# Magento_GoogleOptimizer module

This module implements functionality of Google Experiment tool that is the part of Google Analytics functionality.

## Installation

Before installing this module, note that the Magento_GoogleOptimizer is dependent on the following modules:

- `Magento_GoogleAnalytics`
- `Magento_Catalog`
- `Magento_Cms`
- `Magento_Ui`

For information about a module installation in Magento 2, see [Enable or disable modules](https://devdocs.magento.com/guides/v2.4/install-gde/install/cli/install-cli-subcommands-enable.html).

## Extensibility

Extension developers can interact with the Magento_GoogleOptimizer module. For more information about the Magento extension mechanism, see [Magento plugins](http://devdocs.magento.com/guides/v2.4/extension-dev-guide/plugins.html).

[The Magento dependency injection mechanism](http://devdocs.magento.com/guides/v2.4/extension-dev-guide/depend-inj.html) enables you to override the functionality of the Magento_GoogleOptimizer module.

### Layouts

This module introduces the following layouts in the `view/frontend/layout` and `view/adminhtml/layout` directories:
- `view/adminhtml/layout`:
    - `catalog_product_new`
    - `cms_page_edit`
- `view/frontend/layout`:
    - `catalog_category_view`
    - `catalog_product_view`
    - `cms_page_view`

For more information about a layout in Magento 2, see the [Layout documentation](https://devdocs.magento.com/guides/v2.4/frontend-dev-guide/layouts/layout-overview.html).

### UI components

This module extends following ui components located in the `view/adminhtml/ui_component` directory:
- `category_form`
- `cms_page_form`
- `new_category_form`

For information about a UI component in Magento 2, see [Overview of UI components](http://devdocs.magento.com/guides/v2.4/ui_comp_guide/bk-ui_comps.html).

## Additional information 

Google Experiment (on Google side) allows to make two variants of the same page and compare their popularity.
From Magento side, code generated by Google should be saved and displayed on a particular page.
Google Experiment functionality is available on pages of products, categories and cms pages.
This allows to save different codes for products and categories on different store views.

This functionality can be switched on and off on the configuration page (`Stores -> Configuration -> General -> Google Api -> Google Analytics`).
Also this functionality depends on Google Analytics module and configuration options.

[Learn how to configure Google Content Experiments](https://docs.magento.com/user-guide/marketing/google-content-experiments.html).
