require.config({"config": {
        "jsbuild":{"vimeo/player.js":"/*! @vimeo/player v2.16.4 | (c) 2022 Vimeo | MIT License | https://github.com/vimeo/player.js */\n(function (global, factory) {\n  typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :\n  typeof define === 'function' && define.amd ? define(factory) :\n  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, (global.Vimeo = global.Vimeo || {}, global.Vimeo.Player = factory()));\n}(this, (function () { 'use strict';\n\n  function _classCallCheck(instance, Constructor) {\n    if (!(instance instanceof Constructor)) {\n      throw new TypeError(\"Cannot call a class as a function\");\n    }\n  }\n\n  function _defineProperties(target, props) {\n    for (var i = 0; i < props.length; i++) {\n      var descriptor = props[i];\n      descriptor.enumerable = descriptor.enumerable || false;\n      descriptor.configurable = true;\n      if (\"value\" in descriptor) descriptor.writable = true;\n      Object.defineProperty(target, descriptor.key, descriptor);\n    }\n  }\n\n  function _createClass(Constructor, protoProps, staticProps) {\n    if (protoProps) _defineProperties(Constructor.prototype, protoProps);\n    if (staticProps) _defineProperties(Constructor, staticProps);\n    return Constructor;\n  }\n\n  /**\n   * @module lib/functions\n   */\n\n  /**\n   * Check to see this is a node environment.\n   * @type {Boolean}\n   */\n\n  /* global global */\n  var isNode = typeof global !== 'undefined' && {}.toString.call(global) === '[object global]';\n  /**\n   * Get the name of the method for a given getter or setter.\n   *\n   * @param {string} prop The name of the property.\n   * @param {string} type Either \u201cget\u201d or \u201cset\u201d.\n   * @return {string}\n   */\n\n  function getMethodName(prop, type) {\n    if (prop.indexOf(type.toLowerCase()) === 0) {\n      return prop;\n    }\n\n    return \"\".concat(type.toLowerCase()).concat(prop.substr(0, 1).toUpperCase()).concat(prop.substr(1));\n  }\n  /**\n   * Check to see if the object is a DOM Element.\n   *\n   * @param {*} element The object to check.\n   * @return {boolean}\n   */\n\n  function isDomElement(element) {\n    return Boolean(element && element.nodeType === 1 && 'nodeName' in element && element.ownerDocument && element.ownerDocument.defaultView);\n  }\n  /**\n   * Check to see whether the value is a number.\n   *\n   * @see http://dl.dropboxusercontent.com/u/35146/js/tests/isNumber.html\n   * @param {*} value The value to check.\n   * @param {boolean} integer Check if the value is an integer.\n   * @return {boolean}\n   */\n\n  function isInteger(value) {\n    // eslint-disable-next-line eqeqeq\n    return !isNaN(parseFloat(value)) && isFinite(value) && Math.floor(value) == value;\n  }\n  /**\n   * Check to see if the URL is a Vimeo url.\n   *\n   * @param {string} url The url string.\n   * @return {boolean}\n   */\n\n  function isVimeoUrl(url) {\n    return /^(https?:)?\\/\\/((player|www)\\.)?vimeo\\.com(?=$|\\/)/.test(url);\n  }\n  /**\n   * Get the Vimeo URL from an element.\n   * The element must have either a data-vimeo-id or data-vimeo-url attribute.\n   *\n   * @param {object} oEmbedParameters The oEmbed parameters.\n   * @return {string}\n   */\n\n  function getVimeoUrl() {\n    var oEmbedParameters = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n    var id = oEmbedParameters.id;\n    var url = oEmbedParameters.url;\n    var idOrUrl = id || url;\n\n    if (!idOrUrl) {\n      throw new Error('An id or url must be passed, either in an options object or as a data-vimeo-id or data-vimeo-url attribute.');\n    }\n\n    if (isInteger(idOrUrl)) {\n      return \"https://vimeo.com/\".concat(idOrUrl);\n    }\n\n    if (isVimeoUrl(idOrUrl)) {\n      return idOrUrl.replace('http:', 'https:');\n    }\n\n    if (id) {\n      throw new TypeError(\"\\u201C\".concat(id, \"\\u201D is not a valid video id.\"));\n    }\n\n    throw new TypeError(\"\\u201C\".concat(idOrUrl, \"\\u201D is not a vimeo.com url.\"));\n  }\n\n  var arrayIndexOfSupport = typeof Array.prototype.indexOf !== 'undefined';\n  var postMessageSupport = typeof window !== 'undefined' && typeof window.postMessage !== 'undefined';\n\n  if (!isNode && (!arrayIndexOfSupport || !postMessageSupport)) {\n    throw new Error('Sorry, the Vimeo Player API is not available in this browser.');\n  }\n\n  var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};\n\n  function createCommonjsModule(fn, module) {\n  \treturn module = { exports: {} }, fn(module, module.exports), module.exports;\n  }\n\n  /*!\n   * weakmap-polyfill v2.0.1 - ECMAScript6 WeakMap polyfill\n   * https://github.com/polygonplanet/weakmap-polyfill\n   * Copyright (c) 2015-2020 Polygon Planet <polygon.planet.aqua@gmail.com>\n   * @license MIT\n   */\n  (function (self) {\n\n    if (self.WeakMap) {\n      return;\n    }\n\n    var hasOwnProperty = Object.prototype.hasOwnProperty;\n\n    var defineProperty = function (object, name, value) {\n      if (Object.defineProperty) {\n        Object.defineProperty(object, name, {\n          configurable: true,\n          writable: true,\n          value: value\n        });\n      } else {\n        object[name] = value;\n      }\n    };\n\n    self.WeakMap = function () {\n      // ECMA-262 23.3 WeakMap Objects\n      function WeakMap() {\n        if (this === void 0) {\n          throw new TypeError(\"Constructor WeakMap requires 'new'\");\n        }\n\n        defineProperty(this, '_id', genId('_WeakMap')); // ECMA-262 23.3.1.1 WeakMap([iterable])\n\n        if (arguments.length > 0) {\n          // Currently, WeakMap `iterable` argument is not supported\n          throw new TypeError('WeakMap iterable is not supported');\n        }\n      } // ECMA-262 23.3.3.2 WeakMap.prototype.delete(key)\n\n\n      defineProperty(WeakMap.prototype, 'delete', function (key) {\n        checkInstance(this, 'delete');\n\n        if (!isObject(key)) {\n          return false;\n        }\n\n        var entry = key[this._id];\n\n        if (entry && entry[0] === key) {\n          delete key[this._id];\n          return true;\n        }\n\n        return false;\n      }); // ECMA-262 23.3.3.3 WeakMap.prototype.get(key)\n\n      defineProperty(WeakMap.prototype, 'get', function (key) {\n        checkInstance(this, 'get');\n\n        if (!isObject(key)) {\n          return void 0;\n        }\n\n        var entry = key[this._id];\n\n        if (entry && entry[0] === key) {\n          return entry[1];\n        }\n\n        return void 0;\n      }); // ECMA-262 23.3.3.4 WeakMap.prototype.has(key)\n\n      defineProperty(WeakMap.prototype, 'has', function (key) {\n        checkInstance(this, 'has');\n\n        if (!isObject(key)) {\n          return false;\n        }\n\n        var entry = key[this._id];\n\n        if (entry && entry[0] === key) {\n          return true;\n        }\n\n        return false;\n      }); // ECMA-262 23.3.3.5 WeakMap.prototype.set(key, value)\n\n      defineProperty(WeakMap.prototype, 'set', function (key, value) {\n        checkInstance(this, 'set');\n\n        if (!isObject(key)) {\n          throw new TypeError('Invalid value used as weak map key');\n        }\n\n        var entry = key[this._id];\n\n        if (entry && entry[0] === key) {\n          entry[1] = value;\n          return this;\n        }\n\n        defineProperty(key, this._id, [key, value]);\n        return this;\n      });\n\n      function checkInstance(x, methodName) {\n        if (!isObject(x) || !hasOwnProperty.call(x, '_id')) {\n          throw new TypeError(methodName + ' method called on incompatible receiver ' + typeof x);\n        }\n      }\n\n      function genId(prefix) {\n        return prefix + '_' + rand() + '.' + rand();\n      }\n\n      function rand() {\n        return Math.random().toString().substring(2);\n      }\n\n      defineProperty(WeakMap, '_polyfill', true);\n      return WeakMap;\n    }();\n\n    function isObject(x) {\n      return Object(x) === x;\n    }\n  })(typeof self !== 'undefined' ? self : typeof window !== 'undefined' ? window : typeof commonjsGlobal !== 'undefined' ? commonjsGlobal : commonjsGlobal);\n\n  var npo_src = createCommonjsModule(function (module) {\n  /*! Native Promise Only\n      v0.8.1 (c) Kyle Simpson\n      MIT License: http://getify.mit-license.org\n  */\n  (function UMD(name, context, definition) {\n    // special form of UMD for polyfilling across evironments\n    context[name] = context[name] || definition();\n\n    if (module.exports) {\n      module.exports = context[name];\n    }\n  })(\"Promise\", typeof commonjsGlobal != \"undefined\" ? commonjsGlobal : commonjsGlobal, function DEF() {\n\n    var builtInProp,\n        cycle,\n        scheduling_queue,\n        ToString = Object.prototype.toString,\n        timer = typeof setImmediate != \"undefined\" ? function timer(fn) {\n      return setImmediate(fn);\n    } : setTimeout; // dammit, IE8.\n\n    try {\n      Object.defineProperty({}, \"x\", {});\n\n      builtInProp = function builtInProp(obj, name, val, config) {\n        return Object.defineProperty(obj, name, {\n          value: val,\n          writable: true,\n          configurable: config !== false\n        });\n      };\n    } catch (err) {\n      builtInProp = function builtInProp(obj, name, val) {\n        obj[name] = val;\n        return obj;\n      };\n    } // Note: using a queue instead of array for efficiency\n\n\n    scheduling_queue = function Queue() {\n      var first, last, item;\n\n      function Item(fn, self) {\n        this.fn = fn;\n        this.self = self;\n        this.next = void 0;\n      }\n\n      return {\n        add: function add(fn, self) {\n          item = new Item(fn, self);\n\n          if (last) {\n            last.next = item;\n          } else {\n            first = item;\n          }\n\n          last = item;\n          item = void 0;\n        },\n        drain: function drain() {\n          var f = first;\n          first = last = cycle = void 0;\n\n          while (f) {\n            f.fn.call(f.self);\n            f = f.next;\n          }\n        }\n      };\n    }();\n\n    function schedule(fn, self) {\n      scheduling_queue.add(fn, self);\n\n      if (!cycle) {\n        cycle = timer(scheduling_queue.drain);\n      }\n    } // promise duck typing\n\n\n    function isThenable(o) {\n      var _then,\n          o_type = typeof o;\n\n      if (o != null && (o_type == \"object\" || o_type == \"function\")) {\n        _then = o.then;\n      }\n\n      return typeof _then == \"function\" ? _then : false;\n    }\n\n    function notify() {\n      for (var i = 0; i < this.chain.length; i++) {\n        notifyIsolated(this, this.state === 1 ? this.chain[i].success : this.chain[i].failure, this.chain[i]);\n      }\n\n      this.chain.length = 0;\n    } // NOTE: This is a separate function to isolate\n    // the `try..catch` so that other code can be\n    // optimized better\n\n\n    function notifyIsolated(self, cb, chain) {\n      var ret, _then;\n\n      try {\n        if (cb === false) {\n          chain.reject(self.msg);\n        } else {\n          if (cb === true) {\n            ret = self.msg;\n          } else {\n            ret = cb.call(void 0, self.msg);\n          }\n\n          if (ret === chain.promise) {\n            chain.reject(TypeError(\"Promise-chain cycle\"));\n          } else if (_then = isThenable(ret)) {\n            _then.call(ret, chain.resolve, chain.reject);\n          } else {\n            chain.resolve(ret);\n          }\n        }\n      } catch (err) {\n        chain.reject(err);\n      }\n    }\n\n    function resolve(msg) {\n      var _then,\n          self = this; // already triggered?\n\n\n      if (self.triggered) {\n        return;\n      }\n\n      self.triggered = true; // unwrap\n\n      if (self.def) {\n        self = self.def;\n      }\n\n      try {\n        if (_then = isThenable(msg)) {\n          schedule(function () {\n            var def_wrapper = new MakeDefWrapper(self);\n\n            try {\n              _then.call(msg, function $resolve$() {\n                resolve.apply(def_wrapper, arguments);\n              }, function $reject$() {\n                reject.apply(def_wrapper, arguments);\n              });\n            } catch (err) {\n              reject.call(def_wrapper, err);\n            }\n          });\n        } else {\n          self.msg = msg;\n          self.state = 1;\n\n          if (self.chain.length > 0) {\n            schedule(notify, self);\n          }\n        }\n      } catch (err) {\n        reject.call(new MakeDefWrapper(self), err);\n      }\n    }\n\n    function reject(msg) {\n      var self = this; // already triggered?\n\n      if (self.triggered) {\n        return;\n      }\n\n      self.triggered = true; // unwrap\n\n      if (self.def) {\n        self = self.def;\n      }\n\n      self.msg = msg;\n      self.state = 2;\n\n      if (self.chain.length > 0) {\n        schedule(notify, self);\n      }\n    }\n\n    function iteratePromises(Constructor, arr, resolver, rejecter) {\n      for (var idx = 0; idx < arr.length; idx++) {\n        (function IIFE(idx) {\n          Constructor.resolve(arr[idx]).then(function $resolver$(msg) {\n            resolver(idx, msg);\n          }, rejecter);\n        })(idx);\n      }\n    }\n\n    function MakeDefWrapper(self) {\n      this.def = self;\n      this.triggered = false;\n    }\n\n    function MakeDef(self) {\n      this.promise = self;\n      this.state = 0;\n      this.triggered = false;\n      this.chain = [];\n      this.msg = void 0;\n    }\n\n    function Promise(executor) {\n      if (typeof executor != \"function\") {\n        throw TypeError(\"Not a function\");\n      }\n\n      if (this.__NPO__ !== 0) {\n        throw TypeError(\"Not a promise\");\n      } // instance shadowing the inherited \"brand\"\n      // to signal an already \"initialized\" promise\n\n\n      this.__NPO__ = 1;\n      var def = new MakeDef(this);\n\n      this[\"then\"] = function then(success, failure) {\n        var o = {\n          success: typeof success == \"function\" ? success : true,\n          failure: typeof failure == \"function\" ? failure : false\n        }; // Note: `then(..)` itself can be borrowed to be used against\n        // a different promise constructor for making the chained promise,\n        // by substituting a different `this` binding.\n\n        o.promise = new this.constructor(function extractChain(resolve, reject) {\n          if (typeof resolve != \"function\" || typeof reject != \"function\") {\n            throw TypeError(\"Not a function\");\n          }\n\n          o.resolve = resolve;\n          o.reject = reject;\n        });\n        def.chain.push(o);\n\n        if (def.state !== 0) {\n          schedule(notify, def);\n        }\n\n        return o.promise;\n      };\n\n      this[\"catch\"] = function $catch$(failure) {\n        return this.then(void 0, failure);\n      };\n\n      try {\n        executor.call(void 0, function publicResolve(msg) {\n          resolve.call(def, msg);\n        }, function publicReject(msg) {\n          reject.call(def, msg);\n        });\n      } catch (err) {\n        reject.call(def, err);\n      }\n    }\n\n    var PromisePrototype = builtInProp({}, \"constructor\", Promise,\n    /*configurable=*/\n    false); // Note: Android 4 cannot use `Object.defineProperty(..)` here\n\n    Promise.prototype = PromisePrototype; // built-in \"brand\" to signal an \"uninitialized\" promise\n\n    builtInProp(PromisePrototype, \"__NPO__\", 0,\n    /*configurable=*/\n    false);\n    builtInProp(Promise, \"resolve\", function Promise$resolve(msg) {\n      var Constructor = this; // spec mandated checks\n      // note: best \"isPromise\" check that's practical for now\n\n      if (msg && typeof msg == \"object\" && msg.__NPO__ === 1) {\n        return msg;\n      }\n\n      return new Constructor(function executor(resolve, reject) {\n        if (typeof resolve != \"function\" || typeof reject != \"function\") {\n          throw TypeError(\"Not a function\");\n        }\n\n        resolve(msg);\n      });\n    });\n    builtInProp(Promise, \"reject\", function Promise$reject(msg) {\n      return new this(function executor(resolve, reject) {\n        if (typeof resolve != \"function\" || typeof reject != \"function\") {\n          throw TypeError(\"Not a function\");\n        }\n\n        reject(msg);\n      });\n    });\n    builtInProp(Promise, \"all\", function Promise$all(arr) {\n      var Constructor = this; // spec mandated checks\n\n      if (ToString.call(arr) != \"[object Array]\") {\n        return Constructor.reject(TypeError(\"Not an array\"));\n      }\n\n      if (arr.length === 0) {\n        return Constructor.resolve([]);\n      }\n\n      return new Constructor(function executor(resolve, reject) {\n        if (typeof resolve != \"function\" || typeof reject != \"function\") {\n          throw TypeError(\"Not a function\");\n        }\n\n        var len = arr.length,\n            msgs = Array(len),\n            count = 0;\n        iteratePromises(Constructor, arr, function resolver(idx, msg) {\n          msgs[idx] = msg;\n\n          if (++count === len) {\n            resolve(msgs);\n          }\n        }, reject);\n      });\n    });\n    builtInProp(Promise, \"race\", function Promise$race(arr) {\n      var Constructor = this; // spec mandated checks\n\n      if (ToString.call(arr) != \"[object Array]\") {\n        return Constructor.reject(TypeError(\"Not an array\"));\n      }\n\n      return new Constructor(function executor(resolve, reject) {\n        if (typeof resolve != \"function\" || typeof reject != \"function\") {\n          throw TypeError(\"Not a function\");\n        }\n\n        iteratePromises(Constructor, arr, function resolver(idx, msg) {\n          resolve(msg);\n        }, reject);\n      });\n    });\n    return Promise;\n  });\n  });\n\n  /**\n   * @module lib/callbacks\n   */\n  var callbackMap = new WeakMap();\n  /**\n   * Store a callback for a method or event for a player.\n   *\n   * @param {Player} player The player object.\n   * @param {string} name The method or event name.\n   * @param {(function(this:Player, *): void|{resolve: function, reject: function})} callback\n   *        The callback to call or an object with resolve and reject functions for a promise.\n   * @return {void}\n   */\n\n  function storeCallback(player, name, callback) {\n    var playerCallbacks = callbackMap.get(player.element) || {};\n\n    if (!(name in playerCallbacks)) {\n      playerCallbacks[name] = [];\n    }\n\n    playerCallbacks[name].push(callback);\n    callbackMap.set(player.element, playerCallbacks);\n  }\n  /**\n   * Get the callbacks for a player and event or method.\n   *\n   * @param {Player} player The player object.\n   * @param {string} name The method or event name\n   * @return {function[]}\n   */\n\n  function getCallbacks(player, name) {\n    var playerCallbacks = callbackMap.get(player.element) || {};\n    return playerCallbacks[name] || [];\n  }\n  /**\n   * Remove a stored callback for a method or event for a player.\n   *\n   * @param {Player} player The player object.\n   * @param {string} name The method or event name\n   * @param {function} [callback] The specific callback to remove.\n   * @return {boolean} Was this the last callback?\n   */\n\n  function removeCallback(player, name, callback) {\n    var playerCallbacks = callbackMap.get(player.element) || {};\n\n    if (!playerCallbacks[name]) {\n      return true;\n    } // If no callback is passed, remove all callbacks for the event\n\n\n    if (!callback) {\n      playerCallbacks[name] = [];\n      callbackMap.set(player.element, playerCallbacks);\n      return true;\n    }\n\n    var index = playerCallbacks[name].indexOf(callback);\n\n    if (index !== -1) {\n      playerCallbacks[name].splice(index, 1);\n    }\n\n    callbackMap.set(player.element, playerCallbacks);\n    return playerCallbacks[name] && playerCallbacks[name].length === 0;\n  }\n  /**\n   * Return the first stored callback for a player and event or method.\n   *\n   * @param {Player} player The player object.\n   * @param {string} name The method or event name.\n   * @return {function} The callback, or false if there were none\n   */\n\n  function shiftCallbacks(player, name) {\n    var playerCallbacks = getCallbacks(player, name);\n\n    if (playerCallbacks.length < 1) {\n      return false;\n    }\n\n    var callback = playerCallbacks.shift();\n    removeCallback(player, name, callback);\n    return callback;\n  }\n  /**\n   * Move callbacks associated with an element to another element.\n   *\n   * @param {HTMLElement} oldElement The old element.\n   * @param {HTMLElement} newElement The new element.\n   * @return {void}\n   */\n\n  function swapCallbacks(oldElement, newElement) {\n    var playerCallbacks = callbackMap.get(oldElement);\n    callbackMap.set(newElement, playerCallbacks);\n    callbackMap.delete(oldElement);\n  }\n\n  /**\n   * @module lib/embed\n   */\n  var oEmbedParameters = ['autopause', 'autoplay', 'background', 'byline', 'color', 'controls', 'dnt', 'height', 'id', 'interactive_params', 'keyboard', 'loop', 'maxheight', 'maxwidth', 'muted', 'playsinline', 'portrait', 'responsive', 'speed', 'texttrack', 'title', 'transparent', 'url', 'width'];\n  /**\n   * Get the 'data-vimeo'-prefixed attributes from an element as an object.\n   *\n   * @param {HTMLElement} element The element.\n   * @param {Object} [defaults={}] The default values to use.\n   * @return {Object<string, string>}\n   */\n\n  function getOEmbedParameters(element) {\n    var defaults = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};\n    return oEmbedParameters.reduce(function (params, param) {\n      var value = element.getAttribute(\"data-vimeo-\".concat(param));\n\n      if (value || value === '') {\n        params[param] = value === '' ? 1 : value;\n      }\n\n      return params;\n    }, defaults);\n  }\n  /**\n   * Create an embed from oEmbed data inside an element.\n   *\n   * @param {object} data The oEmbed data.\n   * @param {HTMLElement} element The element to put the iframe in.\n   * @return {HTMLIFrameElement} The iframe embed.\n   */\n\n  function createEmbed(_ref, element) {\n    var html = _ref.html;\n\n    if (!element) {\n      throw new TypeError('An element must be provided');\n    }\n\n    if (element.getAttribute('data-vimeo-initialized') !== null) {\n      return element.querySelector('iframe');\n    }\n\n    var div = document.createElement('div');\n    div.innerHTML = html;\n    element.appendChild(div.firstChild);\n    element.setAttribute('data-vimeo-initialized', 'true');\n    return element.querySelector('iframe');\n  }\n  /**\n   * Make an oEmbed call for the specified URL.\n   *\n   * @param {string} videoUrl The vimeo.com url for the video.\n   * @param {Object} [params] Parameters to pass to oEmbed.\n   * @param {HTMLElement} element The element.\n   * @return {Promise}\n   */\n\n  function getOEmbedData(videoUrl) {\n    var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};\n    var element = arguments.length > 2 ? arguments[2] : undefined;\n    return new Promise(function (resolve, reject) {\n      if (!isVimeoUrl(videoUrl)) {\n        throw new TypeError(\"\\u201C\".concat(videoUrl, \"\\u201D is not a vimeo.com url.\"));\n      }\n\n      var url = \"https://vimeo.com/api/oembed.json?url=\".concat(encodeURIComponent(videoUrl));\n\n      for (var param in params) {\n        if (params.hasOwnProperty(param)) {\n          url += \"&\".concat(param, \"=\").concat(encodeURIComponent(params[param]));\n        }\n      }\n\n      var xhr = 'XDomainRequest' in window ? new XDomainRequest() : new XMLHttpRequest();\n      xhr.open('GET', url, true);\n\n      xhr.onload = function () {\n        if (xhr.status === 404) {\n          reject(new Error(\"\\u201C\".concat(videoUrl, \"\\u201D was not found.\")));\n          return;\n        }\n\n        if (xhr.status === 403) {\n          reject(new Error(\"\\u201C\".concat(videoUrl, \"\\u201D is not embeddable.\")));\n          return;\n        }\n\n        try {\n          var json = JSON.parse(xhr.responseText); // Check api response for 403 on oembed\n\n          if (json.domain_status_code === 403) {\n            // We still want to create the embed to give users visual feedback\n            createEmbed(json, element);\n            reject(new Error(\"\\u201C\".concat(videoUrl, \"\\u201D is not embeddable.\")));\n            return;\n          }\n\n          resolve(json);\n        } catch (error) {\n          reject(error);\n        }\n      };\n\n      xhr.onerror = function () {\n        var status = xhr.status ? \" (\".concat(xhr.status, \")\") : '';\n        reject(new Error(\"There was an error fetching the embed code from Vimeo\".concat(status, \".\")));\n      };\n\n      xhr.send();\n    });\n  }\n  /**\n   * Initialize all embeds within a specific element\n   *\n   * @param {HTMLElement} [parent=document] The parent element.\n   * @return {void}\n   */\n\n  function initializeEmbeds() {\n    var parent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : document;\n    var elements = [].slice.call(parent.querySelectorAll('[data-vimeo-id], [data-vimeo-url]'));\n\n    var handleError = function handleError(error) {\n      if ('console' in window && console.error) {\n        console.error(\"There was an error creating an embed: \".concat(error));\n      }\n    };\n\n    elements.forEach(function (element) {\n      try {\n        // Skip any that have data-vimeo-defer\n        if (element.getAttribute('data-vimeo-defer') !== null) {\n          return;\n        }\n\n        var params = getOEmbedParameters(element);\n        var url = getVimeoUrl(params);\n        getOEmbedData(url, params, element).then(function (data) {\n          return createEmbed(data, element);\n        }).catch(handleError);\n      } catch (error) {\n        handleError(error);\n      }\n    });\n  }\n  /**\n   * Resize embeds when messaged by the player.\n   *\n   * @param {HTMLElement} [parent=document] The parent element.\n   * @return {void}\n   */\n\n  function resizeEmbeds() {\n    var parent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : document;\n\n    // Prevent execution if users include the player.js script multiple times.\n    if (window.VimeoPlayerResizeEmbeds_) {\n      return;\n    }\n\n    window.VimeoPlayerResizeEmbeds_ = true;\n\n    var onMessage = function onMessage(event) {\n      if (!isVimeoUrl(event.origin)) {\n        return;\n      } // 'spacechange' is fired only on embeds with cards\n\n\n      if (!event.data || event.data.event !== 'spacechange') {\n        return;\n      }\n\n      var iframes = parent.querySelectorAll('iframe');\n\n      for (var i = 0; i < iframes.length; i++) {\n        if (iframes[i].contentWindow !== event.source) {\n          continue;\n        } // Change padding-bottom of the enclosing div to accommodate\n        // card carousel without distorting aspect ratio\n\n\n        var space = iframes[i].parentElement;\n        space.style.paddingBottom = \"\".concat(event.data.data[0].bottom, \"px\");\n        break;\n      }\n    };\n\n    window.addEventListener('message', onMessage);\n  }\n\n  /**\n   * @module lib/postmessage\n   */\n  /**\n   * Parse a message received from postMessage.\n   *\n   * @param {*} data The data received from postMessage.\n   * @return {object}\n   */\n\n  function parseMessageData(data) {\n    if (typeof data === 'string') {\n      try {\n        data = JSON.parse(data);\n      } catch (error) {\n        // If the message cannot be parsed, throw the error as a warning\n        console.warn(error);\n        return {};\n      }\n    }\n\n    return data;\n  }\n  /**\n   * Post a message to the specified target.\n   *\n   * @param {Player} player The player object to use.\n   * @param {string} method The API method to call.\n   * @param {object} params The parameters to send to the player.\n   * @return {void}\n   */\n\n  function postMessage(player, method, params) {\n    if (!player.element.contentWindow || !player.element.contentWindow.postMessage) {\n      return;\n    }\n\n    var message = {\n      method: method\n    };\n\n    if (params !== undefined) {\n      message.value = params;\n    } // IE 8 and 9 do not support passing messages, so stringify them\n\n\n    var ieVersion = parseFloat(navigator.userAgent.toLowerCase().replace(/^.*msie (\\d+).*$/, '$1'));\n\n    if (ieVersion >= 8 && ieVersion < 10) {\n      message = JSON.stringify(message);\n    }\n\n    player.element.contentWindow.postMessage(message, player.origin);\n  }\n  /**\n   * Parse the data received from a message event.\n   *\n   * @param {Player} player The player that received the message.\n   * @param {(Object|string)} data The message data. Strings will be parsed into JSON.\n   * @return {void}\n   */\n\n  function processData(player, data) {\n    data = parseMessageData(data);\n    var callbacks = [];\n    var param;\n\n    if (data.event) {\n      if (data.event === 'error') {\n        var promises = getCallbacks(player, data.data.method);\n        promises.forEach(function (promise) {\n          var error = new Error(data.data.message);\n          error.name = data.data.name;\n          promise.reject(error);\n          removeCallback(player, data.data.method, promise);\n        });\n      }\n\n      callbacks = getCallbacks(player, \"event:\".concat(data.event));\n      param = data.data;\n    } else if (data.method) {\n      var callback = shiftCallbacks(player, data.method);\n\n      if (callback) {\n        callbacks.push(callback);\n        param = data.value;\n      }\n    }\n\n    callbacks.forEach(function (callback) {\n      try {\n        if (typeof callback === 'function') {\n          callback.call(player, param);\n          return;\n        }\n\n        callback.resolve(param);\n      } catch (e) {// empty\n      }\n    });\n  }\n\n  /* MIT License\n\n  Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)\n\n  Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the \"Software\"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:\n\n  The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.\n\n  THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.\n  Terms */\n  function initializeScreenfull() {\n    var fn = function () {\n      var val;\n      var fnMap = [['requestFullscreen', 'exitFullscreen', 'fullscreenElement', 'fullscreenEnabled', 'fullscreenchange', 'fullscreenerror'], // New WebKit\n      ['webkitRequestFullscreen', 'webkitExitFullscreen', 'webkitFullscreenElement', 'webkitFullscreenEnabled', 'webkitfullscreenchange', 'webkitfullscreenerror'], // Old WebKit\n      ['webkitRequestFullScreen', 'webkitCancelFullScreen', 'webkitCurrentFullScreenElement', 'webkitCancelFullScreen', 'webkitfullscreenchange', 'webkitfullscreenerror'], ['mozRequestFullScreen', 'mozCancelFullScreen', 'mozFullScreenElement', 'mozFullScreenEnabled', 'mozfullscreenchange', 'mozfullscreenerror'], ['msRequestFullscreen', 'msExitFullscreen', 'msFullscreenElement', 'msFullscreenEnabled', 'MSFullscreenChange', 'MSFullscreenError']];\n      var i = 0;\n      var l = fnMap.length;\n      var ret = {};\n\n      for (; i < l; i++) {\n        val = fnMap[i];\n\n        if (val && val[1] in document) {\n          for (i = 0; i < val.length; i++) {\n            ret[fnMap[0][i]] = val[i];\n          }\n\n          return ret;\n        }\n      }\n\n      return false;\n    }();\n\n    var eventNameMap = {\n      fullscreenchange: fn.fullscreenchange,\n      fullscreenerror: fn.fullscreenerror\n    };\n    var screenfull = {\n      request: function request(element) {\n        return new Promise(function (resolve, reject) {\n          var onFullScreenEntered = function onFullScreenEntered() {\n            screenfull.off('fullscreenchange', onFullScreenEntered);\n            resolve();\n          };\n\n          screenfull.on('fullscreenchange', onFullScreenEntered);\n          element = element || document.documentElement;\n          var returnPromise = element[fn.requestFullscreen]();\n\n          if (returnPromise instanceof Promise) {\n            returnPromise.then(onFullScreenEntered).catch(reject);\n          }\n        });\n      },\n      exit: function exit() {\n        return new Promise(function (resolve, reject) {\n          if (!screenfull.isFullscreen) {\n            resolve();\n            return;\n          }\n\n          var onFullScreenExit = function onFullScreenExit() {\n            screenfull.off('fullscreenchange', onFullScreenExit);\n            resolve();\n          };\n\n          screenfull.on('fullscreenchange', onFullScreenExit);\n          var returnPromise = document[fn.exitFullscreen]();\n\n          if (returnPromise instanceof Promise) {\n            returnPromise.then(onFullScreenExit).catch(reject);\n          }\n        });\n      },\n      on: function on(event, callback) {\n        var eventName = eventNameMap[event];\n\n        if (eventName) {\n          document.addEventListener(eventName, callback);\n        }\n      },\n      off: function off(event, callback) {\n        var eventName = eventNameMap[event];\n\n        if (eventName) {\n          document.removeEventListener(eventName, callback);\n        }\n      }\n    };\n    Object.defineProperties(screenfull, {\n      isFullscreen: {\n        get: function get() {\n          return Boolean(document[fn.fullscreenElement]);\n        }\n      },\n      element: {\n        enumerable: true,\n        get: function get() {\n          return document[fn.fullscreenElement];\n        }\n      },\n      isEnabled: {\n        enumerable: true,\n        get: function get() {\n          // Coerce to boolean in case of old WebKit\n          return Boolean(document[fn.fullscreenEnabled]);\n        }\n      }\n    });\n    return screenfull;\n  }\n\n  var playerMap = new WeakMap();\n  var readyMap = new WeakMap();\n  var screenfull = {};\n\n  var Player = /*#__PURE__*/function () {\n    /**\n     * Create a Player.\n     *\n     * @param {(HTMLIFrameElement|HTMLElement|string|jQuery)} element A reference to the Vimeo\n     *        player iframe, and id, or a jQuery object.\n     * @param {object} [options] oEmbed parameters to use when creating an embed in the element.\n     * @return {Player}\n     */\n    function Player(element) {\n      var _this = this;\n\n      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};\n\n      _classCallCheck(this, Player);\n\n      /* global jQuery */\n      if (window.jQuery && element instanceof jQuery) {\n        if (element.length > 1 && window.console && console.warn) {\n          console.warn('A jQuery object with multiple elements was passed, using the first element.');\n        }\n\n        element = element[0];\n      } // Find an element by ID\n\n\n      if (typeof document !== 'undefined' && typeof element === 'string') {\n        element = document.getElementById(element);\n      } // Not an element!\n\n\n      if (!isDomElement(element)) {\n        throw new TypeError('You must pass either a valid element or a valid id.');\n      } // Already initialized an embed in this div, so grab the iframe\n\n\n      if (element.nodeName !== 'IFRAME') {\n        var iframe = element.querySelector('iframe');\n\n        if (iframe) {\n          element = iframe;\n        }\n      } // iframe url is not a Vimeo url\n\n\n      if (element.nodeName === 'IFRAME' && !isVimeoUrl(element.getAttribute('src') || '')) {\n        throw new Error('The player element passed isn\u2019t a Vimeo embed.');\n      } // If there is already a player object in the map, return that\n\n\n      if (playerMap.has(element)) {\n        return playerMap.get(element);\n      }\n\n      this._window = element.ownerDocument.defaultView;\n      this.element = element;\n      this.origin = '*';\n      var readyPromise = new npo_src(function (resolve, reject) {\n        _this._onMessage = function (event) {\n          if (!isVimeoUrl(event.origin) || _this.element.contentWindow !== event.source) {\n            return;\n          }\n\n          if (_this.origin === '*') {\n            _this.origin = event.origin;\n          }\n\n          var data = parseMessageData(event.data);\n          var isError = data && data.event === 'error';\n          var isReadyError = isError && data.data && data.data.method === 'ready';\n\n          if (isReadyError) {\n            var error = new Error(data.data.message);\n            error.name = data.data.name;\n            reject(error);\n            return;\n          }\n\n          var isReadyEvent = data && data.event === 'ready';\n          var isPingResponse = data && data.method === 'ping';\n\n          if (isReadyEvent || isPingResponse) {\n            _this.element.setAttribute('data-ready', 'true');\n\n            resolve();\n            return;\n          }\n\n          processData(_this, data);\n        };\n\n        _this._window.addEventListener('message', _this._onMessage);\n\n        if (_this.element.nodeName !== 'IFRAME') {\n          var params = getOEmbedParameters(element, options);\n          var url = getVimeoUrl(params);\n          getOEmbedData(url, params, element).then(function (data) {\n            var iframe = createEmbed(data, element); // Overwrite element with the new iframe,\n            // but store reference to the original element\n\n            _this.element = iframe;\n            _this._originalElement = element;\n            swapCallbacks(element, iframe);\n            playerMap.set(_this.element, _this);\n            return data;\n          }).catch(reject);\n        }\n      }); // Store a copy of this Player in the map\n\n      readyMap.set(this, readyPromise);\n      playerMap.set(this.element, this); // Send a ping to the iframe so the ready promise will be resolved if\n      // the player is already ready.\n\n      if (this.element.nodeName === 'IFRAME') {\n        postMessage(this, 'ping');\n      }\n\n      if (screenfull.isEnabled) {\n        var exitFullscreen = function exitFullscreen() {\n          return screenfull.exit();\n        };\n\n        this.fullscreenchangeHandler = function () {\n          if (screenfull.isFullscreen) {\n            storeCallback(_this, 'event:exitFullscreen', exitFullscreen);\n          } else {\n            removeCallback(_this, 'event:exitFullscreen', exitFullscreen);\n          } // eslint-disable-next-line\n\n\n          _this.ready().then(function () {\n            postMessage(_this, 'fullscreenchange', screenfull.isFullscreen);\n          });\n        };\n\n        screenfull.on('fullscreenchange', this.fullscreenchangeHandler);\n      }\n\n      return this;\n    }\n    /**\n     * Get a promise for a method.\n     *\n     * @param {string} name The API method to call.\n     * @param {Object} [args={}] Arguments to send via postMessage.\n     * @return {Promise}\n     */\n\n\n    _createClass(Player, [{\n      key: \"callMethod\",\n      value: function callMethod(name) {\n        var _this2 = this;\n\n        var args = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};\n        return new npo_src(function (resolve, reject) {\n          // We are storing the resolve/reject handlers to call later, so we\n          // can\u2019t return here.\n          // eslint-disable-next-line promise/always-return\n          return _this2.ready().then(function () {\n            storeCallback(_this2, name, {\n              resolve: resolve,\n              reject: reject\n            });\n            postMessage(_this2, name, args);\n          }).catch(reject);\n        });\n      }\n      /**\n       * Get a promise for the value of a player property.\n       *\n       * @param {string} name The property name\n       * @return {Promise}\n       */\n\n    }, {\n      key: \"get\",\n      value: function get(name) {\n        var _this3 = this;\n\n        return new npo_src(function (resolve, reject) {\n          name = getMethodName(name, 'get'); // We are storing the resolve/reject handlers to call later, so we\n          // can\u2019t return here.\n          // eslint-disable-next-line promise/always-return\n\n          return _this3.ready().then(function () {\n            storeCallback(_this3, name, {\n              resolve: resolve,\n              reject: reject\n            });\n            postMessage(_this3, name);\n          }).catch(reject);\n        });\n      }\n      /**\n       * Get a promise for setting the value of a player property.\n       *\n       * @param {string} name The API method to call.\n       * @param {mixed} value The value to set.\n       * @return {Promise}\n       */\n\n    }, {\n      key: \"set\",\n      value: function set(name, value) {\n        var _this4 = this;\n\n        return new npo_src(function (resolve, reject) {\n          name = getMethodName(name, 'set');\n\n          if (value === undefined || value === null) {\n            throw new TypeError('There must be a value to set.');\n          } // We are storing the resolve/reject handlers to call later, so we\n          // can\u2019t return here.\n          // eslint-disable-next-line promise/always-return\n\n\n          return _this4.ready().then(function () {\n            storeCallback(_this4, name, {\n              resolve: resolve,\n              reject: reject\n            });\n            postMessage(_this4, name, value);\n          }).catch(reject);\n        });\n      }\n      /**\n       * Add an event listener for the specified event. Will call the\n       * callback with a single parameter, `data`, that contains the data for\n       * that event.\n       *\n       * @param {string} eventName The name of the event.\n       * @param {function(*)} callback The function to call when the event fires.\n       * @return {void}\n       */\n\n    }, {\n      key: \"on\",\n      value: function on(eventName, callback) {\n        if (!eventName) {\n          throw new TypeError('You must pass an event name.');\n        }\n\n        if (!callback) {\n          throw new TypeError('You must pass a callback function.');\n        }\n\n        if (typeof callback !== 'function') {\n          throw new TypeError('The callback must be a function.');\n        }\n\n        var callbacks = getCallbacks(this, \"event:\".concat(eventName));\n\n        if (callbacks.length === 0) {\n          this.callMethod('addEventListener', eventName).catch(function () {// Ignore the error. There will be an error event fired that\n            // will trigger the error callback if they are listening.\n          });\n        }\n\n        storeCallback(this, \"event:\".concat(eventName), callback);\n      }\n      /**\n       * Remove an event listener for the specified event. Will remove all\n       * listeners for that event if a `callback` isn\u2019t passed, or only that\n       * specific callback if it is passed.\n       *\n       * @param {string} eventName The name of the event.\n       * @param {function} [callback] The specific callback to remove.\n       * @return {void}\n       */\n\n    }, {\n      key: \"off\",\n      value: function off(eventName, callback) {\n        if (!eventName) {\n          throw new TypeError('You must pass an event name.');\n        }\n\n        if (callback && typeof callback !== 'function') {\n          throw new TypeError('The callback must be a function.');\n        }\n\n        var lastCallback = removeCallback(this, \"event:\".concat(eventName), callback); // If there are no callbacks left, remove the listener\n\n        if (lastCallback) {\n          this.callMethod('removeEventListener', eventName).catch(function (e) {// Ignore the error. There will be an error event fired that\n            // will trigger the error callback if they are listening.\n          });\n        }\n      }\n      /**\n       * A promise to load a new video.\n       *\n       * @promise LoadVideoPromise\n       * @fulfill {number} The video with this id or url successfully loaded.\n       * @reject {TypeError} The id was not a number.\n       */\n\n      /**\n       * Load a new video into this embed. The promise will be resolved if\n       * the video is successfully loaded, or it will be rejected if it could\n       * not be loaded.\n       *\n       * @param {number|string|object} options The id of the video, the url of the video, or an object with embed options.\n       * @return {LoadVideoPromise}\n       */\n\n    }, {\n      key: \"loadVideo\",\n      value: function loadVideo(options) {\n        return this.callMethod('loadVideo', options);\n      }\n      /**\n       * A promise to perform an action when the Player is ready.\n       *\n       * @todo document errors\n       * @promise LoadVideoPromise\n       * @fulfill {void}\n       */\n\n      /**\n       * Trigger a function when the player iframe has initialized. You do not\n       * need to wait for `ready` to trigger to begin adding event listeners\n       * or calling other methods.\n       *\n       * @return {ReadyPromise}\n       */\n\n    }, {\n      key: \"ready\",\n      value: function ready() {\n        var readyPromise = readyMap.get(this) || new npo_src(function (resolve, reject) {\n          reject(new Error('Unknown player. Probably unloaded.'));\n        });\n        return npo_src.resolve(readyPromise);\n      }\n      /**\n       * A promise to add a cue point to the player.\n       *\n       * @promise AddCuePointPromise\n       * @fulfill {string} The id of the cue point to use for removeCuePoint.\n       * @reject {RangeError} the time was less than 0 or greater than the\n       *         video\u2019s duration.\n       * @reject {UnsupportedError} Cue points are not supported with the current\n       *         player or browser.\n       */\n\n      /**\n       * Add a cue point to the player.\n       *\n       * @param {number} time The time for the cue point.\n       * @param {object} [data] Arbitrary data to be returned with the cue point.\n       * @return {AddCuePointPromise}\n       */\n\n    }, {\n      key: \"addCuePoint\",\n      value: function addCuePoint(time) {\n        var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};\n        return this.callMethod('addCuePoint', {\n          time: time,\n          data: data\n        });\n      }\n      /**\n       * A promise to remove a cue point from the player.\n       *\n       * @promise AddCuePointPromise\n       * @fulfill {string} The id of the cue point that was removed.\n       * @reject {InvalidCuePoint} The cue point with the specified id was not\n       *         found.\n       * @reject {UnsupportedError} Cue points are not supported with the current\n       *         player or browser.\n       */\n\n      /**\n       * Remove a cue point from the video.\n       *\n       * @param {string} id The id of the cue point to remove.\n       * @return {RemoveCuePointPromise}\n       */\n\n    }, {\n      key: \"removeCuePoint\",\n      value: function removeCuePoint(id) {\n        return this.callMethod('removeCuePoint', id);\n      }\n      /**\n       * A representation of a text track on a video.\n       *\n       * @typedef {Object} VimeoTextTrack\n       * @property {string} language The ISO language code.\n       * @property {string} kind The kind of track it is (captions or subtitles).\n       * @property {string} label The human\u2010readable label for the track.\n       */\n\n      /**\n       * A promise to enable a text track.\n       *\n       * @promise EnableTextTrackPromise\n       * @fulfill {VimeoTextTrack} The text track that was enabled.\n       * @reject {InvalidTrackLanguageError} No track was available with the\n       *         specified language.\n       * @reject {InvalidTrackError} No track was available with the specified\n       *         language and kind.\n       */\n\n      /**\n       * Enable the text track with the specified language, and optionally the\n       * specified kind (captions or subtitles).\n       *\n       * When set via the API, the track language will not change the viewer\u2019s\n       * stored preference.\n       *\n       * @param {string} language The two\u2010letter language code.\n       * @param {string} [kind] The kind of track to enable (captions or subtitles).\n       * @return {EnableTextTrackPromise}\n       */\n\n    }, {\n      key: \"enableTextTrack\",\n      value: function enableTextTrack(language, kind) {\n        if (!language) {\n          throw new TypeError('You must pass a language.');\n        }\n\n        return this.callMethod('enableTextTrack', {\n          language: language,\n          kind: kind\n        });\n      }\n      /**\n       * A promise to disable the active text track.\n       *\n       * @promise DisableTextTrackPromise\n       * @fulfill {void} The track was disabled.\n       */\n\n      /**\n       * Disable the currently-active text track.\n       *\n       * @return {DisableTextTrackPromise}\n       */\n\n    }, {\n      key: \"disableTextTrack\",\n      value: function disableTextTrack() {\n        return this.callMethod('disableTextTrack');\n      }\n      /**\n       * A promise to pause the video.\n       *\n       * @promise PausePromise\n       * @fulfill {void} The video was paused.\n       */\n\n      /**\n       * Pause the video if it\u2019s playing.\n       *\n       * @return {PausePromise}\n       */\n\n    }, {\n      key: \"pause\",\n      value: function pause() {\n        return this.callMethod('pause');\n      }\n      /**\n       * A promise to play the video.\n       *\n       * @promise PlayPromise\n       * @fulfill {void} The video was played.\n       */\n\n      /**\n       * Play the video if it\u2019s paused. **Note:** on iOS and some other\n       * mobile devices, you cannot programmatically trigger play. Once the\n       * viewer has tapped on the play button in the player, however, you\n       * will be able to use this function.\n       *\n       * @return {PlayPromise}\n       */\n\n    }, {\n      key: \"play\",\n      value: function play() {\n        return this.callMethod('play');\n      }\n      /**\n       * Request that the player enters fullscreen.\n       * @return {Promise}\n       */\n\n    }, {\n      key: \"requestFullscreen\",\n      value: function requestFullscreen() {\n        if (screenfull.isEnabled) {\n          return screenfull.request(this.element);\n        }\n\n        return this.callMethod('requestFullscreen');\n      }\n      /**\n       * Request that the player exits fullscreen.\n       * @return {Promise}\n       */\n\n    }, {\n      key: \"exitFullscreen\",\n      value: function exitFullscreen() {\n        if (screenfull.isEnabled) {\n          return screenfull.exit();\n        }\n\n        return this.callMethod('exitFullscreen');\n      }\n      /**\n       * Returns true if the player is currently fullscreen.\n       * @return {Promise}\n       */\n\n    }, {\n      key: \"getFullscreen\",\n      value: function getFullscreen() {\n        if (screenfull.isEnabled) {\n          return npo_src.resolve(screenfull.isFullscreen);\n        }\n\n        return this.get('fullscreen');\n      }\n      /**\n       * Request that the player enters picture-in-picture.\n       * @return {Promise}\n       */\n\n    }, {\n      key: \"requestPictureInPicture\",\n      value: function requestPictureInPicture() {\n        return this.callMethod('requestPictureInPicture');\n      }\n      /**\n       * Request that the player exits picture-in-picture.\n       * @return {Promise}\n       */\n\n    }, {\n      key: \"exitPictureInPicture\",\n      value: function exitPictureInPicture() {\n        return this.callMethod('exitPictureInPicture');\n      }\n      /**\n       * Returns true if the player is currently picture-in-picture.\n       * @return {Promise}\n       */\n\n    }, {\n      key: \"getPictureInPicture\",\n      value: function getPictureInPicture() {\n        return this.get('pictureInPicture');\n      }\n      /**\n       * A promise to unload the video.\n       *\n       * @promise UnloadPromise\n       * @fulfill {void} The video was unloaded.\n       */\n\n      /**\n       * Return the player to its initial state.\n       *\n       * @return {UnloadPromise}\n       */\n\n    }, {\n      key: \"unload\",\n      value: function unload() {\n        return this.callMethod('unload');\n      }\n      /**\n       * Cleanup the player and remove it from the DOM\n       *\n       * It won't be usable and a new one should be constructed\n       *  in order to do any operations.\n       *\n       * @return {Promise}\n       */\n\n    }, {\n      key: \"destroy\",\n      value: function destroy() {\n        var _this5 = this;\n\n        return new npo_src(function (resolve) {\n          readyMap.delete(_this5);\n          playerMap.delete(_this5.element);\n\n          if (_this5._originalElement) {\n            playerMap.delete(_this5._originalElement);\n\n            _this5._originalElement.removeAttribute('data-vimeo-initialized');\n          }\n\n          if (_this5.element && _this5.element.nodeName === 'IFRAME' && _this5.element.parentNode) {\n            // If we've added an additional wrapper div, remove that from the DOM.\n            // If not, just remove the iframe element.\n            if (_this5.element.parentNode.parentNode && _this5._originalElement && _this5._originalElement !== _this5.element.parentNode) {\n              _this5.element.parentNode.parentNode.removeChild(_this5.element.parentNode);\n            } else {\n              _this5.element.parentNode.removeChild(_this5.element);\n            }\n          } // If the clip is private there is a case where the element stays the\n          // div element. Destroy should reset the div and remove the iframe child.\n\n\n          if (_this5.element && _this5.element.nodeName === 'DIV' && _this5.element.parentNode) {\n            _this5.element.removeAttribute('data-vimeo-initialized');\n\n            var iframe = _this5.element.querySelector('iframe');\n\n            if (iframe && iframe.parentNode) {\n              // If we've added an additional wrapper div, remove that from the DOM.\n              // If not, just remove the iframe element.\n              if (iframe.parentNode.parentNode && _this5._originalElement && _this5._originalElement !== iframe.parentNode) {\n                iframe.parentNode.parentNode.removeChild(iframe.parentNode);\n              } else {\n                iframe.parentNode.removeChild(iframe);\n              }\n            }\n          }\n\n          _this5._window.removeEventListener('message', _this5._onMessage);\n\n          if (screenfull.isEnabled) {\n            screenfull.off('fullscreenchange', _this5.fullscreenchangeHandler);\n          }\n\n          resolve();\n        });\n      }\n      /**\n       * A promise to get the autopause behavior of the video.\n       *\n       * @promise GetAutopausePromise\n       * @fulfill {boolean} Whether autopause is turned on or off.\n       * @reject {UnsupportedError} Autopause is not supported with the current\n       *         player or browser.\n       */\n\n      /**\n       * Get the autopause behavior for this player.\n       *\n       * @return {GetAutopausePromise}\n       */\n\n    }, {\n      key: \"getAutopause\",\n      value: function getAutopause() {\n        return this.get('autopause');\n      }\n      /**\n       * A promise to set the autopause behavior of the video.\n       *\n       * @promise SetAutopausePromise\n       * @fulfill {boolean} Whether autopause is turned on or off.\n       * @reject {UnsupportedError} Autopause is not supported with the current\n       *         player or browser.\n       */\n\n      /**\n       * Enable or disable the autopause behavior of this player.\n       *\n       * By default, when another video is played in the same browser, this\n       * player will automatically pause. Unless you have a specific reason\n       * for doing so, we recommend that you leave autopause set to the\n       * default (`true`).\n       *\n       * @param {boolean} autopause\n       * @return {SetAutopausePromise}\n       */\n\n    }, {\n      key: \"setAutopause\",\n      value: function setAutopause(autopause) {\n        return this.set('autopause', autopause);\n      }\n      /**\n       * A promise to get the buffered property of the video.\n       *\n       * @promise GetBufferedPromise\n       * @fulfill {Array} Buffered Timeranges converted to an Array.\n       */\n\n      /**\n       * Get the buffered property of the video.\n       *\n       * @return {GetBufferedPromise}\n       */\n\n    }, {\n      key: \"getBuffered\",\n      value: function getBuffered() {\n        return this.get('buffered');\n      }\n      /**\n       * @typedef {Object} CameraProperties\n       * @prop {number} props.yaw - Number between 0 and 360.\n       * @prop {number} props.pitch - Number between -90 and 90.\n       * @prop {number} props.roll - Number between -180 and 180.\n       * @prop {number} props.fov - The field of view in degrees.\n       */\n\n      /**\n       * A promise to get the camera properties of the player.\n       *\n       * @promise GetCameraPromise\n       * @fulfill {CameraProperties} The camera properties.\n       */\n\n      /**\n       * For 360\u00b0 videos get the camera properties for this player.\n       *\n       * @return {GetCameraPromise}\n       */\n\n    }, {\n      key: \"getCameraProps\",\n      value: function getCameraProps() {\n        return this.get('cameraProps');\n      }\n      /**\n       * A promise to set the camera properties of the player.\n       *\n       * @promise SetCameraPromise\n       * @fulfill {Object} The camera was successfully set.\n       * @reject {RangeError} The range was out of bounds.\n       */\n\n      /**\n       * For 360\u00b0 videos set the camera properties for this player.\n       *\n       * @param {CameraProperties} camera The camera properties\n       * @return {SetCameraPromise}\n       */\n\n    }, {\n      key: \"setCameraProps\",\n      value: function setCameraProps(camera) {\n        return this.set('cameraProps', camera);\n      }\n      /**\n       * A representation of a chapter.\n       *\n       * @typedef {Object} VimeoChapter\n       * @property {number} startTime The start time of the chapter.\n       * @property {object} title The title of the chapter.\n       * @property {number} index The place in the order of Chapters. Starts at 1.\n       */\n\n      /**\n       * A promise to get chapters for the video.\n       *\n       * @promise GetChaptersPromise\n       * @fulfill {VimeoChapter[]} The chapters for the video.\n       */\n\n      /**\n       * Get an array of all the chapters for the video.\n       *\n       * @return {GetChaptersPromise}\n       */\n\n    }, {\n      key: \"getChapters\",\n      value: function getChapters() {\n        return this.get('chapters');\n      }\n      /**\n       * A promise to get the currently active chapter.\n       *\n       * @promise GetCurrentChaptersPromise\n       * @fulfill {VimeoChapter|undefined} The current chapter for the video.\n       */\n\n      /**\n       * Get the currently active chapter for the video.\n       *\n       * @return {GetCurrentChaptersPromise}\n       */\n\n    }, {\n      key: \"getCurrentChapter\",\n      value: function getCurrentChapter() {\n        return this.get('currentChapter');\n      }\n      /**\n       * A promise to get the color of the player.\n       *\n       * @promise GetColorPromise\n       * @fulfill {string} The hex color of the player.\n       */\n\n      /**\n       * Get the color for this player.\n       *\n       * @return {GetColorPromise}\n       */\n\n    }, {\n      key: \"getColor\",\n      value: function getColor() {\n        return this.get('color');\n      }\n      /**\n       * A promise to set the color of the player.\n       *\n       * @promise SetColorPromise\n       * @fulfill {string} The color was successfully set.\n       * @reject {TypeError} The string was not a valid hex or rgb color.\n       * @reject {ContrastError} The color was set, but the contrast is\n       *         outside of the acceptable range.\n       * @reject {EmbedSettingsError} The owner of the player has chosen to\n       *         use a specific color.\n       */\n\n      /**\n       * Set the color of this player to a hex or rgb string. Setting the\n       * color may fail if the owner of the video has set their embed\n       * preferences to force a specific color.\n       *\n       * @param {string} color The hex or rgb color string to set.\n       * @return {SetColorPromise}\n       */\n\n    }, {\n      key: \"setColor\",\n      value: function setColor(color) {\n        return this.set('color', color);\n      }\n      /**\n       * A representation of a cue point.\n       *\n       * @typedef {Object} VimeoCuePoint\n       * @property {number} time The time of the cue point.\n       * @property {object} data The data passed when adding the cue point.\n       * @property {string} id The unique id for use with removeCuePoint.\n       */\n\n      /**\n       * A promise to get the cue points of a video.\n       *\n       * @promise GetCuePointsPromise\n       * @fulfill {VimeoCuePoint[]} The cue points added to the video.\n       * @reject {UnsupportedError} Cue points are not supported with the current\n       *         player or browser.\n       */\n\n      /**\n       * Get an array of the cue points added to the video.\n       *\n       * @return {GetCuePointsPromise}\n       */\n\n    }, {\n      key: \"getCuePoints\",\n      value: function getCuePoints() {\n        return this.get('cuePoints');\n      }\n      /**\n       * A promise to get the current time of the video.\n       *\n       * @promise GetCurrentTimePromise\n       * @fulfill {number} The current time in seconds.\n       */\n\n      /**\n       * Get the current playback position in seconds.\n       *\n       * @return {GetCurrentTimePromise}\n       */\n\n    }, {\n      key: \"getCurrentTime\",\n      value: function getCurrentTime() {\n        return this.get('currentTime');\n      }\n      /**\n       * A promise to set the current time of the video.\n       *\n       * @promise SetCurrentTimePromise\n       * @fulfill {number} The actual current time that was set.\n       * @reject {RangeError} the time was less than 0 or greater than the\n       *         video\u2019s duration.\n       */\n\n      /**\n       * Set the current playback position in seconds. If the player was\n       * paused, it will remain paused. Likewise, if the player was playing,\n       * it will resume playing once the video has buffered.\n       *\n       * You can provide an accurate time and the player will attempt to seek\n       * to as close to that time as possible. The exact time will be the\n       * fulfilled value of the promise.\n       *\n       * @param {number} currentTime\n       * @return {SetCurrentTimePromise}\n       */\n\n    }, {\n      key: \"setCurrentTime\",\n      value: function setCurrentTime(currentTime) {\n        return this.set('currentTime', currentTime);\n      }\n      /**\n       * A promise to get the duration of the video.\n       *\n       * @promise GetDurationPromise\n       * @fulfill {number} The duration in seconds.\n       */\n\n      /**\n       * Get the duration of the video in seconds. It will be rounded to the\n       * nearest second before playback begins, and to the nearest thousandth\n       * of a second after playback begins.\n       *\n       * @return {GetDurationPromise}\n       */\n\n    }, {\n      key: \"getDuration\",\n      value: function getDuration() {\n        return this.get('duration');\n      }\n      /**\n       * A promise to get the ended state of the video.\n       *\n       * @promise GetEndedPromise\n       * @fulfill {boolean} Whether or not the video has ended.\n       */\n\n      /**\n       * Get the ended state of the video. The video has ended if\n       * `currentTime === duration`.\n       *\n       * @return {GetEndedPromise}\n       */\n\n    }, {\n      key: \"getEnded\",\n      value: function getEnded() {\n        return this.get('ended');\n      }\n      /**\n       * A promise to get the loop state of the player.\n       *\n       * @promise GetLoopPromise\n       * @fulfill {boolean} Whether or not the player is set to loop.\n       */\n\n      /**\n       * Get the loop state of the player.\n       *\n       * @return {GetLoopPromise}\n       */\n\n    }, {\n      key: \"getLoop\",\n      value: function getLoop() {\n        return this.get('loop');\n      }\n      /**\n       * A promise to set the loop state of the player.\n       *\n       * @promise SetLoopPromise\n       * @fulfill {boolean} The loop state that was set.\n       */\n\n      /**\n       * Set the loop state of the player. When set to `true`, the player\n       * will start over immediately once playback ends.\n       *\n       * @param {boolean} loop\n       * @return {SetLoopPromise}\n       */\n\n    }, {\n      key: \"setLoop\",\n      value: function setLoop(loop) {\n        return this.set('loop', loop);\n      }\n      /**\n       * A promise to set the muted state of the player.\n       *\n       * @promise SetMutedPromise\n       * @fulfill {boolean} The muted state that was set.\n       */\n\n      /**\n       * Set the muted state of the player. When set to `true`, the player\n       * volume will be muted.\n       *\n       * @param {boolean} muted\n       * @return {SetMutedPromise}\n       */\n\n    }, {\n      key: \"setMuted\",\n      value: function setMuted(muted) {\n        return this.set('muted', muted);\n      }\n      /**\n       * A promise to get the muted state of the player.\n       *\n       * @promise GetMutedPromise\n       * @fulfill {boolean} Whether or not the player is muted.\n       */\n\n      /**\n       * Get the muted state of the player.\n       *\n       * @return {GetMutedPromise}\n       */\n\n    }, {\n      key: \"getMuted\",\n      value: function getMuted() {\n        return this.get('muted');\n      }\n      /**\n       * A promise to get the paused state of the player.\n       *\n       * @promise GetLoopPromise\n       * @fulfill {boolean} Whether or not the video is paused.\n       */\n\n      /**\n       * Get the paused state of the player.\n       *\n       * @return {GetLoopPromise}\n       */\n\n    }, {\n      key: \"getPaused\",\n      value: function getPaused() {\n        return this.get('paused');\n      }\n      /**\n       * A promise to get the playback rate of the player.\n       *\n       * @promise GetPlaybackRatePromise\n       * @fulfill {number} The playback rate of the player on a scale from 0.5 to 2.\n       */\n\n      /**\n       * Get the playback rate of the player on a scale from `0.5` to `2`.\n       *\n       * @return {GetPlaybackRatePromise}\n       */\n\n    }, {\n      key: \"getPlaybackRate\",\n      value: function getPlaybackRate() {\n        return this.get('playbackRate');\n      }\n      /**\n       * A promise to set the playbackrate of the player.\n       *\n       * @promise SetPlaybackRatePromise\n       * @fulfill {number} The playback rate was set.\n       * @reject {RangeError} The playback rate was less than 0.5 or greater than 2.\n       */\n\n      /**\n       * Set the playback rate of the player on a scale from `0.5` to `2`. When set\n       * via the API, the playback rate will not be synchronized to other\n       * players or stored as the viewer's preference.\n       *\n       * @param {number} playbackRate\n       * @return {SetPlaybackRatePromise}\n       */\n\n    }, {\n      key: \"setPlaybackRate\",\n      value: function setPlaybackRate(playbackRate) {\n        return this.set('playbackRate', playbackRate);\n      }\n      /**\n       * A promise to get the played property of the video.\n       *\n       * @promise GetPlayedPromise\n       * @fulfill {Array} Played Timeranges converted to an Array.\n       */\n\n      /**\n       * Get the played property of the video.\n       *\n       * @return {GetPlayedPromise}\n       */\n\n    }, {\n      key: \"getPlayed\",\n      value: function getPlayed() {\n        return this.get('played');\n      }\n      /**\n       * A promise to get the qualities available of the current video.\n       *\n       * @promise GetQualitiesPromise\n       * @fulfill {Array} The qualities of the video.\n       */\n\n      /**\n       * Get the qualities of the current video.\n       *\n       * @return {GetQualitiesPromise}\n       */\n\n    }, {\n      key: \"getQualities\",\n      value: function getQualities() {\n        return this.get('qualities');\n      }\n      /**\n       * A promise to get the current set quality of the video.\n       *\n       * @promise GetQualityPromise\n       * @fulfill {string} The current set quality.\n       */\n\n      /**\n       * Get the current set quality of the video.\n       *\n       * @return {GetQualityPromise}\n       */\n\n    }, {\n      key: \"getQuality\",\n      value: function getQuality() {\n        return this.get('quality');\n      }\n      /**\n       * A promise to set the video quality.\n       *\n       * @promise SetQualityPromise\n       * @fulfill {number} The quality was set.\n       * @reject {RangeError} The quality is not available.\n       */\n\n      /**\n       * Set a video quality.\n       *\n       * @param {string} quality\n       * @return {SetQualityPromise}\n       */\n\n    }, {\n      key: \"setQuality\",\n      value: function setQuality(quality) {\n        return this.set('quality', quality);\n      }\n      /**\n       * A promise to get the seekable property of the video.\n       *\n       * @promise GetSeekablePromise\n       * @fulfill {Array} Seekable Timeranges converted to an Array.\n       */\n\n      /**\n       * Get the seekable property of the video.\n       *\n       * @return {GetSeekablePromise}\n       */\n\n    }, {\n      key: \"getSeekable\",\n      value: function getSeekable() {\n        return this.get('seekable');\n      }\n      /**\n       * A promise to get the seeking property of the player.\n       *\n       * @promise GetSeekingPromise\n       * @fulfill {boolean} Whether or not the player is currently seeking.\n       */\n\n      /**\n       * Get if the player is currently seeking.\n       *\n       * @return {GetSeekingPromise}\n       */\n\n    }, {\n      key: \"getSeeking\",\n      value: function getSeeking() {\n        return this.get('seeking');\n      }\n      /**\n       * A promise to get the text tracks of a video.\n       *\n       * @promise GetTextTracksPromise\n       * @fulfill {VimeoTextTrack[]} The text tracks associated with the video.\n       */\n\n      /**\n       * Get an array of the text tracks that exist for the video.\n       *\n       * @return {GetTextTracksPromise}\n       */\n\n    }, {\n      key: \"getTextTracks\",\n      value: function getTextTracks() {\n        return this.get('textTracks');\n      }\n      /**\n       * A promise to get the embed code for the video.\n       *\n       * @promise GetVideoEmbedCodePromise\n       * @fulfill {string} The `<iframe>` embed code for the video.\n       */\n\n      /**\n       * Get the `<iframe>` embed code for the video.\n       *\n       * @return {GetVideoEmbedCodePromise}\n       */\n\n    }, {\n      key: \"getVideoEmbedCode\",\n      value: function getVideoEmbedCode() {\n        return this.get('videoEmbedCode');\n      }\n      /**\n       * A promise to get the id of the video.\n       *\n       * @promise GetVideoIdPromise\n       * @fulfill {number} The id of the video.\n       */\n\n      /**\n       * Get the id of the video.\n       *\n       * @return {GetVideoIdPromise}\n       */\n\n    }, {\n      key: \"getVideoId\",\n      value: function getVideoId() {\n        return this.get('videoId');\n      }\n      /**\n       * A promise to get the title of the video.\n       *\n       * @promise GetVideoTitlePromise\n       * @fulfill {number} The title of the video.\n       */\n\n      /**\n       * Get the title of the video.\n       *\n       * @return {GetVideoTitlePromise}\n       */\n\n    }, {\n      key: \"getVideoTitle\",\n      value: function getVideoTitle() {\n        return this.get('videoTitle');\n      }\n      /**\n       * A promise to get the native width of the video.\n       *\n       * @promise GetVideoWidthPromise\n       * @fulfill {number} The native width of the video.\n       */\n\n      /**\n       * Get the native width of the currently\u2010playing video. The width of\n       * the highest\u2010resolution available will be used before playback begins.\n       *\n       * @return {GetVideoWidthPromise}\n       */\n\n    }, {\n      key: \"getVideoWidth\",\n      value: function getVideoWidth() {\n        return this.get('videoWidth');\n      }\n      /**\n       * A promise to get the native height of the video.\n       *\n       * @promise GetVideoHeightPromise\n       * @fulfill {number} The native height of the video.\n       */\n\n      /**\n       * Get the native height of the currently\u2010playing video. The height of\n       * the highest\u2010resolution available will be used before playback begins.\n       *\n       * @return {GetVideoHeightPromise}\n       */\n\n    }, {\n      key: \"getVideoHeight\",\n      value: function getVideoHeight() {\n        return this.get('videoHeight');\n      }\n      /**\n       * A promise to get the vimeo.com url for the video.\n       *\n       * @promise GetVideoUrlPromise\n       * @fulfill {number} The vimeo.com url for the video.\n       * @reject {PrivacyError} The url isn\u2019t available because of the video\u2019s privacy setting.\n       */\n\n      /**\n       * Get the vimeo.com url for the video.\n       *\n       * @return {GetVideoUrlPromise}\n       */\n\n    }, {\n      key: \"getVideoUrl\",\n      value: function getVideoUrl() {\n        return this.get('videoUrl');\n      }\n      /**\n       * A promise to get the volume level of the player.\n       *\n       * @promise GetVolumePromise\n       * @fulfill {number} The volume level of the player on a scale from 0 to 1.\n       */\n\n      /**\n       * Get the current volume level of the player on a scale from `0` to `1`.\n       *\n       * Most mobile devices do not support an independent volume from the\n       * system volume. In those cases, this method will always return `1`.\n       *\n       * @return {GetVolumePromise}\n       */\n\n    }, {\n      key: \"getVolume\",\n      value: function getVolume() {\n        return this.get('volume');\n      }\n      /**\n       * A promise to set the volume level of the player.\n       *\n       * @promise SetVolumePromise\n       * @fulfill {number} The volume was set.\n       * @reject {RangeError} The volume was less than 0 or greater than 1.\n       */\n\n      /**\n       * Set the volume of the player on a scale from `0` to `1`. When set\n       * via the API, the volume level will not be synchronized to other\n       * players or stored as the viewer\u2019s preference.\n       *\n       * Most mobile devices do not support setting the volume. An error will\n       * *not* be triggered in that situation.\n       *\n       * @param {number} volume\n       * @return {SetVolumePromise}\n       */\n\n    }, {\n      key: \"setVolume\",\n      value: function setVolume(volume) {\n        return this.set('volume', volume);\n      }\n    }]);\n\n    return Player;\n  }(); // Setup embed only if this is not a node environment\n\n\n  if (!isNode) {\n    screenfull = initializeScreenfull();\n    initializeEmbeds();\n    resizeEmbeds();\n  }\n\n  return Player;\n\n})));\n\n//# sourceMappingURL=player.js.map","vimeo/player.min.js":"/*! @vimeo/player v2.16.4 | (c) 2022 Vimeo | MIT License | https://github.com/vimeo/player.js */\n!function(e,t){\"object\"==typeof exports&&\"undefined\"!=typeof module?module.exports=t():\"function\"==typeof define&&define.amd?define(t):((e=\"undefined\"!=typeof globalThis?globalThis:e||self).Vimeo=e.Vimeo||{},e.Vimeo.Player=t())}(this,function(){\"use strict\";function r(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,\"value\"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var e=\"undefined\"!=typeof global&&\"[object global]\"==={}.toString.call(global);function i(e,t){return 0===e.indexOf(t.toLowerCase())?e:\"\".concat(t.toLowerCase()).concat(e.substr(0,1).toUpperCase()).concat(e.substr(1))}function l(e){return/^(https?:)?\\/\\/((player|www)\\.)?vimeo\\.com(?=$|\\/)/.test(e)}function u(e){var t=0<arguments.length&&void 0!==e?e:{},n=t.id,e=t.url,t=n||e;if(!t)throw new Error(\"An id or url must be passed, either in an options object or as a data-vimeo-id or data-vimeo-url attribute.\");if(e=t,!isNaN(parseFloat(e))&&isFinite(e)&&Math.floor(e)==e)return\"https://vimeo.com/\".concat(t);if(l(t))return t.replace(\"http:\",\"https:\");if(n)throw new TypeError(\"\u201c\".concat(n,\"\u201d is not a valid video id.\"));throw new TypeError(\"\u201c\".concat(t,\"\u201d is not a vimeo.com url.\"))}var t=void 0!==Array.prototype.indexOf,Player=\"undefined\"!=typeof window&&void 0!==window.postMessage;if(!(e||t&&Player))throw new Error(\"Sorry, the Vimeo Player API is not available in this browser.\");var n,o,a=\"undefined\"!=typeof globalThis?globalThis:\"undefined\"!=typeof window?window:\"undefined\"!=typeof global?global:\"undefined\"!=typeof self?self:{};function c(){if(void 0===this)throw new TypeError(\"Constructor WeakMap requires 'new'\");if(o(this,\"_id\",\"_WeakMap_\"+f()+\".\"+f()),0<arguments.length)throw new TypeError(\"WeakMap iterable is not supported\")}function s(e,t){if(!d(e)||!n.call(e,\"_id\"))throw new TypeError(t+\" method called on incompatible receiver \"+typeof e)}function f(){return Math.random().toString().substring(2)}function d(e){return Object(e)===e}(Player=\"undefined\"!=typeof self?self:\"undefined\"!=typeof window?window:a).WeakMap||(n=Object.prototype.hasOwnProperty,Player.WeakMap=((o=function(e,t,n){Object.defineProperty?Object.defineProperty(e,t,{configurable:!0,writable:!0,value:n}):e[t]=n})(c.prototype,\"delete\",function(e){if(s(this,\"delete\"),!d(e))return!1;var t=e[this._id];return!(!t||t[0]!==e)&&(delete e[this._id],!0)}),o(c.prototype,\"get\",function(e){if(s(this,\"get\"),d(e)){var t=e[this._id];return t&&t[0]===e?t[1]:void 0}}),o(c.prototype,\"has\",function(e){if(s(this,\"has\"),!d(e))return!1;var t=e[this._id];return!(!t||t[0]!==e)}),o(c.prototype,\"set\",function(e,t){if(s(this,\"set\"),!d(e))throw new TypeError(\"Invalid value used as weak map key\");var n=e[this._id];return n&&n[0]===e?n[1]=t:o(e,this._id,[e,t]),this}),o(c,\"_polyfill\",!0),c));var h,m=(function(e){var t,n,r;r=function(){var t,n,r,o,i,e=Object.prototype.toString,a=\"undefined\"!=typeof setImmediate?function(e){return setImmediate(e)}:setTimeout;try{Object.defineProperty({},\"x\",{}),t=function(e,t,n,r){return Object.defineProperty(e,t,{value:n,writable:!0,configurable:!1!==r})}}catch(e){t=function(e,t,n){return e[t]=n,e}}function u(e,t){this.fn=e,this.self=t,this.next=void 0}function l(e,t){y.add(e,t),n=n||a(y.drain)}function c(e){var t,n=typeof e;return\"function\"==typeof(t=null!=e&&(\"object\"==n||\"function\"==n)?e.then:t)&&t}function s(){for(var e=0;e<this.chain.length;e++)!function(e,t,n){var r,o;try{!1===t?n.reject(e.msg):(r=!0===t?e.msg:t.call(void 0,e.msg))===n.promise?n.reject(TypeError(\"Promise-chain cycle\")):(o=c(r))?o.call(r,n.resolve,n.reject):n.resolve(r)}catch(e){n.reject(e)}}(this,1===this.state?this.chain[e].success:this.chain[e].failure,this.chain[e]);this.chain.length=0}function f(e){var n,r=this;if(!r.triggered){r.triggered=!0,r.def&&(r=r.def);try{(n=c(e))?l(function(){var t=new m(r);try{n.call(e,function(){f.apply(t,arguments)},function(){d.apply(t,arguments)})}catch(e){d.call(t,e)}}):(r.msg=e,r.state=1,0<r.chain.length&&l(s,r))}catch(e){d.call(new m(r),e)}}}function d(e){var t=this;t.triggered||(t.triggered=!0,(t=t.def?t.def:t).msg=e,t.state=2,0<t.chain.length&&l(s,t))}function h(e,n,r,o){for(var t=0;t<n.length;t++)!function(t){e.resolve(n[t]).then(function(e){r(t,e)},o)}(t)}function m(e){this.def=e,this.triggered=!1}function v(e){this.promise=e,this.state=0,this.triggered=!1,this.chain=[],this.msg=void 0}function p(e){if(\"function\"!=typeof e)throw TypeError(\"Not a function\");if(0!==this.__NPO__)throw TypeError(\"Not a promise\");this.__NPO__=1;var r=new v(this);this.then=function(e,t){var n={success:\"function\"!=typeof e||e,failure:\"function\"==typeof t&&t};return n.promise=new this.constructor(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");n.resolve=e,n.reject=t}),r.chain.push(n),0!==r.state&&l(s,r),n.promise},this.catch=function(e){return this.then(void 0,e)};try{e.call(void 0,function(e){f.call(r,e)},function(e){d.call(r,e)})}catch(e){d.call(r,e)}}var y={add:function(e,t){i=new u(e,t),o?o.next=i:r=i,o=i,i=void 0},drain:function(){var e=r;for(r=o=n=void 0;e;)e.fn.call(e.self),e=e.next}},g=t({},\"constructor\",p,!1);return t(p.prototype=g,\"__NPO__\",0,!1),t(p,\"resolve\",function(n){return n&&\"object\"==typeof n&&1===n.__NPO__?n:new this(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");e(n)})}),t(p,\"reject\",function(n){return new this(function(e,t){if(\"function\"!=typeof e||\"function\"!=typeof t)throw TypeError(\"Not a function\");t(n)})}),t(p,\"all\",function(t){var a=this;return\"[object Array]\"!=e.call(t)?a.reject(TypeError(\"Not an array\")):0===t.length?a.resolve([]):new a(function(n,e){if(\"function\"!=typeof n||\"function\"!=typeof e)throw TypeError(\"Not a function\");var r=t.length,o=Array(r),i=0;h(a,t,function(e,t){o[e]=t,++i===r&&n(o)},e)})}),t(p,\"race\",function(t){var r=this;return\"[object Array]\"!=e.call(t)?r.reject(TypeError(\"Not an array\")):new r(function(n,e){if(\"function\"!=typeof n||\"function\"!=typeof e)throw TypeError(\"Not a function\");h(r,t,function(e,t){n(t)},e)})}),p},(n=a)[t=\"Promise\"]=n[t]||r(),e.exports&&(e.exports=n[t])}(h={exports:{}}),h.exports),v=new WeakMap;function p(e,t,n){var r=v.get(e.element)||{};t in r||(r[t]=[]),r[t].push(n),v.set(e.element,r)}function y(e,t){return(v.get(e.element)||{})[t]||[]}function g(e,t,n){var r=v.get(e.element)||{};if(!r[t])return!0;if(!n)return r[t]=[],v.set(e.element,r),!0;n=r[t].indexOf(n);return-1!==n&&r[t].splice(n,1),v.set(e.element,r),r[t]&&0===r[t].length}var w=[\"autopause\",\"autoplay\",\"background\",\"byline\",\"color\",\"controls\",\"dnt\",\"height\",\"id\",\"interactive_params\",\"keyboard\",\"loop\",\"maxheight\",\"maxwidth\",\"muted\",\"playsinline\",\"portrait\",\"responsive\",\"speed\",\"texttrack\",\"title\",\"transparent\",\"url\",\"width\"];function b(r,e){return w.reduce(function(e,t){var n=r.getAttribute(\"data-vimeo-\".concat(t));return!n&&\"\"!==n||(e[t]=\"\"===n?1:n),e},1<arguments.length&&void 0!==e?e:{})}function k(e,t){var n=e.html;if(!t)throw new TypeError(\"An element must be provided\");if(null!==t.getAttribute(\"data-vimeo-initialized\"))return t.querySelector(\"iframe\");e=document.createElement(\"div\");return e.innerHTML=n,t.appendChild(e.firstChild),t.setAttribute(\"data-vimeo-initialized\",\"true\"),t.querySelector(\"iframe\")}function E(i,e,t){var a=1<arguments.length&&void 0!==e?e:{},u=2<arguments.length?t:void 0;return new Promise(function(t,n){if(!l(i))throw new TypeError(\"\u201c\".concat(i,\"\u201d is not a vimeo.com url.\"));var e,r=\"https://vimeo.com/api/oembed.json?url=\".concat(encodeURIComponent(i));for(e in a)a.hasOwnProperty(e)&&(r+=\"&\".concat(e,\"=\").concat(encodeURIComponent(a[e])));var o=new(\"XDomainRequest\"in window?XDomainRequest:XMLHttpRequest);o.open(\"GET\",r,!0),o.onload=function(){if(404!==o.status)if(403!==o.status)try{var e=JSON.parse(o.responseText);if(403===e.domain_status_code)return k(e,u),void n(new Error(\"\u201c\".concat(i,\"\u201d is not embeddable.\")));t(e)}catch(e){n(e)}else n(new Error(\"\u201c\".concat(i,\"\u201d is not embeddable.\")));else n(new Error(\"\u201c\".concat(i,\"\u201d was not found.\")))},o.onerror=function(){var e=o.status?\" (\".concat(o.status,\")\"):\"\";n(new Error(\"There was an error fetching the embed code from Vimeo\".concat(e,\".\")))},o.send()})}function T(e){function n(e){\"console\"in window&&console.error&&console.error(\"There was an error creating an embed: \".concat(e))}e=0<arguments.length&&void 0!==e?e:document,e=[].slice.call(e.querySelectorAll(\"[data-vimeo-id], [data-vimeo-url]\"));e.forEach(function(t){try{if(null!==t.getAttribute(\"data-vimeo-defer\"))return;var e=b(t);E(u(e),e,t).then(function(e){return k(e,t)}).catch(n)}catch(e){n(e)}})}function P(e){if(\"string\"==typeof e)try{e=JSON.parse(e)}catch(e){return console.warn(e),{}}return e}function _(e,t,n){e.element.contentWindow&&e.element.contentWindow.postMessage&&(t={method:t},void 0!==n&&(t.value=n),8<=(n=parseFloat(navigator.userAgent.toLowerCase().replace(/^.*msie (\\d+).*$/,\"$1\")))&&n<10&&(t=JSON.stringify(t)),e.element.contentWindow.postMessage(t,e.origin))}function M(n,r){var t,e,o,i,a=[];(r=P(r)).event?(\"error\"===r.event&&y(n,r.data.method).forEach(function(e){var t=new Error(r.data.message);t.name=r.data.name,e.reject(t),g(n,r.data.method,e)}),a=y(n,\"event:\".concat(r.event)),t=r.data):r.method&&(e=n,o=r.method,(i=!((i=y(e,o)).length<1)&&(i=i.shift(),g(e,o,i),i))&&(a.push(i),t=r.value)),a.forEach(function(e){try{if(\"function\"==typeof e)return void e.call(n,t);e.resolve(t)}catch(e){}})}var N,F,x,C=new WeakMap,j=new WeakMap,A={},Player=function(){function Player(i){var e,a=this,t=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};if(!function(e,t){if(!(e instanceof t))throw new TypeError(\"Cannot call a class as a function\")}(this,Player),window.jQuery&&i instanceof jQuery&&(1<i.length&&window.console&&console.warn&&console.warn(\"A jQuery object with multiple elements was passed, using the first element.\"),i=i[0]),\"undefined\"!=typeof document&&\"string\"==typeof i&&(i=document.getElementById(i)),e=i,!Boolean(e&&1===e.nodeType&&\"nodeName\"in e&&e.ownerDocument&&e.ownerDocument.defaultView))throw new TypeError(\"You must pass either a valid element or a valid id.\");if(\"IFRAME\"===i.nodeName||(r=i.querySelector(\"iframe\"))&&(i=r),\"IFRAME\"===i.nodeName&&!l(i.getAttribute(\"src\")||\"\"))throw new Error(\"The player element passed isn\u2019t a Vimeo embed.\");if(C.has(i))return C.get(i);this._window=i.ownerDocument.defaultView,this.element=i,this.origin=\"*\";var n,r=new m(function(r,o){var e;a._onMessage=function(e){if(l(e.origin)&&a.element.contentWindow===e.source){\"*\"===a.origin&&(a.origin=e.origin);var t=P(e.data);if(t&&\"error\"===t.event&&t.data&&\"ready\"===t.data.method){var n=new Error(t.data.message);return n.name=t.data.name,void o(n)}e=t&&\"ready\"===t.event,n=t&&\"ping\"===t.method;if(e||n)return a.element.setAttribute(\"data-ready\",\"true\"),void r();M(a,t)}},a._window.addEventListener(\"message\",a._onMessage),\"IFRAME\"!==a.element.nodeName&&E(u(e=b(i,t)),e,i).then(function(e){var t,n,r=k(e,i);return a.element=r,a._originalElement=i,t=i,n=r,r=v.get(t),v.set(n,r),v.delete(t),C.set(a.element,a),e}).catch(o)});return j.set(this,r),C.set(this.element,this),\"IFRAME\"===this.element.nodeName&&_(this,\"ping\"),A.isEnabled&&(n=function(){return A.exit()},this.fullscreenchangeHandler=function(){(A.isFullscreen?p:g)(a,\"event:exitFullscreen\",n),a.ready().then(function(){_(a,\"fullscreenchange\",A.isFullscreen)})},A.on(\"fullscreenchange\",this.fullscreenchangeHandler)),this}var e,t,n;return e=Player,(t=[{key:\"callMethod\",value:function(n){var r=this,o=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{};return new m(function(e,t){return r.ready().then(function(){p(r,n,{resolve:e,reject:t}),_(r,n,o)}).catch(t)})}},{key:\"get\",value:function(n){var r=this;return new m(function(e,t){return n=i(n,\"get\"),r.ready().then(function(){p(r,n,{resolve:e,reject:t}),_(r,n)}).catch(t)})}},{key:\"set\",value:function(n,r){var o=this;return new m(function(e,t){if(n=i(n,\"set\"),null==r)throw new TypeError(\"There must be a value to set.\");return o.ready().then(function(){p(o,n,{resolve:e,reject:t}),_(o,n,r)}).catch(t)})}},{key:\"on\",value:function(e,t){if(!e)throw new TypeError(\"You must pass an event name.\");if(!t)throw new TypeError(\"You must pass a callback function.\");if(\"function\"!=typeof t)throw new TypeError(\"The callback must be a function.\");0===y(this,\"event:\".concat(e)).length&&this.callMethod(\"addEventListener\",e).catch(function(){}),p(this,\"event:\".concat(e),t)}},{key:\"off\",value:function(e,t){if(!e)throw new TypeError(\"You must pass an event name.\");if(t&&\"function\"!=typeof t)throw new TypeError(\"The callback must be a function.\");g(this,\"event:\".concat(e),t)&&this.callMethod(\"removeEventListener\",e).catch(function(e){})}},{key:\"loadVideo\",value:function(e){return this.callMethod(\"loadVideo\",e)}},{key:\"ready\",value:function(){var e=j.get(this)||new m(function(e,t){t(new Error(\"Unknown player. Probably unloaded.\"))});return m.resolve(e)}},{key:\"addCuePoint\",value:function(e){return this.callMethod(\"addCuePoint\",{time:e,data:1<arguments.length&&void 0!==arguments[1]?arguments[1]:{}})}},{key:\"removeCuePoint\",value:function(e){return this.callMethod(\"removeCuePoint\",e)}},{key:\"enableTextTrack\",value:function(e,t){if(!e)throw new TypeError(\"You must pass a language.\");return this.callMethod(\"enableTextTrack\",{language:e,kind:t})}},{key:\"disableTextTrack\",value:function(){return this.callMethod(\"disableTextTrack\")}},{key:\"pause\",value:function(){return this.callMethod(\"pause\")}},{key:\"play\",value:function(){return this.callMethod(\"play\")}},{key:\"requestFullscreen\",value:function(){return A.isEnabled?A.request(this.element):this.callMethod(\"requestFullscreen\")}},{key:\"exitFullscreen\",value:function(){return A.isEnabled?A.exit():this.callMethod(\"exitFullscreen\")}},{key:\"getFullscreen\",value:function(){return A.isEnabled?m.resolve(A.isFullscreen):this.get(\"fullscreen\")}},{key:\"requestPictureInPicture\",value:function(){return this.callMethod(\"requestPictureInPicture\")}},{key:\"exitPictureInPicture\",value:function(){return this.callMethod(\"exitPictureInPicture\")}},{key:\"getPictureInPicture\",value:function(){return this.get(\"pictureInPicture\")}},{key:\"unload\",value:function(){return this.callMethod(\"unload\")}},{key:\"destroy\",value:function(){var n=this;return new m(function(e){var t;j.delete(n),C.delete(n.element),n._originalElement&&(C.delete(n._originalElement),n._originalElement.removeAttribute(\"data-vimeo-initialized\")),n.element&&\"IFRAME\"===n.element.nodeName&&n.element.parentNode&&(n.element.parentNode.parentNode&&n._originalElement&&n._originalElement!==n.element.parentNode?n.element.parentNode.parentNode.removeChild(n.element.parentNode):n.element.parentNode.removeChild(n.element)),n.element&&\"DIV\"===n.element.nodeName&&n.element.parentNode&&(n.element.removeAttribute(\"data-vimeo-initialized\"),(t=n.element.querySelector(\"iframe\"))&&t.parentNode&&(t.parentNode.parentNode&&n._originalElement&&n._originalElement!==t.parentNode?t.parentNode.parentNode.removeChild(t.parentNode):t.parentNode.removeChild(t))),n._window.removeEventListener(\"message\",n._onMessage),A.isEnabled&&A.off(\"fullscreenchange\",n.fullscreenchangeHandler),e()})}},{key:\"getAutopause\",value:function(){return this.get(\"autopause\")}},{key:\"setAutopause\",value:function(e){return this.set(\"autopause\",e)}},{key:\"getBuffered\",value:function(){return this.get(\"buffered\")}},{key:\"getCameraProps\",value:function(){return this.get(\"cameraProps\")}},{key:\"setCameraProps\",value:function(e){return this.set(\"cameraProps\",e)}},{key:\"getChapters\",value:function(){return this.get(\"chapters\")}},{key:\"getCurrentChapter\",value:function(){return this.get(\"currentChapter\")}},{key:\"getColor\",value:function(){return this.get(\"color\")}},{key:\"setColor\",value:function(e){return this.set(\"color\",e)}},{key:\"getCuePoints\",value:function(){return this.get(\"cuePoints\")}},{key:\"getCurrentTime\",value:function(){return this.get(\"currentTime\")}},{key:\"setCurrentTime\",value:function(e){return this.set(\"currentTime\",e)}},{key:\"getDuration\",value:function(){return this.get(\"duration\")}},{key:\"getEnded\",value:function(){return this.get(\"ended\")}},{key:\"getLoop\",value:function(){return this.get(\"loop\")}},{key:\"setLoop\",value:function(e){return this.set(\"loop\",e)}},{key:\"setMuted\",value:function(e){return this.set(\"muted\",e)}},{key:\"getMuted\",value:function(){return this.get(\"muted\")}},{key:\"getPaused\",value:function(){return this.get(\"paused\")}},{key:\"getPlaybackRate\",value:function(){return this.get(\"playbackRate\")}},{key:\"setPlaybackRate\",value:function(e){return this.set(\"playbackRate\",e)}},{key:\"getPlayed\",value:function(){return this.get(\"played\")}},{key:\"getQualities\",value:function(){return this.get(\"qualities\")}},{key:\"getQuality\",value:function(){return this.get(\"quality\")}},{key:\"setQuality\",value:function(e){return this.set(\"quality\",e)}},{key:\"getSeekable\",value:function(){return this.get(\"seekable\")}},{key:\"getSeeking\",value:function(){return this.get(\"seeking\")}},{key:\"getTextTracks\",value:function(){return this.get(\"textTracks\")}},{key:\"getVideoEmbedCode\",value:function(){return this.get(\"videoEmbedCode\")}},{key:\"getVideoId\",value:function(){return this.get(\"videoId\")}},{key:\"getVideoTitle\",value:function(){return this.get(\"videoTitle\")}},{key:\"getVideoWidth\",value:function(){return this.get(\"videoWidth\")}},{key:\"getVideoHeight\",value:function(){return this.get(\"videoHeight\")}},{key:\"getVideoUrl\",value:function(){return this.get(\"videoUrl\")}},{key:\"getVolume\",value:function(){return this.get(\"volume\")}},{key:\"setVolume\",value:function(e){return this.set(\"volume\",e)}}])&&r(e.prototype,t),n&&r(e,n),Player}();return e||(N=function(){for(var e,t=[[\"requestFullscreen\",\"exitFullscreen\",\"fullscreenElement\",\"fullscreenEnabled\",\"fullscreenchange\",\"fullscreenerror\"],[\"webkitRequestFullscreen\",\"webkitExitFullscreen\",\"webkitFullscreenElement\",\"webkitFullscreenEnabled\",\"webkitfullscreenchange\",\"webkitfullscreenerror\"],[\"webkitRequestFullScreen\",\"webkitCancelFullScreen\",\"webkitCurrentFullScreenElement\",\"webkitCancelFullScreen\",\"webkitfullscreenchange\",\"webkitfullscreenerror\"],[\"mozRequestFullScreen\",\"mozCancelFullScreen\",\"mozFullScreenElement\",\"mozFullScreenEnabled\",\"mozfullscreenchange\",\"mozfullscreenerror\"],[\"msRequestFullscreen\",\"msExitFullscreen\",\"msFullscreenElement\",\"msFullscreenEnabled\",\"MSFullscreenChange\",\"MSFullscreenError\"]],n=0,r=t.length,o={};n<r;n++)if((e=t[n])&&e[1]in document){for(n=0;n<e.length;n++)o[t[0][n]]=e[n];return o}return!1}(),F={fullscreenchange:N.fullscreenchange,fullscreenerror:N.fullscreenerror},x={request:function(o){return new Promise(function(e,t){function n(){x.off(\"fullscreenchange\",n),e()}x.on(\"fullscreenchange\",n);var r=(o=o||document.documentElement)[N.requestFullscreen]();r instanceof Promise&&r.then(n).catch(t)})},exit:function(){return new Promise(function(t,e){var n,r;x.isFullscreen?(n=function e(){x.off(\"fullscreenchange\",e),t()},x.on(\"fullscreenchange\",n),(r=document[N.exitFullscreen]())instanceof Promise&&r.then(n).catch(e)):t()})},on:function(e,t){e=F[e];e&&document.addEventListener(e,t)},off:function(e,t){e=F[e];e&&document.removeEventListener(e,t)}},Object.defineProperties(x,{isFullscreen:{get:function(){return Boolean(document[N.fullscreenElement])}},element:{enumerable:!0,get:function(){return document[N.fullscreenElement]}},isEnabled:{enumerable:!0,get:function(){return Boolean(document[N.fullscreenEnabled])}}}),A=x,T(),function(e){var r=0<arguments.length&&void 0!==e?e:document;window.VimeoPlayerResizeEmbeds_||(window.VimeoPlayerResizeEmbeds_=!0,window.addEventListener(\"message\",function(e){if(l(e.origin)&&e.data&&\"spacechange\"===e.data.event)for(var t=r.querySelectorAll(\"iframe\"),n=0;n<t.length;n++)if(t[n].contentWindow===e.source){t[n].parentElement.style.paddingBottom=\"\".concat(e.data.data[0].bottom,\"px\");break}}))}()),Player});\n","vimeo/vimeo-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'vimeo'\n], function (Player) {\n    'use strict';\n\n    window.Vimeo = window.Vimeo || {\n        'Player': Player\n    };\n});\n"}
}});
