require.config({"config": {
        "jsbuild":{"Magento_Ui/js/form/element/single-checkbox.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'underscore',\n    'mage/translate'\n], function (AbstractField, _, $t) {\n    'use strict';\n\n    return AbstractField.extend({\n        defaults: {\n            template: 'ui/form/components/single/field',\n            checked: false,\n            initialChecked: false,\n            multiple: false,\n            prefer: 'checkbox', // 'radio' | 'checkbox' | 'toggle'\n            valueMap: {},\n\n            templates: {\n                radio: 'ui/form/components/single/radio',\n                checkbox: 'ui/form/components/single/checkbox',\n                toggle: 'ui/form/components/single/switcher'\n            },\n\n            listens: {\n                'checked': 'onCheckedChanged',\n                'value': 'onExtendedValueChanged'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initConfig: function (config) {\n            this._super();\n\n            if (!config.elementTmpl) {\n                if (!this.prefer && !this.multiple) {\n                    this.elementTmpl = this.templates.radio;\n                } else if (this.prefer === 'radio') {\n                    this.elementTmpl = this.templates.radio;\n                } else if (this.prefer === 'checkbox') {\n                    this.elementTmpl = this.templates.checkbox;\n                } else if (this.prefer === 'toggle') {\n                    this.elementTmpl = this.templates.toggle;\n                } else {\n                    this.elementTmpl = this.templates.checkbox;\n                }\n            }\n\n            if (this.prefer === 'toggle' && _.isEmpty(this.toggleLabels)) {\n                this.toggleLabels = {\n                    'on': $t('Yes'),\n                    'off': $t('No')\n                };\n            }\n\n            if (typeof this.default === 'undefined' || this.default === null) {\n                this.default = '';\n            }\n\n            if (typeof this.value === 'undefined' || this.value === null) {\n                this.value = _.isEmpty(this.valueMap) || this.default !== '' ? this.default : this.valueMap.false;\n                this.initialValue = this.value;\n            } else {\n                this.initialValue = this.value;\n            }\n\n            if (this.multiple && !_.isArray(this.value)) {\n                this.value = []; // needed for correct observable assignment\n            }\n\n            this.initialChecked = this.checked;\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe('checked');\n        },\n\n        /**\n         * Get true/false key from valueMap by value.\n         *\n         * @param {*} value\n         * @returns {Boolean|undefined}\n         */\n        getReverseValueMap: function getReverseValueMap(value) {\n            var bool = false;\n\n            _.some(this.valueMap, function (iValue, iBool) {\n                if (iValue === value) {\n                    bool = iBool === 'true';\n\n                    return true;\n                }\n            });\n\n            return bool;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        setInitialValue: function () {\n            if (_.isEmpty(this.valueMap)) {\n                this.on('value', this.onUpdate.bind(this));\n            } else {\n                this._super();\n                this.checked(this.getReverseValueMap(this.value()));\n            }\n\n            return this;\n        },\n\n        /**\n         * Handle dataScope changes for checkbox / radio button.\n         *\n         * @param {*} newExportedValue\n         */\n        onExtendedValueChanged: function (newExportedValue) {\n            var isMappedUsed = !_.isEmpty(this.valueMap),\n                oldChecked = this.checked.peek(),\n                oldValue = this.initialValue,\n                newChecked;\n\n            if (this.multiple) {\n                newChecked = newExportedValue.indexOf(oldValue) !== -1;\n            } else if (isMappedUsed) {\n                newChecked = this.getReverseValueMap(newExportedValue);\n            } else if (typeof newExportedValue === 'boolean') {\n                newChecked = newExportedValue;\n            } else {\n                newChecked = newExportedValue === oldValue;\n            }\n\n            if (newChecked !== oldChecked) {\n                this.checked(newChecked);\n            }\n        },\n\n        /**\n         * Handle checked state changes for checkbox / radio button.\n         *\n         * @param {Boolean} newChecked\n         */\n        onCheckedChanged: function (newChecked) {\n            var isMappedUsed = !_.isEmpty(this.valueMap),\n                oldValue = this.initialValue,\n                newValue;\n\n            if (isMappedUsed) {\n                newValue = this.valueMap[newChecked];\n            } else {\n                newValue = oldValue;\n            }\n\n            if (!this.multiple && newChecked) {\n                this.value(newValue);\n            } else if (!this.multiple && !newChecked) {\n                if (typeof newValue === 'boolean') {\n                    this.value(newChecked);\n                } else if (newValue === this.value.peek()) {\n                    this.value('');\n                }\n\n                if (isMappedUsed) {\n                    this.value(newValue);\n                }\n            } else if (this.multiple && newChecked && this.value.indexOf(newValue) === -1) {\n                this.value.push(newValue);\n            } else if (this.multiple && !newChecked && this.value.indexOf(newValue) !== -1) {\n                this.value.splice(this.value.indexOf(newValue), 1);\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onUpdate: function () {\n            if (this.hasUnique) {\n                this.setUnique();\n            }\n\n            return this._super();\n        },\n\n        /**\n         * @inheritdoc\n         */\n        reset: function () {\n            if (this.multiple && this.initialChecked) {\n                this.value.push(this.initialValue);\n            } else if (this.multiple && !this.initialChecked) {\n                this.value.splice(this.value.indexOf(this.initialValue), 1);\n            } else {\n                this.value(this.initialValue);\n            }\n\n            this.error(false);\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        clear: function () {\n            if (this.multiple) {\n                this.value([]);\n            } else {\n                this.value('');\n            }\n\n            this.error(false);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/element/text.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'uiElement',\n    'mageUtils'\n], function (Element, utils) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            visible: true,\n            label: '',\n            error: '',\n            uid: utils.uniqueid(),\n            disabled: false,\n            links: {\n                value: '${ $.provider }:${ $.dataScope }'\n            }\n        },\n\n        /**\n         * Has service\n         *\n         * @returns {Boolean} false.\n         */\n        hasService: function () {\n            return false;\n        },\n\n        /**\n         * Has addons\n         *\n         * @returns {Boolean} false.\n         */\n        hasAddons: function () {\n            return false;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe('disabled visible value');\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/element/textarea.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    './abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            cols: 15,\n            rows: 2,\n            elementTmpl: 'ui/form/element/textarea'\n        }\n    });\n});\n","Magento_Ui/js/form/element/ui-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    './abstract',\n    'Magento_Ui/js/lib/key-codes',\n    'mage/translate',\n    'ko',\n    'jquery',\n    'Magento_Ui/js/lib/view/utils/async'\n], function (_, Abstract, keyCodes, $t, ko, $) {\n    'use strict';\n\n    var isTouchDevice = typeof document.ontouchstart !== 'undefined';\n\n    /**\n     * Processing options list\n     *\n     * @param {Array} array - Property array\n     * @param {String} separator - Level separator\n     * @param {Array} created - list to add new options\n     *\n     * @return {Array} Plain options list\n     */\n    function flattenCollection(array, separator, created) {\n        var i = 0,\n            length,\n            childCollection;\n\n        array = _.compact(array);\n        length = array.length;\n        created = created || [];\n\n        for (i; i < length; i++) {\n            created.push(array[i]);\n\n            if (array[i].hasOwnProperty(separator)) {\n                childCollection = array[i][separator];\n                delete array[i][separator];\n                flattenCollection.call(this, childCollection, separator, created);\n            }\n        }\n\n        return created;\n    }\n\n    /**\n     * Set levels to options list\n     *\n     * @param {Array} array - Property array\n     * @param {String} separator - Level separator\n     * @param {Number} level - Starting level\n     * @param {String} path - path to root\n     *\n     * @returns {Array} Array with levels\n     */\n    function setProperty(array, separator, level, path) {\n        var i = 0,\n            length,\n            nextLevel,\n            nextPath;\n\n        array = _.compact(array);\n        length = array.length;\n        level = level || 0;\n        path = path || '';\n\n        for (i; i < length; i++) {\n            if (array[i]) {\n                _.extend(array[i], {\n                    level: level,\n                    path: path\n                });\n            }\n\n            if (array[i].hasOwnProperty(separator)) {\n                nextLevel = level + 1;\n                nextPath = path ? path + '.' + array[i].label : array[i].label;\n                setProperty.call(this, array[i][separator], separator, nextLevel, nextPath);\n            }\n        }\n\n        return array;\n    }\n\n    /**\n     * Preprocessing options list\n     *\n     * @param {Array} nodes - Options list\n     *\n     * @return {Object} Object with property - options(options list)\n     *      and cache options with plain and tree list\n     */\n    function parseOptions(nodes) {\n        var caption,\n            value,\n            cacheNodes,\n            copyNodes;\n\n        nodes = setProperty(nodes, 'optgroup');\n        copyNodes = JSON.parse(JSON.stringify(nodes));\n        cacheNodes = flattenCollection(copyNodes, 'optgroup');\n\n        nodes = _.map(nodes, function (node) {\n            value = node.value;\n\n            if (value == null || value === '') {\n                if (_.isUndefined(caption)) {\n                    caption = node.label;\n                }\n            } else {\n                return node;\n            }\n        });\n\n        return {\n            options: _.compact(nodes),\n            cacheOptions: {\n                plain: _.compact(cacheNodes),\n                tree: _.compact(nodes)\n            }\n        };\n    }\n\n    return Abstract.extend({\n        defaults: {\n            options: [],\n            total: 0,\n            listVisible: false,\n            value: [],\n            filterOptions: false,\n            chipsEnabled: true,\n            itemsQuantity: '',\n            filterInputValue: '',\n            filterOptionsFocus: false,\n            multiselectFocus: false,\n            multiple: true,\n            selectType: 'tree',\n            lastSelectable: false,\n            showFilteredQuantity: true,\n            showCheckbox: true,\n            levelsVisibility: true,\n            openLevelsAction: true,\n            showOpenLevelsActionIcon: true,\n            optgroupLabels: false,\n            closeBtn: true,\n            showPath: true,\n            labelsDecoration: false,\n            disableLabel: false,\n            filterRateLimit: 500,\n            filterRateLimitMethod: 'notifyAtFixedRate',\n            closeBtnLabel: $t('Done'),\n            optgroupTmpl: 'ui/grid/filters/elements/ui-select-optgroup',\n            quantityPlaceholder: $t('options'),\n            hoverClass: '_hover',\n            rootListSelector: 'ul.admin__action-multiselect-menu-inner._root',\n            visibleOptionSelector: 'li.admin__action-multiselect-menu-inner-item:visible',\n            actionTargetSelector: '.action-menu-item',\n            selectedPlaceholders: {\n                defaultPlaceholder: $t('Select...'),\n                lotPlaceholders: $t('Selected')\n            },\n            separator: 'optgroup',\n            searchOptions: false,\n            loading: false,\n            searchUrl: false,\n            lastSearchKey: '',\n            lastSearchPage: 1,\n            filterPlaceholder: '',\n            emptyOptionsHtml: '',\n            cachedSearchResults: {},\n            pageLimit: 50,\n            deviation: 30,\n            validationLoading: false,\n            isRemoveSelectedIcon: false,\n            debounce: 300,\n            missingValuePlaceholder: $t('Entity with ID: %s doesn\\'t exist'),\n            isDisplayMissingValuePlaceholder: false,\n            currentSearchKey: '',\n            listens: {\n                listVisible: 'cleanHoveredElement',\n                filterInputValue: 'filterOptionsList',\n                options: 'checkOptionsList'\n            },\n            presets: {\n                single: {\n                    showCheckbox: false,\n                    chipsEnabled: false,\n                    closeBtn: false\n                },\n                optgroup: {\n                    showCheckbox: false,\n                    lastSelectable: true,\n                    optgroupLabels: true,\n                    openLevelsAction: false,\n                    labelsDecoration: true,\n                    showOpenLevelsActionIcon: false\n                }\n            }\n        },\n\n        /**\n         * Initializes UISelect component.\n         *\n         * @returns {UISelect} Chainable.\n         */\n        initialize: function () {\n            this._super();\n\n            $.async(\n                this.rootListSelector,\n                this,\n                this.onRootListRender.bind(this)\n            );\n\n            return this;\n        },\n\n        /**\n         * Parses options and merges the result with instance\n         * Set defaults according to mode and levels configuration\n         *\n         * @param  {Object} config\n         * @returns {Object} Chainable.\n         */\n        initConfig: function (config) {\n            var result = parseOptions(config.options),\n                defaults = this.constructor.defaults,\n                multiple = _.isBoolean(config.multiple) ? config.multiple : defaults.multiple,\n                type = config.selectType || defaults.selectType,\n                showOpenLevelsActionIcon = _.isBoolean(config.showOpenLevelsActionIcon) ?\n                    config.showOpenLevelsActionIcon :\n                    defaults.showOpenLevelsActionIcon,\n                openLevelsAction = _.isBoolean(config.openLevelsAction) ?\n                    config.openLevelsAction :\n                    defaults.openLevelsAction;\n\n            multiple = !multiple ? 'single' : false;\n            config.showOpenLevelsActionIcon = showOpenLevelsActionIcon && openLevelsAction;\n            _.extend(config, result, defaults.presets[multiple], defaults.presets[type]);\n            this._super();\n\n            return this;\n        },\n\n        /**\n         * Check child optgroup\n         */\n        hasChildList: function () {\n            return _.find(this.options(), function (option) {\n                return !!option[this.separator];\n            }, this);\n        },\n\n        /**\n         * Check tree mode\n         */\n        isTree: function () {\n            return this.hasChildList() && this.selectType !== 'optgroup';\n        },\n\n        /**\n         * Add option to lastOptions array\n         *\n         * @param {Object} data\n         * @returns {Boolean}\n         */\n        addLastElement: function (data) {\n            if (!data.hasOwnProperty(this.separator)) {\n                !this.cacheOptions.lastOptions ? this.cacheOptions.lastOptions = [] : false;\n\n                if (!_.findWhere(\n                    this.cacheOptions.lastOptions,\n                        {\n                            value: data.value\n                        }\n                    )\n                ) {\n                    this.cacheOptions.lastOptions.push(data);\n                }\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Return empty options html\n         */\n        getEmptyOptionsUnsanitizedHtml: function () {\n            return this.emptyOptionsHtml;\n        },\n\n        /**\n         * Check options length and set to cache\n         * if some options is added\n         *\n         * @param {Array} options - ui select options\n         */\n        checkOptionsList: function (options) {\n            if (options.length > this.cacheOptions.plain.length) {\n                this.cacheOptions.plain = options;\n                this.setCaption();\n            }\n        },\n\n        /**\n         * Check label decoration\n         */\n        isLabelDecoration: function (data) {\n            return data.hasOwnProperty(this.separator) && this.labelsDecoration;\n        },\n\n        /**\n         * Calls 'initObservable' of parent, initializes 'options' and 'initialOptions'\n         *     properties, calls 'setOptions' passing options to it\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n            this.observe([\n                'listVisible',\n                'placeholder',\n                'multiselectFocus',\n                'options',\n                'itemsQuantity',\n                'filterInputValue',\n                'filterOptionsFocus',\n                'loading',\n                'validationLoading',\n                'isDisplayMissingValuePlaceholder'\n            ]);\n\n            this.filterInputValue.extend({\n                rateLimit: {\n                    timeout: this.filterRateLimit,\n                    method: this.filterRateLimitMethod\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * object with key - keyname and value - handler function for this key\n         *\n         * @returns {Object} Object with handlers function name.\n         */\n        keyDownHandlers: function () {\n            return {\n                enterKey: this.enterKeyHandler,\n                escapeKey: this.escapeKeyHandler,\n                spaceKey: this.enterKeyHandler,\n                pageUpKey: this.pageUpKeyHandler,\n                pageDownKey: this.pageDownKeyHandler\n            };\n        },\n\n        /**\n         * Processing level visibility for levels\n         *\n         * @param {Object} data - element data\n         *\n         * @returns {Boolean} level visibility.\n         */\n        showLevels: function (data) {\n            var curLevel = ++data.level,\n                isVisible;\n\n            if (data.visible) {\n                isVisible = data.visible();\n            } else {\n                isVisible = !!data.hasOwnProperty(this.separator) &&\n                    _.isBoolean(this.levelsVisibility) &&\n                    this.levelsVisibility ||\n                    data.hasOwnProperty(this.separator) && parseInt(this.levelsVisibility, 10) >= curLevel;\n\n                data.visible = ko.observable(isVisible);\n                data.isVisited = isVisible;\n            }\n\n            return isVisible;\n        },\n\n        /**\n         * Processing level visibility for levels\n         *\n         * @param {Object} data - element data\n         *\n         * @returns {Boolean} level visibility.\n         */\n        getLevelVisibility: function (data) {\n            if (data.visible) {\n                return data.visible();\n            }\n\n            return this.showLevels(data);\n        },\n\n        /**\n         * Set option to options array.\n         *\n         * @param {Object} option\n         * @param {Array} options\n         */\n        setOption: function (option, options) {\n            var copyOptionsTree;\n\n            options = options || this.cacheOptions.tree;\n\n            _.each(options, function (opt) {\n                if (opt.value == option.parent) { //eslint-disable-line eqeqeq\n                    delete  option.parent;\n                    opt[this.separator] ? opt[this.separator].push(option) : opt[this.separator] = [option];\n                    copyOptionsTree = JSON.parse(JSON.stringify(this.cacheOptions.tree));\n                    this.cacheOptions.plain = flattenCollection(copyOptionsTree, this.separator);\n                    this.options(this.cacheOptions.tree);\n                } else if (opt[this.separator]) {\n                    this.setOption(option, opt[this.separator]);\n                }\n            }, this);\n        },\n\n        /**\n         * Handler outerClick event. Closed options list\n         */\n        outerClick: function () {\n            this.listVisible() ? this.listVisible(false) : false;\n\n            if (isTouchDevice) {\n                this.multiselectFocus(false);\n            }\n        },\n\n        /**\n         * Handler keydown event to filter options input\n         *\n         * @returns {Boolean} Returned true for emersion events\n         */\n        filterOptionsKeydown: function (data, event) {\n            var key = keyCodes[event.keyCode];\n\n            !this.isTabKey(event) ? event.stopPropagation() : false;\n\n            if (key === 'pageDownKey' || key === 'pageUpKey') {\n                event.preventDefault();\n                this.filterOptionsFocus(false);\n                this.cacheUiSelect.focus();\n            }\n\n            this.keydownSwitcher(data, event);\n\n            return true;\n        },\n\n        /**\n         * Filtered options list by value from filter options list\n         */\n        filterOptionsList: function () {\n            var value = this.filterInputValue().trim().toLowerCase(),\n                array = [];\n\n            if (this.searchOptions) {\n                return this.loadOptions(value);\n            }\n\n            this.cleanHoveredElement();\n\n            if (!value) {\n                this.renderPath = false;\n                this.options(this.cacheOptions.tree);\n                this._setItemsQuantity(false);\n\n                return false;\n            }\n\n            this.showPath ? this.renderPath = true : false;\n\n            if (this.filterInputValue()) {\n\n                array = this.selectType === 'optgroup' ?\n                    this._getFilteredArray(this.cacheOptions.lastOptions, value) :\n                    this._getFilteredArray(this.cacheOptions.plain, value);\n\n                if (!value.length) {\n                    this.options(this.cacheOptions.plain);\n                    this._setItemsQuantity(this.cacheOptions.plain.length);\n                } else {\n                    this.options(array);\n                    this._setItemsQuantity(array.length);\n                }\n\n                return false;\n            }\n\n            this.options(this.cacheOptions.plain);\n        },\n\n        /**\n         * Filtered options list by value from filter options list\n         *\n         * @param {Array} list - option list\n         * @param {String} value\n         *\n         * @returns {Array} filters result\n         */\n        _getFilteredArray: function (list, value) {\n            var i = 0,\n                array = [],\n                curOption;\n\n            for (i; i < list.length; i++) {\n                curOption = list[i].label.toLowerCase();\n\n                if (curOption.indexOf(value) > -1) {\n                    array.push(list[i]); /*eslint max-depth: [2, 4]*/\n                }\n            }\n\n            return array;\n        },\n\n        /**\n         * Get path to current option\n         *\n         * @param {Object} data - option data\n         * @returns {String} path\n         */\n        getPath: function (data) {\n            var pathParts,\n                createdPath = '';\n\n            if (this.renderPath) {\n                pathParts = data.path.split('.');\n                _.each(pathParts, function (curData) {\n                    createdPath = createdPath ? createdPath + ' / ' + curData : curData;\n                });\n\n                return createdPath;\n            }\n        },\n\n        /**\n         * Set filtered items quantity\n         *\n         * @param {Object} data - option data\n         */\n        _setItemsQuantity: function (data) {\n            if (this.showFilteredQuantity) {\n                data || parseInt(data, 10) === 0 ?\n                    this.itemsQuantity(this.getItemsPlaceholder(data)) :\n                    this.itemsQuantity('');\n            }\n        },\n\n        /**\n         * Return formatted items placeholder.\n         *\n         * @param {Object} data - option data\n         * @returns {String}\n         */\n        getItemsPlaceholder: function (data) {\n            return data + ' ' + this.quantityPlaceholder;\n        },\n\n        /**\n         * Remove element from selected array\n         */\n        removeSelected: function (value, data, event) {\n            event ? event.stopPropagation() : false;\n            this.value.remove(value);\n        },\n\n        /**\n         * Checked key name\n         *\n         * @returns {Boolean}\n         */\n        isTabKey: function (event) {\n            return keyCodes[event.keyCode] === 'tabKey';\n        },\n\n        /**\n         * Clean hoveredElement variable\n         *\n         * @returns {Object} Chainable\n         */\n        cleanHoveredElement: function () {\n            if (this.hoveredElement) {\n                $(this.hoveredElement)\n                    .children(this.actionTargetSelector)\n                    .removeClass(this.hoverClass);\n\n                this.hoveredElement = null;\n            }\n\n            return this;\n        },\n\n        /**\n         * Check selected option\n         *\n         * @param {String} value - option value\n         * @return {Boolean}\n         */\n        isSelected: function (value) {\n            return this.multiple ? _.contains(this.value(), value) : this.value() === value;\n        },\n\n        /**\n         * Check selected option\n         *\n         * @param {Object} option - option value\n         * @return {Boolean}\n         */\n        isSelectedValue: function (option) {\n            if (_.isUndefined(option)) {\n                return false;\n            }\n\n            return this.isSelected(option.value);\n        },\n\n        /**\n         * Check optgroup label\n         *\n         * @param {Object} data - element data\n         * @return {Boolean}\n         */\n        isOptgroupLabels: function (data) {\n            return data.hasOwnProperty(this.separator) && this.optgroupLabels;\n        },\n\n        /**\n         * Check hovered option\n         *\n         * @param {Object} data - element data\n         * @return {Boolean}\n         */\n        isHovered: function (data) {\n            var element = this.hoveredElement,\n                elementData;\n\n            if (!element) {\n                return false;\n            }\n\n            elementData = ko.dataFor(this.hoveredElement);\n\n            if (_.isUndefined(elementData)) {\n                return false;\n            }\n\n            return data.value === elementData.value;\n        },\n\n        /**\n         * Toggle list visibility\n         *\n         * @returns {Object} Chainable\n         */\n        toggleListVisible: function () {\n            this.listVisible(!this.disabled() && !this.listVisible());\n\n            return this;\n        },\n\n        /**\n         * Get selected element labels\n         *\n         * @returns {Array} array labels\n         */\n        getSelected: function () {\n            var selected = this.value();\n\n            return this.cacheOptions.plain.filter(function (opt) {\n                return _.isArray(selected) ?\n                    _.contains(selected, opt.value) :\n                selected == opt.value;//eslint-disable-line eqeqeq\n            });\n        },\n\n        /**\n         * Toggle activity list element\n         *\n         * @param {Object} data - selected option data\n         * @returns {Object} Chainable\n         */\n        toggleOptionSelected: function (data) {\n            var isSelected = this.isSelected(data.value);\n\n            if (this.lastSelectable && data.hasOwnProperty(this.separator)) {\n                return this;\n            }\n\n            if (!this.multiple) {\n                if (!isSelected) {\n                    this.value(data.value);\n                }\n                this.listVisible(false);\n            } else {\n                if (!isSelected) { /*eslint no-lonely-if: 0*/\n                    this.value.push(data.value);\n                } else {\n                    this.value(_.without(this.value(), data.value));\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Change visibility to child level\n         *\n         * @param {Object} data - element data\n         */\n        openChildLevel: function (data) {\n            var contextElement = data,\n                isVisible;\n\n            if (\n                this.openLevelsAction &&\n                data.hasOwnProperty(this.separator) && _.isBoolean(this.levelsVisibility) ||\n                this.openLevelsAction &&\n                data.hasOwnProperty(this.separator) && parseInt(this.levelsVisibility, 10) <= data.level\n            ) {\n                isVisible = !contextElement.visible();\n\n                if (isVisible && !contextElement.isVisited) {\n                    contextElement.isVisited = true;\n                }\n\n                contextElement.visible(isVisible);\n            }\n        },\n\n        /**\n         * Check selected elements\n         *\n         * @returns {Boolean}\n         */\n        hasData: function () {\n            if (!this.value()) {\n                this.value([]);\n            }\n\n            return this.value() ? !!this.value().length : false;\n        },\n\n        /**\n         * Handles hover on list items.\n         *\n         * @param {Object} event - mousemove event\n         */\n        onDelegatedMouseMove: function (event) {\n            var target = $(event.currentTarget).closest(this.visibleOptionSelector)[0];\n\n            if (this.isCursorPositionChange(event) || this.hoveredElement === target) {\n                return;\n            }\n\n            this._hoverTo(target);\n            this.setCursorPosition(event);\n        },\n\n        /**\n         * Get option index\n         *\n         * @param {Object} data - object with data about this element\n         *\n         * @returns {Number}\n         */\n        getOptionIndex: function (data) {\n            var index;\n\n            _.each(this.cacheOptions.plain, function (opt, id) {\n                if (data.value === opt.value) {\n                    index = id;\n                }\n            });\n\n            return index;\n        },\n\n        /**\n         * Set X and Y cursor position\n         *\n         * @param {Object} event - mousemove event\n         */\n        setCursorPosition: function (event) {\n            this.cursorPosition = {\n                x: event.pageX,\n                y: event.pageY\n            };\n        },\n\n        /**\n         * Check previous and current cursor position\n         *\n         * @param {Object} event - mousemove event\n         * @returns {Boolean}\n         */\n        isCursorPositionChange: function (event) {\n            return this.cursorPosition &&\n                this.cursorPosition.x === event.pageX &&\n                this.cursorPosition.y === event.pageY;\n        },\n\n        /**\n         * Set true to observable variable multiselectFocus\n         * @param {Object} ctx\n         * @param {Object} event - focus event\n         */\n        onFocusIn: function (ctx, event) {\n            !this.cacheUiSelect ? this.cacheUiSelect = event.target : false;\n            this.multiselectFocus(true);\n        },\n\n        /**\n         * Set false to observable variable multiselectFocus\n         * and close list\n         */\n        onFocusOut: function () {\n            this.multiselectFocus(false);\n        },\n\n        /**\n         * Handler enter key, if select list is closed - open select,\n         * if select list is open toggle selected current option\n         */\n        enterKeyHandler: function () {\n\n            if (this.filterOptionsFocus()) {\n                return false;\n            }\n\n            if (this.listVisible()) {\n                if (this.hoveredElement) {\n                    this.toggleOptionSelected(ko.dataFor(this.hoveredElement));\n                }\n            } else {\n                this.setListVisible(true);\n            }\n        },\n\n        /**\n         * Handler escape key, if select list is open - closes it,\n         */\n        escapeKeyHandler: function () {\n            this.listVisible() ? this.setListVisible(false) : false;\n        },\n\n        /**\n         * Handler pageDown key, selected next option in list, if current option is last\n         * selected first option in list\n         */\n        pageDownKeyHandler: function () {\n            this._setHoverToElement(1);\n        },\n\n        /**\n         * Get jQuery element by option data\n         *\n         * @param {Object} data - option data\n         *\n         * @returns {Object} jQuery element\n         */\n        _getElemByData: function (data) {\n            var i = 0,\n                list = $(this.cacheUiSelect).find('li'),\n                length = this.options().length,\n                result;\n\n            for (i; i < length; i++) {\n                if (this.options()[i].value === data.value) {\n                    result = $(list[i]);\n                }\n            }\n\n            return result;\n        },\n\n        /**\n         * Set hover to visible element\n         *\n         * @param {Number} direction - iterator\n         */\n        _setHoverToElement: function (direction) {\n            var element;\n\n            if (direction ===  1) {\n                element = this._getNextElement();\n            } else if (direction === -1) {\n                element = this._getPreviousElement();\n            }\n\n            if (element) {\n                this._hoverTo(element);\n                this._scrollTo(element);\n            }\n        },\n\n        /**\n         * Find current hovered element\n         * and change scroll position\n         *\n         * @param {Number} element - element index\n         */\n        _scrollTo: function (element) {\n            var curEl = $(element).children(this.actionTargetSelector),\n                wrapper = $(this.rootList),\n                curElPos = {},\n                wrapperPos = {};\n\n            curElPos.start = curEl.offset().top;\n            curElPos.end = curElPos.start + curEl.outerHeight();\n\n            wrapperPos.start = wrapper.offset().top;\n            wrapperPos.end = wrapperPos.start + wrapper.height();\n\n            if (curElPos.start < wrapperPos.start) {\n                wrapper.scrollTop(wrapper.scrollTop() - (wrapperPos.start - curElPos.start));\n            } else if (curElPos.end > wrapperPos.end) {\n                wrapper.scrollTop(wrapper.scrollTop() + curElPos.end - wrapperPos.end);\n            }\n        },\n\n        /**\n         * Handler pageUp key, selected previous option in list, if current option is first -\n         * selected last option in list\n         */\n        pageUpKeyHandler: function () {\n            this._setHoverToElement(-1);\n        },\n\n        /**\n         * Switcher to parse keydown event and delegate event to needful method\n         *\n         * @param {Object} data - element data\n         * @param {Object} event - keydown event\n         * @returns {Boolean} if handler for this event doesn't found return true\n         */\n        keydownSwitcher: function (data, event) {\n            var keyName = keyCodes[event.keyCode];\n\n            if (this.isTabKey(event)) {\n                if (!this.filterOptionsFocus() && this.listVisible() && this.filterOptions) {\n                    this.cacheUiSelect.trigger('blur');\n                    this.filterOptionsFocus(true);\n                    this.cleanHoveredElement();\n\n                    return false;\n                }\n                this.listVisible(false);\n\n                return true;\n            }\n\n            if (this.keyDownHandlers().hasOwnProperty(keyName)) {\n                this.keyDownHandlers()[keyName].apply(this, arguments);\n            } else {\n                return true;\n            }\n        },\n\n        /**\n         * Set caption\n         */\n        setCaption: function () {\n            var length, caption = '';\n\n            if (!_.isArray(this.value()) && this.value()) {\n                length = 1;\n            } else if (this.value()) {\n                length = this.value().length;\n            } else {\n                this.value([]);\n                length = 0;\n            }\n            this.warn(caption);\n\n            //check if option was removed\n            if (this.isDisplayMissingValuePlaceholder && length && !this.getSelected().length) {\n                caption = this.missingValuePlaceholder.replace('%s', this.value());\n                this.placeholder(caption);\n                this.warn(caption);\n\n                return this.placeholder();\n            }\n\n            if (length > 1) {\n                this.placeholder(length + ' ' + this.selectedPlaceholders.lotPlaceholders);\n            } else if (length && this.getSelected().length) {\n                this.placeholder(this.getSelected()[0].label);\n            } else {\n                this.placeholder(this.selectedPlaceholders.defaultPlaceholder);\n            }\n\n            return this.placeholder();\n        },\n\n        /**\n         * Set list status, open or close\n         *\n         * @param {Boolean} value - variable for set list visible status\n         */\n        setListVisible: function (value) {\n            this.listVisible(value);\n        },\n\n        /**\n         * Processes preview for option by it's value, and sets the result\n         * to 'preview' observable\n         *\n         * @returns {String}\n         */\n        getPreview: function () {\n            var selected = this.getSelected();\n\n            return selected.map(function (option) {\n                return option.label;\n            }).join(', ');\n        },\n\n        /**\n         * Defines previous option element to\n         * the one that is currently hovered.\n         *\n         * @returns {Element}\n         */\n        _getPreviousElement: function () {\n            var currentElement = this.hoveredElement,\n                lastElement    = this._getLastIn(this.rootList),\n                previousElement;\n\n            if (!currentElement) {\n                return lastElement;\n            }\n\n            previousElement = $(currentElement).prev()[0];\n\n            return this._getLastIn(previousElement) ||\n                previousElement ||\n                this._getFirstParentOf(currentElement) ||\n                lastElement;\n        },\n\n        /**\n         * Defines next option element to\n         * the one that is currently hovered.\n         *\n         * @returns {Element}\n         */\n        _getNextElement: function () {\n            var currentElement = this.hoveredElement,\n                firstElement   = this._getFirstIn(this.rootList);\n\n            if (!currentElement) {\n                return firstElement;\n            }\n\n            return this._getFirstIn(currentElement) ||\n                $(currentElement).next()[0] ||\n                this._getParentsOf(currentElement).next()[0] ||\n                firstElement;\n        },\n\n        /**\n         * Returns first option element in provided scope.\n         *\n         * @param {Element} scope\n         * @returns {Element}\n         */\n        _getFirstIn: function (scope) {\n            return $(scope).find(this.visibleOptionSelector)[0];\n        },\n\n        /**\n         * Returns last descendant option element in provided scope.\n         *\n         * @param {Element} scope\n         * @returns {Element}\n         */\n        _getLastIn: function (scope) {\n            return $(scope).find(this.visibleOptionSelector).last()[0];\n        },\n\n        /**\n         * Returns a collection of parent option elements.\n         *\n         * @param {Element} scope\n         * @returns {jQueryCollection}\n         */\n        _getParentsOf: function (scope) {\n            return $(scope).parents(this.visibleOptionSelector);\n        },\n\n        /**\n         * Returns first parent option element.\n         *\n         * @param {Element} scope\n         * @returns {Element}\n         */\n        _getFirstParentOf: function (scope) {\n            return this._getParentsOf(scope)[0];\n        },\n\n        /**\n         * Sets hover class to provided option element.\n         *\n         * @param {Element} element\n         */\n        _hoverTo: function (element) {\n            if (this.hoveredElement) {\n                $(this.hoveredElement)\n                    .children(this.actionTargetSelector)\n                    .removeClass(this.hoverClass);\n            }\n\n            $(element)\n                .children(this.actionTargetSelector)\n                .addClass(this.hoverClass);\n\n            this.hoveredElement = element;\n        },\n\n        /**\n         * Callback which fires when root list element is rendered.\n         *\n         * @param {Element} element\n         */\n        onRootListRender: function (element) {\n            var targetSelector = 'li > ' + this.actionTargetSelector;\n\n            this.rootList = element;\n\n            $(this.rootList).on(\n                'mousemove',\n                targetSelector,\n                this.onDelegatedMouseMove.bind(this)\n            );\n        },\n\n        /**\n         * Returns options from cache or send request\n         *\n         * @param {String} searchKey\n         */\n        loadOptions: function (searchKey) {\n            var currentPage = searchKey === this.lastSearchKey ? this.lastSearchPage + 1 : 1,\n                cachedSearchResult;\n\n            this.renderPath = !!this.showPath;\n\n            if (this.isSearchKeyCached(searchKey)) {\n                cachedSearchResult = this.getCachedSearchResults(searchKey);\n                this.cacheOptions.plain = cachedSearchResult.options;\n                this.options(cachedSearchResult.options);\n                this.afterLoadOptions(searchKey, cachedSearchResult.lastPage, cachedSearchResult.total);\n\n                return;\n            }\n\n            if (currentPage === 1) {\n                this.options([]);\n            }\n            this.processRequest(searchKey, currentPage);\n        },\n\n        /**\n         * Load more options on scroll down\n         * @param {Object} data\n         * @param {Event} event\n         */\n        onScrollDown: function (data, event) {\n            var clientHight = event.target.scrollTop + event.target.clientHeight,\n                scrollHeight = event.target.scrollHeight;\n\n            if (!this.searchOptions) {\n                return;\n            }\n\n            if (clientHight > scrollHeight - this.deviation && !this.isSearchKeyCached(data.filterInputValue())) {\n                this.loadOptions(data.filterInputValue());\n            }\n        },\n\n        /**\n         * Returns cached search result by search key\n         *\n         * @param {String} searchKey\n         * @return {Object}\n         */\n        getCachedSearchResults: function (searchKey) {\n            if (this.cachedSearchResults.hasOwnProperty(searchKey)) {\n                return this.cachedSearchResults[searchKey];\n            }\n\n            return {\n                options: [],\n                lastPage: 1,\n                total: 0\n            };\n        },\n\n        /**\n         * Cache loaded data\n         *\n         * @param {String} searchKey\n         * @param {Array} optionsArray\n         * @param {Number} page\n         * @param {Number} total\n         */\n        setCachedSearchResults: function (searchKey, optionsArray, page, total) {\n            var cachedData = {};\n\n            cachedData.options = optionsArray;\n            cachedData.lastPage = page;\n            cachedData.total = total;\n            this.cachedSearchResults[searchKey] = cachedData;\n        },\n\n        /**\n         * Check if search key cached\n         *\n         * @param {String} searchKey\n         * @return {Boolean}\n         */\n        isSearchKeyCached: function (searchKey) {\n            var totalCached = this.cachedSearchResults.hasOwnProperty(searchKey) ?\n                this.deviation * this.cachedSearchResults[searchKey].lastPage :\n                0;\n\n            return totalCached > 0 && totalCached >= this.cachedSearchResults[searchKey].total;\n        },\n\n        /**\n         * Submit request to load data\n         *\n         * @param {String} searchKey\n         * @param {Number} page\n         */\n        processRequest: function (searchKey, page) {\n            this.loading(true);\n            this.currentSearchKey = searchKey;\n            $.ajax({\n                url: this.searchUrl,\n                type: 'get',\n                dataType: 'json',\n                context: this,\n                data: {\n                    searchKey: searchKey,\n                    page: page,\n                    limit: this.pageLimit\n                },\n                success: $.proxy(this.success, this),\n                error: $.proxy(this.error, this),\n                beforeSend: $.proxy(this.beforeSend, this),\n                complete: $.proxy(this.complete, this, searchKey, page)\n            });\n        },\n\n        /** @param {Object} response */\n        success: function (response) {\n            var existingOptions = this.options();\n\n            _.each(response.options, function (opt) {\n                existingOptions.push(opt);\n            });\n\n            this.total = response.total;\n            this.cacheOptions.plain = existingOptions;\n            this.options(existingOptions);\n        },\n\n        /** add actions before ajax request */\n        beforeSend: function () {\n\n        },\n\n        /** set empty array if error occurs */\n        error: function () {\n            this.options([]);\n        },\n\n        /** cache options and stop loading*/\n        complete: function (searchKey, page) {\n            this.setCachedSearchResults(searchKey, this.options(), page, this.total);\n            this.afterLoadOptions(searchKey, page, this.total);\n        },\n\n        /**\n         * Stop loading and update data after options were updated\n         *\n         * @param {String} searchKey\n         * @param {Number} page\n         * @param {Number} total\n         */\n        afterLoadOptions: function (searchKey, page, total) {\n            this.lastSearchKey = searchKey;\n            this.lastSearchPage = page;\n            this._setItemsQuantity(total);\n            this.loading(false);\n        }\n    });\n});\n","Magento_Ui/js/form/element/url-input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiLayout',\n    'mage/translate',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, layout, $t, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            linkedElement: {},\n            settingTemplate: 'ui/form/element/urlInput/setting',\n            typeSelectorTemplate: 'ui/form/element/urlInput/typeSelector',\n            options: [],\n            linkedElementInstances: {},\n            //checkbox\n            isDisplayAdditionalSettings: true,\n            settingValue: false,\n            settingLabel: $t('Open in new tab'),\n            tracks: {\n                linkedElement: true\n            },\n            baseLinkSetting: {\n                namePrefix: '${$.name}.',\n                dataScopePrefix: '${$.dataScope}.',\n                provider: '${$.provider}'\n            },\n            urlTypes: {},\n            listens: {\n                settingValue: 'checked',\n                disabled: 'hideLinkedElement',\n                linkType: 'createChildUrlInputComponent'\n            },\n            links: {\n                linkType: '${$.provider}:${$.dataScope}.type',\n                settingValue: '${$.provider}:${$.dataScope}.setting'\n            }\n        },\n\n        /** @inheritdoc */\n        initConfig: function (config) {\n            var processedLinkTypes = {},\n                baseLinkType = this.constructor.defaults.baseLinkSetting;\n\n            _.each(config.urlTypes, function (linkSettingsArray, linkName) {\n                //add link name by link type\n                linkSettingsArray.name = baseLinkType.namePrefix + linkName;\n                linkSettingsArray.dataScope = baseLinkType.dataScopePrefix + linkName;\n                linkSettingsArray.type = linkName;\n                linkSettingsArray.disabled = config.disabled;\n                linkSettingsArray.visible = config.visible;\n                processedLinkTypes[linkName] = {};\n                _.extend(processedLinkTypes[linkName], baseLinkType, linkSettingsArray);\n            });\n            _.extend(this.constructor.defaults.urlTypes, processedLinkTypes);\n\n            this._super();\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe('componentTemplate options value linkType settingValue checked isDisplayAdditionalSettings')\n                .setOptions();\n\n            return this;\n        },\n\n        /**\n         * Set options to select based on link types configuration\n         *\n         * @return {Object}\n         */\n        setOptions: function () {\n            var result = [];\n\n            _.each(this.urlTypes, function (option, key) {\n                result.push({\n                    value: key,\n                    label: option.label,\n                    sortOrder: option.sortOrder || 0\n                });\n            });\n\n            //sort options by sortOrder\n            result.sort(function (a, b) {\n                return a.sortOrder > b.sortOrder ? 1 : -1;\n            });\n\n            this.options(result);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        setPreview: function (visible) {\n            this.linkedElement().visible(visible);\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @param {Boolean} disabled\n         */\n        hideLinkedElement: function (disabled) {\n            this.linkedElement().disabled(disabled);\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            _.each(this.linkedElementInstances, function (value) {\n                value().destroy();\n            });\n            this._super();\n        },\n\n        /**\n         * Create child component by value\n         *\n         * @param {String} value\n         * @return void\n         */\n        createChildUrlInputComponent: function (value) {\n            var elementConfig;\n\n            if (!_.isEmpty(value) && _.isUndefined(this.linkedElementInstances[value])) {\n                elementConfig = this.urlTypes[value];\n                layout([elementConfig]);\n                this.linkedElementInstances[value] = this.requestModule(elementConfig.name);\n            }\n            this.linkedElement = this.linkedElementInstances[value];\n\n        },\n\n        /**\n         * Returns linked element to display related field in template\n         * @return String\n         */\n        getLinkedElementName: function () {\n            return this.linkedElement;\n        },\n\n        /**\n         * Add ability to choose check box by clicking on label\n         */\n        checkboxClick: function () {\n            if (!this.disabled()) {\n                this.settingValue(!this.settingValue());\n            }\n        }\n    });\n});\n","Magento_Ui/js/form/element/website.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    './select'\n], function (_, registry, Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            customerId: null,\n            isGlobalScope: 0\n        },\n\n        /**\n         * Website component constructor.\n         * @returns {exports}\n         */\n        initialize: function () {\n            this._super();\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/form/element/wysiwyg.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'wysiwygAdapter',\n    'Magento_Ui/js/lib/view/utils/async',\n    'underscore',\n    'ko',\n    './abstract',\n    'mage/adminhtml/events',\n    'Magento_Variable/variables'\n], function (wysiwyg, $, _, ko, Abstract, varienGlobalEvents) {\n    'use strict';\n\n    return Abstract.extend({\n        currentWysiwyg: undefined,\n        defaults: {\n            elementSelector: 'textarea',\n            suffixRegExpPattern: '${ $.wysiwygUniqueSuffix }',\n            $wysiwygEditorButton: '',\n            links: {\n                value: '${ $.provider }:${ $.dataScope }'\n            },\n            template: 'ui/form/field',\n            elementTmpl: 'ui/form/element/wysiwyg',\n            content:        '',\n            showSpinner:    false,\n            loading:        false,\n            listens: {\n                disabled: 'setDisabled'\n            }\n        },\n\n        /**\n         *\n         * @returns {} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initNodeListener();\n\n            $.async({\n                component: this,\n                selector: 'button'\n            }, function (element) {\n                this.$wysiwygEditorButton = this.$wysiwygEditorButton ?\n                    this.$wysiwygEditorButton.add($(element)) : $(element);\n            }.bind(this));\n\n            // disable editor completely after initialization is field is disabled\n            varienGlobalEvents.attachEventHandler('wysiwygEditorInitialized', function () {\n                if (!_.isUndefined(window.tinyMceEditors)) {\n                    this.currentWysiwyg = window.tinyMceEditors[this.wysiwygId];\n                }\n\n                if (this.disabled()) {\n                    this.setDisabled(true);\n                }\n            }.bind(this));\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initConfig: function (config) {\n            var pattern = config.suffixRegExpPattern || this.constructor.defaults.suffixRegExpPattern;\n\n            pattern = pattern.replace(/\\$/g, '\\\\$&');\n            config.content = config.content.replace(new RegExp(pattern, 'g'), this.getUniqueSuffix(config));\n            this._super();\n\n            return this;\n        },\n\n        /**\n         * Build unique id based on name, underscore separated.\n         *\n         * @param {Object} config\n         */\n        getUniqueSuffix: function (config) {\n            return config.name.replace(/(\\.|-)/g, '_');\n        },\n\n        /**\n         * @inheritdoc\n         */\n        destroy: function () {\n            this._super();\n            wysiwyg.removeEvents(this.wysiwygId);\n        },\n\n        /**\n         *\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['value', 'content']);\n\n            return this;\n        },\n\n        /**\n         *\n         * @returns {} Chainable.\n         */\n        initNodeListener: function () {\n            $.async({\n                component: this,\n                selector: this.elementSelector\n            }, this.setElementNode.bind(this));\n\n            return this;\n        },\n\n        /**\n         *\n         * @param {HTMLElement} node\n         */\n        setElementNode: function (node) {\n            $(node).bindings({\n                value: this.value\n            });\n        },\n\n        /**\n         * Set disabled property to wysiwyg component\n         *\n         * @param {Boolean} disabled\n         */\n        setDisabled: function (disabled) {\n            if (this.$wysiwygEditorButton && disabled) {\n                this.$wysiwygEditorButton.prop('disabled', 'disabled');\n            } else if (this.$wysiwygEditorButton) {\n                this.$wysiwygEditorButton.prop('disabled', false);\n            }\n\n            /* eslint-disable no-undef */\n            if (!_.isUndefined(this.currentWysiwyg) && this.currentWysiwyg.activeEditor()) {\n                this.currentWysiwyg.setEnabledStatus(!disabled);\n                this.currentWysiwyg.getPluginButtons().prop('disabled', disabled);\n            }\n        },\n\n        /**\n         * Content getter\n         *\n         * @returns {String}\n         */\n        getContentUnsanitizedHtml: function () {\n            return this.content();\n        }\n    });\n});\n","Magento_Ui/js/grid/data-storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'uiClass'\n], function ($, _, utils, Class) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            cacheRequests: true,\n            cachedRequestDelay: 50,\n            indexField: 'entity_id',\n            requestConfig: {\n                url: '${ $.updateUrl }',\n                method: 'GET',\n                dataType: 'json'\n            },\n            dataScope: '',\n            data: {}\n        },\n\n        /**\n         * Initializes dataStorage configuration.\n         *\n         * @returns {DataStorage} Chainable.\n         */\n        initConfig: function () {\n            var scope;\n\n            this._super();\n\n            scope = this.dataScope;\n\n            if (typeof scope === 'string') {\n                this.dataScope = scope ? [scope] : [];\n            }\n\n            this._requests = [];\n\n            return this;\n        },\n\n        /**\n         * Extracts data which matches specified set of identifiers.\n         *\n         * @param {Array} ids - Records identifiers.\n         * @returns {Array|Boolean}\n         */\n        getByIds: function (ids) {\n            var result = [],\n                hasData;\n\n            hasData = ids.every(function (id) {\n                var item = this.data[id];\n\n                return item ? result.push(item) : false;\n            }, this);\n\n            return hasData ? result : false;\n        },\n\n        /**\n         * Extracts identifiers of provided records.\n         * If no records were provided then full list of\n         * current data id's will be returned.\n         *\n         * @param {Object|Array} [data=this.data]\n         * @returns {Array}\n         */\n        getIds: function (data) {\n            data = data || this.data;\n\n            return _.pluck(data, this.indexField);\n        },\n\n        /**\n         * Extracts data which matches specified parameters.\n         *\n         * @param {Object} params - Request parameters.\n         * @param {Object} [options={}]\n         * @returns {jQueryPromise}\n         */\n        getData: function (params, options) {\n            var cachedRequest;\n\n            if (this.hasScopeChanged(params)) {\n                this.clearRequests();\n            } else {\n                cachedRequest = this.getRequest(params);\n            }\n\n            options = options || {};\n\n            return !options.refresh && cachedRequest ?\n                this.getRequestData(cachedRequest) :\n                this.requestData(params);\n        },\n\n        /**\n         * Tells whether one of the parameters defined in the \"dataScope\" has\n         * changed since the last request.\n         *\n         * @param {Object} params - Request parameters.\n         * @returns {Boolean}\n         */\n        hasScopeChanged: function (params) {\n            var lastRequest = _.last(this._requests),\n                keys,\n                diff;\n\n            if (!lastRequest) {\n                return false;\n            }\n\n            diff = utils.compare(lastRequest.params, params);\n\n            keys = _.pluck(diff.changes, 'path');\n            keys = keys.concat(Object.keys(diff.containers));\n\n            return _.intersection(this.dataScope, keys).length > 0;\n        },\n\n        /**\n         * Extends records of current data object\n         * with the provided records collection.\n         *\n         * @param {Array} data - An array of records.\n         * @returns {DataStorage} Chainable.\n         */\n        updateData: function (data) {\n            var records = _.indexBy(data || [], this.indexField);\n\n            _.extend(this.data, records);\n\n            return this;\n        },\n\n        /**\n         * Sends request to the server with provided parameters.\n         *\n         * @param {Object} params - Request parameters.\n         * @returns {jQueryPromise}\n         */\n        requestData: function (params) {\n            var query = utils.copy(params),\n                handler = this.onRequestComplete.bind(this, query),\n                request;\n\n            this.requestConfig.data = query;\n            request = $.ajax(this.requestConfig).done(handler);\n\n            return request;\n        },\n\n        /**\n         * Returns request's instance which\n         * contains provided parameters.\n         *\n         * @param {Object} params - Request parameters.\n         * @returns {Object} Instance of request.\n         */\n        getRequest: function (params) {\n            return _.find(this._requests, function (request) {\n                return _.isEqual(params, request.params);\n            }, this);\n        },\n\n        /**\n         * Forms data object associated with provided request.\n         *\n         * @param {Object} request - Request object.\n         * @returns {jQueryPromise}\n         */\n        getRequestData: function (request) {\n            var defer = $.Deferred(),\n                resolve = defer.resolve.bind(defer),\n                delay = this.cachedRequestDelay,\n                result;\n\n            result = {\n                items: this.getByIds(request.ids),\n                totalRecords: request.totalRecords,\n                errorMessage: request.errorMessage\n            };\n\n            delay ?\n                _.delay(resolve, delay, result) :\n                resolve(result);\n\n            return defer.promise();\n        },\n\n        /**\n         * Caches requests object with provided parameters\n         * and data object associated with it.\n         *\n         * @param {Object} data - Data associated with request.\n         * @param {Object} params - Request parameters.\n         * @returns {DataStorage} Chainable.\n         */\n        cacheRequest: function (data, params) {\n            var cached = this.getRequest(params);\n\n            if (cached) {\n                this.removeRequest(cached);\n            }\n\n            this._requests.push({\n                ids: this.getIds(data.items),\n                params: params,\n                totalRecords: data.totalRecords,\n                errorMessage: data.errorMessage\n            });\n\n            return this;\n        },\n\n        /**\n         * Clears all cached requests.\n         *\n         * @returns {DataStorage} Chainable.\n         */\n        clearRequests: function () {\n            this._requests.splice(0);\n\n            return this;\n        },\n\n        /**\n         * Removes provided request object from cached requests list.\n         *\n         * @param {Object} request - Request object.\n         * @returns {DataStorage} Chainable.\n         */\n        removeRequest: function (request) {\n            var requests = this._requests,\n                index = requests.indexOf(request);\n\n            if (~index) {\n                requests.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Checks if request with a specified parameters was cached.\n         *\n         * @param {Object} params - Parameters of the request.\n         * @returns {Boolean}\n         */\n        wasRequested: function (params) {\n            return !!this.getRequest(params);\n        },\n\n        /**\n         * Handles successful data request.\n         *\n         * @param {Object} params - Request parameters.\n         * @param {Object} data - Response data.\n         */\n        onRequestComplete: function (params, data) {\n            this.updateData(data.items);\n\n            if (this.cacheRequests) {\n                this.cacheRequest(data, params);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/dnd.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'Magento_Ui/js/lib/view/utils/async',\n    'underscore',\n    'uiRegistry',\n    'uiClass'\n], function (ko, $, _, registry, Class) {\n    'use strict';\n\n    var isTouchDevice = typeof document.ontouchstart !== 'undefined',\n        transformProp;\n\n    /**\n     * Defines supported css 'transform' property.\n     *\n     * @returns {String|Undefined}\n     */\n    transformProp = (function () {\n        var style = document.body.style,\n            base = 'Transform',\n            vendors = ['webkit', 'moz', 'ms', 'o'],\n            vi = vendors.length,\n            property;\n\n        if (typeof style.transform != 'undefined') {\n            return 'transform';\n        }\n\n        while (vi--) {\n            property = vendors[vi] + base;\n\n            if (typeof style[property] != 'undefined') {\n                return property;\n            }\n        }\n    })();\n\n    /**\n     * Returns first touch data if it's available.\n     *\n     * @param {(MouseEvent|TouchEvent)} e - Event object.\n     * @returns {Object}\n     */\n    function getTouch(e) {\n        return e.touches ? e.touches[0] : e;\n    }\n\n    /**\n     * Moves specified DOM element to the x and y coordinates.\n     *\n     * @param {HTMLElement} elem - Element to be relocated.\n     * @param {Number} x - X coordinate.\n     * @param {Number} y - Y coordinate.\n     */\n    function locate(elem, x, y) {\n        var value = 'translate(' + x + 'px,' + y + 'px)';\n\n        elem.style[transformProp] = value;\n    }\n\n    /*eslint-disable no-extra-parens*/\n    /**\n     * Checks if specified coordinate is inside of the provided area.\n     *\n     * @param {Number} x - X coordinate.\n     * @param {Number} y - Y coordinate.\n     * @param {Object} area - Object which represents area.\n     * @returns {Boolean}\n     */\n    function isInside(x, y, area) {\n        return (\n            area &&\n            x >= area.left && x <= area.right &&\n            y >= area.top && y <= area.bottom\n        );\n    }\n\n    /*eslint-enable no-extra-parens*/\n\n    /**\n     * Calculates distance between two points.\n     *\n     * @param {Number} x1 - X coordinate of a first point.\n     * @param {Number} y1 - Y coordinate of a first point.\n     * @param {Number} x2 - X coordinate of a second point.\n     * @param {Number} y2 - Y coordinate of a second point.\n     * @returns {Number} Distance between points.\n     */\n    function distance(x1, y1, x2, y2) {\n        var dx = x2 - x1,\n            dy = y2 - y1;\n\n        dx *= dx;\n        dy *= dy;\n\n        return Math.sqrt(dx + dy);\n    }\n\n    /**\n     * Returns viewModel associated with a provided DOM element.\n     *\n     * @param {HTMLElement} elem\n     * @returns {Object|Array}\n     */\n    function getModel(elem) {\n        return ko.dataFor(elem);\n    }\n\n    /**\n     * Checks whether cols are identical\n     *\n     * @param {HTMLElement} c1\n     * @param {HTMLElement} c2\n     * @returns {Boolean}\n     */\n    function compareCols(c1, c2) {\n        return c1.cellIndex === c2.cellIndex;\n    }\n\n    return Class.extend({\n        defaults: {\n            rootSelector: '${ $.columnsProvider }:.admin__data-grid-wrap',\n            tableSelector: '${ $.rootSelector } -> table.data-grid',\n            mainTableSelector: '[data-role=\"grid\"]',\n            columnSelector: '${ $.tableSelector } thead tr th',\n            noSelectClass: '_no-select',\n            hiddenClass: '_hidden',\n            fixedX: false,\n            fixedY: true,\n            minDistance: 2,\n            columns: []\n        },\n\n        /**\n         * Initializes Dnd component.\n         *\n         * @returns {Dnd} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'initTable',\n                'initColumn',\n                'removeColumn',\n                'onMouseMove',\n                'onMouseUp',\n                'onMouseDown'\n            );\n\n            this.$body = $('body');\n\n            this._super()\n                .initListeners();\n\n            $.async(this.tableSelector, this.initTable);\n            $.async(this.columnSelector, this.initColumn);\n\n            return this;\n        },\n\n        /**\n         * Binds necessary events listeners.\n         *\n         * @returns {Dnd} Chainbale.\n         */\n        initListeners: function () {\n            if (isTouchDevice) {\n                $(document).on({\n                    touchmove: this.onMouseMove,\n                    touchend: this.onMouseUp,\n                    touchleave: this.onMouseUp\n                });\n            } else {\n                $(document).on({\n                    mousemove: this.onMouseMove,\n                    mouseup: this.onMouseUp\n                });\n            }\n\n            return this;\n        },\n\n        /**\n         * Defines specified table element as a main container.\n         *\n         * @param {HTMLTableElement} table\n         * @returns {Dnd} Chainable.\n         */\n        initTable: function (table) {\n            this.table =  $(table).is(this.mainTableSelector) ?  table : this.table;\n\n            $(table).addClass('data-grid-draggable');\n\n            return this;\n        },\n\n        /**\n         * Sets specified column as a draggable element.\n         *\n         * @param {HTMLTableHeaderCellElement} column - Columns header element.\n         * @returns {Dnd} Chainable.\n         */\n        initColumn: function (column) {\n            var model = getModel(column),\n                eventName;\n\n            if (!model || !model.draggable) {\n                return this;\n            }\n\n            if (!ko.es5.isTracked(model, 'dragover')) {\n                model.track('dragover');\n            }\n\n            this.columns.push(column);\n\n            $(column).bindings({\n                css: {\n                    '_dragover-left': ko.computed(function () {\n                        return model.dragover === 'right';\n                    }),\n                    '_dragover-right': ko.computed(function () {\n                        return model.dragover === 'left';\n                    })\n                }\n            });\n\n            eventName = isTouchDevice ?\n                'touchstart' :\n                'mousedown';\n\n            $(column).on(eventName, this.onMouseDown);\n            $.async.remove(column, this.removeColumn);\n\n            return this;\n        },\n\n        /**\n         * Removes specified column element from the columns array.\n         *\n         * @param {HTMLTableHeaderCellElement} column - Columns header element.\n         * @returns {Dnd} Chainable.\n         */\n        removeColumn: function (column) {\n            var columns = this.columns,\n                index = columns.indexOf(column);\n\n            if (~index) {\n                columns.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Returns index of column.\n         *\n         * @param {HTMLTableHeaderCellElement} elem\n         * @returns {Number}\n         */\n        _getColumnIndex: function (elem) {\n            return _.toArray(elem.parentNode.cells).indexOf(elem);\n        },\n\n        /**\n         * Calculates coordinates of draggable elements.\n         *\n         * @returns {Dnd} Chainbale.\n         */\n        _cacheCoords: function () {\n            var container   = this.table.getBoundingClientRect(),\n                bodyRect    = document.body.getBoundingClientRect(),\n                grabbed     = this.grabbed,\n                dragElem    = grabbed.elem,\n                cells       = _.toArray(dragElem.parentNode.cells),\n                rect;\n\n            this.coords = this.columns.map(function (column) {\n                var data,\n                    colIndex = _.findIndex(cells, function (cell) {\n                        return compareCols(cell, column);\n                    });\n\n                rect = column.getBoundingClientRect();\n\n                data = {\n                    index: colIndex,\n                    target: column,\n                    orig: rect,\n                    left: rect.left - bodyRect.left,\n                    right: rect.right - bodyRect.left,\n                    top: rect.top - bodyRect.top,\n                    bottom: container.bottom - bodyRect.top\n                };\n\n                if (column === dragElem) {\n                    this.dragArea = data;\n\n                    grabbed.shiftX = rect.left - grabbed.x;\n                    grabbed.shiftY = rect.top - grabbed.y;\n                }\n\n                return data;\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Creates clone of a target table with only specified column visible.\n         *\n         * @param {HTMLTableHeaderCellElement} elem - Dragging column.\n         * @returns {Dnd} Chainbale.\n         */\n        _cloneTable: function (elem) {\n            var clone       = this.table.cloneNode(true),\n                columnIndex = this._getColumnIndex(elem),\n                headRow     = clone.tHead.firstElementChild,\n                headCells   = _.toArray(headRow.cells),\n                tableBody   = clone.tBodies[0],\n                bodyRows    = _.toArray(tableBody.children),\n                origTrs     = this.table.tBodies[0].children;\n\n            clone.style.width = elem.offsetWidth + 'px';\n\n            headCells.forEach(function (th, index) {\n                if (index !== columnIndex) {\n                    headRow.removeChild(th);\n                }\n            });\n\n            headRow.cells[0].style.height = elem.offsetHeight + 'px';\n\n            bodyRows.forEach(function (row, rowIndex) {\n                var cells = row.cells,\n                    cell;\n\n                if (cells.length !== headCells.length) {\n                    tableBody.removeChild(row);\n\n                    return;\n                }\n\n                cell = row.cells[columnIndex].cloneNode(true);\n\n                while (row.firstElementChild) {\n                    row.removeChild(row.firstElementChild);\n                }\n\n                cell.style.height = origTrs[rowIndex].cells[columnIndex].offsetHeight + 'px';\n\n                row.appendChild(cell);\n            });\n\n            this.dragTable = clone;\n\n            $(clone)\n                .addClass('_dragging-copy')\n                .appendTo('body');\n\n            return this;\n        },\n\n        /**\n         * Matches provided coordinates to available areas.\n         *\n         * @param {Number} x - X coordinate of a mouse pointer.\n         * @param {Number} y - Y coordinate of a mouse pointer.\n         * @returns {Object|Undefined} Matched area.\n         */\n        _getDropArea: function (x, y) {\n            return _.find(this.coords, function (area) {\n                return isInside(x, y, area);\n            });\n        },\n\n        /**\n         * Updates state of hovered areas.\n         *\n         * @param {Number} x - X coordinate of a mouse pointer.\n         * @param {Number} y - Y coordinate of a mouse pointer.\n         */\n        _updateAreas: function (x, y) {\n            var leavedArea = this.dropArea,\n                area = this.dropArea = this._getDropArea(x, y);\n\n            if (leavedArea) {\n                this.dragleave(leavedArea);\n            }\n\n            if (area && !compareCols(area.target, this.dragArea.target)) {\n                this.dragenter(area);\n            }\n        },\n\n        /**\n         * Grab action handler.\n         *\n         * @param {Number} x - X coordinate of a grabbed point.\n         * @param {Number} y - Y coordinate of a grabbed point.\n         * @param {HTMLElement} elem - Grabbed element.\n         */\n        grab: function (x, y, elem) {\n            this.initDrag = true;\n\n            this.grabbed = {\n                x: x,\n                y: y,\n                elem: elem\n            };\n\n            this.$body.addClass(this.noSelectClass);\n        },\n\n        /**\n         * Dragstart action handler.\n         *\n         * @param {HTMLTableHeaderCellElement} elem - Element which is dragging.\n         */\n        dragstart: function (elem) {\n            this.initDrag = false;\n            this.dropArea = false;\n            this.dragging = true;\n\n            getModel(elem).dragging(true);\n\n            this._cacheCoords()\n                ._cloneTable(elem);\n        },\n\n        /**\n         * Drag action handler. Locates draggable\n         * grid at a specified coordinates.\n         *\n         * @param {Number} x - X coordinate.\n         * @param {Number} y - Y coordinate.\n         */\n        drag: function (x, y) {\n            var grabbed  = this.grabbed,\n                dragArea = this.dragArea,\n                posX     = x + grabbed.shiftX,\n                posY     = y + grabbed.shiftY;\n\n            if (this.fixedX) {\n                x    = dragArea.left;\n                posX = dragArea.orig.left;\n            }\n\n            if (this.fixedY) {\n                y    = dragArea.top;\n                posY = dragArea.orig.top;\n            }\n\n            locate(this.dragTable, posX, posY);\n\n            if (!isInside(x, y, this.dropArea)) {\n                this._updateAreas(x, y);\n            }\n        },\n\n        /**\n         * Dragenter action handler.\n         *\n         * @param {Object} dropArea\n         */\n        dragenter: function (dropArea) {\n            var direction = this.dragArea.index < dropArea.index ?\n                'left' :\n                'right';\n\n            getModel(dropArea.target).dragover = direction;\n        },\n\n        /**\n         * Dragleave action handler.\n         *\n         * @param {Object} dropArea\n         */\n        dragleave: function (dropArea) {\n            getModel(dropArea.target).dragover = false;\n        },\n\n        /**\n         * Dragend action handler.\n         *\n         * @param {Object} dragArea\n         */\n        dragend: function (dragArea) {\n            var dropArea = this.dropArea,\n                dragElem = dragArea.target;\n\n            this.dragging = false;\n\n            document.body.removeChild(this.dragTable);\n\n            getModel(dragElem).dragging(false);\n\n            if (dropArea && !compareCols(dropArea.target, dragElem)) {\n                this.drop(dropArea, dragArea);\n            }\n        },\n\n        /**\n         * Drop action handler.\n         *\n         * @param {Object} dropArea\n         * @param {Object} dragArea\n         */\n        drop: function (dropArea, dragArea) {\n            var dropModel = getModel(dropArea.target),\n                dragModel = getModel(dragArea.target);\n\n            getModel(this.table).insertChild(dragModel, dropModel);\n            dropModel.dragover = false;\n        },\n\n        /**\n         * Documents' 'mousemove' event handler.\n         *\n         * @param {(MouseEvent|TouchEvent)} e - Event object.\n         */\n        onMouseMove: function (e) {\n            var grab    = this.grabbed,\n                touch   = getTouch(e),\n                x       = touch.pageX,\n                y       = touch.pageY;\n\n            if (this.initDrag || this.dragging) {\n                e.preventDefault();\n            }\n\n            if (this.initDrag && distance(x, y, grab.x, grab.y) >= this.minDistance) {\n                this.dragstart(grab.elem);\n            }\n\n            if (this.dragging) {\n                this.drag(x, y);\n            }\n        },\n\n        /**\n         * Documents' 'mouseup' event handler.\n         */\n        onMouseUp: function () {\n            if (this.initDrag || this.dragging) {\n                this.initDrag = false;\n                this.$body.removeClass(this.noSelectClass);\n            }\n\n            if (this.dragging) {\n                this.dragend(this.dragArea);\n            }\n        },\n\n        /**\n         * Columns' 'mousedown' event handler.\n         *\n         * @param {(MouseEvent|TouchEvent)} e - Event object.\n         */\n        onMouseDown: function (e) {\n            var touch = getTouch(e);\n\n            this.grab(touch.pageX, touch.pageY, e.currentTarget);\n        }\n    });\n});\n","Magento_Ui/js/grid/export.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'uiElement'\n], function ($, _, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/exportButton',\n            selectProvider: 'ns = ${ $.ns }, index = ids',\n            checked: '',\n            additionalParams: [],\n            modules: {\n                selections: '${ $.selectProvider }'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super()\n                .initChecked();\n        },\n\n        /** @inheritdoc */\n        initConfig: function () {\n            this._super();\n\n            _.each(this.additionalParams, function (value, key) {\n                key = 'additionalParams.' + key;\n                this.imports[key] = value;\n            }, this);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('checked');\n\n            return this;\n        },\n\n        /**\n         * Checks first option if checked not defined.\n         *\n         * @returns {Object}\n         */\n        initChecked: function () {\n            if (!this.checked()) {\n                this.checked(\n                    this.options[0].value\n                );\n            }\n\n            return this;\n        },\n\n        /**\n         * Compose params object that will be added to request.\n         *\n         * @returns {Object}\n         */\n        getParams: function () {\n            var selections = this.selections(),\n                data = selections ? selections.getSelections() : null,\n                itemsType,\n                result = {};\n\n            if (data) {\n                itemsType = data.excludeMode ? 'excluded' : 'selected';\n                result.filters = data.params.filters;\n                result.search = data.params.search;\n                result.namespace = data.params.namespace;\n                result[itemsType] = data[itemsType];\n                _.each(this.additionalParams, function (param, key) {\n                    result[key] = param;\n                });\n\n                if (!result[itemsType].length) {\n                    result[itemsType] = false;\n                }\n            }\n\n            return result;\n        },\n\n        /**\n         * Find checked option.\n         *\n         * @returns {Object}\n         */\n        getActiveOption: function () {\n            return _.findWhere(this.options, {\n                value: this.checked()\n            });\n        },\n\n        /**\n         * Build option url.\n         *\n         * @param {Object} option\n         * @returns {String}\n         */\n        buildOptionUrl: function (option) {\n            var params = this.getParams();\n\n            if (!params) {\n                return 'javascript:void(0);';\n            }\n\n            return option.url + '?' + $.param(params);\n            //TODO: MAGETWO-40250\n        },\n\n        /**\n         * Redirect to built option url.\n         */\n        applyOption: function () {\n            var option = this.getActiveOption(),\n                url = this.buildOptionUrl(option);\n\n            location.href = url;\n\n        }\n    });\n});\n","Magento_Ui/js/grid/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/lib/spinner',\n    'rjsResolver',\n    'uiLayout',\n    'uiCollection'\n], function (ko, _, loader, resolver, layout, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/listing',\n            listTemplate: 'ui/list/listing',\n            stickyTmpl: 'ui/grid/sticky/listing',\n            viewSwitcherTmpl: 'ui/grid/view-switcher',\n            positions: false,\n            displayMode: 'grid',\n            displayModes: {\n                grid: {\n                    value: 'grid',\n                    label: 'Grid',\n                    template: '${ $.template }'\n                },\n                list: {\n                    value: 'list',\n                    label: 'List',\n                    template: '${ $.listTemplate }'\n                }\n            },\n            dndConfig: {\n                name: '${ $.name }_dnd',\n                component: 'Magento_Ui/js/grid/dnd',\n                columnsProvider: '${ $.name }',\n                enabled: true\n            },\n            editorConfig: {\n                name: '${ $.name }_editor',\n                component: 'Magento_Ui/js/grid/editing/editor',\n                columnsProvider: '${ $.name }',\n                dataProvider: '${ $.provider }',\n                enabled: false\n            },\n            resizeConfig: {\n                name: '${ $.name }_resize',\n                columnsProvider: '${ $.name }',\n                component: 'Magento_Ui/js/grid/resize',\n                enabled: false\n            },\n            imports: {\n                rows: '${ $.provider }:data.items'\n            },\n            listens: {\n                elems: 'updatePositions updateVisible',\n                '${ $.provider }:reload': 'onBeforeReload',\n                '${ $.provider }:reloaded': 'onDataReloaded'\n            },\n            modules: {\n                dnd: '${ $.dndConfig.name }',\n                resize: '${ $.resizeConfig.name }'\n            },\n            tracks: {\n                displayMode: true\n            },\n            statefull: {\n                displayMode: true\n            }\n        },\n\n        /**\n         * Initializes Listing component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this, 'updateVisible');\n\n            this._super()\n                .initDnd()\n                .initEditor()\n                .initResize();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    rows: [],\n                    visibleColumns: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Creates drag&drop widget instance.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initDnd: function () {\n            if (this.dndConfig.enabled) {\n                layout([this.dndConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes resize component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initResize: function () {\n            if (this.resizeConfig.enabled) {\n                layout([this.resizeConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Creates inline editing component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initEditor: function () {\n            if (this.editorConfig.enabled) {\n                layout([this.editorConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Called when another element was added to current component.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initElement: function (element) {\n            var currentCount = this.elems().length,\n                totalCount = this.initChildCount;\n\n            if (totalCount === currentCount) {\n                this.initPositions();\n            }\n\n            element.on('visible', this.updateVisible);\n\n            return this._super();\n        },\n\n        /**\n         * Defines initial order of child elements.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initPositions: function () {\n            this.on('positions', this.applyPositions.bind(this));\n\n            this.setStatefull('positions');\n\n            return this;\n        },\n\n        /**\n         * Updates current state of child positions.\n         *\n         * @returns {Listing} Chainable.\n         */\n        updatePositions: function () {\n            var positions = {};\n\n            this.elems.each(function (elem, index) {\n                positions[elem.index] = index;\n            });\n\n            this.set('positions', positions);\n\n            return this;\n        },\n\n        /**\n         * Resorts child elements array according to provided positions.\n         *\n         * @param {Object} positions - Object where key represents child\n         *      index and value is its' position.\n         * @returns {Listing} Chainable.\n         */\n        applyPositions: function (positions) {\n            var sorting;\n\n            sorting = this.elems.map(function (elem) {\n                return {\n                    elem: elem,\n                    position: positions[elem.index]\n                };\n            });\n\n            this.insertChild(sorting);\n\n            return this;\n        },\n\n        /**\n         * Returns reference to 'visibleColumns' array.\n         *\n         * @returns {Array}\n         */\n        getVisible: function () {\n            var observable = ko.getObservable(this, 'visibleColumns');\n\n            return observable || this.visibleColumns;\n        },\n\n        /**\n         * Returns path to the template\n         * defined for a current display mode.\n         *\n         * @returns {String} Path to the template.\n         */\n        getTemplate: function () {\n            var mode = this.displayModes[this.displayMode];\n\n            return mode.template;\n        },\n\n        /**\n         * Returns an array of available display modes.\n         *\n         * @returns {Array<Object>}\n         */\n        getDisplayModes: function () {\n            var modes = this.displayModes;\n\n            return _.values(modes);\n        },\n\n        /**\n         * Sets display mode to provided value.\n         *\n         * @param {String} index\n         * @returns {Listing} Chainable\n         */\n        setDisplayMode: function (index) {\n            this.displayMode = index;\n\n            return this;\n        },\n\n        /**\n         * Returns total number of displayed columns in grid.\n         *\n         * @returns {Number}\n         */\n        countVisible: function () {\n            return this.visibleColumns.length;\n        },\n\n        /**\n         * Updates array of visible columns.\n         *\n         * @returns {Listing} Chainable.\n         */\n        updateVisible: function () {\n            this.visibleColumns = this.elems.filter('visible');\n\n            return this;\n        },\n\n        /**\n         * Checks if grid has data.\n         *\n         * @returns {Boolean}\n         */\n        hasData: function () {\n            return !!this.rows && !!this.rows.length;\n        },\n\n        /**\n         * Hides loader.\n         */\n        hideLoader: function () {\n            loader.get(this.name).hide();\n        },\n\n        /**\n         * Shows loader.\n         */\n        showLoader: function () {\n            loader.get(this.name).show();\n        },\n\n        /**\n         * Handler of the data providers' 'reload' event.\n         */\n        onBeforeReload: function () {\n            this.showLoader();\n        },\n\n        /**\n         * Handler of the data providers' 'reloaded' event.\n         */\n        onDataReloaded: function () {\n            resolver(this.hideLoader, this);\n        }\n    });\n});\n","Magento_Ui/js/grid/masonry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/listing',\n    'Magento_Ui/js/lib/view/utils/raf',\n    'jquery',\n    'ko',\n    'underscore'\n], function (Listing, raf, $, ko, _) {\n    'use strict';\n\n    return Listing.extend({\n        defaults: {\n            template: 'ui/grid/masonry',\n            imports: {\n                rows: '${ $.provider }:data.items',\n                errorMessage: '${ $.provider }:data.errorMessage'\n            },\n            listens: {\n                rows: 'initComponent'\n            },\n\n            /**\n             * Images container id\n             * @param string\n             */\n            containerId: null,\n\n            /**\n             * Minimum aspect ratio for each image\n             * @param int\n             */\n            minRatio: null,\n\n            /**\n             * Container width\n             * @param int\n             */\n            containerWidth: window.innerWidth,\n\n            /**\n             * Margin between images\n             * @param int\n             */\n            imageMargin: 20,\n\n            /**\n             * Maximum image height value\n             * @param int\n             */\n            maxImageHeight: 240,\n\n            /**\n             * The value is minimum image width to height ratio when container width is less than the key\n             * @param {Object}\n             */\n            containerWidthToMinRatio: {\n                640: 3,\n                1280: 5,\n                1920: 8\n            },\n\n            /**\n             * Default minimal image width to height ratio.\n             * Applied when container width is greater than max width in the containerWidthToMinRatio matrix.\n             * @param int\n             */\n            defaultMinRatio: 10,\n\n            /**\n             * Layout update FPS during window resizing\n             */\n            refreshFPS: 60\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'rows',\n                    'errorMessage'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Init component handler\n         * @param {Object} rows\n         * @return {Object}\n         */\n        initComponent: function (rows) {\n            if (!rows.length) {\n                return;\n            }\n            this.imageMargin = parseInt(this.imageMargin, 10);\n            this.container = $('[data-id=\"' + this.containerId + '\"]')[0];\n\n            this.setLayoutStyles();\n            this.setEventListener();\n\n            return this;\n        },\n\n        /**\n         * Set event listener to track resize event\n         */\n        setEventListener: function () {\n            window.addEventListener('resize', function () {\n                this.updateStyles();\n            }.bind(this));\n        },\n\n        /**\n         * Updates styles for component.\n         */\n        updateStyles: function () {\n            raf(function () {\n                this.containerWidth = window.innerWidth;\n                this.setLayoutStyles();\n            }.bind(this), this.refreshFPS);\n        },\n\n        /**\n         * Set layout styles inside the container\n         */\n        setLayoutStyles: function () {\n            var containerWidth = parseInt(this.container.clientWidth, 10),\n                rowImages = [],\n                ratio = 0,\n                rowHeight = 0,\n                calcHeight = 0,\n                isLastRow = false,\n                rowNumber = 1;\n\n            this.setMinRatio();\n\n            this.rows().forEach(function (image, index) {\n                ratio += parseFloat((image.width / image.height).toFixed(2));\n                rowImages.push(image);\n\n                if (ratio < this.minRatio && index + 1 !== this.rows().length) {\n                    // Row has more space for images and the image is not the last one - proceed to the next iteration\n                    return;\n                }\n\n                ratio = Math.max(ratio, this.minRatio);\n                calcHeight = (containerWidth - this.imageMargin * rowImages.length) / ratio;\n                rowHeight = calcHeight < this.maxImageHeight ? calcHeight : this.maxImageHeight;\n                isLastRow = index + 1 === this.rows().length;\n\n                this.assignImagesToRow(rowImages, rowNumber, rowHeight, isLastRow);\n\n                rowImages = [];\n                ratio = 0;\n                rowNumber++;\n\n            }.bind(this));\n        },\n\n        /**\n         * Apply styles, css classes and add properties for images in the row\n         *\n         * @param {Object[]} images\n         * @param {Number} rowNumber\n         * @param {Number} rowHeight\n         * @param {Boolean} isLastRow\n         */\n        assignImagesToRow: function (images, rowNumber, rowHeight, isLastRow) {\n            var imageWidth;\n\n            images.forEach(function (img) {\n                imageWidth = rowHeight * (img.width / img.height).toFixed(2);\n                this.setImageStyles(img, imageWidth, rowHeight);\n                this.setImageClass(img, {\n                    bottom: isLastRow\n                });\n                img.rowNumber = rowNumber;\n            }.bind(this));\n\n            images[0].firstInRow = true;\n            images[images.length - 1].lastInRow = true;\n        },\n\n        /**\n         * Wait for container to initialize\n         */\n        waitForContainer: function (callback) {\n            if (typeof this.container === 'undefined') {\n                setTimeout(function () {\n                    this.waitForContainer(callback);\n                }.bind(this), 500);\n            } else {\n                setTimeout(callback, 0);\n            }\n        },\n\n        /**\n         * Set layout styles when container element is loaded.\n         */\n        setLayoutStylesWhenLoaded: function () {\n            this.waitForContainer(function () {\n                this.setLayoutStyles();\n            }.bind(this));\n        },\n\n        /**\n         * Set styles for every image in layout\n         *\n         * @param {Object} img\n         * @param {Number} width\n         * @param {Number} height\n         */\n        setImageStyles: function (img, width, height) {\n            if (!img.styles) {\n                img.styles = ko.observable();\n            }\n            img.styles({\n                width: parseInt(width, 10) + 'px',\n                height: parseInt(height, 10) + 'px'\n            });\n        },\n\n        /**\n         * Set css classes to and an image\n         *\n         * @param {Object} image\n         * @param {Object} classes\n         */\n        setImageClass: function (image, classes) {\n            if (!image.css) {\n                image.css = ko.observable(classes);\n            }\n            image.css(classes);\n        },\n\n        /**\n         * Set min ratio for images in layout\n         */\n        setMinRatio: function () {\n            var minRatio = _.find(\n                this.containerWidthToMinRatio,\n\n                /**\n                 * Find the minimal ratio for container width in the matrix\n                 *\n                 * @param {Number} ratio\n                 * @param {Number} width\n                 * @returns {Boolean}\n                 */\n                function (ratio, width) {\n                    return this.containerWidth <= width;\n                },\n                this\n            );\n\n            this.minRatio = minRatio ? minRatio : this.defaultMinRatio;\n        },\n\n        /**\n         * Checks if grid has data.\n         *\n         * @returns {Boolean}\n         */\n        hasData: function () {\n            return !!this.rows() && !!this.rows().length;\n        },\n\n        /**\n         * Returns error message returned by the data provider\n         *\n         * @returns {String|null}\n         */\n        getErrorMessageUnsanitizedHtml: function () {\n            return this.errorMessage();\n        }\n    });\n});\n","Magento_Ui/js/grid/massactions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'Magento_Ui/js/lib/collapsible',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate'\n], function (_, registry, utils, Collapsible, confirm, alert, $t) {\n    'use strict';\n\n    return Collapsible.extend({\n        defaults: {\n            template: 'ui/grid/actions',\n            stickyTmpl: 'ui/grid/sticky/actions',\n            selectProvider: 'ns = ${ $.ns }, index = ids',\n            actions: [],\n            noItemsMsg: $t('You haven\\'t selected any items!'),\n            modules: {\n                selections: '${ $.selectProvider }'\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Massactions} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe('actions');\n\n            return this;\n        },\n\n        /**\n         * Applies specified action.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @returns {Massactions} Chainable.\n         */\n        applyAction: function (actionIndex) {\n            var data = this.getSelections(),\n                action,\n                callback;\n\n            if (!data.total) {\n                alert({\n                    content: this.noItemsMsg\n                });\n\n                return this;\n            }\n\n            action   = this.getAction(actionIndex);\n            callback = this._getCallback(action, data);\n\n            action.confirm ?\n                this._confirm(action, callback) :\n                callback();\n\n            return this;\n        },\n\n        /**\n         * Retrieves selections data from the selections provider.\n         *\n         * @returns {Object|Undefined}\n         */\n        getSelections: function () {\n            var provider = this.selections(),\n                selections = provider && provider.getSelections();\n\n            return selections;\n        },\n\n        /**\n         * Retrieves action object associated with a specified index.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @returns {Object} Action object.\n         */\n        getAction: function (actionIndex) {\n            return _.findWhere(this.actions(), {\n                type: actionIndex\n            });\n        },\n\n        /**\n         * Adds new action. If action with a specified identifier\n         * already exists, than the original one will be overrided.\n         *\n         * @param {Object} action - Action object.\n         * @returns {Massactions} Chainable.\n         */\n        addAction: function (action) {\n            var actions = this.actions(),\n                index = _.findIndex(actions, {\n                    type: action.type\n                });\n\n            ~index ?\n                actions[index] = action :\n                actions.push(action);\n\n            this.actions(actions);\n\n            return this;\n        },\n\n        /**\n         * Creates action callback based on its' data. If action doesn't spicify\n         * a callback function than the default one will be used.\n         *\n         * @private\n         * @param {Object} action - Actions' object.\n         * @param {Object} selections - Selections data.\n         * @returns {Function} Callback function.\n         */\n        _getCallback: function (action, selections) {\n            var callback = action.callback,\n                args     = [action, selections];\n\n            if (utils.isObject(callback)) {\n                args.unshift(callback.target);\n\n                callback = registry.async(callback.provider);\n            } else if (typeof callback != 'function') {\n                callback = this.defaultCallback.bind(this);\n            }\n\n            return function () {\n                callback.apply(null, args);\n            };\n        },\n\n        /**\n         * Default action callback. Sends selections data\n         * via POST request.\n         *\n         * @param {Object} action - Action data.\n         * @param {Object} data - Selections data.\n         */\n        defaultCallback: function (action, data) {\n            var itemsType = data.excludeMode ? 'excluded' : 'selected',\n                selections = {};\n\n            selections[itemsType] = data[itemsType];\n\n            if (!selections[itemsType].length) {\n                selections[itemsType] = false;\n            }\n\n            _.extend(selections, data.params || {});\n\n            utils.submit({\n                url: action.url,\n                data: selections\n            });\n        },\n\n        /**\n         * Shows actions' confirmation window.\n         *\n         * @param {Object} action - Actions' data.\n         * @param {Function} callback - Callback that will be\n         *      invoked if action is confirmed.\n         */\n        _confirm: function (action, callback) {\n            var confirmData = action.confirm,\n                data = this.getSelections(),\n                total = data.total ? data.total : 0,\n                confirmMessage = confirmData.message + ' (' + total + ' record' + (total > 1 ? 's' : '') + ')';\n\n            confirm({\n                title: confirmData.title,\n                content: confirmMessage,\n                actions: {\n                    confirm: callback\n                }\n            });\n        }\n    });\n});\n","Magento_Ui/js/grid/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'rjsResolver',\n    'uiLayout',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate',\n    'uiElement',\n    'Magento_Ui/js/grid/data-storage'\n], function ($, _, utils, resolver, layout, alert, $t, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            firstLoad: true,\n            lastError: false,\n            storageConfig: {\n                component: 'Magento_Ui/js/grid/data-storage',\n                provider: '${ $.storageConfig.name }',\n                name: '${ $.name }_storage',\n                updateUrl: '${ $.update_url }'\n            },\n            listens: {\n                params: 'onParamsChange',\n                requestConfig: 'updateRequestConfig'\n            },\n            ignoreTmpls: {\n                data: true\n            },\n            triggerDataReload: false\n        },\n\n        /**\n         * Initializes provider component.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initialize: function () {\n            utils.limit(this, 'onParamsChange', 5);\n            _.bindAll(this, 'onReload');\n\n            this._super()\n                .initStorage()\n                .clearData();\n\n            // Load data when there will\n            // be no more pending assets.\n            resolver(this.reload, this);\n\n            return this;\n        },\n\n        /**\n         * Initializes storage component.\n         *\n         * @returns {Provider} Chainable.\n         */\n        initStorage: function () {\n            layout([this.storageConfig]);\n\n            return this;\n        },\n\n        /**\n         * Clears provider's data properties.\n         *\n         * @returns {Provider} Chainable.\n         */\n        clearData: function () {\n            this.setData({\n                items: [],\n                totalRecords: 0\n            });\n\n            return this;\n        },\n\n        /**\n         * Overrides current data with a provided one.\n         *\n         * @param {Object} data - New data object.\n         * @returns {Provider} Chainable.\n         */\n        setData: function (data) {\n            data = this.processData(data);\n\n            this.set('data', data);\n\n            return this;\n        },\n\n        /**\n         * Processes data before applying it.\n         *\n         * @param {Object} data - Data to be processed.\n         * @returns {Object}\n         */\n        processData: function (data) {\n            var items = data.items;\n\n            _.each(items, function (record, index) {\n                record._rowIndex = index;\n            });\n\n            return data;\n        },\n\n        /**\n         * Reloads data with current parameters.\n         *\n         * @returns {Promise} Reload promise object.\n         */\n        reload: function (options) {\n            var request = this.storage().getData(this.params, options);\n\n            this.trigger('reload');\n\n            request\n                .done(this.onReload)\n                .fail(this.onError.bind(this));\n\n            return request;\n        },\n\n        /**\n         * Handles changes of 'params' object.\n         */\n        onParamsChange: function () {\n            // It's necessary to make a reload only\n            // after the initial loading has been made.\n            if (!this.firstLoad) {\n                this.reload();\n            } else {\n                this.triggerDataReload = true;\n            }\n        },\n\n        /**\n         * Handles reload error.\n         */\n        onError: function (xhr) {\n            if (xhr.statusText === 'abort') {\n                return;\n            }\n\n            this.set('lastError', true);\n\n            this.firstLoad = false;\n            this.triggerDataReload = false;\n\n            alert({\n                content: $t('Something went wrong.')\n            });\n        },\n\n        /**\n         * Handles successful data reload.\n         *\n         * @param {Object} data - Retrieved data object.\n         */\n        onReload: function (data) {\n            this.firstLoad = false;\n            this.set('lastError', false);\n            this.setData(data)\n                .trigger('reloaded');\n\n            if (this.triggerDataReload) {\n                this.triggerDataReload = false;\n                this.reload();\n            }\n        },\n\n        /**\n         * Updates storage's request configuration\n         *\n         * @param {Object} requestConfig\n         */\n        updateRequestConfig: function (requestConfig) {\n            if (this.storage()) {\n                _.extend(this.storage().requestConfig, requestConfig);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/resize.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/lib/view/utils/async',\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    'Magento_Ui/js/lib/knockout/extender/bound-nodes',\n    'uiElement'\n], function ($, ko, _, utils, registry, boundedNodes, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            rootSelector: '${ $.columnsProvider }:.admin__data-grid-wrap',\n            tableSelector: '${ $.rootSelector } -> table.data-grid',\n            mainTableSelector: '[data-role=\"grid\"]',\n            columnSelector: '${ $.tableSelector } thead tr th',\n            fieldSelector: '${ $.tableSelector } tbody tr td',\n\n            imports: {\n                storageColumnsData: '${ $.storageConfig.path }.storageColumnsData'\n            },\n            storageColumnsData: {},\n            columnsElements: {},\n            tableWidth: 0,\n            sumColumnsWidth: 0,\n            showLines: 4,\n            resizableElementClass: 'shadow-div',\n            resizingColumnClass: '_resizing',\n            fixedLayoutClass: '_layout-fixed',\n            inResizeClass: '_in-resize',\n            visibleClass: '_resize-visible',\n            cellContentElement: 'div.data-grid-cell-content',\n            minColumnWidth: 40,\n            layoutFixedPolyfillIterator: 0,\n            windowResize: false,\n            resizable: false,\n            resizeConfig: {\n                maxRowsHeight: [],\n                curResizeElem: {},\n                depResizeElem: {},\n                previousWidth: null\n            }\n        },\n\n        /**\n         * Initialize application -\n         * binding functions context,\n         * set handlers for table elements\n         *\n         * @returns {Object} Chainable\n         */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'initTable',\n                'initColumn',\n                'mousedownHandler',\n                'mousemoveHandler',\n                'mouseupHandler',\n                'refreshLastColumn',\n                'refreshMaxRowHeight',\n                'preprocessingWidth',\n                '_eventProxy',\n                'checkAfterResize'\n            );\n\n            this._super();\n            this.observe(['maxRowsHeight']);\n            this.maxRowsHeight([]);\n\n            $.async(this.tableSelector, this.initTable);\n            $.async(this.columnSelector, this.initColumn);\n\n            return this;\n        },\n\n        /**\n         * Set table element and adds handler to mousedown on headers\n         *\n         * @returns {Object} Chainable\n         */\n        initTable: function (table) {\n            if ($(table).is(this.mainTableSelector)) {\n                this.table = table;\n                this.tableWidth = $(table).outerWidth();\n                $(window).on('resize', this.checkAfterResize);\n            }\n\n            //TODO - Must be deleted when Firefox fixed problem with table-layout: fixed\n            //ticket to Firefox: https://bugs.webkit.org/show_bug.cgi?id=90068\n            if (navigator.userAgent.search(/Firefox/) > -1) {\n                this._layoutFixedPolyfill();\n            }\n\n            $(table).addClass(this.fixedLayoutClass);\n\n            return this;\n        },\n\n        /**\n         * Window resize handler,\n         * check changes on table width and\n         * set new width to variable\n         * after window resize start preprocessingWidth method\n         */\n        checkAfterResize: function () {\n            var tableWidth,\n                self = this;\n\n            setTimeout(function () {\n                tableWidth = $(self.table).outerWidth();\n\n                if (self.tableWidth !== tableWidth) {\n                    self.tableWidth = tableWidth;\n                } else {\n                    self.preprocessingWidth();\n                }\n            }, 300);\n        },\n\n        /**\n         * Check conditions to set minimal width\n         */\n        checkSumColumnsWidth: function () {\n            var table = $(this.table),\n                elems = table.find('th:not([style*=\"width: auto\"]):visible'),\n                elemsWidthMin = table.find('th[style*=\"width: ' + (this.minColumnWidth - 1) + 'px\"]:visible'),\n                elemsWidthAuto = table.find('th[style*=\"width: auto\"]:visible'),\n                model;\n\n            this.sumColumnsWidth = 0;\n            _.each(elems, function (elem) {\n                model = ko.dataFor(elem);\n                model.width && model.width !== 'auto' ? this.sumColumnsWidth += model.width : false;\n            }, this);\n\n            if (\n                    this.sumColumnsWidth + elemsWidthAuto.length *\n                    this.minColumnWidth + elemsWidthMin.length *\n                    this.minColumnWidth > this.tableWidth\n            ) {\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Set minimal width to element with \"auto\" width\n         */\n        setWidthToColumnsWidthAuto: function () {\n            var elemsWidthAuto = $(this.table).find('th[style*=\"width: auto\"]:visible');\n\n            _.each(elemsWidthAuto, function (elem) {\n                $(elem).outerWidth(this.minColumnWidth - 1);\n            }, this);\n        },\n\n        /**\n         * Check conditions to set auto width\n         */\n        hasMinimal: function () {\n            var table = $(this.table),\n                elemsWidthMin = table.find('th[style*=\"width: ' + (this.minColumnWidth - 1) + 'px\"]:visible'),\n                elemsWidthAuto = table.find('th[style*=\"width: auto\"]:visible');\n\n            if (\n                    elemsWidthAuto && this.sumColumnsWidth + elemsWidthAuto.length *\n                    this.minColumnWidth + elemsWidthMin.length * this.minColumnWidth + 5 < this.tableWidth\n            ) {\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Set \"auto\" width to element with minimal width\n         */\n        setAuto: function () {\n            var elemsWidthAuto = $(this.table).find('th[style*=\"width: ' + (this.minColumnWidth - 1) + 'px\"]:visible');\n\n            _.each(elemsWidthAuto, function (elem) {\n                $(elem).outerWidth('auto');\n            }, this);\n        },\n\n        /**\n         * Check columns width and preprocessing\n         */\n        preprocessingWidth: function () {\n            if (this.checkSumColumnsWidth()) {\n                this.setWidthToColumnsWidthAuto();\n            } else if (this.hasMinimal()) {\n                this.setAuto();\n            }\n        },\n\n        /**\n         * Init columns elements,\n         * set width to current column element,\n         * add resizable element to columns header,\n         * check and add no-resize class to last column,\n         * stop parents events,\n         * add handler to visibility column\n         *\n         * @param {Object} column - columns header element (th)\n         */\n        initColumn: function (column) {\n            var model = ko.dataFor(column),\n                ctxIndex = this.getCtxIndex(ko.contextFor(column));\n\n            model.width = this.getDefaultWidth(column);\n\n            if (!this.hasColumn(model, ctxIndex, false)) {\n                this.columnsElements[model.index] = this.columnsElements[model.index] || {};\n                this.columnsElements[model.index][ctxIndex] = column;\n                this.initResizableElement(column);\n                this.setStopPropagationHandler(column);\n                $(column).outerWidth(model.width);\n            }\n\n            this.refreshLastColumn(column);\n            this.preprocessingWidth();\n\n            model.on('visible', this.refreshLastColumn.bind(this, column));\n            model.on('visible', this.preprocessingWidth.bind(this));\n        },\n\n        /**\n         * Hack for mozilla firefox\n         */\n        _layoutFixedPolyfill: function () {\n            var self = this;\n\n            setTimeout(function () {\n                if (self.layoutFixedPolyfillIterator < 20) {\n                    $(window).trigger('resize');\n                    self.layoutFixedPolyfillIterator++;\n                    self._layoutFixedPolyfill();\n                } else {\n                    return false;\n                }\n            }, 500);\n        },\n\n        /**\n         * Check element is resizable or not\n         * and append resizable element to DOM\n         *\n         * @param {Object} column - columns header element (th)\n         * @returns {Boolean}\n         */\n        initResizableElement: function (column) {\n            var model = ko.dataFor(column),\n                templateDragElement = '<div class=\"' + this.resizableElementClass + '\"></div>';\n\n            if (_.isUndefined(model.resizeEnabled) || model.resizeEnabled) {\n                $(column).append(templateDragElement);\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Check event target and if need stop parents event,\n         *\n         * @param {Object} column - columns header element (th)\n         * @returns {Boolean}\n         */\n        setStopPropagationHandler: function (column) {\n            var events,\n                click,\n                mousedown;\n\n            $(column).on('click', this._eventProxy);\n            $(column).on('mousedown', this._eventProxy);\n\n            events = $._data(column, 'events');\n\n            click = events.click;\n            mousedown = events.mousedown;\n            click.unshift(click.pop());\n            mousedown.unshift(mousedown.pop());\n\n            return this;\n        },\n\n        /**\n         * Check event target and stop event if need\n         *\n         * @param {Object} event\n         */\n        _eventProxy: function (event) {\n            if ($(event.target).is('.' + this.resizableElementClass)) {\n\n                if (event.type === 'click') {\n                    event.stopImmediatePropagation();\n                } else if (event.type === 'mousedown') {\n                    this.mousedownHandler(event);\n                }\n            }\n        },\n\n        /**\n         * Check visible columns and set disable class to resizable elements,\n         *\n         * @param {Object} column - columns header element (th)\n         */\n        refreshLastColumn: function (column) {\n            var i = 0,\n                columns = $(column).parent().children().not(':hidden'),\n                length = columns.length;\n\n            $('.' + this.visibleClass).removeClass(this.visibleClass);\n\n            $(column).parent().children().not(':hidden').last().addClass(this.visibleClass);\n\n            for (i; i < length; i++) {\n\n                if (!columns.eq(i).find('.' + this.resizableElementClass).length && i) {\n                    columns.eq(i - 1).addClass(this.visibleClass);\n                }\n            }\n\n        },\n\n        /**\n         * Refresh max height to row elements,\n         *\n         * @param {Object} elem - (td)\n         */\n        refreshMaxRowHeight: function (elem) {\n            var rowsH = this.maxRowsHeight(),\n                curEL = $(elem).find('div'),\n                height,\n                obj = this.hasRow($(elem).parent()[0], true);\n\n            curEL.css('white-space', 'nowrap');\n            height = curEL.height() * this.showLines;\n            curEL.css('white-space', 'normal');\n\n            if (obj) {\n                if (obj.maxHeight < height) {\n                    rowsH[_.indexOf(rowsH, obj)].maxHeight = height;\n                } else {\n                    return false;\n                }\n            } else {\n                rowsH.push({\n                    elem: $(elem).parent()[0],\n                    maxHeight: height\n                });\n            }\n\n            $(elem).parent().children().find(this.cellContentElement).css('max-height', height + 'px');\n            this.maxRowsHeight(rowsH);\n        },\n\n        /**\n         * Set resize class to elements when resizable\n         */\n        _setResizeClass: function () {\n            var rowElements = $(this.table).find('tr');\n\n            rowElements\n                .find('td:eq(' + this.resizeConfig.curResizeElem.ctx.$index() + ')')\n                .addClass(this.resizingColumnClass);\n            rowElements\n                .find('td:eq(' + this.resizeConfig.depResizeElem.ctx.$index() + ')')\n                .addClass(this.resizingColumnClass);\n        },\n\n        /**\n         * Remove resize class to elements when resizable\n         */\n        _removeResizeClass: function () {\n            var rowElements = $(this.table).find('tr');\n\n            rowElements\n                .find('td:eq(' + this.resizeConfig.curResizeElem.ctx.$index() + ')')\n                .removeClass(this.resizingColumnClass);\n            rowElements\n                .find('td:eq(' + this.resizeConfig.depResizeElem.ctx.$index() + ')')\n                .removeClass(this.resizingColumnClass);\n        },\n\n        /**\n         * Check conditions to resize\n         *\n         * @returns {Boolean}\n         */\n        _canResize: function (column) {\n            if (\n                $(column).hasClass(this.visibleClass) ||\n                !$(this.resizeConfig.depResizeElem.elems[0]).find('.' + this.resizableElementClass).length\n            ) {\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * Mouse down event handler,\n         * find current and dep column to resize\n         *\n         * @param {Object} event\n         */\n        mousedownHandler: function (event) {\n            var target = event.target,\n                column = $(target).parent()[0],\n                cfg = this.resizeConfig,\n                body = $('body');\n\n            event.stopImmediatePropagation();\n            cfg.curResizeElem.model = ko.dataFor(column);\n            cfg.curResizeElem.ctx = ko.contextFor(column);\n            cfg.curResizeElem.elems = this.hasColumn(cfg.curResizeElem.model, false, true);\n            cfg.curResizeElem.position = event.pageX;\n            cfg.depResizeElem.elems = this.getNextElements(cfg.curResizeElem.elems[0]);\n            cfg.depResizeElem.model = ko.dataFor(cfg.depResizeElem.elems[0]);\n            cfg.depResizeElem.ctx = ko.contextFor(cfg.depResizeElem.elems[0]);\n\n            this._setResizeClass();\n\n            if (!this._canResize(column)) {\n                return false;\n            }\n\n            event.stopPropagation();\n            this.resizable = true;\n            cfg.curResizeElem.model.width = $(cfg.curResizeElem.elems[0]).outerWidth();\n            cfg.depResizeElem.model.width = $(cfg.depResizeElem.elems[0]).outerWidth();\n            body.addClass(this.inResizeClass);\n            body.on('mousemove', this.mousemoveHandler);\n            $(window).on('mouseup', this.mouseupHandler);\n        },\n\n        /**\n         * Mouse move event handler,\n         * change columns width\n         *\n         * @param {Object} event\n         */\n        mousemoveHandler: function (event) {\n            var cfg = this.resizeConfig,\n                width = event.pageX - cfg.curResizeElem.position,\n                self = this;\n\n            event.stopPropagation();\n            event.preventDefault();\n\n            if (\n                this.resizable &&\n                this.minColumnWidth < cfg.curResizeElem.model.width + width &&\n                this.minColumnWidth < cfg.depResizeElem.model.width - width &&\n                cfg.previousWidth !== width\n            ) {\n                cfg.curResizeElem.model.width += width;\n                cfg.depResizeElem.model.width -= width;\n\n                cfg.curResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(cfg.curResizeElem.model.width);\n                });\n                cfg.depResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(cfg.depResizeElem.model.width);\n                });\n\n                cfg.previousWidth = width;\n                cfg.curResizeElem.position = event.pageX;\n            } else if (width <= -(cfg.curResizeElem.model.width - this.minColumnWidth)) {\n\n                cfg.curResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(self.minColumnWidth);\n                });\n                cfg.depResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(\n                    cfg.depResizeElem.model.width +\n                    cfg.curResizeElem.model.width -\n                    self.minColumnWidth);\n                });\n\n            } else if (width >= cfg.depResizeElem.model.width - this.minColumnWidth) {\n\n                cfg.depResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(self.minColumnWidth);\n                });\n                cfg.curResizeElem.elems.forEach(function (el) {\n                    $(el).outerWidth(\n                        cfg.curResizeElem.model.width +\n                        cfg.depResizeElem.model.width -\n                        self.minColumnWidth\n                    );\n                });\n            }\n        },\n\n        /**\n         * Mouse up event handler,\n         * change columns width\n         *\n         * @param {Object} event\n         */\n        mouseupHandler: function (event) {\n            var cfg = this.resizeConfig,\n                body = $('body');\n\n            event.stopPropagation();\n            event.preventDefault();\n\n            this._removeResizeClass();\n            this.storageColumnsData[cfg.curResizeElem.model.index] = cfg.curResizeElem.model.width;\n            this.storageColumnsData[cfg.depResizeElem.model.index] = cfg.depResizeElem.model.width;\n            this.resizable = false;\n\n            this.store('storageColumnsData');\n\n            body.removeClass(this.inResizeClass);\n            body.off('mousemove', this.mousemoveHandler);\n            $(window).off('mouseup', this.mouseupHandler);\n        },\n\n        /**\n         * Find dependency element\n         *\n         * @param {Object} element - current element\n         * @returns {Object} next element data\n         */\n        getNextElements: function (element) {\n            var nextElem = $(element).next()[0],\n                nextElemModel = ko.dataFor(nextElem),\n                nextElemData = this.hasColumn(nextElemModel, false, true);\n\n            if (nextElemData) {\n                if (nextElemModel.visible) {\n                    return nextElemData;\n                }\n\n                return this.getNextElements(nextElem);\n            }\n        },\n\n        /**\n         * Get default width\n         *\n         * @param {Object} column - (th) element\n         * @return {String} width for current column\n         */\n        getDefaultWidth: function (column) {\n            var model = ko.dataFor(column);\n\n            if (this.storageColumnsData[model.index]) {\n                return this.storageColumnsData[model.index];\n            }\n\n            if (model.resizeDefaultWidth) {\n                return parseInt(model.resizeDefaultWidth, 10);\n            }\n\n            return 'auto';\n        },\n\n        /**\n         * Check column is render or not\n         *\n         * @param {Object} model - cur column model\n         * @param {String|Boolean} ctxIndex - index of context, or false, if want to get cols from all ctx\n         * @param {Boolean} returned - need return column object or not\n         * @return {Boolean} if returned param is false, returned boolean value, else return current object data\n         */\n        hasColumn: function (model, ctxIndex, returned) {\n            var colElem = this.columnsElements[model.index] || {},\n                getFromAllCtx = ctxIndex === false;\n\n            if (colElem && (getFromAllCtx || colElem.hasOwnProperty(ctxIndex))) {\n\n                if (returned) {\n                    return getFromAllCtx ?\n                        _.values(colElem) :\n                        colElem[ctxIndex];\n                }\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * Check row is render or not\n         *\n         * @param {Object} elem - cur column element\n         * @param {Boolean} returned - need return column object or not\n         * @return {Boolean|Object} if returned param is false, returned boolean value, else return current object data\n         */\n        hasRow: function (elem, returned) {\n            var i = 0,\n                el = this.maxRowsHeight(),\n                length = el.length;\n\n            for (i; i < length; i++) {\n                if (this.maxRowsHeight()[i].elem === elem) {\n                    if (returned) {//eslint-disable-line max-depth\n                        return this.maxRowsHeight()[i];\n                    }\n\n                    return true;\n                }\n            }\n\n            return false;\n        },\n\n        /**\n         * Generate index that will identify context\n         *\n         * @param {Object} ctx\n         * @return {String}\n         */\n        getCtxIndex: function (ctx) {\n            return ctx ? ctx.$parents.reduce(function (pv, cv) {\n                return (pv.index || pv) + (cv || {}).index;\n            }) : ctx;\n        }\n    });\n});\n","Magento_Ui/js/grid/sortBy.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiElement'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/sortBy',\n            options: [],\n            applied: {},\n            sorting: 'asc',\n            columnsProvider: 'ns = ${ $.ns }, componentType = columns',\n            selectedOption: '',\n            isVisible: true,\n            listens: {\n                'selectedOption': 'applyChanges'\n            },\n            statefull: {\n                selectedOption: true,\n                applied: true\n            },\n            exports: {\n                applied: '${ $.provider }:params.sorting'\n            },\n            imports: {\n                preparedOptions: '${ $.columnsProvider }:elems'\n            },\n            modules: {\n                columns: '${ $.columnsProvider }'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this._super()\n                .observe([\n                    'applied',\n                    'selectedOption',\n                    'isVisible'\n                ]);\n        },\n\n        /**\n         * Prepared sort order options\n         */\n        preparedOptions: function (columns) {\n            if (columns && columns.length > 0) {\n                columns.map(function (column) {\n                    if (column.sortable === true) {\n                        this.options.push({\n                            value: column.index,\n                            label: column.label\n                        });\n                        this.isVisible(true);\n                    } else {\n                        this.isVisible(false);\n                    }\n                }.bind(this));\n            }\n        },\n\n        /**\n         * Apply changes\n         */\n        applyChanges: function () {\n            this.applied({\n                field: this.selectedOption(),\n                direction: this.sorting\n            });\n        }\n    });\n});\n","Magento_Ui/js/grid/toolbar.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/lib/view/utils/async',\n    'Magento_Ui/js/lib/view/utils/raf',\n    'rjsResolver',\n    'uiCollection'\n], function (_, $, raf, resolver, Collection) {\n    'use strict';\n\n    var transformProp;\n\n    /**\n     * Defines supported css 'transform' property.\n     *\n     * @returns {String|Undefined}\n     */\n    transformProp = (function () {\n        var style = document.documentElement.style,\n            base = 'Transform',\n            vendors = ['webkit', 'moz', 'ms', 'o'],\n            vi = vendors.length,\n            property;\n\n        if (typeof style.transform != 'undefined') {\n            return 'transform';\n        }\n\n        while (vi--) {\n            property = vendors[vi] + base;\n\n            if (typeof style[property] != 'undefined') {\n                return property;\n            }\n        }\n    })();\n\n    /**\n     * Moves specified DOM element to the x and y coordinates.\n     *\n     * @param {HTMLElement} elem - Element to be relocated.\n     * @param {Number} x - X coordinate.\n     * @param {Number} y - Y coordinate.\n     */\n    function locate(elem, x, y) {\n        var value = 'translate(' + x + 'px,' + y + 'px)';\n\n        elem.style[transformProp] = value;\n    }\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/toolbar',\n            stickyTmpl: 'ui/grid/sticky/sticky',\n            tableSelector: 'table',\n            columnsProvider: 'ns = ${ $.ns }, componentType = columns',\n            refreshFPS: 15,\n            sticky: false,\n            visible: false,\n            _resized: true,\n            _scrolled: true,\n            _tableScrolled: true,\n            _requiredNodes: {\n                '$stickyToolbar': true,\n                '$stickyTable': true,\n                '$table': true,\n                '$sticky': true\n            },\n            stickyClass: {\n                'sticky-header': true\n            }\n        },\n\n        /**\n         * Initializes sticky toolbar component.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        initialize: function () {\n            this._super();\n\n            if (this.sticky) {\n                this.waitDOMElements()\n                    .then(this.run.bind(this));\n            }\n\n            return this;\n        },\n\n        /**\n         * Establishes DOM elements wait process.\n         *\n         * @returns {jQueryPromise} Promise which will be resolved\n         *      when all of the required DOM elements are defined.\n         */\n        waitDOMElements: function () {\n            var _domPromise = $.Deferred();\n\n            _.bindAll(this, 'setStickyTable', 'setTableNode');\n\n            $.async({\n                ctx: ':not([data-role=\"sticky-el-root\"])',\n                component: this.columnsProvider,\n                selector: this.tableSelector\n            }, this.setTableNode);\n\n            $.async({\n                ctx: '[data-role=\"sticky-el-root\"]',\n                component: this.columnsProvider,\n                selector: this.tableSelector\n            }, this.setStickyTable);\n\n            this._domPromise = _domPromise;\n\n            return _domPromise.promise();\n        },\n\n        /**\n         * Defines left caption element.\n         *\n         * @param {HTMLElement} node\n         */\n        setLeftCap: function (node) {\n            this.$leftCap = node;\n        },\n\n        /**\n         * Defines right caption element.\n         *\n         * @param {HTMLElement} node\n         */\n        setRightCap: function (node) {\n            this.$rightCap = node;\n        },\n\n        /**\n         * Defines original table element.\n         *\n         * @param {HTMLTableElement} node\n         */\n        setTableNode: function (node) {\n            this.$cols = node.tHead.children[0].cells;\n            this.$tableContainer = node.parentNode;\n\n            this.setNode('$table', node);\n        },\n\n        /**\n         * Defines sticky table element.\n         *\n         * @param {HTMLTableElement} node\n         */\n        setStickyTable: function (node) {\n            this.$stickyCols = node.tHead.children[0].cells;\n\n            this.setNode('$stickyTable', node);\n        },\n\n        /**\n         * Defines sticky toolbar node.\n         *\n         * @param {HTMLElement} node\n         */\n        setStickyToolbarNode: function (node) {\n            this.setNode('$stickyToolbar', node);\n        },\n\n        /**\n         * Defines sticky element container.\n         *\n         * @param {HTMLElement} node\n         */\n        setStickyNode: function (node) {\n            this.setNode('$sticky', node);\n        },\n\n        /**\n         * Defines toolbar element container.\n         *\n         * @param {HTMLElement} node\n         */\n        setToolbarNode: function (node) {\n            this.$toolbar = node;\n        },\n\n        /**\n         * Sets provided node as a value of 'key' property and\n         * performs check for required DOM elements.\n         *\n         * @param {String} key - Properties key.\n         * @param {HTMLElement} node - DOM element.\n         */\n        setNode: function (key, node) {\n            var nodes = this._requiredNodes,\n                promise = this._domPromise,\n                defined;\n\n            this[key] = node;\n\n            defined = _.every(nodes, function (enabled, name) {\n                return enabled ? this[name] : true;\n            }, this);\n\n            if (defined) {\n                resolver(promise.resolve, promise);\n            }\n        },\n\n        /**\n         * Starts refresh process of the sticky element\n         * and assigns DOM elements events handlers.\n         */\n        run: function () {\n            _.bindAll(\n                this,\n                'refresh',\n                '_onWindowResize',\n                '_onWindowScroll',\n                '_onTableScroll'\n            );\n\n            $(window).on({\n                scroll: this._onWindowScroll,\n                resize: this._onWindowResize\n            });\n\n            $(this.$tableContainer).on('scroll', this._onTableScroll);\n\n            this.refresh();\n            this.checkTableWidth();\n        },\n\n        /**\n         * Refreshes state of the sticky element and\n         * invokes DOM elements events handlers\n         * if corresponding event has been triggered.\n         */\n        refresh: function () {\n            if (!raf(this.refresh, this.refreshFPS)) {\n                return;\n            }\n\n            if (this._scrolled) {\n                this.onWindowScroll();\n            }\n\n            if (this._tableScrolled) {\n                this.onTableScroll();\n            }\n\n            if (this._resized) {\n                this.onWindowResize();\n            }\n\n            if (this.visible) {\n                this.checkTableWidth();\n            }\n        },\n\n        /**\n         * Shows sticky toolbar.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        show: function () {\n            this.visible = true;\n            //Check admin grid button has addedr not\n            if ($('.page-main-actions').length === 0) {\n                this.$sticky.style.top = 0;\n            }\n            this.$sticky.style.display = '';\n            this.$toolbar.style.visibility = 'hidden';\n\n            return this;\n        },\n\n        /**\n         * Hides sticky toolbar.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        hide: function () {\n            this.visible = false;\n\n            this.$sticky.style.display = 'none';\n            this.$toolbar.style.visibility = '';\n\n            return this;\n        },\n\n        /**\n         * Checks if sticky toolbar covers original elements.\n         *\n         * @returns {Boolean}\n         */\n        isCovered: function () {\n            var stickyTop = this._stickyTableTop + this._wScrollTop;\n\n            return stickyTop > this._tableTop;\n        },\n\n        /**\n         * Updates offset of the sticky table element.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateStickyTableOffset: function () {\n            var style,\n                top;\n\n            if (this.visible) {\n                top = this.$stickyTable.getBoundingClientRect().top;\n            } else {\n                style = this.$sticky.style;\n\n                style.visibility = 'hidden';\n                style.display = '';\n\n                top = this.$stickyTable.getBoundingClientRect().top;\n\n                style.display = 'none';\n                style.visibility = '';\n            }\n\n            this._stickyTableTop = top;\n\n            return this;\n        },\n\n        /**\n         * Updates offset of the original table element.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateTableOffset: function () {\n            var box = this.$table.getBoundingClientRect(),\n                top = box.top + this._wScrollTop;\n\n            if (this._tableTop !== top) {\n                this._tableTop = top;\n\n                this.onTableTopChange(top);\n            }\n\n            return this;\n        },\n\n        /**\n         * Checks if width of the table or it's columns has changed.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        checkTableWidth: function () {\n            var cols        = this.$cols,\n                total       = cols.length,\n                rightBorder = cols[total - 2].offsetLeft,\n                tableWidth  = this.$table.offsetWidth;\n\n            if (this._tableWidth !== tableWidth) {\n                this._tableWidth = tableWidth;\n\n                this.onTableWidthChange(tableWidth);\n            }\n\n            if (this._rightBorder !== rightBorder) {\n                this._rightBorder = rightBorder;\n\n                this.onColumnsWidthChange();\n            }\n\n            return this;\n        },\n\n        /**\n         * Updates width of the sticky table.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateTableWidth: function () {\n            this.$stickyTable.style.width = this._tableWidth + 'px';\n\n            if (this._tableWidth < this._toolbarWidth) {\n                this.checkToolbarSize();\n            }\n\n            return this;\n        },\n\n        /**\n         * Updates width of the sticky columns.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateColumnsWidth: function () {\n            var cols        = this.$cols,\n                index       = cols.length,\n                stickyCols  = this.$stickyCols;\n\n            while (index--) {\n                stickyCols[index].width = cols[index].offsetWidth;\n            }\n\n            return this;\n        },\n\n        /**\n         * Upadates size of the sticky toolbar element\n         * and invokes corresponding 'change' event handlers.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        checkToolbarSize: function () {\n            var width = this.$tableContainer.offsetWidth;\n\n            if (this._toolbarWidth !== width) {\n                this._toolbarWidth = width;\n\n                this.onToolbarWidthChange(width);\n            }\n\n            return this;\n        },\n\n        /**\n         * Toggles sticky toolbar visibility if it's necessary.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateVisibility: function () {\n            if (this.visible !== this.isCovered()) {\n                this.visible ? this.hide() : this.show();\n            }\n\n            return this;\n        },\n\n        /**\n         * Updates position of the left cover area.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateLeftCap: function () {\n            locate(this.$leftCap, -this._wScrollLeft, 0);\n\n            return this;\n        },\n\n        /**\n         * Updates position of the right cover area.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateRightCap: function () {\n            var left = this._toolbarWidth - this._wScrollLeft;\n\n            locate(this.$rightCap, left, 0);\n\n            return this;\n        },\n\n        /**\n         * Updates position of the sticky table.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateTableScroll: function () {\n            var container = this.$tableContainer,\n                left = container.scrollLeft + this._wScrollLeft;\n\n            locate(this.$stickyTable, -left, 0);\n\n            return this;\n        },\n\n        /**\n         * Updates width of the toolbar element.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        updateToolbarWidth: function () {\n            this.$stickyToolbar.style.width = this._toolbarWidth + 'px';\n\n            return this;\n        },\n\n        /**\n         * Handles changes of the toolbar element's width.\n         */\n        onToolbarWidthChange: function () {\n            this.updateToolbarWidth()\n                .updateRightCap();\n        },\n\n        /**\n         * Handles changes of the table top position.\n         */\n        onTableTopChange: function () {\n            this.updateStickyTableOffset();\n        },\n\n        /**\n         * Handles change of the table width.\n         */\n        onTableWidthChange: function () {\n            this.updateTableWidth();\n        },\n\n        /**\n         * Handles change of the table columns width.\n         */\n        onColumnsWidthChange: function () {\n            this.updateColumnsWidth();\n        },\n\n        /**\n         * Handles changes of the window's size.\n         */\n        onWindowResize: function () {\n            this.checkToolbarSize();\n\n            this._resized = false;\n        },\n\n        /**\n         * Handles changes of the original table scroll position.\n         */\n        onTableScroll: function () {\n            this.updateTableScroll();\n\n            this._tableScrolled = false;\n        },\n\n        /**\n         * Handles changes of window's scroll position.\n         */\n        onWindowScroll: function () {\n            var scrollTop = window.pageYOffset,\n                scrollLeft = window.pageXOffset;\n\n            if (this._wScrollTop !== scrollTop) {\n                this._wScrollTop = scrollTop;\n\n                this.onWindowScrollTop(scrollTop);\n            }\n\n            if (this._wScrollLeft !== scrollLeft) {\n                this._wScrollLeft = scrollLeft;\n\n                this.onWindowScrollLeft(scrollLeft);\n            }\n\n            this._scrolled = false;\n        },\n\n        /**\n         * Handles changes of windows' top scroll position.\n         */\n        onWindowScrollTop: function () {\n            this.updateTableOffset()\n                .updateVisibility();\n        },\n\n        /**\n         * Handles changes of windows' left scroll position.\n         */\n        onWindowScrollLeft: function () {\n            this.updateRightCap()\n                .updateLeftCap()\n                .updateTableScroll();\n        },\n\n        /**\n         * Original window 'scroll' event handler.\n         * Sets 'scrolled' flag to 'true'.\n         *\n         * @private\n         */\n        _onWindowScroll: function () {\n            this._scrolled = true;\n        },\n\n        /**\n         * Original window 'resize' event handler.\n         * Sets 'resized' flag to 'true'.\n         *\n         * @private\n         */\n        _onWindowResize: function () {\n            this._resized = true;\n        },\n\n        /**\n         * Original table 'scroll' event handler.\n         * Sets '_tableScrolled' flag to 'true'.\n         *\n         * @private\n         */\n        _onTableScroll: function () {\n            this._tableScrolled = true;\n        }\n    });\n});\n","Magento_Ui/js/grid/tree-massactions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/grid/massactions'\n], function (ko, _, Massactions) {\n    'use strict';\n\n    return Massactions.extend({\n        defaults: {\n            template: 'ui/grid/tree-massactions',\n            submenuTemplate: 'ui/grid/submenu',\n            listens: {\n                opened: 'hideSubmenus'\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Massactions} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .recursiveObserveActions(this.actions());\n\n            return this;\n        },\n\n        /**\n         * Recursive initializes observable actions.\n         *\n         * @param {Array} actions - Action objects.\n         * @param {String} [prefix] - An optional string that will be prepended\n         *      to the \"type\" field of all child actions.\n         * @returns {Massactions} Chainable.\n         */\n        recursiveObserveActions: function (actions, prefix) {\n            _.each(actions, function (action) {\n                if (prefix) {\n                    action.type = prefix + '.' + action.type;\n                }\n\n                if (action.actions) {\n                    action.visible = ko.observable(false);\n                    action.parent = actions;\n                    this.recursiveObserveActions(action.actions, action.type);\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Applies specified action.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @returns {Massactions} Chainable.\n         */\n        applyAction: function (actionIndex) {\n            var action = this.getAction(actionIndex),\n                visibility;\n\n            if (action.visible) {\n                visibility = action.visible();\n\n                this.hideSubmenus(action.parent);\n                action.visible(!visibility);\n\n                return this;\n            }\n\n            return this._super(actionIndex);\n        },\n\n        /**\n         * Retrieves action object associated with a specified index.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @param {Array} actions - Action objects.\n         * @returns {Object} Action object.\n         */\n        getAction: function (actionIndex, actions) {\n            var currentActions = actions || this.actions(),\n                result = false;\n\n            _.find(currentActions, function (action) {\n                if (action.type === actionIndex) {\n                    result = action;\n\n                    return true;\n                }\n\n                if (action.actions) {\n                    result = this.getAction(actionIndex, action.actions);\n\n                    return result;\n                }\n            }, this);\n\n            return result;\n        },\n\n        /**\n         * Recursive hide all sub folders in given array.\n         *\n         * @param {Array} actions - Action objects.\n         * @returns {Massactions} Chainable.\n         */\n        hideSubmenus: function (actions) {\n            var currentActions = actions || this.actions();\n\n            _.each(currentActions, function (action) {\n                if (action.visible && action.visible()) {\n                    action.visible(false);\n                }\n\n                if (action.actions) {\n                    this.hideSubmenus(action.actions);\n                }\n            }, this);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/url-filter-applier.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'underscore',\n    'jquery'\n], function (Component, _, $) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            listingNamespace: null,\n            bookmarkProvider: 'componentType = bookmark, ns = ${ $.listingNamespace }',\n            filterProvider: 'componentType = filters, ns = ${ $.listingNamespace }',\n            filterKey: 'filters',\n            searchString: location.search,\n            modules: {\n                bookmarks: '${ $.bookmarkProvider }',\n                filterComponent: '${ $.filterProvider }'\n            }\n        },\n\n        /**\n         * Init component\n         *\n         * @return {exports}\n         */\n        initialize: function () {\n            this._super();\n            this.apply();\n\n            return this;\n        },\n\n        /**\n         * Apply filter\n         */\n        apply: function () {\n            var urlFilter = this.getFilterParam(this.searchString),\n                applied,\n                filters;\n\n            if (_.isUndefined(this.filterComponent())) {\n                setTimeout(function () {\n                    this.apply();\n                }.bind(this), 100);\n\n                return;\n            }\n\n            if (!_.isUndefined(this.bookmarks())) {\n                if (!_.size(this.bookmarks().getViewData(this.bookmarks().defaultIndex))) {\n                    setTimeout(function () {\n                        this.apply();\n                    }.bind(this), 500);\n\n                    return;\n                }\n            }\n\n            if (Object.keys(urlFilter).length) {\n                applied = this.filterComponent().get('applied');\n                filters = $.extend({}, applied, urlFilter);\n                this.filterComponent().set('applied', filters);\n            }\n        },\n\n        /**\n         * Get filter param from url\n         *\n         * @returns {Object}\n         */\n        getFilterParam: function (url) {\n            var searchString = decodeURI(url),\n                itemArray;\n\n            return _.chain(searchString.slice(1).split('&'))\n                .map(function (item) {\n\n                    if (item && item.search(this.filterKey) !== -1) {\n                        itemArray = item.split('=');\n\n                        if (itemArray[1].search('\\\\[') === 0) {\n                            itemArray[1] = itemArray[1].replace(/[\\[\\]]/g, '').split(',');\n                        }\n\n                        itemArray[0] = itemArray[0].replace(this.filterKey, '')\n                                .replace(/[\\[\\]]/g, '');\n\n                        return itemArray;\n                    }\n                }.bind(this))\n                .compact()\n                .object()\n                .value();\n        }\n    });\n});\n","Magento_Ui/js/grid/cells/sanitizedHtml.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'escaper'\n], function (Column, escaper) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            allowedTags: ['div', 'span', 'b', 'strong', 'i', 'em', 'u', 'a']\n        },\n\n        /**\n         * Name column.\n         *\n         * @param {String} label\n         * @returns {String}\n         */\n        getSafeHtml: function (label) {\n            return escaper.escapeHtml(label, this.allowedTags);\n        },\n\n        /**\n         * UnsanitizedHtml version of getSafeHtml.\n         *\n         * @param {String} label\n         * @returns {String}\n         */\n        getSafeUnsanitizedHtml: function (label) {\n            return this.getSafeHtml(label);\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/actions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    './column',\n    'Magento_Ui/js/modal/confirm',\n    'mage/dataPost'\n], function (_, utils, registry, Column, confirm, dataPost) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/cells/actions',\n            sortable: false,\n            draggable: false,\n            actions: [],\n            rows: [],\n            rowsProvider: '${ $.parentName }',\n            fieldClass: {\n                'data-grid-actions-cell': true\n            },\n            templates: {\n                actions: {}\n            },\n            imports: {\n                rows: '${ $.rowsProvider }:rows'\n            },\n            listens: {\n                rows: 'updateActions'\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {ActionsColumn} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track('actions');\n\n            return this;\n        },\n\n        /**\n         * Returns specific action of a specified row\n         * or all action objects associated with it.\n         *\n         * @param {Number} rowIndex - Index of a row.\n         * @param {String} [actionIndex] - Action identifier.\n         * @returns {Array|Object}\n         */\n        getAction: function (rowIndex, actionIndex) {\n            var rowActions = this.actions[rowIndex];\n\n            return rowActions && actionIndex ?\n                rowActions[actionIndex] :\n                rowActions;\n        },\n\n        /**\n         * Returns visible actions for a specified row.\n         *\n         * @param {Number} rowIndex - Index of a row.\n         * @returns {Array} Visible actions.\n         */\n        getVisibleActions: function (rowIndex) {\n            var rowActions = this.getAction(rowIndex);\n\n            return _.filter(rowActions, this.isActionVisible, this);\n        },\n\n        /**\n         * Adds new action. If an action with the specified identifier\n         * already exists, then the original will be overridden.\n         *\n         * @param {String} index - Actions' identifier.\n         * @param {Object} action - Actions' data.\n         * @returns {ActionsColumn} Chainable.\n         */\n        addAction: function (index, action) {\n            var actionTmpls = this.templates.actions;\n\n            actionTmpls[index] = action;\n\n            this.updateActions();\n\n            return this;\n        },\n\n        /**\n         * Recreates actions for each row.\n         *\n         * @returns {ActionsColumn} Chainable.\n         */\n        updateActions: function () {\n            this.actions = this.rows.map(this._formatActions, this);\n\n            return this;\n        },\n\n        /**\n         * Processes actions, setting additional information to them and\n         * evaluating their properties as string templates.\n         *\n         * @private\n         * @param {Object} row - Row object.\n         * @param {Number} rowIndex - Index of a row.\n         * @returns {Array}\n         */\n        _formatActions: function (row, rowIndex) {\n            var rowActions      = row[this.index] || {},\n                recordId        = row[this.indexField],\n                customActions   = this.templates.actions;\n\n            /**\n             * Actions iterator.\n             */\n            function iterate(action, index) {\n                action = utils.extend({\n                    index: index,\n                    rowIndex: rowIndex,\n                    recordId: recordId\n                }, action);\n\n                return utils.template(action, row, true);\n            }\n\n            rowActions      = _.mapObject(rowActions, iterate);\n            customActions   = _.map(customActions, iterate);\n\n            customActions.forEach(function (action) {\n                rowActions[action.index] = action;\n            });\n\n            return rowActions;\n        },\n\n        /**\n         * Applies specified action.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @param {Number} rowIndex - Index of a row.\n         * @returns {ActionsColumn} Chainable.\n         */\n        applyAction: function (actionIndex, rowIndex) {\n            var action = this.getAction(rowIndex, actionIndex),\n                callback = this._getCallback(action);\n\n            action.confirm ?\n                this._confirm(action, callback) :\n                callback();\n\n            return this;\n        },\n\n        /**\n         * Creates handler for the provided action if it's required.\n         *\n         * @param {Object} action - Action object.\n         * @returns {Function|Undefined}\n         */\n        getActionHandler: function (action) {\n            var index = action.index,\n                rowIndex = action.rowIndex;\n\n            if (this.isHandlerRequired(index, rowIndex)) {\n                return this.applyAction.bind(this, index, rowIndex);\n            }\n        },\n\n        /**\n         * Returns target of action if it's been set.\n         *\n         * @param {Object} action - Action object.\n         * @returns {String}\n         */\n        getTarget: function (action) {\n            if (action.target) {\n                return action.target;\n            }\n\n            return '_self';\n        },\n\n        /**\n         * Checks if specified action requires a handler function.\n         *\n         * @param {String} actionIndex - Actions' identifier.\n         * @param {Number} rowIndex - Index of a row.\n         * @returns {Boolean}\n         */\n        isHandlerRequired: function (actionIndex, rowIndex) {\n            var action = this.getAction(rowIndex, actionIndex);\n\n            return _.isObject(action.callback) || action.confirm || !action.href;\n        },\n\n        /**\n         * Creates action callback based on it's data. If the action doesn't specify\n         * a callback function than the default one will be used.\n         *\n         * @private\n         * @param {Object} action - Action's object.\n         * @returns {Function} Callback function.\n         */\n        _getCallback: function (action) {\n            var args = [action.index, action.recordId, action],\n                callback = action.callback;\n\n            if (utils.isObject(callback)) {\n                args.unshift(callback.target);\n\n                callback = registry.async(callback.provider);\n            } else if (_.isArray(callback)) {\n                return this._getCallbacks(action);\n            } else if (!_.isFunction(callback)) {\n                callback = this.defaultCallback.bind(this);\n            }\n\n            return function () {\n                callback.apply(callback, args);\n            };\n        },\n\n        /**\n         * Creates action callback for multiple actions.\n         *\n         * @private\n         * @param {Object} action - Action's object.\n         * @returns {Function} Callback function.\n         */\n        _getCallbacks: function (action) {\n            var callback = action.callback,\n                callbacks = [],\n                tmpCallback;\n\n            _.each(callback, function (cb) {\n                tmpCallback = {\n                    action: registry.async(cb.provider),\n                    args: _.compact([cb.target, cb.params])\n                };\n                callbacks.push(tmpCallback);\n            });\n\n            return function () {\n                _.each(callbacks, function (cb) {\n                    cb.action.apply(cb.action, cb.args);\n                });\n            };\n        },\n\n        /**\n         * Default action callback. Redirects to\n         * the specified in action's data url.\n         *\n         * @param {String} actionIndex - Action's identifier.\n         * @param {(Number|String)} recordId - Id of the record associated\n         *      with a specified action.\n         * @param {Object} action - Action's data.\n         */\n        defaultCallback: function (actionIndex, recordId, action) {\n            if (action.post) {\n                dataPost().postData({\n                    action: action.href,\n                    data: {}\n                });\n            } else {\n                window.location.href = action.href;\n            }\n        },\n\n        /**\n         * Shows actions' confirmation window.\n         *\n         * @param {Object} action - Action's data.\n         * @param {Function} callback - Callback that will be\n         *      invoked if action is confirmed.\n         */\n        _confirm: function (action, callback) {\n            var confirmData = action.confirm;\n\n            confirm({\n                title: confirmData.title,\n                content: confirmData.message,\n                actions: {\n                    confirm: callback\n                }\n            });\n        },\n\n        /**\n         * Checks if row has only one visible action.\n         *\n         * @param {Number} rowIndex - Row index.\n         * @returns {Boolean}\n         */\n        isSingle: function (rowIndex) {\n            return this.getVisibleActions(rowIndex).length === 1;\n        },\n\n        /**\n         * Checks if row has more than one visible action.\n         *\n         * @param {Number} rowIndex - Row index.\n         * @returns {Boolean}\n         */\n        isMultiple: function (rowIndex) {\n            return this.getVisibleActions(rowIndex).length > 1;\n        },\n\n        /**\n         * Checks if action should be displayed.\n         *\n         * @param {Object} action - Action object.\n         * @returns {Boolean}\n         */\n        isActionVisible: function (action) {\n            return action.hidden !== true;\n        },\n\n        /**\n         * Overrides base method, because this component\n         * can't have global field action.\n         *\n         * @returns {Boolean} False.\n         */\n        hasFieldAction: function () {\n            return false;\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/column.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiElement'\n], function (_, registry, utils, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            headerTmpl: 'ui/grid/columns/text',\n            bodyTmpl: 'ui/grid/cells/text',\n            disableAction: false,\n            controlVisibility: true,\n            sortable: true,\n            sorting: false,\n            visible: true,\n            draggable: true,\n            fieldClass: {},\n            ignoreTmpls: {\n                fieldAction: true\n            },\n            statefull: {\n                visible: true,\n                sorting: true\n            },\n            imports: {\n                exportSorting: 'sorting'\n            },\n            listens: {\n                '${ $.provider }:params.sorting.field': 'onSortChange'\n            },\n            modules: {\n                source: '${ $.provider }'\n            }\n        },\n\n        /**\n         * Initializes column component.\n         *\n         * @returns {Column} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initFieldClass();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Column} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'visible',\n                    'sorting',\n                    'disableAction'\n                ])\n                .observe([\n                    'dragging'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Extends list of field classes.\n         *\n         * @returns {Column} Chainable.\n         */\n        initFieldClass: function () {\n            _.extend(this.fieldClass, {\n                _dragging: this.dragging\n            });\n\n            return this;\n        },\n\n        /**\n         * Applies specified stored state of a column or one of its' properties.\n         *\n         * @param {String} state - Defines what state should be used: saved or default.\n         * @param {String} [property] - Defines what columns' property should be applied.\n         *      If not specified, then all columns stored properties will be used.\n         * @returns {Column} Chainable.\n         */\n        applyState: function (state, property) {\n            var namespace = this.storageConfig.root;\n\n            if (property) {\n                namespace += '.' + property;\n            }\n\n            this.storage('applyStateOf', state, namespace);\n\n            return this;\n        },\n\n        /**\n         * Sets columns' sorting. If column is currently sorted,\n         * than its' direction will be toggled.\n         *\n         * @param {*} [enable=true] - If false, than sorting will\n         *      be removed from a column.\n         * @returns {Column} Chainable.\n         */\n        sort: function (enable) {\n            if (!this.sortable) {\n                return this;\n            }\n\n            enable !== false ?\n                this.toggleSorting() :\n                this.sorting = false;\n\n            return this;\n        },\n\n        /**\n         * Sets descending columns' sorting.\n         *\n         * @returns {Column} Chainable.\n         */\n        sortDescending: function () {\n            if (this.sortable) {\n                this.sorting = 'desc';\n            }\n\n            return this;\n        },\n\n        /**\n         * Sets ascending columns' sorting.\n         *\n         * @returns {Column} Chainable.\n         */\n        sortAscending: function () {\n            if (this.sortable) {\n                this.sorting = 'asc';\n            }\n\n            return this;\n        },\n\n        /**\n         * Toggles sorting direction.\n         *\n         * @returns {Column} Chainable.\n         */\n        toggleSorting: function () {\n            this.sorting === 'asc' ?\n                this.sortDescending() :\n                this.sortAscending();\n\n            return this;\n        },\n\n        /**\n         * Checks if column is sorted.\n         *\n         * @returns {Boolean}\n         */\n        isSorted: function () {\n            return !!this.sorting;\n        },\n\n        /**\n         * Exports sorting data to the dataProvider if\n         * sorting of a column is enabled.\n         */\n        exportSorting: function () {\n            if (!this.sorting) {\n                return;\n            }\n\n            this.source('set', 'params.sorting', {\n                field: this.index,\n                direction: this.sorting\n            });\n        },\n\n        /**\n         * Checks if column has an assigned action that will\n         * be performed when clicking on one of its' fields.\n         *\n         * @returns {Boolean}\n         */\n        hasFieldAction: function () {\n            return !!this.fieldAction || !!this.fieldActions;\n        },\n\n        /**\n         * Applies action described in a 'fieldAction' property\n         * or actions described in 'fieldActions' property.\n         *\n         * @param {Number} rowIndex - Index of a row which initiates action.\n         * @returns {Column} Chainable.\n         *\n         * @example Example of fieldAction definition, which is equivalent to\n         *      referencing to external component named 'listing.multiselect'\n         *      and calling its' method 'toggleSelect' with params [rowIndex, true] =>\n         *\n         *      {\n         *          provider: 'listing.multiselect',\n         *          target: 'toggleSelect',\n         *          params: ['${ $.$data.rowIndex }', true]\n         *      }\n         */\n        applyFieldAction: function (rowIndex) {\n            if (!this.hasFieldAction() || this.disableAction) {\n                return this;\n            }\n\n            if (this.fieldActions) {\n                this.fieldActions.forEach(this.applySingleAction.bind(this, rowIndex), this);\n            } else {\n                this.applySingleAction(rowIndex);\n            }\n\n            return this;\n        },\n\n        /**\n         * Applies single action\n         *\n         * @param {Number} rowIndex - Index of a row which initiates action.\n         * @param {Object} action - Action (fieldAction) to be applied\n         *\n         */\n        applySingleAction: function (rowIndex, action) {\n            var callback;\n\n            action = action || this.fieldAction;\n            action = utils.template(action, {\n                column: this,\n                rowIndex: rowIndex\n            }, true);\n\n            callback = this._getFieldCallback(action);\n\n            if (_.isFunction(callback)) {\n                callback();\n            }\n        },\n\n        /**\n         * Returns field action handler if it was specified.\n         *\n         * @param {Object} record - Record object with which action is associated.\n         * @returns {Function|Undefined}\n         */\n        getFieldHandler: function (record) {\n            if (this.hasFieldAction()) {\n                return this.applyFieldAction.bind(this, record._rowIndex);\n            }\n        },\n\n        /**\n         * Creates action callback based on its' data.\n         *\n         * @param {Object} action - Actions' object.\n         * @returns {Function|Boolean} Callback function or false\n         *      value if it was impossible create a callback.\n         */\n        _getFieldCallback: function (action) {\n            var args     = action.params || [],\n                callback = action.target;\n\n            if (action.provider && action.target) {\n                args.unshift(action.target);\n\n                callback = registry.async(action.provider);\n            }\n\n            if (!_.isFunction(callback)) {\n                return false;\n            }\n\n            return function () {\n                callback.apply(callback, args);\n            };\n        },\n\n        /**\n         * Ment to preprocess data associated with a current columns' field.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getLabel: function (record) {\n            return record[this.index];\n        },\n\n        /**\n         * UnsanitizedHtml version of getLabel.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getLabelUnsanitizedHtml: function (record) {\n            return this.getLabel(record);\n        },\n\n        /**\n         * Returns list of classes that should be applied to a field.\n         *\n         * @returns {Object}\n         */\n        getFieldClass: function () {\n            return this.fieldClass;\n        },\n\n        /**\n         * Returns path to the columns' header template.\n         *\n         * @returns {String}\n         */\n        getHeader: function () {\n            return this.headerTmpl;\n        },\n\n        /**\n         * Returns path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Listener of the providers' sorting state changes.\n         *\n         * @param {Srting} field - Field by which current sorting is performed.\n         */\n        onSortChange: function (field) {\n            if (field !== this.index) {\n                this.sort(false);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'mageUtils',\n    'moment',\n    './column',\n    'underscore',\n    'moment-timezone-with-data'\n], function (utils, moment, Column, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            dateFormat: 'MMM d, YYYY h:mm:ss A',\n            calendarConfig: []\n        },\n\n        /**\n         * Overrides base method to normalize date format\n         *\n         * @returns {DateColumn} Chainable\n         */\n        initConfig: function () {\n            this._super();\n\n            this.dateFormat = utils.normalizeDate(this.dateFormat ? this.dateFormat : this.options.dateFormat);\n\n            return this;\n        },\n\n        /**\n         * Formats incoming date based on the 'dateFormat' property.\n         *\n         * @returns {String} Formatted date.\n         */\n        getLabel: function (value, format) {\n            var date;\n\n            if (this.storeLocale !== undefined) {\n                moment.locale(this.storeLocale, utils.extend({}, this.calendarConfig));\n            }\n\n            date = moment.utc(this._super());\n\n            if (!_.isUndefined(this.timezone) && moment.tz.zone(this.timezone) !== null) {\n                date = date.tz(this.timezone);\n            }\n\n            date = date.isValid() && value[this.index] ?\n                date.format(format || this.dateFormat) :\n                '';\n\n            return date;\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/expandable.js":"/**\n * Copyright \u00a9 2016 Magento. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    './column',\n    'underscore'\n], function (Column, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/cells/expandable',\n            tooltipTmpl: 'ui/grid/cells/expandable/content',\n            visibeItemsLimit: 5,\n            tooltipTitle: ''\n        },\n\n        /**\n         * Gets label from full options array.\n         *\n         * @param {Object} record - Record object.\n         * @returns {String}\n         */\n        getFullLabel: function (record) {\n            return this.getLabelsArray(record).join(', ');\n        },\n\n        /**\n         * Gets label from options array limited by 'visibeItemsLimit'.\n         *\n         * @param {Object} record - Record object.\n         * @returns {String}\n         */\n        getShortLabel: function (record) {\n            return this.getLabelsArray(record).slice(0, this.visibeItemsLimit).join(', ');\n        },\n\n        /**\n         * Extracts array of labels associated with provided values and sort it alphabetically.\n         *\n         * @param {Object} record - Record object.\n         * @returns {Array}\n         */\n        getLabelsArray: function (record) {\n            var values = this.getLabel(record),\n                options = this.options || [],\n                labels = [];\n\n            if (_.isString(values)) {\n                values = values.split(',');\n            }\n\n            if (!Array.isArray(values)) {\n                values = [values];\n            }\n\n            values = values.map(function (value) {\n                return value + '';\n            });\n\n            options = this.flatOptions(options);\n\n            options.forEach(function (item) {\n                if (_.contains(values, item.value + '')) {\n                    labels.push(item.label);\n                }\n            });\n\n            return labels.sort(\n                function (labelFirst, labelSecond) {\n                    return labelFirst.toLowerCase().localeCompare(labelSecond.toLowerCase());\n                }\n            );\n        },\n\n        /**\n         * Transformation tree options structure to liner array.\n         *\n         * @param {Array} options\n         * @returns {Array}\n         */\n        flatOptions: function (options) {\n            var self = this;\n\n            return options.reduce(function (opts, option) {\n                if (_.isArray(option.value)) {\n                    opts = opts.concat(self.flatOptions(option.value));\n                } else {\n                    opts.push(option);\n                }\n\n                return opts;\n            }, []);\n        },\n\n        /**\n         * Checks if amount of options is more than limit value.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Boolean}\n         */\n        isExpandable: function (record) {\n            return this.getLabel(record).length > this.visibeItemsLimit;\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/image-preview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* eslint-disable no-undef */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Ui/js/lib/key-codes'\n], function ($, _, Column, keyCodes) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/columns/image-preview',\n            previewImageSelector: '[data-image-preview]',\n            visibleRecord: null,\n            height: 0,\n            displayedRecord: {},\n            lastOpenedImage: false,\n            fields: {\n                previewUrl: 'preview_url',\n                title: 'title'\n            },\n            modules: {\n                masonry: '${ $.parentName }',\n                thumbnailComponent: '${ $.parentName }.thumbnail_url'\n            },\n            statefull: {\n                sorting: true,\n                lastOpenedImage: true\n            },\n            listens: {\n                '${ $.provider }:params.filters': 'hide',\n                '${ $.provider }:params.search': 'hide',\n                '${ $.provider }:params.paging': 'hide',\n                '${ $.provider }:data.items': 'updateDisplayedRecord'\n            },\n            exports: {\n                height: '${ $.parentName }.thumbnail_url:previewHeight'\n            }\n        },\n\n        /**\n         * Initialize image preview component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super();\n            $(document).on('keydown', this.handleKeyDown.bind(this));\n\n            this.lastOpenedImage.subscribe(function (newValue) {\n\n                if (newValue === false && _.isNull(this.visibleRecord())) {\n                    return;\n                }\n\n                if (newValue === this.visibleRecord()) {\n                    return;\n                }\n\n                if (newValue === false) {\n                    this.hide();\n\n                    return;\n                }\n\n                this.show(this.masonry().rows()[newValue]);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'visibleRecord',\n                    'height',\n                    'displayedRecord',\n                    'lastOpenedImage'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Next image preview\n         *\n         * @param {Object} record\n         */\n        next: function (record) {\n            var recordToShow;\n\n            if (record._rowIndex + 1 === this.masonry().rows().length) {\n                return;\n            }\n\n            recordToShow = this.getRecord(record._rowIndex + 1);\n            recordToShow.rowNumber = record.lastInRow ? record.rowNumber + 1 : record.rowNumber;\n            this.show(recordToShow);\n        },\n\n        /**\n         * Previous image preview\n         *\n         * @param {Object} record\n         */\n        prev: function (record) {\n            var recordToShow;\n\n            if (record._rowIndex === 0) {\n                return;\n            }\n            recordToShow = this.getRecord(record._rowIndex - 1);\n\n            recordToShow.rowNumber = record.firstInRow ? record.rowNumber - 1 : record.rowNumber;\n            this.show(recordToShow);\n        },\n\n        /**\n         * Get record\n         *\n         * @param {Integer} recordIndex\n         *\n         * @return {Object}\n         */\n        getRecord: function (recordIndex) {\n            return this.masonry().rows()[recordIndex];\n        },\n\n        /**\n         * Set selected row id\n         *\n         * @param {Number} rowId\n         * @private\n         */\n        _selectRow: function (rowId) {\n            this.thumbnailComponent().previewRowId(rowId);\n        },\n\n        /**\n         * Show image preview\n         *\n         * @param {Object} record\n         */\n        show: function (record) {\n            if (record._rowIndex === this.visibleRecord()) {\n                this.hide();\n\n                return;\n            }\n\n            this.hide();\n            this.displayedRecord(record);\n            this._selectRow(record.rowNumber || null);\n            this.visibleRecord(record._rowIndex);\n\n            this.lastOpenedImage(record._rowIndex);\n            this.updateImageData();\n        },\n\n        /**\n         * Update image data when image preview is opened\n         */\n        updateImageData: function () {\n            var img = $(this.previewImageSelector + ' img');\n\n            if (!img.get(0)) {\n                setTimeout(function () {\n                    this.updateImageData();\n                }.bind(this), 100);\n            } else if (img.get(0).complete) {\n                this.updateHeight();\n                this.scrollToPreview();\n            } else {\n                img.load(function () {\n                    this.updateHeight();\n                    this.scrollToPreview();\n                }.bind(this));\n            }\n        },\n\n        /**\n         * Update preview displayed record data from the new items data if the preview is expanded\n         *\n         * @param {Array} items\n         */\n        updateDisplayedRecord: function (items) {\n            if (!_.isNull(this.visibleRecord())) {\n                this.displayedRecord(items[this.visibleRecord()]);\n            }\n        },\n\n        /**\n         * Update image preview section height\n         */\n        updateHeight: function () {\n            this.height($(this.previewImageSelector).height() + 'px');\n        },\n\n        /**\n         * Close image preview\n         */\n        hide: function () {\n            this.lastOpenedImage(false);\n            this.visibleRecord(null);\n            this.height(0);\n            this._selectRow(null);\n        },\n\n        /**\n         * Returns visibility for given record.\n         *\n         * @param {Object} record\n         * @return {*|bool}\n         */\n        isVisible: function (record) {\n            if (this.lastOpenedImage() === record._rowIndex &&\n                this.visibleRecord() === null\n            ) {\n                this.show(record);\n            }\n\n            return this.visibleRecord() === record._rowIndex || false;\n        },\n\n        /**\n         * Returns preview image url for a given record.\n         *\n         * @param {Object} record\n         * @return {String}\n         */\n        getUrl: function (record) {\n            return record[this.fields.previewUrl];\n        },\n\n        /**\n         * Returns image title for a given record.\n         *\n         * @param {Object} record\n         * @return {String}\n         */\n        getTitle: function (record) {\n            return record[this.fields.title];\n        },\n\n        /**\n         * Get styles for preview\n         *\n         * @returns {Object}\n         */\n        getStyles: function () {\n            return {\n                'margin-top': '-' + this.height()\n            };\n        },\n\n        /**\n         * Scroll to preview window\n         */\n        scrollToPreview: function () {\n            $(this.previewImageSelector).get(0).scrollIntoView({\n                behavior: 'smooth',\n                block: 'center',\n                inline: 'nearest'\n            });\n        },\n\n        /**\n         * Handle keyboard navigation for image preview\n         *\n         * @param {Object} e\n         */\n        handleKeyDown: function (e) {\n            var key = keyCodes[e.keyCode];\n\n            if (this.visibleRecord() !== null && document.activeElement.tagName !== 'INPUT') {\n                if (key === 'pageLeftKey') {\n                    this.prev(this.displayedRecord());\n                } else if (key === 'pageRightKey') {\n                    this.next(this.displayedRecord());\n                }\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/image.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/columns/image',\n            modules: {\n                masonry: '${ $.parentName }',\n                previewComponent: '${ $.parentName }.preview'\n            },\n            previewRowId: null,\n            previewHeight: 0,\n            fields: {\n                id: 'id',\n                url: 'url'\n            }\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'previewRowId',\n                    'previewHeight'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Updates styles when image loaded.\n         *\n         * @param {Object} record\n         */\n        updateStyles: function (record) {\n            !record.lastInRow || this.masonry().updateStyles();\n        },\n\n        /**\n         * Returns url to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getUrl: function (record) {\n            return record[this.fields.url];\n        },\n\n        /**\n         * Returns id to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Number}\n         */\n        getId: function (record) {\n            return record[this.fields.id];\n        },\n\n        /**\n         * Returns container styles to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Object}\n         */\n        getStyles: function (record) {\n            var styles = record.styles();\n\n            styles['margin-bottom'] = this.previewRowId() === record.rowNumber ? this.previewHeight : 0;\n            record.styles(styles);\n\n            return record.styles;\n        },\n\n        /**\n         * Returns class list to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Object}\n         */\n        getClasses: function (record) {\n            return record.css || {};\n        },\n\n        /**\n         * Get is active record\n         *\n         * @param {Object} record - Data to be preprocessed.\n         *\n         * @returns {Boolean}\n         */\n        getIsActive: function (record) {\n            return this.previewComponent().visibleRecord() === record._rowIndex || false;\n        },\n\n        /**\n         * Expand image preview\n         */\n        expandPreview: function (record) {\n            this.previewComponent().show(record);\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/link.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    './column',\n    'mageUtils'\n], function (Column, utils) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            link: 'link',\n            bodyTmpl: 'ui/grid/cells/link'\n        },\n\n        /**\n         * Returns link to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getLink: function (record) {\n            return utils.nested(record, this.link);\n        },\n\n        /**\n         * Check if link parameter exist in record.\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Boolean}\n         */\n        isLink: function (record) {\n            return !!utils.nested(record, this.link);\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/multiselect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mage/translate',\n    './column'\n], function (_, $t, Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            headerTmpl: 'ui/grid/columns/multiselect',\n            bodyTmpl: 'ui/grid/cells/multiselect',\n            controlVisibility: false,\n            sortable: false,\n            draggable: false,\n            menuVisible: false,\n            excludeMode: false,\n            allSelected: false,\n            indetermine: false,\n            preserveSelectionsOnFilter: false,\n            disabled: [],\n            selected: [],\n            excluded: [],\n            fieldClass: {\n                'data-grid-checkbox-cell': true\n            },\n            actions: [{\n                value: 'selectAll',\n                label: $t('Select All')\n            }, {\n                value: 'deselectAll',\n                label: $t('Deselect All')\n            }, {\n                value: 'selectPage',\n                label: $t('Select All on This Page')\n            }, {\n                value: 'deselectPage',\n                label: $t('Deselect All on This Page')\n            }],\n\n            imports: {\n                totalRecords: '${ $.provider }:data.totalRecords',\n                rows: '${ $.provider }:data.items'\n            },\n\n            listens: {\n                '${ $.provider }:params.filters': 'onFilter',\n                '${ $.provider }:params.search': 'onSearch',\n                selected: 'onSelectedChange',\n                rows: 'onRowsChange'\n            },\n\n            modules: {\n                source: '${ $.provider }'\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'disabled',\n                    'selected',\n                    'excluded',\n                    'excludeMode',\n                    'totalSelected',\n                    'allSelected',\n                    'indetermine',\n                    'totalRecords',\n                    'rows'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Selects specified record.\n         *\n         * @param {*} id - See definition of 'getId' method.\n         * @param {Boolean} [isIndex=false] - See definition of 'getId' method.\n         * @returns {Multiselect} Chainable.\n         */\n        select: function (id, isIndex) {\n            this._setSelection(id, isIndex, true);\n\n            return this;\n        },\n\n        /**\n         * Deselects specified record.\n         *\n         * @param {*} id - See definition of 'getId' method.\n         * @param {Boolean} [isIndex=false] - See definition of 'getId' method.\n         * @returns {Multiselect} Chainable.\n         */\n        deselect: function (id, isIndex) {\n            this._setSelection(id, isIndex, false);\n\n            return this;\n        },\n\n        /**\n         * Toggles selection of a specified record.\n         *\n         * @param {*} id - See definition of 'getId' method.\n         * @param {Boolean} [isIndex=false] - See definition of 'getId' method.\n         * @returns {Multiselect} Chainable.\n         */\n        toggleSelect: function (id, isIndex) {\n            this._setSelection(id, isIndex, !this.isSelected(id, isIndex));\n\n            return this;\n        },\n\n        /**\n         * Checks if specified record is selected.\n         *\n         * @param {*} id - See definition of 'getId' method.\n         * @param {Boolean} [isIndex=false] - See definition of 'getId' method.\n         * @returns {Boolean}\n         */\n        isSelected: function (id, isIndex) {\n            id = this.getId(id, isIndex);\n\n            return this.selected.contains(id);\n        },\n\n        /**\n         * Selects/deselects specified record base on a 'select' parameter value.\n         *\n         * @param {*} id - See definition of 'getId' method.\n         * @param {Boolean} [isIndex=false] - See definition of 'getId' method.\n         * @param {Boolean} select - Whether to select/deselect record.\n         * @returns {Multiselect} Chainable.\n         */\n        _setSelection: function (id, isIndex, select) {\n            var selected = this.selected;\n\n            id = this.getId(id, isIndex);\n\n            if (!select && this.isSelected(id)) {\n                selected.remove(id);\n            } else if (select) {\n                selected.push(id);\n            }\n\n            return this;\n        },\n\n        /**\n         * Selects all records, even those that\n         * are not visible on the page.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        selectAll: function () {\n            this.excludeMode(true);\n\n            this.clearExcluded()\n                .selectPage();\n\n            return this;\n        },\n\n        /**\n         * Deselects all records.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        deselectAll: function () {\n            this.excludeMode(false);\n\n            this.clearExcluded();\n            this.selected.removeAll();\n\n            return this;\n        },\n\n        /**\n         * Selects or deselects all records.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        toggleSelectAll: function () {\n            this.allSelected() ?\n                this.deselectAll() :\n                this.selectAll();\n\n            return this;\n        },\n\n        /**\n         * Selects all records on the current page.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        selectPage: function () {\n            var selected = _.union(this.selected(), this.getIds());\n\n            selected = _.difference(selected, this.disabled());\n\n            this.selected(selected);\n\n            return this;\n        },\n\n        /**\n         * Deselects all records on the current page.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        deselectPage: function () {\n            var pageIds = this.getIds();\n\n            this.selected.remove(function (value) {\n                return !!~pageIds.indexOf(value);\n            });\n\n            return this;\n        },\n\n        /**\n        * Selects or deselects all records on the current page.\n        *\n        * @returns {Multiselect} Chainable.\n        */\n        togglePage: function () {\n            return this.isPageSelected() && !this.excluded().length ? this.deselectPage() : this.selectPage();\n        },\n\n        /**\n         * Clears the array of not selected records.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        clearExcluded: function () {\n            this.excluded.removeAll();\n\n            return this;\n        },\n\n        /**\n         * Retrieve all id's from available records.\n         *\n         * @param {Boolean} [exclude] - Whether to exclude not selected ids' from result.\n         * @returns {Array} An array of ids'.\n         */\n        getIds: function (exclude) {\n            var items = this.rows(),\n                ids = _.pluck(items, this.indexField);\n\n            return exclude ?\n                _.difference(ids, this.excluded()) :\n                ids;\n        },\n\n        /**\n         * Returns identifier of a record.\n         *\n         * @param {*} id - Id of a record or its' index in a rows array.\n         * @param {Boolean} [isIndex=false] - Flag that specifies with what\n         *      kind of identifier we are dealing with.\n         * @returns {*}\n         */\n        getId: function (id, isIndex) {\n            var record = this.rows()[id];\n\n            if (isIndex && record) {\n                id = record[this.indexField];\n            }\n\n            return id;\n        },\n\n        /**\n         * Recalculates list of the excluded records.\n         * Changes value of `excluded`.\n         *\n         * @param {Array} selected - List of the currently selected records.\n         * @returns {Multiselect} Chainable.\n         */\n        updateExcluded: function (selected) {\n            var excluded = this.excluded(),\n                fromPage = _.difference(this.getIds(), selected);\n\n            excluded = _.union(excluded, fromPage);\n            excluded = _.difference(excluded, selected);\n\n            this.excluded(excluded);\n\n            return this;\n        },\n\n        /**\n         * Calculates number of selected records and\n         * updates 'totalSelected' property.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        countSelected: function () {\n            var total = this.totalRecords(),\n                excluded = this.excluded().length,\n                selected = this.selected().length;\n\n            if (this.excludeMode()) {\n                selected = total - excluded;\n            }\n\n            this.totalSelected(selected);\n\n            return this;\n        },\n\n        /**\n         * Returns selected items on a current page.\n         *\n         * @returns {Array}\n         */\n        getPageSelections: function () {\n            var ids = this.getIds();\n\n            return this.selected.filter(function (id) {\n                return _.contains(ids, id);\n            });\n        },\n\n        /**\n         * Returns selections data.\n         *\n         * @returns {Object}\n         */\n        getSelections: function () {\n            return {\n                excluded: this.excluded(),\n                selected: this.selected(),\n                total: this.totalSelected(),\n                excludeMode: this.excludeMode(),\n                params: this.getFiltering()\n            };\n        },\n\n        /**\n         * Extracts filtering data from data provider.\n         *\n         * @returns {Object} Current filters state.\n         */\n        getFiltering: function () {\n            var source = this.source(),\n                keys = ['filters', 'search', 'namespace'];\n\n            if (!source) {\n                return {};\n            }\n\n            return _.pick(source.get('params'), keys);\n        },\n\n        /**\n         * Defines if provided select/deselect actions is relevant.\n         * E.g. there is no need in a 'select page' action if only one\n         * page is available.\n         *\n         * @param {String} actionId - Id of the action to be checked.\n         * @returns {Boolean}\n         */\n        isActionRelevant: function (actionId) {\n            var pageIds         = this.getIds().length,\n                multiplePages   = pageIds < this.totalRecords(),\n                relevant        = true;\n\n            switch (actionId) {\n                case 'selectPage':\n                    relevant = multiplePages && !this.isPageSelected(true);\n                    break;\n\n                case 'deselectPage':\n                    relevant =  multiplePages && this.isPageSelected();\n                    break;\n\n                case 'selectAll':\n                    relevant = !this.allSelected();\n                    break;\n\n                case 'deselectAll':\n                    relevant = this.totalSelected() > 0;\n            }\n\n            return relevant;\n        },\n\n        /**\n         * Checks if current page has selected records.\n         *\n         * @param {Boolean} [all=false] - If set to 'true' checks that every\n         *      record on the page is selected. Otherwise checks that\n         *      page has some selected records.\n         * @returns {Boolean}\n         */\n        isPageSelected: function (all) {\n            var pageIds = this.getIds(),\n                selected = this.selected(),\n                excluded = this.excluded(),\n                iterator = all ? 'every' : 'some';\n\n            if (this.allSelected()) {\n                return true;\n            }\n\n            if (this.excludeMode()) {\n                return pageIds[iterator](function (id) {\n                    return !~excluded.indexOf(id);\n                });\n            }\n\n            return pageIds[iterator](function (id) {\n                return !!~selected.indexOf(id);\n            });\n        },\n\n        /**\n         * Updates values of the 'allSelected'\n         * and 'indetermine' properties.\n         *\n         * @returns {Multiselect} Chainable.\n         */\n        updateState: function () {\n            var selected        = this.selected().length,\n                excluded        = this.excluded().length,\n                totalSelected   = this.totalSelected(),\n                totalRecords    = this.totalRecords(),\n                allSelected     = totalRecords && totalSelected === totalRecords;\n\n            if (this.excludeMode()) {\n                if (excluded === totalRecords && !this.preserveSelectionsOnFilter) {\n                    this.deselectAll();\n                }\n            } else if (totalRecords && selected === totalRecords && !this.preserveSelectionsOnFilter) {\n                this.selectAll();\n            }\n\n            this.allSelected(allSelected);\n            this.indetermine(totalSelected && !allSelected);\n\n            return this;\n        },\n\n        /**\n         * Overrides base method, because this component\n         * can't have global field action.\n         *\n         * @returns {Boolean} False.\n         */\n        hasFieldAction: function () {\n            return false;\n        },\n\n        /**\n         * Callback method to handle changes of selected items.\n         *\n         * @param {Array} selected - An array of currently selected items.\n         */\n        onSelectedChange: function (selected) {\n            this.updateExcluded(selected)\n                .countSelected()\n                .updateState();\n        },\n\n        /**\n         * Is invoked when rows has changed. Recalculates selected items\n         * based on \"selectMode\" property.\n         */\n        onRowsChange: function () {\n            var newSelections;\n\n            if (this.excludeMode()) {\n                newSelections = _.union(this.getIds(true), this.selected());\n\n                this.selected(newSelections);\n            }\n        },\n\n        /**\n         * Is invoked when filtration is applied or removed\n         */\n        onFilter: function () {\n            if (!this.preserveSelectionsOnFilter) {\n                this.deselectAll();\n            }\n        },\n\n        /**\n         * Is invoked when search is applied or removed\n         */\n        onSearch: function () {\n            this.onFilter();\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/onoff.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mage/translate',\n    './multiselect',\n    'uiRegistry'\n], function (_, $t, Column, registry) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            headerTmpl: 'ui/grid/columns/onoff',\n            bodyTmpl: 'ui/grid/cells/onoff',\n            fieldClass: {\n                'admin__scope-old': true,\n                'data-grid-onoff-cell': true,\n                'data-grid-checkbox-cell': false\n            },\n            imports: {\n                selectedData: '${ $.provider }:data.selectedData'\n            },\n            listens: {\n                '${ $.provider }:reloaded': 'setDefaultSelections'\n            }\n        },\n\n        /**\n         * @param {Number} id\n         * @returns {*}\n         */\n        getLabel: function (id) {\n            return this.selected.indexOf(id) !== -1 ? $t('On') : $t('Off');\n        },\n\n        /**\n         * Sets the ids for preselected elements\n         * @returns void\n         */\n        setDefaultSelections: function () {\n            var positionCacheValid = registry.get('position_cache_valid'),\n                selectedFromCache = registry.get('selected_cache'),\n                key,\n                i;\n\n            if (positionCacheValid && this.selected().length === 0) {\n                // Check selected data\n                selectedFromCache = JSON.parse(selectedFromCache);\n\n                for (i = 0; i < selectedFromCache.length; i++) {\n                    this.selected.push(selectedFromCache[i]);\n                }\n\n                registry.set('position_cache_valid', true);\n                registry.set('selected_cache', JSON.stringify(this.selected()));\n\n                return;\n            }\n\n            if (positionCacheValid && this.selected().length > 0) {\n                registry.set('position_cache_valid', true);\n                registry.set('selected_cache', JSON.stringify(this.selected()));\n\n                return;\n            }\n\n            if (this.selectedData.length === 0) {\n                registry.set('position_cache_valid', true);\n                registry.set('selected_cache', JSON.stringify([]));\n\n                return;\n            }\n\n            // Check selected data\n            for (key in this.selectedData) {\n                if (this.selectedData.hasOwnProperty(key) && this.selected().indexOf(key) === -1) {\n                    this.selected.push(key);\n                }\n            }\n            // Uncheck unselected data\n            for (i = 0; i < this.selected().length; i++) {\n                key = this.selected()[i];\n                this.selectedData.hasOwnProperty(key) || this.selected.splice(this.selected().indexOf(key), 1);\n                this.selectedData.hasOwnProperty(key) || i--;\n            }\n            registry.set('position_cache_valid', true);\n            registry.set('selected_cache', JSON.stringify(this.selected()));\n        },\n\n        /**\n         * Show/hide action in the massaction menu\n         * @param {Number} actionId\n         * @returns {Boolean}\n         */\n        isActionRelevant: function (actionId) {\n            var relevant = true;\n\n            switch (actionId) {\n                case 'selectPage':\n                    relevant = !this.isPageSelected(true);\n                    break;\n\n                case 'deselectPage':\n                    relevant =  this.isPageSelected();\n                    break;\n            }\n\n            return relevant;\n        },\n\n        /**\n         * Updates values of the 'allSelected'\n         * and 'indetermine' properties.\n         *\n         * @returns {Object} Chainable.\n         */\n        updateState: function () {\n            var positionCacheValid = registry.get('position_cache_valid'),\n                totalRecords    = this.totalRecords(),\n                selected        = this.selected().length,\n                excluded        = this.excluded().length,\n                totalSelected   = this.totalSelected(),\n                allSelected;\n\n            if (positionCacheValid && this.selected().length > 0) {\n                registry.set('position_cache_valid', true);\n                registry.set('selected_cache', JSON.stringify(this.selected()));\n            }\n\n            // When filters are enabled then totalRecords is unknown\n            if (this.getFiltering()) {\n                if (this.getFiltering().search !== '') {\n                    totalRecords = -1;\n                }\n            }\n\n            allSelected = totalRecords && totalSelected === totalRecords;\n\n            if (this.excludeMode()) {\n                if (excluded === totalRecords) {\n                    this.deselectAll();\n                }\n            } else if (totalRecords && selected === totalRecords) {\n                this.selectAll();\n            }\n\n            this.allSelected(allSelected);\n            this.indetermine(totalSelected && !allSelected);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/overlay.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/columns/overlay'\n        },\n\n        /**\n         * If overlay should be visible\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isVisible: function (row) {\n            return !!row[this.index];\n        },\n\n        /**\n         * Get overlay label\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getLabel: function (row) {\n            return row[this.index];\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    './column'\n], function (_, Column) {\n    'use strict';\n\n    return Column.extend({\n        /**\n         * Retrieves label associated with a provided value.\n         *\n         * @returns {String}\n         */\n        getLabel: function () {\n            var options = this.options || [],\n                values = this._super(),\n                label = [];\n\n            if (_.isString(values)) {\n                values = values.split(',');\n            }\n\n            if (!_.isArray(values)) {\n                values = [values];\n            }\n\n            values = values.map(function (value) {\n                return value + '';\n            });\n\n            options = this.flatOptions(options);\n\n            options.forEach(function (item) {\n                if (_.contains(values, item.value + '')) {\n                    label.push(item.label);\n                }\n            });\n\n            return label.join(', ');\n        },\n\n        /**\n         * Transformation tree options structure to liner array.\n         *\n         * @param {Array} options\n         * @returns {Array}\n         */\n        flatOptions: function (options) {\n            var self = this;\n\n            if (!_.isArray(options)) {\n                options = _.values(options);\n            }\n\n            return options.reduce(function (opts, option) {\n                if (_.isArray(option.value)) {\n                    opts = opts.concat(self.flatOptions(option.value));\n                } else {\n                    opts.push(option);\n                }\n\n                return opts;\n            }, []);\n        }\n    });\n});\n","Magento_Ui/js/grid/columns/thumbnail.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    './column',\n    'jquery',\n    'mage/template',\n    'text!Magento_Ui/templates/grid/cells/thumbnail/preview.html',\n    'underscore',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function (Column, $, mageTemplate, thumbnailPreviewTemplate, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/cells/thumbnail',\n            fieldClass: {\n                'data-grid-thumbnail-cell': true\n            }\n        },\n\n        /**\n         * Get image source data per row.\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getSrc: function (row) {\n            return row[this.index + '_src'];\n        },\n\n        /**\n         * Get original image source data per row.\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getOrigSrc: function (row) {\n            return row[this.index + '_orig_src'];\n        },\n\n        /**\n         * Get link data per row.\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getLink: function (row) {\n            return row[this.index + '_link'];\n        },\n\n        /**\n         * Get alternative text data per row.\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getAlt: function (row) {\n            return _.escape(row[this.index + '_alt']);\n        },\n\n        /**\n         * Check if preview available.\n         *\n         * @returns {Boolean}\n         */\n        isPreviewAvailable: function () {\n            return this['has_preview'] || false;\n        },\n\n        /**\n         * Build preview.\n         *\n         * @param {Object} row\n         */\n        preview: function (row) {\n            var modalHtml = mageTemplate(\n                    thumbnailPreviewTemplate,\n                    {\n                        src: this.getOrigSrc(row), alt: this.getAlt(row), link: this.getLink(row),\n                        linkText: $.mage.__('Go to Details Page')\n                    }\n                ),\n                previewPopup = $('<div></div>').html(modalHtml);\n\n            previewPopup.modal({\n                title: this.getAlt(row),\n                innerScroll: true,\n                modalClass: '_image-box',\n                buttons: []\n            }).trigger('openModal');\n        },\n\n        /**\n         * Get field handler per row.\n         *\n         * @param {Object} row\n         * @returns {Function}\n         */\n        getFieldHandler: function (row) {\n            if (this.isPreviewAvailable()) {\n                return this.preview.bind(this, row);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/controls/columns.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'mage/translate',\n    'uiCollection'\n], function (_, utils, $t, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/controls/columns',\n            minVisible: 1,\n            maxVisible: 30,\n            viewportSize: 18,\n            displayArea: 'dataGridActions',\n            columnsProvider: 'ns = ${ $.ns }, componentType = columns',\n            imports: {\n                addColumns: '${ $.columnsProvider }:elems'\n            },\n            templates: {\n                headerMsg: $t('${ $.visible } out of ${ $.total } visible')\n            }\n        },\n\n        /**\n         * Resets columns visibility to theirs default state.\n         *\n         * @returns {Columns} Chainable.\n         */\n        reset: function () {\n            this.elems.each('applyState', 'default', 'visible');\n\n            return this;\n        },\n\n        /**\n         * Applies last saved state of columns visibility.\n         *\n         * @returns {Columns} Chainable.\n         */\n        cancel: function () {\n            this.elems.each('applyState', '', 'visible');\n\n            return this;\n        },\n\n        /**\n         * Adds columns whose visibility can be controlled to the component.\n         *\n         * @param {Array} columns - Elements array that will be added to component.\n         * @returns {Columns} Chainable.\n         */\n        addColumns: function (columns) {\n            columns = _.where(columns, {\n                controlVisibility: true\n            });\n\n            this.insertChild(columns);\n\n            return this;\n        },\n\n        /**\n         * Defines whether child elements array length\n         * is greater than the 'viewportSize' property.\n         *\n         * @returns {Boolean}\n         */\n        hasOverflow: function () {\n            return this.elems().length > this.viewportSize;\n        },\n\n        /**\n         * Helper, checks\n         *  - if less than one item choosen\n         *  - if more then viewportMaxSize choosen\n         *\n         * @param {Object} elem\n         * @returns {Boolean}\n         */\n        isDisabled: function (elem) {\n            var visible = this.countVisible();\n\n            return elem.visible ?\n                    visible === this.minVisible :\n                    visible === this.maxVisible;\n        },\n\n        /**\n         * Counts number of visible columns.\n         *\n         * @returns {Number}\n         */\n        countVisible: function () {\n            return this.elems.filter('visible').length;\n        },\n\n        /**\n         * Compile header message from headerMessage setting.\n         *\n         * @returns {String}\n         */\n        getHeaderMessage: function () {\n            return utils.template(this.templates.headerMsg, {\n                visible: this.countVisible(),\n                total: this.elems().length\n            });\n        }\n    });\n});\n","Magento_Ui/js/grid/controls/bookmarks/bookmarks.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'mage/translate',\n    'rjsResolver',\n    'uiLayout',\n    'uiCollection'\n], function (_, utils, $t, resolver, layout, Collection) {\n    'use strict';\n\n    /**\n     * Removes 'current' namespace from a 'path' string.\n     *\n     * @param {String} path\n     * @returns {String} Path without namespace.\n     */\n    function removeStateNs(path) {\n        path = typeof path == 'string' ? path.split('.') : [];\n\n        if (path[0] === 'current') {\n            path.shift();\n        }\n\n        return path.join('.');\n    }\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/controls/bookmarks/bookmarks',\n            viewTmpl: 'ui/grid/controls/bookmarks/view',\n            newViewLabel: $t('New View'),\n            defaultIndex: 'default',\n            activeIndex: 'default',\n            viewsArray: [],\n            storageConfig: {\n                provider: '${ $.storageConfig.name }',\n                name: '${ $.name }_storage',\n                component: 'Magento_Ui/js/grid/controls/bookmarks/storage'\n            },\n            views: {\n                default: {\n                    label: $t('Default View'),\n                    index: 'default',\n                    editable: false\n                }\n            },\n            tracks: {\n                editing: true,\n                viewsArray: true,\n                activeView: true,\n                hasChanges: true,\n                customLabel: true,\n                customVisible: true\n            },\n            listens: {\n                activeIndex: 'onActiveIndexChange',\n                activeView: 'checkState',\n                current: 'onStateChange'\n            }\n        },\n\n        /**\n         * Initializes bookmarks component.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        initialize: function () {\n            utils.limit(this, 'checkState', 5);\n            utils.limit(this, 'saveState', 2000);\n\n            this._super()\n                .restore()\n                .initStorage()\n                .initViews();\n\n            return this;\n        },\n\n        /**\n         * Creates custom storage instance.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        initStorage: function () {\n            layout([this.storageConfig]);\n\n            return this;\n        },\n\n        /**\n         * Defines default data if it wasn't gathered previously.\n         *\n         * @private\n         * @returns {Bookmarks} Chainbale.\n         */\n        initDefaultView: function () {\n            var data = this.getViewData(this.defaultIndex);\n\n            if (!_.size(data) && (this.current.columns && this.current.positions)) {\n                    this.setViewData(this.defaultIndex, this.current)\n                        .saveView(this.defaultIndex);\n                    this.defaultDefined = true;\n            }\n\n            return this;\n        },\n\n        /**\n         * Creates instances of a previously saved views.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        initViews: function () {\n            _.each(this.views, function (config) {\n                this.addView(config);\n            }, this);\n\n            this.activeView = this.getActiveView();\n\n            return this;\n        },\n\n        /**\n         * Creates complete configuration for a view.\n         *\n         * @param {Object} [config] - Additional configuration object.\n         * @returns {Object}\n         */\n        buildView: function (config) {\n            var view = {\n                label: this.newViewLabel,\n                index: '_' + Date.now(),\n                editable: true\n            };\n\n            utils.extend(view, config || {});\n\n            view.data   = view.data || utils.copy(this.current);\n            view.value  = view.label;\n\n            this.observe.call(view, true, 'label value');\n\n            return view;\n        },\n\n        /**\n         * Creates instance of a view with a provided configuration.\n         *\n         * @param {Object} [config] - View configuration.\n         * @param {Boolean} [saveView=false] - Whether to save created view automatically or not.\n         * @param {Boolean} [applyView=false] - Whether to apply created view automatically or not.\n         * @returns {View} Created view.\n         */\n        addView: function (config, saveView, applyView) {\n            var view    = this.buildView(config),\n                index   = view.index;\n\n            this.views[index] = view;\n\n            if (saveView) {\n                this.saveView(index);\n            }\n\n            if (applyView) {\n                this.applyView(index);\n            }\n\n            this.updateArray();\n\n            return view;\n        },\n\n        /**\n         * Removes specified view.\n         *\n         * @param {String} index - Index of a view to be removed.\n         * @returns {Bookmarks} Chainable.\n         */\n        removeView: function (index) {\n            var viewPath = this.getViewPath(index);\n\n            if (this.isViewActive(index)) {\n                this.applyView(this.defaultIndex);\n            }\n\n            this.endEdit(index)\n                .remove(viewPath)\n                .removeStored(viewPath)\n                .updateArray();\n\n            return this;\n        },\n\n        /**\n         * Saves data of a specified view.\n         *\n         * @param {String} index - Index of a view to be saved.\n         * @returns {Bookmarks} Chainable.\n         */\n        saveView: function (index) {\n            var viewPath = this.getViewPath(index);\n\n            this.updateViewLabel(index)\n                .endEdit(index)\n                .store(viewPath)\n                .checkState();\n\n            return this;\n        },\n\n        /**\n         * Sets specified view as active\n         * and applies its' state.\n         *\n         * @param {String} index - Index of a view to be applied.\n         * @returns {Bookmarks} Chainable.\n         */\n        applyView: function (index) {\n            this.applyStateOf(index)\n                .set('activeIndex', index);\n\n            return this;\n        },\n\n        /**\n         * Updates data of a specified view if it's\n         * currently active and saves its' data.\n         *\n         * @param {String} index - Index of a view.\n         * @returns {Bookmarks} Chainable.\n         */\n        updateAndSave: function (index) {\n            if (this.isViewActive(index)) {\n                this.updateActiveView(index);\n            }\n\n            this.saveView(index);\n\n            return this;\n        },\n\n        /**\n         * Returns instance of a specified view.\n         *\n         * @param {String} index - Index of a view to be retrieved.\n         * @returns {View}\n         */\n        getView: function (index) {\n            return this.views[index];\n        },\n\n        /**\n         * Returns instance of an active view.\n         *\n         * @returns {View}\n         */\n        getActiveView: function () {\n            return this.views[this.activeIndex];\n        },\n\n        /**\n         * Checks if specified view is active.\n         *\n         * @param {String} index - Index of a view to be checked.\n         * @returns {Boolean}\n         */\n        isViewActive: function (index) {\n            return this.activeView === this.getView(index);\n        },\n\n        /**\n         * Sets current state as a data of an active view.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        updateActiveView: function () {\n            this.setViewData(this.activeIndex, this.current);\n\n            return this;\n        },\n\n        /**\n         * Replaces label a view with a provided one.\n         * If new label is not specified, then views'\n         * 'value' property will be taken.\n         *\n         * @param {String} index - Index of a view.\n         * @param {String} [label=view.value] - New labels' value.\n         * @returns {Bookmarks} Chainable.\n         */\n        updateViewLabel: function (index, label) {\n            var view    = this.getView(index),\n                current = view.label;\n\n            label = (label || view.value).trim() || current;\n            label = this.uniqueLabel(label, current);\n\n            view.label = view.value = label;\n\n            return this;\n        },\n\n        /**\n         * Retrieves data of a specified view.\n         *\n         * @param {String} index - Index of a view whose data should be retrieved.\n         * @param {String} [property] - If not specified then whole views' data will be retrieved.\n         * @returns {Object} Views' data.\n         */\n        getViewData: function (index, property) {\n            var view = this.getView(index),\n                data = view.data;\n\n            if (property) {\n                data = utils.nested(data, property);\n            }\n\n            return utils.copy(data);\n        },\n\n        /**\n         * Sets data to the specified view.\n         *\n         * @param {String} index - Index of a view whose data will be replaced.\n         * @param {Object} data - New view data.\n         * @returns {Bookmarks} Chainable.\n         */\n        setViewData: function (index, data) {\n            var path = this.getViewPath(index) + '.data';\n\n            this.set(path, utils.copy(data));\n\n            return this;\n        },\n\n        /**\n         * Starts editing of a specified view.\n         *\n         * @param {String} index - Index of a view.\n         * @returns {Bookmarks} Chainable.\n         */\n        editView: function (index) {\n            this.editing = index;\n\n            return this;\n        },\n\n        /**\n         * Ends editing of specified view\n         * and restores its' label.\n         *\n         * @param {String} index - Index of a view.\n         * @returns {Bookmarks} Chainable.\n         */\n        endEdit: function (index) {\n            var view;\n\n            if (!this.isEditing(index)) {\n                return this;\n            }\n\n            index   = index || this.editing;\n            view    = this.getView(index);\n\n            view.value = view.label;\n\n            this.editing = false;\n\n            return this;\n        },\n\n        /**\n         * Checks if specified view is in editing state.\n         *\n         * @param {String} index - Index of a view to be checked.\n         * @returns {Boolean}\n         */\n        isEditing: function (index) {\n            return this.editing === index;\n        },\n\n        /**\n         * Generates label unique among present views, based\n         * on the incoming label pattern.\n         *\n         * @param {String} [label=this.newViewLabel] - Label pattern.\n         * @param {String} [exclude]\n         * @returns {String}\n         */\n        uniqueLabel: function (label, exclude) {\n            var labels      = _.pluck(this.views, 'label'),\n                hasParenth  = _.last(label) === ')',\n                index       = 2,\n                result,\n                suffix;\n\n            labels = _.without(labels, exclude);\n            result = label = label || this.newViewLabel;\n\n            for (index = 2; _.contains(labels, result); index++) {\n                suffix = '(' + index + ')';\n\n                if (!hasParenth) {\n                    suffix = ' ' + suffix;\n                }\n\n                result = label + suffix;\n            }\n\n            return result;\n        },\n\n        /**\n         * Applies state of a specified view, without\n         * making it active.\n         *\n         * @param {String} [state=this.activeIndex]\n         * @param {String} [property]\n         * @returns {Bookmarks} Chainable.\n         */\n        applyStateOf: function (state, property) {\n            var index    = state || this.activeIndex,\n                dataPath = removeStateNs(property),\n                viewData = this.getViewData(index, dataPath);\n\n            dataPath = dataPath ?\n                'current.' + dataPath :\n                'current';\n\n            this.set(dataPath, viewData);\n\n            return this;\n        },\n\n        /**\n         * Saves current state.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        saveState: function () {\n            this.store('current');\n            return this;\n        },\n\n        /**\n         * Applies state of an active view.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        resetState: function () {\n            this.applyStateOf(this.activeIndex);\n\n            return this;\n        },\n\n        /**\n         * Checks if current state is different\n         * from the state of an active view.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        checkState: function () {\n            var viewData = this.getViewData(this.activeIndex),\n                diff     = utils.compare(viewData, this.current);\n\n            this.hasChanges = !diff.equal;\n\n            return this;\n        },\n\n        /**\n         * Returns path to the view instance,\n         * based on a provided index.\n         *\n         * @param {String} index - Index of a view.\n         * @returns {String}\n         */\n        getViewPath: function (index) {\n            return 'views.' + index;\n        },\n\n        /**\n         * Updates the array of views.\n         *\n         * @returns {Bookmarks} Chainable\n         */\n        updateArray: function () {\n            this.viewsArray = _.values(this.views);\n\n            return this;\n        },\n\n        /**\n         * Shows custom view field and creates unique label for it.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        showCustom: function () {\n            this.customLabel    = this.uniqueLabel();\n            this.customVisible  = true;\n\n            return this;\n        },\n\n        /**\n         * Hides custom view field.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        hideCustom: function () {\n            this.customVisible = false;\n\n            return this;\n        },\n\n        /**\n         * Checks if custom view field is visible.\n         *\n         * @returns {Boolean}\n         */\n        isCustomVisible: function () {\n            return this.customVisible;\n        },\n\n        /**\n         * Creates new view instance with a label specified\n         * in a custom view field.\n         *\n         * @returns {Bookmarks} Chainable.\n         */\n        applyCustom: function () {\n            var label = this.customLabel.trim();\n\n            this.hideCustom()\n                .addView({\n                    label: this.uniqueLabel(label)\n                }, true, true);\n\n            return this;\n        },\n\n        /**\n         * Listener of the activeIndex property.\n         */\n        onActiveIndexChange: function () {\n            this.activeView = this.getActiveView();\n            this.updateActiveView();\n            this.store('activeIndex');\n        },\n\n        /**\n         * Listener of the activeIndex property.\n         */\n        onStateChange: function () {\n            this.checkState();\n            this.saveState();\n\n            if (!this.defaultDefined) {\n                resolver(this.initDefaultView, this);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/controls/bookmarks/storage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'mageUtils',\n    'Magento_Ui/js/lib/core/storage/local',\n    'uiClass'\n], function ($, utils, storage, Class) {\n    'use strict';\n\n    /**\n     * Removes ns prefix for path.\n     *\n     * @param {String} ns\n     * @param {String} path\n     * @returns {String}\n     */\n    function removeNs(ns, path) {\n        return path.replace(ns + '.', '');\n    }\n\n    return Class.extend({\n        defaults: {\n            ajaxSettings: {\n                method: 'POST',\n                data: {\n                    namespace: '${ $.namespace }'\n                }\n            }\n        },\n\n        /**\n         * Delegates call to the localStorage adapter.\n         */\n        get: function () {\n            return {};\n        },\n\n        /**\n         * Sends request to store specified data.\n         *\n         * @param {String} path - Path by which data should be stored.\n         * @param {*} value - Value to be sent.\n         */\n        set: function (path, value) {\n            var property = removeNs(this.namespace, path),\n                data = {},\n                config;\n\n            utils.nested(data, property, value);\n\n            config = utils.extend({\n                url: this.saveUrl,\n                data: {\n                    data: JSON.stringify(data)\n                }\n            }, this.ajaxSettings);\n\n            $.ajax(config);\n        },\n\n        /**\n         * Sends request to remove specified data.\n         *\n         * @param {String} path - Path to the property to be removed.\n         */\n        remove: function (path) {\n            var property = removeNs(this.namespace, path),\n                config;\n\n            config = utils.extend({\n                url: this.deleteUrl,\n                data: {\n                    data: property\n                }\n            }, this.ajaxSettings);\n\n            $.ajax(config);\n        }\n    });\n});\n","Magento_Ui/js/grid/controls/button/split.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (data, element) {\n\n        $(element).on('click.splitDefault', '.action-default', function () {\n            $(this).siblings('.dropdown-menu').find('.item-default').trigger('click');\n        });\n    };\n});\n","Magento_Ui/js/grid/editing/bulk.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    './record'\n], function (_, utils, Record) {\n    'use strict';\n\n    /**\n     * Removes empty properties from the provided object.\n     *\n     * @param {Object} data - Object to be processed.\n     * @returns {Object}\n     */\n    function removeEmpty(data) {\n        data = utils.flatten(data);\n        data = _.omit(data, utils.isEmpty);\n\n        return utils.unflatten(data);\n    }\n\n    return Record.extend({\n        defaults: {\n            template: 'ui/grid/editing/bulk',\n            active: false,\n            templates: {\n                fields: {\n                    select: {\n                        caption: ' '\n                    }\n                }\n            },\n            imports: {\n                active: '${ $.editorProvider }:isMultiEditing'\n            },\n            listens: {\n                data: 'updateState',\n                active: 'updateState'\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Bulk} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    hasData: false\n                });\n\n            return this;\n        },\n\n        /**\n         * Extends original method to disable possible\n         * 'required-entry' validation rule.\n         *\n         * @returns {Object} Columns' field definition.\n         */\n        buildField: function () {\n            var field = this._super(),\n                rules = field.validation;\n\n            if (rules) {\n                delete rules['required-entry'];\n            }\n\n            return field;\n        },\n\n        /**\n         * Applies current data to all active records.\n         *\n         * @returns {Bulk} Chainable.\n         */\n        apply: function () {\n            if (this.isValid()) {\n                this.applyData()\n                    .clear();\n            }\n\n            return this;\n        },\n\n        /**\n         * Sets available data to all active records.\n         *\n         * @param {Object} [data] -  If not specified, then current fields data will be used.\n         * @returns {Bulk} Chainable.\n         */\n        applyData: function (data) {\n            data = data || this.getData();\n\n            this.editor('setData', data, true);\n\n            return this;\n        },\n\n        /**\n         * Returns data of all non-empty fields.\n         *\n         * @returns {Object} Fields data without empty values.\n         */\n        getData: function () {\n            return removeEmpty(this._super());\n        },\n\n        /**\n         * Updates own 'hasData' property and defines\n         * whether regular rows editing can be resumed.\n         *\n         * @returns {Bulk} Chainable.\n         */\n        updateState: function () {\n            var fields  = _.keys(this.getData()),\n                hasData = !!fields.length;\n\n            this.hasData = hasData;\n\n            if (!this.active()) {\n                fields = [];\n            }\n\n            this.editor('disableFields', fields);\n            this.editor('canSave', !fields.length);\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/editing/client.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mageUtils',\n    'uiClass'\n], function ($, _, utils, Class) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            validateBeforeSave: true,\n            requestConfig: {\n                dataType: 'json',\n                type: 'POST'\n            }\n        },\n\n        /**\n         * Initializes client instance.\n         *\n         * @returns {Client} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this, 'onSuccess', 'onError');\n\n            return this._super();\n        },\n\n        /**\n         * Sends XMLHttpRequest with a provided configuration.\n         *\n         * @param {Object} config - Configuration of request.\n         * @returns {jQueryPromise}\n         */\n        send: function (config) {\n            var deffer  = $.Deferred();\n\n            config = utils.extend({}, this.requestConfig, config);\n\n            $.ajax(config)\n                .done(_.partial(this.onSuccess, deffer))\n                .fail(_.partial(this.onError, deffer));\n\n            return deffer.promise();\n        },\n\n        /**\n         * Proxy save method which might invoke\n         * data validation prior to its' saving.\n         *\n         * @param {Object} data - Data to be processed.\n         * @returns {jQueryPromise}\n         */\n        save: function (data) {\n            var save = this._save.bind(this, data);\n\n            return this.validateBeforeSave ?\n                this.validate(data).pipe(save) :\n                save();\n        },\n\n        /**\n         * Sends request to validate provided data.\n         *\n         * @param {Object} data - Data to be validated.\n         * @returns {jQueryPromise}\n         */\n        validate: function (data) {\n            return this.send({\n                url: this.validateUrl,\n                data: data\n            });\n        },\n\n        /**\n         * Sends request to save provided data.\n         *\n         * @private\n         * @param {Object} data - Data to be validated.\n         * @returns {jQueryPromise}\n         */\n        _save: function (data) {\n            return this.send({\n                url: this.saveUrl,\n                data: data\n            });\n        },\n\n        /**\n         * Creates error object with a provided message.\n         *\n         * @param {String} msg - Errors' message.\n         * @returns {Object}\n         */\n        createError: function (msg) {\n            return {\n                type: 'error',\n                message: msg\n            };\n        },\n\n        /**\n         * Handles ajax error callback.\n         *\n         * @param {jQueryPromise} promise - Promise to be rejected.\n         * @param {jQueryXHR} xhr - See 'jquery' ajax error callback.\n         * @param {String} status - See 'jquery' ajax error callback.\n         * @param {(String|Object)} err - See 'jquery' ajax error callback.\n         */\n        onError: function (promise, xhr, status, err) {\n            var msg;\n\n            msg = xhr.status !== 200 ?\n                xhr.status + ' (' + xhr.statusText + ')' :\n                err;\n\n            promise.reject(this.createError(msg));\n        },\n\n        /**\n         * Handles ajax success callback.\n         *\n         * @param {jQueryPromise} promise - Promise to be resolved.\n         * @param {*} data - See 'jquery' ajax success callback.\n         */\n        onSuccess: function (promise, data) {\n            var errors;\n\n            if (data.error) {\n                errors = _.map(data.messages, this.createError, this);\n\n                promise.reject(errors);\n            } else {\n                promise.resolve(data);\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/editing/editor-view.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'Magento_Ui/js/lib/view/utils/async',\n    'underscore',\n    'uiRegistry',\n    'uiClass'\n], function (ko, $, _, registry, Class) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            rootSelector: '${ $.columnsProvider }:.admin__data-grid-wrap',\n            tableSelector: '${ $.rootSelector } -> table',\n            rowSelector: '${ $.tableSelector } tbody tr.data-row',\n            headerButtonsTmpl:\n                '<!-- ko template: headerButtonsTmpl --><!-- /ko -->',\n            bulkTmpl:\n                '<!-- ko scope: bulk -->' +\n                    '<!-- ko template: getTemplate() --><!-- /ko -->' +\n                '<!-- /ko -->',\n            rowTmpl:\n                '<!-- ko with: _editor -->' +\n                    '<!-- ko if: isActive($row()._rowIndex, true) -->' +\n                        '<!-- ko with: getRecord($row()._rowIndex, true) -->' +\n                            '<!-- ko template: rowTmpl --><!-- /ko -->' +\n                        '<!-- /ko -->' +\n                        '<!-- ko if: isSingleEditing && singleEditingButtons -->' +\n                            '<!-- ko template: rowButtonsTmpl --><!-- /ko -->' +\n                        '<!-- /ko -->' +\n                    '<!-- /ko -->' +\n               '<!-- /ko -->'\n        },\n\n        /**\n         * Initializes view component.\n         *\n         * @returns {View} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'initRoot',\n                'initTable',\n                'initRow',\n                'rowBindings',\n                'tableBindings'\n            );\n\n            this._super();\n\n            this.model = registry.get(this.model);\n\n            $.async(this.rootSelector, this.initRoot);\n            $.async(this.tableSelector, this.initTable);\n            $.async(this.rowSelector, this.initRow);\n\n            return this;\n        },\n\n        /**\n         * Initializes columns root container.\n         *\n         * @param {HTMLElement} node\n         * @returns {View} Chainable.\n         */\n        initRoot: function (node) {\n            $(this.headerButtonsTmpl)\n                .insertBefore(node)\n                .applyBindings(this.model);\n\n            return this;\n        },\n\n        /**\n         * Initializes table element.\n         *\n         * @param {HTMLTableElement} table\n         * @returns {View} Chainable.\n         */\n        initTable: function (table) {\n            $(table).bindings(this.tableBindings);\n\n            this.initBulk(table);\n\n            return this;\n        },\n\n        /**\n         * Initializes bulk editor element\n         * for the provided table.\n         *\n         * @param {HTMLTableElement} table\n         * @returns {View} Chainable.\n         */\n        initBulk: function (table) {\n            var tableBody = $('tbody', table)[0];\n\n            $(this.bulkTmpl)\n                .prependTo(tableBody)\n                .applyBindings(this.model);\n\n            return this;\n        },\n\n        /**\n         * Initializes table row.\n         *\n         * @param {HTMLTableRowElement} row\n         * @returns {View} Chainable.\n         */\n        initRow: function (row) {\n            var $editingRow;\n\n            $(row).extendCtx({\n                    _editor: this.model\n                }).bindings(this.rowBindings);\n\n            $editingRow = $(this.rowTmpl)\n                .insertBefore(row)\n                .applyBindings(row);\n\n            ko.utils.domNodeDisposal.addDisposeCallback(row, this.removeEditingRow.bind(this, $editingRow));\n\n            return this;\n        },\n\n        /**\n         * Returns row bindings.\n         *\n         * @param {Object} ctx - Current context of a row.\n         * @returns {Object}\n         */\n        rowBindings: function (ctx) {\n            var model = this.model;\n\n            return {\n                visible: ko.computed(function () {\n                    var record = ctx.$row(),\n                        index = record && record._rowIndex;\n\n                    return !model.isActive(index, true);\n                })\n            };\n        },\n\n        /**\n         * Returns table bindings.\n         *\n         * @returns {Object}\n         */\n        tableBindings: function () {\n            var model = this.model;\n\n            return {\n                css: {\n                    '_in-edit': ko.computed(function () {\n                        return model.hasActive() && !model.permanentlyActive;\n                    })\n                }\n            };\n        },\n\n        /**\n         * Removes specified array of nodes.\n         *\n         * @param {ArrayLike} row\n         */\n        removeEditingRow: function (row) {\n            _.toArray(row).forEach(ko.removeNode);\n        }\n    });\n});\n","Magento_Ui/js/grid/editing/editor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'mage/translate',\n    'uiCollection'\n], function (_, utils, layout, $t, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            rowButtonsTmpl: 'ui/grid/editing/row-buttons',\n            headerButtonsTmpl: 'ui/grid/editing/header-buttons',\n            successMsg: $t('You have successfully saved your edits.'),\n            errorsCount: 0,\n            bulkEnabled: true,\n            multiEditingButtons: true,\n            singleEditingButtons: true,\n            isMultiEditing: false,\n            isSingleEditing: false,\n            permanentlyActive: false,\n            rowsData: [],\n            fields: {},\n\n            templates: {\n                record: {\n                    parent: '${ $.$data.editor.name }',\n                    name: '${ $.$data.recordId }',\n                    component: 'Magento_Ui/js/grid/editing/record',\n                    columnsProvider: '${ $.$data.editor.columnsProvider }',\n                    editorProvider: '${ $.$data.editor.name }',\n                    preserveFields: {\n                        '${ $.$data.editor.indexField }': true\n                    }\n                }\n            },\n            bulkConfig: {\n                component: 'Magento_Ui/js/grid/editing/bulk',\n                name: '${ $.name }_bulk',\n                editorProvider: '${ $.name }',\n                columnsProvider: '${ $.columnsProvider }'\n            },\n            clientConfig: {\n                component: 'Magento_Ui/js/grid/editing/client',\n                name: '${ $.name }_client'\n            },\n            viewConfig: {\n                component: 'Magento_Ui/js/grid/editing/editor-view',\n                name: '${ $.name }_view',\n                model: '${ $.name }',\n                columnsProvider: '${ $.columnsProvider }'\n            },\n            imports: {\n                rowsData: '${ $.dataProvider }:data.items'\n            },\n            listens: {\n                '${ $.dataProvider }:reloaded': 'cancel',\n                '${ $.selectProvider }:selected': 'onSelectionsChange'\n            },\n            modules: {\n                source: '${ $.dataProvider }',\n                client: '${ $.clientConfig.name }',\n                columns: '${ $.columnsProvider }',\n                bulk: '${ $.bulkConfig.name }',\n                selections: '${ $.selectProvider }'\n            }\n        },\n\n        /**\n         * Initializes editor component.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this, 'updateState', 'countErrors', 'onDataSaved', 'onSaveError');\n\n            this._super()\n                .initBulk()\n                .initClient()\n                .initView();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'errorsCount',\n                    'isMultiEditing',\n                    'isSingleEditing',\n                    'isSingleColumnEditing',\n                    'changed'\n                ])\n                .observe({\n                    canSave: true,\n                    activeRecords: [],\n                    messages: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Initializes bulk editing component.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initBulk: function () {\n            if (this.bulkEnabled) {\n                layout([this.bulkConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes editors' view component.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initView: function () {\n            layout([this.viewConfig]);\n\n            return this;\n        },\n\n        /**\n         * Initializes client component.\n         *\n         * @returns {Editor} Chainable.\n         */\n        initClient: function () {\n            layout([this.clientConfig]);\n\n            return this;\n        },\n\n        /**\n         * Creates instance of a new record.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Editor} Chainable.\n         */\n        initRecord: function (id, isIndex) {\n            var record = this.buildRecord(id, isIndex);\n\n            layout([record]);\n\n            return this;\n        },\n\n        /**\n         * Adds listeners on a new record.\n         *\n         * @param {Record} record\n         * @returns {Editor} Chainable.\n         */\n        initElement: function (record) {\n            record.on({\n                'active': this.updateState,\n                'errorsCount': this.countErrors\n            });\n\n            this.updateState();\n\n            return this._super();\n        },\n\n        /**\n         * Creates configuration for a new record associated with a row data.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Object} Record configuration.\n         */\n        buildRecord: function (id, isIndex) {\n            var recordId = this.getId(id, isIndex),\n                recordTmpl = this.templates.record,\n                record;\n\n            if (this.getRecord(recordId)) {\n                return this;\n            }\n\n            record = utils.template(recordTmpl, {\n                editor: this,\n                recordId: id\n            });\n\n            record.recordId = id;\n            record.data     = this.getRowData(id);\n\n            return record;\n        },\n\n        /**\n         * Starts editing of a specified record. If records'\n         * instance doesn't exist, than it will be created.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Editor} Chainable.\n         */\n        edit: function (id, isIndex) {\n            var recordId = this.getId(id, isIndex),\n                record   = this.getRecord(recordId);\n\n            record ?\n                record.active(true) :\n                this.initRecord(recordId);\n\n            return this;\n        },\n\n        /**\n         * Drops list of selections while activating only the specified record.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Editor} Chainable.\n         */\n        startEdit: function (id, isIndex) {\n            var recordId = this.getId(id, isIndex);\n\n            this.selections()\n                .deselectAll()\n                .select(recordId);\n\n            return this.edit(recordId);\n        },\n\n        /**\n         * Hides records and resets theirs data.\n         *\n         * @returns {Editor} Chainable.\n         */\n        cancel: function () {\n            this.reset()\n                .hide()\n                .clearMessages()\n                .bulk('clear');\n\n            return this;\n        },\n\n        /**\n         * Hides records.\n         *\n         * @returns {Editor} Chainable.\n         */\n        hide: function () {\n            this.activeRecords.each('active', false);\n\n            return this;\n        },\n\n        /**\n         * Resets active records.\n         *\n         * @returns {Editor} Chainable.\n         */\n        reset: function () {\n            this.elems.each(function (record) {\n                this.resetRecord(record.recordId);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Validates and saves data of active records.\n         *\n         * @returns {Editor} Chainable.\n         */\n        save: function () {\n            var data;\n\n            if (!this.isValid()) {\n                return this;\n            }\n\n            data = {\n                items: this.getData()\n            };\n\n            this.clearMessages()\n                .columns('showLoader');\n\n            this.client()\n                .save(data)\n                .done(this.onDataSaved)\n                .fail(this.onSaveError);\n\n            return this;\n        },\n\n        /**\n         * Validates all active records.\n         *\n         * @returns {Array} An array of records and theirs validation results.\n         */\n        validate: function () {\n            return this.activeRecords.map(function (record) {\n                return {\n                    target: record,\n                    valid: record.isValid()\n                };\n            });\n        },\n\n        /**\n         * Checks if all active records are valid.\n         *\n         * @returns {Boolean}\n         */\n        isValid: function () {\n            return _.every(this.validate(), 'valid');\n        },\n\n        /**\n         * Returns active records data, indexed by a theirs ids.\n         *\n         * @returns {Object} Collection of records data.\n         */\n        getData: function () {\n            var data = this.activeRecords.map(function (record) {\n                var elemKey,\n                    recordData = record.getData();\n\n                for (elemKey in recordData) {\n                    if (_.isUndefined(recordData[elemKey])) {\n                        recordData[elemKey] = null;\n                    }\n                }\n\n                return recordData;\n            });\n\n            return _.indexBy(data, this.indexField);\n        },\n\n        /**\n         * Sets provided data to all active records.\n         *\n         * @param {Object} data - See 'setData' method of a 'Record'.\n         * @param {Boolean} partial - See 'setData' method of a 'Record'.\n         * @returns {Editor} Chainable.\n         */\n        setData: function (data, partial) {\n            this.activeRecords.each('setData', data, partial);\n\n            return this;\n        },\n\n        /**\n         * Resets specific records' data\n         * to the data present in associated row.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Editor} Chainable.\n         */\n        resetRecord: function (id, isIndex) {\n            var record  = this.getRecord(id, isIndex),\n                data    = this.getRowData(id, isIndex);\n\n            if (record && data) {\n                record.setData(data);\n            }\n\n            return this;\n        },\n\n        /**\n         * Returns instance of a specified record.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Record}\n         */\n        getRecord: function (id, isIndex) {\n            return this.elems.findWhere({\n                recordId: this.getId(id, isIndex)\n            });\n        },\n\n        /**\n         * Creates record name based on a provided id.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {String}\n         */\n        formRecordName: function (id, isIndex) {\n            id = this.getId(id, isIndex);\n\n            return this.name + '.' + id;\n        },\n\n        /**\n         * Disables editing of specified fields.\n         *\n         * @param {Array} fields - An array of fields indexes to be disabled.\n         * @returns {Editor} Chainable.\n         */\n        disableFields: function (fields) {\n            var columns = this.columns().elems(),\n                data    = utils.copy(this.fields);\n\n            columns.forEach(function (column) {\n                var index = column.index,\n                    field = data[index] = data[index] || {};\n\n                field.disabled = _.contains(fields, index);\n            });\n\n            this.set('fields', data);\n\n            return this;\n        },\n\n        /**\n         * Converts index of a row into the record id.\n         *\n         * @param {(Number|String)} id - Records' identifier or its' index in the rows array.\n         * @param {Boolean} [isIndex=false] - Flag that indicates if first\n         *      parameter is an index or identifier.\n         * @returns {String} Records' id.\n         */\n        getId: function (id, isIndex) {\n            var rowsData = this.rowsData,\n                record;\n\n            if (isIndex === true) {\n                record  = rowsData[id];\n                id      = record ? record[this.indexField] : false;\n            }\n\n            return id;\n        },\n\n        /**\n         * Returns data of a specified row.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See 'getId' method.\n         * @returns {Object}\n         */\n        getRowData: function (id, isIndex) {\n            id = this.getId(id, isIndex);\n\n            return _.find(this.rowsData, function (row) {\n                return row[this.indexField] === id;\n            }, this);\n        },\n\n        /**\n         * Checks if specified record is active.\n         *\n         * @param {(Number|String)} id - See 'getId' method.\n         * @param {Boolean} [isIndex=false] - See'getId' method.\n         * @returns {Boolean}\n         */\n        isActive: function (id, isIndex) {\n            var record = this.getRecord(id, isIndex);\n\n            return _.contains(this.activeRecords(), record);\n        },\n\n        /**\n         * Checks if editor has active records.\n         *\n         * @returns {Boolean}\n         */\n        hasActive: function () {\n            return !!this.activeRecords().length || this.permanentlyActive;\n        },\n\n        /**\n         * Counts number of active records.\n         *\n         * @returns {Number}\n         */\n        countActive: function () {\n            return this.activeRecords().length;\n        },\n\n        /**\n         * Counts number of invalid fields across all active records.\n         *\n         * @returns {Number}\n         */\n        countErrors: function () {\n            var errorsCount = 0;\n\n            this.activeRecords.each(function (record) {\n                errorsCount += record.errorsCount;\n            });\n\n            this.errorsCount = errorsCount;\n\n            return errorsCount;\n        },\n\n        /**\n         * Translatable error message text.\n         *\n         * @returns {String}\n         */\n        countErrorsMessage: function () {\n            return $t('There are {placeholder} messages requires your attention.')\n                .replace('{placeholder}', this.countErrors());\n        },\n\n        /**\n         * Checks if editor has any errors.\n         *\n         * @returns {Boolean}\n         */\n        hasErrors: function () {\n            return !!this.countErrors();\n        },\n\n        /**\n         * Handles changes of the records 'active' property.\n         *\n         * @returns {Editor} Chainable.\n         */\n        updateState: function () {\n            var active      = this.elems.filter('active'),\n                activeCount = active.length,\n                columns     = this.columns().elems;\n\n            columns.each('disableAction', !!activeCount);\n\n            this.isMultiEditing = activeCount > 1;\n            this.isSingleEditing = activeCount === 1;\n\n            this.activeRecords(active);\n\n            return this;\n        },\n\n        /**\n         * Returns list of selections from a current page.\n         *\n         * @returns {Array}\n         */\n        getSelections: function () {\n            return this.selections().getPageSelections();\n        },\n\n        /**\n         * Starts editing of selected records. If record\n         * is not in the selections list, then it will get hidden.\n         *\n         * @returns {Editor} Chainable.\n         */\n        editSelected: function () {\n            var selections = this.getSelections();\n\n            this.elems.each(function (record) {\n                if (!_.contains(selections, record.recordId)) {\n                    record.active(false);\n                }\n            });\n\n            selections.forEach(function (id) {\n                this.edit(id);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Checks if there is any additional messages.\n         *\n         * @returns {Boolean}\n         */\n        hasMessages: function () {\n            return this.messages().length;\n        },\n\n        /**\n         * Adds new additional message or a set of messages.\n         *\n         * @param {(Object|Array)} message - Messages to be added.\n         * @returns {Editor} Chainable.\n         */\n        addMessage: function (message) {\n            var messages = this.messages();\n\n            Array.isArray(message) ?\n                messages.push.apply(messages, message) :\n                messages.push(message);\n\n            this.messages(messages);\n\n            return this;\n        },\n\n        /**\n         * Removes all additional messages.\n         *\n         * @returns {Editor} Chainable.\n         */\n        clearMessages: function () {\n            this.messages.removeAll();\n\n            return this;\n        },\n\n        /**\n         * Listener of the selections data changes.\n         */\n        onSelectionsChange: function () {\n            if (this.hasActive()) {\n                this.editSelected();\n            }\n        },\n\n        /**\n         * Handles successful save request.\n         */\n        onDataSaved: function () {\n            var msg = {\n                type: 'success',\n                message: this.successMsg\n            };\n\n            this.addMessage(msg)\n                .source('reload', {\n                    refresh: true\n                });\n        },\n\n        /**\n         * Handles failed save request.\n         *\n         * @param {(Array|Object)} errors - List of errors or a single error object.\n         */\n        onSaveError: function (errors) {\n            this.addMessage(errors)\n                .columns('hideLoader');\n        }\n    });\n});\n","Magento_Ui/js/grid/editing/record.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'uiCollection'\n], function (_, utils, layout, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            active: true,\n            hasChanges: false,\n            fields: [],\n            errorsCount: 0,\n            fieldTmpl: 'ui/grid/editing/field',\n            rowTmpl: 'ui/grid/editing/row',\n            templates: {\n                fields: {\n                    base: {\n                        parent: '${ $.$data.record.name }',\n                        name: '${ $.$data.column.index }',\n                        provider: '${ $.$data.record.name }',\n                        dataScope: 'data.${ $.$data.column.index }',\n                        imports: {\n                            disabled: '${ $.$data.record.parentName }:fields.${ $.$data.column.index }.disabled'\n                        },\n                        isEditor: true\n                    },\n                    text: {\n                        component: 'Magento_Ui/js/form/element/abstract',\n                        template: 'ui/form/element/input'\n                    },\n                    date: {\n                        component: 'Magento_Ui/js/form/element/date',\n                        template: 'ui/form/element/date',\n                        dateFormat: 'MMM d, y h:mm:ss a'\n                    },\n                    select: {\n                        component: 'Magento_Ui/js/form/element/select',\n                        template: 'ui/form/element/select',\n                        options: '${ JSON.stringify($.$data.column.options) }'\n                    }\n                }\n            },\n            ignoreTmpls: {\n                data: true\n            },\n            listens: {\n                elems: 'updateFields',\n                data: 'updateState'\n            },\n            imports: {\n                onColumnsUpdate: '${ $.columnsProvider }:elems'\n            },\n            modules: {\n                columns: '${ $.columnsProvider }',\n                editor: '${ $.editorProvider }'\n            }\n        },\n\n        /**\n         * Initializes record component.\n         *\n         * @returns {Record} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(this, 'countErrors');\n            utils.limit(this, 'updateState', 10);\n\n            return this._super();\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Record} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track('errorsCount hasChanges')\n                .observe('active fields');\n\n            return this;\n        },\n\n        /**\n         * Adds listeners on a field.\n         *\n         * @returns {Record} Chainable.\n         */\n        initElement: function (field) {\n            field.on('error', this.countErrors);\n\n            return this._super();\n        },\n\n        /**\n         * Creates new instance of a field.\n         *\n         * @param {Column} column - Column instance which contains field definition.\n         * @returns {Record} Chainable.\n         */\n        initField: function (column) {\n            var field = this.buildField(column);\n\n            layout([field]);\n\n            return this;\n        },\n\n        /**\n         * Builds fields' configuration described in a provided column.\n         *\n         * @param {Column} column - Column instance which contains field definition.\n         * @returns {Object} Complete fields' configuration.\n         */\n        buildField: function (column) {\n            var fields = this.templates.fields,\n                field  = column.editor;\n\n            if (_.isObject(field) && field.editorType) {\n                field = utils.extend({}, fields[field.editorType], field);\n            } else if (_.isString(field)) {\n                field = fields[field];\n            }\n\n            field = utils.extend({}, fields.base, field);\n\n            return utils.template(field, {\n                record: this,\n                column: column\n            }, true, true);\n        },\n\n        /**\n         * Creates fields for the specified columns.\n         *\n         * @param {Array} columns - An array of column instances.\n         * @returns {Record} Chainable.\n         */\n        createFields: function (columns) {\n            columns.forEach(function (column) {\n                if (column.editor && !this.hasChild(column.index)) {\n                    this.initField(column);\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Returns instance of a column found by provided index.\n         *\n         * @param {String} index - Index of a column (e.g. 'title').\n         * @returns {Column}\n         */\n        getColumn: function (index) {\n            return this.columns().getChild(index);\n        },\n\n        /**\n         * Returns records' current data object.\n         *\n         * @returns {Object}\n         */\n        getData: function () {\n            return this.filterData(this.data);\n        },\n\n        /**\n         * Returns saved records' data. Data will be processed\n         * with a 'filterData' and 'normalizeData' methods.\n         *\n         * @returns {Object} Saved records' data.\n         */\n        getSavedData: function () {\n            var editor      = this.editor(),\n                savedData   = editor.getRowData(this.index);\n\n            savedData = this.filterData(savedData);\n\n            return this.normalizeData(savedData);\n        },\n\n        /**\n         * Replaces current records' data with the provided one.\n         *\n         * @param {Object} data - New records data.\n         * @param {Boolean} [partial=false] - Flag that defines whether\n         *      to completely replace current data or to extend it.\n         * @returns {Record} Chainable.\n         */\n        setData: function (data, partial) {\n            var currentData = partial ? this.data : {};\n\n            data = this.normalizeData(data);\n            data = utils.extend({}, currentData, data);\n\n            this.set('data', data)\n                .updateState();\n\n            return this;\n        },\n\n        /**\n         * Filters provided object extracting from it values\n         * that can be matched with an existing fields.\n         *\n         * @param {Object} data - Object to be processed.\n         * @returns {Object}\n         */\n        filterData: function (data) {\n            var fields = _.pluck(this.elems(), 'index');\n\n            _.each(this.preserveFields, function (enabled, field) {\n                if (enabled && !_.contains(fields, field)) {\n                    fields.push(field);\n                }\n            });\n\n            return _.pick(data, fields);\n        },\n\n        /**\n         * Parses values of a provided object with\n         * a 'normalizeData' method of a corresponding field.\n         *\n         * @param {Object} data - Data to be processed.\n         * @returns {Object}\n         */\n        normalizeData: function (data) {\n            var index;\n\n            this.elems.each(function (elem) {\n                index = elem.index;\n\n                if (data.hasOwnProperty(index)) {\n                    data[index] = elem.normalizeData(data[index]);\n                }\n            });\n\n            return data;\n        },\n\n        /**\n         * Clears values of all fields.\n         *\n         * @returns {Record} Chainable.\n         */\n        clear: function () {\n            this.elems.each('clear');\n\n            return this;\n        },\n\n        /**\n         * Validates all of the available fields.\n         *\n         * @returns {Array} An array with validation results.\n         */\n        validate: function () {\n            return this.elems.map('validate');\n        },\n\n        /**\n         * Checks if all fields are valid.\n         *\n         * @returns {Boolean}\n         */\n        isValid: function () {\n            return _.every(this.validate(), 'valid');\n        },\n\n        /**\n         * Counts total errors amount across all fields.\n         *\n         * @returns {Number}\n         */\n        countErrors: function () {\n            var errorsCount = this.elems.filter('error').length;\n\n            this.errorsCount = errorsCount;\n\n            return errorsCount;\n        },\n\n        /**\n         * Returns difference between current data and its'\n         * initial state, retrieved from the records collection.\n         *\n         * @returns {Object} Object with changes descriptions.\n         */\n        checkChanges: function () {\n            var savedData   = this.getSavedData(),\n                data        = this.normalizeData(this.getData());\n\n            return utils.compare(savedData, data);\n        },\n\n        /**\n         * Updates 'fields' array filling it with available editors\n         * or with column instances if associated field is not present.\n         *\n         * @returns {Record} Chainable.\n         */\n        updateFields: function () {\n            var fields;\n\n            fields = this.columns().elems.map(function (column) {\n                return this.getChild(column.index) || column;\n            }, this);\n\n            this.fields(fields);\n\n            return this;\n        },\n\n        /**\n         * Updates state of a 'hasChanges' property.\n         *\n         * @returns {Record} Chainable.\n         */\n        updateState: function () {\n            var diff = this.checkChanges(),\n                changed = {};\n\n            this.hasChanges = !diff.equal;\n            changed[this.index] = this.data;\n            this.editor().set('changed', [changed]);\n\n            return this;\n        },\n\n        /**\n         * Checks if provided column is an actions column.\n         *\n         * @param {Column} column - Column to be checked.\n         * @returns {Boolean}\n         */\n        isActionsColumn: function (column) {\n            return column.dataType === 'actions';\n        },\n\n        /**\n         * Listener of columns provider child array changes.\n         *\n         * @param {Array} columns - Modified child elements array.\n         */\n        onColumnsUpdate: function (columns) {\n            this.createFields(columns)\n                .updateFields();\n        }\n    });\n});\n","Magento_Ui/js/grid/filters/chips.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiCollection'\n], function (_, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/filters/chips',\n            componentType: 'filtersChips'\n        },\n\n        /**\n         * Defines if some of components' children has available previews.\n         *\n         * @returns {Boolean}\n         */\n        hasPreviews: function () {\n            return this.elems().some(function (elem) {\n                return !!elem.previews.length;\n            });\n        },\n\n        /**\n         * Calls clear method on all of its' children.\n         *\n         * @returns {Chips} Chainable.\n         */\n        clear: function () {\n            _.invoke(this.elems(), 'clear');\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/filters/filters.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'uiCollection',\n    'mage/translate',\n    'jquery'\n], function (_, utils, layout, Collection, $t, $) {\n    'use strict';\n\n    /**\n     * Extracts and formats preview of an element.\n     *\n     * @param {Object} elem - Element whose preview should be extracted.\n     * @returns {Object} Formatted data.\n     */\n    function extractPreview(elem) {\n        return {\n            label: elem.label,\n            preview: elem.getPreview(),\n            elem: elem\n        };\n    }\n\n    /**\n     * Removes empty properties from the provided object.\n     *\n     * @param {Object} data - Object to be processed.\n     * @returns {Object}\n     */\n    function removeEmpty(data) {\n        var result = utils.mapRecursive(data, utils.removeEmptyValues.bind(utils));\n\n        return utils.mapRecursive(result, function (value) {\n            return _.isString(value) ? value.trim() : value;\n        });\n    }\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/grid/filters/filters',\n            stickyTmpl: 'ui/grid/sticky/filters',\n            _processed: [],\n            columnsProvider: 'ns = ${ $.ns }, componentType = columns',\n            bookmarksProvider: 'ns = ${ $.ns }, componentType = bookmark',\n            applied: {\n                placeholder: true\n            },\n            filters: {\n                placeholder: true\n            },\n            templates: {\n                filters: {\n                    base: {\n                        parent: '${ $.$data.filters.name }',\n                        name: '${ $.$data.column.index }',\n                        provider: '${ $.$data.filters.name }',\n                        dataScope: '${ $.$data.column.index }',\n                        label: '${ $.$data.column.label }',\n                        imports: {\n                            visible: '${ $.$data.column.name }:visible'\n                        }\n                    },\n                    text: {\n                        component: 'Magento_Ui/js/form/element/abstract',\n                        template: 'ui/grid/filters/field'\n                    },\n                    select: {\n                        component: 'Magento_Ui/js/form/element/select',\n                        template: 'ui/grid/filters/field',\n                        options: '${ JSON.stringify($.$data.column.options) }',\n                        caption: ' '\n                    },\n                    dateRange: {\n                        component: 'Magento_Ui/js/grid/filters/range',\n                        rangeType: 'date'\n                    },\n                    datetimeRange: {\n                        component: 'Magento_Ui/js/grid/filters/range',\n                        rangeType: 'datetime'\n                    },\n                    textRange: {\n                        component: 'Magento_Ui/js/grid/filters/range',\n                        rangeType: 'text'\n                    }\n                }\n            },\n            chipsConfig: {\n                name: '${ $.name }_chips',\n                provider: '${ $.chipsConfig.name }',\n                component: 'Magento_Ui/js/grid/filters/chips'\n            },\n            listens: {\n                active: 'updatePreviews',\n                applied: 'cancel updateActive'\n            },\n            statefull: {\n                applied: true\n            },\n            exports: {\n                applied: '${ $.provider }:params.filters'\n            },\n            imports: {\n                onColumnsUpdate: '${ $.columnsProvider }:elems',\n                onBackendError: '${ $.provider }:lastError',\n                bookmarksActiveIndex: '${ $.bookmarksProvider }:activeIndex'\n            },\n            modules: {\n                columns: '${ $.columnsProvider }',\n                chips: '${ $.chipsConfig.provider }'\n            }\n        },\n\n        /**\n         * Initializes filters component.\n         *\n         * @returns {Filters} Chainable.\n         */\n        initialize: function (config) {\n            if (typeof config.options !== 'undefined' && config.options.dateFormat) {\n                this.constructor.defaults.templates.filters.dateRange.dateFormat = config.options.dateFormat;\n            }\n            _.bindAll(this, 'updateActive');\n\n            this._super()\n                .initChips()\n                .cancel();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Filters} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    active: [],\n                    previews: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Initializes chips component.\n         *\n         * @returns {Filters} Chainable.\n         */\n        initChips: function () {\n            layout([this.chipsConfig]);\n\n            this.chips('insertChild', this.name);\n\n            return this;\n        },\n\n        /**\n         * Called when another element was added to filters collection.\n         *\n         * @returns {Filters} Chainable.\n         */\n        initElement: function (elem) {\n            this._super();\n\n            elem.on('elems', this.updateActive);\n\n            this.updateActive();\n\n            return this;\n        },\n\n        /**\n         * Clears filters data.\n         *\n         * @param {Object} [filter] - If provided, then only specified\n         *      filter will be cleared. Otherwise, clears all data.\n         * @returns {Filters} Chainable.\n         */\n        clear: function (filter) {\n            filter ?\n                filter.clear() :\n                _.invoke(this.active, 'clear');\n\n            this.apply();\n\n            return this;\n        },\n\n        /**\n         * Sets filters data to the applied state.\n         *\n         * @returns {Filters} Chainable.\n         */\n        apply: function () {\n            $('body').notification('clear');\n            this.set('applied', removeEmpty(this.filters));\n\n            return this;\n        },\n\n        /**\n         * Resets filters to the last applied state.\n         *\n         * @returns {Filters} Chainable.\n         */\n        cancel: function () {\n            this.set('filters', utils.copy(this.applied));\n\n            return this;\n        },\n\n        /**\n         * Sets provided data to filter components (without applying it).\n         *\n         * @param {Object} data - Filters data.\n         * @param {Boolean} [partial=false] - Flag that defines whether\n         *      to completely replace current filters data or to extend it.\n         * @returns {Filters} Chainable.\n         */\n        setData: function (data, partial) {\n            var filters = partial ? this.filters : {};\n\n            data = utils.extend({}, filters, data);\n\n            this.set('filters', data);\n\n            return this;\n        },\n\n        /**\n         * Creates instance of a filter associated with the provided column.\n         *\n         * @param {Column} column - Column component for which to create a filter.\n         * @returns {Filters} Chainable.\n         */\n        addFilter: function (column) {\n            var index       = column.index,\n                processed   = this._processed,\n                filter;\n\n            if (!column.filter || _.contains(processed, index)) {\n                return this;\n            }\n\n            filter = this.buildFilter(column);\n\n            processed.push(index);\n\n            layout([filter]);\n\n            return this;\n        },\n\n        /**\n         * Creates filter component configuration associated with the provided column.\n         *\n         * @param {Column} column - Column component with a basic filter declaration.\n         * @returns {Object} Filters' configuration.\n         */\n        buildFilter: function (column) {\n            var filters = this.templates.filters,\n                filter  = column.filter,\n                type    = filters[filter.filterType];\n\n            if (_.isObject(filter) && type) {\n                filter = utils.extend({}, type, filter);\n            } else if (_.isString(filter)) {\n                filter = filters[filter];\n            }\n\n            filter = utils.extend({}, filters.base, filter);\n            //Accepting labels as is.\n            filter.__disableTmpl = {\n                label: 1,\n                options: 1\n            };\n\n            filter = utils.template(filter, {\n                filters: this,\n                column: column\n            }, true, true);\n\n            filter.__disableTmpl = {\n                label: true\n            };\n\n            return filter;\n        },\n\n        /**\n         * Returns an array of range filters.\n         *\n         * @returns {Array}\n         */\n        getRanges: function () {\n            return this.elems.filter(function (filter) {\n                return filter.isRange;\n            });\n        },\n\n        /**\n         * Returns an array of non-range filters.\n         *\n         * @returns {Array}\n         */\n        getPlain: function () {\n            return this.elems.filter(function (filter) {\n                return !filter.isRange;\n            });\n        },\n\n        /**\n         * Tells wether specified filter should be visible.\n         *\n         * @param {Object} filter\n         * @returns {Boolean}\n         */\n        isFilterVisible: function (filter) {\n            return filter.visible() || this.isFilterActive(filter);\n        },\n\n        /**\n         * Checks if specified filter is active.\n         *\n         * @param {Object} filter\n         * @returns {Boolean}\n         */\n        isFilterActive: function (filter) {\n            return _.contains(this.active, filter);\n        },\n\n        /**\n         * Checks if collection has visible filters.\n         *\n         * @returns {Boolean}\n         */\n        hasVisible: function () {\n            return this.elems.some(this.isFilterVisible, this);\n        },\n\n        /**\n         * Finds filters with a not empty data\n         * and sets them to the 'active' filters array.\n         *\n         * @returns {Filters} Chainable.\n         */\n        updateActive: function () {\n            var applied = _.keys(this.applied);\n\n            this.active = this.elems.filter(function (elem) {\n                return _.contains(applied, elem.index);\n            });\n\n            return this;\n        },\n\n        /**\n         * Returns number of applied filters.\n         *\n         * @returns {Number}\n         */\n        countActive: function () {\n            return this.active.length;\n        },\n\n        /**\n         * Extract previews of a specified filters.\n         *\n         * @param {Array} filters - Filters to be processed.\n         * @returns {Filters} Chainable.\n         */\n        updatePreviews: function (filters) {\n            var previews = filters.map(extractPreview);\n\n            this.previews = _.compact(previews);\n\n            return this;\n        },\n\n        /**\n         * Listener of the columns provider children array changes.\n         *\n         * @param {Array} columns - Current columns list.\n         */\n        onColumnsUpdate: function (columns) {\n            columns.forEach(this.addFilter, this);\n        },\n\n        /**\n         * Provider ajax error listener.\n         *\n         * @param {bool} isError - Selected index of the filter.\n         */\n        onBackendError: function (isError) {\n            var defaultMessage = 'Something went wrong with processing the default view and we have restored the ' +\n                    'filter to its original state.',\n                customMessage  = 'Something went wrong with processing current custom view and filters have been ' +\n                    'reset to its original state. Please edit filters then click apply.';\n\n            if (isError) {\n                this.clear();\n\n                $('body').notification('clear')\n                    .notification('add', {\n                        error: true,\n                        message: $.mage.__(this.bookmarksActiveIndex !== 'default' ? customMessage : defaultMessage),\n\n                        /**\n                         * @param {String} message\n                         */\n                        insertMethod: function (message) {\n                            var $wrapper = $('<div></div>').html(message);\n\n                            $('.page-main-actions').after($wrapper);\n                        }\n                    });\n            }\n        }\n    });\n});\n","Magento_Ui/js/grid/filters/range.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiLayout',\n    'mageUtils',\n    'Magento_Ui/js/form/components/group',\n    'mage/translate'\n], function (_, layout, utils, Group, $t) {\n    'use strict';\n\n    return Group.extend({\n        defaults: {\n            template: 'ui/grid/filters/elements/group',\n            isRange: true,\n            templates: {\n                base: {\n                    parent: '${ $.$data.group.name }',\n                    provider: '${ $.$data.group.provider }',\n                    template: 'ui/grid/filters/field'\n                },\n                date: {\n                    component: 'Magento_Ui/js/form/element/date',\n                    dateFormat: 'MM/dd/YYYY',\n                    shiftedValue: 'filter'\n                },\n                datetime: {\n                    component: 'Magento_Ui/js/form/element/date',\n                    dateFormat: 'MM/dd/YYYY',\n                    shiftedValue: 'filter',\n                    options: {\n                        showsTime: true\n                    }\n                },\n                text: {\n                    component: 'Magento_Ui/js/form/element/abstract'\n                },\n                ranges: {\n                    from: {\n                        label: $t('from'),\n                        dataScope: 'from'\n                    },\n                    to: {\n                        label: $t('to'),\n                        dataScope: 'to'\n                    }\n                }\n            }\n        },\n\n        /**\n         * Initializes range component.\n         *\n         * @returns {Range} Chainable.\n         */\n        initialize: function (config) {\n            if (config.dateFormat) {\n                this.constructor.defaults.templates.date.pickerDefaultDateFormat = config.dateFormat;\n            }\n            this._super()\n                .initChildren();\n\n            return this;\n        },\n\n        /**\n         * Creates instances of child components.\n         *\n         * @returns {Range} Chainable.\n         */\n        initChildren: function () {\n            var children = this.buildChildren();\n\n            layout(children);\n\n            return this;\n        },\n\n        /**\n         * Creates configuration for the child components.\n         *\n         * @returns {Object}\n         */\n        buildChildren: function () {\n            var templates   = this.templates,\n                typeTmpl    = templates[this.rangeType],\n                tmpl        = utils.extend({}, templates.base, typeTmpl),\n                children    = {};\n\n            _.each(templates.ranges, function (range, key) {\n                children[key] = utils.extend({}, tmpl, range);\n            });\n\n            return utils.template(children, {\n                group: this\n            }, true, true);\n        },\n\n        /**\n         * Clears childrens data.\n         *\n         * @returns {Range} Chainable.\n         */\n        clear: function () {\n            this.elems.each('clear');\n\n            return this;\n        },\n\n        /**\n         * Checks if some children has data.\n         *\n         * @returns {Boolean}\n         */\n        hasData: function () {\n            return this.elems.some('hasData');\n        }\n    });\n});\n","Magento_Ui/js/grid/filters/elements/ui-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/ui-select',\n    'jquery',\n    'underscore'\n], function (Select, $, _) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            bookmarkProvider: 'ns = ${ $.ns }, index = bookmarks',\n            filterChipsProvider: 'componentType = filters, ns = ${ $.ns }',\n            validationUrl: false,\n            loadedOption: [],\n            validationLoading: true,\n            imports: {\n                applied: '${ $.filterChipsProvider }:applied',\n                activeIndex: '${ $.bookmarkProvider }:activeIndex'\n            },\n            modules: {\n                filterChips: '${ $.filterChipsProvider }'\n            },\n            listens: {\n                activeIndex: 'validateInitialValue',\n                applied: 'validateInitialValue'\n            }\n\n        },\n\n        /**\n         * Initializes UiSelect component.\n         *\n         * @returns {UiSelect} Chainable.\n         */\n        initialize: function () {\n            this._super();\n\n            this.validateInitialValue();\n\n            return this;\n        },\n\n        /**\n         * Validate initial value actually exists\n         */\n        validateInitialValue: function () {\n            if (_.isEmpty(this.value())) {\n                this.validationLoading(false);\n\n                return;\n            }\n\n            $.ajax({\n                url: this.validationUrl,\n                type: 'GET',\n                dataType: 'json',\n                context: this,\n                data: {\n                    ids: this.value()\n                },\n\n                /** @param {Object} response */\n                success: function (response) {\n                    if (!_.isEmpty(response)) {\n                        this.options([]);\n                        this.success({\n                            options: response\n                        });\n                    }\n                    this.filterChips().updateActive();\n                },\n\n                /** set empty array if error occurs */\n                error: function () {\n                    this.options([]);\n                },\n\n                /** stop loader */\n                complete: function () {\n                    this.validationLoading(false);\n                    this.setCaption();\n                }\n            });\n        }\n    });\n});\n","Magento_Ui/js/grid/paging/paging.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'uiElement'\n], function (ko, _, utils, layout, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/paging/paging',\n            totalTmpl: 'ui/grid/paging-total',\n            totalRecords: 0,\n            pages: 1,\n            current: 1,\n            selectProvider: 'ns = ${ $.ns }, index = ids',\n\n            sizesConfig: {\n                component: 'Magento_Ui/js/grid/paging/sizes',\n                name: '${ $.name }_sizes',\n                storageConfig: {\n                    provider: '${ $.storageConfig.provider }',\n                    namespace: '${ $.storageConfig.namespace }'\n                }\n            },\n\n            imports: {\n                totalSelected: '${ $.selectProvider }:totalSelected',\n                totalRecords: '${ $.provider }:data.totalRecords',\n                filters: '${ $.provider }:params.filters',\n                keywordUpdated: '${ $.provider }:params.keywordUpdated'\n            },\n\n            exports: {\n                pageSize: '${ $.provider }:params.paging.pageSize',\n                current: '${ $.provider }:params.paging.current'\n            },\n\n            links: {\n                options: '${ $.sizesConfig.name }:options',\n                pageSize: '${ $.sizesConfig.name }:value'\n            },\n\n            statefull: {\n                pageSize: true,\n                current: true\n            },\n\n            listens: {\n                'pages': 'onPagesChange',\n                'pageSize': 'onPageSizeChange',\n                'totalRecords': 'updateCounter',\n                '${ $.provider }:params.filters': 'goFirst',\n                '${ $.provider }:params.search': 'onSearchUpdate'\n            },\n\n            modules: {\n                sizes: '${ $.sizesConfig.name }'\n            }\n        },\n\n        /**\n         * Initializes paging component.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initSizes()\n                .updateCounter();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'totalSelected',\n                    'totalRecords',\n                    'pageSize',\n                    'pages',\n                    'current'\n                ]);\n\n            this._current = ko.pureComputed({\n                read: ko.getObservable(this, 'current'),\n\n                /**\n                 * Validates page change according to user's input.\n                 * Sets current observable to result of validation.\n                 * Calls reload method then.\n                 */\n                write: function (value) {\n                    this.setPage(value)\n                        ._current.notifySubscribers(this.current);\n                },\n\n                owner: this\n            });\n\n            return this;\n        },\n\n        /**\n         * Initializes sizes component.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initSizes: function () {\n            layout([this.sizesConfig]);\n\n            return this;\n        },\n\n        /**\n         * Gets first item index on current page.\n         *\n         * @returns {Number}\n         */\n        getFirstItemIndex: function () {\n            return this.pageSize * (this.current - 1) + 1;\n        },\n\n        /**\n         * Gets last item index on current page.\n         *\n         * @returns {Number}\n         */\n        getLastItemIndex: function () {\n            var lastItem = this.getFirstItemIndex() + this.pageSize - 1;\n\n            return this.totalRecords < lastItem ? this.totalRecords : lastItem;\n        },\n\n        /**\n         * Sets cursor to the provied value.\n         *\n         * @param {(Number|String)} value - New value of the cursor.\n         * @returns {Paging} Chainable.\n         */\n        setPage: function (value) {\n            this.current = this.normalize(value);\n\n            return this;\n        },\n\n        /**\n         * Increments current page value.\n         *\n         * @returns {Paging} Chainable.\n         */\n        next: function () {\n            this.setPage(this.current + 1);\n\n            return this;\n        },\n\n        /**\n         * Decrements current page value.\n         *\n         * @returns {Paging} Chainable.\n         */\n        prev: function () {\n            this.setPage(this.current - 1);\n\n            return this;\n        },\n\n        /**\n         * Goes to the first page.\n         *\n         * @returns {Paging} Chainable.\n         */\n        goFirst: function () {\n            if (!_.isUndefined(this.filters)) {\n                this.current = 1;\n            }\n\n            return this;\n        },\n\n        /**\n         * Goes to the last page.\n         *\n         * @returns {Paging} Chainable.\n         */\n        goLast: function () {\n            this.current = this.pages;\n\n            return this;\n        },\n\n        /**\n         * Checks if current page is the first one.\n         *\n         * @returns {Boolean}\n         */\n        isFirst: function () {\n            return this.current === 1;\n        },\n\n        /**\n         * Checks if current page is the last one.\n         *\n         * @returns {Boolean}\n         */\n        isLast: function () {\n            return this.current === this.pages;\n        },\n\n        /**\n         * Updates number of pages.\n         */\n        updateCounter: function () {\n            this.pages = Math.ceil(this.totalRecords / this.pageSize) || 1;\n\n            return this;\n        },\n\n        /**\n         * Calculates new page cursor based on the\n         * previous and current page size values.\n         */\n        updateCursor: function () {\n            var cursor = this.current - 1,\n                size = this.pageSize,\n                oldSize = _.isUndefined(this.previousSize) ? this.pageSize : this.previousSize,\n                delta = cursor * (oldSize - size) / size;\n\n            delta = size > oldSize ?\n                Math.ceil(delta) :\n                Math.floor(delta);\n\n            cursor += delta + 1;\n\n            this.previousSize = size;\n\n            this.setPage(cursor);\n\n            return this;\n        },\n\n        /**\n         * Converts provided value to a number and puts\n         * it in range between 1 and total amount of pages.\n         *\n         * @param {(Number|String)} value - Value to be normalized.\n         * @returns {Number}\n         */\n        normalize: function (value) {\n            value = +value;\n\n            if (isNaN(value)) {\n                return 1;\n            }\n\n            return utils.inRange(Math.round(value), 1, this.pages);\n        },\n\n        /**\n         * Handles changes of the page size.\n         */\n        onPageSizeChange: function () {\n            this.updateCounter()\n                .updateCursor();\n        },\n\n        /**\n         * Handles changes of the pages amount.\n         */\n        onPagesChange: function () {\n            this.updateCursor();\n        },\n\n        /**\n         * Resent the pagination to Page 1 on search keyword update\n         */\n        onSearchUpdate: function () {\n            if (!_.isUndefined(this.keywordUpdated) && this.keywordUpdated) {\n                this.goFirst();\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/paging/sizes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiElement'\n], function (ko, _, utils, Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/paging/sizes',\n            minSize: 1,\n            maxSize: 999,\n            statefull: {\n                options: true,\n                value: true\n            },\n            listens: {\n                value: 'onValueChange',\n                options: 'onSizesChange'\n            }\n        },\n\n        /**\n         * Initializes sizes component.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .updateArray();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'value',\n                    'editing',\n                    'customVisible',\n                    'customValue'\n                ])\n                .track({\n                    optionsArray: []\n                });\n\n            this._value = ko.pureComputed({\n                read: ko.getObservable(this, 'value'),\n\n                /**\n                 * Validates input field prior to updating 'value' property.\n                 */\n                write: function (value) {\n                    value = this.normalize(value);\n\n                    this.value = value;\n                    this._value.notifySubscribers(value);\n                },\n\n                owner: this\n            });\n\n            return this;\n        },\n\n        /**\n         * Starts editing of the specified size.\n         *\n         * @param {Number} value - Value of the size.\n         * @returns {Sizes} Chainable.\n         */\n        edit: function (value) {\n            this.editing = value;\n\n            return this;\n        },\n\n        /**\n         * Discards changes made to the currently editable size.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        discardEditing: function () {\n            var value = this.editing;\n\n            if (value) {\n                this.updateSize(value, value);\n            }\n\n            return this;\n        },\n\n        /**\n         * Invokes 'discardEditing' and 'discardCustom' actions.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        discardAll: function () {\n            this.discardEditing()\n                .discardCustom();\n\n            return this;\n        },\n\n        /**\n         * Returns value of the first size.\n         *\n         * @returns {Number}\n         */\n        getFirst: function () {\n            return this.optionsArray[0].value;\n        },\n\n        /**\n         * Returns size which matches specified value.\n         *\n         * @param {Number} value - Value of the item.\n         * @returns {Object|Undefined}\n         */\n        getSize: function (value) {\n            return this.options[value];\n        },\n\n        /**\n         * Sets current size to the specified value.\n         *\n         * @param {Number} value - Value of the size.\n         * @returns {Sizes} Chainable.\n         */\n        setSize: function (value) {\n            this.value = value;\n\n            return this;\n        },\n\n        /**\n         * Adds a new value to sizes list.\n         *\n         * @param {Number} value - Value to be added.\n         * @returns {Sizes} Chainable.\n         */\n        addSize: function (value) {\n            var size;\n\n            if (!this.hasSize(value)) {\n                size = this.createSize(value);\n\n                this.set('options.' + value, size);\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes provided value from the sizes list.\n         *\n         * @param {Number} value - Value to be removed.\n         * @returns {Sizes} Chainable.\n         */\n        removeSize: function (value) {\n            if (!this.hasSize(value)) {\n                return this;\n            }\n\n            this.remove('options.' + value);\n\n            if (this.isSelected(value)) {\n                this.setSize(this.getFirst());\n            }\n\n            return this;\n        },\n\n        /**\n         * Updates existing value to the provided one. If new value\n         * is not specified, then sizes' '_value' property will be taken.\n         *\n         * @param {Number} value - Existing value that should be updated.\n         * @param {(Number|String)} [newValue=size._value] - New size value.\n         * @returns {Sizes} Chainable.\n         */\n        updateSize: function (value, newValue) {\n            var size = this.getSize(value);\n\n            if (!size) {\n                return this;\n            }\n\n            newValue = newValue || size._value;\n\n            if (isNaN(+newValue)) {\n                this.discardEditing();\n\n                return this;\n            }\n\n            newValue = this.normalize(newValue);\n\n            this.remove('options.' + value)\n                .addSize(newValue);\n\n            if (this.isSelected(value)) {\n                this.setSize(newValue);\n            }\n\n            return this;\n        },\n\n        /**\n         * Creates new editable size instance with the provided value.\n         *\n         * @param {Number} value - Value of the size.\n         * @returns {Object}\n         */\n        createSize: function (value) {\n            return {\n                value: value,\n                label: value,\n                _value: value,\n                editable: true\n            };\n        },\n\n        /**\n         * Checks if provided value exists in the sizes list.\n         *\n         * @param {Number} value - Value to be checked.\n         * @returns {Boolean}\n         */\n        hasSize: function (value) {\n            return !!this.getSize(value);\n        },\n\n        /**\n         * Hides and clears custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        discardCustom: function () {\n            this.hideCustom()\n                .clearCustom();\n\n            return this;\n        },\n\n        /**\n         * Shows custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        showCustom: function () {\n            this.customVisible = true;\n\n            return this;\n        },\n\n        /**\n         * Hides custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        hideCustom: function () {\n            this.customVisible = false;\n\n            return this;\n        },\n\n        /**\n         * Empties value of the custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        clearCustom: function () {\n            this.customValue = '';\n\n            return this;\n        },\n\n        /**\n         * Adds a new size specified in the custom field.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        applyCustom: function () {\n            var value = this.customValue;\n\n            value = this.normalize(value);\n\n            this.addSize(value)\n                .setSize(value)\n                .discardCustom();\n\n            return this;\n        },\n\n        /**\n         * Checks if custom field is visible.\n         *\n         * @returns {Boolean}\n         */\n        isCustomVisible: function () {\n            return this.customVisible;\n        },\n\n        /**\n         * Converts provided value to a number and puts\n         * it in range between 'minSize' and 'maxSize' properties.\n         *\n         * @param {(Number|String)} value - Value to be normalized.\n         * @returns {Number}\n         */\n        normalize: function (value) {\n            value = +value;\n\n            if (isNaN(value)) {\n                return this.getFirst();\n            }\n\n            return utils.inRange(Math.round(value), this.minSize, this.maxSize);\n        },\n\n        /**\n         * Updates the array of options.\n         *\n         * @returns {Sizes} Chainable.\n         */\n        updateArray: function () {\n            var array = _.values(this.options);\n\n            this.optionsArray = _.sortBy(array, 'value');\n\n            return this;\n        },\n\n        /**\n         * Checks if provided value is in editing state.\n         *\n         * @param {Number} value - Value to be checked.\n         * @returns {Boolean}\n         */\n        isEditing: function (value) {\n            return this.editing === value;\n        },\n\n        /**\n         * Checks if provided value is selected.\n         *\n         * @param {Number} value - Value to be checked.\n         * @returns {Boolean}\n         */\n        isSelected: function (value) {\n            return this.value === value;\n        },\n\n        /**\n         * Listener of the 'value' property changes.\n         */\n        onValueChange: function () {\n            this.discardAll()\n                .trigger('close');\n        },\n\n        /**\n         * Listener of the 'options' object changes.\n         */\n        onSizesChange: function () {\n            this.editing = false;\n\n            this.updateArray();\n        }\n    });\n});\n","Magento_Ui/js/grid/search/search.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'uiLayout',\n    'mage/translate',\n    'mageUtils',\n    'uiElement',\n    'jquery'\n], function (_, layout, $t, utils, Element, $) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/grid/search/search',\n            placeholder: $t('Search by keyword'),\n            label: $t('Keyword'),\n            value: '',\n            keywordUpdated: false,\n            previews: [],\n            chipsProvider: 'componentType = filtersChips, ns = ${ $.ns }',\n            statefull: {\n                value: true\n            },\n            tracks: {\n                value: true,\n                previews: true,\n                inputValue: true,\n                focused: true,\n                keywordUpdated: true\n            },\n            imports: {\n                inputValue: 'value',\n                updatePreview: 'value',\n                focused: false\n            },\n            exports: {\n                value: '${ $.provider }:params.search',\n                keywordUpdated: '${ $.provider }:params.keywordUpdated'\n            },\n            modules: {\n                chips: '${ $.chipsProvider }'\n            }\n        },\n\n        /**\n         * Initializes search component.\n         *\n         * @returns {Search} Chainable.\n         */\n        initialize: function () {\n            var urlParams = window.location.href.slice(window.location.href.search('[\\&\\?](search=)')).split('&'),\n                searchTerm = [];\n\n            this._super()\n                .initChips();\n\n            if (urlParams[0]) {\n                searchTerm = urlParams[0].split('=');\n\n                if (searchTerm[1]) {\n                    this.apply(decodeURIComponent(searchTerm[1]));\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes chips component.\n         *\n         * @returns {Search} Chainbale.\n         */\n        initChips: function () {\n            this.chips('insertChild', this, 0);\n\n            return this;\n        },\n\n        /**\n         * Clears search.\n         *\n         * @returns {Search} Chainable.\n         */\n        clear: function () {\n            this.value = '';\n\n            return this;\n        },\n\n        /**\n         * Click To ScrollTop.\n         */\n        scrollTo: function ($data) {\n            $('html, body').animate({\n                scrollTop: 0\n            }, 'slow', function () {\n                $data.focused = false;\n                $data.focused = true;\n            });\n        },\n\n        /**\n         * Resets input value to the last applied state.\n         *\n         * @returns {Search} Chainable.\n         */\n        cancel: function () {\n            this.inputValue = this.value;\n\n            return this;\n        },\n\n        /**\n         * Applies search query.\n         *\n         * @param {String} [value=inputValue] - If not specified, then\n         *      value of the input field will be used.\n         * @returns {Search} Chainable.\n         */\n        apply: function (value) {\n            value = value || this.inputValue;\n\n            this.keywordUpdated = this.value !== value;\n            this.value = this.inputValue = value.trim();\n\n            return this;\n        },\n\n        /**\n         * Updates preview data.\n         *\n         * @returns {Search} Chainable.\n         */\n        updatePreview: function () {\n            var preview = [];\n\n            if (this.value) {\n                preview.push({\n                    elem: this,\n                    label: this.label,\n                    preview: this.value\n                });\n            }\n\n            this.previews = preview;\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/grid/sticky/sticky.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/lib/view/utils/async',\n    'underscore',\n    'uiComponent',\n    'Magento_Ui/js/lib/view/utils/raf'\n], function ($, _, Component, raf) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            listingSelector: '${ $.listingProvider }::not([data-role = \"sticky-el-root\"])',\n            toolbarSelector: '${ $.toolbarProvider }::not([data-role = \"sticky-el-root\"])',\n            bulkRowSelector: '[data-role = \"data-grid-bulk-row\"]',\n            bulkRowHeaderSelector: '.data-grid-info-panel:visible',\n            tableSelector: 'table',\n            columnSelector: 'thead tr th',\n            rowSelector: 'tbody tr',\n            toolbarCollapsiblesSelector: '[data-role=\"toolbar-menu-item\"]',\n            toolbarCollapsiblesActiveClass: '_active',\n            template: 'ui/grid/sticky/sticky',\n            stickyContainerSelector: '.sticky-header',\n            stickyElementSelector: '[data-role = \"sticky-el-root\"]',\n            leftDataGridCapSelector: '.data-grid-cap-left',\n            rightDataGridCapSelector: '.data-grid-cap-right',\n            visible: false,\n            enableToolbar: true,\n            enableHeader: true,\n            modules: {\n                toolbar: '${ $.toolbarProvider }',\n                listing: '${ $.listingProvider }'\n            },\n            otherStickyElsSize: 77,\n            containerNode: null,\n            listingNode: null,\n            toolbarNode: null,\n            stickyListingNode: null,\n            stickyToolbarNode: null,\n            storedOriginalToolbarElements: [],\n            cache: {},\n            flags: {},\n            dirtyFlag: 'dirty'\n        },\n\n        /**\n         * Initializes Sticky component.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super();\n            _.bindAll(this,\n                'adjustStickyElems',\n                'initListingNode',\n                'initToolbarNode',\n                'initContainerNode',\n                'initColumns',\n                'initStickyListingNode',\n                'initStickyToolbarNode',\n                'initLeftDataGridCap',\n                'initRightDataGridCap'\n            );\n\n            $.async(this.listingSelector,\n                this.initListingNode);\n            $.async(this.toolbarSelector,\n                this.initToolbarNode);\n\n            $.async(this.stickyContainerSelector,\n                this,\n                this.initContainerNode);\n\n            return this;\n        },\n\n        /**\n         * Init observables\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track('visible');\n\n            return this;\n        },\n\n        /**\n         * Init original listing node\n         *\n         * @param {HTMLElement} node\n         */\n        initListingNode: function (node) {\n            if ($(node).is(this.stickyElementSelector)) {\n                return;\n            }\n            this.listingNode = $(node);\n            $.async(this.columnSelector, node, this.initColumns);\n        },\n\n        /**\n         * Init original toolbar node\n         *\n         * @param {HTMLElement} node\n         */\n        initToolbarNode: function (node) {\n            if ($(node).is(this.stickyElementSelector)) {\n                return;\n            }\n            this.toolbarNode = $(node);\n        },\n\n        /**\n         * Init sticky listing node\n         *\n         * @param {HTMLElement} node\n         */\n        initStickyListingNode: function (node) {\n            this.stickyListingNode = $(node);\n            this.checkPos();\n            this.initListeners();\n        },\n\n        /**\n         * Init sticky toolbar node\n         *\n         * @param {HTMLElement} node\n         */\n        initStickyToolbarNode: function (node) {\n            this.stickyToolbarNode = $(node);\n        },\n\n        /**\n         * Init sticky header container node\n         *\n         * @param {HTMLElement} node\n         */\n        initContainerNode: function (node) {\n            this.containerNode = $(node);\n\n            $.async(this.leftDataGridCapSelector,\n                node,\n                this.initLeftDataGridCap);\n            $.async(this.rightDataGridCapSelector,\n                node,\n                this.initRightDataGridCap);\n\n            $.async(this.stickyElementSelector,\n                this.listing(),\n                this.initStickyListingNode);\n            $.async(this.stickyElementSelector,\n                this.toolbar(),\n                this.initStickyToolbarNode);\n        },\n\n        /**\n         * Init columns (each time when amount of columns is changed)\n         *\n         */\n        initColumns: function () {\n            this.columns = this.listingNode.find(this.columnSelector);\n        },\n\n        /**\n         * Init left DataGridCap\n         *\n         * @param {HTMLElement} node\n         */\n        initLeftDataGridCap: function (node) {\n            this.leftDataGridCap = $(node);\n        },\n\n        /**\n         * Init right DataGridCap\n         *\n         * @param {HTMLElement} node\n         */\n        initRightDataGridCap: function (node) {\n            this.rightDataGridCap = $(node);\n        },\n\n        /**\n         * Init listeners\n         *\n         * @returns {Object} Chainable.\n         */\n        initListeners: function () {\n            this.adjustStickyElems();\n            this.initOnResize()\n                .initOnScroll()\n                .initOnListingScroll();\n\n            return this;\n        },\n\n        /**\n         * Start to listen to window scroll event\n         *\n         * @returns {Object} Chainable.\n         */\n        initOnScroll: function () {\n            this.lastHorizontalScrollPos = $(window).scrollLeft();\n            document.addEventListener('scroll', function () {\n                this.flags.scrolled = true;\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Start to listen to original listing scroll event\n         *\n         * @returns {Object} Chainable.\n         */\n        initOnListingScroll: function () {\n            $(this.listingNode).on('scroll', function (e) {\n                this.flags.listingScrolled = true;\n                this.flags.listingScrolledValue = $(e.target).scrollLeft();\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Start to listen to window resize event\n         *\n         * @returns {Object} Chainable.\n         */\n        initOnResize: function () {\n            $(window).on('resize', function () {\n                this.flags.resized = true;\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Adjust sticky header elements according to flags of the events that have happened in the endless RAF loop\n         */\n        adjustStickyElems: function () {\n            if (this.flags.resized ||\n                this.flags.scrolled) {\n                this.checkPos();\n            }\n\n            if (this.visible) {\n                this.checkTableElemsWidth();\n\n                if (this.flags.originalWidthChanged) {\n                    this.adjustContainerElemsWidth();\n                }\n\n                if (this.flags.resized) {\n                    this.onResize();\n                }\n\n                if (this.flags.scrolled) {\n                    this.onWindowScroll();\n                }\n\n                if (this.flags.listingScrolled) {\n                    this.onListingScroll(this.flags.listingScrolledValue);\n                }\n            }\n            _.each(this.flags, function (val, key) {\n                if (val === this.dirtyFlag) {\n                    this.flags[key] = false;\n                } else if (val) {\n                    this.flags[key] = this.dirtyFlag;\n                }\n            }, this);\n\n            raf(this.adjustStickyElems);\n        },\n\n        /**\n         * Handles window scroll\n         */\n        onWindowScroll: function () {\n            var scrolled = $(window).scrollLeft(),\n                horizontal = this.lastHorizontalScrollPos !== scrolled;\n\n            if (horizontal) {\n                this.adjustOffset()\n                    .adjustDataGridCapPositions();\n                this.lastHorizontalScrollPos = scrolled;\n            } else {\n                this.checkPos();\n            }\n        },\n\n        /**\n         * Handles original listing scroll\n         *\n         * @param {Number} scrolled\n         */\n        onListingScroll: function (scrolled) {\n            this.adjustOffset(scrolled);\n        },\n\n        /**\n         * Handles window resize\n         */\n        onResize: function () {\n            this.checkPos();\n            this.adjustContainerElemsWidth()\n                .adjustDataGridCapPositions();\n        },\n\n        /**\n         * Check if original table or columns change it dimensions and sets appropriate flag\n         */\n        checkTableElemsWidth: function () {\n            var newWidth = this.getTableWidth();\n\n            if (this.cache.tableWidth !== newWidth) {\n                this.cache.tableWidth = newWidth;\n                this.flags.originalWidthChanged = true;\n            } else if (this.cache.colChecksum !== this.getColsChecksum()) {\n                this.cache.colChecksum = this.getColsChecksum();\n                this.flags.originalWidthChanged = true;\n            }\n        },\n\n        /**\n         * Get the checksum of original columns width\n         *\n         * @returns {Number}.\n         */\n        getColsChecksum: function () {\n            return _.reduce(this.columns,\n            function (pv, cv) {\n                return ($(pv).width() || pv) + '' + $(cv).width();\n            });\n        },\n\n        /**\n         * Get the width of the sticky table wrapper\n         *\n         * @returns {Number}.\n         */\n        getListingWidth: function () {\n            return this.listingNode.width();\n        },\n\n        /**\n         * Get the width of the original table\n         *\n         * @returns {Number}.\n         */\n        getTableWidth: function () {\n            return this.listingNode.find(this.tableSelector).width();\n        },\n\n        /**\n         * Get the top elem: header or toolbar\n         *\n         * @returns {HTMLElement}.\n         */\n        getTopElement: function () {\n            return this.toolbarNode || this.listingNode;\n        },\n\n        /**\n         * Get the height of the other sticky elem (Page header)\n         *\n         * @returns {Number}.\n         */\n        getOtherStickyElementsSize: function () {\n            return this.otherStickyElsSize;\n        },\n\n        /**\n         * Get original bulk row height, if is visible\n         *\n         * @returns {Number}.\n         */\n        getBulkRowHeight: function () {\n            return this.listingNode.find(this.bulkRowSelector).filter(':visible').height();\n        },\n\n        /**\n         * Get top Y coord of the sticky header\n         *\n         * @returns {Number}.\n         */\n        getListingTopYCoord: function () {\n            var bulkRowHeight = this.getBulkRowHeight();\n\n            return this.listingNode.find('tbody').offset().top -\n                this.containerNode.height() -\n                $(window).scrollTop() +\n                bulkRowHeight;\n        },\n\n        /**\n         * Check if sticky header must be visible\n         *\n         * @returns {Boolean}.\n         */\n        getMustBeSticky: function () {\n            var stickyTopCondition = this.getListingTopYCoord() - this.getOtherStickyElementsSize(),\n                stickyBottomCondition = this.listingNode.offset().top +\n                    this.listingNode.height() -\n                    $(window).scrollTop() +\n                    this.getBulkRowHeight() -\n                    this.getOtherStickyElementsSize();\n\n            return stickyTopCondition < 0 && stickyBottomCondition > 0;\n        },\n\n        /**\n         * Resize sticky header and cols\n         *\n         * @returns {Object} Chainable.\n         */\n        adjustContainerElemsWidth: function () {\n            this.resizeContainer()\n                .resizeCols()\n                .resizeBulk();\n\n            return this;\n        },\n\n        /**\n         * Resize sticky header\n         *\n         * @returns {Object} Chainable.\n         */\n        resizeContainer: function () {\n            var listingWidth = this.getListingWidth();\n\n            this.stickyListingNode.innerWidth(listingWidth);\n            this.stickyListingNode.find(this.tableSelector).innerWidth(this.getTableWidth());\n\n            if (this.stickyToolbarNode) {\n                this.stickyToolbarNode.innerWidth(listingWidth);\n            }\n\n            return this;\n        },\n\n        /**\n         * Resize sticky cols\n         *\n         * @returns {Object} Chainable.\n         */\n        resizeCols: function () {\n            var cols = this.listingNode.find(this.columnSelector);\n\n            this.stickyListingNode.find(this.columnSelector).each(function (ind) {\n                var originalColWidth =  $(cols[ind]).width();\n\n                $(this).width(originalColWidth);\n            });\n\n            return this;\n        },\n\n        /**\n         * Resize bulk row header\n         *\n         * @returns {Object} Chainable.\n         */\n        resizeBulk: function () {\n            var bulk = this.containerNode.find(this.bulkRowHeaderSelector)[0];\n\n            if (bulk) {\n                $(bulk).innerWidth(this.getListingWidth());\n            }\n\n            return this;\n        },\n\n        /**\n         * Reset viewport to the top of listing\n         */\n        resetToTop: function () {\n            var posOfTopEl = this.getTopElement().offset().top - this.getOtherStickyElementsSize() || 0;\n\n            $(window).scrollTop(posOfTopEl);\n        },\n\n        /**\n         * Adjust sticky header offset\n         *\n         * @param {Number} val\n         * @returns {Object} Chainable.\n         */\n        adjustOffset: function (val) {\n            val = val || this.listingNode.scrollLeft();\n            this.stickyListingNode.offset({\n                left: this.listingNode.offset().left - val\n            });\n\n            return this;\n        },\n\n        /**\n         * Adjust both DataGridCap position\n         *\n         * @returns {Object} Chainable.\n         */\n        adjustDataGridCapPositions: function () {\n            this.adjustLeftDataGridCapPos()\n                .adjustRightDataGridCapPos();\n\n            return this;\n        },\n\n        /**\n         * Adjust left DataGridCap position\n         *\n         * @returns {Object} Chainable.\n         */\n        adjustLeftDataGridCapPos: function () {\n            this.leftDataGridCap.offset({\n                left: this.listingNode.offset().left - this.leftDataGridCap.width()\n            });\n\n            return this;\n        },\n\n        /**\n         * Adjust right DataGridCap position\n         *\n         * @returns {Object} Chainable.\n         */\n        adjustRightDataGridCapPos: function () {\n            this.rightDataGridCap.offset({\n                left: this.listingNode.offset().left + this.listingNode.width()\n            });\n\n            return this;\n        },\n\n        /**\n         * Hides the oiginal toolbar opened dropdowns/collapsibles etc\n         */\n        collapseOriginalElements: function () {\n            this.toolbarNode\n                .find(this.toolbarCollapsiblesSelector)\n                .css('visibility', 'hidden');\n            $(this.listingNode.find(this.bulkRowSelector)[0]).css('visibility', 'hidden');\n        },\n\n        /**\n         * Restores the oiginal toolbar opened dropdowns/collapsibles etc\n         */\n        restoreOriginalElements: function () {\n            this.toolbarNode\n                .find(this.toolbarCollapsiblesSelector)\n                .css('visibility', 'visible');\n            $(this.listingNode.find(this.bulkRowSelector)[0]).css('visibility', 'visible');\n        },\n\n        /**\n         * Toggle the visibility of sticky header\n         *\n         * @returns {Object} Chainable.\n         */\n        toggleContainerVisibility: function () {\n            this.visible = !this.visible;\n\n            return this;\n        },\n\n        /**\n         * Checks position of the listing to know if need to show/hide sticky header\n         *\n         * @returns {Boolean} whether the visibility of the sticky header was toggled.\n         */\n        checkPos: function () {\n            var isSticky = this.visible,\n                mustBeSticky = this.getMustBeSticky(),\n                needChange = isSticky !== mustBeSticky;\n\n            if (needChange) {\n                if (mustBeSticky) {\n                    this.collapseOriginalElements();\n                    this.toggleContainerVisibility();\n                    this.adjustContainerElemsWidth()\n                        .adjustOffset()\n                        .adjustDataGridCapPositions();\n\n                } else {\n                    this.toggleContainerVisibility();\n                    this.restoreOriginalElements();\n                }\n            }\n\n            return needChange;\n        }\n    });\n});\n","Magento_Ui/js/lib/collapsible.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'uiComponent'\n], function (Component) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            opened: false,\n            collapsible: true\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Collapsible} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe('opened');\n\n            return this;\n        },\n\n        /**\n         * Toggles value of the 'opened' property.\n         *\n         * @returns {Collapsible} Chainable.\n         */\n        toggleOpened: function () {\n            this.opened() ?\n                this.close() :\n                this.open();\n\n            return this;\n        },\n\n        /**\n         * Sets 'opened' flag to false.\n         *\n         * @returns {Collapsible} Chainable.\n         */\n        close: function () {\n            if (this.collapsible) {\n                this.opened(false);\n            }\n\n            return this;\n        },\n\n        /**\n         * Sets 'opened' flag to true.\n         *\n         * @returns {Collapsible} Chainable.\n         */\n        open: function () {\n            if (this.collapsible) {\n                this.opened(true);\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_Ui/js/lib/key-codes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([], function () {\n    'use strict';\n\n    return {\n        13: 'enterKey',\n        27: 'escapeKey',\n        40: 'pageDownKey',\n        38: 'pageUpKey',\n        32: 'spaceKey',\n        9:  'tabKey',\n        37: 'pageLeftKey',\n        39: 'pageRightKey',\n        17: 'ctrlKey',\n        18: 'altKey',\n        16: 'shiftKey',\n        191: 'forwardSlashKey',\n        66: 'bKey',\n        73: 'iKey',\n        85: 'uKey'\n    };\n});\n","Magento_Ui/js/lib/spinner.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var selector = '[data-role=\"spinner\"]',\n        spinner = $(selector);\n\n    return {\n        /**\n         * Show spinner.\n         */\n        show: function () {\n            spinner.show();\n        },\n\n        /**\n         * Hide spinner.\n         */\n        hide: function () {\n            spinner.hide();\n        },\n\n        /**\n         * Get spinner by selector.\n         *\n         * @param {String} id\n         * @return {jQuery}\n         */\n        get: function (id) {\n            return $(selector + '[data-component=\"' + id + '\"]');\n        }\n    };\n});\n","Magento_Ui/js/lib/step-wizard.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiRegistry',\n    'uiComponent',\n    'jquery',\n    'underscore',\n    'ko',\n    'mage/backend/notification',\n    'mage/translate'\n], function (uiRegistry, Component, $, _, ko) {\n    'use strict';\n\n    var Wizard;\n\n    ko.utils.domNodeDisposal.cleanExternalData = _.wrap(\n        ko.utils.domNodeDisposal.cleanExternalData,\n        function (func, node) {\n            if (!$(node).closest('[data-type=skipKO]').length) {\n                func(node);\n            }\n        }\n    );\n\n    /**\n     * Wizard constructor.\n     *\n     * @param {Array} steps\n     * @param {String} modalClass\n     * @constructor\n     */\n    Wizard = function (steps, modalClass) {\n        this.steps = steps;\n        this.index = 0;\n        this.data = {};\n        this.nextLabelText = $.mage.__('Next');\n        this.prevLabelText = $.mage.__('Back');\n        this.elementSelector = '[data-role=steps-wizard-main]';\n        this.element = modalClass ? $('.' + modalClass + this.elementSelector) : $(this.elementSelector);\n        this.nextLabel = '[data-role=\"step-wizard-next\"]';\n        this.prevLabel = '[data-role=\"step-wizard-prev\"]';\n        this.element.notification();\n\n        /**\n         * Move to newIndex.\n         *\n         * @param {Number} newIndex\n         * @return {String}\n         */\n        this.move = function (newIndex) {\n            if (!this.preventSwitch(newIndex)) {\n                if (newIndex > this.index) {\n                    this._next(newIndex);\n                } else if (newIndex < this.index) {\n                    this._prev(newIndex);\n                }\n            }\n            this.updateLabels(this.getStep());\n            this.showNotificationMessage();\n\n            return this.getStep().name;\n        };\n\n        /**\n         * Move wizard to next step.\n         *\n         * @return {String}\n         */\n        this.next = function () {\n            this.move(this.index + 1);\n\n            return this.getStep().name;\n        };\n\n        /**\n         * Move wizard to previous step.\n         *\n         * @return {String}\n         */\n        this.prev = function () {\n            this.move(this.index - 1);\n\n            return this.getStep().name;\n        };\n\n        /**\n         * @return {*}\n         */\n        this.preventSwitch = function (newIndex) {\n            return newIndex < 0 || (newIndex - this.index) > 1;//eslint-disable-line no-extra-parens\n        };\n\n        /**\n         * @param {Number} newIndex\n         * @return {Boolean}\n         * @private\n         */\n        this._next = function (newIndex) {\n            newIndex = _.isNumber(newIndex) ? newIndex : this.index + 1;\n\n            try {\n                this.getStep().force(this);\n\n                if (newIndex >= steps.length) {\n                    return false;\n                }\n            } catch (e) {\n                this.setNotificationMessage(e.message, true);\n\n                return false;\n            }\n            this.cleanErrorNotificationMessage();\n            this.index = newIndex;\n            this.cleanNotificationMessage();\n            this.render();\n        };\n\n        /**\n         * @param {Number} newIndex\n         * @private\n         */\n        this._prev = function (newIndex) {\n            newIndex = _.isNumber(newIndex) ? newIndex : this.index - 1;\n            this.getStep().back(this);\n            this.index = newIndex;\n        };\n\n        /**\n         * @param {Number} stepIndex\n         * @return {Object}\n         */\n        this.getStep = function (stepIndex) {\n            return this.steps[stepIndex || this.index] || {};\n        };\n\n        /**\n         * @param {String} message\n         * @param {String} error\n         */\n        this.notifyMessage = function (message, error) {\n            $(this.element).notification('clear').notification('add', {\n                error: error,\n                message: message\n            });\n        };\n\n        /**\n         * @param {Object} step\n         */\n        this.updateLabels = function (step) {\n            this.element.find(this.nextLabel).find('button').text(step.nextLabelText || this.nextLabelText);\n            this.element.find(this.prevLabel).find('button').text(step.prevLabelText || this.prevLabelText);\n        };\n\n        /**\n         * Show notification message.\n         */\n        this.showNotificationMessage = function () {\n            if (!_.isEmpty(this.getStep())) {\n                this.hideNotificationMessage();\n\n                if (this.getStep().notificationMessage.text !== null) {\n                    this.notifyMessage(\n                        this.getStep().notificationMessage.text,\n                        this.getStep().notificationMessage.error\n                    );\n                }\n            }\n        };\n\n        /**\n         * Remove notification message.\n         */\n        this.cleanNotificationMessage = function () {\n            this.getStep().notificationMessage.text = null;\n            this.hideNotificationMessage();\n        };\n\n        /**\n         * Remove error message.\n         */\n        this.cleanErrorNotificationMessage = function () {\n            if (this.getStep().notificationMessage.error === true) {\n                this.cleanNotificationMessage();\n            }\n        };\n\n        /**\n         * @param {String} text\n         * @param {String} error\n         */\n        this.setNotificationMessage = function (text, error) {\n            error = error !== undefined;\n\n            if (!_.isEmpty(this.getStep())) {\n                this.getStep().notificationMessage.text = text;\n                this.getStep().notificationMessage.error = error;\n                this.showNotificationMessage();\n            }\n        };\n\n        /**\n         * Hide notification message.\n         */\n        this.hideNotificationMessage = function () {\n            $(this.element).notification('clear');\n        };\n\n        /**\n         * Render step.\n         */\n        this.render = function () {\n            this.hideNotificationMessage();\n            this.getStep().render(this);\n        };\n\n        /**\n         * Initialize step.\n         */\n        this.init = function () {\n            this.updateLabels(this.getStep());\n            this.render();\n        };\n        this.init();\n    };\n\n    return Component.extend({\n        defaults: {\n            modalClass: '',\n            initData: [],\n            stepsNames: [],\n            selectedStep: '',\n            steps: [],\n            disabled: true\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.selectedStep.subscribe(this.wrapDisabledBackButton.bind(this));\n        },\n\n        /** @inheritdoc */\n        initElement: function (step) {\n            step.initData = this.initData;\n            step.mode = _.all(this.initData, _.isEmpty) ? 'create' : 'edit';\n            this.steps[this.getStepIndexByName(step.name)] = step;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe([\n                'selectedStep',\n                'disabled'\n            ]);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            _.each(this.steps, function (step) {\n                step.destroy();\n            });\n\n            this._super();\n        },\n\n        /**\n         * Toggle disable property.\n         *\n         * @param {String} stepName\n         */\n        wrapDisabledBackButton: function (stepName) {\n            if (_.first(this.stepsNames) === stepName) {\n                this.disabled(true);\n            } else {\n                this.disabled(false);\n            }\n        },\n\n        /**\n         * Get step by index name.\n         *\n         * @param {String} stepName\n         */\n        getStepIndexByName: function (stepName) {\n            return _.indexOf(this.stepsNames, stepName);\n        },\n        //controls, todo to another object\n        /**\n         * Select next step.\n         */\n        next: function () {\n            this.selectedStep(this.wizard.next());\n        },\n\n        /**\n         * Select previous step.\n         */\n        back: function () {\n            this.selectedStep(this.wizard.prev());\n        },\n\n        /**\n         * Open wizard.\n         */\n        open: function () {\n            this.selectedStep(this.stepsNames.first());\n            this.wizard = new Wizard(this.steps, this.modalClass);\n        },\n\n        /**\n         * Close wizard.\n         */\n        close: function () {\n            var modal =  uiRegistry.get(this.initData.configurableModal);\n\n            if (!_.isUndefined(modal)) {\n                modal.closeModal();\n            }\n        },\n\n        /**\n         * @param {Object} data\n         * @param {Object} event\n         */\n        showSpecificStep: function (data, event) {\n            var index = _.indexOf(this.stepsNames, event.target.hash.substr(1)),\n                stepName = this.wizard.move(index);\n\n            this.selectedStep(stepName);\n        }\n    });\n});\n","Magento_Ui/js/lib/core/class.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'mage/utils/wrapper'\n], function (_, utils, wrapper) {\n    'use strict';\n\n    var Class;\n\n    /**\n     * Returns property of an object if\n     * it's his own property.\n     *\n     * @param {Object} obj - Object whose property should be retrieved.\n     * @param {String} prop - Name of the property.\n     * @returns {*} Value of the property or false.\n     */\n    function getOwn(obj, prop) {\n        return _.isObject(obj) && obj.hasOwnProperty(prop) && obj[prop];\n    }\n\n    /**\n     * Creates constructor function which allows\n     * initialization without usage of a 'new' operator.\n     *\n     * @param {Object} protoProps - Prototypal properties of a new constructor.\n     * @param {Function} constructor\n     * @returns {Function} Created constructor.\n     */\n    function createConstructor(protoProps, constructor) {\n        var UiClass = constructor;\n\n        if (!UiClass) {\n\n            /**\n             * Default constructor function.\n             */\n            UiClass = function () {\n                var obj = this;\n\n                if (!_.isObject(obj) || Object.getPrototypeOf(obj) !== UiClass.prototype) {\n                    obj = Object.create(UiClass.prototype);\n                }\n\n                obj.initialize.apply(obj, arguments);\n\n                return obj;\n            };\n        }\n\n        UiClass.prototype = protoProps;\n        UiClass.prototype.constructor = UiClass;\n\n        return UiClass;\n    }\n\n    Class = createConstructor({\n\n        /**\n         * Entry point to the initialization of constructor's instance.\n         *\n         * @param {Object} [options={}]\n         * @returns {Class} Chainable.\n         */\n        initialize: function (options) {\n            this.initConfig(options);\n\n            return this;\n        },\n\n        /**\n         * Recursively extends data specified in constructors' 'defaults'\n         * property with provided options object. Evaluates resulting\n         * object using string templates (see: mage/utils/template.js).\n         *\n         * @param {Object} [options={}]\n         * @returns {Class} Chainable.\n         */\n        initConfig: function (options) {\n            var defaults    = this.constructor.defaults,\n                config      = utils.extend({}, defaults, options || {}),\n                ignored     = config.ignoreTmpls || {},\n                cached      = utils.omit(config, ignored);\n\n            config = utils.template(config, this, false, true);\n\n            _.each(cached, function (value, key) {\n                utils.nested(config, key, value);\n            });\n\n            return _.extend(this, config);\n        }\n    });\n\n    _.extend(Class, {\n        defaults: {\n            ignoreTmpls: {\n                templates: true\n            }\n        },\n\n        /**\n         * Creates new constructor based on a current prototype properties,\n         * extending them with properties specified in 'exender' object.\n         *\n         * @param {Object} [extender={}]\n         * @returns {Function} New constructor.\n         */\n        extend: function (extender) {\n            var parent      = this,\n                parentProto = parent.prototype,\n                childProto  = Object.create(parentProto),\n                child       = createConstructor(childProto, getOwn(extender, 'constructor')),\n                defaults;\n\n            extender = extender || {};\n            defaults = extender.defaults;\n\n            delete extender.defaults;\n\n            _.each(extender, function (method, name) {\n                childProto[name] = wrapper.wrapSuper(parentProto[name], method);\n            });\n\n            child.defaults = utils.extend({}, parent.defaults || {});\n\n            if (defaults) {\n                utils.extend(child.defaults, defaults);\n                extender.defaults = defaults;\n            }\n\n            return _.extend(child, {\n                __super__:  parentProto,\n                extend:     parent.extend\n            });\n        }\n    });\n\n    return Class;\n});\n","Magento_Ui/js/lib/core/collection.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    'uiElement'\n], function (_, utils, registry, Element) {\n    'use strict';\n\n    /**\n     * Removes non plain object items from the specified array.\n     *\n     * @param {Array} container - Array whose value should be filtered.\n     * @returns {Array}\n     */\n    function compact(container) {\n        return _.values(container).filter(utils.isObject);\n    }\n\n    /**\n     * Defines index of an item in a specified container.\n     *\n     * @param {*} item - Item whose index should be defined.\n     * @param {Array} container - Container upon which to perform search.\n     * @returns {Number}\n     */\n    function _findIndex(item, container) {\n        var index = _.findKey(container, function (value) {\n            return value === item;\n        });\n\n        if (typeof index === 'undefined') {\n            index = _.findKey(container, function (value) {\n                return value && value.name === item;\n            });\n        }\n\n        return typeof index === 'undefined' ? -1 : index;\n    }\n\n    /**\n     * Inserts specified item into container at a specified position.\n     *\n     * @param {*} item - Item to be inserted into container.\n     * @param {Array} container - Container of items.\n     * @param {*} [position=-1] - Position at which item should be inserted.\n     *      Position can represent:\n     *          - specific index in container\n     *          - item which might already be present in container\n     *          - structure with one of these properties: after, before\n     * @returns {Boolean|*}\n     *      - true if element has changed its' position\n     *      - false if nothing has changed\n     *      - inserted value if it wasn't present in container\n     */\n    function _insertAt(item, container, position) {\n        var currentIndex = _findIndex(item, container),\n            newIndex,\n            target;\n\n        if (typeof position === 'undefined') {\n            position = -1;\n        } else if (typeof position === 'string') {\n            position = isNaN(+position) ? position : +position;\n        }\n\n        newIndex = position;\n\n        if (~currentIndex) {\n            target = container.splice(currentIndex, 1)[0];\n\n            if (typeof item === 'string') {\n                item = target;\n            }\n        }\n\n        if (typeof position !== 'number') {\n            target = position.after || position.before || position;\n\n            newIndex = _findIndex(target, container);\n\n            if (~newIndex && (position.after || newIndex >= currentIndex)) {\n                newIndex++;\n            }\n        }\n\n        if (newIndex < 0) {\n            newIndex += container.length + 1;\n        }\n\n        container[newIndex] ?\n            container.splice(newIndex, 0, item) :\n            container[newIndex] = item;\n\n        return !~currentIndex ? item : currentIndex !== newIndex;\n    }\n\n    return Element.extend({\n        defaults: {\n            template: 'ui/collection',\n            _elems: [],\n            ignoreTmpls: {\n                childDefaults: true\n            }\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Model} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe({\n                    elems: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Called when another element was added to current component.\n         *\n         * @param {Object} elem - Instance of an element that was added.\n         * @returns {Collection} Chainable.\n         */\n        initElement: function (elem) {\n            elem.initContainer(this);\n\n            return this;\n        },\n\n        /**\n         * Returns instance of a child found by provided index.\n         *\n         * @param {String} index - Index of a child.\n         * @returns {Object}\n         */\n        getChild: function (index) {\n            return _.findWhere(this.elems(), {\n                index: index\n            });\n        },\n\n        /**\n         * Requests specified components to insert\n         * them into 'elems' array starting from provided position.\n         *\n         * @param {(String|Array)} elems - Name of the component to insert.\n         * @param {Number} [position=-1] - Position at which to insert elements.\n         * @returns {Collection} Chainable.\n         */\n        insertChild: function (elems, position) {\n            var container   = this._elems,\n                insert      = this._insert.bind(this),\n                update;\n\n            if (!Array.isArray(elems)) {\n                elems = [elems];\n            }\n\n            elems.map(function (item) {\n                return item.elem ?\n                    _insertAt(item.elem, container, item.position) :\n                    _insertAt(item, container, position);\n            }).forEach(function (item) {\n                if (item === true) {\n                    update = true;\n                } else if (_.isString(item)) {\n                    registry.get(item, insert);\n                } else if (utils.isObject(item)) {\n                    insert(item);\n                }\n            });\n\n            if (update) {\n                this._updateCollection();\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes specified child from collection.\n         *\n         * @param {(Object|String)} elem - Child or index of a child to be removed.\n         * @param {Boolean} skipUpdate - skip collection update when element to be destroyed.\n         *\n         * @returns {Collection} Chainable.\n         */\n        removeChild: function (elem, skipUpdate) {\n            if (_.isString(elem)) {\n                elem = this.getChild(elem);\n            }\n\n            if (elem) {\n                utils.remove(this._elems, elem);\n\n                if (!skipUpdate) {\n                    this._updateCollection();\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Destroys collection children with its' elements.\n         */\n        destroyChildren: function () {\n            this.elems.each(function (elem) {\n                elem.destroy(true);\n            });\n\n            this._updateCollection();\n        },\n\n        /**\n         * Clear data. Call method \"clear\"\n         * in child components\n         *\n         * @returns {Object} Chainable.\n         */\n        clear: function () {\n            var elems = this.elems();\n\n            _.each(elems, function (elem) {\n                if (_.isFunction(elem.clear)) {\n                    elem.clear();\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Checks if specified child exists in collection.\n         *\n         * @param {String} index - Index of a child.\n         * @returns {Boolean}\n         */\n        hasChild: function (index) {\n            return !!this.getChild(index);\n        },\n\n        /**\n         * Creates 'async' wrapper for the specified child\n         * using uiRegistry 'async' method and caches it\n         * in a '_requested' components  object.\n         *\n         * @param {String} index - Index of a child.\n         * @returns {Function} Async module wrapper.\n         */\n        requestChild: function (index) {\n            var name = this.formChildName(index);\n\n            return this.requestModule(name);\n        },\n\n        /**\n         * Creates complete child name based on a provided index.\n         *\n         * @param {String} index - Index of a child.\n         * @returns {String}\n         */\n        formChildName: function (index) {\n            return this.name + '.' + index;\n        },\n\n        /**\n         * Retrieves requested region.\n         * Creates region if it was not created yet\n         *\n         * @returns {ObservableArray}\n         */\n        getRegion: function (name) {\n            var regions = this.regions = this.regions || {};\n\n            if (!regions[name]) {\n                regions[name] = [];\n\n                this.observe.call(regions, name);\n            }\n\n            return regions[name];\n        },\n\n        /**\n         * Checks if the specified region has any elements\n         * associated with it.\n         *\n         * @param {String} name\n         * @returns {Boolean}\n         */\n        regionHasElements: function (name) {\n            var region = this.getRegion(name);\n\n            return region().length > 0;\n        },\n\n        /**\n         * Replaces specified regions' data with a provided one.\n         * Creates region if it was not created yet.\n         *\n         * @param {Array} items - New regions' data.\n         * @param {String} name - Name of the region.\n         * @returns {Collection} Chainable.\n         */\n        updateRegion: function (items, name) {\n            this.getRegion(name)(items);\n\n            return this;\n        },\n\n        /**\n         * Destroys collection along with its' elements.\n         */\n        destroy: function () {\n            this._super();\n\n            this.elems.each('destroy');\n        },\n\n        /**\n         * Inserts provided component into 'elems' array at a specified position.\n         * @private\n         *\n         * @param {Object} elem - Element to insert.\n         */\n        _insert: function (elem) {\n            var index = _.findKey(this._elems, function (value) {\n                return value === elem.name;\n            });\n\n            if (typeof index !== 'undefined') {\n                this._elems[index] = elem;\n            }\n\n            this._updateCollection()\n                .initElement(elem);\n        },\n\n        /**\n         * Synchronizes multiple elements arrays with a core '_elems' container.\n         * Performs elemets grouping by theirs 'displayArea' property.\n         * @private\n         *\n         * @returns {Collection} Chainable.\n         */\n        _updateCollection: function () {\n            var _elems = compact(this._elems),\n                grouped;\n\n            grouped = _elems.filter(function (elem) {\n                return elem.displayArea && _.isString(elem.displayArea);\n            });\n            grouped = _.groupBy(grouped, 'displayArea');\n\n            _.each(grouped, this.updateRegion, this);\n\n            _.each(this.regions, function (items) {\n                var hasObsoleteComponents = items().length && !_.intersection(_elems, items()).length;\n\n                if (hasObsoleteComponents) {\n                    items.removeAll();\n                }\n            });\n\n            this.elems(_elems);\n\n            return this;\n        },\n\n        /**\n         * Tries to call specified method of a current component,\n         * otherwise delegates attempt to its' children.\n         *\n         * @param {String} target - Name of the method.\n         * @param {...*} parameters - Arguments that will be passed to method.\n         * @returns {*} Result of the method calls.\n         */\n        delegate: function (target) {\n            var args = _.toArray(arguments);\n\n            target = this[target];\n\n            if (_.isFunction(target)) {\n                return target.apply(this, args.slice(1));\n            }\n\n            return this._delegate(args);\n        },\n\n        /**\n         * Calls 'delegate' method of all of it's children components.\n         * @private\n         *\n         * @param {Array} args - An array of arguments to pass to the next delegation call.\n         * @returns {Array} An array of delegation results.\n         */\n        _delegate: function (args) {\n            var result;\n\n            result = this.elems.map(function (elem) {\n                var target;\n\n                if (!_.isFunction(elem.delegate)) {\n                    target = elem[args[0]];\n\n                    if (_.isFunction(target)) {\n                        return target.apply(elem, args.slice(1));\n                    }\n                } else {\n                    return elem.delegate.apply(elem, args);\n                }\n            });\n\n            return _.flatten(result);\n        }\n    });\n});\n","Magento_Ui/js/lib/core/events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore'\n], function (ko, _) {\n    'use strict';\n\n    var eventsMap = new WeakMap();\n\n    /**\n     * Returns events map or a specific event\n     * data associated with a provided object.\n     *\n     * @param {Object} obj - Key in the events weakmap.\n     * @param {String} [name] - Name of the event.\n     * @returns {Map|Array|Boolean}\n     */\n    function getEvents(obj, name) {\n        var events = eventsMap.get(obj);\n\n        if (!events) {\n            return false;\n        }\n\n        return name ? events.get(name) : events;\n    }\n\n    /**\n     * Adds new event handler.\n     *\n     * @param {Object} obj - Key in the events weakmap.\n     * @param {String} ns - Callback namespace.\n     * @param {Function} callback - Event callback.\n     * @param {String} name - Name of the event.\n     */\n    function addHandler(obj, ns, callback, name) {\n        var events      = getEvents(obj),\n            observable,\n            data;\n\n        observable = !ko.isObservable(obj[name]) ?\n            ko.getObservable(obj, name) :\n            obj[name];\n\n        if (observable) {\n            observable.subscribe(callback);\n\n            return;\n        }\n\n        if (!events) {\n            events = new Map();\n\n            eventsMap.set(obj, events);\n        }\n\n        data = {\n            callback: callback,\n            ns: ns\n        };\n\n        events.has(name) ?\n            events.get(name).push(data) :\n            events.set(name, [data]);\n    }\n\n    /**\n     * Invokes provided callbacks with a specified arguments.\n     *\n     * @param {Array} handlers\n     * @param {Array} args\n     * @returns {Boolean}\n     */\n    function trigger(handlers, args) {\n        var bubble = true,\n            callback;\n\n        handlers.forEach(function (handler) {\n            callback = handler.callback;\n\n            if (callback.apply(null, args) === false) {\n                bubble = false;\n            }\n        });\n\n        return bubble;\n    }\n\n    return {\n\n        /**\n         * Calls callback when name event is triggered.\n         * @param  {String}   events\n         * @param  {Function} callback\n         * @param  {Function} ns\n         * @return {Object} reference to this\n         */\n        on: function (events, callback, ns) {\n            var iterator;\n\n            if (arguments.length < 2) {\n                ns = callback;\n            }\n\n            iterator = addHandler.bind(null, this, ns);\n\n            _.isObject(events) ?\n                _.each(events, iterator) :\n                iterator(callback, events);\n\n            return this;\n        },\n\n        /**\n         * Removed callback from listening to target event\n         * @param  {String} ns\n         * @return {Object} reference to this\n         */\n        off: function (ns) {\n            var storage = getEvents(this);\n\n            if (!storage) {\n                return this;\n            }\n\n            storage.forEach(function (handlers, name) {\n                handlers = handlers.filter(function (handler) {\n                    return !ns ? false : handler.ns !== ns;\n                });\n\n                handlers.length ?\n                    storage.set(name, handlers) :\n                    storage.delete(name);\n            });\n\n            return this;\n        },\n\n        /**\n         * Triggers event and executes all attached callbacks.\n         *\n         * @param {String} name - Name of the event to be triggered.\n         * @returns {Boolean}\n         */\n        trigger: function (name) {\n            var handlers,\n                args;\n\n            handlers = getEvents(this, name),\n            args = _.toArray(arguments).slice(1);\n\n            if (!handlers || !name) {\n                return true;\n            }\n\n            return trigger(handlers, args);\n        }\n    };\n});\n","Magento_Ui/js/lib/core/element/element.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    'uiEvents',\n    'uiClass',\n    './links',\n    '../storage/local'\n], function (ko, _, utils, registry, Events, Class, links) {\n    'use strict';\n\n    var Element;\n\n    /**\n     * Creates observable property using knockouts'\n     * 'observableArray' or 'observable' methods,\n     * depending on a type of 'value' parameter.\n     *\n     * @param {Object} obj - Object to whom property belongs.\n     * @param {String} key - Key of the property.\n     * @param {*} value - Initial value.\n     */\n    function observable(obj, key, value) {\n        var method = Array.isArray(value) ? 'observableArray' : 'observable';\n\n        if (_.isFunction(obj[key]) && !ko.isObservable(obj[key])) {\n            return;\n        }\n\n        if (ko.isObservable(value)) {\n            value = value();\n        }\n\n        ko.isObservable(obj[key]) ?\n            obj[key](value) :\n            obj[key] = ko[method](value);\n    }\n\n    /**\n     * Creates observable property using 'track' method.\n     *\n     * @param {Object} obj - Object to whom property belongs.\n     * @param {String} key - Key of the property.\n     * @param {*} value - Initial value.\n     */\n    function accessor(obj, key, value) {\n        if (_.isFunction(obj[key]) || ko.isObservable(obj[key])) {\n            return;\n        }\n\n        obj[key] = value;\n\n        if (!ko.es5.isTracked(obj, key)) {\n            ko.track(obj, [key]);\n        }\n    }\n\n    Element = _.extend({\n        defaults: {\n            _requested: {},\n            containers: [],\n            exports: {},\n            imports: {},\n            links: {},\n            listens: {},\n            name: '',\n            ns: '${ $.name.split(\".\")[0] }',\n            provider: '',\n            registerNodes: true,\n            source: null,\n            statefull: {},\n            template: '',\n            tracks: {},\n            storageConfig: {\n                provider: 'localStorage',\n                namespace: '${ $.name }',\n                path: '${ $.storageConfig.provider }:${ $.storageConfig.namespace }'\n            },\n            maps: {\n                imports: {},\n                exports: {}\n            },\n            modules: {\n                storage: '${ $.storageConfig.provider }'\n            }\n        },\n\n        /**\n         * Initializes model instance.\n         *\n         * @returns {Element} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initObservable()\n                .initModules()\n                .initStatefull()\n                .initLinks()\n                .initUnique();\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Element} Chainable.\n         */\n        initObservable: function () {\n            _.each(this.tracks, function (enabled, key) {\n                if (enabled) {\n                    this.track(key);\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Parses 'modules' object and creates\n         * async wrappers for specified components.\n         *\n         * @returns {Element} Chainable.\n         */\n        initModules: function () {\n            _.each(this.modules, function (name, property) {\n                if (name) {\n                    this[property] = this.requestModule(name);\n                }\n            }, this);\n\n            if (!_.isFunction(this.source)) {\n                this.source = registry.get(this.provider);\n            }\n\n            return this;\n        },\n\n        /**\n         * Called when current element was injected to another component.\n         *\n         * @param {Object} parent - Instance of a 'parent' component.\n         * @returns {Collection} Chainable.\n         */\n        initContainer: function (parent) {\n            this.containers.push(parent);\n\n            return this;\n        },\n\n        /**\n         * Initializes statefull properties\n         * based on the keys of 'statefull' object.\n         *\n         * @returns {Element} Chainable.\n         */\n        initStatefull: function () {\n            _.each(this.statefull, function (path, key) {\n                if (path) {\n                    this.setStatefull(key, path);\n                }\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Initializes links between properties.\n         *\n         * @returns {Element} Chainbale.\n         */\n        initLinks: function () {\n            return this.setListeners(this.listens)\n                       .setLinks(this.links, 'imports')\n                       .setLinks(this.links, 'exports')\n                       .setLinks(this.exports, 'exports')\n                       .setLinks(this.imports, 'imports');\n        },\n\n        /**\n         * Initializes listeners of the unique property.\n         *\n         * @returns {Element} Chainable.\n         */\n        initUnique: function () {\n            var update = this.onUniqueUpdate.bind(this),\n                uniqueNs = this.uniqueNs;\n\n            this.hasUnique = this.uniqueProp && uniqueNs;\n\n            if (this.hasUnique) {\n                this.source.on(uniqueNs, update, this.name);\n            }\n\n            return this;\n        },\n\n        /**\n         * Makes specified property to be stored automatically.\n         *\n         * @param {String} key - Name of the property\n         *      that will be stored.\n         * @param {String} [path=key] - Path to the property in storage.\n         * @returns {Element} Chainable.\n         */\n        setStatefull: function (key, path) {\n            var link = {};\n\n            path        = !_.isString(path) || !path ? key : path;\n            link[key]   = this.storageConfig.path + '.' + path;\n\n            this.setLinks(link, 'imports')\n                .setLinks(link, 'exports');\n\n            return this;\n        },\n\n        /**\n         * Updates property specified in uniqueNs\n         * if elements' unique property is set to 'true'.\n         *\n         * @returns {Element} Chainable.\n         */\n        setUnique: function () {\n            var property = this.uniqueProp;\n\n            if (this[property]()) {\n                this.source.set(this.uniqueNs, this.name);\n            }\n\n            return this;\n        },\n\n        /**\n         * Creates 'async' wrapper for the specified component\n         * using uiRegistry 'async' method and caches it\n         * in a '_requested' components  object.\n         *\n         * @param {String} name - Name of requested component.\n         * @returns {Function} Async module wrapper.\n         */\n        requestModule: function (name) {\n            var requested = this._requested;\n\n            if (!requested[name]) {\n                requested[name] = registry.async(name);\n            }\n\n            return requested[name];\n        },\n\n        /**\n         * Returns path to elements' template.\n         *\n         * @returns {String}\n         */\n        getTemplate: function () {\n            return this.template;\n        },\n\n        /**\n         * Checks if template was specified for an element.\n         *\n         * @returns {Boolean}\n         */\n        hasTemplate: function () {\n            return !!this.template;\n        },\n\n        /**\n         * Returns value of the nested property.\n         *\n         * @param {String} path - Path to the property.\n         * @returns {*} Value of the property.\n         */\n        get: function (path) {\n            return utils.nested(this, path);\n        },\n\n        /**\n         * Sets provided value as a value of the specified nested property.\n         * Triggers changes notifications, if value has mutated.\n         *\n         * @param {String} path - Path to property.\n         * @param {*} value - New value of the property.\n         * @returns {Element} Chainable.\n         */\n        set: function (path, value) {\n            var data = this.get(path),\n                diffs;\n\n            diffs = !_.isFunction(data) && !this.isTracked(path) ?\n                utils.compare(data, value, path) :\n                false;\n\n            utils.nested(this, path, value);\n\n            if (diffs) {\n                this._notifyChanges(diffs);\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes nested property from the object.\n         *\n         * @param {String} path - Path to the property.\n         * @returns {Element} Chainable.\n         */\n        remove: function (path) {\n            var data = utils.nested(this, path),\n                diffs;\n\n            if (_.isUndefined(data) || _.isFunction(data)) {\n                return this;\n            }\n\n            diffs = utils.compare(data, undefined, path);\n\n            utils.nestedRemove(this, path);\n\n            this._notifyChanges(diffs);\n\n            return this;\n        },\n\n        /**\n         * Creates observable properties for the current object.\n         *\n         * If 'useTrack' flag is set to 'true' then each property will be\n         * created with a ES5 get/set accessor descriptors, instead of\n         * making them an observable functions.\n         * See 'knockout-es5' library for more information.\n         *\n         * @param {Boolean} [useAccessors=false] - Whether to create an\n         *      observable function or to use property accesessors.\n         * @param {(Object|String|Array)} properties - List of observable properties.\n         * @returns {Element} Chainable.\n         *\n         * @example Sample declaration and equivalent knockout methods.\n         *      this.key = 'value';\n         *      this.array = ['value'];\n         *\n         *      this.observe(['key', 'array']);\n         *      =>\n         *          this.key = ko.observable('value');\n         *          this.array = ko.observableArray(['value']);\n         *\n         * @example Another syntaxes of the previous example.\n         *      this.observe({\n         *          key: 'value',\n         *          array: ['value']\n         *      });\n         */\n        observe: function (useAccessors, properties) {\n            var model = this,\n                trackMethod;\n\n            if (typeof useAccessors !== 'boolean') {\n                properties   = useAccessors;\n                useAccessors = false;\n            }\n\n            trackMethod = useAccessors ? accessor : observable;\n\n            if (_.isString(properties)) {\n                properties = properties.split(' ');\n            }\n\n            if (Array.isArray(properties)) {\n                properties.forEach(function (key) {\n                    trackMethod(model, key, model[key]);\n                });\n            } else if (typeof properties === 'object') {\n                _.each(properties, function (value, key) {\n                    trackMethod(model, key, value);\n                });\n            }\n\n            return this;\n        },\n\n        /**\n         * Delegates call to 'observe' method but\n         * with a predefined 'useAccessors' flag.\n         *\n         * @param {(String|Array|Object)} properties - List of observable properties.\n         * @returns {Element} Chainable.\n         */\n        track: function (properties) {\n            this.observe(true, properties);\n\n            return this;\n        },\n\n        /**\n         * Checks if specified property is tracked.\n         *\n         * @param {String} property - Property to be checked.\n         * @returns {Boolean}\n         */\n        isTracked: function (property) {\n            return ko.es5.isTracked(this, property);\n        },\n\n        /**\n         * Invokes subscribers for the provided changes.\n         *\n         * @param {Object} diffs - Object with changes descriptions.\n         * @returns {Element} Chainable.\n         */\n        _notifyChanges: function (diffs) {\n            diffs.changes.forEach(function (change) {\n                this.trigger(change.path, change.value, change);\n            }, this);\n\n            _.each(diffs.containers, function (changes, name) {\n                var value = utils.nested(this, name);\n\n                this.trigger(name, value, changes);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Extracts all stored data and sets it to element.\n         *\n         * @returns {Element} Chainable.\n         */\n        restore: function () {\n            var ns = this.storageConfig.namespace,\n                storage = this.storage();\n\n            if (storage) {\n                utils.extend(this, storage.get(ns));\n            }\n\n            return this;\n        },\n\n        /**\n         * Stores value of the specified property in components' storage module.\n         *\n         * @param {String} property\n         * @param {*} [data=this[property]]\n         * @returns {Element} Chainable.\n         */\n        store: function (property, data) {\n            var ns = this.storageConfig.namespace,\n                path = utils.fullPath(ns, property);\n\n            if (arguments.length < 2) {\n                data = this.get(property);\n            }\n\n            this.storage('set', path, data);\n\n            return this;\n        },\n\n        /**\n         * Extracts specified property from storage.\n         *\n         * @param {String} [property] - Name of the property\n         *      to be extracted. If not specified then all of the\n         *      stored will be returned.\n         * @returns {*}\n         */\n        getStored: function (property) {\n            var ns = this.storageConfig.namespace,\n                path = utils.fullPath(ns, property),\n                storage = this.storage(),\n                data;\n\n            if (storage) {\n                data = storage.get(path);\n            }\n\n            return data;\n        },\n\n        /**\n         * Removes stored property.\n         *\n         * @param {String} property - Property to be removed from storage.\n         * @returns {Element} Chainable.\n         */\n        removeStored: function (property) {\n            var ns = this.storageConfig.namespace,\n                path = utils.fullPath(ns, property);\n\n            this.storage('remove', path);\n\n            return this;\n        },\n\n        /**\n         * Destroys current instance along with all of its' children.\n         * @param {Boolean} skipUpdate - skip collection update when element to be destroyed.\n         */\n        destroy: function (skipUpdate) {\n            this._dropHandlers()\n                ._clearRefs(skipUpdate);\n        },\n\n        /**\n         * Removes events listeners.\n         * @private\n         *\n         * @returns {Element} Chainable.\n         */\n        _dropHandlers: function () {\n            this.off();\n\n            if (_.isFunction(this.source)) {\n                this.source().off(this.name);\n            } else if (this.source) {\n                this.source.off(this.name);\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes all references to current instance and\n         * calls 'destroy' method on all of its' children.\n         * @private\n         * @param {Boolean} skipUpdate - skip collection update when element to be destroyed.\n         *\n         * @returns {Element} Chainable.\n         */\n        _clearRefs: function (skipUpdate) {\n            registry.remove(this.name);\n\n            this.containers.forEach(function (parent) {\n                parent.removeChild(this, skipUpdate);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Overrides 'EventsBus.trigger' method to implement events bubbling.\n         *\n         * @param {...*} arguments - Any number of arguments that should be passed to the events' handler.\n         * @returns {Boolean} False if event bubbling was canceled.\n         */\n        bubble: function () {\n            var args = _.toArray(arguments),\n                bubble = this.trigger.apply(this, args),\n                result;\n\n            if (!bubble) {\n                return false;\n            }\n\n            this.containers.forEach(function (parent) {\n                result = parent.bubble.apply(parent, args);\n\n                if (result === false) {\n                    bubble = false;\n                }\n            });\n\n            return !!bubble;\n        },\n\n        /**\n         * Callback which fires when property under uniqueNs has changed.\n         */\n        onUniqueUpdate: function (name) {\n            var active = name === this.name,\n                property = this.uniqueProp;\n\n            this[property](active);\n        },\n\n        /**\n         * Clean data form data source.\n         *\n         * @returns {Element}\n         */\n        cleanData: function () {\n            if (this.source && this.source.componentType === 'dataSource') {\n                if (this.elems) {\n                    _.each(this.elems(), function (val) {\n                        val.cleanData();\n                    });\n                } else {\n                    this.source.remove(this.dataScope);\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Fallback data.\n         */\n        cacheData: function () {\n            this.cachedComponent = utils.copy(this);\n        },\n\n        /**\n         * Update configuration in component.\n         *\n         * @param {*} oldValue\n         * @param {*} newValue\n         * @param {String} path - path to value.\n         * @returns {Element}\n         */\n        updateConfig: function (oldValue, newValue, path) {\n            var names = path.split('.'),\n                index = _.lastIndexOf(names, 'config') + 1;\n\n            names = names.splice(index, names.length - index).join('.');\n            this.set(names, newValue);\n\n            return this;\n        }\n    }, Events, links);\n\n    return Class.extend(Element);\n});\n","Magento_Ui/js/lib/core/element/links.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'mageUtils',\n    'uiRegistry'\n], function (ko, _, utils, registry) {\n    'use strict';\n\n    /**\n     * Parse provided data.\n     *\n     * @param {String} placeholder\n     * @param {String} data\n     * @param {String} direction\n     * @returns {Boolean|Object}\n     */\n    function parseData(placeholder, data, direction) {\n        if (typeof data !== 'string') {\n            return false;\n        }\n\n        data = data.split(':');\n\n        if (!data[0]) {\n            return false;\n        }\n\n        if (!data[1]) {\n            data[1] = data[0];\n            data[0] = placeholder;\n        }\n\n        return {\n            target: data[0],\n            property: data[1],\n            direction: direction\n        };\n    }\n\n    /**\n     * Check if value not empty.\n     *\n     * @param {*} value\n     * @returns {Boolean}\n     */\n    function notEmpty(value) {\n        return typeof value !== 'undefined' && value != null;\n    }\n\n    /**\n     * Update value for linked component.\n     *\n     * @param {Object} data\n     * @param {Object} owner\n     * @param {Object} target\n     * @param {*} value\n     */\n    function updateValue(data, owner, target, value) {\n        var component = target.component,\n            property = target.property,\n            linked = data.linked;\n\n        if (data.mute) {\n            return;\n        }\n\n        if (linked) {\n            linked.mute = true;\n        }\n\n        if (owner.component !== target.component) {\n            value = data.inversionValue ? !utils.copy(value) : utils.copy(value);\n        }\n\n        component.set(property, value, owner);\n\n        if (property === 'disabled' && value) {\n            component.set('validate', value, owner);\n        }\n\n        if (linked) {\n            linked.mute = false;\n        }\n    }\n\n    /**\n     * Get value form owner component property.\n     *\n     * @param {Object} owner\n     * @returns {*}\n     */\n    function getValue(owner) {\n        var component = owner.component,\n            property = owner.property;\n\n        return component.get(property);\n    }\n\n    /**\n     * Format provided params to object.\n     *\n     * @param {String} ownerComponent\n     * @param {String} targetComponent\n     * @param {String} ownerProp\n     * @param {String} targetProp\n     * @param {String} direction\n     * @returns {Object}\n     */\n    function form(ownerComponent, targetComponent, ownerProp, targetProp, direction) {\n        var result,\n            tmp;\n\n        result = {\n            owner: {\n                component: ownerComponent,\n                property: ownerProp\n            },\n            target: {\n                component: targetComponent,\n                property: targetProp\n            }\n        };\n\n        if (direction === 'exports') {\n            tmp = result.owner;\n            result.owner = result.target;\n            result.target = tmp;\n        }\n\n        return result;\n    }\n\n    /**\n     * Set data to linked property.\n     *\n     * @param {Object} map\n     * @param {Object} data\n     */\n    function setLinked(map, data) {\n        var match;\n\n        if (!map) {\n            return;\n        }\n\n        match = _.findWhere(map, {\n            linked: false,\n            target: data.target,\n            property: data.property\n        });\n\n        if (match) {\n            match.linked = data;\n            data.linked = match;\n        }\n    }\n\n    /**\n     * Set data by direction.\n     *\n     * @param {Object} maps\n     * @param {String} property\n     * @param {Object} data\n     */\n    function setData(maps, property, data) {\n        var direction   = data.direction,\n            map         = maps[direction];\n\n        data.linked = false;\n\n        (map[property] = map[property] || []).push(data);\n\n        direction = direction === 'imports' ? 'exports' : 'imports';\n\n        setLinked(maps[direction][property], data);\n    }\n\n    /**\n     * Set links for components.\n     *\n     * @param {String} target\n     * @param {String} owner\n     * @param {Object} data\n     * @param {String} property\n     * @param {Boolean} immediate\n     */\n    function setLink(target, owner, data, property, immediate) {\n        var direction = data.direction,\n            formated = form(target, owner, data.property, property, direction),\n            callback,\n            value;\n\n        owner = formated.owner;\n        target = formated.target;\n\n        callback = updateValue.bind(null, data, owner, target);\n\n        owner.component.on(owner.property, callback, target.component.name);\n\n        if (immediate) {\n            value = getValue(owner);\n\n            if (notEmpty(value)) {\n                updateValue(data, owner, target, value);\n            }\n        }\n    }\n\n    /**\n     * Transfer data between components.\n     *\n     * @param {Object} owner\n     * @param {Object} data\n     */\n    function transfer(owner, data) {\n        var args = _.toArray(arguments);\n\n        if (data.target.substr(0, 1) === '!') {\n            data.target = data.target.substr(1);\n            data.inversionValue = true;\n        }\n\n        if (owner.name === data.target) {\n            args.unshift(owner);\n\n            setLink.apply(null, args);\n        } else {\n            registry.get(data.target, function (target) {\n                args.unshift(target);\n\n                setLink.apply(null, args);\n            });\n        }\n    }\n\n    return {\n        /**\n         * Assign listeners.\n         *\n         * @param {Object} listeners\n         * @returns {Object} Chainable\n         */\n        setListeners: function (listeners) {\n            var owner = this,\n                data;\n\n            _.each(listeners, function (callbacks, sources) {\n                sources = sources.split(' ');\n                callbacks = callbacks.split(' ');\n\n                sources.forEach(function (target) {\n                    callbacks.forEach(function (callback) {//eslint-disable-line max-nested-callbacks\n                        data = parseData(owner.name, target, 'imports');\n\n                        if (data) {\n                            setData(owner.maps, callback, data);\n                            transfer(owner, data, callback);\n                        }\n                    });\n                });\n            });\n\n            return this;\n        },\n\n        /**\n         * Set links in provided direction.\n         *\n         * @param {Object} links\n         * @param {String} direction\n         * @returns {Object} Chainable\n         */\n        setLinks: function (links, direction) {\n            var owner = this,\n                property,\n                data;\n\n            for (property in links) {\n                if (links.hasOwnProperty(property)) {\n                    data = parseData(owner.name, links[property], direction);\n\n                    if (data) {//eslint-disable-line max-depth\n                        setData(owner.maps, property, data);\n                        transfer(owner, data, property, true);\n                    }\n                }\n            }\n\n            return this;\n        }\n    };\n});\n","Magento_Ui/js/lib/core/storage/local.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiEvents'\n], function (_, registry, utils, EventsBus) {\n    'use strict';\n\n    var root = 'appData',\n        localStorage,\n        hasSupport,\n        storage;\n\n    /**\n     * Flag which indicates whether localStorage is supported.\n     */\n    hasSupport = (function () {\n        var key = '_storageSupported';\n\n        try {\n            localStorage = window.localStorage;\n            localStorage.setItem(key, 'true');\n\n            if (localStorage.getItem(key) === 'true') {\n                localStorage.removeItem(key);\n\n                return true;\n            }\n\n            return false;\n        } catch (e) {\n            return false;\n        }\n    })();\n\n    if (!hasSupport) {\n        localStorage = {\n            _data: {},\n\n            /**\n             * Sets value of the specified item.\n             *\n             * @param {String} key - Key of the property.\n             * @param {*} value - Properties' value.\n             */\n            setItem: function (key, value) {\n                this._data[key] = value + '';\n            },\n\n            /**\n             * Retrieves specified item.\n             *\n             * @param {String} key - Key of the property to be retrieved.\n             */\n            getItem: function (key) {\n                return this._data[key];\n            },\n\n            /**\n             * Removes specified item.\n             *\n             * @param {String} key - Key of the property to be removed.\n             */\n            removeItem: function (key) {\n                delete this._data[key];\n            },\n\n            /**\n             * Removes all items.\n             */\n            clear: function () {\n                this._data = {};\n            }\n        };\n    }\n\n    /**\n     * Extracts and parses data stored in localStorage by the\n     * key specified in 'root' variable.\n     *\n     * @returns {Object}\n     */\n    function getRoot() {\n        var data = localStorage.getItem(root),\n            result = {};\n\n        if (!_.isNull(data) && typeof data != 'undefined') {\n            result = JSON.parse(data);\n        }\n\n        return result;\n    }\n\n    /**\n     * Writes provided data to the localStorage.\n     *\n     * @param {*} data - Data to be stored.\n     */\n    function setRoot(data) {\n        localStorage.setItem(root, JSON.stringify(data));\n    }\n\n    /**\n     * Provides methods to work with a localStorage\n     * as a single nested structure.\n     */\n    storage = _.extend({\n\n        /**\n         * Retrieves value of the specified property.\n         *\n         * @param {String} path - Path to the property.\n         *\n         * @example Retrieving data.\n         *      localStorage =>\n         *          'appData' => '\n         *              \"one\": {\"two\": \"three\"}\n         *          '\n         *      storage.get('one.two')\n         *      => \"three\"\n         *\n         *      storage.get('one')\n         *      => {\"two\": \"three\"}\n         */\n        get: function (path) {\n            var data = getRoot();\n\n            return utils.nested(data, path);\n        },\n\n        /**\n         * Sets specified data to the localStorage.\n         *\n         * @param {String} path - Path of the property.\n         * @param {*} value - Value of the property.\n         *\n         * @example Setting data.\n         *      storage.set('one.two', 'four');\n         *      => localStorage =>\n         *          'appData' => '\n         *              \"one\": {\"two\": \"four\"}\n         *          '\n         */\n        set: function (path, value) {\n            var data = getRoot();\n\n            utils.nested(data, path, value);\n\n            setRoot(data);\n        },\n\n        /**\n         * Removes specified data from the localStorage.\n         *\n         * @param {String} path - Path to the property that should be removed.\n         *\n         * @example Removing data.\n         *      storage.remove('one.two', 'four');\n         *      => localStorage =>\n         *          'appData' => '\n         *              \"one\": {}\n         *          '\n         */\n        remove: function (path) {\n            var data = getRoot();\n\n            utils.nestedRemove(data, path);\n\n            setRoot(data);\n        }\n    }, EventsBus);\n\n    registry.set('localStorage', storage);\n\n    return storage;\n});\n","Magento_Ui/js/lib/knockout/bootstrap.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/** Loads all available knockout bindings, sets custom template engine, initializes knockout on page */\n\ndefine([\n    'ko',\n    './template/engine',\n    'knockoutjs/knockout-es5',\n    './bindings/bootstrap',\n    './extender/observable_array',\n    './extender/bound-nodes',\n    'domReady!'\n], function (ko, templateEngine) {\n    'use strict';\n\n    ko.uid = 0;\n\n    ko.setTemplateEngine(templateEngine);\n    ko.applyBindings();\n});\n","Magento_Ui/js/lib/knockout/bindings/after-render.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    '../template/renderer'\n], function (ko, renderer) {\n    'use strict';\n\n    ko.bindingHandlers.afterRender = {\n\n        /**\n         * Binding init callback.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel) {\n            var callback = valueAccessor();\n\n            if (typeof callback === 'function') {\n                callback.call(viewModel, element, viewModel);\n            }\n        }\n    };\n\n    renderer.addAttribute('afterRender');\n});\n","Magento_Ui/js/lib/knockout/bindings/autoselect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    '../template/renderer'\n], function (ko, $, renderer) {\n    'use strict';\n\n    /**\n     * 'Focus' event handler.\n     *\n     * @param {EventObject} e\n     */\n    function onFocus(e) {\n        e.target.select();\n    }\n\n    ko.bindingHandlers.autoselect = {\n\n        /**\n         * Adds event handler which automatically\n         * selects inputs' element text when field gets focused.\n         */\n        init: function (element, valueAccessor) {\n            var enabled = ko.unwrap(valueAccessor());\n\n            if (enabled !== false) {\n                $(element).on('focus', onFocus);\n            }\n        }\n    };\n\n    renderer.addAttribute('autoselect');\n});\n","Magento_Ui/js/lib/knockout/bindings/bind-html.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'mage/apply/main',\n    '../template/renderer'\n], function (ko, _, mage, renderer) {\n    'use strict';\n\n    /**\n     * Set html to node element.\n     *\n     * @param {HTMLElement} el - Element to apply bindings to.\n     * @param {Function} html - Observable html content.\n     */\n    function setHtml(el, html) {\n        ko.utils.emptyDomNode(el);\n        html = ko.utils.unwrapObservable(html);\n\n        if (!_.isNull(html) && !_.isUndefined(html)) {\n            if (!_.isString(html)) {\n                html = html.toString();\n            }\n\n            el.innerHTML = html;\n        }\n    }\n\n    /**\n     * Apply bindings and call magento attributes parser.\n     *\n     * @param {HTMLElement} el - Element to apply bindings to.\n     * @param {ko.bindingContext} ctx - Instance of ko.bindingContext, passed to binding initially.\n     */\n    function applyComponents(el, ctx) {\n        ko.utils.arrayForEach(el.childNodes, ko.cleanNode);\n        ko.applyBindingsToDescendants(ctx, el);\n        mage.apply();\n    }\n\n    ko.bindingHandlers.bindHtml = {\n        /**\n         * Scope binding's init method.\n         *\n         * @returns {Object} - Knockout declaration for it to let binding control descendants.\n         */\n        init: function () {\n            return {\n                controlsDescendantBindings: true\n            };\n        },\n\n        /**\n         * Reads params passed to binding.\n         * Set html to node element, apply bindings and call magento attributes parser.\n         *\n         * @param {HTMLElement} el - Element to apply bindings to.\n         * @param {Function} valueAccessor - Function that returns value, passed to binding.\n         * @param {Object} allBindings - Object, which represents all bindings applied to element.\n         * @param {Object} viewModel - Object, which represents view model binded to el.\n         * @param {ko.bindingContext} bindingContext - Instance of ko.bindingContext, passed to binding initially.\n         */\n        update: function (el, valueAccessor, allBindings, viewModel, bindingContext) {\n            setHtml(el, valueAccessor());\n            applyComponents(el, bindingContext);\n        }\n    };\n\n    renderer.addAttribute('bindHtml');\n});\n","Magento_Ui/js/lib/knockout/bindings/bootstrap.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function (require) {\n    'use strict';\n\n    var renderer = require('../template/renderer');\n\n    renderer.addAttribute('repeat', renderer.handlers.wrapAttribute);\n\n    renderer.addAttribute('outerfasteach', {\n        binding: 'fastForEach',\n        handler: renderer.handlers.wrapAttribute\n    });\n\n    renderer\n        .addNode('repeat')\n        .addNode('fastForEach');\n\n    return {\n        resizable:      require('./resizable'),\n        i18n:           require('./i18n'),\n        scope:          require('./scope'),\n        range:          require('./range'),\n        mageInit:       require('./mage-init'),\n        keyboard:       require('./keyboard'),\n        optgroup:       require('./optgroup'),\n        afterRender:     require('./after-render'),\n        autoselect:     require('./autoselect'),\n        datepicker:     require('./datepicker'),\n        outerClick:     require('./outer_click'),\n        fadeVisible:    require('./fadeVisible'),\n        collapsible:    require('./collapsible'),\n        staticChecked:  require('./staticChecked'),\n        simpleChecked:  require('./simple-checked'),\n        bindHtml:       require('./bind-html'),\n        tooltip:        require('./tooltip'),\n        repeat:         require('knockoutjs/knockout-repeat'),\n        fastForEach:    require('knockoutjs/knockout-fast-foreach'),\n        colorPicker:    require('./color-picker')\n    };\n});\n","Magento_Ui/js/lib/knockout/bindings/collapsible.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    '../template/renderer'\n], function (ko, $, _, renderer) {\n    'use strict';\n\n    var collapsible,\n        defaults;\n\n    defaults = {\n        closeOnOuter: true,\n        onTarget: false,\n        openClass: '_active',\n        as: '$collapsible'\n    };\n\n    collapsible = {\n\n        /**\n         * Sets 'opened' property to true.\n         */\n        open: function () {\n            this.opened(true);\n        },\n\n        /**\n         * Sets 'opened' property to false.\n         */\n        close: function () {\n            this.opened(false);\n        },\n\n        /**\n         * Toggles value of the 'opened' property.\n         */\n        toggle: function () {\n            this.opened(!this.opened());\n        }\n    };\n\n    /**\n     * Document click handler which in case if event target is not\n     * a descendant of provided container element, closes collapsible model.\n     *\n     * @param {HTMLElement} container\n     * @param {Object} model\n     * @param {EventObject} e\n     */\n    function onOuterClick(container, model, e) {\n        var target = e.target;\n\n        if (target !== container && !container.contains(target)) {\n            model.close();\n        }\n    }\n\n    /**\n     * Creates 'css' binding which toggles\n     * class specified in 'name' parameter.\n     *\n     * @param {Object} model\n     * @param {String} name\n     * @returns {Object}\n     */\n    function getClassBinding(model, name) {\n        var binding = {};\n\n        binding[name] = model.opened;\n\n        return {\n            css: binding\n        };\n    }\n\n    /**\n     * Prepares configuration for the binding based\n     * on a default properties and provided options.\n     *\n     * @param {Object} [options={}]\n     * @returns {Object} Complete instance configuration.\n     */\n    function buildConfig(options) {\n        if (typeof options !== 'object') {\n            options = {};\n        }\n\n        return _.extend({}, defaults, options);\n    }\n\n    ko.bindingHandlers.collapsible = {\n\n        /**\n         * Initializes 'collapsible' binding.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var $collapsible = Object.create(collapsible),\n                config = buildConfig(valueAccessor()),\n                outerClick,\n                bindings;\n\n            _.bindAll($collapsible, 'open', 'close', 'toggle');\n\n            $collapsible.opened = ko.observable(!!config.opened);\n\n            bindingCtx[config.as] = $collapsible;\n\n            if (config.closeOnOuter) {\n                outerClick = onOuterClick.bind(null, element, $collapsible);\n\n                $(document).on('click', outerClick);\n\n                ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n                    $(document).off('click', outerClick);\n                });\n            }\n\n            if (config.openClass) {\n                bindings = getClassBinding($collapsible, config.openClass);\n\n                ko.applyBindingsToNode(element, bindings, bindingCtx);\n            }\n\n            if (config.onTarget) {\n                $(element).on('click', $collapsible.toggle);\n            }\n\n            if (viewModel && _.isFunction(viewModel.on)) {\n                viewModel.on({\n                    close:          $collapsible.close,\n                    open:           $collapsible.open,\n                    toggleOpened:   $collapsible.toggle\n                });\n            }\n        }\n    };\n\n    ko.bindingHandlers.closeCollapsible = {\n\n        /**\n         * Creates listener for the click event on provided DOM element,\n         * which closes associated with it collapsible model.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var name = valueAccessor() || defaults.as,\n                $collapsible = bindingCtx[name];\n\n            if ($collapsible) {\n                $(element).on('click', $collapsible.close);\n            }\n        }\n    };\n\n    ko.bindingHandlers.openCollapsible = {\n\n        /**\n         * Creates listener for the click event on provided DOM element,\n         * which opens associated with it collapsible model.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var name = valueAccessor() || defaults.as,\n                $collapsible = bindingCtx[name];\n\n            if ($collapsible) {\n                $(element).on('click', $collapsible.open);\n            }\n        }\n    };\n\n    ko.bindingHandlers.toggleCollapsible = {\n\n        /**\n         * Creates listener for the click event on provided DOM element,\n         * which toggles associated with it collapsible model.\n         */\n        init: function (element, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var name = valueAccessor() || defaults.as,\n                $collapsible = bindingCtx[name];\n\n            if ($collapsible) {\n                $(element).on('click', $collapsible.toggle);\n            }\n        }\n    };\n\n    renderer\n        .addAttribute('collapsible')\n        .addAttribute('openCollapsible')\n        .addAttribute('closeCollapsible')\n        .addAttribute('toggleCollapsible');\n});\n","Magento_Ui/js/lib/knockout/bindings/color-picker.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    '../template/renderer',\n    'spectrum',\n    'tinycolor'\n], function (ko, $, renderer, spectrum, tinycolor) {\n    'use strict';\n\n    /**\n     * Change color picker status to be enabled or disabled\n     *\n     * @param {HTMLElement} element - Element to apply colorpicker enable/disable status to.\n     * @param {Object} viewModel - Object, which represents view model binded to el.\n     */\n    function changeColorPickerStateBasedOnViewModel(element, viewModel) {\n        $(element).spectrum(viewModel.disabled() ? 'disable' : 'enable');\n    }\n\n    ko.bindingHandlers.colorPicker = {\n        /**\n         * Binding init callback.\n         *\n         * @param {*} element\n         * @param {Function} valueAccessor\n         * @param {Function} allBindings\n         * @param {Object} viewModel\n         */\n        init: function (element, valueAccessor, allBindings, viewModel) {\n            var config = valueAccessor(),\n\n                /** change value */\n                changeValue = function (value) {\n                    if (value == null) {\n                        value = '';\n                    }\n                    config.value(value.toString());\n                };\n\n            config.change = changeValue;\n\n            config.hide = changeValue;\n\n            /** show value */\n            config.show = function () {\n                if (!viewModel.focused()) {\n                    viewModel.focused(true);\n                }\n\n                return true;\n            };\n\n            $(element).spectrum(config);\n\n            changeColorPickerStateBasedOnViewModel(element, viewModel);\n        },\n\n        /**\n         * Reads params passed to binding, parses component declarations.\n         * Fetches for those found and attaches them to the new context.\n         *\n         * @param {HTMLElement} element - Element to apply bindings to.\n         * @param {Function} valueAccessor - Function that returns value, passed to binding.\n         * @param {Object} allBindings - Object, which represents all bindings applied to element.\n         * @param {Object} viewModel - Object, which represents view model binded to element.\n         */\n        update: function (element, valueAccessor, allBindings, viewModel) {\n            var config = valueAccessor();\n\n            /** Initialise value as empty if it is undefined when color picker input is reset **/\n            if (config.value() === undefined) {\n                config.value('');\n            }\n\n            if (tinycolor(config.value()).isValid() || config.value() === '') {\n                $(element).spectrum('set', config.value());\n\n                if (config.value() !== '') {\n                    config.value($(element).spectrum('get').toString());\n                }\n            }\n\n            changeColorPickerStateBasedOnViewModel(element, viewModel);\n        }\n    };\n\n    renderer.addAttribute('colorPicker');\n});\n","Magento_Ui/js/lib/knockout/bindings/datepicker.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/** Creates datepicker binding and registers in to ko.bindingHandlers object */\ndefine([\n    'ko',\n    'underscore',\n    'jquery',\n    'mage/translate'\n], function (ko, _, $, $t) {\n    'use strict';\n\n    var defaults = {\n        dateFormat: 'mm\\/dd\\/yyyy',\n        showsTime: false,\n        timeFormat: null,\n        buttonImage: null,\n        buttonImageOnly: null,\n        buttonText: $t('Select Date')\n    };\n\n    ko.bindingHandlers.datepicker = {\n        /**\n         * Initializes calendar widget on element and stores it's value to observable property.\n         * Datepicker binding takes either observable property or object\n         *  { storage: {ko.observable}, options: {Object} }.\n         * For more info about options take a look at \"mage/calendar\" and jquery.ui.datepicker widget.\n         * @param {HTMLElement} el - Element, that binding is applied to\n         * @param {Function} valueAccessor - Function that returns value, passed to binding\n         * @param {object} allBindings\n         * @param {object} viewModel\n         * @param {object} bindingContext\n         */\n        init: function (el, valueAccessor, allBindings, viewModel, bindingContext) {\n            var config = valueAccessor(),\n                observable,\n                options = {};\n\n            _.extend(options, defaults);\n\n            if (typeof config === 'object') {\n                observable = config.storage;\n                _.extend(options, config.options);\n            } else {\n                observable = config;\n            }\n\n            require(['mage/calendar'], function () {\n                $(el).calendar(options);\n\n                ko.utils.registerEventHandler(el, 'change', function () {\n                    observable(this.value);\n                });\n            });\n\n            if (bindingContext.$data) {\n                bindingContext.$data.value.subscribe(function (newVal) {\n                    if (!newVal) {\n                        $(el).val('');\n                    }\n                }, this);\n            }\n\n\n        },\n\n        /**\n         * Update calendar widget on element and stores it's value to observable property.\n         * Datepicker binding takes either observable property or object\n         *  { storage: {ko.observable}, options: {Object} }.\n         * @param {HTMLElement} element - Element, that binding is applied to\n         * @param {Function} valueAccessor - Function that returns value, passed to binding\n         */\n        update: function (element, valueAccessor) {\n            var config = valueAccessor(),\n                $element = $(element),\n                observable,\n                options = {},\n                newVal;\n\n            _.extend(options, defaults);\n\n            if (typeof config === 'object') {\n                observable = config.storage;\n                _.extend(options, config.options);\n            } else {\n                observable = config;\n            }\n\n            require(['moment', 'mage/utils/misc', 'mage/calendar'], function (moment, utils) {\n                if (_.isEmpty(observable())) {\n                    newVal = null;\n                } else {\n                    newVal = moment(\n                        observable(),\n                        utils.convertToMomentFormat(\n                            options.dateFormat + (options.showsTime ? ' ' + options.timeFormat : '')\n                        )\n                    ).toDate();\n                }\n\n                if (!options.timeOnly) {\n                    $element.datepicker('setDate', newVal);\n                    $element.trigger('blur');\n                }\n            });\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/bindings/fadeVisible.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko'\n], function ($, ko) {\n    'use strict';\n\n    ko.bindingHandlers.fadeVisible = {\n        /**\n         * Initially set the element to be instantly visible/hidden depending on the value.\n         *\n         * @param {HTMLElement} element\n         * @param {Function} valueAccessor\n         */\n        init: function (element, valueAccessor) {\n            var value = valueAccessor();\n\n            // Use \"unwrapObservable\" so we can handle values that may or may not be observable\n            $(element).toggle(ko.unwrap(value));\n        },\n\n        /**\n         * Whenever the value subsequently changes, slowly fade the element in or out.\n         *\n         * @param {HTMLElement} element\n         * @param {Function} valueAccessor\n         */\n        update: function (element, valueAccessor) {\n            var value = valueAccessor();\n\n            ko.unwrap(value) ? $(element).fadeIn() : $(element).fadeOut();\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/bindings/i18n.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'module',\n    '../template/renderer',\n    'mage/translate'\n], function ($, ko, module, renderer) {\n    'use strict';\n\n    var locations = {\n            'legend': 'Caption for the fieldset element',\n            'label': 'Label for an input element.',\n            'button': 'Push button',\n            'a': 'Link label',\n            'b': 'Bold text',\n            'strong': 'Strong emphasized text',\n            'i': 'Italic text',\n            'em': 'Emphasized text',\n            'u': 'Underlined text',\n            'sup': 'Superscript text',\n            'sub': 'Subscript text',\n            'span': 'Span element',\n            'small': 'Smaller text',\n            'big': 'Bigger text',\n            'address': 'Contact information',\n            'blockquote': 'Long quotation',\n            'q': 'Short quotation',\n            'cite': 'Citation',\n            'caption': 'Table caption',\n            'abbr': 'Abbreviated phrase',\n            'acronym': 'An acronym',\n            'var': 'Variable part of a text',\n            'dfn': 'Term',\n            'strike': 'Strikethrough text',\n            'del': 'Deleted text',\n            'ins': 'Inserted text',\n            'h1': 'Heading level 1',\n            'h2': 'Heading level 2',\n            'h3': 'Heading level 3',\n            'h4': 'Heading level 4',\n            'h5': 'Heading level 5',\n            'h6': 'Heading level 6',\n            'center': 'Centered text',\n            'select': 'List options',\n            'img': 'Image',\n            'input': 'Form element'\n        },\n\n        /**\n         * Generates [data-translate] attribute's value\n         * @param {Object} translationData\n         * @param {String} location\n         */\n        composeTranslateAttr = function (translationData, location) {\n            var obj = [{\n                'shown': translationData.shown,\n                'translated': translationData.translated,\n                'original': translationData.original,\n                'location': locations[location] || 'Text'\n            }];\n\n            return JSON.stringify(obj);\n        },\n\n        /**\n         * Sets text for the element\n         * @param {Object} el\n         * @param {String} text\n         */\n        setText = function (el, text) {\n            $(el).text(text);\n        },\n\n        /**\n         * Sets [data-translate] attribute for the element\n         * @param {Object} el - The element which is binded\n         * @param {String} original - The original value of the element\n         */\n        setTranslateProp = function (el, original) {\n            var location = $(el).prop('tagName').toLowerCase(),\n                translated = $.mage.__(original),\n                translationData = {\n                    shown: translated,\n                    translated: translated,\n                    original: original\n                },\n                translateAttr = composeTranslateAttr(translationData, location);\n\n            $(el).attr('data-translate', translateAttr);\n\n            setText(el, translationData.shown);\n        },\n\n        /**\n         * Checks if node represents ko virtual node (nodeType === 8, nodeName === '#comment').\n         *\n         * @param {HTMLElement} node\n         * @returns {Boolean}\n         */\n        isVirtualElement = function (node) {\n            return node.nodeType === 8;\n        },\n\n        /**\n        * Checks if it's real DOM element\n        * in case of virtual element, returns span wrapper\n        * @param {Object} el\n        * @param {bool} isUpdate\n        * @return {Object} el\n        */\n        getRealElement = function (el, isUpdate) {\n            if (isVirtualElement(el)) {\n                if (isUpdate) {\n                    return $(el).next('span');\n                }\n\n                return $('<span></span>').insertAfter(el);\n            }\n\n            return el;\n        },\n\n        /**\n         * execute i18n binding\n         * @param {Object} element\n         * @param {Function} valueAccessor\n         * @param {bool} isUpdate\n         */\n        execute = function (element, valueAccessor, isUpdate) {\n            var original = ko.unwrap(valueAccessor() || ''),\n                el = getRealElement(element, isUpdate),\n                inlineTranslation = (module.config() || {}).inlineTranslation;\n\n            if (inlineTranslation) {\n                setTranslateProp(el, original);\n            } else {\n                setText(el, $.mage.__(original));\n            }\n        };\n\n    /**\n     * i18n binding\n     * @property {Function}  init\n     * @property {Function}  update\n     */\n    ko.bindingHandlers.i18n = {\n\n        /**\n         * init i18n binding\n         * @param {Object} element\n         * @param {Function} valueAccessor\n         */\n        init: function (element, valueAccessor) {\n            execute(element, valueAccessor);\n        },\n\n        /**\n         * update i18n binding\n         * @param {Object} element\n         * @param {Function} valueAccessor\n         */\n        update: function (element, valueAccessor) {\n            execute(element, valueAccessor, true);\n        }\n    };\n\n    ko.virtualElements.allowedBindings.i18n = true;\n\n    renderer\n        .addNode('translate', {\n            binding: 'i18n'\n        })\n        .addAttribute('translate', {\n            binding: 'i18n'\n        });\n});\n","Magento_Ui/js/lib/knockout/bindings/keyboard.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    '../template/renderer'\n], function (ko, renderer) {\n    'use strict';\n\n    ko.bindingHandlers.keyboard = {\n\n        /**\n         * Attaches keypress handlers to element\n         * @param {HTMLElement} el - Element, that binding is applied to\n         * @param {Function} valueAccessor - Function that returns value, passed to binding\n         * @param  {Object} allBindings - all bindings object\n         * @param  {Object} viewModel - reference to viewmodel\n         */\n        init: function (el, valueAccessor, allBindings, viewModel) {\n            var map = valueAccessor();\n\n            ko.utils.registerEventHandler(el, 'keyup', function (e) {\n                var callback = map[e.keyCode];\n\n                if (callback) {\n                    return callback.call(viewModel, e);\n                }\n            });\n        }\n    };\n\n    renderer.addAttribute('keyboard');\n});\n","Magento_Ui/js/lib/knockout/bindings/mage-init.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'mage/apply/main'\n], function (ko, _, mage) {\n    'use strict';\n\n    ko.bindingHandlers.mageInit = {\n        /**\n         * Initializes components assigned to HTML elements.\n         *\n         * @param {HTMLElement} el\n         * @param {Function} valueAccessor\n         */\n        init: function (el, valueAccessor) {\n            var data = valueAccessor();\n\n            _.each(data, function (config, component) {\n                mage.applyFor(el, config, component);\n            });\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/bindings/optgroup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'mageUtils'\n    ], function (ko, utils) {\n    'use strict';\n\n    var captionPlaceholder = {},\n        optgroupTmpl = '<optgroup label=\"${ $.label }\"></optgroup>',\n        nbspRe = /&nbsp;/g,\n        optionsText,\n        optionsValue,\n        optionTitle;\n\n    ko.bindingHandlers.optgroup = {\n        /**\n         * @param {*} element\n         */\n        init: function (element) {\n            if (ko.utils.tagNameLower(element) !== 'select') {\n                throw new Error('options binding applies only to SELECT elements');\n            }\n\n            // Remove all existing <option>s.\n            while (element.length > 0) {\n                element.remove(0);\n            }\n        },\n\n        /**\n         * @param {*} element\n         * @param {*} valueAccessor\n         * @param {*} allBindings\n         */\n        update: function (element, valueAccessor, allBindings) {\n            var selectWasPreviouslyEmpty = element.length === 0,\n                previousScrollTop = !selectWasPreviouslyEmpty && element.multiple ? element.scrollTop : null,\n                includeDestroyed = allBindings.get('optionsIncludeDestroyed'),\n                arrayToDomNodeChildrenOptions = {},\n                captionValue,\n                unwrappedArray = ko.utils.unwrapObservable(valueAccessor()),\n                filteredArray,\n                previousSelectedValues,\n                itemUpdate = false,\n                callback = setSelectionCallback,//eslint-disable-line no-use-before-define\n                nestedOptionsLevel = -1;\n\n            optionsText = ko.utils.unwrapObservable(allBindings.get('optionsText')) || 'text';\n            optionsValue = ko.utils.unwrapObservable(allBindings.get('optionsValue')) || 'value';\n            optionTitle = optionsText + 'title';\n\n            if (element.multiple) {\n                previousSelectedValues = ko.utils.arrayMap(\n                    selectedOptions(),//eslint-disable-line no-use-before-define\n                    ko.selectExtensions.readValue\n                );\n            } else {\n                previousSelectedValues = element.selectedIndex >= 0 ?\n                    [ko.selectExtensions.readValue(element.options[element.selectedIndex])] :\n                    [];\n            }\n\n            if (unwrappedArray) {\n                if (typeof unwrappedArray.length === 'undefined') { // Coerce single value into array\n                    unwrappedArray = [unwrappedArray];\n                }\n\n                // Filter out any entries marked as destroyed\n                filteredArray = ko.utils.arrayFilter(unwrappedArray, function (item) {\n                    if (item && !item.label) {\n                        return false;\n                    }\n\n                    return includeDestroyed ||\n                        item === undefined ||\n                        item === null ||\n                        !ko.utils.unwrapObservable(item._destroy);\n                });\n                filteredArray.map(recursivePathBuilder, null);//eslint-disable-line no-use-before-define\n            }\n\n            /**\n             * @param {*} option\n             */\n            arrayToDomNodeChildrenOptions.beforeRemove = function (option) {\n                element.removeChild(option);\n            };\n\n            if (allBindings.has('optionsAfterRender')) {\n\n                /**\n                 * @param {*} arrayEntry\n                 * @param {*} newOptions\n                 */\n                callback = function (arrayEntry, newOptions) {\n                    setSelectionCallback(arrayEntry, newOptions);//eslint-disable-line no-use-before-define\n                    ko.dependencyDetection.ignore(\n                        allBindings.get('optionsAfterRender'),\n                        null,\n                        [newOptions[0],\n                        arrayEntry !== captionPlaceholder ? arrayEntry : undefined]\n                    );\n                };\n            }\n\n            filteredArray = formatOptions(filteredArray);//eslint-disable-line no-use-before-define\n            ko.utils.setDomNodeChildrenFromArrayMapping(\n                element,\n                filteredArray,\n                optionNodeFromArray,//eslint-disable-line no-use-before-define\n                arrayToDomNodeChildrenOptions,\n                callback\n            );\n\n            ko.dependencyDetection.ignore(function () {\n                var selectionChanged;\n\n                if (allBindings.get('valueAllowUnset') && allBindings.has('value')) {\n                    // The model value is authoritative, so make sure its value is the one selected\n                    ko.selectExtensions.writeValue(\n                        element,\n                        ko.utils.unwrapObservable(allBindings.get('value')),\n                        true /* allowUnset */\n                    );\n                } else {\n                    // Determine if the selection has changed as a result of updating the options list\n                    if (element.multiple) {\n                        // For a multiple-select box, compare the new selection count to the previous one\n                        // But if nothing was selected before, the selection can't have changed\n                        selectionChanged = previousSelectedValues.length &&\n                            selectedOptions().length < //eslint-disable-line no-use-before-define\n                            previousSelectedValues.length;\n                    } else {\n                        // For a single-select box, compare the current value to the previous value\n                        // But if nothing was selected before or nothing is selected now,\n                        // just look for a change in selection\n                        selectionChanged = previousSelectedValues.length && element.selectedIndex >= 0 ?\n                            ko.selectExtensions.readValue(element.options[element.selectedIndex]) !==\n                            previousSelectedValues[0] : previousSelectedValues.length || element.selectedIndex >= 0;\n                    }\n\n                    // Ensure consistency between model value and selected option.\n                    // If the dropdown was changed so that selection is no longer the same,\n                    // notify the value or selectedOptions binding.\n                    if (selectionChanged) {\n                        ko.utils.triggerEvent(element, 'change');\n                    }\n                }\n            });\n\n            /*eslint-enable max-len, no-use-before-define*/\n\n            if (previousScrollTop && Math.abs(previousScrollTop - element.scrollTop) > 20) {\n                element.scrollTop = previousScrollTop;\n            }\n\n            /**\n             * @returns {*}\n             */\n            function selectedOptions() {\n                return ko.utils.arrayFilter(element.options, function (node) {\n                    return node.selected;\n                });\n            }\n\n            /**\n             * @param {*} object\n             * @param {*} predicate\n             * @param {*} defaultValue\n             * @returns {*}\n             */\n            function applyToObject(object, predicate, defaultValue) {\n                var predicateType = typeof predicate;\n\n                if (predicateType === 'function') {   // run it against the data value\n                    return predicate(object);\n                } else if (predicateType === 'string') { // treat it as a property name on the data value\n                    return object[predicate];\n                }\n\n                return defaultValue;\n            }\n\n            /**\n             * @param {*} obj\n             */\n            function recursivePathBuilder(obj) {\n\n                obj[optionTitle] = (this && this[optionTitle] ? this[optionTitle] + '/' : '') + obj[optionsText].trim();\n\n                if (Array.isArray(obj[optionsValue])) {\n                    obj[optionsValue].map(recursivePathBuilder, obj);\n                }\n            }\n\n            /**\n             * @param {Array} arrayEntry\n             * @param {*} oldOptions\n             * @returns {*[]}\n             */\n            function optionNodeFromArray(arrayEntry, oldOptions) {\n                var option;\n\n                if (oldOptions.length) {\n                    previousSelectedValues = oldOptions[0].selected ?\n                        [ko.selectExtensions.readValue(oldOptions[0])] : [];\n                    itemUpdate = true;\n                }\n\n                if (arrayEntry === captionPlaceholder) { // empty value, label === caption\n                    option = element.ownerDocument.createElement('option');\n                    ko.utils.setTextContent(option, allBindings.get('optionsCaption'));\n                    ko.selectExtensions.writeValue(option, undefined);\n                } else if (typeof arrayEntry[optionsValue] === 'undefined') { // empty value === optgroup\n                    if (arrayEntry.__disableTmpl) {\n                        option = '<optgroup label=\"' + arrayEntry[optionsText] + '\"></optgroup>';\n                    } else {\n                        option = utils.template(optgroupTmpl, {\n                            label: arrayEntry[optionsText],\n                            title: arrayEntry[optionsText + 'title']\n                        });\n                    }\n                    option = ko.utils.parseHtmlFragment(option)[0];\n\n                } else {\n                    option = element.ownerDocument.createElement('option');\n                    option.setAttribute('data-title', arrayEntry[optionsText + 'title']);\n                    ko.selectExtensions.writeValue(option, arrayEntry[optionsValue]);\n                    ko.utils.setTextContent(option, arrayEntry[optionsText]);\n                }\n\n                return [option];\n            }\n\n            /**\n             * @param {*} newOptions\n             */\n            function setSelectionCallback(newOptions) {\n                var isSelected;\n\n                // IE6 doesn't like us to assign selection to OPTION nodes before they're added to the document.\n                // That's why we first added them without selection. Now it's time to set the selection.\n                if (previousSelectedValues.length && newOptions.value) {\n                    isSelected = ko.utils.arrayIndexOf(\n                        previousSelectedValues,\n                        ko.selectExtensions.readValue(newOptions.value)\n                    ) >= 0;\n\n                    ko.utils.setOptionNodeSelectionState(newOptions.value, isSelected);\n\n                    // If this option was changed from being selected during a single-item update, notify the change\n                    if (itemUpdate && !isSelected) {\n                        ko.dependencyDetection.ignore(ko.utils.triggerEvent, null, [element, 'change']);\n                    }\n                }\n            }\n\n            /**\n             * @param {*} string\n             * @param {Number} times\n             * @returns {Array}\n             */\n            function strPad(string, times) {\n                return new Array(times + 1).join(string);\n            }\n\n            /**\n             * @param {*} options\n             * @returns {Array}\n             */\n            function formatOptions(options) {\n                var res = [];\n\n                nestedOptionsLevel++;\n\n                if (!nestedOptionsLevel) { // zero level\n                    // If caption is included, add it to the array\n                    if (allBindings.has('optionsCaption')) {\n                        captionValue = ko.utils.unwrapObservable(allBindings.get('optionsCaption'));\n                        // If caption value is null or undefined, don't show a caption\n                        if (//eslint-disable-line max-depth\n                            captionValue !== null &&\n                            captionValue !== undefined &&\n                            captionValue !== false\n                        ) {\n                            res.push(captionPlaceholder);\n                        }\n                    }\n                }\n\n                ko.utils.arrayForEach(options, function (option) {\n                    var value = applyToObject(option, optionsValue, option),\n                        label = applyToObject(option, optionsText, value) || '',\n                        disabled = applyToObject(option, 'disabled', false) || false,\n                        obj = {},\n                        space = '\\u2007\\u2007\\u2007';\n\n                    obj[optionTitle] = applyToObject(option, optionsText + 'title', value);\n\n                    if (disabled) {\n                        obj.disabled = disabled;\n                    }\n\n                    if (option.hasOwnProperty('__disableTmpl')) {\n                        obj.__disableTmpl = option.__disableTmpl;\n                    }\n\n                    label = label.replace(nbspRe, '').trim();\n\n                    if (Array.isArray(value)) {\n                        obj[optionsText] = strPad('&nbsp;', nestedOptionsLevel * 4) + label;\n                        res.push(obj);\n                        res = res.concat(formatOptions(value));\n                    } else {\n                        obj[optionsText] = strPad(space, nestedOptionsLevel * 2) + label;\n                        obj[optionsValue] = value;\n                        res.push(obj);\n                    }\n                });\n                nestedOptionsLevel--;\n\n                return res;\n            }\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/bindings/outer_click.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/** Creates outerClick binding and registers in to ko.bindingHandlers object */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    '../template/renderer'\n], function (ko, $, _, renderer) {\n    'use strict';\n\n    var defaults = {\n        onlyIfVisible: true\n    };\n\n    /**\n     * Checks if element sis visible.\n     *\n     * @param {Element} el\n     * @returns {Boolean}\n     */\n    function isVisible(el) {\n        var style = window.getComputedStyle(el),\n            visibility = {\n                display: 'none',\n                visibility: 'hidden',\n                opacity: '0'\n            },\n            visible = true;\n\n        _.each(visibility, function (val, key) {\n            if (style[key] === val) {\n                visible = false;\n            }\n        });\n\n        return visible;\n    }\n\n    /**\n     * Document click handler which in case if event target is not\n     * a descendant of provided container element,\n     * invokes specified in configuration callback.\n     *\n     * @param {HTMLElement} container\n     * @param {Object} config\n     * @param {EventObject} e\n     */\n    function onOuterClick(container, config, e) {\n        var target = e.target,\n            callback = config.callback;\n\n        if (container === target || container.contains(target)) {\n            return;\n        }\n\n        if (config.onlyIfVisible) {\n            if (!_.isNull(container.offsetParent) && isVisible(container)) {\n                callback();\n            }\n        } else {\n            callback();\n        }\n    }\n\n    /**\n     * Prepares configuration for the binding based\n     * on a default properties and provided options.\n     *\n     * @param {(Object|Function)} [options={}]\n     * @returns {Object}\n     */\n    function buildConfig(options) {\n        var config = {};\n\n        if (_.isFunction(options)) {\n            options = {\n                callback: options\n            };\n        } else if (!_.isObject(options)) {\n            options = {};\n        }\n\n        return _.extend(config, defaults, options);\n    }\n\n    ko.bindingHandlers.outerClick = {\n\n        /**\n         * Initializes outer click binding.\n         */\n        init: function (element, valueAccessor) {\n            var config = buildConfig(valueAccessor()),\n                outerClick = onOuterClick.bind(null, element, config),\n                isTouchDevice = typeof document.ontouchstart !== 'undefined';\n\n            if (isTouchDevice) {\n                $(document).on('touchstart', outerClick);\n\n                ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n                    $(document).off('touchstart', outerClick);\n                });\n            } else {\n                $(document).on('click', outerClick);\n\n                ko.utils.domNodeDisposal.addDisposeCallback(element, function () {\n                    $(document).off('click', outerClick);\n                });\n            }\n        }\n    };\n\n    renderer.addAttribute('outerClick');\n});\n","Magento_Ui/js/lib/knockout/bindings/range.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    '../template/renderer'\n], function (ko, $, _, renderer) {\n    'use strict';\n\n    var isTouchDevice = !_.isUndefined(document.ontouchstart),\n        sliderFn = 'slider',\n        sliderModule = 'jquery-ui-modules/slider';\n\n    if (isTouchDevice) {\n        sliderFn = 'touchSlider';\n        sliderModule = 'mage/touch-slider';\n    }\n\n    ko.bindingHandlers.range = {\n\n        /**\n         * Initializes binding and a slider update.\n         *\n         * @param {HTMLElement} element\n         * @param {Function} valueAccessor\n         */\n        init: function (element, valueAccessor) {\n            var config  = valueAccessor(),\n                value   = config.value;\n\n            _.extend(config, {\n                value: value(),\n\n                /**\n                 * Callback which is being called when sliders' value changes.\n                 *\n                 * @param {Event} event\n                 * @param {Object} ui\n                 */\n                slide: function (event, ui) {\n                    value(ui.value);\n                }\n            });\n\n            require([sliderModule], function () {\n                $(element)[sliderFn](config);\n            });\n        },\n\n        /**\n         * Updates sliders' plugin configuration.\n         *\n         * @param {HTMLElement} element\n         * @param {Function} valueAccessor\n         */\n        update: function (element, valueAccessor) {\n            var config = valueAccessor();\n\n            config.value = ko.unwrap(config.value);\n\n            require([sliderModule], function () {\n                $(element)[sliderFn]('option', config);\n            });\n        }\n    };\n\n    renderer.addAttribute('range');\n});\n","Magento_Ui/js/lib/knockout/bindings/resizable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'Magento_Ui/js/lib/view/utils/async',\n    'uiRegistry',\n    'underscore',\n    '../template/renderer'\n], function (ko, $, async, registry, _, renderer) {\n    'use strict';\n\n    var sizeOptions = [\n            'minHeight',\n            'maxHeight',\n            'minWidth',\n            'maxWidth'\n        ],\n\n        handles = {\n            height: '.ui-resizable-s, .ui-resizable-n',\n            width: '.ui-resizable-w, .ui-resizable-e'\n        };\n\n    /**\n     * Recalcs visibility of handles, width and height of resizable based on content\n     * @param {HTMLElement} element\n     */\n    function adjustSize(element) {\n        var maxHeight,\n            maxWidth;\n\n        element = $(element);\n        maxHeight = element.resizable('option').maxHeight;\n        maxWidth = element.resizable('option').maxWidth;\n\n        if (maxHeight && element.height() > maxHeight) {\n            element.height(maxHeight + 1);\n            $(handles.height).hide();\n        } else {\n            $(handles.height).show();\n        }\n\n        if (maxWidth && element.width() > maxWidth) {\n            element.width(maxWidth + 1);\n            $(handles.width).hide();\n        } else {\n            $(handles.width).show();\n        }\n    }\n\n    /**\n     * Recalcs allowed min, max width and height based on configured selectors\n     * @param {Object} sizeConstraints\n     * @param {String} componentName\n     * @param {HTMLElement} element\n     * @param {Boolean} hasWidthUpdate\n     */\n    function recalcAllowedSize(sizeConstraints, componentName, element, hasWidthUpdate) {\n        var size;\n\n        element = $(element);\n\n        if (!element.data('resizable')) {\n            return;\n        }\n\n        if (!hasWidthUpdate) {\n            element.css('width', 'auto');\n        }\n\n        _.each(sizeConstraints, function (selector, key) {\n            async.async({\n                component: componentName,\n                selector: selector\n            }, function (elem) {\n                size = key.indexOf('Height') !== -1 ? $(elem).outerHeight(true) : $(elem).outerWidth(true);\n\n                if (element.data('resizable')) {\n                    element.resizable('option', key, size + 1);\n                }\n            });\n        }, this);\n\n        adjustSize(element);\n    }\n\n    /**\n     * Preprocess config to separate options,\n     * which must be processed further before applying\n     *\n     * @param {Object} config\n     * @param {Object} viewModel\n     * @param {*} element\n     * @return {Object} config\n     */\n    function processConfig(config, viewModel, element) {\n        var sizeConstraint,\n            sizeConstraints = {},\n            recalc,\n            hasWidthUpdate;\n\n        if (_.isEmpty(config)) {\n            return {};\n        }\n        _.each(sizeOptions, function (key) {\n            sizeConstraint = config[key];\n\n            if (sizeConstraint && !_.isNumber(sizeConstraint)) {\n                sizeConstraints[key] = sizeConstraint;\n                delete config[key];\n            }\n        });\n        hasWidthUpdate =  _.some(sizeConstraints, function (value, key) {\n            return key.indexOf('Width') !== -1;\n        });\n\n        recalc = recalcAllowedSize.bind(null, sizeConstraints, viewModel.name, element, hasWidthUpdate);\n        config.start = recalc;\n        $(window).on('resize.resizable', recalc);\n        registry.get(viewModel.provider).on('reloaded', recalc);\n\n        return config;\n    }\n\n    ko.bindingHandlers.resizable = {\n\n        /**\n         * Binding init callback.\n         *\n         * @param {*} element\n         * @param {Function} valueAccessor\n         * @param {Function} allBindings\n         * @param {Object} viewModel\n         */\n        init: function (element, valueAccessor, allBindings, viewModel) {\n            var config = processConfig(valueAccessor(), viewModel, element);\n\n            require(['jquery-ui-modules/resizable'], function () {\n                if ($.fn.resizable) {\n                    $(element).resizable(config);\n                }\n            });\n        }\n    };\n\n    renderer.addAttribute('resizable');\n});\n","Magento_Ui/js/lib/knockout/bindings/scope.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/** Creates scope binding and registers in to ko.bindingHandlers object */\ndefine([\n    'ko',\n    'uiRegistry',\n    'mage/translate',\n    '../template/renderer',\n    'jquery',\n    '../../logger/console-logger'\n], function (ko, registry, $t, renderer, $, consoleLogger) {\n    'use strict';\n\n    /**\n     * Creates child context with passed component param as $data. Extends context with $t helper.\n     * Applies bindings to descendant nodes.\n     * @param {HTMLElement} el - element to apply bindings to.\n     * @param {ko.bindingContext} bindingContext - instance of ko.bindingContext, passed to binding initially.\n     * @param {Promise} promise - instance of jQuery promise\n     * @param {Object} component - component instance to attach to new context\n     */\n    function applyComponents(el, bindingContext, promise, component) {\n        promise.resolve();\n        component = bindingContext.createChildContext(component);\n\n        ko.utils.extend(component, {\n            $t: $t\n        });\n\n        ko.utils.arrayForEach(ko.virtualElements.childNodes(el), ko.cleanNode);\n\n        ko.applyBindingsToDescendants(component, el);\n    }\n\n    ko.bindingHandlers.scope = {\n\n        /**\n         * Scope binding's init method.\n         * @returns {Object} - Knockout declaration for it to let binding control descendants.\n         */\n        init: function () {\n            return {\n                controlsDescendantBindings: true\n            };\n        },\n\n        /**\n         * Reads params passed to binding, parses component declarations.\n         * Fetches for those found and attaches them to the new context.\n         * @param {HTMLElement} el - Element to apply bindings to.\n         * @param {Function} valueAccessor - Function that returns value, passed to binding.\n         * @param {Object} allBindings - Object, which represents all bindings applied to element.\n         * @param {Object} viewModel - Object, which represents view model binded to el.\n         * @param {ko.bindingContext} bindingContext - Instance of ko.bindingContext, passed to binding initially.\n         */\n        update: function (el, valueAccessor, allBindings, viewModel, bindingContext) {\n            var component = valueAccessor(),\n                promise = $.Deferred(),\n                apply = applyComponents.bind(this, el, bindingContext, promise),\n                loggerUtils = consoleLogger.utils;\n\n            if (typeof component === 'string') {\n                loggerUtils.asyncLog(\n                    promise,\n                    {\n                        data: {\n                            component: component\n                        },\n                        messages: loggerUtils.createMessages(\n                            'requestingComponent',\n                            'requestingComponentIsLoaded',\n                            'requestingComponentIsFailed'\n                        )\n                    }\n                );\n\n                registry.get(component, apply);\n            } else if (typeof component === 'function') {\n                component(apply);\n            }\n        }\n    };\n\n    ko.virtualElements.allowedBindings.scope = true;\n\n    renderer\n        .addNode('scope')\n        .addAttribute('scope', {\n            name: 'ko-scope'\n        });\n});\n","Magento_Ui/js/lib/knockout/bindings/simple-checked.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    '../template/renderer'\n], function (ko, renderer) {\n    'use strict';\n\n    ko.bindingHandlers.simpleChecked = {\n        'after': ['attr'],\n\n        /**\n         * Implements same functionality as a standard 'simpleChecked' binding,\n         * but with a difference that it wont' change values array if\n         * value of DOM element changes.\n         */\n        init: function (element, valueAccessor) {\n            var isCheckbox = element.type === 'checkbox',\n                isRadio = element.type === 'radio',\n                updateView,\n                updateModel;\n\n            if (!isCheckbox && !isRadio) {\n                return;\n            }\n\n            /**\n             * Updates checked observable\n             */\n            updateModel = function () {\n                var  modelValue = ko.dependencyDetection.ignore(valueAccessor),\n                    isChecked = element.checked;\n\n                if (ko.computedContext.isInitial()) {\n                    return;\n                }\n\n                if (modelValue.peek() === isChecked) {\n                    return;\n                }\n\n                if (isRadio && !isChecked) {\n                    return;\n                }\n\n                modelValue(isChecked);\n            };\n\n            /**\n             * Updates checkbox state\n             */\n            updateView = function () {\n                var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n                element.checked = !!modelValue;\n            };\n\n            ko.utils.registerEventHandler(element, 'change', updateModel);\n\n            ko.computed(updateModel, null, {\n                disposeWhenNodeIsRemoved: element\n            });\n            ko.computed(updateView, null, {\n                disposeWhenNodeIsRemoved: element\n            });\n        }\n    };\n\n    ko.expressionRewriting._twoWayBindings.simpleChecked = true;\n\n    renderer.addAttribute('simpleChecked');\n    renderer.addAttribute('simple-checked', {\n        binding: 'simpleChecked'\n    });\n});\n","Magento_Ui/js/lib/knockout/bindings/staticChecked.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    '../template/renderer'\n], function (ko, renderer) {\n    'use strict';\n\n    ko.bindingHandlers.staticChecked = {\n        'after': ['value', 'attr'],\n\n        /**\n         * Implements same functionality as a standard 'checked' binding,\n         * but with a difference that it wont' change values array if\n         * value of DOM element changes.\n         */\n        init: function (element, valueAccessor, allBindings) {\n            var isCheckbox = element.type === 'checkbox',\n                isRadio = element.type === 'radio',\n                isValueArray,\n                oldElemValue,\n                useCheckedValue,\n                checkedValue,\n                updateModel,\n                updateView;\n\n            if (!isCheckbox && !isRadio) {\n                return;\n            }\n\n            checkedValue = ko.pureComputed(function () {\n                if (allBindings.has('checkedValue')) {\n                    return ko.utils.unwrapObservable(allBindings.get('checkedValue'));\n                } else if (allBindings.has('value')) {\n                    return ko.utils.unwrapObservable(allBindings.get('value'));\n                }\n\n                return element.value;\n            });\n\n            isValueArray = isCheckbox && ko.utils.unwrapObservable(valueAccessor()) instanceof Array;\n            oldElemValue = isValueArray ? checkedValue() : undefined;\n            useCheckedValue = isRadio || isValueArray;\n\n            /**\n             * Updates values array if it's necessary.\n             */\n            updateModel = function () {\n                var isChecked = element.checked,\n                    elemValue = useCheckedValue ? checkedValue() : isChecked,\n                    modelValue;\n\n                if (ko.computedContext.isInitial()) {\n                    return;\n                }\n\n                if (isRadio && !isChecked) {\n                    return;\n                }\n\n                modelValue = ko.dependencyDetection.ignore(valueAccessor);\n\n                if (isValueArray) {\n                    if (oldElemValue !== elemValue) {\n                        oldElemValue = elemValue;\n                    } else {\n                        ko.utils.addOrRemoveItem(modelValue, elemValue, isChecked);\n                    }\n                } else {\n                    ko.expressionRewriting.writeValueToProperty(modelValue, allBindings, 'checked', elemValue, true);\n                }\n            };\n\n            /**\n             * Updates checkbox state.\n             */\n            updateView = function () {\n                var modelValue = ko.utils.unwrapObservable(valueAccessor());\n\n                if (isValueArray) {\n                    element.checked = ko.utils.arrayIndexOf(modelValue, checkedValue()) >= 0;\n                } else if (isCheckbox) {\n                    element.checked = modelValue;\n                } else {\n                    element.checked = checkedValue() === modelValue;\n                }\n            };\n\n            ko.computed(updateModel, null, {\n                disposeWhenNodeIsRemoved: element\n            });\n\n            ko.utils.registerEventHandler(element, 'click', updateModel);\n\n            ko.computed(updateView, null, {\n                disposeWhenNodeIsRemoved: element\n            });\n        }\n    };\n\n    ko.expressionRewriting._twoWayBindings.staticChecked = true;\n\n    renderer.addAttribute('staticChecked');\n});\n","Magento_Ui/js/lib/knockout/bindings/tooltip.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'ko',\n    'underscore',\n    'mage/template',\n    'text!ui/template/tooltip/tooltip.html',\n    '../template/renderer'\n], function ($, ko, _, template, tooltipTmpl, renderer) {\n    'use strict';\n\n    var tooltip,\n        defaults,\n        positions,\n        transformProp,\n        checkedPositions = {},\n        iterator = 0,\n        previousTooltip,\n        tooltipData,\n        positionData = {},\n        tooltipsCollection = {},\n        isTouchDevice = (function () {\n            return 'ontouchstart' in document.documentElement;\n        })(),\n        CLICK_EVENT = (function () {\n            return isTouchDevice ? 'touchstart' : 'click';\n        })();\n\n    defaults = {\n        tooltipWrapper: '[data-tooltip=tooltip-wrapper]',\n        tooltipContentBlock: 'data-tooltip-content',\n        closeButtonClass: 'action-close',\n        tailClass: 'data-tooltip-tail',\n        action: 'hover',\n        delay: 300,\n        track: false,\n        step: 20,\n        position: 'top',\n        closeButton: false,\n        showed: false,\n        strict: true,\n        center: false,\n        closeOnScroll: true\n    };\n\n    tooltipData = {\n        tooltipClasses: '',\n        trigger: false,\n        timeout: 0,\n        element: false,\n        event: false,\n        targetElement: {},\n        showed: false,\n        currentID: 0\n    };\n\n    /**\n     * Polyfill for css transform\n     */\n    transformProp = (function () {\n        var style = document.createElement('div').style,\n            base = 'Transform',\n            vendors = ['webkit', 'moz', 'ms', 'o'],\n            vi = vendors.length,\n            property;\n\n        if (typeof style.transform !== 'undefined') {\n            return 'transform';\n        }\n\n        while (vi--) {\n            property = vendors[vi] + base;\n\n            if (typeof style[property] !== 'undefined') {\n                return property;\n            }\n        }\n    })();\n\n    positions = {\n\n        /*eslint max-depth: [0, 0]*/\n\n        map: {\n            horizontal: {\n                s: 'w',\n                p: 'left'\n            },\n            vertical: {\n                s: 'h',\n                p: 'top'\n            }\n        },\n\n        /**\n         * Wrapper function to get tooltip data (position, className, etc)\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        top: function (s) {\n            return positions._topLeftChecker(s, positions.map, 'vertical', '_bottom', 'top', 'right');\n        },\n\n        /**\n         * Wrapper function to get tooltip data (position, className, etc)\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        left: function (s) {\n            return positions._topLeftChecker(s, positions.map, 'horizontal', '_right', 'left', 'top');\n        },\n\n        /**\n         * Wrapper function to get tooltip data (position, className, etc)\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        bottom: function (s) {\n            return positions._bottomRightChecker(s, positions.map, 'vertical', '_top', 'bottom', 'left');\n        },\n\n        /**\n         * Wrapper function to get tooltip data (position, className, etc)\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        right: function (s) {\n            return positions._bottomRightChecker(s, positions.map, 'horizontal', '_left', 'right', 'bottom');\n        },\n\n        /**\n         * Check can tooltip setted on current position or not. If can't setted - delegate call.\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} map - mapping for get direction positions\n         * @param {String} direction - vertical or horizontal\n         * @param {String} className - class whats should be setted to tooltip\n         * @param {String} side - parent method name\n         * @param {String} delegate - method name if tooltip can't be setted in current position\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _topLeftChecker: function (s, map, direction, className, side, delegate) {\n            var result = {\n                    position: {}\n                },\n                config = tooltip.getTooltip(tooltipData.currentID),\n                startPosition = !config.strict ? s.eventPosition : s.elementPosition,\n                changedDirection;\n\n            checkedPositions[side] = true;\n\n            if (\n                startPosition[map[direction].p] - s.tooltipSize[map[direction].s] - config.step >\n                s.scrollPosition[map[direction].p]\n            ) {\n                result.position[map[direction].p] = startPosition[map[direction].p] - s.tooltipSize[map[direction].s] -\n                    config.step;\n                result.className = className;\n                result.side = side;\n                changedDirection = direction === 'vertical' ? 'horizontal' : 'vertical';\n                result = positions._normalize(s, result, config, delegate, map, changedDirection);\n            } else if (!checkedPositions[delegate]) {\n                result = positions[delegate].apply(null, arguments);\n            } else {\n                result = positions.positionCenter(s, result);\n            }\n\n            return result;\n        },\n\n        /**\n         * Check can tooltip setted on current position or not. If can't setted - delegate call.\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} map - mapping for get direction positions\n         * @param {String} direction - vertical or horizontal\n         * @param {String} className - class whats should be setted to tooltip\n         * @param {String} side - parent method name\n         * @param {String} delegate - method name if tooltip can't be setted in current position\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _bottomRightChecker: function (s, map, direction, className, side, delegate) {\n            var result = {\n                    position: {}\n                },\n                config = tooltip.getTooltip(tooltipData.currentID),\n                startPosition = !config.strict ? s.eventPosition : {\n                    top: s.elementPosition.top + s.elementSize.h,\n                    left: s.elementPosition.left + s.elementSize.w\n                },\n                changedDirection;\n\n            checkedPositions[side] = true;\n\n            if (\n                startPosition[map[direction].p] + s.tooltipSize[map[direction].s] + config.step <\n                s.scrollPosition[map[direction].p] + s.windowSize[map[direction].s]\n            ) {\n                result.position[map[direction].p] = startPosition[map[direction].p] + config.step;\n                result.className = className;\n                result.side = side;\n                changedDirection = direction === 'vertical' ? 'horizontal' : 'vertical';\n                result = positions._normalize(s, result, config, delegate, map, changedDirection);\n            } else if (!checkedPositions[delegate]) {\n                result = positions[delegate].apply(null, arguments);\n            } else {\n                result = positions.positionCenter(s, result);\n            }\n\n            return result;\n        },\n\n        /**\n         * Centered tooltip if tooltip does not fit in window\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} data - current data (position, className, etc)\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        positionCenter: function (s, data) {\n            data = positions._positionCenter(s, data, 'horizontal', positions.map);\n            data = positions._positionCenter(s, data, 'vertical', positions.map);\n\n            return data;\n        },\n\n        /**\n         * Centered tooltip side\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} data - current data (position, className, etc)\n         * @param {String} direction - vertical or horizontal\n         * @param {Object} map - mapping for get direction positions\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _positionCenter: function (s, data, direction, map) {\n            if (s.tooltipSize[map[direction].s] < s.windowSize[map[direction].s]) {\n                data.position[map[direction].p] = (s.windowSize[map[direction].s] -\n                    s.tooltipSize[map[direction].s]) / 2 + s.scrollPosition[map[direction].p];\n            } else {\n                data.position[map[direction].p] = s.scrollPosition[map[direction].p];\n                data.tooltipSize = {};\n                data.tooltipSize[map[direction].s] = s.windowSize[map[direction].s];\n            }\n\n            return data;\n        },\n\n        /**\n         * Normalize horizontal or vertical position.\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} data - current data (position, className, etc)\n         * @param {Object} config - tooltip config\n         * @param {String} delegate - method name if tooltip can't be setted in current position\n         * @param {Object} map - mapping for get direction positions\n         * @param {String} direction - vertical or horizontal\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _normalize: function (s, data, config, delegate, map, direction) {\n            var startPosition = !config.center ? s.eventPosition : {\n                    left: s.elementPosition.left + s.elementSize.w / 2,\n                    top: s.elementPosition.top + s.elementSize.h / 2\n                },\n                depResult;\n\n            if (startPosition[map[direction].p] - s.tooltipSize[map[direction].s] / 2 >\n                s.scrollPosition[map[direction].p] && startPosition[map[direction].p] +\n                s.tooltipSize[map[direction].s] / 2 <\n                s.scrollPosition[map[direction].p] + s.windowSize[map[direction].s]\n            ) {\n                data.position[map[direction].p] = startPosition[map[direction].p] - s.tooltipSize[map[direction].s] / 2;\n            } else {\n\n                /*eslint-disable no-lonely-if*/\n                if (!checkedPositions[delegate]) {\n                    depResult = positions[delegate].apply(null, arguments);\n\n                    if (depResult.hasOwnProperty('className')) {\n                        data = depResult;\n                    } else {\n                        data = positions._normalizeTail(s, data, config, delegate, map, direction, startPosition);\n                    }\n                } else {\n                    data = positions._normalizeTail(s, data, config, delegate, map, direction, startPosition);\n                }\n            }\n\n            return data;\n        },\n\n        /**\n         * Calc tail position.\n         *\n         * @param {Object} s - object with sizes and positions elements\n         * @param {Object} data - current data (position, className, etc)\n         * @param {Object} config - tooltip config\n         * @param {String} delegate - method name if tooltip can't be setted in current position\n         * @param {Object} map - mapping for get direction positions\n         * @param {String} direction - vertical or horizontal\n         * @param {Object} startPosition - start position\n         * @returns {Object} tooltip data (position, className, etc)\n         */\n        _normalizeTail: function (s, data, config, delegate, map, direction, startPosition) {\n            data.tail = {};\n\n            if (s.tooltipSize[map[direction].s] < s.windowSize[map[direction].s]) {\n\n                if (\n                    startPosition[map[direction].p] >\n                    s.windowSize[map[direction].s] / 2 + s.scrollPosition[map[direction].p]\n                ) {\n                    data.position[map[direction].p] = s.windowSize[map[direction].s] +\n                        s.scrollPosition[map[direction].p] - s.tooltipSize[map[direction].s];\n                    data.tail[map[direction].p] = startPosition[map[direction].p] -\n                        s.tooltipSize[map[direction].s] / 2 - data.position[map[direction].p];\n                } else {\n                    data.position[map[direction].p] = s.scrollPosition[map[direction].p];\n                    data.tail[map[direction].p] = startPosition[map[direction].p] -\n                        s.tooltipSize[map[direction].s] / 2 - data.position[map[direction].p];\n                }\n            } else {\n                data.position[map[direction].p] = s.scrollPosition[map[direction].p];\n                data.tail[map[direction].p] = s.eventPosition[map[direction].p] - s.windowSize[map[direction].s] / 2;\n                data.tooltipSize = {};\n                data.tooltipSize[map[direction].s] = s.windowSize[map[direction].s];\n            }\n\n            return data;\n        }\n    };\n\n    tooltip = {\n\n        /**\n         * Set new tooltip to tooltipCollection, save config, and add unic id\n         *\n         * @param {Object} config - tooltip config\n         * @returns {String} tooltip id\n         */\n        setTooltip: function (config) {\n            var property = 'id-' + iterator;\n\n            tooltipsCollection[property] = config;\n            iterator++;\n\n            return property;\n        },\n\n        /**\n         * Get tooltip config by id\n         *\n         * @param {String} id - tooltip id\n         * @returns {Object} tooltip config\n         */\n        getTooltip: function (id) {\n            return tooltipsCollection[id];\n        },\n\n        /**\n         * Set content to current tooltip\n         *\n         * @param {Object} tooltipElement - tooltip element\n         * @param {Object} viewModel - tooltip view model\n         * @param {String} id - tooltip id\n         * @param {Object} bindingCtx - tooltip context\n         * @param {Object} event - action event\n         */\n        setContent: function (tooltipElement, viewModel, id, bindingCtx, event) {\n            var html = $(tooltipElement).html(),\n                config = tooltip.getTooltip(id),\n                body = $('body');\n\n            tooltipData.currentID = id;\n            tooltipData.trigger = $(event.currentTarget);\n            tooltip.setTargetData(event);\n            body.on('mousemove.setTargetData', tooltip.setTargetData);\n            tooltip.clearTimeout(id);\n\n            tooltipData.timeout = _.delay(function () {\n                body.off('mousemove.setTargetData', tooltip.setTargetData);\n\n                if (tooltipData.trigger[0] === tooltipData.targetElement) {\n                    tooltip.destroy(id);\n                    event.stopPropagation();\n                    tooltipElement = tooltip.createTooltip(id);\n                    tooltipElement.find('.' + defaults.tooltipContentBlock).append(html);\n                    tooltipElement.applyBindings(bindingCtx);\n                    tooltip.setHandlers(id);\n                    tooltip.setPosition(tooltipElement, id);\n                    previousTooltip = id;\n                }\n\n            }, config.delay);\n        },\n\n        /**\n         * Set position to current tooltip\n         *\n         * @param {Object} tooltipElement - tooltip element\n         * @param {String} id - tooltip id\n         */\n        setPosition: function (tooltipElement, id) {\n            var config = tooltip.getTooltip(id);\n\n            tooltip.sizeData = {\n                windowSize: {\n                    h: $(window).outerHeight(),\n                    w: $(window).outerWidth()\n                },\n                scrollPosition: {\n                    top: $(window).scrollTop(),\n                    left: $(window).scrollLeft()\n                },\n                tooltipSize: {\n                    h: tooltipElement.outerHeight(),\n                    w: tooltipElement.outerWidth()\n                },\n                elementSize: {\n                    h: tooltipData.trigger.outerHeight(),\n                    w: tooltipData.trigger.outerWidth()\n                },\n                elementPosition: tooltipData.trigger.offset(),\n                eventPosition: this.getEventPosition(tooltipData.event)\n            };\n\n            _.extend(positionData, positions[config.position](tooltip.sizeData));\n            tooltipElement.css(positionData.position);\n            tooltipElement.addClass(positionData.className);\n            tooltip._setTooltipSize(positionData, tooltipElement);\n            tooltip._setTailPosition(positionData, tooltipElement);\n            checkedPositions = {};\n        },\n\n        /**\n         * Check position data and change tooltip size if needs\n         *\n         * @param {Object} data - position data\n         * @param {Object} tooltipElement - tooltip element\n         */\n        _setTooltipSize: function (data, tooltipElement) {\n            if (data.tooltipSize) {\n                data.tooltipSize.w ?\n                    tooltipElement.css('width', data.tooltipSize.w) :\n                    tooltipElement.css('height', data.tooltipSize.h);\n            }\n        },\n\n        /**\n         * Check position data and set position to tail\n         *\n         * @param {Object} data - position data\n         * @param {Object} tooltipElement - tooltip element\n         */\n        _setTailPosition: function (data, tooltipElement) {\n            var tail,\n                tailMargin;\n\n            if (data.tail) {\n                tail = tooltipElement.find('.' + defaults.tailClass);\n\n                if (data.tail.left) {\n                    tailMargin = parseInt(tail.css('margin-left'), 10);\n                    tail.css('margin-left', tailMargin + data.tail.left);\n                } else {\n                    tailMargin = parseInt(tail.css('margin-top'), 10);\n                    tail.css('margin-top', tailMargin + data.tail.top);\n                }\n            }\n        },\n\n        /**\n         * Resolves position for tooltip\n         *\n         * @param {Object} event\n         * @returns {Object}\n         */\n        getEventPosition: function (event) {\n            var position = {\n                left: event.originalEvent && event.originalEvent.pageX || 0,\n                top: event.originalEvent && event.originalEvent.pageY || 0\n            };\n\n            if (position.left === 0 && position.top === 0) {\n                _.extend(position, event.target.getBoundingClientRect());\n            }\n\n            return position;\n        },\n\n        /**\n         * Close tooltip if action happened outside handler and tooltip element\n         *\n         * @param {String} id - tooltip id\n         * @param {Object} event - action event\n         */\n        outerClick: function (id, event) {\n            var tooltipElement = $(event.target).parents(defaults.tooltipWrapper)[0],\n                isTrigger = event.target === tooltipData.trigger[0] || $.contains(tooltipData.trigger[0], event.target);\n\n            if (tooltipData.showed && tooltipElement !== tooltipData.element[0] && !isTrigger) {\n                tooltip.destroy(id);\n            }\n        },\n\n        /**\n         * Parse keydown event and if event trigger is escape key - close tooltip\n         *\n         * @param {Object} event - action event\n         */\n        keydownHandler: function (event) {\n            if (tooltipData.showed && event.keyCode === 27) {\n                tooltip.destroy(tooltipData.currentID);\n            }\n        },\n\n        /**\n         * Change tooltip position when track is enabled\n         *\n         * @param {Object} event - current event\n         */\n        track: function (event) {\n            var inequality = {},\n                map = positions.map,\n                translate = {\n                    left: 'translateX',\n                    top: 'translateY'\n                },\n                eventPosition = {\n                    left: event.pageX,\n                    top: event.pageY\n                },\n                tooltipSize = {\n                    w: tooltipData.element.outerWidth(),\n                    h: tooltipData.element.outerHeight()\n                },\n                direction = positionData.side === 'bottom' || positionData.side === 'top' ? 'horizontal' : 'vertical';\n\n            inequality[map[direction].p] = eventPosition[map[direction].p] - (positionData.position[map[direction].p] +\n                tooltipSize[map[direction].s] / 2);\n\n            if (positionData.position[map[direction].p] + inequality[map[direction].p] +\n                tooltip.sizeData.tooltipSize[map[direction].s] >\n                tooltip.sizeData.windowSize[map[direction].s] + tooltip.sizeData.scrollPosition[map[direction].p] ||\n                inequality[map[direction].p] + positionData.position[map[direction].p] <\n                tooltip.sizeData.scrollPosition[map[direction].p]) {\n\n                return false;\n            }\n\n            tooltipData.element[0].style[transformProp] = translate[map[direction].p] +\n                '(' + inequality[map[direction].p] + 'px)';\n        },\n\n        /**\n         * Set handlers to tooltip\n         *\n         * @param {String} id - tooltip id\n         */\n        setHandlers: function (id) {\n            var config = tooltip.getTooltip(id);\n\n            if (config.track) {\n                tooltipData.trigger.on('mousemove.track', tooltip.track);\n            }\n\n            if (config.action === 'click') {\n                $(window).on(CLICK_EVENT + '.outerClick', tooltip.outerClick.bind(null, id));\n            }\n\n            if (config.closeButton) {\n                $('.' + config.closeButtonClass).on('click.closeButton', tooltip.destroy.bind(null, id));\n            }\n\n            if (config.closeOnScroll) {\n                document.addEventListener('scroll', tooltip.destroy, true);\n                $(window).on('scroll.tooltip', tooltip.outerClick.bind(null, id));\n            }\n\n            $(window).on('keydown.tooltip', tooltip.keydownHandler);\n            $(window).on('resize.outerClick', tooltip.outerClick.bind(null, id));\n        },\n\n        /**\n         * Toggle tooltip\n         *\n         * @param {Object} tooltipElement - tooltip element\n         * @param {Object} viewModel - tooltip view model\n         * @param {String} id - tooltip id\n         */\n        toggleTooltip: function (tooltipElement, viewModel, id) {\n            if (previousTooltip === id && tooltipData.showed) {\n                tooltip.destroy(id);\n\n                return false;\n            }\n\n            tooltip.setContent.apply(null, arguments);\n\n            return false;\n        },\n\n        /**\n         * Create tooltip and append to DOM\n         *\n         * @param {String} id - tooltip id\n         * @returns {Object} tooltip element\n         */\n        createTooltip: function (id) {\n            var body = $('body'),\n                config = tooltip.getTooltip(id);\n\n            $(template(tooltipTmpl, {\n                data: config\n            })).appendTo(body);\n\n            tooltipData.showed = true;\n            tooltipData.element = $(config.tooltipWrapper);\n\n            return tooltipData.element;\n        },\n\n        /**\n         * Check action and clean timeout\n         *\n         * @param {String} id - tooltip id\n         */\n        clearTimeout: function (id) {\n            var config = tooltip.getTooltip(id);\n\n            if (config.action === 'hover') {\n                clearTimeout(tooltipData.timeout);\n            }\n        },\n\n        /**\n         * Check previous tooltip\n         */\n        checkPreviousTooltip: function () {\n            if (!tooltipData.timeout) {\n                tooltip.destroy();\n            }\n        },\n\n        /**\n         * Destroy tooltip instance\n         */\n        destroy: function () {\n            if (tooltipData.element) {\n                tooltipData.element.remove();\n                tooltipData.showed = false;\n            }\n\n            positionData = {};\n            tooltipData.timeout = false;\n            tooltip.removeHandlers();\n        },\n\n        /**\n         * Remove tooltip handlers\n         */\n        removeHandlers: function () {\n            $('.' + defaults.closeButtonClass).off('click.closeButton');\n            tooltipData.trigger.off('mousemove.track');\n            document.removeEventListener('scroll', tooltip.destroy, true);\n            $(window).off('scroll.tooltip');\n            $(window).off(CLICK_EVENT + '.outerClick');\n            $(window).off('keydown.tooltip');\n            $(window).off('resize.outerClick');\n        },\n\n        /**\n         * Set target element\n         *\n         * @param {Object} event - current event\n         */\n        setTargetData: function (event) {\n            tooltipData.event = event;\n\n            //TODO: bug chrome v.49; Link to issue https://bugs.chromium.org/p/chromium/issues/detail?id=161464\n            if (event.timeStamp - (tooltipData.timestamp || 0) < 1) {\n                return;\n            }\n\n            if (event.type === 'mousemove') {\n                tooltipData.targetElement = event.target;\n            } else {\n                tooltipData.targetElement = event.currentTarget;\n                tooltipData.timestamp = event.timeStamp;\n            }\n        },\n\n        /**\n         * Merged user config with defaults configuration\n         *\n         * @param {Object} config - user config\n         * @returns {Object} merged config\n         */\n        processingConfig: function (config) {\n            return _.extend({}, defaults, config);\n        }\n    };\n\n    ko.bindingHandlers.tooltip = {\n\n        /**\n         * Initialize tooltip\n         *\n         * @param {Object} elem - tooltip DOM element\n         * @param {Function} valueAccessor - ko observable property, tooltip data\n         * @param {Object} allBindings - all bindings on current element\n         * @param {Object} viewModel - current element viewModel\n         * @param {Object} bindingCtx - current element binding context\n         */\n        init: function (elem, valueAccessor, allBindings, viewModel, bindingCtx) {\n            var config = tooltip.processingConfig(valueAccessor()),\n                $parentScope = config.parentScope ? $(config.parentScope) : $(elem).parent(),\n                tooltipId;\n\n            $(elem).addClass('hidden');\n\n            if (isTouchDevice) {\n                config.action = 'click';\n            }\n            tooltipId = tooltip.setTooltip(config);\n\n            if (config.action === 'hover') {\n                $parentScope.on(\n                    'mouseenter',\n                    config.trigger,\n                    tooltip.setContent.bind(null, elem, viewModel, tooltipId, bindingCtx)\n                );\n                $parentScope.on(\n                    'mouseleave',\n                    config.trigger,\n                    tooltip.checkPreviousTooltip.bind(null, tooltipId)\n                );\n            } else if (config.action === 'click') {\n                $parentScope.on(\n                    'click',\n                    config.trigger,\n                    tooltip.toggleTooltip.bind(null, elem, viewModel, tooltipId, bindingCtx)\n                );\n            }\n\n            return {\n                controlsDescendantBindings: true\n            };\n        }\n    };\n\n    renderer.addAttribute('tooltip');\n});\n","Magento_Ui/js/lib/knockout/extender/bound-nodes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'mage/utils/wrapper',\n    'uiEvents'\n], function (ko, _, wrapper, Events) {\n    'use strict';\n\n    var nodesMap = new WeakMap();\n\n    /**\n     * Returns a array of nodes associated with a specified model.\n     *\n     * @param {Object} model\n     * @returns {Undefined|Array}\n     */\n    function getBounded(model) {\n        return nodesMap.get(model);\n    }\n\n    /**\n     * Removes specified node to models' associations list, if it's\n     * a root node (node is not a descendant of any previously added nodes).\n     * Triggers 'addNode' event.\n     *\n     * @param {Object} model\n     * @param {HTMLElement} node\n     */\n    function addBounded(model, node) {\n        var nodes = getBounded(model),\n            isRoot;\n\n        if (!nodes) {\n            nodesMap.set(model, [node]);\n\n            Events.trigger.call(model, 'addNode', node);\n\n            return;\n        }\n\n        isRoot = nodes.every(function (bounded) {\n            return !bounded.contains(node);\n        });\n\n        if (isRoot) {\n            nodes.push(node);\n\n            Events.trigger.call(model, 'addNode', node);\n        }\n    }\n\n    /**\n     * Removes specified node from models' associations list.\n     * Triggers 'removeNode' event.\n     *\n     * @param {Object} model\n     * @param {HTMLElement} node\n     */\n    function removeBounded(model, node) {\n        var nodes = getBounded(model),\n            index;\n\n        if (!nodes) {\n            return;\n        }\n\n        index = nodes.indexOf(node);\n\n        if (~index) {\n            nodes.splice(index, 0);\n\n            Events.trigger.call(model, 'removeNode', node);\n        }\n\n        if (!nodes.length) {\n            nodesMap.delete(model);\n        }\n    }\n\n    /**\n     * Returns node's first sibling of 'element' type within the common component scope\n     *\n     * @param {HTMLElement} node\n     * @param {*} data\n     * @returns {HTMLElement}\n     */\n    function getElement(node, data) {\n        var elem;\n\n        while (node.nextElementSibling) {\n            node = node.nextElementSibling;\n\n            if (node.nodeType === 1 && ko.dataFor(node) === data) {\n                elem = node;\n                break;\n            }\n        }\n\n        return elem;\n    }\n\n    wrapper.extend(ko, {\n\n        /**\n         * Extends knockouts' 'applyBindings'\n         * to track nodes associated with model.\n         *\n         * @param {Function} orig - Original 'applyBindings' method.\n         * @param {Object} ctx\n         * @param {HTMLElement} node - Original 'applyBindings' method.\n         */\n        applyBindings: function (orig, ctx, node) {\n            var result = orig(),\n                data = ctx && (ctx.$data || ctx);\n\n            if (node && node.nodeType === 8) {\n                node = getElement(node, data);\n            }\n\n            if (!node || node.nodeType !== 1) {\n                return result;\n            }\n\n            if (data && data.registerNodes) {\n                addBounded(data, node);\n            }\n\n            return result;\n        },\n\n        /**\n         * Extends knockouts' cleanNode\n         * to track nodes associated with model.\n         *\n         * @param {Function} orig - Original 'cleanNode' method.\n         * @param {HTMLElement} node - Original 'cleanNode' method.\n         */\n        cleanNode: function (orig, node) {\n            var result = orig(),\n                data;\n\n            if (node.nodeType !== 1) {\n                return result;\n            }\n\n            data = ko.dataFor(node);\n\n            if (data && data.registerNodes) {\n                removeBounded(data, node);\n            }\n\n            return result;\n        }\n    });\n\n    return {\n\n        /**\n         * Returns root nodes associated with a model. If callback is provided,\n         * will iterate through all of the present nodes triggering callback\n         * for each of it. Also it will subscribe to the 'addNode' event.\n         *\n         * @param {Object} model\n         * @param {Function} [callback]\n         * @returns {Array|Undefined}\n         */\n        get: function (model, callback) {\n            var nodes = getBounded(model) || [];\n\n            if (!_.isFunction(callback)) {\n                return nodes;\n            }\n\n            nodes.forEach(function (node) {\n                callback(node);\n            });\n\n            this.add.apply(this, arguments);\n        },\n\n        /**\n         * Subscribes to adding of nodes associated with a model.\n         *\n         * @param {Object} model\n         */\n        add: function (model) {\n            var args = _.toArray(arguments).slice(1);\n\n            args.unshift('addNode');\n\n            Events.on.apply(model, args);\n        },\n\n        /**\n         * Subscribes to removal of nodes associated with a model.\n         *\n         * @param {Object} model\n         */\n        remove: function (model) {\n            var args = _.toArray(arguments).slice(1);\n\n            args.unshift('removeNode');\n\n            Events.on.apply(model, args);\n        },\n\n        /**\n         * Removes subscriptions from the model.\n         *\n         * @param {Object} model\n         */\n        off: function (model) {\n            var args = _.toArray(arguments).slice(1);\n\n            Events.off.apply(model, args);\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/extender/observable_array.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore'\n], function (ko, _) {\n    'use strict';\n\n    /**\n     * Iterator function.\n     *\n     * @param {String} callback\n     * @param {Array} args\n     * @param {Object} elem\n     * @returns {*}\n     */\n    function iterator(callback, args, elem) {\n        callback = elem[callback];\n\n        if (_.isFunction(callback)) {\n            return callback.apply(elem, args);\n        }\n\n        return callback;\n    }\n\n    /**\n     * Wrapper function.\n     *\n     * @param {String} method\n     * @returns {Function}\n     */\n    function wrapper(method) {\n        return function (iteratee) {\n            var callback = iteratee,\n                elems = this(),\n                args = _.toArray(arguments);\n\n            if (_.isString(iteratee)) {\n                callback = iterator.bind(null, iteratee, args.slice(1));\n\n                args.unshift(callback);\n            }\n\n            args.unshift(elems);\n\n            return _[method].apply(_, args);\n        };\n    }\n\n    _.extend(ko.observableArray.fn, {\n        each: wrapper('each'),\n\n        map: wrapper('map'),\n\n        filter: wrapper('filter'),\n\n        some: wrapper('some'),\n\n        every: wrapper('every'),\n\n        groupBy: wrapper('groupBy'),\n\n        sortBy: wrapper('sortBy'),\n\n        /**\n         * Wrapper for underscore findWhere function.\n         *\n         * @param {Object} properties\n         * @return {Object}\n         */\n        findWhere: function (properties) {\n            return _.findWhere(this(), properties);\n        },\n\n        /**\n         * Wrapper for underscore contains function.\n         *\n         * @param {*} value\n         * @return {Boolean}\n         */\n        contains: function (value) {\n            return _.contains(this(), value);\n        },\n\n        /**\n         * Inverse contains call.\n         *\n         * @return {Boolean}\n         */\n        hasNo: function () {\n            return !this.contains.apply(this, arguments);\n        },\n\n        /**\n         * Getter for length property.\n         *\n         * @return {Number}\n         */\n        getLength: function () {\n            return this().length;\n        },\n\n        /**\n         * Create object with keys that gets from each object property.\n         *\n         * @return {Object}\n         */\n        indexBy: function (key) {\n            return _.indexBy(this(), key);\n        },\n\n        /**\n         * Returns a copy of the array with all instances of the values removed.\n         *\n         * @return {Array}\n         */\n        without: function () {\n            var args = Array.prototype.slice.call(arguments);\n\n            args.unshift(this());\n\n            return _.without.apply(_, args);\n        },\n\n        /**\n         * Returns the first element of an array.\n         *\n         * @return {*}\n         */\n        first: function () {\n            return _.first(this());\n        },\n\n        /**\n         * Returns the last element of an array\n         *\n         * @return {*}\n         */\n        last: function () {\n            return _.last(this());\n        },\n\n        /**\n         * Iterate and pick provided properties.\n         *\n         * @return {Array}\n         */\n        pluck: function () {\n            var args = Array.prototype.slice.call(arguments);\n\n            args.unshift(this());\n\n            return _.pluck.apply(_, args);\n        }\n    });\n});\n","Magento_Ui/js/lib/knockout/template/engine.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'ko',\n    'underscore',\n    './observable_source',\n    './renderer',\n    '../../logger/console-logger'\n], function ($, ko, _, Source, renderer, consoleLogger) {\n    'use strict';\n\n    var RemoteTemplateEngine,\n        NativeTemplateEngine = ko.nativeTemplateEngine,\n        sources = {};\n\n    /**\n     * Remote template engine class. Is used to be able to load remote templates via knockout template binding.\n     */\n    RemoteTemplateEngine = function () {\n        // Instance reference for closure.\n        var engine = this,\n        // Decorate the builtin Knockout \"template\" binding to track synchronous template renders.\n        origUpdate = ko.bindingHandlers.template.update;\n\n        /**\n         * Counter to track the number of currently running render tasks (both synchronous and asynchronous).\n         * @type {Number}\n         * @private\n         */\n        this._rendersOutstanding = 0;\n\n        /**\n         * Use a jQuery object as an event bus (but any event emitter with on/off/emit methods could work)\n         * @type {jQuery}\n         * @private\n         */\n        this._events = $(this);\n\n        /**\n         * Rendered templates\n         * @type {Object}\n         * @private\n         */\n        this._templatesRendered = {};\n\n        /*eslint-disable no-unused-vars*/\n        /**\n         * Decorate update method\n         *\n         * @param {HTMLElement} element\n         * @param {Function} valueAccessor\n         * @param {Object} allBindings\n         * @param {Object} viewModel\n         * @param {ko.bindingContext} bindingContext\n         * @returns {*}\n         */\n        ko.bindingHandlers.template.update = function (element, valueAccessor, allBindings, viewModel, bindingContext) {\n            /*eslint-enable no-unused-vars*/\n            var options = ko.utils.peekObservable(valueAccessor()),\n                templateName,\n                isSync,\n                updated;\n\n            if (typeof options === 'object') {\n                if (options.templateEngine && options.templateEngine !== engine) {\n                    return origUpdate.apply(this, arguments);\n                }\n\n                if (!options.name) {\n                    consoleLogger.error('Could not find template name', options);\n                }\n                templateName = options.name;\n            } else if (typeof options === 'string') {\n                templateName = options;\n            } else {\n                consoleLogger.error('Could not build a template binding', options);\n            }\n            engine._trackRender(templateName);\n            isSync = engine._hasTemplateLoaded(templateName);\n            updated = origUpdate.apply(this, arguments);\n\n            if (isSync) {\n                engine._releaseRender(templateName, 'sync');\n            }\n\n            return updated;\n        };\n    };\n\n    /**\n     * Creates unique template identifier based on template name and it's extenders (optional)\n     * @param  {String} templateName\n     * @return {String} - unique template identifier\n     */\n    function createTemplateIdentifier(templateName) {\n        return templateName;\n    }\n\n    RemoteTemplateEngine.prototype = new NativeTemplateEngine;\n    RemoteTemplateEngine.prototype.constructor = RemoteTemplateEngine;\n\n    /**\n     * When an asynchronous render task begins, increment the internal counter for tracking when renders are complete.\n     * @private\n     */\n    RemoteTemplateEngine.prototype._trackRender = function (templateName) {\n        var rendersForTemplate = this._templatesRendered[templateName] !== undefined ?\n            this._templatesRendered[templateName] : 0;\n\n        this._rendersOutstanding++;\n        this._templatesRendered[templateName] = rendersForTemplate + 1;\n        this._resolveRenderWaits();\n    };\n\n    /**\n     * When an asynchronous render task ends, decrement the internal counter for tracking when renders are complete.\n     * @private\n     */\n    RemoteTemplateEngine.prototype._releaseRender = function (templateName) {\n        var rendersForTemplate = this._templatesRendered[templateName];\n\n        this._rendersOutstanding--;\n        this._templatesRendered[templateName] = rendersForTemplate - 1;\n        this._resolveRenderWaits();\n    };\n\n    /**\n     * Check to see if renders are complete and trigger events for listeners.\n     * @private\n     */\n    RemoteTemplateEngine.prototype._resolveRenderWaits = function () {\n        if (this._rendersOutstanding === 0) {\n            this._events.triggerHandler('finishrender');\n        }\n    };\n\n    /**\n     * Get a promise for the end of the current run of renders, both sync and async.\n     * @return {jQueryPromise} - promise that resolves when render completes\n     */\n    RemoteTemplateEngine.prototype.waitForFinishRender = function () {\n        var defer = $.Deferred();\n\n        this._events.one('finishrender', defer.resolve);\n\n        return defer.promise();\n    };\n\n    /**\n     * Returns true if this template has already been asynchronously loaded and will be synchronously rendered.\n     * @param {String} templateName\n     * @returns {Boolean}\n     * @private\n     */\n    RemoteTemplateEngine.prototype._hasTemplateLoaded = function (templateName) {\n        // Sources object will have cached template once makeTemplateSource has run\n        return sources.hasOwnProperty(templateName);\n    };\n\n    /**\n     * Overrided method of native knockout template engine.\n     * Caches template after it's unique name and renders in once.\n     * If template name is not typeof string, delegates work to knockout.templateSources.anonymousTemplate.\n     * @param  {*} template\n     * @param  {HTMLElement} templateDocument - document\n     * @param  {Object} options - options, passed to template binding\n     * @param  {ko.bindingContext} bindingContext\n     * @returns {TemplateSource} Object with methods 'nodes' and 'data'.\n     */\n    RemoteTemplateEngine.prototype.makeTemplateSource = function (template, templateDocument, options, bindingContext) {\n        var engine = this,\n            source,\n            templateId;\n\n        if (typeof template === 'string') {\n            templateId = createTemplateIdentifier(template);\n            source = sources[templateId];\n\n            if (!source) {\n                source = new Source(template);\n                source.requestedBy = bindingContext.$data.name;\n                sources[templateId] = source;\n\n                consoleLogger.info('templateStartLoading', {\n                    template: templateId,\n                    component: bindingContext.$data.name\n                });\n\n                renderer.render(template).then(function (rendered) {\n                    consoleLogger.info('templateLoadedFromServer', {\n                        template: templateId,\n                        component: bindingContext.$data.name\n                    });\n                    source.nodes(rendered);\n                    engine._releaseRender(templateId, 'async');\n                }).fail(function () {\n                    consoleLogger.error('templateLoadingFail', {\n                        template: templateId,\n                        component: bindingContext.$data.name\n                    });\n                });\n            }\n\n            if (source.requestedBy !== bindingContext.$data.name) {\n                consoleLogger.info('templateLoadedFromCache', {\n                    template: templateId,\n                    component: bindingContext.$data.name\n                });\n            }\n\n            return source;\n        } else if (template.nodeType === 1 || template.nodeType === 8) {\n            source = new ko.templateSources.anonymousTemplate(template);\n\n            return source;\n        }\n\n        throw new Error('Unknown template type: ' + template);\n    };\n\n    /**\n     * Overrided method of native knockout template engine.\n     * Should return array of html elements.\n     * @param  {TemplateSource} templateSource - object with methods 'nodes' and 'data'.\n     * @return {Array} - array of html elements\n     */\n    RemoteTemplateEngine.prototype.renderTemplateSource = function (templateSource) {\n        var nodes = templateSource.nodes();\n\n        return ko.utils.cloneNodes(nodes);\n    };\n\n    /**\n     * Overrided method of native knockout template engine.\n     * Created in order to invoke makeTemplateSource method with custom set of params.\n     * @param  {*} template - template identifier\n     * @param  {ko.bindingContext} bindingContext\n     * @param  {Object} options - options, passed to template binding\n     * @param  {HTMLElement} templateDocument - document\n     * @return {Array} - array of html elements\n     */\n    RemoteTemplateEngine.prototype.renderTemplate = function (template, bindingContext, options, templateDocument) {\n        var templateSource = this.makeTemplateSource(template, templateDocument, options, bindingContext);\n\n        return this.renderTemplateSource(templateSource);\n    };\n\n    return new RemoteTemplateEngine;\n});\n","Magento_Ui/js/lib/knockout/template/loader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var licenseRegExp   = /<!--[\\s\\S]*?-->/,\n        defaultPlugin   = 'text',\n        defaultExt      = 'html';\n\n    /**\n     * Checks of provided string contains a file extension.\n     *\n     * @param {String} str - String to be checked.\n     * @returns {Boolean}\n     */\n    function hasFileExtension(str) {\n        return !!~str.indexOf('.') && !!str.split('.').pop();\n    }\n\n    /**\n     * Checks if provided string contains a requirejs's plugin reference.\n     *\n     * @param {String} str - String to be checked.\n     * @returns {Boolean}\n     */\n    function hasPlugin(str) {\n        return !!~str.indexOf('!');\n    }\n\n    /**\n     * Checks if provided string is a full path to the file.\n     *\n     * @param {String} str - String to be checked.\n     * @returns {Boolean}\n     */\n    function isFullPath(str) {\n        return !!~str.indexOf('://');\n    }\n\n    /**\n     * Removes license comment from the provided string.\n     *\n     * @param {String} content - String to be processed.\n     * @returns {String}\n     */\n    function removeLicense(content) {\n        return content.replace(licenseRegExp, function (match) {\n            return ~match.indexOf('/**') ? '' : match;\n        });\n    }\n\n    return {\n\n        /**\n         * Attempts to extract template by provided path from\n         * a DOM element and falls back to a file loading if\n         * none of the DOM nodes was found.\n         *\n         * @param {String} path - Path to the template or a DOM selector.\n         * @returns {jQueryPromise}\n         */\n        loadTemplate: function (path) {\n            var content = this.loadFromNode(path),\n                defer;\n\n            if (content) {\n                defer = $.Deferred();\n\n                defer.resolve(content);\n\n                return defer.promise();\n            }\n\n            return this.loadFromFile(path);\n        },\n\n        /**\n         * Loads template from external file by provided\n         * path, which will be preliminary formatted.\n         *\n         * @param {String} path - Path to the template.\n         * @returns {jQueryPromise}\n         */\n        loadFromFile: function (path) {\n            var loading = $.Deferred();\n\n            path = this.formatPath(path);\n\n            require([path], function (template) {\n                template = removeLicense(template);\n                loading.resolve(template);\n            }, function (err) {\n                loading.reject(err);\n            });\n\n            return loading.promise();\n        },\n\n        /**\n         * Attempts to extract content of a node found by provided selector.\n         *\n         * @param {String} selector - Node's selector (not necessary valid).\n         * @returns {String|Boolean} If specified node doesn't exists\n         *      'false' will be returned, otherwise returns node's content.\n         */\n        loadFromNode: function (selector) {\n            var node;\n\n            try {\n                node =\n                    document.getElementById(selector) ||\n                    document.querySelector(selector);\n\n                return node ? node.innerHTML : false;\n            } catch (e) {\n                return false;\n            }\n        },\n\n        /**\n         * Adds requirejs's plugin and file extension to\n         * to the provided string if it's necessary.\n         *\n         * @param {String} path - Path to be processed.\n         * @returns {String} Formatted path.\n         */\n        formatPath: function (path) {\n            var result = path;\n\n            if (!hasPlugin(path)) {\n                result = defaultPlugin + '!' + result;\n            }\n\n            if (isFullPath(path)) {\n                return result;\n            }\n\n            if (!hasFileExtension(path)) {\n                result += '.' + defaultExt;\n            }\n\n            return result.replace(/^([^\\/]+)/g, '$1/template');\n        }\n    };\n});\n","Magento_Ui/js/lib/knockout/template/observable_source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/**\n * Is being used by knockout template engine to store template to.\n */\ndefine([\n    'ko',\n    'uiClass'\n], function (ko, Class) {\n    'use strict';\n\n    return Class.extend({\n\n        /**\n         * Initializes templateName, _data, nodes properties.\n         *\n         * @param  {template} template - identifier of template\n         */\n        initialize: function (template) {\n            this.templateName = template;\n            this._data = {};\n            this.nodes = ko.observable([]);\n        },\n\n        /**\n         * Data setter. If only one arguments passed, returns corresponding value.\n         * Else, writes into it.\n         * @param  {String} key - key to write to or to read from\n         * @param  {*} value\n         * @return {*} - if 1 arg provided, Returns _data[key] property\n         */\n        data: function (key, value) {\n            if (arguments.length === 1) {\n                return this._data[key];\n            }\n\n            this._data[key] = value;\n        }\n    });\n});\n","Magento_Ui/js/lib/knockout/template/renderer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    './loader'\n], function ($, _, loader) {\n    'use strict';\n\n    var colonReg       = /\\\\:/g,\n        renderedTemplatePromises = {},\n        attributes     = {},\n        elements       = {},\n        globals        = [],\n        renderer,\n        preset;\n\n    renderer = {\n\n        /**\n         * Loads template by provided path and\n         * than converts it's content to html.\n         *\n         * @param {String} tmplPath - Path to the template.\n         * @returns {jQueryPromise}\n         * @alias getRendered\n         */\n        render: function (tmplPath) {\n            var cachedPromise = renderedTemplatePromises[tmplPath];\n\n            if (!cachedPromise) {\n                cachedPromise = renderedTemplatePromises[tmplPath] = loader\n                    .loadTemplate(tmplPath)\n                    .then(renderer.parseTemplate);\n            }\n\n            return cachedPromise;\n        },\n\n        /**\n         * @ignore\n         */\n        getRendered: function (tmplPath) {\n            return renderer.render(tmplPath);\n        },\n\n        /**\n         * Parses provided string as html content\n         * and returns an array of DOM elements.\n         *\n         * @param {String} html - String to be processed.\n         * @returns {Array}\n         */\n        parseTemplate: function (html) {\n            var fragment = document.createDocumentFragment();\n\n            $(fragment).append(html);\n\n            return renderer.normalize(fragment);\n        },\n\n        /**\n         * Processes custom attributes and nodes of provided DOM element.\n         *\n         * @param {HTMLElement} content - Element to be processed.\n         * @returns {Array} An array of content's child nodes.\n         */\n        normalize: function (content) {\n            globals.forEach(function (handler) {\n                handler(content);\n            });\n\n            return _.toArray(content.childNodes);\n        },\n\n        /**\n         * Adds new global content handler.\n         *\n         * @param {Function} handler - Function which will be invoked for\n         *      an every content passed to 'normalize' method.\n         * @returns {Renderer} Chainable.\n         */\n        addGlobal: function (handler) {\n            if (!_.contains(globals, handler)) {\n                globals.push(handler);\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes specified global content handler.\n         *\n         * @param {Function} handler - Handler to be removed.\n         * @returns {Renderer} Chainable.\n         */\n        removeGlobal: function (handler) {\n            var index = globals.indexOf(handler);\n\n            if (~index) {\n                globals.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Adds new custom attribute handler.\n         *\n         * @param {String} id - Attribute identifier.\n         * @param {(Object|Function)} [config={}]\n         * @returns {Renderer} Chainable.\n         */\n        addAttribute: function (id, config) {\n            var data = {\n                name: id,\n                binding: id,\n                handler: renderer.handlers.attribute\n            };\n\n            if (_.isFunction(config)) {\n                data.handler = config;\n            } else if (_.isObject(config)) {\n                _.extend(data, config);\n            }\n\n            data.id = id;\n            attributes[id] = data;\n\n            return this;\n        },\n\n        /**\n         * Removes specified attribute handler.\n         *\n         * @param {String} id - Attribute identifier.\n         * @returns {Renderer} Chainable.\n         */\n        removeAttribute: function (id) {\n            delete attributes[id];\n\n            return this;\n        },\n\n        /**\n         * Adds new custom node handler.\n         *\n         * @param {String} id - Node identifier.\n         * @param {(Object|Function)} [config={}]\n         * @returns {Renderer} Chainable.\n         */\n        addNode: function (id, config) {\n            var data = {\n                name: id,\n                binding: id,\n                handler: renderer.handlers.node\n            };\n\n            if (_.isFunction(config)) {\n                data.handler = config;\n            } else if (_.isObject(config)) {\n                _.extend(data, config);\n            }\n\n            data.id = id;\n            elements[id] = data;\n\n            return this;\n        },\n\n        /**\n         * Removes specified custom node handler.\n         *\n         * @param {String} id - Node identifier.\n         * @returns {Renderer} Chainable.\n         */\n        removeNode: function (id) {\n            delete elements[id];\n\n            return this;\n        },\n\n        /**\n         * Checks if provided DOM element is a custom node.\n         *\n         * @param {HTMLElement} node - Node to be checked.\n         * @returns {Boolean}\n         */\n        isCustomNode: function (node) {\n            return _.some(elements, function (elem) {\n                return elem.name.toUpperCase() === node.tagName;\n            });\n        },\n\n        /**\n         * Processes custom attributes of a content's child nodes.\n         *\n         * @param {HTMLElement} content - DOM element to be processed.\n         */\n        processAttributes: function (content) {\n            var repeat;\n\n            repeat = _.some(attributes, function (attr) {\n                var attrName = attr.name,\n                    nodes    = content.querySelectorAll('[' + attrName + ']'),\n                    handler  = attr.handler;\n\n                return _.toArray(nodes).some(function (node) {\n                    var data = node.getAttribute(attrName);\n\n                    return handler(node, data, attr) === true;\n                });\n            });\n\n            if (repeat) {\n                renderer.processAttributes(content);\n            }\n        },\n\n        /**\n         * Processes custom nodes of a provided content.\n         *\n         * @param {HTMLElement} content - DOM element to be processed.\n         */\n        processNodes: function (content) {\n            var repeat;\n\n            repeat = _.some(elements, function (element) {\n                var nodes   = content.querySelectorAll(element.name),\n                    handler = element.handler;\n\n                return _.toArray(nodes).some(function (node) {\n                    var data = node.getAttribute('args');\n\n                    return handler(node, data, element) === true;\n                });\n            });\n\n            if (repeat) {\n                renderer.processNodes(content);\n            }\n        },\n\n        /**\n         * Wraps provided string in curly braces if it's necessary.\n         *\n         * @param {String} args - String to be wrapped.\n         * @returns {String} Wrapped string.\n         */\n        wrapArgs: function (args) {\n            if (~args.indexOf('\\\\:')) {\n                args = args.replace(colonReg, ':');\n            } else if (~args.indexOf(':') && !~args.indexOf('}')) {\n                args = '{' + args + '}';\n            }\n\n            return args;\n        },\n\n        /**\n         * Wraps child nodes of provided DOM element\n         * with knockout's comment tag.\n         *\n         * @param {HTMLElement} node - Node whose children should be wrapped.\n         * @param {String} binding - Name of the binding for the opener comment tag.\n         * @param {String} data - Data associated with a binding.\n         *\n         * @example\n         *      <div id=\"example\"><span/></div>\n         *      wrapChildren(document.getElementById('example'), 'foreach', 'data');\n         *      =>\n         *      <div id=\"example\">\n         *      <!-- ko foreach: data -->\n         *          <span></span>\n         *      <!-- /ko -->\n         *      </div>\n         */\n        wrapChildren: function (node, binding, data) {\n            var tag = this.createComment(binding, data),\n                $node = $(node);\n\n            $node.prepend(tag.open);\n            $node.append(tag.close);\n        },\n\n        /**\n         * Wraps specified node with knockout's comment tag.\n         *\n         * @param {HTMLElement} node - Node to be wrapped.\n         * @param {String} binding - Name of the binding for the opener comment tag.\n         * @param {String} data - Data associated with a binding.\n         *\n         * @example\n         *      <div id=\"example\"></div>\n         *      wrapNode(document.getElementById('example'), 'foreach', 'data');\n         *      =>\n         *      <!-- ko foreach: data -->\n         *          <div id=\"example\"></div>\n         *      <!-- /ko -->\n         */\n        wrapNode: function (node, binding, data) {\n            var tag = this.createComment(binding, data),\n                $node = $(node);\n\n            $node.before(tag.open);\n            $node.after(tag.close);\n        },\n\n        /**\n         * Creates knockouts' comment tag for the provided binding.\n         *\n         * @param {String} binding - Name of the binding.\n         * @param {String} data - Data associated with a binding.\n         * @returns {Object} Object with an open and close comment elements.\n         */\n        createComment: function (binding, data) {\n            return {\n                open: document.createComment(' ko ' + binding + ': ' + data + ' '),\n                close: document.createComment(' /ko ')\n            };\n        }\n    };\n\n    renderer.handlers = {\n\n        /**\n         * Basic node handler. Replaces custom nodes\n         * with a corresponding knockout's comment tag.\n         *\n         * @param {HTMLElement} node - Node to be processed.\n         * @param {String} data\n         * @param {Object} element\n         * @returns {Boolean} True\n         *\n         * @example Sample syntaxes conversions.\n         *      <with args=\"model\">\n         *          <span/>\n         *      </with>\n         *      =>\n         *      <!-- ko with: model-->\n         *          <span/>\n         *      <!-- /ko -->\n         */\n        node: function (node, data, element) {\n            data = renderer.wrapArgs(data);\n\n            renderer.wrapNode(node, element.binding, data);\n            $(node).replaceWith(node.childNodes);\n\n            return true;\n        },\n\n        /**\n         * Base attribute handler. Replaces custom attributes with\n         * a corresponding knockouts' data binding.\n         *\n         * @param {HTMLElement} node - Node to be processed.\n         * @param {String} data - Data associated with a binding.\n         * @param {Object} attr - Attribute definition.\n         *\n         * @example Sample syntaxes conversions.\n         *      <div text=\"label\"></div>\n         *      =>\n         *      <div data-bind=\"text: label\"></div>\n         */\n        attribute: function (node, data, attr) {\n            data = renderer.wrapArgs(data);\n\n            renderer.bindings.add(node, attr.binding, data);\n            node.removeAttribute(attr.name);\n        },\n\n        /**\n         * Wraps provided node with a knockouts' comment tag.\n         *\n         * @param {HTMLElement} node - Node that will be wrapped.\n         * @param {String} data - Data associated with a binding.\n         * @param {Object} attr - Attribute definition.\n         *\n         * @example\n         *      <div outereach=\"data\" class=\"test\"></div>\n         *      =>\n         *      <!-- ko foreach: data -->\n         *          <div class=\"test\"></div>\n         *      <!-- /ko -->\n         */\n        wrapAttribute: function (node, data, attr) {\n            data = renderer.wrapArgs(data);\n\n            renderer.wrapNode(node, attr.binding, data);\n            node.removeAttribute(attr.name);\n        }\n    };\n\n    renderer.bindings = {\n\n        /**\n         * Appends binding string to the current\n         * 'data-bind' attribute of provided node.\n         *\n         * @param {HTMLElement} node - DOM element whose 'data-bind' attribute will be extended.\n         * @param {String} name - Name of a binding.\n         * @param {String} data - Data associated with the binding.\n         */\n        add: function (node, name, data) {\n            var bindings = this.get(node);\n\n            if (bindings) {\n                bindings += ', ';\n            }\n\n            bindings += name;\n\n            if (data) {\n                bindings += ': ' + data;\n            }\n\n            this.set(node, bindings);\n        },\n\n        /**\n         * Extracts value of a 'data-bind' attribute from provided node.\n         *\n         * @param {HTMLElement} node - Node whose attribute to be extracted.\n         * @returns {String}\n         */\n        get: function (node) {\n            return node.getAttribute('data-bind') || '';\n        },\n\n        /**\n         * Sets 'data-bind' attribute of the specified node\n         * to the provided value.\n         *\n         * @param {HTMLElement} node - Node whose attribute will be altered.\n         * @param {String} bindings - New value of 'data-bind' attribute.\n         */\n        set: function (node, bindings) {\n            node.setAttribute('data-bind', bindings);\n        }\n    };\n\n    renderer\n        .addGlobal(renderer.processAttributes)\n        .addGlobal(renderer.processNodes);\n\n    /**\n     * Collection of default binding conversions.\n     */\n    preset = {\n        nodes: _.object([\n            'if',\n            'text',\n            'with',\n            'scope',\n            'ifnot',\n            'foreach',\n            'component'\n        ], Array.prototype),\n        attributes: _.object([\n            'css',\n            'attr',\n            'html',\n            'with',\n            'text',\n            'click',\n            'event',\n            'submit',\n            'enable',\n            'disable',\n            'options',\n            'visible',\n            'template',\n            'hasFocus',\n            'textInput',\n            'component',\n            'uniqueName',\n            'optionsText',\n            'optionsValue',\n            'checkedValue',\n            'selectedOptions'\n        ], Array.prototype)\n    };\n\n    _.extend(preset.attributes, {\n        if: renderer.handlers.wrapAttribute,\n        ifnot: renderer.handlers.wrapAttribute,\n        innerif: {\n            binding: 'if'\n        },\n        innerifnot: {\n            binding: 'ifnot'\n        },\n        outereach: {\n            binding: 'foreach',\n            handler: renderer.handlers.wrapAttribute\n        },\n        foreach: {\n            name: 'each'\n        },\n        value: {\n            name: 'ko-value'\n        },\n        style: {\n            name: 'ko-style'\n        },\n        checked: {\n            name: 'ko-checked'\n        },\n        disabled: {\n            name: 'ko-disabled',\n            binding: 'disable'\n        },\n        focused: {\n            name: 'ko-focused',\n            binding: 'hasFocus'\n        },\n\n        /**\n         * Custom 'render' attribute handler function. Wraps child elements\n         * of a node with knockout's 'ko template:' comment tag.\n         *\n         * @param {HTMLElement} node - Element to be processed.\n         * @param {String} data - Data specified in 'render' attribute of a node.\n         */\n        render: function (node, data) {\n            data = data || 'getTemplate()';\n            data = renderer.wrapArgs(data);\n\n            renderer.wrapChildren(node, 'template', data);\n            node.removeAttribute('render');\n        }\n    });\n\n    _.extend(preset.nodes, {\n        foreach: {\n            name: 'each'\n        },\n\n        /**\n         * Custom 'render' node handler function.\n         * Replaces node with knockout's 'ko template:' comment tag.\n         *\n         * @param {HTMLElement} node - Element to be processed.\n         * @param {String} data - Data specified in 'args' attribute of a node.\n         */\n        render: function (node, data) {\n            data = data || 'getTemplate()';\n            data = renderer.wrapArgs(data);\n\n            renderer.wrapNode(node, 'template', data);\n            $(node).replaceWith(node.childNodes);\n        }\n    });\n\n    _.each(preset.attributes, function (data, id) {\n        renderer.addAttribute(id, data);\n    });\n\n    _.each(preset.nodes, function (data, id) {\n        renderer.addNode(id, data);\n    });\n\n    return renderer;\n});\n","Magento_Ui/js/lib/logger/console-logger.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    './logger',\n    './entry-factory',\n    './console-output-handler',\n    './formatter',\n    './message-pool',\n    './levels-pool',\n    'Magento_Ui/js/lib/core/storage/local',\n    'underscore',\n    './logger-utils'\n], function (Logger, entryFactory, ConsoleHandler, Formatter, messagePoll, levelsPoll, storage, _, LoggerUtils) {\n    'use strict';\n\n    var STORAGE_NAMESPACE = 'CONSOLE_LOGGER';\n\n    /**\n     * Singleton Logger's sub-class instance of which is configured to display its\n     * messages to the console. It also provides the support of predefined messages\n     * and persists its display level.\n     */\n    function ConsoleLogger() {\n        var formatter = new Formatter(),\n            consoleHandler = new ConsoleHandler(formatter),\n            savedLevel = storage.get(STORAGE_NAMESPACE),\n            utils = new LoggerUtils(this);\n\n        Logger.call(this, consoleHandler, entryFactory);\n\n        if (savedLevel) {\n            this.displayLevel_ = savedLevel;\n        }\n\n        this.utils = utils;\n        this.messages = messagePoll;\n        this.levels = levelsPoll.getLevels();\n    }\n\n    _.extend(ConsoleLogger, Logger);\n\n    ConsoleLogger.prototype = Object.create(Logger.prototype);\n    ConsoleLogger.prototype.constructor = ConsoleLogger;\n\n    /**\n     * Overrides parent method to save the provided display level.\n     *\n     * @override\n     */\n    ConsoleLogger.prototype.setDisplayLevel = function (level) {\n        Logger.prototype.setDisplayLevel.call(this, level);\n\n        storage.set(STORAGE_NAMESPACE, level);\n    };\n\n    /**\n     * Adds the support of predefined messages.\n     *\n     * @protected\n     * @override\n     */\n    ConsoleLogger.prototype.createEntry_ = function (message, level, data) {\n        var code;\n\n        if (messagePoll.hasMessage(message)) {\n            data = data || {};\n            code = message;\n            message = messagePoll.getMessage(code);\n\n            data.messageCode = code;\n        }\n\n        return Logger.prototype.createEntry_.call(this, message, level, data);\n    };\n\n    return new ConsoleLogger();\n});\n","Magento_Ui/js/lib/logger/console-output-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    './levels-pool'\n], function (logLevels) {\n    'use strict';\n\n    var levels = logLevels.getLevels();\n\n    /**\n     * @param {LogFormatter} formatter\n     */\n    function ConsoleOutputHandler(formatter) {\n        /**\n         * @protected\n         * @type {LogFormatter}\n         */\n        this.formatter_ = formatter;\n    }\n\n    /**\n     * Display data of the provided entry to the console.\n     *\n     * @param {LogEntry} entry - Entry to be displayed.\n     */\n    ConsoleOutputHandler.prototype.show = function (entry) {\n        var displayString = this.formatter_.process(entry);\n\n        switch (entry.level) {\n            case levels.ERROR:\n                console.error(displayString);\n                break;\n\n            case levels.WARN:\n                console.warn(displayString);\n                break;\n\n            case levels.INFO:\n                console.info(displayString);\n                break;\n\n            case levels.DEBUG:\n                console.log(displayString);\n                break;\n        }\n    };\n\n    /**\n     * Displays the array of entries.\n     *\n     * @param {Array<LogEntry>} entries\n     */\n    ConsoleOutputHandler.prototype.dump = function (entries) {\n        entries.forEach(this.show, this);\n    };\n\n    return ConsoleOutputHandler;\n});\n","Magento_Ui/js/lib/logger/entry-factory.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    './entry'\n], function (LogEntry) {\n    'use strict';\n\n    return {\n        /**\n         * @param {String} message\n         * @param {Number} level\n         * @param {Object} [messageData]\n         * @returns {LogEntry}\n         */\n        createEntry: function (message, level, messageData) {\n            return new LogEntry(message, level, messageData);\n        }\n    };\n});\n","Magento_Ui/js/lib/logger/entry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    './levels-pool'\n], function (logLevels) {\n    'use strict';\n\n    /**\n     * @param {String} message\n     * @param {Number} level\n     * @param {Object} [data]\n     */\n    function LogEntry(message, level, data) {\n        /**\n         * @readonly\n         * @type {Number}\n         */\n        this.timestamp = Date.now();\n\n        /**\n         * @readonly\n         * @type {Number}\n         */\n        this.level = level;\n\n        /**\n         * @readonly\n         * @type {String}\n         */\n        this.levelName = logLevels.getNameByCode(level);\n\n        /**\n         * @readonly\n         * @type {Object}\n         */\n        this.data = data;\n\n        /**\n         * @readonly\n         * @type {String}\n         */\n        this.message = message;\n    }\n\n    return LogEntry;\n});\n","Magento_Ui/js/lib/logger/formatter.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'moment',\n    'mage/utils/template'\n], function (moment, mageTemplate) {\n    'use strict';\n\n    /**\n     * @param {String} dateFormat\n     * @param {String} template\n     */\n    function LogFormatter(dateFormat, template) {\n        /**\n         * @protected\n         * @type {String}\n         */\n        this.dateFormat_ = 'YYYY-MM-DD hh:mm:ss';\n\n        /**\n         * @protected\n         * @type {String}\n         */\n        this.template_ = '[${ $.date }] [${ $.entry.levelName }] ${ $.message }';\n\n        if (dateFormat) {\n            this.dateFormat_ = dateFormat;\n        }\n\n        if (template) {\n            this.template_ = template;\n        }\n    }\n\n    /**\n     * @param {LogEntry} entry\n     * @returns {String}\n     */\n    LogFormatter.prototype.process = function (entry) {\n        var message = mageTemplate.template(entry.message, entry.data),\n            date = moment(entry.timestamp).format(this.dateFormat_);\n\n        return mageTemplate.template(this.template_, {\n            date: date,\n            entry: entry,\n            message: message\n        });\n    };\n\n    return LogFormatter;\n});\n","Magento_Ui/js/lib/logger/levels-pool.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    var LEVELS,\n        CODE_MAP;\n\n    LEVELS = {\n        NONE: 0,\n        ERROR: 1,\n        WARN: 2,\n        INFO: 3,\n        DEBUG: 4,\n        ALL: 5\n    };\n\n    CODE_MAP = _.invert(LEVELS);\n\n    return {\n        /**\n         * Returns the list of available log levels.\n         *\n         * @returns {Object}\n         */\n        getLevels: function () {\n            return LEVELS;\n        },\n\n        /**\n         * Returns name of the log level that matches to the provided code.\n         *\n         * @returns {String}\n         */\n        getNameByCode: function (code) {\n            return CODE_MAP[code];\n        }\n    };\n});\n","Magento_Ui/js/lib/logger/logger-utils.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    /**\n     * Utils methods for logger\n     * @param {Logger} logger\n     */\n    function LogUtils(logger) {\n        this.logger = logger;\n\n    }\n\n    /**\n     * Method for logging asynchronous operations\n     * @param {Promise} promise\n     * @param {Object} config\n     */\n    LogUtils.prototype.asyncLog = function (promise, config) {\n        var levels,\n            messages,\n            wait;\n\n        config = config || {};\n        levels = config.levels || this.createLevels();\n        messages = config.messages || this.createMessages();\n        wait = config.wait || 5000;\n\n        this.logger[levels.requested](messages.requested, config.data);\n        setTimeout(function () {\n            promise.state() === 'pending' ?\n                this.logger[levels.failed](messages.failed, config.data) :\n                this.logger[levels.loaded](messages.loaded, config.data);\n        }.bind(this), wait);\n    };\n\n    /**\n     * Method that creates object of messages\n     * @param {String} requested - log message that showing that request for class is started\n     * @param {String} loaded - log message that show when requested class is loaded\n     * @param {String} failed - log message that show when requested class is failed\n     * @returns {Object}\n     */\n    LogUtils.prototype.createMessages = function (requested, loaded, failed) {\n        return {\n            requested: requested || '',\n            loaded: loaded || '',\n            failed: failed || ''\n        };\n    };\n\n    /**\n     * Method that creates object of log levels\n     * @param {String} requested - log message that showing that request for class is started\n     * @param {String} loaded - log message that show when requested class is loaded\n     * @param {String} failed - log message that show when requested class is failed\n     * @returns {Object}\n     */\n    LogUtils.prototype.createLevels = function (requested, loaded, failed) {\n        return {\n            requested: requested || 'info',\n            loaded: loaded || 'info',\n            failed: failed || 'warn'\n        };\n    };\n\n    return LogUtils;\n});\n","Magento_Ui/js/lib/logger/logger.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    './levels-pool'\n], function (logLevels) {\n    'use strict';\n\n    var levels = logLevels.getLevels();\n\n    /**\n     * @param {LogOutputHandler} outputHandler\n     * @param {LogEntryFactory} entryFactory\n     */\n    function Logger(outputHandler, entryFactory) {\n        /**\n         * An array of log entries.\n         *\n         * @protected\n         * @type {Array<LogEntry>}\n         */\n        this.entries_ = [];\n\n        /**\n         * Current display level.\n         *\n         * @protected\n         * @type {Number}\n         */\n        this.displayLevel_ = levels.ERROR;\n\n        /**\n         * An array of display criteria.\n         *\n         * @protected\n         * @type {Array<LogCriteria>}\n         */\n        this.displayCriteria_ = [];\n\n        /**\n         * @protected\n         * @type {LogEntryFactory}\n         */\n        this.entryFactory_ = entryFactory;\n\n        /**\n         * @protected\n         * @type {Array<LogOutputHandler>}\n         */\n        this.outputHandlers_ = [outputHandler];\n\n        this.addDisplayCriteria(this.matchesLevel_);\n    }\n\n    /**\n     * Swaps current display level with the provided one.\n     *\n     * @param {Number} level - Level's code.\n     */\n    Logger.prototype.setDisplayLevel = function (level) {\n        var levelName = logLevels.getNameByCode(level);\n\n        if (!levelName) {\n            throw new TypeError('The provided level is not defined in the levels list.');\n        }\n\n        this.displayLevel_ = level;\n    };\n\n    /**\n     * Sets up the criteria by which log entries will be filtered out from the output.\n     *\n     * @param {LogCriteria} criteria\n     */\n    Logger.prototype.addDisplayCriteria = function (criteria) {\n        this.displayCriteria_.push(criteria);\n    };\n\n    /**\n     * Removes previously defined criteria.\n     *\n     * @param {LogCriteria} criteria\n     */\n    Logger.prototype.removeDisplayCriteria = function (criteria) {\n        var index = this.displayCriteria_.indexOf(criteria);\n\n        if (~index) {\n            this.displayCriteria_.splice(index, 1);\n        }\n    };\n\n    /**\n     * @param {String} message\n     * @param {Object} [messageData]\n     * @returns {LogEntry}\n     */\n    Logger.prototype.error = function (message, messageData) {\n        return this.log_(message, levels.ERROR, messageData);\n    };\n\n    /**\n     * @param {String} message\n     * @param {Object} [messageData]\n     * @returns {LogEntry}\n     */\n    Logger.prototype.warn = function (message, messageData) {\n        return this.log_(message, levels.WARN, messageData);\n    };\n\n    /**\n     * @param {String} message\n     * @param {Object} [messageData]\n     * @returns {LogEntry}\n     */\n    Logger.prototype.info = function (message, messageData) {\n        return this.log_(message, levels.INFO, messageData);\n    };\n\n    /**\n     * @param {String} message\n     * @param {Object} [messageData]\n     * @returns {LogEntry}\n     */\n    Logger.prototype.debug = function (message, messageData) {\n        return this.log_(message, levels.DEBUG, messageData);\n    };\n\n    /**\n     * @protected\n     * @param {String} message\n     * @param {Number} level\n     * @param {Object} [messageData]\n     * @returns {LogEntry}\n     */\n    Logger.prototype.log_ = function (message, level, messageData) {\n        var entry = this.createEntry_(message, level, messageData);\n\n        this.entries_.push(entry);\n\n        if (this.matchesCriteria_(entry)) {\n            this.processOutput_(entry);\n        }\n\n        return entry;\n    };\n\n    /**\n     * @protected\n     * @param {String} message\n     * @param {Number} level\n     * @param {Object} [messageData]\n     * @returns {LogEntry}\n     */\n    Logger.prototype.createEntry_ = function (message, level, messageData) {\n        return this.entryFactory_.createEntry(message, level, messageData);\n    };\n\n    /**\n     * Returns an array of log entries that have been added to the logger.\n     *\n     * @param {LogCriteria} [criteria] - Optional filter criteria.\n     * @returns {Array<LogEntry>}\n     */\n    Logger.prototype.getEntries = function (criteria) {\n        if (criteria) {\n            return this.entries_.filter(criteria);\n        }\n\n        return this.entries_;\n    };\n\n    /**\n     * @param {LogCriteria} [criteria]\n     */\n    Logger.prototype.dump = function (criteria) {\n        var entries;\n\n        if (!criteria) {\n            criteria = this.matchesCriteria_;\n        }\n\n        entries = this.entries_.filter(criteria, this);\n\n        this.outputHandlers_.forEach(function (handler) {\n            handler.dump(entries);\n        });\n    };\n\n    /**\n     * @protected\n     * @param {LogEntry} entry\n     */\n    Logger.prototype.processOutput_ = function (entry) {\n        this.outputHandlers_.forEach(function (handler) {\n            handler.show(entry);\n        });\n    };\n\n    /**\n     * @protected\n     * @param {LogEntry} entry\n     * @returns {Boolean}\n     */\n    Logger.prototype.matchesCriteria_ = function (entry) {\n        return this.displayCriteria_.every(function (criteria) {\n            return criteria.call(this, entry);\n        }, this);\n    };\n\n    /**\n     * Checks that the level of provided entry passes the \"displayLevel_\" threshold.\n     *\n     * @protected\n     * @param {LogEntry} entry - Entry to be checked.\n     * @returns {Boolean}\n     */\n    Logger.prototype.matchesLevel_ = function (entry) {\n        return entry.level <= this.displayLevel_;\n    };\n\n    return Logger;\n});\n","Magento_Ui/js/lib/logger/message-pool.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(function () {\n    'use strict';\n\n    var MESSAGES = {\n        templateStartLoading:\n            'The \"${ $.template }\" template requested by  the \"${$.component}\" component started loading.',\n        templateLoadedFromServer:\n            'The \"${ $.template }\" template requested by the \"${$.component}\" component  was loaded from server.\"',\n        templateLoadedFromCache:\n            'The \"${ $.template }\" template  requested by the \"${$.component}\" component was loaded from cache.\"',\n        templateLoadingFail: 'Failed to load the \"${ $.template }\" template requested by \"${$.component}\".',\n        componentStartInitialization:\n            'Component \"${$.component}\" start initialization with instance name \"${$.componentName}\".',\n        componentStartLoading: ' Started loading the \"${$.component}\" component.',\n        componentFinishLoading: 'The \"${$.component}\" component was loaded.',\n        componentLoadingFail: 'Failed to load the \"${$.component}\" component.',\n        depsLoadingFail: 'Could not get the declared \"${$.deps}\" dependency for the \"${$.component}\" instance.',\n        depsStartRequesting: 'Requesting the \"${$.deps}\" dependency for the \"${$.component}\" instance.',\n        depsFinishRequesting: 'The \"${$.deps}\" dependency for the \"${$.component}\" instance was received.',\n        requestingComponent: 'Requesting the \"${$.component}\" component.',\n        requestingComponentIsLoaded: 'The requested \"${$.component}\" component was received.',\n        requestingComponentIsFailed: 'Could not get the requested \"${$.component}\" component.'\n    };\n\n    return {\n        /**\n         * Returns message that matches the provided code.\n         *\n         * @param {String} code - Message's identifier\n         * @returns {String}\n         */\n        getMessage: function (code) {\n            return MESSAGES[code];\n        },\n\n        /**\n         * Adds a new message to the poll.\n         *\n         * @param {String} code - Message's identifier.\n         * @param {String} message - Text of the message\n         */\n        addMessage: function (code, message) {\n            MESSAGES[code] = message;\n        },\n\n        /**\n         * Tells whether message with provide code exists in the poll.\n         *\n         * @param {String} code - Message's identifier.\n         * @returns {Boolean}\n         */\n        hasMessage: function (code) {\n            return MESSAGES.hasOwnProperty(code);\n        }\n    };\n});\n","Magento_Ui/js/lib/registry/registry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore'\n], function ($, _) {\n    'use strict';\n\n    var privateData = new WeakMap();\n\n    /**\n     * Extracts private item storage associated\n     * with a provided registry instance.\n     *\n     * @param {Object} container\n     * @returns {Object}\n     */\n    function getItems(container) {\n        return privateData.get(container).items;\n    }\n\n    /**\n     * Extracts private requests array associated\n     * with a provided registry instance.\n     *\n     * @param {Object} container\n     * @returns {Array}\n     */\n    function getRequests(container) {\n        return privateData.get(container).requests;\n    }\n\n    /**\n     * Wrapper function used for convenient access to the elements.\n     * See 'async' method for examples of usage and comparison\n     * with a regular 'get' method.\n     *\n     * @param {(String|Object|Function)} name - Key of the requested element.\n     * @param {Registry} registry - Instance of a registry\n     *      where to search for the element.\n     * @param {(Function|String)} [method] - Optional callback function\n     *      or a name of the elements' method which\n     *      will be invoked when element is available in registry.\n     * @returns {*}\n     */\n    function async(name, registry, method) {\n        var args = _.toArray(arguments).slice(3);\n\n        if (_.isString(method)) {\n            registry.get(name, function (component) {\n                component[method].apply(component, args);\n            });\n        } else if (_.isFunction(method)) {\n            registry.get(name, method);\n        } else if (!args.length) {\n            return registry.get(name);\n        }\n    }\n\n    /**\n     * Checks that every property of the query object\n     * is present and equal to the corresponding\n     * property in target object.\n     * Note that non-strict comparison is used.\n     *\n     * @param {Object} query - Query object.\n     * @param {Object} target - Target object.\n     * @returns {Boolean}\n     */\n    function compare(query, target) {\n        var matches = true,\n            index,\n            keys,\n            key;\n\n        if (!_.isObject(query) || !_.isObject(target)) {\n            return false;\n        }\n\n        keys = Object.getOwnPropertyNames(query);\n        index = keys.length;\n\n        while (matches && index--) {\n            key = keys[index];\n\n            /* eslint-disable eqeqeq */\n            if (target[key] != query[key]) {\n                matches = false;\n            }\n\n            /* eslint-enable eqeqeq */\n        }\n\n        return matches;\n    }\n\n    /**\n     * Explodes incoming string into object if\n     * string is defined as a set of key = value pairs.\n     *\n     * @param {(String|*)} query - String to be processed.\n     * @returns {Object|*} Either created object or an unmodified incoming\n     *      value if conversion was not possible.\n     * @example Sample conversions.\n     *      'key = value, key2 = value2'\n     *      => {key: 'value', key2: 'value2'}\n     */\n    function explode(query) {\n        var result = {},\n            index,\n            data;\n\n        if (typeof query !== 'string' || !~query.indexOf('=')) {\n            return query;\n        }\n\n        query = query.split(',');\n        index = query.length;\n\n        while (index--) {\n            data = query[index].split('=');\n\n            result[data[0].trim()] = data[1].trim();\n        }\n\n        return result;\n    }\n\n    /**\n     * Extracts items from the provided data object\n     * which matches specified search criteria.\n     *\n     * @param {Object} data - Data object where to perform a lookup.\n     * @param {(String|Object|Function)} query - Search criteria.\n     * @param {Boolean} findAll - Flag that defines whether to\n     *      search for all applicable items or to stop on a first found entry.\n     * @returns {Array|Object|*}\n     */\n    function find(data, query, findAll) {\n        var iterator,\n            item;\n\n        query = explode(query);\n\n        if (typeof query === 'string') {\n            item = data[query];\n\n            if (findAll) {\n                return item ? [item] : [];\n            }\n\n            return item;\n        }\n\n        iterator = !_.isFunction(query) ?\n            compare.bind(null, query) :\n            query;\n\n        return findAll ?\n            _.filter(data, iterator) :\n            _.find(data, iterator);\n    }\n\n    /**\n     * @constructor\n     */\n    function Registry() {\n        var data = {\n            items: {},\n            requests: []\n        };\n\n        this._updateRequests = _.debounce(this._updateRequests.bind(this), 10);\n        privateData.set(this, data);\n    }\n\n    Registry.prototype = {\n        constructor: Registry,\n\n        /**\n         * Retrieves item from registry which matches specified search criteria.\n         *\n         * @param {(Object|String|Function|Array)} query - Search condition (see examples).\n         * @param {Function} [callback] - Callback that will be invoked when\n         *      all of the requested items are available.\n         * @returns {*}\n         *\n         * @example Requesting item by it's name.\n         *      var obj = {index: 'test', sample: true};\n         *\n         *      registry.set('first', obj);\n         *      registry.get('first') === obj;\n         *      => true\n         *\n         * @example Requesting item with a specific properties.\n         *      registry.get('sample = 1, index = test') === obj;\n         *      => true\n         *      registry.get('sample = 0, index = foo') === obj;\n         *      => false\n         *\n         * @example Declaring search criteria as an object.\n         *      registry.get({sample: true}) === obj;\n         *      => true;\n         *\n         * @example Providing custom search handler.\n         *      registry.get(function (item) { return item.sample === true; }) === obj;\n         *      => true\n         *\n         * @example Sample asynchronous request declaration.\n         *      registry.get('index = test', function (item) {});\n         *\n         * @example Requesting multiple elements.\n         *      registry.set('second', {index: 'test2'});\n         *      registry.get(['first', 'second'], function (first, second) {});\n         */\n        get: function (query, callback) {\n            if (typeof callback !== 'function') {\n                return find(getItems(this), query);\n            }\n\n            this._addRequest(query, callback);\n        },\n\n        /**\n         * Sets provided item to the registry.\n         *\n         * @param {String} id - Item's identifier.\n         * @param {*} item - Item's data.\n         * returns {Registry} Chainable.\n         */\n        set: function (id, item) {\n            getItems(this)[id] = item;\n\n            this._updateRequests();\n\n            return this;\n        },\n\n        /**\n         * Removes specified item from registry.\n         * Note that search query is not applicable.\n         *\n         * @param {String} id - Item's identifier.\n         * @returns {Registry} Chainable.\n         */\n        remove: function (id) {\n            delete getItems(this)[id];\n\n            return this;\n        },\n\n        /**\n         * Retrieves a collection of elements that match\n         * provided search criteria.\n         *\n         * @param {(Object|String|Function)} query - Search query.\n         *      See 'get' method for the syntax examples.\n         * @returns {Array} Found elements.\n         */\n        filter: function (query) {\n            return find(getItems(this), query, true);\n        },\n\n        /**\n         * Checks that at least one element in collection\n         * matches provided search criteria.\n         *\n         * @param {(Object|String|Function)} query - Search query.\n         *      See 'get' method for the syntax examples.\n         * @returns {Boolean}\n         */\n        has: function (query) {\n            return !!this.get(query);\n        },\n\n        /**\n         * Checks that registry contains a provided item.\n         *\n         * @param {*} item - Item to be checked.\n         * @returns {Boolean}\n         */\n        contains: function (item) {\n            return _.contains(getItems(this), item);\n        },\n\n        /**\n         * Extracts identifier of an item if it's present in registry.\n         *\n         * @param {*} item - Item whose identifier will be extracted.\n         * @returns {String|Undefined}\n         */\n        indexOf: function (item) {\n            return _.findKey(getItems(this), function (elem) {\n                return item === elem;\n            });\n        },\n\n        /**\n         * Same as a 'get' method except that it returns\n         * a promise object instead of invoking provided callback.\n         *\n         * @param {(String|Function|Object|Array)} query - Search query.\n         *      See 'get' method for the syntax examples.\n         * @returns {jQueryPromise}\n         */\n        promise: function (query) {\n            var defer    = $.Deferred(),\n                callback = defer.resolve.bind(defer);\n\n            this.get(query, callback);\n\n            return defer.promise();\n        },\n\n        /**\n         * Creates a wrapper function over the provided search query\n         * in order to provide somehow more convenient access to the\n         * registry's items.\n         *\n         * @param {(String|Object|Function)} query - Search criteria.\n         *      See 'get' method for the syntax examples.\n         * @returns {Function}\n         *\n         * @example Comparison with a 'get' method on retrieving items.\n         *      var module = registry.async('name');\n         *\n         *      module();\n         *      => registry.get('name');\n         *\n         * @example Asynchronous request.\n         *      module(function (component) {});\n         *      => registry.get('name', function (component) {});\n         *\n         * @example Requesting item and invoking it's method with specified parameters.\n         *      module('trigger', true);\n         *      => registry.get('name', function (component) {\n         *          component.trigger(true);\n         *      });\n         */\n        async: function (query) {\n            return async.bind(null, query, this);\n        },\n\n        /**\n         * Creates new instance of a Registry.\n         *\n         * @returns {Registry} New instance.\n         */\n        create: function () {\n            return new Registry;\n        },\n\n        /**\n         * Adds new request to the queue or resolves it immediately\n         * if all of the required items are available.\n         *\n         * @private\n         * @param {(Object|String|Function|Array)} queries - Search criteria.\n         *      See 'get' method for the syntax examples.\n         * @param {Function} callback - Callback that will be invoked when\n         *      all of the requested items are available.\n         * @returns {Registry}\n         */\n        _addRequest: function (queries, callback) {\n            var request;\n\n            if (!Array.isArray(queries)) {\n                queries = queries ? [queries] : [];\n            }\n\n            request = {\n                queries: queries.map(explode),\n                callback: callback\n            };\n\n            this._canResolve(request) ?\n                this._resolveRequest(request) :\n                getRequests(this).push(request);\n\n            return this;\n        },\n\n        /**\n         * Updates requests list resolving applicable items.\n         *\n         * @private\n         * @returns {Registry} Chainable.\n         */\n        _updateRequests: function () {\n            getRequests(this)\n                .filter(this._canResolve, this)\n                .forEach(this._resolveRequest, this);\n\n            return this;\n        },\n\n        /**\n         * Resolves provided request invoking it's callback\n         * with items specified in query parameters.\n         *\n         * @private\n         * @param {Object} request - Request object.\n         * @returns {Registry} Chainable.\n         */\n        _resolveRequest: function (request) {\n            var requests = getRequests(this),\n                items    = request.queries.map(this.get, this),\n                index    = requests.indexOf(request);\n\n            request.callback.apply(null, items);\n\n            if (~index) {\n                requests.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Checks if provided request can be resolved.\n         *\n         * @private\n         * @param {Object} request - Request object.\n         * @returns {Boolean}\n         */\n        _canResolve: function (request) {\n            var queries = request.queries;\n\n            return queries.every(this.has, this);\n        }\n    };\n\n    return new Registry;\n});\n","Magento_Ui/js/lib/validation/rules.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    './utils',\n    'moment',\n    'tinycolor',\n    'jquery/validate',\n    'mage/translate'\n], function ($, _, utils, moment, tinycolor) {\n    'use strict';\n\n    /**\n     * validate credit card number using mod10\n     * @param {String} s\n     * @return {Boolean}\n     */\n    function validateCreditCard(s) {\n        // remove non-numerics\n        var v = '0123456789',\n            w = '',\n            i, j, k, m, c, a, x;\n\n        for (i = 0; i < s.length; i++) {\n            x = s.charAt(i);\n\n            if (v.indexOf(x, 0) !== -1) {\n                w += x;\n            }\n        }\n        // validate number\n        j = w.length / 2;\n        k = Math.floor(j);\n        m = Math.ceil(j) - k;\n        c = 0;\n\n        for (i = 0; i < k; i++) {\n            a = w.charAt(i * 2 + m) * 2;\n            c += a > 9 ? Math.floor(a / 10 + a % 10) : a;\n        }\n\n        for (i = 0; i < k + m; i++) {\n            c += w.charAt(i * 2 + 1 - m) * 1;\n        }\n\n        return c % 10 === 0;\n    }\n\n    /**\n     * Collection of validation rules including rules from additional-methods.js\n     * @type {Object}\n     */\n    return _.mapObject({\n        'min_text_length': [\n            function (value, params) {\n                return _.isUndefined(value) || value.length === 0 || value.length >= +params;\n            },\n            $.mage.__('Please enter more or equal than {0} symbols.')\n        ],\n        'max_text_length': [\n            function (value, params) {\n                return !_.isUndefined(value) && value.length <= +params;\n            },\n            $.mage.__('Please enter less or equal than {0} symbols.')\n        ],\n        'max-words': [\n            function (value, params) {\n                return utils.isEmpty(value) || utils.stripHtml(value).match(/\\b\\w+\\b/g).length < params;\n            },\n            $.mage.__('Please enter {0} words or less.')\n        ],\n        'min-words': [\n            function (value, params) {\n                return utils.isEmpty(value) || utils.stripHtml(value).match(/\\b\\w+\\b/g).length >= params;\n            },\n            $.mage.__('Please enter at least {0} words.')\n        ],\n        'range-words': [\n            function (value, params) {\n                var match = utils.stripHtml(value).match(/\\b\\w+\\b/g) || [];\n\n                return utils.isEmpty(value) || match.length >= params[0] &&\n                    match.length <= params[1];\n            },\n            $.mage.__('Please enter between {0} and {1} words.')\n        ],\n        'letters-with-basic-punc': [\n            function (value) {\n                return utils.isEmpty(value) || /^[a-z\\-.,()\\u0027\\u0022\\s]+$/i.test(value);\n            },\n            $.mage.__('Letters or punctuation only please')\n        ],\n        'alphanumeric': [\n            function (value) {\n                return utils.isEmpty(value) || /^\\w+$/i.test(value);\n            },\n            $.mage.__('Letters, numbers, spaces or underscores only please')\n        ],\n        'letters-only': [\n            function (value) {\n                return utils.isEmpty(value) || /^[a-z]+$/i.test(value);\n            },\n            $.mage.__('Letters only please')\n        ],\n        'no-whitespace': [\n            function (value) {\n                return utils.isEmpty(value) || /^\\S+$/i.test(value);\n            },\n            $.mage.__('No white space please')\n        ],\n        'no-marginal-whitespace': [\n            function (value) {\n                return !/^\\s+|\\s+$/i.test(value);\n            },\n            $.mage.__('No marginal white space please')\n        ],\n        'zip-range': [\n            function (value) {\n                return utils.isEmpty(value) || /^90[2-5]-\\d{2}-\\d{4}$/.test(value);\n            },\n            $.mage.__('Your ZIP-code must be in the range 902xx-xxxx to 905-xx-xxxx')\n        ],\n        'integer': [\n            function (value) {\n                return utils.isEmpty(value) || /^-?\\d+$/.test(value);\n            },\n            $.mage.__('A positive or negative non-decimal number please')\n        ],\n        'vinUS': [\n            function (value) {\n                if (utils.isEmpty(value)) {\n                    return true;\n                }\n\n                if (value.length !== 17) {\n                    return false;\n                }\n                var i, n, d, f, cd, cdv,//eslint-disable-line vars-on-top\n                    LL = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'],//eslint-disable-line max-len\n                    VL = [1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 7, 9, 2, 3, 4, 5, 6, 7, 8, 9],\n                    FL = [8, 7, 6, 5, 4, 3, 2, 10, 0, 9, 8, 7, 6, 5, 4, 3, 2],\n                    rs = 0;\n\n                for (i = 0; i < 17; i++) {\n                    f = FL[i];\n                    d = value.slice(i, i + 1);\n\n                    if (i === 8) {\n                        cdv = d;\n                    }\n\n                    if (!isNaN(d)) {\n                        d *= f;\n                    } else {\n                        for (n = 0; n < LL.length; n++) {//eslint-disable-line max-depth\n                            if (d.toUpperCase() === LL[n]) {//eslint-disable-line max-depth\n                                d = VL[n];\n                                d *= f;\n\n                                if (isNaN(cdv) && n === 8) {//eslint-disable-line max-depth\n                                    cdv = LL[n];\n                                }\n                                break;\n                            }\n                        }\n                    }\n                    rs += d;\n                }\n                cd = rs % 11;\n\n                if (cd === 10) {\n                    cd = 'X';\n                }\n\n                if (cd === cdv) {\n                    return true;\n                }\n\n                return false;\n            },\n            $.mage.__('The specified vehicle identification number (VIN) is invalid.')\n        ],\n        'dateITA': [\n            function (value) {\n                var check = false,\n                    re = /^\\d{1,2}\\/\\d{1,2}\\/\\d{4}$/,\n                    adata, gg, mm, aaaa, xdata;\n\n                if (re.test(value)) {\n                    adata = value.split('/');\n                    gg = parseInt(adata[0], 10);\n                    mm = parseInt(adata[1], 10);\n                    aaaa = parseInt(adata[2], 10);\n                    xdata = new Date(aaaa, mm - 1, gg);\n\n                    if (xdata.getFullYear() === aaaa &&\n                        xdata.getMonth() === mm - 1 &&\n                        xdata.getDate() === gg\n                    ) {\n                        check = true;\n                    } else {\n                        check = false;\n                    }\n                } else {\n                    check = false;\n                }\n\n                return check;\n            },\n            $.mage.__('Please enter a correct date')\n        ],\n        'dateNL': [\n            function (value) {\n                return /^\\d\\d?[\\.\\/-]\\d\\d?[\\.\\/-]\\d\\d\\d?\\d?$/.test(value);\n            },\n            $.mage.__('Vul hier een geldige datum in.')\n        ],\n        'time': [\n            function (value) {\n                return utils.isEmpty(value) || /^([01]\\d|2[0-3])(:[0-5]\\d){0,2}$/.test(value);\n            },\n            $.mage.__('Please enter a valid time, between 00:00 and 23:59')\n        ],\n        'time12h': [\n            function (value) {\n                return utils.isEmpty(value) || /^((0?[1-9]|1[012])(:[0-5]\\d){0,2}(\\s[AP]M))$/i.test(value);\n            },\n            $.mage.__('Please enter a valid time, between 00:00 am and 12:00 pm')\n        ],\n        'phoneUS': [\n            function (value) {\n                value = value.replace(/\\s+/g, '');\n\n                return utils.isEmpty(value) || value.length > 9 &&\n                    value.match(/^(1-?)?(\\([2-9]\\d{2}\\)|[2-9]\\d{2})-?[2-9]\\d{2}-?\\d{4}$/);\n            },\n            $.mage.__('Please specify a valid phone number')\n        ],\n        'phoneUK': [\n            function (value) {\n                return utils.isEmpty(value) || value.length > 9 &&\n                    value.match(/^(\\(?(0|\\+44)[1-9]{1}\\d{1,4}?\\)?\\s?\\d{3,4}\\s?\\d{3,4})$/);\n            },\n            $.mage.__('Please specify a valid phone number')\n        ],\n        'mobileUK': [\n            function (value) {\n                return utils.isEmpty(value) || value.length > 9 && value.match(/^((0|\\+44)7\\d{3}\\s?\\d{6})$/);\n            },\n            $.mage.__('Please specify a valid mobile number')\n        ],\n        'stripped-min-length': [\n            function (value, param) {\n                return _.isUndefined(value) || value.length === 0 || utils.stripHtml(value).length >= param;\n            },\n            $.mage.__('Please enter at least {0} characters')\n        ],\n        'email2': [\n            function (value) {\n                return utils.isEmpty(value) || /^((([a-z]|\\d|[!#\\$%&\\u0027\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z]|\\d|[!#\\$%&\\u0027\\*\\+\\-\\/=\\?\\^_`{\\|}~]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*)|((\\u0022)((((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(([\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x7f]|\\x21|[\\x23-\\x5b]|[\\x5d-\\x7e]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(\\\\([\\x01-\\x09\\x0b\\x0c\\x0d-\\x7f]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]))))*(((\\x20|\\x09)*(\\x0d\\x0a))?(\\x20|\\x09)+)?(\\u0022)))@((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)*(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?$/i.test(value);//eslint-disable-line max-len\n            },\n            $.validator.messages.email\n        ],\n        'url2': [\n            function (value) {\n                return utils.isEmpty(value) || /^(https?|ftp):\\/\\/(((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:)*@)?(((\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d\\d|2[0-4]\\d|25[0-5]))|((([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|\\d|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.)*(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])*([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])))\\.?)(:\\d*)?)(\\/((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)+(\\/(([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)*)*)?)?(\\?((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)|[\\uE000-\\uF8FF]|\\/|\\?)*)?(\\#((([a-z]|\\d|-|\\.|_|~|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])|(%[\\da-f]{2})|[!\\$&\\u0027\\(\\)\\*\\+,;=]|:|@)|\\/|\\?)*)?$/i.test(value);//eslint-disable-line max-len\n            },\n            $.validator.messages.url\n        ],\n        'credit-card-types': [\n            function (value, param) {\n                var validTypes;\n\n                if (utils.isEmpty(value)) {\n                    return true;\n                }\n\n                if (/[^0-9-]+/.test(value)) {\n                    return false;\n                }\n                value = value.replace(/\\D/g, '');\n                validTypes = 0x0000;\n\n                if (param.mastercard) {\n                    validTypes |= 0x0001;\n                }\n\n                if (param.visa) {\n                    validTypes |= 0x0002;\n                }\n\n                if (param.amex) {\n                    validTypes |= 0x0004;\n                }\n\n                if (param.dinersclub) {\n                    validTypes |= 0x0008;\n                }\n\n                if (param.enroute) {\n                    validTypes |= 0x0010;\n                }\n\n                if (param.discover) {\n                    validTypes |= 0x0020;\n                }\n\n                if (param.jcb) {\n                    validTypes |= 0x0040;\n                }\n\n                if (param.unknown) {\n                    validTypes |= 0x0080;\n                }\n\n                if (param.all) {\n                    validTypes = 0x0001 | 0x0002 | 0x0004 | 0x0008 | 0x0010 | 0x0020 | 0x0040 | 0x0080;\n                }\n\n                if (validTypes & 0x0001 && /^(51|52|53|54|55)/.test(value)) { //mastercard\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0002 && /^(4)/.test(value)) { //visa\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0004 && /^(34|37)/.test(value)) { //amex\n                    return value.length === 15;\n                }\n\n                if (validTypes & 0x0008 && /^(300|301|302|303|304|305|36|38)/.test(value)) { //dinersclub\n                    return value.length === 14;\n                }\n\n                if (validTypes & 0x0010 && /^(2014|2149)/.test(value)) { //enroute\n                    return value.length === 15;\n                }\n\n                if (validTypes & 0x0020 && /^(6011)/.test(value)) { //discover\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0040 && /^(3)/.test(value)) { //jcb\n                    return value.length === 16;\n                }\n\n                if (validTypes & 0x0040 && /^(2131|1800)/.test(value)) { //jcb\n                    return value.length === 15;\n                }\n\n                if (validTypes & 0x0080) { //unknown\n                    return true;\n                }\n\n                return false;\n            },\n            $.mage.__('Please enter a valid credit card number.')\n        ],\n        'ipv4': [\n            function (value) {\n                return utils.isEmpty(value) || /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/i.test(value);//eslint-disable-line max-len\n            },\n            $.mage.__('Please enter a valid IP v4 address.')\n        ],\n        'ipv6': [\n            function (value) {\n                return utils.isEmpty(value) || /^((([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}:[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){5}:([0-9A-Fa-f]{1,4}:)?[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){4}:([0-9A-Fa-f]{1,4}:){0,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){3}:([0-9A-Fa-f]{1,4}:){0,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){2}:([0-9A-Fa-f]{1,4}:){0,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){6}((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|(([0-9A-Fa-f]{1,4}:){0,5}:((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|(::([0-9A-Fa-f]{1,4}:){0,5}((\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b)\\.){3}(\\b((25[0-5])|(1\\d{2})|(2[0-4]\\d)|(\\d{1,2}))\\b))|([0-9A-Fa-f]{1,4}::([0-9A-Fa-f]{1,4}:){0,5}[0-9A-Fa-f]{1,4})|(::([0-9A-Fa-f]{1,4}:){0,6}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4}:){1,7}:))$/i.test(value);//eslint-disable-line max-len\n            },\n            $.mage.__('Please enter a valid IP v6 address.')\n        ],\n        'pattern': [\n            function (value, param) {\n                return utils.isEmpty(value) || new RegExp(param).test(value);\n            },\n            $.mage.__('Invalid format.')\n        ],\n        'validate-no-html-tags': [\n            function (value) {\n                return !/<(\\/)?\\w+/.test(value);\n            },\n            $.mage.__('HTML tags are not allowed.')\n        ],\n        'validate-select': [\n            function (value) {\n                return value !== 'none' && value != null && value.length !== 0;\n            },\n            $.mage.__('Please select an option.')\n        ],\n        'validate-no-empty': [\n            function (value) {\n                return !utils.isEmpty(value);\n            },\n            $.mage.__('Empty Value.')\n        ],\n        'validate-alphanum-with-spaces': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-zA-Z0-9 ]+$/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9) or spaces only in this field.')\n        ],\n        'validate-data': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[A-Za-z]+[A-Za-z0-9_]+$/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.')//eslint-disable-line max-len\n        ],\n        'validate-street': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) ||\n                    /^[ \\w]{3,}([A-Za-z]\\.)?([ \\w]*\\#\\d+)?(\\r\\n| )[ \\w]{3,}/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9), spaces and \"#\" in this field.')\n        ],\n        'validate-phoneStrict': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(value);\n            },\n            $.mage.__('Please enter a valid phone number. For example (123) 456-7890 or 123-456-7890.')\n        ],\n        'validate-phoneLax': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) ||\n                    /^((\\d[\\-. ]?)?((\\(\\d{3}\\))|\\d{3}))?[\\-. ]?\\d{3}[\\-. ]?\\d{4}$/.test(value);\n            },\n            $.mage.__('Please enter a valid phone number. For example (123) 456-7890 or 123-456-7890.')\n        ],\n        'validate-fax': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^(\\()?\\d{3}(\\))?(-|\\s)?\\d{3}(-|\\s)\\d{4}$/.test(value);\n            },\n            $.mage.__('Please enter a valid fax number (Ex: 123-456-7890).')\n        ],\n        'validate-email': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9,!\\#\\$%&'\\*\\+\\/=\\?\\^_`\\{\\|\\}~-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*@([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+(\\.([a-z0-9-]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF])+)*\\.(([a-z]|[\\u00A0-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]){2,})$/i.test(value);//eslint-disable-line max-len\n            },\n            $.mage.__('Please enter a valid email address (Ex: johndoe@domain.com).')\n        ],\n        'validate-emailSender': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[\\S ]+$/.test(value);\n            },\n            $.mage.__('Please enter a valid email address (Ex: johndoe@domain.com).')\n        ],\n        'validate-password': [\n            function (value) {\n                var pass;\n\n                if (value == null) {\n                    return false;\n                }\n\n                pass = value.trim();\n\n                if (!pass.length) {\n                    return true;\n                }\n\n                return !(pass.length > 0 && pass.length < 6);\n            },\n            $.mage.__('Please enter 6 or more characters. Leading and trailing spaces will be ignored.')\n        ],\n        'validate-admin-password': [\n            function (value) {\n                var pass;\n\n                if (value == null) {\n                    return false;\n                }\n\n                pass = value.trim();\n\n                if (pass.length === 0) {\n                    return true;\n                }\n\n                if (!/[a-z]/i.test(value) || !/[0-9]/.test(value)) {\n                    return false;\n                }\n\n                if (pass.length < 7) {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter 7 or more characters, using both numeric and alphabetic.')\n        ],\n        'validate-customer-password': [\n            function (v, elm) {\n                var validator = this,\n                    counter = 0,\n                    passwordMinLength = $(elm).data('password-min-length'),\n                    passwordMinCharacterSets = $(elm).data('password-min-character-sets'),\n                    pass = v.trim(),\n                    result = pass.length >= passwordMinLength;\n\n                if (result === false) {\n                    validator.passwordErrorMessage = $.mage.__('Minimum length of this field must be equal or greater than %1 symbols. Leading and trailing spaces will be ignored.').replace('%1', passwordMinLength);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                if (pass.match(/\\d+/)) {\n                    counter++;\n                }\n\n                if (pass.match(/[a-z]+/)) {\n                    counter++;\n                }\n\n                if (pass.match(/[A-Z]+/)) {\n                    counter++;\n                }\n\n                if (pass.match(/[^a-zA-Z0-9]+/)) {\n                    counter++;\n                }\n\n                if (counter < passwordMinCharacterSets) {\n                    result = false;\n                    validator.passwordErrorMessage = $.mage.__('Minimum of different classes of characters in password is %1. Classes of characters: Lower Case, Upper Case, Digits, Special Characters.').replace('%1', passwordMinCharacterSets);//eslint-disable-line max-len\n                }\n\n                return result;\n            }, function () {\n                return this.passwordErrorMessage;\n            }\n        ],\n        'validate-url': [\n            function (value) {\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n                value = (value || '').replace(/^\\s+/, '').replace(/\\s+$/, '');\n\n                return (/^(http|https|ftp):\\/\\/(([A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))(\\.[A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))*)(:(\\d+))?(\\/[A-Z0-9~](([A-Z0-9_~-]|\\.)*[A-Z0-9~]|))*\\/?(.*)?$/i).test(value);//eslint-disable-line max-len\n\n            },\n            $.mage.__('Please enter a valid URL. Protocol is required (http://, https:// or ftp://).')\n        ],\n        'validate-clean-url': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^(http|https|ftp):\\/\\/(([A-Z0-9][A-Z0-9_-]*)(\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(value) || /^(www)((\\.[A-Z0-9][A-Z0-9_-]*)+.(com|org|net|dk|at|us|tv|info|uk|co.uk|biz|se)$)(:(\\d+))?\\/?/i.test(value);//eslint-disable-line max-len\n\n            },\n            $.mage.__('Please enter a valid URL. For example http://www.example.com or www.example.com.')\n        ],\n        'validate-xml-identifier': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[A-Z][A-Z0-9_\\/-]*$/i.test(value);\n\n            },\n            $.mage.__('Please enter a valid XML-identifier (Ex: something_1, block5, id-4).')\n        ],\n        'validate-ssn': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^\\d{3}-?\\d{2}-?\\d{4}$/.test(value);\n\n            },\n            $.mage.__('Please enter a valid social security number (Ex: 123-45-6789).')\n        ],\n        'validate-zip-us': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /(^\\d{5}$)|(^\\d{5}-\\d{4}$)/.test(value);\n\n            },\n            $.mage.__('Please enter a valid zip code (Ex: 90602 or 90602-1234).')\n        ],\n        'validate-date-au': [\n            function (value) {\n                var regex = /^(\\d{2})\\/(\\d{2})\\/(\\d{4})$/,\n                    d;\n\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                if (utils.isEmpty(value) || !regex.test(value)) {\n                    return false;\n                }\n                d = new Date(value.replace(regex, '$2/$1/$3'));\n\n                return parseInt(RegExp.$2, 10) === 1 + d.getMonth() &&\n                    parseInt(RegExp.$1, 10) === d.getDate() &&\n                    parseInt(RegExp.$3, 10) === d.getFullYear();\n\n            },\n            $.mage.__('Please use this date format: dd/mm/yyyy. For example 17/03/2006 for the 17th of March, 2006.')\n        ],\n        'validate-currency-dollar': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^\\$?\\-?([1-9]{1}[0-9]{0,2}(\\,[0-9]{3})*(\\.[0-9]{0,2})?|[1-9]{1}\\d*(\\.[0-9]{0,2})?|0(\\.[0-9]{0,2})?|(\\.[0-9]{1,2})?)$/.test(value);//eslint-disable-line max-len\n\n            },\n            $.mage.__('Please enter a valid $ amount. For example $100.00.')\n        ],\n        'validate-not-negative-number': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || !isNaN(utils.parseNumber(value))\n                    && value >= 0 && (/^\\s*-?\\d+([,.]\\d+)*\\s*%?\\s*$/).test(value);\n\n            },\n            $.mage.__('Please enter a number 0 or greater, without comma in this field.')\n        ],\n        // validate-not-negative-number should be replaced in all places with this one and then removed\n        'validate-zero-or-greater': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || !isNaN(utils.parseNumber(value))\n                    && value >= 0 && (/^\\s*-?\\d+([,.]\\d+)*\\s*%?\\s*$/).test(value);\n            },\n            $.mage.__('Please enter a number 0 or greater, without comma in this field.')\n        ],\n        'validate-greater-than-zero': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || !isNaN(utils.parseNumber(value))\n                    && value > 0 && (/^\\s*-?\\d+([,.]\\d+)*\\s*%?\\s*$/).test(value);\n            },\n            $.mage.__('Please enter a number greater than 0, without comma in this field.')\n        ],\n        'validate-css-length': [\n            function (value) {\n                if (value !== '') {\n                    return (/^[0-9]*\\.*[0-9]+(px|pc|pt|ex|em|mm|cm|in|%)?$/).test(value);\n                }\n\n                return true;\n            },\n            $.mage.__('Please input a valid CSS-length (Ex: 100px, 77pt, 20em, .5ex or 50%).')\n        ],\n        'validate-number': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) ||\n                    !isNaN(utils.parseNumber(value)) &&\n                    /^\\s*-?\\d*(?:[.,|'|\\s]\\d+)*(?:[.,|'|\\s]\\d{2})?-?\\s*$/.test(value);\n            },\n            $.mage.__('Please enter a valid number in this field.')\n        ],\n        'validate-integer': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || !isNaN(utils.parseNumber(value)) && /^\\s*-?\\d*\\s*$/.test(value);\n            },\n            $.mage.__('Please enter a valid integer in this field.')\n        ],\n        'validate-number-range': [\n            function (value, param) {\n                var numValue, dataAttrRange, result, range, m;\n\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                numValue = utils.parseNumber(value);\n\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                dataAttrRange = /^(-?[\\d.,]+)?-(-?[\\d.,]+)?$/;\n                result = true;\n                range = param;\n\n                if (range) {\n                    m = dataAttrRange.exec(range);\n\n                    if (m) {\n                        result = result && utils.isBetween(numValue, m[1], m[2]);\n                    }\n                }\n\n                return result;\n            },\n            $.mage.__('The value is not within the specified range.')\n        ],\n        'validate-positive-percent-decimal': [\n            function (value) {\n                var numValue;\n\n                if (utils.isEmptyNoTrim(value) || !/^\\s*-?\\d*(\\.\\d*)?\\s*$/.test(value)) {\n                    return false;\n                }\n\n                numValue = utils.parseNumber(value);\n\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                return utils.isBetween(numValue, 0.01, 100);\n            },\n            $.mage.__('Please enter a valid percentage discount value greater than 0.')\n        ],\n        'validate-digits': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || !/[^\\d]/.test(value);\n            },\n            $.mage.__('Please enter a valid number in this field.')\n        ],\n        'validate-digits-range': [\n            function (value, param) {\n                var numValue, dataAttrRange, result, range, m;\n\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                numValue = utils.parseNumber(value);\n\n                if (isNaN(numValue)) {\n                    return false;\n                }\n\n                dataAttrRange = /^(-?\\d+)?-(-?\\d+)?$/;\n                result = true;\n                range = param;\n\n                if (range) {\n                    m = dataAttrRange.exec(range);\n\n                    if (m) {\n                        result = result && utils.isBetween(numValue, m[1], m[2]);\n                    }\n                }\n\n                return result;\n            },\n            $.mage.__('The value is not within the specified range.')\n        ],\n        'validate-range': [\n            function (value) {\n                var minValue, maxValue, ranges;\n\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                } else if ($.validator.methods['validate-digits'] && $.validator.methods['validate-digits'](value)) {\n                    minValue = maxValue = utils.parseNumber(value);\n                } else {\n                    ranges = /^(-?\\d+)?-(-?\\d+)?$/.exec(value);\n\n                    if (ranges) {\n                        minValue = utils.parseNumber(ranges[1]);\n                        maxValue = utils.parseNumber(ranges[2]);\n\n                        if (minValue > maxValue) {//eslint-disable-line max-depth\n                            return false;\n                        }\n                    } else {\n                        return false;\n                    }\n                }\n            },\n            $.mage.__('The value is not within the specified range.')\n        ],\n        'validate-alpha': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-zA-Z]+$/.test(value);\n            },\n            $.mage.__('Please use letters only (a-z or A-Z) in this field.')\n        ],\n        'validate-code': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-z]+[a-z0-9_]+$/.test(value);\n            },\n            $.mage.__('Please use only lowercase letters (a-z), numbers (0-9) or underscore (_) in this field, and the first character should be a letter.')//eslint-disable-line max-len\n        ],\n        'validate-alphanum': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-zA-Z0-9]+$/.test(value);\n            },\n            $.mage.__('Please use only letters (a-z or A-Z) or numbers (0-9) in this field. No spaces or other characters are allowed.')//eslint-disable-line max-len\n        ],\n        'validate-not-number-first': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[^0-9-\\.].*$/.test(value.trim());\n            },\n            $.mage.__('First character must be letter.')\n        ],\n        'validate-date': [\n            function (value, params, additionalParams) {\n                var test = moment(value, additionalParams.dateFormat);\n\n                return utils.isEmptyNoTrim(value) || test.isValid();\n            },\n            $.mage.__('Please enter a valid date.')\n        ],\n        'validate-date-range': [\n            function (value, params) {\n                var fromDate = $('input[name*=\"' + params + '\"]').val();\n\n                return moment.utc(value).unix() >= moment.utc(fromDate).unix() || isNaN(moment.utc(value).unix());\n            },\n            $.mage.__('Make sure the To Date is later than or the same as the From Date.')\n        ],\n        'validate-identifier': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^[a-z0-9][a-z0-9_\\/-]+(\\.[a-z0-9_-]+)?$/.test(value);\n            },\n            $.mage.__('Please enter a valid URL Key (Ex: \"example-page\", \"example-page.html\" or \"anotherlevel/example-page\").')//eslint-disable-line max-len\n        ],\n        'validate-trailing-hyphen': [\n            function (value) {\n                return utils.isEmptyNoTrim(value) || /^(?!-)(?!.*-$).+$/.test(value);\n            },\n            $.mage.__('Trailing hyphens are not allowed.')\n        ],\n        'validate-zip-international': [\n\n            /*function(v) {\n            // @TODO: Cleanup\n            return Validation.get('IsEmpty').test(v) || /(^[A-z0-9]{2,10}([\\s]{0,1}|[\\-]{0,1})[A-z0-9]{2,10}$)/.test(v);\n            }*/\n            function () {\n                return true;\n            },\n            $.mage.__('Please enter a valid zip code.')\n        ],\n        'validate-state': [\n            function (value) {\n                return value !== 0;\n            },\n            $.mage.__('Please select State/Province.')\n        ],\n        'less-than-equals-to': [\n            function (value, params) {\n                value = utils.parseNumber(value);\n\n                if (isNaN(parseFloat(params))) {\n                    params = $(params).val();\n                }\n\n                params = utils.parseNumber(params);\n\n                if (!isNaN(params) && !isNaN(value)) {\n                    this.lteToVal = params;\n\n                    return value <= params;\n                }\n\n                return true;\n            },\n            function () {\n                return $.mage.__('Please enter a value less than or equal to %s.').replace('%s', this.lteToVal);\n            }\n        ],\n        'greater-than-equals-to': [\n            function (value, params) {\n                value = utils.parseNumber(value);\n\n                if (isNaN(parseFloat(params))) {\n                    params = $(params).val();\n                }\n\n                params = utils.parseNumber(params);\n\n                if (!isNaN(params) && !isNaN(value)) {\n                    this.gteToVal = params;\n\n                    return value >= params;\n                }\n\n                return true;\n            },\n            function () {\n                return $.mage.__('Please enter a value greater than or equal to %s.').replace('%s', this.gteToVal);\n            }\n        ],\n        'validate-emails': [\n            function (value) {\n                var validRegexp, emails, i;\n\n                if (utils.isEmpty(value)) {\n                    return true;\n                }\n                validRegexp = /^[a-z0-9\\._-]{1,30}@([a-z0-9_-]{1,30}\\.){1,5}[a-z]{2,4}$/i;\n                emails = value.split(/[\\s\\n\\,]+/g);\n\n                for (i = 0; i < emails.length; i++) {\n                    if (!validRegexp.test(emails[i].strip())) {\n                        return false;\n                    }\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter valid email addresses, separated by commas. For example, johndoe@domain.com, johnsmith@domain.com.')//eslint-disable-line max-len\n        ],\n        'validate-cc-number': [\n\n            /**\n             * Validate credit card number based on mod 10.\n             *\n             * @param {String} value - credit card number\n             * @return {Boolean}\n             */\n            function (value) {\n                if (value) {\n                    return validateCreditCard(value);\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter a valid credit card number.')\n        ],\n        'validate-cc-ukss': [\n\n            /**\n             * Validate Switch/Solo/Maestro issue number and start date is filled.\n             *\n             * @param {String} value - input field value\n             * @return {*}\n             */\n            function (value) {\n                return value;\n            },\n            $.mage.__('Please enter issue number or start date for switch/solo card type.')\n        ],\n        'required-entry': [\n            function (value) {\n                return !utils.isEmpty(value);\n            },\n            $.mage.__('This is a required field.')\n        ],\n        'checked': [\n            function (value) {\n                return value;\n            },\n            $.mage.__('This is a required field.')\n        ],\n        'not-negative-amount': [\n            function (value) {\n                if (value.length) {\n                    return (/^\\s*\\d+([,.]\\d+)*\\s*%?\\s*$/).test(value);\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter positive number in this field.')\n        ],\n        'validate-per-page-value-list': [\n            function (value) {\n                var isValid = true,\n                    values = value.split(','),\n                    i;\n\n                if (utils.isEmpty(value)) {\n                    return isValid;\n                }\n\n                for (i = 0; i < values.length; i++) {\n                    if (!/^[0-9]+$/.test(values[i])) {\n                        isValid = false;\n                    }\n                }\n\n                return isValid;\n            },\n            $.mage.__('Please enter a valid value, ex: 10,20,30')\n        ],\n        'validate-new-password': [\n            function (value) {\n                if ($.validator.methods['validate-password'] && !$.validator.methods['validate-password'](value)) {\n                    return false;\n                }\n\n                if (utils.isEmpty(value) && value !== '') {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter 6 or more characters. Leading and trailing spaces will be ignored.')\n        ],\n        'validate-item-quantity': [\n            function (value, params) {\n                var validator = this,\n                    result = false,\n                    // obtain values for validation\n                    qty = utils.parseNumber(value),\n                    isMinAllowedValid = typeof params.minAllowed === 'undefined' ||\n                        qty >= utils.parseNumber(params.minAllowed),\n                    isMaxAllowedValid = typeof params.maxAllowed === 'undefined' ||\n                        qty <= utils.parseNumber(params.maxAllowed),\n                    isQtyIncrementsValid = typeof params.qtyIncrements === 'undefined' ||\n                        qty % utils.parseNumber(params.qtyIncrements) === 0;\n\n                result = qty > 0;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('Please enter a quantity greater than 0.');//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                result = isMinAllowedValid;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('The fewest you may purchase is %1.').replace('%1', params.minAllowed);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                result = isMaxAllowedValid;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('The maximum you may purchase is %1.').replace('%1', params.maxAllowed);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                result = isQtyIncrementsValid;\n\n                if (result === false) {\n                    validator.itemQtyErrorMessage = $.mage.__('You can buy this product only in quantities of %1 at a time.').replace('%1', params.qtyIncrements);//eslint-disable-line max-len\n\n                    return result;\n                }\n\n                return result;\n            }, function () {\n                return this.itemQtyErrorMessage;\n            }\n        ],\n        'equalTo': [\n            function (value, param) {\n                return value === $(param).val();\n            },\n            $.validator.messages.equalTo\n        ],\n        'validate-file-type': [\n            function (name, types) {\n                var extension = name.split('.').pop().toLowerCase();\n\n                if (types && typeof types === 'string') {\n                    types = types.split(' ');\n                }\n\n                return !types || !types.length || ~types.indexOf(extension);\n            },\n            $.mage.__('We don\\'t recognize or support this file extension type.')\n        ],\n        'validate-max-size': [\n            function (size, maxSize) {\n                return maxSize === false || size < maxSize;\n            },\n            $.mage.__('File you are trying to upload exceeds maximum file size limit.')\n        ],\n        'validate-if-tag-script-exist': [\n            function (value) {\n                return !value || (/<script\\b[^>]*>([\\s\\S]*?)<\\/script>$/ig).test(value);\n            },\n            $.mage.__('Please use tag SCRIPT with SRC attribute or with proper content to include JavaScript to the document.')//eslint-disable-line max-len\n        ],\n        'date_range_min': [\n            function (value, minValue, params) {\n                return moment.utc(value, params.dateFormat).unix() >= minValue;\n            },\n            $.mage.__('The date is not within the specified range.')\n        ],\n        'date_range_max': [\n            function (value, maxValue, params) {\n                return moment.utc(value, params.dateFormat).unix() <= maxValue;\n            },\n            $.mage.__('The date is not within the specified range.')\n        ],\n        'validate-color': [\n            function (value) {\n                if (value === '') {\n                    return true;\n                }\n\n                return tinycolor(value).isValid();\n            },\n            $.mage.__('Wrong color format. Please specify color in HEX, RGBa, HSVa, HSLa or use color name.')\n        ],\n        'blacklist-url': [\n            function (value, param) {\n                return new RegExp(param).test(value);\n            },\n            $.mage.__('This link is not allowed.')\n        ],\n        'validate-dob': [\n            function (value, param, params) {\n                if (value === '') {\n                    return true;\n                }\n\n                return moment.utc(value, params.dateFormat).isSameOrBefore(moment.utc());\n            },\n            $.mage.__('The Date of Birth should not be greater than today.')\n        ],\n        'validate-no-utf8mb4-characters': [\n            function (value) {\n                var validator = this,\n                    message = $.mage.__('Please remove invalid characters: {0}.'),\n                    matches = value.match(/(?:[\\uD800-\\uDBFF][\\uDC00-\\uDFFF])/g),\n                    result = matches === null;\n\n                if (!result) {\n                    validator.charErrorMessage = message.replace('{0}', matches.join());\n                }\n\n                return result;\n            }, function () {\n                return this.charErrorMessage;\n            }\n        ]\n    }, function (data) {\n        return {\n            handler: data[0],\n            message: data[1]\n        };\n    });\n});\n","Magento_Ui/js/lib/validation/utils.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(function () {\n    'use strict';\n\n    var utils = {\n        /**\n         * Check if string is empty with trim.\n         *\n         * @param {String} value\n         * @return {Boolean}\n         */\n        isEmpty: function (value) {\n            return value === '' || value == null || value.length === 0 || /^\\s+$/.test(value);\n        },\n\n        /**\n         * Check if string is empty no trim.\n         *\n         * @param {String} value\n         * @return {Boolean}\n         */\n        isEmptyNoTrim: function (value) {\n            return value === '' || value == null || value.length === 0;\n        },\n\n        /**\n         * Checks if {value} is between numbers {from} and {to}.\n         *\n         * @param {String} value\n         * @param {String} from\n         * @param {String} to\n         * @return {Boolean}\n         */\n        isBetween: function (value, from, to) {\n            return (from === null || from === '' || value >= utils.parseNumber(from)) &&\n                   (to === null || to === '' || value <= utils.parseNumber(to));\n        },\n\n        /**\n         * Parse price string.\n         *\n         * @param {String} value\n         * @return {Number}\n         */\n        parseNumber: function (value) {\n            var isDot, isComa;\n\n            if (typeof value !== 'string') {\n                return parseFloat(value);\n            }\n            isDot = value.indexOf('.');\n            isComa = value.indexOf(',');\n\n            if (isDot !== -1 && isComa !== -1) {\n                if (isComa > isDot) {\n                    value = value.replace('.', '').replace(',', '.');\n                } else {\n                    value = value.replace(',', '');\n                }\n            } else if (isComa !== -1) {\n                value = value.replace(',', '.');\n            }\n\n            return parseFloat(value);\n        },\n\n        /**\n         * Removes HTML tags and space characters, numbers and punctuation.\n         *\n         * @param {String} value -  Value being stripped.\n         * @return {String}\n         */\n        stripHtml: function (value) {\n            return value.replace(/<.[^<>]*?>/g, ' ').replace(/&nbsp;|&#160;/gi, ' ')\n                .replace(/[0-9.(),;:!?%#$'\"_+=\\/-]*/g, '');\n        }\n    };\n\n    return utils;\n});\n","Magento_Ui/js/lib/validation/validator.js":"/*\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    './rules'\n], function (_, rulesList) {\n    'use strict';\n\n    /**\n     * Validates provided value be the specified rule.\n     *\n     * @param {String} id - Rule identifier.\n     * @param {*} value - Value to be checked.\n     * @param {*} [params]\n     * @param {*} additionalParams - additional validation params set by method caller\n     * @returns {Object}\n     */\n    function validate(id, value, params, additionalParams) {\n        var rule,\n            message,\n            valid,\n            result = {\n                rule: id,\n                passed: true,\n                message: ''\n            };\n\n        if (_.isObject(params)) {\n            message = params.message || '';\n        }\n\n        if (!rulesList[id]) {\n            return result;\n        }\n\n        rule    = rulesList[id];\n        message = message || rule.message;\n        valid   = rule.handler(value, params, additionalParams);\n\n        if (!valid) {\n            params = Array.isArray(params) ?\n                params :\n                [params];\n\n            if (typeof message === 'function') {\n                message = message.call(rule);\n            }\n\n            message = params.reduce(function (msg, param, idx) {\n                return msg.replace(new RegExp('\\\\{' + idx + '\\\\}', 'g'), param);\n            }, message);\n\n            result.passed = false;\n            result.message = message;\n        }\n\n        return result;\n    }\n\n    /**\n     * Validates provided value by a specified set of rules.\n     *\n     * @param {(String|Object)} rules - One or many validation rules.\n     * @param {*} value - Value to be checked.\n     * @param {*} additionalParams - additional validation params set by method caller\n     * @returns {Object}\n     */\n    function validator(rules, value, additionalParams) {\n        var result;\n\n        if (typeof rules === 'object') {\n            result = {\n                passed: true\n            };\n\n            _.every(rules, function (ruleParams, id) {\n                if (ruleParams.validate || ruleParams !== false || additionalParams) {\n                    result = validate(id, value, ruleParams, additionalParams);\n\n                    return result.passed;\n                }\n\n                return true;\n            });\n\n            return result;\n        }\n\n        return validate.apply(null, arguments);\n    }\n\n    /**\n     * Adds new validation rule.\n     *\n     * @param {String} id - Rule identifier.\n     * @param {Function} handler - Validation function.\n     * @param {String} message - Error message.\n     */\n    validator.addRule = function (id, handler, message) {\n        rulesList[id] = {\n            handler: handler,\n            message: message\n        };\n    };\n\n    /**\n     * Returns rule object found by provided identifier.\n     *\n     * @param {String} id - Rule identifier.\n     * @returns {Object}\n     */\n    validator.getRule = function (id) {\n        return rulesList[id];\n    };\n\n    return validator;\n});\n","Magento_Ui/js/lib/view/utils/async.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'uiRegistry',\n    './dom-observer',\n    'Magento_Ui/js/lib/knockout/extender/bound-nodes',\n    './bindings'\n], function (ko, $, _, registry, domObserver, boundedNodes) {\n    'use strict';\n\n    /**\n     * Checks if provided value is a dom element.\n     *\n     * @param {*} node - Value to be checked.\n     * @returns {Boolean}\n     */\n    function isDomElement(node) {\n        return typeof node === 'object' && node.tagName && node.nodeType;\n    }\n\n    /**\n     * Parses provided string and extracts\n     * component, context and selector data from it.\n     *\n     * @param {String} str - String to be processed.\n     * @returns {Object} Data retrieved from string.\n     *\n     * @example Sample format.\n     *      '{{component}}:{{ctx}} -> {{selector}}'\n     *\n     *      component - Name of component.\n     *      ctx - Selector of the root node upon which component is binded.\n     *      selector - Selector of DOM elements located\n     *          inside of a previously specified context.\n     */\n    function parseSelector(str) {\n        var data    = str.trim().split('->'),\n            result  = {},\n            componentData;\n\n        if (data.length === 1) {\n            if (!~data[0].indexOf(':')) {\n                result.selector = data[0];\n            } else {\n                componentData = data[0];\n            }\n        } else {\n            componentData   = data[0];\n            result.selector = data[1];\n        }\n\n        if (componentData) {\n            componentData = componentData.split(':');\n\n            result.component = componentData[0];\n            result.ctx = componentData[1];\n        }\n\n        _.each(result, function (value, key) {\n            result[key] = value.trim();\n        });\n\n        return result;\n    }\n\n    /**\n     * Internal method used to normalize argumnets passed\n     * to 'async' module methods.\n     *\n     * @param {(String|Object)} selector\n     * @param {(HTMLElement|Object|String)} [ctx]\n     * @returns {Object}\n     */\n    function parseData(selector, ctx) {\n        var data = {};\n\n        if (arguments.length === 2) {\n            data.selector = selector;\n\n            if (isDomElement(ctx)) {\n                data.ctx = ctx;\n            } else {\n                data.component = ctx;\n                data.ctx = '*';\n            }\n        } else {\n            data = _.isString(selector) ?\n                parseSelector(selector) :\n                selector;\n        }\n\n        return data;\n    }\n\n    /**\n     * Creates promise that will be resolved\n     * when requested component is registred.\n     *\n     * @param {String} name - Name of component.\n     * @returns {jQueryPromise}\n     */\n    function waitComponent(name) {\n        var deffer = $.Deferred();\n\n        if (_.isString(name)) {\n            registry.get(name, function (component) {\n                deffer.resolve(component);\n            });\n        } else {\n            deffer.resolve(name);\n        }\n\n        return deffer.promise();\n    }\n\n    /**\n     * Creates listener for the nodes binded to provided component.\n     *\n     * @param {Object} data - Listener data.\n     * @param {Object} component - Associated with nodes component.\n     */\n    function setRootListener(data, component) {\n        boundedNodes.get(component, function (root) {\n            if (!$(root).is(data.ctx || '*')) {\n                return;\n            }\n\n            data.selector ?\n                domObserver.get(data.selector, data.fn, root) :\n                data.fn(root);\n        });\n    }\n\n    /*eslint-disable no-unused-vars*/\n    /**\n     * Sets listener for the appearance of elements which\n     * matches specified selector data.\n     *\n     * @param {(String|Object)} selector - Valid css selector or a string\n     *      in format acceptable by 'parseSelector' method or an object with\n     *      'component', 'selector' and 'ctx' properties.\n     * @param {(HTMLElement|Object|String)} [ctx] - Optional context parameter\n     *      which might be a DOM element, component instance or components' name.\n     * @param {Function} fn - Callback that will be invoked\n     *      when required DOM element appears.\n     *\n     * @example\n     *      Creating listener of the 'span' nodes appearance,\n     *      located inside of 'div' nodes, which are binded to 'cms_page_listing' component:\n     *\n     *      $.async('cms_page_listing:div -> span', function (node) {});\n     *\n     * @example Another syntaxes of the previous example.\n     *      $.async({\n     *          component: 'cms_page_listing',\n     *          ctx: 'div',\n     *          selector: 'span'\n     *       }, function (node) {});\n     *\n     * @example Listens for appearance of any child node inside of specified component.\n     *      $.async('> *', 'cms_page_lsiting', function (node) {});\n     *\n     * @example Listens for appearance of 'span' nodes inside of specific context.\n     *      $.async('span', document.getElementById('test'), function (node) {});\n     */\n    $.async = function (selector, ctx, fn) {\n        var args = _.toArray(arguments),\n            data = parseData.apply(null, _.initial(args));\n\n        data.fn = _.last(args);\n\n        if (data.component) {\n            waitComponent(data.component)\n                .then(setRootListener.bind(null, data));\n        } else {\n            domObserver.get(data.selector, data.fn, data.ctx);\n        }\n    };\n\n    /*eslint-enable no-unused-vars*/\n\n    _.extend($.async, {\n\n        /*eslint-disable no-unused-vars*/\n        /**\n         * Returns collection of elements found by provided selector data.\n         *\n         * @param {(String|Object)} selector - See 'async' definition.\n         * @param {(HTMLElement|Object|String)} [ctx] - See 'async' definition.\n         * @returns {Array} An array of DOM elements.\n         */\n        get: function (selector, ctx) {\n            var data        = parseData.apply(null, arguments),\n                component   = data.component,\n                nodes;\n\n            if (!component) {\n                return $(data.selector, data.ctx).toArray();\n            } else if (_.isString(component)) {\n                component = registry.get(component);\n            }\n\n            if (!component) {\n                return [];\n            }\n\n            nodes = boundedNodes.get(component);\n            nodes = $(nodes).filter(data.ctx).toArray();\n\n            return data.selector ?\n                $(data.selector, nodes).toArray() :\n                nodes;\n        },\n\n        /*eslint-enable no-unused-vars*/\n\n        /**\n         * Sets removal listener of the specified nodes.\n         *\n         * @param {(HTMLElement|Array|ArrayLike)} nodes - Nodes whose removal to track.\n         * @param {Function} fn - Callback that will be invoked when node is removed.\n         */\n        remove: function (nodes, fn) {\n            domObserver.remove(nodes, fn);\n        },\n\n        parseSelector: parseSelector\n    });\n\n    return $;\n});\n","Magento_Ui/js/lib/view/utils/bindings.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore'\n], function (ko, $, _) {\n    'use strict';\n\n    /**\n     * Checks if provided  value is a dom element.\n     *\n     * @param {*} node - Value to be checked.\n     * @returns {Boolean}\n     */\n    function isDomElement(node) {\n        return typeof node === 'object' && node.tagName && node.nodeType;\n    }\n\n    /**\n     * Removes from the provided array all non-root nodes located inside\n     * of the comment element as long as the closing comment tags.\n     *\n     * @param {(Array|ArrayLike)} nodes - An array of nodes to be processed.\n     * @returns {Array}\n     */\n    function normalize(nodes) {\n        var result;\n\n        nodes   = _.toArray(nodes);\n        result  = nodes.slice();\n\n        nodes.forEach(function (node) {\n            if (node.nodeType === 8) {\n                result = !ko.virtualElements.hasBindingValue(node) ?\n                    _.without(result, node) :\n                    _.difference(result, ko.virtualElements.childNodes(node));\n            }\n        });\n\n        return result;\n    }\n\n    /**\n     * Extends binding context of each item in the collection.\n     *\n     * @param {...Object} extenders - Multiple extender objects to be applied to the context.\n     * @returns {jQueryCollection} Chainable.\n     */\n    $.fn.extendCtx = function () {\n        var nodes       = normalize(this),\n            extenders   = _.toArray(arguments);\n\n        nodes.forEach(function (node) {\n            var ctx  = ko.contextFor(node),\n                data = [ctx].concat(extenders);\n\n            _.extend.apply(_, data);\n        });\n\n        return this;\n    };\n\n    /**\n     * Evaluates bindings specified in each DOM element of collection.\n     *\n     * @param {(HTMLElement|Object)} [ctx] - Context to use for bindings evaluation.\n     *      If not specified then current context of a collections' item will be used.\n     * @returns {jQueryCollection} Chainable.\n     */\n    $.fn.applyBindings = function (ctx) {\n        var nodes = normalize(this),\n            nodeCtx;\n\n        if (isDomElement(ctx)) {\n            ctx = ko.contextFor(ctx);\n        }\n\n        nodes.forEach(function (node) {\n            nodeCtx = ctx || ko.contextFor(node);\n\n            ko.applyBindings(nodeCtx, node);\n        });\n\n        return this;\n    };\n\n    /**\n     * Adds specified bindings to each DOM element in\n     * collection and evaluates them with provided context.\n     *\n     * @param {(Object|Function)} data - Either bindings object or a function\n     *      which returns bindings data for each element in collection.\n     * @param {(HTMLElement|Object)} [ctx] - Context to use for bindings evaluation.\n     *      If not specified then current context of a collections' item will be used.\n     * @returns {jQueryCollection} Chainable.\n     */\n    $.fn.bindings = function (data, ctx) {\n        var nodes    = normalize(this),\n            bindings = data,\n            nodeCtx;\n\n        if (isDomElement(ctx)) {\n            ctx = ko.contextFor(ctx);\n        }\n\n        nodes.forEach(function (node) {\n            nodeCtx = ctx || ko.contextFor(node);\n\n            if (_.isFunction(data)) {\n                bindings = data(nodeCtx, node);\n            }\n\n            ko.applyBindingsToNode(node, bindings, nodeCtx);\n        });\n\n        return this;\n    };\n});\n","Magento_Ui/js/lib/view/utils/dom-observer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'domReady!'\n], function ($, _) {\n    'use strict';\n\n    var counter = 1,\n        watchers,\n        globalObserver,\n        disabledNodes = [];\n\n    watchers = {\n        selectors: {},\n        nodes: {}\n    };\n\n    /**\n     * Checks if node represents an element node (nodeType === 1).\n     *\n     * @param {HTMLElement} node\n     * @returns {Boolean}\n     */\n    function isElementNode(node) {\n        return node.nodeType === 1;\n    }\n\n    /**\n     * Extracts all child descendant\n     * elements of a specified node.\n     *\n     * @param {HTMLElement} node\n     * @returns {Array}\n     */\n    function extractChildren(node) {\n        var children = node.querySelectorAll('*');\n\n        return _.toArray(children);\n    }\n\n    /**\n     * Extracts node identifier. If ID is not specified,\n     * then it will be created for the provided node.\n     *\n     * @param {HTMLElement} node\n     * @returns {Number}\n     */\n    function getNodeId(node) {\n        var id = node._observeId;\n\n        if (!id) {\n            id = node._observeId = counter++;\n        }\n\n        return id;\n    }\n\n    /**\n     * Invokes callback passing node to it.\n     *\n     * @param {HTMLElement} node\n     * @param {Object} data\n     */\n    function trigger(node, data) {\n        var id = getNodeId(node),\n            ids = data.invoked;\n\n        if (_.contains(ids, id)) {\n            return;\n        }\n\n        data.callback(node);\n        data.invoked.push(id);\n    }\n\n    /**\n     * Adds node to the observer list.\n     *\n     * @param {HTMLElement} node\n     * @returns {Object}\n     */\n    function createNodeData(node) {\n        var nodes   = watchers.nodes,\n            id      = getNodeId(node);\n\n        nodes[id] = nodes[id] || {};\n\n        return nodes[id];\n    }\n\n    /**\n     * Returns data associated with a specified node.\n     *\n     * @param {HTMLElement} node\n     * @returns {Object|Undefined}\n     */\n    function getNodeData(node) {\n        var nodeId = node._observeId;\n\n        return watchers.nodes[nodeId];\n    }\n\n    /**\n     * Removes data associated with a specified node.\n     *\n     * @param {HTMLElement} node\n     */\n    function removeNodeData(node) {\n        var nodeId = node._observeId;\n\n        delete watchers.nodes[nodeId];\n    }\n\n    /**\n     * Adds removal listener for a specified node.\n     *\n     * @param {HTMLElement} node\n     * @param {Object} data\n     */\n    function addRemovalListener(node, data) {\n        var nodeData = createNodeData(node);\n\n        (nodeData.remove = nodeData.remove || []).push(data);\n    }\n\n    /**\n     * Adds listener for the nodes which matches specified selector.\n     *\n     * @param {String} selector - CSS selector.\n     * @param {Object} data\n     */\n    function addSelectorListener(selector, data) {\n        var storage = watchers.selectors;\n\n        (storage[selector] = storage[selector] || []).push(data);\n    }\n\n    /**\n     * Calls handlers associated with an added node.\n     * Adds listeners for the node removal.\n     *\n     * @param {HTMLElement} node - Added node.\n     */\n    function processAdded(node) {\n        _.each(watchers.selectors, function (listeners, selector) {\n            listeners.forEach(function (data) {\n                if (!data.ctx.contains(node) || !$(node, data.ctx).is(selector)) {\n                    return;\n                }\n\n                if (data.type === 'add') {\n                    trigger(node, data);\n                } else if (data.type === 'remove') {\n                    addRemovalListener(node, data);\n                }\n            });\n        });\n    }\n\n    /**\n     * Calls handlers associated with a removed node.\n     *\n     * @param {HTMLElement} node - Removed node.\n     */\n    function processRemoved(node) {\n        var nodeData    = getNodeData(node),\n            listeners   = nodeData && nodeData.remove;\n\n        if (!listeners) {\n            return;\n        }\n\n        listeners.forEach(function (data) {\n            trigger(node, data);\n        });\n\n        removeNodeData(node);\n    }\n\n    /**\n     * Removes all non-element nodes from provided array\n     * and appends to it descendant elements.\n     *\n     * @param {Array} nodes\n     * @returns {Array}\n     */\n    function formNodesList(nodes) {\n        var result = [],\n            children;\n\n        nodes = _.toArray(nodes).filter(isElementNode);\n\n        nodes.forEach(function (node) {\n            result.push(node);\n\n            children = extractChildren(node);\n            result   = result.concat(children);\n        });\n\n        return result;\n    }\n\n    /**\n     * Collects all removed and added nodes from\n     * mutation records into separate arrays\n     * while removing duplicates between both types of changes.\n     *\n     * @param {Array} mutations - An array of mutation records.\n     * @returns {Object} Object with 'removed' and 'added' nodes arrays.\n     */\n    function formChangesLists(mutations) {\n        var removed = [],\n            added = [];\n\n        mutations.forEach(function (record) {\n            removed = removed.concat(_.toArray(record.removedNodes));\n            added   = added.concat(_.toArray(record.addedNodes));\n        });\n\n        removed = removed.filter(function (node) {\n            var addIndex = added.indexOf(node),\n                wasAdded = !!~addIndex;\n\n            if (wasAdded) {\n                added.splice(addIndex, 1);\n            }\n\n            return !wasAdded;\n        });\n\n        return {\n            removed: formNodesList(removed),\n            added: formNodesList(added)\n        };\n    }\n\n    /**\n     * Verify if the DOM node is a child of a defined disabled node, if so we shouldn't observe provided mutation.\n     *\n     * @param {Object} mutation - a single mutation\n     * @returns {Boolean}\n     */\n    function shouldObserveMutation(mutation) {\n        var isDisabled;\n\n        if (disabledNodes.length > 0) {\n            // Iterate through the disabled nodes and determine if this mutation is occurring inside one of them\n            isDisabled = _.find(disabledNodes, function (node) {\n                return node === mutation.target || $.contains(node, mutation.target);\n            });\n\n            // If we find a matching node we should not observe the mutation\n            return !isDisabled;\n        }\n\n        return true;\n    }\n\n    /**\n     * Should we observe these mutations? Check the first and last mutation to determine if this is a disabled mutation,\n     * we check both the first and last in case one has been removed from the DOM during the process of the mutation.\n     *\n     * @param {Array} mutations - An array of mutation records.\n     * @returns {Boolean}\n     */\n    function shouldObserveMutations(mutations) {\n        var firstMutation,\n            lastMutation;\n\n        if (mutations.length > 0) {\n            firstMutation = mutations[0];\n            lastMutation = mutations[mutations.length - 1];\n\n            return shouldObserveMutation(firstMutation) && shouldObserveMutation(lastMutation);\n        }\n\n        return true;\n    }\n\n    globalObserver = new MutationObserver(function (mutations) {\n        var changes;\n\n        if (shouldObserveMutations(mutations)) {\n            changes = formChangesLists(mutations);\n\n            changes.removed.forEach(processRemoved);\n            changes.added.forEach(processAdded);\n        }\n    });\n\n    globalObserver.observe(document.body, {\n        subtree: true,\n        childList: true\n    });\n\n    return {\n        /**\n         * Disable a node from being observed by the mutations, you may want to disable specific aspects of the\n         * application which are heavy on DOM changes. The observer running on some actions could cause significant\n         * delays and degrade the performance of that specific part of the application exponentially.\n         *\n         * @param {HTMLElement} node - a HTML node within the document\n         */\n        disableNode: function (node) {\n            disabledNodes.push(node);\n        },\n\n        /**\n         * Adds listener for the appearance of nodes that matches provided\n         * selector and which are inside of the provided context. Callback will be\n         * also invoked on elements which a currently present.\n         *\n         * @param {String} selector - CSS selector.\n         * @param {Function} callback - Function that will invoked when node appears.\n         * @param {HTMLElement} [ctx=document.body] - Context inside of which to search for the node.\n         */\n        get: function (selector, callback, ctx) {\n            var data,\n                nodes;\n\n            data = {\n                ctx: ctx || document.body,\n                type: 'add',\n                callback: callback,\n                invoked: []\n            };\n\n            nodes = $(selector, data.ctx).toArray();\n\n            nodes.forEach(function (node) {\n                trigger(node, data);\n            });\n\n            addSelectorListener(selector, data);\n        },\n\n        /**\n         * Adds listener for the nodes removal.\n         *\n         * @param {(jQueryObject|HTMLElement|Array|String)} selector\n         * @param {Function} callback - Function that will invoked when node is removed.\n         * @param {HTMLElement} [ctx=document.body] - Context inside of which to search for the node.\n         */\n        remove: function (selector, callback, ctx) {\n            var nodes = [],\n                data;\n\n            data = {\n                ctx: ctx || document.body,\n                type: 'remove',\n                callback: callback,\n                invoked: []\n            };\n\n            if (typeof selector === 'object') {\n                nodes = !_.isUndefined(selector.length) ?\n                    _.toArray(selector) :\n                    [selector];\n            } else if (_.isString(selector)) {\n                nodes = $(selector, ctx).toArray();\n\n                addSelectorListener(selector, data);\n            }\n\n            nodes.forEach(function (node) {\n                addRemovalListener(node, data);\n            });\n        },\n\n        /**\n         * Removes listeners.\n         *\n         * @param {String} selector\n         * @param {Function} [fn]\n         */\n        off: function (selector, fn) {\n            var selectors = watchers.selectors,\n                listeners = selectors[selector];\n\n            if (selector && !fn) {\n                delete selectors[selector];\n            } else if (listeners && fn) {\n                selectors[selector] = listeners.filter(function (data) {\n                    return data.callback !== fn;\n                });\n            }\n        }\n    };\n});\n","Magento_Ui/js/lib/view/utils/raf.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    var processMap = new WeakMap(),\n        origRaf,\n        raf;\n\n    origRaf = window.requestAnimationFrame ||\n        window.webkitRequestAnimationFrame ||\n        window.mozRequestAnimationFrame ||\n        window.onRequestAnimationFrame ||\n        window.msRequestAnimationFrame ||\n        function (callback) {\n            if (typeof callback != 'function') {\n                throw new Error('raf argument \"callback\" must be of type function');\n            }\n            window.setTimeout(callback, 1000 / 60);\n        };\n\n    /**\n     * Creates new process object or extracts the\n     * the existing one.\n     *\n     * @param {*} id - Process identifier.\n     * @param {Number} fps - Required FPS count.\n     * @returns {Object}\n     */\n    function getProcess(id, fps) {\n        var process = processMap.get(id);\n\n        if (!process) {\n            process = {};\n            processMap.set(id, process);\n        }\n\n        if (process.fps !== fps) {\n            process.fps        = fps;\n            process.interval   = 1000 / fps;\n            process.update     = Date.now();\n        }\n\n        return process;\n    }\n\n    /**\n     * Proxy method which delegates call to the 'requestAnimationFrame'\n     * function and optionally can keep track of the FPS with which\n     * provided function is called.\n     *\n     * @param {Function} callback - Callback function to be passed to 'requestAnimationFrame'.\n     * @param {Number} [fps] - If specified, will update FPS counter for the provided function.\n     * @returns {Number|Boolean} ID of request or a flag which indicates\n     *      whether callback fits specified FPS.\n     */\n    raf = function (callback, fps) {\n        var rafId = origRaf(callback);\n\n        return fps ? raf.tick(callback, fps) : rafId;\n    };\n\n    /**\n     * Updates FPS counter for the specified process\n     * and returns a flag which indicates whether\n     * counter value is equal or greater than the required FPS.\n     *\n     * @param {*} id - Process identifier.\n     * @param {Number} fps - Required FPS count.\n     * @returns {Boolean}\n     */\n    raf.tick = function (id, fps) {\n        var process  = getProcess(id, fps),\n            now      = Date.now(),\n            delta    = now - process.update,\n            interval = process.interval;\n\n        if (fps >= 60 || delta >= interval) {\n            process.update = now - delta % interval;\n\n            return true;\n        }\n\n        return false;\n    };\n\n    return raf;\n});\n","Magento_Ui/js/modal/alert.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'jquery-ui-modules/widget',\n    'Magento_Ui/js/modal/confirm',\n    'mage/translate'\n], function ($, _) {\n    'use strict';\n\n    $.widget('mage.alert', $.mage.confirm, {\n        options: {\n            modalClass: 'confirm',\n            title: $.mage.__('Attention'),\n            actions: {\n\n                /**\n                 * Callback always - called on all actions.\n                 */\n                always: function () {}\n            },\n            buttons: [{\n                text: $.mage.__('OK'),\n                class: 'action-primary action-accept',\n\n                /**\n                 * Click handler.\n                 */\n                click: function () {\n                    this.closeModal(true);\n                }\n            }]\n        },\n\n        /**\n         * Close modal window.\n         */\n        closeModal: function () {\n            this.options.actions.always();\n            this.element.on('alertclosed', _.bind(this._remove, this));\n\n            return this._super();\n        }\n    });\n\n    return function (config) {\n        return $('<div></div>').html(config.content).alert(config);\n    };\n});\n","Magento_Ui/js/modal/confirm.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/translate',\n    'jquery-ui-modules/widget',\n    'Magento_Ui/js/modal/modal'\n], function ($, _, $t) {\n    'use strict';\n\n    $.widget('mage.confirm', $.mage.modal, {\n        options: {\n            modalClass: 'confirm',\n            title: '',\n            focus: '.action-accept',\n            actions: {\n\n                /**\n                 * Callback always - called on all actions.\n                 */\n                always: function () {},\n\n                /**\n                 * Callback confirm.\n                 */\n                confirm: function () {},\n\n                /**\n                 * Callback cancel.\n                 */\n                cancel: function () {}\n            },\n            buttons: [{\n                text: $t('Cancel'),\n                class: 'action-secondary action-dismiss',\n\n                /**\n                 * Click handler.\n                 */\n                click: function (event) {\n                    this.closeModal(event);\n                }\n            }, {\n                text: $t('OK'),\n                class: 'action-primary action-accept',\n\n                /**\n                 * Click handler.\n                 */\n                click: function (event) {\n                    this.closeModal(event, true);\n                }\n            }]\n        },\n\n        /**\n         * Create widget.\n         */\n        _create: function () {\n            this._super();\n            this.modal.find(this.options.modalCloseBtn).off().on('click', _.bind(this.closeModal, this));\n            this.openModal();\n        },\n\n        /**\n         * Remove modal window.\n         */\n        _remove: function () {\n            this.modal.remove();\n        },\n\n        /**\n         * Open modal window.\n         */\n        openModal: function () {\n            return this._super();\n        },\n\n        /**\n         * Close modal window.\n         */\n        closeModal: function (event, result) {\n            result = result || false;\n\n            if (result) {\n                this.options.actions.confirm(event);\n            } else {\n                this.options.actions.cancel(event);\n            }\n            this.options.actions.always(event);\n            this.element.on('confirmclosed', _.bind(this._remove, this));\n\n            return this._super();\n        }\n    });\n\n    return function (config) {\n        return $('<div></div>').html(config.content).confirm(config);\n    };\n});\n","Magento_Ui/js/modal/modal-component.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/lib/view/utils/async',\n    'uiCollection',\n    'uiRegistry',\n    'underscore',\n    './modal'\n], function ($, Collection, registry, _) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            template: 'ui/modal/modal-component',\n            title: '',\n            subTitle: '',\n            options: {\n                modalClass: '',\n                title: '',\n                subTitle: '',\n                buttons: [],\n                keyEventHandlers: {}\n            },\n            valid: true,\n            links: {\n                title: 'options.title',\n                subTitle: 'options.subTitle'\n            },\n            listens: {\n                state: 'onState',\n                title: 'setTitle',\n                'options.subTitle': 'setSubTitle'\n            },\n            modalClass: 'modal-component',\n            onCancel: 'closeModal'\n        },\n\n        /**\n         * Initializes component.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super();\n            _.bindAll(this,\n                'initModal',\n                'openModal',\n                'closeModal',\n                'toggleModal',\n                'setPrevValues',\n                'validate');\n            this.initializeContent();\n\n            return this;\n        },\n\n        /**\n         * Initializes modal configuration\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            return this._super()\n                .initSelector()\n                .initModalEvents();\n        },\n\n        /**\n         * Configure modal selector\n         *\n         * @returns {Object} Chainable.\n         */\n        initSelector: function () {\n            var modalClass = this.name.replace(/\\./g, '_');\n\n            this.contentSelector = '.' + this.modalClass;\n            this.options.modalClass = this.options.modalClass + ' ' + modalClass;\n            this.rootSelector = '.' + modalClass;\n\n            return this;\n        },\n\n        /**\n         * Configure modal keyboard handlers\n         * and outer click\n         *\n         * @returns {Object} Chainable.\n         */\n        initModalEvents: function () {\n            this.options.keyEventHandlers.escapeKey = this.options.outerClickHandler = this[this.onCancel].bind(this);\n\n            return this;\n        },\n\n        /**\n         * Initialize modal's content components\n         */\n        initializeContent: function () {\n            $.async({\n                component: this.name\n            }, this.initModal);\n        },\n\n        /**\n         * Init toolbar section so other components will be able to place something in it\n         */\n        initToolbarSection: function () {\n            this.set('toolbarSection', this.modal.data('mage-modal').modal.find('header').get(0));\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n            this.observe(['state', 'focused']);\n\n            return this;\n        },\n\n        /**\n         * Wrap content in a modal of certain type\n         *\n         * @param {HTMLElement} element\n         * @returns {Object} Chainable.\n         */\n        initModal: function (element) {\n            if (!this.modal) {\n                this.overrideModalButtonCallback();\n                this.options.modalCloseBtnHandler = this[this.onCancel].bind(this);\n                this.modal = $(element).modal(this.options);\n                this.initToolbarSection();\n\n                if (this.waitCbk) {\n                    this.waitCbk();\n                    this.waitCbk = null;\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Open modal\n         */\n        openModal: function () {\n            if (this.modal) {\n                this.state(true);\n            } else {\n                this.waitCbk = this.openModal;\n            }\n        },\n\n        /**\n         * Close modal\n         */\n        closeModal: function () {\n            if (this.modal) {\n                this.state(false);\n            } else {\n                this.waitCbk = this.closeModal;\n            }\n        },\n\n        /**\n         * Toggle modal\n         */\n        toggleModal: function () {\n            if (this.modal) {\n                this.state(!this.state());\n            } else {\n                this.waitCbk = this.toggleModal;\n            }\n        },\n\n        /**\n         * Sets title for modal\n         *\n         * @param {String} title\n         */\n        setTitle: function (title) {\n            if (this.title !== title) {\n                this.title = title;\n            }\n\n            if (this.modal) {\n                this.modal.modal('setTitle', title);\n            }\n        },\n\n        /**\n         * Sets subTitle for modal\n         *\n         * @param {String} subTitle\n         */\n        setSubTitle: function (subTitle) {\n            if (this.subTitle !== subTitle) {\n                this.subTitle = subTitle;\n            }\n\n            if (this.modal) {\n                this.modal.modal('setSubTitle', subTitle);\n            }\n        },\n\n        /**\n         * Wrap content in a modal of certain type\n         *\n         * @param {Boolean} state\n         */\n        onState: function (state) {\n            if (state) {\n                this.modal.modal('openModal');\n                this.applyData();\n            } else {\n                this.modal.modal('closeModal');\n            }\n        },\n\n        /**\n         * Validate everything validatable in modal\n         */\n        validate: function (elem) {\n            if (typeof elem === 'undefined') {\n                return;\n            }\n\n            if (typeof elem.validate === 'function') {\n                this.valid &= elem.validate().valid;\n            } else if (elem.elems) {\n                elem.elems().forEach(this.validate, this);\n            }\n        },\n\n        /**\n         * Reset data from provider\n         */\n        resetData: function () {\n            this.elems().forEach(this.resetValue, this);\n        },\n\n        /**\n         * Update 'applied' property with data from modal content\n         */\n        applyData: function () {\n            var applied = {};\n\n            this.elems().forEach(this.gatherValues.bind(this, applied), this);\n            this.applied = applied;\n        },\n\n        /**\n         * Gather values from modal content\n         *\n         * @param {Array} applied\n         * @param {HTMLElement} elem\n         */\n        gatherValues: function (applied, elem) {\n            if (typeof elem.value === 'function') {\n                applied[elem.name] = elem.value();\n            } else if (elem.elems) {\n                elem.elems().forEach(this.gatherValues.bind(this, applied), this);\n            }\n        },\n\n        /**\n         * Set to previous values from modal content\n         *\n         * @param {HTMLElement} elem\n         */\n        setPrevValues: function (elem) {\n            if (typeof elem.value === 'function') {\n                this.modal.focus();\n                elem.value(this.applied[elem.name]);\n            } else if (elem.elems) {\n                elem.elems().forEach(this.setPrevValues, this);\n            }\n        },\n\n        /**\n         * Triggers some method in every modal child elem, if this method is defined\n         *\n         * @param {Object} action - action configuration,\n         * must contain actionName and targetName and\n         * can contain params\n         */\n        triggerAction: function (action) {\n            var targetName = action.targetName,\n                params = action.params || [],\n                actionName = action.actionName,\n                target;\n\n            target = registry.async(targetName);\n\n            if (target && typeof target === 'function' && actionName) {\n                params.unshift(actionName);\n                target.apply(target, params);\n            }\n        },\n\n        /**\n         * Override modal buttons callback placeholders with real callbacks\n         */\n        overrideModalButtonCallback: function () {\n            var buttons = this.options.buttons;\n\n            if (buttons && buttons.length) {\n                buttons.forEach(function (button) {\n                    button.click = this.getButtonClickHandler(button.actions);\n                }, this);\n            }\n        },\n\n        /**\n         * Generate button click handler based on button's 'actions' configuration\n         */\n        getButtonClickHandler: function (actionsConfig) {\n            var actions = actionsConfig.map(\n                function (actionConfig) {\n                    if (_.isObject(actionConfig)) {\n                        return this.triggerAction.bind(this, actionConfig);\n                    }\n\n                    return this[actionConfig] ? this[actionConfig].bind(this) : function () {};\n                }, this);\n\n            return function () {\n                actions.forEach(\n                    function (action) {\n                        action();\n                    }\n                );\n            };\n        },\n\n        /**\n         * Cancels changes in modal:\n         * returning elems values to the previous state,\n         * and close modal\n         */\n        actionCancel: function () {\n            this.elems().forEach(this.setPrevValues, this);\n            this.closeModal();\n        },\n\n        /**\n         * Accept changes in modal by not preventing them.\n         * Can be extended by exporting 'gatherValues' result somewhere\n         */\n        actionDone: function () {\n            this.valid = true;\n            this.elems().forEach(this.validate, this);\n\n            if (this.valid) {\n                this.closeModal();\n            }\n        }\n    });\n});\n","Magento_Ui/js/modal/modal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'text!ui/template/modal/modal-popup.html',\n    'text!ui/template/modal/modal-slide.html',\n    'text!ui/template/modal/modal-custom.html',\n    'Magento_Ui/js/lib/key-codes',\n    'jquery-ui-modules/widget',\n    'jquery-ui-modules/core',\n    'mage/translate',\n    'jquery/z-index'\n], function ($, _, template, popupTpl, slideTpl, customTpl, keyCodes) {\n    'use strict';\n\n    /**\n     * Detect browser transition end event.\n     * @return {String|undefined} - transition event.\n     */\n    var transitionEvent = (function () {\n        var transition,\n            elementStyle = document.createElement('div').style,\n            transitions = {\n                'transition': 'transitionend',\n                'OTransition': 'oTransitionEnd',\n                'MozTransition': 'transitionend',\n                'WebkitTransition': 'webkitTransitionEnd'\n            };\n\n        for (transition in transitions) {\n            if (elementStyle[transition] !== undefined && transitions.hasOwnProperty(transition)) {\n                return transitions[transition];\n            }\n        }\n    })();\n\n    /**\n     * Modal Window Widget\n     */\n    $.widget('mage.modal', {\n        options: {\n            id: null,\n            type: 'popup',\n            title: '',\n            subTitle: '',\n            modalClass: '',\n            focus: '[data-role=\"closeBtn\"]',\n            autoOpen: false,\n            clickableOverlay: true,\n            popupTpl: popupTpl,\n            slideTpl: slideTpl,\n            customTpl: customTpl,\n            modalVisibleClass: '_show',\n            parentModalClass: '_has-modal',\n            innerScrollClass: '_inner-scroll',\n            responsive: false,\n            innerScroll: false,\n            modalTitle: '[data-role=\"title\"]',\n            modalSubTitle: '[data-role=\"subTitle\"]',\n            modalBlock: '[data-role=\"modal\"]',\n            modalCloseBtn: '[data-role=\"closeBtn\"]',\n            modalContent: '[data-role=\"content\"]',\n            modalAction: '[data-role=\"action\"]',\n            focusableScope: '[data-role=\"focusable-scope\"]',\n            focusableStart: '[data-role=\"focusable-start\"]',\n            focusableEnd: '[data-role=\"focusable-end\"]',\n            appendTo: 'body',\n            wrapperClass: 'modals-wrapper',\n            overlayClass: 'modals-overlay',\n            responsiveClass: 'modal-slide',\n            trigger: '',\n            modalLeftMargin: 45,\n            closeText: $.mage.__('Close'),\n            buttons: [{\n                text: $.mage.__('Ok'),\n                class: '',\n                attr: {},\n\n                /**\n                 * Default action on button click\n                 */\n                click: function (event) {\n                    this.closeModal(event);\n                }\n            }],\n            keyEventHandlers: {\n\n                /**\n                 * Tab key press handler,\n                 * set focus to elements\n                 */\n                tabKey: function () {\n                    if (document.activeElement === this.modal[0]) {\n                        this._setFocus('start');\n                    }\n                },\n\n                /**\n                 * Escape key press handler,\n                 * close modal window\n                 * @param {Object} event - event\n                 */\n                escapeKey: function (event) {\n                    if (this.options.isOpen && this.modal.find(document.activeElement).length ||\n                        this.options.isOpen && this.modal[0] === document.activeElement) {\n                        this.closeModal(event);\n                    }\n                }\n            }\n        },\n\n        /**\n         * Creates modal widget.\n         */\n        _create: function () {\n            _.bindAll(\n                this,\n                'keyEventSwitcher',\n                '_tabSwitcher',\n                'closeModal'\n            );\n\n            this.options.id = this.uuid;\n            this.options.transitionEvent = transitionEvent;\n            this._createWrapper();\n            this._renderModal();\n            this._createButtons();\n\n            if (this.options.trigger) {\n                $(document).on('click', this.options.trigger, _.bind(this.toggleModal, this));\n            }\n            this._on(this.modal.find(this.options.modalCloseBtn), {\n                'click': this.options.modalCloseBtnHandler ? this.options.modalCloseBtnHandler : this.closeModal\n            });\n            this._on(this.element, {\n                'openModal': this.openModal,\n                'closeModal': this.closeModal\n            });\n            this.options.autoOpen ? this.openModal() : false;\n        },\n\n        /**\n         * Returns element from modal node.\n         * @return {Object} - element.\n         */\n        _getElem: function (elem) {\n            return this.modal.find(elem);\n        },\n\n        /**\n         * Gets visible modal count.\n         * * @return {Number} - visible modal count.\n         */\n        _getVisibleCount: function () {\n            var modals = this.modalWrapper.find(this.options.modalBlock);\n\n            return modals.filter('.' + this.options.modalVisibleClass).length;\n        },\n\n        /**\n         * Gets count of visible modal by slide type.\n         * * @return {Number} - visible modal count.\n         */\n        _getVisibleSlideCount: function () {\n            var elems = this.modalWrapper.find('[data-type=\"slide\"]');\n\n            return elems.filter('.' + this.options.modalVisibleClass).length;\n        },\n\n        /**\n         * Listener key events.\n         * Call handler function if it exists\n         */\n        keyEventSwitcher: function (event) {\n            var key = keyCodes[event.keyCode];\n\n            if (this.options.keyEventHandlers.hasOwnProperty(key)) {\n                this.options.keyEventHandlers[key].apply(this, arguments);\n            }\n        },\n\n        /**\n         * Set title for modal.\n         *\n         * @param {String} title\n         */\n        setTitle: function (title) {\n            var $title = this.modal.find(this.options.modalTitle),\n                $subTitle = this.modal.find(this.options.modalSubTitle);\n\n            $title.text(title);\n            $title.append($subTitle);\n        },\n\n        /**\n         * Set sub title for modal.\n         *\n         * @param {String} subTitle\n         */\n        setSubTitle: function (subTitle) {\n            this.options.subTitle = subTitle;\n            this.modal.find(this.options.modalSubTitle).html(subTitle);\n        },\n\n        /**\n         * Toggle modal.\n         * * @return {Element} - current element.\n         */\n        toggleModal: function () {\n            if (this.options.isOpen === true) {\n                this.closeModal();\n            } else {\n                this.openModal();\n            }\n        },\n\n        /**\n         * Open modal.\n         * * @return {Element} - current element.\n         */\n        openModal: function () {\n            this.options.isOpen = true;\n            this.focussedElement = document.activeElement;\n            this._createOverlay();\n            this._setActive();\n            this._setKeyListener();\n            this.modal.one(this.options.transitionEvent, _.bind(this._setFocus, this, 'end', 'opened'));\n            this.modal.one(this.options.transitionEvent, _.bind(this._trigger, this, 'opened'));\n            this.modal.addClass(this.options.modalVisibleClass);\n\n            if (!this.options.transitionEvent) {\n                this._trigger('opened');\n            }\n\n            return this.element;\n        },\n\n        /**\n         * Set focus to element.\n         * @param {String} position - can be \"start\" and \"end\"\n         *      positions.\n         *      If position is \"end\" - sets focus to first\n         *      focusable element in modal window scope.\n         *      If position is \"start\" - sets focus to last\n         *      focusable element in modal window scope\n         *\n         *  @param {String} type - can be \"opened\" or false\n         *      If type is \"opened\" - looks to \"this.options.focus\"\n         *      property and sets focus\n         */\n        _setFocus: function (position, type) {\n            var focusableElements,\n                infelicity;\n\n            if (type === 'opened' && this.options.focus) {\n                this.modal.find($(this.options.focus)).trigger('focus');\n            } else if (type === 'opened' && !this.options.focus) {\n                this.modal.find(this.options.focusableScope).trigger('focus');\n            } else if (position === 'end') {\n                this.modal.find(this.options.modalCloseBtn).trigger('focus');\n            } else if (position === 'start') {\n                infelicity = 2; //Constant for find last focusable element\n                focusableElements = this.modal.find(':focusable');\n                focusableElements.eq(focusableElements.length - infelicity).trigger('focus');\n            }\n        },\n\n        /**\n         * Set events listener when modal is opened.\n         */\n        _setKeyListener: function () {\n            this.modal.find(this.options.focusableStart).on('focusin', this._tabSwitcher);\n            this.modal.find(this.options.focusableEnd).on('focusin', this._tabSwitcher);\n            this.modal.on('keydown', this.keyEventSwitcher);\n        },\n\n        /**\n         * Remove events listener when modal is closed.\n         */\n        _removeKeyListener: function () {\n            this.modal.find(this.options.focusableStart).off('focusin', this._tabSwitcher);\n            this.modal.find(this.options.focusableEnd).off('focusin', this._tabSwitcher);\n            this.modal.off('keydown', this.keyEventSwitcher);\n        },\n\n        /**\n         * Switcher for focus event.\n         * @param {Object} e - event\n         */\n        _tabSwitcher: function (e) {\n            var target = $(e.target);\n\n            if (target.is(this.options.focusableStart)) {\n                this._setFocus('start');\n            } else if (target.is(this.options.focusableEnd)) {\n                this._setFocus('end');\n            }\n        },\n\n        /**\n         * Close modal.\n         * * @return {Element} - current element.\n         */\n        closeModal: function () {\n            var that = this;\n\n            this._removeKeyListener();\n            this.options.isOpen = false;\n            this.modal.one(this.options.transitionEvent, function () {\n                that._close();\n            });\n            this.modal.removeClass(this.options.modalVisibleClass);\n\n            if (!this.options.transitionEvent) {\n                that._close();\n            }\n\n            return this.element;\n        },\n\n        /**\n         * Helper for closeModal function.\n         */\n        _close: function () {\n            var trigger = _.bind(this._trigger, this, 'closed', this.modal);\n\n            $(this.focussedElement).trigger('focus');\n            this._destroyOverlay();\n            this._unsetActive();\n            _.defer(trigger, this);\n        },\n\n        /**\n         * Set z-index and margin for modal and overlay.\n         */\n        _setActive: function () {\n            var zIndex = this.modal.zIndex(),\n                baseIndex = zIndex + this._getVisibleCount();\n\n            if (this.modal.data('active')) {\n                return;\n            }\n\n            this.modal.data('active', true);\n\n            this.overlay.zIndex(++baseIndex);\n            this.prevOverlayIndex = this.overlay.zIndex();\n            this.modal.zIndex(this.overlay.zIndex() + 1);\n\n            if (this._getVisibleSlideCount()) {\n                this.modal.css('marginLeft', this.options.modalLeftMargin * this._getVisibleSlideCount());\n            }\n        },\n\n        /**\n         * Unset styles for modal and set z-index for previous modal.\n         */\n        _unsetActive: function () {\n            this.modal.removeAttr('style');\n            this.modal.data('active', false);\n\n            if (this.overlay) {\n                this.overlay.zIndex(this.prevOverlayIndex - 1);\n            }\n        },\n\n        /**\n         * Creates wrapper to hold all modals.\n         */\n        _createWrapper: function () {\n            this.modalWrapper = $(this.options.appendTo).find('.' + this.options.wrapperClass);\n\n            if (!this.modalWrapper.length) {\n                this.modalWrapper = $('<div></div>')\n                    .addClass(this.options.wrapperClass)\n                    .appendTo(this.options.appendTo);\n            }\n        },\n\n        /**\n         * Compile template and append to wrapper.\n         */\n        _renderModal: function () {\n            $(template(\n                this.options[this.options.type + 'Tpl'],\n                {\n                    data: this.options\n                })).appendTo(this.modalWrapper);\n            this.modal = this.modalWrapper.find(this.options.modalBlock).last();\n            this.element.appendTo(this._getElem(this.options.modalContent));\n\n            if (this.element.is(':hidden')) {\n                this.element.show();\n            }\n        },\n\n        /**\n         * Creates buttons pane.\n         */\n        _createButtons: function () {\n            this.buttons = this._getElem(this.options.modalAction);\n            _.each(this.options.buttons, function (btn, key) {\n                var button = this.buttons[key];\n\n                if (btn.attr) {\n                    $(button).attr(btn.attr);\n                }\n\n                if (btn.class) {\n                    $(button).addClass(btn.class);\n                }\n\n                if (!btn.click) {\n                    btn.click = this.closeModal;\n                }\n                $(button).on('click', _.bind(btn.click, this));\n            }, this);\n        },\n\n        /**\n         * Creates overlay, append it to wrapper, set previous click event on overlay.\n         */\n        _createOverlay: function () {\n            var events,\n                outerClickHandler = this.options.outerClickHandler || this.closeModal;\n\n            this.overlay = $('.' + this.options.overlayClass);\n\n            if (!this.overlay.length) {\n                $(this.options.appendTo).addClass(this.options.parentModalClass);\n                this.overlay = $('<div></div>')\n                    .addClass(this.options.overlayClass)\n                    .appendTo(this.modalWrapper);\n            }\n            events = $._data(this.overlay.get(0), 'events');\n            events ? this.prevOverlayHandler = events.click[0].handler : false;\n            this.options.clickableOverlay ? this.overlay.off().on('click', outerClickHandler) : false;\n        },\n\n        /**\n         * Destroy overlay.\n         */\n        _destroyOverlay: function () {\n            if (this._getVisibleCount()) {\n                this.overlay.off().on('click', this.prevOverlayHandler);\n            } else {\n                $(this.options.appendTo).removeClass(this.options.parentModalClass);\n                this.overlay.remove();\n                this.overlay = null;\n            }\n        }\n    });\n\n    return $.mage.modal;\n});\n","Magento_Ui/js/modal/modalToggle.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal'\n], function ($) {\n    'use strict';\n\n    return function (config, el) {\n        var widget,\n            content;\n\n        if (config.contentSelector) {\n            content = $(config.contentSelector);\n        } else if (config.content) {\n            content = $('<div></div>').html(config.content);\n        } else {\n            content = $('<div></div>');\n        }\n\n        widget = content.modal(config);\n\n        $(el).on(config.toggleEvent, function () {\n            var state = widget.data('mage-modal').options.isOpen;\n\n            if (state) {\n                widget.modal('closeModal');\n            } else {\n                widget.modal('openModal');\n            }\n\n            return false;\n        });\n\n        return widget;\n    };\n});\n","Magento_Ui/js/modal/prompt.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'text!ui/template/modal/modal-prompt-content.html',\n    'jquery-ui-modules/widget',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function ($, _, template, promptContentTmpl) {\n    'use strict';\n\n    $.widget('mage.prompt', $.mage.modal, {\n        options: {\n            modalClass: 'prompt',\n            promptContentTmpl: promptContentTmpl,\n            promptField: '[data-role=\"promptField\"]',\n            attributesForm: {},\n            attributesField: {},\n            value: '',\n            validation: false,\n            validationRules: [],\n            keyEventHandlers: {\n\n                /**\n                 * Enter key press handler,\n                 * submit result and close modal window\n                 * @param {Object} event - event\n                 */\n                enterKey: function (event) {\n                    if (this.options.isOpen && this.modal.find(document.activeElement).length ||\n                        this.options.isOpen && this.modal[0] === document.activeElement) {\n                        this.closeModal(true);\n                        event.preventDefault();\n                    }\n                },\n\n                /**\n                 * Tab key press handler,\n                 * set focus to elements\n                 */\n                tabKey: function () {\n                    if (document.activeElement === this.modal[0]) {\n                        this._setFocus('start');\n                    }\n                },\n\n                /**\n                 * Escape key press handler,\n                 * cancel and close modal window\n                 * @param {Object} event - event\n                 */\n                escapeKey: function (event) {\n                    if (this.options.isOpen && this.modal.find(document.activeElement).length ||\n                        this.options.isOpen && this.modal[0] === document.activeElement) {\n                        this.closeModal();\n                        event.preventDefault();\n                    }\n                }\n            },\n            actions: {\n\n                /**\n                 * Callback always - called on all actions.\n                 */\n                always: function () {},\n\n                /**\n                 * Callback confirm.\n                 */\n                confirm: function () {},\n\n                /**\n                 * Callback cancel.\n                 */\n                cancel: function () {}\n            },\n            buttons: [{\n                text: $.mage.__('Cancel'),\n                class: 'action-secondary action-dismiss',\n\n                /**\n                 * Click handler.\n                 */\n                click: function () {\n                    this.closeModal();\n                }\n            }, {\n                text: $.mage.__('OK'),\n                class: 'action-primary action-accept',\n\n                /**\n                 * Click handler.\n                 */\n                click: function () {\n                    this.closeModal(true);\n                }\n            }]\n        },\n\n        /**\n         * Create widget.\n         */\n        _create: function () {\n            this.options.focus = this.options.promptField;\n            this.options.validation = this.options.validation && this.options.validationRules.length;\n            this.options.outerClickHandler = this.options.outerClickHandler || _.bind(this.closeModal, this, false);\n            this._super();\n            this.modal.find(this.options.modalContent).append(this.getFormTemplate());\n            this.modal.find(this.options.modalCloseBtn).off().on('click',  _.bind(this.closeModal, this, false));\n\n            if (this.options.validation) {\n                this.setValidationClasses();\n            }\n\n            this.openModal();\n        },\n\n        /**\n         * Form template getter.\n         *\n         * @returns {Object} Form template.\n         */\n        getFormTemplate: function () {\n            var formTemplate,\n                formAttr = '',\n                inputAttr = '',\n                attributeName;\n\n            for (attributeName in this.options.attributesForm) {\n                if (this.options.attributesForm.hasOwnProperty(attributeName)) {\n                    formAttr = formAttr + ' ' + attributeName + '=\"' +\n                        this.options.attributesForm[attributeName] + '\"';\n                }\n            }\n\n            for (attributeName in this.options.attributesField) {\n                if (this.options.attributesField.hasOwnProperty(attributeName)) {\n                    inputAttr = inputAttr + ' ' + attributeName + '=\"' +\n                        this.options.attributesField[attributeName] + '\"';\n                }\n            }\n\n            formTemplate = $(template(this.options.promptContentTmpl, {\n                data: this.options,\n                formAttr: formAttr,\n                inputAttr: inputAttr\n            }));\n\n            return formTemplate;\n        },\n\n        /**\n         * Remove widget\n         */\n        _remove: function () {\n            this.modal.remove();\n        },\n\n        /**\n         * Validate prompt field\n         */\n        validate: function () {\n            return $.validator.validateSingleElement(this.options.promptField);\n        },\n\n        /**\n         * Add validation classes to prompt field\n         */\n        setValidationClasses: function () {\n            this.modal.find(this.options.promptField).attr('class', $.proxy(function (i, val) {\n                return val + ' ' + this.options.validationRules.join(' ');\n            }, this));\n        },\n\n        /**\n         * Open modal window\n         */\n        openModal: function () {\n            this._super();\n            this.modal.find(this.options.promptField).val(this.options.value);\n        },\n\n        /**\n         * Close modal window\n         */\n        closeModal: function (result) {\n            var value;\n\n            if (result) {\n                if (this.options.validation && !this.validate()) {\n                    return false;\n                }\n\n                value = this.modal.find(this.options.promptField).val();\n                this.options.actions.confirm.call(this, value);\n            } else {\n                this.options.actions.cancel.call(this, result);\n            }\n\n            this.options.actions.always();\n            this.element.on('promptclosed', _.bind(this._remove, this));\n\n            return this._super();\n        }\n    });\n\n    return function (config) {\n        return $('<div class=\"prompt-message\"></div>').html(config.content).prompt(config);\n    };\n});\n","Magento_Ui/js/timeline/timeline-view.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'ko',\n    'Magento_Ui/js/lib/view/utils/async',\n    'underscore',\n    'Magento_Ui/js/lib/view/utils/raf',\n    'uiRegistry',\n    'uiClass'\n], function (ko, $, _, raf, registry, Class) {\n    'use strict';\n\n    var hasClassList = (function () {\n        var list = document.createElement('_').classList;\n\n        return !!list && !list.toggle('_test', false);\n    })();\n\n    /**\n     * Polyfill of the 'classList.toggle' method.\n     *\n     * @param {HTMLElement} elem\n     */\n    function toggleClass(elem) {\n        var classList   = elem.classList,\n            args        = Array.prototype.slice.call(arguments, 1),\n            $elem;\n\n        if (hasClassList) {\n            classList.toggle.apply(classList, args);\n        } else {\n            $elem = $(elem);\n            $elem.toggleClass.apply($elem, args);\n        }\n    }\n\n    return Class.extend({\n        defaults: {\n            selectors: {\n                content: '.timeline-content',\n                timeUnit: '.timeline-unit',\n                item: '.timeline-item:not([data-role=no-data-msg])',\n                event: '.timeline-event'\n            }\n        },\n\n        /**\n         * Initializes TimelineView component.\n         *\n         * @returns {TimelineView} Chainable.\n         */\n        initialize: function () {\n            _.bindAll(\n                this,\n                'refresh',\n                'initContent',\n                'initItem',\n                'initTimeUnit',\n                'getItemBindings',\n                'updateItemsPosition',\n                'onScaleChange',\n                'onEventElementRender',\n                'onWindowResize',\n                'onContentScroll',\n                'onDataReloaded',\n                'onToStartClick',\n                'onToEndClick'\n            );\n\n            this._super()\n                .initModel()\n                .waitContent();\n\n            return this;\n        },\n\n        /**\n         * Applies listeners for the model properties changes.\n         *\n         * @returns {TimelineView} Chainable.\n         */\n        initModel: function () {\n            var model = registry.get(this.model);\n\n            model.on('scale', this.onScaleChange);\n            model.source.on('reloaded', this.onDataReloaded);\n\n            this.model = model;\n\n            return this;\n        },\n\n        /**\n         * Applies DOM watcher for the\n         * content element rendering.\n         *\n         * @returns {TimelineView} Chainable.\n         */\n        waitContent: function () {\n            $.async({\n                selector: this.selectors.content,\n                component: this.model\n            }, this.initContent);\n\n            return this;\n        },\n\n        /**\n         * Initializes timelines' content element.\n         *\n         * @param {HTMLElement} content\n         * @returns {TimelineView} Chainable.\n         */\n        initContent: function (content) {\n            this.$content = content;\n\n            $(content).on('scroll', this.onContentScroll);\n            $(window).on('resize', this.onWindowResize);\n\n            $.async(this.selectors.item, content, this.initItem);\n            $.async(this.selectors.event, content, this.onEventElementRender);\n            $.async(this.selectors.timeUnit, content, this.initTimeUnit);\n\n            this.refresh();\n\n            return this;\n        },\n\n        /**\n         * Initializes timeline item element,\n         * e.g. establishes event listeners and applies data bindings.\n         *\n         * @param {HTMLElement} elem\n         * @returns {TimelineView} Chainable.\n         */\n        initItem: function (elem) {\n            $(elem)\n                .bindings(this.getItemBindings)\n                .on('click', '._toend', this.onToEndClick)\n                .on('click', '._tostart', this.onToStartClick);\n\n            return this;\n        },\n\n        /**\n         * Initializes timeline unit element.\n         *\n         * @param {HTMLElement} elem\n         * @returns {TimelineView} Chainable.\n         */\n        initTimeUnit: function (elem) {\n            $(elem).bindings(this.getTimeUnitBindings());\n\n            return this;\n        },\n\n        /**\n         * Updates items positions in a\n         * loop if state of a view has changed.\n         */\n        refresh: function () {\n            raf(this.refresh);\n\n            if (this._update) {\n                this._update = false;\n\n                this.updateItemsPosition();\n            }\n        },\n\n        /**\n         * Returns object width additional bindings\n         * for a timeline unit element.\n         *\n         * @returns {Object}\n         */\n        getTimeUnitBindings: function () {\n            return {\n                style: {\n                    width: ko.computed(function () {\n                        return this.getTimeUnitWidth() + '%';\n                    }.bind(this))\n                }\n            };\n        },\n\n        /**\n         * Returns object with additional\n         * bindings for a timeline item element.\n         *\n         * @param {Object} ctx\n         * @returns {Object}\n         */\n        getItemBindings: function (ctx) {\n            return {\n                style: {\n                    width: ko.computed(function () {\n                        return this.getItemWidth(ctx.$row()) + '%';\n                    }.bind(this)),\n\n                    'margin-left': ko.computed(function () {\n                        return this.getItemMargin(ctx.$row()) + '%';\n                    }.bind(this))\n                }\n            };\n        },\n\n        /**\n         * Calculates width in percents of a timeline unit element.\n         *\n         * @returns {Number}\n         */\n        getTimeUnitWidth: function () {\n            return 100 / this.model.scale;\n        },\n\n        /**\n         * Calculates width of a record in percents.\n         *\n         * @param {Object} record\n         * @returns {String}\n         */\n        getItemWidth: function (record) {\n            var days = 0;\n\n            if (record) {\n                days = this.model.getDaysLength(record);\n            }\n\n            return this.getTimeUnitWidth()  * days;\n        },\n\n        /**\n         * Calculates left margin value for provided record.\n         *\n         * @param {Object} record\n         * @returns {String}\n         */\n        getItemMargin: function (record) {\n            var offset = 0;\n\n            if (record) {\n                offset = this.model.getStartDelta(record);\n            }\n\n            return this.getTimeUnitWidth() * offset;\n        },\n\n        /**\n         * Returns collection of currently available\n         * timeline item elements.\n         *\n         * @returns {Array<HTMLElement>}\n         */\n        getItems: function () {\n            var items = this.$content.querySelectorAll(this.selectors.item);\n\n            return _.toArray(items);\n        },\n\n        /**\n         * Updates positions of timeline elements.\n         *\n         * @returns {TimelineView} Chainable.\n         */\n        updateItemsPosition: function () {\n            this.getItems()\n                .forEach(this.updatePositionFor, this);\n\n            return this;\n        },\n\n        /**\n         * Updates position of provided timeline element.\n         *\n         * @param {HTMLElement} $elem\n         * @returns {TimelineView} Chainable.\n         */\n        updatePositionFor: function ($elem) {\n            var $event      = $elem.querySelector(this.selectors.event),\n                leftEdge    = this.getLeftEdgeFor($elem),\n                rightEdge   = this.getRightEdgeFor($elem);\n\n            if ($event) {\n                $event.style.left = Math.max(-leftEdge, 0) + 'px';\n                $event.style.right = Math.max(rightEdge, 0) + 'px';\n            }\n\n            toggleClass($elem, '_scroll-start', leftEdge < 0);\n            toggleClass($elem, '_scroll-end', rightEdge > 0);\n\n            return this;\n        },\n\n        /**\n         * Scrolls content area to the start of provided element.\n         *\n         * @param {HTMLElement} elem\n         * @returns {TimelineView}\n         */\n        toStartOf: function (elem) {\n            var leftEdge = this.getLeftEdgeFor(elem);\n\n            this.$content.scrollLeft += leftEdge;\n\n            return this;\n        },\n\n        /**\n         * Scrolls content area to the end of provided element.\n         *\n         * @param {HTMLElement} elem\n         * @returns {TimelineView}\n         */\n        toEndOf: function (elem) {\n            var rightEdge = this.getRightEdgeFor(elem);\n\n            this.$content.scrollLeft += rightEdge + 1;\n\n            return this;\n        },\n\n        /**\n         * Calculates location of the left edge of an element\n         * relative to the contents' left edge.\n         *\n         * @param {HTMLElement} elem\n         * @returns {Number}\n         */\n        getLeftEdgeFor: function (elem) {\n            var leftOffset = elem.getBoundingClientRect().left;\n\n            return leftOffset - this.$content.getBoundingClientRect().left;\n        },\n\n        /**\n         * Calculates location of the right edge of an element\n         * relative to the contents' right edge.\n         *\n         * @param {HTMLElement} elem\n         * @returns {Number}\n         */\n        getRightEdgeFor: function (elem) {\n            var elemWidth   = elem.offsetWidth,\n                leftEdge    = this.getLeftEdgeFor(elem);\n\n            return leftEdge + elemWidth - this.$content.offsetWidth;\n        },\n\n        /**\n         * 'To Start' button 'click' event handler.\n         *\n         * @param {jQueryEvent} event\n         */\n        onToStartClick: function (event) {\n            var elem = event.originalEvent.currentTarget;\n\n            event.stopPropagation();\n\n            this.toStartOf(elem);\n        },\n\n        /**\n         * 'To End' button 'click' event handler.\n         *\n         * @param {jQueryEvent} event\n         */\n        onToEndClick: function (event) {\n            var elem = event.originalEvent.currentTarget;\n\n            event.stopPropagation();\n\n            this.toEndOf(elem);\n        },\n\n        /**\n         * Handler of the scale value 'change' event.\n         */\n        onScaleChange: function () {\n            this._update = true;\n        },\n\n        /**\n         * Callback function which is invoked\n         * when event element was rendered.\n         */\n        onEventElementRender: function () {\n            this._update = true;\n        },\n\n        /**\n         * Window 'resize' event handler.\n         */\n        onWindowResize: function () {\n            this._update = true;\n        },\n\n        /**\n         * Content container 'scroll' event handler.\n         */\n        onContentScroll: function () {\n            this._update = true;\n        },\n\n        /**\n         * Data 'reload' event handler.\n         */\n        onDataReloaded: function () {\n            this._update = true;\n        }\n    });\n});\n","Magento_Ui/js/timeline/timeline.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'moment',\n    'uiLayout',\n    'Magento_Ui/js/grid/listing'\n], function (_, moment, layout, Listing) {\n    'use strict';\n\n    var ONE_DAY = 86400000;\n\n    return Listing.extend({\n        defaults: {\n            recordTmpl: 'ui/timeline/record',\n            dateFormat: 'YYYY-MM-DD HH:mm:ss',\n            headerFormat: 'ddd MM/DD',\n            detailsFormat: 'DD/MM/YYYY HH:mm:ss',\n            scale: 7,\n            scaleStep: 1,\n            minScale: 7,\n            maxScale: 28,\n            minDays: 28,\n            displayMode: 'timeline',\n            displayModes: {\n                timeline: {\n                    label: 'Timeline',\n                    value: 'timeline',\n                    template: 'ui/timeline/timeline'\n                }\n            },\n            viewConfig: {\n                component: 'Magento_Ui/js/timeline/timeline-view',\n                name: '${ $.name }_view',\n                model: '${ $.name }'\n            },\n            tracks: {\n                scale: true\n            },\n            statefull: {\n                scale: true\n            },\n            range: {}\n        },\n\n        /**\n         * Initializes Timeline component.\n         *\n         * @returns {Timeline} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initView()\n                .updateRange();\n\n            return this;\n        },\n\n        /**\n         * Initializes components configuration.\n         *\n         * @returns {Timeline} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n\n            this.maxScale = Math.min(this.minDays, this.maxScale);\n            this.minScale = Math.min(this.maxScale, this.minScale);\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Timeline} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe.call(this.range, true, 'hasToday');\n\n            return this;\n        },\n\n        /**\n         * Initializes TimelineView component.\n         *\n         * @returns {Timeline} Chainable.\n         */\n        initView: function () {\n            layout([this.viewConfig]);\n\n            return this;\n        },\n\n        /**\n         * Checks if provided event record is active,\n         * i.e. it has already started.\n         *\n         * @param {Object} record\n         * @returns {Boolean}\n         */\n        isActive: function (record) {\n            return Number(record.status) === 1;\n        },\n\n        /**\n         * Checks if provided event record is upcoming,\n         * i.e. it will start later on.\n         *\n         * @param {Object} record\n         * @returns {Boolean}\n         */\n        isUpcoming: function (record) {\n            return Number(record.status) === 2;\n        },\n\n        /**\n         * Checks if provided event record is permanent,\n         * i.e. it has no ending time.\n         *\n         * @param {Object} record\n         * @returns {Boolean}\n         */\n        isPermanent: function (record) {\n            return !this.getEndDate(record);\n        },\n\n        /**\n         * Checks if provided date indicates current day.\n         *\n         * @param {(Number|Moment)} date\n         * @returns {Boolenan}\n         */\n        isToday: function (date) {\n            return moment().isSame(date, 'day');\n        },\n\n        /**\n         * Checks if range object contains todays date.\n         *\n         * @returns {Boolean}\n         */\n        hasToday: function () {\n            return this.range.hasToday;\n        },\n\n        /**\n         * Returns start date of provided record.\n         *\n         * @param {Object} record\n         * @returns {String}\n         */\n        getStartDate: function (record) {\n            return record['start_time'];\n        },\n\n        /**\n         * Returns end date of provided record.\n         *\n         * @param {Object} record\n         * @returns {String}\n         */\n        getEndDate: function (record) {\n            return record['end_time'];\n        },\n\n        /**\n         * Returns difference in days between records' start date\n         * and a first day of a range.\n         *\n         * @param {Object} record\n         * @returns {Number}\n         */\n        getStartDelta: function (record) {\n            var start    = this.createDate(this.getStartDate(record)),\n                firstDay = this.range.firstDay;\n\n            return start.diff(firstDay, 'days', true);\n        },\n\n        /**\n         * Calculates the amount of days that provided event lasts.\n         *\n         * @param {Object} record\n         * @returns {Number}\n         */\n        getDaysLength: function (record) {\n            var start   = this.createDate(this.getStartDate(record)),\n                end     = this.createDate(this.getEndDate(record));\n\n            if (!end.isValid()) {\n                end = this.range.lastDay.endOf('day');\n            }\n\n            return end.diff(start, 'days', true);\n        },\n\n        /**\n         * Creates new date object based on provided date string value.\n         *\n         * @param {String} dateStr\n         * @returns {Moment}\n         */\n        createDate: function (dateStr) {\n            return moment(dateStr, this.dateFormat);\n        },\n\n        /**\n         * Converts days to weeks.\n         *\n         * @param {Number} days\n         * @returns {Number}\n         */\n        daysToWeeks: function (days) {\n            var weeks = days / 7;\n\n            if (weeks % 1) {\n                weeks = weeks.toFixed(1);\n            }\n\n            return weeks;\n        },\n\n        /**\n         * Updates data of a range object,\n         * e.g. total days, first day and last day, etc.\n         *\n         * @returns {Object} Range instance.\n         */\n        updateRange: function () {\n            var firstDay    = this._getFirstDay(),\n                lastDay     = this._getLastDay(),\n                totalDays   = lastDay.diff(firstDay, 'days'),\n                days        = [],\n                i           = -1;\n\n            if (totalDays < this.minDays) {\n                totalDays += this.minDays - totalDays - 1;\n            }\n\n            while (++i <= totalDays) {\n                days.push(+firstDay + ONE_DAY * i);\n            }\n\n            return _.extend(this.range, {\n                days:       days,\n                totalDays:  totalDays,\n                firstDay:   firstDay,\n                lastDay:    moment(_.last(days)),\n                hasToday:   this.isToday(firstDay)\n            });\n        },\n\n        /**\n         *\n         * @private\n         * @param {String} key\n         * @returns {Array<Moment>}\n         */\n        _getDates: function (key) {\n            var dates = [];\n\n            this.rows.forEach(function (record) {\n                if (record[key]) {\n                    dates.push(this.createDate(record[key]));\n                }\n            }, this);\n\n            return dates;\n        },\n\n        /**\n         * Returns date which is closest to the current day.\n         *\n         * @private\n         * @returns {Moment}\n         */\n        _getFirstDay: function () {\n            var dates = this._getDates('start_time'),\n                first = moment.min(dates).subtract(1, 'day'),\n                today = moment();\n\n            if (!first.isValid() || first < today) {\n                first = today;\n            }\n\n            return first.startOf('day');\n        },\n\n        /**\n         * Returns the most distant date\n         * specified in available records.\n         *\n         * @private\n         * @returns {Moment}\n         */\n        _getLastDay: function () {\n            var startDates  = this._getDates('start_time'),\n                endDates    = this._getDates('end_time'),\n                last        = moment.max(startDates.concat(endDates));\n\n            return last.add(1, 'day').startOf('day');\n        },\n\n        /**\n         * TODO: remove after integration with date binding.\n         *\n         * @param {Number} timestamp\n         * @returns {String}\n         */\n        formatHeader: function (timestamp) {\n            return moment(timestamp).format(this.headerFormat);\n        },\n\n        /**\n         * TODO: remove after integration with date binding.\n         *\n         * @param {String} date\n         * @returns {String}\n         */\n        formatDetails: function (date) {\n            return moment(date).format(this.detailsFormat);\n        }\n    });\n});\n","Magento_UrlRewrite/js/url-rewrite-validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/backend/form',\n    'mage/backend/validation'\n], function ($) {\n    'use strict';\n\n    return function (data, element) {\n\n        $(element).form().validation({\n            validationUrl: data.url\n        });\n    };\n});\n","Magento_User/js/delete-user-account.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    var postData;\n\n    return function (params, elem) {\n\n        elem.on('click', function () {\n\n            postData = {\n                'data': {\n                    'user_id': params.objId,\n                    'current_password': $('[name=\"current_password\"]').val()\n                }\n            };\n\n            if ($.validator.validateElement($('[name=\"current_password\"]'))) {\n                window.deleteConfirm(params.message, params.url, postData);\n            }\n        });\n    };\n});\n","Magento_User/js/roles-tree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'jquery/ui',\n    'jquery/jstree/jquery.jstree'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.rolesTree', {\n        options: {\n            treeInitData: {},\n            editFormSelector: '',\n            resourceFieldName: 'resource[]',\n            checkboxVisible: true\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.element.jstree({\n                plugins: ['checkbox'],\n                checkbox: {\n                    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                    three_state: false,\n                    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                    visible: this.options.checkboxVisible,\n                    cascade: 'undetermined'\n                },\n                core: {\n                    data: this.options.treeInitData,\n                    themes: {\n                        dots: false\n                    }\n                }\n            });\n            this._bind();\n        },\n\n        /**\n         * @private\n         */\n        _destroy: function () {\n            this.element.jstree('destroy');\n        },\n\n        /**\n         * @private\n         */\n        _bind: function () {\n            this.element.on('select_node.jstree', $.proxy(this._selectChildNodes, this));\n            this.element.on('deselect_node.jstree', $.proxy(this._deselectChildNodes, this));\n            this.element.on('changed.jstree', $.proxy(this._changedNode, this));\n        },\n\n        /**\n         * @param {Event} event\n         * @param {Object} selected\n         * @private\n         */\n        _selectChildNodes: function (event, selected) {\n            // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            selected.instance.open_node(selected.node);\n            selected.node.children.each(function (id) {\n                var selector = '[id=\"' + id + '\"]';\n\n                selected.instance.select_node(\n                    selected.instance.get_node($(selector), false)\n                );\n            });\n            // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n        },\n\n        /**\n         * @param {Event} event\n         * @param {Object} selected\n         * @private\n         */\n        _deselectChildNodes: function (event, selected) {\n            selected.node.children.each(function (id) {\n                var selector = '[id=\"' + id + '\"]';\n\n                // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                selected.instance.deselect_node(\n                    selected.instance.get_node($(selector), false)\n                );\n                // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n            });\n        },\n\n        /**\n         * Add selected resources to form to be send later\n         *\n         * @param {Event} event\n         * @param {Object} selected\n         * @private\n         */\n        _changedNode: function (event, selected) {\n            var form = $(this.options.editFormSelector),\n                fieldName = this.options.resourceFieldName,\n                items = selected.selected.concat($(this.element).jstree('get_undetermined'));\n\n            if (this.options.editFormSelector === '') {\n                return;\n            }\n            form.find('input[name=\"' + this.options.resourceFieldName +  '\"]').remove();\n            items.each(function (id) {\n                $('<input>', {\n                    type: 'hidden',\n                    name: fieldName,\n                    value: id\n                }).appendTo(form);\n            });\n        }\n    });\n\n    return $.mage.rolesTree;\n});\n","Magento_Variable/variables.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global Variables, updateElementAtCursor, MagentovariablePlugin, Base64 */\ndefine([\n    'jquery',\n    'mage/backend/notification',\n    'mage/translate',\n    'wysiwygAdapter',\n    'uiRegistry',\n    'mage/apply/main',\n    'mageUtils',\n    'Magento_Variable/js/config-directive-generator',\n    'Magento_Variable/js/custom-directive-generator',\n    'Magento_Ui/js/lib/spinner',\n    'jquery/ui',\n    'prototype',\n    'mage/adminhtml/tools'\n], function (jQuery, notification, $t, wysiwyg, registry, mageApply, utils, configGenerator, customGenerator, loader) {\n    'use strict';\n\n    window.Variables = {\n        textareaElementId: null,\n        variablesContent: null,\n        dialogWindow: null,\n        dialogWindowId: 'variables-chooser',\n        overlayShowEffectOptions: null,\n        overlayHideEffectOptions: null,\n        insertFunction: 'Variables.insertVariable',\n        selectedPlaceholder: null,\n        isEditMode: null,\n        editor: null,\n\n        /**\n         * Initialize Variables handler.\n         *\n         * @param {*} textareaElementId\n         * @param {Function} insertFunction\n         * @param {Object} editor\n         * @param {Object} selectedPlaceholder\n         */\n        init: function (textareaElementId, insertFunction, editor, selectedPlaceholder) {\n            if ($(textareaElementId)) {\n                this.textareaElementId = textareaElementId;\n            }\n\n            if (insertFunction) {\n                this.insertFunction = insertFunction;\n            }\n\n            if (selectedPlaceholder) {\n                this.selectedPlaceholder = selectedPlaceholder;\n            }\n\n            if (editor) {\n                this.editor = editor;\n            }\n        },\n\n        /**\n         * Reset data.\n         */\n        resetData: function () {\n            this.variablesContent = null;\n            this.dialogWindow = null;\n        },\n\n        /**\n         * Open variables chooser slideout.\n         *\n         * @param {Object} variables\n         */\n        openVariableChooser: function (variables) {\n            if (variables) {\n                this.openDialogWindow(variables);\n            }\n        },\n\n        /**\n         * Close variables chooser slideout dialog window.\n         */\n        closeDialogWindow: function () {\n            jQuery('#' + this.dialogWindowId).modal('closeModal');\n        },\n\n        /**\n         * Init ui component grid on the form\n         *\n         * @return void\n         */\n        initUiGrid: function () {\n            mageApply.apply(document.getElementById(this.dialogWindow));\n            jQuery('#' + this.dialogWindowId).applyBindings();\n            loader.get('variables_modal.variables_modal.variables').hide();\n        },\n\n        /**\n         * Open slideout dialog window.\n         *\n         * @param {*} variablesContent\n         * @param {Object} selectedElement\n         */\n        openDialogWindow: function (variablesContent, selectedElement) {\n\n            var html = utils.copy(variablesContent),\n                self = this;\n\n            jQuery('<div id=\"' + this.dialogWindowId + '\">' + html + '</div>').modal({\n                title: self.isEditMode ? $t('Edit Variable') : $t('Insert Variable'),\n                type: 'slide',\n                buttons: self.getButtonsConfig(self.isEditMode),\n\n                /**\n                 * @param {jQuery.Event} e\n                 * @param {Object} modal\n                 */\n                closed: function (e, modal) {\n                    modal.modal.remove();\n                    registry.get(\n                        'variables_modal.variables_modal.variables.variable_selector',\n                        function (radioSelect) {\n                            radioSelect.selectedVariableCode('');\n                        }\n                    );\n                }\n            });\n\n            this.selectedPlaceholder = selectedElement;\n\n            this.addNotAvailableMessage(selectedElement);\n\n            jQuery('#' + this.dialogWindowId).modal('openModal');\n\n            if (typeof selectedElement !== 'undefined') {\n                registry.get(\n                    'variables_modal.variables_modal.variables.variable_selector',\n                    function (radioSelect) {\n                        radioSelect.selectedVariableCode(MagentovariablePlugin.getElementVariablePath(selectedElement));\n                    }\n                );\n            }\n        },\n\n        /**\n         * Add message to slide out that variable is no longer available\n         *\n         * @param {Object} selectedElement\n         */\n        addNotAvailableMessage: function (selectedElement) {\n            var name,\n                msg,\n                variablePath,\n                $wrapper,\n                lostVariableClass = 'magento-placeholder-error';\n\n            if (\n                this.isEditMode &&\n                typeof selectedElement !== 'undefined' &&\n                jQuery(selectedElement).hasClass(lostVariableClass)\n            ) {\n\n                variablePath = MagentovariablePlugin.getElementVariablePath(selectedElement);\n                name = variablePath.split(':');\n                msg = $t('The variable %1 is no longer available. Select a different variable.')\n                    .replace('%1', name[1]);\n\n                jQuery('body').notification('clear')\n                    .notification('add', {\n                        error: true,\n                        message: msg,\n\n                        /**\n                         * @param {String} message\n                         */\n                        insertMethod: function (message) {\n                            $wrapper = jQuery('<div></div>').html(message);\n\n                            jQuery('.modal-header .page-main-actions').after($wrapper);\n                        }\n                    });\n            }\n        },\n\n        /**\n         * Get selected variable directive.\n         *\n         * @returns {*}\n         */\n        getVariableCode: function () {\n            var code = registry.get('variables_modal.variables_modal.variables.variable_selector')\n                    .selectedVariableCode(),\n                directive = code;\n\n            // processing switch here as content must contain only path/code without type\n            if (typeof code !== 'undefined') {\n                if (code.match('^default:')) {\n                    directive = configGenerator.processConfig(code.replace('default:', ''));\n                } else if (code.match('^custom:')) {\n                    directive = customGenerator.processConfig(code.replace('custom:', ''));\n                }\n\n                return directive;\n            }\n        },\n\n        /**\n         * Get buttons configuration for slideout dialog.\n         *\n         * @param {Boolean} isEditMode\n         *\n         * @returns {Array}\n         */\n        getButtonsConfig: function (isEditMode) {\n\n            var self = this,\n                buttonsData;\n\n            buttonsData = [\n                {\n\n                    text: $t('Cancel'),\n                    'class': 'action-scalable cancel',\n\n                    /**\n                     * @param {jQuery.Event} event\n                     */\n                    click: function (event) {\n                        this.closeModal(event);\n                    }\n                },\n                {\n\n                    text: isEditMode ? $t('Save') : $t('Insert Variable'),\n                    class: 'action-primary ' + (isEditMode ? '' : 'disabled'),\n                    attr: {\n                        'id': 'insert_variable'\n                    },\n\n                    /**\n                     * Insert Variable\n                     */\n                    click: function () {\n                        self.insertVariable(self.getVariableCode());\n                    }\n                }\n            ];\n\n            return buttonsData;\n        },\n\n        /**\n         * Prepare variables row.\n         *\n         * @param {String} varValue\n         * @param {*} varLabel\n         * @return {String}\n         * @deprecated This method isn't relevant after ui changes\n         */\n        prepareVariableRow: function (varValue, varLabel) {\n            var value = varValue.replace(/\"/g, '&quot;').replace(/'/g, '\\\\&#39;');\n\n            return '<a href=\"#\" onclick=\"' +\n                this.insertFunction +\n                '(\\'' +\n                value +\n                '\\');return false;\">' +\n                varLabel +\n                '</a>';\n        },\n\n        /**\n         * Insert variable into WYSIWYG editor.\n         *\n         * @param {*} value\n         * @return {Object}\n         */\n        insertVariable: function (value) {\n            var windowId = this.dialogWindowId,\n                textareaElm, scrollPos, wysiwygEditorFocused;\n\n            jQuery('#' + windowId).modal('closeModal');\n            textareaElm = $(this.textareaElementId);\n\n            //to support switching between wysiwyg editors\n            wysiwygEditorFocused = wysiwyg && wysiwyg.activeEditor();\n\n            if (wysiwygEditorFocused && wysiwyg.get(this.textareaElementId)) {\n                if (jQuery(this.selectedPlaceholder).hasClass('magento-placeholder')) {\n                    wysiwyg.setCaretOnElement(this.selectedPlaceholder, 1);\n                }\n                wysiwyg.insertContent(value, false);\n\n                if (this.selectedPlaceholder && jQuery(this.selectedPlaceholder).hasClass('magento-placeholder')) {\n                    this.selectedPlaceholder.remove();\n                }\n\n            } else if (textareaElm) {\n                scrollPos = textareaElm.scrollTop;\n                updateElementAtCursor(textareaElm, value);\n                textareaElm.focus();\n                textareaElm.scrollTop = scrollPos;\n                jQuery(textareaElm).trigger('change');\n                textareaElm = null;\n            }\n\n            return this;\n        }\n\n    };\n\n    window.MagentovariablePlugin = {\n        editor: null,\n        variables: null,\n        textareaId: null,\n\n        /**\n         * Bind editor.\n         *\n         * @param {*} editor\n         */\n        setEditor: function (editor) {\n            this.editor = editor;\n        },\n\n        /**\n         * Load variables chooser.\n         *\n         * @param {String} url\n         * @param {*} textareaId\n         * @param {Object} selectedElement\n         *\n         * @return {Object}\n         */\n        loadChooser: function (url, textareaId, selectedElement) {\n            this.textareaId = textareaId;\n\n            new Ajax.Request(url, {\n                parameters: {},\n                onComplete: function (transport) {\n                    Variables.init(this.textareaId, 'MagentovariablePlugin.insertVariable', this.editor);\n                    Variables.isEditMode = !!this.getElementVariablePath(selectedElement);\n                    this.variablesContent = transport.responseText;\n                    Variables.openDialogWindow(this.variablesContent, selectedElement);\n                    Variables.initUiGrid();\n                }.bind(this)\n            });\n\n            return this;\n        },\n\n        /**\n         * Open variables chooser window.\n         *\n         * @param {*} variables\n         * @deprecated This method isn't relevant after ui changes\n         */\n        openChooser: function (variables) {\n            Variables.openVariableChooser(variables);\n        },\n\n        /**\n         * Insert variable.\n         *\n         * @param {*} value\n         *\n         * @return {Object}\n         */\n        insertVariable: function (value) {\n            if (this.textareaId) {\n                Variables.init(this.textareaId);\n                Variables.insertVariable(value);\n            } else {\n                Variables.closeDialogWindow();\n                Variables.insertVariable(value);\n            }\n\n            return this;\n        },\n\n        /**\n         * Get element variable path.\n         *\n         * @param {Object} element\n         * @returns {String}\n         */\n        getElementVariablePath: function (element) {\n            var type, code;\n\n            if (!element || !jQuery(element).hasClass('magento-variable')) {\n                return '';\n            }\n            type = jQuery(element).hasClass('magento-custom-var') ? 'custom' : 'default';\n            code = Base64.idDecode(element.getAttribute('id'));\n\n            return type + ':' + code;\n        }\n    };\n});\n","Magento_Variable/js/config-directive-generator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return _.extend({\n        directiveTemplate: '{{config path=\"%s\"}}',\n\n        /**\n         * @param {String} path\n         * @return {String}\n         */\n        processConfig: function (path) {\n            return this.directiveTemplate.replace('%s', path);\n\n        }\n\n    });\n\n});\n","Magento_Variable/js/custom-directive-generator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return _.extend({\n        directiveTemplate: '{{customVar code=%s}}',\n\n        /**\n         * @param {String} path\n         * @return {String}\n         */\n        processConfig: function (path) {\n            return this.directiveTemplate.replace('%s', path);\n        }\n\n    });\n\n});\n","Magento_Variable/js/grid/columns/radioselect.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'mage/translate',\n    'Magento_Ui/js/grid/columns/column',\n    'jquery'\n], function (_, $t, Column, jQuery) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Variable/grid/cells/radioselect',\n            draggable: false,\n            sortable: false,\n            selectedVariableCode: null,\n            selectedVariableType: null\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super().observe(['selectedVariableCode']);\n\n            return this;\n        },\n\n        /**\n         * Remove disable class from Insert Variable button after Variable has been chosen.\n         *\n         * @return {Boolean}\n         */\n        selectVariable: function () {\n            if (jQuery('#insert_variable').hasClass('disabled')) {\n                jQuery('#insert_variable').removeClass('disabled');\n            }\n\n            return true;\n        }\n    });\n});\n","Magento_Vault/js/vault.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/* @api */\ndefine([\n    'jquery',\n    'uiComponent'\n], function ($, Class) {\n    'use strict';\n\n    return Class.extend({\n        defaults: {\n            $selector: null,\n            selector: 'edit_form',\n            fieldset: '',\n            active: false,\n            imports: {\n                onActiveChange: 'active'\n            }\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this,\n                paymentSelector = '[name=\"payment[method]\"][value=\"' + this.getCode() + '\"]:checked';\n\n            self.$selector = $('#' + self.selector);\n            this._super()\n                .observe(['active']);\n\n            if (self.$selector.find(paymentSelector).length !== 0) {\n                this.active(true);\n            }\n\n            $('#' + self.fieldset).find('[name=\"payment[token_switcher]\"]')\n                .on('click', this.rememberTokenSwitcher.bind(this));\n\n            // re-init payment method events\n            self.$selector.off('changePaymentMethod.' + this.getCode())\n                .on('changePaymentMethod.' + this.getCode(), this.changePaymentMethod.bind(this));\n\n            if (this.active()) {\n                this.chooseTokenSwitcher();\n            }\n\n            return this;\n        },\n\n        /**\n         * Enable/disable current payment method\n         * @param {Object} event\n         * @param {String} method\n         * @returns {exports.changePaymentMethod}\n         */\n        changePaymentMethod: function (event, method) {\n            this.active(method === this.getCode());\n\n            return this;\n        },\n\n        /**\n         * Save last chosen token switcher\n         * @param {Object} event\n         * @returns {exports.rememberTokenSwitcher}\n         */\n        rememberTokenSwitcher: function (event) {\n            $('#' + this.selector).data('lastTokenSwitcherId', event.target.id);\n\n            return this;\n        },\n\n        /**\n         * Select token switcher\n         * @returns {exports.chooseTokenSwitcher}\n         */\n        chooseTokenSwitcher: function () {\n            var lastTokenSwitcherId = $('#' + this.selector).data('lastTokenSwitcherId');\n\n            if (lastTokenSwitcherId) {\n                $('#' + lastTokenSwitcherId).trigger('click');\n            } else {\n                $('#' + this.fieldset + ' input:radio:first').trigger('click');\n            }\n\n            return this;\n        },\n\n        /**\n         * Triggered when payment changed\n         * @param {Boolean} isActive\n         */\n        onActiveChange: function (isActive) {\n            if (!isActive) {\n                this.$selector.trigger('setVaultNotActive.' + this.getCode());\n\n                return;\n            }\n            this.chooseTokenSwitcher();\n            window.order.addExcludedPaymentMethod(this.getCode());\n        },\n\n        /**\n         * Get payment method code\n         * @returns {String}\n         */\n        getCode: function () {\n            return this.code;\n        }\n    });\n});\n","Magento_Weee/js/fpt-attribute.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global RegionUpdater */\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui',\n    'mage/adminhtml/form'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.fptAttribute', {\n        /** @inheritdoc */\n        _create: function () {\n            var widget = this;\n\n            this.rowTmpl = mageTemplate(this.element.find('[data-role=\"row-template\"]').html());\n\n            this._initOptionItem();\n\n            if ($(this.options.bundlePriceType).val() === '0') {\n                this.element.hide();\n            }\n\n            $.each(this.options.itemsData, function () {\n                widget.addItem(this);\n            });\n        },\n\n        /**\n         * @private\n         */\n        _initOptionItem: function () {\n            var widget = this,\n                isOriginalRequired = $(widget.element).hasClass('required');\n\n            this._on({\n                /**\n                 * Add new tax item.\n                 *\n                 * @param {jQuery.Event} event\n                 */\n                'click [data-action=add-fpt-item]': function (event) {\n                    this.addItem(event);\n                },\n\n                /**\n                 * Delete tax item.\n                 *\n                 * @param {jQuery.Event} event\n                 */\n                'click [data-action=delete-fpt-item]': function (event) {\n                    var parent = $(event.target).closest('[data-role=\"fpt-item-row\"]');\n\n                    parent.find('[data-role=\"delete-fpt-item\"]').val(1);\n                    parent.addClass('ignore-validate').hide();\n                },\n\n                /**\n                 * Change tax item country/state.\n                 *\n                 * @param {jQuery.Event} event\n                 * @param {Object} data\n                 */\n                'change [data-role=\"select-country\"]': function (event, data) {\n                    var currentElement = event.target || event.srcElement || event.currentTarget,\n                        parentElement = $(currentElement).closest('[data-role=\"fpt-item-row\"]'),\n                        updater;\n\n                    data = data || {};\n                    updater = new RegionUpdater(\n                        parentElement.find('[data-role=\"select-country\"]').attr('id'), null,\n                        parentElement.find('[data-role=\"select-state\"]').attr('id'),\n                        widget.options.region, 'disable', true\n                    );\n                    updater.update();\n                    //set selected state value if set\n                    if (data.state) {\n                        parentElement.find('[data-role=\"select-state\"]').val(data.state);\n                    }\n\n                    if (!isOriginalRequired && $(widget.element).hasClass('required')) {\n                        $(widget.element).removeClass('required');\n                    }\n                }\n            });\n\n            $(this.options.bundlePriceType).on('change', function (event) {\n                var attributeItems = widget.element.find('[data-role=\"delete-fpt-item\"]');\n\n                if ($(event.target).val() === '0') {\n                    widget.element.hide();\n                    attributeItems.each(function () {\n                        $(this).val(1);\n                    });\n                } else {\n                    widget.element.show();\n                    attributeItems.each(function () {\n                        if ($(this).closest('[data-role=\"fpt-item-row\"]').is(':visible')) {\n                            $(this).val(0);\n                        }\n                    });\n                }\n            });\n        },\n\n        /**\n         * Add custom option.\n         *\n         * @param {jQuery.Event} event\n         */\n        addItem: function (event) {\n            var data = {},\n                currentElement = event.target || event.srcElement || event.currentTarget,\n                tmpl;\n\n            if (typeof currentElement !== 'undefined') {\n                data['website_id'] = 0;\n            } else {\n                data = event;\n            }\n\n            data.index = this.element.find('[data-role=\"fpt-item-row\"]').length;\n\n            tmpl = this.rowTmpl({\n                data: data\n            });\n\n            $(tmpl).appendTo(this.element.find('[data-role=\"fpt-item-container\"]'));\n\n            //set selected website_id value if set\n            if (data['website_id']) {\n                this.element.find('[data-role=\"select-website\"][id$=\"_' + data.index + '_website\"]')\n                    .val(data['website_id']);\n            }\n\n            //set selected country value if set\n            if (data.country) {\n                this.element.find('[data-role=\"select-country\"][id$=\"_' + data.index + '_country\"]')\n                    .val(data.country).trigger('change', data);\n            }\n        }\n    });\n\n    return $.mage.fptAttribute;\n});\n","Magento_Weee/js/fpt-group.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/group',\n    'uiRegistry',\n    'Magento_Ui/js/lib/validation/validator',\n    'mage/translate',\n    'underscore'\n], function (Group, uiRegistry, validation, $t, _) {\n    'use strict';\n\n    return Group.extend({\n        defaults: {\n            visible: true,\n            label: '',\n            showLabel: true,\n            required: false,\n            template: 'ui/group/group',\n            fieldTemplate: 'ui/form/field',\n            breakLine: true,\n            validateWholeGroup: false,\n            additionalClasses: {}\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            validation.addRule('validate-fpt-group', function (value) {\n                if (value.indexOf('?') !== -1) {\n\n                    return false;\n                }\n\n                return true;\n            }, $t(\n                'Set unique country-state combinations within the same fixed product tax. ' +\n                'Verify the combinations and try again.'\n            ));\n\n            this._super();\n        },\n\n        /**\n         *\n         * @private\n         */\n        _handleOptionsAvailability: function () {\n            var parent,\n                dup;\n\n            dup = {};\n            parent = uiRegistry.get(uiRegistry.get(this.parentName).parentName);\n            _.each(parent.elems(), function (elem) {\n                var country,\n                    state,\n                    val,\n                    key;\n\n                country = uiRegistry.get(elem.name + '.countryState.country');\n                state = uiRegistry.get(elem.name + '.countryState.state');\n                val = uiRegistry.get(elem.name + '.countryState.val');\n\n                key = country.value() + (state.value() > 0 ? state.value() : 0);\n                dup[key]++;\n\n                if (!dup[key]) {\n                    dup[key] = 1;\n                    val.value('');\n                } else {\n                    dup[key]++;\n                    val.value(country.value() + '?' + country.name);\n                }\n            });\n        },\n\n        /** @inheritdoc */\n        initElement: function (elem) {\n            var obj;\n\n            obj = this;\n            this._super();\n            elem.on('value', function () {\n                obj._handleOptionsAvailability();\n            });\n\n            return this;\n        }\n    });\n});\n","Magento_Weee/js/regions-tax-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            filterBy: {\n                field: 'country',\n                target: '${ $.parentName }.country:value'\n            }\n        },\n\n        /** @inheritdoc */\n        filter: function () {\n            this._super();\n            this.disableSelect();\n        },\n\n        /**\n         * Disables select if there's no regions/states\n         *\n         * @returns {*} instance - Chainable\n         */\n        disableSelect: function () {\n            var empty = !this.options().length;\n\n            this.disabled(empty);\n\n            if (empty) {\n                this.error('');\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_Weee/js/price/adjustment.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Weee/price/adjustment',\n            dataSource: '${ $.parentName }.provider',\n            //Weee configuration constants can be configured from backend\n            inclFptWithDesc: 1,//show FPT and description\n            inclFpt: 0, //show FPT attribute\n            exclFpt: 2, //do not show FPT\n            bothFptPrices: 3 //show price without FPT and with FPT and with description\n        },\n\n        /**\n         * Get Weee attributes.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeAttributes: function (row) {\n            return row['price_info']['extension_attributes']['weee_attributes'];\n        },\n\n        /**\n         * Get Weee without Tax attributes.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithoutTax: function (taxAmount) {\n            return taxAmount['amount_excl_tax'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getWeeeTaxWithoutTax.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithoutTaxUnsanitizedHtml: function (taxAmount) {\n            return this.getWeeeTaxWithoutTax(taxAmount);\n        },\n\n        /**\n         * Get Weee with Tax attributes.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithTax: function (taxAmount) {\n            return taxAmount['tax_amount_incl_tax'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getWeeeTaxWithTax.\n         *\n         * @param {Object} taxAmount\n         * @return {HTMLElement} Weee html\n         */\n        getWeeeTaxWithTaxUnsanitizedHtml: function (taxAmount) {\n            return this.getWeeeTaxWithTax(taxAmount);\n        },\n\n        /**\n         * Get Weee Tax name.\n         *\n         * @param {String} taxAmount\n         * @return {String} Weee name\n         */\n        getWeeTaxAttributeName: function (taxAmount) {\n            return taxAmount['attribute_code'];\n        },\n\n        /**\n         * Set price type.\n         *\n         * @param {String} priceType\n         * @return {Object}\n         */\n        setPriceType: function (priceType) {\n            this.taxPriceType = priceType;\n\n            return this;\n        },\n\n        /**\n         * Check if Weee Tax must be shown.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        isShown: function (row) {\n            return row['price_info']['extension_attributes']['weee_attributes'].length;\n        },\n\n        /**\n         * Get Weee final price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} Weee final price html\n         */\n        getWeeeAdjustment: function (row) {\n            return row['price_info']['extension_attributes']['weee_adjustment'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getWeeeAdjustment.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} Weee final price html\n         */\n        getWeeeAdjustmentUnsanitizedHtml: function (row) {\n            return this.getWeeeAdjustment(row);\n        },\n\n        /**\n         * Return whether display setting is to display price including FPT only.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclFpt: function () {\n            return +this.source.data.displayWeee === this.inclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * price including FPT and FPT description.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclFptDescr: function () {\n            return +this.source.data.displayWeee === this.inclFptWithDesc;\n        },\n\n        /**\n         * Return whether display setting is to display price\n         * excluding FPT but including FPT description and final price.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclFptDescr: function () {\n            return +this.source.data.displayWeee === this.exclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding FPT.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclFpt: function () {\n            return +this.source.data.displayWeee === this.bothFptPrices;\n        },\n\n        /**\n         * Return whether display setting is to display price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceExclTax: function () {\n            return +this.source.data.displayTaxes === this.inclFptWithDesc;\n        },\n\n        /**\n         * Return whether display setting is to display price including tax.\n         *\n         * @return {Boolean}\n         */\n        displayPriceInclTax: function () {\n            return +this.source.data.displayTaxes === this.exclFpt;\n        },\n\n        /**\n         * Return whether display setting is to display\n         * both price including tax and price excluding tax.\n         *\n         * @return {Boolean}\n         */\n        displayBothPricesTax: function () {\n            return +this.source.data.displayTaxes === this.bothFptPrices;\n        }\n    });\n});\n","Mageplaza_BannerSlider/js/grid/preview.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license that is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_BannerSlider\r\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\n\r\ndefine([\r\n    'Magento_Ui/js/grid/columns/thumbnail',\r\n    'jquery',\r\n    'mage/template',\r\n    'text!Mageplaza_BannerSlider/template/grid/cells/preview.html',\r\n    'Magento_Ui/js/modal/modal',\r\n    'mage/translate'\r\n], function (Thumbnail, $, mageTemplate, previewTemplate) {\r\n    'use strict';\r\n\r\n    return Thumbnail.extend({\r\n        defaults: {\r\n            bodyTmpl: 'Mageplaza_BannerSlider/grid/cells/html',\r\n            fieldClass: {\r\n                'data-grid-thumbnail-cell': true\r\n            }\r\n        },\r\n\r\n        /**\r\n         * Get content data per row\r\n         * @param {Object} row\r\n         * @returns {String}\r\n         */\r\n        getContent: function (row) {\r\n            return row[this.index];\r\n        },\r\n\r\n        /**\r\n         * Check banner type per row\r\n         *\r\n         * @param {Object} row\r\n         * @returns {boolean}\r\n         */\r\n        getType: function (row) {\r\n            return row[this.index + '_type'] === '1';\r\n        },\r\n\r\n        /**\r\n         * Build preview.\r\n         *\r\n         * @param {Object} row\r\n         */\r\n        preview: function (row) {\r\n            var modalHtml = mageTemplate(\r\n                previewTemplate,\r\n                {\r\n                    src: this.getSrc(row), alt: this.getAlt(row), link: this.getLink(row), type: this.getType(row),\r\n                    linkText: $.mage.__('Go to Details Page')\r\n                }\r\n                ),\r\n                previewPopup = $('<div/>').html(modalHtml);\r\n\r\n            previewPopup.modal({\r\n                innerScroll: true,\r\n                modalClass: '_image-box',\r\n                buttons: []\r\n            }).trigger('openModal');\r\n\r\n            if (this.getType(row)) {\r\n                $('.content-preview-block').html($.parseHTML(this.getContent(row)));\r\n            }\r\n        }\r\n    });\r\n});\r\n","Mageplaza_BannerSlider/js/view/bannerslider.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license that is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_BannerSlider\r\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\n\r\ndefine([\r\n    'jquery'\r\n], function ($) {\r\n    \"use strict\";\r\n\r\n    $.widget('mageplaza.bannerslider', {\r\n        /**\r\n         * This method constructs a new widget.\r\n         * @private\r\n         */\r\n        _create: function () {\r\n            this.templates = JSON.parse(this.options.templateHtml);\r\n            this.imgUrls = JSON.parse(this.options.imgUrls);\r\n            this.tplDropdown = $('#banner_default_template');\r\n            this.initObserve();\r\n        },\r\n        initObserve: function () {\r\n            this.loadTemplate();\r\n            this.changeImageUrl();\r\n        },\r\n        loadTemplate: function () {\r\n            var self = this;\r\n            var toggleMCEEditor = $('#togglebanner_content');\r\n            var bannerContent = $('#banner_content');\r\n            var btnLoadContent = $('#banner_load_template');\r\n            btnLoadContent.on('click', function () {\r\n                var tplId = self.tplDropdown.val();\r\n                var tpl = self.templates[tplId][\"tpl\"];\r\n                var replaceBy = self.templates[tplId][\"var\"];\r\n                var regEx = new RegExp(replaceBy, 'g');\r\n                var html = tpl.replace(regEx, tplId);\r\n\r\n                if (bannerContent.css('display') === 'none') {\r\n                    toggleMCEEditor.trigger('click');\r\n                }\r\n                bannerContent.val(html);\r\n            });\r\n        },\r\n        changeImageUrl: function () {\r\n            var imageUrls = this.imgUrls;\r\n            var demoImg = $('#mp-demo-image');\r\n            this.tplDropdown.on('change', function () {\r\n                demoImg.attr('src', imageUrls[$(this).val()]);\r\n            })\r\n        }\r\n    });\r\n\r\n    return $.mageplaza.bannerslider;\r\n});\r\n","Mageplaza_Blog/category/edit.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license that is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_Blog\r\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\n\r\ndefine([\r\n    'jquery',\r\n    'prototype'\r\n], function (jQuery) {\r\n\r\n    var categorySubmit = function (url, useAjax) {\r\n        var activeTab = $('active_tab_id');\r\n        if (activeTab) {\r\n            if (activeTab.tabsJsObject && activeTab.tabsJsObject.tabs('activeAnchor')) {\r\n                activeTab.value = activeTab.tabsJsObject.tabs('activeAnchor').prop('id');\r\n            }\r\n        }\r\n\r\n        var params = {};\r\n        var fields = $('category_edit_form').getElementsBySelector('input', 'select');\r\n        for (var i = 0; i < fields.length; i++) {\r\n            if (!fields[i].name) {\r\n                continue;\r\n            }\r\n            params[fields[i].name] = fields[i].getValue();\r\n        }\r\n\r\n        // Get info about what we're submitting - to properly update tree nodes\r\n        var categoryId = params['category[id]'] ? params['category[id]'] : 0;\r\n        var isCreating = categoryId == 0; // Separate variable is needed because '0' in javascript converts to TRUE\r\n        var path = params['category[path]'].split('/');\r\n        var parentId = path.pop();\r\n        if (parentId == categoryId) { // Maybe path includes Blog Category id itself\r\n            parentId = path.pop();\r\n        }\r\n\r\n        // Make operations with Blog Category tree\r\n        if (isCreating) {\r\n            if (!tree.currentNodeId) {\r\n                // First submit of form - select some node to be current\r\n                tree.currentNodeId = parentId;\r\n            }\r\n            tree.addNodeTo = parentId;\r\n        }\r\n\r\n        // Submit form\r\n        jQuery('#category_edit_form').trigger('submit');\r\n    };\r\n\r\n    return function (config, element) {\r\n        config = config || {};\r\n        jQuery(element).on('click', function (event) {\r\n            categorySubmit(config.url, config.ajax);\r\n        });\r\n    };\r\n});\r\n","Mageplaza_Blog/category/form.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license that is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_Blog\r\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\n\r\n/*jshint jquery:true browser:true*/\r\n/*global Ajax:true alert:true*/\r\ndefine([\r\n    \"jquery\",\r\n    \"mage/backend/form\",\r\n    \"jquery/ui\",\r\n    \"prototype\"\r\n], function ($) {\r\n    \"use strict\";\r\n\r\n    $.widget(\"mage.categoryForm\", $.mage.form, {\r\n        options: {\r\n            categoryIdSelector: 'input[name=\"category[category_id]\"]',\r\n            categoryPathSelector: 'input[name=\"category[path]\"]'\r\n        },\r\n\r\n        /**\r\n         * Form creation\r\n         * @protected\r\n         */\r\n        _create: function () {\r\n            this._super();\r\n            $('body').on('categoryMove.tree', $.proxy(this.refreshPath, this));\r\n        },\r\n\r\n        /**\r\n         * Sending ajax to server to refresh field 'category[path]'\r\n         * @protected\r\n         */\r\n        refreshPath: function () {\r\n            var that = this;\r\n            if (!this.element.find(this.options.categoryIdSelector).prop('value')) {\r\n                return false;\r\n            }\r\n            $.ajax({\r\n                type: 'POST',\r\n                url: this.options.refreshUrl,\r\n                dataType: 'json',\r\n                data: {\r\n                    form_key: FORM_KEY\r\n                }\r\n            }).success(function (data) {\r\n                that._refreshPathSuccess(data);\r\n            });\r\n        },\r\n        _refreshPathSuccess: function (response) {\r\n            if (response.error) {\r\n                alert(response.message);\r\n            } else {\r\n                if (this.element.find(this.options.categoryIdSelector).prop('value') == response.id) {\r\n                    this.element.find(this.options.categoryPathSelector)\r\n                        .prop('value', response.path);\r\n                }\r\n            }\r\n        }\r\n    });\r\n\r\n    return $.mage.categoryForm;\r\n});\r\n","Mageplaza_Blog/js/components/new-category.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license that is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_Blog\r\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\n\r\ndefine([\r\n    'underscore',\r\n    'Magento_Catalog/js/components/new-category'\r\n], function (_, Category) {\r\n    'use strict';\r\n\r\n    /**\r\n     * Processing options list\r\n     *\r\n     * @param {Array} array - Property array\r\n     * @param {String} separator - Level separator\r\n     * @param {Array} created - list to add new options\r\n     *\r\n     * @return {Array} Plain options list\r\n     */\r\n    function flattenCollection(array, separator, created) {\r\n        var i = 0,\r\n            length,\r\n            childCollection;\r\n\r\n        array = _.compact(array);\r\n        length = array.length;\r\n        created = created || [];\r\n\r\n        for (i; i < length; i++) {\r\n            created.push(array[i]);\r\n\r\n            if (array[i].hasOwnProperty(separator)) {\r\n                childCollection = array[i][separator];\r\n                delete array[i][separator];\r\n                flattenCollection.call(this, childCollection, separator, created);\r\n            }\r\n        }\r\n\r\n        return created;\r\n    }\r\n\r\n    return Category.extend({\r\n        /**\r\n         * Get path to current option\r\n         *\r\n         * @param {Object} data - option data\r\n         * @returns {String} path\r\n         */\r\n        getPath: function (data) {\r\n            var pathParts,\r\n                createdPath = '';\r\n\r\n            if (this.renderPath && typeof data.path !== \"undefined\") {\r\n                pathParts = data.path.split('.');\r\n                _.each(pathParts, function (curData) {\r\n                    createdPath = createdPath ? createdPath + ' / ' + curData : curData;\r\n                });\r\n\r\n                return createdPath;\r\n            }\r\n        },\r\n\r\n        /**\r\n         * Set option to options array.\r\n         *\r\n         * @param {Object} option\r\n         * @param {Array} options\r\n         */\r\n        setOption: function (option, options) {\r\n            // eslint-disable-next-line radix\r\n            var parent = parseInt(option.parent),\r\n                copyOptionsTree;\r\n\r\n            if (_.contains([0, 1], parent)) {\r\n                options = options || this.cacheOptions.tree;\r\n                options.push(option);\r\n\r\n                copyOptionsTree = JSON.parse(JSON.stringify(this.cacheOptions.tree));\r\n                this.cacheOptions.plain = flattenCollection(copyOptionsTree, this.separator);\r\n                this.options(this.cacheOptions.tree);\r\n            } else {\r\n                this._super(option, options);\r\n            }\r\n        }\r\n    });\r\n});\r\n","Mageplaza_Blog/js/grid/columns/enable.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license sliderConfig is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_Blog\r\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\n\r\ndefine([\r\n    'Magento_Ui/js/grid/columns/select'\r\n], function (Column) {\r\n    'use strict';\r\n\r\n    return Column.extend({\r\n        defaults: {\r\n            bodyTmpl: 'ui/grid/cells/html'\r\n        },\r\n        getLabel: function (record) {\r\n            var label = this._super(record);\r\n\r\n            if (label !== '') {\r\n                switch (record.enabled) {\r\n                    case '1':\r\n                        label = '<span class=\"grid-severity-notice\"><span>' + label + '</span></span>';\r\n                        break;\r\n                    case '0':\r\n                        label = '<span class=\"grid-severity-critical\"><span>' + label + '</span></span>';\r\n                        break;\r\n                    case '2':\r\n                        label = '<span class=\"grid-severity-critical\"><span>' + label + '</span></span>';\r\n                        break;\r\n                }\r\n            }\r\n            return label;\r\n        }\r\n    });\r\n});","Mageplaza_Blog/js/grid/columns/select.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license sliderConfig is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_Blog\r\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\n\r\ndefine([\r\n    'Magento_Ui/js/grid/columns/select'\r\n], function (Column) {\r\n    'use strict';\r\n\r\n    return Column.extend({\r\n        defaults: {\r\n            bodyTmpl: 'ui/grid/cells/html'\r\n        },\r\n        getLabel: function (record) {\r\n            var label = this._super(record);\r\n\r\n            if (label !== '') {\r\n                switch (record.status) {\r\n                    case '1':\r\n                        label = '<span class=\"grid-severity-notice\"><span>' + label + '</span></span>';\r\n                        break;\r\n                    case '2':\r\n                        label = '<span class=\"grid-severity-critical\"><span>' + label + '</span></span>';\r\n                        break;\r\n                    case '3':\r\n                        label = '<span class=\"grid-severity-minor\"><span>' + label + '</span></span>';\r\n                        break;\r\n                }\r\n            }\r\n            return label;\r\n        }\r\n    });\r\n});","Mageplaza_Blog/js/view/author.js":"/**\r\n * Mageplaza\r\n *\r\n * NOTICE OF LICENSE\r\n *\r\n * This source file is subject to the Mageplaza.com license that is\r\n * available through the world-wide-web at this URL:\r\n * https://www.mageplaza.com/LICENSE.txt\r\n *\r\n * DISCLAIMER\r\n *\r\n * Do not edit or add to this file if you wish to upgrade this extension to newer\r\n * version in the future.\r\n *\r\n * @category    Mageplaza\r\n * @package     Mageplaza_Blog\r\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\r\n * @license     https://www.mageplaza.com/LICENSE.txt\r\n */\r\n\r\ndefine([\r\n    'jquery',\r\n    'Magento_Ui/js/modal/modal',\r\n    'mage/translate'\r\n], function ($, modal, $t) {\r\n    \"use strict\";\r\n\r\n    $.widget('mageplaza.mpBlogAuthor', {\r\n        options: {\r\n            url: ''\r\n        },\r\n        isloaded: false,\r\n\r\n        /**\r\n         * This method constructs a new widget.\r\n         * @private\r\n         */\r\n        _create: function () {\r\n            this.initCustomerGrid();\r\n            this.selectCustomer();\r\n        },\r\n\r\n        /**\r\n         * Init popup\r\n         * Popup will automatic open\r\n         */\r\n        initPopup: function () {\r\n            var options = {\r\n                type: 'popup',\r\n                responsive: true,\r\n                innerScroll: true,\r\n                title: $t('Select Customer'),\r\n                buttons: []\r\n            },\r\n            customerGridEl = $('#customer-grid');\r\n\r\n            modal(options, customerGridEl);\r\n            customerGridEl.modal('openModal');\r\n        },\r\n\r\n        /**\r\n         * Init select customer\r\n         */\r\n        selectCustomer: function () {\r\n            $('body').delegate('#customer-grid_table tbody tr', 'click', function () {\r\n                var first_name = $(this).find('td:nth-child(3)').text().trim(),\r\n                    last_name = $(this).find('td:nth-child(4)').text().trim();\r\n\r\n                $(\"#author_customer_id\").val($(this).find('input').val().trim());\r\n                $(\"#author_customer\").val(first_name+' '+last_name);\r\n                $('#customer-grid').data('mageModal').closeModal();\r\n            });\r\n        },\r\n\r\n        /**\r\n         * Init customer grid\r\n         */\r\n        initCustomerGrid: function () {\r\n            var self = this;\r\n\r\n            $(\"#author_customer\").click(function () {\r\n                $.ajax({\r\n                    method: 'POST',\r\n                    url: self.options.url,\r\n                    data: {form_key: window.FORM_KEY},\r\n                    showLoader: true\r\n                }).done(function (response) {\r\n                    $('#customer-grid').html(response);\r\n                    self.initPopup();\r\n                });\r\n            });\r\n        }\r\n    });\r\n\r\n    return $.mageplaza.mpBlogAuthor;\r\n});\r\n\r\n","Mageplaza_Core/js/bootstrap.min.js":"/*!\r\n * Bootstrap v3.3.6 (http://getbootstrap.com)\r\n * Copyright 2011-2015 Twitter, Inc.\r\n * Licensed under the MIT license\r\n */\r\nif(\"undefined\"==typeof jQuery)throw new Error(\"Bootstrap's JavaScript requires jQuery\");+function(a){\"use strict\";var b=a.fn.jquery.split(\" \")[0].split(\".\");if(b[0]<2&&b[1]<9||1==b[0]&&9==b[1]&&b[2]<1||b[0]>2)throw new Error(\"Bootstrap's JavaScript requires jQuery version 1.9.1 or higher, but lower than version 3\")}(jQuery),+function(a){\"use strict\";function b(){var a=document.createElement(\"bootstrap\"),b={WebkitTransition:\"webkitTransitionEnd\",MozTransition:\"transitionend\",OTransition:\"oTransitionEnd otransitionend\",transition:\"transitionend\"};for(var c in b)if(void 0!==a.style[c])return{end:b[c]};return!1}a.fn.emulateTransitionEnd=function(b){var c=!1,d=this;a(this).one(\"bsTransitionEnd\",function(){c=!0});var e=function(){c||a(d).trigger(a.support.transition.end)};return setTimeout(e,b),this},a(function(){a.support.transition=b(),a.support.transition&&(a.event.special.bsTransitionEnd={bindType:a.support.transition.end,delegateType:a.support.transition.end,handle:function(b){return a(b.target).is(this)?b.handleObj.handler.apply(this,arguments):void 0}})})}(jQuery),+function(a){\"use strict\";function b(b){return this.each(function(){var c=a(this),e=c.data(\"bs.alert\");e||c.data(\"bs.alert\",e=new d(this)),\"string\"==typeof b&&e[b].call(c)})}var c='[data-dismiss=\"alert\"]',d=function(b){a(b).on(\"click\",c,this.close)};d.VERSION=\"3.3.6\",d.TRANSITION_DURATION=150,d.prototype.close=function(b){function c(){g.detach().trigger(\"closed.bs.alert\").remove()}var e=a(this),f=e.attr(\"data-target\");f||(f=e.attr(\"href\"),f=f&&f.replace(/.*(?=#[^\\s]*$)/,\"\"));var g=a(f);b&&b.preventDefault(),g.length||(g=e.closest(\".alert\")),g.trigger(b=a.Event(\"close.bs.alert\")),b.isDefaultPrevented()||(g.removeClass(\"in\"),a.support.transition&&g.hasClass(\"fade\")?g.one(\"bsTransitionEnd\",c).emulateTransitionEnd(d.TRANSITION_DURATION):c())};var e=a.fn.alert;a.fn.alert=b,a.fn.alert.Constructor=d,a.fn.alert.noConflict=function(){return a.fn.alert=e,this},a(document).on(\"click.bs.alert.data-api\",c,d.prototype.close)}(jQuery),+function(a){\"use strict\";function b(b){return this.each(function(){var d=a(this),e=d.data(\"bs.button\"),f=\"object\"==typeof b&&b;e||d.data(\"bs.button\",e=new c(this,f)),\"toggle\"==b?e.toggle():b&&e.setState(b)})}var c=function(b,d){this.$element=a(b),this.options=a.extend({},c.DEFAULTS,d),this.isLoading=!1};c.VERSION=\"3.3.6\",c.DEFAULTS={loadingText:\"loading...\"},c.prototype.setState=function(b){var c=\"disabled\",d=this.$element,e=d.is(\"input\")?\"val\":\"html\",f=d.data();b+=\"Text\",null==f.resetText&&d.data(\"resetText\",d[e]()),setTimeout(a.proxy(function(){d[e](null==f[b]?this.options[b]:f[b]),\"loadingText\"==b?(this.isLoading=!0,d.addClass(c).attr(c,c)):this.isLoading&&(this.isLoading=!1,d.removeClass(c).removeAttr(c))},this),0)},c.prototype.toggle=function(){var a=!0,b=this.$element.closest('[data-toggle=\"buttons\"]');if(b.length){var c=this.$element.find(\"input\");\"radio\"==c.prop(\"type\")?(c.prop(\"checked\")&&(a=!1),b.find(\".active\").removeClass(\"active\"),this.$element.addClass(\"active\")):\"checkbox\"==c.prop(\"type\")&&(c.prop(\"checked\")!==this.$element.hasClass(\"active\")&&(a=!1),this.$element.toggleClass(\"active\")),c.prop(\"checked\",this.$element.hasClass(\"active\")),a&&c.trigger(\"change\")}else this.$element.attr(\"aria-pressed\",!this.$element.hasClass(\"active\")),this.$element.toggleClass(\"active\")};var d=a.fn.button;a.fn.button=b,a.fn.button.Constructor=c,a.fn.button.noConflict=function(){return a.fn.button=d,this},a(document).on(\"click.bs.button.data-api\",'[data-toggle^=\"button\"]',function(c){var d=a(c.target);d.hasClass(\"btn\")||(d=d.closest(\".btn\")),b.call(d,\"toggle\"),a(c.target).is('input[type=\"radio\"]')||a(c.target).is('input[type=\"checkbox\"]')||c.preventDefault()}).on(\"focus.bs.button.data-api blur.bs.button.data-api\",'[data-toggle^=\"button\"]',function(b){a(b.target).closest(\".btn\").toggleClass(\"focus\",/^focus(in)?$/.test(b.type))})}(jQuery),+function(a){\"use strict\";function b(b){return this.each(function(){var d=a(this),e=d.data(\"bs.carousel\"),f=a.extend({},c.DEFAULTS,d.data(),\"object\"==typeof b&&b),g=\"string\"==typeof b?b:f.slide;e||d.data(\"bs.carousel\",e=new c(this,f)),\"number\"==typeof b?e.to(b):g?e[g]():f.interval&&e.pause().cycle()})}var c=function(b,c){this.$element=a(b),this.$indicators=this.$element.find(\".carousel-indicators\"),this.options=c,this.paused=null,this.sliding=null,this.interval=null,this.$active=null,this.$items=null,this.options.keyboard&&this.$element.on(\"keydown.bs.carousel\",a.proxy(this.keydown,this)),\"hover\"==this.options.pause&&!(\"ontouchstart\"in document.documentElement)&&this.$element.on(\"mouseenter.bs.carousel\",a.proxy(this.pause,this)).on(\"mouseleave.bs.carousel\",a.proxy(this.cycle,this))};c.VERSION=\"3.3.6\",c.TRANSITION_DURATION=600,c.DEFAULTS={interval:5e3,pause:\"hover\",wrap:!0,keyboard:!0},c.prototype.keydown=function(a){if(!/input|textarea/i.test(a.target.tagName)){switch(a.which){case 37:this.prev();break;case 39:this.next();break;default:return}a.preventDefault()}},c.prototype.cycle=function(b){return b||(this.paused=!1),this.interval&&clearInterval(this.interval),this.options.interval&&!this.paused&&(this.interval=setInterval(a.proxy(this.next,this),this.options.interval)),this},c.prototype.getItemIndex=function(a){return this.$items=a.parent().children(\".item\"),this.$items.index(a||this.$active)},c.prototype.getItemForDirection=function(a,b){var c=this.getItemIndex(b),d=\"prev\"==a&&0===c||\"next\"==a&&c==this.$items.length-1;if(d&&!this.options.wrap)return b;var e=\"prev\"==a?-1:1,f=(c+e)%this.$items.length;return this.$items.eq(f)},c.prototype.to=function(a){var b=this,c=this.getItemIndex(this.$active=this.$element.find(\".item.active\"));return a>this.$items.length-1||0>a?void 0:this.sliding?this.$element.one(\"slid.bs.carousel\",function(){b.to(a)}):c==a?this.pause().cycle():this.slide(a>c?\"next\":\"prev\",this.$items.eq(a))},c.prototype.pause=function(b){return b||(this.paused=!0),this.$element.find(\".next, .prev\").length&&a.support.transition&&(this.$element.trigger(a.support.transition.end),this.cycle(!0)),this.interval=clearInterval(this.interval),this},c.prototype.next=function(){return this.sliding?void 0:this.slide(\"next\")},c.prototype.prev=function(){return this.sliding?void 0:this.slide(\"prev\")},c.prototype.slide=function(b,d){var e=this.$element.find(\".item.active\"),f=d||this.getItemForDirection(b,e),g=this.interval,h=\"next\"==b?\"left\":\"right\",i=this;if(f.hasClass(\"active\"))return this.sliding=!1;var j=f[0],k=a.Event(\"slide.bs.carousel\",{relatedTarget:j,direction:h});if(this.$element.trigger(k),!k.isDefaultPrevented()){if(this.sliding=!0,g&&this.pause(),this.$indicators.length){this.$indicators.find(\".active\").removeClass(\"active\");var l=a(this.$indicators.children()[this.getItemIndex(f)]);l&&l.addClass(\"active\")}var m=a.Event(\"slid.bs.carousel\",{relatedTarget:j,direction:h});return a.support.transition&&this.$element.hasClass(\"slide\")?(f.addClass(b),f[0].offsetWidth,e.addClass(h),f.addClass(h),e.one(\"bsTransitionEnd\",function(){f.removeClass([b,h].join(\" \")).addClass(\"active\"),e.removeClass([\"active\",h].join(\" \")),i.sliding=!1,setTimeout(function(){i.$element.trigger(m)},0)}).emulateTransitionEnd(c.TRANSITION_DURATION)):(e.removeClass(\"active\"),f.addClass(\"active\"),this.sliding=!1,this.$element.trigger(m)),g&&this.cycle(),this}};var d=a.fn.carousel;a.fn.carousel=b,a.fn.carousel.Constructor=c,a.fn.carousel.noConflict=function(){return a.fn.carousel=d,this};var e=function(c){var d,e=a(this),f=a(e.attr(\"data-target\")||(d=e.attr(\"href\"))&&d.replace(/.*(?=#[^\\s]+$)/,\"\"));if(f.hasClass(\"carousel\")){var g=a.extend({},f.data(),e.data()),h=e.attr(\"data-slide-to\");h&&(g.interval=!1),b.call(f,g),h&&f.data(\"bs.carousel\").to(h),c.preventDefault()}};a(document).on(\"click.bs.carousel.data-api\",\"[data-slide]\",e).on(\"click.bs.carousel.data-api\",\"[data-slide-to]\",e),a(window).on(\"load\",function(){a('[data-ride=\"carousel\"]').each(function(){var c=a(this);b.call(c,c.data())})})}(jQuery),+function(a){\"use strict\";function b(b){var c,d=b.attr(\"data-target\")||(c=b.attr(\"href\"))&&c.replace(/.*(?=#[^\\s]+$)/,\"\");return a(d)}function c(b){return this.each(function(){var c=a(this),e=c.data(\"bs.collapse\"),f=a.extend({},d.DEFAULTS,c.data(),\"object\"==typeof b&&b);!e&&f.toggle&&/show|hide/.test(b)&&(f.toggle=!1),e||c.data(\"bs.collapse\",e=new d(this,f)),\"string\"==typeof b&&e[b]()})}var d=function(b,c){this.$element=a(b),this.options=a.extend({},d.DEFAULTS,c),this.$trigger=a('[data-toggle=\"collapse\"][href=\"#'+b.id+'\"],[data-toggle=\"collapse\"][data-target=\"#'+b.id+'\"]'),this.transitioning=null,this.options.parent?this.$parent=this.getParent():this.addAriaAndCollapsedClass(this.$element,this.$trigger),this.options.toggle&&this.toggle()};d.VERSION=\"3.3.6\",d.TRANSITION_DURATION=350,d.DEFAULTS={toggle:!0},d.prototype.dimension=function(){var a=this.$element.hasClass(\"width\");return a?\"width\":\"height\"},d.prototype.show=function(){if(!this.transitioning&&!this.$element.hasClass(\"in\")){var b,e=this.$parent&&this.$parent.children(\".panel\").children(\".in, .collapsing\");if(!(e&&e.length&&(b=e.data(\"bs.collapse\"),b&&b.transitioning))){var f=a.Event(\"show.bs.collapse\");if(this.$element.trigger(f),!f.isDefaultPrevented()){e&&e.length&&(c.call(e,\"hide\"),b||e.data(\"bs.collapse\",null));var g=this.dimension();this.$element.removeClass(\"collapse\").addClass(\"collapsing\")[g](0).attr(\"aria-expanded\",!0),this.$trigger.removeClass(\"collapsed\").attr(\"aria-expanded\",!0),this.transitioning=1;var h=function(){this.$element.removeClass(\"collapsing\").addClass(\"collapse in\")[g](\"\"),this.transitioning=0,this.$element.trigger(\"shown.bs.collapse\")};if(!a.support.transition)return h.call(this);var i=a.camelCase([\"scroll\",g].join(\"-\"));this.$element.one(\"bsTransitionEnd\",a.proxy(h,this)).emulateTransitionEnd(d.TRANSITION_DURATION)[g](this.$element[0][i])}}}},d.prototype.hide=function(){if(!this.transitioning&&this.$element.hasClass(\"in\")){var b=a.Event(\"hide.bs.collapse\");if(this.$element.trigger(b),!b.isDefaultPrevented()){var c=this.dimension();this.$element[c](this.$element[c]())[0].offsetHeight,this.$element.addClass(\"collapsing\").removeClass(\"collapse in\").attr(\"aria-expanded\",!1),this.$trigger.addClass(\"collapsed\").attr(\"aria-expanded\",!1),this.transitioning=1;var e=function(){this.transitioning=0,this.$element.removeClass(\"collapsing\").addClass(\"collapse\").trigger(\"hidden.bs.collapse\")};return a.support.transition?void this.$element[c](0).one(\"bsTransitionEnd\",a.proxy(e,this)).emulateTransitionEnd(d.TRANSITION_DURATION):e.call(this)}}},d.prototype.toggle=function(){this[this.$element.hasClass(\"in\")?\"hide\":\"show\"]()},d.prototype.getParent=function(){return a(this.options.parent).find('[data-toggle=\"collapse\"][data-parent=\"'+this.options.parent+'\"]').each(a.proxy(function(c,d){var e=a(d);this.addAriaAndCollapsedClass(b(e),e)},this)).end()},d.prototype.addAriaAndCollapsedClass=function(a,b){var c=a.hasClass(\"in\");a.attr(\"aria-expanded\",c),b.toggleClass(\"collapsed\",!c).attr(\"aria-expanded\",c)};var e=a.fn.collapse;a.fn.collapse=c,a.fn.collapse.Constructor=d,a.fn.collapse.noConflict=function(){return a.fn.collapse=e,this},a(document).on(\"click.bs.collapse.data-api\",'[data-toggle=\"collapse\"]',function(d){var e=a(this);e.attr(\"data-target\")||d.preventDefault();var f=b(e),g=f.data(\"bs.collapse\"),h=g?\"toggle\":e.data();c.call(f,h)})}(jQuery),+function(a){\"use strict\";function b(b){var c=b.attr(\"data-target\");c||(c=b.attr(\"href\"),c=c&&/#[A-Za-z]/.test(c)&&c.replace(/.*(?=#[^\\s]*$)/,\"\"));var d=c&&a(c);return d&&d.length?d:b.parent()}function c(c){c&&3===c.which||(a(e).remove(),a(f).each(function(){var d=a(this),e=b(d),f={relatedTarget:this};e.hasClass(\"open\")&&(c&&\"click\"==c.type&&/input|textarea/i.test(c.target.tagName)&&a.contains(e[0],c.target)||(e.trigger(c=a.Event(\"hide.bs.dropdown\",f)),c.isDefaultPrevented()||(d.attr(\"aria-expanded\",\"false\"),e.removeClass(\"open\").trigger(a.Event(\"hidden.bs.dropdown\",f)))))}))}function d(b){return this.each(function(){var c=a(this),d=c.data(\"bs.dropdown\");d||c.data(\"bs.dropdown\",d=new g(this)),\"string\"==typeof b&&d[b].call(c)})}var e=\".dropdown-backdrop\",f='[data-toggle=\"dropdown\"]',g=function(b){a(b).on(\"click.bs.dropdown\",this.toggle)};g.VERSION=\"3.3.6\",g.prototype.toggle=function(d){var e=a(this);if(!e.is(\".disabled, :disabled\")){var f=b(e),g=f.hasClass(\"open\");if(c(),!g){\"ontouchstart\"in document.documentElement&&!f.closest(\".navbar-nav\").length&&a(document.createElement(\"div\")).addClass(\"dropdown-backdrop\").insertAfter(a(this)).on(\"click\",c);var h={relatedTarget:this};if(f.trigger(d=a.Event(\"show.bs.dropdown\",h)),d.isDefaultPrevented())return;e.trigger(\"focus\").attr(\"aria-expanded\",\"true\"),f.toggleClass(\"open\").trigger(a.Event(\"shown.bs.dropdown\",h))}return!1}},g.prototype.keydown=function(c){if(/(38|40|27|32)/.test(c.which)&&!/input|textarea/i.test(c.target.tagName)){var d=a(this);if(c.preventDefault(),c.stopPropagation(),!d.is(\".disabled, :disabled\")){var e=b(d),g=e.hasClass(\"open\");if(!g&&27!=c.which||g&&27==c.which)return 27==c.which&&e.find(f).trigger(\"focus\"),d.trigger(\"click\");var h=\" li:not(.disabled):visible a\",i=e.find(\".dropdown-menu\"+h);if(i.length){var j=i.index(c.target);38==c.which&&j>0&&j--,40==c.which&&j<i.length-1&&j++,~j||(j=0),i.eq(j).trigger(\"focus\")}}}};var h=a.fn.dropdown;a.fn.dropdown=d,a.fn.dropdown.Constructor=g,a.fn.dropdown.noConflict=function(){return a.fn.dropdown=h,this},a(document).on(\"click.bs.dropdown.data-api\",c).on(\"click.bs.dropdown.data-api\",\".dropdown form\",function(a){a.stopPropagation()}).on(\"click.bs.dropdown.data-api\",f,g.prototype.toggle).on(\"keydown.bs.dropdown.data-api\",f,g.prototype.keydown).on(\"keydown.bs.dropdown.data-api\",\".dropdown-menu\",g.prototype.keydown)}(jQuery),+function(a){\"use strict\";function b(b,d){return this.each(function(){var e=a(this),f=e.data(\"bs.modal\"),g=a.extend({},c.DEFAULTS,e.data(),\"object\"==typeof b&&b);f||e.data(\"bs.modal\",f=new c(this,g)),\"string\"==typeof b?f[b](d):g.show&&f.show(d)})}var c=function(b,c){this.options=c,this.$body=a(document.body),this.$element=a(b),this.$dialog=this.$element.find(\".modal-dialog\"),this.$backdrop=null,this.isShown=null,this.originalBodyPad=null,this.scrollbarWidth=0,this.ignoreBackdropClick=!1,this.options.remote&&this.$element.find(\".modal-content\").load(this.options.remote,a.proxy(function(){this.$element.trigger(\"loaded.bs.modal\")},this))};c.VERSION=\"3.3.6\",c.TRANSITION_DURATION=300,c.BACKDROP_TRANSITION_DURATION=150,c.DEFAULTS={backdrop:!0,keyboard:!0,show:!0},c.prototype.toggle=function(a){return this.isShown?this.hide():this.show(a)},c.prototype.show=function(b){var d=this,e=a.Event(\"show.bs.modal\",{relatedTarget:b});this.$element.trigger(e),this.isShown||e.isDefaultPrevented()||(this.isShown=!0,this.checkScrollbar(),this.setScrollbar(),this.$body.addClass(\"modal-open\"),this.escape(),this.resize(),this.$element.on(\"click.dismiss.bs.modal\",'[data-dismiss=\"modal\"]',a.proxy(this.hide,this)),this.$dialog.on(\"mousedown.dismiss.bs.modal\",function(){d.$element.one(\"mouseup.dismiss.bs.modal\",function(b){a(b.target).is(d.$element)&&(d.ignoreBackdropClick=!0)})}),this.backdrop(function(){var e=a.support.transition&&d.$element.hasClass(\"fade\");d.$element.parent().length||d.$element.appendTo(d.$body),d.$element.show().scrollTop(0),d.adjustDialog(),e&&d.$element[0].offsetWidth,d.$element.addClass(\"in\"),d.enforceFocus();var f=a.Event(\"shown.bs.modal\",{relatedTarget:b});e?d.$dialog.one(\"bsTransitionEnd\",function(){d.$element.trigger(\"focus\").trigger(f)}).emulateTransitionEnd(c.TRANSITION_DURATION):d.$element.trigger(\"focus\").trigger(f)}))},c.prototype.hide=function(b){b&&b.preventDefault(),b=a.Event(\"hide.bs.modal\"),this.$element.trigger(b),this.isShown&&!b.isDefaultPrevented()&&(this.isShown=!1,this.escape(),this.resize(),a(document).off(\"focusin.bs.modal\"),this.$element.removeClass(\"in\").off(\"click.dismiss.bs.modal\").off(\"mouseup.dismiss.bs.modal\"),this.$dialog.off(\"mousedown.dismiss.bs.modal\"),a.support.transition&&this.$element.hasClass(\"fade\")?this.$element.one(\"bsTransitionEnd\",a.proxy(this.hideModal,this)).emulateTransitionEnd(c.TRANSITION_DURATION):this.hideModal())},c.prototype.enforceFocus=function(){a(document).off(\"focusin.bs.modal\").on(\"focusin.bs.modal\",a.proxy(function(a){this.$element[0]===a.target||this.$element.has(a.target).length||this.$element.trigger(\"focus\")},this))},c.prototype.escape=function(){this.isShown&&this.options.keyboard?this.$element.on(\"keydown.dismiss.bs.modal\",a.proxy(function(a){27==a.which&&this.hide()},this)):this.isShown||this.$element.off(\"keydown.dismiss.bs.modal\")},c.prototype.resize=function(){this.isShown?a(window).on(\"resize.bs.modal\",a.proxy(this.handleUpdate,this)):a(window).off(\"resize.bs.modal\")},c.prototype.hideModal=function(){var a=this;this.$element.hide(),this.backdrop(function(){a.$body.removeClass(\"modal-open\"),a.resetAdjustments(),a.resetScrollbar(),a.$element.trigger(\"hidden.bs.modal\")})},c.prototype.removeBackdrop=function(){this.$backdrop&&this.$backdrop.remove(),this.$backdrop=null},c.prototype.backdrop=function(b){var d=this,e=this.$element.hasClass(\"fade\")?\"fade\":\"\";if(this.isShown&&this.options.backdrop){var f=a.support.transition&&e;if(this.$backdrop=a(document.createElement(\"div\")).addClass(\"modal-backdrop \"+e).appendTo(this.$body),this.$element.on(\"click.dismiss.bs.modal\",a.proxy(function(a){return this.ignoreBackdropClick?void(this.ignoreBackdropClick=!1):void(a.target===a.currentTarget&&(\"static\"==this.options.backdrop?this.$element[0].focus():this.hide()))},this)),f&&this.$backdrop[0].offsetWidth,this.$backdrop.addClass(\"in\"),!b)return;f?this.$backdrop.one(\"bsTransitionEnd\",b).emulateTransitionEnd(c.BACKDROP_TRANSITION_DURATION):b()}else if(!this.isShown&&this.$backdrop){this.$backdrop.removeClass(\"in\");var g=function(){d.removeBackdrop(),b&&b()};a.support.transition&&this.$element.hasClass(\"fade\")?this.$backdrop.one(\"bsTransitionEnd\",g).emulateTransitionEnd(c.BACKDROP_TRANSITION_DURATION):g()}else b&&b()},c.prototype.handleUpdate=function(){this.adjustDialog()},c.prototype.adjustDialog=function(){var a=this.$element[0].scrollHeight>document.documentElement.clientHeight;this.$element.css({paddingLeft:!this.bodyIsOverflowing&&a?this.scrollbarWidth:\"\",paddingRight:this.bodyIsOverflowing&&!a?this.scrollbarWidth:\"\"})},c.prototype.resetAdjustments=function(){this.$element.css({paddingLeft:\"\",paddingRight:\"\"})},c.prototype.checkScrollbar=function(){var a=window.innerWidth;if(!a){var b=document.documentElement.getBoundingClientRect();a=b.right-Math.abs(b.left)}this.bodyIsOverflowing=document.body.clientWidth<a,this.scrollbarWidth=this.measureScrollbar()},c.prototype.setScrollbar=function(){var a=parseInt(this.$body.css(\"padding-right\")||0,10);this.originalBodyPad=document.body.style.paddingRight||\"\",this.bodyIsOverflowing&&this.$body.css(\"padding-right\",a+this.scrollbarWidth)},c.prototype.resetScrollbar=function(){this.$body.css(\"padding-right\",this.originalBodyPad)},c.prototype.measureScrollbar=function(){var a=document.createElement(\"div\");a.className=\"modal-scrollbar-measure\",this.$body.append(a);var b=a.offsetWidth-a.clientWidth;return this.$body[0].removeChild(a),b};var d=a.fn.modal;a.fn.modal=b,a.fn.modal.Constructor=c,a.fn.modal.noConflict=function(){return a.fn.modal=d,this},a(document).on(\"click.bs.modal.data-api\",'[data-toggle=\"modal\"]',function(c){var d=a(this),e=d.attr(\"href\"),f=a(d.attr(\"data-target\")||e&&e.replace(/.*(?=#[^\\s]+$)/,\"\")),g=f.data(\"bs.modal\")?\"toggle\":a.extend({remote:!/#/.test(e)&&e},f.data(),d.data());d.is(\"a\")&&c.preventDefault(),f.one(\"show.bs.modal\",function(a){a.isDefaultPrevented()||f.one(\"hidden.bs.modal\",function(){d.is(\":visible\")&&d.trigger(\"focus\")})}),b.call(f,g,this)})}(jQuery),+function(a){\"use strict\";function b(b){return this.each(function(){var d=a(this),e=d.data(\"bs.tooltip\"),f=\"object\"==typeof b&&b;(e||!/destroy|hide/.test(b))&&(e||d.data(\"bs.tooltip\",e=new c(this,f)),\"string\"==typeof b&&e[b]())})}var c=function(a,b){this.type=null,this.options=null,this.enabled=null,this.timeout=null,this.hoverState=null,this.$element=null,this.inState=null,this.init(\"tooltip\",a,b)};c.VERSION=\"3.3.6\",c.TRANSITION_DURATION=150,c.DEFAULTS={animation:!0,placement:\"top\",selector:!1,template:'<div class=\"tooltip\" role=\"tooltip\"><div class=\"tooltip-arrow\"></div><div class=\"tooltip-inner\"></div></div>',trigger:\"hover focus\",title:\"\",delay:0,html:!1,container:!1,viewport:{selector:\"body\",padding:0}},c.prototype.init=function(b,c,d){if(this.enabled=!0,this.type=b,this.$element=a(c),this.options=this.getOptions(d),this.$viewport=this.options.viewport&&a(a.isFunction(this.options.viewport)?this.options.viewport.call(this,this.$element):this.options.viewport.selector||this.options.viewport),this.inState={click:!1,hover:!1,focus:!1},this.$element[0]instanceof document.constructor&&!this.options.selector)throw new Error(\"`selector` option must be specified when initializing \"+this.type+\" on the window.document object!\");for(var e=this.options.trigger.split(\" \"),f=e.length;f--;){var g=e[f];if(\"click\"==g)this.$element.on(\"click.\"+this.type,this.options.selector,a.proxy(this.toggle,this));else if(\"manual\"!=g){var h=\"hover\"==g?\"mouseenter\":\"focusin\",i=\"hover\"==g?\"mouseleave\":\"focusout\";this.$element.on(h+\".\"+this.type,this.options.selector,a.proxy(this.enter,this)),this.$element.on(i+\".\"+this.type,this.options.selector,a.proxy(this.leave,this))}}this.options.selector?this._options=a.extend({},this.options,{trigger:\"manual\",selector:\"\"}):this.fixTitle()},c.prototype.getDefaults=function(){return c.DEFAULTS},c.prototype.getOptions=function(b){return b=a.extend({},this.getDefaults(),this.$element.data(),b),b.delay&&\"number\"==typeof b.delay&&(b.delay={show:b.delay,hide:b.delay}),b},c.prototype.getDelegateOptions=function(){var b={},c=this.getDefaults();return this._options&&a.each(this._options,function(a,d){c[a]!=d&&(b[a]=d)}),b},c.prototype.enter=function(b){var c=b instanceof this.constructor?b:a(b.currentTarget).data(\"bs.\"+this.type);return c||(c=new this.constructor(b.currentTarget,this.getDelegateOptions()),a(b.currentTarget).data(\"bs.\"+this.type,c)),b instanceof a.Event&&(c.inState[\"focusin\"==b.type?\"focus\":\"hover\"]=!0),c.tip().hasClass(\"in\")||\"in\"==c.hoverState?void(c.hoverState=\"in\"):(clearTimeout(c.timeout),c.hoverState=\"in\",c.options.delay&&c.options.delay.show?void(c.timeout=setTimeout(function(){\"in\"==c.hoverState&&c.show()},c.options.delay.show)):c.show())},c.prototype.isInStateTrue=function(){for(var a in this.inState)if(this.inState[a])return!0;return!1},c.prototype.leave=function(b){var c=b instanceof this.constructor?b:a(b.currentTarget).data(\"bs.\"+this.type);return c||(c=new this.constructor(b.currentTarget,this.getDelegateOptions()),a(b.currentTarget).data(\"bs.\"+this.type,c)),b instanceof a.Event&&(c.inState[\"focusout\"==b.type?\"focus\":\"hover\"]=!1),c.isInStateTrue()?void 0:(clearTimeout(c.timeout),c.hoverState=\"out\",c.options.delay&&c.options.delay.hide?void(c.timeout=setTimeout(function(){\"out\"==c.hoverState&&c.hide()},c.options.delay.hide)):c.hide())},c.prototype.show=function(){var b=a.Event(\"show.bs.\"+this.type);if(this.hasContent()&&this.enabled){this.$element.trigger(b);var d=a.contains(this.$element[0].ownerDocument.documentElement,this.$element[0]);if(b.isDefaultPrevented()||!d)return;var e=this,f=this.tip(),g=this.getUID(this.type);this.setContent(),f.attr(\"id\",g),this.$element.attr(\"aria-describedby\",g),this.options.animation&&f.addClass(\"fade\");var h=\"function\"==typeof this.options.placement?this.options.placement.call(this,f[0],this.$element[0]):this.options.placement,i=/\\s?auto?\\s?/i,j=i.test(h);j&&(h=h.replace(i,\"\")||\"top\"),f.detach().css({top:0,left:0,display:\"block\"}).addClass(h).data(\"bs.\"+this.type,this),this.options.container?f.appendTo(this.options.container):f.insertAfter(this.$element),this.$element.trigger(\"inserted.bs.\"+this.type);var k=this.getPosition(),l=f[0].offsetWidth,m=f[0].offsetHeight;if(j){var n=h,o=this.getPosition(this.$viewport);h=\"bottom\"==h&&k.bottom+m>o.bottom?\"top\":\"top\"==h&&k.top-m<o.top?\"bottom\":\"right\"==h&&k.right+l>o.width?\"left\":\"left\"==h&&k.left-l<o.left?\"right\":h,f.removeClass(n).addClass(h)}var p=this.getCalculatedOffset(h,k,l,m);this.applyPlacement(p,h);var q=function(){var a=e.hoverState;e.$element.trigger(\"shown.bs.\"+e.type),e.hoverState=null,\"out\"==a&&e.leave(e)};a.support.transition&&this.$tip.hasClass(\"fade\")?f.one(\"bsTransitionEnd\",q).emulateTransitionEnd(c.TRANSITION_DURATION):q()}},c.prototype.applyPlacement=function(b,c){var d=this.tip(),e=d[0].offsetWidth,f=d[0].offsetHeight,g=parseInt(d.css(\"margin-top\"),10),h=parseInt(d.css(\"margin-left\"),10);isNaN(g)&&(g=0),isNaN(h)&&(h=0),b.top+=g,b.left+=h,a.offset.setOffset(d[0],a.extend({using:function(a){d.css({top:Math.round(a.top),left:Math.round(a.left)})}},b),0),d.addClass(\"in\");var i=d[0].offsetWidth,j=d[0].offsetHeight;\"top\"==c&&j!=f&&(b.top=b.top+f-j);var k=this.getViewportAdjustedDelta(c,b,i,j);k.left?b.left+=k.left:b.top+=k.top;var l=/top|bottom/.test(c),m=l?2*k.left-e+i:2*k.top-f+j,n=l?\"offsetWidth\":\"offsetHeight\";d.offset(b),this.replaceArrow(m,d[0][n],l)},c.prototype.replaceArrow=function(a,b,c){this.arrow().css(c?\"left\":\"top\",50*(1-a/b)+\"%\").css(c?\"top\":\"left\",\"\")},c.prototype.setContent=function(){var a=this.tip(),b=this.getTitle();a.find(\".tooltip-inner\")[this.options.html?\"html\":\"text\"](b),a.removeClass(\"fade in top bottom left right\")},c.prototype.hide=function(b){function d(){\"in\"!=e.hoverState&&f.detach(),e.$element.removeAttr(\"aria-describedby\").trigger(\"hidden.bs.\"+e.type),b&&b()}var e=this,f=a(this.$tip),g=a.Event(\"hide.bs.\"+this.type);return this.$element.trigger(g),g.isDefaultPrevented()?void 0:(f.removeClass(\"in\"),a.support.transition&&f.hasClass(\"fade\")?f.one(\"bsTransitionEnd\",d).emulateTransitionEnd(c.TRANSITION_DURATION):d(),this.hoverState=null,this)},c.prototype.fixTitle=function(){var a=this.$element;(a.attr(\"title\")||\"string\"!=typeof a.attr(\"data-original-title\"))&&a.attr(\"data-original-title\",a.attr(\"title\")||\"\").attr(\"title\",\"\")},c.prototype.hasContent=function(){return this.getTitle()},c.prototype.getPosition=function(b){b=b||this.$element;var c=b[0],d=\"BODY\"==c.tagName,e=c.getBoundingClientRect();null==e.width&&(e=a.extend({},e,{width:e.right-e.left,height:e.bottom-e.top}));var f=d?{top:0,left:0}:b.offset(),g={scroll:d?document.documentElement.scrollTop||document.body.scrollTop:b.scrollTop()},h=d?{width:a(window).width(),height:a(window).height()}:null;return a.extend({},e,g,h,f)},c.prototype.getCalculatedOffset=function(a,b,c,d){return\"bottom\"==a?{top:b.top+b.height,left:b.left+b.width/2-c/2}:\"top\"==a?{top:b.top-d,left:b.left+b.width/2-c/2}:\"left\"==a?{top:b.top+b.height/2-d/2,left:b.left-c}:{top:b.top+b.height/2-d/2,left:b.left+b.width}},c.prototype.getViewportAdjustedDelta=function(a,b,c,d){var e={top:0,left:0};if(!this.$viewport)return e;var f=this.options.viewport&&this.options.viewport.padding||0,g=this.getPosition(this.$viewport);if(/right|left/.test(a)){var h=b.top-f-g.scroll,i=b.top+f-g.scroll+d;h<g.top?e.top=g.top-h:i>g.top+g.height&&(e.top=g.top+g.height-i)}else{var j=b.left-f,k=b.left+f+c;j<g.left?e.left=g.left-j:k>g.right&&(e.left=g.left+g.width-k)}return e},c.prototype.getTitle=function(){var a,b=this.$element,c=this.options;return a=b.attr(\"data-original-title\")||(\"function\"==typeof c.title?c.title.call(b[0]):c.title)},c.prototype.getUID=function(a){do a+=~~(1e6*Math.random());while(document.getElementById(a));return a},c.prototype.tip=function(){if(!this.$tip&&(this.$tip=a(this.options.template),1!=this.$tip.length))throw new Error(this.type+\" `template` option must consist of exactly 1 top-level element!\");return this.$tip},c.prototype.arrow=function(){return this.$arrow=this.$arrow||this.tip().find(\".tooltip-arrow\")},c.prototype.enable=function(){this.enabled=!0},c.prototype.disable=function(){this.enabled=!1},c.prototype.toggleEnabled=function(){this.enabled=!this.enabled},c.prototype.toggle=function(b){var c=this;b&&(c=a(b.currentTarget).data(\"bs.\"+this.type),c||(c=new this.constructor(b.currentTarget,this.getDelegateOptions()),a(b.currentTarget).data(\"bs.\"+this.type,c))),b?(c.inState.click=!c.inState.click,c.isInStateTrue()?c.enter(c):c.leave(c)):c.tip().hasClass(\"in\")?c.leave(c):c.enter(c)},c.prototype.destroy=function(){var a=this;clearTimeout(this.timeout),this.hide(function(){a.$element.off(\".\"+a.type).removeData(\"bs.\"+a.type),a.$tip&&a.$tip.detach(),a.$tip=null,a.$arrow=null,a.$viewport=null})};var d=a.fn.tooltip;a.fn.tooltip=b,a.fn.tooltip.Constructor=c,a.fn.tooltip.noConflict=function(){return a.fn.tooltip=d,this}}(jQuery),+function(a){\"use strict\";function b(b){return this.each(function(){var d=a(this),e=d.data(\"bs.popover\"),f=\"object\"==typeof b&&b;(e||!/destroy|hide/.test(b))&&(e||d.data(\"bs.popover\",e=new c(this,f)),\"string\"==typeof b&&e[b]())})}var c=function(a,b){this.init(\"popover\",a,b)};if(!a.fn.tooltip)throw new Error(\"Popover requires tooltip.js\");c.VERSION=\"3.3.6\",c.DEFAULTS=a.extend({},a.fn.tooltip.Constructor.DEFAULTS,{placement:\"right\",trigger:\"click\",content:\"\",template:'<div class=\"popover\" role=\"tooltip\"><div class=\"arrow\"></div><h3 class=\"popover-title\"></h3><div class=\"popover-content\"></div></div>'}),c.prototype=a.extend({},a.fn.tooltip.Constructor.prototype),c.prototype.constructor=c,c.prototype.getDefaults=function(){return c.DEFAULTS},c.prototype.setContent=function(){var a=this.tip(),b=this.getTitle(),c=this.getContent();a.find(\".popover-title\")[this.options.html?\"html\":\"text\"](b),a.find(\".popover-content\").children().detach().end()[this.options.html?\"string\"==typeof c?\"html\":\"append\":\"text\"](c),a.removeClass(\"fade top bottom left right in\"),a.find(\".popover-title\").html()||a.find(\".popover-title\").hide()},c.prototype.hasContent=function(){return this.getTitle()||this.getContent()},c.prototype.getContent=function(){var a=this.$element,b=this.options;return a.attr(\"data-content\")||(\"function\"==typeof b.content?b.content.call(a[0]):b.content)},c.prototype.arrow=function(){return this.$arrow=this.$arrow||this.tip().find(\".arrow\")};var d=a.fn.popover;a.fn.popover=b,a.fn.popover.Constructor=c,a.fn.popover.noConflict=function(){return a.fn.popover=d,this}}(jQuery),+function(a){\"use strict\";function b(c,d){this.$body=a(document.body),this.$scrollElement=a(a(c).is(document.body)?window:c),this.options=a.extend({},b.DEFAULTS,d),this.selector=(this.options.target||\"\")+\" .nav li > a\",this.offsets=[],this.targets=[],this.activeTarget=null,this.scrollHeight=0,this.$scrollElement.on(\"scroll.bs.scrollspy\",a.proxy(this.process,this)),this.refresh(),this.process()}function c(c){return this.each(function(){var d=a(this),e=d.data(\"bs.scrollspy\"),f=\"object\"==typeof c&&c;e||d.data(\"bs.scrollspy\",e=new b(this,f)),\"string\"==typeof c&&e[c]()})}b.VERSION=\"3.3.6\",b.DEFAULTS={offset:10},b.prototype.getScrollHeight=function(){return this.$scrollElement[0].scrollHeight||Math.max(this.$body[0].scrollHeight,document.documentElement.scrollHeight)},b.prototype.refresh=function(){var b=this,c=\"offset\",d=0;this.offsets=[],this.targets=[],this.scrollHeight=this.getScrollHeight(),a.isWindow(this.$scrollElement[0])||(c=\"position\",d=this.$scrollElement.scrollTop()),this.$body.find(this.selector).map(function(){var b=a(this),e=b.data(\"target\")||b.attr(\"href\"),f=/^#./.test(e)&&a(e);return f&&f.length&&f.is(\":visible\")&&[[f[c]().top+d,e]]||null}).sort(function(a,b){return a[0]-b[0]}).each(function(){b.offsets.push(this[0]),b.targets.push(this[1])})},b.prototype.process=function(){var a,b=this.$scrollElement.scrollTop()+this.options.offset,c=this.getScrollHeight(),d=this.options.offset+c-this.$scrollElement.height(),e=this.offsets,f=this.targets,g=this.activeTarget;if(this.scrollHeight!=c&&this.refresh(),b>=d)return g!=(a=f[f.length-1])&&this.activate(a);if(g&&b<e[0])return this.activeTarget=null,this.clear();for(a=e.length;a--;)g!=f[a]&&b>=e[a]&&(void 0===e[a+1]||b<e[a+1])&&this.activate(f[a])},b.prototype.activate=function(b){this.activeTarget=b,this.clear();var c=this.selector+'[data-target=\"'+b+'\"],'+this.selector+'[href=\"'+b+'\"]',d=a(c).parents(\"li\").addClass(\"active\");\r\n    d.parent(\".dropdown-menu\").length&&(d=d.closest(\"li.dropdown\").addClass(\"active\")),d.trigger(\"activate.bs.scrollspy\")},b.prototype.clear=function(){a(this.selector).parentsUntil(this.options.target,\".active\").removeClass(\"active\")};var d=a.fn.scrollspy;a.fn.scrollspy=c,a.fn.scrollspy.Constructor=b,a.fn.scrollspy.noConflict=function(){return a.fn.scrollspy=d,this},a(window).on(\"load.bs.scrollspy.data-api\",function(){a('[data-spy=\"scroll\"]').each(function(){var b=a(this);c.call(b,b.data())})})}(jQuery),+function(a){\"use strict\";function b(b){return this.each(function(){var d=a(this),e=d.data(\"bs.tab\");e||d.data(\"bs.tab\",e=new c(this)),\"string\"==typeof b&&e[b]()})}var c=function(b){this.element=a(b)};c.VERSION=\"3.3.6\",c.TRANSITION_DURATION=150,c.prototype.show=function(){var b=this.element,c=b.closest(\"ul:not(.dropdown-menu)\"),d=b.data(\"target\");if(d||(d=b.attr(\"href\"),d=d&&d.replace(/.*(?=#[^\\s]*$)/,\"\")),!b.parent(\"li\").hasClass(\"active\")){var e=c.find(\".active:last a\"),f=a.Event(\"hide.bs.tab\",{relatedTarget:b[0]}),g=a.Event(\"show.bs.tab\",{relatedTarget:e[0]});if(e.trigger(f),b.trigger(g),!g.isDefaultPrevented()&&!f.isDefaultPrevented()){var h=a(d);this.activate(b.closest(\"li\"),c),this.activate(h,h.parent(),function(){e.trigger({type:\"hidden.bs.tab\",relatedTarget:b[0]}),b.trigger({type:\"shown.bs.tab\",relatedTarget:e[0]})})}}},c.prototype.activate=function(b,d,e){function f(){g.removeClass(\"active\").find(\"> .dropdown-menu > .active\").removeClass(\"active\").end().find('[data-toggle=\"tab\"]').attr(\"aria-expanded\",!1),b.addClass(\"active\").find('[data-toggle=\"tab\"]').attr(\"aria-expanded\",!0),h?(b[0].offsetWidth,b.addClass(\"in\")):b.removeClass(\"fade\"),b.parent(\".dropdown-menu\").length&&b.closest(\"li.dropdown\").addClass(\"active\").end().find('[data-toggle=\"tab\"]').attr(\"aria-expanded\",!0),e&&e()}var g=d.find(\"> .active\"),h=e&&a.support.transition&&(g.length&&g.hasClass(\"fade\")||!!d.find(\"> .fade\").length);g.length&&h?g.one(\"bsTransitionEnd\",f).emulateTransitionEnd(c.TRANSITION_DURATION):f(),g.removeClass(\"in\")};var d=a.fn.tab;a.fn.tab=b,a.fn.tab.Constructor=c,a.fn.tab.noConflict=function(){return a.fn.tab=d,this};var e=function(c){c.preventDefault(),b.call(a(this),\"show\")};a(document).on(\"click.bs.tab.data-api\",'[data-toggle=\"tab\"]',e).on(\"click.bs.tab.data-api\",'[data-toggle=\"pill\"]',e)}(jQuery),+function(a){\"use strict\";function b(b){return this.each(function(){var d=a(this),e=d.data(\"bs.affix\"),f=\"object\"==typeof b&&b;e||d.data(\"bs.affix\",e=new c(this,f)),\"string\"==typeof b&&e[b]()})}var c=function(b,d){this.options=a.extend({},c.DEFAULTS,d),this.$target=a(this.options.target).on(\"scroll.bs.affix.data-api\",a.proxy(this.checkPosition,this)).on(\"click.bs.affix.data-api\",a.proxy(this.checkPositionWithEventLoop,this)),this.$element=a(b),this.affixed=null,this.unpin=null,this.pinnedOffset=null,this.checkPosition()};c.VERSION=\"3.3.6\",c.RESET=\"affix affix-top affix-bottom\",c.DEFAULTS={offset:0,target:window},c.prototype.getState=function(a,b,c,d){var e=this.$target.scrollTop(),f=this.$element.offset(),g=this.$target.height();if(null!=c&&\"top\"==this.affixed)return c>e?\"top\":!1;if(\"bottom\"==this.affixed)return null!=c?e+this.unpin<=f.top?!1:\"bottom\":a-d>=e+g?!1:\"bottom\";var h=null==this.affixed,i=h?e:f.top,j=h?g:b;return null!=c&&c>=e?\"top\":null!=d&&i+j>=a-d?\"bottom\":!1},c.prototype.getPinnedOffset=function(){if(this.pinnedOffset)return this.pinnedOffset;this.$element.removeClass(c.RESET).addClass(\"affix\");var a=this.$target.scrollTop(),b=this.$element.offset();return this.pinnedOffset=b.top-a},c.prototype.checkPositionWithEventLoop=function(){setTimeout(a.proxy(this.checkPosition,this),1)},c.prototype.checkPosition=function(){if(this.$element.is(\":visible\")){var b=this.$element.height(),d=this.options.offset,e=d.top,f=d.bottom,g=Math.max(a(document).height(),a(document.body).height());\"object\"!=typeof d&&(f=e=d),\"function\"==typeof e&&(e=d.top(this.$element)),\"function\"==typeof f&&(f=d.bottom(this.$element));var h=this.getState(g,b,e,f);if(this.affixed!=h){null!=this.unpin&&this.$element.css(\"top\",\"\");var i=\"affix\"+(h?\"-\"+h:\"\"),j=a.Event(i+\".bs.affix\");if(this.$element.trigger(j),j.isDefaultPrevented())return;this.affixed=h,this.unpin=\"bottom\"==h?this.getPinnedOffset():null,this.$element.removeClass(c.RESET).addClass(i).trigger(i.replace(\"affix\",\"affixed\")+\".bs.affix\")}\"bottom\"==h&&this.$element.offset({top:g-b-f})}};var d=a.fn.affix;a.fn.affix=b,a.fn.affix.Constructor=c,a.fn.affix.noConflict=function(){return a.fn.affix=d,this},a(window).on(\"load\",function(){a('[data-spy=\"affix\"]').each(function(){var c=a(this),d=c.data();d.offset=d.offset||{},null!=d.offsetBottom&&(d.offset.bottom=d.offsetBottom),null!=d.offsetTop&&(d.offset.top=d.offsetTop),b.call(c,d)})})}(jQuery);","Mageplaza_Core/js/help.js":"/**\n * Mageplaza\n *\n * NOTICE OF LICENSE\n *\n * This source file is subject to the mageplaza.com license that is\n * available through the world-wide-web at this URL:\n * https://www.mageplaza.com/LICENSE.txt\n *\n * DISCLAIMER\n *\n * Do not edit or add to this file if you wish to upgrade this extension to newer\n * version in the future.\n *\n * @category    Mageplaza\n * @package     Mageplaza_Core\n * @copyright   Copyright (c) Mageplaza (https://www.mageplaza.com/)\n * @license     https://www.mageplaza.com/LICENSE.txt\n */\n\nrequire([\n    'jquery',\n    'underscore'\n], function ($, _) {\n    'use strict';\n\n    var mpHelpDb = {\n        'admin/system_config/index': [\n            {\n                'css_selector': '#general_single_store_mode_enabled',\n                'type': 'link',\n                'text': 'How to enable Single Store Mode, {link}.',\n                'url': 'https://www.mageplaza.com/kb/how-enable-single-store-mode-magento-2.html',\n                'anchor': 'learn more'\n            }\n        ],\n        'theme/design_config/edit/scope/websites/scope_id': [\n            {\n                'css_selector': 'input[name*=\"header_welcome\"]',\n                'type': 'link',\n                'text': 'How to change the welcome message, {link}.',\n                'url': 'https://www.mageplaza.com/kb/how-change-welcome-message-magento-2.html',\n                'anchor': 'learn more'\n            }\n        ],\n        'system_config/edit/section/contact': [\n            {\n                'css_selector': '#contact_contact_enabled',\n                'type': 'link',\n                'text': 'How to configure Contact Us form, {link}.',\n                'url': 'https://www.mageplaza.com/kb/how-configure-contacts-email-address-magento-2.html',\n                'anchor': 'learn more'\n            }\n        ],\n        //Not Configuration\n        'catalog/product/edit': [\n            {\n                'css_selector': '#media_gallery_content',\n                'type': 'link',\n                'text': 'How to upload Images Product, {link}.',\n                'url': 'https://www.mageplaza.com/kb/how-to-upload-images-product-in-magento-2.html',\n                'anchor': 'learn more'\n            }\n        ],\n        'type/configurable/key/': [\n            {\n                'css_selector': '.page-actions-placeholder',\n                'type': 'link',\n                'text': 'Create Configurable Product, {link}.',\n                'url': 'https://www.mageplaza.com/kb/how-create-configurable-product-magento-2.html',\n                'anchor': 'learn more'\n            }\n        ],\n        'system_config/edit/section/general': [\n            {\n                'css_selector': '#general_region_state_required',\n                'type': 'link',\n                'text': 'How to setup State, {link}.',\n                'url': 'https://www.mageplaza.com/kb/how-setup-locale-state-country-magento-2.html#set-up-state',\n                'anchor': 'learn more'\n            },\n            {\n                'css_selector': '#general_country_default',\n                'type': 'link',\n                'text': 'How to setup Country, {link}.',\n                'url': 'https://www.mageplaza.com/kb/how-setup-locale-state-country-magento-2.html#set-up-country',\n                'anchor': 'learn more'\n            },\n            {\n                'css_selector': '#general_locale_timezone',\n                'type': 'link',\n                'text': 'How to setup Locale, {link}.',\n                'url': 'https://www.mageplaza.com/kb/how-setup-locale-state-country-magento-2.html#login-magento-2',\n                'anchor': 'learn more'\n            },\n            {\n                'css_selector': '#general_store_information_name',\n                'type': 'link',\n                'text': 'How to setup store information, {link}.',\n                'url': 'https://www.mageplaza.com/kb/how-setup-store-information-magento-2.html',\n                'anchor': 'learn more'\n            }\n\n        ],\n        'system_config/edit/section/trans_email': [\n            {\n                'css_selector': '#trans_email_ident_sales_email',\n                'type': 'link',\n                'text': 'About 79% of visitors drop their shopping cart at the checkout page. This proven abandoned cart email templates that can improve that number, {link}.',\n                'url': 'https://pages.mageplaza.com/abandoned-cart-email-templates-for-magento/',\n                'anchor': 'learn more'\n            },\n        ],\n        'system_config/edit/section/newsletter': [\n            {\n                'css_selector': '#newsletter_subscription_success_email_template',\n                'type': 'link',\n                'text': 'Welcome emails generate 4 times the total open rates and 5 times the click rates compared to other bulk promotions. Get proven welcome email templates, {link}.',\n                'url': 'https://pages.mageplaza.com/welcome-email-templates-for-magento-2/',\n                'anchor': 'get a copy'\n            }\n\n\n        ],\n        'admin/email_template/new': [\n            {\n                'css_selector': '#template_select',\n                'type': 'link',\n                'text': 'Get {link} templates that convert',\n                'url': 'https://pages.mageplaza.com/bundle-of-email-follow-up-templates/',\n                'anchor': 'bundle of follow up emails'\n            }\n\n\n        ]\n    };\n\n    function buildHtml(data) {\n        var link = '<a href=\"' + data.url + '?utm_source=store&utm_medium=link&utm_campaign=mageplaza-helps\" target=\"_blank\">' + data.anchor + '</a>';\n        var text = data.text.replace('{link}', link);\n\n        return '<p class=\"note\">' + text + '</p>';\n    }\n\n    var url = window.location.href;\n    for (var path in mpHelpDb) {\n        if (mpHelpDb.hasOwnProperty(path) && url.search(path)) {\n            var datas = mpHelpDb[path];\n            _.each(datas, function (data) {\n                var html = buildHtml(data);\n                html && $(html).insertAfter(data.css_selector); //only insert if html is not empty\n            });\n        }\n    }\n});","Mageplaza_Core/js/ion.rangeSlider.min.js":"// Ion.RangeSlider | version 2.1.6 | https://github.com/IonDen/ion.rangeSlider\r\n;(function(f){\"function\"===typeof define&&define.amd?define([\"jquery\"],function(p){return f(p,document,window,navigator)}):\"object\"===typeof exports?f(require(\"jquery\"),document,window,navigator):f(jQuery,document,window,navigator)})(function(f,p,h,t,q){var u=0,m=function(){var a=t.userAgent,b=/msie\\s\\d+/i;return 0<a.search(b)&&(a=b.exec(a).toString(),a=a.split(\" \")[1],9>a)?(f(\"html\").addClass(\"lt-ie9\"),!0):!1}();Function.prototype.bind||(Function.prototype.bind=function(a){var b=this,d=[].slice;if(\"function\"!=\r\n    typeof b)throw new TypeError;var c=d.call(arguments,1),e=function(){if(this instanceof e){var g=function(){};g.prototype=b.prototype;var g=new g,l=b.apply(g,c.concat(d.call(arguments)));return Object(l)===l?l:g}return b.apply(a,c.concat(d.call(arguments)))};return e});Array.prototype.indexOf||(Array.prototype.indexOf=function(a,b){var d;if(null==this)throw new TypeError('\"this\" is null or not defined');var c=Object(this),e=c.length>>>0;if(0===e)return-1;d=+b||0;Infinity===Math.abs(d)&&(d=0);if(d>=\r\n    e)return-1;for(d=Math.max(0<=d?d:e-Math.abs(d),0);d<e;){if(d in c&&c[d]===a)return d;d++}return-1});var r=function(a,b,d){this.VERSION=\"2.1.6\";this.input=a;this.plugin_count=d;this.old_to=this.old_from=this.update_tm=this.calc_count=this.current_plugin=0;this.raf_id=this.old_min_interval=null;this.is_update=this.is_key=this.no_diapason=this.force_redraw=this.dragging=!1;this.is_start=this.is_first_update=!0;this.is_click=this.is_resize=this.is_active=this.is_finish=!1;b=b||{};this.$cache={win:f(h),\r\n    body:f(p.body),input:f(a),cont:null,rs:null,min:null,max:null,from:null,to:null,single:null,bar:null,line:null,s_single:null,s_from:null,s_to:null,shad_single:null,shad_from:null,shad_to:null,edge:null,grid:null,grid_labels:[]};this.coords={x_gap:0,x_pointer:0,w_rs:0,w_rs_old:0,w_handle:0,p_gap:0,p_gap_left:0,p_gap_right:0,p_step:0,p_pointer:0,p_handle:0,p_single_fake:0,p_single_real:0,p_from_fake:0,p_from_real:0,p_to_fake:0,p_to_real:0,p_bar_x:0,p_bar_w:0,grid_gap:0,big_num:0,big:[],big_w:[],big_p:[],\r\n    big_x:[]};this.labels={w_min:0,w_max:0,w_from:0,w_to:0,w_single:0,p_min:0,p_max:0,p_from_fake:0,p_from_left:0,p_to_fake:0,p_to_left:0,p_single_fake:0,p_single_left:0};var c=this.$cache.input;a=c.prop(\"value\");var e;d={type:\"single\",min:10,max:100,from:null,to:null,step:1,min_interval:0,max_interval:0,drag_interval:!1,values:[],p_values:[],from_fixed:!1,from_min:null,from_max:null,from_shadow:!1,to_fixed:!1,to_min:null,to_max:null,to_shadow:!1,prettify_enabled:!0,prettify_separator:\" \",prettify:null,\r\n    force_edges:!1,keyboard:!1,keyboard_step:5,grid:!1,grid_margin:!0,grid_num:4,grid_snap:!1,hide_min_max:!1,hide_from_to:!1,prefix:\"\",postfix:\"\",max_postfix:\"\",decorate_both:!0,values_separator:\" \\u2014 \",input_values_separator:\";\",disable:!1,onStart:null,onChange:null,onFinish:null,onUpdate:null};\"INPUT\"!==c[0].nodeName&&console&&console.warn&&console.warn(\"Base element should be <input>!\",c[0]);c={type:c.data(\"type\"),min:c.data(\"min\"),max:c.data(\"max\"),from:c.data(\"from\"),to:c.data(\"to\"),step:c.data(\"step\"),\r\n    min_interval:c.data(\"minInterval\"),max_interval:c.data(\"maxInterval\"),drag_interval:c.data(\"dragInterval\"),values:c.data(\"values\"),from_fixed:c.data(\"fromFixed\"),from_min:c.data(\"fromMin\"),from_max:c.data(\"fromMax\"),from_shadow:c.data(\"fromShadow\"),to_fixed:c.data(\"toFixed\"),to_min:c.data(\"toMin\"),to_max:c.data(\"toMax\"),to_shadow:c.data(\"toShadow\"),prettify_enabled:c.data(\"prettifyEnabled\"),prettify_separator:c.data(\"prettifySeparator\"),force_edges:c.data(\"forceEdges\"),keyboard:c.data(\"keyboard\"),\r\n    keyboard_step:c.data(\"keyboardStep\"),grid:c.data(\"grid\"),grid_margin:c.data(\"gridMargin\"),grid_num:c.data(\"gridNum\"),grid_snap:c.data(\"gridSnap\"),hide_min_max:c.data(\"hideMinMax\"),hide_from_to:c.data(\"hideFromTo\"),prefix:c.data(\"prefix\"),postfix:c.data(\"postfix\"),max_postfix:c.data(\"maxPostfix\"),decorate_both:c.data(\"decorateBoth\"),values_separator:c.data(\"valuesSeparator\"),input_values_separator:c.data(\"inputValuesSeparator\"),disable:c.data(\"disable\")};c.values=c.values&&c.values.split(\",\");for(e in c)c.hasOwnProperty(e)&&\r\n(c[e]!==q&&\"\"!==c[e]||delete c[e]);a!==q&&\"\"!==a&&(a=a.split(c.input_values_separator||b.input_values_separator||\";\"),a[0]&&a[0]==+a[0]&&(a[0]=+a[0]),a[1]&&a[1]==+a[1]&&(a[1]=+a[1]),b&&b.values&&b.values.length?(d.from=a[0]&&b.values.indexOf(a[0]),d.to=a[1]&&b.values.indexOf(a[1])):(d.from=a[0]&&+a[0],d.to=a[1]&&+a[1]));f.extend(d,b);f.extend(d,c);this.options=d;this.update_check={};this.validate();this.result={input:this.$cache.input,slider:null,min:this.options.min,max:this.options.max,from:this.options.from,\r\n    from_percent:0,from_value:null,to:this.options.to,to_percent:0,to_value:null};this.init()};r.prototype={init:function(a){this.no_diapason=!1;this.coords.p_step=this.convertToPercent(this.options.step,!0);this.target=\"base\";this.toggleInput();this.append();this.setMinMax();a?(this.force_redraw=!0,this.calc(!0),this.callOnUpdate()):(this.force_redraw=!0,this.calc(!0),this.callOnStart());this.updateScene()},append:function(){this.$cache.input.before('<span class=\"irs js-irs-'+this.plugin_count+'\"></span>');\r\n        this.$cache.input.prop(\"readonly\",!0);this.$cache.cont=this.$cache.input.prev();this.result.slider=this.$cache.cont;this.$cache.cont.html('<span class=\"irs\"><span class=\"irs-line\" tabindex=\"-1\"><span class=\"irs-line-left\"></span><span class=\"irs-line-mid\"></span><span class=\"irs-line-right\"></span></span><span class=\"irs-min\">0</span><span class=\"irs-max\">1</span><span class=\"irs-from\">0</span><span class=\"irs-to\">0</span><span class=\"irs-single\">0</span></span><span class=\"irs-grid\"></span><span class=\"irs-bar\"></span>');\r\n        this.$cache.rs=this.$cache.cont.find(\".irs\");this.$cache.min=this.$cache.cont.find(\".irs-min\");this.$cache.max=this.$cache.cont.find(\".irs-max\");this.$cache.from=this.$cache.cont.find(\".irs-from\");this.$cache.to=this.$cache.cont.find(\".irs-to\");this.$cache.single=this.$cache.cont.find(\".irs-single\");this.$cache.bar=this.$cache.cont.find(\".irs-bar\");this.$cache.line=this.$cache.cont.find(\".irs-line\");this.$cache.grid=this.$cache.cont.find(\".irs-grid\");\"single\"===this.options.type?(this.$cache.cont.append('<span class=\"irs-bar-edge\"></span><span class=\"irs-shadow shadow-single\"></span><span class=\"irs-slider single\"></span>'),\r\n            this.$cache.edge=this.$cache.cont.find(\".irs-bar-edge\"),this.$cache.s_single=this.$cache.cont.find(\".single\"),this.$cache.from[0].style.visibility=\"hidden\",this.$cache.to[0].style.visibility=\"hidden\",this.$cache.shad_single=this.$cache.cont.find(\".shadow-single\")):(this.$cache.cont.append('<span class=\"irs-shadow shadow-from\"></span><span class=\"irs-shadow shadow-to\"></span><span class=\"irs-slider from\"></span><span class=\"irs-slider to\"></span>'),this.$cache.s_from=this.$cache.cont.find(\".from\"),\r\n            this.$cache.s_to=this.$cache.cont.find(\".to\"),this.$cache.shad_from=this.$cache.cont.find(\".shadow-from\"),this.$cache.shad_to=this.$cache.cont.find(\".shadow-to\"),this.setTopHandler());this.options.hide_from_to&&(this.$cache.from[0].style.display=\"none\",this.$cache.to[0].style.display=\"none\",this.$cache.single[0].style.display=\"none\");this.appendGrid();this.options.disable?(this.appendDisableMask(),this.$cache.input[0].disabled=!0):(this.$cache.cont.removeClass(\"irs-disabled\"),this.$cache.input[0].disabled=\r\n            !1,this.bindEvents());this.options.drag_interval&&(this.$cache.bar[0].style.cursor=\"ew-resize\")},setTopHandler:function(){var a=this.options.max,b=this.options.to;this.options.from>this.options.min&&b===a?this.$cache.s_from.addClass(\"type_last\"):b<a&&this.$cache.s_to.addClass(\"type_last\")},changeLevel:function(a){switch(a){case \"single\":this.coords.p_gap=this.toFixed(this.coords.p_pointer-this.coords.p_single_fake);break;case \"from\":this.coords.p_gap=this.toFixed(this.coords.p_pointer-this.coords.p_from_fake);\r\n        this.$cache.s_from.addClass(\"state_hover\");this.$cache.s_from.addClass(\"type_last\");this.$cache.s_to.removeClass(\"type_last\");break;case \"to\":this.coords.p_gap=this.toFixed(this.coords.p_pointer-this.coords.p_to_fake);this.$cache.s_to.addClass(\"state_hover\");this.$cache.s_to.addClass(\"type_last\");this.$cache.s_from.removeClass(\"type_last\");break;case \"both\":this.coords.p_gap_left=this.toFixed(this.coords.p_pointer-this.coords.p_from_fake),this.coords.p_gap_right=this.toFixed(this.coords.p_to_fake-\r\n        this.coords.p_pointer),this.$cache.s_to.removeClass(\"type_last\"),this.$cache.s_from.removeClass(\"type_last\")}},appendDisableMask:function(){this.$cache.cont.append('<span class=\"irs-disable-mask\"></span>');this.$cache.cont.addClass(\"irs-disabled\")},remove:function(){this.$cache.cont.remove();this.$cache.cont=null;this.$cache.line.off(\"keydown.irs_\"+this.plugin_count);this.$cache.body.off(\"touchmove.irs_\"+this.plugin_count);this.$cache.body.off(\"mousemove.irs_\"+this.plugin_count);this.$cache.win.off(\"touchend.irs_\"+\r\n        this.plugin_count);this.$cache.win.off(\"mouseup.irs_\"+this.plugin_count);m&&(this.$cache.body.off(\"mouseup.irs_\"+this.plugin_count),this.$cache.body.off(\"mouseleave.irs_\"+this.plugin_count));this.$cache.grid_labels=[];this.coords.big=[];this.coords.big_w=[];this.coords.big_p=[];this.coords.big_x=[];cancelAnimationFrame(this.raf_id)},bindEvents:function(){if(!this.no_diapason){this.$cache.body.on(\"touchmove.irs_\"+this.plugin_count,this.pointerMove.bind(this));this.$cache.body.on(\"mousemove.irs_\"+this.plugin_count,\r\n        this.pointerMove.bind(this));this.$cache.win.on(\"touchend.irs_\"+this.plugin_count,this.pointerUp.bind(this));this.$cache.win.on(\"mouseup.irs_\"+this.plugin_count,this.pointerUp.bind(this));this.$cache.line.on(\"touchstart.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\"));this.$cache.line.on(\"mousedown.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\"));this.options.drag_interval&&\"double\"===this.options.type?(this.$cache.bar.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\r\n        \"both\")),this.$cache.bar.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"both\"))):(this.$cache.bar.on(\"touchstart.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")),this.$cache.bar.on(\"mousedown.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")));\"single\"===this.options.type?(this.$cache.single.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"single\")),this.$cache.s_single.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"single\")),\r\n        this.$cache.shad_single.on(\"touchstart.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")),this.$cache.single.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"single\")),this.$cache.s_single.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"single\")),this.$cache.edge.on(\"mousedown.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")),this.$cache.shad_single.on(\"mousedown.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\"))):(this.$cache.single.on(\"touchstart.irs_\"+\r\n        this.plugin_count,this.pointerDown.bind(this,null)),this.$cache.single.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,null)),this.$cache.from.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"from\")),this.$cache.s_from.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"from\")),this.$cache.to.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"to\")),this.$cache.s_to.on(\"touchstart.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"to\")),\r\n        this.$cache.shad_from.on(\"touchstart.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")),this.$cache.shad_to.on(\"touchstart.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")),this.$cache.from.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"from\")),this.$cache.s_from.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"from\")),this.$cache.to.on(\"mousedown.irs_\"+this.plugin_count,this.pointerDown.bind(this,\"to\")),this.$cache.s_to.on(\"mousedown.irs_\"+\r\n        this.plugin_count,this.pointerDown.bind(this,\"to\")),this.$cache.shad_from.on(\"mousedown.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")),this.$cache.shad_to.on(\"mousedown.irs_\"+this.plugin_count,this.pointerClick.bind(this,\"click\")));if(this.options.keyboard)this.$cache.line.on(\"keydown.irs_\"+this.plugin_count,this.key.bind(this,\"keyboard\"));m&&(this.$cache.body.on(\"mouseup.irs_\"+this.plugin_count,this.pointerUp.bind(this)),this.$cache.body.on(\"mouseleave.irs_\"+this.plugin_count,this.pointerUp.bind(this)))}},\r\n    pointerMove:function(a){this.dragging&&(this.coords.x_pointer=(a.pageX||a.originalEvent.touches&&a.originalEvent.touches[0].pageX)-this.coords.x_gap,this.calc())},pointerUp:function(a){this.current_plugin===this.plugin_count&&this.is_active&&(this.is_active=!1,this.$cache.cont.find(\".state_hover\").removeClass(\"state_hover\"),this.force_redraw=!0,m&&f(\"*\").prop(\"unselectable\",!1),this.updateScene(),this.restoreOriginalMinInterval(),(f.contains(this.$cache.cont[0],a.target)||this.dragging)&&this.callOnFinish(),\r\n        this.dragging=!1)},pointerDown:function(a,b){b.preventDefault();var d=b.pageX||b.originalEvent.touches&&b.originalEvent.touches[0].pageX;2!==b.button&&(\"both\"===a&&this.setTempMinInterval(),a||(a=this.target||\"from\"),this.current_plugin=this.plugin_count,this.target=a,this.dragging=this.is_active=!0,this.coords.x_gap=this.$cache.rs.offset().left,this.coords.x_pointer=d-this.coords.x_gap,this.calcPointerPercent(),this.changeLevel(a),m&&f(\"*\").prop(\"unselectable\",!0),this.$cache.line.trigger(\"focus\"),\r\n        this.updateScene())},pointerClick:function(a,b){b.preventDefault();var d=b.pageX||b.originalEvent.touches&&b.originalEvent.touches[0].pageX;2!==b.button&&(this.current_plugin=this.plugin_count,this.target=a,this.is_click=!0,this.coords.x_gap=this.$cache.rs.offset().left,this.coords.x_pointer=+(d-this.coords.x_gap).toFixed(),this.force_redraw=!0,this.calc(),this.$cache.line.trigger(\"focus\"))},key:function(a,b){if(!(this.current_plugin!==this.plugin_count||b.altKey||b.ctrlKey||b.shiftKey||b.metaKey)){switch(b.which){case 83:case 65:case 40:case 37:b.preventDefault();\r\n        this.moveByKey(!1);break;case 87:case 68:case 38:case 39:b.preventDefault(),this.moveByKey(!0)}return!0}},moveByKey:function(a){var b=this.coords.p_pointer,b=a?b+this.options.keyboard_step:b-this.options.keyboard_step;this.coords.x_pointer=this.toFixed(this.coords.w_rs/100*b);this.is_key=!0;this.calc()},setMinMax:function(){this.options&&(this.options.hide_min_max?(this.$cache.min[0].style.display=\"none\",this.$cache.max[0].style.display=\"none\"):(this.options.values.length?(this.$cache.min.html(this.decorate(this.options.p_values[this.options.min])),\r\n        this.$cache.max.html(this.decorate(this.options.p_values[this.options.max]))):(this.$cache.min.html(this.decorate(this._prettify(this.options.min),this.options.min)),this.$cache.max.html(this.decorate(this._prettify(this.options.max),this.options.max))),this.labels.w_min=this.$cache.min.outerWidth(!1),this.labels.w_max=this.$cache.max.outerWidth(!1)))},setTempMinInterval:function(){var a=this.result.to-this.result.from;null===this.old_min_interval&&(this.old_min_interval=this.options.min_interval);\r\n        this.options.min_interval=a},restoreOriginalMinInterval:function(){null!==this.old_min_interval&&(this.options.min_interval=this.old_min_interval,this.old_min_interval=null)},calc:function(a){if(this.options){this.calc_count++;if(10===this.calc_count||a)this.calc_count=0,this.coords.w_rs=this.$cache.rs.outerWidth(!1),this.calcHandlePercent();if(this.coords.w_rs){this.calcPointerPercent();a=this.getHandleX();\"both\"===this.target&&(this.coords.p_gap=0,a=this.getHandleX());\"click\"===this.target&&(this.coords.p_gap=\r\n        this.coords.p_handle/2,a=this.getHandleX(),this.target=this.options.drag_interval?\"both_one\":this.chooseHandle(a));switch(this.target){case \"base\":var b=(this.options.max-this.options.min)/100;a=(this.result.from-this.options.min)/b;b=(this.result.to-this.options.min)/b;this.coords.p_single_real=this.toFixed(a);this.coords.p_from_real=this.toFixed(a);this.coords.p_to_real=this.toFixed(b);this.coords.p_single_real=this.checkDiapason(this.coords.p_single_real,this.options.from_min,this.options.from_max);\r\n        this.coords.p_from_real=this.checkDiapason(this.coords.p_from_real,this.options.from_min,this.options.from_max);this.coords.p_to_real=this.checkDiapason(this.coords.p_to_real,this.options.to_min,this.options.to_max);this.coords.p_single_fake=this.convertToFakePercent(this.coords.p_single_real);this.coords.p_from_fake=this.convertToFakePercent(this.coords.p_from_real);this.coords.p_to_fake=this.convertToFakePercent(this.coords.p_to_real);this.target=null;break;case \"single\":if(this.options.from_fixed)break;\r\n        this.coords.p_single_real=this.convertToRealPercent(a);this.coords.p_single_real=this.calcWithStep(this.coords.p_single_real);this.coords.p_single_real=this.checkDiapason(this.coords.p_single_real,this.options.from_min,this.options.from_max);this.coords.p_single_fake=this.convertToFakePercent(this.coords.p_single_real);break;case \"from\":if(this.options.from_fixed)break;this.coords.p_from_real=this.convertToRealPercent(a);this.coords.p_from_real=this.calcWithStep(this.coords.p_from_real);this.coords.p_from_real>\r\n    this.coords.p_to_real&&(this.coords.p_from_real=this.coords.p_to_real);this.coords.p_from_real=this.checkDiapason(this.coords.p_from_real,this.options.from_min,this.options.from_max);this.coords.p_from_real=this.checkMinInterval(this.coords.p_from_real,this.coords.p_to_real,\"from\");this.coords.p_from_real=this.checkMaxInterval(this.coords.p_from_real,this.coords.p_to_real,\"from\");this.coords.p_from_fake=this.convertToFakePercent(this.coords.p_from_real);break;case \"to\":if(this.options.to_fixed)break;\r\n        this.coords.p_to_real=this.convertToRealPercent(a);this.coords.p_to_real=this.calcWithStep(this.coords.p_to_real);this.coords.p_to_real<this.coords.p_from_real&&(this.coords.p_to_real=this.coords.p_from_real);this.coords.p_to_real=this.checkDiapason(this.coords.p_to_real,this.options.to_min,this.options.to_max);this.coords.p_to_real=this.checkMinInterval(this.coords.p_to_real,this.coords.p_from_real,\"to\");this.coords.p_to_real=this.checkMaxInterval(this.coords.p_to_real,this.coords.p_from_real,\"to\");\r\n        this.coords.p_to_fake=this.convertToFakePercent(this.coords.p_to_real);break;case \"both\":if(this.options.from_fixed||this.options.to_fixed)break;a=this.toFixed(a+.001*this.coords.p_handle);this.coords.p_from_real=this.convertToRealPercent(a)-this.coords.p_gap_left;this.coords.p_from_real=this.calcWithStep(this.coords.p_from_real);this.coords.p_from_real=this.checkDiapason(this.coords.p_from_real,this.options.from_min,this.options.from_max);this.coords.p_from_real=this.checkMinInterval(this.coords.p_from_real,\r\n        this.coords.p_to_real,\"from\");this.coords.p_from_fake=this.convertToFakePercent(this.coords.p_from_real);this.coords.p_to_real=this.convertToRealPercent(a)+this.coords.p_gap_right;this.coords.p_to_real=this.calcWithStep(this.coords.p_to_real);this.coords.p_to_real=this.checkDiapason(this.coords.p_to_real,this.options.to_min,this.options.to_max);this.coords.p_to_real=this.checkMinInterval(this.coords.p_to_real,this.coords.p_from_real,\"to\");this.coords.p_to_fake=this.convertToFakePercent(this.coords.p_to_real);\r\n        break;case \"both_one\":if(!this.options.from_fixed&&!this.options.to_fixed){var d=this.convertToRealPercent(a);a=this.result.to_percent-this.result.from_percent;var c=a/2,b=d-c,d=d+c;0>b&&(b=0,d=b+a);100<d&&(d=100,b=d-a);this.coords.p_from_real=this.calcWithStep(b);this.coords.p_from_real=this.checkDiapason(this.coords.p_from_real,this.options.from_min,this.options.from_max);this.coords.p_from_fake=this.convertToFakePercent(this.coords.p_from_real);this.coords.p_to_real=this.calcWithStep(d);this.coords.p_to_real=\r\n        this.checkDiapason(this.coords.p_to_real,this.options.to_min,this.options.to_max);this.coords.p_to_fake=this.convertToFakePercent(this.coords.p_to_real)}}\"single\"===this.options.type?(this.coords.p_bar_x=this.coords.p_handle/2,this.coords.p_bar_w=this.coords.p_single_fake,this.result.from_percent=this.coords.p_single_real,this.result.from=this.convertToValue(this.coords.p_single_real),this.options.values.length&&(this.result.from_value=this.options.values[this.result.from])):(this.coords.p_bar_x=\r\n        this.toFixed(this.coords.p_from_fake+this.coords.p_handle/2),this.coords.p_bar_w=this.toFixed(this.coords.p_to_fake-this.coords.p_from_fake),this.result.from_percent=this.coords.p_from_real,this.result.from=this.convertToValue(this.coords.p_from_real),this.result.to_percent=this.coords.p_to_real,this.result.to=this.convertToValue(this.coords.p_to_real),this.options.values.length&&(this.result.from_value=this.options.values[this.result.from],this.result.to_value=this.options.values[this.result.to]));\r\n        this.calcMinMax();this.calcLabels()}}},calcPointerPercent:function(){this.coords.w_rs?(0>this.coords.x_pointer||isNaN(this.coords.x_pointer)?this.coords.x_pointer=0:this.coords.x_pointer>this.coords.w_rs&&(this.coords.x_pointer=this.coords.w_rs),this.coords.p_pointer=this.toFixed(this.coords.x_pointer/this.coords.w_rs*100)):this.coords.p_pointer=0},convertToRealPercent:function(a){return a/(100-this.coords.p_handle)*100},convertToFakePercent:function(a){return a/100*(100-this.coords.p_handle)},getHandleX:function(){var a=\r\n        100-this.coords.p_handle,b=this.toFixed(this.coords.p_pointer-this.coords.p_gap);0>b?b=0:b>a&&(b=a);return b},calcHandlePercent:function(){this.coords.w_handle=\"single\"===this.options.type?this.$cache.s_single.outerWidth(!1):this.$cache.s_from.outerWidth(!1);this.coords.p_handle=this.toFixed(this.coords.w_handle/this.coords.w_rs*100)},chooseHandle:function(a){return\"single\"===this.options.type?\"single\":a>=this.coords.p_from_real+(this.coords.p_to_real-this.coords.p_from_real)/2?this.options.to_fixed?\r\n        \"from\":\"to\":this.options.from_fixed?\"to\":\"from\"},calcMinMax:function(){this.coords.w_rs&&(this.labels.p_min=this.labels.w_min/this.coords.w_rs*100,this.labels.p_max=this.labels.w_max/this.coords.w_rs*100)},calcLabels:function(){this.coords.w_rs&&!this.options.hide_from_to&&(\"single\"===this.options.type?(this.labels.w_single=this.$cache.single.outerWidth(!1),this.labels.p_single_fake=this.labels.w_single/this.coords.w_rs*100,this.labels.p_single_left=this.coords.p_single_fake+this.coords.p_handle/\r\n        2-this.labels.p_single_fake/2):(this.labels.w_from=this.$cache.from.outerWidth(!1),this.labels.p_from_fake=this.labels.w_from/this.coords.w_rs*100,this.labels.p_from_left=this.coords.p_from_fake+this.coords.p_handle/2-this.labels.p_from_fake/2,this.labels.p_from_left=this.toFixed(this.labels.p_from_left),this.labels.p_from_left=this.checkEdges(this.labels.p_from_left,this.labels.p_from_fake),this.labels.w_to=this.$cache.to.outerWidth(!1),this.labels.p_to_fake=this.labels.w_to/this.coords.w_rs*100,\r\n        this.labels.p_to_left=this.coords.p_to_fake+this.coords.p_handle/2-this.labels.p_to_fake/2,this.labels.p_to_left=this.toFixed(this.labels.p_to_left),this.labels.p_to_left=this.checkEdges(this.labels.p_to_left,this.labels.p_to_fake),this.labels.w_single=this.$cache.single.outerWidth(!1),this.labels.p_single_fake=this.labels.w_single/this.coords.w_rs*100,this.labels.p_single_left=(this.labels.p_from_left+this.labels.p_to_left+this.labels.p_to_fake)/2-this.labels.p_single_fake/2,this.labels.p_single_left=\r\n        this.toFixed(this.labels.p_single_left)),this.labels.p_single_left=this.checkEdges(this.labels.p_single_left,this.labels.p_single_fake))},updateScene:function(){this.raf_id&&(cancelAnimationFrame(this.raf_id),this.raf_id=null);clearTimeout(this.update_tm);this.update_tm=null;this.options&&(this.drawHandles(),this.is_active?this.raf_id=requestAnimationFrame(this.updateScene.bind(this)):this.update_tm=setTimeout(this.updateScene.bind(this),300))},drawHandles:function(){this.coords.w_rs=this.$cache.rs.outerWidth(!1);\r\n        if(this.coords.w_rs){this.coords.w_rs!==this.coords.w_rs_old&&(this.target=\"base\",this.is_resize=!0);if(this.coords.w_rs!==this.coords.w_rs_old||this.force_redraw)this.setMinMax(),this.calc(!0),this.drawLabels(),this.options.grid&&(this.calcGridMargin(),this.calcGridLabels()),this.force_redraw=!0,this.coords.w_rs_old=this.coords.w_rs,this.drawShadow();if(this.coords.w_rs&&(this.dragging||this.force_redraw||this.is_key)){if(this.old_from!==this.result.from||this.old_to!==this.result.to||this.force_redraw||\r\n            this.is_key){this.drawLabels();this.$cache.bar[0].style.left=this.coords.p_bar_x+\"%\";this.$cache.bar[0].style.width=this.coords.p_bar_w+\"%\";if(\"single\"===this.options.type)this.$cache.s_single[0].style.left=this.coords.p_single_fake+\"%\";else{this.$cache.s_from[0].style.left=this.coords.p_from_fake+\"%\";this.$cache.s_to[0].style.left=this.coords.p_to_fake+\"%\";if(this.old_from!==this.result.from||this.force_redraw)this.$cache.from[0].style.left=this.labels.p_from_left+\"%\";if(this.old_to!==this.result.to||\r\n            this.force_redraw)this.$cache.to[0].style.left=this.labels.p_to_left+\"%\"}this.$cache.single[0].style.left=this.labels.p_single_left+\"%\";this.writeToInput();this.old_from===this.result.from&&this.old_to===this.result.to||this.is_start||(this.$cache.input.trigger(\"change\"),this.$cache.input.trigger(\"input\"));this.old_from=this.result.from;this.old_to=this.result.to;this.is_resize||this.is_update||this.is_start||this.is_finish||this.callOnChange();if(this.is_key||this.is_click||this.is_first_update)this.is_first_update=\r\n            this.is_click=this.is_key=!1,this.callOnFinish();this.is_finish=this.is_resize=this.is_update=!1}this.force_redraw=this.is_click=this.is_key=this.is_start=!1}}},drawLabels:function(){if(this.options){var a=this.options.values.length,b=this.options.p_values,d;if(!this.options.hide_from_to)if(\"single\"===this.options.type)a=a?this.decorate(b[this.result.from]):this.decorate(this._prettify(this.result.from),this.result.from),this.$cache.single.html(a),this.calcLabels(),this.$cache.min[0].style.visibility=\r\n        this.labels.p_single_left<this.labels.p_min+1?\"hidden\":\"visible\",this.$cache.max[0].style.visibility=this.labels.p_single_left+this.labels.p_single_fake>100-this.labels.p_max-1?\"hidden\":\"visible\";else{a?(this.options.decorate_both?(a=this.decorate(b[this.result.from]),a+=this.options.values_separator,a+=this.decorate(b[this.result.to])):a=this.decorate(b[this.result.from]+this.options.values_separator+b[this.result.to]),d=this.decorate(b[this.result.from]),b=this.decorate(b[this.result.to])):(this.options.decorate_both?\r\n        (a=this.decorate(this._prettify(this.result.from),this.result.from),a+=this.options.values_separator,a+=this.decorate(this._prettify(this.result.to),this.result.to)):a=this.decorate(this._prettify(this.result.from)+this.options.values_separator+this._prettify(this.result.to),this.result.to),d=this.decorate(this._prettify(this.result.from),this.result.from),b=this.decorate(this._prettify(this.result.to),this.result.to));this.$cache.single.html(a);this.$cache.from.html(d);this.$cache.to.html(b);this.calcLabels();\r\n        b=Math.min(this.labels.p_single_left,this.labels.p_from_left);a=this.labels.p_single_left+this.labels.p_single_fake;d=this.labels.p_to_left+this.labels.p_to_fake;var c=Math.max(a,d);this.labels.p_from_left+this.labels.p_from_fake>=this.labels.p_to_left?(this.$cache.from[0].style.visibility=\"hidden\",this.$cache.to[0].style.visibility=\"hidden\",this.$cache.single[0].style.visibility=\"visible\",this.result.from===this.result.to?(\"from\"===this.target?this.$cache.from[0].style.visibility=\"visible\":\"to\"===\r\n        this.target?this.$cache.to[0].style.visibility=\"visible\":this.target||(this.$cache.from[0].style.visibility=\"visible\"),this.$cache.single[0].style.visibility=\"hidden\",c=d):(this.$cache.from[0].style.visibility=\"hidden\",this.$cache.to[0].style.visibility=\"hidden\",this.$cache.single[0].style.visibility=\"visible\",c=Math.max(a,d))):(this.$cache.from[0].style.visibility=\"visible\",this.$cache.to[0].style.visibility=\"visible\",this.$cache.single[0].style.visibility=\"hidden\");this.$cache.min[0].style.visibility=\r\n            b<this.labels.p_min+1?\"hidden\":\"visible\";this.$cache.max[0].style.visibility=c>100-this.labels.p_max-1?\"hidden\":\"visible\"}}},drawShadow:function(){var a=this.options,b=this.$cache,d=\"number\"===typeof a.from_min&&!isNaN(a.from_min),c=\"number\"===typeof a.from_max&&!isNaN(a.from_max),e=\"number\"===typeof a.to_min&&!isNaN(a.to_min),g=\"number\"===typeof a.to_max&&!isNaN(a.to_max);\"single\"===a.type?a.from_shadow&&(d||c)?(d=this.convertToPercent(d?a.from_min:a.min),c=this.convertToPercent(c?a.from_max:a.max)-\r\n        d,d=this.toFixed(d-this.coords.p_handle/100*d),c=this.toFixed(c-this.coords.p_handle/100*c),d+=this.coords.p_handle/2,b.shad_single[0].style.display=\"block\",b.shad_single[0].style.left=d+\"%\",b.shad_single[0].style.width=c+\"%\"):b.shad_single[0].style.display=\"none\":(a.from_shadow&&(d||c)?(d=this.convertToPercent(d?a.from_min:a.min),c=this.convertToPercent(c?a.from_max:a.max)-d,d=this.toFixed(d-this.coords.p_handle/100*d),c=this.toFixed(c-this.coords.p_handle/100*c),d+=this.coords.p_handle/2,b.shad_from[0].style.display=\r\n        \"block\",b.shad_from[0].style.left=d+\"%\",b.shad_from[0].style.width=c+\"%\"):b.shad_from[0].style.display=\"none\",a.to_shadow&&(e||g)?(e=this.convertToPercent(e?a.to_min:a.min),a=this.convertToPercent(g?a.to_max:a.max)-e,e=this.toFixed(e-this.coords.p_handle/100*e),a=this.toFixed(a-this.coords.p_handle/100*a),e+=this.coords.p_handle/2,b.shad_to[0].style.display=\"block\",b.shad_to[0].style.left=e+\"%\",b.shad_to[0].style.width=a+\"%\"):b.shad_to[0].style.display=\"none\")},writeToInput:function(){\"single\"===\r\n    this.options.type?(this.options.values.length?this.$cache.input.prop(\"value\",this.result.from_value):this.$cache.input.prop(\"value\",this.result.from),this.$cache.input.data(\"from\",this.result.from)):(this.options.values.length?this.$cache.input.prop(\"value\",this.result.from_value+this.options.input_values_separator+this.result.to_value):this.$cache.input.prop(\"value\",this.result.from+this.options.input_values_separator+this.result.to),this.$cache.input.data(\"from\",this.result.from),this.$cache.input.data(\"to\",\r\n        this.result.to))},callOnStart:function(){this.writeToInput();if(this.options.onStart&&\"function\"===typeof this.options.onStart)this.options.onStart(this.result)},callOnChange:function(){this.writeToInput();if(this.options.onChange&&\"function\"===typeof this.options.onChange)this.options.onChange(this.result)},callOnFinish:function(){this.writeToInput();if(this.options.onFinish&&\"function\"===typeof this.options.onFinish)this.options.onFinish(this.result)},callOnUpdate:function(){this.writeToInput();\r\n        if(this.options.onUpdate&&\"function\"===typeof this.options.onUpdate)this.options.onUpdate(this.result)},toggleInput:function(){this.$cache.input.toggleClass(\"irs-hidden-input\")},convertToPercent:function(a,b){var d=this.options.max-this.options.min;return d?this.toFixed((b?a:a-this.options.min)/(d/100)):(this.no_diapason=!0,0)},convertToValue:function(a){var b=this.options.min,d=this.options.max,c=b.toString().split(\".\")[1],e=d.toString().split(\".\")[1],g,l,f=0,k=0;if(0===a)return this.options.min;\r\n        if(100===a)return this.options.max;c&&(f=g=c.length);e&&(f=l=e.length);g&&l&&(f=g>=l?g:l);0>b&&(k=Math.abs(b),b=+(b+k).toFixed(f),d=+(d+k).toFixed(f));a=(d-b)/100*a+b;(b=this.options.step.toString().split(\".\")[1])?a=+a.toFixed(b.length):(a/=this.options.step,a*=this.options.step,a=+a.toFixed(0));k&&(a-=k);k=b?+a.toFixed(b.length):this.toFixed(a);k<this.options.min?k=this.options.min:k>this.options.max&&(k=this.options.max);return k},calcWithStep:function(a){var b=Math.round(a/this.coords.p_step)*\r\n        this.coords.p_step;100<b&&(b=100);100===a&&(b=100);return this.toFixed(b)},checkMinInterval:function(a,b,d){var c=this.options;if(!c.min_interval)return a;a=this.convertToValue(a);b=this.convertToValue(b);\"from\"===d?b-a<c.min_interval&&(a=b-c.min_interval):a-b<c.min_interval&&(a=b+c.min_interval);return this.convertToPercent(a)},checkMaxInterval:function(a,b,d){var c=this.options;if(!c.max_interval)return a;a=this.convertToValue(a);b=this.convertToValue(b);\"from\"===d?b-a>c.max_interval&&(a=b-c.max_interval):\r\n        a-b>c.max_interval&&(a=b+c.max_interval);return this.convertToPercent(a)},checkDiapason:function(a,b,d){a=this.convertToValue(a);var c=this.options;\"number\"!==typeof b&&(b=c.min);\"number\"!==typeof d&&(d=c.max);a<b&&(a=b);a>d&&(a=d);return this.convertToPercent(a)},toFixed:function(a){a=a.toFixed(20);return+a},_prettify:function(a){return this.options.prettify_enabled?this.options.prettify&&\"function\"===typeof this.options.prettify?this.options.prettify(a):this.prettify(a):a},prettify:function(a){return a.toString().replace(/(\\d{1,3}(?=(?:\\d\\d\\d)+(?!\\d)))/g,\r\n        \"$1\"+this.options.prettify_separator)},checkEdges:function(a,b){if(!this.options.force_edges)return this.toFixed(a);0>a?a=0:a>100-b&&(a=100-b);return this.toFixed(a)},validate:function(){var a=this.options,b=this.result,d=a.values,c=d.length,e,g;\"string\"===typeof a.min&&(a.min=+a.min);\"string\"===typeof a.max&&(a.max=+a.max);\"string\"===typeof a.from&&(a.from=+a.from);\"string\"===typeof a.to&&(a.to=+a.to);\"string\"===typeof a.step&&(a.step=+a.step);\"string\"===typeof a.from_min&&(a.from_min=+a.from_min);\r\n        \"string\"===typeof a.from_max&&(a.from_max=+a.from_max);\"string\"===typeof a.to_min&&(a.to_min=+a.to_min);\"string\"===typeof a.to_max&&(a.to_max=+a.to_max);\"string\"===typeof a.keyboard_step&&(a.keyboard_step=+a.keyboard_step);\"string\"===typeof a.grid_num&&(a.grid_num=+a.grid_num);a.max<a.min&&(a.max=a.min);if(c)for(a.p_values=[],a.min=0,a.max=c-1,a.step=1,a.grid_num=a.max,a.grid_snap=!0,g=0;g<c;g++)e=+d[g],isNaN(e)?e=d[g]:(d[g]=e,e=this._prettify(e)),a.p_values.push(e);if(\"number\"!==typeof a.from||isNaN(a.from))a.from=\r\n            a.min;if(\"number\"!==typeof a.to||isNaN(a.to))a.to=a.max;\"single\"===a.type?(a.from<a.min&&(a.from=a.min),a.from>a.max&&(a.from=a.max)):(a.from<a.min&&(a.from=a.min),a.from>a.max&&(a.from=a.max),a.to<a.min&&(a.to=a.min),a.to>a.max&&(a.to=a.max),this.update_check.from&&(this.update_check.from!==a.from&&a.from>a.to&&(a.from=a.to),this.update_check.to!==a.to&&a.to<a.from&&(a.to=a.from)),a.from>a.to&&(a.from=a.to),a.to<a.from&&(a.to=a.from));if(\"number\"!==typeof a.step||isNaN(a.step)||!a.step||0>a.step)a.step=\r\n            1;if(\"number\"!==typeof a.keyboard_step||isNaN(a.keyboard_step)||!a.keyboard_step||0>a.keyboard_step)a.keyboard_step=5;\"number\"===typeof a.from_min&&a.from<a.from_min&&(a.from=a.from_min);\"number\"===typeof a.from_max&&a.from>a.from_max&&(a.from=a.from_max);\"number\"===typeof a.to_min&&a.to<a.to_min&&(a.to=a.to_min);\"number\"===typeof a.to_max&&a.from>a.to_max&&(a.to=a.to_max);if(b){b.min!==a.min&&(b.min=a.min);b.max!==a.max&&(b.max=a.max);if(b.from<b.min||b.from>b.max)b.from=a.from;if(b.to<b.min||b.to>\r\n            b.max)b.to=a.to}if(\"number\"!==typeof a.min_interval||isNaN(a.min_interval)||!a.min_interval||0>a.min_interval)a.min_interval=0;if(\"number\"!==typeof a.max_interval||isNaN(a.max_interval)||!a.max_interval||0>a.max_interval)a.max_interval=0;a.min_interval&&a.min_interval>a.max-a.min&&(a.min_interval=a.max-a.min);a.max_interval&&a.max_interval>a.max-a.min&&(a.max_interval=a.max-a.min)},decorate:function(a,b){var d=\"\",c=this.options;c.prefix&&(d+=c.prefix);d+=a;c.max_postfix&&(c.values.length&&a===c.p_values[c.max]?\r\n        (d+=c.max_postfix,c.postfix&&(d+=\" \")):b===c.max&&(d+=c.max_postfix,c.postfix&&(d+=\" \")));c.postfix&&(d+=c.postfix);return d},updateFrom:function(){this.result.from=this.options.from;this.result.from_percent=this.convertToPercent(this.result.from);this.options.values&&(this.result.from_value=this.options.values[this.result.from])},updateTo:function(){this.result.to=this.options.to;this.result.to_percent=this.convertToPercent(this.result.to);this.options.values&&(this.result.to_value=this.options.values[this.result.to])},\r\n    updateResult:function(){this.result.min=this.options.min;this.result.max=this.options.max;this.updateFrom();this.updateTo()},appendGrid:function(){if(this.options.grid){var a=this.options,b,d;b=a.max-a.min;var c=a.grid_num,e,g,f=4,h,k,m,n=\"\";this.calcGridMargin();a.grid_snap?(c=b/a.step,e=this.toFixed(a.step/(b/100))):e=this.toFixed(100/c);4<c&&(f=3);7<c&&(f=2);14<c&&(f=1);28<c&&(f=0);for(b=0;b<c+1;b++){h=f;g=this.toFixed(e*b);100<g&&(g=100,h-=2,0>h&&(h=0));this.coords.big[b]=g;k=(g-e*(b-1))/(h+1);\r\n        for(d=1;d<=h&&0!==g;d++)m=this.toFixed(g-k*d),n+='<span class=\"irs-grid-pol small\" style=\"left: '+m+'%\"></span>';n+='<span class=\"irs-grid-pol\" style=\"left: '+g+'%\"></span>';d=this.convertToValue(g);d=a.values.length?a.p_values[d]:this._prettify(d);n+='<span class=\"irs-grid-text js-grid-text-'+b+'\" style=\"left: '+g+'%\">'+d+\"</span>\"}this.coords.big_num=Math.ceil(c+1);this.$cache.cont.addClass(\"irs-with-grid\");this.$cache.grid.html(n);this.cacheGridLabels()}},cacheGridLabels:function(){var a,b,d=this.coords.big_num;\r\n        for(b=0;b<d;b++)a=this.$cache.grid.find(\".js-grid-text-\"+b),this.$cache.grid_labels.push(a);this.calcGridLabels()},calcGridLabels:function(){var a,b;b=[];var d=[],c=this.coords.big_num;for(a=0;a<c;a++)this.coords.big_w[a]=this.$cache.grid_labels[a].outerWidth(!1),this.coords.big_p[a]=this.toFixed(this.coords.big_w[a]/this.coords.w_rs*100),this.coords.big_x[a]=this.toFixed(this.coords.big_p[a]/2),b[a]=this.toFixed(this.coords.big[a]-this.coords.big_x[a]),d[a]=this.toFixed(b[a]+this.coords.big_p[a]);\r\n        this.options.force_edges&&(b[0]<-this.coords.grid_gap&&(b[0]=-this.coords.grid_gap,d[0]=this.toFixed(b[0]+this.coords.big_p[0]),this.coords.big_x[0]=this.coords.grid_gap),d[c-1]>100+this.coords.grid_gap&&(d[c-1]=100+this.coords.grid_gap,b[c-1]=this.toFixed(d[c-1]-this.coords.big_p[c-1]),this.coords.big_x[c-1]=this.toFixed(this.coords.big_p[c-1]-this.coords.grid_gap)));this.calcGridCollision(2,b,d);this.calcGridCollision(4,b,d);for(a=0;a<c;a++)b=this.$cache.grid_labels[a][0],this.coords.big_x[a]!==\r\n        Number.POSITIVE_INFINITY&&(b.style.marginLeft=-this.coords.big_x[a]+\"%\")},calcGridCollision:function(a,b,d){var c,e,g,f=this.coords.big_num;for(c=0;c<f;c+=a){e=c+a/2;if(e>=f)break;g=this.$cache.grid_labels[e][0];g.style.visibility=d[c]<=b[e]?\"visible\":\"hidden\"}},calcGridMargin:function(){this.options.grid_margin&&(this.coords.w_rs=this.$cache.rs.outerWidth(!1),this.coords.w_rs&&(this.coords.w_handle=\"single\"===this.options.type?this.$cache.s_single.outerWidth(!1):this.$cache.s_from.outerWidth(!1),\r\n        this.coords.p_handle=this.toFixed(this.coords.w_handle/this.coords.w_rs*100),this.coords.grid_gap=this.toFixed(this.coords.p_handle/2-.1),this.$cache.grid[0].style.width=this.toFixed(100-this.coords.p_handle)+\"%\",this.$cache.grid[0].style.left=this.coords.grid_gap+\"%\"))},update:function(a){this.input&&(this.is_update=!0,this.options.from=this.result.from,this.options.to=this.result.to,this.update_check.from=this.result.from,this.update_check.to=this.result.to,this.options=f.extend(this.options,a),\r\n        this.validate(),this.updateResult(a),this.toggleInput(),this.remove(),this.init(!0))},reset:function(){this.input&&(this.updateResult(),this.update())},destroy:function(){this.input&&(this.toggleInput(),this.$cache.input.prop(\"readonly\",!1),f.data(this.input,\"ionRangeSlider\",null),this.remove(),this.options=this.input=null)}};f.fn.ionRangeSlider=function(a){return this.each(function(){f.data(this,\"ionRangeSlider\")||f.data(this,\"ionRangeSlider\",new r(this,a,u++))})};(function(){for(var a=0,b=[\"ms\",\r\n    \"moz\",\"webkit\",\"o\"],d=0;d<b.length&&!h.requestAnimationFrame;++d)h.requestAnimationFrame=h[b[d]+\"RequestAnimationFrame\"],h.cancelAnimationFrame=h[b[d]+\"CancelAnimationFrame\"]||h[b[d]+\"CancelRequestAnimationFrame\"];h.requestAnimationFrame||(h.requestAnimationFrame=function(b,d){var c=(new Date).getTime(),e=Math.max(0,16-(c-a)),f=h.setTimeout(function(){b(c+e)},e);a=c+e;return f});h.cancelAnimationFrame||(h.cancelAnimationFrame=function(a){clearTimeout(a)})})()});\r\n","Mageplaza_Core/js/jquery.autocomplete.min.js":"/**\r\n *  Ajax Autocomplete for jQuery, version 1.3.0\r\n *  (c) 2017 Tomas Kirda\r\n *\r\n *  Ajax Autocomplete for jQuery is freely distributable under the terms of an MIT-style license.\r\n *  For details, see the web site: https://github.com/devbridge/jQuery-Autocomplete\r\n */\r\n!function(a){\"use strict\";\"function\"==typeof define&&define.amd?define([\"jquery\"],a):a(\"object\"==typeof exports&&\"function\"==typeof require?require(\"jquery\"):jQuery)}(function(a){\"use strict\";function b(c,d){var e=a.noop,f=this,g={ajaxSettings:{},autoSelectFirst:!1,appendTo:document.body,serviceUrl:null,lookup:null,onSelect:null,width:\"auto\",minChars:1,maxHeight:300,deferRequestBy:0,params:{},formatResult:b.formatResult,formatGroup:b.formatGroup,delimiter:null,zIndex:9999,type:\"GET\",noCache:!1,onSearchStart:e,onSearchComplete:e,onSearchError:e,preserveInput:!1,containerClass:\"autocomplete-suggestions\",tabDisabled:!1,dataType:\"text\",currentRequest:null,triggerSelectOnValidInput:!0,preventBadQueries:!0,lookupFilter:function(a,b,c){return-1!==a.value.toLowerCase().indexOf(c)},paramName:\"query\",transformResult:function(b){return\"string\"==typeof b?a.parseJSON(b):b},showNoSuggestionNotice:!1,noSuggestionNotice:\"No results\",orientation:\"bottom\",forceFixPosition:!1};f.element=c,f.el=a(c),f.suggestions=[],f.badQueries=[],f.selectedIndex=-1,f.currentValue=f.element.value,f.intervalId=0,f.cachedResponse={},f.onChangeInterval=null,f.onChange=null,f.isLocal=!1,f.suggestionsContainer=null,f.noSuggestionsContainer=null,f.options=a.extend({},g,d),f.classes={selected:\"autocomplete-selected\",suggestion:\"autocomplete-suggestion\"},f.hint=null,f.hintValue=\"\",f.selection=null,f.initialize(),f.setOptions(d)}var c=function(){return{escapeRegExChars:function(a){return a.replace(/[|\\\\{}()[\\]^$+*?.]/g,\"\\\\$&\")},createNode:function(a){var b=document.createElement(\"div\");return b.className=a,b.style.position=\"absolute\",b.style.display=\"none\",b}}}(),d={ESC:27,TAB:9,RETURN:13,LEFT:37,UP:38,RIGHT:39,DOWN:40};b.utils=c,a.Autocomplete=b,b.formatResult=function(a,b){if(!b)return a.value;var d=\"(\"+c.escapeRegExChars(b)+\")\";return a.value.replace(new RegExp(d,\"gi\"),\"<strong>$1</strong>\").replace(/&/g,\"&amp;\").replace(/</g,\"&lt;\").replace(/>/g,\"&gt;\").replace(/\"/g,\"&quot;\").replace(/&lt;(\\/?strong)&gt;/g,\"<$1>\")},b.formatGroup=function(a,b){return'<div class=\"autocomplete-group\"><strong>'+b+\"</strong></div>\"},b.prototype={killerFn:null,initialize:function(){var c,d=this,e=\".\"+d.classes.suggestion,f=d.classes.selected,g=d.options;d.element.setAttribute(\"autocomplete\",\"off\"),d.killerFn=function(b){a(b.target).closest(\".\"+d.options.containerClass).length||(d.killSuggestions(),d.disableKillerFn())},d.noSuggestionsContainer=a('<div class=\"autocomplete-no-suggestion\"></div>').html(this.options.noSuggestionNotice).get(0),d.suggestionsContainer=b.utils.createNode(g.containerClass),c=a(d.suggestionsContainer),c.appendTo(g.appendTo),\"auto\"!==g.width&&c.css(\"width\",g.width),c.on(\"mouseover.autocomplete\",e,function(){d.activate(a(this).data(\"index\"))}),c.on(\"mouseout.autocomplete\",function(){d.selectedIndex=-1,c.children(\".\"+f).removeClass(f)}),c.on(\"click.autocomplete\",e,function(){return d.select(a(this).data(\"index\")),!1}),d.fixPositionCapture=function(){d.visible&&d.fixPosition()},a(window).on(\"resize.autocomplete\",d.fixPositionCapture),d.el.on(\"keydown.autocomplete\",function(a){d.onKeyPress(a)}),d.el.on(\"keyup.autocomplete\",function(a){d.onKeyUp(a)}),d.el.on(\"blur.autocomplete\",function(){d.onBlur()}),d.el.on(\"focus.autocomplete\",function(){d.onFocus()}),d.el.on(\"change.autocomplete\",function(a){d.onKeyUp(a)}),d.el.on(\"input.autocomplete\",function(a){d.onKeyUp(a)})},onFocus:function(){var a=this;a.fixPosition(),a.el.val().length>=a.options.minChars&&a.onValueChange()},onBlur:function(){this.enableKillerFn()},abortAjax:function(){var a=this;a.currentRequest&&(a.currentRequest.abort(),a.currentRequest=null)},setOptions:function(b){var c=this,d=c.options;a.extend(d,b),c.isLocal=a.isArray(d.lookup),c.isLocal&&(d.lookup=c.verifySuggestionsFormat(d.lookup)),d.orientation=c.validateOrientation(d.orientation,\"bottom\"),a(c.suggestionsContainer).css({\"max-height\":d.maxHeight+\"px\",width:d.width+\"px\",\"z-index\":d.zIndex})},clearCache:function(){this.cachedResponse={},this.badQueries=[]},clear:function(){this.clearCache(),this.currentValue=\"\",this.suggestions=[]},disable:function(){var a=this;a.disabled=!0,clearInterval(a.onChangeInterval),a.abortAjax()},enable:function(){this.disabled=!1},fixPosition:function(){var b=this,c=a(b.suggestionsContainer),d=c.parent().get(0);if(d===document.body||b.options.forceFixPosition){var e=b.options.orientation,f=c.outerHeight(),g=b.el.outerHeight(),h=b.el.offset(),i={top:h.top,left:h.left};if(\"auto\"===e){var j=a(window).height(),k=a(window).scrollTop(),l=-k+h.top-f,m=k+j-(h.top+g+f);e=Math.max(l,m)===l?\"top\":\"bottom\"}if(\"top\"===e?i.top+=-f:i.top+=g,d!==document.body){var n,o=c.css(\"opacity\");b.visible||c.css(\"opacity\",0).show(),n=c.offsetParent().offset(),i.top-=n.top,i.left-=n.left,b.visible||c.css(\"opacity\",o).hide()}\"auto\"===b.options.width&&(i.width=b.el.outerWidth()+\"px\"),c.css(i)}},enableKillerFn:function(){var b=this;a(document).on(\"click.autocomplete\",b.killerFn)},disableKillerFn:function(){var b=this;a(document).off(\"click.autocomplete\",b.killerFn)},killSuggestions:function(){var a=this;a.stopKillSuggestions(),a.intervalId=window.setInterval(function(){a.visible&&(a.options.preserveInput||a.el.val(a.currentValue),a.hide()),a.stopKillSuggestions()},50)},stopKillSuggestions:function(){window.clearInterval(this.intervalId)},isCursorAtEnd:function(){var a,b=this,c=b.el.val().length,d=b.element.selectionStart;return\"number\"==typeof d?d===c:document.selection?(a=document.selection.createRange(),a.moveStart(\"character\",-c),c===a.text.length):!0},onKeyPress:function(a){var b=this;if(!b.disabled&&!b.visible&&a.which===d.DOWN&&b.currentValue)return void b.suggest();if(!b.disabled&&b.visible){switch(a.which){case d.ESC:b.el.val(b.currentValue),b.hide();break;case d.RIGHT:if(b.hint&&b.options.onHint&&b.isCursorAtEnd()){b.selectHint();break}return;case d.TAB:if(b.hint&&b.options.onHint)return void b.selectHint();if(-1===b.selectedIndex)return void b.hide();if(b.select(b.selectedIndex),b.options.tabDisabled===!1)return;break;case d.RETURN:if(-1===b.selectedIndex)return void b.hide();b.select(b.selectedIndex);break;case d.UP:b.moveUp();break;case d.DOWN:b.moveDown();break;default:return}a.stopImmediatePropagation(),a.preventDefault()}},onKeyUp:function(a){var b=this;if(!b.disabled){switch(a.which){case d.UP:case d.DOWN:return}clearInterval(b.onChangeInterval),b.currentValue!==b.el.val()&&(b.findBestHint(),b.options.deferRequestBy>0?b.onChangeInterval=setInterval(function(){b.onValueChange()},b.options.deferRequestBy):b.onValueChange())}},onValueChange:function(){var b=this,c=b.options,d=b.el.val(),e=b.getQuery(d);return b.selection&&b.currentValue!==e&&(b.selection=null,(c.onInvalidateSelection||a.noop).call(b.element)),clearInterval(b.onChangeInterval),b.currentValue=d,b.selectedIndex=-1,c.triggerSelectOnValidInput&&b.isExactMatch(e)?void b.select(0):void(e.length<c.minChars?b.hide():b.getSuggestions(e))},isExactMatch:function(a){var b=this.suggestions;return 1===b.length&&b[0].value.toLowerCase()===a.toLowerCase()},getQuery:function(b){var c,d=this.options.delimiter;return d?(c=b.split(d),a.trim(c[c.length-1])):b},getSuggestionsLocal:function(b){var c,d=this,e=d.options,f=b.toLowerCase(),g=e.lookupFilter,h=parseInt(e.lookupLimit,10);return c={suggestions:a.grep(e.lookup,function(a){return g(a,b,f)})},h&&c.suggestions.length>h&&(c.suggestions=c.suggestions.slice(0,h)),c},getSuggestions:function(b){var c,d,e,f,g=this,h=g.options,i=h.serviceUrl;if(h.params[h.paramName]=b,d=h.ignoreParams?null:h.params,h.onSearchStart.call(g.element,h.params)!==!1){if(a.isFunction(h.lookup))return void h.lookup(b,function(a){g.suggestions=a.suggestions,g.suggest(),h.onSearchComplete.call(g.element,b,a.suggestions)});g.isLocal?c=g.getSuggestionsLocal(b):(a.isFunction(i)&&(i=i.call(g.element,b)),e=i+\"?\"+a.param(d||{}),c=g.cachedResponse[e]),c&&a.isArray(c.suggestions)?(g.suggestions=c.suggestions,g.suggest(),h.onSearchComplete.call(g.element,b,c.suggestions)):g.isBadQuery(b)?h.onSearchComplete.call(g.element,b,[]):(g.abortAjax(),f={url:i,data:d,type:h.type,dataType:h.dataType},a.extend(f,h.ajaxSettings),g.currentRequest=a.ajax(f).done(function(a){var c;g.currentRequest=null,c=h.transformResult(a,b),g.processResponse(c,b,e),h.onSearchComplete.call(g.element,b,c.suggestions)}).fail(function(a,c,d){h.onSearchError.call(g.element,b,a,c,d)}))}},isBadQuery:function(a){if(!this.options.preventBadQueries)return!1;for(var b=this.badQueries,c=b.length;c--;)if(0===a.indexOf(b[c]))return!0;return!1},hide:function(){var b=this,c=a(b.suggestionsContainer);a.isFunction(b.options.onHide)&&b.visible&&b.options.onHide.call(b.element,c),b.visible=!1,b.selectedIndex=-1,clearInterval(b.onChangeInterval),a(b.suggestionsContainer).hide(),b.signalHint(null)},suggest:function(){if(!this.suggestions.length)return void(this.options.showNoSuggestionNotice?this.noSuggestions():this.hide());var b,c=this,d=c.options,e=d.groupBy,f=d.formatResult,g=c.getQuery(c.currentValue),h=c.classes.suggestion,i=c.classes.selected,j=a(c.suggestionsContainer),k=a(c.noSuggestionsContainer),l=d.beforeRender,m=\"\",n=function(a,c){var f=a.data[e];return b===f?\"\":(b=f,d.formatGroup(a,b))};return d.triggerSelectOnValidInput&&c.isExactMatch(g)?void c.select(0):(a.each(c.suggestions,function(a,b){e&&(m+=n(b,g,a)),m+='<div class=\"'+h+'\" data-index=\"'+a+'\">'+f(b,g,a)+\"</div>\"}),this.adjustContainerWidth(),k.detach(),j.html(m),a.isFunction(l)&&l.call(c.element,j,c.suggestions),c.fixPosition(),j.show(),d.autoSelectFirst&&(c.selectedIndex=0,j.scrollTop(0),j.children(\".\"+h).first().addClass(i)),c.visible=!0,void c.findBestHint())},noSuggestions:function(){var b=this,c=a(b.suggestionsContainer),d=a(b.noSuggestionsContainer);this.adjustContainerWidth(),d.detach(),c.empty(),c.append(d),b.fixPosition(),c.show(),b.visible=!0},adjustContainerWidth:function(){var b,c=this,d=c.options,e=a(c.suggestionsContainer);\"auto\"===d.width?(b=c.el.outerWidth(),e.css(\"width\",b>0?b:300)):\"flex\"===d.width&&e.css(\"width\",\"\")},findBestHint:function(){var b=this,c=b.el.val().toLowerCase(),d=null;c&&(a.each(b.suggestions,function(a,b){var e=0===b.value.toLowerCase().indexOf(c);return e&&(d=b),!e}),b.signalHint(d))},signalHint:function(b){var c=\"\",d=this;b&&(c=d.currentValue+b.value.substr(d.currentValue.length)),d.hintValue!==c&&(d.hintValue=c,d.hint=b,(this.options.onHint||a.noop)(c))},verifySuggestionsFormat:function(b){return b.length&&\"string\"==typeof b[0]?a.map(b,function(a){return{value:a,data:null}}):b},validateOrientation:function(b,c){return b=a.trim(b||\"\").toLowerCase(),-1===a.inArray(b,[\"auto\",\"bottom\",\"top\"])&&(b=c),b},processResponse:function(a,b,c){var d=this,e=d.options;a.suggestions=d.verifySuggestionsFormat(a.suggestions),e.noCache||(d.cachedResponse[c]=a,e.preventBadQueries&&!a.suggestions.length&&d.badQueries.push(b)),b===d.getQuery(d.currentValue)&&(d.suggestions=a.suggestions,d.suggest())},activate:function(b){var c,d=this,e=d.classes.selected,f=a(d.suggestionsContainer),g=f.find(\".\"+d.classes.suggestion);return f.find(\".\"+e).removeClass(e),d.selectedIndex=b,-1!==d.selectedIndex&&g.length>d.selectedIndex?(c=g.get(d.selectedIndex),a(c).addClass(e),c):null},selectHint:function(){var b=this,c=a.inArray(b.hint,b.suggestions);b.select(c)},select:function(a){var b=this;b.hide(),b.onSelect(a),b.disableKillerFn()},moveUp:function(){var b=this;if(-1!==b.selectedIndex)return 0===b.selectedIndex?(a(b.suggestionsContainer).children().first().removeClass(b.classes.selected),b.selectedIndex=-1,b.el.val(b.currentValue),void b.findBestHint()):void b.adjustScroll(b.selectedIndex-1)},moveDown:function(){var a=this;a.selectedIndex!==a.suggestions.length-1&&a.adjustScroll(a.selectedIndex+1)},adjustScroll:function(b){var c=this,d=c.activate(b);if(d){var e,f,g,h=a(d).outerHeight();e=d.offsetTop,f=a(c.suggestionsContainer).scrollTop(),g=f+c.options.maxHeight-h,f>e?a(c.suggestionsContainer).scrollTop(e):e>g&&a(c.suggestionsContainer).scrollTop(e-c.options.maxHeight+h),c.options.preserveInput||c.el.val(c.getValue(c.suggestions[b].value)),c.signalHint(null)}},onSelect:function(b){var c=this,d=c.options.onSelect,e=c.suggestions[b];c.currentValue=c.getValue(e.value),c.currentValue===c.el.val()||c.options.preserveInput||c.el.val(c.currentValue),c.signalHint(null),c.suggestions=[],c.selection=e,a.isFunction(d)&&d.call(c.element,e)},getValue:function(a){var b,c,d=this,e=d.options.delimiter;return e?(b=d.currentValue,c=b.split(e),1===c.length?a:b.substr(0,b.length-c[c.length-1].length)+a):a},dispose:function(){var b=this;b.el.off(\".autocomplete\").removeData(\"autocomplete\"),b.disableKillerFn(),a(window).off(\"resize.autocomplete\",b.fixPositionCapture),a(b.suggestionsContainer).remove()}},a.fn.autocomplete=a.fn.devbridgeAutocomplete=function(c,d){var e=\"autocomplete\";return arguments.length?this.each(function(){var f=a(this),g=f.data(e);\"string\"==typeof c?g&&\"function\"==typeof g[c]&&g[c](d):(g&&g.dispose&&g.dispose(),g=new b(this,c),f.data(e,g))}):this.first().data(e)}});","Mageplaza_Core/js/jquery.magnific-popup.min.js":"// Magnific Popup v1.1.0 by Dmitry Semenov\r\n// http://bit.ly/magnific-popup#build=inline+image+ajax+iframe+gallery+retina+imagezoom\r\n(function(a){typeof define==\"function\"&&define.amd?define([\"jquery\"],a):typeof exports==\"object\"?a(require(\"jquery\")):a(window.jQuery||window.Zepto)})(function(a){var b=\"Close\",c=\"BeforeClose\",d=\"AfterClose\",e=\"BeforeAppend\",f=\"MarkupParse\",g=\"Open\",h=\"Change\",i=\"mfp\",j=\".\"+i,k=\"mfp-ready\",l=\"mfp-removing\",m=\"mfp-prevent-close\",n,o=function(){},p=!!window.jQuery,q,r=a(window),s,t,u,v,w=function(a,b){n.ev.on(i+a+j,b)},x=function(b,c,d,e){var f=document.createElement(\"div\");return f.className=\"mfp-\"+b,d&&(f.innerHTML=d),e?c&&c.appendChild(f):(f=a(f),c&&f.appendTo(c)),f},y=function(b,c){n.ev.triggerHandler(i+b,c),n.st.callbacks&&(b=b.charAt(0).toLowerCase()+b.slice(1),n.st.callbacks[b]&&n.st.callbacks[b].apply(n,a.isArray(c)?c:[c]))},z=function(b){if(b!==v||!n.currTemplate.closeBtn)n.currTemplate.closeBtn=a(n.st.closeMarkup.replace(\"%title%\",n.st.tClose)),v=b;return n.currTemplate.closeBtn},A=function(){a.magnificPopup.instance||(n=new o,n.init(),a.magnificPopup.instance=n)},B=function(){var a=document.createElement(\"p\").style,b=[\"ms\",\"O\",\"Moz\",\"Webkit\"];if(a.transition!==undefined)return!0;while(b.length)if(b.pop()+\"Transition\"in a)return!0;return!1};o.prototype={constructor:o,init:function(){var b=navigator.appVersion;n.isLowIE=n.isIE8=document.all&&!document.addEventListener,n.isAndroid=/android/gi.test(b),n.isIOS=/iphone|ipad|ipod/gi.test(b),n.supportsTransition=B(),n.probablyMobile=n.isAndroid||n.isIOS||/(Opera Mini)|Kindle|webOS|BlackBerry|(Opera Mobi)|(Windows Phone)|IEMobile/i.test(navigator.userAgent),s=a(document),n.popupsCache={}},open:function(b){var c;if(b.isObj===!1){n.items=b.items.toArray(),n.index=0;var d=b.items,e;for(c=0;c<d.length;c++){e=d[c],e.parsed&&(e=e.el[0]);if(e===b.el[0]){n.index=c;break}}}else n.items=a.isArray(b.items)?b.items:[b.items],n.index=b.index||0;if(n.isOpen){n.updateItemHTML();return}n.types=[],u=\"\",b.mainEl&&b.mainEl.length?n.ev=b.mainEl.eq(0):n.ev=s,b.key?(n.popupsCache[b.key]||(n.popupsCache[b.key]={}),n.currTemplate=n.popupsCache[b.key]):n.currTemplate={},n.st=a.extend(!0,{},a.magnificPopup.defaults,b),n.fixedContentPos=n.st.fixedContentPos===\"auto\"?!n.probablyMobile:n.st.fixedContentPos,n.st.modal&&(n.st.closeOnContentClick=!1,n.st.closeOnBgClick=!1,n.st.showCloseBtn=!1,n.st.enableEscapeKey=!1),n.bgOverlay||(n.bgOverlay=x(\"bg\").on(\"click\"+j,function(){n.close()}),n.wrap=x(\"wrap\").attr(\"tabindex\",-1).on(\"click\"+j,function(a){n._checkIfClose(a.target)&&n.close()}),n.container=x(\"container\",n.wrap)),n.contentContainer=x(\"content\"),n.st.preloader&&(n.preloader=x(\"preloader\",n.container,n.st.tLoading));var h=a.magnificPopup.modules;for(c=0;c<h.length;c++){var i=h[c];i=i.charAt(0).toUpperCase()+i.slice(1),n[\"init\"+i].call(n)}y(\"BeforeOpen\"),n.st.showCloseBtn&&(n.st.closeBtnInside?(w(f,function(a,b,c,d){c.close_replaceWith=z(d.type)}),u+=\" mfp-close-btn-in\"):n.wrap.append(z())),n.st.alignTop&&(u+=\" mfp-align-top\"),n.fixedContentPos?n.wrap.css({overflow:n.st.overflowY,overflowX:\"hidden\",overflowY:n.st.overflowY}):n.wrap.css({top:r.scrollTop(),position:\"absolute\"}),(n.st.fixedBgPos===!1||n.st.fixedBgPos===\"auto\"&&!n.fixedContentPos)&&n.bgOverlay.css({height:s.height(),position:\"absolute\"}),n.st.enableEscapeKey&&s.on(\"keyup\"+j,function(a){a.keyCode===27&&n.close()}),r.on(\"resize\"+j,function(){n.updateSize()}),n.st.closeOnContentClick||(u+=\" mfp-auto-cursor\"),u&&n.wrap.addClass(u);var l=n.wH=r.height(),m={};if(n.fixedContentPos&&n._hasScrollBar(l)){var o=n._getScrollbarSize();o&&(m.marginRight=o)}n.fixedContentPos&&(n.isIE7?a(\"body, html\").css(\"overflow\",\"hidden\"):m.overflow=\"hidden\");var p=n.st.mainClass;return n.isIE7&&(p+=\" mfp-ie7\"),p&&n._addClassToMFP(p),n.updateItemHTML(),y(\"BuildControls\"),a(\"html\").css(m),n.bgOverlay.add(n.wrap).prependTo(n.st.prependTo||a(document.body)),n._lastFocusedEl=document.activeElement,setTimeout(function(){n.content?(n._addClassToMFP(k),n._setFocus()):n.bgOverlay.addClass(k),s.on(\"focusin\"+j,n._onFocusIn)},16),n.isOpen=!0,n.updateSize(l),y(g),b},close:function(){if(!n.isOpen)return;y(c),n.isOpen=!1,n.st.removalDelay&&!n.isLowIE&&n.supportsTransition?(n._addClassToMFP(l),setTimeout(function(){n._close()},n.st.removalDelay)):n._close()},_close:function(){y(b);var c=l+\" \"+k+\" \";n.bgOverlay.detach(),n.wrap.detach(),n.container.empty(),n.st.mainClass&&(c+=n.st.mainClass+\" \"),n._removeClassFromMFP(c);if(n.fixedContentPos){var e={marginRight:\"\"};n.isIE7?a(\"body, html\").css(\"overflow\",\"\"):e.overflow=\"\",a(\"html\").css(e)}s.off(\"keyup\"+j+\" focusin\"+j),n.ev.off(j),n.wrap.attr(\"class\",\"mfp-wrap\").removeAttr(\"style\"),n.bgOverlay.attr(\"class\",\"mfp-bg\"),n.container.attr(\"class\",\"mfp-container\"),n.st.showCloseBtn&&(!n.st.closeBtnInside||n.currTemplate[n.currItem.type]===!0)&&n.currTemplate.closeBtn&&n.currTemplate.closeBtn.detach(),n.st.autoFocusLast&&n._lastFocusedEl&&a(n._lastFocusedEl).focus(),n.currItem=null,n.content=null,n.currTemplate=null,n.prevHeight=0,y(d)},updateSize:function(a){if(n.isIOS){var b=document.documentElement.clientWidth/window.innerWidth,c=window.innerHeight*b;n.wrap.css(\"height\",c),n.wH=c}else n.wH=a||r.height();n.fixedContentPos||n.wrap.css(\"height\",n.wH),y(\"Resize\")},updateItemHTML:function(){var b=n.items[n.index];n.contentContainer.detach(),n.content&&n.content.detach(),b.parsed||(b=n.parseEl(n.index));var c=b.type;y(\"BeforeChange\",[n.currItem?n.currItem.type:\"\",c]),n.currItem=b;if(!n.currTemplate[c]){var d=n.st[c]?n.st[c].markup:!1;y(\"FirstMarkupParse\",d),d?n.currTemplate[c]=a(d):n.currTemplate[c]=!0}t&&t!==b.type&&n.container.removeClass(\"mfp-\"+t+\"-holder\");var e=n[\"get\"+c.charAt(0).toUpperCase()+c.slice(1)](b,n.currTemplate[c]);n.appendContent(e,c),b.preloaded=!0,y(h,b),t=b.type,n.container.prepend(n.contentContainer),y(\"AfterChange\")},appendContent:function(a,b){n.content=a,a?n.st.showCloseBtn&&n.st.closeBtnInside&&n.currTemplate[b]===!0?n.content.find(\".mfp-close\").length||n.content.append(z()):n.content=a:n.content=\"\",y(e),n.container.addClass(\"mfp-\"+b+\"-holder\"),n.contentContainer.append(n.content)},parseEl:function(b){var c=n.items[b],d;c.tagName?c={el:a(c)}:(d=c.type,c={data:c,src:c.src});if(c.el){var e=n.types;for(var f=0;f<e.length;f++)if(c.el.hasClass(\"mfp-\"+e[f])){d=e[f];break}c.src=c.el.attr(\"data-mfp-src\"),c.src||(c.src=c.el.attr(\"href\"))}return c.type=d||n.st.type||\"inline\",c.index=b,c.parsed=!0,n.items[b]=c,y(\"ElementParse\",c),n.items[b]},addGroup:function(a,b){var c=function(c){c.mfpEl=this,n._openClick(c,a,b)};b||(b={});var d=\"click.magnificPopup\";b.mainEl=a,b.items?(b.isObj=!0,a.off(d).on(d,c)):(b.isObj=!1,b.delegate?a.off(d).on(d,b.delegate,c):(b.items=a,a.off(d).on(d,c)))},_openClick:function(b,c,d){var e=d.midClick!==undefined?d.midClick:a.magnificPopup.defaults.midClick;if(!e&&(b.which===2||b.ctrlKey||b.metaKey||b.altKey||b.shiftKey))return;var f=d.disableOn!==undefined?d.disableOn:a.magnificPopup.defaults.disableOn;if(f)if(a.isFunction(f)){if(!f.call(n))return!0}else if(r.width()<f)return!0;b.type&&(b.preventDefault(),n.isOpen&&b.stopPropagation()),d.el=a(b.mfpEl),d.delegate&&(d.items=c.find(d.delegate)),n.open(d)},updateStatus:function(a,b){if(n.preloader){q!==a&&n.container.removeClass(\"mfp-s-\"+q),!b&&a===\"loading\"&&(b=n.st.tLoading);var c={status:a,text:b};y(\"UpdateStatus\",c),a=c.status,b=c.text,n.preloader.html(b),n.preloader.find(\"a\").on(\"click\",function(a){a.stopImmediatePropagation()}),n.container.addClass(\"mfp-s-\"+a),q=a}},_checkIfClose:function(b){if(a(b).hasClass(m))return;var c=n.st.closeOnContentClick,d=n.st.closeOnBgClick;if(c&&d)return!0;if(!n.content||a(b).hasClass(\"mfp-close\")||n.preloader&&b===n.preloader[0])return!0;if(b!==n.content[0]&&!a.contains(n.content[0],b)){if(d&&a.contains(document,b))return!0}else if(c)return!0;return!1},_addClassToMFP:function(a){n.bgOverlay.addClass(a),n.wrap.addClass(a)},_removeClassFromMFP:function(a){this.bgOverlay.removeClass(a),n.wrap.removeClass(a)},_hasScrollBar:function(a){return(n.isIE7?s.height():document.body.scrollHeight)>(a||r.height())},_setFocus:function(){(n.st.focus?n.content.find(n.st.focus).eq(0):n.wrap).focus()},_onFocusIn:function(b){if(b.target!==n.wrap[0]&&!a.contains(n.wrap[0],b.target))return n._setFocus(),!1},_parseMarkup:function(b,c,d){var e;d.data&&(c=a.extend(d.data,c)),y(f,[b,c,d]),a.each(c,function(c,d){if(d===undefined||d===!1)return!0;e=c.split(\"_\");if(e.length>1){var f=b.find(j+\"-\"+e[0]);if(f.length>0){var g=e[1];g===\"replaceWith\"?f[0]!==d[0]&&f.replaceWith(d):g===\"img\"?f.is(\"img\")?f.attr(\"src\",d):f.replaceWith(a(\"<img>\").attr(\"src\",d).attr(\"class\",f.attr(\"class\"))):f.attr(e[1],d)}}else b.find(j+\"-\"+c).html(d)})},_getScrollbarSize:function(){if(n.scrollbarSize===undefined){var a=document.createElement(\"div\");a.style.cssText=\"width: 99px; height: 99px; overflow: scroll; position: absolute; top: -9999px;\",document.body.appendChild(a),n.scrollbarSize=a.offsetWidth-a.clientWidth,document.body.removeChild(a)}return n.scrollbarSize}},a.magnificPopup={instance:null,proto:o.prototype,modules:[],open:function(b,c){return A(),b?b=a.extend(!0,{},b):b={},b.isObj=!0,b.index=c||0,this.instance.open(b)},close:function(){return a.magnificPopup.instance&&a.magnificPopup.instance.close()},registerModule:function(b,c){c.options&&(a.magnificPopup.defaults[b]=c.options),a.extend(this.proto,c.proto),this.modules.push(b)},defaults:{disableOn:0,key:null,midClick:!1,mainClass:\"\",preloader:!0,focus:\"\",closeOnContentClick:!1,closeOnBgClick:!0,closeBtnInside:!0,showCloseBtn:!0,enableEscapeKey:!0,modal:!1,alignTop:!1,removalDelay:0,prependTo:null,fixedContentPos:\"auto\",fixedBgPos:\"auto\",overflowY:\"auto\",closeMarkup:'<button title=\"%title%\" type=\"button\" class=\"mfp-close\">&#215;</button>',tClose:\"Close (Esc)\",tLoading:\"Loading...\",autoFocusLast:!0}},a.fn.magnificPopup=function(b){A();var c=a(this);if(typeof b==\"string\")if(b===\"open\"){var d,e=p?c.data(\"magnificPopup\"):c[0].magnificPopup,f=parseInt(arguments[1],10)||0;e.items?d=e.items[f]:(d=c,e.delegate&&(d=d.find(e.delegate)),d=d.eq(f)),n._openClick({mfpEl:d},c,e)}else n.isOpen&&n[b].apply(n,Array.prototype.slice.call(arguments,1));else b=a.extend(!0,{},b),p?c.data(\"magnificPopup\",b):c[0].magnificPopup=b,n.addGroup(c,b);return c};var C=\"inline\",D,E,F,G=function(){F&&(E.after(F.addClass(D)).detach(),F=null)};a.magnificPopup.registerModule(C,{options:{hiddenClass:\"hide\",markup:\"\",tNotFound:\"Content not found\"},proto:{initInline:function(){n.types.push(C),w(b+\".\"+C,function(){G()})},getInline:function(b,c){G();if(b.src){var d=n.st.inline,e=a(b.src);if(e.length){var f=e[0].parentNode;f&&f.tagName&&(E||(D=d.hiddenClass,E=x(D),D=\"mfp-\"+D),F=e.after(E).detach().removeClass(D)),n.updateStatus(\"ready\")}else n.updateStatus(\"error\",d.tNotFound),e=a(\"<div>\");return b.inlineElement=e,e}return n.updateStatus(\"ready\"),n._parseMarkup(c,{},b),c}}});var H=\"ajax\",I,J=function(){I&&a(document.body).removeClass(I)},K=function(){J(),n.req&&n.req.abort()};a.magnificPopup.registerModule(H,{options:{settings:null,cursor:\"mfp-ajax-cur\",tError:'<a href=\"%url%\">The content</a> could not be loaded.'},proto:{initAjax:function(){n.types.push(H),I=n.st.ajax.cursor,w(b+\".\"+H,K),w(\"BeforeChange.\"+H,K)},getAjax:function(b){I&&a(document.body).addClass(I),n.updateStatus(\"loading\");var c=a.extend({url:b.src,success:function(c,d,e){var f={data:c,xhr:e};y(\"ParseAjax\",f),n.appendContent(a(f.data),H),b.finished=!0,J(),n._setFocus(),setTimeout(function(){n.wrap.addClass(k)},16),n.updateStatus(\"ready\"),y(\"AjaxContentAdded\")},error:function(){J(),b.finished=b.loadError=!0,n.updateStatus(\"error\",n.st.ajax.tError.replace(\"%url%\",b.src))}},n.st.ajax.settings);return n.req=a.ajax(c),\"\"}}});var L,M=function(b){if(b.data&&b.data.title!==undefined)return b.data.title;var c=n.st.image.titleSrc;if(c){if(a.isFunction(c))return c.call(n,b);if(b.el)return b.el.attr(c)||\"\"}return\"\"};a.magnificPopup.registerModule(\"image\",{options:{markup:'<div class=\"mfp-figure\"><div class=\"mfp-close\"></div><figure><div class=\"mfp-img\"></div><figcaption><div class=\"mfp-bottom-bar\"><div class=\"mfp-title\"></div><div class=\"mfp-counter\"></div></div></figcaption></figure></div>',cursor:\"mfp-zoom-out-cur\",titleSrc:\"title\",verticalFit:!0,tError:'<a href=\"%url%\">The image</a> could not be loaded.'},proto:{initImage:function(){var c=n.st.image,d=\".image\";n.types.push(\"image\"),w(g+d,function(){n.currItem.type===\"image\"&&c.cursor&&a(document.body).addClass(c.cursor)}),w(b+d,function(){c.cursor&&a(document.body).removeClass(c.cursor),r.off(\"resize\"+j)}),w(\"Resize\"+d,n.resizeImage),n.isLowIE&&w(\"AfterChange\",n.resizeImage)},resizeImage:function(){var a=n.currItem;if(!a||!a.img)return;if(n.st.image.verticalFit){var b=0;n.isLowIE&&(b=parseInt(a.img.css(\"padding-top\"),10)+parseInt(a.img.css(\"padding-bottom\"),10)),a.img.css(\"max-height\",n.wH-b)}},_onImageHasSize:function(a){a.img&&(a.hasSize=!0,L&&clearInterval(L),a.isCheckingImgSize=!1,y(\"ImageHasSize\",a),a.imgHidden&&(n.content&&n.content.removeClass(\"mfp-loading\"),a.imgHidden=!1))},findImageSize:function(a){var b=0,c=a.img[0],d=function(e){L&&clearInterval(L),L=setInterval(function(){if(c.naturalWidth>0){n._onImageHasSize(a);return}b>200&&clearInterval(L),b++,b===3?d(10):b===40?d(50):b===100&&d(500)},e)};d(1)},getImage:function(b,c){var d=0,e=function(){b&&(b.img[0].complete?(b.img.off(\".mfploader\"),b===n.currItem&&(n._onImageHasSize(b),n.updateStatus(\"ready\")),b.hasSize=!0,b.loaded=!0,y(\"ImageLoadComplete\")):(d++,d<200?setTimeout(e,100):f()))},f=function(){b&&(b.img.off(\".mfploader\"),b===n.currItem&&(n._onImageHasSize(b),n.updateStatus(\"error\",g.tError.replace(\"%url%\",b.src))),b.hasSize=!0,b.loaded=!0,b.loadError=!0)},g=n.st.image,h=c.find(\".mfp-img\");if(h.length){var i=document.createElement(\"img\");i.className=\"mfp-img\",b.el&&b.el.find(\"img\").length&&(i.alt=b.el.find(\"img\").attr(\"alt\")),b.img=a(i).on(\"load.mfploader\",e).on(\"error.mfploader\",f),i.src=b.src,h.is(\"img\")&&(b.img=b.img.clone()),i=b.img[0],i.naturalWidth>0?b.hasSize=!0:i.width||(b.hasSize=!1)}return n._parseMarkup(c,{title:M(b),img_replaceWith:b.img},b),n.resizeImage(),b.hasSize?(L&&clearInterval(L),b.loadError?(c.addClass(\"mfp-loading\"),n.updateStatus(\"error\",g.tError.replace(\"%url%\",b.src))):(c.removeClass(\"mfp-loading\"),n.updateStatus(\"ready\")),c):(n.updateStatus(\"loading\"),b.loading=!0,b.hasSize||(b.imgHidden=!0,c.addClass(\"mfp-loading\"),n.findImageSize(b)),c)}}});var N,O=function(){return N===undefined&&(N=document.createElement(\"p\").style.MozTransform!==undefined),N};a.magnificPopup.registerModule(\"zoom\",{options:{enabled:!1,easing:\"ease-in-out\",duration:300,opener:function(a){return a.is(\"img\")?a:a.find(\"img\")}},proto:{initZoom:function(){var a=n.st.zoom,d=\".zoom\",e;if(!a.enabled||!n.supportsTransition)return;var f=a.duration,g=function(b){var c=b.clone().removeAttr(\"style\").removeAttr(\"class\").addClass(\"mfp-animated-image\"),d=\"all \"+a.duration/1e3+\"s \"+a.easing,e={position:\"fixed\",zIndex:9999,left:0,top:0,\"-webkit-backface-visibility\":\"hidden\"},f=\"transition\";return e[\"-webkit-\"+f]=e[\"-moz-\"+f]=e[\"-o-\"+f]=e[f]=d,c.css(e),c},h=function(){n.content.css(\"visibility\",\"visible\")},i,j;w(\"BuildControls\"+d,function(){if(n._allowZoom()){clearTimeout(i),n.content.css(\"visibility\",\"hidden\"),e=n._getItemToZoom();if(!e){h();return}j=g(e),j.css(n._getOffset()),n.wrap.append(j),i=setTimeout(function(){j.css(n._getOffset(!0)),i=setTimeout(function(){h(),setTimeout(function(){j.remove(),e=j=null,y(\"ZoomAnimationEnded\")},16)},f)},16)}}),w(c+d,function(){if(n._allowZoom()){clearTimeout(i),n.st.removalDelay=f;if(!e){e=n._getItemToZoom();if(!e)return;j=g(e)}j.css(n._getOffset(!0)),n.wrap.append(j),n.content.css(\"visibility\",\"hidden\"),setTimeout(function(){j.css(n._getOffset())},16)}}),w(b+d,function(){n._allowZoom()&&(h(),j&&j.remove(),e=null)})},_allowZoom:function(){return n.currItem.type===\"image\"},_getItemToZoom:function(){return n.currItem.hasSize?n.currItem.img:!1},_getOffset:function(b){var c;b?c=n.currItem.img:c=n.st.zoom.opener(n.currItem.el||n.currItem);var d=c.offset(),e=parseInt(c.css(\"padding-top\"),10),f=parseInt(c.css(\"padding-bottom\"),10);d.top-=a(window).scrollTop()-e;var g={width:c.width(),height:(p?c.innerHeight():c[0].offsetHeight)-f-e};return O()?g[\"-moz-transform\"]=g.transform=\"translate(\"+d.left+\"px,\"+d.top+\"px)\":(g.left=d.left,g.top=d.top),g}}});var P=\"iframe\",Q=\"//about:blank\",R=function(a){if(n.currTemplate[P]){var b=n.currTemplate[P].find(\"iframe\");b.length&&(a||(b[0].src=Q),n.isIE8&&b.css(\"display\",a?\"block\":\"none\"))}};a.magnificPopup.registerModule(P,{options:{markup:'<div class=\"mfp-iframe-scaler\"><div class=\"mfp-close\"></div><iframe class=\"mfp-iframe\" src=\"//about:blank\" frameborder=\"0\" allowfullscreen></iframe></div>',srcAction:\"iframe_src\",patterns:{youtube:{index:\"youtube.com\",id:\"v=\",src:\"//www.youtube.com/embed/%id%?autoplay=1\"},vimeo:{index:\"vimeo.com/\",id:\"/\",src:\"//player.vimeo.com/video/%id%?autoplay=1\"},gmaps:{index:\"//maps.google.\",src:\"%id%&output=embed\"}}},proto:{initIframe:function(){n.types.push(P),w(\"BeforeChange\",function(a,b,c){b!==c&&(b===P?R():c===P&&R(!0))}),w(b+\".\"+P,function(){R()})},getIframe:function(b,c){var d=b.src,e=n.st.iframe;a.each(e.patterns,function(){if(d.indexOf(this.index)>-1)return this.id&&(typeof this.id==\"string\"?d=d.substr(d.lastIndexOf(this.id)+this.id.length,d.length):d=this.id.call(this,d)),d=this.src.replace(\"%id%\",d),!1});var f={};return e.srcAction&&(f[e.srcAction]=d),n._parseMarkup(c,f,b),n.updateStatus(\"ready\"),c}}});var S=function(a){var b=n.items.length;return a>b-1?a-b:a<0?b+a:a},T=function(a,b,c){return a.replace(/%curr%/gi,b+1).replace(/%total%/gi,c)};a.magnificPopup.registerModule(\"gallery\",{options:{enabled:!1,arrowMarkup:'<button title=\"%title%\" type=\"button\" class=\"mfp-arrow mfp-arrow-%dir%\"></button>',preload:[0,2],navigateByImgClick:!0,arrows:!0,tPrev:\"Previous (Left arrow key)\",tNext:\"Next (Right arrow key)\",tCounter:\"%curr% of %total%\"},proto:{initGallery:function(){var c=n.st.gallery,d=\".mfp-gallery\";n.direction=!0;if(!c||!c.enabled)return!1;u+=\" mfp-gallery\",w(g+d,function(){c.navigateByImgClick&&n.wrap.on(\"click\"+d,\".mfp-img\",function(){if(n.items.length>1)return n.next(),!1}),s.on(\"keydown\"+d,function(a){a.keyCode===37?n.prev():a.keyCode===39&&n.next()})}),w(\"UpdateStatus\"+d,function(a,b){b.text&&(b.text=T(b.text,n.currItem.index,n.items.length))}),w(f+d,function(a,b,d,e){var f=n.items.length;d.counter=f>1?T(c.tCounter,e.index,f):\"\"}),w(\"BuildControls\"+d,function(){if(n.items.length>1&&c.arrows&&!n.arrowLeft){var b=c.arrowMarkup,d=n.arrowLeft=a(b.replace(/%title%/gi,c.tPrev).replace(/%dir%/gi,\"left\")).addClass(m),e=n.arrowRight=a(b.replace(/%title%/gi,c.tNext).replace(/%dir%/gi,\"right\")).addClass(m);d.click(function(){n.prev()}),e.click(function(){n.next()}),n.container.append(d.add(e))}}),w(h+d,function(){n._preloadTimeout&&clearTimeout(n._preloadTimeout),n._preloadTimeout=setTimeout(function(){n.preloadNearbyImages(),n._preloadTimeout=null},16)}),w(b+d,function(){s.off(d),n.wrap.off(\"click\"+d),n.arrowRight=n.arrowLeft=null})},next:function(){n.direction=!0,n.index=S(n.index+1),n.updateItemHTML()},prev:function(){n.direction=!1,n.index=S(n.index-1),n.updateItemHTML()},goTo:function(a){n.direction=a>=n.index,n.index=a,n.updateItemHTML()},preloadNearbyImages:function(){var a=n.st.gallery.preload,b=Math.min(a[0],n.items.length),c=Math.min(a[1],n.items.length),d;for(d=1;d<=(n.direction?c:b);d++)n._preloadItem(n.index+d);for(d=1;d<=(n.direction?b:c);d++)n._preloadItem(n.index-d)},_preloadItem:function(b){b=S(b);if(n.items[b].preloaded)return;var c=n.items[b];c.parsed||(c=n.parseEl(b)),y(\"LazyLoad\",c),c.type===\"image\"&&(c.img=a('<img class=\"mfp-img\" />').on(\"load.mfploader\",function(){c.hasSize=!0}).on(\"error.mfploader\",function(){c.hasSize=!0,c.loadError=!0,y(\"LazyLoadError\",c)}).attr(\"src\",c.src)),c.preloaded=!0}}});var U=\"retina\";a.magnificPopup.registerModule(U,{options:{replaceSrc:function(a){return a.src.replace(/\\.\\w+$/,function(a){return\"@2x\"+a})},ratio:1},proto:{initRetina:function(){if(window.devicePixelRatio>1){var a=n.st.retina,b=a.ratio;b=isNaN(b)?b():b,b>1&&(w(\"ImageHasSize.\"+U,function(a,c){c.img.css({\"max-width\":c.img[0].naturalWidth/b,width:\"100%\"})}),w(\"ElementParse.\"+U,function(c,d){d.src=a.replaceSrc(d,b)}))}}}}),A()})","Mageplaza_Core/js/jquery.ui.touch-punch.min.js":"/*!\r\n * jQuery UI Touch Punch 0.2.3\r\n *\r\n * Copyright 2011\u20132014, Dave Furfero\r\n * Dual licensed under the MIT or GPL Version 2 licenses.\r\n *\r\n * Depends:\r\n *  jquery.ui.widget.js\r\n *  jquery.ui.mouse.js\r\n */\r\n!function(a){function f(a,b){if(!(a.originalEvent.touches.length>1)){a.preventDefault();var c=a.originalEvent.changedTouches[0],d=document.createEvent(\"MouseEvents\");d.initMouseEvent(b,!0,!0,window,1,c.screenX,c.screenY,c.clientX,c.clientY,!1,!1,!1,!1,0,null),a.target.dispatchEvent(d)}}if(a.support.touch=\"ontouchend\"in document,a.support.touch){var e,b=a.ui.mouse.prototype,c=b._mouseInit,d=b._mouseDestroy;b._touchStart=function(a){var b=this;!e&&b._mouseCapture(a.originalEvent.changedTouches[0])&&(e=!0,b._touchMoved=!1,f(a,\"mouseover\"),f(a,\"mousemove\"),f(a,\"mousedown\"))},b._touchMove=function(a){e&&(this._touchMoved=!0,f(a,\"mousemove\"))},b._touchEnd=function(a){e&&(f(a,\"mouseup\"),f(a,\"mouseout\"),this._touchMoved||f(a,\"click\"),e=!1)},b._mouseInit=function(){var b=this;b.element.bind({touchstart:a.proxy(b,\"_touchStart\"),touchmove:a.proxy(b,\"_touchMove\"),touchend:a.proxy(b,\"_touchEnd\")}),c.call(b)},b._mouseDestroy=function(){var b=this;b.element.unbind({touchstart:a.proxy(b,\"_touchStart\"),touchmove:a.proxy(b,\"_touchMove\"),touchend:a.proxy(b,\"_touchEnd\")}),d.call(b)}}}(jQuery);\r\n","Mageplaza_Core/js/jscolor.min.js":"/**\n * jscolor - JavaScript Color Picker\n *\n * @link    http://jscolor.com\n * @license For open source use: GPLv3\n *          For commercial use: JSColor Commercial License\n * @author  Jan Odvarko\n *\n * See usage examples at http://jscolor.com/examples/\n */\"use strict\";window.jscolor||(window.jscolor=function(){var e={register:function(){e.attachDOMReadyEvent(e.init),e.attachEvent(document,\"mousedown\",e.onDocumentMouseDown),e.attachEvent(document,\"touchstart\",e.onDocumentTouchStart),e.attachEvent(window,\"resize\",e.onWindowResize)},init:function(){e.jscolor.lookupClass&&e.jscolor.installByClassName(e.jscolor.lookupClass)},tryInstallOnElements:function(t,n){var r=new RegExp(\"(^|\\\\s)(\"+n+\")(\\\\s*(\\\\{[^}]*\\\\})|\\\\s|$)\",\"i\");for(var i=0;i<t.length;i+=1){if(t[i].type!==undefined&&t[i].type.toLowerCase()==\"color\"&&e.isColorAttrSupported)continue;var s;if(!t[i].jscolor&&t[i].className&&(s=t[i].className.match(r))){var o=t[i],u=null,a=e.getDataAttr(o,\"jscolor\");a!==null?u=a:s[4]&&(u=s[4]);var f={};if(u)try{f=(new Function(\"return (\"+u+\")\"))()}catch(l){e.warn(\"Error parsing jscolor options: \"+l+\":\\n\"+u)}o.jscolor=new e.jscolor(o,f)}}},isColorAttrSupported:function(){var e=document.createElement(\"input\");if(e.setAttribute){e.setAttribute(\"type\",\"color\");if(e.type.toLowerCase()==\"color\")return!0}return!1}(),isCanvasSupported:function(){var e=document.createElement(\"canvas\");return!!e.getContext&&!!e.getContext(\"2d\")}(),fetchElement:function(e){return typeof e==\"string\"?document.getElementById(e):e},isElementType:function(e,t){return e.nodeName.toLowerCase()===t.toLowerCase()},getDataAttr:function(e,t){var n=\"data-\"+t,r=e.getAttribute(n);return r!==null?r:null},attachEvent:function(e,t,n){e.addEventListener?e.addEventListener(t,n,!1):e.attachEvent&&e.attachEvent(\"on\"+t,n)},detachEvent:function(e,t,n){e.removeEventListener?e.removeEventListener(t,n,!1):e.detachEvent&&e.detachEvent(\"on\"+t,n)},_attachedGroupEvents:{},attachGroupEvent:function(t,n,r,i){e._attachedGroupEvents.hasOwnProperty(t)||(e._attachedGroupEvents[t]=[]),e._attachedGroupEvents[t].push([n,r,i]),e.attachEvent(n,r,i)},detachGroupEvents:function(t){if(e._attachedGroupEvents.hasOwnProperty(t)){for(var n=0;n<e._attachedGroupEvents[t].length;n+=1){var r=e._attachedGroupEvents[t][n];e.detachEvent(r[0],r[1],r[2])}delete e._attachedGroupEvents[t]}},attachDOMReadyEvent:function(e){var t=!1,n=function(){t||(t=!0,e())};if(document.readyState===\"complete\"){setTimeout(n,1);return}if(document.addEventListener)document.addEventListener(\"DOMContentLoaded\",n,!1),window.addEventListener(\"load\",n,!1);else if(document.attachEvent){document.attachEvent(\"onreadystatechange\",function(){document.readyState===\"complete\"&&(document.detachEvent(\"onreadystatechange\",arguments.callee),n())}),window.attachEvent(\"onload\",n);if(document.documentElement.doScroll&&window==window.top){var r=function(){if(!document.body)return;try{document.documentElement.doScroll(\"left\"),n()}catch(e){setTimeout(r,1)}};r()}}},warn:function(e){window.console&&window.console.warn&&window.console.warn(e)},preventDefault:function(e){e.preventDefault&&e.preventDefault(),e.returnValue=!1},captureTarget:function(t){t.setCapture&&(e._capturedTarget=t,e._capturedTarget.setCapture())},releaseTarget:function(){e._capturedTarget&&(e._capturedTarget.releaseCapture(),e._capturedTarget=null)},fireEvent:function(e,t){if(!e)return;if(document.createEvent){var n=document.createEvent(\"HTMLEvents\");n.initEvent(t,!0,!0),e.dispatchEvent(n)}else if(document.createEventObject){var n=document.createEventObject();e.fireEvent(\"on\"+t,n)}else e[\"on\"+t]&&e[\"on\"+t]()},classNameToList:function(e){return e.replace(/^\\s+|\\s+$/g,\"\").split(/\\s+/)},hasClass:function(e,t){return t?-1!=(\" \"+e.className.replace(/\\s+/g,\" \")+\" \").indexOf(\" \"+t+\" \"):!1},setClass:function(t,n){var r=e.classNameToList(n);for(var i=0;i<r.length;i+=1)e.hasClass(t,r[i])||(t.className+=(t.className?\" \":\"\")+r[i])},unsetClass:function(t,n){var r=e.classNameToList(n);for(var i=0;i<r.length;i+=1){var s=new RegExp(\"^\\\\s*\"+r[i]+\"\\\\s*|\"+\"\\\\s*\"+r[i]+\"\\\\s*$|\"+\"\\\\s+\"+r[i]+\"(\\\\s+)\",\"g\");t.className=t.className.replace(s,\"$1\")}},getStyle:function(e){return window.getComputedStyle?window.getComputedStyle(e):e.currentStyle},setStyle:function(){var e=document.createElement(\"div\"),t=function(t){for(var n=0;n<t.length;n+=1)if(t[n]in e.style)return t[n]},n={borderRadius:t([\"borderRadius\",\"MozBorderRadius\",\"webkitBorderRadius\"]),boxShadow:t([\"boxShadow\",\"MozBoxShadow\",\"webkitBoxShadow\"])};return function(e,t,r){switch(t.toLowerCase()){case\"opacity\":var i=Math.round(parseFloat(r)*100);e.style.opacity=r,e.style.filter=\"alpha(opacity=\"+i+\")\";break;default:e.style[n[t]]=r}}}(),setBorderRadius:function(t,n){e.setStyle(t,\"borderRadius\",n||\"0\")},setBoxShadow:function(t,n){e.setStyle(t,\"boxShadow\",n||\"none\")},getElementPos:function(t,n){var r=0,i=0,s=t.getBoundingClientRect();r=s.left,i=s.top;if(!n){var o=e.getViewPos();r+=o[0],i+=o[1]}return[r,i]},getElementSize:function(e){return[e.offsetWidth,e.offsetHeight]},getAbsPointerPos:function(e){e||(e=window.event);var t=0,n=0;return typeof e.changedTouches!=\"undefined\"&&e.changedTouches.length?(t=e.changedTouches[0].clientX,n=e.changedTouches[0].clientY):typeof e.clientX==\"number\"&&(t=e.clientX,n=e.clientY),{x:t,y:n}},getRelPointerPos:function(e){e||(e=window.event);var t=e.target||e.srcElement,n=t.getBoundingClientRect(),r=0,i=0,s=0,o=0;return typeof e.changedTouches!=\"undefined\"&&e.changedTouches.length?(s=e.changedTouches[0].clientX,o=e.changedTouches[0].clientY):typeof e.clientX==\"number\"&&(s=e.clientX,o=e.clientY),r=s-n.left,i=o-n.top,{x:r,y:i}},getViewPos:function(){var e=document.documentElement;return[(window.pageXOffset||e.scrollLeft)-(e.clientLeft||0),(window.pageYOffset||e.scrollTop)-(e.clientTop||0)]},getViewSize:function(){var e=document.documentElement;return[window.innerWidth||e.clientWidth,window.innerHeight||e.clientHeight]},redrawPosition:function(){if(e.picker&&e.picker.owner){var t=e.picker.owner,n,r;t.fixed?(n=e.getElementPos(t.targetElement,!0),r=[0,0]):(n=e.getElementPos(t.targetElement),r=e.getViewPos());var i=e.getElementSize(t.targetElement),s=e.getViewSize(),o=e.getPickerOuterDims(t),u,a,f;switch(t.position.toLowerCase()){case\"left\":u=1,a=0,f=-1;break;case\"right\":u=1,a=0,f=1;break;case\"top\":u=0,a=1,f=-1;break;default:u=0,a=1,f=1}var l=(i[a]+o[a])/2;if(!t.smartPosition)var c=[n[u],n[a]+i[a]-l+l*f];else var c=[-r[u]+n[u]+o[u]>s[u]?-r[u]+n[u]+i[u]/2>s[u]/2&&n[u]+i[u]-o[u]>=0?n[u]+i[u]-o[u]:n[u]:n[u],-r[a]+n[a]+i[a]+o[a]-l+l*f>s[a]?-r[a]+n[a]+i[a]/2>s[a]/2&&n[a]+i[a]-l-l*f>=0?n[a]+i[a]-l-l*f:n[a]+i[a]-l+l*f:n[a]+i[a]-l+l*f>=0?n[a]+i[a]-l+l*f:n[a]+i[a]-l-l*f];var h=c[u],p=c[a],d=t.fixed?\"fixed\":\"absolute\",v=(c[0]+o[0]>n[0]||c[0]<n[0]+i[0])&&c[1]+o[1]<n[1]+i[1];e._drawPosition(t,h,p,d,v)}},_drawPosition:function(t,n,r,i,s){var o=s?0:t.shadowBlur;e.picker.wrap.style.position=i,e.picker.wrap.style.left=n+\"px\",e.picker.wrap.style.top=r+\"px\",e.setBoxShadow(e.picker.boxS,t.shadow?new e.BoxShadow(0,o,t.shadowBlur,0,t.shadowColor):null)},getPickerDims:function(t){var n=!!e.getSliderComponent(t),r=[2*t.insetWidth+2*t.padding+t.width+(n?2*t.insetWidth+e.getPadToSliderPadding(t)+t.sliderSize:0),2*t.insetWidth+2*t.padding+t.height+(t.closable?2*t.insetWidth+t.padding+t.buttonHeight:0)];return r},getPickerOuterDims:function(t){var n=e.getPickerDims(t);return[n[0]+2*t.borderWidth,n[1]+2*t.borderWidth]},getPadToSliderPadding:function(e){return Math.max(e.padding,1.5*(2*e.pointerBorderWidth+e.pointerThickness))},getPadYComponent:function(e){switch(e.mode.charAt(1).toLowerCase()){case\"v\":return\"v\"}return\"s\"},getSliderComponent:function(e){if(e.mode.length>2)switch(e.mode.charAt(2).toLowerCase()){case\"s\":return\"s\";case\"v\":return\"v\"}return null},onDocumentMouseDown:function(t){t||(t=window.event);var n=t.target||t.srcElement;n._jscLinkedInstance?n._jscLinkedInstance.showOnClick&&n._jscLinkedInstance.show():n._jscControlName?e.onControlPointerStart(t,n,n._jscControlName,\"mouse\"):e.picker&&e.picker.owner&&e.picker.owner.hide()},onDocumentTouchStart:function(t){t||(t=window.event);var n=t.target||t.srcElement;n._jscLinkedInstance?n._jscLinkedInstance.showOnClick&&n._jscLinkedInstance.show():n._jscControlName?e.onControlPointerStart(t,n,n._jscControlName,\"touch\"):e.picker&&e.picker.owner&&e.picker.owner.hide()},onWindowResize:function(t){e.redrawPosition()},onParentScroll:function(t){e.picker&&e.picker.owner&&e.picker.owner.hide()},_pointerMoveEvent:{mouse:\"mousemove\",touch:\"touchmove\"},_pointerEndEvent:{mouse:\"mouseup\",touch:\"touchend\"},_pointerOrigin:null,_capturedTarget:null,onControlPointerStart:function(t,n,r,i){var s=n._jscInstance;e.preventDefault(t),e.captureTarget(n);var o=function(s,o){e.attachGroupEvent(\"drag\",s,e._pointerMoveEvent[i],e.onDocumentPointerMove(t,n,r,i,o)),e.attachGroupEvent(\"drag\",s,e._pointerEndEvent[i],e.onDocumentPointerEnd(t,n,r,i))};o(document,[0,0]);if(window.parent&&window.frameElement){var u=window.frameElement.getBoundingClientRect(),a=[-u.left,-u.top];o(window.parent.window.document,a)}var f=e.getAbsPointerPos(t),l=e.getRelPointerPos(t);e._pointerOrigin={x:f.x-l.x,y:f.y-l.y};switch(r){case\"pad\":switch(e.getSliderComponent(s)){case\"s\":s.hsv[1]===0&&s.fromHSV(null,100,null);break;case\"v\":s.hsv[2]===0&&s.fromHSV(null,null,100)}e.setPad(s,t,0,0);break;case\"sld\":e.setSld(s,t,0)}e.dispatchFineChange(s)},onDocumentPointerMove:function(t,n,r,i,s){return function(t){var i=n._jscInstance;switch(r){case\"pad\":t||(t=window.event),e.setPad(i,t,s[0],s[1]),e.dispatchFineChange(i);break;case\"sld\":t||(t=window.event),e.setSld(i,t,s[1]),e.dispatchFineChange(i)}}},onDocumentPointerEnd:function(t,n,r,i){return function(t){var r=n._jscInstance;e.detachGroupEvents(\"drag\"),e.releaseTarget(),e.dispatchChange(r)}},dispatchChange:function(t){t.valueElement&&e.isElementType(t.valueElement,\"input\")&&e.fireEvent(t.valueElement,\"change\")},dispatchFineChange:function(e){if(e.onFineChange){var t;typeof e.onFineChange==\"string\"?t=new Function(e.onFineChange):t=e.onFineChange,t.call(e)}},setPad:function(t,n,r,i){var s=e.getAbsPointerPos(n),o=r+s.x-e._pointerOrigin.x-t.padding-t.insetWidth,u=i+s.y-e._pointerOrigin.y-t.padding-t.insetWidth,a=o*(360/(t.width-1)),f=100-u*(100/(t.height-1));switch(e.getPadYComponent(t)){case\"s\":t.fromHSV(a,f,null,e.leaveSld);break;case\"v\":t.fromHSV(a,null,f,e.leaveSld)}},setSld:function(t,n,r){var i=e.getAbsPointerPos(n),s=r+i.y-e._pointerOrigin.y-t.padding-t.insetWidth,o=100-s*(100/(t.height-1));switch(e.getSliderComponent(t)){case\"s\":t.fromHSV(null,o,null,e.leavePad);break;case\"v\":t.fromHSV(null,null,o,e.leavePad)}},_vmlNS:\"jsc_vml_\",_vmlCSS:\"jsc_vml_css_\",_vmlReady:!1,initVML:function(){if(!e._vmlReady){var t=document;t.namespaces[e._vmlNS]||t.namespaces.add(e._vmlNS,\"urn:schemas-microsoft-com:vml\");if(!t.styleSheets[e._vmlCSS]){var n=[\"shape\",\"shapetype\",\"group\",\"background\",\"path\",\"formulas\",\"handles\",\"fill\",\"stroke\",\"shadow\",\"textbox\",\"textpath\",\"imagedata\",\"line\",\"polyline\",\"curve\",\"rect\",\"roundrect\",\"oval\",\"arc\",\"image\"],r=t.createStyleSheet();r.owningElement.id=e._vmlCSS;for(var i=0;i<n.length;i+=1)r.addRule(e._vmlNS+\"\\\\:\"+n[i],\"behavior:url(#default#VML);\")}e._vmlReady=!0}},createPalette:function(){var t={elm:null,draw:null};if(e.isCanvasSupported){var n=document.createElement(\"canvas\"),r=n.getContext(\"2d\"),i=function(e,t,i){n.width=e,n.height=t,r.clearRect(0,0,n.width,n.height);var s=r.createLinearGradient(0,0,n.width,0);s.addColorStop(0,\"#F00\"),s.addColorStop(1/6,\"#FF0\"),s.addColorStop(2/6,\"#0F0\"),s.addColorStop(.5,\"#0FF\"),s.addColorStop(4/6,\"#00F\"),s.addColorStop(5/6,\"#F0F\"),s.addColorStop(1,\"#F00\"),r.fillStyle=s,r.fillRect(0,0,n.width,n.height);var o=r.createLinearGradient(0,0,0,n.height);switch(i.toLowerCase()){case\"s\":o.addColorStop(0,\"rgba(255,255,255,0)\"),o.addColorStop(1,\"rgba(255,255,255,1)\");break;case\"v\":o.addColorStop(0,\"rgba(0,0,0,0)\"),o.addColorStop(1,\"rgba(0,0,0,1)\")}r.fillStyle=o,r.fillRect(0,0,n.width,n.height)};t.elm=n,t.draw=i}else{e.initVML();var s=document.createElement(\"div\");s.style.position=\"relative\",s.style.overflow=\"hidden\";var o=document.createElement(e._vmlNS+\":fill\");o.type=\"gradient\",o.method=\"linear\",o.angle=\"90\",o.colors=\"16.67% #F0F, 33.33% #00F, 50% #0FF, 66.67% #0F0, 83.33% #FF0\";var u=document.createElement(e._vmlNS+\":rect\");u.style.position=\"absolute\",u.style.left=\"-1px\",u.style.top=\"-1px\",u.stroked=!1,u.appendChild(o),s.appendChild(u);var a=document.createElement(e._vmlNS+\":fill\");a.type=\"gradient\",a.method=\"linear\",a.angle=\"180\",a.opacity=\"0\";var f=document.createElement(e._vmlNS+\":rect\");f.style.position=\"absolute\",f.style.left=\"-1px\",f.style.top=\"-1px\",f.stroked=!1,f.appendChild(a),s.appendChild(f);var i=function(e,t,n){s.style.width=e+\"px\",s.style.height=t+\"px\",u.style.width=f.style.width=e+1+\"px\",u.style.height=f.style.height=t+1+\"px\",o.color=\"#F00\",o.color2=\"#F00\";switch(n.toLowerCase()){case\"s\":a.color=a.color2=\"#FFF\";break;case\"v\":a.color=a.color2=\"#000\"}};t.elm=s,t.draw=i}return t},createSliderGradient:function(){var t={elm:null,draw:null};if(e.isCanvasSupported){var n=document.createElement(\"canvas\"),r=n.getContext(\"2d\"),i=function(e,t,i,s){n.width=e,n.height=t,r.clearRect(0,0,n.width,n.height);var o=r.createLinearGradient(0,0,0,n.height);o.addColorStop(0,i),o.addColorStop(1,s),r.fillStyle=o,r.fillRect(0,0,n.width,n.height)};t.elm=n,t.draw=i}else{e.initVML();var s=document.createElement(\"div\");s.style.position=\"relative\",s.style.overflow=\"hidden\";var o=document.createElement(e._vmlNS+\":fill\");o.type=\"gradient\",o.method=\"linear\",o.angle=\"180\";var u=document.createElement(e._vmlNS+\":rect\");u.style.position=\"absolute\",u.style.left=\"-1px\",u.style.top=\"-1px\",u.stroked=!1,u.appendChild(o),s.appendChild(u);var i=function(e,t,n,r){s.style.width=e+\"px\",s.style.height=t+\"px\",u.style.width=e+1+\"px\",u.style.height=t+1+\"px\",o.color=n,o.color2=r};t.elm=s,t.draw=i}return t},leaveValue:1,leaveStyle:2,leavePad:4,leaveSld:8,BoxShadow:function(){var e=function(e,t,n,r,i,s){this.hShadow=e,this.vShadow=t,this.blur=n,this.spread=r,this.color=i,this.inset=!!s};return e.prototype.toString=function(){var e=[Math.round(this.hShadow)+\"px\",Math.round(this.vShadow)+\"px\",Math.round(this.blur)+\"px\",Math.round(this.spread)+\"px\",this.color];return this.inset&&e.push(\"inset\"),e.join(\" \")},e}(),jscolor:function(t,n){function i(e,t,n){e/=255,t/=255,n/=255;var r=Math.min(Math.min(e,t),n),i=Math.max(Math.max(e,t),n),s=i-r;if(s===0)return[null,0,100*i];var o=e===r?3+(n-t)/s:t===r?5+(e-n)/s:1+(t-e)/s;return[60*(o===6?0:o),100*(s/i),100*i]}function s(e,t,n){var r=255*(n/100);if(e===null)return[r,r,r];e/=60,t/=100;var i=Math.floor(e),s=i%2?e-i:1-(e-i),o=r*(1-t),u=r*(1-t*s);switch(i){case 6:case 0:return[r,u,o];case 1:return[u,r,o];case 2:return[o,r,u];case 3:return[o,u,r];case 4:return[u,o,r];case 5:return[r,o,u]}}function o(){e.unsetClass(d.targetElement,d.activeClass),e.picker.wrap.parentNode.removeChild(e.picker.wrap),delete e.picker.owner}function u(){function l(){var e=d.insetColor.split(/\\s+/),n=e.length<2?e[0]:e[1]+\" \"+e[0]+\" \"+e[0]+\" \"+e[1];t.btn.style.borderColor=n}d._processParentElementsInDOM(),e.picker||(e.picker={owner:null,wrap:document.createElement(\"div\"),box:document.createElement(\"div\"),boxS:document.createElement(\"div\"),boxB:document.createElement(\"div\"),pad:document.createElement(\"div\"),padB:document.createElement(\"div\"),padM:document.createElement(\"div\"),padPal:e.createPalette(),cross:document.createElement(\"div\"),crossBY:document.createElement(\"div\"),crossBX:document.createElement(\"div\"),crossLY:document.createElement(\"div\"),crossLX:document.createElement(\"div\"),sld:document.createElement(\"div\"),sldB:document.createElement(\"div\"),sldM:document.createElement(\"div\"),sldGrad:e.createSliderGradient(),sldPtrS:document.createElement(\"div\"),sldPtrIB:document.createElement(\"div\"),sldPtrMB:document.createElement(\"div\"),sldPtrOB:document.createElement(\"div\"),btn:document.createElement(\"div\"),btnT:document.createElement(\"span\")},e.picker.pad.appendChild(e.picker.padPal.elm),e.picker.padB.appendChild(e.picker.pad),e.picker.cross.appendChild(e.picker.crossBY),e.picker.cross.appendChild(e.picker.crossBX),e.picker.cross.appendChild(e.picker.crossLY),e.picker.cross.appendChild(e.picker.crossLX),e.picker.padB.appendChild(e.picker.cross),e.picker.box.appendChild(e.picker.padB),e.picker.box.appendChild(e.picker.padM),e.picker.sld.appendChild(e.picker.sldGrad.elm),e.picker.sldB.appendChild(e.picker.sld),e.picker.sldB.appendChild(e.picker.sldPtrOB),e.picker.sldPtrOB.appendChild(e.picker.sldPtrMB),e.picker.sldPtrMB.appendChild(e.picker.sldPtrIB),e.picker.sldPtrIB.appendChild(e.picker.sldPtrS),e.picker.box.appendChild(e.picker.sldB),e.picker.box.appendChild(e.picker.sldM),e.picker.btn.appendChild(e.picker.btnT),e.picker.box.appendChild(e.picker.btn),e.picker.boxB.appendChild(e.picker.box),e.picker.wrap.appendChild(e.picker.boxS),e.picker.wrap.appendChild(e.picker.boxB));var t=e.picker,n=!!e.getSliderComponent(d),r=e.getPickerDims(d),i=2*d.pointerBorderWidth+d.pointerThickness+2*d.crossSize,s=e.getPadToSliderPadding(d),o=Math.min(d.borderRadius,Math.round(d.padding*Math.PI)),u=\"crosshair\";t.wrap.style.clear=\"both\",t.wrap.style.width=r[0]+2*d.borderWidth+\"px\",t.wrap.style.height=r[1]+2*d.borderWidth+\"px\",t.wrap.style.zIndex=d.zIndex,t.box.style.width=r[0]+\"px\",t.box.style.height=r[1]+\"px\",t.boxS.style.position=\"absolute\",t.boxS.style.left=\"0\",t.boxS.style.top=\"0\",t.boxS.style.width=\"100%\",t.boxS.style.height=\"100%\",e.setBorderRadius(t.boxS,o+\"px\"),t.boxB.style.position=\"relative\",t.boxB.style.border=d.borderWidth+\"px solid\",t.boxB.style.borderColor=d.borderColor,t.boxB.style.background=d.backgroundColor,e.setBorderRadius(t.boxB,o+\"px\"),t.padM.style.background=t.sldM.style.background=\"#FFF\",e.setStyle(t.padM,\"opacity\",\"0\"),e.setStyle(t.sldM,\"opacity\",\"0\"),t.pad.style.position=\"relative\",t.pad.style.width=d.width+\"px\",t.pad.style.height=d.height+\"px\",t.padPal.draw(d.width,d.height,e.getPadYComponent(d)),t.padB.style.position=\"absolute\",t.padB.style.left=d.padding+\"px\",t.padB.style.top=d.padding+\"px\",t.padB.style.border=d.insetWidth+\"px solid\",t.padB.style.borderColor=d.insetColor,t.padM._jscInstance=d,t.padM._jscControlName=\"pad\",t.padM.style.position=\"absolute\",t.padM.style.left=\"0\",t.padM.style.top=\"0\",t.padM.style.width=d.padding+2*d.insetWidth+d.width+s/2+\"px\",t.padM.style.height=r[1]+\"px\",t.padM.style.cursor=u,t.cross.style.position=\"absolute\",t.cross.style.left=t.cross.style.top=\"0\",t.cross.style.width=t.cross.style.height=i+\"px\",t.crossBY.style.position=t.crossBX.style.position=\"absolute\",t.crossBY.style.background=t.crossBX.style.background=d.pointerBorderColor,t.crossBY.style.width=t.crossBX.style.height=2*d.pointerBorderWidth+d.pointerThickness+\"px\",t.crossBY.style.height=t.crossBX.style.width=i+\"px\",t.crossBY.style.left=t.crossBX.style.top=Math.floor(i/2)-Math.floor(d.pointerThickness/2)-d.pointerBorderWidth+\"px\",t.crossBY.style.top=t.crossBX.style.left=\"0\",t.crossLY.style.position=t.crossLX.style.position=\"absolute\",t.crossLY.style.background=t.crossLX.style.background=d.pointerColor,t.crossLY.style.height=t.crossLX.style.width=i-2*d.pointerBorderWidth+\"px\",t.crossLY.style.width=t.crossLX.style.height=d.pointerThickness+\"px\",t.crossLY.style.left=t.crossLX.style.top=Math.floor(i/2)-Math.floor(d.pointerThickness/2)+\"px\",t.crossLY.style.top=t.crossLX.style.left=d.pointerBorderWidth+\"px\",t.sld.style.overflow=\"hidden\",t.sld.style.width=d.sliderSize+\"px\",t.sld.style.height=d.height+\"px\",t.sldGrad.draw(d.sliderSize,d.height,\"#000\",\"#000\"),t.sldB.style.display=n?\"block\":\"none\",t.sldB.style.position=\"absolute\",t.sldB.style.right=d.padding+\"px\",t.sldB.style.top=d.padding+\"px\",t.sldB.style.border=d.insetWidth+\"px solid\",t.sldB.style.borderColor=d.insetColor,t.sldM._jscInstance=d,t.sldM._jscControlName=\"sld\",t.sldM.style.display=n?\"block\":\"none\",t.sldM.style.position=\"absolute\",t.sldM.style.right=\"0\",t.sldM.style.top=\"0\",t.sldM.style.width=d.sliderSize+s/2+d.padding+2*d.insetWidth+\"px\",t.sldM.style.height=r[1]+\"px\",t.sldM.style.cursor=\"default\",t.sldPtrIB.style.border=t.sldPtrOB.style.border=d.pointerBorderWidth+\"px solid \"+d.pointerBorderColor,t.sldPtrOB.style.position=\"absolute\",t.sldPtrOB.style.left=-(2*d.pointerBorderWidth+d.pointerThickness)+\"px\",t.sldPtrOB.style.top=\"0\",t.sldPtrMB.style.border=d.pointerThickness+\"px solid \"+d.pointerColor,t.sldPtrS.style.width=d.sliderSize+\"px\",t.sldPtrS.style.height=m+\"px\",t.btn.style.display=d.closable?\"block\":\"none\",t.btn.style.position=\"absolute\",t.btn.style.left=d.padding+\"px\",t.btn.style.bottom=d.padding+\"px\",t.btn.style.padding=\"0 15px\",t.btn.style.height=d.buttonHeight+\"px\",t.btn.style.border=d.insetWidth+\"px solid\",l(),t.btn.style.color=d.buttonColor,t.btn.style.font=\"12px sans-serif\",t.btn.style.textAlign=\"center\";try{t.btn.style.cursor=\"pointer\"}catch(c){t.btn.style.cursor=\"hand\"}t.btn.onmousedown=function(){d.hide()},t.btnT.style.lineHeight=d.buttonHeight+\"px\",t.btnT.innerHTML=\"\",t.btnT.appendChild(document.createTextNode(d.closeText)),a(),f(),e.picker.owner&&e.picker.owner!==d&&e.unsetClass(e.picker.owner.targetElement,d.activeClass),e.picker.owner=d,e.isElementType(v,\"body\")?e.redrawPosition():e._drawPosition(d,0,0,\"relative\",!1),t.wrap.parentNode!=v&&v.appendChild(t.wrap),e.setClass(d.targetElement,d.activeClass)}function a(){switch(e.getPadYComponent(d)){case\"s\":var t=1;break;case\"v\":var t=2}var n=Math.round(d.hsv[0]/360*(d.width-1)),r=Math.round((1-d.hsv[t]/100)*(d.height-1)),i=2*d.pointerBorderWidth+d.pointerThickness+2*d.crossSize,o=-Math.floor(i/2);e.picker.cross.style.left=n+o+\"px\",e.picker.cross.style.top=r+o+\"px\";switch(e.getSliderComponent(d)){case\"s\":var u=s(d.hsv[0],100,d.hsv[2]),a=s(d.hsv[0],0,d.hsv[2]),f=\"rgb(\"+Math.round(u[0])+\",\"+Math.round(u[1])+\",\"+Math.round(u[2])+\")\",l=\"rgb(\"+Math.round(a[0])+\",\"+Math.round(a[1])+\",\"+Math.round(a[2])+\")\";e.picker.sldGrad.draw(d.sliderSize,d.height,f,l);break;case\"v\":var c=s(d.hsv[0],d.hsv[1],100),f=\"rgb(\"+Math.round(c[0])+\",\"+Math.round(c[1])+\",\"+Math.round(c[2])+\")\",l=\"#000\";e.picker.sldGrad.draw(d.sliderSize,d.height,f,l)}}function f(){var t=e.getSliderComponent(d);if(t){switch(t){case\"s\":var n=1;break;case\"v\":var n=2}var r=Math.round((1-d.hsv[n]/100)*(d.height-1));e.picker.sldPtrOB.style.top=r-(2*d.pointerBorderWidth+d.pointerThickness)-Math.floor(m/2)+\"px\"}}function l(){return e.picker&&e.picker.owner===d}function c(){d.importColor()}this.value=null,this.valueElement=t,this.styleElement=t,this.required=!0,this.refine=!0,this.hash=!1,this.uppercase=!0,this.onFineChange=null,this.activeClass=\"jscolor-active\",this.minS=0,this.maxS=100,this.minV=0,this.maxV=100,this.hsv=[0,0,100],this.rgb=[255,255,255],this.width=181,this.height=101,this.showOnClick=!0,this.mode=\"HSV\",this.position=\"bottom\",this.smartPosition=!0,this.sliderSize=16,this.crossSize=8,this.closable=!1,this.closeText=\"Close\",this.buttonColor=\"#000000\",this.buttonHeight=18,this.padding=12,this.backgroundColor=\"#FFFFFF\",this.borderWidth=1,this.borderColor=\"#BBBBBB\",this.borderRadius=8,this.insetWidth=1,this.insetColor=\"#BBBBBB\",this.shadow=!0,this.shadowBlur=15,this.shadowColor=\"rgba(0,0,0,0.2)\",this.pointerColor=\"#4C4C4C\",this.pointerBorderColor=\"#FFFFFF\",this.pointerBorderWidth=1,this.pointerThickness=2,this.zIndex=1e3,this.container=null;for(var r in n)n.hasOwnProperty(r)&&(this[r]=n[r]);this.hide=function(){l()&&o()},this.show=function(){u()},this.redraw=function(){l()&&u()},this.importColor=function(){this.valueElement?e.isElementType(this.valueElement,\"input\")?this.refine?!this.required&&/^\\s*$/.test(this.valueElement.value)?(this.valueElement.value=\"\",this.styleElement&&(this.styleElement.style.backgroundImage=this.styleElement._jscOrigStyle.backgroundImage,this.styleElement.style.backgroundColor=this.styleElement._jscOrigStyle.backgroundColor,this.styleElement.style.color=this.styleElement._jscOrigStyle.color),this.exportColor(e.leaveValue|e.leaveStyle)):this.fromString(this.valueElement.value)||this.exportColor():this.fromString(this.valueElement.value,e.leaveValue)||(this.styleElement&&(this.styleElement.style.backgroundImage=this.styleElement._jscOrigStyle.backgroundImage,this.styleElement.style.backgroundColor=this.styleElement._jscOrigStyle.backgroundColor,this.styleElement.style.color=this.styleElement._jscOrigStyle.color),this.exportColor(e.leaveValue|e.leaveStyle)):this.exportColor():this.exportColor()},this.exportColor=function(t){if(!(t&e.leaveValue)&&this.valueElement){var n=this.toString();this.uppercase&&(n=n.toUpperCase()),this.hash&&(n=\"#\"+n),e.isElementType(this.valueElement,\"input\")?this.valueElement.value=n:this.valueElement.innerHTML=n}t&e.leaveStyle||this.styleElement&&(this.styleElement.style.backgroundImage=\"none\",this.styleElement.style.backgroundColor=\"#\"+this.toString(),this.styleElement.style.color=this.isLight()?\"#000\":\"#FFF\"),!(t&e.leavePad)&&l()&&a(),!(t&e.leaveSld)&&l()&&f()},this.fromHSV=function(e,t,n,r){if(e!==null){if(isNaN(e))return!1;e=Math.max(0,Math.min(360,e))}if(t!==null){if(isNaN(t))return!1;t=Math.max(0,Math.min(100,this.maxS,t),this.minS)}if(n!==null){if(isNaN(n))return!1;n=Math.max(0,Math.min(100,this.maxV,n),this.minV)}this.rgb=s(e===null?this.hsv[0]:this.hsv[0]=e,t===null?this.hsv[1]:this.hsv[1]=t,n===null?this.hsv[2]:this.hsv[2]=n),this.exportColor(r)},this.fromRGB=function(e,t,n,r){if(e!==null){if(isNaN(e))return!1;e=Math.max(0,Math.min(255,e))}if(t!==null){if(isNaN(t))return!1;t=Math.max(0,Math.min(255,t))}if(n!==null){if(isNaN(n))return!1;n=Math.max(0,Math.min(255,n))}var o=i(e===null?this.rgb[0]:e,t===null?this.rgb[1]:t,n===null?this.rgb[2]:n);o[0]!==null&&(this.hsv[0]=Math.max(0,Math.min(360,o[0]))),o[2]!==0&&(this.hsv[1]=o[1]===null?null:Math.max(0,this.minS,Math.min(100,this.maxS,o[1]))),this.hsv[2]=o[2]===null?null:Math.max(0,this.minV,Math.min(100,this.maxV,o[2]));var u=s(this.hsv[0],this.hsv[1],this.hsv[2]);this.rgb[0]=u[0],this.rgb[1]=u[1],this.rgb[2]=u[2],this.exportColor(r)},this.fromString=function(e,t){var n;if(n=e.match(/^\\W*([0-9A-F]{3}([0-9A-F]{3})?)\\W*$/i))return n[1].length===6?this.fromRGB(parseInt(n[1].substr(0,2),16),parseInt(n[1].substr(2,2),16),parseInt(n[1].substr(4,2),16),t):this.fromRGB(parseInt(n[1].charAt(0)+n[1].charAt(0),16),parseInt(n[1].charAt(1)+n[1].charAt(1),16),parseInt(n[1].charAt(2)+n[1].charAt(2),16),t),!0;if(n=e.match(/^\\W*rgba?\\(([^)]*)\\)\\W*$/i)){var r=n[1].split(\",\"),i=/^\\s*(\\d*)(\\.\\d+)?\\s*$/,s,o,u;if(r.length>=3&&(s=r[0].match(i))&&(o=r[1].match(i))&&(u=r[2].match(i))){var a=parseFloat((s[1]||\"0\")+(s[2]||\"\")),f=parseFloat((o[1]||\"0\")+(o[2]||\"\")),l=parseFloat((u[1]||\"0\")+(u[2]||\"\"));return this.fromRGB(a,f,l,t),!0}}return!1},this.toString=function(){return(256|Math.round(this.rgb[0])).toString(16).substr(1)+(256|Math.round(this.rgb[1])).toString(16).substr(1)+(256|Math.round(this.rgb[2])).toString(16).substr(1)},this.toHEXString=function(){return\"#\"+this.toString().toUpperCase()},this.toRGBString=function(){return\"rgb(\"+Math.round(this.rgb[0])+\",\"+Math.round(this.rgb[1])+\",\"+Math.round(this.rgb[2])+\")\"},this.isLight=function(){return.213*this.rgb[0]+.715*this.rgb[1]+.072*this.rgb[2]>127.5},this._processParentElementsInDOM=function(){if(this._linkedElementsProcessed)return;this._linkedElementsProcessed=!0;var t=this.targetElement;do{var n=e.getStyle(t);n&&n.position.toLowerCase()===\"fixed\"&&(this.fixed=!0),t!==this.targetElement&&(t._jscEventsAttached||(e.attachEvent(t,\"scroll\",e.onParentScroll),t._jscEventsAttached=!0))}while((t=t.parentNode)&&!e.isElementType(t,\"body\"))};if(typeof t==\"string\"){var h=t,p=document.getElementById(h);p?this.targetElement=p:e.warn(\"Could not find target element with ID '\"+h+\"'\")}else t?this.targetElement=t:e.warn(\"Invalid target element: '\"+t+\"'\");if(this.targetElement._jscLinkedInstance){e.warn(\"Cannot link jscolor twice to the same element. Skipping.\");return}this.targetElement._jscLinkedInstance=this,this.valueElement=e.fetchElement(this.valueElement),this.styleElement=e.fetchElement(this.styleElement);var d=this,v=this.container?e.fetchElement(this.container):document.getElementsByTagName(\"body\")[0],m=3;if(e.isElementType(this.targetElement,\"button\"))if(this.targetElement.onclick){var g=this.targetElement.onclick;this.targetElement.onclick=function(e){return g.call(this,e),!1}}else this.targetElement.onclick=function(){return!1};if(this.valueElement&&e.isElementType(this.valueElement,\"input\")){var y=function(){d.fromString(d.valueElement.value,e.leaveValue),e.dispatchFineChange(d)};e.attachEvent(this.valueElement,\"keyup\",y),e.attachEvent(this.valueElement,\"input\",y),e.attachEvent(this.valueElement,\"blur\",c),this.valueElement.setAttribute(\"autocomplete\",\"off\")}this.styleElement&&(this.styleElement._jscOrigStyle={backgroundImage:this.styleElement.style.backgroundImage,backgroundColor:this.styleElement.style.backgroundColor,color:this.styleElement.style.color}),this.value?this.fromString(this.value)||this.exportColor():this.importColor()}};return e.jscolor.lookupClass=\"jscolor\",e.jscolor.installByClassName=function(t){var n=document.getElementsByTagName(\"input\"),r=document.getElementsByTagName(\"button\");e.tryInstallOnElements(n,t),e.tryInstallOnElements(r,t)},e.register(),e.jscolor}());","Mageplaza_Core/js/owl.carousel.min.js":"/**\r\n * Owl Carousel v2.3.4\r\n * Copyright 2013-2018 David Deutsch\r\n * Licensed under: SEE LICENSE IN https://github.com/OwlCarousel2/OwlCarousel2/blob/master/LICENSE\r\n */\r\n!function(a,b,c,d){function e(b,c){this.settings=null,this.options=a.extend({},e.Defaults,c),this.$element=a(b),this._handlers={},this._plugins={},this._supress={},this._current=null,this._speed=null,this._coordinates=[],this._breakpoint=null,this._width=null,this._items=[],this._clones=[],this._mergers=[],this._widths=[],this._invalidated={},this._pipe=[],this._drag={time:null,target:null,pointer:null,stage:{start:null,current:null},direction:null},this._states={current:{},tags:{initializing:[\"busy\"],animating:[\"busy\"],dragging:[\"interacting\"]}},a.each([\"onResize\",\"onThrottledResize\"],a.proxy(function(b,c){this._handlers[c]=a.proxy(this[c],this)},this)),a.each(e.Plugins,a.proxy(function(a,b){this._plugins[a.charAt(0).toLowerCase()+a.slice(1)]=new b(this)},this)),a.each(e.Workers,a.proxy(function(b,c){this._pipe.push({filter:c.filter,run:a.proxy(c.run,this)})},this)),this.setup(),this.initialize()}e.Defaults={items:3,loop:!1,center:!1,rewind:!1,checkVisibility:!0,mouseDrag:!0,touchDrag:!0,pullDrag:!0,freeDrag:!1,margin:0,stagePadding:0,merge:!1,mergeFit:!0,autoWidth:!1,startPosition:0,rtl:!1,smartSpeed:250,fluidSpeed:!1,dragEndSpeed:!1,responsive:{},responsiveRefreshRate:200,responsiveBaseElement:b,fallbackEasing:\"swing\",slideTransition:\"\",info:!1,nestedItemSelector:!1,itemElement:\"div\",stageElement:\"div\",refreshClass:\"owl-refresh\",loadedClass:\"owl-loaded\",loadingClass:\"owl-loading\",rtlClass:\"owl-rtl\",responsiveClass:\"owl-responsive\",dragClass:\"owl-drag\",itemClass:\"owl-item\",stageClass:\"owl-stage\",stageOuterClass:\"owl-stage-outer\",grabClass:\"owl-grab\"},e.Width={Default:\"default\",Inner:\"inner\",Outer:\"outer\"},e.Type={Event:\"event\",State:\"state\"},e.Plugins={},e.Workers=[{filter:[\"width\",\"settings\"],run:function(){this._width=this.$element.width()}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){a.current=this._items&&this._items[this.relative(this._current)]}},{filter:[\"items\",\"settings\"],run:function(){this.$stage.children(\".cloned\").remove()}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){var b=this.settings.margin||\"\",c=!this.settings.autoWidth,d=this.settings.rtl,e={width:\"auto\",\"margin-left\":d?b:\"\",\"margin-right\":d?\"\":b};!c&&this.$stage.children().css(e),a.css=e}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){var b=(this.width()/this.settings.items).toFixed(3)-this.settings.margin,c=null,d=this._items.length,e=!this.settings.autoWidth,f=[];for(a.items={merge:!1,width:b};d--;)c=this._mergers[d],c=this.settings.mergeFit&&Math.min(c,this.settings.items)||c,a.items.merge=c>1||a.items.merge,f[d]=e?b*c:this._items[d].width();this._widths=f}},{filter:[\"items\",\"settings\"],run:function(){var b=[],c=this._items,d=this.settings,e=Math.max(2*d.items,4),f=2*Math.ceil(c.length/2),g=d.loop&&c.length?d.rewind?e:Math.max(e,f):0,h=\"\",i=\"\";for(g/=2;g>0;)b.push(this.normalize(b.length/2,!0)),h+=c[b[b.length-1]][0].outerHTML,b.push(this.normalize(c.length-1-(b.length-1)/2,!0)),i=c[b[b.length-1]][0].outerHTML+i,g-=1;this._clones=b,a(h).addClass(\"cloned\").appendTo(this.$stage),a(i).addClass(\"cloned\").prependTo(this.$stage)}},{filter:[\"width\",\"items\",\"settings\"],run:function(){for(var a=this.settings.rtl?1:-1,b=this._clones.length+this._items.length,c=-1,d=0,e=0,f=[];++c<b;)d=f[c-1]||0,e=this._widths[this.relative(c)]+this.settings.margin,f.push(d+e*a);this._coordinates=f}},{filter:[\"width\",\"items\",\"settings\"],run:function(){var a=this.settings.stagePadding,b=this._coordinates,c={width:Math.ceil(Math.abs(b[b.length-1]))+2*a,\"padding-left\":a||\"\",\"padding-right\":a||\"\"};this.$stage.css(c)}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){var b=this._coordinates.length,c=!this.settings.autoWidth,d=this.$stage.children();if(c&&a.items.merge)for(;b--;)a.css.width=this._widths[this.relative(b)],d.eq(b).css(a.css);else c&&(a.css.width=a.items.width,d.css(a.css))}},{filter:[\"items\"],run:function(){this._coordinates.length<1&&this.$stage.removeAttr(\"style\")}},{filter:[\"width\",\"items\",\"settings\"],run:function(a){a.current=a.current?this.$stage.children().index(a.current):0,a.current=Math.max(this.minimum(),Math.min(this.maximum(),a.current)),this.reset(a.current)}},{filter:[\"position\"],run:function(){this.animate(this.coordinates(this._current))}},{filter:[\"width\",\"position\",\"items\",\"settings\"],run:function(){var a,b,c,d,e=this.settings.rtl?1:-1,f=2*this.settings.stagePadding,g=this.coordinates(this.current())+f,h=g+this.width()*e,i=[];for(c=0,d=this._coordinates.length;c<d;c++)a=this._coordinates[c-1]||0,b=Math.abs(this._coordinates[c])+f*e,(this.op(a,\"<=\",g)&&this.op(a,\">\",h)||this.op(b,\"<\",g)&&this.op(b,\">\",h))&&i.push(c);this.$stage.children(\".active\").removeClass(\"active\"),this.$stage.children(\":eq(\"+i.join(\"), :eq(\")+\")\").addClass(\"active\"),this.$stage.children(\".center\").removeClass(\"center\"),this.settings.center&&this.$stage.children().eq(this.current()).addClass(\"center\")}}],e.prototype.initializeStage=function(){this.$stage=this.$element.find(\".\"+this.settings.stageClass),this.$stage.length||(this.$element.addClass(this.options.loadingClass),this.$stage=a(\"<\"+this.settings.stageElement+\">\",{class:this.settings.stageClass}).wrap(a(\"<div/>\",{class:this.settings.stageOuterClass})),this.$element.append(this.$stage.parent()))},e.prototype.initializeItems=function(){var b=this.$element.find(\".owl-item\");if(b.length)return this._items=b.get().map(function(b){return a(b)}),this._mergers=this._items.map(function(){return 1}),void this.refresh();this.replace(this.$element.children().not(this.$stage.parent())),this.isVisible()?this.refresh():this.invalidate(\"width\"),this.$element.removeClass(this.options.loadingClass).addClass(this.options.loadedClass)},e.prototype.initialize=function(){if(this.enter(\"initializing\"),this.trigger(\"initialize\"),this.$element.toggleClass(this.settings.rtlClass,this.settings.rtl),this.settings.autoWidth&&!this.is(\"pre-loading\")){var a,b,c;a=this.$element.find(\"img\"),b=this.settings.nestedItemSelector?\".\"+this.settings.nestedItemSelector:d,c=this.$element.children(b).width(),a.length&&c<=0&&this.preloadAutoWidthImages(a)}this.initializeStage(),this.initializeItems(),this.registerEventHandlers(),this.leave(\"initializing\"),this.trigger(\"initialized\")},e.prototype.isVisible=function(){return!this.settings.checkVisibility||this.$element.is(\":visible\")},e.prototype.setup=function(){var b=this.viewport(),c=this.options.responsive,d=-1,e=null;c?(a.each(c,function(a){a<=b&&a>d&&(d=Number(a))}),e=a.extend({},this.options,c[d]),\"function\"==typeof e.stagePadding&&(e.stagePadding=e.stagePadding()),delete e.responsive,e.responsiveClass&&this.$element.attr(\"class\",this.$element.attr(\"class\").replace(new RegExp(\"(\"+this.options.responsiveClass+\"-)\\\\S+\\\\s\",\"g\"),\"$1\"+d))):e=a.extend({},this.options),this.trigger(\"change\",{property:{name:\"settings\",value:e}}),this._breakpoint=d,this.settings=e,this.invalidate(\"settings\"),this.trigger(\"changed\",{property:{name:\"settings\",value:this.settings}})},e.prototype.optionsLogic=function(){this.settings.autoWidth&&(this.settings.stagePadding=!1,this.settings.merge=!1)},e.prototype.prepare=function(b){var c=this.trigger(\"prepare\",{content:b});return c.data||(c.data=a(\"<\"+this.settings.itemElement+\"/>\").addClass(this.options.itemClass).append(b)),this.trigger(\"prepared\",{content:c.data}),c.data},e.prototype.update=function(){for(var b=0,c=this._pipe.length,d=a.proxy(function(a){return this[a]},this._invalidated),e={};b<c;)(this._invalidated.all||a.grep(this._pipe[b].filter,d).length>0)&&this._pipe[b].run(e),b++;this._invalidated={},!this.is(\"valid\")&&this.enter(\"valid\")},e.prototype.width=function(a){switch(a=a||e.Width.Default){case e.Width.Inner:case e.Width.Outer:return this._width;default:return this._width-2*this.settings.stagePadding+this.settings.margin}},e.prototype.refresh=function(){this.enter(\"refreshing\"),this.trigger(\"refresh\"),this.setup(),this.optionsLogic(),this.$element.addClass(this.options.refreshClass),this.update(),this.$element.removeClass(this.options.refreshClass),this.leave(\"refreshing\"),this.trigger(\"refreshed\")},e.prototype.onThrottledResize=function(){b.clearTimeout(this.resizeTimer),this.resizeTimer=b.setTimeout(this._handlers.onResize,this.settings.responsiveRefreshRate)},e.prototype.onResize=function(){return!!this._items.length&&(this._width!==this.$element.width()&&(!!this.isVisible()&&(this.enter(\"resizing\"),this.trigger(\"resize\").isDefaultPrevented()?(this.leave(\"resizing\"),!1):(this.invalidate(\"width\"),this.refresh(),this.leave(\"resizing\"),void this.trigger(\"resized\")))))},e.prototype.registerEventHandlers=function(){a.support.transition&&this.$stage.on(a.support.transition.end+\".owl.core\",a.proxy(this.onTransitionEnd,this)),!1!==this.settings.responsive&&this.on(b,\"resize\",this._handlers.onThrottledResize),this.settings.mouseDrag&&(this.$element.addClass(this.options.dragClass),this.$stage.on(\"mousedown.owl.core\",a.proxy(this.onDragStart,this)),this.$stage.on(\"dragstart.owl.core selectstart.owl.core\",function(){return!1})),this.settings.touchDrag&&(this.$stage.on(\"touchstart.owl.core\",a.proxy(this.onDragStart,this)),this.$stage.on(\"touchcancel.owl.core\",a.proxy(this.onDragEnd,this)))},e.prototype.onDragStart=function(b){var d=null;3!==b.which&&(a.support.transform?(d=this.$stage.css(\"transform\").replace(/.*\\(|\\)| /g,\"\").split(\",\"),d={x:d[16===d.length?12:4],y:d[16===d.length?13:5]}):(d=this.$stage.position(),d={x:this.settings.rtl?d.left+this.$stage.width()-this.width()+this.settings.margin:d.left,y:d.top}),this.is(\"animating\")&&(a.support.transform?this.animate(d.x):this.$stage.stop(),this.invalidate(\"position\")),this.$element.toggleClass(this.options.grabClass,\"mousedown\"===b.type),this.speed(0),this._drag.time=(new Date).getTime(),this._drag.target=a(b.target),this._drag.stage.start=d,this._drag.stage.current=d,this._drag.pointer=this.pointer(b),a(c).on(\"mouseup.owl.core touchend.owl.core\",a.proxy(this.onDragEnd,this)),a(c).one(\"mousemove.owl.core touchmove.owl.core\",a.proxy(function(b){var d=this.difference(this._drag.pointer,this.pointer(b));a(c).on(\"mousemove.owl.core touchmove.owl.core\",a.proxy(this.onDragMove,this)),Math.abs(d.x)<Math.abs(d.y)&&this.is(\"valid\")||(b.preventDefault(),this.enter(\"dragging\"),this.trigger(\"drag\"))},this)))},e.prototype.onDragMove=function(a){var b=null,c=null,d=null,e=this.difference(this._drag.pointer,this.pointer(a)),f=this.difference(this._drag.stage.start,e);this.is(\"dragging\")&&(a.preventDefault(),this.settings.loop?(b=this.coordinates(this.minimum()),c=this.coordinates(this.maximum()+1)-b,f.x=((f.x-b)%c+c)%c+b):(b=this.settings.rtl?this.coordinates(this.maximum()):this.coordinates(this.minimum()),c=this.settings.rtl?this.coordinates(this.minimum()):this.coordinates(this.maximum()),d=this.settings.pullDrag?-1*e.x/5:0,f.x=Math.max(Math.min(f.x,b+d),c+d)),this._drag.stage.current=f,this.animate(f.x))},e.prototype.onDragEnd=function(b){var d=this.difference(this._drag.pointer,this.pointer(b)),e=this._drag.stage.current,f=d.x>0^this.settings.rtl?\"left\":\"right\";a(c).off(\".owl.core\"),this.$element.removeClass(this.options.grabClass),(0!==d.x&&this.is(\"dragging\")||!this.is(\"valid\"))&&(this.speed(this.settings.dragEndSpeed||this.settings.smartSpeed),this.current(this.closest(e.x,0!==d.x?f:this._drag.direction)),this.invalidate(\"position\"),this.update(),this._drag.direction=f,(Math.abs(d.x)>3||(new Date).getTime()-this._drag.time>300)&&this._drag.target.one(\"click.owl.core\",function(){return!1})),this.is(\"dragging\")&&(this.leave(\"dragging\"),this.trigger(\"dragged\"))},e.prototype.closest=function(b,c){var e=-1,f=30,g=this.width(),h=this.coordinates();return this.settings.freeDrag||a.each(h,a.proxy(function(a,i){return\"left\"===c&&b>i-f&&b<i+f?e=a:\"right\"===c&&b>i-g-f&&b<i-g+f?e=a+1:this.op(b,\"<\",i)&&this.op(b,\">\",h[a+1]!==d?h[a+1]:i-g)&&(e=\"left\"===c?a+1:a),-1===e},this)),this.settings.loop||(this.op(b,\">\",h[this.minimum()])?e=b=this.minimum():this.op(b,\"<\",h[this.maximum()])&&(e=b=this.maximum())),e},e.prototype.animate=function(b){var c=this.speed()>0;this.is(\"animating\")&&this.onTransitionEnd(),c&&(this.enter(\"animating\"),this.trigger(\"translate\")),a.support.transform3d&&a.support.transition?this.$stage.css({transform:\"translate3d(\"+b+\"px,0px,0px)\",transition:this.speed()/1e3+\"s\"+(this.settings.slideTransition?\" \"+this.settings.slideTransition:\"\")}):c?this.$stage.animate({left:b+\"px\"},this.speed(),this.settings.fallbackEasing,a.proxy(this.onTransitionEnd,this)):this.$stage.css({left:b+\"px\"})},e.prototype.is=function(a){return this._states.current[a]&&this._states.current[a]>0},e.prototype.current=function(a){if(a===d)return this._current;if(0===this._items.length)return d;if(a=this.normalize(a),this._current!==a){var b=this.trigger(\"change\",{property:{name:\"position\",value:a}});b.data!==d&&(a=this.normalize(b.data)),this._current=a,this.invalidate(\"position\"),this.trigger(\"changed\",{property:{name:\"position\",value:this._current}})}return this._current},e.prototype.invalidate=function(b){return\"string\"===a.type(b)&&(this._invalidated[b]=!0,this.is(\"valid\")&&this.leave(\"valid\")),a.map(this._invalidated,function(a,b){return b})},e.prototype.reset=function(a){(a=this.normalize(a))!==d&&(this._speed=0,this._current=a,this.suppress([\"translate\",\"translated\"]),this.animate(this.coordinates(a)),this.release([\"translate\",\"translated\"]))},e.prototype.normalize=function(a,b){var c=this._items.length,e=b?0:this._clones.length;return!this.isNumeric(a)||c<1?a=d:(a<0||a>=c+e)&&(a=((a-e/2)%c+c)%c+e/2),a},e.prototype.relative=function(a){return a-=this._clones.length/2,this.normalize(a,!0)},e.prototype.maximum=function(a){var b,c,d,e=this.settings,f=this._coordinates.length;if(e.loop)f=this._clones.length/2+this._items.length-1;else if(e.autoWidth||e.merge){if(b=this._items.length)for(c=this._items[--b].width(),d=this.$element.width();b--&&!((c+=this._items[b].width()+this.settings.margin)>d););f=b+1}else f=e.center?this._items.length-1:this._items.length-e.items;return a&&(f-=this._clones.length/2),Math.max(f,0)},e.prototype.minimum=function(a){return a?0:this._clones.length/2},e.prototype.items=function(a){return a===d?this._items.slice():(a=this.normalize(a,!0),this._items[a])},e.prototype.mergers=function(a){return a===d?this._mergers.slice():(a=this.normalize(a,!0),this._mergers[a])},e.prototype.clones=function(b){var c=this._clones.length/2,e=c+this._items.length,f=function(a){return a%2==0?e+a/2:c-(a+1)/2};return b===d?a.map(this._clones,function(a,b){return f(b)}):a.map(this._clones,function(a,c){return a===b?f(c):null})},e.prototype.speed=function(a){return a!==d&&(this._speed=a),this._speed},e.prototype.coordinates=function(b){var c,e=1,f=b-1;return b===d?a.map(this._coordinates,a.proxy(function(a,b){return this.coordinates(b)},this)):(this.settings.center?(this.settings.rtl&&(e=-1,f=b+1),c=this._coordinates[b],c+=(this.width()-c+(this._coordinates[f]||0))/2*e):c=this._coordinates[f]||0,c=Math.ceil(c))},e.prototype.duration=function(a,b,c){return 0===c?0:Math.min(Math.max(Math.abs(b-a),1),6)*Math.abs(c||this.settings.smartSpeed)},e.prototype.to=function(a,b){var c=this.current(),d=null,e=a-this.relative(c),f=(e>0)-(e<0),g=this._items.length,h=this.minimum(),i=this.maximum();this.settings.loop?(!this.settings.rewind&&Math.abs(e)>g/2&&(e+=-1*f*g),a=c+e,(d=((a-h)%g+g)%g+h)!==a&&d-e<=i&&d-e>0&&(c=d-e,a=d,this.reset(c))):this.settings.rewind?(i+=1,a=(a%i+i)%i):a=Math.max(h,Math.min(i,a)),this.speed(this.duration(c,a,b)),this.current(a),this.isVisible()&&this.update()},e.prototype.next=function(a){a=a||!1,this.to(this.relative(this.current())+1,a)},e.prototype.prev=function(a){a=a||!1,this.to(this.relative(this.current())-1,a)},e.prototype.onTransitionEnd=function(a){if(a!==d&&(a.stopPropagation(),(a.target||a.srcElement||a.originalTarget)!==this.$stage.get(0)))return!1;this.leave(\"animating\"),this.trigger(\"translated\")},e.prototype.viewport=function(){var d;return this.options.responsiveBaseElement!==b?d=a(this.options.responsiveBaseElement).width():b.innerWidth?d=b.innerWidth:c.documentElement&&c.documentElement.clientWidth?d=c.documentElement.clientWidth:console.warn(\"Can not detect viewport width.\"),d},e.prototype.replace=function(b){this.$stage.empty(),this._items=[],b&&(b=b instanceof jQuery?b:a(b)),this.settings.nestedItemSelector&&(b=b.find(\".\"+this.settings.nestedItemSelector)),b.filter(function(){return 1===this.nodeType}).each(a.proxy(function(a,b){b=this.prepare(b),this.$stage.append(b),this._items.push(b),this._mergers.push(1*b.find(\"[data-merge]\").addBack(\"[data-merge]\").attr(\"data-merge\")||1)},this)),this.reset(this.isNumeric(this.settings.startPosition)?this.settings.startPosition:0),this.invalidate(\"items\")},e.prototype.add=function(b,c){var e=this.relative(this._current);c=c===d?this._items.length:this.normalize(c,!0),b=b instanceof jQuery?b:a(b),this.trigger(\"add\",{content:b,position:c}),b=this.prepare(b),0===this._items.length||c===this._items.length?(0===this._items.length&&this.$stage.append(b),0!==this._items.length&&this._items[c-1].after(b),this._items.push(b),this._mergers.push(1*b.find(\"[data-merge]\").addBack(\"[data-merge]\").attr(\"data-merge\")||1)):(this._items[c].before(b),this._items.splice(c,0,b),this._mergers.splice(c,0,1*b.find(\"[data-merge]\").addBack(\"[data-merge]\").attr(\"data-merge\")||1)),this._items[e]&&this.reset(this._items[e].index()),this.invalidate(\"items\"),this.trigger(\"added\",{content:b,position:c})},e.prototype.remove=function(a){(a=this.normalize(a,!0))!==d&&(this.trigger(\"remove\",{content:this._items[a],position:a}),this._items[a].remove(),this._items.splice(a,1),this._mergers.splice(a,1),this.invalidate(\"items\"),this.trigger(\"removed\",{content:null,position:a}))},e.prototype.preloadAutoWidthImages=function(b){b.each(a.proxy(function(b,c){this.enter(\"pre-loading\"),c=a(c),a(new Image).one(\"load\",a.proxy(function(a){c.attr(\"src\",a.target.src),c.css(\"opacity\",1),this.leave(\"pre-loading\"),!this.is(\"pre-loading\")&&!this.is(\"initializing\")&&this.refresh()},this)).attr(\"src\",c.attr(\"src\")||c.attr(\"data-src\")||c.attr(\"data-src-retina\"))},this))},e.prototype.destroy=function(){this.$element.off(\".owl.core\"),this.$stage.off(\".owl.core\"),a(c).off(\".owl.core\"),!1!==this.settings.responsive&&(b.clearTimeout(this.resizeTimer),this.off(b,\"resize\",this._handlers.onThrottledResize));for(var d in this._plugins)this._plugins[d].destroy();this.$stage.children(\".cloned\").remove(),this.$stage.unwrap(),this.$stage.children().contents().unwrap(),this.$stage.children().unwrap(),this.$stage.remove(),this.$element.removeClass(this.options.refreshClass).removeClass(this.options.loadingClass).removeClass(this.options.loadedClass).removeClass(this.options.rtlClass).removeClass(this.options.dragClass).removeClass(this.options.grabClass).attr(\"class\",this.$element.attr(\"class\").replace(new RegExp(this.options.responsiveClass+\"-\\\\S+\\\\s\",\"g\"),\"\")).removeData(\"owl.carousel\")},e.prototype.op=function(a,b,c){var d=this.settings.rtl;switch(b){case\"<\":return d?a>c:a<c;case\">\":return d?a<c:a>c;case\">=\":return d?a<=c:a>=c;case\"<=\":return d?a>=c:a<=c}},e.prototype.on=function(a,b,c,d){a.addEventListener?a.addEventListener(b,c,d):a.attachEvent&&a.attachEvent(\"on\"+b,c)},e.prototype.off=function(a,b,c,d){a.removeEventListener?a.removeEventListener(b,c,d):a.detachEvent&&a.detachEvent(\"on\"+b,c)},e.prototype.trigger=function(b,c,d,f,g){var h={item:{count:this._items.length,index:this.current()}},i=a.camelCase(a.grep([\"on\",b,d],function(a){return a}).join(\"-\").toLowerCase()),j=a.Event([b,\"owl\",d||\"carousel\"].join(\".\").toLowerCase(),a.extend({relatedTarget:this},h,c));return this._supress[b]||(a.each(this._plugins,function(a,b){b.onTrigger&&b.onTrigger(j)}),this.register({type:e.Type.Event,name:b}),this.$element.trigger(j),this.settings&&\"function\"==typeof this.settings[i]&&this.settings[i].call(this,j)),j},e.prototype.enter=function(b){a.each([b].concat(this._states.tags[b]||[]),a.proxy(function(a,b){this._states.current[b]===d&&(this._states.current[b]=0),this._states.current[b]++},this))},e.prototype.leave=function(b){a.each([b].concat(this._states.tags[b]||[]),a.proxy(function(a,b){this._states.current[b]--},this))},e.prototype.register=function(b){if(b.type===e.Type.Event){if(a.event.special[b.name]||(a.event.special[b.name]={}),!a.event.special[b.name].owl){var c=a.event.special[b.name]._default;a.event.special[b.name]._default=function(a){return!c||!c.apply||a.namespace&&-1!==a.namespace.indexOf(\"owl\")?a.namespace&&a.namespace.indexOf(\"owl\")>-1:c.apply(this,arguments)},a.event.special[b.name].owl=!0}}else b.type===e.Type.State&&(this._states.tags[b.name]?this._states.tags[b.name]=this._states.tags[b.name].concat(b.tags):this._states.tags[b.name]=b.tags,this._states.tags[b.name]=a.grep(this._states.tags[b.name],a.proxy(function(c,d){return a.inArray(c,this._states.tags[b.name])===d},this)))},e.prototype.suppress=function(b){a.each(b,a.proxy(function(a,b){this._supress[b]=!0},this))},e.prototype.release=function(b){a.each(b,a.proxy(function(a,b){delete this._supress[b]},this))},e.prototype.pointer=function(a){var c={x:null,y:null};return a=a.originalEvent||a||b.event,a=a.touches&&a.touches.length?a.touches[0]:a.changedTouches&&a.changedTouches.length?a.changedTouches[0]:a,a.pageX?(c.x=a.pageX,c.y=a.pageY):(c.x=a.clientX,c.y=a.clientY),c},e.prototype.isNumeric=function(a){return!isNaN(parseFloat(a))},e.prototype.difference=function(a,b){return{x:a.x-b.x,y:a.y-b.y}},a.fn.owlCarousel=function(b){var c=Array.prototype.slice.call(arguments,1);return this.each(function(){var d=a(this),f=d.data(\"owl.carousel\");f||(f=new e(this,\"object\"==typeof b&&b),d.data(\"owl.carousel\",f),a.each([\"next\",\"prev\",\"to\",\"destroy\",\"refresh\",\"replace\",\"add\",\"remove\"],function(b,c){f.register({type:e.Type.Event,name:c}),f.$element.on(c+\".owl.carousel.core\",a.proxy(function(a){a.namespace&&a.relatedTarget!==this&&(this.suppress([c]),f[c].apply(this,[].slice.call(arguments,1)),this.release([c]))},f))})),\"string\"==typeof b&&\"_\"!==b.charAt(0)&&f[b].apply(f,c)})},a.fn.owlCarousel.Constructor=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._interval=null,this._visible=null,this._handlers={\"initialized.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.autoRefresh&&this.watch()},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers)};e.Defaults={autoRefresh:!0,autoRefreshInterval:500},e.prototype.watch=function(){this._interval||(this._visible=this._core.isVisible(),this._interval=b.setInterval(a.proxy(this.refresh,this),this._core.settings.autoRefreshInterval))},e.prototype.refresh=function(){this._core.isVisible()!==this._visible&&(this._visible=!this._visible,this._core.$element.toggleClass(\"owl-hidden\",!this._visible),this._visible&&this._core.invalidate(\"width\")&&this._core.refresh())},e.prototype.destroy=function(){var a,c;b.clearInterval(this._interval);for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(c in Object.getOwnPropertyNames(this))\"function\"!=typeof this[c]&&(this[c]=null)},a.fn.owlCarousel.Constructor.Plugins.AutoRefresh=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._loaded=[],this._handlers={\"initialized.owl.carousel change.owl.carousel resized.owl.carousel\":a.proxy(function(b){if(b.namespace&&this._core.settings&&this._core.settings.lazyLoad&&(b.property&&\"position\"==b.property.name||\"initialized\"==b.type)){var c=this._core.settings,e=c.center&&Math.ceil(c.items/2)||c.items,f=c.center&&-1*e||0,g=(b.property&&b.property.value!==d?b.property.value:this._core.current())+f,h=this._core.clones().length,i=a.proxy(function(a,b){this.load(b)},this);for(c.lazyLoadEager>0&&(e+=c.lazyLoadEager,c.loop&&(g-=c.lazyLoadEager,e++));f++<e;)this.load(h/2+this._core.relative(g)),h&&a.each(this._core.clones(this._core.relative(g)),i),g++}},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers)};e.Defaults={lazyLoad:!1,lazyLoadEager:0},e.prototype.load=function(c){var d=this._core.$stage.children().eq(c),e=d&&d.find(\".owl-lazy\");!e||a.inArray(d.get(0),this._loaded)>-1||(e.each(a.proxy(function(c,d){var e,f=a(d),g=b.devicePixelRatio>1&&f.attr(\"data-src-retina\")||f.attr(\"data-src\")||f.attr(\"data-srcset\");this._core.trigger(\"load\",{element:f,url:g},\"lazy\"),f.is(\"img\")?f.one(\"load.owl.lazy\",a.proxy(function(){f.css(\"opacity\",1),this._core.trigger(\"loaded\",{element:f,url:g},\"lazy\")},this)).attr(\"src\",g):f.is(\"source\")?f.one(\"load.owl.lazy\",a.proxy(function(){this._core.trigger(\"loaded\",{element:f,url:g},\"lazy\")},this)).attr(\"srcset\",g):(e=new Image,e.onload=a.proxy(function(){f.css({\"background-image\":'url(\"'+g+'\")',opacity:\"1\"}),this._core.trigger(\"loaded\",{element:f,url:g},\"lazy\")},this),e.src=g)},this)),this._loaded.push(d.get(0)))},e.prototype.destroy=function(){var a,b;for(a in this.handlers)this._core.$element.off(a,this.handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.Lazy=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(c){this._core=c,this._previousHeight=null,this._handlers={\"initialized.owl.carousel refreshed.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.autoHeight&&this.update()},this),\"changed.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.autoHeight&&\"position\"===a.property.name&&this.update()},this),\"loaded.owl.lazy\":a.proxy(function(a){a.namespace&&this._core.settings.autoHeight&&a.element.closest(\".\"+this._core.settings.itemClass).index()===this._core.current()&&this.update()},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers),this._intervalId=null;var d=this;a(b).on(\"load\",function(){d._core.settings.autoHeight&&d.update()}),a(b).resize(function(){d._core.settings.autoHeight&&(null!=d._intervalId&&clearTimeout(d._intervalId),d._intervalId=setTimeout(function(){d.update()},250))})};e.Defaults={autoHeight:!1,autoHeightClass:\"owl-height\"},e.prototype.update=function(){var b=this._core._current,c=b+this._core.settings.items,d=this._core.settings.lazyLoad,e=this._core.$stage.children().toArray().slice(b,c),f=[],g=0;a.each(e,function(b,c){f.push(a(c).height())}),g=Math.max.apply(null,f),g<=1&&d&&this._previousHeight&&(g=this._previousHeight),this._previousHeight=g,this._core.$stage.parent().height(g).addClass(this._core.settings.autoHeightClass)},e.prototype.destroy=function(){var a,b;for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.AutoHeight=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._videos={},this._playing=null,this._handlers={\"initialized.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.register({type:\"state\",name:\"playing\",tags:[\"interacting\"]})},this),\"resize.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.video&&this.isInFullScreen()&&a.preventDefault()},this),\"refreshed.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.is(\"resizing\")&&this._core.$stage.find(\".cloned .owl-video-frame\").remove()},this),\"changed.owl.carousel\":a.proxy(function(a){a.namespace&&\"position\"===a.property.name&&this._playing&&this.stop()},this),\"prepared.owl.carousel\":a.proxy(function(b){if(b.namespace){var c=a(b.content).find(\".owl-video\");c.length&&(c.css(\"display\",\"none\"),this.fetch(c,a(b.content)))}},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this._core.$element.on(this._handlers),this._core.$element.on(\"click.owl.video\",\".owl-video-play-icon\",a.proxy(function(a){this.play(a)},this))};e.Defaults={video:!1,videoHeight:!1,videoWidth:!1},e.prototype.fetch=function(a,b){var c=function(){return a.attr(\"data-vimeo-id\")?\"vimeo\":a.attr(\"data-vzaar-id\")?\"vzaar\":\"youtube\"}(),d=a.attr(\"data-vimeo-id\")||a.attr(\"data-youtube-id\")||a.attr(\"data-vzaar-id\"),e=a.attr(\"data-width\")||this._core.settings.videoWidth,f=a.attr(\"data-height\")||this._core.settings.videoHeight,g=a.attr(\"href\");if(!g)throw new Error(\"Missing video URL.\");if(d=g.match(/(http:|https:|)\\/\\/(player.|www.|app.)?(vimeo\\.com|youtu(be\\.com|\\.be|be\\.googleapis\\.com|be\\-nocookie\\.com)|vzaar\\.com)\\/(video\\/|videos\\/|embed\\/|channels\\/.+\\/|groups\\/.+\\/|watch\\?v=|v\\/)?([A-Za-z0-9._%-]*)(\\&\\S+)?/),d[3].indexOf(\"youtu\")>-1)c=\"youtube\";else if(d[3].indexOf(\"vimeo\")>-1)c=\"vimeo\";else{if(!(d[3].indexOf(\"vzaar\")>-1))throw new Error(\"Video URL not supported.\");c=\"vzaar\"}d=d[6],this._videos[g]={type:c,id:d,width:e,height:f},b.attr(\"data-video\",g),this.thumbnail(a,this._videos[g])},e.prototype.thumbnail=function(b,c){var d,e,f,g=c.width&&c.height?\"width:\"+c.width+\"px;height:\"+c.height+\"px;\":\"\",h=b.find(\"img\"),i=\"src\",j=\"\",k=this._core.settings,l=function(c){e='<div class=\"owl-video-play-icon\"></div>',d=k.lazyLoad?a(\"<div/>\",{class:\"owl-video-tn \"+j,srcType:c}):a(\"<div/>\",{class:\"owl-video-tn\",style:\"opacity:1;background-image:url(\"+c+\")\"}),b.after(d),b.after(e)};if(b.wrap(a(\"<div/>\",{class:\"owl-video-wrapper\",style:g})),this._core.settings.lazyLoad&&(i=\"data-src\",j=\"owl-lazy\"),h.length)return l(h.attr(i)),h.remove(),!1;\"youtube\"===c.type?(f=\"//img.youtube.com/vi/\"+c.id+\"/hqdefault.jpg\",l(f)):\"vimeo\"===c.type?a.ajax({type:\"GET\",url:\"//vimeo.com/api/v2/video/\"+c.id+\".json\",jsonp:\"callback\",dataType:\"jsonp\",success:function(a){f=a[0].thumbnail_large,l(f)}}):\"vzaar\"===c.type&&a.ajax({type:\"GET\",url:\"//vzaar.com/api/videos/\"+c.id+\".json\",jsonp:\"callback\",dataType:\"jsonp\",success:function(a){f=a.framegrab_url,l(f)}})},e.prototype.stop=function(){this._core.trigger(\"stop\",null,\"video\"),this._playing.find(\".owl-video-frame\").remove(),this._playing.removeClass(\"owl-video-playing\"),this._playing=null,this._core.leave(\"playing\"),this._core.trigger(\"stopped\",null,\"video\")},e.prototype.play=function(b){var c,d=a(b.target),e=d.closest(\".\"+this._core.settings.itemClass),f=this._videos[e.attr(\"data-video\")],g=f.width||\"100%\",h=f.height||this._core.$stage.height();this._playing||(this._core.enter(\"playing\"),this._core.trigger(\"play\",null,\"video\"),e=this._core.items(this._core.relative(e.index())),this._core.reset(e.index()),c=a('<iframe frameborder=\"0\" allowfullscreen mozallowfullscreen webkitAllowFullScreen ></iframe>'),c.attr(\"height\",h),c.attr(\"width\",g),\"youtube\"===f.type?c.attr(\"src\",\"//www.youtube.com/embed/\"+f.id+\"?autoplay=1&rel=0&v=\"+f.id):\"vimeo\"===f.type?c.attr(\"src\",\"//player.vimeo.com/video/\"+f.id+\"?autoplay=1\"):\"vzaar\"===f.type&&c.attr(\"src\",\"//view.vzaar.com/\"+f.id+\"/player?autoplay=true\"),a(c).wrap('<div class=\"owl-video-frame\" />').insertAfter(e.find(\".owl-video\")),this._playing=e.addClass(\"owl-video-playing\"))},e.prototype.isInFullScreen=function(){var b=c.fullscreenElement||c.mozFullScreenElement||c.webkitFullscreenElement;return b&&a(b).parent().hasClass(\"owl-video-frame\")},e.prototype.destroy=function(){var a,b;this._core.$element.off(\"click.owl.video\");for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.Video=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this.core=b,this.core.options=a.extend({},e.Defaults,this.core.options),this.swapping=!0,this.previous=d,this.next=d,this.handlers={\"change.owl.carousel\":a.proxy(function(a){a.namespace&&\"position\"==a.property.name&&(this.previous=this.core.current(),this.next=a.property.value)},this),\"drag.owl.carousel dragged.owl.carousel translated.owl.carousel\":a.proxy(function(a){a.namespace&&(this.swapping=\"translated\"==a.type)},this),\"translate.owl.carousel\":a.proxy(function(a){a.namespace&&this.swapping&&(this.core.options.animateOut||this.core.options.animateIn)&&this.swap()},this)},this.core.$element.on(this.handlers)};e.Defaults={animateOut:!1,\r\nanimateIn:!1},e.prototype.swap=function(){if(1===this.core.settings.items&&a.support.animation&&a.support.transition){this.core.speed(0);var b,c=a.proxy(this.clear,this),d=this.core.$stage.children().eq(this.previous),e=this.core.$stage.children().eq(this.next),f=this.core.settings.animateIn,g=this.core.settings.animateOut;this.core.current()!==this.previous&&(g&&(b=this.core.coordinates(this.previous)-this.core.coordinates(this.next),d.one(a.support.animation.end,c).css({left:b+\"px\"}).addClass(\"animated owl-animated-out\").addClass(g)),f&&e.one(a.support.animation.end,c).addClass(\"animated owl-animated-in\").addClass(f))}},e.prototype.clear=function(b){a(b.target).css({left:\"\"}).removeClass(\"animated owl-animated-out owl-animated-in\").removeClass(this.core.settings.animateIn).removeClass(this.core.settings.animateOut),this.core.onTransitionEnd()},e.prototype.destroy=function(){var a,b;for(a in this.handlers)this.core.$element.off(a,this.handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.Animate=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this._core=b,this._call=null,this._time=0,this._timeout=0,this._paused=!0,this._handlers={\"changed.owl.carousel\":a.proxy(function(a){a.namespace&&\"settings\"===a.property.name?this._core.settings.autoplay?this.play():this.stop():a.namespace&&\"position\"===a.property.name&&this._paused&&(this._time=0)},this),\"initialized.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.autoplay&&this.play()},this),\"play.owl.autoplay\":a.proxy(function(a,b,c){a.namespace&&this.play(b,c)},this),\"stop.owl.autoplay\":a.proxy(function(a){a.namespace&&this.stop()},this),\"mouseover.owl.autoplay\":a.proxy(function(){this._core.settings.autoplayHoverPause&&this._core.is(\"rotating\")&&this.pause()},this),\"mouseleave.owl.autoplay\":a.proxy(function(){this._core.settings.autoplayHoverPause&&this._core.is(\"rotating\")&&this.play()},this),\"touchstart.owl.core\":a.proxy(function(){this._core.settings.autoplayHoverPause&&this._core.is(\"rotating\")&&this.pause()},this),\"touchend.owl.core\":a.proxy(function(){this._core.settings.autoplayHoverPause&&this.play()},this)},this._core.$element.on(this._handlers),this._core.options=a.extend({},e.Defaults,this._core.options)};e.Defaults={autoplay:!1,autoplayTimeout:5e3,autoplayHoverPause:!1,autoplaySpeed:!1},e.prototype._next=function(d){this._call=b.setTimeout(a.proxy(this._next,this,d),this._timeout*(Math.round(this.read()/this._timeout)+1)-this.read()),this._core.is(\"interacting\")||c.hidden||this._core.next(d||this._core.settings.autoplaySpeed)},e.prototype.read=function(){return(new Date).getTime()-this._time},e.prototype.play=function(c,d){var e;this._core.is(\"rotating\")||this._core.enter(\"rotating\"),c=c||this._core.settings.autoplayTimeout,e=Math.min(this._time%(this._timeout||c),c),this._paused?(this._time=this.read(),this._paused=!1):b.clearTimeout(this._call),this._time+=this.read()%c-e,this._timeout=c,this._call=b.setTimeout(a.proxy(this._next,this,d),c-e)},e.prototype.stop=function(){this._core.is(\"rotating\")&&(this._time=0,this._paused=!0,b.clearTimeout(this._call),this._core.leave(\"rotating\"))},e.prototype.pause=function(){this._core.is(\"rotating\")&&!this._paused&&(this._time=this.read(),this._paused=!0,b.clearTimeout(this._call))},e.prototype.destroy=function(){var a,b;this.stop();for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(b in Object.getOwnPropertyNames(this))\"function\"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.autoplay=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){\"use strict\";var e=function(b){this._core=b,this._initialized=!1,this._pages=[],this._controls={},this._templates=[],this.$element=this._core.$element,this._overrides={next:this._core.next,prev:this._core.prev,to:this._core.to},this._handlers={\"prepared.owl.carousel\":a.proxy(function(b){b.namespace&&this._core.settings.dotsData&&this._templates.push('<div class=\"'+this._core.settings.dotClass+'\">'+a(b.content).find(\"[data-dot]\").addBack(\"[data-dot]\").attr(\"data-dot\")+\"</div>\")},this),\"added.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.dotsData&&this._templates.splice(a.position,0,this._templates.pop())},this),\"remove.owl.carousel\":a.proxy(function(a){a.namespace&&this._core.settings.dotsData&&this._templates.splice(a.position,1)},this),\"changed.owl.carousel\":a.proxy(function(a){a.namespace&&\"position\"==a.property.name&&this.draw()},this),\"initialized.owl.carousel\":a.proxy(function(a){a.namespace&&!this._initialized&&(this._core.trigger(\"initialize\",null,\"navigation\"),this.initialize(),this.update(),this.draw(),this._initialized=!0,this._core.trigger(\"initialized\",null,\"navigation\"))},this),\"refreshed.owl.carousel\":a.proxy(function(a){a.namespace&&this._initialized&&(this._core.trigger(\"refresh\",null,\"navigation\"),this.update(),this.draw(),this._core.trigger(\"refreshed\",null,\"navigation\"))},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this.$element.on(this._handlers)};e.Defaults={nav:!1,navText:['<span aria-label=\"Previous\">&#x2039;</span>','<span aria-label=\"Next\">&#x203a;</span>'],navSpeed:!1,navElement:'button type=\"button\" role=\"presentation\"',navContainer:!1,navContainerClass:\"owl-nav\",navClass:[\"owl-prev\",\"owl-next\"],slideBy:1,dotClass:\"owl-dot\",dotsClass:\"owl-dots\",dots:!0,dotsEach:!1,dotsData:!1,dotsSpeed:!1,dotsContainer:!1},e.prototype.initialize=function(){var b,c=this._core.settings;this._controls.$relative=(c.navContainer?a(c.navContainer):a(\"<div>\").addClass(c.navContainerClass).appendTo(this.$element)).addClass(\"disabled\"),this._controls.$previous=a(\"<\"+c.navElement+\">\").addClass(c.navClass[0]).html(c.navText[0]).prependTo(this._controls.$relative).on(\"click\",a.proxy(function(a){this.prev(c.navSpeed)},this)),this._controls.$next=a(\"<\"+c.navElement+\">\").addClass(c.navClass[1]).html(c.navText[1]).appendTo(this._controls.$relative).on(\"click\",a.proxy(function(a){this.next(c.navSpeed)},this)),c.dotsData||(this._templates=[a('<button role=\"button\">').addClass(c.dotClass).append(a(\"<span>\")).prop(\"outerHTML\")]),this._controls.$absolute=(c.dotsContainer?a(c.dotsContainer):a(\"<div>\").addClass(c.dotsClass).appendTo(this.$element)).addClass(\"disabled\"),this._controls.$absolute.on(\"click\",\"button\",a.proxy(function(b){var d=a(b.target).parent().is(this._controls.$absolute)?a(b.target).index():a(b.target).parent().index();b.preventDefault(),this.to(d,c.dotsSpeed)},this));for(b in this._overrides)this._core[b]=a.proxy(this[b],this)},e.prototype.destroy=function(){var a,b,c,d,e;e=this._core.settings;for(a in this._handlers)this.$element.off(a,this._handlers[a]);for(b in this._controls)\"$relative\"===b&&e.navContainer?this._controls[b].html(\"\"):this._controls[b].remove();for(d in this.overides)this._core[d]=this._overrides[d];for(c in Object.getOwnPropertyNames(this))\"function\"!=typeof this[c]&&(this[c]=null)},e.prototype.update=function(){var a,b,c,d=this._core.clones().length/2,e=d+this._core.items().length,f=this._core.maximum(!0),g=this._core.settings,h=g.center||g.autoWidth||g.dotsData?1:g.dotsEach||g.items;if(\"page\"!==g.slideBy&&(g.slideBy=Math.min(g.slideBy,g.items)),g.dots||\"page\"==g.slideBy)for(this._pages=[],a=d,b=0,c=0;a<e;a++){if(b>=h||0===b){if(this._pages.push({start:Math.min(f,a-d),end:a-d+h-1}),Math.min(f,a-d)===f)break;b=0,++c}b+=this._core.mergers(this._core.relative(a))}},e.prototype.draw=function(){var b,c=this._core.settings,d=this._core.items().length<=c.items,e=this._core.relative(this._core.current()),f=c.loop||c.rewind;this._controls.$relative.toggleClass(\"disabled\",!c.nav||d),c.nav&&(this._controls.$previous.toggleClass(\"disabled\",!f&&e<=this._core.minimum(!0)),this._controls.$next.toggleClass(\"disabled\",!f&&e>=this._core.maximum(!0))),this._controls.$absolute.toggleClass(\"disabled\",!c.dots||d),c.dots&&(b=this._pages.length-this._controls.$absolute.children().length,c.dotsData&&0!==b?this._controls.$absolute.html(this._templates.join(\"\")):b>0?this._controls.$absolute.append(new Array(b+1).join(this._templates[0])):b<0&&this._controls.$absolute.children().slice(b).remove(),this._controls.$absolute.find(\".active\").removeClass(\"active\"),this._controls.$absolute.children().eq(a.inArray(this.current(),this._pages)).addClass(\"active\"))},e.prototype.onTrigger=function(b){var c=this._core.settings;b.page={index:a.inArray(this.current(),this._pages),count:this._pages.length,size:c&&(c.center||c.autoWidth||c.dotsData?1:c.dotsEach||c.items)}},e.prototype.current=function(){var b=this._core.relative(this._core.current());return a.grep(this._pages,a.proxy(function(a,c){return a.start<=b&&a.end>=b},this)).pop()},e.prototype.getPosition=function(b){var c,d,e=this._core.settings;return\"page\"==e.slideBy?(c=a.inArray(this.current(),this._pages),d=this._pages.length,b?++c:--c,c=this._pages[(c%d+d)%d].start):(c=this._core.relative(this._core.current()),d=this._core.items().length,b?c+=e.slideBy:c-=e.slideBy),c},e.prototype.next=function(b){a.proxy(this._overrides.to,this._core)(this.getPosition(!0),b)},e.prototype.prev=function(b){a.proxy(this._overrides.to,this._core)(this.getPosition(!1),b)},e.prototype.to=function(b,c,d){var e;!d&&this._pages.length?(e=this._pages.length,a.proxy(this._overrides.to,this._core)(this._pages[(b%e+e)%e].start,c)):a.proxy(this._overrides.to,this._core)(b,c)},a.fn.owlCarousel.Constructor.Plugins.Navigation=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){\"use strict\";var e=function(c){this._core=c,this._hashes={},this.$element=this._core.$element,this._handlers={\"initialized.owl.carousel\":a.proxy(function(c){c.namespace&&\"URLHash\"===this._core.settings.startPosition&&a(b).trigger(\"hashchange.owl.navigation\")},this),\"prepared.owl.carousel\":a.proxy(function(b){if(b.namespace){var c=a(b.content).find(\"[data-hash]\").addBack(\"[data-hash]\").attr(\"data-hash\");if(!c)return;this._hashes[c]=b.content}},this),\"changed.owl.carousel\":a.proxy(function(c){if(c.namespace&&\"position\"===c.property.name){var d=this._core.items(this._core.relative(this._core.current())),e=a.map(this._hashes,function(a,b){return a===d?b:null}).join();if(!e||b.location.hash.slice(1)===e)return;b.location.hash=e}},this)},this._core.options=a.extend({},e.Defaults,this._core.options),this.$element.on(this._handlers),a(b).on(\"hashchange.owl.navigation\",a.proxy(function(a){var c=b.location.hash.substring(1),e=this._core.$stage.children(),f=this._hashes[c]&&e.index(this._hashes[c]);f!==d&&f!==this._core.current()&&this._core.to(this._core.relative(f),!1,!0)},this))};e.Defaults={URLhashListener:!1},e.prototype.destroy=function(){var c,d;a(b).off(\"hashchange.owl.navigation\");for(c in this._handlers)this._core.$element.off(c,this._handlers[c]);for(d in Object.getOwnPropertyNames(this))\"function\"!=typeof this[d]&&(this[d]=null)},a.fn.owlCarousel.Constructor.Plugins.Hash=e}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){function e(b,c){var e=!1,f=b.charAt(0).toUpperCase()+b.slice(1);return a.each((b+\" \"+h.join(f+\" \")+f).split(\" \"),function(a,b){if(g[b]!==d)return e=!c||b,!1}),e}function f(a){return e(a,!0)}var g=a(\"<support>\").get(0).style,h=\"Webkit Moz O ms\".split(\" \"),i={transition:{end:{WebkitTransition:\"webkitTransitionEnd\",MozTransition:\"transitionend\",OTransition:\"oTransitionEnd\",transition:\"transitionend\"}},animation:{end:{WebkitAnimation:\"webkitAnimationEnd\",MozAnimation:\"animationend\",OAnimation:\"oAnimationEnd\",animation:\"animationend\"}}},j={csstransforms:function(){return!!e(\"transform\")},csstransforms3d:function(){return!!e(\"perspective\")},csstransitions:function(){return!!e(\"transition\")},cssanimations:function(){return!!e(\"animation\")}};j.csstransitions()&&(a.support.transition=new String(f(\"transition\")),a.support.transition.end=i.transition.end[a.support.transition]),j.cssanimations()&&(a.support.animation=new String(f(\"animation\")),a.support.animation.end=i.animation.end[a.support.animation]),j.csstransforms()&&(a.support.transform=new String(f(\"transform\")),a.support.transform3d=j.csstransforms3d())}(window.Zepto||window.jQuery,window,document);","PayPal_Braintree/js/braintree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/*browser:true*/\n/*global define*/\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/lib/view/utils/dom-observer',\n    'mage/translate',\n    'PayPal_Braintree/js/validator',\n    'braintree',\n    'braintreeHostedFields'\n], function ($, Class, alert, domObserver, $t, validator, client, hostedFields) {\n    'use strict';\n\n    return Class.extend({\n\n        defaults: {\n            $selector: null,\n            selector: 'edit_form',\n            container: 'payment_form_braintree',\n            active: false,\n            scriptLoaded: false,\n            braintree: null,\n            selectedCardType: null,\n            imports: {\n                onActiveChange: 'active'\n            },\n            hostedFieldsInstance: null\n        },\n\n        /**\n         * Set list of observable attributes\n         * @returns {exports.initObservable}\n         */\n        initObservable: function () {\n            var self = this;\n\n            validator.setConfig(this);\n\n            self.$selector = $('#' + self.selector);\n            this._super()\n                .observe([\n                    'active',\n                    'scriptLoaded',\n                    'selectedCardType'\n                ]);\n\n            // re-init payment method events\n            self.$selector.off('changePaymentMethod.' + this.code)\n                .on('changePaymentMethod.' + this.code, this.changePaymentMethod.bind(this));\n\n            // listen block changes\n            domObserver.get('#' + self.container, function () {\n                if (self.scriptLoaded()) {\n                    self.$selector.off('submit');\n                    self.initBraintree();\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * Enable/disable current payment method\n         * @param {Object} event\n         * @param {String} method\n         * @returns {exports.changePaymentMethod}\n         */\n        changePaymentMethod: function (event, method) {\n            this.active(method === this.code);\n            return this;\n        },\n\n        /**\n         * Triggered when payment changed\n         * @param {Boolean} isActive\n         */\n        onActiveChange: function (isActive) {\n            if (!isActive) {\n                this.$selector.off('submitOrder.braintree');\n                this.$selector.on('submitOrder', function () {\n                    $('#payment_form_braintree').find('[type=\"submit\"]').trigger('click');\n                    $('#edit_form').trigger('realOrder');\n                });\n\n                return;\n            }\n            this.disableEventListeners();\n\n            if (typeof window.order !== 'undefined') {\n                window.order.addExcludedPaymentMethod(this.code);\n            }\n\n            if (!this.clientToken) {\n                this.error($.mage.__('This payment is not available'));\n\n                return;\n            }\n\n            this.enableEventListeners();\n\n            if (!this.scriptLoaded()) {\n                this.initBraintree();\n            }\n        },\n\n        /**\n         * Setup Braintree SDK\n         */\n        initBraintree: function () {\n            var self = this;\n            this.scriptLoaded(true);\n\n            self.disableEventListeners();\n\n            try {\n                $('body').trigger('processStart');\n\n                client.create({\n                    authorization: self.clientToken\n                }, function (clientErr, clientInstance) {\n                    if (clientErr) {\n                        console.error('Error!', clientErr);\n                        return self.error(response.clientErr);\n                    }\n\n                    hostedFields.create({\n                        client: clientInstance,\n                        fields: self.getHostedFields()\n                    }, function (createErr, hostedFieldsInstance) {\n                        if (createErr) {\n                            self.error($t(createErr));\n                            console.error('Error!', createErr);\n                            return;\n                        }\n\n                        self.hostedFieldsInstance = hostedFieldsInstance;\n                        self.enableEventListeners();\n\n                        $('body').trigger('processStop');\n                    }.bind(this));\n                }.bind(this));\n            } catch (e) {\n                $('body').trigger('processStop');\n                self.error(e.message);\n                console.log(e);\n            }\n        },\n\n        /**\n         * Get hosted fields configuration\n         * @returns {Object}\n         */\n        getHostedFields: function () {\n            var self = this,\n                fields = {\n                    number: {\n                        selector: self.getSelector('cc_number'),\n                        placeholder: $t('4111 1111 1111 1111')\n                    },\n                    expirationMonth: {\n                        selector: self.getSelector('cc_exp_month'),\n                        placeholder: $t('MM')\n                    },\n                    expirationYear: {\n                        selector: self.getSelector('cc_exp_year'),\n                        placeholder: $t('YY')\n                    }\n                };\n\n            if (self.useCvv) {\n                fields.cvv = {\n                    selector: self.getSelector('cc_cid'),\n                    placeholder: $t('123')\n                };\n            }\n\n            return fields;\n        },\n\n        /**\n         * Show alert message\n         * @param {String} message\n         */\n        error: function (message) {\n            alert({\n                content: message\n            });\n        },\n\n        /**\n         * Enable form event listeners\n         */\n        enableEventListeners: function () {\n            this.$selector.on('submitOrder.braintree', this.submitOrder.bind(this));\n        },\n\n        /**\n         * Disable form event listeners\n         */\n        disableEventListeners: function () {\n            this.$selector.off('submitOrder');\n            this.$selector.off('submit');\n        },\n\n        /**\n         * Store payment details\n         * @param {String} nonce\n         */\n        setPaymentDetails: function (nonce) {\n            var $container = $('#' + this.container);\n\n            $container.find('[name=\"payment[payment_method_nonce]\"]').val(nonce);\n        },\n\n        /**\n         * Trigger order submit\n         */\n        submitOrder: function () {\n            this.$selector.validate().form();\n            this.$selector.trigger('afterValidate.beforeSubmit');\n            $('body').trigger('processStop');\n\n            // validate parent form\n            if (this.$selector.validate().errorList.length) {\n                return false;\n            }\n\n            $('body').trigger('processStart');\n            this.tokenizeHostedFields();\n        },\n\n        /**\n         * Place order\n         */\n        placeOrder: function () {\n            $('#' + this.selector).trigger('realOrder');\n        },\n\n        /**\n         * Get list of currently available card types\n         * @returns {Array}\n         */\n        getCcAvailableTypes: function () {\n            var types = [],\n                $options = $(this.getSelector('cc_type')).find('option');\n\n            $.map($options, function (option) {\n                types.push($(option).val());\n            });\n\n            return types;\n        },\n\n        /**\n         * Get jQuery selector\n         * @param {String} field\n         * @returns {String}\n         */\n        getSelector: function (field) {\n            return '#' + this.code + '_' + field;\n        },\n\n        tokenizeHostedFields: function () {\n            this.hostedFieldsInstance.tokenize({\n                vault: false // vault or no?\n            }, function (tokenizeErr, payload) {\n                if (tokenizeErr) {\n                    $('body').trigger('processStop');\n                    switch (tokenizeErr.code) {\n                        case 'HOSTED_FIELDS_FIELDS_EMPTY':\n                            // occurs when none of the fields are filled in\n                            this.error($t('Please enter a card number, expiration date and CVV'));\n                            break;\n                        case 'HOSTED_FIELDS_FIELDS_INVALID':\n                            // occurs when certain fields do not pass client side validation\n                            this.error($t('Please correct the problems with the Credit Card fields.'));\n                            console.error('Some fields are invalid:', tokenizeErr.details.invalidFieldKeys);\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_FAIL_ON_DUPLICATE':\n                            // occurs when:\n                            //   * the client token used for client authorization was generated\n                            //     with a customer ID and the fail on duplicate payment method\n                            //     option is set to true\n                            //   * the card being tokenized has previously been vaulted (with any customer)\n                            // See: https://developers.braintreepayments.com/reference/request/client-token/generate/#options.fail_on_duplicate_payment_method\n                            this.error($t('The payment method used, already exists in the user\\'s vault. Please use the vault option instead.'));\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_CVV_VERIFICATION_FAILED':\n                            // occurs when:\n                            //   * the client token used for client authorization was generated\n                            //     with a customer ID and the verify card option is set to true\n                            //     and you have credit card verification turned on in the Braintree\n                            //     control panel\n                            //   * the cvv does not pass verfication (https://developers.braintreepayments.com/reference/general/testing/#avs-and-cvv/cid-responses)\n                            // See: https://developers.braintreepayments.com/reference/request/client-token/generate/#options.verify_card\n                            this.error($t('CVV did not pass verification'));\n                            break;\n                        case 'HOSTED_FIELDS_FAILED_TOKENIZATION':\n                            // occurs for any other tokenization error on the server\n                            this.error($t('There was an issue tokenizing the card. Please check the card is valid.'));\n                            console.error('Tokenization failed server side. Is the card valid?');\n                            break;\n                        case 'HOSTED_FIELDS_TOKENIZATION_NETWORK_ERROR':\n                            // occurs when the Braintree gateway cannot be contacted\n                            this.error($t('There was an error connecting to Braintree. Please try again.'));\n                            break;\n                        default:\n                            this.error($t('There was an issue processing the payment. Please try again.'));\n                            console.error('Braintree error', tokenizeErr);\n                            break;\n                    }\n                } else {\n                    this.setPaymentDetails(payload.nonce);\n                    $('#' + this.container).find('[type=\"submit\"]').trigger('click');\n                }\n            }.bind(this));\n        }\n    });\n});\n","PayPal_Braintree/js/form-builder.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(\n    [\n        'jquery',\n        'underscore',\n        'mage/template'\n    ],\n    function ($, _, mageTemplate) {\n        'use strict';\n\n        return {\n\n            /**\n             * @param {Object} formData\n             * @returns {*|jQuery}\n             */\n            build: function (formData) {\n                var formTmpl = mageTemplate('<form action=\"<%= data.action %>\"' +\n                    ' method=\"POST\" hidden enctype=\"application/x-www-form-urlencoded\">' +\n                        '<% _.each(data.fields, function(val, key){ %>' +\n                            '<input value=\\'<%= val %>\\' name=\"<%= key %>\" type=\"hidden\">' +\n                        '<% }); %>' +\n                    '</form>');\n\n                return $(formTmpl({\n                    data: {\n                        action: formData.action,\n                        fields: formData.fields\n                    }\n                })).appendTo($('[data-container=\"body\"]'));\n            }\n        };\n    }\n);\n","PayPal_Braintree/js/paypalButtonPreview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'jquery',\n    'braintree',\n    'braintreePayPalCheckout',\n    'domReady!'\n], function (_, $, braintree, paypalCheckout) {\n    'use strict';\n    let buttonIds = [];\n\n    return {\n        events: {\n            onClick: null\n        },\n\n        /**\n         * @param token\n         * @param currency\n         * @param env\n         * @param local\n         */\n        init: function (token, currency, env, local) {\n            buttonIds = [];\n            $('.action-braintree-paypal-logo').each(function () {\n                if (!$(this).hasClass(\"button-loaded\")) {\n                    $(this).addClass('button-loaded');\n                    buttonIds.push($(this).attr('id'));\n                }\n            });\n\n            if (buttonIds.length > 0) {\n                this.loadSDK(token, currency, env, local);\n            }\n        },\n\n        /**\n         * Load Braintree PayPal SDK\n         * @param token\n         * @param currency\n         * @param env\n         * @param local\n         */\n        loadSDK: function (token, currency, env, local) {\n            braintree.create({\n                authorization: token\n            }, function (clientErr, clientInstance) {\n                if (clientErr) {\n                    console.error('paypalCheckout error', clientErr);\n                    return this.showError(\"PayPal Checkout could not be initialized. Please contact the store owner.\");\n                }\n                paypalCheckout.create({\n                    client: clientInstance\n                }, function (err, paypalCheckoutInstance) {\n                    if (typeof paypal !== 'undefined' ) {\n                        this.renderPayPalButtons(buttonIds);\n                        this.renderPayPalMessages();\n                    } else {\n                        var configSDK = {\n                            components: 'buttons,messages,funding-eligibility',\n                            \"enable-funding\": \"paylater\",\n                            currency: currency\n                        };\n                        if (env === 'sandbox' && (local !== '' || local !== 'undefined')) {\n                            configSDK[\"buyer-country\"] = local;\n                        }\n                        paypalCheckoutInstance.loadPayPalSDK(configSDK, function () {\n                            this.renderPayPalButtons(buttonIds);\n                            this.renderPayPalMessages();\n                        }.bind(this));\n                    }\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /**\n         * Render PayPal buttons\n         * @param ids\n         */\n        renderPayPalButtons: function (ids) {\n            _.each(ids, function (id) {\n                this.payPalButton(id);\n            }.bind(this));\n        },\n\n        /**\n         * Render PayPal messages\n         */\n        renderPayPalMessages: function () {\n            $('.action-braintree-paypal-message').each(function () {\n                let messages = paypal.Messages({\n                    amount: $(this).data('pp-amount'),\n                    pageType: $(this).data('pp-type'),\n                    style: {\n                        layout: $(this).data('messaging-layout'),\n                        text: {\n                            color:   $(this).data('messaging-text-color')\n                        },\n                        logo: {\n                            type: $(this).data('messaging-logo'),\n                            position: $(this).data('messaging-logo-position')\n                        }\n                    }\n                });\n\n                if ($('#' + $(this).attr('id')).length && $(this).data('messaging-show')) {\n                    messages.render('#' + $(this).attr('id'));\n                }\n            });\n        },\n\n        /**\n         * @param id\n         */\n        payPalButton: function (id) {\n            let data = $('#' + id);\n            let style = {\n                color: data.data('color'),\n                shape: data.data('shape'),\n                size: data.data('size'),\n                layout: data.data('layout'),\n                label: data.data('label')\n            };\n\n            if (data.data('fundingicons')) {\n                style.fundingicons = data.data('fundingicons');\n            }\n\n            if (data.data('layout') === 'horizontal') {\n                style.tagline = data.data('tagline');\n            }\n\n            // Render\n            var button = paypal.Buttons({\n                fundingSource: data.data('funding'),\n                style: style,\n\n                onInit: function (data, actions) {\n                    actions.disable();\n                }\n            });\n            if (!button.isEligible()) {\n                console.log('PayPal button is not elligible');\n                data.parent().remove();\n                return;\n            }\n            if ($('#' + data.attr('id')).length && data.data('show')) {\n                button.render('#' + data.attr('id'));\n            }\n        },\n    }\n});\n","PayPal_Braintree/js/paypalStylingPreview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\nrequire([\n    'underscore',\n    'jquery',\n    'domReady!'\n], function (_, $) {\n    'use strict';\n    let buttonIds = [], currentButtonId = '';\n    let location = '', buttonType = '', buttonShow = '', buttonLayout = '', buttonTagline = '', buttonLabel = '', buttonColor = '', buttonShape = '', buttonSize = '';\n    let messagingShow = '', messagingLayout = '', messagingLogo = '', messagingLogoPosition = '', messagingTextColor = '';\n\n    function getCurrentLocationAndButtonType()\n    {\n        location = $('.payment-location').val();\n        buttonType = $('.' + location + '-button-type').val();\n    }\n\n    $(document).ready(function () {\n        getCurrentLocationAndButtonType();\n\n        $('.payment-location').on('change', function (customEvent) {\n            location = $(this).val();\n            buttonType = $('.' + location + '-button-type').val();\n            buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n            buttonLayout = $('.' + location + '-' + buttonType + '-layout').val();\n            buttonTagline = $('.' + location + '-' + buttonType + '-tagline').val();\n            buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n            buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n            buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n            buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n            updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLayout, buttonTagline, buttonLabel, buttonColor, buttonShape, buttonSize);\n\n            // render pay later messages when location changed\n            messagingShow = $('.' + location + '-messaging-show').val();\n            messagingLayout = $('.' + location + '-messaging-layout').val();\n            messagingLogo = $('.' + location + '-messaging-logo').val();\n            messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n            messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n            renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n            customEvent.stopImmediatePropagation();\n        });\n\n        $(\"select\").change(function () {\n            $(document).on('change', '.' + location + '-button-type', function (customEvent) {\n                buttonType = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLayout = $('.' + location + '-' + buttonType + '-layout').val();\n                buttonTagline = $('.' + location + '-' + buttonType + '-tagline').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLayout, buttonTagline, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-show', function (customEvent) {\n                buttonShow = $(this).val();\n                buttonLayout = $('.' + location + '-' + buttonType + '-layout').val();\n                buttonTagline = $('.' + location + '-' + buttonType + '-tagline').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLayout, buttonTagline, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-layout', function (customEvent) {\n                buttonLayout = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonTagline = $('.' + location + '-' + buttonType + '-tagline').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLayout, buttonTagline, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-tagline', function (customEvent) {\n                buttonTagline = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLayout = $('.' + location + '-' + buttonType + '-layout').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLayout, buttonTagline, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-label', function (customEvent) {\n                buttonLabel = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLayout = $('.' + location + '-' + buttonType + '-layout').val();\n                buttonTagline = $('.' + location + '-' + buttonType + '-tagline').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLayout, buttonTagline, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-color', function (customEvent) {\n                buttonColor = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLayout = $('.' + location + '-' + buttonType + '-layout').val();\n                buttonTagline = $('.' + location + '-' + buttonType + '-tagline').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLayout, buttonTagline, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-shape', function (customEvent) {\n                buttonShape = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLayout = $('.' + location + '-' + buttonType + '-layout').val();\n                buttonTagline = $('.' + location + '-' + buttonType + '-tagline').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonSize = $('.' + location + '-' + buttonType + '-size').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLayout, buttonTagline, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-' + buttonType + '-size', function (customEvent) {\n                buttonSize = $(this).val();\n                buttonShow = $('.' + location + '-' + buttonType + '-show').val();\n                buttonLayout = $('.' + location + '-' + buttonType + '-layout').val();\n                buttonTagline = $('.' + location + '-' + buttonType + '-tagline').val();\n                buttonLabel = $('.' + location + '-' + buttonType + '-label').val();\n                buttonColor = $('.' + location + '-' + buttonType + '-color').val();\n                buttonShape = $('.' + location + '-' + buttonType + '-shape').val();\n\n                updatePayPalButtonStyling(location, buttonType, buttonShow, buttonLayout, buttonTagline, buttonLabel, buttonColor, buttonShape, buttonSize);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-messaging-show', function (customEvent) {\n                messagingShow = $(this).val();\n                messagingLayout = $('.' + location + '-messaging-layout').val();\n                messagingLogo = $('.' + location + '-messaging-logo').val();\n                messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n                messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n                renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-messaging-layout', function (customEvent) {\n                messagingShow = $('.' + location + '-messaging-show').val();\n                messagingLayout = $(this).val();\n                messagingLogo = $('.' + location + '-messaging-logo').val();\n                messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n                messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n                renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + location + '-messaging-logo', function (customEvent) {\n                messagingShow = $('.' + location + '-messaging-show').val();\n                messagingLayout = $('.' + location + '-messaging-layout').val();\n                messagingLogo = $(this).val();\n                messagingLogoPosition = $('.' + location + '-messaging-logo-position').val();\n                messagingTextColor = $('.' + location + '-messaging-text-color').val();\n\n                renderPayLaterMessages(location, messagingShow, messagingLayout, messagingLogo, messagingLogoPosition, messagingTextColor);\n                customEvent.stopImmediatePropagation();\n            });\n\n            $(document).on('change', '.' + locati