require.config({"config": {
        "jsbuild":{"Magento_PageBuilder/js/stage.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"knockout\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/resource/jquery/ui/jquery.ui.touch-punch\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/binding/sortable\", \"Magento_PageBuilder/js/collection\", \"Magento_PageBuilder/js/data-store\", \"Magento_PageBuilder/js/drag-drop/matrix\", \"Magento_PageBuilder/js/master-format/render\", \"Magento_PageBuilder/js/stage-builder\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/utils/promise-deferred\"], function (_jquery, _knockout, _events, _jqueryUi, _mageUtils, _underscore, _sortable, _collection, _dataStore, _matrix, _render, _stageBuilder, _editor, _promiseDeferred) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Stage = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * We always complete a single render when the stage is first loaded, so we can set the lock when the stage is\n     * created. The lock is used to halt the parent forms submission when Page Builder is rendering.\n     */\n\n    /**\n     * Debounce the applyBindings call by 500ms to stop duplicate calls\n     *\n     * @type {(() => void) & _.Cancelable}\n     */\n\n    /**\n     * @param {PageBuilderInterface} pageBuilder\n     * @param {ContentTypeCollectionInterface} rootContainer\n     */\n    function Stage(pageBuilder, rootContainer) {\n      var _this = this;\n\n      this.loading = _knockout.observable(true);\n      this.showBorders = _knockout.observable(false);\n      this.interacting = _knockout.observable(false);\n      this.userSelect = _knockout.observable(true);\n      this.focusChild = _knockout.observable(false);\n      this.dataStore = new _dataStore();\n      this.afterRenderDeferred = (0, _promiseDeferred)();\n      this.renderingLocks = [];\n      this.template = \"Magento_PageBuilder/content-type/preview\";\n      this.collection = new _collection();\n      this.applyBindingsDebounce = _underscore.debounce(function (renderId) {\n        _this.render.applyBindings(_this.rootContainer).then(function (renderedOutput) {\n          if (_this.lastRenderId === renderId) {\n            _events.trigger(\"stage:\" + _this.id + \":masterFormatRenderAfter\", {\n              value: (0, _editor.unescapeDoubleQuoteWithinWidgetDirective)(renderedOutput)\n            });\n\n            _this.renderingLocks.forEach(function (lock) {\n              lock.resolve(renderedOutput);\n            });\n          }\n        }).catch(function (error) {\n          if (error) {\n            console.error(error);\n          }\n        });\n      }, 500);\n      this.pageBuilder = pageBuilder;\n      this.id = pageBuilder.id;\n      this.render = new _render(pageBuilder.id);\n      this.rootContainer = rootContainer;\n      (0, _matrix.generateAllowedParents)(); // Fire an event after the DOM has rendered\n\n      this.afterRenderDeferred.promise.then(function () {\n        _this.render.setupChannel();\n\n        _events.trigger(\"stage:\" + _this.id + \":renderAfter\", {\n          stage: _this\n        });\n      }); // Wait for the stage to be built alongside the stage being rendered\n\n      Promise.all([(0, _stageBuilder)(this, (0, _editor.escapeDoubleQuoteWithinWidgetDirective)(this.pageBuilder.initialValue)), this.afterRenderDeferred.promise]).then(this.ready.bind(this)).catch(function (error) {\n        console.error(error);\n      });\n    }\n    /**\n     * Get template.\n     *\n     * @returns {string}\n     */\n\n\n    var _proto = Stage.prototype;\n\n    _proto.getTemplate = function getTemplate() {\n      return this.template;\n    }\n    /**\n     * The stage has been initiated fully and is ready\n     */\n    ;\n\n    _proto.ready = function ready() {\n      _events.trigger(\"stage:\" + this.id + \":readyAfter\", {\n        stage: this\n      });\n\n      this.loading(false);\n      this.initListeners(); // Ensure we complete an initial save of the data within the stage once we're ready\n\n      _events.trigger(\"stage:updateAfter\", {\n        stageId: this.id\n      });\n    }\n    /**\n     * Init listeners\n     */\n    ;\n\n    _proto.initListeners = function initListeners() {\n      var _this2 = this;\n\n      this.collection.getChildren().subscribe(function () {\n        return _events.trigger(\"stage:updateAfter\", {\n          stageId: _this2.id\n        });\n      }); // ContentType being removed from container\n\n      _events.on(\"contentType:removeAfter\", function (args) {\n        if (args.stageId === _this2.id) {\n          _this2.onContentTypeRemoved(args);\n        }\n      }); // Any store state changes trigger a stage update event\n\n\n      this.dataStore.subscribe(function () {\n        return _events.trigger(\"stage:updateAfter\", {\n          stageId: _this2.id\n        });\n      }); // Watch for stage update events & manipulations to the store, debounce for 50ms as multiple stage changes\n      // can occur concurrently.\n\n      _events.on(\"stage:updateAfter\", function (args) {\n        if (args.stageId === _this2.id) {\n          // Create the rendering lock straight away\n          _this2.createLock();\n\n          var renderId = _mageUtils.uniqueid();\n\n          _this2.lastRenderId = renderId;\n\n          _this2.applyBindingsDebounce(renderId);\n        }\n      });\n\n      var interactionLevel = 0;\n\n      _events.on(\"stage:interactionStart\", function () {\n        ++interactionLevel;\n\n        _this2.interacting(true);\n      });\n\n      _events.on(\"stage:interactionStop\", function (args) {\n        var forced = _underscore.isObject(args) && args.force === true;\n        interactionLevel = Math.max(interactionLevel - 1, 0);\n\n        if (interactionLevel === 0 || forced) {\n          _this2.interacting(false);\n\n          if (forced) {\n            interactionLevel = 0;\n          }\n        }\n      });\n\n      _events.on(\"stage:childFocusStart\", function () {\n        return _this2.focusChild(true);\n      });\n\n      _events.on(\"stage:childFocusStop\", function () {\n        return _this2.focusChild(false);\n      });\n    }\n    /**\n     * Create a new lock for rendering\n     */\n    ;\n\n    _proto.createLock = function createLock() {\n      this.renderingLocks.push(_jquery.Deferred());\n    }\n    /**\n     * On content type removed\n     *\n     * @param params\n     */\n    ;\n\n    _proto.onContentTypeRemoved = function onContentTypeRemoved(params) {\n      if (params.parentContentType) {\n        params.parentContentType.removeChild(params.contentType);\n      }\n    };\n\n    return Stage;\n  }();\n\n  Stage.rootContainerName = \"root-container\";\n  return Stage;\n});\n//# sourceMappingURL=stage.js.map","Magento_PageBuilder/js/template-manager.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"html2canvas\", \"jquery\", \"mage/translate\", \"Magento_PageBuilder/js/modal/confirm-alert\", \"Magento_PageBuilder/js/modal/template-manager-save\", \"text!Magento_PageBuilder/template/modal/template-manager/save-content-modal.html\", \"uiRegistry\", \"underscore\", \"Magento_PageBuilder/js/acl\", \"Magento_PageBuilder/js/config\"], function (_html2canvas, _jquery, _translate, _confirmAlert, _templateManagerSave, _saveContentModal, _uiRegistry, _underscore, _acl, _config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Save the current stage contents as a template\n   *\n   * @param stage\n   */\n  function saveAsTemplate(stage) {\n    if (!(0, _acl.isAllowed)(_acl.resources.TEMPLATE_SAVE)) {\n      (0, _confirmAlert)({\n        content: (0, _translate)(\"You do not have permission to save new templates.\"),\n        title: (0, _translate)(\"Permission Error\")\n      });\n      return false;\n    }\n\n    var capture = createCapture(stage);\n    var prompt = (0, _templateManagerSave)({\n      title: (0, _translate)(\"Save Content as Template\"),\n      promptContentTmpl: _saveContentModal,\n      templateTypes: _config.getConfig(\"stage_config\").template_types,\n      createdForNote: (0, _translate)(\"Created For is to help with filtering templates. This does not restrict where this template can be used.\"),\n      typeLabel: (0, _translate)(\"Created For\"),\n      label: (0, _translate)(\"Template Name\"),\n      validation: true,\n      modalClass: \"template-manager-save\",\n      validationRules: [\"required-entry\"],\n      attributesForm: {\n        novalidate: \"novalidate\",\n        action: \"\"\n      },\n      attributesField: {\n        \"name\": \"name\",\n        \"data-validate\": \"{required:true}\",\n        \"maxlength\": \"255\"\n      },\n      actions: {\n        /**\n         * Handle confirmation of the prompt\n         *\n         * @param {String} name\n         * @param {String} createdFor\n         * @this {actions}\n         */\n        confirm: function confirm(name, createdFor) {\n          return new Promise(function (resolve, reject) {\n            // Wait for the screenshot and the rendering lock to complete before making the request\n            var renderingLock = stage.renderingLocks[stage.renderingLocks.length - 1];\n\n            _jquery.when(capture, renderingLock).then(function (imageSrc, content) {\n              _jquery.ajax({\n                url: _config.getConfig(\"template_save_url\"),\n                data: {\n                  name: name,\n                  template: content,\n                  previewImage: imageSrc,\n                  createdFor: createdFor\n                },\n                method: \"POST\",\n                dataType: \"json\"\n              }).done(function (data) {\n                if (data.status === \"ok\") {\n                  (0, _confirmAlert)({\n                    content: (0, _translate)(\"The current contents of Page Builder has been successfully saved as a template.\"),\n                    title: (0, _translate)(\"Template Saved\")\n                  });\n                  refreshGrid();\n                  resolve();\n                } else if (data.status === \"error\") {\n                  (0, _confirmAlert)({\n                    content: data.message || (0, _translate)(\"An issue occurred while attempting to save \" + \"the template, please try again.\"),\n                    title: (0, _translate)(\"An error occurred\")\n                  });\n                  reject();\n                }\n              }).fail(function () {\n                (0, _confirmAlert)({\n                  content: (0, _translate)(\"An issue occurred while attempting to save the template, \" + \"please try again.\"),\n                  title: (0, _translate)(\"Template Save Error\")\n                });\n                reject();\n              });\n            });\n          });\n        }\n      }\n    }); // Update the UI with the preview image once available\n\n    capture.then(function (imageSrc) {\n      // @ts-ignore\n      prompt.templateManagerSave(\"setPreviewImage\", imageSrc);\n    });\n  }\n  /**\n   * Refresh the grid if it exists\n   */\n\n\n  function refreshGrid() {\n    var templateStageGrid = _uiRegistry.get(\"pagebuilder_stage_template_grid.pagebuilder_stage_template_grid_data_source\");\n\n    if (templateStageGrid) {\n      templateStageGrid.storage().clearRequests();\n      templateStageGrid.reload();\n    }\n  }\n  /**\n   * Create a capture of the stage\n   *\n   * @param stage\n   */\n\n\n  function createCapture(stage) {\n    var scrollY = window.scrollY;\n    var stageElement = document.querySelector(\"#\" + stage.id);\n\n    var deferred = _jquery.Deferred(); // Wait for the stage to complete rendering before taking the capture\n\n\n    var renderingLock = stage.renderingLocks[stage.renderingLocks.length - 1];\n    renderingLock.then(function () {\n      // Resolve issues with Parallax\n      var parallaxRestore = disableParallax(stageElement);\n      stageElement.style.height = (0, _jquery)(stageElement).outerHeight(false) + \"px\";\n      stageElement.classList.add(\"capture\");\n      stageElement.classList.add(\"interacting\");\n\n      if (stage.pageBuilder.isFullScreen()) {\n        window.scrollTo({\n          top: 0\n        });\n      }\n\n      _underscore.defer(function () {\n        (0, _html2canvas)(document.querySelector(\"#\" + stage.id + \" .pagebuilder-canvas\"), {\n          scale: 1,\n          useCORS: true,\n          scrollY: window.pageYOffset * -1\n        }).then(function (canvas) {\n          var imageSrc = canvas.toDataURL(\"image/jpeg\", 0.85);\n          deferred.resolve(imageSrc);\n\n          if (stage.pageBuilder.isFullScreen()) {\n            window.scrollTo({\n              top: scrollY\n            });\n          }\n\n          stageElement.style.height = null;\n          stageElement.classList.remove(\"capture\");\n          stageElement.classList.remove(\"interacting\");\n          restoreParallax(parallaxRestore);\n        });\n      });\n    });\n    return deferred;\n  }\n  /**\n   * Disable the parallax elements in the stage\n   *\n   * @param {Element} stageElement\n   */\n\n\n  function disableParallax(stageElement) {\n    var rowsToReset = [];\n    var parallaxRows = stageElement.querySelectorAll(\"[data-jarallax-original-styles]\");\n\n    _underscore.each(parallaxRows, function (row) {\n      var originalStyles = row.getAttribute(\"data-jarallax-original-styles\");\n      var jarallaxStyle = row.style.cssText;\n      row.style.cssText = originalStyles;\n      var jarallaxContainer = row.querySelector('div[id*=\"jarallax-container\"]');\n      jarallaxContainer.style.display = \"none\";\n      rowsToReset.push({\n        element: row,\n        styles: jarallaxStyle,\n        container: jarallaxContainer\n      });\n    });\n\n    return rowsToReset;\n  }\n  /**\n   * Restore parallax on modified nodes\n   *\n   * @param rows\n   */\n\n\n  function restoreParallax(rows) {\n    _underscore.each(rows, function (_ref) {\n      var element = _ref.element,\n          styles = _ref.styles,\n          container = _ref.container;\n      element.style.cssText = styles;\n      container.style.display = \"\";\n    });\n  }\n\n  return {\n    saveAsTemplate: saveAsTemplate\n  };\n});\n//# sourceMappingURL=template-manager.js.map","Magento_PageBuilder/js/uploader.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/events\", \"uiLayout\", \"uiRegistry\"], function (_events, _uiLayout, _uiRegistry) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Uploader = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * Config data of uploader instance\n     */\n\n    /**\n     * The supplied data store\n     */\n\n    /**\n     * @param {String} name Name to use for lookup reference in registry\n     * @param {Object} uploaderConfig The config used when initializing the Uploader UI component\n     * @param {String} contentTypeId The id of the content type this will be used in\n     * @param {DataStore} dataStore The datastore that the selected image should be stored in.\n     * @param {Object[]} initialValue The value that should be used for the initial state of the component.\n     * @param {Function} onChangeCallback Called when image is added or updated\n     * @param {Function} onDeleteCallback Called when currently set image is deleted from storage\n     */\n    function Uploader(name, uploaderConfig, contentTypeId, dataStore, initialValue, onChangeCallback, onDeleteCallback) {\n      if (onChangeCallback === void 0) {\n        onChangeCallback = null;\n      }\n\n      if (onDeleteCallback === void 0) {\n        onDeleteCallback = null;\n      }\n\n      var config = Object.assign({}, uploaderConfig, {\n        value: initialValue\n      });\n      config.id = contentTypeId;\n      config.name = name;\n      this.dataStore = dataStore;\n\n      _events.on(\"image:\" + contentTypeId + \":uploadAfter\", onChangeCallback ? onChangeCallback : this.onImageChanged.bind(this));\n\n      _events.on(\"image:\" + contentTypeId + \":deleteFileAfter\", onDeleteCallback ? onDeleteCallback : this.onImageDeleted.bind(this));\n\n      this.config = config; // Render uploader\n\n      this.render();\n    }\n    /**\n     * Default callback for upload event\n     * @param {object[]} data\n     */\n\n\n    var _proto = Uploader.prototype;\n\n    _proto.onImageChanged = function onImageChanged(data) {\n      this.dataStore.set(this.config.dataScope.toString(), data);\n    }\n    /**\n     * Default callback for image deleted event\n     */\n    ;\n\n    _proto.onImageDeleted = function onImageDeleted() {\n      this.dataStore.set(this.config.dataScope.toString(), \"\");\n    }\n    /**\n     * Get registry callback reference to uploader UI component\n     *\n     * @returns {Function}\n     */\n    ;\n\n    _proto.getUiComponent = function getUiComponent() {\n      return _uiRegistry.async(this.config.name);\n    }\n    /**\n     * Instantiate uploader through layout UI component renderer\n     */\n    ;\n\n    _proto.render = function render() {\n      (0, _uiLayout)([this.config]);\n    };\n\n    return Uploader;\n  }();\n\n  return Uploader;\n});\n//# sourceMappingURL=uploader.js.map","Magento_PageBuilder/js/widget-initializer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'underscore',\n    'jquery',\n    'mage/apply/main',\n    'Magento_Ui/js/lib/view/utils/dom-observer'\n], function (_, $, mage, domObserver) {\n    'use strict';\n\n    /**\n     * Initializes components assigned to HTML elements.\n     *\n     *\n     * @param {HTMLElement} el\n     * @param {Array} data\n     * @param {Object} breakpoints\n     * @param {Object} currentViewport\n     */\n    function initializeWidget(el, data, breakpoints, currentViewport) {\n        _.each(data, function (config, component) {\n            config = config || {};\n            config.breakpoints = breakpoints;\n            config.currentViewport = currentViewport;\n            mage.applyFor(el, config, component);\n        });\n    }\n\n    return function (data, contextElement) {\n        _.each(data.config, function (componentConfiguration, elementPath) {\n            domObserver.get(\n                elementPath,\n                function (element) {\n                    var $element = $(element);\n\n                    if (contextElement) {\n                        $element = $(contextElement).find(element);\n                    }\n\n                    if ($element.length) {\n                        initializeWidget($element, componentConfiguration, data.breakpoints, data.currentViewport);\n                    }\n                }\n            );\n        });\n    };\n});\n","Magento_PageBuilder/js/binding/draggable.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"knockout\"], function (_jquery, _knockout) {\n  \"use strict\";\n\n  _jquery = _interopRequireDefault(_jquery);\n  _knockout = _interopRequireDefault(_knockout);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  // Create a new sortable Knockout binding\n  _knockout.default.bindingHandlers.draggable = {\n    init: function init(element, valueAccessor) {\n      (0, _jquery.default)(element).draggable(valueAccessor());\n    }\n  };\n});\n//# sourceMappingURL=draggable.js.map","Magento_PageBuilder/js/binding/focus.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\"], function (_knockout) {\n  \"use strict\";\n\n  _knockout = _interopRequireDefault(_knockout);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  _knockout.default.bindingHandlers.hasFocusNoScroll = {\n    init: _knockout.default.bindingHandlers.hasFocus.init,\n    update: function update(element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {\n      var value = !!_knockout.default.utils.unwrapObservable(valueAccessor());\n      value ? element.focus({\n        preventScroll: true\n      }) : element.blur();\n    }\n  };\n});\n//# sourceMappingURL=focus.js.map","Magento_PageBuilder/js/binding/live-edit.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"knockout\", \"Magento_Ui/js/lib/key-codes\", \"underscore\"], function (_jquery, _knockout, _keyCodes, _underscore) {\n  \"use strict\";\n\n  _jquery = _interopRequireDefault(_jquery);\n  _knockout = _interopRequireDefault(_knockout);\n  _keyCodes = _interopRequireDefault(_keyCodes);\n  _underscore = _interopRequireDefault(_underscore);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n\n  /**\n   * Strip HTML and return text\n   *\n   * @param {string} html\n   * @returns {string}\n   */\n  function stripHtml(html) {\n    if (html) {\n      var htmlDocument = new DOMParser().parseFromString(html, \"text/html\");\n      return htmlDocument.body ? htmlDocument.body.textContent : \"\";\n    }\n\n    return html;\n  }\n  /**\n   * Add or remove the placeholder-text class from the element based on its content\n   *\n   * @param {Element} element\n   */\n\n\n  function handlePlaceholderClass(element) {\n    if (stripHtml(element.innerHTML).length === 0) {\n      element.innerHTML = \"\";\n      element.classList.add(\"placeholder-text\");\n    } else {\n      element.classList.remove(\"placeholder-text\");\n    }\n  } // Custom Knockout binding for live editing text inputs\n\n\n  _knockout.default.bindingHandlers.liveEdit = {\n    /**\n     * Init the live edit binding on an element\n     *\n     * @param {HTMLElement} element\n     * @param {() => any} valueAccessor\n     * @param {KnockoutAllBindingsAccessor} allBindings\n     * @param {any} viewModel\n     * @param {KnockoutBindingContext} bindingContext\n     */\n    init: function init(element, valueAccessor, allBindings, viewModel, bindingContext) {\n      var _valueAccessor = valueAccessor(),\n          field = _valueAccessor.field,\n          placeholder = _valueAccessor.placeholder,\n          _valueAccessor$select = _valueAccessor.selectAll,\n          selectAll = _valueAccessor$select === void 0 ? false : _valueAccessor$select;\n\n      var focusedValue = element.innerHTML;\n      var previouslyFocused = false;\n      var blurTimeout;\n      var lastUpdateValue;\n      /**\n       * Record the value on focus, only conduct an update when data changes\n       */\n\n      var onFocus = function onFocus() {\n        clearTimeout(blurTimeout);\n        focusedValue = stripHtml(element.innerHTML);\n        lastUpdateValue = focusedValue;\n\n        if (selectAll && element.innerHTML !== \"\" && !previouslyFocused) {\n          _underscore.default.defer(function () {\n            var selection = window.getSelection();\n            var range = document.createRange();\n            range.selectNodeContents(element);\n            selection.removeAllRanges();\n            selection.addRange(range);\n            previouslyFocused = true;\n          });\n        }\n      };\n      /**\n       * On blur change our timeout for previously focused. We require a flag to track whether the input has been\n       * focused and selected previously due to a bug in Firefox which doesn't handle focus events correctly when\n       * contenteditable is placed within an anchor.\n       */\n\n\n      var onBlur = function onBlur() {\n        blurTimeout = setTimeout(function () {\n          previouslyFocused = false;\n        }, 100);\n      };\n      /**\n       * Mousedown event on element\n       *\n       * @param {Event} event\n       */\n\n\n      var onMouseDown = function onMouseDown(event) {\n        event.stopPropagation();\n      };\n      /**\n       * Key down event on element\n       *\n       * Prevent styling such as bold, italic, and underline using keyboard commands, and prevent multi-line entries\n       *\n       * @param {JQueryEventObject} event\n       */\n\n\n      var onKeyDown = function onKeyDown(event) {\n        var key = _keyCodes.default[event.keyCode]; // command or control\n\n        if (event.metaKey || event.ctrlKey) {\n          if (key === \"bKey\" || key === \"iKey\" || key === \"uKey\") {\n            event.preventDefault();\n          }\n        }\n\n        if (key === \"enterKey\") {\n          event.preventDefault();\n        } // prevent slides from sliding\n\n\n        if (key === \"pageLeftKey\" || key === \"pageRightKey\") {\n          event.stopPropagation();\n        }\n      };\n      /**\n       * On key up update the view model to ensure all changes are saved\n       */\n\n\n      var onKeyUp = function onKeyUp() {\n        var strippedValue = stripHtml(element.innerHTML);\n\n        if (focusedValue !== strippedValue) {\n          lastUpdateValue = strippedValue;\n          viewModel.updateData(field, strippedValue);\n        }\n      };\n      /**\n       * Prevent content from being dropped inside of inline edit area\n       *\n       * @param {DragEvent} event\n       */\n\n\n      var onDrop = function onDrop(event) {\n        event.preventDefault();\n      };\n      /**\n       * Prevent content from being dragged\n       *\n       * @param {DragEvent} event\n       */\n\n\n      var onDragStart = function onDragStart(event) {\n        event.preventDefault();\n      };\n      /**\n       * Input event on element\n       */\n\n\n      var onInput = function onInput() {\n        handlePlaceholderClass(element);\n      };\n      /**\n       * On paste strip any HTML\n       */\n\n\n      var onPaste = function onPaste() {\n        // Record the original caret position so we can ensure we restore it at the correct position\n        var selection = window.getSelection();\n        var originalPositionStart = selection.getRangeAt(0).cloneRange().startOffset;\n        var originalPositionEnd = selection.getRangeAt(0).cloneRange().endOffset;\n        var originalContentLength = stripHtml(element.innerHTML).length; // Allow the paste action to update the content\n\n        _underscore.default.defer(function () {\n          var strippedValue = stripHtml(element.innerHTML);\n          lastUpdateValue = strippedValue;\n          element.textContent = strippedValue;\n          /**\n           * Calculate the position the caret should end up at, the difference in string length + the original\n           * end offset position\n           */\n\n          var restoredPosition = Math.abs(strippedValue.length - originalContentLength) + originalPositionStart; // If part of the text was selected adjust the position for the removed text\n\n          if (originalPositionStart !== originalPositionEnd) {\n            restoredPosition += Math.abs(originalPositionEnd - originalPositionStart);\n          }\n\n          var range = document.createRange();\n          range.setStart(element.childNodes[0], restoredPosition);\n          range.setEnd(element.childNodes[0], restoredPosition);\n          selection.removeAllRanges();\n          selection.addRange(range);\n        });\n      };\n\n      element.setAttribute(\"data-placeholder\", placeholder);\n      element.textContent = viewModel.contentType.dataStore.get(field);\n      element.contentEditable = \"true\";\n      element.addEventListener(\"focus\", onFocus);\n      element.addEventListener(\"blur\", onBlur);\n      element.addEventListener(\"mousedown\", onMouseDown);\n      element.addEventListener(\"keydown\", onKeyDown);\n      element.addEventListener(\"keyup\", onKeyUp);\n      element.addEventListener(\"input\", onInput);\n      element.addEventListener(\"drop\", onDrop);\n      element.addEventListener(\"paste\", onPaste);\n      element.addEventListener(\"dragstart\", onDragStart);\n      (0, _jquery.default)(element).parent().css(\"cursor\", \"text\");\n      handlePlaceholderClass(element); // Create a subscription onto the original data to update the internal value\n\n      viewModel.contentType.dataStore.subscribe(function (data) {\n        // Only update the value if it differs from the last value added within live edit\n        if (lastUpdateValue !== data[field]) {\n          lastUpdateValue = data[field];\n          element.textContent = data[field];\n          handlePlaceholderClass(element);\n        }\n      }, field); // Resolve issues of content editable being within an anchor\n\n      if ((0, _jquery.default)(element).parent().is(\"a\")) {\n        (0, _jquery.default)(element).parent().attr(\"draggable\", \"false\");\n      }\n    },\n\n    /**\n     * Update live edit binding on an element\n     *\n     * @param {any} element\n     * @param {() => any} valueAccessor\n     * @param {KnockoutAllBindingsAccessor} allBindings\n     * @param {any} viewModel\n     * @param {KnockoutBindingContext} bindingContext\n     */\n    update: function update(element, valueAccessor, allBindings, viewModel, bindingContext) {\n      var _valueAccessor2 = valueAccessor(),\n          field = _valueAccessor2.field;\n\n      element.textContent = viewModel.contentType.dataStore.get(field);\n      handlePlaceholderClass(element);\n    }\n  };\n});\n//# sourceMappingURL=live-edit.js.map","Magento_PageBuilder/js/binding/master-style.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/style-registry\"], function (_knockout, _mageUtils, _underscore, _config, _styleRegistry) {\n  \"use strict\";\n\n  _knockout = _interopRequireDefault(_knockout);\n  _mageUtils = _interopRequireDefault(_mageUtils);\n  _underscore = _interopRequireDefault(_underscore);\n  _config = _interopRequireDefault(_config);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var bodyId = _config.default.getConfig(\"bodyId\");\n\n  var getStyles = function getStyles(styleObject) {\n    var styles = {};\n\n    _knockout.default.utils.objectForEach(styleObject, function (styleName, styleValue) {\n      styleValue = _knockout.default.utils.unwrapObservable(styleValue);\n\n      if (styleValue === null || styleValue === undefined || styleValue === false) {\n        // Empty string removes the value, whereas null/undefined have no effect\n        styleValue = \"\";\n      }\n\n      if (styleValue) {\n        styles[styleName] = styleValue;\n      }\n    });\n\n    return styles;\n  };\n\n  _knockout.default.bindingHandlers.style = {\n    update: function update(element, valueAccessor, allBindings, viewModel, bindingContext) {\n      var value = _knockout.default.utils.unwrapObservable(valueAccessor() || {});\n\n      var viewportKeys = _underscore.default.keys(_config.default.getConfig(\"viewports\"));\n\n      var commonStyles = getStyles(_underscore.default.omit(value, viewportKeys));\n      var viewportStyles = {};\n\n      _underscore.default.each(viewportKeys, function (name) {\n        viewportStyles[name] = _underscore.default.extend(getStyles(value[name]), commonStyles);\n      });\n\n      if (_underscore.default.findKey(viewportStyles, function (styles) {\n        return !_underscore.default.isEmpty(styles);\n      })) {\n        var id = _mageUtils.default.uniqueid();\n\n        var selector = \"#\" + bodyId + \" [\" + _styleRegistry.pbStyleAttribute + \"=\\\"\" + id + \"\\\"]\";\n\n        _underscore.default.each(viewportKeys, function (name) {\n          var registry = (0, _styleRegistry.getStyleRegistry)(name + bindingContext.$root.id);\n          registry.setStyles(selector, viewportStyles[name]);\n        });\n\n        element.setAttribute(_styleRegistry.pbStyleAttribute, id);\n      }\n    }\n  };\n});\n//# sourceMappingURL=master-style.js.map","Magento_PageBuilder/js/binding/sortable-children.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"knockout\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/drag-drop/move-content-type\", \"Magento_PageBuilder/js/utils/array\"], function (_jquery, _knockout, _events, _moveContentType, _array) {\n  \"use strict\";\n\n  _jquery = _interopRequireDefault(_jquery);\n  _knockout = _interopRequireDefault(_knockout);\n  _events = _interopRequireDefault(_events);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var draggedContentType; // Create a new sortable Knockout binding\n\n  _knockout.default.bindingHandlers.sortableChildren = {\n    /**\n     * Init the draggable binding on an element\n     *\n     * @param element\n     * @param valueAccessor\n     * @param allBindingsAccessor\n     * @param data\n     * @param context\n     */\n    init: function init(element, valueAccessor, allBindingsAccessor, data, context) {\n      var instance = context.$data.contentType;\n\n      var options = _knockout.default.unwrap(valueAccessor());\n\n      var originalPosition;\n      (0, _jquery.default)(element).sortable(options).on(\"sortstart\", function (event, ui) {\n        originalPosition = ui.item.index();\n        draggedContentType = instance.children()[originalPosition];\n\n        _events.default.trigger(\"childContentType:sortStart\", {\n          instance: instance,\n          originalPosition: originalPosition,\n          ui: ui\n        });\n      }).on(\"sortstop\", function (event, ui) {\n        _events.default.trigger(\"childContentType:sortStop\", {\n          instance: instance,\n          ui: ui,\n          originalPosition: originalPosition\n        });\n      }).on(\"sortupdate\", function (event, ui) {\n        if (this === ui.item.parent()[0]) {\n          var index = ui.item.index();\n\n          var targetParent = _knockout.default.dataFor(ui.item.parent()[0]).contentType;\n\n          if (targetParent && (originalPosition !== index || draggedContentType.parentContentType !== targetParent)) {\n            ui.item.remove();\n\n            if (draggedContentType.parentContentType === targetParent) {\n              (0, _array.moveArrayItem)(instance.children, originalPosition, index);\n            } else {\n              (0, _moveContentType.moveContentType)(draggedContentType, index, targetParent);\n            }\n\n            _events.default.trigger(\"childContentType:sortUpdate\", {\n              instance: instance,\n              newPosition: index,\n              originalPosition: originalPosition,\n              ui: ui,\n              event: event\n            });\n          }\n        }\n      });\n    }\n  };\n});\n//# sourceMappingURL=sortable-children.js.map","Magento_PageBuilder/js/binding/sortable.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"knockout\", \"underscore\"], function (_jquery, _knockout, _underscore) {\n  \"use strict\";\n\n  _jquery = _interopRequireDefault(_jquery);\n  _knockout = _interopRequireDefault(_knockout);\n  _underscore = _interopRequireDefault(_underscore);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  // Create a new sortable Knockout binding\n  _knockout.default.bindingHandlers.sortable = {\n    init: function init(element, valueAccessor) {\n      // As we can't conditionally apply bindings we block this operation when options are null\n      if (valueAccessor() === null) {\n        return;\n      }\n\n      _underscore.default.defer(function () {\n        (0, _jquery.default)(element).sortable(valueAccessor());\n      });\n    }\n  };\n});\n//# sourceMappingURL=sortable.js.map","Magento_PageBuilder/js/binding/style.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/style-registry\"], function (_knockout, _mageUtils, _underscore, _config, _styleRegistry) {\n  \"use strict\";\n\n  _knockout = _interopRequireDefault(_knockout);\n  _mageUtils = _interopRequireDefault(_mageUtils);\n  _underscore = _interopRequireDefault(_underscore);\n  _config = _interopRequireDefault(_config);\n\n  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var originalStyle = _knockout.default.bindingHandlers.style;\n\n  var bodyId = _config.default.getConfig(\"bodyId\");\n\n  function isPageBuilderContext(context) {\n    return !!(context.stage && context.stage.pageBuilder);\n  }\n\n  _knockout.default.bindingHandlers.style = {\n    init: function init(element, valueAccessor, allBindings, viewModel, bindingContext) {\n      if (isPageBuilderContext(bindingContext)) {\n        element.setAttribute(_styleRegistry.pbStyleAttribute, _mageUtils.default.uniqueid());\n      }\n    },\n    update: function update(element, valueAccessor, allBindings, viewModel, bindingContext) {\n      if (isPageBuilderContext(bindingContext)) {\n        var value = _knockout.default.utils.unwrapObservable(valueAccessor() || {});\n\n        var styles = {};\n        var styleId = element.getAttribute(_styleRegistry.pbStyleAttribute);\n        var existedStyleBlock = document.querySelector(\"style[\" + _styleRegistry.styleDataAttribute + \"=\\\"\" + styleId + \"\\\"]\");\n\n        _knockout.default.utils.objectForEach(value, function (styleName, styleValue) {\n          styleValue = _knockout.default.utils.unwrapObservable(styleValue);\n\n          if (styleValue === null || styleValue === undefined || styleValue === false) {\n            styleValue = \"\";\n          }\n\n          if (styleValue) {\n            styles[styleName] = styleValue;\n          }\n        });\n\n        if (existedStyleBlock) {\n          existedStyleBlock.remove();\n        }\n\n        if (!_underscore.default.isEmpty(styles)) {\n          var styleElement = document.createElement(\"style\");\n          styleElement.setAttribute(_styleRegistry.styleDataAttribute, styleId);\n          styleElement.innerHTML = (0, _styleRegistry.generateCssBlock)(\"#\" + bodyId + \" [\" + _styleRegistry.pbStyleAttribute + \"=\\\"\" + styleId + \"\\\"]\", styles);\n          element.parentElement.append(styleElement);\n        }\n      } else {\n        originalStyle.update(element, valueAccessor, allBindings, viewModel, bindingContext);\n      }\n    }\n  };\n});\n//# sourceMappingURL=style.js.map","Magento_PageBuilder/js/content-type/appearance-config.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\"], function (_config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Get config for appearance\n   *\n   * @param {string} contentType\n   * @param {string} appearance\n   * @returns {ContentTypeConfigAppearanceInterface}\n   * @api\n   */\n  function getAppearanceConfig(contentType, appearance) {\n    var contentTypeConfig = _config.getContentTypeConfig(contentType);\n\n    var config;\n\n    if (contentTypeConfig.appearances !== undefined) {\n      if (!appearance) {\n        for (var key in contentTypeConfig.appearances) {\n          if (!!contentTypeConfig.appearances[key].default) {\n            appearance = key;\n            break;\n          }\n        }\n      }\n\n      if (appearance) {\n        config = contentTypeConfig.appearances[appearance];\n      }\n    }\n\n    return config;\n  }\n\n  return getAppearanceConfig;\n});\n//# sourceMappingURL=appearance-config.js.map","Magento_PageBuilder/js/content-type/converter-resolver.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Resolve converter\n   *\n   * @param {DataMappingInterface} config\n   * @return string\n   */\n  function resolve(config) {\n    return config.converter;\n  }\n\n  return resolve;\n});\n//# sourceMappingURL=converter-resolver.js.map","Magento_PageBuilder/js/content-type/master-collection.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type/master\"], function (_master) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var MasterCollection = /*#__PURE__*/function (_master2) {\n    \"use strict\";\n\n    _inheritsLoose(MasterCollection, _master2);\n\n    function MasterCollection() {\n      return _master2.apply(this, arguments) || this;\n    }\n\n    _createClass(MasterCollection, [{\n      key: \"masterTemplate\",\n      get:\n      /**\n       * Retrieve the child template\n       *\n       * @returns {string}\n       */\n      function get() {\n        return \"Magento_PageBuilder/content-type/master-collection\";\n      }\n    }]);\n\n    return MasterCollection;\n  }(_master);\n\n  return MasterCollection;\n});\n//# sourceMappingURL=master-collection.js.map","Magento_PageBuilder/js/content-type/master-factory.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/loader\", \"Magento_PageBuilder/js/content-type/converter-resolver\", \"Magento_PageBuilder/js/content-type/observable-updater-factory\"], function (_loader, _converterResolver, _observableUpdaterFactory) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create new content instance\n   *\n   * @param {ContentTypeInterface | ContentTypeCollectionInterface} contentType\n   * @param {ContentTypeConfigInterface} config\n   * @returns {Promise<ContentTypeInterface>}\n   */\n  function create(contentType, config) {\n    return new Promise(function (resolve, reject) {\n      (0, _observableUpdaterFactory)(config, _converterResolver).then(function (observableUpdater) {\n        (0, _loader)([config.master_component], function (masterComponent) {\n          try {\n            var master = new masterComponent(contentType, observableUpdater);\n            resolve(master);\n          } catch (error) {\n            reject(\"Error within master component (\" + config.master_component + \") for \" + config.name + \".\");\n            console.error(error);\n          }\n        }, function (error) {\n          reject(\"Unable to load preview component (\" + config.master_component + \") for \" + config.name + \". Please \" + \"check preview component exists and content type configuration is correct.\");\n          console.error(error);\n        });\n      }).catch(function (error) {\n        console.error(error);\n        return null;\n      });\n    });\n  }\n\n  return create;\n});\n//# sourceMappingURL=master-factory.js.map","Magento_PageBuilder/js/content-type/master.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\", \"Magento_PageBuilder/js/content-type/appearance-config\"], function (_underscore, _object, _appearanceConfig) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Master = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param {ContentTypeInterface} contentType\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Master(contentType, observableUpdater) {\n      this.data = {};\n      this.contentType = contentType;\n      this.observableUpdater = observableUpdater;\n      this.bindEvents();\n    }\n    /**\n     * Retrieve the render template\n     *\n     * @returns {string}\n     */\n\n\n    var _proto = Master.prototype;\n\n    /**\n     * Get content type data\n     *\n     * @param {string} element\n     * @returns {DataObject}\n     * @deprecated\n     */\n    _proto.getData = function getData(element) {\n      var data = _underscore.extend({}, this.contentType.dataStore.getState());\n\n      if (undefined === element) {\n        return data;\n      }\n\n      var appearanceConfiguration = (0, _appearanceConfig)(this.contentType.config.name, data.appearance);\n      var config = appearanceConfiguration.elements;\n      data = this.observableUpdater.convertData(data, appearanceConfiguration.converters);\n      var result = {};\n\n      if (undefined !== config[element].tag.var) {\n        result[config[element].tag.var] = (0, _object.get)(data, config[element].tag.var);\n      }\n\n      return result;\n    }\n    /**\n     * Destroys current instance\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      return;\n    }\n    /**\n     * Attach event to updating data in data store to update observables\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this = this;\n\n      this.contentType.dataStore.subscribe(function () {\n        _this.updateObservables();\n      });\n    }\n    /**\n     * After observables updated, allows to modify observables\n     */\n    ;\n\n    _proto.afterObservablesUpdated = function afterObservablesUpdated() {\n      return;\n    }\n    /**\n     * Update observables\n     *\n     * @deprecated\n     */\n    ;\n\n    _proto.updateObservables = function updateObservables() {\n      this.observableUpdater.update(this, _underscore.extend({\n        name: this.contentType.config.name\n      }, this.contentType.dataStore.getState()), this.contentType.getDataStoresStates());\n      this.afterObservablesUpdated();\n    };\n\n    _createClass(Master, [{\n      key: \"template\",\n      get: function get() {\n        return (0, _appearanceConfig)(this.contentType.config.name, this.getData().appearance).master_template;\n      }\n    }]);\n\n    return Master;\n  }();\n\n  return Master;\n});\n//# sourceMappingURL=master.js.map","Magento_PageBuilder/js/content-type/observable-updater-factory.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/converter/converter-pool-factory\", \"Magento_PageBuilder/js/mass-converter/converter-pool-factory\", \"Magento_PageBuilder/js/content-type/observable-updater\"], function (_converterPoolFactory, _converterPoolFactory2, _observableUpdater) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create new observable updater instance\n   *\n   * @param {ContentTypeConfigInterface} config\n   * @param {Function} converterResolver\n   * @returns {Promise<ObservableUpdater>}\n   */\n  function create(config, converterResolver) {\n    var promises = [(0, _converterPoolFactory)(config.name), (0, _converterPoolFactory2)(config.name)];\n    return new Promise(function (resolve) {\n      Promise.all(promises).then(function (resolvedPromises) {\n        var converterPool = resolvedPromises[0],\n            massConverterPool = resolvedPromises[1];\n        resolve(new _observableUpdater(converterPool, massConverterPool, converterResolver));\n      }).catch(function (error) {\n        console.error(error);\n        return null;\n      });\n    });\n  }\n\n  return create;\n});\n//# sourceMappingURL=observable-updater-factory.js.map","Magento_PageBuilder/js/content-type/observable-updater.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"consoleLogger\", \"knockout\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/appearance-config\", \"Magento_PageBuilder/js/content-type/observable-updater/attributes\", \"Magento_PageBuilder/js/content-type/observable-updater/css\", \"Magento_PageBuilder/js/content-type/observable-updater/html\", \"Magento_PageBuilder/js/content-type/observable-updater/style\"], function (_consoleLogger, _knockout, _underscore, _config, _appearanceConfig, _attributes, _css, _html, _style) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ObservableUpdater = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param {typeof ConverterPool} converterPool\n     * @param {typeof MassConverterPool} massConverterPool\n     * @param {(config: object) => string} converterResolver\n     */\n    function ObservableUpdater(converterPool, massConverterPool, converterResolver) {\n      this.previousData = {};\n      this.bindingGenerators = {\n        attributes: _attributes,\n        css: _css,\n        html: _html,\n        style: _style\n      };\n      this.converterPool = converterPool;\n      this.massConverterPool = massConverterPool;\n      this.converterResolver = converterResolver;\n    }\n    /**\n     * Update the associated viewModel with the generated data\n     *\n     * We create an API for each potential binding and make it available in the master and preview templates through\n     * the data variable. Each data variable will have associated observables that are updated on a data change.\n     *\n     * @param {Preview} viewModel\n     * @param {DataObject} data\n     * @param {DataObject} dataStores\n     */\n\n\n    var _proto = ObservableUpdater.prototype;\n\n    _proto.update = function update(viewModel, data, dataStores) {\n      var appearance = data && data.appearance !== undefined ? data.appearance : undefined;\n      var appearanceConfiguration = (0, _appearanceConfig)(viewModel.contentType.config.name, appearance);\n\n      if (undefined === appearanceConfiguration || undefined === appearanceConfiguration.elements) {\n        return;\n      } // Generate Knockout bindings in objects for usage in preview and master templates\n\n\n      var generatedBindings = this.generateKnockoutBindings(appearanceConfiguration.elements, appearanceConfiguration.converters, data, dataStores);\n\n      var _loop = function _loop(element) {\n        if (generatedBindings.hasOwnProperty(element)) {\n          // Ensure every element is represented by an object\n          if (viewModel.data[element] === undefined) {\n            viewModel.data[element] = {};\n          }\n          /**\n           * Iterate through each elements data (css, style, attributes) and apply data updates within the\n           * observable. If no observable already exists create a new one.\n           */\n\n\n          Object.keys(generatedBindings[element]).forEach(function (key) {\n            var elementBindings = viewModel.data[element][key];\n\n            if (elementBindings !== undefined && _knockout.isObservable(elementBindings)) {\n              elementBindings(generatedBindings[element][key]);\n            } else {\n              viewModel.data[element][key] = _knockout.observable(generatedBindings[element][key]);\n            }\n          });\n        }\n      };\n\n      for (var element in generatedBindings) {\n        _loop(element);\n      }\n    }\n    /**\n     * Generate binding object to be applied to master format\n     *\n     * This function iterates through each element defined in the content types XML and generates a nested object of\n     * the associated Knockout binding data. We support 5 bindings attributes, style, css, html & tag.\n     *\n     * @param elements\n     * @param converters\n     * @param data\n     * @param dataStoreStates\n     */\n    ;\n\n    _proto.generateKnockoutBindings = function generateKnockoutBindings(elements, converters, data, dataStoreStates) {\n      var convertedData = this.convertData(data, converters);\n      var generatedData = {};\n\n      for (var _i = 0, _Object$keys = Object.keys(elements); _i < _Object$keys.length; _i++) {\n        var elementName = _Object$keys[_i];\n        var elementConfig = elements[elementName];\n\n        if (this.previousData[elementName] === undefined) {\n          this.previousData[elementName] = {};\n        }\n\n        generatedData[elementName] = {\n          attributes: this.generateKnockoutBinding(\"attributes\", elementName, elementConfig, data),\n          style: _config.getMode() === \"Preview\" ? this.generateKnockoutBinding(\"style\", elementName, elementConfig, data) : this.generateKnockoutBindingForBreakpoints(\"style\", elementName, elementConfig, data, dataStoreStates),\n          css: elementConfig.css.var in convertedData ? this.generateKnockoutBinding(\"css\", elementName, elementConfig, data) : {},\n          html: this.generateKnockoutBinding(\"html\", elementName, elementConfig, data)\n        };\n\n        if (elementConfig.tag !== undefined && elementConfig.tag.var !== undefined) {\n          if (generatedData[elementName][elementConfig.tag.var] === undefined) {\n            generatedData[elementName][elementConfig.tag.var] = \"\";\n          }\n\n          generatedData[elementName][elementConfig.tag.var] = convertedData[elementConfig.tag.var];\n        }\n      }\n\n      return generatedData;\n    }\n    /**\n     * Process data for elements before its converted to knockout format\n     *\n     * @param {object} data\n     * @param {ConverterInterface[]} convertersConfig\n     * @returns {object}\n     */\n    ;\n\n    _proto.convertData = function convertData(data, convertersConfig) {\n      for (var _iterator = _createForOfIteratorHelperLoose(convertersConfig), _step; !(_step = _iterator()).done;) {\n        var converterConfig = _step.value;\n        this.massConverterPool.get(converterConfig.component).toDom(data, converterConfig.config);\n      }\n\n      return data;\n    }\n    /**\n     * Generate an individual knockout binding\n     *\n     * @param binding\n     * @param elementName\n     * @param config\n     * @param data\n     */\n    ;\n\n    _proto.generateKnockoutBinding = function generateKnockoutBinding(binding, elementName, config, data) {\n      if (config[binding] === undefined) {\n        return {};\n      }\n\n      var previousData = {};\n\n      if (this.previousData[elementName][binding] !== undefined) {\n        previousData = this.previousData[elementName][binding];\n      }\n\n      if (this.bindingGenerators[binding] === undefined) {\n        _consoleLogger.error(\"Unable to find Knockout binding generator for \" + binding);\n\n        return {};\n      } // Generate the associated binding using our dedicated generators\n\n\n      var generatedBindingData = this.bindingGenerators[binding](elementName, config, data, this.converterResolver, this.converterPool, previousData);\n      this.previousData[elementName][binding] = generatedBindingData;\n      return generatedBindingData;\n    }\n    /**\n     * Generate an individual knockout binding for breakpoints\n     *\n     * @param binding\n     * @param elementName\n     * @param config\n     * @param data\n     * @param dataStoreStates\n     */\n    ;\n\n    _proto.generateKnockoutBindingForBreakpoints = function generateKnockoutBindingForBreakpoints(binding, elementName, config, data, dataStoreStates) {\n      var _this = this;\n\n      var result = {};\n      Object.keys(dataStoreStates).forEach(function (name) {\n        result[name] = _underscore.isEmpty(dataStoreStates[name]) ? {} : _this.generateKnockoutBinding(binding, elementName, config, dataStoreStates[name]);\n      });\n      return result;\n    };\n\n    return ObservableUpdater;\n  }();\n\n  return ObservableUpdater;\n});\n//# sourceMappingURL=observable-updater.js.map","Magento_PageBuilder/js/content-type/preview-collection.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type/preview\"], function (_config, _contentTypeFactory, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var PreviewCollection = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(PreviewCollection, _preview2);\n\n    function PreviewCollection() {\n      return _preview2.apply(this, arguments) || this;\n    }\n\n    var _proto = PreviewCollection.prototype;\n\n    /**\n     * Duplicate a collection content type\n     *\n     * @param {ContentTypeCollectionInterface} contentType\n     * @param {boolean} autoAppend\n     * @param {boolean} direct\n     * @returns {Promise<ContentTypeCollectionInterface> | void}\n     */\n    _proto.clone = function clone(contentType, autoAppend, direct) {\n      var _this = this;\n\n      if (autoAppend === void 0) {\n        autoAppend = true;\n      }\n\n      if (direct === void 0) {\n        direct = false;\n      }\n\n      var defaultViewport = _config.getConfig(\"defaultViewport\");\n\n      var index = contentType.parentContentType.getChildren().indexOf(contentType) + 1 || null;\n      var childrenLength = contentType.children ? contentType.children().length : 0;\n      return new Promise(function (resolve, reject) {\n        (0, _contentTypeFactory)(contentType.config, contentType.parentContentType, contentType.stageId, contentType.dataStores[defaultViewport].getState(), childrenLength, contentType.getDataStoresStates()).then(function (duplicate) {\n          if (contentType.children && contentType.children().length > 0) {\n            // Duplicate the instances children into the new duplicate\n            contentType.children().forEach(function (subChild) {\n              var subChildClone = duplicate.preview.clone(subChild, false);\n\n              if (subChildClone) {\n                subChildClone.then(function (duplicateSubChild) {\n                  duplicateSubChild.parentContentType = duplicate;\n                  duplicate.addChild(duplicateSubChild);\n                });\n              } else {\n                reject(\"Unable to duplicate sub child.\");\n              }\n            });\n          }\n\n          if (autoAppend) {\n            contentType.parentContentType.addChild(duplicate, index);\n          }\n\n          _this.dispatchContentTypeCloneEvents(contentType, duplicate, index, direct);\n\n          resolve(duplicate);\n        });\n      });\n    }\n    /**\n     * Tries to call specified method of a current content type,\n     * and delegates attempt to its' children.\n     * @param args\n     */\n    ;\n\n    _proto.delegate = function delegate() {\n      var _preview2$prototype$d;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      (_preview2$prototype$d = _preview2.prototype.delegate).call.apply(_preview2$prototype$d, [this].concat(args));\n\n      this.contentType.getChildren()().forEach(function (elem) {\n        elem.preview.delegate.apply(elem.preview, args);\n      });\n    }\n    /**\n     * Does the current instance have any children or values different from the default for it's type?\n     *\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.isConfigured = function isConfigured() {\n      if (this.contentType.children().length > 0) {\n        return true;\n      }\n\n      return _preview2.prototype.isConfigured.call(this);\n    };\n\n    _createClass(PreviewCollection, [{\n      key: \"childTemplate\",\n      get:\n      /**\n       * Retrieve the preview child template\n       *\n       * @returns {string}\n       */\n      function get() {\n        return \"Magento_PageBuilder/content-type/preview-collection\";\n      }\n    }]);\n\n    return PreviewCollection;\n  }(_preview);\n\n  return PreviewCollection;\n});\n//# sourceMappingURL=preview-collection.js.map","Magento_PageBuilder/js/content-type/preview-converter-resolver.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Resolve converter\n   *\n   * @param {DataMappingStyleInterface} config\n   * @return string\n   */\n  function resolve(config) {\n    return config.preview_converter ? config.preview_converter : config.converter;\n  }\n\n  return resolve;\n});\n//# sourceMappingURL=preview-converter-resolver.js.map","Magento_PageBuilder/js/content-type/preview-factory.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/loader\", \"Magento_PageBuilder/js/content-type/observable-updater-factory\", \"Magento_PageBuilder/js/content-type/preview-converter-resolver\"], function (_loader, _observableUpdaterFactory, _previewConverterResolver) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create new preview instance\n   *\n   * @param {ContentTypeInterface | ContentTypeCollectionInterface} contentType\n   * @param {ContentTypeConfigInterface} config\n   * @returns {Promise<Preview | PreviewCollection>}\n   */\n  function create(contentType, config) {\n    return new Promise(function (resolve, reject) {\n      (0, _observableUpdaterFactory)(config, _previewConverterResolver).then(function (observableUpdater) {\n        (0, _loader)([config.preview_component], function (previewComponent) {\n          try {\n            var preview = new previewComponent(contentType, config, observableUpdater);\n            resolve(preview);\n          } catch (error) {\n            reject(\"Error within preview component (\" + config.preview_component + \") for \" + config.name + \".\");\n            console.error(error);\n          }\n        }, function (error) {\n          reject(\"Unable to load preview component (\" + config.preview_component + \") for \" + config.name + \". Please \" + \"check preview component exists and content type configuration is correct.\");\n          console.error(error);\n        });\n      }).catch(function (error) {\n        console.error(error);\n        return null;\n      });\n    });\n  }\n\n  return create;\n});\n//# sourceMappingURL=preview-factory.js.map","Magento_PageBuilder/js/content-type/preview-styles.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/content-type/style-registry\"], function (_knockout, _events, _styleRegistry) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var PreviewStyles =\n  /*#__PURE__*/\n  function () {\n    \"use strict\";\n\n    function PreviewStyles(stageId) {\n      var _this = this;\n\n      this.styleBlocks = _knockout.observableArray([]);\n      this.template = \"Magento_PageBuilder/content-type/preview-styles\";\n      this.stageId = stageId;\n\n      _events.on(\"styles:update\", function (args) {\n        if (args.stageId === _this.stageId) {\n          var css = (0, _styleRegistry.generateCssBlock)(args.className, args.styles); // Remove any existing style blocks for the current class name\n\n          var existingBlock = _this.styleBlocks().find(function (block) {\n            return block.className === args.className;\n          });\n\n          if (existingBlock) {\n            // Don't do an update if the CSS matches\n            if (existingBlock.css === css) {\n              return;\n            }\n\n            _this.styleBlocks.splice(_this.styleBlocks().indexOf(existingBlock), 1);\n          }\n\n          _this.styleBlocks.push({\n            className: args.className,\n            css: css\n          });\n        }\n      });\n    }\n    /**\n     * Get template.\n     *\n     * @returns {string}\n     */\n\n\n    var _proto = PreviewStyles.prototype;\n\n    _proto.getTemplate = function getTemplate() {\n      return this.template;\n    };\n\n    return PreviewStyles;\n  }();\n\n  return PreviewStyles;\n});\n//# sourceMappingURL=preview-styles.js.map","Magento_PageBuilder/js/content-type/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/modal/dismissible-confirm\", \"underscore\", \"Magento_PageBuilder/js/binding/live-edit\", \"Magento_PageBuilder/js/binding/sortable\", \"Magento_PageBuilder/js/binding/sortable-children\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-collection\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type-menu\", \"Magento_PageBuilder/js/content-type-menu/edit\", \"Magento_PageBuilder/js/content-type-menu/option\", \"Magento_PageBuilder/js/content-type-menu/title-option\", \"Magento_PageBuilder/js/drag-drop/registry\", \"Magento_PageBuilder/js/drag-drop/sortable\", \"Magento_PageBuilder/js/utils/check-stage-full-screen\", \"Magento_PageBuilder/js/utils/object\", \"Magento_PageBuilder/js/content-type/appearance-config\"], function (_jquery, _knockout, _translate, _events, _dismissibleConfirm, _underscore, _liveEdit, _sortable, _sortableChildren, _config, _contentTypeCollection, _contentTypeFactory, _contentTypeMenu, _edit, _option, _titleOption, _registry, _sortable2, _checkStageFullScreen, _object, _appearanceConfig) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * Provide preview data as an object which can be queried\n     *\n     * @deprecated please use getOptionValue directly\n     */\n\n    /**\n     * Fields that should not be considered when evaluating whether an object has been configured.\n     *\n     * @see {Preview.isConfigured}\n     * @type {[string]}\n     */\n\n    /**\n     * @param {ContentTypeInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      this.data = {};\n      this.displayLabel = _knockout.observable();\n      this.display = _knockout.observable(true);\n      this.appearance = _knockout.observable();\n      this.isPlaceholderVisible = _knockout.observable(true);\n      this.isEmpty = _knockout.observable(true);\n      this.viewport = _knockout.observable(\"\");\n      this.previewData = {};\n      this.fieldsToIgnoreOnRemove = [];\n      this.events = {};\n      this.isSnapshot = _knockout.observable(false);\n      this.mouseover = false;\n      this.contentType = contentType;\n      this.config = config;\n      this.edit = new _edit(this.contentType, this.contentType.dataStore);\n      this.optionsMenu = new _contentTypeMenu(this, this.retrieveOptions());\n      this.observableUpdater = observableUpdater;\n      this.displayLabel(this.config.label);\n      this.placeholderCss = _knockout.observable({\n        \"visible\": this.isEmpty,\n        \"empty-placeholder-background\": this.isPlaceholderVisible\n      });\n\n      if (_config.getConfig(\"pagebuilder_content_snapshot\")) {\n        this.isSnapshot(!(0, _checkStageFullScreen)(this.contentType.stageId));\n      }\n\n      this.viewport(_config.getConfig(\"viewport\"));\n      this.bindEvents();\n      this.populatePreviewData();\n    }\n    /**\n     * Retrieve the preview template\n     *\n     * @returns {string}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Calls methods by event name.\n     *\n     * @param {string}  eventName\n     * @param {any} params\n     */\n    _proto.trigger = function trigger(eventName, params) {\n      var _this = this;\n\n      if (this.events[eventName]) {\n        var methods = this.events[eventName];\n\n        _underscore.each(methods.split(\" \"), function (methodName) {\n          var method = _this[methodName];\n\n          if (method) {\n            method.call(_this, params);\n          }\n        }, this);\n      }\n    }\n    /**\n     * Tries to call specified method of a current content type.\n     *\n     * @param args\n     */\n    ;\n\n    _proto.delegate = function delegate() {\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      var methodName = args.slice(0, 1)[0];\n      var method = this[methodName];\n\n      if (method) {\n        method.apply(this, args.slice(1, args.length));\n      }\n    }\n    /**\n     * Open the edit form for this content type\n     */\n    ;\n\n    _proto.openEdit = function openEdit() {\n      return this.edit.open();\n    }\n    /**\n     * Update data store\n     *\n     * @param {string} key\n     * @param {string} value\n     */\n    ;\n\n    _proto.updateData = function updateData(key, value) {\n      this.contentType.dataStore.set(key, value);\n    }\n    /**\n     * Retrieve the value for an option\n     *\n     * @param key\n     */\n    ;\n\n    _proto.getOptionValue = function getOptionValue(key) {\n      return this.contentType.dataStore.get(key);\n    }\n    /**\n     * Set state based on mouseover event for the preview\n     *\n     * @param {Preview} context\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onMouseOver = function onMouseOver(context, event) {\n      if (this.mouseover || (0, _registry.getDraggedContentTypeConfig)()) {\n        return;\n      } // Ensure no other options panel is displayed\n\n\n      (0, _jquery)(\".pagebuilder-options-visible\").removeClass(\"pagebuilder-options-visible\");\n      this.mouseover = true;\n      this.mouseoverContext = context;\n      var currentTarget = event.currentTarget;\n      var optionsMenu = (0, _jquery)(currentTarget).find(\".pagebuilder-options-wrapper\");\n\n      if (!(0, _jquery)(currentTarget).hasClass(\"type-nested\")) {\n        optionsMenu = optionsMenu.first();\n      }\n\n      var middleOfPreview = currentTarget.getBoundingClientRect().left + currentTarget.offsetWidth / 2; // Check for space for option menu\n\n      if (window.innerWidth - middleOfPreview > optionsMenu.width() / 2) {\n        optionsMenu.parent().addClass(\"pagebuilder-options-middle\");\n      } else {\n        optionsMenu.parent().removeClass(\"pagebuilder-options-middle\");\n      }\n\n      optionsMenu.parent().addClass(\"pagebuilder-options-visible\");\n      (0, _jquery)(currentTarget).addClass(\"pagebuilder-content-type-active\");\n    }\n    /**\n     * Set state based on mouseout event for the preview\n     *\n     * @param {Preview} context\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onMouseOut = function onMouseOut(context, event) {\n      var _this2 = this;\n\n      this.mouseover = false;\n\n      if ((0, _registry.getDraggedContentTypeConfig)()) {\n        return;\n      }\n\n      _underscore.delay(function () {\n        if (!_this2.mouseover && _this2.mouseoverContext === context) {\n          var currentTarget = event.currentTarget;\n          var optionsMenu = (0, _jquery)(currentTarget).find(\".pagebuilder-options-wrapper\");\n\n          if (!(0, _jquery)(currentTarget).hasClass(\"type-nested\")) {\n            optionsMenu = optionsMenu.first();\n          }\n\n          optionsMenu.parent().removeClass(\"pagebuilder-options-visible\");\n          (0, _jquery)(currentTarget).removeClass(\"pagebuilder-content-type-active\");\n        }\n      }, 100); // 100 ms delay to allow for users hovering over other elements\n\n    }\n    /**\n     * After children render fire an event\n     *\n     * @param {Element} element\n     * @deprecated\n     */\n    ;\n\n    _proto.afterChildrenRender = function afterChildrenRender(element) {\n      _events.trigger(\"contentType:childrenRenderAfter\", {\n        id: this.contentType.id,\n        contentType: this.contentType,\n        element: element\n      });\n\n      _events.trigger(this.contentType.config.name + \":childrenRenderAfter\", {\n        contentType: this.contentType,\n        element: element,\n        id: this.contentType.id\n      });\n    }\n    /**\n     * Dispatch an after render event for individual content types\n     *\n     * @param {Element[]} elements\n     */\n    ;\n\n    _proto.dispatchAfterRenderEvent = function dispatchAfterRenderEvent(elements) {\n      var elementNodes = elements.filter(function (renderedElement) {\n        return renderedElement.nodeType === Node.ELEMENT_NODE;\n      });\n\n      if (elementNodes.length > 0) {\n        var element = elementNodes[0];\n        this.wrapperElement = element;\n\n        _events.trigger(\"contentType:renderAfter\", {\n          id: this.contentType.id,\n          contentType: this.contentType,\n          element: element\n        });\n\n        _events.trigger(this.contentType.config.name + \":renderAfter\", {\n          contentType: this.contentType,\n          element: element,\n          id: this.contentType.id\n        });\n\n        this.disableImageUploadOnHide(element);\n      }\n    }\n    /**\n     * Get the options instance\n     *\n     * @returns {ContentTypeMenu}\n     */\n    ;\n\n    _proto.getOptions = function getOptions() {\n      return this.optionsMenu;\n    }\n    /**\n     * Handle user editing an instance\n     */\n    ;\n\n    _proto.onOptionEdit = function onOptionEdit() {\n      this.openEdit();\n    }\n    /**\n     * Reverse the display data currently in the data store\n     */\n    ;\n\n    _proto.onOptionVisibilityToggle = function onOptionVisibilityToggle() {\n      var display = this.contentType.dataStore.get(\"display\");\n      this.contentType.dataStore.set(\"display\", !display);\n      this.dispatchContentTypeVisibilityEvents(this.contentType, !display);\n    }\n    /**\n     * Handle duplicate of items\n     */\n    ;\n\n    _proto.onOptionDuplicate = function onOptionDuplicate() {\n      this.clone(this.contentType, true, true);\n    }\n    /**\n     * Duplicate content type\n     *\n     * @param {ContentTypeInterface | ContentTypeCollectionInterface} contentType\n     * @param {boolean} autoAppend\n     * @param {boolean} direct\n     * @returns {Promise<ContentTypeInterface> | void}\n     */\n    ;\n\n    _proto.clone = function clone(contentType, autoAppend, direct) {\n      var _this3 = this;\n\n      if (autoAppend === void 0) {\n        autoAppend = true;\n      }\n\n      if (direct === void 0) {\n        direct = false;\n      }\n\n      var defaultViewport = _config.getConfig(\"defaultViewport\");\n\n      var contentTypeData = contentType.dataStores[defaultViewport].getState();\n      var index = contentType.parentContentType.getChildren()().indexOf(contentType) + 1 || null;\n      return (0, _contentTypeFactory)(contentType.config, contentType.parentContentType, contentType.stageId, contentTypeData, 0, contentType.getDataStoresStates()).then(function (duplicateContentType) {\n        if (autoAppend) {\n          contentType.parentContentType.addChild(duplicateContentType, index);\n        }\n\n        _this3.dispatchContentTypeCloneEvents(contentType, duplicateContentType, index, direct);\n\n        return duplicateContentType;\n      });\n    }\n    /**\n     * Handle content type removal\n     */\n    ;\n\n    _proto.onOptionRemove = function onOptionRemove() {\n      var _this4 = this;\n\n      var removeContentType = function removeContentType() {\n        if (_this4.wrapperElement) {\n          // Fade out the content type\n          (0, _jquery)(_this4.wrapperElement).fadeOut(350 / 2, function () {\n            _this4.contentType.destroy();\n          });\n        } else {\n          _this4.contentType.destroy();\n        }\n      };\n\n      if (this.isConfigured()) {\n        (0, _dismissibleConfirm)({\n          actions: {\n            confirm: function confirm() {\n              // Call the parent to remove the child element\n              removeContentType();\n            }\n          },\n          content: (0, _translate)(\"Are you sure you want to remove this item? The data within this item is not recoverable once removed.\"),\n          // tslint:disable-line:max-line-length\n          dismissKey: \"pagebuilder_modal_dismissed\",\n          dismissible: true,\n          title: (0, _translate)(\"Confirm Item Removal\")\n        });\n      } else {\n        removeContentType();\n      }\n    }\n    /**\n     * Determine if the container can receive drop events? With the current matrix system everything can unless\n     * specified in an inherited preview instance.\n     *\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.isContainer = function isContainer() {\n      return true;\n    }\n    /**\n     * Return the sortable options\n     *\n     * @returns {JQueryUI.SortableOptions}\n     */\n    ;\n\n    _proto.getSortableOptions = function getSortableOptions() {\n      return (0, _sortable2.getSortableOptions)(this);\n    }\n    /**\n     * Destroys current instance\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      return;\n    }\n    /**\n     * Get the CSS classes for the children element, as we dynamically create this class name it can't sit in the DOM\n     * without causing browser issues\n     *\n     * @returns {{[p: string]: boolean}}\n     */\n    ;\n\n    _proto.getChildrenCss = function getChildrenCss() {\n      var _ref;\n\n      return _ref = {}, _ref[this.config.name + \"-container\"] = true, _ref;\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = {\n        move: new _option({\n          preview: this,\n          icon: \"<i class='icon-admin-pagebuilder-handle'></i>\",\n          title: (0, _translate)(\"Move\"),\n          classes: [\"move-structural\"],\n          sort: 10\n        }),\n        title: new _titleOption({\n          preview: this,\n          title: this.config.label,\n          template: \"Magento_PageBuilder/content-type/title\",\n          sort: 20\n        }),\n        edit: new _option({\n          preview: this,\n          icon: \"<i class='icon-admin-pagebuilder-systems'></i>\",\n          title: (0, _translate)(\"Edit\"),\n          action: this.onOptionEdit,\n          classes: [\"edit-content-type\"],\n          sort: 30\n        }),\n        duplicate: new _option({\n          preview: this,\n          icon: \"<i class='icon-pagebuilder-copy'></i>\",\n          title: (0, _translate)(\"Duplicate\"),\n          action: this.onOptionDuplicate,\n          classes: [\"duplicate-structural\"],\n          sort: 50\n        }),\n        remove: new _option({\n          preview: this,\n          icon: \"<i class='icon-admin-pagebuilder-remove'></i>\",\n          title: (0, _translate)(\"Remove\"),\n          action: this.onOptionRemove,\n          classes: [\"remove-structural\"],\n          sort: 60\n        })\n      };\n      return options;\n    }\n    /**\n     * Dispatch content type clone events\n     *\n     * @param {ContentTypeInterface | ContentTypeCollectionInterface} originalContentType\n     * @param {ContentTypeInterface | ContentTypeCollectionInterface} duplicateContentType\n     * @param {number} index\n     * @param {boolean} direct\n     */\n    ;\n\n    _proto.dispatchContentTypeCloneEvents = function dispatchContentTypeCloneEvents(originalContentType, duplicateContentType, index, direct) {\n      var duplicateEventParams = {\n        originalContentType: originalContentType,\n        duplicateContentType: duplicateContentType,\n        index: index,\n        direct: direct\n      };\n\n      _events.trigger(\"contentType:duplicateAfter\", duplicateEventParams);\n\n      _events.trigger(originalContentType.config.name + \":duplicateAfter\", duplicateEventParams);\n    }\n    /**\n     * Dispatch content type visibility events\n     *\n     * @param {ContentTypeInterface | ContentTypeCollectionInterface} contentType\n     * @param {boolean} visibility\n     */\n    ;\n\n    _proto.dispatchContentTypeVisibilityEvents = function dispatchContentTypeVisibilityEvents(contentType, visibility) {\n      var visibilityEventParams = {\n        contentType: contentType,\n        visibility: visibility\n      };\n\n      _events.trigger(\"contentType:visibilityAfter\", visibilityEventParams);\n\n      _events.trigger(contentType.config.name + \":visibilityAfter\", visibilityEventParams);\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this5 = this;\n\n      var fullScreenModeChangeAfterEvent = \"stage:\" + this.contentType.stageId + \":fullScreenModeChangeAfter\";\n      this.contentType.dataStore.subscribe(function (data) {\n        _this5.updateObservables();\n\n        _this5.updatePlaceholderVisibility(data); // Keep a reference to the display state in an observable for adding classes to the wrapper\n\n\n        _this5.display(!!data.display);\n\n        _this5.appearance(data.appearance);\n      });\n\n      if (this.contentType instanceof _contentTypeCollection) {\n        this.contentType.children.subscribe(function (children) {\n          _this5.isEmpty(!children.length);\n        });\n      }\n\n      _events.on(fullScreenModeChangeAfterEvent, this.toggleSnapshot.bind(this));\n\n      _events.on(\"stage:\" + this.contentType.stageId + \":viewportChangeAfter\", function (args) {\n        _this5.viewport(args.viewport);\n      });\n    }\n    /**\n     * After observables updated, allows to modify observables\n     */\n    ;\n\n    _proto.afterObservablesUpdated = function afterObservablesUpdated() {\n      return;\n    }\n    /**\n     * Does the current instance have any children or values different from the default for it's type?\n     *\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.isConfigured = function isConfigured() {\n      var _this6 = this;\n\n      var data = this.contentType.dataStore.getState();\n      var fields = this.contentType.config.fields[this.appearance() + \"-appearance\"] || this.contentType.config.fields.default;\n      var hasDataChanges = false;\n\n      _underscore.each(fields, function (field, key) {\n        if (_this6.fieldsToIgnoreOnRemove && _this6.fieldsToIgnoreOnRemove.includes(key)) {\n          return;\n        }\n\n        var fieldValue = (0, _object.get)(data, key);\n\n        if (!fieldValue) {\n          fieldValue = \"\";\n        } // Default values can only ever be strings\n\n\n        if (_underscore.isObject(fieldValue)) {\n          // Empty arrays as default values appear as empty strings\n          if (_underscore.isArray(fieldValue) && fieldValue.length === 0) {\n            fieldValue = \"\";\n          } else {\n            fieldValue = JSON.stringify(fieldValue);\n          }\n        }\n\n        if (_underscore.isObject(field.default)) {\n          if (JSON.stringify(field.default) !== fieldValue) {\n            hasDataChanges = true;\n          }\n        } else if (field.default !== fieldValue) {\n          hasDataChanges = true;\n        }\n\n        return;\n      });\n\n      return hasDataChanges;\n    }\n    /**\n     * Any hidden element should block drag / drop events from uploading images from the OS. We have to block this for\n     * all elements as underlying elements could still receive the events if a parent is hidden.\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.disableImageUploadOnHide = function disableImageUploadOnHide(element) {\n      var _this7 = this;\n\n      (0, _jquery)(element).on(\"drag dragstart dragend dragover dragenter dragleave drop\", function (event) {\n        if (_this7.display() === false) {\n          event.preventDefault();\n          event.stopPropagation();\n        }\n      });\n    }\n    /**\n     * Update observables\n     */\n    ;\n\n    _proto.updateObservables = function updateObservables() {\n      this.observableUpdater.update(this, _underscore.extend({}, this.contentType.dataStore.getState()));\n      this.afterObservablesUpdated();\n    }\n    /**\n     * Update placeholder background visibility base on height and padding\n     *\n     * @param {DataObject} data\n     */\n    ;\n\n    _proto.updatePlaceholderVisibility = function updatePlaceholderVisibility(data) {\n      var minHeight = !_underscore.isEmpty(data.min_height) ? parseFloat(data.min_height) : 130;\n      var marginsAndPadding = _underscore.isString(data.margins_and_padding) && data.margins_and_padding ? JSON.parse(data.margins_and_padding) : data.margins_and_padding || {};\n      var padding = marginsAndPadding.padding || {};\n      var paddingBottom = parseFloat(padding.bottom) || 0;\n      var paddingTop = parseFloat(padding.top) || 0;\n      this.isPlaceholderVisible(paddingBottom + paddingTop + minHeight >= 130);\n    }\n    /**\n     * Populate the preview data with calls to the supported getOptionValue method\n     *\n     * @deprecated this function is only included to preserve backwards compatibility, use getOptionValue directly\n     */\n    ;\n\n    _proto.populatePreviewData = function populatePreviewData() {\n      var _this8 = this;\n\n      if (this.config.fields) {\n        _underscore.each(this.config.fields, function (fields) {\n          _underscore.keys(fields).forEach(function (key) {\n            _this8.previewData[key] = _knockout.observable(\"\");\n          });\n        });\n      } // Subscribe to this content types data in the store\n\n\n      this.contentType.dataStore.subscribe(function (data) {\n        _underscore.forEach(data, function (value, key) {\n          var optionValue = _this8.getOptionValue(key);\n\n          if (_knockout.isObservable(_this8.previewData[key])) {\n            _this8.previewData[key](optionValue);\n          } else {\n            if (_underscore.isArray(optionValue)) {\n              _this8.previewData[key] = _knockout.observableArray(optionValue);\n            } else {\n              _this8.previewData[key] = _knockout.observable(optionValue);\n            }\n          }\n        });\n      });\n    }\n    /**\n     * Enable snapshot mode.\n     * @param args\n     */\n    ;\n\n    _proto.toggleSnapshot = function toggleSnapshot(args) {\n      if (_config.getConfig(\"pagebuilder_content_snapshot\")) {\n        this.isSnapshot(!args.fullScreen);\n      }\n    };\n\n    _createClass(Preview, [{\n      key: \"template\",\n      get: function get() {\n        return (0, _appearanceConfig)(this.config.name, this.appearance()).preview_template;\n      }\n    }]);\n\n    return Preview;\n  }();\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/style-registry.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/string\"], function (_underscore, _string) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var styleRegistries = {};\n  var pbStyleAttribute = \"data-pb-style\";\n  var styleDataAttribute = \"data-style-id\";\n\n  var StyleRegistry = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function StyleRegistry(identifier) {\n      this.styles = {};\n\n      if (identifier) {\n        styleRegistries[identifier] = this;\n      }\n    }\n    /**\n     * Update styles for selector\n     *\n     * @param selector\n     * @param styles\n     */\n\n\n    var _proto = StyleRegistry.prototype;\n\n    _proto.setStyles = function setStyles(selector, styles) {\n      this.styles[selector] = styles;\n    }\n    /**\n     * Retrieve styles for a selector\n     *\n     * @param selector\n     */\n    ;\n\n    _proto.getStyles = function getStyles(selector) {\n      if (this.styles[selector]) {\n        return this.styles[selector];\n      }\n\n      return {};\n    }\n    /**\n     * Retrieve all styles\n     */\n    ;\n\n    _proto.getAllStyles = function getAllStyles() {\n      return this.styles;\n    };\n\n    return StyleRegistry;\n  }();\n  /**\n   * Return the style registry\n   *\n   * @param id\n   */\n\n\n  function getStyleRegistry(id) {\n    return styleRegistries[id] !== undefined ? styleRegistries[id] : null;\n  }\n  /**\n   * Delete the style registry\n   *\n   * @param id\n   */\n\n\n  function deleteStyleRegistry(id) {\n    if (styleRegistries[id]) {\n      delete styleRegistries[id];\n    }\n  }\n  /**\n   * Generate CSS from styles\n   *\n   * @param styles\n   */\n\n\n  function generateCss(styles) {\n    var generatedCss = \"\";\n    Object.keys(styles).forEach(function (selector) {\n      if (!_underscore.isEmpty(styles[selector])) {\n        generatedCss += generateCssBlock(selector, styles[selector]);\n      }\n    });\n    return generatedCss;\n  }\n  /**\n   * Generate styles from an object\n   *\n   * @param selector\n   * @param styles\n   */\n\n\n  function generateCssBlock(selector, styles) {\n    var generatedStyles = \"\";\n    Object.keys(styles).forEach(function (key) {\n      if (!_underscore.isEmpty(styles[key])) {\n        generatedStyles += (0, _string.fromCamelCaseToDash)(key) + \": \" + styles[key] + \"; \";\n      }\n    });\n    return selector + \" { \" + generatedStyles + \" }\";\n  }\n\n  return Object.assign(StyleRegistry, {\n    getStyleRegistry: getStyleRegistry,\n    deleteStyleRegistry: deleteStyleRegistry,\n    generateCss: generateCss,\n    generateCssBlock: generateCssBlock,\n    pbStyleAttribute: pbStyleAttribute,\n    styleDataAttribute: styleDataAttribute\n  });\n});\n//# sourceMappingURL=style-registry.js.map","Magento_PageBuilder/js/content-type/banner/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jarallax\", \"jarallaxVideo\", \"jquery\", \"jquery/z-index\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"mageUtils\", \"underscore\", \"vimeoWrapper\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/uploader\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/utils/nesting-link-dialog\", \"Magento_PageBuilder/js/utils/nesting-widget-dialog\", \"Magento_PageBuilder/js/wysiwyg/factory\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jarallax, _jarallaxVideo, _jquery, _zIndex, _translate, _events, _mageUtils, _underscore, _vimeoWrapper, _hideShowOption, _uploader, _delayUntil, _editor, _nestingLinkDialog, _nestingWidgetDialog, _factory, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.buttonPlaceholder = (0, _translate)(\"Edit Button Text\");\n      _this.wysiwygDeferred = _jquery.Deferred();\n      _this.handledDoubleClick = false;\n      _this.videoUpdateProperties = [\"background_type\", \"video_fallback_image\", \"video_lazy_load\", \"video_loop\", \"video_play_only_visible\", \"video_source\"];\n      _this.bannerOverlaySelector = \".pagebuilder-overlay\";\n      _this.defaultOverlayZIndex = 2;\n      _this.activeEditorOverlayZIndex = 3;\n      _this.buildJarallax = _underscore.debounce(function () {\n        // Destroy all instances of the plugin prior\n        try {\n          jarallax(_this.wrapper, \"destroy\");\n        } catch (e) {// Failure of destroying is acceptable\n        }\n\n        if (_this.wrapper && _this.wrapper.dataset.backgroundType === \"video\" && _this.wrapper.dataset.videoSrc.length) {\n          _underscore.defer(function () {\n            // Build Parallax on elements with the correct class\n            jarallax(_this.wrapper, {\n              videoSrc: _this.wrapper.dataset.videoSrc,\n              imgSrc: _this.wrapper.dataset.videoFallbackSrc,\n              videoLoop: _this.contentType.dataStore.get(\"video_loop\") === \"true\",\n              speed: 1,\n              videoPlayOnlyVisible: _this.contentType.dataStore.get(\"video_play_only_visible\") === \"true\",\n              videoLazyLoading: _this.contentType.dataStore.get(\"video_lazy_load\") === \"true\"\n            }); // @ts-ignore\n\n            if (_this.wrapper.jarallax && _this.wrapper.jarallax.video) {\n              // @ts-ignore\n              _this.wrapper.jarallax.video.on(\"started\", function () {\n                // @ts-ignore\n                if (_this.wrapper.jarallax && _this.wrapper.jarallax.$video) {\n                  // @ts-ignore\n                  _this.wrapper.jarallax.$video.style.visibility = \"visible\";\n                }\n              });\n            }\n          });\n        }\n      }, 50);\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Get registry callback reference to uploader UI component\n     *\n     * @returns {Uploader}\n     */\n    ;\n\n    _proto.getUploader = function getUploader() {\n      var initialImageValue = this.contentType.dataStore.get(this.config.additional_data.uploaderConfig.dataScope, \"\"); // Create uploader\n\n      return new _uploader(\"imageuploader_\" + this.contentType.id, this.config.additional_data.uploaderConfig, this.contentType.id, this.contentType.dataStore, initialImageValue);\n    }\n    /**\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.afterRenderWysiwyg = function afterRenderWysiwyg(element) {\n      var _this2 = this;\n\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\"; // Set the innerHTML manually so we don't upset Knockout & TinyMCE\n\n      element.innerHTML = this.data.content.html();\n      this.contentType.dataStore.subscribe(function () {\n        // If we're not focused into TinyMCE inline, update the value when it changes in the data store\n        if (!_this2.wysiwyg || _this2.wysiwyg && _this2.wysiwyg.getAdapter().id !== (0, _editor.getActiveEditor)().id) {\n          element.innerHTML = _this2.data.content.html();\n        }\n      }, \"message\");\n      /**\n       * afterRenderWysiwyg is called whenever Knockout causes a DOM re-render. This occurs frequently within Slider\n       * due to Slick's inability to perform a refresh with Knockout managing the DOM. Due to this the original\n       * WYSIWYG instance will be detached from this slide and we need to re-initialize on click.\n       */\n\n      this.wysiwyg = null;\n    }\n    /**\n     * Stop event to prevent execution of action when editing textarea.\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.stopEvent = function stopEvent(preview, event) {\n      event.stopPropagation();\n      return true;\n    }\n    /**\n     * Init WYSIWYG on load\n     *\n     * @param element\n     * @deprecated please use activateEditor & initWysiwygFromClick\n     */\n    ;\n\n    _proto.initWysiwyg = function initWysiwyg(element) {\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\";\n      this.wysiwyg = null;\n      return this.initWysiwygFromClick(false);\n    }\n    /**\n     * Init the WYSIWYG\n     *\n     * @param {boolean} focus Should wysiwyg focus after initialization?\n     * @returns Promise\n     */\n    ;\n\n    _proto.initWysiwygFromClick = function initWysiwygFromClick(focus) {\n      var _this3 = this;\n\n      if (focus === void 0) {\n        focus = false;\n      }\n\n      if (this.wysiwyg) {\n        return Promise.resolve(this.wysiwyg);\n      }\n\n      var wysiwygConfig = this.config.additional_data.wysiwygConfig.wysiwygConfigData;\n\n      if (focus) {\n        wysiwygConfig.adapter.settings.auto_focus = this.element.id;\n\n        wysiwygConfig.adapter.settings.init_instance_callback = function (editor) {\n          editor.on(\"focus\", function () {\n            (0, _jquery)(_this3.element).parents(_this3.bannerOverlaySelector).zIndex(_this3.activeEditorOverlayZIndex);\n          });\n          editor.on(\"blur\", function () {\n            (0, _jquery)(_this3.element).parents(_this3.bannerOverlaySelector).zIndex(_this3.defaultOverlayZIndex);\n            (0, _nestingLinkDialog)(_this3.contentType.dataStore, _this3.wysiwyg, \"message\", \"link_url\");\n            (0, _nestingWidgetDialog)(_this3.contentType.dataStore, _this3.wysiwyg, \"message\", \"link_url\");\n          });\n\n          _underscore.defer(function () {\n            _this3.element.blur();\n\n            _this3.element.focus();\n          });\n        };\n      }\n\n      wysiwygConfig.adapter.settings.fixed_toolbar_container = \"#\" + this.contentType.id + \" .pagebuilder-banner-text-content\";\n      return (0, _factory)(this.contentType.id, this.element.id, this.config.name, wysiwygConfig, this.contentType.dataStore, \"message\", this.contentType.stageId).then(function (wysiwyg) {\n        _this3.wysiwyg = wysiwyg;\n        return wysiwyg;\n      });\n    }\n    /**\n     * Makes WYSIWYG active\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.activateEditor = function activateEditor(preview, event) {\n      var _this4 = this;\n\n      if (this.element && !this.wysiwyg) {\n        var bookmark = (0, _editor.createBookmark)(event);\n        (0, _editor.lockImageSize)(this.element);\n        this.element.removeAttribute(\"contenteditable\");\n\n        _underscore.defer(function () {\n          _this4.initWysiwygFromClick(true).then(function () {\n            return (0, _delayUntil)(function () {\n              // We no longer need to handle double click once it's initialized\n              _this4.handledDoubleClick = true;\n\n              _this4.wysiwygDeferred.resolve();\n\n              (0, _editor.moveToBookmark)(bookmark);\n              (0, _editor.unlockImageSize)(_this4.element);\n            }, function () {\n              return _this4.element.classList.contains(\"mce-edit-focus\");\n            }, 10);\n          }).catch(function (error) {\n            // If there's an error with init of WYSIWYG editor push into the console to aid support\n            console.error(error);\n          });\n        });\n      } else if (this.element && this.wysiwyg) {\n        var element = this.element || this.textarea;\n\n        if (event.currentTarget !== event.target && event.target !== element && !element.contains(event.target)) {\n          return;\n        }\n\n        element.focus();\n      }\n    }\n    /**\n     * If a user double clicks prior to initializing TinyMCE, forward the event\n     *\n     * @param preview\n     * @param event\n     */\n    ;\n\n    _proto.handleDoubleClick = function handleDoubleClick(preview, event) {\n      var _this5 = this;\n\n      if (this.handledDoubleClick) {\n        return;\n      }\n\n      event.preventDefault();\n      var targetIndex = (0, _editor.findNodeIndex)(this.element, event.target.tagName, event.target);\n      this.handledDoubleClick = true;\n      this.wysiwygDeferred.then(function () {\n        var target = document.getElementById(event.target.id);\n\n        if (!target) {\n          target = (0, _editor.getNodeByIndex)(_this5.element, event.target.tagName, targetIndex);\n        }\n\n        if (target) {\n          target.dispatchEvent((0, _editor.createDoubleClickEvent)());\n        }\n      });\n    }\n    /**\n     * Set state based on overlay mouseover event for the preview\n     */\n    ;\n\n    _proto.onMouseOverWrapper = function onMouseOverWrapper() {\n      if (this.data.main.attributes()[\"data-show-overlay\"] === \"hover\") {\n        this.data.overlay.attributes(Object.assign(this.data.overlay.attributes(), {\n          \"data-background-color-orig\": this.data.overlay.style().backgroundColor\n        }));\n        this.data.overlay.style(Object.assign(this.data.overlay.style(), {\n          backgroundColor: this.data.overlay.attributes()[\"data-overlay-color\"]\n        }));\n      }\n\n      if (this.data.main.attributes()[\"data-show-button\"] === \"hover\") {\n        this.data.button.style(Object.assign(this.data.button.style(), {\n          opacity: 1,\n          visibility: \"visible\"\n        }));\n      }\n    }\n    /**\n     * Set state based on overlay mouseout event for the preview\n     */\n    ;\n\n    _proto.onMouseOutWrapper = function onMouseOutWrapper() {\n      if (this.data.main.attributes()[\"data-show-overlay\"] === \"hover\") {\n        this.data.overlay.style(Object.assign(this.data.overlay.style(), {\n          backgroundColor: this.data.overlay.attributes()[\"data-background-color-orig\"]\n        }));\n      }\n\n      if (this.data.main.attributes()[\"data-show-button\"] === \"hover\") {\n        this.data.button.style(Object.assign(this.data.button.style(), {\n          opacity: 0,\n          visibility: \"hidden\"\n        }));\n      }\n    }\n    /**\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.isWysiwygSupported = function isWysiwygSupported() {\n      return (0, _editor.isWysiwygSupported)();\n    }\n    /**\n     * @param {HTMLTextAreaElement} element\n     */\n    ;\n\n    _proto.initTextarea = function initTextarea(element) {\n      var _this6 = this;\n\n      this.textarea = element; // set initial value of textarea based on data store\n\n      this.textarea.value = this.contentType.dataStore.get(\"message\");\n      this.adjustTextareaHeightBasedOnScrollHeight(); // Update content in our stage preview textarea after its slideout counterpart gets updated\n\n      _events.on(\"form:\" + this.contentType.id + \":saveAfter\", function () {\n        _this6.textarea.value = _this6.contentType.dataStore.get(\"message\");\n\n        _this6.adjustTextareaHeightBasedOnScrollHeight();\n      });\n    }\n    /**\n     * Save current value of textarea in data store\n     */\n    ;\n\n    _proto.onTextareaKeyUp = function onTextareaKeyUp() {\n      this.adjustTextareaHeightBasedOnScrollHeight();\n      this.contentType.dataStore.set(\"message\", this.textarea.value);\n    }\n    /**\n     * Start stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaFocus = function onTextareaFocus() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-banner-text-content\").addClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStart\");\n    }\n    /**\n     * Stop stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaBlur = function onTextareaBlur() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-banner-text-content\").removeClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStop\");\n    }\n    /**\n     * Init the parallax element\n     *\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.initParallax = function initParallax(element) {\n      var _this7 = this;\n\n      this.wrapper = element;\n\n      _underscore.defer(function () {\n        _this7.buildJarallax();\n      });\n    }\n    /**\n     * Destroy jarallax instance.\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      _preview2.prototype.destroy.call(this);\n\n      if (this.wrapper) {\n        jarallax(this.wrapper, \"destroy\");\n      }\n    }\n    /**\n     * @inheritDoc\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this8 = this;\n\n      _preview2.prototype.bindEvents.call(this);\n\n      _events.on(\"banner:mountAfter\", function (args) {\n        if (args.id === _this8.contentType.id) {\n          _this8.buildJarallax();\n\n          _this8.isSnapshot.subscribe(function (value) {\n            _this8.changeUploaderControlsVisibility();\n          });\n\n          _this8.changeUploaderControlsVisibility();\n        }\n      });\n\n      _events.on(this.config.name + \":\" + this.contentType.id + \":updateAfter\", function () {\n        var dataStore = _this8.contentType.dataStore.getState();\n\n        var imageObject = dataStore[_this8.config.additional_data.uploaderConfig.dataScope][0] || {}; // Resolves issue when tinyMCE injects a non-breaking space on reinitialization and removes placeholder.\n\n        if (dataStore.message === \"<div data-bind=\\\"html: data.content.html\\\">&nbsp;</div>\") {\n          _this8.contentType.dataStore.set(\"message\", \"\");\n        }\n\n        _events.trigger(\"image:\" + _this8.contentType.id + \":assignAfter\", imageObject);\n      });\n\n      this.contentType.dataStore.subscribe(function (data) {\n        if (this.shouldUpdateVideo(data)) {\n          this.buildJarallax();\n        }\n      }.bind(this));\n\n      _events.on(\"image:\" + this.contentType.id + \":uploadAfter\", function () {\n        _this8.contentType.dataStore.set(\"background_type\", \"image\");\n      });\n\n      _events.on(\"stage:\" + this.contentType.stageId + \":viewportChangeAfter\", function (args) {\n        _this8.buildJarallax();\n      });\n    }\n    /**\n     * Change uploader controls visibility\n     */\n    ;\n\n    _proto.changeUploaderControlsVisibility = function changeUploaderControlsVisibility() {\n      var _this9 = this;\n\n      this.getUploader().getUiComponent()(function (uploader) {\n        uploader.visibleControls = !_this9.isSnapshot();\n      });\n    }\n    /**\n     * Adjust textarea's height based on scrollHeight\n     */\n    ;\n\n    _proto.adjustTextareaHeightBasedOnScrollHeight = function adjustTextareaHeightBasedOnScrollHeight() {\n      this.textarea.style.height = \"\";\n      var scrollHeight = this.textarea.scrollHeight;\n      var minHeight = parseInt((0, _jquery)(this.textarea).css(\"min-height\"), 10);\n\n      if (scrollHeight === minHeight) {\n        // leave height at 'auto'\n        return;\n      }\n\n      (0, _jquery)(this.textarea).height(scrollHeight);\n    }\n    /**\n     * Check if video options has been updated.\n     *\n     * @return boolean\n     */\n    ;\n\n    _proto.shouldUpdateVideo = function shouldUpdateVideo(state) {\n      var _this10 = this;\n\n      var previousState = this.contentType.dataStore.getPreviousState();\n\n      var diff = _mageUtils.compare(previousState, state).changes;\n\n      if (diff.length > 0) {\n        return _underscore.some(diff, function (element) {\n          if (element.name === \"video_fallback_image\") {\n            return (!_underscore.isEmpty(previousState.video_fallback_image) && previousState.video_fallback_image) !== (!_underscore.isEmpty(state.video_fallback_image) && state.video_fallback_image);\n          }\n\n          return _this10.videoUpdateProperties.indexOf(element.name) !== -1;\n        });\n      }\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/banner/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_PageBuilder/js/widget/show-on-hover',\n    'Magento_PageBuilder/js/widget/video-background'\n], function (showOnHover, videoBackground) {\n    'use strict';\n\n    return function (config, element) {\n        var videoElement = element[0].querySelector('[data-background-type=video]');\n\n        showOnHover(config);\n\n        if (videoElement) {\n            videoBackground(config, videoElement);\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/banner/converter/attribute/overlay-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var OverlayColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayColor() {}\n\n    var _proto = OverlayColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value === \"transparent\" ? \"\" : value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      if (data.overlay_color) {\n        return data.overlay_color.toString();\n      }\n\n      return \"\";\n    };\n\n    return OverlayColor;\n  }();\n\n  return OverlayColor;\n});\n//# sourceMappingURL=overlay-color.js.map","Magento_PageBuilder/js/content-type/banner/converter/style/button-opacity.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ButtonOpacity = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ButtonOpacity() {}\n\n    var _proto = ButtonOpacity.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return data.show_button === \"always\" ? \"1\" : \"0\";\n    };\n\n    return ButtonOpacity;\n  }();\n\n  return ButtonOpacity;\n});\n//# sourceMappingURL=button-opacity.js.map","Magento_PageBuilder/js/content-type/banner/converter/style/button-visibility.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ButtonVisibility = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ButtonVisibility() {}\n\n    var _proto = ButtonVisibility.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return data.show_button === \"always\" ? \"visible\" : \"hidden\";\n    };\n\n    return ButtonVisibility;\n  }();\n\n  return ButtonVisibility;\n});\n//# sourceMappingURL=button-visibility.js.map","Magento_PageBuilder/js/content-type/banner/converter/style/overlay-background-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var OverlayBackgroundColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayBackgroundColor() {}\n\n    var _proto = OverlayBackgroundColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (data.show_overlay === \"always\" && value !== \"\" && value !== undefined) {\n        return value;\n      }\n\n      return \"transparent\";\n    };\n\n    return OverlayBackgroundColor;\n  }();\n\n  return OverlayBackgroundColor;\n});\n//# sourceMappingURL=overlay-background-color.js.map","Magento_PageBuilder/js/content-type/banner/wysiwyg/tinymce/component-initializer.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/adminhtml/wysiwyg/events\"], function (_jquery, _events) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ComponentInitializer = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ComponentInitializer() {}\n\n    var _proto = ComponentInitializer.prototype;\n\n    /**\n     * The editor element\n     */\n\n    /**\n     * The configuration of the wysiwyg content type\n     */\n\n    /**\n     * Initialize the instance\n     *\n     * @param {Wysiwyg} wysiwyg\n     */\n    _proto.initialize = function initialize(wysiwyg) {\n      this.$element = (0, _jquery)(\"#\" + wysiwyg.elementId);\n      this.config = wysiwyg.config;\n      var tinymce = wysiwyg.getAdapter();\n      tinymce.eventBus.attachEventHandler(_events.afterFocus, this.onFocus.bind(this));\n      tinymce.eventBus.attachEventHandler(_events.afterBlur, this.onBlur.bind(this));\n    }\n    /**\n     * Called when tinymce is focused\n     */\n    ;\n\n    _proto.onFocus = function onFocus() {\n      var _this = this;\n\n      // If there isn't enough room for a left-aligned toolbar, right align it\n      if ((0, _jquery)(window).width() < this.$element.offset().left + parseInt(this.config.adapter_config.minToolbarWidth, 10)) {\n        this.$element.addClass(\"_right-aligned-toolbar\");\n      } else {\n        this.$element.removeClass(\"_right-aligned-toolbar\");\n      }\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this.$element.closest(selector).css(\"z-index\", 100);\n      });\n    }\n    /**\n     * Called when tinymce is blurred\n     */\n    ;\n\n    _proto.onBlur = function onBlur() {\n      var _this2 = this;\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this2.$element.closest(selector).css(\"z-index\", \"\");\n      });\n    };\n\n    return ComponentInitializer;\n  }();\n\n  return ComponentInitializer;\n});\n//# sourceMappingURL=component-initializer.js.map","Magento_PageBuilder/js/content-type/block/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/widget-initializer\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/style-registry\", \"Magento_PageBuilder/js/utils/object\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _knockout, _translate, _widgetInitializer, _mageUtils, _underscore, _config, _hideShowOption, _styleRegistry, _object, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    /**\n     * @inheritdoc\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _preview2.call(this, contentType, config, observableUpdater) || this;\n      _this.displayingBlockPreview = _knockout.observable(false);\n      _this.loading = _knockout.observable(false);\n      _this.messages = {\n        NOT_SELECTED: (0, _translate)(\"Empty Block\"),\n        UNKNOWN_ERROR: (0, _translate)(\"An unknown error occurred. Please try again.\")\n      };\n      _this.placeholderText = _knockout.observable(_this.messages.NOT_SELECTED);\n      return _this;\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Runs the widget initializer for each configured widget\n     */\n    ;\n\n    _proto.initializeWidgets = function initializeWidgets(element) {\n      if (element) {\n        this.element = element;\n        (0, _widgetInitializer)({\n          config: _config.getConfig(\"widgets\"),\n          breakpoints: _config.getConfig(\"breakpoints\"),\n          currentViewport: _config.getConfig(\"viewport\")\n        }, element);\n      }\n    }\n    /**\n     * Updates the view state using the data provided\n     * @param {DataObject} data\n     */\n    ;\n\n    _proto.processBlockData = function processBlockData(data) {\n      // Only load if something changed\n      this.displayPreviewPlaceholder(data, \"block_id\");\n\n      if (data.block_id && data.template.length !== 0) {\n        this.processRequest(data, \"block_id\", \"title\");\n      }\n    }\n    /**\n     * @inheritdoc\n     */\n    ;\n\n    _proto.afterObservablesUpdated = function afterObservablesUpdated() {\n      _preview2.prototype.afterObservablesUpdated.call(this);\n\n      var data = this.contentType.dataStore.getState(); // Only load if something changed\n\n      this.processBlockData(data);\n    }\n    /**\n     * Display preview placeholder\n     *\n     * @param {DataObject} data\n     * @param {string} identifierName\n     */\n    ;\n\n    _proto.displayPreviewPlaceholder = function displayPreviewPlaceholder(data, identifierName) {\n      var blockId = (0, _object.get)(data, identifierName); // Only load if something changed\n\n      if (this.lastBlockId === blockId && this.lastTemplate === data.template) {\n        // The mass converter will have transformed the HTML property into a directive\n        if (this.lastRenderedHtml) {\n          this.data.main.html(this.lastRenderedHtml);\n          this.showBlockPreview(true);\n          this.initializeWidgets(this.element);\n        }\n      } else {\n        this.showBlockPreview(false);\n        this.placeholderText(\"\");\n      }\n\n      if (!blockId || blockId && blockId.toString().length === 0 || data.template.length === 0) {\n        this.showBlockPreview(false);\n        this.placeholderText(this.messages.NOT_SELECTED);\n        return;\n      }\n    }\n    /**\n     *\n     * @param {DataObject} data\n     * @param {string} identifierName\n     * @param {string} labelKey\n     */\n    ;\n\n    _proto.processRequest = function processRequest(data, identifierName, labelKey) {\n      var _this2 = this;\n\n      var url = _config.getConfig(\"preview_url\");\n\n      var identifier = (0, _object.get)(data, identifierName);\n      var requestConfig = {\n        // Prevent caching\n        method: \"POST\",\n        data: {\n          role: this.config.name,\n          block_id: identifier,\n          directive: this.data.main.html()\n        }\n      };\n      this.loading(true); // Retrieve a state object representing the block from the preview controller and process it on the stage\n\n      _jquery.ajax(url, requestConfig) // The state object will contain the block name and either html or a message why there isn't any.\n      .done(function (response) {\n        // Empty content means something bad happened in the controller that didn't trigger a 5xx\n        if (typeof response.data !== \"object\") {\n          _this2.showBlockPreview(false);\n\n          _this2.placeholderText(_this2.messages.UNKNOWN_ERROR);\n\n          return;\n        } // Update the stage content type label with the real block title if provided\n\n\n        _this2.displayLabel(response.data[labelKey] ? response.data[labelKey] : _this2.config.label);\n\n        var content = \"\";\n\n        if (response.data.content) {\n          content = _this2.processContent(response.data.content);\n\n          _this2.data.main.html(content);\n\n          _this2.showBlockPreview(true);\n\n          _this2.initializeWidgets(_this2.element);\n        } else if (response.data.error) {\n          _this2.showBlockPreview(false);\n\n          _this2.placeholderText(response.data.error);\n        }\n\n        _this2.lastBlockId = parseInt(identifier.toString(), 10);\n        _this2.lastTemplate = data.template.toString();\n        _this2.lastRenderedHtml = content;\n      }).fail(function () {\n        _this2.showBlockPreview(false);\n\n        _this2.placeholderText(_this2.messages.UNKNOWN_ERROR);\n      }).always(function () {\n        _this2.loading(false);\n      });\n    }\n    /**\n     * Toggle display of block preview.  If showing block preview, add hidden mode to PB preview.\n     * @param {boolean} isShow\n     */\n    ;\n\n    _proto.showBlockPreview = function showBlockPreview(isShow) {\n      this.displayingBlockPreview(isShow);\n    }\n    /**\n     * Adapt content to view it on stage.\n     *\n     * @param content\n     */\n    ;\n\n    _proto.processContent = function processContent(content) {\n      var processedContent = this.processBackgroundImages(content);\n      processedContent = this.processBreakpointStyles(processedContent);\n      return processedContent;\n    }\n    /**\n     * Generate styles for background images.\n     *\n     * @param {string} content\n     * @return string\n     */\n    ;\n\n    _proto.processBackgroundImages = function processBackgroundImages(content) {\n      var document = new DOMParser().parseFromString(content, \"text/html\");\n      var elements = document.querySelectorAll(\"[data-background-images]\");\n      var styleBlock = document.createElement(\"style\");\n\n      var viewports = _config.getConfig(\"viewports\");\n\n      elements.forEach(function (element) {\n        var rawAttrValue = element.getAttribute(\"data-background-images\").replace(/\\\\(.)/mg, \"$1\");\n        var attrValue = JSON.parse(rawAttrValue);\n\n        var elementClass = \"background-image-\" + _mageUtils.uniqueid(13);\n\n        var rules = \"\";\n        Object.keys(attrValue).forEach(function (imageName) {\n          var imageUrl = attrValue[imageName];\n          var viewportName = imageName.replace(\"_image\", \"\");\n\n          if (viewports[viewportName].stage && imageUrl) {\n            rules += \".\" + viewportName + \"-viewport .\" + elementClass + \" {\\n                            background-image: url(\\\"\" + imageUrl + \"\\\");\\n                        }\";\n          }\n        });\n\n        if (rules.length) {\n          styleBlock.append(rules);\n          element.classList.add(elementClass);\n        }\n      });\n\n      if (elements.length && styleBlock.innerText.length) {\n        document.body.append(styleBlock);\n        content = document.head.innerHTML + document.body.innerHTML;\n      }\n\n      return content;\n    }\n    /**\n     * Replace media queries with viewport classes.\n     *\n     * @param {string} content\n     * @return string\n     */\n    ;\n\n    _proto.processBreakpointStyles = function processBreakpointStyles(content) {\n      var document = new DOMParser().parseFromString(content, \"text/html\");\n      var styleBlocks = document.querySelectorAll(\"style\");\n      var mediaStyleBlock = document.createElement(\"style\");\n\n      var viewports = _config.getConfig(\"viewports\");\n\n      styleBlocks.forEach(function (styleBlock) {\n        var cssRules = styleBlock.sheet.cssRules;\n        Array.from(cssRules).forEach(function (rule) {\n          var mediaScope = rule instanceof CSSMediaRule && _underscore.findKey(viewports, function (viewport) {\n            return rule.conditionText === viewport.media;\n          });\n\n          if (mediaScope) {\n            Array.from(rule.cssRules).forEach(function (mediaRule, index) {\n              if (mediaRule.selectorText.indexOf(_styleRegistry.pbStyleAttribute) !== -1) {\n                var searchPattern = new RegExp(_config.getConfig(\"bodyId\") + \" \", \"g\");\n                var replaceValue = _config.getConfig(\"bodyId\") + \" .\" + mediaScope + \"-viewport \";\n                var selector = mediaRule.selectorText.replace(searchPattern, replaceValue);\n                mediaStyleBlock.append(selector + \" {\" + mediaRule.style.cssText + \"}\");\n              }\n            });\n          }\n        });\n      });\n\n      if (mediaStyleBlock.innerText.length) {\n        document.body.append(mediaStyleBlock);\n        content = document.head.innerHTML + document.body.innerHTML;\n      }\n\n      return content;\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/block/mass-converter/widget-directive.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/mass-converter/widget-directive-abstract\", \"Magento_PageBuilder/js/utils/object\"], function (_widgetDirectiveAbstract, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Enables the settings of the content type to be stored as a widget directive.\n   *\n   * @api\n   */\n  var WidgetDirective = /*#__PURE__*/function (_widgetDirectiveAbstr) {\n    \"use strict\";\n\n    _inheritsLoose(WidgetDirective, _widgetDirectiveAbstr);\n\n    function WidgetDirective() {\n      return _widgetDirectiveAbstr.apply(this, arguments) || this;\n    }\n\n    var _proto = WidgetDirective.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var attributes = _widgetDirectiveAbstr.prototype.fromDom.call(this, data, config);\n\n      data.template = attributes.template;\n      data.block_id = attributes.block_id;\n      return data;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var attributes = {\n        type: \"Magento\\\\Cms\\\\Block\\\\Widget\\\\Block\",\n        template: data.template,\n        block_id: data.block_id,\n        type_name: \"CMS Static Block\"\n      };\n\n      if (!attributes.block_id || !attributes.template) {\n        return data;\n      }\n\n      (0, _object.set)(data, config.html_variable, this.buildDirective(attributes));\n      return data;\n    };\n\n    return WidgetDirective;\n  }(_widgetDirectiveAbstract);\n\n  return WidgetDirective;\n});\n//# sourceMappingURL=widget-directive.js.map","Magento_PageBuilder/js/content-type/button-item/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/content-type-menu/conditional-remove-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _knockout, _translate, _conditionalRemoveOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.buttonPlaceholder = (0, _translate)(\"Edit Button Text\");\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Use the conditional remove to disable the option when the parent has a single child\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      delete options.title;\n      delete options.move;\n      options.remove = new _conditionalRemoveOption(_extends({}, options.remove.config, {\n        preview: this\n      }));\n      return options;\n    }\n    /**\n     * Force the focus on the clicked button\n     *\n     * @param {number} index\n     * @param {JQueryEventObject} event\n     */\n    ;\n\n    _proto.onClick = function onClick(index, event) {\n      (0, _jquery)(event.currentTarget).find(\"[contenteditable]\").focus();\n      event.stopPropagation();\n    }\n    /**\n     * Handle on focus out events, when the button item is focused out we need to set our focusedButton record on the\n     * buttons preview item to null. If we detect this focus out event is to focus into another button we need to ensure\n     * we update the record appropriately.\n     *\n     * @param {number} index\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onFocusOut = function onFocusOut(index, event) {\n      if (this.contentType && this.contentType.parentContentType) {\n        var parentPreview = this.contentType.parentContentType.preview;\n\n        var unfocus = function unfocus() {\n          window.getSelection().removeAllRanges();\n          parentPreview.focusedButton(null);\n        };\n\n        if (event.relatedTarget && _jquery.contains(parentPreview.wrapperElement, event.relatedTarget)) {\n          // Verify the focus was not onto the options menu\n          if ((0, _jquery)(event.relatedTarget).closest(\".pagebuilder-options\").length > 0) {\n            unfocus();\n          } else {\n            // Have we moved the focus onto another button in the current group?\n            var buttonItem = _knockout.dataFor(event.relatedTarget);\n\n            if (buttonItem && buttonItem.contentType && buttonItem.contentType.parentContentType && buttonItem.contentType.parentContentType.id === this.contentType.parentContentType.id) {\n              var newIndex = buttonItem.contentType.parentContentType.children().indexOf(buttonItem.contentType);\n              parentPreview.focusedButton(newIndex);\n            } else {\n              unfocus();\n            }\n          }\n        } else if (parentPreview.focusedButton() === index) {\n          unfocus();\n        }\n      }\n    }\n    /**\n     * On focus in set the focused button\n     *\n     * @param {number} index\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onFocusIn = function onFocusIn(index, event) {\n      var parentPreview = this.contentType.parentContentType.preview;\n\n      if (parentPreview.focusedButton() !== index) {\n        parentPreview.focusedButton(index);\n      }\n    }\n    /**\n     * If the button is displayed we need to show the options menu on hover\n     *\n     * @param {Preview} context\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onButtonMouseOver = function onButtonMouseOver(context, event) {\n      if (this.display() === false) {\n        this.onMouseOver(context, event);\n      }\n    }\n    /**\n     * If the button is displayed we need to hide the options menu on mouse out\n     *\n     * @param {Preview} context\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onButtonMouseOut = function onButtonMouseOut(context, event) {\n      if (this.display() === false) {\n        this.onMouseOut(context, event);\n      }\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/button-item/converter/style/display.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Display = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Display() {}\n\n    var _proto = Display.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return !(value === \"none\");\n    }\n    /**\n     * Convert value to knockout format, if buttons are displayed they should be inline block\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (!_underscore.isUndefined(value) && value === false) {\n        return \"none\";\n      }\n\n      return \"inline-block\";\n    };\n\n    return Display;\n  }();\n\n  return Display;\n});\n//# sourceMappingURL=display.js.map","Magento_PageBuilder/js/content-type/buttons/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type-menu/option\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jquery, _knockout, _translate, _events, _underscore, _config, _contentTypeFactory, _hideShowOption, _option, _delayUntil, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * @param {ContentTypeCollectionInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this; // Keeps track of number of button item to disable sortable if there is only 1.\n\n      _this.focusedButton = _knockout.observable();\n      _this.debouncedResizeHandler = _underscore.debounce(function () {\n        _this.resizeChildButtons();\n      }, 350);\n\n      _this.contentType.children.subscribe(function () {\n        var sortableElement = (0, _jquery)(_this.wrapperElement).find(\".buttons-container\");\n\n        if (!sortableElement.data(\"ui-sortable\")) {\n          return;\n        }\n\n        if (_this.contentType.children().length <= 1) {\n          sortableElement.sortable(\"disable\");\n        } else {\n          sortableElement.sortable(\"enable\");\n        }\n      }); // Monitor focus tab to start / stop interaction on the stage, debounce to avoid duplicate calls\n\n\n      _this.focusedButton.subscribe(_underscore.debounce(function (index) {\n        if (index !== null) {\n          _events.trigger(\"stage:interactionStart\");\n\n          var focusedButton = _this.contentType.children()[index];\n\n          (0, _delayUntil)(function () {\n            return (0, _jquery)(focusedButton.preview.wrapperElement).find(\"[contenteditable]\").focus();\n          }, function () {\n            return typeof focusedButton.preview.wrapperElement !== \"undefined\";\n          }, 10);\n        } else {\n          // We have to force the stop as the event firing is inconsistent for certain operations\n          _events.trigger(\"stage:interactionStop\", {\n            force: true\n          });\n        }\n      }, 1));\n\n      return _this;\n    }\n    /**\n     * Bind events\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this);\n\n      _events.on(\"buttons:dropAfter\", function (args) {\n        if (args.id === _this2.contentType.id && _this2.contentType.children().length === 0) {\n          _this2.addButton();\n        }\n      });\n\n      _events.on(\"buttons:renderAfter\", function (args) {\n        if (args.contentType.id === _this2.contentType.id) {\n          _this2.debouncedResizeHandler();\n        }\n      });\n\n      _events.on(\"button-item:renderAfter\", function (args) {\n        if (args.contentType.parentContentType.id === _this2.contentType.id) {\n          _this2.debouncedResizeHandler();\n        }\n      });\n\n      _events.on(\"stage:updateAfter\", function () {\n        _this2.debouncedResizeHandler();\n      });\n\n      _events.on(\"contentType:redrawAfter\", function () {\n        _this2.debouncedResizeHandler();\n      }); // Capture when a content type is duplicated within the container\n\n\n      var duplicatedButton;\n      var duplicatedButtonIndex;\n\n      _events.on(\"button-item:duplicateAfter\", function (args) {\n        if (_this2.contentType.id === args.duplicateContentType.parentContentType.id && args.direct) {\n          duplicatedButton = args.duplicateContentType;\n          duplicatedButtonIndex = args.index;\n        }\n      });\n\n      _events.on(\"button-item:mountAfter\", function (args) {\n        if (duplicatedButton && args.id === duplicatedButton.id) {\n          _this2.focusedButton(duplicatedButtonIndex);\n        }\n      });\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.add = new _option({\n        preview: this,\n        icon: \"<i class='icon-pagebuilder-add'></i>\",\n        title: (0, _translate)(\"Add Button\"),\n        action: this.addButton,\n        classes: [\"add-child\"],\n        sort: 10\n      });\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Add button-item to buttons children array\n     */\n    ;\n\n    _proto.addButton = function addButton() {\n      var _this3 = this;\n\n      var createButtonItemPromise = (0, _contentTypeFactory)(_config.getContentTypeConfig(\"button-item\"), this.contentType, this.contentType.stageId, {});\n      createButtonItemPromise.then(function (button) {\n        _this3.contentType.addChild(button);\n\n        var buttonIndex = _this3.contentType.children().indexOf(button);\n\n        _this3.focusedButton(buttonIndex > -1 ? buttonIndex : null);\n\n        return button;\n      }).catch(function (error) {\n        console.error(error);\n      });\n    }\n    /**\n     * Get the sortable options for the buttons sorting\n     *\n     * @param {string} orientation\n     * @param {string} tolerance\n     * @returns {JQueryUI.Sortable}\n     */\n    ;\n\n    _proto.getSortableOptions = function getSortableOptions(orientation, tolerance) {\n      if (orientation === void 0) {\n        orientation = \"width\";\n      }\n\n      if (tolerance === void 0) {\n        tolerance = \"intersect\";\n      }\n\n      return {\n        handle: \".button-item-drag-handle\",\n        items: \".pagebuilder-content-type-wrapper\",\n        cursor: \"grabbing\",\n        containment: \"parent\",\n        tolerance: tolerance,\n        revert: 200,\n        disabled: this.contentType.children().length <= 1,\n\n        /**\n         * Provide custom helper element\n         *\n         * @param {Event} event\n         * @param {JQueryUI.Sortable} element\n         * @returns {Element}\n         */\n        helper: function helper(event, element) {\n          var helper = (0, _jquery)(element).clone().css({\n            opacity: \"0.7\",\n            width: \"auto\"\n          });\n          helper[0].querySelector(\".pagebuilder-options\").remove();\n          return helper[0];\n        },\n        placeholder: {\n          /**\n           * Provide custom placeholder element\n           *\n           * @param {JQuery} item\n           * @returns {JQuery}\n           */\n          element: function element(item) {\n            var placeholder = item.clone().css({\n              display: \"inline-block\",\n              opacity: \"0.3\"\n            }).removeClass(\"focused\").addClass(\"sortable-placeholder\");\n            placeholder[0].querySelector(\".pagebuilder-options\").remove();\n            return placeholder[0];\n          },\n          update: function update() {\n            return;\n          }\n        },\n\n        /**\n         * Trigger interaction start on sort\n         */\n        start: function start() {\n          _events.trigger(\"stage:interactionStart\");\n        },\n\n        /**\n         * Stop stage interaction on stop\n         */\n        stop: function stop() {\n          _events.trigger(\"stage:interactionStop\");\n        }\n      };\n    }\n    /**\n     * Resize width of all child buttons. Dependently make them the same width if configured.\n     */\n    ;\n\n    _proto.resizeChildButtons = function resizeChildButtons() {\n      if (this.wrapperElement) {\n        var buttonItems = (0, _jquery)(this.wrapperElement).find(\".pagebuilder-button-item > a\");\n        var buttonResizeValue = 0;\n\n        if (this.contentType.dataStore.get(\"is_same_width\") === \"true\") {\n          if (buttonItems.length > 0) {\n            var currentLargestButtonWidth = this.findLargestButtonWidth(buttonItems);\n            var parentWrapperWidth = (0, _jquery)(this.wrapperElement).find(\".buttons-container\").width();\n\n            if (currentLargestButtonWidth === 0) {\n              return;\n            }\n\n            buttonResizeValue = Math.min(currentLargestButtonWidth, parentWrapperWidth);\n          }\n        }\n\n        buttonItems.css(\"min-width\", buttonResizeValue);\n      }\n    }\n    /**\n     * Find the largest button width for calculating same size value.\n     *\n     * @param {JQuery} buttonItems\n     * @returns {number}\n     */\n    ;\n\n    _proto.findLargestButtonWidth = function findLargestButtonWidth(buttonItems) {\n      var _this4 = this;\n\n      return _underscore.max(_underscore.map(buttonItems, function (buttonItem) {\n        return _this4.calculateButtonWidth((0, _jquery)(buttonItem));\n      }));\n    }\n    /**\n     * Manually calculate button width using content plus box widths (padding, border)\n     *\n     * @param {JQuery} buttonItem\n     * @returns {number}\n     */\n    ;\n\n    _proto.calculateButtonWidth = function calculateButtonWidth(buttonItem) {\n      if (buttonItem.is(\":visible\") === false) {\n        return 0;\n      }\n\n      var widthProperties = [\"paddingLeft\", \"paddingRight\", \"borderLeftWidth\", \"borderRightWidth\"];\n      var buttonText = buttonItem.find(\"[data-element='link_text']\");\n      var textWidth = buttonText.css(\"display\", \"inline-block\").width();\n      buttonText.css(\"display\", \"\");\n      return widthProperties.reduce(function (accumulatedWidth, widthProperty) {\n        return accumulatedWidth + (parseInt(buttonItem.css(widthProperty), 10) || 0);\n      }, textWidth);\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/buttons/appearance/inline/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/events'\n], function ($, events) {\n    'use strict';\n\n    /**\n     * Equalize the width of a list of button-item components\n     *\n     * @param {JQuery} buttonList\n     */\n    var equalizeButtonWidth = function (buttonList) {\n        var buttonMinWidth = 0;\n\n        buttonList.css('min-width', buttonMinWidth);\n        buttonList.each(function () {\n            var buttonWidth = this.offsetWidth;\n\n            if (buttonWidth > buttonMinWidth) {\n                buttonMinWidth = buttonWidth;\n            }\n        });\n        buttonList.css('min-width', buttonMinWidth);\n    };\n\n    return function (config, element) {\n        var $element = $(element),\n            buttonSelector = '[data-element=\"link\"], [data-element=\"empty_link\"]';\n\n        if ($element.data('sameWidth')) {\n            equalizeButtonWidth($element.find(buttonSelector));\n            $(window).on('resize', function () {\n                equalizeButtonWidth($element.find(buttonSelector));\n            });\n            events.on('contentType:redrawAfter', function (eventData) {\n                if ($element.closest(eventData.element).length > 0) {\n                    equalizeButtonWidth($element.find(buttonSelector));\n                }\n            });\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/buttons/converter/style/display/boolean.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Boolean = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Boolean() {}\n\n    var _proto = Boolean.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return !(value === \"none\");\n    }\n    /**\n     * Convert value to knockout format, if buttons are displayed they should be reset to default\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (!_underscore.isUndefined(value) && value === false) {\n        return \"none\";\n      }\n\n      return \"\";\n    };\n\n    return Boolean;\n  }();\n\n  return Boolean;\n});\n//# sourceMappingURL=boolean.js.map","Magento_PageBuilder/js/content-type/buttons/converter/style/display/flex.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Flex = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Flex() {}\n\n    var _proto = Flex.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return !(value === \"none\");\n    }\n    /**\n     * Convert value to knockout format, if buttons are displayed they should be inline block\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (!_underscore.isUndefined(value) && value === false) {\n        return \"none\";\n      }\n\n      return \"flex\";\n    };\n\n    return Flex;\n  }();\n\n  return Flex;\n});\n//# sourceMappingURL=flex.js.map","Magento_PageBuilder/js/content-type/buttons/converter/style/preview/display/flex.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Display = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Display() {}\n\n    var _proto = Display.prototype;\n\n    /**\n     * Ensure the display none property doesn't persist to the preview\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return;\n    }\n    /**\n     * Ensure the display none property doesn't persist to the preview\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return \"flex\";\n    };\n\n    return Display;\n  }();\n\n  return Display;\n});\n//# sourceMappingURL=flex.js.map","Magento_PageBuilder/js/content-type/column/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"Magento_Ui/js/modal/alert\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type-menu/option\", \"Magento_PageBuilder/js/content-type/column-group/grid-size\", \"Magento_PageBuilder/js/content-type/column-line/preview\", \"Magento_PageBuilder/js/content-type/preview-collection\", \"Magento_PageBuilder/js/content-type/column/resize\"], function (_jquery, _knockout, _translate, _events, _alert, _config, _contentTypeFactory, _option, _gridSize, _preview, _previewCollection, _resize) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * Fields that should not be considered when evaluating whether an object has been configured.\n     *\n     * @see {Preview.isConfigured}\n     * @type {[string]}\n     */\n\n    /**\n     * @param {ContentTypeInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this; // Update the width label for the column\n\n      _this.resizing = _knockout.observable(false);\n      _this.fieldsToIgnoreOnRemove = [\"width\"];\n\n      _this.contentType.dataStore.subscribe(_this.updateColumnWidthClass.bind(_assertThisInitialized(_this)), \"width\");\n\n      _this.contentType.dataStore.subscribe(_this.updateDisplayLabel.bind(_assertThisInitialized(_this)), \"width\");\n\n      _this.contentType.dataStore.subscribe(_this.triggerChildren.bind(_assertThisInitialized(_this)), \"width\");\n\n      _this.contentType.parentContentType.dataStore.subscribe(_this.updateDisplayLabel.bind(_assertThisInitialized(_this)), \"grid_size\"); // Update the column number for the column\n\n\n      _this.contentType.parentContentType.children.subscribe(_this.updateDisplayLabel.bind(_assertThisInitialized(_this)));\n\n      return _this;\n    }\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this);\n\n      _events.on(\"column:moveAfter\", function (args) {\n        if (args.contentType.id === _this2.contentType.id) {\n          _this2.updateDisplayLabel();\n        }\n\n        _this2.resetRemoveOnLastColumn(args.targetParent);\n\n        _this2.resetRemoveOnLastColumn(args.sourceParent);\n      });\n\n      _events.on(\"column:initializeAfter\", function (args) {\n        _this2.resetRemoveOnLastColumn(args.columnLine);\n      });\n\n      _events.on(\"column:dropAfter\", function (args) {\n        _this2.resetRemoveOnLastColumn(_this2.contentType.parentContentType);\n      });\n\n      _events.on(\"column:duplicateAfter\", function (args) {\n        _this2.resetRemoveOnLastColumn(args.duplicateContentType.parentContentType);\n      });\n\n      _events.on(\"column:removeAfter\", function (args) {\n        if (args.contentType.id === _this2.contentType.id) {\n          _this2.resetRemoveOnLastColumn(args.parentContentType);\n        }\n      });\n    }\n    /**\n     * Make a reference to the element in the column\n     *\n     * @param element\n     */\n    ;\n\n    _proto.initColumn = function initColumn(element) {\n      this.element = (0, _jquery)(element);\n      this.updateColumnWidthClass();\n\n      _events.trigger(\"column:initializeAfter\", {\n        column: this.contentType,\n        element: (0, _jquery)(element),\n        columnLine: this.contentType.parentContentType,\n        columnGroup: this.contentType.parentContentType.parentContentType\n      });\n\n      this.updateDisplayLabel();\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.move = new _option({\n        preview: this,\n        icon: \"<i class='icon-admin-pagebuilder-handle'></i>\",\n        title: (0, _translate)(\"Move\"),\n        classes: [\"move-column\"],\n        sort: 10\n      });\n      return options;\n    }\n    /**\n     * Init the resize handle for the resizing functionality\n     *\n     * @param handle\n     */\n    ;\n\n    _proto.bindResizeHandle = function bindResizeHandle(handle) {\n      _events.trigger(\"column:resizeHandleBindAfter\", {\n        column: this.contentType,\n        handle: (0, _jquery)(handle),\n        columnLine: this.contentType.parentContentType\n      });\n    }\n    /**\n     * Wrap the current column in a group if it not in a column-group\n     *\n     * @returns {Promise<ContentTypeCollectionInterface>}\n     */\n    ;\n\n    _proto.createColumnGroup = function createColumnGroup() {\n      var _this3 = this;\n\n      if (this.contentType.parentContentType.config.name !== \"column-group\") {\n        var index = this.contentType.parentContentType.children().indexOf(this.contentType); // Remove child instantly to stop content jumping around\n\n        this.contentType.parentContentType.removeChild(this.contentType); // Create a new instance of column group to wrap our columns with\n\n        var defaultGridSize = (0, _gridSize.getDefaultGridSize)();\n        return (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column-group\"), this.contentType.parentContentType, this.contentType.stageId, {\n          grid_size: defaultGridSize\n        }).then(function (columnGroup) {\n          var col1Width = (Math.ceil(defaultGridSize / 2) * 100 / defaultGridSize).toFixed(Math.round(100 / defaultGridSize) !== 100 / defaultGridSize ? 8 : 0);\n          return Promise.all([(0, _contentTypeFactory)(_this3.contentType.config, columnGroup, columnGroup.stageId, {\n            width: col1Width + \"%\"\n          }), (0, _contentTypeFactory)(_this3.contentType.config, columnGroup, columnGroup.stageId, {\n            width: 100 - parseFloat(col1Width) + \"%\"\n          })]).then(function (columns) {\n            columnGroup.addChild(columns[0], 0);\n            columnGroup.addChild(columns[1], 1);\n\n            _this3.contentType.parentContentType.addChild(columnGroup, index);\n\n            _this3.fireMountEvent(columnGroup, columns[0], columns[1]);\n\n            return columnGroup;\n          });\n        });\n      }\n    }\n    /**\n     * Duplicate a child of the current instance\n     *\n     * @param {ContentTypeCollectionInterface<Preview>} contentType\n     * @param {boolean} autoAppend\n     * @returns {Promise<ContentTypeCollectionInterface> | void}\n     */\n    ;\n\n    _proto.clone = function clone(contentType, autoAppend) {\n      if (autoAppend === void 0) {\n        autoAppend = true;\n      }\n\n      var resizeUtils = this.contentType.parentContentType.preview.getResizeUtils(); // Are we duplicating from a container content type?\n\n      if (contentType.config.name !== \"column\" || this.contentType.parentContentType.children().length === 0 || this.contentType.parentContentType.children().length > 0 && resizeUtils.getColumnsWidth() < 100) {\n        return _previewCollection2.prototype.clone.call(this, contentType, autoAppend);\n      }\n\n      var biggestShrinkableColumn = resizeUtils.findBiggerShrinkableColumn(contentType);\n\n      if (biggestShrinkableColumn) {\n        var shrinkableClone = _previewCollection2.prototype.clone.call(this, contentType, autoAppend);\n\n        if (shrinkableClone) {\n          var newShrinkableColumnWidth = resizeUtils.getColumnWidth(biggestShrinkableColumn) - resizeUtils.getColumnWidth(contentType);\n          var duplicateColumnWidth = resizeUtils.getColumnWidth(contentType);\n          shrinkableClone.then(function (duplicateContentType) {\n            (0, _resize.updateColumnWidth)(biggestShrinkableColumn, resizeUtils.getAcceptedColumnWidth(newShrinkableColumnWidth.toString()));\n            (0, _resize.updateColumnWidth)(duplicateContentType, duplicateColumnWidth);\n            return duplicateContentType;\n          });\n        }\n\n        return;\n      } // Attempt to split the current column into parts\n\n\n      var splitTimes = Math.round(resizeUtils.getColumnWidth(contentType) / resizeUtils.getSmallestColumnWidth());\n\n      if (splitTimes > 1) {\n        var splitClone = _previewCollection2.prototype.clone.call(this, contentType, autoAppend);\n\n        if (splitClone) {\n          splitClone.then(function (duplicateContentType) {\n            /**\n             * Distribute the width across the original & duplicated columns, if the we have an odd number of\n             * split times apply it to the original.\n             */\n            var originalWidth = (Math.floor(splitTimes / 2) + splitTimes % 2) * resizeUtils.getSmallestColumnWidth();\n            var duplicateWidth = Math.floor(splitTimes / 2) * resizeUtils.getSmallestColumnWidth();\n            (0, _resize.updateColumnWidth)(contentType, resizeUtils.getAcceptedColumnWidth(originalWidth.toString()));\n            (0, _resize.updateColumnWidth)(duplicateContentType, resizeUtils.getAcceptedColumnWidth(duplicateWidth.toString()));\n            return duplicateContentType;\n          });\n        }\n      } else {\n        // Conduct an outward search on the children to locate a suitable shrinkable column\n        var shrinkableColumn = resizeUtils.findShrinkableColumn(contentType);\n\n        if (shrinkableColumn) {\n          var _shrinkableClone = _previewCollection2.prototype.clone.call(this, contentType, autoAppend);\n\n          if (_shrinkableClone) {\n            _shrinkableClone.then(function (duplicateContentType) {\n              (0, _resize.updateColumnWidth)(shrinkableColumn, resizeUtils.getAcceptedColumnWidth((resizeUtils.getColumnWidth(shrinkableColumn) - resizeUtils.getSmallestColumnWidth()).toString()));\n              (0, _resize.updateColumnWidth)(duplicateContentType, resizeUtils.getSmallestColumnWidth());\n              return duplicateContentType;\n            });\n          }\n        } else {\n          // If we aren't able to duplicate inform the user why\n          (0, _alert)({\n            content: (0, _translate)(\"There is no free space within the column group to perform this action.\"),\n            title: (0, _translate)(\"Unable to duplicate column\")\n          });\n        }\n      }\n    }\n    /**\n     * Update the display label for the column\n     */\n    ;\n\n    _proto.updateDisplayLabel = function updateDisplayLabel() {\n      if (this.contentType.parentContentType.preview instanceof _preview) {\n        var newWidth = parseFloat(this.contentType.dataStore.get(\"width\").toString());\n        var grandParent = this.contentType.parentContentType.parentContentType;\n        var columnGroupPreview = grandParent.preview;\n        var gridSize = columnGroupPreview.gridSize();\n        var newLabel = Math.round(newWidth / (100 / gridSize)) + \"/\" + gridSize;\n        var columnIndex = this.contentType.parentContentType.children().indexOf(this.contentType);\n        var columnNumber = columnIndex !== -1 ? columnIndex + 1 + \" \" : \"\";\n        this.displayLabel((0, _translate)(\"Column\") + \" \" + columnNumber + \"(\" + newLabel + \")\");\n      }\n    }\n    /**\n     * Reset remove option on all columns within a column-group depending on the number of remaining child columns\n     * @param parentContentType\n     */\n    ;\n\n    _proto.resetRemoveOnLastColumn = function resetRemoveOnLastColumn(parentContentType) {\n      if (!parentContentType) {\n        // can happen if the column is moved within the same column group\n        return;\n      }\n\n      if (parentContentType.config.name !== \"column-line\") {\n        // for legacy content in preview mode before stage is initialized, the parent may not be a column line\n        return;\n      }\n\n      var siblings = parentContentType.children();\n      var siblingColumnLines = parentContentType.parentContentType.children();\n      var totalColumnCount = 0;\n      siblingColumnLines.forEach(function (columnLine) {\n        var columns = columnLine.children();\n        columns.forEach(function (column) {\n          totalColumnCount++;\n        });\n      });\n      var isRemoveDisabled = totalColumnCount <= 1;\n      siblingColumnLines.forEach(function (columnLine) {\n        var columns = columnLine.children();\n        columns.forEach(function (column) {\n          var removeOption = column.preview.getOptions().getOption(\"remove\");\n          removeOption.isDisabled(isRemoveDisabled);\n        });\n      });\n    }\n    /**\n     * Syncs the column-width-* class on the children-wrapper with the current width to the nearest tenth rounded up\n     */\n    ;\n\n    _proto.updateColumnWidthClass = function updateColumnWidthClass() {\n      // Only update once instantiated\n      if (!this.element) {\n        return;\n      }\n\n      var currentClass = this.element.attr(\"class\").match(/(?:^|\\s)(column-width-\\d{1,3})(?:$|\\s)/);\n\n      if (currentClass !== null) {\n        this.element.removeClass(currentClass[1]);\n      }\n\n      var roundedWidth = Math.ceil(parseFloat(this.contentType.dataStore.get(\"width\").toString()) / 10) * 10;\n      this.element.addClass(\"column-width-\" + roundedWidth);\n    }\n    /**\n     * Return selected element styles\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyle = function getStyle(element, styleProperties) {\n      var stylesObject = element.style();\n      return styleProperties.reduce(function (obj, key) {\n        var _extends2;\n\n        return _extends({}, obj, (_extends2 = {}, _extends2[key] = stylesObject[key], _extends2));\n      }, {});\n    }\n    /**\n     * Return element styles without selected\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyleWithout = function getStyleWithout(element, styleProperties) {\n      var stylesObject = element.style();\n      return Object.keys(stylesObject).filter(function (key) {\n        return !styleProperties.includes(key);\n      }).reduce(function (obj, key) {\n        var _extends3;\n\n        return _extends({}, obj, (_extends3 = {}, _extends3[key] = stylesObject[key], _extends3));\n      }, {});\n    }\n    /**\n     * Fire the mount event for content types\n     *\n     * @param {ContentTypeInterface[]} contentTypes\n     */\n    ;\n\n    _proto.fireMountEvent = function fireMountEvent() {\n      for (var _len = arguments.length, contentTypes = new Array(_len), _key = 0; _key < _len; _key++) {\n        contentTypes[_key] = arguments[_key];\n      }\n\n      contentTypes.forEach(function (contentType) {\n        _events.trigger(\"contentType:mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n\n        _events.trigger(contentType.config.name + \":mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n      });\n    }\n    /**\n     * Delegate trigger call on children elements.\n     */\n    ;\n\n    _proto.triggerChildren = function triggerChildren() {\n      if (this.contentType.parentContentType.preview instanceof _preview) {\n        var newWidth = parseFloat(this.contentType.dataStore.get(\"width\").toString());\n        this.delegate(\"trigger\", \"columnWidthChangeAfter\", {\n          width: newWidth\n        });\n      }\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/column/resize.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/array\"], function (_array) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Resize = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Resize(columnGroup, columnLine) {\n      this.columnGroup = columnGroup;\n      this.columnLine = columnLine;\n    }\n    /**\n     * Get the grid size for this columnGroup\n     *\n     * @returns {number}\n     */\n\n\n    var _proto = Resize.prototype;\n\n    _proto.getGridSize = function getGridSize() {\n      return parseInt(this.columnGroup.dataStore.get(\"grid_size\").toString(), 10);\n    }\n    /**\n     * Get the initial grid size for this columnGroup before it was updated\n     *\n     * @returns {number}\n     */\n    ;\n\n    _proto.getInitialGridSize = function getInitialGridSize() {\n      return parseInt(this.columnGroup.dataStore.get(\"initial_grid_size\", 0).toString(), 10);\n    }\n    /**\n     * Get the smallest column width possible\n     *\n     * @param {number} gridSize\n     * @returns {number}\n     */\n    ;\n\n    _proto.getSmallestColumnWidth = function getSmallestColumnWidth(gridSize) {\n      gridSize = gridSize || this.getInitialGridSize() || this.getGridSize();\n      return this.getAcceptedColumnWidth(parseFloat((100 / gridSize).toString()).toFixed(Math.round(100 / gridSize) !== 100 / gridSize ? 8 : 0));\n    }\n    /**\n     * Get an accepted column width to resolve rounding issues, e.g. turn 49.995% into 50%\n     *\n     * @param {string} width\n     * @param {number} gridSize\n     * @returns {number}\n     */\n    ;\n\n    _proto.getAcceptedColumnWidth = function getAcceptedColumnWidth(width, gridSize) {\n      gridSize = gridSize || this.getInitialGridSize() || this.getGridSize();\n      var newWidth = 0;\n\n      for (var i = gridSize; i > 0; i--) {\n        var percentage = parseFloat((100 / gridSize * i).toFixed(Math.round(100 / gridSize * i) !== 100 / gridSize * i ? 8 : 0)); // Allow for rounding issues\n\n        if (parseFloat(width) > percentage - 0.1 && parseFloat(width) < percentage + 0.1) {\n          newWidth = percentage;\n          break;\n        }\n      }\n\n      return newWidth;\n    }\n    /**\n     * Return the width of the column\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @returns {number}\n     */\n    ;\n\n    _proto.getColumnWidth = function getColumnWidth(column) {\n      return this.getAcceptedColumnWidth(column.dataStore.get(\"width\").toString());\n    }\n    /**\n     * Get the total width of all columns in the column line\n     *\n     * @returns {number}\n     */\n    ;\n\n    _proto.getColumnsWidth = function getColumnsWidth() {\n      var _this = this;\n\n      return this.getAcceptedColumnWidth(this.columnLine.children().map(function (column) {\n        return _this.getColumnWidth(column);\n      }).reduce(function (widthA, widthB) {\n        return widthA + (widthB ? widthB : 0);\n      }).toString());\n    }\n    /**\n     * Determine the pixel position of every column that can be created within the group\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {GroupPositionCache} groupPosition\n     * @returns {ColumnWidth[]}\n     */\n    ;\n\n    _proto.determineColumnWidths = function determineColumnWidths(column, groupPosition) {\n      var gridSize = this.getGridSize();\n      var singleColumnWidth = groupPosition.outerWidth / gridSize;\n      var adjacentColumn = getAdjacentColumn(column, \"+1\");\n      var columnWidths = [];\n      var columnLeft = column.preview.element.offset().left - parseInt(column.preview.element.css(\"margin-left\"), 10);\n      var adjacentRightPosition = adjacentColumn.preview.element.offset().left + adjacentColumn.preview.element.outerWidth(true); // Determine the maximum size (in pixels) that this column can be dragged to\n\n      var columnsToRight = column.parentContentType.children().length - (getColumnIndexInGroup(column) + 1);\n      var leftMaxWidthFromChildren = groupPosition.left + groupPosition.outerWidth - columnsToRight * singleColumnWidth + 10;\n      var rightMaxWidthFromChildren = groupPosition.left + (column.parentContentType.children().length - columnsToRight) * singleColumnWidth - 10; // Due to rounding we add a threshold of 10\n      // Iterate through the amount of columns generating the position for both left & right interactions\n\n      for (var i = gridSize; i > 0; i--) {\n        var position = Math.round(columnLeft + singleColumnWidth * i);\n\n        if (position > Math.round(leftMaxWidthFromChildren)) {\n          continue;\n        }\n\n        columnWidths.push({\n          forColumn: \"left\",\n          // These positions are for the left column in the pair\n          name: i + \"/\" + gridSize,\n          position: position,\n          width: getRoundedColumnWidth(100 / gridSize * i)\n        });\n      }\n\n      for (var _i = 1; _i < gridSize; _i++) {\n        var _position = Math.floor(adjacentRightPosition - _i * singleColumnWidth);\n\n        if (_position < Math.floor(rightMaxWidthFromChildren)) {\n          continue;\n        } // The right interaction is only used when we're crushing a column that isn't adjacent\n\n\n        columnWidths.push({\n          forColumn: \"right\",\n          // These positions are for the left column in the pair\n          name: _i + \"/\" + gridSize,\n          position: _position,\n          width: getRoundedColumnWidth(100 / gridSize * _i)\n        });\n      }\n\n      return columnWidths;\n    }\n    /**\n     * Find a column which can be shrunk for the current resize action\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {\"left\" | \"right\"} direction\n     * @returns {ContentTypeCollectionInterface<ColumnPreview>}\n     */\n    ;\n\n    _proto.findShrinkableColumnForResize = function findShrinkableColumnForResize(column, direction) {\n      var _this2 = this;\n\n      var currentIndex = getColumnIndexInGroup(column);\n      var columnItemsArray = column.parentContentType.children();\n      var searchArray;\n\n      switch (direction) {\n        case \"right\":\n          searchArray = columnItemsArray.slice(currentIndex + 1);\n          break;\n\n        case \"left\":\n          searchArray = columnItemsArray.slice(0).reverse().slice(columnItemsArray.length - currentIndex);\n          break;\n      }\n\n      return searchArray.find(function (groupColumn) {\n        return _this2.getColumnWidth(groupColumn) > _this2.getSmallestColumnWidth();\n      });\n    }\n    /**\n     * Find a shrinkable column outwards from the current column\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @returns {ContentTypeCollectionInterface<ColumnPreview>}\n     */\n    ;\n\n    _proto.findShrinkableColumn = function findShrinkableColumn(column) {\n      var _this3 = this;\n\n      return (0, _array.outwardSearch)(column.parentContentType.children(), getColumnIndexInGroup(column), function (neighbourColumn) {\n        return _this3.getColumnWidth(neighbourColumn) > _this3.getSmallestColumnWidth();\n      });\n    }\n    /**\n     * Find a shrinkable column of a greater size outwards from the current column\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @returns {ContentTypeCollectionInterface<ColumnPreview>}\n     */\n    ;\n\n    _proto.findBiggerShrinkableColumn = function findBiggerShrinkableColumn(column) {\n      var _this4 = this;\n\n      return (0, _array.outwardSearch)(column.parentContentType.children(), getColumnIndexInGroup(column), function (neighbourColumn) {\n        return _this4.getColumnWidth(neighbourColumn) > _this4.getColumnWidth(column);\n      });\n    }\n    /**\n     * Calculate the ghost size for the resizing action\n     *\n     * @param {GroupPositionCache} groupPosition\n     * @param {number} currentPos\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {string} modifyColumnInPair\n     * @param {MaxGhostWidth} maxGhostWidth\n     * @returns {number}\n     */\n    ;\n\n    _proto.calculateGhostWidth = function calculateGhostWidth(groupPosition, currentPos, column, modifyColumnInPair, maxGhostWidth) {\n      var ghostWidth = currentPos - groupPosition.left;\n\n      switch (modifyColumnInPair) {\n        case \"left\":\n          var singleColumnWidth = column.preview.element.position().left + groupPosition.outerWidth / this.getGridSize(); // Don't allow the ghost widths be less than the smallest column\n\n          if (ghostWidth <= singleColumnWidth) {\n            ghostWidth = singleColumnWidth;\n          }\n\n          if (currentPos >= maxGhostWidth.left) {\n            ghostWidth = maxGhostWidth.left - groupPosition.left;\n          }\n\n          break;\n\n        case \"right\":\n          if (currentPos <= maxGhostWidth.right) {\n            ghostWidth = maxGhostWidth.right - groupPosition.left;\n          }\n\n          break;\n      }\n\n      return ghostWidth;\n    }\n    /**\n     * Determine which column in the group should be adjusted for the current resize action\n     *\n     * @param {number} currentPos\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {ResizeHistory} history\n     * @returns {[ContentTypeCollectionInterface<ColumnPreview>, string, string]}\n     */\n    ;\n\n    _proto.determineAdjustedColumn = function determineAdjustedColumn(currentPos, column, history) {\n      var modifyColumnInPair = \"left\";\n      var usedHistory;\n      var resizeColumnLeft = column.preview.element.offset().left - parseInt(column.preview.element.css(\"margin-left\"), 10);\n      var resizeColumnWidth = column.preview.element.outerWidth(true);\n      var resizeHandlePosition = resizeColumnLeft + resizeColumnWidth;\n      var adjustedColumn;\n\n      if (currentPos >= resizeHandlePosition) {\n        // Get the history for the opposite direction of resizing\n        if (history.left.length > 0) {\n          usedHistory = \"left\";\n          adjustedColumn = history.left.reverse()[0].adjustedColumn;\n          modifyColumnInPair = history.left.reverse()[0].modifyColumnInPair;\n        } else {\n          // If we're increasing the width of our column we need to locate a column that can shrink to the\n          // right\n          adjustedColumn = this.findShrinkableColumnForResize(column, \"right\");\n        }\n      } else {\n        if (this.getColumnWidth(column) <= this.getSmallestColumnWidth()) {\n          adjustedColumn = this.findShrinkableColumnForResize(column, \"left\");\n\n          if (adjustedColumn) {\n            modifyColumnInPair = \"right\";\n          }\n        } else if (history.right.length > 0) {\n          usedHistory = \"right\";\n          adjustedColumn = history.right.reverse()[0].adjustedColumn;\n          modifyColumnInPair = history.right.reverse()[0].modifyColumnInPair;\n        } else {\n          // If we're shrinking our column we can just increase the adjacent column\n          adjustedColumn = getAdjacentColumn(column, \"+1\");\n        }\n      }\n\n      return [adjustedColumn, modifyColumnInPair, usedHistory];\n    }\n    /**\n     * Resize a column to a specific width\n     *\n     * @param {ContentTypeCollectionInterface<Preview>} column\n     * @param {number} width\n     * @param {ContentTypeCollectionInterface<Preview>} shrinkableColumn\n     */\n    ;\n\n    _proto.resizeColumn = function resizeColumn(column, width, shrinkableColumn) {\n      var current = this.getColumnWidth(column);\n      var difference = (parseFloat(width.toString()) - current).toFixed(8); // Don't run the update if we've already modified the column\n\n      if (current === parseFloat(width.toString()) || parseFloat(width.toString()) < this.getSmallestColumnWidth()) {\n        return;\n      } // Also shrink the closest shrinkable column\n\n\n      var allowedToShrink = true;\n\n      if (difference && shrinkableColumn) {\n        var currentShrinkable = this.getColumnWidth(shrinkableColumn);\n        var shrinkableSize = this.getAcceptedColumnWidth((currentShrinkable + -difference).toString()); // Ensure the column we're crushing is not becoming the same size, and it's not less than the smallest width\n\n        if (currentShrinkable === parseFloat(shrinkableSize.toString()) || parseFloat(shrinkableSize.toString()) < this.getSmallestColumnWidth()) {\n          allowedToShrink = false;\n        } else {\n          // Ensure we're not creating more columns width than the grid can support\n          if (this.gridSupportsResize(column, width, shrinkableColumn, shrinkableSize)) {\n            updateColumnWidth(shrinkableColumn, shrinkableSize);\n          } else {\n            allowedToShrink = false;\n          }\n        }\n      }\n\n      if (allowedToShrink) {\n        updateColumnWidth(column, width);\n      }\n    }\n    /**\n     * Determine if the grid supports the new proposed grid size\n     *\n     * @param {ContentTypeCollectionInterface<Preview>} column\n     * @param {number} newWidth\n     * @param {ContentTypeCollectionInterface<Preview>} shrinkableColumn\n     * @param {number} shrinkableColumnNewWidth\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.gridSupportsResize = function gridSupportsResize(column, newWidth, shrinkableColumn, shrinkableColumnNewWidth) {\n      var _this5 = this;\n\n      // Determine the total width of all other columns in the grid, excluding the ones we plan to resize\n      var otherColumnsWidth = column.parentContentType.getChildren()().filter(function (gridColumn) {\n        return gridColumn !== column && shrinkableColumn && gridColumn !== shrinkableColumn;\n      }).map(function (otherColumn) {\n        return _this5.getColumnWidth(otherColumn);\n      }).reduce(function (a, b) {\n        return a + b;\n      }, 0); // Determine if the new total grid size will be 100%, with 1 for margin of error with rounding\n\n      return comparator(otherColumnsWidth + newWidth + (shrinkableColumnNewWidth ? shrinkableColumnNewWidth : 0), 100, 0.1);\n    };\n\n    return Resize;\n  }();\n  /**\n   * Retrieve the index of the column within it's group\n   * @deprecated use getColumnIndexInLine\n   * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n   * @returns {number}\n   */\n\n\n  function getColumnIndexInGroup(column) {\n    return column.parentContentType.children().indexOf(column);\n  }\n  /**\n   * Retrieve the index of the column within it's column line\n   *\n   * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n   * @returns {number}\n   */\n\n\n  function getColumnIndexInLine(column) {\n    return column.parentContentType.children().indexOf(column);\n  }\n  /**\n   * Retrieve the adjacent column based on a direction of +1 or -1\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} column\n   * @param {\"+1\" | \"-1\"} direction\n   * @returns {ContentTypeCollectionInterface<Preview>}\n   */\n\n\n  function getAdjacentColumn(column, direction) {\n    var currentIndex = getColumnIndexInGroup(column);\n\n    if (typeof column.parentContentType.children()[currentIndex + parseInt(direction, 10)] !== \"undefined\") {\n      return column.parentContentType.children()[currentIndex + parseInt(direction, 10)];\n    }\n\n    return null;\n  }\n  /**\n   * Determine the max ghost width based on the calculated columns\n   *\n   * @param {ColumnWidth[]} columnWidths\n   * @returns {MaxGhostWidth}\n   */\n\n\n  function determineMaxGhostWidth(columnWidths) {\n    var leftColumns = columnWidths.filter(function (width) {\n      return width.forColumn === \"left\";\n    });\n    var rightColumns = columnWidths.filter(function (width) {\n      return width.forColumn === \"right\";\n    });\n    return {\n      left: leftColumns[0].position,\n      right: rightColumns[rightColumns.length - 1].position\n    };\n  }\n  /**\n   * Return the column width to 8 decimal places if it's not a whole number\n   *\n   * @param {number} width\n   * @returns {string}\n   */\n\n\n  function getRoundedColumnWidth(width) {\n    return Number(width.toFixed(Math.round(width) !== width ? 8 : 0));\n  }\n  /**\n   * Compare if two numbers are within a certain threshold of each other\n   *\n   * comparator(10,11,2) => true\n   * comparator(1.1,1.11,0.5) => true\n   *\n   * @param {number} num1\n   * @param {number} num2\n   * @param {number} threshold\n   * @returns {boolean}\n   */\n\n\n  function comparator(num1, num2, threshold) {\n    return num1 > num2 - threshold / 2 && num1 < num2 + threshold / 2;\n  }\n  /**\n   * Update the width of a column\n   *\n   * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n   * @param {number} width\n   */\n\n\n  function updateColumnWidth(column, width) {\n    column.dataStore.set(\"width\", parseFloat(width.toString()) + \"%\");\n  }\n\n  return Object.assign(Resize, {\n    getColumnIndexInGroup: getColumnIndexInGroup,\n    getColumnIndexInLine: getColumnIndexInLine,\n    getAdjacentColumn: getAdjacentColumn,\n    determineMaxGhostWidth: determineMaxGhostWidth,\n    getRoundedColumnWidth: getRoundedColumnWidth,\n    comparator: comparator,\n    updateColumnWidth: updateColumnWidth\n  });\n});\n//# sourceMappingURL=resize.js.map","Magento_PageBuilder/js/content-type/column/converter/style/margins.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Margins = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Margins() {}\n\n    var _proto = Margins.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (undefined !== value.margin) {\n        return {\n          margin: {\n            top: value.margin.top.replace(\"px\", \"\"),\n            left: value.margin.left.replace(\"px\", \"\"),\n            right: value.margin.right.replace(\"px\", \"\"),\n            bottom: value.margin.bottom.replace(\"px\", \"\")\n          }\n        };\n      }\n\n      return {};\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.margin) {\n        result.marginLeft = value.margin.left ? value.margin.left + \"px\" : \"\";\n        result.marginTop = value.margin.top ? value.margin.top + \"px\" : \"\";\n        result.marginRight = (value.margin.right && parseInt(value.margin.right, 10) !== 0 ? value.margin.right : 1) + \"px\";\n        result.marginBottom = value.margin.bottom ? value.margin.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Margins;\n  }();\n\n  return Margins;\n});\n//# sourceMappingURL=margins.js.map","Magento_PageBuilder/js/content-type/column-group/drag-and-drop.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Calculate the drop positions of a column group\n   *\n   * @param {ContentTypeCollectionInterface} group\n   * @returns {any[]}\n   */\n  function calculateDropPositions(group) {\n    var resizeUtils = group.preview.getResizeUtils();\n    var dropPositions = [];\n    group.children().forEach(function (column, index) {\n      var left = column.preview.element.position().left;\n      var width = column.preview.element.outerWidth(true);\n      var canShrink = resizeUtils.getAcceptedColumnWidth(resizeUtils.getColumnWidth(column).toString()) > resizeUtils.getSmallestColumnWidth();\n      dropPositions.push({\n        affectedColumn: column,\n        canShrink: canShrink,\n        insertIndex: index,\n        left: left,\n        placement: \"left\",\n        right: left + width / 2\n      }, {\n        affectedColumn: column,\n        canShrink: canShrink,\n        insertIndex: index + 1,\n        left: left + width / 2,\n        placement: \"right\",\n        right: left + width\n      });\n    });\n    return dropPositions;\n  }\n\n  return {\n    calculateDropPositions: calculateDropPositions\n  };\n});\n//# sourceMappingURL=drag-and-drop.js.map","Magento_PageBuilder/js/content-type/column-group/factory.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\"], function (_config, _contentTypeFactory) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create a column and add it to it's column group\n   *\n   * @param {ContentTypeCollectionInterface} columnGroup\n   * @param {number} width\n   * @param {number} index\n   * @returns {Promise<ContentTypeCollectionInterface>}\n   */\n  function createColumn(columnGroup, width, index) {\n    return (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column\"), columnGroup, columnGroup.stageId, {\n      width: parseFloat(width.toString()) + \"%\"\n    }).then(function (column) {\n      columnGroup.addChild(column, index);\n      return column;\n    }).catch(function (error) {\n      console.error(error);\n      return null;\n    });\n  }\n  /**\n   * Create a column and add it to it's column group\n   *\n   * @param {ContentTypeCollectionInterface} columnGroup\n   * @param {number} width\n   * @param {number} index\n   * @returns {Promise<ContentTypeCollectionInterface>}\n   */\n\n\n  function createColumnLine(columnGroup, width, index) {\n    return (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column-line\"), columnGroup, columnGroup.stageId, {\n      width: parseFloat(width.toString()) + \"%\"\n    }).then(function (columnLine) {\n      columnGroup.addChild(columnLine, index);\n      return columnLine;\n    }).catch(function (error) {\n      console.error(error);\n      return null;\n    });\n  }\n\n  return {\n    createColumn: createColumn,\n    createColumnLine: createColumnLine\n  };\n});\n//# sourceMappingURL=factory.js.map","Magento_PageBuilder/js/content-type/column-group/grid-size.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _wrapNativeSuper(Class) { var _cache = typeof Map === \"function\" ? new Map() : undefined; _wrapNativeSuper = function _wrapNativeSuper(Class) { if (Class === null || !_isNativeFunction(Class)) return Class; if (typeof Class !== \"function\") { throw new TypeError(\"Super expression must either be null or a function\"); } if (typeof _cache !== \"undefined\") { if (_cache.has(Class)) return _cache.get(Class); _cache.set(Class, Wrapper); } function Wrapper() { return _construct(Class, arguments, _getPrototypeOf(this).constructor); } Wrapper.prototype = Object.create(Class.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } }); return _setPrototypeOf(Wrapper, Class); }; return _wrapNativeSuper(Class); }\n\nfunction _construct(Parent, args, Class) { if (_isNativeReflectConstruct()) { _construct = Reflect.construct; } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) _setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }\n\nfunction _isNativeReflectConstruct() { if (typeof Reflect === \"undefined\" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === \"function\") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }\n\nfunction _isNativeFunction(fn) { return Function.toString.call(fn).indexOf(\"[native code]\") !== -1; }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"mage/translate\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/column/resize\"], function (_translate, _config, _resize) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Retrieve default  grid size\n   *\n   * @returns {number}\n   */\n  function getDefaultGridSize() {\n    return parseInt(_config.getConfig(\"column_grid_default\"), 10);\n  }\n  /**\n   * Retrieve the max grid size\n   *\n   * @returns {number}\n   */\n\n\n  function getMaxGridSize() {\n    return parseInt(_config.getConfig(\"column_grid_max\"), 10);\n  }\n  /**\n   * Apply the new grid size, adjusting the existing columns as needed.\n   *\n   * Rules for resizing the grid:\n   *  - The grid size can be increased up to the configured maximum value.\n   *  - The grid size can be decreased only if the number of non-empty columns is less than or equal to the new size.\n   *  - If the new grid size is less than the number of columns currently in the grid, empty columns will be deleted\n   *    to accommodate the new size.\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   * @param {Map<number, number[]>} gridSizeHistory\n   */\n\n\n  function resizeGrid(columnGroup, newGridSize, gridSizeHistory) {\n    if (newGridSize === columnGroup.preview.getResizeUtils().getInitialGridSize()) {\n      return;\n    }\n\n    validateNewGridSize(columnGroup, newGridSize);\n    columnGroup.getChildren()().forEach(function (columnLine, index) {\n      // if we have more columns than the new grid size allows, remove empty columns till the correct size\n      console.log(columnLine.getChildren()().length);\n\n      if (newGridSize < columnLine.getChildren()().length) {\n        removeEmptyColumnsToFit(columnLine, newGridSize);\n      }\n    }); // update column widths\n\n    redistributeColumnWidths(columnGroup, newGridSize, gridSizeHistory);\n  }\n  /**\n   * Validate that the new grid size is within the configured limits and can be achieved.\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   */\n\n\n  function validateNewGridSize(columnGroup, newGridSize) {\n    // Validate against the max grid size\n    if (newGridSize > getMaxGridSize()) {\n      throw new GridSizeError((0, _translate)(\"The maximum grid size supported is \" + getMaxGridSize() + \".\"));\n    } else if (newGridSize < 2) {\n      throw new GridSizeError((0, _translate)(\"The minimum grid size supported is 2.\"));\n    } // Validate that the operation will be successful\n\n\n    var doThrowException = false;\n    columnGroup.getChildren()().forEach(function (columnLine, index) {\n      var numEmptyColumns = 0;\n      var numCols = columnLine.getChildren()().length;\n      var currentGridSize = columnLine.preview.getResizeUtils().getInitialGridSize();\n\n      if (newGridSize < currentGridSize && numCols > newGridSize) {\n        columnLine.getChildren()().forEach(function (column) {\n          if (column.getChildren()().length === 0) {\n            numEmptyColumns++;\n          }\n        });\n\n        if (newGridSize < numCols - numEmptyColumns) {\n          doThrowException = true;\n        }\n      }\n    });\n\n    if (doThrowException) {\n      throw new Error((0, _translate)(\"Grid size cannot be smaller than the current total amount of columns, minus any empty columns.\"));\n    }\n  }\n  /**\n   * Remove empty columns so we can accommodate the new grid size\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   */\n\n\n  function removeEmptyColumnsToFit(columnLine, newGridSize) {\n    var columns = columnLine.getChildren()();\n    var numColumns = columns.length;\n    var i;\n\n    for (i = numColumns - 1; i >= 0; i--) {\n      var column = columns[i];\n\n      if (newGridSize < numColumns && column.getChildren()().length === 0) {\n        columnLine.removeChild(column);\n        numColumns--;\n      }\n    }\n  }\n  /**\n   * Adjust columns widths across the new grid size, making sure each column is at least one grid size in width\n   * and the entire grid size is distributed.\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   * @param {Map<number, number[]>} gridSizeHistory\n   */\n\n\n  function redistributeColumnWidths(columnGroup, newGridSize, gridSizeHistory) {\n    // apply known column widths if we have resized before\n    if (gridSizeHistory.has(newGridSize) && gridSizeHistory.get(newGridSize).length === columnGroup.getChildren()().length) {\n      var columnWidths = gridSizeHistory.get(newGridSize);\n      columnGroup.getChildren()().forEach(function (column, index) {\n        (0, _resize.updateColumnWidth)(column, columnWidths[index]);\n      });\n      columnGroup.dataStore.set(\"grid_size\", newGridSize);\n      columnGroup.dataStore.unset(\"initial_grid_size\");\n      return;\n    }\n\n    var columnGroupResizeUtil = columnGroup.preview.getResizeUtils();\n    var existingGridSize = columnGroupResizeUtil.getInitialGridSize();\n    var minColWidth = parseFloat((100 / newGridSize).toString()).toFixed(Math.round(100 / newGridSize) !== 100 / newGridSize ? 8 : 0);\n    columnGroup.getChildren()().forEach(function (columnLine, columnLineIndex) {\n      var totalNewWidths = 0;\n      var remainingWidth = 0;\n      var numColumns = columnLine.getChildren()().length;\n      var resizeUtils = columnLine.preview.getResizeUtils();\n      columnLine.getChildren()().forEach(function (column, index) {\n        var existingWidth = resizeUtils.getColumnWidth(column);\n        var fractionColumnWidth = Math.round(existingWidth / (100 / existingGridSize));\n        /**\n         * Determine if the grid & column are directly compatible with the new defined grid size, this will\n         * directly convert fractions to their equivalent of the new grid size.\n         *\n         * For instance changing a 12 column grid with 2 x 6 / 12 columns to a 6 grid is fully compatible.\n         *\n         * Check the existing grid size and new grid size are divisible, verify the amount of columns will fit\n         * in the new grid size and finally check the calculation to convert the existing column width results\n         * in a positive integer.\n         */\n\n        if ((existingGridSize > newGridSize && existingGridSize % newGridSize === 0 || existingGridSize < newGridSize && newGridSize % existingGridSize === 0) && newGridSize % numColumns === 0 && newGridSize / existingGridSize * fractionColumnWidth % 1 === 0) {\n          // We don't need to modify the columns width as it's compatible, we will however increment the\n          // width counter as some other columns may not be compatible.\n          totalNewWidths += existingWidth;\n        } else {\n          var newWidth = (100 * Math.floor(existingWidth / 100 * newGridSize) / newGridSize).toFixed(Math.round(100 / newGridSize) !== 100 / newGridSize ? 8 : 0); // make sure the column is at least one grid size wide\n\n          if (parseFloat(newWidth) < parseFloat(minColWidth)) {\n            newWidth = minColWidth;\n          } // make sure we leave enough space for other columns\n\n\n          var widthTaken = totalNewWidths + (numColumns - index - 1) * parseFloat(minColWidth);\n          var maxAvailableWidth = 100 - totalNewWidths;\n\n          if (parseFloat(newWidth) > maxAvailableWidth) {\n            var gridWidth = Math.round(100 / newGridSize) !== 100 / newGridSize ? 8 : 0;\n            newWidth = maxAvailableWidth.toFixed(gridWidth);\n          } // Calculate any width lost from the column, if a 5 / 12 is becoming a 2 / 6 then it's lost 1 / 12\n\n\n          remainingWidth += existingWidth - parseFloat(newWidth);\n          /**\n           * Determine if we have enough remaining width, and apply it to the current column, this results in\n           * a subsequent column always receiving any additional width from the previous column\n           */\n\n          if (resizeUtils.getSmallestColumnWidth(newGridSize) === resizeUtils.getAcceptedColumnWidth(remainingWidth.toString(), newGridSize)) {\n            var widthWithRemaining = resizeUtils.getAcceptedColumnWidth((parseFloat(newWidth) + remainingWidth).toString(), newGridSize);\n\n            if (widthWithRemaining > 0) {\n              newWidth = widthWithRemaining.toFixed(Math.round(100 / widthWithRemaining) !== 100 / widthWithRemaining ? 8 : 0);\n              remainingWidth = 0;\n            }\n          }\n\n          totalNewWidths += parseFloat(newWidth);\n          (0, _resize.updateColumnWidth)(column, parseFloat(newWidth));\n        }\n\n        column.preview.updateDisplayLabel();\n      });\n    });\n    columnGroup.dataStore.set(\"grid_size\", newGridSize);\n    columnGroup.dataStore.unset(\"initial_grid_size\");\n    columnGroup.getChildren()().forEach(function (columnLine, index) {\n      var resizeUtils = columnLine.preview.getResizeUtils();\n\n      if (Math.round(resizeUtils.getColumnsWidth()) < 100) {\n        applyLeftoverColumnsInColumnLine(columnLine, newGridSize);\n      }\n    });\n  }\n  /**\n   * Make sure the full grid size is distributed across the columns\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   */\n\n\n  function applyLeftoverColumns(columnGroup, newGridSize) {\n    var resizeUtils = columnGroup.preview.getResizeUtils();\n    var minColWidth = parseFloat((100 / newGridSize).toString()).toFixed(Math.round(100 / newGridSize) !== 100 / newGridSize ? 8 : 0);\n    var column;\n\n    for (var _iterator = _createForOfIteratorHelperLoose(columnGroup.getChildren()()), _step; !(_step = _iterator()).done;) {\n      column = _step.value;\n\n      if (Math.round(resizeUtils.getColumnsWidth()) < 100) {\n        (0, _resize.updateColumnWidth)(column, parseFloat(resizeUtils.getColumnWidth(column).toString()) + parseFloat(minColWidth));\n      } else {\n        break;\n      }\n    }\n  }\n  /**\n   * Make sure the full grid size is distributed across the columns\n   *\n   * @param {ContentTypeCollectionInterface<Preview>} columnGroup\n   * @param {number} newGridSize\n   */\n\n\n  function applyLeftoverColumnsInColumnLine(columnLine, newGridSize) {\n    var resizeUtils = columnLine.preview.getResizeUtils();\n    var minColWidth = parseFloat((100 / newGridSize).toString()).toFixed(Math.round(100 / newGridSize) !== 100 / newGridSize ? 8 : 0);\n    var column;\n\n    for (var _iterator2 = _createForOfIteratorHelperLoose(columnLine.getChildren()()), _step2; !(_step2 = _iterator2()).done;) {\n      column = _step2.value;\n\n      if (Math.round(resizeUtils.getColumnsWidth()) < 100) {\n        (0, _resize.updateColumnWidth)(column, parseFloat(resizeUtils.getColumnWidth(column).toString()) + parseFloat(minColWidth));\n      } else {\n        break;\n      }\n    }\n  }\n\n  var GridSizeError = /*#__PURE__*/function (_Error) {\n    \"use strict\";\n\n    _inheritsLoose(GridSizeError, _Error);\n\n    function GridSizeError(m) {\n      var _this;\n\n      _this = _Error.call(this, m) || this;\n      Object.setPrototypeOf(_assertThisInitialized(_this), GridSizeError.prototype);\n      return _this;\n    }\n\n    return GridSizeError;\n  }( /*#__PURE__*/_wrapNativeSuper(Error));\n\n  return {\n    getDefaultGridSize: getDefaultGridSize,\n    getMaxGridSize: getMaxGridSize,\n    resizeGrid: resizeGrid,\n    GridSizeError: GridSizeError\n  };\n});\n//# sourceMappingURL=grid-size.js.map","Magento_PageBuilder/js/content-type/column-group/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/drag-drop/move-content-type\", \"Magento_PageBuilder/js/drag-drop/registry\", \"Magento_PageBuilder/js/drag-drop/sortable\", \"Magento_PageBuilder/js/utils/create-stylesheet\", \"Magento_PageBuilder/js/content-type/column/resize\", \"Magento_PageBuilder/js/content-type/preview-collection\", \"Magento_PageBuilder/js/content-type/column-group/drag-and-drop\", \"Magento_PageBuilder/js/content-type/column-group/factory\", \"Magento_PageBuilder/js/content-type/column-group/grid-size\", \"Magento_PageBuilder/js/content-type/column-group/registry\"], function (_jquery, _knockout, _translate, _hideShowOption, _events, _underscore, _config, _contentTypeFactory, _moveContentType, _registry, _sortable, _createStylesheet, _resize, _previewCollection, _dragAndDrop, _factory, _gridSize, _registry2) {\n  function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== \"function\") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     *\n     * @param {ContentTypeCollection} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this;\n      _this.resizing = _knockout.observable(false);\n      _this.hasEmptyChild = _knockout.computed(function () {\n        var empty = false;\n\n        _this.contentType.getChildren()().forEach(function (column) {\n          if (column.getChildren()().length === 0) {\n            empty = true;\n          }\n        });\n\n        return empty;\n      });\n      _this.gridSize = _knockout.observable();\n      _this.gridSizeInput = _knockout.observable();\n      _this.gridSizeArray = _knockout.observableArray([]);\n      _this.gridSizeError = _knockout.observable();\n      _this.gridSizeMax = _knockout.observable((0, _gridSize.getMaxGridSize)());\n      _this.gridFormOpen = _knockout.observable(false);\n      _this.gridChange = _knockout.observable(false);\n      _this.gridToolTipOverFlow = _knockout.observable(false);\n      _this.resizeColumnWidths = [];\n      _this.resizeHistory = {\n        left: [],\n        right: []\n      };\n      _this.dropPositions = [];\n      _this.gridSizeHistory = new Map();\n      _this.interactionLevel = 0;\n      _this.resizeUtils = new _resize(_this.contentType); // Keep track of the grid size in an observable\n\n      _this.contentType.dataStore.subscribe(function (state) {\n        var gridSize = parseInt(state.grid_size.toString(), 10);\n\n        _this.gridSize(gridSize);\n\n        _this.gridSizeInput(gridSize);\n\n        if (gridSize) {\n          _this.gridSizeArray(new Array(gridSize));\n        }\n      }, \"grid_size\");\n\n      _events.on(\"contentType:removeAfter\", function (args) {\n        if (args.parentContentType && args.parentContentType.id === _this.contentType.id) {\n          _underscore.defer(function () {\n            _this.spreadWidth(args.index);\n          });\n        }\n      });\n\n      _events.on(\"column:initializeAfter\", function (args) {\n        // Does the events parent match the previews column group?\n        if (args.columnGroup.id === _this.contentType.id) {\n          _this.bindDraggable(args.column);\n        }\n      });\n\n      _events.on(\"stage:\" + _this.contentType.stageId + \":fullScreenModeChangeAfter\", _this.moveContentsToNewColumnGroup.bind(_assertThisInitialized(_this)));\n\n      _events.on(\"column-group:renderAfter\", function (args) {\n        if (args.contentType.id === _this.contentType.id) {\n          if (!_this.hasColumnLine(args.contentType)) {\n            args.element.classList.add(\"no-column-line\");\n          } else {\n            args.element.classList.remove(\"no-column-line\");\n            args.element.classList.add(\"with-column-line\");\n          }\n        }\n      });\n\n      _this.contentType.children.subscribe(_underscore.debounce(_this.removeIfEmpty.bind(_assertThisInitialized(_this)), 50));\n\n      return _this;\n    }\n    /**\n     * Handle user editing an instance\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.onOptionEdit = function onOptionEdit() {\n      var numCols = this.contentType.getChildren()().length; // count the number of non empty columns\n\n      var numEmptyColumns = 0;\n      this.contentType.getChildren()().forEach(function (column) {\n        if (column.getChildren()().length === 0) {\n          numEmptyColumns++;\n        }\n      });\n      var appearance = this.contentType.dataStore.get(\"appearance\") ? this.contentType.dataStore.get(\"appearance\") : \"default\";\n      this.contentType.dataStore.set(\"appearance\", appearance);\n      this.contentType.dataStore.set(\"non_empty_column_count\", this.getNonEmptyColumnCount());\n      this.contentType.dataStore.set(\"max_grid_size\", (0, _gridSize.getMaxGridSize)());\n      this.contentType.dataStore.set(\"initial_grid_size\", this.contentType.dataStore.get(\"grid_size\"));\n\n      _previewCollection2.prototype.openEdit.call(this);\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this);\n\n      if (_config.getContentTypeConfig(\"column\")) {\n        _events.on(\"column-group:dropAfter\", function (args) {\n          if (args.id === _this2.contentType.id) {\n            _this2.setDefaultGridSizeOnColumnGroup();\n\n            _this2.addDefaultColumnLine(args);\n          }\n        });\n      }\n\n      _events.on(\"form:\" + this.contentType.id + \":saveAfter\", function () {\n        if (_this2.contentType.dataStore.get(\"grid_size\") !== _this2.contentType.dataStore.get(\"initial_grid_size\")) {\n          _this2.updateGridSize();\n        }\n      });\n    }\n    /**\n     * Set default grid size on current column group\n     */\n    ;\n\n    _proto.setDefaultGridSizeOnColumnGroup = function setDefaultGridSizeOnColumnGroup() {\n      this.contentType.dataStore.set(\"grid_size\", (0, _gridSize.getDefaultGridSize)());\n    }\n    /**\n     * Add Columns to the current Column Group\n     *\n     * @returns {Promise<ContentTypeCollectionInterface>}\n     */\n    ;\n\n    _proto.createColumns = function createColumns() {\n      var _this3 = this;\n\n      var defaultGridSize = (0, _gridSize.getDefaultGridSize)();\n      var col1Width = (Math.ceil(defaultGridSize / 2) * 100 / defaultGridSize).toFixed(Math.round(100 / defaultGridSize) !== 100 / defaultGridSize ? 8 : 0);\n      Promise.all([(0, _contentTypeFactory)(_config.getContentTypeConfig(\"column\"), this.contentType, this.contentType.stageId, {\n        width: col1Width + \"%\"\n      }), (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column\"), this.contentType, this.contentType.stageId, {\n        width: 100 - parseFloat(col1Width) + \"%\"\n      })]).then(function (columns) {\n        _this3.contentType.addChild(columns[0], 0);\n\n        _this3.contentType.addChild(columns[1], 1);\n\n        _this3.fireMountEvent(_this3.contentType, columns[0], columns[1]);\n      });\n    };\n\n    _proto.addDefaultColumnLine = function addDefaultColumnLine(args) {\n      var _this4 = this;\n\n      (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column-line\"), this.contentType, this.contentType.stageId).then(function (columnLine) {\n        _this4.contentType.addChild(columnLine, 0);\n\n        if (args.columnGroupWithoutColumnLine === undefined) {\n          _events.trigger(columnLine.config.name + \":dropAfter\", {\n            id: columnLine.id,\n            columnLine: columnLine\n          });\n        } else {\n          // Move children of this column group without column line as descendant of new\n          // column group that has a column line\n          var children = args.columnGroupWithoutColumnLine.getChildren()();\n          var index = 0;\n          children.forEach(function (child) {\n            setTimeout(function () {\n              (0, _moveContentType.moveContentType)(child, index++, columnLine);\n            }, 250);\n          });\n        }\n\n        _this4.fireMountEvent(_this4.contentType, columnLine);\n      });\n    }\n    /**\n     * Use the conditional remove to disable the option when the content type has a single child\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Return selected element styles\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyle = function getStyle(element, styleProperties) {\n      var stylesObject = element.style();\n      return styleProperties.reduce(function (obj, key) {\n        var _extends2;\n\n        return _extends({}, obj, (_extends2 = {}, _extends2[key] = stylesObject[key], _extends2));\n      }, {});\n    }\n    /**\n     * Return element styles without selected\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyleWithout = function getStyleWithout(element, styleProperties) {\n      var stylesObject = element.style();\n      return Object.keys(stylesObject).filter(function (key) {\n        return !styleProperties.includes(key);\n      }).reduce(function (obj, key) {\n        var _extends3;\n\n        return _extends({}, obj, (_extends3 = {}, _extends3[key] = stylesObject[key], _extends3));\n      }, {});\n    }\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n    ;\n\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * Retrieve the resize utils\n     *\n     * @returns {Resize}\n     */\n    ;\n\n    _proto.getResizeUtils = function getResizeUtils() {\n      return this.resizeUtils;\n    }\n    /**\n     * Handle a new column being dropped into the group\n     *\n     * @param {DropPosition} dropPosition\n     */\n    ;\n\n    _proto.onNewColumnDrop = function onNewColumnDrop(dropPosition) {\n      var _this5 = this;\n\n      // Create our new column\n      (0, _factory.createColumn)(this.contentType, this.resizeUtils.getSmallestColumnWidth(), dropPosition.insertIndex).then(function () {\n        var newWidth = _this5.resizeUtils.getAcceptedColumnWidth((_this5.resizeUtils.getColumnWidth(dropPosition.affectedColumn) - _this5.resizeUtils.getSmallestColumnWidth()).toString()); // Reduce the affected columns width by the smallest column width\n\n\n        (0, _resize.updateColumnWidth)(dropPosition.affectedColumn, newWidth);\n      });\n    }\n    /**\n     * Handle an existing column being dropped into a new column group\n     *\n     * @param {DropPosition} movePosition\n     */\n    ;\n\n    _proto.onExistingColumnDrop = function onExistingColumnDrop(movePosition) {\n      var column = (0, _registry2.getDragColumn)();\n      var sourceGroupPreview = column.parentContentType.preview;\n      var modifyOldNeighbour; // Determine which old neighbour we should modify\n\n      var oldWidth = sourceGroupPreview.getResizeUtils().getColumnWidth(column); // Retrieve the adjacent column either +1 or -1\n\n      if ((0, _resize.getAdjacentColumn)(column, \"+1\")) {\n        modifyOldNeighbour = (0, _resize.getAdjacentColumn)(column, \"+1\");\n      } else if ((0, _resize.getAdjacentColumn)(column, \"-1\")) {\n        modifyOldNeighbour = (0, _resize.getAdjacentColumn)(column, \"-1\");\n      } // Set the column to it's smallest column width\n\n\n      (0, _resize.updateColumnWidth)(column, this.resizeUtils.getSmallestColumnWidth()); // Move the content type\n\n      (0, _moveContentType.moveContentType)(column, movePosition.insertIndex, this.contentType); // Modify the old neighbour\n\n      if (modifyOldNeighbour) {\n        var oldNeighbourWidth = sourceGroupPreview.getResizeUtils().getAcceptedColumnWidth((oldWidth + sourceGroupPreview.getResizeUtils().getColumnWidth(modifyOldNeighbour)).toString());\n        (0, _resize.updateColumnWidth)(modifyOldNeighbour, oldNeighbourWidth);\n      } // Modify the columns new neighbour\n\n\n      var newNeighbourWidth = this.resizeUtils.getAcceptedColumnWidth((this.resizeUtils.getColumnWidth(movePosition.affectedColumn) - this.resizeUtils.getSmallestColumnWidth()).toString()); // Reduce the affected columns width by the smallest column width\n\n      (0, _resize.updateColumnWidth)(movePosition.affectedColumn, newNeighbourWidth);\n    }\n    /**\n     * Handle a column being sorted into a new position in the group\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {number} newIndex\n     */\n    ;\n\n    _proto.onColumnSort = function onColumnSort(column, newIndex) {\n      var currentIndex = (0, _resize.getColumnIndexInGroup)(column);\n\n      if (currentIndex !== newIndex) {\n        if (currentIndex < newIndex) {\n          // As we're moving an array item the keys all reduce by 1\n          --newIndex;\n        } // Move the content type\n\n\n        (0, _moveContentType.moveContentType)(column, newIndex);\n      }\n    }\n    /**\n     * Handle a column being resized\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {number} width\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} adjustedColumn\n     */\n    ;\n\n    _proto.onColumnResize = function onColumnResize(column, width, adjustedColumn) {\n      this.resizeUtils.resizeColumn(column, width, adjustedColumn);\n    }\n    /**\n     * Init the droppable & resizing interactions\n     *\n     * @param group\n     */\n    ;\n\n    _proto.bindInteractions = function bindInteractions(group) {\n      this.groupElement = (0, _jquery)(group);\n      this.initDroppable(this.groupElement);\n      this.initMouseMove(this.groupElement); // Handle the mouse leaving the window\n\n      (0, _jquery)(\"body\").mouseleave(this.endAllInteractions.bind(this));\n    }\n    /**\n     * Init the drop placeholder\n     * @deprecated - dropPlaceholder functionality moved to column-line\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindDropPlaceholder = function bindDropPlaceholder(element) {\n      this.dropPlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Init the move placeholder\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindMovePlaceholder = function bindMovePlaceholder(element) {\n      this.movePlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Retrieve the ghost element from the template\n     *\n     * @param {Element} ghost\n     */\n    ;\n\n    _proto.bindGhost = function bindGhost(ghost) {\n      this.resizeGhost = (0, _jquery)(ghost);\n    }\n    /**\n     * Register a resize handle within a child column\n     * @deprecated\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {JQuery} handle\n     */\n    ;\n\n    _proto.registerResizeHandle = function registerResizeHandle(column, handle) {\n      var _this6 = this;\n\n      handle.off(\"mousedown touchstart\");\n      handle.on(\"mousedown touchstart\", function (event) {\n        event.preventDefault();\n\n        var groupPosition = _this6.getGroupPosition(_this6.groupElement);\n\n        _this6.resizing(true);\n\n        _this6.resizeColumnInstance = column;\n        _this6.resizeColumnWidths = _this6.resizeUtils.determineColumnWidths(_this6.resizeColumnInstance, groupPosition);\n        _this6.resizeMaxGhostWidth = (0, _resize.determineMaxGhostWidth)(_this6.resizeColumnWidths); // Force the cursor to resizing\n\n        (0, _jquery)(\"body\").css(\"cursor\", \"col-resize\"); // Reset the resize history\n\n        _this6.resizeHistory = {\n          left: [],\n          right: []\n        };\n        _this6.resizeLastPosition = null;\n        _this6.resizeMouseDown = true;\n        ++_this6.interactionLevel;\n\n        _events.trigger(\"stage:interactionStart\", {\n          stageId: _this6.contentType.stageId\n        });\n      });\n    }\n    /**\n     * Bind draggable instances to the child columns\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     */\n    ;\n\n    _proto.bindDraggable = function bindDraggable(column) {\n      var _this7 = this;\n\n      column.preview.element.draggable({\n        appendTo: \"body\",\n        containment: \"body\",\n        cursor: \"-webkit-grabbing\",\n        handle: \".move-column\",\n        revertDuration: 250,\n        helper: function helper() {\n          var helper = (0, _jquery)(this).clone();\n          helper.css({\n            height: (0, _jquery)(this).outerHeight() + \"px\",\n            minHeight: 0,\n            opacity: 0.5,\n            pointerEvents: \"none\",\n            width: (0, _jquery)(this).outerWidth() + \"px\",\n            zIndex: 5000\n          });\n          return helper;\n        },\n        start: function start(event) {\n          var columnInstance = _knockout.dataFor((0, _jquery)(event.target)[0]); // Use the global state as columns can be dragged between groups\n\n\n          (0, _registry2.setDragColumn)(columnInstance.contentType);\n          _this7.dropPositions = (0, _dragAndDrop.calculateDropPositions)(_this7.contentType);\n          _this7.startDragEvent = event;\n\n          _events.trigger(\"column:dragStart\", {\n            column: columnInstance,\n            stageId: _this7.contentType.stageId\n          });\n\n          _events.trigger(\"stage:interactionStart\", {\n            stageId: _this7.contentType.stageId\n          });\n        },\n        stop: function stop() {\n          var draggedColumn = (0, _registry2.getDragColumn)();\n\n          if (_this7.movePosition && draggedColumn) {\n            // Check if we're moving within the same group, even though this function will\n            // only ever run on the group that bound the draggable event\n            if (draggedColumn.parentContentType === _this7.contentType) {\n              _this7.onColumnSort(draggedColumn, _this7.movePosition.insertIndex);\n\n              _this7.movePosition = null;\n            }\n          }\n\n          (0, _registry2.removeDragColumn)();\n\n          _this7.movePlaceholder.removeClass(\"active\");\n\n          _this7.startDragEvent = null;\n\n          _events.trigger(\"column:dragStop\", {\n            column: draggedColumn,\n            stageId: _this7.contentType.stageId\n          });\n\n          _events.trigger(\"stage:interactionStop\", {\n            stageId: _this7.contentType.stageId\n          });\n        }\n      });\n    }\n    /**\n     * Update the grid size on enter or blur of the input\n     */\n    ;\n\n    _proto.updateGridSize = function updateGridSize() {\n      var _this8 = this;\n\n      if (!_jquery.isNumeric(this.gridSizeInput())) {\n        this.gridSizeError((0, _translate)(\"Please enter a valid number.\"));\n      }\n\n      var newGridSize = parseInt(this.gridSizeInput().toString(), 10);\n\n      if (newGridSize || newGridSize === 0) {\n        if (newGridSize !== this.resizeUtils.getGridSize() || true) {\n          try {\n            (0, _gridSize.resizeGrid)(this.contentType, newGridSize, this.gridSizeHistory);\n            this.recordGridResize(newGridSize);\n            this.gridSizeError(null); // Make the grid \"flash\" on successful change\n\n            this.gridChange(true);\n\n            _underscore.delay(function () {\n              _this8.gridChange(false);\n            }, 1000);\n          } catch (e) {\n            if (e instanceof _gridSize.GridSizeError) {\n              this.gridSizeError(e.message);\n            } else {\n              throw e;\n            }\n          }\n        } else {\n          this.gridSizeError(null);\n        }\n      }\n    }\n    /**\n     * @param {ContentTypeInterface | ContentTypeCollectionInterface} contentType\n     * @private\n     */\n    ;\n\n    _proto.hasColumnLine = function hasColumnLine(contentType) {\n      var children = this.contentType.getChildren()();\n      var hasColumnLine = false;\n\n      if (children.length === 0) {\n        // new column group, so it has a column line\n        hasColumnLine = true;\n      }\n\n      children.forEach(function (child) {\n        if (child.config.name === \"column-line\") {\n          hasColumnLine = true;\n        }\n      });\n      return hasColumnLine;\n    }\n    /**\n     * If the column group does not have a column line, move contents to a new column group with a column line\n     */\n    ;\n\n    _proto.moveContentsToNewColumnGroup = function moveContentsToNewColumnGroup() {\n      var _this9 = this;\n\n      if (this.hasColumnLine(this.contentType)) {\n        // This column-group already has a column line. Don't need to add one.\n        return;\n      }\n\n      var indexToInsertNewColumnGroupAt = this.getCurrentIndexInParent();\n      (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column-group\"), this.contentType.parentContentType, this.contentType.stageId).then(function (columnGroup) {\n        _this9.contentType.parentContentType.addChild(columnGroup, indexToInsertNewColumnGroupAt);\n\n        _events.trigger(columnGroup.config.name + \":dropAfter\", {\n          id: columnGroup.id,\n          columnGroup: columnGroup,\n          columnGroupWithoutColumnLine: _this9.contentType\n        });\n\n        _this9.fireMountEvent(_this9.contentType, columnGroup);\n      });\n    }\n    /**\n     * @private return index of current content type in parent\n     */\n    ;\n\n    _proto.getCurrentIndexInParent = function getCurrentIndexInParent() {\n      var parentContentType = this.contentType.parentContentType;\n      var currentIndex = 0;\n\n      for (var _iterator = _createForOfIteratorHelperLoose(this.contentType.parentContentType.getChildren()()), _step; !(_step = _iterator()).done;) {\n        var sibling = _step.value;\n\n        if (sibling.id !== this.contentType.id) {\n          currentIndex++;\n          continue;\n        }\n\n        break;\n      }\n\n      return currentIndex;\n    }\n    /**\n     * Fire the mount event for content types\n     *\n     * @param {ContentTypeInterface[]} contentTypes\n     */\n    ;\n\n    _proto.fireMountEvent = function fireMountEvent() {\n      for (var _len = arguments.length, contentTypes = new Array(_len), _key = 0; _key < _len; _key++) {\n        contentTypes[_key] = arguments[_key];\n      }\n\n      contentTypes.forEach(function (contentType) {\n        _events.trigger(\"contentType:mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n\n        _events.trigger(contentType.config.name + \":mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n      });\n    }\n    /**\n     * Set columns in the group as resizing\n     *\n     * @param {Array<ContentTypeCollectionInterface<ColumnPreview>>} columns\n     */\n    ;\n\n    _proto.setColumnsAsResizing = function setColumnsAsResizing() {\n      for (var _len2 = arguments.length, columns = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {\n        columns[_key2] = arguments[_key2];\n      }\n\n      columns.forEach(function (column) {\n        column.preview.resizing(true);\n        column.preview.element.css({\n          transition: \"width 350ms ease-in-out\"\n        });\n      });\n    }\n    /**\n     * Unset resizing flag on all child columns\n     */\n    ;\n\n    _proto.unsetResizingColumns = function unsetResizingColumns() {\n      this.contentType.children().forEach(function (column) {\n        column.preview.resizing(false);\n\n        if (column.preview.element) {\n          column.preview.element.css({\n            transition: \"\"\n          });\n        }\n      });\n    }\n    /**\n     * End all current interactions\n     */\n    ;\n\n    _proto.endAllInteractions = function endAllInteractions() {\n      if (this.resizing() === true) {\n        for (; this.interactionLevel > 0; this.interactionLevel--) {\n          _events.trigger(\"stage:interactionStop\", {\n            stageId: this.contentType.stageId\n          });\n        }\n      }\n\n      this.resizing(false);\n      this.resizeMouseDown = null;\n      this.resizeLeftLastColumnShrunk = this.resizeRightLastColumnShrunk = null;\n      this.dropPositions = []; // this.unsetResizingColumns();\n      // Change the cursor back\n\n      (0, _jquery)(\"body\").css(\"cursor\", \"\");\n      this.movePlaceholder.css(\"left\", \"\").removeClass(\"active\");\n      this.resizeGhost.removeClass(\"active\"); // Reset the group positions cache\n\n      this.groupPositionCache = null;\n    }\n    /**\n     * Init the resizing events on the group\n     *\n     * @param {JQuery} group\n     */\n    ;\n\n    _proto.initMouseMove = function initMouseMove(group) {\n      var _this10 = this;\n\n      var intersects = false;\n      (0, _jquery)(document).on(\"mousemove touchmove\", function (event) {\n        if (group.parents(_sortable.hiddenClass).length > 0) {\n          return;\n        }\n\n        var groupPosition = _this10.getGroupPosition(group); // If we're handling a touch event we need to pass through the page X & Y\n\n\n        if (event.type === \"touchmove\") {\n          event.pageX = event.originalEvent.pageX;\n          event.pageY = event.originalEvent.pageY;\n        }\n\n        if (_this10.eventIntersectsGroup(event, groupPosition)) {\n          intersects = true; // @todo make column re-sizing work\n\n          _this10.onResizingMouseMove(event, group, groupPosition);\n        } else {\n          intersects = false;\n          _this10.groupPositionCache = null;\n          _this10.dropPosition = null;\n\n          _this10.movePlaceholder.css(\"left\", \"\").removeClass(\"active\");\n        }\n      }).on(\"mouseup touchend\", function () {\n        intersects = false;\n        _this10.dropPosition = null;\n\n        _this10.endAllInteractions();\n\n        _underscore.defer(function () {\n          // Re-enable any disabled sortable areas\n          group.find(\".ui-sortable\").each(function () {\n            if ((0, _jquery)(this).data(\"ui-sortable\")) {\n              (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n            }\n          });\n        });\n      });\n    }\n    /**\n     * Handle the mouse up action, either adding a new column or moving an existing\n     * @deprecated\n     */\n    ;\n\n    _proto.handleMouseUp = function handleMouseUp() {\n      if (this.dropOverElement && this.dropPosition) {\n        this.onNewColumnDrop(this.dropPosition);\n        this.dropOverElement = null; // Re-enable the parent disabled sortable instance\n\n        _underscore.defer(function () {\n          (0, _jquery)(\".element-children.ui-sortable-disabled\").each(function () {\n            (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n          });\n        });\n      }\n\n      var column = (0, _registry2.getDragColumn)();\n\n      if (this.movePosition && column && column.parentContentType !== this.contentType) {\n        this.onExistingColumnDrop(this.movePosition);\n      }\n    }\n    /**\n     * Does the current event intersect with the group?\n     *\n     * @param {JQueryEventObject} event\n     * @param {GroupPositionCache} groupPosition\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.eventIntersectsGroup = function eventIntersectsGroup(event, groupPosition) {\n      return event.pageY > groupPosition.top && event.pageY < groupPosition.top + groupPosition.outerHeight && event.pageX > groupPosition.left && event.pageX < groupPosition.left + groupPosition.outerWidth;\n    }\n    /**\n     * Cache the groups positions\n     *\n     * @param {JQuery} group\n     * @returns {GroupPositionCache}\n     */\n    ;\n\n    _proto.getGroupPosition = function getGroupPosition(group) {\n      if (!this.groupPositionCache) {\n        this.groupPositionCache = {\n          top: group.offset().top,\n          left: group.offset().left,\n          width: group.width(),\n          height: group.height(),\n          outerWidth: group.outerWidth(),\n          outerHeight: group.outerHeight()\n        };\n      }\n\n      return this.groupPositionCache;\n    }\n    /**\n     * Record the resizing history for this action\n     *\n     * @param {string} usedHistory\n     * @param {string} direction\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} adjustedColumn\n     * @param {string} modifyColumnInPair\n     */\n    ;\n\n    _proto.recordResizeHistory = function recordResizeHistory(usedHistory, direction, adjustedColumn, modifyColumnInPair) {\n      if (usedHistory) {\n        this.resizeHistory[usedHistory].pop();\n      }\n\n      this.resizeHistory[direction].push({\n        adjustedColumn: adjustedColumn,\n        modifyColumnInPair: modifyColumnInPair\n      });\n    }\n    /**\n     * Handle the resizing on mouse move, we always resize a pair of columns at once\n     *\n     * @param {JQueryEventObject} event\n     * @param {JQuery} group\n     * @param {GroupPositionCache} groupPosition\n     */\n    ;\n\n    _proto.onResizingMouseMove = function onResizingMouseMove(event, group, groupPosition) {\n      var _this11 = this;\n\n      var newColumnWidth;\n\n      if (this.resizeMouseDown) {\n        event.preventDefault();\n        var currentPos = event.pageX;\n        var resizeColumnLeft = this.resizeColumnInstance.preview.element.offset().left;\n        var resizeColumnWidth = this.resizeColumnInstance.preview.element.outerWidth();\n        var resizeHandlePosition = resizeColumnLeft + resizeColumnWidth;\n        var direction = currentPos >= resizeHandlePosition ? \"right\" : \"left\";\n        var adjustedColumn;\n        var modifyColumnInPair; // We need to know if we're modifying the left or right column in the pair\n\n        var usedHistory; // Was the adjusted column pulled from history?\n        // Determine which column in the group should be adjusted for this action\n\n        var _this$resizeUtils$det = this.resizeUtils.determineAdjustedColumn(currentPos, this.resizeColumnInstance, this.resizeHistory);\n\n        adjustedColumn = _this$resizeUtils$det[0];\n        modifyColumnInPair = _this$resizeUtils$det[1];\n        usedHistory = _this$resizeUtils$det[2];\n        // Calculate the ghost width based on mouse position and bounds of allowed sizes\n        var ghostWidth = this.resizeUtils.calculateGhostWidth(groupPosition, currentPos, this.resizeColumnInstance, modifyColumnInPair, this.resizeMaxGhostWidth);\n        this.resizeGhost.width(ghostWidth - 15 + \"px\").addClass(\"active\");\n\n        if (adjustedColumn && this.resizeColumnWidths) {\n          newColumnWidth = this.resizeColumnWidths.find(function (val) {\n            return (0, _resize.comparator)(currentPos, val.position, 35) && val.forColumn === modifyColumnInPair;\n          });\n\n          if (newColumnWidth) {\n            var mainColumn = this.resizeColumnInstance; // If we're using the left data set, we're actually resizing the right column of the group\n\n            if (modifyColumnInPair === \"right\") {\n              mainColumn = (0, _resize.getAdjacentColumn)(this.resizeColumnInstance, \"+1\");\n            } // Ensure we aren't resizing multiple times, also validate the last resize isn't the same as the\n            // one being performed now. This occurs as we re-calculate the column positions on resize, we have\n            // to use the comparator as the calculation may result in slightly different numbers due to rounding\n\n\n            if (this.resizeUtils.getColumnWidth(mainColumn) !== newColumnWidth.width && !(0, _resize.comparator)(this.resizeLastPosition, newColumnWidth.position, 10)) {\n              // If our previous action was to resize the right column in pair, and we're now dragging back\n              // to the right, but have matched a column for the left we need to fix the columns being\n              // affected\n              if (usedHistory && this.resizeLastColumnInPair === \"right\" && direction === \"right\" && newColumnWidth.forColumn === \"left\") {\n                var originalMainColumn = mainColumn;\n                mainColumn = adjustedColumn;\n                adjustedColumn = (0, _resize.getAdjacentColumn)(originalMainColumn, \"+1\");\n              }\n\n              this.recordResizeHistory(usedHistory, direction, adjustedColumn, modifyColumnInPair);\n              this.resizeLastPosition = newColumnWidth.position;\n              this.resizeLastColumnInPair = modifyColumnInPair; // Ensure the adjusted column is marked as resizing to animate correctly\n\n              this.setColumnsAsResizing(mainColumn, adjustedColumn);\n              this.onColumnResize(mainColumn, newColumnWidth.width, adjustedColumn); // Wait for the render cycle to finish from the above resize before re-calculating\n\n              _underscore.defer(function () {\n                // If we do a resize, re-calculate the column widths\n                _this11.resizeColumnWidths = _this11.resizeUtils.determineColumnWidths(_this11.resizeColumnInstance, groupPosition);\n                _this11.resizeMaxGhostWidth = (0, _resize.determineMaxGhostWidth)(_this11.resizeColumnWidths);\n              });\n            }\n          }\n        }\n      }\n    }\n    /**\n     * Handle a column being dragged around the group\n     * @deprecated - this is now handled in column-line/preview onDraggingMouseMove\n     * @param {JQueryEventObject} event\n     * @param {JQuery} group\n     * @param {GroupPositionCache} groupPosition\n     */\n    ;\n\n    _proto.onDraggingMouseMove = function onDraggingMouseMove(event, group, groupPosition) {\n      var dragColumn = (0, _registry2.getDragColumn)();\n\n      if (dragColumn) {\n        // If the drop positions haven't been calculated for this group do so now\n        if (this.dropPositions.length === 0) {\n          this.dropPositions = (0, _dragAndDrop.calculateDropPositions)(this.contentType);\n        }\n\n        var columnInstance = dragColumn;\n        var currentX = event.pageX - groupPosition.left; // Are we within the same column group or have we ended up over another?\n\n        if (columnInstance.parentContentType === this.contentType && this.startDragEvent) {\n          var dragDirection = event.pageX <= this.startDragEvent.pageX ? \"left\" : \"right\";\n          var adjacentLeftColumn = (0, _resize.getAdjacentColumn)(dragColumn, \"-1\"); // Determine the current move position based on the cursors position and direction of drag\n\n          this.movePosition = this.dropPositions.find(function (position) {\n            return currentX > position.left && currentX < position.right && position.placement === dragDirection && position.affectedColumn !== dragColumn;\n          }); // Differences in the element & event positions cause a right movement to activate on the left column\n\n          if (this.movePosition && dragDirection === \"right\" && this.movePosition.affectedColumn === adjacentLeftColumn) {\n            this.movePosition = null;\n          }\n\n          if (this.movePosition) {\n            this.movePlaceholder.css({\n              left: this.movePosition.placement === \"left\" ? this.movePosition.left : \"\",\n              right: this.movePosition.placement === \"right\" ? groupPosition.width - this.movePosition.right : \"\",\n              width: dragColumn.preview.element.outerWidth() + \"px\"\n            }).addClass(\"active\");\n          } else {\n            this.movePlaceholder.removeClass(\"active\");\n          }\n        } else {\n          // If we're moving to another column group we utilise the existing drop placeholder\n          this.movePosition = this.dropPositions.find(function (position) {\n            return currentX > position.left && currentX <= position.right && position.canShrink;\n          });\n\n          if (this.movePosition) {\n            var classToRemove = this.movePosition.placement === \"left\" ? \"right\" : \"left\";\n            this.movePlaceholder.removeClass(\"active\");\n          }\n        }\n      }\n    }\n    /**\n     * Handle mouse move events on when dropping elements\n     *\n     * @param {JQueryEventObject} event\n     * @param {JQuery} group\n     * @param {GroupPositionCache} groupPosition\n     * @deprecated now handled in column-line/preview\n     */\n    ;\n\n    _proto.onDroppingMouseMove = function onDroppingMouseMove(event, group, groupPosition) {\n      var elementChildrenParent = group.parents(\".element-children\"); // Only initiate this process if we're within the group by a buffer to allow for sortable to function correctly\n\n      if (this.dropOverElement && event.pageY > groupPosition.top + 20 && event.pageY < groupPosition.top + groupPosition.outerHeight - 20) {\n        // Disable the column group sortable instance\n        if (elementChildrenParent.data(\"ui-sortable\")) {\n          elementChildrenParent.sortable(\"option\", \"disabled\", true);\n        }\n\n        var currentX = event.pageX - groupPosition.left;\n        this.dropPosition = this.dropPositions.find(function (position) {\n          return currentX > position.left && currentX <= position.right && position.canShrink;\n        });\n      } else if (this.dropOverElement) {\n        // Re-enable the column group sortable instance\n        if (elementChildrenParent.data(\"ui-sortable\")) {\n          elementChildrenParent.sortable(\"option\", \"disabled\", false);\n        }\n\n        this.dropPosition = null;\n      }\n    }\n    /**\n     * Init the droppable functionality for new columns\n     *\n     * @param {JQuery} group\n     */\n    ;\n\n    _proto.initDroppable = function initDroppable(group) {\n      var self = this;\n      var headStyles;\n      group.droppable({\n        deactivate: function deactivate() {\n          self.dropOverElement = null;\n\n          _underscore.defer(function () {\n            // Re-enable the column group sortable instance & all children sortable instances\n            group.parents(\".element-children\").each(function () {\n              if ((0, _jquery)(this).data(\"ui-sortable\")) {\n                (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n              }\n            });\n          });\n        },\n        activate: function activate() {\n          if ((0, _registry.getDraggedContentTypeConfig)() === _config.getContentTypeConfig(\"column-group\")) {\n            var _ref;\n\n            group.find(\".ui-sortable\").each(function () {\n              if ((0, _jquery)(this).data(\"ui-sortable\")) {\n                (0, _jquery)(this).sortable(\"option\", \"disabled\", true);\n              }\n            });\n            var classes = [\".pagebuilder-content-type.pagebuilder-column .pagebuilder-drop-indicator\", \".pagebuilder-content-type.pagebuilder-column .empty-container .content-type-container:before\"]; // Ensure we don't display any drop indicators inside the column\n\n            headStyles = (0, _createStylesheet.createStyleSheet)((_ref = {}, _ref[classes.join(\", \")] = {\n              display: \"none!important\"\n            }, _ref));\n            document.head.appendChild(headStyles);\n          } else if (headStyles) {\n            headStyles.remove();\n            headStyles = null;\n          }\n        },\n        drop: function drop() {\n          self.dropPositions = [];\n        },\n        out: function out() {\n          self.dropOverElement = null;\n        },\n        over: function over() {\n          // Is the element currently being dragged a column group?\n          if ((0, _registry.getDraggedContentTypeConfig)() === _config.getContentTypeConfig(\"column-group\")) {\n            // Always calculate drop positions when an element is dragged over\n            self.dropOverElement = true;\n          } else {\n            self.dropOverElement = null;\n          }\n        }\n      });\n    }\n    /**\n     * Spread any empty space across the other columns when a column is removed\n     *\n     * @param {number} removedIndex\n     */\n    ;\n\n    _proto.spreadWidth = function spreadWidth(removedIndex) {\n      if (this.contentType.children().length === 0) {\n        return;\n      }\n\n      var availableWidth = 100 - this.resizeUtils.getColumnsWidth();\n      var formattedAvailableWidth = (0, _resize.getRoundedColumnWidth)(availableWidth);\n      var totalChildColumns = this.contentType.children().length;\n      var allowedColumnWidths = [];\n      var spreadAcross = 1;\n      var spreadAmount;\n\n      for (var i = this.resizeUtils.getGridSize(); i > 0; i--) {\n        allowedColumnWidths.push((0, _resize.getRoundedColumnWidth)(100 / this.resizeUtils.getGridSize() * i));\n      } // Determine how we can spread the empty space across the columns\n\n\n      for (var _i = totalChildColumns; _i > 0; _i--) {\n        var potentialWidth = Math.floor(formattedAvailableWidth / _i);\n\n        for (var _iterator2 = _createForOfIteratorHelperLoose(allowedColumnWidths), _step2; !(_step2 = _iterator2()).done;) {\n          var width = _step2.value;\n\n          if (potentialWidth === Math.floor(width)) {\n            spreadAcross = _i;\n            spreadAmount = formattedAvailableWidth / _i;\n            break;\n          }\n        }\n\n        if (spreadAmount) {\n          break;\n        }\n      } // Let's spread the width across the columns\n\n\n      for (var _i2 = 1; _i2 <= spreadAcross; _i2++) {\n        var columnToModify = void 0; // As the original column has been removed from the array, check the new index for a column\n\n        if (removedIndex <= this.contentType.children().length && typeof this.contentType.children()[removedIndex] !== \"undefined\") {\n          columnToModify = this.contentType.children()[removedIndex];\n        }\n\n        if (!columnToModify && removedIndex - _i2 >= 0 && typeof this.contentType.children()[removedIndex - _i2] !== \"undefined\") {\n          columnToModify = this.contentType.children()[removedIndex - _i2];\n        }\n\n        if (columnToModify) {\n          (0, _resize.updateColumnWidth)(columnToModify, this.resizeUtils.getColumnWidth(columnToModify) + spreadAmount);\n        }\n      }\n    }\n    /**\n     * Remove self if we contain no children\n     */\n    ;\n\n    _proto.removeIfEmpty = function removeIfEmpty() {\n      if (this.contentType.children().length === 0) {\n        this.contentType.parentContentType.removeChild(this.contentType);\n        return;\n      }\n    }\n    /**\n     * Record the grid resize operation into a history for later restoration\n     *\n     * @param {number} newGridSize\n     */\n    ;\n\n    _proto.recordGridResize = function recordGridResize(newGridSize) {\n      var _this12 = this;\n\n      // @todo evaluate utility of having a grid size history\n      return;\n\n      if (!this.gridSizeHistory.has(newGridSize)) {\n        var columnWidths = [];\n        this.contentType.getChildren()().forEach(function (column) {\n          columnWidths.push(_this12.resizeUtils.getColumnWidth(column));\n        });\n        this.gridSizeHistory.set(newGridSize, columnWidths);\n      }\n    }\n    /**\n     * Figure out the maximum number of non-empty columns in various column lines\n     * @private\n     */\n    ;\n\n    _proto.getNonEmptyColumnCount = function getNonEmptyColumnCount() {\n      var nonEmptyColumnCount = 0;\n      this.contentType.getChildren()().forEach(function (columnLine, index) {\n        var numEmptyColumns = 0;\n        var numCols = columnLine.getChildren()().length;\n        columnLine.getChildren()().forEach(function (column) {\n          if (column.getChildren()().length === 0) {\n            numEmptyColumns++;\n          }\n        });\n\n        if (numCols - numEmptyColumns > nonEmptyColumnCount) {\n          nonEmptyColumnCount = numCols - numEmptyColumns;\n        }\n      });\n      return nonEmptyColumnCount;\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/column-group/registry.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var dragColumn;\n  /**\n   * Retrieve the drag column from the registry\n   *\n   * @returns {ContentTypeCollectionInterface}\n   */\n\n  function getDragColumn() {\n    return dragColumn;\n  }\n  /**\n   * Remove the drag column reference\n   */\n\n\n  function removeDragColumn() {\n    dragColumn = null;\n  }\n  /**\n   * Set the drag column in the registry\n   *\n   * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n   */\n\n\n  function setDragColumn(column) {\n    dragColumn = column;\n  }\n\n  return {\n    getDragColumn: getDragColumn,\n    removeDragColumn: removeDragColumn,\n    setDragColumn: setDragColumn\n  };\n});\n//# sourceMappingURL=registry.js.map","Magento_PageBuilder/js/content-type/column-line/drag-and-drop.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Calculate the drop positions of a column group\n   *\n   * @param {ContentTypeCollectionInterface} group\n   * @returns {any[]}\n   */\n  function calculateDropPositions(line) {\n    var resizeUtils = line.preview.getResizeUtils();\n    var dropPositions = [];\n    line.children().forEach(function (column, index) {\n      var left = column.preview.element.position().left;\n      var width = column.preview.element.outerWidth(true);\n      var canShrink = resizeUtils.getAcceptedColumnWidth(resizeUtils.getColumnWidth(column).toString()) > resizeUtils.getSmallestColumnWidth();\n      dropPositions.push({\n        affectedColumn: column,\n        canShrink: canShrink,\n        insertIndex: index,\n        left: left,\n        placement: \"left\",\n        right: left + width / 2\n      }, {\n        affectedColumn: column,\n        canShrink: canShrink,\n        insertIndex: index + 1,\n        left: left + width / 2,\n        placement: \"right\",\n        right: left + width\n      });\n    });\n    return dropPositions;\n  }\n\n  return {\n    calculateDropPositions: calculateDropPositions\n  };\n});\n//# sourceMappingURL=drag-and-drop.js.map","Magento_PageBuilder/js/content-type/column-line/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type/column-group/factory\", \"Magento_PageBuilder/js/content-type/column-group/registry\", \"Magento_PageBuilder/js/drag-drop/move-content-type\", \"Magento_PageBuilder/js/drag-drop/registry\", \"Magento_PageBuilder/js/drag-drop/sortable\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/utils/create-stylesheet\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/column-group/grid-size\", \"Magento_PageBuilder/js/content-type/column/resize\", \"Magento_PageBuilder/js/content-type/preview-collection\", \"Magento_PageBuilder/js/content-type/column-line/drag-and-drop\"], function (_jquery, _knockout, _contentTypeFactory, _factory, _registry, _moveContentType, _registry2, _sortable, _events, _createStylesheet, _underscore, _config, _gridSize, _resize, _previewCollection, _dragAndDrop) {\n  function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== \"function\") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     *\n     * @param {ContentTypeCollection} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this;\n      _this.resizing = _knockout.observable(false);\n      _this.gridSizeArray = _knockout.observableArray([]);\n      _this.dropPositions = [];\n      _this.resizeHistory = {\n        left: [],\n        right: []\n      };\n      _this.interactionLevel = 0;\n      _this.lineDropperHeight = 50;\n      _this.resizeUtils = new _resize(_this.contentType.parentContentType, _this.contentType);\n\n      _events.on(\"contentType:removeAfter\", function (args) {\n        if (args.parentContentType && args.parentContentType.id === _this.contentType.id) {\n          _underscore.defer(function () {\n            _this.spreadWidth(args.index);\n          });\n        }\n      }); // Listen for resizing events from child columns\n\n\n      _events.on(\"column:resizeHandleBindAfter\", function (args) {\n        // Does the events content type match the previews column group?\n        if (args.columnLine.id === _this.contentType.id) {\n          _this.registerResizeHandle(args.column, args.handle);\n        }\n      });\n\n      _events.on(\"column:initializeAfter\", function (args) {\n        // Does the events parent match the previews column group?\n        if (args.columnGroup.id === _this.contentType.id) {\n          _this.bindDraggable(args.column);\n        }\n      });\n\n      var parentPreview = _this.contentType.parentContentType.preview;\n\n      _this.gridSizeArray(parentPreview.gridSizeArray());\n\n      parentPreview.gridSizeArray.subscribe(function (gridSize) {\n        _this.gridSizeArray(gridSize);\n      });\n\n      _this.contentType.children.subscribe(_underscore.debounce(_this.removeIfEmpty.bind(_assertThisInitialized(_this)), 50));\n\n      return _this;\n    }\n    /**\n     * Bind events\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this);\n\n      if (_config.getContentTypeConfig(\"column\")) {\n        _events.on(\"column-line:dropAfter\", function (args) {\n          if (args.id === _this2.contentType.id) {\n            _this2.createColumns();\n          }\n        });\n      }\n\n      _events.on(\"column:initializeAfter\", function (args) {\n        // Does the events parent match the previews column group?\n        if (args.columnLine.id === _this2.contentType.id) {\n          _this2.bindDraggable(args.column);\n        }\n      });\n    }\n    /**\n     * Init the droppable & resizing interactions\n     *\n     * @param line\n     */\n    ;\n\n    _proto.bindInteractions = function bindInteractions(line) {\n      this.element = (0, _jquery)(line);\n      this.initDroppable(this.element);\n      this.initMouseMove(this.element); // Handle the mouse leaving the window\n      //  $(\"body\").mouseleave(this.endAllInteractions.bind(this));\n    }\n    /**\n     * Init the drop placeholder\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindDropPlaceholder = function bindDropPlaceholder(element) {\n      this.dropPlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Init the drop placeholder\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindColumnLineBottomDropPlaceholder = function bindColumnLineBottomDropPlaceholder(element) {\n      this.columnLineBottomDropPlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Init the drop placeholder\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindColumnLineDropPlaceholder = function bindColumnLineDropPlaceholder(element) {\n      this.columnLineDropPlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Init the move placeholder\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.bindMovePlaceholder = function bindMovePlaceholder(element) {\n      this.movePlaceholder = (0, _jquery)(element);\n    }\n    /**\n     * Retrieve the ghost element from the template\n     *\n     * @param {Element} ghost\n     */\n    ;\n\n    _proto.bindGhost = function bindGhost(ghost) {\n      this.resizeGhost = (0, _jquery)(ghost);\n    }\n    /**\n     * Retrieve the resize utils\n     *\n     * @returns {Resize}\n     */\n    ;\n\n    _proto.getResizeUtils = function getResizeUtils() {\n      return this.resizeUtils;\n    }\n    /**\n     * Bind draggable instances to the child columns\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     */\n    ;\n\n    _proto.bindDraggable = function bindDraggable(column) {\n      var _this3 = this;\n\n      column.preview.element.draggable({\n        appendTo: \"body\",\n        containment: \"body\",\n        cursor: \"-webkit-grabbing\",\n        handle: \".move-column\",\n        revertDuration: 250,\n        helper: function helper() {\n          var helper = (0, _jquery)(this).clone();\n          helper.css({\n            height: (0, _jquery)(this).outerHeight() + \"px\",\n            minHeight: 0,\n            opacity: 0.5,\n            pointerEvents: \"none\",\n            width: (0, _jquery)(this).outerWidth() + \"px\",\n            zIndex: 5000\n          });\n          return helper;\n        },\n        start: function start(event) {\n          var columnInstance = _knockout.dataFor((0, _jquery)(event.target)[0]); // Use the global state as columns can be dragged between groups\n\n\n          (0, _registry.setDragColumn)(columnInstance.contentType);\n          _this3.dropPositions = (0, _dragAndDrop.calculateDropPositions)(_this3.contentType);\n          _this3.startDragEvent = event;\n\n          _events.trigger(\"column:dragStart\", {\n            column: columnInstance,\n            stageId: _this3.contentType.stageId\n          });\n\n          _events.trigger(\"stage:interactionStart\", {\n            stageId: _this3.contentType.stageId\n          });\n        },\n        stop: function stop() {\n          var draggedColumn = (0, _registry.getDragColumn)();\n\n          if (_this3.movePosition && draggedColumn) {\n            // Check if we're moving within the same group, even though this function will\n            // only ever run on the group that bound the draggable event\n            if (draggedColumn.parentContentType === _this3.contentType) {\n              _this3.onColumnSort(draggedColumn, _this3.movePosition.insertIndex);\n\n              _this3.movePosition = null; // todo see from column group\n            }\n          }\n\n          (0, _registry.removeDragColumn)();\n\n          _this3.dropPlaceholder.removeClass(\"left right\");\n\n          _this3.movePlaceholder.removeClass(\"active\");\n\n          _this3.movePosition = null;\n          _this3.startDragEvent = null;\n\n          _events.trigger(\"column:dragStop\", {\n            column: draggedColumn,\n            stageId: _this3.contentType.stageId\n          });\n\n          _events.trigger(\"stage:interactionStop\", {\n            stageId: _this3.contentType.stageId\n          });\n        }\n      });\n    }\n    /**\n     * Handle a column being sorted into a new position in the column line\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {number} newIndex\n     */\n    ;\n\n    _proto.onColumnSort = function onColumnSort(column, newIndex) {\n      var currentIndex = (0, _resize.getColumnIndexInLine)(column);\n\n      if (currentIndex !== newIndex) {\n        if (currentIndex < newIndex) {\n          // As we're moving an array item the keys all reduce by 1\n          --newIndex;\n        } // Move the content type\n\n\n        (0, _moveContentType.moveContentType)(column, newIndex);\n      }\n    }\n    /**\n     * Handle a new column being dropped into the group\n     *\n     * @param {DropPosition} dropPosition\n     */\n    ;\n\n    _proto.onNewColumnDrop = function onNewColumnDrop(dropPosition) {\n      var _this4 = this;\n\n      // Create our new column\n      (0, _factory.createColumn)(this.contentType, this.resizeUtils.getSmallestColumnWidth(), dropPosition.insertIndex).then(function () {\n        var newWidth = _this4.resizeUtils.getAcceptedColumnWidth((_this4.resizeUtils.getColumnWidth(dropPosition.affectedColumn) - _this4.resizeUtils.getSmallestColumnWidth()).toString()); // Reduce the affected columns width by the smallest column width\n\n\n        (0, _resize.updateColumnWidth)(dropPosition.affectedColumn, newWidth);\n      });\n    }\n    /**\n     * Handle an existing column being dropped into a different column line\n     *\n     * @param {DropPosition} movePosition\n     */\n    ;\n\n    _proto.onExistingColumnDrop = function onExistingColumnDrop(movePosition) {\n      var _this5 = this;\n\n      var column = (0, _registry.getDragColumn)();\n      var sourceLinePreview = column.parentContentType.preview;\n      var modifyOldNeighbour; // Determine which old neighbour we should modify\n\n      var oldWidth = sourceLinePreview.getResizeUtils().getColumnWidth(column);\n      var direction = \"+1\"; // Retrieve the adjacent column either +1 or -1\n\n      if ((0, _resize.getAdjacentColumn)(column, \"+1\")) {\n        modifyOldNeighbour = (0, _resize.getAdjacentColumn)(column, \"+1\");\n      } else if ((0, _resize.getAdjacentColumn)(column, \"-1\")) {\n        direction = \"-1\";\n        modifyOldNeighbour = (0, _resize.getAdjacentColumn)(column, \"-1\");\n      } // Modify the old neighbour\n\n\n      var oldNeighbourWidth = 100;\n\n      if (modifyOldNeighbour) {\n        oldNeighbourWidth = sourceLinePreview.getResizeUtils().getAcceptedColumnWidth((oldWidth + sourceLinePreview.getResizeUtils().getColumnWidth(modifyOldNeighbour)).toString());\n      } // Move the content type\n\n\n      if (this.columnLineDropPlaceholder.hasClass(\"active\")) {\n        // if new column line placeholders are visible, add new column line and move column there\n        (0, _factory.createColumnLine)(this.contentType.parentContentType, this.resizeUtils.getSmallestColumnWidth(), this.getNewColumnLineIndex()).then(function (columnLine) {\n          (0, _moveContentType.moveContentType)(column, 0, columnLine);\n          (0, _resize.updateColumnWidth)(column, 100);\n\n          if (modifyOldNeighbour) {\n            (0, _resize.updateColumnWidth)(modifyOldNeighbour, oldNeighbourWidth);\n          }\n\n          _this5.fireMountEvent(_this5.contentType, column);\n        });\n      } else if (this.columnLineBottomDropPlaceholder.hasClass(\"active\")) {\n        // if new column line placeholders are visible, add new column line and move column there\n        (0, _factory.createColumnLine)(this.contentType.parentContentType, this.resizeUtils.getSmallestColumnWidth(), this.getNewColumnLineIndex()).then(function (columnLine) {\n          (0, _moveContentType.moveContentType)(column, 0, columnLine);\n          (0, _resize.updateColumnWidth)(column, 100);\n\n          if (modifyOldNeighbour) {\n            (0, _resize.updateColumnWidth)(modifyOldNeighbour, oldNeighbourWidth);\n          }\n\n          _this5.fireMountEvent(_this5.contentType, column);\n        });\n      } else {\n        (0, _moveContentType.moveContentType)(column, movePosition.insertIndex, this.contentType);\n\n        if (modifyOldNeighbour) {\n          (0, _resize.updateColumnWidth)(modifyOldNeighbour, oldNeighbourWidth);\n        }\n\n        var newNeighbourWidth = this.resizeUtils.getAcceptedColumnWidth((this.resizeUtils.getColumnWidth(movePosition.affectedColumn) - oldWidth).toString());\n        var newNeighbour = movePosition.affectedColumn;\n        var totalWidthAdjusted = 0;\n        (0, _resize.updateColumnWidth)(column, oldWidth);\n\n        while (true) {\n          // take width from all neighbours in one direction till the entire width is obtained\n          if (newNeighbourWidth <= 0) {\n            newNeighbourWidth = this.resizeUtils.getSmallestColumnWidth();\n            var originalWidthOfNeighbour = this.resizeUtils.getColumnWidth(newNeighbour);\n            (0, _resize.updateColumnWidth)(newNeighbour, newNeighbourWidth);\n            totalWidthAdjusted += originalWidthOfNeighbour - newNeighbourWidth;\n          } else {\n            (0, _resize.updateColumnWidth)(newNeighbour, newNeighbourWidth);\n            break;\n          }\n\n          if (direction === \"+1\") {\n            newNeighbour = (0, _resize.getAdjacentColumn)(newNeighbour, \"+1\");\n          } else {\n            newNeighbour = (0, _resize.getAdjacentColumn)(newNeighbour, \"-1\");\n          }\n\n          if (!newNeighbour) {\n            (0, _resize.updateColumnWidth)(column, totalWidthAdjusted);\n            break;\n          }\n\n          var neighbourExistingWidth = this.resizeUtils.getColumnWidth(newNeighbour);\n          newNeighbourWidth = neighbourExistingWidth - (oldWidth - totalWidthAdjusted);\n\n          if (newNeighbourWidth < 0.001) {\n            newNeighbourWidth = 0;\n          }\n        }\n\n        var totalWidth = 0;\n        this.contentType.children().forEach(function (columnChild) {\n          totalWidth += _this5.resizeUtils.getColumnWidth(columnChild);\n        });\n\n        if (totalWidth > 100) {\n          // take extra width from newly moved column\n          (0, _resize.updateColumnWidth)(column, this.resizeUtils.getColumnWidth(column) - (totalWidth - 100));\n        }\n      }\n    }\n    /**\n     * Init the resizing events on the group\n     *\n     * @param {JQuery} line\n     */\n    ;\n\n    _proto.initMouseMove = function initMouseMove(line) {\n      var _this6 = this;\n\n      var intersects = false;\n      (0, _jquery)(document).on(\"mousemove touchmove\", function (event) {\n        if (line.parents(_sortable.hiddenClass).length > 0) {\n          return;\n        }\n\n        var linePosition = _this6.getLinePosition(line); // If we're handling a touch event we need to pass through the page X & Y\n\n\n        if (event.type === \"touchmove\") {\n          event.pageX = event.originalEvent.pageX;\n          event.pageY = event.originalEvent.pageY;\n        }\n\n        if (_this6.eventIntersectsLine(event, linePosition)) {\n          intersects = true; // @todo re-instate onResizingMouseMove\n\n          _this6.onResizingMouseMove(event, line, linePosition);\n\n          _this6.onDraggingMouseMove(event, line, linePosition);\n\n          _this6.onDroppingMouseMove(event, line, linePosition);\n        } else {\n          intersects = false;\n          _this6.linePositionCache = null;\n          _this6.dropPosition = null;\n\n          _this6.dropPlaceholder.removeClass(\"left right\");\n\n          _this6.columnLineDropPlaceholder.removeClass(\"active\");\n\n          _this6.columnLineBottomDropPlaceholder.removeClass(\"active\");\n\n          _this6.columnLineBottomDropPlaceholder.hide();\n\n          _this6.columnLineDropPlaceholder.hide(); // @todo combine active and show/hide functionality for columnLineDropPlaceholder\n          //  this.movePlaceholder.css(\"left\", \"\").removeClass(\"active\");\n\n        }\n      }).on(\"mouseup touchend\", function () {\n        if (intersects) {\n          _this6.handleMouseUp();\n        }\n\n        intersects = false;\n        _this6.dropPosition = null;\n\n        _this6.endAllInteractions();\n\n        _underscore.defer(function () {\n          // Re-enable any disabled sortable areas\n          line.find(\".ui-sortable\").each(function () {\n            if ((0, _jquery)(this).data(\"ui-sortable\")) {\n              (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n            }\n          });\n        });\n      });\n    }\n    /**\n     * End all current interactions\n     */\n    ;\n\n    _proto.endAllInteractions = function endAllInteractions() {\n      if (this.resizing() === true) {\n        for (; this.interactionLevel > 0; this.interactionLevel--) {\n          _events.trigger(\"stage:interactionStop\", {\n            stageId: this.contentType.stageId\n          });\n        }\n      }\n\n      this.linePositionCache = null;\n      this.dropPosition = null;\n      this.dropPlaceholder.removeClass(\"left right\");\n      this.columnLineDropPlaceholder.removeClass(\"active\");\n      this.columnLineBottomDropPlaceholder.removeClass(\"active\");\n      this.columnLineBottomDropPlaceholder.hide();\n      this.columnLineDropPlaceholder.hide();\n      this.resizing(false);\n      this.resizeMouseDown = null;\n      this.resizeLeftLastColumnShrunk = this.resizeRightLastColumnShrunk = null;\n      this.dropPositions = [];\n      this.unsetResizingColumns(); // Change the cursor back\n\n      (0, _jquery)(\"body\").css(\"cursor\", \"\");\n      this.movePlaceholder.css(\"left\", \"\").removeClass(\"active\");\n      this.resizeGhost.removeClass(\"active\"); // Reset the line positions cache\n\n      this.linePositionCache = null;\n    }\n    /**\n     * Handle the mouse up action, either adding a new column or moving an existing\n     */\n    ;\n\n    _proto.handleMouseUp = function handleMouseUp() {\n      var self = this;\n      var dragColumn = (0, _registry.getDragColumn)();\n\n      if ((this.columnLineDropPlaceholder.hasClass(\"active\") || this.columnLineBottomDropPlaceholder.hasClass(\"active\")) && !dragColumn) {\n        (0, _factory.createColumnLine)(this.contentType.parentContentType, this.resizeUtils.getSmallestColumnWidth(), this.getNewColumnLineIndex()).then(function (columnLine) {\n          _events.trigger(columnLine.config.name + \":dropAfter\", {\n            id: columnLine.id,\n            columnLine: columnLine\n          });\n        });\n        return;\n      }\n\n      if (this.dropOverElement && this.dropPosition) {\n        this.onNewColumnDrop(this.dropPosition);\n        this.dropOverElement = null; // Re-enable the parent disabled sortable instance\n\n        _underscore.defer(function () {\n          (0, _jquery)(\".element-children.ui-sortable-disabled\").each(function () {\n            (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n          });\n        });\n      }\n\n      var column = (0, _registry.getDragColumn)();\n\n      if (this.isColumnBeingMovedToAnotherColumnLine()) {\n        this.onExistingColumnDrop(this.movePosition);\n      }\n    }\n    /**\n     * Does the current event intersect with the line?\n     *\n     * @param {JQueryEventObject} event\n     * @param {LinePositionCache} groupPosition\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.eventIntersectsLine = function eventIntersectsLine(event, groupPosition) {\n      return event.pageY > groupPosition.top && event.pageY < groupPosition.top + groupPosition.outerHeight && event.pageX > groupPosition.left && event.pageX < groupPosition.left + groupPosition.outerWidth;\n    }\n    /**\n     * Handle a column being dragged around the group\n     *\n     * @param {JQueryEventObject} event\n     * @param {JQuery} line\n     * @param {LinePositionCache} linePosition\n     */\n    ;\n\n    _proto.onDraggingMouseMove = function onDraggingMouseMove(event, line, linePosition) {\n      var dragColumn = (0, _registry.getDragColumn)();\n\n      if (dragColumn) {\n        // If the drop positions haven't been calculated for this line do so now\n        if (this.dropPositions.length === 0) {\n          this.dropPositions = (0, _dragAndDrop.calculateDropPositions)(this.contentType);\n        }\n\n        var columnInstance = dragColumn;\n        var currentX = event.pageX - linePosition.left; // Are we within the same column line or have we ended up over another?\n\n        if (columnInstance.parentContentType === this.contentType && this.startDragEvent) {\n          var dragDirection = event.pageX <= this.startDragEvent.pageX ? \"left\" : \"right\";\n          var adjacentLeftColumn = (0, _resize.getAdjacentColumn)(dragColumn, \"-1\"); // Determine the current move position based on the cursors position and direction of drag\n\n          this.movePosition = this.dropPositions.find(function (position) {\n            return currentX > position.left && currentX < position.right && position.placement === dragDirection && position.affectedColumn !== dragColumn;\n          }); // Differences in the element & event positions cause a right movement to activate on the left column\n\n          if (this.movePosition && dragDirection === \"right\" && this.movePosition.affectedColumn === adjacentLeftColumn) {\n            this.movePosition = null;\n          }\n\n          if (this.movePosition && !this.isNewLinePlaceDropPlaceholderVisible(event, linePosition) && !this.isNewLineBottomPlaceDropPlaceholderVisible(event, linePosition)) {\n            this.dropPlaceholder.removeClass(\"left right\");\n            this.movePlaceholder.css({\n              left: this.movePosition.placement === \"left\" ? this.movePosition.left : \"\",\n              right: this.movePosition.placement === \"right\" ? linePosition.width - this.movePosition.right : \"\",\n              width: dragColumn.preview.element.outerWidth() + \"px\"\n            }).addClass(\"active\");\n          } else {\n            this.movePlaceholder.removeClass(\"active\");\n          }\n        } else {\n          // If we're moving to another column line we utilise the existing drop placeholder\n          this.movePosition = this.dropPositions.find(function (position) {\n            return currentX > position.left && currentX <= position.right && position.canShrink;\n          });\n\n          if (this.movePosition && !this.isNewLinePlaceDropPlaceholderVisible(event, linePosition)) {\n            var classToRemove = this.movePosition.placement === \"left\" ? \"right\" : \"left\";\n            this.movePlaceholder.removeClass(\"active\");\n            this.dropPlaceholder.removeClass(classToRemove).css({\n              left: this.movePosition.placement === \"left\" ? this.movePosition.left : \"\",\n              right: this.movePosition.placement === \"right\" ? linePosition.width - this.movePosition.right : \"\",\n              width: linePosition.width / this.resizeUtils.getGridSize() + \"px\"\n            }).addClass(this.movePosition.placement);\n          } else {\n            this.dropPlaceholder.removeClass(\"left right\");\n          }\n        }\n      }\n    }\n    /**\n     * Handle the resizing on mouse move, we always resize a pair of columns at once\n     *\n     * @param {JQueryEventObject} event\n     * @param {JQuery} group\n     * @param {GroupPositionCache} groupPosition\n     */\n    ;\n\n    _proto.onResizingMouseMove = function onResizingMouseMove(event, group, groupPosition) {\n      var _this7 = this;\n\n      var newColumnWidth;\n\n      if (this.resizeMouseDown) {\n        event.preventDefault();\n        var currentPos = event.pageX;\n        var resizeColumnLeft = this.resizeColumnInstance.preview.element.offset().left;\n        var resizeColumnWidth = this.resizeColumnInstance.preview.element.outerWidth();\n        var resizeHandlePosition = resizeColumnLeft + resizeColumnWidth;\n        var direction = currentPos >= resizeHandlePosition ? \"right\" : \"left\";\n        var adjustedColumn;\n        var modifyColumnInPair; // We need to know if we're modifying the left or right column in the pair\n\n        var usedHistory; // Was the adjusted column pulled from history?\n        // Determine which column in the group should be adjusted for this action\n\n        var _this$resizeUtils$det = this.resizeUtils.determineAdjustedColumn(currentPos, this.resizeColumnInstance, this.resizeHistory);\n\n        adjustedColumn = _this$resizeUtils$det[0];\n        modifyColumnInPair = _this$resizeUtils$det[1];\n        usedHistory = _this$resizeUtils$det[2];\n        // Calculate the ghost width based on mouse position and bounds of allowed sizes\n        var ghostWidth = this.resizeUtils.calculateGhostWidth(groupPosition, currentPos, this.resizeColumnInstance, modifyColumnInPair, this.resizeMaxGhostWidth);\n        this.resizeGhost.width(ghostWidth - 15 + \"px\").addClass(\"active\");\n\n        if (adjustedColumn && this.resizeColumnWidths) {\n          newColumnWidth = this.resizeColumnWidths.find(function (val) {\n            return (0, _resize.comparator)(currentPos, val.position, 35) && val.forColumn === modifyColumnInPair;\n          });\n\n          if (newColumnWidth) {\n            var mainColumn = this.resizeColumnInstance; // If we're using the left data set, we're actually resizing the right column of the group\n\n            if (modifyColumnInPair === \"right\") {\n              mainColumn = (0, _resize.getAdjacentColumn)(this.resizeColumnInstance, \"+1\");\n            } // Ensure we aren't resizing multiple times, also validate the last resize isn't the same as the\n            // one being performed now. This occurs as we re-calculate the column positions on resize, we have\n            // to use the comparator as the calculation may result in slightly different numbers due to rounding\n\n\n            if (this.resizeUtils.getColumnWidth(mainColumn) !== newColumnWidth.width && !(0, _resize.comparator)(this.resizeLastPosition, newColumnWidth.position, 10)) {\n              // If our previous action was to resize the right column in pair, and we're now dragging back\n              // to the right, but have matched a column for the left we need to fix the columns being\n              // affected\n              if (usedHistory && this.resizeLastColumnInPair === \"right\" && direction === \"right\" && newColumnWidth.forColumn === \"left\") {\n                var originalMainColumn = mainColumn;\n                mainColumn = adjustedColumn;\n                adjustedColumn = (0, _resize.getAdjacentColumn)(originalMainColumn, \"+1\");\n              }\n\n              this.recordResizeHistory(usedHistory, direction, adjustedColumn, modifyColumnInPair);\n              this.resizeLastPosition = newColumnWidth.position;\n              this.resizeLastColumnInPair = modifyColumnInPair; // Ensure the adjusted column is marked as resizing to animate correctly\n\n              this.setColumnsAsResizing(mainColumn, adjustedColumn);\n              this.onColumnResize(mainColumn, newColumnWidth.width, adjustedColumn); // Wait for the render cycle to finish from the above resize before re-calculating\n\n              _underscore.defer(function () {\n                // If we do a resize, re-calculate the column widths\n                _this7.resizeColumnWidths = _this7.resizeUtils.determineColumnWidths(_this7.resizeColumnInstance, groupPosition);\n                _this7.resizeMaxGhostWidth = (0, _resize.determineMaxGhostWidth)(_this7.resizeColumnWidths);\n              });\n            }\n          }\n        }\n      }\n    }\n    /**\n     * Unset resizing flag on all child columns\n     */\n    ;\n\n    _proto.unsetResizingColumns = function unsetResizingColumns() {\n      this.contentType.children().forEach(function (column) {\n        column.preview.resizing(false);\n\n        if (column.preview.element) {\n          column.preview.element.css({\n            transition: \"\"\n          });\n        }\n      });\n    }\n    /**\n     *\n     * @param event\n     * @param linePosition\n     * @private\n     */\n    ;\n\n    _proto.isNewLinePlaceDropPlaceholderVisible = function isNewLinePlaceDropPlaceholderVisible(event, linePosition) {\n      var siblings = this.contentType.parentContentType.children();\n      var id = this.contentType.id;\n      var index = 0;\n      siblings.forEach(function (columnLine) {\n        if (columnLine.id === id) {\n          return false;\n        }\n\n        index++;\n      });\n      var draggedColumn = (0, _registry.getDragColumn)(); // show column line drop placeholder only for top column line in a group\n\n      return (this.dropOverElement || draggedColumn) && event.pageY > linePosition.top + 15 && event.pageY < linePosition.top + 15 + this.lineDropperHeight;\n    }\n    /**\n     *\n     * @param event\n     * @param linePosition\n     * @private\n     */\n    ;\n\n    _proto.isNewLineBottomPlaceDropPlaceholderVisible = function isNewLineBottomPlaceDropPlaceholderVisible(event, linePosition) {\n      var draggedColumn = (0, _registry.getDragColumn)();\n      return (this.dropOverElement || draggedColumn) && event.pageY < linePosition.top + 15 + this.element.outerHeight() && event.pageY > linePosition.top + 15 + this.element.outerHeight() - this.lineDropperHeight;\n    }\n    /**\n     *\n     * @param event\n     * @param linePosition\n     * @private\n     */\n    ;\n\n    _proto.isNewColumnDropPlaceholderVisible = function isNewColumnDropPlaceholderVisible(event, linePosition) {\n      var draggedColumn = (0, _registry.getDragColumn)();\n      return (this.dropOverElement || draggedColumn) && event.pageY > linePosition.top + 15 + this.lineDropperHeight && event.pageY < linePosition.top + 15 + linePosition.outerHeight - this.lineDropperHeight;\n    }\n    /**\n     * Handle mouse move events on when dropping elements\n     *\n     * @param {JQueryEventObject} event\n     * @param {JQuery} line\n     * @param {LinePositionCache} linePosition\n     */\n    ;\n\n    _proto.onDroppingMouseMove = function onDroppingMouseMove(event, line, linePosition) {\n      var elementChildrenParent = line.parents(\".element-children\"); // Only initiate this process if we're within the group by a buffer to allow for sortable to function correctly\n\n      if (this.isNewLinePlaceDropPlaceholderVisible(event, linePosition)) {\n        this.dropPosition = null;\n        this.dropPlaceholder.removeClass(\"left right\");\n        this.columnLineDropPlaceholder.addClass(\"active\");\n        this.columnLineDropPlaceholder.show();\n        return this.handleLineDropMouseMove(event, line, linePosition);\n      } else if (this.isNewLineBottomPlaceDropPlaceholderVisible(event, linePosition)) {\n        this.dropPosition = null;\n        this.dropPlaceholder.removeClass(\"left right\");\n        this.columnLineBottomDropPlaceholder.addClass(\"active\");\n        this.columnLineBottomDropPlaceholder.show();\n        return this.handleLineDropMouseMove(event, line, linePosition);\n      } else if (this.dropOverElement) {\n        this.columnLineDropPlaceholder.hide();\n        this.columnLineBottomDropPlaceholder.hide();\n        this.columnLineBottomDropPlaceholder.removeClass(\"active\");\n        this.columnLineDropPlaceholder.removeClass(\"active\");\n      }\n\n      if (this.isNewColumnDropPlaceholderVisible(event, linePosition)) {\n        this.columnLineDropPlaceholder.hide();\n        this.columnLineDropPlaceholder.removeClass(\"active\");\n        this.columnLineBottomDropPlaceholder.hide();\n        this.columnLineBottomDropPlaceholder.removeClass(\"active\");\n        return this.handleColumnDropMouseMove(event, line, linePosition);\n      }\n    }\n    /**\n     *\n     * @param event\n     * @param line\n     * @param linePosition\n     * @private\n     */\n    ;\n\n    _proto.handleLineDropMouseMove = function handleLineDropMouseMove(event, line, linePosition) {\n      var elementChildrenParent = line.parents(\".element-children\"); // Disable the column line sortable instance\n      // Disable the column group sortable instance\n\n      if (elementChildrenParent.data(\"ui-sortable\")) {\n        elementChildrenParent.sortable(\"option\", \"disabled\", true);\n      }\n    }\n    /**\n     *\n     * @param event\n     * @param line\n     * @param linePosition\n     * @private\n     */\n    ;\n\n    _proto.handleColumnDropMouseMove = function handleColumnDropMouseMove(event, line, linePosition) {\n      var elementChildrenParent = line.parents(\".element-children\"); // Only initiate this process if we're within the group by a buffer to allow for sortable to function correctly\n\n      if (this.dropOverElement && event.pageY > linePosition.top + 50 && event.pageY < linePosition.top + linePosition.outerHeight - 50) {\n        // Disable the column line sortable instance\n        if (elementChildrenParent.data(\"ui-sortable\")) {\n          elementChildrenParent.sortable(\"option\", \"disabled\", true);\n        }\n\n        var currentX = event.pageX - linePosition.left;\n        this.dropPosition = this.dropPositions.find(function (position) {\n          return currentX > position.left && currentX <= position.right && position.canShrink;\n        });\n\n        if (this.dropPosition) {\n          this.dropPlaceholder.removeClass(\"left right\").css({\n            left: this.dropPosition.placement === \"left\" ? this.dropPosition.left : \"\",\n            right: this.dropPosition.placement === \"right\" ? linePosition.width - this.dropPosition.right : \"\",\n            width: linePosition.width / this.resizeUtils.getGridSize() + \"px\"\n          }).addClass(this.dropPosition.placement);\n        }\n      } else if (this.dropOverElement) {\n        // Re-enable the column group sortable instance\n        if (elementChildrenParent.data(\"ui-sortable\")) {\n          elementChildrenParent.sortable(\"option\", \"disabled\", false);\n        }\n\n        this.dropPosition = null;\n        this.dropPlaceholder.removeClass(\"left right\");\n      }\n    }\n    /**\n     * Cache the groups positions\n     *\n     * @param {JQuery} line\n     * @returns {}\n     */\n    ;\n\n    _proto.getLinePosition = function getLinePosition(line) {\n      if (!this.linePositionCache) {\n        this.linePositionCache = {\n          top: line.offset().top,\n          left: line.offset().left,\n          width: line.width(),\n          height: line.height(),\n          outerWidth: line.outerWidth(),\n          outerHeight: line.outerHeight()\n        };\n      }\n\n      return this.linePositionCache;\n    }\n    /**\n     * Init the droppable functionality for new columns\n     *\n     * @param {JQuery} line\n     */\n    ;\n\n    _proto.initDroppable = function initDroppable(line) {\n      var self = this;\n      var headStyles;\n      line.droppable({\n        deactivate: function deactivate() {\n          self.dropOverElement = null;\n          self.dropPlaceholder.removeClass(\"left right\");\n\n          _underscore.defer(function () {\n            // Re-enable the column group sortable instance & all children sortable instances\n            line.parents(\".element-children\").each(function () {\n              if ((0, _jquery)(this).data(\"ui-sortable\")) {\n                (0, _jquery)(this).sortable(\"option\", \"disabled\", false);\n              }\n            });\n          });\n        },\n        activate: function activate() {\n          if ((0, _registry2.getDraggedContentTypeConfig)() === _config.getContentTypeConfig(\"column-group\")) {\n            var _ref;\n\n            line.find(\".ui-sortable\").each(function () {\n              if ((0, _jquery)(this).data(\"ui-sortable\")) {\n                (0, _jquery)(this).sortable(\"option\", \"disabled\", true);\n              }\n            });\n            var classes = [\".pagebuilder-content-type.pagebuilder-column .pagebuilder-drop-indicator\", \".pagebuilder-content-type.pagebuilder-column .empty-container .content-type-container:before\"]; // Ensure we don't display any drop indicators inside the column\n\n            headStyles = (0, _createStylesheet.createStyleSheet)((_ref = {}, _ref[classes.join(\", \")] = {\n              display: \"none!important\"\n            }, _ref));\n            document.head.appendChild(headStyles);\n          } else if (headStyles) {\n            headStyles.remove();\n            headStyles = null;\n          }\n        },\n        drop: function drop() {\n          self.dropPositions = [];\n          self.dropPlaceholder.removeClass(\"left right\");\n        },\n        out: function out() {\n          self.dropOverElement = null;\n          self.dropPlaceholder.removeClass(\"left right\");\n        },\n        over: function over() {\n          // Is the element currently being dragged a column group?\n          if ((0, _registry2.getDraggedContentTypeConfig)() === _config.getContentTypeConfig(\"column-group\") || (0, _registry2.getDraggedContentTypeConfig)() === _config.getContentTypeConfig(\"column\")) {\n            // Always calculate drop positions when an element is dragged over\n            var ownContentType = self.contentType;\n            self.dropPositions = (0, _dragAndDrop.calculateDropPositions)(ownContentType);\n            self.dropOverElement = true;\n          } else {\n            self.dropOverElement = null;\n          }\n        }\n      });\n    }\n    /**\n     * Spread any empty space across the other columns when a column is removed\n     *\n     * @param {number} removedIndex\n     */\n    ;\n\n    _proto.spreadWidth = function spreadWidth(removedIndex) {\n      if (this.contentType.children().length === 0) {\n        return;\n      }\n\n      var availableWidth = 100 - this.resizeUtils.getColumnsWidth();\n      var formattedAvailableWidth = (0, _resize.getRoundedColumnWidth)(availableWidth);\n      var totalChildColumns = this.contentType.children().length;\n      var allowedColumnWidths = [];\n      var spreadAcross = 1;\n      var spreadAmount;\n\n      for (var i = this.resizeUtils.getGridSize(); i > 0; i--) {\n        allowedColumnWidths.push((0, _resize.getRoundedColumnWidth)(100 / this.resizeUtils.getGridSize() * i));\n      } // Determine how we can spread the empty space across the columns\n\n\n      for (var _i = totalChildColumns; _i > 0; _i--) {\n        var potentialWidth = Math.floor(formattedAvailableWidth / _i);\n\n        for (var _iterator = _createForOfIteratorHelperLoose(allowedColumnWidths), _step; !(_step = _iterator()).done;) {\n          var width = _step.value;\n\n          if (potentialWidth === Math.floor(width)) {\n            spreadAcross = _i;\n            spreadAmount = formattedAvailableWidth / _i;\n            break;\n          }\n        }\n\n        if (spreadAmount) {\n          break;\n        }\n      } // Let's spread the width across the columns\n\n\n      for (var _i2 = 1; _i2 <= spreadAcross; _i2++) {\n        var columnToModify = void 0; // As the original column has been removed from the array, check the new index for a column\n\n        if (removedIndex <= this.contentType.children().length && typeof this.contentType.children()[removedIndex] !== \"undefined\") {\n          columnToModify = this.contentType.children()[removedIndex];\n        }\n\n        if (!columnToModify && removedIndex - _i2 >= 0 && typeof this.contentType.children()[removedIndex - _i2] !== \"undefined\") {\n          columnToModify = this.contentType.children()[removedIndex - _i2];\n        }\n\n        if (columnToModify) {\n          (0, _resize.updateColumnWidth)(columnToModify, this.resizeUtils.getColumnWidth(columnToModify) + spreadAmount);\n        }\n      }\n    }\n    /**\n     * Register a resize handle within a child column\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {JQuery} handle\n     */\n    ;\n\n    _proto.registerResizeHandle = function registerResizeHandle(column, handle) {\n      var _this8 = this;\n\n      handle.off(\"mousedown touchstart\");\n      handle.on(\"mousedown touchstart\", function (event) {\n        event.preventDefault();\n\n        var groupPosition = _this8.getLinePosition(_this8.element);\n\n        _this8.resizing(true); // @ts-ignore\n\n\n        _this8.resizeColumnInstance = column;\n        _this8.resizeColumnWidths = _this8.resizeUtils.determineColumnWidths(_this8.resizeColumnInstance, groupPosition);\n        _this8.resizeMaxGhostWidth = (0, _resize.determineMaxGhostWidth)(_this8.resizeColumnWidths); // Force the cursor to resizing\n\n        (0, _jquery)(\"body\").css(\"cursor\", \"col-resize\"); // Reset the resize history\n\n        _this8.resizeHistory = {\n          left: [],\n          right: []\n        };\n        _this8.resizeLastPosition = null;\n        _this8.resizeMouseDown = true;\n        ++_this8.interactionLevel;\n\n        _events.trigger(\"stage:interactionStart\", {\n          stageId: _this8.contentType.stageId\n        });\n      });\n    }\n    /**\n     * Add Columns to the current Column Line\n     *\n     * @returns {Promise<ContentTypeCollectionInterface>}\n     */\n    ;\n\n    _proto.createColumns = function createColumns() {\n      var _this9 = this;\n\n      var defaultGridSize = (0, _gridSize.getDefaultGridSize)();\n      var col1Width = (Math.ceil(defaultGridSize / 2) * 100 / defaultGridSize).toFixed(Math.round(100 / defaultGridSize) !== 100 / defaultGridSize ? 8 : 0);\n      Promise.all([(0, _contentTypeFactory)(_config.getContentTypeConfig(\"column\"), this.contentType, this.contentType.stageId, {\n        width: col1Width + \"%\"\n      }), (0, _contentTypeFactory)(_config.getContentTypeConfig(\"column\"), this.contentType, this.contentType.stageId, {\n        width: 100 - parseFloat(col1Width) + \"%\"\n      })]).then(function (columns) {\n        _this9.contentType.addChild(columns[0], 0);\n\n        _this9.contentType.addChild(columns[1], 1);\n\n        _this9.fireMountEvent(_this9.contentType, columns[0], columns[1]);\n      });\n    }\n    /**\n     * Record the resizing history for this action\n     *\n     * @param {string} usedHistory\n     * @param {string} direction\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} adjustedColumn\n     * @param {string} modifyColumnInPair\n     */\n    ;\n\n    _proto.recordResizeHistory = function recordResizeHistory(usedHistory, direction, adjustedColumn, modifyColumnInPair) {\n      if (usedHistory) {\n        this.resizeHistory[usedHistory].pop();\n      }\n\n      this.resizeHistory[direction].push({\n        adjustedColumn: adjustedColumn,\n        modifyColumnInPair: modifyColumnInPair\n      });\n    }\n    /**\n     * Set columns in the group as resizing\n     *\n     * @param {Array<ContentTypeCollectionInterface<ColumnPreview>>} columns\n     */\n    ;\n\n    _proto.setColumnsAsResizing = function setColumnsAsResizing() {\n      for (var _len = arguments.length, columns = new Array(_len), _key = 0; _key < _len; _key++) {\n        columns[_key] = arguments[_key];\n      }\n\n      columns.forEach(function (column) {\n        column.preview.resizing(true);\n        column.preview.element.css({\n          transition: \"width 350ms ease-in-out\"\n        });\n      });\n    }\n    /**\n     * Handle a column being resized\n     *\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} column\n     * @param {number} width\n     * @param {ContentTypeCollectionInterface<ColumnPreview>} adjustedColumn\n     */\n    ;\n\n    _proto.onColumnResize = function onColumnResize(column, width, adjustedColumn) {\n      this.resizeUtils.resizeColumn(column, width, adjustedColumn);\n    }\n    /**\n     * Fire the mount event for content types\n     *\n     * @param {ContentTypeInterface[]} contentTypes\n     */\n    ;\n\n    _proto.fireMountEvent = function fireMountEvent() {\n      for (var _len2 = arguments.length, contentTypes = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {\n        contentTypes[_key2] = arguments[_key2];\n      }\n\n      contentTypes.forEach(function (contentType) {\n        _events.trigger(\"contentType:mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n\n        _events.trigger(contentType.config.name + \":mountAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n      });\n    }\n    /**\n     * Remove self if we contain no children\n     */\n    ;\n\n    _proto.removeIfEmpty = function removeIfEmpty() {\n      if (this.contentType.children().length === 0) {\n        this.contentType.parentContentType.removeChild(this.contentType);\n        return;\n      }\n    };\n\n    _proto.getNewColumnLineIndex = function getNewColumnLineIndex() {\n      var index = -1;\n      var self = this;\n\n      for (var _iterator2 = _createForOfIteratorHelperLoose(this.contentType.parentContentType.children()), _step2; !(_step2 = _iterator2()).done;) {\n        var child = _step2.value;\n        index++;\n\n        if (child.id === self.contentType.id) {\n          break;\n        }\n      }\n\n      if (this.columnLineBottomDropPlaceholder.hasClass(\"active\")) {\n        // show the bottom drop placeholder\n        index++;\n      }\n\n      return index;\n    };\n\n    _proto.isColumnBeingMovedToAnotherColumnLine = function isColumnBeingMovedToAnotherColumnLine() {\n      var column = (0, _registry.getDragColumn)();\n\n      if (!column) {\n        // if no move position, column is not being moved.\n        return false;\n      }\n\n      if (column.parentContentType !== this.contentType) {\n        // if the parent content type is not same as this column line, column is being moved to new column line\n        return true;\n      }\n\n      if (column.parentContentType === this.contentType && (this.columnLineDropPlaceholder.hasClass(\"active\") || this.columnLineBottomDropPlaceholder.hasClass(\"active\"))) {\n        // since new column line drop placeholder is visible, column move should introduce a new column line\n        return true;\n      }\n\n      return false;\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/divider/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      return _preview2.apply(this, arguments) || this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/heading/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type-toolbar\", \"Magento_PageBuilder/js/utils/promise-deferred\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _events, _underscore, _hideShowOption, _contentTypeToolbar, _promiseDeferred, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    /**\n     * @param {ContentTypeInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _preview2.call(this, contentType, config, observableUpdater) || this;\n      _this.afterRenderDeferred = (0, _promiseDeferred)();\n      _this.toolbar = new _contentTypeToolbar(_assertThisInitialized(_this), _this.getToolbarOptions());\n      return _this;\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * On render init the heading\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.afterRender = function afterRender(element) {\n      this.element = element;\n      this.afterRenderDeferred.resolve(element);\n    };\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _preview2.prototype.bindEvents.call(this); // When a heading is dropped for the first time show heading toolbar\n\n\n      _events.on(\"heading:dropAfter\", function (args) {\n        if (args.id === _this2.contentType.id) {\n          Promise.all([_this2.afterRenderDeferred.promise, _this2.toolbar.afterRenderDeferred.promise]).then(function (_ref) {\n            var element = _ref[0];\n\n            _underscore.defer(function () {\n              (0, _jquery)(element).focus();\n            });\n          });\n        }\n      });\n    }\n    /**\n     * Get option value from observable data.\n     *\n     * @param {string} key\n     * @return {*}\n     */\n    ;\n\n    _proto.getOptionValue = function getOptionValue(key) {\n      if (key === \"heading_type\") {\n        return this.data.main.heading_type();\n      } else if (key === \"text_align\") {\n        return this.data.main.style().textAlign;\n      }\n\n      return;\n    }\n    /**\n     * Build and return the tool bar options for heading\n     *\n     * @returns {OptionInterface[]}\n     */\n    ;\n\n    _proto.getToolbarOptions = function getToolbarOptions() {\n      return [{\n        key: \"heading_type\",\n        type: \"select\",\n        values: [{\n          value: \"h1\",\n          label: \"H1\",\n          icon: \"\"\n        }, {\n          value: \"h2\",\n          label: \"H2\",\n          icon: \"\"\n        }, {\n          value: \"h3\",\n          label: \"H3\",\n          icon: \"\"\n        }, {\n          value: \"h4\",\n          label: \"H4\",\n          icon: \"\"\n        }, {\n          value: \"h5\",\n          label: \"H5\",\n          icon: \"\"\n        }, {\n          value: \"h6\",\n          label: \"H6\",\n          icon: \"\"\n        }]\n      }, {\n        key: \"text_align\",\n        type: \"select\",\n        values: [{\n          value: \"left\",\n          label: \"Left\",\n          icon: \"icon-pagebuilder-align-left\"\n        }, {\n          value: \"center\",\n          label: \"Center\",\n          icon: \"icon-pagebuilder-align-center\"\n        }, {\n          value: \"right\",\n          label: \"Right\",\n          icon: \"icon-pagebuilder-align-right\"\n        }]\n      }];\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/html/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      return _preview2.apply(this, arguments) || this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/image/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/uploader\", \"Magento_PageBuilder/js/content-type/preview\"], function (_events, _hideShowOption, _uploader, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      return _preview2.apply(this, arguments) || this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Get registry callback reference to uploader UI component\n     *\n     * @returns {Uploader}\n     */\n    ;\n\n    _proto.getUploader = function getUploader() {\n      var initialImageValue = this.contentType.dataStore.get(this.config.additional_data.uploaderConfig.dataScope, \"\");\n      return new _uploader(\"imageuploader_\" + this.contentType.id, this.config.additional_data.uploaderConfig, this.contentType.id, this.contentType.dataStore, initialImageValue);\n    }\n    /**\n     * Get viewport image data\n     */\n    ;\n\n    _proto.getViewportImageData = function getViewportImageData() {\n      var desktopImageData = this.data.desktop_image;\n      var mobileImageData = this.data.mobile_image;\n      return this.viewport() === \"mobile\" && typeof mobileImageData !== \"undefined\" ? mobileImageData : desktopImageData;\n    }\n    /**\n     * @inheritDoc\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this = this;\n\n      _preview2.prototype.bindEvents.call(this);\n\n      _events.on(\"image:mountAfter\", function (args) {\n        if (args.id === _this.contentType.id) {\n          _this.isSnapshot.subscribe(function (value) {\n            _this.changeUploaderControlsVisibility();\n          });\n\n          _this.changeUploaderControlsVisibility();\n        }\n      });\n\n      _events.on(this.config.name + \":\" + this.contentType.id + \":updateAfter\", function () {\n        var files = _this.contentType.dataStore.get(_this.config.additional_data.uploaderConfig.dataScope);\n\n        var imageObject = files ? files[0] : {};\n\n        _events.trigger(\"image:\" + _this.contentType.id + \":assignAfter\", imageObject);\n      });\n    }\n    /**\n     * Change uploader controls visibility\n     */\n    ;\n\n    _proto.changeUploaderControlsVisibility = function changeUploaderControlsVisibility() {\n      var _this2 = this;\n\n      this.getUploader().getUiComponent()(function (uploader) {\n        uploader.visibleControls = !_this2.isSnapshot();\n      });\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/map/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"knockout\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/utils/map\", \"module\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_knockout, _events, _map, _module, _hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.apiKeyValid = _knockout.observable(!!_module.config().apiKey);\n      _this.apiKeyErrorMessage = _module.config().apiKeyErrorMessage;\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Open edit menu on map content type drop with a delay of 300ms\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this2 = this;\n\n      _preview2.prototype.bindEvents.call(this); // When the map api key fails, empties out the content type and adds the placeholder\n\n\n      _events.on(\"googleMaps:authFailure\", function () {\n        _this2.apiKeyValid(false);\n      });\n    }\n    /**\n     * Renders the map and subscribe to position for updates\n     *\n     * @param {Element} element\n     * @returns {void}\n     */\n    ;\n\n    _proto.renderMap = function renderMap(element) {\n      var _this3 = this;\n\n      if (!this.apiKeyValid()) {\n        return;\n      }\n\n      this.generateMap(element);\n      this.element = element;\n\n      if (this.mapElement && this.mapElement.map) {\n        this.data.main.attributes.subscribe(function () {\n          _this3.updateMap();\n        });\n      }\n    }\n    /**\n     * Generate maps\n     *\n     * @param {Element} element\n     * @returns {void}\n     */\n    ;\n\n    _proto.generateMap = function generateMap(element) {\n      var currentLocations = this.data.main.attributes()[\"data-locations\"] || \"[]\";\n      var controls = this.data.main.attributes()[\"data-show-controls\"] || \"true\";\n      var locations = [];\n      var options = {\n        disableDefaultUI: controls !== \"true\",\n        mapTypeControl: controls === \"true\"\n      };\n\n      if (currentLocations !== \"[]\") {\n        var mapData = this.getMapData();\n        locations = mapData.locations;\n        options = mapData.options;\n      }\n\n      this.mapElement = new _map(element, locations, options);\n    }\n    /**\n     * Updates map\n     *\n     * @returns {void}\n     */\n    ;\n\n    _proto.updateMap = function updateMap() {\n      var mapData = this.getMapData();\n      this.mapElement.onUpdate(mapData.locations, mapData.options);\n    }\n    /**\n     * Get locations, center coordinates, and zoom from data.position\n     *\n     * @returns {Object}\n     */\n    ;\n\n    _proto.getMapData = function getMapData() {\n      var attributes = this.data.main.attributes();\n      var controls = attributes[\"data-show-controls\"];\n      var options = {\n        disableDefaultUI: controls !== \"true\",\n        mapTypeControl: controls === \"true\"\n      };\n      var locations = attributes[\"data-locations\"];\n\n      if (locations !== \"\" && typeof locations === \"string\") {\n        locations = JSON.parse(locations);\n      }\n\n      locations.forEach(function (location) {\n        location.position.latitude = parseFloat(location.position.latitude);\n        location.position.longitude = parseFloat(location.position.longitude);\n      });\n      return {\n        locations: locations,\n        options: options\n      };\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/map/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/utils/map'\n], function ($, GoogleMap) {\n    'use strict';\n\n    return function (config, element) {\n        var locations,\n            controls,\n            mapOptions = {};\n\n        element = element[0];\n\n        if (element !== undefined && element.hasAttribute('data-locations')) {\n\n            /**\n             * Set map display to none if no locations\n             */\n            if (element.getAttribute('data-locations') === '[]') {\n                $(element).hide();\n\n                return;\n            }\n            locations = JSON.parse(element.getAttribute('data-locations'));\n            locations.forEach(function (location) {\n                location.position.latitude = parseFloat(location.position.latitude);\n                location.position.longitude = parseFloat(location.position.longitude);\n            });\n            controls = element.getAttribute('data-show-controls');\n            mapOptions.disableDefaultUI = controls !== 'true';\n            mapOptions.mapTypeControl = controls === 'true';\n            new GoogleMap(element, locations, mapOptions);\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/map/converter/attribute/locations.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Locations = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Locations() {}\n\n    var _proto = Locations.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (value && value !== \"\") {\n        return JSON.parse(value);\n      }\n\n      return [];\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var content = (0, _object.get)(data, name);\n\n      if (_underscore.isString(content) && content !== \"\") {\n        content = JSON.parse(content);\n      }\n\n      if (content && Object.keys(content).length) {\n        content.forEach(function (marker) {\n          if (marker.position) {\n            marker.position.latitude = parseFloat(marker.position.latitude);\n            marker.position.longitude = parseFloat(marker.position.longitude);\n          }\n        });\n        return JSON.stringify(content);\n      }\n\n      return JSON.stringify([]);\n    };\n\n    return Locations;\n  }();\n\n  return Locations;\n});\n//# sourceMappingURL=locations.js.map","Magento_PageBuilder/js/content-type/observable-updater/attributes.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _config, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Generate Knockout compatible bindings for the elements attribute binding\n   *\n   * @param elementName\n   * @param config\n   * @param data\n   * @param converterResolver\n   * @param converterPool\n   */\n  function generate(elementName, config, data, converterResolver, converterPool) {\n    var attributeData = {};\n\n    var _loop = function _loop() {\n      var attributeConfig = _step.value;\n\n      if (\"read\" === attributeConfig.persistence_mode) {\n        return \"continue\";\n      } // @ts-ignore\n\n\n      var value = void 0;\n\n      if (!!attributeConfig.static) {\n        value = attributeConfig.value;\n      } else {\n        value = (0, _object.get)(data, attributeConfig.var);\n      }\n\n      var converter = converterResolver(attributeConfig);\n\n      if (converterPool.get(converter)) {\n        value = converterPool.get(converter).toDom(attributeConfig.var, data);\n      } // Replacing src attribute with data-tmp-src to prevent img requests in iframe during master format rendering\n\n\n      if (_config.getMode() !== \"Preview\" && attributeConfig.name === \"src\" && _underscore.isString(value) && !value.indexOf(\"{{media url=\")) {\n        attributeData[\"data-tmp-\" + attributeConfig.name] = value; // @ts-ignore\n\n        Object.defineProperty(attributeData, attributeConfig.name, {\n          get: function get() {\n            return value;\n          }\n        });\n      } else {\n        attributeData[attributeConfig.name] = value;\n      }\n    };\n\n    for (var _iterator = _createForOfIteratorHelperLoose(config.attributes), _step; !(_step = _iterator()).done;) {\n      var _ret = _loop();\n\n      if (_ret === \"continue\") continue;\n    }\n\n    attributeData[\"data-element\"] = elementName;\n    return attributeData;\n  }\n\n  return generate;\n});\n//# sourceMappingURL=attributes.js.map","Magento_PageBuilder/js/content-type/observable-updater/css.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Generate Knockout compatible bindings for the elements css binding\n   *\n   * @param elementName\n   * @param config\n   * @param data\n   * @param converterResolver\n   * @param converterPool\n   * @param previousData\n   */\n  function generate(elementName, config, data, converterResolver, converterPool, previousData) {\n    var css = (0, _object.get)(data, config.css.var);\n    var newClasses = {};\n\n    if (css && css.length > 0) {\n      css.toString().split(\" \").map(function (value) {\n        return newClasses[value] = true;\n      });\n    }\n\n    for (var _i = 0, _Object$keys = Object.keys(previousData); _i < _Object$keys.length; _i++) {\n      var className = _Object$keys[_i];\n\n      if (!(className in newClasses)) {\n        newClasses[className] = false;\n      }\n    }\n\n    return newClasses;\n  }\n\n  return generate;\n});\n//# sourceMappingURL=css.js.map","Magento_PageBuilder/js/content-type/observable-updater/html.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/directives\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/utils/object\"], function (_config, _directives, _editor, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Generate Knockout compatible bindings for the elements html binding\n   *\n   * @param elementName\n   * @param config\n   * @param data\n   * @param converterResolver\n   * @param converterPool\n   */\n  function generate(elementName, config, data, converterResolver, converterPool) {\n    var value = config.html.var ? (0, _object.get)(data, config.html.var, config.html.placeholder) : config.html.placeholder;\n    var converter = converterResolver(config.html);\n\n    if (converterPool.get(converter)) {\n      value = converterPool.get(converter).toDom(config.html.var, data);\n    } // if value is empty, use placeholder\n\n\n    if (typeof value === \"string\" && !value.length && config.html.placeholder) {\n      value = config.html.placeholder;\n    } // Replacing src attribute with data-tmp-src to prevent img requests in iframe during master format rendering\n\n\n    if (_config.getMode() !== \"Preview\" && typeof value === \"string\" && value.indexOf(\"{{media url=\") !== -1) {\n      value = (0, _directives.replaceWithDataSrc)(value);\n    } // Process all desktop styles that left unprocessed after migrating from inline styles.\n\n\n    if (typeof value === \"string\") {\n      value = (0, _editor.processInlineStyles)(value);\n    }\n\n    return value;\n  }\n\n  return generate;\n});\n//# sourceMappingURL=html.js.map","Magento_PageBuilder/js/content-type/observable-updater/style.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\", \"Magento_PageBuilder/js/utils/string\"], function (_underscore, _object, _string) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Generate Knockout compatible bindings for the elements style binding\n   *\n   * @param elementName\n   * @param config\n   * @param data\n   * @param converterResolver\n   * @param converterPool\n   * @param previousData\n   */\n  function generate(elementName, config, data, converterResolver, converterPool, previousData) {\n    var newStyles = {};\n\n    if (config.style) {\n      for (var _iterator = _createForOfIteratorHelperLoose(config.style), _step; !(_step = _iterator()).done;) {\n        var propertyConfig = _step.value;\n\n        if (\"read\" === propertyConfig.persistence_mode) {\n          continue;\n        }\n\n        var value = void 0;\n\n        if (!!propertyConfig.static) {\n          value = propertyConfig.value;\n        } else {\n          value = (0, _object.get)(data, propertyConfig.var);\n          var converter = converterResolver(propertyConfig);\n\n          if (converterPool.get(converter)) {\n            value = converterPool.get(converter).toDom(propertyConfig.var, data);\n          }\n        }\n\n        if (typeof value === \"object\") {\n          _underscore.extend(newStyles, value);\n        } else if (value !== undefined) {\n          newStyles[(0, _string.fromSnakeToCamelCase)(propertyConfig.name)] = value;\n        }\n      }\n    }\n\n    if (previousData) {\n      /**\n       * If so we need to retrieve the previous styles applied to this element and create a new object\n       * which forces all of these styles to be \"false\". Knockout doesn't clean existing styles when\n       * applying new styles to an element. This resolves styles sticking around when they should be\n       * removed.\n       */\n      var removeCurrentStyles = Object.keys(previousData).reduce(function (object, styleName) {\n        var _Object$assign;\n\n        return Object.assign(object, (_Object$assign = {}, _Object$assign[styleName] = \"\", _Object$assign));\n      }, {});\n\n      if (!_underscore.isEmpty(removeCurrentStyles)) {\n        newStyles = _underscore.extend(removeCurrentStyles, newStyles);\n      }\n    }\n\n    return newStyles;\n  }\n\n  return generate;\n});\n//# sourceMappingURL=style.js.map","Magento_PageBuilder/js/content-type/products/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"slick\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _knockout, _translate, _events, _slick, _underscore, _config, _hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    /**\n     * Define keys which when changed should not trigger the slider to be rebuilt\n     *\n     * @type {string[]}\n     */\n\n    /**\n     * @inheritdoc\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _preview2.call(this, contentType, config, observableUpdater) || this;\n      _this.displayPreview = _knockout.observable(false);\n      _this.previewElement = _jquery.Deferred();\n      _this.widgetUnsanitizedHtml = _knockout.observable();\n      _this.slidesToShow = 5;\n      _this.productItemSelector = \".product-item\";\n      _this.centerModeClass = \"center-mode\";\n      _this.messages = {\n        EMPTY: (0, _translate)(\"Empty Products\"),\n        NO_RESULTS: (0, _translate)(\"No products were found matching your condition\"),\n        LOADING: (0, _translate)(\"Loading...\"),\n        UNKNOWN_ERROR: (0, _translate)(\"An unknown error occurred. Please try again.\")\n      };\n      _this.ignoredKeysForBuild = [\"margins_and_padding\", \"border\", \"border_color\", \"border_radius\", \"border_width\", \"css_classes\", \"text_align\"];\n      _this.placeholderText = _knockout.observable(_this.messages.EMPTY); // Redraw slider after content type gets redrawn\n\n      _events.on(\"contentType:redrawAfter\", function (args) {\n        if (_this.element && _this.element.children) {\n          var $element = (0, _jquery)(_this.element.children);\n\n          if (args.element && $element.closest(args.element).length) {\n            $element.slick(\"setPosition\");\n          }\n        }\n      });\n\n      _events.on(\"stage:\" + _this.contentType.stageId + \":viewportChangeAfter\", function (args) {\n        var viewports = _config.getConfig(\"viewports\");\n\n        if (_this.element && _this.appearance() === \"carousel\") {\n          _this.slidesToShow = parseFloat(viewports[args.viewport].options.products.default.slidesToShow);\n\n          _this.destroySlider();\n\n          _this.initSlider();\n        }\n      });\n\n      return _this;\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * On afterRender callback.\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.onAfterRender = function onAfterRender(element) {\n      this.element = element;\n      this.previewElement.resolve(element);\n      this.initSlider();\n    }\n    /**\n     * @inheritdoc\n     */\n    ;\n\n    _proto.afterObservablesUpdated = function afterObservablesUpdated() {\n      var _this2 = this;\n\n      _preview2.prototype.afterObservablesUpdated.call(this);\n\n      var data = this.contentType.dataStore.getState();\n\n      if (this.hasDataChanged(this.previousData, data)) {\n        this.displayPreview(false);\n\n        if (typeof data.conditions_encoded !== \"string\" || data.conditions_encoded.length === 0) {\n          this.placeholderText(this.messages.EMPTY);\n          return;\n        }\n\n        var url = _config.getConfig(\"preview_url\");\n\n        var requestConfig = {\n          // Prevent caching\n          method: \"POST\",\n          data: {\n            role: this.config.name,\n            directive: this.data.main.html()\n          }\n        };\n        this.placeholderText(this.messages.LOADING);\n\n        _jquery.ajax(url, requestConfig).done(function (response) {\n          if (typeof response.data !== \"object\" || !Boolean(response.data.content)) {\n            _this2.placeholderText(_this2.messages.NO_RESULTS);\n\n            return;\n          }\n\n          if (response.data.error) {\n            _this2.widgetUnsanitizedHtml(response.data.error);\n          } else {\n            _this2.widgetUnsanitizedHtml(response.data.content);\n\n            _this2.displayPreview(true);\n          }\n\n          _this2.previewElement.done(function () {\n            (0, _jquery)(_this2.element).trigger(\"contentUpdated\");\n          });\n        }).fail(function () {\n          _this2.placeholderText(_this2.messages.UNKNOWN_ERROR);\n        });\n      }\n\n      this.previousData = Object.assign({}, data);\n    };\n\n    _proto.initSlider = function initSlider() {\n      if (this.element && this.appearance() === \"carousel\") {\n        (0, _jquery)(this.element.children).slick(this.buildSlickConfig());\n      }\n    };\n\n    _proto.destroySlider = function destroySlider() {\n      (0, _jquery)(this.element.children).slick(\"unslick\");\n    }\n    /**\n     * Build the slick config object\n     *\n     * @returns {{autoplay: boolean; autoplay: number; infinite: boolean; arrows: boolean; dots: boolean;\n     * centerMode: boolean; slidesToScroll: number; slidesToShow: number;}}\n     */\n    ;\n\n    _proto.buildSlickConfig = function buildSlickConfig() {\n      var attributes = this.data.main.attributes();\n      var productCount = (0, _jquery)(this.widgetUnsanitizedHtml()).find(this.productItemSelector).length;\n\n      var viewports = _config.getConfig(\"viewports\");\n\n      var currentViewport = this.viewport();\n      var carouselMode = attributes[\"data-carousel-mode\"];\n      var config = {\n        slidesToShow: this.slidesToShow,\n        slidesToScroll: this.slidesToShow,\n        dots: attributes[\"data-show-dots\"] === \"true\",\n        arrows: attributes[\"data-show-arrows\"] === \"true\",\n        autoplay: attributes[\"data-autoplay\"] === \"true\",\n        autoplaySpeed: parseFloat(attributes[\"data-autoplay-speed\"])\n      };\n      var slidesToShow = viewports[currentViewport].options.products[carouselMode] ? viewports[currentViewport].options.products[carouselMode].slidesToShow : viewports[currentViewport].options.products.default.slidesToShow;\n      config.slidesToShow = parseFloat(slidesToShow);\n\n      if (attributes[\"data-carousel-mode\"] === \"continuous\" && productCount > config.slidesToShow) {\n        config.centerPadding = attributes[\"data-center-padding\"];\n        config.centerMode = true;\n        (0, _jquery)(this.element).addClass(this.centerModeClass);\n      } else {\n        config.infinite = attributes[\"data-infinite-loop\"] === \"true\";\n        (0, _jquery)(this.element).removeClass(this.centerModeClass);\n      }\n\n      return config;\n    }\n    /**\n     * Determine if the data has changed, whilst ignoring certain keys which don't require a rebuild\n     *\n     * @param {DataObject} previousData\n     * @param {DataObject} newData\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.hasDataChanged = function hasDataChanged(previousData, newData) {\n      previousData = _underscore.omit(previousData, this.ignoredKeysForBuild);\n      newData = _underscore.omit(newData, this.ignoredKeysForBuild);\n      return !_underscore.isEqual(previousData, newData);\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/products/appearance/carousel/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'matchMedia',\n    'Magento_PageBuilder/js/utils/breakpoints',\n    'Magento_PageBuilder/js/events',\n    'slick'\n], function ($, _, mediaCheck, breakpointsUtils, events) {\n    'use strict';\n\n    /**\n     * Build slick\n     *\n     * @param {jQuery} $carouselElement\n     * @param {Object} config\n     */\n    function buildSlick($carouselElement, config) {\n        /**\n         * Prevent each slick slider from being initialized more than once which could throw an error.\n         */\n        if ($carouselElement.hasClass('slick-initialized')) {\n            $carouselElement.slick('unslick');\n        }\n\n        config.slidesToScroll = config.slidesToShow;\n        $carouselElement.slick(config);\n    }\n\n    /**\n     * Initialize slider.\n     *\n     * @param {jQuery} $element\n     * @param {Object} slickConfig\n     * @param {Object} breakpoint\n     */\n    function initSlider($element, slickConfig, breakpoint) {\n        var productCount = $element.find('.product-item').length,\n            $carouselElement = $($element.children()),\n            centerModeClass = 'center-mode',\n            carouselMode = $element.data('carousel-mode'),\n            slidesToShow = breakpoint.options.products[carouselMode] ?\n                breakpoint.options.products[carouselMode].slidesToShow :\n                breakpoint.options.products.default.slidesToShow;\n\n        slickConfig.slidesToShow = parseFloat(slidesToShow);\n\n        if (carouselMode === 'continuous' && productCount > slickConfig.slidesToShow) {\n            $element.addClass(centerModeClass);\n            slickConfig.centerPadding = $element.data('center-padding');\n            slickConfig.centerMode = true;\n        } else {\n            $element.removeClass(centerModeClass);\n            slickConfig.infinite = $element.data('infinite-loop');\n        }\n\n        buildSlick($carouselElement, slickConfig);\n    }\n\n    return function (config, element) {\n        var $element = $(element),\n            $carouselElement = $($element.children()),\n            currentViewport = config.currentViewport,\n            currentBreakpoint = config.breakpoints[currentViewport],\n            slickConfig = {\n                autoplay: $element.data('autoplay'),\n                autoplaySpeed: $element.data('autoplay-speed') || 0,\n                arrows: $element.data('show-arrows'),\n                dots: $element.data('show-dots')\n            };\n\n        _.each(config.breakpoints, function (breakpoint) {\n            mediaCheck({\n                media: breakpointsUtils.buildMedia(breakpoint.conditions),\n\n                /** @inheritdoc */\n                entry: function () {\n                    initSlider($element, slickConfig, breakpoint);\n                }\n            });\n        });\n\n        //initialize slider when content type is added in mobile viewport\n        if (currentViewport === 'mobile') {\n            initSlider($element, slickConfig, currentBreakpoint);\n        }\n\n        // Redraw slide after content type gets redrawn\n        events.on('contentType:redrawAfter', function (args) {\n            if ($carouselElement.closest(args.element).length) {\n                $carouselElement.slick('setPosition');\n            }\n        });\n\n        events.on('stage:viewportChangeAfter', function (args) {\n            var breakpoint = config.breakpoints[args.viewport];\n\n            initSlider($element, slickConfig, breakpoint);\n        });\n    };\n});\n","Magento_PageBuilder/js/content-type/products/form/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PageBuilder/js/form/provider',\n    'Magento_PageBuilder/js/form/provider/conditions-data-processor'\n], function (Provider, conditionsDataProcessor) {\n    'use strict';\n\n    return Provider.extend({\n        /** @inheritdoc **/\n        save: function () {\n            var data = this.get('data');\n\n            conditionsDataProcessor(data, data['condition_option'] + '_source');\n\n            return this._super();\n        }\n    });\n});\n","Magento_PageBuilder/js/content-type/products/mass-converter/carousel-widget-directive.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/mass-converter/widget-directive-abstract\", \"Magento_PageBuilder/js/utils/object\"], function (_widgetDirectiveAbstract, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var WidgetDirective = /*#__PURE__*/function (_widgetDirectiveAbstr) {\n    \"use strict\";\n\n    _inheritsLoose(WidgetDirective, _widgetDirectiveAbstr);\n\n    function WidgetDirective() {\n      return _widgetDirectiveAbstr.apply(this, arguments) || this;\n    }\n\n    var _proto = WidgetDirective.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var attributes = _widgetDirectiveAbstr.prototype.fromDom.call(this, data, config);\n\n      data.carousel_products_count = attributes.products_count;\n      data.sort_order = attributes.sort_order;\n      data.condition_option = attributes.condition_option || \"condition\";\n      data[data.condition_option] = this.decodeWysiwygCharacters(attributes.condition_option_value || \"\");\n      data.conditions_encoded = this.decodeWysiwygCharacters(attributes.conditions_encoded || \"\");\n      data[data.condition_option + \"_source\"] = data.conditions_encoded;\n      return data;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var attributes = {\n        type: \"Magento\\\\CatalogWidget\\\\Block\\\\Product\\\\ProductsList\",\n        template: \"Magento_PageBuilder::catalog/product/widget/content/carousel.phtml\",\n        anchor_text: \"\",\n        id_path: \"\",\n        show_pager: 0,\n        products_count: data.carousel_products_count,\n        condition_option: data.condition_option,\n        condition_option_value: \"\",\n        type_name: \"Catalog Products Carousel\",\n        conditions_encoded: this.encodeWysiwygCharacters(data.conditions_encoded || \"\")\n      };\n\n      if (data.sort_order) {\n        attributes.sort_order = data.sort_order;\n      }\n\n      if (typeof data[data.condition_option] === \"string\") {\n        attributes.condition_option_value = this.encodeWysiwygCharacters(data[data.condition_option]);\n      }\n\n      if (attributes.conditions_encoded.length === 0) {\n        return data;\n      }\n\n      (0, _object.set)(data, config.html_variable, this.buildDirective(attributes));\n      return data;\n    }\n    /**\n     * @param {string} content\n     * @returns {string}\n     */\n    ;\n\n    _proto.encodeWysiwygCharacters = function encodeWysiwygCharacters(content) {\n      return content.replace(/\\{/g, \"^[\").replace(/\\}/g, \"^]\").replace(/\"/g, \"`\").replace(/\\\\/g, \"|\").replace(/</g, \"&lt;\").replace(/>/g, \"&gt;\");\n    }\n    /**\n     * @param {string} content\n     * @returns {string}\n     */\n    ;\n\n    _proto.decodeWysiwygCharacters = function decodeWysiwygCharacters(content) {\n      return content.replace(/\\^\\[/g, \"{\").replace(/\\^\\]/g, \"}\").replace(/`/g, \"\\\"\").replace(/\\|/g, \"\\\\\").replace(/&lt;/g, \"<\").replace(/&gt;/g, \">\");\n    };\n\n    return WidgetDirective;\n  }(_widgetDirectiveAbstract);\n\n  return WidgetDirective;\n});\n//# sourceMappingURL=carousel-widget-directive.js.map","Magento_PageBuilder/js/content-type/products/mass-converter/widget-directive.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/mass-converter/widget-directive-abstract\", \"Magento_PageBuilder/js/utils/object\"], function (_widgetDirectiveAbstract, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var WidgetDirective = /*#__PURE__*/function (_widgetDirectiveAbstr) {\n    \"use strict\";\n\n    _inheritsLoose(WidgetDirective, _widgetDirectiveAbstr);\n\n    function WidgetDirective() {\n      return _widgetDirectiveAbstr.apply(this, arguments) || this;\n    }\n\n    var _proto = WidgetDirective.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var attributes = _widgetDirectiveAbstr.prototype.fromDom.call(this, data, config);\n\n      data.products_count = attributes.products_count;\n      data.sort_order = attributes.sort_order;\n      data.condition_option = attributes.condition_option || \"condition\";\n      data[data.condition_option] = this.decodeWysiwygCharacters(attributes.condition_option_value || \"\");\n      data.conditions_encoded = this.decodeWysiwygCharacters(attributes.conditions_encoded || \"\");\n      data[data.condition_option + \"_source\"] = data.conditions_encoded;\n      return data;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {object} data\n     * @param {object} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var attributes = {\n        type: \"Magento\\\\CatalogWidget\\\\Block\\\\Product\\\\ProductsList\",\n        template: \"Magento_CatalogWidget::product/widget/content/grid.phtml\",\n        anchor_text: \"\",\n        id_path: \"\",\n        show_pager: 0,\n        products_count: data.products_count,\n        condition_option: data.condition_option,\n        condition_option_value: \"\",\n        type_name: \"Catalog Products List\",\n        conditions_encoded: this.encodeWysiwygCharacters(data.conditions_encoded || \"\")\n      };\n\n      if (data.sort_order) {\n        attributes.sort_order = data.sort_order;\n      }\n\n      if (typeof data[data.condition_option] === \"string\") {\n        attributes.condition_option_value = this.encodeWysiwygCharacters(data[data.condition_option]);\n      }\n\n      if (attributes.conditions_encoded.length === 0) {\n        return data;\n      }\n\n      (0, _object.set)(data, config.html_variable, this.buildDirective(attributes));\n      return data;\n    }\n    /**\n     * @param {string} content\n     * @returns {string}\n     */\n    ;\n\n    _proto.encodeWysiwygCharacters = function encodeWysiwygCharacters(content) {\n      return content.replace(/\\{/g, \"^[\").replace(/\\}/g, \"^]\").replace(/\"/g, \"`\").replace(/\\\\/g, \"|\").replace(/</g, \"&lt;\").replace(/>/g, \"&gt;\");\n    }\n    /**\n     * @param {string} content\n     * @returns {string}\n     */\n    ;\n\n    _proto.decodeWysiwygCharacters = function decodeWysiwygCharacters(content) {\n      return content.replace(/\\^\\[/g, \"{\").replace(/\\^\\]/g, \"}\").replace(/`/g, \"\\\"\").replace(/\\|/g, \"\\\\\").replace(/&lt;/g, \"<\").replace(/&gt;/g, \">\");\n    };\n\n    return WidgetDirective;\n  }(_widgetDirectiveAbstract);\n\n  return WidgetDirective;\n});\n//# sourceMappingURL=widget-directive.js.map","Magento_PageBuilder/js/content-type/root-container/content-type-collection.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_Ui/js/modal/alert\", \"Magento_PageBuilder/js/content-type-collection\"], function (_alert, _contentTypeCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var RootContainer = /*#__PURE__*/function (_contentTypeCollectio) {\n    \"use strict\";\n\n    _inheritsLoose(RootContainer, _contentTypeCollectio);\n\n    function RootContainer() {\n      return _contentTypeCollectio.apply(this, arguments) || this;\n    }\n\n    var _proto = RootContainer.prototype;\n\n    /**\n     * Remove a child from the observable array\n     *\n     * @param child\n     */\n    _proto.removeChild = function removeChild(child) {\n      if (this.getChildren().length === 1) {\n        (0, _alert)({\n          content: $t(\"You are not able to remove the final row from the content.\"),\n          title: $t(\"Unable to Remove\")\n        });\n        return;\n      }\n\n      _contentTypeCollectio.prototype.removeChild.call(this, child);\n    };\n\n    return RootContainer;\n  }(_contentTypeCollection);\n\n  return RootContainer;\n});\n//# sourceMappingURL=content-type-collection.js.map","Magento_PageBuilder/js/content-type/row/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jarallax\", \"jarallaxVideo\", \"jquery\", \"knockout\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/resource/resize-observer/ResizeObserver\", \"underscore\", \"vimeoWrapper\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jarallax, _jarallaxVideo, _jquery, _knockout, _events, _ResizeObserver, _underscore, _vimeoWrapper, _hideShowOption, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * Debounce and defer the init of Jarallax\n     *\n     * @type {(() => void) & _.Cancelable}\n     */\n\n    /**\n     * @param {ContentTypeInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this;\n      _this.wrapClass = _knockout.observable(false);\n      _this.buildJarallax = _underscore.debounce(function () {\n        // Destroy all instances of the plugin prior\n        try {\n          jarallax(_this.element, \"destroy\");\n        } catch (e) {// Failure of destroying is acceptable\n        }\n\n        if (_this.element && (0, _jquery)(_this.element).hasClass(\"jarallax\") && _this.contentType.dataStore.get(\"background_type\") !== \"video\" && _this.contentType.dataStore.get(\"background_image\").length) {\n          _underscore.defer(function () {\n            // Build Parallax on elements with the correct class\n            var parallaxSpeed = Number.parseFloat(_this.contentType.dataStore.get(\"parallax_speed\"));\n            jarallax(_this.element, {\n              imgPosition: _this.contentType.dataStore.get(\"background_position\") || \"50% 50%\",\n              imgRepeat: _this.contentType.dataStore.get(\"background_repeat\") || \"no-repeat\",\n              imgSize: _this.contentType.dataStore.get(\"background_size\") || \"cover\",\n              speed: !isNaN(parallaxSpeed) ? parallaxSpeed : 0.5\n            });\n            jarallax(_this.element, \"onResize\");\n          });\n        }\n\n        if (_this.element && _this.element.dataset.backgroundType === \"video\" && _this.element.dataset.videoSrc.length) {\n          var parallaxSpeed = _this.contentType.dataStore.get(\"enable_parallax\") === \"1\" ? Number.parseFloat(_this.contentType.dataStore.get(\"parallax_speed\")) : 1;\n\n          _underscore.defer(function () {\n            // Build Parallax on elements with the correct class\n            jarallax(_this.element, {\n              videoSrc: _this.element.dataset.videoSrc,\n              imgSrc: _this.element.dataset.videoFallbackSrc,\n              videoLoop: _this.contentType.dataStore.get(\"video_loop\") === \"true\",\n              speed: !isNaN(parallaxSpeed) ? parallaxSpeed : 0.5,\n              videoPlayOnlyVisible: _this.contentType.dataStore.get(\"video_play_only_visible\") === \"true\",\n              videoLazyLoading: _this.contentType.dataStore.get(\"video_lazy_load\") === \"true\"\n            }); // @ts-ignore\n\n            if (_this.element.jarallax && _this.element.jarallax.video) {\n              // @ts-ignore\n              _this.element.jarallax.video.on(\"started\", function () {\n                // @ts-ignore\n                if (_this.element.jarallax.$video) {\n                  // @ts-ignore\n                  _this.element.jarallax.$video.style.visibility = \"visible\";\n                }\n              });\n            }\n          });\n        }\n      }, 50);\n\n      _this.contentType.dataStore.subscribe(_this.buildJarallax);\n\n      _events.on(\"row:mountAfter\", function (args) {\n        if (args.id === _this.contentType.id) {\n          _this.buildJarallax();\n        }\n      });\n\n      _events.on(\"contentType:mountAfter\", function (args) {\n        if (args.contentType.parentContentType && args.contentType.parentContentType.id === _this.contentType.id) {\n          _this.buildJarallax();\n        }\n      });\n\n      _events.on(\"stage:\" + _this.contentType.stageId + \":fullScreenModeChangeAfter\", _this.toggleFullScreen.bind(_assertThisInitialized(_this)));\n\n      _events.on(\"stage:\" + _this.contentType.stageId + \":viewportChangeAfter\", function (args) {\n        _this.buildJarallax();\n      });\n\n      return _this;\n    }\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * Toggle fullscreen\n     */\n    ;\n\n    _proto.toggleFullScreen = function toggleFullScreen() {\n      if ((0, _jquery)(this.element).hasClass(\"jarallax\")) {\n        this.buildJarallax();\n      }\n    }\n    /**\n     * Use the conditional remove to disable the option when the content type has a single child\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Init the parallax element\n     *\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.initParallax = function initParallax(element) {\n      var _this2 = this;\n\n      this.element = element;\n\n      _underscore.defer(function () {\n        _this2.buildJarallax();\n      });\n\n      new _ResizeObserver(function () {\n        // Observe for resizes of the element and force jarallax to display correctly\n        if ((0, _jquery)(_this2.element).hasClass(\"jarallax\") && _this2.contentType.dataStore.get(\"background_image\").length) {\n          jarallax(_this2.element, \"onResize\");\n          jarallax(_this2.element, \"onScroll\");\n        }\n      }).observe(this.element);\n    }\n    /**\n     * Destroy jarallax instance.\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      _previewCollection2.prototype.destroy.call(this);\n\n      if (this.element) {\n        jarallax(this.element, \"destroy\");\n      }\n    }\n    /**\n     * Return selected element styles\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyle = function getStyle(element, styleProperties) {\n      var stylesObject = element.style();\n      return styleProperties.reduce(function (obj, key) {\n        var _extends2;\n\n        return _extends({}, obj, (_extends2 = {}, _extends2[key] = stylesObject[key], _extends2));\n      }, {});\n    }\n    /**\n     * Return element styles without selected\n     *\n     * @param element\n     * @param styleProperties\n     */\n    ;\n\n    _proto.getStyleWithout = function getStyleWithout(element, styleProperties) {\n      var stylesObject = element.style();\n      return Object.keys(stylesObject).filter(function (key) {\n        return !styleProperties.includes(key);\n      }).reduce(function (obj, key) {\n        var _extends3;\n\n        return _extends({}, obj, (_extends3 = {}, _extends3[key] = stylesObject[key], _extends3));\n      }, {});\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/row/appearance/default/widget-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(['underscore', 'jquery', 'Magento_PageBuilder/js/events'], function (_, $, events) {\n    'use strict';\n\n    return function (target) {\n        return function (config, element) {\n            var result = target(config, element),\n                stageId = $(element).parents('[data-role=\"pagebuilder-stage\"]').attr('id'),\n                $element = $(element);\n\n            if ($element.data('appearance') === 'contained') {\n                $element = $(element).find('[data-element=\"inner\"]');\n            }\n\n            // If Parallax isn't enabled, let's not attach the event\n            if ($element.data('enableParallax') !== 1) {\n                return result;\n            }\n\n            // Listen for full screen events and destroy and rebuild jarallax\n            events.on('stage:' + stageId + ':fullScreenModeChangeAfter', function () {\n                _.delay(function () {\n                    $element.jarallax('destroy');\n                    target(config, element);\n                }, 350);\n            });\n\n            return result;\n        };\n    };\n});\n","Magento_PageBuilder/js/content-type/row/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/widget/video-background',\n    'jarallax'\n], function ($, videoBackground) {\n    'use strict';\n\n    return function (config, element) {\n        var $element = $(element),\n            parallaxSpeed = null,\n            elementStyle = null;\n\n        if ($element.data('appearance') === 'contained') {\n            $element = $(element).find('[data-element=\"inner\"]');\n        }\n\n        if ($element.data('background-type') === 'video') {\n            videoBackground(config, $element[0]);\n\n            return;\n        }\n\n        if ($element.data('enableParallax') !== 1) {\n            return;\n        }\n\n        $element.addClass('jarallax');\n        $element.attr('data-jarallax', '');\n\n        parallaxSpeed = parseFloat($element.data('parallaxSpeed'));\n        elementStyle = window.getComputedStyle($element[0]);\n\n        window.jarallax($element[0], {\n            imgPosition: elementStyle.backgroundPosition || '50% 50%',\n            imgRepeat: elementStyle.backgroundRepeat || 'no-repeat',\n            imgSize: elementStyle.backgroundSize || 'cover',\n            speed: !isNaN(parallaxSpeed) ? parallaxSpeed : 0.5\n        });\n    };\n});\n","Magento_PageBuilder/js/content-type/row/converter/style/margins.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Margins = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Margins() {}\n\n    var _proto = Margins.prototype;\n\n    /**\n     * @param {string} value\n     * @returns {Object | string}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.margin) {\n        result.marginLeft = value.margin.left ? value.margin.left + \"px\" : \"\";\n        result.marginTop = value.margin.top ? value.margin.top + \"px\" : \"\";\n        result.marginRight = value.margin.right ? value.margin.right + \"px\" : \"\";\n        result.marginBottom = (parseInt(value.margin.bottom, 10) > 0 ? value.margin.bottom : 1) + \"px\";\n      }\n\n      return result;\n    };\n\n    return Margins;\n  }();\n\n  return Margins;\n});\n//# sourceMappingURL=margins.js.map","Magento_PageBuilder/js/content-type/row/converter/style/paddings.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Paddings = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Paddings() {}\n\n    var _proto = Paddings.prototype;\n\n    /**\n     * @param {string} value\n     * @returns {Object | string}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.padding) {\n        result.paddingLeft = value.padding.left ? value.padding.left + \"px\" : \"\";\n        result.paddingTop = value.padding.top ? value.padding.top + \"px\" : \"\";\n        result.paddingRight = value.padding.right ? value.padding.right + \"px\" : \"\";\n        result.paddingBottom = value.padding.bottom ? value.padding.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Paddings;\n  }();\n\n  return Paddings;\n});\n//# sourceMappingURL=paddings.js.map","Magento_PageBuilder/js/content-type/slide/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jarallax\", \"jarallaxVideo\", \"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"mageUtils\", \"underscore\", \"vimeoWrapper\", \"Magento_PageBuilder/js/content-type-menu/conditional-remove-option\", \"Magento_PageBuilder/js/uploader\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/utils/nesting-link-dialog\", \"Magento_PageBuilder/js/utils/nesting-widget-dialog\", \"Magento_PageBuilder/js/wysiwyg/factory\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jarallax, _jarallaxVideo, _jquery, _knockout, _translate, _events, _mageUtils, _underscore, _vimeoWrapper, _conditionalRemoveOption, _uploader, _delayUntil, _editor, _nestingLinkDialog, _nestingWidgetDialog, _factory, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.buttonPlaceholder = (0, _translate)(\"Edit Button Text\");\n      _this.slideName = _knockout.observable();\n      _this.wysiwygDeferred = _jquery.Deferred();\n      _this.slideChanged = true;\n      _this.handledDoubleClick = false;\n      _this.videoUpdateProperties = [\"background_type\", \"video_fallback_image\", \"video_lazy_load\", \"video_loop\", \"video_play_only_visible\", \"video_source\"];\n      _this.buildJarallax = _underscore.debounce(function () {\n        // Destroy all instances of the plugin prior\n        try {\n          jarallax(_this.wrapper, \"destroy\");\n        } catch (e) {// Failure of destroying is acceptable\n        }\n\n        if (_this.wrapper && _this.wrapper.dataset.backgroundType === \"video\" && _this.wrapper.dataset.videoSrc.length) {\n          _underscore.defer(function () {\n            // Build Parallax on elements with the correct class\n            var viewportElement = (0, _jquery)(\"<div/>\").addClass(\"jarallax-viewport-element\");\n            (0, _jquery)(_this.wrapper).append((0, _jquery)(\".jarallax-viewport-element\", _this.wrapper).length ? \"\" : viewportElement);\n            jarallax(_this.wrapper, {\n              videoSrc: _this.wrapper.dataset.videoSrc,\n              imgSrc: _this.wrapper.dataset.videoFallbackSrc,\n              videoLoop: _this.contentType.dataStore.get(\"video_loop\") === \"true\",\n              speed: 1,\n              videoPlayOnlyVisible: _this.contentType.dataStore.get(\"video_play_only_visible\") === \"true\",\n              elementInViewport: (0, _jquery)(\".jarallax-viewport-element\", _this.wrapper),\n              videoLazyLoading: _this.contentType.dataStore.get(\"video_lazy_load\") === \"true\"\n            }); // @ts-ignore\n\n            if (_this.wrapper.jarallax && _this.wrapper.jarallax.video) {\n              // @ts-ignore\n              _this.wrapper.jarallax.video.on(\"started\", function () {\n                // @ts-ignore\n                if (_this.wrapper.jarallax && _this.wrapper.jarallax.$video) {\n                  // @ts-ignore\n                  _this.wrapper.jarallax.$video.style.visibility = \"visible\";\n                }\n              });\n            }\n          });\n        }\n      }, 50);\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.afterRenderWysiwyg = function afterRenderWysiwyg(element) {\n      var _this2 = this;\n\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\"; // Set the innerHTML manually so we don't upset Knockout & TinyMCE\n\n      element.innerHTML = this.data.content.html();\n      this.contentType.dataStore.subscribe(function () {\n        // If we're not focused into TinyMCE inline, update the value when it changes in the data store\n        if (!_this2.wysiwyg || _this2.wysiwyg && _this2.wysiwyg.getAdapter().id !== (0, _editor.getActiveEditor)().id) {\n          element.innerHTML = _this2.data.content.html();\n        }\n      }, \"content\");\n      /**\n       * afterRenderWysiwyg is called whenever Knockout causes a DOM re-render. This occurs frequently within Slider\n       * due to Slick's inability to perform a refresh with Knockout managing the DOM. Due to this the original\n       * WYSIWYG instance will be detached from this slide and we need to re-initialize on click.\n       */\n\n      this.wysiwyg = null;\n    }\n    /**\n     * Set state based on overlay mouseover event for the preview\n     */\n    ;\n\n    _proto.onMouseOverWrapper = function onMouseOverWrapper() {\n      // Triggers the visibility of the overlay content to show\n      if (this.data.main.attributes()[\"data-show-overlay\"] === \"hover\") {\n        this.data.overlay.attributes(Object.assign(this.data.overlay.attributes(), {\n          \"data-background-color-orig\": this.data.overlay.style().backgroundColor\n        }));\n        this.data.overlay.style(Object.assign(this.data.overlay.style(), {\n          backgroundColor: this.data.overlay.attributes()[\"data-overlay-color\"]\n        }));\n      }\n\n      if (this.data.main.attributes()[\"data-show-button\"] === \"hover\") {\n        this.data.button.style(Object.assign(this.data.button.style(), {\n          opacity: 1,\n          visibility: \"visible\"\n        }));\n      }\n    }\n    /**\n     * Set state based on overlay mouseout event for the preview\n     */\n    ;\n\n    _proto.onMouseOutWrapper = function onMouseOutWrapper() {\n      // Triggers the visibility of the overlay content to hide\n      if (this.data.main.attributes()[\"data-show-overlay\"] === \"hover\") {\n        this.data.overlay.style(Object.assign(this.data.overlay.style(), {\n          backgroundColor: this.data.overlay.attributes()[\"data-background-color-orig\"]\n        }));\n      }\n\n      if (this.data.main.attributes()[\"data-show-button\"] === \"hover\") {\n        this.data.button.style(Object.assign(this.data.button.style(), {\n          opacity: 0,\n          visibility: \"hidden\"\n        }));\n      }\n    }\n    /**\n     * Get the options instance\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      delete options.move;\n      options.remove = new _conditionalRemoveOption(_extends({}, options.remove.config, {\n        preview: this\n      }));\n      return options;\n    }\n    /**\n     * Get registry callback reference to uploader UI component\n     *\n     * @returns {Uploader}\n     */\n    ;\n\n    _proto.getUploader = function getUploader() {\n      var initialImageValue = this.contentType.dataStore.get(this.config.additional_data.uploaderConfig.dataScope, \"\"); // Create uploader\n\n      return new _uploader(\"imageuploader_\" + this.contentType.id, this.config.additional_data.uploaderConfig, this.contentType.id, this.contentType.dataStore, initialImageValue);\n    }\n    /**\n     * Makes WYSIWYG active\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.activateEditor = function activateEditor(preview, event) {\n      var _this3 = this;\n\n      if (this.element && !this.wysiwyg) {\n        var bookmark = (0, _editor.createBookmark)(event);\n        (0, _editor.lockImageSize)(this.element);\n        this.element.removeAttribute(\"contenteditable\");\n\n        _underscore.defer(function () {\n          _this3.initWysiwygFromClick(true).then(function () {\n            return (0, _delayUntil)(function () {\n              // We no longer need to handle double click once it's initialized\n              _this3.handledDoubleClick = true;\n\n              _this3.wysiwygDeferred.resolve();\n\n              (0, _editor.moveToBookmark)(bookmark);\n              (0, _editor.unlockImageSize)(_this3.element);\n            }, function () {\n              return _this3.element.classList.contains(\"mce-edit-focus\");\n            }, 10);\n          }).catch(function (error) {\n            // If there's an error with init of WYSIWYG editor push into the console to aid support\n            console.error(error);\n          });\n        });\n      } else if (this.element && this.wysiwyg) {\n        var element = this.element || this.textarea;\n\n        if (event.currentTarget !== event.target && event.target !== element && !element.contains(event.target)) {\n          return;\n        }\n\n        element.focus();\n      }\n    }\n    /**\n     * If a user double clicks prior to initializing TinyMCE, forward the event\n     *\n     * @param preview\n     * @param event\n     */\n    ;\n\n    _proto.handleDoubleClick = function handleDoubleClick(preview, event) {\n      var _this4 = this;\n\n      if (this.handledDoubleClick) {\n        return;\n      }\n\n      event.preventDefault();\n      var targetIndex = (0, _editor.findNodeIndex)(this.element, event.target.tagName, event.target);\n      this.handledDoubleClick = true;\n      this.wysiwygDeferred.then(function () {\n        var target = document.getElementById(event.target.id);\n\n        if (!target) {\n          target = (0, _editor.getNodeByIndex)(_this4.element, event.target.tagName, targetIndex);\n        }\n\n        if (target) {\n          target.dispatchEvent((0, _editor.createDoubleClickEvent)());\n        }\n      });\n    }\n    /**\n     * Stop event to prevent execution of action when editing textarea.\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.stopEvent = function stopEvent(preview, event) {\n      event.stopPropagation();\n      return true;\n    }\n    /**\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.isWysiwygSupported = function isWysiwygSupported() {\n      return (0, _editor.isWysiwygSupported)();\n    }\n    /**\n     * @param {HTMLTextAreaElement} element\n     */\n    ;\n\n    _proto.initTextarea = function initTextarea(element) {\n      var _this5 = this;\n\n      this.textarea = element; // set initial value of textarea based on data store\n\n      this.textarea.value = this.contentType.dataStore.get(\"content\");\n      this.adjustTextareaHeightBasedOnScrollHeight(); // Update content in our stage preview textarea after its slideout counterpart gets updated\n\n      _events.on(\"form:\" + this.contentType.id + \":saveAfter\", function () {\n        _this5.textarea.value = _this5.contentType.dataStore.get(\"content\");\n\n        _this5.adjustTextareaHeightBasedOnScrollHeight();\n      });\n    }\n    /**\n     * Save current value of textarea in data store\n     */\n    ;\n\n    _proto.onTextareaKeyUp = function onTextareaKeyUp() {\n      this.adjustTextareaHeightBasedOnScrollHeight();\n      this.contentType.dataStore.set(\"content\", this.textarea.value);\n    }\n    /**\n     * Start stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaFocus = function onTextareaFocus() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-content-type\").addClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStart\");\n    }\n    /**\n     * Stop stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaBlur = function onTextareaBlur() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-content-type\").removeClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStop\");\n    }\n    /**\n     * Init WYSIWYG on load\n     *\n     * @param element\n     * @deprecated please use activateEditor & initWysiwygFromClick\n     */\n    ;\n\n    _proto.initWysiwyg = function initWysiwyg(element) {\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\";\n      this.wysiwyg = null;\n      return this.initWysiwygFromClick(true);\n    }\n    /**\n     * Init the WYSIWYG\n     *\n     * @param {boolean} focus Should wysiwyg focus after initialization?\n     * @returns Promise\n     */\n    ;\n\n    _proto.initWysiwygFromClick = function initWysiwygFromClick(focus) {\n      var _this6 = this;\n\n      if (focus === void 0) {\n        focus = false;\n      }\n\n      if (this.wysiwyg) {\n        return Promise.resolve(this.wysiwyg);\n      }\n\n      var wysiwygConfig = this.config.additional_data.wysiwygConfig.wysiwygConfigData;\n\n      if (focus) {\n        wysiwygConfig.adapter.settings.auto_focus = this.element.id;\n\n        wysiwygConfig.adapter.settings.init_instance_callback = function (editor) {\n          editor.on(\"blur\", function () {\n            (0, _nestingLinkDialog)(_this6.contentType.dataStore, _this6.wysiwyg, \"content\", \"link_url\");\n            (0, _nestingWidgetDialog)(_this6.contentType.dataStore, _this6.wysiwyg, \"content\", \"link_url\");\n          });\n\n          _underscore.defer(function () {\n            _this6.element.blur();\n\n            _this6.element.focus();\n          });\n        };\n      }\n\n      return (0, _factory)(this.contentType.id, this.element.id, this.config.name, wysiwygConfig, this.contentType.dataStore, \"content\", this.contentType.stageId).then(function (wysiwyg) {\n        _this6.wysiwyg = wysiwyg;\n        return wysiwyg;\n      });\n    }\n    /**\n     * Init the parallax element\n     *\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.initParallax = function initParallax(element) {\n      var _this7 = this;\n\n      this.wrapper = element;\n\n      _underscore.defer(function () {\n        _this7.buildJarallax();\n      });\n    }\n    /**\n     * Destroy jarallax instance.\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      _preview2.prototype.destroy.call(this);\n\n      if (this.wrapper) {\n        jarallax(this.wrapper, \"destroy\");\n      }\n    }\n    /**\n     * @inheritDoc\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this8 = this;\n\n      _preview2.prototype.bindEvents.call(this);\n\n      _events.on(\"slide:mountAfter\", function (args) {\n        if (args.id === _this8.contentType.id) {\n          _this8.buildJarallax();\n\n          _this8.isSnapshot.subscribe(function (value) {\n            _this8.changeUploaderControlsVisibility();\n          });\n\n          _this8.changeUploaderControlsVisibility();\n        }\n      });\n\n      _events.on(this.config.name + \":\" + this.contentType.id + \":updateAfter\", function () {\n        var dataStore = _this8.contentType.dataStore.getState();\n\n        var imageObject = dataStore[_this8.config.additional_data.uploaderConfig.dataScope][0] || {};\n\n        _events.trigger(\"image:\" + _this8.contentType.id + \":assignAfter\", imageObject);\n      }); // Remove wysiwyg before assign new instance.\n\n\n      _events.on(\"childContentType:sortUpdate\", function (args) {\n        if (args.instance.id === _this8.contentType.parentContentType.id) {\n          _this8.wysiwyg = null;\n        }\n      });\n\n      _events.on(this.config.name + \":mountAfter\", function (args) {\n        if (args.id === _this8.contentType.id) {\n          // Update the display label for the slide\n          var slider = _this8.contentType.parentContentType;\n\n          _this8.displayLabel((0, _translate)(\"Slide \" + (slider.children().indexOf(_this8.contentType) + 1)));\n\n          slider.children.subscribe(function (children) {\n            var index = children.indexOf(_this8.contentType);\n\n            _this8.displayLabel((0, _translate)(\"Slide \" + (slider.children().indexOf(_this8.contentType) + 1)));\n          });\n        }\n      });\n\n      _events.on(this.config.name + \":renderAfter\", function (args) {\n        if (args.id === _this8.contentType.id) {\n          var slider = _this8.contentType.parentContentType;\n          (0, _jquery)(slider.preview.element).on(\"beforeChange\", function () {\n            _this8.slideChanged = false;\n          });\n          (0, _jquery)(slider.preview.element).on(\"afterChange\", function (event, slick) {\n            (0, _jquery)(slick.$slides).each(function (index, slide) {\n              var videoSlide = slide.querySelector(\".jarallax\");\n\n              if (videoSlide) {\n                jarallax(videoSlide, \"onScroll\");\n              }\n            });\n            _this8.slideChanged = true;\n          });\n        }\n      });\n\n      this.contentType.dataStore.subscribe(function (data) {\n        _this8.slideName(data.slide_name);\n\n        if (_this8.shouldUpdateVideo(data)) {\n          _this8.buildJarallax();\n        }\n      });\n\n      _events.on(\"image:\" + this.contentType.id + \":uploadAfter\", function () {\n        _this8.contentType.dataStore.set(\"background_type\", \"image\");\n      });\n\n      _events.on(\"stage:\" + this.contentType.stageId + \":viewportChangeAfter\", function (args) {\n        if (_this8.contentType.dataStore.get(\"background_type\") === \"video\") {\n          _this8.buildJarallax();\n        }\n      });\n    }\n    /**\n     * Change uploader controls visibility\n     */\n    ;\n\n    _proto.changeUploaderControlsVisibility = function changeUploaderControlsVisibility() {\n      var _this9 = this;\n\n      this.getUploader().getUiComponent()(function (uploader) {\n        uploader.visibleControls = !_this9.isSnapshot();\n      });\n    }\n    /**\n     * Update image data inside data store\n     *\n     * @param {Array} data - list of each files' data\n     */\n    ;\n\n    _proto.onImageUploaded = function onImageUploaded(data) {\n      this.contentType.dataStore.set(this.config.additional_data.uploaderConfig.dataScope, data);\n    }\n    /**\n     * Adjust textarea's height based on scrollHeight\n     */\n    ;\n\n    _proto.adjustTextareaHeightBasedOnScrollHeight = function adjustTextareaHeightBasedOnScrollHeight() {\n      this.textarea.style.height = \"\";\n      var scrollHeight = this.textarea.scrollHeight;\n      var minHeight = parseInt((0, _jquery)(this.textarea).css(\"min-height\"), 10);\n\n      if (scrollHeight === minHeight) {\n        // leave height at 'auto'\n        return;\n      }\n\n      (0, _jquery)(this.textarea).height(scrollHeight);\n    }\n    /**\n     * Check if video options has been updated.\n     *\n     * @return boolean\n     */\n    ;\n\n    _proto.shouldUpdateVideo = function shouldUpdateVideo(state) {\n      var _this10 = this;\n\n      var previousState = this.contentType.dataStore.getPreviousState();\n\n      var diff = _mageUtils.compare(previousState, state).changes;\n\n      if (diff.length > 0) {\n        return _underscore.some(diff, function (element) {\n          if (element.name === \"video_fallback_image\") {\n            return (!_underscore.isEmpty(previousState.video_fallback_image) && previousState.video_fallback_image) !== (!_underscore.isEmpty(state.video_fallback_image) && state.video_fallback_image);\n          }\n\n          return _this10.videoUpdateProperties.indexOf(element.name) !== -1;\n        });\n      }\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/slide/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_PageBuilder/js/widget/show-on-hover',\n    'Magento_PageBuilder/js/widget/video-background'\n], function ($, _, showOnHover, videoBackground) {\n    'use strict';\n\n    return function (config, element) {\n        var videoElement = element[0].querySelector('[data-background-type=video]'),\n            viewportElement = document.createElement('div'),\n            $slider = null;\n\n        showOnHover(config);\n\n        if (videoElement) {\n            $slider = $(element).closest('[data-content-type=slider]');\n            viewportElement.classList.add('jarallax-viewport-element');\n            videoElement.setAttribute('data-element-in-viewport', '.jarallax-viewport-element');\n            videoElement.appendChild(viewportElement);\n            videoBackground(config, videoElement);\n\n            if ($slider.data('afterChangeIsSet')) {\n                return;\n            }\n\n            $slider.on('afterChange init', function () {\n                var videoSlides = $slider[0].querySelectorAll('.jarallax');\n\n                _.each(videoSlides, function (videoSlide) {\n                    videoSlide.jarallax && videoSlide.jarallax.onScroll();\n                });\n            });\n            $slider.data('afterChangeIsSet', true);\n        }\n    };\n});\n","Magento_PageBuilder/js/content-type/slide/converter/attribute/overlay-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var OverlayColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayColor() {}\n\n    var _proto = OverlayColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value === \"transparent\" ? \"\" : value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      if (data.overlay_color) {\n        return data.overlay_color.toString();\n      }\n\n      return \"\";\n    };\n\n    return OverlayColor;\n  }();\n\n  return OverlayColor;\n});\n//# sourceMappingURL=overlay-color.js.map","Magento_PageBuilder/js/content-type/slide/converter/style/button-opacity.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ButtonOpacity = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ButtonOpacity() {}\n\n    var _proto = ButtonOpacity.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return data.show_button === \"always\" ? \"1\" : \"0\";\n    };\n\n    return ButtonOpacity;\n  }();\n\n  return ButtonOpacity;\n});\n//# sourceMappingURL=button-opacity.js.map","Magento_PageBuilder/js/content-type/slide/converter/style/button-visibility.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ButtonVisibility = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ButtonVisibility() {}\n\n    var _proto = ButtonVisibility.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return data.show_button === \"always\" ? \"visible\" : \"hidden\";\n    };\n\n    return ButtonVisibility;\n  }();\n\n  return ButtonVisibility;\n});\n//# sourceMappingURL=button-visibility.js.map","Magento_PageBuilder/js/content-type/slide/converter/style/margins.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Margins = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Margins() {}\n\n    var _proto = Margins.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (undefined !== value.margin) {\n        return {\n          margin: {\n            top: value.margin.top.replace(\"px\", \"\"),\n            left: value.margin.left.replace(\"px\", \"\"),\n            right: value.margin.right.replace(\"px\", \"\"),\n            bottom: value.margin.bottom.replace(\"px\", \"\")\n          }\n        };\n      }\n\n      return {};\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.margin) {\n        result.marginLeft = value.margin.left ? value.margin.left + \"px\" : \"\";\n        result.marginTop = value.margin.top ? value.margin.top + \"px\" : \"\";\n        result.marginRight = value.margin.right ? value.margin.right + \"px\" : \"\";\n        result.marginBottom = value.margin.bottom ? value.margin.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Margins;\n  }();\n\n  return Margins;\n});\n//# sourceMappingURL=margins.js.map","Magento_PageBuilder/js/content-type/slide/converter/style/overlay-background-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var OverlayBackgroundColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayBackgroundColor() {}\n\n    var _proto = OverlayBackgroundColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (data.show_overlay === \"always\" && value !== \"\" && value !== undefined) {\n        return value;\n      }\n\n      return \"transparent\";\n    };\n\n    return OverlayBackgroundColor;\n  }();\n\n  return OverlayBackgroundColor;\n});\n//# sourceMappingURL=overlay-background-color.js.map","Magento_PageBuilder/js/content-type/slide/converter/style/paddings.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Paddings = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Paddings() {}\n\n    var _proto = Paddings.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      var result = {};\n\n      if (undefined !== value.padding) {\n        result.padding = {\n          bottom: value.padding.bottom.replace(\"px\", \"\"),\n          left: value.padding.left.replace(\"px\", \"\"),\n          right: value.padding.right.replace(\"px\", \"\"),\n          top: value.padding.top.replace(\"px\", \"\")\n        };\n      }\n\n      if (result.padding.right[0] === \"c\") {\n        result.padding.right = parseInt(result.padding.right.split(\"+\")[1].trim(), 10);\n      }\n\n      if (result.padding.left[0] === \"c\") {\n        result.padding.left = parseInt(result.padding.left.split(\"+\")[1].trim(), 10);\n      }\n\n      return result;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.padding) {\n        result.paddingLeft = value.padding.left ? value.padding.left + \"px\" : \"\";\n        result.paddingTop = value.padding.top ? value.padding.top + \"px\" : \"\";\n        result.paddingRight = value.padding.right ? value.padding.right + \"px\" : \"\";\n        result.paddingBottom = value.padding.bottom ? value.padding.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Paddings;\n  }();\n\n  return Paddings;\n});\n//# sourceMappingURL=paddings.js.map","Magento_PageBuilder/js/content-type/slide/wysiwyg/tinymce/component-initializer.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/adminhtml/wysiwyg/events\", \"Magento_PageBuilder/js/utils/delay-until\"], function (_jquery, _events, _delayUntil) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ComponentInitializer = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ComponentInitializer() {\n      this.sliderSelector = \".slick-list\";\n      this.sliderContentSelector = \".slick-track\";\n      this.slideSelector = \".slick-slide\";\n      this.activeSlideSelector = \".slick-current\";\n      this.slideChanging = false;\n    }\n\n    var _proto = ComponentInitializer.prototype;\n\n    /**\n     * Initialize the instance\n     *\n     * @param {Wysiwyg} wysiwyg\n     */\n    _proto.initialize = function initialize(wysiwyg) {\n      var _this = this;\n\n      this.$element = (0, _jquery)(\"#\" + wysiwyg.elementId);\n      this.config = wysiwyg.config;\n      var tinymce = wysiwyg.getAdapter();\n      tinymce.eventBus.attachEventHandler(_events.afterFocus, this.onFocus.bind(this));\n      tinymce.eventBus.attachEventHandler(_events.afterBlur, this.onBlur.bind(this)); // Update our KO pointer to the active slide on change\n\n      (0, _jquery)(this.$element.parents(this.sliderSelector)).parent().on(\"beforeChange\", function () {\n        _this.slideChanging = true;\n      }).on(\"afterChange\", function () {\n        _this.slideChanging = false;\n      });\n    }\n    /**\n     * Event handler for wysiwyg focus\n     * Fixes z-index issues for tabs and column\n     * Fixes slider\n     */\n    ;\n\n    _proto.onFocus = function onFocus() {\n      var _this2 = this;\n\n      var $slider = (0, _jquery)(this.$element.parents(this.sliderSelector));\n      var sliderContent = this.$element.parents(this.sliderContentSelector)[0];\n      var $notActiveSlides = $slider.find(this.slideSelector).not(this.activeSlideSelector); // If there isn't enough room for a left-aligned toolbar, right align it\n\n      if ((0, _jquery)(window).width() < this.$element.offset().left + parseInt(this.config.adapter_config.minToolbarWidth, 10)) {\n        this.$element.addClass(\"_right-aligned-toolbar\");\n      } else {\n        this.$element.removeClass(\"_right-aligned-toolbar\");\n      }\n\n      (0, _delayUntil)(function () {\n        _jquery.each(_this2.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n          _this2.$element.closest(selector).css(\"z-index\", 100);\n        }); // Disable slider keyboard events and fix problem with overflow hidden issue\n\n\n        $slider.parent().slick(\"slickSetOption\", \"accessibility\", false);\n        _this2.autoplay = $slider.parent().slick(\"slickGetOption\", \"autoplay\");\n        _this2.fade = $slider.parent().slick(\"slickGetOption\", \"fade\");\n\n        if (_this2.autoplay) {\n          $slider.parent().slick(\"slickPause\");\n        }\n\n        if (!_this2.fade) {\n          $notActiveSlides.css(\"display\", \"none\");\n        }\n\n        _this2.sliderTransform = sliderContent.style.transform;\n        sliderContent.style.transform = \"\";\n        $slider.css(\"overflow\", \"visible\");\n      }, function () {\n        return !_this2.slideChanging;\n      }, 10);\n    }\n    /**\n     * Event handler for wysiwyg blur\n     * Fixes z-index issues for tabs and column\n     * Fixes slider\n     */\n    ;\n\n    _proto.onBlur = function onBlur() {\n      var _this3 = this;\n\n      var $slider = (0, _jquery)(this.$element.parents(this.sliderSelector));\n      var sliderContent = this.$element.parents(this.sliderContentSelector)[0];\n      var $notActiveSlides = $slider.find(this.slideSelector).not(this.activeSlideSelector);\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this3.$element.closest(selector).css(\"z-index\", \"\");\n      }); // Enable slider keyboard events and revert changes made in onFocus\n\n\n      $slider.css(\"overflow\", \"hidden\");\n      sliderContent.style.transform = this.sliderTransform;\n      $notActiveSlides.css(\"display\", \"block\");\n      $slider.parent().slick(\"slickSetOption\", \"accessibility\", true);\n\n      if (this.autoplay) {\n        $slider.parent().slick(\"slickPlay\");\n      }\n    };\n\n    return ComponentInitializer;\n  }();\n\n  return ComponentInitializer;\n});\n//# sourceMappingURL=component-initializer.js.map","Magento_PageBuilder/js/content-type/slide/wysiwyg/tinymce/config-modifier.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ConfigModifier = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ConfigModifier() {}\n\n    var _proto = ConfigModifier.prototype;\n\n    /**\n     * Initialize the config\n     *\n     * @param {String} contentTypeId\n     * @param {Object} config\n     */\n    _proto.modify = function modify(contentTypeId, config) {\n      if (config.adapter_config.mode === \"inline\") {\n        config.adapter.settings.fixed_toolbar_container = \"#\" + contentTypeId + \" .wysiwyg-container\";\n      }\n    };\n\n    return ConfigModifier;\n  }();\n\n  return ConfigModifier;\n});\n//# sourceMappingURL=config-modifier.js.map","Magento_PageBuilder/js/content-type/slider/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"slick\", \"underscore\", \"Magento_PageBuilder/js/binding/focus\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type-menu/option\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/promise-deferred\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jquery, _knockout, _translate, _events, _slick, _underscore, _focus, _config, _contentTypeFactory, _hideShowOption, _option, _delayUntil, _promiseDeferred, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * Define keys which when changed should not trigger the slider to be rebuilt\n     *\n     * @type {string[]}\n     */\n\n    /**\n     * @param {ContentTypeCollectionInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this; // Wait for the tabs instance to mount and the container to be ready\n\n      _this.focusedSlide = _knockout.observable();\n      _this.activeSlide = _knockout.observable(0);\n      _this.events = {\n        columnWidthChangeAfter: \"onColumnResize\"\n      };\n      _this.ready = false;\n      _this.mountAfterDeferred = (0, _promiseDeferred)();\n      _this.afterChildrenRenderDeferred = (0, _promiseDeferred)();\n      _this.buildSlickDebounce = _underscore.debounce(_this.buildSlick.bind(_assertThisInitialized(_this)), 10);\n      _this.ignoredKeysForBuild = [\"display\", \"margins_and_padding\", \"border\", \"border_color\", \"border_radius\", \"border_width\", \"css_classes\", \"name\", \"text_align\"];\n      Promise.all([_this.afterChildrenRenderDeferred.promise, _this.mountAfterDeferred.promise]).then(function (_ref) {\n        var element = _ref[0],\n            expectedChildren = _ref[1];\n        // We always create 1 tab when dropping tabs into the instance\n        expectedChildren = expectedChildren || 1; // Wait until all children's DOM elements are present before building the tabs instance\n\n        (0, _delayUntil)(function () {\n          _this.element = element;\n          _this.childSubscribe = _this.contentType.children.subscribe(_this.buildSlickDebounce);\n          _this.previousData = _this.contentType.dataStore.getState();\n\n          _this.contentType.dataStore.subscribe(function (data) {\n            if (_this.hasDataChanged(_this.previousData, data)) {\n              _this.buildSlickDebounce();\n            }\n\n            _this.previousData = data;\n          });\n\n          _this.buildSlick(); // Redraw slide after content type gets redrawn\n\n\n          _events.on(\"contentType:redrawAfter\", function (args) {\n            var $element = (0, _jquery)(_this.element);\n\n            if (args.element && _this.element && $element.closest(args.element).length) {\n              $element.slick(\"setPosition\");\n            }\n          }); // Set the stage to interacting when a slide is focused\n\n\n          _this.focusedSlideSubscriber = _this.focusedSlide.subscribe(function (value) {\n            if (value !== null) {\n              _events.trigger(\"stage:interactionStart\");\n            } else {\n              _events.trigger(\"stage:interactionStop\");\n            }\n          });\n\n          _events.on(\"stage:\" + _this.contentType.stageId + \":fullScreenModeChangeAfter\", _this.onColumnResize.bind(_assertThisInitialized(_this), [true]));\n\n          _events.on(\"stage:\" + _this.contentType.stageId + \":viewportChangeAfter\", function () {\n            if (_this.element) {\n              (0, _jquery)(_this.element).slick(\"setPosition\");\n\n              _this.checkWidth();\n            }\n          });\n        }, function () {\n          return (0, _jquery)(element).find(\".pagebuilder-slide\").length === expectedChildren;\n        });\n      });\n      return _this;\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.add = new _option({\n        preview: this,\n        icon: \"<i class='icon-pagebuilder-add'></i>\",\n        title: (0, _translate)(\"Add\"),\n        action: this.addSlide,\n        classes: [\"add-child\"],\n        sort: 10\n      });\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Set an active slide for navigation dot\n     *\n     * @param slideIndex\n     */\n    ;\n\n    _proto.setActiveSlide = function setActiveSlide(slideIndex) {\n      this.activeSlide(slideIndex);\n    }\n    /**\n     * Set the focused slide\n     *\n     * @param {number} slideIndex\n     * @param {boolean} force\n     */\n    ;\n\n    _proto.setFocusedSlide = function setFocusedSlide(slideIndex, force) {\n      if (force === void 0) {\n        force = false;\n      }\n\n      if (force) {\n        this.focusedSlide(null);\n      }\n\n      this.focusedSlide(slideIndex);\n    }\n    /**\n     * Unset focused slide on focusout event.\n     *\n     * @param {PreviewCollection} data\n     * @param {JQueryEventObject} event\n     */\n    ;\n\n    _proto.onFocusOut = function onFocusOut(data, event) {\n      var relatedTarget = event.relatedTarget;\n\n      if (!relatedTarget && document.activeElement && !(document.activeElement instanceof HTMLBodyElement)) {\n        relatedTarget = document.activeElement;\n      }\n\n      if (!relatedTarget) {\n        this.setFocusedSlide(null);\n        return;\n      }\n\n      var $relatedTarget = (0, _jquery)(relatedTarget);\n      var isRelatedTargetDescendantOfNavigation = $relatedTarget.closest(this.navigationElement).length;\n      var isFocusedOnAnotherSlideInThisSlider = $relatedTarget.hasClass(\"navigation-dot-anchor\") && isRelatedTargetDescendantOfNavigation;\n\n      if (isFocusedOnAnotherSlideInThisSlider) {\n        _events.trigger(\"stage:interactionStop\");\n      } else if (!isRelatedTargetDescendantOfNavigation) {\n        this.setFocusedSlide(null);\n      }\n    }\n    /**\n     * Set reference to navigation element in template\n     *\n     * @param {HTMLElement} navigationElement\n     */\n    ;\n\n    _proto.afterNavigationRender = function afterNavigationRender(navigationElement) {\n      this.navigationElement = navigationElement;\n    }\n    /**\n     * Navigate to a slide\n     *\n     * @param {number} slideIndex\n     * @param {boolean} dontAnimate\n     * @param {boolean} force\n     */\n    ;\n\n    _proto.navigateToSlide = function navigateToSlide(slideIndex, dontAnimate, force) {\n      if (dontAnimate === void 0) {\n        dontAnimate = false;\n      }\n\n      if (force === void 0) {\n        force = false;\n      }\n\n      if ((0, _jquery)(this.element).hasClass(\"slick-initialized\")) {\n        (0, _jquery)(this.element).slick(\"slickGoTo\", slideIndex, dontAnimate);\n        this.setActiveSlide(slideIndex);\n        this.setFocusedSlide(slideIndex, force);\n      }\n    }\n    /**\n     * After child render record element\n     *\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.afterChildrenRender = function afterChildrenRender(element) {\n      this.element = element; // if slider has been re-rendered previously on this element, re-build\n\n      if (this.ready) {\n        this.buildSlick();\n      }\n\n      _previewCollection2.prototype.afterChildrenRender.call(this, element);\n\n      this.afterChildrenRenderDeferred.resolve(element);\n    }\n    /**\n     * On sort start force the container height, also focus to that slide\n     *\n     * @param {Event} event\n     * @param {JQueryUI.SortableUIParams} params\n     */\n    ;\n\n    _proto.onSortStart = function onSortStart(event, params) {\n      this.forceContainerHeight();\n\n      if (this.activeSlide() !== params.item.index() || this.focusedSlide() !== params.item.index()) {\n        this.navigateToSlide(params.item.index(), false, true); // As we've completed a navigation request we need to ensure we don't remove the forced height\n\n        this.contentTypeHeightReset = true;\n      }\n    }\n    /**\n     * On sort stop ensure the focused slide and the active slide are in sync, as the focus can be lost in this\n     * operation\n     */\n    ;\n\n    _proto.onSortStop = function onSortStop(event, params) {\n      var _this2 = this;\n\n      if (this.activeSlide() !== this.focusedSlide()) {\n        this.setFocusedSlide(this.activeSlide(), true);\n      }\n\n      if (params.item.index() !== -1) {\n        _underscore.defer(this.focusElement.bind(this, event, params.item.index()));\n      }\n\n      _underscore.defer(function () {\n        (0, _jquery)(_this2.element).css({\n          height: \"\",\n          overflow: \"\"\n        });\n      });\n    }\n    /**\n     * Add a slide into the slider\n     */\n    ;\n\n    _proto.addSlide = function addSlide() {\n      var _this3 = this;\n\n      (0, _contentTypeFactory)(_config.getConfig(\"content_types\").slide, this.contentType, this.contentType.stageId).then(function (slide) {\n        _events.on(\"slide:mountAfter\", function (args) {\n          if (args.id === slide.id) {\n            _underscore.defer(function () {\n              // Wait until slick is initialized before trying to navigate\n              (0, _delayUntil)(function () {\n                return _this3.navigateToSlide(_this3.contentType.children().length - 1);\n              }, function () {\n                return (0, _jquery)(_this3.element).hasClass(\"slick-initialized\");\n              }, 10);\n            });\n\n            _events.off(\"slide:\" + slide.id + \":mountAfter\");\n          }\n        }, \"slide:\" + slide.id + \":mountAfter\");\n\n        _this3.contentType.addChild(slide, _this3.contentType.children().length);\n      });\n    }\n    /**\n     * Slider can not receive drops by default\n     *\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.isContainer = function isContainer() {\n      return false;\n    }\n    /**\n     * Slider navigation click handler.\n     *\n     * @param {number} index\n     * @param {Preview} context\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onControlClick = function onControlClick(index, context, event) {\n      (0, _jquery)(event.target).focus();\n      this.navigateToSlide(index);\n      this.setFocusedSlide(index);\n    }\n    /**\n     * @inheritdoc\n     */\n    ;\n\n    _proto.destroy = function destroy() {\n      _previewCollection2.prototype.destroy.call(this);\n\n      if (this.focusedSlideSubscriber) {\n        this.focusedSlideSubscriber.dispose();\n      }\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this4 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this);\n\n      _events.on(\"slider:mountAfter\", function (args) {\n        if (args.id === _this4.contentType.id) {\n          if (args.expectChildren !== undefined) {\n            _this4.mountAfterDeferred.resolve(args.expectChildren);\n          }\n        }\n      }); // Set the active slide to the new position of the sorted slide\n\n\n      _events.on(\"childContentType:sortUpdate\", function (args) {\n        if (args.instance.id === _this4.contentType.id) {\n          (0, _jquery)(args.ui.item).remove(); // Remove the item as the container's children is controlled by knockout\n\n          _this4.setActiveSlide(args.newPosition);\n\n          _underscore.defer(_this4.focusElement.bind(_this4, args.event, args.newPosition));\n        }\n      }); // When a slide content type is removed\n      // we need to force update the content of the slider due to KO rendering issues\n\n\n      var newItemIndex;\n\n      _events.on(\"slide:removeAfter\", function (args) {\n        if (args.parentContentType && args.parentContentType.id === _this4.contentType.id) {\n          // Mark the previous slide as active\n          newItemIndex = args.index - 1 >= 0 ? args.index - 1 : 0;\n\n          _this4.forceContainerHeight();\n\n          var data = _this4.contentType.children().slice(0);\n\n          _this4.contentType.children([]);\n\n          _this4.contentType.children(data);\n\n          _underscore.defer(function () {\n            _this4.buildSlick();\n          });\n        }\n      });\n\n      _events.on(\"slide:renderAfter\", function (args) {\n        var itemIndex = args.contentType.parentContentType.getChildren()().indexOf(args.contentType);\n\n        if (args.contentType.parentContentType.id === _this4.contentType.id && newItemIndex !== null && newItemIndex === itemIndex) {\n          _underscore.defer(function () {\n            if (newItemIndex !== null) {\n              newItemIndex = null;\n\n              _this4.navigateToSlide(itemIndex, true, true);\n\n              _underscore.defer(function () {\n                _this4.focusedSlide(null);\n\n                _this4.focusedSlide(itemIndex);\n              });\n            }\n          });\n        }\n      }); // On a slide content types creation we need to lock the height of the slider to ensure a smooth transition\n\n\n      _events.on(\"slide:createAfter\", function (args) {\n        if (_this4.element && _this4.ready && args.contentType.parentContentType.id === _this4.contentType.id) {\n          _this4.forceContainerHeight();\n\n          _underscore.defer(function () {\n            (0, _jquery)(_this4.element).css({\n              height: \"\",\n              overflow: \"\"\n            });\n          });\n        }\n      }); // ContentType being mounted onto container\n\n\n      _events.on(\"slider:dropAfter\", function (args) {\n        if (args.id === _this4.contentType.id && _this4.contentType.children().length === 0) {\n          _this4.addSlide();\n        }\n      }); // Capture when a content type is duplicated within the container\n\n\n      var duplicatedSlide;\n      var duplicatedSlideIndex;\n\n      _events.on(\"slide:duplicateAfter\", function (args) {\n        if (args.duplicateContentType.parentContentType.id === _this4.contentType.id && args.direct) {\n          duplicatedSlide = args.duplicateContentType;\n          duplicatedSlideIndex = args.index;\n        }\n      });\n\n      _events.on(\"slide:mountAfter\", function (args) {\n        if (duplicatedSlide && args.id === duplicatedSlide.id) {\n          _underscore.defer(function () {\n            // Mark the new duplicate slide as active\n            _this4.navigateToSlide(duplicatedSlideIndex, true, true);\n\n            duplicatedSlide = duplicatedSlideIndex = null;\n          });\n        }\n      });\n    }\n    /**\n     * Determine if the data has changed, whilst ignoring certain keys which don't require a rebuild\n     *\n     * @param {DataObject} previousData\n     * @param {DataObject} newData\n     * @returns {boolean}\n     */\n    ;\n\n    _proto.hasDataChanged = function hasDataChanged(previousData, newData) {\n      previousData = _underscore.omit(previousData, this.ignoredKeysForBuild);\n      newData = _underscore.omit(newData, this.ignoredKeysForBuild);\n      return !_underscore.isEqual(previousData, newData);\n    }\n    /**\n     * Build our instance of slick\n     */\n    ;\n\n    _proto.buildSlick = function buildSlick() {\n      var _this5 = this;\n\n      if (this.element && this.element.children.length > 0) {\n        try {\n          (0, _jquery)(this.element).slick(\"unslick\");\n        } catch (e) {// We aren't concerned if this fails, slick throws an Exception when we cannot unslick\n        } // Dispose current subscription in order to prevent infinite loop\n\n\n        if (this.childSubscribe) {\n          this.childSubscribe.dispose();\n        } // Force an update on all children, ko tries to intelligently re-render but fails\n\n\n        var data = this.contentType.children().slice(0);\n        this.contentType.children([]);\n        (0, _jquery)(this.element).empty();\n        this.contentType.children(data); // Re-subscribe original event\n\n        this.childSubscribe = this.contentType.children.subscribe(this.buildSlickDebounce); // Bind our init event for slick\n\n        (0, _jquery)(this.element).on(\"init\", function () {\n          _this5.ready = true;\n        }); // Build slick\n\n        (0, _jquery)(this.element).slick(Object.assign({\n          initialSlide: this.activeSlide() || 0\n        }, this.buildSlickConfig())); // Update our KO pointer to the active slide on change\n\n        (0, _jquery)(this.element).on(\"beforeChange\", function (event, slick, currentSlide, nextSlide) {\n          (0, _jquery)(_this5.element).css(\"pointer-events\", \"none\");\n\n          _this5.setActiveSlide(nextSlide);\n        }).on(\"afterChange\", function () {\n          if (!_this5.contentTypeHeightReset) {\n            (0, _jquery)(_this5.element).css({\n              height: \"\",\n              overflow: \"\"\n            });\n            _this5.contentTypeHeightReset = null;\n          }\n\n          (0, _jquery)(_this5.element).css(\"pointer-events\", \"\");\n        });\n      }\n    }\n    /**\n     * Take dropped element on focus.\n     *\n     * @param {JQueryEventObject} event\n     * @param {number} index\n     */\n    ;\n\n    _proto.focusElement = function focusElement(event, index) {\n      var handleClassName = (0, _jquery)(event.target).data(\"ui-sortable\").options.handle;\n      (0, _jquery)((0, _jquery)(event.target).find(handleClassName)[index]).focus();\n    }\n    /**\n     * To ensure smooth animations we need to lock the container height\n     */\n    ;\n\n    _proto.forceContainerHeight = function forceContainerHeight() {\n      (0, _jquery)(this.element).css({\n        height: (0, _jquery)(this.element).outerHeight(),\n        overflow: \"hidden\"\n      });\n    }\n    /**\n     * Build the slick config object\n     *\n     * @returns {{autoplay: boolean; autoplaySpeed: (any | number);\n     * fade: boolean; infinite: boolean; arrows: boolean; dots: boolean}}\n     */\n    ;\n\n    _proto.buildSlickConfig = function buildSlickConfig() {\n      var data = this.contentType.dataStore.getState();\n      return {\n        arrows: data.show_arrows === \"true\",\n        autoplay: data.autoplay === \"true\",\n        autoplaySpeed: data.autoplay_speed,\n        dots: false,\n        // We have our own dots implemented\n        fade: data.fade === \"true\",\n        infinite: data.is_infinite === \"true\",\n        waitForAnimate: false,\n        swipe: false\n      };\n    }\n    /**\n     * Fit slider in column container\n     *\n     * @param params\n     */\n    ;\n\n    _proto.onColumnResize = function onColumnResize(params) {\n      var _this6 = this;\n\n      setTimeout(function () {\n        if (_this6.element) {\n          (0, _jquery)(_this6.element).slick(\"setPosition\");\n\n          _this6.checkWidth();\n        }\n      }, 450);\n    }\n    /**\n     * Check width and add class that marks element as small\n     */\n    ;\n\n    _proto.checkWidth = function checkWidth() {\n      if (this.element.offsetWidth < 410) {\n        this.element.classList.add(\"slider-small-width\");\n      } else {\n        this.element.classList.remove(\"slider-small-width\");\n      }\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/slider/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/events',\n    'slick'\n], function ($, events) {\n    'use strict';\n\n    return function (config, sliderElement) {\n        var $element = $(sliderElement);\n\n        /**\n         * Prevent each slick slider from being initialized more than once which could throw an error.\n         */\n        if ($element.hasClass('slick-initialized')) {\n            $element.slick('unslick');\n        }\n\n        $element.slick({\n            autoplay: $element.data('autoplay'),\n            autoplaySpeed: $element.data('autoplay-speed') || 0,\n            fade: $element.data('fade'),\n            infinite: $element.data('infinite-loop'),\n            arrows: $element.data('show-arrows'),\n            dots: $element.data('show-dots')\n        });\n\n        // Redraw slide after content type gets redrawn\n        events.on('contentType:redrawAfter', function (args) {\n            if ($element.closest(args.element).length) {\n                $element.slick('setPosition');\n            }\n        });\n        // eslint-disable-next-line jquery-no-bind-unbind\n        events.on('stage:viewportChangeAfter', $element.slick.bind($element, 'setPosition'));\n    };\n});\n","Magento_PageBuilder/js/content-type/tab-item/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"Magento_PageBuilder/js/content-type-menu/conditional-remove-option\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jquery, _knockout, _conditionalRemoveOption, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _previewCollection2.call.apply(_previewCollection2, [this].concat(args)) || this;\n      _this.fieldsToIgnoreOnRemove = [\"tab_name\"];\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Get background image url base on the viewport.\n     *\n     * @returns {string}\n     */\n    _proto.getBackgroundImage = function getBackgroundImage() {\n      var mobileImage = this.contentType.dataStore.get(\"mobile_image\");\n      var desktopImage = this.contentType.dataStore.get(\"background_image\");\n      var backgroundImage = this.viewport() === \"mobile\" && mobileImage.length ? mobileImage : desktopImage;\n      return backgroundImage.length ? \"url(\\\"\" + backgroundImage[0].url + \"\\\")\" : \"none\";\n    }\n    /**\n     * Force the focus on the clicked tab header\n     *\n     * @param {number} index\n     * @param {JQueryEventObject} event\n     */\n    ;\n\n    _proto.onClick = function onClick(index, event) {\n      (0, _jquery)(event.currentTarget).find(\"[contenteditable]\").focus();\n      event.stopPropagation();\n    }\n    /**\n     * On focus in set the focused button\n     *\n     * @param {number} index\n     * @param {Event} event\n     */\n    ;\n\n    _proto.onFocusIn = function onFocusIn(index, event) {\n      var parentPreview = this.contentType.parentContentType.preview;\n\n      if (parentPreview.focusedTab() !== index) {\n        parentPreview.setFocusedTab(index, true);\n      }\n    }\n    /**\n     * On focus out set the focused tab to null\n     *\n     * @param {number} index\n     * @param {JQueryEventObject} event\n     */\n    ;\n\n    _proto.onFocusOut = function onFocusOut(index, event) {\n      if (this.contentType && this.contentType.parentContentType) {\n        var parentPreview = this.contentType.parentContentType.preview;\n\n        var unfocus = function unfocus() {\n          window.getSelection().removeAllRanges();\n          parentPreview.focusedTab(null);\n        };\n\n        if (event.relatedTarget && _jquery.contains(parentPreview.wrapperElement, event.relatedTarget)) {\n          // Verify the focus was not onto the options menu\n          if ((0, _jquery)(event.relatedTarget).closest(\".pagebuilder-options\").length > 0) {\n            unfocus();\n          } else {\n            // Have we moved the focus onto another button in the current group?\n            var tabItem = _knockout.dataFor(event.relatedTarget);\n\n            if (tabItem && tabItem.contentType && tabItem.contentType.parentContentType && tabItem.contentType.parentContentType.id === this.contentType.parentContentType.id) {\n              var newIndex = tabItem.contentType.parentContentType.children().indexOf(tabItem.contentType);\n              parentPreview.setFocusedTab(newIndex, true);\n            } else {\n              unfocus();\n            }\n          }\n        } else if (parentPreview.focusedTab() === index) {\n          unfocus();\n        }\n      }\n    }\n    /**\n     * Get the options instance\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      delete options.move;\n      delete options.title;\n      options.remove = new _conditionalRemoveOption(_extends({}, options.remove.config, {\n        preview: this\n      }));\n      return options;\n    };\n\n    return Preview;\n  }(_previewCollection);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/tabs/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"knockout\", \"mage/translate\", \"Magento_PageBuilder/js/events\", \"tabs\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type-menu/option\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/promise-deferred\", \"Magento_PageBuilder/js/content-type/preview-collection\"], function (_jquery, _knockout, _translate, _events, _tabs, _underscore, _config, _contentTypeFactory, _hideShowOption, _option, _delayUntil, _promiseDeferred, _previewCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_previewCollection2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _previewCollection2);\n\n    /**\n     * @param {ContentTypeCollectionInterface} contentType\n     * @param {ContentTypeConfigInterface} config\n     * @param {ObservableUpdater} observableUpdater\n     */\n    function Preview(contentType, config, observableUpdater) {\n      var _this;\n\n      _this = _previewCollection2.call(this, contentType, config, observableUpdater) || this; // Wait for the tabs instance to mount and the container to be ready\n\n      _this.focusedTab = _knockout.observable(null);\n      _this.activeTab = _knockout.observable(0);\n      _this.onContainerRenderDeferred = (0, _promiseDeferred)();\n      _this.mountAfterDeferred = (0, _promiseDeferred)();\n      Promise.all([_this.onContainerRenderDeferred.promise, _this.mountAfterDeferred.promise]).then(function (_ref) {\n        var element = _ref[0],\n            expectedChildren = _ref[1];\n        // We always create 1 tab when dropping tabs into the instance\n        expectedChildren = expectedChildren || 1; // Wait until all children's DOM elements are present before building the tabs instance\n\n        (0, _delayUntil)(function () {\n          _this.element = element;\n\n          _this.buildTabs();\n        }, function () {\n          return (0, _jquery)(element).find(\".pagebuilder-tab-item\").length === expectedChildren;\n        });\n      }); // Resolve our deferred when the tabs item mounts with expect children\n\n      _events.on(\"tabs:mountAfter\", function (args) {\n        if (args.contentType.id === _this.contentType.id && args.expectChildren !== undefined) {\n          _this.mountAfterDeferred.resolve(args.expectChildren);\n        }\n      });\n\n      _events.on(\"tab-item:mountAfter\", function (args) {\n        if (_this.element && args.contentType.parentContentType.id === _this.contentType.id) {\n          _this.refreshTabs();\n        }\n      });\n\n      _events.on(\"tab-item:renderAfter\", function (args) {\n        if (_this.element && args.contentType.parentContentType.id === _this.contentType.id) {\n          _underscore.defer(function () {\n            _this.refreshTabs();\n          });\n        }\n      }); // Set the active tab to the new position of the sorted tab\n\n\n      _events.on(\"tab-item:removeAfter\", function (args) {\n        if (args.parentContentType && args.parentContentType.id === _this.contentType.id) {\n          _this.refreshTabs(); // We need to wait for the tabs to refresh before executing the focus\n\n\n          _underscore.defer(function () {\n            var newPosition = args.index > 0 ? args.index - 1 : 0;\n\n            _this.setFocusedTab(newPosition, true);\n          });\n        }\n      }); // Refresh tab contents and set the focus to the new position of the sorted tab\n\n\n      _events.on(\"childContentType:sortUpdate\", function (args) {\n        if (args.instance.id === _this.contentType.id) {\n          _this.refreshTabs(args.newPosition, true);\n          /**\n           * Update the default active tab if its position was affected by the sorting\n           */\n\n\n          var defaultActiveTab = +_this.activeTab();\n          var newDefaultActiveTab = defaultActiveTab;\n\n          if (args.originalPosition === defaultActiveTab) {\n            newDefaultActiveTab = args.newPosition;\n          } else if (args.originalPosition < defaultActiveTab && args.newPosition >= defaultActiveTab) {\n            // a tab was moved from the left of the default active tab the right of it, changing its index\n            newDefaultActiveTab--;\n          } else if (args.originalPosition > defaultActiveTab && args.newPosition <= defaultActiveTab) {\n            // a tab was moved from the right of the default active tab the left of it, changing its index\n            newDefaultActiveTab++;\n          }\n\n          _this.updateData(\"default_active\", newDefaultActiveTab.toString());\n        }\n      }); // Monitor focus tab to start / stop interaction on the stage, debounce to avoid duplicate calls\n\n\n      _this.focusedTab.subscribe(_underscore.debounce(function (index) {\n        if (index !== null) {\n          _events.trigger(\"stage:interactionStart\");\n\n          (0, _delayUntil)(function () {\n            return (0, _jquery)((0, _jquery)(_this.wrapperElement).find(\".tab-header\")[index]).find(\"[contenteditable]\").focus();\n          }, function () {\n            return (0, _jquery)((0, _jquery)(_this.wrapperElement).find(\".tab-header\")[index]).find(\"[contenteditable]\").length > 0;\n          }, 10);\n        } else {\n          // We have to force the stop as the event firing is inconsistent for certain operations\n          _events.trigger(\"stage:interactionStop\", {\n            force: true\n          });\n        }\n      }, 1));\n\n      return _this;\n    }\n    /**\n     * Remove focused tab\n     */\n\n\n    var _proto = Preview.prototype;\n\n    _proto.destroy = function destroy() {\n      var _this2 = this;\n\n      _previewCollection2.prototype.destroy.call(this);\n\n      _underscore.defer(function () {\n        return _this2.setFocusedTab(null);\n      });\n    }\n    /**\n     * Refresh the tabs instance when new content appears\n     *\n     * @param {number} focusIndex\n     * @param {boolean} forceFocus\n     * @param {number} activeIndex\n     */\n    ;\n\n    _proto.refreshTabs = function refreshTabs(focusIndex, forceFocus, activeIndex) {\n      try {\n        (0, _jquery)(this.element).tabs(\"refresh\");\n\n        if (focusIndex >= 0) {\n          this.setFocusedTab(focusIndex, forceFocus);\n        } else if (activeIndex) {\n          this.setActiveTab(activeIndex);\n        } // update sortability of tabs\n\n\n        var sortableElement = (0, _jquery)(this.element).find(\".tabs-navigation\");\n\n        if (sortableElement.hasClass(\"ui-sortable\")) {\n          if (this.contentType.children().length <= 1) {\n            sortableElement.sortable(\"disable\");\n          } else {\n            sortableElement.sortable(\"enable\");\n          }\n        }\n      } catch (e) {\n        this.buildTabs();\n      }\n    }\n    /**\n     * Set the active tab, we maintain a reference to it in an observable for when we rebuild the tab instance\n     *\n     * @param {number} index\n     */\n    ;\n\n    _proto.setActiveTab = function setActiveTab(index) {\n      var _this3 = this;\n\n      if (index !== null) {\n        // Added to prevent mismatched fragment error caused by not yet rendered tab-item\n        index = parseInt(index.toString(), 10);\n        (0, _delayUntil)(function () {\n          (0, _jquery)(_this3.element).tabs(\"option\", \"active\", index);\n\n          _this3.activeTab(index);\n\n          _events.trigger(\"contentType:redrawAfter\", {\n            id: _this3.contentType.id,\n            contentType: _this3\n          });\n        }, function () {\n          return (0, _jquery)(_this3.element).find(\".pagebuilder-tab-item\").length >= index + 1;\n        });\n      }\n    }\n    /**\n     * Set the focused tab\n     *\n     * @param {number} index\n     * @param {boolean} force\n     */\n    ;\n\n    _proto.setFocusedTab = function setFocusedTab(index, force) {\n      if (force === void 0) {\n        force = false;\n      }\n\n      this.setActiveTab(index);\n\n      if (force) {\n        this.focusedTab(null);\n      }\n\n      this.focusedTab(index);\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _previewCollection2.prototype.retrieveOptions.call(this);\n\n      options.add = new _option({\n        preview: this,\n        icon: \"<i class='icon-pagebuilder-add'></i>\",\n        title: (0, _translate)(\"Add\"),\n        action: this.addTab,\n        classes: [\"add-child\"],\n        sort: 10\n      });\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * Add a tab\n     */\n    ;\n\n    _proto.addTab = function addTab() {\n      var _this4 = this;\n\n      (0, _contentTypeFactory)(_config.getContentTypeConfig(\"tab-item\"), this.contentType, this.contentType.stageId).then(function (tab) {\n        _events.on(\"tab-item:mountAfter\", function (args) {\n          if (args.id === tab.id) {\n            _this4.setFocusedTab(_this4.contentType.children().length - 1);\n\n            _events.off(\"tab-item:\" + tab.id + \":mountAfter\");\n          }\n        }, \"tab-item:\" + tab.id + \":mountAfter\");\n\n        _this4.contentType.addChild(tab, _this4.contentType.children().length); // Update the default tab title when adding a new tab\n\n\n        tab.dataStore.set(\"tab_name\", (0, _translate)(\"Tab\") + \" \" + (_this4.contentType.children.indexOf(tab) + 1));\n      });\n    }\n    /**\n     * On render init the tabs widget\n     *\n     * @param {Element} element\n     */\n    ;\n\n    _proto.onContainerRender = function onContainerRender(element) {\n      this.element = element;\n      this.onContainerRenderDeferred.resolve(element);\n    }\n    /**\n     * Copy over border styles to the tab headers\n     *\n     * @returns {any}\n     */\n    ;\n\n    _proto.getTabHeaderStyles = function getTabHeaderStyles() {\n      var headerStyles = this.data.headers.style();\n      return _extends({}, headerStyles, {\n        marginBottom: \"-\" + headerStyles.borderWidth,\n        marginLeft: \"-\" + headerStyles.borderWidth\n      });\n    }\n    /**\n     * Get the sortable options for the tab heading sorting\n     *\n     * @returns {JQueryUI.SortableOptions}\n     */\n    ;\n\n    _proto.getSortableOptions = function getSortableOptions() {\n      var self = this;\n      var borderWidth;\n      return {\n        handle: \".tab-drag-handle\",\n        tolerance: \"pointer\",\n        cursor: \"grabbing\",\n        cursorAt: {\n          left: 8,\n          top: 25\n        },\n\n        /**\n         * Provide custom helper element\n         *\n         * @param {Event} event\n         * @param {JQueryUI.Sortable} element\n         * @returns {Element}\n         */\n        helper: function helper(event, element) {\n          var helper = (0, _jquery)(element).clone().css(\"opacity\", \"0.7\");\n          helper[0].querySelector(\".pagebuilder-options\").remove();\n          return helper[0];\n        },\n\n        /**\n         * Add a padding to the navigation UL to resolve issues of negative margins when sorting\n         *\n         * @param {Event} event\n         * @param {JQueryUI.SortableUIParams} ui\n         */\n        start: function start(event, ui) {\n          /**\n           * Due to the way we use negative margins to overlap the borders we need to apply a padding to the\n           * container when we're moving the first item to ensure the tabs remain in the same place.\n           */\n          if (ui.item.index() === 0) {\n            borderWidth = parseInt(ui.item.css(\"borderWidth\"), 10) || 1;\n            (0, _jquery)(this).css(\"paddingLeft\", borderWidth);\n          }\n\n          ui.helper.css(\"width\", \"\");\n\n          _events.trigger(\"stage:interactionStart\");\n\n          self.disableInteracting = true;\n        },\n\n        /**\n         * Remove the padding once the operation is completed\n         *\n         * @param {Event} event\n         * @param {JQueryUI.SortableUIParams} ui\n         */\n        stop: function stop(event, ui) {\n          (0, _jquery)(this).css(\"paddingLeft\", \"\");\n\n          _events.trigger(\"stage:interactionStop\");\n\n          self.disableInteracting = false;\n        },\n        placeholder: {\n          /**\n           * Provide custom placeholder element\n           *\n           * @param {JQuery} item\n           * @returns {JQuery}\n           */\n          element: function element(item) {\n            var placeholder = item.clone().css({\n              display: \"inline-block\",\n              opacity: \"0.3\"\n            }).removeClass(\"focused\").addClass(\"sortable-placeholder\");\n            placeholder[0].querySelector(\".pagebuilder-options\").remove();\n            return placeholder[0];\n          },\n          update: function update() {\n            return;\n          }\n        }\n      };\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this5 = this;\n\n      _previewCollection2.prototype.bindEvents.call(this); // ContentType being mounted onto container\n\n\n      _events.on(\"tabs:dropAfter\", function (args) {\n        if (args.id === _this5.contentType.id && _this5.contentType.children().length === 0) {\n          _this5.addTab();\n        }\n      }); // ContentType being removed from container\n\n\n      _events.on(\"tab-item:removeAfter\", function (args) {\n        if (args.parentContentType && args.parentContentType.id === _this5.contentType.id) {\n          // Mark the previous tab as active\n          var newIndex = args.index - 1 >= 0 ? args.index - 1 : 0;\n\n          _this5.refreshTabs(newIndex, true);\n        }\n      }); // Capture when a content type is duplicated within the container\n\n\n      var duplicatedTab;\n      var duplicatedTabIndex;\n\n      _events.on(\"tab-item:duplicateAfter\", function (args) {\n        if (_this5.contentType.id === args.duplicateContentType.parentContentType.id && args.direct) {\n          var tabData = args.duplicateContentType.dataStore.getState();\n          args.duplicateContentType.dataStore.set(\"tab_name\", tabData.tab_name.toString() + \" copy\");\n          duplicatedTab = args.duplicateContentType;\n          duplicatedTabIndex = args.index;\n        }\n      });\n\n      _events.on(\"tab-item:mountAfter\", function (args) {\n        if (duplicatedTab && args.id === duplicatedTab.id) {\n          _this5.refreshTabs(duplicatedTabIndex, true);\n\n          duplicatedTab = duplicatedTabIndex = null;\n        }\n\n        if (_this5.contentType.id === args.contentType.parentContentType.id) {\n          _this5.updateTabNamesInDataStore();\n\n          args.contentType.dataStore.subscribe(function () {\n            _this5.updateTabNamesInDataStore();\n          });\n        }\n      });\n\n      this.contentType.dataStore.subscribe(function (data) {\n        _this5.activeTab(data.default_active);\n      });\n    }\n    /**\n     * Update data store with active options\n     */\n    ;\n\n    _proto.updateTabNamesInDataStore = function updateTabNamesInDataStore() {\n      var activeOptions = [];\n      this.contentType.children().forEach(function (tab, index) {\n        var tabData = tab.dataStore.getState();\n        activeOptions.push({\n          label: tabData.tab_name.toString(),\n          labeltitle: tabData.tab_name.toString(),\n          value: index\n        });\n      });\n      this.contentType.dataStore.set(\"_default_active_options\", activeOptions);\n    }\n    /**\n     * Assign a debounce and delay to the init of tabs to ensure the DOM has updated\n     *\n     * @type {(() => void) & _.Cancelable}\n     */\n    ;\n\n    _proto.buildTabs = function buildTabs(activeTabIndex) {\n      var _this6 = this;\n\n      if (activeTabIndex === void 0) {\n        activeTabIndex = this.activeTab() || 0;\n      }\n\n      this.ready = false;\n\n      if (this.element && this.element.children.length > 0) {\n        var focusedTab = this.focusedTab();\n\n        try {\n          (0, _jquery)(this.element).tabs(\"destroy\");\n        } catch (e) {// We aren't concerned if this fails, tabs throws an Exception when we cannot destroy\n        }\n\n        (0, _jquery)(this.element).tabs({\n          create: function create() {\n            _this6.ready = true; // Ensure focus tab is restored after a rebuild cycle\n\n            if (focusedTab !== null) {\n              _this6.setFocusedTab(focusedTab, true);\n            } else {\n              _this6.setFocusedTab(null);\n\n              if (activeTabIndex) {\n                _this6.setActiveTab(activeTabIndex);\n              }\n            }\n          },\n\n          /**\n           * Trigger redraw event since new content is being displayed\n           */\n          activate: function activate() {\n            _events.trigger(\"contentType:redrawAfter\", {\n              element: _this6.element\n            });\n          }\n        });\n      }\n    };\n\n    return Preview;\n  }(_previewCollection); // Resolve issue with jQuery UI tabs content typing events on content editable areas\n\n\n  var originalTabKeyDown = _jquery.ui.tabs.prototype._tabKeydown;\n\n  _jquery.ui.tabs.prototype._tabKeydown = function (event) {\n    // If the target is content editable don't handle any events\n    if ((0, _jquery)(event.target).attr(\"contenteditable\")) {\n      return;\n    }\n\n    originalTabKeyDown.call(this, event);\n  };\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/tabs/appearance/default/widget.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_PageBuilder/js/events',\n    'jquery-ui-modules/tabs'\n], function ($, events) {\n    'use strict';\n\n    return function (config, element) {\n        var $element = $(element);\n\n        // Ignore stage builder preview tabs\n        if ($element.is('.pagebuilder-tabs')) {\n            return;\n        }\n\n        // Disambiguate between the mage/tabs component which is loaded randomly depending on requirejs order.\n        $.ui.tabs({\n            active: $element.data('activeTab') || 0,\n            create:\n\n                /**\n                 * Adjust the margin bottom of the navigation to correctly display the active tab\n                 */\n                function () {\n                    var borderWidth = parseInt($element.find('.tabs-content').css('borderWidth').toString(), 10);\n\n                    $element.find('.tabs-navigation').css('marginBottom', -borderWidth);\n                    $element.find('.tabs-navigation li:not(:first-child)').css('marginLeft', -borderWidth);\n                },\n            activate:\n\n                /**\n                 * Trigger redraw event since new content is being displayed\n                 */\n                function () {\n                    events.trigger('contentType:redrawAfter', {\n                        element: element\n                    });\n                }\n        }, element);\n    };\n});\n","Magento_PageBuilder/js/content-type/tabs/mass-converter/header-alignment.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var HeaderAlignment = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function HeaderAlignment() {}\n\n    var _proto = HeaderAlignment.prototype;\n\n    /**\n     * Process data after it's read and converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      return data;\n    }\n    /**\n     * Add our tab alignment class into the data for the tabs\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      data.css_classes += \" tab-align-\" + (0, _object.get)(data, config.navigation_alignment_variable, \"left\");\n      return data;\n    };\n\n    return HeaderAlignment;\n  }();\n\n  return HeaderAlignment;\n});\n//# sourceMappingURL=header-alignment.js.map","Magento_PageBuilder/js/content-type/text/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"jquery\", \"Magento_PageBuilder/js/events\", \"underscore\", \"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/utils/delay-until\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/wysiwyg/factory\", \"Magento_PageBuilder/js/content-type/preview\"], function (_jquery, _events, _underscore, _hideShowOption, _delayUntil, _editor, _factory, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      var _this;\n\n      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n        args[_key] = arguments[_key];\n      }\n\n      _this = _preview2.call.apply(_preview2, [this].concat(args)) || this;\n      _this.wysiwygDeferred = _jquery.Deferred();\n      _this.afterRenderDeferred = _jquery.Deferred();\n      _this.handledDoubleClick = false;\n      return _this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * @returns {Boolean}\n     */\n    _proto.isWysiwygSupported = function isWysiwygSupported() {\n      return (0, _editor.isWysiwygSupported)();\n    }\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    ;\n\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    }\n    /**\n     * @param {HTMLElement} element\n     */\n    ;\n\n    _proto.afterRenderWysiwyg = function afterRenderWysiwyg(element) {\n      var _this2 = this;\n\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\"; // Set the innerHTML manually so we don't upset Knockout & TinyMCE\n\n      element.innerHTML = this.data.main.html();\n      this.contentType.dataStore.subscribe(function () {\n        // If we're not focused into TinyMCE inline, update the value when it changes in the data store\n        if (!_this2.wysiwyg || _this2.wysiwyg && _this2.wysiwyg.getAdapter().id !== (0, _editor.getActiveEditor)().id) {\n          element.innerHTML = _this2.data.main.html();\n        }\n      }, \"content\");\n      this.afterRenderDeferred.resolve(element);\n      /**\n       * afterRenderWysiwyg is called whenever Knockout causes a DOM re-render. This occurs frequently within Slider\n       * due to Slick's inability to perform a refresh with Knockout managing the DOM. Due to this the original\n       * WYSIWYG instance will be detached from this slide and we need to re-initialize on click.\n       */\n\n      this.wysiwyg = null;\n    }\n    /**\n     * Stop event to prevent execution of action when editing textarea.\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.stopEvent = function stopEvent(preview, event) {\n      event.stopPropagation();\n      return true;\n    }\n    /**\n     * Init WYSIWYG on load\n     *\n     * @param element\n     * @deprecated please use activateEditor & initWysiwygFromClick\n     */\n    ;\n\n    _proto.initWysiwyg = function initWysiwyg(element) {\n      this.element = element;\n      element.id = this.contentType.id + \"-editor\";\n      this.wysiwyg = null;\n      return this.initWysiwygFromClick(true);\n    }\n    /**\n     * Init the WYSIWYG\n     *\n     * @param {boolean} focus Should wysiwyg focus after initialization?\n     * @returns Promise\n     */\n    ;\n\n    _proto.initWysiwygFromClick = function initWysiwygFromClick(focus) {\n      var _this3 = this;\n\n      if (focus === void 0) {\n        focus = false;\n      }\n\n      if (this.wysiwyg) {\n        return Promise.resolve(this.wysiwyg);\n      }\n\n      var wysiwygConfig = this.config.additional_data.wysiwygConfig.wysiwygConfigData;\n      wysiwygConfig.adapter.settings.paste_as_text = true;\n\n      if (focus) {\n        wysiwygConfig.adapter.settings.auto_focus = this.element.id;\n\n        wysiwygConfig.adapter.settings.init_instance_callback = function () {\n          _underscore.defer(function () {\n            _this3.element.blur();\n\n            _this3.element.focus();\n          });\n        };\n      }\n\n      return (0, _factory)(this.contentType.id, this.element.id, this.config.name, wysiwygConfig, this.contentType.dataStore, \"content\", this.contentType.stageId).then(function (wysiwyg) {\n        _this3.wysiwyg = wysiwyg;\n        return wysiwyg;\n      });\n    }\n    /**\n     * Makes WYSIWYG active\n     *\n     * @param {Preview} preview\n     * @param {JQueryEventObject} event\n     * @returns {Boolean}\n     */\n    ;\n\n    _proto.activateEditor = function activateEditor(preview, event) {\n      var _this4 = this;\n\n      if (this.element && !this.wysiwyg) {\n        var bookmark = (0, _editor.createBookmark)(event);\n        (0, _editor.lockImageSize)(this.element);\n        this.element.removeAttribute(\"contenteditable\");\n\n        _underscore.defer(function () {\n          _this4.initWysiwygFromClick(true).then(function () {\n            return (0, _delayUntil)(function () {\n              // We no longer need to handle double click once it's initialized\n              _this4.handledDoubleClick = true;\n\n              _this4.wysiwygDeferred.resolve();\n\n              (0, _editor.moveToBookmark)(bookmark);\n              (0, _editor.unlockImageSize)(_this4.element);\n            }, function () {\n              return _this4.element.classList.contains(\"mce-edit-focus\");\n            }, 10);\n          }).catch(function (error) {\n            // If there's an error with init of WYSIWYG editor push into the console to aid support\n            console.error(error);\n          });\n        });\n      }\n    }\n    /**\n     * If a user double clicks prior to initializing TinyMCE, forward the event\n     *\n     * @param preview\n     * @param event\n     */\n    ;\n\n    _proto.handleDoubleClick = function handleDoubleClick(preview, event) {\n      var _this5 = this;\n\n      if (this.handledDoubleClick) {\n        return;\n      }\n\n      event.preventDefault();\n      var targetIndex = (0, _editor.findNodeIndex)(this.element, event.target.tagName, event.target);\n      this.handledDoubleClick = true;\n      this.wysiwygDeferred.then(function () {\n        var target = document.getElementById(event.target.id);\n\n        if (!target) {\n          target = (0, _editor.getNodeByIndex)(_this5.element, event.target.tagName, targetIndex);\n        }\n\n        if (target) {\n          target.dispatchEvent((0, _editor.createDoubleClickEvent)());\n        }\n      });\n    }\n    /**\n     * @param {HTMLTextAreaElement} element\n     */\n    ;\n\n    _proto.initTextarea = function initTextarea(element) {\n      var _this6 = this;\n\n      this.textarea = element; // set initial value of textarea based on data store\n\n      this.textarea.value = this.contentType.dataStore.get(\"content\");\n      this.adjustTextareaHeightBasedOnScrollHeight(); // Update content in our stage preview textarea after its slideout counterpart gets updated\n\n      _events.on(\"form:\" + this.contentType.id + \":saveAfter\", function () {\n        _this6.textarea.value = _this6.contentType.dataStore.get(\"content\");\n\n        _this6.adjustTextareaHeightBasedOnScrollHeight();\n      });\n    }\n    /**\n     * Save current value of textarea in data store\n     */\n    ;\n\n    _proto.onTextareaKeyUp = function onTextareaKeyUp() {\n      this.adjustTextareaHeightBasedOnScrollHeight();\n      this.contentType.dataStore.set(\"content\", this.textarea.value);\n    }\n    /**\n     * Start stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaFocus = function onTextareaFocus() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-content-type\").addClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStart\");\n    }\n    /**\n     * Stop stage interaction on textarea blur\n     */\n    ;\n\n    _proto.onTextareaBlur = function onTextareaBlur() {\n      (0, _jquery)(this.textarea).closest(\".pagebuilder-content-type\").removeClass(\"pagebuilder-toolbar-active\");\n\n      _events.trigger(\"stage:interactionStop\");\n    }\n    /**\n     * Retrieve the margin & padding & alignment styles for the placeholder\n     *\n     * @returns {any}\n     */\n    ;\n\n    _proto.getPlaceholderStyle = function getPlaceholderStyle() {\n      var keys = [\"marginBottom\", \"marginLeft\", \"marginRight\", \"marginTop\", \"paddingBottom\", \"paddingLeft\", \"paddingRight\", \"paddingTop\", \"textAlign\"];\n      return _underscore.pick(this.data.main.style(), function (style, key) {\n        return keys.indexOf(key) !== -1;\n      });\n    }\n    /**\n     * Bind events\n     */\n    ;\n\n    _proto.bindEvents = function bindEvents() {\n      var _this7 = this;\n\n      _preview2.prototype.bindEvents.call(this);\n\n      this.contentType.dataStore.subscribe(function (state) {\n        var sanitizedContent = (0, _editor.replaceDoubleQuoteWithSingleQuoteWithinVariableDirective)((0, _editor.escapeDoubleQuoteWithinWidgetDirective)(state.content));\n\n        if (sanitizedContent !== state.content) {\n          state.content = sanitizedContent;\n        }\n      }); // After drop of new content type open TinyMCE and focus\n\n      _events.on(\"text:dropAfter\", function (args) {\n        if (args.id === _this7.contentType.id) {\n          _this7.afterRenderDeferred.then(function () {\n            if (_this7.isWysiwygSupported()) {\n              _this7.initWysiwygFromClick(true);\n            }\n          });\n        }\n      });\n    }\n    /**\n     * Adjust textarea's height based on scrollHeight\n     */\n    ;\n\n    _proto.adjustTextareaHeightBasedOnScrollHeight = function adjustTextareaHeightBasedOnScrollHeight() {\n      this.textarea.style.height = \"\";\n      var scrollHeight = this.textarea.scrollHeight;\n      var minHeight = parseInt((0, _jquery)(this.textarea).css(\"min-height\"), 10);\n\n      if (scrollHeight === minHeight) {\n        // leave height at 'auto'\n        return;\n      }\n\n      (0, _jquery)(this.textarea).height(scrollHeight);\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/text/wysiwyg/tinymce/component-initializer.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"mage/adminhtml/wysiwyg/events\"], function (_jquery, _events) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ComponentInitializer = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ComponentInitializer() {}\n\n    var _proto = ComponentInitializer.prototype;\n\n    /**\n     * The editor element\n     */\n\n    /**\n     * The configuration of the wysiwyg content type\n     */\n\n    /**\n     * Initialize the instance\n     *\n     * @param {Wysiwyg} wysiwyg\n     */\n    _proto.initialize = function initialize(wysiwyg) {\n      this.$element = (0, _jquery)(\"#\" + wysiwyg.elementId);\n      this.config = wysiwyg.config;\n      var tinymce = wysiwyg.getAdapter();\n      tinymce.eventBus.attachEventHandler(_events.afterFocus, this.onFocus.bind(this));\n      tinymce.eventBus.attachEventHandler(_events.afterBlur, this.onBlur.bind(this));\n    }\n    /**\n     * Called when tinymce is focused\n     */\n    ;\n\n    _proto.onFocus = function onFocus() {\n      var _this = this;\n\n      // If there isn't enough room for a left-aligned toolbar, right align it\n      if ((0, _jquery)(window).width() < this.$element.offset().left + parseInt(this.config.adapter_config.minToolbarWidth, 10)) {\n        this.$element.addClass(\"_right-aligned-toolbar\");\n      } else {\n        this.$element.removeClass(\"_right-aligned-toolbar\");\n      }\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this.$element.closest(selector).css(\"z-index\", 100);\n      });\n    }\n    /**\n     * Called when tinymce is blurred\n     */\n    ;\n\n    _proto.onBlur = function onBlur() {\n      var _this2 = this;\n\n      _jquery.each(this.config.adapter_config.parentSelectorsToUnderlay, function (i, selector) {\n        _this2.$element.closest(selector).css(\"z-index\", \"\");\n      });\n    };\n\n    return ComponentInitializer;\n  }();\n\n  return ComponentInitializer;\n});\n//# sourceMappingURL=component-initializer.js.map","Magento_PageBuilder/js/content-type/text/wysiwyg/tinymce/config-modifier.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ConfigModifier = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ConfigModifier() {}\n\n    var _proto = ConfigModifier.prototype;\n\n    /**\n     * Initialize the config\n     *\n     * @param {String} contentTypeId\n     * @param {Object} config\n     */\n    _proto.modify = function modify(contentTypeId, config) {\n      if (config.adapter_config.mode === \"inline\") {\n        config.adapter.settings.fixed_toolbar_container = \"#\" + contentTypeId + \" \" + config.adapter.settings.fixed_toolbar_container;\n      }\n    };\n\n    return ConfigModifier;\n  }();\n\n  return ConfigModifier;\n});\n//# sourceMappingURL=config-modifier.js.map","Magento_PageBuilder/js/content-type/video/master.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type/master\"], function (_master) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Master = /*#__PURE__*/function (_master2) {\n    \"use strict\";\n\n    _inheritsLoose(Master, _master2);\n\n    function Master() {\n      return _master2.apply(this, arguments) || this;\n    }\n\n    var _proto = Master.prototype;\n\n    _proto.isHosted = function isHosted(src) {\n      var youtubeRegExp = new RegExp(\"^(?:https?:\\/\\/|\\/\\/)?(?:www\\\\.|m\\\\.)?\" + \"(?:youtu\\\\.be\\/|youtube\\\\.com\\/(?:embed\\/|v\\/|watch\\\\?v=|watch\\\\?.+&v=))([\\\\w-]{11})(?![\\\\w-])\");\n      var vimeoRegExp = new RegExp(\"https?:\\/\\/(?:www\\\\.|player\\\\.)?vimeo.com\\/(?:channels\\/\" + \"(?:\\\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|album\\/(\\\\d+)\\/video\\/|video\\/|)(\\\\d+)(?:$|\\/|\\\\?)\");\n      return vimeoRegExp.test(src) || youtubeRegExp.test(src);\n    };\n\n    return Master;\n  }(_master);\n\n  return Master;\n});\n//# sourceMappingURL=master.js.map","Magento_PageBuilder/js/content-type/video/preview.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type-menu/hide-show-option\", \"Magento_PageBuilder/js/content-type/preview\"], function (_hideShowOption, _preview) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Preview = /*#__PURE__*/function (_preview2) {\n    \"use strict\";\n\n    _inheritsLoose(Preview, _preview2);\n\n    function Preview() {\n      return _preview2.apply(this, arguments) || this;\n    }\n\n    var _proto = Preview.prototype;\n\n    /**\n     * Return an array of options\n     *\n     * @returns {OptionsInterface}\n     */\n    _proto.retrieveOptions = function retrieveOptions() {\n      var options = _preview2.prototype.retrieveOptions.call(this);\n\n      options.hideShow = new _hideShowOption({\n        preview: this,\n        icon: _hideShowOption.showIcon,\n        title: _hideShowOption.showText,\n        action: this.onOptionVisibilityToggle,\n        classes: [\"hide-show-content-type\"],\n        sort: 40\n      });\n      return options;\n    };\n\n    _proto.isHosted = function isHosted(src) {\n      var youtubeRegExp = new RegExp(\"^(?:https?:\\/\\/|\\/\\/)?(?:www\\\\.|m\\\\.)?\" + \"(?:youtu\\\\.be\\/|youtube\\\\.com\\/(?:embed\\/|v\\/|watch\\\\?v=|watch\\\\?.+&v=))([\\\\w-]{11})(?![\\\\w-])\");\n      var vimeoRegExp = new RegExp(\"https?:\\/\\/(?:www\\\\.|player\\\\.)?vimeo.com\\/(?:channels\\/\" + \"(?:\\\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|album\\/(\\\\d+)\\/video\\/|video\\/|)(\\\\d+)(?:$|\\/|\\\\?)\");\n      return vimeoRegExp.test(src) || youtubeRegExp.test(src);\n    }\n    /**\n     * After render callback\n     *\n     * @param {HTMLVideoElement} videoElement\n     * @param {Preview} self\n     */\n    ;\n\n    _proto.onAfterRender = function onAfterRender(videoElement, self) {\n      // Assign muted attribute explicitly due to API issues\n      videoElement.muted = self.data.video.attributes().autoplay;\n    };\n\n    return Preview;\n  }(_preview);\n\n  return Preview;\n});\n//# sourceMappingURL=preview.js.map","Magento_PageBuilder/js/content-type/video/converter/attribute/autoplay.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var VideoSrc = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function VideoSrc() {}\n\n    var _proto = VideoSrc.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value === \"true\" ? value : \"false\";\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {boolean|string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n      return value === \"true\" ? true : null;\n    };\n\n    return VideoSrc;\n  }();\n\n  return VideoSrc;\n});\n//# sourceMappingURL=autoplay.js.map","Magento_PageBuilder/js/content-type/video/converter/attribute/src.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Src = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Src() {}\n\n    var _proto = Src.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      var fileRegExp = new RegExp(\"^(webm:|mp4:|ogv:)\");\n\n      if (fileRegExp.test(value)) {\n        return value.substr(fileRegExp.exec(value)[0].length);\n      }\n\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value === undefined) {\n        return \"\";\n      }\n\n      var youtubeRegExp = new RegExp(\"^(?:https?:\\/\\/|\\/\\/)?(?:www\\\\.|m\\\\.)?\" + \"(?:youtu\\\\.be\\/|youtube\\\\.com\\/(?:embed\\/|v\\/|watch\\\\?v=|watch\\\\?.+&v=))([\\\\w-]{11})(?![\\\\w-])\");\n      var vimeoRegExp = new RegExp(\"https?:\\/\\/(?:www\\\\.|player\\\\.)?vimeo.com\\/(?:channels\\/\" + \"(?:\\\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|album\\/(\\\\d+)\\/video\\/|video\\/|)(\\\\d+)(?:$|\\/|\\\\?)\");\n      var fileRegExp = new RegExp(\"^(?:https:|http:)?\\\\/\\\\/.*[\\\\\\\\\\\\/].+\\\\.(webm|mp4|ogv)(?!\\w)\");\n\n      if (youtubeRegExp.test(value)) {\n        return \"https://www.youtube.com/embed/\" + youtubeRegExp.exec(value)[1];\n      } else if (vimeoRegExp.test(value)) {\n        return \"https://player.vimeo.com/video/\" + vimeoRegExp.exec(value)[3] + \"?title=0&byline=0&portrait=0\";\n      } else if (fileRegExp.test(value)) {\n        var result = fileRegExp.exec(value);\n        return result[1] + \":\" + value;\n      }\n\n      return value;\n    };\n\n    return Src;\n  }();\n\n  return Src;\n});\n//# sourceMappingURL=src.js.map","Magento_PageBuilder/js/content-type/video/converter/attribute/videosrc.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var VideoSrc = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function VideoSrc() {}\n\n    /**\n     * Parse YouTube parameters from given URL and Autoplay setting from UI\n     *\n     * @param url string\n     * @param data DataObject\n     * @returns string\n     * @private\n     */\n    VideoSrc.parseYoutubeGetParams = function parseYoutubeGetParams(url, data) {\n      var acceptableYouTubeParams = [\"rel\", \"controls\", \"autoplay\", \"mute\", \"loop\", \"playlist\", \"cc_lang_pref\", \"cc_load_policy\", \"color\", \"disablekb\", \"end\", \"fs\", \"hl\", \"iv_load_policy\", \"modestbranding\", \"start\"];\n      var a = document.createElement(\"a\");\n      a.href = url;\n      var urlGetParams = {};\n      a.search.slice(a.search.indexOf(\"?\") + 1).split(\"&\").map(function (hash) {\n        var _hash$split = hash.split(\"=\"),\n            key = _hash$split[0],\n            val = _hash$split[1];\n\n        urlGetParams[key] = decodeURIComponent(val);\n      });\n      var filteredGetParams = {};\n\n      for (var _i = 0, _acceptableYouTubePar = acceptableYouTubeParams; _i < _acceptableYouTubePar.length; _i++) {\n        var param = _acceptableYouTubePar[_i];\n\n        if (urlGetParams.hasOwnProperty(param)) {\n          filteredGetParams[param] = urlGetParams[param];\n        }\n      }\n\n      if (data.autoplay === \"true\") {\n        filteredGetParams.autoplay = \"1\";\n        filteredGetParams.mute = \"1\";\n      } else {\n        delete filteredGetParams.autoplay;\n        delete filteredGetParams.mute;\n      }\n\n      var processedGetParams = [];\n\n      for (var _param in filteredGetParams) {\n        if (filteredGetParams.hasOwnProperty(_param)) {\n          processedGetParams.push(encodeURI(_param + \"=\" + filteredGetParams[_param]));\n        }\n      }\n\n      return processedGetParams.length > 0 ? \"?\" + processedGetParams.join(\"&\") : \"\";\n    }\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    ;\n\n    var _proto = VideoSrc.prototype;\n\n    _proto.fromDom = function fromDom(value) {\n      value = value.replace(/\\?autoplay=1&mute=1/g, \"\");\n      value = value.replace(/&autoplay=1&mute=1/g, \"\");\n      value = value.replace(/\\?title=0&byline=0&portrait=0/g, \"\");\n      value = value.replace(/&autoplay=1&autopause=0&muted=1/g, \"\");\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value === undefined) {\n        return \"\";\n      }\n\n      var youtubeRegExp = new RegExp(\"^(?:https?:\\/\\/|\\/\\/)?(?:www\\\\.|m\\\\.)?\" + \"(?:youtu\\\\.be\\/|youtube\\\\.com\\/(?:embed\\/|v\\/|watch\\\\?v=|watch\\\\?.+&v=))([\\\\w-]{11})(?![\\\\w-])\");\n      var vimeoRegExp = new RegExp(\"https?:\\/\\/(?:www\\\\.|player\\\\.)?vimeo.com\\/(?:channels\\/\" + \"(?:\\\\w+\\/)?|groups\\/([^\\/]*)\\/videos\\/|album\\/(\\\\d+)\\/video\\/|video\\/|)(\\\\d+)(?:$|\\/|\\\\?)\");\n\n      if (youtubeRegExp.test(value)) {\n        return \"https://www.youtube.com/embed/\" + youtubeRegExp.exec(value)[1] + VideoSrc.parseYoutubeGetParams(value, data);\n      } else if (vimeoRegExp.test(value)) {\n        return \"https://player.vimeo.com/video/\" + vimeoRegExp.exec(value)[3] + \"?title=0&byline=0&portrait=0\" + (data.autoplay === \"true\" ? \"&autoplay=1&autopause=0&muted=1\" : \"\");\n      }\n\n      return value;\n    };\n\n    return VideoSrc;\n  }();\n\n  return VideoSrc;\n});\n//# sourceMappingURL=videosrc.js.map","Magento_PageBuilder/js/content-type-menu/conditional-remove-option.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type-menu/option\"], function (_option) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ConditionalRemoveOption = /*#__PURE__*/function (_option2) {\n    \"use strict\";\n\n    _inheritsLoose(ConditionalRemoveOption, _option2);\n\n    /**\n     * @param {OptionConfigInterface} config\n     */\n    function ConditionalRemoveOption(config) {\n      var _this;\n\n      _this = _option2.call(this, config) || this;\n      var parentContentType = _this.preview.contentType.parentContentType;\n\n      if (parentContentType.children().length < 2) {\n        _this.isDisabled(true);\n      }\n\n      parentContentType.children.subscribe(function (children) {\n        _this.isDisabled(children.length < 2);\n      });\n      return _this;\n    }\n\n    return ConditionalRemoveOption;\n  }(_option);\n\n  return ConditionalRemoveOption;\n});\n//# sourceMappingURL=conditional-remove-option.js.map","Magento_PageBuilder/js/content-type-menu/edit.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/events\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/config\"], function (_events, _mageUtils, _underscore, _config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Edit = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param {ContentTypeInterface} instance\n     * @param {DataStore} dataStore\n     */\n    function Edit(instance, dataStore) {\n      var _this = this;\n\n      this.instance = instance;\n      this.dataStore = dataStore;\n\n      _events.on(\"form:\" + this.instance.id + \":saveAfter\", function (data) {\n        var viewport = _config.getConfig(\"viewport\");\n\n        var defaultViewport = _config.getConfig(\"defaultViewport\"); // set value to dataStore from default viewport if it is empty\n\n\n        if (defaultViewport !== viewport) {\n          _underscore.each(_this.instance.getViewportFields(viewport, data), function (value, key) {\n            var isEmpty = !_underscore.find(_mageUtils.compare(data[key], _this.instance.dataStores[defaultViewport].get(key)).changes, function (change) {\n              return !_underscore.isEmpty(change.oldValue);\n            });\n\n            if (isEmpty) {\n              _this.instance.dataStores[viewport].set(key, data[key]);\n\n              data[key] = _this.instance.dataStores[defaultViewport].get(key);\n            }\n          });\n        }\n\n        _this.dataStore.setState(_this.filterData(data));\n      });\n    }\n    /**\n     * Open the modal\n     */\n\n\n    var _proto = Edit.prototype;\n\n    _proto.open = function open() {\n      var _this2 = this;\n\n      var contentTypeData = this.dataStore.getState();\n\n      var viewport = _config.getConfig(\"viewport\");\n\n      var defaultViewport = _config.getConfig(\"defaultViewport\"); // set empty value if it the same in default viewport\n\n\n      if (defaultViewport !== viewport) {\n        _underscore.each(this.instance.getViewportFields(viewport, contentTypeData), function (value, key) {\n          if (_mageUtils.compare(contentTypeData[key], _this2.instance.dataStores.desktop.get(key)).equal) {\n            contentTypeData[key] = undefined;\n          }\n        });\n      }\n\n      _events.trigger(\"contentType:editBefore\", {\n        contentType: this.instance\n      });\n\n      _events.trigger(\"form:renderAfter\", {\n        data: contentTypeData,\n        appearances: this.instance.config.appearances,\n        defaultNamespace: this.getDefaultNamespaceForm(),\n        id: this.instance.id,\n        namespace: this.getFormNamespace(contentTypeData),\n        title: this.instance.config.label\n      });\n    }\n    /**\n     * Flip flop to JSON and back again to ensure all data received from the form is serializable. Magento by default\n     * adds functions into some basic types which cannot be serialized when calling PostMessage.\n     *\n     * @param {DataObject} data\n     * @returns {DataObject}\n     */\n    ;\n\n    _proto.filterData = function filterData(data) {\n      return JSON.parse(JSON.stringify(data));\n    }\n    /**\n     * Determine the form namespace based on the currently set appearance\n     *\n     * @param {DataObject} contentTypeData\n     * @returns {string}\n     */\n    ;\n\n    _proto.getFormNamespace = function getFormNamespace(contentTypeData) {\n      var viewport = this.instance.preview.viewport();\n      var currentAppearance = this.dataStore.get(\"appearance\");\n      var appearance = this.instance.config.appearances[currentAppearance];\n      var breakpoints = appearance.breakpoints;\n      var formNamespace = this.getDefaultNamespaceForm(); // Use the default form unless a custom one is defined\n\n      if (breakpoints && breakpoints[viewport] && breakpoints[viewport].form) {\n        formNamespace = breakpoints[viewport].form;\n      } else if (!_underscore.isUndefined(appearance.form)) {\n        formNamespace = appearance.form;\n      }\n\n      return formNamespace;\n    }\n    /**\n     * Determine the form default namespace based on the currently set appearance and breakpoint\n     *\n     * @returns {string}\n     */\n    ;\n\n    _proto.getDefaultNamespaceForm = function getDefaultNamespaceForm() {\n      var viewport = this.instance.preview.viewport();\n      var breakpoints = this.instance.config.breakpoints;\n      var formNamespace = this.instance.config.form;\n\n      if (breakpoints && breakpoints[viewport] && breakpoints[viewport].form) {\n        formNamespace = breakpoints[viewport].form;\n      }\n\n      return formNamespace;\n    };\n\n    return Edit;\n  }();\n\n  return Edit;\n});\n//# sourceMappingURL=edit.js.map","Magento_PageBuilder/js/content-type-menu/hide-show-option.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"mage/translate\", \"Magento_PageBuilder/js/content-type-menu/option\"], function (_translate, _option) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var HideShowOption = /*#__PURE__*/function (_option2) {\n    \"use strict\";\n\n    _inheritsLoose(HideShowOption, _option2);\n\n    /**\n     * @param {OptionConfigInterface} options\n     */\n    function HideShowOption(options) {\n      var _this;\n\n      _this = _option2.call(this, options) || this; // Modify the icon when changes are made to display in the data store\n\n      _this.preview.contentType.dataStore.subscribe(_this.onDisplayChange.bind(_assertThisInitialized(_this)), \"display\");\n\n      return _this;\n    }\n    /**\n     * On display change update the title and icon\n     *\n     * @param {DataObject} state\n     */\n\n\n    var _proto = HideShowOption.prototype;\n\n    _proto.onDisplayChange = function onDisplayChange(state) {\n      var display = !!state.display;\n\n      if (display) {\n        this.icon(HideShowOption.hideIcon);\n        this.title(HideShowOption.hideText);\n      } else {\n        this.icon(HideShowOption.showIcon);\n        this.title(HideShowOption.showText);\n      }\n    };\n\n    return HideShowOption;\n  }(_option);\n\n  HideShowOption.showText = (0, _translate)(\"Show\");\n  HideShowOption.showIcon = \"<i class='icon-pagebuilder-show'></i>\";\n  HideShowOption.hideText = (0, _translate)(\"Hide\");\n  HideShowOption.hideIcon = \"<i class='icon-pagebuilder-hide'></i>\";\n  return HideShowOption;\n});\n//# sourceMappingURL=hide-show-option.js.map","Magento_PageBuilder/js/content-type-menu/option.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\ndefine([\"knockout\"], function (_knockout) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Option = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param {OptionConfigInterface} config\n     */\n    function Option(config) {\n      var _this = this;\n\n      this.icon = _knockout.observable(\"\");\n      this.title = _knockout.observable(\"\");\n      this.classes = _knockout.observable({});\n      this.isDisabled = _knockout.observable(false);\n      this.config = config;\n      this.preview = config.preview;\n      this.icon(config.icon);\n      this.title(config.title);\n      this.code = config.code;\n      this.sort = config.sort || 0;\n      this.customTemplate = config.template; // Generate an array of classes for KO to consume\n\n      var koClasses = {};\n\n      if (config.classes && config.classes.length > 0) {\n        config.classes.forEach(function (cssClass) {\n          koClasses[cssClass] = true;\n        });\n      } // Always add a disabled class which tracks whether this option is disabled\n\n\n      koClasses.disabled = this.isDisabled;\n      this.classes(koClasses); // If no action is supplied pass an empty function, this is called within the context of the preview\n\n      var action = config.action ? config.action : function () {\n        return;\n      };\n\n      this.action = function () {\n        if (!_this.isDisabled()) {\n          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n            args[_key] = arguments[_key];\n          }\n\n          action.apply(_this.preview, args);\n        }\n      };\n    }\n\n    _createClass(Option, [{\n      key: \"template\",\n      get: function get() {\n        return this.customTemplate || null;\n      }\n    }]);\n\n    return Option;\n  }();\n\n  return Option;\n});\n//# sourceMappingURL=option.js.map","Magento_PageBuilder/js/content-type-menu/title-option.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\ndefine([\"Magento_PageBuilder/js/content-type-menu/option\"], function (_option) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var TitleOption = /*#__PURE__*/function (_option2) {\n    \"use strict\";\n\n    _inheritsLoose(TitleOption, _option2);\n\n    /**\n     * @param {OptionConfigInterface} options\n     */\n    function TitleOption(options) {\n      var _this;\n\n      _this = _option2.call(this, options) || this; // Modify the icon when changes are made to display in the data store\n\n      _this.preview.displayLabel.subscribe(function (label) {\n        _this.title(label);\n      });\n\n      return _this;\n    }\n\n    return TitleOption;\n  }(_option);\n\n  return TitleOption;\n});\n//# sourceMappingURL=title-option.js.map","Magento_PageBuilder/js/converter/converter-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=converter-interface.js.map","Magento_PageBuilder/js/converter/converter-pool-factory.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/loader\", \"Magento_PageBuilder/js/converter/converter-pool\"], function (_config, _loader, _converterPool) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create a new instance of converter pool\n   */\n  function create(contentType) {\n    var config = _config.getContentTypeConfig(contentType);\n\n    var converters = [];\n    var appearanceName;\n\n    for (var _i = 0, _Object$keys = Object.keys(config.appearances); _i < _Object$keys.length; _i++) {\n      appearanceName = _Object$keys[_i];\n      var appearance = config.appearances[appearanceName];\n\n      if (appearance !== undefined && appearance.elements !== undefined) {\n        var elementName = void 0;\n\n        for (var _i2 = 0, _Object$keys2 = Object.keys(appearance.elements); _i2 < _Object$keys2.length; _i2++) {\n          elementName = _Object$keys2[_i2];\n\n          if (appearance.elements[elementName].style !== undefined) {\n            for (var _iterator = _createForOfIteratorHelperLoose(appearance.elements[elementName].style), _step; !(_step = _iterator()).done;) {\n              var propertyConfig = _step.value;\n\n              if (!!propertyConfig.converter && converters.indexOf(propertyConfig.converter) === -1 && !_converterPool.get(propertyConfig.converter)) {\n                converters.push(propertyConfig.converter);\n              }\n\n              if (!!propertyConfig.preview_converter && converters.indexOf(propertyConfig.preview_converter) === -1 && !_converterPool.get(propertyConfig.preview_converter)) {\n                converters.push(propertyConfig.preview_converter);\n              }\n            }\n          }\n\n          if (appearance.elements[elementName].attributes !== undefined) {\n            for (var _iterator2 = _createForOfIteratorHelperLoose(appearance.elements[elementName].attributes), _step2; !(_step2 = _iterator2()).done;) {\n              var attributeConfig = _step2.value;\n\n              if (!!attributeConfig.converter && converters.indexOf(attributeConfig.converter) === -1 && !_converterPool.get(attributeConfig.converter)) {\n                converters.push(attributeConfig.converter);\n              }\n\n              if (!!attributeConfig.preview_converter && converters.indexOf(attributeConfig.preview_converter) === -1 && !_converterPool.get(attributeConfig.preview_converter)) {\n                converters.push(attributeConfig.preview_converter);\n              }\n            }\n          }\n\n          if (appearance.elements[elementName].html !== undefined) {\n            var htmlConfig = appearance.elements[elementName].html;\n\n            if (!!htmlConfig.converter && converters.indexOf(htmlConfig.converter) === -1 && !_converterPool.get(htmlConfig.converter)) {\n              converters.push(htmlConfig.converter);\n            }\n\n            if (!!htmlConfig.preview_converter && converters.indexOf(htmlConfig.preview_converter) === -1 && !_converterPool.get(htmlConfig.preview_converter)) {\n              converters.push(htmlConfig.preview_converter);\n            }\n          }\n        }\n      }\n    }\n\n    return new Promise(function (resolve) {\n      (0, _loader)(converters, function () {\n        for (var _len = arguments.length, loadedConverters = new Array(_len), _key = 0; _key < _len; _key++) {\n          loadedConverters[_key] = arguments[_key];\n        }\n\n        for (var i = 0; i < converters.length; i++) {\n          _converterPool.register(converters[i], new loadedConverters[i]());\n        }\n\n        resolve(_converterPool);\n      });\n    });\n  }\n\n  return create;\n});\n//# sourceMappingURL=converter-pool-factory.js.map","Magento_PageBuilder/js/converter/converter-pool.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ConverterPool = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function ConverterPool() {\n      this.converters = {};\n    }\n\n    var _proto = ConverterPool.prototype;\n\n    /**\n     * Retrieve a converter from the pool\n     *\n     * @param {string} name\n     * @returns {ConverterInterface}\n     */\n    _proto.get = function get(name) {\n      return this.converters[name] !== undefined ? this.converters[name] : null;\n    }\n    /**\n     * Register a new converter into the pool\n     *\n     * @param {string} name\n     * @param {ConverterInterface} converter\n     */\n    ;\n\n    _proto.register = function register(name, converter) {\n      this.converters[name] = converter;\n    };\n\n    return ConverterPool;\n  }();\n\n  var _default = new ConverterPool();\n\n  return _default;\n});\n//# sourceMappingURL=converter-pool.js.map","Magento_PageBuilder/js/converter/attribute/link-href.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var CreateValueForHref = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function CreateValueForHref() {\n      this.widgetParamsByLinkType = {\n        category: {\n          type: \"Magento\\\\Catalog\\\\Block\\\\Category\\\\Widget\\\\Link\",\n          id_path: \"category/:href\",\n          template: \"Magento_PageBuilder::widget/link_href.phtml\",\n          type_name: \"Catalog Category Link\"\n        },\n        product: {\n          type: \"Magento\\\\Catalog\\\\Block\\\\Product\\\\Widget\\\\Link\",\n          id_path: \"product/:href\",\n          template: \"Magento_PageBuilder::widget/link_href.phtml\",\n          type_name: \"Catalog Product Link\"\n        },\n        page: {\n          type: \"Magento\\\\Cms\\\\Block\\\\Widget\\\\Page\\\\Link\",\n          page_id: \":href\",\n          template: \"Magento_PageBuilder::widget/link_href.phtml\",\n          type_name: \"CMS Page Link\"\n        }\n      };\n    }\n\n    var _proto = CreateValueForHref.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var link = (0, _object.get)(data, name);\n      var href = \"\";\n\n      if (!link) {\n        return href;\n      }\n\n      var linkType = link.type;\n      var isHrefId = !isNaN(parseInt(link[linkType], 10));\n\n      if (isHrefId && link) {\n        href = this.convertToWidget(link[linkType], linkType);\n      } else if (typeof link[linkType] === \"string\") {\n        href = link[linkType];\n      }\n\n      return href;\n    }\n    /**\n     * @param {string} href\n     * @param {string} linkType\n     * @returns {string}\n     */\n    ;\n\n    _proto.convertToWidget = function convertToWidget(href, linkType) {\n      if (!href || !this.widgetParamsByLinkType[linkType]) {\n        return href;\n      }\n\n      var attributesString = _underscore.map(this.widgetParamsByLinkType[linkType], function (val, key) {\n        return key + \"='\" + val.replace(\":href\", href) + \"'\";\n      }).join(\" \");\n\n      return \"{{widget \" + attributesString + \" }}\";\n    };\n\n    return CreateValueForHref;\n  }();\n\n  return CreateValueForHref;\n});\n//# sourceMappingURL=link-href.js.map","Magento_PageBuilder/js/converter/attribute/link-target.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var CreateValueForTarget = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function CreateValueForTarget() {}\n\n    var _proto = CreateValueForTarget.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (!value) {\n        return \"\";\n      }\n\n      return value.setting ? \"_blank\" : \"\";\n    };\n\n    return CreateValueForTarget;\n  }();\n\n  return CreateValueForTarget;\n});\n//# sourceMappingURL=link-target.js.map","Magento_PageBuilder/js/converter/attribute/link-type.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var CreateValueForLinkType = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function CreateValueForLinkType() {}\n\n    var _proto = CreateValueForLinkType.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n      return value && value.type ? value.type : \"default\";\n    };\n\n    return CreateValueForLinkType;\n  }();\n\n  return CreateValueForLinkType;\n});\n//# sourceMappingURL=link-type.js.map","Magento_PageBuilder/js/converter/attribute/src.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/image\", \"Magento_PageBuilder/js/utils/object\", \"Magento_PageBuilder/js/utils/url\"], function (_config, _image, _object, _url) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Src = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Src() {}\n\n    var _proto = Src.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (!value) {\n        return \"\";\n      }\n\n      return (0, _image.decodeUrl)(value);\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value[0] === undefined || value[0].url === undefined) {\n        return \"\";\n      }\n\n      var imageUrl = value[0].url;\n      var mediaUrl = (0, _url.convertUrlToPathIfOtherUrlIsOnlyAPath)(_config.getConfig(\"media_url\"), imageUrl);\n      var mediaPath = imageUrl.split(mediaUrl);\n      return \"{{media url=\" + mediaPath[1] + \"}}\";\n    };\n\n    return Src;\n  }();\n\n  return Src;\n});\n//# sourceMappingURL=src.js.map","Magento_PageBuilder/js/converter/attribute/video-overlay-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var OverlayColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayColor() {}\n\n    var _proto = OverlayColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value === \"transparent\" ? \"\" : value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      if (data.video_overlay_color) {\n        return data.video_overlay_color.toString();\n      }\n\n      return \"\";\n    };\n\n    return OverlayColor;\n  }();\n\n  return OverlayColor;\n});\n//# sourceMappingURL=video-overlay-color.js.map","Magento_PageBuilder/js/converter/attribute/preview/src.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Src = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Src() {}\n\n    var _proto = Src.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value && typeof value[0] === \"object\") {\n        return value[0].url;\n      }\n\n      return \"\";\n    };\n\n    return Src;\n  }();\n\n  return Src;\n});\n//# sourceMappingURL=src.js.map","Magento_PageBuilder/js/converter/attribute/preview/store-id.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\"], function (_jquery) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var StoreId = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function StoreId() {}\n\n    var _proto = StoreId.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      if (typeof data[name] !== \"string\") {\n        return \"\";\n      }\n\n      var storeId = (0, _jquery)('[data-role=\"store-view-id\"]').val() || \"0\";\n      return data[name].replace(/}}$/, \" store_id=\\\"\" + storeId + \"\\\"}}\");\n    };\n\n    return StoreId;\n  }();\n\n  return StoreId;\n});\n//# sourceMappingURL=store-id.js.map","Magento_PageBuilder/js/converter/html/decode.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/directives\", \"Magento_PageBuilder/js/utils/object\"], function (_directives, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Decode = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Decode() {}\n\n    var _proto = Decode.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {string} value\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      // Convert the encoded string back to HTML without executing\n      var html = new DOMParser().parseFromString(value, \"text/html\");\n      return html.body.textContent;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {Object} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return (0, _directives.removeQuotesInMediaDirectives)((0, _object.get)(data, name));\n    };\n\n    return Decode;\n  }();\n\n  return Decode;\n});\n//# sourceMappingURL=decode.js.map","Magento_PageBuilder/js/converter/html/directive.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/directives\", \"Magento_PageBuilder/js/utils/editor\", \"Magento_PageBuilder/js/utils/object\"], function (_directives, _editor, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Directives = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Directives() {}\n\n    var _proto = Directives.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {string} value\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {Object} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return (0, _editor.encodeContent)((0, _directives.convertMediaDirectivesToUrls)((0, _directives.removeQuotesInMediaDirectives)((0, _object.get)(data, name))));\n    };\n\n    return Directives;\n  }();\n\n  return Directives;\n});\n//# sourceMappingURL=directive.js.map","Magento_PageBuilder/js/converter/html/tag-escaper.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var TagEscaper = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function TagEscaper() {}\n\n    var _proto = TagEscaper.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {string} value\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      var result = (0, _underscore.unescape)(value); // Have to do a manual &nbsp; replace since underscore un-escape does not un-escape &nbsp;\n\n      return result.replace(/&nbsp;/g, String.fromCharCode(160));\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {Object} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return (0, _underscore.escape)((0, _object.get)(data, name));\n    };\n\n    return TagEscaper;\n  }();\n\n  return TagEscaper;\n});\n//# sourceMappingURL=tag-escaper.js.map","Magento_PageBuilder/js/converter/style/background-image.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var BackgroundImage = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function BackgroundImage() {}\n\n    var _proto = BackgroundImage.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return null;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return null;\n    };\n\n    return BackgroundImage;\n  }();\n\n  return BackgroundImage;\n});\n//# sourceMappingURL=background-image.js.map","Magento_PageBuilder/js/converter/style/border-style.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var BorderStyleDefault = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function BorderStyleDefault() {}\n\n    var _proto = BorderStyleDefault.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (!value) {\n        return \"_default\";\n      }\n\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value && value !== \"_default\") {\n        return value;\n      }\n    };\n\n    return BorderStyleDefault;\n  }();\n\n  return BorderStyleDefault;\n});\n//# sourceMappingURL=border-style.js.map","Magento_PageBuilder/js/converter/style/border-width.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var BorderWidth = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function BorderWidth() {}\n\n    var _proto = BorderWidth.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value === \"initial\" ? \"\" : value.replace(\"px\", \"\");\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value) {\n        return value + \"px\";\n      }\n    };\n\n    return BorderWidth;\n  }();\n\n  return BorderWidth;\n});\n//# sourceMappingURL=border-width.js.map","Magento_PageBuilder/js/converter/style/color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Color = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Color() {}\n\n    var _proto = Color.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (value === \"default\" || value === \"initial\" || value === \"\") {\n        value = \"\";\n      } else {\n        var regexp = /(\\d{0,3}),\\s(\\d{0,3}),\\s(\\d{0,3})/;\n        var matches = regexp.exec(value);\n\n        if (matches) {\n          value = \"#\" + this.fromIntToHex(parseInt(matches[1], 10)) + this.fromIntToHex(parseInt(matches[2], 10)) + this.fromIntToHex(parseInt(matches[3], 10));\n        }\n      }\n\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return (0, _object.get)(data, name, \"\");\n    }\n    /**\n     * Convert from int to hex\n     *\n     * @param {number} value\n     * @returns {string}\n     */\n    ;\n\n    _proto.fromIntToHex = function fromIntToHex(value) {\n      var hex = value.toString(16);\n      return hex.length === 1 ? \"0\" + hex : hex;\n    };\n\n    return Color;\n  }();\n\n  return Color;\n});\n//# sourceMappingURL=color.js.map","Magento_PageBuilder/js/converter/style/display.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Display = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Display() {}\n\n    var _proto = Display.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return !(value === \"none\");\n    }\n    /**\n     * Convert value to knockout format, we only provide a none property if we intend for the content type to be hidden,\n     * otherwise we let the original display property handle the display of the content type.\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (!_underscore.isUndefined(value) && value === false) {\n        return \"none\";\n      }\n\n      return;\n    };\n\n    return Display;\n  }();\n\n  return Display;\n});\n//# sourceMappingURL=display.js.map","Magento_PageBuilder/js/converter/style/margins.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Margins = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Margins() {}\n\n    var _proto = Margins.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (undefined !== value.margin) {\n        return {\n          margin: {\n            top: value.margin.top.replace(\"px\", \"\"),\n            left: value.margin.left.replace(\"px\", \"\"),\n            right: value.margin.right.replace(\"px\", \"\"),\n            bottom: value.margin.bottom.replace(\"px\", \"\")\n          }\n        };\n      }\n\n      return {};\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.margin) {\n        result.marginLeft = value.margin.left ? value.margin.left + \"px\" : \"\";\n        result.marginTop = value.margin.top ? value.margin.top + \"px\" : \"\";\n        result.marginRight = value.margin.right ? value.margin.right + \"px\" : \"\";\n        result.marginBottom = value.margin.bottom ? value.margin.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Margins;\n  }();\n\n  return Margins;\n});\n//# sourceMappingURL=margins.js.map","Magento_PageBuilder/js/converter/style/min-height.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var MinHeight = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function MinHeight() {}\n\n    var _proto = MinHeight.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value.indexOf(\"calc\") !== -1 ? value.substring(5, value.length - 1) : value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n      return value.split(/\\+|\\-|\\*|\\//).length > 1 ? \"calc(\" + (0, _object.get)(data, name) + \")\" : value;\n    };\n\n    return MinHeight;\n  }();\n\n  return MinHeight;\n});\n//# sourceMappingURL=min-height.js.map","Magento_PageBuilder/js/converter/style/overlay-border-radius.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Takes difference of border width from border radius to conform snugly to edges of wrapper border\n   *\n   * @api\n   */\n  var OverlayBorderRadius = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function OverlayBorderRadius() {}\n\n    var _proto = OverlayBorderRadius.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var borderRadius = data.border_radius ? parseInt(data.border_radius, 10) : 0;\n      var borderWidth = data.border_width ? parseInt(data.border_width, 10) : 0;\n\n      if (borderRadius <= borderWidth) {\n        return \"0\";\n      }\n\n      return borderRadius - borderWidth + \"px\";\n    };\n\n    return OverlayBorderRadius;\n  }();\n\n  return OverlayBorderRadius;\n});\n//# sourceMappingURL=overlay-border-radius.js.map","Magento_PageBuilder/js/converter/style/paddings.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Paddings = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Paddings() {}\n\n    var _proto = Paddings.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (undefined !== value.padding) {\n        return {\n          padding: {\n            top: value.padding.top.replace(\"px\", \"\"),\n            left: value.padding.left.replace(\"px\", \"\"),\n            right: value.padding.right.replace(\"px\", \"\"),\n            bottom: value.padding.bottom.replace(\"px\", \"\")\n          }\n        };\n      }\n\n      return {};\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {string} name\n     * @param {DataObject} data\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var result = {};\n      var value = (0, _object.get)(data, name);\n\n      if (value && _underscore.isString(value)) {\n        value = JSON.parse(value);\n      }\n\n      if (value && undefined !== value.padding) {\n        result.paddingLeft = value.padding.left ? value.padding.left + \"px\" : \"\";\n        result.paddingTop = value.padding.top ? value.padding.top + \"px\" : \"\";\n        result.paddingRight = value.padding.right ? value.padding.right + \"px\" : \"\";\n        result.paddingBottom = value.padding.bottom ? value.padding.bottom + \"px\" : \"\";\n      }\n\n      return result;\n    };\n\n    return Paddings;\n  }();\n\n  return Paddings;\n});\n//# sourceMappingURL=paddings.js.map","Magento_PageBuilder/js/converter/style/remove-px.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var RemovePx = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function RemovePx() {}\n\n    var _proto = RemovePx.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value.replace(\"px\", \"\");\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value) {\n        return value + \"px\";\n      }\n    };\n\n    return RemovePx;\n  }();\n\n  return RemovePx;\n});\n//# sourceMappingURL=remove-px.js.map","Magento_PageBuilder/js/converter/style/video-overlay-color.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var VideoOverlayColor = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function VideoOverlayColor() {}\n\n    var _proto = VideoOverlayColor.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value !== \"\" && value !== undefined) {\n        return value;\n      }\n\n      return \"transparent\";\n    };\n\n    return VideoOverlayColor;\n  }();\n\n  return VideoOverlayColor;\n});\n//# sourceMappingURL=video-overlay-color.js.map","Magento_PageBuilder/js/converter/style/width.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Subtract margin from width to ensure adjacent elements do not\n   * move or resize when positive or negative margins are present\n   *\n   * @api\n   */\n  var Width = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Width() {}\n\n    var _proto = Width.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      if (value.indexOf(\"calc\") !== -1) {\n        return value.split(\"%\")[0].split(\"(\")[1] + \"%\";\n      }\n\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string | object}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      if (data[name] && data[name] !== \"\") {\n        var marginsAndPadding = data.margins_and_padding || {};\n        var margins = marginsAndPadding.margin || \"\";\n        var marginLeft = margins.left ? parseInt(margins.left, 10) : 0;\n        var marginRight = margins.right ? parseInt(margins.right, 10) : 0;\n\n        if (marginLeft === 0 && marginRight === 0) {\n          return data[name].toString();\n        }\n\n        return \"calc(\" + data[name].toString() + \" - \" + (marginLeft + marginRight) + \"px)\";\n      }\n    };\n\n    return Width;\n  }();\n\n  return Width;\n});\n//# sourceMappingURL=width.js.map","Magento_PageBuilder/js/converter/style/preview/background-image.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var BackgroundImage = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function BackgroundImage() {}\n\n    var _proto = BackgroundImage.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return value;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      var value = (0, _object.get)(data, name);\n\n      if (value && typeof value[0] === \"object\") {\n        return \"url(\" + value[0].url + \")\";\n      }\n\n      return \"\";\n    };\n\n    return BackgroundImage;\n  }();\n\n  return BackgroundImage;\n});\n//# sourceMappingURL=background-image.js.map","Magento_PageBuilder/js/converter/style/preview/display.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Display = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Display() {}\n\n    var _proto = Display.prototype;\n\n    /**\n     * Ensure the display none property doesn't persist to the preview\n     *\n     * @param value string\n     * @returns {string | object}\n     */\n    _proto.fromDom = function fromDom(value) {\n      return;\n    }\n    /**\n     * Ensure the display none property doesn't persist to the preview\n     *\n     * @param name string\n     * @param data Object\n     * @returns {string}\n     */\n    ;\n\n    _proto.toDom = function toDom(name, data) {\n      return;\n    };\n\n    return Display;\n  }();\n\n  return Display;\n});\n//# sourceMappingURL=display.js.map","Magento_PageBuilder/js/drag-drop/drop-indicators.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/create-stylesheet\", \"Magento_PageBuilder/js/drag-drop/matrix\"], function (_createStylesheet, _matrix) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var headDropIndicatorStyles;\n  /**\n   * Show the drop indicators for a specific content type\n   *\n   * We do this by creating a style sheet and injecting it into the head. It's dramatically quicker to allow the browsers\n   * CSS engine to display these for us than manually iterating through the DOM and applying a class to the elements.\n   *\n   * @param {string} contentType\n   * @param {string} stageId\n   * @returns {HTMLStyleElement}\n   */\n\n  function showDropIndicators(contentType, stageId) {\n    var acceptedContainers = (0, _matrix.getContainersFor)(contentType);\n\n    if (acceptedContainers.length > 0) {\n      var _ref;\n\n      var classNames = acceptedContainers.map(function (container) {\n        return \"#\" + stageId + \" .content-type-container.\" + container + \"-container > .pagebuilder-drop-indicator, \" + (\"#\" + stageId + \" .pagebuilder-content-type.type-container.empty-container > .content-type-container.\") + (container + \"-container:before\");\n      });\n      var styles = (0, _createStylesheet.createStyleSheet)((_ref = {}, _ref[classNames.join(\", \")] = {\n        opacity: 1,\n        visibility: \"visible\"\n      }, _ref));\n      document.head.appendChild(styles);\n      headDropIndicatorStyles = styles;\n      return styles;\n    }\n  }\n  /**\n   * Hide the drop indicators\n   */\n\n\n  function hideDropIndicators() {\n    if (headDropIndicatorStyles) {\n      headDropIndicatorStyles.remove();\n      headDropIndicatorStyles = null;\n    }\n  }\n\n  return {\n    showDropIndicators: showDropIndicators,\n    hideDropIndicators: hideDropIndicators\n  };\n});\n//# sourceMappingURL=drop-indicators.js.map","Magento_PageBuilder/js/drag-drop/matrix.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/config\"], function (_underscore, _config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var allowedParents = {};\n  /**\n   * Build a matrix of which containers each content type can go into, these are determined by the allowed_parents\n   * node within the content types configuration\n   */\n\n  function generateAllowedParents() {\n    _underscore.values(_config.getConfig(\"content_types\")).forEach(function (contentType) {\n      allowedParents[contentType.name] = contentType.allowed_parents.slice();\n    });\n  }\n  /**\n   * Retrieve the containers a specific content type can be contained in\n   *\n   * @param {string} contentType\n   * @returns {any}\n   */\n\n\n  function getContainersFor(contentType) {\n    if (allowedParents[contentType]) {\n      return allowedParents[contentType];\n    }\n\n    return [];\n  }\n  /**\n   * Generate classes of containers the content type is allowed within\n   *\n   * @param {string} contentType\n   * @param {string} stageId\n   * @returns {string}\n   */\n\n\n  function getAllowedContainersClasses(contentType, stageId) {\n    return getContainersFor(contentType).map(function (value) {\n      return \"#\" + stageId + \" .content-type-container.\" + value + \"-container\";\n    }).join(\", \");\n  }\n  /**\n   * @api\n   */\n\n\n  return {\n    generateAllowedParents: generateAllowedParents,\n    getContainersFor: getContainersFor,\n    getAllowedContainersClasses: getAllowedContainersClasses\n  };\n});\n//# sourceMappingURL=matrix.js.map","Magento_PageBuilder/js/drag-drop/move-content-type.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\", \"Magento_PageBuilder/js/events\"], function (_knockout, _events) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Move a content type to a new index, with the option to move to a new container\n   *\n   * @param {ContentTypeInterface | ContentTypeCollectionInterface} contentType\n   * @param {number} targetIndex\n   * @param {ContentTypeCollectionInterface} targetParent\n   */\n  function moveContentType(contentType, targetIndex, targetParent) {\n    if (targetParent === void 0) {\n      targetParent = null;\n    }\n\n    var sourceParent = contentType.parentContentType;\n    var sourceIndex = contentType.parentContentType.children().indexOf(contentType);\n    var sourceParentChildren = sourceParent.getChildren(); // Trigger our block move event\n\n    _events.trigger(\"contentType:moveBefore\", {\n      contentType: contentType,\n      sourceParent: sourceParent,\n      targetParent: targetParent,\n      targetIndex: targetIndex,\n      stageId: contentType.stageId\n    });\n\n    _events.trigger(contentType.config.name + \":moveBefore\", {\n      contentType: contentType,\n      sourceParent: sourceParent,\n      targetParent: targetParent,\n      targetIndex: targetIndex,\n      stageId: contentType.stageId\n    });\n\n    if (targetParent && sourceParent !== targetParent) {\n      contentType.parentContentType = targetParent; // Handle dragging between sortable elements\n\n      sourceParentChildren.splice(sourceIndex, 1);\n      targetParent.getChildren().splice(targetIndex, 0, contentType);\n    } else {\n      // Retrieve the children from the source parent\n      var children = _knockout.utils.unwrapObservable(sourceParentChildren); // Inform KO that this value is about to mutate\n\n\n      if (sourceParentChildren.valueWillMutate) {\n        sourceParentChildren.valueWillMutate();\n      } // Perform the mutation\n\n\n      children.splice(sourceIndex, 1);\n      children.splice(targetIndex, 0, contentType); // Inform KO that the mutation is complete\n\n      if (sourceParentChildren.valueHasMutated) {\n        sourceParentChildren.valueHasMutated();\n      }\n    } // Process any deferred bindings\n\n\n    if (_knockout.processAllDeferredBindingUpdates) {\n      _knockout.processAllDeferredBindingUpdates();\n    } // Trigger our content type move event\n\n\n    _events.trigger(\"contentType:moveAfter\", {\n      contentType: contentType,\n      sourceParent: sourceParent,\n      targetParent: targetParent,\n      targetIndex: targetIndex,\n      stageId: contentType.stageId\n    });\n\n    _events.trigger(contentType.config.name + \":moveAfter\", {\n      contentType: contentType,\n      sourceParent: sourceParent,\n      targetParent: targetParent,\n      targetIndex: targetIndex,\n      stageId: contentType.stageId\n    });\n  }\n\n  return {\n    moveContentType: moveContentType\n  };\n});\n//# sourceMappingURL=move-content-type.js.map","Magento_PageBuilder/js/drag-drop/registry.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var draggedContentTypeConfig;\n  /**\n   * Set the current dragged blocks config into the registry\n   *\n   * @param {ContentTypeConfigInterface} config\n   */\n\n  function setDraggedContentTypeConfig(config) {\n    draggedContentTypeConfig = config;\n  }\n  /**\n   * Retrieve the dragged blocks config\n   *\n   * @returns {ContentTypeConfigInterface}\n   */\n\n\n  function getDraggedContentTypeConfig() {\n    return draggedContentTypeConfig;\n  }\n\n  return {\n    setDraggedContentTypeConfig: setDraggedContentTypeConfig,\n    getDraggedContentTypeConfig: getDraggedContentTypeConfig\n  };\n});\n//# sourceMappingURL=registry.js.map","Magento_PageBuilder/js/drag-drop/sortable.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"knockout\", \"Magento_PageBuilder/js/events\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/drag-drop/drop-indicators\", \"Magento_PageBuilder/js/drag-drop/matrix\", \"Magento_PageBuilder/js/drag-drop/move-content-type\", \"Magento_PageBuilder/js/drag-drop/registry\"], function (_jquery, _knockout, _events, _contentTypeFactory, _dropIndicators, _matrix, _moveContentType, _registry) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * The class used when hiding a content type\n   * @type {string}\n   */\n  var hiddenClass = \".pagebuilder-content-type-hidden\";\n  /**\n   * Return the sortable options for an instance which requires sorting / dropping functionality\n   *\n   * @param {Preview} preview\n   * @returns {JQueryUI.SortableOptions | any}\n   */\n\n  function getSortableOptions(preview) {\n    return {\n      cursor: \"-webkit-grabbing\",\n      tolerance: \"pointer\",\n      helper: function helper(event, item) {\n        var helper = (0, _jquery)(item).clone();\n        helper.css({\n          pointerEvents: \"none\"\n        });\n        return helper[0];\n      },\n      appendTo: document.body,\n      placeholder: {\n        element: function element() {\n          return (0, _jquery)(\"<div />\").addClass(\"pagebuilder-sortable-placeholder\")[0];\n        },\n        update: function update() {\n          return;\n        }\n      },\n      handle: \".move-structural\",\n      items: \"> .pagebuilder-content-type-wrapper\",\n      start: function start() {\n        onSortStart.apply(this, [preview].concat(Array.prototype.slice.call(arguments)));\n      },\n      sort: function sort() {\n        onSort.apply(this, [preview].concat(Array.prototype.slice.call(arguments)));\n      },\n      receive: function receive() {\n        onSortReceive.apply(this, [preview].concat(Array.prototype.slice.call(arguments)));\n      },\n      update: function update() {\n        onSortUpdate.apply(this, [preview].concat(Array.prototype.slice.call(arguments)));\n      },\n      stop: function stop() {\n        onSortStop.apply(this, [preview].concat(Array.prototype.slice.call(arguments)));\n      }\n    };\n  }\n  /**\n   * Get the stage ID from the preview\n   *\n   * @param {Preview | Stage} preview\n   * @returns {string}\n   */\n\n\n  function getPreviewStageIdProxy(preview) {\n    return preview.contentType.stageId;\n  }\n  /**\n   * Retrieve the contentType from the preview\n   *\n   * @param {Preview | Stage} instance\n   * @returns {any}\n   */\n\n\n  function getcontentTypeProxy(instance) {\n    return instance.contentType;\n  }\n\n  var sortedContentType;\n  /**\n   * On sort start record the item being sorted\n   *\n   * @param {Preview} preview\n   * @param {Event} event\n   * @param {JQueryUI.SortableUIParams} ui\n   */\n\n  function onSortStart(preview, event, ui) {\n    // Verify we're sorting an already created item\n    if (ui.item.hasClass(\"pagebuilder-content-type-wrapper\")) {\n      _events.trigger(\"stage:interactionStart\");\n\n      var contentTypeInstance = _knockout.dataFor(ui.item[0]);\n\n      if (contentTypeInstance) {\n        // Ensure the original item is displayed but with reduced opacity\n        ui.item.css(\"display\", \"block\").addClass(\"pagebuilder-sorting-original\");\n        (0, _jquery)(\".pagebuilder-drop-indicator.hidden-drop-indicator\").css(\"display\", \"block\").removeClass(\"hidden-drop-indicator\"); // If we're the first item in the container we need to hide the first drop indicator\n\n        if (contentTypeInstance.parentContentType.getChildren().indexOf(contentTypeInstance) === 0) {\n          ui.item.prev(\".pagebuilder-drop-indicator\").css(\"display\", \"none\").addClass(\"hidden-drop-indicator\");\n        }\n\n        (0, _dropIndicators.showDropIndicators)(contentTypeInstance.config.name, preview.contentType.stageId);\n        sortedContentType = contentTypeInstance; // Dynamically change the connect with option to restrict content types\n\n        (0, _jquery)(this).sortable(\"option\", \"connectWith\", (0, _matrix.getAllowedContainersClasses)(contentTypeInstance.config.name, preview.contentType.stageId));\n        (0, _jquery)(this).sortable(\"refresh\");\n      }\n    }\n  }\n\n  var placeholderContainer;\n  /**\n   * On a sort action hide the placeholder if disabled\n   *\n   * @param {Preview} preview\n   * @param {Event} event\n   * @param {JQueryUI.SortableUIParams} ui\n   */\n\n  function onSort(preview, event, ui) {\n    if ((0, _jquery)(this).sortable(\"option\", \"disabled\") || ui.placeholder.parents(hiddenClass).length > 0) {\n      ui.placeholder.css(\"display\", \"none\");\n    } else {\n      ui.placeholder.css(\"display\", \"block\");\n    }\n    /**\n     * We record the position of the placeholder on sort so we can ensure we place the content type in the correct place\n     * as jQuery UI's events aren't reliable.\n     */\n\n\n    placeholderContainer = ui.placeholder.parents(\".content-type-container\")[0];\n  }\n  /**\n   * On sort stop hide any indicators\n   */\n\n\n  function onSortStop(preview, event, ui) {\n    ui.item.removeClass(\"pagebuilder-sorting-original\");\n    (0, _dropIndicators.hideDropIndicators)();\n    (0, _registry.setDraggedContentTypeConfig)(null); // Only trigger stop if we triggered start\n\n    if (ui.item.hasClass(\"pagebuilder-content-type-wrapper\")) {\n      _events.trigger(\"stage:interactionStop\");\n    }\n\n    if (ui.item && !sortedContentType) {\n      ui.item.remove();\n    }\n\n    sortedContentType = null;\n  }\n  /**\n   * Handle receiving a content type from the left panel\n   *\n   * @param {Preview} preview\n   * @param {Event} event\n   * @param {JQueryUI.SortableUIParams} ui\n   */\n\n\n  function onSortReceive(preview, event, ui) {\n    var contentTypeConfig = (0, _registry.getDraggedContentTypeConfig)();\n    (0, _registry.setDraggedContentTypeConfig)(null);\n\n    if ((0, _jquery)(event.target)[0] !== this) {\n      return;\n    } // If the container content type can't receive drops we need to cancel the operation\n\n\n    if (!preview.isContainer()) {\n      (0, _jquery)(this).sortable(\"cancel\");\n      return;\n    }\n\n    if (contentTypeConfig) {\n      // If the sortable instance is disabled don't complete this operation\n      if ((0, _jquery)(this).sortable(\"option\", \"disabled\") || (0, _jquery)(this).parents(hiddenClass).length > 0) {\n        return;\n      } // jQuery's index method doesn't work correctly here, so use Array.findIndex instead\n\n\n      var index = (0, _jquery)(event.target).children(\".pagebuilder-content-type-wrapper, .pagebuilder-draggable-content-type\").toArray().findIndex(function (element) {\n        return element.classList.contains(\"pagebuilder-draggable-content-type\");\n      }); // Create the new content type and insert it into the parent\n\n      (0, _contentTypeFactory)(contentTypeConfig, getcontentTypeProxy(preview), getPreviewStageIdProxy(preview)).then(function (contentType) {\n        // Set the content type instance as \"dropped\", as it was dropped from the left panel\n        contentType.dropped = true;\n        getcontentTypeProxy(preview).addChild(contentType, index);\n\n        _events.trigger(\"contentType:dropAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n\n        _events.trigger(contentTypeConfig.name + \":dropAfter\", {\n          id: contentType.id,\n          contentType: contentType\n        });\n\n        return contentType;\n      }); // Remove the DOM element, as this is a drop event we can't just remove the ui.item\n\n      (0, _jquery)(event.target).find(\".pagebuilder-draggable-content-type\").remove();\n    }\n  }\n  /**\n   * On sort update handle sorting the underlying children knockout list\n   *\n   * @param {Preview} preview\n   * @param {Event} event\n   * @param {JQueryUI.SortableUIParams} ui\n   */\n\n\n  function onSortUpdate(preview, event, ui) {\n    // If the sortable instance is disabled don't complete this operation\n    if ((0, _jquery)(this).hasClass(\"ui-sortable\") && (0, _jquery)(this).sortable(\"option\", \"disabled\") || ui.item.parents(hiddenClass).length > 0) {\n      ui.item.remove();\n      (0, _jquery)(this).sortable(\"cancel\"); // jQuery tries to reset the state but kills KO's bindings, so we'll force a re-render on the content type\n\n      if (ui.item.length > 0 && typeof _knockout.dataFor(ui.item[0]) !== \"undefined\") {\n        var data = _knockout.dataFor(ui.item[0]);\n\n        var contentType = data.contentType && data.contentType.getChildren ? data.contentType : data.parentContentType;\n        var children = contentType.getChildren()().splice(0);\n        contentType.getChildren()([]);\n        contentType.getChildren()(children);\n      }\n\n      return;\n    }\n    /**\n     * Validate the event is coming from the exact instance or a child instance, we validate on the child instance\n     * as the event is sometimes annoyingly caught by the parent rather than the child it's dropped into. Combining this\n     * with placeholderContainer logic we can ensure we always do the right operation.\n     */\n\n\n    if (sortedContentType && (this === ui.item.parent()[0] || placeholderContainer && (0, _jquery)(this).find(ui.item.parent()).length > 0)) {\n      var el = ui.item[0];\n\n      var contentTypeInstance = _knockout.dataFor(el);\n\n      var target = _knockout.dataFor(placeholderContainer);\n\n      if (target && contentTypeInstance) {\n        // Calculate the source and target index\n        var sourceParent = contentTypeInstance.parentContentType;\n        var targetParent = getcontentTypeProxy(target);\n        var targetIndex = (0, _jquery)(placeholderContainer).children(\".pagebuilder-content-type-wrapper, .pagebuilder-draggable-content-type\").toArray().findIndex(function (element) {\n          return element === el;\n        });\n\n        if (sourceParent) {\n          (0, _jquery)(sourceParent === targetParent ? this : ui.sender || this).sortable(\"cancel\");\n        } else {\n          (0, _jquery)(el).remove();\n        }\n\n        (0, _moveContentType.moveContentType)(contentTypeInstance, targetIndex, targetParent);\n\n        if (contentTypeInstance.parentContentType !== targetParent) {\n          ui.item.remove();\n        }\n      }\n    }\n  }\n\n  return {\n    getSortableOptions: getSortableOptions,\n    hiddenClass: hiddenClass\n  };\n});\n//# sourceMappingURL=sortable.js.map","Magento_PageBuilder/js/form/form-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'Magento_PageBuilder/js/events',\n    'consoleLogger'\n], function (_, $, events, consoleLogger) {\n    'use strict';\n\n    var mixin = {\n        defaults: {\n            pageBuilderInstances: []\n        },\n\n        /**\n         * Record instances of Page Builder initialized in the forms namespace\n         */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n\n            events.on('pagebuilder:register', function (data) {\n                if (data.ns === self.ns) {\n                    self.pageBuilderInstances.push(data.instance);\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * Intercept save call to ensure any Page Builder rendering is completed before submitting form\n         *\n         * @param {String} redirect\n         * @param {Object} data\n         */\n        save: function (redirect, data) {\n            var submit = this._super.bind(this, redirect, data),\n                timeout,\n                locks;\n\n            if (_.isEmpty(this.pageBuilderInstances)) {\n                submit();\n            } else {\n                timeout = setTimeout(function () {\n                    consoleLogger.error('Page Builder was rendering for 5 seconds without releasing locks.');\n                }, 5000);\n\n                $('body').trigger('processStart');\n\n                // Wait for all rendering locks within Page Builder stages to resolve\n                $.when.apply(\n                    null,\n                    this.pageBuilderInstances.map(function (instance) {\n                        locks = instance.stage.renderingLocks;\n\n                        return locks[locks.length - 1];\n                    })\n                ).then(function () {\n                    $('body').trigger('processStop');\n                    clearTimeout(timeout);\n                    submit();\n                });\n            }\n        }\n    };\n\n    return function (target) {\n        return target.extend(mixin);\n    };\n});\n","Magento_PageBuilder/js/form/map-location-provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/provider',\n    'Magento_PageBuilder/js/events'\n], function (Provider, events) {\n    'use strict';\n\n    return Provider.extend({\n        /** @inheritdoc **/\n        initClient: function () {\n            return this;\n        },\n\n        /** @inheritdoc **/\n        save: function () {\n            events.trigger('mapLocation:saveAfter', this.get('data'));\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/provider.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/provider',\n    'Magento_PageBuilder/js/events'\n], function (Provider, events) {\n    'use strict';\n\n    return Provider.extend({\n        /** @inheritdoc **/\n        initClient: function () {\n            return this;\n        },\n\n        /** @inheritdoc **/\n        save: function () {\n            events.trigger('form:' + this.id + ':saveAfter', this.get('data'));\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/components/action-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/button'\n], function (Button) {\n    'use strict';\n\n    return Button.extend({\n        defaults: {\n            modules: {\n                parent: '${ $.parentName }',\n                insertForm: '${ $.insertFormProvider }',\n                modal: '${ $.modalProvider }'\n            }\n        },\n\n        /**\n         * Edit form with data assigning.\n         */\n        edit: function () {\n            this.modal().openModal();\n            this.insertForm().edit(this.parent().data());\n        },\n\n        /**\n         * Delete record from dynamic row.\n         */\n        deleteRecord: function () {\n            var record = this.parent(),\n                dynamicRow = record.parentComponent(),\n                prop = dynamicRow.identificationProperty,\n                id = record.data()[prop];\n\n            dynamicRow.deleteRecord(record.index, id);\n        }\n    });\n});\n","Magento_PageBuilder/js/form/components/insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-form',\n    'Magento_PageBuilder/js/events',\n    'jquery'\n], function (Insert, events, $) {\n    'use strict';\n\n    return Insert.extend({\n        defaults: {\n            appearanceIndex: '',\n            configs: {},\n            tracks: {\n                id: true\n            },\n            listens: {\n                appearance: 'onAppearanceChange'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            events.on('form:renderAfter', function (params) {\n                this.render(params);\n            }.bind(this));\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        render: function (params) {\n            this.availableAppearances = params.appearances;\n            this.title = params.title;\n            this.defaultNamespace = params.defaultNamespace;\n            this.destroyInserted();\n            this.setData(params);\n\n            return this._super({\n                namespace: params.namespace,\n                handle: params.namespace\n            });\n        },\n\n        /**\n         * Set data for new form.\n         *\n         * @param {Object} params\n         */\n        setData: function (params) {\n            var formQuery = 'index=' + params.namespace,\n                dataProviderQuery = 'index=' + params.namespace + '_data_source';\n\n            this.providerData = params.data;\n            this.id = params.id;\n            this.externalForm = this.requestModule(formQuery);\n            this.externalSource = this.requestModule(dataProviderQuery);\n            this.setLinks({\n                appearance: 'ns = ' + params.namespace + ', index = ' + this.appearanceIndex + ':value'\n            }, 'imports');\n            this.setLinks({\n                providerData: dataProviderQuery + ':data',\n                prefix: formQuery + ':selectorPrefix',\n                id: dataProviderQuery + ':id'\n            }, 'exports');\n        },\n\n        /** @inheritdoc **/\n        requestData: function (params) {\n            var deffer = $.Deferred(),\n                formConfig = this.configs[params.namespace];\n\n            if (formConfig) {\n                return deffer.resolve(formConfig);\n            }\n\n            return this._super().done(function (data) {\n                this.configs[params.namespace] = data;\n            }.bind(this));\n        },\n\n        /**\n         * Re-render after appearance change\n         *\n         * @param {String} value\n         */\n        onAppearanceChange: function (value) {\n            var namespace = this.availableAppearances[value] && this.availableAppearances[value].form ||\n                this.defaultNamespace;\n\n            if (namespace !== this.previousParams.namespace) {\n                this.render({\n                    namespace: namespace,\n                    id: this.id,\n                    data: this.externalSource().get('data'),\n                    appearances: this.availableAppearances,\n                    title: this.title,\n                    defaultNamespace: this.defaultNamespace\n                });\n            }\n        }\n    });\n});\n","Magento_PageBuilder/js/form/components/map-location-dynamic-rows.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/dynamic-rows/dynamic-rows',\n    'Magento_PageBuilder/js/events',\n    'underscore',\n    'jquery'\n], function (dynamicRows, Events, _, $) {\n    'use strict';\n\n    /**\n     * Returns sortable values\n     *\n     * @param {String | Number | Object | Array} value\n     * @return {String | Number}\n     */\n    var sortValueValidator = function (value) {\n        if (typeof value === 'string') {\n            return value.toLowerCase();\n        }\n\n        if (typeof value === 'number') {\n            return value;\n        }\n\n        return '';\n    };\n\n    return dynamicRows.extend({\n        defaults: {\n            modules: {\n                insertForm: '${ $.insertFormProvider }',\n                modal: '${$.modalProvider}'\n            }\n        },\n\n        /** @inheritdoc */\n        initLinks: function () {\n            this._super();\n            Events.on('mapLocation:saveAfter', function (data) {\n                this.modal().closeModal();\n                this.reInitData(data);\n            }.bind(this), this.name);\n\n            return this;\n        },\n\n        /**\n         * Open the location modal and insert form with the data from selected record\n         *\n         * @param {Object} record\n         */\n        edit: function (record) {\n            this.modal().openModal();\n            this.insertForm().edit(record.data());\n        },\n\n        /**\n         * Reinitializing of dynamic row records.\n         *\n         * @param {Object} data\n         */\n        reInitData: function (data) {\n            var recordData = this.recordData().slice(),\n                prop = this.identificationProperty,\n                isExists = false;\n\n            _.each(recordData, function (elem, index) {\n                if (elem[prop] === data[prop]) {\n                    recordData[index] = data;\n                    isExists = true;\n                }\n            }, this);\n\n            if (!isExists) {\n                recordData.push(data);\n            }\n\n            this.recordData(recordData);\n\n            _.each(this.labels(), function (label) {\n                if (label.columnsHeaderClasses) {\n                    this.sortRecord(label.name, label.columnsHeaderClasses === '_ascend');\n                }\n            }.bind(this));\n\n            this.reload();\n        },\n\n        /**\n         * Logic to toggle ascend and descend sorting for headers\n         *\n         * @param {KnockoutObservableArray} property\n         */\n        sortByHeader: function (property) {\n            var ascend,\n                activeLabel,\n                allLabels,\n                placeholder;\n\n            if (property().name === 'actions') {\n                return;\n            }\n\n            if (property().columnsHeaderClasses) {\n                activeLabel = $.extend({}, property());\n                activeLabel.columnsHeaderClasses =\n                    property().columnsHeaderClasses === '_ascend' ? '_descend' : '_ascend';\n                ascend = activeLabel.columnsHeaderClasses === '_ascend';\n                property(activeLabel);\n            } else {\n                allLabels = this.labels().slice();\n                allLabels.forEach(function (label) {\n\n                    if (label.name === property().name) {\n                        label.columnsHeaderClasses = '_ascend';\n                    } else {\n                        label.columnsHeaderClasses = '';\n                    }\n                });\n                ascend = true;\n                this.labels(allLabels);\n            }\n\n            if (this.recordData().length) {\n                placeholder = this.emptyContentPlaceholder;\n\n                this.emptyContentPlaceholder = false;\n                this.sortRecord(property().name, ascend);\n                this.reload();\n                this.emptyContentPlaceholder = placeholder;\n            }\n        },\n\n        /**\n         * Sorting of dynamic row records.\n         *\n         * @param {String} sortBy\n         * @param {Boolean} ascend\n         */\n        sortRecord: function (sortBy, ascend) {\n            this.recordData.sort(function (left, right) {\n                var record1 = ascend ? left : right,\n                    record2 = ascend ? right : left;\n\n                record1 = sortValueValidator(record1[sortBy]);\n                record2 = sortValueValidator(record2[sortBy]);\n\n                return record1 === record2 ? 0 : record1 < record2 ? -1 : 1;\n            });\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            this._super();\n            Events.off(this.name);\n        }\n    });\n});\n","Magento_PageBuilder/js/form/components/map-location-insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-form'\n], function (Insert) {\n    'use strict';\n\n    return Insert.extend({\n        /**\n         * Clear form content and reinsert data in argument\n         * @param {Object} data\n         */\n        edit: function (data) {\n            this.destroyInserted();\n            this.render();\n            this.setData(data);\n        },\n\n        /**\n         * Set data for new form\n         *\n         * @param {Object} data\n         */\n        setData: function (data) {\n            var formQuery = 'index=' + this.ns,\n                dataProviderQuery = 'index=' + this.ns + '_data_source';\n\n            this.providerData = data;\n            this.externalForm = this.requestModule(formQuery);\n            this.externalSource = this.requestModule(dataProviderQuery);\n            this.setLinks({\n                providerData: dataProviderQuery + ':data'\n            }, 'exports');\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/block-chooser.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiLayout',\n    'uiElement',\n    'Magento_PageBuilder/js/config',\n    'mage/translate',\n    'mage/utils/objects'\n], function ($, layout, Element, Config, $t, objectUtils) {\n    'use strict';\n\n    return Element.extend({\n        id: null,\n        meta: {},\n        errorMessage: null,\n        displayMetadata: true,\n        messages: {\n            UNKOWN_ERROR: $t('Sorry, there was an error getting requested content. ' +\n                'Please contact the store owner.'),\n            UNKNOWN_SELECTION: $t('The currently selected block does not exist.')\n        },\n        defaults: {\n            template: 'Magento_PageBuilder/form/element/block-chooser',\n            requestParameter: null,\n            dataUrlConfigPath: null,\n            modalName: null,\n            buttonComponentConfig: {\n                title: '${ $.buttonTitle }',\n                component: 'Magento_Ui/js/form/components/button',\n                actions: [{\n                    targetName: '${ $.modalName }',\n                    actionName: 'openModal'\n                }]\n            },\n            requestData: {\n                method: 'POST',\n                data: {\n                    'form_key': window.FORM_KEY\n                }\n            },\n            listens: {\n                id: 'updateFromServer'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this._super()\n                .observe('id meta errorMessage displayMetadata');\n        },\n\n        /**\n         * Updates the block data from the server\n         *\n         * @returns void\n         */\n        updateFromServer: function () {\n            var requestData = $.extend(true, {}, this.requestData);\n\n            // The component hasn't be configured yet. Nothing to do.\n            if (!this.id().length || !this.requestParameter || !this.dataUrlConfigPath) {\n                this.meta({});\n\n                return;\n            }\n\n            requestData.data[this.requestParameter] = this.id();\n            $('body').trigger('processStart');\n\n            $.ajax(objectUtils.nested(Config.getConfig(), this.dataUrlConfigPath), requestData)\n                .always(function () {\n                    $('body').trigger('processStop');\n                    this.errorMessage(null);\n                }.bind(this))\n                .done(function (response) {\n                    if (typeof response !== 'object' || response.error) {\n                        this.meta({});\n                        this.errorMessage(this.messages.UNKOWN_ERROR);\n\n                        return;\n                    } else if (Array.isArray(response)) {\n                        this.meta({});\n                        this.errorMessage(this.messages.UNKNOWN_SELECTION);\n\n                        return;\n                    }\n\n                    this.meta(response);\n                }.bind(this))\n                .fail(function () {\n                    this.meta({});\n                    this.errorMessage(this.messages.UNKOWN_ERROR);\n                }.bind(this));\n        },\n\n        /**\n         * Creates the button component for rendering\n         *\n         * @returns {Object} The button component\n         */\n        getButton: function () {\n            var elementConfig = this.buttonComponentConfig;\n\n            elementConfig.name = this.name + '_button';\n            layout([elementConfig]);\n\n            return this.requestModule(elementConfig.name);\n        },\n\n        /**\n         * Determines the status label for the currently loaded block\n         *\n         * @returns {String}\n         */\n        getStatusLabel: function () {\n            return this.meta()['is_active'] === '1' ? $t('Active') : $t('Inactive');\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/condition-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_PageBuilder/js/form/element/visual-select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.showRelatedElement(this.value());\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super();\n\n            this.options().forEach(function (option) {\n                this.observe(option.value + 'Visible');\n            }.bind(this));\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        onUpdate: function (value) {\n            this.showRelatedElement(value);\n\n            return this._super();\n        },\n\n        /**\n         * Sets exported property, linked with visibility of the element, defined as option\n         *\n         * @param {String} value\n         * @returns {Object} Chainable\n         */\n        showRelatedElement: function (value) {\n            this[value + 'Visible'](true);\n            this.options().forEach(function (option) {\n                if (value !== option.value) {\n                    this[option.value + 'Visible'](false);\n                }\n            }.bind(this));\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/conditional-disable-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    var setDisabledSetting = {\n        defaults: {\n            disabledValues: []\n        },\n\n        /**\n         * Set the field as disabled when it's empty or is equal to a value within disabledValues\n         *\n         * @param {Array} value\n         */\n        setDisabled: function (value) {\n            if (_.indexOf(_.values(this.disabledValues), value) !== -1) {\n                this.disable();\n            } else {\n                this.enable();\n            }\n        }\n    };\n\n    return function (target) {\n        return target.extend(setDisabledSetting);\n    };\n});\n","Magento_PageBuilder/js/form/element/conditions-loader.js":"define([\n    'jquery',\n    'Magento_Rule/rules',\n    'uiRegistry',\n    'mage/utils/objects'\n], function ($, RulesForm, uiRegistry, objectUtils) {\n    'use strict';\n\n    return function (config, conditionsFormPlaceholder) {\n        var $conditionsFormPlaceholder = $(conditionsFormPlaceholder),\n            attributeData = uiRegistry.get(config.formNamespace + '.' + config.formNamespace).source.data,\n            conditions = objectUtils.nested(attributeData, config.attribute) || '[]';\n\n        $('body').trigger('processStart');\n\n        $.ajax(config.componentUrl, {\n            method: 'POST',\n            data: {\n                conditions: conditions\n            }\n        })\n        .done(function (response) {\n            $conditionsFormPlaceholder.html(response);\n            window[config.jsObjectName] = new RulesForm(config.jsObjectName, config.childComponentUrl);\n            $('body').trigger('processStop');\n        });\n    };\n});\n","Magento_PageBuilder/js/form/element/dependent-fieldset.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/fieldset'\n], function (Fieldset) {\n    'use strict';\n\n    return Fieldset.extend({\n        defaults: {\n            originalLabelValue: ''\n        },\n\n        /**\n         * Observe label\n         * {@inheritDoc}\n         */\n        initObservable: function () {\n            this._super().observe('label');\n\n            return this;\n        },\n\n        /**\n         * Store original label value\n         * {@inheritDoc}\n         */\n        initConfig: function () {\n            this._super();\n            this.originalLabelValue = this.label;\n        },\n\n        /**\n         * Hide fieldset if number of field options is <= 1 and it is the only element in the group\n         *\n         * @param {Array} options\n         */\n        hideFieldset: function (options) {\n            this.visible(options.length > 1 || this.elems().length > 1);\n        },\n\n        /**\n         * Hide label if number of field options is <= 1\n         *\n         * @param {Array} options\n         */\n        hideLabel: function (options) {\n            this.label(options.length > 1 ? this.originalLabelValue : '');\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/dependent-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            visible: false\n        },\n\n        /**\n         * Dependently display dropdown component if it contains more than one option\n         *\n         * @returns {Object} Chainable\n         */\n        setOptions: function () {\n            this._super();\n\n            if (this.options().length > 1) {\n                this.setVisible(true);\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/dependent-value-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    var setDependentValuesSetting = {\n        defaults: {\n            dependentValues: {}\n        },\n\n        /**\n         * Change value of component if it present in dependentValues\n         */\n        setDependentValues: function (value) {\n            if (this.dependentValues.hasOwnProperty(value)) {\n                this.previousValue = this.value();\n                this.value(this.dependentValues[value]);\n            } else if (this.hasOwnProperty('previousValue')) {\n                this.value(this.previousValue);\n            }\n        }\n    };\n\n    return function (target) {\n        return target.extend(setDependentValuesSetting);\n    };\n});\n","Magento_PageBuilder/js/form/element/dependent-visual-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_PageBuilder/js/form/element/visual-select'\n], function (_, Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            visible: false\n        },\n\n        /**\n         * Dependently display dropdown component if it contains more than one option\n         *\n         * @returns {Object} Chainable\n         */\n        setOptions: function () {\n            this._super();\n\n            if (this.options().length > 1) {\n                this.setVisible(true);\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/grid-size.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        validate: function () {\n            var externalFormSourceData = this.requestModule('index=' + this.ns)().source.data;\n\n            this.validationParams = {\n                'non_empty_column_count': externalFormSourceData.non_empty_column_count,\n                'max_grid_size': externalFormSourceData.max_grid_size\n            };\n\n            return this._super();\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/html-code.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global MediabrowserUtility, widgetTools, MagentovariablePlugin */\ndefine([\n    'Magento_Ui/js/form/element/textarea',\n    'mage/adminhtml/wysiwyg/widget'\n], function (Textarea) {\n    'use strict';\n\n    var HTML_ID_PLACEHOLDER = 'HTML_ID_PLACEHOLDER';\n\n    return Textarea.extend({\n        defaults: {\n            elementTmpl: 'Magento_PageBuilder/form/element/html-code'\n        },\n\n        /**\n         * Click event for Insert Widget Button\n         */\n        clickInsertWidget: function () {\n            return widgetTools.openDialog(\n                this.widgetUrl.replace(HTML_ID_PLACEHOLDER, this.uid)\n            );\n        },\n\n        /**\n         * Click event for Insert Image Button\n         */\n        clickInsertImage: function () {\n            return MediabrowserUtility.openDialog(\n                this.imageUrl.replace(HTML_ID_PLACEHOLDER, this.uid)\n            );\n        },\n\n        /**\n         * Click event for Insert Variable Button\n         */\n        clickInsertVariable: function () {\n            return MagentovariablePlugin.loadChooser(\n                this.variableUrl,\n                this.uid\n            );\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/html.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/html',\n    'jquery',\n    'underscore'\n], function (Html, $, _) {\n    'use strict';\n\n    return Html.extend({\n        defaults: {\n            inputSelector: '[data-form-part=${ $.ns }]',\n            elements: [],\n            value: {}\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.initInputListener();\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe('value');\n        },\n\n        /**\n         * Listen for value change on each field that has been added.\n         */\n        initInputListener: function () {\n            $.async({\n                component: this,\n                selector: this.inputSelector\n            }, function (el) {\n                this.elements.push(el);\n                $(el).on('change', this.updateValue.bind(this));\n                $(el).nextAll('.rule-param-apply').on('click', function () {\n                    $(el).trigger('change');\n                });\n                $(el).closest('li').find('.rule-param-remove').on('click', function () {\n                    $(el).val('').trigger('change');\n                });\n                this.updateValue(this);\n            }.bind(this));\n        },\n\n        /**\n         * Collect data and update value.\n         */\n        updateValue: function () {\n            var result = {},\n                name;\n\n            this.elements.forEach(function (item) {\n                switch (item.type) {\n                    case 'checkbox':\n                        result[item.name] = +!!item.checked;\n                        break;\n\n                    case 'radio':\n                        if (item.checked) {\n                            result[item.name] = item.value;\n                        }\n                        break;\n\n                    case 'select-multiple':\n                        name = item.name.substring(0, item.name.length - 2); //remove [] from the name ending\n                        result[name] = _.pluck(item.selectedOptions, 'value');\n                        break;\n\n                    default:\n                        result[item.name] = item.value;\n                }\n            });\n\n            this.value(result);\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/image-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/image-uploader',\n    'Magento_PageBuilder/js/resource/resize-observer/ResizeObserver',\n    'Magento_PageBuilder/js/events',\n    'mage/translate'\n], function ($, _, uiRegistry, Uploader, ResizeObserver, events, $t) {\n    'use strict';\n\n    var initializedOnce = false;\n\n    return Uploader.extend({\n        defaults: {\n            $uploadArea: null,\n            isShowImageUploadInstructions: true,\n            isShowImageUploadOptions: false,\n            visibleControls: true,\n            classes: {\n                dragging: 'dragging',\n                draggingInside: 'dragging-inside',\n                draggingOutside: 'dragging-outside'\n            },\n            // listed in ascending order\n            elementWidthModifierClasses: {\n                '_micro-ui': {\n                    maxWidth: 130\n                },\n                '_compact-ui': {\n                    minWidth: 131,\n                    maxWidth: 440\n                }\n            },\n            translations: {\n                allowedFileTypes: $t('Allowed file types'),\n                dragImageHere: $t('Drag image here'),\n                dropHere: $t('Drop here'),\n                maximumFileSize: $t('Maximum file size'),\n                selectFromGallery: $t('Select from Gallery'),\n                or: $t('or'),\n                uploadImage: $t('Upload Image'),\n                uploadNewImage: $t('Upload New Image')\n            },\n            tracks: {\n                visibleControls: true\n            }\n        },\n\n        /**\n         * Bind drag events to highlight/unhighlight dropzones\n         * {@inheritDoc}\n         */\n        initialize: function () {\n            var $document = $(document);\n\n            this._super();\n\n            events.on('image:' + this.id + ':assignAfter', this.onAssignedFile.bind(this));\n\n            // bind dropzone highlighting using event delegation only once\n            if (!initializedOnce) {\n                // dropzone highlighting\n                $document.on('dragover', this.highlightDropzone.bind(this));\n\n                // dropzone unhighlighting\n                $document.on('dragend dragleave mouseup', this.unhighlightDropzone.bind(this));\n\n                initializedOnce = true;\n            }\n        },\n\n        /**\n         * {@inheritDoc}\n         */\n        initUploader: function (fileInput) {\n            this._super(fileInput);\n            this.$uploadArea = $(this.$fileInput).closest('.pagebuilder-image-empty-preview');\n            new ResizeObserver(this.updateResponsiveClasses.bind(this)).observe(this.$uploadArea.get(0));\n        },\n\n        /**\n         * Checks if provided file is allowed to be uploaded.\n         * {@inheritDoc}\n         */\n        isFileAllowed: function () {\n            var result = this._super(),\n                allowedExtensions = this.getAllowedFileExtensionsInCommaDelimitedFormat();\n\n            if (!result.passed && result.rule === 'validate-file-type') {\n                result.message += ' ' + this.translations.allowedFileTypes + ': ' + allowedExtensions + '.';\n            }\n\n            return result;\n        },\n\n        /**\n         * Remove draggable classes from dropzones\n         * {@inheritDoc}\n         */\n        onBeforeFileUpload: function () {\n            this.removeDraggableClassesFromDropzones();\n            this._super();\n        },\n\n        /**\n         * Add/remove CSS classes to $dropzone element to provide UI feedback\n         *\n         * @param {jQuery.event} e\n         */\n        highlightDropzone: function (e) {\n            var $dropzone = $(e.target).closest(this.dropZone),\n                $otherDropzones = $(this.dropZone).not($dropzone),\n                isInsideDropzone = !!$dropzone.length;\n\n            if (isInsideDropzone) {\n                $dropzone\n                  .removeClass(this.classes.draggingOutside)\n                  .addClass([this.classes.dragging, this.classes.draggingInside].join(' '));\n            }\n\n            $otherDropzones\n              .removeClass(this.classes.draggingInside)\n              .addClass([this.classes.dragging, this.classes.draggingOutside].join(' '));\n        },\n\n        /**\n         * Remove all UI styling from dropzone\n         *\n         * @param {jQuery.event} e\n         */\n        unhighlightDropzone: function (e) {\n            var isMouseReleased = e.type === 'mouseup' || e.type === 'dragend',\n                isActuallyLeavingThePage = e.type === 'dragleave' && (e.clientX === 0 || e.clientY === 0);\n\n            if (!isMouseReleased && !isActuallyLeavingThePage) {\n                return;\n            }\n\n            this.removeDraggableClassesFromDropzones();\n        },\n\n        /**\n         * Remove draggable CSS classes from dropzone elements\n         */\n        removeDraggableClassesFromDropzones: function () {\n            var $dropzones = $(this.dropZone);\n\n            $dropzones\n                .removeClass([\n                    this.classes.dragging,\n                    this.classes.draggingInside,\n                    this.classes.draggingOutside\n                ].join(' '));\n        },\n\n        /**\n         * Trigger image:uploadAfter event to be handled by PageBuilder image component\n         * {@inheritDoc}\n         */\n        addFile: function (file) {\n            this._super();\n\n            events.trigger('image:' + this.id + ':uploadAfter', [file]);\n\n            return this;\n        },\n\n        /**\n         * Trigger image:deleteFileAfter event to be handled by PageBuilder image component\n         * {inheritDoc}\n         */\n        clear: function () {\n            this._super();\n\n            events.trigger('image:' + this.id + ':deleteFileAfter');\n\n            return this;\n        },\n\n        /**\n         * Propagate file changes through all image uploaders sharing the same id\n         *\n         * @param {Object} file\n         */\n        onAssignedFile: function (file) {\n            this.value([file]);\n        },\n\n        /**\n         * Adds the appropriate ui state class to the upload control area based on the current rendered size\n         */\n        updateResponsiveClasses: function () {\n            var classesToAdd = [],\n                classConfig,\n                elementWidth = this.$uploadArea.width(),\n                modifierClass;\n\n            if (!this.$uploadArea.is(':visible')) {\n                return;\n            }\n\n            this.$uploadArea.removeClass(Object.keys(this.elementWidthModifierClasses).join(' '));\n\n            for (modifierClass in this.elementWidthModifierClasses) {\n                if (!this.elementWidthModifierClasses.hasOwnProperty(modifierClass)) {\n                    // jscs:disable disallowKeywords\n                    continue;\n                    // jscs:enable disallowKeywords\n                }\n\n                classConfig = this.elementWidthModifierClasses[modifierClass];\n\n                if (classConfig.minWidth && classConfig.maxWidth &&\n                    (classConfig.minWidth <= elementWidth && elementWidth <= classConfig.maxWidth) ||\n                    classConfig.minWidth && !classConfig.maxWidth && classConfig.minWidth <= elementWidth ||\n                    classConfig.maxWidth && !classConfig.minWidth && elementWidth <= classConfig.maxWidth\n                ) {\n                    classesToAdd.push(modifierClass);\n                }\n            }\n\n            if (classesToAdd.length) {\n                this.$uploadArea.addClass(classesToAdd.join(' '));\n            }\n        },\n\n        /**\n         * {@inheritDoc}\n         */\n        hasData: function () {\n            // Some of the components automatically add an empty object if the value is unset.\n            return this._super() && !$.isEmptyObject(this.value()[0]);\n        },\n\n        /**\n         * Stop event to prevent it from reaching any objects other than the current object.\n         *\n         * @param {Object} uploader\n         * @param {Event} event\n         * @returns {Boolean}\n         */\n        stopEvent: function (uploader, event) {\n            event.stopPropagation();\n\n            return true;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/map.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*eslint-disable vars-on-top, strict */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'Magento_PageBuilder/js/utils/map',\n    'module',\n    'Magento_PageBuilder/js/events'\n], function (AbstractField, GoogleMap, module, events) {\n    'use strict';\n\n    var google = window.google || {};\n\n    return AbstractField.extend({\n        defaults: {\n            elementTmpl: 'Magento_PageBuilder/form/element/map',\n            map: false,\n            marker: false,\n            apiKeyValid: !!module.config().apiKey,\n            apiKeyErrorMessage: module.config().apiKeyErrorMessage\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n\n            this.observe('apiKeyValid');\n\n            return this;\n        },\n\n        /**\n         * Render the map into the field\n         *\n         * @param {HTMLElement} element\n         */\n        renderMap: function (element) {\n            // Get the start value and convert the value into an array\n            var startValue = this.value(),\n                mapOptions,\n                latitudeLongitude;\n\n            if (!this.apiKeyValid()) {\n                return;\n            }\n\n            if (typeof startValue === 'string' && startValue !== '') {\n                startValue = JSON.parse(startValue);\n            }\n\n            mapOptions = {\n                navigationControl: true,\n                navigationControlOptions: {\n                    style: google.maps.NavigationControlStyle.DEFAULT\n                }\n            };\n\n            events.on('googleMaps:authFailure', function () {\n                this.apiKeyValid(false);\n            }.bind(this));\n\n            // Create the map\n            this.mapElement = new GoogleMap(element, [], mapOptions);\n\n            if (!this.mapElement || !this.mapElement.map) {\n                return;\n            }\n\n            // Add marker if there is a start value\n            if (startValue.latitude !== '' && startValue.longitude !== '') {\n                latitudeLongitude = new google.maps.LatLng(\n                    parseFloat(startValue.latitude),\n                    parseFloat(startValue.longitude)\n                );\n\n                this.mapElement.map.setCenter(latitudeLongitude);\n                this.addMarker(startValue.latitude, startValue.longitude);\n            }\n\n            // After click, add and update both Latitude and Longitude.\n            google.maps.event.addListener(this.mapElement.map, 'click', this.onClick.bind(this));\n            google.maps.event.addListener(this.mapElement.map, 'dblclick', this.onDblClick.bind(this));\n            google.maps.event.trigger(this.marker, 'click');\n        },\n\n        /**\n         * Adds a map marker\n         *\n         * @param {String} latitude\n         * @param {String} longitude\n         */\n        addMarker: function (latitude, longitude) {\n            this.marker = new google.maps.Marker({\n                draggable: true,\n                map: this.mapElement.map,\n                position: new google.maps.LatLng(latitude, longitude)\n            });\n            google.maps.event.addListener(this.marker, 'dragend', this.onDragEnd.bind(this));\n        },\n\n        /**\n         * Event for drag end to update value\n         */\n        onDragEnd: function () {\n            this.value(this.exportValue());\n        },\n\n        /**\n         * Event for click to update marker, delayed by 300ms in case of double click\n         *\n         * @param {Event} event\n         */\n        onClick: function (event) {\n            this.clickTimer = setTimeout(function () {\n                if (!this.marker) {\n                    this.addMarker(event.latLng.lat(), event.latLng.lng());\n                }\n                this.value(this.exportValue(event.latLng));\n            }.bind(this), 300);\n        },\n\n        /**\n         * Event for double click to prevent call from single click\n         */\n        onDblClick: function () {\n            clearTimeout(this.clickTimer);\n        },\n\n        /**\n         * Callback after an update to map\n         */\n        onUpdate: function () {\n            if (!this.mapElement) {\n                return;\n            }\n\n            this._super();\n            var content = this.value(),\n                latitudeLongitude;\n\n            if (this.marker && content.latitude === '' && content.longitude === '') {\n                this.marker.setMap(null);\n                delete this.marker;\n\n                return;\n            }\n\n            if (!this.validateCoordinate(content) ||\n                this.mapElement &&\n                !this.mapElement.map ||\n                this.value() === '' ||\n                this.value() === this.exportValue()) {\n                return;\n            }\n\n            if (typeof this.value() === 'string' && this.value() !== '') {\n                content = JSON.parse(this.value());\n            }\n            latitudeLongitude = new google.maps.LatLng(parseFloat(content.latitude), parseFloat(content.longitude));\n\n            if (!this.marker) {\n                this.addMarker(latitudeLongitude.lat(), latitudeLongitude.lng());\n            }\n\n            this.marker.setPosition(latitudeLongitude);\n            this.mapElement.map.setCenter(latitudeLongitude);\n        },\n\n        /**\n         * Coordinate validation\n         *\n         * @param {Object} coordinates\n         * @return {Boolean}\n         */\n        validateCoordinate: function (coordinates) {\n            var valid = true;\n\n            if (coordinates.longitude === '' ||\n                coordinates.latitude === '' ||\n                isNaN(coordinates.longitude) ||\n                isNaN(coordinates.latitude) ||\n                parseFloat(coordinates.longitude) < -180 ||\n                parseFloat(coordinates.longitude) > 180 ||\n                parseFloat(coordinates.latitude) < -90 ||\n                parseFloat(coordinates.latitude) > 90\n            ) {\n                valid = false;\n            }\n\n            return valid;\n        },\n\n        /**\n         * Returns current latitude and longitude as an object\n         *\n         * @param {Object} coordinate\n         * @return {Object}\n         */\n        exportValue: function (coordinate) {\n            var position = this.marker ?\n                this.marker.getPosition() :\n                new google.maps.LatLng(this.mapElement.map.center.lat(), this.mapElement.map.center.lng()),\n                currentCoordinate = coordinate ? coordinate : position;\n\n            return {\n                latitude: currentCoordinate.lat(),\n                longitude: currentCoordinate.lng()\n            };\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/margins-and-padding.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*eslint-disable vars-on-top, strict */\n\ndefine([\n    'underscore',\n    'ko',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, ko, Abstract) {\n    'use strict';\n\n    var defaultValue = '';\n\n    return Abstract.extend({\n        defaults: {\n            elementTmpl: 'Magento_PageBuilder/form/element/margins-and-padding',\n            marginTop: defaultValue,\n            marginRight: defaultValue,\n            marginBottom: defaultValue,\n            marginLeft: defaultValue,\n            paddingTop: defaultValue,\n            paddingRight: defaultValue,\n            paddingBottom: defaultValue,\n            paddingLeft: defaultValue,\n            listens: {\n                marginTop: 'updateValue',\n                marginRight: 'updateValue',\n                marginBottom: 'updateValue',\n                marginLeft: 'updateValue',\n                paddingTop: 'updateValue',\n                paddingRight: 'updateValue',\n                paddingBottom: 'updateValue',\n                paddingLeft: 'updateValue'\n            }\n        },\n\n        /**\n         * Init observable on our margin & padding properties\n         *\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super();\n            this.observe('marginTop marginRight marginBottom marginLeft ' +\n                'paddingTop paddingRight paddingBottom paddingLeft');\n\n            return this;\n        },\n\n        /**\n         * Update the value on individual property changes\n         */\n        updateValue: function () {\n            this.value({\n                margin: {\n                    top: this.marginTop(),\n                    right: this.marginRight(),\n                    bottom: this.marginBottom(),\n                    left: this.marginLeft()\n                },\n                padding: {\n                    top: this.paddingTop(),\n                    right: this.paddingRight(),\n                    bottom: this.paddingBottom(),\n                    left: this.paddingLeft()\n                }\n            });\n        },\n\n        /**\n         * On set of the initial value update our individual observables\n         *\n         * @returns {exports}\n         */\n        setInitialValue: function () {\n            this._super();\n            this._updateObservables(this.initialValue);\n\n            return this;\n        },\n\n        /**\n         * On update of the value property update our individual observables, the data provider can have data\n         * set on it after the initial construction, this ensures we translate our values\n         *\n         * @returns {exports}\n         */\n        onUpdate: function () {\n            this._super();\n            this._updateObservables(this.value());\n\n            return this;\n        },\n\n        /**\n         * Update the observable properties\n         *\n         * @param {Number} value\n         * @private\n         */\n        _updateObservables: function (value) {\n            if (value && _.isString(value)) {\n                value = JSON.parse(value);\n            }\n\n            if (value && _.isObject(value)) {\n                _.each(value, function (attributeData, attributeType) {\n                    _.each(attributeData, function (attributeValue, attributeDirection) {\n                        if (attributeValue !== defaultValue) {\n                            this[attributeType + attributeDirection.capitalize()](attributeValue);\n                        }\n                    }, this);\n                }, this);\n            }\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/page-ui-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/ui-select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n\n        /**\n         * Get path to current option\n         *\n         * @param {Object} data - option data\n         * @returns {String} path\n         */\n        getPath: function (data) {\n            var path = '';\n\n            if (this.renderPath) {\n                path = data.identifier || path;\n            }\n\n            return path;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/product-totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'mage/translate',\n    'Magento_PageBuilder/js/form/provider/conditions-data-processor',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, $, $t, conditionsDataProcessor, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            conditionOption: '',\n            conditionValue: '',\n            formData: {},\n            totalProductCount: 0,\n            totalDisabledProducts: 0,\n            totalNotVisibleProducts: 0,\n            previousConditions: false,\n            listens: {\n                conditionOption: 'updateProductTotals',\n                conditionValue: 'updateProductTotals',\n                '${ $.provider }:data.modalClosed': 'abortRunningRequest'\n            },\n            imports: {\n                formData: '${ $.provider }:data'\n            },\n            links: {\n                value: false\n            },\n            url: null,\n            valuePlaceholder: $t('of %1 total'),\n            disabledPlaceholder: $t('%1 disabled'),\n            notVisiblePlaceholder: $t('%1 not visible'),\n            showSpinner: true,\n            loading: false,\n            jqXHR: null\n        },\n\n        /**\n         * Abort running Ajax request\n         */\n        abortRunningRequest: function () {\n            if (this.jqXHR && this.jqXHR.readyState !== 4) {\n                this.jqXHR.abort();\n            }\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            return this._super()\n                .observe('value totalProductCount totalDisabledProducts totalNotVisibleProducts loading');\n        },\n\n        /**\n         * If we haven't aborted the request, continue and display the error\n         *\n         * @param {Object} jqXHR\n         */\n        callSuperError: function (jqXHR) {\n            // eslint-disable-next-line jquery-no-bind-unbind\n            var superError = $.ajaxSettings.error.bind(window, jqXHR);\n\n            superError();\n        },\n\n        /**\n         * Update product count.\n         */\n        updateProductTotals: _.debounce(function () {\n            var totalText,\n                negativeTotals = [];\n\n            if (!this.conditionOption || _.isEmpty(this.formData)) {\n                return;\n            }\n\n            if (this.conditionOption === 'category_ids' && typeof this.formData['category_ids'] !== 'string') {\n                this.formData['category_ids'] = '';\n            }\n\n            _.extend(this.formData, this.conditionValue);\n            conditionsDataProcessor(this.formData, this.conditionOption + '_source');\n\n            // Store the previous conditions so we don't update the totals when nothing has changed\n            if (this.previousConditions === this.formData['conditions_encoded']) {\n                return;\n            }\n            this.previousConditions = this.formData['conditions_encoded'];\n\n            this.loading(true);\n            this.abortRunningRequest();\n            this.jqXHR = $.ajax({\n                url: this.url,\n                method: 'POST',\n                data: {\n                    conditionValue: this.formData['conditions_encoded']\n                },\n                error: function (jqXHR) {\n                    if (jqXHR.statusText !== 'abort') {\n                        this.callSuperError(jqXHR);\n                    }\n                }.bind(this)\n            }).done(function (response) {\n                this.totalProductCount(parseInt(response.total, 10));\n                this.totalDisabledProducts(parseInt(response.disabled, 10));\n                this.totalNotVisibleProducts(parseInt(response.notVisible, 10));\n                totalText = this.valuePlaceholder\n                    .replace('%1', parseInt(response.total, 10));\n\n                if (parseInt(response.disabled, 10) > 0) {\n                    negativeTotals.push(this.disabledPlaceholder.replace('%1', parseInt(response.disabled, 10)));\n                }\n\n                if (parseInt(response.notVisible, 10) > 0) {\n                    negativeTotals.push(this.notVisiblePlaceholder.replace('%1', parseInt(response.notVisible, 10)));\n                }\n\n                if (negativeTotals.length > 0) {\n                    totalText += ' (' + negativeTotals.join(', ') + ')';\n                }\n\n                this.value(totalText);\n                this.loading(false);\n            }.bind(this)).fail(function () {\n                if (this.jqXHR.statusText !== 'abort') {\n                    this.value($t('An unknown error occurred. Please try again.'));\n                }\n                this.loading(false);\n            }.bind(this));\n        }, 10)\n    });\n});\n","Magento_PageBuilder/js/form/element/select-filtered-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/select'\n], function (_, Select) {\n    'use strict';\n\n    return Select.extend({\n\n        defaults: {\n            excludeOptions: []\n        },\n\n        /** @inheritdoc */\n        onUpdate: function () {\n            if (!this.updatedByFilter) {\n                this.transferredValue = null;\n            } else {\n                this.updatedByFilter = false;\n            }\n\n            return this._super();\n        },\n\n        /**\n         * Excluding options according excludeOptions configuration based on the passed value\n         *\n         * @param {String} value\n         */\n        filter: function (value) {\n            var source = this.initialOptions,\n                initialValue = this.value(),\n                result,\n                excludeOptions =  this.excludeOptions[value],\n                excludedOptionsArray = excludeOptions ? excludeOptions.split(',') : [];\n\n            result = _.filter(source, function (item) {\n                return !excludeOptions || excludedOptionsArray.indexOf(item.value) === -1;\n            });\n\n            this.updatedByFilter = true;\n            this.setOptions(result);\n\n            this.value(this.transferredValue ? this.transferredValue : initialValue);\n\n            if (excludedOptionsArray.indexOf(initialValue) !== -1) {\n                this.transferredValue = initialValue;\n            } else {\n                this.transferredValue = null;\n            }\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/validator-rules-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/lib/validation/utils'\n], function ($, _, utils) {\n    'use strict';\n\n    /**\n     * Validate the number is between the min and max provided\n     *\n     * @param {Number} value\n     * @param {Number} min\n     * @param {Number} max\n     * @return {Boolean}\n     */\n    function validateNumberBetween(value, min, max) {\n        var numValue;\n\n        if ($.mage.isEmptyNoTrim(value)) {\n            return true;\n        }\n\n        numValue = $.mage.parseNumber(value);\n\n        if (isNaN(numValue)) {\n            return false;\n        }\n\n        return $.mage.isBetween(numValue, min, max);\n    }\n\n    /**\n     * Validate that string is url\n     * @param {String} href\n     * @return {Boolean}\n     */\n    function validateIsUrl(href) {\n        return (/^(http|https|ftp):\\/\\/(([A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))(\\.[A-Z0-9]([A-Z0-9_-]*[A-Z0-9]|))*)(:(\\d+))?(\\/[A-Z0-9~](([A-Z0-9_~-]|\\.)*[A-Z0-9~]|))*\\/?(.*)?$/i).test(href);//eslint-disable-line max-len\n    }\n\n    /**\n     * Validate that string has an anchor tag\n     * @param {String} str\n     * @return {Boolean}\n     */\n    function validateWysiwygHasAnchorTags(str) {\n        return (/<a[\\s]+([^>]+)>|<a>|<\\/a>/igm).test(str);\n    }\n\n    /**\n     * Validate that string has a widget\n     * @param {String} str\n     * @return {Boolean}\n     */\n    function validateWysiwygHasWidget(str) {\n        return (/\\{\\{widget(.*?)\\}\\}/ig).test(str);\n    }\n\n    /**\n     * Validate that string is a proper css-class\n     * @param {String} str\n     * @return {Boolean}\n     */\n    function validateCssClass(str) {\n        return (/^[a-zA-Z _\\-\\d]+$/i).test(str);\n    }\n\n    /**\n     * Validate message field and url field anchor tag is used exclusively by one field\n     * @param {String} message\n     * @param {Object} url\n     * @return {Boolean}\n     */\n    function validateOneAnchorTagField(message, url) {\n        return !(validateWysiwygHasAnchorTags(message) &&\n            ['page', 'product', 'category', 'default'].indexOf(url.type) !== -1 &&\n            url[url.type] &&\n            url[url.type].length > 0);\n    }\n\n    /**\n     * Validate message field and url field html standards, nested widget\n     * @param {String} message\n     * @param {Object} url\n     * @return {Boolean}\n     */\n    function validateNestedWidgetElement(message, url) {\n        return !(validateWysiwygHasWidget(message) &&\n            ['page', 'product', 'category', 'default'].indexOf(url.type) !== -1 &&\n            url[url.type] &&\n            url[url.type].length > 0);\n    }\n\n    /**\n     * Validate a field with an expected data value of type object, like margins_and_padding field\n     * @param {Function} validator\n     * @param {String} ruleName\n     */\n    function validateObjectField(validator, ruleName) {\n        var rule = validator.getRule(ruleName);\n\n        validator.addRule(\n            ruleName,\n            function (value, params) {\n                var allNumbers = true,\n                    handler = rule.handler.bind(this);\n\n                if (typeof value !== 'object') {\n                    return handler(value, params);\n                }\n\n                _.flatten(_.map(value, _.values)).forEach(function (val) {\n                    if (!handler(val, params)) {\n                        allNumbers = false;\n\n                        return allNumbers;\n                    }\n                });\n\n                return allNumbers;\n            },\n            $.mage.__(rule.message)\n        );\n    }\n\n    /**\n     * Validate calc value.\n     *\n     * @param {String} value\n     * @returns {Boolean}\n     */\n    function validateCalc(value) {\n        var el = document.createElement('div'),\n            style = el.style;\n\n        if (!value.trim().length) {\n            return true;\n        }\n\n        style.width = 'calc(' + value + ')';\n\n        return !!style.width.length;\n    }\n\n    return function (validator) {\n        var requiredInputRule = validator.getRule('required-entry');\n\n        validator.addRule(\n            'required-entry-location-name',\n            requiredInputRule.handler,\n            $.mage.__('Please enter the location name.')\n        );\n\n        validator.addRule(\n            'required-entry-latitude',\n            requiredInputRule.handler,\n            $.mage.__('Enter latitude')\n        );\n\n        validator.addRule(\n            'required-entry-longitude',\n            requiredInputRule.handler,\n            $.mage.__('Enter longitude')\n        );\n\n        validator.addRule(\n            'validate-latitude',\n            function (value) {\n                return validateNumberBetween(value, -85, 85);\n            },\n            $.mage.__('Please enter a number between -85 and 85')\n        );\n\n        validator.addRule(\n            'validate-longitude',\n            function (value) {\n                return validateNumberBetween(value, -180, 180);\n            },\n            $.mage.__('Please enter a number between -180 and 180')\n        );\n\n        validator.addRule(\n            'validate-video-url',\n            function (href) {\n                if (utils.isEmptyNoTrim(href)) {\n                    return true;\n                }\n\n                href = (href || '').replace(/^\\s+/, '').replace(/\\s+$/, '');\n\n                return validateIsUrl(href) && (href.match(/youtube\\.com|youtu\\.be/) || href.match(/vimeo\\.com/));\n            },\n            $.mage.__('Please enter a valid video URL.')\n        );\n\n        validator.addRule(\n            'validate-video-source',\n            function (href) {\n                if (utils.isEmptyNoTrim(href)) {\n                    return true;\n                }\n\n                href = (href || '').replace(/^\\s+/, '').replace(/\\s+$/, '');\n\n                return validateIsUrl(href) && (\n                    href.match(/youtube\\.com|youtu\\.be/) ||\n                    href.match(/vimeo\\.com/) ||\n                    href.match(/\\.(mp4|ogv|webm)(?!\\w)/)\n                );\n            },\n            $.mage.__('Please enter a valid video URL. Valid URLs have a video file extension (.mp4, .webm, .ogv) or links to videos on YouTube or Vimeo.')//eslint-disable-line max-len\n        );\n\n        validator.addRule(\n            'validate-css-class',\n            function (value) {\n                if (utils.isEmptyNoTrim(value)) {\n                    return true;\n                }\n\n                return validateCssClass(value);\n            },\n            $.mage.__('Please enter a valid CSS class.')\n        );\n\n        validator.addRule(\n            'required-entry',\n            function (value) {\n                var allFilled;\n\n                // Validation only for margins and paddings\n                if (typeof value === 'object' && !!(value.padding || value.margin)) {\n                    allFilled = true;\n\n                    _.flatten(_.map(value, _.values)).forEach(function (val) {\n                        if (utils.isEmpty(val)) {\n                            allFilled = false;\n\n                            return allFilled;\n                        }\n                    });\n\n                    return allFilled;\n                }\n\n                return requiredInputRule.handler(value);\n            },\n            $.mage.__(requiredInputRule.message)\n        );\n\n        validator.addRule(\n            'validate-message-no-link',\n            function (url, message) {\n                return validateOneAnchorTagField(message, url);\n            },\n            $.mage.__('Adding link in both content and outer element is not allowed.')\n        );\n\n        validator.addRule(\n            'validate-no-url',\n            function (message, url) {\n                return validateOneAnchorTagField(message, url);\n            },\n            $.mage.__('Adding link in both content and outer element is not allowed.')\n        );\n\n        validator.addRule(\n            'validate-message-no-widget',\n            function (url, message) {\n                return validateNestedWidgetElement(message, url);\n            },\n            $.mage.__('Adding link in outer element and widget in content is not allowed.')\n        );\n\n        validator.addRule(\n            'validate-no-widget',\n            function (message, url) {\n                return validateNestedWidgetElement(message, url);\n            },\n            $.mage.__('Adding widget in content and link in outer element is not allowed.')\n        );\n\n        validator.addRule(\n            'validate-calc',\n            function (value) {\n                return validateCalc(value);\n            },\n            $.mage.__('Please enter a valid number or calculation: Valid numbers must have an extension (px, %, pt, vh). Calculations must have white space around the + and - operators and cannot divide by zero.')//eslint-disable-line max-len\n        );\n\n        validator.addRule(\n            'validate-grid-size',\n            function (value, params, additionalParams) {\n                if (value < additionalParams.non_empty_column_count) {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Grid size cannot be smaller than the current total amount of columns, minus any empty columns.')\n        );\n\n        validator.addRule(\n            'validate-max-grid-size',\n            function (value, params, additionalParams) {\n                if (value > additionalParams.max_grid_size) {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter a value less than or equal to the Maximum Column Grid Size configuration.')\n        );\n\n        validateObjectField(validator, 'validate-number');\n        validateObjectField(validator, 'less-than-equals-to');\n        validateObjectField(validator, 'greater-than-equals-to');\n\n        return validator;\n    };\n});\n","Magento_PageBuilder/js/form/element/visual-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/select'\n], function (_, Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            noticeMessage: '',\n            listens: {\n                value: 'setNoticeMessage'\n            }\n        },\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Abstract} Chainable.\n         */\n        initObservable: function () {\n            this._super();\n            this.observe('noticeMessage');\n\n            return this;\n        },\n\n        /**\n         * Parses incoming options, considers options with undefined value property\n         *     as caption\n         *\n         * @param  {Array} nodes\n         * @param {Object} captionValue\n         * @return {Object} captionValue\n         */\n        parseOptions: function (nodes, captionValue) {\n            var caption,\n                value;\n\n            nodes = _.map(nodes, function (node) {\n                value = node.value;\n\n                if ((value === null || value === captionValue) && _.isUndefined(caption)) {\n                    caption = node.label;\n                }\n\n                return node;\n            });\n\n            return {\n                options: _.compact(nodes),\n                caption: _.isString(caption) ? caption : false\n            };\n        },\n\n        /**\n         * Recursively set to object item like value and item.value like key.\n         *\n         * @param {Array} data\n         * @param {Object} result\n         * @returns {Object}\n         */\n        indexOptions: function (data, result) {\n            var value;\n\n            result = result || {};\n\n            data.forEach(function (item) {\n                value = item.value;\n\n                if (Array.isArray(value)) {\n                    this.indexOptions(value, result);\n                } else {\n                    result[value] = item;\n                }\n            });\n\n            return result;\n        },\n\n        /**\n         * Sets 'data' to 'options' observable array, if instance has\n         * 'customEntry' property set to true, calls 'setHidden' method\n         *  passing !options.length as a parameter\n         *\n         * @param {Array} data\n         * @returns {Object} Chainable\n         */\n        setOptions: function (data) {\n            var captionValue = this.captionValue || '',\n                result = this.parseOptions(data, captionValue),\n                isVisible;\n\n            this.indexedOptions = this.indexOptions(result.options);\n\n            this.options(result.options);\n\n            if (!this.caption()) {\n                this.caption(result.caption);\n            }\n\n            if (this.customEntry) {\n                isVisible = !!result.options.length;\n\n                this.setVisible(isVisible);\n                this.toggleInput(!isVisible);\n            }\n\n            return this;\n        },\n\n        /**\n         * Set the notice message on value change\n         *\n         * @param {any} value\n         * @returns {exports}\n         */\n        setNoticeMessage: function (value) {\n            var noticeMessage = '',\n                selectedOption = _.find(this.options(), function (option) {\n                    return option.value === value;\n                });\n\n            if (selectedOption && typeof selectedOption.noticeMessage !== 'undefined') {\n                noticeMessage = selectedOption.noticeMessage;\n            }\n\n            this.noticeMessage(noticeMessage);\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/form/element/wysiwyg.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/form/element/wysiwyg',\n    'mage/translate',\n    'Magento_PageBuilder/js/events',\n    'Magento_Ui/js/lib/view/utils/dom-observer',\n    'Magento_PageBuilder/js/page-builder',\n    'Magento_Ui/js/lib/view/utils/async'\n], function ($, _, Wysiwyg, $t, events, domObserver, PageBuilder) {\n    'use strict';\n\n    /**\n     * Extend the original WYSIWYG with added PageBuilder functionality\n     */\n    return Wysiwyg.extend({\n        defaults: {\n            transition: false,\n            transitionOut: false,\n            elementSelector: '> textarea',\n            stageSelector: '.pagebuilder-stage-wrapper',\n            fieldsetSelector: 'fieldset.admin__fieldset',\n            overlaySelector: '.pagebuilder-wysiwyg-overlay',\n            overlayMouseover: false,\n            pageBuilder: false,\n            visiblePageBuilder: false,\n            isComponentInitialized: false,\n            wysiwygConfigData: {\n                isFullScreen: false\n            },\n            pageBuilderEditButtonText: $t('Edit with Page Builder'),\n            isWithinModal: false,\n            modal: false\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            this._super();\n\n            if (!this.wysiwygConfigData()['pagebuilder_button'] ||\n                this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                this.initPageBuilder();\n            }\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            this._super()\n                .observe('isComponentInitialized visiblePageBuilder wysiwygConfigData loading transition ' +\n                    'transitionOut overlayMouseover');\n\n            return this;\n        },\n\n        /**\n         * Handle button click, init the Page Builder application\n         */\n        pageBuilderEditButtonClick: function (context, event) {\n            this.determineIfWithinModal(event.currentTarget);\n            this.transition(false);\n\n            if (!this.isComponentInitialized()) {\n                this.disableDomObserver($(event.currentTarget).parent()[0]);\n            }\n\n            this.initPageBuilder();\n            this.toggleFullScreen();\n        },\n\n        /**\n         * Init Page Builder\n         */\n        initPageBuilder: function () {\n            if (!this.isComponentInitialized()) {\n                this.loading(true);\n                this.pageBuilder = new PageBuilder(\n                  this.wysiwygConfigData(),\n                  this.initialValue\n                );\n                events.trigger('pagebuilder:register', {\n                    ns: this.ns,\n                    instance: this.pageBuilder\n                });\n                this.initPageBuilderListeners();\n                this.isComponentInitialized(true);\n\n                // Disable the domObserver for the entire stage\n                $.async({\n                    component: this,\n                    selector: this.stageSelector\n                }, this.disableDomObserver.bind(this));\n\n                if (!this.wysiwygConfigData()['pagebuilder_button'] ||\n                    this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                    this.visiblePageBuilder(true);\n                }\n            }\n        },\n\n        /**\n         * Disable the domObserver on the PageBuilder stage to improve performance\n         *\n         * @param {HTMLElement} node\n         */\n        disableDomObserver: function (node) {\n            this.determineIfWithinModal(node);\n            domObserver.disableNode(node);\n            domObserver.disableNode($(node).parents(this.fieldsetSelector)[0]);\n        },\n\n        /**\n         * Changes tabindex and content editable on stage elements\n         */\n        toggleFocusableElements: function () {\n            var pageBuilderSelector = '#' + this.pageBuilder.id,\n                editable = $(pageBuilderSelector).find('[contenteditable]:not(.mceNonEditable)'),\n                focusableSelector = ' :focusable:not(' + this.overlaySelector + ')',\n                mediaSelector = pageBuilderSelector + ' iframe,' + pageBuilderSelector + ' video',\n                tabIndexValue = this.pageBuilder.isFullScreen() ? '0' : '-1',\n                editableValue = this.pageBuilder.isFullScreen();\n\n            editable.attr('contenteditable', editableValue);\n            $(pageBuilderSelector + focusableSelector).attr('tabindex', tabIndexValue);\n            $(mediaSelector).attr('tabindex', tabIndexValue);\n        },\n\n        /**\n         * Determine if the current instance is within a modal\n         *\n         * @param {HTMLElement} element\n         */\n        determineIfWithinModal: function (element) {\n            var modalInnerWrap = $(element).parents('.modal-inner-wrap');\n\n            // Determine if the Page Builder instance is within a modal\n            this.isWithinModal = modalInnerWrap.length === 1;\n\n            if (this.isWithinModal) {\n                this.modal = modalInnerWrap;\n            }\n        },\n\n        /**\n         * Press Enter key on Overlay\n         */\n        onOverlayKeyDown: function (context, event) {\n            if (event.which === 13 || event.keyCode === 13) {\n                this.pageBuilderEditButtonClick(context, event);\n            }\n\n            return true;\n        },\n\n        /**\n         * Toggle Page Builder full screen mode\n         */\n        toggleFullScreen: function () {\n            events.trigger('stage:' + this.pageBuilder.id + ':toggleFullscreen', {\n                animate: !!this.wysiwygConfigData()['pagebuilder_content_snapshot']\n            });\n        },\n\n        /**\n         * Init various listeners on the stage\n         */\n        initPageBuilderListeners: function () {\n            var id = this.pageBuilder.id,\n                renderDeferred = $.Deferred(),\n                fullScreenDeferred = $.Deferred(),\n                rendered = false;\n\n            events.on('stage:' + id + ':readyAfter', function () {\n                this.loading(false);\n            }.bind(this));\n\n            events.on('stage:' + id + ':renderAfter', function () {\n                renderDeferred.resolve();\n                rendered = true;\n            });\n\n            events.on('stage:' + id + ':masterFormatRenderAfter', function (args) {\n                this.value(args.value);\n\n                if (this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                    this.toggleFocusableElements();\n                }\n            }.bind(this));\n\n            events.on('stage:' + id + ':fullScreenModeChangeAfter', function (args) {\n                if (!args.fullScreen) {\n                    if (this.isWithinModal && this.modal) {\n                        _.delay(function () {\n                            this.modal.css({\n                                transform: '',\n                                transition: ''\n                            });\n                        }.bind(this), 350);\n                    }\n\n                    if (this.wysiwygConfigData()['pagebuilder_button'] &&\n                        !this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                        // Force full screen mode whilst the animation occurs\n                        this.transitionOut(true);\n                        // Trigger animation out\n                        this.transition(false);\n\n                        // Reset the transition out class and hide the stage\n                        _.delay(function () {\n                            this.transitionOut(false);\n                            this.visiblePageBuilder(false);\n                        }.bind(this), 185);\n                    }\n                } else if (args.fullScreen) {\n                    if (this.isWithinModal && this.modal) {\n                        this.modal.css({\n                            transform: 'none',\n                            transition: 'none'\n                        });\n                    }\n\n                    if (this.wysiwygConfigData()['pagebuilder_button'] &&\n                        !this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                        this.visiblePageBuilder(true);\n\n                        fullScreenDeferred.resolve();\n\n                        /* eslint-disable max-depth */\n                        // If the stage has already rendered once we don't need to wait until animating the stage in\n                        if (rendered) {\n                            _.defer(function () {\n                                this.transition(true);\n                            }.bind(this));\n                        }\n                        /* eslint-enable max-depth */\n                    }\n                }\n\n                if (this.wysiwygConfigData()['pagebuilder_content_snapshot']) {\n                    this.toggleFocusableElements();\n                }\n            }.bind(this));\n\n            // Wait until the stage is rendered and full screen mode is activated\n            $.when(renderDeferred, fullScreenDeferred).done(function () {\n                _.defer(function () {\n                    this.transition(true);\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            this.pageBuilder && this.pageBuilder.destroy();\n            this._super();\n        }\n    });\n});\n","Magento_PageBuilder/js/form/provider/conditions-data-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'mage/utils/objects',\n    'Magento_Rule/conditions-data-normalizer'\n], function (_, objectUtils, ConditionsDataNormalizer) {\n    'use strict';\n\n    var serializer = new ConditionsDataNormalizer();\n\n    return function (data, attribute) {\n        var pairs = {},\n            conditions = '';\n\n        /*\n         * The Condition Rule Tree is not a UI component and doesn't provide good data.\n         * The best solution is to implement the tree as a UI component that can provide good data but\n         * that is outside of the scope of the feature for now.\n         */\n        _.each(data, function (element, key) {\n            // parameters is hardcoded in the Magento\\Rule model that creates the HTML forms.\n            if (key.indexOf('parameters[' + attribute + ']') === 0) {\n                // Remove the bad, un-normalized data.\n                delete data[key];\n                pairs[key] = element;\n            }\n        });\n\n        /*\n         * The Combine Condition rule needs to have children,\n         * if does not have, we cannot parse the rule in the backend.\n         */\n        _.each(pairs, function (element, key) {\n            var keyIds = key.match(/[\\d?-]+/g),\n              combineElement = 'Magento\\\\CatalogWidget\\\\Model\\\\Rule\\\\Condition\\\\Combine',\n              nextPairsFirstKey = 'parameters[condition_source][NEXT_ITEM--1][type]',\n              nextPairsSecondKey = 'parameters[condition_source][NEXT_ITEM--2][type]';\n\n            if (keyIds !== null && element === combineElement) {\n                if (pairs[nextPairsFirstKey.replace('NEXT_ITEM', keyIds[0])] === undefined ||\n                    pairs[nextPairsFirstKey.replace('NEXT_ITEM', keyIds[0])] === combineElement &&\n                    pairs[nextPairsSecondKey.replace('NEXT_ITEM', keyIds[0])] === undefined) {\n                    pairs[key] = '';\n                }\n            }\n        });\n\n        /*\n         * Add pairs in case conditions source is not rules configurator\n         */\n        if (data['condition_option'] !== 'condition') {\n            pairs['parameters[' + attribute + '][1--1][operator]'] =\n                data[data['condition_option'] + '-condition_operator'] ?\n                data[data['condition_option'] + '-condition_operator'] :\n                '==';\n            pairs['parameters[' + attribute + '][1--1][type]'] =\n                'Magento\\\\CatalogWidget\\\\Model\\\\Rule\\\\Condition\\\\Product';\n            pairs['parameters[' + attribute + '][1][aggregator]'] = 'all';\n            pairs['parameters[' + attribute + '][1][new_child]'] = '';\n            pairs['parameters[' + attribute + '][1][type]'] = 'Magento\\\\CatalogWidget\\\\Model\\\\Rule\\\\Condition\\\\Combine';\n            pairs['parameters[' + attribute + '][1][value]'] = '1';\n            pairs['parameters[' + attribute + '][1--1][attribute]'] = data['condition_option'];\n            pairs['parameters[' + attribute + '][1--1][value]'] = _.isString(data[data['condition_option']]) ?\n                data[data['condition_option']].trim() :\n                '';\n        }\n\n        if (!_.isEmpty(pairs)) {\n            conditions = JSON.stringify(serializer.normalize(pairs).parameters[attribute]);\n            data['conditions_encoded'] = conditions;\n            objectUtils.nested(data, attribute, conditions);\n        }\n    };\n});\n","Magento_PageBuilder/js/grid/cells/single-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/multiselect',\n    'underscore'\n], function (Select, _) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            headerTmpl: 'ui/grid/columns/text',\n            bodyTmpl: 'Magento_PageBuilder/grid/cells/single-select',\n            label: '',\n            extendedSelections: [],\n            lastSelected: null,\n            listens: {\n                selected: 'onSelectedChange setExtendedSelections'\n            }\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('extendedSelections lastSelected');\n\n            return this;\n        },\n\n        /**\n         * Getter for extended selections.\n         *\n         * @returns {Array}\n         */\n        getExtendedSelections: function () {\n            return this.extendedSelections();\n        },\n\n        /**\n         * Setter for extended selections.\n         *\n         * @param {Array} selected\n         */\n        setExtendedSelections: function (selected) {\n            var item = {},\n                extended = [];\n\n            _.each(selected, function (id) {\n                item[this.indexField] = id;\n                extended.push(_.findWhere(this.rows(), item));\n            }, this);\n\n            this.set('extendedSelections', extended);\n        },\n\n        /** @inheritdoc */\n        isSelected: function (id, isIndex) {\n            id = this.getId(id, isIndex);\n\n            return this.selected()[0] === id;\n        },\n\n        /** @inheritdoc **/\n        select: function (id) {\n            this._super();\n            this.lastSelected(id);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        _setSelection: function (id, isIndex, select) {\n            var selected = this.selected;\n\n            id = this.getId(id, isIndex);\n\n            if (!select && this.isSelected(id)) {\n                selected([]);\n            } else if (select) {\n                selected([id]);\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/grid/cells/template-apply.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/multiselect',\n    'Magento_PageBuilder/js/modal/dismissible-confirm',\n    'mage/translate'\n], function (Select, confirm, $t) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            headerTmpl: 'ui/grid/columns/text',\n            bodyTmpl: 'Magento_PageBuilder/grid/cells/template-apply',\n            label: '',\n            lastSelected: null\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('lastSelected');\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        isSelected: function () {\n            return false;\n        },\n\n        /** @inheritdoc **/\n        select: function (id) {\n            var self = this,\n                superCall = this._super.bind(this);\n\n            self.lastSelected(null);\n\n            confirm({\n                title: $t('Apply Template'),\n                content: $t('Are you sure you want to apply this template? This will overwrite any existing content.'),\n                dismissKey: 'pagebuilder_template_apply_confirm',\n                dismissible: true,\n                actions: {\n                    /**\n                     * Confirm action\n                     */\n                    confirm: function () {\n                        superCall();\n                        self.lastSelected(id);\n                    }\n                },\n                buttons: [{\n                    text: $t('Cancel'),\n                    class: 'action-secondary action-dismiss action-pagebuilder-cancel',\n\n                    /**\n                     * Close modal and trigger 'cancel' action on click\n                     */\n                    click: function (event) {\n                        this.closeModal(event);\n                    }\n                }, {\n                    text: $t('Apply'),\n                    class: 'action-primary action-accept',\n\n                    /**\n                     * Close modal and trigger 'confirm' action on click\n                     */\n                    click: function (event) {\n                        superCall();\n                        self.lastSelected(id);\n                        this.closeModal(event);\n                    }\n                }]\n            });\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        _setSelection: function () {\n            return this;\n        }\n    });\n});\n","Magento_PageBuilder/js/grid/columns/actions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/actions'\n], function (Actions) {\n    'use strict';\n\n    return Actions.extend({\n        defaults: {\n        },\n\n        /**\n         * Callback after click on element.\n         *\n         * @public\n         */\n        applyAction: function () {\n            switch (this.type) {\n                case 'edit-user':\n                    $(this).userEdit(this.options)\n                        .trigger('editUser');\n                    break;\n\n                case 'delete-user':\n                    $(this).userDelete(this.options)\n                        .trigger('deleteUser');\n                    break;\n\n                case 'delete-role':\n                    $(this).roleDelete(this.options)\n                        .trigger('deleteRole');\n                    break;\n\n                default:\n                    return true;\n            }\n        }\n    });\n});\n","Magento_PageBuilder/js/grid/columns/preview-image.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'jquery',\n    'mage/template',\n    'text!Magento_PageBuilder/template/grid/cells/preview-image/preview.html',\n    'underscore',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate'\n], function (Column, $, mageTemplate, thumbnailPreviewTemplate, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'ui/grid/cells/thumbnail',\n            fieldClass: {\n                'data-grid-preview-image-cell': true\n            }\n        },\n\n        /**\n         * Get image source data per row.\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getSrc: function (row) {\n            return row[this.index + '_src'];\n        },\n\n        /**\n         * Retrieve the original images src to be displayed at full size in the modal\n         *\n         * @param {Object} row\n         * @returns {*}\n         */\n        getOrigSrc: function (row) {\n            return row[this.index + '_orig_src'];\n        },\n\n        /**\n         * Get alternative text data per row.\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getAlt: function (row) {\n            return _.escape(row[this.index + '_alt']);\n        },\n\n        /**\n         * Check if preview available.\n         *\n         * @returns {Boolean}\n         */\n        isPreviewAvailable: function () {\n            return this['has_preview'] || false;\n        },\n\n        /**\n         * Build preview.\n         *\n         * @param {Object} row\n         */\n        preview: function (row) {\n            var modalHtml = mageTemplate(\n                thumbnailPreviewTemplate,\n                {\n                    src: this.getOrigSrc(row),\n                    alt: this.getAlt(row)\n                }\n            ),\n                previewPopup = $('<div/>').html(modalHtml);\n\n            previewPopup.modal({\n                title: this.getAlt(row),\n                innerScroll: true,\n                modalClass: '_image-box',\n                buttons: []\n            }).trigger('openModal');\n        },\n\n        /**\n         * Get field handler per row.\n         *\n         * @param {Object} row\n         * @returns {Function}\n         */\n        getFieldHandler: function (row) {\n            if (this.isPreviewAvailable()) {\n                return this.preview.bind(this, row);\n            }\n        }\n    });\n});\n","Magento_PageBuilder/js/mass-converter/background-images.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/image\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _image, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var BackgroundImages = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function BackgroundImages() {}\n\n    var _proto = BackgroundImages.prototype;\n\n    /**\n     * Process data after it's read and converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var directive = (0, _object.get)(data, config.attribute_name);\n\n      if (directive) {\n        var images = JSON.parse(directive.replace(/\\\\(.)/mg, \"$1\")) || {};\n\n        if (!_underscore.isUndefined(images.desktop_image)) {\n          (0, _object.set)(data, config.desktop_image_variable, (0, _image.decodeUrl)(images.desktop_image));\n        }\n\n        if (!_underscore.isUndefined(images.mobile_image)) {\n          (0, _object.set)(data, config.mobile_image_variable, (0, _image.decodeUrl)(images.mobile_image));\n        }\n\n        delete data[config.attribute_name];\n      }\n\n      return data;\n    }\n    /**\n     * Process data before it's converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var desktopImage = (0, _object.get)(data, config.desktop_image_variable);\n      var mobileImage = (0, _object.get)(data, config.mobile_image_variable);\n      var directiveData = {};\n\n      if (!_underscore.isUndefined(desktopImage) && desktopImage && !_underscore.isUndefined(desktopImage[0])) {\n        directiveData.desktop_image = (0, _image.urlToDirective)(desktopImage[0].url);\n      }\n\n      if (!_underscore.isUndefined(mobileImage) && mobileImage && !_underscore.isUndefined(mobileImage[0])) {\n        directiveData.mobile_image = (0, _image.urlToDirective)(mobileImage[0].url);\n      } // Add the directive data, ensuring we escape double quotes\n\n\n      (0, _object.set)(data, config.attribute_name, JSON.stringify(directiveData).replace(/[\\\\\"']/g, \"\\\\$&\").replace(/\\u0000/g, \"\\\\0\"));\n      return data;\n    };\n\n    return BackgroundImages;\n  }();\n\n  return BackgroundImages;\n});\n//# sourceMappingURL=background-images.js.map","Magento_PageBuilder/js/mass-converter/background-type.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var BackgroundType = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function BackgroundType() {}\n\n    var _proto = BackgroundType.prototype;\n\n    /**\n     * Process data after it's read and converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      return data;\n    }\n    /**\n     * Process data before it's converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var backgroundType = (0, _object.get)(data, config.attribute_name);\n\n      if (backgroundType === \"video\") {\n        (0, _object.set)(data, config.desktop_image_variable, []);\n        (0, _object.set)(data, config.mobile_image_variable, []);\n      } else if (backgroundType === \"image\") {\n        (0, _object.set)(data, config.video_source_variable, null);\n        (0, _object.set)(data, config.video_fallback_image_variable, []);\n        (0, _object.set)(data, config.video_overlay_color_variable, \"\");\n      }\n\n      return data;\n    };\n\n    return BackgroundType;\n  }();\n\n  return BackgroundType;\n});\n//# sourceMappingURL=background-type.js.map","Magento_PageBuilder/js/mass-converter/converter-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=converter-interface.js.map","Magento_PageBuilder/js/mass-converter/converter-pool-factory.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/loader\", \"Magento_PageBuilder/js/mass-converter/converter-pool\"], function (_config, _loader, _converterPool) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create a new instance of converter pool\n   */\n  function create(contentType) {\n    var config = _config.getContentTypeConfig(contentType);\n\n    var converters = [];\n    var appearanceName;\n\n    for (var _i = 0, _Object$keys = Object.keys(config.appearances); _i < _Object$keys.length; _i++) {\n      appearanceName = _Object$keys[_i];\n      var appearance = config.appearances[appearanceName];\n\n      if (undefined !== appearance && undefined !== appearance.converters) {\n        for (var _iterator = _createForOfIteratorHelperLoose(appearance.converters), _step; !(_step = _iterator()).done;) {\n          var converterConfig = _step.value;\n\n          if (!!converterConfig.component && !_converterPool.get(converterConfig.component)) {\n            converters.push(converterConfig.component);\n          }\n        }\n      }\n    }\n\n    return new Promise(function (resolve) {\n      (0, _loader)(converters, function () {\n        for (var _len = arguments.length, loadedConverters = new Array(_len), _key = 0; _key < _len; _key++) {\n          loadedConverters[_key] = arguments[_key];\n        }\n\n        for (var i = 0; i < converters.length; i++) {\n          _converterPool.register(converters[i], new loadedConverters[i]());\n        }\n\n        resolve(_converterPool);\n      });\n    });\n  }\n\n  return create;\n});\n//# sourceMappingURL=converter-pool-factory.js.map","Magento_PageBuilder/js/mass-converter/converter-pool.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var DataConverterPool = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function DataConverterPool() {\n      this.converters = {};\n    }\n\n    var _proto = DataConverterPool.prototype;\n\n    /**\n     * Retrieve a data converter instance from the pool\n     *\n     * @param {string} name\n     * @returns {ConverterInterface}\n     */\n    _proto.get = function get(name) {\n      return this.converters[name] !== undefined ? this.converters[name] : null;\n    }\n    /**\n     * Register a new data converter into the pool\n     *\n     * @param {string} name\n     * @param {ConverterInterface} converter\n     */\n    ;\n\n    _proto.register = function register(name, converter) {\n      this.converters[name] = converter;\n    };\n\n    return DataConverterPool;\n  }();\n\n  var _default = new DataConverterPool();\n\n  return _default;\n});\n//# sourceMappingURL=converter-pool.js.map","Magento_PageBuilder/js/mass-converter/empty-mobile-image.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/object\"], function (_object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var EmptyMobileImage = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function EmptyMobileImage() {}\n\n    var _proto = EmptyMobileImage.prototype;\n\n    /**\n     * Process data after it's read and converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {object} config\n     * @returns {object}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var desktopImage = (0, _object.get)(data, config.desktop_image_variable);\n      var mobileImage = (0, _object.get)(data, config.mobile_image_variable);\n\n      if (mobileImage && desktopImage && mobileImage[0] !== undefined && desktopImage[0] !== undefined && mobileImage[0].url === desktopImage[0].url) {\n        delete data[config.mobile_image_variable];\n      }\n\n      return data;\n    }\n    /**\n     * Process data before it's converted by element converters\n     *\n     * @param {ConverterDataInterface} data\n     * @param {object} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      var mobileImage = (0, _object.get)(data, config.mobile_image_variable);\n\n      if (mobileImage === undefined || mobileImage[0] === undefined) {\n        (0, _object.set)(data, config.mobile_image_variable, (0, _object.get)(data, config.desktop_image_variable));\n      }\n\n      return data;\n    };\n\n    return EmptyMobileImage;\n  }();\n\n  return EmptyMobileImage;\n});\n//# sourceMappingURL=empty-mobile-image.js.map","Magento_PageBuilder/js/mass-converter/widget-directive-abstract.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"underscore\", \"Magento_PageBuilder/js/utils/object\"], function (_underscore, _object) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var WidgetDirectiveAbstract = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function WidgetDirectiveAbstract() {}\n\n    var _proto = WidgetDirectiveAbstract.prototype;\n\n    /**\n     * Convert value to internal format\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {WidgetDirectiveAttributes}\n     */\n    _proto.fromDom = function fromDom(data, config) {\n      var _this = this;\n\n      var attributes = {};\n      (0, _object.get)(data, config.html_variable).replace(/\\{\\{widget([\\S\\s]*?)\\}\\}/i, function (match, attributeString) {\n        attributes = _this.parseAttributesString(attributeString);\n      }.bind(this));\n      return attributes;\n    }\n    /**\n     * Convert value to knockout format\n     *\n     * @param {ConverterDataInterface} data\n     * @param {ConverterConfigInterface} config\n     * @returns {object}\n     */\n    ;\n\n    _proto.toDom = function toDom(data, config) {\n      (0, _object.set)(data, config.html_variable, this.buildDirective(data));\n      return data;\n    }\n    /**\n     * Build the directive string using the supplies attributes\n     *\n     * @param {object} attributes\n     * @returns {string}\n     */\n    ;\n\n    _proto.buildDirective = function buildDirective(attributes) {\n      return \"{{widget \" + this.createAttributesString(attributes) + \"}}\";\n    }\n    /**\n     * @param {string} attributes\n     * @return {Object}\n     */\n    ;\n\n    _proto.parseAttributesString = function parseAttributesString(attributes) {\n      var result = {};\n      attributes.replace(/(\\w+)(?:\\s*=\\s*(?:(?:\"((?:\\\\.|[^\"])*)\")|(?:'((?:\\\\.|[^'])*)')|([^>\\s]+)))?/g, function (match, key, value) {\n        result[key] = value.replace(/&quote;/g, \"\\\"\");\n        return \"\";\n      });\n      return result;\n    }\n    /**\n     * @param {Object} attributes\n     * @return {string}\n     */\n    ;\n\n    _proto.createAttributesString = function createAttributesString(attributes) {\n      var result = \"\";\n\n      _underscore.each(attributes, function (value, name) {\n        result += name + \"=\\\"\" + String(value).replace(/\"/g, \"&quote;\") + \"\\\" \";\n      });\n\n      return result.substr(0, result.length - 1);\n    };\n\n    return WidgetDirectiveAbstract;\n  }();\n\n  return WidgetDirectiveAbstract;\n});\n//# sourceMappingURL=widget-directive-abstract.js.map","Magento_PageBuilder/js/master-format/filter-html.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\"], function (_jquery) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Filter the HTML output to only include necessary attributes & nodes\n   *\n   * @param {JQuery} element\n   * @returns {JQuery}\n   */\n  function filterHtml(element) {\n    var isWhiteSpaceOrComment = function isWhiteSpaceOrComment() {\n      return this.nodeType === Node.COMMENT_NODE || this.nodeType === Node.TEXT_NODE && this.data.match(/^\\s+$/);\n    };\n\n    element.find(\"[data-bind]\").each(function (index, value) {\n      (0, _jquery)(value).removeAttr(\"data-bind\");\n    });\n    element.contents().filter(isWhiteSpaceOrComment).remove();\n    element.find(\"*\").filter(function (index, descendentEl) {\n      // filter out elements that are iframes or have .bypass-html-filter ancestor\n      var isIframe = descendentEl.tagName === \"IFRAME\";\n      var isBeingBypassedByThisFilter = !!(0, _jquery)(descendentEl).closest(\".bypass-html-filter\").length;\n      return !isIframe && !isBeingBypassedByThisFilter;\n    }).each(function (index, descendentEl) {\n      (0, _jquery)(descendentEl).contents().filter(isWhiteSpaceOrComment).remove();\n    });\n    element.find(\"[data-wrapper]\").each(function (index, value) {\n      (0, _jquery)(value).parent().append((0, _jquery)(value).children());\n      (0, _jquery)(value).remove();\n    });\n    element.find(\".bypass-html-filter\").each(function (index, value) {\n      (0, _jquery)(value).removeClass(\"bypass-html-filter\").filter('[class=\"\"]').removeAttr(\"class\");\n    });\n    return element;\n  }\n\n  return filterHtml;\n});\n//# sourceMappingURL=filter-html.js.map","Magento_PageBuilder/js/master-format/read-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=read-interface.js.map","Magento_PageBuilder/js/master-format/render.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"jquery\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/master-format/render/serialize\"], function (_jquery, _config, _serialize) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var MasterFormatRenderer = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param stageId\n     */\n    function MasterFormatRenderer(stageId) {\n      this.ready = false;\n      this.readyDeferred = _jquery.Deferred();\n      this.stageId = stageId;\n    }\n    /**\n     * Render the root container into a string utilising our sandboxed iframe\n     *\n     * @param {ContentTypeCollection} rootContainer\n     * @returns {Promise<string>}\n     */\n\n\n    var _proto = MasterFormatRenderer.prototype;\n\n    _proto.applyBindings = function applyBindings(rootContainer) {\n      var _this = this;\n\n      return new Promise(function (resolve, reject) {\n        if (!_this.getRenderFrame()) {\n          // If the stage exists we should also have a frame\n          if (document.getElementById(_this.stageId)) {\n            return reject(\"No render frame present for Page Builder instance.\");\n          } // Otherwise the instance of Page Builder has been removed from the DOM and this is an old instance.\n\n\n          return reject();\n        }\n\n        if (_this.ready) {\n          _this.channel.port1.postMessage({\n            type: \"render\",\n            message: {\n              stageId: _this.stageId,\n              tree: (0, _serialize.getSerializedTree)(rootContainer)\n            }\n          });\n\n          _this.channel.port1.onmessage = function (event) {\n            if (event.isTrusted) {\n              if (event.data.type === \"render\") {\n                resolve(event.data.message);\n              }\n\n              if (event.data.type === \"template\") {\n                _this.loadTemplate(event.data.message);\n              }\n            } else {\n              reject(\"Render event was not trusted.\");\n            }\n          };\n        } else {\n          _this.readyDeferred.then(function () {\n            _this.applyBindings(rootContainer).then(function (rendered) {\n              resolve(rendered);\n            }).catch(function (error) {\n              reject(error);\n            });\n          });\n        }\n      });\n    }\n    /**\n     * Create a channel to communicate with our sandboxed iframe. Firstly add a listener to the current window and then\n     * set the src of the iframe. Listening for a specific message event with a predefined term and then hand over the\n     * MessageChannel port to allow communication between the main window and iframe.\n     */\n    ;\n\n    _proto.setupChannel = function setupChannel() {\n      var _this2 = this;\n\n      this.channel = new MessageChannel();\n      var frame = this.getRenderFrame();\n      window.addEventListener(\"message\", function (event) {\n        if (!_this2.ready && event.data.name === \"PB_RENDER_READY\" && _this2.stageId === event.data.stageId) {\n          frame.contentWindow.postMessage(\"PB_RENDER_PORT\", \"*\", [_this2.channel.port2]);\n          _this2.ready = true;\n\n          _this2.readyDeferred.resolve();\n        }\n      });\n      frame.src = _config.getConfig(\"render_url\") + \"?stageId=\" + this.stageId;\n    }\n    /**\n     * Use the text! RequireJS plugin to load a template and send it back to the child render iframe\n     *\n     * @param name\n     */\n    ;\n\n    _proto.loadTemplate = function loadTemplate(name) {\n      var _this3 = this;\n\n      require([\"text!\" + name], function (template) {\n        _this3.channel.port1.postMessage({\n          type: \"template\",\n          message: {\n            name: name,\n            template: template\n          }\n        });\n      });\n    }\n    /**\n     * Retrieve the render frame\n     *\n     * @returns {HTMLIFrameElement}\n     */\n    ;\n\n    _proto.getRenderFrame = function getRenderFrame() {\n      return document.getElementById(\"render_frame_\" + this.stageId);\n    };\n\n    return MasterFormatRenderer;\n  }();\n\n  return MasterFormatRenderer;\n});\n//# sourceMappingURL=render.js.map","Magento_PageBuilder/js/master-format/validator.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\"], function (_config) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Validate if content has page builder format by checking for any data-content-type attributes\n   *\n   * @param {string} content\n   * @returns {boolean}\n   */\n  function validate(content) {\n    var stageDocument = new DOMParser().parseFromString(content, \"text/html\");\n    return !!stageDocument.querySelector(\"[\" + _config.getConfig(\"dataContentTypeAttributeName\") + \"]\");\n  }\n\n  return validate;\n});\n//# sourceMappingURL=validator.js.map","Magento_PageBuilder/js/master-format/read/configurable.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"jquery\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type/appearance-config\", \"Magento_PageBuilder/js/converter/converter-pool-factory\", \"Magento_PageBuilder/js/mass-converter/converter-pool-factory\", \"Magento_PageBuilder/js/property/property-reader-pool-factory\"], function (_jquery, _mageUtils, _underscore, _config, _appearanceConfig, _converterPoolFactory, _converterPoolFactory2, _propertyReaderPoolFactory) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Configurable = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Configurable() {}\n\n    var _proto = Configurable.prototype;\n\n    /**\n     * Read data from the dom based on configuration\n     *\n     * @param element HTMLElement\n     * @returns {Promise<any>}\n     */\n    _proto.read = function read(element) {\n      var _this = this;\n\n      var role = element.getAttribute(_config.getConfig(\"dataContentTypeAttributeName\"));\n      var config = (0, _appearanceConfig)(role, element.getAttribute(\"data-appearance\"));\n      var componentsPromise = [(0, _propertyReaderPoolFactory)(role), (0, _converterPoolFactory)(role), (0, _converterPoolFactory2)(role)];\n      return new Promise(function (resolve) {\n        Promise.all(componentsPromise).then(function (loadedComponents) {\n          var propertyReaderPool = loadedComponents[0],\n              converterPool = loadedComponents[1],\n              massConverterPool = loadedComponents[2];\n\n          var viewports = _config.getConfig(\"viewports\");\n\n          var data = {};\n\n          _underscore.each(viewports, function (viewport, name) {\n            return data[name] = {};\n          });\n\n          var _loop = function _loop() {\n            var elementName = _Object$keys[_i];\n            var elementConfig = config.elements[elementName];\n\n            var currentElement = _this.findElementByName(element, elementName); // If we cannot locate the current element skip trying to read any attributes from it\n\n\n            if (currentElement === null || currentElement === undefined) {\n              return \"continue\";\n            }\n\n            _underscore.each(viewports, function (viewportObj, viewport) {\n              currentElement.setAttribute(\"style\", currentElement.getAttribute(\"data-\" + viewport + \"-style\"));\n\n              if (elementConfig.style.length) {\n                data[viewport] = _this.readStyle(elementConfig.style, currentElement, data[viewport], propertyReaderPool, converterPool);\n              }\n\n              if (elementConfig.attributes.length) {\n                data[viewport] = _this.readAttributes(elementConfig.attributes, currentElement, data[viewport], propertyReaderPool, converterPool);\n              }\n\n              if (undefined !== elementConfig.html.var) {\n                data[viewport] = _this.readHtml(elementConfig, currentElement, data[viewport], converterPool);\n              }\n\n              if (undefined !== elementConfig.tag.var) {\n                data[viewport] = _this.readHtmlTag(elementConfig, currentElement, data[viewport]);\n              }\n\n              if (undefined !== elementConfig.css.var) {\n                data[viewport] = _this.readCss(elementConfig, currentElement, data[viewport]);\n              }\n            });\n          };\n\n          for (var _i = 0, _Object$keys = Object.keys(config.elements); _i < _Object$keys.length; _i++) {\n            var _ret = _loop();\n\n            if (_ret === \"continue\") continue;\n          }\n\n          _underscore.each(viewports, function (viewportObj, viewport) {\n            data[viewport] = _this.convertData(config, data[viewport], massConverterPool);\n          });\n\n          resolve(data);\n        }).catch(function (error) {\n          console.error(error);\n        });\n      });\n    }\n    /**\n     * Find the element for the current content type by it's name, avoiding searching in other content types by\n     * removing any other element which contains it's own data-content-type.\n     *\n     * @param {HTMLElement} element\n     * @param {string} name\n     * @returns {HTMLElement}\n     */\n    ;\n\n    _proto.findElementByName = function findElementByName(element, name) {\n      // Create a clone of the element to avoid modifying the source\n      var currentElement = (0, _jquery)(element).clone();\n\n      if (currentElement.attr(\"data-element\") === name) {\n        return currentElement[0];\n      } // Attempt to find the element in the children of the data-content-type\n\n\n      var searchInChildren = currentElement.find(\"[data-element=\\\"\" + name + \"\\\"]\"); // Ensure the element is within the current content type\n\n      if (searchInChildren.length > 0 && searchInChildren.closest(\"[data-content-type]\")[0] === currentElement[0]) {\n        return searchInChildren[0];\n      }\n\n      return null;\n    }\n    /**\n     * Read attributes for element\n     *\n     * @param {DataMappingAttributesInterface[]} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @param {typeof PropertyReaderPool} propertyReaderPool\n     * @param {typeof ConverterPool} converterPool\n     * @returns {any}\n     */\n    ;\n\n    _proto.readAttributes = function readAttributes(config, element, data, propertyReaderPool, converterPool) {\n      var result = {};\n\n      for (var _iterator = _createForOfIteratorHelperLoose(config), _step; !(_step = _iterator()).done;) {\n        var attributeConfig = _step.value;\n\n        if (\"write\" === attributeConfig.persistence_mode) {\n          continue;\n        }\n\n        var value = !!attributeConfig.static ? attributeConfig.value : propertyReaderPool.get(attributeConfig.reader).read(element, attributeConfig.name);\n\n        if (converterPool.get(attributeConfig.converter)) {\n          value = converterPool.get(attributeConfig.converter).fromDom(value);\n        }\n\n        if (_jquery.type(result[attributeConfig.var]) === \"object\") {\n          var _mageUtils$extend;\n\n          value = _mageUtils.extend((_mageUtils$extend = {}, _mageUtils$extend[attributeConfig.name] = value, _mageUtils$extend), result[attributeConfig.var]);\n        }\n\n        result[attributeConfig.var] = value;\n      }\n\n      return _underscore.extend(data, result);\n    }\n    /**\n     * Read style properties for element\n     *\n     * @param {DataMappingStyleInterface[]} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @param {typeof PropertyReaderPool} propertyReaderPool\n     * @param {typeof ConverterPool} converterPool\n     * @returns {{[p: string]: string}}\n     */\n    ;\n\n    _proto.readStyle = function readStyle(config, element, data, propertyReaderPool, converterPool) {\n      var result = _underscore.extend({}, data);\n\n      for (var _iterator2 = _createForOfIteratorHelperLoose(config), _step2; !(_step2 = _iterator2()).done;) {\n        var propertyConfig = _step2.value;\n\n        if (\"write\" === propertyConfig.persistence_mode) {\n          continue;\n        }\n\n        var value = !!propertyConfig.static ? propertyConfig.value : propertyReaderPool.get(propertyConfig.reader).read(element, propertyConfig.name);\n\n        if (converterPool.get(propertyConfig.converter)) {\n          value = converterPool.get(propertyConfig.converter).fromDom(value);\n        }\n\n        if (_jquery.type(result[propertyConfig.var]) === \"object\") {\n          value = _mageUtils.extend(result[propertyConfig.var], value);\n        }\n\n        result[propertyConfig.var] = value;\n      }\n\n      return result;\n    }\n    /**\n     * Read element's tag\n     *\n     * @param {object} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @returns {object}\n     */\n    ;\n\n    _proto.readHtmlTag = function readHtmlTag(config, element, data) {\n      var result = {};\n      result[config.tag.var] = element.nodeName.toLowerCase();\n      return _underscore.extend(data, result);\n    }\n    /**\n     * Read element's css\n     *\n     * @param {ContentTypeConfigAppearanceElementInterface} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @returns {any}\n     */\n    ;\n\n    _proto.readCss = function readCss(config, element, data) {\n      var result = {};\n      var css = element.getAttribute(\"class\") !== null ? element.getAttribute(\"class\") : \"\";\n\n      if (config.css !== undefined && config.css.filter !== undefined && config.css.filter.length) {\n        for (var _iterator3 = _createForOfIteratorHelperLoose(config.css.filter), _step3; !(_step3 = _iterator3()).done;) {\n          var filterClass = _step3.value;\n          css = css.replace(filterClass, \"\");\n        }\n      }\n\n      result[config.css.var] = css.replace(/\\s{2,}/g, \" \").trim();\n      return _underscore.extend(data, result);\n    }\n    /**\n     * Read element's content\n     *\n     * @param {ContentTypeConfigAppearanceElementInterface} config\n     * @param {HTMLElement} element\n     * @param {object} data\n     * @param {typeof ConverterPool} converterPool\n     * @returns {any}\n     */\n    ;\n\n    _proto.readHtml = function readHtml(config, element, data, converterPool) {\n      var result = {};\n      var value = element.innerHTML;\n\n      if (converterPool.get(config.html.converter)) {\n        value = converterPool.get(config.html.converter).fromDom(value);\n      }\n\n      result[config.html.var] = value;\n      return _underscore.extend(data, result);\n    }\n    /**\n     * Convert data after it's read for all elements\n     *\n     * @param config\n     * @param {object} data\n     * @param {typeof MassConverterPool} massConverterPool\n     * @returns {object}\n     */\n    ;\n\n    _proto.convertData = function convertData(config, data, massConverterPool) {\n      for (var _iterator4 = _createForOfIteratorHelperLoose(config.converters), _step4; !(_step4 = _iterator4()).done;) {\n        var converterConfig = _step4.value;\n\n        if (massConverterPool.get(converterConfig.component)) {\n          data = massConverterPool.get(converterConfig.component).fromDom(data, converterConfig.config);\n        }\n      }\n\n      return data;\n    };\n\n    return Configurable;\n  }();\n\n  return Configurable;\n});\n//# sourceMappingURL=configurable.js.map","Magento_PageBuilder/js/master-format/render/events.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * The frame does not need to create or observe events, however the app will naturally attempt to. So let's stop that!\n   */\n  var _default = {\n    on: function on() {\n      return this;\n    },\n    off: function off() {\n      return this;\n    },\n    trigger: function trigger() {\n      return this;\n    }\n  };\n  return _default;\n});\n//# sourceMappingURL=events.js.map","Magento_PageBuilder/js/master-format/render/frame.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"csso\", \"jquery\", \"knockout\", \"Magento_Ui/js/lib/knockout/template/engine\", \"mageUtils\", \"underscore\", \"Magento_PageBuilder/js/binding/master-style\", \"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-factory\", \"Magento_PageBuilder/js/content-type/style-registry\", \"Magento_PageBuilder/js/utils/directives\", \"Magento_PageBuilder/js/master-format/filter-html\"], function (_csso, _jquery, _knockout, _engine, _mageUtils, _underscore, _masterStyle, _config, _contentTypeFactory, _styleRegistry, _directives, _filterHtml) {\n  function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== \"function\") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }\n\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var port = null;\n\n  var portDeferred = _jquery.Deferred();\n\n  var deferredTemplates = {};\n  var lastRenderId;\n  /**\n   * Debounce the render call, so we don't render until the final request\n   */\n\n  var debounceRender = _underscore.debounce(function (message, renderId) {\n    render(message, renderId).then(function (output) {\n      // Only post the most recent render back to the parent\n      if (lastRenderId === renderId) {\n        port.postMessage({\n          type: \"render\",\n          message: output\n        });\n      }\n    });\n  }, 50);\n  /**\n   * Listen for requests from the parent window for a render\n   */\n\n\n  function listen(config) {\n    var stageId = window.location.href.split(\"?\")[1].split(\"=\")[1];\n\n    _config.setConfig(config);\n\n    _config.setMode(\"Master\"); // Override assign with extend to prevent deep object overriding.\n\n\n    Object.assign = _mageUtils.extend;\n    /**\n     * Create a listener within our iframe so we can observe messages from the parent, once we receive a port on the\n     * MessageChannel we utilise that for all communication.\n     */\n\n    window.addEventListener(\"message\", function (event) {\n      if (event.ports && event.ports.length) {\n        port = event.ports[0];\n        portDeferred.resolve(port);\n\n        port.onmessage = function (messageEvent) {\n          if (messageEvent.data.type === \"render\") {\n            var renderId = _mageUtils.uniqueid();\n\n            lastRenderId = renderId;\n            debounceRender(messageEvent.data.message, renderId);\n          }\n\n          if (messageEvent.data.type === \"template\") {\n            var message = messageEvent.data.message;\n\n            if (message.name in deferredTemplates) {\n              deferredTemplates[message.name].resolve(message.template);\n              delete deferredTemplates[message.name];\n            }\n          }\n        };\n      }\n    }, false); // Inform the parent iframe that we're ready to receive the port\n\n    window.parent.postMessage({\n      name: \"PB_RENDER_READY\",\n      stageId: stageId\n    }, \"*\");\n  }\n  /**\n   * Use our MessageChannel to load a template from the parent window, this is required as the iframe isn't allowed to\n   * make same origin XHR requests.\n   *\n   * @param name\n   */\n\n\n  function loadTemplate(name) {\n    return new Promise(function (resolve) {\n      if (!(name in deferredTemplates)) {\n        deferredTemplates[name] = _jquery.Deferred();\n      }\n\n      deferredTemplates[name].then(function (template) {\n        resolve(template);\n      });\n\n      if (port) {\n        port.postMessage({\n          type: \"template\",\n          message: name\n        });\n      } else {\n        portDeferred.then(function (messagePort) {\n          messagePort.postMessage({\n            type: \"template\",\n            message: name\n          });\n        });\n      }\n    });\n  }\n  /**\n   * Assert if the render has finished\n   */\n\n\n  var assertRenderFinished = _underscore.debounce(function (element, expectedCount, callback) {\n    if (element.querySelectorAll(\"[data-content-type]\").length === expectedCount) {\n      callback();\n    }\n  }, 50);\n  /**\n   * Iterate over the root container and count all content types\n   *\n   * @param rootContainer\n   * @param count\n   */\n\n\n  function countContentTypes(rootContainer, count) {\n    count = count || 0;\n    rootContainer.getChildren()().forEach(function (child) {\n      ++count;\n\n      if (typeof child.getChildren !== \"undefined\" && child.getChildren()().length > 0) {\n        count = countContentTypes(child, count);\n      }\n    });\n    return count;\n  }\n  /**\n   * Perform a render of the provided data\n   *\n   * @param message\n   * @param renderId\n   */\n\n\n  function render(message, renderId) {\n    var styleRegistries = {};\n\n    _underscore.each(_config.getConfig(\"viewports\"), function (viewport, name) {\n      styleRegistries[name] = new _styleRegistry(name + renderId);\n    });\n\n    return new Promise(function (resolve, reject) {\n      createRenderTree(message.stageId, message.tree).then(function (rootContainer) {\n        var element = document.createElement(\"div\");\n        /**\n         * Setup an event on the element to observe changes and count the expected amount of content types are\n         * present within the content.\n         */\n\n        var renderFinished = _jquery.Deferred();\n\n        var observer = new MutationObserver(function () {\n          assertRenderFinished(element, countContentTypes(rootContainer), renderFinished.resolve);\n        });\n        observer.observe(element, {\n          attributes: true,\n          childList: true,\n          subtree: true\n        }); // Combine this event with our engine waitForRenderFinish to ensure rendering is completed\n\n        _jquery.when(_engine.waitForFinishRender(), renderFinished).then(function () {\n          observer.disconnect();\n\n          _knockout.cleanNode(element);\n\n          var styles = generateMasterCssForViewports(styleRegistries);\n\n          if (styles) {\n            (0, _jquery)(element).append((0, _jquery)(\"<style/>\").html(styles));\n          }\n\n          _underscore.each(styleRegistries, function (value, name) {\n            return (0, _styleRegistry.deleteStyleRegistry)(name + renderId);\n          });\n\n          var filtered = (0, _filterHtml)((0, _jquery)(element));\n          var output = (0, _directives.replaceWithSrc)((0, _directives)(filtered.html()));\n          resolve(output);\n        });\n\n        _knockout.applyBindingsToNode(element, {\n          template: {\n            data: rootContainer.content,\n            name: rootContainer.content.template\n          }\n        }, {\n          id: renderId\n        });\n      }).catch(function (error) {\n        reject(error);\n      });\n    });\n  }\n  /**\n   * Rebuild the content type tree using their original data and configuration\n   *\n   * @param stageId\n   * @param tree\n   * @param parent\n   */\n\n\n  function createRenderTree(stageId, tree, parent) {\n    if (parent === void 0) {\n      parent = null;\n    }\n\n    return new Promise(function (resolve, reject) {\n      (0, _contentTypeFactory)(_config.getContentTypeConfig(tree.name), parent, stageId, tree.data, parent !== null ? tree.children.length : 0, tree.viewportsData).then(function (contentType) {\n        // Ensure  we retain the original tree ID's\n        contentType.id = tree.id;\n\n        if (tree.children.length > 0) {\n          var childPromises = [];\n          tree.children.forEach(function (child) {\n            childPromises.push(createRenderTree(stageId, child, contentType));\n          });\n          Promise.all(childPromises).then(function (children) {\n            children.forEach(function (child) {\n              contentType.addChild(child);\n            });\n            resolve(contentType);\n          });\n        } else {\n          resolve(contentType);\n        }\n      }).catch(function (error) {\n        reject(error);\n      });\n    });\n  }\n  /**\n   * Generate the master format CSS\n   *\n   * @param registry\n   */\n\n\n  function generateMasterCss(registry) {\n    var scopes = Object.keys(registry.getAllStyles()).map(function (selector) {\n      return [selector];\n    });\n    return _csso.minify((0, _styleRegistry.generateCss)(registry.getAllStyles()), {\n      usage: {\n        scopes: scopes\n      }\n    }).css;\n  }\n\n  function generateMasterCssForViewports(registries) {\n    var result = \"\";\n\n    _underscore.each(registries, function (registry, name) {\n      var css = generateMasterCss(registry);\n\n      var media = _config.getConfig(\"viewports\")[name].media;\n\n      if (media && css) {\n        result += \"@media \" + media + \" { \" + css + \" }\";\n      } else {\n        result += css;\n      }\n    });\n\n    return result;\n  }\n\n  return Object.assign(listen, {\n    loadTemplate: loadTemplate\n  });\n});\n//# sourceMappingURL=frame.js.map","Magento_PageBuilder/js/master-format/render/serialize.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/content-type-collection\"], function (_config, _contentTypeCollection) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Serialize the tree as a simplified object for rendering\n   *\n   * @param contentType\n   */\n  function buildTree(contentType) {\n    var data = getData(contentType);\n    var viewportsData = getViewportsData(contentType);\n    var tree = {\n      name: contentType.config.name,\n      id: contentType.id,\n      data: data,\n      children: [],\n      viewportsData: viewportsData\n    };\n\n    if (contentType instanceof _contentTypeCollection && contentType.getChildren()().length > 0) {\n      contentType.getChildren()().forEach(function (child) {\n        tree.children.push(buildTree(child));\n      });\n    }\n\n    return tree;\n  }\n  /**\n   * Get a serialized version of the tree\n   *\n   * @param contentType\n   */\n\n\n  function getSerializedTree(contentType) {\n    return buildTree(contentType);\n  }\n  /**\n   * Retrieve the master data from the content types instance\n   *\n   * @param contentType\n   */\n\n\n  function getData(contentType) {\n    /**\n     * Flip flop to JSON and back again to ensure all data is serializable. Magento by default adds functions into\n     * some basic types which cannot be serialized when calling PostMessage.\n     */\n    return JSON.parse(JSON.stringify(contentType.dataStores[_config.getConfig(\"defaultViewport\")].getState())) || {};\n  }\n  /**\n   * Retrieve the master data from the content types instance\n   *\n   * @param contentType\n   */\n\n\n  function getViewportsData(contentType) {\n    /**\n     * Flip flop to JSON and back again to ensure all data is serializable. Magento by default adds functions into\n     * some basic types which cannot be serialized when calling PostMessage.\n     */\n    var result = {};\n    Object.keys(contentType.dataStores).forEach(function (name) {\n      result[name] = JSON.parse(JSON.stringify(contentType.dataStores[name].getState())) || {};\n    });\n    return result;\n  }\n\n  return {\n    buildTree: buildTree,\n    getSerializedTree: getSerializedTree\n  };\n});\n//# sourceMappingURL=serialize.js.map","Magento_PageBuilder/js/master-format/render/requirejs/text.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"mage/requirejs/text\", \"Magento_PageBuilder/js/master-format/render/frame\"], function (_text, _frame) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Within our render frame we override the RequireJS text! plugin, this is originally implemented within\n   * lib/web/mage/requirejs/text.js. The override uses the MessageChannel to communicate with the parent frame to\n   * retrieve any requested HTML knockout template. We do this due to the sandbox restrictions on the iframe disallow\n   * XHR requests to the same origin domain.\n   */\n\n  /**\n   * Load a template\n   *\n   * @param name\n   * @param req\n   * @param onLoad\n   */\n  function load(name, req, onLoad) {\n    (0, _frame.loadTemplate)(name).then(function (template) {\n      onLoad(template);\n    }).catch(function (error) {\n      onLoad.error(error);\n    });\n  }\n  /**\n   * Retrieve a template\n   *\n   * @param url\n   * @param callback\n   * @param fail\n   * @param headers\n   */\n\n\n  function get(url, callback, fail, headers) {\n    _text.get.apply(_text, arguments);\n  }\n\n  return {\n    load: load,\n    get: get\n  };\n});\n//# sourceMappingURL=text.js.map","Magento_PageBuilder/js/modal/confirm-alert.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget',\n    'Magento_Ui/js/modal/alert',\n    'jquery/z-index'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.confirmAlert', $.mage.alert, {\n        /**\n         * Fix issue with zIndex when removing the alert from the screen\n         * @private\n         */\n        _unsetActive: function () {\n            this._super();\n\n            if (this.overlay) {\n                this.overlay.zIndex('');\n            }\n        }\n    });\n\n    return function (config) {\n        return $('<div></div>').html(config.content).confirmAlert(config);\n    };\n});\n","Magento_PageBuilder/js/modal/dismissible-confirm.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Extend the confirmation prompt to allow for an additional checkbox to be displayed. The checkbox enables the user to\n * dismiss subsequent prompts of the same type based on their dismissKey.\n *\n * Once a type is dismissed a cookie is set and all future instances of that prompt are bypassed. This cookie is\n * cleared once the user logs out and back in via an observer.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'text!Magento_PageBuilder/template/modal/dismissible-modal-content.html',\n    'mage/translate',\n    'Magento_Ui/js/modal/prompt',\n    'mage/cookies'\n], function ($, _, promptContentTmpl, $t) {\n    'use strict';\n\n    /**\n     * Create buttons array for modal options\n     *\n     * @param {Boolean} haveCancelButton\n     * @return {Object}\n     */\n    function buttonsConfig(haveCancelButton) {\n        var cancelButton = {\n            text: $.mage.__('Cancel'),\n            class: 'action-secondary action-dismiss',\n\n            /**\n             * Click handler.\n             */\n            click: function () {\n                this.closeModal(false);\n            }\n        },\n            confirmButton = {\n            text: $.mage.__('OK'),\n            class: 'action-primary action-accept',\n\n            /**\n             * Click handler.\n             */\n            click: function () {\n                this.closeModal(true);\n            }\n        },\n            buttons = [];\n\n        if (haveCancelButton !== false) {\n            buttons.push(cancelButton);\n        }\n        buttons.push(confirmButton);\n\n        return buttons;\n    }\n\n    $.widget('mage.dismissibleConfirm', $.mage.prompt, {\n        options: {\n            promptContentTmpl: promptContentTmpl,\n            dismissible: false, // Can the modal be dismissed?\n            dismissKey: 'default', // The key we'll check to see if the modal has already been dismissed\n            dismissMessage: $t('Do not show this again'), // Message to display next to the dismiss checkbox\n            dismissCheckbox: '[name=\"modal-dnsa\"]' // Selector to retrieve dismiss checkbox\n        },\n\n        /**\n         * Open the modal window, if the modal has been dismissed, then run the confirm & always actions and don't\n         * don't open the modal\n         *\n         * @returns {*}\n         */\n        openModal: function () {\n            if ($.mage.cookies.get(this.options.dismissKey) === 'true') {\n                this.options.actions.confirm();\n\n                return this.options.actions.always(); // Always runs after confirm in confirm.js\n            }\n\n            return this._super();\n        },\n\n        /**\n         * Close modal window.\n         *\n         * @param {Boolean} result\n         */\n        closeModal: function (result) {\n            this._super(result);\n\n            if (result && this._isDismissed()) {\n                $.mage.cookies.set(this.options.dismissKey, 'true', {});\n            }\n        },\n\n        /**\n         * Is the dismissed checkbox checked?\n         *\n         * @private\n         */\n        _isDismissed: function () {\n            return this.modal.find(this.options.dismissCheckbox).is(':checked');\n        }\n    });\n\n    return function (config) {\n        config.buttons = buttonsConfig(config.haveCancelButton);\n        delete config.haveCancelButton;\n\n        return $('<div></div>').html(config.content).dismissibleConfirm(config);\n    };\n});\n","Magento_PageBuilder/js/modal/modal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/modal/modal-component',\n    'Magento_PageBuilder/js/events'\n], function (ModalComponent, events) {\n    'use strict';\n\n    return ModalComponent.extend({\n        defaults: {\n            titlePrefix: '${ $.options.title }',\n            modules: {\n                insertForm: '${ $.insertFormProvider }'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            events.on('form:renderAfter', function (params) {\n                this.openModal();\n                this.setTitle(this.titlePrefix + ' ' + params.title);\n                this.startListen(params.id);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Listen for from save.\n         *\n         * @param {String} id\n         */\n        startListen: function (id) {\n            events.on('form:' + id + ':saveAfter', function () {\n                this.closeModal();\n            }.bind(this));\n\n        },\n\n        /**\n         * Trigger modalClosed event on external provider\n         *\n         * @returns {any}\n         */\n        closeModal: function () {\n            this.insertForm() &&\n            this.insertForm().externalSource() &&\n            this.insertForm().externalSource().trigger('data.modalClosed');\n\n            return this._super();\n        }\n    });\n});\n","Magento_PageBuilder/js/modal/template-manager-modal.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal-component',\n    'Magento_PageBuilder/js/events',\n    'underscore',\n    'Magento_PageBuilder/js/stage-builder'\n], function ($, ModalComponent, events, _, stageBuilder) {\n    'use strict';\n\n    return ModalComponent.extend({\n        defaults: {\n            stage: null,\n            modules: {\n                messageContainer: '${ $.messageContainerProvider }',\n                listing: '${ $.listingProvider }'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            _.bindAll(this, 'closeModal');\n\n            events.on('stage:templateManager:open', function (params) {\n                this.openModal();\n                this.stage = params.stage;\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Apply selected template\n         *\n         * @param {String} template\n         */\n        applySelected: function (template) {\n            if (template) {\n                // Destroy the old content in the stage\n                this.stage.pageBuilder.destroy();\n                $('body').trigger('processStart');\n\n                stageBuilder(this.stage, template).then(function () {\n                    $('body').trigger('processStop');\n                    this.closeModal();\n                }.bind(this));\n            }\n        }\n    });\n});\n","Magento_PageBuilder/js/modal/template-manager-save.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/translate',\n    'Magento_Ui/js/modal/prompt'\n], function ($, _, $t) {\n    'use strict';\n\n    $.widget('mage.templateManagerSave', $.mage.prompt, {\n        options: {\n            createdForField: '[data-role=\"createdForField\"]',\n            previewImage: '[data-role=\"preview-image\"]',\n            previewImageSpinner: '[data-role=\"preview-image-spinner\"]',\n            saveButton: '[data-role=\"action\"].action-save',\n            form: 'form',\n            buttons: [{\n                text: $.mage.__('Cancel'),\n                class: 'action-secondary action-dismiss',\n\n                /**\n                 * Click handler.\n                 */\n                click: function () {\n                    this.closeModal();\n                }\n            }, {\n                text: $.mage.__('Save'),\n                class: 'action-primary action-save',\n\n                /**\n                 * Click handler.\n                 */\n                click: function () {\n                    this.submit();\n                }\n            }]\n        },\n\n        /**\n         * Create widget\n         *\n         * @private\n         */\n        _create: function () {\n            this._super();\n\n            this.modal.find(this.options.saveButton).prop('disabled', 'disabled');\n            // Ensure if the form is submitted through hitting enter we handle it correctly\n            this.modal.find(this.options.form).on('submit', function (event) {\n                event.preventDefault();\n                this.submit();\n            }.bind(this));\n        },\n\n        /**\n         * Validate prompt contains a template name\n         *\n         * @returns {Boolean}\n         */\n        validate: function () {\n            return this.modal.find(this.options.promptField) &&\n                !_.isEmpty(this.modal.find(this.options.promptField).val());\n        },\n\n        /**\n         * Save the values within the prompt\n         */\n        submit: function () {\n            var name,\n                createdFor;\n\n            if (this.options.validation && !this.validate()) {\n                return false;\n            }\n\n            $('body').trigger('processStart');\n\n            name = this.modal.find(this.options.promptField).val();\n            createdFor = this.modal.find(this.options.createdForField).val();\n\n            this.options.actions.confirm.call(this, name, createdFor).then(function () {\n                this.closeModal(true);\n                $('body').trigger('processStop');\n            }.bind(this)).catch(function () {\n                $('body').trigger('processStop');\n            });\n        },\n\n        /**\n         * Set the preview image\n         *\n         * @param {String} image\n         */\n        setPreviewImage: function (image) {\n            var previewImage = this.modal.find(this.options.previewImage),\n                previewImageSpinner = this.modal.find(this.options.previewImageSpinner);\n\n            // Update the preview image within the modal\n            previewImageSpinner.hide();\n            previewImage.append(\n                $('<img />').prop('src', image).prop('alt', $t('Template Preview'))\n            ).show();\n\n            // Enable the button so the user can save\n            this.modal.find(this.options.saveButton).prop('disabled', false);\n        },\n\n        /**\n         * Close modal window\n         */\n        closeModal: function (saved) {\n            if (!saved) {\n                this.options.actions.cancel.call(this, saved);\n            }\n\n            this.options.actions.always();\n            this.element.on('promptclosed', _.bind(this._remove, this));\n\n            return this._super();\n        }\n    });\n\n    return function (config) {\n        return $('<div class=\"prompt-message\"></div>').html(config.content).templateManagerSave(config);\n    };\n});\n","Magento_PageBuilder/js/panel/menu.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\"], function (_knockout) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var Menu = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * Menu constructor\n     *\n     * @param id\n     * @param menu\n     * @param contentTypes\n     * @param stageId\n     */\n    function Menu(id, menu, contentTypes, stageId) {\n      if (contentTypes === void 0) {\n        contentTypes = [];\n      }\n\n      this.hidden = _knockout.observable(false);\n      this.id = _knockout.observable();\n      this.code = _knockout.observable(\"\");\n      this.label = _knockout.observable(\"\");\n      this.icon = _knockout.observable(\"\");\n      this.sort = _knockout.observable();\n      this.contentTypes = _knockout.observableArray([]);\n      this.active = _knockout.observable(false);\n      this.id(id);\n      this.code(menu.code);\n      this.label(menu.label);\n      this.icon(menu.icon);\n      this.sort(menu.sort);\n      this.contentTypes(contentTypes);\n      this.stageId = stageId;\n    }\n    /**\n     * Toggle the menu\n     */\n\n\n    var _proto = Menu.prototype;\n\n    _proto.toggle = function toggle() {\n      this.active(!this.active());\n    };\n\n    return Menu;\n  }();\n\n  return {\n    Menu: Menu\n  };\n});\n//# sourceMappingURL=menu.js.map","Magento_PageBuilder/js/panel/menu/content-type.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"knockout\", \"Magento_PageBuilder/js/drag-drop/matrix\"], function (_knockout, _matrix) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var ContentType = /*#__PURE__*/function () {\n    \"use strict\";\n\n    /**\n     * @param {string} identifier\n     * @param {ContentTypeConfigInterface} config\n     * @param {string} stageId\n     */\n    function ContentType(identifier, config, stageId) {\n      this.droppable = true;\n      this.icon = _knockout.observable(\"\");\n      this.identifier = _knockout.observable(\"\");\n      this.label = _knockout.observable(\"\");\n      this.config = config;\n      this.identifier(identifier);\n      this.label(config.label);\n      this.icon(config.icon);\n      this.stageId = stageId;\n    }\n    /**\n     * Retrieve the config object\n     *\n     * @returns {ContentTypeConfigInterface}\n     */\n\n\n    var _proto = ContentType.prototype;\n\n    _proto.getConfig = function getConfig() {\n      return this.config;\n    }\n    /**\n     * Only connect to container sortable instances that the current content type is accepted into\n     *\n     * @returns {string}\n     */\n    ;\n\n    _proto.getDraggableOptions = function getDraggableOptions() {\n      return {\n        connectToSortable: (0, _matrix.getAllowedContainersClasses)(this.config.name, this.stageId)\n      };\n    };\n\n    return ContentType;\n  }();\n\n  return {\n    ContentType: ContentType\n  };\n});\n//# sourceMappingURL=content-type.js.map","Magento_PageBuilder/js/property/attribute-reader.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var AttributeReader = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function AttributeReader() {}\n\n    var _proto = AttributeReader.prototype;\n\n    /**\n     * Read attribute from element\n     *\n     * @param {HTMLElement} element\n     * @param {string} source\n     * @returns {string | object}\n     */\n    _proto.read = function read(element, source) {\n      return element.getAttribute(source);\n    };\n\n    return AttributeReader;\n  }();\n\n  return AttributeReader;\n});\n//# sourceMappingURL=attribute-reader.js.map","Magento_PageBuilder/js/property/link.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Link = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Link() {\n      this.regexpByLinkType = {\n        category: new RegExp(/id_path=['\"]category\\/(\\d+)/),\n        product: new RegExp(/id_path=['\"]product\\/(\\d+)/),\n        page: new RegExp(/page_id=['\"](\\d+)/)\n      };\n    }\n\n    var _proto = Link.prototype;\n\n    /**\n     * Read link from element\n     *\n     * @param {HTMLElement} element\n     * @returns {string | object}\n     */\n    _proto.read = function read(element) {\n      var _ref;\n\n      var href = element.getAttribute(\"href\");\n      var attributeLinkType = element.getAttribute(\"data-link-type\");\n\n      if (typeof href === \"string\" && attributeLinkType !== \"default\") {\n        href = this.getIdFromWidgetSyntax(href, this.regexpByLinkType[attributeLinkType]);\n      }\n\n      return _ref = {}, _ref[attributeLinkType] = href, _ref.setting = element.getAttribute(\"target\") === \"_blank\", _ref.type = attributeLinkType, _ref;\n    }\n    /**\n     * Returns link value from widget string\n     *\n     * @param {string} href\n     * @param {RegExp} regexp\n     * @return {string}\n     */\n    ;\n\n    _proto.getIdFromWidgetSyntax = function getIdFromWidgetSyntax(href, regexp) {\n      var attributeIdMatches = href.match(regexp);\n\n      if (!attributeIdMatches) {\n        return href;\n      }\n\n      return attributeIdMatches[1];\n    };\n\n    return Link;\n  }();\n\n  return Link;\n});\n//# sourceMappingURL=link.js.map","Magento_PageBuilder/js/property/margins.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Margins = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Margins() {}\n\n    var _proto = Margins.prototype;\n\n    /**\n     * Read margins from element\n     *\n     * @param {HTMLElement} element\n     * @returns {string | object}\n     */\n    _proto.read = function read(element) {\n      return {\n        margin: {\n          left: element.style.marginLeft,\n          top: element.style.marginTop,\n          right: element.style.marginRight,\n          bottom: element.style.marginBottom\n        }\n      };\n    };\n\n    return Margins;\n  }();\n\n  return Margins;\n});\n//# sourceMappingURL=margins.js.map","Magento_PageBuilder/js/property/paddings.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var Paddings = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function Paddings() {}\n\n    var _proto = Paddings.prototype;\n\n    /**\n     * Read paddings from element\n     *\n     * @param {HTMLElement} element\n     * @returns {string | object}\n     */\n    _proto.read = function read(element) {\n      return {\n        padding: {\n          left: element.style.paddingLeft,\n          top: element.style.paddingTop,\n          right: element.style.paddingRight,\n          bottom: element.style.paddingBottom\n        }\n      };\n    };\n\n    return Paddings;\n  }();\n\n  return Paddings;\n});\n//# sourceMappingURL=paddings.js.map","Magento_PageBuilder/js/property/property-reader-interface.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  \"use strict\";\n});\n//# sourceMappingURL=property-reader-interface.js.map","Magento_PageBuilder/js/property/property-reader-pool-factory.js":"/*eslint-disable */\n/* jscs:disable */\n\nfunction _createForOfIteratorHelperLoose(o, allowArrayLike) { var it = typeof Symbol !== \"undefined\" && o[Symbol.iterator] || o[\"@@iterator\"]; if (it) return (it = it.call(o)).next.bind(it); if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === \"number\") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError(\"Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.\"); }\n\nfunction _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === \"string\") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === \"Object\" && o.constructor) n = o.constructor.name; if (n === \"Map\" || n === \"Set\") return Array.from(o); if (n === \"Arguments\" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }\n\nfunction _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }\n\ndefine([\"Magento_PageBuilder/js/config\", \"Magento_PageBuilder/js/utils/loader\", \"Magento_PageBuilder/js/property/property-reader-pool\"], function (_config, _loader, _propertyReaderPool) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * Create a new instance of property reader pool\n   */\n  function create(contentType) {\n    var config = _config.getContentTypeConfig(contentType);\n\n    var propertyReaders = [];\n    var appearanceName;\n\n    for (var _i = 0, _Object$keys = Object.keys(config.appearances); _i < _Object$keys.length; _i++) {\n      appearanceName = _Object$keys[_i];\n      var appearance = config.appearances[appearanceName];\n\n      if (appearance !== undefined && appearance.elements !== undefined) {\n        var elementName = void 0;\n\n        for (var _i2 = 0, _Object$keys2 = Object.keys(appearance.elements); _i2 < _Object$keys2.length; _i2++) {\n          elementName = _Object$keys2[_i2];\n          var element = appearance.elements[elementName];\n\n          if (element.style !== undefined) {\n            for (var _iterator = _createForOfIteratorHelperLoose(element.style), _step; !(_step = _iterator()).done;) {\n              var propertyConfig = _step.value;\n\n              if (propertyConfig.reader && propertyReaders.indexOf(propertyConfig.reader) === -1 && !_propertyReaderPool.get(propertyConfig.reader)) {\n                propertyReaders.push(propertyConfig.reader);\n              }\n            }\n          }\n\n          if (element.attributes !== undefined) {\n            for (var _iterator2 = _createForOfIteratorHelperLoose(element.attributes), _step2; !(_step2 = _iterator2()).done;) {\n              var attributeConfig = _step2.value;\n\n              if (attributeConfig.reader && propertyReaders.indexOf(attributeConfig.reader) === -1 && !_propertyReaderPool.get(attributeConfig.reader)) {\n                propertyReaders.push(attributeConfig.reader);\n              }\n            }\n          }\n        }\n      }\n    }\n\n    return new Promise(function (resolve) {\n      (0, _loader)(propertyReaders, function () {\n        for (var _len = arguments.length, loadedPropertyReaders = new Array(_len), _key = 0; _key < _len; _key++) {\n          loadedPropertyReaders[_key] = arguments[_key];\n        }\n\n        for (var i = 0; i < propertyReaders.length; i++) {\n          _propertyReaderPool.register(propertyReaders[i], new loadedPropertyReaders[i]());\n        }\n\n        resolve(_propertyReaderPool);\n      });\n    });\n  }\n\n  return create;\n});\n//# sourceMappingURL=property-reader-pool-factory.js.map","Magento_PageBuilder/js/property/property-reader-pool.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([], function () {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n  var PropertyReaderPool = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function PropertyReaderPool() {\n      this.propertyReaders = {};\n    }\n\n    var _proto = PropertyReaderPool.prototype;\n\n    /**\n     * Retrieve a property reader from the pool\n     *\n     * @param {string} name\n     * @returns {PropertyReaderInterface}\n     */\n    _proto.get = function get(name) {\n      return this.propertyReaders[name] !== undefined ? this.propertyReaders[name] : null;\n    }\n    /**\n     * Register a new property reader into the pool\n     *\n     * @param {string} name\n     * @param {PropertyReaderInterface} property\n     */\n    ;\n\n    _proto.register = function register(name, property) {\n      this.propertyReaders[name] = property;\n    };\n\n    return PropertyReaderPool;\n  }();\n\n  var _default = new PropertyReaderPool();\n\n  return Object.assign(_default, {\n    PropertyReaderPool: PropertyReaderPool\n  });\n});\n//# sourceMappingURL=property-reader-pool.js.map","Magento_PageBuilder/js/property/style-property-reader.js":"/*eslint-disable */\n/* jscs:disable */\ndefine([\"Magento_PageBuilder/js/utils/string\"], function (_string) {\n  /**\n   * Copyright \u00a9 Magento, Inc. All rights reserved.\n   * See COPYING.txt for license details.\n   */\n\n  /**\n   * @api\n   */\n  var StylePropertyReader = /*#__PURE__*/function () {\n    \"use strict\";\n\n    function StylePropertyReader() {}\n\n    var _proto = StylePropertyReader.prototype;\n\n    /**\n     * Read style property from element\n     *\n     * @param {HTMLElement} element\n     * @param {string} source\n     * @returns {string | object}\n     */\n    _proto.read = function read(element, source) {\n      var camelCasedSource = (0, _string.fromSnakeToCamelCase)(source);\n      return element.style[camelCasedSource];\n    };\n\n    return StylePropertyReader;\n  }();\n\n  return StylePropertyReader;\n});\n//# sourceMappingURL=style-property-reader.js.map","Magento_PageBuilder/js/resource/object-path.js":"(function (root, factory){\n    'use strict';\n\n    /*istanbul ignore next:cant test*/\n    if (typeof module === 'object' && typeof module.exports === 'object') {\n        module.exports = factory();\n    } else if (typeof define === 'function' && define.amd) {\n        // AMD. Register as an anonymous module.\n        define([], factory);\n    } else {\n        // Browser globals\n        root.objectPath = factory();\n    }\n})(this, function(){\n    'use strict';\n\n    var toStr = Object.prototype.toString;\n    function hasOwnProperty(obj, prop) {\n        if(obj == null) {\n            return false\n        }\n        //to handle objects with null prototypes (too edge case?)\n        return Object.prototype.hasOwnProperty.call(obj, prop)\n    }\n\n    function isEmpty(value){\n        if (!value) {\n            return true;\n        }\n        if (isArray(value) && value.length === 0) {\n            return true;\n        } else if (typeof value !== 'string') {\n            for (var i in value) {\n                if (hasOwnProperty(value, i)) {\n                    return false;\n                }\n            }\n            return true;\n        }\n        return false;\n    }\n\n    function toString(type){\n        return toStr.call(type);\n    }\n\n    function isObject(obj){\n        return typeof obj === 'object' && toString(obj) === \"[object Object]\";\n    }\n\n    var isArray = Array.isArray || function(obj){\n        /*istanbul ignore next:cant test*/\n        return toStr.call(obj) === '[object Array]';\n    }\n\n    function isBoolean(obj){\n        return typeof obj === 'boolean' || toString(obj) === '[object Boolean]';\n    }\n\n    function getKey(key){\n        var intKey = parseInt(key);\n        if (intKey.toString() === key) {\n            return intKey;\n        }\n        return key;\n    }\n\n    function factory(options) {\n        options = options || {}\n\n        var objectPath = function(obj) {\n            return Object.keys(objectPath).reduce(function(proxy, prop) {\n                if(prop === 'create') {\n                    return proxy;\n                }\n\n                /*istanbul ignore else*/\n                if (typeof objectPath[prop] === 'function') {\n                    proxy[prop] = objectPath[prop].bind(objectPath, obj);\n                }\n\n                return proxy;\n            }, {});\n        };\n\n        var hasShallowProperty\n        if (options.includeInheritedProps) {\n            hasShallowProperty = function () {\n                return true\n            }\n        } else {\n            hasShallowProperty = function (obj, prop) {\n                return (typeof prop === 'number' && Array.isArray(obj)) || hasOwnProperty(obj, prop)\n            }\n        }\n\n        function getShallowProperty(obj, prop) {\n            if (hasShallowProperty(obj, prop)) {\n                return obj[prop];\n            }\n        }\n\n        function set(obj, path, value, doNotReplace){\n            if (typeof path === 'number') {\n                path = [path];\n            }\n            if (!path || path.length === 0) {\n                return obj;\n            }\n            if (typeof path === 'string') {\n                return set(obj, path.split('.').map(getKey), value, doNotReplace);\n            }\n            var currentPath = path[0];\n            var currentValue = getShallowProperty(obj, currentPath);\n            if (options.includeInheritedProps && (currentPath === '__proto__' ||\n                (currentPath === 'constructor' && typeof currentValue === 'function'))) {\n                throw new Error('For security reasons, object\\'s magic properties cannot be set')\n            }\n            if (path.length === 1) {\n                if (currentValue === void 0 || !doNotReplace) {\n                    obj[currentPath] = value;\n                }\n                return currentValue;\n            }\n\n            if (currentValue === void 0) {\n                //check if we assume an array\n                if(typeof path[1] === 'number') {\n                    obj[currentPath] = [];\n                } else {\n                    obj[currentPath] = {};\n                }\n            }\n\n            return set(obj[currentPath], path.slice(1), value, doNotReplace);\n        }\n\n        objectPath.has = function (obj, path) {\n            if (typeof path === 'number') {\n                path = [path];\n            } else if (typeof path === 'string') {\n                path = path.split('.');\n            }\n\n            if (!path || path.length === 0) {\n                return !!obj;\n            }\n\n            for (var i = 0; i < path.length; i++) {\n                var j = getKey(path[i]);\n\n                if((typeof j === 'number' && isArray(obj) && j < obj.length) ||\n                    (options.includeInheritedProps ? (j in Object(obj)) : hasOwnProperty(obj, j))) {\n                    obj = obj[j];\n                } else {\n                    return false;\n                }\n            }\n\n            return true;\n        };\n\n        objectPath.ensureExists = function (obj, path, value){\n            return set(obj, path, value, true);\n        };\n\n        objectPath.set = function (obj, path, value, doNotReplace){\n            return set(obj, path, value, doNotReplace);\n        };\n\n        objectPath.insert = function (obj, path, value, at){\n            var arr = objectPath.get(obj, path);\n            at = ~~at;\n            if (!isArray(arr)) {\n                arr = [];\n                objectPath.set(obj, path, arr);\n            }\n            arr.splice(at, 0, value);\n        };\n\n        objectPath.empty = function(obj, path) {\n            if (isEmpty(path)) {\n                return void 0;\n            }\n            if (obj == null) {\n                return void 0;\n            }\n\n            var value, i;\n            if (!(value = objectPath.get(obj, path))) {\n                return void 0;\n            }\n\n            if (typeof value === 'string') {\n                return objectPath.set(obj, path, '');\n            } else if (isBoolean(value)) {\n                return objectPath.set(obj, path, false);\n            } else if (typeof value === 'number') {\n                return objectPath.set(obj, path, 0);\n            } else if (isArray(value)) {\n                value.length = 0;\n            } else if (isObject(value)) {\n                for (i in value) {\n                    if (hasShallowProperty(value, i)) {\n                        delete value[i];\n                    }\n                }\n            } else {\n                return objectPath.set(obj, path, null);\n            }\n        };\n\n        objectPath.push = function (obj, path /*, values */){\n            var arr = objectPath.get(obj, path);\n            if (!isArray(arr)) {\n                arr = [];\n                objectPath.set(obj, path, arr);\n            }\n\n            arr.push.apply(arr, Array.prototype.slice.call(arguments, 2));\n        };\n\n        objectPath.coalesce = function (obj, paths, defaultValue) {\n            var value;\n\n            for (var i = 0, len = paths.length; i < len; i++) {\n                if ((value = objectPath.get(obj, paths[i])) !== void 0) {\n                    return value;\n                }\n            }\n\n            return defaultValue;\n        };\n\n        objectPath.get = function (obj, path, defaultValue){\n            if (typeof path === 'number') {\n                path = [path];\n            }\n            if (!path || path.length === 0) {\n                return obj;\n            }\n            if (obj == null) {\n                return defaultValue;\n            }\n            if (typeof path === 'string') {\n                return objectPath.get(obj, path.split('.'), defaultValue);\n            }\n\n            var currentPath = getKey(path[0]);\n            var nextObj = getShallowProperty(obj, currentPath)\n            if (nextObj === void 0) {\n                return defaultValue;\n            }\n\n            if (path.length === 1) {\n                return nextObj;\n            }\n\n            return objectPath.get(obj[currentPath], path.slice(1), defaultValue);\n        };\n\n        objectPath.del = function del(obj, path) {\n            if (typeof path === 'number') {\n                path = [path];\n            }\n\n            if (obj == null) {\n                return obj;\n            }\n\n            if (isEmpty(path)) {\n                return obj;\n            }\n            if(typeof path === 'string') {\n                return objectPath.del(obj, path.split('.'));\n            }\n\n            var currentPath = getKey(path[0]);\n            if (!hasShallowProperty(obj, currentPath)) {\n                return obj;\n            }\n\n            if(path.length === 1) {\n                if (isArray(obj)) {\n                    obj.splice(currentPath, 1);\n                } else {\n                    delete obj[currentPath];\n                }\n            } else {\n                return objectPath.del(obj[currentPath], path.slice(1));\n            }\n\n            return obj;\n        }\n\n        return objectPath;\n    }\n\n    var mod = factory();\n    mod.create = factory;\n    mod.withInheritedProps = factory({includeInheritedProps: true})\n    return mod;\n});","Magento_PageBuilder/js/resource/babel/polyfill.js":"(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require==\"function\"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error(\"Cannot find module '\"+o+\"'\");throw f.code=\"MODULE_NOT_FOUND\",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require==\"function\"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(_dereq_,module,exports){\n        (function (global){\n            \"use strict\";\n\n            _dereq_(327);\n\n            _dereq_(328);\n\n            _dereq_(2);\n\n            if (global._babelPolyfill) {\n                throw new Error(\"only one instance of babel-polyfill is allowed\");\n            }\n            global._babelPolyfill = true;\n\n            var DEFINE_PROPERTY = \"defineProperty\";\n            function define(O, key, value) {\n                O[key] || Object[DEFINE_PROPERTY](O, key, {\n                    writable: true,\n                    configurable: true,\n                    value: value\n                });\n            }\n\n            define(String.prototype, \"padLeft\", \"\".padStart);\n            define(String.prototype, \"padRight\", \"\".padEnd);\n\n            \"pop,reverse,shift,keys,values,entries,indexOf,every,some,forEach,map,filter,find,findIndex,includes,join,slice,concat,push,splice,unshift,sort,lastIndexOf,reduce,reduceRight,copyWithin,fill\".split(\",\").forEach(function (key) {\n                [][key] && define(Array, key, Function.call.bind([][key]));\n            });\n        }).call(this,typeof global !== \"undefined\" ? global : typeof self !== \"undefined\" ? self : typeof window !== \"undefined\" ? window : {})\n    },{\"2\":2,\"327\":327,\"328\":328}],2:[function(_dereq_,module,exports){\n        _dereq_(130);\n        module.exports = _dereq_(23).RegExp.escape;\n\n    },{\"130\":130,\"23\":23}],3:[function(_dereq_,module,exports){\n        module.exports = function (it) {\n            if (typeof it != 'function') throw TypeError(it + ' is not a function!');\n            return it;\n        };\n\n    },{}],4:[function(_dereq_,module,exports){\n        var cof = _dereq_(18);\n        module.exports = function (it, msg) {\n            if (typeof it != 'number' && cof(it) != 'Number') throw TypeError(msg);\n            return +it;\n        };\n\n    },{\"18\":18}],5:[function(_dereq_,module,exports){\n// 22.1.3.31 Array.prototype[@@unscopables]\n        var UNSCOPABLES = _dereq_(128)('unscopables');\n        var ArrayProto = Array.prototype;\n        if (ArrayProto[UNSCOPABLES] == undefined) _dereq_(42)(ArrayProto, UNSCOPABLES, {});\n        module.exports = function (key) {\n            ArrayProto[UNSCOPABLES][key] = true;\n        };\n\n    },{\"128\":128,\"42\":42}],6:[function(_dereq_,module,exports){\n        module.exports = function (it, Constructor, name, forbiddenField) {\n            if (!(it instanceof Constructor) || (forbiddenField !== undefined && forbiddenField in it)) {\n                throw TypeError(name + ': incorrect invocation!');\n            } return it;\n        };\n\n    },{}],7:[function(_dereq_,module,exports){\n        var isObject = _dereq_(51);\n        module.exports = function (it) {\n            if (!isObject(it)) throw TypeError(it + ' is not an object!');\n            return it;\n        };\n\n    },{\"51\":51}],8:[function(_dereq_,module,exports){\n// 22.1.3.3 Array.prototype.copyWithin(target, start, end = this.length)\n        'use strict';\n        var toObject = _dereq_(119);\n        var toAbsoluteIndex = _dereq_(114);\n        var toLength = _dereq_(118);\n\n        module.exports = [].copyWithin || function copyWithin(target /* = 0 */, start /* = 0, end = @length */) {\n            var O = toObject(this);\n            var len = toLength(O.length);\n            var to = toAbsoluteIndex(target, len);\n            var from = toAbsoluteIndex(start, len);\n            var end = arguments.length > 2 ? arguments[2] : undefined;\n            var count = Math.min((end === undefined ? len : toAbsoluteIndex(end, len)) - from, len - to);\n            var inc = 1;\n            if (from < to && to < from + count) {\n                inc = -1;\n                from += count - 1;\n                to += count - 1;\n            }\n            while (count-- > 0) {\n                if (from in O) O[to] = O[from];\n                else delete O[to];\n                to += inc;\n                from += inc;\n            } return O;\n        };\n\n    },{\"114\":114,\"118\":118,\"119\":119}],9:[function(_dereq_,module,exports){\n// 22.1.3.6 Array.prototype.fill(value, start = 0, end = this.length)\n        'use strict';\n        var toObject = _dereq_(119);\n        var toAbsoluteIndex = _dereq_(114);\n        var toLength = _dereq_(118);\n        module.exports = function fill(value /* , start = 0, end = @length */) {\n            var O = toObject(this);\n            var length = toLength(O.length);\n            var aLen = arguments.length;\n            var index = toAbsoluteIndex(aLen > 1 ? arguments[1] : undefined, length);\n            var end = aLen > 2 ? arguments[2] : undefined;\n            var endPos = end === undefined ? length : toAbsoluteIndex(end, length);\n            while (endPos > index) O[index++] = value;\n            return O;\n        };\n\n    },{\"114\":114,\"118\":118,\"119\":119}],10:[function(_dereq_,module,exports){\n        var forOf = _dereq_(39);\n\n        module.exports = function (iter, ITERATOR) {\n            var result = [];\n            forOf(iter, false, result.push, result, ITERATOR);\n            return result;\n        };\n\n    },{\"39\":39}],11:[function(_dereq_,module,exports){\n// false -> Array#indexOf\n// true  -> Array#includes\n        var toIObject = _dereq_(117);\n        var toLength = _dereq_(118);\n        var toAbsoluteIndex = _dereq_(114);\n        module.exports = function (IS_INCLUDES) {\n            return function ($this, el, fromIndex) {\n                var O = toIObject($this);\n                var length = toLength(O.length);\n                var index = toAbsoluteIndex(fromIndex, length);\n                var value;\n                // Array#includes uses SameValueZero equality algorithm\n                // eslint-disable-next-line no-self-compare\n                if (IS_INCLUDES && el != el) while (length > index) {\n                    value = O[index++];\n                    // eslint-disable-next-line no-self-compare\n                    if (value != value) return true;\n                    // Array#indexOf ignores holes, Array#includes - not\n                } else for (;length > index; index++) if (IS_INCLUDES || index in O) {\n                    if (O[index] === el) return IS_INCLUDES || index || 0;\n                } return !IS_INCLUDES && -1;\n            };\n        };\n\n    },{\"114\":114,\"117\":117,\"118\":118}],12:[function(_dereq_,module,exports){\n// 0 -> Array#forEach\n// 1 -> Array#map\n// 2 -> Array#filter\n// 3 -> Array#some\n// 4 -> Array#every\n// 5 -> Array#find\n// 6 -> Array#findIndex\n        var ctx = _dereq_(25);\n        var IObject = _dereq_(47);\n        var toObject = _dereq_(119);\n        var toLength = _dereq_(118);\n        var asc = _dereq_(15);\n        module.exports = function (TYPE, $create) {\n            var IS_MAP = TYPE == 1;\n            var IS_FILTER = TYPE == 2;\n            var IS_SOME = TYPE == 3;\n            var IS_EVERY = TYPE == 4;\n            var IS_FIND_INDEX = TYPE == 6;\n            var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;\n            var create = $create || asc;\n            return function ($this, callbackfn, that) {\n                var O = toObject($this);\n                var self = IObject(O);\n                var f = ctx(callbackfn, that, 3);\n                var length = toLength(self.length);\n                var index = 0;\n                var result = IS_MAP ? create($this, length) : IS_FILTER ? create($this, 0) : undefined;\n                var val, res;\n                for (;length > index; index++) if (NO_HOLES || index in self) {\n                    val = self[index];\n                    res = f(val, index, O);\n                    if (TYPE) {\n                        if (IS_MAP) result[index] = res;   // map\n                        else if (res) switch (TYPE) {\n                            case 3: return true;             // some\n                            case 5: return val;              // find\n                            case 6: return index;            // findIndex\n                            case 2: result.push(val);        // filter\n                        } else if (IS_EVERY) return false; // every\n                    }\n                }\n                return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : result;\n            };\n        };\n\n    },{\"118\":118,\"119\":119,\"15\":15,\"25\":25,\"47\":47}],13:[function(_dereq_,module,exports){\n        var aFunction = _dereq_(3);\n        var toObject = _dereq_(119);\n        var IObject = _dereq_(47);\n        var toLength = _dereq_(118);\n\n        module.exports = function (that, callbackfn, aLen, memo, isRight) {\n            aFunction(callbackfn);\n            var O = toObject(that);\n            var self = IObject(O);\n            var length = toLength(O.length);\n            var index = isRight ? length - 1 : 0;\n            var i = isRight ? -1 : 1;\n            if (aLen < 2) for (;;) {\n                if (index in self) {\n                    memo = self[index];\n                    index += i;\n                    break;\n                }\n                index += i;\n                if (isRight ? index < 0 : length <= index) {\n                    throw TypeError('Reduce of empty array with no initial value');\n                }\n            }\n            for (;isRight ? index >= 0 : length > index; index += i) if (index in self) {\n                memo = callbackfn(memo, self[index], index, O);\n            }\n            return memo;\n        };\n\n    },{\"118\":118,\"119\":119,\"3\":3,\"47\":47}],14:[function(_dereq_,module,exports){\n        var isObject = _dereq_(51);\n        var isArray = _dereq_(49);\n        var SPECIES = _dereq_(128)('species');\n\n        module.exports = function (original) {\n            var C;\n            if (isArray(original)) {\n                C = original.constructor;\n                // cross-realm fallback\n                if (typeof C == 'function' && (C === Array || isArray(C.prototype))) C = undefined;\n                if (isObject(C)) {\n                    C = C[SPECIES];\n                    if (C === null) C = undefined;\n                }\n            } return C === undefined ? Array : C;\n        };\n\n    },{\"128\":128,\"49\":49,\"51\":51}],15:[function(_dereq_,module,exports){\n// 9.4.2.3 ArraySpeciesCreate(originalArray, length)\n        var speciesConstructor = _dereq_(14);\n\n        module.exports = function (original, length) {\n            return new (speciesConstructor(original))(length);\n        };\n\n    },{\"14\":14}],16:[function(_dereq_,module,exports){\n        'use strict';\n        var aFunction = _dereq_(3);\n        var isObject = _dereq_(51);\n        var invoke = _dereq_(46);\n        var arraySlice = [].slice;\n        var factories = {};\n\n        var construct = function (F, len, args) {\n            if (!(len in factories)) {\n                for (var n = [], i = 0; i < len; i++) n[i] = 'a[' + i + ']';\n                // eslint-disable-next-line no-new-func\n                factories[len] = Function('F,a', 'return new F(' + n.join(',') + ')');\n            } return factories[len](F, args);\n        };\n\n        module.exports = Function.bind || function bind(that /* , ...args */) {\n            var fn = aFunction(this);\n            var partArgs = arraySlice.call(arguments, 1);\n            var bound = function (/* args... */) {\n                var args = partArgs.concat(arraySlice.call(arguments));\n                return this instanceof bound ? construct(fn, args.length, args) : invoke(fn, args, that);\n            };\n            if (isObject(fn.prototype)) bound.prototype = fn.prototype;\n            return bound;\n        };\n\n    },{\"3\":3,\"46\":46,\"51\":51}],17:[function(_dereq_,module,exports){\n// getting tag from 19.1.3.6 Object.prototype.toString()\n        var cof = _dereq_(18);\n        var TAG = _dereq_(128)('toStringTag');\n// ES3 wrong here\n        var ARG = cof(function () { return arguments; }()) == 'Arguments';\n\n// fallback for IE11 Script Access Denied error\n        var tryGet = function (it, key) {\n            try {\n                return it[key];\n            } catch (e) { /* empty */ }\n        };\n\n        module.exports = function (it) {\n            var O, T, B;\n            return it === undefined ? 'Undefined' : it === null ? 'Null'\n                // @@toStringTag case\n                : typeof (T = tryGet(O = Object(it), TAG)) == 'string' ? T\n                    // builtinTag case\n                    : ARG ? cof(O)\n                        // ES3 arguments fallback\n                        : (B = cof(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : B;\n        };\n\n    },{\"128\":128,\"18\":18}],18:[function(_dereq_,module,exports){\n        var toString = {}.toString;\n\n        module.exports = function (it) {\n            return toString.call(it).slice(8, -1);\n        };\n\n    },{}],19:[function(_dereq_,module,exports){\n        'use strict';\n        var dP = _dereq_(72).f;\n        var create = _dereq_(71);\n        var redefineAll = _dereq_(93);\n        var ctx = _dereq_(25);\n        var anInstance = _dereq_(6);\n        var forOf = _dereq_(39);\n        var $iterDefine = _dereq_(55);\n        var step = _dereq_(57);\n        var setSpecies = _dereq_(100);\n        var DESCRIPTORS = _dereq_(29);\n        var fastKey = _dereq_(66).fastKey;\n        var validate = _dereq_(125);\n        var SIZE = DESCRIPTORS ? '_s' : 'size';\n\n        var getEntry = function (that, key) {\n            // fast case\n            var index = fastKey(key);\n            var entry;\n            if (index !== 'F') return that._i[index];\n            // frozen object case\n            for (entry = that._f; entry; entry = entry.n) {\n                if (entry.k == key) return entry;\n            }\n        };\n\n        module.exports = {\n            getConstructor: function (wrapper, NAME, IS_MAP, ADDER) {\n                var C = wrapper(function (that, iterable) {\n                    anInstance(that, C, NAME, '_i');\n                    that._t = NAME;         // collection type\n                    that._i = create(null); // index\n                    that._f = undefined;    // first entry\n                    that._l = undefined;    // last entry\n                    that[SIZE] = 0;         // size\n                    if (iterable != undefined) forOf(iterable, IS_MAP, that[ADDER], that);\n                });\n                redefineAll(C.prototype, {\n                    // 23.1.3.1 Map.prototype.clear()\n                    // 23.2.3.2 Set.prototype.clear()\n                    clear: function clear() {\n                        for (var that = validate(this, NAME), data = that._i, entry = that._f; entry; entry = entry.n) {\n                            entry.r = true;\n                            if (entry.p) entry.p = entry.p.n = undefined;\n                            delete data[entry.i];\n                        }\n                        that._f = that._l = undefined;\n                        that[SIZE] = 0;\n                    },\n                    // 23.1.3.3 Map.prototype.delete(key)\n                    // 23.2.3.4 Set.prototype.delete(value)\n                    'delete': function (key) {\n                        var that = validate(this, NAME);\n                        var entry = getEntry(that, key);\n                        if (entry) {\n                            var next = entry.n;\n                            var prev = entry.p;\n                            delete that._i[entry.i];\n                            entry.r = true;\n                            if (prev) prev.n = next;\n                            if (next) next.p = prev;\n                            if (that._f == entry) that._f = next;\n                            if (that._l == entry) that._l = prev;\n                            that[SIZE]--;\n                        } return !!entry;\n                    },\n                    // 23.2.3.6 Set.prototype.forEach(callbackfn, thisArg = undefined)\n                    // 23.1.3.5 Map.prototype.forEach(callbackfn, thisArg = undefined)\n                    forEach: function forEach(callbackfn /* , that = undefined */) {\n                        validate(this, NAME);\n                        var f = ctx(callbackfn, arguments.length > 1 ? arguments[1] : undefined, 3);\n                        var entry;\n                        while (entry = entry ? entry.n : this._f) {\n                            f(entry.v, entry.k, this);\n                            // revert to the last existing entry\n                            while (entry && entry.r) entry = entry.p;\n                        }\n                    },\n                    // 23.1.3.7 Map.prototype.has(key)\n                    // 23.2.3.7 Set.prototype.has(value)\n                    has: function has(key) {\n                        return !!getEntry(validate(this, NAME), key);\n                    }\n                });\n                if (DESCRIPTORS) dP(C.prototype, 'size', {\n                    get: function () {\n                        return validate(this, NAME)[SIZE];\n                    }\n                });\n                return C;\n            },\n            def: function (that, key, value) {\n                var entry = getEntry(that, key);\n                var prev, index;\n                // change existing entry\n                if (entry) {\n                    entry.v = value;\n                    // create new entry\n                } else {\n                    that._l = entry = {\n                        i: index = fastKey(key, true), // <- index\n                        k: key,                        // <- key\n                        v: value,                      // <- value\n                        p: prev = that._l,             // <- previous entry\n                        n: undefined,                  // <- next entry\n                        r: false                       // <- removed\n                    };\n                    if (!that._f) that._f = entry;\n                    if (prev) prev.n = entry;\n                    that[SIZE]++;\n                    // add to index\n                    if (index !== 'F') that._i[index] = entry;\n                } return that;\n            },\n            getEntry: getEntry,\n            setStrong: function (C, NAME, IS_MAP) {\n                // add .keys, .values, .entries, [@@iterator]\n                // 23.1.3.4, 23.1.3.8, 23.1.3.11, 23.1.3.12, 23.2.3.5, 23.2.3.8, 23.2.3.10, 23.2.3.11\n                $iterDefine(C, NAME, function (iterated, kind) {\n                    this._t = validate(iterated, NAME); // target\n                    this._k = kind;                     // kind\n                    this._l = undefined;                // previous\n                }, function () {\n                    var that = this;\n                    var kind = that._k;\n                    var entry = that._l;\n                    // revert to the last existing entry\n                    while (entry && entry.r) entry = entry.p;\n                    // get next entry\n                    if (!that._t || !(that._l = entry = entry ? entry.n : that._t._f)) {\n                        // or finish the iteration\n                        that._t = undefined;\n                        return step(1);\n                    }\n                    // return step by kind\n                    if (kind == 'keys') return step(0, entry.k);\n                    if (kind == 'values') return step(0, entry.v);\n                    return step(0, [entry.k, entry.v]);\n                }, IS_MAP ? 'entries' : 'values', !IS_MAP, true);\n\n                // add [@@species], 23.1.2.2, 23.2.2.2\n                setSpecies(NAME);\n            }\n        };\n\n    },{\"100\":100,\"125\":125,\"25\":25,\"29\":29,\"39\":39,\"55\":55,\"57\":57,\"6\":6,\"66\":66,\"71\":71,\"72\":72,\"93\":93}],20:[function(_dereq_,module,exports){\n// https://github.com/DavidBruant/Map-Set.prototype.toJSON\n        var classof = _dereq_(17);\n        var from = _dereq_(10);\n        module.exports = function (NAME) {\n            return function toJSON() {\n                if (classof(this) != NAME) throw TypeError(NAME + \"#toJSON isn't generic\");\n                return from(this);\n            };\n        };\n\n    },{\"10\":10,\"17\":17}],21:[function(_dereq_,module,exports){\n        'use strict';\n        var redefineAll = _dereq_(93);\n        var getWeak = _dereq_(66).getWeak;\n        var anObject = _dereq_(7);\n        var isObject = _dereq_(51);\n        var anInstance = _dereq_(6);\n        var forOf = _dereq_(39);\n        var createArrayMethod = _dereq_(12);\n        var $has = _dereq_(41);\n        var validate = _dereq_(125);\n        var arrayFind = createArrayMethod(5);\n        var arrayFindIndex = createArrayMethod(6);\n        var id = 0;\n\n// fallback for uncaught frozen keys\n        var uncaughtFrozenStore = function (that) {\n            return that._l || (that._l = new UncaughtFrozenStore());\n        };\n        var UncaughtFrozenStore = function () {\n            this.a = [];\n        };\n        var findUncaughtFrozen = function (store, key) {\n            return arrayFind(store.a, function (it) {\n                return it[0] === key;\n            });\n        };\n        UncaughtFrozenStore.prototype = {\n            get: function (key) {\n                var entry = findUncaughtFrozen(this, key);\n                if (entry) return entry[1];\n            },\n            has: function (key) {\n                return !!findUncaughtFrozen(this, key);\n            },\n            set: function (key, value) {\n                var entry = findUncaughtFrozen(this, key);\n                if (entry) entry[1] = value;\n                else this.a.push([key, value]);\n            },\n            'delete': function (key) {\n                var index = arrayFindIndex(this.a, function (it) {\n                    return it[0] === key;\n                });\n                if (~index) this.a.splice(index, 1);\n                return !!~index;\n            }\n        };\n\n        module.exports = {\n            getConstructor: function (wrapper, NAME, IS_MAP, ADDER) {\n                var C = wrapper(function (that, iterable) {\n                    anInstance(that, C, NAME, '_i');\n                    that._t = NAME;      // collection type\n                    that._i = id++;      // collection id\n                    that._l = undefined; // leak store for uncaught frozen objects\n                    if (iterable != undefined) forOf(iterable, IS_MAP, that[ADDER], that);\n                });\n                redefineAll(C.prototype, {\n                    // 23.3.3.2 WeakMap.prototype.delete(key)\n                    // 23.4.3.3 WeakSet.prototype.delete(value)\n                    'delete': function (key) {\n                        if (!isObject(key)) return false;\n                        var data = getWeak(key);\n                        if (data === true) return uncaughtFrozenStore(validate(this, NAME))['delete'](key);\n                        return data && $has(data, this._i) && delete data[this._i];\n                    },\n                    // 23.3.3.4 WeakMap.prototype.has(key)\n                    // 23.4.3.4 WeakSet.prototype.has(value)\n                    has: function has(key) {\n                        if (!isObject(key)) return false;\n                        var data = getWeak(key);\n                        if (data === true) return uncaughtFrozenStore(validate(this, NAME)).has(key);\n                        return data && $has(data, this._i);\n                    }\n                });\n                return C;\n            },\n            def: function (that, key, value) {\n                var data = getWeak(anObject(key), true);\n                if (data === true) uncaughtFrozenStore(that).set(key, value);\n                else data[that._i] = value;\n                return that;\n            },\n            ufstore: uncaughtFrozenStore\n        };\n\n    },{\"12\":12,\"125\":125,\"39\":39,\"41\":41,\"51\":51,\"6\":6,\"66\":66,\"7\":7,\"93\":93}],22:[function(_dereq_,module,exports){\n        'use strict';\n        var global = _dereq_(40);\n        var $export = _dereq_(33);\n        var redefine = _dereq_(94);\n        var redefineAll = _dereq_(93);\n        var meta = _dereq_(66);\n        var forOf = _dereq_(39);\n        var anInstance = _dereq_(6);\n        var isObject = _dereq_(51);\n        var fails = _dereq_(35);\n        var $iterDetect = _dereq_(56);\n        var setToStringTag = _dereq_(101);\n        var inheritIfRequired = _dereq_(45);\n\n        module.exports = function (NAME, wrapper, methods, common, IS_MAP, IS_WEAK) {\n            var Base = global[NAME];\n            var C = Base;\n            var ADDER = IS_MAP ? 'set' : 'add';\n            var proto = C && C.prototype;\n            var O = {};\n            var fixMethod = function (KEY) {\n                var fn = proto[KEY];\n                redefine(proto, KEY,\n                    KEY == 'delete' ? function (a) {\n                        return IS_WEAK && !isObject(a) ? false : fn.call(this, a === 0 ? 0 : a);\n                    } : KEY == 'has' ? function has(a) {\n                        return IS_WEAK && !isObject(a) ? false : fn.call(this, a === 0 ? 0 : a);\n                    } : KEY == 'get' ? function get(a) {\n                        return IS_WEAK && !isObject(a) ? undefined : fn.call(this, a === 0 ? 0 : a);\n                    } : KEY == 'add' ? function add(a) { fn.call(this, a === 0 ? 0 : a); return this; }\n                        : function set(a, b) { fn.call(this, a === 0 ? 0 : a, b); return this; }\n                );\n            };\n            if (typeof C != 'function' || !(IS_WEAK || proto.forEach && !fails(function () {\n                new C().entries().next();\n            }))) {\n                // create collection constructor\n                C = common.getConstructor(wrapper, NAME, IS_MAP, ADDER);\n                redefineAll(C.prototype, methods);\n                meta.NEED = true;\n            } else {\n                var instance = new C();\n                // early implementations not supports chaining\n                var HASNT_CHAINING = instance[ADDER](IS_WEAK ? {} : -0, 1) != instance;\n                // V8 ~  Chromium 40- weak-collections throws on primitives, but should return false\n                var THROWS_ON_PRIMITIVES = fails(function () { instance.has(1); });\n                // most early implementations doesn't supports iterables, most modern - not close it correctly\n                var ACCEPT_ITERABLES = $iterDetect(function (iter) { new C(iter); }); // eslint-disable-line no-new\n                // for early implementations -0 and +0 not the same\n                var BUGGY_ZERO = !IS_WEAK && fails(function () {\n                    // V8 ~ Chromium 42- fails only with 5+ elements\n                    var $instance = new C();\n                    var index = 5;\n                    while (index--) $instance[ADDER](index, index);\n                    return !$instance.has(-0);\n                });\n                if (!ACCEPT_ITERABLES) {\n                    C = wrapper(function (target, iterable) {\n                        anInstance(target, C, NAME);\n                        var that = inheritIfRequired(new Base(), target, C);\n                        if (iterable != undefined) forOf(iterable, IS_MAP, that[ADDER], that);\n                        return that;\n                    });\n                    C.prototype = proto;\n                    proto.constructor = C;\n                }\n                if (THROWS_ON_PRIMITIVES || BUGGY_ZERO) {\n                    fixMethod('delete');\n                    fixMethod('has');\n                    IS_MAP && fixMethod('get');\n                }\n                if (BUGGY_ZERO || HASNT_CHAINING) fixMethod(ADDER);\n                // weak collections should not contains .clear method\n                if (IS_WEAK && proto.clear) delete proto.clear;\n            }\n\n            setToStringTag(C, NAME);\n\n            O[NAME] = C;\n            $export($export.G + $export.W + $export.F * (C != Base), O);\n\n            if (!IS_WEAK) common.setStrong(C, NAME, IS_MAP);\n\n            return C;\n        };\n\n    },{\"101\":101,\"33\":33,\"35\":35,\"39\":39,\"40\":40,\"45\":45,\"51\":51,\"56\":56,\"6\":6,\"66\":66,\"93\":93,\"94\":94}],23:[function(_dereq_,module,exports){\n        var core = module.exports = { version: '2.5.0' };\n        if (typeof __e == 'number') __e = core; // eslint-disable-line no-undef\n\n    },{}],24:[function(_dereq_,module,exports){\n        'use strict';\n        var $defineProperty = _dereq_(72);\n        var createDesc = _dereq_(92);\n\n        module.exports = function (object, index, value) {\n            if (index in object) $defineProperty.f(object, index, createDesc(0, value));\n            else object[index] = value;\n        };\n\n    },{\"72\":72,\"92\":92}],25:[function(_dereq_,module,exports){\n// optional / simple context binding\n        var aFunction = _dereq_(3);\n        module.exports = function (fn, that, length) {\n            aFunction(fn);\n            if (that === undefined) return fn;\n            switch (length) {\n                case 1: return function (a) {\n                    return fn.call(that, a);\n                };\n                case 2: return function (a, b) {\n                    return fn.call(that, a, b);\n                };\n                case 3: return function (a, b, c) {\n                    return fn.call(that, a, b, c);\n                };\n            }\n            return function (/* ...args */) {\n                return fn.apply(that, arguments);\n            };\n        };\n\n    },{\"3\":3}],26:[function(_dereq_,module,exports){\n        'use strict';\n// 20.3.4.36 / 15.9.5.43 Date.prototype.toISOString()\n        var fails = _dereq_(35);\n        var getTime = Date.prototype.getTime;\n        var $toISOString = Date.prototype.toISOString;\n\n        var lz = function (num) {\n            return num > 9 ? num : '0' + num;\n        };\n\n// PhantomJS / old WebKit has a broken implementations\n        module.exports = (fails(function () {\n            return $toISOString.call(new Date(-5e13 - 1)) != '0385-07-25T07:06:39.999Z';\n        }) || !fails(function () {\n            $toISOString.call(new Date(NaN));\n        })) ? function toISOString() {\n            if (!isFinite(getTime.call(this))) throw RangeError('Invalid time value');\n            var d = this;\n            var y = d.getUTCFullYear();\n            var m = d.getUTCMilliseconds();\n            var s = y < 0 ? '-' : y > 9999 ? '+' : '';\n            return s + ('00000' + Math.abs(y)).slice(s ? -6 : -4) +\n                '-' + lz(d.getUTCMonth() + 1) + '-' + lz(d.getUTCDate()) +\n                'T' + lz(d.getUTCHours()) + ':' + lz(d.getUTCMinutes()) +\n                ':' + lz(d.getUTCSeconds()) + '.' + (m > 99 ? m : '0' + lz(m)) + 'Z';\n        } : $toISOString;\n\n    },{\"35\":35}],27:[function(_dereq_,module,exports){\n        'use strict';\n        var anObject = _dereq_(7);\n        var toPrimitive = _dereq_(120);\n        var NUMBER = 'number';\n\n        module.exports = function (hint) {\n            if (hint !== 'string' && hint !== NUMBER && hint !== 'default') throw TypeError('Incorrect hint');\n            return toPrimitive(anObject(this), hint != NUMBER);\n        };\n\n    },{\"120\":120,\"7\":7}],28:[function(_dereq_,module,exports){\n// 7.2.1 RequireObjectCoercible(argument)\n        module.exports = function (it) {\n            if (it == undefined) throw TypeError(\"Can't call method on  \" + it);\n            return it;\n        };\n\n    },{}],29:[function(_dereq_,module,exports){\n// Thank's IE8 for his funny defineProperty\n        module.exports = !_dereq_(35)(function () {\n            return Object.defineProperty({}, 'a', { get: function () { return 7; } }).a != 7;\n        });\n\n    },{\"35\":35}],30:[function(_dereq_,module,exports){\n        var isObject = _dereq_(51);\n        var document = _dereq_(40).document;\n// typeof document.createElement is 'object' in old IE\n        var is = isObject(document) && isObject(document.createElement);\n        module.exports = function (it) {\n            return is ? document.createElement(it) : {};\n        };\n\n    },{\"40\":40,\"51\":51}],31:[function(_dereq_,module,exports){\n// IE 8- don't enum bug keys\n        module.exports = (\n            'constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf'\n        ).split(',');\n\n    },{}],32:[function(_dereq_,module,exports){\n// all enumerable object keys, includes symbols\n        var getKeys = _dereq_(81);\n        var gOPS = _dereq_(78);\n        var pIE = _dereq_(82);\n        module.exports = function (it) {\n            var result = getKeys(it);\n            var getSymbols = gOPS.f;\n            if (getSymbols) {\n                var symbols = getSymbols(it);\n                var isEnum = pIE.f;\n                var i = 0;\n                var key;\n                while (symbols.length > i) if (isEnum.call(it, key = symbols[i++])) result.push(key);\n            } return result;\n        };\n\n    },{\"78\":78,\"81\":81,\"82\":82}],33:[function(_dereq_,module,exports){\n        var global = _dereq_(40);\n        var core = _dereq_(23);\n        var hide = _dereq_(42);\n        var redefine = _dereq_(94);\n        var ctx = _dereq_(25);\n        var PROTOTYPE = 'prototype';\n\n        var $export = function (type, name, source) {\n            var IS_FORCED = type & $export.F;\n            var IS_GLOBAL = type & $export.G;\n            var IS_STATIC = type & $export.S;\n            var IS_PROTO = type & $export.P;\n            var IS_BIND = type & $export.B;\n            var target = IS_GLOBAL ? global : IS_STATIC ? global[name] || (global[name] = {}) : (global[name] || {})[PROTOTYPE];\n            var exports = IS_GLOBAL ? core : core[name] || (core[name] = {});\n            var expProto = exports[PROTOTYPE] || (exports[PROTOTYPE] = {});\n            var key, own, out, exp;\n            if (IS_GLOBAL) source = name;\n            for (key in source) {\n                // contains in native\n                own = !IS_FORCED && target && target[key] !== undefined;\n                // export native or passed\n                out = (own ? target : source)[key];\n                // bind timers to global for call from export context\n                exp = IS_BIND && own ? ctx(out, global) : IS_PROTO && typeof out == 'function' ? ctx(Function.call, out) : out;\n                // extend global\n                if (target) redefine(target, key, out, type & $export.U);\n                // export\n                if (exports[key] != out) hide(exports, key, exp);\n                if (IS_PROTO && expProto[key] != out) expProto[key] = out;\n            }\n        };\n        global.core = core;\n// type bitmap\n        $export.F = 1;   // forced\n        $export.G = 2;   // global\n        $export.S = 4;   // static\n        $export.P = 8;   // proto\n        $export.B = 16;  // bind\n        $export.W = 32;  // wrap\n        $export.U = 64;  // safe\n        $export.R = 128; // real proto method for `library`\n        module.exports = $export;\n\n    },{\"23\":23,\"25\":25,\"40\":40,\"42\":42,\"94\":94}],34:[function(_dereq_,module,exports){\n        var MATCH = _dereq_(128)('match');\n        module.exports = function (KEY) {\n            var re = /./;\n            try {\n                '/./'[KEY](re);\n            } catch (e) {\n                try {\n                    re[MATCH] = false;\n                    return !'/./'[KEY](re);\n                } catch (f) { /* empty */ }\n            } return true;\n        };\n\n    },{\"128\":128}],35:[function(_dereq_,module,exports){\n        module.exports = function (exec) {\n            try {\n                return !!exec();\n            } catch (e) {\n                return true;\n            }\n        };\n\n    },{}],36:[function(_dereq_,module,exports){\n        'use strict';\n        var hide = _dereq_(42);\n        var redefine = _dereq_(94);\n        var fails = _dereq_(35);\n        var defined = _dereq_(28);\n        var wks = _dereq_(128);\n\n        module.exports = function (KEY, length, exec) {\n            var SYMBOL = wks(KEY);\n            var fns = exec(defined, SYMBOL, ''[KEY]);\n            var strfn = fns[0];\n            var rxfn = fns[1];\n            if (fails(function () {\n                var O = {};\n                O[SYMBOL] = function () { return 7; };\n                return ''[KEY](O) != 7;\n            })) {\n                redefine(String.prototype, KEY, strfn);\n                hide(RegExp.prototype, SYMBOL, length == 2\n                    // 21.2.5.8 RegExp.prototype[@@replace](string, replaceValue)\n                    // 21.2.5.11 RegExp.prototype[@@split](string, limit)\n                    ? function (string, arg) { return rxfn.call(string, this, arg); }\n                    // 21.2.5.6 RegExp.prototype[@@match](string)\n                    // 21.2.5.9 RegExp.prototype[@@search](string)\n                    : function (string) { return rxfn.call(string, this); }\n                );\n            }\n        };\n\n    },{\"128\":128,\"28\":28,\"35\":35,\"42\":42,\"94\":94}],37:[function(_dereq_,module,exports){\n        'use strict';\n// 21.2.5.3 get RegExp.prototype.flags\n        var anObject = _dereq_(7);\n        module.exports = function () {\n            var that = anObject(this);\n            var result = '';\n            if (that.global) result += 'g';\n            if (that.ignoreCase) result += 'i';\n            if (that.multiline) result += 'm';\n            if (that.unicode) result += 'u';\n            if (that.sticky) result += 'y';\n            return result;\n        };\n\n    },{\"7\":7}],38:[function(_dereq_,module,exports){\n        'use strict';\n// https://tc39.github.io/proposal-flatMap/#sec-FlattenIntoArray\n        var isArray = _dereq_(49);\n        var isObject = _dereq_(51);\n        var toLength = _dereq_(118);\n        var ctx = _dereq_(25);\n        var IS_CONCAT_SPREADABLE = _dereq_(128)('isConcatSpreadable');\n\n        function flattenIntoArray(target, original, source, sourceLen, start, depth, mapper, thisArg) {\n            var targetIndex = start;\n            var sourceIndex = 0;\n            var mapFn = mapper ? ctx(mapper, thisArg, 3) : false;\n            var element, spreadable;\n\n            while (sourceIndex < sourceLen) {\n                if (sourceIndex in source) {\n                    element = mapFn ? mapFn(source[sourceIndex], sourceIndex, original) : source[sourceIndex];\n\n                    spreadable = false;\n                    if (isObject(element)) {\n                        spreadable = element[IS_CONCAT_SPREADABLE];\n                        spreadable = spreadable !== undefined ? !!spreadable : isArray(element);\n                    }\n\n                    if (spreadable && depth > 0) {\n                        targetIndex = flattenIntoArray(target, original, element, toLength(element.length), targetIndex, depth - 1) - 1;\n                    } else {\n                        if (targetIndex >= 0x1fffffffffffff) throw TypeError();\n                        target[targetIndex] = element;\n                    }\n\n                    targetIndex++;\n                }\n                sourceIndex++;\n            }\n            return targetIndex;\n        }\n\n        module.exports = flattenIntoArray;\n\n    },{\"118\":118,\"128\":128,\"25\":25,\"49\":49,\"51\":51}],39:[function(_dereq_,module,exports){\n        var ctx = _dereq_(25);\n        var call = _dereq_(53);\n        var isArrayIter = _dereq_(48);\n        var anObject = _dereq_(7);\n        var toLength = _dereq_(118);\n        var getIterFn = _dereq_(129);\n        var BREAK = {};\n        var RETURN = {};\n        var exports = module.exports = function (iterable, entries, fn, that, ITERATOR) {\n            var iterFn = ITERATOR ? function () { return iterable; } : getIterFn(iterable);\n            var f = ctx(fn, that, entries ? 2 : 1);\n            var index = 0;\n            var length, step, iterator, result;\n            if (typeof iterFn != 'function') throw TypeError(iterable + ' is not iterable!');\n            // fast case for arrays with default iterator\n            if (isArrayIter(iterFn)) for (length = toLength(iterable.length); length > index; index++) {\n                result = entries ? f(anObject(step = iterable[index])[0], step[1]) : f(iterable[index]);\n                if (result === BREAK || result === RETURN) return result;\n            } else for (iterator = iterFn.call(iterable); !(step = iterator.next()).done;) {\n                result = call(iterator, f, step.value, entries);\n                if (result === BREAK || result === RETURN) return result;\n            }\n        };\n        exports.BREAK = BREAK;\n        exports.RETURN = RETURN;\n\n    },{\"118\":118,\"129\":129,\"25\":25,\"48\":48,\"53\":53,\"7\":7}],40:[function(_dereq_,module,exports){\n// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028\n        var global = module.exports = typeof window != 'undefined' && window.Math == Math\n            ? window : typeof self != 'undefined' && self.Math == Math ? self\n                // eslint-disable-next-line no-new-func\n                : Function('return this')();\n        if (typeof __g == 'number') __g = global; // eslint-disable-line no-undef\n\n    },{}],41:[function(_dereq_,module,exports){\n        var hasOwnProperty = {}.hasOwnProperty;\n        module.exports = function (it, key) {\n            return hasOwnProperty.call(it, key);\n        };\n\n    },{}],42:[function(_dereq_,module,exports){\n        var dP = _dereq_(72);\n        var createDesc = _dereq_(92);\n        module.exports = _dereq_(29) ? function (object, key, value) {\n            return dP.f(object, key, createDesc(1, value));\n        } : function (object, key, value) {\n            object[key] = value;\n            return object;\n        };\n\n    },{\"29\":29,\"72\":72,\"92\":92}],43:[function(_dereq_,module,exports){\n        var document = _dereq_(40).document;\n        module.exports = document && document.documentElement;\n\n    },{\"40\":40}],44:[function(_dereq_,module,exports){\n        module.exports = !_dereq_(29) && !_dereq_(35)(function () {\n            return Object.defineProperty(_dereq_(30)('div'), 'a', { get: function () { return 7; } }).a != 7;\n        });\n\n    },{\"29\":29,\"30\":30,\"35\":35}],45:[function(_dereq_,module,exports){\n        var isObject = _dereq_(51);\n        var setPrototypeOf = _dereq_(99).set;\n        module.exports = function (that, target, C) {\n            var S = target.constructor;\n            var P;\n            if (S !== C && typeof S == 'function' && (P = S.prototype) !== C.prototype && isObject(P) && setPrototypeOf) {\n                setPrototypeOf(that, P);\n            } return that;\n        };\n\n    },{\"51\":51,\"99\":99}],46:[function(_dereq_,module,exports){\n// fast apply, http://jsperf.lnkit.com/fast-apply/5\n        module.exports = function (fn, args, that) {\n            var un = that === undefined;\n            switch (args.length) {\n                case 0: return un ? fn()\n                    : fn.call(that);\n                case 1: return un ? fn(args[0])\n                    : fn.call(that, args[0]);\n                case 2: return un ? fn(args[0], args[1])\n                    : fn.call(that, args[0], args[1]);\n                case 3: return un ? fn(args[0], args[1], args[2])\n                    : fn.call(that, args[0], args[1], args[2]);\n                case 4: return un ? fn(args[0], args[1], args[2], args[3])\n                    : fn.call(that, args[0], args[1], args[2], args[3]);\n            } return fn.apply(that, args);\n        };\n\n    },{}],47:[function(_dereq_,module,exports){\n// fallback for non-array-like ES3 and non-enumerable old V8 strings\n        var cof = _dereq_(18);\n// eslint-disable-next-line no-prototype-builtins\n        module.exports = Object('z').propertyIsEnumerable(0) ? Object : function (it) {\n            return cof(it) == 'String' ? it.split('') : Object(it);\n        };\n\n    },{\"18\":18}],48:[function(_dereq_,module,exports){\n// check on default Array iterator\n        var Iterators = _dereq_(58);\n        var ITERATOR = _dereq_(128)('iterator');\n        var ArrayProto = Array.prototype;\n\n        module.exports = function (it) {\n            return it !== undefined && (Iterators.Array === it || ArrayProto[ITERATOR] === it);\n        };\n\n    },{\"128\":128,\"58\":58}],49:[function(_dereq_,module,exports){\n// 7.2.2 IsArray(argument)\n        var cof = _dereq_(18);\n        module.exports = Array.isArray || function isArray(arg) {\n            return cof(arg) == 'Array';\n        };\n\n    },{\"18\":18}],50:[function(_dereq_,module,exports){\n// 20.1.2.3 Number.isInteger(number)\n        var isObject = _dereq_(51);\n        var floor = Math.floor;\n        module.exports = function isInteger(it) {\n            return !isObject(it) && isFinite(it) && floor(it) === it;\n        };\n\n    },{\"51\":51}],51:[function(_dereq_,module,exports){\n        module.exports = function (it) {\n            return typeof it === 'object' ? it !== null : typeof it === 'function';\n        };\n\n    },{}],52:[function(_dereq_,module,exports){\n// 7.2.8 IsRegExp(argument)\n        var isObject = _dereq_(51);\n        var cof = _dereq_(18);\n        var MATCH = _dereq_(128)('match');\n        module.exports = function (it) {\n            var isRegExp;\n            return isObject(it) && ((isRegExp = it[MATCH]) !== undefined ? !!isRegExp : cof(it) == 'RegExp');\n        };\n\n    },{\"128\":128,\"18\":18,\"51\":51}],53:[function(_dereq_,module,exports){\n// call something on iterator step with safe closing on error\n        var anObject = _dereq_(7);\n        module.exports = function (iterator, fn, value, entries) {\n            try {\n                return entries ? fn(anObject(value)[0], value[1]) : fn(value);\n                // 7.4.6 IteratorClose(iterator, completion)\n            } catch (e) {\n                var ret = iterator['return'];\n                if (ret !== undefined) anObject(ret.call(iterator));\n                throw e;\n            }\n        };\n\n    },{\"7\":7}],54:[function(_dereq_,module,exports){\n        'use strict';\n        var create = _dereq_(71);\n        var descriptor = _dereq_(92);\n        var setToStringTag = _dereq_(101);\n        var IteratorPrototype = {};\n\n// 25.1.2.1.1 %IteratorPrototype%[@@iterator]()\n        _dereq_(42)(IteratorPrototype, _dereq_(128)('iterator'), function () { return this; });\n\n        module.exports = function (Constructor, NAME, next) {\n            Constructor.prototype = create(IteratorPrototype, { next: descriptor(1, next) });\n            setToStringTag(Constructor, NAME + ' Iterator');\n        };\n\n    },{\"101\":101,\"128\":128,\"42\":42,\"71\":71,\"92\":92}],55:[function(_dereq_,module,exports){\n        'use strict';\n        var LIBRARY = _dereq_(60);\n        var $export = _dereq_(33);\n        var redefine = _dereq_(94);\n        var hide = _dereq_(42);\n        var has = _dereq_(41);\n        var Iterators = _dereq_(58);\n        var $iterCreate = _dereq_(54);\n        var setToStringTag = _dereq_(101);\n        var getPrototypeOf = _dereq_(79);\n        var ITERATOR = _dereq_(128)('iterator');\n        var BUGGY = !([].keys && 'next' in [].keys()); // Safari has buggy iterators w/o `next`\n        var FF_ITERATOR = '@@iterator';\n        var KEYS = 'keys';\n        var VALUES = 'values';\n\n        var returnThis = function () { return this; };\n\n        module.exports = function (Base, NAME, Constructor, next, DEFAULT, IS_SET, FORCED) {\n            $iterCreate(Constructor, NAME, next);\n            var getMethod = function (kind) {\n                if (!BUGGY && kind in proto) return proto[kind];\n                switch (kind) {\n                    case KEYS: return function keys() { return new Constructor(this, kind); };\n                    case VALUES: return function values() { return new Constructor(this, kind); };\n                } return function entries() { return new Constructor(this, kind); };\n            };\n            var TAG = NAME + ' Iterator';\n            var DEF_VALUES = DEFAULT == VALUES;\n            var VALUES_BUG = false;\n            var proto = Base.prototype;\n            var $native = proto[ITERATOR] || proto[FF_ITERATOR] || DEFAULT && proto[DEFAULT];\n            var $default = $native || getMethod(DEFAULT);\n            var $entries = DEFAULT ? !DEF_VALUES ? $default : getMethod('entries') : undefined;\n            var $anyNative = NAME == 'Array' ? proto.entries || $native : $native;\n            var methods, key, IteratorPrototype;\n            // Fix native\n            if ($anyNative) {\n                IteratorPrototype = getPrototypeOf($anyNative.call(new Base()));\n                if (IteratorPrototype !== Object.prototype && IteratorPrototype.next) {\n                    // Set @@toStringTag to native iterators\n                    setToStringTag(IteratorPrototype, TAG, true);\n                    // fix for some old engines\n                    if (!LIBRARY && !has(IteratorPrototype, ITERATOR)) hide(IteratorPrototype, ITERATOR, returnThis);\n                }\n            }\n            // fix Array#{values, @@iterator}.name in V8 / FF\n            if (DEF_VALUES && $native && $native.name !== VALUES) {\n                VALUES_BUG = true;\n                $default = function values() { return $native.call(this); };\n            }\n            // Define iterator\n            if ((!LIBRARY || FORCED) && (BUGGY || VALUES_BUG || !proto[ITERATOR])) {\n                hide(proto, ITERATOR, $default);\n            }\n            // Plug for library\n            Iterators[NAME] = $default;\n            Iterators[TAG] = returnThis;\n            if (DEFAULT) {\n                methods = {\n                    values: DEF_VALUES ? $default : getMethod(VALUES),\n                    keys: IS_SET ? $default : getMethod(KEYS),\n                    entries: $entries\n                };\n                if (FORCED) for (key in methods) {\n                    if (!(key in proto)) redefine(proto, key, methods[key]);\n                } else $export($export.P + $export.F * (BUGGY || VALUES_BUG), NAME, methods);\n            }\n            return methods;\n        };\n\n    },{\"101\":101,\"128\":128,\"33\":33,\"41\":41,\"42\":42,\"54\":54,\"58\":58,\"60\":60,\"79\":79,\"94\":94}],56:[function(_dereq_,module,exports){\n        var ITERATOR = _dereq_(128)('iterator');\n        var SAFE_CLOSING = false;\n\n        try {\n            var riter = [7][ITERATOR]();\n            riter['return'] = function () { SAFE_CLOSING = true; };\n            // eslint-disable-next-line no-throw-literal\n            Array.from(riter, function () { throw 2; });\n        } catch (e) { /* empty */ }\n\n        module.exports = function (exec, skipClosing) {\n            if (!skipClosing && !SAFE_CLOSING) return false;\n            var safe = false;\n            try {\n                var arr = [7];\n                var iter = arr[ITERATOR]();\n                iter.next = function () { return { done: safe = true }; };\n                arr[ITERATOR] = function () { return iter; };\n                exec(arr);\n            } catch (e) { /* empty */ }\n            return safe;\n        };\n\n    },{\"128\":128}],57:[function(_dereq_,module,exports){\n        module.exports = function (done, value) {\n            return { value: value, done: !!done };\n        };\n\n    },{}],58:[function(_dereq_,module,exports){\n        module.exports = {};\n\n    },{}],59:[function(_dereq_,module,exports){\n        var getKeys = _dereq_(81);\n        var toIObject = _dereq_(117);\n        module.exports = function (object, el) {\n            var O = toIObject(object);\n            var keys = getKeys(O);\n            var length = keys.length;\n            var index = 0;\n            var key;\n            while (length > index) if (O[key = keys[index++]] === el) return key;\n        };\n\n    },{\"117\":117,\"81\":81}],60:[function(_dereq_,module,exports){\n        module.exports = false;\n\n    },{}],61:[function(_dereq_,module,exports){\n// 20.2.2.14 Math.expm1(x)\n        var $expm1 = Math.expm1;\n        module.exports = (!$expm1\n            // Old FF bug\n            || $expm1(10) > 22025.465794806719 || $expm1(10) < 22025.4657948067165168\n            // Tor Browser bug\n            || $expm1(-2e-17) != -2e-17\n        ) ? function expm1(x) {\n            return (x = +x) == 0 ? x : x > -1e-6 && x < 1e-6 ? x + x * x / 2 : Math.exp(x) - 1;\n        } : $expm1;\n\n    },{}],62:[function(_dereq_,module,exports){\n// 20.2.2.16 Math.fround(x)\n        var sign = _dereq_(65);\n        var pow = Math.pow;\n        var EPSILON = pow(2, -52);\n        var EPSILON32 = pow(2, -23);\n        var MAX32 = pow(2, 127) * (2 - EPSILON32);\n        var MIN32 = pow(2, -126);\n\n        var roundTiesToEven = function (n) {\n            return n + 1 / EPSILON - 1 / EPSILON;\n        };\n\n        module.exports = Math.fround || function fround(x) {\n            var $abs = Math.abs(x);\n            var $sign = sign(x);\n            var a, result;\n            if ($abs < MIN32) return $sign * roundTiesToEven($abs / MIN32 / EPSILON32) * MIN32 * EPSILON32;\n            a = (1 + EPSILON32 / EPSILON) * $abs;\n            result = a - (a - $abs);\n            // eslint-disable-next-line no-self-compare\n            if (result > MAX32 || result != result) return $sign * Infinity;\n            return $sign * result;\n        };\n\n    },{\"65\":65}],63:[function(_dereq_,module,exports){\n// 20.2.2.20 Math.log1p(x)\n        module.exports = Math.log1p || function log1p(x) {\n            return (x = +x) > -1e-8 && x < 1e-8 ? x - x * x / 2 : Math.log(1 + x);\n        };\n\n    },{}],64:[function(_dereq_,module,exports){\n// https://rwaldron.github.io/proposal-math-extensions/\n        module.exports = Math.scale || function scale(x, inLow, inHigh, outLow, outHigh) {\n            if (\n                arguments.length === 0\n                // eslint-disable-next-line no-self-compare\n                || x != x\n                // eslint-disable-next-line no-self-compare\n                || inLow != inLow\n                // eslint-disable-next-line no-self-compare\n                || inHigh != inHigh\n                // eslint-disable-next-line no-self-compare\n                || outLow != outLow\n                // eslint-disable-next-line no-self-compare\n                || outHigh != outHigh\n            ) return NaN;\n            if (x === Infinity || x === -Infinity) return x;\n            return (x - inLow) * (outHigh - outLow) / (inHigh - inLow) + outLow;\n        };\n\n    },{}],65:[function(_dereq_,module,exports){\n// 20.2.2.28 Math.sign(x)\n        module.exports = Math.sign || function sign(x) {\n            // eslint-disable-next-line no-self-compare\n            return (x = +x) == 0 || x != x ? x : x < 0 ? -1 : 1;\n        };\n\n    },{}],66:[function(_dereq_,module,exports){\n        var META = _dereq_(124)('meta');\n        var isObject = _dereq_(51);\n        var has = _dereq_(41);\n        var setDesc = _dereq_(72).f;\n        var id = 0;\n        var isExtensible = Object.isExtensible || function () {\n            return true;\n        };\n        var FREEZE = !_dereq_(35)(function () {\n            return isExtensible(Object.preventExtensions({}));\n        });\n        var setMeta = function (it) {\n            setDesc(it, META, { value: {\n                    i: 'O' + ++id, // object ID\n                    w: {}          // weak collections IDs\n                } });\n        };\n        var fastKey = function (it, create) {\n            // return primitive with prefix\n            if (!isObject(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;\n            if (!has(it, META)) {\n                // can't set metadata to uncaught frozen object\n                if (!isExtensible(it)) return 'F';\n                // not necessary to add metadata\n                if (!create) return 'E';\n                // add missing metadata\n                setMeta(it);\n                // return object ID\n            } return it[META].i;\n        };\n        var getWeak = function (it, create) {\n            if (!has(it, META)) {\n                // can't set metadata to uncaught frozen object\n                if (!isExtensible(it)) return true;\n                // not necessary to add metadata\n                if (!create) return false;\n                // add missing metadata\n                setMeta(it);\n                // return hash weak collections IDs\n            } return it[META].w;\n        };\n// add metadata on freeze-family methods calling\n        var onFreeze = function (it) {\n            if (FREEZE && meta.NEED && isExtensible(it) && !has(it, META)) setMeta(it);\n            return it;\n        };\n        var meta = module.exports = {\n            KEY: META,\n            NEED: false,\n            fastKey: fastKey,\n            getWeak: getWeak,\n            onFreeze: onFreeze\n        };\n\n    },{\"124\":124,\"35\":35,\"41\":41,\"51\":51,\"72\":72}],67:[function(_dereq_,module,exports){\n        var Map = _dereq_(160);\n        var $export = _dereq_(33);\n        var shared = _dereq_(103)('metadata');\n        var store = shared.store || (shared.store = new (_dereq_(266))());\n\n        var getOrCreateMetadataMap = function (target, targetKey, create) {\n            var targetMetadata = store.get(target);\n            if (!targetMetadata) {\n                if (!create) return undefined;\n                store.set(target, targetMetadata = new Map());\n            }\n            var keyMetadata = targetMetadata.get(targetKey);\n            if (!keyMetadata) {\n                if (!create) return undefined;\n                targetMetadata.set(targetKey, keyMetadata = new Map());\n            } return keyMetadata;\n        };\n        var ordinaryHasOwnMetadata = function (MetadataKey, O, P) {\n            var metadataMap = getOrCreateMetadataMap(O, P, false);\n            return metadataMap === undefined ? false : metadataMap.has(MetadataKey);\n        };\n        var ordinaryGetOwnMetadata = function (MetadataKey, O, P) {\n            var metadataMap = getOrCreateMetadataMap(O, P, false);\n            return metadataMap === undefined ? undefined : metadataMap.get(MetadataKey);\n        };\n        var ordinaryDefineOwnMetadata = function (MetadataKey, MetadataValue, O, P) {\n            getOrCreateMetadataMap(O, P, true).set(MetadataKey, MetadataValue);\n        };\n        var ordinaryOwnMetadataKeys = function (target, targetKey) {\n            var metadataMap = getOrCreateMetadataMap(target, targetKey, false);\n            var keys = [];\n            if (metadataMap) metadataMap.forEach(function (_, key) { keys.push(key); });\n            return keys;\n        };\n        var toMetaKey = function (it) {\n            return it === undefined || typeof it == 'symbol' ? it : String(it);\n        };\n        var exp = function (O) {\n            $export($export.S, 'Reflect', O);\n        };\n\n        module.exports = {\n            store: store,\n            map: getOrCreateMetadataMap,\n            has: ordinaryHasOwnMetadata,\n            get: ordinaryGetOwnMetadata,\n            set: ordinaryDefineOwnMetadata,\n            keys: ordinaryOwnMetadataKeys,\n            key: toMetaKey,\n            exp: exp\n        };\n\n    },{\"103\":103,\"160\":160,\"266\":266,\"33\":33}],68:[function(_dereq_,module,exports){\n        var global = _dereq_(40);\n        var macrotask = _dereq_(113).set;\n        var Observer = global.MutationObserver || global.WebKitMutationObserver;\n        var process = global.process;\n        var Promise = global.Promise;\n        var isNode = _dereq_(18)(process) == 'process';\n\n        module.exports = function () {\n            var head, last, notify;\n\n            var flush = function () {\n                var parent, fn;\n                if (isNode && (parent = process.domain)) parent.exit();\n                while (head) {\n                    fn = head.fn;\n                    head = head.next;\n                    try {\n                        fn();\n                    } catch (e) {\n                        if (head) notify();\n                        else last = undefined;\n                        throw e;\n                    }\n                } last = undefined;\n                if (parent) parent.enter();\n            };\n\n            // Node.js\n            if (isNode) {\n                notify = function () {\n                    process.nextTick(flush);\n                };\n                // browsers with MutationObserver\n            } else if (Observer) {\n                var toggle = true;\n                var node = document.createTextNode('');\n                new Observer(flush).observe(node, { characterData: true }); // eslint-disable-line no-new\n                notify = function () {\n                    node.data = toggle = !toggle;\n                };\n                // environments with maybe non-completely correct, but existent Promise\n            } else if (Promise && Promise.resolve) {\n                var promise = Promise.resolve();\n                notify = function () {\n                    promise.then(flush);\n                };\n                // for other environments - macrotask based on:\n                // - setImmediate\n                // - MessageChannel\n                // - window.postMessag\n                // - onreadystatechange\n                // - setTimeout\n            } else {\n                notify = function () {\n                    // strange IE + webpack dev server bug - use .call(global)\n                    macrotask.call(global, flush);\n                };\n            }\n\n            return function (fn) {\n                var task = { fn: fn, next: undefined };\n                if (last) last.next = task;\n                if (!head) {\n                    head = task;\n                    notify();\n                } last = task;\n            };\n        };\n\n    },{\"113\":113,\"18\":18,\"40\":40}],69:[function(_dereq_,module,exports){\n        'use strict';\n// 25.4.1.5 NewPromiseCapability(C)\n        var aFunction = _dereq_(3);\n\n        function PromiseCapability(C) {\n            var resolve, reject;\n            this.promise = new C(function ($$resolve, $$reject) {\n                if (resolve !== undefined || reject !== undefined) throw TypeError('Bad Promise constructor');\n                resolve = $$resolve;\n                reject = $$reject;\n            });\n            this.resolve = aFunction(resolve);\n            this.reject = aFunction(reject);\n        }\n\n        module.exports.f = function (C) {\n            return new PromiseCapability(C);\n        };\n\n    },{\"3\":3}],70:[function(_dereq_,module,exports){\n        'use strict';\n// 19.1.2.1 Object.assign(target, source, ...)\n        var getKeys = _dereq_(81);\n        var gOPS = _dereq_(78);\n        var pIE = _dereq_(82);\n        var toObject = _dereq_(119);\n        var IObject = _dereq_(47);\n        var $assign = Object.assign;\n\n// should work with symbols and should have deterministic property order (V8 bug)\n        module.exports = !$assign || _dereq_(35)(function () {\n            var A = {};\n            var B = {};\n            // eslint-disable-next-line no-undef\n            var S = Symbol();\n            var K = 'abcdefghijklmnopqrst';\n            A[S] = 7;\n            K.split('').forEach(function (k) { B[k] = k; });\n            return $assign({}, A)[S] != 7 || Object.keys($assign({}, B)).join('') != K;\n        }) ? function assign(target, source) { // eslint-disable-line no-unused-vars\n            var T = toObject(target);\n            var aLen = arguments.length;\n            var index = 1;\n            var getSymbols = gOPS.f;\n            var isEnum = pIE.f;\n            while (aLen > index) {\n                var S = IObject(arguments[index++]);\n                var keys = getSymbols ? getKeys(S).concat(getSymbols(S)) : getKeys(S);\n                var length = keys.length;\n                var j = 0;\n                var key;\n                while (length > j) if (isEnum.call(S, key = keys[j++])) T[key] = S[key];\n            } return T;\n        } : $assign;\n\n    },{\"119\":119,\"35\":35,\"47\":47,\"78\":78,\"81\":81,\"82\":82}],71:[function(_dereq_,module,exports){\n// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])\n        var anObject = _dereq_(7);\n        var dPs = _dereq_(73);\n        var enumBugKeys = _dereq_(31);\n        var IE_PROTO = _dereq_(102)('IE_PROTO');\n        var Empty = function () { /* empty */ };\n        var PROTOTYPE = 'prototype';\n\n// Create object with fake `null` prototype: use iframe Object with cleared prototype\n        var createDict = function () {\n            // Thrash, waste and sodomy: IE GC bug\n            var iframe = _dereq_(30)('iframe');\n            var i = enumBugKeys.length;\n            var lt = '<';\n            var gt = '>';\n            var iframeDocument;\n            iframe.style.display = 'none';\n            _dereq_(43).appendChild(iframe);\n            iframe.src = 'javascript:'; // eslint-disable-line no-script-url\n            // createDict = iframe.contentWindow.Object;\n            // html.removeChild(iframe);\n            iframeDocument = iframe.contentWindow.document;\n            iframeDocument.open();\n            iframeDocument.write(lt + 'script' + gt + 'document.F=Object' + lt + '/script' + gt);\n            iframeDocument.close();\n            createDict = iframeDocument.F;\n            while (i--) delete createDict[PROTOTYPE][enumBugKeys[i]];\n            return createDict();\n        };\n\n        module.exports = Object.create || function create(O, Properties) {\n            var result;\n            if (O !== null) {\n                Empty[PROTOTYPE] = anObject(O);\n                result = new Empty();\n                Empty[PROTOTYPE] = null;\n                // add \"__proto__\" for Object.getPrototypeOf polyfill\n                result[IE_PROTO] = O;\n            } else result = createDict();\n            return Properties === undefined ? result : dPs(result, Properties);\n        };\n\n    },{\"102\":102,\"30\":30,\"31\":31,\"43\":43,\"7\":7,\"73\":73}],72:[function(_dereq_,module,exports){\n        var anObject = _dereq_(7);\n        var IE8_DOM_DEFINE = _dereq_(44);\n        var toPrimitive = _dereq_(120);\n        var dP = Object.defineProperty;\n\n        exports.f = _dereq_(29) ? Object.defineProperty : function defineProperty(O, P, Attributes) {\n            anObject(O);\n            P = toPrimitive(P, true);\n            anObject(Attributes);\n            if (IE8_DOM_DEFINE) try {\n                return dP(O, P, Attributes);\n            } catch (e) { /* empty */ }\n            if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported!');\n            if ('value' in Attributes) O[P] = Attributes.value;\n            return O;\n        };\n\n    },{\"120\":120,\"29\":29,\"44\":44,\"7\":7}],73:[function(_dereq_,module,exports){\n        var dP = _dereq_(72);\n        var anObject = _dereq_(7);\n        var getKeys = _dereq_(81);\n\n        module.exports = _dereq_(29) ? Object.defineProperties : function defineProperties(O, Properties) {\n            anObject(O);\n            var keys = getKeys(Properties);\n            var length = keys.length;\n            var i = 0;\n            var P;\n            while (length > i) dP.f(O, P = keys[i++], Properties[P]);\n            return O;\n        };\n\n    },{\"29\":29,\"7\":7,\"72\":72,\"81\":81}],74:[function(_dereq_,module,exports){\n        'use strict';\n// Forced replacement prototype accessors methods\n        module.exports = _dereq_(60) || !_dereq_(35)(function () {\n            var K = Math.random();\n            // In FF throws only define methods\n            // eslint-disable-next-line no-undef, no-useless-call\n            __defineSetter__.call(null, K, function () { /* empty */ });\n            delete _dereq_(40)[K];\n        });\n\n    },{\"35\":35,\"40\":40,\"60\":60}],75:[function(_dereq_,module,exports){\n        var pIE = _dereq_(82);\n        var createDesc = _dereq_(92);\n        var toIObject = _dereq_(117);\n        var toPrimitive = _dereq_(120);\n        var has = _dereq_(41);\n        var IE8_DOM_DEFINE = _dereq_(44);\n        var gOPD = Object.getOwnPropertyDescriptor;\n\n        exports.f = _dereq_(29) ? gOPD : function getOwnPropertyDescriptor(O, P) {\n            O = toIObject(O);\n            P = toPrimitive(P, true);\n            if (IE8_DOM_DEFINE) try {\n                return gOPD(O, P);\n            } catch (e) { /* empty */ }\n            if (has(O, P)) return createDesc(!pIE.f.call(O, P), O[P]);\n        };\n\n    },{\"117\":117,\"120\":120,\"29\":29,\"41\":41,\"44\":44,\"82\":82,\"92\":92}],76:[function(_dereq_,module,exports){\n// fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window\n        var toIObject = _dereq_(117);\n        var gOPN = _dereq_(77).f;\n        var toString = {}.toString;\n\n        var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames\n            ? Object.getOwnPropertyNames(window) : [];\n\n        var getWindowNames = function (it) {\n            try {\n                return gOPN(it);\n            } catch (e) {\n                return windowNames.slice();\n            }\n        };\n\n        module.exports.f = function getOwnPropertyNames(it) {\n            return windowNames && toString.call(it) == '[object Window]' ? getWindowNames(it) : gOPN(toIObject(it));\n        };\n\n    },{\"117\":117,\"77\":77}],77:[function(_dereq_,module,exports){\n// 19.1.2.7 / 15.2.3.4 Object.getOwnPropertyNames(O)\n        var $keys = _dereq_(80);\n        var hiddenKeys = _dereq_(31).concat('length', 'prototype');\n\n        exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {\n            return $keys(O, hiddenKeys);\n        };\n\n    },{\"31\":31,\"80\":80}],78:[function(_dereq_,module,exports){\n        exports.f = Object.getOwnPropertySymbols;\n\n    },{}],79:[function(_dereq_,module,exports){\n// 19.1.2.9 / 15.2.3.2 Object.getPrototypeOf(O)\n        var has = _dereq_(41);\n        var toObject = _dereq_(119);\n        var IE_PROTO = _dereq_(102)('IE_PROTO');\n        var ObjectProto = Object.prototype;\n\n        module.exports = Object.getPrototypeOf || function (O) {\n            O = toObject(O);\n            if (has(O, IE_PROTO)) return O[IE_PROTO];\n            if (typeof O.constructor == 'function' && O instanceof O.constructor) {\n                return O.constructor.prototype;\n            } return O instanceof Object ? ObjectProto : null;\n        };\n\n    },{\"102\":102,\"119\":119,\"41\":41}],80:[function(_dereq_,module,exports){\n        var has = _dereq_(41);\n        var toIObject = _dereq_(117);\n        var arrayIndexOf = _dereq_(11)(false);\n        var IE_PROTO = _dereq_(102)('IE_PROTO');\n\n        module.exports = function (object, names) {\n            var O = toIObject(object);\n            var i = 0;\n            var result = [];\n            var key;\n            for (key in O) if (key != IE_PROTO) has(O, key) && result.push(key);\n            // Don't enum bug & hidden keys\n            while (names.length > i) if (has(O, key = names[i++])) {\n                ~arrayIndexOf(result, key) || result.push(key);\n            }\n            return result;\n        };\n\n    },{\"102\":102,\"11\":11,\"117\":117,\"41\":41}],81:[function(_dereq_,module,exports){\n// 19.1.2.14 / 15.2.3.14 Object.keys(O)\n        var $keys = _dereq_(80);\n        var enumBugKeys = _dereq_(31);\n\n        module.exports = Object.keys || function keys(O) {\n            return $keys(O, enumBugKeys);\n        };\n\n    },{\"31\":31,\"80\":80}],82:[function(_dereq_,module,exports){\n        exports.f = {}.propertyIsEnumerable;\n\n    },{}],83:[function(_dereq_,module,exports){\n// most Object methods by ES6 should accept primitives\n        var $export = _dereq_(33);\n        var core = _dereq_(23);\n        var fails = _dereq_(35);\n        module.exports = function (KEY, exec) {\n            var fn = (core.Object || {})[KEY] || Object[KEY];\n            var exp = {};\n            exp[KEY] = exec(fn);\n            $export($export.S + $export.F * fails(function () { fn(1); }), 'Object', exp);\n        };\n\n    },{\"23\":23,\"33\":33,\"35\":35}],84:[function(_dereq_,module,exports){\n        var getKeys = _dereq_(81);\n        var toIObject = _dereq_(117);\n        var isEnum = _dereq_(82).f;\n        module.exports = function (isEntries) {\n            return function (it) {\n                var O = toIObject(it);\n                var keys = getKeys(O);\n                var length = keys.length;\n                var i = 0;\n                var result = [];\n                var key;\n                while (length > i) if (isEnum.call(O, key = keys[i++])) {\n                    result.push(isEntries ? [key, O[key]] : O[key]);\n                } return result;\n            };\n        };\n\n    },{\"117\":117,\"81\":81,\"82\":82}],85:[function(_dereq_,module,exports){\n// all object keys, includes non-enumerable and symbols\n        var gOPN = _dereq_(77);\n        var gOPS = _dereq_(78);\n        var anObject = _dereq_(7);\n        var Reflect = _dereq_(40).Reflect;\n        module.exports = Reflect && Reflect.ownKeys || function ownKeys(it) {\n            var keys = gOPN.f(anObject(it));\n            var getSymbols = gOPS.f;\n            return getSymbols ? keys.concat(getSymbols(it)) : keys;\n        };\n\n    },{\"40\":40,\"7\":7,\"77\":77,\"78\":78}],86:[function(_dereq_,module,exports){\n        var $parseFloat = _dereq_(40).parseFloat;\n        var $trim = _dereq_(111).trim;\n\n        module.exports = 1 / $parseFloat(_dereq_(112) + '-0') !== -Infinity ? function parseFloat(str) {\n            var string = $trim(String(str), 3);\n            var result = $parseFloat(string);\n            return result === 0 && string.charAt(0) == '-' ? -0 : result;\n        } : $parseFloat;\n\n    },{\"111\":111,\"112\":112,\"40\":40}],87:[function(_dereq_,module,exports){\n        var $parseInt = _dereq_(40).parseInt;\n        var $trim = _dereq_(111).trim;\n        var ws = _dereq_(112);\n        var hex = /^[-+]?0[xX]/;\n\n        module.exports = $parseInt(ws + '08') !== 8 || $parseInt(ws + '0x16') !== 22 ? function parseInt(str, radix) {\n            var string = $trim(String(str), 3);\n            return $parseInt(string, (radix >>> 0) || (hex.test(string) ? 16 : 10));\n        } : $parseInt;\n\n    },{\"111\":111,\"112\":112,\"40\":40}],88:[function(_dereq_,module,exports){\n        'use strict';\n        var path = _dereq_(89);\n        var invoke = _dereq_(46);\n        var aFunction = _dereq_(3);\n        module.exports = function (/* ...pargs */) {\n            var fn = aFunction(this);\n            var length = arguments.length;\n            var pargs = Array(length);\n            var i = 0;\n            var _ = path._;\n            var holder = false;\n            while (length > i) if ((pargs[i] = arguments[i++]) === _) holder = true;\n            return function (/* ...args */) {\n                var that = this;\n                var aLen = arguments.length;\n                var j = 0;\n                var k = 0;\n                var args;\n                if (!holder && !aLen) return invoke(fn, pargs, that);\n                args = pargs.slice();\n                if (holder) for (;length > j; j++) if (args[j] === _) args[j] = arguments[k++];\n                while (aLen > k) args.push(arguments[k++]);\n                return invoke(fn, args, that);\n            };\n        };\n\n    },{\"3\":3,\"46\":46,\"89\":89}],89:[function(_dereq_,module,exports){\n        module.exports = _dereq_(40);\n\n    },{\"40\":40}],90:[function(_dereq_,module,exports){\n        module.exports = function (exec) {\n            try {\n                return { e: false, v: exec() };\n            } catch (e) {\n                return { e: true, v: e };\n            }\n        };\n\n    },{}],91:[function(_dereq_,module,exports){\n        var newPromiseCapability = _dereq_(69);\n\n        module.exports = function (C, x) {\n            var promiseCapability = newPromiseCapability.f(C);\n            var resolve = promiseCapability.resolve;\n            resolve(x);\n            return promiseCapability.promise;\n        };\n\n    },{\"69\":69}],92:[function(_dereq_,module,exports){\n        module.exports = function (bitmap, value) {\n            return {\n                enumerable: !(bitmap & 1),\n                configurable: !(bitmap & 2),\n                writable: !(bitmap & 4),\n                value: value\n            };\n        };\n\n    },{}],93:[function(_dereq_,module,exports){\n        var redefine = _dereq_(94);\n        module.exports = function (target, src, safe) {\n            for (var key in src) redefine(target, key, src[key], safe);\n            return target;\n        };\n\n    },{\"94\":94}],94:[function(_dereq_,module,exports){\n        var global = _dereq_(40);\n        var hide = _dereq_(42);\n        var has = _dereq_(41);\n        var SRC = _dereq_(124)('src');\n        var TO_STRING = 'toString';\n        var $toString = Function[TO_STRING];\n        var TPL = ('' + $toString).split(TO_STRING);\n\n        _dereq_(23).inspectSource = function (it) {\n            return $toString.call(it);\n        };\n\n        (module.exports = function (O, key, val, safe) {\n            var isFunction = typeof val == 'function';\n            if (isFunction) has(val, 'name') || hide(val, 'name', key);\n            if (O[key] === val) return;\n            if (isFunction) has(val, SRC) || hide(val, SRC, O[key] ? '' + O[key] : TPL.join(String(key)));\n            if (O === global) {\n                O[key] = val;\n            } else if (!safe) {\n                delete O[key];\n                hide(O, key, val);\n            } else if (O[key]) {\n                O[key] = val;\n            } else {\n                hide(O, key, val);\n            }\n// add fake Function#toString for correct work wrapped methods / constructors with methods like LoDash isNative\n        })(Function.prototype, TO_STRING, function toString() {\n            return typeof this == 'function' && this[SRC] || $toString.call(this);\n        });\n\n    },{\"124\":124,\"23\":23,\"40\":40,\"41\":41,\"42\":42}],95:[function(_dereq_,module,exports){\n        module.exports = function (regExp, replace) {\n            var replacer = replace === Object(replace) ? function (part) {\n                return replace[part];\n            } : replace;\n            return function (it) {\n                return String(it).replace(regExp, replacer);\n            };\n        };\n\n    },{}],96:[function(_dereq_,module,exports){\n// 7.2.9 SameValue(x, y)\n        module.exports = Object.is || function is(x, y) {\n            // eslint-disable-next-line no-self-compare\n            return x === y ? x !== 0 || 1 / x === 1 / y : x != x && y != y;\n        };\n\n    },{}],97:[function(_dereq_,module,exports){\n        'use strict';\n// https://tc39.github.io/proposal-setmap-offrom/\n        var $export = _dereq_(33);\n        var aFunction = _dereq_(3);\n        var ctx = _dereq_(25);\n        var forOf = _dereq_(39);\n\n        module.exports = function (COLLECTION) {\n            $export($export.S, COLLECTION, { from: function from(source /* , mapFn, thisArg */) {\n                    var mapFn = arguments[1];\n                    var mapping, A, n, cb;\n                    aFunction(this);\n                    mapping = mapFn !== undefined;\n                    if (mapping) aFunction(mapFn);\n                    if (source == undefined) return new this();\n                    A = [];\n                    if (mapping) {\n                        n = 0;\n                        cb = ctx(mapFn, arguments[2], 2);\n                        forOf(source, false, function (nextItem) {\n                            A.push(cb(nextItem, n++));\n                        });\n                    } else {\n                        forOf(source, false, A.push, A);\n                    }\n                    return new this(A);\n                } });\n        };\n\n    },{\"25\":25,\"3\":3,\"33\":33,\"39\":39}],98:[function(_dereq_,module,exports){\n        'use strict';\n// https://tc39.github.io/proposal-setmap-offrom/\n        var $export = _dereq_(33);\n\n        module.exports = function (COLLECTION) {\n            $export($export.S, COLLECTION, { of: function of() {\n                    var length = arguments.length;\n                    var A = Array(length);\n                    while (length--) A[length] = arguments[length];\n                    return new this(A);\n                } });\n        };\n\n    },{\"33\":33}],99:[function(_dereq_,module,exports){\n// Works with __proto__ only. Old v8 can't work with null proto objects.\n        /* eslint-disable no-proto */\n        var isObject = _dereq_(51);\n        var anObject = _dereq_(7);\n        var check = function (O, proto) {\n            anObject(O);\n            if (!isObject(proto) && proto !== null) throw TypeError(proto + \": can't set as prototype!\");\n        };\n        module.exports = {\n            set: Object.setPrototypeOf || ('__proto__' in {} ? // eslint-disable-line\n                function (test, buggy, set) {\n                    try {\n                        set = _dereq_(25)(Function.call, _dereq_(75).f(Object.prototype, '__proto__').set, 2);\n                        set(test, []);\n                        buggy = !(test instanceof Array);\n                    } catch (e) { buggy = true; }\n                    return function setPrototypeOf(O, proto) {\n                        check(O, proto);\n                        if (buggy) O.__proto__ = proto;\n                        else set(O, proto);\n                        return O;\n                    };\n                }({}, false) : undefined),\n            check: check\n        };\n\n    },{\"25\":25,\"51\":51,\"7\":7,\"75\":75}],100:[function(_dereq_,module,exports){\n        'use strict';\n        var global = _dereq_(40);\n        var dP = _dereq_(72);\n        var DESCRIPTORS = _dereq_(29);\n        var SPECIES = _dereq_(128)('species');\n\n        module.exports = function (KEY) {\n            var C = global[KEY];\n            if (DESCRIPTORS && C && !C[SPECIES]) dP.f(C, SPECIES, {\n                configurable: true,\n                get: function () { return this; }\n            });\n        };\n\n    },{\"128\":128,\"29\":29,\"40\":40,\"72\":72}],101:[function(_dereq_,module,exports){\n        var def = _dereq_(72).f;\n        var has = _dereq_(41);\n        var TAG = _dereq_(128)('toStringTag');\n\n        module.exports = function (it, tag, stat) {\n            if (it && !has(it = stat ? it : it.prototype, TAG)) def(it, TAG, { configurable: true, value: tag });\n        };\n\n    },{\"128\":128,\"41\":41,\"72\":72}],102:[function(_dereq_,module,exports){\n        var shared = _dereq_(103)('keys');\n        var uid = _dereq_(124);\n        module.exports = function (key) {\n            return shared[key] || (shared[key] = uid(key));\n        };\n\n    },{\"103\":103,\"124\":124}],103:[function(_dereq_,module,exports){\n        var global = _dereq_(40);\n        var SHARED = '__core-js_shared__';\n        var store = global[SHARED] || (global[SHARED] = {});\n        module.exports = function (key) {\n            return store[key] || (store[key] = {});\n        };\n\n    },{\"40\":40}],104:[function(_dereq_,module,exports){\n// 7.3.20 SpeciesConstructor(O, defaultConstructor)\n        var anObject = _dereq_(7);\n        var aFunction = _dereq_(3);\n        var SPECIES = _dereq_(128)('species');\n        module.exports = function (O, D) {\n            var C = anObject(O).constructor;\n            var S;\n            return C === undefined || (S = anObject(C)[SPECIES]) == undefined ? D : aFunction(S);\n        };\n\n    },{\"128\":128,\"3\":3,\"7\":7}],105:[function(_dereq_,module,exports){\n        'use strict';\n        var fails = _dereq_(35);\n\n        module.exports = function (method, arg) {\n            return !!method && fails(function () {\n                // eslint-disable-next-line no-useless-call\n                arg ? method.call(null, function () { /* empty */ }, 1) : method.call(null);\n            });\n        };\n\n    },{\"35\":35}],106:[function(_dereq_,module,exports){\n        var toInteger = _dereq_(116);\n        var defined = _dereq_(28);\n// true  -> String#at\n// false -> String#codePointAt\n        module.exports = function (TO_STRING) {\n            return function (that, pos) {\n                var s = String(defined(that));\n                var i = toInteger(pos);\n                var l = s.length;\n                var a, b;\n                if (i < 0 || i >= l) return TO_STRING ? '' : undefined;\n                a = s.charCodeAt(i);\n                return a < 0xd800 || a > 0xdbff || i + 1 === l || (b = s.charCodeAt(i + 1)) < 0xdc00 || b > 0xdfff\n                    ? TO_STRING ? s.charAt(i) : a\n                    : TO_STRING ? s.slice(i, i + 2) : (a - 0xd800 << 10) + (b - 0xdc00) + 0x10000;\n            };\n        };\n\n    },{\"116\":116,\"28\":28}],107:[function(_dereq_,module,exports){\n// helper for String#{startsWith, endsWith, includes}\n        var isRegExp = _dereq_(52);\n        var defined = _dereq_(28);\n\n        module.exports = function (that, searchString, NAME) {\n            if (isRegExp(searchString)) throw TypeError('String#' + NAME + \" doesn't accept regex!\");\n            return String(defined(that));\n        };\n\n    },{\"28\":28,\"52\":52}],108:[function(_dereq_,module,exports){\n        var $export = _dereq_(33);\n        var fails = _dereq_(35);\n        var defined = _dereq_(28);\n        var quot = /\"/g;\n// B.2.3.2.1 CreateHTML(string, tag, attribute, value)\n        var createHTML = function (string, tag, attribute, value) {\n            var S = String(defined(string));\n            var p1 = '<' + tag;\n            if (attribute !== '') p1 += ' ' + attribute + '=\"' + String(value).replace(quot, '&quot;') + '\"';\n            return p1 + '>' + S + '</' + tag + '>';\n        };\n        module.exports = function (NAME, exec) {\n            var O = {};\n            O[NAME] = exec(createHTML);\n            $export($export.P + $export.F * fails(function () {\n                var test = ''[NAME]('\"');\n                return test !== test.toLowerCase() || test.split('\"').length > 3;\n            }), 'String', O);\n        };\n\n    },{\"28\":28,\"33\":33,\"35\":35}],109:[function(_dereq_,module,exports){\n// https://github.com/tc39/proposal-string-pad-start-end\n        var toLength = _dereq_(118);\n        var repeat = _dereq_(110);\n        var defined = _dereq_(28);\n\n        module.exports = function (that, maxLength, fillString, left) {\n            var S = String(defined(that));\n            var stringLength = S.length;\n            var fillStr = fillString === undefined ? ' ' : String(fillString);\n            var intMaxLength = toLength(maxLength);\n            if (intMaxLength <= stringLength || fillStr == '') return S;\n            var fillLen = intMaxLength - stringLength;\n            var stringFiller = repeat.call(fillStr, Math.ceil(fillLen / fillStr.length));\n            if (stringFiller.length > fillLen) stringFiller = stringFiller.slice(0, fillLen);\n            return left ? stringFiller + S : S + stringFiller;\n        };\n\n    },{\"110\":110,\"118\":118,\"28\":28}],110:[function(_dereq_,module,exports){\n        'use strict';\n        var toInteger = _dereq_(116);\n        var defined = _dereq_(28);\n\n        module.exports = function repeat(count) {\n            var str = String(defined(this));\n            var res = '';\n            var n = toInteger(count);\n            if (n < 0 || n == Infinity) throw RangeError(\"Count can't be negative\");\n            for (;n > 0; (n >>>= 1) && (str += str)) if (n & 1) res += str;\n            return res;\n        };\n\n    },{\"116\":116,\"28\":28}],111:[function(_dereq_,module,exports){\n        var $export = _dereq_(33);\n        var defined = _dereq_(28);\n        var fails = _dereq_(35);\n        var spaces = _dereq_(112);\n        var space = '[' + spaces + ']';\n        var non = '\\u200b\\u0085';\n        var ltrim = RegExp('^' + space + space + '*');\n        var rtrim = RegExp(space + space + '*$');\n\n        var exporter = function (KEY, exec, ALIAS) {\n            var exp = {};\n            var FORCE = fails(function () {\n                return !!spaces[KEY]() || non[KEY]() != non;\n            });\n            var fn = exp[KEY] = FORCE ? exec(trim) : spaces[KEY];\n            if (ALIAS) exp[ALIAS] = fn;\n            $export($export.P + $export.F * FORCE, 'String', exp);\n        };\n\n// 1 -> String#trimLeft\n// 2 -> String#trimRight\n// 3 -> String#trim\n        var trim = exporter.trim = function (string, TYPE) {\n            string = String(defined(string));\n            if (TYPE & 1) string = string.replace(ltrim, '');\n            if (TYPE & 2) string = string.replace(rtrim, '');\n            return string;\n        };\n\n        module.exports = exporter;\n\n    },{\"112\":112,\"28\":28,\"33\":33,\"35\":35}],112:[function(_dereq_,module,exports){\n        module.exports = '\\x09\\x0A\\x0B\\x0C\\x0D\\x20\\xA0\\u1680\\u180E\\u2000\\u2001\\u2002\\u2003' +\n            '\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u202F\\u205F\\u3000\\u2028\\u2029\\uFEFF';\n\n    },{}],113:[function(_dereq_,module,exports){\n        var ctx = _dereq_(25);\n        var invoke = _dereq_(46);\n        var html = _dereq_(43);\n        var cel = _dereq_(30);\n        var global = _dereq_(40);\n        var process = global.process;\n        var setTask = global.setImmediate;\n        var clearTask = global.clearImmediate;\n        var MessageChannel = global.MessageChannel;\n        var Dispatch = global.Dispatch;\n        var counter = 0;\n        var queue = {};\n        var ONREADYSTATECHANGE = 'onreadystatechange';\n        var defer, channel, port;\n        var run = function () {\n            var id = +this;\n            // eslint-disable-next-line no-prototype-builtins\n            if (queue.hasOwnProperty(id)) {\n                var fn = queue[id];\n                delete queue[id];\n                fn();\n            }\n        };\n        var listener = function (event) {\n            run.call(event.data);\n        };\n// Node.js 0.9+ & IE10+ has setImmediate, otherwise:\n        if (!setTask || !clearTask) {\n            setTask = function setImmediate(fn) {\n                var args = [];\n                var i = 1;\n                while (arguments.length > i) args.push(arguments[i++]);\n                queue[++counter] = function () {\n                    // eslint-disable-next-line no-new-func\n                    invoke(typeof fn == 'function' ? fn : Function(fn), args);\n                };\n                defer(counter);\n                return counter;\n            };\n            clearTask = function clearImmediate(id) {\n                delete queue[id];\n            };\n            // Node.js 0.8-\n            if (_dereq_(18)(process) == 'process') {\n                defer = function (id) {\n                    process.nextTick(ctx(run, id, 1));\n                };\n                // Sphere (JS game engine) Dispatch API\n            } else if (Dispatch && Dispatch.now) {\n                defer = function (id) {\n                    Dispatch.now(ctx(run, id, 1));\n                };\n                // Browsers with MessageChannel, includes WebWorkers\n            } else if (MessageChannel) {\n                channel = new MessageChannel();\n                port = channel.port2;\n                channel.port1.onmessage = listener;\n                defer = ctx(port.postMessage, port, 1);\n                // Browsers with postMessage, skip WebWorkers\n                // IE8 has postMessage, but it's sync & typeof its postMessage is 'object'\n            } else if (global.addEventListener && typeof postMessage == 'function' && !global.importScripts) {\n                defer = function (id) {\n                    global.postMessage(id + '', '*');\n                };\n                global.addEventListener('message', listener, false);\n                // IE8-\n            } else if (ONREADYSTATECHANGE in cel('script')) {\n                defer = function (id) {\n                    html.appendChild(cel('script'))[ONREADYSTATECHANGE] = function () {\n                        html.removeChild(this);\n                        run.call(id);\n                    };\n                };\n                // Rest old browsers\n            } else {\n                defer = function (id) {\n                    setTimeout(ctx(run, id, 1), 0);\n                };\n            }\n        }\n        module.exports = {\n            set: setTask,\n            clear: clearTask\n        };\n\n    },{\"18\":18,\"25\":25,\"30\":30,\"40\":40,\"43\":43,\"46\":46}],114:[function(_dereq_,module,exports){\n        var toInteger = _dereq_(116);\n        var max = Math.max;\n        var min = Math.min;\n        module.exports = function (index, length) {\n            index = toInteger(index);\n            return index < 0 ? max(index + length, 0) : min(index, length);\n        };\n\n    },{\"116\":116}],115:[function(_dereq_,module,exports){\n// https://tc39.github.io/ecma262/#sec-toindex\n        var toInteger = _dereq_(116);\n        var toLength = _dereq_(118);\n        module.exports = function (it) {\n            if (it === undefined) return 0;\n            var number = toInteger(it);\n            var length = toLength(number);\n            if (number !== length) throw RangeError('Wrong length!');\n            return length;\n        };\n\n    },{\"116\":116,\"118\":118}],116:[function(_dereq_,module,exports){\n// 7.1.4 ToInteger\n        var ceil = Math.ceil;\n        var floor = Math.floor;\n        module.exports = function (it) {\n            return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);\n        };\n\n    },{}],117:[function(_dereq_,module,exports){\n// to indexed object, toObject with fallback for non-array-like ES3 strings\n        var IObject = _dereq_(47);\n        var defined = _dereq_(28);\n        module.exports = function (it) {\n            return IObject(defined(it));\n        };\n\n    },{\"28\":28,\"47\":47}],118:[function(_dereq_,module,exports){\n// 7.1.15 ToLength\n        var toInteger = _dereq_(116);\n        var min = Math.min;\n        module.exports = function (it) {\n            return it > 0 ? min(toInteger(it), 0x1fffffffffffff) : 0; // pow(2, 53) - 1 == 9007199254740991\n        };\n\n    },{\"116\":116}],119:[function(_dereq_,module,exports){\n// 7.1.13 ToObject(argument)\n        var defined = _dereq_(28);\n        module.exports = function (it) {\n            return Object(defined(it));\n        };\n\n    },{\"28\":28}],120:[function(_dereq_,module,exports){\n// 7.1.1 ToPrimitive(input [, PreferredType])\n        var isObject = _dereq_(51);\n// instead of the ES6 spec version, we didn't implement @@toPrimitive case\n// and the second argument - flag - preferred type is a string\n        module.exports = function (it, S) {\n            if (!isObject(it)) return it;\n            var fn, val;\n            if (S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;\n            if (typeof (fn = it.valueOf) == 'function' && !isObject(val = fn.call(it))) return val;\n            if (!S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;\n            throw TypeError(\"Can't convert object to primitive value\");\n        };\n\n    },{\"51\":51}],121:[function(_dereq_,module,exports){\n        'use strict';\n        if (_dereq_(29)) {\n            var LIBRARY = _dereq_(60);\n            var global = _dereq_(40);\n            var fails = _dereq_(35);\n            var $export = _dereq_(33);\n            var $typed = _dereq_(123);\n            var $buffer = _dereq_(122);\n            var ctx = _dereq_(25);\n            var anInstance = _dereq_(6);\n            var propertyDesc = _dereq_(92);\n            var hide = _dereq_(42);\n            var redefineAll = _dereq_(93);\n            var toInteger = _dereq_(116);\n            var toLength = _dereq_(118);\n            var toIndex = _dereq_(115);\n            var toAbsoluteIndex = _dereq_(114);\n            var toPrimitive = _dereq_(120);\n            var has = _dereq_(41);\n            var classof = _dereq_(17);\n            var isObject = _dereq_(51);\n            var toObject = _dereq_(119);\n            var isArrayIter = _dereq_(48);\n            var create = _dereq_(71);\n            var getPrototypeOf = _dereq_(79);\n            var gOPN = _dereq_(77).f;\n            var getIterFn = _dereq_(129);\n            var uid = _dereq_(124);\n            var wks = _dereq_(128);\n            var createArrayMethod = _dereq_(12);\n            var createArrayIncludes = _dereq_(11);\n            var speciesConstructor = _dereq_(104);\n            var ArrayIterators = _dereq_(141);\n            var Iterators = _dereq_(58);\n            var $iterDetect = _dereq_(56);\n            var setSpecies = _dereq_(100);\n            var arrayFill = _dereq_(9);\n            var arrayCopyWithin = _dereq_(8);\n            var $DP = _dereq_(72);\n            var $GOPD = _dereq_(75);\n            var dP = $DP.f;\n            var gOPD = $GOPD.f;\n            var RangeError = global.RangeError;\n            var TypeError = global.TypeError;\n            var Uint8Array = global.Uint8Array;\n            var ARRAY_BUFFER = 'ArrayBuffer';\n            var SHARED_BUFFER = 'Shared' + ARRAY_BUFFER;\n            var BYTES_PER_ELEMENT = 'BYTES_PER_ELEMENT';\n            var PROTOTYPE = 'prototype';\n            var ArrayProto = Array[PROTOTYPE];\n            var $ArrayBuffer = $buffer.ArrayBuffer;\n            var $DataView = $buffer.DataView;\n            var arrayForEach = createArrayMethod(0);\n            var arrayFilter = createArrayMethod(2);\n            var arraySome = createArrayMethod(3);\n            var arrayEvery = createArrayMethod(4);\n            var arrayFind = createArrayMethod(5);\n            var arrayFindIndex = createArrayMethod(6);\n            var arrayIncludes = createArrayIncludes(true);\n            var arrayIndexOf = createArrayIncludes(false);\n            var arrayValues = ArrayIterators.values;\n            var arrayKeys = ArrayIterators.keys;\n            var arrayEntries = ArrayIterators.entries;\n            var arrayLastIndexOf = ArrayProto.lastIndexOf;\n            var arrayReduce = ArrayProto.reduce;\n            var arrayReduceRight = ArrayProto.reduceRight;\n            var arrayJoin = ArrayProto.join;\n            var arraySort = ArrayProto.sort;\n            var arraySlice = ArrayProto.slice;\n            var arrayToString = ArrayProto.toString;\n            var arrayToLocaleString = ArrayProto.toLocaleString;\n            var ITERATOR = wks('iterator');\n            var TAG = wks('toStringTag');\n            var TYPED_CONSTRUCTOR = uid('typed_constructor');\n            var DEF_CONSTRUCTOR = uid('def_constructor');\n            var ALL_CONSTRUCTORS = $typed.CONSTR;\n            var TYPED_ARRAY = $typed.TYPED;\n            var VIEW = $typed.VIEW;\n            var WRONG_LENGTH = 'Wrong length!';\n\n            var $map = createArrayMethod(1, function (O, length) {\n                return allocate(speciesConstructor(O, O[DEF_CONSTRUCTOR]), length);\n            });\n\n            var LITTLE_ENDIAN = fails(function () {\n                // eslint-disable-next-line no-undef\n                return new Uint8Array(new Uint16Array([1]).buffer)[0] === 1;\n            });\n\n            var FORCED_SET = !!Uint8Array && !!Uint8Array[PROTOTYPE].set && fails(function () {\n                new Uint8Array(1).set({});\n            });\n\n            var toOffset = function (it, BYTES) {\n                var offset = toInteger(it);\n                if (offset < 0 || offset % BYTES) throw RangeError('Wrong offset!');\n                return offset;\n            };\n\n            var validate = function (it) {\n                if (isObject(it) && TYPED_ARRAY in it) return it;\n                throw TypeError(it + ' is not a typed array!');\n            };\n\n            var allocate = function (C, length) {\n                if (!(isObject(C) && TYPED_CONSTRUCTOR in C)) {\n                    throw TypeError('It is not a typed array constructor!');\n                } return new C(length);\n            };\n\n            var speciesFromList = function (O, list) {\n                return fromList(speciesConstructor(O, O[DEF_CONSTRUCTOR]), list);\n            };\n\n            var fromList = function (C, list) {\n                var index = 0;\n                var length = list.length;\n                var result = allocate(C, length);\n                while (length > index) result[index] = list[index++];\n                return result;\n            };\n\n            var addGetter = function (it, key, internal) {\n                dP(it, key, { get: function () { return this._d[internal]; } });\n            };\n\n            var $from = function from(source /* , mapfn, thisArg */) {\n                var O = toObject(source);\n                var aLen = arguments.length;\n                var mapfn = aLen > 1 ? arguments[1] : undefined;\n                var mapping = mapfn !== undefined;\n                var iterFn = getIterFn(O);\n                var i, length, values, result, step, iterator;\n                if (iterFn != undefined && !isArrayIter(iterFn)) {\n                    for (iterator = iterFn.call(O), values = [], i = 0; !(step = iterator.next()).done; i++) {\n                        values.push(step.value);\n                    } O = values;\n                }\n                if (mapping && aLen > 2) mapfn = ctx(mapfn, arguments[2], 2);\n                for (i = 0, length = toLength(O.length), result = allocate(this, length); length > i; i++) {\n                    result[i] = mapping ? mapfn(O[i], i) : O[i];\n                }\n                return result;\n            };\n\n            var $of = function of(/* ...items */) {\n                var index = 0;\n                var length = arguments.length;\n                var result = allocate(this, length);\n                while (length > index) result[index] = arguments[index++];\n                return result;\n            };\n\n            // iOS Safari 6.x fails here\n            var TO_LOCALE_BUG = !!Uint8Array && fails(function () { arrayToLocaleString.call(new Uint8Array(1)); });\n\n            var $toLocaleString = function toLocaleString() {\n                return arrayToLocaleString.apply(TO_LOCALE_BUG ? arraySlice.call(validate(this)) : validate(this), arguments);\n            };\n\n            var proto = {\n                copyWithin: function copyWithin(target, start /* , end */) {\n                    return arrayCopyWithin.call(validate(this), target, start, arguments.length > 2 ? arguments[2] : undefined);\n                },\n                every: function every(callbackfn /* , thisArg */) {\n                    return arrayEvery(validate(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);\n                },\n                fill: function fill(value /* , start, end */) { // eslint-disable-line no-unused-vars\n                    return arrayFill.apply(validate(this), arguments);\n                },\n                filter: function filter(callbackfn /* , thisArg */) {\n                    return speciesFromList(this, arrayFilter(validate(this), callbackfn,\n                        arguments.length > 1 ? arguments[1] : undefined));\n                },\n                find: function find(predicate /* , thisArg */) {\n                    return arrayFind(validate(this), predicate, arguments.length > 1 ? arguments[1] : undefined);\n                },\n                findIndex: function findIndex(predicate /* , thisArg */) {\n                    return arrayFindIndex(validate(this), predicate, arguments.length > 1 ? arguments[1] : undefined);\n                },\n                forEach: function forEach(callbackfn /* , thisArg */) {\n                    arrayForEach(validate(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);\n                },\n                indexOf: function indexOf(searchElement /* , fromIndex */) {\n                    return arrayIndexOf(validate(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);\n                },\n                includes: function includes(searchElement /* , fromIndex */) {\n                    return arrayIncludes(validate(this), searchElement, arguments.length > 1 ? arguments[1] : undefined);\n                },\n                join: function join(separator) { // eslint-disable-line no-unused-vars\n                    return arrayJoin.apply(validate(this), arguments);\n                },\n                lastIndexOf: function lastIndexOf(searchElement /* , fromIndex */) { // eslint-disable-line no-unused-vars\n                    return arrayLastIndexOf.apply(validate(this), arguments);\n                },\n                map: function map(mapfn /* , thisArg */) {\n                    return $map(validate(this), mapfn, arguments.length > 1 ? arguments[1] : undefined);\n                },\n                reduce: function reduce(callbackfn /* , initialValue */) { // eslint-disable-line no-unused-vars\n                    return arrayReduce.apply(validate(this), arguments);\n                },\n                reduceRight: function reduceRight(callbackfn /* , initialValue */) { // eslint-disable-line no-unused-vars\n                    return arrayReduceRight.apply(validate(this), arguments);\n                },\n                reverse: function reverse() {\n                    var that = this;\n                    var length = validate(that).length;\n                    var middle = Math.floor(length / 2);\n                    var index = 0;\n                    var value;\n                    while (index < middle) {\n                        value = that[index];\n                        that[index++] = that[--length];\n                        that[length] = value;\n                    } return that;\n                },\n                some: function some(callbackfn /* , thisArg */) {\n                    return arraySome(validate(this), callbackfn, arguments.length > 1 ? arguments[1] : undefined);\n                },\n                sort: function sort(comparefn) {\n                    return arraySort.call(validate(this), comparefn);\n                },\n                subarray: function subarray(begin, end) {\n                    var O = validate(this);\n                    var length = O.length;\n                    var $begin = toAbsoluteIndex(begin, length);\n                    return new (speciesConstructor(O, O[DEF_CONSTRUCTOR]))(\n                        O.buffer,\n                        O.byteOffset + $begin * O.BYTES_PER_ELEMENT,\n                        toLength((end === undefined ? length : toAbsoluteIndex(end, length)) - $begin)\n                    );\n                }\n            };\n\n            var $slice = function slice(start, end) {\n                return speciesFromList(this, arraySlice.call(validate(this), start, end));\n            };\n\n            var $set = function set(arrayLike /* , offset */) {\n                validate(this);\n                var offset = toOffset(arguments[1], 1);\n                var length = this.length;\n                var src = toObject(arrayLike);\n                var len = toLength(src.length);\n                var index = 0;\n                if (len + offset > length) throw RangeError(WRONG_LENGTH);\n                while (index < len) this[offset + index] = src[index++];\n            };\n\n            var $iterators = {\n                entries: function entries() {\n                    return arrayEntries.call(validate(this));\n                },\n                keys: function keys() {\n                    return arrayKeys.call(validate(this));\n                },\n                values: function values() {\n                    return arrayValues.call(validate(this));\n                }\n            };\n\n            var isTAIndex = function (target, key) {\n                return isObject(target)\n                    && target[TYPED_ARRAY]\n                    && typeof key != 'symbol'\n                    && key in target\n                    && String(+key) == String(key);\n            };\n            var $getDesc = function getOwnPropertyDescriptor(target, key) {\n                return isTAIndex(target, key = toPrimitive(key, true))\n                    ? propertyDesc(2, target[key])\n                    : gOPD(target, key);\n            };\n            var $setDesc = function defineProperty(target, key, desc) {\n                if (isTAIndex(target, key = toPrimitive(key, true))\n                    && isObject(desc)\n                    && has(desc, 'value')\n                    && !has(desc, 'get')\n                    && !has(desc, 'set')\n                    // TODO: add validation descriptor w/o calling accessors\n                    && !desc.configurable\n                    && (!has(desc, 'writable') || desc.writable)\n                    && (!has(desc, 'enumerable') || desc.enumerable)\n                ) {\n                    target[key] = desc.value;\n                    return target;\n                } return dP(target, key, desc);\n            };\n\n            if (!ALL_CONSTRUCTORS) {\n                $GOPD.f = $getDesc;\n                $DP.f = $setDesc;\n            }\n\n            $export($export.S + $export.F * !ALL_CONSTRUCTORS, 'Object', {\n                getOwnPropertyDescriptor: $getDesc,\n                defineProperty: $setDesc\n            });\n\n            if (fails(function () { arrayToString.call({}); })) {\n                arrayToString = arrayToLocaleString = function toString() {\n                    return arrayJoin.call(this);\n                };\n            }\n\n            var $TypedArrayPrototype$ = redefineAll({}, proto);\n            redefineAll($TypedArrayPrototype$, $iterators);\n            hide($TypedArrayPrototype$, ITERATOR, $iterators.values);\n            redefineAll($TypedArrayPrototype$, {\n                slice: $slice,\n                set: $set,\n                constructor: function () { /* noop */ },\n                toString: arrayToString,\n                toLocaleString: $toLocaleString\n            });\n            addGetter($TypedArrayPrototype$, 'buffer', 'b');\n            addGetter($TypedArrayPrototype$, 'byteOffset', 'o');\n            addGetter($TypedArrayPrototype$, 'byteLength', 'l');\n            addGetter($TypedArrayPrototype$, 'length', 'e');\n            dP($TypedArrayPrototype$, TAG, {\n                get: function () { return this[TYPED_ARRAY]; }\n            });\n\n            // eslint-disable-next-line max-statements\n            module.exports = function (KEY, BYTES, wrapper, CLAMPED) {\n                CLAMPED = !!CLAMPED;\n                var NAME = KEY + (CLAMPED ? 'Clamped' : '') + 'Array';\n                var GETTER = 'get' + KEY;\n                var SETTER = 'set' + KEY;\n                var TypedArray = global[NAME];\n                var Base = TypedArray || {};\n                var TAC = TypedArray && getPrototypeOf(TypedArray);\n                var FORCED = !TypedArray || !$typed.ABV;\n                var O = {};\n                var TypedArrayPrototype = TypedArray && TypedArray[PROTOTYPE];\n                var getter = function (that, index) {\n                    var data = that._d;\n                    return data.v[GETTER](index * BYTES + data.o, LITTLE_ENDIAN);\n                };\n                var setter = function (that, index, value) {\n                    var data = that._d;\n                    if (CLAMPED) value = (value = Math.round(value)) < 0 ? 0 : value > 0xff ? 0xff : value & 0xff;\n                    data.v[SETTER](index * BYTES + data.o, value, LITTLE_ENDIAN);\n                };\n                var addElement = function (that, index) {\n                    dP(that, index, {\n                        get: function () {\n                            return getter(this, index);\n                        },\n                        set: function (value) {\n                            return setter(this, index, value);\n                        },\n                        enumerable: true\n                    });\n                };\n                if (FORCED) {\n                    TypedArray = wrapper(function (that, data, $offset, $length) {\n                        anInstance(that, TypedArray, NAME, '_d');\n                        var index = 0;\n                        var offset = 0;\n                        var buffer, byteLength, length, klass;\n                        if (!isObject(data)) {\n                            length = toIndex(data);\n                            byteLength = length * BYTES;\n                            buffer = new $ArrayBuffer(byteLength);\n                        } else if (data instanceof $ArrayBuffer || (klass = classof(data)) == ARRAY_BUFFER || klass == SHARED_BUFFER) {\n                            buffer = data;\n                            offset = toOffset($offset, BYTES);\n                            var $len = data.byteLength;\n                            if ($length === undefined) {\n                                if ($len % BYTES) throw RangeError(WRONG_LENGTH);\n                                byteLength = $len - offset;\n                                if (byteLength < 0) throw RangeError(WRONG_LENGTH);\n                            } else {\n                                byteLength = toLength($length) * BYTES;\n                                if (byteLength + offset > $len) throw RangeError(WRONG_LENGTH);\n                            }\n                            length = byteLength / BYTES;\n                        } else if (TYPED_ARRAY in data) {\n                            return fromList(TypedArray, data);\n                        } else {\n                            return $from.call(TypedArray, data);\n                        }\n                        hide(that, '_d', {\n                            b: buffer,\n                            o: offset,\n                            l: byteLength,\n                            e: length,\n                            v: new $DataView(buffer)\n                        });\n                        while (index < length) addElement(that, index++);\n                    });\n                    TypedArrayPrototype = TypedArray[PROTOTYPE] = create($TypedArrayPrototype$);\n                    hide(TypedArrayPrototype, 'constructor', TypedArray);\n                } else if (!fails(function () {\n                    TypedArray(1);\n                }) || !fails(function () {\n                    new TypedArray(-1); // eslint-disable-line no-new\n                }) || !$iterDetect(function (iter) {\n                    new TypedArray(); // eslint-disable-line no-new\n                    new TypedArray(null); // eslint-disable-line no-new\n                    new TypedArray(1.5); // eslint-disable-line no-new\n                    new TypedArray(iter); // eslint-disable-line no-new\n                }, true)) {\n                    TypedArray = wrapper(function (that, data, $offset, $length) {\n                        anInstance(that, TypedArray, NAME);\n                        var klass;\n                        // `ws` module bug, temporarily remove validation length for Uint8Array\n                        // https://github.com/websockets/ws/pull/645\n                        if (!isObject(data)) return new Base(toIndex(data));\n                        if (data instanceof $ArrayBuffer || (klass = classof(data)) == ARRAY_BUFFER || klass == SHARED_BUFFER) {\n                            return $length !== undefined\n                                ? new Base(data, toOffset($offset, BYTES), $length)\n                                : $offset !== undefined\n                                    ? new Base(data, toOffset($offset, BYTES))\n                                    : new Base(data);\n                        }\n                        if (TYPED_ARRAY in data) return fromList(TypedArray, data);\n                        return $from.call(TypedArray, data);\n                    });\n                    arrayForEach(TAC !== Function.prototype ? gOPN(Base).concat(gOPN(TAC)) : gOPN(Base), function (key) {\n                        if (!(key in TypedArray)) hide(TypedArray, key, Base[key]);\n                    });\n                    TypedArray[PROTOTYPE] = TypedArrayPrototype;\n                    if (!LIBRARY) TypedArrayPrototype.constructor = TypedArray;\n                }\n                var $nativeIterator = TypedArrayPrototype[ITERATOR];\n                var CORRECT_ITER_NAME = !!$nativeIterator\n                    && ($nativeIterator.name == 'values' || $nativeIterator.name == undefined);\n                var $iterator = $iterators.values;\n                hide(TypedArray, TYPED_CONSTRUCTOR, true);\n                hide(TypedArrayPrototype, TYPED_ARRAY, NAME);\n                hide(TypedArrayPrototype, VIEW, true);\n                hide(TypedArrayPrototype, DEF_CONSTRUCTOR, TypedArray);\n\n                if (CLAMPED ? new TypedArray(1)[TAG] != NAME : !(TAG in TypedArrayPrototype)) {\n                    dP(TypedArrayPrototype, TAG, {\n                        get: function () { return NAME; }\n                    });\n                }\n\n                O[NAME] = TypedArray;\n\n                $export($export.G + $export.W + $export.F * (TypedArray != Base), O);\n\n                $export($export.S, NAME, {\n                    BYTES_PER_ELEMENT: BYTES\n                });\n\n                $export($export.S + $export.F * fails(function () { Base.of.call(TypedArray, 1); }), NAME, {\n                    from: $from,\n                    of: $of\n                });\n\n                if (!(BYTES_PER_ELEMENT in TypedArrayPrototype)) hide(TypedArrayPrototype, BYTES_PER_ELEMENT, BYTES);\n\n                $export($export.P, NAME, proto);\n\n                setSpecies(NAME);\n\n                $export($export.P + $export.F * FORCED_SET, NAME, { set: $set });\n\n                $export($export.P + $export.F * !CORRECT_ITER_NAME, NAME, $iterators);\n\n                if (!LIBRARY && TypedArrayPrototype.toString != arrayToString) TypedArrayPrototype.toString = arrayToString;\n\n                $export($export.P + $export.F * fails(function () {\n                    new TypedArray(1).slice();\n                }), NAME, { slice: $slice });\n\n                $export($export.P + $export.F * (fails(function () {\n                    return [1, 2].toLocaleString() != new TypedArray([1, 2]).toLocaleString();\n                }) || !fails(function () {\n                    TypedArrayPrototype.toLocaleString.call([1, 2]);\n                })), NAME, { toLocaleString: $toLocaleString });\n\n                Iterators[NAME] = CORRECT_ITER_NAME ? $nativeIterator : $iterator;\n                if (!LIBRARY && !CORRECT_ITER_NAME) hide(TypedArrayPrototype, ITERATOR, $iterator);\n            };\n        } else module.exports = function () { /* empty */ };\n\n    },{\"100\":100,\"104\":104,\"11\":11,\"114\":114,\"115\":115,\"116\":116,\"118\":118,\"119\":119,\"12\":12,\"120\":120,\"122\":122,\"123\":123,\"124\":124,\"128\":128,\"129\":129,\"141\":141,\"17\":17,\"25\":25,\"29\":29,\"33\":33,\"35\":35,\"40\":40,\"41\":41,\"42\":42,\"48\":48,\"51\":51,\"56\":56,\"58\":58,\"6\":6,\"60\":60,\"71\":71,\"72\":72,\"75\":75,\"77\":77,\"79\":79,\"8\":8,\"9\":9,\"92\":92,\"93\":93}],122:[function(_dereq_,module,exports){\n        'use strict';\n        var global = _dereq_(40);\n        var DESCRIPTORS = _dereq_(29);\n        var LIBRARY = _dereq_(60);\n        var $typed = _dereq_(123);\n        var hide = _dereq_(42);\n        var redefineAll = _dereq_(93);\n        var fails = _dereq_(35);\n        var anInstance = _dereq_(6);\n        var toInteger = _dereq_(116);\n        var toLength = _dereq_(118);\n        var toIndex = _dereq_(115);\n        var gOPN = _dereq_(77).f;\n        var dP = _dereq_(72).f;\n        var arrayFill = _dereq_(9);\n        var setToStringTag = _dereq_(101);\n        var ARRAY_BUFFER = 'ArrayBuffer';\n        var DATA_VIEW = 'DataView';\n        var PROTOTYPE = 'prototype';\n        var WRONG_LENGTH = 'Wrong length!';\n        var WRONG_INDEX = 'Wrong index!';\n        var $ArrayBuffer = global[ARRAY_BUFFER];\n        var $DataView = global[DATA_VIEW];\n        var Math = global.Math;\n        var RangeError = global.RangeError;\n// eslint-disable-next-line no-shadow-restricted-names\n        var Infinity = global.Infinity;\n        var BaseBuffer = $ArrayBuffer;\n        var abs = Math.abs;\n        var pow = Math.pow;\n        var floor = Math.floor;\n        var log = Math.log;\n        var LN2 = Math.LN2;\n        var BUFFER = 'buffer';\n        var BYTE_LENGTH = 'byteLength';\n        var BYTE_OFFSET = 'byteOffset';\n        var $BUFFER = DESCRIPTORS ? '_b' : BUFFER;\n        var $LENGTH = DESCRIPTORS ? '_l' : BYTE_LENGTH;\n        var $OFFSET = DESCRIPTORS ? '_o' : BYTE_OFFSET;\n\n// IEEE754 conversions based on https://github.com/feross/ieee754\n        function packIEEE754(value, mLen, nBytes) {\n            var buffer = Array(nBytes);\n            var eLen = nBytes * 8 - mLen - 1;\n            var eMax = (1 << eLen) - 1;\n            var eBias = eMax >> 1;\n            var rt = mLen === 23 ? pow(2, -24) - pow(2, -77) : 0;\n            var i = 0;\n            var s = value < 0 || value === 0 && 1 / value < 0 ? 1 : 0;\n            var e, m, c;\n            value = abs(value);\n            // eslint-disable-next-line no-self-compare\n            if (value != value || value === Infinity) {\n                // eslint-disable-next-line no-self-compare\n                m = value != value ? 1 : 0;\n                e = eMax;\n            } else {\n                e = floor(log(value) / LN2);\n                if (value * (c = pow(2, -e)) < 1) {\n                    e--;\n                    c *= 2;\n                }\n                if (e + eBias >= 1) {\n                    value += rt / c;\n                } else {\n                    value += rt * pow(2, 1 - eBias);\n                }\n                if (value * c >= 2) {\n                    e++;\n                    c /= 2;\n                }\n                if (e + eBias >= eMax) {\n                    m = 0;\n                    e = eMax;\n                } else if (e + eBias >= 1) {\n                    m = (value * c - 1) * pow(2, mLen);\n                    e = e + eBias;\n                } else {\n                    m = value * pow(2, eBias - 1) * pow(2, mLen);\n                    e = 0;\n                }\n            }\n            for (; mLen >= 8; buffer[i++] = m & 255, m /= 256, mLen -= 8);\n            e = e << mLen | m;\n            eLen += mLen;\n            for (; eLen > 0; buffer[i++] = e & 255, e /= 256, eLen -= 8);\n            buffer[--i] |= s * 128;\n            return buffer;\n        }\n        function unpackIEEE754(buffer, mLen, nBytes) {\n            var eLen = nBytes * 8 - mLen - 1;\n            var eMax = (1 << eLen) - 1;\n            var eBias = eMax >> 1;\n            var nBits = eLen - 7;\n            var i = nBytes - 1;\n            var s = buffer[i--];\n            var e = s & 127;\n            var m;\n            s >>= 7;\n            for (; nBits > 0; e = e * 256 + buffer[i], i--, nBits -= 8);\n            m = e & (1 << -nBits) - 1;\n            e >>= -nBits;\n            nBits += mLen;\n            for (; nBits > 0; m = m * 256 + buffer[i], i--, nBits -= 8);\n            if (e === 0) {\n                e = 1 - eBias;\n            } else if (e === eMax) {\n                return m ? NaN : s ? -Infinity : Infinity;\n            } else {\n                m = m + pow(2, mLen);\n                e = e - eBias;\n            } return (s ? -1 : 1) * m * pow(2, e - mLen);\n        }\n\n        function unpackI32(bytes) {\n            return bytes[3] << 24 | bytes[2] << 16 | bytes[1] << 8 | bytes[0];\n        }\n        function packI8(it) {\n            return [it & 0xff];\n        }\n        function packI16(it) {\n            return [it & 0xff, it >> 8 & 0xff];\n        }\n        function packI32(it) {\n            return [it & 0xff, it >> 8 & 0xff, it >> 16 & 0xff, it >> 24 & 0xff];\n        }\n        function packF64(it) {\n            return packIEEE754(it, 52, 8);\n        }\n        function packF32(it) {\n            return packIEEE754(it, 23, 4);\n        }\n\n        function addGetter(C, key, internal) {\n            dP(C[PROTOTYPE], key, { get: function () { return this[internal]; } });\n        }\n\n        function get(view, bytes, index, isLittleEndian) {\n            var numIndex = +index;\n            var intIndex = toIndex(numIndex);\n            if (intIndex + bytes > view[$LENGTH]) throw RangeError(WRONG_INDEX);\n            var store = view[$BUFFER]._b;\n            var start = intIndex + view[$OFFSET];\n            var pack = store.slice(start, start + bytes);\n            return isLittleEndian ? pack : pack.reverse();\n        }\n        function set(view, bytes, index, conversion, value, isLittleEndian) {\n            var numIndex = +index;\n            var intIndex = toIndex(numIndex);\n            if (intIndex + bytes > view[$LENGTH]) throw RangeError(WRONG_INDEX);\n            var store = view[$BUFFER]._b;\n            var start = intIndex + view[$OFFSET];\n            var pack = conversion(+value);\n            for (var i = 0; i < bytes; i++) store[start + i] = pack[isLittleEndian ? i : bytes - i - 1];\n        }\n\n        if (!$typed.ABV) {\n            $ArrayBuffer = function ArrayBuffer(length) {\n                anInstance(this, $ArrayBuffer, ARRAY_BUFFER);\n                var byteLength = toIndex(length);\n                this._b = arrayFill.call(Array(byteLength), 0);\n                this[$LENGTH] = byteLength;\n            };\n\n            $DataView = function DataView(buffer, byteOffset, byteLength) {\n                anInstance(this, $DataView, DATA_VIEW);\n                anInstance(buffer, $ArrayBuffer, DATA_VIEW);\n                var bufferLength = buffer[$LENGTH];\n                var offset = toInteger(byteOffset);\n                if (offset < 0 || offset > bufferLength) throw RangeError('Wrong offset!');\n                byteLength = byteLength === undefined ? bufferLength - offset : toLength(byteLength);\n                if (offset + byteLength > bufferLength) throw RangeError(WRONG_LENGTH);\n                this[$BUFFER] = buffer;\n                this[$OFFSET] = offset;\n                this[$LENGTH] = byteLength;\n            };\n\n            if (DESCRIPTORS) {\n                addGetter($ArrayBuffer, BYTE_LENGTH, '_l');\n                addGetter($DataView, BUFFER, '_b');\n                addGetter($DataView, BYTE_LENGTH, '_l');\n                addGetter($DataView, BYTE_OFFSET, '_o');\n            }\n\n            redefineAll($DataView[PROTOTYPE], {\n                getInt8: function getInt8(byteOffset) {\n                    return get(this, 1, byteOffset)[0] << 24 >> 24;\n                },\n                getUint8: function getUint8(byteOffset) {\n                    return get(this, 1, byteOffset)[0];\n                },\n                getInt16: function getInt16(byteOffset /* , littleEndian */) {\n                    var bytes = get(this, 2, byteOffset, arguments[1]);\n                    return (bytes[1] << 8 | bytes[0]) << 16 >> 16;\n                },\n                getUint16: function getUint16(byteOffset /* , littleEndian */) {\n                    var bytes = get(this, 2, byteOffset, arguments[1]);\n                    return bytes[1] << 8 | bytes[0];\n                },\n                getInt32: function getInt32(byteOffset /* , littleEndian */) {\n                    return unpackI32(get(this, 4, byteOffset, arguments[1]));\n                },\n                getUint32: function getUint32(byteOffset /* , littleEndian */) {\n                    return unpackI32(get(this, 4, byteOffset, arguments[1])) >>> 0;\n                },\n                getFloat32: function getFloat32(byteOffset /* , littleEndian */) {\n                    return unpackIEEE754(get(this, 4, byteOffset, arguments[1]), 23, 4);\n                },\n                getFloat64: function getFloat64(byteOffset /* , littleEndian */) {\n                    return unpackIEEE754(get(this, 8, byteOffset, arguments[1]), 52, 8);\n                },\n                setInt8: function setInt8(byteOffset, value) {\n                    set(this, 1, byteOffset, packI8, value);\n                },\n                setUint8: function setUint8(byteOffset, value) {\n                    set(this, 1, byteOffset, packI8, value);\n                },\n                setInt16: function setInt16(byteOffset, value /* , littleEndian */) {\n                    set(this, 2, byteOffset, packI16, value, arguments[2]);\n                },\n                setUint16: function setUint16(byteOffset, value /* , littleEndian */) {\n                    set(this, 2, byteOffset, packI16, value, arguments[2]);\n                },\n                setInt32: function setInt32(byteOffset, value /* , littleEndian */) {\n                    set(this, 4, byteOffset, packI32, value, arguments[2]);\n                },\n                setUint32: function setUint32(byteOffset, value /* , littleEndian */) {\n                    set(this, 4, byteOffset, packI32, value, arguments[2]);\n                },\n                setFloat32: function setFloat32(byteOffset, value /* , littleEndian */) {\n                    set(this, 4, byteOffset, packF32, value, arguments[2]);\n                },\n                setFloat64: function setFloat64(byteOffset, value /* , littleEndian */) {\n                    set(this, 8, byteOffset, packF64, value, arguments[2]);\n                }\n            });\n        } else {\n            if (!fails(function () {\n                $ArrayBuffer(1);\n            }) || !fails(function () {\n                new $ArrayBuffer(-1); // eslint-disable-line no-new\n            }) || fails(function () {\n                new $ArrayBuffer(); // eslint-disable-line no-new\n                new $ArrayBuffer(1.5); // eslint-disable-line no-new\n                new $ArrayBuffer(NaN); // eslint-disable-line no-new\n                return $ArrayBuffer.name != ARRAY_BUFFER;\n            })) {\n                $ArrayBuffer = function ArrayBuffer(length) {\n                    anInstance(this, $ArrayBuffer);\n                    return new BaseBuffer(toIndex(length));\n                };\n                var ArrayBufferProto = $ArrayBuffer[PROTOTYPE] = BaseBuffer[PROTOTYPE];\n                for (var keys = gOPN(BaseBuffer), j = 0, key; keys.length > j;) {\n                    if (!((key = keys[j++]) in $ArrayBuffer)) hide($ArrayBuffer, key, BaseBuffer[key]);\n                }\n                if (!LIBRARY) ArrayBufferProto.constructor = $ArrayBuffer;\n            }\n            // iOS Safari 7.x bug\n            var view = new $DataView(new $ArrayBuffer(2));\n            var $setInt8 = $DataView[PROTOTYPE].setInt8;\n            view.setInt8(0, 2147483648);\n            view.setInt8(1, 2147483649);\n            if (view.getInt8(0) || !view.getInt8(1)) redefineAll($DataView[PROTOTYPE], {\n                setInt8: function setInt8(byteOffset, value) {\n                    $setInt8.call(this, byteOffset, value << 24 >> 24);\n                },\n                setUint8: function setUint8(byteOffset, value) {\n                    $setInt8.call(this, byteOffset, value << 24 >> 24);\n                }\n            }, true);\n        }\n        setToStringTag($ArrayBuffer, ARRAY_BUFFER);\n        setToStringTag($DataView, DATA_VIEW);\n        hide($DataView[PROTOTYPE], $typed.VIEW, true);\n        exports[ARRAY_BUFFER] = $ArrayBuffer;\n        exports[DATA_VIEW] = $DataView;\n\n    },{\"101\":101,\"115\":115,\"116\":116,\"118\":118,\"123\":123,\"29\":29,\"35\":35,\"40\":40,\"42\":42,\"6\":6,\"60\":60,\"72\":72,\"77\":77,\"9\":9,\"93\":93}],123:[function(_dereq_,module,exports){\n        var global = _dereq_(40);\n        var hide = _dereq_(42);\n        var uid = _dereq_(124);\n        var TYPED = uid('typed_array');\n        var VIEW = uid('view');\n        var ABV = !!(global.ArrayBuffer && global.DataView);\n        var CONSTR = ABV;\n        var i = 0;\n        var l = 9;\n        var Typed;\n\n        var TypedArrayConstructors = (\n            'Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array'\n        ).split(',');\n\n        while (i < l) {\n            if (Typed = global[TypedArrayConstructors[i++]]) {\n                hide(Typed.prototype, TYPED, true);\n                hide(Typed.prototype, VIEW, true);\n            } else CONSTR = false;\n        }\n\n        module.exports = {\n            ABV: ABV,\n            CONSTR: CONSTR,\n            TYPED: TYPED,\n            VIEW: VIEW\n        };\n\n    },{\"124\":124,\"40\":40,\"42\":42}],124:[function(_dereq_,module,exports){\n        var id = 0;\n        var px = Math.random();\n        module.exports = function (key) {\n            return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));\n        };\n\n    },{}],125:[function(_dereq_,module,exports){\n        var isObject = _dereq_(51);\n        module.exports = function (it, TYPE) {\n            if (!isObject(it) || it._t !== TYPE) throw TypeError('Incompatible receiver, ' + TYPE + ' required!');\n            return it;\n        };\n\n    },{\"51\":51}],126:[function(_dereq_,module,exports){\n        var global = _dereq_(40);\n        var core = _dereq_(23);\n        var LIBRARY = _dereq_(60);\n        var wksExt = _dereq_(127);\n        var defineProperty = _dereq_(72).f;\n        module.exports = function (name) {\n            var $Symbol = core.Symbol || (core.Symbol = LIBRARY ? {} : global.Symbol || {});\n            if (name.charAt(0) != '_' && !(name in $Symbol)) defineProperty($Symbol, name, { value: wksExt.f(name) });\n        };\n\n    },{\"127\":127,\"23\":23,\"40\":40,\"60\":60,\"72\":72}],127:[function(_dereq_,module,exports){\n        exports.f = _dereq_(128);\n\n    },{\"128\":128}],128:[function(_dereq_,module,exports){\n        var store = _dereq_(103)('wks');\n        var uid = _dereq_(124);\n        var Symbol = _dereq_(40).Symbol;\n        var USE_SYMBOL = typeof Symbol == 'function';\n\n        var $exports = module.exports = function (name) {\n            return store[name] || (store[name] =\n                USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : uid)('Symbol.' + name));\n        };\n\n        $exports.store = store;\n\n    },{\"103\":103,\"124\":124,\"40\":40}],129:[function(_dereq_,module,exports){\n        var classof = _dereq_(17);\n        var ITERATOR = _dereq_(128)('iterator');\n        var Iterators = _dereq_(58);\n        module.exports = _dereq_(23).getIteratorMethod = function (it) {\n            if (it != undefined) return it[ITERATOR]\n                || it['@@iterator']\n                || Iterators[classof(it)];\n        };\n\n    },{\"128\":128,\"17\":17,\"23\":23,\"58\":58}],130:[function(_dereq_,module,exports){\n// https://github.com/benjamingr/RexExp.escape\n        var $export = _dereq_(33);\n        var $re = _dereq_(95)(/[\\\\^$*+?.()|[\\]{}]/g, '\\\\$&');\n\n        $export($export.S, 'RegExp', { escape: function escape(it) { return $re(it); } });\n\n    },{\"33\":33,\"95\":95}],131:[function(_dereq_,module,exports){\n// 22.1.3.3 Array.prototype.copyWithin(target, start, end = this.length)\n        var $export = _dereq_(33);\n\n        $export($export.P, 'Array', { copyWithin: _dereq_(8) });\n\n        _dereq_(5)('copyWithin');\n\n    },{\"33\":33,\"5\":5,\"8\":8}],132:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var $every = _dereq_(12)(4);\n\n        $export($export.P + $export.F * !_dereq_(105)([].every, true), 'Array', {\n            // 22.1.3.5 / 15.4.4.16 Array.prototype.every(callbackfn [, thisArg])\n            every: function every(callbackfn /* , thisArg */) {\n                return $every(this, callbackfn, arguments[1]);\n            }\n        });\n\n    },{\"105\":105,\"12\":12,\"33\":33}],133:[function(_dereq_,module,exports){\n// 22.1.3.6 Array.prototype.fill(value, start = 0, end = this.length)\n        var $export = _dereq_(33);\n\n        $export($export.P, 'Array', { fill: _dereq_(9) });\n\n        _dereq_(5)('fill');\n\n    },{\"33\":33,\"5\":5,\"9\":9}],134:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var $filter = _dereq_(12)(2);\n\n        $export($export.P + $export.F * !_dereq_(105)([].filter, true), 'Array', {\n            // 22.1.3.7 / 15.4.4.20 Array.prototype.filter(callbackfn [, thisArg])\n            filter: function filter(callbackfn /* , thisArg */) {\n                return $filter(this, callbackfn, arguments[1]);\n            }\n        });\n\n    },{\"105\":105,\"12\":12,\"33\":33}],135:[function(_dereq_,module,exports){\n        'use strict';\n// 22.1.3.9 Array.prototype.findIndex(predicate, thisArg = undefined)\n        var $export = _dereq_(33);\n        var $find = _dereq_(12)(6);\n        var KEY = 'findIndex';\n        var forced = true;\n// Shouldn't skip holes\n        if (KEY in []) Array(1)[KEY](function () { forced = false; });\n        $export($export.P + $export.F * forced, 'Array', {\n            findIndex: function findIndex(callbackfn /* , that = undefined */) {\n                return $find(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);\n            }\n        });\n        _dereq_(5)(KEY);\n\n    },{\"12\":12,\"33\":33,\"5\":5}],136:[function(_dereq_,module,exports){\n        'use strict';\n// 22.1.3.8 Array.prototype.find(predicate, thisArg = undefined)\n        var $export = _dereq_(33);\n        var $find = _dereq_(12)(5);\n        var KEY = 'find';\n        var forced = true;\n// Shouldn't skip holes\n        if (KEY in []) Array(1)[KEY](function () { forced = false; });\n        $export($export.P + $export.F * forced, 'Array', {\n            find: function find(callbackfn /* , that = undefined */) {\n                return $find(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);\n            }\n        });\n        _dereq_(5)(KEY);\n\n    },{\"12\":12,\"33\":33,\"5\":5}],137:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var $forEach = _dereq_(12)(0);\n        var STRICT = _dereq_(105)([].forEach, true);\n\n        $export($export.P + $export.F * !STRICT, 'Array', {\n            // 22.1.3.10 / 15.4.4.18 Array.prototype.forEach(callbackfn [, thisArg])\n            forEach: function forEach(callbackfn /* , thisArg */) {\n                return $forEach(this, callbackfn, arguments[1]);\n            }\n        });\n\n    },{\"105\":105,\"12\":12,\"33\":33}],138:[function(_dereq_,module,exports){\n        'use strict';\n        var ctx = _dereq_(25);\n        var $export = _dereq_(33);\n        var toObject = _dereq_(119);\n        var call = _dereq_(53);\n        var isArrayIter = _dereq_(48);\n        var toLength = _dereq_(118);\n        var createProperty = _dereq_(24);\n        var getIterFn = _dereq_(129);\n\n        $export($export.S + $export.F * !_dereq_(56)(function (iter) { Array.from(iter); }), 'Array', {\n            // 22.1.2.1 Array.from(arrayLike, mapfn = undefined, thisArg = undefined)\n            from: function from(arrayLike /* , mapfn = undefined, thisArg = undefined */) {\n                var O = toObject(arrayLike);\n                var C = typeof this == 'function' ? this : Array;\n                var aLen = arguments.length;\n                var mapfn = aLen > 1 ? arguments[1] : undefined;\n                var mapping = mapfn !== undefined;\n                var index = 0;\n                var iterFn = getIterFn(O);\n                var length, result, step, iterator;\n                if (mapping) mapfn = ctx(mapfn, aLen > 2 ? arguments[2] : undefined, 2);\n                // if object isn't iterable or it's array with default iterator - use simple case\n                if (iterFn != undefined && !(C == Array && isArrayIter(iterFn))) {\n                    for (iterator = iterFn.call(O), result = new C(); !(step = iterator.next()).done; index++) {\n                        createProperty(result, index, mapping ? call(iterator, mapfn, [step.value, index], true) : step.value);\n                    }\n                } else {\n                    length = toLength(O.length);\n                    for (result = new C(length); length > index; index++) {\n                        createProperty(result, index, mapping ? mapfn(O[index], index) : O[index]);\n                    }\n                }\n                result.length = index;\n                return result;\n            }\n        });\n\n    },{\"118\":118,\"119\":119,\"129\":129,\"24\":24,\"25\":25,\"33\":33,\"48\":48,\"53\":53,\"56\":56}],139:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var $indexOf = _dereq_(11)(false);\n        var $native = [].indexOf;\n        var NEGATIVE_ZERO = !!$native && 1 / [1].indexOf(1, -0) < 0;\n\n        $export($export.P + $export.F * (NEGATIVE_ZERO || !_dereq_(105)($native)), 'Array', {\n            // 22.1.3.11 / 15.4.4.14 Array.prototype.indexOf(searchElement [, fromIndex])\n            indexOf: function indexOf(searchElement /* , fromIndex = 0 */) {\n                return NEGATIVE_ZERO\n                    // convert -0 to +0\n                    ? $native.apply(this, arguments) || 0\n                    : $indexOf(this, searchElement, arguments[1]);\n            }\n        });\n\n    },{\"105\":105,\"11\":11,\"33\":33}],140:[function(_dereq_,module,exports){\n// 22.1.2.2 / 15.4.3.2 Array.isArray(arg)\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Array', { isArray: _dereq_(49) });\n\n    },{\"33\":33,\"49\":49}],141:[function(_dereq_,module,exports){\n        'use strict';\n        var addToUnscopables = _dereq_(5);\n        var step = _dereq_(57);\n        var Iterators = _dereq_(58);\n        var toIObject = _dereq_(117);\n\n// 22.1.3.4 Array.prototype.entries()\n// 22.1.3.13 Array.prototype.keys()\n// 22.1.3.29 Array.prototype.values()\n// 22.1.3.30 Array.prototype[@@iterator]()\n        module.exports = _dereq_(55)(Array, 'Array', function (iterated, kind) {\n            this._t = toIObject(iterated); // target\n            this._i = 0;                   // next index\n            this._k = kind;                // kind\n// 22.1.5.2.1 %ArrayIteratorPrototype%.next()\n        }, function () {\n            var O = this._t;\n            var kind = this._k;\n            var index = this._i++;\n            if (!O || index >= O.length) {\n                this._t = undefined;\n                return step(1);\n            }\n            if (kind == 'keys') return step(0, index);\n            if (kind == 'values') return step(0, O[index]);\n            return step(0, [index, O[index]]);\n        }, 'values');\n\n// argumentsList[@@iterator] is %ArrayProto_values% (9.4.4.6, 9.4.4.7)\n        Iterators.Arguments = Iterators.Array;\n\n        addToUnscopables('keys');\n        addToUnscopables('values');\n        addToUnscopables('entries');\n\n    },{\"117\":117,\"5\":5,\"55\":55,\"57\":57,\"58\":58}],142:[function(_dereq_,module,exports){\n        'use strict';\n// 22.1.3.13 Array.prototype.join(separator)\n        var $export = _dereq_(33);\n        var toIObject = _dereq_(117);\n        var arrayJoin = [].join;\n\n// fallback for not array-like strings\n        $export($export.P + $export.F * (_dereq_(47) != Object || !_dereq_(105)(arrayJoin)), 'Array', {\n            join: function join(separator) {\n                return arrayJoin.call(toIObject(this), separator === undefined ? ',' : separator);\n            }\n        });\n\n    },{\"105\":105,\"117\":117,\"33\":33,\"47\":47}],143:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var toIObject = _dereq_(117);\n        var toInteger = _dereq_(116);\n        var toLength = _dereq_(118);\n        var $native = [].lastIndexOf;\n        var NEGATIVE_ZERO = !!$native && 1 / [1].lastIndexOf(1, -0) < 0;\n\n        $export($export.P + $export.F * (NEGATIVE_ZERO || !_dereq_(105)($native)), 'Array', {\n            // 22.1.3.14 / 15.4.4.15 Array.prototype.lastIndexOf(searchElement [, fromIndex])\n            lastIndexOf: function lastIndexOf(searchElement /* , fromIndex = @[*-1] */) {\n                // convert -0 to +0\n                if (NEGATIVE_ZERO) return $native.apply(this, arguments) || 0;\n                var O = toIObject(this);\n                var length = toLength(O.length);\n                var index = length - 1;\n                if (arguments.length > 1) index = Math.min(index, toInteger(arguments[1]));\n                if (index < 0) index = length + index;\n                for (;index >= 0; index--) if (index in O) if (O[index] === searchElement) return index || 0;\n                return -1;\n            }\n        });\n\n    },{\"105\":105,\"116\":116,\"117\":117,\"118\":118,\"33\":33}],144:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var $map = _dereq_(12)(1);\n\n        $export($export.P + $export.F * !_dereq_(105)([].map, true), 'Array', {\n            // 22.1.3.15 / 15.4.4.19 Array.prototype.map(callbackfn [, thisArg])\n            map: function map(callbackfn /* , thisArg */) {\n                return $map(this, callbackfn, arguments[1]);\n            }\n        });\n\n    },{\"105\":105,\"12\":12,\"33\":33}],145:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var createProperty = _dereq_(24);\n\n// WebKit Array.of isn't generic\n        $export($export.S + $export.F * _dereq_(35)(function () {\n            function F() { /* empty */ }\n            return !(Array.of.call(F) instanceof F);\n        }), 'Array', {\n            // 22.1.2.3 Array.of( ...items)\n            of: function of(/* ...args */) {\n                var index = 0;\n                var aLen = arguments.length;\n                var result = new (typeof this == 'function' ? this : Array)(aLen);\n                while (aLen > index) createProperty(result, index, arguments[index++]);\n                result.length = aLen;\n                return result;\n            }\n        });\n\n    },{\"24\":24,\"33\":33,\"35\":35}],146:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var $reduce = _dereq_(13);\n\n        $export($export.P + $export.F * !_dereq_(105)([].reduceRight, true), 'Array', {\n            // 22.1.3.19 / 15.4.4.22 Array.prototype.reduceRight(callbackfn [, initialValue])\n            reduceRight: function reduceRight(callbackfn /* , initialValue */) {\n                return $reduce(this, callbackfn, arguments.length, arguments[1], true);\n            }\n        });\n\n    },{\"105\":105,\"13\":13,\"33\":33}],147:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var $reduce = _dereq_(13);\n\n        $export($export.P + $export.F * !_dereq_(105)([].reduce, true), 'Array', {\n            // 22.1.3.18 / 15.4.4.21 Array.prototype.reduce(callbackfn [, initialValue])\n            reduce: function reduce(callbackfn /* , initialValue */) {\n                return $reduce(this, callbackfn, arguments.length, arguments[1], false);\n            }\n        });\n\n    },{\"105\":105,\"13\":13,\"33\":33}],148:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var html = _dereq_(43);\n        var cof = _dereq_(18);\n        var toAbsoluteIndex = _dereq_(114);\n        var toLength = _dereq_(118);\n        var arraySlice = [].slice;\n\n// fallback for not array-like ES3 strings and DOM objects\n        $export($export.P + $export.F * _dereq_(35)(function () {\n            if (html) arraySlice.call(html);\n        }), 'Array', {\n            slice: function slice(begin, end) {\n                var len = toLength(this.length);\n                var klass = cof(this);\n                end = end === undefined ? len : end;\n                if (klass == 'Array') return arraySlice.call(this, begin, end);\n                var start = toAbsoluteIndex(begin, len);\n                var upTo = toAbsoluteIndex(end, len);\n                var size = toLength(upTo - start);\n                var cloned = Array(size);\n                var i = 0;\n                for (; i < size; i++) cloned[i] = klass == 'String'\n                    ? this.charAt(start + i)\n                    : this[start + i];\n                return cloned;\n            }\n        });\n\n    },{\"114\":114,\"118\":118,\"18\":18,\"33\":33,\"35\":35,\"43\":43}],149:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var $some = _dereq_(12)(3);\n\n        $export($export.P + $export.F * !_dereq_(105)([].some, true), 'Array', {\n            // 22.1.3.23 / 15.4.4.17 Array.prototype.some(callbackfn [, thisArg])\n            some: function some(callbackfn /* , thisArg */) {\n                return $some(this, callbackfn, arguments[1]);\n            }\n        });\n\n    },{\"105\":105,\"12\":12,\"33\":33}],150:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var aFunction = _dereq_(3);\n        var toObject = _dereq_(119);\n        var fails = _dereq_(35);\n        var $sort = [].sort;\n        var test = [1, 2, 3];\n\n        $export($export.P + $export.F * (fails(function () {\n            // IE8-\n            test.sort(undefined);\n        }) || !fails(function () {\n            // V8 bug\n            test.sort(null);\n            // Old WebKit\n        }) || !_dereq_(105)($sort)), 'Array', {\n            // 22.1.3.25 Array.prototype.sort(comparefn)\n            sort: function sort(comparefn) {\n                return comparefn === undefined\n                    ? $sort.call(toObject(this))\n                    : $sort.call(toObject(this), aFunction(comparefn));\n            }\n        });\n\n    },{\"105\":105,\"119\":119,\"3\":3,\"33\":33,\"35\":35}],151:[function(_dereq_,module,exports){\n        _dereq_(100)('Array');\n\n    },{\"100\":100}],152:[function(_dereq_,module,exports){\n// 20.3.3.1 / 15.9.4.4 Date.now()\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Date', { now: function () { return new Date().getTime(); } });\n\n    },{\"33\":33}],153:[function(_dereq_,module,exports){\n// 20.3.4.36 / 15.9.5.43 Date.prototype.toISOString()\n        var $export = _dereq_(33);\n        var toISOString = _dereq_(26);\n\n// PhantomJS / old WebKit has a broken implementations\n        $export($export.P + $export.F * (Date.prototype.toISOString !== toISOString), 'Date', {\n            toISOString: toISOString\n        });\n\n    },{\"26\":26,\"33\":33}],154:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var toObject = _dereq_(119);\n        var toPrimitive = _dereq_(120);\n\n        $export($export.P + $export.F * _dereq_(35)(function () {\n            return new Date(NaN).toJSON() !== null\n                || Date.prototype.toJSON.call({ toISOString: function () { return 1; } }) !== 1;\n        }), 'Date', {\n            // eslint-disable-next-line no-unused-vars\n            toJSON: function toJSON(key) {\n                var O = toObject(this);\n                var pv = toPrimitive(O);\n                return typeof pv == 'number' && !isFinite(pv) ? null : O.toISOString();\n            }\n        });\n\n    },{\"119\":119,\"120\":120,\"33\":33,\"35\":35}],155:[function(_dereq_,module,exports){\n        var TO_PRIMITIVE = _dereq_(128)('toPrimitive');\n        var proto = Date.prototype;\n\n        if (!(TO_PRIMITIVE in proto)) _dereq_(42)(proto, TO_PRIMITIVE, _dereq_(27));\n\n    },{\"128\":128,\"27\":27,\"42\":42}],156:[function(_dereq_,module,exports){\n        var DateProto = Date.prototype;\n        var INVALID_DATE = 'Invalid Date';\n        var TO_STRING = 'toString';\n        var $toString = DateProto[TO_STRING];\n        var getTime = DateProto.getTime;\n        if (new Date(NaN) + '' != INVALID_DATE) {\n            _dereq_(94)(DateProto, TO_STRING, function toString() {\n                var value = getTime.call(this);\n                // eslint-disable-next-line no-self-compare\n                return value === value ? $toString.call(this) : INVALID_DATE;\n            });\n        }\n\n    },{\"94\":94}],157:[function(_dereq_,module,exports){\n// 19.2.3.2 / 15.3.4.5 Function.prototype.bind(thisArg, args...)\n        var $export = _dereq_(33);\n\n        $export($export.P, 'Function', { bind: _dereq_(16) });\n\n    },{\"16\":16,\"33\":33}],158:[function(_dereq_,module,exports){\n        'use strict';\n        var isObject = _dereq_(51);\n        var getPrototypeOf = _dereq_(79);\n        var HAS_INSTANCE = _dereq_(128)('hasInstance');\n        var FunctionProto = Function.prototype;\n// 19.2.3.6 Function.prototype[@@hasInstance](V)\n        if (!(HAS_INSTANCE in FunctionProto)) _dereq_(72).f(FunctionProto, HAS_INSTANCE, { value: function (O) {\n                if (typeof this != 'function' || !isObject(O)) return false;\n                if (!isObject(this.prototype)) return O instanceof this;\n                // for environment w/o native `@@hasInstance` logic enough `instanceof`, but add this:\n                while (O = getPrototypeOf(O)) if (this.prototype === O) return true;\n                return false;\n            } });\n\n    },{\"128\":128,\"51\":51,\"72\":72,\"79\":79}],159:[function(_dereq_,module,exports){\n        var dP = _dereq_(72).f;\n        var FProto = Function.prototype;\n        var nameRE = /^\\s*function ([^ (]*)/;\n        var NAME = 'name';\n\n// 19.2.4.2 name\n        NAME in FProto || _dereq_(29) && dP(FProto, NAME, {\n            configurable: true,\n            get: function () {\n                try {\n                    return ('' + this).match(nameRE)[1];\n                } catch (e) {\n                    return '';\n                }\n            }\n        });\n\n    },{\"29\":29,\"72\":72}],160:[function(_dereq_,module,exports){\n        'use strict';\n        var strong = _dereq_(19);\n        var validate = _dereq_(125);\n        var MAP = 'Map';\n\n// 23.1 Map Objects\n        module.exports = _dereq_(22)(MAP, function (get) {\n            return function Map() { return get(this, arguments.length > 0 ? arguments[0] : undefined); };\n        }, {\n            // 23.1.3.6 Map.prototype.get(key)\n            get: function get(key) {\n                var entry = strong.getEntry(validate(this, MAP), key);\n                return entry && entry.v;\n            },\n            // 23.1.3.9 Map.prototype.set(key, value)\n            set: function set(key, value) {\n                return strong.def(validate(this, MAP), key === 0 ? 0 : key, value);\n            }\n        }, strong, true);\n\n    },{\"125\":125,\"19\":19,\"22\":22}],161:[function(_dereq_,module,exports){\n// 20.2.2.3 Math.acosh(x)\n        var $export = _dereq_(33);\n        var log1p = _dereq_(63);\n        var sqrt = Math.sqrt;\n        var $acosh = Math.acosh;\n\n        $export($export.S + $export.F * !($acosh\n            // V8 bug: https://code.google.com/p/v8/issues/detail?id=3509\n            && Math.floor($acosh(Number.MAX_VALUE)) == 710\n            // Tor Browser bug: Math.acosh(Infinity) -> NaN\n            && $acosh(Infinity) == Infinity\n        ), 'Math', {\n            acosh: function acosh(x) {\n                return (x = +x) < 1 ? NaN : x > 94906265.62425156\n                    ? Math.log(x) + Math.LN2\n                    : log1p(x - 1 + sqrt(x - 1) * sqrt(x + 1));\n            }\n        });\n\n    },{\"33\":33,\"63\":63}],162:[function(_dereq_,module,exports){\n// 20.2.2.5 Math.asinh(x)\n        var $export = _dereq_(33);\n        var $asinh = Math.asinh;\n\n        function asinh(x) {\n            return !isFinite(x = +x) || x == 0 ? x : x < 0 ? -asinh(-x) : Math.log(x + Math.sqrt(x * x + 1));\n        }\n\n// Tor Browser bug: Math.asinh(0) -> -0\n        $export($export.S + $export.F * !($asinh && 1 / $asinh(0) > 0), 'Math', { asinh: asinh });\n\n    },{\"33\":33}],163:[function(_dereq_,module,exports){\n// 20.2.2.7 Math.atanh(x)\n        var $export = _dereq_(33);\n        var $atanh = Math.atanh;\n\n// Tor Browser bug: Math.atanh(-0) -> 0\n        $export($export.S + $export.F * !($atanh && 1 / $atanh(-0) < 0), 'Math', {\n            atanh: function atanh(x) {\n                return (x = +x) == 0 ? x : Math.log((1 + x) / (1 - x)) / 2;\n            }\n        });\n\n    },{\"33\":33}],164:[function(_dereq_,module,exports){\n// 20.2.2.9 Math.cbrt(x)\n        var $export = _dereq_(33);\n        var sign = _dereq_(65);\n\n        $export($export.S, 'Math', {\n            cbrt: function cbrt(x) {\n                return sign(x = +x) * Math.pow(Math.abs(x), 1 / 3);\n            }\n        });\n\n    },{\"33\":33,\"65\":65}],165:[function(_dereq_,module,exports){\n// 20.2.2.11 Math.clz32(x)\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Math', {\n            clz32: function clz32(x) {\n                return (x >>>= 0) ? 31 - Math.floor(Math.log(x + 0.5) * Math.LOG2E) : 32;\n            }\n        });\n\n    },{\"33\":33}],166:[function(_dereq_,module,exports){\n// 20.2.2.12 Math.cosh(x)\n        var $export = _dereq_(33);\n        var exp = Math.exp;\n\n        $export($export.S, 'Math', {\n            cosh: function cosh(x) {\n                return (exp(x = +x) + exp(-x)) / 2;\n            }\n        });\n\n    },{\"33\":33}],167:[function(_dereq_,module,exports){\n// 20.2.2.14 Math.expm1(x)\n        var $export = _dereq_(33);\n        var $expm1 = _dereq_(61);\n\n        $export($export.S + $export.F * ($expm1 != Math.expm1), 'Math', { expm1: $expm1 });\n\n    },{\"33\":33,\"61\":61}],168:[function(_dereq_,module,exports){\n// 20.2.2.16 Math.fround(x)\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Math', { fround: _dereq_(62) });\n\n    },{\"33\":33,\"62\":62}],169:[function(_dereq_,module,exports){\n// 20.2.2.17 Math.hypot([value1[, value2[, \u2026 ]]])\n        var $export = _dereq_(33);\n        var abs = Math.abs;\n\n        $export($export.S, 'Math', {\n            hypot: function hypot(value1, value2) { // eslint-disable-line no-unused-vars\n                var sum = 0;\n                var i = 0;\n                var aLen = arguments.length;\n                var larg = 0;\n                var arg, div;\n                while (i < aLen) {\n                    arg = abs(arguments[i++]);\n                    if (larg < arg) {\n                        div = larg / arg;\n                        sum = sum * div * div + 1;\n                        larg = arg;\n                    } else if (arg > 0) {\n                        div = arg / larg;\n                        sum += div * div;\n                    } else sum += arg;\n                }\n                return larg === Infinity ? Infinity : larg * Math.sqrt(sum);\n            }\n        });\n\n    },{\"33\":33}],170:[function(_dereq_,module,exports){\n// 20.2.2.18 Math.imul(x, y)\n        var $export = _dereq_(33);\n        var $imul = Math.imul;\n\n// some WebKit versions fails with big numbers, some has wrong arity\n        $export($export.S + $export.F * _dereq_(35)(function () {\n            return $imul(0xffffffff, 5) != -5 || $imul.length != 2;\n        }), 'Math', {\n            imul: function imul(x, y) {\n                var UINT16 = 0xffff;\n                var xn = +x;\n                var yn = +y;\n                var xl = UINT16 & xn;\n                var yl = UINT16 & yn;\n                return 0 | xl * yl + ((UINT16 & xn >>> 16) * yl + xl * (UINT16 & yn >>> 16) << 16 >>> 0);\n            }\n        });\n\n    },{\"33\":33,\"35\":35}],171:[function(_dereq_,module,exports){\n// 20.2.2.21 Math.log10(x)\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Math', {\n            log10: function log10(x) {\n                return Math.log(x) * Math.LOG10E;\n            }\n        });\n\n    },{\"33\":33}],172:[function(_dereq_,module,exports){\n// 20.2.2.20 Math.log1p(x)\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Math', { log1p: _dereq_(63) });\n\n    },{\"33\":33,\"63\":63}],173:[function(_dereq_,module,exports){\n// 20.2.2.22 Math.log2(x)\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Math', {\n            log2: function log2(x) {\n                return Math.log(x) / Math.LN2;\n            }\n        });\n\n    },{\"33\":33}],174:[function(_dereq_,module,exports){\n// 20.2.2.28 Math.sign(x)\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Math', { sign: _dereq_(65) });\n\n    },{\"33\":33,\"65\":65}],175:[function(_dereq_,module,exports){\n// 20.2.2.30 Math.sinh(x)\n        var $export = _dereq_(33);\n        var expm1 = _dereq_(61);\n        var exp = Math.exp;\n\n// V8 near Chromium 38 has a problem with very small numbers\n        $export($export.S + $export.F * _dereq_(35)(function () {\n            return !Math.sinh(-2e-17) != -2e-17;\n        }), 'Math', {\n            sinh: function sinh(x) {\n                return Math.abs(x = +x) < 1\n                    ? (expm1(x) - expm1(-x)) / 2\n                    : (exp(x - 1) - exp(-x - 1)) * (Math.E / 2);\n            }\n        });\n\n    },{\"33\":33,\"35\":35,\"61\":61}],176:[function(_dereq_,module,exports){\n// 20.2.2.33 Math.tanh(x)\n        var $export = _dereq_(33);\n        var expm1 = _dereq_(61);\n        var exp = Math.exp;\n\n        $export($export.S, 'Math', {\n            tanh: function tanh(x) {\n                var a = expm1(x = +x);\n                var b = expm1(-x);\n                return a == Infinity ? 1 : b == Infinity ? -1 : (a - b) / (exp(x) + exp(-x));\n            }\n        });\n\n    },{\"33\":33,\"61\":61}],177:[function(_dereq_,module,exports){\n// 20.2.2.34 Math.trunc(x)\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Math', {\n            trunc: function trunc(it) {\n                return (it > 0 ? Math.floor : Math.ceil)(it);\n            }\n        });\n\n    },{\"33\":33}],178:[function(_dereq_,module,exports){\n        'use strict';\n        var global = _dereq_(40);\n        var has = _dereq_(41);\n        var cof = _dereq_(18);\n        var inheritIfRequired = _dereq_(45);\n        var toPrimitive = _dereq_(120);\n        var fails = _dereq_(35);\n        var gOPN = _dereq_(77).f;\n        var gOPD = _dereq_(75).f;\n        var dP = _dereq_(72).f;\n        var $trim = _dereq_(111).trim;\n        var NUMBER = 'Number';\n        var $Number = global[NUMBER];\n        var Base = $Number;\n        var proto = $Number.prototype;\n// Opera ~12 has broken Object#toString\n        var BROKEN_COF = cof(_dereq_(71)(proto)) == NUMBER;\n        var TRIM = 'trim' in String.prototype;\n\n// 7.1.3 ToNumber(argument)\n        var toNumber = function (argument) {\n            var it = toPrimitive(argument, false);\n            if (typeof it == 'string' && it.length > 2) {\n                it = TRIM ? it.trim() : $trim(it, 3);\n                var first = it.charCodeAt(0);\n                var third, radix, maxCode;\n                if (first === 43 || first === 45) {\n                    third = it.charCodeAt(2);\n                    if (third === 88 || third === 120) return NaN; // Number('+0x1') should be NaN, old V8 fix\n                } else if (first === 48) {\n                    switch (it.charCodeAt(1)) {\n                        case 66: case 98: radix = 2; maxCode = 49; break; // fast equal /^0b[01]+$/i\n                        case 79: case 111: radix = 8; maxCode = 55; break; // fast equal /^0o[0-7]+$/i\n                        default: return +it;\n                    }\n                    for (var digits = it.slice(2), i = 0, l = digits.length, code; i < l; i++) {\n                        code = digits.charCodeAt(i);\n                        // parseInt parses a string to a first unavailable symbol\n                        // but ToNumber should return NaN if a string contains unavailable symbols\n                        if (code < 48 || code > maxCode) return NaN;\n                    } return parseInt(digits, radix);\n                }\n            } return +it;\n        };\n\n        if (!$Number(' 0o1') || !$Number('0b1') || $Number('+0x1')) {\n            $Number = function Number(value) {\n                var it = arguments.length < 1 ? 0 : value;\n                var that = this;\n                return that instanceof $Number\n                // check on 1..constructor(foo) case\n                && (BROKEN_COF ? fails(function () { proto.valueOf.call(that); }) : cof(that) != NUMBER)\n                    ? inheritIfRequired(new Base(toNumber(it)), that, $Number) : toNumber(it);\n            };\n            for (var keys = _dereq_(29) ? gOPN(Base) : (\n                // ES3:\n                'MAX_VALUE,MIN_VALUE,NaN,NEGATIVE_INFINITY,POSITIVE_INFINITY,' +\n                // ES6 (in case, if modules with ES6 Number statics required before):\n                'EPSILON,isFinite,isInteger,isNaN,isSafeInteger,MAX_SAFE_INTEGER,' +\n                'MIN_SAFE_INTEGER,parseFloat,parseInt,isInteger'\n            ).split(','), j = 0, key; keys.length > j; j++) {\n                if (has(Base, key = keys[j]) && !has($Number, key)) {\n                    dP($Number, key, gOPD(Base, key));\n                }\n            }\n            $Number.prototype = proto;\n            proto.constructor = $Number;\n            _dereq_(94)(global, NUMBER, $Number);\n        }\n\n    },{\"111\":111,\"120\":120,\"18\":18,\"29\":29,\"35\":35,\"40\":40,\"41\":41,\"45\":45,\"71\":71,\"72\":72,\"75\":75,\"77\":77,\"94\":94}],179:[function(_dereq_,module,exports){\n// 20.1.2.1 Number.EPSILON\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Number', { EPSILON: Math.pow(2, -52) });\n\n    },{\"33\":33}],180:[function(_dereq_,module,exports){\n// 20.1.2.2 Number.isFinite(number)\n        var $export = _dereq_(33);\n        var _isFinite = _dereq_(40).isFinite;\n\n        $export($export.S, 'Number', {\n            isFinite: function isFinite(it) {\n                return typeof it == 'number' && _isFinite(it);\n            }\n        });\n\n    },{\"33\":33,\"40\":40}],181:[function(_dereq_,module,exports){\n// 20.1.2.3 Number.isInteger(number)\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Number', { isInteger: _dereq_(50) });\n\n    },{\"33\":33,\"50\":50}],182:[function(_dereq_,module,exports){\n// 20.1.2.4 Number.isNaN(number)\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Number', {\n            isNaN: function isNaN(number) {\n                // eslint-disable-next-line no-self-compare\n                return number != number;\n            }\n        });\n\n    },{\"33\":33}],183:[function(_dereq_,module,exports){\n// 20.1.2.5 Number.isSafeInteger(number)\n        var $export = _dereq_(33);\n        var isInteger = _dereq_(50);\n        var abs = Math.abs;\n\n        $export($export.S, 'Number', {\n            isSafeInteger: function isSafeInteger(number) {\n                return isInteger(number) && abs(number) <= 0x1fffffffffffff;\n            }\n        });\n\n    },{\"33\":33,\"50\":50}],184:[function(_dereq_,module,exports){\n// 20.1.2.6 Number.MAX_SAFE_INTEGER\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Number', { MAX_SAFE_INTEGER: 0x1fffffffffffff });\n\n    },{\"33\":33}],185:[function(_dereq_,module,exports){\n// 20.1.2.10 Number.MIN_SAFE_INTEGER\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Number', { MIN_SAFE_INTEGER: -0x1fffffffffffff });\n\n    },{\"33\":33}],186:[function(_dereq_,module,exports){\n        var $export = _dereq_(33);\n        var $parseFloat = _dereq_(86);\n// 20.1.2.12 Number.parseFloat(string)\n        $export($export.S + $export.F * (Number.parseFloat != $parseFloat), 'Number', { parseFloat: $parseFloat });\n\n    },{\"33\":33,\"86\":86}],187:[function(_dereq_,module,exports){\n        var $export = _dereq_(33);\n        var $parseInt = _dereq_(87);\n// 20.1.2.13 Number.parseInt(string, radix)\n        $export($export.S + $export.F * (Number.parseInt != $parseInt), 'Number', { parseInt: $parseInt });\n\n    },{\"33\":33,\"87\":87}],188:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var toInteger = _dereq_(116);\n        var aNumberValue = _dereq_(4);\n        var repeat = _dereq_(110);\n        var $toFixed = 1.0.toFixed;\n        var floor = Math.floor;\n        var data = [0, 0, 0, 0, 0, 0];\n        var ERROR = 'Number.toFixed: incorrect invocation!';\n        var ZERO = '0';\n\n        var multiply = function (n, c) {\n            var i = -1;\n            var c2 = c;\n            while (++i < 6) {\n                c2 += n * data[i];\n                data[i] = c2 % 1e7;\n                c2 = floor(c2 / 1e7);\n            }\n        };\n        var divide = function (n) {\n            var i = 6;\n            var c = 0;\n            while (--i >= 0) {\n                c += data[i];\n                data[i] = floor(c / n);\n                c = (c % n) * 1e7;\n            }\n        };\n        var numToString = function () {\n            var i = 6;\n            var s = '';\n            while (--i >= 0) {\n                if (s !== '' || i === 0 || data[i] !== 0) {\n                    var t = String(data[i]);\n                    s = s === '' ? t : s + repeat.call(ZERO, 7 - t.length) + t;\n                }\n            } return s;\n        };\n        var pow = function (x, n, acc) {\n            return n === 0 ? acc : n % 2 === 1 ? pow(x, n - 1, acc * x) : pow(x * x, n / 2, acc);\n        };\n        var log = function (x) {\n            var n = 0;\n            var x2 = x;\n            while (x2 >= 4096) {\n                n += 12;\n                x2 /= 4096;\n            }\n            while (x2 >= 2) {\n                n += 1;\n                x2 /= 2;\n            } return n;\n        };\n\n        $export($export.P + $export.F * (!!$toFixed && (\n            0.00008.toFixed(3) !== '0.000' ||\n            0.9.toFixed(0) !== '1' ||\n            1.255.toFixed(2) !== '1.25' ||\n            1000000000000000128.0.toFixed(0) !== '1000000000000000128'\n        ) || !_dereq_(35)(function () {\n            // V8 ~ Android 4.3-\n            $toFixed.call({});\n        })), 'Number', {\n            toFixed: function toFixed(fractionDigits) {\n                var x = aNumberValue(this, ERROR);\n                var f = toInteger(fractionDigits);\n                var s = '';\n                var m = ZERO;\n                var e, z, j, k;\n                if (f < 0 || f > 20) throw RangeError(ERROR);\n                // eslint-disable-next-line no-self-compare\n                if (x != x) return 'NaN';\n                if (x <= -1e21 || x >= 1e21) return String(x);\n                if (x < 0) {\n                    s = '-';\n                    x = -x;\n                }\n                if (x > 1e-21) {\n                    e = log(x * pow(2, 69, 1)) - 69;\n                    z = e < 0 ? x * pow(2, -e, 1) : x / pow(2, e, 1);\n                    z *= 0x10000000000000;\n                    e = 52 - e;\n                    if (e > 0) {\n                        multiply(0, z);\n                        j = f;\n                        while (j >= 7) {\n                            multiply(1e7, 0);\n                            j -= 7;\n                        }\n                        multiply(pow(10, j, 1), 0);\n                        j = e - 1;\n                        while (j >= 23) {\n                            divide(1 << 23);\n                            j -= 23;\n                        }\n                        divide(1 << j);\n                        multiply(1, 1);\n                        divide(2);\n                        m = numToString();\n                    } else {\n                        multiply(0, z);\n                        multiply(1 << -e, 0);\n                        m = numToString() + repeat.call(ZERO, f);\n                    }\n                }\n                if (f > 0) {\n                    k = m.length;\n                    m = s + (k <= f ? '0.' + repeat.call(ZERO, f - k) + m : m.slice(0, k - f) + '.' + m.slice(k - f));\n                } else {\n                    m = s + m;\n                } return m;\n            }\n        });\n\n    },{\"110\":110,\"116\":116,\"33\":33,\"35\":35,\"4\":4}],189:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var $fails = _dereq_(35);\n        var aNumberValue = _dereq_(4);\n        var $toPrecision = 1.0.toPrecision;\n\n        $export($export.P + $export.F * ($fails(function () {\n            // IE7-\n            return $toPrecision.call(1, undefined) !== '1';\n        }) || !$fails(function () {\n            // V8 ~ Android 4.3-\n            $toPrecision.call({});\n        })), 'Number', {\n            toPrecision: function toPrecision(precision) {\n                var that = aNumberValue(this, 'Number#toPrecision: incorrect invocation!');\n                return precision === undefined ? $toPrecision.call(that) : $toPrecision.call(that, precision);\n            }\n        });\n\n    },{\"33\":33,\"35\":35,\"4\":4}],190:[function(_dereq_,module,exports){\n// 19.1.3.1 Object.assign(target, source)\n        var $export = _dereq_(33);\n\n        $export($export.S + $export.F, 'Object', { assign: _dereq_(70) });\n\n    },{\"33\":33,\"70\":70}],191:[function(_dereq_,module,exports){\n        var $export = _dereq_(33);\n// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])\n        $export($export.S, 'Object', { create: _dereq_(71) });\n\n    },{\"33\":33,\"71\":71}],192:[function(_dereq_,module,exports){\n        var $export = _dereq_(33);\n// 19.1.2.3 / 15.2.3.7 Object.defineProperties(O, Properties)\n        $export($export.S + $export.F * !_dereq_(29), 'Object', { defineProperties: _dereq_(73) });\n\n    },{\"29\":29,\"33\":33,\"73\":73}],193:[function(_dereq_,module,exports){\n        var $export = _dereq_(33);\n// 19.1.2.4 / 15.2.3.6 Object.defineProperty(O, P, Attributes)\n        $export($export.S + $export.F * !_dereq_(29), 'Object', { defineProperty: _dereq_(72).f });\n\n    },{\"29\":29,\"33\":33,\"72\":72}],194:[function(_dereq_,module,exports){\n// 19.1.2.5 Object.freeze(O)\n        var isObject = _dereq_(51);\n        var meta = _dereq_(66).onFreeze;\n\n        _dereq_(83)('freeze', function ($freeze) {\n            return function freeze(it) {\n                return $freeze && isObject(it) ? $freeze(meta(it)) : it;\n            };\n        });\n\n    },{\"51\":51,\"66\":66,\"83\":83}],195:[function(_dereq_,module,exports){\n// 19.1.2.6 Object.getOwnPropertyDescriptor(O, P)\n        var toIObject = _dereq_(117);\n        var $getOwnPropertyDescriptor = _dereq_(75).f;\n\n        _dereq_(83)('getOwnPropertyDescriptor', function () {\n            return function getOwnPropertyDescriptor(it, key) {\n                return $getOwnPropertyDescriptor(toIObject(it), key);\n            };\n        });\n\n    },{\"117\":117,\"75\":75,\"83\":83}],196:[function(_dereq_,module,exports){\n// 19.1.2.7 Object.getOwnPropertyNames(O)\n        _dereq_(83)('getOwnPropertyNames', function () {\n            return _dereq_(76).f;\n        });\n\n    },{\"76\":76,\"83\":83}],197:[function(_dereq_,module,exports){\n// 19.1.2.9 Object.getPrototypeOf(O)\n        var toObject = _dereq_(119);\n        var $getPrototypeOf = _dereq_(79);\n\n        _dereq_(83)('getPrototypeOf', function () {\n            return function getPrototypeOf(it) {\n                return $getPrototypeOf(toObject(it));\n            };\n        });\n\n    },{\"119\":119,\"79\":79,\"83\":83}],198:[function(_dereq_,module,exports){\n// 19.1.2.11 Object.isExtensible(O)\n        var isObject = _dereq_(51);\n\n        _dereq_(83)('isExtensible', function ($isExtensible) {\n            return function isExtensible(it) {\n                return isObject(it) ? $isExtensible ? $isExtensible(it) : true : false;\n            };\n        });\n\n    },{\"51\":51,\"83\":83}],199:[function(_dereq_,module,exports){\n// 19.1.2.12 Object.isFrozen(O)\n        var isObject = _dereq_(51);\n\n        _dereq_(83)('isFrozen', function ($isFrozen) {\n            return function isFrozen(it) {\n                return isObject(it) ? $isFrozen ? $isFrozen(it) : false : true;\n            };\n        });\n\n    },{\"51\":51,\"83\":83}],200:[function(_dereq_,module,exports){\n// 19.1.2.13 Object.isSealed(O)\n        var isObject = _dereq_(51);\n\n        _dereq_(83)('isSealed', function ($isSealed) {\n            return function isSealed(it) {\n                return isObject(it) ? $isSealed ? $isSealed(it) : false : true;\n            };\n        });\n\n    },{\"51\":51,\"83\":83}],201:[function(_dereq_,module,exports){\n// 19.1.3.10 Object.is(value1, value2)\n        var $export = _dereq_(33);\n        $export($export.S, 'Object', { is: _dereq_(96) });\n\n    },{\"33\":33,\"96\":96}],202:[function(_dereq_,module,exports){\n// 19.1.2.14 Object.keys(O)\n        var toObject = _dereq_(119);\n        var $keys = _dereq_(81);\n\n        _dereq_(83)('keys', function () {\n            return function keys(it) {\n                return $keys(toObject(it));\n            };\n        });\n\n    },{\"119\":119,\"81\":81,\"83\":83}],203:[function(_dereq_,module,exports){\n// 19.1.2.15 Object.preventExtensions(O)\n        var isObject = _dereq_(51);\n        var meta = _dereq_(66).onFreeze;\n\n        _dereq_(83)('preventExtensions', function ($preventExtensions) {\n            return function preventExtensions(it) {\n                return $preventExtensions && isObject(it) ? $preventExtensions(meta(it)) : it;\n            };\n        });\n\n    },{\"51\":51,\"66\":66,\"83\":83}],204:[function(_dereq_,module,exports){\n// 19.1.2.17 Object.seal(O)\n        var isObject = _dereq_(51);\n        var meta = _dereq_(66).onFreeze;\n\n        _dereq_(83)('seal', function ($seal) {\n            return function seal(it) {\n                return $seal && isObject(it) ? $seal(meta(it)) : it;\n            };\n        });\n\n    },{\"51\":51,\"66\":66,\"83\":83}],205:[function(_dereq_,module,exports){\n// 19.1.3.19 Object.setPrototypeOf(O, proto)\n        var $export = _dereq_(33);\n        $export($export.S, 'Object', { setPrototypeOf: _dereq_(99).set });\n\n    },{\"33\":33,\"99\":99}],206:[function(_dereq_,module,exports){\n        'use strict';\n// 19.1.3.6 Object.prototype.toString()\n        var classof = _dereq_(17);\n        var test = {};\n        test[_dereq_(128)('toStringTag')] = 'z';\n        if (test + '' != '[object z]') {\n            _dereq_(94)(Object.prototype, 'toString', function toString() {\n                return '[object ' + classof(this) + ']';\n            }, true);\n        }\n\n    },{\"128\":128,\"17\":17,\"94\":94}],207:[function(_dereq_,module,exports){\n        var $export = _dereq_(33);\n        var $parseFloat = _dereq_(86);\n// 18.2.4 parseFloat(string)\n        $export($export.G + $export.F * (parseFloat != $parseFloat), { parseFloat: $parseFloat });\n\n    },{\"33\":33,\"86\":86}],208:[function(_dereq_,module,exports){\n        var $export = _dereq_(33);\n        var $parseInt = _dereq_(87);\n// 18.2.5 parseInt(string, radix)\n        $export($export.G + $export.F * (parseInt != $parseInt), { parseInt: $parseInt });\n\n    },{\"33\":33,\"87\":87}],209:[function(_dereq_,module,exports){\n        'use strict';\n        var LIBRARY = _dereq_(60);\n        var global = _dereq_(40);\n        var ctx = _dereq_(25);\n        var classof = _dereq_(17);\n        var $export = _dereq_(33);\n        var isObject = _dereq_(51);\n        var aFunction = _dereq_(3);\n        var anInstance = _dereq_(6);\n        var forOf = _dereq_(39);\n        var speciesConstructor = _dereq_(104);\n        var task = _dereq_(113).set;\n        var microtask = _dereq_(68)();\n        var newPromiseCapabilityModule = _dereq_(69);\n        var perform = _dereq_(90);\n        var promiseResolve = _dereq_(91);\n        var PROMISE = 'Promise';\n        var TypeError = global.TypeError;\n        var process = global.process;\n        var $Promise = global[PROMISE];\n        var isNode = classof(process) == 'process';\n        var empty = function () { /* empty */ };\n        var Internal, newGenericPromiseCapability, OwnPromiseCapability, Wrapper;\n        var newPromiseCapability = newGenericPromiseCapability = newPromiseCapabilityModule.f;\n\n        var USE_NATIVE = !!function () {\n            try {\n                // correct subclassing with @@species support\n                var promise = $Promise.resolve(1);\n                var FakePromise = (promise.constructor = {})[_dereq_(128)('species')] = function (exec) {\n                    exec(empty, empty);\n                };\n                // unhandled rejections tracking support, NodeJS Promise without it fails @@species test\n                return (isNode || typeof PromiseRejectionEvent == 'function') && promise.then(empty) instanceof FakePromise;\n            } catch (e) { /* empty */ }\n        }();\n\n// helpers\n        var sameConstructor = LIBRARY ? function (a, b) {\n            // with library wrapper special case\n            return a === b || a === $Promise && b === Wrapper;\n        } : function (a, b) {\n            return a === b;\n        };\n        var isThenable = function (it) {\n            var then;\n            return isObject(it) && typeof (then = it.then) == 'function' ? then : false;\n        };\n        var notify = function (promise, isReject) {\n            if (promise._n) return;\n            promise._n = true;\n            var chain = promise._c;\n            microtask(function () {\n                var value = promise._v;\n                var ok = promise._s == 1;\n                var i = 0;\n                var run = function (reaction) {\n                    var handler = ok ? reaction.ok : reaction.fail;\n                    var resolve = reaction.resolve;\n                    var reject = reaction.reject;\n                    var domain = reaction.domain;\n                    var result, then;\n                    try {\n                        if (handler) {\n                            if (!ok) {\n                                if (promise._h == 2) onHandleUnhandled(promise);\n                                promise._h = 1;\n                            }\n                            if (handler === true) result = value;\n                            else {\n                                if (domain) domain.enter();\n                                result = handler(value);\n                                if (domain) domain.exit();\n                            }\n                            if (result === reaction.promise) {\n                                reject(TypeError('Promise-chain cycle'));\n                            } else if (then = isThenable(result)) {\n                                then.call(result, resolve, reject);\n                            } else resolve(result);\n                        } else reject(value);\n                    } catch (e) {\n                        reject(e);\n                    }\n                };\n                while (chain.length > i) run(chain[i++]); // variable length - can't use forEach\n                promise._c = [];\n                promise._n = false;\n                if (isReject && !promise._h) onUnhandled(promise);\n            });\n        };\n        var onUnhandled = function (promise) {\n            task.call(global, function () {\n                var value = promise._v;\n                var unhandled = isUnhandled(promise);\n                var result, handler, console;\n                if (unhandled) {\n                    result = perform(function () {\n                        if (isNode) {\n                            process.emit('unhandledRejection', value, promise);\n                        } else if (handler = global.onunhandledrejection) {\n                            handler({ promise: promise, reason: value });\n                        } else if ((console = global.console) && console.error) {\n                            console.error('Unhandled promise rejection', value);\n                        }\n                    });\n                    // Browsers should not trigger `rejectionHandled` event if it was handled here, NodeJS - should\n                    promise._h = isNode || isUnhandled(promise) ? 2 : 1;\n                } promise._a = undefined;\n                if (unhandled && result.e) throw result.v;\n            });\n        };\n        var isUnhandled = function (promise) {\n            if (promise._h == 1) return false;\n            var chain = promise._a || promise._c;\n            var i = 0;\n            var reaction;\n            while (chain.length > i) {\n                reaction = chain[i++];\n                if (reaction.fail || !isUnhandled(reaction.promise)) return false;\n            } return true;\n        };\n        var onHandleUnhandled = function (promise) {\n            task.call(global, function () {\n                var handler;\n                if (isNode) {\n                    process.emit('rejectionHandled', promise);\n                } else if (handler = global.onrejectionhandled) {\n                    handler({ promise: promise, reason: promise._v });\n                }\n            });\n        };\n        var $reject = function (value) {\n            var promise = this;\n            if (promise._d) return;\n            promise._d = true;\n            promise = promise._w || promise; // unwrap\n            promise._v = value;\n            promise._s = 2;\n            if (!promise._a) promise._a = promise._c.slice();\n            notify(promise, true);\n        };\n        var $resolve = function (value) {\n            var promise = this;\n            var then;\n            if (promise._d) return;\n            promise._d = true;\n            promise = promise._w || promise; // unwrap\n            try {\n                if (promise === value) throw TypeError(\"Promise can't be resolved itself\");\n                if (then = isThenable(value)) {\n                    microtask(function () {\n                        var wrapper = { _w: promise, _d: false }; // wrap\n                        try {\n                            then.call(value, ctx($resolve, wrapper, 1), ctx($reject, wrapper, 1));\n                        } catch (e) {\n                            $reject.call(wrapper, e);\n                        }\n                    });\n                } else {\n                    promise._v = value;\n                    promise._s = 1;\n                    notify(promise, false);\n                }\n            } catch (e) {\n                $reject.call({ _w: promise, _d: false }, e); // wrap\n            }\n        };\n\n// constructor polyfill\n        if (!USE_NATIVE) {\n            // 25.4.3.1 Promise(executor)\n            $Promise = function Promise(executor) {\n                anInstance(this, $Promise, PROMISE, '_h');\n                aFunction(executor);\n                Internal.call(this);\n                try {\n                    executor(ctx($resolve, this, 1), ctx($reject, this, 1));\n                } catch (err) {\n                    $reject.call(this, err);\n                }\n            };\n            // eslint-disable-next-line no-unused-vars\n            Internal = function Promise(executor) {\n                this._c = [];             // <- awaiting reactions\n                this._a = undefined;      // <- checked in isUnhandled reactions\n                this._s = 0;              // <- state\n                this._d = false;          // <- done\n                this._v = undefined;      // <- value\n                this._h = 0;              // <- rejection state, 0 - default, 1 - handled, 2 - unhandled\n                this._n = false;          // <- notify\n            };\n            Internal.prototype = _dereq_(93)($Promise.prototype, {\n                // 25.4.5.3 Promise.prototype.then(onFulfilled, onRejected)\n                then: function then(onFulfilled, onRejected) {\n                    var reaction = newPromiseCapability(speciesConstructor(this, $Promise));\n                    reaction.ok = typeof onFulfilled == 'function' ? onFulfilled : true;\n                    reaction.fail = typeof onRejected == 'function' && onRejected;\n                    reaction.domain = isNode ? process.domain : undefined;\n                    this._c.push(reaction);\n                    if (this._a) this._a.push(reaction);\n                    if (this._s) notify(this, false);\n                    return reaction.promise;\n                },\n                // 25.4.5.1 Promise.prototype.catch(onRejected)\n                'catch': function (onRejected) {\n                    return this.then(undefined, onRejected);\n                }\n            });\n            OwnPromiseCapability = function () {\n                var promise = new Internal();\n                this.promise = promise;\n                this.resolve = ctx($resolve, promise, 1);\n                this.reject = ctx($reject, promise, 1);\n            };\n            newPromiseCapabilityModule.f = newPromiseCapability = function (C) {\n                return sameConstructor($Promise, C)\n                    ? new OwnPromiseCapability(C)\n                    : newGenericPromiseCapability(C);\n            };\n        }\n\n        $export($export.G + $export.W + $export.F * !USE_NATIVE, { Promise: $Promise });\n        _dereq_(101)($Promise, PROMISE);\n        _dereq_(100)(PROMISE);\n        Wrapper = _dereq_(23)[PROMISE];\n\n// statics\n        $export($export.S + $export.F * !USE_NATIVE, PROMISE, {\n            // 25.4.4.5 Promise.reject(r)\n            reject: function reject(r) {\n                var capability = newPromiseCapability(this);\n                var $$reject = capability.reject;\n                $$reject(r);\n                return capability.promise;\n            }\n        });\n        $export($export.S + $export.F * (LIBRARY || !USE_NATIVE), PROMISE, {\n            // 25.4.4.6 Promise.resolve(x)\n            resolve: function resolve(x) {\n                // instanceof instead of internal slot check because we should fix it without replacement native Promise core\n                if (x instanceof $Promise && sameConstructor(x.constructor, this)) return x;\n                return promiseResolve(this, x);\n            }\n        });\n        $export($export.S + $export.F * !(USE_NATIVE && _dereq_(56)(function (iter) {\n            $Promise.all(iter)['catch'](empty);\n        })), PROMISE, {\n            // 25.4.4.1 Promise.all(iterable)\n            all: function all(iterable) {\n                var C = this;\n                var capability = newPromiseCapability(C);\n                var resolve = capability.resolve;\n                var reject = capability.reject;\n                var result = perform(function () {\n                    var values = [];\n                    var index = 0;\n                    var remaining = 1;\n                    forOf(iterable, false, function (promise) {\n                        var $index = index++;\n                        var alreadyCalled = false;\n                        values.push(undefined);\n                        remaining++;\n                        C.resolve(promise).then(function (value) {\n                            if (alreadyCalled) return;\n                            alreadyCalled = true;\n                            values[$index] = value;\n                            --remaining || resolve(values);\n                        }, reject);\n                    });\n                    --remaining || resolve(values);\n                });\n                if (result.e) reject(result.v);\n                return capability.promise;\n            },\n            // 25.4.4.4 Promise.race(iterable)\n            race: function race(iterable) {\n                var C = this;\n                var capability = newPromiseCapability(C);\n                var reject = capability.reject;\n                var result = perform(function () {\n                    forOf(iterable, false, function (promise) {\n                        C.resolve(promise).then(capability.resolve, reject);\n                    });\n                });\n                if (result.e) reject(result.v);\n                return capability.promise;\n            }\n        });\n\n    },{\"100\":100,\"101\":101,\"104\":104,\"113\":113,\"128\":128,\"17\":17,\"23\":23,\"25\":25,\"3\":3,\"33\":33,\"39\":39,\"40\":40,\"51\":51,\"56\":56,\"6\":6,\"60\":60,\"68\":68,\"69\":69,\"90\":90,\"91\":91,\"93\":93}],210:[function(_dereq_,module,exports){\n// 26.1.1 Reflect.apply(target, thisArgument, argumentsList)\n        var $export = _dereq_(33);\n        var aFunction = _dereq_(3);\n        var anObject = _dereq_(7);\n        var rApply = (_dereq_(40).Reflect || {}).apply;\n        var fApply = Function.apply;\n// MS Edge argumentsList argument is optional\n        $export($export.S + $export.F * !_dereq_(35)(function () {\n            rApply(function () { /* empty */ });\n        }), 'Reflect', {\n            apply: function apply(target, thisArgument, argumentsList) {\n                var T = aFunction(target);\n                var L = anObject(argumentsList);\n                return rApply ? rApply(T, thisArgument, L) : fApply.call(T, thisArgument, L);\n            }\n        });\n\n    },{\"3\":3,\"33\":33,\"35\":35,\"40\":40,\"7\":7}],211:[function(_dereq_,module,exports){\n// 26.1.2 Reflect.construct(target, argumentsList [, newTarget])\n        var $export = _dereq_(33);\n        var create = _dereq_(71);\n        var aFunction = _dereq_(3);\n        var anObject = _dereq_(7);\n        var isObject = _dereq_(51);\n        var fails = _dereq_(35);\n        var bind = _dereq_(16);\n        var rConstruct = (_dereq_(40).Reflect || {}).construct;\n\n// MS Edge supports only 2 arguments and argumentsList argument is optional\n// FF Nightly sets third argument as `new.target`, but does not create `this` from it\n        var NEW_TARGET_BUG = fails(function () {\n            function F() { /* empty */ }\n            return !(rConstruct(function () { /* empty */ }, [], F) instanceof F);\n        });\n        var ARGS_BUG = !fails(function () {\n            rConstruct(function () { /* empty */ });\n        });\n\n        $export($export.S + $export.F * (NEW_TARGET_BUG || ARGS_BUG), 'Reflect', {\n            construct: function construct(Target, args /* , newTarget */) {\n                aFunction(Target);\n                anObject(args);\n                var newTarget = arguments.length < 3 ? Target : aFunction(arguments[2]);\n                if (ARGS_BUG && !NEW_TARGET_BUG) return rConstruct(Target, args, newTarget);\n                if (Target == newTarget) {\n                    // w/o altered newTarget, optimization for 0-4 arguments\n                    switch (args.length) {\n                        case 0: return new Target();\n                        case 1: return new Target(args[0]);\n                        case 2: return new Target(args[0], args[1]);\n                        case 3: return new Target(args[0], args[1], args[2]);\n                        case 4: return new Target(args[0], args[1], args[2], args[3]);\n                    }\n                    // w/o altered newTarget, lot of arguments case\n                    var $args = [null];\n                    $args.push.apply($args, args);\n                    return new (bind.apply(Target, $args))();\n                }\n                // with altered newTarget, not support built-in constructors\n                var proto = newTarget.prototype;\n                var instance = create(isObject(proto) ? proto : Object.prototype);\n                var result = Function.apply.call(Target, instance, args);\n                return isObject(result) ? result : instance;\n            }\n        });\n\n    },{\"16\":16,\"3\":3,\"33\":33,\"35\":35,\"40\":40,\"51\":51,\"7\":7,\"71\":71}],212:[function(_dereq_,module,exports){\n// 26.1.3 Reflect.defineProperty(target, propertyKey, attributes)\n        var dP = _dereq_(72);\n        var $export = _dereq_(33);\n        var anObject = _dereq_(7);\n        var toPrimitive = _dereq_(120);\n\n// MS Edge has broken Reflect.defineProperty - throwing instead of returning false\n        $export($export.S + $export.F * _dereq_(35)(function () {\n            // eslint-disable-next-line no-undef\n            Reflect.defineProperty(dP.f({}, 1, { value: 1 }), 1, { value: 2 });\n        }), 'Reflect', {\n            defineProperty: function defineProperty(target, propertyKey, attributes) {\n                anObject(target);\n                propertyKey = toPrimitive(propertyKey, true);\n                anObject(attributes);\n                try {\n                    dP.f(target, propertyKey, attributes);\n                    return true;\n                } catch (e) {\n                    return false;\n                }\n            }\n        });\n\n    },{\"120\":120,\"33\":33,\"35\":35,\"7\":7,\"72\":72}],213:[function(_dereq_,module,exports){\n// 26.1.4 Reflect.deleteProperty(target, propertyKey)\n        var $export = _dereq_(33);\n        var gOPD = _dereq_(75).f;\n        var anObject = _dereq_(7);\n\n        $export($export.S, 'Reflect', {\n            deleteProperty: function deleteProperty(target, propertyKey) {\n                var desc = gOPD(anObject(target), propertyKey);\n                return desc && !desc.configurable ? false : delete target[propertyKey];\n            }\n        });\n\n    },{\"33\":33,\"7\":7,\"75\":75}],214:[function(_dereq_,module,exports){\n        'use strict';\n// 26.1.5 Reflect.enumerate(target)\n        var $export = _dereq_(33);\n        var anObject = _dereq_(7);\n        var Enumerate = function (iterated) {\n            this._t = anObject(iterated); // target\n            this._i = 0;                  // next index\n            var keys = this._k = [];      // keys\n            var key;\n            for (key in iterated) keys.push(key);\n        };\n        _dereq_(54)(Enumerate, 'Object', function () {\n            var that = this;\n            var keys = that._k;\n            var key;\n            do {\n                if (that._i >= keys.length) return { value: undefined, done: true };\n            } while (!((key = keys[that._i++]) in that._t));\n            return { value: key, done: false };\n        });\n\n        $export($export.S, 'Reflect', {\n            enumerate: function enumerate(target) {\n                return new Enumerate(target);\n            }\n        });\n\n    },{\"33\":33,\"54\":54,\"7\":7}],215:[function(_dereq_,module,exports){\n// 26.1.7 Reflect.getOwnPropertyDescriptor(target, propertyKey)\n        var gOPD = _dereq_(75);\n        var $export = _dereq_(33);\n        var anObject = _dereq_(7);\n\n        $export($export.S, 'Reflect', {\n            getOwnPropertyDescriptor: function getOwnPropertyDescriptor(target, propertyKey) {\n                return gOPD.f(anObject(target), propertyKey);\n            }\n        });\n\n    },{\"33\":33,\"7\":7,\"75\":75}],216:[function(_dereq_,module,exports){\n// 26.1.8 Reflect.getPrototypeOf(target)\n        var $export = _dereq_(33);\n        var getProto = _dereq_(79);\n        var anObject = _dereq_(7);\n\n        $export($export.S, 'Reflect', {\n            getPrototypeOf: function getPrototypeOf(target) {\n                return getProto(anObject(target));\n            }\n        });\n\n    },{\"33\":33,\"7\":7,\"79\":79}],217:[function(_dereq_,module,exports){\n// 26.1.6 Reflect.get(target, propertyKey [, receiver])\n        var gOPD = _dereq_(75);\n        var getPrototypeOf = _dereq_(79);\n        var has = _dereq_(41);\n        var $export = _dereq_(33);\n        var isObject = _dereq_(51);\n        var anObject = _dereq_(7);\n\n        function get(target, propertyKey /* , receiver */) {\n            var receiver = arguments.length < 3 ? target : arguments[2];\n            var desc, proto;\n            if (anObject(target) === receiver) return target[propertyKey];\n            if (desc = gOPD.f(target, propertyKey)) return has(desc, 'value')\n                ? desc.value\n                : desc.get !== undefined\n                    ? desc.get.call(receiver)\n                    : undefined;\n            if (isObject(proto = getPrototypeOf(target))) return get(proto, propertyKey, receiver);\n        }\n\n        $export($export.S, 'Reflect', { get: get });\n\n    },{\"33\":33,\"41\":41,\"51\":51,\"7\":7,\"75\":75,\"79\":79}],218:[function(_dereq_,module,exports){\n// 26.1.9 Reflect.has(target, propertyKey)\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Reflect', {\n            has: function has(target, propertyKey) {\n                return propertyKey in target;\n            }\n        });\n\n    },{\"33\":33}],219:[function(_dereq_,module,exports){\n// 26.1.10 Reflect.isExtensible(target)\n        var $export = _dereq_(33);\n        var anObject = _dereq_(7);\n        var $isExtensible = Object.isExtensible;\n\n        $export($export.S, 'Reflect', {\n            isExtensible: function isExtensible(target) {\n                anObject(target);\n                return $isExtensible ? $isExtensible(target) : true;\n            }\n        });\n\n    },{\"33\":33,\"7\":7}],220:[function(_dereq_,module,exports){\n// 26.1.11 Reflect.ownKeys(target)\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Reflect', { ownKeys: _dereq_(85) });\n\n    },{\"33\":33,\"85\":85}],221:[function(_dereq_,module,exports){\n// 26.1.12 Reflect.preventExtensions(target)\n        var $export = _dereq_(33);\n        var anObject = _dereq_(7);\n        var $preventExtensions = Object.preventExtensions;\n\n        $export($export.S, 'Reflect', {\n            preventExtensions: function preventExtensions(target) {\n                anObject(target);\n                try {\n                    if ($preventExtensions) $preventExtensions(target);\n                    return true;\n                } catch (e) {\n                    return false;\n                }\n            }\n        });\n\n    },{\"33\":33,\"7\":7}],222:[function(_dereq_,module,exports){\n// 26.1.14 Reflect.setPrototypeOf(target, proto)\n        var $export = _dereq_(33);\n        var setProto = _dereq_(99);\n\n        if (setProto) $export($export.S, 'Reflect', {\n            setPrototypeOf: function setPrototypeOf(target, proto) {\n                setProto.check(target, proto);\n                try {\n                    setProto.set(target, proto);\n                    return true;\n                } catch (e) {\n                    return false;\n                }\n            }\n        });\n\n    },{\"33\":33,\"99\":99}],223:[function(_dereq_,module,exports){\n// 26.1.13 Reflect.set(target, propertyKey, V [, receiver])\n        var dP = _dereq_(72);\n        var gOPD = _dereq_(75);\n        var getPrototypeOf = _dereq_(79);\n        var has = _dereq_(41);\n        var $export = _dereq_(33);\n        var createDesc = _dereq_(92);\n        var anObject = _dereq_(7);\n        var isObject = _dereq_(51);\n\n        function set(target, propertyKey, V /* , receiver */) {\n            var receiver = arguments.length < 4 ? target : arguments[3];\n            var ownDesc = gOPD.f(anObject(target), propertyKey);\n            var existingDescriptor, proto;\n            if (!ownDesc) {\n                if (isObject(proto = getPrototypeOf(target))) {\n                    return set(proto, propertyKey, V, receiver);\n                }\n                ownDesc = createDesc(0);\n            }\n            if (has(ownDesc, 'value')) {\n                if (ownDesc.writable === false || !isObject(receiver)) return false;\n                existingDescriptor = gOPD.f(receiver, propertyKey) || createDesc(0);\n                existingDescriptor.value = V;\n                dP.f(receiver, propertyKey, existingDescriptor);\n                return true;\n            }\n            return ownDesc.set === undefined ? false : (ownDesc.set.call(receiver, V), true);\n        }\n\n        $export($export.S, 'Reflect', { set: set });\n\n    },{\"33\":33,\"41\":41,\"51\":51,\"7\":7,\"72\":72,\"75\":75,\"79\":79,\"92\":92}],224:[function(_dereq_,module,exports){\n        var global = _dereq_(40);\n        var inheritIfRequired = _dereq_(45);\n        var dP = _dereq_(72).f;\n        var gOPN = _dereq_(77).f;\n        var isRegExp = _dereq_(52);\n        var $flags = _dereq_(37);\n        var $RegExp = global.RegExp;\n        var Base = $RegExp;\n        var proto = $RegExp.prototype;\n        var re1 = /a/g;\n        var re2 = /a/g;\n// \"new\" creates a new object, old webkit buggy here\n        var CORRECT_NEW = new $RegExp(re1) !== re1;\n\n        if (_dereq_(29) && (!CORRECT_NEW || _dereq_(35)(function () {\n            re2[_dereq_(128)('match')] = false;\n            // RegExp constructor can alter flags and IsRegExp works correct with @@match\n            return $RegExp(re1) != re1 || $RegExp(re2) == re2 || $RegExp(re1, 'i') != '/a/i';\n        }))) {\n            $RegExp = function RegExp(p, f) {\n                var tiRE = this instanceof $RegExp;\n                var piRE = isRegExp(p);\n                var fiU = f === undefined;\n                return !tiRE && piRE && p.constructor === $RegExp && fiU ? p\n                    : inheritIfRequired(CORRECT_NEW\n                        ? new Base(piRE && !fiU ? p.source : p, f)\n                        : Base((piRE = p instanceof $RegExp) ? p.source : p, piRE && fiU ? $flags.call(p) : f)\n                        , tiRE ? this : proto, $RegExp);\n            };\n            var proxy = function (key) {\n                key in $RegExp || dP($RegExp, key, {\n                    configurable: true,\n                    get: function () { return Base[key]; },\n                    set: function (it) { Base[key] = it; }\n                });\n            };\n            for (var keys = gOPN(Base), i = 0; keys.length > i;) proxy(keys[i++]);\n            proto.constructor = $RegExp;\n            $RegExp.prototype = proto;\n            _dereq_(94)(global, 'RegExp', $RegExp);\n        }\n\n        _dereq_(100)('RegExp');\n\n    },{\"100\":100,\"128\":128,\"29\":29,\"35\":35,\"37\":37,\"40\":40,\"45\":45,\"52\":52,\"72\":72,\"77\":77,\"94\":94}],225:[function(_dereq_,module,exports){\n// 21.2.5.3 get RegExp.prototype.flags()\n        if (_dereq_(29) && /./g.flags != 'g') _dereq_(72).f(RegExp.prototype, 'flags', {\n            configurable: true,\n            get: _dereq_(37)\n        });\n\n    },{\"29\":29,\"37\":37,\"72\":72}],226:[function(_dereq_,module,exports){\n// @@match logic\n        _dereq_(36)('match', 1, function (defined, MATCH, $match) {\n            // 21.1.3.11 String.prototype.match(regexp)\n            return [function match(regexp) {\n                'use strict';\n                var O = defined(this);\n                var fn = regexp == undefined ? undefined : regexp[MATCH];\n                return fn !== undefined ? fn.call(regexp, O) : new RegExp(regexp)[MATCH](String(O));\n            }, $match];\n        });\n\n    },{\"36\":36}],227:[function(_dereq_,module,exports){\n// @@replace logic\n        _dereq_(36)('replace', 2, function (defined, REPLACE, $replace) {\n            // 21.1.3.14 String.prototype.replace(searchValue, replaceValue)\n            return [function replace(searchValue, replaceValue) {\n                'use strict';\n                var O = defined(this);\n                var fn = searchValue == undefined ? undefined : searchValue[REPLACE];\n                return fn !== undefined\n                    ? fn.call(searchValue, O, replaceValue)\n                    : $replace.call(String(O), searchValue, replaceValue);\n            }, $replace];\n        });\n\n    },{\"36\":36}],228:[function(_dereq_,module,exports){\n// @@search logic\n        _dereq_(36)('search', 1, function (defined, SEARCH, $search) {\n            // 21.1.3.15 String.prototype.search(regexp)\n            return [function search(regexp) {\n                'use strict';\n                var O = defined(this);\n                var fn = regexp == undefined ? undefined : regexp[SEARCH];\n                return fn !== undefined ? fn.call(regexp, O) : new RegExp(regexp)[SEARCH](String(O));\n            }, $search];\n        });\n\n    },{\"36\":36}],229:[function(_dereq_,module,exports){\n// @@split logic\n        _dereq_(36)('split', 2, function (defined, SPLIT, $split) {\n            'use strict';\n            var isRegExp = _dereq_(52);\n            var _split = $split;\n            var $push = [].push;\n            var $SPLIT = 'split';\n            var LENGTH = 'length';\n            var LAST_INDEX = 'lastIndex';\n            if (\n                'abbc'[$SPLIT](/(b)*/)[1] == 'c' ||\n                'test'[$SPLIT](/(?:)/, -1)[LENGTH] != 4 ||\n                'ab'[$SPLIT](/(?:ab)*/)[LENGTH] != 2 ||\n                '.'[$SPLIT](/(.?)(.?)/)[LENGTH] != 4 ||\n                '.'[$SPLIT](/()()/)[LENGTH] > 1 ||\n                ''[$SPLIT](/.?/)[LENGTH]\n            ) {\n                var NPCG = /()??/.exec('')[1] === undefined; // nonparticipating capturing group\n                // based on es5-shim implementation, need to rework it\n                $split = function (separator, limit) {\n                    var string = String(this);\n                    if (separator === undefined && limit === 0) return [];\n                    // If `separator` is not a regex, use native split\n                    if (!isRegExp(separator)) return _split.call(string, separator, limit);\n                    var output = [];\n                    var flags = (separator.ignoreCase ? 'i' : '') +\n                        (separator.multiline ? 'm' : '') +\n                        (separator.unicode ? 'u' : '') +\n                        (separator.sticky ? 'y' : '');\n                    var lastLastIndex = 0;\n                    var splitLimit = limit === undefined ? 4294967295 : limit >>> 0;\n                    // Make `global` and avoid `lastIndex` issues by working with a copy\n                    var separatorCopy = new RegExp(separator.source, flags + 'g');\n                    var separator2, match, lastIndex, lastLength, i;\n                    // Doesn't need flags gy, but they don't hurt\n                    if (!NPCG) separator2 = new RegExp('^' + separatorCopy.source + '$(?!\\\\s)', flags);\n                    while (match = separatorCopy.exec(string)) {\n                        // `separatorCopy.lastIndex` is not reliable cross-browser\n                        lastIndex = match.index + match[0][LENGTH];\n                        if (lastIndex > lastLastIndex) {\n                            output.push(string.slice(lastLastIndex, match.index));\n                            // Fix browsers whose `exec` methods don't consistently return `undefined` for NPCG\n                            // eslint-disable-next-line no-loop-func\n                            if (!NPCG && match[LENGTH] > 1) match[0].replace(separator2, function () {\n                                for (i = 1; i < arguments[LENGTH] - 2; i++) if (arguments[i] === undefined) match[i] = undefined;\n                            });\n                            if (match[LENGTH] > 1 && match.index < string[LENGTH]) $push.apply(output, match.slice(1));\n                            lastLength = match[0][LENGTH];\n                            lastLastIndex = lastIndex;\n                            if (output[LENGTH] >= splitLimit) break;\n                        }\n                        if (separatorCopy[LAST_INDEX] === match.index) separatorCopy[LAST_INDEX]++; // Avoid an infinite loop\n                    }\n                    if (lastLastIndex === string[LENGTH]) {\n                        if (lastLength || !separatorCopy.test('')) output.push('');\n                    } else output.push(string.slice(lastLastIndex));\n                    return output[LENGTH] > splitLimit ? output.slice(0, splitLimit) : output;\n                };\n                // Chakra, V8\n            } else if ('0'[$SPLIT](undefined, 0)[LENGTH]) {\n                $split = function (separator, limit) {\n                    return separator === undefined && limit === 0 ? [] : _split.call(this, separator, limit);\n                };\n            }\n            // 21.1.3.17 String.prototype.split(separator, limit)\n            return [function split(separator, limit) {\n                var O = defined(this);\n                var fn = separator == undefined ? undefined : separator[SPLIT];\n                return fn !== undefined ? fn.call(separator, O, limit) : $split.call(String(O), separator, limit);\n            }, $split];\n        });\n\n    },{\"36\":36,\"52\":52}],230:[function(_dereq_,module,exports){\n        'use strict';\n        _dereq_(225);\n        var anObject = _dereq_(7);\n        var $flags = _dereq_(37);\n        var DESCRIPTORS = _dereq_(29);\n        var TO_STRING = 'toString';\n        var $toString = /./[TO_STRING];\n\n        var define = function (fn) {\n            _dereq_(94)(RegExp.prototype, TO_STRING, fn, true);\n        };\n\n// 21.2.5.14 RegExp.prototype.toString()\n        if (_dereq_(35)(function () { return $toString.call({ source: 'a', flags: 'b' }) != '/a/b'; })) {\n            define(function toString() {\n                var R = anObject(this);\n                return '/'.concat(R.source, '/',\n                    'flags' in R ? R.flags : !DESCRIPTORS && R instanceof RegExp ? $flags.call(R) : undefined);\n            });\n// FF44- RegExp#toString has a wrong name\n        } else if ($toString.name != TO_STRING) {\n            define(function toString() {\n                return $toString.call(this);\n            });\n        }\n\n    },{\"225\":225,\"29\":29,\"35\":35,\"37\":37,\"7\":7,\"94\":94}],231:[function(_dereq_,module,exports){\n        'use strict';\n        var strong = _dereq_(19);\n        var validate = _dereq_(125);\n        var SET = 'Set';\n\n// 23.2 Set Objects\n        module.exports = _dereq_(22)(SET, function (get) {\n            return function Set() { return get(this, arguments.length > 0 ? arguments[0] : undefined); };\n        }, {\n            // 23.2.3.1 Set.prototype.add(value)\n            add: function add(value) {\n                return strong.def(validate(this, SET), value = value === 0 ? 0 : value, value);\n            }\n        }, strong);\n\n    },{\"125\":125,\"19\":19,\"22\":22}],232:[function(_dereq_,module,exports){\n        'use strict';\n// B.2.3.2 String.prototype.anchor(name)\n        _dereq_(108)('anchor', function (createHTML) {\n            return function anchor(name) {\n                return createHTML(this, 'a', 'name', name);\n            };\n        });\n\n    },{\"108\":108}],233:[function(_dereq_,module,exports){\n        'use strict';\n// B.2.3.3 String.prototype.big()\n        _dereq_(108)('big', function (createHTML) {\n            return function big() {\n                return createHTML(this, 'big', '', '');\n            };\n        });\n\n    },{\"108\":108}],234:[function(_dereq_,module,exports){\n        'use strict';\n// B.2.3.4 String.prototype.blink()\n        _dereq_(108)('blink', function (createHTML) {\n            return function blink() {\n                return createHTML(this, 'blink', '', '');\n            };\n        });\n\n    },{\"108\":108}],235:[function(_dereq_,module,exports){\n        'use strict';\n// B.2.3.5 String.prototype.bold()\n        _dereq_(108)('bold', function (createHTML) {\n            return function bold() {\n                return createHTML(this, 'b', '', '');\n            };\n        });\n\n    },{\"108\":108}],236:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var $at = _dereq_(106)(false);\n        $export($export.P, 'String', {\n            // 21.1.3.3 String.prototype.codePointAt(pos)\n            codePointAt: function codePointAt(pos) {\n                return $at(this, pos);\n            }\n        });\n\n    },{\"106\":106,\"33\":33}],237:[function(_dereq_,module,exports){\n// 21.1.3.6 String.prototype.endsWith(searchString [, endPosition])\n        'use strict';\n        var $export = _dereq_(33);\n        var toLength = _dereq_(118);\n        var context = _dereq_(107);\n        var ENDS_WITH = 'endsWith';\n        var $endsWith = ''[ENDS_WITH];\n\n        $export($export.P + $export.F * _dereq_(34)(ENDS_WITH), 'String', {\n            endsWith: function endsWith(searchString /* , endPosition = @length */) {\n                var that = context(this, searchString, ENDS_WITH);\n                var endPosition = arguments.length > 1 ? arguments[1] : undefined;\n                var len = toLength(that.length);\n                var end = endPosition === undefined ? len : Math.min(toLength(endPosition), len);\n                var search = String(searchString);\n                return $endsWith\n                    ? $endsWith.call(that, search, end)\n                    : that.slice(end - search.length, end) === search;\n            }\n        });\n\n    },{\"107\":107,\"118\":118,\"33\":33,\"34\":34}],238:[function(_dereq_,module,exports){\n        'use strict';\n// B.2.3.6 String.prototype.fixed()\n        _dereq_(108)('fixed', function (createHTML) {\n            return function fixed() {\n                return createHTML(this, 'tt', '', '');\n            };\n        });\n\n    },{\"108\":108}],239:[function(_dereq_,module,exports){\n        'use strict';\n// B.2.3.7 String.prototype.fontcolor(color)\n        _dereq_(108)('fontcolor', function (createHTML) {\n            return function fontcolor(color) {\n                return createHTML(this, 'font', 'color', color);\n            };\n        });\n\n    },{\"108\":108}],240:[function(_dereq_,module,exports){\n        'use strict';\n// B.2.3.8 String.prototype.fontsize(size)\n        _dereq_(108)('fontsize', function (createHTML) {\n            return function fontsize(size) {\n                return createHTML(this, 'font', 'size', size);\n            };\n        });\n\n    },{\"108\":108}],241:[function(_dereq_,module,exports){\n        var $export = _dereq_(33);\n        var toAbsoluteIndex = _dereq_(114);\n        var fromCharCode = String.fromCharCode;\n        var $fromCodePoint = String.fromCodePoint;\n\n// length should be 1, old FF problem\n        $export($export.S + $export.F * (!!$fromCodePoint && $fromCodePoint.length != 1), 'String', {\n            // 21.1.2.2 String.fromCodePoint(...codePoints)\n            fromCodePoint: function fromCodePoint(x) { // eslint-disable-line no-unused-vars\n                var res = [];\n                var aLen = arguments.length;\n                var i = 0;\n                var code;\n                while (aLen > i) {\n                    code = +arguments[i++];\n                    if (toAbsoluteIndex(code, 0x10ffff) !== code) throw RangeError(code + ' is not a valid code point');\n                    res.push(code < 0x10000\n                        ? fromCharCode(code)\n                        : fromCharCode(((code -= 0x10000) >> 10) + 0xd800, code % 0x400 + 0xdc00)\n                    );\n                } return res.join('');\n            }\n        });\n\n    },{\"114\":114,\"33\":33}],242:[function(_dereq_,module,exports){\n// 21.1.3.7 String.prototype.includes(searchString, position = 0)\n        'use strict';\n        var $export = _dereq_(33);\n        var context = _dereq_(107);\n        var INCLUDES = 'includes';\n\n        $export($export.P + $export.F * _dereq_(34)(INCLUDES), 'String', {\n            includes: function includes(searchString /* , position = 0 */) {\n                return !!~context(this, searchString, INCLUDES)\n                    .indexOf(searchString, arguments.length > 1 ? arguments[1] : undefined);\n            }\n        });\n\n    },{\"107\":107,\"33\":33,\"34\":34}],243:[function(_dereq_,module,exports){\n        'use strict';\n// B.2.3.9 String.prototype.italics()\n        _dereq_(108)('italics', function (createHTML) {\n            return function italics() {\n                return createHTML(this, 'i', '', '');\n            };\n        });\n\n    },{\"108\":108}],244:[function(_dereq_,module,exports){\n        'use strict';\n        var $at = _dereq_(106)(true);\n\n// 21.1.3.27 String.prototype[@@iterator]()\n        _dereq_(55)(String, 'String', function (iterated) {\n            this._t = String(iterated); // target\n            this._i = 0;                // next index\n// 21.1.5.2.1 %StringIteratorPrototype%.next()\n        }, function () {\n            var O = this._t;\n            var index = this._i;\n            var point;\n            if (index >= O.length) return { value: undefined, done: true };\n            point = $at(O, index);\n            this._i += point.length;\n            return { value: point, done: false };\n        });\n\n    },{\"106\":106,\"55\":55}],245:[function(_dereq_,module,exports){\n        'use strict';\n// B.2.3.10 String.prototype.link(url)\n        _dereq_(108)('link', function (createHTML) {\n            return function link(url) {\n                return createHTML(this, 'a', 'href', url);\n            };\n        });\n\n    },{\"108\":108}],246:[function(_dereq_,module,exports){\n        var $export = _dereq_(33);\n        var toIObject = _dereq_(117);\n        var toLength = _dereq_(118);\n\n        $export($export.S, 'String', {\n            // 21.1.2.4 String.raw(callSite, ...substitutions)\n            raw: function raw(callSite) {\n                var tpl = toIObject(callSite.raw);\n                var len = toLength(tpl.length);\n                var aLen = arguments.length;\n                var res = [];\n                var i = 0;\n                while (len > i) {\n                    res.push(String(tpl[i++]));\n                    if (i < aLen) res.push(String(arguments[i]));\n                } return res.join('');\n            }\n        });\n\n    },{\"117\":117,\"118\":118,\"33\":33}],247:[function(_dereq_,module,exports){\n        var $export = _dereq_(33);\n\n        $export($export.P, 'String', {\n            // 21.1.3.13 String.prototype.repeat(count)\n            repeat: _dereq_(110)\n        });\n\n    },{\"110\":110,\"33\":33}],248:[function(_dereq_,module,exports){\n        'use strict';\n// B.2.3.11 String.prototype.small()\n        _dereq_(108)('small', function (createHTML) {\n            return function small() {\n                return createHTML(this, 'small', '', '');\n            };\n        });\n\n    },{\"108\":108}],249:[function(_dereq_,module,exports){\n// 21.1.3.18 String.prototype.startsWith(searchString [, position ])\n        'use strict';\n        var $export = _dereq_(33);\n        var toLength = _dereq_(118);\n        var context = _dereq_(107);\n        var STARTS_WITH = 'startsWith';\n        var $startsWith = ''[STARTS_WITH];\n\n        $export($export.P + $export.F * _dereq_(34)(STARTS_WITH), 'String', {\n            startsWith: function startsWith(searchString /* , position = 0 */) {\n                var that = context(this, searchString, STARTS_WITH);\n                var index = toLength(Math.min(arguments.length > 1 ? arguments[1] : undefined, that.length));\n                var search = String(searchString);\n                return $startsWith\n                    ? $startsWith.call(that, search, index)\n                    : that.slice(index, index + search.length) === search;\n            }\n        });\n\n    },{\"107\":107,\"118\":118,\"33\":33,\"34\":34}],250:[function(_dereq_,module,exports){\n        'use strict';\n// B.2.3.12 String.prototype.strike()\n        _dereq_(108)('strike', function (createHTML) {\n            return function strike() {\n                return createHTML(this, 'strike', '', '');\n            };\n        });\n\n    },{\"108\":108}],251:[function(_dereq_,module,exports){\n        'use strict';\n// B.2.3.13 String.prototype.sub()\n        _dereq_(108)('sub', function (createHTML) {\n            return function sub() {\n                return createHTML(this, 'sub', '', '');\n            };\n        });\n\n    },{\"108\":108}],252:[function(_dereq_,module,exports){\n        'use strict';\n// B.2.3.14 String.prototype.sup()\n        _dereq_(108)('sup', function (createHTML) {\n            return function sup() {\n                return createHTML(this, 'sup', '', '');\n            };\n        });\n\n    },{\"108\":108}],253:[function(_dereq_,module,exports){\n        'use strict';\n// 21.1.3.25 String.prototype.trim()\n        _dereq_(111)('trim', function ($trim) {\n            return function trim() {\n                return $trim(this, 3);\n            };\n        });\n\n    },{\"111\":111}],254:[function(_dereq_,module,exports){\n        'use strict';\n// ECMAScript 6 symbols shim\n        var global = _dereq_(40);\n        var has = _dereq_(41);\n        var DESCRIPTORS = _dereq_(29);\n        var $export = _dereq_(33);\n        var redefine = _dereq_(94);\n        var META = _dereq_(66).KEY;\n        var $fails = _dereq_(35);\n        var shared = _dereq_(103);\n        var setToStringTag = _dereq_(101);\n        var uid = _dereq_(124);\n        var wks = _dereq_(128);\n        var wksExt = _dereq_(127);\n        var wksDefine = _dereq_(126);\n        var keyOf = _dereq_(59);\n        var enumKeys = _dereq_(32);\n        var isArray = _dereq_(49);\n        var anObject = _dereq_(7);\n        var toIObject = _dereq_(117);\n        var toPrimitive = _dereq_(120);\n        var createDesc = _dereq_(92);\n        var _create = _dereq_(71);\n        var gOPNExt = _dereq_(76);\n        var $GOPD = _dereq_(75);\n        var $DP = _dereq_(72);\n        var $keys = _dereq_(81);\n        var gOPD = $GOPD.f;\n        var dP = $DP.f;\n        var gOPN = gOPNExt.f;\n        var $Symbol = global.Symbol;\n        var $JSON = global.JSON;\n        var _stringify = $JSON && $JSON.stringify;\n        var PROTOTYPE = 'prototype';\n        var HIDDEN = wks('_hidden');\n        var TO_PRIMITIVE = wks('toPrimitive');\n        var isEnum = {}.propertyIsEnumerable;\n        var SymbolRegistry = shared('symbol-registry');\n        var AllSymbols = shared('symbols');\n        var OPSymbols = shared('op-symbols');\n        var ObjectProto = Object[PROTOTYPE];\n        var USE_NATIVE = typeof $Symbol == 'function';\n        var QObject = global.QObject;\n// Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173\n        var setter = !QObject || !QObject[PROTOTYPE] || !QObject[PROTOTYPE].findChild;\n\n// fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687\n        var setSymbolDesc = DESCRIPTORS && $fails(function () {\n            return _create(dP({}, 'a', {\n                get: function () { return dP(this, 'a', { value: 7 }).a; }\n            })).a != 7;\n        }) ? function (it, key, D) {\n            var protoDesc = gOPD(ObjectProto, key);\n            if (protoDesc) delete ObjectProto[key];\n            dP(it, key, D);\n            if (protoDesc && it !== ObjectProto) dP(ObjectProto, key, protoDesc);\n        } : dP;\n\n        var wrap = function (tag) {\n            var sym = AllSymbols[tag] = _create($Symbol[PROTOTYPE]);\n            sym._k = tag;\n            return sym;\n        };\n\n        var isSymbol = USE_NATIVE && typeof $Symbol.iterator == 'symbol' ? function (it) {\n            return typeof it == 'symbol';\n        } : function (it) {\n            return it instanceof $Symbol;\n        };\n\n        var $defineProperty = function defineProperty(it, key, D) {\n            if (it === ObjectProto) $defineProperty(OPSymbols, key, D);\n            anObject(it);\n            key = toPrimitive(key, true);\n            anObject(D);\n            if (has(AllSymbols, key)) {\n                if (!D.enumerable) {\n                    if (!has(it, HIDDEN)) dP(it, HIDDEN, createDesc(1, {}));\n                    it[HIDDEN][key] = true;\n                } else {\n                    if (has(it, HIDDEN) && it[HIDDEN][key]) it[HIDDEN][key] = false;\n                    D = _create(D, { enumerable: createDesc(0, false) });\n                } return setSymbolDesc(it, key, D);\n            } return dP(it, key, D);\n        };\n        var $defineProperties = function defineProperties(it, P) {\n            anObject(it);\n            var keys = enumKeys(P = toIObject(P));\n            var i = 0;\n            var l = keys.length;\n            var key;\n            while (l > i) $defineProperty(it, key = keys[i++], P[key]);\n            return it;\n        };\n        var $create = function create(it, P) {\n            return P === undefined ? _create(it) : $defineProperties(_create(it), P);\n        };\n        var $propertyIsEnumerable = function propertyIsEnumerable(key) {\n            var E = isEnum.call(this, key = toPrimitive(key, true));\n            if (this === ObjectProto && has(AllSymbols, key) && !has(OPSymbols, key)) return false;\n            return E || !has(this, key) || !has(AllSymbols, key) || has(this, HIDDEN) && this[HIDDEN][key] ? E : true;\n        };\n        var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(it, key) {\n            it = toIObject(it);\n            key = toPrimitive(key, true);\n            if (it === ObjectProto && has(AllSymbols, key) && !has(OPSymbols, key)) return;\n            var D = gOPD(it, key);\n            if (D && has(AllSymbols, key) && !(has(it, HIDDEN) && it[HIDDEN][key])) D.enumerable = true;\n            return D;\n        };\n        var $getOwnPropertyNames = function getOwnPropertyNames(it) {\n            var names = gOPN(toIObject(it));\n            var result = [];\n            var i = 0;\n            var key;\n            while (names.length > i) {\n                if (!has(AllSymbols, key = names[i++]) && key != HIDDEN && key != META) result.push(key);\n            } return result;\n        };\n        var $getOwnPropertySymbols = function getOwnPropertySymbols(it) {\n            var IS_OP = it === ObjectProto;\n            var names = gOPN(IS_OP ? OPSymbols : toIObject(it));\n            var result = [];\n            var i = 0;\n            var key;\n            while (names.length > i) {\n                if (has(AllSymbols, key = names[i++]) && (IS_OP ? has(ObjectProto, key) : true)) result.push(AllSymbols[key]);\n            } return result;\n        };\n\n// 19.4.1.1 Symbol([description])\n        if (!USE_NATIVE) {\n            $Symbol = function Symbol() {\n                if (this instanceof $Symbol) throw TypeError('Symbol is not a constructor!');\n                var tag = uid(arguments.length > 0 ? arguments[0] : undefined);\n                var $set = function (value) {\n                    if (this === ObjectProto) $set.call(OPSymbols, value);\n                    if (has(this, HIDDEN) && has(this[HIDDEN], tag)) this[HIDDEN][tag] = false;\n                    setSymbolDesc(this, tag, createDesc(1, value));\n                };\n                if (DESCRIPTORS && setter) setSymbolDesc(ObjectProto, tag, { configurable: true, set: $set });\n                return wrap(tag);\n            };\n            redefine($Symbol[PROTOTYPE], 'toString', function toString() {\n                return this._k;\n            });\n\n            $GOPD.f = $getOwnPropertyDescriptor;\n            $DP.f = $defineProperty;\n            _dereq_(77).f = gOPNExt.f = $getOwnPropertyNames;\n            _dereq_(82).f = $propertyIsEnumerable;\n            _dereq_(78).f = $getOwnPropertySymbols;\n\n            if (DESCRIPTORS && !_dereq_(60)) {\n                redefine(ObjectProto, 'propertyIsEnumerable', $propertyIsEnumerable, true);\n            }\n\n            wksExt.f = function (name) {\n                return wrap(wks(name));\n            };\n        }\n\n        $export($export.G + $export.W + $export.F * !USE_NATIVE, { Symbol: $Symbol });\n\n        for (var es6Symbols = (\n            // 19.4.2.2, 19.4.2.3, 19.4.2.4, 19.4.2.6, 19.4.2.8, 19.4.2.9, 19.4.2.10, 19.4.2.11, 19.4.2.12, 19.4.2.13, 19.4.2.14\n            'hasInstance,isConcatSpreadable,iterator,match,replace,search,species,split,toPrimitive,toStringTag,unscopables'\n        ).split(','), j = 0; es6Symbols.length > j;)wks(es6Symbols[j++]);\n\n        for (var wellKnownSymbols = $keys(wks.store), k = 0; wellKnownSymbols.length > k;) wksDefine(wellKnownSymbols[k++]);\n\n        $export($export.S + $export.F * !USE_NATIVE, 'Symbol', {\n            // 19.4.2.1 Symbol.for(key)\n            'for': function (key) {\n                return has(SymbolRegistry, key += '')\n                    ? SymbolRegistry[key]\n                    : SymbolRegistry[key] = $Symbol(key);\n            },\n            // 19.4.2.5 Symbol.keyFor(sym)\n            keyFor: function keyFor(key) {\n                if (isSymbol(key)) return keyOf(SymbolRegistry, key);\n                throw TypeError(key + ' is not a symbol!');\n            },\n            useSetter: function () { setter = true; },\n            useSimple: function () { setter = false; }\n        });\n\n        $export($export.S + $export.F * !USE_NATIVE, 'Object', {\n            // 19.1.2.2 Object.create(O [, Properties])\n            create: $create,\n            // 19.1.2.4 Object.defineProperty(O, P, Attributes)\n            defineProperty: $defineProperty,\n            // 19.1.2.3 Object.defineProperties(O, Properties)\n            defineProperties: $defineProperties,\n            // 19.1.2.6 Object.getOwnPropertyDescriptor(O, P)\n            getOwnPropertyDescriptor: $getOwnPropertyDescriptor,\n            // 19.1.2.7 Object.getOwnPropertyNames(O)\n            getOwnPropertyNames: $getOwnPropertyNames,\n            // 19.1.2.8 Object.getOwnPropertySymbols(O)\n            getOwnPropertySymbols: $getOwnPropertySymbols\n        });\n\n// 24.3.2 JSON.stringify(value [, replacer [, space]])\n        $JSON && $export($export.S + $export.F * (!USE_NATIVE || $fails(function () {\n            var S = $Symbol();\n            // MS Edge converts symbol values to JSON as {}\n            // WebKit converts symbol values to JSON as null\n            // V8 throws on boxed symbols\n            return _stringify([S]) != '[null]' || _stringify({ a: S }) != '{}' || _stringify(Object(S)) != '{}';\n        })), 'JSON', {\n            stringify: function stringify(it) {\n                if (it === undefined || isSymbol(it)) return; // IE8 returns string on undefined\n                var args = [it];\n                var i = 1;\n                var replacer, $replacer;\n                while (arguments.length > i) args.push(arguments[i++]);\n                replacer = args[1];\n                if (typeof replacer == 'function') $replacer = replacer;\n                if ($replacer || !isArray(replacer)) replacer = function (key, value) {\n                    if ($replacer) value = $replacer.call(this, key, value);\n                    if (!isSymbol(value)) return value;\n                };\n                args[1] = replacer;\n                return _stringify.apply($JSON, args);\n            }\n        });\n\n// 19.4.3.4 Symbol.prototype[@@toPrimitive](hint)\n        $Symbol[PROTOTYPE][TO_PRIMITIVE] || _dereq_(42)($Symbol[PROTOTYPE], TO_PRIMITIVE, $Symbol[PROTOTYPE].valueOf);\n// 19.4.3.5 Symbol.prototype[@@toStringTag]\n        setToStringTag($Symbol, 'Symbol');\n// 20.2.1.9 Math[@@toStringTag]\n        setToStringTag(Math, 'Math', true);\n// 24.3.3 JSON[@@toStringTag]\n        setToStringTag(global.JSON, 'JSON', true);\n\n    },{\"101\":101,\"103\":103,\"117\":117,\"120\":120,\"124\":124,\"126\":126,\"127\":127,\"128\":128,\"29\":29,\"32\":32,\"33\":33,\"35\":35,\"40\":40,\"41\":41,\"42\":42,\"49\":49,\"59\":59,\"60\":60,\"66\":66,\"7\":7,\"71\":71,\"72\":72,\"75\":75,\"76\":76,\"77\":77,\"78\":78,\"81\":81,\"82\":82,\"92\":92,\"94\":94}],255:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var $typed = _dereq_(123);\n        var buffer = _dereq_(122);\n        var anObject = _dereq_(7);\n        var toAbsoluteIndex = _dereq_(114);\n        var toLength = _dereq_(118);\n        var isObject = _dereq_(51);\n        var ArrayBuffer = _dereq_(40).ArrayBuffer;\n        var speciesConstructor = _dereq_(104);\n        var $ArrayBuffer = buffer.ArrayBuffer;\n        var $DataView = buffer.DataView;\n        var $isView = $typed.ABV && ArrayBuffer.isView;\n        var $slice = $ArrayBuffer.prototype.slice;\n        var VIEW = $typed.VIEW;\n        var ARRAY_BUFFER = 'ArrayBuffer';\n\n        $export($export.G + $export.W + $export.F * (ArrayBuffer !== $ArrayBuffer), { ArrayBuffer: $ArrayBuffer });\n\n        $export($export.S + $export.F * !$typed.CONSTR, ARRAY_BUFFER, {\n            // 24.1.3.1 ArrayBuffer.isView(arg)\n            isView: function isView(it) {\n                return $isView && $isView(it) || isObject(it) && VIEW in it;\n            }\n        });\n\n        $export($export.P + $export.U + $export.F * _dereq_(35)(function () {\n            return !new $ArrayBuffer(2).slice(1, undefined).byteLength;\n        }), ARRAY_BUFFER, {\n            // 24.1.4.3 ArrayBuffer.prototype.slice(start, end)\n            slice: function slice(start, end) {\n                if ($slice !== undefined && end === undefined) return $slice.call(anObject(this), start); // FF fix\n                var len = anObject(this).byteLength;\n                var first = toAbsoluteIndex(start, len);\n                var final = toAbsoluteIndex(end === undefined ? len : end, len);\n                var result = new (speciesConstructor(this, $ArrayBuffer))(toLength(final - first));\n                var viewS = new $DataView(this);\n                var viewT = new $DataView(result);\n                var index = 0;\n                while (first < final) {\n                    viewT.setUint8(index++, viewS.getUint8(first++));\n                } return result;\n            }\n        });\n\n        _dereq_(100)(ARRAY_BUFFER);\n\n    },{\"100\":100,\"104\":104,\"114\":114,\"118\":118,\"122\":122,\"123\":123,\"33\":33,\"35\":35,\"40\":40,\"51\":51,\"7\":7}],256:[function(_dereq_,module,exports){\n        var $export = _dereq_(33);\n        $export($export.G + $export.W + $export.F * !_dereq_(123).ABV, {\n            DataView: _dereq_(122).DataView\n        });\n\n    },{\"122\":122,\"123\":123,\"33\":33}],257:[function(_dereq_,module,exports){\n        _dereq_(121)('Float32', 4, function (init) {\n            return function Float32Array(data, byteOffset, length) {\n                return init(this, data, byteOffset, length);\n            };\n        });\n\n    },{\"121\":121}],258:[function(_dereq_,module,exports){\n        _dereq_(121)('Float64', 8, function (init) {\n            return function Float64Array(data, byteOffset, length) {\n                return init(this, data, byteOffset, length);\n            };\n        });\n\n    },{\"121\":121}],259:[function(_dereq_,module,exports){\n        _dereq_(121)('Int16', 2, function (init) {\n            return function Int16Array(data, byteOffset, length) {\n                return init(this, data, byteOffset, length);\n            };\n        });\n\n    },{\"121\":121}],260:[function(_dereq_,module,exports){\n        _dereq_(121)('Int32', 4, function (init) {\n            return function Int32Array(data, byteOffset, length) {\n                return init(this, data, byteOffset, length);\n            };\n        });\n\n    },{\"121\":121}],261:[function(_dereq_,module,exports){\n        _dereq_(121)('Int8', 1, function (init) {\n            return function Int8Array(data, byteOffset, length) {\n                return init(this, data, byteOffset, length);\n            };\n        });\n\n    },{\"121\":121}],262:[function(_dereq_,module,exports){\n        _dereq_(121)('Uint16', 2, function (init) {\n            return function Uint16Array(data, byteOffset, length) {\n                return init(this, data, byteOffset, length);\n            };\n        });\n\n    },{\"121\":121}],263:[function(_dereq_,module,exports){\n        _dereq_(121)('Uint32', 4, function (init) {\n            return function Uint32Array(data, byteOffset, length) {\n                return init(this, data, byteOffset, length);\n            };\n        });\n\n    },{\"121\":121}],264:[function(_dereq_,module,exports){\n        _dereq_(121)('Uint8', 1, function (init) {\n            return function Uint8Array(data, byteOffset, length) {\n                return init(this, data, byteOffset, length);\n            };\n        });\n\n    },{\"121\":121}],265:[function(_dereq_,module,exports){\n        _dereq_(121)('Uint8', 1, function (init) {\n            return function Uint8ClampedArray(data, byteOffset, length) {\n                return init(this, data, byteOffset, length);\n            };\n        }, true);\n\n    },{\"121\":121}],266:[function(_dereq_,module,exports){\n        'use strict';\n        var each = _dereq_(12)(0);\n        var redefine = _dereq_(94);\n        var meta = _dereq_(66);\n        var assign = _dereq_(70);\n        var weak = _dereq_(21);\n        var isObject = _dereq_(51);\n        var fails = _dereq_(35);\n        var validate = _dereq_(125);\n        var WEAK_MAP = 'WeakMap';\n        var getWeak = meta.getWeak;\n        var isExtensible = Object.isExtensible;\n        var uncaughtFrozenStore = weak.ufstore;\n        var tmp = {};\n        var InternalMap;\n\n        var wrapper = function (get) {\n            return function WeakMap() {\n                return get(this, arguments.length > 0 ? arguments[0] : undefined);\n            };\n        };\n\n        var methods = {\n            // 23.3.3.3 WeakMap.prototype.get(key)\n            get: function get(key) {\n                if (isObject(key)) {\n                    var data = getWeak(key);\n                    if (data === true) return uncaughtFrozenStore(validate(this, WEAK_MAP)).get(key);\n                    return data ? data[this._i] : undefined;\n                }\n            },\n            // 23.3.3.5 WeakMap.prototype.set(key, value)\n            set: function set(key, value) {\n                return weak.def(validate(this, WEAK_MAP), key, value);\n            }\n        };\n\n// 23.3 WeakMap Objects\n        var $WeakMap = module.exports = _dereq_(22)(WEAK_MAP, wrapper, methods, weak, true, true);\n\n// IE11 WeakMap frozen keys fix\n        if (fails(function () { return new $WeakMap().set((Object.freeze || Object)(tmp), 7).get(tmp) != 7; })) {\n            InternalMap = weak.getConstructor(wrapper, WEAK_MAP);\n            assign(InternalMap.prototype, methods);\n            meta.NEED = true;\n            each(['delete', 'has', 'get', 'set'], function (key) {\n                var proto = $WeakMap.prototype;\n                var method = proto[key];\n                redefine(proto, key, function (a, b) {\n                    // store frozen objects on internal weakmap shim\n                    if (isObject(a) && !isExtensible(a)) {\n                        if (!this._f) this._f = new InternalMap();\n                        var result = this._f[key](a, b);\n                        return key == 'set' ? this : result;\n                        // store all the rest on native weakmap\n                    } return method.call(this, a, b);\n                });\n            });\n        }\n\n    },{\"12\":12,\"125\":125,\"21\":21,\"22\":22,\"35\":35,\"51\":51,\"66\":66,\"70\":70,\"94\":94}],267:[function(_dereq_,module,exports){\n        'use strict';\n        var weak = _dereq_(21);\n        var validate = _dereq_(125);\n        var WEAK_SET = 'WeakSet';\n\n// 23.4 WeakSet Objects\n        _dereq_(22)(WEAK_SET, function (get) {\n            return function WeakSet() { return get(this, arguments.length > 0 ? arguments[0] : undefined); };\n        }, {\n            // 23.4.3.1 WeakSet.prototype.add(value)\n            add: function add(value) {\n                return weak.def(validate(this, WEAK_SET), value, true);\n            }\n        }, weak, false, true);\n\n    },{\"125\":125,\"21\":21,\"22\":22}],268:[function(_dereq_,module,exports){\n        'use strict';\n// https://tc39.github.io/proposal-flatMap/#sec-Array.prototype.flatMap\n        var $export = _dereq_(33);\n        var flattenIntoArray = _dereq_(38);\n        var toObject = _dereq_(119);\n        var toLength = _dereq_(118);\n        var aFunction = _dereq_(3);\n        var arraySpeciesCreate = _dereq_(15);\n\n        $export($export.P, 'Array', {\n            flatMap: function flatMap(callbackfn /* , thisArg */) {\n                var O = toObject(this);\n                var sourceLen, A;\n                aFunction(callbackfn);\n                sourceLen = toLength(O.length);\n                A = arraySpeciesCreate(O, 0);\n                flattenIntoArray(A, O, O, sourceLen, 0, 1, callbackfn, arguments[1]);\n                return A;\n            }\n        });\n\n        _dereq_(5)('flatMap');\n\n    },{\"118\":118,\"119\":119,\"15\":15,\"3\":3,\"33\":33,\"38\":38,\"5\":5}],269:[function(_dereq_,module,exports){\n        'use strict';\n// https://tc39.github.io/proposal-flatMap/#sec-Array.prototype.flatten\n        var $export = _dereq_(33);\n        var flattenIntoArray = _dereq_(38);\n        var toObject = _dereq_(119);\n        var toLength = _dereq_(118);\n        var toInteger = _dereq_(116);\n        var arraySpeciesCreate = _dereq_(15);\n\n        $export($export.P, 'Array', {\n            flatten: function flatten(/* depthArg = 1 */) {\n                var depthArg = arguments[0];\n                var O = toObject(this);\n                var sourceLen = toLength(O.length);\n                var A = arraySpeciesCreate(O, 0);\n                flattenIntoArray(A, O, O, sourceLen, 0, depthArg === undefined ? 1 : toInteger(depthArg));\n                return A;\n            }\n        });\n\n        _dereq_(5)('flatten');\n\n    },{\"116\":116,\"118\":118,\"119\":119,\"15\":15,\"33\":33,\"38\":38,\"5\":5}],270:[function(_dereq_,module,exports){\n        'use strict';\n// https://github.com/tc39/Array.prototype.includes\n        var $export = _dereq_(33);\n        var $includes = _dereq_(11)(true);\n\n        $export($export.P, 'Array', {\n            includes: function includes(el /* , fromIndex = 0 */) {\n                return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);\n            }\n        });\n\n        _dereq_(5)('includes');\n\n    },{\"11\":11,\"33\":33,\"5\":5}],271:[function(_dereq_,module,exports){\n// https://github.com/rwaldron/tc39-notes/blob/master/es6/2014-09/sept-25.md#510-globalasap-for-enqueuing-a-microtask\n        var $export = _dereq_(33);\n        var microtask = _dereq_(68)();\n        var process = _dereq_(40).process;\n        var isNode = _dereq_(18)(process) == 'process';\n\n        $export($export.G, {\n            asap: function asap(fn) {\n                var domain = isNode && process.domain;\n                microtask(domain ? domain.bind(fn) : fn);\n            }\n        });\n\n    },{\"18\":18,\"33\":33,\"40\":40,\"68\":68}],272:[function(_dereq_,module,exports){\n// https://github.com/ljharb/proposal-is-error\n        var $export = _dereq_(33);\n        var cof = _dereq_(18);\n\n        $export($export.S, 'Error', {\n            isError: function isError(it) {\n                return cof(it) === 'Error';\n            }\n        });\n\n    },{\"18\":18,\"33\":33}],273:[function(_dereq_,module,exports){\n// https://github.com/tc39/proposal-global\n        var $export = _dereq_(33);\n\n        $export($export.G, { global: _dereq_(40) });\n\n    },{\"33\":33,\"40\":40}],274:[function(_dereq_,module,exports){\n// https://tc39.github.io/proposal-setmap-offrom/#sec-map.from\n        _dereq_(97)('Map');\n\n    },{\"97\":97}],275:[function(_dereq_,module,exports){\n// https://tc39.github.io/proposal-setmap-offrom/#sec-map.of\n        _dereq_(98)('Map');\n\n    },{\"98\":98}],276:[function(_dereq_,module,exports){\n// https://github.com/DavidBruant/Map-Set.prototype.toJSON\n        var $export = _dereq_(33);\n\n        $export($export.P + $export.R, 'Map', { toJSON: _dereq_(20)('Map') });\n\n    },{\"20\":20,\"33\":33}],277:[function(_dereq_,module,exports){\n// https://rwaldron.github.io/proposal-math-extensions/\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Math', {\n            clamp: function clamp(x, lower, upper) {\n                return Math.min(upper, Math.max(lower, x));\n            }\n        });\n\n    },{\"33\":33}],278:[function(_dereq_,module,exports){\n// https://rwaldron.github.io/proposal-math-extensions/\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Math', { DEG_PER_RAD: Math.PI / 180 });\n\n    },{\"33\":33}],279:[function(_dereq_,module,exports){\n// https://rwaldron.github.io/proposal-math-extensions/\n        var $export = _dereq_(33);\n        var RAD_PER_DEG = 180 / Math.PI;\n\n        $export($export.S, 'Math', {\n            degrees: function degrees(radians) {\n                return radians * RAD_PER_DEG;\n            }\n        });\n\n    },{\"33\":33}],280:[function(_dereq_,module,exports){\n// https://rwaldron.github.io/proposal-math-extensions/\n        var $export = _dereq_(33);\n        var scale = _dereq_(64);\n        var fround = _dereq_(62);\n\n        $export($export.S, 'Math', {\n            fscale: function fscale(x, inLow, inHigh, outLow, outHigh) {\n                return fround(scale(x, inLow, inHigh, outLow, outHigh));\n            }\n        });\n\n    },{\"33\":33,\"62\":62,\"64\":64}],281:[function(_dereq_,module,exports){\n// https://gist.github.com/BrendanEich/4294d5c212a6d2254703\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Math', {\n            iaddh: function iaddh(x0, x1, y0, y1) {\n                var $x0 = x0 >>> 0;\n                var $x1 = x1 >>> 0;\n                var $y0 = y0 >>> 0;\n                return $x1 + (y1 >>> 0) + (($x0 & $y0 | ($x0 | $y0) & ~($x0 + $y0 >>> 0)) >>> 31) | 0;\n            }\n        });\n\n    },{\"33\":33}],282:[function(_dereq_,module,exports){\n// https://gist.github.com/BrendanEich/4294d5c212a6d2254703\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Math', {\n            imulh: function imulh(u, v) {\n                var UINT16 = 0xffff;\n                var $u = +u;\n                var $v = +v;\n                var u0 = $u & UINT16;\n                var v0 = $v & UINT16;\n                var u1 = $u >> 16;\n                var v1 = $v >> 16;\n                var t = (u1 * v0 >>> 0) + (u0 * v0 >>> 16);\n                return u1 * v1 + (t >> 16) + ((u0 * v1 >>> 0) + (t & UINT16) >> 16);\n            }\n        });\n\n    },{\"33\":33}],283:[function(_dereq_,module,exports){\n// https://gist.github.com/BrendanEich/4294d5c212a6d2254703\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Math', {\n            isubh: function isubh(x0, x1, y0, y1) {\n                var $x0 = x0 >>> 0;\n                var $x1 = x1 >>> 0;\n                var $y0 = y0 >>> 0;\n                return $x1 - (y1 >>> 0) - ((~$x0 & $y0 | ~($x0 ^ $y0) & $x0 - $y0 >>> 0) >>> 31) | 0;\n            }\n        });\n\n    },{\"33\":33}],284:[function(_dereq_,module,exports){\n// https://rwaldron.github.io/proposal-math-extensions/\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Math', { RAD_PER_DEG: 180 / Math.PI });\n\n    },{\"33\":33}],285:[function(_dereq_,module,exports){\n// https://rwaldron.github.io/proposal-math-extensions/\n        var $export = _dereq_(33);\n        var DEG_PER_RAD = Math.PI / 180;\n\n        $export($export.S, 'Math', {\n            radians: function radians(degrees) {\n                return degrees * DEG_PER_RAD;\n            }\n        });\n\n    },{\"33\":33}],286:[function(_dereq_,module,exports){\n// https://rwaldron.github.io/proposal-math-extensions/\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Math', { scale: _dereq_(64) });\n\n    },{\"33\":33,\"64\":64}],287:[function(_dereq_,module,exports){\n// http://jfbastien.github.io/papers/Math.signbit.html\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Math', { signbit: function signbit(x) {\n                // eslint-disable-next-line no-self-compare\n                return (x = +x) != x ? x : x == 0 ? 1 / x == Infinity : x > 0;\n            } });\n\n    },{\"33\":33}],288:[function(_dereq_,module,exports){\n// https://gist.github.com/BrendanEich/4294d5c212a6d2254703\n        var $export = _dereq_(33);\n\n        $export($export.S, 'Math', {\n            umulh: function umulh(u, v) {\n                var UINT16 = 0xffff;\n                var $u = +u;\n                var $v = +v;\n                var u0 = $u & UINT16;\n                var v0 = $v & UINT16;\n                var u1 = $u >>> 16;\n                var v1 = $v >>> 16;\n                var t = (u1 * v0 >>> 0) + (u0 * v0 >>> 16);\n                return u1 * v1 + (t >>> 16) + ((u0 * v1 >>> 0) + (t & UINT16) >>> 16);\n            }\n        });\n\n    },{\"33\":33}],289:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var toObject = _dereq_(119);\n        var aFunction = _dereq_(3);\n        var $defineProperty = _dereq_(72);\n\n// B.2.2.2 Object.prototype.__defineGetter__(P, getter)\n        _dereq_(29) && $export($export.P + _dereq_(74), 'Object', {\n            __defineGetter__: function __defineGetter__(P, getter) {\n                $defineProperty.f(toObject(this), P, { get: aFunction(getter), enumerable: true, configurable: true });\n            }\n        });\n\n    },{\"119\":119,\"29\":29,\"3\":3,\"33\":33,\"72\":72,\"74\":74}],290:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var toObject = _dereq_(119);\n        var aFunction = _dereq_(3);\n        var $defineProperty = _dereq_(72);\n\n// B.2.2.3 Object.prototype.__defineSetter__(P, setter)\n        _dereq_(29) && $export($export.P + _dereq_(74), 'Object', {\n            __defineSetter__: function __defineSetter__(P, setter) {\n                $defineProperty.f(toObject(this), P, { set: aFunction(setter), enumerable: true, configurable: true });\n            }\n        });\n\n    },{\"119\":119,\"29\":29,\"3\":3,\"33\":33,\"72\":72,\"74\":74}],291:[function(_dereq_,module,exports){\n// https://github.com/tc39/proposal-object-values-entries\n        var $export = _dereq_(33);\n        var $entries = _dereq_(84)(true);\n\n        $export($export.S, 'Object', {\n            entries: function entries(it) {\n                return $entries(it);\n            }\n        });\n\n    },{\"33\":33,\"84\":84}],292:[function(_dereq_,module,exports){\n// https://github.com/tc39/proposal-object-getownpropertydescriptors\n        var $export = _dereq_(33);\n        var ownKeys = _dereq_(85);\n        var toIObject = _dereq_(117);\n        var gOPD = _dereq_(75);\n        var createProperty = _dereq_(24);\n\n        $export($export.S, 'Object', {\n            getOwnPropertyDescriptors: function getOwnPropertyDescriptors(object) {\n                var O = toIObject(object);\n                var getDesc = gOPD.f;\n                var keys = ownKeys(O);\n                var result = {};\n                var i = 0;\n                var key, desc;\n                while (keys.length > i) {\n                    desc = getDesc(O, key = keys[i++]);\n                    if (desc !== undefined) createProperty(result, key, desc);\n                }\n                return result;\n            }\n        });\n\n    },{\"117\":117,\"24\":24,\"33\":33,\"75\":75,\"85\":85}],293:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var toObject = _dereq_(119);\n        var toPrimitive = _dereq_(120);\n        var getPrototypeOf = _dereq_(79);\n        var getOwnPropertyDescriptor = _dereq_(75).f;\n\n// B.2.2.4 Object.prototype.__lookupGetter__(P)\n        _dereq_(29) && $export($export.P + _dereq_(74), 'Object', {\n            __lookupGetter__: function __lookupGetter__(P) {\n                var O = toObject(this);\n                var K = toPrimitive(P, true);\n                var D;\n                do {\n                    if (D = getOwnPropertyDescriptor(O, K)) return D.get;\n                } while (O = getPrototypeOf(O));\n            }\n        });\n\n    },{\"119\":119,\"120\":120,\"29\":29,\"33\":33,\"74\":74,\"75\":75,\"79\":79}],294:[function(_dereq_,module,exports){\n        'use strict';\n        var $export = _dereq_(33);\n        var toObject = _dereq_(119);\n        var toPrimitive = _dereq_(120);\n        var getPrototypeOf = _dereq_(79);\n        var getOwnPropertyDescriptor = _dereq_(75).f;\n\n// B.2.2.5 Object.prototype.__lookupSetter__(P)\n        _dereq_(29) && $export($export.P + _dereq_(74), 'Object', {\n            __lookupSetter__: function __lookupSetter__(P) {\n                var O = toObject(this);\n                var K = toPrimitive(P, true);\n                var D;\n                do {\n                    if (D = getOwnPropertyDescriptor(O, K)) return D.set;\n                } while (O = getPrototypeOf(O));\n            }\n        });\n\n    },{\"119\":119,\"120\":120,\"29\":29,\"33\":33,\"74\":74,\"75\":75,\"79\":79}],295:[function(_dereq_,module,exports){\n// https://github.com/tc39/proposal-object-values-entries\n        var $export = _dereq_(33);\n        var $values = _dereq_(84)(false);\n\n        $export($export.S, 'Object', {\n            values: function values(it) {\n                return $values(it);\n            }\n        });\n\n    },{\"33\":33,\"84\":84}],296:[function(_dereq_,module,exports){\n        'use strict';\n// https://github.com/zenparsing/es-observable\n        var $export = _dereq_(33);\n        var global = _dereq_(40);\n        var core = _dereq_(23);\n        var microtask = _dereq_(68)();\n        var OBSERVABLE = _dereq_(128)('observable');\n        var aFunction = _dereq_(3);\n        var anObject = _dereq_(7);\n        var anInstance = _dereq_(6);\n        var redefineAll = _dereq_(93);\n        var hide = _dereq_(42);\n        var forOf = _dereq_(39);\n        var RETURN = forOf.RETURN;\n\n        var getMethod = function (fn) {\n            return fn == null ? undefined : aFunction(fn);\n        };\n\n        var cleanupSubscription = function (subscription) {\n            var cleanup = subscription._c;\n            if (cleanup) {\n                subscription._c = undefined;\n                cleanup();\n            }\n        };\n\n        var subscriptionClosed = function (subscription) {\n            return subscription._o === undefined;\n        };\n\n        var closeSubscription = function (subscription) {\n            if (!subscriptionClosed(subscription)) {\n                subscription._o = undefined;\n                cleanupSubscription(subscription);\n            }\n        };\n\n        var Subscription = function (observer, subscriber) {\n            anObject(observer);\n            this._c = undefined;\n            this._o = observer;\n            observer = new SubscriptionObserver(this);\n            try {\n                var cleanup = subscriber(observer);\n                var subscription = cleanup;\n                if (cleanup != null) {\n                    if (typeof cleanup.unsubscribe === 'function') cleanup = function () { subscription.unsubscribe(); };\n                    else aFunction(cleanup);\n                    this._c = cleanup;\n                }\n            } catch (e) {\n                observer.error(e);\n     