require.config({"config": {
        "jsbuild":{"mage/backend/menu.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.menu', {\n        widgetEventPrefix: 'menu',\n        version: '1.10.1',\n        defaultElement: '<ul>',\n        delay: 300,\n        options: {\n            icons: {\n                submenu: 'ui-icon-carat-1-e'\n            },\n            menus: 'ul',\n            position: {\n                my: 'left top',\n                at: 'right top'\n            },\n            role: 'menu',\n\n            // callbacks\n            blur: null,\n            focus: null,\n            select: null\n        },\n\n        /**\n         * @private\n         */\n        _create: function () {\n            this.activeMenu = this.element;\n            // flag used to prevent firing of the click handler\n            // as the event bubbles up through nested menus\n            this.mouseHandled = false;\n            this.element\n                .uniqueId()\n                .addClass('ui-menu ui-widget ui-widget-content ui-corner-all')\n                .toggleClass('ui-menu-icons', !!this.element.find('.ui-icon').length)\n                .attr({\n                    role: this.options.role,\n                    tabIndex: 0\n                })\n                // need to catch all clicks on disabled menu\n                // not possible through _on\n                .on('click' + this.eventNamespace, $.proxy(function (event) {\n                    if (this.options.disabled) {\n                        event.preventDefault();\n                    }\n                }, this));\n\n            if (this.options.disabled) {\n                this.element\n                    .addClass('ui-state-disabled')\n                    .attr('aria-disabled', 'true');\n            }\n\n            this._on({\n                /**\n                 * Prevent focus from sticking to links inside menu after clicking\n                 * them (focus should always stay on UL during navigation).\n                 */\n                'mousedown .ui-menu-item > a': function (event) {\n                    event.preventDefault();\n                },\n\n                /**\n                 * Prevent focus from sticking to links inside menu after clicking\n                 * them (focus should always stay on UL during navigation).\n                 */\n                'click .ui-state-disabled > a': function (event) {\n                    event.preventDefault();\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'click .ui-menu-item:has(a)': function (event) {\n                    var target = $(event.target).closest('.ui-menu-item');\n\n                    if (!this.mouseHandled && target.not('.ui-state-disabled').length) {\n                        this.mouseHandled = true;\n\n                        this.select(event);\n                        // Open submenu on click\n                        if (target.has('.ui-menu').length) {\n                            this.expand(event);\n                        } else if (!this.element.is(':focus')) {\n                            // Redirect focus to the menu\n                            this.element.trigger('focus', [true]);\n\n                            // If the active item is on the top level, let it stay active.\n                            // Otherwise, blur the active item since it is no longer visible.\n                            if (this.active && this.active.parents('.ui-menu').length === 1) { //eslint-disable-line\n                                clearTimeout(this.timer);\n                            }\n                        }\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'mouseenter .ui-menu-item': function (event) {\n                    var target = $(event.currentTarget);\n\n                    // Remove ui-state-active class from siblings of the newly focused menu item\n                    // to avoid a jump caused by adjacent elements both having a class with a border\n                    target.siblings().children('.ui-state-active').removeClass('ui-state-active');\n                    this.focus(event, target);\n                },\n                mouseleave: 'collapseAll',\n                'mouseleave .ui-menu': 'collapseAll',\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {*} keepActiveItem\n                 */\n                focus: function (event, keepActiveItem) {\n                    // If there's already an active item, keep it active\n                    // If not, activate the first item\n                    var item = this.active || this.element.children('.ui-menu-item').eq(0);\n\n                    if (!keepActiveItem) {\n                        this.focus(event, item);\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                blur: function (event) {\n                    this._delay(function () {\n                        if (!$.contains(this.element[0], this.document[0].activeElement)) {\n                            this.collapseAll(event);\n                        }\n                    });\n                },\n                keydown: '_keydown'\n            });\n\n            this.refresh();\n\n            // Clicks outside of a menu collapse any open menus\n            this._on(this.document, {\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                click: function (event) {\n                    if (!$(event.target).closest('.ui-menu').length) {\n                        this.collapseAll(event);\n                    }\n\n                    // Reset the mouseHandled flag\n                    this.mouseHandled = false;\n                }\n            });\n        },\n\n        /**\n         * @private\n         */\n        _destroy: function () {\n            // Destroy (sub)menus\n            this.element\n                .removeAttr('aria-activedescendant')\n                .find('.ui-menu').addBack()\n                .removeClass('ui-menu ui-widget ui-widget-content ui-corner-all ui-menu-icons')\n                .removeAttr('role')\n                .removeAttr('tabIndex')\n                .removeAttr('aria-labelledby')\n                .removeAttr('aria-expanded')\n                .removeAttr('aria-hidden')\n                .removeAttr('aria-disabled')\n                .removeUniqueId()\n                .show();\n\n            // Destroy menu items\n            this.element.find('.ui-menu-item')\n                .removeClass('ui-menu-item')\n                .removeAttr('role')\n                .removeAttr('aria-disabled')\n                .children('a')\n                .removeUniqueId()\n                .removeClass('ui-corner-all ui-state-hover')\n                .removeAttr('tabIndex')\n                .removeAttr('role')\n                .removeAttr('aria-haspopup')\n                .children().each(function () {\n                    var elem = $(this);\n\n                    if (elem.data('ui-menu-submenu-carat')) {\n                        elem.remove();\n                    }\n                });\n\n            // Destroy menu dividers\n            this.element.find('.ui-menu-divider').removeClass('ui-menu-divider ui-widget-content');\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _keydown: function (event) {\n            var match, prev, character, skip, regex,\n                preventDefault = true;\n\n            /**\n             * @param {String} value\n             */\n            function escape(value) {\n                return value.replace(/[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g, '\\\\$&');\n            }\n\n            switch (event.keyCode) {\n                case $.ui.keyCode.PAGE_UP:\n                    this.previousPage(event);\n                    break;\n\n                case $.ui.keyCode.PAGE_DOWN:\n                    this.nextPage(event);\n                    break;\n\n                case $.ui.keyCode.HOME:\n                    this._move('first', 'first', event);\n                    break;\n\n                case $.ui.keyCode.END:\n                    this._move('last', 'last', event);\n                    break;\n\n                case $.ui.keyCode.UP:\n                    this.previous(event);\n                    break;\n\n                case $.ui.keyCode.DOWN:\n                    this.next(event);\n                    break;\n\n                case $.ui.keyCode.LEFT:\n                    this.collapse(event);\n                    break;\n\n                case $.ui.keyCode.RIGHT:\n                    if (this.active && !this.active.is('.ui-state-disabled')) {\n                        this.expand(event);\n                    }\n                    break;\n\n                case $.ui.keyCode.ENTER:\n                case $.ui.keyCode.SPACE:\n                    this._activate(event);\n                    break;\n\n                case $.ui.keyCode.ESCAPE:\n                    this.collapse(event);\n                    break;\n\n                default:\n                    preventDefault = false;\n                    prev = this.previousFilter || '';\n                    character = String.fromCharCode(event.keyCode);\n                    skip = false;\n\n                    clearTimeout(this.filterTimer);\n\n                    if (character === prev) {\n                        skip = true;\n                    } else {\n                        character = prev + character;\n                    }\n\n                    regex = new RegExp('^' + escape(character), 'i');\n                    match = this.activeMenu.children('.ui-menu-item').filter(function () {\n                        return regex.test($(this).children('a').text());\n                    });\n                    match = skip && match.index(this.active.next()) !== -1 ?\n                        this.active.nextAll('.ui-menu-item') :\n                        match;\n\n                    // If no matches on the current filter, reset to the last character pressed\n                    // to move down the menu to the first item that starts with that character\n                    if (!match.length) {\n                        character = String.fromCharCode(event.keyCode);\n                        regex = new RegExp('^' + escape(character), 'i');\n                        match = this.activeMenu.children('.ui-menu-item').filter(function () {\n                            return regex.test($(this).children('a').text());\n                        });\n                    }\n\n                    if (match.length) {\n                        this.focus(event, match);\n\n                        if (match.length > 1) { //eslint-disable-line max-depth\n                            this.previousFilter = character;\n                            this.filterTimer = this._delay(function () {\n                                delete this.previousFilter;\n                            }, 1000);\n                        } else {\n                            delete this.previousFilter;\n                        }\n                    } else {\n                        delete this.previousFilter;\n                    }\n            }\n\n            if (preventDefault) {\n                event.preventDefault();\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _activate: function (event) {\n            if (!this.active.is('.ui-state-disabled')) {\n                if (this.active.children('a[aria-haspopup=\"true\"]').length) {\n                    this.expand(event);\n                } else {\n                    this.select(event);\n                }\n            }\n        },\n\n        /**\n         * Refresh.\n         */\n        refresh: function () {\n            var menus,\n                icon = this.options.icons.submenu,\n                submenus = this.element.find(this.options.menus);\n\n            // Initialize nested menus\n            submenus.filter(':not(.ui-menu)')\n                .addClass('ui-menu ui-widget ui-widget-content ui-corner-all')\n                .hide()\n                .attr({\n                    role: this.options.role,\n                    'aria-hidden': 'true',\n                    'aria-expanded': 'false'\n                })\n                .each(function () {\n                    var menu = $(this),\n                        item = menu.prev('a'),\n                        submenuCarat = $('<span>')\n                            .addClass('ui-menu-icon ui-icon ' + icon)\n                            .data('ui-menu-submenu-carat', true);\n\n                    item\n                        .attr('aria-haspopup', 'true')\n                        .prepend(submenuCarat);\n                    menu.attr('aria-labelledby', item.attr('id'));\n                });\n\n            menus = submenus.add(this.element);\n\n            // Don't refresh list items that are already adapted\n            menus.children(':not(.ui-menu-item):has(a)')\n                .addClass('ui-menu-item')\n                .attr('role', 'presentation')\n                .children('a')\n                .uniqueId()\n                .addClass('ui-corner-all')\n                .attr({\n                    tabIndex: -1,\n                    role: this._itemRole()\n                });\n\n            // Initialize unlinked menu-items containing spaces and/or dashes only as dividers\n            menus.children(':not(.ui-menu-item)').each(function () {\n                var item = $(this);\n\n                // hyphen, em dash, en dash\n                if (!/[^\\-\\u2014\\u2013\\s]/.test(item.text())) {\n                    item.addClass('ui-widget-content ui-menu-divider');\n                }\n            });\n\n            // Add aria-disabled attribute to any disabled menu item\n            menus.children('.ui-state-disabled').attr('aria-disabled', 'true');\n\n            // If the active item has been removed, blur the menu\n            if (this.active && !$.contains(this.element[0], this.active[0])) {\n                this.blur();\n            }\n        },\n\n        /**\n         * @return {*}\n         * @private\n         */\n        _itemRole: function () {\n            return {\n                menu: 'menuitem',\n                listbox: 'option'\n            }[this.options.role];\n        },\n\n        /**\n         * @param {String} key\n         * @param {*} value\n         * @private\n         */\n        _setOption: function (key, value) {\n            if (key === 'icons') {\n                this.element.find('.ui-menu-icon')\n                    .removeClass(this.options.icons.submenu)\n                    .addClass(value.submenu);\n            }\n            this._super(key, value);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} item\n         */\n        focus: function (event, item) {\n            var nested, focused;\n\n            this.blur(event, event && event.type === 'focus');\n\n            this._scrollIntoView(item);\n\n            this.active = item.first();\n            focused = this.active.children('a').addClass('ui-state-focus');\n            // Only update aria-activedescendant if there's a role\n            // otherwise we assume focus is managed elsewhere\n            if (this.options.role) {\n                this.element.attr('aria-activedescendant', focused.attr('id'));\n            }\n\n            // Highlight active parent menu item, if any\n            this.active\n                .parent()\n                .closest('.ui-menu-item')\n                .children('a:first')\n                .addClass('ui-state-active');\n\n            if (event && event.type === 'keydown') {\n                this._close();\n            } else {\n                this.timer = this._delay(function () {\n                    this._close();\n                }, this.delay);\n            }\n\n            nested = item.children('.ui-menu');\n\n            if (nested.length && /^mouse/.test(event.type)) {\n                this._startOpening(nested);\n            }\n            this.activeMenu = item.parent();\n\n            this._trigger('focus', event, {\n                item: item\n            });\n        },\n\n        /**\n         * @param {Object} item\n         * @private\n         */\n        _scrollIntoView: function (item) {\n            var borderTop, paddingTop, offset, scroll, elementHeight, itemHeight;\n\n            if (this._hasScroll()) {\n                borderTop = parseFloat($.css(this.activeMenu[0], 'borderTopWidth')) || 0;\n                paddingTop = parseFloat($.css(this.activeMenu[0], 'paddingTop')) || 0;\n                offset = item.offset().top - this.activeMenu.offset().top - borderTop - paddingTop;\n                scroll = this.activeMenu.scrollTop();\n                elementHeight = this.activeMenu.height();\n                itemHeight = item.height();\n\n                if (offset < 0) {\n                    this.activeMenu.scrollTop(scroll + offset);\n                } else if (offset + itemHeight > elementHeight) {\n                    this.activeMenu.scrollTop(scroll + offset - elementHeight + itemHeight);\n                }\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {*} fromFocus\n         */\n        blur: function (event, fromFocus) {\n            if (!fromFocus) {\n                clearTimeout(this.timer);\n            }\n\n            if (!this.active) {\n                return;\n            }\n\n            this.active.children('a').removeClass('ui-state-focus');\n            this.active = null;\n\n            this._trigger('blur', event, {\n                item: this.active\n            });\n        },\n\n        /**\n         * @param {*} submenu\n         * @private\n         */\n        _startOpening: function (submenu) {\n            clearTimeout(this.timer);\n\n            // Don't open if already open fixes a Firefox bug that caused a .5 pixel\n            // shift in the submenu position when mousing over the carat icon\n            if (submenu.attr('aria-hidden') !== 'true') {\n                return;\n            }\n\n            this.timer = this._delay(function () {\n                this._close();\n                this._open(submenu);\n            }, this.delay);\n        },\n\n        /**\n         * @param {*} submenu\n         * @private\n         */\n        _open: function (submenu) {\n            var position = $.extend({\n                of: this.active\n            }, this.options.position);\n\n            clearTimeout(this.timer);\n            this.element.find('.ui-menu').not(submenu.parents('.ui-menu'))\n                .hide()\n                .attr('aria-hidden', 'true');\n\n            submenu\n                .show()\n                .removeAttr('aria-hidden')\n                .attr('aria-expanded', 'true')\n                .position(position);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {*} all\n         */\n        collapseAll: function (event, all) {\n            clearTimeout(this.timer);\n            this.timer = this._delay(function () {\n                // If we were passed an event, look for the submenu that contains the event\n                var currentMenu = all ? this.element :\n                    $(event && event.target).closest(this.element.find('.ui-menu'));\n\n                // If we found no valid submenu ancestor, use the main menu to close all sub menus anyway\n                if (!currentMenu.length) {\n                    currentMenu = this.element;\n                }\n\n                this._close(currentMenu);\n\n                this.blur(event);\n                this.activeMenu = currentMenu;\n            }, this.delay);\n        },\n\n        // With no arguments, closes the currently active menu - if nothing is active\n        // it closes all menus.  If passed an argument, it will search for menus BELOW\n        /**\n         * With no arguments, closes the currently active menu - if nothing is active\n         * it closes all menus.  If passed an argument, it will search for menus BELOW.\n         *\n         * @param {*} startMenu\n         * @private\n         */\n        _close: function (startMenu) {\n            if (!startMenu) {\n                startMenu = this.active ? this.active.parent() : this.element;\n            }\n\n            startMenu\n                .find('.ui-menu')\n                .hide()\n                .attr('aria-hidden', 'true')\n                .attr('aria-expanded', 'false')\n                .end()\n                .find('a.ui-state-active')\n                .removeClass('ui-state-active');\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        collapse: function (event) {\n            var newItem = this.active &&\n                this.active.parent().closest('.ui-menu-item', this.element);\n\n            if (newItem && newItem.length) {\n                this._close();\n                this.focus(event, newItem);\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        expand: function (event) {\n            var newItem = this.active &&\n                this.active\n                    .children('.ui-menu ')\n                    .children('.ui-menu-item')\n                    .first();\n\n            if (newItem && newItem.length) {\n                this._open(newItem.parent());\n\n                // Delay so Firefox will not hide activedescendant change in expanding submenu from AT\n                this._delay(function () {\n                    this.focus(event, newItem);\n                });\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        next: function (event) {\n            this._move('next', 'first', event);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        previous: function (event) {\n            this._move('prev', 'last', event);\n        },\n\n        /**\n         * @return {null|Boolean}\n         */\n        isFirstItem: function () {\n            return this.active && !this.active.prevAll('.ui-menu-item').length;\n        },\n\n        /**\n         * @return {null|Boolean}\n         */\n        isLastItem: function () {\n            return this.active && !this.active.nextAll('.ui-menu-item').length;\n        },\n\n        /**\n         * @param {*} direction\n         * @param {*} filter\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _move: function (direction, filter, event) {\n            var next;\n\n            if (this.active) {\n                if (direction === 'first' || direction === 'last') {\n                    next = this.active\n                        [direction === 'first' ? 'prevAll' : 'nextAll']('.ui-menu-item')\n                        .eq(-1);\n                } else {\n                    next = this.active\n                        [direction + 'All']('.ui-menu-item')\n                        .eq(0);\n                }\n            }\n\n            if (!next || !next.length || !this.active) {\n                next = this.activeMenu.children('.ui-menu-item')[filter]();\n            }\n\n            this.focus(event, next);\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        nextPage: function (event) {\n            var item, base, height;\n\n            if (!this.active) {\n                this.next(event);\n\n                return;\n            }\n\n            if (this.isLastItem()) {\n                return;\n            }\n\n            if (this._hasScroll()) {\n                base = this.active.offset().top;\n                height = this.element.height();\n                this.active.nextAll('.ui-menu-item').each(function () {\n                    item = $(this);\n\n                    return item.offset().top - base - height < 0;\n                });\n\n                this.focus(event, item);\n            } else {\n                this.focus(event, this.activeMenu.children('.ui-menu-item')\n                    [!this.active ? 'first' : 'last']());\n            }\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        previousPage: function (event) {\n            var item, base, height;\n\n            if (!this.active) {\n                this.next(event);\n\n                return;\n            }\n\n            if (this.isFirstItem()) {\n                return;\n            }\n\n            if (this._hasScroll()) {\n                base = this.active.offset().top;\n                height = this.element.height();\n                this.active.prevAll('.ui-menu-item').each(function () {\n                    item = $(this);\n\n                    return item.offset().top - base + height > 0;\n                });\n\n                this.focus(event, item);\n            } else {\n                this.focus(event, this.activeMenu.children('.ui-menu-item').first());\n            }\n        },\n\n        /**\n         * @return {Boolean}\n         * @private\n         */\n        _hasScroll: function () {\n            return this.element.outerHeight() < this.element.prop('scrollHeight');\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         */\n        select: function (event) {\n            // TODO: It should never be possible to not have an active item at this\n            // point, but the tests don't trigger mouseenter before click.\n            var ui;\n\n            this.active = this.active || $(event.target).closest('.ui-menu-item');\n            ui = {\n                item: this.active\n            };\n\n            if (!this.active.has('.ui-menu').length) {\n                this.collapseAll(event, true);\n            }\n            this._trigger('select', event, ui);\n        }\n    });\n\n    return $.mage.menu;\n});\n","mage/backend/notification.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.notification', {\n        options: {\n            templates: {\n                global: '<div data-role=\"messages\" id=\"messages\">' +\n                    '<div class=\"message <% if (data.error) { %>error<% } %>\"><div><%- data.message %></div></div>' +\n                '</div>',\n                error: '<div data-role=\"messages\" id=\"messages\">' +\n                    '<div class=\"messages\"><div class=\"message message-error error\">' +\n                        '<div data-ui-id=\"messages-message-error\"><%- data.message %></div></div>' +\n                    '</div></div>'\n            }\n        },\n        placeholder: '[data-role=messages]',\n\n        /**\n         * Notification creation\n         * @protected\n         */\n        _create: function () {\n            $(document).on('ajaxComplete ajaxError', $.proxy(this._add, this));\n        },\n\n        /**\n         * Add new message\n         * @protected\n         * @param {Object} event - object\n         * @param {Object} jqXHR - The jQuery XMLHttpRequest object returned by $.ajax()\n         */\n        _add: function (event, jqXHR) {\n            var response;\n\n            try {\n                response = JSON.parse(jqXHR.responseText);\n\n                if (response && response.error && response['html_message']) {\n                    $(this.placeholder).html(response['html_message']);\n                }\n            } catch (e) {}\n        },\n\n        /**\n         * Adds new message.\n         *\n         * @param {Object} data - Data with a message to be displayed.\n         */\n        add: function (data) {\n            var template = data.error ? this.options.templates.error : this.options.templates.global,\n                message = mageTemplate(template, {\n                    data: data\n                }),\n                messageContainer;\n\n            if (typeof data.insertMethod === 'function') {\n                data.insertMethod(message);\n            } else {\n                messageContainer = data.messageContainer || this.placeholder;\n                $(messageContainer).prepend(message);\n            }\n\n            return this;\n        },\n\n        /**\n         * Removes error messages.\n         */\n        clear: function () {\n            $(this.placeholder).html('');\n        }\n    });\n\n    return $.mage.notification;\n});\n","mage/backend/suggest.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'mage/mage',\n    'jquery/ui',\n    'mage/backend/menu',\n    'mage/translate'\n], function ($, mageTemplate) {\n    'use strict';\n\n    /**\n     * Implement base functionality\n     */\n    $.widget('mage.suggest', {\n        widgetEventPrefix: 'suggest',\n        options: {\n            template: '<% if (data.items.length) { %>' +\n                '<% if (!data.term && !data.allShown() && data.recentShown()) { %>' +\n                '<h5 class=\"title\"><%- data.recentTitle %></h5>' +\n                '<% } %>' +\n                '<ul data-mage-init=\\'{\"menu\":[]}\\'>' +\n                '<% _.each(data.items, function(value){ %>' +\n                '<% if (!data.itemSelected(value)) { %><li <%= data.optionData(value) %>>' +\n                '<a href=\"#\"><%- value.label %></a></li><% } %>' +\n                '<% }); %>' +\n                '<% if (!data.term && !data.allShown() && data.recentShown()) { %>' +\n                '<li data-mage-init=\\'{\"actionLink\":{\"event\":\"showAll\"}}\\' class=\"show-all\">' +\n                '<a href=\"#\"><%- data.showAllTitle %></a></li>' +\n                '<% } %>' +\n                '</ul><% } else { %><span class=\"mage-suggest-no-records\"><%- data.noRecordsText %></span><% } %>',\n            minLength: 1,\n\n            /**\n             * @type {(String|Array)}\n             */\n            source: null,\n            delay: 500,\n            loadingClass: 'mage-suggest-state-loading',\n            events: {},\n            appendMethod: 'after',\n            controls: {\n                selector: ':ui-menu, :mage-menu',\n                eventsMap: {\n                    focus: ['menufocus'],\n                    blur: ['menublur'],\n                    select: ['menuselect']\n                }\n            },\n            termAjaxArgument: 'label_part',\n            filterProperty: 'label',\n            className: null,\n            inputWrapper: '<div class=\"mage-suggest\"><div class=\"mage-suggest-inner\"></div></div>',\n            dropdownWrapper: '<div class=\"mage-suggest-dropdown\"></div>',\n            preventClickPropagation: true,\n            currentlySelected: null,\n            submitInputOnEnter: true\n        },\n\n        /**\n         * Component's constructor\n         * @private\n         */\n        _create: function () {\n            this._term = null;\n            this._nonSelectedItem = {\n                id: '',\n                label: ''\n            };\n            this.templates = {};\n            this._renderedContext = null;\n            this._selectedItem = this._nonSelectedItem;\n            this._control = this.options.controls || {};\n            this._setTemplate();\n            this._prepareValueField();\n            this._render();\n            this._bind();\n        },\n\n        /**\n         * Render base elements for suggest component\n         * @private\n         */\n        _render: function () {\n            var wrapper;\n\n            this.dropdown = $(this.options.dropdownWrapper).hide();\n            wrapper = this.options.className ?\n                $(this.options.inputWrapper).addClass(this.options.className) :\n                $(this.options.inputWrapper);\n            this.element\n                .wrap(wrapper)[this.options.appendMethod](this.dropdown)\n                .attr('autocomplete', 'off');\n        },\n\n        /**\n         * Define a field for storing item id (find in DOM or create a new one)\n         * @private\n         */\n        _prepareValueField: function () {\n            if (this.options.valueField) {\n                this.valueField = $(this.options.valueField);\n            } else {\n                this.valueField = this._createValueField()\n                    .insertBefore(this.element)\n                    .attr('name', this.element.attr('name'));\n                this.element.removeAttr('name');\n            }\n        },\n\n        /**\n         * Create value field which keeps a id for selected option\n         * can be overridden in descendants\n         * @return {jQuery}\n         * @private\n         */\n        _createValueField: function () {\n            return $('<input/>', {\n                type: 'hidden'\n            });\n        },\n\n        /**\n         * Component's destructor\n         * @private\n         */\n        _destroy: function () {\n            this.element\n                .unwrap()\n                .removeAttr('autocomplete');\n\n            if (!this.options.valueField) {\n                this.element.attr('name', this.valueField.attr('name'));\n                this.valueField.remove();\n            }\n\n            this.dropdown.remove();\n            this._off(this.element, 'keydown keyup blur');\n        },\n\n        /**\n         * Return actual value of an \"input\"-element\n         * @return {String}\n         * @private\n         */\n        _value: function () {\n            return this.element[this.element.is(':input') ? 'val' : 'text']().trim();\n        },\n\n        /**\n         * Pass original event to a control component for handling it as it's own event\n         * @param {Object} event - event object\n         * @private\n         */\n        _proxyEvents: function (event) {\n            var fakeEvent = $.extend({}, $.Event(event.type), {\n                    ctrlKey: event.ctrlKey,\n                    keyCode: event.keyCode,\n                    which: event.keyCode\n                }),\n                target = this._control.selector ? this.dropdown.find(this._control.selector) : this.dropdown;\n\n            target.trigger(fakeEvent);\n        },\n\n        /**\n         * Bind handlers on specific events\n         * @private\n         */\n        _bind: function () {\n            this._on($.extend({\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                keydown: function (event) {\n                    var keyCode = $.ui.keyCode,\n                        suggestList,\n                        hasSuggestedItems,\n                        hasSelectedItems,\n                        selectedItem;\n\n                    switch (event.keyCode) {\n                        case keyCode.PAGE_UP:\n                        case keyCode.UP:\n                            if (!event.shiftKey) {\n                                event.preventDefault();\n                                this._proxyEvents(event);\n                            }\n\n                            suggestList = event.currentTarget.parentNode.getElementsByTagName('ul')[0];\n                            hasSuggestedItems = event.currentTarget\n                                    .parentNode.getElementsByTagName('ul')[0].children.length >= 0;\n\n                            if (hasSuggestedItems) {\n                                selectedItem =  $(suggestList.getElementsByClassName('_active')[0])\n                                    .removeClass('_active').prev().addClass('_active');\n                                event.currentTarget.value = selectedItem.find('a').text();\n                            }\n\n                            break;\n\n                        case keyCode.PAGE_DOWN:\n                        case keyCode.DOWN:\n                            if (!event.shiftKey) {\n                                event.preventDefault();\n                                this._proxyEvents(event);\n                            }\n\n                            suggestList = event.currentTarget.parentNode.getElementsByTagName('ul')[0];\n                            hasSuggestedItems = event.currentTarget\n                                .parentNode.getElementsByTagName('ul')[0].children.length >= 0;\n\n                            if (hasSuggestedItems) {\n                                hasSelectedItems = suggestList.getElementsByClassName('_active').length === 0;\n\n                                if (hasSelectedItems) { //eslint-disable-line max-depth\n                                    selectedItem = $(suggestList.children[0]).addClass('_active');\n                                    event.currentTarget.value = selectedItem.find('a').text();\n                                } else {\n                                    selectedItem = $(suggestList.getElementsByClassName('_active')[0])\n                                        .removeClass('_active').next().addClass('_active');\n                                    event.currentTarget.value = selectedItem.find('a').text();\n                                }\n                            }\n                            break;\n\n                        case keyCode.TAB:\n                            if (this.isDropdownShown()) {\n                                this._onSelectItem(event, null);\n                                event.preventDefault();\n                            }\n                            break;\n\n                        case keyCode.ENTER:\n                        case keyCode.NUMPAD_ENTER:\n                            this._toggleEnter(event);\n\n                            if (this.isDropdownShown() && this._focused) {\n                                this._proxyEvents(event);\n                                event.preventDefault();\n                            }\n                            break;\n\n                        case keyCode.ESCAPE:\n                            if (this.isDropdownShown()) {\n                                event.stopPropagation();\n                            }\n                            this.close(event);\n                            this._blurItem();\n                            break;\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                keyup: function (event) {\n                    var keyCode = $.ui.keyCode;\n\n                    switch (event.keyCode) {\n                        case keyCode.HOME:\n                        case keyCode.END:\n                        case keyCode.PAGE_UP:\n                        case keyCode.PAGE_DOWN:\n                        case keyCode.ESCAPE:\n                        case keyCode.UP:\n                        case keyCode.DOWN:\n                        case keyCode.LEFT:\n                        case keyCode.RIGHT:\n                        case keyCode.TAB:\n                            break;\n\n                        case keyCode.ENTER:\n                        case keyCode.NUMPAD_ENTER:\n                            if (this.isDropdownShown()) {\n                                event.preventDefault();\n                            }\n                            break;\n                        default:\n                            this.search(event);\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                blur: function (event) {\n                    if (!this.preventBlur) {\n                        this._abortSearch();\n                        this.close(event);\n                        this._change(event);\n                    } else {\n                        this.element.trigger('focus');\n                    }\n                },\n                cut: this.search,\n                paste: this.search,\n                input: this.search,\n                selectItem: this._onSelectItem,\n                click: this.search\n            }, this.options.events));\n\n            this._bindSubmit();\n            this._bindDropdown();\n        },\n\n        /**\n         * @param {Object} event\n         * @private\n         */\n        _toggleEnter: function (event) {\n            var suggestList,\n                activeItems,\n                selectedItem;\n\n            if (!this.options.submitInputOnEnter) {\n                event.preventDefault();\n            }\n\n            suggestList = $(event.currentTarget.parentNode).find('ul').first();\n            activeItems = suggestList.find('._active');\n\n            if (activeItems.length >= 0) {\n                selectedItem = activeItems.first();\n\n                if (selectedItem.find('a') && selectedItem.find('a').attr('href') !== undefined) {\n                    window.location = selectedItem.find('a').attr('href');\n                    event.preventDefault();\n                }\n            }\n        },\n\n        /**\n         * Bind handlers for submit on enter\n         * @private\n         */\n        _bindSubmit: function () {\n            this.element.parents('form').on('submit', function (event) {\n                if (!this.submitInputOnEnter) {\n                    event.preventDefault();\n                }\n            });\n        },\n\n        /**\n         * @param {Object} e - event object\n         * @private\n         */\n        _change: function (e) {\n            if (this._term !== this._value()) {\n                this._trigger('change', e);\n            }\n        },\n\n        /**\n         * Bind handlers for dropdown element on specific events\n         * @private\n         */\n        _bindDropdown: function () {\n            var events = {\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                click: function (e) {\n                    // prevent default browser's behavior of changing location by anchor href\n                    e.preventDefault();\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                mousedown: function (e) {\n                    e.preventDefault();\n                }\n            };\n\n            $.each(this._control.eventsMap, $.proxy(function (suggestEvent, controlEvents) {\n                $.each(controlEvents, $.proxy(function (i, handlerName) {\n                    switch (suggestEvent) {\n                        case 'select':\n                            events[handlerName] = this._onSelectItem;\n                            break;\n\n                        case 'focus':\n                            events[handlerName] = this._focusItem;\n                            break;\n\n                        case 'blur':\n                            events[handlerName] = this._blurItem;\n                            break;\n                    }\n                }, this));\n            }, this));\n\n            if (this.options.preventClickPropagation) {\n                this._on(this.dropdown, events);\n            }\n            // Fix for IE 8\n            this._on(this.dropdown, {\n                /**\n                 * Mousedown.\n                 */\n                mousedown: function () {\n                    this.preventBlur = true;\n                },\n\n                /**\n                 * Mouseup.\n                 */\n                mouseup: function () {\n                    this.preventBlur = false;\n                }\n            });\n        },\n\n        /**\n         * @override\n         */\n        _trigger: function (type, event) {\n            var result = this._superApply(arguments);\n\n            if (result === false && event) {\n                event.stopImmediatePropagation();\n                event.preventDefault();\n            }\n\n            return result;\n        },\n\n        /**\n         * Handle focus event of options item\n         * @param {Object} e - event object\n         * @param {Object} ui - object that can contain information about focused item\n         * @private\n         */\n        _focusItem: function (e, ui) {\n            if (ui && ui.item) {\n                this._focused = $(ui.item).prop('tagName') ?\n                    this._readItemData(ui.item) :\n                    ui.item;\n\n                this.element.val(this._focused.label);\n                this._trigger('focus', e, {\n                    item: this._focused\n                });\n            }\n        },\n\n        /**\n         * Handle blur event of options item\n         * @private\n         */\n        _blurItem: function () {\n            this._focused = null;\n            this.element.val(this._term);\n        },\n\n        /**\n         * @param {Object} e - event object\n         * @param {Object} item\n         * @private\n         */\n        _onSelectItem: function (e, item) {\n            if (item && typeof item === 'object' && $(e.target).is(this.element)) {\n                this._focusItem(e, {\n                    item: item\n                });\n            }\n\n            if (this._trigger('beforeselect', e || null, {\n                    item: this._focused\n                }) === false) {\n                return;\n            }\n            this._selectItem(e);\n            this._blurItem();\n            this._trigger('select', e || null, {\n                item: this._selectedItem\n            });\n        },\n\n        /**\n         * Save selected item and hide dropdown\n         * @private\n         * @param {Object} e - event object\n         */\n        _selectItem: function (e) {\n            if (this._focused) {\n                this._selectedItem = this._focused;\n\n                if (this._selectedItem !== this._nonSelectedItem) {\n                    this._term = this._selectedItem.label;\n                    this.valueField.val(this._selectedItem.id);\n                    this.close(e);\n                }\n            }\n        },\n\n        /**\n         * Read option data from item element\n         * @param {Element} element\n         * @return {Object}\n         * @private\n         */\n        _readItemData: function (element) {\n            return element.data('suggestOption') || this._nonSelectedItem;\n        },\n\n        /**\n         * Check if dropdown is shown\n         * @return {Boolean}\n         */\n        isDropdownShown: function () {\n            return this.dropdown.is(':visible');\n        },\n\n        /**\n         * Open dropdown\n         * @private\n         * @param {Object} e - event object\n         */\n        open: function (e) {\n            if (!this.isDropdownShown()) {\n                this.element.addClass('_suggest-dropdown-open');\n                this.dropdown.show();\n                this._trigger('open', e);\n            }\n        },\n\n        /**\n         * Close and clear dropdown content\n         * @private\n         * @param {Object} e - event object\n         */\n        close: function (e) {\n            this._renderedContext = null;\n\n            if (this.dropdown.length) {\n                this.element.removeClass('_suggest-dropdown-open');\n                this.dropdown.hide().empty();\n            }\n\n            this._trigger('close', e);\n        },\n\n        /**\n         * Acquire content template\n         * @private\n         */\n        _setTemplate: function () {\n            this.templateName = 'suggest' + Math.random().toString(36).substr(2);\n\n            this.templates[this.templateName] = mageTemplate(this.options.template);\n        },\n\n        /**\n         * Execute search process\n         * @public\n         * @param {Object} e - event object\n         */\n        search: function (e) {\n            var term = this._value();\n\n            if ((this._term !== term || term.length === 0) && !this.preventBlur) {\n                this._term = term;\n\n                if (typeof term === 'string' && term.length >= this.options.minLength) {\n                    if (this._trigger('search', e) === false) { //eslint-disable-line max-depth\n                        return;\n                    }\n                    this._search(e, term, {});\n                } else {\n                    this._selectedItem = this._nonSelectedItem;\n                    this._resetSuggestValue();\n                }\n            }\n        },\n\n        /**\n         * Clear suggest hidden input\n         * @private\n         */\n        _resetSuggestValue: function () {\n            this.valueField.val(this._nonSelectedItem.id);\n        },\n\n        /**\n         * Actual search method, can be overridden in descendants\n         * @param {Object} e - event object\n         * @param {String} term - search phrase\n         * @param {Object} context - search context\n         * @private\n         */\n        _search: function (e, term, context) {\n            var response = $.proxy(function (items) {\n                return this._processResponse(e, items, context || {});\n            }, this);\n\n            this.element.addClass(this.options.loadingClass);\n\n            if (this.options.delay) {\n                if (typeof this.options.data !== 'undefined') {\n                    response(this.filter(this.options.data, term));\n                }\n                clearTimeout(this._searchTimeout);\n                this._searchTimeout = this._delay(function () {\n                    this._source(term, response);\n                }, this.options.delay);\n            } else {\n                this._source(term, response);\n            }\n        },\n\n        /**\n         * Extend basic context with additional data (search results, search term)\n         * @param {Object} context\n         * @return {Object}\n         * @private\n         */\n        _prepareDropdownContext: function (context) {\n            return $.extend(context, {\n                items: this._items,\n                term: this._term,\n\n                /**\n                 * @param {Object} item\n                 * @return {String}\n                 */\n                optionData: function (item) {\n                    return 'data-suggest-option=\"' +\n                        $('<div>').text(JSON.stringify(item)).html().replace(/\"/g, '&quot;') + '\"';\n                },\n                itemSelected: $.proxy(this._isItemSelected, this),\n                noRecordsText: $.mage.__('No records found.')\n            });\n        },\n\n        /**\n         * @param {Object} item\n         * @return {Boolean}\n         * @private\n         */\n        _isItemSelected: function (item) {\n            return item.id == (this._selectedItem && this._selectedItem.id ? //eslint-disable-line eqeqeq\n                this._selectedItem.id :\n                this.options.currentlySelected);\n        },\n\n        /**\n         * Render content of suggest's dropdown\n         * @param {Object} e - event object\n         * @param {Array} items - list of label+id objects\n         * @param {Object} context - template's context\n         * @private\n         */\n        _renderDropdown: function (e, items, context) {\n            var tmpl = this.templates[this.templateName];\n\n            this._items = items;\n\n            tmpl = tmpl({\n                data: this._prepareDropdownContext(context)\n            });\n\n            $(tmpl).appendTo(this.dropdown.empty());\n\n            this.dropdown.trigger('contentUpdated')\n                .find(this._control.selector).on('focus', function (event) {\n                    event.preventDefault();\n                });\n\n            this._renderedContext = context;\n            this.element.removeClass(this.options.loadingClass);\n            this.open(e);\n        },\n\n        /**\n         * @param {Object} e\n         * @param {Object} items\n         * @param {Object} context\n         * @private\n         */\n        _processResponse: function (e, items, context) {\n            var renderer = $.proxy(function (i) {\n                return this._renderDropdown(e, i, context || {});\n            }, this);\n\n            if (this._trigger('response', e, [items, renderer]) === false) {\n                return;\n            }\n            this._renderDropdown(e, items, context);\n        },\n\n        /**\n         * Implement search process via spesific source\n         * @param {String} term - search phrase\n         * @param {Function} response - search results handler, process search result\n         * @private\n         */\n        _source: function (term, response) {\n            var o = this.options,\n                ajaxData;\n\n            if (Array.isArray(o.source)) {\n                response(this.filter(o.source, term));\n            } else if (typeof o.source === 'string') {\n                ajaxData = {};\n                ajaxData[this.options.termAjaxArgument] = term;\n\n                this._xhr = $.ajax($.extend(true, {\n                    url: o.source,\n                    type: 'POST',\n                    dataType: 'json',\n                    data: ajaxData,\n                    success: $.proxy(function (items) {\n                        this.options.data = items;\n                        response.apply(response, arguments);\n                    }, this)\n                }, o.ajaxOptions || {}));\n            } else if (typeof o.source === 'function') {\n                o.source.apply(o.source, arguments);\n            }\n        },\n\n        /**\n         * Abort search process\n         * @private\n         */\n        _abortSearch: function () {\n            this.element.removeClass(this.options.loadingClass);\n            clearTimeout(this._searchTimeout);\n        },\n\n        /**\n         * Perform filtering in advance loaded items and returns search result\n         * @param {Array} items - all available items\n         * @param {String} term - search phrase\n         * @return {Object}\n         */\n        filter: function (items, term) {\n            var matcher = new RegExp(term.replace(/[\\-\\/\\\\\\^$*+?.()|\\[\\]{}]/g, '\\\\$&'), 'i'),\n                itemsArray = Array.isArray(items) ? items : $.map(items, function (element) {\n                    return element;\n                }),\n                property = this.options.filterProperty;\n\n            return $.grep(\n                itemsArray,\n                function (value) {\n                    return matcher.test(value[property] || value.id || value);\n                }\n            );\n        }\n    });\n\n    /**\n     * Implement show all functionality and storing and display recent searches\n     */\n    $.widget('mage.suggest', $.mage.suggest, {\n        options: {\n            showRecent: false,\n            showAll: false,\n            storageKey: 'suggest',\n            storageLimit: 10\n        },\n\n        /**\n         * @override\n         */\n        _create: function () {\n            var recentItems;\n\n            if (this.options.showRecent && window.localStorage) {\n                recentItems = JSON.parse(localStorage.getItem(this.options.storageKey));\n\n                /**\n                 * @type {Array} - list of recently searched items\n                 * @private\n                 */\n                this._recentItems = Array.isArray(recentItems) ? recentItems : [];\n            }\n            this._super();\n        },\n\n        /**\n         * @override\n         */\n        _bind: function () {\n            this._super();\n            this._on(this.dropdown, {\n                /**\n                 * @param {jQuery.Event} e\n                 */\n                showAll: function (e) {\n                    e.stopImmediatePropagation();\n                    e.preventDefault();\n                    this.element.trigger('showAll');\n                }\n            });\n\n            if (this.options.showRecent || this.options.showAll) {\n                this._on({\n                    /**\n                     * @param {jQuery.Event} e\n                     */\n                    focus: function (e) {\n                        if (!this.isDropdownShown()) {\n                            this.search(e);\n                        }\n                    },\n                    showAll: this._showAll\n                });\n            }\n        },\n\n        /**\n         * @private\n         * @param {Object} e - event object\n         */\n        _showAll: function (e) {\n            this._abortSearch();\n            this._search(e, '', {\n                _allShown: true\n            });\n        },\n\n        /**\n         * @override\n         */\n        search: function (e) {\n            if (!this._value()) {\n\n                if (this.options.showRecent) {\n\n                    if (this._recentItems.length) { //eslint-disable-line max-depth\n                        this._processResponse(e, this._recentItems, {});\n                    } else {\n                        this._showAll(e);\n                    }\n                } else if (this.options.showAll) {\n                    this._showAll(e);\n                }\n            }\n            this._superApply(arguments);\n        },\n\n        /**\n         * @override\n         */\n        _selectItem: function () {\n            this._superApply(arguments);\n\n            if (this._selectedItem && this._selectedItem.id && this.options.showRecent) {\n                this._addRecent(this._selectedItem);\n            }\n        },\n\n        /**\n         * @override\n         */\n        _prepareDropdownContext: function () {\n            var context = this._superApply(arguments);\n\n            return $.extend(context, {\n                recentShown: $.proxy(function () {\n                    return this.options.showRecent;\n                }, this),\n                recentTitle: $.mage.__('Recent items'),\n                showAllTitle: $.mage.__('Show all...'),\n\n                /**\n                 * @return {Boolean}\n                 */\n                allShown: function () {\n                    return !!context._allShown;\n                }\n            });\n        },\n\n        /**\n         * Add selected item of search result into storage of recents\n         * @param {Object} item - label+id object\n         * @private\n         */\n        _addRecent: function (item) {\n            this._recentItems = $.grep(this._recentItems, function (obj) {\n                return obj.id !== item.id;\n            });\n            this._recentItems.unshift(item);\n            this._recentItems = this._recentItems.slice(0, this.options.storageLimit);\n            localStorage.setItem(this.options.storageKey, JSON.stringify(this._recentItems));\n        }\n    });\n\n    /**\n     * Implement multi suggest functionality\n     */\n    $.widget('mage.suggest', $.mage.suggest, {\n        options: {\n            multiSuggestWrapper: '<ul class=\"mage-suggest-choices\">' +\n                '<li class=\"mage-suggest-search-field\" data-role=\"parent-choice-element\"><' +\n                'label class=\"mage-suggest-search-label\"></label></li></ul>',\n            choiceTemplate: '<li class=\"mage-suggest-choice button\"><div><%- text %></div>' +\n            '<span class=\"mage-suggest-choice-close\" tabindex=\"-1\" ' +\n            'data-mage-init=\\'{\"actionLink\":{\"event\":\"removeOption\"}}\\'></span></li>',\n            selectedClass: 'mage-suggest-selected'\n        },\n\n        /**\n         * @override\n         */\n        _create: function () {\n            this.choiceTmpl = mageTemplate(this.options.choiceTemplate);\n\n            this._super();\n\n            if (this.options.multiselect) {\n                this.valueField.hide();\n            }\n        },\n\n        /**\n         * @override\n         */\n        _render: function () {\n            this._super();\n\n            if (this.options.multiselect) {\n                this._renderMultiselect();\n            }\n        },\n\n        /**\n         * Render selected options\n         * @private\n         */\n        _renderMultiselect: function () {\n            var that = this;\n\n            this.element.wrap(this.options.multiSuggestWrapper);\n            this.elementWrapper = this.element.closest('[data-role=\"parent-choice-element\"]');\n            $(function () {\n                that._getOptions()\n                    .each(function (i, option) {\n                        option = $(option);\n                        that._createOption({\n                            id: option.val(),\n                            label: option.text()\n                        });\n                    });\n            });\n        },\n\n        /**\n         * @return {Array} array of DOM-elements\n         * @private\n         */\n        _getOptions: function () {\n            return this.valueField.find('option');\n        },\n\n        /**\n         * @override\n         */\n        _bind: function () {\n            this._super();\n\n            if (this.options.multiselect) {\n                this._on({\n                    /**\n                     * @param {jQuery.Event} event\n                     */\n                    keydown: function (event) {\n                        if (event.keyCode === $.ui.keyCode.BACKSPACE) {\n                            if (!this._value()) {\n                                this._removeLastAdded(event);\n                            }\n                        }\n                    },\n                    removeOption: this.removeOption\n                });\n            }\n        },\n\n        /**\n         * @param {Array} items\n         * @return {Array}\n         * @private\n         */\n        _filterSelected: function (items) {\n            var options = this._getOptions();\n\n            return $.grep(items, function (value) {\n                var itemSelected = false;\n\n                $.each(options, function () {\n                    if (value.id == $(this).val()) { //eslint-disable-line eqeqeq\n                        itemSelected = true;\n                    }\n                });\n\n                return !itemSelected;\n            });\n        },\n\n        /**\n         * @override\n         */\n        _processResponse: function (e, items, context) {\n            if (this.options.multiselect) {\n                items = this._filterSelected(items, context);\n            }\n            this._superApply([e, items, context]);\n        },\n\n        /**\n         * @override\n         */\n        _prepareValueField: function () {\n            this._super();\n\n            if (this.options.multiselect && !this.options.valueField && this.options.selectedItems) {\n                $.each(this.options.selectedItems, $.proxy(function (i, item) {\n                    this._addOption(item);\n                }, this));\n            }\n        },\n\n        /**\n         * If \"multiselect\" option is set, then do not need to clear value for hidden select, to avoid losing of\n         *      previously selected items\n         * @override\n         */\n        _resetSuggestValue: function () {\n            if (!this.options.multiselect) {\n                this._super();\n            }\n        },\n\n        /**\n         * @override\n         */\n        _createValueField: function () {\n            if (this.options.multiselect) {\n                return $('<select></select>', {\n                    type: 'hidden',\n                    multiple: 'multiple'\n                });\n            }\n\n            return this._super();\n        },\n\n        /**\n         * @override\n         */\n        _selectItem: function (e) {\n            if (this.options.multiselect) {\n                if (this._focused) {\n                    this._selectedItem = this._focused;\n\n                    /* eslint-disable max-depth */\n                    if (this._selectedItem !== this._nonSelectedItem) {\n                        this._term = '';\n                        this.element.val(this._term);\n\n                        if (this._isItemSelected(this._selectedItem)) {\n                            $(e.target).removeClass(this.options.selectedClass);\n                            this.removeOption(e, this._selectedItem);\n                            this._selectedItem = this._nonSelectedItem;\n                        } else {\n                            $(e.target).addClass(this.options.selectedClass);\n                            this._addOption(e, this._selectedItem);\n                        }\n                    }\n\n                    /* eslint-enable max-depth */\n                }\n                this.close(e);\n            } else {\n                this._superApply(arguments);\n            }\n        },\n\n        /**\n         * @override\n         */\n        _isItemSelected: function (item) {\n            if (this.options.multiselect) {\n                return this.valueField.find('option[value=' + item.id + ']').length > 0;\n            }\n\n            return this._superApply(arguments);\n        },\n\n        /**\n         *\n         * @param {Object} item\n         * @return {Element}\n         * @private\n         */\n        _createOption: function (item) {\n            var option = this._getOption(item);\n\n            if (!option.length) {\n                option = $('<option>', {\n                    value: item.id,\n                    selected: true\n                }).text(item.label);\n            }\n\n            return option.data('renderedOption', this._renderOption(item));\n        },\n\n        /**\n         * Add selected item in to select options\n         * @param {Object} e - event object\n         * @param {*} item\n         * @private\n         */\n        _addOption: function (e, item) {\n            this.valueField.append(this._createOption(item).data('selectTarget', $(e.target)));\n        },\n\n        /**\n         * @param {Object|Element} item\n         * @return {Element}\n         * @private\n         */\n        _getOption: function (item) {\n            return $(item).prop('tagName') ?\n                $(item) :\n                this.valueField.find('option[value=' + item.id + ']');\n        },\n\n        /**\n         * Remove last added option\n         * @private\n         * @param {Object} e - event object\n         */\n        _removeLastAdded: function (e) {\n            var lastAdded = this._getOptions().last();\n\n            if (lastAdded.length) {\n                this.removeOption(e, lastAdded);\n            }\n        },\n\n        /**\n         * Remove item from select options\n         * @param {Object} e - event object\n         * @param {Object} item\n         * @private\n         */\n        removeOption: function (e, item) {\n            var option = this._getOption(item),\n                selectTarget = option.data('selectTarget');\n\n            if (selectTarget && selectTarget.length) {\n                selectTarget.removeClass(this.options.selectedClass);\n            }\n\n            option.data('renderedOption').remove();\n            option.remove();\n        },\n\n        /**\n         * Render visual element of selected item\n         * @param {Object} item - selected item\n         * @private\n         */\n        _renderOption: function (item) {\n            var tmpl = this.choiceTmpl({\n                text: item.label\n            });\n\n            return $(tmpl)\n                .insertBefore(this.elementWrapper)\n                .trigger('contentUpdated')\n                .on('removeOption', $.proxy(function (e) {\n                    this.removeOption(e, item);\n                }, this));\n        }\n    });\n\n    return $.mage.suggest;\n});\n","mage/backend/tabs.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY */\ndefine([\n    'jquery',\n    'jquery/ui',\n    'jquery/ui-modules/widgets/tabs'\n], function ($) {\n    'use strict';\n\n    var rhash, isLocal;\n\n    // mage.tabs base functionality\n    $.widget('mage.tabs', $.ui.tabs, {\n        options: {\n            spinner: false,\n            groups: null,\n            tabPanelClass: '',\n            excludedPanel: ''\n        },\n\n        /**\n         * Tabs creation\n         * @protected\n         */\n        _create: function () {\n            var activeIndex = this._getTabIndex(this.options.active);\n\n            this.options.active = activeIndex >= 0 ? activeIndex : 0;\n            this._super();\n        },\n\n        /**\n         * @override\n         * @private\n         * @return {Array} Array of DOM-elements\n         */\n        _getList: function () {\n            if (this.options.groups) {\n                return this.element.find(this.options.groups);\n            }\n\n            return this._super();\n        },\n\n        /**\n         * Get active anchor\n         * @return {Element}\n         */\n        activeAnchor: function () {\n            return this.anchors.eq(this.option('active'));\n        },\n\n        /**\n         * Get tab index by tab id\n         * @protected\n         * @param {String} id - id of tab\n         * @return {Number}\n         */\n        _getTabIndex: function (id) {\n            var anchors = this.anchors ?\n                this.anchors :\n                this._getList().find('> li > a[href]');\n\n            return anchors.index($('#' + id));\n        },\n\n        /**\n         * Switch between tabs\n         * @protected\n         * @param {Object} event - event object\n         * @param {undefined|Object} eventData\n         */\n        _toggle: function (event, eventData) {\n            var anchor = $(eventData.newTab).find('a');\n\n            if ($(eventData.newTab).find('a').data().tabType === 'link') {\n                location.href = anchor.prop('href');\n            } else {\n                this._superApply(arguments);\n            }\n        }\n    });\n\n    rhash = /#.*$/;\n\n    /**\n     * @param {*} anchor\n     * @return {Boolean}\n     */\n    isLocal = function (anchor) {\n        return anchor.hash.length > 1 &&\n            anchor.href.replace(rhash, '') ===\n                location.href.replace(rhash, '')\n                    // support: Safari 5.1\n                    // Safari 5.1 doesn't encode spaces in window.location\n                    // but it does encode spaces from anchors (#8777)\n                    .replace(/\\s/g, '%20');\n    };\n\n    // Extension for mage.tabs - Move panels in destination element\n    $.widget('mage.tabs', $.mage.tabs, {\n        /**\n         * Move panels in destination element on creation\n         * @protected\n         * @override\n         */\n        _create: function () {\n            this._super();\n            this._movePanelsInDestination(this.panels);\n        },\n\n        /**\n         * Get panel for tab. If panel no exist in tabs container, then find panel in destination element\n         * @protected\n         * @override\n         * @param {Element} tab - tab \"li\" DOM-element\n         * @return {Element}\n         */\n        _getPanelForTab: function (tab) {\n            var panel = this._superApply(arguments),\n                id;\n\n            if (!panel.length) {\n                id = $(tab).attr('aria-controls');\n                panel = $(this.options.destination).find(this._sanitizeSelector('#' + id));\n            }\n\n            return panel;\n        },\n\n        /**\n         * @private\n         */\n        _processTabs: function () {\n            var that = this;\n\n            this.tablist = this._getList()\n                .addClass('ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all')\n                .attr('role', 'tablist');\n\n            this.tabs = this.tablist.find('> li:has(a[href])')\n                .addClass('ui-state-default ui-corner-top')\n                .attr({\n                    role: 'tab',\n                    tabIndex: -1\n                });\n\n            this.anchors = this.tabs.map(function () {\n                return $('a', this)[ 0 ];\n            })\n                .addClass('ui-tabs-anchor')\n                .attr({\n                    role: 'presentation',\n                    tabIndex: -1\n                });\n\n            this.panels = $();\n\n            this.anchors.each(function (i, anchor) {\n                var selector, panel, panelId,\n                    anchorId = $(anchor).uniqueId().attr('id'),\n                    tab = $(anchor).closest('li'),\n                    originalAriaControls = tab.attr('aria-controls');\n\n                // inline tab\n                if (isLocal(anchor)) {\n                    selector = anchor.hash;\n                    panel = that.document.find(that._sanitizeSelector(selector));\n                    // remote tab\n                } else {\n                    panelId = tab.attr('aria-controls') || $({}).uniqueId()[ 0 ].id;\n                    selector = '#' + panelId;\n                    panel = that.element.find(selector);\n\n                    if (!panel.length) {\n                        panel = that._createPanel(panelId);\n                        panel.insertAfter(that.panels[ i - 1 ] || that.tablist);\n                    }\n                    panel.attr('aria-live', 'polite');\n                }\n\n                if (panel.length) {\n                    that.panels = that.panels.add(panel);\n                }\n\n                if (originalAriaControls) {\n                    tab.data('ui-tabs-aria-controls', originalAriaControls);\n                }\n                tab.attr({\n                    'aria-controls': selector.substring(1),\n                    'aria-labelledby': anchorId\n                });\n                panel.attr('aria-labelledby', anchorId);\n\n                if (that.options.excludedPanel.indexOf(anchorId + '_content') < 0) {\n                    panel.addClass(that.options.tabPanelClass);\n                }\n            });\n\n            this.panels\n                .addClass('ui-tabs-panel ui-widget-content ui-corner-bottom')\n                .attr('role', 'tabpanel');\n        },\n\n        /**\n         * Move panels in destination element\n         * @protected\n         * @override\n         */\n        _movePanelsInDestination: function (panels) {\n            if (this.options.destination && !panels.parents(this.options.destination).length) {\n                this.element.trigger('beforePanelsMove', panels);\n\n                panels.find('script:not([type]), script[type=\"text/javascript\"]').remove();\n\n                panels.appendTo(this.options.destination)\n                    .each($.proxy(function (i, panel) {\n                        $(panel).trigger('move.tabs', this.anchors.eq(i));\n                    }, this));\n            }\n        },\n\n        /**\n         * Move panels in destination element on tabs switching\n         * @protected\n         * @override\n         * @param {Object} event - event object\n         * @param {Object} eventData\n         */\n        _toggle: function (event, eventData) {\n            this._movePanelsInDestination(eventData.newPanel);\n            this._superApply(arguments);\n        }\n    });\n\n    // Extension for mage.tabs - Ajax functionality for tabs\n    $.widget('mage.tabs', $.mage.tabs, {\n        options: {\n            /**\n             * Add form key to ajax call\n             * @param {Object} event - event object\n             * @param {Object} ui\n             */\n            beforeLoad: function (event, ui) {\n                ui.ajaxSettings.type = 'POST';\n                ui.ajaxSettings.hasContent = true;\n                ui.jqXHR.setRequestHeader('Content-Type', ui.ajaxSettings.contentType);\n                ui.ajaxSettings.data = jQuery.param(\n                    {\n                        isAjax: true,\n                        'form_key': typeof FORM_KEY !== 'undefined' ? FORM_KEY : null\n                    },\n                    ui.ajaxSettings.traditional\n                );\n            },\n\n            /**\n             * Replacing href attribute with loaded panel id\n             * @param {Object} event - event object\n             * @param {Object} ui\n             */\n            load: function (event, ui) {\n                var panel = $(ui.panel);\n\n                $(ui.tab).prop('href', '#' + panel.prop('id'));\n                panel.trigger('contentUpdated');\n            }\n        }\n    });\n\n    // Extension for mage.tabs - Attach event handlers to tabs\n    $.widget('mage.tabs', $.mage.tabs, {\n        options: {\n            tabIdArgument: 'tab',\n            tabsBlockPrefix: null\n        },\n\n        /**\n         * Attach event handlers to tabs, on creation\n         * @protected\n         * @override\n         */\n        _refresh: function () {\n            this._super();\n            $.each(this.tabs, $.proxy(function (i, tab) {\n                $(this._getPanelForTab(tab))\n                    .off('changed' + this.eventNamespace)\n                    .off('highlight.validate' + this.eventNamespace)\n                    .off('focusin' + this.eventNamespace)\n\n                    .on('changed' + this.eventNamespace, {\n                        index: i\n                    }, $.proxy(this._onContentChange, this))\n                    .on('highlight.validate' + this.eventNamespace, {\n                        index: i\n                    }, $.proxy(this._onInvalid, this))\n                    .on('focusin' + this.eventNamespace, {\n                        index: i\n                    }, $.proxy(this._onFocus, this));\n            }, this));\n\n            ($(this.options.destination).is('form') ?\n                $(this.options.destination) :\n                $(this.options.destination).closest('form'))\n                    .off('beforeSubmit' + this.eventNamespace)\n                    .on('beforeSubmit' + this.eventNamespace, $.proxy(this._onBeforeSubmit, this));\n        },\n\n        /**\n         * Mark tab as changed if some field inside tab panel is changed\n         * @protected\n         * @param {Object} e - event object\n         */\n        _onContentChange: function (e) {\n            var cssChanged = '_changed';\n\n            this.anchors.eq(e.data.index).addClass(cssChanged);\n            this._updateNavTitleMessages(e, cssChanged);\n        },\n\n        /**\n         * Clone messages (tooltips) from anchor to parent element\n         * @protected\n         * @param {Object} e - event object\n         * @param {String} messageType - changed or error\n         */\n        _updateNavTitleMessages: function (e, messageType) {\n            var curAnchor = this.anchors.eq(e.data.index),\n                curItem = curAnchor.parents('[data-role=\"container\"]').find('[data-role=\"title\"]'),\n                curItemMessages = curItem.find('[data-role=\"title-messages\"]'),\n                activeClass = '_active';\n\n            if (curItemMessages.is(':empty')) {\n                curAnchor\n                    .find('[data-role=\"item-messages\"]')\n                    .clone()\n                    .appendTo(curItemMessages);\n            }\n\n            curItemMessages.find('.' + messageType).addClass(activeClass);\n        },\n\n        /**\n         * Mark tab as error if some field inside tab panel is not passed validation\n         * @param {Object} e - event object\n         * @protected\n         */\n        _onInvalid: function (e) {\n            var cssError = '_error',\n                fakeEvent = e;\n\n            fakeEvent.currentTarget = $(this.anchors).eq(e.data.index);\n            this._eventHandler(fakeEvent);\n            this.anchors.eq(e.data.index).addClass(cssError).find('.' + cssError).show();\n            this._updateNavTitleMessages(e, cssError);\n        },\n\n        /**\n         * Show tab panel if focus event triggered of some field inside tab panel\n         * @param {Object} e - event object\n         * @protected\n         */\n        _onFocus: function (e) {\n            this.option('_active', e.data.index);\n        },\n\n        /**\n         * Add active tab id in data object when \"beforeSubmit\" event is triggered\n         * @param {Object} e - event object\n         * @param {Object} data - event data object\n         * @protected\n         */\n        _onBeforeSubmit: function (e, data) { //eslint-disable-line no-unused-vars\n            var activeAnchor = this.activeAnchor(),\n                activeTabId = activeAnchor.prop('id'),\n                options;\n\n            if (this.options.tabsBlockPrefix) {\n                if (activeAnchor.is('[id*=\"' + this.options.tabsBlockPrefix + '\"]')) {\n                    activeTabId = activeAnchor.prop('id').substr(this.options.tabsBlockPrefix.length);\n                }\n            }\n            $(this.anchors).removeClass('error');\n            options = {\n                action: {\n                    args: {}\n                }\n            };\n            options.action.args[this.options.tabIdArgument] = activeTabId;\n        }\n    });\n\n    // Extension for mage.tabs - Shadow tabs functionality\n    $.widget('mage.tabs', $.mage.tabs, {\n        /**\n         * Add shadow tabs functionality on creation\n         * @protected\n         * @override\n         */\n        _refresh: function () {\n            var anchors, shadowTabs, tabs;\n\n            this._super();\n            anchors = this.anchors;\n            shadowTabs = this.options.shadowTabs;\n            tabs = this.tabs;\n\n            if (shadowTabs) {\n                anchors.each($.proxy(function (i, anchor) {\n                    var anchorId = $(anchor).prop('id');\n\n                    if (shadowTabs[anchorId]) {\n                        $(anchor).parents('li').on('click', $.proxy(function () {\n                            $.each(shadowTabs[anchorId], $.proxy(function (key, id) {\n                                this.load($(tabs).index($('#' + id).parents('li')), {});\n                            }, this));\n                        }, this));\n                    }\n                }, this));\n            }\n        }\n    });\n\n    return $.mage.tabs;\n});\n","mage/backend/tree-suggest.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui',\n    'jquery/jstree/jquery.jstree',\n    'mage/backend/suggest'\n], function ($) {\n    'use strict';\n\n    /* jscs:disable requireCamelCaseOrUpperCaseIdentifiers */\n    var hover_node, dehover_node, select_node, init;\n\n    $.extend(true, $, {\n        // @TODO: Move method 'treeToList' in file with utility functions\n        mage: {\n            /**\n             * @param {Array} list\n             * @param {Object} nodes\n             * @param {*} level\n             * @param {*} path\n             * @return {*}\n             */\n            treeToList: function (list, nodes, level, path) {\n                $.each(nodes, function () {\n                    if (typeof this === 'object') {\n                        list.push({\n                            label: this.label,\n                            id: this.id,\n                            level: level,\n                            item: this,\n                            path: path + this.label\n                        });\n\n                        if (this.children) {\n                            $.mage.treeToList(list, this.children, level + 1, path + this.label + ' / ');\n                        }\n                    }\n                });\n\n                return list;\n            }\n        }\n    });\n\n    hover_node = $.jstree.core.prototype.hover_node;\n    dehover_node = $.jstree.core.prototype.dehover_node;\n    select_node = $.jstree.core.prototype.select_node;\n    init = $.jstree.core.prototype.init;\n\n    $.extend(true, $.jstree.core.prototype, {\n        /**\n         * @override\n         */\n        init: function () {\n            this.get_container()\n                .show()\n                .on('keydown', $.proxy(function (e) {\n                    var o;\n\n                    if (e.keyCode === $.ui.keyCode.ENTER) {\n                        o = this.data.ui.hovered || this.data.ui.last_selected || -1;\n                        this.select_node(o, true);\n                    }\n                }, this));\n            init.call(this);\n        },\n\n        /**\n         * @override\n         */\n        hover_node: function (obj) {\n            hover_node.apply(this, arguments);\n            obj = this._get_node(obj);\n\n            if (!obj.length) {\n                return false;\n            }\n            this.get_container().trigger('hover_node', [{\n                item: obj.find('a:first')\n            }]);\n        },\n\n        /**\n         * @override\n         */\n        dehover_node: function () {\n            dehover_node.call(this);\n            this.get_container().trigger('dehover_node');\n        },\n\n        /**\n         * @override\n         */\n        select_node: function (o) {\n            var node;\n\n            select_node.apply(this, arguments);\n            node = this._get_node(o);\n\n            (node ? $(node) : this.data.ui.last_selected)\n                .trigger('select_tree_node');\n        }\n    });\n\n    $.widget('mage.treeSuggest', $.mage.suggest, {\n        widgetEventPrefix: 'suggest',\n        options: {\n            template:\n                '<% if (data.items.length) { %>' +\n                    '<% if (data.allShown()) { %>' +\n                        '<% if (typeof data.nested === \"undefined\") { %>' +\n                            '<div style=\"display:none;\" data-mage-init=\"{&quot;jstree&quot;:{&quot;plugins&quot;:[&quot;themes&quot;,&quot;html_data&quot;,&quot;ui&quot;,&quot;hotkeys&quot;],&quot;themes&quot;:{&quot;theme&quot;:&quot;default&quot;,&quot;dots&quot;:false,&quot;icons&quot;:false}}}\">' + //eslint-disable-line max-len\n                        '<% } %>' +\n                        '<ul>' +\n                            '<% _.each(data.items, function(value) { %>' +\n                                '<li class=\"<% if (data.itemSelected(value)) { %>mage-suggest-selected<% } %>' +\n                '                   <% if (value.is_active == 0) { %> mage-suggest-not-active<% } %>\">' +\n                                    '<a href=\"#\" <%= data.optionData(value) %>><%- value.label %></a>' +\n                                    '<% if (value.children && value.children.length) { %>' +\n                                        '<%= data.renderTreeLevel(value.children) %>' +\n                                    '<% } %>' +\n                                '</li>' +\n                            '<% }); %>' +\n                        '</ul>' +\n                        '<% if (typeof data.nested === \"undefined\") { %>' +\n                            '</div>' +\n                        '<% } %>' +\n                    '<% } else { %>' +\n                        '<ul data-mage-init=\"{&quot;menu&quot;:[]}\">' +\n                            '<% _.each(data.items, function(value) { %>' +\n                                '<% if (!data.itemSelected(value)) {%>' +\n                                    '<li <%= data.optionData(value) %>>' +\n                                        '<a href=\"#\">' +\n                                            '<span class=\"category-label\"><%- value.label %></span>' +\n                                            '<span class=\"category-path\"><%- value.path %></span>' +\n                                        '</a>' +\n                                    '</li>' +\n                                '<% } %>' +\n                            '<% }); %>' +\n                        '</ul>' +\n                    '<% } %>' +\n                '<% } else { %>' +\n                    '<span class=\"mage-suggest-no-records\"><%- data.noRecordsText %></span>' +\n                '<% } %>',\n            controls: {\n                selector: ':ui-menu, :mage-menu, .jstree',\n                eventsMap: {\n                    focus: ['menufocus', 'hover_node'],\n                    blur: ['menublur', 'dehover_node'],\n                    select: ['menuselect', 'select_tree_node']\n                }\n            }\n        },\n\n        /**\n         * @override\n         */\n        _bind: function () {\n            this._super();\n            this._on({\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                keydown: function (event) {\n                    var keyCode = $.ui.keyCode;\n\n                    switch (event.keyCode) {\n                        case keyCode.LEFT:\n                        case keyCode.RIGHT:\n\n                            if (this.isDropdownShown()) {\n                                event.preventDefault();\n                                this._proxyEvents(event);\n                            }\n                            break;\n                    }\n                }\n            });\n        },\n\n        /**\n         * @override\n         */\n        close: function (e) {\n            var eType = e ? e.type : null;\n\n            if (eType === 'select_tree_node') {\n                this.element.focus();\n            } else {\n                this._superApply(arguments);\n            }\n        },\n\n        /**\n         * @override\n         */\n        _filterSelected: function (items, context) {\n            if (context._allShown) {\n                return items;\n            }\n\n            return this._superApply(arguments);\n        },\n\n        /**\n         * @override\n         */\n        _prepareDropdownContext: function () {\n            var context = this._superApply(arguments),\n                optionData = context.optionData,\n                templates = this.templates,\n                tmplName = this.templateName;\n\n            /**\n             * @param {Object} item\n             * @return {*|String}\n             */\n            context.optionData = function (item) {\n                item = $.extend({}, item);\n                delete item.children;\n\n                return optionData(item);\n            };\n\n            return $.extend(context, {\n                /**\n                 * @param {*} children\n                 * @return {*|jQuery}\n                 */\n                renderTreeLevel: function (children) {\n                    var _context = $.extend({}, this, {\n                        items: children,\n                        nested: true\n                    }),\n                    tmpl = templates[tmplName];\n\n                    tmpl = tmpl({\n                        data: _context\n                    });\n\n                    return $('<div>').append($(tmpl)).html();\n                }\n            });\n        },\n\n        /**\n         * @override\n         */\n        _processResponse: function (e, items, context) {\n            var control;\n\n            if (context && !context._allShown) {\n                items = this.filter($.mage.treeToList([], items, 0, ''), this._term);\n            }\n            control = this.dropdown.find(this._control.selector);\n\n            if (control.length && control.hasClass('jstree')) {\n                control.jstree('destroy');\n            }\n            this._superApply([e, items, context]);\n        }\n    });\n\n    return $.mage.treeSuggest;\n});\n","mage/backend/validation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global BASE_URL, alertAlreadyDisplayed */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'jquery/validate',\n    'mage/translate',\n    'mage/validation'\n], function ($, _, alert) {\n    'use strict';\n\n    $.extend(true, $.validator.prototype, {\n        /**\n         * Focus invalid fields\n         */\n        focusInvalid: function () {\n            if (this.settings.focusInvalid) {\n                try {\n                    $(this.errorList.length && this.errorList[0].element || [])\n                        .trigger('focus')\n                        .trigger('focusin');\n                } catch (e) {\n                    // ignore IE throwing errors when focusing hidden elements\n                }\n            }\n        },\n\n        /**\n         * Elements.\n         */\n        elements: function () {\n            var validator = this,\n                rulesCache = {};\n\n            // select all valid inputs inside the form (no submit or reset buttons)\n            return $(this.currentForm)\n                .find('input, select, textarea')\n                .not(this.settings.forceIgnore)\n                .not(':submit, :reset, :image, [disabled]')\n                .not(this.settings.ignore)\n                .filter(function () {\n                    if (!this.name && validator.settings.debug && window.console) {\n                        console.error('%o has no name assigned', this);\n                    }\n\n                    // select only the first element for each name, and only those with rules specified\n                    if (this.name in rulesCache || !validator.objectLength($(this).rules())) {\n                        return false;\n                    }\n\n                    rulesCache[this.name] = true;\n\n                    return true;\n                });\n        }\n    });\n\n    $.extend($.fn, {\n        /**\n         * ValidationDelegate overridden for those cases where the form is located in another form,\n         *     to avoid not correct working of validate plug-in\n         * @override\n         * @param {String} delegate - selector, if event target matched against this selector,\n         *     then event will be delegated\n         * @param {String} type - event type\n         * @param {Function} handler - event handler\n         * @return {Element}\n         */\n        validateDelegate: function (delegate, type, handler) {\n            return this.on(type, $.proxy(function (event) {\n                var target = $(event.target),\n                    form = target[0].form;\n\n                if (form && $(form).is(this) && $.data(form, 'validator') && target.is(delegate)) {\n                    return handler.apply(target, arguments);\n                }\n            }, this));\n        }\n    });\n\n    $.widget('mage.validation', $.mage.validation, {\n        options: {\n            messagesId: 'messages',\n            forceIgnore: '',\n            ignore: ':disabled, .ignore-validate, .no-display.template, ' +\n                ':disabled input, .ignore-validate input, .no-display.template input, ' +\n                ':disabled select, .ignore-validate select, .no-display.template select, ' +\n                ':disabled textarea, .ignore-validate textarea, .no-display.template textarea',\n            errorElement: 'label',\n            errorUrl: typeof BASE_URL !== 'undefined' ? BASE_URL : null,\n\n            /**\n             * @param {HTMLElement} element\n             */\n            highlight: function (element) {\n                if ($.validator.defaults.highlight && typeof $.validator.defaults.highlight === 'function') {\n                    $.validator.defaults.highlight.apply(this, arguments);\n                }\n                $(element).trigger('highlight.validate');\n            },\n\n            /**\n             * @param {HTMLElement} element\n             */\n            unhighlight: function (element) {\n                if ($.validator.defaults.unhighlight && typeof $.validator.defaults.unhighlight === 'function') {\n                    $.validator.defaults.unhighlight.apply(this, arguments);\n                }\n                $(element).trigger('unhighlight.validate');\n            }\n        },\n\n        /**\n         * Validation creation\n         * @protected\n         */\n        _create: function () {\n            if (!this.options.submitHandler && typeof this.options.submitHandler !== 'function') {\n                if (!this.options.frontendOnly && this.options.validationUrl) {\n                    this.options.submitHandler = $.proxy(this._ajaxValidate, this);\n                } else {\n                    this.options.submitHandler = $.proxy(this._submit, this);\n                }\n            }\n            this.element.on('resetElement', function (e) {\n                $(e.target).rules('remove');\n            });\n            this._super('_create');\n        },\n\n        /**\n         * ajax validation\n         * @protected\n         */\n        _ajaxValidate: function () {\n            $.ajax({\n                url: this.options.validationUrl,\n                type: 'POST',\n                dataType: 'json',\n                data: this.element.serialize(),\n                context: $('body'),\n                success: $.proxy(this._onSuccess, this),\n                error: $.proxy(this._onError, this),\n                showLoader: true,\n                dontHide: false\n            });\n        },\n\n        /**\n         * Process ajax success.\n         *\n         * @protected\n         * @param {Object} response\n         */\n        _onSuccess: function (response) {\n            if (!response.error) {\n                this._submit();\n            } else {\n                this._showErrors(response);\n                $(this.element[0]).trigger('afterValidate.error');\n                $('body').trigger('processStop');\n            }\n        },\n\n        /**\n         * Submitting a form.\n         * @private\n         */\n        _submit: function () {\n            $(this.element[0]).trigger('afterValidate.beforeSubmit');\n            this.element[0].submit();\n        },\n\n        /**\n         * Displays errors after backend validation.\n         *\n         * @param {Object} data - Data that came from backend.\n         */\n        _showErrors: function (data) {\n            $('body').notification('clear')\n                .notification('add', {\n                    error: data.error,\n                    message: data.message,\n\n                    /**\n                     * @param {*} message\n                     */\n                    insertMethod: function (message) {\n                        $('.messages:first').html(message);\n                    }\n                });\n        },\n\n        /**\n         * Tries to retrieve element either by id or by inputs' name property.\n         * @param {String} code - String to search by.\n         * @returns {jQuery} jQuery element.\n         */\n        _getByCode: function (code) {\n            var parent = this.element[0],\n                element;\n\n            element = parent.querySelector('#' + code) || parent.querySelector('input[name=' + code + ']');\n\n            return $(element);\n        },\n\n        /**\n         * Process ajax error\n         * @protected\n         */\n        _onError: function () {\n            $(this.element[0]).trigger('afterValidate.error');\n            $('body').trigger('processStop');\n\n            if (this.options.errorUrl) {\n                location.href = this.options.errorUrl;\n            }\n        }\n    });\n\n    _.each({\n        'validate-greater-zero-based-on-option': [\n            function (v, el) {\n                var optionType = $(el)\n                    .closest('.form-list')\n                    .prev('.fieldset-alt')\n                    .find('select.select-product-option-type'),\n                    optionTypeVal = optionType.val();\n\n                v = Number(v) || 0;\n\n                if (optionType && (optionTypeVal == 'checkbox' || optionTypeVal == 'multi') && v <= 0) { //eslint-disable-line\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please enter a number greater 0 in this field.')\n        ],\n        'validate-rating': [\n            function () {\n                var ratings = $('#detailed_rating').find('.field-rating'),\n                    noError = true;\n\n                ratings.each(function (index, rating) {\n                    noError = noError && $(rating).find('input:checked').length > 0;\n                });\n\n                return noError;\n            },\n            $.mage.__('Please select one of each ratings above.')\n        ],\n        'validate-downloadable-file': [\n            function (v, element) {\n                var elmParent = $(element).parent(),\n                    linkType = elmParent.find('input[value=\"file\"]'),\n                    newFileContainer;\n\n                if (linkType.is(':checked') && (v === '' || v === '[]')) {\n                    newFileContainer = elmParent.find('.new-file');\n\n                    if (!alertAlreadyDisplayed && (newFileContainer.empty() || newFileContainer.is(':visible'))) {\n                        window.alertAlreadyDisplayed = true;\n                        alert({\n                            content: $.mage.__('There are files that were selected but not uploaded yet. ' +\n                            'Please upload or remove them first')\n                        });\n                    }\n\n                    return false;\n                }\n\n                return true;\n            },\n            'Please upload a file.'\n        ],\n        'validate-downloadable-url': [\n            function (v, element) {\n                var linkType = $(element).parent().find('input[value=\"url\"]');\n\n                if (linkType.is(':checked') && v === '') {\n                    return false;\n                }\n\n                return true;\n            },\n            $.mage.__('Please specify Url.')\n        ]\n    }, function (rule, i) {\n        rule.unshift(i);\n        $.validator.addMethod.apply($.validator, rule);\n    });\n\n    return $.mage.validation;\n});\n","mage/msie/file-reader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * Init \"readAsBinaryString\" function for FileReader class.\n     * It need for IE11\n     * @param {Blob} fileData\n     */\n    var readAsBinaryStringIEFunc = function (fileData) {\n        var binary = '',\n            self = this,\n            reader = new FileReader();\n\n        /**\n         * Read file as binary string\n         */\n        reader.onload = function () {\n            var bytes, length, index;\n\n            /* eslint-disable no-undef */\n            bytes = new Uint8Array(reader.result);\n            /* eslint-enable */\n            length = bytes.length;\n\n            for (index = 0; index < length; index++) {\n                binary += String.fromCharCode(bytes[index]);\n            }\n            //self.result  - readonly so assign binary\n            self.content = binary;\n            $(self).trigger('onload');\n        };\n        reader.readAsArrayBuffer(fileData);\n    };\n\n    if (typeof FileReader.prototype.readAsBinaryString === 'undefined') {\n        FileReader.prototype.readAsBinaryString = readAsBinaryStringIEFunc;\n    }\n});\n","mage/requirejs/baseUrlResolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Sample configuration:\n *\n require.config({\n        \"config\": {\n            \"baseUrlInterceptor\": {\n                \"Magento_Ui/js/lib/knockout/bindings/collapsible.js\": \"../../../../frontend/Magento/luma/en_US/\"\n            }\n        }\n    });\n */\n\n/* global jsSuffixRegExp */\n/* eslint-disable max-depth */\ndefine('baseUrlInterceptor', [\n    'module'\n], function (module) {\n    'use strict';\n\n    /**\n     * RequireJS Context object\n     */\n    var ctx = require.s.contexts._,\n\n        /**\n         * Original function\n         *\n         * @type {Function}\n         */\n        origNameToUrl = ctx.nameToUrl,\n\n        /**\n         * Original function\n         *\n         * @type {Function}\n         */\n        newContextConstr = require.s.newContext;\n\n    /**\n     * Remove dots from URL\n     *\n     * @param {Array} ary\n     */\n    function trimDots(ary) {\n        var i, part, length = ary.length;\n\n        for (i = 0; i < length; i++) {\n            part = ary[i];\n\n            if (part === '.') {\n                ary.splice(i, 1);\n                i -= 1;\n            } else if (part === '..') {\n                if (i === 1 && (ary[2] === '..' || ary[0] === '..')) {\n                    //End of the line. Keep at least one non-dot\n                    //path segment at the front so it can be mapped\n                    //correctly to disk. Otherwise, there is likely\n                    //no path mapping for a path starting with '..'.\n                    //This can still fail, but catches the most reasonable\n                    //uses of ..\n                    break;\n                } else if (i > 0) {\n                    ary.splice(i - 1, 2);\n                    i -= 2;\n                }\n            }\n        }\n    }\n\n    /**\n     * Normalize URL string (remove '/../')\n     *\n     * @param {String} name\n     * @param {String} baseName\n     * @param {Object} applyMap\n     * @param {Object} localContext\n     * @returns {*}\n     */\n    function normalize(name, baseName, applyMap, localContext) {\n        var lastIndex,\n            baseParts = baseName && baseName.split('/'),\n            normalizedBaseParts = baseParts;\n\n        //Adjust any relative paths.\n        if (name && name.charAt(0) === '.') {\n            //If have a base name, try to normalize against it,\n            //otherwise, assume it is a top-level require that will\n            //be relative to baseUrl in the end.\n            if (baseName) {\n                //Convert baseName to array, and lop off the last part,\n                //so that . matches that 'directory' and not name of the baseName's\n                //module. For instance, baseName of 'one/two/three', maps to\n                //'one/two/three.js', but we want the directory, 'one/two' for\n                //this normalization.\n                normalizedBaseParts = baseParts.slice(0, baseParts.length - 1);\n                name = name.split('/');\n                lastIndex = name.length - 1;\n\n                // If wanting node ID compatibility, strip .js from end\n                // of IDs. Have to do this here, and not in nameToUrl\n                // because node allows either .js or non .js to map\n                // to same file.\n                if (localContext.nodeIdCompat && jsSuffixRegExp.test(name[lastIndex])) {\n                    name[lastIndex] = name[lastIndex].replace(jsSuffixRegExp, '');\n                }\n\n                name = normalizedBaseParts.concat(name);\n                trimDots(name);\n                name = name.join('/');\n            } else if (name.indexOf('./') === 0) {\n                // No baseName, so this is ID is resolved relative\n                // to baseUrl, pull off the leading dot.\n                name = name.substring(2);\n            }\n        }\n\n        return name;\n    }\n\n    /**\n     * Get full url.\n     *\n     * @param {Object} context\n     * @param {String} url\n     * @return {String}\n     */\n    function getUrl(context, url) {\n        var baseUrl = context.config.baseUrl,\n            newConfig = context.config,\n            modulePath = url.replace(baseUrl, ''),\n            newBaseUrl,\n            rewrite = module.config()[modulePath];\n\n        if (!rewrite) {\n            return url;\n        }\n\n        newBaseUrl = normalize(rewrite, baseUrl, undefined, newConfig);\n\n        return newBaseUrl + modulePath;\n    }\n\n    /**\n     * Replace original function.\n     *\n     * @returns {*}\n     */\n    ctx.nameToUrl = function () {\n        return getUrl(ctx, origNameToUrl.apply(ctx, arguments));\n    };\n\n    /**\n     * Replace original function.\n     *\n     * @return {*}\n     */\n    require.s.newContext = function () {\n        var newCtx = newContextConstr.apply(require.s, arguments),\n            newOrigNameToUrl = newCtx.nameToUrl;\n\n        /**\n         * New implementation of native function.\n         *\n         * @returns {String}\n         */\n        newCtx.nameToUrl = function () {\n            return getUrl(newCtx, newOrigNameToUrl.apply(newCtx, arguments));\n        };\n\n        return newCtx;\n    };\n});\n\nrequire(['baseUrlInterceptor'], function () {\n    'use strict';\n\n});\n","mage/requirejs/resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'domReady!'\n], function (_) {\n    'use strict';\n\n    var context = require.s.contexts._,\n        execCb = context.execCb,\n        registry = context.registry,\n        callbacks = [],\n        retries = 10,\n        updateDelay = 1,\n        ready,\n        update;\n\n    /**\n     * Checks if provided callback already exists in the callbacks list.\n     *\n     * @param {Object} callback - Callback object to be checked.\n     * @returns {Boolean}\n     */\n    function isSubscribed(callback) {\n        return !!_.findWhere(callbacks, callback);\n    }\n\n    /**\n     * Checks if provided module is rejected during load.\n     *\n     * @param {Object} module - Module to be checked.\n     * @return {Boolean}\n     */\n    function isRejected(module) {\n        return registry[module.id] && (registry[module.id].inited || registry[module.id].error);\n    }\n\n    /**\n     * Checks if provided module had path fallback triggered.\n     *\n     * @param {Object} module - Module to be checked.\n     * @return {Boolean}\n     */\n    function isPathFallback(module) {\n        return registry[module.id] && registry[module.id].events.error;\n    }\n\n    /**\n     * Checks if provided module has unresolved dependencies.\n     *\n     * @param {Object} module - Module to be checked.\n     * @returns {Boolean}\n     */\n    function isPending(module) {\n        if (!module.depCount) {\n            return false;\n        }\n\n        return module.depCount >\n            _.filter(module.depMaps, isRejected).length + _.filter(module.depMaps, isPathFallback).length;\n    }\n\n    /**\n     * Checks if requirejs's registry object contains pending modules.\n     *\n     * @returns {Boolean}\n     */\n    function hasPending() {\n        return _.some(registry, isPending);\n    }\n\n    /**\n     * Checks if 'resolver' module is in ready\n     * state and that there are no pending modules.\n     *\n     * @returns {Boolean}\n     */\n    function isReady() {\n        return ready && !hasPending();\n    }\n\n    /**\n     * Invokes provided callback handler.\n     *\n     * @param {Object} callback\n     */\n    function invoke(callback) {\n        callback.handler.call(callback.ctx);\n    }\n\n    /**\n     * Sets 'resolver' module to a ready state\n     * and invokes pending callbacks.\n     */\n    function resolve() {\n        ready = true;\n\n        callbacks.splice(0).forEach(invoke);\n    }\n\n    /**\n     * Drops 'ready' flag and runs the update process.\n     */\n    function tick() {\n        ready = false;\n\n        update(retries);\n    }\n\n    /**\n     * Adds callback which will be invoked\n     * when all of the pending modules are initiated.\n     *\n     * @param {Function} handler - 'Ready' event handler function.\n     * @param {Object} [ctx] - Optional context with which handler\n     *      will be invoked.\n     */\n    function subscribe(handler, ctx) {\n        var callback = {\n            handler: handler,\n            ctx: ctx\n        };\n\n        if (!isSubscribed(callback)) {\n            callbacks.push(callback);\n\n            if (isReady()) {\n                _.defer(tick);\n            }\n        }\n    }\n\n    /**\n     * Checks for all modules to be initiated\n     * and invokes pending callbacks if it's so.\n     *\n     * @param {Number} [retry] - Number of retries\n     *      that will be used to repeat the 'update' function\n     *      invokation in case if there are no pending requests.\n     */\n    update = _.debounce(function (retry) {\n        if (!hasPending()) {\n            retry ? update(--retry) : resolve();\n        }\n    }, updateDelay);\n\n    /**\n     * Overrides requirejs's original 'execCb' method\n     * in order to track pending modules.\n     *\n     * @returns {*} Result of original method call.\n     */\n    context.execCb = function () {\n        var exported = execCb.apply(context, arguments);\n\n        tick();\n\n        return exported;\n    };\n\n    return subscribe;\n});\n","mage/requirejs/text.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n/* inspired by http://github.com/requirejs/text */\n/*global XDomainRequest */\n\ndefine(['module'], function (module) {\n    'use strict';\n\n    var xmlRegExp = /^\\s*<\\?xml(\\s)+version=[\\'\\\"](\\d)*.(\\d)*[\\'\\\"](\\s)*\\?>/im,\n        bodyRegExp = /<body[^>]*>\\s*([\\s\\S]+)\\s*<\\/body>/im,\n        stripReg = /!strip$/i,\n        defaultConfig = module.config && module.config() || {};\n\n    /**\n     * Strips <?xml ...?> declarations so that external SVG and XML documents can be\n     * added to a document without worry.\n     * Also, if the string is an HTML document, only the part inside the body tag is returned.\n     *\n     * @param {String} external\n     * @returns {String}\n     */\n    function stripContent(external) {\n        var matches;\n\n        if (!external) {\n            return '';\n        }\n\n        matches = external.match(bodyRegExp);\n        external = matches ?\n            matches[1] :\n            external.replace(xmlRegExp, '');\n\n        return external;\n    }\n\n    /**\n     * Checks that url match current location\n     *\n     * @param {String} url\n     * @returns {Boolean}\n     */\n    function sameDomain(url) {\n        var uProtocol, uHostName, uPort,\n            xdRegExp = /^([\\w:]+)?\\/\\/([^\\/\\\\]+)/i,\n            location = window.location,\n            match = xdRegExp.exec(url);\n\n        if (!match) {\n            return true;\n        }\n        uProtocol = match[1];\n        uHostName = match[2];\n\n        uHostName = uHostName.split(':');\n        uPort = uHostName[1] || '';\n        uHostName = uHostName[0];\n\n        return (!uProtocol || uProtocol === location.protocol) &&\n            (!uHostName || uHostName.toLowerCase() === location.hostname.toLowerCase()) &&\n            (!uPort && !uHostName || uPort === location.port);\n    }\n\n    /**\n     * @returns {XMLHttpRequest|XDomainRequest|null}\n     */\n    function createRequest(url) {\n        var xhr = new XMLHttpRequest();\n\n        if (!sameDomain(url) && typeof XDomainRequest !== 'undefined') {\n            xhr = new XDomainRequest();\n        }\n\n        return xhr;\n    }\n\n    /**\n     * XHR requester. Returns value to callback.\n     *\n     * @param {String} url\n     * @param {Function} callback\n     * @param {Function} fail\n     * @param {Object} headers\n     */\n    function getContent(url, callback, fail, headers) {\n        var xhr = createRequest(url),\n            header;\n\n        xhr.open('GET', url);\n\n        /*eslint-disable max-depth */\n        if ('setRequestHeader' in xhr && headers) {\n            for (header in headers) {\n                if (headers.hasOwnProperty(header)) {\n                    xhr.setRequestHeader(header.toLowerCase(), headers[header]);\n                }\n            }\n        }\n\n        /**\n         * @inheritdoc\n         */\n        xhr.onreadystatechange = function () {\n            var status, err;\n\n            //Do not explicitly handle errors, those should be\n            //visible via console output in the browser.\n            if (xhr.readyState === 4) {\n                status = xhr.status || 0;\n\n                if (status > 399 && status < 600) {\n                    //An http 4xx or 5xx error. Signal an error.\n                    err = new Error(url + ' HTTP status: ' + status);\n                    err.xhr = xhr;\n\n                    if (fail) {\n                        fail(err);\n                    }\n                } else {\n                    callback(xhr.responseText);\n\n                    if (defaultConfig.onXhrComplete) {\n                        defaultConfig.onXhrComplete(xhr, url);\n                    }\n                }\n            }\n        };\n\n        /*eslint-enable max-depth */\n\n        if (defaultConfig.onXhr) {\n            defaultConfig.onXhr(xhr, url);\n        }\n\n        xhr.send();\n    }\n\n    /**\n     * Main method used by RequireJs.\n     *\n     * @param {String} name - has format: some.module.filext!strip\n     * @param {Function} req\n     * @param {Function|undefined} onLoad\n     */\n    function loadContent(name, req, onLoad) {\n\n        var toStrip = stripReg.test(name),\n            url = req.toUrl(name.replace(stripReg, '')),\n            headers = defaultConfig.headers;\n\n        getContent(url, function (content) {\n                content = toStrip ? stripContent(content) : content;\n                onLoad(content);\n            }, onLoad.error, headers);\n    }\n\n    return {\n        load: loadContent,\n        get: getContent\n    };\n});\n","mage/utils/arrays.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    './strings'\n], function (_, utils) {\n    'use strict';\n\n    /**\n     * Defines index of an item in a specified container.\n     *\n     * @param {*} item - Item whose index should be defined.\n     * @param {Array} container - Container upon which to perform search.\n     * @returns {Number}\n     */\n    function getIndex(item, container) {\n        var index = container.indexOf(item);\n\n        if (~index) {\n            return index;\n        }\n\n        return _.findIndex(container, function (value) {\n            return value && value.name === item;\n        });\n    }\n\n    return {\n        /**\n         * Facade method to remove/add value from/to array\n         * without creating a new instance.\n         *\n         * @param {Array} arr - Array to be modified.\n         * @param {*} value - Value to add/remove.\n         * @param {Boolean} add - Flag that specfies operation.\n         * @returns {Utils} Chainable.\n         */\n        toggle: function (arr, value, add) {\n            return add ?\n                this.add(arr, value) :\n                this.remove(arr, value);\n        },\n\n        /**\n         * Removes the incoming value from array in case\n         * without creating a new instance of it.\n         *\n         * @param {Array} arr - Array to be modified.\n         * @param {*} value - Value to be removed.\n         * @returns {Utils} Chainable.\n         */\n        remove: function (arr, value) {\n            var index = arr.indexOf(value);\n\n            if (~index) {\n                arr.splice(index, 1);\n            }\n\n            return this;\n        },\n\n        /**\n         * Adds the incoming value to array if\n         * it's not alredy present in there.\n         *\n         * @param {Array} arr - Array to be modifed.\n         * @param {...*} arguments - Values to be added.\n         * @returns {Utils} Chainable.\n         */\n        add: function (arr) {\n            var values = _.toArray(arguments).slice(1);\n\n            values.forEach(function (value) {\n                if (!~arr.indexOf(value)) {\n                    arr.push(value);\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * Inserts specified item into container at a specified position.\n         *\n         * @param {*} item - Item to be inserted into container.\n         * @param {Array} container - Container of items.\n         * @param {*} [position=-1] - Position at which item should be inserted.\n         *      Position can represent:\n         *          - specific index in container\n         *          - item which might already be present in container\n         *          - structure with one of these properties: after, before\n         * @returns {Boolean|*}\n         *      - true if element has changed its' position\n         *      - false if nothing has changed\n         *      - inserted value if it wasn't present in container\n         */\n        insert: function (item, container, position) {\n            var currentIndex = getIndex(item, container),\n                newIndex,\n                target;\n\n            if (typeof position === 'undefined') {\n                position = -1;\n            } else if (typeof position === 'string') {\n                position = isNaN(+position) ? position : +position;\n            }\n\n            newIndex = position;\n\n            if (~currentIndex) {\n                target = container.splice(currentIndex, 1)[0];\n\n                if (typeof item === 'string') {\n                    item = target;\n                }\n            }\n\n            if (typeof position !== 'number') {\n                target = position.after || position.before || position;\n\n                newIndex = getIndex(target, container);\n\n                if (~newIndex && (position.after || newIndex >= currentIndex)) {\n                    newIndex++;\n                }\n            }\n\n            if (newIndex < 0) {\n                newIndex += container.length + 1;\n            }\n\n            container[newIndex] ?\n                container.splice(newIndex, 0, item) :\n                container[newIndex] = item;\n\n            return !~currentIndex ? item : currentIndex !== newIndex;\n        },\n\n        /**\n         * @param {Array} elems\n         * @param {Number} offset\n         * @return {Number|*}\n         */\n        formatOffset: function (elems, offset) {\n            if (utils.isEmpty(offset)) {\n                offset = -1;\n            }\n\n            offset = +offset;\n\n            if (offset < 0) {\n                offset += elems.length + 1;\n            }\n\n            return offset;\n        }\n    };\n});\n","mage/utils/compare.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'mage/utils/objects'\n], function (_, utils) {\n    'use strict';\n\n    var result = [];\n\n    /**\n     * Checks if all of the provided arrays contains equal values.\n     *\n     * @param {(Boolean|Array)} [keepOrder=false]\n     * @param {Array} target\n     * @returns {Boolean}\n     */\n    function equalArrays(keepOrder, target) {\n        var args = _.toArray(arguments),\n            arrays;\n\n        if (!Array.isArray(keepOrder)) {\n            arrays      = args.slice(2);\n        } else {\n            target      = keepOrder;\n            keepOrder   = false;\n            arrays      = args.slice(1);\n        }\n\n        if (!arrays.length) {\n            return true;\n        }\n\n        return arrays.every(function (array) {\n            if (array === target) {\n                return true;\n            } else if (array.length !== target.length) {\n                return false;\n            } else if (!keepOrder) {\n                return !_.difference(target, array).length;\n            }\n\n            return array.every(function (value, index) {\n                return target[index] === value;\n            });\n        });\n    }\n\n    /**\n     * Checks if two values are different.\n     *\n     * @param {*} a - First value.\n     * @param {*} b - Second value.\n     * @returns {Boolean}\n     */\n    function isDifferent(a, b) {\n        var oldIsPrimitive = utils.isPrimitive(a);\n\n        if (Array.isArray(a) && Array.isArray(b)) {\n            return !equalArrays(true, a, b);\n        }\n\n        return oldIsPrimitive ? a !== b : true;\n    }\n\n    /**\n     * @param {String} prefix\n     * @param {String} part\n     */\n    function getPath(prefix, part) {\n        return prefix ? prefix + '.' + part : part;\n    }\n\n    /**\n     * Checks if object has own specified property.\n     *\n     * @param {*} obj - Value to be checked.\n     * @param {String} key - Key of the property.\n     * @returns {Boolean}\n     */\n    function hasOwn(obj, key) {\n        return Object.prototype.hasOwnProperty.call(obj, key);\n    }\n\n    /**\n     * @param {Array} changes\n     */\n    function getContainers(changes) {\n        var containers  = {},\n            indexed     = _.indexBy(changes, 'path');\n\n        _.each(indexed, function (change, name) {\n            var path;\n\n            name.split('.').forEach(function (part) {\n                path = getPath(path, part);\n\n                if (path in indexed) {\n                    return;\n                }\n\n                (containers[path] = containers[path] || []).push(change);\n            });\n        });\n\n        return containers;\n    }\n\n    /**\n     * @param {String} path\n     * @param {String} name\n     * @param {String} type\n     * @param {String} newValue\n     * @param {String} oldValue\n     */\n    function addChange(path, name, type, newValue, oldValue) {\n        var data;\n\n        data = {\n            path: path,\n            name: name,\n            type: type\n        };\n\n        if (type !== 'remove') {\n            data.value = newValue;\n            data.oldValue = oldValue;\n        } else {\n            data.oldValue = newValue;\n        }\n\n        result.push(data);\n    }\n\n    /**\n     * @param {String} ns\n     * @param {String} name\n     * @param {String} type\n     * @param {String} iterator\n     * @param {String} placeholder\n     */\n    function setAll(ns, name, type, iterator, placeholder) {\n        var key;\n\n        if (arguments.length > 4) {\n            type === 'add' ?\n                addChange(ns, name, 'update', iterator, placeholder) :\n                addChange(ns, name, 'update', placeholder, iterator);\n        } else {\n            addChange(ns, name, type, iterator);\n        }\n\n        if (!utils.isObject(iterator)) {\n            return;\n        }\n\n        for (key in iterator) {\n            if (hasOwn(iterator, key)) {\n                setAll(getPath(ns, key), key, type, iterator[key]);\n            }\n        }\n    }\n\n    /*eslint-disable max-depth*/\n    /**\n     * @param {Object} old\n     * @param {Object} current\n     * @param {String} ns\n     * @param {String} name\n     */\n    function compare(old, current, ns, name) {\n        var key,\n            oldIsObj = utils.isObject(old),\n            newIsObj = utils.isObject(current);\n\n        if (oldIsObj && newIsObj) {\n            for (key in old) {\n                if (hasOwn(old, key) && !hasOwn(current, key)) {\n                    setAll(getPath(ns, key), key, 'remove', old[key]);\n                }\n            }\n\n            for (key in current) {\n                if (hasOwn(current, key)) {\n                    hasOwn(old, key) ?\n                        compare(old[key], current[key], getPath(ns, key), key) :\n                        setAll(getPath(ns, key), key, 'add', current[key]);\n                }\n            }\n        } else if (oldIsObj) {\n            setAll(ns, name, 'remove', old, current);\n        } else if (newIsObj) {\n            setAll(ns, name, 'add', current, old);\n        } else if (isDifferent(old, current)) {\n            addChange(ns, name, 'update', current, old);\n        }\n    }\n\n    /*eslint-enable max-depth*/\n\n    return {\n\n        /**\n         *\n         * @returns {Object}\n         */\n        compare: function () {\n            var changes;\n\n            compare.apply(null, arguments);\n\n            changes = result.splice(0);\n\n            return {\n                containers: getContainers(changes),\n                changes: changes,\n                equal: !changes.length\n            };\n        },\n\n        equalArrays: equalArrays\n    };\n});\n","mage/utils/main.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function (require) {\n    'use strict';\n\n    var utils = {},\n        _ = require('underscore'),\n        root = typeof self == 'object' && self.self === self && self ||\n            typeof global == 'object' && global.global === global && global ||\n            Function('return this')() || {};\n\n    root._ = _;\n\n    return _.extend(\n        utils,\n        require('./arrays'),\n        require('./compare'),\n        require('./misc'),\n        require('./objects'),\n        require('./strings'),\n        require('./template')\n    );\n});\n","mage/utils/misc.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'mage/utils/objects'\n], function (_, $, utils) {\n    'use strict';\n\n    var defaultAttributes,\n        ajaxSettings,\n        map;\n\n    defaultAttributes = {\n        method: 'post',\n        enctype: 'multipart/form-data'\n    };\n\n    ajaxSettings = {\n        default: {\n            method: 'POST',\n            cache: false,\n            processData: false,\n            contentType: false\n        },\n        simple: {\n            method: 'POST',\n            dataType: 'json'\n        }\n    };\n\n    map = {\n        'D': 'DDD',\n        'dd': 'DD',\n        'd': 'D',\n        'EEEE': 'dddd',\n        'EEE': 'ddd',\n        'e': 'd',\n        'yyyy': 'YYYY',\n        'yy': 'YY',\n        'y': 'YYYY',\n        'a': 'A'\n    };\n\n    return {\n\n        /**\n         * Generates a unique identifier.\n         *\n         * @param {Number} [size=7] - Length of a resulting identifier.\n         * @returns {String}\n         */\n        uniqueid: function (size) {\n            var code = Math.random() * 25 + 65 | 0,\n                idstr = String.fromCharCode(code);\n\n            size = size || 7;\n\n            while (idstr.length < size) {\n                code = Math.floor(Math.random() * 42 + 48);\n\n                if (code < 58 || code > 64) {\n                    idstr += String.fromCharCode(code);\n                }\n            }\n\n            return idstr;\n        },\n\n        /**\n         * Limits function call.\n         *\n         * @param {Object} owner\n         * @param {String} target\n         * @param {Number} limit\n         */\n        limit: function (owner, target, limit) {\n            var fn = owner[target];\n\n            owner[target] = _.debounce(fn.bind(owner), limit);\n        },\n\n        /**\n         * Converts mage date format to a moment.js format.\n         *\n         * @param {String} mageFormat\n         * @returns {String}\n         */\n        normalizeDate: function (mageFormat) {\n            var result = mageFormat;\n\n            _.each(map, function (moment, mage) {\n                result = result.replace(\n                    new RegExp(mage + '(?=([^\\u0027]*\\u0027[^\\u0027]*\\u0027)*[^\\u0027]*$)'),\n                    moment\n                );\n            });\n            result = result.replace(/'(.*?)'/g, '[$1]');\n            return result;\n        },\n\n        /**\n         * Puts provided value in range of min and max parameters.\n         *\n         * @param {Number} value - Value to be located.\n         * @param {Number} min - Min value.\n         * @param {Number} max - Max value.\n         * @returns {Number}\n         */\n        inRange: function (value, min, max) {\n            return Math.min(Math.max(min, value), max);\n        },\n\n        /**\n         * Serializes and sends data via POST request.\n         *\n         * @param {Object} options - Options object that consists of\n         *      a 'url' and 'data' properties.\n         * @param {Object} attrs - Attributes that will be added to virtual form.\n         */\n        submit: function (options, attrs) {\n            var form        = document.createElement('form'),\n                data        = utils.serialize(options.data),\n                attributes  = _.extend({}, defaultAttributes, attrs || {});\n\n            if (!attributes.action) {\n                attributes.action = options.url;\n            }\n\n            data['form_key'] = window.FORM_KEY;\n\n            _.each(attributes, function (value, name) {\n                form.setAttribute(name, value);\n            });\n\n            data = _.map(\n                data,\n                function (value, name) {\n                    return '<input type=\"hidden\" ' +\n                        'name=\"' + _.escape(name) + '\" ' +\n                        'value=\"' + _.escape(value) + '\"' +\n                        ' />';\n                }\n            ).join('');\n\n            form.insertAdjacentHTML('afterbegin', data);\n            document.body.appendChild(form);\n\n            form.submit();\n        },\n\n        /**\n         * Serializes and sends data via AJAX POST request.\n         *\n         * @param {Object} options - Options object that consists of\n         *      a 'url' and 'data' properties.\n         * @param {Object} config\n         */\n        ajaxSubmit: function (options, config) {\n            var t = new Date().getTime(),\n                settings;\n\n            options.data['form_key'] = window.FORM_KEY;\n            options.data = this.prepareFormData(options.data, config.ajaxSaveType);\n            settings = _.extend({}, ajaxSettings[config.ajaxSaveType], options || {});\n\n            if (!config.ignoreProcessEvents) {\n                $('body').trigger('processStart');\n            }\n\n            return $.ajax(settings)\n                .done(function (data) {\n                    if (config.response) {\n                        data.t = t;\n                        config.response.data(data);\n                        config.response.status(undefined);\n                        config.response.status(!data.error);\n                    }\n                })\n                .fail(function () {\n                    if (config.response) {\n                        config.response.status(undefined);\n                        config.response.status(false);\n                        config.response.data({\n                            error: true,\n                            messages: 'Something went wrong.',\n                            t: t\n                        });\n                    }\n                })\n                .always(function () {\n                    if (!config.ignoreProcessEvents) {\n                        $('body').trigger('processStop');\n                    }\n                });\n        },\n\n        /**\n         * Creates FormData object and append this data.\n         *\n         * @param {Object} data\n         * @param {String} type\n         * @returns {FormData}\n         */\n        prepareFormData: function (data, type) {\n            var formData;\n\n            if (type === 'default') {\n                formData = new FormData();\n                _.each(utils.serialize(data), function (val, name) {\n                    formData.append(name, val);\n                });\n            } else if (type === 'simple') {\n                formData = utils.serialize(data);\n            }\n\n            return formData;\n        },\n\n        /**\n         * Filters data object. Finds properties with suffix\n         * and sets their values to properties with the same name without suffix.\n         *\n         * @param {Object} data - The data object that should be filtered\n         * @param {String} suffix - The string by which data object should be filtered\n         * @param {String} separator - The string that is separator between property and suffix\n         *\n         * @returns {Object} Filtered data object\n         */\n        filterFormData: function (data, suffix, separator) {\n            data = data || {};\n            suffix = suffix || 'prepared-for-send';\n            separator = separator || '-';\n\n            _.each(data, function (value, key) {\n                if (_.isObject(value) && !Array.isArray(value)) {\n                    this.filterFormData(value, suffix, separator);\n                } else if (_.isString(key) && ~key.indexOf(suffix)) {\n                    data[key.split(separator)[0]] = value;\n                    delete data[key];\n                }\n            }, this);\n\n            return data;\n        },\n\n        /**\n         * Replaces special characters with their corresponding HTML entities.\n         *\n         * @param {String} string - Text to escape.\n         * @returns {String} Escaped text.\n         */\n        escape: function (string) {\n            return string ? $('<p></p>').text(string).html().replace(/\"/g, '&quot;') : string;\n        },\n\n        /**\n         * Replaces symbol codes with their unescaped counterparts.\n         *\n         * @param {String} data\n         *\n         * @returns {String}\n         */\n        unescape: function (data) {\n            var unescaped = _.unescape(data),\n                mapCharacters = {\n                    '&#039;': '\\''\n                };\n\n            _.each(mapCharacters, function (value, key) {\n                unescaped = unescaped.replace(key, value);\n            });\n\n            return unescaped;\n        },\n\n        /**\n         * Converts PHP IntlFormatter format to moment format.\n         *\n         * @param {String} format - PHP format\n         * @returns {String} - moment compatible formatting\n         */\n        convertToMomentFormat: function (format) {\n            var newFormat;\n\n            newFormat = format.replace(/yyyy|yy|y/, 'YYYY'); // replace the year\n            newFormat = newFormat.replace(/dd|d/g, 'DD'); // replace the date\n\n            return newFormat;\n        },\n\n        /**\n         * Get Url Parameters.\n         *\n         * @param {String} url - Url string\n         * @returns {Object}\n         */\n        getUrlParameters: function (url) {\n            var params = {},\n                queries = url.split('?'),\n                temp,\n                i,\n                l;\n\n            if (!queries[1]) {\n                return params;\n            }\n\n            queries = queries[1].split('&');\n\n            for (i = 0, l = queries.length; i < l; i++) {\n                temp = queries[i].split('=');\n\n                if (temp[1]) {\n                    params[temp[0]] = decodeURIComponent(temp[1].replace(/\\+/g, '%20'));\n                } else {\n                    params[temp[0]] = '';\n                }\n            }\n\n            return params;\n        }\n    };\n});\n","mage/utils/objects.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'jquery',\n    'underscore',\n    'mage/utils/strings'\n], function (ko, $, _, stringUtils) {\n    'use strict';\n\n    var primitives = [\n        'undefined',\n        'boolean',\n        'number',\n        'string'\n    ];\n\n    /**\n     * Sets nested property of a specified object.\n     * @private\n     *\n     * @param {Object} parent - Object to look inside for the properties.\n     * @param {Array} path - Splitted path the property.\n     * @param {*} value - Value of the last property in 'path' array.\n     * returns {*} New value for the property.\n     */\n    function setNested(parent, path, value) {\n        var last = path.pop(),\n            len = path.length,\n            pi = 0,\n            part = path[pi];\n\n        for (; pi < len; part = path[++pi]) {\n            if (!_.isObject(parent[part])) {\n                parent[part] = {};\n            }\n\n            parent = parent[part];\n        }\n\n        if (typeof parent[last] === 'function') {\n            parent[last](value);\n        } else {\n            parent[last] = value;\n        }\n\n        return value;\n    }\n\n    /**\n     * Retrieves value of a nested property.\n     * @private\n     *\n     * @param {Object} parent - Object to look inside for the properties.\n     * @param {Array} path - Splitted path the property.\n     * @returns {*} Value of the property.\n     */\n    function getNested(parent, path) {\n        var exists = true,\n            len = path.length,\n            pi = 0;\n\n        for (; pi < len && exists; pi++) {\n            parent = parent[path[pi]];\n\n            if (typeof parent === 'undefined') {\n                exists = false;\n            }\n        }\n\n        if (exists) {\n            if (ko.isObservable(parent)) {\n                parent = parent();\n            }\n\n            return parent;\n        }\n    }\n\n    /**\n     * Removes property from a specified object.\n     * @private\n     *\n     * @param {Object} parent - Object from which to remove property.\n     * @param {Array} path - Splitted path to the property.\n     */\n    function removeNested(parent, path) {\n        var field = path.pop();\n\n        parent = getNested(parent, path);\n\n        if (_.isObject(parent)) {\n            delete parent[field];\n        }\n    }\n\n    return {\n\n        /**\n         * Retrieves or defines objects' property by a composite path.\n         *\n         * @param {Object} data - Container for the properties specified in path.\n         * @param {String} path - Objects' properties divided by dots.\n         * @param {*} [value] - New value for the last property.\n         * @returns {*} Returns value of the last property in chain.\n         *\n         * @example\n         *      utils.nested({}, 'one.two', 3);\n         *      => { one: {two: 3} }\n         */\n        nested: function (data, path, value) {\n            var action = arguments.length > 2 ? setNested : getNested;\n\n            path = path ? path.split('.') : [];\n\n            return action(data, path, value);\n        },\n\n        /**\n         * Removes nested property from an object.\n         *\n         * @param {Object} data - Data source.\n         * @param {String} path - Path to the property e.g. 'one.two.three'\n         */\n        nestedRemove: function (data, path) {\n            path = path.split('.');\n\n            removeNested(data, path);\n        },\n\n        /**\n         * Flattens objects' nested properties.\n         *\n         * @param {Object} data - Object to flatten.\n         * @param {String} [separator='.'] - Objects' keys separator.\n         * @returns {Object} Flattened object.\n         *\n         * @example Example with a default separator.\n         *      utils.flatten({one: { two: { three: 'value'} }});\n         *      => { 'one.two.three': 'value' };\n         *\n         * @example Example with a custom separator.\n         *      utils.flatten({one: { two: { three: 'value'} }}, '=>');\n         *      => {'one=>two=>three': 'value'};\n         */\n        flatten: function (data, separator, parent, result) {\n            separator = separator || '.';\n            result = result || {};\n\n            if (!data) {\n                return result;\n            }\n\n            // UnderscoreJS each breaks when an object has a length property so we use Object.keys\n            _.each(Object.keys(data), function (name) {\n                var node = data[name];\n\n                if ({}.toString.call(node) === '[object Function]') {\n                    return;\n                }\n\n                if (parent) {\n                    name = parent + separator + name;\n                }\n\n                typeof node === 'object' ?\n                    this.flatten(node, separator, name, result) :\n                    result[name] = node;\n\n            }, this);\n\n            return result;\n        },\n\n        /**\n         * Opposite operation of the 'flatten' method.\n         *\n         * @param {Object} data - Previously flattened object.\n         * @param {String} [separator='.'] - Keys separator.\n         * @returns {Object} Object with nested properties.\n         *\n         * @example Example using custom separator.\n         *      utils.unflatten({'one=>two': 'value'}, '=>');\n         *      => {\n         *          one: { two: 'value' }\n         *      };\n         */\n        unflatten: function (data, separator) {\n            var result = {};\n\n            separator = separator || '.';\n\n            _.each(data, function (value, nodes) {\n                nodes = nodes.split(separator);\n\n                setNested(result, nodes, value);\n            });\n\n            return result;\n        },\n\n        /**\n         * Same operation as 'flatten' method,\n         * but returns objects' keys wrapped in '[]'.\n         *\n         * @param {Object} data - Object that should be serialized.\n         * @returns {Object} Serialized data.\n         *\n         * @example\n         *      utils.serialize({one: { two: { three: 'value'} }});\n         *      => { 'one[two][three]': 'value' }\n         */\n        serialize: function (data) {\n            var result = {};\n\n            data = this.flatten(data);\n\n            _.each(data, function (value, keys) {\n                keys = stringUtils.serializeName(keys);\n                value = _.isUndefined(value) ? '' : value;\n\n                result[keys] = value;\n            }, this);\n\n            return result;\n        },\n\n        /**\n         * Performs deep extend of specified objects.\n         *\n         * @returns {Object|Array} Extended object.\n         */\n        extend: function () {\n            var args = _.toArray(arguments);\n\n            args.unshift(true);\n\n            return $.extend.apply($, args);\n        },\n\n        /**\n         * Performs a deep clone of a specified object.\n         *\n         * @param {(Object|Array)} data - Data that should be copied.\n         * @returns {Object|Array} Cloned object.\n         */\n        copy: function (data) {\n            var result = data,\n                isArray = Array.isArray(data),\n                placeholder;\n\n            if (this.isObject(data) || isArray) {\n                placeholder = isArray ? [] : {};\n                result = this.extend(placeholder, data);\n            }\n\n            return result;\n        },\n\n        /**\n         * Performs a deep clone of a specified object.\n         * Doesn't save links to original object.\n         *\n         * @param {*} original - Object to clone\n         * @returns {*}\n         */\n        hardCopy: function (original) {\n            if (original === null || typeof original !== 'object') {\n                return original;\n            }\n\n            return JSON.parse(JSON.stringify(original));\n        },\n\n        /**\n         * Removes specified nested properties from the target object.\n         *\n         * @param {Object} target - Object whose properties should be removed.\n         * @param {(...String|Array|Object)} list - List that specifies properties to be removed.\n         * @returns {Object} Modified object.\n         *\n         * @example Basic usage\n         *      var obj = {a: {b: 2}, c: 'a'};\n         *\n         *      omit(obj, 'a.b');\n         *      => {'a.b': 2};\n         *      obj => {a: {}, c: 'a'};\n         *\n         * @example Various syntaxes that would return same result\n         *      omit(obj, ['a.b', 'c']);\n         *      omit(obj, 'a.b', 'c');\n         *      omit(obj, {'a.b': true, 'c': true});\n         */\n        omit: function (target, list) {\n            var removed = {},\n                ignored = list;\n\n            if (this.isObject(list)) {\n                ignored = [];\n\n                _.each(list, function (value, key) {\n                    if (value) {\n                        ignored.push(key);\n                    }\n                });\n            } else if (_.isString(list)) {\n                ignored = _.toArray(arguments).slice(1);\n            }\n\n            _.each(ignored, function (path) {\n                var value = this.nested(target, path);\n\n                if (!_.isUndefined(value)) {\n                    removed[path] = value;\n\n                    this.nestedRemove(target, path);\n                }\n            }, this);\n\n            return removed;\n        },\n\n        /**\n         * Checks if provided value is a plain object.\n         *\n         * @param {*} value - Value to be checked.\n         * @returns {Boolean}\n         */\n        isObject: function (value) {\n            var objProto = Object.prototype;\n\n            return typeof value == 'object' ?\n            objProto.toString.call(value) === '[object Object]' :\n                false;\n        },\n\n        /**\n         *\n         * @param {*} value\n         * @returns {Boolean}\n         */\n        isPrimitive: function (value) {\n            return value === null || ~primitives.indexOf(typeof value);\n        },\n\n        /**\n         * Iterates over obj props/array elems recursively, applying action to each one\n         *\n         * @param {Object|Array} data - Data to be iterated.\n         * @param {Function} action - Callback to be called with each item as an argument.\n         * @param {Number} [maxDepth=7] - Max recursion depth.\n         */\n        forEachRecursive: function (data, action, maxDepth) {\n            maxDepth = typeof maxDepth === 'number' && !isNaN(maxDepth) ? maxDepth - 1 : 7;\n\n            if (!_.isFunction(action) || _.isFunction(data) || maxDepth < 0) {\n                return;\n            }\n\n            if (!_.isObject(data)) {\n                action(data);\n\n                return;\n            }\n\n            _.each(data, function (value) {\n                this.forEachRecursive(value, action, maxDepth);\n            }, this);\n\n            action(data);\n        },\n\n        /**\n         * Maps obj props/array elems recursively\n         *\n         * @param {Object|Array} data - Data to be iterated.\n         * @param {Function} action - Callback to transform each item.\n         * @param {Number} [maxDepth=7] - Max recursion depth.\n         *\n         * @returns {Object|Array}\n         */\n        mapRecursive: function (data, action, maxDepth) {\n            var newData;\n\n            maxDepth = typeof maxDepth === 'number' && !isNaN(maxDepth) ? maxDepth - 1 : 7;\n\n            if (!_.isFunction(action) || _.isFunction(data) || maxDepth < 0) {\n                return data;\n            }\n\n            if (!_.isObject(data)) {\n                return action(data);\n            }\n\n            if (_.isArray(data)) {\n                newData = _.map(data, function (item) {\n                    return this.mapRecursive(item, action, maxDepth);\n                }, this);\n\n                return action(newData);\n            }\n\n            newData = _.mapObject(data, function (val, key) {\n                if (data.hasOwnProperty(key)) {\n                    return this.mapRecursive(val, action, maxDepth);\n                }\n\n                return val;\n            }, this);\n\n            return action(newData);\n        },\n\n        /**\n         * Removes empty(in common sence) obj props/array elems\n         *\n         * @param {*} data - Data to be cleaned.\n         * @returns {*}\n         */\n        removeEmptyValues: function (data) {\n            if (!_.isObject(data)) {\n                return data;\n            }\n\n            if (_.isArray(data)) {\n                return data.filter(function (item) {\n                    return !this.isEmptyObj(item);\n                }, this);\n            }\n\n            return _.omit(data, this.isEmptyObj.bind(this));\n        },\n\n        /**\n         * Checks that argument of any type is empty in common sence:\n         * empty string, string with spaces only, object without own props, empty array, null or undefined\n         *\n         * @param {*} val - Value to be checked.\n         * @returns {Boolean}\n         */\n        isEmptyObj: function (val) {\n\n            return _.isObject(val) && _.isEmpty(val) ||\n            this.isEmpty(val) ||\n            val && val.trim && this.isEmpty(val.trim());\n        }\n    };\n});\n\n","mage/utils/strings.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    var jsonRe = /^(?:\\{[\\w\\W]*\\}|\\[[\\w\\W]*\\])$/;\n\n    return {\n\n        /**\n         * Attempts to convert string to one of the primitive values,\n         * or to parse it as a valid json object.\n         *\n         * @param {String} str - String to be processed.\n         * @returns {*}\n         */\n        castString: function (str) {\n            try {\n                str = str === 'true' ? true :\n                    str === 'false' ? false :\n                        str === 'null' ? null :\n                            +str + '' === str ? +str :\n                                jsonRe.test(str) ? JSON.parse(str) :\n                                    str;\n            } catch (e) {\n            }\n\n            return str;\n        },\n\n        /**\n         * Splits string by separator if it's possible,\n         * otherwise returns the incoming value.\n         *\n         * @param {(String|Array|*)} str - String to split.\n         * @param {String} [separator=' '] - Seperator based on which to split the string.\n         * @returns {Array|*} Splitted string or the incoming value.\n         */\n        stringToArray: function (str, separator) {\n            separator = separator || ' ';\n\n            return typeof str === 'string' ?\n                str.split(separator) :\n                str;\n        },\n\n        /**\n         * Converts the incoming string which consists\n         * of a specified delimiters into a format commonly used in form elements.\n         *\n         * @param {String} name - The incoming string.\n         * @param {String} [separator='.']\n         * @returns {String} Serialized string.\n         *\n         * @example\n         *      utils.serializeName('one.two.three');\n         *      => 'one[two][three]';\n         */\n        serializeName: function (name, separator) {\n            var result;\n\n            separator = separator || '.';\n            name = name.split(separator);\n\n            result = name.shift();\n\n            name.forEach(function (part) {\n                result += '[' + part + ']';\n            });\n\n            return result;\n        },\n\n        /**\n         * Checks wether the incoming value is not empty,\n         * e.g. not 'null' or 'undefined'\n         *\n         * @param {*} value - Value to check.\n         * @returns {Boolean}\n         */\n        isEmpty: function (value) {\n            return value === '' || _.isUndefined(value) || _.isNull(value);\n        },\n\n        /**\n         * Adds 'prefix' to the 'part' value if it was provided.\n         *\n         * @param {String} prefix\n         * @param {String} part\n         * @returns {String}\n         */\n        fullPath: function (prefix, part) {\n            return prefix ? prefix + '.' + part : part;\n        },\n\n        /**\n         * Splits incoming string and returns its' part specified by offset.\n         *\n         * @param {String} parts\n         * @param {Number} [offset]\n         * @param {String} [delimiter=.]\n         * @returns {String}\n         */\n        getPart: function (parts, offset, delimiter) {\n            delimiter = delimiter || '.';\n            parts = parts.split(delimiter);\n            offset = this.formatOffset(parts, offset);\n\n            parts.splice(offset, 1);\n\n            return parts.join(delimiter) || '';\n        },\n\n        /**\n         * Converts nameThroughCamelCase to name-through-minus\n         *\n         * @param {String} string\n         * @returns {String}\n         */\n        camelCaseToMinus: function camelCaseToMinus(string) {\n            return ('' + string)\n                .split('')\n                .map(function (symbol, index) {\n                    return index ?\n                        symbol.toUpperCase() === symbol ?\n                        '-' + symbol.toLowerCase() :\n                            symbol :\n                        symbol.toLowerCase();\n                })\n                .join('');\n        },\n\n        /**\n         * Converts name-through-minus to nameThroughCamelCase\n         *\n         * @param {String} string\n         * @returns {String}\n         */\n        minusToCamelCase: function minusToCamelCase(string) {\n            return ('' + string)\n                .split('-')\n                .map(function (part, index) {\n                    return index ? part.charAt(0).toUpperCase() + part.slice(1) : part;\n                })\n                .join('');\n        }\n    };\n});\n","mage/utils/template.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-shadow */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/utils/objects',\n    'mage/utils/strings'\n], function ($, _, utils, stringUtils) {\n    'use strict';\n\n    var tmplSettings = _.templateSettings,\n        interpolate = /\\$\\{([\\s\\S]+?)\\}/g,\n        opener = '${',\n        template,\n        hasStringTmpls;\n\n    /**\n     * Identifies whether ES6 templates are supported.\n     */\n    hasStringTmpls = (function () {\n        var testString = 'var foo = \"bar\"; return `${ foo }` === foo';\n\n        try {\n            return Function(testString)();\n        } catch (e) {\n            return false;\n        }\n    })();\n\n    /**\n     * Objects can specify how to use templating for their properties - getting that configuration.\n     *\n     * To disable rendering for all properties of your object add __disableTmpl: true.\n     * To disable for specific property add __disableTmpl: {propertyName: true}.\n     * To limit recursion for a specific property add __disableTmpl: {propertyName: numberOfCycles}.\n     *\n     * @param {String} tmpl\n     * @param {Object | undefined} target\n     * @returns {Boolean|Object}\n     */\n    function isTmplIgnored(tmpl, target) {\n        var parsedTmpl;\n\n        try {\n            parsedTmpl = JSON.parse(tmpl);\n\n            if (typeof parsedTmpl === 'object') {\n                return tmpl.includes('__disableTmpl');\n            }\n        } catch (e) {\n        }\n\n        if (typeof target !== 'undefined') {\n            if (typeof target === 'object' && target.hasOwnProperty('__disableTmpl')) {\n                return target.__disableTmpl;\n            }\n        }\n\n        return false;\n\n    }\n\n    if (hasStringTmpls) {\n\n        /*eslint-disable no-unused-vars, no-eval*/\n        /**\n         * Evaluates template string using ES6 templates.\n         *\n         * @param {String} tmpl - Template string.\n         * @param {Object} $ - Data object used in a template.\n         * @returns {String} Compiled template.\n         */\n        template = function (tmpl, $) {\n            return eval('`' + tmpl + '`');\n        };\n\n        /*eslint-enable no-unused-vars, no-eval*/\n    } else {\n\n        /**\n         * Fallback function used when ES6 templates are not supported.\n         * Uses underscore templates renderer.\n         *\n         * @param {String} tmpl - Template string.\n         * @param {Object} data - Data object used in a template.\n         * @returns {String} Compiled template.\n         */\n        template = function (tmpl, data) {\n            var cached = tmplSettings.interpolate;\n\n            tmplSettings.interpolate = interpolate;\n\n            tmpl = _.template(tmpl, {\n                variable: '$'\n            })(data);\n\n            tmplSettings.interpolate = cached;\n\n            return tmpl;\n        };\n    }\n\n    /**\n     * Checks if provided value contains template syntax.\n     *\n     * @param {*} value - Value to be checked.\n     * @returns {Boolean}\n     */\n    function isTemplate(value) {\n        return typeof value === 'string' &&\n            value.indexOf(opener) !== -1 &&\n            // the below pattern almost always indicates an accident which should not cause template evaluation\n            // refuse to evaluate\n            value.indexOf('${{') === -1;\n    }\n\n    /**\n     * Iteratively processes provided string\n     * until no templates syntax will be found.\n     *\n     * @param {String} tmpl - Template string.\n     * @param {Object} data - Data object used in a template.\n     * @param {Boolean} [castString=false] - Flag that indicates whether template\n     *      should be casted after evaluation to a value of another type or\n     *      that it should be leaved as a string.\n     * @param {Number|undefined} maxCycles - Maximum number of rendering cycles, can be 0.\n     * @returns {*} Compiled template.\n     */\n    function render(tmpl, data, castString, maxCycles) {\n        var last = tmpl,\n            cycles = 0;\n\n        while (~tmpl.indexOf(opener) && (typeof maxCycles === 'undefined' || cycles < maxCycles)) {\n            if (!isTmplIgnored(tmpl)) {\n                tmpl = template(tmpl, data);\n            }\n\n            if (tmpl === last) {\n                break;\n            }\n\n            last = tmpl;\n            cycles++;\n        }\n\n        return castString ?\n            stringUtils.castString(tmpl) :\n            tmpl;\n    }\n\n    return {\n\n        /**\n         * Applies provided data to the template.\n         *\n         * @param {Object|String} tmpl\n         * @param {Object} [data] - Data object to match with template.\n         * @param {Boolean} [castString=false] - Flag that indicates whether template\n         *      should be casted after evaluation to a value of another type or\n         *      that it should be leaved as a string.\n         * @returns {*}\n         *\n         * @example Template defined as a string.\n         *      var source = { foo: 'Random Stuff', bar: 'Some' };\n         *\n         *      utils.template('${ $.bar } ${ $.foo }', source);\n         *      => 'Some Random Stuff';\n         *\n         * @example Template defined as an object.\n         *      var tmpl = {\n         *              key: {'${ $.$data.bar }': '${ $.$data.foo }'},\n         *              foo: 'bar',\n         *              x1: 2, x2: 5,\n         *              delta: '${ $.x2 - $.x1 }',\n         *              baz: 'Upper ${ $.foo.toUpperCase() }'\n         *      };\n         *\n         *      utils.template(tmpl, source);\n         *      => {\n         *          key: {'Some': 'Random Stuff'},\n         *          foo: 'bar',\n         *          x1: 2, x2: 5,\n         *          delta: 3,\n         *          baz: 'Upper BAR'\n         *      };\n         */\n        template: function (tmpl, data, castString, dontClone) {\n            if (typeof tmpl === 'string') {\n                return render(tmpl, data, castString);\n            }\n\n            if (!dontClone) {\n                tmpl = utils.copy(tmpl);\n            }\n\n            tmpl.$data = data || {};\n\n            /**\n             * Template iterator function.\n             */\n            _.each(tmpl, function iterate(value, key, list) {\n                var disabled,\n                    maxCycles;\n\n                if (key === '$data') {\n                    return;\n                }\n\n                if (isTemplate(key)) {\n                    delete list[key];\n\n                    key = render(key, tmpl);\n                    list[key] = value;\n                }\n\n                if (isTemplate(value)) {\n                    //Getting template disabling settings, can be true for all disabled and separate settings\n                    //for each property.\n                    disabled = isTmplIgnored(value, list);\n\n                    if (typeof disabled === 'object' && disabled.hasOwnProperty(key) && disabled[key] !== false) {\n                        //Checking if specific settings for a property provided.\n                        maxCycles = disabled[key];\n                    }\n\n                    if (disabled === true || maxCycles === true) {\n                        //Rendering for all properties is disabled.\n                        maxCycles = 0;\n                    }\n\n                    list[key] = render(value, tmpl, castString, maxCycles);\n                } else if ($.isPlainObject(value) || Array.isArray(value)) {\n                    _.each(value, iterate);\n                }\n            });\n\n            delete tmpl.$data;\n\n            return tmpl;\n        }\n    };\n});\n","mage/utils/wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * Utility methods used to wrap and extend functions.\n *\n * @example Usage of a 'wrap' method with arguments delegation.\n *      var multiply = function (a, b) {\n *          return a * b;\n *      };\n *\n *      multiply = module.wrap(multiply, function (orig) {\n *          return 'Result is: ' + orig();\n *      });\n *\n *      multiply(2, 2);\n *      => 'Result is: 4'\n *\n * @example Usage of 'wrapSuper' method.\n *      var multiply = function (a, b) {\n *         return a * b;\n *      };\n *\n *      var obj = {\n *          multiply: module.wrapSuper(multiply, function () {\n *              return 'Result is: ' + this._super();\n *          });\n *      };\n *\n *      obj.multiply(2, 2);\n *      => 'Result is: 4'\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    /**\n     * Checks if string has a '_super' substring.\n     */\n    var superReg = /\\b_super\\b/;\n\n    return {\n\n        /**\n         * Wraps target function with a specified wrapper, which will receive\n         * reference to the original function as a first argument.\n         *\n         * @param {Function} target - Function to be wrapped.\n         * @param {Function} wrapper - Wrapper function.\n         * @returns {Function} Wrapper function.\n         */\n        wrap: function (target, wrapper) {\n            if (!_.isFunction(target) || !_.isFunction(wrapper)) {\n                return wrapper;\n            }\n\n            return function () {\n                var args    = _.toArray(arguments),\n                    ctx     = this,\n                    _super;\n\n                /**\n                 * Function that will be passed to the wrapper.\n                 * If no arguments will be passed to it, then the original\n                 * function will be called with an arguments of a wrapper function.\n                 */\n                _super = function () {\n                    var superArgs = arguments.length ? arguments : args.slice(1);\n\n                    return target.apply(ctx, superArgs);\n                };\n\n                args.unshift(_super);\n\n                return wrapper.apply(ctx, args);\n            };\n        },\n\n        /**\n         * Wraps the incoming function to implement support of the '_super' method.\n         *\n         * @param {Function} target - Function to be wrapped.\n         * @param {Function} wrapper - Wrapper function.\n         * @returns {Function} Wrapped function.\n         */\n        wrapSuper: function (target, wrapper) {\n            if (!this.hasSuper(wrapper) || !_.isFunction(target)) {\n                return wrapper;\n            }\n\n            return function () {\n                var _super  = this._super,\n                    args    = arguments,\n                    result;\n\n                /**\n                 * Temporary define '_super' method which\n                 * contains call to the original function.\n                 */\n                this._super = function () {\n                    var superArgs = arguments.length ? arguments : args;\n\n                    return target.apply(this, superArgs);\n                };\n\n                result = wrapper.apply(this, args);\n\n                this._super = _super;\n\n                return result;\n            };\n        },\n\n        /**\n         * Checks wether the incoming method contains calls of the '_super' method.\n         *\n         * @param {Function} fn - Function to be checked.\n         * @returns {Boolean}\n         */\n        hasSuper: function (fn) {\n            return _.isFunction(fn) && superReg.test(fn);\n        },\n\n        /**\n         * Extends target object with provided extenders.\n         * If property in target and extender objects is a function,\n         * then it will be wrapped using 'wrap' method.\n         *\n         * @param {Object} target - Object to be extended.\n         * @param {...Object} extenders - Multiple extenders objects.\n         * @returns {Object} Modified target object.\n         */\n        extend: function (target) {\n            var extenders = _.toArray(arguments).slice(1),\n                iterator = this._extend.bind(this, target);\n\n            extenders.forEach(iterator);\n\n            return target;\n        },\n\n        /**\n         * Same as the 'extend' method, but operates only on one extender object.\n         *\n         * @private\n         * @param {Object} target\n         * @param {Object} extender\n         */\n        _extend: function (target, extender) {\n            _.each(extender, function (value, key) {\n                target[key] = this.wrap(target[key], extender[key]);\n            }, this);\n        }\n    };\n});\n","mage/validation/url.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n    'use strict';\n\n    return {\n\n        /**\n         * Redirects to the url if it is considered safe\n         *\n         * @param {String} path - url to be redirected to\n         */\n        redirect: function (path) {\n            path = this.sanitize(path);\n\n            if (this.validate(path)) {\n                window.location.href = path;\n            }\n        },\n\n        /**\n         * Validates url\n         *\n         * @param {Object} path - url to be validated\n         * @returns {Boolean}\n         */\n        validate: function (path) {\n            var hostname = window.location.hostname;\n\n            if (path.indexOf(hostname) === -1 ||\n                path.indexOf('javascript:') !== -1 ||\n                path.indexOf('vbscript:') !== -1) {\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * Sanitize url, replacing disallowed chars\n         *\n         * @param {String} path - url to be normalized\n         * @returns {String}\n         */\n        sanitize: function (path) {\n            return path.replace('[^-A-Za-z0-9+&@#/%?=~_|!:,.;\\(\\)]', '');\n        }\n    };\n});\n","Magento_AdminAdobeIms/postcss.config.js":"module.exports = {\n    plugins: [\n        require('postcss-import'),\n        require('postcss-varfallback'),\n        require('postcss-dropunusedvars'),\n        require('cssnano')\n    ]\n};\n","Magento_AdminAdobeIms/js/admin_adobe_ims_load_icons.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_AdminAdobeIms/js/loadicons'\n], function ($, _, loadicons) {\n    'use strict';\n\n    var icons = {},\n\n    loadIcons = {\n        /**\n         * loadicons initialization\n         */\n        init: function () {\n            loadicons(icons.spectrumCssIcons);\n            loadicons(icons.spectrumIcons);\n        },\n\n        /**\n         * @param {Object} iconUrls\n         * @constructor\n         */\n        'Magento_AdminAdobeIms/js/admin_adobe_ims_load_icons': function (iconUrls) {\n            icons = iconUrls;\n            loadIcons.init();\n        }\n    };\n\n    return loadIcons;\n});\n","Magento_AdminAdobeIms/js/adobe-ims-reauth.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'jquery',\n    'Magento_AdobeIms/js/action/authorization'\n], function (Component, $, login) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            loginConfig: {\n                url: 'https://ims-na1-stg.adobelogin.com/ims/authorize',\n                callbackParsingParams: {\n                    regexpPattern: /auth\\[code=(success|error);message=(.+)\\]/,\n                    codeIndex: 1,\n                    messageIndex: 2,\n                    nameIndex: 3,\n                    successCode: 'success',\n                    errorCode: 'error'\n                },\n                popupWindowParams: {\n                    width: 500,\n                    height: 600,\n                    top: 100,\n                    left: 300\n                },\n                popupWindowTimeout: 60000\n            }\n        },\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.login();\n        },\n\n        /**\n         * Open popup for Adobe reauth\n         *\n         * @return {window.Promise}\n         */\n        login: function () {\n            var deferred = $.Deferred(),\n                loginConfig = this.loginConfig;\n\n            $('input.ims_verification').on('click', function () {\n                login(loginConfig)\n                    .then(function (response) {\n                        if (response.isAuthorized === true) {\n                            $('input.ims_verified').val(true);\n                        }\n                        deferred.resolve(response);\n                    })\n                    .fail(function (error) {\n                        deferred.reject(error);\n                    });\n            });\n\n            return deferred.promise();\n        }\n    });\n});\n","Magento_AdminAdobeIms/js/loadicons.js":"/*\nCopyright 2018 Adobe. All rights reserved.\nThis file is licensed to you under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License. You may obtain a copy\nof the License at http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software distributed under\nthe License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS\nOF ANY KIND, either express or implied. See the License for the specific language\ngoverning permissions and limitations under the License.\n*/\n\n// UMD pattern via umdjs\n(function (root, factory) {\n  if (typeof define === 'function' && define.amd) {\n    // AMD\n    define([], factory);\n  }\n  else if (typeof module === 'object' && module.exports) {\n    // CommonJS-like\n    module.exports = factory();\n  }\n  else {\n    // Browser\n    root.loadIcons = factory();\n  }\n}(typeof self !== 'undefined' ? self : this, function() {\n  function handleError(string) {\n    string = 'loadIcons: '+string;\n    var error = new Error(string);\n\n    console.error(error.toString());\n\n    if (typeof callback === 'function') {\n      callback(error);\n    }\n  }\n\n  function injectSVG(svgURL, callback) {\n    var error;\n    // 200 for web servers, 0 for CEP panels\n    if (this.status !== 200 && this.status !== 0) {\n      handleError('Failed to fetch icons, server returned ' + this.status);\n      return;\n    }\n\n    // Parse the SVG\n    var parser = new DOMParser();\n    try {\n      var doc = parser.parseFromString(this.responseText, 'image/svg+xml');\n      var svg = doc.firstChild;\n    }\n    catch (err) {\n      handleError('Error parsing SVG: ' + err);\n      return;\n    }\n\n    // Make sure a real SVG was returned\n    if (svg && svg.tagName === 'svg') {\n      // Hide the element\n      svg.style.display = 'none';\n\n      svg.setAttribute('data-url', svgURL);\n\n      // Insert it into the head\n      document.head.insertBefore(svg, null);\n\n      // Pass the SVG to the callback\n      if (typeof callback === 'function') {\n        callback(null, svg);\n      }\n    }\n    else {\n      handleError('Parsed SVG document contained something other than an SVG');\n    }\n  }\n\n  function loadIcons(svgURL, callback) {\n    // Request the SVG sprite\n    var req = new XMLHttpRequest();\n    req.open('GET', svgURL, true);\n    req.addEventListener('load', injectSVG.bind(req, svgURL, callback));\n    req.addEventListener('error', function(event) {\n      handleError('Request failed');\n    });\n    req.send();\n  }\n\n  return loadIcons;\n}));\n","Magento_AdminAnalytics/js/modal/component.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'jquery',\n    'Magento_Ui/js/modal/modal-component',\n    'uiRegistry',\n    'analyticsPopupConfig'\n],\n    function (_, $, Modal, registry, analyticsPopupConfig) {\n        'use strict';\n\n        return Modal.extend(\n            {\n                defaults: {\n                    imports: {\n                        enableLogAction: '${ $.provider }:data.enableLogAction',\n                        disableLogAction: '${ $.provider }:data.disableLogAction'\n                    },\n                    options: {},\n                    notificationWindow: null\n                },\n\n                /**\n                 * Initializes modal on opened function\n                 */\n                initModal: function () {\n                    this.options.opened = this.onOpened.bind(this);\n                    this._super();\n                },\n\n                /**\n                 * Configure ESC and TAB so user can't leave modal\n                 * without selecting an option\n                 *\n                 * @returns {Object} Chainable.\n                 */\n                initModalEvents: function () {\n                    this._super();\n                    //Don't allow ESC key to close modal\n                    this.options.keyEventHandlers.escapeKey = this.handleEscKey.bind(this);\n                    //Restrict tab action to the modal\n                    this.options.keyEventHandlers.tabKey = this.handleTabKey.bind(this);\n\n                    return this;\n                },\n\n                /**\n                 * Once the modal is opened it hides the X\n                 */\n                onOpened: function () {\n                    $('.modal-header button.action-close').attr('disabled', true).hide();\n\n                    this.focusableElements = $(this.rootSelector).find('a[href], button:enabled');\n                    this.firstFocusableElement = this.focusableElements[0];\n                    this.lastFocusableElement = this.focusableElements[this.focusableElements.length - 1];\n                    this.firstFocusableElement.focus();\n                },\n\n                /**\n                 * Changes admin usage setting to yes\n                 */\n                enableAdminUsage: function () {\n                    var data = {\n                        'form_key': window.FORM_KEY\n                    };\n\n                    $.ajax(\n                        {\n                            type: 'POST',\n                            url: this.enableLogAction,\n                            data: data,\n                            showLoader: true\n                        }\n                    ).done(\n                        function (xhr) {\n                            if (xhr.error) {\n                                self.onError(xhr);\n                            }\n                        }\n                    ).fail(this.onError);\n                    this.openReleasePopup();\n                    this.closeModal();\n                },\n\n                /**\n                 * Changes admin usage setting to no\n                 */\n                disableAdminUsage: function () {\n                    var data = {\n                        'form_key': window.FORM_KEY\n                    };\n\n                    $.ajax(\n                        {\n                            type: 'POST',\n                            url: this.disableLogAction,\n                            data: data,\n                            showLoader: true\n                        }\n                    ).done(\n                        function (xhr) {\n                            if (xhr.error) {\n                                self.onError(xhr);\n                            }\n                        }\n                    ).fail(this.onError);\n                    this.openReleasePopup();\n                    this.closeModal();\n                },\n\n                /**\n                 * Allows admin usage popup to be shown first and then new release notification\n                 */\n                openReleasePopup: function () {\n                    var notificationModalSelector = 'release_notification.release_notification.notification_modal_1';\n\n                    if (analyticsPopupConfig.releaseVisible) {\n                        registry.get(notificationModalSelector).initializeContentAfterAnalytics();\n                    }\n                },\n\n                /**\n                 * Handle Tab and Shift+Tab key event\n                 *\n                 * Keep the tab actions restricted to the popup modal\n                 * so the user must select an option to dismiss the modal\n                 */\n                handleTabKey: function (event) {\n                    var modal = this,\n                        KEY_TAB = 9;\n\n                    /**\n                     * Handle Shift+Tab to tab backwards\n                     */\n                    function handleBackwardTab() {\n                        if (document.activeElement === modal.firstFocusableElement ||\n                            document.activeElement === $(modal.rootSelector)[0]\n                        ) {\n                            event.preventDefault();\n                            modal.lastFocusableElement.focus();\n                        }\n                    }\n\n                    /**\n                     * Handle Tab forward\n                     */\n                    function handleForwardTab() {\n                        if (document.activeElement === modal.lastFocusableElement) {\n                            event.preventDefault();\n                            modal.firstFocusableElement.focus();\n                        }\n                    }\n\n                    switch (event.keyCode) {\n                        case KEY_TAB:\n                            if (modal.focusableElements.length === 1) {\n                                event.preventDefault();\n                                break;\n                            }\n\n                            if (event.shiftKey) {\n                                handleBackwardTab();\n                                break;\n                            }\n                            handleForwardTab();\n                            break;\n                        default:\n                            break;\n                    }\n                },\n\n                /**\n                 * Handle Esc key\n                 *\n                 * Esc key should not close modal\n                 */\n                handleEscKey: function (event) {\n                    event.preventDefault();\n                }\n            }\n        );\n    }\n);\n","Magento_AdminAnalytics/js/release-notification/modal/component-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(['jquery', 'analyticsPopupConfig'], function ($, analyticsPopupConfig) {\n    'use strict';\n\n    var deferred = $.Deferred(),\n\n        mixin = {\n        /**\n         * Initializes content only if its visible\n         */\n        initializeContent: function () {\n            var initializeContent = this._super.bind(this);\n\n            if (!analyticsPopupConfig.analyticsVisible) {\n                initializeContent();\n            } else {\n                deferred.then(function () {\n                    initializeContent();\n                });\n            }\n        },\n\n        /**\n         * Initializes release notification content after admin analytics\n         */\n        initializeContentAfterAnalytics: function () {\n            deferred.resolve();\n        }\n    };\n\n    return function (target) {\n        return target.extend(mixin);\n    };\n});\n\n","Magento_AdminNotification/toolbar_entry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'jquery/ui',\n    'domReady!'\n], function ($) {\n    'use strict';\n\n    /**\n     * Mark notification as read via AJAX call.\n     *\n     * @param {String} notificationId\n     */\n    var markNotificationAsRead = function (notificationId) {\n            var requestUrl = $('.notifications-wrapper .admin__action-dropdown-menu').attr('data-mark-as-read-url');\n\n            $.ajax({\n                url: requestUrl,\n                type: 'POST',\n                dataType: 'json',\n                data: {\n                    id: notificationId\n                },\n                showLoader: false\n            });\n        },\n        notificationCount = $('.notifications-wrapper').attr('data-notification-count'),\n\n        /**\n         * Remove notification from the list.\n         *\n         * @param {jQuery} notificationEntry\n         */\n        removeNotificationFromList = function (notificationEntry) {\n            var notificationIcon, actionElement;\n\n            notificationEntry.remove();\n            notificationCount--;\n            $('.notifications-wrapper').attr('data-notification-count', notificationCount);\n\n            if (notificationCount == 0) {// eslint-disable-line eqeqeq\n                // Change appearance of the bubble and its behavior when the last notification is removed\n                $('.notifications-wrapper .admin__action-dropdown-menu').remove();\n                notificationIcon = $('.notifications-wrapper .notifications-icon');\n                notificationIcon.removeAttr('data-toggle');\n                notificationIcon.off('click.dropdown');\n                $('.notifications-action .notifications-counter').text('').hide();\n            } else {\n                // Change top counter only for allowable range\n                if (notificationCount <= 99) {\n                    $('.notifications-action .notifications-counter').text(notificationCount);\n                }\n                $('.notifications-entry-last .notifications-counter').text(notificationCount);\n                // Modify caption of the 'See All' link\n                actionElement = $('.notifications-wrapper .admin__action-dropdown-menu .last .action-more');\n                actionElement.text(actionElement.text().replace(/\\d+/, notificationCount));\n            }\n        },\n\n        /**\n         * Show notification details.\n         *\n         * @param {jQuery} notificationEntry\n         */\n        showNotificationDetails = function (notificationEntry) {\n            var notificationDescription = notificationEntry.find('.notifications-entry-description'),\n                notificationDescriptionEnd = notificationEntry.find('.notifications-entry-description-end');\n\n            if (notificationDescriptionEnd.length > 0) {\n                notificationDescriptionEnd.addClass('_show');\n            }\n\n            if (notificationDescription.hasClass('_cutted')) {\n                notificationDescription.removeClass('_cutted');\n            }\n        };\n\n    // Show notification description when corresponding item is clicked\n    $('.notifications-wrapper .admin__action-dropdown-menu .notifications-entry').on(\n        'click.showNotification',\n        function (event) {\n            // hide notification dropdown\n            $('.notifications-wrapper .notifications-icon').trigger('click.dropdown');\n\n            showNotificationDetails($(this));\n            event.stopPropagation();\n        }\n    );\n\n    // Remove corresponding notification from the list and mark it as read\n    $('.notifications-close').on('click.removeNotification', function (event) {\n        var notificationEntry = $(this).closest('.notifications-entry'),\n            notificationId = notificationEntry.attr('data-notification-id');\n\n        markNotificationAsRead(notificationId);\n        removeNotificationFromList(notificationEntry);\n\n        // Checking for last unread notification to hide dropdown\n        if (notificationCount == 0) {// eslint-disable-line eqeqeq\n            $('.notifications-wrapper').removeClass('active')\n                .find('.notifications-action')\n                .removeAttr('data-toggle')\n                .off('click.dropdown');\n        }\n        event.stopPropagation();\n    });\n\n    // Hide notifications bubble\n    if (notificationCount == 0) {// eslint-disable-line eqeqeq\n        $('.notifications-action .notifications-counter').hide();\n    } else {\n        $('.notifications-action .notifications-counter').show();\n    }\n});\n","Magento_AdminNotification/js/grid/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/grid/listing',\n    'Magento_Ui/js/lib/spinner',\n    'jquery'\n], function (Listing, loader, $) {\n    'use strict';\n\n    return Listing.extend({\n        defaults: {\n            imports: {\n                totalRecords: '${ $.provider }:data.totalRecords'\n            },\n            selectors: {\n                collapsible: '.message-system-collapsible',\n                messages: '.message-system'\n            }\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .track({\n                    totalRecords: 0\n                });\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        showLoader: function () {\n            if (!this.source.firstLoad) {\n                this.fixLoaderHeight();\n                this._super();\n            }\n        },\n\n        /**\n         * Calculates loader height\n         *\n         * @param {Boolean} [closed]\n         */\n        fixLoaderHeight: function (closed) {\n            var $messagesBlock = $(this.selectors.messages),\n                $collapsibleBlock = $(this.selectors.collapsible),\n                resultHeight = 0;\n\n            if ($messagesBlock.length) {\n                resultHeight += $messagesBlock.outerHeight();\n            }\n\n            if ($collapsibleBlock.length && $collapsibleBlock.is(':visible') && !closed) {\n                resultHeight += $collapsibleBlock.outerHeight();\n            }\n\n            loader.get(this.name).height(resultHeight);\n        }\n    });\n});\n","Magento_AdminNotification/js/grid/columns/message.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'underscore'\n], function (Column, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_AdminNotification/grid/cells/message',\n            messageIndex: 'text',\n            fieldClass: {\n                message: true,\n                'message-warning': false,\n                'message-progress': false,\n                'message-success': false,\n                'message-error': false\n            },\n            statusMap: {\n                0: 'info',\n                1: 'progress',\n                2: 'success',\n                3: 'error'\n            }\n        },\n\n        /** @inheritdoc */\n        getLabel: function (record) {\n            return record[this.messageIndex];\n        },\n\n        /**\n         * Proxy to getLabel function with UnsanitizedHtml suffix\n         *\n         * @param {Object} record\n         * @returns {String}\n         */\n        getLabelUnsanitizedHtml: function (record) {\n            return this.getLabel(record);\n        },\n\n        /** @inheritdoc */\n        getFieldClass: function ($row) {\n            var status = this.statusMap[$row.status] || 'warning',\n                result = {};\n\n            result['message-' + status] = true;\n            result = _.extend({}, this.fieldClass, result);\n\n            return result;\n        }\n    });\n});\n","Magento_AdminNotification/js/system/messages/popup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/modal'\n], function ($, modal) {\n    'use strict';\n\n    return function (data, element) {\n\n        if (modal.modal) {\n            modal.modal.html($(element).html());\n        } else {\n            modal.modal = $(element).modal({\n                modalClass: data.class,\n                type: 'popup',\n                buttons: []\n            });\n        }\n\n        modal.modal.modal('openModal');\n    };\n});\n","Magento_AdminNotification/system/notification.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui',\n    'Magento_Ui/js/modal/modal'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.systemMessageDialog', $.mage.modal, {\n        options: {\n            modalClass: 'modal-system-messages',\n            systemMessageTemplate:\n                '<% _.each(data.items, function(item) { %>' +\n                    '<li class=\"message message-warning' +\n                        '<% if (item.severity == 1) { %>error<% } else { %>warning<% } %>\">' +\n                        '<%= item.text %>' +\n                    '</li>' +\n                '<% }); %>'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.options.title = $('#message-system-all').attr('title');\n            this._super();\n        },\n\n        /** @inheritdoc */\n        openModal: function (severity) {\n            var superMethod = $.proxy(this._super, this);\n\n            $.ajax({\n                url: this.options.ajaxUrl,\n                type: 'GET',\n                data: {\n                    severity: severity\n                }\n            }).done($.proxy(function (data) {\n                var tmpl = mageTemplate(this.options.systemMessageTemplate, {\n                    data: {\n                        items: data\n                    }\n                });\n\n                tmpl = $(tmpl);\n\n                this.element.html(\n                    $('<ul></ul>', {\n                        'class': 'message-system-list'\n                    }).append(tmpl)\n                ).trigger('contentUpdated');\n\n                superMethod();\n            }, this));\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        closeModal: function () {\n            this._super();\n        }\n    });\n\n    $(function () {\n        $('#system_messages .message-system-short .error').on('click', function () {\n            $('#message-system-all').systemMessageDialog('openModal', 1);\n        });\n\n        $('#system_messages .message-system-short .warning').on('click', function () {\n            $('#message-system-all').systemMessageDialog('openModal', 2);\n        });\n    });\n\n    return $.mage.systemMessageDialog;\n});\n","Magento_AdobeIms/js/config.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([], function () {\n    'use strict';\n\n    return {\n        loginUrl: 'https://ims-na1.adobelogin.com/ims/authorize',\n        profileUrl: 'adobe_ims/user/profile',\n        logoutUrl: 'adobe_ims/user/logout',\n        manageAccountLink: 'https://account.adobe.com/',\n        login: {\n            callbackParsingParams: {\n                regexpPattern: /auth\\[code=(success|error);message=(.+)\\]/,\n                codeIndex: 1,\n                messageIndex: 2,\n                nameIndex: 3,\n                successCode: 'success',\n                errorCode: 'error'\n            },\n            popupWindowParams: {\n                width: 500,\n                height: 600,\n                top: 100,\n                left: 300\n            },\n            popupWindowTimeout: 10000\n        }\n    };\n});\n\n","Magento_AdobeIms/js/signIn.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'jquery',\n    'Magento_AdobeIms/js/action/authorization'\n], function (Component, $, login) {\n    'use strict';\n\n    return Component.extend({\n\n        defaults: {\n            profileUrl: 'adobe_ims/user/profile',\n            logoutUrl: 'adobe_ims/user/logout',\n            user: {\n                isAuthorized: false,\n                name: '',\n                email: '',\n                image: ''\n            },\n            loginConfig: {\n                url: 'https://ims-na1.adobelogin.com/ims/authorize',\n                callbackParsingParams: {\n                    regexpPattern: /auth\\[code=(success|error);message=(.+)\\]/,\n                    codeIndex: 1,\n                    messageIndex: 2,\n                    nameIndex: 3,\n                    successCode: 'success',\n                    errorCode: 'error'\n                },\n                popupWindowParams: {\n                    width: 500,\n                    height: 600,\n                    top: 100,\n                    left: 300\n                },\n                popupWindowTimeout: 60000\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            this._super().observe(['user']);\n\n            return this;\n        },\n\n        /**\n         * Login to Adobe\n         *\n         * @return {window.Promise}\n         */\n        login: function () {\n            var deferred = $.Deferred();\n\n            if (this.user().isAuthorized) {\n                deferred.resolve();\n            }\n            login(this.loginConfig)\n                .then(function (response) {\n                    this.loadUserProfile();\n                    deferred.resolve(response);\n                }.bind(this))\n                .fail(function (error) {\n                    deferred.reject(error);\n                });\n\n            return deferred.promise();\n        },\n\n        /**\n         * Retrieve data to authorized user.\n         *\n         * @return array\n         */\n        loadUserProfile: function () {\n            $.ajax({\n                type: 'GET',\n                url: this.profileUrl,\n                showLoader: true,\n                dataType: 'json',\n                context: this,\n\n                /**\n                 * @param {Object} response\n                 * @returns void\n                 */\n                success: function (response) {\n                    this.user({\n                        isAuthorized: true,\n                        name: response.result.name,\n                        email: response.result.email,\n                        image: response.result.image\n                    });\n                },\n\n                /**\n                 * @param {Object} response\n                 * @returns {String}\n                 */\n                error: function (response) {\n                    return response.message;\n                }\n            });\n        },\n\n        /**\n         * Logout from adobe account\n         */\n        logout: function () {\n            $.ajax({\n                type: 'POST',\n                url: this.logoutUrl,\n                data: {\n                    'form_key': window.FORM_KEY\n                },\n                dataType: 'json',\n                context: this,\n                showLoader: true,\n                success: function () {\n                    this.user({\n                        isAuthorized: false,\n                        name: '',\n                        email: '',\n                        image: ''\n                    });\n                }.bind(this),\n\n                /**\n                 * @param {Object} response\n                 * @returns {String}\n                 */\n                error: function (response) {\n                    return response.message;\n                }\n            });\n        }\n    });\n});\n","Magento_AdobeIms/js/user.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(['ko'], function (ko) {\n    'use strict';\n\n    return {\n        isAuthorized: ko.observable(false),\n        name: ko.observable(''),\n        email: ko.observable('')\n    };\n});\n","Magento_AdobeIms/js/action/authorization.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * Build window params\n     * @param {Object} windowParams\n     * @returns {String}\n     */\n    function buildWindowParams(windowParams) {\n        var output = '',\n            coma = '',\n            paramName,\n            paramValue;\n\n        for (paramName in windowParams) {\n            if (windowParams[paramName]) {\n                paramValue = windowParams[paramName];\n                output += coma + paramName + '=' + paramValue;\n                coma = ',';\n            }\n        }\n\n        return output;\n    }\n\n    return function (config) {\n        var authWindow,\n            deferred = $.Deferred(),\n            watcherId,\n            stopWatcherId;\n\n        /**\n         * Close authorization window if already opened\n         */\n        if (window.adobeIMSAuthWindow) {\n            window.adobeIMSAuthWindow.close();\n        }\n\n        /**\n         * Opens authorization window with special parameters\n         */\n        authWindow = window.adobeIMSAuthWindow = window.open(\n            config.url,\n            'authorization_widnow',\n            buildWindowParams(\n                config.popupWindowParams || {\n                    width: 500,\n                    height: 300\n                }\n            )\n        );\n\n        /**\n         * Stop handle\n         */\n        function stopHandle() {\n            // Clear timers\n            clearTimeout(stopWatcherId);\n            clearInterval(watcherId);\n\n            // Close window\n            authWindow.close();\n        }\n\n        /**\n         * Start handle\n         */\n        function startHandle() {\n            var responseData;\n\n            try {\n\n                if (authWindow.document.domain !== document.domain ||\n                    authWindow.document.readyState !== 'complete') {\n                    return;\n                }\n\n                /**\n                 * If within 10 seconds the result is not received, then reject the request\n                 */\n                stopWatcherId = setTimeout(function () {\n                    stopHandle();\n                    deferred.reject(new Error('Time\\'s up.'));\n                }, config.popupWindowTimeout || 60000);\n\n                responseData = authWindow.document.body.innerHTML.match(\n                    config.callbackParsingParams.regexpPattern\n                );\n\n                if (!responseData) {\n                    return;\n                }\n\n                stopHandle();\n\n                if (responseData[config.callbackParsingParams.codeIndex] ===\n                    config.callbackParsingParams.successCode) {\n                    deferred.resolve({\n                        isAuthorized: true,\n                        lastAuthSuccessMessage: responseData[config.callbackParsingParams.messageIndex]\n                    });\n                } else {\n                    deferred.reject(responseData[config.callbackParsingParams.messageIndex]);\n                }\n            } catch (e) {\n                if (authWindow.closed) {\n                    clearTimeout(stopWatcherId);\n                    clearInterval(watcherId);\n\n                    // eslint-disable-next-line max-depth\n                    if (window.adobeIMSAuthWindow && window.adobeIMSAuthWindow.closed) {\n                        deferred.reject(new Error('Authentication window was closed.'));\n                    }\n                }\n            }\n        }\n\n        /**\n         * Watch a result 1 time per second\n         */\n        watcherId = setInterval(startHandle, 1000);\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockAdminUi/js/connection.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'uiComponent',\n    'jquery'\n], function (ko, Component, $) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_AdobeStockAdminUi/connection',\n            connectionFailedMessage: 'Connection test failed.',\n            emptyApiKeyMessage: 'Please fill the \"API Key (Client ID)\" field for a connection test',\n            apiKeyInputId: 'system_adobe_stock_integration_api_key',\n            url: '',\n            success: false,\n            message: '',\n            visible: false\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'success',\n                    'message',\n                    'visible'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * @override\n         */\n        initialize: function () {\n            this._super();\n            this.messageClass = ko.computed(function () {\n                return 'message-validation message message-' + (this.success() ? 'success' : 'error');\n            }, this);\n\n            if (!this.success()) {\n                this.showMessage(false, this.connectionFailedMessage);\n            }\n        },\n\n        /**\n         * @param {bool} success\n         * @param {String} message\n         */\n        showMessage: function (success, message) {\n            this.message(message);\n            this.success(success);\n            this.visible(true);\n        },\n\n        /**\n         * Send request to server to test connection to Adobe Stock API and display the result\n         */\n        testConnection: function () {\n            var apiKey = document.getElementById(this.apiKeyInputId).value;\n\n            if (apiKey.length === 0) {\n                this.showMessage(false, this.emptyApiKeyMessage);\n\n                return;\n            }\n\n            this.visible(false);\n\n            $.ajax({\n                type: 'POST',\n                url: this.url,\n                dataType: 'json',\n                data: {\n                    'api_key': apiKey\n                },\n                success: function (response) {\n                    this.showMessage(response.success === true, response.message);\n                }.bind(this),\n                error: function () {\n                    this.showMessage(false, this.connectionFailedMessage);\n                }.bind(this)\n            });\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/media-gallery.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global Base64 */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm'\n], function ($, confirm) {\n    'use strict';\n\n    return {\n        jsTreeRootFolderId: 'root',\n        jsTreeFolderNameMaxLength: 20,\n\n        /**\n         * Locate downloaded image in media browser\n         *\n         * @param {String} path\n         */\n        locate: function (path) {\n            var imageFolder = this.selectFolder(path),\n                imageFilename = path.substring(path.lastIndexOf('/') + 1),\n                locatedImage;\n\n            if (imageFolder.length) {\n                locatedImage = $('div[data-row=\"file\"]:has(img[alt=\\\"' + imageFilename + '\\\"])');\n\n                return locatedImage.length ? locatedImage : false;\n            }\n\n            $.ajaxSetup({\n                async: true\n            });\n        },\n\n        /**\n         * Select folder\n         *\n         * @param {String} path\n         */\n        selectFolder: function (path) {\n            var imageFolder,\n                pathId,\n                imagePath = path.replace(/^\\/+/, ''),\n                folderPathParts = imagePath.split('/').slice(0, -1);\n\n            $.ajaxSetup({\n                async: false\n            });\n\n            if (folderPathParts.length > 1) {\n                this.openFolderTree(folderPathParts);\n            }\n\n            pathId = Base64.idEncode(folderPathParts.join('/'));\n            imageFolder = $('.jstree li[data-id=\"' + pathId + '\"]').children('a');\n\n            if (!imageFolder.length) {\n                imageFolder = $('.jstree li[data-id=\"' + this.jsTreeRootFolderId + '\"]')\n                    .children('a');\n            }\n\n            if (imageFolder.length) {\n                imageFolder[0].click();\n            }\n\n            return imageFolder;\n        },\n\n        /**\n         * Show popup that image cannot be located\n         */\n        notLocated: function () {\n            confirm({\n                title: $.mage.__('The image cannot be located'),\n                content: $.mage.__('We cannot find this image in the media gallery.'),\n                buttons: [{\n                    text: $.mage.__('Ok'),\n                    class: 'action-primary',\n                    attr: {},\n\n                    /**\n                     * Close modal on button click\n                     */\n                    click: function (event) {\n                        this.closeModal(event);\n                    }\n                }]\n            });\n        },\n\n        /**\n         * Open folder Tree\n         *\n         * @param {Array} folderPathParts\n         */\n        openFolderTree: function (folderPathParts) {\n            var i,\n                pathId,\n                openFolderButton,\n                folderPath = '';\n\n            for (i = 0; i < folderPathParts.length - 1; i++) {\n                if (folderPath === '') {\n                    folderPath = folderPathParts[i];\n                } else {\n                    folderPath = folderPath + '/' + folderPathParts[i];\n                }\n                pathId = Base64.idEncode(folderPath);\n                openFolderButton = $('.jstree li[data-id=\"' + pathId + '\"].jstree-closed').children('.jstree-icon');\n\n                if (openFolderButton.length) {\n                    openFolderButton.click();\n                }\n            }\n        }\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/panel.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiElement',\n    'jquery',\n    'mage/translate'\n], function (Element, $, $t) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            containerId: '#adobe-stock-images-search-modal',\n            masonryComponentPath: 'adobe_stock_images_listing.adobe_stock_images_listing.adobe_stock_images_columns',\n            dataSourcePath: 'adobe_stock_images_listing.adobe_stock_images_listing_data_source',\n            modules: {\n                masonry: '${ $.masonryComponentPath }',\n                source: '${ $.dataSourcePath }'\n            }\n        },\n\n        /**\n         * Init component\n         *\n         * @return {exports}\n         */\n        initialize: function () {\n            this._super();\n\n            $(this.containerId).modal({\n                type: 'slide',\n                buttons: [],\n                modalClass: 'adobe-stock-modal',\n                title: $t('Adobe Stock')\n            }).on('openModal', function () {\n                this.masonry().setLayoutStylesWhenLoaded();\n            }.bind(this));\n\n            try {\n                $(this.containerId).applyBindings();\n            } catch (e) {\n                //already bounded\n            }\n\n            $(window).on('fileDeleted.mediabrowser', this.reloadGrid.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Update listing data\n         */\n        reloadGrid: function () {\n            this.source().set('params.t', Date.now());\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/path-utility.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([], function () {\n    'use strict';\n\n    return {\n        /**\n         * Extracts image name from its path\n         *\n         * @param {String} path\n         * @returns {String}\n         */\n        getImageNameFromPath: function (path) {\n            var filePathArray = path.split('/'),\n                imageIndex = filePathArray.length - 1;\n\n            return filePathArray[imageIndex].substring(0, filePathArray[imageIndex].lastIndexOf('.'));\n        },\n\n        /**\n         * Generate meaningful name image file,\n         * allow only alphanumerics, dashes, and underscores\n         *\n         * @param {String} title\n         * @param {Number} id\n         * @return string\n         */\n        generateImageName: function (title, id) {\n            var fileName = title.substring(0, 32)\n                .replace(/[^a-zA-Z0-9_]/g, '-')\n                .replace(/-{2,}/g, '-')\n                .toLowerCase();\n\n            /* If the filename does not contain latin chars, use ID as a filename */\n            return fileName === '-' ? id : fileName;\n        },\n\n        /**\n         * Get image file extension\n         *\n         * @param {String} contentType\n         * @return string\n         */\n        getImageExtension: function (contentType) {\n            return contentType.match(/[^/]{1,4}$/);\n        },\n\n        /**\n         * Create path\n         *\n         * @param {String} directoryPath\n         * @param {String} fileName\n         * @param {String} contentType\n         * @returns {String}\n         */\n        buildPath: function (directoryPath, fileName, contentType) {\n            return directoryPath + '/' + fileName + '.' + this.getImageExtension(contentType);\n        }\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/signIn.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_AdobeIms/js/signIn',\n    'Magento_AdobeIms/js/action/authorization',\n    'Magento_Ui/js/modal/confirm'\n], function ($, signIn, auth, confirm) {\n    'use strict';\n\n    return signIn.extend({\n\n        defaults: {\n            userQuota: {},\n            // eslint-disable-next-line max-len\n            dataProvider: 'name = adobe_stock_images_listing.adobe_stock_images_listing_data_source, ns = adobe_stock_images_listing',\n            // eslint-disable-next-line max-len\n            previewProvider: 'name = adobe_stock_images_listing.adobe_stock_images_listing.adobe_stock_images_columns.preview, ns = adobe_stock_images_listing',\n            quotaUrl: 'adobe_stock/license/quota',\n            modules: {\n                source: '${ $.dataProvider }',\n                preview: '${ $.previewProvider }'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            this._super().observe(['userQuota']);\n\n            return this;\n        },\n\n        /**\n         * Login to Adobe\n         *\n         * @return {*}\n         */\n        login: function () {\n            var deferred = $.Deferred();\n\n            if (this.user().isAuthorized) {\n                return deferred.resolve();\n            }\n            auth(this.loginConfig)\n                .then(function (response) {\n                    this.loadUserProfile();\n                    deferred.resolve(response);\n                }.bind(this))\n                .fail(function (error) {\n                    deferred.reject(error);\n                });\n\n            return deferred.promise();\n        },\n\n        /**\n         * Login action with popup on error..\n         */\n        loginClick: function () {\n            this.login().fail(function (error) {\n                this.showLoginErrorPopup(error);\n            }.bind(this));\n        },\n\n        /**\n         * Show popup that user failed to login.\n         */\n        showLoginErrorPopup: function (error) {\n            confirm({\n                title: $.mage.__('Couldn\\'t log you in'),\n                content: error,\n                buttons: [{\n                    text: $.mage.__('Ok'),\n                    class: 'action-primary action-accept'\n                }],\n                actions: {\n\n                    /**\n                       * Close modal\n                       */\n                    confirm: function (event) {\n                        this.closeModal(event);\n                    }\n                }\n            });\n        },\n\n        /**\n         * Logout from adobe account\n         */\n        logout: function () {\n            $.ajax({\n                type: 'POST',\n                url: this.logoutUrl,\n                data: {\n                    'form_key': window.FORM_KEY\n                },\n                dataType: 'json',\n                context: this,\n                showLoader: true,\n                success: function () {\n                    this.user({\n                        isAuthorized: false,\n                        name: '',\n                        email: '',\n                        image: this.defaultProfileImage\n                    });\n                }.bind(this),\n\n                /**\n                 * @param {Object} response\n                 * @returns {String}\n                 */\n                error: function (response) {\n                    return response.message;\n                }\n            });\n        },\n\n        /**\n         * Retrieves full user quota.\n         */\n        getUserQuota: function () {\n            $.ajax({\n                type: 'GET',\n                url: this.quotaUrl,\n                dataType: 'json',\n                context: this,\n\n                /**\n                 * @param {Object} response\n                 * @returns void\n                 */\n                success: function (response) {\n                    this.userQuota(response.result);\n                },\n\n                /**\n                 * @param {Object} response\n                 * @returns {String}\n                 */\n                error: function (response) {\n                    return response.message;\n                }\n            });\n        },\n\n        /**\n         * @inheritdoc\n         */\n        loadUserProfile: function () {\n            $.ajax({\n                type: 'GET',\n                url: this.profileUrl,\n                dataType: 'json',\n                context: this,\n\n                /**\n                 * @param {Object} response\n                 * @returns void\n                 */\n                success: function (response) {\n                    this.user({\n                        isAuthorized: true,\n                        name: response.result.name,\n                        email: response.result.email,\n                        image: response.result.image\n                    });\n                    this.getUserQuota();\n                },\n\n                /**\n                 * @param {Object} response\n                 * @returns {String}\n                 */\n                error: function (response) {\n                    return response.message;\n                }\n            });\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/action/confirmQuota.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (requestUrl, adobeAssetId) {\n        var deferred = $.Deferred();\n\n        $.ajax({\n            type: 'GET',\n            url: requestUrl,\n            dataType: 'json',\n            data: {\n                'media_id': adobeAssetId\n            },\n            showLoader: true,\n\n            /**\n             * Extract the data from the response and resolve\n             *\n             * @param {Object} response\n             */\n            success: function (response) {\n                deferred.resolve({\n                    canLicense: response.result.canLicense,\n                    message: response.result.message\n                });\n            },\n\n            /**\n             * Extract the error message and reject\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n                var message = response.JSON ? response.JSON.message\n                    : $.mage.__('Could not fetch licensing information.');\n\n                if (response.status === 403) {\n                    message = $.mage.__('Your admin role does not have permissions to license an image');\n                }\n\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/action/getLicenseStatus.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (requestUrl, ids) {\n        var deferred = $.Deferred();\n\n        $.ajax({\n            type: 'GET',\n            url: requestUrl + '?ids=' + ids.join(','),\n            data: {\n                'form_key': window.FORM_KEY\n            },\n            showLoader: true,\n            dataType: 'json',\n\n            /**\n             * Resolve with the response result\n             *\n             * @param {Object} response\n             */\n            success: function (response) {\n                deferred.resolve(response.result);\n            },\n\n            /**\n             * Reject with the message from response\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n                var message = response.message;\n\n                if (response.status === 403) {\n                    message = $.mage.__('Your admin role does not have permissions to license an image');\n                }\n\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/action/licenseAndSave.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_AdobeStockImageAdminUi/js/action/save',\n    'Magento_AdobeStockImageAdminUi/js/confirmation/license',\n    'Magento_AdobeStockImageAdminUi/js/path-utility'\n], function ($, saveAction, licenseConfirmation, pathUtility) {\n    'use strict';\n\n    return function (\n        requestUrl,\n        id,\n        title,\n        path,\n        contentType,\n        isDownloaded,\n        quotaMessage,\n        directoryPath\n    ) {\n        var deferred = $.Deferred(),\n            destinationPath;\n\n        licenseConfirmation(\n                title,\n                quotaMessage,\n                isDownloaded,\n                pathUtility.generateImageName(title, id),\n                pathUtility.getImageExtension(contentType)\n            ).then(function (fileName) {\n\n                if (typeof fileName === 'undefined') {\n                    fileName = pathUtility.getImageNameFromPath(path);\n                }\n\n                destinationPath = pathUtility.buildPath(directoryPath, fileName, contentType);\n\n                saveAction(\n                    requestUrl,\n                    id,\n                    destinationPath\n                ).then(function () {\n                    deferred.resolve(destinationPath);\n                }).fail(function (message) {\n                    deferred.reject(message);\n                });\n            }).fail(function (error) {\n                deferred.reject(error);\n            });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/action/save.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (requestUrl, adobeAssetId, destinationPath) {\n        var deferred = $.Deferred();\n\n        $.ajax({\n            type: 'POST',\n            url: requestUrl,\n            dataType: 'json',\n            showLoader: true,\n            data: {\n                'media_id': adobeAssetId,\n                'destination_path': destinationPath\n            },\n\n            /**\n             * Resolve on success\n             */\n            success: function () {\n                deferred.resolve();\n            },\n\n            /**\n             * Extract the error message and reject\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n                var message;\n\n                if (typeof response.responseJSON === 'undefined' ||\n                    typeof response.responseJSON.message === 'undefined'\n                ) {\n                    message = 'Could not save the asset!';\n                } else {\n                    message = response.responseJSON.message;\n                }\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/action/saveLicensed.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_AdobeStockImageAdminUi/js/action/save',\n    'Magento_AdobeStockImageAdminUi/js/confirmation/saveLicensed',\n    'Magento_AdobeStockImageAdminUi/js/path-utility'\n], function ($, saveAction, saveLicensedConfirmation, pathUtility) {\n    'use strict';\n\n    return function (requestUrl, id, title, path, contentType, directoryPath) {\n        var imageName = '',\n            destinationPath,\n            deferred = $.Deferred();\n\n        if (path !== '') {\n            imageName = pathUtility.getImageNameFromPath(path);\n            destinationPath = pathUtility.buildPath(directoryPath, imageName, contentType);\n            saveAction(\n                requestUrl,\n                id,\n                destinationPath\n            ).then(function () {\n                deferred.resolve(destinationPath);\n            }).fail(function (message) {\n                deferred.reject(message);\n            });\n\n            return deferred.promise();\n        }\n\n        saveLicensedConfirmation(\n            pathUtility.generateImageName(title, id),\n            pathUtility.getImageExtension(contentType)\n        ).then(function (fileName) {\n            destinationPath = pathUtility.buildPath(directoryPath, fileName, contentType);\n            saveAction(\n                requestUrl,\n                id,\n                destinationPath\n            ).then(function () {\n                deferred.resolve(destinationPath);\n            }).fail(function (message) {\n                deferred.reject(message);\n            });\n        }).fail(function (error) {\n            deferred.reject(error);\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/action/savePreview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_AdobeStockImageAdminUi/js/action/save',\n    'Magento_AdobeStockImageAdminUi/js/confirmation/save',\n    'Magento_AdobeStockImageAdminUi/js/path-utility'\n], function ($, saveAction, saveConfirmation, pathUtility) {\n    'use strict';\n\n    return function (requestUrl, id, title, contentType, directoryPath) {\n        var deferred = $.Deferred(),\n            destinationPath;\n\n        saveConfirmation(\n            pathUtility.generateImageName(title, id),\n            pathUtility.getImageExtension(contentType)\n        ).then(function (fileName) {\n            destinationPath = pathUtility.buildPath(directoryPath, fileName, contentType);\n\n            saveAction(\n                requestUrl,\n                id,\n                destinationPath\n            ).then(function () {\n                deferred.resolve(destinationPath);\n            }).fail(function (error) {\n                deferred.reject(error);\n            });\n        }).fail(function (error) {\n            deferred.reject(error);\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/components/images-grid-sizes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/paging/sizes',\n    'underscore'\n], function (Sizes, _) {\n    'use strict';\n\n    return Sizes.extend({\n        defaults: {\n            value: 32,\n            minSize: 1,\n            maxSize: 64\n        },\n\n        exports: {\n            value: '${ $.provider }:params.paging.page',\n            options: '${ $.provider }:params.paging.options'\n        },\n\n        sizes: {\n            '32': {\n                value: 32,\n                label: 32\n            },\n            '48': {\n                value: 48,\n                label: 48\n            },\n            '64': {\n                value: 64,\n                label: 64\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        updateArray: function () {\n            if (_.isUndefined(this.options)) {\n                this.options = this.sizes;\n            }\n\n            return this._super();\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/components/grid/column/image-preview.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'uiLayout',\n    'Magento_Ui/js/grid/columns/image-preview'\n], function ($, layout, imagePreview) {\n    'use strict';\n\n    return imagePreview.extend({\n        defaults: {\n            downloadImagePreviewUrl: 'adobe_stock/preview/download',\n            licenseAndDownloadUrl: 'adobe_stock/license/license',\n            saveLicensedAndDownloadUrl: 'adobe_stock/license/saveLicensed',\n            confirmationUrl: 'adobe_stock/license/confirmation',\n            relatedImagesUrl: 'adobe_stock/preview/relatedimages',\n            buyCreditsUrl: 'https://stock.adobe.com/',\n            mediaGallerySelector: '.media-gallery-modal:has(#search_adobe_stock)',\n            adobeStockModalSelector: '.adobe-search-images-modal',\n            activeMediaGallerySelector: 'aside.modal-slide.adobe-stock-modal._show',\n            modules: {\n                keywords: '${ $.name }_keywords',\n                related: '${ $.name }_related',\n                actions: '${ $.name }_actions'\n            },\n            viewConfig: [\n                {\n                    component: 'Magento_AdobeStockImageAdminUi/js/components/grid/column/preview/keywords',\n                    name: '${ $.name }_keywords'\n                },\n                {\n                    component: 'Magento_AdobeStockImageAdminUi/js/components/grid/column/preview/related',\n                    name: '${ $.name }_related'\n                },\n                {\n                    component: 'Magento_AdobeStockImageAdminUi/js/components/grid/column/preview/actions',\n                    name: '${ $.name }_actions',\n                    provider: '${ $.provider }',\n                    mediaGallery: '${ $.mediaGalleryComponent }',\n                    mediaGalleryName: '${ $.mediaGalleryName }',\n                    mediaGalleryProvider: '${ $.mediaGalleryProvider }',\n                    mediaGallerySortBy: '${ $.mediaGallerySortBy }',\n                    mediaGallerySearchInput: '${ $.mediaGallerySearchInput }',\n                    mediaGalleryListingFilters: '${ $.mediaGalleryListingFilters }',\n                    getMediaGalleryAsset: '${ $.getMediaGalleryAsset }',\n                    imageEditDetailsUrl: '${ $.imageEditDetailsUrl }',\n                    listingPaging: '${ $.listingPaging }'\n                }\n            ],\n            listens: {\n                '${ $.sortByComponentName }:applied': 'hide'\n            }\n        },\n\n        /**\n         * Initialize the component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super().initView();\n            $(window).on('fileDeleted.enhancedMediaGallery', this.reloadAdobeGrid.bind(this));\n            $(window).on('folderDeleted.enhancedMediaGallery', this.reloadAdobeGrid.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Initialize child components\n         *\n         * @returns {Object}\n         */\n        initView: function () {\n            layout(this.viewConfig);\n\n            return this;\n        },\n\n        /**\n         * Get previous button disabled\n         *\n         * @param {Object} record\n         *\n         * @return {Boolean}\n         */\n        cannotViewPrevious: function (record) {\n            return this.related().cannotViewPrevious(record);\n        },\n\n        /**\n         * Get next button disabled\n         *\n         * @param {Object} record\n         *\n         * @return {Boolean}\n         */\n        cannotViewNext: function (record) {\n            return this.related().cannotViewNext(record);\n        },\n\n        /**\n         * Return active adobe gallery selector.\n         */\n        getAdobeModal: function () {\n            return $(this.activeMediaGallerySelector).find(this.adobeStockModalSelector);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        next: function (record) {\n            if (this.related().selectedTab()) {\n                this.related().nextRelated(record);\n\n                return;\n            }\n            this.keywords().hideAllKeywords();\n            this._super(record);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        prev: function (record) {\n            if (this.related().selectedTab()) {\n                this.related().prevRelated(record);\n\n                return;\n            }\n            this.keywords().hideAllKeywords();\n            this._super(record);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        show: function (record) {\n            this.related().selectedTab(null);\n            this.keywords().hideAllKeywords();\n            this.displayedRecord(record);\n            this._super(record);\n            this.related().loadRelatedImages(record);\n        },\n\n        /**\n         * Show related image data in the preview section\n         *\n         * @param {Object} record\n         */\n        showRelated: function (record) {\n            this.keywords().hideAllKeywords();\n            this.displayedRecord(record);\n            this.updateHeight();\n        },\n\n        /**\n         * Returns attributes to display under the preview image\n         *\n         * @returns {*[]}\n         */\n        getDisplayAttributes: function () {\n            if (!this.displayedRecord()) {\n                return [];\n            }\n\n            return [\n                {\n                    name: 'Dimensions',\n                    value: this.displayedRecord().width + ' x ' + this.displayedRecord().height + ' px'\n                },\n                {\n                    name: 'File type',\n                    value: this.displayedRecord()['content_type'].toUpperCase()\n                },\n                {\n                    name: 'Category',\n                    value: this.displayedRecord().category.name || 'None'\n                },\n                {\n                    name: 'File #',\n                    value: this.displayedRecord().id\n                }\n            ];\n        },\n\n        /**\n         * Reload Adobe grid after deleting image\n         */\n        reloadAdobeGrid: function () {\n            this.actions().source().reload({\n                refresh: true\n            });\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/components/grid/column/overlay.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/grid/columns/overlay',\n    'Magento_AdobeStockImageAdminUi/js/action/getLicenseStatus'\n], function ($, _, overlay, getLicenseStatus) {\n    'use strict';\n\n    return overlay.extend({\n        defaults: {\n            // eslint-disable-next-line max-len\n            provider: 'name = adobe_stock_images_listing.adobe_stock_images_listing_data_source, ns = adobe_stock_images_listing',\n            loginProvider: 'name = adobe-login, ns = adobe-login',\n            getImagesUrl: 'adobe_stock/license/getlist',\n            licensed: {},\n            modules: {\n                login: '${ $.loginProvider }'\n            },\n            listens: {\n                '${ $.provider }:data.items': 'handleItemsUpdate',\n                '${ $.loginProvider }:user': 'handleUserUpdate'\n            },\n            imports: {\n                rows: '${ $.provider }:data.items'\n            }\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'licensed'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Updates the licensed data when items data is updated.\n         *\n         * @param {Array} items\n         */\n        handleItemsUpdate: function (items) {\n            var ids = this.getIds(items);\n\n            this.updateLicensed(ids);\n        },\n\n        /**\n         * Updates the licensed data when user data is updated.\n         */\n        handleUserUpdate: function () {\n            var ids = this.getIds(this.rows);\n\n            this.updateLicensed(ids);\n        },\n\n        /**\n         * Set Licensed images data.\n         *\n         * @param {Array} ids\n         */\n        updateLicensed: function (ids) {\n            if (!this.isUserAuthorized() || ids.length === 0) {\n                this.licensed({});\n\n                return;\n            }\n\n            getLicenseStatus(this.getImagesUrl, ids).then(function (licensed) {\n                this.licensed(licensed);\n            }.bind(this));\n        },\n\n        /**\n         * Checks if user is logged in and authorized\n         *\n         * @returns {Boolean}\n         */\n        isUserAuthorized: function () {\n            return !_.isUndefined(this.login()) && this.login().user().isAuthorized;\n        },\n\n        /**\n         * Get all ids from items array\n         *\n         * @param {Array} items\n         * @returns {Number[]}\n         */\n        getIds: function (items) {\n            var ids = [];\n\n            items.forEach(function (record) {\n                ids.push(record.id);\n            });\n\n            return ids;\n        },\n\n        /**\n         * Returns top displacement of overlay according to image height\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Object}\n         */\n        getStyles: function (record) {\n            var height = record.styles().height.replace('px', '') - 40;\n\n            return {\n                top: height + 'px'\n            };\n        },\n\n        /**\n         * If overlay should be visible\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isVisible: function (row) {\n            return this.licensed()[row.id];\n        },\n\n        /**\n         * Get overlay label\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getLabel: function (row) {\n            return this.licensed()[row.id] ? 'Licensed' : '';\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/components/grid/column/preview/actions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'uiRegistry',\n    'jquery',\n    'underscore',\n    'Magento_AdobeStockImageAdminUi/js/action/save',\n    'Magento_AdobeStockImageAdminUi/js/action/savePreview',\n    'Magento_AdobeStockImageAdminUi/js/action/saveLicensed',\n    'Magento_AdobeStockImageAdminUi/js/action/licenseAndSave',\n    'Magento_AdobeStockImageAdminUi/js/action/confirmQuota',\n    'Magento_AdobeStockImageAdminUi/js/media-gallery',\n    'Magento_AdobeStockImageAdminUi/js/confirmation/buyCredits',\n    'Magento_AdobeStockImageAdminUi/js/action/getLicenseStatus',\n    'Magento_Ui/js/modal/alert'\n], function (\n    Component,\n    uiRegistry,\n    $,\n    _,\n    saveAction,\n    savePreviewAction,\n    saveLicensedAction,\n    licenseAndSaveAction,\n    confirmQuotaAction,\n    mediaGallery,\n    buyCreditsConfirmation,\n    getLicenseStatus,\n    uiAlert\n) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_AdobeStockImageAdminUi/grid/column/preview/actions',\n            loginProvider: 'name = adobe-login, ns = adobe-login',\n            mediaGallerySelector: '.media-gallery-modal:has(#search_adobe_stock)',\n            adobeStockModalSelector: '.adobe-search-images-modal',\n            downloadImagePreviewUrl: 'adobe_stock/preview/download',\n            licenseAndDownloadUrl: 'adobe_stock/license/license',\n            saveLicensedAndDownloadUrl: 'adobe_stock/license/saveLicensed',\n            buyCreditsUrl: 'https://stock.adobe.com/',\n            messageDelay: 5,\n            mediaGallery: '',\n            imageItems: [],\n            messages: [],\n            listens: {\n                '${ $.provider }:data.items': 'updateActions'\n            },\n            modules: {\n                login: '${ $.loginProvider }',\n                preview: '${ $.parentName }.preview',\n                overlay: '${ $.parentName }.overlay',\n                source: '${ $.provider }',\n                imageDirectory: '${ $.mediaGalleryName }',\n                mediaGallerySortBy: '${ $.mediaGallerySortBy }',\n                mediaGallerySearchInput: '${ $.mediaGallerySearchInput }',\n                mediaGalleryListingFilters: '${ $.mediaGalleryListingFilters }',\n                listingPaging: '${ $.listingPaging }'\n            },\n            imports: {\n                imageItems: '${ $.mediaGalleryProvider }:data.items'\n            }\n        },\n\n        /**\n         * Init observable variables\n         *\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'imageItems',\n                    'messages'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Update displayed record data on data source update\n         */\n        updateActions: function () {\n            var displayedRecord = this.preview().displayedRecord(),\n                updatedDisplayedRecord = this.preview().displayedRecord(),\n                records = this.source().data.items,\n                index;\n\n            if (typeof displayedRecord.id === 'undefined') {\n                return;\n            }\n\n            for (index = 0; index < records.length; index++) {\n                if (records[index].id === displayedRecord.id) {\n                    updatedDisplayedRecord = records[index];\n                    break;\n                }\n            }\n\n            this.preview().displayedRecord(updatedDisplayedRecord);\n        },\n\n        /**\n         * Returns is_downloaded flag as observable for given record\n         *\n         * @returns {observable}\n         */\n        isDownloaded: function () {\n            return this.preview().displayedRecord()['is_downloaded'];\n        },\n\n        /**\n         * Is asset licensed in adobe stock in context of currently logged in account\n         *\n         * @returns {observable}\n         */\n        isLicensed: function () {\n            return this.overlay().licensed()[this.preview().displayedRecord().id] && !this.isLicensedLocally();\n        },\n\n        /**\n         * Is licensed version of asset saved locally\n         *\n         * @returns {observable}\n         */\n        isLicensedLocally: function () {\n            return this.preview().displayedRecord()['is_licensed_locally'];\n        },\n\n        /**\n         * Locate downloaded image in media browser\n         */\n        openInMediaGalleryClick: function () {\n            this.preview().getAdobeModal().trigger('closeModal');\n\n            if (!this.isMediaBrowser()) {\n                this.selectImageInNewMediaGalleryBySearch(this.preview().displayedRecord().id);\n            } else {\n                this.selectDisplayedImageForOldMediaGallery(this.preview().displayedRecord().path);\n            }\n        },\n\n        /**\n         * Return adobe stock asset by adobe id\n         *\n         * @param {String} adobeId\n         */\n        getAssetDetails: function (adobeId) {\n            return $.ajax({\n                url: this.getMediaGalleryAsset,\n                data: {\n                    'adobe_id': adobeId\n                },\n                context: this,\n                showLoader: true\n            });\n        },\n\n        /**\n         * Select image in new media gallery via search input\n         *\n         * @param {String} imageId\n         */\n        selectImageInNewMediaGalleryBySearch: function (imageId) {\n            var path;\n\n            this.mediaGalleryListingFilters().clear();\n            this.getAssetDetails(imageId).then(function (assetDetails) {\n                if (assetDetails.length === 0) {\n                    return;\n                }\n                this.mediaGallerySearchInput().apply(assetDetails.title);\n                path = assetDetails.path;\n                path = path.substring(0, path.lastIndexOf('/'));\n\n                if (path !== '') {\n                    this.imageDirectory().locateNode(path);\n                }\n                this.selectRecordFromMediaGalleryProvider(assetDetails.path);\n            }.bind(this));\n\n        },\n\n        /**\n         * Open recently saved image and go to first page\n         */\n        openNewestImage: function () {\n            this.listingPaging().goFirst();\n            this.mediaGallerySortBy().selectDefaultOption();\n        },\n\n        /**\n         * Selects displayed image in media gallery for old gallery\n         */\n        selectDisplayedImageForOldMediaGallery: function (path) {\n            var image = mediaGallery.locate(path);\n\n            image ? image.trigger('click') : mediaGallery.notLocated();\n        },\n\n        /**\n         * Select record by image file name\n         *\n         * @param {String} path\n         */\n        selectRecordFromMediaGalleryProvider: function (path) {\n            var subscription;\n\n            subscription = this.imageItems.subscribe(function (items) {\n                subscription.dispose();\n                items.each(function (item) {\n                    if (item.path === path) {\n                        this.selectRecord(item);\n\n                        return false;\n                    }\n                }.bind(this));\n            }.bind(this));\n\n            setTimeout(function () {\n                subscription.dispose();\n            }, 1500);\n        },\n\n        /**\n         * Set the record as selected\n         *\n         * @param {Object} record\n         */\n        selectRecord: function (record) {\n            uiRegistry.get('name =' + this.mediaGallery).select(record);\n        },\n\n        /**\n         * Save preview click handler\n         */\n        savePreviewClick: function () {\n            var record = this.preview().displayedRecord();\n\n            savePreviewAction(\n                this.preview().downloadImagePreviewUrl,\n                record.id,\n                record.title,\n                record['content_type'],\n                this.getDestinationDirectoryPath()\n            ).then(function (destinationPath) {\n                this.updateDownloadedDisplayedRecord(destinationPath);\n                this.reloadGrid().done(function () {\n                    this.openInMediaGalleryClick();\n                }.bind(this));\n            }.bind(this)).fail(function (error) {\n                if (error) {\n                    this.showErrorMessage(error);\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Update displayed record after downloading\n         *\n         * @param {String} path\n         */\n        updateDownloadedDisplayedRecord: function (path) {\n            var record = this.preview().displayedRecord();\n\n            record['is_downloaded'] = 1;\n\n            if (record.path === '') {\n                record.path = path;\n            }\n\n            this.preview().displayedRecord(record);\n        },\n\n        /**\n         * Update displayed record after licensing\n         *\n         * @param {String} path\n         */\n        updateLicensedDisplayedRecord: function (path) {\n            var record = this.preview().displayedRecord();\n\n            record['is_downloaded'] = 1;\n\n            if (record.path === '') {\n                record.path = path;\n            }\n\n            record['is_licensed'] = 1;\n            record['is_licensed_locally'] = 1;\n\n            this.preview().displayedRecord(record);\n        },\n\n        /**\n         * Get image destination path\n         *\n         * @param {String} fileName\n         * @param {String} contentType\n         * @returns {String}\n         */\n        getDestinationPath: function (fileName, contentType) {\n            return this.getDestinationDirectoryPath() + '/' + fileName + '.' + this.getImageExtension(contentType);\n        },\n\n        /**\n         * Get destination directory path\n         *\n         * @returns {String}\n         */\n        getDestinationDirectoryPath: function () {\n            var activeNodePath,\n                activeNode;\n\n            if (this.isMediaBrowser()) {\n                activeNode = this.getMageMediaBrowserData().activeNode;\n\n                activeNodePath = _.isUndefined(activeNode.original.path) ? '' : activeNode.original.path;\n            } else {\n                activeNodePath = this.imageDirectory().activeNode() || '';\n            }\n\n            return activeNodePath;\n        },\n\n        /**\n         * Reload grid\n         *\n         * @returns {*}\n         */\n        reloadGrid: function () {\n            var provider,\n                dataStorage;\n\n            if (this.isMediaBrowser()) {\n                return this.getMageMediaBrowserData().reload();\n            }\n\n            provider = uiRegistry.get('index = media_gallery_listing_data_source'),\n                dataStorage = provider.storage();\n\n            dataStorage.clearRequests();\n\n            return provider.reload();\n        },\n\n        /**\n         * Get data for media browser\n         *\n         * @returns {Undefined|Object}\n         */\n        getMageMediaBrowserData: function () {\n            return $(this.preview().mediaGallerySelector).data('mageMediabrowser');\n        },\n\n        /**\n         * Is the media browser used in the content of the grid\n         *\n         * @returns {Boolean}\n         */\n        isMediaBrowser: function () {\n            return typeof this.getMageMediaBrowserData() !== 'undefined';\n        },\n\n        /**\n         * Generate meaningful name image file,\n         * allow only alphanumerics, dashes, and underscores\n         *\n         * @param {String} title\n         * @param {Number} id\n         * @return string\n         */\n        generateImageName: function (title, id) {\n            var fileName = title.substring(0, 32)\n                .replace(/[^a-zA-Z0-9_]/g, '-')\n                .replace(/-{2,}/g, '-')\n                .toLowerCase();\n\n            /* If the filename does not contain latin chars, use ID as a filename */\n            return fileName === '-' ? id : fileName;\n        },\n\n        /**\n         * Get image file extension\n         *\n         * @param {String} contentType\n         * @return string\n         */\n        getImageExtension: function (contentType) {\n            return contentType.match(/[^/]{1,4}$/);\n        },\n\n        /**\n         * Get messages\n         *\n         * @return {Array}\n         */\n        getMessages: function () {\n            return this.messages();\n        },\n\n        /**\n         * License click handler\n         */\n        licenseClick: function () {\n            var record = this.preview().displayedRecord();\n\n            this.licenseProcess(\n                record.id,\n                record.title,\n                record.path,\n                record['content_type'],\n                this.isDownloaded()\n            ).then(function (destinationPath) {\n                this.updateLicensedDisplayedRecord(destinationPath);\n                this.login().getUserQuota();\n                this.reloadGrid().done(function () {\n                    this.openInMediaGalleryClick();\n                }.bind(this));\n            }.bind(this)).fail(function (error) {\n                if (error) {\n                    uiAlert({\n                        content: error\n                    });\n                }\n            });\n        },\n\n        /**\n         * Process of license\n         *\n         * @param {Number} id\n         * @param {String} title\n         * @param {String} path\n         * @param {String} contentType\n         * @param {Boolean} isDownloaded\n         * @return {window.Promise}\n         */\n        licenseProcess: function (id, title, path, contentType, isDownloaded) {\n            var deferred = $.Deferred();\n\n            this.login().login()\n                .then(function () {\n                    getLicenseStatus(\n                        this.overlay().getImagesUrl,\n                        [id]\n                    ).then(function (licensedInfo) {\n                        var isLicensed = licensedInfo[id] || false;\n\n                        if (isLicensed) {\n                            saveLicensedAction(\n                                this.preview().saveLicensedAndDownloadUrl,\n                                id,\n                                title,\n                                path,\n                                contentType,\n                                this.getDestinationDirectoryPath()\n                            ).then(function (destinationPath) {\n                                deferred.resolve(destinationPath);\n                            }).fail(function (error) {\n                                deferred.reject(error);\n                            });\n                        } else {\n                            confirmQuotaAction(this.preview().confirmationUrl, id).then(function (data) {\n                                if (data.canLicense === false) {\n                                    buyCreditsConfirmation(\n                                        this.preview().buyCreditsUrl,\n                                        title,\n                                        data.message\n                                    );\n                                } else {\n                                    licenseAndSaveAction(\n                                        this.preview().licenseAndDownloadUrl,\n                                        id,\n                                        title,\n                                        path,\n                                        contentType,\n                                        isDownloaded,\n                                        data.message,\n                                        this.getDestinationDirectoryPath()\n                                    ).then(function (destinationPath) {\n                                        deferred.resolve(destinationPath);\n                                    }).fail(function (error) {\n                                        deferred.reject(error);\n                                    });\n                                }\n                            }.bind(this)).fail(function (error) {\n                                deferred.reject(error);\n                            });\n                        }\n                    }.bind(this)).fail(function (error) {\n                        deferred.reject(error);\n                    });\n                }.bind(this)).fail(function (error) {\n                deferred.reject(error);\n            });\n\n            return deferred.promise();\n        },\n\n        /**\n         * Save licensed click handler\n         */\n        saveLicensedClick: function () {\n            var record = this.preview().displayedRecord();\n\n            if (!this.login().user().isAuthorized) {\n                return;\n            }\n\n            if (!this.isLicensed()) {\n                return;\n            }\n\n            saveLicensedAction(\n                this.preview().saveLicensedAndDownloadUrl,\n                record.id,\n                record.title,\n                record.path,\n                record['content_type'],\n                this.getDestinationDirectoryPath()\n            ).then(function (destinationPath) {\n                this.updateLicensedDisplayedRecord(destinationPath);\n                this.login().getUserQuota();\n                this.reloadGrid().done(function () {\n                    this.openInMediaGalleryClick();\n                }.bind(this));\n            }.bind(this)).fail(function (error) {\n                if (error) {\n                    uiAlert({\n                        content: error\n                    });\n                }\n            });\n        },\n\n        /**\n         * Returns license button title depending on the existing saved preview\n         *\n         * @returns {String}\n         */\n        getLicenseButtonTitle: function () {\n            return this.isDownloaded() ? $.mage.__('License') : $.mage.__('License and Save');\n        },\n\n        /**\n         * Extracts image name from its path\n         *\n         * @param {String} path\n         * @returns {String}\n         */\n        getImageNameFromPath: function (path) {\n            var filePathArray = path.split('/'),\n                imageIndex = filePathArray.length - 1;\n\n            return filePathArray[imageIndex].substring(0, filePathArray[imageIndex].lastIndexOf('.'));\n        },\n\n        /**\n         * Show error message and schedule cleanup\n         *\n         * @param {String} message\n         */\n        showErrorMessage: function (message) {\n            this.messages.push({\n                code: 'error',\n                messageUnsanitizedHtml: message\n            });\n            this.messagesCleanup();\n        },\n\n        /**\n         * Messages cleanup\n         */\n        messagesCleanup: function () {\n            // eslint-disable-next-line no-unused-vars\n            var timerId;\n\n            // eslint-disable-next-line no-unused-vars\n            timerId = setTimeout(function () {\n                clearTimeout(timerId);\n                this.messages.removeAll();\n            }.bind(this), Number(this.messageDelay) * 1000);\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/components/grid/column/preview/keywords.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'underscore'\n], function (Component, _) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_AdobeStockImageAdminUi/grid/column/preview/keywords',\n            chipsProvider: 'componentType = filtersChips, ns = ${ $.ns }',\n            defaultKeywordsLimit: 5,\n            keywordsLimit: 5,\n            canViewMoreKeywords: true,\n            modules: {\n                chips: '${ $.chipsProvider }',\n                preview: '${ $.parentName }.preview'\n            }\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'keywordsLimit',\n                    'canViewMoreKeywords'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Returns keywords to display under the attributes image\n         *\n         * @returns {*[]}\n         */\n        getKeywords: function (record) {\n            return record.keywords;\n        },\n\n        /**\n         * Returns keywords limit to show no of keywords\n         */\n        getKeywordsLimit: function () {\n            return this.keywordsLimit();\n        },\n\n        /**\n         * Show all the related keywords\n         */\n        viewAllKeywords: function (record) {\n            this.keywordsLimit(record.keywords.length);\n            this.canViewMoreKeywords(false);\n            this.preview().updateHeight();\n            this.preview().scrollToPreview();\n        },\n\n        /**\n         * Hide all the related keywords\n         */\n        hideAllKeywords: function () {\n            this.keywordsLimit(this.defaultKeywordsLimit);\n            this.canViewMoreKeywords(true);\n        },\n\n        /**\n         * Drop all filters and initiate search on keyword click event\n         */\n        searchByKeyWord: function (keyword) {\n            _.invoke(this.chips().elems(), 'clear');\n            _.invoke(this.chips().elems(), 'apply', keyword);\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/components/grid/column/preview/related.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'uiComponent',\n    'underscore',\n    'jquery'\n], function (Component, _, $) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_AdobeStockImageAdminUi/grid/column/preview/related',\n            filterChipsProvider: 'componentType = filters, ns = ${ $.ns }',\n            filterBookmarksSelector: '.admin__data-grid-action-bookmarks',\n            tabImagesLimit: 4,\n            tabsContainerId: '#adobe-stock-tabs',\n            serieFilterValue: '',\n            modelFilterValue: '',\n            selectedTab: null,\n            loader: false,\n            relatedImages: {\n                series: {},\n                model: {}\n            },\n            statefull: {\n                serieFilterValue: true,\n                modelFilterValue: true\n            },\n            modules: {\n                chips: '${ $.chipsProvider }',\n                filterChips: '${ $.filterChipsProvider }',\n                preview: '${ $.parentName }.preview'\n            },\n            exports: {\n                serieFilterValue: '${ $.provider }:params.filters.serie_id',\n                modelFilterValue: '${ $.provider }:params.filters.model_id'\n            }\n        },\n\n        /**\n         * Initializes related component.\n         */\n        initialize: function () {\n            this._super();\n\n            this.filterChips().updateActive();\n\n            return this;\n        },\n\n        /**\n         * Disable keydown event for related content tabs\n         */\n        disableTabsKeyDownEvent: function () {\n            if ($(this.tabsContainerId + ' li[role=tab]').length === 0) {\n                setTimeout(function () {\n                    this.disableTabsKeyDownEvent();\n                }.bind(this), 100);\n            } else {\n                $(this.tabsContainerId + ' li[role=tab]').off('keydown');\n            }\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'serieFilterValue',\n                    'modelFilterValue',\n                    'selectedTab',\n                    'relatedImages',\n                    'loader'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Check if visible container\n         *\n         * @param {Object} record\n         * @returns boolean\n         */\n        isVisible: function (record) {\n            return this.showSeriesTab(record) && this.showModelTab(record);\n        },\n\n        /**\n         * Get image related image series.s\n         *\n         * @param {Object} record\n         */\n        loadRelatedImages: function (record) {\n            var series = this.getSeries(record),\n                model = this.getModel(record);\n\n            if (series && series.length ||\n                model && model.length\n            ) {\n                return;\n            }\n            $.ajax({\n                type: 'GET',\n                url: this.preview().relatedImagesUrl,\n                dataType: 'json',\n                beforeSend: function () {\n                    this.loader(true);\n                }.bind(this),\n                data: {\n                    'image_id': record.id,\n                    'limit': this.tabImagesLimit\n                }\n            }).done(function (data) {\n                var relatedImages = this.relatedImages();\n\n                this.loader(false);\n                relatedImages.series[record.id] = data.result['same_series'];\n                relatedImages.model[record.id] = data.result['same_model'];\n\n                this.relatedImages(relatedImages);\n                this.preview().updateHeight();\n\n                /* Switch to the model tab if the series tab is hidden */\n                if (relatedImages.series[record.id].length === 0 && relatedImages.model[record.id].length > 0) {\n                    // eslint-disable-next-line jquery-no-input-event-shorthand\n                    $('#adobe-stock-tabs').data().mageTabs.select(1);\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Returns true if the series tab should be show, false otherwise\n         *\n         * @param {Object} record\n         * @returns boolean\n         */\n        showSeriesTab: function (record) {\n            return typeof this.relatedImages().series[record.id] === 'undefined' ||\n                this.relatedImages().series[record.id].length !== 0;\n        },\n\n        /**\n         * Returns true if the model tab should be show, false otherwise\n         *\n         * @param {Object} record\n         * @returns boolean\n         */\n        showModelTab: function (record) {\n            return typeof this.relatedImages().model[record.id] === 'undefined' ||\n                this.relatedImages().model[record.id].length !== 0;\n        },\n\n        /**\n         * Returns series to display under the image\n         *\n         * @param {Object} record\n         * @returns {*[]}\n         */\n        getSeries: function (record) {\n            return this.relatedImages().series[record.id] || [];\n        },\n\n        /**\n         * Check if the number of related series image is greater than 4 or not\n         *\n         * @param {Object} record\n         * @returns boolean\n         */\n        canShowMoreSeriesImages: function (record) {\n            return this.getSeries(record).length >= this.tabImagesLimit;\n        },\n\n        /**\n         * Returns model to display under the image\n         *\n         * @param {Object} record\n         * @returns {*[]}\n         */\n        getModel: function (record) {\n            return this.relatedImages().model[record.id] || [];\n        },\n\n        /**\n         * Check if the number of related model image is greater than 4 or not\n         *\n         * @param {Object} record\n         * @returns boolean\n         */\n        canShowMoreModelImages: function (record) {\n            return this.getModel(record).length >= this.tabImagesLimit;\n        },\n\n        /**\n         * Filter images from serie_id\n         *\n         * @param {Object} record\n         */\n        seeMoreFromSeries: function (record) {\n            if (this.isSerieFilterApplied(record)) {\n                this.scrollToFilter();\n\n                return;\n            }\n            this.serieFilterValue(record.id);\n            this.applyFilter('serie_id', record.id.toString());\n        },\n\n        /**\n         * Filter images from serie_id\n         *\n         * @param {Object} record\n         */\n        seeMoreFromModel: function (record) {\n            if (this.isModelFilterApplied(record)) {\n                this.scrollToFilter();\n\n                return;\n            }\n            this.modelFilterValue(record.id);\n            this.applyFilter('model_id', record.id.toString());\n        },\n\n        /**\n         * Apply series or model id filter and scroll to top of the page\n         *\n         * @param {String} typeId\n         * @param {String} recordId\n         */\n        applyFilter: function (typeId, recordId) {\n            var data = {};\n\n            data[typeId] = recordId;\n\n            this.filterChips().clear();\n            this.filterChips().setData(data, true);\n            this.filterChips().apply();\n\n            this.scrollToFilter();\n        },\n\n        /**\n         * Checks if the filter is applied\n         *\n         * @param {Object} record\n         * @returns {Boolean}\n         */\n        isSerieFilterApplied: function (record) {\n            return this.filterChips().get('applied')['serie_id'] === record.id.toString();\n        },\n\n        /**\n         * Checks if the filter is applied\n         *\n         * @param {Object} record\n         * @returns {Boolean}\n         */\n        isModelFilterApplied: function (record) {\n            return this.filterChips().get('applied')['model_id'] === record.id.toString();\n        },\n\n        /**\n         * Scrolls user window to the filter bookmarks\n         */\n        scrollToFilter: function () {\n            $(this.preview().adobeStockModalSelector + ' ' + this.filterBookmarksSelector).get(0).scrollIntoView({\n                behavior: 'smooth',\n                block: 'center',\n                inline: 'nearest'\n            });\n        },\n\n        /**\n         * Next related image preview\n         *\n         * @param {Object} record\n         */\n        nextRelated: function (record) {\n            var relatedList = this.selectedTab() === 'series' ? this.getSeries(record) : this.getModel(record),\n                nextRelatedIndex = _.findLastIndex(\n                    relatedList,\n                    {\n                        id: this.preview().displayedRecord().id\n                    }\n                ) + 1,\n                nextRelated = relatedList[nextRelatedIndex];\n\n            if (typeof nextRelated === 'undefined') {\n                return;\n            }\n\n            this.switchImagePreviewToRelatedImage(nextRelated);\n        },\n\n        /**\n         * Previous related preview\n         *\n         * @param {Object} record\n         */\n        prevRelated: function (record) {\n            var relatedList = this.selectedTab() === 'series' ? this.getSeries(record) : this.getModel(record),\n                prevRelatedIndex = _.findLastIndex(\n                    relatedList,\n                    {\n                        id: this.preview().displayedRecord().id\n                    }\n                ) - 1,\n                prevRelated = relatedList[prevRelatedIndex];\n\n            if (typeof prevRelated === 'undefined') {\n                return;\n            }\n\n            this.switchImagePreviewToRelatedImage(prevRelated);\n        },\n\n        /**\n         * Get previous button disabled\n         *\n         * @param {Object} record\n         *\n         * @return {Boolean}\n         */\n        cannotViewPrevious: function (record) {\n            var relatedList, prevRelatedIndex, prevRelated;\n\n            if (!this.selectedTab()) {\n                return false;\n            }\n            relatedList = this.selectedTab() === 'series' ? this.getSeries(record) : this.getModel(record);\n            prevRelatedIndex = _.findLastIndex(\n                relatedList,\n                {\n                    id: this.preview().displayedRecord().id\n                }\n            ) - 1;\n            prevRelated = relatedList[prevRelatedIndex];\n\n            return typeof prevRelated === 'undefined';\n        },\n\n        /**\n         * Get next button disabled\n         *\n         * @param {Object} record\n         *\n         * @return {Boolean}\n         */\n        cannotViewNext: function (record) {\n            var relatedList, nextRelatedIndex, nextRelated;\n\n            if (!this.selectedTab()) {\n                return false;\n            }\n            relatedList = this.selectedTab() === 'series' ? this.getSeries(record) : this.getModel(record);\n            nextRelatedIndex = _.findLastIndex(\n                relatedList,\n                {\n                    id: this.preview().displayedRecord().id\n                }\n            ) + 1;\n            nextRelated = relatedList[nextRelatedIndex];\n\n            return typeof nextRelated === 'undefined';\n        },\n\n        /**\n         * Switch image preview to related image\n         *\n         * @param {Object|null} relatedImage\n         */\n        switchImagePreviewToRelatedImage: function (relatedImage) {\n            if (!relatedImage) {\n                this.selectedTab(null);\n\n                return;\n            }\n\n            if (this.preview().displayedRecord().id === relatedImage.id) {\n                return;\n            }\n\n            this.preview().showRelated(relatedImage);\n        },\n\n        /**\n         * Switch image preview to series image\n         *\n         * @param {Object} record\n         */\n        switchImagePreviewToSeriesImage: function (record) {\n            this.selectedTab('series');\n            this.switchImagePreviewToRelatedImage(record);\n        },\n\n        /**\n         * Switch image preview to model image\n         *\n         * @param {Object} record\n         */\n        switchImagePreviewToModelImage: function (record) {\n            this.selectedTab('model');\n            this.switchImagePreviewToRelatedImage(record);\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/confirmation/buyCredits.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm'\n], function ($, confirm) {\n    'use strict';\n\n    return function (buyCreditsUrl, recordTitle, quotaMessage) {\n        var confirmationContent = $.mage.__('License \"' + recordTitle + '\"'),\n            content = '<p>' + confirmationContent + '</p><p><b>' + quotaMessage + '</b></p><br>';\n\n        confirm({\n            title: $.mage.__('License Adobe Stock Images?'),\n            content: content,\n            buttons: [{\n                text: $.mage.__('Cancel'),\n                class: 'action-secondary action-dismiss',\n\n                /**\n                 * Close modal\n                 */\n                click: function () {\n                    this.closeModal();\n                }\n            },{\n                text: $.mage.__('Buy Credits'),\n                class: 'action-primary action-accept',\n\n                /**\n                 * Close modal\n                 */\n                click: function () {\n                    window.open(buyCreditsUrl);\n                    this.closeModal();\n                }\n            }]\n        });\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/confirmation/license.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/prompt',\n    'text!Magento_AdobeStockImageAdminUi/template/modal/adobe-modal-prompt-content.html'\n], function ($, prompt, adobePromptContentTmpl) {\n    'use strict';\n\n    return function (recordTitle, quotaMessage, isPreviewDownloaded, proposedfileName, fileExtension) {\n        var confirmationContent = $.mage.__('License \"' + recordTitle + '\"'),\n            deferred = $.Deferred(),\n            displayFieldName = !isPreviewDownloaded ? '<b>' + $.mage.__('File Name') + '</b>' : '',\n            content = '<p>' + confirmationContent + '</p><p><b>' + quotaMessage + '</b></p><br>' + displayFieldName,\n            data = {\n                'title': $.mage.__('License Adobe Stock Images?'),\n                'content': content,\n                'visible': !isPreviewDownloaded,\n                'actions': {\n                    /**\n                     * Confirm action\n                     *\n                     * @param {String} fileName\n                     */\n                    confirm: function (fileName) {\n                        deferred.resolve(fileName);\n                    }\n                },\n                'buttons': [{\n                    text: $.mage.__('Cancel'),\n                    class: 'action-secondary action-dismiss',\n\n                    /**\n                     * Close modal\n                     */\n                    click: function () {\n                        this.closeModal();\n                        deferred.reject();\n                    }\n                }, {\n                    text: $.mage.__('Confirm'),\n                    class: 'action-primary action-accept'\n                }]\n\n            };\n\n        prompt({\n            title: data.title,\n            content:  data.content,\n            value: proposedfileName,\n            imageExtension: fileExtension,\n            visible: data.visible,\n            promptContentTmpl: adobePromptContentTmpl,\n            modalClass: 'adobe-stock-save-preview-prompt',\n            validation: true,\n            promptField: '[data-role=\"adobe-stock-image-name-field\"]',\n            validationRules: ['required-entry', 'validate-image-name'],\n            attributesForm: {\n                novalidate: 'novalidate',\n                action: '',\n                onkeydown: 'return event.key != \\'Enter\\';'\n            },\n            attributesField: {\n                name: 'name',\n                'data-validate': '{required:true}',\n                maxlength: '128'\n            },\n            context: this,\n            actions: data.actions,\n            buttons: data.buttons\n        });\n\n        if (!data.visible) {\n            $('.adobe-stock-save-preview-prompt').trigger('focus');\n        }\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/confirmation/save.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/prompt',\n    'text!Magento_AdobeStockImageAdminUi/template/modal/adobe-modal-prompt-content.html'\n], function ($, prompt, adobePromptContentTmpl) {\n    'use strict';\n\n    return function (proposedfileName, fileExtension) {\n        var deferred = $.Deferred(),\n            data = {\n                'title': $.mage.__('Save Preview'),\n                'content': $.mage.__('File Name'),\n                'visible': true,\n                'actions': {\n                    /**\n                     * Resolve with the specified file name\n                     *\n                     * @param {String} specifiedFileName\n                     */\n                    confirm: function (specifiedFileName) {\n                        deferred.resolve(specifiedFileName);\n                    }\n                },\n                'buttons': [{\n                    text: $.mage.__('Cancel'),\n                    class: 'action-secondary action-dismiss',\n\n                    /**\n                     * Close modal on button click\n                     */\n                    click: function () {\n                        this.closeModal();\n                        deferred.reject();\n                    }\n                }, {\n                    text: $.mage.__('Confirm'),\n                    class: 'action-primary action-accept'\n                }]\n\n            };\n\n        prompt({\n            title: data.title,\n            content:  data.content,\n            value: proposedfileName,\n            imageExtension: fileExtension,\n            visible: data.visible,\n            promptContentTmpl: adobePromptContentTmpl,\n            modalClass: 'adobe-stock-save-preview-prompt',\n            validation: true,\n            promptField: '[data-role=\"adobe-stock-image-name-field\"]',\n            validationRules: ['required-entry', 'validate-image-name'],\n            attributesForm: {\n                novalidate: 'novalidate',\n                action: '',\n                onkeydown: 'return event.key != \\'Enter\\';'\n            },\n            attributesField: {\n                name: 'name',\n                'data-validate': '{required:true}',\n                maxlength: '128'\n            },\n            context: this,\n            actions: data.actions,\n            buttons: data.buttons\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/confirmation/saveLicensed.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/prompt',\n    'text!Magento_AdobeStockImageAdminUi/template/modal/adobe-modal-prompt-content.html'\n], function ($, prompt, adobePromptContentTmpl) {\n    'use strict';\n\n    return function (proposedfileName, fileExtension) {\n        var deferred = $.Deferred(),\n            data = {\n                'title': $.mage.__('Save'),\n                'content': $.mage.__('File Name'),\n                'visible': true,\n                'actions': {\n                    /**\n                     * Resolve with the specified file name\n                     *\n                     * @param {String} fileName\n                     */\n                    confirm: function (fileName) {\n                        deferred.resolve(fileName);\n                    }\n                },\n                'buttons': [\n                    {\n                        text: $.mage.__('Cancel'),\n                        class: 'action-secondary action-dismiss',\n\n                        /**\n                         * Close modal on button click\n                         */\n                        click: function () {\n                            this.closeModal();\n                            deferred.reject();\n                        }\n                    },\n                    {\n                        text: $.mage.__('Confirm'),\n                        class: 'action-primary action-accept'\n                    }\n                ]\n            };\n\n        prompt({\n            title: data.title,\n            content:  data.content,\n            value: proposedfileName,\n            imageExtension: fileExtension,\n            visible: data.visible,\n            promptContentTmpl: adobePromptContentTmpl,\n            modalClass: 'adobe-stock-save-preview-prompt',\n            validation: true,\n            promptField: '[data-role=\"adobe-stock-image-name-field\"]',\n            validationRules: ['required-entry', 'validate-image-name'],\n            attributesForm: {\n                novalidate: 'novalidate',\n                action: '',\n                onkeydown: 'return event.key != \\'Enter\\';'\n            },\n            attributesField: {\n                name: 'name',\n                'data-validate': '{required:true}',\n                maxlength: '128'\n            },\n            context: this,\n            actions: data.actions,\n            buttons: data.buttons\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_AdobeStockImageAdminUi/js/mediaGallery/grid/columns/licenseImage.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_MediaGalleryUi/js/grid/columns/image'\n], function (Image) {\n    'use strict';\n\n    return Image.extend({\n        defaults: {\n            viewConfig: [\n                {\n                    component: 'Magento_AdobeStockImageAdminUi/js/mediaGallery/grid/columns/image/licenseActions',\n                    name: '${ $.name }_actions',\n                    imageModelName: '${ $.name }',\n                    imageDetailsUrl: '${ $.imageDetailsurl }',\n                    imageComponent: '${ $.imageComponent }'\n                }\n            ]\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/mediaGallery/grid/columns/image/licenseActions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_MediaGalleryUi/js/grid/columns/image/actions',\n    'Magento_MediaGalleryUi/js/action/getDetails',\n    'mage/translate'\n], function ($, _, Action, getDetails) {\n    'use strict';\n\n    return Action.extend({\n        defaults: {\n            template: 'Magento_AdobeStockImageAdminUi/mediaGallery/grid/columns/image/licenseActions',\n            licenseAction: {\n                name: 'license',\n                title: $.mage.__('License'),\n                handler: 'licenseImageAction'\n            },\n            modules: {\n                image: '${ $.imageComponent }'\n            }\n        },\n\n        /**\n         * Initialize the component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super();\n            this.actionsList.push(this.licenseAction);\n\n            return this;\n        },\n\n        /**\n         * Init observable variables\n         *\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'visible'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * License image\n         *\n         * @param {Object} record\n         */\n        licenseImageAction: function (record) {\n            this.getImageRecord(record.id);\n        },\n\n        /**\n         * Check if image licensed\n         *\n         * @param {Object} record\n         * @param {Object} name\n         */\n        isVisible: function (record, name) {\n            if (name === this.licenseAction.name) {\n                if (_.isUndefined(record.overlay) || record.overlay === '') {\n                    return false;\n                }\n\n                return true;\n            }\n\n            return true;\n        },\n\n        /**\n         * Get image record and start license process\n         *\n         * @param {Number} imageId\n         */\n        getImageRecord: function (imageId) {\n            getDetails(this.imageDetailsUrl, [imageId]).then(function (imageDetails) {\n                var id = imageDetails[imageId]['adobe_stock'][0].value;\n\n                this.image().actions().licenseProcess(\n                    id,\n                    imageDetails[imageId].title,\n                    imageDetails[imageId].path,\n                    imageDetails[imageId]['content_type'],\n                    true\n                ).then(function () {\n                    this.image().actions().login().getUserQuota();\n                    this.imageModel().reloadGrid();\n                    this.imageModel().addMessage('success', $.mage.__('The image has been licensed.'));\n                }.bind(this)).fail(function (error) {\n                    if (error) {\n                        this.imageModel().addMessage('error', error);\n                    }\n                }.bind(this));\n            }.bind(this)).fail(function (message) {\n                this.imageModel().addMessage('error', message);\n            }.bind(this));\n        }\n    });\n});\n","Magento_AdobeStockImageAdminUi/js/validation/validate-image-name.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/translate',\n    'jquery/validate'\n], function ($, $t) {\n    'use strict';\n\n    $.validator.addMethod(\n        'validate-image-name', function (value) {\n            return /^[a-zA-Z0-9\\-\\_]+$/i.test(value);\n\n        }, $t('Please name the file using only letters, numbers, underscores and dashes'));\n});\n","Magento_AdvancedSearch/js/testconnection.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui'\n], function ($, alert) {\n    'use strict';\n\n    $.widget('mage.testConnection', {\n        options: {\n            url: '',\n            elementId: '',\n            successText: '',\n            failedText: '',\n            fieldMapping: ''\n        },\n\n        /**\n         * Bind handlers to events\n         */\n        _create: function () {\n            this._on({\n                'click': $.proxy(this._connect, this)\n            });\n        },\n\n        /**\n         * Method triggers an AJAX request to check search engine connection\n         * @private\n         */\n        _connect: function () {\n            var result = this.options.failedText,\n                element =  $('#' + this.options.elementId),\n                self = this,\n                params = {},\n                msg = '',\n                fieldToCheck = this.options.fieldToCheck || 'success';\n\n            element.removeClass('success').addClass('fail');\n            $.each(JSON.parse(this.options.fieldMapping), function (key, el) {\n                params[key] = $('#' + el).val();\n            });\n            $.ajax({\n                url: this.options.url,\n                showLoader: true,\n                data: params,\n                headers: this.options.headers || {}\n            }).done(function (response) {\n                if (response[fieldToCheck]) {\n                    element.removeClass('fail').addClass('success');\n                    result = self.options.successText;\n                } else {\n                    msg = response.errorMessage;\n\n                    if (msg) {\n                        alert({\n                            content: msg\n                        });\n                    }\n                }\n            }).always(function () {\n                $('#' + self.options.elementId + '_result').text(result);\n            });\n        }\n    });\n\n    return $.mage.testConnection;\n});\n","Magento_AsynchronousOperations/js/insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-form',\n    'uiRegistry'\n], function (Insert, registry) {\n    'use strict';\n\n    return Insert.extend({\n        defaults: {\n            modalProvider: '${ $.parentName }',\n            titlePrefix: '',\n            imports: {\n                changeModalTitle: '${ $.modalProvider }:state'\n            },\n            listens: {\n                responseData: 'afterRetry'\n            },\n            modules: {\n                modal: '${ $.modalProvider }',\n                notificationListing: '${ $.columnsProvider }'\n            }\n        },\n\n        /** @inheritdoc */\n        initConfig: function () {\n            var modalTitleProvider;\n\n            this._super();\n            modalTitleProvider = this.modalTitleProvider.split(':');\n            this.modalTitleTarget = modalTitleProvider[0];\n            this.modalTitlePath = modalTitleProvider[1];\n        },\n\n        /**\n         * Change modal title.\n         *\n         * @param {Boolean} change\n         */\n        changeModalTitle: function (change) {\n            if (change) {\n                registry.get(this.modalTitleTarget, function (target) {\n                    this.modal().setTitle(this.titlePrefix + target.get(this.modalTitlePath));\n                }.bind(this));\n            } else {\n                this.modal().setTitle('');\n            }\n        },\n\n        /**\n         * Action after retry operation.\n         *\n         * @param {Object} data\n         */\n        afterRetry: function (data) {\n            if (!data.error) {\n                this.modal().closeModal();\n                this.notificationListing().reload();\n            }\n        }\n    });\n});\n","Magento_AsynchronousOperations/js/form/error.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        /** @inheritdoc */\n        onUpdate: function () {\n            this.bubble('update', this.hasChanged());\n        }\n    });\n});\n","Magento_AsynchronousOperations/js/grid/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_AdminNotification/js/grid/listing',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate',\n    'underscore',\n    'jquery'\n], function (Listing, uiAlert, $t, _, $) {\n    'use strict';\n\n    return Listing.extend({\n        defaults: {\n            isAllowed: true,\n            ajaxSettings: {\n                method: 'POST',\n                data: {},\n                url: '${ $.dismissUrl }'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            _.bindAll(this, 'reload', 'onError');\n\n            return this._super();\n        },\n\n        /**\n         * Dismiss all items.\n         */\n        dismissAll: function () {\n            var toDismiss = [];\n\n            _.each(this.rows, function (row) {\n                if (row.dismiss) {\n                    toDismiss.push(row.uuid);\n                }\n            });\n            toDismiss.length && this.dismiss(toDismiss);\n        },\n\n        /**\n         * Dismiss action.\n         *\n         * @param {Array} items\n         */\n        dismiss: function (items) {\n            var config = _.extend({}, this.ajaxSettings);\n\n            config.data.uuid = items;\n            this.showLoader();\n\n            $.ajax(config)\n                .done(this.reload)\n                .fail(this.onError);\n        },\n\n        /**\n         * Success callback for dismiss request.\n         */\n        reload: function () {\n            this.source.reload({\n                refresh: true\n            });\n        },\n\n        /**\n         * Error callback for dismiss request.\n         *\n         * @param {Object} xhr\n         */\n        onError: function (xhr) {\n            this.hideLoader();\n\n            if (xhr.statusText === 'abort') {\n                return;\n            }\n\n            uiAlert({\n                content: $t('Something went wrong.')\n            });\n        }\n    });\n});\n","Magento_Backend/js/delete-with-confirm.js":"/**\n *\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Backend/js/validate-store'\n], function ($, validateStore) {\n    'use strict';\n\n    $.widget('mage.deleteWithConfirm', validateStore, {});\n\n    return $.mage.deleteWithConfirm;\n});\n","Magento_Backend/js/media-uploader.js":"/**\n *\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\n\n/*global byteConvert*/\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/form/element/file-uploader',\n    'mage/translate',\n    'jquery/file-uploader'\n], function ($, mageTemplate, alert, FileUploader) {\n    'use strict';\n\n    var fileUploader = new FileUploader({\n        dataScope: '',\n        isMultipleFiles: true\n    });\n\n    fileUploader.initUploader();\n\n    $.widget('mage.mediaUploader', {\n\n        /**\n         *\n         * @private\n         */\n        _create: function () {\n            var self = this,\n                progressTmpl = mageTemplate('[data-template=\"uploader\"]'),\n                isResizeEnabled = this.options.isResizeEnabled,\n                resizeConfiguration = {\n                    action: 'resizeImage',\n                    maxWidth: this.options.maxWidth,\n                    maxHeight: this.options.maxHeight\n                };\n\n            if (!isResizeEnabled) {\n                resizeConfiguration = {\n                    action: 'resizeImage'\n                };\n            }\n\n            this.element.find('input[type=file]').fileupload({\n                dataType: 'json',\n                formData: {\n                    'form_key': window.FORM_KEY\n                },\n                dropZone: '[data-tab-panel=image-management]',\n                sequentialUploads: true,\n                acceptFileTypes: /(\\.|\\/)(gif|jpe?g|png)$/i,\n                maxFileSize: this.options.maxFileSize,\n\n                /**\n                 * @param {Object} e\n                 * @param {Object} data\n                 */\n                add: function (e, data) {\n                    var fileSize,\n                        tmpl;\n\n                    $.each(data.files, function (index, file) {\n                        fileSize = typeof file.size == 'undefined' ?\n                            $.mage.__('We could not detect a size.') :\n                            byteConvert(file.size);\n\n                        data.fileId = Math.random().toString(33).substr(2, 18);\n\n                        tmpl = progressTmpl({\n                            data: {\n                                name: file.name,\n                                size: fileSize,\n                                id: data.fileId\n                            }\n                        });\n\n                        $(tmpl).appendTo(self.element);\n                    });\n\n                    $(this).fileupload('process', data).done(function () {\n                        data.submit();\n                    });\n                },\n\n                /**\n                 * @param {Object} e\n                 * @param {Object} data\n                 */\n                done: function (e, data) {\n                    if (data.result && !data.result.error) {\n                        self.element.trigger('addItem', data.result);\n                    } else {\n                        fileUploader.aggregateError(data.files[0].name, data.result.error);\n                    }\n\n                    self.element.find('#' + data.fileId).remove();\n                },\n\n                /**\n                 * @param {Object} e\n                 * @param {Object} data\n                 */\n                progress: function (e, data) {\n                    var progress = parseInt(data.loaded / data.total * 100, 10),\n                        progressSelector = '#' + data.fileId + ' .progressbar-container .progressbar';\n\n                    self.element.find(progressSelector).css('width', progress + '%');\n                },\n\n                /**\n                 * @param {Object} e\n                 * @param {Object} data\n                 */\n                fail: function (e, data) {\n                    var progressSelector = '#' + data.fileId;\n\n                    self.element.find(progressSelector).removeClass('upload-progress').addClass('upload-failure')\n                        .delay(2000)\n                        .hide('highlight')\n                        .remove();\n                },\n\n                stop: fileUploader.uploaderConfig.stop\n            });\n\n            this.element.find('input[type=file]').fileupload('option', {\n                processQueue: [{\n                    action: 'loadImage',\n                    fileTypes: /^image\\/(gif|jpeg|png)$/\n                },\n                resizeConfiguration,\n                {\n                    action: 'saveImage'\n                }]\n            });\n        }\n    });\n\n    return $.mage.mediaUploader;\n});\n","Magento_Backend/js/save-with-confirm.js":"/**\n *\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Backend/js/validate-store'\n], function ($, validateStore) {\n    'use strict';\n\n    $.widget('mage.saveWithConfirm', validateStore, {\n\n        /**\n         * Check is it need to show confirmation popup\n         *\n         * @returns {Boolean}\n         */\n        _needConfirm: function () {\n\n            var storeData = this.settings.storeData,\n\n            /* edit store view*/\n                storeViewEdit = $('[name=\"store[store_id]\"]').length,\n                groupId = $('[name=\"store[group_id]\"]').val(),\n                isNewStoreView = !$('[name=\"store[store_id]\"]').val(),\n\n            /* edit store */\n                storeEdit = $('[name=\"group[group_id]\"]').length,\n                storeId = $('[name=\"group[group_id]\"]').val(),\n                rootCategoryId = $('[name=\"group[root_category_id]\"]').val(),\n                defaultStoreView = $('[name=\"group[default_store_id]\"]').val(),\n\n            /* edit website */\n                websiteEdit = $('[name=\"website[website_id]\"]').length,\n                defaultStore = $('[name=\"website[default_group_id]\"]').val(),\n\n            /* conditions */\n                storeViewUpdated = storeViewEdit && (isNewStoreView || storeData['group_id'] !== groupId),\n                storeUpdated = storeEdit && storeId &&\n                    (rootCategoryId !== null  && storeData['root_category_id'] !== rootCategoryId ||\n                    defaultStoreView !== null && storeData['default_store_id'] !== defaultStoreView),\n                websiteUpdated = websiteEdit && defaultStore !== null && storeData['default_group_id'] !== defaultStore;\n\n            return storeViewUpdated || storeUpdated || websiteUpdated;\n        }\n    });\n\n    return $.mage.saveWithConfirm;\n});\n","Magento_Backend/js/store-switcher.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    /**\n     * @param {Object} storeSwitchConfig\n     */\n    return function (storeSwitchConfig) {\n        var scopeSwitcherHandler;\n\n        (function () {\n            var storesList = $('[data-role=stores-list]');\n\n            storesList.on('click', '[data-value]', function (event) {\n                var val = $(event.target).data('value'),\n                    role = $(event.target).data('role'),\n                    switcher = $('[data-role=' + role + ']');\n\n                event.preventDefault();\n\n                if (!switcher.val() || val !== switcher.val()) {\n\n                    /* Set the value & trigger event */\n                    switcher.val(val).trigger('change');\n                }\n            });\n        })($);\n\n        /**\n         * Switch store scope\n         *\n         * @param {Object} obj\n         * @return void\n         */\n        function switchScope(obj) {\n            var switcher = $(obj),\n                scopeId = switcher.val(),\n                scopeParams = '',\n                switcherParams = {};\n\n            if (scopeId) {\n                scopeParams = switcher.data('param') + '/' + scopeId + '/';\n            }\n\n            if (obj.switchParams) {\n                scopeParams += obj.switchParams;\n            }\n\n            /**\n             * Reload function for switcher\n             */\n            function reload() {\n                var url;\n\n                if (!storeSwitchConfig.isUsingIframe) {\n\n                    if (storeSwitchConfig.switchUrl && storeSwitchConfig.switchUrl.length > 0) {\n                        url = storeSwitchConfig.switchUrl + scopeParams;\n\n                        /* eslint-disable no-undef */\n                        setLocation(url);\n                    }\n\n                } else {\n                    $('#preview_selected_store').val(scopeId);\n                    $('#preview_form').trigger('submit');\n\n                    $('.store-switcher .dropdown-menu li a').each(function () {\n                        var $this = $(this);\n\n                        if ($this.data('role') === 'store-view-id' && $this.data('value') === scopeId) {\n                            $('#store-change-button').html($this.text());\n                        }\n                    });\n\n                    $('#store-change-button').trigger('click');\n                }\n            }\n\n            if (typeof scopeSwitcherHandler !== 'undefined') {\n                switcherParams = {\n                    scopeId: scopeId,\n                    scopeParams: scopeParams,\n                    useConfirm: storeSwitchConfig.useConfirm\n                };\n\n                scopeSwitcherHandler(switcherParams);\n            } else if (storeSwitchConfig.useConfirm) {\n                require([\n                    'Magento_Ui/js/modal/confirm',\n                    'mage/translate'\n                ], function (confirm, $t) {\n                    confirm({\n                        content: $t('Please confirm scope switching. All data that hasn\\'t been saved will be lost.'),\n                        actions: {\n\n                            /**\n                             * Confirm action\n                             */\n                            confirm: function () {\n                                reload();\n                            },\n\n                            /**\n                             * Cancel action\n                             */\n                            cancel: function () {\n                                obj.value = storeSwitchConfig.storeId ? storeSwitchConfig.storeId : '';\n                            }\n                        }\n                    });\n                });\n            } else {\n                reload();\n            }\n        }\n\n        window.scopeSwitcherHandler = scopeSwitcherHandler;\n        window.switchScope = switchScope;\n    };\n});\n","Magento_Backend/js/translate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable strict */\ndefine([\n    'jquery',\n    'mage/mage'\n], function ($) {\n    $.extend(true, $, {\n        mage: {\n            translate: (function () {\n                /**\n                 * Key-value translations storage\n                 * @type {Object}\n                 * @private\n                 */\n                var _data = {};\n\n                /**\n                 * Add new translation (two string parameters) or several translations (object)\n                 */\n                this.add = function () {\n                    if (arguments.length > 1) {\n                        _data[arguments[0]] = arguments[1];\n                    } else if (typeof arguments[0] === 'object') {\n                        $.extend(_data, arguments[0]);\n                    }\n                };\n\n                /**\n                 * Make a translation with parsing (to handle case when _data represents tuple)\n                 * @param {String} text\n                 * @return {String}\n                 */\n                this.translate = function (text) {\n                    return typeof _data[text] === 'string' ? _data[text] : text;\n                };\n\n                return this;\n            }())\n        }\n    });\n    $.mage.__ = $.proxy($.mage.translate.translate, $.mage.translate);\n\n    return $.mage.__;\n});\n","Magento_Backend/js/validate-store.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'jquery/ui',\n    'mage/dataPost',\n    'mage/backend/validation',\n    'Magento_Ui/js/modal/confirm'\n], function ($, jqueryUi, dataPost, validation, modalConfirm) {\n    'use strict';\n\n    $.widget('mage.storeValidation', {\n\n        /**\n         * Validation creation\n         * @protected\n         */\n        _create: function () {\n            var form = this.element[0],\n                validator = $.data(form, 'validator');\n\n            if (validator && validator.settings) {\n                validator.settings.submitHandler = this._saveHandler;\n                validator.settings.confirmCallback = this._needConfirm;\n                $.extend(validator.settings, this.options);\n                $.data(form, 'validator', validator);\n            }\n        },\n\n        /**\n         * Check is it need to show confirmation popup\n         *\n         * @returns {Boolean}\n         */\n        _needConfirm: function () {\n            return true;\n        },\n\n        /**\n         * Save form with confirmation if needed\n         *\n         * @param {Object} form\n         * @private\n         */\n        _saveHandler: function (form) {\n            var formData = {},\n                requestData = {},\n                options = $.data(form, 'validator').settings;\n\n            if ($(form).validation('isValid')) {\n                $.each($(form).serializeArray(), function () {\n                    formData[this.name] = this.value || '';\n                });\n                requestData = {\n                    action: $(form).attr('action'),\n                    data: formData\n                };\n\n                if (options.confirmCallback.call(this)) {\n                    modalConfirm({\n                        title: $.mage.__('Warning message'),\n                        content: $.mage.__('This operation can take a long time'),\n                        actions: {\n                            /**\n                             * 'Confirm' action handler.\n                             */\n                            confirm: function () {\n                                $('body').trigger('processStart');\n                                dataPost().postData(requestData);\n                            }\n                        }\n                    });\n                } else {\n                    dataPost().postData(requestData);\n                }\n            }\n        }\n    });\n\n    return $.mage.storeValidation;\n});\n","Magento_Backend/js/bootstrap/editor.js":"/**\n *\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'Magento_Variable/variables',\n    'mage/adminhtml/browser'\n]);\n","Magento_Backend/js/dashboard/chart.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*global FORM_KEY*/\ndefine([\n    'jquery',\n    'chartJs',\n    'jquery-ui-modules/widget',\n    'chartjs/chartjs-adapter-moment',\n    'moment'\n], function ($, Chart) {\n    'use strict';\n\n    $.widget('mage.dashboardChart', {\n        options: {\n            updateUrl: '',\n            periodSelect: null,\n            periodUnits: [],\n            precision: 0,\n            type: ''\n        },\n        chart: null,\n\n        /**\n         * @private\n         */\n        _create: function () {\n            this.createChart();\n\n            if (this.options.periodSelect) {\n                $(document).on('change', this.options.periodSelect, this.refreshChartData.bind(this));\n\n                this.period = $(this.options.periodSelect).val();\n            }\n        },\n\n        /**\n         * @public\n         */\n        createChart: function () {\n            this.chart = new Chart(this.element, this.getChartSettings());\n            this.refreshChartData();\n        },\n\n        /**\n         * @public\n         */\n        refreshChartData: function () {\n            var data = {\n                'form_key': FORM_KEY\n            };\n\n            if (this.options.periodSelect) {\n                this.period = data.period = $(this.options.periodSelect).val();\n            }\n\n            $.ajax({\n                url: this.options.updateUrl,\n                showLoader: true,\n                data: data,\n                dataType: 'json',\n                type: 'POST',\n                success: this.updateChart.bind(this)\n            });\n        },\n\n        /**\n         * @public\n         * @param {Object} response\n         */\n        updateChart: function (response) {\n            $(this.element).toggle(response.data.length > 0);\n            $(this.element).next('.dashboard-diagram-nodata').toggle(response.data.length === 0);\n\n            this.chart.options.scales.xAxis.time.unit = this.options.periodUnits[this.period] ?\n                this.options.periodUnits[this.period] : 'hour';\n            this.chart.data.datasets[0].data = response.data;\n            this.chart.data.datasets[0].label = response.label;\n            this.chart.update();\n        },\n\n        /**\n         * @returns {Object} chart object configuration\n         */\n        getChartSettings: function () {\n            return {\n                type: 'bar',\n                data: {\n                    datasets: [{\n                        yAxisID: 'yAxis',\n                        xAxisID: 'xAxis',\n                        data: [],\n                        backgroundColor: '#f1d4b3',\n                        borderColor: '#eb5202',\n                        borderWidth: 1\n                    }]\n                },\n                options: {\n                    legend: {\n                        onClick: this.handleChartLegendClick,\n                        position: 'bottom'\n                    },\n                    scales: {\n                        xAxis: {\n                            offset: true,\n                            type: 'time',\n                            ticks: {\n                                source: 'data'\n                            }\n                        },\n                        yAxis: {\n                            ticks: {\n                                beginAtZero: true,\n                                precision: this.options.precision\n                            }\n                        }\n                    }\n                }\n            };\n        },\n\n        /**\n         * @public\n         */\n        handleChartLegendClick: function () {\n            // don't hide dataset on clicking into legend item\n        }\n    });\n\n    return $.mage.dashboardChart;\n});\n","Magento_Backend/js/dashboard/totals.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*global FORM_KEY*/\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.dashboardTotals', {\n        options: {\n            updateUrl: '',\n            periodSelect: null\n        },\n        elementId: null,\n\n        /**\n         * @private\n         */\n        _create: function () {\n            this.elementId = $(this.element).attr('id');\n\n            if (this.options.periodSelect) {\n                $(document).on('change', this.options.periodSelect, $.proxy(function () {\n                    this.refreshTotals();\n                }, this));\n            }\n        },\n\n        /**\n         * @public\n         */\n        refreshTotals: function () {\n            var periodParam = '';\n\n            if (this.options.periodSelect && $(this.options.periodSelect).val()) {\n                periodParam = 'period/' + $(this.options.periodSelect).val() + '/';\n            }\n\n            $.ajax({\n                url: this.options.updateUrl + periodParam,\n                showLoader: true,\n                data: {\n                    'form_key': FORM_KEY\n                },\n                dataType: 'html',\n                type: 'POST',\n                success: $.proxy(function (response) {\n                    $('#' + this.elementId).replaceWith(response);\n                }, this)\n            });\n        }\n    });\n\n    return $.mage.dashboardTotals;\n});\n","Magento_Bundle/js/bundle-product.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*global FORM_KEY*/\n/*global bSelection*/\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/js/product/weight-handler',\n    'Magento_Ui/js/modal/modal',\n    'jquery/ui',\n    'mage/translate',\n    'Magento_Theme/js/sortable',\n    'prototype'\n], function ($, weightHandler) {\n    'use strict';\n\n    $.widget('mage.bundleProduct', {\n        /** @inheritdoc */\n        _create: function () {\n            this._initOptionBoxes()\n                ._initSortableSelections()\n                ._bindCheckboxHandlers()\n                ._initCheckboxState()\n                ._bindAddSelectionDialog()\n                ._hideProductTypeSwitcher();\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _initOptionBoxes: function () {\n            var syncOptionTitle;\n\n            this.element.sortable({\n                axis: 'y',\n                handle: '[data-role=draggable-handle]',\n                items: '.option-box',\n                update: this._updateOptionBoxPositions,\n                tolerance: 'pointer'\n            });\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            syncOptionTitle = function (event) {\n                var originalValue = $(event.target).attr('data-original-value'),\n                    currentValue = $(event.target).val(),\n                    optionBoxTitle = $('.title > span', $(event.target).closest('.option-box')),\n                    newOptionTitle = $.mage.__('New Option');\n\n                optionBoxTitle.text(currentValue === '' && !originalValue.length ? newOptionTitle : currentValue);\n            };\n            this._on({\n                'change .field-option-title input[name$=\"[title]\"]': syncOptionTitle,\n                'keyup .field-option-title input[name$=\"[title]\"]': syncOptionTitle,\n                'paste .field-option-title input[name$=\"[title]\"]': syncOptionTitle\n            });\n\n            return this;\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _initSortableSelections: function () {\n            this.element.find('.option-box .form-list tbody').sortable({\n                axis: 'y',\n                handle: '[data-role=draggable-handle]',\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {jQuery} ui\n                 * @return {jQuery}\n                 */\n                helper: function (event, ui) {\n                    ui.children().each(function () {\n                        $(this).width($(this).width());\n                    });\n\n                    return ui;\n                },\n                update: this._updateSelectionsPositions,\n                tolerance: 'pointer'\n            });\n\n            return this;\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _initCheckboxState: function () {\n            this.element.find('.is-required').each(function () {\n                $(this).prop('checked', $(this).closest('.option-box').find('[name$=\"[required]\"]').val() > 0);\n            });\n\n            this.element.find('.is-user-defined-qty').each(function () {\n                $(this).prop('checked', $(this).closest('.qty-box').find('.select').val() > 0);\n            });\n\n            return this;\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _bindAddSelectionDialog: function () {\n            var widget = this;\n\n            this._on({\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'click .add-selection': function (event) {\n                    var $optionBox = $(event.target).closest('.option-box'),\n                        $selectionGrid = $optionBox.find('.selection-search').clone(),\n                        optionIndex = $optionBox.attr('id').replace('bundle_option_', ''),\n                        productIds = [],\n                        productSkus = [],\n                        selectedProductList = {};\n\n                    $optionBox.find('[name$=\"[product_id]\"]').each(function () {\n                        if (!$(this).closest('tr').find('[name$=\"[delete]\"]').val()) {\n                            productIds.push($(this).val());\n                            productSkus.push($(this).closest('tr').find('.col-sku').text());\n                        }\n                    });\n\n                    bSelection.gridSelection.set(optionIndex, $H({}));\n                    bSelection.gridRemoval = $H({});\n                    bSelection.gridSelectedProductSkus = productSkus;\n\n                    $selectionGrid.on('contentUpdated', bSelection.gridUpdateCallback);\n                    $selectionGrid.on('change', '.col-id input', function () {\n                        var tr = $(this).closest('tr');\n\n                        if ($(this).is(':checked')) {\n                            selectedProductList[$(this).val()] = {\n                                name: tr.find('.col-name').html().trim(),\n                                sku: tr.find('.col-sku').html().trim(),\n                                'product_id': $(this).val(),\n                                'option_id': $('bundle_selection_id_' + optionIndex).val(),\n                                'selection_price_value': 0,\n                                'selection_qty': 1\n                            };\n                        } else {\n                            delete selectedProductList[$(this).val()];\n                        }\n                    });\n\n                    $selectionGrid.modal({\n                        title: $optionBox.find('input[name$=\"[title]\"]').val() === '' ?\n                            $.mage.__('Add Products to New Option') :\n                            $.mage.__('Add Products to Option \"%1\"').replace(\n                                '%1',\n                                $('<div>').text($optionBox.find('input[name$=\"[title]\"]').val()).html()\n                            ),\n                        modalClass: 'bundle',\n                        type: 'slide',\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} modalWindow\n                         */\n                        closed: function (e, modalWindow) {\n                            modalWindow.modal.remove();\n                        },\n                        buttons: [{\n                            text: $.mage.__('Add Selected Products'),\n                            'class': 'action-primary action-add',\n\n                            /** Click action. */\n                            click: function () {\n                                $.each(selectedProductList, function () {\n                                    window.bSelection.addRow(optionIndex, this);\n                                });\n                                bSelection.gridRemoval.each(function (pair) {\n                                    $optionBox.find('.col-sku').filter(function () {\n                                        let text = $(this).text();\n\n                                        return text.trim() === pair.key; // find row by SKU\n                                    }).closest('tr').find('button.delete').trigger('click');\n                                });\n                                widget.refreshSortableElements();\n                                widget._updateSelectionsPositions.apply(widget.element);\n                                $selectionGrid.modal('closeModal');\n                            }\n                        }]\n                    });\n                    $.ajax({\n                        url: bSelection.selectionSearchUrl,\n                        dataType: 'html',\n                        data: {\n                            index: optionIndex,\n                            products: productIds,\n                            'selected_products': productIds,\n                            'form_key': FORM_KEY\n                        },\n\n                        /**\n                         * @param {*} data\n                         */\n                        success: function (data) {\n                            $selectionGrid.html(data).modal('openModal');\n                        },\n                        context: $('body'),\n                        showLoader: true\n                    });\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * @private\n         */\n        _hideProductTypeSwitcher: function () {\n            weightHandler.hideWeightSwitcher();\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _bindCheckboxHandlers: function () {\n            this._on({\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'change .is-required': function (event) {\n                    var $this = $(event.target);\n\n                    $this.closest('.option-box').find('[name$=\"[required]\"]').val($this.is(':checked') ? 1 : 0);\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'change .is-user-defined-qty': function (event) {\n                    var $this = $(event.target);\n\n                    $this.closest('.qty-box').find('.select').val($this.is(':checked') ? 1 : 0);\n                }\n            });\n\n            return this;\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _updateOptionBoxPositions: function () {\n            $(this).find('[name^=bundle_options][name$=\"[position]\"]').each(function (index) {\n                $(this).val(index);\n            });\n\n            return this;\n        },\n\n        /**\n         * @return {Object}\n         * @private\n         */\n        _updateSelectionsPositions: function () {\n            $(this).find('[name^=bundle_selections][name$=\"[position]\"]').each(function (index) {\n                $(this).val(index);\n            });\n\n            return this;\n        },\n\n        /**\n         *\n         * @return {Object}\n         */\n        refreshSortableElements: function () {\n            this.element.sortable('refresh');\n            this._updateOptionBoxPositions.apply(this.element);\n            this._initSortableSelections();\n            this._initCheckboxState();\n\n            return this;\n        }\n    });\n\n});\n","Magento_Bundle/js/bundle-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Catalog/catalog/type-events',\n    'Magento_Catalog/js/product/weight-handler'\n], function ($, productType, weight) {\n    'use strict';\n\n    return {\n\n        /**\n         * Constructor component\n         */\n        'Magento_Bundle/js/bundle-type-handler': function () {\n            this.bindAll();\n            this._initType();\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            $(document).on('changeTypeProduct', this._initType.bind(this));\n        },\n\n        /**\n         * Init type\n         * @private\n         */\n        _initType: function () {\n            if (\n                productType.type.init === 'bundle' &&\n                productType.type.current !== 'bundle' &&\n                !weight.isLocked()\n            ) {\n                weight.switchWeight();\n            }\n        }\n    };\n});\n","Magento_Bundle/js/price-bundle.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'priceUtils',\n    'priceBox'\n], function ($, _, mageTemplate, utils) {\n    'use strict';\n\n    var globalOptions = {\n        optionConfig: null,\n        productBundleSelector: 'input.bundle.option, select.bundle.option, textarea.bundle.option',\n        qtyFieldSelector: 'input.qty',\n        priceBoxSelector: '.price-box',\n        optionHandlers: {},\n        optionTemplate: '<%- data.label %>' +\n            '<% if (data.finalPrice.value) { %>' +\n            ' +<%- data.finalPrice.formatted %>' +\n            '<% } %>',\n        controlContainer: 'dd', // should be eliminated\n        priceFormat: {},\n        isFixedPrice: false,\n        optionTierPricesBlocksSelector: '#option-tier-prices-{1} [data-role=\"selection-tier-prices\"]',\n        isOptionsInitialized: false\n    };\n\n    $.widget('mage.priceBundle', {\n        options: globalOptions,\n\n        /**\n         * @private\n         */\n        _init: function initPriceBundle() {\n            var form = this.element,\n                options = $(this.options.productBundleSelector, form);\n\n            options.trigger('change');\n        },\n\n        /**\n         * @private\n         */\n        _create: function createPriceBundle() {\n            var form = this.element,\n                options = $(this.options.productBundleSelector, form),\n                priceBox = $(this.options.priceBoxSelector, form),\n                qty = $(this.options.qtyFieldSelector, form);\n\n            this._updatePriceBox();\n            priceBox.on('price-box-initialized', this._updatePriceBox.bind(this));\n            options.on('change', this._onBundleOptionChanged.bind(this));\n            qty.on('change', this._onQtyFieldChanged.bind(this));\n        },\n\n        /**\n         * Update price box config with bundle option prices\n         * @private\n         */\n        _updatePriceBox: function () {\n            var form = this.element,\n                options = $(this.options.productBundleSelector, form),\n                priceBox = $(this.options.priceBoxSelector, form);\n\n            if (!this.options.isOptionsInitialized) {\n                if (priceBox.data('magePriceBox') &&\n                    priceBox.priceBox('option') &&\n                    priceBox.priceBox('option').priceConfig\n                ) {\n                    if (priceBox.priceBox('option').priceConfig.optionTemplate) { //eslint-disable-line max-depth\n                        this._setOption('optionTemplate', priceBox.priceBox('option').priceConfig.optionTemplate);\n                    }\n                    this._setOption('priceFormat', priceBox.priceBox('option').priceConfig.priceFormat);\n                    priceBox.priceBox('setDefault', this.options.optionConfig.prices);\n                    this.options.isOptionsInitialized = true;\n                }\n                this._applyOptionNodeFix(options);\n            }\n\n            return this;\n        },\n\n        /**\n         * Handle change on bundle option inputs\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _onBundleOptionChanged: function onBundleOptionChanged(event) {\n            var changes,\n                bundleOption = $(event.target),\n                priceBox = $(this.options.priceBoxSelector, this.element),\n                handler = this.options.optionHandlers[bundleOption.data('role')];\n\n            bundleOption.data('optionContainer', bundleOption.closest(this.options.controlContainer));\n            bundleOption.data('qtyField', bundleOption.data('optionContainer').find(this.options.qtyFieldSelector));\n\n            if (handler && handler instanceof Function) {\n                changes = handler(bundleOption, this.options.optionConfig, this);\n            } else {\n                changes = defaultGetOptionValue(bundleOption, this.options.optionConfig);//eslint-disable-line\n            }\n\n            // eslint-disable-next-line no-use-before-define\n            if (isValidQty(bundleOption)) {\n                if (changes) {\n                    priceBox.trigger('updatePrice', changes);\n                }\n\n                this._displayTierPriceBlock(bundleOption);\n                this.updateProductSummary();\n            }\n        },\n\n        /**\n         * Handle change on qty inputs near bundle option\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _onQtyFieldChanged: function onQtyFieldChanged(event) {\n            var field = $(event.target),\n                optionInstance,\n                optionConfig;\n\n            if (field.data('optionId') && field.data('optionValueId')) {\n                optionInstance = field.data('option');\n                optionConfig = this.options.optionConfig\n                    .options[field.data('optionId')]\n                    .selections[field.data('optionValueId')];\n                optionConfig.qty = field.val();\n\n                // eslint-disable-next-line no-use-before-define\n                if (isValidQty(optionInstance)) {\n                    optionInstance.trigger('change');\n                }\n            }\n        },\n\n        /**\n         * Helper to fix backend behavior:\n         *  - if default qty large than 1 then backend multiply price in config\n         *\n         * @deprecated\n         * @private\n         */\n        _applyQtyFix: function applyQtyFix() {\n            var config = this.options.optionConfig;\n\n            if (config.isFixedPrice) {\n                _.each(config.options, function (option) {\n                    _.each(option.selections, function (item) {\n                        if (item.qty && item.qty !== 1) {\n                            _.each(item.prices, function (price) {\n                                price.amount /= item.qty;\n                            });\n                        }\n                    });\n                });\n            }\n        },\n\n        /**\n         * Helper to fix issue with option nodes:\n         *  - you can't place any html in option ->\n         *    so you can't style it via CSS\n         * @param {jQuery} options\n         * @private\n         */\n        _applyOptionNodeFix: function applyOptionNodeFix(options) {\n            var config = this.options,\n                format = config.priceFormat,\n                template = config.optionTemplate;\n\n            template = mageTemplate(template);\n            options.filter('select').each(function (index, element) {\n                var $element = $(element),\n                    optionId = utils.findOptionId($element),\n                    optionConfig = config.optionConfig && config.optionConfig.options[optionId].selections,\n                    value;\n\n                $element.find('option').each(function (idx, option) {\n                    var $option,\n                        optionValue,\n                        toTemplate,\n                        prices;\n\n                    $option = $(option);\n                    optionValue = $option.val();\n\n                    if (!optionValue && optionValue !== 0) {\n                        return;\n                    }\n\n                    toTemplate = {\n                        data: {\n                            label: optionConfig[optionValue] && optionConfig[optionValue].name\n                        }\n                    };\n                    prices = optionConfig[optionValue].prices;\n\n                    _.each(prices, function (price, type) {\n                        value = +price.amount;\n                        value += _.reduce(price.adjustments, function (sum, x) {//eslint-disable-line\n                            return sum + x;\n                        }, 0);\n                        toTemplate.data[type] = {\n                            value: value,\n                            formatted: utils.formatPriceLocale(value, format)\n                        };\n                    });\n\n                    $option.html(template(toTemplate));\n                });\n            });\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge accepted configuration with instance options.\n         * @param  {Object}  options\n         * @return {$.Widget}\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n\n            this._super(options);\n\n            return this;\n        },\n\n        /**\n         * Show or hide option tier prices block\n         *\n         * @param {Object} optionElement\n         * @private\n         */\n        _displayTierPriceBlock: function (optionElement) {\n            var optionType = optionElement.prop('type'),\n                optionId,\n                optionValue,\n                optionTierPricesElements;\n\n            if (optionType === 'select-one') {\n                optionId = utils.findOptionId(optionElement[0]);\n                optionValue = optionElement.val() || null;\n                optionTierPricesElements = $(this.options.optionTierPricesBlocksSelector.replace('{1}', optionId));\n\n                _.each(optionTierPricesElements, function (tierPriceElement) {\n                    var selectionId = $(tierPriceElement).data('selection-id') + '';\n\n                    if (selectionId === optionValue) {\n                        $(tierPriceElement).show();\n                    } else {\n                        $(tierPriceElement).hide();\n                    }\n                });\n            }\n        },\n\n        /**\n         * Handler to update productSummary box\n         */\n        updateProductSummary: function updateProductSummary() {\n            this.element.trigger('updateProductSummary', {\n                config: this.options.optionConfig\n            });\n        }\n    });\n\n    return $.mage.priceBundle;\n\n    /**\n     * Converts option value to priceBox object\n     *\n     * @param   {jQuery} element\n     * @param   {Object} config\n     * @returns {Object|null} - priceBox object with additional prices\n     */\n    function defaultGetOptionValue(element, config) {\n        var changes = {},\n            optionHash,\n            tempChanges,\n            qtyField,\n            optionId = utils.findOptionId(element[0]),\n            optionValue = element.val() || null,\n            optionName = element.prop('name'),\n            optionType = element.prop('type'),\n            optionConfig = config.options[optionId].selections,\n            optionQty = 0,\n            canQtyCustomize = false,\n            selectedIds = config.selected;\n\n        switch (optionType) {\n            case 'radio':\n            case 'select-one':\n\n                if (optionType === 'radio' && !element.is(':checked')) {\n                    return null;\n                }\n\n                qtyField = element.data('qtyField');\n                qtyField.data('option', element);\n\n                if (optionValue) {\n                    optionQty = optionConfig[optionValue].qty || 0;\n                    canQtyCustomize = optionConfig[optionValue].customQty === '1';\n                    toggleQtyField(qtyField, optionQty, optionId, optionValue, canQtyCustomize);//eslint-disable-line\n                    tempChanges = utils.deepClone(optionConfig[optionValue].prices);\n                    tempChanges = applyTierPrice(//eslint-disable-line\n                        tempChanges,\n                        optionQty,\n                        optionConfig[optionValue]\n                    );\n                    tempChanges = applyQty(tempChanges, optionQty);//eslint-disable-line\n                } else {\n                    tempChanges = {};\n                    toggleQtyField(qtyField, '0', optionId, optionValue, false);//eslint-disable-line\n                }\n                optionHash = 'bundle-option-' + optionName;\n                changes[optionHash] = tempChanges;\n                selectedIds[optionId] = [optionValue];\n                break;\n\n            case 'select-multiple':\n                optionValue = _.compact(optionValue);\n\n                _.each(optionConfig, function (row, optionValueCode) {\n                    optionHash = 'bundle-option-' + optionName + '##' + optionValueCode;\n                    optionQty = row.qty || 0;\n                    tempChanges = utils.deepClone(row.prices);\n                    tempChanges = applyTierPrice(tempChanges, optionQty, optionConfig);//eslint-disable-line\n                    tempChanges = applyQty(tempChanges, optionQty);//eslint-disable-line\n                    changes[optionHash] = _.contains(optionValue, optionValueCode) ? tempChanges : {};\n                });\n\n                selectedIds[optionId] = optionValue || [];\n                break;\n\n            case 'checkbox':\n                optionHash = 'bundle-option-' + optionName + '##' + optionValue;\n                optionQty = optionConfig[optionValue].qty || 0;\n                tempChanges = utils.deepClone(optionConfig[optionValue].prices);\n                tempChanges = applyTierPrice(tempChanges, optionQty, optionConfig);//eslint-disable-line\n                tempChanges = applyQty(tempChanges, optionQty);//eslint-disable-line\n                changes[optionHash] = element.is(':checked') ? tempChanges : {};\n\n                selectedIds[optionId] = selectedIds[optionId] || [];\n\n                if (!_.contains(selectedIds[optionId], optionValue) && element.is(':checked')) {\n                    selectedIds[optionId].push(optionValue);\n                } else if (!element.is(':checked')) {\n                    selectedIds[optionId] = _.without(selectedIds[optionId], optionValue);\n                }\n                break;\n\n            case 'hidden':\n                optionHash = 'bundle-option-' + optionName + '##' + optionValue;\n                optionQty = optionConfig[optionValue].qty || 0;\n                canQtyCustomize = optionConfig[optionValue].customQty === '1';\n                qtyField = element.data('qtyField');\n                qtyField.data('option', element);\n                toggleQtyField(qtyField, optionQty, optionId, optionValue, canQtyCustomize);//eslint-disable-line\n                tempChanges = utils.deepClone(optionConfig[optionValue].prices);\n                tempChanges = applyTierPrice(tempChanges, optionQty, optionConfig);//eslint-disable-line\n                tempChanges = applyQty(tempChanges, optionQty);//eslint-disable-line\n\n                optionHash = 'bundle-option-' + optionName;\n                changes[optionHash] = tempChanges;\n                selectedIds[optionId] = [optionValue];\n                break;\n        }\n\n        return changes;\n    }\n\n    /**\n     * Check the quantity field if negative value occurs.\n     *\n     * @param {Object} bundleOption\n     */\n    function isValidQty(bundleOption) {\n        var isValid = true,\n            qtyElem = bundleOption.data('qtyField'),\n            bundleOptionType = bundleOption.prop('type'),\n            qtyValidator = qtyElem.data('validate') &&\n                typeof qtyElem.data('validate')['validate-item-quantity'] === 'object' ?\n                qtyElem.data('validate')['validate-item-quantity'] : null;\n\n        if (['radio', 'select-one'].includes(bundleOptionType) &&\n            qtyValidator &&\n            (qtyElem.val() < qtyValidator.minAllowed || qtyElem.val() > qtyValidator.maxAllowed)\n        ) {\n            isValid = false;\n        }\n\n        return isValid;\n    }\n\n    /**\n     * Helper to toggle qty field\n     * @param {jQuery} element\n     * @param {String|Number} value\n     * @param {String|Number} optionId\n     * @param {String|Number} optionValueId\n     * @param {Boolean} canEdit\n     */\n    function toggleQtyField(element, value, optionId, optionValueId, canEdit) {\n        element\n            .val(value)\n            .data('optionId', optionId)\n            .data('optionValueId', optionValueId)\n            .attr('disabled', !canEdit);\n\n        if (canEdit) {\n            element.removeClass('qty-disabled');\n        } else {\n            element.addClass('qty-disabled');\n        }\n    }\n\n    /**\n     * Helper to multiply on qty\n     *\n     * @param   {Object} prices\n     * @param   {Number} qty\n     * @returns {Object}\n     */\n    function applyQty(prices, qty) {\n        _.each(prices, function (everyPrice) {\n            everyPrice.amount *= qty;\n            _.each(everyPrice.adjustments, function (el, index) {\n                everyPrice.adjustments[index] *= qty;\n            });\n        });\n\n        return prices;\n    }\n\n    /**\n     * Helper to limit price with tier price\n     *\n     * @param {Object} oneItemPrice\n     * @param {Number} qty\n     * @param {Object} optionConfig\n     * @returns {Object}\n     */\n    function applyTierPrice(oneItemPrice, qty, optionConfig) {\n        var tiers = optionConfig.tierPrice,\n            magicKey = _.keys(oneItemPrice)[0],\n            tiersFirstKey = _.keys(optionConfig)[0],\n            lowest = false;\n\n        if (!tiers) {//tiers is undefined when options has only one option\n            tiers = optionConfig[tiersFirstKey].tierPrice;\n        }\n\n        tiers.sort(function (a, b) {//sorting based on \"price_qty\"\n            return a['price_qty'] - b['price_qty'];\n        });\n\n        _.each(tiers, function (tier, index) {\n            if (tier['price_qty'] > qty) {\n                return;\n            }\n\n            if (tier.prices[magicKey].amount < oneItemPrice[magicKey].amount) {\n                lowest = index;\n            }\n        });\n\n        if (lowest !== false) {\n            oneItemPrice = utils.deepClone(tiers[lowest].prices);\n        }\n\n        return oneItemPrice;\n    }\n});\n","Magento_Bundle/js/components/bundle-checkbox.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox',\n    'uiRegistry'\n], function (Checkbox, registry) {\n    'use strict';\n\n    return Checkbox.extend({\n        defaults: {\n            clearing: false,\n            parentContainer: '',\n            parentSelections: '',\n            changer: '',\n            exports: {\n                value: '${$.parentName}:isDefaultValue'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            this._super().\n                observe('elementTmpl');\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initConfig: function () {\n            this._super();\n            this.imports.changeType = this.retrieveParentName(this.parentContainer) + '.' + this.changer + ':value';\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onUpdate: function () {\n            if (this.prefer === 'radio' && this.checked() && !this.clearing) {\n                this.clearValues();\n            }\n\n            this._super();\n        },\n\n        /**\n         * Checkbox to radio type changer.\n         *\n         * @param {String} type - type to change.\n         */\n        changeType: function (type) {\n            var typeMap = registry.get(this.retrieveParentName(this.parentContainer) + '.' + this.changer).typeMap;\n\n            this.prefer = typeMap[type];\n            this.elementTmpl(this.templates[typeMap[type]]);\n        },\n\n        /**\n         * Clears values in components like this.\n         */\n        clearValues: function () {\n            var records = registry.get(this.retrieveParentName(this.parentSelections)),\n                index = this.index,\n                uid = this.uid;\n\n            records.elems.each(function (record) {\n                record.elems.filter(function (comp) {\n                    return comp.index === index && comp.uid !== uid;\n                }).each(function (comp) {\n                    comp.clearing = true;\n                    comp.clear();\n                    comp.clearing = false;\n                });\n            });\n        },\n\n        /**\n         * Retrieve name for the most global parent with provided index.\n         *\n         * @param {String} parent - parent name.\n         * @returns {String}\n         */\n        retrieveParentName: function (parent) {\n            return this.name.replace(new RegExp('^(.+?\\\\.)?' + parent + '\\\\..+'), '$1' + parent);\n        }\n    });\n});\n","Magento_Bundle/js/components/bundle-dynamic-rows-grid.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows-grid',\n    'uiLayout',\n    'rjsResolver'\n], function (_, dynamicRowsGrid, layout, resolver) {\n    'use strict';\n\n    return dynamicRowsGrid.extend({\n        defaults: {\n            label: '',\n            columnsHeader: false,\n            columnsHeaderAfterRender: true,\n            addButton: false,\n            isDefaultFieldScope: 'is_default',\n            defaultRecords: {\n                use: [],\n                moreThanOne: false,\n                state: {}\n            },\n            listens: {\n                inputType: 'onInputTypeChange',\n                isDefaultValue: 'onIsDefaultValue',\n                pageSize: 'onPageSizeChange'\n            },\n            sizesConfig: {\n                component: 'Magento_Ui/js/grid/paging/sizes',\n                name: '${ $.name }_sizes',\n                options: {\n                    '20': {\n                        value: 20,\n                        label: 20\n                    },\n                    '30': {\n                        value: 30,\n                        label: 30\n                    },\n                    '50': {\n                        value: 50,\n                        label: 50\n                    },\n                    '100': {\n                        value: 100,\n                        label: 100\n                    },\n                    '200': {\n                        value: 200,\n                        label: 200\n                    }\n                },\n                storageConfig: {\n                    provider: '${ $.storageConfig.provider }',\n                    namespace: '${ $.storageConfig.namespace }'\n                },\n                enabled: false\n            },\n            links: {\n                options: '${ $.sizesConfig.name }:options',\n                pageSize: '${ $.sizesConfig.name }:value'\n            },\n            modules: {\n                sizes: '${ $.sizesConfig.name }'\n            }\n        },\n\n        /**\n         * Initializes paging component.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initSizes();\n\n            return this;\n        },\n\n        /**\n         * Initializes sizes component.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initSizes: function () {\n            if (this.sizesConfig.enabled) {\n                layout([this.sizesConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Handler for type select.\n         *\n         * @param {String} inputType - changed.\n         */\n        onInputTypeChange: function (inputType) {\n            if (this.defaultRecords.moreThanOne && (inputType === 'radio' || inputType === 'select')) {\n                _.each(this.defaultRecords.use, function (index, counter) {\n                    this.source.set(\n                        this.dataScope + '.bundle_selections.' + index + '.' + this.isDefaultFieldScope,\n                        counter ? '0' : '1'\n                    );\n                }.bind(this));\n            }\n        },\n\n        /**\n         * Handler for is_default field.\n         *\n         * @param {Object} data - changed data.\n         */\n        onIsDefaultValue: function (data) {\n            var cb,\n                use = 0;\n\n            this.defaultRecords.use = [];\n\n            cb = function (elem, key) {\n\n                if (~~elem) {\n                    this.defaultRecords.use.push(key);\n                    use++;\n                }\n\n                this.defaultRecords.moreThanOne = use > 1;\n            }.bind(this);\n\n            _.each(data, cb);\n        },\n\n        /**\n         * Initialize elements from grid\n         *\n         * @param {Array} data\n         *\n         * @returns {Object} Chainable.\n         */\n        initElements: function (data) {\n            var newData = this.getNewData(data),\n                recordIndex;\n\n            this.parsePagesData(data);\n\n            if (newData.length) {\n                if (this.insertData().length) {\n                    recordIndex = data.length - newData.length - 1;\n\n                    _.each(newData, function (newRecord) {\n                        this.processingAddChild(newRecord, ++recordIndex, newRecord[this.identificationProperty]);\n                    }, this);\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Mapping value from grid\n         *\n         * @param {Array} data\n         */\n        mappingValue: function (data) {\n            if (_.isEmpty(data)) {\n                return;\n            }\n\n            this._super();\n        },\n\n        /**\n         * Handles changes of the page size.\n         */\n        onPageSizeChange: function () {\n            resolver(function () {\n                if (this.elems().length) {\n                    this.reload();\n                }\n            }, this);\n        }\n    });\n});\n","Magento_Bundle/js/components/bundle-dynamic-rows.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'mageUtils',\n    'uiRegistry',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows'\n], function (_, utils, registry, dynamicRows) {\n    'use strict';\n\n    return dynamicRows.extend({\n        defaults: {\n            label: '',\n            collapsibleHeader: true,\n            columnsHeader: false,\n            deleteProperty: false,\n            addButton: false\n        },\n\n        /**\n         * Set new data to dataSource,\n         * delete element\n         *\n         * @param {Array} data - record data\n         */\n        _updateData: function (data) {\n            var elems = _.clone(this.elems()),\n                path,\n                dataArr,\n                optionBaseData;\n\n            dataArr = this.recordData.splice(this.startIndex, this.recordData().length - this.startIndex);\n            dataArr.splice(0, this.pageSize);\n            elems = _.sortBy(this.elems(), function (elem) {\n                return ~~elem.index;\n            });\n\n            data.concat(dataArr).forEach(function (rec, idx) {\n                if (elems[idx]) {\n                    elems[idx].recordId = rec[this.identificationProperty];\n                }\n\n                if (!rec.position) {\n                    rec.position = this.maxPosition;\n                    this.setMaxPosition();\n                }\n\n                path = this.dataScope + '.' + this.index + '.' + (this.startIndex + idx);\n                optionBaseData = _.pick(rec, function (value) {\n                    return !_.isObject(value);\n                });\n                this.source.set(path, optionBaseData);\n                this.source.set(path + '.bundle_button_proxy', []);\n                this.source.set(path + '.bundle_selections', []);\n                this.removeBundleItemsFromOption(idx);\n                _.each(rec['bundle_selections'], function (obj, index) {\n                    this.source.set(path + '.bundle_button_proxy' + '.' + index, rec['bundle_button_proxy'][index]);\n                    this.source.set(path + '.bundle_selections' + '.' + index, obj);\n                }, this);\n            }, this);\n\n            this.elems(elems);\n        },\n\n        /**\n         *  Removes nested dynamic-rows-grid rendered records from option\n         *\n         * @param {Number|String} index - element index\n         */\n        removeBundleItemsFromOption: function (index) {\n            var bundleSelections = registry.get(this.name + '.' + index + '.' + this.bundleSelectionsName),\n                bundleSelectionsLength = (bundleSelections.elems() || []).length,\n                i;\n\n            if (bundleSelectionsLength) {\n                for (i = 0; i < bundleSelectionsLength; i++) {\n                    bundleSelections.elems()[0].destroy();\n                }\n            }\n        },\n\n        /**\n        * {@inheritdoc}\n        */\n        processingAddChild: function (ctx, index, prop) {\n            var recordIds = _.map(this.recordData(), function (rec) {\n                return parseInt(rec['record_id'], 10);\n            }),\n            maxRecordId = _.max(recordIds);\n\n            prop = maxRecordId > -1 ? maxRecordId + 1 : prop;\n            this._super(ctx, index, prop);\n        }\n    });\n});\n","Magento_Bundle/js/components/bundle-input-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated Not used anymore\n * @see Magento_Bundle/js/components/bundle-record\n * @see Magento_Bundle/js/components/bundle-checkbox\n */\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'uiRegistry'\n], function (Select, registry) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            previousType: '',\n            parentContainer: '',\n            selections: '',\n            targetIndex: '',\n            typeMap: {}\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onUpdate: function () {\n            var type = this.typeMap[this.value()];\n\n            if (type !== this.previousType) {\n                this.previousType = type;\n                this.processSelections(type === 'radio');\n            }\n\n            this._super();\n        },\n\n        /**\n         * Toggle 'User Defined' column and clears values\n         * @param {Boolean} isRadio\n         */\n        processSelections: function (isRadio) {\n            var records = registry.get(this.retrieveParentName(this.parentContainer) + '.' + this.selections),\n                checkedFound = false;\n\n            records.elems.each(function (record) {\n                record.elems.filter(function (comp) {\n                    return comp.index === this.userDefinedIndex;\n                }, this).each(function (comp) {\n                    comp.visible(isRadio);\n                });\n\n                if (isRadio) {\n                    record.elems.filter(function (comp) {\n                        return comp.index === this.isDefaultIndex;\n                    }, this).each(function (comp) {\n                        if (comp.checked()) {\n                            if (checkedFound) {\n                                comp.clearing = true;\n                                comp.clear();\n                                comp.clearing = false;\n                            }\n\n                            checkedFound = true;\n                        }\n                    });\n                }\n            }, this);\n        },\n\n        /**\n         * Retrieve name for the most global parent with provided index.\n         *\n         * @param {String} parent - parent name.\n         * @returns {String}\n         */\n        retrieveParentName: function (parent) {\n            return this.name.replace(new RegExp('^(.+?\\\\.)?' + parent + '\\\\..+'), '$1' + parent);\n        }\n    });\n});\n","Magento_Bundle/js/components/bundle-option-qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            valueUpdate: 'input',\n            isInteger: true,\n            validation: {\n                'validate-number': true\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        setInitialValue: function () {\n            this.initialValue = this.getInitialValue();\n\n            if (this.initialValue === undefined || this.initialValue === '') {\n                this.initialValue = 1;\n            }\n\n            if (this.value.peek() !== this.initialValue) {\n                this.value(this.initialValue);\n            }\n\n            this.on('value', this.onUpdate.bind(this));\n            this.isUseDefault(this.disabled());\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onUpdate: function () {\n            this.validation['validate-digits'] = this.isInteger;\n            this._super();\n        },\n\n        /**\n         * @inheritdoc\n         */\n        hasChanged: function () {\n            var notEqual = this.value() !== this.initialValue.toString();\n\n            return !this.visible() ? false : notEqual;\n        }\n    });\n});\n","Magento_Bundle/js/components/bundle-record.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/dynamic-rows/record',\n    'uiRegistry'\n], function (Record, registry) {\n    'use strict';\n\n    return Record.extend({\n        /**\n         * @param {String} val - type of Input Type\n         */\n        onTypeChanged: function (val) {\n            var columnVisibility  = !(val === 'multi' || val === 'checkbox');\n\n            registry.async(this.name + '.' + 'selection_can_change_qty')(function (elem) {\n                elem.visible(columnVisibility);\n            });\n        }\n    });\n});\n","Magento_Bundle/js/components/bundle-user-defined-checkbox.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (Checkbox) {\n    'use strict';\n\n    return Checkbox.extend({\n        defaults: {\n            listens: {\n                inputType: 'onInputTypeChange'\n            }\n        },\n\n        /**\n         * Handler for \"inputType\" property\n         *\n         * @param {String} data\n         */\n        onInputTypeChange: function (data) {\n            data === 'checkbox' || data === 'multi' ?\n                this.clear()\n                    .visible(false) :\n                this.visible(true);\n        }\n    });\n});\n","Magento_Catalog/catalog/apply-to-type-switcher.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/catalog/type-events'\n], function ($, productType) {\n    'use strict';\n\n    return {\n\n        /**\n         * Bind event\n         */\n        bindAll: function () {\n            $('[data-form=edit-product] [data-role=tabs]').on(\n                'contentUpdated',\n                this._switchToTypeByApplyAttr.bind(this)\n            );\n\n            $('#product_info_tabs').on(\n                'beforePanelsMove tabscreate tabsactivate',\n                this._switchToTypeByApplyAttr.bind(this)\n            );\n\n            $(document).on('changeTypeProduct', this._switchToTypeByApplyAttr.bind(this));\n        },\n\n        /**\n         * Constructor component\n         */\n        'Magento_Catalog/catalog/apply-to-type-switcher': function () {\n            this.bindAll();\n            this._switchToTypeByApplyAttr();\n        },\n\n        /**\n         * Show/hide elements based on type\n         *\n         * @private\n         */\n        _switchToTypeByApplyAttr: function () {\n            $('[data-apply-to]:not(.removed)').each(function (index, element) {\n                var attrContainer = $(element),\n                    applyTo = attrContainer.data('applyTo') || [],\n                    $inputs = attrContainer.find('select, input, textarea');\n\n                if (applyTo.length === 0 || $.inArray(productType.type.current, applyTo) !== -1) {\n                    attrContainer.removeClass('not-applicable-attribute');\n                    $inputs.removeClass('ignore-validate');\n                } else {\n                    attrContainer.addClass('not-applicable-attribute');\n                    $inputs.addClass('ignore-validate');\n                }\n            });\n        }\n    };\n});\n","Magento_Catalog/catalog/base-image-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'jquery/file-uploader',\n    'mage/translate',\n    'mage/backend/notification'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.baseImage', {\n        /**\n         * Button creation\n         * @protected\n         */\n        options: {\n            maxImageUploadCount: 10\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var $container = this.element,\n                imageTmpl = mageTemplate(this.element.find('[data-template=image]').html()),\n                $dropPlaceholder = this.element.find('.image-placeholder'),\n                $galleryContainer = $('#media_gallery_content'),\n                mainClass = 'base-image',\n                maximumImageCount = 5,\n                $fieldCheckBox = $container.closest('[data-attribute-code=image]').find(':checkbox'),\n                isDefaultChecked = $fieldCheckBox.is(':checked'),\n                findElement, updateVisibility;\n\n            if (isDefaultChecked) {\n                $fieldCheckBox.trigger('click');\n            }\n\n            /**\n             * @param {Object} data\n             * @return {HTMLElement}\n             */\n            findElement = function (data) {\n                return $container.find('.image:not(.image-placeholder)').filter(function () {\n                    if (!$(this).data('image')) {\n                        return false;\n                    }\n\n                    return $(this).data('image').file === data.file;\n                }).first();\n            };\n\n            /** Update image visibility. */\n            updateVisibility = function () {\n                var elementsList = $container.find('.image:not(.removed-item)');\n\n                elementsList.each(function (index) {\n                    $(this)[index < maximumImageCount ? 'show' : 'hide']();\n                });\n                $dropPlaceholder[elementsList.length > maximumImageCount ? 'hide' : 'show']();\n            };\n\n            $galleryContainer.on('setImageType', function (event, data) {\n                if (data.type === 'image') {\n                    $container.find('.' + mainClass).removeClass(mainClass);\n\n                    if (data.imageData) {\n                        findElement(data.imageData).addClass(mainClass);\n                    }\n                }\n            });\n\n            $galleryContainer.on('addItem', function (event, data) {\n                var tmpl = imageTmpl({\n                    data: data\n                });\n\n                $(tmpl).data('image', data).insertBefore($dropPlaceholder);\n\n                updateVisibility();\n            });\n\n            $galleryContainer.on('removeItem', function (event, image) {\n                findElement(image).addClass('removed-item').hide();\n                updateVisibility();\n            });\n\n            $galleryContainer.on('moveElement', function (event, data) {\n                var $element = findElement(data.imageData),\n                    $after;\n\n                if (data.position === 0) {\n                    $container.prepend($element);\n                } else {\n                    $after = $container.find('.image').eq(data.position);\n\n                    if (!$element.is($after)) {\n                        $element.insertAfter($after);\n                    }\n                }\n                updateVisibility();\n            });\n\n            $container.on('click', '[data-role=make-base-button]', function (event) {\n                var data;\n\n                event.preventDefault();\n                data = $(event.target).closest('.image').data('image');\n                $galleryContainer.productGallery('setBase', data);\n            });\n\n            $container.on('click', '[data-role=delete-button]', function (event) {\n                event.preventDefault();\n                $galleryContainer.trigger('removeItem', $(event.target).closest('.image').data('image'));\n            });\n\n            $container.sortable({\n                axis: 'x',\n                items: '.image:not(.image-placeholder)',\n                distance: 8,\n                tolerance: 'pointer',\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {Object} data\n                 */\n                stop: function (event, data) {\n                    $galleryContainer.trigger('setPosition', {\n                        imageData: data.item.data('image'),\n                        position: $container.find('.image').index(data.item)\n                    });\n                    $galleryContainer.trigger('resort');\n                }\n            }).disableSelection();\n\n            this.element.find('input[type=\"file\"]').fileupload({\n                dataType: 'json',\n                dropZone: $dropPlaceholder.closest('[data-attribute-code]'),\n                acceptFileTypes: /(\\.|\\/)(gif|jpe?g|png)$/i,\n                maxFileSize: this.element.data('maxFileSize'),\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {Object} data\n                 */\n                done: function (event, data) {\n                    $dropPlaceholder.find('.progress-bar').text('').removeClass('in-progress');\n\n                    if (!data.result) {\n                        return;\n                    }\n\n                    if (!data.result.error) {\n                        $galleryContainer.trigger('addItem', data.result);\n                    } else {\n                        alert({\n                            content: $.mage.__('We don\\'t recognize or support this file extension type.')\n                        });\n                    }\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 * @param {Object} data\n                 */\n                change: function (e, data) {\n                    if (data.files.length > this.options.maxImageUploadCount) {\n                        $('body').notification('clear').notification('add', {\n                            error: true,\n                            message: $.mage.__('You can\\'t upload more than ' + this.options.maxImageUploadCount +\n                                ' images in one time'),\n\n                            /**\n                             * @param {*} message\n                             */\n                            insertMethod: function (message) {\n                                $('.page-main-actions').after(message);\n                            }\n                        });\n\n                        return false;\n                    }\n                }.bind(this),\n\n                /**\n                 * @param {jQuery.Event} event\n                 * @param {*} data\n                 */\n                add: function (event, data) {\n                    $(this).fileupload('process', data).done(function () {\n                        data.submit();\n                    });\n                },\n\n                /**\n                 * @param {jQuery.Event} e\n                 * @param {Object} data\n                 */\n                progress: function (e, data) {\n                    var progress = parseInt(data.loaded / data.total * 100, 10);\n\n                    $dropPlaceholder.find('.progress-bar').addClass('in-progress').text(progress + '%');\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                start: function (event) {\n                    var uploaderContainer = $(event.target).closest('.image-placeholder');\n\n                    uploaderContainer.addClass('loading');\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                stop: function (event) {\n                    var uploaderContainer = $(event.target).closest('.image-placeholder');\n\n                    uploaderContainer.removeClass('loading');\n                }\n            });\n        }\n    });\n\n    return $.mage.baseImage;\n});\n","Magento_Catalog/catalog/product-attributes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiRegistry',\n    'jquery/ui',\n    'mage/translate'\n], function ($, _, registry) {\n    'use strict';\n\n    $.widget('mage.productAttributes', {\n        /** @inheritdoc */\n        _create: function () {\n            this._on({\n                'click': '_showPopup'\n            });\n        },\n\n        /**\n         * @private\n         */\n        _initModal: function () {\n            var self = this;\n\n            this.modal = $('<div id=\"create_new_attribute\"></div>').modal({\n                title: $.mage.__('New Attribute'),\n                type: 'slide',\n                buttons: [],\n\n                /** @inheritdoc */\n                opened: function () {\n                    $(this).parent().addClass('modal-content-new-attribute');\n                    self.iframe = $('<iframe id=\"create_new_attribute_container\"></iframe>').attr({\n                        src: self._prepareUrl(),\n                        frameborder: 0\n                    });\n                    self.modal.append(self.iframe);\n                    self._changeIframeSize();\n                    $(window).off().on('resize.modal', _.debounce(self._changeIframeSize.bind(self), 400));\n                },\n\n                /** @inheritdoc */\n                closed: function () {\n                    var doc = self.iframe.get(0).document;\n\n                    if (doc && typeof doc.execCommand === 'function') {\n                        //IE9 break script loading but not execution on iframe removing\n                        doc.execCommand('stop');\n                        self.iframe.remove();\n                    }\n                    self.modal.data('mageModal').modal.remove();\n                    $(window).off('resize.modal');\n                }\n            });\n        },\n\n        /**\n         * @return {Number}\n         * @private\n         */\n        _getHeight: function () {\n            var modal = this.modal.data('mageModal').modal,\n                modalHead = modal.find('header'),\n                modalHeadHeight = modalHead.outerHeight(),\n                modalHeight = modal.outerHeight(),\n                modalContentPadding = this.modal.parent().outerHeight() - this.modal.parent().height();\n\n            return modalHeight - modalHeadHeight - modalContentPadding;\n        },\n\n        /**\n         * @return {Number}\n         * @private\n         */\n        _getWidth: function () {\n            return this.modal.width();\n        },\n\n        /**\n         * @private\n         */\n        _changeIframeSize: function () {\n            this.modal.parent().outerHeight(this._getHeight());\n            this.iframe.outerHeight(this._getHeight());\n            this.iframe.outerWidth(this._getWidth());\n\n        },\n\n        /**\n         * @return {String}\n         * @private\n         */\n        _prepareUrl: function () {\n            var productSource,\n                attributeSetId = '';\n\n            if (this.options.dataProvider) {\n                try {\n                    productSource = registry.get(this.options.dataProvider);\n                    attributeSetId = productSource.data.product['attribute_set_id'];\n                } catch (e) {}\n            }\n\n            return this.options.url +\n                (/\\?/.test(this.options.url) ? '&' : '?') +\n                'set=' + attributeSetId;\n        },\n\n        /**\n         * @private\n         */\n        _showPopup: function () {\n            this._initModal();\n            this.modal.modal('openModal');\n        }\n    });\n\n    return $.mage.productAttributes;\n});\n","Magento_Catalog/catalog/product.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    window.Product = {};\n\n    /**\n     * @param {String} id\n     * @return {*|jQuery|HTMLElement}\n     */\n    function byId(id) {\n        return $('#' + id);\n    }\n\n    /**\n     * @param {String} fieldId\n     */\n    function disableFieldEditMode(fieldId) {\n        var field = byId(fieldId);\n\n        field.prop('disabled', true);\n\n        if (field.next().hasClass('addafter')) {\n            field.parent().addClass('_update-attributes-disabled');\n        }\n\n        if (byId(fieldId + '_hidden').length) {\n            byId(fieldId + '_hidden').prop('disabled', true);\n        }\n    }\n\n    /**\n     * @param {String} fieldId\n     */\n    function enableFieldEditMode(fieldId) {\n        var field = byId(fieldId);\n\n        field.prop('disabled', false);\n\n        if (field.parent().hasClass('_update-attributes-disabled')) {\n            field.parent().removeClass('_update-attributes-disabled');\n        }\n\n        if (byId(fieldId + '_hidden').length) {\n            byId(fieldId + '_hidden').prop('disabled', false);\n        }\n    }\n\n    /**\n     * @param {String} toogleIdentifier\n     * @param {String} fieldId\n     */\n    function toogleFieldEditMode(toogleIdentifier, fieldId) {\n        if ($(toogleIdentifier).is(':checked')) {\n            enableFieldEditMode(fieldId);\n        } else {\n            disableFieldEditMode(fieldId);\n        }\n    }\n\n    /**\n     * On complete disable.\n     */\n    function onCompleteDisableInited() {\n        var item;\n\n        $.each($('[data-disable]'), function () {\n            item = $(this).data('disable');\n            disableFieldEditMode(item);\n        });\n    }\n\n    /**\n     * @param {String} urlKey\n     */\n    function onUrlkeyChanged(urlKey) {\n        var hidden, chbx, oldValue;\n\n        urlKey = byId(urlKey);\n        hidden = urlKey.siblings('input[type=hidden]');\n        chbx = urlKey.siblings('input[type=checkbox]');\n        oldValue = chbx.val();\n\n        chbx.prop('disabled', oldValue === urlKey.val());\n        hidden.prop('disabled', chbx.prop('disabled'));\n    }\n\n    /**\n     * @param {HTMLElement} element\n     */\n    function onCustomUseParentChanged(element) {\n        var useParent, parent;\n\n        element = $(element);\n        useParent = element.val() == 1; //eslint-disable-line eqeqeq\n        parent = element.offsetParent().parent();\n\n        parent.find('input, select, textarea').each(function (i, el) {\n            el = $(el);\n\n            if (element.prop('id') !== el.prop('id')) {\n                el.prop('disabled', useParent);\n            }\n        });\n\n        parent.find('img').each(function (i, el) {\n            if (useParent) {\n                $(el).hide();\n            } else {\n                $(el).show();\n            }\n        });\n    }\n\n    window.onCustomUseParentChanged = onCustomUseParentChanged;\n    window.onUrlkeyChanged = onUrlkeyChanged;\n    window.toogleFieldEditMode = toogleFieldEditMode;\n\n    $(onCompleteDisableInited);\n});\n","Magento_Catalog/catalog/type-events.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return {\n        $type: $('#product_type_id'),\n\n        /**\n         * Init\n         */\n        init: function () {\n            this.type = {\n                init: this.$type.val(),\n                current: this.$type.val()\n            };\n\n            this.bindAll();\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            $(document).on('setTypeProduct', function (event, type) {\n                this.setType(type);\n            }.bind(this));\n\n            //direct change type input\n            this.$type.on('change', function () {\n                this.type.current = this.$type.val();\n                this._notifyType();\n            }.bind(this));\n        },\n\n        /**\n         * Set type\n         * @param {String} type - type product (downloadable, simple, virtual ...)\n         * @returns {*}\n         */\n        setType: function (type) {\n            return this.$type.val(type || this.type.init).trigger('change');\n        },\n\n        /**\n         * Notify type\n         * @private\n         */\n        _notifyType: function () {\n            $(document).trigger('changeTypeProduct', this.type);\n        }\n    };\n});\n","Magento_Catalog/catalog/category/assign-products.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'mage/adminhtml/grid'\n], function () {\n    'use strict';\n\n    return function (config) {\n        var selectedProducts = config.selectedProducts,\n            categoryProducts = $H(selectedProducts),\n            gridJsObject = window[config.gridJsObjectName],\n            tabIndex = 1000;\n\n        $('in_category_products').value = Object.toJSON(categoryProducts);\n\n        /**\n         * Register Category Product\n         *\n         * @param {Object} grid\n         * @param {Object} element\n         * @param {Boolean} checked\n         */\n        function registerCategoryProduct(grid, element, checked) {\n            if (checked) {\n                if (element.positionElement) {\n                    element.positionElement.disabled = false;\n                    categoryProducts.set(element.value, element.positionElement.value);\n                }\n            } else {\n                if (element.positionElement) {\n                    element.positionElement.disabled = true;\n                }\n                categoryProducts.unset(element.value);\n            }\n            $('in_category_products').value = Object.toJSON(categoryProducts);\n            grid.reloadParams = {\n                'selected_products[]': categoryProducts.keys()\n            };\n        }\n\n        /**\n         * Click on product row\n         *\n         * @param {Object} grid\n         * @param {String} event\n         */\n        function categoryProductRowClick(grid, event) {\n            var trElement = Event.findElement(event, 'tr'),\n                eventElement = Event.element(event),\n                isInputCheckbox = eventElement.tagName === 'INPUT' && eventElement.type === 'checkbox',\n                isInputPosition = grid.targetElement &&\n                    grid.targetElement.tagName === 'INPUT' &&\n                    grid.targetElement.name === 'position',\n                checked = false,\n                checkbox = null;\n\n            if (eventElement.tagName === 'LABEL' &&\n                trElement.querySelector('#' + eventElement.htmlFor) &&\n                trElement.querySelector('#' + eventElement.htmlFor).type === 'checkbox'\n            ) {\n                event.stopPropagation();\n                trElement.querySelector('#' + eventElement.htmlFor).trigger('click');\n\n                return;\n            }\n\n            if (trElement && !isInputPosition) {\n                checkbox = Element.getElementsBySelector(trElement, 'input');\n\n                if (checkbox[0]) {\n                    checked = isInputCheckbox ? checkbox[0].checked : !checkbox[0].checked;\n                    gridJsObject.setCheckboxChecked(checkbox[0], checked);\n                }\n            }\n        }\n\n        /**\n         * Change product position\n         *\n         * @param {String} event\n         */\n        function positionChange(event) {\n            var element = Event.element(event);\n\n            if (element && element.checkboxElement && element.checkboxElement.checked) {\n                categoryProducts.set(element.checkboxElement.value, element.value);\n                $('in_category_products').value = Object.toJSON(categoryProducts);\n            }\n        }\n\n        /**\n         * Initialize category product row\n         *\n         * @param {Object} grid\n         * @param {String} row\n         */\n        function categoryProductRowInit(grid, row) {\n            var checkbox = $(row).getElementsByClassName('checkbox')[0],\n                position = $(row).getElementsByClassName('input-text')[0];\n\n            if (checkbox && position) {\n                checkbox.positionElement = position;\n                position.checkboxElement = checkbox;\n                position.disabled = !checkbox.checked;\n                position.tabIndex = tabIndex++;\n                Event.observe(position, 'keyup', positionChange);\n            }\n        }\n\n        gridJsObject.rowClickCallback = categoryProductRowClick;\n        gridJsObject.initRowCallback = categoryProductRowInit;\n        gridJsObject.checkboxCheckCallback = registerCategoryProduct;\n\n        if (gridJsObject.rows) {\n            gridJsObject.rows.each(function (row) {\n                categoryProductRowInit(gridJsObject, row);\n            });\n        }\n    };\n});\n","Magento_Catalog/catalog/category/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert'\n], function ($, alert) {\n    'use strict';\n\n    return function (config) {\n        var categoryForm = {\n            options: {\n                categoryIdSelector: 'input[name=\"id\"]',\n                categoryPathSelector: 'input[name=\"path\"]',\n                categoryParentSelector: 'input[name=\"parent\"]',\n                categoryLevelSelector: 'input[name=\"level\"]',\n                refreshUrl: config.refreshUrl\n            },\n\n            /**\n             * Sending ajax to server to refresh field 'path'\n             * @protected\n             */\n            refreshPath: function () {\n                if (!$(this.options.categoryIdSelector)) {\n                    return false;\n                }\n                $.ajax({\n                    url: this.options.refreshUrl,\n                    method: 'GET',\n                    showLoader: true\n                }).done(this._refreshPathSuccess.bind(this));\n            },\n\n            /**\n             * Refresh field 'path' on ajax success\n             * @param {Object} data\n             * @private\n             */\n            _refreshPathSuccess: function (data) {\n                if (data.error) {\n                    alert({\n                        content: data.message\n                    });\n                } else {\n                    $(this.options.categoryIdSelector).val(data.id).trigger('change');\n                    $(this.options.categoryPathSelector).val(data.path).trigger('change');\n                    $(this.options.categoryParentSelector).val(data.parentId).trigger('change');\n                    $(this.options.categoryLevelSelector).val(data.level).trigger('change');\n                }\n            }\n        };\n\n        $('body').on('categoryMove.tree', $.proxy(categoryForm.refreshPath.bind(categoryForm), this));\n    };\n});\n","Magento_Catalog/catalog/product/attribute/unique-validate.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/backend/validation'\n], function (jQuery) {\n    'use strict';\n\n    return function (config) {\n        var msg = '',\n            _config = jQuery.extend({\n                element: null,\n                message: '',\n                uniqueClass: 'required-unique'\n            }, config),\n\n            /** @inheritdoc */\n            messager = function () {\n                return msg;\n            };\n\n        if (typeof _config.element === 'string') {\n            jQuery.validator.addMethod(\n                _config.element,\n\n                function (value, element) {\n                    var inputs = jQuery(element)\n                            .closest('table')\n                            .find('.' + _config.uniqueClass + ':visible'),\n                        valuesHash = {},\n                        isValid = true,\n                        duplicates = [];\n\n                    inputs.each(function (el) {\n                        var inputValue = inputs[el].value;\n\n                        if (typeof valuesHash[inputValue] !== 'undefined') {\n                            isValid = false;\n                            duplicates.push(inputValue);\n                        }\n                        valuesHash[inputValue] = el;\n                    });\n\n                    if (!isValid) {\n                        msg = _config.message + ' (' + duplicates.join(', ') + ')';\n                    }\n\n                    return isValid;\n                },\n\n                messager\n            );\n        }\n    };\n});\n","Magento_Catalog/catalog/product/composite/configure.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/lib/view/utils/async',\n    'jquery/ui',\n    'mage/translate',\n    'prototype',\n    'Magento_Ui/js/modal/modal'\n], function (jQuery) {\n\n    window.ProductConfigure = Class.create();\n\n    ProductConfigure.prototype = {\n\n        listTypes:                  $H({}),\n        current:                    $H({}),\n        itemsFilter:                $H({}),\n        blockWindow:                null,\n        blockForm:                  null,\n        blockFormFields:            null,\n        blockFormAdd:               null,\n        blockFormConfirmed:         null,\n        blockConfirmed:             null,\n        blockIFrame:                null,\n        blockCancelBtn:             null,\n        blockMask:                  null,\n        blockMsg:                   null,\n        blockMsgError:              null,\n        windowHeight:               null,\n        confirmedCurrentId:         null,\n        confirmCallback:            {},\n        cancelCallback:             {},\n        onLoadIFrameCallback:       {},\n        showWindowCallback:         {},\n        beforeSubmitCallback:       {},\n        iFrameJSVarname:            null,\n        _listTypeId:                1,\n\n        /**\n         * Initialize object\n         */\n        initialize: function () {\n            var self = this,\n                popupDialog = jQuery('#product_composite_configure');\n\n            this._initWindowElements();\n            jQuery.async('#product_composite_configure', function (el) {\n                if (el !== popupDialog[0]) {\n                    el = popupDialog[0];\n                }\n                self.dialog = jQuery(el).modal({\n                    title: jQuery.mage.__('Configure Product'),\n                    type: 'slide',\n                    buttons: [{\n                        text: jQuery.mage.__('OK'),\n                        'class': 'action-primary',\n                        click: function () {\n                            self.onConfirmBtn();\n                        }\n                    }],\n                    closed: function () {\n                        self.clean('window');\n                    },\n                });\n            });\n        },\n\n        /**\n         * Initialize window elements\n         */\n        _initWindowElements: function () {\n            this.blockWindow                = $('product_composite_configure');\n            this.blockForm                  = $('product_composite_configure_form');\n            this.blockFormFields            = $('product_composite_configure_form_fields');\n            this.blockFormAdd               = $('product_composite_configure_form_additional');\n            this.blockFormConfirmed         = $('product_composite_configure_form_confirmed');\n            this.blockConfirmed             = $('product_composite_configure_confirmed');\n            this.blockIFrame                = $('product_composite_configure_iframe');\n            this.blockCancelBtn             = $('product_composite_configure_form_cancel');\n            this.blockMsg                   = $('product_composite_configure_messages');\n            this.blockMsgError              = this.blockMsg.select('.message.error div')[0];\n            this.iFrameJSVarname            = this.blockForm.select('input[name=\"as_js_varname\"]')[0].value;\n        },\n\n        /**\n         * Returns next unique list type id\n         */\n        _generateListTypeId: function () {\n            return '_internal_lt_' + this._listTypeId++;\n        },\n\n        /**\n         * Add product list types as scope and their urls\n         * example: addListType('product_to_add', {urlFetch: 'http://magento...'})\n         * example: addListType('wishlist', {urlSubmit: 'http://magento...'})\n         *\n         * @param type types as scope\n         * @param urls obj can be\n         *             - {urlFetch: 'http://magento...'} for fetching configuration fields through ajax\n         *             - {urlConfirm: 'http://magento...'} for submit configured data through iFrame when clicked confirm button\n         *             - {urlSubmit: 'http://magento...'} for submit configured data through iFrame\n         */\n        addListType: function (type, urls) {\n            if ('undefined' == typeof this.listTypes[type]) {\n                this.listTypes[type] = {};\n            }\n            Object.extend(this.listTypes[type], urls);\n\n            return this;\n        },\n\n        /**\n         * Adds complex list type - that is used to submit several list types at once\n         * Only urlSubmit is possible for this list type\n         * example: addComplexListType(['wishlist', 'product_list'], 'http://magento...')\n         *\n         * @param type types as scope\n         * @param urls obj can be\n         *             - {urlSubmit: 'http://magento...'} for submit configured data through iFrame\n         * @return type string\n         */\n        addComplexListType: function (types, urlSubmit) {\n            var type = this._generateListTypeId();\n\n            this.listTypes[type] = {};\n            this.listTypes[type].complexTypes = types;\n            this.listTypes[type].urlSubmit = urlSubmit;\n\n            return type;\n        },\n\n        /**\n         * Add filter of items\n         *\n         * @param listType scope name\n         * @param itemsFilter\n         */\n        addItemsFilter: function (listType, itemsFilter) {\n            if (!listType || !itemsFilter) {\n                return false;\n            }\n\n            if ('undefined' == typeof this.itemsFilter[listType]) {\n                this.itemsFilter[listType] = [];\n            }\n            this.itemsFilter[listType] = this.itemsFilter[listType].concat(itemsFilter);\n\n            return this;\n        },\n\n        /**\n         * Returns id of block where configuration for an item is stored\n         *\n         * @param listType scope name\n         * @param itemId\n         * @return string\n         */\n        _getConfirmedBlockId: function (listType, itemId) {\n            return this.blockConfirmed.id + '[' + listType + '][' + itemId + ']';\n        },\n\n        /**\n         * Checks whether item has some configuration fields\n         *\n         * @param listType scope name\n         * @param itemId\n         * @return bool\n         */\n        itemConfigured: function (listType, itemId) {\n            var confirmedBlockId = this._getConfirmedBlockId(listType, itemId);\n            var itemBlock = $(confirmedBlockId);\n\n            return !!(itemBlock && itemBlock.innerHTML);\n        },\n\n        /**\n         * Show configuration fields of item, if it not found then get it through ajax\n         *\n         * @param listType scope name\n         * @param itemId\n         */\n        showItemConfiguration: function (listType, itemId) {\n            if (!listType || !itemId) {\n                return false;\n            }\n\n            this.initialize();\n            this.current.listType = listType;\n            this.current.itemId = itemId;\n            this.confirmedCurrentId = this._getConfirmedBlockId(listType, itemId);\n\n            if (!this.itemConfigured(listType, itemId)) {\n                this._requestItemConfiguration(listType, itemId);\n            } else {\n                this._processFieldsData('item_restore');\n                this._showWindow();\n            }\n        },\n\n        /**\n         * Get configuration fields of product through ajax and show them\n         *\n         * @param listType scope name\n         * @param itemId\n         */\n        _requestItemConfiguration: function (listType, itemId) {\n            if (!this.listTypes[listType].urlFetch) {\n                return false;\n            }\n            var url = this.listTypes[listType].urlFetch;\n\n            if (url) {\n                new Ajax.Request(url, {\n                    parameters: {\n                        id: itemId\n                    },\n                    onSuccess: function (transport) {\n                        var response = transport.responseText;\n\n                        if (response.isJSON()) {\n                            response = response.evalJSON();\n\n                            if (response.error) {\n                                this.blockMsg.show();\n                                this.blockMsgError.innerHTML = response.message;\n                                if(this.blockCancelBtn) {\n                                    this.blockCancelBtn.hide();\n                                }\n                                this.setConfirmCallback(listType, null);\n                                this._showWindow();\n                            }\n                        } else if (response) {\n                            response += '';\n                            this.blockFormFields.update(response);\n\n                            // Add special div to hold mage data, e.g. scripts to execute on every popup show\n                            var mageData = {};\n                            var scripts = response.extractScripts();\n\n                            mageData.scripts = scripts;\n\n                            var scriptHolder = new Element('div', {\n                                'style': 'display:none'\n                            });\n\n                            scriptHolder.mageData = mageData;\n                            this.blockFormFields.insert(scriptHolder);\n\n                            // Show window\n                            this._showWindow();\n                        }\n                    }.bind(this)\n                });\n            }\n        },\n\n        /**\n         * Triggered on confirm button click\n         * Do submit configured data through iFrame if needed\n         */\n        onConfirmBtn: function () {\n            if (jQuery(this.blockForm).valid()) {\n                if (this.listTypes[this.current.listType].urlConfirm) {\n                    this.submit();\n                } else {\n                    this._processFieldsData('item_confirm');\n                    this._closeWindow();\n\n                    if (Object.isFunction(this.confirmCallback[this.current.listType])) {\n                        this.confirmCallback[this.current.listType]();\n                    }\n                }\n            }\n\n            return this;\n        },\n\n        /**\n         * Triggered on cancel button click\n         */\n        onCancelBtn: function () {\n            this._closeWindow();\n\n            if (Object.isFunction(this.cancelCallback[this.current.listType])) {\n                this.cancelCallback[this.current.listType]();\n            }\n\n            return this;\n        },\n\n        /**\n         * Submit configured data through iFrame\n         *\n         * @param listType scope name\n         */\n        submit: function (listType) {\n            // prepare data\n            if (listType) {\n                this.current.listType = listType;\n                this.current.itemId = null;\n            }\n            var urlConfirm = this.listTypes[this.current.listType].urlConfirm;\n            var urlSubmit = this.listTypes[this.current.listType].urlSubmit;\n\n            if (!urlConfirm && !urlSubmit) {\n                return false;\n            }\n\n            if (urlConfirm) {\n                this.blockForm.action = urlConfirm;\n                this.addFields([new Element('input', {\n                    type: 'hidden', name: 'id', value: this.current.itemId\n                })]);\n            } else {\n                this.blockForm.action = urlSubmit;\n\n                var complexTypes = this.listTypes[this.current.listType].complexTypes;\n\n                if (complexTypes) {\n                    this.addFields([new Element('input', {\n                        type: 'hidden', name: 'configure_complex_list_types', value: complexTypes.join(',')\n                    })]);\n                }\n\n                this._processFieldsData('current_confirmed_to_form');\n\n                // Disable item controls that duplicate added fields (e.g. sometimes qty controls can intersect)\n                // so they won't be submitted\n                var tagNames = ['input', 'select', 'textarea'];\n\n                var names = {}; // Map of added field names\n\n                for (var i = 0, len = tagNames.length; i < len; i++) {\n                    var tagName = tagNames[i];\n                    var elements = this.blockFormAdd.getElementsByTagName(tagName);\n\n                    for (var index = 0, elLen = elements.length; index < elLen; index++) {\n                        names[elements[index].name] = true;\n                    }\n                }\n\n                for (var i = 0, len = tagNames.length; i < len; i++) {\n                    var tagName = tagNames[i];\n                    var elements = this.blockFormConfirmed.getElementsByTagName(tagName);\n\n                    for (var index = 0, elLen = elements.length; index < elLen; index++) {\n                        var element = elements[index];\n\n                        if (names[element.name]) {\n                            element.setAttribute('configure_disabled', 1);\n                            element.setAttribute('configure_prev_disabled', element.disabled ? 1 : 0);\n                            element.disabled = true;\n                        } else {\n                            element.setAttribute('configure_disabled', 0);\n                        }\n                    }\n                }\n            }\n            // do submit\n            if (Object.isFunction(this.beforeSubmitCallback[this.current.listType])) {\n                this.beforeSubmitCallback[this.current.listType]();\n            }\n            this.blockForm.submit();\n\n            // Show loader\n            jQuery(this.blockForm).trigger('processStart');\n\n            return this;\n        },\n\n        /**\n         * Add dynamically additional fields for form\n         *\n         * @param fields\n         */\n        addFields: function (fields) {\n            fields.each(function (elm) {\n                this.blockFormAdd.insert(elm);\n            }.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Triggered when form was submitted and iFrame was loaded. Get response from iFrame and handle it\n         */\n        onLoadIFrame: function () {\n            this.blockFormConfirmed.select('[configure_disabled=1]').each(function (element) {\n                element.disabled = element.getAttribute('configure_prev_disabled') == '1';\n            });\n\n            this._processFieldsData('form_confirmed_to_confirmed');\n\n            var response = this.blockIFrame.contentWindow[this.iFrameJSVarname];\n\n            if (response && 'object' == typeof response) {\n                if (this.listTypes[this.current.listType].urlConfirm) {\n                    if (response.ok) {\n                        this._closeWindow();\n                        this.clean('current');\n                    } else if (response.error) {\n                        this.showItemConfiguration(this.current.listType, this.current.itemId);\n                        this.blockMsg.show();\n                        this.blockMsgError.innerHTML = response.message;\n                        this._showWindow();\n\n                        jQuery(this.blockForm).trigger('processStop');\n                        return false;\n                    }\n                }\n\n                if (Object.isFunction(this.onLoadIFrameCallback[this.current.listType])) {\n                    this.onLoadIFrameCallback[this.current.listType](response);\n                }\n                document.fire(this.current.listType + ':afterIFrameLoaded');\n            }\n            // Hide loader\n            jQuery(this.blockForm).trigger('processStop');\n\n            this.clean('current');\n            this.initialize();\n        },\n\n        /**\n         * Helper for fetching content from iFrame\n         */\n        _getIFrameContent: function () {\n            var content = this.blockIFrame.contentWindow || this.blockIFrame.contentDocument;\n\n            if (content.document) {\n                content = content.document;\n            }\n\n            return content;\n        },\n\n        /**\n         * Helper to find qty of currently confirmed item\n         */\n        getCurrentConfirmedQtyElement: function () {\n            var elms = $(this.confirmedCurrentId).getElementsByTagName('input');\n\n            for (var i = 0; i < elms.length; i++) {\n                if (elms[i].name == 'qty') {\n                    return elms[i];\n                }\n            }\n        },\n\n        /**\n         * Helper to find select element of currently confirmed item\n         */\n        getCurrentConfirmedSelectElement: function () {\n            return $(this.confirmedCurrentId).getElementsByTagName('select');\n        },\n\n        /**\n         * Helper to find qty of active form\n         */\n        getCurrentFormQtyElement: function () {\n            var elms = this.blockFormFields.getElementsByTagName('input');\n\n            for (var i = 0; i < elms.length; i++) {\n                if (elms[i].name == 'qty') {\n                    return elms[i];\n                }\n            }\n        },\n\n        /**\n         * Show configuration window\n         */\n        _showWindow: function () {\n            this.dialog.modal('openModal');\n            //this._toggleSelectsExceptBlock(false);\n\n            if (Object.isFunction(this.showWindowCallback[this.current.listType])) {\n                this.showWindowCallback[this.current.listType]();\n            }\n        },\n\n        /**\n         * Close configuration window\n         */\n        _closeWindow: function () {\n            this.dialog.modal('closeModal');\n            //this.blockWindow.style.display = 'none';\n            //this.clean('window');\n        },\n\n        /**\n         * Attach callback function triggered when confirm button was clicked\n         *\n         * @param confirmCallback\n         */\n        setConfirmCallback: function (listType, confirmCallback) {\n            this.confirmCallback[listType] = confirmCallback;\n\n            return this;\n        },\n\n        /**\n         * Attach callback function triggered when cancel button was clicked\n         *\n         * @param cancelCallback\n         */\n        setCancelCallback: function (listType, cancelCallback) {\n            this.cancelCallback[listType] = cancelCallback;\n\n            return this;\n        },\n\n        /**\n         * Attach callback function triggered when iFrame was loaded\n         *\n         * @param onLoadIFrameCallback\n         */\n        setOnLoadIFrameCallback: function (listType, onLoadIFrameCallback) {\n            this.onLoadIFrameCallback[listType] = onLoadIFrameCallback;\n\n            return this;\n        },\n\n        /**\n         * Attach callback function triggered when iFrame was loaded\n         *\n         * @param showWindowCallback\n         */\n        setShowWindowCallback: function (listType, showWindowCallback) {\n            this.showWindowCallback[listType] = showWindowCallback;\n\n            return this;\n        },\n\n        /**\n         * Attach callback function triggered before submitting form\n         *\n         * @param beforeSubmitCallback\n         */\n        setBeforeSubmitCallback: function (listType, beforeSubmitCallback) {\n            this.beforeSubmitCallback[listType] = beforeSubmitCallback;\n\n            return this;\n        },\n\n        /**\n         * Clean object data\n         *\n         * @param method can be 'all' or 'current'\n         */\n        clean: function (method) {\n            var listInfo = null;\n            var listTypes = null;\n            var removeConfirmed = function (listTypes) {\n                this.blockConfirmed.childElements().each(function (elm) {\n                    for (var i = 0, len = listTypes.length; i < len; i++) {\n                        var pattern = this.blockConfirmed.id + '[' + listTypes[i] + ']';\n\n                        if (elm.id.indexOf(pattern) == 0) {\n                            elm.remove();\n                            break;\n                        }\n                    }\n                }.bind(this));\n            }.bind(this);\n\n            switch (method) {\n                case 'current':\n                    listInfo = this.listTypes[this.current.listType];\n                    listTypes = [this.current.listType];\n\n                    if (listInfo && listInfo.complexTypes) {\n                        listTypes = listTypes.concat(listInfo.complexTypes);\n                    }\n                    removeConfirmed(listTypes);\n                    break;\n\n                case 'window':\n                    this.blockFormFields.update();\n                    this.blockMsg.hide();\n                    this.blockMsgError.update();\n                    if(this.blockCancelBtn) {\n                        this.blockCancelBtn.show();\n                    }\n                    break;\n                default:\n                    // search in list types for its cleaning\n                    if (this.listTypes[method]) {\n                        listInfo = this.listTypes[method];\n                        listTypes = [method];\n\n                        if (listInfo.complexTypes) {\n                            listTypes = listTypes.concat(listInfo.complexTypes);\n                        }\n                        removeConfirmed(listTypes);\n                        // clean all\n                    } else if (!method) {\n                        this.current = $H({});\n                        this.blockConfirmed.update();\n                        this.blockFormFields.update();\n                        this.blockMsg.hide();\n                        this.blockMsgError.update();\n                        if(this.blockCancelBtn) {\n                            this.blockCancelBtn.show();\n                        }\n                    }\n                    break;\n            }\n            this._getIFrameContent().body.innerHTML = '';\n            this.blockIFrame.contentWindow[this.iFrameJSVarname] = {};\n            this.blockFormAdd.update();\n            this.blockFormConfirmed.update();\n            this.blockForm.action = '';\n\n            return this;\n        },\n\n        /**\n         * Process fields data: save, restore, move saved to form and back\n         *\n         * @param method can be 'item_confirm', 'item_restore', 'current_confirmed_to_form', 'form_confirmed_to_confirmed'\n         */\n        _processFieldsData: function (method) {\n            var self = this;\n\n            /**\n             * Internal function for rename fields names of some list type\n             * if listType is not specified, then it won't be added as prefix to all names\n             *\n             * @param method can be 'current_confirmed_to_form', 'form_confirmed_to_confirmed'\n             * @param blockItem\n             */\n            var _renameFields = function (method, blockItem, listType) {\n                var pattern           = null;\n                var patternFlat       = null;\n                var patternPrefix     = RegExp('\\\\s', 'g');\n                var replacement       = null;\n                var replacementFlat   = null;\n                var replacementPrefix = '_';\n                var scopeArr          = blockItem.id.match(/.*\\[\\w+\\]\\[([^\\]]+)\\]$/);\n                var itemId            = scopeArr[1];\n\n                if (method == 'current_confirmed_to_form') {\n                    pattern         = RegExp('(\\\\w+)(\\\\[?)');\n                    patternFlat     = RegExp('(\\\\w+)');\n                    replacement     = 'item[' + itemId + '][$1]$2';\n                    replacementFlat = 'item_' + itemId + '_$1';\n\n                    if (listType) {\n                        replacement = 'list[' + listType + '][item][' + itemId + '][$1]$2';\n                        replacementFlat = 'list_' + listType + '_' + replacementFlat;\n                    }\n                } else if (method == 'form_confirmed_to_confirmed') {\n                    var stPattern = 'item\\\\[' + itemId + '\\\\]\\\\[(\\\\w+)\\\\](.*)';\n                    var stPatternFlat = 'item_' + itemId + '_(\\\\w+)';\n\n                    if (listType) {\n                        stPattern = 'list\\\\[' + listType + '\\\\]\\\\[item\\\\]\\\\[' + itemId + '\\\\]\\\\[(\\\\w+)\\\\](.*)';\n                        stPatternFlat = 'list_' + listType + '_' + stPatternFlat;\n                    }\n                    pattern         = new RegExp(stPattern);\n                    patternFlat     = new RegExp(stPatternFlat);\n                    replacement     = '$1$2';\n                    replacementFlat = '$1';\n                } else {\n                    return false;\n                }\n                var rename = function (elms) {\n                    for (var i = 0; i < elms.length; i++) {\n                        if (elms[i].name && elms[i].type == 'file') {\n                            var prefixName = 'options[files_prefix]',\n                                prefixValue = 'item_' + itemId + '_';\n\n                            self.blockFormFields.insert(new Element('input', {\n                                type: 'hidden',\n                                name: prefixName.replace(pattern, replacement),\n                                value: prefixValue.replace(patternPrefix, replacementPrefix)\n                            }));\n                            elms[i].name = elms[i].name.replace(patternFlat, replacementFlat);\n                        } else if (elms[i].name) {\n                            elms[i].name = elms[i].name.replace(pattern, replacement);\n                        }\n                    }\n                };\n\n                rename(blockItem.getElementsByTagName('input'));\n                rename(blockItem.getElementsByTagName('select'));\n                rename(blockItem.getElementsByTagName('textarea'));\n            };\n\n            switch (method) {\n                case 'item_confirm':\n                    if (!$(this.confirmedCurrentId)) {\n                        this.blockConfirmed.insert(new Element('div', {\n                            id: this.confirmedCurrentId\n                        }));\n                    } else {\n                        $(this.confirmedCurrentId).update();\n                    }\n                    this.blockFormFields.childElements().each(function (elm) {\n                        $(this.confirmedCurrentId).insert(elm);\n                    }.bind(this));\n                    break;\n\n                case 'item_restore':\n                    this.blockFormFields.update();\n\n                    // clone confirmed to form\n                    var mageData = null;\n\n                    $(this.confirmedCurrentId).childElements().each(function (elm) {\n                        var cloned = elm.cloneNode(true);\n\n                        if (elm.mageData) {\n                            cloned.mageData = elm.mageData;\n                            mageData = elm.mageData;\n                        }\n                        this.blockFormFields.insert(cloned);\n                    }.bind(this));\n\n                    // get confirmed values\n                    var fieldsValue = {};\n                    var getConfirmedValues = function (elms) {\n                        for (var i = 0; i < elms.length; i++) {\n                            if (elms[i].name) {\n                                if ('undefined' == typeof fieldsValue[elms[i].name]) {\n                                    fieldsValue[elms[i].name] = {};\n                                }\n\n                                if (elms[i].type == 'checkbox') {\n                                    fieldsValue[elms[i].name][elms[i].value] = elms[i].checked;\n                                } else if (elms[i].type == 'radio') {\n                                    if (elms[i].checked) {\n                                        fieldsValue[elms[i].name] = elms[i].value;\n                                    }\n                                } else {\n                                    fieldsValue[elms[i].name] = Form.Element.getValue(elms[i]);\n                                }\n                            }\n                        }\n                    };\n\n                    getConfirmedValues($(this.confirmedCurrentId).getElementsByTagName('input'));\n                    getConfirmedValues($(this.confirmedCurrentId).getElementsByTagName('select'));\n                    getConfirmedValues($(this.confirmedCurrentId).getElementsByTagName('textarea'));\n\n                    // restore confirmed values\n                    var restoreConfirmedValues = function (elms) {\n                        for (var i = 0; i < elms.length; i++) {\n                            if ('undefined' != typeof fieldsValue[elms[i].name]) {\n                                if (elms[i].type != 'file') {\n                                    if (elms[i].type == 'checkbox') {\n                                        elms[i].checked = fieldsValue[elms[i].name][elms[i].value];\n                                    } else if (elms[i].type == 'radio') {\n                                        if (elms[i].value == fieldsValue[elms[i].name]) {\n                                            elms[i].checked = true;\n                                        }\n                                    } else {\n                                        elms[i].setValue(fieldsValue[elms[i].name]);\n                                    }\n                                }\n                            }\n                        }\n                    };\n\n                    restoreConfirmedValues(this.blockFormFields.getElementsByTagName('input'));\n                    restoreConfirmedValues(this.blockFormFields.getElementsByTagName('select'));\n                    restoreConfirmedValues(this.blockFormFields.getElementsByTagName('textarea'));\n\n                    // Execute scripts\n                    if (mageData && mageData.scripts) {\n                        this.restorePhase = true;\n\n                        try {\n                            mageData.scripts.map(function (script) {\n                                return eval(script);\n                            });\n                        } catch (e) {\n\n                        }\n                        this.restorePhase = false;\n                    }\n                    break;\n\n                case 'current_confirmed_to_form':\n                    var allowedListTypes = {};\n\n                    allowedListTypes[this.current.listType] = true;\n                    var listInfo = this.listTypes[this.current.listType];\n\n                    if (listInfo.complexTypes) {\n                        for (var i = 0, len = listInfo.complexTypes.length; i < len; i++) {\n                            allowedListTypes[listInfo.complexTypes[i]] = true;\n                        }\n                    }\n\n                    this.blockFormConfirmed.update();\n                    this.blockConfirmed.childElements().each(function (blockItem) {\n                        var scopeArr    = blockItem.id.match(/.*\\[(\\w+)\\]\\[([^\\]]+)\\]$/);\n                        var listType    = scopeArr[1];\n                        var itemId    = scopeArr[2];\n\n                        if (allowedListTypes[listType] && (!this.itemsFilter[listType] ||\n                            this.itemsFilter[listType].indexOf(itemId) != -1)) {\n                            _renameFields(method, blockItem, listInfo.complexTypes ? listType : null);\n                            this.blockFormConfirmed.insert(blockItem);\n                        }\n                    }.bind(this));\n                    break;\n\n                case 'form_confirmed_to_confirmed':\n                    var listInfo = this.listTypes[this.current.listType];\n\n                    this.blockFormConfirmed.childElements().each(function (blockItem) {\n                        var scopeArr = blockItem.id.match(/.*\\[(\\w+)\\]\\[([^\\]]+)\\]$/);\n                        var listType = scopeArr[1];\n\n                        _renameFields(method, blockItem, listInfo.complexTypes ? listType : null);\n                        this.blockConfirmed.insert(blockItem);\n                    }.bind(this));\n                    break;\n            }\n        },\n\n        /**\n         * Check if qty selected correctly\n         *\n         * @param object element\n         * @param object event\n         */\n        changeOptionQty: function (element, event) {\n            var checkQty = true;\n\n            if ('undefined' != typeof event) {\n                if (event.keyCode == 8 || event.keyCode == 46) {\n                    checkQty = false;\n                }\n            }\n\n            if (checkQty && (Number(element.value) <= 0 || isNaN(Number(element.value)))) {\n                element.value = 1;\n            }\n        }\n    };\n\n    productConfigure = new ProductConfigure();\n    jQuery(document).trigger('productConfigure:inited');\n    jQuery(document).data('productConfigureInited', true);\n});\n","Magento_Catalog/catalog/product/edit/attribute.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/mage',\n    'validation'\n], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element).mage('form').validation({\n            validationUrl: config.validationUrl\n        });\n    };\n});\n","Magento_Catalog/component/file-type-field.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Checks is relevant value\n         *\n         * @param {String} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if (value === 'file') {\n                this.disabled(false);\n                this.visible(true);\n\n                return true;\n            }\n\n            this.reset();\n            this.disabled(true);\n            this.visible(false);\n\n            return false;\n        }\n    });\n});\n","Magento_Catalog/component/image-size-field.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/lib/validation/utils',\n    'Magento_Ui/js/form/element/abstract',\n    'Magento_Ui/js/lib/validation/validator',\n    'mage/translate'\n], function ($, utils, Abstract, validator) {\n    'use strict';\n\n    validator.addRule(\n        'validate-image-size-range',\n        function (value) {\n            var dataAttrRange = /^(\\d+)x(\\d+)$/,\n                m;\n\n            if (utils.isEmptyNoTrim(value)) {\n                return true;\n            }\n\n            m = dataAttrRange.exec(value);\n\n            return !!(m &&  m[1] > 0 && m[2] > 0);\n        },\n        $.mage.__('This value does not follow the specified format (for example, 200X300).')\n    );\n\n    return Abstract.extend({\n\n        /**\n         * Checks for relevant value\n         *\n         * @returns {Boolean}\n         */\n        isRangeCorrect: function () {\n            return validator('validate-image-size-range', this.value()).passed;\n        }\n    });\n});\n","Magento_Catalog/component/select-type-grid.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows'\n], function ($, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Checks is relevant value\n         *\n         * @param {String} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if ($.inArray(value, ['drop_down', 'radio', 'checkbox', 'multiple']) !== -1) {\n                this.disabled(false);\n                this.visible(true);\n\n                return true;\n            }\n\n            this.reset();\n            this.disabled(true);\n            this.visible(false);\n\n            return false;\n        }\n    });\n});\n","Magento_Catalog/component/static-type-container.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/components/group'\n], function ($, Group) {\n    'use strict';\n\n    return Group.extend({\n\n        /**\n         * Checks is relevant value\n         *\n         * @param {String} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if ($.inArray(value, ['field', 'area', 'file', 'date', 'date_time', 'time']) !== -1) {\n                this.visible(true);\n\n                return true;\n            }\n\n            this.visible(false);\n\n            return false;\n        }\n    });\n});\n","Magento_Catalog/component/static-type-input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiRegistry',\n    'Magento_Ui/js/form/element/abstract'\n], function (registry, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            parentOption: null\n        },\n\n        /**\n         * Initialize component.\n         *\n         * @returns {Element}\n         */\n        initialize: function () {\n            return this\n                ._super()\n                .initLinkToParent();\n        },\n\n        /**\n         * Cache link to parent component - option holder.\n         *\n         * @returns {Element}\n         */\n        initLinkToParent: function () {\n            var pathToParent = this.parentName.replace(/(\\.[^.]*){2}$/, '');\n\n            this.parentOption = registry.async(pathToParent);\n            this.value() && this.parentOption('label', this.value());\n\n            return this;\n        },\n\n        /**\n         * On value change handler.\n         *\n         * @param {String} value\n         */\n        onUpdate: function (value) {\n            this.parentOption(function (component) {\n                component.set('label', value ? value : component.get('headerLabel'));\n            });\n\n            return this._super();\n        }\n    });\n});\n","Magento_Catalog/component/static-type-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/element/select'\n], function ($, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Checks is relevant value\n         *\n         * @param {String} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if (!value || $.inArray(value, ['drop_down', 'radio', 'checkbox', 'multiple']) !== -1) {\n                this.reset();\n                this.disabled(true);\n\n                return false;\n            }\n\n            this.disabled(false);\n\n            return true;\n        }\n    });\n});\n","Magento_Catalog/component/text-type-field.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/element/abstract'\n], function ($, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Checks for relevant value\n         *\n         * @param {*} value\n         * @returns {Boolean}\n         */\n        isRelevant: function (value) {\n            if ($.inArray(value, ['field', 'area']) !== -1) {\n                this.disabled(false);\n                this.visible(true);\n\n                return true;\n            }\n\n            this.reset();\n            this.disabled(true);\n            this.visible(false);\n\n            return false;\n        }\n    });\n});\n","Magento_Catalog/js/bundle-proxy-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n * @deprecated since version 2.2.0\n */\ndefine([\n    'Magento_Ui/js/form/components/button',\n    'uiRegistry',\n    'underscore'\n], function (Button, registry, _) {\n    'use strict';\n\n    return Button.extend({\n        defaults: {\n            currentRecordNamespace: 'bundle_current_record',\n            listingDataProvider: '',\n            value: [],\n            imports: {\n                currentRecordName: '${ $.provider }:${ $.currentRecordNamespace }',\n                listingData: '${ $.provider }:${ $.listingDataProvider }'\n            },\n            links: {\n                value: '${ $.provider }:${ $.dataScope }'\n            },\n            listens: {\n                listingData: 'setListingData'\n            }\n        },\n\n        /**\n         * Initializes component.\n         *\n         * @returns {Object} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initSource();\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'value',\n                    'listingData'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Calls 'destroy' of parent and\n         * clear listing provider source\n         *\n         * @returns {Object} Chainable.\n         */\n        destroy: function () {\n            this._super();\n            this.source.set(this.listingDataProvider, []);\n\n            return this;\n        },\n\n        /**\n         * Call parent \"action\" method\n         * and set new data to record and listing.\n         *\n         * @returns {Object} Chainable.\n         */\n\n        action: function () {\n            this._super();\n            this.source.set(this.currentRecordNamespace, this.name);\n            this.source.set(this.listingDataProvider, this.value());\n\n            return this;\n        },\n\n        /**\n         * Init current source.\n         *\n         * @returns {Object} Chainable.\n         */\n        initSource: function () {\n            if (!_.isFunction(this.source)) {\n                this.source = registry.get(this.provider);\n            }\n\n            return this;\n        },\n\n        /**\n         * Set data to listing source.\n         *\n         * @returns {Object} Chainable.\n         */\n        setListingData: function (data) {\n            if (this.name === this.currentRecordName) {\n                this.source.set(this.dataScope, data);\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_Catalog/js/category-checkbox-tree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global Ext, varienWindowOnload, varienElementMethods */\n\ndefine([\n    'jquery',\n    'prototype',\n    'extjs/ext-tree-checkbox',\n    'mage/adminhtml/form'\n], function (jQuery) {\n    'use strict';\n\n    return function (config) {\n        var tree,\n            options = {\n                dataUrl: config.dataUrl,\n                divId: config.divId,\n                rootVisible: config.rootVisible,\n                useAjax: config.useAjax,\n                currentNodeId: config.currentNodeId,\n                jsFormObject: window[config.jsFormObject],\n                name: config.name,\n                checked: config.checked,\n                allowDrop: config.allowDrop,\n                rootId: config.rootId,\n                expanded: config.expanded,\n                categoryId: config.categoryId,\n                treeJson: config.treeJson\n            },\n            data = {},\n            parameters = {},\n            root = {},\n            key = '';\n\n        /**\n         * Fix ext compatibility with prototype 1.6\n         */\n        Ext.lib.Event.getTarget = function (e) {\n            var ee = e.browserEvent || e;\n\n            return ee.target ? Event.element(ee) : null;\n        };\n\n        /**\n         * @param {Object} el\n         * @param {Object} nodeConfig\n         */\n        Ext.tree.TreePanel.Enhanced = function (el, nodeConfig) {\n            Ext.tree.TreePanel.Enhanced.superclass.constructor.call(this, el, nodeConfig);\n        };\n\n        Ext.extend(Ext.tree.TreePanel.Enhanced, Ext.tree.TreePanel, {\n            /**\n             * @param {Object} treeConfig\n             * @param {Boolean} firstLoad\n             */\n            loadTree: function (treeConfig, firstLoad) {\n                parameters = treeConfig.parameters,\n                    data = treeConfig.data,\n                    root = new Ext.tree.TreeNode(parameters);\n\n                if (typeof parameters.rootVisible !== 'undefined') {\n                    this.rootVisible = parameters.rootVisible * 1;\n                }\n\n                this.nodeHash = {};\n                this.setRootNode(root);\n\n                if (firstLoad) {\n                    this.addListener('click', this.categoryClick.createDelegate(this));\n                }\n\n                this.loader.buildCategoryTree(root, data);\n                this.el.dom.innerHTML = '';\n                // render the tree\n                this.render();\n            },\n\n            /**\n             * @param {Object} node\n             */\n            categoryClick: function (node) {\n                node.getUI().check(!node.getUI().checked());\n            }\n        });\n\n        jQuery(function () {\n            var categoryLoader = new Ext.tree.TreeLoader({\n                dataUrl: config.dataUrl\n            });\n\n            /**\n             * @param {Object} response\n             * @param {Object} parent\n             * @param {Function} callback\n             */\n            categoryLoader.processResponse = function (response, parent, callback) {\n                config = JSON.parse(response.responseText);\n\n                this.buildCategoryTree(parent, config);\n\n                if (typeof callback === 'function') {\n                    callback(this, parent);\n                }\n            };\n\n            /**\n             * @param {Object} nodeConfig\n             * @returns {Object}\n             */\n            categoryLoader.createNode = function (nodeConfig) {\n                var node;\n\n                nodeConfig.uiProvider = Ext.tree.CheckboxNodeUI;\n\n                if (nodeConfig.children && !nodeConfig.children.length) {\n                    delete nodeConfig.children;\n                    node = new Ext.tree.AsyncTreeNode(nodeConfig);\n                } else {\n                    node = new Ext.tree.TreeNode(nodeConfig);\n                }\n\n                return node;\n            };\n\n            /**\n             * @param {Object} parent\n             * @param {Object} nodeConfig\n             * @param {Integer} i\n             */\n            categoryLoader.processCategoryTree = function (parent, nodeConfig, i) {\n                var node,\n                    _node = {};\n\n                nodeConfig[i].uiProvider = Ext.tree.CheckboxNodeUI;\n\n                _node = Object.clone(nodeConfig[i]);\n\n                if (_node.children && !_node.children.length) {\n                    delete _node.children;\n                    node = new Ext.tree.AsyncTreeNode(_node);\n                } else {\n                    node = new Ext.tree.TreeNode(nodeConfig[i]);\n                }\n                parent.appendChild(node);\n                node.loader = node.getOwnerTree().loader;\n\n                if (_node.children) {\n                    categoryLoader.buildCategoryTree(node, _node.children);\n                }\n            };\n\n            /**\n             * @param {Object} parent\n             * @param {Object} nodeConfig\n             * @returns {void}\n             */\n            categoryLoader.buildCategoryTree = function (parent, nodeConfig) {\n                var i = 0;\n\n                if (!nodeConfig) {\n                    return null;\n                }\n\n                if (parent && nodeConfig && nodeConfig.length) {\n                    for (i; i < nodeConfig.length; i++) {\n                        categoryLoader.processCategoryTree(parent, nodeConfig, i);\n                    }\n                }\n            };\n\n            /**\n             *\n             * @param {Object} hash\n             * @param {Object} node\n             * @returns {Object}\n             */\n            categoryLoader.buildHashChildren = function (hash, node) {\n                var i = 0,\n                    len;\n\n                if (node.childNodes.length > 0 || node.loaded === false && node.loading === false) {\n                    hash.children = [];\n\n                    for (i, len = node.childNodes.length; i < len; i++) {\n                        hash.children = hash.children ? hash.children : [];\n                        hash.children.push(this.buildHash(node.childNodes[i]));\n                    }\n                }\n\n                return hash;\n            };\n\n            /**\n             * @param {Object} node\n             * @returns {Object}\n             */\n            categoryLoader.buildHash = function (node) {\n                var hash = {};\n\n                hash = this.toArray(node.attributes);\n\n                return categoryLoader.buildHashChildren(hash, node);\n            };\n\n            /**\n             * @param {Object} attributes\n             * @returns {Object}\n             */\n            categoryLoader.toArray = function (attributes) {\n                data = {};\n\n                for (key in attributes) {\n\n                    if (attributes[key]) {\n                        data[key] = attributes[key];\n                    }\n                }\n\n                return data;\n            };\n\n            categoryLoader.on('beforeload', function (treeLoader, node) {\n                treeLoader.baseParams.id = node.attributes.id;\n                treeLoader.baseParams.selected = options.jsFormObject.updateElement.value;\n            });\n\n            categoryLoader.on('load', function () {\n                varienWindowOnload();\n            });\n\n            tree = new Ext.tree.TreePanel.Enhanced(options.divId, {\n                animate: false,\n                loader: categoryLoader,\n                enableDD: false,\n                containerScroll: true,\n                selModel: new Ext.tree.CheckNodeMultiSelectionModel(),\n                rootVisible: options.rootVisible,\n                useAjax: options.useAjax,\n                currentNodeId: options.currentNodeId,\n                addNodeTo: false,\n                rootUIProvider: Ext.tree.CheckboxNodeUI\n            });\n\n            tree.on('check', function (node) {\n                options.jsFormObject.updateElement.value = this.getChecked().join(', ');\n                varienElementMethods.setHasChanges(node.getUI().checkbox);\n            }, tree);\n\n            // set the root node\n            //jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            parameters = {\n                text: options.name,\n                draggable: false,\n                checked: options.checked,\n                uiProvider: Ext.tree.CheckboxNodeUI,\n                allowDrop: options.allowDrop,\n                id: options.rootId,\n                expanded: options.expanded,\n                category_id: options.categoryId\n            };\n            //jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n            tree.loadTree({\n                parameters: parameters, data: options.treeJson\n            }, true);\n        });\n    };\n});\n","Magento_Catalog/js/category-tree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mageUtils',\n    'jquery/ui',\n    'jquery/jstree/jquery.jstree'\n], function ($, utils) {\n    'use strict';\n\n    $.widget('mage.categoryTree', {\n        options: {\n            url: '',\n            data: [],\n            tree: {\n                core: {\n                    themes: {\n                        dots: false\n                    }\n                }\n            }\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var options = this.options,\n                treeOptions = $.extend(\n                    true,\n                    {},\n                    options.tree,\n                    {\n                        core: {\n                            data: this._convertData(this.options.data).children\n                        }\n                    }\n                );\n\n            this.element.jstree(treeOptions);\n            this.element.on('select_node.jstree', $.proxy(this._selectNode, this));\n        },\n\n        /**\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _selectNode: function (event, data) {\n            var node = data.node;\n\n            if (!node.state.disabled) {\n                window.location = window.location + '/' + node.id;\n            } else {\n                event.preventDefault();\n            }\n        },\n\n        /**\n         * @param {Array} nodes\n         * @returns {Array}\n         * @private\n         */\n        _convertDataNodes: function (nodes) {\n            var nodesData = [];\n\n            nodes.children.forEach(function (node) {\n                nodesData.push(this._convertData(node));\n            }, this);\n\n            return nodesData;\n        },\n\n        /**\n         * @param {Object} node\n         * @return {*}\n         * @private\n         */\n        _convertData: function (node) {\n            var self = this,\n                result;\n\n            if (!node) {\n                return result;\n            }\n            // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            result = {\n                id: node.id,\n                text: utils.unescape(node.name) + ' (' + node.product_count + ')',\n                li_attr: {\n                    class: node.cls + (!!node.disabled ? ' disabled' : '') //eslint-disable-line no-extra-boolean-cast\n                },\n                state: {\n                    disabled: node.disabled,\n                    opened:  !!node.children_count && node.expanded\n                }\n            };\n            // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n            if (node.children) {\n                result.children = [];\n                $.each(node.children, function () {\n                    result.children.push(self._convertData(this));\n                });\n            }\n\n            return result;\n        }\n    });\n\n    return $.mage.categoryTree;\n});\n","Magento_Catalog/js/custom-options-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/ui-select'\n], function ($, _, registry, UiSelect) {\n    'use strict';\n\n    return UiSelect.extend({\n        defaults: {\n            previousGroup: null,\n            groupsConfig: {},\n            valuesMap: {},\n            indexesMap: {},\n            filterPlaceholder: 'ns = ${ $.ns }, parentScope = ${ $.parentScope }'\n        },\n\n        /**\n         * Initialize component.\n         * @returns {Element}\n         */\n        initialize: function () {\n            return this\n                ._super()\n                .initMapping()\n                .updateComponents(this.initialValue, true);\n        },\n\n        /**\n         * Create additional mappings.\n         *\n         * @returns {Element}\n         */\n        initMapping: function () {\n            _.each(this.groupsConfig, function (groupData, group) {\n                _.each(groupData.values, function (value) {\n                    this.valuesMap[value] = group;\n                }, this);\n\n                _.each(groupData.indexes, function (index) {\n                    if (!this.indexesMap[index]) {\n                        this.indexesMap[index] = [];\n                    }\n\n                    this.indexesMap[index].push(group);\n                }, this);\n            }, this);\n\n            return this;\n        },\n\n        /**\n         * Callback that fires when 'value' property is updated.\n         *\n         * @param {String} currentValue\n         * @returns {*}\n         */\n        onUpdate: function (currentValue) {\n            this.updateComponents(currentValue);\n\n            return this._super();\n        },\n\n        /**\n         * Show, hide or clear components based on the current type value.\n         *\n         * @param {String} currentValue\n         * @param {Boolean} isInitialization\n         * @returns {Element}\n         */\n        updateComponents: function (currentValue, isInitialization) {\n            var currentGroup = this.valuesMap[currentValue];\n\n            if (currentGroup !== this.previousGroup) {\n                _.each(this.indexesMap, function (groups, index) {\n                    var template = this.filterPlaceholder + ', index = ' + index,\n                        visible = groups.indexOf(currentGroup) !== -1,\n                        component;\n\n                    switch (index) {\n                        case 'container_type_static':\n                        case 'values':\n                            template = 'ns=' + this.ns +\n                                ', dataScope=' + this.parentScope +\n                                ', index=' + index;\n                            break;\n                    }\n\n                    /*eslint-disable max-depth */\n                    if (isInitialization) {\n                        registry.async(template)(\n                            function (currentComponent) {\n                                currentComponent.visible(visible);\n                            }\n                        );\n                    } else {\n                        component = registry.get(template);\n\n                        if (component) {\n                            component.visible(visible);\n                        }\n                    }\n                }, this);\n\n                this.previousGroup = currentGroup;\n            }\n\n            return this;\n        }\n    });\n});\n","Magento_Catalog/js/custom-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'useDefault',\n    'collapsable',\n    'mage/translate',\n    'mage/backend/validation',\n    'Magento_Ui/js/modal/modal'\n], function ($, mageTemplate, alert) {\n    'use strict';\n\n    $.widget('mage.customOptions', {\n        options: {\n            selectionItemCount: {}\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            this.baseTmpl = mageTemplate('#custom-option-base-template');\n            this.rowTmpl = mageTemplate('#custom-option-select-type-row-template');\n\n            this._initOptionBoxes();\n            this._initSortableSelections();\n            this._bindCheckboxHandlers();\n            this._bindReadOnlyMode();\n            this._addValidation();\n        },\n\n        /**\n         * @private\n         */\n        _addValidation: function () {\n            $.validator.addMethod(\n                'required-option-select', function (value) {\n                    return value !== '';\n                }, $.mage.__('Select type of option.'));\n\n            $.validator.addMethod(\n                'required-option-select-type-rows', function (value, element) {\n                    var optionContainerElm = element.up('div[id*=_type_]'),\n                        selectTypesFlag = false,\n                        selectTypeElements = $('#' + optionContainerElm.id + ' .select-type-title');\n\n                    selectTypeElements.each(function () {\n                        if (!$(this).closest('tr').hasClass('ignore-validate')) {\n                            selectTypesFlag = true;\n                        }\n                    });\n\n                    return selectTypesFlag;\n                }, $.mage.__('Please add rows to option.'));\n        },\n\n        /**\n         * @private\n         */\n        _initOptionBoxes: function () {\n            var syncOptionTitle;\n\n            if (!this.options.isReadonly) {\n                this.element.sortable({\n                    axis: 'y',\n                    handle: '[data-role=draggable-handle]',\n                    items: '#product_options_container_top > div',\n                    update: this._updateOptionBoxPositions,\n                    tolerance: 'pointer'\n                });\n            }\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            syncOptionTitle = function (event) {\n                var currentValue = $(event.target).val(),\n                    optionBoxTitle = $(\n                        '.admin__collapsible-title > span',\n                        $(event.target).closest('.fieldset-wrapper')\n                    ),\n                    newOptionTitle = $.mage.__('New Option');\n\n                optionBoxTitle.text(currentValue === '' ? newOptionTitle : currentValue);\n            };\n            this._on({\n                /**\n                 * Reset field value to Default\n                 */\n                'click .use-default-label': function (event) {\n                    $(event.target).closest('label').find('input').prop('checked', true).trigger('change');\n                },\n\n                /**\n                 * Remove custom option or option row for 'select' type of custom option\n                 */\n                'click button[id^=product_option_][id$=_delete]': function (event) {\n                    var element = $(event.target).closest('#product_options_container_top > div.fieldset-wrapper,tr');\n\n                    if (element.length) {\n                        $('#product_' + element.attr('id').replace('product_', '') + '_is_delete').val(1);\n                        element.addClass('ignore-validate').hide();\n                        this.refreshSortableElements();\n                    }\n                },\n\n                /**\n                 * Minimize custom option block\n                 */\n                'click #product_options_container_top [data-target$=-content]': function () {\n                    if (this.options.isReadonly) {\n                        return false;\n                    }\n                },\n\n                /**\n                 * Add new custom option\n                 */\n                'click #add_new_defined_option': function (event) {\n                    this.addOption(event);\n                },\n\n                /**\n                 * Add new option row for 'select' type of custom option\n                 */\n                'click button[id^=product_option_][id$=_add_select_row]': function (event) {\n                    this.addSelection(event);\n                },\n\n                /**\n                 * Import custom options from products\n                 */\n                'click #import_new_defined_option': function () {\n                    var importContainer = $('#import-container'),\n                        widget = this;\n\n                    importContainer.modal({\n                        title: $.mage.__('Select Product'),\n                        type: 'slide',\n\n                        /** @inheritdoc */\n                        opened: function () {\n                            $(document).off().on('click', '#productGrid_massaction-form button', function () {\n                                $('.import-custom-options-apply-button').trigger('click', 'massActionTrigger');\n                            });\n                        },\n                        buttons: [{\n                            text: $.mage.__('Import'),\n                            attr: {\n                                id: 'import-custom-options-apply-button'\n                            },\n                            'class': 'action-primary action-import import-custom-options-apply-button',\n\n                            /** @inheritdoc */\n                            click: function (event, massActionTrigger) {\n                                var request = [];\n\n                                $(this.element).find('input[name=product]:checked').map(function () {\n                                    request.push(this.value);\n                                });\n\n                                if (request.length === 0) {\n                                    if (!massActionTrigger) {\n                                        alert({\n                                            content: $.mage.__('An item needs to be selected. Select and try again.')\n                                        });\n                                    }\n\n                                    return;\n                                }\n\n                                $.post(widget.options.customOptionsUrl, {\n                                    'products[]': request,\n                                    'form_key': widget.options.formKey\n                                }, function ($data) {\n                                    $.each(JSON.parse($data), function (el) {\n                                        var i;\n\n                                        el.id = widget.getFreeOptionId(el.id);\n                                        el['option_id'] = el.id;\n\n                                        if (typeof el.optionValues !== 'undefined') {\n                                            for (i = 0; i < el.optionValues.length; i++) {\n                                                el.optionValues[i]['option_id'] = el.id;\n                                            }\n                                        }\n                                        //Adding option\n                                        widget.addOption(el);\n                                        //Will save new option on server side\n                                        $('#product_option_' + el.id + '_option_id').val(0);\n                                        $('#option_' + el.id + ' input[name$=\"option_type_id]\"]').val(-1);\n                                    });\n                                    importContainer.modal('closeModal');\n                                });\n                            }\n                        }]\n                    });\n                    importContainer.load(\n                        this.options.productGridUrl,\n                        {\n                            'form_key': this.options.formKey,\n                            'current_product_id': this.options.currentProductId\n                        },\n                        function () {\n                            importContainer.modal('openModal');\n                        }\n                    );\n                },\n\n                /**\n                 * Change custom option type\n                 */\n                'change select[id^=product_option_][id$=_type]': function (event, data) {\n                    var widget = this,\n                        currentElement = $(event.target),\n                        parentId = '#' + currentElement.closest('.fieldset-alt').attr('id'),\n                        group = currentElement.find('[value=\"' + currentElement.val() + '\"]')\n                            .closest('optgroup').attr('data-optgroup-name'),\n                        previousGroup = $(parentId + '_previous_group').val(),\n                        previousBlock = $(parentId + '_type_' + previousGroup),\n                        tmpl, disabledBlock, priceType;\n\n                    data = data || {};\n\n                    if (typeof group !== 'undefined') {\n                        group = group.toLowerCase();\n                    }\n\n                    if (previousGroup !== group) {\n                        if (previousBlock.length) {\n                            previousBlock.addClass('ignore-validate').hide();\n                        }\n                        $(parentId + '_previous_group').val(group);\n\n                        if (typeof group === 'undefined') {\n                            return;\n                        }\n                        disabledBlock = $(parentId).find(parentId + '_type_' + group);\n\n                        if (disabledBlock.length) {\n                            disabledBlock.removeClass('ignore-validate').show();\n                        } else {\n                            if ($.isEmptyObject(data)) { //eslint-disable-line max-depth\n                                data['option_id'] = $(parentId + '_id').val();\n                                data.price = data.sku = '';\n                            }\n                            data.group = group;\n\n                            tmpl = widget.element.find('#custom-option-' + group + '-type-template').html();\n                            tmpl = mageTemplate(tmpl, {\n                                data: data\n                            });\n\n                            $(tmpl).insertAfter($(parentId));\n\n                            if (data['price_type']) { //eslint-disable-line max-depth\n                                priceType = $('#' + widget.options.fieldId + '_' + data['option_id'] + '_price_type');\n                                priceType.val(data['price_type']).attr('data-store-label', data['price_type']);\n                            }\n                            this._bindUseDefault(widget.options.fieldId + '_' + data['option_id'], data);\n                            //Add selections\n\n                            if (data.optionValues) { //eslint-disable-line max-depth\n                                data.optionValues.each(function (value) {\n                                    widget.addSelection(value);\n                                });\n                            }\n                        }\n                    }\n                },\n                //Sync title\n                'change .field-option-title > .control > input[id$=\"_title\"]': syncOptionTitle,\n                'keyup .field-option-title > .control > input[id$=\"_title\"]': syncOptionTitle,\n                'paste .field-option-title > .control > input[id$=\"_title\"]': syncOptionTitle\n            });\n        },\n\n        /**\n         * @private\n         */\n        _initSortableSelections: function () {\n            if (!this.options.isReadonly) {\n                this.element.find('[id^=product_option_][id$=_type_select] tbody').sortable({\n                    axis: 'y',\n                    handle: '[data-role=draggable-handle]',\n\n                    /** @inheritdoc */\n                    helper: function (event, ui) {\n                        ui.children().each(function () {\n                            $(this).width($(this).width());\n                        });\n\n                        return ui;\n                    },\n                    update: this._updateSelectionsPositions,\n                    tolerance: 'pointer'\n                });\n            }\n        },\n\n        /**\n         * Sync sort order checkbox with hidden dropdown\n         */\n        _bindCheckboxHandlers: function () {\n            this._on({\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'change [id^=product_option_][id$=_required]': function (event) {\n                    var $this = $(event.target);\n\n                    $this.closest('#product_options_container_top > div')\n                        .find('[name$=\"[is_require]\"]').val($this.is(':checked') ? 1 : 0);\n                }\n            });\n            this.element.find('[id^=product_option_][id$=_required]').each(function () {\n                $(this).prop('checked', $(this).closest('#product_options_container_top > div')\n                        .find('[name$=\"[is_require]\"]').val() > 0);\n            });\n        },\n\n        /**\n         * Update Custom option position\n         */\n        _updateOptionBoxPositions: function () {\n            $(this).find('div[id^=option_]:not(.ignore-validate) .fieldset-alt > [name$=\"[sort_order]\"]').each(\n                function (index) {\n                    $(this).val(index);\n                });\n        },\n\n        /**\n         * Update selections positions for 'select' type of custom option\n         */\n        _updateSelectionsPositions: function () {\n            $(this).find('tr:not(.ignore-validate) [name$=\"[sort_order]\"]').each(function (index) {\n                $(this).val(index);\n            });\n        },\n\n        /**\n         * Disable input data if \"Read Only\"\n         */\n        _bindReadOnlyMode: function () {\n            if (this.options.isReadonly) {\n                $('div.product-custom-options').find('button,input,select,textarea').each(function () {\n                    $(this).prop('disabled', true);\n\n                    if ($(this).is('button')) {\n                        $(this).addClass('disabled');\n                    }\n                });\n            }\n        },\n\n        /**\n         * @param {String} id\n         * @param {Object} data\n         * @private\n         */\n        _bindUseDefault: function (id, data) {\n            var title = $('#' + id + '_title'),\n                price = $('#' + id + '_price'),\n                priceType = $('#' + id + '_price_type');\n\n            //enable 'use default' link for title\n            if (data.checkboxScopeTitle) {\n                title.useDefault({\n                    field: '.field',\n                    useDefault: 'label[for$=_title]',\n                    checkbox: 'input[id$=_title_use_default]',\n                    label: 'span'\n                });\n            }\n            //enable 'use default' link for price and price_type\n            if (data.checkboxScopePrice) {\n                price.useDefault({\n                    field: '.field',\n                    useDefault: 'label[for$=_price]',\n                    checkbox: 'input[id$=_price_use_default]',\n                    label: 'span'\n                });\n                //not work set default value for second field\n                priceType.useDefault({\n                    field: '.field',\n                    useDefault: 'label[for$=_price]',\n                    checkbox: 'input[id$=_price_use_default]',\n                    label: 'span'\n                });\n            }\n        },\n\n        /**\n         * Add selection value for 'select' type of custom option\n         */\n        addSelection: function (event) {\n            var data = {},\n                element = event.target || event.srcElement || event.currentTarget,\n                rowTmpl, priceType;\n\n            if (typeof element !== 'undefined') {\n                data.id = $(element).closest('#product_options_container_top > div')\n                    .find('[name^=\"product[options]\"][name$=\"[id]\"]').val();\n                data['option_type_id'] = -1;\n\n                if (!this.options.selectionItemCount[data.id]) {\n                    this.options.selectionItemCount[data.id] = 1;\n                }\n\n                data['select_id'] = this.options.selectionItemCount[data.id];\n                data.price = data.sku = '';\n            } else {\n                data = event;\n                data.id = data['option_id'];\n                data['select_id'] = data['option_type_id'];\n                this.options.selectionItemCount[data.id] = data['item_count'];\n            }\n\n            rowTmpl = this.rowTmpl({\n                data: data\n            });\n\n            $(rowTmpl).appendTo($('#select_option_type_row_' + data.id));\n\n            //set selected price_type value if set\n            if (data['price_type']) {\n                priceType = $('#' + this.options.fieldId + '_' + data.id + '_select_' + data['select_id'] +\n                    '_price_type');\n                priceType.val(data['price_type']).attr('data-store-label', data['price_type']);\n            }\n\n            this._bindUseDefault(this.options.fieldId + '_' + data.id + '_select_' + data['select_id'], data);\n            this.refreshSortableElements();\n            this.options.selectionItemCount[data.id] = parseInt(this.options.selectionItemCount[data.id], 10) + 1;\n\n            $('#' + this.options.fieldId + '_' + data.id + '_select_' + data['select_id'] + '_title').trigger('focus');\n        },\n\n        /**\n         * Add custom option\n         */\n        addOption: function (event) {\n            var data = {},\n                element = event.target || event.srcElement || event.currentTarget,\n                baseTmpl;\n\n            if (typeof element !== 'undefined') {\n                data.id = this.options.itemCount;\n                data.type = '';\n                data['option_id'] = 0;\n            } else {\n                data = event;\n                this.options.itemCount = data['item_count'];\n            }\n\n            baseTmpl = this.baseTmpl({\n                data: data\n            });\n\n            $(baseTmpl)\n                .appendTo(this.element.find('#product_options_container_top'))\n                .find('.collapse').collapsable();\n\n            //set selected type value if set\n            if (data.type) {\n                $('#' + this.options.fieldId + '_' + data.id + '_type').val(data.type).trigger('change', data);\n            }\n\n            //set selected is_require value if set\n            if (data['is_require']) {\n                $('#' + this.options.fieldId + '_' + data.id + '_is_require').val(data['is_require']).trigger('change');\n            }\n\n            this.refreshSortableElements();\n            this._bindCheckboxHandlers();\n            this._bindReadOnlyMode();\n            this.options.itemCount++;\n            $('#' + this.options.fieldId + '_' + data.id + '_title').trigger('change');\n        },\n\n        /**\n         * @return {Object}\n         */\n        refreshSortableElements: function () {\n            if (!this.options.isReadonly) {\n                this.element.sortable('refresh');\n                this._updateOptionBoxPositions.apply(this.element);\n                this._updateSelectionsPositions.apply(this.element);\n                this._initSortableSelections();\n            }\n\n            return this;\n        },\n\n        /**\n         * @param {String} id\n         * @return {*}\n         */\n        getFreeOptionId: function (id) {\n            return $('#' + this.options.fieldId + '_' + id).length ? this.getFreeOptionId(parseInt(id, 10) + 1) : id;\n        }\n    });\n\n});\n","Magento_Catalog/js/edit-tree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\n// jscs:disable jsDoc\n\nrequire([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Ui/js/modal/alert',\n    'loadingPopup',\n    'mage/backend/floating-header'\n], function (jQuery, confirm) {\n    'use strict';\n\n    /**\n     * Delete some category\n     * This routine get categoryId explicitly, so even if currently selected tree node is out of sync\n     * with this form, we surely delete same category in the tree and at backend.\n     *\n     * @deprecated\n     * @see deleteConfirm\n     */\n    function categoryDelete(url) {\n        confirm({\n            content: 'Are you sure you want to delete this category?',\n            actions: {\n                confirm: function () {\n                    location.href = url;\n                }\n            }\n        });\n    }\n\n    function displayLoadingMask() {\n        jQuery('body').loadingPopup();\n    }\n\n    window.categoryDelete = categoryDelete;\n    window.displayLoadingMask = displayLoadingMask;\n});\n","Magento_Catalog/js/new-category-dialog.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\n/*global FORM_KEY*/\ndefine([\n    'jquery',\n    'jquery/ui',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate',\n    'mage/backend/tree-suggest',\n    'mage/backend/validation'\n], function ($) {\n    'use strict';\n\n    /** Clear parent category. */\n    var clearParentCategory = function () {\n        $('#new_category_parent').find('option').each(function () {\n            $('#new_category_parent-suggest').treeSuggest('removeOption', null, this);\n        });\n    };\n\n    $.widget('mage.newCategoryDialog', {\n        /** @inheritdoc */\n        _create: function () {\n            var widget = this,\n                newCategoryForm;\n\n            $('#new_category_parent').before($('<input>', {\n                id: 'new_category_parent-suggest',\n                placeholder: $.mage.__('start typing to search category')\n            }));\n\n            $('#new_category_parent-suggest').treeSuggest(this.options.suggestOptions)\n                .on('suggestbeforeselect', function (event) {\n                    clearParentCategory();\n                    $(event.target).treeSuggest('close');\n                });\n\n            $.validator.addMethod('validate-parent-category', function () {\n                return $('#new_category_parent').val() || $('#new_category_parent-suggest').val() === '';\n            }, $.mage.__('Choose existing category.'));\n            newCategoryForm = $('#new_category_form');\n            newCategoryForm.mage('validation', {\n                /**\n                 * @param {jQuery} error\n                 * @param {*} element\n                 */\n                errorPlacement: function (error, element) {\n                    error.insertAfter(element.is('#new_category_parent') ?\n                        $('#new_category_parent-suggest').closest('.mage-suggest') :\n                        element);\n                }\n            }).on('highlight.validate', function (e) {\n                var options = $(this).validation('option');\n\n                if ($(e.target).is('#new_category_parent')) {\n                    options.highlight($('#new_category_parent-suggest').get(0),\n                        options.errorClass, options.validClass || '');\n                }\n            });\n            this.element.modal({\n                type: 'slide',\n                modalClass: 'mage-new-category-dialog form-inline',\n                title: $.mage.__('Create Category'),\n\n                /** @inheritdoc */\n                opened: function () {\n                    var enteredName = $('#category_ids-suggest').val();\n\n                    $('#new_category_name').val(enteredName);\n\n                    if (enteredName === '') {\n                        $('#new_category_name').trigger('focus');\n                    }\n                    $('#new_category_messages').html('');\n                },\n\n                /** @inheritdoc */\n                closed: function () {\n                    var validationOptions = newCategoryForm.validation('option');\n\n                    $('#new_category_name, #new_category_parent-suggest').val('');\n                    validationOptions.unhighlight($('#new_category_parent-suggest').get(0),\n                        validationOptions.errorClass, validationOptions.validClass || '');\n                    newCategoryForm.validation('clearError');\n                    $('#category_ids-suggest').trigger('focus');\n                },\n                buttons: [{\n                    text: $.mage.__('Create Category'),\n                    class: 'action-primary',\n\n                    /** @inheritdoc */\n                    click: function (e) {\n                        var thisButton;\n\n                        if (!newCategoryForm.valid()) {\n                            return;\n                        }\n                        thisButton = $(e.currentTarget);\n\n                        thisButton.prop('disabled', true);\n                        $.ajax({\n                            type: 'POST',\n                            url: widget.options.saveCategoryUrl,\n                            data: {\n                                name: $('#new_category_name').val(),\n                                parent: $('#new_category_parent').val(),\n                                'is_active': 1,\n                                'include_in_menu': 1,\n                                'use_config': ['available_sort_by', 'default_sort_by'],\n                                'form_key': FORM_KEY,\n                                'return_session_messages_only': 1\n                            },\n                            dataType: 'json',\n                            context: $('body')\n                        }).done(function (data) {\n                            var $suggest;\n\n                            if (!data.error) {\n                                $suggest = $('#category_ids-suggest');\n\n                                $suggest.trigger('selectItem', {\n                                    id: data.category['entity_id'],\n                                    label: data.category.name\n                                });\n                                $('#new_category_name, #new_category_parent-suggest').val('');\n                                $suggest.val('');\n                                clearParentCategory();\n                                $(widget.element).modal('closeModal');\n                            } else {\n                                $('#new_category_messages').html(data.messages);\n                            }\n                        }).always(\n                            function () {\n                                thisButton.prop('disabled', false);\n                            }\n                        );\n                    }\n                }]\n            });\n        }\n    });\n\n    return $.mage.newCategoryDialog;\n});\n","Magento_Catalog/js/options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* eslint-disable no-undef */\n// jscs:disable jsDoc\n\ndefine([\n    'jquery',\n    'mage/template',\n    'uiRegistry',\n    'jquery/ui',\n    'prototype',\n    'form',\n    'validation',\n    'mage/translate'\n], function (jQuery, mageTemplate, rg) {\n    'use strict';\n\n    return function (config) {\n        var optionPanel = jQuery('#manage-options-panel'),\n            editForm = jQuery('#edit_form'),\n            attributeOption = {\n                table: $('attribute-options-table'),\n                itemCount: 0,\n                totalItems: 0,\n                rendered: 0,\n                template: mageTemplate('#row-template'),\n                newOptionClass: 'new-option',\n                isReadOnly: config.isReadOnly,\n                add: function (data, render) {\n                    var isNewOption = false,\n                        element;\n\n                    if (typeof data.id == 'undefined') {\n                        data = {\n                            'id': 'option_' + this.itemCount,\n                            'sort_order': this.itemCount + 1,\n                            'rowClasses': this.newOptionClass\n                        };\n                        isNewOption = true;\n                    }\n\n                    if (!data.intype) {\n                        data.intype = this.getOptionInputType();\n                    }\n\n                    element = this.template({\n                        data: data\n                    });\n\n                    if (isNewOption && !this.isReadOnly) {\n                        this.enableNewOptionDeleteButton(data.id);\n                    }\n                    this.itemCount++;\n                    this.totalItems++;\n                    this.elements += element;\n\n                    if (render) {\n                        this.render();\n                        this.updateItemsCountField();\n                    }\n                },\n                remove: function (event) {\n                    var element = $(Event.findElement(event, 'tr')),\n                        elementFlags; // !!! Button already have table parent in safari\n\n                    // Safari workaround\n                    element.ancestors().each(function (parentItem) {\n                        if (parentItem.hasClassName('option-row')) {\n                            element = parentItem;\n                            throw $break;\n                        } else if (parentItem.hasClassName('box')) {\n                            throw $break;\n                        }\n                    });\n\n                    if (element) {\n                        elementFlags = element.getElementsByClassName('delete-flag');\n\n                        if (elementFlags[0]) {\n                            elementFlags[0].value = 1;\n                        }\n\n                        element.addClassName('no-display');\n                        element.addClassName('template');\n                        element.hide();\n                        this.totalItems--;\n                        this.updateItemsCountField();\n                    }\n\n                    if (element.hasClassName(this.newOptionClass)) {\n                        element.remove();\n                    }\n                },\n                updateItemsCountField: function () {\n                    $('option-count-check').value = this.totalItems > 0 ? '1' : '';\n                },\n                enableNewOptionDeleteButton: function (id) {\n                    $$('#delete_button_container_' + id + ' button').each(function (button) {\n                        button.enable();\n                        button.removeClassName('disabled');\n                    });\n                },\n                bindRemoveButtons: function () {\n                    jQuery('#swatch-visual-options-panel').on('click', '.delete-option', this.remove.bind(this));\n                },\n                render: function () {\n                    Element.insert($$('[data-role=options-container]')[0], this.elements);\n                    this.elements = '';\n                },\n                renderWithDelay: function (data, from, step, delay) {\n                    var arrayLength = data.length,\n                        len;\n\n                    for (len = from + step; from < len && from < arrayLength; from++) {\n                        this.add(data[from]);\n                    }\n                    this.render();\n\n                    if (from === arrayLength) {\n                        this.updateItemsCountField();\n                        this.rendered = 1;\n                        jQuery('body').trigger('processStop');\n\n                        return true;\n                    }\n                    setTimeout(this.renderWithDelay.bind(this, data, from, step, delay), delay);\n                },\n                ignoreValidate: function () {\n                    var ignore = '.ignore-validate input, ' +\n                        '.ignore-validate select, ' +\n                        '.ignore-validate textarea';\n\n                    jQuery('#edit_form').data('validator').settings.forceIgnore = ignore;\n                },\n                getOptionInputType: function () {\n                    var optionDefaultInputType = 'radio';\n\n                    if ($('frontend_input') && $('frontend_input').value === 'multiselect') {\n                        optionDefaultInputType = 'checkbox';\n                    }\n\n                    return optionDefaultInputType;\n                }\n            },\n            tableBody = jQuery(),\n            activePanelClass = 'selected-type-options';\n\n        if ($('add_new_option_button')) {\n            Event.observe('add_new_option_button', 'click', attributeOption.add.bind(attributeOption, {}, true));\n        }\n        $('manage-options-panel').on('click', '.delete-option', function (event) {\n            attributeOption.remove(event);\n        });\n\n        optionPanel.on('render', function () {\n            attributeOption.ignoreValidate();\n\n            if (attributeOption.rendered) {\n                return false;\n            }\n            jQuery('body').trigger('processStart');\n            attributeOption.renderWithDelay(config.attributesData, 0, 100, 300);\n            attributeOption.bindRemoveButtons();\n        });\n\n        if (config.isSortable) {\n            jQuery(function ($) {\n                $('[data-role=options-container]').sortable({\n                    distance: 8,\n                    tolerance: 'pointer',\n                    cancel: 'input, button',\n                    axis: 'y',\n                    update: function () {\n                        $('[data-role=options-container] [data-role=order]').each(function (index, element) {\n                            $(element).val(index + 1);\n                        });\n                    }\n                });\n            });\n        }\n        editForm.on('beforeSubmit', function () {\n            var optionContainer = optionPanel.find('table tbody'),\n                optionsValues;\n\n            if (optionPanel.hasClass(activePanelClass)) {\n                optionsValues = jQuery.map(\n                    optionContainer.find('tr'),\n                    function (row) {\n                        return jQuery(row).find('input, select, textarea').serialize();\n                    }\n                );\n                jQuery('<input>')\n                    .attr({\n                        type: 'hidden',\n                        name: 'serialized_options'\n                    })\n                    .val(JSON.stringify(optionsValues))\n                    .prependTo(editForm);\n            }\n            tableBody = optionContainer.detach();\n        });\n        editForm.on('afterValidate.error highlight.validate', function () {\n            if (optionPanel.hasClass(activePanelClass)) {\n                optionPanel.find('table').append(tableBody);\n                jQuery('input[name=\"serialized_options\"]').remove();\n            }\n        });\n        window.attributeOption = attributeOption;\n        window.optionDefaultInputType = attributeOption.getOptionInputType();\n\n        rg.set('manage-options-panel', attributeOption);\n    };\n});\n","Magento_Catalog/js/price-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/js/price-utils',\n    'underscore',\n    'mage/template',\n    'jquery-ui-modules/widget'\n], function ($, utils, _, mageTemplate) {\n    'use strict';\n\n    var globalOptions = {\n        productId: null,\n        priceConfig: null,\n        prices: {},\n        priceTemplate: '<span class=\"price\"><%- data.formatted %></span>'\n    };\n\n    $.widget('mage.priceBox', {\n        options: globalOptions,\n        qtyInfo: '#qty',\n\n        /**\n         * Widget initialisation.\n         * Every time when option changed prices also can be changed. So\n         * changed options.prices -> changed cached prices -> recalculation -> redraw price box\n         */\n        _init: function initPriceBox() {\n            var box = this.element;\n\n            box.trigger('updatePrice');\n            this.cache.displayPrices = utils.deepClone(this.options.prices);\n        },\n\n        /**\n         * Widget creating.\n         */\n        _create: function createPriceBox() {\n            var box = this.element;\n\n            this.cache = {};\n            this._setDefaultsFromPriceConfig();\n            this._setDefaultsFromDataSet();\n\n            box.on('reloadPrice', this.reloadPrice.bind(this));\n            box.on('updatePrice', this.onUpdatePrice.bind(this));\n            $(this.qtyInfo).on('input', this.updateProductTierPrice.bind(this));\n            box.trigger('price-box-initialized');\n        },\n\n        /**\n         * Call on event updatePrice. Proxy to updatePrice method.\n         * @param {Event} event\n         * @param {Object} prices\n         */\n        onUpdatePrice: function onUpdatePrice(event, prices) {\n            return this.updatePrice(prices);\n        },\n\n        /**\n         * Updates price via new (or additional values).\n         * It expects object like this:\n         * -----\n         *   \"option-hash\":\n         *      \"price-code\":\n         *         \"amount\": 999.99999,\n         *         ...\n         * -----\n         * Empty option-hash object or empty price-code object treats as zero amount.\n         * @param {Object} newPrices\n         */\n        updatePrice: function updatePrice(newPrices) {\n            var prices = this.cache.displayPrices,\n                additionalPrice = {},\n                pricesCode = [],\n                priceValue, origin, finalPrice;\n\n            this.cache.additionalPriceObject = this.cache.additionalPriceObject || {};\n\n            if (newPrices) {\n                $.extend(this.cache.additionalPriceObject, newPrices);\n            }\n\n            if (!_.isEmpty(additionalPrice)) {\n                pricesCode = _.keys(additionalPrice);\n            } else if (!_.isEmpty(prices)) {\n                pricesCode = _.keys(prices);\n            }\n\n            _.each(this.cache.additionalPriceObject, function (additional) {\n                if (additional && !_.isEmpty(additional)) {\n                    pricesCode = _.keys(additional);\n                }\n                _.each(pricesCode, function (priceCode) {\n                    priceValue = additional[priceCode] || {};\n                    priceValue.amount = +priceValue.amount || 0;\n                    priceValue.adjustments = priceValue.adjustments || {};\n\n                    additionalPrice[priceCode] = additionalPrice[priceCode] || {\n                        'amount': 0,\n                        'adjustments': {}\n                    };\n                    additionalPrice[priceCode].amount =  0 + (additionalPrice[priceCode].amount || 0) +\n                        priceValue.amount;\n                    _.each(priceValue.adjustments, function (adValue, adCode) {\n                        additionalPrice[priceCode].adjustments[adCode] = 0 +\n                            (additionalPrice[priceCode].adjustments[adCode] || 0) + adValue;\n                    });\n                });\n            });\n\n            if (_.isEmpty(additionalPrice)) {\n                this.cache.displayPrices = utils.deepClone(this.options.prices);\n            } else {\n                _.each(additionalPrice, function (option, priceCode) {\n                    origin = this.options.prices[priceCode] || {};\n                    finalPrice = prices[priceCode] || {};\n                    option.amount = option.amount || 0;\n                    origin.amount = origin.amount || 0;\n                    origin.adjustments = origin.adjustments || {};\n                    finalPrice.adjustments = finalPrice.adjustments || {};\n\n                    finalPrice.amount = 0 + origin.amount + option.amount;\n                    _.each(option.adjustments, function (pa, paCode) {\n                        finalPrice.adjustments[paCode] = 0 + (origin.adjustments[paCode] || 0) + pa;\n                    });\n                }, this);\n            }\n\n            this.element.trigger('priceUpdated', this.cache.displayPrices);\n            this.element.trigger('reloadPrice');\n        },\n\n        /*eslint-disable no-extra-parens*/\n        /**\n         * Render price unit block.\n         */\n        reloadPrice: function reDrawPrices() {\n            var priceFormat = (this.options.priceConfig && this.options.priceConfig.priceFormat) || {},\n                priceTemplate = mageTemplate(this.options.priceTemplate);\n\n            _.each(this.cache.displayPrices, function (price, priceCode) {\n                price.final = _.reduce(price.adjustments, function (memo, amount) {\n                    return memo + amount;\n                }, price.amount);\n\n                price.formatted = utils.formatPriceLocale(price.final, priceFormat);\n\n                $('[data-price-type=\"' + priceCode + '\"]', this.element).html(priceTemplate({\n                    data: price\n                }));\n            }, this);\n        },\n\n        /*eslint-enable no-extra-parens*/\n        /**\n         * Overwrites initial (default) prices object.\n         * @param {Object} prices\n         */\n        setDefault: function setDefaultPrices(prices) {\n            this.cache.displayPrices = utils.deepClone(prices);\n            this.options.prices = utils.deepClone(prices);\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge of accepted configuration.\n         * @param  {Object} options\n         * @return {mage.priceBox}\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n\n            if ('disabled' in options) {\n                this._setOption('disabled', options.disabled);\n            }\n\n            return this;\n        },\n\n        /**\n         * setDefaultsFromDataSet\n         */\n        _setDefaultsFromDataSet: function _setDefaultsFromDataSet() {\n            var box = this.element,\n                priceHolders = $('[data-price-type]', box),\n                prices = this.options.prices;\n\n            this.options.productId = box.data('productId');\n\n            if (_.isEmpty(prices)) {\n                priceHolders.each(function (index, element) {\n                    var type = $(element).data('priceType'),\n                        amount = parseFloat($(element).data('priceAmount'));\n\n                    if (type && !_.isNaN(amount)) {\n                        prices[type] = {\n                            amount: amount\n                        };\n                    }\n                });\n            }\n        },\n\n        /**\n         * setDefaultsFromPriceConfig\n         */\n        _setDefaultsFromPriceConfig: function _setDefaultsFromPriceConfig() {\n            var config = this.options.priceConfig;\n\n            if (config && config.prices) {\n                this.options.prices = config.prices;\n            }\n        },\n\n        /**\n         * Updates product final and base price according to tier prices\n         */\n        updateProductTierPrice: function updateProductTierPrice() {\n            var originalPrice,\n                prices = {'prices': {}};\n\n            if (this.options.prices.finalPrice) {\n                originalPrice = this.options.prices.finalPrice.amount;\n                prices.prices.finalPrice = {'amount': this.getPrice('price') - originalPrice};\n            }\n\n            if (this.options.prices.basePrice) {\n                originalPrice = this.options.prices.basePrice.amount;\n                prices.prices.basePrice = {'amount': this.getPrice('basePrice') - originalPrice};\n            }\n\n            this.updatePrice(prices);\n        },\n\n        /**\n         * Returns price.\n         *\n         * @param {String} priceKey\n         * @returns {Number}\n         */\n        getPrice: function (priceKey) {\n            var productQty = $(this.qtyInfo).val(),\n                result,\n                tierPriceItem,\n                i;\n\n            for (i = 0; i < this.options.priceConfig.tierPrices.length; i++) {\n                tierPriceItem = this.options.priceConfig.tierPrices[i];\n                if (productQty >= tierPriceItem.qty && tierPriceItem[priceKey]) {\n                    result = tierPriceItem[priceKey];\n                }\n            }\n\n            return result;\n        }\n    });\n\n    return $.mage.priceBox;\n});\n","Magento_Catalog/js/price-option-date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'priceUtils',\n    'priceOptions',\n    'jquery-ui-modules/widget'\n], function ($, utils) {\n    'use strict';\n\n    var globalOptions = {\n            fromSelector: 'form',\n            dropdownsSelector: '[data-role=calendar-dropdown]'\n        },\n        optionHandler = {};\n\n    optionHandler.optionHandlers = {};\n\n    /**\n     * Custom handler for Date-with-Dropdowns option type.\n     * @param  {jQuery} siblings\n     * @return {Function} function that return object { optionHash : optionAdditionalPrice }\n     */\n    function onCalendarDropdownChange(siblings) {\n        return function (element, optionConfig) {\n            var changes = {},\n                optionId = utils.findOptionId(element),\n                overhead = optionConfig[optionId].prices,\n                isNeedToUpdate = true,\n                optionHash = 'price-option-calendar-' + optionId;\n\n            siblings.each(function (index, el) {\n                isNeedToUpdate = isNeedToUpdate && !!$(el).val();\n            });\n\n            overhead = isNeedToUpdate ? overhead : {};\n            changes[optionHash] = overhead;\n\n            return changes;\n        };\n    }\n\n    /**\n     * Returns number of days for special month and year\n     * @param  {Number} month\n     * @param  {Number} year\n     * @return {Number}\n     */\n    function getDaysInMonth(month, year) {\n        return new Date(year, month, 0).getDate();\n    }\n\n    /**\n     * Adjusts the number of days in the day option element based on which month or year\n     * is selected (changed). Adjusts the days to 28, 29, 30, or 31 typically.\n     * @param {jQuery} dropdowns\n     */\n    function onDateChange(dropdowns) {\n        var daysNodes,\n            curMonth, curYear, expectedDays,\n            options, needed,\n            month = dropdowns.filter('[data-calendar-role=month]'),\n            year = dropdowns.filter('[data-calendar-role=year]');\n\n        if (month.length && year.length) {\n            daysNodes = dropdowns.filter('[data-calendar-role=day]').find('option');\n\n            curMonth = month.val() || '01';\n            curYear = year.val() || '2000';\n            expectedDays = getDaysInMonth(curMonth, curYear);\n\n            if (daysNodes.length - 1 > expectedDays) { // remove unnecessary option nodes\n                daysNodes.each(function (i, e) {\n                    if (e.value > expectedDays) {\n                        $(e).remove();\n                    }\n                });\n            } else if (daysNodes.length - 1 < expectedDays) { // add missing option nodes\n                options = [];\n                needed = expectedDays - daysNodes.length + 1;\n\n                while (needed--) { //eslint-disable-line max-depth\n                    options.push(\n                        '<option value=\"' + (expectedDays - needed) + '\">' + (expectedDays - needed) + '</option>'\n                    );\n                }\n                $(options.join('')).insertAfter(daysNodes.last());\n            }\n        }\n    }\n\n    $.widget('mage.priceOptionDate', {\n        options: globalOptions,\n\n        /**\n         * Function-initializer of priceOptionDate widget\n         * @private\n         */\n        _create: function initOptionDate() {\n            var field = this.element,\n                form = field.closest(this.options.fromSelector),\n                dropdowns = $(this.options.dropdownsSelector, field),\n                dateOptionId;\n\n            if (dropdowns.length) {\n                dateOptionId = this.options.dropdownsSelector + dropdowns.attr('name');\n\n                optionHandler.optionHandlers[dateOptionId] = onCalendarDropdownChange(dropdowns);\n\n                form.priceOptions(optionHandler);\n\n                dropdowns.data('role', dateOptionId);\n                dropdowns.on('change', onDateChange.bind(this, dropdowns));\n            }\n        }\n    });\n\n    return $.mage.priceOptionDate;\n});\n","Magento_Catalog/js/price-option-file.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery-ui-modules/widget'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.priceOptionFile', {\n        options: {\n            fileName: '',\n            fileNamed: '',\n            fieldNameAction: '',\n            changeFileSelector: '',\n            deleteFileSelector: ''\n        },\n\n        /**\n         * Creates instance of widget\n         * @private\n         */\n        _create: function () {\n            this.fileDeleteFlag = this.fileChangeFlag = false;\n            this.inputField = this.element.find('input[name=' + this.options.fileName + ']')[0];\n            this.inputFieldAction = this.element.find('input[name=' + this.options.fieldNameAction + ']')[0];\n            this.fileNameSpan = this.element.parent('dd').find('.' + this.options.fileNamed);\n\n            $(this.options.changeFileSelector).on('click', $.proxy(function () {\n                this._toggleFileChange();\n            }, this));\n            $(this.options.deleteFileSelector).on('click', $.proxy(function () {\n                this._toggleFileDelete();\n            }, this));\n        },\n\n        /**\n         * Toggles whether the current file is being changed or not. If the file is being deleted\n         * then the option to change the file is disabled.\n         * @private\n         */\n        _toggleFileChange: function () {\n            this.element.toggle();\n            this.fileChangeFlag = !this.fileChangeFlag;\n\n            if (!this.fileDeleteFlag) {\n                $(this.inputFieldAction).attr('value', this.fileChangeFlag ? 'save_new' : 'save_old');\n                this.inputField.disabled = !this.fileChangeFlag;\n            }\n        },\n\n        /**\n         * Toggles whether the file is to be deleted. When the file is being deleted, the name of\n         * the file is decorated with strike-through text and the option to change the file is\n         * disabled.\n         * @private\n         */\n        _toggleFileDelete: function () {\n            this.fileDeleteFlag = $(this.options.deleteFileSelector + ':checked').val();\n            $(this.inputFieldAction).attr('value',\n                this.fileDeleteFlag ? '' : this.fileChangeFlag ? 'save_new' : 'save_old');\n            this.inputField.disabled = this.fileDeleteFlag || !this.fileChangeFlag;\n            this.fileNameSpan.css('text-decoration', this.fileDeleteFlag ? 'line-through' : 'none');\n        }\n    });\n\n    return $.mage.priceOptionFile;\n});\n","Magento_Catalog/js/price-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'priceUtils',\n    'priceBox',\n    'jquery-ui-modules/widget'\n], function ($, _, mageTemplate, utils) {\n    'use strict';\n\n    var globalOptions = {\n        productId: null,\n        priceHolderSelector: '.price-box', //data-role=\"priceBox\"\n        optionsSelector: '.product-custom-option',\n        optionConfig: {},\n        optionHandlers: {},\n        optionTemplate: '<%= data.label %>' +\n        '<% if (data.finalPrice.value > 0) { %>' +\n        ' +<%- data.finalPrice.formatted %>' +\n        '<% } else if (data.finalPrice.value < 0) { %>' +\n        ' <%- data.finalPrice.formatted %>' +\n        '<% } %>',\n        controlContainer: 'dd'\n    };\n\n    /**\n     * Custom option preprocessor\n     * @param  {jQuery} element\n     * @param  {Object} optionsConfig - part of config\n     * @return {Object}\n     */\n    function defaultGetOptionValue(element, optionsConfig) {\n        var changes = {},\n            optionValue = element.val(),\n            optionId = utils.findOptionId(element[0]),\n            optionName = element.prop('name'),\n            optionType = element.prop('type'),\n            optionConfig = optionsConfig[optionId],\n            optionHash = optionName;\n\n        switch (optionType) {\n            case 'text':\n            case 'textarea':\n                changes[optionHash] = optionValue ? optionConfig.prices : {};\n                break;\n\n            case 'radio':\n                if (element.is(':checked')) {\n                    changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                }\n                break;\n\n            case 'select-one':\n                changes[optionHash] = optionConfig[optionValue] && optionConfig[optionValue].prices || {};\n                break;\n\n            case 'select-multiple':\n                _.each(optionConfig, function (row, optionValueCode) {\n                    optionHash = optionName + '##' + optionValueCode;\n                    changes[optionHash] = _.contains(optionValue, optionValueCode) ? row.prices : {};\n                });\n                break;\n\n            case 'checkbox':\n                optionHash = optionName + '##' + optionValue;\n                changes[optionHash] = element.is(':checked') ? optionConfig[optionValue].prices : {};\n                break;\n\n            case 'file':\n                // Checking for 'disable' property equal to checking DOMNode with id*=\"change-\"\n                changes[optionHash] = optionValue || element.prop('disabled') ? optionConfig.prices : {};\n                break;\n        }\n\n        return changes;\n    }\n\n    $.widget('mage.priceOptions', {\n        options: globalOptions,\n\n        /**\n         * @private\n         */\n        _init: function initPriceBundle() {\n            $(this.options.optionsSelector, this.element).trigger('change');\n        },\n\n        /**\n         * Widget creating method.\n         * Triggered once.\n         * @private\n         */\n        _create: function createPriceOptions() {\n            var form = this.element,\n                options = $(this.options.optionsSelector, form),\n                priceBox = $(this.options.priceHolderSelector, $(this.options.optionsSelector).element);\n\n            if (priceBox.data('magePriceBox') &&\n                priceBox.priceBox('option') &&\n                priceBox.priceBox('option').priceConfig\n            ) {\n                if (priceBox.priceBox('option').priceConfig.optionTemplate) {\n                    this._setOption('optionTemplate', priceBox.priceBox('option').priceConfig.optionTemplate);\n                }\n                this._setOption('priceFormat', priceBox.priceBox('option').priceConfig.priceFormat);\n            }\n\n            this._applyOptionNodeFix(options);\n\n            options.on('change', this._onOptionChanged.bind(this));\n        },\n\n        /**\n         * Custom option change-event handler\n         * @param {Event} event\n         * @private\n         */\n        _onOptionChanged: function onOptionChanged(event) {\n            var changes,\n                option = $(event.target),\n                handler = this.options.optionHandlers[option.data('role')];\n\n            option.data('optionContainer', option.closest(this.options.controlContainer));\n\n            if (handler && handler instanceof Function) {\n                changes = handler(option, this.options.optionConfig, this);\n            } else {\n                changes = defaultGetOptionValue(option, this.options.optionConfig);\n            }\n            $(this.options.priceHolderSelector).trigger('updatePrice', changes);\n        },\n\n        /**\n         * Helper to fix issue with option nodes:\n         *  - you can't place any html in option ->\n         *    so you can't style it via CSS\n         * @param {jQuery} options\n         * @private\n         */\n        _applyOptionNodeFix: function applyOptionNodeFix(options) {\n            var config = this.options,\n                format = config.priceFormat,\n                template = config.optionTemplate;\n\n            template = mageTemplate(template);\n            options.filter('select').each(function (index, element) {\n                var $element = $(element),\n                    optionId = utils.findOptionId($element),\n                    optionConfig = config.optionConfig && config.optionConfig[optionId];\n\n                $element.find('option').each(function (idx, option) {\n                    var $option,\n                        optionValue,\n                        toTemplate,\n                        prices;\n\n                    $option = $(option);\n                    optionValue = $option.val();\n\n                    if (!optionValue && optionValue !== 0) {\n                        return;\n                    }\n\n                    toTemplate = {\n                        data: {\n                            label: optionConfig[optionValue] && optionConfig[optionValue].name\n                        }\n                    };\n                    prices = optionConfig[optionValue] ? optionConfig[optionValue].prices : null;\n\n                    if (prices) {\n                        _.each(prices, function (price, type) {\n                            var value = +price.amount;\n\n                            value += _.reduce(price.adjustments, function (sum, x) { //eslint-disable-line\n                                return sum + x;\n                            }, 0);\n                            toTemplate.data[type] = {\n                                value: value,\n                                formatted: utils.formatPriceLocale(value, format)\n                            };\n                        });\n\n                        $option.text(template(toTemplate));\n                    }\n                });\n            });\n        },\n\n        /**\n         * Custom behavior on getting options:\n         * now widget able to deep merge accepted configuration with instance options.\n         * @param  {Object}  options\n         * @return {$.Widget}\n         * @private\n         */\n        _setOptions: function setOptions(options) {\n            $.extend(true, this.options, options);\n            this._super(options);\n\n            return this;\n        }\n    });\n\n    return $.mage.priceOptions;\n});\n","Magento_Catalog/js/price-utils.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore'\n], function ($, _) {\n    'use strict';\n\n    var globalPriceFormat = {\n        requiredPrecision: 2,\n        integerRequired: 1,\n        decimalSymbol: ',',\n        groupSymbol: ',',\n        groupLength: ','\n    };\n\n    /**\n     * Repeats {string} {times} times\n     * @param  {String} string\n     * @param  {Number} times\n     * @return {String}\n     */\n    function stringPad(string, times) {\n        return new Array(times + 1).join(string);\n    }\n\n    /**\n     * Format the price with the compliance to the specified locale\n     *\n     * @param {Number} amount\n     * @param {Object} format\n     * @param  {Boolean} isShowSign\n     */\n    function formatPriceLocale(amount, format, isShowSign)\n    {\n        var s = '',\n            precision, pattern, locale, r;\n\n        format = _.extend(globalPriceFormat, format);\n        precision = isNaN(format.requiredPrecision = Math.abs(format.requiredPrecision)) ? 2 : format.requiredPrecision;\n        pattern = format.pattern || '%s';\n        locale = window.LOCALE || 'en-US';\n        if (isShowSign === undefined || isShowSign === true) {\n            s = amount < 0 ? '-' : isShowSign ? '+' : '';\n        } else if (isShowSign === false) {\n            s = '';\n        }\n        pattern = pattern.indexOf('{sign}') < 0 ? s + pattern : pattern.replace('{sign}', s);\n        amount = Number(Math.round(Math.abs(+amount || 0) + 'e+' + precision) + ('e-' + precision));\n        r = amount.toLocaleString(locale, {minimumFractionDigits: precision});\n\n        return pattern.replace('%s', r).replace(/^\\s\\s*/, '').replace(/\\s\\s*$/, '');\n    }\n\n    /**\n     * Formatter for price amount\n     * @param  {Number}  amount\n     * @param  {Object}  format\n     * @param  {Boolean} isShowSign\n     * @return {String}              Formatted value\n     * @deprecated\n     */\n    function formatPrice(amount, format, isShowSign) {\n        var s = '',\n            precision, integerRequired, decimalSymbol, groupSymbol, groupLength, pattern, i, pad, j, re, r, am;\n\n        format = _.extend(globalPriceFormat, format);\n\n        // copied from price-option.js | Could be refactored with varien/js.js\n\n        precision = isNaN(format.requiredPrecision = Math.abs(format.requiredPrecision)) ? 2 : format.requiredPrecision;\n        integerRequired = isNaN(format.integerRequired = Math.abs(format.integerRequired)) ? 1 : format.integerRequired;\n        decimalSymbol = format.decimalSymbol === undefined ? ',' : format.decimalSymbol;\n        groupSymbol = format.groupSymbol === undefined ? '.' : format.groupSymbol;\n        groupLength = format.groupLength === undefined ? 3 : format.groupLength;\n        pattern = format.pattern || '%s';\n\n        if (isShowSign === undefined || isShowSign === true) {\n            s = amount < 0 ? '-' : isShowSign ? '+' : '';\n        } else if (isShowSign === false) {\n            s = '';\n        }\n        pattern = pattern.indexOf('{sign}') < 0 ? s + pattern : pattern.replace('{sign}', s);\n\n        // we're avoiding the usage of to fixed, and using round instead with the e representation to address\n        // numbers like 1.005 = 1.01. Using ToFixed to only provide trailing zeroes in case we have a whole number\n        i = parseInt(\n                amount = Number(Math.round(Math.abs(+amount || 0) + 'e+' + precision) + ('e-' + precision)),\n                10\n            ) + '';\n        pad = i.length < integerRequired ? integerRequired - i.length : 0;\n\n        i = stringPad('0', pad) + i;\n\n        j = i.length > groupLength ? i.length % groupLength : 0;\n        re = new RegExp('(\\\\d{' + groupLength + '})(?=\\\\d)', 'g');\n\n        // replace(/-/, 0) is only for fixing Safari bug which appears\n        // when Math.abs(0).toFixed() executed on '0' number.\n        // Result is '0.-0' :(\n\n        am = Number(Math.round(Math.abs(amount - i) + 'e+' + precision) + ('e-' + precision));\n        r = (j ? i.substr(0, j) + groupSymbol : '') +\n            i.substr(j).replace(re, '$1' + groupSymbol) +\n            (precision ? decimalSymbol + am.toFixed(precision).replace(/-/, 0).slice(2) : '');\n\n        return pattern.replace('%s', r).replace(/^\\s\\s*/, '').replace(/\\s\\s*$/, '');\n    }\n\n    /**\n     * Deep clone of Object. Doesn't support functions\n     * @param {Object} obj\n     * @return {Object}\n     */\n    function objectDeepClone(obj) {\n        return JSON.parse(JSON.stringify(obj));\n    }\n\n    /**\n     * Helper to find ID in name attribute\n     * @param   {jQuery} element\n     * @returns {undefined|String}\n     */\n    function findOptionId(element) {\n        var re, id, name;\n\n        if (!element) {\n            return id;\n        }\n        name = $(element).attr('name');\n\n        if (name.indexOf('[') !== -1) {\n            re = /\\[([^\\]]+)?\\]/;\n        } else {\n            re = /_([^\\]]+)?_/; // just to support file-type-option\n        }\n        id = re.exec(name) && re.exec(name)[1];\n\n        if (id) {\n            return id;\n        }\n    }\n\n    return {\n        formatPriceLocale: formatPriceLocale,\n        formatPrice: formatPrice,\n        deepClone: objectDeepClone,\n        strPad: stringPad,\n        findOptionId: findOptionId\n    };\n});\n","Magento_Catalog/js/product-gallery.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/template',\n    'uiRegistry',\n    'jquery/ui',\n    'baseImage'\n], function ($, _, mageTemplate, registry) {\n    'use strict';\n\n    /**\n     * Formats incoming bytes value to a readable format.\n     *\n     * @param {Number} bytes\n     * @returns {String}\n     */\n    function bytesToSize(bytes) {\n        var sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB'],\n            i;\n\n        if (bytes === 0) {\n            return '0 Byte';\n        }\n\n        i = window.parseInt(Math.floor(Math.log(bytes) / Math.log(1024)));\n\n        return Math.round(bytes / Math.pow(1024, i), 2) + ' ' + sizes[i];\n    }\n\n    /**\n     * Product gallery widget\n     */\n    $.widget('mage.productGallery', {\n        options: {\n            imageSelector: '[data-role=image]',\n            imageElementSelector: '[data-role=image-element]',\n            template: '[data-template=image]',\n            imageResolutionLabel: '[data-role=resolution]',\n            imgTitleSelector: '[data-role=img-title]',\n            imageSizeLabel: '[data-role=size]',\n            types: null,\n            initialized: false\n        },\n\n        /**\n         * Gallery creation\n         * @protected\n         */\n        _create: function () {\n            this.options.types = this.options.types || this.element.data('types');\n            this.options.images = this.options.images || this.element.data('images');\n            this.options.parentComponent = this.options.parentComponent || this.element.data('parent-component');\n\n            this.imgTmpl = mageTemplate(this.element.find(this.options.template).html().trim());\n\n            this._bind();\n\n            this._isInitializingItems = true;\n            this._initializedItemCount = 0;\n            this._lastInitializedElement = null;\n\n            $.each(this.options.images, $.proxy(function (index, imageData) {\n                this.element.trigger('addItem', imageData);\n            }, this));\n\n            this._updateImagesRoles();\n            this._contentUpdated();\n\n            this._isInitializingItems = false;\n            this.options.initialized = true;\n        },\n\n        /**\n         * Bind handler to elements\n         * @protected\n         */\n        _bind: function () {\n            this._on({\n                updateImageTitle: '_updateImageTitle',\n                updateVisibility: '_updateVisibility',\n                openDialog: '_onOpenDialog',\n                addItem: '_addItem',\n                removeItem: '_removeItem',\n                setImageType: '_setImageType',\n                setPosition: '_setPosition',\n                resort: '_resort',\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'mouseup [data-role=delete-button]': function (event) {\n                    var $imageContainer;\n\n                    event.preventDefault();\n                    $imageContainer = $(event.currentTarget).closest(this.options.imageSelector);\n                    this.element.find('[data-role=dialog]').trigger('close');\n                    this.element.trigger('removeItem', $imageContainer.data('imageData'));\n                },\n\n                /**\n                 * @param {jQuery.Event} event\n                 */\n                'mouseup [data-role=make-base-button]': function (event) {\n                    var $imageContainer,\n                        imageData;\n\n                    event.preventDefault();\n                    event.stopImmediatePropagation();\n                    $imageContainer = $(event.currentTarget).closest(this.options.imageSelector);\n                    imageData = $imageContainer.data('imageData');\n                    this.setBase(imageData);\n                }\n            });\n\n            this.element.sortable({\n                distance: 8,\n                items: this.options.imageSelector,\n                tolerance: 'pointer',\n                cancel: 'input, button, .uploader',\n                update: $.proxy(function () {\n                    this.element.trigger('resort');\n                }, this)\n            });\n        },\n\n        /**\n         * Set image as main\n         * @param {Object} imageData\n         * @private\n         */\n        setBase: function (imageData) {\n            var baseImage = this.options.types.image,\n                sameImages = $.grep(\n                    $.map(this.options.types, function (el) {\n                        return el;\n                    }),\n                    function (el) {\n                        return el.value === baseImage.value;\n                    }\n                ),\n                isImageOpened = this.findElement(imageData).hasClass('active');\n\n            $.each(sameImages, $.proxy(function (index, image) {\n                this.element.trigger('setImageType', {\n                    type: image.code,\n                    imageData: imageData\n                });\n\n                if (isImageOpened) {\n                    this.element.find('.item').addClass('selected');\n                    this.element.find('[data-role=type-selector]').prop({\n                        'checked': true\n                    });\n                }\n            }, this));\n        },\n\n        /**\n         * Find element by fileName\n         * @param {Object} data\n         * @returns {Element}\n         */\n        findElement: function (data) {\n            return this.element.find(this.options.imageSelector).filter(function () {\n                return $(this).data('imageData').file === data.file;\n            }).first();\n        },\n\n        /**\n         * Mark parent fieldset that content was updated\n         */\n        _contentUpdated: function () {\n            if (this.options.initialized && this.options.parentComponent) {\n                registry.async(this.options.parentComponent)(\n                    function (parentComponent) {\n                        parentComponent.bubble('update', true);\n                    }\n                );\n            }\n        },\n\n        /**\n         * Add image\n         * @param {jQuery.Event} event\n         * @param {Object} imageData\n         * @private\n         */\n        _addItem: function (event, imageData) {\n            var element,\n                imgElement,\n                lastElement,\n                count,\n                position;\n\n            if (this._isInitializingItems) {\n                count = this._initializedItemCount++;\n                lastElement = this._lastInitializedElement;\n            } else {\n                count = this.element.find(this.options.imageSelector).length;\n                lastElement = this.element.find(this.options.imageSelector + ':last');\n            }\n\n            position = count + 1;\n\n            if (lastElement && lastElement.length === 1) {\n                position = parseInt(lastElement.data('imageData').position || count, 10) + 1;\n            }\n            imageData = $.extend({\n                'file_id': imageData['value_id'] ? imageData['value_id'] : Math.random().toString(33).substr(2, 18),\n                'disabled': imageData.disabled ? imageData.disabled : 0,\n                'position': position,\n                sizeLabel: bytesToSize(imageData.size)\n            }, imageData);\n\n            element = this.imgTmpl({\n                data: imageData\n            });\n\n            element = $(element).data('imageData', imageData);\n\n            if (count === 0) {\n                element.prependTo(this.element);\n            } else {\n                element.insertAfter(lastElement);\n            }\n\n            this._lastInitializedElement = element;\n\n            if (!this.options.initialized &&\n                this.options.images.length === 0 ||\n                this.options.initialized &&\n                this.element.find(this.options.imageSelector + ':not(.removed)').length === 1\n            ) {\n                this.setBase(imageData);\n            }\n\n            imgElement = element.find(this.options.imageElementSelector);\n\n            imgElement.on('load', this._updateImageDimesions.bind(this, element));\n\n            $.each(this.options.types, $.proxy(function (index, image) {\n                if (imageData.file === image.value) {\n                    this.element.trigger('setImageType', {\n                        type: image.code,\n                        imageData: imageData\n                    });\n                }\n            }, this));\n\n            if (!this._isInitializingItems) {\n                this._updateImagesRoles();\n                this._contentUpdated();\n            }\n        },\n\n        /**\n         * Returns a list of current images.\n         *\n         * @returns {jQueryCollection}\n         */\n        _getImages: function () {\n            return this.element.find(this.options.imageSelector);\n        },\n\n        /**\n         * Returns a list of images roles.\n         *\n         * @return {Object}\n         */\n        _getRoles: function () {\n            return _.mapObject(this.options.types, function (data, key) {\n                var elem = this.element.find('.image-' + key);\n\n                return {\n                    index: key,\n                    value: elem.val(),\n                    elem: elem\n                };\n            }, this);\n        },\n\n        /**\n         * Updates labels with roles information for each image.\n         */\n        _updateImagesRoles: function () {\n            var $images = this._getImages().toArray(),\n                roles = this._getRoles();\n\n            $images.forEach(function (img) {\n                var $img = $(img),\n                    data = $img.data('imageData');\n\n                $img.find('[data-role=roles-labels] li').each(function (index, elem) {\n                    var $elem = $(elem),\n                        roleCode = $elem.data('roleCode'),\n                        role = roles[roleCode];\n\n                    role.value === data.file  ?\n                        $elem.show() :\n                        $elem.hide();\n                });\n\n            });\n        },\n\n        /**\n         * Updates image's dimensions information.\n         *\n         * @param {jQeuryCollection} imgContainer\n         */\n        _updateImageDimesions: function (imgContainer) {\n            var $img = imgContainer.find(this.options.imageElementSelector)[0],\n                $dimens = imgContainer.find('[data-role=image-dimens]');\n\n            $dimens.text($img.naturalWidth + 'x' + $img.naturalHeight + ' px');\n        },\n\n        /**\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         */\n        _updateImageTitle: function (event, data) {\n            var imageData = data.imageData,\n                $imgContainer = this.findElement(imageData),\n                $title = $imgContainer.find(this.options.imgTitleSelector),\n                value;\n\n            value = imageData['media_type'] === 'external-video' ?\n                imageData['video_title'] :\n                imageData.label;\n\n            $title.text(value);\n\n            this._contentUpdated();\n        },\n\n        /**\n         * Remove Image\n         * @param {jQuery.Event} event\n         * @param {Object} imageData\n         * @private\n         */\n        _removeItem: function (event, imageData) {\n            var $imageContainer = this.findElement(imageData);\n\n            imageData.isRemoved = true;\n            $imageContainer.addClass('removed').hide().find('.is-removed').val(1);\n\n            this._contentUpdated();\n        },\n\n        /**\n         * Set image type\n         * @param {jQuery.Event} event\n         * @param {Obejct} data\n         * @private\n         */\n        _setImageType: function (event, data) {\n            if (data.type === 'image') {\n                this.element.find('.base-image').removeClass('base-image');\n            }\n\n            if (data.imageData) {\n                this.options.types[data.type].value = data.imageData.file;\n\n                if (data.type === 'image') {\n                    this.findElement(data.imageData).addClass('base-image');\n                }\n            } else {\n                this.options.types[data.type].value = 'no_selection';\n            }\n            this.element.find('.image-' + data.type).val(this.options.types[data.type].value || 'no_selection');\n            this._updateImagesRoles();\n            this._contentUpdated();\n        },\n\n        /**\n         * Resort images\n         * @private\n         */\n        _resort: function () {\n            this.element.find('.position').each($.proxy(function (index, element) {\n                var value = $(element).val();\n\n                if (value != index) { //eslint-disable-line eqeqeq\n                    this.element.trigger('moveElement', {\n                        imageData: $(element).closest(this.options.imageSelector).data('imageData'),\n                        position: index\n                    });\n                    $(element).val(index);\n                }\n            }, this));\n\n            this._contentUpdated();\n        },\n\n        /**\n         * Set image position\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _setPosition: function (event, data) {\n            var $element = this.findElement(data.imageData),\n                curIndex = this.element.find(this.options.imageSelector).index($element),\n                newPosition = data.position + (curIndex > data.position ? -1 : 0);\n\n            if (data.position != curIndex) { //eslint-disable-line eqeqeq\n                if (data.position === 0) {\n                    this.element.prepend($element);\n                } else {\n                    $element.insertAfter(\n                        this.element.find(this.options.imageSelector).eq(newPosition)\n                    );\n                }\n                this.element.trigger('resort');\n            }\n\n            this._contentUpdated();\n        }\n    });\n\n    // Extension for mage.productGallery - Add advanced settings block\n    $.widget('mage.productGallery', $.mage.productGallery, {\n        options: {\n            dialogTemplate: '[data-role=img-dialog-tmpl]',\n            dialogContainerTmpl: '[data-role=img-dialog-container-tmpl]'\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var template = this.element.find(this.options.dialogTemplate),\n                containerTmpl = this.element.find(this.options.dialogContainerTmpl);\n\n            this._super();\n            this.modalPopupInit = false;\n\n            if (template.length) {\n                this.dialogTmpl = mageTemplate(template.html().trim());\n            }\n\n            if (containerTmpl.length) {\n                this.dialogContainerTmpl = mageTemplate(containerTmpl.html().trim());\n            } else {\n                this.dialogContainerTmpl = mageTemplate('');\n            }\n\n            this._initDialog();\n        },\n\n        /**\n         * Bind handler to elements\n         * @protected\n         */\n        _bind: function () {\n            var events = {};\n\n            this._super();\n\n            events['click [data-role=close-panel]'] = $.proxy(function () {\n                this.element.find('[data-role=dialog]').trigger('close');\n            }, this);\n\n            /**\n             * @param {jQuery.Event} event\n             */\n            events['click ' + this.options.imageSelector] = function (event) {\n                var imageData, $imageContainer;\n\n                if (!$(event.currentTarget).is('.ui-sortable-helper')) {\n                    $(event.currentTarget).addClass('active');\n                    imageData = $(event.currentTarget).data('imageData');\n                    $imageContainer = this.findElement(imageData);\n\n                    if ($imageContainer.is('.removed')) {\n                        return;\n                    }\n                    this.element.trigger('openDialog', [imageData]);\n                }\n            };\n            this._on(events);\n            this.element.on('sortstart', $.proxy(function () {\n                this.element.find('[data-role=dialog]').trigger('close');\n            }, this));\n        },\n\n        /**\n         * Initializes dialog element.\n         */\n        _initDialog: function () {\n            var $dialog = $(this.dialogContainerTmpl());\n\n            $dialog.modal({\n                'type': 'slide',\n                title: $.mage.__('Image Detail'),\n                buttons: [],\n\n                /** @inheritdoc */\n                opened: function () {\n                    $dialog.trigger('open');\n                },\n\n                /** @inheritdoc */\n                closed: function () {\n                    $dialog.trigger('close');\n                }\n            });\n\n            $dialog.on('open', this.onDialogOpen.bind(this));\n            $dialog.on('close', function () {\n                var $imageContainer = $dialog.data('imageContainer');\n\n                $imageContainer.removeClass('active');\n                $dialog.find('#hide-from-product-page').remove();\n            });\n\n            $dialog.on('change', '[data-role=type-selector]', function () {\n                var parent = $(this).closest('.item'),\n                    selectedClass = 'selected';\n\n                parent.toggleClass(selectedClass, $(this).prop('checked'));\n            });\n\n            $dialog.on('change', '[data-role=type-selector]', $.proxy(this._notifyType, this));\n\n            $dialog.on('change', '[data-role=visibility-trigger]', $.proxy(function (e) {\n                var imageData = $dialog.data('imageData');\n\n                this.element.trigger('updateVisibility', {\n                    disabled: $(e.currentTarget).is(':checked'),\n                    imageData: imageData\n                });\n            }, this));\n\n            $dialog.on('change', '[data-role=\"image-description\"]', function (e) {\n                var target = $(e.target),\n                    targetName = target.attr('name'),\n                    desc = target.val(),\n                    imageData = $dialog.data('imageData');\n\n                this.element.find('input[type=\"hidden\"][name=\"' + targetName + '\"]').val(desc);\n\n                imageData.label = desc;\n                imageData['label_default'] = desc;\n\n                this.element.trigger('updateImageTitle', {\n                    imageData: imageData\n                });\n            }.bind(this));\n\n            this.$dialog = $dialog;\n        },\n\n        /**\n         * @param {Object} imageData\n         * @private\n         */\n        _showDialog: function (imageData) {\n            var $imageContainer = this.findElement(imageData),\n                $template;\n\n            $template = this.dialogTmpl({\n                'data': imageData\n            });\n\n            this.$dialog\n                .html($template)\n                .data('imageData', imageData)\n                .data('imageContainer', $imageContainer)\n                .modal('openModal');\n        },\n\n        /**\n         * Handles dialog open event.\n         *\n         * @param {EventObject} event\n         */\n        onDialogOpen: function (event) {\n            var imageData = this.$dialog.data('imageData'),\n                imageSizeKb = imageData.sizeLabel,\n                image = document.createElement('img'),\n                sizeSpan = this.$dialog.find(this.options.imageSizeLabel)\n                    .find('[data-message]'),\n                resolutionSpan = this.$dialog.find(this.options.imageResolutionLabel)\n                    .find('[data-message]'),\n                sizeText = sizeSpan.attr('data-message').replace('{size}', imageSizeKb),\n                resolutionText;\n\n            image.src = imageData.url;\n\n            resolutionText = resolutionSpan\n                .attr('data-message')\n                .replace('{width}^{height}', image.width + 'x' + image.height);\n\n            sizeSpan.text(sizeText);\n            resolutionSpan.text(resolutionText);\n\n            $(event.target)\n                .find('[data-role=type-selector]')\n                .each($.proxy(function (index, checkbox) {\n                    var $checkbox = $(checkbox),\n                        parent = $checkbox.closest('.item'),\n                        selectedClass = 'selected',\n                        isChecked = this.options.types[$checkbox.val()].value == imageData.file; //eslint-disable-line\n\n                    $checkbox.prop(\n                        'checked',\n                        isChecked\n                    );\n                    parent.toggleClass(selectedClass, isChecked);\n                }, this));\n        },\n\n        /**\n         *\n         * Click by image handler\n         *\n         * @param {jQuery.Event} e\n         * @param {Object} imageData\n         * @private\n         */\n        _onOpenDialog: function (e, imageData) {\n            if (imageData['media_type'] && imageData['media_type'] != 'image') { //eslint-disable-line eqeqeq\n                return;\n            }\n            this._showDialog(imageData);\n        },\n\n        /**\n         * Change visibility\n         *\n         * @param {jQuery.Event} event\n         * * @param {Object} data\n         * @private\n         */\n        _updateVisibility: function (event, data) {\n            var imageData = data.imageData,\n                disabled = +data.disabled,\n                $imageContainer = this.findElement(imageData);\n\n            !!disabled ? //eslint-disable-line no-extra-boolean-cast\n                $imageContainer.addClass('hidden-for-front') :\n                $imageContainer.removeClass('hidden-for-front');\n\n            $imageContainer.find('[name*=\"disabled\"]').val(disabled);\n            imageData.disabled = disabled;\n\n            this._contentUpdated();\n        },\n\n        /**\n         * Set image\n         * @param {jQuery.Event} event\n         * @private\n         */\n        _notifyType: function (event) {\n            var $checkbox = $(event.currentTarget),\n                $imageContainer = $checkbox.closest('[data-role=dialog]').data('imageContainer');\n\n            this.element.trigger('setImageType', {\n                type: $checkbox.val(),\n                imageData: $checkbox.is(':checked') ? $imageContainer.data('imageData') : null\n            });\n\n            this._updateImagesRoles();\n        }\n    });\n\n    return $.mage.productGallery;\n});\n","Magento_Catalog/js/components/attribute-set-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/ui-select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            listens: {\n                'value': 'changeFormSubmitUrl'\n            },\n            modules: {\n                formProvider: '${ $.provider }'\n            }\n        },\n\n        /**\n         * Change set parameter in save and validate urls of form\n         *\n         * @param {String|Number} value\n         */\n        changeFormSubmitUrl: function (value) {\n            var pattern = /(set\\/)(\\d)*?\\//,\n                change = '$1' + value + '/';\n\n            this.formProvider().client.urls.save = this.formProvider().client.urls.save.replace(pattern, change);\n            this.formProvider().client.urls.beforeSave = this.formProvider().client.urls.beforeSave.replace(\n                pattern,\n                change\n            );\n        }\n    });\n});\n","Magento_Catalog/js/components/attributes-fieldset.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/fieldset',\n    'Magento_Ui/js/core/app'\n], function (Fieldset, app) {\n    'use strict';\n\n    return Fieldset.extend({\n        defaults: {\n            listens: {\n                '${ $.provider }:additionalAttributes': 'onAttributeAdd'\n            }\n        },\n\n        /**\n         * On attribute add trigger\n         *\n         * @param {Object} listOfNewAttributes\n         */\n        onAttributeAdd: function (listOfNewAttributes) {\n            app(listOfNewAttributes, true);\n        }\n    });\n});\n","Magento_Catalog/js/components/attributes-grid-paging.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/paging/paging',\n    'underscore'\n], function (Paging, _) {\n    'use strict';\n\n    return Paging.extend({\n        defaults: {\n            totalTmpl: 'Magento_Catalog/attributes/grid/paging',\n            modules: {\n                selectionColumn: '${ $.selectProvider }'\n            },\n            listens: {\n                '${ $.selectProvider }:selected': 'changeLabel'\n            },\n            label: '',\n            selectedAttrs: []\n        },\n\n        /**\n         * Change label.\n         *\n         * @param {Array} selected\n         */\n        changeLabel: function (selected) {\n            this.selectedAttrs = [];\n            _.each(this.selectionColumn().rows(), function (row) {\n                if (selected.indexOf(row['attribute_id']) !== -1) {\n                    this.selectedAttrs.push(row['attribute_code']);\n                }\n            }, this);\n\n            this.label(this.selectedAttrs.join(', '));\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super()\n                .observe('label');\n\n            return this;\n        }\n    });\n});\n","Magento_Catalog/js/components/attributes-insert-listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/lib/view/utils/async',\n    'uiRegistry',\n    'underscore',\n    'Magento_Ui/js/form/components/insert-listing'\n], function ($, registry, _, InsertListing) {\n    'use strict';\n\n    return InsertListing.extend({\n        defaults: {\n            addAttributeUrl: '',\n            attributeSetId: '',\n            attributeIds: '',\n            groupCode: '',\n            groupName: '',\n            groupSortOrder: 0,\n            productId: 0,\n            formProvider: '',\n            modules: {\n                form: '${ $.formProvider }',\n                modal: '${ $.parentName }'\n            },\n            productType: ''\n        },\n\n        /**\n         * Render attribute\n         */\n        render: function () {\n            this._super();\n        },\n\n        /**\n         * Save attribute\n         */\n        save: function () {\n            this.addSelectedAttributes();\n            this._super();\n        },\n\n        /**\n         * Add selected attributes\n         */\n        addSelectedAttributes: function () {\n            $.ajax({\n                url: this.addAttributeUrl,\n                type: 'POST',\n                dataType: 'json',\n                data: {\n                    attributeIds: this.selections().getSelections(),\n                    templateId: this.attributeSetId,\n                    groupCode: this.groupCode,\n                    groupName: this.groupName,\n                    groupSortOrder: this.groupSortOrder,\n                    productId: this.productId,\n                    componentJson: 1\n                },\n                success: function () {\n                    this.form().params = {\n                        set: this.attributeSetId,\n                        id: this.productId,\n                        type: this.productType\n                    };\n                    this.form().reload();\n                    this.modal().state(false);\n                    this.reload();\n                }.bind(this)\n            });\n        }\n    });\n});\n","Magento_Catalog/js/components/checkbox.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated since version 2.2.0\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'knockout'\n], function (Abstract, ko) {\n    'use strict';\n\n    return Abstract.extend({\n\n        /**\n         * Initializes observable properties of instance\n         *\n         * @returns {Element} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe('checked');\n\n            this.value = ko.pureComputed({\n\n                /**\n                 * use 'mappedValue' as value if checked\n                 */\n                read: function () {\n                    return this.checked() ? this.mappedValue : '';\n                },\n\n                /**\n                 * any value made checkbox checked\n                 */\n                write: function (val) {\n                    if (val) {\n                        this.checked(true);\n                    }\n                },\n                owner: this\n            });\n\n            return this;\n        }\n    });\n});\n","Magento_Catalog/js/components/custom-options-component.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        /**\n         * {@inheritdoc}\n         */\n        setInitialValue: function () {\n            this._super();\n\n            this.addBefore(this.addbefore);\n\n            return this;\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initObservable: function () {\n            this._super();\n\n            this.observe('addBefore');\n\n            return this;\n        }\n    });\n});\n","Magento_Catalog/js/components/custom-options-price-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/select',\n    'uiRegistry'\n], function (_, Select, uiRegistry) {\n    'use strict';\n\n    return Select.extend({\n        /**\n         * {@inheritdoc}\n         */\n        onUpdate: function () {\n            this._super();\n\n            this.updateAddBeforeForPrice();\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        setInitialValue: function () {\n            this._super();\n\n            this.updateAddBeforeForPrice();\n\n            return this;\n        },\n\n        /**\n         * Update addbefore for price field. Change it to currency or % depends of price_type value.\n         */\n        updateAddBeforeForPrice: function () {\n            var addBefore, currentValue, priceIndex, priceName, uiPrice;\n\n            priceIndex = typeof this.imports.priceIndex == 'undefined' ? 'price' : this.imports.priceIndex;\n            priceName = this.parentName + '.' + priceIndex;\n\n            uiPrice = uiRegistry.get(priceName);\n\n            if (uiPrice && uiPrice.addbeforePool) {\n                currentValue = this.value();\n\n                uiPrice.addbeforePool.forEach(function (item) {\n                    if (item.value === currentValue) {\n                        addBefore = item.label;\n                    }\n                });\n\n                if (typeof addBefore != 'undefined') {\n                    uiPrice.addBefore(addBefore);\n                }\n            }\n        }\n    });\n});\n","Magento_Catalog/js/components/disable-hide-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'Magento_Catalog/js/components/visible-on-option/strategy',\n    'Magento_Catalog/js/components/disable-on-option/strategy'\n], function (Element, visibleStrategy, disableStrategy) {\n    'use strict';\n\n    return Element.extend(visibleStrategy).extend(disableStrategy);\n});\n","Magento_Catalog/js/components/dynamic-rows-import-custom-options.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/dynamic-rows/dynamic-rows-grid',\n    'underscore',\n    'mageUtils'\n], function (DynamicRows, _, utils) {\n    'use strict';\n\n    return DynamicRows.extend({\n        defaults: {\n            mappingSettings: {\n                enabled: false,\n                distinct: false\n            },\n            update: true,\n            map: {\n                'option_id': 'option_id'\n            },\n            identificationProperty: 'option_id',\n            identificationDRProperty: 'option_id'\n        },\n\n        /** @inheritdoc */\n        processingInsertData: function (data) {\n            var options = [],\n                currentOption,\n                generalContext = this;\n\n            if (!data) {\n                return;\n            }\n            _.each(data, function (item) {\n                if (!item.options) {\n                    return;\n                }\n                _.each(item.options, function (option) {\n                    currentOption = utils.copy(option);\n\n                    if (currentOption.hasOwnProperty('sort_order')) {\n                        delete currentOption['sort_order'];\n                    }\n\n                    if (currentOption.hasOwnProperty('option_id')) {\n                        delete currentOption['option_id'];\n                    }\n\n                    if (currentOption.values.length > 0) {\n                        generalContext.removeOptionsIds(currentOption.values);\n                    }\n                    options.push(currentOption);\n                });\n            });\n\n            if (!options.length) {\n                return;\n            }\n            this.cacheGridData = options;\n            _.each(options, function (opt) {\n                this.mappingValue(opt);\n            }, this);\n\n            this.insertData([]);\n        },\n\n        /**\n         * Removes option_id and option_type_id from every option\n         *\n         * @param {Array} options\n         */\n        removeOptionsIds: function (options) {\n            _.each(options, function (optionValue) {\n                delete optionValue['option_id'];\n                delete optionValue['option_type_id'];\n            });\n        },\n\n        /** @inheritdoc */\n        processingAddChild: function (ctx, index, prop) {\n            if (!ctx) {\n                this.showSpinner(true);\n                this.addChild(ctx, index, prop);\n\n                return;\n            }\n\n            this._super(ctx, index, prop);\n        },\n\n        /**\n         * Set empty array to dataProvider\n         */\n        clearDataProvider: function () {\n            this.source.set(this.dataProvider, []);\n        },\n\n        /**\n         * Mutes parent method\n         */\n        updateInsertData: function () {\n            return false;\n        }\n    });\n});\n","Magento_Catalog/js/components/dynamic-rows-per-page.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/dynamic-rows/dynamic-rows',\n    'underscore',\n    'mageUtils',\n    'uiLayout',\n    'rjsResolver'\n], function (DynamicRows, _, utils, layout, resolver) {\n    'use strict';\n\n    return DynamicRows.extend({\n        defaults: {\n            sizesConfig: {\n                component: 'Magento_Ui/js/grid/paging/sizes',\n                name: '${ $.name }_sizes',\n                options: {\n                    '20': {\n                        value: 20,\n                        label: 20\n                    },\n                    '30': {\n                        value: 30,\n                        label: 30\n                    },\n                    '50': {\n                        value: 50,\n                        label: 50\n                    },\n                    '100': {\n                        value: 100,\n                        label: 100\n                    },\n                    '200': {\n                        value: 200,\n                        label: 200\n                    }\n                },\n                storageConfig: {\n                    provider: '${ $.storageConfig.provider }',\n                    namespace: '${ $.storageConfig.namespace }'\n                },\n                enabled: false\n            },\n            links: {\n                options: '${ $.sizesConfig.name }:options',\n                pageSize: '${ $.sizesConfig.name }:value'\n            },\n            listens: {\n                'pageSize': 'onPageSizeChange'\n            },\n            modules: {\n                sizes: '${ $.sizesConfig.name }'\n            }\n        },\n\n        /**\n         * Initializes paging component.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initialize: function () {\n            this._super()\n                .initSizes();\n\n            return this;\n        },\n\n        /**\n         * Initializes sizes component.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initSizes: function () {\n            if (this.sizesConfig.enabled) {\n                layout([this.sizesConfig]);\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Paging} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track([\n                    'pageSize'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Handles changes of the page size.\n         */\n        onPageSizeChange: function () {\n            resolver(function () {\n                if (this.elems().length) {\n                    this.reload();\n                }\n            }, this);\n        }\n    });\n});\n","Magento_Catalog/js/components/dynamic-rows-tier-price.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows'\n], function (_, DynamicRows) {\n    'use strict';\n\n    /**\n     * @deprecated Parent method contains labels sorting.\n     * @see Magento_Ui/js/dynamic-rows/dynamic-rows\n     */\n    return DynamicRows.extend({\n\n        /**\n         * Init header elements\n         */\n        initHeader: function () {\n            var labels;\n\n            this._super();\n            labels = _.clone(this.labels());\n            labels = _.sortBy(labels, function (label) {\n                return label.sortOrder;\n            });\n\n            this.labels(labels);\n        }\n    });\n});\n","Magento_Catalog/js/components/import-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'underscore',\n    'uiRegistry'\n], function (Abstract, _, registry) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            allowImport: true,\n            autoImportIfEmpty: false,\n            values: {},\n            mask: '',\n            queryTemplate: 'ns = ${ $.ns }, index = '\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            if (this.allowImport) {\n                this.setHandlers();\n            }\n        },\n\n        /**\n         * Split mask placeholder and attach events to placeholder fields.\n         */\n        setHandlers: function () {\n            var str = this.mask || '',\n                placeholders;\n\n            placeholders = str.match(/{{(.*?)}}/g); // Get placeholders\n\n            _.each(placeholders, function (placeholder) {\n                placeholder = placeholder.replace(/[{{}}]/g, ''); // Remove curly braces\n\n                registry.get(this.queryTemplate + placeholder, function (component) {\n                    this.values[placeholder] = component.getPreview();\n                    component.on('value', this.updateValue.bind(this, placeholder, component));\n                    component.valueUpdate = 'keyup';\n                }.bind(this));\n            }, this);\n        },\n\n        /**\n         * Update field with mask value, if it's allowed.\n         *\n         * @param {Object} placeholder\n         * @param {Object} component\n         */\n        updateValue: function (placeholder, component) {\n            var string = this.mask || '',\n                nonEmptyValueFlag = false;\n\n            if (placeholder) {\n                this.values[placeholder] = component.getPreview() || '';\n            }\n\n            if (!this.allowImport) {\n                return;\n            }\n\n            _.each(this.values, function (propertyValue, propertyName) {\n                string = string.replace('{{' + propertyName + '}}', propertyValue);\n                nonEmptyValueFlag = nonEmptyValueFlag || !!propertyValue;\n            });\n\n            if (nonEmptyValueFlag) {\n                string = string.replace(/(<([^>]+)>)/ig, ''); // Remove html tags\n                this.value(string);\n            } else {\n                this.value('');\n            }\n        },\n\n        /**\n         * Disallow import when initial value isn't empty string\n         *\n         * @returns {*}\n         */\n        setInitialValue: function () {\n            this._super();\n\n            if (this.initialValue !== '') {\n                this.allowImport = false;\n            }\n\n            return this;\n        },\n\n        /**\n         *  Callback when value is changed by user,\n         *  and disallow/allow import value\n         */\n        userChanges: function () {\n\n            /**\n             *  As userChanges is called before updateValue,\n             *  we forced to get value from component by reference\n             */\n            var actualValue = arguments[1].currentTarget.value;\n\n            this._super();\n\n            if (actualValue === '') {\n                this.allowImport = true;\n\n                if (this.autoImportIfEmpty) {\n                    this.updateValue(null, null);\n                }\n            } else {\n                this.allowImport = false;\n            }\n        }\n    });\n});\n","Magento_Catalog/js/components/messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/html'\n], function (Html) {\n    'use strict';\n\n    return Html.extend({\n        defaults: {\n            form: '${ $.namespace }.${ $.namespace }',\n            visible: false,\n            imports: {\n                responseData: '${ $.form }:responseData',\n                visible: 'responseData.error',\n                content: 'responseData.messages'\n            },\n            listens: {\n                '${ $.provider }:data.reset': 'hide'\n            }\n        },\n\n        /**\n         * Show messages.\n         */\n        show: function () {\n            this.visible(true);\n        },\n\n        /**\n         * Hide messages.\n         */\n        hide: function () {\n            this.visible(false);\n        }\n    });\n});\n","Magento_Catalog/js/components/new-attribute-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/form',\n    'Magento_Ui/js/modal/prompt',\n    'Magento_Ui/js/modal/alert'\n], function ($, Form, prompt, alert) {\n    'use strict';\n\n    return Form.extend({\n        defaults: {\n            newSetPromptMessage: '',\n            listens: {\n                responseData: 'processResponseData'\n            },\n            modules: {\n                productForm: 'product_form.product_form'\n            }\n        },\n\n        /**\n         * Process response data\n         *\n         * @param {Object} data\n         */\n        processResponseData: function (data) {\n            if (data.params['new_attribute_set_id']) {\n                this.productForm().params = {\n                    set: data.params['new_attribute_set_id']\n                };\n            }\n        },\n\n        /**\n         * Process Save In New Attribute Set prompt\n         */\n        saveAttributeInNewSet: function () {\n\n            var self = this;\n\n            this.validate();\n\n            if (!this.additionalInvalid && !this.source.get('params.invalid')) {\n                prompt({\n                    content: this.newSetPromptMessage,\n                    actions: {\n\n                        /**\n                         * @param {String} val\n                         * @this {actions}\n                         */\n                        confirm: function (val) {\n                            var rules = ['required-entry', 'validate-no-html-tags'],\n                                editForm = self,\n                                newAttributeSetName = val,\n                                i,\n                                params = {};\n\n                            if (!newAttributeSetName) {\n                                return;\n                            }\n\n                            for (i = 0; i < rules.length; i++) {\n                                if (!$.validator.methods[rules[i]](newAttributeSetName)) {\n                                    alert({\n                                        content: $.validator.messages[rules[i]]\n                                    });\n\n                                    return;\n                                }\n                            }\n\n                            params['new_attribute_set_name'] = newAttributeSetName;\n                            editForm.setAdditionalData(params);\n                            editForm.save();\n                        }\n                    }\n                });\n            } else {\n                this.focusInvalid();\n            }\n        }\n    });\n});\n","Magento_Catalog/js/components/new-attribute-insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-form'\n], function (InsertForm) {\n    'use strict';\n\n    return InsertForm.extend({\n        defaults: {\n            modules: {\n                productForm: 'product_form.product_form'\n            },\n            listens: {\n                responseStatus: 'processResponseStatus'\n            },\n            attributeSetId: 0,\n            productId: 0\n        },\n\n        /**\n         * Process response status.\n         */\n        processResponseStatus: function () {\n            if (this.responseStatus()) {\n\n                if (this.productForm().params === undefined) {\n                    this.productForm().params = {\n                        set: this.attributeSetId\n                    };\n                }\n\n                if (this.productId) {\n                    this.productForm().params.id = this.productId;\n                }\n                this.productForm().params.type = this.productType;\n\n                this.productForm().reload();\n                this.resetForm();\n            }\n        }\n    });\n});\n","Magento_Catalog/js/components/new-category.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/ui-select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n\n        /**\n         * Parse data and set it to options.\n         *\n         * @param {Object} data - Response data object.\n         * @returns {Object}\n         */\n        setParsed: function (data) {\n            var option = this.parseData(data);\n\n            if (data.error) {\n                return this;\n            }\n\n            this.options([]);\n            this.setOption(option);\n            this.set('newOption', option);\n        },\n\n        /**\n         * Normalize option object.\n         *\n         * @param {Object} data - Option object.\n         * @returns {Object}\n         */\n        parseData: function (data) {\n            return {\n                'is_active': data.category['is_active'],\n                level: data.category.level,\n                value: data.category['entity_id'],\n                label: data.category.name,\n                parent: data.category.parent\n            };\n        }\n    });\n});\n","Magento_Catalog/js/components/product-ui-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @deprecated see Magento/Ui/view/base/web/js/grid/filters/elements/ui-select.js\n */\ndefine([\n    'Magento_Ui/js/form/element/ui-select',\n    'jquery',\n    'underscore'\n], function (Select, $, _) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            validationUrl: false,\n            loadedOption: [],\n            validationLoading: true\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.validateInitialValue();\n\n            return this;\n        },\n\n        /**\n         * Validate initial value actually exists\n         */\n        validateInitialValue: function () {\n            if (!_.isEmpty(this.value())) {\n                $.ajax({\n                    url: this.validationUrl,\n                    type: 'GET',\n                    dataType: 'json',\n                    context: this,\n                    data: {\n                        productId: this.value()\n                    },\n\n                    /** @param {Object} response */\n                    success: function (response) {\n                        if (!_.isEmpty(response)) {\n                            this.options([response]);\n                            this.loadedOption = response;\n                        }\n                    },\n\n                    /** set empty array if error occurs */\n                    error: function () {\n                        this.options([]);\n                    },\n\n                    /** stop loader */\n                    complete: function () {\n                        this.validationLoading(false);\n                        this.setCaption();\n                    }\n                });\n            } else {\n                this.validationLoading(false);\n            }\n        },\n\n        /** @inheritdoc */\n        getSelected: function () {\n            var options = this._super();\n\n            if (!_.isEmpty(this.loadedOption)) {\n                return this.value() === this.loadedOption.value ? [this.loadedOption] : options;\n            }\n\n            return options;\n        }\n    });\n});\n","Magento_Catalog/js/components/reset-dynamic-rows-grid-row-position-on-delete.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'rjsResolver',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows-grid'\n], function (_, registry, resolver, dynamicRowsGrid) {\n    'use strict';\n\n    return dynamicRowsGrid.extend({\n\n        /** @inheritdoc */\n        deleteRecord: function () {\n            this._super();\n            this.resetPosition();\n        },\n\n        /**\n         * Reset the position on delete of the record.\n         */\n        resetPosition() {\n            let self = this,\n                position = 0;\n\n            _.filter(this.elems(), function (elem, index) {\n                if (index === 0) {\n                    position = (self.currentPage() - 1) * self.pageSize + 1;\n                }\n                _.filter(elem.elems(),function (childElem) {\n                    if (childElem.index === 'position') {\n                        childElem.value(position);\n                    }\n                });\n                position++;\n            });\n        },\n\n        /** @inheritdoc */\n        nextPage: function () {\n            this._super();\n            resolver(function () {\n                if (this.elems().length) {\n                    this.resetPosition();\n                }\n            }, this);\n        }\n    });\n});\n","Magento_Catalog/js/components/url-key-handle-changes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (Checkbox) {\n    'use strict';\n\n    return Checkbox.extend({\n        defaults: {\n            imports: {\n                handleUseDefault: '${ $.parentName }.use_default.url_key:checked',\n                urlKey: '${ $.provider }:data.url_key'\n            },\n            listens: {\n                urlKey: 'handleChanges'\n            },\n            modules: {\n                useDefault: '${ $.parentName }.use_default.url_key'\n            }\n        },\n\n        /**\n         * Disable checkbox field, when 'url_key' field without changes or 'use default' field is checked\n         */\n        handleChanges: function (newValue) {\n            this.disabled(newValue === this.valueMap['true'] || this.useDefault.checked);\n        },\n\n        /**\n         * Disable checkbox field, when 'url_key' field without changes or 'use default' field is checked\n         */\n        handleUseDefault: function (checkedUseDefault) {\n            this.disabled(this.urlKey === this.valueMap['true'] || checkedUseDefault);\n        }\n    });\n});\n","Magento_Catalog/js/components/website-currency-symbol.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            currenciesForWebsites: {},\n            tracks: {\n                currency: true\n            }\n        },\n\n        /**\n         * Set currency symbol per website\n         *\n         * @param {String} value - currency symbol\n         */\n        setDifferedFromDefault: function (value) {\n            this.currency = this.currenciesForWebsites[value];\n\n            return this._super();\n        }\n    });\n});\n","Magento_Catalog/js/components/disable-on-option/input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'Magento_Catalog/js/components/disable-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/disable-on-option/select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'Magento_Catalog/js/components/disable-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/disable-on-option/strategy.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function () {\n    'use strict';\n\n    return {\n        defaults: {\n            valuesForEnable: [],\n            disabled: true,\n            imports: {\n                toggleDisable:\n                    'product_attribute_add_form.product_attribute_add_form.base_fieldset.frontend_input:value'\n            }\n        },\n\n        /**\n         * Toggle disabled state.\n         *\n         * @param {Number} selected\n         */\n        toggleDisable: function (selected) {\n            this.disabled(!(selected in this.valuesForEnable));\n        }\n    };\n});\n","Magento_Catalog/js/components/disable-on-option/yesno.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox',\n    'Magento_Catalog/js/components/disable-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    var comp = Element.extend(strategy).extend({\n\n        defaults: {\n            listens: {\n                disabled: 'updateValueForDisabledField',\n                visible: 'updateValueForDisabledField'\n            }\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super();\n            this.updateValueForDisabledField();\n\n            return this;\n        },\n\n        /**\n         * Set element value to O(No) if element is invisible and disabled\n         * Set element value to initialValue if element becomes visible and enable\n         */\n        updateValueForDisabledField: function () {\n            if (!this.disabled() && this.visible()) {\n                this.set('value', this.initialValue);\n            } else {\n                this.set('value', 0);\n            }\n        }\n    });\n\n    return comp.extend(strategy);\n});\n","Magento_Catalog/js/components/use-parent-settings/select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Component) {\n    'use strict';\n\n    return Component;\n});\n","Magento_Catalog/js/components/use-parent-settings/single-checkbox.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (Component) {\n    'use strict';\n\n    return Component;\n});\n","Magento_Catalog/js/components/use-parent-settings/textarea.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'Magento_Ui/js/form/element/textarea'\n], function (Component) {\n    'use strict';\n\n    return Component;\n});\n","Magento_Catalog/js/components/use-parent-settings/toggle-disabled-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    var mixin = {\n        defaults: {\n            imports: {\n                toggleDisabled: '${ $.parentName }.custom_use_parent_settings:checked'\n            },\n            useParent: false,\n            useDefaults: false\n        },\n\n        /**\n         * Disable form input if settings for parent section is used\n         * or default value is applied.\n         *\n         * @param {Boolean} isUseParent\n         */\n        toggleDisabled: function (isUseParent) {\n            var disabled = this.useParent = isUseParent;\n\n            if (!disabled && !_.isUndefined(this.service)) {\n                disabled = !!this.isUseDefault();\n            }\n\n            this.saveUseDefaults();\n            this.disabled(disabled);\n        },\n\n        /**\n         * Stores original state of the field.\n         */\n        saveUseDefaults: function () {\n            this.useDefaults = this.disabled();\n        },\n\n        /** @inheritdoc */\n        setInitialValue: function () {\n            this._super();\n            this.isUseDefault(this.useDefaults);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        toggleUseDefault: function (state) {\n            this._super();\n            this.disabled(state || this.useParent);\n        }\n    };\n\n    return function (target) {\n        return target.extend(mixin);\n    };\n});\n","Magento_Catalog/js/components/visible-on-option/date.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/date',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/visible-on-option/fieldset.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/components/fieldset',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Fieldset, strategy) {\n    'use strict';\n\n    return Fieldset.extend(strategy).extend(\n        {\n            defaults: {\n                openOnShow: true\n            },\n\n            /**\n             * Toggle visibility state.\n             */\n            toggleVisibility: function () {\n                this._super();\n\n                if (this.openOnShow) {\n                    this.opened(this.inverseVisibility ? !this.isShown : this.isShown);\n                }\n            }\n        }\n    );\n});\n","Magento_Catalog/js/components/visible-on-option/input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/visible-on-option/select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/visible-on-option/strategy.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine(function () {\n    'use strict';\n\n    return {\n        defaults: {\n            valuesForOptions: [],\n            imports: {\n                toggleVisibility:\n                    'product_attribute_add_form.product_attribute_add_form.base_fieldset.frontend_input:value'\n            },\n            isShown: false,\n            inverseVisibility: false\n        },\n\n        /**\n         * Toggle visibility state.\n         *\n         * @param {Number} selected\n         */\n        toggleVisibility: function (selected) {\n            this.isShown = selected in this.valuesForOptions;\n            this.visible(this.inverseVisibility ? !this.isShown : this.isShown);\n        }\n    };\n});\n","Magento_Catalog/js/components/visible-on-option/textarea.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/textarea',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/components/visible-on-option/yesno.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox',\n    'Magento_Catalog/js/components/visible-on-option/strategy'\n], function (Element, strategy) {\n    'use strict';\n\n    return Element.extend(strategy);\n});\n","Magento_Catalog/js/form/element/action-delete.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            prefixName: '',\n            prefixElementName: '',\n            elementName: '',\n            suffixName: ''\n        },\n\n        /**\n         * Parses options and merges the result with instance\n         *\n         * @param  {Object} config\n         * @returns {Object} Chainable.\n         */\n        initConfig: function (config) {\n            this._super(config);\n\n            this.configureDataScope();\n\n            return this;\n        },\n\n        /**\n         * Configure data scope.\n         */\n        configureDataScope: function () {\n            var recordId,\n                prefixName,\n                suffixName;\n\n            // Get recordId\n            recordId = this.parentName.split('.').last();\n\n            prefixName = this.dataScopeToHtmlArray(this.prefixName);\n            this.elementName = this.prefixElementName + recordId;\n\n            suffixName = '';\n\n            if (!_.isEmpty(this.suffixName) || _.isNumber(this.suffixName)) {\n                suffixName = '[' + this.suffixName + ']';\n            }\n            this.inputName = prefixName + '[' + this.elementName + ']' + suffixName;\n\n            suffixName = '';\n\n            if (!_.isEmpty(this.suffixName) || _.isNumber(this.suffixName)) {\n                suffixName = '.' + this.suffixName;\n            }\n            this.dataScope = 'data.' + this.prefixName + '.' + this.elementName + suffixName;\n\n            this.links.value = this.provider + ':' + this.dataScope;\n        },\n\n        /**\n         * Get HTML array from data scope.\n         *\n         * @param {String} dataScopeString\n         * @returns {String}\n         */\n        dataScopeToHtmlArray: function (dataScopeString) {\n            var dataScopeArray, dataScope, reduceFunction;\n\n            /**\n             * Reduce\n             *\n             * @param {String} prev\n             * @param {String} curr\n             * @returns {String}\n             */\n            reduceFunction = function (prev, curr) {\n                return prev + '[' + curr + ']';\n            };\n\n            dataScopeArray = dataScopeString.split('.');\n\n            dataScope = dataScopeArray.shift();\n            dataScope += dataScopeArray.reduce(reduceFunction, '');\n\n            return dataScope;\n        },\n\n        /**\n         * Delete record instance\n         * update data provider dataScope\n         *\n         * @param {Object} parents\n         */\n        deleteRecord: function (parents) {\n            this.value(1);\n            parents[1].deleteRecord(parents[0].index, parents[0].recordId);\n\n            return this;\n        }\n    });\n});\n","Magento_Catalog/js/form/element/checkbox.js":"/**\r\n * Copyright \u00a9 Magento, Inc. All rights reserved.\r\n * See COPYING.txt for license details.\r\n */\r\n\r\ndefine([\r\n    'Magento_Ui/js/form/element/single-checkbox'\r\n], function (Checkbox) {\r\n    'use strict';\r\n\r\n    return Checkbox.extend({\r\n        defaults: {\r\n            inputCheckBoxName: '',\r\n            prefixElementName: '',\r\n            parentDynamicRowName: 'visual_swatch'\r\n        },\r\n\r\n        /**\r\n         * Parses options and merges the result with instance\r\n         *\r\n         * @returns {Object} Chainable.\r\n         */\r\n        initConfig: function () {\r\n            this._super();\r\n            this.configureDataScope();\r\n\r\n            return this;\r\n        },\r\n\r\n        /** @inheritdoc */\r\n        initialize: function () {\r\n            this._super();\r\n\r\n            if (this.rows && this.rows().elems().length === 0) {\r\n                this.checked(true);\r\n            }\r\n\r\n            return this;\r\n        },\r\n\r\n        /**\r\n         * Configure data scope.\r\n         */\r\n        configureDataScope: function () {\r\n            var recordId,\r\n                value;\r\n\r\n            recordId = this.parentName.split('.').last();\r\n            value = this.prefixElementName + recordId;\r\n\r\n            this.dataScope = 'data.' + this.inputCheckBoxName;\r\n            this.inputName = this.dataScopeToHtmlArray(this.inputCheckBoxName);\r\n\r\n            this.initialValue = value;\r\n\r\n            this.links.value = this.provider + ':' + this.dataScope;\r\n        },\r\n\r\n        /**\r\n         * Get HTML array from data scope.\r\n         *\r\n         * @param {String} dataScopeString\r\n         * @returns {String}\r\n         */\r\n        dataScopeToHtmlArray: function (dataScopeString) {\r\n            var dataScopeArray, dataScope, reduceFunction;\r\n\r\n            /**\r\n             * Add new level of nesting.\r\n             *\r\n             * @param {String} prev\r\n             * @param {String} curr\r\n             * @returns {String}\r\n             */\r\n            reduceFunction = function (prev, curr) {\r\n                return prev + '[' + curr + ']';\r\n            };\r\n\r\n            dataScopeArray = dataScopeString.split('.');\r\n\r\n            dataScope = dataScopeArray.shift();\r\n            dataScope += dataScopeArray.reduce(reduceFunction, '');\r\n\r\n            return dataScope;\r\n        }\r\n    });\r\n});\r\n","Magento_Catalog/js/form/element/input.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            prefixName: '',\n            prefixElementName: '',\n            elementName: '',\n            suffixName: ''\n        },\n\n        /**\n         * Parses options and merges the result with instance\n         *\n         * @returns {Object} Chainable.\n         */\n        initConfig: function () {\n            this._super();\n            this.configureDataScope();\n\n            return this;\n        },\n\n        /**\n         * Configure data scope.\n         */\n        configureDataScope: function () {\n            var recordId,\n                prefixName,\n                suffixName;\n\n            // Get recordId\n            recordId = this.parentName.split('.').last();\n\n            prefixName = this.dataScopeToHtmlArray(this.prefixName);\n            this.elementName = this.prefixElementName + recordId;\n\n            suffixName = '';\n\n            if (!_.isEmpty(this.suffixName) || _.isNumber(this.suffixName)) {\n                suffixName = '[' + this.suffixName + ']';\n            }\n            this.inputName = prefixName + '[' + this.elementName + ']' + suffixName;\n\n            suffixName = '';\n\n            if (!_.isEmpty(this.suffixName) || _.isNumber(this.suffixName)) {\n                suffixName = '.' + this.suffixName;\n            }\n\n            this.exportDataLink = 'data.' + this.prefixName + '.' + this.elementName + suffixName;\n            this.exports.value = this.provider + ':' + this.exportDataLink;\n        },\n\n        /** @inheritdoc */\n        destroy: function () {\n            this._super();\n\n            this.source.remove(this.exportDataLink);\n        },\n\n        /**\n         * Get HTML array from data scope.\n         *\n         * @param {String} dataScopeString\n         * @returns {String}\n         */\n        dataScopeToHtmlArray: function (dataScopeString) {\n            var dataScopeArray, dataScope, reduceFunction;\n\n            /**\n             * Add new level of nesting.\n             *\n             * @param {String} prev\n             * @param {String} curr\n             * @returns {String}\n             */\n            reduceFunction = function (prev, curr) {\n                return prev + '[' + curr + ']';\n            };\n\n            dataScopeArray = dataScopeString.split('.');\n\n            dataScope = dataScopeArray.shift();\n            dataScope += dataScopeArray.reduce(reduceFunction, '');\n\n            return dataScope;\n        }\n    });\n});\n","Magento_Catalog/js/product/addtocart-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Element, uencProcessor, columnStatusValidator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Prepare data, that will be inserted as data-mage-init attribute into button. With help of this attribute\n         * Add To * buttons can understand post data and urls\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getDataMageInit: function (row) {\n            return '{\"redirectUrl\": { \"url\" : \"'  + uencProcessor(row['add_to_cart_button'].url) + '\"}}';\n        },\n\n        /**\n         * Prepare Data-Post data that will be used in data-mage-init\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['add_to_cart_button']['post_data']);\n        },\n\n        /**\n         * Check if product has required options.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        hasRequiredOptions: function (row) {\n            return row['add_to_cart_button']['required_options'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isSalable: function (row) {\n            return row['is_salable'];\n        },\n\n        /**\n         * Depends on this option, stock status text can be \"In stock\" or \"Out Of Stock\"\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        isAvailable: function (row) {\n            return row['is_available'];\n        },\n\n        /**\n         * Depends on this option, \"Add to cart\" button can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_cart', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/addtocompare-button.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/uenc-processor',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Column, uencProcessor, columnStatusValidator) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            label: ''\n        },\n\n        /**\n         * Prepare Data-Post data that will be used in data-mage-init\n         *\n         * @param {Object} row\n         * @returns {Array}\n         */\n        getDataPost: function (row) {\n            return uencProcessor(row['add_to_compare_button'].url ||\n                    row['add_to_compare_button']['post_data']);\n        },\n\n        /**\n         * Depends on this option, \"Add to compare\" button can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'add_to_compare', 'show_buttons');\n        },\n\n        /**\n         * Get button label.\n         *\n         * @return {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/learn-more.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (Column, columnStatusValidator) {\n    'use strict';\n\n    return Column.extend({\n        /**\n         * Depends on this option, \"Learn More\" link can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'learn_more', 'show_attributes');\n        }\n    });\n});\n","Magento_Catalog/js/product/name.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator',\n    'escaper'\n], function (Column, columnStatusValidator, escaper) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            allowedTags: ['div', 'span', 'b', 'strong', 'i', 'em', 'u', 'a']\n        },\n\n        /**\n         * Depends on this option, product name can be shown or hide. Depends on  backend configuration\n         *\n         * @returns {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'name', 'show_attributes');\n        },\n\n        /**\n         * Name column.\n         *\n         * @param {String} label\n         * @returns {String}\n         */\n        getNameUnsanitizedHtml: function (label) {\n            return escaper.escapeHtml(label, this.allowedTags);\n        }\n    });\n});\n","Magento_Catalog/js/product/weight-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return {\n\n        /**\n         * Get weight\n         * @returns {*|jQuery|HTMLElement}\n         */\n        $weight: function () {\n            return $('#weight');\n        },\n\n        /**\n         * Weight Switcher\n         * @returns {*|jQuery|HTMLElement}\n         */\n        $weightSwitcher: function () {\n            return $('[data-role=weight-switcher]');\n        },\n\n        /**\n         * Weight Change Toggle\n         * @returns {*|jQuery|HTMLElement}\n         */\n        $weightChangeToggle: function () {\n            return $('#toggle_weight');\n        },\n\n        /**\n         * Is locked\n         * @returns {*}\n         */\n        isLocked: function () {\n            return this.$weight().is('[data-locked]');\n        },\n\n        /**\n         * Disabled\n         */\n        disabled: function () {\n            this.$weight().addClass('ignore-validate').prop('disabled', true);\n        },\n\n        /**\n         * Enabled\n         */\n        enabled: function () {\n            this.$weight().removeClass('ignore-validate').prop('disabled', false);\n        },\n\n        /**\n         * Disabled Switcher\n         */\n        disabledSwitcher: function () {\n            this.$weightSwitcher().find('input[type=\"radio\"]').addClass('ignore-validate').prop('disabled', true);\n        },\n\n        /**\n         * Enabled Switcher\n         */\n        enabledSwitcher: function () {\n            this.$weightSwitcher().find('input[type=\"radio\"]').removeClass('ignore-validate').prop('disabled', false);\n        },\n\n        /**\n         * Switch Weight\n         * @returns {*}\n         */\n        switchWeight: function () {\n            if (this.hasWeightChangeToggle()) {\n                return;\n            }\n\n            return this.productHasWeightBySwitcher() ? this.enabled() : this.disabled();\n        },\n\n        /**\n         * Toggle Switcher\n         */\n        toggleSwitcher: function () {\n            this.isWeightChanging() ? this.enabledSwitcher() : this.disabledSwitcher();\n        },\n\n        /**\n         * Hide weight switcher\n         */\n        hideWeightSwitcher: function () {\n            this.$weightSwitcher().hide();\n        },\n\n        /**\n         * Has weight switcher\n         * @returns {*}\n         */\n        hasWeightSwitcher: function () {\n            return this.$weightSwitcher().is(':visible');\n        },\n\n        /**\n         * Has weight\n         * @returns {*}\n         */\n        hasWeight: function () {\n            return this.$weight.is(':visible');\n        },\n\n        /**\n         * Has weight change toggle\n         * @returns {*}\n         */\n        hasWeightChangeToggle: function () {\n            return this.$weightChangeToggle().is(':visible');\n        },\n\n        /**\n         * Product has weight\n         * @returns {Bool}\n         */\n        productHasWeightBySwitcher: function () {\n            return $('input:checked', this.$weightSwitcher()).val() === '1';\n        },\n\n        /**\n         * Product weight toggle is checked\n         * @returns {Bool}\n         */\n        isWeightChanging: function () {\n            return this.$weightChangeToggle().is(':checked');\n        },\n\n        /**\n         * Change\n         * @param {String} data\n         */\n        change: function (data) {\n            var value = data !== undefined ? +data : !this.productHasWeightBySwitcher();\n\n            $('input[value=' + value + ']', this.$weightSwitcher()).prop('checked', true);\n            this.switchWeight();\n        },\n\n        /**\n         * Constructor component\n         */\n        'Magento_Catalog/js/product/weight-handler': function () {\n            this.bindAll();\n\n            if (this.hasWeightSwitcher()) {\n                this.switchWeight();\n            }\n\n            if (this.hasWeightChangeToggle()) {\n                this.toggleSwitcher();\n            }\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            this.$weightSwitcher().find('input').on('change', this.switchWeight.bind(this));\n        }\n    };\n});\n","Magento_Catalog/js/product/list/column-status-validator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore'\n], function (_) {\n    'use strict';\n\n    return _.extend({\n        /**\n         * Check whether we can show column depends on server settings or not\n         *\n         * @param {Object} source\n         * @param {String} attributeCode\n         * @param {String} type\n         * @returns {Boolean}\n         */\n        isValid: function (source, attributeCode, type) {\n            var attributes;\n\n            if (!source[type]) {\n                return false;\n            }\n\n            attributes = source[type].split(',');\n\n            return _.contains(attributes, attributeCode);\n        }\n    });\n});\n","Magento_Catalog/js/product/list/listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'ko',\n    'underscore',\n    'Magento_Ui/js/grid/listing'\n], function (ko, _, Listing) {\n    'use strict';\n\n    return Listing.extend({\n        defaults: {\n            additionalClasses: '',\n            filteredRows: {},\n            limit: 5,\n            listens: {\n                elems: 'filterRowsFromCache',\n                '${ $.provider }:data.items': 'filterRowsFromServer'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.filteredRows = ko.observable();\n            this.initProductsLimit();\n            this.hideLoader();\n        },\n\n        /**\n         * Initialize product limit\n         * Product limit can be configured through Ui component.\n         * Product limit are present in widget form\n         *\n         * @returns {exports}\n         */\n        initProductsLimit: function () {\n            if (this.source['page_size']) {\n                this.limit = this.source['page_size'];\n            }\n\n            return this;\n        },\n\n        /**\n         * Initializes observable properties.\n         *\n         * @returns {Listing} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .track({\n                    rows: []\n                });\n\n            return this;\n        },\n\n        /**\n         * Sort and filter rows, that are already in magento storage cache\n         *\n         * @return void\n         */\n        filterRowsFromCache: function () {\n            this._filterRows(this.rows);\n        },\n\n        /**\n         * Sort and filter rows, that are come from backend\n         *\n         * @param {Object} rows\n         */\n        filterRowsFromServer: function (rows) {\n            this._filterRows(rows);\n        },\n\n        /**\n         * Filter rows by limit and sort them\n         *\n         * @param {Array} rows\n         * @private\n         */\n        _filterRows: function (rows) {\n            this.filteredRows(_.sortBy(rows, 'added_at').reverse().slice(0, this.limit));\n        },\n\n        /**\n         * Can retrieve product url\n         *\n         * @param {Object} row\n         * @returns {String}\n         */\n        getUrl: function (row) {\n            return row.url;\n        },\n\n        /**\n         * Get product attribute by code.\n         *\n         * @param {String} code\n         * @return {Object}\n         */\n        getComponentByCode: function (code) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                component;\n\n            component = _.filter(elems, function (elem) {\n                return elem.index === code;\n            }, this).pop();\n\n            return component;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/final-price.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiCollection'\n], function (_, registry, utils, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            label: false,\n            headerTmpl: 'ui/grid/columns/text',\n            showMinimalPrice: false,\n            showMaximumPrice: false,\n            useLinkForAsLowAs: false,\n            bodyTmpl: 'Magento_Catalog/product/final_price',\n            priceWrapperCssClasses: '',\n            priceWrapperAttr: {}\n        },\n\n        /**\n         * Get product final price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} final price html\n         */\n        getPrice: function (row) {\n            return row['price_info']['formatted_prices']['final_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} final price html\n         */\n        getPriceUnsanitizedHtml: function (row) {\n            return this.getPrice(row);\n        },\n\n        /**\n         * Get product regular price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} regular price html\n         */\n        getRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['regular_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getRegularPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} regular price html\n         */\n        getRegularPriceUnsanitizedHtml: function (row) {\n            return this.getRegularPrice(row);\n        },\n\n        /**\n         * Check if product has a price range.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        hasPriceRange: function (row) {\n            return row['price_info']['max_regular_price'] !== row['price_info']['min_regular_price'];\n        },\n\n        /**\n         * Check if product has special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} special price html\n         */\n        hasSpecialPrice: function (row) {\n            return row['price_info']['regular_price'] > row['price_info']['final_price'];\n        },\n\n        /**\n         * Check if product has minimal price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal price html\n         */\n        isMinimalPrice: function (row) {\n            return row['price_info']['minimal_price'] < row['price_info']['final_price'];\n        },\n\n        /**\n         * Get product minimal price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal price html\n         */\n        getMinimalPrice: function (row) {\n            return row['price_info']['formatted_prices']['minimal_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMinimalPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal price html\n         */\n        getMinimalPriceUnsanitizedHtml: function (row) {\n            return this.getMinimalPrice(row);\n        },\n\n        /**\n         * Check if product is salable.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        isSalable: function (row) {\n            return row['is_salable'];\n        },\n\n        /**\n         * Get product maximum price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum price html\n         */\n        getMaxPrice: function (row) {\n            return row['price_info']['formatted_prices']['max_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMaxPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum price html\n         */\n        getMaxPriceUnsanitizedHtml: function (row) {\n            return this.getMaxPrice(row);\n        },\n\n        /**\n         * Get product maximum regular price in case of price range and special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum regular price html\n         */\n        getMaxRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['max_regular_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMaxRegularPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} maximum regular price html\n         */\n        getMaxRegularPriceUnsanitizedHtml: function (row) {\n            return this.getMaxRegularPrice(row);\n        },\n\n        /**\n         * Get product minimal regular price in case of price range and special price.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal regular price html\n         */\n        getMinRegularPrice: function (row) {\n            return row['price_info']['formatted_prices']['min_regular_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMinRegularPrice.\n         *\n         * @param {Object} row\n         * @return {HTMLElement} minimal regular price html\n         */\n        getMinRegularPriceUnsanitizedHtml: function (row) {\n            return this.getMinRegularPrice(row);\n        },\n\n        /**\n         * Get adjustments names and return as string.\n         *\n         * @return {String} adjustments classes\n         */\n        getAdjustmentCssClasses: function () {\n            return _.pluck(this.getAdjustments(), 'index').join(' ');\n        },\n\n        /**\n         * Get product minimal price as number.\n         *\n         * @param {Object} row\n         * @return {Number} minimal price amount\n         */\n        getMinimalPriceAmount: function (row) {\n            return row['price_info']['minimal_price'];\n        },\n\n        /**\n         * UnsanitizedHtml version of getMinimalPriceAmount\n         *\n         * @param {Object} row\n         * @return {Number} minimal price amount\n         */\n        getMinimalPriceAmountUnsanitizedHtml: function (row) {\n            return this.getMinimalPriceAmount(row);\n        },\n\n        /**\n         * Get product minimal regular price as number in case of special price.\n         *\n         * @param {Object} row\n         * @return {Number} minimal regular price amount\n         */\n        getMinimalRegularPriceAmount: function (row) {\n            return row['price_info']['min_regular_price'];\n        },\n\n        /**\n         * Get product maximum price as number.\n         *\n         * @param {Object} row\n         * @return {Number} maximum price amount\n         */\n        getMaximumPriceAmount: function (row) {\n            return row['price_info']['max_price'];\n        },\n\n        /**\n         * Get product maximum regular price as number in case of special price.\n         *\n         * @param {Object} row\n         * @return {Number} maximum regular price amount\n         */\n        getMaximumRegularPriceAmount: function (row) {\n            return row['price_info']['max_regular_price'];\n        },\n\n        /**\n         * Check if minimal regular price exist for product.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        showMinRegularPrice: function (row) {\n            return this.getMinimalPriceAmount(row) < this.getMinimalRegularPriceAmount(row);\n        },\n\n        /**\n         * Check if maximum regular price exist for product.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        showMaxRegularPrice: function (row) {\n            return this.getMaximumPriceAmount(row) < this.getMaximumRegularPriceAmount(row);\n        },\n\n        /**\n         * Get path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Get all price adjustments.\n         *\n         * @returns {Object}\n         */\n        getAdjustments: function () {\n            var adjustments = this.elems();\n\n            _.each(adjustments, function (adjustment) {\n                adjustment.setPriceType(this.priceType);\n                adjustment.source = this.source;\n            }, this);\n\n            return adjustments;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/image.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/grid/columns/column',\n    'Magento_Catalog/js/product/list/column-status-validator'\n], function (_, Element, columnStatusValidator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            bodyTmpl: 'Magento_Catalog/product/list/columns/image',\n            imageCode: 'default',\n            image: {}\n        },\n\n        /**\n         * Find image by code in scope of images\n         *\n         * @param {Object} images\n         * @returns {*|T}\n         */\n        getImage: function (images) {\n            return _.filter(images, function (image) {\n                return this.imageCode === image.code;\n            }, this).pop();\n        },\n\n        /**\n         * Get image path.\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getImageUrl: function (row) {\n            return this.getImage(row.images).url;\n        },\n\n        /**\n         * Get image box width.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getWidth: function (row) {\n            return this.getImage(row.images).width;\n        },\n\n        /**\n         * Get image box height.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getHeight: function (row) {\n            return this.getImage(row.images).height;\n        },\n\n        /**\n         * Get resized image width.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getResizedImageWidth: function (row) {\n            return this.getImage(row.images)['resized_width'];\n        },\n\n        /**\n         * Get resized image height.\n         *\n         * @param {Object} row\n         * @return {Number}\n         */\n        getResizedImageHeight: function (row) {\n            return this.getImage(row.images)['resized_height'];\n        },\n\n        /**\n         * Get image alt text.\n         *\n         * @param {Object} row\n         * @return {String}\n         */\n        getLabel: function (row) {\n            if (!this.imageExists(row)) {\n                return this._super();\n            }\n\n            return this.getImage(row.images).label;\n        },\n\n        /**\n         * Check if image exist.\n         *\n         * @param {Object} row\n         * @return {Boolean}\n         */\n        imageExists: function (row) {\n            return this.getImage(row.images) !== 'undefined';\n        },\n\n        /**\n         * Check if component must be shown.\n         *\n         * @return {Boolean}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'image', 'show_attributes');\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/price-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore',\n    'uiRegistry',\n    'mageUtils',\n    'uiCollection',\n    'Magento_Catalog/js/product/list/column-status-validator',\n    'uiLayout'\n], function (ko, _, registry, utils, Collection, columnStatusValidator, layout) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            label: '',\n            hasSpecialPrice: false,\n            showMinimalPrice: false,\n            useLinkForAsLowAs: false,\n            visible: true,\n            headerTmpl: 'ui/grid/columns/text',\n            bodyTmpl: 'Magento_Catalog/product/price/price_box',\n            disableAction: false,\n            controlVisibility: true,\n            sortable: false,\n            sorting: false,\n            draggable: true,\n            fieldClass: {},\n            renders: {\n                default: {}\n            },\n            ignoreTmpls: {\n                fieldAction: true\n            },\n            statefull: {\n                visible: true,\n                sorting: true\n            },\n            imports: {\n                exportSorting: 'sorting'\n            },\n            listens: {\n                elems: ''\n            },\n            modules: {\n                source: '${ $.provider }'\n            },\n            pricesInit: {}\n        },\n\n        /**\n         * Sort prices api\n         *\n         * @returns {exports}\n         */\n        sort: function () {\n            return this;\n        },\n\n        /**\n         * Check whether is allowed to render price or not\n         *\n         * @returns {*}\n         */\n        isAllowed: function () {\n            return columnStatusValidator.isValid(this.source(), 'price', 'show_attributes');\n        },\n\n        /**\n         * Retrieve array of prices, that should be rendered for specific product\n         *\n         * @param {Array} row\n         * @return {Array}\n         */\n        getPrices: function (row) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                result;\n\n            //we cant take type of product from row\n            this.initPrices(row);\n            result = _.filter(elems, function (elem) {\n                return elem.productType === row.type;\n            });\n\n            return result;\n        },\n\n        /**\n         * Recursive Merging of objects\n         *\n         * @param {Array} target\n         * @param {Array} source\n         * @returns {Array}\n         * @private\n         */\n        _deepObjectExtend: function (target, source) {\n            var _target = utils.copy(target);\n\n            _.each(source, function (value, key) {\n                if (_.keys(value).length && typeof _target[key] !== 'undefined') {\n                    _target[key] = this._deepObjectExtend(_target[key], value);\n                } else {\n                    _target[key] = value;\n                }\n            }, this);\n\n            return _target;\n        },\n\n        /**\n         * Init price type box, in cases when product type has custom component or bodyTmpl\n         *\n         * @param {String} productType\n         * @private\n         */\n        _initPriceWithCustomMetaData: function (productType) {\n            var price = this._deepObjectExtend(\n                this.renders.prices['default'],\n                this.renders.prices[productType]\n            );\n\n            price.name = productType + '.default';\n            price.parent = this.name;\n            price.source = this.source;\n            price.productType = productType;\n            layout([price]);\n        },\n\n        /**\n         * Init Prices by product type and add them to layout\n         *\n         * @param {Array} _priceData\n         * @param {String} productType\n         * @private\n         */\n        _initPricesForProductType: function (_priceData, productType) {\n            var prices = [];\n\n            this._setPriceNamesToPrices(_priceData, productType);\n            _.sortBy(_priceData, this._comparePrices);\n\n            _.each(_priceData, function (priceData) {\n                if (!priceData.component) {\n                    return;\n                }\n\n                priceData.parent = this.name;\n                priceData.provider = this.provider;\n                priceData.productType = productType;\n                priceData = utils.template(priceData, this);\n                prices.push(priceData);\n            }, this);\n\n            layout(prices);\n        },\n\n        /**\n         * Init dynamic price components\n         *\n         * @param {Array} row\n         * @returns {void}\n         */\n        initPrices: function (row) {\n            var _priceData = [],\n                productType = row.type,\n                defaultPrice = this.renders.prices['default'];\n\n            if (this.pricesInit[productType]) {\n                return true;\n            }\n\n            this.pricesInit[productType] = true;\n\n            if (this.renders.prices[productType] && this._needToApplyCustomTemplate(this.renders.prices[productType])) {\n                return this._initPriceWithCustomMetaData(productType);\n            }\n\n            if (this.renders.prices[productType] && this.renders.prices[productType].children) {\n                _priceData = this._deepObjectExtend(defaultPrice.children, this.renders.prices[productType].children);\n            } else {\n                _priceData = defaultPrice.children;\n            }\n\n            return this._initPricesForProductType(_priceData, productType);\n        },\n\n        /**\n         * Set name to all price components\n         *\n         * @param {Array} prices\n         * @param {String} productType\n         * @private\n         */\n        _setPriceNamesToPrices: function (prices, productType) {\n            _.each(prices, function (price, name) {\n                price.priceType = name;\n                price.name = name + '.' + productType;\n            });\n\n            return prices;\n        },\n\n        /**\n         * Sort callback to compare prices by sort order\n         *\n         * @param {Number} firstPrice\n         * @param {Number} secondPrice\n         * @returns {Number}\n         * @private\n         */\n        _comparePrices: function (firstPrice, secondPrice) {\n            if (firstPrice.sortOrder < secondPrice.sortOrder) {\n                return -1;\n            }\n\n            if (firstPrice.sortOrder > secondPrice.sortOrder) {\n                return 1;\n            }\n\n            return 0;\n        },\n\n        /**\n         * Check whether metadata of product type prices was changed, and we should\n         * to apply custom template or custom component\n         *\n         * @param {Array} productData\n         * @returns {*}\n         * @private\n         */\n        _needToApplyCustomTemplate: function (productData) {\n            return productData.bodyTmpl || productData.component;\n        },\n\n        /**\n         * Returns path to the columns' body template.\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Get price label.\n         *\n         * @returns {String}\n         */\n        getLabel: function () {\n            return this.label;\n        }\n    });\n});\n","Magento_Catalog/js/product/list/columns/pricetype-box.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'ko',\n    'underscore',\n    'uiCollection'\n], function (ko, _, Collection) {\n    'use strict';\n\n    return Collection.extend({\n        /**\n         * Find from all price ui components, price with specific code, init source on it and set priceType\n         *\n         * @param {String} code\n         * @returns {*|T}\n         */\n        getPriceByCode: function (code) {\n            var elems = this.elems() ? this.elems() : ko.getObservable(this, 'elems'),\n                price;\n\n            price = _.filter(elems, function (elem) {\n                return elem.index.split('.').shift() === code;\n            }, this).pop();\n\n            price.source = this.source();\n            price.priceType = code;\n\n            return price;\n        },\n\n        /**\n         * Retrieve body template\n         *\n         * @returns {String}\n         */\n        getBody: function () {\n            return this.bodyTmpl;\n        },\n\n        /**\n         * Check whether price has price range, depends on different options, that can be choose\n         *\n         * @param {Object} row\n         * @returns {Boolean}\n         */\n        hasPriceRange: function (row) {\n            return row['price_info']['max_regular_price'] !== row['price_info']['min_regular_price'];\n        }\n    });\n});\n","Magento_Catalog/js/tier-price/percentage-processor.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiElement',\n    'underscore',\n    'Magento_Ui/js/lib/view/utils/async',\n    'Magento_Catalog/js/utils/percentage-price-calculator'\n], function (Element, _, $, percentagePriceCalculator) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            priceElem: '${ $.parentName }.price',\n            selector: 'input',\n            imports: {\n                priceValue: '${ $.priceElem }:priceValue'\n            },\n            exports: {\n                calculatedVal: '${ $.priceElem }:value'\n            }\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super();\n\n            _.bindAll(this, 'initPriceListener', 'onInput');\n\n            $.async({\n                component: this.priceElem,\n                selector: this.selector\n            }, this.initPriceListener);\n\n            return this;\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initObservable: function () {\n            return this._super()\n                .observe(['visible']);\n        },\n\n        /**\n         * Handles keyup event on price input.\n         *\n         * {@param} HTMLElement elem\n         */\n        initPriceListener: function (elem) {\n            $(elem).on('keyup.priceCalc', this.onInput);\n        },\n\n        /**\n         * Delegates calculation of the price input value to percentagePriceCalculator.\n         *\n         * {@param} object event\n         */\n        onInput: function (event) {\n            var value = event.currentTarget.value;\n\n            if (value.slice(-1) === '%') {\n                value = percentagePriceCalculator(this.priceValue, value);\n                this.set('calculatedVal', value);\n            }\n        }\n    });\n});\n","Magento_Catalog/js/tier-price/value-type-select.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'uiRegistry',\n    'underscore'\n], function (Select, uiRegistry, _) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            prices: {}\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        initialize: function () {\n            this._super();\n            delete this.prices.__disableTmpl;\n            this.prepareForm();\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        setInitialValue: function () {\n            this.initialValue = this.getInitialValue();\n\n            if (this.value.peek() !== this.initialValue) {\n                this.value(this.initialValue);\n            }\n\n            this.isUseDefault(this.disabled());\n\n            return this;\n        },\n\n        /**\n         * {@inheritdoc}\n         */\n        prepareForm: function () {\n            var elements = this.getElementsByPrices(),\n                prices = this.prices,\n                currencyType = _.keys(prices)[0],\n                select = this;\n\n            uiRegistry.get(elements, function () {\n                _.each(arguments, function (currentValue) {\n                    if (parseFloat(currentValue.value()) > 0) {\n                        _.each(prices, function (priceValue, priceKey) {\n                            if (priceValue === currentValue.name) {\n                                currencyType = priceKey;\n                            }\n                        });\n                    }\n                });\n                select.value(currencyType);\n                select.on('value', select.onUpdate.bind(select));\n                select.onUpdate();\n            });\n        },\n\n        /**\n         * @returns {Array}\n         */\n        getElementsByPrices: function () {\n            var elements = [];\n\n            _.each(this.prices, function (currentValue) {\n                elements.push(currentValue);\n            });\n\n            return elements;\n        },\n\n        /**\n         * Callback that fires when 'value' property is updated\n         */\n        onUpdate: function () {\n            var value = this.value(),\n                prices = this.prices,\n                select = this,\n                parentDataScopeArr = this.dataScope.split('.'),\n                parentDataScope,\n                elements = this.getElementsByPrices();\n\n            parentDataScopeArr.pop();\n            parentDataScope = parentDataScopeArr.join('.');\n\n            uiRegistry.get(elements, function () {\n                var sourceData = select.source.get(parentDataScope);\n\n                _.each(arguments, function (currentElement) {\n                    var index;\n\n                    _.each(prices, function (priceValue, priceKey) {\n                        if (priceValue === currentElement.name) {\n                            index = priceKey;\n                        }\n                    });\n\n                    if (value === index) {\n                        currentElement.visible(true);\n                        sourceData[currentElement.index] = currentElement.value();\n                    } else {\n                        currentElement.value('');\n                        currentElement.visible(false);\n                        delete sourceData[currentElement.index];\n                    }\n                });\n                select.source.set(parentDataScope, sourceData);\n            });\n        }\n    });\n});\n","Magento_Catalog/js/utils/percentage-price-calculator.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine(['Magento_Ui/js/lib/validation/utils'], function (utils) {\n    'use strict';\n\n    /**\n     * Calculates the price input value when entered percentage value.\n     *\n     * @param {String} price\n     * @param {String} input\n     *\n     * @returns {String}\n     */\n    return function (price, input) {\n        var result,\n            lastInputSymbol = input.slice(-1),\n            inputPercent = input.slice(0, -1),\n            parsedPercent = utils.parseNumber(inputPercent),\n            parsedPrice = utils.parseNumber(price);\n\n        if (lastInputSymbol !== '%') {\n            result = input;\n        } else if (\n            input === '%' ||\n            isNaN(parsedPrice) ||\n            parsedPercent != inputPercent || /* eslint eqeqeq:0 */\n            isNaN(parsedPercent) ||\n            input === ''\n        ) {\n            result = '';\n        } else if (parsedPercent > 100) {\n            result = '0.00';\n        } else if (lastInputSymbol === '%') {\n            result = parsedPrice - parsedPrice * (inputPercent / 100);\n            result = result.toFixed(2);\n        } else {\n            result = input;\n        }\n\n        return result;\n    };\n});\n","Magento_CatalogInventory/js/components/qty-validator-changer.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            valueUpdate: 'input'\n        },\n\n        /**\n         * Change validator\n         */\n        handleChanges: function (value) {\n            var isDigits = value !== 1;\n\n            this.validation['validate-integer'] = isDigits;\n            this.validation['less-than-equals-to'] = isDigits ? 99999999 : 99999999.9999;\n            this.validate();\n        }\n    });\n});\n","Magento_CatalogInventory/js/components/use-config-min-sale-qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox',\n    'underscore',\n    'uiRegistry'\n], function (checkbox, _, registry) {\n    'use strict';\n\n    return checkbox.extend({\n        defaults: {\n            valueFromConfig: ''\n        },\n\n        /**\n         * @returns {Element}\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['valueFromConfig']);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            this._super();\n            this.onCheckedChanged(this.checked());\n\n            return this;\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onCheckedChanged: function (newChecked) {\n            var valueFromConfig = this.valueFromConfig();\n\n            if (newChecked && (_.isArray(valueFromConfig) && valueFromConfig.length === 0 || valueFromConfig === 1)) {\n                this.changeVisibleDisabled(this.inputField, true, true, 1);\n            } else if (newChecked && _.isObject(valueFromConfig)) {\n                this.changeVisibleDisabled(this.inputField, false, true, null);\n                this.changeVisibleDisabled(this.dynamicRowsField, true, true, null);\n            } else if (newChecked && _.isNumber(valueFromConfig)) {\n                this.changeVisibleDisabled(this.inputField, true, true, null);\n                this.changeVisibleDisabled(this.dynamicRowsField, false, true, null);\n            } else {\n                this.changeVisibleDisabled(this.inputField, true, this.disabled() || false, null);\n                this.changeVisibleDisabled(this.dynamicRowsField, false, true, null);\n            }\n\n            this._super(newChecked);\n        },\n\n        /**\n         * Change visible and disabled\n         *\n         * @param {String} filter\n         * @param {Boolean} visible\n         * @param {Boolean} disabled\n         * @param {Null|Number} valueFromConfig\n         */\n        changeVisibleDisabled: function (filter, visible, disabled, valueFromConfig) {\n            registry.async(filter)(\n                function (currentComponent) {\n                    var initialValue = currentComponent.initialValue;\n\n                    if (_.isString(initialValue) || initialValue === 0 || valueFromConfig === 1) {\n                        currentComponent.value(1);\n                    } else if (initialValue) {\n                        currentComponent.value(initialValue);\n                    }\n\n                    currentComponent.visible(visible);\n                    currentComponent.disabled(disabled);\n                }\n            );\n        }\n    });\n});\n","Magento_CatalogInventory/js/components/use-config-settings.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (checkbox) {\n    'use strict';\n\n    return checkbox.extend({\n        defaults: {\n            valueFromConfig: '',\n            linkedValue: '',\n            disableParent: false,\n            listens: {\n                disabled: 'processState',\n                checked: 'processState onCheckedChanged'\n            },\n            imports: {\n                readOnly: 'ns = ${ $.ns }, index = stock_data:disabled'\n            }\n        },\n\n        /**\n         * @returns {Element}\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['valueFromConfig', 'linkedValue', 'disableParent']);\n        },\n\n        /**\n         * Handle checked and disabled changes to calculate disableParent value\n         */\n        processState: function () {\n            this.disableParent(this.checked() || this.readOnly);\n\n            if (this.readOnly) {\n                this.disable();\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        onCheckedChanged: function (newChecked) {\n            if (newChecked) {\n                this.linkedValue(this.valueFromConfig());\n            }\n\n            this._super(newChecked);\n        }\n    });\n});\n","Magento_Checkout/js/model/default-post-code-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([], function () {\n    'use strict';\n\n    /**\n     * Define necessity of using default post code value\n     */\n    var useDefaultPostCode;\n\n    return {\n        /**\n         * Resolve default post code\n         *\n         * @returns {String|null}\n         */\n        resolve: function () {\n            return useDefaultPostCode ?  window.checkoutConfig.defaultPostcode : null;\n        },\n\n        /**\n         * Set state to useDefaultPostCode variable\n         *\n         * @param {Boolean} shouldUseDefaultPostCode\n         * @returns {underscore}\n         */\n        setUseDefaultPostCode: function (shouldUseDefaultPostCode) {\n            useDefaultPostCode = shouldUseDefaultPostCode;\n\n            return this;\n        }\n    };\n});\n","Magento_Cms/js/folder-tree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'jquery/ui',\n    'jquery/jstree/jquery.jstree'\n], function ($) {\n    'use strict';\n\n    $.widget('mage.folderTree', {\n        options: {\n            root: 'root',\n            rootName: 'Root',\n            url: '',\n            currentPath: ['root'],\n            tree: {\n                core: {\n                    themes: {\n                        dots: false\n                    },\n                    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                    check_callback: true\n                    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                }\n            }\n        },\n\n        /** @inheritdoc */\n        _create: function () {\n            var options = this.options,\n                treeOptions = $.extend(\n                    true,\n                    {},\n                    options.tree,\n                    {\n                        core: {\n                            data: {\n                                url: options.url,\n                                type: 'POST',\n                                dataType: 'text',\n                                dataFilter: $.proxy(function (data) {\n                                    return this._convertData(JSON.parse(data));\n                                }, this),\n\n                                /**\n                                 * @param {HTMLElement} node\n                                 * @return {Object}\n                                 */\n                                data: function (node) {\n                                    return {\n                                        node: node.id === 'root' ? null : node.id,\n                                        'form_key': window.FORM_KEY\n                                    };\n                                }\n                            }\n                        }\n                    }\n                );\n\n            this.element.jstree(treeOptions)\n                .on('ready.jstree', $.proxy(this.treeLoaded, this))\n                .on('load_node.jstree', $.proxy(this._createRootNode, this));\n        },\n\n        /**\n         * Tree loaded.\n         */\n        treeLoaded: function () {\n            var path = this.options.currentPath,\n                tree = this.element,\n                lastExistentFolderEl,\n\n                /**\n                 * Recursively open folders specified in path array.\n                 */\n                recursiveOpen = function () {\n                    var folderEl = $('[data-id=\"' + path.pop() + '\"]');\n\n                    // if folder doesn't exist, select the last opened folder\n                    if (!folderEl.length) {\n                        tree.jstree('select_node', lastExistentFolderEl);\n\n                        return;\n                    }\n\n                    lastExistentFolderEl = folderEl;\n\n                    if (path.length) {\n                        tree.jstree('open_node', folderEl, recursiveOpen);\n                    } else {\n                        tree.jstree('open_node', folderEl, function () {\n                            tree.jstree('select_node', folderEl);\n                        });\n                    }\n                };\n\n            recursiveOpen();\n        },\n\n        /**\n         * Create tree root node\n         *\n         * @param {jQuery.Event} event\n         * @param {Object} data\n         * @private\n         */\n        _createRootNode: function (event, data) {\n            var rootNode, children;\n\n            // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            if (data.node.id === '#') {\n                rootNode = {\n                    id: this.options.root,\n                    text: this.options.rootName,\n                    li_attr: {\n                        'data-id': this.options.root\n                    }\n                };\n                children = data.node.children;\n\n                data.instance.element.jstree().create_node(null, rootNode, 'first', function () {\n                    data.instance.element.jstree().move_node(children, rootNode.id);\n                });\n            }\n            // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n        },\n\n        /**\n         * @param {*} data\n         * @return {*}\n         * @private\n         */\n        _convertData: function (data) {\n            return $.map(data, function (node) {\n\n                return {\n                    id: node.id,\n                    text: node.text,\n                    path: node.path,\n                    // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                    li_attr: {\n                        'data-id': node.id\n                    },\n                    // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                    children: node.children\n                };\n            });\n        }\n    });\n\n    return $.mage.folderTree;\n});\n","Magento_ConfigurableProduct/js/configurable-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/catalog/type-events',\n    'collapsible',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate',\n    'domReady!'\n], function ($, productType) {\n    'use strict';\n\n    return {\n        $block: null,\n        hasVariations: null,\n        configurationSectionMessageHandler: (function () {\n            var title = $('[data-role=\"product-create-configuration-info\"]'),\n                buttons = $('[data-action=\"product-create-configuration-buttons\"]'),\n                newText = 'Configurations cannot be created for a standard product with downloadable files.' +\n                ' To create configurations, first remove all downloadable files.',\n                oldText = title.text();\n\n            return function (change) {\n                if (change) {\n                    title.text(newText);\n                    buttons.hide();\n                } else {\n                    title.text(oldText);\n                    buttons.show();\n                }\n            };\n        }()),\n\n        /**\n         * Set element disabled\n         * @param {Object} $element - jquery instance element\n         * @param {Bool} state\n         * @param {Bool} triggerEvent\n         * @private\n         */\n        _setElementDisabled: function ($element, state, triggerEvent) {\n            if (!$element.is('[data-locked]')) {\n                $element.prop('disabled', state);\n\n                if (triggerEvent) {\n                    $element.trigger('change');\n                }\n            }\n        },\n\n        /**\n         * Show\n         */\n        show: function () {\n            this.configurationSectionMessageHandler(false);\n        },\n\n        /**\n         * Hide\n         */\n        hide: function () {\n            this.configurationSectionMessageHandler(true);\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            $(document).on('changeConfigurableTypeProduct', function (event, isConfigurable) {\n                $(document).trigger('setTypeProduct', isConfigurable ?\n                    'configurable' :\n                    productType.type.init === 'configurable' ? 'simple' : productType.type.init\n                );\n            });\n            $(document).on('changeTypeProduct', this._initType.bind(this));\n        },\n\n        /**\n         * Init type\n         * @private\n         */\n        _initType: function () {\n\n            /*var suggestContainer = $('#product-template-suggest-container .action-dropdown > .action-toggle');\n\n\n            if (productType.type.current === 'configurable') {\n                this._setElementDisabled(suggestContainer.addClass('disabled'), true);\n                this._setElementDisabled($('#inventory_qty'), true);\n                this._setElementDisabled($('#inventory_stock_availability'), false);\n                this._setElementDisabled($('#qty'), true, true);\n                this._setElementDisabled($('#quantity_and_stock_status'), false, false);\n            } else {\n                this._setElementDisabled(suggestContainer.removeClass('disabled'), false);\n                this._setElementDisabled($('#inventory_qty'), false);\n                this._setElementDisabled($('#inventory_stock_availability'), true);\n                this._setElementDisabled($('#qty'), false, true);\n            }\n            */\n\n            /*if (['simple', 'virtual', 'configurable'].indexOf(productType.type.current) < 0) {\n                this.hide();\n            } else {\n                this.show();\n            }*/\n\n            this.show();\n        },\n\n        /**\n         * Constructor component\n         * @param {Object} data - this backend data\n         */\n        'Magento_ConfigurableProduct/js/configurable-type-handler': function (data) {\n            this.$block = $(data.blockId + ' input[name=\"attributes[]\"]');\n            this.hasVariations = data.hasVariations;\n\n            //advancedPricingHandler.init();\n            //priceTypeHandler.init();\n\n            /*if (productType.type.init === 'configurable' && !this.hasVariations) {\n                $(document).trigger('setTypeProduct', 'simple');\n            }*/\n            $(document).trigger('setTypeProduct', 'simple');\n\n            this.bindAll();\n            this._initType();\n        }\n    };\n});\n","Magento_ConfigurableProduct/js/configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**************************** CONFIGURABLE PRODUCT **************************/\n/* global Product, optionsPrice */\ndefine([\n    'jquery',\n    'mage/template',\n    'mage/translate',\n    'prototype'\n], function (jQuery, mageTemplate) {\n    'use strict';\n\n    if (typeof Product == 'undefined') {\n        window.Product = {};\n    }\n\n    Product.Config = Class.create();\n    Product.Config.prototype = {\n        /**\n         * Initialize function.\n         *\n         * @param {Object} config\n         */\n        initialize: function (config) {\n            var separatorIndex, paramsStr, urlValues, i, childSettings, prevSetting, nextSetting;\n\n            // Magic preprocessing\n            // TODO MAGETWO-31539\n            config.taxConfig = {\n                showBothPrices: false,\n                inclTaxTitle: jQuery.mage.__('Incl. Tax')\n            };\n\n            this.config     = config;\n            this.taxConfig  = this.config.taxConfig;\n\n            if (config.containerId) {\n                this.settings   = $$('#' + config.containerId + ' ' + '.super-attribute-select');\n            } else {\n                this.settings   = $$('.super-attribute-select');\n            }\n            this.state      = new Hash();\n            this.priceTemplate = mageTemplate(this.config.template);\n            this.prices     = config.prices;\n            this.values     = {};\n\n            // Set default values from config\n            if (config.defaultValues) {\n                this.values = config.defaultValues;\n            }\n\n            // Overwrite defaults by url\n            separatorIndex = window.location.href.indexOf('#');\n\n            if (separatorIndex != -1) { //eslint-disable-line eqeqeq\n                paramsStr = window.location.href.substr(separatorIndex + 1);\n                urlValues = paramsStr.toQueryParams();\n\n                for (i in urlValues) { //eslint-disable-line guard-for-in\n                    this.values[i] = urlValues[i];\n                }\n            }\n\n            // Overwrite defaults by inputs values if needed\n            if (config.inputsInitialized) {\n                this.values = {};\n                this.settings.each(function (element) {\n                    var attributeId;\n\n                    if (element.value) {\n                        attributeId = element.id.replace(/[a-z]*/, '');\n                        this.values[attributeId] = element.value;\n                    }\n                }.bind(this));\n            }\n\n            // Put events to check select reloads\n            this.settings.each(function (element) {\n                Event.observe(element, 'change', this.configure.bind(this));\n            }.bind(this));\n\n            // fill state\n            this.settings.each(function (element) {\n                var attributeId = element.id.replace(/[a-z]*/, '');\n\n                if (attributeId && this.config.attributes[attributeId]) {\n                    element.config = this.config.attributes[attributeId];\n                    element.attributeId = attributeId;\n                    this.state[attributeId] = false;\n                }\n            }.bind(this));\n\n            // Init settings dropdown\n            childSettings = [];\n\n            for (i = this.settings.length - 1; i >= 0; i--) {\n                prevSetting = this.settings[i - 1] ? this.settings[i - 1] : false;\n                nextSetting = this.settings[i + 1] ? this.settings[i + 1] : false;\n\n                if (i === 0) {\n                    this.fillSelect(this.settings[i]);\n                } else {\n                    this.settings[i].disabled = true;\n                }\n                $(this.settings[i]).childSettings = childSettings.clone();\n                $(this.settings[i]).prevSetting   = prevSetting;\n                $(this.settings[i]).nextSetting   = nextSetting;\n                childSettings.push(this.settings[i]);\n            }\n\n            // Set values to inputs\n            this.configureForValues();\n            document.observe('dom:loaded', this.configureForValues.bind(this));\n        },\n\n        /**\n         * Configure for values.\n         */\n        configureForValues: function () {\n            if (this.values) {\n                this.settings.each(function (element) {\n                    var attributeId = element.attributeId;\n\n                    element.value = typeof this.values[attributeId] === 'undefined' ? '' : this.values[attributeId];\n                    this.configureElement(element);\n                }.bind(this));\n            }\n        },\n\n        /**\n         * @param {Object} event\n         */\n        configure: function (event) {\n            var element = Event.element(event);\n\n            this.configureElement(element);\n        },\n\n        /**\n         * @param {Object} element\n         */\n        configureElement: function (element) {\n            this.reloadOptionLabels(element);\n\n            if (element.value) {\n                this.state[element.config.id] = element.value;\n\n                if (element.nextSetting) {\n                    element.nextSetting.disabled = false;\n                    this.fillSelect(element.nextSetting);\n                    this.resetChildren(element.nextSetting);\n                }\n            } else {\n                this.resetChildren(element);\n            }\n            this.reloadPrice();\n        },\n\n        /**\n         * @param {Object} element\n         */\n        reloadOptionLabels: function (element) {\n            var selectedPrice = 0,\n                option, i;\n\n            if (element.options[element.selectedIndex] && element.options[element.selectedIndex].config) {\n                option = element.options[element.selectedIndex].config;\n                selectedPrice = parseFloat(this.config.optionPrices[option.allowedProducts[0]].finalPrice.amount);\n            }\n            element.setAttribute('price', selectedPrice);\n\n            for (i = 0; i < element.options.length; i++) {\n                if (element.options[i].config) {\n                    element.options[i].setAttribute('price', selectedPrice);\n                    element.options[i].setAttribute('summarizePrice', 0);\n                    element.options[i].text = this.getOptionLabel(element.options[i].config, selectedPrice);\n                }\n            }\n        },\n\n        /* eslint-disable max-depth */\n        /**\n         * @param {Object} element\n         */\n        resetChildren: function (element) {\n            var i;\n\n            if (element.childSettings) {\n                for (i = 0; i < element.childSettings.length; i++) {\n                    element.childSettings[i].selectedIndex = 0;\n                    element.childSettings[i].disabled = true;\n\n                    if (element.config) {\n                        this.state[element.config.id] = false;\n                    }\n                }\n            }\n        },\n\n        /**\n         * @param {Object} element\n         */\n        fillSelect: function (element) {\n            var attributeId = element.id.replace(/[a-z]*/, ''),\n                options = this.getAttributeOptions(attributeId),\n                prevConfig = false,\n                index = 1,\n                i, j, allowedProducts;\n\n            this.clearSelect(element);\n            element.options[0] = new Option('', '');\n            element.options[0].innerHTML = this.config.chooseText;\n\n            if (element.prevSetting) {\n                prevConfig = element.prevSetting.options[element.prevSetting.selectedIndex];\n            }\n\n            if (options) {\n                for (i = 0; i < options.length; i++) {\n                    allowedProducts = [];\n\n                    if (prevConfig) {\n                        for (j = 0; j < options[i].products.length; j++) {\n                            if (prevConfig.config.allowedProducts &&\n                                prevConfig.config.allowedProducts.indexOf(options[i].products[j]) > -1\n                            ) {\n                                allowedProducts.push(options[i].products[j]);\n                            }\n                        }\n                    } else {\n                        allowedProducts = options[i].products.clone();\n                    }\n\n                    if (allowedProducts.size() > 0) {\n                        options[i].allowedProducts = allowedProducts;\n                        element.options[index] = new Option(this.getOptionLabel(options[i]), options[i].id);\n\n                        if (typeof options[i].price != 'undefined') {\n                            element.options[index].setAttribute('price', options[i].price);\n                        }\n                        element.options[index].config = options[i];\n                        index++;\n                    }\n                }\n            }\n        },\n\n        //eslint-enable max-depth\n        /**\n         * @param {Object} option\n         */\n        getOptionLabel: function (option) {\n            return option.label;\n        },\n\n        /**\n         * @param {*} price\n         * @param {Boolean} showSign\n         * @return {String}\n         */\n        formatPrice: function (price, showSign) {\n            var str = '',\n                roundedPrice;\n\n            price = parseFloat(price);\n\n            if (showSign) {\n                if (price < 0) {\n                    str += '-';\n                    price = -price;\n                } else {\n                    str += '+';\n                }\n            }\n\n            roundedPrice = Number(Math.round(price + 'e+2') + 'e-2').toString();\n\n            if (this.prices && this.prices[roundedPrice]) {\n                str += this.prices[roundedPrice];\n            } else {\n                str += this.priceTemplate({\n                    data: {\n                        price: price.toFixed(2)\n                    }\n                });\n            }\n\n            return str;\n        },\n\n        /**\n         * @param {Object} element\n         */\n        clearSelect: function (element) {\n            var i;\n\n            for (i = element.options.length - 1; i >= 0; i--) {\n                element.remove(i);\n            }\n        },\n\n        /**\n         * @param {*} attributeId\n         * @return {*|undefined}\n         */\n        getAttributeOptions: function (attributeId) {\n            if (this.config.attributes[attributeId]) {\n                return this.config.attributes[attributeId].options;\n            }\n        },\n\n        /**\n         * Reload price.\n         *\n         * @return {undefined|Number}\n         */\n        reloadPrice: function () {\n            var price = 0,\n                oldPrice = 0,\n                inclTaxPrice = 0,\n                exclTaxPrice = 0,\n                i, selected;\n\n            if (this.config.disablePriceReload) {\n                return undefined;\n            }\n\n            for (i = this.settings.length - 1; i >= 0; i--) {\n                selected = this.settings[i].options[this.settings[i].selectedIndex];\n\n                if (selected.config) {\n                    price += parseFloat(selected.config.price);\n                    oldPrice += parseFloat(selected.config.oldPrice);\n                    inclTaxPrice += parseFloat(selected.config.inclTaxPrice);\n                    exclTaxPrice += parseFloat(selected.config.exclTaxPrice);\n                }\n            }\n\n            optionsPrice.changePrice(\n                'config', {\n                    'price': price,\n                    'oldPrice': oldPrice,\n                    'inclTaxPrice': inclTaxPrice,\n                    'exclTaxPrice': exclTaxPrice\n                }\n            );\n            optionsPrice.reload();\n\n            return price;\n        },\n\n        /**\n         * Reload old price.\n         */\n        reloadOldPrice: function () {\n            var price, i, selected;\n\n            if (this.config.disablePriceReload) {\n                return;\n            }\n\n            if ($('old-price-' + this.config.productId)) {\n\n                price = parseFloat(this.config.oldPrice);\n\n                for (i = this.settings.length - 1; i >= 0; i--) {\n                    selected = this.settings[i].options[this.settings[i].selectedIndex];\n\n                    if (selected.config) {\n                        price += parseFloat(selected.config.price);\n                    }\n                }\n\n                if (price < 0) {\n                    price = 0;\n                }\n                price = this.formatPrice(price);\n\n                if ($('old-price-' + this.config.productId)) {\n                    $('old-price-' + this.config.productId).innerHTML = price;\n                }\n\n            }\n        }\n    };\n});\n","Magento_ConfigurableProduct/js/components/associated-product-insert-listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/form/components/insert-listing'\n], function (_, insertListing) {\n    'use strict';\n\n    return insertListing.extend({\n        defaults: {\n            gridInitialized: false,\n            paramsUpdated: false,\n            showMassActionColumn: true,\n            currentProductId: 0,\n            dataScopeAssociatedProduct: 'data.associated_product_ids',\n            typeGrid: '',\n            product: {},\n            rowIndexForChange: undefined,\n            changeProductData: [],\n            modules: {\n                productsProvider: '${ $.productsProvider }',\n                productsColumns: '${ $.productsColumns }',\n                productsMassAction: '${ $.productsMassAction }',\n                modalWithGrid: '${ $.modalWithGrid }',\n                productsFilters: '${ $.productsFilters }'\n            },\n            exports: {\n                externalProviderParams: '${ $.externalProvider }:params'\n            },\n            links: {\n                changeProductData: '${ $.provider }:${ $.changeProductProvider }'\n            },\n            listens: {\n                '${ $.externalProvider }:params': '_setFilters _setVisibilityMassActionColumn',\n                '${ $.productsProvider }:data': '_handleManualGridOpening',\n                '${ $.productsMassAction }:selected': '_handleManualGridSelect'\n            }\n        },\n\n        /**\n         * Initialize observables.\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super().observe(\n                'changeProductData'\n            );\n\n            return this;\n        },\n\n        /**\n         * Get ids of used products.\n         *\n         * @returns {Array}\n         */\n        getUsedProductIds: function () {\n            var usedProductsIds = this.source.get(this.dataScopeAssociatedProduct);\n\n            return usedProductsIds.slice();\n        },\n\n        /**\n         * Request for render content.\n         *\n         * @returns {Object}\n         */\n        doRender: function (showMassActionColumn, typeGrid) {\n            this.typeGrid = typeGrid;\n            this.showMassActionColumn = showMassActionColumn;\n\n            if (this.gridInitialized) {\n                this.paramsUpdated = false;\n                this.productsFilters().clear();\n                this._setFilters(this.externalProviderParams);\n                this._setVisibilityMassActionColumn();\n            }\n\n            return this.render();\n        },\n\n        /**\n         * Show grid with assigned product.\n         *\n         * @returns {Object}\n         */\n        showGridAssignProduct: function () {\n            this.product = {};\n            this.rowIndexForChange = undefined;\n\n            return this.doRender(true, 'assignProduct');\n        },\n\n        /**\n         * Show grid with changed product.\n         *\n         * @param {String} rowIndex\n         * @param {String} product\n         */\n        showGridChangeProduct: function (rowIndex, product) {\n            this.rowIndexForChange = rowIndex;\n            this.product = product;\n            this.doRender(false, 'changeProduct');\n        },\n\n        /**\n         * Select product.\n         *\n         * @param {String} rowIndex\n         */\n        selectProduct: function (rowIndex) {\n            this.changeProductData({\n                rowIndex: this.rowIndexForChange,\n                product: this.productsProvider().data.items[rowIndex]\n            });\n            this.modalWithGrid().closeModal();\n        },\n\n        /**\n         * Set visibility state for mass action column\n         *\n         * @private\n         */\n        _setVisibilityMassActionColumn: function () {\n            this.productsMassAction(function (massActionComponent) {\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = this.showMassActionColumn;\n                }, this);\n                massActionComponent.visible = this.showMassActionColumn;\n            }.bind(this));\n        },\n\n        /**\n         * Set filters.\n         *\n         * @param {Object} params\n         * @private\n         */\n        _setFilters: function (params) {\n            var filterModifier = {},\n                attrCodes,\n                usedProductIds,\n                attributes;\n\n            params = _.omit(params);\n\n            if (!this.paramsUpdated) {\n                this.gridInitialized = true;\n                this.paramsUpdated = true;\n\n                attrCodes = this._getAttributesCodes();\n                usedProductIds = this.getUsedProductIds();\n\n                if (this.currentProductId) {\n                    usedProductIds.push(this.currentProductId);\n                }\n\n                filterModifier['entity_id'] = {\n                    'condition_type': 'nin', value: usedProductIds\n                };\n                attrCodes.each(function (code) {\n                    filterModifier[code] = {\n                        'condition_type': 'notnull'\n                    };\n                });\n\n                if (this.typeGrid === 'changeProduct') {\n                    attributes = JSON.parse(this.product.attributes);\n\n                    filterModifier = _.extend(filterModifier, _.mapObject(attributes, function (value) {\n                        return {\n                            'condition_type': 'eq',\n                            'value': value\n                        };\n                    }));\n\n                    params.filters = attributes;\n                } else {\n                    params.filters = {};\n                }\n\n                params['attributes_codes'] = attrCodes;\n\n                this.set('externalProviderParams', params);\n                this.set('externalFiltersModifier', filterModifier);\n            }\n        },\n\n        /**\n         * Get attribute codes.\n         *\n         * @returns {Array}\n         * @private\n         */\n        _getAttributesCodes: function () {\n            var attrCodes = this.source.get('data.attribute_codes');\n\n            return attrCodes ? attrCodes : [];\n        },\n\n        /**\n         * Get product variations.\n         *\n         * @returns {Array}\n         * @private\n         */\n        _getProductVariations: function () {\n            var matrix = this.source.get('data.configurable-matrix');\n\n            return matrix ? matrix : [];\n        },\n\n        /**\n         * Handle manual grid after opening\n         * @private\n         */\n        _handleManualGridOpening: function (data) {\n            if (data.items.length && this.typeGrid === 'assignProduct') {\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = true;\n                });\n\n                this._disableRows(data.items);\n            }\n        },\n\n        /**\n         * Handle manual selection.\n         *\n         * @param {Array} selected\n         * @private\n         */\n        _handleManualGridSelect: function (selected) {\n            var selectedRows,\n                selectedVariationKeys;\n\n            if (this.typeGrid === 'assignProduct') {\n                selectedRows = _.filter(this.productsProvider().data.items, function (row) {\n                    return selected.indexOf(row['entity_id']) !== -1;\n                });\n                selectedVariationKeys = _.values(this._getVariationKeyMap(selectedRows));\n                this._disableRows(this.productsProvider().data.items, selectedVariationKeys, selected);\n            }\n        },\n\n        /**\n         * Disable rows in grid for products with the same variation key\n         *\n         * @param {Array} items\n         * @param {Array} selectedVariationKeys\n         * @param {Array} selected\n         * @private\n         */\n        _disableRows: function (items, selectedVariationKeys, selected) {\n            selectedVariationKeys = selectedVariationKeys === undefined ? [] : selectedVariationKeys;\n            selected = selected === undefined ? [] : selected;\n            this.productsMassAction(function (massaction) {\n                var configurableVariationKeys = _.union(\n                    selectedVariationKeys,\n                    _.pluck(this._getProductVariations(), 'variationKey')\n                    ),\n                    variationKeyMap = this._getVariationKeyMap(items),\n                    rowsForDisable = _.keys(_.pick(\n                        variationKeyMap,\n                        function (variationKey) {\n                            return configurableVariationKeys.indexOf(variationKey) !== -1;\n                        }\n                    ));\n\n                massaction.disabled(_.difference(rowsForDisable, selected));\n            }.bind(this));\n        },\n\n        /**\n         * Get variation key map used in manual grid.\n         *\n         * @param {Array} items\n         * @returns {Array} [{entity_id: variation-key}, ...]\n         * @private\n         */\n        _getVariationKeyMap: function (items) {\n            var variationKeyMap = {};\n\n            _.each(items, function (row) {\n                variationKeyMap[row['entity_id']] = _.values(\n                    _.pick(row, this._getAttributesCodes())\n                ).sort().join('-');\n\n            }, this);\n\n            return variationKeyMap;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/container-configurable-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            listens: {\n                '${ $.provider }:data.is_downloadable': 'handleProductType'\n            },\n            links: {\n                isDownloadable: '${ $.provider }:data.is_downloadable'\n            },\n            modules: {\n                createConfigurableButton: '${$.createConfigurableButton}'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super();\n            this.handleProductType(this.isDownloadable);\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['content']);\n\n            return this;\n        },\n\n        /**\n         * Change content for container and visibility for button\n         *\n         * @param {String} isDownloadable\n         */\n        handleProductType: function (isDownloadable) {\n            if (isDownloadable === '1') {\n                this.content(this.content2);\n\n                if (this.createConfigurableButton()) {\n                    this.createConfigurableButton().visible(false);\n                }\n            } else {\n                this.content(this.content1);\n\n                if (this.createConfigurableButton()) {\n                    this.createConfigurableButton().visible(true);\n                }\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/custom-options-price-type.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Catalog/js/components/custom-options-price-type'\n], function (_, PriceType) {\n    'use strict';\n\n    return PriceType.extend({\n        defaults: {\n            isConfigurable: false,\n            isFiltered: null,\n            defaultOptions: null,\n            filteredOptions: null,\n            bannedOptions: []\n        },\n\n        /**\n         * Updates options.\n         *\n         * @param {Boolean} variationsEmpty\n         * @returns {Boolean}\n         */\n        updateOptions: function (variationsEmpty) {\n            var isFiltered = this.isConfigurable || !variationsEmpty,\n                value;\n\n            if (this.isFiltered !== isFiltered) {\n                value = this.value();\n\n                this.options(isFiltered ? this.getFilteredOptions() : this.getDefaultOptions());\n                this.value(value);\n            }\n\n            return isFiltered;\n        },\n\n        /**\n         * Get default list of options.\n         *\n         * @returns {Array}\n         */\n        getDefaultOptions: function () {\n            if (this.defaultOptions === null) {\n                this.defaultOptions = this.options();\n            }\n\n            return this.defaultOptions;\n        },\n\n        /**\n         * Get filtered list of options.\n         *\n         * @returns {Array}\n         */\n        getFilteredOptions: function () {\n            var defaultOptions;\n\n            if (this.filteredOptions === null) {\n                defaultOptions = this.getDefaultOptions();\n                this.filteredOptions = [];\n\n                _.each(defaultOptions, function (option) {\n                    if (this.bannedOptions.indexOf(option.value) === -1) {\n                        this.filteredOptions.push(option);\n                    }\n                }, this);\n            }\n\n            return this.filteredOptions;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/custom-options-warning.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/html'\n], function (Html) {\n    'use strict';\n\n    return Html.extend({\n        defaults: {\n            isConfigurable: false\n        },\n\n        /**\n         * Updates component visibility state.\n         *\n         * @param {Boolean} variationsEmpty\n         * @returns {Boolean}\n         */\n        updateVisibility: function (variationsEmpty) {\n            var isVisible = this.isConfigurable || !variationsEmpty;\n\n            this.visible(isVisible);\n\n            return isVisible;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/dynamic-rows-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows',\n    'jquery'\n], function (_, registry, dynamicRows, $) {\n    'use strict';\n\n    return dynamicRows.extend({\n        defaults: {\n            actionsListOpened: false,\n            canEditField: 'canEdit',\n            newProductField: 'newProduct',\n            dataScopeAssociatedProduct: 'data.associated_product_ids',\n            dataProviderFromGrid: '',\n            dataProviderChangeFromGrid: '',\n            insertDataFromGrid: [],\n            changeDataFromGrid: [],\n            dataProviderFromWizard: '',\n            insertDataFromWizard: [],\n            map: null,\n            isEmpty: true,\n            isShowAddProductButton: false,\n            cacheGridData: [],\n            unionInsertData: [],\n            deleteProperty: false,\n            dataLength: 0,\n            identificationProperty: 'id',\n            'attribute_set_id': '',\n            attributesTmp: [],\n            changedFlag: 'was_changed',\n            listens: {\n                'insertDataFromGrid': 'processingInsertDataFromGrid',\n                'insertDataFromWizard': 'processingInsertDataFromWizard',\n                'unionInsertData': 'processingUnionInsertData',\n                'changeDataFromGrid': 'processingChangeDataFromGrid',\n                'isEmpty': 'changeVisibility'\n            },\n            imports: {\n                'attribute_set_id': '${$.provider}:data.product.attribute_set_id'\n            },\n            'exports': {\n                'attribute_set_id': '${$.provider}:data.new-variations-attribute-set-id'\n            },\n            modules: {\n                modalWithGrid: '${ $.modalWithGrid }',\n                gridWithProducts: '${ $.gridWithProducts}'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super()\n                .changeVisibility(this.isEmpty());\n\n            return this;\n        },\n\n        /**\n         * Change visibility\n         *\n         * When isEmpty = true, then visbible = false\n         *\n         * @param {Boolean} isEmpty\n         */\n        changeVisibility: function (isEmpty) {\n            this.visible(!isEmpty);\n        },\n\n        /**\n         * Open modal with grid.\n         *\n         * @param {String} rowIndex\n         */\n        openModalWithGrid: function (rowIndex) {\n            var productSource = this.source.get(this.dataScope + '.' + this.index + '.' + rowIndex),\n                product = {\n                    'id': productSource.id,\n                    'attributes': productSource['configurable_attribute']\n                };\n\n            this.modalWithGrid().openModal();\n            this.gridWithProducts().showGridChangeProduct(rowIndex, product);\n        },\n\n        /**\n         * Initialize children\n         *\n         * @returns {Object} Chainable.\n         */\n        initChildren: function () {\n            var tmpArray = [];\n\n            this.recordData.each(function (recordData) {\n                tmpArray.push(recordData);\n            }, this);\n\n            this.unionInsertData(tmpArray);\n\n            return this;\n        },\n\n        /**\n         * Delete record\n         *\n         * @param {Number} index - row index\n         */\n        deleteRecord: function (index) {\n            var tmpArray,\n                lastRecord;\n\n            this.reRender = false;\n            tmpArray = this.getUnionInsertData();\n            tmpArray.splice(index, 1);\n\n            if (!tmpArray.length) {\n                this.attributesTmp = this.source.get('data.attributes');\n                this.source.set('data.attributes', []);\n                this.cacheGridData = [];\n            }\n\n            if (parseInt(this.currentPage(), 10) === this.pages()) {\n                lastRecord =\n                    _.findWhere(this.elems(), {\n                        index: this.startIndex + this.getChildItems().length - 1\n                    }) ||\n                    _.findWhere(this.elems(), {\n                        index: (this.startIndex + this.getChildItems().length - 1).toString()\n                    });\n\n                lastRecord.destroy();\n            }\n\n            this.unionInsertData(tmpArray);\n\n            if (this.pages() < parseInt(this.currentPage(), 10)) {\n                this.currentPage(this.pages());\n            }\n\n            this.reRender = true;\n            this.showSpinner(false);\n        },\n\n        /**\n         * Generate associated products\n         */\n        generateAssociatedProducts: function () {\n            var productsIds = [];\n\n            this.getUnionInsertData().forEach(function (data) {\n                if (data.id !== null) {\n                    productsIds.push(data.id);\n                }\n            });\n\n            this.source.set(this.dataScopeAssociatedProduct, productsIds);\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'insertDataFromGrid', 'unionInsertData', 'isEmpty', 'isShowAddProductButton', 'actionsListOpened'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Get union insert data from source\n         *\n         * @returns {Array}\n         */\n        getUnionInsertData: function () {\n            var source = this.source.get(this.dataScope + '.' + this.index),\n                result = [];\n\n            _.each(source, function (data) {\n                result.push(data);\n            });\n\n            return result;\n        },\n\n        /**\n         * Process union insert data.\n         *\n         * @param {Array} data\n         */\n        processingUnionInsertData: function (data) {\n            var dataCount,\n                elemsCount,\n                tmpData,\n                path,\n                attributeCodes = this.source.get('data.attribute_codes');\n\n            this.isEmpty(data.length === 0);\n            this.isShowAddProductButton(\n                (!attributeCodes || data.length > 0 ? data.length : attributeCodes.length) > 0\n            );\n\n            tmpData = data.slice(this.pageSize * (this.currentPage() - 1),\n                                 this.pageSize * (this.currentPage() - 1) + parseInt(this.pageSize, 10));\n\n            this.source.set(this.dataScope + '.' + this.index, []);\n\n            _.each(tmpData, function (row, index) {\n                path = this.dataScope + '.' + this.index + '.' + (this.startIndex + index);\n                row.attributes = $('<i></i>').text(row.attributes).html();\n                this.source.set(path, row);\n            }, this);\n\n            this.source.set(this.dataScope + '.' + this.index, data);\n            this.parsePagesData(data);\n\n            // Render\n            dataCount = tmpData.length;\n            elemsCount = this.elems().length;\n\n            if (dataCount > elemsCount) {\n                tmpData.each(function (elemData, index) {\n                    this.addChild(elemData, this.startIndex + index);\n                }, this);\n            } else {\n                for (elemsCount; elemsCount > dataCount; elemsCount--) {\n                    this.elems()[elemsCount - 1].destroy();\n                }\n            }\n\n            this.generateAssociatedProducts();\n        },\n\n        /**\n         * Set initial property to records data\n         *\n         * @returns {Object} Chainable.\n         */\n        setInitialProperty: function () {\n            return this;\n        },\n\n        /**\n         * Parsed data\n         *\n         * @param {Array} data - array with data\n         * about selected records\n         */\n        processingInsertDataFromGrid: function (data) {\n            var changes,\n                tmpArray;\n\n            if (!data.length) {\n                return;\n            }\n\n            tmpArray = this.getUnionInsertData();\n\n            changes = this._checkGridData(data);\n            this.cacheGridData = data;\n\n            changes.each(function (changedObject) {\n                var mappedData = this.mappingValue(changedObject);\n\n                mappedData[this.canEditField] = 0;\n                mappedData[this.newProductField] = 0;\n                mappedData.variationKey = this._getVariationKey(changedObject);\n                mappedData['configurable_attribute'] = this._getConfigurableAttribute(changedObject);\n                tmpArray.push(mappedData);\n            }, this);\n\n            // Attributes cannot be changed before regeneration thought wizard\n            if (!this.source.get('data.attributes').length) {\n                this.source.set('data.attributes', this.attributesTmp);\n            }\n            this.unionInsertData(tmpArray);\n        },\n\n        /**\n         * Process changes from grid.\n         *\n         * @param {Object} data\n         */\n        processingChangeDataFromGrid: function (data) {\n            var tmpArray = this.getUnionInsertData(),\n                mappedData = this.mappingValue(data.product);\n\n            mappedData[this.canEditField] = 0;\n            mappedData[this.newProductField] = 0;\n            mappedData.variationKey = this._getVariationKey(data.product);\n            mappedData['configurable_attribute'] = this._getConfigurableAttribute(data.product);\n            tmpArray[data.rowIndex] = mappedData;\n\n            this.unionInsertData(tmpArray);\n        },\n\n        /**\n         * Get variation key.\n         *\n         * @param {Object} data\n         * @returns {String}\n         * @private\n         */\n        _getVariationKey: function (data) {\n            var attrCodes = this.source.get('data.attribute_codes'),\n                key = [];\n\n            attrCodes.each(function (code) {\n                key.push(data[code]);\n            });\n\n            return key.sort().join('-');\n        },\n\n        /**\n         * Get configurable attribute.\n         *\n         * @param {Object} data\n         * @returns {String}\n         * @private\n         */\n        _getConfigurableAttribute: function (data) {\n            var attrCodes = this.source.get('data.attribute_codes'),\n                confAttrs = {};\n\n            attrCodes.each(function (code) {\n                confAttrs[code] = data[code];\n            });\n\n            return JSON.stringify(confAttrs);\n        },\n\n        /**\n         * Process data insertion from wizard\n         *\n         * @param {Object} data\n         */\n        processingInsertDataFromWizard: function (data) {\n            var tmpArray = this.getUnionInsertData(),\n                productIdsToDelete = this.source.get(this.dataScopeAssociatedProduct),\n                index,\n                product = {};\n\n            tmpArray = this.unsetArrayItem(\n                tmpArray,\n                {\n                    id: null\n                }\n            );\n\n            _.each(data, function (row) {\n                if (row.productId) {\n                    index = _.indexOf(productIdsToDelete, row.productId);\n\n                    if (index > -1) {\n                        productIdsToDelete.splice(index, 1);\n                        tmpArray = this.unsetArrayItem(\n                            tmpArray,\n                            {\n                                id: row.productId\n                            }\n                        );\n                    }\n                }\n                product = this.getProductData(row);\n\n                product[this.changedFlag] = true;\n                product[this.canEditField] = row.editable;\n                product[this.newProductField] = row.newProduct;\n                tmpArray.push(product);\n            }, this);\n\n            _.each(productIdsToDelete, function (id) {\n                tmpArray = this.unsetArrayItem(\n                    tmpArray,\n                    {\n                        id: id\n                    }\n                );\n            }, this);\n\n            this.unionInsertData(tmpArray);\n        },\n\n        /**\n         *\n         * @param {Object} row\n         * @returns {Object}\n         */\n        getProductData: function (row) {\n            var product,\n                attributesText = '';\n\n            _.each(row.options, function (attribute) {\n                if (attributesText) {\n                    attributesText += ', ';\n                }\n                attributesText += attribute['attribute_label'] + ': ' + attribute.label;\n            }, this);\n\n            product = {\n                'id': row.productId,\n                'product_link': row.productUrl,\n                'name': $('<i></i>').text(row.name).html(),\n                'sku': row.sku,\n                'status': row.status,\n                'price': row.price,\n                'price_currency': row.priceCurrency,\n                'price_string': row.priceCurrency + row.price,\n                'weight': row.weight,\n                'qty': row.quantity,\n                'variationKey': row.variationKey,\n                'configurable_attribute': row.attribute,\n                'thumbnail_image': row.images.preview,\n                'media_gallery': row['media_gallery'],\n                'swatch_image': row['swatch_image'],\n                'small_image': row['small_image'],\n                image: row.image,\n                'thumbnail': row.thumbnail,\n                'attributes': attributesText\n            };\n\n            return product;\n        },\n\n        /**\n         * Remove array items matching condition.\n         *\n         * @param {Array} data\n         * @param {Object} condition\n         * @returns {Array}\n         */\n        unsetArrayItem: function (data, condition) {\n            var objs = _.where(data, condition);\n\n            _.each(objs, function (obj) {\n                var index = _.indexOf(data, obj);\n\n                if (index > -1) {\n                    data.splice(index, 1);\n                }\n            });\n\n            return data;\n        },\n\n        /**\n         * Check changed records\n         *\n         * @param {Array} data - array with records data\n         * @returns {Array} Changed records\n         */\n        _checkGridData: function (data) {\n            var cacheLength = this.cacheGridData.length,\n                curData = data.length,\n                max = cacheLength > curData ? this.cacheGridData : data,\n                changes = [],\n                obj = {};\n\n            max.each(function (record, index) {\n                obj[this.map.id] = record[this.map.id];\n\n                if (!_.where(this.cacheGridData, obj).length) {\n                    changes.push(data[index]);\n                }\n            }, this);\n\n            return changes;\n        },\n\n        /**\n         * Mapped value\n         */\n        mappingValue: function (data) {\n            var result = {};\n\n            _.each(this.map, function (prop, index) {\n                result[index] = data[prop];\n            });\n\n            return result;\n        },\n\n        /**\n         * Toggle actions list.\n         *\n         * @param {Number} rowIndex\n         * @returns {Object} Chainable.\n         */\n        toggleActionsList: function (rowIndex) {\n            var state = false;\n\n            if (rowIndex !== this.actionsListOpened()) {\n                state = rowIndex;\n            }\n            this.actionsListOpened(state);\n\n            return this;\n        },\n\n        /**\n         * Close action list.\n         *\n         * @param {Number} rowIndex\n         * @returns {Object} Chainable\n         */\n        closeList: function (rowIndex) {\n            if (this.actionsListOpened() === rowIndex) {\n                this.actionsListOpened(false);\n            }\n\n            return this;\n        },\n\n        /**\n         * Toggle product status.\n         *\n         * @param {Number} rowIndex\n         */\n        toggleStatusProduct: function (rowIndex) {\n            var tmpArray = this.getUnionInsertData(),\n                status = parseInt(tmpArray[rowIndex].status, 10);\n\n            if (status === 1) {\n                tmpArray[rowIndex].status = 2;\n            } else {\n                tmpArray[rowIndex].status = 1;\n            }\n\n            tmpArray[rowIndex][this.changedFlag] = true;\n            this.unionInsertData(tmpArray);\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/file-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/file-uploader',\n    'underscore'\n], function (Element, _) {\n    'use strict';\n\n    return Element.extend({\n        processedFile: {},\n        actionsListOpened: false,\n        thumbnailUrl: '',\n        thumbnail: null,\n        smallImage: null,\n        defaults: {\n            fileInputName: ''\n        },\n\n        /**\n         * Initialize observables.\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super().observe(['processedFile', 'actionsListOpened', 'thumbnailUrl', 'thumbnail', 'smallImage']);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        setInitialValue: function () {\n            var value = this.getInitialValue();\n\n            if (!_.isString(value)) {\n                this._super();\n            }\n\n            return this;\n        },\n\n        /**\n         * Adds provided file to the files list.\n         *\n         * @param {Object} file\n         * @returns {Object} Chainable.\n         */\n        addFile: function (file) {\n            this.processedFile(this.processFile(file));\n\n            this.value(this.processedFile().file);\n\n            return this;\n        },\n\n        /**\n         * Toggle actions list.\n         *\n         * @returns {Object} Chainable.\n         */\n        toggleActionsList: function () {\n            if (this.actionsListOpened()) {\n                this.actionsListOpened(false);\n            } else {\n                this.actionsListOpened(true);\n            }\n\n            return this;\n        },\n\n        /**\n         * Close action list.\n         *\n         * @returns {Object} Chainable\n         */\n        closeList: function () {\n            if (this.actionsListOpened()) {\n                this.actionsListOpened(false);\n            }\n\n            return this;\n        },\n\n        /**\n         * Delete Image\n         *\n         * @returns {Object} Chainable\n         */\n        deleteImage: function () {\n            this.processedFile({});\n            this.value(null);\n            this.thumbnail(null);\n            this.thumbnailUrl(null);\n            this.smallImage(null);\n\n            return this;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/modal-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/modal/modal-component',\n    'uiRegistry',\n    'underscore'\n], function (Modal, registry, _) {\n    'use strict';\n\n    return Modal.extend({\n        defaults: {\n            stepWizard: '',\n            modules: {\n                form: '${ $.formName }'\n            }\n        },\n\n        /**\n         * Open modal\n         */\n        openModal: function () {\n            var stepWizard = {};\n\n            this.form().validate();\n\n            if (this.form().source.get('params.invalid') === false) {\n                stepWizard = registry.get('index = ' + this.stepWizard);\n\n                if (!_.isUndefined(stepWizard)) {\n                    stepWizard.open();\n                }\n\n                this._super();\n            } else {\n                this.form().focusInvalid();\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/price-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/form/element/abstract'\n], function (_, registry, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            imports: {\n                isConfigurable: '!ns = ${ $.ns }, index = configurable-matrix:isEmpty'\n            },\n            modules: {\n                createConfigurableButton: '${$.createConfigurableButton}'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            // resolve initial disable state\n            this.handlePriceValue(this.isConfigurable);\n            // add listener to track \"configurable\" type\n            this.setListeners({\n                isConfigurable: 'handlePriceValue'\n            });\n\n            return this;\n        },\n\n        /**\n         * Calls 'initObservable' of parent\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['content']);\n\n            return this;\n        },\n\n        /**\n         * Disable and clear price if product type changed to configurable\n         *\n         * @param {String} isConfigurable\n         */\n        handlePriceValue: function (isConfigurable) {\n            this.disabled(!!this.isUseDefault() || isConfigurable);\n            this.required(!!this.isUseDefault() || !isConfigurable);\n\n            if (isConfigurable) {\n                this.clear();\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/components/qty-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            imports: {\n                isConfigurable: '!ns = ${ $.ns }, index = configurable-matrix:isEmpty'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            // resolve initial disable state\n            this.handleQtyValue(this.isConfigurable);\n\n            /** important to set this listener in initialize because of a different order of processing.\n             * Do not move to defaults->listens section */\n            this.setListeners({\n                isConfigurable: 'handleQtyValue'\n            });\n\n            return this;\n        },\n\n        /**\n         * Disable and clear Qty if product type changed to configurable\n         *\n         * @param {String} isConfigurable\n         */\n        handleQtyValue: function (isConfigurable) {\n            this.disabled(!!this.isUseDefault() || isConfigurable);\n\n            if (isConfigurable) {\n                this.clear();\n            }\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/options/price-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/*\ndefine([\n    'jquery',\n    'Magento_Catalog/catalog/type-events',\n    'notification',\n    'mage/translate'\n], function ($, productType) {\n    'use strict';\n\n    return {\n        isConfigurable: false,\n        messageInited: false,\n        messageSelector: '[data-role=product-custom-options-content]',\n        isPercentPriceTypeExist: function () {\n            var productOptionsContainer = $('#product_options_container_top');\n\n            return !!productOptionsContainer.length;\n        },\n        showWarning: function () {\n            if (!this.messageInited) {\n                $(this.messageSelector).notification();\n                this.messageInited = true;\n            }\n            this.hideWarning();\n            $(this.messageSelector).notification('add', {\n                message: $.mage.__('Custom options with price type \"percent\" is not available for ' +\n                    'configurable product.'),\n                error: false,\n                messageContainer: this.messageSelector\n            });\n        },\n        hideWarning: function () {\n            $(this.messageSelector).notification('clear');\n        },\n        init: function () {\n            $(document).on('changeTypeProduct', this._initType.bind(this));\n\n            $('#product-edit-form-tabs').on('change', '.opt-type > select', function () {\n                var selected = $('.opt-type > select :selected'),\n                    optGroup = selected.parent().attr('label');\n\n                if (optGroup === 'Select') {\n                    $('#product-edit-form-tabs').on(\n                        'click',\n                        '[data-ui-id=\"admin-product-options-options-box-select-option-type-add-select-row-button\"]',\n                        function () {\n                            this.percentPriceTypeHandler();\n                        }.bind(this)\n                    );\n                } else {\n                    this.percentPriceTypeHandler();\n                }\n            }.bind(this));\n\n            this._initType();\n        },\n        _initType: function () {\n            this.isConfigurable = productType.type.current === 'configurable';\n            if (this.isPercentPriceTypeExist()) {\n                this.percentPriceTypeHandler();\n            }\n        },\n        percentPriceTypeHandler: function () {\n            var priceType = $('[data-attr=\"price-type\"]'),\n                optionPercentPriceType = priceType.find('option[value=\"percent\"]');\n\n            if (this.isConfigurable) {\n                this.showWarning();\n                optionPercentPriceType.hide();\n                optionPercentPriceType.parent().val() === 'percent' ? optionPercentPriceType.parent().val('fixed') : '';\n            } else {\n                $(this.messageSelector).notification();\n                optionPercentPriceType.show();\n                this.hideWarning();\n            }\n        }\n    };\n});\n*/\n","Magento_ConfigurableProduct/js/variations/product-grid.js":"// jscs:disable requireDotNotation\n/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'Magento_Ui/js/core/app',\n    'underscore',\n    'notification',\n    'mage/translate'\n], function (Component, $, bootstrap, _) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            productsGridUrl: null,\n            productAttributes: [],\n            productsModal: null,\n            button: '',\n            gridSelector: '[data-grid-id=associated-products-container]',\n            modules: {\n                productsFilter: '${ $.productsFilter }',\n                productsProvider: '${ $.productsProvider }',\n                productsMassAction: '${ $.productsMassAction }',\n                productsColumns: '${ $.productsColumns }',\n                variationsComponent: '${ $.configurableVariations }'\n            },\n            listens: {\n                '${ $.productsProvider }:data': '_showMessageAssociatedGrid _handleManualGridOpening',\n                '${ $.productsMassAction }:selected': '_handleManualGridSelect',\n                '${ $.configurableVariations }:productMatrix': '_showButtonAddManual _switchProductType'\n            }\n        },\n\n        /**\n         * Initialize\n         *\n         * @param {Array} options\n         */\n        initialize: function (options) {\n            this._super(options);\n            this.productsModal = $(this.gridSelector).modal({\n                title: $.mage.__('Select Associated Product'),\n                type: 'slide',\n                buttons: [\n                    {\n                        text: $.mage.__('Cancel'),\n\n                        /** Close modal */\n                        click: function () {\n                            this.closeModal();\n                        }\n                    }, {\n                        text: $.mage.__('Done'),\n                        click: this.close.bind(this, null)\n                    }\n                ]\n            });\n\n            this.productsProvider(function () {\n                this.productsModal.notification();\n            }.bind(this));\n            this.variationsComponent(function (variation) {\n                this._showButtonAddManual(variation.productMatrix());\n            }.bind(this));\n\n            this._initGrid = _.once(this._initGrid);\n            this._switchProductType = _.wrap(this._switchProductType.bind(this), function (func, params) {\n                if (!!params.length !== !!this.init) {\n                    this.init = !!params.length;\n                    func(params);\n                }\n            }.bind(this._switchProductType));\n        },\n\n        /**\n         * Initial observerable\n         * @returns {*}\n         */\n        initObservable: function () {\n            this._super().observe('button');\n\n            return this;\n        },\n\n        /**\n         * init Grid\n         * @private\n         */\n        _initGrid: function (filterData) {\n            $.ajax({\n                type: 'GET',\n                url: this._buildGridUrl(filterData),\n                context: $('body')\n            }).done(function (data) {\n                bootstrap(JSON.parse(data));\n            });\n        },\n\n        /**\n         * Select different product in configurations section\n         * @see configurable_associated_product_listing.xml\n         * @param {Integer} rowIndex\n         */\n        selectProduct: function (rowIndex) {\n            this.close(rowIndex);\n        },\n\n        /**\n         * Open\n         * @param {Object} filterData - filter data\n         * @param {Object|*} filterData.filters - attribute name\n         * @param {Object|*} filterData.filters_modifier - modifier value\n         * @param {String} callbackName\n         * @param {Boolean} showMassActionColumn\n         */\n        open: function (filterData, callbackName, showMassActionColumn) {\n            this.callbackName = callbackName;\n            this.productsMassAction(function (massActionComponent) {\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = showMassActionColumn;\n                });\n                massActionComponent.visible = showMassActionColumn;\n            }.bind(this));\n            this._setFilter(filterData);\n            this._initGrid(filterData);\n            this.productsModal.trigger('openModal');\n        },\n\n        /**\n         * Close\n         */\n        close: function (rowIndex) {\n            try {\n                if (this.productsMassAction().selected.getLength()) {\n                    this.variationsComponent()[this.callbackName](this.productsMassAction()\n                        .selected.map(this.getProductById.bind(this)));\n                    this.productsMassAction().deselectAll();\n                } else if (!_.isNull(rowIndex)) {\n                    this.variationsComponent()[this.callbackName]([this.getProductByIndex(rowIndex)]);\n                }\n                this.productsModal.trigger('closeModal');\n            } catch (e) {\n                if (e.name === 'UserException') {\n                    this.productsModal.notification('clear');\n                    this.productsModal.notification('add', {\n                        message: e.message,\n                        messageContainer: this.gridSelector\n                    });\n                } else {\n                    throw e;\n                }\n            }\n        },\n\n        /**\n         * Get product by id\n         * @param {Integer} productId\n         * @returns {*}\n         */\n        getProductById: function (productId) {\n            return _.findWhere(this.productsProvider().data.items, {\n                'entity_id': productId\n            });\n        },\n\n        /**\n         * Get product\n         * @param {Integer} rowIndex\n         * @returns {*}\n         */\n        getProductByIndex: function (rowIndex) {\n            return this.productsProvider().data.items[rowIndex];\n        },\n\n        /**\n         * Build grid url\n         * @private\n         */\n        _buildGridUrl: function (filterData) {\n            var params = '?' + $.param({\n                'filters': filterData.filters,\n                'attributes_codes': this._getAttributesCodes(),\n                'filters_modifier': filterData['filters_modifier']\n            });\n\n            return this.productsGridUrl + params;\n        },\n\n        /**\n         * Show button add manual\n         * @param {Array} variations\n         * @returns {*}\n         * @private\n         */\n        _showButtonAddManual: function (variations) {\n            return this.button(variations.length);\n        },\n\n        /**\n         * @param {Array} variations\n         * @private\n         */\n        _switchProductType: function (variations) {\n            $(document).trigger('changeConfigurableTypeProduct', variations.length);\n        },\n\n        /**\n         * Get attributes codes used for configurable\n         * @private\n         */\n        _getAttributesCodes: function () {\n            return this.variationsComponent().attributes.pluck('code');\n        },\n\n        /**\n         * Show data associated grid\n         * @private\n         */\n        _showMessageAssociatedGrid: function (data) {\n            this.productsModal.notification('clear');\n\n            if (data.items.length) {\n                this.productsModal.notification('add', {\n                    message: $.mage.__('Choose a new product to delete and replace the current product configuration.'),\n                    messageContainer: this.gridSelector\n                });\n            } else {\n                this.productsModal.notification('add', {\n                    message: $.mage.__('For better results, add attributes and attribute values to your products.'),\n                    messageContainer: this.gridSelector\n                });\n            }\n        },\n\n        /**\n         * Show manually grid\n         */\n        showManuallyGrid: function () {\n            var filterModifier = _.mapObject(_.object(this._getAttributesCodes(), []), function () {\n                    return {\n                        'condition_type': 'notnull'\n                    };\n                }),\n                usedProductIds = _.values(this.variationsComponent().productAttributesMap);\n\n            if (usedProductIds && usedProductIds.length > 0) {\n                filterModifier['entity_id'] = {\n                    'condition_type': 'nin', value: usedProductIds\n                };\n            }\n\n            this.open(\n                {\n                    'filters_modifier': filterModifier\n                },\n                'appendProducts',\n                true\n            );\n        },\n\n        /**\n         * Handle manual grid after opening\n         * @private\n         */\n        _handleManualGridOpening: function (data) {\n            if (data.items.length && this.callbackName == 'appendProducts') { //eslint-disable-line eqeqeq\n                this.productsColumns().elems().each(function (rowElement) {\n                    rowElement.disableAction = true;\n                });\n\n                this._disableRows(data.items);\n            }\n        },\n\n        /**\n         * Disable rows in grid for products with the same variation key\n         *\n         * @param {Array} items\n         * @param {Array} selectedVariationKeys\n         * @param {Array} selected\n         * @private\n         */\n        _disableRows: function (items, selectedVariationKeys, selected) {\n            selectedVariationKeys = selectedVariationKeys === undefined ? [] : selectedVariationKeys;\n            selected = selected === undefined ? [] : selected;\n            this.productsMassAction(function (massaction) {\n                var configurableVariationKeys = _.union(\n                        selectedVariationKeys,\n                        _.pluck(this.variationsComponent().productMatrix(), 'variationKey')\n                    ),\n                    variationKeyMap = this._getVariationKeyMap(items),\n                    rowsForDisable = _.keys(_.pick(\n                        variationKeyMap,\n                        function (variationKey) {\n                            return configurableVariationKeys.indexOf(variationKey) !== -1;\n                        }\n                    ));\n\n                massaction.disabled(_.difference(rowsForDisable, selected));\n            }.bind(this));\n        },\n\n        /**\n         * @private\n         */\n        _handleManualGridSelect: function (selected) {\n            var selectedRows, selectedVariationKeys;\n\n            if (this.callbackName == 'appendProducts') { //eslint-disable-line eqeqeq\n                selectedRows = _.filter(this.productsProvider().data.items, function (row) {\n                    return selected.indexOf(row['entity_id']) !== -1;\n                });\n                selectedVariationKeys = _.values(this._getVariationKeyMap(selectedRows));\n                this._disableRows(this.productsProvider().data.items, selectedVariationKeys, selected);\n            }\n        },\n\n        /**\n         * Get variation key map used in manual grid.\n         *\n         * @param {Object} items\n         * @returns {Array} [{entity_id: variation-key}, ...]\n         * @private\n         */\n        _getVariationKeyMap: function (items) {\n            this._variationKeyMap = {};\n\n            _.each(items, function (row) {\n                this._variationKeyMap[row['entity_id']] = _.values(\n                    _.pick(row, this._getAttributesCodes())\n                ).sort().join('-');\n\n            }, this);\n\n            return this._variationKeyMap;\n        },\n\n        /**\n         * Set filter\n         * @private\n         */\n        _setFilter: function (filterData) {\n            this.productsProvider(function (provider) {\n                provider.params['filters_modifier'] = filterData['filters_modifier'];\n                provider.params['attributes_codes'] = this._getAttributesCodes();\n            }.bind(this));\n\n            this.productsFilter(function (filter) {\n                filter.set('filters', _.extend({\n                    'filters_modifier': filterData['filters_modifier']\n                }, filterData.filters))\n                    .apply();\n            });\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/variations.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'Magento_Ui/js/modal/alert',\n    'uiRegistry',\n    'mage/translate'\n], function (Component, $, ko, _, alert, registry, $t) {\n    'use strict';\n\n    /**\n     * @param {*} message\n     * @constructor\n     */\n    function UserException(message) {\n        this.message = message;\n        this.name = 'UserException';\n    }\n    UserException.prototype = Object.create(Error.prototype);\n\n    return Component.extend({\n        defaults: {\n            opened: false,\n            attributes: [],\n            usedAttributes: [],\n            attributeCodes: [],\n            attributesData: {},\n            productMatrix: [],\n            variations: [],\n            formSaveParams: [],\n            productAttributes: [],\n            disabledAttributes: [],\n            fullAttributes: [],\n            rowIndexToEdit: false,\n            productAttributesMap: null,\n            value: [],\n            modules: {\n                associatedProductGrid: '${ $.configurableProductGrid }',\n                wizardButtonElement: '${ $.wizardModalButtonName }',\n                formElement: '${ $.formName }',\n                attributeSetHandlerModal: '${ $.attributeSetHandler }'\n            },\n            imports: {\n                attributeSetName: '${ $.provider }:configurableNewAttributeSetName',\n                attributeSetId: '${ $.provider }:configurableExistingAttributeSetId',\n                attributeSetSelection: '${ $.provider }:configurableAffectedAttributeSet',\n                productPrice: '${ $.provider }:data.product.price'\n            },\n            links: {\n                value: '${ $.provider }:${ $.dataScopeVariations }',\n                usedAttributes: '${ $.provider }:${ $.dataScopeAttributes }',\n                attributesData: '${ $.provider }:${ $.dataScopeAttributesData }',\n                attributeCodes: '${ $.provider }:${ $.dataScopeAttributeCodes }',\n                skeletonAttributeSet: '${ $.provider }:data.new-variations-attribute-set-id'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n\n            this.changeButtonWizard();\n            this.initProductAttributesMap();\n            this.disableConfigurableAttributes(this.productAttributes);\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe(\n                'actions opened attributes productMatrix value usedAttributes attributesData attributeCodes'\n            );\n\n            return this;\n        },\n\n        /**\n         * @param {Object} product\n         * @return {Object}\n         * @private\n         */\n        _makeProduct: function (product) {\n            var productId = product['entity_id'] || product.productId || null,\n                attributes = _.pick(product, this.attributes.pluck('code')),\n                options = _.map(attributes, function (option, attribute) {\n                    var oldOptions = _.findWhere(this.attributes(), {\n                            code: attribute\n                        }).options,\n                        result;\n\n                    if (_.isFunction(oldOptions)) {\n                        result = oldOptions.findWhere({\n                            value: option\n                        });\n                    } else {\n                        result = _.findWhere(oldOptions, {\n                            value: option\n                        });\n                    }\n\n                    return result;\n                }.bind(this));\n\n            return {\n                attribute: JSON.stringify(attributes),\n                editable: false,\n                images: {\n                    preview: product['thumbnail_src']\n                },\n                name: product.name || product.sku,\n                options: options,\n                price: parseFloat(Math.round(product.price.replace(/[^\\d.]+/g, '') + 'e+4') + 'e-4').toFixed(4),\n                productId: productId,\n                productUrl: this.buildProductUrl(productId),\n                quantity: product.quantity || null,\n                sku: product.sku,\n                status: product.status === undefined ? 1 : parseInt(product.status, 10),\n                variationKey: this.getVariationKey(options),\n                weight: product.weight || null\n            };\n        },\n\n        /**\n         * @param {String} name\n         * @return {String|Number|Array}\n         */\n        getProductValue: function (name) {\n            name = name.split('/').join('][');\n\n            return $('[name=\"product[' + name + ']\"]:enabled:not(.ignore-validate)', this.productForm).val();\n        },\n\n        /**\n         * @param {Object} data\n         * @param {String} field\n         * @return {String}\n         */\n        getRowId: function (data, field) {\n            var key = data.variationKey;\n\n            return 'variations-matrix-' + key + '-' + field;\n        },\n\n        /**\n         * @param {Object} variation\n         * @param {String} field\n         * @return {String}\n         */\n        getVariationRowName: function (variation, field) {\n            var result;\n\n            if (variation.productId) {\n                result = 'configurations[' + variation.productId + '][' + field.split('/').join('][') + ']';\n            } else {\n                result = 'variations-matrix[' + variation.variationKey + '][' + field.split('/').join('][') + ']';\n            }\n\n            return result;\n        },\n\n        /**\n         * @param {*} variations\n         * @param {*} attributes\n         */\n        render: function (variations, attributes) {\n            this.changeButtonWizard();\n            this.populateVariationMatrix(variations);\n            this.attributes(attributes);\n            this.disableConfigurableAttributes(attributes);\n            this.handleValue(variations);\n            this.handleAttributes();\n        },\n\n        /**\n         * Change button wizard.\n         */\n        changeButtonWizard: function () {\n            if (this.variations.length) {\n                this.wizardButtonElement().title(this.wizardModalButtonTitle);\n            }\n        },\n\n        /**\n         * @param {Array} variations\n         */\n        handleValue: function (variations) {\n            var tmpArray = [];\n\n            _.each(variations, function (variation) {\n                var attributes = _.reduce(variation.options, function (memo, option) {\n                    var attribute = {};\n\n                    attribute[option['attribute_code']] = option.value;\n\n                    return _.extend(memo, attribute);\n                }, {}),\n                    gallery = {\n                        images: {}\n                    },\n                    types = {};\n\n                _.each(variation.images.images, function (image) {\n                    gallery.images[image['file_id']] = {\n                        position: image.position,\n                        file: image.file,\n                        disabled: image.disabled,\n                        label: image.label || ''\n                    };\n                    _.each(image.galleryTypes, function (type) {\n                        types[type] = image.file;\n                    });\n                }, this);\n\n                tmpArray.push(_.extend(variation, types, {\n                    productId: variation.productId || null,\n                    name: variation.name || variation.sku,\n                    priceCurrency: this.currencySymbol,\n                    weight: variation.weight,\n                    attribute: JSON.stringify(attributes),\n                    variationKey: this.getVariationKey(variation.options),\n                    editable: variation.editable === undefined ? 0 : 1,\n                    productUrl: this.buildProductUrl(variation.productId),\n                    status: variation.status === undefined ? 1 : parseInt(variation.status, 10),\n                    newProduct: variation.productId ? 0 : 1,\n                    'media_gallery': gallery\n                }));\n            }, this);\n\n            this.value(tmpArray);\n        },\n\n        /**\n         * Handle attributes.\n         */\n        handleAttributes: function () {\n            var tmpArray = [],\n                codesArray = [],\n                tmpOptions = {},\n                option = {},\n                position = 0,\n                values = {};\n\n            _.each(this.attributes(), function (attribute) {\n                tmpArray.push(attribute.id);\n                codesArray.push(attribute.code);\n                values = {};\n                _.each(attribute.chosen, function (row) {\n                    values[row.value] = {\n                        'include': '1',\n                        'value_index': row.value\n                    };\n                }, this);\n                option = {\n                    'attribute_id': attribute.id,\n                    'code': attribute.code,\n                    'label': attribute.label,\n                    'position': position,\n                    'values': values\n                };\n                tmpOptions[attribute.id] = option;\n                position++;\n            }, this);\n\n            this.attributesData(tmpOptions);\n            this.usedAttributes(tmpArray);\n            this.attributeCodes(codesArray);\n        },\n\n        /**\n         * Get attributes options\n         * @see use in matrix.phtml\n         *\n         * @returns {Array}\n         */\n        getAttributesOptions: function () {\n            return this.showVariations() ? this.productMatrix()[0].options : [];\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        showVariations: function () {\n            return this.productMatrix().length > 0;\n        },\n\n        /**\n         * @param {Array} variations\n         */\n        populateVariationMatrix: function (variations) {\n            this.productMatrix([]);\n            _.each(variations, function (variation) {\n                var attributes = _.reduce(variation.options, function (memo, option) {\n                    var attribute = {};\n\n                    attribute[option['attribute_code']] = option.value;\n\n                    return _.extend(memo, attribute);\n                }, {});\n\n                this.productMatrix.push(_.extend(variation, {\n                    productId: variation.productId || null,\n                    name: variation.name || variation.sku,\n                    weight: variation.weight,\n                    attribute: JSON.stringify(attributes),\n                    variationKey: this.getVariationKey(variation.options),\n                    editable: variation.editable === undefined ? !variation.productId : variation.editable,\n                    productUrl: this.buildProductUrl(variation.productId),\n                    status: variation.status === undefined ? 1 : parseInt(variation.status, 10)\n                }));\n            }, this);\n        },\n\n        /**\n         * @param {*} productId\n         */\n        buildProductUrl: function (productId) {\n            return this.productUrl.replace('%id%', productId);\n        },\n\n        /**\n         * @param {Object} options\n         * @return {String}\n         */\n        getVariationKey: function (options) {\n            return _.pluck(options, 'value').sort().join('-');\n        },\n\n        /**\n         * @param {*} options\n         * @return {*|null}\n         */\n        getProductIdByOptions: function (options) {\n            return this.productAttributesMap[this.getVariationKey(options)] || null;\n        },\n\n        /**\n         * Init product attributes map\n         */\n        initProductAttributesMap: function () {\n            if (this.productAttributesMap === null) {\n                this.productAttributesMap = {};\n                _.each(this.variations, function (product) {\n                    this.productAttributesMap[this.getVariationKey(product.options)] = product.productId;\n                }.bind(this));\n            }\n        },\n\n        /**\n         * @param {Array} attributes\n         */\n        disableConfigurableAttributes: function (attributes) {\n            var element;\n\n            _.each(this.disabledAttributes, function (attribute) {\n                registry.get('inputName = ' + 'product[' + attribute + ']').disabled(false);\n            });\n            this.disabledAttributes = [];\n\n            _.each(attributes, function (attribute) {\n                element = registry.get('inputName = ' + 'product[' + attribute.code + ']');\n\n                if (!_.isUndefined(element)) {\n                    element.disabled(true);\n                    this.disabledAttributes.push(attribute.code);\n                }\n            }, this);\n        },\n\n        /**\n         * Get currency symbol\n         * @returns {String}\n         */\n        getCurrencySymbol: function () {\n            return this.currencySymbol;\n        },\n\n        /**\n         * Chose action for the form save button\n         */\n        saveFormHandler: function () {\n            this.formElement().validate();\n\n            if (this.formElement().source.get('params.invalid') === false) {\n                this.serializeData();\n            }\n\n            if (this.checkForNewAttributes()) {\n                this.formSaveParams = arguments;\n                this.attributeSetHandlerModal().openModal();\n            } else {\n                if (this.validateForm(this.formElement())) {\n                    this.clearOutdatedData();\n                }\n                this.formElement().save(arguments[0], arguments[1]);\n\n                if (this.formElement().source.get('params.invalid')) {\n                    this.unserializeData();\n                }\n            }\n        },\n\n        /**\n         * @param {Object} formElement\n         *\n         * Validates each form element and returns true, if all elements are valid.\n         */\n        validateForm: function (formElement) {\n            formElement.validate();\n\n            return !formElement.additionalInvalid && !formElement.source.get('params.invalid');\n        },\n\n        /**\n         * Serialize data for specific form fields\n         *\n         * Serializes some complex data fields\n         *\n         * Original fields:\n         *   - configurable-matrix;\n         *   - associated_product_ids.\n         *\n         * Serialized fields in request:\n         *   - configurable-matrix-serialized;\n         *   - associated_product_ids_serialized.\n         */\n        serializeData: function () {\n            if (this.source.data['configurable-matrix']) {\n                this.source.data['configurable-matrix-serialized'] =\n                    JSON.stringify(this.source.data['configurable-matrix']);\n            }\n\n            if (this.source.data['associated_product_ids']) {\n                this.source.data['associated_product_ids_serialized'] =\n                    JSON.stringify(this.source.data['associated_product_ids']);\n            }\n        },\n\n        /**\n         * Clear outdated data for specific form fields\n         *\n         * Outdated fields:\n         *   - configurable-matrix;\n         *   - associated_product_ids.\n         */\n        clearOutdatedData: function () {\n            if (this.source.data['configurable-matrix']) {\n                delete this.source.data['configurable-matrix'];\n            }\n\n            if (this.source.data['associated_product_ids']) {\n                delete this.source.data['associated_product_ids'];\n            }\n        },\n\n        /**\n         * Unserialize data for specific form fields\n         *\n         * Unserializes some fields that were serialized this.serializeData\n         */\n        unserializeData: function () {\n            if (this.source.data['configurable-matrix-serialized']) {\n                this.source.data['configurable-matrix'] =\n                    JSON.parse(this.source.data['configurable-matrix-serialized']);\n                delete this.source.data['configurable-matrix-serialized'];\n            }\n\n            if (this.source.data['associated_product_ids_serialized']) {\n                this.source.data['associated_product_ids'] =\n                    JSON.parse(this.source.data['associated_product_ids_serialized']);\n                delete this.source.data['associated_product_ids_serialized'];\n            }\n        },\n\n        /**\n         * Check for newly added attributes\n         * @returns {Boolean}\n         */\n        checkForNewAttributes: function () {\n            var element, newAttributes = false;\n\n            _.each(this.source.get('data.attribute_codes'), function (attribute) {\n                element = registry.get('index = ' + attribute);\n\n                if (_.isUndefined(element)) {\n                    newAttributes = true;\n                }\n            }, this);\n\n            return newAttributes;\n        },\n\n        /**\n         * New attributes handler\n         * @returns {Boolean}\n         */\n        addNewAttributeSetHandler: function () {\n            var chosenAttributeSetOption;\n\n            this.formElement().validate();\n\n            if (this.formElement().source.get('params.invalid') === false) {\n                chosenAttributeSetOption = this.attributeSetSelection;\n\n                if (chosenAttributeSetOption === 'new') {\n                    this.createNewAttributeSet();\n\n                    return false;\n                }\n\n                if (chosenAttributeSetOption === 'existing') {\n                    this.set(\n                        'skeletonAttributeSet',\n                        this.attributeSetId\n                    );\n                }\n\n                this.closeDialogAndProcessForm();\n\n                return true;\n            }\n\n            this.unserializeData();\n\n            return false;\n        },\n\n        /**\n         * Handles new attribute set creation\n         * @returns {Boolean}\n         */\n        createNewAttributeSet: function () {\n            var messageBoxElement = registry.get('index = affectedAttributeSetError');\n\n            messageBoxElement.visible(false);\n\n            $.ajax({\n                type: 'POST',\n                url: this.attributeSetCreationUrl,\n                data: {\n                    gotoEdit: 1,\n                    'attribute_set_name': this.attributeSetName,\n                    'skeleton_set': this.skeletonAttributeSet,\n                    'return_session_messages_only': 1\n                },\n                dataType: 'json',\n                showLoader: true,\n                context: this\n            }).done(function (data) {\n                if (!data.error) {\n                    this.set(\n                        'skeletonAttributeSet',\n                        data.id\n                    );\n                    messageBoxElement.content(data.messages);\n                    messageBoxElement.visible(true);\n                    this.closeDialogAndProcessForm();\n                } else {\n                    messageBoxElement.content(data.messages);\n                    messageBoxElement.visible(true);\n                }\n\n                return false;\n            }).fail(function (xhr) {\n                if (xhr.statusText === 'abort') {\n                    return;\n                }\n\n                alert({\n                    content: $t('Something went wrong.')\n                });\n            });\n\n            return false;\n        },\n\n        /**\n         * Closes attribute set handler modal and process product form\n         */\n        closeDialogAndProcessForm: function () {\n            this.attributeSetHandlerModal().closeModal();\n            this.formElement().save(this.formSaveParams[0], this.formSaveParams[1]);\n        },\n\n        /**\n         * Retrieves product price\n         * @returns {*}\n         */\n        getProductPrice: function () {\n            return this.productPrice;\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/paging/sizes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/paging/sizes'\n], function (Sizes) {\n    'use strict';\n\n    return Sizes.extend({\n        defaults: {\n            options: {\n                '20': {\n                    value: 20,\n                    label: 20\n                },\n                '30': {\n                    value: 30,\n                    label: 30\n                },\n                '50': {\n                    value: 50,\n                    label: 50\n                }\n            },\n            value: 20\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/attributes_values.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'mageUtils',\n    'Magento_Ui/js/lib/collapsible',\n    'mage/translate'\n], function (Component, $, ko, _, utils, Collapsible) {\n    'use strict';\n\n    //connect items with observableArrays\n    ko.bindingHandlers.sortableList = {\n        /** @inheritdoc */\n        init: function (element, valueAccessor) {\n            var list = valueAccessor();\n\n            $(element).sortable({\n                axis: 'y',\n                handle: '[data-role=\"draggable\"]',\n                tolerance: 'pointer',\n\n                /** @inheritdoc */\n                update: function (event, ui) {\n                    var item = ko.contextFor(ui.item[0]).$data,\n                        position = ko.utils.arrayIndexOf(ui.item.parent().children(), ui.item[0]);\n\n                    if (ko.contextFor(ui.item[0]).$index() != position) { //eslint-disable-line eqeqeq\n                        if (position >= 0) {\n                            list.remove(item);\n                            list.splice(position, 0, item);\n                        }\n                        ui.item.remove();\n                    }\n                }\n            });\n        }\n    };\n\n    return Collapsible.extend({\n        defaults: {\n            notificationMessage: {\n                text: null,\n                error: null\n            },\n            createOptionsUrl: null,\n            attributes: [],\n            stepInitialized: false\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.createAttribute = _.wrap(this.createAttribute, function () {\n                var args = _.toArray(arguments),\n                    createAttribute = args.shift();\n\n                return this.doInitSavedOptions(createAttribute.apply(this, args));\n            });\n            this.createAttribute = _.memoize(this.createAttribute.bind(this), _.property('id'));\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe(['attributes']);\n\n            return this;\n        },\n\n        /**\n         * Create option.\n         */\n        createOption: function () {\n            // this - current attribute\n            this.options.push({\n                value: 0,\n                label: '',\n                id: utils.uniqueid(),\n                'attribute_id': this.id,\n                'is_new': true\n            });\n        },\n\n        /**\n         * @param {Object} option\n         */\n        saveOption: function (option) {\n            if (this.isValidOption(option)) {\n                this.options.remove(option);\n                this.options.push(option);\n                this.chosenOptions.push(option.id);\n            }\n        },\n\n        /**\n         * @param {Object} newOption\n         * @return boolean\n         */\n        isValidOption: function (newOption) {\n            var duplicatedOptions = [],\n                errorOption,\n                allOptions = [];\n\n            newOption.label = newOption.label.trim();\n\n            if (_.isEmpty(newOption.label)) {\n                return false;\n            }\n\n            _.each(this.options(), function (option) {\n                if (!_.isUndefined(allOptions[option.label]) && newOption.label === option.label) {\n                    duplicatedOptions.push(option);\n                }\n\n                allOptions[option.label] = option.label;\n            });\n\n            if (duplicatedOptions.length) {\n                _.each(duplicatedOptions, function (duplicatedOption) {\n                    errorOption = $('[data-role=\"' + duplicatedOption.id + '\"]');\n                    errorOption.addClass('_error');\n                });\n\n                return false;\n            }\n\n            return true;\n        },\n\n        /**\n         * @param {Object} option\n         */\n        removeOption: function (option) {\n            this.options.remove(option);\n        },\n\n        /**\n         * @param {String} attribute\n         */\n        removeAttribute: function (attribute) {\n            this.attributes.remove(attribute);\n            this.wizard.setNotificationMessage(\n                $.mage.__('An attribute has been removed. This attribute will no longer appear in your configurations.')\n            );\n        },\n\n        /**\n         * @param {Object} attribute\n         * @param {*} index\n         * @return {Object}\n         */\n        createAttribute: function (attribute, index) {\n            attribute.chosenOptions = ko.observableArray([]);\n            attribute.options = ko.observableArray(_.map(attribute.options, function (option) {\n                option.id = utils.uniqueid();\n\n                return option;\n            }));\n            attribute.opened = ko.observable(this.initialOpened(index));\n            attribute.collapsible = ko.observable(true);\n            attribute.isValidOption = this.isValidOption;\n\n            return attribute;\n        },\n\n        /**\n         * First 3 attribute panels must be open.\n         *\n         * @param {Number} index\n         * @return {Boolean}\n         */\n        initialOpened: function (index) {\n            return index < 3;\n        },\n\n        /**\n         * Save attribute.\n         */\n        saveAttribute: function () {\n            var errorMessage = $.mage.__('Select options for all attributes or remove unused attributes.');\n\n            if (!this.attributes().length) {\n                throw new Error(errorMessage);\n            }\n\n            _.each(this.attributes(), function (attribute) {\n                attribute.chosen = [];\n\n                if (!attribute.chosenOptions.getLength()) {\n                    throw new Error(errorMessage);\n                }\n                _.each(attribute.chosenOptions(), function (id) {\n                    attribute.chosen.push(attribute.options.findWhere({\n                        id: id\n                    }));\n                });\n            });\n        },\n\n        /**\n         * @param {Object} attribute\n         */\n        selectAllAttributes: function (attribute) {\n            this.chosenOptions(_.pluck(attribute.options(), 'id'));\n        },\n\n        /**\n         * @param {Object} attribute\n         */\n        deSelectAllAttributes: function (attribute) {\n            attribute.chosenOptions.removeAll();\n        },\n\n        /**\n         * @return {Boolean}\n         */\n        saveOptions: function () {\n            var newOptions = [];\n\n            _.each(this.attributes(), function (attribute) {\n                _.each(attribute.options(), function (element) {\n                    var option = attribute.options.findWhere({\n                        id: element.id\n                    });\n\n                    if (option['is_new'] === true) {\n                        if (!attribute.isValidOption(option)) {\n                            throw new Error(\n                                $.mage.__('The value of attribute \"\"%1\"\" must be unique')\n                                    .replace('\"%1\"', attribute.label)\n                            );\n                        }\n\n                        newOptions.push(option);\n                    }\n                });\n            });\n\n            if (!newOptions.length) {\n                return false;\n            }\n\n            $.ajax({\n                type: 'POST',\n                url: this.createOptionsUrl,\n                data: {\n                    options: newOptions\n                },\n                showLoader: true\n            }).done(function (savedOptions) {\n                if (savedOptions.error) {\n                    this.notificationMessage.error = savedOptions.error;\n                    this.notificationMessage.text = savedOptions.message;\n\n                    return;\n                }\n\n                _.each(this.attributes(), function (attribute) {\n                    _.each(savedOptions, function (newOptionId, oldOptionId) {\n                        var option = attribute.options.findWhere({\n                            id: oldOptionId\n                        });\n\n                        if (option) {\n                            attribute.options.remove(option);\n                            option['is_new'] = false;\n                            option.value = newOptionId;\n                            attribute.options.push(option);\n                        }\n                    });\n                });\n\n            }.bind(this));\n        },\n\n        /**\n         * @param {*} attributeIds\n         */\n        requestAttributes: function (attributeIds) {\n            $.ajax({\n                type: 'GET',\n                url: this.optionsUrl,\n                data: {\n                    attributes: attributeIds\n                },\n                showLoader: true\n            }).done(function (attributes) {\n                attributes = _.sortBy(attributes, function (attribute) {\n                    return this.wizard.data.attributesIds.indexOf(attribute.id);\n                }.bind(this));\n                this.attributes(_.map(attributes, this.createAttribute));\n            }.bind(this));\n        },\n\n        /**\n         * @param {*} attribute\n         * @return {*}\n         */\n        doInitSavedOptions: function (attribute) {\n            var selectedOptions, selectedOptionsIds, selectedAttribute = _.findWhere(this.initData.attributes, {\n                id: attribute.id\n            });\n\n            if (selectedAttribute) {\n                selectedOptions = _.pluck(selectedAttribute.chosen, 'value');\n                selectedOptionsIds = _.pluck(_.filter(attribute.options(), function (option) {\n                    return _.contains(selectedOptions, option.value);\n                }), 'id');\n                attribute.chosenOptions(selectedOptionsIds);\n                this.initData.attributes = _.without(this.initData.attributes, selectedAttribute);\n            }\n\n            return attribute;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.requestAttributes(wizard.data.attributesIds());\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        force: function (wizard) {\n            this.saveOptions();\n            this.saveAttribute(wizard);\n\n            wizard.data.attributes = this.attributes;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        back: function (wizard) {\n            wizard.data.attributesIds(this.attributes().pluck('id'));\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/bulk.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY, byteConvert */\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'Magento_Ui/js/lib/collapsible',\n    'mage/template',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Catalog/js/product-gallery',\n    'jquery/file-uploader',\n    'mage/translate',\n    'Magento_ConfigurableProduct/js/variations/variations'\n], function (Component, $, ko, _, Collapsible, mageTemplate, alert) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            modules: {\n                variationsComponent: '${ $.variationsComponent }'\n            },\n            countVariations: 0,\n            attributes: [],\n            sections: {},\n            images: null,\n            price: '',\n            quantity: '',\n            notificationMessage: {\n                text: null,\n                error: null\n            }\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe('countVariations attributes sections');\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var self = this;\n\n            this._super();\n            this.sections({\n                images: {\n                    label: 'images',\n                    type: ko.observable('none'),\n                    value: ko.observable(),\n                    attribute: ko.observable()\n                },\n                price: {\n                    label: 'price',\n                    type: ko.observable('none'),\n                    value: ko.observable(),\n                    attribute: ko.observable(),\n                    currencySymbol: ''\n                },\n                quantity: {\n                    label: 'quantity',\n                    type: ko.observable('none'),\n                    value: ko.observable(),\n                    attribute: ko.observable()\n                }\n            });\n\n            this.variationsComponent(function (variationsComponent) {\n                this.sections().price.currencySymbol = variationsComponent.getCurrencySymbol();\n            }.bind(this));\n\n            /**\n             * Make options sections.\n             */\n            this.makeOptionSections = function () {\n                return {\n                    images: new this.makeImages(null),\n                    price: this.price,\n                    quantity: this.quantity\n                };\n            }.bind(this);\n\n            /**\n             * @param {Object} images\n             * @param {*} typePreview\n             */\n            this.makeImages = function (images, typePreview) {\n                var preview;\n\n                if (!images) {\n                    this.images = [];\n                    this.preview = self.noImage;\n                    this.file = null;\n                } else {\n                    this.images = images;\n                    preview = _.find(this.images, function (image) {\n                        return _.contains(image.galleryTypes, typePreview);\n                    });\n\n                    if (preview) {\n                        this.file = preview.file;\n                        this.preview = preview.url;\n                    } else {\n                        this.file = null;\n                        this.preview = self.noImage;\n                    }\n                }\n            };\n            this.images = new this.makeImages();\n            _.each(this.sections(), function (section) {\n                section.type.subscribe(function () {\n                    this.setWizardNotifyMessageDependOnSectionType();\n                }.bind(this));\n            }, this);\n        },\n        types: ['each', 'single', 'none'],\n\n        /**\n         * Set Wizard notify message depend on section type\n         */\n        setWizardNotifyMessageDependOnSectionType: function () {\n            var flag = false;\n\n            _.each(this.sections(), function (section) {\n                if (section.type() !== 'none') {\n                    flag = true;\n                }\n            }, this);\n\n            if (flag) {\n                this.wizard.setNotificationMessage(\n                    $.mage.__('Choose this option to delete and replace extension data for all past configurations.')\n                );\n            } else {\n                this.wizard.cleanNotificationMessage();\n            }\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.attributes(wizard.data.attributes());\n\n            if (this.mode === 'edit') {\n                this.setWizardNotifyMessageDependOnSectionType();\n            }\n            //fill option section data\n            this.attributes.each(function (attribute) {\n                attribute.chosen.each(function (option) {\n                    option.sections = ko.observable(this.makeOptionSections());\n                }, this);\n            }, this);\n            //reset section.attribute\n            _.each(this.sections(), function (section) {\n                section.attribute(null);\n            });\n\n            this.initCountVariations();\n            this.bindGalleries();\n        },\n\n        /**\n         * Init count variations.\n         */\n        initCountVariations: function () {\n            var variations = this.generateVariation(this.attributes()),\n                newVariations = _.map(variations, function (options) {\n                    return this.variationsComponent().getVariationKey(options);\n                }.bind(this)),\n                existingVariations = _.keys(this.variationsComponent().productAttributesMap);\n\n            this.countVariations(_.difference(newVariations, existingVariations).length);\n        },\n\n        /**\n         * @param {Object} attributes - example [['b1', 'b2'],['a1', 'a2', 'a3'],['c1', 'c2', 'c3'],['d1']]\n         * @returns {*} example [['b1','a1','c1','d1'],['b1','a1','c2','d1']...]\n         */\n        generateVariation: function (attributes) {\n            return _.reduce(attributes, function (matrix, attribute) {\n                var tmp = [];\n\n                _.each(matrix, function (variations) {\n                    _.each(attribute.chosen, function (option) {\n                        option['attribute_code'] = attribute.code;\n                        option['attribute_label'] = attribute.label;\n                        tmp.push(_.union(variations, [option]));\n                    });\n                });\n\n                if (!tmp.length) {\n                    return _.map(attribute.chosen, function (option) {\n                        option['attribute_code'] = attribute.code;\n                        option['attribute_label'] = attribute.label;\n\n                        return [option];\n                    });\n                }\n\n                return tmp;\n            }, []);\n        },\n\n        /**\n         * @param {*} section\n         * @param {Object} options\n         * @return {*}\n         */\n        getSectionValue: function (section, options) {\n            switch (this.sections()[section].type()) {\n                case 'each':\n                    return _.find(this.sections()[section].attribute().chosen, function (chosen) {\n                        return _.find(options, function (option) {\n                            return chosen.id == option.id; //eslint-disable-line eqeqeq\n                        });\n                    }).sections()[section];\n\n                case 'single':\n                    return this.sections()[section].value();\n\n                case 'none':\n                    return this[section];\n            }\n        },\n\n        /**\n         * @param {*} node\n         * @return {Promise|*}\n         */\n        getImageProperty: function (node) {\n            var types = node.find('[data-role=gallery]').productGallery('option').types,\n                images = _.map(node.find('[data-role=image]'), function (image) {\n                    var imageData = $(image).data('imageData'),\n                        positionElement;\n\n                    imageData.galleryTypes = _.pluck(_.filter(types, function (type) {\n                        return type.value === imageData.file;\n                    }), 'code');\n\n                    //jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                    positionElement =\n                        $(image).find('[name=\"product[media_gallery][images][' + imageData.file_id + '][position]\"]');\n                    //jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n                    if (!_.isEmpty(positionElement.val())) {\n                        imageData.position = positionElement.val();\n                    }\n\n                    return imageData;\n                });\n\n            return _.reject(images, function (image) {\n                return !!image.isRemoved;\n            });\n        },\n\n        /**\n         * Fill images section.\n         */\n        fillImagesSection: function () {\n            switch (this.sections().images.type()) {\n                case 'each':\n                    if (this.sections().images.attribute()) {\n                        this.sections().images.attribute().chosen.each(function (option) {\n                            option.sections().images = new this.makeImages(\n                                this.getImageProperty($('[data-role=step-gallery-option-' + option.id + ']')),\n                                'thumbnail'\n                            );\n                        }, this);\n                    }\n                    break;\n\n                case 'single':\n                    this.sections().images.value(new this.makeImages(\n                        this.getImageProperty($('[data-role=step-gallery-single]')),\n                        'thumbnail'\n                    ));\n                    break;\n\n                default:\n                    this.sections().images.value(new this.makeImages());\n                    break;\n            }\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        force: function (wizard) {\n            this.fillImagesSection();\n            this.validate();\n            this.validateImage();\n            wizard.data.sections = this.sections;\n            wizard.data.sectionHelper = this.getSectionValue.bind(this);\n            wizard.data.variations = this.generateVariation(this.attributes());\n        },\n\n        /**\n         * Validate.\n         */\n        validate: function () {\n            var formValid;\n\n            _.each(this.sections(), function (section) {\n                switch (section.type()) {\n                    case 'each':\n                        if (!section.attribute()) {\n                            throw new Error($.mage.__('Please select attribute for {section} section.')\n                                .replace('{section}', section.label));\n                        }\n                        break;\n\n                    case 'single':\n                        if (!section.value()) {\n                            throw new Error($.mage.__('Please fill in the values for {section} section.')\n                                .replace('{section}', section.label));\n                        }\n                        break;\n                }\n            }, this);\n            formValid = true;\n            _.each($('[data-role=attributes-values-form]'), function (form) {\n                formValid = $(form).valid() && formValid;\n            });\n\n            if (!formValid) {\n                throw new Error($.mage.__('Please fill-in correct values.'));\n            }\n        },\n\n        /**\n         * Validate image.\n         */\n        validateImage: function () {\n            switch (this.sections().images.type()) {\n                case 'each':\n                    _.each(this.sections().images.attribute().chosen, function (option) {\n                        if (!option.sections().images.images.length) {\n                            throw new Error($.mage.__('Please select image(s) for your attribute.'));\n                        }\n                    });\n                    break;\n\n                case 'single':\n                    if (this.sections().images.value().file == null) {\n                        throw new Error($.mage.__('Please choose image(s).'));\n                    }\n                    break;\n            }\n        },\n\n        /**\n         * Back.\n         */\n        back: function () {\n            this.setWizardNotifyMessageDependOnSectionType();\n        },\n\n        /**\n         * Bind galleries.\n         */\n        bindGalleries: function () {\n            $('[data-role=bulk-step] [data-role=gallery]').each(function (index, element) {\n                var gallery = $(element),\n                    uploadInput = $(gallery.find('[name=image]')),\n                    dropZone = $(gallery).find('.image-placeholder');\n\n                if (!gallery.data('gallery-initialized')) {\n                    gallery.mage('productGallery', {\n                        template: '[data-template=gallery-content]',\n                        dialogTemplate: '.dialog-template',\n                        dialogContainerTmpl: '[data-role=img-dialog-container-tmpl]'\n                    });\n\n                    uploadInput.fileupload({\n                        dataType: 'json',\n                        dropZone: dropZone,\n                        process: [{\n                            action: 'load',\n                            fileTypes: /^image\\/(gif|jpeg|png)$/\n                        }, {\n                            action: 'resize',\n                            maxWidth: 1920,\n                            maxHeight: 1200\n                        }, {\n                            action: 'save'\n                        }],\n                        formData: {\n                            'form_key': FORM_KEY\n                        },\n                        sequentialUploads: true,\n                        acceptFileTypes: /(\\.|\\/)(gif|jpe?g|png)$/i,\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        add: function (e, data) {\n                            var progressTmpl = mageTemplate('[data-template=uploader]'),\n                                fileSize,\n                                tmpl;\n\n                            $.each(data.files, function (i, file) {\n                                fileSize = typeof file.size == 'undefined' ?\n                                    $.mage.__('We could not detect a size.') :\n                                    byteConvert(file.size);\n\n                                data.fileId = Math.random().toString(33).substr(2, 18);\n\n                                tmpl = progressTmpl({\n                                    data: {\n                                        name: file.name,\n                                        size: fileSize,\n                                        id: data.fileId\n                                    }\n                                });\n\n                                $(tmpl).appendTo(gallery.find('[data-role=uploader]'));\n                            });\n\n                            $(this).fileupload('process', data).done(function () {\n                                data.submit();\n                            });\n                        },\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        done: function (e, data) {\n                            if (data.result && !data.result.error) {\n                                gallery.trigger('addItem', data.result);\n                            } else {\n                                $('#' + data.fileId)\n                                    .delay(2000)\n                                    .hide('highlight');\n                                alert({\n                                    content: $.mage.__('We don\\'t recognize or support this file extension type.')\n                                });\n                            }\n                            $('#' + data.fileId).remove();\n                        },\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        progress: function (e, data) {\n                            var progress = parseInt(data.loaded / data.total * 100, 10),\n                                progressSelector = '#' + data.fileId + ' .progressbar-container .progressbar';\n\n                            $(progressSelector).css('width', progress + '%');\n                        },\n\n                        /**\n                         * @param {jQuery.Event} e\n                         * @param {Object} data\n                         */\n                        fail: function (e, data) {\n                            var progressSelector = '#' + data.fileId;\n\n                            $(progressSelector).removeClass('upload-progress').addClass('upload-failure')\n                                .delay(2000)\n                                .hide('highlight')\n                                .remove();\n                        }\n                    });\n                    gallery.data('gallery-initialized', 1);\n                }\n            });\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/select_attributes.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'underscore',\n    'mage/translate'\n], function (Component, $, _) {\n    'use strict';\n\n    /**\n     * @param {Function} provider\n     */\n    var initNewAttributeListener = function (provider) {\n        $('[data-role=product-variations-matrix]').on('add', function () {\n            provider().reload();\n        });\n    };\n\n    return Component.extend({\n        attributesLabels: {},\n        stepInitialized: false,\n        defaults: {\n            modules: {\n                multiselect: '${ $.multiselectName }',\n                attributeProvider: '${ $.providerName }'\n            },\n            listens: {\n                '${ $.multiselectName }:selected': 'doSelectedAttributesLabels',\n                '${ $.multiselectName }:rows': 'doSelectSavedAttributes'\n            },\n            notificationMessage: {\n                text: null,\n                error: null\n            },\n            selectedAttributes: []\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            this._super();\n            this.selected = [];\n\n            initNewAttributeListener(this.attributeProvider);\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            this._super().observe(['selectedAttributes']);\n\n            return this;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.setNotificationMessage();\n        },\n\n        /**\n         * Set notification message.\n         */\n        setNotificationMessage: function () {\n            /*eslint-disable max-len*/\n            var msg = $.mage.__('When you remove or add an attribute, we automatically update all configurations and you will need to recreate current configurations manually.');\n\n            /*eslint-enable max-len*/\n\n            if (this.mode === 'edit') {\n                this.wizard.setNotificationMessage(msg);\n            }\n        },\n\n        /**\n         * Do select saved attributes.\n         */\n        doSelectSavedAttributes: function () {\n            if (this.stepInitialized === false) {\n                this.stepInitialized = true;\n                //cache attributes labels, which can be present on the 2nd page\n                _.each(this.initData.attributes, function (attribute) {\n                    this.attributesLabels[attribute.id] = attribute.label;\n                }.bind(this));\n                this.multiselect().selected(_.pluck(this.initData.attributes, 'id'));\n            }\n        },\n\n        /**\n         * @param {*} selected\n         */\n        doSelectedAttributesLabels: function (selected) {\n            var labels = [];\n\n            this.selected = selected;\n            _.each(selected, function (attributeId) {\n                var attribute;\n\n                if (!this.attributesLabels[attributeId]) {\n                    attribute = _.findWhere(this.multiselect().rows(), {\n                        'attribute_id': attributeId\n                    });\n\n                    if (attribute) {\n                        this.attributesLabels[attribute['attribute_id']] = attribute['frontend_label'];\n                    }\n                }\n                labels.push(this.attributesLabels[attributeId]);\n            }.bind(this));\n            this.selectedAttributes(labels.join(', '));\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        force: function (wizard) {\n            wizard.data.attributesIds = this.multiselect().selected;\n\n            if (!wizard.data.attributesIds() || wizard.data.attributesIds().length === 0) {\n                throw new Error($.mage.__('Please select attribute(s).'));\n            }\n            this.setNotificationMessage();\n        },\n\n        /**\n         * Back.\n         */\n        back: function () {\n        }\n    });\n});\n","Magento_ConfigurableProduct/js/variations/steps/summary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'ko',\n    'underscore',\n    'Magento_Ui/js/grid/paging/paging',\n    'mage/translate'\n], function (Component, $, ko, _, paging) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            modules: {\n                variationsComponent: '${ $.variationsComponent }',\n                modalComponent: '${ $.modalComponent }',\n                matrixGridComponent: '${ $.matrixGridComponent }'\n            },\n            notificationMessage: {\n                text: null,\n                error: null\n            },\n            gridExisting: [],\n            gridNew: [],\n            gridDeleted: [],\n            variationsExisting: [],\n            variationsNew: [],\n            variationsDeleted: [],\n            pagingExisting: paging({\n                name: 'configurableWizard.pagingExisting',\n                sizesConfig: {\n                    component: 'Magento_ConfigurableProduct/js/variations/paging/sizes',\n                    name: 'configurableWizard.pagingExisting_sizes'\n                }\n            }),\n            pagingNew: paging({\n                name: 'configurableWizard.pagingNew',\n                sizesConfig: {\n                    component: 'Magento_ConfigurableProduct/js/variations/paging/sizes',\n                    name: 'configurableWizard.pagingNew_sizes'\n                }\n            }),\n            pagingDeleted: paging({\n                name: 'configurableWizard.pagingDeleted',\n                sizesConfig: {\n                    component: 'Magento_ConfigurableProduct/js/variations/paging/sizes',\n                    name: 'configurableWizard.pagingDeleted_sizes'\n                }\n            }),\n            attributes: [],\n            attributesName: [$.mage.__('Images'), $.mage.__('SKU'), $.mage.__('Quantity'), $.mage.__('Price')],\n            sections: [],\n            gridTemplate: 'Magento_ConfigurableProduct/variations/steps/summary-grid',\n            quantityFieldName: 'quantity'\n        },\n\n        /** @inheritdoc */\n        initObservable: function () {\n            var pagingObservables = {\n                currentNew: ko.getObservable(this.pagingNew, 'current'),\n                currentExisting: ko.getObservable(this.pagingExisting, 'current'),\n                currentDeleted: ko.getObservable(this.pagingDeleted, 'current'),\n                pageSizeNew: ko.getObservable(this.pagingNew, 'pageSize'),\n                pageSizeExisting: ko.getObservable(this.pagingExisting, 'pageSize'),\n                pageSizeDeleted: ko.getObservable(this.pagingDeleted, 'pageSize')\n            };\n\n            this._super().observe('gridExisting gridNew gridDeleted attributes sections');\n            this.gridExisting.columns = ko.observableArray();\n            this.gridNew.columns = ko.observableArray();\n            this.gridDeleted.columns = ko.observableArray();\n\n            _.each(pagingObservables, function (observable) {\n                observable.subscribe(function () {\n                    this.generateGrid();\n                }, this);\n            }, this);\n\n            return this;\n        },\n        nextLabelText: $.mage.__('Generate Products'),\n        variations: [],\n\n        /**\n         * @param {*} variations\n         * @param {Function} getSectionValue\n         */\n        calculate: function (variations, getSectionValue) {\n            var productSku = this.variationsComponent().getProductValue('sku'),\n                productPrice = this.variationsComponent().getProductPrice(),\n                productWeight = this.variationsComponent().getProductValue('weight'),\n                productName = this.variationsComponent().getProductValue('name'),\n                variationsKeys = [],\n                gridExisting = [],\n                gridNew = [],\n                gridDeleted = [],\n                matrixGridData = this.matrixGridComponent() ?\n                    _.indexBy(this.matrixGridComponent().getUnionInsertData(), 'variationKey') : {};\n\n            this.variations = [];\n            _.each(variations, function (options) {\n                var product, images, sku, name, quantity, price, variation,\n                    variationsKey = this.variationsComponent().getVariationKey(options),\n                    productDataFromGrid = matrixGridData[variationsKey] || {},\n                    productDataFromWizard = {},\n                    productId = this.variationsComponent().getProductIdByOptions(options);\n\n                if (productId) {\n                    product = _.findWhere(this.variationsComponent().variations, {\n                        productId: productId\n                    });\n                }\n                images = getSectionValue('images', options);\n                sku = productSku + _.reduce(options, function (memo, option) {\n                    return memo + '-' + option.label;\n                }, '');\n                name = productName + _.reduce(options, function (memo, option) {\n                    return memo + '-' + option.label;\n                }, '');\n                quantity = getSectionValue(this.quantityFieldName, options);\n\n                if (quantity) {\n                    productDataFromWizard[this.quantityFieldName] = quantity;\n                }\n                price = getSectionValue('price', options);\n\n                if (price) {\n                    productDataFromWizard.price = price;\n                }\n\n                if (productId && !images.file) {\n                    images = product.images;\n                }\n                productDataFromGrid = _.pick(\n                    productDataFromGrid,\n                    'sku',\n                    'name',\n                    'weight',\n                    'status',\n                    'price',\n                    'qty'\n                );\n\n                if (productDataFromGrid.hasOwnProperty('qty')) {\n                    productDataFromGrid[this.quantityFieldName] = productDataFromGrid.qty;\n                }\n                delete productDataFromGrid.qty;\n                product = _.pick(\n                    product || {},\n                    'sku',\n                    'name',\n                    'weight',\n                    'status',\n                    'price',\n                    this.quantityFieldName\n                );\n                variation = {\n                    options: options,\n                    images: images,\n                    sku: sku,\n                    name: name,\n                    price: productPrice,\n                    productId: productId,\n                    weight: productWeight,\n                    editable: true\n                };\n                variation[this.quantityFieldName] = quantity;\n                variation = _.extend(variation, product, productDataFromGrid, productDataFromWizard);\n\n                if (productId) {\n                    gridExisting.push(this.prepareRowForGrid(variation));\n                } else {\n                    gridNew.push(this.prepareRowForGrid(variation));\n                }\n                this.variations.push(variation);\n                variationsKeys.push(variationsKey);\n            }, this);\n\n            _.each(_.omit(this.variationsComponent().productAttributesMap, variationsKeys), function (productId) {\n                gridDeleted.push(this.prepareRowForGrid(\n                    _.findWhere(this.variationsComponent().variations, {\n                        productId: productId\n                    })\n                ));\n            }.bind(this));\n\n            this.variationsExisting = gridExisting;\n            this.variationsNew = gridNew;\n            this.variationsDeleted = gridDeleted;\n        },\n\n        /**\n         * Generate grid.\n         */\n        generateGrid: function () {\n            var pageExisting = this.pagingExisting.pageSize * this.pagingExisting.current,\n                pageNew = this.pagingNew.pageSize * this.pagingNew.current,\n                pageDeleted = this.pagingDeleted.pageSize * this.pagingDeleted.current;\n\n            this.pagingExisting.totalRecords = this.variationsExisting.length;\n            this.gridExisting(this.variationsExisting.slice(pageExisting - this.pagingExisting.pageSize, pageExisting));\n\n            this.pagingNew.totalRecords = this.variationsNew.length;\n            this.gridNew(this.variationsNew.slice(pageNew - this.pagingNew.pageSize, pageNew));\n\n            this.pagingDeleted.totalRecords = this.variationsDeleted.length;\n            this.gridDeleted(this.variationsDeleted.slice(pageDeleted - this.pagingDeleted.pageSize, pageDeleted));\n        },\n\n        /**\n         * @param {Object} variation\n         * @return {Array}\n         */\n        prepareRowForGrid: function (variation) {\n            var row = [];\n\n            row.push(_.extend({\n                images: []\n            }, variation.images));\n            row.push(variation.sku);\n            row.push(variation[this.quantityFieldName]);\n            _.each(variation.options, function (option) {\n                row.push(option.label);\n            });\n            row.push(this.variationsComponent().getCurrencySymbol() +  ' ' + variation.price);\n\n            return row;\n        },\n\n        /**\n         * @return {String|*}\n         */\n        getGridTemplate: function () {\n            return this.gridTemplate;\n        },\n\n        /**\n         * @return {*|String}\n         */\n        getGridId: function () {\n            return _.uniqueId('grid_');\n        },\n\n        /**\n         * @param {*} attributes\n         * @return {Array}\n         */\n        getColumnsName: function (attributes) {\n            var columns = this.attributesName.slice(0);\n\n            attributes.each(function (attribute, index) {\n                columns.splice(3 + index, 0, attribute.label);\n            }, this);\n\n            return columns;\n        },\n\n        /**\n         * @param {Object} wizard\n         */\n        render: function (wizard) {\n            this.wizard = wizard;\n            this.sections(wizard.data.sections());\n            this.attributes(wizard.data.attributes());\n            this.gridNew([]);\n            this.gridExisting([]);\n            this.gridDeleted([]);\n            this.gridExisting.columns(this.getColumnsName(this.wizard.data.attributes));\n            this.gridNew.columns(this.getColumnsName(this.wizard.data.attributes));\n            this.gridDeleted.columns(this.getColumnsName(this.variationsComponent().productAttributes));\n            this.calculate(wizard.data.variations, wizard.data.sectionHelper);\n            this.generateGrid();\n        },\n\n        /**\n         * Force.\n         */\n        force: function () {\n            this.variationsComponent().render(this.variations, this.attributes());\n            this.modalComponent().closeModal();\n        },\n\n        /**\n         * Back.\n         */\n        back: function () {\n        }\n    });\n});\n","Magento_CurrencySymbol/js/symbols-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'mage/mage'\n], function ($) {\n    'use strict';\n\n    return function (config, element) {\n        $(element)\n            .mage('form')\n            .mage('validation');\n\n        /**\n         * Toggle the field to use the default value\n         *\n         * @param {String} code\n         * @param {String} value\n         */\n        function toggleUseDefault(code, value) {\n            var checkbox = $('#custom_currency_symbol_inherit' + code),\n                input = $('#custom_currency_symbol' + code);\n\n            if (checkbox.is(':checked')) {\n                input.val(value);\n                input.prop('disabled', true);\n            } else {\n                input.prop('disabled', false);\n            }\n        }\n\n        window.toggleUseDefault = toggleUseDefault;\n    };\n});\n","Magento_Customer/edit/post-wrapper.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/confirm',\n    'mage/translate'\n], function ($, confirm) {\n    'use strict';\n\n    /**\n     * @param {String} url\n     * @returns {Object}\n     */\n    function getForm(url) {\n        return $('<form>', {\n            'action': url,\n            'method': 'POST'\n        }).append($('<input>', {\n            'name': 'form_key',\n            'value': window.FORM_KEY,\n            'type': 'hidden'\n        }));\n    }\n\n    $('#customer-edit-delete-button').on('click', function () {\n        var msg = $.mage.__('Are you sure you want to do this?'),\n            url = $('#customer-edit-delete-button').data('url');\n\n        confirm({\n            'content': msg,\n            'actions': {\n\n                /**\n                 * 'Confirm' action handler.\n                 */\n                confirm: function () {\n                    getForm(url).appendTo('body').submit();\n                }\n            }\n        });\n\n        return false;\n    });\n});\n","Magento_Customer/js/address/default-address.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/button',\n    'underscore'\n], function (Button, _) {\n    'use strict';\n\n    return Button.extend({\n        defaults: {\n            entityId: null,\n            parentId: null,\n            listens: {\n                entity: 'changeVisibility'\n            }\n        },\n\n        /**\n         * Apply action on target component,\n         * but previously create this component from template if it is not existed\n         *\n         * @param {Object} action - action configuration\n         */\n        applyAction: function (action) {\n            if (action.params && action.params[0]) {\n                action.params[0]['entity_id'] = this.entityId;\n                action.params[0]['parent_id'] = this.parentId;\n            } else {\n                action.params = [{\n                    'entity_id': this.entityId,\n                    'parent_id': this.parentId\n                }];\n            }\n\n            this._super();\n        },\n\n        /**\n         * Change visibility of the default address shipping/billing blocks\n         *\n         * @param {Object} entity - customer address\n         */\n        changeVisibility: function (entity) {\n            this.visible(!_.isEmpty(entity));\n        }\n    });\n});\n","Magento_Customer/js/bootstrap/customer-post-action.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\nrequire([\n    'Magento_Customer/edit/post-wrapper'\n]);\n","Magento_Customer/js/form/components/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Ui/js/form/form',\n    'underscore',\n    'mage/translate'\n], function ($, uiAlert, uiConfirm, Form, _, $t) {\n    'use strict';\n\n    return Form.extend({\n        defaults: {\n            deleteConfirmationMessage: '',\n            ajaxSettings: {\n                method: 'POST',\n                dataType: 'json'\n            }\n        },\n\n        /**\n         * Delete customer address by provided url.\n         * Will call confirmation message to be sure that user is really wants to delete this address\n         *\n         * @param {String} url - ajax url\n         */\n        deleteAddress: function (url) {\n            var that = this;\n\n            uiConfirm({\n                content: this.deleteConfirmationMessage,\n                actions: {\n                    /** @inheritdoc */\n                    confirm: function () {\n                        that._delete(url);\n                    }\n                }\n            });\n        },\n\n        /**\n         * Perform asynchronous DELETE request to server.\n         * @param {String} url - ajax url\n         * @returns {Deferred}\n         */\n        _delete: function (url) {\n            var settings = _.extend({}, this.ajaxSettings, {\n                    url: url,\n                    data: {\n                        'form_key': window.FORM_KEY\n                    }\n                }),\n                that = this;\n\n            $('body').trigger('processStart');\n\n            return $.ajax(settings)\n                .done(function (response) {\n                    if (response.error) {\n                        uiAlert({\n                            content: response.message\n                        });\n                    } else {\n                        that.trigger('deleteAddressAction', that.source.get('data.entity_id'));\n                    }\n                })\n                .fail(function () {\n                    uiAlert({\n                        content: $t('Sorry, there has been an error processing your request. Please try again later.')\n                    });\n                })\n                .always(function () {\n                    $('body').trigger('processStop');\n                });\n\n        }\n    });\n});\n","Magento_Customer/js/form/components/insert-form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-form'\n], function (Insert) {\n    'use strict';\n\n    return Insert.extend({\n        defaults: {\n            listens: {\n                responseData: 'onResponse'\n            },\n            modules: {\n                addressListing: '${ $.addressListingProvider }',\n                addressModal: '${ $.addressModalProvider }'\n            }\n        },\n\n        /**\n         * Close modal, reload customer address listing and save customer address\n         *\n         * @param {Object} responseData\n         */\n        onResponse: function (responseData) {\n            var data;\n\n            if (!responseData.error) {\n                this.addressModal().closeModal();\n                this.addressListing().reload({\n                    refresh: true\n                });\n                data = this.externalSource().get('data');\n                this.saveAddress(responseData, data);\n            }\n        },\n\n        /**\n         * Save customer address to customer form data source\n         *\n         * @param {Object} responseData\n         * @param {Object} data - customer address\n         */\n        saveAddress: function (responseData, data) {\n            data['entity_id'] = responseData.data['entity_id'];\n\n            if (parseFloat(data['default_billing'])) {\n                this.source.set('data.default_billing_address', data);\n            } else if (\n                parseFloat(this.source.get('data.default_billing_address')['entity_id']) === data['entity_id']\n            ) {\n                this.source.set('data.default_billing_address', []);\n            }\n\n            if (parseFloat(data['default_shipping'])) {\n                this.source.set('data.default_shipping_address', data);\n            } else if (\n                parseFloat(this.source.get('data.default_shipping_address')['entity_id']) === data['entity_id']\n            ) {\n                this.source.set('data.default_shipping_address', []);\n            }\n        },\n\n        /**\n         * Event method that closes \"Edit customer address\" modal and refreshes grid after customer address\n         * was removed through \"Delete\" button on the \"Edit customer address\" modal\n         *\n         * @param {String} id - customer address ID to delete\n         */\n        onAddressDelete: function (id) {\n            this.addressModal().closeModal();\n            this.addressListing().reload({\n                refresh: true\n            });\n            this.addressListing()._delete([parseFloat(id)]);\n        }\n    });\n});\n","Magento_Customer/js/form/components/insert-listing.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/insert-listing',\n    'underscore'\n], function (Insert, _) {\n    'use strict';\n\n    return Insert.extend({\n\n        /**\n         * On action call\n         *\n         * @param {Object} data - customer address and actions\n         */\n        onAction: function (data) {\n            this[data.action + 'Action'].call(this, data.data);\n        },\n\n        /**\n         * On mass action call\n         *\n         * @param {Object} data - customer address\n         */\n        onMassAction: function (data) {\n            this[data.action + 'Massaction'].call(this, data.data);\n        },\n\n        /**\n         * Set default billing address\n         *\n         * @param {Object} data - customer address\n         */\n        setDefaultBillingAction: function (data) {\n            this.source.set('data.default_billing_address', data);\n        },\n\n        /**\n         * Set default shipping address\n         *\n         * @param {Object} data - customer address\n         */\n        setDefaultShippingAction: function (data) {\n            this.source.set('data.default_shipping_address', data);\n        },\n\n        /**\n         * Delete customer address\n         *\n         * @param {Object} data - customer address\n         */\n        deleteAction: function (data) {\n            this._delete([parseFloat(data[data['id_field_name']])]);\n        },\n\n        /**\n         * Mass action delete\n         *\n         * @param {Object} data - customer address\n         */\n        deleteMassaction: function (data) {\n            var ids = data.selected || this.selections().selected();\n\n            ids = _.map(ids, function (val) {\n                return parseFloat(val);\n            });\n\n            this._delete(ids);\n        },\n\n        /**\n         * Delete customer address and selections by provided ids.\n         *\n         * @param {Array} ids\n         */\n        _delete: function (ids) {\n            var defaultShippingId = parseFloat(this.source.get('data.default_shipping_address.entity_id')),\n                defaultBillingId = parseFloat(this.source.get('data.default_billing_address.entity_id'));\n\n            if (ids.indexOf(defaultShippingId) !== -1) {\n                this.source.set('data.default_shipping_address', []);\n            }\n\n            if (ids.indexOf(defaultBillingId) !== -1) {\n                this.source.set('data.default_billing_address', []);\n            }\n\n            _.each(ids, function (id) {\n                this.selections().deselect(id.toString(), false);\n            }, this);\n        }\n    });\n});\n","Magento_Customer/js/form/element/country.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/country'\n], function (Country) {\n    'use strict';\n\n    return Country.extend({\n        defaults: {\n            countryScope: 'data.country'\n        },\n\n        /**\n         * Set country to customer address form\n         *\n         * @param {String} value - country\n         */\n        setDifferedFromDefault: function (value) {\n            this._super();\n\n            if (value) {\n                this.source.set(this.countryScope, this.indexedOptions[value].label);\n            }\n        }\n    });\n});\n","Magento_Customer/js/form/element/region.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/region'\n], function (Region) {\n    'use strict';\n\n    return Region.extend({\n        defaults: {\n            regionScope: 'data.region'\n        },\n\n        /**\n         * Set region to customer address form\n         *\n         * @param {String} value - region\n         */\n        setDifferedFromDefault: function (value) {\n            this._super();\n\n            if (parseFloat(value)) {\n                this.source.set(this.regionScope, this.indexedOptions[value].label);\n            }\n        }\n    });\n});\n","Magento_Customer/js/form/element/website.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/website',\n    'uiRegistry'\n], function (Website, registry) {\n    'use strict';\n\n    return Website.extend({\n        /**\n         * On value change handler.\n         *\n         * @param {String} value\n         */\n        onUpdate: function (value) {\n            var groupIdFieldKey = 'group_id',\n                sendEmailStoreIdFieldKey = 'sendemail_store_id',\n                groupId = registry.get('index = ' + groupIdFieldKey),\n                sendEmailStoreId = registry.get('index = ' + sendEmailStoreIdFieldKey),\n                option = this.getOption(value);\n\n            if (groupId) {\n                groupId.value(option[groupIdFieldKey]);\n            }\n\n            if (sendEmailStoreId && option['default_store_view_id']) {\n                sendEmailStoreId.value(option['default_store_view_id']);\n            }\n            return this._super();\n        }\n    });\n});\n","Magento_Customer/js/grid/massactions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/massactions',\n    'Magento_Ui/js/modal/alert',\n    'underscore',\n    'jquery',\n    'mage/translate'\n], function (Massactions, uiAlert, _, $, $t) {\n    'use strict';\n\n    return Massactions.extend({\n        defaults: {\n            ajaxSettings: {\n                method: 'POST',\n                dataType: 'json'\n            },\n            listens: {\n                massaction: 'onAction'\n            }\n        },\n\n        /**\n         * Reload customer addresses listing\n         *\n         * @param {Object} data\n         */\n        onAction: function (data) {\n            if (data.action === 'delete') {\n                this.source.reload({\n                    refresh: true\n                });\n            }\n        },\n\n        /**\n         * Default action callback. Send selections data\n         * via POST request.\n         *\n         * @param {Object} action - Action data.\n         * @param {Object} data - Selections data.\n         */\n        defaultCallback: function (action, data) {\n            var itemsType, selections;\n\n            if (action.isAjax) {\n                itemsType = data.excludeMode ? 'excluded' : 'selected';\n                selections = {};\n\n                selections[itemsType] = data[itemsType];\n\n                if (!selections[itemsType].length) {\n                    selections[itemsType] = false;\n                }\n\n                _.extend(selections, data.params || {});\n\n                this.request(action.url, selections).done(function (response) {\n                    if (!response.error) {\n                        this.trigger('massaction', {\n                            action: action.type,\n                            data: selections\n                        });\n                    }\n                }.bind(this));\n            } else {\n                this._super();\n            }\n        },\n\n        /**\n         * Send customer address listing mass action ajax request\n         *\n         * @param {String} href\n         * @param {Object} data\n         */\n        request: function (href, data) {\n            var settings = _.extend({}, this.ajaxSettings, {\n                url: href,\n                data: data\n            });\n\n            $('body').trigger('processStart');\n\n            return $.ajax(settings)\n                .done(function (response) {\n                    if (response.error) {\n                        uiAlert({\n                            content: response.message\n                        });\n                    }\n                })\n                .fail(function () {\n                    uiAlert({\n                        content: $t('Sorry, there has been an error processing your request. Please try again later.')\n                    });\n                })\n                .always(function () {\n                    $('body').trigger('processStop');\n                });\n        }\n    });\n});\n","Magento_Customer/js/grid/columns/actions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/columns/actions',\n    'Magento_Ui/js/modal/alert',\n    'underscore',\n    'jquery',\n    'mage/translate'\n], function (Actions, uiAlert, _, $, $t) {\n    'use strict';\n\n    return Actions.extend({\n        defaults: {\n            ajaxSettings: {\n                method: 'POST',\n                dataType: 'json'\n            },\n            listens: {\n                action: 'onAction'\n            },\n            ignoreTmpls: {\n                fieldAction: true,\n                options: true,\n                action: true\n            }\n        },\n\n        /**\n         * Reload customer address listing data source after customer address delete action\n         *\n         * @param {Object} data\n         */\n        onAction: function (data) {\n            if (data.action === 'delete') {\n                this.source().reload({\n                    refresh: true\n                });\n            }\n        },\n\n        /**\n         * Default action callback. Redirects to\n         * the specified in action's data url.\n         *\n         * @param {String} actionIndex - Action's identifier.\n         * @param {(Number|String)} recordId - Id of the record associated\n         *      with a specified action.\n         * @param {Object} action - Action's data.\n         */\n        defaultCallback: function (actionIndex, recordId, action) {\n            if (action.isAjax) {\n                this.request(action.href).done(function (response) {\n                    var data;\n\n                    if (!response.error) {\n                        data = _.findWhere(this.rows, {\n                            _rowIndex: action.rowIndex\n                        });\n\n                        this.trigger('action', {\n                            action: actionIndex,\n                            data: data\n                        });\n                    }\n                }.bind(this));\n\n            } else {\n                this._super();\n            }\n        },\n\n        /**\n         * Send customer address listing ajax request\n         *\n         * @param {String} href\n         */\n        request: function (href) {\n            var settings = _.extend({}, this.ajaxSettings, {\n                url: href,\n                data: {\n                    'form_key': window.FORM_KEY\n                }\n            });\n\n            $('body').trigger('processStart');\n\n            return $.ajax(settings)\n                .done(function (response) {\n                    if (response.error) {\n                        uiAlert({\n                            content: response.message\n                        });\n                    }\n                })\n                .fail(function () {\n                    uiAlert({\n                        content: $t('Sorry, there has been an error processing your request. Please try again later.')\n                    });\n                })\n                .always(function () {\n                    $('body').trigger('processStop');\n                });\n        }\n    });\n});\n","Magento_Customer/js/grid/filters/chips.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/filters/chips'\n], function (Chips) {\n    'use strict';\n\n    return Chips.extend({\n\n        /**\n         * Clear previous filters while initializing element to prevent filters sharing between customers\n         *\n         * @param {Object} elem\n         */\n        initElement: function (elem) {\n            this.clear();\n            this._super(elem);\n        }\n    });\n});\n","Magento_Customer/js/grid/filters/filters.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/filters/filters'\n], function (Filters) {\n    'use strict';\n\n    return Filters.extend({\n        defaults: {\n            chipsConfig: {\n                name: '${ $.name }_chips',\n                provider: '${ $.chipsConfig.name }',\n                component: 'Magento_Customer/js/grid/filters/chips'\n            }\n        }\n    });\n});\n","Magento_Downloadable/downloadable-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Catalog/js/product/weight-handler',\n    'Magento_Catalog/catalog/type-events'\n], function ($, weight, productType) {\n    'use strict';\n\n    return {\n        $checkbox: $('[data-action=change-type-product-downloadable]'),\n        $items: $('#product_info_tabs_downloadable_items'),\n        $tab: null,\n        isDownloadable: false,\n\n        /**\n         * Show\n         */\n        show: function () {\n            this.$checkbox.prop('checked', true);\n            this.$items.show();\n        },\n\n        /**\n         * Hide\n         */\n        hide: function () {\n            this.$checkbox.prop('checked', false);\n            this.$items.hide();\n        },\n\n        /**\n         * Constructor component\n         * @param {Object} data - this backend data\n         */\n        'Magento_Downloadable/downloadable-type-handler': function (data) {\n            this.$tab = $('[data-tab=' + data.tabId + ']');\n            this.isDownloadable = data.isDownloadable;\n            this.bindAll();\n            this._initType();\n        },\n\n        /**\n         * Bind all\n         */\n        bindAll: function () {\n            this.$checkbox.on('change', function (event) {\n                $(document).trigger('setTypeProduct', $(event.target).prop('checked') ?\n                    'downloadable' :\n                    productType.type.init === 'downloadable' ? 'virtual' : productType.type.init\n                );\n            });\n\n            $(document).on('changeTypeProduct', this._initType.bind(this));\n        },\n\n        /**\n         * Init type\n         * @private\n         */\n        _initType: function () {\n            if (productType.type.current === 'downloadable') {\n                weight.change(false);\n                weight.$weightSwitcher().one('change', function () {\n                    $(document).trigger(\n                        'setTypeProduct',\n                        productType.type.init === 'downloadable' ? 'virtual' : productType.type.init\n                    );\n                });\n                this.show();\n            } else {\n                this.hide();\n            }\n        }\n    };\n});\n","Magento_Downloadable/js/components/file-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/file-uploader'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            fileInputName: ''\n        },\n\n        /**\n         * Adds provided file to the files list.\n         *\n         * @param {Object} file\n         * @returns {FileUploder} Chainable.\n         */\n        addFile: function (file) {\n            var processedFile = this.processFile(file),\n                tmpFile = [],\n                resultFile = {\n                'file': processedFile.file,\n                'name': processedFile.name,\n                'size': processedFile.size,\n                'status': processedFile.status ? processedFile.status : 'new'\n            };\n\n            tmpFile[0] = resultFile;\n\n            this.isMultipleFiles ?\n                this.value.push(tmpFile) :\n                this.value(tmpFile);\n\n            return this;\n        }\n    });\n});\n","Magento_Downloadable/js/components/is-downloadable-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            listens: {\n                disabled: 'changeVisibility'\n            },\n            modules: {\n                samplesFieldset: '${ $.samplesFieldset }',\n                linksFieldset: '${ $.linksFieldset}'\n            }\n        },\n\n        /**\n         * Change visibility for samplesFieldset & linksFieldset based on current statuses of checkbox.\n         */\n        changeVisibility: function () {\n            if (this.samplesFieldset() && this.linksFieldset()) {\n                if (this.checked() && !this.disabled()) {\n                    this.samplesFieldset().visible(true);\n                    this.linksFieldset().visible(true);\n                } else {\n                    this.samplesFieldset().visible(false);\n                    this.linksFieldset().visible(false);\n                }\n            }\n        },\n\n        /**\n         * Handle checked state changes for checkbox / radio button.\n         *\n         * @param {Boolean} newChecked\n         */\n        onCheckedChanged: function (newChecked) {\n            this.changeVisibility();\n            this._super(newChecked);\n        }\n    });\n});\n","Magento_Downloadable/js/components/price-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            linksPurchasedSeparately: '0',\n            useDefaultPrice: false,\n            listens: {\n                linksPurchasedSeparately: 'changeDisabledStatus',\n                useDefaultPrice: 'changeDisabledStatus'\n            }\n        },\n\n        /**\n         * Invokes initialize method of parent class,\n         * contains initialization logic\n         */\n        initialize: function () {\n            this._super();\n            this.changeDisabledStatus();\n\n            return this;\n        },\n\n        /**\n         * Disable/enable price field\n         */\n        changeDisabledStatus: function () {\n            if (this.linksPurchasedSeparately === '1') {\n                if (this.useDefaultPrice) {\n                    this.disabled(true);\n                } else {\n                    this.disabled(false);\n                }\n            } else {\n                this.disabled(true);\n            }\n        }\n    });\n});\n","Magento_Downloadable/js/components/upload-type-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/select',\n    'uiRegistry'\n], function (Select, registry) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            listens: {\n                value: 'changeTypeUpload'\n            },\n            typeUrl: 'file',\n            typeFile: 'link_url',\n            filterPlaceholder: 'ns = ${ $.ns }, parentScope = ${ $.parentScope }'\n        },\n\n        /**\n         * Initialize component.\n         * @returns {Element}\n         */\n        initialize: function () {\n            return this\n                ._super()\n                .changeTypeUpload(this.initialValue);\n        },\n\n        /**\n         * Callback that fires when 'value' property is updated.\n         *\n         * @param {String} currentValue\n         * @returns {*}\n         */\n        onUpdate: function (currentValue) {\n            this.changeTypeUpload(currentValue);\n\n            return this._super();\n        },\n\n        /**\n         * Change visibility for typeUrl/typeFile based on current value.\n         *\n         * @param {String} currentValue\n         */\n        changeTypeUpload: function (currentValue) {\n            var componentFile = this.filterPlaceholder + ', index=' + this.typeFile,\n                componentUrl = this.filterPlaceholder + ', index=' + this.typeUrl;\n\n            switch (currentValue) {\n\n                case 'file':\n                    this.changeVisible(componentFile, true);\n                    this.changeVisible(componentUrl, false);\n                    break;\n\n                case 'url':\n                    this.changeVisible(componentFile, false);\n                    this.changeVisible(componentUrl, true);\n                    break;\n            }\n        },\n\n        /**\n         * Change visible\n         *\n         * @param {String} filter\n         * @param {Boolean} visible\n         */\n        changeVisible: function (filter, visible) {\n            registry.async(filter)(\n                function (currentComponent) {\n                    currentComponent.visible(visible);\n                }\n            );\n        }\n    });\n});\n","Magento_Downloadable/js/components/use-price-default-handler.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            linksPurchasedSeparately: '0',\n            listens: {\n                linksPurchasedSeparately: 'changeVisibleStatus'\n            }\n        },\n\n        /**\n         * Change visibility of checkbox\n         */\n        changeVisibleStatus: function () {\n            if (this.linksPurchasedSeparately === '1') {\n                this.visible(true);\n            } else {\n                this.visible(false);\n            }\n        }\n    });\n});\n","Magento_Eav/js/input-types.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/translate'\n], function ($) {\n    'use strict';\n\n    return function (config) {\n        $('select#frontend_input').each(function () {\n            var select = $(this),\n                currentValue = select.find('option:selected').val(),\n                compatibleTypes = config.inputTypes,\n                enabledTypes = [],\n                iterator,\n                warning = $('<label>')\n                    .hide()\n                    .text($.mage.__('These changes affect all related products.'))\n                    .addClass('mage-error')\n                    .attr({\n                        generated: true, for: select.attr('id')\n                    }),\n                hint = $('<p>')\n                    .hide()\n                    .addClass('note')\n                    .attr({\n                        generated: true\n                    }),\n                hints = config.hints,\n\n            /**\n             * Toggle hint about changes types\n             */\n            toggleWarning = function () {\n                if (select.find('option:selected').val() === currentValue) {\n                    warning.hide();\n                } else {\n                    warning.show();\n                }\n            },\n\n            /**\n             * Toggle hint\n             */\n            toggleHint = function () {\n                if (typeof hints[select.find('option:selected').val()] !== 'undefined') {\n                    select.after(hint.show().text(hints[select.find('option:selected').val()]));\n                } else {\n                    hint.hide();\n                }\n            },\n\n            /**\n             * Remove unsupported options\n             */\n            removeOption = function () {\n                if (!~enabledTypes.indexOf($(this).val())) {\n                    $(this).remove();\n                }\n            };\n\n            // find enabled types for switching dor current input type\n            for (iterator = 0; iterator < compatibleTypes.length; iterator++) {\n                if (compatibleTypes[iterator].indexOf(currentValue) >= 0) {\n                    enabledTypes = compatibleTypes[iterator];\n                }\n            }\n\n            // Check current type (allow only compatible types)\n            if (~enabledTypes.indexOf(currentValue)) {\n                // Enable select and keep only available options (all other will be removed)\n                select.prop('disabled', false).find('option').each(removeOption);\n                // Add warning on page and event for show/hide it\n                select.after(warning).on('change', toggleWarning);\n            }\n            //bind hint toggling on change event\n            select.on('change', toggleHint);\n            //show hint for currently selected value\n            toggleHint();\n        });\n    };\n});\n","Magento_Email/js/variables.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global Variables, updateElementAtCursor */\ndefine([\n    'jquery',\n    'mage/translate',\n    'Magento_Ui/js/modal/modal',\n    'jquery/ui',\n    'prototype'\n], function (jQuery, $t) {\n    'use strict';\n\n    window.Variables = {\n        textareaElementId: null,\n        variablesContent: null,\n        dialogWindow: null,\n        dialogWindowId: 'variables-chooser',\n        overlayShowEffectOptions: null,\n        overlayHideEffectOptions: null,\n        insertFunction: 'Variables.insertVariable',\n        variablesValue: [],\n\n        /**\n         * @param {*} textareaElementId\n         * @param {Function} insertFunction\n         */\n        init: function (textareaElementId, insertFunction) {\n            if ($(textareaElementId)) {\n                this.textareaElementId = textareaElementId;\n            }\n\n            if (insertFunction) {\n                this.insertFunction = insertFunction;\n            }\n        },\n\n        /**\n         * reset data.\n         */\n        resetData: function () {\n            this.variablesContent = null;\n            this.dialogWindow = null;\n        },\n\n        /**\n         * @param {Object} variables\n         */\n        openVariableChooser: function (variables) {\n            if (this.variablesContent == null && variables) {\n                this.variablesContent = '<ul class=\"insert-variable\">';\n                variables.each(function (variableGroup) {\n                    if (variableGroup.label && variableGroup.value) {\n                        this.variablesContent += '<li><b>' + variableGroup.label.escapeHTML() + '</b></li>';\n                        variableGroup.value.each(function (variable) {\n                            if (variable.value && variable.label) {\n                                this.variablesValue.push(variable.value);\n                                this.variablesContent += '<li>' +\n                                    this.prepareVariableRow(this.variablesValue.length, variable.label) + '</li>';\n                            }\n                        }.bind(this));\n                    }\n                }.bind(this));\n                this.variablesContent += '</ul>';\n            }\n\n            if (this.variablesContent) {\n                this.openDialogWindow(this.variablesContent);\n            }\n        },\n\n        /**\n         * @param {*} variablesContent\n         */\n        openDialogWindow: function (variablesContent) {\n            var windowId = this.dialogWindowId;\n\n            jQuery('<div id=\"' + windowId + '\">' + variablesContent + '</div>').modal({\n                title: $t('Insert Variable...'),\n                type: 'slide',\n                buttons: [],\n\n                /** @inheritdoc */\n                closed: function (e, modal) {\n                    modal.modal.remove();\n                }\n            });\n\n            jQuery('#' + windowId).modal('openModal');\n        },\n\n        /**\n         * Close dialog window.\n         */\n        closeDialogWindow: function () {\n            jQuery('#' + this.dialogWindowId).modal('closeModal');\n        },\n\n        /**\n         * @param {Number} index\n         * @param {*} varLabel\n         * @return {String}\n         */\n        prepareVariableRow: function (index, varLabel) {\n            return '<a href=\"#\" onclick=\"' +\n                this.insertFunction +\n                '(' +\n                index +\n                ');return false;\">' +\n                varLabel.escapeHTML() +\n                '</a>';\n        },\n\n        /**\n         * @param {*} variable\n         */\n        insertVariable: function (variable) {\n            var windowId = this.dialogWindowId,\n                textareaElm, scrollPos;\n\n            jQuery('#' + windowId).modal('closeModal');\n            textareaElm = $(this.textareaElementId);\n\n            if (textareaElm) {\n                scrollPos = textareaElm.scrollTop;\n\n                if (!isNaN(variable)) {\n                    updateElementAtCursor(textareaElm, Variables.variablesValue[variable - 1]);\n                } else {\n                    updateElementAtCursor(textareaElm, variable);\n                }\n                textareaElm.focus();\n                textareaElm.scrollTop = scrollPos;\n                jQuery(textareaElm).trigger('change');\n                textareaElm = null;\n            }\n        }\n    };\n\n    window.MagentovariablePlugin = {\n        editor: null,\n        variables: null,\n        textareaId: null,\n\n        /**\n         * @param {*} editor\n         */\n        setEditor: function (editor) {\n            this.editor = editor;\n        },\n\n        /**\n         * @param {String} url\n         * @param {*} textareaId\n         */\n        loadChooser: function (url, textareaId) {\n            this.textareaId = textareaId;\n\n            if (this.variables == null) {\n                new Ajax.Request(url, {\n                    parameters: {},\n                    onComplete: function (transport) {\n                        if (transport.responseText.isJSON()) {\n                            Variables.init(null, 'MagentovariablePlugin.insertVariable');\n                            this.variables = transport.responseText.evalJSON();\n                            this.openChooser(this.variables);\n                        }\n                    }.bind(this)\n                });\n            } else {\n                this.openChooser(this.variables);\n            }\n        },\n\n        /**\n         * @param {*} variables\n         */\n        openChooser: function (variables) {\n            Variables.openVariableChooser(variables);\n        },\n\n        /**\n         * @param {*} value\n         */\n        insertVariable: function (value) {\n            if (this.textareaId) {\n                Variables.init(this.textareaId);\n                Variables.insertVariable(value);\n            } else {\n                Variables.closeDialogWindow();\n                this.editor.execCommand('mceInsertContent', false, value);\n            }\n        }\n    };\n});\n","Magento_GroupedProduct/js/grouped-product-grid.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows-grid'\n], function (_, registry, dynamicRowsGrid) {\n    'use strict';\n\n    return dynamicRowsGrid.extend({\n\n        /**\n         * Set max element position\n         *\n         * @param {Number} position - element position\n         * @param {Object} elem - instance\n         */\n        setMaxPosition: function (position, elem) {\n\n            if (position || position === 0) {\n                this.checkMaxPosition(position);\n                this.sort(position, elem);\n\n                if (~~position === this.maxPosition && ~~position > this.getDefaultPageBoundary() + 1) {\n                    this.shiftNextPagesPositions(position);\n                }\n            } else {\n                this.maxPosition += 1;\n            }\n        },\n\n        /**\n         * Shift positions for next page elements\n         *\n         * @param {Number} position\n         */\n        shiftNextPagesPositions: function (position) {\n\n            var recordData = this.recordData(),\n                startIndex = ~~this.currentPage() * this.pageSize,\n                offset = position - startIndex + 1,\n                index = startIndex;\n\n            if (~~this.currentPage() === this.pages()) {\n                return false;\n            }\n\n            for (index; index < recordData.length; index++) {\n                recordData[index].position = index + offset;\n            }\n            this.recordData(recordData);\n        },\n\n        /**\n         * Update position for element after position from another page is entered\n         *\n         * @param {Object} data\n         * @param {Object} event\n         */\n        updateGridPosition: function (data, event) {\n            var inputValue = parseInt(event.target.value, 10),\n                recordData = this.recordData(),\n                record,\n                previousValue,\n                updatedRecord;\n\n            record = this.elems().find(function (obj) {\n                return obj.dataScope === data.parentScope;\n            });\n\n            previousValue = this.getCalculatedPosition(record);\n\n            if (isNaN(inputValue) || inputValue < 0 || inputValue === previousValue) {\n                return false;\n            }\n\n            this.elems([]);\n\n            updatedRecord = this.getUpdatedRecordIndex(recordData, record.data().id);\n\n            if (inputValue >= this.recordData().size() - 1) {\n                recordData[updatedRecord].position = this.getGlobalMaxPosition() + 1;\n            } else {\n                recordData.forEach(function (value, index) {\n                    if (~~value.id === ~~record.data().id) {\n                        recordData[index].position = inputValue;\n                    } else if (inputValue > previousValue && index <= inputValue) {\n                        recordData[index].position = index - 1;\n                    } else if (inputValue < previousValue && index >= inputValue) {\n                        recordData[index].position = index + 1;\n                    }\n                });\n            }\n\n            this.reloadGridData(recordData);\n\n        },\n\n        /**\n         * Get updated record index\n         *\n         * @param  {Array} recordData\n         * @param {Number} recordId\n         * @return {Number}\n         */\n        getUpdatedRecordIndex: function (recordData, recordId) {\n            return recordData.map(function (o) {\n                return ~~o.id;\n            }).indexOf(~~recordId);\n        },\n\n        /**\n         *\n         * @param {Array} recordData - to reprocess\n         */\n        reloadGridData: function (recordData) {\n            this.recordData(recordData.sort(function (a, b) {\n                return ~~a.position - ~~b.position;\n            }));\n            this._updateCollection();\n            this.reload();\n        },\n\n        /**\n         * Event handler for \"Send to bottom\" button\n         *\n         * @param {Object} positionObj\n         * @return {Boolean}\n         */\n        sendToBottom: function (positionObj) {\n\n            var objectToUpdate = this.getObjectToUpdate(positionObj),\n                recordData = this.recordData(),\n                updatedRecord;\n\n            if (~~this.currentPage() === this.pages) {\n                objectToUpdate.position = this.maxPosition;\n            } else {\n                this.elems([]);\n                updatedRecord = this.getUpdatedRecordIndex(recordData, objectToUpdate.data().id);\n                recordData[updatedRecord].position = this.getGlobalMaxPosition() + 1;\n                this.reloadGridData(recordData);\n            }\n\n            return false;\n        },\n\n        /**\n         * Event handler for \"Send to top\" button\n         *\n         * @param {Object} positionObj\n         * @return {Boolean}\n         */\n        sendToTop: function (positionObj) {\n            var objectToUpdate = this.getObjectToUpdate(positionObj),\n                recordData = this.recordData(),\n                updatedRecord;\n\n            //isFirst\n            if (~~this.currentPage() === 1) {\n                objectToUpdate.position = 0;\n            } else {\n                this.elems([]);\n                updatedRecord = this.getUpdatedRecordIndex(recordData, objectToUpdate.data().id);\n                recordData.forEach(function (value, index) {\n                    recordData[index].position = index === updatedRecord ? 0 : value.position + 1;\n                });\n                this.reloadGridData(recordData);\n            }\n\n            return false;\n        },\n\n        /**\n         * Get element from grid for update\n         *\n         * @param {Object} object\n         * @return {*}\n         */\n        getObjectToUpdate: function (object) {\n            return this.elems().filter(function (item) {\n                return item.name === object.parentName;\n            })[0];\n        },\n\n        /**\n         * Value function for position input\n         *\n         * @param {Object} data\n         * @return {Number}\n         */\n        getCalculatedPosition: function (data) {\n            return (~~this.currentPage() - 1) * this.pageSize + this.elems().pluck('name').indexOf(data.name);\n        },\n\n        /**\n         * Return Page Boundary\n         *\n         * @return {Number}\n         */\n        getDefaultPageBoundary: function () {\n            return ~~this.currentPage() * this.pageSize - 1;\n        },\n\n        /**\n         * Returns position for last element to be moved after\n         *\n         * @return {Number}\n         */\n        getGlobalMaxPosition: function () {\n            return _.max(this.recordData().map(function (r) {\n                return ~~r.position;\n            }));\n        }\n    });\n});\n","Magento_GroupedProduct/js/grouped-product.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'jquery',\n    'mage/template',\n    'jquery/ui',\n    'Magento_Ui/js/modal/modal',\n    'mage/translate',\n    'mage/adminhtml/grid'\n], function ($, mageTemplate) {\n    'use strict';\n\n    $.widget('mage.groupedProduct', {\n        /**\n         * Create widget\n         * @private\n         */\n        _create: function () {\n            this.$grid = this.element.find('[data-role=grouped-product-grid]');\n            this.$grid.sortable({\n                distance: 8,\n                items: '[data-role=row]',\n                tolerance: 'pointer',\n                cancel: ':input',\n                update: $.proxy(function () {\n                    this.element.trigger('resort');\n                }, this)\n            });\n\n            this.productTmpl = mageTemplate('#group-product-template');\n\n            $.each(\n                this.$grid.data('products'),\n                $.proxy(function (index, product) {\n                    this._add(null, product);\n                }, this)\n            );\n\n            this._on({\n                'add': '_add',\n                'resort': '_resort',\n                'click [data-column=actions] [data-role=delete]': '_remove'\n            });\n\n            this._bindDialog();\n            this._updateGridVisibility();\n        },\n\n        /**\n         * Add product to grouped grid\n         * @param {EventObject} event\n         * @param {Object} product\n         * @private\n         */\n        _add: function (event, product) {\n            var tmpl,\n                productExists;\n\n            productExists = this.$grid.find('[data-role=id]')\n                .filter(function (index, element) {\n                    return $(element).val() == product.id; //eslint-disable-line eqeqeq\n                }).length;\n\n            if (!productExists) {\n                tmpl = this.productTmpl({\n                    data: product\n                });\n\n                $(tmpl).appendTo(this.$grid.find('tbody'));\n            }\n        },\n\n        /**\n         * Remove product\n         * @param {EventObject} event\n         * @private\n         */\n        _remove: function (event) {\n            $(event.target).closest('[data-role=row]').remove();\n            this.element.trigger('resort');\n            this._updateGridVisibility();\n        },\n\n        /**\n         * Resort products\n         * @private\n         */\n        _resort: function () {\n            this.element.find('[data-role=position]').each($.proxy(function (index, element) {\n                $(element).val(index + 1);\n            }, this));\n        },\n\n        /**\n         * Create modal for show product\n         *\n         * @private\n         */\n        _bindDialog: function () {\n            var widget = this,\n                selectedProductList = {},\n                popup = $('[data-role=add-product-dialog]'),\n                gridPopup;\n\n            popup.modal({\n                type: 'slide',\n                innerScroll: true,\n                title: $.mage.__('Add Products to Group'),\n                modalClass: 'grouped',\n\n                /** @inheritdoc */\n                open: function () {\n                    $(this).addClass('admin__scope-old'); // ToDo UI: remove with old styles removal\n                },\n                buttons: [{\n                    id: 'grouped-product-dialog-apply-button',\n                    text: $.mage.__('Add Selected Products'),\n                    'class': 'action-primary action-add',\n\n                    /** @inheritdoc */\n                    click: function () {\n                        $.each(selectedProductList, function (index, product) {\n                            widget._add(null, product);\n                        });\n                        widget._resort();\n                        widget._updateGridVisibility();\n                        popup.modal('closeModal');\n                    }\n                }]\n            });\n\n            popup.on('click', '[data-role=row]', function (event) {\n                var target = $(event.target);\n\n                if (!target.is('input')) {\n                    target.closest('[data-role=row]')\n                        .find('[data-column=entity_ids] input')\n                        .prop('checked', function (element, value) {\n                            return !value;\n                        })\n                        .trigger('change');\n                }\n            });\n\n            popup.on(\n                'change',\n                '[data-role=row] [data-column=entity_ids] input',\n                $.proxy(function (event) {\n                    var element = $(event.target),\n                        product = {};\n\n                    if (element.is(':checked')) {\n                        product.id = element.val();\n                        product.qty = 0;\n                        element.closest('[data-role=row]').find('[data-column]').each(function (index, el) {\n                            let text = $(el).text();\n\n                            product[$(el).data('column')] = text.trim();\n                        });\n                        selectedProductList[product.id] = product;\n                    } else {\n                        delete selectedProductList[element.val()];\n                    }\n                }, this)\n            );\n\n            gridPopup = $(this.options.gridPopup).data('gridObject');\n\n            $('[data-role=add-product]').on('click', function (event) {\n                event.preventDefault();\n                popup.modal('openModal');\n                gridPopup.reload();\n                selectedProductList = {};\n            });\n\n            $('#' + gridPopup.containerId).on('gridajaxsettings', function (event, ajaxSettings) {\n                var ids = widget.$grid.find('[data-role=id]').map(function (index, element) {\n                    return $(element).val();\n                }).toArray();\n\n                ajaxSettings.data.filter = $.extend(ajaxSettings.data.filter || {}, {\n                    'entity_ids': ids\n                });\n            }).on('gridajax', function (event, ajaxRequest) {\n                ajaxRequest.done(function () {\n                    popup.find('[data-role=row] [data-column=entity_ids] input').each(function (index, element) {\n                        var $element = $(element);\n\n                        $element.prop('checked', !!selectedProductList[$element.val()]);\n                    });\n                });\n            });\n        },\n\n        /**\n         * Show or hide message\n         * @private\n         */\n        _updateGridVisibility: function () {\n            var showGrid = this.element.find('[data-role=id]').length > 0;\n\n            this.element.find('.grid-container').toggle(showGrid);\n            this.element.find('.no-products-message').toggle(!showGrid);\n        }\n    });\n\n    return $.mage.groupedProduct;\n});\n","Magento_Integration/js/integration.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * jQuery plugin is added.\n *\n * @api\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/modal/alert',\n    'jquery/ui',\n    'mage/translate',\n    'Magento_Ui/js/modal/modal'\n], function ($, alert) {\n    'use strict';\n\n    $.widget('mage.integration', {\n        /**\n         * Options common to all instances of this widget.\n         * @type {Object}\n         */\n        options: {\n            /**\n             * URL of the integration grid.\n             * @type {String}\n             */\n            gridUrl: ''\n        },\n\n        /**\n         * Bind event handler for the action when admin clicks \"Save & Activate\" button.\n         * @private\n         */\n        _create: function () {\n            if ($('#save-split-button-activate').length) {\n                // We're on the \"New integration\" page - bind related handler\n                this._form = $('#edit_form');\n                this._form.on('saveAndActivate', $.proxy(this._saveAndActivate, this));\n            }\n        },\n\n        /**\n         * Save new integration, then kick off the activate dialog.\n         * @private\n         */\n        _saveAndActivate: function () {\n            if (this._form.validation && !this._form.validation('isValid')) {\n                return false;\n            }\n\n            $.ajax({\n                url: this._form.prop('action'),\n                type: 'post',\n                data: this._form.serialize(),\n                dataType: 'json',\n                context: this,\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    $('body').trigger('processStart');\n                },\n\n                /** @inheritdoc */\n                success: function (data) {\n                    var integrationName, that;\n\n                    if (data._redirect) {\n                        window.location.href = data._redirect;\n                    } else if (data.integrationId) {\n                        integrationName = $('#integration_properties_name').val();\n                        window.integration.popup.show($('<span>').attr({\n                            'data-row-dialog': 'permissions',\n                            'data-row-id': data.integrationId,\n                            // We do escaping here instead of the place of actual output because _showPopup()\n                            // actually receives dialog window title from couple of places: from here and from the grid.\n                            // The issue is we always should escape values in the grid, so that value is already\n                            // escaped. To avoid double escaping we do it here instead of the output.\n                            'data-row-name': $('<div>').text(integrationName).html(),\n                            'data-row-is-reauthorize': '0',\n                            'data-row-is-token-exchange': data.isTokenExchange\n                        }));\n                        that = this;\n                        $('#integration-popup-container').on('dialogclose', function () {\n                            $('body').trigger('processStart');\n                            window.location.href = that.options.gridUrl;\n\n                            return false;\n                        });\n                    }\n                },\n\n                /** @inheritdoc */\n                error: function (jqXHR, status, error) {\n                    alert({\n                        content: $.mage.__('Sorry, something went wrong. Please try again later.')\n                    });\n                    window.console && console.log(status + ': ' + error + '\\nResponse text:\\n' + jqXHR.responseText);\n                },\n\n                /** @inheritdoc */\n                complete: function () {\n                    $('body').trigger('processStop');\n                }\n            });\n\n            return true;\n        }\n    });\n\n    /**\n     * @param {*} permissionsDialogUrl\n     * @param {*} tokensDialogUrl\n     * @param {*} tokensExchangeUrl\n     * @param {*} gridUrl\n     * @param {*} successCallbackUrl\n     * @return {Object}\n     * @constructor\n     */\n    window.Integration = function (\n        permissionsDialogUrl,\n        tokensDialogUrl,\n        tokensExchangeUrl,\n        gridUrl,\n        successCallbackUrl\n    ) {\n        var url = {\n            permissions: permissionsDialogUrl,\n            tokens: tokensDialogUrl,\n            tokensExchange: tokensExchangeUrl,\n            grid: gridUrl\n        },\n        IdentityLogin = {\n            win: null,\n            strLocation: null,\n            checker: null,\n            isCalledBack: false,\n            //Info popup dialog. Should be hidden when login window is closed\n            jqInfoDialog: $('#integration-popup-container'),\n            successCallbackUrl: successCallbackUrl,\n            Constants: {\n                /*\n                 This interval is set such that it adjusts to the child window closing timeout of 1000 ms. This will\n                 give the checker function enough time to detect if the successCallback has been invoked\n                 */\n                CHECKER_INTERVAL: 500,\n                //Login screen size plus some buffer\n                WIDTH: 680,\n                HEIGHT: 510,\n                // subtract pixels(30) and width(680) from screen width to move popup from extreme left\n                LEFT: screen.width - 680 - 30,\n                // subtract pixels(300) and height(300) from screen height to move from top\n                TOP: screen.height - 510 - 300\n            },\n\n            /**\n             * @param {*} identityCallbackUrl\n             * @param {*} consumerKey\n             * @param {*} jqInfoDialog\n             */\n            invokePopup: function (identityCallbackUrl, consumerKey, jqInfoDialog) {\n                var param;\n\n                // Callback should be invoked only once. Reset callback flag on subsequent invocations.\n                IdentityLogin.isCalledBack = false;\n                IdentityLogin.jqInfoDialog = jqInfoDialog;\n                param = $.param({\n                    'oauth_consumer_key': consumerKey,\n                    'success_call_back': IdentityLogin.successCallbackUrl\n                });\n                IdentityLogin.win = window.open(identityCallbackUrl + '?' + param, '',\n                    'top=' + IdentityLogin.Constants.TOP +\n                        ', left=' + IdentityLogin.Constants.LEFT +\n                        ', width=' + IdentityLogin.Constants.WIDTH +\n                        ', height=' + IdentityLogin.Constants.HEIGHT + ',scrollbars=no');\n\n                if (IdentityLogin.checker != null) {\n                    //Clear any previous check\n                    clearInterval(IdentityLogin.checker);\n                }\n                //Polling to detect url of the child window.\n                IdentityLogin.checker = setInterval(\n                    IdentityLogin.fnCheckLocation, IdentityLogin.Constants.CHECKER_INTERVAL\n                );\n            },\n\n            /**\n             * Function to check the location of the child popup window.\n             * Once detected if the callback is successful, parent window will be reloaded\n             */\n            fnCheckLocation: function () {\n                if (IdentityLogin.win == null) {\n                    return;\n                }\n                // Check to see if the location has changed.\n                try {\n                    //Is the success callback invoked\n                    if (IdentityLogin.win.closed ||\n                        IdentityLogin.win.location.href == IdentityLogin.successCallbackUrl //eslint-disable-line eqeqeq\n                    ) {\n                        //Stop the polling\n                        clearInterval(IdentityLogin.checker);\n                        $('body').trigger('processStart');\n                        //Check for window closed\n                        window.location.href = url.grid;\n                        IdentityLogin.jqInfoDialog.modal('closeModal');\n                    }\n                } catch (e) {\n                    //squash. In case Window closed without success callback, clear polling\n                    if (IdentityLogin.win.closed) {\n                        IdentityLogin.jqInfoDialog.modal('closeModal');\n                        clearInterval(IdentityLogin.checker);\n                    }\n\n                    return;\n                }\n            }\n        },\n\n        /**\n         * @param {Object} popupWindow\n         * @return {Boolean}\n         */\n        isPopupBlocked = function (popupWindow) {\n            try {\n                popupWindow.focus();\n            } catch (e) {\n                alert({\n                    content: $.mage.__('Popup Blocker is enabled! Please add this site to your exception list.')\n                });\n\n                return true;\n            }\n\n            return false;\n        },\n\n        /**\n         * @param {*} dialog\n         * @param {*} title\n         * @param {*} okButton\n         * @param {*} ajaxUrl\n         * @private\n         */\n        _showPopup = function (dialog, title, okButton, ajaxUrl) {\n            $.ajax({\n                url: ajaxUrl,\n                cache: false,\n                data: {\n                    'form_key': window.FORM_KEY\n                },\n                method: 'GET',\n\n                /** @inheritdoc */\n                beforeSend: function () {\n                    // Show the spinner\n                    $('body').trigger('processStart');\n                },\n\n                /** @inheritdoc */\n                success: function (result) {\n                    var redirect = result._redirect,\n                        identityLinkUrl, consumerKey, popupHtml, popup, resultObj, buttons, dialogProperties;\n\n                    if (redirect) {\n                        window.location.href = redirect;\n\n                        return;\n                    }\n\n                    identityLinkUrl = null;\n                    consumerKey = null;\n                    popupHtml = null;\n                    popup = $('#integration-popup-container');\n\n                    try {\n                        resultObj = typeof result === 'string' ?\n                            JSON.parse(result) :\n                            result;\n\n                        identityLinkUrl = resultObj['identity_link_url'];\n                        consumerKey      = resultObj['oauth_consumer_key'];\n                        popupHtml       = resultObj['popup_content'];\n\n                    } catch (e) {\n                        //This is expected if result is not json. Do nothing.\n                    }\n\n                    if (identityLinkUrl && consumerKey && popupHtml) {\n                        IdentityLogin.invokePopup(identityLinkUrl, consumerKey, popup);\n\n                        if (isPopupBlocked(IdentityLogin.win)) {\n                            return;\n                        }\n                    } else {\n                        popupHtml = result;\n                    }\n\n                    if (popup.length === 0) {\n                        popup = $('<div></div>');\n                    }\n                    popup.html(popupHtml);\n\n                    buttons = [];\n                    dialogProperties = {\n                        title: title,\n                        type: 'slide',\n                        dialogClass: dialog == 'permissions' ? 'integration-dialog' : 'integration-dialog no-close' //eslint-disable-line\n                    };\n\n                    // Add confirmation button to the list of dialog buttons. okButton not set for tokenExchange dialog\n                    if (okButton) {\n                        buttons.push(okButton);\n                    }\n                    // Add button only if its not empty\n                    if (buttons.length > 0) {\n                        dialogProperties.buttons = buttons;\n                    }\n                    popup.modal(dialogProperties);\n                    popup.modal('openModal');\n                },\n\n                /** @inheritdoc */\n                error: function (jqXHR, status, error) {\n                    alert({\n                        content: $.mage.__('Sorry, something went wrong. Please try again later.')\n                    });\n                    window.console && console.log(status + ': ' + error + '\\nResponse text:\\n' + jqXHR.responseText);\n                },\n\n                /** @inheritdoc */\n                complete: function () {\n                    // Hide the spinner\n                    $('body').trigger('processStop');\n                }\n            });\n        };\n\n        return {\n            popup: {\n                /**\n                 * @param {*} ctx\n                 */\n                show: function (ctx) {\n                    var dialog = $(ctx).attr('data-row-dialog'),\n                        isReauthorize = $(ctx).attr('data-row-is-reauthorize'),\n                        isTokenExchange = $(ctx).attr('data-row-is-token-exchange'),\n                        integrationId, ajaxUrl, integrationName, okButton;\n\n                    if (!url.hasOwnProperty(dialog)) {\n                        throw 'Invalid dialog type';\n                    }\n\n                    integrationId = $(ctx).attr('data-row-id');\n\n                    if (!integrationId) {\n                        throw 'Unable to find integration ID';\n                    }\n\n                    // Replace placeholders in URL\n                    ajaxUrl = url[dialog].replace(':id', integrationId).replace(':isReauthorize', isReauthorize);\n\n                    try {\n                        // Get integration name either from current element or from neighbor column\n                        integrationName = $(ctx).attr('data-row-name') ||\n                            $(ctx).parents('tr').find('.col-name').html().trim(); // eslint-disable-line jquery-no-trim\n\n                        if (integrationName.indexOf('<span') > -1) {\n                            // Remove unsecure URL warning from popup window title if it is present\n                            integrationName = integrationName.substring(0, integrationName.indexOf('<span'));\n                        }\n                    } catch (e) {\n                        throw 'Unable to find integration name';\n                    }\n\n                    okButton = {\n                        permissions: {\n                            text: isReauthorize == '1' ? $.mage.__('Reauthorize') : $.mage.__('Allow'), //eslint-disable-line\n                            'class': 'action-primary',\n                            attr: {\n                                'data-row-id': integrationId,\n                                'data-row-name': integrationName,\n                                'data-row-dialog': isTokenExchange == '1' ? 'tokensExchange' : 'tokens', //eslint-disable-line\n                                'data-row-is-reauthorize': isReauthorize,\n                                'data-row-is-token-exchange': isTokenExchange\n                            },\n\n                            /**\n                             * Click.\n                             */\n                            click: function () {\n                                // Find the 'Allow' button and clone - it has all necessary data, but is going to be\n                                // destroyed along with the current dialog\n                                var context = this.modal.find('button.action-primary').clone(true);\n\n                                this.closeModal();\n                                this.modal.remove();\n                                // Make popup out of data we saved from 'Allow' button\n                                window.integration.popup.show(context);\n                            }\n                        },\n                        tokens: {\n                            text: $.mage.__('Done'),\n                            'class': 'action-primary',\n\n                            /**\n                             * Click.\n                             */\n                            click: function () {\n                                // Integration has been activated at the point of generating tokens\n                                window.location.href = url.grid;\n                            }\n                        }\n                    };\n\n                    _showPopup(dialog, integrationName, okButton[dialog], ajaxUrl);\n                }\n            }\n        };\n    };\n\n    return $.mage.integration;\n});\n","Magento_InventoryAdminUi/js/form/element/region.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/region'\n], function (Region) {\n    'use strict';\n\n    return Region.extend({\n        defaults: {\n            regionScope: 'data.general.region'\n        },\n\n        /**\n         * Set region to source form\n         *\n         * @param {String} value - region\n         */\n        setDifferedFromDefault: function (value) {\n            this._super();\n\n            if (parseFloat(value)) {\n                this.source.set(this.regionScope, this.indexedOptions[value].label);\n            }\n        }\n    });\n});\n","Magento_InventoryAdminUi/js/stock/grid/cell/assigned-sources.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryAdminUi/stock/grid/cell/assigned-sources-cell.html',\n            itemsToDisplay: 5\n        },\n\n        /**\n         *\n         * @param {Array} record\n         * @returns {Array}\n         */\n        getTooltipData: function (record) {\n            return record[this.index].map(function (source) {\n                return {\n                    sourceCode: source.sourceCode,\n                    name: source.name\n                };\n            });\n        },\n\n        /**\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSourcesAssignedToStockOrderedByPriority: function (record) {\n            return this.getTooltipData(record).slice(0, this.itemsToDisplay);\n        }\n    });\n});\n","Magento_InventoryAdminUi/js/stock/grid/dynamic-rows/assigned-sources.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'Magento_Ui/js/dynamic-rows/dynamic-rows-grid'\n], function (_, dynamicRowsGrid) {\n    'use strict';\n\n    return dynamicRowsGrid.extend({\n        defaults: {\n            cacheGridDataIndex: []\n        },\n\n        /**\n         * Performance optimization of setting initial property to records data of only first page\n         *\n         * @returns {Object} Chainable.\n         */\n        setInitialProperty: function () {\n            var startIndex,\n                stopIndex;\n\n            if (_.isArray(this.recordData())) {\n                startIndex = (~~this.currentPage() - 1) * this.pageSize;\n                stopIndex = startIndex + parseInt(this.pageSize, 10);\n                this.recordData.each(function (data, index) {\n                    if (index < stopIndex) {\n                        this.source.set(this.dataScope + '.' + this.index + '.' + index + '.initialize', true);\n                    }\n                }, this);\n            }\n\n            return this;\n        },\n\n        /**\n         * Performance optimization of checking changed records\n         * skip when checks are not necessary\n         *\n         * @param {Array} data - array with records data\n         * @returns {Array} Changed records\n         */\n        _checkGridData: function (data) {\n            var cacheLength = this.cacheGridData.length,\n                curData = data.length,\n                changes = [],\n                dataIndex = [],\n                changesIndex = [];\n\n            if (cacheLength === curData || cacheLength > curData) {\n                return [];\n            }\n\n            if (!cacheLength) {\n                return data;\n            }\n            data.forEach(function (record, index) {\n                dataIndex[index] = record[this.map[this.identificationDRProperty]];\n            }, this);\n            changesIndex = _.difference(dataIndex, this.cacheGridDataIndex);\n            changesIndex.forEach(function (changeIndex) {\n                data.forEach(function (record, index) {\n                    if (changeIndex === record[this.map[this.identificationDRProperty]]) {\n                        changes.push(data[index]);\n                    }\n                }, this);\n            }, this);\n\n            return changes;\n        },\n\n        /**\n         * Performance optimization of processing insert data\n         *\n         * @param {Object} data\n         */\n        processingInsertData: function (data) {\n            this._super(data);\n            data.forEach(function (record, index) {\n                this.cacheGridDataIndex[index] = record[this.map[this.identificationDRProperty]];\n            }, this);\n        }\n    });\n});\n","Magento_InventoryBundleProductAdminUi/js/form/element/grid-column-quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/grid/columns/column'\n], function ($t, Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryBundleProductAdminUi/grid/column/quantity-per-source',\n            itemsToDisplay: 3,\n            showFullListDescription: $t('Show more...')\n        },\n\n        /**\n         * Get source items from product data.\n         *\n         * @param {Object} rowData\n         * @returns {Array}\n         */\n        getSourceItemsData: function (rowData) {\n            return rowData['quantity_per_source'];\n        }\n    });\n});\n","Magento_InventoryBundleProductAdminUi/js/form/element/quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/form/element/abstract'\n], function ($t, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            elementTmpl: 'Magento_InventoryBundleProductAdminUi/dynamic-rows/cells/cell-source',\n            itemsToDisplay: 3,\n            isFullList: true,\n            showFullListDescription: $t('Show more...'),\n            listens: {\n                value: 'updateItems'\n            }\n        },\n\n        /**\n         * Observe elements.\n         *\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['items', 'isFullList']);\n\n            return this;\n        },\n\n        /**\n         * Prepare data to use.\n         *\n         * @param {Object} data\n         * @private\n         */\n        updateItems: function (data) {\n            this.isFullList(data.length > this.itemsToDisplay);\n            this.isFullList() ? this.items(data.slice(0, this.itemsToDisplay)) : this.items(data);\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/attribute/edit/inventory/toggle/toggle-editability-all.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    $('[data-role=toggle-editability-all]').on('change', function () {\n        var toggler = $(this),\n            field = toggler.parents('.field'),\n            someEditable = $('input[type!=\"checkbox\"], select, textarea', field),\n            someEditableCheckboxes = $('input[type=\"checkbox\"]', field).not(toggler);\n\n        if (someEditableCheckboxes.length) {\n            someEditable.prop('disabled', !toggler.prop('checked') || someEditableCheckboxes.prop('checked'));\n            someEditableCheckboxes.prop('disabled', !toggler.prop('checked'));\n        } else {\n            someEditable.prop('disabled', !toggler.prop('checked'));\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/attribute/edit/inventory/toggle/toggle-editability.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    $('[data-role=toggle-editability]').on('change', function () {\n        var useConfigSettings = $(this),\n            field = useConfigSettings.parents('.field'),\n            someEditable = $('input[type!=\"checkbox\"], select, textarea', field);\n\n        someEditable.prop('disabled', useConfigSettings.prop('checked'));\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/form/qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_CatalogInventory/js/components/qty-validator-changer'\n], function (Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            links: {\n                value: false\n            }\n        },\n\n        /** @inheritdoc */\n        getInitialValue: function () {\n            var values = [this.source.get(this.dataScope), this.default],\n                value;\n\n            values.some(function (v) {\n                if (v !== null && v !== undefined) {\n                    value = v;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n            return this.normalizeData(value);\n        },\n\n        /** @inheritdoc */\n        setDifferedFromDefault: function () {\n            var initialValue;\n\n            this._super();\n            initialValue = this.source.data.product['current_product_id'] !== null ? this.initialValue : 0;\n\n            if (this.value() &&\n                parseFloat(initialValue) !== parseFloat(this.value())\n            ) {\n                this.source.set(this.dataScope, this.value());\n            } else {\n                this.source.remove(this.dataScope);\n            }\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/form/source-items.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/components/fieldset',\n    'uiRegistry',\n    'underscore'\n], function (Fieldset, registry, _) {\n    'use strict';\n\n    return Fieldset.extend({\n        defaults: {\n            advancedInventoryButtonIndex: '',\n            imports: {\n                onStockChange: '${ $.provider }:data.product.stock_data.manage_stock'\n            }\n        },\n\n        /**\n         * \"Advanced Inventory\" button should stay active in any case.\n         *\n         * @param {Integer} canManageStock\n         */\n        onStockChange: function (canManageStock) {\n            var advancedInventoryButton = registry.get('index = ' + this.advancedInventoryButtonIndex);\n\n            if (canManageStock === 0) {\n                if (!_.isUndefined(advancedInventoryButton)) {\n                    advancedInventoryButton.disabled(false);\n                }\n            }\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/form/stock-status.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/select'\n], function (Select) {\n    'use strict';\n\n    return Select.extend({\n        defaults: {\n            links: {\n                linkedValue: false\n            }\n        },\n\n        /** @inheritdoc */\n        getInitialValue: function () {\n            var values = [this.source.get(this.dataScope), this.default],\n                value;\n\n            values.some(function (v) {\n                if (v !== null && v !== undefined) {\n                    value = v;\n\n                    return true;\n                }\n\n                return false;\n            });\n\n            return this.normalizeData(value);\n        },\n\n        /** @inheritdoc */\n        setDifferedFromDefault: function () {\n            this._super();\n\n            if (parseFloat(this.initialValue) !== parseFloat(this.value())) {\n                this.source.set(this.dataScope, this.value());\n            } else {\n                this.source.remove(this.dataScope);\n            }\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/form/sources/qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_CatalogInventory/js/components/qty-validator-changer'\n], function (Validator) {\n    'use strict';\n\n    return Validator.extend({\n\n        /**\n         * Set default value for source quantity, depends on 'Use Decimal\" value.\n         *\n         * @param {Integer} isDecimal\n         * @returns void\n         */\n        setDefaultValue: function (isDecimal) {\n            if (!this.value()) {\n                isDecimal ? this.value('0.0') : this.value('0');\n            }\n        }\n    });\n});\n","Magento_InventoryCatalogAdminUi/js/product/grid/cell/quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryCatalogAdminUi/product/grid/cell/source-items.html',\n            itemsToDisplay: 5\n        },\n\n        /**\n         * Get source items data (source name and qty)\n         *\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSourceItemsData: function (record) {\n            return record[this.index] ? record[this.index] : [];\n        },\n\n        /**\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSourceItemsDataCut: function (record) {\n            return this.getSourceItemsData(record).slice(0, this.itemsToDisplay);\n        }\n    });\n});\n","Magento_InventoryConfigurableProductAdminUi/js/configurable-quantity-resolver.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiCollection',\n    'jquery',\n    'ko',\n    'uiLayout',\n    'mageUtils',\n    'underscore',\n    'mage/translate'\n], function (Collection, $, ko, layout, utils, _, $t) {\n    'use strict';\n\n    return Collection.extend({\n        defaults: {\n            attribute: {},\n            template: 'Magento_InventoryConfigurableProductAdminUi/container',\n            identifier: 'source_code',\n            dataScope: '',\n            currentAttribute: '',\n            insertListingComponent: '',\n            dynamicRowsName: 'dynamicRows',\n            type: '',\n            templateElementNames: {\n                button: 'button_template',\n                dynamicRows: 'dynamic_rows_template',\n                group: 'group_template'\n            },\n            ignoreTmpls: {\n                childTemplate: true\n            },\n            listens: {\n                'attribute': 'handlerAttributeChange',\n                'insertListingValue': 'handlerInsertValueChange',\n                'type': 'handlerTypeChange'\n            },\n            dynamicRowsCollection: {},\n            imports: {\n                insertListingValue: '${$.insertListingComponent}:value'\n            },\n            modules: {\n                insertListing: '${$.insertListingComponent}'\n            }\n        },\n\n        /**\n         * Generates data for dynamic-rows records\n         * @param {Array} data\n         *\n         * @returns {Array}\n         */\n        generateDynamicRowsData: function (data) {\n            var items = [];\n\n            _.each(data, function (item) {\n                items.push({\n                    'source': item.name,\n                    'source_code': item[this.identifier],\n                    'source_status': parseInt(item.enabled, 10) ? $.mage.__('Enabled') : $.mage.__('Disabled')\n                });\n            }.bind(this));\n\n            return items;\n        },\n\n        /**\n         * Handler for InsertListing value\n         *\n         * @param {Array} data\n         */\n        handlerInsertValueChange: function (data) {\n            var items,\n                path = this.dynamicRowsName + '.' + this.currentDynamicRows;\n\n            if (!this.currentDynamicRows) {\n                return;\n            }\n\n            if (!data.length) {\n                return;\n            }\n\n            items = this.generateDynamicRowsData(data);\n            this.source.set(path, items);\n        },\n\n        /**\n         * Handler for attribute property\n         *\n         * @param {Object} data\n         */\n        handlerAttributeChange: function (data) {\n            if (data && data !== this.currentAttribute) {\n                this.currentAttribute = data;\n                this.destroyChildren();\n\n                _.each(data.chosen, function (item) {\n                    this.addChild(item);\n                }.bind(this));\n            }\n        },\n\n        /**\n         * Handler for type property\n         *\n         * @param {String} data\n         */\n        handlerTypeChange: function (data) {\n            if (data === 'single') {\n                this.destroyChildren();\n                this.currentAttribute = {};\n                this.addChild();\n            } else if (data === 'each' && this.attribute) {\n                this.handlerAttributeChange(this.attribute);\n            }\n        },\n\n        /** @inheritdoc */\n        validate: function (elem) {\n            if (typeof elem === 'undefined') {\n                return;\n            }\n\n            if (typeof elem.validate === 'function') {\n                this.valid &= elem.validate().valid;\n            } else if (elem.elems) {\n                elem.elems().forEach(this.validate, this);\n            }\n        },\n\n        /**\n         * Parses string templates.\n         * Skip parse if deferredTmpl property set to \"true\"\n         *\n         * @param {Object} obj\n         *\n         * @returns obj\n         */\n        parseTemplateString: function (obj) {\n            var children;\n\n            if (obj.children) {\n                children = utils.copy(obj.children);\n                delete obj.children;\n            }\n\n            obj = utils.template(obj, obj);\n            obj.children = children;\n\n            if (children) {\n                _.each(children, function (child, name) {\n                    obj.children[name] = child.config.deferredTmpl ? child : this.parseTemplateString(child);\n                }, this);\n            }\n\n            obj.name = obj.config.name || obj.name;\n\n            return obj;\n        },\n\n        /**\n         * Handler for modal\n         *\n         * @param {String} id - dynamic-rows name that open modal\n         */\n        handleToggleSourcesModal: function (id) {\n            this.currentDynamicRows = this.type === 'each' ? this.currentAttribute.code + '.' + id : id;\n            this.insertListing().value(this.source.get(this.dynamicRowsName + '.' + this.currentDynamicRows));\n        },\n\n        /**\n         * Generates dynamic data for child.\n         *\n         * @param {Object | Undefined} data - optional.\n         */\n        generateDynamicData: function (data) {\n            var key = data ? data.label : this.dynamicRowsName,\n                drExportTo = this.name + ':dynamicRowsCollection.',\n                drDataScope = 'data.' + this.name + '.',\n                drDataProvider = this.dynamicRowsName + '.';\n\n            if (this.type === 'each') {\n                drDataScope += this.currentAttribute.code + '.';\n                drExportTo += this.currentAttribute.code + '.';\n                drDataProvider += this.currentAttribute.code + '.';\n            }\n\n            drDataScope += key;\n            drExportTo += key;\n            drDataProvider += key;\n\n            return {\n                group: {\n                    name: key\n                },\n                button: {\n                    label: data ? data.label : $t('Quantity'),\n                    targetName: this.name,\n                    param: key\n                },\n                dynamicRows: {\n                    dataScope: drDataScope,\n                    dataProvider: drDataProvider,\n                    name: this.dynamicRowsName,\n                    exportTo: drExportTo\n                }\n            };\n        },\n\n        /**\n         * @param {Object | Undefined} data - optional.\n         */\n        addChild: function (data) {\n            var template = utils.copy(this.childTemplate.templates).children,\n                dynamicRows = template[this.templateElementNames.dynamicRows],\n                button = template[this.templateElementNames.button],\n                group = template[this.templateElementNames.group],\n                dynamicData = this.generateDynamicData(data);\n\n            group.dynamicData = dynamicData.group;\n            group.parent = this.name;\n            group = this.parseTemplateString(group);\n\n            button.dynamicData = dynamicData.button;\n            button.parent = this.name + '.' + group.name;\n            button = this.parseTemplateString(button);\n\n            dynamicRows.dynamicData = dynamicData.dynamicRows;\n            dynamicRows.parent = this.name + '.' + group.name;\n            dynamicRows = this.parseTemplateString(dynamicRows);\n\n            layout([group, button, dynamicRows]);\n        }\n    });\n});\n","Magento_InventoryConfigurableProductAdminUi/js/dynamic-rows-configurable-mixin.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([], function () {\n        'use strict';\n\n        var mixin = {\n\n            /**\n             * Parsed data\n             *\n             * @param {Array} data - array with data\n             * about selected records\n             */\n            processingInsertDataFromGrid: function (data) {\n                var changes,\n                    tmpArray;\n\n                if (!data.length) {\n                    return;\n                }\n\n                tmpArray = this.getUnionInsertData();\n\n                changes = this._checkGridData(data);\n                this.cacheGridData = data;\n\n                changes.each(function (changedObject) {\n                    var mappedData = this.mappingValue(changedObject),\n                        sources = [];\n\n                    mappedData[this.canEditField] = 0;\n                    mappedData[this.newProductField] = 0;\n                    mappedData.variationKey = this._getVariationKey(changedObject);\n                    mappedData['configurable_attribute'] = this._getConfigurableAttribute(changedObject);\n\n                    if ('quantity_per_source' in changedObject) {\n                        changedObject['quantity_per_source'].each(function (source) {\n                            sources.push({\n                                'quantity_per_source': source.qty,\n                                'source': source['source_name'],\n                                'source_code': source['source_code']\n                            });\n                        });\n                        mappedData['quantity_per_source'] = sources;\n                    }\n\n                    tmpArray.push(mappedData);\n                }, this);\n\n                // Attributes cannot be changed before regeneration thought wizard\n                if (!this.source.get('data.attributes').length) {\n                    this.source.set('data.attributes', this.attributesTmp);\n                }\n                this.unionInsertData(tmpArray);\n            }\n        };\n\n        return function (target) {\n            return target.extend(mixin);\n        };\n    }\n);\n","Magento_InventoryConfigurableProductAdminUi/js/components/dynamic-rows-configurable.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_ConfigurableProduct/js/components/dynamic-rows-configurable'\n], function (dynamicRowsConfigurable) {\n    'use strict';\n\n    return dynamicRowsConfigurable.extend({\n        defaults: {\n            quantityFieldName: 'quantity_per_source'\n        },\n\n        /** @inheritdoc */\n        getProductData: function (row) {\n            var product = this._super(row);\n\n            product[this.quantityFieldName] = row.quantityPerSource;\n\n            return product;\n        }\n    });\n});\n","Magento_InventoryConfigurableProductAdminUi/js/components/sources-visibility-checker.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'underscore',\n    'uiRegistry',\n    'uiComponent'\n], function (_, registry, component) {\n    'use strict';\n\n    return component.extend({\n        defaults: {\n            sourcesIndex: ''\n        },\n\n        /**\n         * Hide source tab if convert product to configurable and show it if to simple.\n         */\n        applySourcesConfiguration: function (visibleMatrix) {\n            var source = registry.get('index = ' + this.sourcesIndex);\n\n            if (!_.isUndefined(source)) {\n                source.visible(!visibleMatrix);\n            }\n        }\n    });\n});\n","Magento_InventoryConfigurableProductAdminUi/js/form/element/quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/**\n * @api\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/form/element/abstract'\n], function ($t, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            elementTmpl: 'Magento_InventoryConfigurableProductAdminUi/dynamic-rows/cells/cell-source',\n            itemsToDisplay: 5,\n            isFullList: true,\n            showFullListDescription: $t('Show more...'),\n            listens: {\n                value: 'updateItems'\n            }\n        },\n\n        /**\n         *\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['items', 'isFullList']);\n\n            return this;\n        },\n\n        /**\n         *\n         * @param {Object} data\n         */\n        updateItems: function (data) {\n            this.isFullList(data.length > this.itemsToDisplay);\n            this.isFullList() ? this.items(data.slice(0, this.itemsToDisplay)) : this.items(data);\n        }\n    });\n});\n","Magento_InventoryConfigurableProductAdminUi/js/variations/steps/bulk.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_ConfigurableProduct/js/variations/steps/bulk',\n    'jquery',\n    'ko',\n    'underscore'\n], function (Bulk, $, ko, _) {\n    'use strict';\n\n    return Bulk.extend({\n        defaults: {\n            quantityModuleName: '',\n            quantityPerSource: '',\n            exports: {\n                attribute: '${$.provider}:data.inventoryAttribute',\n                type: '${$.provider}:data.inventoryType'\n            },\n            modules: {\n                quantityResolver: '${$.quantityResolver}'\n            }\n        },\n\n        /** @inheritdoc */\n        initialize: function () {\n            var sections;\n\n            this._super();\n\n            sections = this.sections();\n            sections.quantityPerSource = {\n                label: 'Quantity Per Source',\n                type: ko.observable('none'),\n                value: ko.observable(),\n                attribute: ko.observable()\n            };\n            this.sections(sections);\n\n            /**\n             * Make options sections.\n             */\n            this.makeOptionSections = function () {\n                return {\n                    images: new this.makeImages(null),\n                    price: this.price,\n                    quantityPerSource: this.quantityPerSource\n                };\n            }.bind(this);\n\n            this.initAttributeListener();\n\n            return this;\n        },\n\n        /**\n         * Inits listeners for attribute change.\n         */\n        initAttributeListener: function () {\n            var quantityPerSource = this.sections().quantityPerSource;\n\n            quantityPerSource.attribute.subscribe(function (data) {\n                this.attribute(data);\n            }.bind(this));\n\n            quantityPerSource.type.subscribe(function (data) {\n                this.type(data);\n            }.bind(this));\n        },\n\n        /**\n         * Calls 'initObservable' of parent, initializes 'options' and 'initialOptions'\n         *     properties, calls 'setOptions' passing options to it\n         *\n         * @returns {Object} Chainable.\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'attribute',\n                    'type'\n                ]);\n\n            return this;\n        },\n\n        /** @inheritdoc */\n        force: function (wizard) {\n            if (this.type() === 'each' && this.attribute() || this.type() === 'single') {\n                this.prepareDynamicRowsData();\n            }\n\n            this._super(wizard);\n        },\n\n        /**\n         * Prepares dynamic rows data for the next step\n         */\n        prepareDynamicRowsData: function () {\n            var data,\n                module = this.quantityResolver();\n\n            if (this.type() === 'each') {\n                data = module.dynamicRowsCollection[this.attribute().code];\n\n                _.each(this.attribute().chosen, function (item) {\n                    item.sections().quantityPerSource = data[item.label];\n                });\n            } else if (this.type() === 'single') {\n                data = module.dynamicRowsCollection[module.dynamicRowsName];\n                this.sections().quantityPerSource.value(data);\n            }\n        },\n\n        /** @inheritdoc */\n        validate: function () {\n            var valid = true,\n                quantityPerSource = this.quantityResolver();\n\n            this._super();\n\n            if (this.type() && this.type() !== 'none') {\n                quantityPerSource.valid = true;\n\n                quantityPerSource.elems().forEach(function (item) {\n                    quantityPerSource.validate.call(quantityPerSource, item);\n                    valid = valid && item.elems()[1].elems().length;\n                });\n\n                if (!quantityPerSource.valid || !valid) {\n                    throw new Error($.mage.__('Please fill-in correct values.'));\n                }\n            }\n        }\n    });\n});\n","Magento_InventoryConfigurableProductAdminUi/js/variations/steps/summary.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_ConfigurableProduct/js/variations/steps/summary',\n    'jquery',\n    'mage/translate'\n], function (Summary, $) {\n    'use strict';\n\n    return Summary.extend({\n        defaults: {\n            attributesName: [\n                $.mage.__('Images'),\n                $.mage.__('SKU'),\n                $.mage.__('Quantity Per Source'),\n                $.mage.__('Price')\n            ],\n            quantityFieldName: 'quantityPerSource'\n        }\n    });\n});\n","Magento_InventoryGroupedProductAdminUi/js/form/element/grid-column-quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/grid/columns/column'\n], function ($t, Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryGroupedProductAdminUi/grid/column/quantity-per-source',\n            itemsToDisplay: 3,\n            showFullListDescription: $t('Show more...')\n        },\n\n        /**\n         * Get source items from product data.\n         *\n         * @param {Object} rowData\n         * @returns {Array}\n         */\n        getSourceItemsData: function (rowData) {\n            return rowData['quantity_per_source'];\n        }\n    });\n});\n","Magento_InventoryGroupedProductAdminUi/js/form/element/quantity-per-source.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'mage/translate',\n    'Magento_Ui/js/form/element/abstract'\n], function ($t, Abstract) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            elementTmpl: 'Magento_InventoryGroupedProductAdminUi/dynamic-rows/cells/cell-source',\n            itemsToDisplay: 3,\n            isFullList: true,\n            showFullListDescription: $t('Show more...'),\n            listens: {\n                value: 'updateItems'\n            }\n        },\n\n        /**\n         * Observe elements.\n         *\n         * @returns {exports}\n         */\n        initObservable: function () {\n            this._super()\n                .observe(['items', 'isFullList']);\n\n            return this;\n        },\n\n        /**\n         * Prepare data to use.\n         *\n         * @param {Object} data\n         * @private\n         */\n        updateItems: function (data) {\n            this.isFullList(data.length > this.itemsToDisplay);\n            this.isFullList() ? this.items(data.slice(0, this.itemsToDisplay)) : this.items(data);\n        }\n    });\n});\n","Magento_InventoryInStorePickupAdminUi/js/form/components/fieldset.js":"/*\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/components/fieldset',\n    'ko'\n], function (Fieldset, ko) {\n    'use strict';\n\n    /**\n     * TODO Remove when issue is resolved in core.\n     * @see Please check issue in core for more details: https://github.com/magento/magento2/issues/22067.\n     */\n    return Fieldset.extend(ko).extend(\n        {\n            /**\n             * Convert `visible` value from string ('1', '0') to bool (true, false)\n             */\n            initialize: function () {\n                this._super();\n\n                // eslint-disable-next-line vars-on-top\n                var visible = this.visible;\n\n                this.visible = ko.computed({\n                    /**\n                     * @returns {Boolean}\n                     */\n                    read: function () {\n                        return visible();\n                    },\n\n                    /**\n                     * @param {String} value\n                     */\n                    write: function (value) {\n                        value = Boolean(value) === value ? value : Boolean(parseInt(value, 10));\n                        visible(value);\n                    },\n                    owner: this\n                });\n                this.visible(visible());\n            }\n        }\n    );\n});\n","Magento_InventoryInStorePickupAdminUi/js/form/element/conditional-required.js":"/*\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'ko',\n    'underscore',\n    'mageUtils'\n], function (uiElement, ko, _, utils) {\n    'use strict';\n\n    /**\n     * Provide possibility to make field required by dependency on other field value.\n     */\n    return uiElement.extend(\n        {\n            /**\n             * Convert `required` value from string ('1', '0') to bool (true, false)\n             */\n            initialize: function () {\n                this._super();\n\n                // eslint-disable-next-line vars-on-top\n                var required = this.required;\n\n                this.required = ko.computed({\n                    /**\n                     * @returns {Boolean}\n                     */\n                    read: function () {\n                        return required();\n                    },\n\n                    /**\n                     * @param {String|Boolean} value\n                     */\n                    write: function (value) {\n                        value = Boolean(value) === value ? value : Boolean(parseInt(value, 10));\n\n                        if (required() !== value) {\n                            required(value);\n                            this.setValidation('required-entry', required());\n                        }\n                    },\n                    owner: this\n                });\n                this.required(required());\n            },\n\n            /**\n             * @param {(String|Object)} rule\n             * @param {(Object|Boolean)} [options]\n             * @returns {Abstract} Chainable.\n             */\n            setValidation: function (rule, options) {\n                var rules = utils.copy(this.validation),\n                    changed;\n\n                if (_.isObject(rule)) {\n                    _.extend(this.validation, rule);\n                } else {\n                    this.validation[rule] = options;\n                }\n\n                changed = !utils.compare(rules, this.validation).equal;\n\n                if (changed) {\n                    this.required(!!this.validation['required-entry']);\n                    this.validate();\n                }\n\n                return this;\n            }\n        }\n    );\n});\n","Magento_InventoryInStorePickupSalesAdminUi/order/create/scripts-mixin.js":"/*\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(\n    [\n        'jquery',\n        'prototype'\n    ],\n    function (jQuery) {\n        'use strict';\n\n        return function () {\n            var STORE_PICKUP_METHOD = 'instore_pickup',\n                SOURCES_FIELD_SELECTOR = '#shipping_form_pickup_location_source',\n                SAME_AS_BILLING_SELECTOR = '#order-shipping_same_as_billing',\n                CUSTOMER_SHIPPING_ADDRESS_ID_SELECTOR = '#order-shipping_address_customer_address_id',\n                CUSTOMER_ADDRESS_SAVE_IN_ADDRESS_BOOK_SELECTOR = '#order-shipping_address_save_in_address_book',\n                IN_STORE_PICKUP_CHECKBOX_SELECTOR = '#s_method_instore_pickup';\n\n            /**\n             * Display sources dropdown field;\n             * And vice-versa\n             *\n             * @param {Boolean} isStorePickup\n             */\n            function setStorePickupMethod(isStorePickup) {\n                var sourcesInput = jQuery(SOURCES_FIELD_SELECTOR),\n                    shippingAddressSaveInAddressBook = jQuery(CUSTOMER_ADDRESS_SAVE_IN_ADDRESS_BOOK_SELECTOR);\n\n                if (isStorePickup) {\n                    shippingAddressSaveInAddressBook.prop('checked', false);\n                    sourcesInput.show();\n\n                    return;\n                }\n                window.order.disableShippingAddress(jQuery(SAME_AS_BILLING_SELECTOR).prop('checked'));\n                sourcesInput.hide();\n            }\n\n            /**\n             * Verify is store pickup delivery method is checked.\n             */\n            function isStorePickupSelected() {\n                var storePickupCheckbox = jQuery(IN_STORE_PICKUP_CHECKBOX_SELECTOR);\n\n                return storePickupCheckbox.length && storePickupCheckbox.prop('checked');\n            }\n\n            /**\n             * Always disable unwanted shipping address fields in case store pickup is selected.\n             */\n            window.AdminOrder.prototype.disableShippingAddress =\n                window.AdminOrder.prototype.disableShippingAddress.wrap(function (proceed, flag) {\n                    var shippingAddressId = jQuery(CUSTOMER_SHIPPING_ADDRESS_ID_SELECTOR),\n                        theSameAsBillingCheckBox = jQuery(SAME_AS_BILLING_SELECTOR),\n                        shippingAddressSaveInAddressBook = jQuery(CUSTOMER_ADDRESS_SAVE_IN_ADDRESS_BOOK_SELECTOR);\n\n                    proceed(flag);\n\n                    if (isStorePickupSelected()) {\n                        shippingAddressId.prop('disabled', true);\n                        theSameAsBillingCheckBox.prop('disabled', true);\n                        shippingAddressSaveInAddressBook.prop('disabled', true);\n                    }\n                });\n\n            /**\n             * Set shipping method override\n             *\n             * @param {String} method\n             */\n            window.AdminOrder.prototype.setShippingMethod = function (method) {\n                var data = {},\n                    areas = [\n                        'shipping_method',\n                        'totals',\n                        'billing_method',\n                        'shipping_address'\n                    ];\n\n                data['order[shipping_method]'] = method;\n\n                if (method === STORE_PICKUP_METHOD) {\n                    data = this.serializeData(this.shippingAddressContainer).toObject();\n                    data['order[shipping_method]'] = method;\n                    data['shipping_as_billing'] = 0;\n                    data['save_in_address_book'] = 0;\n                    this.shippingAsBilling = 0;\n                    this.saveInAddressBook = 0;\n                }\n\n                this.loadArea(areas, true, data).then(\n                    function () {\n                        setStorePickupMethod(method === STORE_PICKUP_METHOD);\n                    }\n                );\n            };\n\n            /**\n             * Replace shipping method area.\n             * Restore store pickup shipping method if it was already selected.\n             */\n            window.AdminOrder.prototype.resetShippingMethod = function () {\n                var storePickupCheckbox = jQuery(IN_STORE_PICKUP_CHECKBOX_SELECTOR);\n\n                if (!this.isOnlyVirtualProduct) {\n                    /* eslint-disable no-undef */\n                    $(this.getAreaId('shipping_method')).update(this.shippingTemplate);\n\n                    if (isStorePickupSelected()) {\n                        window.order.setShippingMethod(storePickupCheckbox.val());\n                    }\n                }\n            };\n        };\n    }\n);\n","Magento_InventoryInStorePickupSalesAdminUi/order/create/trigger-shipping-method-update.js":"/*\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine(\n    [\n        'jquery',\n        'Magento_Sales/order/create/form'\n    ],\n    function ($) {\n        'use strict';\n\n        return function () {\n            var storePickupCheckbox = $('#s_method_instore_pickup');\n\n            if (storePickupCheckbox.length && storePickupCheckbox.prop('checked')) {\n                window.order.setShippingMethod(storePickupCheckbox.val());\n            }\n        };\n    }\n);\n","Magento_InventoryLowQuantityNotificationAdminUi/js/components/notify-stock-qty.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/abstract'\n], function (AbstractField) {\n    'use strict';\n\n    return AbstractField.extend({\n        defaults: {\n            notifyStockQtyUseDefault: '',\n            manageStock: '',\n            listens: {\n                notifyStockQtyUseDefault: 'onChange',\n                manageStock: 'onChange'\n            }\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['notifyStockQtyUseDefault', 'manageStock']);\n        },\n\n        /**\n         * Disable input when Manage Stock switched off or Notify Quantity Use Default\n         */\n        onChange: function () {\n            this.disabled(\n                this.notifyStockQtyUseDefault() ||\n                this.manageStock()\n            );\n        }\n    });\n});\n","Magento_InventoryLowQuantityNotificationAdminUi/js/components/use-config-settings.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/form/element/single-checkbox'\n], function (checkbox) {\n    'use strict';\n\n    return checkbox.extend({\n        defaults: {\n            valueFromConfig: '',\n            linkedValue: ''\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initObservable: function () {\n            return this\n                ._super()\n                .observe(['valueFromConfig', 'linkedValue']);\n        },\n\n        /**\n         * @inheritdoc\n         */\n        'onCheckedChanged': function (newChecked) {\n            if (newChecked) {\n                this.linkedValue(this.valueFromConfig());\n            }\n\n            this._super(newChecked);\n        },\n\n        /**\n         * @returns {String}\n         */\n        getInitialValue: function () {\n            var values = [this.value(), this.default],\n                value;\n\n            values.some(function (v) {\n                value = v || !!v;\n\n                return value;\n            });\n\n            return this.normalizeData(value);\n        }\n    });\n});\n","Magento_InventorySalesAdminUi/js/product/grid/cell/salable-quantity.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventorySalesAdminUi/product/grid/cell/salable-quantity.html'\n        },\n\n        /**\n         * Get salable quantity data (stock name and salable qty)\n         *\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSalableQuantityData: function (record) {\n            return record[this.index] ? record[this.index] : [];\n        }\n    });\n});\n","Magento_InventorySalesAdminUi/js/stock/grid/cell/sales-channels.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column',\n    'underscore'\n], function (Column, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventorySalesAdminUi/stock/grid/cell/sales-channel-cell.html'\n        },\n\n        /**\n         * Get sales channels grouped by type\n         *\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getSalesChannelsGroupedByType: function (record) {\n            var result = [];\n\n            _.each(record[this.index], function (channels, type) {\n                result.push({\n                    type: type,\n                    channels: channels\n                });\n            });\n\n            return result;\n        }\n    });\n});\n","Magento_InventoryShippingAdminUi/js/form/form.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/form/form',\n    'underscore',\n    'mageUtils'\n], function ($, Form, _, utils) {\n    'use strict';\n\n    return Form.extend({\n        defaults: {\n            sourceSelectionUrl: '${ $.sourceSelectionUrl }'\n        },\n\n        /**\n         * Process source selection algorithm\n         *\n         * @param {String} redirect\n         * @param {Object} data\n         */\n        processAlgorithm: function (redirect, data) {\n            var formData = utils.filterFormData(this.source.get('data'));\n\n            data.requestData = [];\n\n            _.each(formData.items, function (item) {\n                data.requestData.push({\n                    orderItem: item.orderItemId,\n                    sku: item.sku,\n                    qty: item.qtyToShip\n                });\n            });\n\n            data.orderId = formData['order_id'];\n            data.websiteId = formData.websiteId;\n            data = utils.serialize(utils.filterFormData(data));\n            data['form_key'] = window.FORM_KEY;\n\n            if (!this.sourceSelectionUrl || this.sourceSelectionUrl === 'undefined') {\n                return $.Deferred.resolve();\n            }\n\n            $('body').trigger('processStart');\n\n            $.ajax({\n                url: this.sourceSelectionUrl,\n                data: data,\n\n                /**\n                 * Success callback.\n                 *\n                 * @param {Object} response\n                 */\n                success: function (response) {\n                    var dataItems = this.source.get('data.items');\n\n                    _.each(dataItems, function (item) {\n                        if (response[item.orderItemId]) {\n                            this.source.set('data.items.' + item['record_id'] + '.sources', response[item.orderItemId]);\n                        }\n                    }.bind(this));\n                    this.source.trigger('reInitSources');\n                    this.source.set('data.sourceCodes', response.sourceCodes ? response.sourceCodes : []);\n                }.bind(this),\n\n                /**\n                 * Complete callback.\n                 */\n                complete: function () {\n                    $('body').trigger('processStop');\n                }\n            });\n        }\n    });\n});\n","Magento_InventoryShippingAdminUi/js/form/element/qty_to_deduct.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/form/element/abstract',\n    'mageUtils'\n], function (Abstract, utils) {\n    'use strict';\n\n    return Abstract.extend({\n        defaults: {\n            sourceCode: null,\n            qtyAvailable: 0\n        },\n\n        /**\n         * @inheritdoc\n         */\n        initialize: function () {\n            var path,\n                qtyToShip,\n                isManageStock;\n\n            this._super();\n\n            //TODO: Is it right way?\n            path = utils.getPart(utils.getPart(this.parentScope, -2), -2);\n            qtyToShip = this.source.get(path + '.qtyToShip');\n            isManageStock = this.source.get(path + '.isManageStock');\n\n            this.validation['less-than-equals-to'] = isManageStock ? this.qtyAvailable : qtyToShip;\n\n            return this;\n        },\n\n        /**\n         * Toggle disabled state.\n         *\n         * @param {String} selected\n         */\n        toggleDisable: function (selected) {\n            this.disabled(selected ? selected.toString() !== this.sourceCode : !selected);\n        }\n    });\n});\n","Magento_InventoryShippingAdminUi/js/form/element/source_code.js":"define([\n    'underscore',\n    'Magento_Ui/js/form/element/select'\n], function (_, select) {\n    'use strict';\n\n    return select.extend({\n        /**\n         * @inheritdoc\n         */\n        setOptions: function (data) {\n            var result = this._super(data);\n\n            if (data.length === 1) {\n                this.value(data[0].value);\n            }\n\n            return result;\n        }\n    });\n});\n","Magento_InventoryShippingAdminUi/js/order/grid/cell/allocated-sources.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/columns/column'\n], function (Column) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_InventoryShippingAdminUi/order/grid/cell/allocated-sources-cell.html',\n            itemsToDisplay: 5\n        },\n\n        /**\n         *\n         * @param {Array} record\n         * @returns {Array}\n         */\n        getTooltipData: function (record) {\n            return record[this.index];\n        },\n\n        /**\n         * @param {Object} record - Record object\n         * @returns {Array} Result array\n         */\n        getAllocatedSources: function (record) {\n            return this.getTooltipData(record).slice(0, this.itemsToDisplay);\n        }\n    });\n});\n","Magento_LoginAsCustomerAdminUi/js/confirmation-popup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Ui/js/modal/confirm',\n    'jquery',\n    'ko',\n    'mage/translate',\n    'mage/template',\n    'underscore',\n    'Magento_Ui/js/modal/alert',\n    'text!Magento_LoginAsCustomerAdminUi/template/confirmation-popup/store-view-ptions.html'\n], function (Component, confirm, $, ko, $t, template, _, alert, selectTpl) {\n\n    'use strict';\n\n    return Component.extend({\n        /**\n         * Initialize Component\n         */\n        initialize: function () {\n            var self = this,\n                content;\n\n            this._super();\n\n            content = '<div class=\"message message-warning\">' + self.content + '</div>';\n\n            if (self.showStoreViewOptions) {\n                content = template(\n                    selectTpl,\n                    {\n                        data: {\n                            showStoreViewOptions: self.showStoreViewOptions,\n                            storeViewOptions: self.storeViewOptions,\n                            label: $t('Store')\n                        }\n                    }) + content;\n            }\n\n            /**\n             * Confirmation popup\n             *\n             * @param {String} url\n             * @returns {Boolean}\n             */\n            window.lacConfirmationPopup = function (url) {\n                confirm({\n                    title: self.title,\n                    content: content,\n                    modalClass: 'confirm lac-confirm',\n                    actions: {\n                        /**\n                         * Confirm action.\n                         */\n                        confirm: function () {\n                            var storeId = $('#lac-confirmation-popup-store-id').val(),\n                                formKey = $('input[name=\"form_key\"]').val(),\n                                params = {};\n\n                            // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n                            if (storeId) {\n                                params.store_id = storeId;\n                            }\n\n                            if (formKey) {\n                                params.form_key = formKey;\n                            }\n                            // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n\n                            $.ajax({\n                                url: url,\n                                type: 'POST',\n                                dataType: 'json',\n                                data: params,\n                                showLoader: true,\n\n                                /**\n                                 * Open redirect URL in new window, or show messages if they are present\n                                 *\n                                 * @param {Object} data\n                                 */\n                                success: function (data) {\n                                    var messages = data.messages || [];\n\n                                    if (data.message) {\n                                        messages.push(data.message);\n                                    }\n\n                                    if (data.redirectUrl) {\n                                        window.open(data.redirectUrl);\n                                    } else if (messages.length) {\n                                        messages = messages.map(function (message) {\n                                            return _.escape(message);\n                                        });\n\n                                        alert({\n                                            content: messages.join('<br>')\n                                        });\n                                    }\n                                },\n\n                                /**\n                                 * Show XHR response text\n                                 *\n                                 * @param {Object} jqXHR\n                                 */\n                                error: function (jqXHR) {\n                                    alert({\n                                        content: _.escape(jqXHR.responseText)\n                                    });\n                                }\n                            });\n                        }\n                    },\n                    buttons: [{\n                        text: $t('Cancel'),\n                        class: 'action-secondary action-dismiss',\n\n                        /**\n                         * Click handler.\n                         */\n                        click: function (event) {\n                            this.closeModal(event);\n                        }\n                    }, {\n                        text: $t('Login as Customer'),\n                        class: 'action-primary action-accept',\n\n                        /**\n                         * Click handler.\n                         */\n                        click: function (event) {\n                            this.closeModal(event, true);\n                        }\n                    }]\n                });\n\n                return false;\n            };\n        }\n    });\n});\n","Magento_LoginAsCustomerAssistance/js/not-allowed-popup.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'Magento_Ui/js/modal/confirm',\n    'mage/translate'\n], function (Component, confirm, $t) {\n\n    'use strict';\n\n    return Component.extend({\n        /**\n         * Initialize Component\n         */\n        initialize: function () {\n            var self = this,\n                content;\n\n            this._super();\n\n            content = '<div class=\"message message-warning\">' + self.content + '</div>';\n\n            /**\n             * Not Allowed popup\n             *\n             * @returns {Boolean}\n             */\n            window.lacNotAllowedPopup = function () {\n                confirm({\n                    title: self.title,\n                    content: content,\n                    modalClass: 'confirm lac-confirm',\n                    buttons: [\n                        {\n                            text: $t('Close'),\n                            class: 'action-secondary action-dismiss',\n\n                            /**\n                             * Click handler.\n                             */\n                            click: function (event) {\n                                this.closeModal(event);\n                            }\n                        }\n                    ]\n                });\n\n                return false;\n            };\n        }\n    });\n});\n","Magento_Marketplace/default.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery'\n], function ($) {\n    'use strict';\n\n    return function (configFromPage) {\n        var url = configFromPage.url;\n\n        $.ajax({\n            method: 'GET',\n            url: url\n        }).done(function (data) {\n            $('div[data-role=partners-block]').html(data);\n        });\n    };\n});\n","Magento_MediaGalleryUi/js/container.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiElement',\n    'jquery'\n], function (Element, $) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            containerSelector: '.media-gallery-container',\n            masonryComponentPath: 'media_gallery_listing.media_gallery_listing.media_gallery_columns',\n            modules: {\n                masonry: '${ $.masonryComponentPath }'\n            }\n        },\n\n        /**\n         * Init component\n         *\n         * @return {exports}\n         */\n        initialize: function () {\n            this._super();\n\n            $(this.containerSelector).applyBindings();\n\n            return this;\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/image-uploader.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiComponent',\n    'jquery',\n    'underscore',\n    'Magento_Ui/js/lib/validation/validator',\n    'mage/translate',\n    'jquery/file-uploader'\n], function (Component, $, _, validator, $t) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            imageUploadInputSelector: '#image-uploader-form',\n            directoriesPath: 'media_gallery_listing.media_gallery_listing.media_gallery_directories',\n            actionsPath: 'media_gallery_listing.media_gallery_listing.media_gallery_columns.thumbnail_url',\n            messagesPath: 'media_gallery_listing.media_gallery_listing.messages',\n            imageUploadUrl: '',\n            acceptFileTypes: '',\n            allowedExtensions: '',\n            maxFileSize: '',\n            maxFileNameLength: 90,\n            loader: false,\n            modules: {\n                directories: '${ $.directoriesPath }',\n                actions: '${ $.actionsPath }',\n                mediaGridMessages: '${ $.messagesPath }',\n                sortBy: '${ $.sortByName }',\n                listingPaging: '${ $.listingPagingName }'\n            }\n        },\n\n        /**\n         * Init component\n         *\n         * @return {exports}\n         */\n        initialize: function () {\n            this._super().observe(\n                [\n                    'loader',\n                    'count'\n                ]\n            );\n\n            return this;\n        },\n\n        /**\n         * Initializes file upload library\n         */\n        initializeFileUpload: function () {\n            $(this.imageUploadInputSelector).fileupload({\n                url: this.imageUploadUrl,\n                acceptFileTypes: this.acceptFileTypes,\n                allowedExtensions: this.allowedExtensions,\n                maxFileSize: this.maxFileSize,\n\n                /**\n                 * Extending the form data\n                 *\n                 * @param {Object} form\n                 * @returns {Array}\n                 */\n                formData: function (form) {\n                    return form.serializeArray().concat(\n                        [{\n                            name: 'isAjax',\n                            value: true\n                        },\n                        {\n                            name: 'form_key',\n                            value: window.FORM_KEY\n                        },\n                        {\n                            name: 'target_folder',\n                            value: this.getTargetFolder()\n                        }]\n                    );\n                }.bind(this),\n\n                add: function (e, data) {\n                    if (!this.isSizeExceeded(data.files[0]).passed) {\n                        this.addValidationErrorMessage(\n                            $t('Cannot upload \"%1\". File exceeds maximum file size limit.')\n                                .replace('%1', data.files[0].name)\n                        );\n\n                        return;\n                    } else if (!this.isFileNameLengthExceeded(data.files[0]).passed) {\n                        this.addValidationErrorMessage(\n                            $t('Cannot upload \"%1\". Filename is too long, must be 90 characters or less.')\n                                .replace('%1', data.files[0].name)\n                        );\n\n                        return;\n                    }\n\n                    this.showLoader();\n                    this.count(1);\n                    data.submit();\n                }.bind(this),\n\n                stop: function () {\n                    this.openNewestImages();\n                    this.mediaGridMessages().scheduleCleanup();\n                }.bind(this),\n\n                start: function () {\n                    this.mediaGridMessages().clear();\n                }.bind(this),\n\n                done: function (e, data) {\n                    var response = data.jqXHR.responseJSON;\n\n                    if (!response) {\n                        this.showErrorMessage(data, $t('Could not upload the asset.'));\n\n                        return;\n                    }\n\n                    if (!response.success) {\n                        this.showErrorMessage(data, response.message);\n\n                        return;\n                    }\n                    this.showSuccessMessage(data);\n                    this.hideLoader();\n                    this.actions().reloadGrid();\n                }.bind(this)\n            });\n        },\n\n        /**\n         * Add error message after validation error.\n         *\n         * @param {String} message\n         */\n        addValidationErrorMessage: function (message) {\n            this.mediaGridMessages().add('error', message);\n\n            this.count() < 2 || this.mediaGridMessages().scheduleCleanup();\n        },\n\n        /**\n         * Checks if size of provided file exceeds\n         * defined in configuration size limits.\n         *\n         * @param {Object} file - File to be checked.\n         * @returns {Boolean}\n         */\n        isSizeExceeded: function (file) {\n            return validator('validate-max-size', file.size, this.maxFileSize);\n        },\n\n        /**\n         * Checks if name length of provided file exceeds\n         * defined in configuration size limits.\n         *\n         * @param {Object} file - File to be checked.\n         * @returns {Boolean}\n         */\n        isFileNameLengthExceeded: function (file) {\n            return validator('max_text_length', file.name, this.maxFileNameLength);\n        },\n\n        /**\n         * Go to recently uploaded images if at least one uploaded successfully\n         */\n        openNewestImages: function () {\n            this.mediaGridMessages().get().each(function (message) {\n                if (message.code === 'success') {\n                    this.actions().deselectImage();\n                    this.sortBy().selectDefaultOption();\n                    this.listingPaging().goFirst();\n\n                    return false;\n                }\n            }.bind(this));\n        },\n\n        /**\n         * Show error meassages with file name.\n         *\n         * @param {Object} data\n         * @param {String} message\n         */\n        showErrorMessage: function (data, message) {\n            data.files.each(function (file) {\n                this.mediaGridMessages().add(\n                    'error',\n                    file.name + ': ' + $t(message)\n                );\n            }.bind(this));\n\n            this.hideLoader();\n        },\n\n        /**\n         * Show success message, and files counts\n         */\n        showSuccessMessage: function () {\n            this.mediaGridMessages().messages.remove(function (item) {\n                return item.code === 'success';\n            });\n            this.mediaGridMessages().add('success', $t('Assets have been successfully uploaded!'));\n            this.count(this.count() + 1);\n\n        },\n\n        /**\n         * Gets Media Gallery selected folder\n         *\n         * @returns {String}\n         */\n        getTargetFolder: function () {\n\n            if (_.isUndefined(this.directories().activeNode()) ||\n                _.isNull(this.directories().activeNode())) {\n                return '/';\n            }\n\n            return this.directories().activeNode();\n        },\n\n        /**\n         * Shows spinner loader\n         */\n        showLoader: function () {\n            this.loader(true);\n        },\n\n        /**\n         * Hides spinner loader\n         */\n        hideLoader: function () {\n            this.loader(false);\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/action/deleteImages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'mage/url',\n    'Magento_MediaGalleryUi/js/grid/messages',\n    'Magento_Ui/js/modal/confirm',\n    'mage/translate'\n], function ($, _, urlBuilder, messages, confirmation, $t) {\n    'use strict';\n\n    return function (ids, deleteUrl, confirmationContent) {\n        var deferred = $.Deferred(),\n               title = $t('Delete assets'),\n               cancelText = $t('Cancel'),\n               deleteImageText = $t('Delete');\n\n        /**\n         * Send deletion request with redords ids\n         *\n         * @param {Array} recordIds\n         * @param {String} serviceUrl\n         */\n        function sendRequest(recordIds, serviceUrl) {\n\n            $.ajax({\n                type: 'POST',\n                url: serviceUrl,\n                dataType: 'json',\n                showLoader: true,\n                data: {\n                    'form_key': window.FORM_KEY,\n                    'ids': recordIds\n                },\n                context: this,\n\n                /**\n                 * Success handler for deleting image\n                 *\n                 * @param {Object} response\n                 */\n                success: function (response) {\n                    var message = !_.isUndefined(response.message) ? response.message : null;\n\n                    if (!response.success) {\n                        message = message || $t('There was an error on attempt to delete the images.');\n                        $(window).trigger('fileDeleted.enhancedMediaGallery', {\n                            reload: false,\n                            message: message,\n                            code: 'error'\n                        });\n\n                        deferred.reject(message);\n                    }\n\n                    message = message || $t('You have successfully removed the images.');\n                    $(window).trigger('fileDeleted.enhancedMediaGallery', {\n                        reload: true,\n                        message: message,\n                        code: 'success'\n                    });\n                    deferred.resolve(message);\n                },\n\n                /**\n                 * Error handler for deleting image\n                 *\n                 * @param {Object} response\n                 */\n                error: function (response) {\n                    var message;\n\n                    if (typeof response.responseJSON === 'undefined' ||\n                        typeof response.responseJSON.message === 'undefined'\n                    ) {\n                        message = $t('There was an error on attempt to delete the image.');\n                    } else {\n                        message = response.responseJSON.message;\n                    }\n\n                    $(window).trigger('fileDeleted.enhancedMediaGallery', {\n                        reload: false,\n                        message: message,\n                        code: 'error'\n                    });\n                    deferred.reject(message);\n                }\n            });\n        }\n\n        confirmation({\n            title: title,\n            modalClass: 'media-gallery-delete-image-action',\n            content: confirmationContent,\n            buttons: [\n                {\n                    text: cancelText,\n                    class: 'action-secondary action-dismiss',\n\n                    /**\n                     * Close modal\n                     */\n                    click: function () {\n                        this.closeModal();\n                        deferred.resolve({\n                            status: 'canceled'\n                        });\n                    }\n                },\n                {\n                    text: deleteImageText,\n                    class: 'action-primary action-accept',\n\n                    /**\n                     * Delete Image and close modal\n                     */\n                    click: function () {\n                        sendRequest(ids, deleteUrl);\n                        this.closeModal();\n                    }\n                }\n            ]\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_MediaGalleryUi/js/action/deleteImageWithDetailConfirmation.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'Magento_MediaGalleryUi/js/action/getDetails',\n    'Magento_MediaGalleryUi/js/action/deleteImages',\n    'mage/translate'\n], function ($, _, getDetails, deleteImages, $t) {\n    'use strict';\n\n    return {\n\n        /**\n         * Get information about image use\n         *\n         * @param {Array} recordsIds\n         * @param {String} imageDetailsUrl\n         * @param {String} deleteImageUrl\n         */\n        deleteImageAction: function (recordsIds, imageDetailsUrl, deleteImageUrl) {\n            var confirmationContent = $t('%1Are you sure you want to delete \"%2\" image(s)?')\n                .replace('%2', Object.keys(recordsIds).length),\n                deferred = $.Deferred();\n\n            getDetails(imageDetailsUrl, recordsIds).then(function (images) {\n                        confirmationContent = confirmationContent.replace(\n                            '%1',\n                            this.getRecordRelatedContentMessage(images) + ' '\n                        );\n                    }.bind(this)).fail(function () {\n                        confirmationContent = confirmationContent.replace('%1', '');\n                    }).always(function () {\n                        deleteImages(recordsIds, deleteImageUrl, confirmationContent).then(function (status) {\n                            deferred.resolve(status);\n                        }).fail(function (error) {\n                            deferred.reject(error);\n                        });\n                    });\n\n            return deferred.promise();\n        },\n\n        /**\n         * Get information about image use\n         *\n         * @param {Object|String} images\n         * @return {String}\n         */\n        getRecordRelatedContentMessage: function (images) {\n            var usedInMessage = $t('The selected assets are used in the content of the following entities: '),\n                usedIn = {};\n\n            $.each(images, function (key, image) {\n                $.each(image.details, function (sectionIndex, section) {\n                    if (section.title === 'Used In' && _.isObject(section) && !_.isEmpty(section.value)) {\n                        $.each(section.value, function (entityTypeIndex, entityTypeData) {\n                            usedIn[entityTypeData.name] = entityTypeData.name in usedIn ?\n                                usedIn[entityTypeData.name] + entityTypeData.number :\n                                entityTypeData.number;\n                        });\n                    }\n                });\n            });\n\n            if (_.isEmpty(usedIn)) {\n                return '';\n            }\n\n            return usedInMessage + this.usedInObjectToString(usedIn);\n        },\n\n        /**\n         * Fromats usedIn object to string\n         *\n         * @param {Object} usedIn\n         * @return {String}\n         */\n        usedInObjectToString: function (usedIn) {\n            var entities = [];\n\n            $.each(usedIn, function (entityName, number) {\n                entities.push(entityName + '(' + number + ')');\n            });\n\n            return entities.join(', ') + '.';\n        }\n    };\n});\n","Magento_MediaGalleryUi/js/action/getDetails.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/translate'\n], function ($, $t) {\n    'use strict';\n\n    return function (imageDetailsUrl, imageIds) {\n        var deferred = $.Deferred(),\n            message;\n\n        $.ajax({\n            type: 'GET',\n            url: imageDetailsUrl,\n            dataType: 'json',\n            showLoader: true,\n            data: {\n                'ids': imageIds\n            },\n            context: this,\n\n            /**\n             * Resolve with image details if success, reject with response message othervise\n             *\n             * @param {Object} response\n             */\n            success: function (response) {\n                if (response.success) {\n                    deferred.resolve(response.imageDetails);\n\n                    return;\n                }\n\n                deferred.reject(response.message);\n            },\n\n            /**\n             * Extract the message and reject\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n\n                if (typeof response.responseJSON === 'undefined' ||\n                    typeof response.responseJSON.message === 'undefined'\n                ) {\n                    message = $t('Could not retrieve image details.');\n                } else {\n                    message = response.responseJSON.message;\n                }\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_MediaGalleryUi/js/action/saveDetails.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/translate'\n], function ($, $t) {\n    'use strict';\n\n    return function (saveImageDetailsUrl, data) {\n        var deferred = $.Deferred(),\n            message;\n\n        $.ajax({\n            type: 'POST',\n            url: saveImageDetailsUrl,\n            dataType: 'json',\n            showLoader: true,\n            data: data,\n\n            /**\n             * Resolve with image details if success, reject with response message otherwise\n             *\n             * @param {Object} response\n             */\n            success: function (response) {\n                if (response.success) {\n                    deferred.resolve(response.message);\n\n                    return;\n                }\n\n                deferred.reject(response.message);\n            },\n\n            /**\n             * Extract the message and reject\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n                if (typeof response.responseJSON === 'undefined' ||\n                    typeof response.responseJSON.message === 'undefined'\n                ) {\n                    message = $t('Could not save image details.');\n                } else {\n                    message = response.responseJSON.message;\n                }\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_MediaGalleryUi/js/directory/directories.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.g\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_Ui/js/modal/confirm',\n    'Magento_Ui/js/modal/alert',\n    'underscore',\n    'Magento_Ui/js/modal/prompt',\n    'Magento_MediaGalleryUi/js/directory/actions/createDirectory',\n    'Magento_MediaGalleryUi/js/directory/actions/deleteDirectory',\n    'mage/translate',\n    'validation'\n], function ($, Component, confirm, uiAlert, _, prompt, createDirectory, deleteDirectory, $t) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            allowedActions: [],\n            directoryTreeSelector: '#media-gallery-directory-tree',\n            deleteButtonSelector: '#delete_folder',\n            createFolderButtonSelector: '#create_folder',\n            messageDelay: 5,\n            selectedFolder: null,\n            messagesName: 'media_gallery_listing.media_gallery_listing.messages',\n            modules: {\n                directoryTree: '${ $.parentName }.media_gallery_directories',\n                messages: '${ $.messagesName }'\n            }\n        },\n\n        /**\n         * Initializes media gallery directories component.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        initialize: function () {\n            this._super().observe(['selectedFolder']);\n            this._addValidation();\n            this.initEvents();\n\n            return this;\n        },\n\n        /**\n          * Initialize directories events\n          */\n        initEvents: function () {\n            $(this.deleteButtonSelector).on('delete_folder', function () {\n                this.deleteFolder();\n            }.bind(this));\n\n            $(this.createFolderButtonSelector).on('create_folder', function () {\n                this.createFolder();\n            }.bind(this));\n        },\n\n        /**\n         * Show confirmation popup and create folder based on user input\n         */\n        createFolder: function () {\n            this.getPrompt({\n                title: $t('New Folder Name:'),\n                content: '',\n                actions: {\n                    /**\n                     * Confirm action\n                     */\n                    confirm: function (folderName) {\n                        createDirectory(\n                            this.directoryTree().createDirectoryUrl,\n                            [this.getNewFolderPath(folderName)]\n                        ).then(function () {\n                            this.directoryTree().reloadJsTree().then(function () {\n                                this.directoryTree().locateNode(this.getNewFolderPath(folderName));\n                            }.bind(this));\n                        }.bind(this)).fail(function (error) {\n                            uiAlert({\n                                content: error\n                            });\n                        });\n                    }.bind(this)\n                },\n                buttons: [{\n                    text: $t('Cancel'),\n                    class: 'action-secondary action-dismiss',\n\n                    /**\n                     * Close modal\n                     */\n                    click: function () {\n                        this.closeModal();\n                    }\n                }, {\n                    text: $t('Confirm'),\n                    class: 'action-primary action-accept'\n                }]\n            });\n        },\n\n        /**\n         * Return configured path for folder creation.\n         *\n         * @param {String} folderName\n         * @returns {String}\n         */\n        getNewFolderPath: function (folderName) {\n            if (_.isUndefined(this.selectedFolder()) || _.isNull(this.selectedFolder())) {\n                return folderName;\n            }\n\n            return this.selectedFolder() + '/' + folderName;\n        },\n\n        /**\n          * Return configured prompt with input field\n          */\n        getPrompt: function (data) {\n                prompt({\n                    title: $t(data.title),\n                    content:  $t(data.content),\n                    modalClass: 'media-gallery-folder-prompt',\n                    validation: true,\n                    validationRules: ['required-entry', 'validate-filename'],\n                    attributesField: {\n                        name: 'folder_name',\n                        'data-validate': '{required:true, validate-filename}',\n                        maxlength: '128'\n                    },\n                    attributesForm: {\n                        novalidate: 'novalidate',\n                        action: ''\n                    },\n                    context: this,\n                    actions: data.actions,\n                    buttons: data.buttons\n                });\n            },\n\n        /**\n          * Confirmation popup for delete folder action.\n          */\n        deleteFolder: function () {\n            confirm({\n                title: $t('Are you sure you want to delete this folder?'),\n                modalClass: 'delete-folder-confirmation-popup',\n                content: $t('The following folder is going to be deleted: %1')\n                    .replace('%1', this.selectedFolder()),\n                actions: {\n\n                    /**\n                      * Delete folder on button click\n                      */\n                    confirm: function () {\n                        deleteDirectory(\n                            this.directoryTree().deleteDirectoryUrl,\n                            this.selectedFolder()\n                        ).then(function () {\n                            this.directoryTree().removeNode();\n                            this.directoryTree().selectStorageRoot();\n                            $(window).trigger('folderDeleted.enhancedMediaGallery');\n                        }.bind(this)).fail(function (error) {\n                            uiAlert({\n                                content: error\n                            });\n                        });\n                    }.bind(this)\n                }\n            });\n        },\n\n        /**\n         * Set inactive all nodes, adds disable state to Delete Folder Button\n         */\n        setInActive: function () {\n            this.selectedFolder(null);\n            $(this.deleteButtonSelector).attr('disabled', true).addClass('disabled');\n        },\n\n        /**\n         * Set active node, remove disable state from Delete Forlder button\n         *\n         * @param {String} folderId\n         */\n        setActive: function (folderId) {\n            if (!this.allowedActions.includes('delete_folder')) {\n                return;\n            }\n\n            this.selectedFolder(folderId);\n            $(this.deleteButtonSelector).prop('disabled', false).removeClass('disabled');\n        },\n\n        /**\n         * @private\n         */\n        _addValidation: function () {\n            $.validator.addMethod(\n                'validate-filename', function (value) {\n                    return $.mage.isEmptyNoTrim(value) || /^[a-z0-9\\-\\_]+$/si.test(value);\n                },\n                $.mage.__('Please use only letters (a-z or A-Z), numbers (0-9), underscore (_) or hyphen (-) in this field. No spaces or other characters are allowed.')); //eslint-disable-line max-len\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/directory/directoryTree.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global Base64 */\ndefine([\n    'jquery',\n    'uiComponent',\n    'uiLayout',\n    'underscore',\n    'Magento_MediaGalleryUi/js/directory/actions/createDirectory',\n    'jquery/jstree/jquery.jstree',\n    'Magento_Ui/js/lib/view/utils/async',\n    'Magento_MediaGalleryUi/js/directory/directories'\n], function ($, Component, layout, _, createDirectory) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            allowedActions: [],\n            filterChipsProvider: 'componentType = filters, ns = ${ $.ns }',\n            bookmarkProvider: 'componentType = bookmark, ns = ${ $.ns }',\n            directoryTreeSelector: '#media-gallery-directory-tree',\n            getDirectoryTreeUrl: 'media_gallery/directories/gettree',\n            createDirectoryUrl: 'media_gallery/directories/create',\n            deleteDirectoryUrl: 'media_gallery/directories/delete',\n            jsTreeReloaded: null,\n            modules: {\n                bookmarks: '${ $.bookmarkProvider }',\n                directories: '${ $.name }_directories',\n                filterChips: '${ $.filterChipsProvider }'\n            },\n            listens: {\n                '${ $.provider }:params.filters.path': 'updateSelectedDirectory'\n            },\n            viewConfig: [{\n                component: 'Magento_MediaGalleryUi/js/directory/directories',\n                name: '${ $.name }_directories',\n                allowedActions: '${ $.allowedActions }'\n            }]\n        },\n\n        /**\n         * Initializes media gallery directories component.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        initialize: function () {\n            this._super().observe(['activeNode']).initView();\n\n            $.async(\n                this.directoryTreeSelector,\n                this,\n                function () {\n                    this.initJsTreeEvents();\n                    this.renderDirectoryTree().then(function () {\n                        this.initEvents();\n                    }.bind(this));\n                }.bind(this)\n            );\n\n            return this;\n        },\n\n        /**\n         * Render directory tree component.\n         */\n        renderDirectoryTree: function () {\n            return this.getJsonTree().then(function (data) {\n                this.createFolderIfNotExists(data).then(function (isFolderCreated) {\n                    if (isFolderCreated) {\n                        this.getJsonTree().then(function (newData) {\n                            this.createTree(newData);\n                        }.bind(this));\n                    } else {\n                        this.createTree(data);\n                    }\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /**\n         * Set jstree reloaded\n         *\n         * @param {Boolean} value\n         */\n        setJsTreeReloaded: function (value) {\n            this.jsTreeReloaded = value;\n        },\n\n        /**\n         * Create folder by provided current_tree_path param\n         *\n         * @param {Array} directories\n         */\n        createFolderIfNotExists: function (directories) {\n            var requestedDirectory = this.getRequestedDirectory(),\n                deferred = $.Deferred(),\n                pathArray;\n\n            if (_.isNull(requestedDirectory)) {\n                deferred.resolve(false);\n\n                return deferred.promise();\n            }\n\n            if (this.isDirectoryExist(directories, requestedDirectory)) {\n                deferred.resolve(false);\n\n                return deferred.promise();\n            }\n\n            pathArray = this.convertPathToPathsArray(requestedDirectory);\n\n            $.each(pathArray, function (i, val) {\n                if (this.isDirectoryExist(directories, val)) {\n                    pathArray.splice(i, 1);\n                }\n            }.bind(this));\n\n            createDirectory(\n                this.createDirectoryUrl,\n                pathArray\n            ).then(function () {\n                deferred.resolve(true);\n            });\n\n            return deferred.promise();\n        },\n\n        /**\n         * Verify if directory exists in array\n         *\n         * @param {Array} directories\n         * @param {String} directoryId\n         */\n        isDirectoryExist: function (directories, directoryId) {\n            var found = false;\n\n            /**\n             * Recursive search in array\n             *\n             * @param {Array} data\n             * @param {String} id\n             */\n            function recurse(data, id) {\n                var i;\n\n                for (i = 0; i < data.length; i++) {\n                    if (data[i].id === id) {\n                        found = data[i];\n                        break;\n                    } else if (data[i].children && data[i].children.length) {\n                        recurse(data[i].children, id);\n                    }\n                }\n            }\n\n            recurse(directories, directoryId);\n\n            return found;\n        },\n\n        /**\n         * Convert path string to path array e.g 'path1/path2' -> ['path1', 'path1/path2']\n         *\n         * @param {String} path\n         */\n        convertPathToPathsArray: function (path) {\n            var pathsArray = [],\n                pathString = '',\n                paths = path.split('/');\n\n            $.each(paths, function (i, val) {\n                pathString += i >= 1 ? val : val + '/';\n                pathsArray.push(i >= 1 ? pathString : val);\n            });\n\n            return pathsArray;\n        },\n\n        /**\n         * Initialize child components\n         *\n         * @returns {Object}\n         */\n        initView: function () {\n            layout(this.viewConfig);\n\n            return this;\n        },\n\n        /**\n         * Wait for condition then call provided callback\n         */\n        waitForCondition: function (condition, callback) {\n            if (condition()) {\n                setTimeout(function () {\n                    this.waitForCondition(condition, callback);\n                }.bind(this), 100);\n            } else {\n                callback();\n            }\n        },\n\n        /**\n         * Remove ability to multiple select on nodes\n         */\n        disableMultiselectBehavior: function () {\n            $.jstree.defaults.core.multiple = false;\n        },\n\n        /**\n         *  Handle jstree events\n         */\n        initEvents: function () {\n            this.disableMultiselectBehavior();\n\n            $(window).on('reload.MediaGallery', function () {\n                this.getJsonTree().then(function (data) {\n                    this.createFolderIfNotExists(data).then(function (isCreated) {\n                        if (isCreated) {\n                            this.renderDirectoryTree().then(function () {\n                                this.setJsTreeReloaded(true);\n                                this.initJsTreeEvents();\n                            }.bind(this));\n                        } else {\n                            this.updateSelectedDirectory();\n                        }\n                    }.bind(this));\n                }.bind(this));\n            }.bind(this));\n        },\n\n        /**\n         * Fire event for jstree component\n         */\n        initJsTreeEvents: function () {\n            $(this.directoryTreeSelector).on('select_node.jstree', function (element, data) {\n                this.setActiveNodeFilter(data.node.id);\n                this.setJsTreeReloaded(false);\n            }.bind(this));\n\n            $(this.directoryTreeSelector).on('loaded.jstree', function () {\n                this.updateSelectedDirectory();\n            }.bind(this));\n        },\n\n        /**\n         * Verify directory filter on init event, select folder per directory filter state\n         */\n        updateSelectedDirectory: function () {\n            var currentFilterPath = this.filterChips().filters.path,\n                requestedDirectory = this.getRequestedDirectory(),\n                currentTreePath;\n\n            if (_.isUndefined(currentFilterPath)) {\n                this.clearFiltersHandle();\n\n                return;\n            }\n\n            if (!_.isUndefined(this.bookmarks())) {\n                if (!_.size(this.bookmarks().getViewData(this.bookmarks().defaultIndex))) {\n                    setTimeout(function () {\n                        this.updateSelectedDirectory();\n                    }.bind(this), 500);\n\n                    return;\n                }\n            }\n            currentTreePath = this.isFilterApplied(currentFilterPath) || _.isNull(requestedDirectory) ?\n                currentFilterPath : requestedDirectory;\n\n            if (this.folderExistsInTree(currentTreePath)) {\n                this.locateNode(currentTreePath);\n            } else {\n                this.selectStorageRoot();\n            }\n        },\n\n        /**\n         * Verify if directory exists in folder tree\n         *\n         * @param {String} path\n         */\n        folderExistsInTree: function (path) {\n            if (!_.isUndefined(path)) {\n                return $(this.directoryTreeSelector).jstree('get_node', path);\n            }\n\n            return false;\n        },\n\n        /**\n         * Get requested directory from MediabrowserUtility\n         *\n         * @returns {String|null}\n         */\n        getRequestedDirectory: function () {\n            return !_.isUndefined(window.MediabrowserUtility) && window.MediabrowserUtility.pathId !== '' ?\n                Base64.idDecode(window.MediabrowserUtility.pathId) : null;\n        },\n\n        /**\n         * Check if need to select directory by filters state\n         *\n         * @param {String} currentFilterPath\n         */\n        isFilterApplied: function (currentFilterPath) {\n            return !_.isUndefined(currentFilterPath) && currentFilterPath !== '';\n        },\n\n        /**\n         * Locate and higlight node in jstree by path id.\n         *\n         * @param {String} path\n         */\n        locateNode: function (path) {\n            if ($(this.directoryTreeSelector).jstree('is_selected', path)) {\n                return;\n            }\n            $(this.directoryTreeSelector).jstree('deselect_node',\n                $(this.directoryTreeSelector).jstree('get_selected')\n            );\n            $(this.directoryTreeSelector).jstree('open_node', path);\n            $(this.directoryTreeSelector).jstree('select_node', path, true);\n\n        },\n\n        /**\n         * Clear filters\n         */\n        clearFiltersHandle: function () {\n            $(this.directoryTreeSelector).jstree('deselect_all');\n            this.activeNode(null);\n            this.directories().setInActive();\n        },\n\n        /**\n         * Set active node filter, or deselect if the same node clicked\n         *\n         * @param {String} nodePath\n         */\n        setActiveNodeFilter: function (nodePath) {\n            if (this.activeNode() === nodePath && !this.jsTreeReloaded) {\n                this.selectStorageRoot();\n            } else {\n                this.selectFolder(nodePath);\n            }\n        },\n\n        /**\n         * Remove folders selection -> select storage root\n         */\n        selectStorageRoot: function () {\n            var filters = {},\n                applied = this.filterChips().get('applied');\n\n            $(this.directoryTreeSelector).jstree('deselect_all');\n\n            filters = $.extend(true, filters, applied);\n            delete filters.path;\n            this.filterChips().set('applied', filters);\n            this.activeNode(null);\n            this.waitForCondition(\n                function () {\n                    return _.isUndefined(this.directories());\n                }.bind(this),\n                function () {\n                    this.directories().setInActive();\n                }.bind(this)\n            );\n        },\n\n        /**\n         * Set selected folder\n         *\n         * @param {String} path\n         */\n        selectFolder: function (path) {\n            this.activeNode(path);\n\n            this.waitForCondition(\n                function () {\n                    return _.isUndefined(this.directories());\n                }.bind(this),\n                function () {\n                    this.directories().setActive(path);\n                }.bind(this)\n            );\n\n            this.applyFilter(path);\n        },\n\n        /**\n         * Remove active node from directory tree, and select next\n         */\n        removeNode: function () {\n            $(this.directoryTreeSelector).jstree('delete_node',\n                $(this.directoryTreeSelector).jstree('get_selected')\n            );\n        },\n\n        /**\n         * Apply folder filter by path\n         *\n         * @param {String} path\n         */\n        applyFilter: function (path) {\n            var filters = {},\n                applied = this.filterChips().get('applied');\n\n            filters = $.extend(true, filters, applied);\n            filters.path = path;\n            this.filterChips().set('applied', filters);\n        },\n\n        /**\n         * Reload jstree and update jstree events\n         */\n        reloadJsTree: function () {\n            var deferred = $.Deferred();\n\n            this.getJsonTree().then(function (data) {\n                $(this.directoryTreeSelector).jstree(true).settings.core.data = data;\n                $(this.directoryTreeSelector).jstree(true).refresh(false, true);\n                this.setJsTreeReloaded(true);\n                deferred.resolve();\n            }.bind(this));\n\n            return deferred.promise();\n        },\n\n        /**\n         * Get json data for jstree\n         */\n        getJsonTree: function () {\n            var deferred = $.Deferred();\n\n            $.ajax({\n                url: this.getDirectoryTreeUrl,\n                type: 'GET',\n                dataType: 'json',\n\n                /**\n                 * Success handler for request\n                 *\n                 * @param {Object} data\n                 */\n                success: function (data) {\n                    deferred.resolve(data);\n                },\n\n                /**\n                 * Error handler for request\n                 *\n                 * @param {Object} jqXHR\n                 * @param {String} textStatus\n                 */\n                error: function (jqXHR, textStatus) {\n                    deferred.reject();\n                    throw textStatus;\n                }\n            });\n\n            return deferred.promise();\n        },\n\n        /**\n         * Initialize directory tree\n         *\n         * @param {Array} data\n         */\n        createTree: function (data) {\n            // jscs:disable requireCamelCaseOrUpperCaseIdentifiers\n            $(this.directoryTreeSelector).jstree({\n                plugins: [],\n                checkbox: {\n                    three_state: false,\n                    cascade: ''\n                },\n                core: {\n                    data: data,\n                    check_callback: true,\n                    themes: {\n                        dots: false\n                    }\n                }\n            });\n            // jscs:enable requireCamelCaseOrUpperCaseIdentifiers\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/directory/actions/createDirectory.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/translate'\n], function ($, $t) {\n    'use strict';\n\n    return function (createFolderUrl, paths) {\n        var deferred = $.Deferred(),\n            message,\n            data = {\n                paths: paths\n            };\n\n        $.ajax({\n            type: 'POST',\n            url: createFolderUrl,\n            dataType: 'json',\n            showLoader: true,\n            data: data,\n            context: this,\n\n            /**\n             * Resolve  if success, reject with response message othervise\n             *\n             * @param {Object} response\n             */\n            success: function (response) {\n                if (response.success) {\n                    deferred.resolve(response.message);\n\n                    return;\n                }\n\n                deferred.reject(response.message);\n            },\n\n            /**\n             * Extract the message and reject\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n\n                if (typeof response.responseJSON === 'undefined' ||\n                    typeof response.responseJSON.message === 'undefined'\n                ) {\n                    message = $t('Could not create the directory.');\n                } else {\n                    message = response.responseJSON.message;\n                }\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_MediaGalleryUi/js/directory/actions/deleteDirectory.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'mage/translate'\n], function ($, $t) {\n    'use strict';\n\n    return function (deleteFolderUrl, path) {\n        var deferred = $.Deferred(),\n            message;\n\n        $.ajax({\n            type: 'POST',\n            url: deleteFolderUrl,\n            dataType: 'json',\n            showLoader: true,\n            data: {\n                path: path\n            },\n            context: this,\n\n            /**\n             * Resolve  if delete folder success, reject with response message othervise\n             *\n             * @param {Object} response\n             */\n            success: function (response) {\n                if (response.success) {\n                    deferred.resolve(response.message);\n\n                    return;\n                }\n\n                deferred.reject(response.message);\n            },\n\n            /**\n             * Extract the message and reject\n             *\n             * @param {Object} response\n             */\n            error: function (response) {\n\n                if (typeof response.responseJSON === 'undefined' ||\n                    typeof response.responseJSON.message === 'undefined'\n                ) {\n                    message = $t('Could not delete the directory.');\n                } else {\n                    message = response.responseJSON.message;\n                }\n                deferred.reject(message);\n            }\n        });\n\n        return deferred.promise();\n    };\n});\n","Magento_MediaGalleryUi/js/grid/masonry.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'Magento_Ui/js/grid/masonry',\n    'jquery'\n], function (Masonry, $) {\n    'use strict';\n\n    return Masonry.extend({\n        defaults: {\n            modules: {\n                provider: '${ $.provider }'\n            }\n        },\n\n        /**\n         * Init component\n         *\n         * @return {Object}\n         */\n        initialize: function () {\n            this._super();\n            this.initEvents();\n\n            return this;\n        },\n\n        /**\n         * Initialize events\n         */\n        initEvents: function () {\n            $(window).on('folderDeleted.enhancedMediaGallery', this.reloadGrid.bind(this));\n        },\n\n        /**\n         * Reload grid\n         */\n        reloadGrid: function () {\n            var provider = this.provider(),\n                dataStorage = provider.storage();\n\n            dataStorage.clearRequests();\n            provider.reload();\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/grid/messages.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'uiElement',\n    'escaper'\n], function (Element, escaper) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            template: 'Magento_MediaGalleryUi/grid/messages',\n            messageDelay: 5,\n            messages: [],\n            allowedTags: ['div', 'span', 'b', 'strong', 'i', 'em', 'u', 'a']\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'messages'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Get messages\n         *\n         * @returns {Array}\n         */\n        get: function () {\n            return this.messages();\n        },\n\n        /**\n         * Add message\n         *\n         * @param {String} type\n         * @param {String} message\n         */\n        add: function (type, message) {\n            this.messages.push({\n                code: type,\n                message: message\n            });\n        },\n\n        /**\n         * Clear messages\n         */\n        clear: function () {\n            this.messages.removeAll();\n        },\n\n        /**\n         * Schedule message cleanup\n         *\n         * @param {Number} delay\n         */\n        scheduleCleanup: function (delay) {\n            // eslint-disable-next-line no-unused-vars\n            var timerId;\n\n            delay = delay || this.messageDelay;\n\n            // eslint-disable-next-line no-unused-vars\n            timerId = setTimeout(function () {\n                clearTimeout(timerId);\n                this.clear();\n            }.bind(this), Number(delay) * 1000);\n        },\n\n        /**\n         * Prepare the given message to be rendered as HTML\n         *\n         * @param {String} message\n         * @return {String}\n         */\n        prepareMessageUnsanitizedHtml: function (message) {\n            return escaper.escapeHtml(message, this.allowedTags);\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/grid/sortBy.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'Magento_Ui/js/grid/sortBy'\n], function (Element) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            columnIndexMap: {}\n        },\n\n        /**\n         * Prepared sort order options\n         */\n        preparedOptions: function (columns) {\n            var index = 0,\n                sortBy;\n\n            if (columns && columns.length > 0) {\n                columns.map(function (column) {\n                    if (column.sortable === true) {\n                        sortBy = column['sort_by'] || {};\n\n                        if (sortBy.excluded) {\n                            return;\n                        }\n\n                        this.options.push({\n                            value: column.index,\n                            label: column.label,\n                            sortByField: sortBy.field,\n                            sortDirection: sortBy.direction\n                        });\n\n                        this.columnIndexMap[column.index] = index++;\n\n                        this.isVisible(true);\n                    } else {\n                        this.isVisible(false);\n                    }\n                }.bind(this));\n            }\n        },\n\n        /**\n         * Apply changes\n         */\n        applyChanges: function () {\n            var column = this.getColumn(this.selectedOption());\n\n            this.applied({\n                field: column.sortByField || this.selectedOption(),\n                direction: column.sortDirection || this.sorting\n            });\n        },\n\n        /**\n         * Get column by index\n         *\n         * @param {String} optionIndex\n         * @returns {Object}\n         */\n        getColumn: function (optionIndex) {\n            return this.options[this.columnIndexMap[optionIndex]];\n        },\n\n        /**\n         * Select default option\n         */\n        selectDefaultOption: function () {\n            this.selectedOption(this.options[0].value);\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/grid/columns/image.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'Magento_Ui/js/grid/columns/column',\n    'uiLayout',\n    'underscore'\n], function ($, Column, layout, _) {\n    'use strict';\n\n    return Column.extend({\n        defaults: {\n            bodyTmpl: 'Magento_MediaGalleryUi/grid/columns/image',\n            messageContentSelector: 'ul.messages',\n            mediaGalleryContainerSelector: '.media-gallery-container',\n            deleteImageUrl: 'media_gallery/image/delete',\n            addSelectedBtnSelector: '#add_selected',\n            deleteSelectedBtnSelector: '#delete_selected',\n            gridSelector: '[data-id=\"media-gallery-masonry-grid\"]',\n            selected: null,\n            allowedActions: [],\n            fields: {\n                id: 'id',\n                url: 'url',\n                alt: 'name'\n            },\n            modules: {\n                actions: '${ $.name }_actions',\n                provider: '${ $.provider }',\n                messages: '${ $.messagesName }',\n                massaction: '${ $.massactionComponentName }'\n            },\n            imports: {\n                activeDirectory: '${ $.mediaGalleryDirectoryComponent }:activeNode'\n            },\n            listens: {\n                activeDirectory: 'selectDirectoryHandle',\n                '${ $.massactionComponentName }:massActionMode': 'updateSelected'\n            },\n            viewConfig: [\n                {\n                    component: 'Magento_MediaGalleryUi/js/grid/columns/image/actions',\n                    name: '${ $.name }_actions',\n                    imageModelName: '${ $.name }',\n                    allowedActions: '${ $.allowedActions }'\n                }\n            ]\n        },\n\n        /**\n         * Initialize the component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super();\n            this.initView();\n            $(window).on('fileDeleted.enhancedMediaGallery', this.reloadMediaGrid.bind(this));\n            $(window).on('reload.MediaGallery', this.reloadGrid.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Init observable variables\n         * @return {Object}\n         */\n        initObservable: function () {\n            this._super()\n                .observe([\n                    'selected'\n                ]);\n\n            return this;\n        },\n\n        /**\n         * Is massaction mode active.\n         */\n        isMassActionMode: function () {\n            return this.massaction().massActionMode();\n        },\n\n        /**\n         * Returns url to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getUrl: function (record) {\n            return record[this.fields.url];\n        },\n\n        /**\n         * Returns id to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Number}\n         */\n        getId: function (record) {\n            return record[this.fields.id];\n        },\n\n        /**\n         * Update selected items per massaction mode.\n         */\n        updateSelected: function () {\n            this.selected({});\n            this.hideAddSelectedAndDeleteButon();\n        },\n\n        /**\n         * Returns name to given record.\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {String}\n         */\n        getImageAlt: function (record) {\n            return record[this.fields.alt];\n        },\n\n        /**\n         * Check if the record is currently selected\n         *\n         * @param {Object} record - Data to be preprocessed.\n         * @returns {Boolean}\n         */\n        isSelected: function (record) {\n            if (_.isNull(this.selected())) {\n                return false;\n            }\n\n            if (this.massaction().massActionMode()) {\n                return this.selected()[record.id];\n            }\n\n            return this.getId(this.selected()) === this.getId(record);\n        },\n\n        /**\n         * Click on image\n         *\n         * @param {Object} record\n         * @param {Boolean} collapsibleOpened\n         */\n        clickOnImage: function (record, collapsibleOpened) {\n            if (!collapsibleOpened) {\n                this.select(record);\n            }\n        },\n\n        /**\n         * Click on three-dots\n         *\n         * @param {Object} record\n         * @param {Boolean} collapsibleOpened\n         */\n        clickOnThreeDots: function (record, collapsibleOpened) {\n            if (!this.isSelected(record) || collapsibleOpened) {\n                this.select(record);\n            }\n        },\n\n        /**\n         * Handle checkbox click.\n         */\n        checkboxClick: function (record) {\n            var items = this.selected();\n\n            if (this.selected()[record.id])  {\n                delete items[record.id];\n                this.selected(items);\n            } else {\n                items[record.id] = record.id;\n                this.selected(items);\n            }\n\n            return true;\n        },\n\n        /**\n         * Set the record as selected\n         */\n        select: function (record) {\n            if (this.massaction().massActionMode()) {\n                return this.checkboxClick(record);\n            }\n\n            this.isSelected(record) ? this.selected(null) : this.selected(record);\n            this.toggleAddSelectedButton();\n\n            return true;\n        },\n\n        /**\n         * Deselect the record\n         */\n        deselectImage: function () {\n            this.selected(null);\n            this.toggleAddSelectedButton();\n        },\n\n        /**\n         * Get the selected record\n         * @returns {Object}\n         */\n        getSelected: function () {\n            return this.selected();\n        },\n\n        /**\n         * Initialize child components\n         *\n         * @returns {Object}\n         */\n        initView: function () {\n            layout(this.viewConfig);\n\n            return this;\n        },\n\n        /**\n         * Toggle add selected button\n         */\n        toggleAddSelectedButton: function () {\n            if (this.selected() === null) {\n                this.hideAddSelectedAndDeleteButon();\n\n                return;\n            }\n\n            if (this.allowedActions.includes('insert')) {\n                $(this.addSelectedBtnSelector).removeClass('no-display');\n            }\n\n            if (this.allowedActions.includes('delete')) {\n                $(this.deleteSelectedBtnSelector).removeClass('no-display');\n            }\n        },\n\n        /**\n         * Hide add selected and Delete button\n         */\n        hideAddSelectedAndDeleteButon: function () {\n            $(this.addSelectedBtnSelector).addClass('no-display');\n            $(this.deleteSelectedBtnSelector).addClass('no-display');\n        },\n\n        /**\n         * @param {jQuery.event} e\n         * @param {Object} data\n         */\n        reloadMediaGrid: function (e, data) {\n            if (data.reload) {\n                this.reloadGrid();\n            }\n\n            if (data.message && data.code) {\n                this.addMessage(data.code, data.message);\n            }\n            this.hideAddSelectedAndDeleteButon();\n        },\n\n        /**\n         * Reload grid\n         */\n        reloadGrid: function () {\n            var provider = this.provider(),\n                dataStorage = provider.storage();\n\n            dataStorage.clearRequests();\n            provider.reload();\n        },\n\n        /**\n         * Add message\n         *\n         * @param {String} code\n         * @param {String} message\n         */\n        addMessage: function (code, message) {\n            this.messages().add(code, message);\n            this.closeContextMenu();\n            this.scrollToMessageContent();\n            this.messages().scheduleCleanup();\n        },\n\n        /**\n         * Listener to select directory event\n         *\n         * @param {String} path\n         */\n        selectDirectoryHandle: function (path) {\n            if (this.selected() &&\n                this.selected().directory !== path  &&\n                !this.massaction().massActionMode()) {\n                this.deselectImage();\n            }\n        },\n\n        /**\n         * Action to close the context menu in media gallery.\n         */\n        closeContextMenu: function () {\n            $(this.gridSelector).trigger('click');\n        },\n\n        /**\n         * Scroll to the top of media gallery page\n         */\n        scrollToMessageContent: function () {\n            var scrollTargetElement = $(this.messageContentSelector),\n                scrollTargetContainer = $(this.mediaGalleryContainerSelector);\n\n            scrollTargetContainer.find(scrollTargetElement).get(0).scrollIntoView({\n                behavior: 'smooth',\n                block: 'center',\n                inline: 'nearest'\n            });\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/grid/columns/image/actions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\ndefine([\n    'jquery',\n    'underscore',\n    'uiComponent',\n    'Magento_MediaGalleryUi/js/action/deleteImageWithDetailConfirmation',\n    'Magento_MediaGalleryUi/js/grid/columns/image/insertImageAction',\n    'mage/translate',\n    'Magento_Ui/js/lib/view/utils/async'\n], function ($, _, Component, deleteImageWithDetailConfirmation, image, $t) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            template: 'Magento_MediaGalleryUi/grid/columns/image/actions',\n            mediaGalleryImageDetailsName: 'mediaGalleryImageDetails',\n            mediaGalleryEditDetailsName: 'mediaGalleryEditDetails',\n            allowedActions: [],\n            actionsList: [\n                {\n                    name: 'image-details',\n                    title: $t('View Details'),\n                    classes: 'action-menu-item',\n                    handler: 'viewImageDetails'\n                },\n                {\n                    name: 'edit',\n                    title: $t('Edit'),\n                    classes: 'action-menu-item',\n                    handler: 'editImageDetails'\n                },\n                {\n                    name: 'delete',\n                    title: $t('Delete'),\n                    classes: 'action-menu-item media-gallery-delete-assets',\n                    handler: 'deleteImageAction'\n                }\n            ],\n            modules: {\n                imageModel: '${ $.imageModelName }',\n                mediaGalleryImageDetails: '${ $.mediaGalleryImageDetailsName }',\n                mediaGalleryEditDetails: '${ $.mediaGalleryEditDetailsName }'\n            }\n        },\n\n        /**\n         * Initialize the component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super();\n            this.initEvents();\n\n            this.actionsList = this.actionsList.filter(function (item) {\n                return this.allowedActions.includes(item.name);\n            }.bind(this));\n\n            if (!this.allowedActions.includes('delete')) {\n                $.async('.media-gallery-delete-assets', function () {\n                    $('.media-gallery-delete-assets').off('click').addClass('action-disabled');\n                });\n            }\n\n            return this;\n        },\n\n        /**\n         * Initialize image action events\n         */\n        initEvents: function () {\n            $(this.imageModel().addSelectedBtnSelector).on('click', function () {\n                image.insertImage(\n                    this.imageModel().getSelected(),\n                    {\n                        onInsertUrl: this.imageModel().onInsertUrl,\n                        storeId: this.imageModel().storeId\n                    }\n                );\n            }.bind(this));\n            $(this.imageModel().deleteSelectedBtnSelector).on('click', function () {\n                this.deleteImageAction(this.imageModel().selected());\n            }.bind(this));\n\n        },\n\n        /**\n         * Delete image action\n         *\n         * @param {Object} record\n         */\n        deleteImageAction: function (record) {\n            var imageDetailsUrl = this.mediaGalleryImageDetails().imageDetailsUrl,\n                deleteImageUrl = this.imageModel().deleteImageUrl;\n\n            deleteImageWithDetailConfirmation.deleteImageAction([record.id], imageDetailsUrl, deleteImageUrl);\n        },\n\n        /**\n         * View image details\n         *\n         * @param {Object} record\n         */\n        viewImageDetails: function (record) {\n            var recordId = this.imageModel().getId(record);\n\n            this.mediaGalleryImageDetails().showImageDetailsById(recordId);\n        },\n\n        /**\n         * Edit image details\n         *\n         * @param {Object} record\n         */\n        editImageDetails: function (record) {\n            var recordId = this.imageModel().getId(record);\n\n            this.mediaGalleryEditDetails().showEditDetailsPanel(recordId);\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/grid/columns/image/insertImageAction.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\n/* global FORM_KEY, tinyMceEditors */\ndefine([\n    'jquery',\n    'wysiwygAdapter',\n    'underscore',\n    'mage/translate'\n], function ($, wysiwyg, _, $t) {\n    'use strict';\n\n    return {\n\n        /**\n         * Insert provided image in wysiwyg if enabled, or widget\n         *\n         * @param {Object} record\n         * @param {Object} config\n         * @returns {Boolean}\n         */\n        insertImage: function (record, config) {\n            var targetElement, forceStaticPath;\n\n            if (record === null) {\n                return false;\n            }\n            targetElement = this.getTargetElement(window.MediabrowserUtility.targetElementId);\n\n            if (!targetElement.length) {\n                window.MediabrowserUtility.closeDialog();\n                throw $t('Target element not found for content update');\n            }\n\n            forceStaticPath = typeof targetElement !== 'function' && targetElement.data('force_static_path') ? 1 : 0;\n\n            $.ajax({\n                url: config.onInsertUrl,\n                data: {\n                    filename: record['encoded_id'],\n                    'store_id': config.storeId,\n                    'as_is': typeof targetElement !== 'function' && targetElement.is('textarea') ? 1 : 0,\n                    'force_static_path': forceStaticPath,\n                    'form_key': FORM_KEY\n                },\n                context: this,\n                showLoader: true\n            }).done($.proxy(function (data) {\n                if (typeof targetElement === 'function') {\n                    targetElement(data.content, {text: record['title']});\n                } else if (targetElement.is('textarea')) {\n                    this.insertAtCursor(targetElement.get(0), data.content);\n                    targetElement.focus();\n                    $(targetElement).trigger('change');\n                } else {\n                    targetElement.val(data.content)\n                        .data('size', data.size)\n                        .data('mime-type', data.type)\n                        .trigger('change');\n                }\n            }, this));\n            window.MediabrowserUtility.closeDialog();\n\n            if (typeof targetElement !== 'function') {\n                targetElement.focus();\n                $(targetElement).trigger('change');\n            }\n        },\n\n        /**\n         * Insert image to target instance.\n         *\n         * @param {Object} element\n         * @param {*} value\n         */\n        insertAtCursor: function (element, value) {\n            var sel, startPos, endPos, scrollTop;\n\n            if ('selection' in document) {\n                //For browsers like Internet Explorer\n                element.focus();\n                sel = document.selection.createRange();\n                sel.text = value;\n                element.focus();\n            } else if (element.selectionStart || element.selectionStart == '0') { //eslint-disable-line eqeqeq\n                //For browsers like Firefox and Webkit based\n                startPos = element.selectionStart;\n                endPos = element.selectionEnd;\n                scrollTop = element.scrollTop;\n                element.value = element.value.substring(0, startPos) + value +\n                    element.value.substring(startPos, endPos) + element.value.substring(endPos, element.value.length);\n                element.focus();\n                element.selectionStart = startPos + value.length;\n                element.selectionEnd = startPos + value.length + element.value.substring(startPos, endPos).length;\n                element.scrollTop = scrollTop;\n            } else {\n                element.value += value;\n                element.focus();\n            }\n        },\n\n        /**\n         * Return opener Window object if it exists, not closed and editor is active\n         *\n         * @param {String} targetElementId\n         * return {Object|null}\n         */\n        getMediaBrowserOpener: function (targetElementId) {\n            if (!_.isUndefined(wysiwyg) && wysiwyg.get(targetElementId) && !_.isUndefined(tinyMceEditors)) {\n                return tinyMceEditors.get(targetElementId).getMediaBrowserOpener();\n            }\n\n            return null;\n        },\n\n        /**\n         * Get target element\n         *\n         * @param {String} targetElementId\n         * @returns {*|n.fn.init|jQuery|HTMLElement}\n         */\n        getTargetElement: function (targetElementId) {\n\n            if (!_.isUndefined(wysiwyg) && wysiwyg.get(targetElementId)) {\n                return this.getMediaBrowserOpener(targetElementId) || window;\n            }\n\n            return $('#' + targetElementId);\n        }\n    };\n});\n","Magento_MediaGalleryUi/js/grid/massaction/massactions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'Magento_MediaGalleryUi/js/action/deleteImageWithDetailConfirmation',\n    'uiLayout',\n    'underscore',\n    'Magento_Ui/js/modal/alert',\n    'mage/translate'\n], function ($, Component, DeleteImages, Layout, _, uiAlert, $t) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            allowedActions: [],\n            deleteButtonSelector: '#delete_selected_massaction',\n            deleteImagesSelector: '#delete_massaction',\n            mediaGalleryImageDetailsName: 'mediaGalleryImageDetails',\n            modules: {\n                massactionView: '${ $.name }_view',\n                imageModel: '${ $.imageModelName }',\n                mediaGalleryImageDetails: '${ $.mediaGalleryImageDetailsName }'\n            },\n            viewConfig: [\n                {\n                    component: 'Magento_MediaGalleryUi/js/grid/massaction/massactionView',\n                    name: '${ $.name }_view'\n                }\n            ],\n            imports: {\n                imageItems: '${ $.mediaGalleryProvider }:data.items'\n            },\n            listens: {\n                imageItems: 'checkButtonVisibility'\n            },\n            exports: {\n                massActionMode: '${ $.name }_view:massActionMode'\n            }\n        },\n\n        /**\n         * Initializes media gallery massaction component.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        initialize: function () {\n            this._super().observe([\n                'massActionMode'\n            ]);\n            this.initView();\n            this.initEvents();\n\n            return this;\n        },\n\n        /**\n         * Initialize child components\n         *\n         * @returns {Object}\n         */\n        initView: function () {\n            Layout(this.viewConfig);\n\n            return this;\n        },\n\n        /**\n         * Initilize massactions events for media gallery grid.\n         */\n        initEvents: function () {\n            $(window).on('massAction.MediaGallery', function () {\n                if (this.massActionMode()) {\n                    return;\n                }\n                this.imageModel().selected(null);\n                this.massActionMode(true);\n                this.switchMode();\n            }.bind(this));\n\n            $(window).on('terminateMassAction.MediaGallery', function () {\n                if (!this.massActionMode()) {\n                    return;\n                }\n\n                this.massActionMode(false);\n                this.switchMode();\n                this.imageModel().updateSelected();\n            }.bind(this));\n        },\n\n        /**\n         * Return total selected items.\n         */\n        getSelectedCount: function () {\n            if (this.massActionMode() && !_.isNull(this.imageModel().selected())) {\n                return Object.keys(this.imageModel().selected()).length;\n            }\n\n            return 0;\n        },\n\n        /**\n         * If images records less than one, disable \"delete images\" button\n         */\n        checkButtonVisibility: function () {\n            if (!this.allowedActions.includes('delete_assets')) {\n                return;\n            }\n\n            if (this.imageItems.length < 1) {\n                $(this.deleteImagesSelector).addClass('disabled');\n            } else {\n                $(this.deleteImagesSelector).removeClass('disabled');\n            }\n        },\n\n        /**\n         * Switch massaction per current event.\n         */\n        switchMode: function () {\n            this.massactionView().switchView();\n            this.handleDeleteAction();\n        },\n\n        /**\n         * Change Default  behavior of delete image to bulk deletion.\n         */\n        handleDeleteAction: function () {\n            if (this.massActionMode()) {\n                $(this.deleteButtonSelector).on('massDelete.MediaGallery', function () {\n                    if (this.getSelectedCount() < 1) {\n                        uiAlert({\n                            content: $t('You need to select at least one image')\n                        });\n\n                    } else {\n                        DeleteImages.deleteImageAction(\n                            this.imageModel().selected(),\n                            this.mediaGalleryImageDetails().imageDetailsUrl,\n                            this.imageModel().deleteImageUrl\n                        ).then(function (response) {\n                            if (response.status === 'canceled') {\n                                return;\n                            }\n                            $(window).trigger('terminateMassAction.MediaGallery');\n                        });\n                    }\n                }.bind(this));\n            }\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/grid/massaction/massactionView.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'uiComponent',\n    'mage/translate',\n    'text!Magento_MediaGalleryUi/template/grid/massactions/massactionButtons.html'\n], function ($, Component, $t, massactionButtons) {\n    'use strict';\n\n    return Component.extend({\n        defaults: {\n            gridSelector: '[data-id=\"media-gallery-masonry-grid\"]',\n            standAloneTitle: 'Manage Gallery',\n            slidePanelTitle: 'Media Gallery',\n            defaultTitle: null,\n            are: null,\n            standAloneArea: 'standalone',\n            slidepanelArea: 'slidepanel',\n            massactionButtonsSelector: '.massaction-buttons',\n            buttonsSelectorStandalone: '.page-actions-buttons',\n            buttonsSelectorSlidePanel: '.page-actions.floating-header',\n            buttons: '.page-main-actions :button',\n            massactionModeTitle: $t('Select Images to Delete')\n        },\n\n        /**\n         * Initializes media gallery massaction component.\n         *\n         * @returns {Sticky} Chainable.\n         */\n        initialize: function () {\n            this._super().observe([\n                'massActionMode'\n            ]);\n\n            return this;\n        },\n\n        /**\n         * Switch massaction view state per active mode.\n         */\n        switchView: function () {\n            this.changePageTitle();\n            this.switchButtons();\n        },\n\n        /**\n         * Hide or show buttons per active mode.\n         */\n        switchButtons: function () {\n            if (this.massActionMode()) {\n                this.activateMassactionButtonView();\n            } else {\n                this.revertButtonsToDefaultView();\n            }\n        },\n\n        /**\n         * Sets buttons to default regular -mode view.\n         */\n        revertButtonsToDefaultView: function () {\n            $(this.buttons).removeClass('no-display');\n            $(this.massactionButtonsSelector).remove();\n        },\n\n        /**\n          * Activate mass action buttons view\n          */\n        activateMassactionButtonView: function () {\n            var buttonsContainer;\n\n            $(this.buttons).addClass('no-display');\n\n            buttonsContainer =  this.area === this.standAloneArea ?\n                this.buttonsSelectorStandalone :\n                this.buttonsSelectorSlidePanel;\n\n            $(buttonsContainer).append(massactionButtons);\n            $(this.massactionButtonsSelector).applyBindings();\n        },\n\n        /**\n         * Change page title per active mode.\n         */\n        changePageTitle: function () {\n            var title = $('h1:contains(' + this.standAloneTitle + ')'),\n                titleSelector;\n\n            if (title.length === 1)  {\n                titleSelector = title;\n                this.area = this.standAloneArea;\n            } else {\n                titleSelector = $('h1:contains(' + this.slidePanelTitle + ')');\n                this.area = this.slidepanelArea;\n            }\n\n            if (this.massActionMode()) {\n                this.defaultTitle = titleSelector.text();\n                titleSelector.text(this.massactionModeTitle);\n            } else {\n                titleSelector = $('h1:contains(' + this.massactionModeTitle + ')');\n                titleSelector.text(this.defaultTitle);\n            }\n        }\n    });\n});\n","Magento_MediaGalleryUi/js/image/image-actions.js":"/**\n * Copyright \u00a9 Magento, Inc. All rights reserved.\n * See COPYING.txt for license details.\n */\n\ndefine([\n    'jquery',\n    'underscore',\n    'uiElement',\n    'Magento_MediaGalleryUi/js/action/deleteImageWithDetailConfirmation',\n    'Magento_MediaGalleryUi/js/grid/columns/image/insertImageAction',\n    'Magento_MediaGalleryUi/js/action/saveDetails',\n    'mage/validation'\n], function ($, _, Element, deleteImageWithDetailConfirmation, addSelected, saveDetails) {\n    'use strict';\n\n    return Element.extend({\n        defaults: {\n            modalSelector: '',\n            modalWindowSelector: '',\n            mediaGalleryImageDetailsName: 'mediaGalleryImageDetails',\n            mediaGalleryEditDetailsName: 'mediaGalleryEditDetails',\n            template: 'Magento_MediaGalleryUi/image/actions',\n            modules: {\n                imageModel: '${ $.imageModelName }',\n                mediaGalleryImageDetails: '${ $.mediaGalleryImageDetailsName }',\n                mediaGalleryEditDetails: '${ $.mediaGalleryEditDetailsName }'\n            }\n        },\n\n        /**\n         * Initialize the component\n         *\n         * @returns {Object}\n         */\n        initialize: function () {\n            this._super();\n            $(window).on('fileDeleted.enhancedMediaGallery', this.closeViewDetailsModal.bind(this));\n\n            return this;\n        },\n\n        /**\n         * Close the images details modal\n         */\n        closeModal: function () {\n            var modalElement = $(this.modalSelector),\n                modalWindow = $(this.modalWindowSelector);\n\n            if (!modalWindow.