require.config({"config": {
        "jsbuild":{"jquery/jstree/jquery.jstree.js":"/*globals jQuery, define, module, exports, require, window, document, postMessage */\n(function (factory) {\n    \"use strict\";\n    if (typeof define === 'function' && define.amd) {\n        define(['jquery'], factory);\n    }\n    else if(typeof module !== 'undefined' && module.exports) {\n        module.exports = factory(require('jquery'));\n    }\n    else {\n        factory(jQuery);\n    }\n}(function ($, undefined) {\n    \"use strict\";\n    /*!\n * jsTree 3.3.12\n * http://jstree.com/\n *\n * Copyright (c) 2014 Ivan Bozhanov (http://vakata.com)\n *\n * Licensed same as jquery - under the terms of the MIT License\n *   http://www.opensource.org/licenses/mit-license.php\n */\n    /*!\n * if using jslint please allow for the jQuery global and use following options:\n * jslint: loopfunc: true, browser: true, ass: true, bitwise: true, continue: true, nomen: true, plusplus: true, regexp: true, unparam: true, todo: true, white: true\n */\n    /*jshint -W083 */\n\n    // prevent another load? maybe there is a better way?\n    if($.jstree) {\n        return;\n    }\n\n    /**\n     * ### jsTree core functionality\n     */\n\n        // internal variables\n    var instance_counter = 0,\n        ccp_node = false,\n        ccp_mode = false,\n        ccp_inst = false,\n        themes_loaded = [],\n        src = $('script:last').attr('src'),\n        document = window.document; // local variable is always faster to access then a global\n\n    var setImmediate = window.setImmediate;\n    var Promise = window.Promise;\n    if (!setImmediate && Promise) {\n        // Good enough approximation of setImmediate\n        setImmediate = function (cb, arg) {\n            Promise.resolve(arg).then(cb);\n        };\n    }\n\n    /**\n     * holds all jstree related functions and variables, including the actual class and methods to create, access and manipulate instances.\n     * @name $.jstree\n     */\n    $.jstree = {\n        /**\n         * specifies the jstree version in use\n         * @name $.jstree.version\n         */\n        version : '3.3.12',\n        /**\n         * holds all the default options used when creating new instances\n         * @name $.jstree.defaults\n         */\n        defaults : {\n            /**\n             * configure which plugins will be active on an instance. Should be an array of strings, where each element is a plugin name. The default is `[]`\n             * @name $.jstree.defaults.plugins\n             */\n            plugins : []\n        },\n        /**\n         * stores all loaded jstree plugins (used internally)\n         * @name $.jstree.plugins\n         */\n        plugins : {},\n        path : src && src.indexOf('/') !== -1 ? src.replace(/\\/[^\\/]+$/,'') : '',\n        idregex : /[\\\\:&!^|()\\[\\]<>@*'+~#\";.,=\\- \\/${}%?`]/g,\n        root : '#'\n    };\n\n    /**\n     * creates a jstree instance\n     * @name $.jstree.create(el [, options])\n     * @param {DOMElement|jQuery|String} el the element to create the instance on, can be jQuery extended or a selector\n     * @param {Object} options options for this instance (extends `$.jstree.defaults`)\n     * @return {jsTree} the new instance\n     */\n    $.jstree.create = function (el, options) {\n        var tmp = new $.jstree.core(++instance_counter),\n            opt = options;\n        options = $.extend(true, {}, $.jstree.defaults, options);\n        if(opt && opt.plugins) {\n            options.plugins = opt.plugins;\n        }\n        $.each(options.plugins, function (i, k) {\n            if(i !== 'core') {\n                tmp = tmp.plugin(k, options[k]);\n            }\n        });\n        $(el).data('jstree', tmp);\n        tmp.init(el, options);\n        return tmp;\n    };\n    /**\n     * remove all traces of jstree from the DOM and destroy all instances\n     * @name $.jstree.destroy()\n     */\n    $.jstree.destroy = function () {\n        $('.jstree:jstree').jstree('destroy');\n        $(document).off('.jstree');\n    };\n    /**\n     * the jstree class constructor, used only internally\n     * @private\n     * @name $.jstree.core(id)\n     * @param {Number} id this instance's index\n     */\n    $.jstree.core = function (id) {\n        this._id = id;\n        this._cnt = 0;\n        this._wrk = null;\n        this._data = {\n            core : {\n                themes : {\n                    name : false,\n                    dots : false,\n                    icons : false,\n                    ellipsis : false\n                },\n                selected : [],\n                last_error : {},\n                working : false,\n                worker_queue : [],\n                focused : null\n            }\n        };\n    };\n    /**\n     * get a reference to an existing instance\n     *\n     * __Examples__\n     *\n     *\t// provided a container with an ID of \"tree\", and a nested node with an ID of \"branch\"\n     *\t// all of there will return the same instance\n     *\t$.jstree.reference('tree');\n     *\t$.jstree.reference('#tree');\n     *\t$.jstree.reference($('#tree'));\n     *\t$.jstree.reference(document.getElementByID('tree'));\n     *\t$.jstree.reference('branch');\n     *\t$.jstree.reference('#branch');\n     *\t$.jstree.reference($('#branch'));\n     *\t$.jstree.reference(document.getElementByID('branch'));\n     *\n     * @name $.jstree.reference(needle)\n     * @param {DOMElement|jQuery|String} needle\n     * @return {jsTree|null} the instance or `null` if not found\n     */\n    $.jstree.reference = function (needle) {\n        var tmp = null,\n            obj = null;\n        if(needle && needle.id && (!needle.tagName || !needle.nodeType)) { needle = needle.id; }\n\n        if(!obj || !obj.length) {\n            try { obj = $(needle); } catch (ignore) { }\n        }\n        if(!obj || !obj.length) {\n            try { obj = $('#' + needle.replace($.jstree.idregex,'\\\\$&')); } catch (ignore) { }\n        }\n        if(obj && obj.length && (obj = obj.closest('.jstree')).length && (obj = obj.data('jstree'))) {\n            tmp = obj;\n        }\n        else {\n            $('.jstree').each(function () {\n                var inst = $(this).data('jstree');\n                if(inst && inst._model.data[needle]) {\n                    tmp = inst;\n                    return false;\n                }\n            });\n        }\n        return tmp;\n    };\n    /**\n     * Create an instance, get an instance or invoke a command on a instance.\n     *\n     * If there is no instance associated with the current node a new one is created and `arg` is used to extend `$.jstree.defaults` for this new instance. There would be no return value (chaining is not broken).\n     *\n     * If there is an existing instance and `arg` is a string the command specified by `arg` is executed on the instance, with any additional arguments passed to the function. If the function returns a value it will be returned (chaining could break depending on function).\n     *\n     * If there is an existing instance and `arg` is not a string the instance itself is returned (similar to `$.jstree.reference`).\n     *\n     * In any other case - nothing is returned and chaining is not broken.\n     *\n     * __Examples__\n     *\n     *\t$('#tree1').jstree(); // creates an instance\n     *\t$('#tree2').jstree({ plugins : [] }); // create an instance with some options\n     *\t$('#tree1').jstree('open_node', '#branch_1'); // call a method on an existing instance, passing additional arguments\n     *\t$('#tree2').jstree(); // get an existing instance (or create an instance)\n     *\t$('#tree2').jstree(true); // get an existing instance (will not create new instance)\n     *\t$('#branch_1').jstree().select_node('#branch_1'); // get an instance (using a nested element and call a method)\n     *\n     * @name $().jstree([arg])\n     * @param {String|Object} arg\n     * @return {Mixed}\n     */\n    $.fn.jstree = function (arg) {\n        // check for string argument\n        var is_method\t= (typeof arg === 'string'),\n            args\t\t= Array.prototype.slice.call(arguments, 1),\n            result\t\t= null;\n        if(arg === true && !this.length) { return false; }\n        this.each(function () {\n            // get the instance (if there is one) and method (if it exists)\n            var instance = $.jstree.reference(this),\n                method = is_method && instance ? instance[arg] : null;\n            // if calling a method, and method is available - execute on the instance\n            result = is_method && method ?\n                method.apply(instance, args) :\n                null;\n            // if there is no instance and no method is being called - create one\n            if(!instance && !is_method && (arg === undefined || $.isPlainObject(arg))) {\n                $.jstree.create(this, arg);\n            }\n            // if there is an instance and no method is called - return the instance\n            if( (instance && !is_method) || arg === true ) {\n                result = instance || false;\n            }\n            // if there was a method call which returned a result - break and return the value\n            if(result !== null && result !== undefined) {\n                return false;\n            }\n        });\n        // if there was a method call with a valid return value - return that, otherwise continue the chain\n        return result !== null && result !== undefined ?\n            result : this;\n    };\n    /**\n     * used to find elements containing an instance\n     *\n     * __Examples__\n     *\n     *\t$('div:jstree').each(function () {\n     *\t\t$(this).jstree('destroy');\n     *\t});\n     *\n     * @name $(':jstree')\n     * @return {jQuery}\n     */\n    $.expr.pseudos.jstree = $.expr.createPseudo(function(search) {\n        return function(a) {\n            return $(a).hasClass('jstree') &&\n                $(a).data('jstree') !== undefined;\n        };\n    });\n\n    /**\n     * stores all defaults for the core\n     * @name $.jstree.defaults.core\n     */\n    $.jstree.defaults.core = {\n        /**\n         * data configuration\n         *\n         * If left as `false` the HTML inside the jstree container element is used to populate the tree (that should be an unordered list with list items).\n         *\n         * You can also pass in a HTML string or a JSON array here.\n         *\n         * It is possible to pass in a standard jQuery-like AJAX config and jstree will automatically determine if the response is JSON or HTML and use that to populate the tree.\n         * In addition to the standard jQuery ajax options here you can supply functions for `data` and `url`, the functions will be run in the current instance's scope and a param will be passed indicating which node is being loaded, the return value of those functions will be used.\n         *\n         * The last option is to specify a function, that function will receive the node being loaded as argument and a second param which is a function which should be called with the result.\n         *\n         * __Examples__\n         *\n         *\t// AJAX\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'data' : {\n         *\t\t\t\t'url' : '/get/children/',\n         *\t\t\t\t'data' : function (node) {\n         *\t\t\t\t\treturn { 'id' : node.id };\n         *\t\t\t\t}\n         *\t\t\t}\n         *\t\t});\n         *\n         *\t// direct data\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'data' : [\n         *\t\t\t\t'Simple root node',\n         *\t\t\t\t{\n         *\t\t\t\t\t'id' : 'node_2',\n         *\t\t\t\t\t'text' : 'Root node with options',\n         *\t\t\t\t\t'state' : { 'opened' : true, 'selected' : true },\n         *\t\t\t\t\t'children' : [ { 'text' : 'Child 1' }, 'Child 2']\n         *\t\t\t\t}\n         *\t\t\t]\n         *\t\t}\n         *\t});\n         *\n         *\t// function\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'data' : function (obj, callback) {\n         *\t\t\t\tcallback.call(this, ['Root 1', 'Root 2']);\n         *\t\t\t}\n         *\t\t});\n         *\n         * @name $.jstree.defaults.core.data\n         */\n        data\t\t\t: false,\n        /**\n         * configure the various strings used throughout the tree\n         *\n         * You can use an object where the key is the string you need to replace and the value is your replacement.\n         * Another option is to specify a function which will be called with an argument of the needed string and should return the replacement.\n         * If left as `false` no replacement is made.\n         *\n         * __Examples__\n         *\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'strings' : {\n         *\t\t\t\t'Loading ...' : 'Please wait ...'\n         *\t\t\t}\n         *\t\t}\n         *\t});\n         *\n         * @name $.jstree.defaults.core.strings\n         */\n        strings\t\t\t: false,\n        /**\n         * determines what happens when a user tries to modify the structure of the tree\n         * If left as `false` all operations like create, rename, delete, move or copy are prevented.\n         * You can set this to `true` to allow all interactions or use a function to have better control.\n         *\n         * __Examples__\n         *\n         *\t$('#tree').jstree({\n         *\t\t'core' : {\n         *\t\t\t'check_callback' : function (operation, node, node_parent, node_position, more) {\n         *\t\t\t\t// operation can be 'create_node', 'rename_node', 'delete_node', 'move_node', 'copy_node' or 'edit'\n         *\t\t\t\t// in case of 'rename_node' node_position is filled with the new node name\n         *\t\t\t\treturn operation === 'rename_node' ? true : false;\n         *\t\t\t}\n         *\t\t}\n         *\t});\n         *\n         * @name $.jstree.defaults.core.check_callback\n         */\n        check_callback\t: false,\n        /**\n         * a callback called with a single object parameter in the instance's scope when something goes wrong (operation prevented, ajax failed, etc)\n         * @name $.jstree.defaults.core.error\n         */\n        error\t\t\t: $.noop,\n        /**\n         * the open / close animation duration in milliseconds - set this to `false` to disable the animation (default is `200`)\n         * @name $.jstree.defaults.core.animation\n         */\n        animation\t\t: 200,\n        /**\n         * a boolean indicating if multiple nodes can be selected\n         * @name $.jstree.defaults.core.multiple\n         */\n        multiple\t\t: true,\n        /**\n         * theme configuration object\n         * @name $.jstree.defaults.core.themes\n         */\n        themes\t\t\t: {\n            /**\n             * the name of the theme to use (if left as `false` the default theme is used)\n             * @name $.jstree.defaults.core.themes.name\n             */\n            name\t\t\t: false,\n            /**\n             * the URL of the theme's CSS file, leave this as `false` if you have manually included the theme CSS (recommended). You can set this to `true` too which will try to autoload the theme.\n             * @name $.jstree.defaults.core.themes.url\n             */\n            url\t\t\t\t: false,\n            /**\n             * the location of all jstree themes - only used if `url` is set to `true`\n             * @name $.jstree.defaults.core.themes.dir\n             */\n            dir\t\t\t\t: false,\n            /**\n             * a boolean indicating if connecting dots are shown\n             * @name $.jstree.defaults.core.themes.dots\n             */\n            dots\t\t\t: true,\n            /**\n             * a boolean indicating if node icons are shown\n             * @name $.jstree.defaults.core.themes.icons\n             */\n            icons\t\t\t: true,\n            /**\n             * a boolean indicating if node ellipsis should be shown - this only works with a fixed with on the container\n             * @name $.jstree.defaults.core.themes.ellipsis\n             */\n            ellipsis\t\t: false,\n            /**\n             * a boolean indicating if the tree background is striped\n             * @name $.jstree.defaults.core.themes.stripes\n             */\n            stripes\t\t\t: false,\n            /**\n             * a string (or boolean `false`) specifying the theme variant to use (if the theme supports variants)\n             * @name $.jstree.defaults.core.themes.variant\n             */\n            variant\t\t\t: false,\n            /**\n             * a boolean specifying if a reponsive version of the theme should kick in on smaller screens (if the theme supports it). Defaults to `false`.\n             * @name $.jstree.defaults.core.themes.responsive\n             */\n            responsive\t\t: false\n        },\n        /**\n         * if left as `true` all parents of all selected nodes will be opened once the tree loads (so that all selected nodes are visible to the user)\n         * @name $.jstree.defaults.core.expand_selected_onload\n         */\n        expand_selected_onload : true,\n        /**\n         * if left as `true` web workers will be used to parse incoming JSON data where possible, so that the UI will not be blocked by large requests. Workers are however about 30% slower. Defaults to `true`\n         * @name $.jstree.defaults.core.worker\n         */\n        worker : true,\n        /**\n         * Force node text to plain text (and escape HTML). Defaults to `false`\n         * @name $.jstree.defaults.core.force_text\n         */\n        force_text : false,\n        /**\n         * Should the node be toggled if the text is double clicked. Defaults to `true`\n         * @name $.jstree.defaults.core.dblclick_toggle\n         */\n        dblclick_toggle : true,\n        /**\n         * Should the loaded nodes be part of the state. Defaults to `false`\n         * @name $.jstree.defaults.core.loaded_state\n         */\n        loaded_state : false,\n        /**\n         * Should the last active node be focused when the tree container is blurred and the focused again. This helps working with screen readers. Defaults to `true`\n         * @name $.jstree.defaults.core.restore_focus\n         */\n        restore_focus : true,\n        /**\n         * Force to compute and set \"aria-setsize\" and \"aria-posinset\" explicitly for each treeitem.\n         * Some browsers may compute incorrect elements position and produce wrong announcements for screen readers. Defaults to `false`\n         * @name $.jstree.defaults.core.compute_elements_positions\n         */\n        compute_elements_positions : false,\n        /**\n         * Default keyboard shortcuts (an object where each key is the button name or combo - like 'enter', 'ctrl-space', 'p', etc and the value is the function to execute in the instance's scope)\n         * @name $.jstree.defaults.core.keyboard\n         */\n        keyboard : {\n            'ctrl-space': function (e) {\n                // aria defines space only with Ctrl\n                e.type = \"click\";\n                $(e.currentTarget).trigger(e);\n            },\n            'enter': function (e) {\n                // enter\n                e.type = \"click\";\n                $(e.currentTarget).trigger(e);\n            },\n            'left': function (e) {\n                // left\n                e.preventDefault();\n                if(this.is_open(e.currentTarget)) {\n                    this.close_node(e.currentTarget);\n                }\n                else {\n                    var o = this.get_parent(e.currentTarget);\n                    if(o && o.id !== $.jstree.root) { this.get_node(o, true).children('.jstree-anchor').trigger('focus'); }\n                }\n            },\n            'up': function (e) {\n                // up\n                e.preventDefault();\n                var o = this.get_prev_dom(e.currentTarget);\n                if(o && o.length) { o.children('.jstree-anchor').trigger('focus'); }\n            },\n            'right': function (e) {\n                // right\n                e.preventDefault();\n                if(this.is_closed(e.currentTarget)) {\n                    this.open_node(e.currentTarget, function (o) { this.get_node(o, true).children('.jstree-anchor').trigger('focus'); });\n                }\n                else if (this.is_open(e.currentTarget)) {\n                    var o = this.get_node(e.currentTarget, true).children('.jstree-children')[0];\n                    if(o) { $(this._firstChild(o)).children('.jstree-anchor').trigger('focus'); }\n                }\n            },\n            'down': function (e) {\n                // down\n                e.preventDefault();\n                var o = this.get_next_dom(e.currentTarget);\n                if(o && o.length) { o.children('.jstree-anchor').trigger('focus'); }\n            },\n            '*': function (e) {\n                // aria defines * on numpad as open_all - not very common\n                this.open_all();\n            },\n            'home': function (e) {\n                // home\n                e.preventDefault();\n                var o = this._firstChild(this.get_container_ul()[0]);\n                if(o) { $(o).children('.jstree-anchor').filter(':visible').trigger('focus'); }\n            },\n            'end': function (e) {\n                // end\n                e.preventDefault();\n                this.element.find('.jstree-anchor').filter(':visible').last().trigger('focus');\n            },\n            'f2': function (e) {\n                // f2 - safe to include - if check_callback is false it will fail\n                e.preventDefault();\n                this.edit(e.currentTarget);\n            }\n        }\n    };\n    $.jstree.core.prototype = {\n        /**\n         * used to decorate an instance with a plugin. Used internally.\n         * @private\n         * @name plugin(deco [, opts])\n         * @param  {String} deco the plugin to decorate with\n         * @param  {Object} opts options for the plugin\n         * @return {jsTree}\n         */\n        plugin : function (deco, opts) {\n            var Child = $.jstree.plugins[deco];\n            if(Child) {\n                this._data[deco] = {};\n                Child.prototype = this;\n                return new Child(opts, this);\n            }\n            return this;\n        },\n        /**\n         * initialize the instance. Used internally.\n         * @private\n         * @name init(el, optons)\n         * @param {DOMElement|jQuery|String} el the element we are transforming\n         * @param {Object} options options for this instance\n         * @trigger init.jstree, loading.jstree, loaded.jstree, ready.jstree, changed.jstree\n         */\n        init : function (el, options) {\n            this._model = {\n                data : {},\n                changed : [],\n                force_full_redraw : false,\n                redraw_timeout : false,\n                default_state : {\n                    loaded : true,\n                    opened : false,\n                    selected : false,\n                    disabled : false\n                }\n            };\n            this._model.data[$.jstree.root] = {\n                id : $.jstree.root,\n                parent : null,\n                parents : [],\n                children : [],\n                children_d : [],\n                state : { loaded : false }\n            };\n\n            this.element = $(el).addClass('jstree jstree-' + this._id);\n            this.settings = options;\n\n            this._data.core.ready = false;\n            this._data.core.loaded = false;\n            this._data.core.rtl = (this.element.css(\"direction\") === \"rtl\");\n            this.element[this._data.core.rtl ? 'addClass' : 'removeClass'](\"jstree-rtl\");\n            this.element.attr('role','tree');\n            if(this.settings.core.multiple) {\n                this.element.attr('aria-multiselectable', true);\n            }\n            if(!this.element.attr('tabindex')) {\n                this.element.attr('tabindex','0');\n            }\n\n            this.bind();\n            /**\n             * triggered after all events are bound\n             * @event\n             * @name init.jstree\n             */\n            this.trigger(\"init\");\n\n            this._data.core.original_container_html = this.element.find(\" > ul > li\").clone(true);\n            this._data.core.original_container_html\n                .find(\"li\").addBack()\n                .contents().filter(function() {\n                return this.nodeType === 3 && (!this.nodeValue || /^\\s+$/.test(this.nodeValue));\n            })\n                .remove();\n            this.element.html(\"<\"+\"ul class='jstree-container-ul jstree-children' role='group'><\"+\"li id='j\"+this._id+\"_loading' class='jstree-initial-node jstree-loading jstree-leaf jstree-last' role='none'><i class='jstree-icon jstree-ocl'></i><\"+\"a class='jstree-anchor' role='treeitem' href='#'><i class='jstree-icon jstree-themeicon-hidden'></i>\" + this.get_string(\"Loading ...\") + \"</a></li></ul>\");\n            this.element.attr('aria-activedescendant','j' + this._id + '_loading');\n            this._data.core.li_height = this.get_container_ul().children(\"li\").first().outerHeight() || 24;\n            this._data.core.node = this._create_prototype_node();\n            /**\n             * triggered after the loading text is shown and before loading starts\n             * @event\n             * @name loading.jstree\n             */\n            this.trigger(\"loading\");\n            this.load_node($.jstree.root);\n        },\n        /**\n         * destroy an instance\n         * @name destroy()\n         * @param  {Boolean} keep_html if not set to `true` the container will be emptied, otherwise the current DOM elements will be kept intact\n         */\n        destroy : function (keep_html) {\n            /**\n             * triggered before the tree is destroyed\n             * @event\n             * @name destroy.jstree\n             */\n            this.trigger(\"destroy\");\n            if(this._wrk) {\n                try {\n                    window.URL.revokeObjectURL(this._wrk);\n                    this._wrk = null;\n                }\n                catch (ignore) { }\n            }\n            if(!keep_html) { this.element.empty(); }\n            this.teardown();\n        },\n        /**\n         * Create a prototype node\n         * @name _create_prototype_node()\n         * @return {DOMElement}\n         */\n        _create_prototype_node : function () {\n            var _node = document.createElement('LI'), _temp1, _temp2;\n            _node.setAttribute('role', 'none');\n            _temp1 = document.createElement('I');\n            _temp1.className = 'jstree-icon jstree-ocl';\n            _temp1.setAttribute('role', 'presentation');\n            _node.appendChild(_temp1);\n            _temp1 = document.createElement('A');\n            _temp1.className = 'jstree-anchor';\n            _temp1.setAttribute('href','#');\n            _temp1.setAttribute('tabindex','-1');\n            _temp1.setAttribute('role', 'treeitem');\n            _temp2 = document.createElement('I');\n            _temp2.className = 'jstree-icon jstree-themeicon';\n            _temp2.setAttribute('role', 'presentation');\n            _temp1.appendChild(_temp2);\n            _node.appendChild(_temp1);\n            _temp1 = _temp2 = null;\n\n            return _node;\n        },\n        _kbevent_to_func : function (e) {\n            var keys = {\n                8: \"Backspace\", 9: \"Tab\", 13: \"Enter\", 19: \"Pause\", 27: \"Esc\",\n                32: \"Space\", 33: \"PageUp\", 34: \"PageDown\", 35: \"End\", 36: \"Home\",\n                37: \"Left\", 38: \"Up\", 39: \"Right\", 40: \"Down\", 44: \"Print\", 45: \"Insert\",\n                46: \"Delete\", 96: \"Numpad0\", 97: \"Numpad1\", 98: \"Numpad2\", 99 : \"Numpad3\",\n                100: \"Numpad4\", 101: \"Numpad5\", 102: \"Numpad6\", 103: \"Numpad7\",\n                104: \"Numpad8\", 105: \"Numpad9\", '-13': \"NumpadEnter\", 112: \"F1\",\n                113: \"F2\", 114: \"F3\", 115: \"F4\", 116: \"F5\", 117: \"F6\", 118: \"F7\",\n                119: \"F8\", 120: \"F9\", 121: \"F10\", 122: \"F11\", 123: \"F12\", 144: \"Numlock\",\n                145: \"Scrolllock\", 16: 'Shift', 17: 'Ctrl', 18: 'Alt',\n                48: '0',  49: '1',  50: '2',  51: '3',  52: '4', 53:  '5',\n                54: '6',  55: '7',  56: '8',  57: '9',  59: ';',  61: '=', 65:  'a',\n                66: 'b',  67: 'c',  68: 'd',  69: 'e',  70: 'f',  71: 'g', 72:  'h',\n                73: 'i',  74: 'j',  75: 'k',  76: 'l',  77: 'm',  78: 'n', 79:  'o',\n                80: 'p',  81: 'q',  82: 'r',  83: 's',  84: 't',  85: 'u', 86:  'v',\n                87: 'w',  88: 'x',  89: 'y',  90: 'z', 107: '+', 109: '-', 110: '.',\n                186: ';', 187: '=', 188: ',', 189: '-', 190: '.', 191: '/', 192: '`',\n                219: '[', 220: '\\\\',221: ']', 222: \"'\", 111: '/', 106: '*', 173: '-'\n            };\n            var parts = [];\n            if (e.ctrlKey) { parts.push('ctrl'); }\n            if (e.altKey) { parts.push('alt'); }\n            if (e.shiftKey) { parts.push('shift'); }\n            parts.push(keys[e.which] || e.which);\n            parts = parts.sort().join('-').toLowerCase();\n            if (parts === 'shift-shift' || parts === 'ctrl-ctrl' || parts === 'alt-alt') {\n                return null;\n            }\n\n            var kb = this.settings.core.keyboard, i, tmp;\n            for (i in kb) {\n                if (kb.hasOwnProperty(i)) {\n                    tmp = i;\n                    if (tmp !== '-' && tmp !== '+') {\n                        tmp = tmp.replace('--', '-MINUS').replace('+-', '-MINUS').replace('++', '-PLUS').replace('-+', '-PLUS');\n                        tmp = tmp.split(/-|\\+/).sort().join('-').replace('MINUS', '-').replace('PLUS', '+').toLowerCase();\n                    }\n                    if (tmp === parts) {\n                        return kb[i];\n                    }\n                }\n            }\n            return null;\n        },\n        /**\n         * part of the destroying of an instance. Used internally.\n         * @private\n         * @name teardown()\n         */\n        teardown : function () {\n            this.unbind();\n            this.element\n                .removeClass('jstree')\n                .removeData('jstree')\n                .find(\"[class^='jstree']\")\n                .addBack()\n                .attr(\"class\", function () { return this.className.replace(/jstree[^ ]*|$/ig,''); });\n            this.element = null;\n        },\n        /**\n         * bind all events. Used internally.\n         * @private\n         * @name bind()\n         */\n        bind : function () {\n            var word = '',\n                tout = null,\n                was_click = 0;\n            this.element\n                .on(\"dblclick.jstree\", function (e) {\n                    if(e.target.tagName && e.target.tagName.toLowerCase() === \"input\") { return true; }\n                    if(document.selection && document.selection.empty) {\n                        document.selection.empty();\n                    }\n                    else {\n                        if(window.getSelection) {\n                            var sel = window.getSelection();\n                            try {\n                                sel.removeAllRanges();\n                                sel.collapse();\n                            } catch (ignore) { }\n                        }\n                    }\n                })\n                .on(\"mousedown.jstree\", function (e) {\n                    if(e.target === this.element[0]) {\n                        e.preventDefault(); // prevent losing focus when clicking scroll arrows (FF, Chrome)\n                        was_click = +(new Date()); // ie does not allow to prevent losing focus\n                    }\n                }.bind(this))\n                .on(\"mousedown.jstree\", \".jstree-ocl\", function (e) {\n                    e.preventDefault(); // prevent any node inside from losing focus when clicking the open/close icon\n                })\n                .on(\"click.jstree\", \".jstree-ocl\", function (e) {\n                    this.toggle_node(e.target);\n                }.bind(this))\n                .on(\"dblclick.jstree\", \".jstree-anchor\", function (e) {\n                    if(e.target.tagName && e.target.tagName.toLowerCase() === \"input\") { return true; }\n                    if(this.settings.core.dblclick_toggle) {\n                        this.toggle_node(e.target);\n                    }\n                }.bind(this))\n                .on(\"click.jstree\", \".jstree-anchor\", function (e) {\n                    e.preventDefault();\n                    if(e.currentTarget !== document.activeElement) { $(e.currentTarget).trigger('focus'); }\n                    this.activate_node(e.currentTarget, e);\n                }.bind(this))\n                .on('keydown.jstree', '.jstree-anchor', function (e) {\n                    if(e.target.tagName && e.target.tagName.toLowerCase() === \"input\") { return true; }\n                    if(this._data.core.rtl) {\n                        if(e.which === 37) { e.which = 39; }\n                        else if(e.which === 39) { e.which = 37; }\n                    }\n                    var f = this._kbevent_to_func(e);\n                    if (f) {\n                        var r = f.call(this, e);\n                        if (r === false || r === true) {\n                            return r;\n                        }\n                    }\n                }.bind(this))\n                .on(\"load_node.jstree\", function (e, data) {\n                    if(data.status) {\n                        if(data.node.id === $.jstree.root && !this._data.core.loaded) {\n                            this._data.core.loaded = true;\n                            if(this._firstChild(this.get_container_ul()[0])) {\n                                this.element.attr('aria-activedescendant',this._firstChild(this.get_container_ul()[0]).id);\n                            }\n                            /**\n                             * triggered after the root node is loaded for the first time\n                             * @event\n                             * @name loaded.jstree\n                             */\n                            this.trigger(\"loaded\");\n                        }\n                        if(!this._data.core.ready) {\n                            setTimeout(function() {\n                                if(this.element && !this.get_container_ul().find('.jstree-loading').length) {\n                                    this._data.core.ready = true;\n                                    if(this._data.core.selected.length) {\n                                        if(this.settings.core.expand_selected_onload) {\n                                            var tmp = [], i, j;\n                                            for(i = 0, j = this._data.core.selected.length; i < j; i++) {\n                                                tmp = tmp.concat(this._model.data[this._data.core.selected[i]].parents);\n                                            }\n                                            tmp = $.vakata.array_unique(tmp);\n                                            for(i = 0, j = tmp.length; i < j; i++) {\n                                                this.open_node(tmp[i], false, 0);\n                                            }\n                                        }\n                                        this.trigger('changed', { 'action' : 'ready', 'selected' : this._data.core.selected });\n                                    }\n                                    /**\n                                     * triggered after all nodes are finished loading\n                                     * @event\n                                     * @name ready.jstree\n                                     */\n                                    this.trigger(\"ready\");\n                                }\n                            }.bind(this), 0);\n                        }\n                    }\n                }.bind(this))\n                // quick searching when the tree is focused\n                .on('keypress.jstree', function (e) {\n                    if(e.target.tagName && e.target.tagName.toLowerCase() === \"input\") { return true; }\n                    if(tout) { clearTimeout(tout); }\n                    tout = setTimeout(function () {\n                        word = '';\n                    }, 500);\n\n                    var chr = String.fromCharCode(e.which).toLowerCase(),\n                        col = this.element.find('.jstree-anchor').filter(':visible'),\n                        ind = col.index(document.activeElement) || 0,\n                        end = false;\n                    word += chr;\n\n                    // match for whole word from current node down (including the current node)\n                    if(word.length > 1) {\n                        col.slice(ind).each(function (i, v) {\n                            if($(v).text().toLowerCase().indexOf(word) === 0) {\n                                $(v).trigger('focus');\n                                end = true;\n                                return false;\n                            }\n                        }.bind(this));\n                        if(end) { return; }\n\n                        // match for whole word from the beginning of the tree\n                        col.slice(0, ind).each(function (i, v) {\n                            if($(v).text().toLowerCase().indexOf(word) === 0) {\n                                $(v).trigger('focus');\n                                end = true;\n                                return false;\n                            }\n                        }.bind(this));\n                        if(end) { return; }\n                    }\n                    // list nodes that start with that letter (only if word consists of a single char)\n                    if(new RegExp('^' + chr.replace(/[-\\/\\\\^$*+?.()|[\\]{}]/g, '\\\\$&') + '+$').test(word)) {\n                        // search for the next node starting with that letter\n                        col.slice(ind + 1).each(function (i, v) {\n                            if($(v).text().toLowerCase().charAt(0) === chr) {\n                                $(v).trigger('focus');\n                                end = true;\n                                return false;\n                            }\n                        }.bind(this));\n                        if(end) { return; }\n\n                        // search from the beginning\n                        col.slice(0, ind + 1).each(function (i, v) {\n                            if($(v).text().toLowerCase().charAt(0) === chr) {\n                                $(v).trigger('focus');\n                                end = true;\n                                return false;\n                            }\n                        }.bind(this));\n                        if(end) { return; }\n                    }\n                }.bind(this))\n                // THEME RELATED\n                .on(\"init.jstree\", function () {\n                    var s = this.settings.core.themes;\n                    this._data.core.themes.dots\t\t\t= s.dots;\n                    this._data.core.themes.stripes\t\t= s.stripes;\n                    this._data.core.themes.icons\t\t= s.icons;\n                    this._data.core.themes.ellipsis\t\t= s.ellipsis;\n                    this.set_theme(s.name || \"default\", s.url);\n                    this.set_theme_variant(s.variant);\n                }.bind(this))\n                .on(\"loading.jstree\", function () {\n                    this[ this._data.core.themes.dots ? \"show_dots\" : \"hide_dots\" ]();\n                    this[ this._data.core.themes.icons ? \"show_icons\" : \"hide_icons\" ]();\n                    this[ this._data.core.themes.stripes ? \"show_stripes\" : \"hide_stripes\" ]();\n                    this[ this._data.core.themes.ellipsis ? \"show_ellipsis\" : \"hide_ellipsis\" ]();\n                }.bind(this))\n                .on('blur.jstree', '.jstree-anchor', function (e) {\n                    this._data.core.focused = null;\n                    $(e.currentTarget).filter('.jstree-hovered').trigger('mouseleave');\n                    this.element.attr('tabindex', '0');\n                }.bind(this))\n                .on('focus.jstree', '.jstree-anchor', function (e) {\n                    var tmp = this.get_node(e.currentTarget);\n                    if(tmp && tmp.id) {\n                        this._data.core.focused = tmp.id;\n                    }\n                    this.element.find('.jstree-hovered').not(e.currentTarget).trigger('mouseleave');\n                    $(e.currentTarget).trigger('mouseenter');\n                    this.element.attr('tabindex', '-1');\n                }.bind(this))\n                .on('focus.jstree', function () {\n                    if(+(new Date()) - was_click > 500 && !this._data.core.focused && this.settings.core.restore_focus) {\n                        was_click = 0;\n                        var act = this.get_node(this.element.attr('aria-activedescendant'), true);\n                        if(act) {\n                            act.find('> .jstree-anchor').trigger('focus');\n                        }\n                    }\n                }.bind(this))\n                .on('mouseenter.jstree', '.jstree-anchor', function (e) {\n                    this.hover_node(e.currentTarget);\n                }.bind(this))\n                .on('mouseleave.jstree', '.jstree-anchor', function (e) {\n                    this.dehover_node(e.currentTarget);\n                }.bind(this));\n        },\n        /**\n         * part of the destroying of an instance. Used internally.\n         * @private\n         * @name unbind()\n         */\n        unbind : function () {\n            this.element.off('.jstree');\n            $(document).off('.jstree-' + this._id);\n        },\n        /**\n         * trigger an event. Used internally.\n         * @private\n         * @name trigger(ev [, data])\n         * @param  {String} ev the name of the event to trigger\n         * @param  {Object} data additional data to pass with the event\n         */\n        trigger : function (ev, data) {\n            if(!data) {\n                data = {};\n            }\n            data.instance = this;\n            this.element.triggerHandler(ev.replace('.jstree','') + '.jstree', data);\n        },\n        /**\n         * returns the jQuery extended instance container\n         * @name get_container()\n         * @return {jQuery}\n         */\n        get_container : function () {\n            return this.element;\n        },\n        /**\n         * returns the jQuery extended main UL node inside the instance container. Used internally.\n         * @private\n         * @name get_container_ul()\n         * @return {jQuery}\n         */\n        get_container_ul : function () {\n            return this.element.children(\".jstree-children\").first();\n        },\n        /**\n         * gets string replacements (localization). Used internally.\n         * @private\n         * @name get_string(key)\n         * @param  {String} key\n         * @return {String}\n         */\n        get_string : function (key) {\n            var a = this.settings.core.strings;\n            if($.vakata.is_function(a)) { return a.call(this, key); }\n            if(a && a[key]) { return a[key]; }\n            return key;\n        },\n        /**\n         * gets the first child of a DOM node. Used internally.\n         * @private\n         * @name _firstChild(dom)\n         * @param  {DOMElement} dom\n         * @return {DOMElement}\n         */\n        _firstChild : function (dom) {\n            dom = dom ? dom.firstChild : null;\n            while(dom !== null && dom.nodeType !== 1) {\n                dom = dom.nextSibling;\n            }\n            return dom;\n        },\n        /**\n         * gets the next sibling of a DOM node. Used internally.\n         * @private\n         * @name _nextSibling(dom)\n         * @param  {DOMElement} dom\n         * @return {DOMElement}\n         */\n        _nextSibling : function (dom) {\n            dom = dom ? dom.nextSibling : null;\n            while(dom !== null && dom.nodeType !== 1) {\n                dom = dom.nextSibling;\n            }\n            return dom;\n        },\n        /**\n         * gets the previous sibling of a DOM node. Used internally.\n         * @private\n         * @name _previousSibling(dom)\n         * @param  {DOMElement} dom\n         * @return {DOMElement}\n         */\n        _previousSibling : function (dom) {\n            dom = dom ? dom.previousSibling : null;\n            while(dom !== null && dom.nodeType !== 1) {\n                dom = dom.previousSibling;\n            }\n            return dom;\n        },\n        /**\n         * get the JSON representation of a node (or the actual jQuery extended DOM node) by using any input (child DOM element, ID string, selector, etc)\n         * @name get_node(obj [, as_dom])\n         * @param  {mixed} obj\n         * @param  {Boolean} as_dom\n         * @return {Object|jQuery}\n         */\n        get_node : function (obj, as_dom) {\n            if(obj && obj.id) {\n                obj = obj.id;\n            }\n            if (obj instanceof $ && obj.length && obj[0].id) {\n                obj = obj[0].id;\n            }\n            var dom;\n            try {\n                if(this._model.data[obj]) {\n                    obj = this._model.data[obj];\n                }\n                else if(typeof obj === \"string\" && this._model.data[obj.replace(/^#/, '')]) {\n                    obj = this._model.data[obj.replace(/^#/, '')];\n                }\n                else if(typeof obj === \"string\" && (dom = $('#' + obj.replace($.jstree.idregex,'\\\\$&'), this.element)).length && this._model.data[dom.closest('.jstree-node').attr('id')]) {\n                    obj = this._model.data[dom.closest('.jstree-node').attr('id')];\n                }\n                else if((dom = this.element.find(obj)).length && this._model.data[dom.closest('.jstree-node').attr('id')]) {\n                    obj = this._model.data[dom.closest('.jstree-node').attr('id')];\n                }\n                else if((dom = this.element.find(obj)).length && dom.hasClass('jstree')) {\n                    obj = this._model.data[$.jstree.root];\n                }\n                else {\n                    return false;\n                }\n\n                if(as_dom) {\n                    obj = obj.id === $.jstree.root ? this.element : $('#' + obj.id.replace($.jstree.idregex,'\\\\$&'), this.element);\n                }\n                return obj;\n            } catch (ex) { return false; }\n        },\n        /**\n         * get the path to a node, either consisting of node texts, or of node IDs, optionally glued together (otherwise an array)\n         * @name get_path(obj [, glue, ids])\n         * @param  {mixed} obj the node\n         * @param  {String} glue if you want the path as a string - pass the glue here (for example '/'), if a falsy value is supplied here, an array is returned\n         * @param  {Boolean} ids if set to true build the path using ID, otherwise node text is used\n         * @return {mixed}\n         */\n        get_path : function (obj, glue, ids) {\n            obj = obj.parents ? obj : this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root || !obj.parents) {\n                return false;\n            }\n            var i, j, p = [];\n            p.push(ids ? obj.id : obj.text);\n            for(i = 0, j = obj.parents.length; i < j; i++) {\n                p.push(ids ? obj.parents[i] : this.get_text(obj.parents[i]));\n            }\n            p = p.reverse().slice(1);\n            return glue ? p.join(glue) : p;\n        },\n        /**\n         * get the next visible node that is below the `obj` node. If `strict` is set to `true` only sibling nodes are returned.\n         * @name get_next_dom(obj [, strict])\n         * @param  {mixed} obj\n         * @param  {Boolean} strict\n         * @return {jQuery}\n         */\n        get_next_dom : function (obj, strict) {\n            var tmp;\n            obj = this.get_node(obj, true);\n            if(obj[0] === this.element[0]) {\n                tmp = this._firstChild(this.get_container_ul()[0]);\n                while (tmp && tmp.offsetHeight === 0) {\n                    tmp = this._nextSibling(tmp);\n                }\n                return tmp ? $(tmp) : false;\n            }\n            if(!obj || !obj.length) {\n                return false;\n            }\n            if(strict) {\n                tmp = obj[0];\n                do {\n                    tmp = this._nextSibling(tmp);\n                } while (tmp && tmp.offsetHeight === 0);\n                return tmp ? $(tmp) : false;\n            }\n            if(obj.hasClass(\"jstree-open\")) {\n                tmp = this._firstChild(obj.children('.jstree-children')[0]);\n                while (tmp && tmp.offsetHeight === 0) {\n                    tmp = this._nextSibling(tmp);\n                }\n                if(tmp !== null) {\n                    return $(tmp);\n                }\n            }\n            tmp = obj[0];\n            do {\n                tmp = this._nextSibling(tmp);\n            } while (tmp && tmp.offsetHeight === 0);\n            if(tmp !== null) {\n                return $(tmp);\n            }\n            return obj.parentsUntil(\".jstree\",\".jstree-node\").nextAll(\".jstree-node:visible\").first();\n        },\n        /**\n         * get the previous visible node that is above the `obj` node. If `strict` is set to `true` only sibling nodes are returned.\n         * @name get_prev_dom(obj [, strict])\n         * @param  {mixed} obj\n         * @param  {Boolean} strict\n         * @return {jQuery}\n         */\n        get_prev_dom : function (obj, strict) {\n            var tmp;\n            obj = this.get_node(obj, true);\n            if(obj[0] === this.element[0]) {\n                tmp = this.get_container_ul()[0].lastChild;\n                while (tmp && tmp.offsetHeight === 0) {\n                    tmp = this._previousSibling(tmp);\n                }\n                return tmp ? $(tmp) : false;\n            }\n            if(!obj || !obj.length) {\n                return false;\n            }\n            if(strict) {\n                tmp = obj[0];\n                do {\n                    tmp = this._previousSibling(tmp);\n                } while (tmp && tmp.offsetHeight === 0);\n                return tmp ? $(tmp) : false;\n            }\n            tmp = obj[0];\n            do {\n                tmp = this._previousSibling(tmp);\n            } while (tmp && tmp.offsetHeight === 0);\n            if(tmp !== null) {\n                obj = $(tmp);\n                while(obj.hasClass(\"jstree-open\")) {\n                    obj = obj.children(\".jstree-children\").first().children(\".jstree-node:visible:last\");\n                }\n                return obj;\n            }\n            tmp = obj[0].parentNode.parentNode;\n            return tmp && tmp.className && tmp.className.indexOf('jstree-node') !== -1 ? $(tmp) : false;\n        },\n        /**\n         * get the parent ID of a node\n         * @name get_parent(obj)\n         * @param  {mixed} obj\n         * @return {String}\n         */\n        get_parent : function (obj) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            return obj.parent;\n        },\n        /**\n         * get a jQuery collection of all the children of a node (node must be rendered), returns false on error\n         * @name get_children_dom(obj)\n         * @param  {mixed} obj\n         * @return {jQuery}\n         */\n        get_children_dom : function (obj) {\n            obj = this.get_node(obj, true);\n            if(obj[0] === this.element[0]) {\n                return this.get_container_ul().children(\".jstree-node\");\n            }\n            if(!obj || !obj.length) {\n                return false;\n            }\n            return obj.children(\".jstree-children\").children(\".jstree-node\");\n        },\n        /**\n         * checks if a node has children\n         * @name is_parent(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_parent : function (obj) {\n            obj = this.get_node(obj);\n            return obj && (obj.state.loaded === false || obj.children.length > 0);\n        },\n        /**\n         * checks if a node is loaded (its children are available)\n         * @name is_loaded(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_loaded : function (obj) {\n            obj = this.get_node(obj);\n            return obj && obj.state.loaded;\n        },\n        /**\n         * check if a node is currently loading (fetching children)\n         * @name is_loading(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_loading : function (obj) {\n            obj = this.get_node(obj);\n            return obj && obj.state && obj.state.loading;\n        },\n        /**\n         * check if a node is opened\n         * @name is_open(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_open : function (obj) {\n            obj = this.get_node(obj);\n            return obj && obj.state.opened;\n        },\n        /**\n         * check if a node is in a closed state\n         * @name is_closed(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_closed : function (obj) {\n            obj = this.get_node(obj);\n            return obj && this.is_parent(obj) && !obj.state.opened;\n        },\n        /**\n         * check if a node has no children\n         * @name is_leaf(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_leaf : function (obj) {\n            return !this.is_parent(obj);\n        },\n        /**\n         * loads a node (fetches its children using the `core.data` setting). Multiple nodes can be passed to by using an array.\n         * @name load_node(obj [, callback])\n         * @param  {mixed} obj\n         * @param  {function} callback a function to be executed once loading is complete, the function is executed in the instance's scope and receives two arguments - the node and a boolean status\n         * @return {Boolean}\n         * @trigger load_node.jstree\n         */\n        load_node : function (obj, callback) {\n            var k, l, i, j, c;\n            if($.vakata.is_array(obj)) {\n                this._load_nodes(obj.slice(), callback);\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj) {\n                if(callback) { callback.call(this, obj, false); }\n                return false;\n            }\n            // if(obj.state.loading) { } // the node is already loading - just wait for it to load and invoke callback? but if called implicitly it should be loaded again?\n            if(obj.state.loaded) {\n                obj.state.loaded = false;\n                for(i = 0, j = obj.parents.length; i < j; i++) {\n                    this._model.data[obj.parents[i]].children_d = $.vakata.array_filter(this._model.data[obj.parents[i]].children_d, function (v) {\n                        return $.inArray(v, obj.children_d) === -1;\n                    });\n                }\n                for(k = 0, l = obj.children_d.length; k < l; k++) {\n                    if(this._model.data[obj.children_d[k]].state.selected) {\n                        c = true;\n                    }\n                    delete this._model.data[obj.children_d[k]];\n                }\n                if (c) {\n                    this._data.core.selected = $.vakata.array_filter(this._data.core.selected, function (v) {\n                        return $.inArray(v, obj.children_d) === -1;\n                    });\n                }\n                obj.children = [];\n                obj.children_d = [];\n                if(c) {\n                    this.trigger('changed', { 'action' : 'load_node', 'node' : obj, 'selected' : this._data.core.selected });\n                }\n            }\n            obj.state.failed = false;\n            obj.state.loading = true;\n            this.get_node(obj, true).addClass(\"jstree-loading\").attr('aria-busy',true);\n            this._load_node(obj, function (status) {\n                obj = this._model.data[obj.id];\n                obj.state.loading = false;\n                obj.state.loaded = status;\n                obj.state.failed = !obj.state.loaded;\n                var dom = this.get_node(obj, true), i = 0, j = 0, m = this._model.data, has_children = false;\n                for(i = 0, j = obj.children.length; i < j; i++) {\n                    if(m[obj.children[i]] && !m[obj.children[i]].state.hidden) {\n                        has_children = true;\n                        break;\n                    }\n                }\n                if(obj.state.loaded && dom && dom.length) {\n                    dom.removeClass('jstree-closed jstree-open jstree-leaf');\n                    if (!has_children) {\n                        dom.addClass('jstree-leaf');\n                    }\n                    else {\n                        if (obj.id !== '#') {\n                            dom.addClass(obj.state.opened ? 'jstree-open' : 'jstree-closed');\n                        }\n                    }\n                }\n                dom.removeClass(\"jstree-loading\").attr('aria-busy',false);\n                /**\n                 * triggered after a node is loaded\n                 * @event\n                 * @name load_node.jstree\n                 * @param {Object} node the node that was loading\n                 * @param {Boolean} status was the node loaded successfully\n                 */\n                this.trigger('load_node', { \"node\" : obj, \"status\" : status });\n                if(callback) {\n                    callback.call(this, obj, status);\n                }\n            }.bind(this));\n            return true;\n        },\n        /**\n         * load an array of nodes (will also load unavailable nodes as soon as they appear in the structure). Used internally.\n         * @private\n         * @name _load_nodes(nodes [, callback])\n         * @param  {array} nodes\n         * @param  {function} callback a function to be executed once loading is complete, the function is executed in the instance's scope and receives one argument - the array passed to _load_nodes\n         */\n        _load_nodes : function (nodes, callback, is_callback, force_reload) {\n            var r = true,\n                c = function () { this._load_nodes(nodes, callback, true); },\n                m = this._model.data, i, j, tmp = [];\n            for(i = 0, j = nodes.length; i < j; i++) {\n                if(m[nodes[i]] && ( (!m[nodes[i]].state.loaded && !m[nodes[i]].state.failed) || (!is_callback && force_reload) )) {\n                    if(!this.is_loading(nodes[i])) {\n                        this.load_node(nodes[i], c);\n                    }\n                    r = false;\n                }\n            }\n            if(r) {\n                for(i = 0, j = nodes.length; i < j; i++) {\n                    if(m[nodes[i]] && m[nodes[i]].state.loaded) {\n                        tmp.push(nodes[i]);\n                    }\n                }\n                if(callback && !callback.done) {\n                    callback.call(this, tmp);\n                    callback.done = true;\n                }\n            }\n        },\n        /**\n         * loads all unloaded nodes\n         * @name load_all([obj, callback])\n         * @param {mixed} obj the node to load recursively, omit to load all nodes in the tree\n         * @param {function} callback a function to be executed once loading all the nodes is complete,\n         * @trigger load_all.jstree\n         */\n        load_all : function (obj, callback) {\n            if(!obj) { obj = $.jstree.root; }\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            var to_load = [],\n                m = this._model.data,\n                c = m[obj.id].children_d,\n                i, j;\n            if(obj.state && !obj.state.loaded) {\n                to_load.push(obj.id);\n            }\n            for(i = 0, j = c.length; i < j; i++) {\n                if(m[c[i]] && m[c[i]].state && !m[c[i]].state.loaded) {\n                    to_load.push(c[i]);\n                }\n            }\n            if(to_load.length) {\n                this._load_nodes(to_load, function () {\n                    this.load_all(obj, callback);\n                });\n            }\n            else {\n                /**\n                 * triggered after a load_all call completes\n                 * @event\n                 * @name load_all.jstree\n                 * @param {Object} node the recursively loaded node\n                 */\n                if(callback) { callback.call(this, obj); }\n                this.trigger('load_all', { \"node\" : obj });\n            }\n        },\n        /**\n         * handles the actual loading of a node. Used only internally.\n         * @private\n         * @name _load_node(obj [, callback])\n         * @param  {mixed} obj\n         * @param  {function} callback a function to be executed once loading is complete, the function is executed in the instance's scope and receives one argument - a boolean status\n         * @return {Boolean}\n         */\n        _load_node : function (obj, callback) {\n            var s = this.settings.core.data, t;\n            var notTextOrCommentNode = function notTextOrCommentNode () {\n                return this.nodeType !== 3 && this.nodeType !== 8;\n            };\n            // use original HTML\n            if(!s) {\n                if(obj.id === $.jstree.root) {\n                    return this._append_html_data(obj, this._data.core.original_container_html.clone(true), function (status) {\n                        callback.call(this, status);\n                    });\n                }\n                else {\n                    return callback.call(this, false);\n                }\n                // return callback.call(this, obj.id === $.jstree.root ? this._append_html_data(obj, this._data.core.original_container_html.clone(true)) : false);\n            }\n            if($.vakata.is_function(s)) {\n                return s.call(this, obj, function (d) {\n                    if(d === false) {\n                        callback.call(this, false);\n                    }\n                    else {\n                        this[typeof d === 'string' ? '_append_html_data' : '_append_json_data'](obj, typeof d === 'string' ? $($.parseHTML(d)).filter(notTextOrCommentNode) : d, function (status) {\n                            callback.call(this, status);\n                        });\n                    }\n                    // return d === false ? callback.call(this, false) : callback.call(this, this[typeof d === 'string' ? '_append_html_data' : '_append_json_data'](obj, typeof d === 'string' ? $(d) : d));\n                }.bind(this));\n            }\n            if(typeof s === 'object') {\n                if(s.url) {\n                    s = $.extend(true, {}, s);\n                    if($.vakata.is_function(s.url)) {\n                        s.url = s.url.call(this, obj);\n                    }\n                    if($.vakata.is_function(s.data)) {\n                        s.data = s.data.call(this, obj);\n                    }\n                    return $.ajax(s)\n                        .done(function (d,t,x) {\n                            var type = x.getResponseHeader('Content-Type');\n                            if((type && type.indexOf('json') !== -1) || typeof d === \"object\") {\n                                return this._append_json_data(obj, d, function (status) { callback.call(this, status); });\n                                //return callback.call(this, this._append_json_data(obj, d));\n                            }\n                            if((type && type.indexOf('html') !== -1) || typeof d === \"string\") {\n                                return this._append_html_data(obj, $($.parseHTML(d)).filter(notTextOrCommentNode), function (status) { callback.call(this, status); });\n                                // return callback.call(this, this._append_html_data(obj, $(d)));\n                            }\n                            this._data.core.last_error = { 'error' : 'ajax', 'plugin' : 'core', 'id' : 'core_04', 'reason' : 'Could not load node', 'data' : JSON.stringify({ 'id' : obj.id, 'xhr' : x }) };\n                            this.settings.core.error.call(this, this._data.core.last_error);\n                            return callback.call(this, false);\n                        }.bind(this))\n                        .fail(function (f) {\n                            this._data.core.last_error = { 'error' : 'ajax', 'plugin' : 'core', 'id' : 'core_04', 'reason' : 'Could not load node', 'data' : JSON.stringify({ 'id' : obj.id, 'xhr' : f }) };\n                            callback.call(this, false);\n                            this.settings.core.error.call(this, this._data.core.last_error);\n                        }.bind(this));\n                }\n                if ($.vakata.is_array(s)) {\n                    t = $.extend(true, [], s);\n                } else if ($.isPlainObject(s)) {\n                    t = $.extend(true, {}, s);\n                } else {\n                    t = s;\n                }\n                if(obj.id === $.jstree.root) {\n                    return this._append_json_data(obj, t, function (status) {\n                        callback.call(this, status);\n                    });\n                }\n                else {\n                    this._data.core.last_error = { 'error' : 'nodata', 'plugin' : 'core', 'id' : 'core_05', 'reason' : 'Could not load node', 'data' : JSON.stringify({ 'id' : obj.id }) };\n                    this.settings.core.error.call(this, this._data.core.last_error);\n                    return callback.call(this, false);\n                }\n                //return callback.call(this, (obj.id === $.jstree.root ? this._append_json_data(obj, t) : false) );\n            }\n            if(typeof s === 'string') {\n                if(obj.id === $.jstree.root) {\n                    return this._append_html_data(obj, $($.parseHTML(s)).filter(notTextOrCommentNode), function (status) {\n                        callback.call(this, status);\n                    });\n                }\n                else {\n                    this._data.core.last_error = { 'error' : 'nodata', 'plugin' : 'core', 'id' : 'core_06', 'reason' : 'Could not load node', 'data' : JSON.stringify({ 'id' : obj.id }) };\n                    this.settings.core.error.call(this, this._data.core.last_error);\n                    return callback.call(this, false);\n                }\n                //return callback.call(this, (obj.id === $.jstree.root ? this._append_html_data(obj, $(s)) : false) );\n            }\n            return callback.call(this, false);\n        },\n        /**\n         * adds a node to the list of nodes to redraw. Used only internally.\n         * @private\n         * @name _node_changed(obj [, callback])\n         * @param  {mixed} obj\n         */\n        _node_changed : function (obj) {\n            obj = this.get_node(obj);\n            if (obj && $.inArray(obj.id, this._model.changed) === -1) {\n                this._model.changed.push(obj.id);\n            }\n        },\n        /**\n         * appends HTML content to the tree. Used internally.\n         * @private\n         * @name _append_html_data(obj, data)\n         * @param  {mixed} obj the node to append to\n         * @param  {String} data the HTML string to parse and append\n         * @trigger model.jstree, changed.jstree\n         */\n        _append_html_data : function (dom, data, cb) {\n            dom = this.get_node(dom);\n            dom.children = [];\n            dom.children_d = [];\n            var dat = data.is('ul') ? data.children() : data,\n                par = dom.id,\n                chd = [],\n                dpc = [],\n                m = this._model.data,\n                p = m[par],\n                s = this._data.core.selected.length,\n                tmp, i, j;\n            dat.each(function (i, v) {\n                tmp = this._parse_model_from_html($(v), par, p.parents.concat());\n                if(tmp) {\n                    chd.push(tmp);\n                    dpc.push(tmp);\n                    if(m[tmp].children_d.length) {\n                        dpc = dpc.concat(m[tmp].children_d);\n                    }\n                }\n            }.bind(this));\n            p.children = chd;\n            p.children_d = dpc;\n            for(i = 0, j = p.parents.length; i < j; i++) {\n                m[p.parents[i]].children_d = m[p.parents[i]].children_d.concat(dpc);\n            }\n            /**\n             * triggered when new data is inserted to the tree model\n             * @event\n             * @name model.jstree\n             * @param {Array} nodes an array of node IDs\n             * @param {String} parent the parent ID of the nodes\n             */\n            this.trigger('model', { \"nodes\" : dpc, 'parent' : par });\n            if(par !== $.jstree.root) {\n                this._node_changed(par);\n                this.redraw();\n            }\n            else {\n                this.get_container_ul().children('.jstree-initial-node').remove();\n                this.redraw(true);\n            }\n            if(this._data.core.selected.length !== s) {\n                this.trigger('changed', { 'action' : 'model', 'selected' : this._data.core.selected });\n            }\n            cb.call(this, true);\n        },\n        /**\n         * appends JSON content to the tree. Used internally.\n         * @private\n         * @name _append_json_data(obj, data)\n         * @param  {mixed} obj the node to append to\n         * @param  {String} data the JSON object to parse and append\n         * @param  {Boolean} force_processing internal param - do not set\n         * @trigger model.jstree, changed.jstree\n         */\n        _append_json_data : function (dom, data, cb, force_processing) {\n            if(this.element === null) { return; }\n            dom = this.get_node(dom);\n            dom.children = [];\n            dom.children_d = [];\n            // *%$@!!!\n            if(data.d) {\n                data = data.d;\n                if(typeof data === \"string\") {\n                    data = JSON.parse(data);\n                }\n            }\n            if(!$.vakata.is_array(data)) { data = [data]; }\n            var w = null,\n                args = {\n                    'df'\t: this._model.default_state,\n                    'dat'\t: data,\n                    'par'\t: dom.id,\n                    'm'\t\t: this._model.data,\n                    't_id'\t: this._id,\n                    't_cnt'\t: this._cnt,\n                    'sel'\t: this._data.core.selected\n                },\n                inst = this,\n                func = function (data, undefined) {\n                    if(data.data) { data = data.data; }\n                    var dat = data.dat,\n                        par = data.par,\n                        chd = [],\n                        dpc = [],\n                        add = [],\n                        df = data.df,\n                        t_id = data.t_id,\n                        t_cnt = data.t_cnt,\n                        m = data.m,\n                        p = m[par],\n                        sel = data.sel,\n                        tmp, i, j, rslt,\n                        parse_flat = function (d, p, ps) {\n                            if(!ps) { ps = []; }\n                            else { ps = ps.concat(); }\n                            if(p) { ps.unshift(p); }\n                            var tid = d.id.toString(),\n                                i, j, c, e,\n                                tmp = {\n                                    id\t\t\t: tid,\n                                    text\t\t: d.text || '',\n                                    icon\t\t: d.icon !== undefined ? d.icon : true,\n                                    parent\t\t: p,\n                                    parents\t\t: ps,\n                                    children\t: d.children || [],\n                                    children_d\t: d.children_d || [],\n                                    data\t\t: d.data,\n                                    state\t\t: { },\n                                    li_attr\t\t: { id : false },\n                                    a_attr\t\t: { href : '#' },\n                                    original\t: false\n                                };\n                            for(i in df) {\n                                if(df.hasOwnProperty(i)) {\n                                    tmp.state[i] = df[i];\n                                }\n                            }\n                            if(d && d.data && d.data.jstree && d.data.jstree.icon) {\n                                tmp.icon = d.data.jstree.icon;\n                            }\n                            if(tmp.icon === undefined || tmp.icon === null || tmp.icon === \"\") {\n                                tmp.icon = true;\n                            }\n                            if(d && d.data) {\n                                tmp.data = d.data;\n                                if(d.data.jstree) {\n                                    for(i in d.data.jstree) {\n                                        if(d.data.jstree.hasOwnProperty(i)) {\n                                            tmp.state[i] = d.data.jstree[i];\n                                        }\n                                    }\n                                }\n                            }\n                            if(d && typeof d.state === 'object') {\n                                for (i in d.state) {\n                                    if(d.state.hasOwnProperty(i)) {\n                                        tmp.state[i] = d.state[i];\n                                    }\n                                }\n                            }\n                            if(d && typeof d.li_attr === 'object') {\n                                for (i in d.li_attr) {\n                                    if(d.li_attr.hasOwnProperty(i)) {\n                                        tmp.li_attr[i] = d.li_attr[i];\n                                    }\n                                }\n                            }\n                            if(!tmp.li_attr.id) {\n                                tmp.li_attr.id = tid;\n                            }\n                            if(d && typeof d.a_attr === 'object') {\n                                for (i in d.a_attr) {\n                                    if(d.a_attr.hasOwnProperty(i)) {\n                                        tmp.a_attr[i] = d.a_attr[i];\n                                    }\n                                }\n                            }\n                            if(d && d.children && d.children === true) {\n                                tmp.state.loaded = false;\n                                tmp.children = [];\n                                tmp.children_d = [];\n                            }\n                            m[tmp.id] = tmp;\n                            for(i = 0, j = tmp.children.length; i < j; i++) {\n                                c = parse_flat(m[tmp.children[i]], tmp.id, ps);\n                                e = m[c];\n                                tmp.children_d.push(c);\n                                if(e.children_d.length) {\n                                    tmp.children_d = tmp.children_d.concat(e.children_d);\n                                }\n                            }\n                            delete d.data;\n                            delete d.children;\n                            m[tmp.id].original = d;\n                            if(tmp.state.selected) {\n                                add.push(tmp.id);\n                            }\n                            return tmp.id;\n                        },\n                        parse_nest = function (d, p, ps) {\n                            if(!ps) { ps = []; }\n                            else { ps = ps.concat(); }\n                            if(p) { ps.unshift(p); }\n                            var tid = false, i, j, c, e, tmp;\n                            do {\n                                tid = 'j' + t_id + '_' + (++t_cnt);\n                            } while(m[tid]);\n\n                            tmp = {\n                                id\t\t\t: false,\n                                text\t\t: typeof d === 'string' ? d : '',\n                                icon\t\t: typeof d === 'object' && d.icon !== undefined ? d.icon : true,\n                                parent\t\t: p,\n                                parents\t\t: ps,\n                                children\t: [],\n                                children_d\t: [],\n                                data\t\t: null,\n                                state\t\t: { },\n                                li_attr\t\t: { id : false },\n                                a_attr\t\t: { href : '#' },\n                                original\t: false\n                            };\n                            for(i in df) {\n                                if(df.hasOwnProperty(i)) {\n                                    tmp.state[i] = df[i];\n                                }\n                            }\n                            if(d && d.id) { tmp.id = d.id.toString(); }\n                            if(d && d.text) { tmp.text = d.text; }\n                            if(d && d.data && d.data.jstree && d.data.jstree.icon) {\n                                tmp.icon = d.data.jstree.icon;\n                            }\n                            if(tmp.icon === undefined || tmp.icon === null || tmp.icon === \"\") {\n                                tmp.icon = true;\n                            }\n                            if(d && d.data) {\n                                tmp.data = d.data;\n                                if(d.data.jstree) {\n                                    for(i in d.data.jstree) {\n                                        if(d.data.jstree.hasOwnProperty(i)) {\n                                            tmp.state[i] = d.data.jstree[i];\n                                        }\n                                    }\n                                }\n                            }\n                            if(d && typeof d.state === 'object') {\n                                for (i in d.state) {\n                                    if(d.state.hasOwnProperty(i)) {\n                                        tmp.state[i] = d.state[i];\n                                    }\n                                }\n                            }\n                            if(d && typeof d.li_attr === 'object') {\n                                for (i in d.li_attr) {\n                                    if(d.li_attr.hasOwnProperty(i)) {\n                                        tmp.li_attr[i] = d.li_attr[i];\n                                    }\n                                }\n                            }\n                            if(tmp.li_attr.id && !tmp.id) {\n                                tmp.id = tmp.li_attr.id.toString();\n                            }\n                            if(!tmp.id) {\n                                tmp.id = tid;\n                            }\n                            if(!tmp.li_attr.id) {\n                                tmp.li_attr.id = tmp.id;\n                            }\n                            if(d && typeof d.a_attr === 'object') {\n                                for (i in d.a_attr) {\n                                    if(d.a_attr.hasOwnProperty(i)) {\n                                        tmp.a_attr[i] = d.a_attr[i];\n                                    }\n                                }\n                            }\n                            if(d && d.children && d.children.length) {\n                                for(i = 0, j = d.children.length; i < j; i++) {\n                                    c = parse_nest(d.children[i], tmp.id, ps);\n                                    e = m[c];\n                                    tmp.children.push(c);\n                                    if(e.children_d.length) {\n                                        tmp.children_d = tmp.children_d.concat(e.children_d);\n                                    }\n                                }\n                                tmp.children_d = tmp.children_d.concat(tmp.children);\n                            }\n                            if(d && d.children && d.children === true) {\n                                tmp.state.loaded = false;\n                                tmp.children = [];\n                                tmp.children_d = [];\n                            }\n                            delete d.data;\n                            delete d.children;\n                            tmp.original = d;\n                            m[tmp.id] = tmp;\n                            if(tmp.state.selected) {\n                                add.push(tmp.id);\n                            }\n                            return tmp.id;\n                        };\n\n                    if(dat.length && dat[0].id !== undefined && dat[0].parent !== undefined) {\n                        // Flat JSON support (for easy import from DB):\n                        // 1) convert to object (foreach)\n                        for(i = 0, j = dat.length; i < j; i++) {\n                            if(!dat[i].children) {\n                                dat[i].children = [];\n                            }\n                            if(!dat[i].state) {\n                                dat[i].state = {};\n                            }\n                            m[dat[i].id.toString()] = dat[i];\n                        }\n                        // 2) populate children (foreach)\n                        for(i = 0, j = dat.length; i < j; i++) {\n                            if (!m[dat[i].parent.toString()]) {\n                                if (typeof inst !== \"undefined\") {\n                                    inst._data.core.last_error = { 'error' : 'parse', 'plugin' : 'core', 'id' : 'core_07', 'reason' : 'Node with invalid parent', 'data' : JSON.stringify({ 'id' : dat[i].id.toString(), 'parent' : dat[i].parent.toString() }) };\n                                    inst.settings.core.error.call(inst, inst._data.core.last_error);\n                                }\n                                continue;\n                            }\n\n                            m[dat[i].parent.toString()].children.push(dat[i].id.toString());\n                            // populate parent.children_d\n                            p.children_d.push(dat[i].id.toString());\n                        }\n                        // 3) normalize && populate parents and children_d with recursion\n                        for(i = 0, j = p.children.length; i < j; i++) {\n                            tmp = parse_flat(m[p.children[i]], par, p.parents.concat());\n                            dpc.push(tmp);\n                            if(m[tmp].children_d.length) {\n                                dpc = dpc.concat(m[tmp].children_d);\n                            }\n                        }\n                        for(i = 0, j = p.parents.length; i < j; i++) {\n                            m[p.parents[i]].children_d = m[p.parents[i]].children_d.concat(dpc);\n                        }\n                        // ?) three_state selection - p.state.selected && t - (if three_state foreach(dat => ch) -> foreach(parents) if(parent.selected) child.selected = true;\n                        rslt = {\n                            'cnt' : t_cnt,\n                            'mod' : m,\n                            'sel' : sel,\n                            'par' : par,\n                            'dpc' : dpc,\n                            'add' : add\n                        };\n                    }\n                    else {\n                        for(i = 0, j = dat.length; i < j; i++) {\n                            tmp = parse_nest(dat[i], par, p.parents.concat());\n                            if(tmp) {\n                                chd.push(tmp);\n                                dpc.push(tmp);\n                                if(m[tmp].children_d.length) {\n                                    dpc = dpc.concat(m[tmp].children_d);\n                                }\n                            }\n                        }\n                        p.children = chd;\n                        p.children_d = dpc;\n                        for(i = 0, j = p.parents.length; i < j; i++) {\n                            m[p.parents[i]].children_d = m[p.parents[i]].children_d.concat(dpc);\n                        }\n                        rslt = {\n                            'cnt' : t_cnt,\n                            'mod' : m,\n                            'sel' : sel,\n                            'par' : par,\n                            'dpc' : dpc,\n                            'add' : add\n                        };\n                    }\n                    if(typeof window === 'undefined' || typeof window.document === 'undefined') {\n                        postMessage(rslt);\n                    }\n                    else {\n                        return rslt;\n                    }\n                },\n                rslt = function (rslt, worker) {\n                    if(this.element === null) { return; }\n                    this._cnt = rslt.cnt;\n                    var i, m = this._model.data;\n                    for (i in m) {\n                        if (m.hasOwnProperty(i) && m[i].state && m[i].state.loading && rslt.mod[i]) {\n                            rslt.mod[i].state.loading = true;\n                        }\n                    }\n                    this._model.data = rslt.mod; // breaks the reference in load_node - careful\n\n                    if(worker) {\n                        var j, a = rslt.add, r = rslt.sel, s = this._data.core.selected.slice();\n                        m = this._model.data;\n                        // if selection was changed while calculating in worker\n                        if(r.length !== s.length || $.vakata.array_unique(r.concat(s)).length !== r.length) {\n                            // deselect nodes that are no longer selected\n                            for(i = 0, j = r.length; i < j; i++) {\n                                if($.inArray(r[i], a) === -1 && $.inArray(r[i], s) === -1) {\n                                    m[r[i]].state.selected = false;\n                                }\n                            }\n                            // select nodes that were selected in the mean time\n                            for(i = 0, j = s.length; i < j; i++) {\n                                if($.inArray(s[i], r) === -1) {\n                                    m[s[i]].state.selected = true;\n                                }\n                            }\n                        }\n                    }\n                    if(rslt.add.length) {\n                        this._data.core.selected = this._data.core.selected.concat(rslt.add);\n                    }\n\n                    this.trigger('model', { \"nodes\" : rslt.dpc, 'parent' : rslt.par });\n\n                    if(rslt.par !== $.jstree.root) {\n                        this._node_changed(rslt.par);\n                        this.redraw();\n                    }\n                    else {\n                        // this.get_container_ul().children('.jstree-initial-node').remove();\n                        this.redraw(true);\n                    }\n                    if(rslt.add.length) {\n                        this.trigger('changed', { 'action' : 'model', 'selected' : this._data.core.selected });\n                    }\n\n                    // If no worker, try to mimic worker behavioour, by invoking cb asynchronously\n                    if (!worker && setImmediate) {\n                        setImmediate(function(){\n                            cb.call(inst, true);\n                        });\n                    }\n                    else {\n                        cb.call(inst, true);\n                    }\n                };\n            if(this.settings.core.worker && window.Blob && window.URL && window.Worker) {\n                try {\n                    if(this._wrk === null) {\n                        this._wrk = window.URL.createObjectURL(\n                            new window.Blob(\n                                ['self.onmessage = ' + func.toString()],\n                                {type:\"text/javascript\"}\n                            )\n                        );\n                    }\n                    if(!this._data.core.working || force_processing) {\n                        this._data.core.working = true;\n                        w = new window.Worker(this._wrk);\n                        w.onmessage = function (e) {\n                            rslt.call(this, e.data, true);\n                            try { w.terminate(); w = null; } catch(ignore) { }\n                            if(this._data.core.worker_queue.length) {\n                                this._append_json_data.apply(this, this._data.core.worker_queue.shift());\n                            }\n                            else {\n                                this._data.core.working = false;\n                            }\n                        }.bind(this);\n                        if(!args.par) {\n                            if(this._data.core.worker_queue.length) {\n                                this._append_json_data.apply(this, this._data.core.worker_queue.shift());\n                            }\n                            else {\n                                this._data.core.working = false;\n                            }\n                        }\n                        else {\n                            w.postMessage(args);\n                        }\n                    }\n                    else {\n                        this._data.core.worker_queue.push([dom, data, cb, true]);\n                    }\n                }\n                catch(e) {\n                    rslt.call(this, func(args), false);\n                    if(this._data.core.worker_queue.length) {\n                        this._append_json_data.apply(this, this._data.core.worker_queue.shift());\n                    }\n                    else {\n                        this._data.core.working = false;\n                    }\n                }\n            }\n            else {\n                rslt.call(this, func(args), false);\n            }\n        },\n        /**\n         * parses a node from a jQuery object and appends them to the in memory tree model. Used internally.\n         * @private\n         * @name _parse_model_from_html(d [, p, ps])\n         * @param  {jQuery} d the jQuery object to parse\n         * @param  {String} p the parent ID\n         * @param  {Array} ps list of all parents\n         * @return {String} the ID of the object added to the model\n         */\n        _parse_model_from_html : function (d, p, ps) {\n            if(!ps) { ps = []; }\n            else { ps = [].concat(ps); }\n            if(p) { ps.unshift(p); }\n            var c, e, m = this._model.data,\n                data = {\n                    id\t\t\t: false,\n                    text\t\t: false,\n                    icon\t\t: true,\n                    parent\t\t: p,\n                    parents\t\t: ps,\n                    children\t: [],\n                    children_d\t: [],\n                    data\t\t: null,\n                    state\t\t: { },\n                    li_attr\t\t: { id : false },\n                    a_attr\t\t: { href : '#' },\n                    original\t: false\n                }, i, tmp, tid;\n            for(i in this._model.default_state) {\n                if(this._model.default_state.hasOwnProperty(i)) {\n                    data.state[i] = this._model.default_state[i];\n                }\n            }\n            tmp = $.vakata.attributes(d, true);\n            $.each(tmp, function (i, v) {\n                v = $.vakata.trim(v);\n                if(!v.length) { return true; }\n                data.li_attr[i] = v;\n                if(i === 'id') {\n                    data.id = v.toString();\n                }\n            });\n            tmp = d.children('a').first();\n            if(tmp.length) {\n                tmp = $.vakata.attributes(tmp, true);\n                $.each(tmp, function (i, v) {\n                    v = $.vakata.trim(v);\n                    if(v.length) {\n                        data.a_attr[i] = v;\n                    }\n                });\n            }\n            tmp = d.children(\"a\").first().length ? d.children(\"a\").first().clone() : d.clone();\n            tmp.children(\"ins, i, ul\").remove();\n            tmp = tmp.html();\n            tmp = $('<div></div>').html(tmp);\n            data.text = this.settings.core.force_text ? tmp.text() : tmp.html();\n            tmp = d.data();\n            data.data = tmp ? $.extend(true, {}, tmp) : null;\n            data.state.opened = d.hasClass('jstree-open');\n            data.state.selected = d.children('a').hasClass('jstree-clicked');\n            data.state.disabled = d.children('a').hasClass('jstree-disabled');\n            if(data.data && data.data.jstree) {\n                for(i in data.data.jstree) {\n                    if(data.data.jstree.hasOwnProperty(i)) {\n                        data.state[i] = data.data.jstree[i];\n                    }\n                }\n            }\n            tmp = d.children(\"a\").children(\".jstree-themeicon\");\n            if(tmp.length) {\n                data.icon = tmp.hasClass('jstree-themeicon-hidden') ? false : tmp.attr('rel');\n            }\n            if(data.state.icon !== undefined) {\n                data.icon = data.state.icon;\n            }\n            if(data.icon === undefined || data.icon === null || data.icon === \"\") {\n                data.icon = true;\n            }\n            tmp = d.children(\"ul\").children(\"li\");\n            do {\n                tid = 'j' + this._id + '_' + (++this._cnt);\n            } while(m[tid]);\n            data.id = data.li_attr.id ? data.li_attr.id.toString() : tid;\n            if(tmp.length) {\n                tmp.each(function (i, v) {\n                    c = this._parse_model_from_html($(v), data.id, ps);\n                    e = this._model.data[c];\n                    data.children.push(c);\n                    if(e.children_d.length) {\n                        data.children_d = data.children_d.concat(e.children_d);\n                    }\n                }.bind(this));\n                data.children_d = data.children_d.concat(data.children);\n            }\n            else {\n                if(d.hasClass('jstree-closed')) {\n                    data.state.loaded = false;\n                }\n            }\n            if(data.li_attr['class']) {\n                data.li_attr['class'] = data.li_attr['class'].replace('jstree-closed','').replace('jstree-open','');\n            }\n            if(data.a_attr['class']) {\n                data.a_attr['class'] = data.a_attr['class'].replace('jstree-clicked','').replace('jstree-disabled','');\n            }\n            m[data.id] = data;\n            if(data.state.selected) {\n                this._data.core.selected.push(data.id);\n            }\n            return data.id;\n        },\n        /**\n         * parses a node from a JSON object (used when dealing with flat data, which has no nesting of children, but has id and parent properties) and appends it to the in memory tree model. Used internally.\n         * @private\n         * @name _parse_model_from_flat_json(d [, p, ps])\n         * @param  {Object} d the JSON object to parse\n         * @param  {String} p the parent ID\n         * @param  {Array} ps list of all parents\n         * @return {String} the ID of the object added to the model\n         */\n        _parse_model_from_flat_json : function (d, p, ps) {\n            if(!ps) { ps = []; }\n            else { ps = ps.concat(); }\n            if(p) { ps.unshift(p); }\n            var tid = d.id.toString(),\n                m = this._model.data,\n                df = this._model.default_state,\n                i, j, c, e,\n                tmp = {\n                    id\t\t\t: tid,\n                    text\t\t: d.text || '',\n                    icon\t\t: d.icon !== undefined ? d.icon : true,\n                    parent\t\t: p,\n                    parents\t\t: ps,\n                    children\t: d.children || [],\n                    children_d\t: d.children_d || [],\n                    data\t\t: d.data,\n                    state\t\t: { },\n                    li_attr\t\t: { id : false },\n                    a_attr\t\t: { href : '#' },\n                    original\t: false\n                };\n            for(i in df) {\n                if(df.hasOwnProperty(i)) {\n                    tmp.state[i] = df[i];\n                }\n            }\n            if(d && d.data && d.data.jstree && d.data.jstree.icon) {\n                tmp.icon = d.data.jstree.icon;\n            }\n            if(tmp.icon === undefined || tmp.icon === null || tmp.icon === \"\") {\n                tmp.icon = true;\n            }\n            if(d && d.data) {\n                tmp.data = d.data;\n                if(d.data.jstree) {\n                    for(i in d.data.jstree) {\n                        if(d.data.jstree.hasOwnProperty(i)) {\n                            tmp.state[i] = d.data.jstree[i];\n                        }\n                    }\n                }\n            }\n            if(d && typeof d.state === 'object') {\n                for (i in d.state) {\n                    if(d.state.hasOwnProperty(i)) {\n                        tmp.state[i] = d.state[i];\n                    }\n                }\n            }\n            if(d && typeof d.li_attr === 'object') {\n                for (i in d.li_attr) {\n                    if(d.li_attr.hasOwnProperty(i)) {\n                        tmp.li_attr[i] = d.li_attr[i];\n                    }\n                }\n            }\n            if(!tmp.li_attr.id) {\n                tmp.li_attr.id = tid;\n            }\n            if(d && typeof d.a_attr === 'object') {\n                for (i in d.a_attr) {\n                    if(d.a_attr.hasOwnProperty(i)) {\n                        tmp.a_attr[i] = d.a_attr[i];\n                    }\n                }\n            }\n            if(d && d.children && d.children === true) {\n                tmp.state.loaded = false;\n                tmp.children = [];\n                tmp.children_d = [];\n            }\n            m[tmp.id] = tmp;\n            for(i = 0, j = tmp.children.length; i < j; i++) {\n                c = this._parse_model_from_flat_json(m[tmp.children[i]], tmp.id, ps);\n                e = m[c];\n                tmp.children_d.push(c);\n                if(e.children_d.length) {\n                    tmp.children_d = tmp.children_d.concat(e.children_d);\n                }\n            }\n            delete d.data;\n            delete d.children;\n            m[tmp.id].original = d;\n            if(tmp.state.selected) {\n                this._data.core.selected.push(tmp.id);\n            }\n            return tmp.id;\n        },\n        /**\n         * parses a node from a JSON object and appends it to the in memory tree model. Used internally.\n         * @private\n         * @name _parse_model_from_json(d [, p, ps])\n         * @param  {Object} d the JSON object to parse\n         * @param  {String} p the parent ID\n         * @param  {Array} ps list of all parents\n         * @return {String} the ID of the object added to the model\n         */\n        _parse_model_from_json : function (d, p, ps) {\n            if(!ps) { ps = []; }\n            else { ps = ps.concat(); }\n            if(p) { ps.unshift(p); }\n            var tid = false, i, j, c, e, m = this._model.data, df = this._model.default_state, tmp;\n            do {\n                tid = 'j' + this._id + '_' + (++this._cnt);\n            } while(m[tid]);\n\n            tmp = {\n                id\t\t\t: false,\n                text\t\t: typeof d === 'string' ? d : '',\n                icon\t\t: typeof d === 'object' && d.icon !== undefined ? d.icon : true,\n                parent\t\t: p,\n                parents\t\t: ps,\n                children\t: [],\n                children_d\t: [],\n                data\t\t: null,\n                state\t\t: { },\n                li_attr\t\t: { id : false },\n                a_attr\t\t: { href : '#' },\n                original\t: false\n            };\n            for(i in df) {\n                if(df.hasOwnProperty(i)) {\n                    tmp.state[i] = df[i];\n                }\n            }\n            if(d && d.id) { tmp.id = d.id.toString(); }\n            if(d && d.text) { tmp.text = d.text; }\n            if(d && d.data && d.data.jstree && d.data.jstree.icon) {\n                tmp.icon = d.data.jstree.icon;\n            }\n            if(tmp.icon === undefined || tmp.icon === null || tmp.icon === \"\") {\n                tmp.icon = true;\n            }\n            if(d && d.data) {\n                tmp.data = d.data;\n                if(d.data.jstree) {\n                    for(i in d.data.jstree) {\n                        if(d.data.jstree.hasOwnProperty(i)) {\n                            tmp.state[i] = d.data.jstree[i];\n                        }\n                    }\n                }\n            }\n            if(d && typeof d.state === 'object') {\n                for (i in d.state) {\n                    if(d.state.hasOwnProperty(i)) {\n                        tmp.state[i] = d.state[i];\n                    }\n                }\n            }\n            if(d && typeof d.li_attr === 'object') {\n                for (i in d.li_attr) {\n                    if(d.li_attr.hasOwnProperty(i)) {\n                        tmp.li_attr[i] = d.li_attr[i];\n                    }\n                }\n            }\n            if(tmp.li_attr.id && !tmp.id) {\n                tmp.id = tmp.li_attr.id.toString();\n            }\n            if(!tmp.id) {\n                tmp.id = tid;\n            }\n            if(!tmp.li_attr.id) {\n                tmp.li_attr.id = tmp.id;\n            }\n            if(d && typeof d.a_attr === 'object') {\n                for (i in d.a_attr) {\n                    if(d.a_attr.hasOwnProperty(i)) {\n                        tmp.a_attr[i] = d.a_attr[i];\n                    }\n                }\n            }\n            if(d && d.children && d.children.length) {\n                for(i = 0, j = d.children.length; i < j; i++) {\n                    c = this._parse_model_from_json(d.children[i], tmp.id, ps);\n                    e = m[c];\n                    tmp.children.push(c);\n                    if(e.children_d.length) {\n                        tmp.children_d = tmp.children_d.concat(e.children_d);\n                    }\n                }\n                tmp.children_d = tmp.children.concat(tmp.children_d);\n            }\n            if(d && d.children && d.children === true) {\n                tmp.state.loaded = false;\n                tmp.children = [];\n                tmp.children_d = [];\n            }\n            delete d.data;\n            delete d.children;\n            tmp.original = d;\n            m[tmp.id] = tmp;\n            if(tmp.state.selected) {\n                this._data.core.selected.push(tmp.id);\n            }\n            return tmp.id;\n        },\n        /**\n         * redraws all nodes that need to be redrawn. Used internally.\n         * @private\n         * @name _redraw()\n         * @trigger redraw.jstree\n         */\n        _redraw : function () {\n            var nodes = this._model.force_full_redraw ? this._model.data[$.jstree.root].children.concat([]) : this._model.changed.concat([]),\n                f = document.createElement('UL'), tmp, i, j, fe = this._data.core.focused;\n            for(i = 0, j = nodes.length; i < j; i++) {\n                tmp = this.redraw_node(nodes[i], true, this._model.force_full_redraw);\n                if(tmp && this._model.force_full_redraw) {\n                    f.appendChild(tmp);\n                }\n            }\n            if(this._model.force_full_redraw) {\n                f.className = this.get_container_ul()[0].className;\n                f.setAttribute('role','group');\n                this.element.empty().append(f);\n                //this.get_container_ul()[0].appendChild(f);\n            }\n            if(fe !== null && this.settings.core.restore_focus) {\n                tmp = this.get_node(fe, true);\n                if(tmp && tmp.length && tmp.children('.jstree-anchor')[0] !== document.activeElement) {\n                    tmp.children('.jstree-anchor').trigger('focus');\n                }\n                else {\n                    this._data.core.focused = null;\n                }\n            }\n            this._model.force_full_redraw = false;\n            this._model.changed = [];\n            /**\n             * triggered after nodes are redrawn\n             * @event\n             * @name redraw.jstree\n             * @param {array} nodes the redrawn nodes\n             */\n            this.trigger('redraw', { \"nodes\" : nodes });\n        },\n        /**\n         * redraws all nodes that need to be redrawn or optionally - the whole tree\n         * @name redraw([full])\n         * @param {Boolean} full if set to `true` all nodes are redrawn.\n         */\n        redraw : function (full) {\n            if(full) {\n                this._model.force_full_redraw = true;\n            }\n            //if(this._model.redraw_timeout) {\n            //\tclearTimeout(this._model.redraw_timeout);\n            //}\n            //this._model.redraw_timeout = setTimeout($.proxy(this._redraw, this),0);\n            this._redraw();\n        },\n        /**\n         * redraws a single node's children. Used internally.\n         * @private\n         * @name draw_children(node)\n         * @param {mixed} node the node whose children will be redrawn\n         */\n        draw_children : function (node) {\n            var obj = this.get_node(node),\n                i = false,\n                j = false,\n                k = false,\n                d = document;\n            if(!obj) { return false; }\n            if(obj.id === $.jstree.root) { return this.redraw(true); }\n            node = this.get_node(node, true);\n            if(!node || !node.length) { return false; } // TODO: quick toggle\n\n            node.children('.jstree-children').remove();\n            node = node[0];\n            if(obj.children.length && obj.state.loaded) {\n                k = d.createElement('UL');\n                k.setAttribute('role', 'group');\n                k.className = 'jstree-children';\n                for(i = 0, j = obj.children.length; i < j; i++) {\n                    k.appendChild(this.redraw_node(obj.children[i], true, true));\n                }\n                node.appendChild(k);\n            }\n        },\n        /**\n         * redraws a single node. Used internally.\n         * @private\n         * @name redraw_node(node, deep, is_callback, force_render)\n         * @param {mixed} node the node to redraw\n         * @param {Boolean} deep should child nodes be redrawn too\n         * @param {Boolean} is_callback is this a recursion call\n         * @param {Boolean} force_render should children of closed parents be drawn anyway\n         */\n        redraw_node : function (node, deep, is_callback, force_render) {\n            var obj = this.get_node(node),\n                par = false,\n                ind = false,\n                old = false,\n                i = false,\n                j = false,\n                k = false,\n                c = '',\n                d = document,\n                m = this._model.data,\n                f = false,\n                s = false,\n                tmp = null,\n                t = 0,\n                l = 0,\n                has_children = false,\n                last_sibling = false;\n            if(!obj) { return false; }\n            if(obj.id === $.jstree.root) {  return this.redraw(true); }\n            deep = deep || obj.children.length === 0;\n            node = !document.querySelector ? document.getElementById(obj.id) : this.element[0].querySelector('#' + (\"0123456789\".indexOf(obj.id[0]) !== -1 ? '\\\\3' + obj.id[0] + ' ' + obj.id.substr(1).replace($.jstree.idregex,'\\\\$&') : obj.id.replace($.jstree.idregex,'\\\\$&')) ); //, this.element);\n            if(!node) {\n                deep = true;\n                //node = d.createElement('LI');\n                if(!is_callback) {\n                    par = obj.parent !== $.jstree.root ? $('#' + obj.parent.replace($.jstree.idregex,'\\\\$&'), this.element)[0] : null;\n                    if(par !== null && (!par || !m[obj.parent].state.opened)) {\n                        return false;\n                    }\n                    ind = $.inArray(obj.id, par === null ? m[$.jstree.root].children : m[obj.parent].children);\n                }\n            }\n            else {\n                node = $(node);\n                if(!is_callback) {\n                    par = node.parent().parent()[0];\n                    if(par === this.element[0]) {\n                        par = null;\n                    }\n                    ind = node.index();\n                }\n                // m[obj.id].data = node.data(); // use only node's data, no need to touch jquery storage\n                if(!deep && obj.children.length && !node.children('.jstree-children').length) {\n                    deep = true;\n                }\n                if(!deep) {\n                    old = node.children('.jstree-children')[0];\n                }\n                f = node.children('.jstree-anchor')[0] === document.activeElement;\n                node.remove();\n                //node = d.createElement('LI');\n                //node = node[0];\n            }\n            node = this._data.core.node.cloneNode(true);\n            // node is DOM, deep is boolean\n\n            c = 'jstree-node ';\n            for(i in obj.li_attr) {\n                if(obj.li_attr.hasOwnProperty(i)) {\n                    if(i === 'id') { continue; }\n                    if(i !== 'class') {\n                        node.setAttribute(i, obj.li_attr[i]);\n                    }\n                    else {\n                        c += obj.li_attr[i];\n                    }\n                }\n            }\n            if(!obj.a_attr.id) {\n                obj.a_attr.id = obj.id + '_anchor';\n            }\n            node.childNodes[1].setAttribute('aria-selected', !!obj.state.selected);\n            node.childNodes[1].setAttribute('aria-level', obj.parents.length);\n            if(this.settings.core.compute_elements_positions) {\n                node.childNodes[1].setAttribute('aria-setsize', m[obj.parent].children.length);\n                node.childNodes[1].setAttribute('aria-posinset', m[obj.parent].children.indexOf(obj.id) + 1);\n            }\n            if(obj.state.disabled) {\n                node.childNodes[1].setAttribute('aria-disabled', true);\n            }\n\n            for(i = 0, j = obj.children.length; i < j; i++) {\n                if(!m[obj.children[i]].state.hidden) {\n                    has_children = true;\n                    break;\n                }\n            }\n            if(obj.parent !== null && m[obj.parent] && !obj.state.hidden) {\n                i = $.inArray(obj.id, m[obj.parent].children);\n                last_sibling = obj.id;\n                if(i !== -1) {\n                    i++;\n                    for(j = m[obj.parent].children.length; i < j; i++) {\n                        if(!m[m[obj.parent].children[i]].state.hidden) {\n                            last_sibling = m[obj.parent].children[i];\n                        }\n                        if(last_sibling !== obj.id) {\n                            break;\n                        }\n                    }\n                }\n            }\n\n            if(obj.state.hidden) {\n                c += ' jstree-hidden';\n            }\n            if (obj.state.loading) {\n                c += ' jstree-loading';\n            }\n            if(obj.state.loaded && !has_children) {\n                c += ' jstree-leaf';\n            }\n            else {\n                c += obj.state.opened && obj.state.loaded ? ' jstree-open' : ' jstree-closed';\n                node.childNodes[1].setAttribute('aria-expanded', (obj.state.opened && obj.state.loaded) );\n            }\n            if(last_sibling === obj.id) {\n                c += ' jstree-last';\n            }\n            node.id = obj.id;\n            node.className = c;\n            c = ( obj.state.selected ? ' jstree-clicked' : '') + ( obj.state.disabled ? ' jstree-disabled' : '');\n            for(j in obj.a_attr) {\n                if(obj.a_attr.hasOwnProperty(j)) {\n                    if(j === 'href' && obj.a_attr[j] === '#') { continue; }\n                    if(j !== 'class') {\n                        node.childNodes[1].setAttribute(j, obj.a_attr[j]);\n                    }\n                    else {\n                        c += ' ' + obj.a_attr[j];\n                    }\n                }\n            }\n            if(c.length) {\n                node.childNodes[1].className = 'jstree-anchor ' + c;\n            }\n            if((obj.icon && obj.icon !== true) || obj.icon === false) {\n                if(obj.icon === false) {\n                    node.childNodes[1].childNodes[0].className += ' jstree-themeicon-hidden';\n                }\n                else if(obj.icon.indexOf('/') === -1 && obj.icon.indexOf('.') === -1) {\n                    node.childNodes[1].childNodes[0].className += ' ' + obj.icon + ' jstree-themeicon-custom';\n                }\n                else {\n                    node.childNodes[1].childNodes[0].style.backgroundImage = 'url(\"'+obj.icon+'\")';\n                    node.childNodes[1].childNodes[0].style.backgroundPosition = 'center center';\n                    node.childNodes[1].childNodes[0].style.backgroundSize = 'auto';\n                    node.childNodes[1].childNodes[0].className += ' jstree-themeicon-custom';\n                }\n            }\n\n            if(this.settings.core.force_text) {\n                node.childNodes[1].appendChild(d.createTextNode(obj.text));\n            }\n            else {\n                node.childNodes[1].innerHTML += obj.text;\n            }\n\n\n            if(deep && obj.children.length && (obj.state.opened || force_render) && obj.state.loaded) {\n                k = d.createElement('UL');\n                k.setAttribute('role', 'group');\n                k.className = 'jstree-children';\n                for(i = 0, j = obj.children.length; i < j; i++) {\n                    k.appendChild(this.redraw_node(obj.children[i], deep, true));\n                }\n                node.appendChild(k);\n            }\n            if(old) {\n                node.appendChild(old);\n            }\n            if(!is_callback) {\n                // append back using par / ind\n                if(!par) {\n                    par = this.element[0];\n                }\n                for(i = 0, j = par.childNodes.length; i < j; i++) {\n                    if(par.childNodes[i] && par.childNodes[i].className && par.childNodes[i].className.indexOf('jstree-children') !== -1) {\n                        tmp = par.childNodes[i];\n                        break;\n                    }\n                }\n                if(!tmp) {\n                    tmp = d.createElement('UL');\n                    tmp.setAttribute('role', 'group');\n                    tmp.className = 'jstree-children';\n                    par.appendChild(tmp);\n                }\n                par = tmp;\n\n                if(ind < par.childNodes.length) {\n                    par.insertBefore(node, par.childNodes[ind]);\n                }\n                else {\n                    par.appendChild(node);\n                }\n                if(f) {\n                    t = this.element[0].scrollTop;\n                    l = this.element[0].scrollLeft;\n                    node.childNodes[1].focus();\n                    this.element[0].scrollTop = t;\n                    this.element[0].scrollLeft = l;\n                }\n            }\n            if(obj.state.opened && !obj.state.loaded) {\n                obj.state.opened = false;\n                setTimeout(function () {\n                    this.open_node(obj.id, false, 0);\n                }.bind(this), 0);\n            }\n            return node;\n        },\n        /**\n         * opens a node, revealing its children. If the node is not loaded it will be loaded and opened once ready.\n         * @name open_node(obj [, callback, animation])\n         * @param {mixed} obj the node to open\n         * @param {Function} callback a function to execute once the node is opened\n         * @param {Number} animation the animation duration in milliseconds when opening the node (overrides the `core.animation` setting). Use `false` for no animation.\n         * @trigger open_node.jstree, after_open.jstree, before_open.jstree\n         */\n        open_node : function (obj, callback, animation) {\n            var t1, t2, d, t;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.open_node(obj[t1], callback, animation);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            animation = animation === undefined ? this.settings.core.animation : animation;\n            if(!this.is_closed(obj)) {\n                if(callback) {\n                    callback.call(this, obj, false);\n                }\n                return false;\n            }\n            if(!this.is_loaded(obj)) {\n                if(this.is_loading(obj)) {\n                    return setTimeout(function () {\n                        this.open_node(obj, callback, animation);\n                    }.bind(this), 500);\n                }\n                this.load_node(obj, function (o, ok) {\n                    return ok ? this.open_node(o, callback, animation) : (callback ? callback.call(this, o, false) : false);\n                });\n            }\n            else {\n                d = this.get_node(obj, true);\n                t = this;\n                if(d.length) {\n                    if(animation && d.children(\".jstree-children\").length) {\n                        d.children(\".jstree-children\").stop(true, true);\n                    }\n                    if(obj.children.length && !this._firstChild(d.children('.jstree-children')[0])) {\n                        this.draw_children(obj);\n                        //d = this.get_node(obj, true);\n                    }\n                    if(!animation) {\n                        this.trigger('before_open', { \"node\" : obj });\n                        d[0].className = d[0].className.replace('jstree-closed', 'jstree-open');\n                        d[0].childNodes[1].setAttribute(\"aria-expanded\", true);\n                    }\n                    else {\n                        this.trigger('before_open', { \"node\" : obj });\n                        d\n                            .children(\".jstree-children\").css(\"display\",\"none\").end()\n                            .removeClass(\"jstree-closed\").addClass(\"jstree-open\")\n                            .children('.jstree-anchor').attr(\"aria-expanded\", true).end()\n                            .children(\".jstree-children\").stop(true, true)\n                            .slideDown(animation, function () {\n                                this.style.display = \"\";\n                                if (t.element) {\n                                    t.trigger(\"after_open\", { \"node\" : obj });\n                                }\n                            });\n                    }\n                }\n                obj.state.opened = true;\n                if(callback) {\n                    callback.call(this, obj, true);\n                }\n                if(!d.length) {\n                    /**\n                     * triggered when a node is about to be opened (if the node is supposed to be in the DOM, it will be, but it won't be visible yet)\n                     * @event\n                     * @name before_open.jstree\n                     * @param {Object} node the opened node\n                     */\n                    this.trigger('before_open', { \"node\" : obj });\n                }\n                /**\n                 * triggered when a node is opened (if there is an animation it will not be completed yet)\n                 * @event\n                 * @name open_node.jstree\n                 * @param {Object} node the opened node\n                 */\n                this.trigger('open_node', { \"node\" : obj });\n                if(!animation || !d.length) {\n                    /**\n                     * triggered when a node is opened and the animation is complete\n                     * @event\n                     * @name after_open.jstree\n                     * @param {Object} node the opened node\n                     */\n                    this.trigger(\"after_open\", { \"node\" : obj });\n                }\n                return true;\n            }\n        },\n        /**\n         * opens every parent of a node (node should be loaded)\n         * @name _open_to(obj)\n         * @param {mixed} obj the node to reveal\n         * @private\n         */\n        _open_to : function (obj) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            var i, j, p = obj.parents;\n            for(i = 0, j = p.length; i < j; i+=1) {\n                if(i !== $.jstree.root) {\n                    this.open_node(p[i], false, 0);\n                }\n            }\n            return $('#' + obj.id.replace($.jstree.idregex,'\\\\$&'), this.element);\n        },\n        /**\n         * closes a node, hiding its children\n         * @name close_node(obj [, animation])\n         * @param {mixed} obj the node to close\n         * @param {Number} animation the animation duration in milliseconds when closing the node (overrides the `core.animation` setting). Use `false` for no animation.\n         * @trigger close_node.jstree, after_close.jstree\n         */\n        close_node : function (obj, animation) {\n            var t1, t2, t, d;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.close_node(obj[t1], animation);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            if(this.is_closed(obj)) {\n                return false;\n            }\n            animation = animation === undefined ? this.settings.core.animation : animation;\n            t = this;\n            d = this.get_node(obj, true);\n\n            obj.state.opened = false;\n            /**\n             * triggered when a node is closed (if there is an animation it will not be complete yet)\n             * @event\n             * @name close_node.jstree\n             * @param {Object} node the closed node\n             */\n            this.trigger('close_node',{ \"node\" : obj });\n            if(!d.length) {\n                /**\n                 * triggered when a node is closed and the animation is complete\n                 * @event\n                 * @name after_close.jstree\n                 * @param {Object} node the closed node\n                 */\n                this.trigger(\"after_close\", { \"node\" : obj });\n            }\n            else {\n                if(!animation) {\n                    d[0].className = d[0].className.replace('jstree-open', 'jstree-closed');\n                    d.children('.jstree-anchor').attr(\"aria-expanded\", false);\n                    d.children('.jstree-children').remove();\n                    this.trigger(\"after_close\", { \"node\" : obj });\n                }\n                else {\n                    d\n                        .children(\".jstree-children\").attr(\"style\",\"display:block !important\").end()\n                        .removeClass(\"jstree-open\").addClass(\"jstree-closed\")\n                        .children('.jstree-anchor').attr(\"aria-expanded\", false).end()\n                        .children(\".jstree-children\").stop(true, true).slideUp(animation, function () {\n                        this.style.display = \"\";\n                        d.children('.jstree-children').remove();\n                        if (t.element) {\n                            t.trigger(\"after_close\", { \"node\" : obj });\n                        }\n                    });\n                }\n            }\n        },\n        /**\n         * toggles a node - closing it if it is open, opening it if it is closed\n         * @name toggle_node(obj)\n         * @param {mixed} obj the node to toggle\n         */\n        toggle_node : function (obj) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.toggle_node(obj[t1]);\n                }\n                return true;\n            }\n            if(this.is_closed(obj)) {\n                return this.open_node(obj);\n            }\n            if(this.is_open(obj)) {\n                return this.close_node(obj);\n            }\n        },\n        /**\n         * opens all nodes within a node (or the tree), revealing their children. If the node is not loaded it will be loaded and opened once ready.\n         * @name open_all([obj, animation, original_obj])\n         * @param {mixed} obj the node to open recursively, omit to open all nodes in the tree\n         * @param {Number} animation the animation duration in milliseconds when opening the nodes, the default is no animation\n         * @param {jQuery} reference to the node that started the process (internal use)\n         * @trigger open_all.jstree\n         */\n        open_all : function (obj, animation, original_obj) {\n            if(!obj) { obj = $.jstree.root; }\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            var dom = obj.id === $.jstree.root ? this.get_container_ul() : this.get_node(obj, true), i, j, _this;\n            if(!dom.length) {\n                for(i = 0, j = obj.children_d.length; i < j; i++) {\n                    if(this.is_closed(this._model.data[obj.children_d[i]])) {\n                        this._model.data[obj.children_d[i]].state.opened = true;\n                    }\n                }\n                return this.trigger('open_all', { \"node\" : obj });\n            }\n            original_obj = original_obj || dom;\n            _this = this;\n            dom = this.is_closed(obj) ? dom.find('.jstree-closed').addBack() : dom.find('.jstree-closed');\n            dom.each(function () {\n                _this.open_node(\n                    this,\n                    function(node, status) { if(status && this.is_parent(node)) { this.open_all(node, animation, original_obj); } },\n                    animation || 0\n                );\n            });\n            if(original_obj.find('.jstree-closed').length === 0) {\n                /**\n                 * triggered when an `open_all` call completes\n                 * @event\n                 * @name open_all.jstree\n                 * @param {Object} node the opened node\n                 */\n                this.trigger('open_all', { \"node\" : this.get_node(original_obj) });\n            }\n        },\n        /**\n         * closes all nodes within a node (or the tree), revealing their children\n         * @name close_all([obj, animation])\n         * @param {mixed} obj the node to close recursively, omit to close all nodes in the tree\n         * @param {Number} animation the animation duration in milliseconds when closing the nodes, the default is no animation\n         * @trigger close_all.jstree\n         */\n        close_all : function (obj, animation) {\n            if(!obj) { obj = $.jstree.root; }\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            var dom = obj.id === $.jstree.root ? this.get_container_ul() : this.get_node(obj, true),\n                _this = this, i, j;\n            if(dom.length) {\n                dom = this.is_open(obj) ? dom.find('.jstree-open').addBack() : dom.find('.jstree-open');\n                $(dom.get().reverse()).each(function () { _this.close_node(this, animation || 0); });\n            }\n            for(i = 0, j = obj.children_d.length; i < j; i++) {\n                this._model.data[obj.children_d[i]].state.opened = false;\n            }\n            /**\n             * triggered when an `close_all` call completes\n             * @event\n             * @name close_all.jstree\n             * @param {Object} node the closed node\n             */\n            this.trigger('close_all', { \"node\" : obj });\n        },\n        /**\n         * checks if a node is disabled (not selectable)\n         * @name is_disabled(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        is_disabled : function (obj) {\n            obj = this.get_node(obj);\n            return obj && obj.state && obj.state.disabled;\n        },\n        /**\n         * enables a node - so that it can be selected\n         * @name enable_node(obj)\n         * @param {mixed} obj the node to enable\n         * @trigger enable_node.jstree\n         */\n        enable_node : function (obj) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.enable_node(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            obj.state.disabled = false;\n            this.get_node(obj,true).children('.jstree-anchor').removeClass('jstree-disabled').attr('aria-disabled', false);\n            /**\n             * triggered when an node is enabled\n             * @event\n             * @name enable_node.jstree\n             * @param {Object} node the enabled node\n             */\n            this.trigger('enable_node', { 'node' : obj });\n        },\n        /**\n         * disables a node - so that it can not be selected\n         * @name disable_node(obj)\n         * @param {mixed} obj the node to disable\n         * @trigger disable_node.jstree\n         */\n        disable_node : function (obj) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.disable_node(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            obj.state.disabled = true;\n            this.get_node(obj,true).children('.jstree-anchor').addClass('jstree-disabled').attr('aria-disabled', true);\n            /**\n             * triggered when an node is disabled\n             * @event\n             * @name disable_node.jstree\n             * @param {Object} node the disabled node\n             */\n            this.trigger('disable_node', { 'node' : obj });\n        },\n        /**\n         * determines if a node is hidden\n         * @name is_hidden(obj)\n         * @param {mixed} obj the node\n         */\n        is_hidden : function (obj) {\n            obj = this.get_node(obj);\n            return obj.state.hidden === true;\n        },\n        /**\n         * hides a node - it is still in the structure but will not be visible\n         * @name hide_node(obj)\n         * @param {mixed} obj the node to hide\n         * @param {Boolean} skip_redraw internal parameter controlling if redraw is called\n         * @trigger hide_node.jstree\n         */\n        hide_node : function (obj, skip_redraw) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.hide_node(obj[t1], true);\n                }\n                if (!skip_redraw) {\n                    this.redraw();\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            if(!obj.state.hidden) {\n                obj.state.hidden = true;\n                this._node_changed(obj.parent);\n                if(!skip_redraw) {\n                    this.redraw();\n                }\n                /**\n                 * triggered when an node is hidden\n                 * @event\n                 * @name hide_node.jstree\n                 * @param {Object} node the hidden node\n                 */\n                this.trigger('hide_node', { 'node' : obj });\n            }\n        },\n        /**\n         * shows a node\n         * @name show_node(obj)\n         * @param {mixed} obj the node to show\n         * @param {Boolean} skip_redraw internal parameter controlling if redraw is called\n         * @trigger show_node.jstree\n         */\n        show_node : function (obj, skip_redraw) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.show_node(obj[t1], true);\n                }\n                if (!skip_redraw) {\n                    this.redraw();\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            if(obj.state.hidden) {\n                obj.state.hidden = false;\n                this._node_changed(obj.parent);\n                if(!skip_redraw) {\n                    this.redraw();\n                }\n                /**\n                 * triggered when an node is shown\n                 * @event\n                 * @name show_node.jstree\n                 * @param {Object} node the shown node\n                 */\n                this.trigger('show_node', { 'node' : obj });\n            }\n        },\n        /**\n         * hides all nodes\n         * @name hide_all()\n         * @trigger hide_all.jstree\n         */\n        hide_all : function (skip_redraw) {\n            var i, m = this._model.data, ids = [];\n            for(i in m) {\n                if(m.hasOwnProperty(i) && i !== $.jstree.root && !m[i].state.hidden) {\n                    m[i].state.hidden = true;\n                    ids.push(i);\n                }\n            }\n            this._model.force_full_redraw = true;\n            if(!skip_redraw) {\n                this.redraw();\n            }\n            /**\n             * triggered when all nodes are hidden\n             * @event\n             * @name hide_all.jstree\n             * @param {Array} nodes the IDs of all hidden nodes\n             */\n            this.trigger('hide_all', { 'nodes' : ids });\n            return ids;\n        },\n        /**\n         * shows all nodes\n         * @name show_all()\n         * @trigger show_all.jstree\n         */\n        show_all : function (skip_redraw) {\n            var i, m = this._model.data, ids = [];\n            for(i in m) {\n                if(m.hasOwnProperty(i) && i !== $.jstree.root && m[i].state.hidden) {\n                    m[i].state.hidden = false;\n                    ids.push(i);\n                }\n            }\n            this._model.force_full_redraw = true;\n            if(!skip_redraw) {\n                this.redraw();\n            }\n            /**\n             * triggered when all nodes are shown\n             * @event\n             * @name show_all.jstree\n             * @param {Array} nodes the IDs of all shown nodes\n             */\n            this.trigger('show_all', { 'nodes' : ids });\n            return ids;\n        },\n        /**\n         * called when a node is selected by the user. Used internally.\n         * @private\n         * @name activate_node(obj, e)\n         * @param {mixed} obj the node\n         * @param {Object} e the related event\n         * @trigger activate_node.jstree, changed.jstree\n         */\n        activate_node : function (obj, e) {\n            if(this.is_disabled(obj)) {\n                return false;\n            }\n            if(!e || typeof e !== 'object') {\n                e = {};\n            }\n\n            // ensure last_clicked is still in the DOM, make it fresh (maybe it was moved?) and make sure it is still selected, if not - make last_clicked the last selected node\n            this._data.core.last_clicked = this._data.core.last_clicked && this._data.core.last_clicked.id !== undefined ? this.get_node(this._data.core.last_clicked.id) : null;\n            if(this._data.core.last_clicked && !this._data.core.last_clicked.state.selected) { this._data.core.last_clicked = null; }\n            if(!this._data.core.last_clicked && this._data.core.selected.length) { this._data.core.last_clicked = this.get_node(this._data.core.selected[this._data.core.selected.length - 1]); }\n\n            if(!this.settings.core.multiple || (!e.metaKey && !e.ctrlKey && !e.shiftKey) || (e.shiftKey && (!this._data.core.last_clicked || !this.get_parent(obj) || this.get_parent(obj) !== this._data.core.last_clicked.parent ) )) {\n                if(!this.settings.core.multiple && (e.metaKey || e.ctrlKey || e.shiftKey) && this.is_selected(obj)) {\n                    this.deselect_node(obj, false, e);\n                }\n                else {\n                    this.deselect_all(true);\n                    this.select_node(obj, false, false, e);\n                    this._data.core.last_clicked = this.get_node(obj);\n                }\n            }\n            else {\n                if(e.shiftKey) {\n                    var o = this.get_node(obj).id,\n                        l = this._data.core.last_clicked.id,\n                        p = this.get_node(this._data.core.last_clicked.parent).children,\n                        c = false,\n                        i, j;\n                    for(i = 0, j = p.length; i < j; i += 1) {\n                        // separate IFs work whem o and l are the same\n                        if(p[i] === o) {\n                            c = !c;\n                        }\n                        if(p[i] === l) {\n                            c = !c;\n                        }\n                        if(!this.is_disabled(p[i]) && (c || p[i] === o || p[i] === l)) {\n                            if (!this.is_hidden(p[i])) {\n                                this.select_node(p[i], true, false, e);\n                            }\n                        }\n                        else {\n                            this.deselect_node(p[i], true, e);\n                        }\n                    }\n                    this.trigger('changed', { 'action' : 'select_node', 'node' : this.get_node(obj), 'selected' : this._data.core.selected, 'event' : e });\n                }\n                else {\n                    if(!this.is_selected(obj)) {\n                        this.select_node(obj, false, false, e);\n                    }\n                    else {\n                        this.deselect_node(obj, false, e);\n                    }\n                }\n            }\n            /**\n             * triggered when an node is clicked or intercated with by the user\n             * @event\n             * @name activate_node.jstree\n             * @param {Object} node\n             * @param {Object} event the ooriginal event (if any) which triggered the call (may be an empty object)\n             */\n            this.trigger('activate_node', { 'node' : this.get_node(obj), 'event' : e });\n        },\n        /**\n         * applies the hover state on a node, called when a node is hovered by the user. Used internally.\n         * @private\n         * @name hover_node(obj)\n         * @param {mixed} obj\n         * @trigger hover_node.jstree\n         */\n        hover_node : function (obj) {\n            obj = this.get_node(obj, true);\n            if(!obj || !obj.length || obj.children('.jstree-hovered').length) {\n                return false;\n            }\n            var o = this.element.find('.jstree-hovered'), t = this.element;\n            if(o && o.length) { this.dehover_node(o); }\n\n            obj.children('.jstree-anchor').addClass('jstree-hovered');\n            /**\n             * triggered when an node is hovered\n             * @event\n             * @name hover_node.jstree\n             * @param {Object} node\n             */\n            this.trigger('hover_node', { 'node' : this.get_node(obj) });\n            setTimeout(function () { t.attr('aria-activedescendant', obj[0].id); }, 0);\n        },\n        /**\n         * removes the hover state from a nodecalled when a node is no longer hovered by the user. Used internally.\n         * @private\n         * @name dehover_node(obj)\n         * @param {mixed} obj\n         * @trigger dehover_node.jstree\n         */\n        dehover_node : function (obj) {\n            obj = this.get_node(obj, true);\n            if(!obj || !obj.length || !obj.children('.jstree-hovered').length) {\n                return false;\n            }\n            obj.children('.jstree-anchor').removeClass('jstree-hovered');\n            /**\n             * triggered when an node is no longer hovered\n             * @event\n             * @name dehover_node.jstree\n             * @param {Object} node\n             */\n            this.trigger('dehover_node', { 'node' : this.get_node(obj) });\n        },\n        /**\n         * select a node\n         * @name select_node(obj [, supress_event, prevent_open])\n         * @param {mixed} obj an array can be used to select multiple nodes\n         * @param {Boolean} supress_event if set to `true` the `changed.jstree` event won't be triggered\n         * @param {Boolean} prevent_open if set to `true` parents of the selected node won't be opened\n         * @trigger select_node.jstree, changed.jstree\n         */\n        select_node : function (obj, supress_event, prevent_open, e) {\n            var dom, t1, t2, th;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.select_node(obj[t1], supress_event, prevent_open, e);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(!obj.state.selected) {\n                obj.state.selected = true;\n                this._data.core.selected.push(obj.id);\n                if(!prevent_open) {\n                    dom = this._open_to(obj);\n                }\n                if(dom && dom.length) {\n                    dom.children('.jstree-anchor').addClass('jstree-clicked').attr('aria-selected', true);\n                }\n                /**\n                 * triggered when an node is selected\n                 * @event\n                 * @name select_node.jstree\n                 * @param {Object} node\n                 * @param {Array} selected the current selection\n                 * @param {Object} event the event (if any) that triggered this select_node\n                 */\n                this.trigger('select_node', { 'node' : obj, 'selected' : this._data.core.selected, 'event' : e });\n                if(!supress_event) {\n                    /**\n                     * triggered when selection changes\n                     * @event\n                     * @name changed.jstree\n                     * @param {Object} node\n                     * @param {Object} action the action that caused the selection to change\n                     * @param {Array} selected the current selection\n                     * @param {Object} event the event (if any) that triggered this changed event\n                     */\n                    this.trigger('changed', { 'action' : 'select_node', 'node' : obj, 'selected' : this._data.core.selected, 'event' : e });\n                }\n            }\n        },\n        /**\n         * deselect a node\n         * @name deselect_node(obj [, supress_event])\n         * @param {mixed} obj an array can be used to deselect multiple nodes\n         * @param {Boolean} supress_event if set to `true` the `changed.jstree` event won't be triggered\n         * @trigger deselect_node.jstree, changed.jstree\n         */\n        deselect_node : function (obj, supress_event, e) {\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.deselect_node(obj[t1], supress_event, e);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(obj.state.selected) {\n                obj.state.selected = false;\n                this._data.core.selected = $.vakata.array_remove_item(this._data.core.selected, obj.id);\n                if(dom.length) {\n                    dom.children('.jstree-anchor').removeClass('jstree-clicked').attr('aria-selected', false);\n                }\n                /**\n                 * triggered when an node is deselected\n                 * @event\n                 * @name deselect_node.jstree\n                 * @param {Object} node\n                 * @param {Array} selected the current selection\n                 * @param {Object} event the event (if any) that triggered this deselect_node\n                 */\n                this.trigger('deselect_node', { 'node' : obj, 'selected' : this._data.core.selected, 'event' : e });\n                if(!supress_event) {\n                    this.trigger('changed', { 'action' : 'deselect_node', 'node' : obj, 'selected' : this._data.core.selected, 'event' : e });\n                }\n            }\n        },\n        /**\n         * select all nodes in the tree\n         * @name select_all([supress_event])\n         * @param {Boolean} supress_event if set to `true` the `changed.jstree` event won't be triggered\n         * @trigger select_all.jstree, changed.jstree\n         */\n        select_all : function (supress_event) {\n            var tmp = this._data.core.selected.concat([]), i, j;\n            this._data.core.selected = this._model.data[$.jstree.root].children_d.concat();\n            for(i = 0, j = this._data.core.selected.length; i < j; i++) {\n                if(this._model.data[this._data.core.selected[i]]) {\n                    this._model.data[this._data.core.selected[i]].state.selected = true;\n                }\n            }\n            this.redraw(true);\n            /**\n             * triggered when all nodes are selected\n             * @event\n             * @name select_all.jstree\n             * @param {Array} selected the current selection\n             */\n            this.trigger('select_all', { 'selected' : this._data.core.selected });\n            if(!supress_event) {\n                this.trigger('changed', { 'action' : 'select_all', 'selected' : this._data.core.selected, 'old_selection' : tmp });\n            }\n        },\n        /**\n         * deselect all selected nodes\n         * @name deselect_all([supress_event])\n         * @param {Boolean} supress_event if set to `true` the `changed.jstree` event won't be triggered\n         * @trigger deselect_all.jstree, changed.jstree\n         */\n        deselect_all : function (supress_event) {\n            var tmp = this._data.core.selected.concat([]), i, j;\n            for(i = 0, j = this._data.core.selected.length; i < j; i++) {\n                if(this._model.data[this._data.core.selected[i]]) {\n                    this._model.data[this._data.core.selected[i]].state.selected = false;\n                }\n            }\n            this._data.core.selected = [];\n            this.element.find('.jstree-clicked').removeClass('jstree-clicked').attr('aria-selected', false);\n            /**\n             * triggered when all nodes are deselected\n             * @event\n             * @name deselect_all.jstree\n             * @param {Object} node the previous selection\n             * @param {Array} selected the current selection\n             */\n            this.trigger('deselect_all', { 'selected' : this._data.core.selected, 'node' : tmp });\n            if(!supress_event) {\n                this.trigger('changed', { 'action' : 'deselect_all', 'selected' : this._data.core.selected, 'old_selection' : tmp });\n            }\n        },\n        /**\n         * checks if a node is selected\n         * @name is_selected(obj)\n         * @param  {mixed}  obj\n         * @return {Boolean}\n         */\n        is_selected : function (obj) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            return obj.state.selected;\n        },\n        /**\n         * get an array of all selected nodes\n         * @name get_selected([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         */\n        get_selected : function (full) {\n            return full ? $.map(this._data.core.selected, function (i) { return this.get_node(i); }.bind(this)) : this._data.core.selected.slice();\n        },\n        /**\n         * get an array of all top level selected nodes (ignoring children of selected nodes)\n         * @name get_top_selected([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         */\n        get_top_selected : function (full) {\n            var tmp = this.get_selected(true),\n                obj = {}, i, j, k, l;\n            for(i = 0, j = tmp.length; i < j; i++) {\n                obj[tmp[i].id] = tmp[i];\n            }\n            for(i = 0, j = tmp.length; i < j; i++) {\n                for(k = 0, l = tmp[i].children_d.length; k < l; k++) {\n                    if(obj[tmp[i].children_d[k]]) {\n                        delete obj[tmp[i].children_d[k]];\n                    }\n                }\n            }\n            tmp = [];\n            for(i in obj) {\n                if(obj.hasOwnProperty(i)) {\n                    tmp.push(i);\n                }\n            }\n            return full ? $.map(tmp, function (i) { return this.get_node(i); }.bind(this)) : tmp;\n        },\n        /**\n         * get an array of all bottom level selected nodes (ignoring selected parents)\n         * @name get_bottom_selected([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         */\n        get_bottom_selected : function (full) {\n            var tmp = this.get_selected(true),\n                obj = [], i, j;\n            for(i = 0, j = tmp.length; i < j; i++) {\n                if(!tmp[i].children.length) {\n                    obj.push(tmp[i].id);\n                }\n            }\n            return full ? $.map(obj, function (i) { return this.get_node(i); }.bind(this)) : obj;\n        },\n        /**\n         * gets the current state of the tree so that it can be restored later with `set_state(state)`. Used internally.\n         * @name get_state()\n         * @private\n         * @return {Object}\n         */\n        get_state : function () {\n            var state\t= {\n                'core' : {\n                    'open' : [],\n                    'loaded' : [],\n                    'scroll' : {\n                        'left' : this.element.scrollLeft(),\n                        'top' : this.element.scrollTop()\n                    },\n                    /*!\n\t\t\t\t\t'themes' : {\n\t\t\t\t\t\t'name' : this.get_theme(),\n\t\t\t\t\t\t'icons' : this._data.core.themes.icons,\n\t\t\t\t\t\t'dots' : this._data.core.themes.dots\n\t\t\t\t\t},\n\t\t\t\t\t*/\n                    'selected' : []\n                }\n            }, i;\n            for(i in this._model.data) {\n                if(this._model.data.hasOwnProperty(i)) {\n                    if(i !== $.jstree.root) {\n                        if(this._model.data[i].state.loaded && this.settings.core.loaded_state) {\n                            state.core.loaded.push(i);\n                        }\n                        if(this._model.data[i].state.opened) {\n                            state.core.open.push(i);\n                        }\n                        if(this._model.data[i].state.selected) {\n                            state.core.selected.push(i);\n                        }\n                    }\n                }\n            }\n            return state;\n        },\n        /**\n         * sets the state of the tree. Used internally.\n         * @name set_state(state [, callback])\n         * @private\n         * @param {Object} state the state to restore. Keep in mind this object is passed by reference and jstree will modify it.\n         * @param {Function} callback an optional function to execute once the state is restored.\n         * @trigger set_state.jstree\n         */\n        set_state : function (state, callback) {\n            if(state) {\n                if(state.core && state.core.selected && state.core.initial_selection === undefined) {\n                    state.core.initial_selection = this._data.core.selected.concat([]).sort().join(',');\n                }\n                if(state.core) {\n                    var res, n, t, _this, i;\n                    if(state.core.loaded) {\n                        if(!this.settings.core.loaded_state || !$.vakata.is_array(state.core.loaded) || !state.core.loaded.length) {\n                            delete state.core.loaded;\n                            this.set_state(state, callback);\n                        }\n                        else {\n                            this._load_nodes(state.core.loaded, function (nodes) {\n                                delete state.core.loaded;\n                                this.set_state(state, callback);\n                            });\n                        }\n                        return false;\n                    }\n                    if(state.core.open) {\n                        if(!$.vakata.is_array(state.core.open) || !state.core.open.length) {\n                            delete state.core.open;\n                            this.set_state(state, callback);\n                        }\n                        else {\n                            this._load_nodes(state.core.open, function (nodes) {\n                                this.open_node(nodes, false, 0);\n                                delete state.core.open;\n                                this.set_state(state, callback);\n                            });\n                        }\n                        return false;\n                    }\n                    if(state.core.scroll) {\n                        if(state.core.scroll && state.core.scroll.left !== undefined) {\n                            this.element.scrollLeft(state.core.scroll.left);\n                        }\n                        if(state.core.scroll && state.core.scroll.top !== undefined) {\n                            this.element.scrollTop(state.core.scroll.top);\n                        }\n                        delete state.core.scroll;\n                        this.set_state(state, callback);\n                        return false;\n                    }\n                    if(state.core.selected) {\n                        _this = this;\n                        if (state.core.initial_selection === undefined ||\n                            state.core.initial_selection === this._data.core.selected.concat([]).sort().join(',')\n                        ) {\n                            this.deselect_all();\n                            $.each(state.core.selected, function (i, v) {\n                                _this.select_node(v, false, true);\n                            });\n                        }\n                        delete state.core.initial_selection;\n                        delete state.core.selected;\n                        this.set_state(state, callback);\n                        return false;\n                    }\n                    for(i in state) {\n                        if(state.hasOwnProperty(i) && i !== \"core\" && $.inArray(i, this.settings.plugins) === -1) {\n                            delete state[i];\n                        }\n                    }\n                    if($.isEmptyObject(state.core)) {\n                        delete state.core;\n                        this.set_state(state, callback);\n                        return false;\n                    }\n                }\n                if($.isEmptyObject(state)) {\n                    state = null;\n                    if(callback) { callback.call(this); }\n                    /**\n                     * triggered when a `set_state` call completes\n                     * @event\n                     * @name set_state.jstree\n                     */\n                    this.trigger('set_state');\n                    return false;\n                }\n                return true;\n            }\n            return false;\n        },\n        /**\n         * refreshes the tree - all nodes are reloaded with calls to `load_node`.\n         * @name refresh()\n         * @param {Boolean} skip_loading an option to skip showing the loading indicator\n         * @param {Mixed} forget_state if set to `true` state will not be reapplied, if set to a function (receiving the current state as argument) the result of that function will be used as state\n         * @trigger refresh.jstree\n         */\n        refresh : function (skip_loading, forget_state) {\n            this._data.core.state = forget_state === true ? {} : this.get_state();\n            if(forget_state && $.vakata.is_function(forget_state)) { this._data.core.state = forget_state.call(this, this._data.core.state); }\n            this._cnt = 0;\n            this._model.data = {};\n            this._model.data[$.jstree.root] = {\n                id : $.jstree.root,\n                parent : null,\n                parents : [],\n                children : [],\n                children_d : [],\n                state : { loaded : false }\n            };\n            this._data.core.selected = [];\n            this._data.core.last_clicked = null;\n            this._data.core.focused = null;\n\n            var c = this.get_container_ul()[0].className;\n            if(!skip_loading) {\n                this.element.html(\"<\"+\"ul class='\"+c+\"' role='group'><\"+\"li class='jstree-initial-node jstree-loading jstree-leaf jstree-last' role='none' id='j\"+this._id+\"_loading'><i class='jstree-icon jstree-ocl'></i><\"+\"a class='jstree-anchor' role='treeitem' href='#'><i class='jstree-icon jstree-themeicon-hidden'></i>\" + this.get_string(\"Loading ...\") + \"</a></li></ul>\");\n                this.element.attr('aria-activedescendant','j'+this._id+'_loading');\n            }\n            this.load_node($.jstree.root, function (o, s) {\n                if(s) {\n                    this.get_container_ul()[0].className = c;\n                    if(this._firstChild(this.get_container_ul()[0])) {\n                        this.element.attr('aria-activedescendant',this._firstChild(this.get_container_ul()[0]).id);\n                    }\n                    this.set_state($.extend(true, {}, this._data.core.state), function () {\n                        /**\n                         * triggered when a `refresh` call completes\n                         * @event\n                         * @name refresh.jstree\n                         */\n                        this.trigger('refresh');\n                    });\n                }\n                this._data.core.state = null;\n            });\n        },\n        /**\n         * refreshes a node in the tree (reload its children) all opened nodes inside that node are reloaded with calls to `load_node`.\n         * @name refresh_node(obj)\n         * @param  {mixed} obj the node\n         * @trigger refresh_node.jstree\n         */\n        refresh_node : function (obj) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            var opened = [], to_load = [], s = this._data.core.selected.concat([]);\n            to_load.push(obj.id);\n            if(obj.state.opened === true) { opened.push(obj.id); }\n            this.get_node(obj, true).find('.jstree-open').each(function() { to_load.push(this.id); opened.push(this.id); });\n            this._load_nodes(to_load, function (nodes) {\n                this.open_node(opened, false, 0);\n                this.select_node(s);\n                /**\n                 * triggered when a node is refreshed\n                 * @event\n                 * @name refresh_node.jstree\n                 * @param {Object} node - the refreshed node\n                 * @param {Array} nodes - an array of the IDs of the nodes that were reloaded\n                 */\n                this.trigger('refresh_node', { 'node' : obj, 'nodes' : nodes });\n            }.bind(this), false, true);\n        },\n        /**\n         * set (change) the ID of a node\n         * @name set_id(obj, id)\n         * @param  {mixed} obj the node\n         * @param  {String} id the new ID\n         * @return {Boolean}\n         * @trigger set_id.jstree\n         */\n        set_id : function (obj, id) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            var i, j, m = this._model.data, old = obj.id;\n            id = id.toString();\n            // update parents (replace current ID with new one in children and children_d)\n            m[obj.parent].children[$.inArray(obj.id, m[obj.parent].children)] = id;\n            for(i = 0, j = obj.parents.length; i < j; i++) {\n                m[obj.parents[i]].children_d[$.inArray(obj.id, m[obj.parents[i]].children_d)] = id;\n            }\n            // update children (replace current ID with new one in parent and parents)\n            for(i = 0, j = obj.children.length; i < j; i++) {\n                m[obj.children[i]].parent = id;\n            }\n            for(i = 0, j = obj.children_d.length; i < j; i++) {\n                m[obj.children_d[i]].parents[$.inArray(obj.id, m[obj.children_d[i]].parents)] = id;\n            }\n            i = $.inArray(obj.id, this._data.core.selected);\n            if(i !== -1) { this._data.core.selected[i] = id; }\n            // update model and obj itself (obj.id, this._model.data[KEY])\n            i = this.get_node(obj.id, true);\n            if(i) {\n                i.attr('id', id); //.children('.jstree-anchor').attr('id', id + '_anchor').end().attr('aria-labelledby', id + '_anchor');\n                if(this.element.attr('aria-activedescendant') === obj.id) {\n                    this.element.attr('aria-activedescendant', id);\n                }\n            }\n            delete m[obj.id];\n            obj.id = id;\n            obj.li_attr.id = id;\n            m[id] = obj;\n            /**\n             * triggered when a node id value is changed\n             * @event\n             * @name set_id.jstree\n             * @param {Object} node\n             * @param {String} old the old id\n             */\n            this.trigger('set_id',{ \"node\" : obj, \"new\" : obj.id, \"old\" : old });\n            return true;\n        },\n        /**\n         * get the text value of a node\n         * @name get_text(obj)\n         * @param  {mixed} obj the node\n         * @return {String}\n         */\n        get_text : function (obj) {\n            obj = this.get_node(obj);\n            return (!obj || obj.id === $.jstree.root) ? false : obj.text;\n        },\n        /**\n         * set the text value of a node. Used internally, please use `rename_node(obj, val)`.\n         * @private\n         * @name set_text(obj, val)\n         * @param  {mixed} obj the node, you can pass an array to set the text on multiple nodes\n         * @param  {String} val the new text value\n         * @return {Boolean}\n         * @trigger set_text.jstree\n         */\n        set_text : function (obj, val) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.set_text(obj[t1], val);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            obj.text = val;\n            if(this.get_node(obj, true).length) {\n                this.redraw_node(obj.id);\n            }\n            /**\n             * triggered when a node text value is changed\n             * @event\n             * @name set_text.jstree\n             * @param {Object} obj\n             * @param {String} text the new value\n             */\n            this.trigger('set_text',{ \"obj\" : obj, \"text\" : val });\n            return true;\n        },\n        /**\n         * gets a JSON representation of a node (or the whole tree)\n         * @name get_json([obj, options])\n         * @param  {mixed} obj\n         * @param  {Object} options\n         * @param  {Boolean} options.no_state do not return state information\n         * @param  {Boolean} options.no_id do not return ID\n         * @param  {Boolean} options.no_children do not include children\n         * @param  {Boolean} options.no_data do not include node data\n         * @param  {Boolean} options.no_li_attr do not include LI attributes\n         * @param  {Boolean} options.no_a_attr do not include A attributes\n         * @param  {Boolean} options.flat return flat JSON instead of nested\n         * @return {Object}\n         */\n        get_json : function (obj, options, flat) {\n            obj = this.get_node(obj || $.jstree.root);\n            if(!obj) { return false; }\n            if(options && options.flat && !flat) { flat = []; }\n            var tmp = {\n                'id' : obj.id,\n                'text' : obj.text,\n                'icon' : this.get_icon(obj),\n                'li_attr' : $.extend(true, {}, obj.li_attr),\n                'a_attr' : $.extend(true, {}, obj.a_attr),\n                'state' : {},\n                'data' : options && options.no_data ? false : $.extend(true, $.vakata.is_array(obj.data)?[]:{}, obj.data)\n                //( this.get_node(obj, true).length ? this.get_node(obj, true).data() : obj.data ),\n            }, i, j;\n            if(options && options.flat) {\n                tmp.parent = obj.parent;\n            }\n            else {\n                tmp.children = [];\n            }\n            if(!options || !options.no_state) {\n                for(i in obj.state) {\n                    if(obj.state.hasOwnProperty(i)) {\n                        tmp.state[i] = obj.state[i];\n                    }\n                }\n            } else {\n                delete tmp.state;\n            }\n            if(options && options.no_li_attr) {\n                delete tmp.li_attr;\n            }\n            if(options && options.no_a_attr) {\n                delete tmp.a_attr;\n            }\n            if(options && options.no_id) {\n                delete tmp.id;\n                if(tmp.li_attr && tmp.li_attr.id) {\n                    delete tmp.li_attr.id;\n                }\n                if(tmp.a_attr && tmp.a_attr.id) {\n                    delete tmp.a_attr.id;\n                }\n            }\n            if(options && options.flat && obj.id !== $.jstree.root) {\n                flat.push(tmp);\n            }\n            if(!options || !options.no_children) {\n                for(i = 0, j = obj.children.length; i < j; i++) {\n                    if(options && options.flat) {\n                        this.get_json(obj.children[i], options, flat);\n                    }\n                    else {\n                        tmp.children.push(this.get_json(obj.children[i], options));\n                    }\n                }\n            }\n            return options && options.flat ? flat : (obj.id === $.jstree.root ? tmp.children : tmp);\n        },\n        /**\n         * create a new node (do not confuse with load_node)\n         * @name create_node([par, node, pos, callback, is_loaded])\n         * @param  {mixed}   par       the parent node (to create a root node use either \"#\" (string) or `null`)\n         * @param  {mixed}   node      the data for the new node (a valid JSON object, or a simple string with the name)\n         * @param  {mixed}   pos       the index at which to insert the node, \"first\" and \"last\" are also supported, default is \"last\"\n         * @param  {Function} callback a function to be called once the node is created\n         * @param  {Boolean} is_loaded internal argument indicating if the parent node was succesfully loaded\n         * @return {String}            the ID of the newly create node\n         * @trigger model.jstree, create_node.jstree\n         */\n        create_node : function (par, node, pos, callback, is_loaded) {\n            if(par === null) { par = $.jstree.root; }\n            par = this.get_node(par);\n            if(!par) { return false; }\n            pos = pos === undefined ? \"last\" : pos;\n            if(!pos.toString().match(/^(before|after)$/) && !is_loaded && !this.is_loaded(par)) {\n                return this.load_node(par, function () { this.create_node(par, node, pos, callback, true); });\n            }\n            if(!node) { node = { \"text\" : this.get_string('New node') }; }\n            if(typeof node === \"string\") {\n                node = { \"text\" : node };\n            } else {\n                node = $.extend(true, {}, node);\n            }\n            if(node.text === undefined) { node.text = this.get_string('New node'); }\n            var tmp, dpc, i, j;\n\n            if(par.id === $.jstree.root) {\n                if(pos === \"before\") { pos = \"first\"; }\n                if(pos === \"after\") { pos = \"last\"; }\n            }\n            switch(pos) {\n                case \"before\":\n                    tmp = this.get_node(par.parent);\n                    pos = $.inArray(par.id, tmp.children);\n                    par = tmp;\n                    break;\n                case \"after\" :\n                    tmp = this.get_node(par.parent);\n                    pos = $.inArray(par.id, tmp.children) + 1;\n                    par = tmp;\n                    break;\n                case \"inside\":\n                case \"first\":\n                    pos = 0;\n                    break;\n                case \"last\":\n                    pos = par.children.length;\n                    break;\n                default:\n                    if(!pos) { pos = 0; }\n                    break;\n            }\n            if(pos > par.children.length) { pos = par.children.length; }\n            if(!node.id) { node.id = true; }\n            if(!this.check(\"create_node\", node, par, pos)) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            if(node.id === true) { delete node.id; }\n            node = this._parse_model_from_json(node, par.id, par.parents.concat());\n            if(!node) { return false; }\n            tmp = this.get_node(node);\n            dpc = [];\n            dpc.push(node);\n            dpc = dpc.concat(tmp.children_d);\n            this.trigger('model', { \"nodes\" : dpc, \"parent\" : par.id });\n\n            par.children_d = par.children_d.concat(dpc);\n            for(i = 0, j = par.parents.length; i < j; i++) {\n                this._model.data[par.parents[i]].children_d = this._model.data[par.parents[i]].children_d.concat(dpc);\n            }\n            node = tmp;\n            tmp = [];\n            for(i = 0, j = par.children.length; i < j; i++) {\n                tmp[i >= pos ? i+1 : i] = par.children[i];\n            }\n            tmp[pos] = node.id;\n            par.children = tmp;\n\n            this.redraw_node(par, true);\n            /**\n             * triggered when a node is created\n             * @event\n             * @name create_node.jstree\n             * @param {Object} node\n             * @param {String} parent the parent's ID\n             * @param {Number} position the position of the new node among the parent's children\n             */\n            this.trigger('create_node', { \"node\" : this.get_node(node), \"parent\" : par.id, \"position\" : pos });\n            if(callback) { callback.call(this, this.get_node(node)); }\n            return node.id;\n        },\n        /**\n         * set the text value of a node\n         * @name rename_node(obj, val)\n         * @param  {mixed} obj the node, you can pass an array to rename multiple nodes to the same name\n         * @param  {String} val the new text value\n         * @return {Boolean}\n         * @trigger rename_node.jstree\n         */\n        rename_node : function (obj, val) {\n            var t1, t2, old;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.rename_node(obj[t1], val);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            old = obj.text;\n            if(!this.check(\"rename_node\", obj, this.get_parent(obj), val)) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            this.set_text(obj, val); // .apply(this, Array.prototype.slice.call(arguments))\n            /**\n             * triggered when a node is renamed\n             * @event\n             * @name rename_node.jstree\n             * @param {Object} node\n             * @param {String} text the new value\n             * @param {String} old the old value\n             */\n            this.trigger('rename_node', { \"node\" : obj, \"text\" : val, \"old\" : old });\n            return true;\n        },\n        /**\n         * remove a node\n         * @name delete_node(obj)\n         * @param  {mixed} obj the node, you can pass an array to delete multiple nodes\n         * @return {Boolean}\n         * @trigger delete_node.jstree, changed.jstree\n         */\n        delete_node : function (obj) {\n            var t1, t2, par, pos, tmp, i, j, k, l, c, top, lft;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.delete_node(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            par = this.get_node(obj.parent);\n            pos = $.inArray(obj.id, par.children);\n            c = false;\n            if(!this.check(\"delete_node\", obj, par, pos)) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            if(pos !== -1) {\n                par.children = $.vakata.array_remove(par.children, pos);\n            }\n            tmp = obj.children_d.concat([]);\n            tmp.push(obj.id);\n            for(i = 0, j = obj.parents.length; i < j; i++) {\n                this._model.data[obj.parents[i]].children_d = $.vakata.array_filter(this._model.data[obj.parents[i]].children_d, function (v) {\n                    return $.inArray(v, tmp) === -1;\n                });\n            }\n            for(k = 0, l = tmp.length; k < l; k++) {\n                if(this._model.data[tmp[k]].state.selected) {\n                    c = true;\n                    break;\n                }\n            }\n            if (c) {\n                this._data.core.selected = $.vakata.array_filter(this._data.core.selected, function (v) {\n                    return $.inArray(v, tmp) === -1;\n                });\n            }\n            /**\n             * triggered when a node is deleted\n             * @event\n             * @name delete_node.jstree\n             * @param {Object} node\n             * @param {String} parent the parent's ID\n             */\n            this.trigger('delete_node', { \"node\" : obj, \"parent\" : par.id });\n            if(c) {\n                this.trigger('changed', { 'action' : 'delete_node', 'node' : obj, 'selected' : this._data.core.selected, 'parent' : par.id });\n            }\n            for(k = 0, l = tmp.length; k < l; k++) {\n                delete this._model.data[tmp[k]];\n            }\n            if($.inArray(this._data.core.focused, tmp) !== -1) {\n                this._data.core.focused = null;\n                top = this.element[0].scrollTop;\n                lft = this.element[0].scrollLeft;\n                if(par.id === $.jstree.root) {\n                    if (this._model.data[$.jstree.root].children[0]) {\n                        this.get_node(this._model.data[$.jstree.root].children[0], true).children('.jstree-anchor').triger('focus');\n                    }\n                }\n                else {\n                    this.get_node(par, true).children('.jstree-anchor').trigger('focus');\n                }\n                this.element[0].scrollTop  = top;\n                this.element[0].scrollLeft = lft;\n            }\n            this.redraw_node(par, true);\n            return true;\n        },\n        /**\n         * check if an operation is premitted on the tree. Used internally.\n         * @private\n         * @name check(chk, obj, par, pos)\n         * @param  {String} chk the operation to check, can be \"create_node\", \"rename_node\", \"delete_node\", \"copy_node\" or \"move_node\"\n         * @param  {mixed} obj the node\n         * @param  {mixed} par the parent\n         * @param  {mixed} pos the position to insert at, or if \"rename_node\" - the new name\n         * @param  {mixed} more some various additional information, for example if a \"move_node\" operations is triggered by DND this will be the hovered node\n         * @return {Boolean}\n         */\n        check : function (chk, obj, par, pos, more) {\n            obj = obj && obj.id ? obj : this.get_node(obj);\n            par = par && par.id ? par : this.get_node(par);\n            var tmp = chk.match(/^move_node|copy_node|create_node$/i) ? par : obj,\n                chc = this.settings.core.check_callback;\n            if(chk === \"move_node\" || chk === \"copy_node\") {\n                if((!more || !more.is_multi) && (chk === \"move_node\" && $.inArray(obj.id, par.children) === pos)) {\n                    this._data.core.last_error = { 'error' : 'check', 'plugin' : 'core', 'id' : 'core_08', 'reason' : 'Moving node to its current position', 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    return false;\n                }\n                if((!more || !more.is_multi) && (obj.id === par.id || (chk === \"move_node\" && $.inArray(obj.id, par.children) === pos) || $.inArray(par.id, obj.children_d) !== -1)) {\n                    this._data.core.last_error = { 'error' : 'check', 'plugin' : 'core', 'id' : 'core_01', 'reason' : 'Moving parent inside child', 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    return false;\n                }\n            }\n            if(tmp && tmp.data) { tmp = tmp.data; }\n            if(tmp && tmp.functions && (tmp.functions[chk] === false || tmp.functions[chk] === true)) {\n                if(tmp.functions[chk] === false) {\n                    this._data.core.last_error = { 'error' : 'check', 'plugin' : 'core', 'id' : 'core_02', 'reason' : 'Node data prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                }\n                return tmp.functions[chk];\n            }\n            if(chc === false || ($.vakata.is_function(chc) && chc.call(this, chk, obj, par, pos, more) === false) || (chc && chc[chk] === false)) {\n                this._data.core.last_error = { 'error' : 'check', 'plugin' : 'core', 'id' : 'core_03', 'reason' : 'User config for core.check_callback prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                return false;\n            }\n            return true;\n        },\n        /**\n         * get the last error\n         * @name last_error()\n         * @return {Object}\n         */\n        last_error : function () {\n            return this._data.core.last_error;\n        },\n        /**\n         * move a node to a new parent\n         * @name move_node(obj, par [, pos, callback, is_loaded])\n         * @param  {mixed} obj the node to move, pass an array to move multiple nodes\n         * @param  {mixed} par the new parent\n         * @param  {mixed} pos the position to insert at (besides integer values, \"first\" and \"last\" are supported, as well as \"before\" and \"after\"), defaults to integer `0`\n         * @param  {function} callback a function to call once the move is completed, receives 3 arguments - the node, the new parent and the position\n         * @param  {Boolean} is_loaded internal parameter indicating if the parent node has been loaded\n         * @param  {Boolean} skip_redraw internal parameter indicating if the tree should be redrawn\n         * @param  {Boolean} instance internal parameter indicating if the node comes from another instance\n         * @trigger move_node.jstree\n         */\n        move_node : function (obj, par, pos, callback, is_loaded, skip_redraw, origin) {\n            var t1, t2, old_par, old_pos, new_par, old_ins, is_multi, dpc, tmp, i, j, k, l, p;\n\n            par = this.get_node(par);\n            pos = pos === undefined ? 0 : pos;\n            if(!par) { return false; }\n            if(!pos.toString().match(/^(before|after)$/) && !is_loaded && !this.is_loaded(par)) {\n                return this.load_node(par, function () { this.move_node(obj, par, pos, callback, true, false, origin); });\n            }\n\n            if($.vakata.is_array(obj)) {\n                if(obj.length === 1) {\n                    obj = obj[0];\n                }\n                else {\n                    //obj = obj.slice();\n                    for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                        if((tmp = this.move_node(obj[t1], par, pos, callback, is_loaded, false, origin))) {\n                            par = tmp;\n                            pos = \"after\";\n                        }\n                    }\n                    this.redraw();\n                    return true;\n                }\n            }\n            obj = obj && obj.id ? obj : this.get_node(obj);\n\n            if(!obj || obj.id === $.jstree.root) { return false; }\n\n            old_par = (obj.parent || $.jstree.root).toString();\n            new_par = (!pos.toString().match(/^(before|after)$/) || par.id === $.jstree.root) ? par : this.get_node(par.parent);\n            old_ins = origin ? origin : (this._model.data[obj.id] ? this : $.jstree.reference(obj.id));\n            is_multi = !old_ins || !old_ins._id || (this._id !== old_ins._id);\n            old_pos = old_ins && old_ins._id && old_par && old_ins._model.data[old_par] && old_ins._model.data[old_par].children ? $.inArray(obj.id, old_ins._model.data[old_par].children) : -1;\n            if(old_ins && old_ins._id) {\n                obj = old_ins._model.data[obj.id];\n            }\n\n            if(is_multi) {\n                if((tmp = this.copy_node(obj, par, pos, callback, is_loaded, false, origin))) {\n                    if(old_ins) { old_ins.delete_node(obj); }\n                    return tmp;\n                }\n                return false;\n            }\n            //var m = this._model.data;\n            if(par.id === $.jstree.root) {\n                if(pos === \"before\") { pos = \"first\"; }\n                if(pos === \"after\") { pos = \"last\"; }\n            }\n            switch(pos) {\n                case \"before\":\n                    pos = $.inArray(par.id, new_par.children);\n                    break;\n                case \"after\" :\n                    pos = $.inArray(par.id, new_par.children) + 1;\n                    break;\n                case \"inside\":\n                case \"first\":\n                    pos = 0;\n                    break;\n                case \"last\":\n                    pos = new_par.children.length;\n                    break;\n                default:\n                    if(!pos) { pos = 0; }\n                    break;\n            }\n            if(pos > new_par.children.length) { pos = new_par.children.length; }\n            if(!this.check(\"move_node\", obj, new_par, pos, { 'core' : true, 'origin' : origin, 'is_multi' : (old_ins && old_ins._id && old_ins._id !== this._id), 'is_foreign' : (!old_ins || !old_ins._id) })) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            if(obj.parent === new_par.id) {\n                dpc = new_par.children.concat();\n                tmp = $.inArray(obj.id, dpc);\n                if(tmp !== -1) {\n                    dpc = $.vakata.array_remove(dpc, tmp);\n                    if(pos > tmp) { pos--; }\n                }\n                tmp = [];\n                for(i = 0, j = dpc.length; i < j; i++) {\n                    tmp[i >= pos ? i+1 : i] = dpc[i];\n                }\n                tmp[pos] = obj.id;\n                new_par.children = tmp;\n                this._node_changed(new_par.id);\n                this.redraw(new_par.id === $.jstree.root);\n            }\n            else {\n                // clean old parent and up\n                tmp = obj.children_d.concat();\n                tmp.push(obj.id);\n                for(i = 0, j = obj.parents.length; i < j; i++) {\n                    dpc = [];\n                    p = old_ins._model.data[obj.parents[i]].children_d;\n                    for(k = 0, l = p.length; k < l; k++) {\n                        if($.inArray(p[k], tmp) === -1) {\n                            dpc.push(p[k]);\n                        }\n                    }\n                    old_ins._model.data[obj.parents[i]].children_d = dpc;\n                }\n                old_ins._model.data[old_par].children = $.vakata.array_remove_item(old_ins._model.data[old_par].children, obj.id);\n\n                // insert into new parent and up\n                for(i = 0, j = new_par.parents.length; i < j; i++) {\n                    this._model.data[new_par.parents[i]].children_d = this._model.data[new_par.parents[i]].children_d.concat(tmp);\n                }\n                dpc = [];\n                for(i = 0, j = new_par.children.length; i < j; i++) {\n                    dpc[i >= pos ? i+1 : i] = new_par.children[i];\n                }\n                dpc[pos] = obj.id;\n                new_par.children = dpc;\n                new_par.children_d.push(obj.id);\n                new_par.children_d = new_par.children_d.concat(obj.children_d);\n\n                // update object\n                obj.parent = new_par.id;\n                tmp = new_par.parents.concat();\n                tmp.unshift(new_par.id);\n                p = obj.parents.length;\n                obj.parents = tmp;\n\n                // update object children\n                tmp = tmp.concat();\n                for(i = 0, j = obj.children_d.length; i < j; i++) {\n                    this._model.data[obj.children_d[i]].parents = this._model.data[obj.children_d[i]].parents.slice(0,p*-1);\n                    Array.prototype.push.apply(this._model.data[obj.children_d[i]].parents, tmp);\n                }\n\n                if(old_par === $.jstree.root || new_par.id === $.jstree.root) {\n                    this._model.force_full_redraw = true;\n                }\n                if(!this._model.force_full_redraw) {\n                    this._node_changed(old_par);\n                    this._node_changed(new_par.id);\n                }\n                if(!skip_redraw) {\n                    this.redraw();\n                }\n            }\n            if(callback) { callback.call(this, obj, new_par, pos); }\n            /**\n             * triggered when a node is moved\n             * @event\n             * @name move_node.jstree\n             * @param {Object} node\n             * @param {String} parent the parent's ID\n             * @param {Number} position the position of the node among the parent's children\n             * @param {String} old_parent the old parent of the node\n             * @param {Number} old_position the old position of the node\n             * @param {Boolean} is_multi do the node and new parent belong to different instances\n             * @param {jsTree} old_instance the instance the node came from\n             * @param {jsTree} new_instance the instance of the new parent\n             */\n            this.trigger('move_node', { \"node\" : obj, \"parent\" : new_par.id, \"position\" : pos, \"old_parent\" : old_par, \"old_position\" : old_pos, 'is_multi' : (old_ins && old_ins._id && old_ins._id !== this._id), 'is_foreign' : (!old_ins || !old_ins._id), 'old_instance' : old_ins, 'new_instance' : this });\n            return obj.id;\n        },\n        /**\n         * copy a node to a new parent\n         * @name copy_node(obj, par [, pos, callback, is_loaded])\n         * @param  {mixed} obj the node to copy, pass an array to copy multiple nodes\n         * @param  {mixed} par the new parent\n         * @param  {mixed} pos the position to insert at (besides integer values, \"first\" and \"last\" are supported, as well as \"before\" and \"after\"), defaults to integer `0`\n         * @param  {function} callback a function to call once the move is completed, receives 3 arguments - the node, the new parent and the position\n         * @param  {Boolean} is_loaded internal parameter indicating if the parent node has been loaded\n         * @param  {Boolean} skip_redraw internal parameter indicating if the tree should be redrawn\n         * @param  {Boolean} instance internal parameter indicating if the node comes from another instance\n         * @trigger model.jstree copy_node.jstree\n         */\n        copy_node : function (obj, par, pos, callback, is_loaded, skip_redraw, origin) {\n            var t1, t2, dpc, tmp, i, j, node, old_par, new_par, old_ins, is_multi;\n\n            par = this.get_node(par);\n            pos = pos === undefined ? 0 : pos;\n            if(!par) { return false; }\n            if(!pos.toString().match(/^(before|after)$/) && !is_loaded && !this.is_loaded(par)) {\n                return this.load_node(par, function () { this.copy_node(obj, par, pos, callback, true, false, origin); });\n            }\n\n            if($.vakata.is_array(obj)) {\n                if(obj.length === 1) {\n                    obj = obj[0];\n                }\n                else {\n                    //obj = obj.slice();\n                    for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                        if((tmp = this.copy_node(obj[t1], par, pos, callback, is_loaded, true, origin))) {\n                            par = tmp;\n                            pos = \"after\";\n                        }\n                    }\n                    this.redraw();\n                    return true;\n                }\n            }\n            obj = obj && obj.id ? obj : this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n\n            old_par = (obj.parent || $.jstree.root).toString();\n            new_par = (!pos.toString().match(/^(before|after)$/) || par.id === $.jstree.root) ? par : this.get_node(par.parent);\n            old_ins = origin ? origin : (this._model.data[obj.id] ? this : $.jstree.reference(obj.id));\n            is_multi = !old_ins || !old_ins._id || (this._id !== old_ins._id);\n\n            if(old_ins && old_ins._id) {\n                obj = old_ins._model.data[obj.id];\n            }\n\n            if(par.id === $.jstree.root) {\n                if(pos === \"before\") { pos = \"first\"; }\n                if(pos === \"after\") { pos = \"last\"; }\n            }\n            switch(pos) {\n                case \"before\":\n                    pos = $.inArray(par.id, new_par.children);\n                    break;\n                case \"after\" :\n                    pos = $.inArray(par.id, new_par.children) + 1;\n                    break;\n                case \"inside\":\n                case \"first\":\n                    pos = 0;\n                    break;\n                case \"last\":\n                    pos = new_par.children.length;\n                    break;\n                default:\n                    if(!pos) { pos = 0; }\n                    break;\n            }\n            if(pos > new_par.children.length) { pos = new_par.children.length; }\n            if(!this.check(\"copy_node\", obj, new_par, pos, { 'core' : true, 'origin' : origin, 'is_multi' : (old_ins && old_ins._id && old_ins._id !== this._id), 'is_foreign' : (!old_ins || !old_ins._id) })) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            node = old_ins ? old_ins.get_json(obj, { no_id : true, no_data : true, no_state : true }) : obj;\n            if(!node) { return false; }\n            if(node.id === true) { delete node.id; }\n            node = this._parse_model_from_json(node, new_par.id, new_par.parents.concat());\n            if(!node) { return false; }\n            tmp = this.get_node(node);\n            if(obj && obj.state && obj.state.loaded === false) { tmp.state.loaded = false; }\n            dpc = [];\n            dpc.push(node);\n            dpc = dpc.concat(tmp.children_d);\n            this.trigger('model', { \"nodes\" : dpc, \"parent\" : new_par.id });\n\n            // insert into new parent and up\n            for(i = 0, j = new_par.parents.length; i < j; i++) {\n                this._model.data[new_par.parents[i]].children_d = this._model.data[new_par.parents[i]].children_d.concat(dpc);\n            }\n            dpc = [];\n            for(i = 0, j = new_par.children.length; i < j; i++) {\n                dpc[i >= pos ? i+1 : i] = new_par.children[i];\n            }\n            dpc[pos] = tmp.id;\n            new_par.children = dpc;\n            new_par.children_d.push(tmp.id);\n            new_par.children_d = new_par.children_d.concat(tmp.children_d);\n\n            if(new_par.id === $.jstree.root) {\n                this._model.force_full_redraw = true;\n            }\n            if(!this._model.force_full_redraw) {\n                this._node_changed(new_par.id);\n            }\n            if(!skip_redraw) {\n                this.redraw(new_par.id === $.jstree.root);\n            }\n            if(callback) { callback.call(this, tmp, new_par, pos); }\n            /**\n             * triggered when a node is copied\n             * @event\n             * @name copy_node.jstree\n             * @param {Object} node the copied node\n             * @param {Object} original the original node\n             * @param {String} parent the parent's ID\n             * @param {Number} position the position of the node among the parent's children\n             * @param {String} old_parent the old parent of the node\n             * @param {Number} old_position the position of the original node\n             * @param {Boolean} is_multi do the node and new parent belong to different instances\n             * @param {jsTree} old_instance the instance the node came from\n             * @param {jsTree} new_instance the instance of the new parent\n             */\n            this.trigger('copy_node', { \"node\" : tmp, \"original\" : obj, \"parent\" : new_par.id, \"position\" : pos, \"old_parent\" : old_par, \"old_position\" : old_ins && old_ins._id && old_par && old_ins._model.data[old_par] && old_ins._model.data[old_par].children ? $.inArray(obj.id, old_ins._model.data[old_par].children) : -1,'is_multi' : (old_ins && old_ins._id && old_ins._id !== this._id), 'is_foreign' : (!old_ins || !old_ins._id), 'old_instance' : old_ins, 'new_instance' : this });\n            return tmp.id;\n        },\n        /**\n         * cut a node (a later call to `paste(obj)` would move the node)\n         * @name cut(obj)\n         * @param  {mixed} obj multiple objects can be passed using an array\n         * @trigger cut.jstree\n         */\n        cut : function (obj) {\n            if(!obj) { obj = this._data.core.selected.concat(); }\n            if(!$.vakata.is_array(obj)) { obj = [obj]; }\n            if(!obj.length) { return false; }\n            var tmp = [], o, t1, t2;\n            for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                o = this.get_node(obj[t1]);\n                if(o && o.id && o.id !== $.jstree.root) { tmp.push(o); }\n            }\n            if(!tmp.length) { return false; }\n            ccp_node = tmp;\n            ccp_inst = this;\n            ccp_mode = 'move_node';\n            /**\n             * triggered when nodes are added to the buffer for moving\n             * @event\n             * @name cut.jstree\n             * @param {Array} node\n             */\n            this.trigger('cut', { \"node\" : obj });\n        },\n        /**\n         * copy a node (a later call to `paste(obj)` would copy the node)\n         * @name copy(obj)\n         * @param  {mixed} obj multiple objects can be passed using an array\n         * @trigger copy.jstree\n         */\n        copy : function (obj) {\n            if(!obj) { obj = this._data.core.selected.concat(); }\n            if(!$.vakata.is_array(obj)) { obj = [obj]; }\n            if(!obj.length) { return false; }\n            var tmp = [], o, t1, t2;\n            for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                o = this.get_node(obj[t1]);\n                if(o && o.id && o.id !== $.jstree.root) { tmp.push(o); }\n            }\n            if(!tmp.length) { return false; }\n            ccp_node = tmp;\n            ccp_inst = this;\n            ccp_mode = 'copy_node';\n            /**\n             * triggered when nodes are added to the buffer for copying\n             * @event\n             * @name copy.jstree\n             * @param {Array} node\n             */\n            this.trigger('copy', { \"node\" : obj });\n        },\n        /**\n         * get the current buffer (any nodes that are waiting for a paste operation)\n         * @name get_buffer()\n         * @return {Object} an object consisting of `mode` (\"copy_node\" or \"move_node\"), `node` (an array of objects) and `inst` (the instance)\n         */\n        get_buffer : function () {\n            return { 'mode' : ccp_mode, 'node' : ccp_node, 'inst' : ccp_inst };\n        },\n        /**\n         * check if there is something in the buffer to paste\n         * @name can_paste()\n         * @return {Boolean}\n         */\n        can_paste : function () {\n            return ccp_mode !== false && ccp_node !== false; // && ccp_inst._model.data[ccp_node];\n        },\n        /**\n         * copy or move the previously cut or copied nodes to a new parent\n         * @name paste(obj [, pos])\n         * @param  {mixed} obj the new parent\n         * @param  {mixed} pos the position to insert at (besides integer, \"first\" and \"last\" are supported), defaults to integer `0`\n         * @trigger paste.jstree\n         */\n        paste : function (obj, pos) {\n            obj = this.get_node(obj);\n            if(!obj || !ccp_mode || !ccp_mode.match(/^(copy_node|move_node)$/) || !ccp_node) { return false; }\n            if(this[ccp_mode](ccp_node, obj, pos, false, false, false, ccp_inst)) {\n                /**\n                 * triggered when paste is invoked\n                 * @event\n                 * @name paste.jstree\n                 * @param {String} parent the ID of the receiving node\n                 * @param {Array} node the nodes in the buffer\n                 * @param {String} mode the performed operation - \"copy_node\" or \"move_node\"\n                 */\n                this.trigger('paste', { \"parent\" : obj.id, \"node\" : ccp_node, \"mode\" : ccp_mode });\n            }\n            ccp_node = false;\n            ccp_mode = false;\n            ccp_inst = false;\n        },\n        /**\n         * clear the buffer of previously copied or cut nodes\n         * @name clear_buffer()\n         * @trigger clear_buffer.jstree\n         */\n        clear_buffer : function () {\n            ccp_node = false;\n            ccp_mode = false;\n            ccp_inst = false;\n            /**\n             * triggered when the copy / cut buffer is cleared\n             * @event\n             * @name clear_buffer.jstree\n             */\n            this.trigger('clear_buffer');\n        },\n        /**\n         * put a node in edit mode (input field to rename the node)\n         * @name edit(obj [, default_text, callback])\n         * @param  {mixed} obj\n         * @param  {String} default_text the text to populate the input with (if omitted or set to a non-string value the node's text value is used)\n         * @param  {Function} callback a function to be called once the text box is blurred, it is called in the instance's scope and receives the node, a status parameter (true if the rename is successful, false otherwise), a boolean indicating if the user cancelled the edit and the original unescaped value provided by the user. You can also access the node's title using .text\n         */\n        edit : function (obj, default_text, callback) {\n            var rtl, w, a, s, t, h1, h2, fn, tmp, cancel = false;\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            if(!this.check(\"edit\", obj, this.get_parent(obj))) {\n                this.settings.core.error.call(this, this._data.core.last_error);\n                return false;\n            }\n            tmp = obj;\n            default_text = typeof default_text === 'string' ? default_text : obj.text;\n            this.set_text(obj, \"\");\n            obj = this._open_to(obj);\n            tmp.text = default_text;\n\n            rtl = this._data.core.rtl;\n            w  = this.element.width();\n            this._data.core.focused = tmp.id;\n            a  = obj.children('.jstree-anchor').trigger('focus');\n            s  = $('<span></span>');\n            /*!\n\t\t\toi = obj.children(\"i:visible\"),\n\t\t\tai = a.children(\"i:visible\"),\n\t\t\tw1 = oi.width() * oi.length,\n\t\t\tw2 = ai.width() * ai.length,\n\t\t\t*/\n            t  = default_text;\n            h1 = $(\"<\"+\"div></div>\", { css : { \"position\" : \"absolute\", \"top\" : \"-200px\", \"left\" : (rtl ? \"0px\" : \"-1000px\"), \"visibility\" : \"hidden\" } }).appendTo(document.body);\n            h2 = $(\"<\"+\"input />\", {\n                \"value\" : t,\n                \"class\" : \"jstree-rename-input\",\n                // \"size\" : t.length,\n                \"css\" : {\n                    \"padding\" : \"0\",\n                    \"border\" : \"1px solid silver\",\n                    \"box-sizing\" : \"border-box\",\n                    \"display\" : \"inline-block\",\n                    \"height\" : (this._data.core.li_height) + \"px\",\n                    \"lineHeight\" : (this._data.core.li_height) + \"px\",\n                    \"width\" : \"150px\" // will be set a bit further down\n                },\n                \"blur\" : function (e) {\n                    e.stopImmediatePropagation();\n                    e.preventDefault();\n                    var i = s.children(\".jstree-rename-input\"),\n                        v = i.val(),\n                        f = this.settings.core.force_text,\n                        nv;\n                    if(v === \"\") { v = t; }\n                    h1.remove();\n                    s.replaceWith(a);\n                    s.remove();\n                    t = f ? t : $('<div></div>').append($.parseHTML(t)).html();\n                    obj = this.get_node(obj);\n                    this.set_text(obj, t);\n                    nv = !!this.rename_node(obj, f ? $('<div></div>').text(v).text() : $('<div></div>').append($.parseHTML(v)).html());\n                    if(!nv) {\n                        this.set_text(obj, t); // move this up? and fix #483\n                    }\n                    this._data.core.focused = tmp.id;\n                    setTimeout(function () {\n                        var node = this.get_node(tmp.id, true);\n                        if(node.length) {\n                            this._data.core.focused = tmp.id;\n                            node.children('.jstree-anchor').trigger('focus');\n                        }\n                    }.bind(this), 0);\n                    if(callback) {\n                        callback.call(this, tmp, nv, cancel, v);\n                    }\n                    h2 = null;\n                }.bind(this),\n                \"keydown\" : function (e) {\n                    var key = e.which;\n                    if(key === 27) {\n                        cancel = true;\n                        this.value = t;\n                    }\n                    if(key === 27 || key === 13 || key === 37 || key === 38 || key === 39 || key === 40 || key === 32) {\n                        e.stopImmediatePropagation();\n                    }\n                    if(key === 27 || key === 13) {\n                        e.preventDefault();\n                        this.blur();\n                    }\n                },\n                \"click\" : function (e) { e.stopImmediatePropagation(); },\n                \"mousedown\" : function (e) { e.stopImmediatePropagation(); },\n                \"keyup\" : function (e) {\n                    h2.width(Math.min(h1.text(\"pW\" + this.value).width(),w));\n                },\n                \"keypress\" : function(e) {\n                    if(e.which === 13) { return false; }\n                }\n            });\n            fn = {\n                fontFamily\t\t: a.css('fontFamily')\t\t|| '',\n                fontSize\t\t: a.css('fontSize')\t\t\t|| '',\n                fontWeight\t\t: a.css('fontWeight')\t\t|| '',\n                fontStyle\t\t: a.css('fontStyle')\t\t|| '',\n                fontStretch\t\t: a.css('fontStretch')\t\t|| '',\n                fontVariant\t\t: a.css('fontVariant')\t\t|| '',\n                letterSpacing\t: a.css('letterSpacing')\t|| '',\n                wordSpacing\t\t: a.css('wordSpacing')\t\t|| ''\n            };\n            s.attr('class', a.attr('class')).append(a.contents().clone()).append(h2);\n            a.replaceWith(s);\n            h1.css(fn);\n            h2.css(fn).width(Math.min(h1.text(\"pW\" + h2[0].value).width(),w))[0].select();\n            $(document).one('mousedown.jstree touchstart.jstree dnd_start.vakata', function (e) {\n                if (h2 && e.target !== h2) {\n                    $(h2).trigger('blur');\n                }\n            });\n        },\n\n\n        /**\n         * changes the theme\n         * @name set_theme(theme_name [, theme_url])\n         * @param {String} theme_name the name of the new theme to apply\n         * @param {mixed} theme_url  the location of the CSS file for this theme. Omit or set to `false` if you manually included the file. Set to `true` to autoload from the `core.themes.dir` directory.\n         * @trigger set_theme.jstree\n         */\n        set_theme : function (theme_name, theme_url) {\n            if(!theme_name) { return false; }\n            if(theme_url === true) {\n                var dir = this.settings.core.themes.dir;\n                if(!dir) { dir = $.jstree.path + '/themes'; }\n                theme_url = dir + '/' + theme_name + '/style.css';\n            }\n            if(theme_url && $.inArray(theme_url, themes_loaded) === -1) {\n                $('head').append('<'+'link rel=\"stylesheet\" href=\"' + theme_url + '\" type=\"text/css\" />');\n                themes_loaded.push(theme_url);\n            }\n            if(this._data.core.themes.name) {\n                this.element.removeClass('jstree-' + this._data.core.themes.name);\n            }\n            this._data.core.themes.name = theme_name;\n            this.element.addClass('jstree-' + theme_name);\n            this.element[this.settings.core.themes.responsive ? 'addClass' : 'removeClass' ]('jstree-' + theme_name + '-responsive');\n            /**\n             * triggered when a theme is set\n             * @event\n             * @name set_theme.jstree\n             * @param {String} theme the new theme\n             */\n            this.trigger('set_theme', { 'theme' : theme_name });\n        },\n        /**\n         * gets the name of the currently applied theme name\n         * @name get_theme()\n         * @return {String}\n         */\n        get_theme : function () { return this._data.core.themes.name; },\n        /**\n         * changes the theme variant (if the theme has variants)\n         * @name set_theme_variant(variant_name)\n         * @param {String|Boolean} variant_name the variant to apply (if `false` is used the current variant is removed)\n         */\n        set_theme_variant : function (variant_name) {\n            if(this._data.core.themes.variant) {\n                this.element.removeClass('jstree-' + this._data.core.themes.name + '-' + this._data.core.themes.variant);\n            }\n            this._data.core.themes.variant = variant_name;\n            if(variant_name) {\n                this.element.addClass('jstree-' + this._data.core.themes.name + '-' + this._data.core.themes.variant);\n            }\n        },\n        /**\n         * gets the name of the currently applied theme variant\n         * @name get_theme()\n         * @return {String}\n         */\n        get_theme_variant : function () { return this._data.core.themes.variant; },\n        /**\n         * shows a striped background on the container (if the theme supports it)\n         * @name show_stripes()\n         */\n        show_stripes : function () {\n            this._data.core.themes.stripes = true;\n            this.get_container_ul().addClass(\"jstree-striped\");\n            /**\n             * triggered when stripes are shown\n             * @event\n             * @name show_stripes.jstree\n             */\n            this.trigger('show_stripes');\n        },\n        /**\n         * hides the striped background on the container\n         * @name hide_stripes()\n         */\n        hide_stripes : function () {\n            this._data.core.themes.stripes = false;\n            this.get_container_ul().removeClass(\"jstree-striped\");\n            /**\n             * triggered when stripes are hidden\n             * @event\n             * @name hide_stripes.jstree\n             */\n            this.trigger('hide_stripes');\n        },\n        /**\n         * toggles the striped background on the container\n         * @name toggle_stripes()\n         */\n        toggle_stripes : function () { if(this._data.core.themes.stripes) { this.hide_stripes(); } else { this.show_stripes(); } },\n        /**\n         * shows the connecting dots (if the theme supports it)\n         * @name show_dots()\n         */\n        show_dots : function () {\n            this._data.core.themes.dots = true;\n            this.get_container_ul().removeClass(\"jstree-no-dots\");\n            /**\n             * triggered when dots are shown\n             * @event\n             * @name show_dots.jstree\n             */\n            this.trigger('show_dots');\n        },\n        /**\n         * hides the connecting dots\n         * @name hide_dots()\n         */\n        hide_dots : function () {\n            this._data.core.themes.dots = false;\n            this.get_container_ul().addClass(\"jstree-no-dots\");\n            /**\n             * triggered when dots are hidden\n             * @event\n             * @name hide_dots.jstree\n             */\n            this.trigger('hide_dots');\n        },\n        /**\n         * toggles the connecting dots\n         * @name toggle_dots()\n         */\n        toggle_dots : function () { if(this._data.core.themes.dots) { this.hide_dots(); } else { this.show_dots(); } },\n        /**\n         * show the node icons\n         * @name show_icons()\n         */\n        show_icons : function () {\n            this._data.core.themes.icons = true;\n            this.get_container_ul().removeClass(\"jstree-no-icons\");\n            /**\n             * triggered when icons are shown\n             * @event\n             * @name show_icons.jstree\n             */\n            this.trigger('show_icons');\n        },\n        /**\n         * hide the node icons\n         * @name hide_icons()\n         */\n        hide_icons : function () {\n            this._data.core.themes.icons = false;\n            this.get_container_ul().addClass(\"jstree-no-icons\");\n            /**\n             * triggered when icons are hidden\n             * @event\n             * @name hide_icons.jstree\n             */\n            this.trigger('hide_icons');\n        },\n        /**\n         * toggle the node icons\n         * @name toggle_icons()\n         */\n        toggle_icons : function () { if(this._data.core.themes.icons) { this.hide_icons(); } else { this.show_icons(); } },\n        /**\n         * show the node ellipsis\n         * @name show_icons()\n         */\n        show_ellipsis : function () {\n            this._data.core.themes.ellipsis = true;\n            this.get_container_ul().addClass(\"jstree-ellipsis\");\n            /**\n             * triggered when ellisis is shown\n             * @event\n             * @name show_ellipsis.jstree\n             */\n            this.trigger('show_ellipsis');\n        },\n        /**\n         * hide the node ellipsis\n         * @name hide_ellipsis()\n         */\n        hide_ellipsis : function () {\n            this._data.core.themes.ellipsis = false;\n            this.get_container_ul().removeClass(\"jstree-ellipsis\");\n            /**\n             * triggered when ellisis is hidden\n             * @event\n             * @name hide_ellipsis.jstree\n             */\n            this.trigger('hide_ellipsis');\n        },\n        /**\n         * toggle the node ellipsis\n         * @name toggle_icons()\n         */\n        toggle_ellipsis : function () { if(this._data.core.themes.ellipsis) { this.hide_ellipsis(); } else { this.show_ellipsis(); } },\n        /**\n         * set the node icon for a node\n         * @name set_icon(obj, icon)\n         * @param {mixed} obj\n         * @param {String} icon the new icon - can be a path to an icon or a className, if using an image that is in the current directory use a `./` prefix, otherwise it will be detected as a class\n         */\n        set_icon : function (obj, icon) {\n            var t1, t2, dom, old;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.set_icon(obj[t1], icon);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            old = obj.icon;\n            obj.icon = icon === true || icon === null || icon === undefined || icon === '' ? true : icon;\n            dom = this.get_node(obj, true).children(\".jstree-anchor\").children(\".jstree-themeicon\");\n            if(icon === false) {\n                dom.removeClass('jstree-themeicon-custom ' + old).css(\"background\",\"\").removeAttr(\"rel\");\n                this.hide_icon(obj);\n            }\n            else if(icon === true || icon === null || icon === undefined || icon === '') {\n                dom.removeClass('jstree-themeicon-custom ' + old).css(\"background\",\"\").removeAttr(\"rel\");\n                if(old === false) { this.show_icon(obj); }\n            }\n            else if(icon.indexOf(\"/\") === -1 && icon.indexOf(\".\") === -1) {\n                dom.removeClass(old).css(\"background\",\"\");\n                dom.addClass(icon + ' jstree-themeicon-custom').attr(\"rel\",icon);\n                if(old === false) { this.show_icon(obj); }\n            }\n            else {\n                dom.removeClass(old).css(\"background\",\"\");\n                dom.addClass('jstree-themeicon-custom').css(\"background\", \"url('\" + icon + \"') center center no-repeat\").attr(\"rel\",icon);\n                if(old === false) { this.show_icon(obj); }\n            }\n            return true;\n        },\n        /**\n         * get the node icon for a node\n         * @name get_icon(obj)\n         * @param {mixed} obj\n         * @return {String}\n         */\n        get_icon : function (obj) {\n            obj = this.get_node(obj);\n            return (!obj || obj.id === $.jstree.root) ? false : obj.icon;\n        },\n        /**\n         * hide the icon on an individual node\n         * @name hide_icon(obj)\n         * @param {mixed} obj\n         */\n        hide_icon : function (obj) {\n            var t1, t2;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.hide_icon(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj === $.jstree.root) { return false; }\n            obj.icon = false;\n            this.get_node(obj, true).children(\".jstree-anchor\").children(\".jstree-themeicon\").addClass('jstree-themeicon-hidden');\n            return true;\n        },\n        /**\n         * show the icon on an individual node\n         * @name show_icon(obj)\n         * @param {mixed} obj\n         */\n        show_icon : function (obj) {\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.show_icon(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj === $.jstree.root) { return false; }\n            dom = this.get_node(obj, true);\n            obj.icon = dom.length ? dom.children(\".jstree-anchor\").children(\".jstree-themeicon\").attr('rel') : true;\n            if(!obj.icon) { obj.icon = true; }\n            dom.children(\".jstree-anchor\").children(\".jstree-themeicon\").removeClass('jstree-themeicon-hidden');\n            return true;\n        }\n    };\n\n    // helpers\n    $.vakata = {};\n    // collect attributes\n    $.vakata.attributes = function(node, with_values) {\n        node = $(node)[0];\n        var attr = with_values ? {} : [];\n        if(node && node.attributes) {\n            $.each(node.attributes, function (i, v) {\n                if($.inArray(v.name.toLowerCase(),['style','contenteditable','hasfocus','tabindex']) !== -1) { return; }\n                if(v.value !== null && $.vakata.trim(v.value) !== '') {\n                    if(with_values) { attr[v.name] = v.value; }\n                    else { attr.push(v.name); }\n                }\n            });\n        }\n        return attr;\n    };\n    $.vakata.array_unique = function(array) {\n        var a = [], i, j, l, o = {};\n        for(i = 0, l = array.length; i < l; i++) {\n            if(o[array[i]] === undefined) {\n                a.push(array[i]);\n                o[array[i]] = true;\n            }\n        }\n        return a;\n    };\n    // remove item from array\n    $.vakata.array_remove = function(array, from) {\n        array.splice(from, 1);\n        return array;\n        //var rest = array.slice((to || from) + 1 || array.length);\n        //array.length = from < 0 ? array.length + from : from;\n        //array.push.apply(array, rest);\n        //return array;\n    };\n    // remove item from array\n    $.vakata.array_remove_item = function(array, item) {\n        var tmp = $.inArray(item, array);\n        return tmp !== -1 ? $.vakata.array_remove(array, tmp) : array;\n    };\n    $.vakata.array_filter = function(c,a,b,d,e) {\n        if (c.filter) {\n            return c.filter(a, b);\n        }\n        d=[];\n        for (e in c) {\n            if (~~e+''===e+'' && e>=0 && a.call(b,c[e],+e,c)) {\n                d.push(c[e]);\n            }\n        }\n        return d;\n    };\n    $.vakata.trim = function (text) {\n        return String.prototype.trim ?\n            String.prototype.trim.call(text.toString()) :\n            text.toString().replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n    };\n    $.vakata.is_function = function(obj) {\n        return typeof obj === \"function\" && typeof obj.nodeType !== \"number\";\n    };\n    $.vakata.is_array = Array.isArray || function (obj) {\n        return Object.prototype.toString.call(obj) === \"[object Array]\";\n    };\n\n    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_objects/Function/bind#polyfill\n    if (!Function.prototype.bind) {\n        Function.prototype.bind = function () {\n            var thatFunc = this, thatArg = arguments[0];\n            var args = Array.prototype.slice.call(arguments, 1);\n            if (typeof thatFunc !== 'function') {\n                // closest thing possible to the ECMAScript 5\n                // internal IsCallable function\n                throw new TypeError('Function.prototype.bind - what is trying to be bound is not callable');\n            }\n            return function(){\n                var funcArgs = args.concat(Array.prototype.slice.call(arguments));\n                return thatFunc.apply(thatArg, funcArgs);\n            };\n        };\n    }\n\n\n    /**\n     * ### Changed plugin\n     *\n     * This plugin adds more information to the `changed.jstree` event. The new data is contained in the `changed` event data property, and contains a lists of `selected` and `deselected` nodes.\n     */\n\n    $.jstree.plugins.changed = function (options, parent) {\n        var last = [];\n        this.trigger = function (ev, data) {\n            var i, j;\n            if(!data) {\n                data = {};\n            }\n            if(ev.replace('.jstree','') === 'changed') {\n                data.changed = { selected : [], deselected : [] };\n                var tmp = {};\n                for(i = 0, j = last.length; i < j; i++) {\n                    tmp[last[i]] = 1;\n                }\n                for(i = 0, j = data.selected.length; i < j; i++) {\n                    if(!tmp[data.selected[i]]) {\n                        data.changed.selected.push(data.selected[i]);\n                    }\n                    else {\n                        tmp[data.selected[i]] = 2;\n                    }\n                }\n                for(i = 0, j = last.length; i < j; i++) {\n                    if(tmp[last[i]] === 1) {\n                        data.changed.deselected.push(last[i]);\n                    }\n                }\n                last = data.selected.slice();\n            }\n            /**\n             * triggered when selection changes (the \"changed\" plugin enhances the original event with more data)\n             * @event\n             * @name changed.jstree\n             * @param {Object} node\n             * @param {Object} action the action that caused the selection to change\n             * @param {Array} selected the current selection\n             * @param {Object} changed an object containing two properties `selected` and `deselected` - both arrays of node IDs, which were selected or deselected since the last changed event\n             * @param {Object} event the event (if any) that triggered this changed event\n             * @plugin changed\n             */\n            parent.trigger.call(this, ev, data);\n        };\n        this.refresh = function (skip_loading, forget_state) {\n            last = [];\n            return parent.refresh.apply(this, arguments);\n        };\n    };\n\n    /**\n     * ### Checkbox plugin\n     *\n     * This plugin renders checkbox icons in front of each node, making multiple selection much easier.\n     * It also supports tri-state behavior, meaning that if a node has a few of its children checked it will be rendered as undetermined, and state will be propagated up.\n     */\n\n    var _i = document.createElement('I');\n    _i.className = 'jstree-icon jstree-checkbox';\n    _i.setAttribute('role', 'presentation');\n    /**\n     * stores all defaults for the checkbox plugin\n     * @name $.jstree.defaults.checkbox\n     * @plugin checkbox\n     */\n    $.jstree.defaults.checkbox = {\n        /**\n         * a boolean indicating if checkboxes should be visible (can be changed at a later time using `show_checkboxes()` and `hide_checkboxes`). Defaults to `true`.\n         * @name $.jstree.defaults.checkbox.visible\n         * @plugin checkbox\n         */\n        visible\t\t\t\t: true,\n        /**\n         * a boolean indicating if checkboxes should cascade down and have an undetermined state. Defaults to `true`.\n         * @name $.jstree.defaults.checkbox.three_state\n         * @plugin checkbox\n         */\n        three_state\t\t\t: true,\n        /**\n         * a boolean indicating if clicking anywhere on the node should act as clicking on the checkbox. Defaults to `true`.\n         * @name $.jstree.defaults.checkbox.whole_node\n         * @plugin checkbox\n         */\n        whole_node\t\t\t: true,\n        /**\n         * a boolean indicating if the selected style of a node should be kept, or removed. Defaults to `true`.\n         * @name $.jstree.defaults.checkbox.keep_selected_style\n         * @plugin checkbox\n         */\n        keep_selected_style\t: true,\n        /**\n         * This setting controls how cascading and undetermined nodes are applied.\n         * If 'up' is in the string - cascading up is enabled, if 'down' is in the string - cascading down is enabled, if 'undetermined' is in the string - undetermined nodes will be used.\n         * If `three_state` is set to `true` this setting is automatically set to 'up+down+undetermined'. Defaults to ''.\n         * @name $.jstree.defaults.checkbox.cascade\n         * @plugin checkbox\n         */\n        cascade\t\t\t\t: '',\n        /**\n         * This setting controls if checkbox are bound to the general tree selection or to an internal array maintained by the checkbox plugin. Defaults to `true`, only set to `false` if you know exactly what you are doing.\n         * @name $.jstree.defaults.checkbox.tie_selection\n         * @plugin checkbox\n         */\n        tie_selection\t\t: true,\n\n        /**\n         * This setting controls if cascading down affects disabled checkboxes\n         * @name $.jstree.defaults.checkbox.cascade_to_disabled\n         * @plugin checkbox\n         */\n        cascade_to_disabled : true,\n\n        /**\n         * This setting controls if cascading down affects hidden checkboxes\n         * @name $.jstree.defaults.checkbox.cascade_to_hidden\n         * @plugin checkbox\n         */\n        cascade_to_hidden : true\n    };\n    $.jstree.plugins.checkbox = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n            this._data.checkbox.uto = false;\n            this._data.checkbox.selected = [];\n            if(this.settings.checkbox.three_state) {\n                this.settings.checkbox.cascade = 'up+down+undetermined';\n            }\n            this.element\n                .on(\"init.jstree\", function () {\n                    this._data.checkbox.visible = this.settings.checkbox.visible;\n                    if(!this.settings.checkbox.keep_selected_style) {\n                        this.element.addClass('jstree-checkbox-no-clicked');\n                    }\n                    if(this.settings.checkbox.tie_selection) {\n                        this.element.addClass('jstree-checkbox-selection');\n                    }\n                }.bind(this))\n                .on(\"loading.jstree\", function () {\n                    this[ this._data.checkbox.visible ? 'show_checkboxes' : 'hide_checkboxes' ]();\n                }.bind(this));\n            if(this.settings.checkbox.cascade.indexOf('undetermined') !== -1) {\n                this.element\n                    .on('changed.jstree uncheck_node.jstree check_node.jstree uncheck_all.jstree check_all.jstree move_node.jstree copy_node.jstree redraw.jstree open_node.jstree', function () {\n                        // only if undetermined is in setting\n                        if(this._data.checkbox.uto) { clearTimeout(this._data.checkbox.uto); }\n                        this._data.checkbox.uto = setTimeout(this._undetermined.bind(this), 50);\n                    }.bind(this));\n            }\n            if(!this.settings.checkbox.tie_selection) {\n                this.element\n                    .on('model.jstree', function (e, data) {\n                        var m = this._model.data,\n                            p = m[data.parent],\n                            dpc = data.nodes,\n                            i, j;\n                        for(i = 0, j = dpc.length; i < j; i++) {\n                            m[dpc[i]].state.checked = m[dpc[i]].state.checked || (m[dpc[i]].original && m[dpc[i]].original.state && m[dpc[i]].original.state.checked);\n                            if(m[dpc[i]].state.checked) {\n                                this._data.checkbox.selected.push(dpc[i]);\n                            }\n                        }\n                    }.bind(this));\n            }\n            if(this.settings.checkbox.cascade.indexOf('up') !== -1 || this.settings.checkbox.cascade.indexOf('down') !== -1) {\n                this.element\n                    .on('model.jstree', function (e, data) {\n                        var m = this._model.data,\n                            p = m[data.parent],\n                            dpc = data.nodes,\n                            chd = [],\n                            c, i, j, k, l, tmp, s = this.settings.checkbox.cascade, t = this.settings.checkbox.tie_selection;\n\n                        if(s.indexOf('down') !== -1) {\n                            // apply down\n                            if(p.state[ t ? 'selected' : 'checked' ]) {\n                                for(i = 0, j = dpc.length; i < j; i++) {\n                                    m[dpc[i]].state[ t ? 'selected' : 'checked' ] = true;\n                                }\n\n                                this._data[ t ? 'core' : 'checkbox' ].selected = this._data[ t ? 'core' : 'checkbox' ].selected.concat(dpc);\n                            }\n                            else {\n                                for(i = 0, j = dpc.length; i < j; i++) {\n                                    if(m[dpc[i]].state[ t ? 'selected' : 'checked' ]) {\n                                        for(k = 0, l = m[dpc[i]].children_d.length; k < l; k++) {\n                                            m[m[dpc[i]].children_d[k]].state[ t ? 'selected' : 'checked' ] = true;\n                                        }\n                                        this._data[ t ? 'core' : 'checkbox' ].selected = this._data[ t ? 'core' : 'checkbox' ].selected.concat(m[dpc[i]].children_d);\n                                    }\n                                }\n                            }\n                        }\n\n                        if(s.indexOf('up') !== -1) {\n                            // apply up\n                            for(i = 0, j = p.children_d.length; i < j; i++) {\n                                if(!m[p.children_d[i]].children.length) {\n                                    chd.push(m[p.children_d[i]].parent);\n                                }\n                            }\n                            chd = $.vakata.array_unique(chd);\n                            for(k = 0, l = chd.length; k < l; k++) {\n                                p = m[chd[k]];\n                                while(p && p.id !== $.jstree.root) {\n                                    c = 0;\n                                    for(i = 0, j = p.children.length; i < j; i++) {\n                                        c += m[p.children[i]].state[ t ? 'selected' : 'checked' ];\n                                    }\n                                    if(c === j) {\n                                        p.state[ t ? 'selected' : 'checked' ] = true;\n                                        this._data[ t ? 'core' : 'checkbox' ].selected.push(p.id);\n                                        tmp = this.get_node(p, true);\n                                        if(tmp && tmp.length) {\n                                            tmp.attr('aria-selected', true).children('.jstree-anchor').addClass( t ? 'jstree-clicked' : 'jstree-checked');\n                                        }\n                                    }\n                                    else {\n                                        break;\n                                    }\n                                    p = this.get_node(p.parent);\n                                }\n                            }\n                        }\n\n                        this._data[ t ? 'core' : 'checkbox' ].selected = $.vakata.array_unique(this._data[ t ? 'core' : 'checkbox' ].selected);\n                    }.bind(this))\n                    .on(this.settings.checkbox.tie_selection ? 'select_node.jstree' : 'check_node.jstree', function (e, data) {\n                        var self = this,\n                            obj = data.node,\n                            m = this._model.data,\n                            par = this.get_node(obj.parent),\n                            i, j, c, tmp, s = this.settings.checkbox.cascade, t = this.settings.checkbox.tie_selection,\n                            sel = {}, cur = this._data[ t ? 'core' : 'checkbox' ].selected;\n\n                        for (i = 0, j = cur.length; i < j; i++) {\n                            sel[cur[i]] = true;\n                        }\n\n                        // apply down\n                        if(s.indexOf('down') !== -1) {\n                            //this._data[ t ? 'core' : 'checkbox' ].selected = $.vakata.array_unique(this._data[ t ? 'core' : 'checkbox' ].selected.concat(obj.children_d));\n                            var selectedIds = this._cascade_new_checked_state(obj.id, true);\n                            var temp = obj.children_d.concat(obj.id);\n                            for (i = 0, j = temp.length; i < j; i++) {\n                                if (selectedIds.indexOf(temp[i]) > -1) {\n                                    sel[temp[i]] = true;\n                                }\n                                else {\n                                    delete sel[temp[i]];\n                                }\n                            }\n                        }\n\n                        // apply up\n                        if(s.indexOf('up') !== -1) {\n                            while(par && par.id !== $.jstree.root) {\n                                c = 0;\n                                for(i = 0, j = par.children.length; i < j; i++) {\n                                    c += m[par.children[i]].state[ t ? 'selected' : 'checked' ];\n                                }\n                                if(c === j) {\n                                    par.state[ t ? 'selected' : 'checked' ] = true;\n                                    sel[par.id] = true;\n                                    //this._data[ t ? 'core' : 'checkbox' ].selected.push(par.id);\n                                    tmp = this.get_node(par, true);\n                                    if(tmp && tmp.length) {\n                                        tmp.attr('aria-selected', true).children('.jstree-anchor').addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                    }\n                                }\n                                else {\n                                    break;\n                                }\n                                par = this.get_node(par.parent);\n                            }\n                        }\n\n                        cur = [];\n                        for (i in sel) {\n                            if (sel.hasOwnProperty(i)) {\n                                cur.push(i);\n                            }\n                        }\n                        this._data[ t ? 'core' : 'checkbox' ].selected = cur;\n                    }.bind(this))\n                    .on(this.settings.checkbox.tie_selection ? 'deselect_all.jstree' : 'uncheck_all.jstree', function (e, data) {\n                        var obj = this.get_node($.jstree.root),\n                            m = this._model.data,\n                            i, j, tmp;\n                        for(i = 0, j = obj.children_d.length; i < j; i++) {\n                            tmp = m[obj.children_d[i]];\n                            if(tmp && tmp.original && tmp.original.state && tmp.original.state.undetermined) {\n                                tmp.original.state.undetermined = false;\n                            }\n                        }\n                    }.bind(this))\n                    .on(this.settings.checkbox.tie_selection ? 'deselect_node.jstree' : 'uncheck_node.jstree', function (e, data) {\n                        var self = this,\n                            obj = data.node,\n                            dom = this.get_node(obj, true),\n                            i, j, tmp, s = this.settings.checkbox.cascade, t = this.settings.checkbox.tie_selection,\n                            cur = this._data[ t ? 'core' : 'checkbox' ].selected, sel = {},\n                            stillSelectedIds = [],\n                            allIds = obj.children_d.concat(obj.id);\n\n                        // apply down\n                        if(s.indexOf('down') !== -1) {\n                            var selectedIds = this._cascade_new_checked_state(obj.id, false);\n\n                            cur = $.vakata.array_filter(cur, function(id) {\n                                return allIds.indexOf(id) === -1 || selectedIds.indexOf(id) > -1;\n                            });\n                        }\n\n                        // only apply up if cascade up is enabled and if this node is not selected\n                        // (if all child nodes are disabled and cascade_to_disabled === false then this node will till be selected).\n                        if(s.indexOf('up') !== -1 && cur.indexOf(obj.id) === -1) {\n                            for(i = 0, j = obj.parents.length; i < j; i++) {\n                                tmp = this._model.data[obj.parents[i]];\n                                tmp.state[ t ? 'selected' : 'checked' ] = false;\n                                if(tmp && tmp.original && tmp.original.state && tmp.original.state.undetermined) {\n                                    tmp.original.state.undetermined = false;\n                                }\n                                tmp = this.get_node(obj.parents[i], true);\n                                if(tmp && tmp.length) {\n                                    tmp.attr('aria-selected', false).children('.jstree-anchor').removeClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                }\n                            }\n\n                            cur = $.vakata.array_filter(cur, function(id) {\n                                return obj.parents.indexOf(id) === -1;\n                            });\n                        }\n\n                        this._data[ t ? 'core' : 'checkbox' ].selected = cur;\n                    }.bind(this));\n            }\n            if(this.settings.checkbox.cascade.indexOf('up') !== -1) {\n                this.element\n                    .on('delete_node.jstree', function (e, data) {\n                        // apply up (whole handler)\n                        var p = this.get_node(data.parent),\n                            m = this._model.data,\n                            i, j, c, tmp, t = this.settings.checkbox.tie_selection;\n                        while(p && p.id !== $.jstree.root && !p.state[ t ? 'selected' : 'checked' ]) {\n                            c = 0;\n                            for(i = 0, j = p.children.length; i < j; i++) {\n                                c += m[p.children[i]].state[ t ? 'selected' : 'checked' ];\n                            }\n                            if(j > 0 && c === j) {\n                                p.state[ t ? 'selected' : 'checked' ] = true;\n                                this._data[ t ? 'core' : 'checkbox' ].selected.push(p.id);\n                                tmp = this.get_node(p, true);\n                                if(tmp && tmp.length) {\n                                    tmp.attr('aria-selected', true).children('.jstree-anchor').addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                }\n                            }\n                            else {\n                                break;\n                            }\n                            p = this.get_node(p.parent);\n                        }\n                    }.bind(this))\n                    .on('move_node.jstree', function (e, data) {\n                        // apply up (whole handler)\n                        var is_multi = data.is_multi,\n                            old_par = data.old_parent,\n                            new_par = this.get_node(data.parent),\n                            m = this._model.data,\n                            p, c, i, j, tmp, t = this.settings.checkbox.tie_selection;\n                        if(!is_multi) {\n                            p = this.get_node(old_par);\n                            while(p && p.id !== $.jstree.root && !p.state[ t ? 'selected' : 'checked' ]) {\n                                c = 0;\n                                for(i = 0, j = p.children.length; i < j; i++) {\n                                    c += m[p.children[i]].state[ t ? 'selected' : 'checked' ];\n                                }\n                                if(j > 0 && c === j) {\n                                    p.state[ t ? 'selected' : 'checked' ] = true;\n                                    this._data[ t ? 'core' : 'checkbox' ].selected.push(p.id);\n                                    tmp = this.get_node(p, true);\n                                    if(tmp && tmp.length) {\n                                        tmp.attr('aria-selected', true).children('.jstree-anchor').addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                    }\n                                }\n                                else {\n                                    break;\n                                }\n                                p = this.get_node(p.parent);\n                            }\n                        }\n                        p = new_par;\n                        while(p && p.id !== $.jstree.root) {\n                            c = 0;\n                            for(i = 0, j = p.children.length; i < j; i++) {\n                                c += m[p.children[i]].state[ t ? 'selected' : 'checked' ];\n                            }\n                            if(c === j) {\n                                if(!p.state[ t ? 'selected' : 'checked' ]) {\n                                    p.state[ t ? 'selected' : 'checked' ] = true;\n                                    this._data[ t ? 'core' : 'checkbox' ].selected.push(p.id);\n                                    tmp = this.get_node(p, true);\n                                    if(tmp && tmp.length) {\n                                        tmp.attr('aria-selected', true).children('.jstree-anchor').addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                    }\n                                }\n                            }\n                            else {\n                                if(p.state[ t ? 'selected' : 'checked' ]) {\n                                    p.state[ t ? 'selected' : 'checked' ] = false;\n                                    this._data[ t ? 'core' : 'checkbox' ].selected = $.vakata.array_remove_item(this._data[ t ? 'core' : 'checkbox' ].selected, p.id);\n                                    tmp = this.get_node(p, true);\n                                    if(tmp && tmp.length) {\n                                        tmp.attr('aria-selected', false).children('.jstree-anchor').removeClass(t ? 'jstree-clicked' : 'jstree-checked');\n                                    }\n                                }\n                                else {\n                                    break;\n                                }\n                            }\n                            p = this.get_node(p.parent);\n                        }\n                    }.bind(this));\n            }\n        };\n        /**\n         * get an array of all nodes whose state is \"undetermined\"\n         * @name get_undetermined([full])\n         * @param  {boolean} full: if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         * @plugin checkbox\n         */\n        this.get_undetermined = function (full) {\n            if (this.settings.checkbox.cascade.indexOf('undetermined') === -1) {\n                return [];\n            }\n            var i, j, k, l, o = {}, m = this._model.data, t = this.settings.checkbox.tie_selection, s = this._data[ t ? 'core' : 'checkbox' ].selected, p = [], tt = this, r = [];\n            for(i = 0, j = s.length; i < j; i++) {\n                if(m[s[i]] && m[s[i]].parents) {\n                    for(k = 0, l = m[s[i]].parents.length; k < l; k++) {\n                        if(o[m[s[i]].parents[k]] !== undefined) {\n                            break;\n                        }\n                        if(m[s[i]].parents[k] !== $.jstree.root) {\n                            o[m[s[i]].parents[k]] = true;\n                            p.push(m[s[i]].parents[k]);\n                        }\n                    }\n                }\n            }\n            // attempt for server side undetermined state\n            this.element.find('.jstree-closed').not(':has(.jstree-children)')\n                .each(function () {\n                    var tmp = tt.get_node(this), tmp2;\n\n                    if(!tmp) { return; }\n\n                    if(!tmp.state.loaded) {\n                        if(tmp.original && tmp.original.state && tmp.original.state.undetermined && tmp.original.state.undetermined === true) {\n                            if(o[tmp.id] === undefined && tmp.id !== $.jstree.root) {\n                                o[tmp.id] = true;\n                                p.push(tmp.id);\n                            }\n                            for(k = 0, l = tmp.parents.length; k < l; k++) {\n                                if(o[tmp.parents[k]] === undefined && tmp.parents[k] !== $.jstree.root) {\n                                    o[tmp.parents[k]] = true;\n                                    p.push(tmp.parents[k]);\n                                }\n                            }\n                        }\n                    }\n                    else {\n                        for(i = 0, j = tmp.children_d.length; i < j; i++) {\n                            tmp2 = m[tmp.children_d[i]];\n                            if(!tmp2.state.loaded && tmp2.original && tmp2.original.state && tmp2.original.state.undetermined && tmp2.original.state.undetermined === true) {\n                                if(o[tmp2.id] === undefined && tmp2.id !== $.jstree.root) {\n                                    o[tmp2.id] = true;\n                                    p.push(tmp2.id);\n                                }\n                                for(k = 0, l = tmp2.parents.length; k < l; k++) {\n                                    if(o[tmp2.parents[k]] === undefined && tmp2.parents[k] !== $.jstree.root) {\n                                        o[tmp2.parents[k]] = true;\n                                        p.push(tmp2.parents[k]);\n                                    }\n                                }\n                            }\n                        }\n                    }\n                });\n            for (i = 0, j = p.length; i < j; i++) {\n                if(!m[p[i]].state[ t ? 'selected' : 'checked' ]) {\n                    r.push(full ? m[p[i]] : p[i]);\n                }\n            }\n            return r;\n        };\n        /**\n         * set the undetermined state where and if necessary. Used internally.\n         * @private\n         * @name _undetermined()\n         * @plugin checkbox\n         */\n        this._undetermined = function () {\n            if(this.element === null) { return; }\n            var p = this.get_undetermined(false), i, j, s;\n\n            this.element.find('.jstree-undetermined').removeClass('jstree-undetermined');\n            for (i = 0, j = p.length; i < j; i++) {\n                s = this.get_node(p[i], true);\n                if(s && s.length) {\n                    s.children('.jstree-anchor').children('.jstree-checkbox').addClass('jstree-undetermined');\n                }\n            }\n        };\n        this.redraw_node = function(obj, deep, is_callback, force_render) {\n            obj = parent.redraw_node.apply(this, arguments);\n            if(obj) {\n                var i, j, tmp = null, icon = null;\n                for(i = 0, j = obj.childNodes.length; i < j; i++) {\n                    if(obj.childNodes[i] && obj.childNodes[i].className && obj.childNodes[i].className.indexOf(\"jstree-anchor\") !== -1) {\n                        tmp = obj.childNodes[i];\n                        break;\n                    }\n                }\n                if(tmp) {\n                    if(!this.settings.checkbox.tie_selection && this._model.data[obj.id].state.checked) { tmp.className += ' jstree-checked'; }\n                    icon = _i.cloneNode(false);\n                    if(this._model.data[obj.id].state.checkbox_disabled) { icon.className += ' jstree-checkbox-disabled'; }\n                    tmp.insertBefore(icon, tmp.childNodes[0]);\n                }\n            }\n            if(!is_callback && this.settings.checkbox.cascade.indexOf('undetermined') !== -1) {\n                if(this._data.checkbox.uto) { clearTimeout(this._data.checkbox.uto); }\n                this._data.checkbox.uto = setTimeout(this._undetermined.bind(this), 50);\n            }\n            return obj;\n        };\n        /**\n         * show the node checkbox icons\n         * @name show_checkboxes()\n         * @plugin checkbox\n         */\n        this.show_checkboxes = function () { this._data.core.themes.checkboxes = true; this.get_container_ul().removeClass(\"jstree-no-checkboxes\"); };\n        /**\n         * hide the node checkbox icons\n         * @name hide_checkboxes()\n         * @plugin checkbox\n         */\n        this.hide_checkboxes = function () { this._data.core.themes.checkboxes = false; this.get_container_ul().addClass(\"jstree-no-checkboxes\"); };\n        /**\n         * toggle the node icons\n         * @name toggle_checkboxes()\n         * @plugin checkbox\n         */\n        this.toggle_checkboxes = function () { if(this._data.core.themes.checkboxes) { this.hide_checkboxes(); } else { this.show_checkboxes(); } };\n        /**\n         * checks if a node is in an undetermined state\n         * @name is_undetermined(obj)\n         * @param  {mixed} obj\n         * @return {Boolean}\n         */\n        this.is_undetermined = function (obj) {\n            obj = this.get_node(obj);\n            var s = this.settings.checkbox.cascade, i, j, t = this.settings.checkbox.tie_selection, d = this._data[ t ? 'core' : 'checkbox' ].selected, m = this._model.data;\n            if(!obj || obj.state[ t ? 'selected' : 'checked' ] === true || s.indexOf('undetermined') === -1 || (s.indexOf('down') === -1 && s.indexOf('up') === -1)) {\n                return false;\n            }\n            if(!obj.state.loaded && obj.original.state.undetermined === true) {\n                return true;\n            }\n            for(i = 0, j = obj.children_d.length; i < j; i++) {\n                if($.inArray(obj.children_d[i], d) !== -1 || (!m[obj.children_d[i]].state.loaded && m[obj.children_d[i]].original.state.undetermined)) {\n                    return true;\n                }\n            }\n            return false;\n        };\n        /**\n         * disable a node's checkbox\n         * @name disable_checkbox(obj)\n         * @param {mixed} obj an array can be used too\n         * @trigger disable_checkbox.jstree\n         * @plugin checkbox\n         */\n        this.disable_checkbox = function (obj) {\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.disable_checkbox(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(!obj.state.checkbox_disabled) {\n                obj.state.checkbox_disabled = true;\n                if(dom && dom.length) {\n                    dom.children('.jstree-anchor').children('.jstree-checkbox').addClass('jstree-checkbox-disabled');\n                }\n                /**\n                 * triggered when an node's checkbox is disabled\n                 * @event\n                 * @name disable_checkbox.jstree\n                 * @param {Object} node\n                 * @plugin checkbox\n                 */\n                this.trigger('disable_checkbox', { 'node' : obj });\n            }\n        };\n        /**\n         * enable a node's checkbox\n         * @name enable_checkbox(obj)\n         * @param {mixed} obj an array can be used too\n         * @trigger enable_checkbox.jstree\n         * @plugin checkbox\n         */\n        this.enable_checkbox = function (obj) {\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.enable_checkbox(obj[t1]);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(obj.state.checkbox_disabled) {\n                obj.state.checkbox_disabled = false;\n                if(dom && dom.length) {\n                    dom.children('.jstree-anchor').children('.jstree-checkbox').removeClass('jstree-checkbox-disabled');\n                }\n                /**\n                 * triggered when an node's checkbox is enabled\n                 * @event\n                 * @name enable_checkbox.jstree\n                 * @param {Object} node\n                 * @plugin checkbox\n                 */\n                this.trigger('enable_checkbox', { 'node' : obj });\n            }\n        };\n\n        this.activate_node = function (obj, e) {\n            if($(e.target).hasClass('jstree-checkbox-disabled')) {\n                return false;\n            }\n            if(this.settings.checkbox.tie_selection && (this.settings.checkbox.whole_node || $(e.target).hasClass('jstree-checkbox'))) {\n                e.ctrlKey = true;\n            }\n            if(this.settings.checkbox.tie_selection || (!this.settings.checkbox.whole_node && !$(e.target).hasClass('jstree-checkbox'))) {\n                return parent.activate_node.call(this, obj, e);\n            }\n            if(this.is_disabled(obj)) {\n                return false;\n            }\n            if(this.is_checked(obj)) {\n                this.uncheck_node(obj, e);\n            }\n            else {\n                this.check_node(obj, e);\n            }\n            this.trigger('activate_node', { 'node' : this.get_node(obj) });\n        };\n\n        /**\n         * Cascades checked state to a node and all its descendants. This function does NOT affect hidden and disabled nodes (or their descendants).\n         * However if these unaffected nodes are already selected their ids will be included in the returned array.\n         * @private\n         * @name _cascade_new_checked_state(id, checkedState)\n         * @param {string} id the node ID\n         * @param {bool} checkedState should the nodes be checked or not\n         * @returns {Array} Array of all node id's (in this tree branch) that are checked.\n         */\n        this._cascade_new_checked_state = function (id, checkedState) {\n            var self = this;\n            var t = this.settings.checkbox.tie_selection;\n            var node = this._model.data[id];\n            var selectedNodeIds = [];\n            var selectedChildrenIds = [], i, j, selectedChildIds;\n\n            if (\n                (this.settings.checkbox.cascade_to_disabled || !node.state.disabled) &&\n                (this.settings.checkbox.cascade_to_hidden || !node.state.hidden)\n            ) {\n                //First try and check/uncheck the children\n                if (node.children) {\n                    for (i = 0, j = node.children.length; i < j; i++) {\n                        var childId = node.children[i];\n                        selectedChildIds = self._cascade_new_checked_state(childId, checkedState);\n                        selectedNodeIds = selectedNodeIds.concat(selectedChildIds);\n                        if (selectedChildIds.indexOf(childId) > -1) {\n                            selectedChildrenIds.push(childId);\n                        }\n                    }\n                }\n\n                var dom = self.get_node(node, true);\n\n                //A node's state is undetermined if some but not all of it's children are checked/selected .\n                var undetermined = selectedChildrenIds.length > 0 && selectedChildrenIds.length < node.children.length;\n\n                if(node.original && node.original.state && node.original.state.undetermined) {\n                    node.original.state.undetermined = undetermined;\n                }\n\n                //If a node is undetermined then remove selected class\n                if (undetermined) {\n                    node.state[ t ? 'selected' : 'checked' ] = false;\n                    dom.attr('aria-selected', false).children('.jstree-anchor').removeClass(t ? 'jstree-clicked' : 'jstree-checked');\n                }\n                    //Otherwise, if the checkedState === true (i.e. the node is being checked now) and all of the node's children are checked (if it has any children),\n                //check the node and style it correctly.\n                else if (checkedState && selectedChildrenIds.length === node.children.length) {\n                    node.state[ t ? 'selected' : 'checked' ] = checkedState;\n                    selectedNodeIds.push(node.id);\n\n                    dom.attr('aria-selected', true).children('.jstree-anchor').addClass(t ? 'jstree-clicked' : 'jstree-checked');\n                }\n                else {\n                    node.state[ t ? 'selected' : 'checked' ] = false;\n                    dom.attr('aria-selected', false).children('.jstree-anchor').removeClass(t ? 'jstree-clicked' : 'jstree-checked');\n                }\n            }\n            else {\n                selectedChildIds = this.get_checked_descendants(id);\n\n                if (node.state[ t ? 'selected' : 'checked' ]) {\n                    selectedChildIds.push(node.id);\n                }\n\n                selectedNodeIds = selectedNodeIds.concat(selectedChildIds);\n            }\n\n            return selectedNodeIds;\n        };\n\n        /**\n         * Gets ids of nodes selected in branch (of tree) specified by id (does not include the node specified by id)\n         * @name get_checked_descendants(obj)\n         * @param {string} id the node ID\n         * @return {Array} array of IDs\n         * @plugin checkbox\n         */\n        this.get_checked_descendants = function (id) {\n            var self = this;\n            var t = self.settings.checkbox.tie_selection;\n            var node = self._model.data[id];\n\n            return $.vakata.array_filter(node.children_d, function(_id) {\n                return self._model.data[_id].state[ t ? 'selected' : 'checked' ];\n            });\n        };\n\n        /**\n         * check a node (only if tie_selection in checkbox settings is false, otherwise select_node will be called internally)\n         * @name check_node(obj)\n         * @param {mixed} obj an array can be used to check multiple nodes\n         * @trigger check_node.jstree\n         * @plugin checkbox\n         */\n        this.check_node = function (obj, e) {\n            if(this.settings.checkbox.tie_selection) { return this.select_node(obj, false, true, e); }\n            var dom, t1, t2, th;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.check_node(obj[t1], e);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(!obj.state.checked) {\n                obj.state.checked = true;\n                this._data.checkbox.selected.push(obj.id);\n                if(dom && dom.length) {\n                    dom.children('.jstree-anchor').addClass('jstree-checked');\n                }\n                /**\n                 * triggered when an node is checked (only if tie_selection in checkbox settings is false)\n                 * @event\n                 * @name check_node.jstree\n                 * @param {Object} node\n                 * @param {Array} selected the current selection\n                 * @param {Object} event the event (if any) that triggered this check_node\n                 * @plugin checkbox\n                 */\n                this.trigger('check_node', { 'node' : obj, 'selected' : this._data.checkbox.selected, 'event' : e });\n            }\n        };\n        /**\n         * uncheck a node (only if tie_selection in checkbox settings is false, otherwise deselect_node will be called internally)\n         * @name uncheck_node(obj)\n         * @param {mixed} obj an array can be used to uncheck multiple nodes\n         * @trigger uncheck_node.jstree\n         * @plugin checkbox\n         */\n        this.uncheck_node = function (obj, e) {\n            if(this.settings.checkbox.tie_selection) { return this.deselect_node(obj, false, e); }\n            var t1, t2, dom;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.uncheck_node(obj[t1], e);\n                }\n                return true;\n            }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) {\n                return false;\n            }\n            dom = this.get_node(obj, true);\n            if(obj.state.checked) {\n                obj.state.checked = false;\n                this._data.checkbox.selected = $.vakata.array_remove_item(this._data.checkbox.selected, obj.id);\n                if(dom.length) {\n                    dom.children('.jstree-anchor').removeClass('jstree-checked');\n                }\n                /**\n                 * triggered when an node is unchecked (only if tie_selection in checkbox settings is false)\n                 * @event\n                 * @name uncheck_node.jstree\n                 * @param {Object} node\n                 * @param {Array} selected the current selection\n                 * @param {Object} event the event (if any) that triggered this uncheck_node\n                 * @plugin checkbox\n                 */\n                this.trigger('uncheck_node', { 'node' : obj, 'selected' : this._data.checkbox.selected, 'event' : e });\n            }\n        };\n\n        /**\n         * checks all nodes in the tree (only if tie_selection in checkbox settings is false, otherwise select_all will be called internally)\n         * @name check_all()\n         * @trigger check_all.jstree, changed.jstree\n         * @plugin checkbox\n         */\n        this.check_all = function () {\n            if(this.settings.checkbox.tie_selection) { return this.select_all(); }\n            var tmp = this._data.checkbox.selected.concat([]), i, j;\n            this._data.checkbox.selected = this._model.data[$.jstree.root].children_d.concat();\n            for(i = 0, j = this._data.checkbox.selected.length; i < j; i++) {\n                if(this._model.data[this._data.checkbox.selected[i]]) {\n                    this._model.data[this._data.checkbox.selected[i]].state.checked = true;\n                }\n            }\n            this.redraw(true);\n            /**\n             * triggered when all nodes are checked (only if tie_selection in checkbox settings is false)\n             * @event\n             * @name check_all.jstree\n             * @param {Array} selected the current selection\n             * @plugin checkbox\n             */\n            this.trigger('check_all', { 'selected' : this._data.checkbox.selected });\n        };\n        /**\n         * uncheck all checked nodes (only if tie_selection in checkbox settings is false, otherwise deselect_all will be called internally)\n         * @name uncheck_all()\n         * @trigger uncheck_all.jstree\n         * @plugin checkbox\n         */\n        this.uncheck_all = function () {\n            if(this.settings.checkbox.tie_selection) { return this.deselect_all(); }\n            var tmp = this._data.checkbox.selected.concat([]), i, j;\n            for(i = 0, j = this._data.checkbox.selected.length; i < j; i++) {\n                if(this._model.data[this._data.checkbox.selected[i]]) {\n                    this._model.data[this._data.checkbox.selected[i]].state.checked = false;\n                }\n            }\n            this._data.checkbox.selected = [];\n            this.element.find('.jstree-checked').removeClass('jstree-checked');\n            /**\n             * triggered when all nodes are unchecked (only if tie_selection in checkbox settings is false)\n             * @event\n             * @name uncheck_all.jstree\n             * @param {Object} node the previous selection\n             * @param {Array} selected the current selection\n             * @plugin checkbox\n             */\n            this.trigger('uncheck_all', { 'selected' : this._data.checkbox.selected, 'node' : tmp });\n        };\n        /**\n         * checks if a node is checked (if tie_selection is on in the settings this function will return the same as is_selected)\n         * @name is_checked(obj)\n         * @param  {mixed}  obj\n         * @return {Boolean}\n         * @plugin checkbox\n         */\n        this.is_checked = function (obj) {\n            if(this.settings.checkbox.tie_selection) { return this.is_selected(obj); }\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            return obj.state.checked;\n        };\n        /**\n         * get an array of all checked nodes (if tie_selection is on in the settings this function will return the same as get_selected)\n         * @name get_checked([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         * @plugin checkbox\n         */\n        this.get_checked = function (full) {\n            if(this.settings.checkbox.tie_selection) { return this.get_selected(full); }\n            return full ? $.map(this._data.checkbox.selected, function (i) { return this.get_node(i); }.bind(this)) : this._data.checkbox.selected.slice();\n        };\n        /**\n         * get an array of all top level checked nodes (ignoring children of checked nodes) (if tie_selection is on in the settings this function will return the same as get_top_selected)\n         * @name get_top_checked([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         * @plugin checkbox\n         */\n        this.get_top_checked = function (full) {\n            if(this.settings.checkbox.tie_selection) { return this.get_top_selected(full); }\n            var tmp = this.get_checked(true),\n                obj = {}, i, j, k, l;\n            for(i = 0, j = tmp.length; i < j; i++) {\n                obj[tmp[i].id] = tmp[i];\n            }\n            for(i = 0, j = tmp.length; i < j; i++) {\n                for(k = 0, l = tmp[i].children_d.length; k < l; k++) {\n                    if(obj[tmp[i].children_d[k]]) {\n                        delete obj[tmp[i].children_d[k]];\n                    }\n                }\n            }\n            tmp = [];\n            for(i in obj) {\n                if(obj.hasOwnProperty(i)) {\n                    tmp.push(i);\n                }\n            }\n            return full ? $.map(tmp, function (i) { return this.get_node(i); }.bind(this)) : tmp;\n        };\n        /**\n         * get an array of all bottom level checked nodes (ignoring selected parents) (if tie_selection is on in the settings this function will return the same as get_bottom_selected)\n         * @name get_bottom_checked([full])\n         * @param  {mixed}  full if set to `true` the returned array will consist of the full node objects, otherwise - only IDs will be returned\n         * @return {Array}\n         * @plugin checkbox\n         */\n        this.get_bottom_checked = function (full) {\n            if(this.settings.checkbox.tie_selection) { return this.get_bottom_selected(full); }\n            var tmp = this.get_checked(true),\n                obj = [], i, j;\n            for(i = 0, j = tmp.length; i < j; i++) {\n                if(!tmp[i].children.length) {\n                    obj.push(tmp[i].id);\n                }\n            }\n            return full ? $.map(obj, function (i) { return this.get_node(i); }.bind(this)) : obj;\n        };\n        this.load_node = function (obj, callback) {\n            var k, l, i, j, c, tmp;\n            if(!$.vakata.is_array(obj) && !this.settings.checkbox.tie_selection) {\n                tmp = this.get_node(obj);\n                if(tmp && tmp.state.loaded) {\n                    for(k = 0, l = tmp.children_d.length; k < l; k++) {\n                        if(this._model.data[tmp.children_d[k]].state.checked) {\n                            c = true;\n                            this._data.checkbox.selected = $.vakata.array_remove_item(this._data.checkbox.selected, tmp.children_d[k]);\n                        }\n                    }\n                }\n            }\n            return parent.load_node.apply(this, arguments);\n        };\n        this.get_state = function () {\n            var state = parent.get_state.apply(this, arguments);\n            if(this.settings.checkbox.tie_selection) { return state; }\n            state.checkbox = this._data.checkbox.selected.slice();\n            return state;\n        };\n        this.set_state = function (state, callback) {\n            var res = parent.set_state.apply(this, arguments);\n            if(res && state.checkbox) {\n                if(!this.settings.checkbox.tie_selection) {\n                    this.uncheck_all();\n                    var _this = this;\n                    $.each(state.checkbox, function (i, v) {\n                        _this.check_node(v);\n                    });\n                }\n                delete state.checkbox;\n                this.set_state(state, callback);\n                return false;\n            }\n            return res;\n        };\n        this.refresh = function (skip_loading, forget_state) {\n            if(this.settings.checkbox.tie_selection) {\n                this._data.checkbox.selected = [];\n            }\n            return parent.refresh.apply(this, arguments);\n        };\n    };\n\n    // include the checkbox plugin by default\n    // $.jstree.defaults.plugins.push(\"checkbox\");\n\n\n    /**\n     * ### Conditionalselect plugin\n     *\n     * This plugin allows defining a callback to allow or deny node selection by user input (activate node method).\n     */\n\n    /**\n     * a callback (function) which is invoked in the instance's scope and receives two arguments - the node and the event that triggered the `activate_node` call. Returning false prevents working with the node, returning true allows invoking activate_node. Defaults to returning `true`.\n     * @name $.jstree.defaults.checkbox.visible\n     * @plugin checkbox\n     */\n    $.jstree.defaults.conditionalselect = function () { return true; };\n    $.jstree.plugins.conditionalselect = function (options, parent) {\n        // own function\n        this.activate_node = function (obj, e) {\n            if(this.settings.conditionalselect.call(this, this.get_node(obj), e)) {\n                return parent.activate_node.call(this, obj, e);\n            }\n        };\n    };\n\n\n    /**\n     * ### Contextmenu plugin\n     *\n     * Shows a context menu when a node is right-clicked.\n     */\n\n    /**\n     * stores all defaults for the contextmenu plugin\n     * @name $.jstree.defaults.contextmenu\n     * @plugin contextmenu\n     */\n    $.jstree.defaults.contextmenu = {\n        /**\n         * a boolean indicating if the node should be selected when the context menu is invoked on it. Defaults to `true`.\n         * @name $.jstree.defaults.contextmenu.select_node\n         * @plugin contextmenu\n         */\n        select_node : true,\n        /**\n         * a boolean indicating if the menu should be shown aligned with the node. Defaults to `true`, otherwise the mouse coordinates are used.\n         * @name $.jstree.defaults.contextmenu.show_at_node\n         * @plugin contextmenu\n         */\n        show_at_node : true,\n        /**\n         * an object of actions, or a function that accepts a node and a callback function and calls the callback function with an object of actions available for that node (you can also return the items too).\n         *\n         * Each action consists of a key (a unique name) and a value which is an object with the following properties (only label and action are required). Once a menu item is activated the `action` function will be invoked with an object containing the following keys: item - the contextmenu item definition as seen below, reference - the DOM node that was used (the tree node), element - the contextmenu DOM element, position - an object with x/y properties indicating the position of the menu.\n         *\n         * * `separator_before` - a boolean indicating if there should be a separator before this item\n         * * `separator_after` - a boolean indicating if there should be a separator after this item\n         * * `_disabled` - a boolean indicating if this action should be disabled\n         * * `label` - a string - the name of the action (could be a function returning a string)\n         * * `title` - a string - an optional tooltip for the item\n         * * `action` - a function to be executed if this item is chosen, the function will receive\n         * * `icon` - a string, can be a path to an icon or a className, if using an image that is in the current directory use a `./` prefix, otherwise it will be detected as a class\n         * * `shortcut` - keyCode which will trigger the action if the menu is open (for example `113` for rename, which equals F2)\n         * * `shortcut_label` - shortcut label (like for example `F2` for rename)\n         * * `submenu` - an object with the same structure as $.jstree.defaults.contextmenu.items which can be used to create a submenu - each key will be rendered as a separate option in a submenu that will appear once the current item is hovered\n         *\n         * @name $.jstree.defaults.contextmenu.items\n         * @plugin contextmenu\n         */\n        items : function (o, cb) { // Could be an object directly\n            return {\n                \"create\" : {\n                    \"separator_before\"\t: false,\n                    \"separator_after\"\t: true,\n                    \"_disabled\"\t\t\t: false, //(this.check(\"create_node\", data.reference, {}, \"last\")),\n                    \"label\"\t\t\t\t: \"Create\",\n                    \"action\"\t\t\t: function (data) {\n                        var inst = $.jstree.reference(data.reference),\n                            obj = inst.get_node(data.reference);\n                        inst.create_node(obj, {}, \"last\", function (new_node) {\n                            try {\n                                inst.edit(new_node);\n                            } catch (ex) {\n                                setTimeout(function () { inst.edit(new_node); },0);\n                            }\n                        });\n                    }\n                },\n                \"rename\" : {\n                    \"separator_before\"\t: false,\n                    \"separator_after\"\t: false,\n                    \"_disabled\"\t\t\t: false, //(this.check(\"rename_node\", data.reference, this.get_parent(data.reference), \"\")),\n                    \"label\"\t\t\t\t: \"Rename\",\n                    /*!\n\t\t\t\t\t\"shortcut\"\t\t\t: 113,\n\t\t\t\t\t\"shortcut_label\"\t: 'F2',\n\t\t\t\t\t\"icon\"\t\t\t\t: \"glyphicon glyphicon-leaf\",\n\t\t\t\t\t*/\n                    \"action\"\t\t\t: function (data) {\n                        var inst = $.jstree.reference(data.reference),\n                            obj = inst.get_node(data.reference);\n                        inst.edit(obj);\n                    }\n                },\n                \"remove\" : {\n                    \"separator_before\"\t: false,\n                    \"icon\"\t\t\t\t: false,\n                    \"separator_after\"\t: false,\n                    \"_disabled\"\t\t\t: false, //(this.check(\"delete_node\", data.reference, this.get_parent(data.reference), \"\")),\n                    \"label\"\t\t\t\t: \"Delete\",\n                    \"action\"\t\t\t: function (data) {\n                        var inst = $.jstree.reference(data.reference),\n                            obj = inst.get_node(data.reference);\n                        if(inst.is_selected(obj)) {\n                            inst.delete_node(inst.get_selected());\n                        }\n                        else {\n                            inst.delete_node(obj);\n                        }\n                    }\n                },\n                \"ccp\" : {\n                    \"separator_before\"\t: true,\n                    \"icon\"\t\t\t\t: false,\n                    \"separator_after\"\t: false,\n                    \"label\"\t\t\t\t: \"Edit\",\n                    \"action\"\t\t\t: false,\n                    \"submenu\" : {\n                        \"cut\" : {\n                            \"separator_before\"\t: false,\n                            \"separator_after\"\t: false,\n                            \"label\"\t\t\t\t: \"Cut\",\n                            \"action\"\t\t\t: function (data) {\n                                var inst = $.jstree.reference(data.reference),\n                                    obj = inst.get_node(data.reference);\n                                if(inst.is_selected(obj)) {\n                                    inst.cut(inst.get_top_selected());\n                                }\n                                else {\n                                    inst.cut(obj);\n                                }\n                            }\n                        },\n                        \"copy\" : {\n                            \"separator_before\"\t: false,\n                            \"icon\"\t\t\t\t: false,\n                            \"separator_after\"\t: false,\n                            \"label\"\t\t\t\t: \"Copy\",\n                            \"action\"\t\t\t: function (data) {\n                                var inst = $.jstree.reference(data.reference),\n                                    obj = inst.get_node(data.reference);\n                                if(inst.is_selected(obj)) {\n                                    inst.copy(inst.get_top_selected());\n                                }\n                                else {\n                                    inst.copy(obj);\n                                }\n                            }\n                        },\n                        \"paste\" : {\n                            \"separator_before\"\t: false,\n                            \"icon\"\t\t\t\t: false,\n                            \"_disabled\"\t\t\t: function (data) {\n                                return !$.jstree.reference(data.reference).can_paste();\n                            },\n                            \"separator_after\"\t: false,\n                            \"label\"\t\t\t\t: \"Paste\",\n                            \"action\"\t\t\t: function (data) {\n                                var inst = $.jstree.reference(data.reference),\n                                    obj = inst.get_node(data.reference);\n                                inst.paste(obj);\n                            }\n                        }\n                    }\n                }\n            };\n        }\n    };\n\n    $.jstree.plugins.contextmenu = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n\n            var last_ts = 0, cto = null, ex, ey;\n            this.element\n                .on(\"init.jstree loading.jstree ready.jstree\", function () {\n                    this.get_container_ul().addClass('jstree-contextmenu');\n                }.bind(this))\n                .on(\"contextmenu.jstree\", \".jstree-anchor\", function (e, data) {\n                    if (e.target.tagName.toLowerCase() === 'input') {\n                        return;\n                    }\n                    e.preventDefault();\n                    last_ts = e.ctrlKey ? +new Date() : 0;\n                    if(data || cto) {\n                        last_ts = (+new Date()) + 10000;\n                    }\n                    if(cto) {\n                        clearTimeout(cto);\n                    }\n                    if(!this.is_loading(e.currentTarget)) {\n                        this.show_contextmenu(e.currentTarget, e.pageX, e.pageY, e);\n                    }\n                }.bind(this))\n                .on(\"click.jstree\", \".jstree-anchor\", function (e) {\n                    if(this._data.contextmenu.visible && (!last_ts || (+new Date()) - last_ts > 250)) { // work around safari & macOS ctrl+click\n                        $.vakata.context.hide();\n                    }\n                    last_ts = 0;\n                }.bind(this))\n                .on(\"touchstart.jstree\", \".jstree-anchor\", function (e) {\n                    if(!e.originalEvent || !e.originalEvent.changedTouches || !e.originalEvent.changedTouches[0]) {\n                        return;\n                    }\n                    ex = e.originalEvent.changedTouches[0].clientX;\n                    ey = e.originalEvent.changedTouches[0].clientY;\n                    cto = setTimeout(function () {\n                        $(e.currentTarget).trigger('contextmenu', true);\n                    }, 750);\n                })\n                .on('touchmove.vakata.jstree', function (e) {\n                    if(cto && e.originalEvent && e.originalEvent.changedTouches && e.originalEvent.changedTouches[0] && (Math.abs(ex - e.originalEvent.changedTouches[0].clientX) > 10 || Math.abs(ey - e.originalEvent.changedTouches[0].clientY) > 10)) {\n                        clearTimeout(cto);\n                        $.vakata.context.hide();\n                    }\n                })\n                .on('touchend.vakata.jstree', function (e) {\n                    if(cto) {\n                        clearTimeout(cto);\n                    }\n                });\n\n            /*!\n\t\t\tif(!('oncontextmenu' in document.body) && ('ontouchstart' in document.body)) {\n\t\t\t\tvar el = null, tm = null;\n\t\t\t\tthis.element\n\t\t\t\t\t.on(\"touchstart\", \".jstree-anchor\", function (e) {\n\t\t\t\t\t\tel = e.currentTarget;\n\t\t\t\t\t\ttm = +new Date();\n\t\t\t\t\t\t$(document).one(\"touchend\", function (e) {\n\t\t\t\t\t\t\te.target = document.elementFromPoint(e.originalEvent.targetTouches[0].pageX - window.pageXOffset, e.originalEvent.targetTouches[0].pageY - window.pageYOffset);\n\t\t\t\t\t\t\te.currentTarget = e.target;\n\t\t\t\t\t\t\ttm = ((+(new Date())) - tm);\n\t\t\t\t\t\t\tif(e.target === el && tm > 600 && tm < 1000) {\n\t\t\t\t\t\t\t\te.preventDefault();\n\t\t\t\t\t\t\t\t$(el).trigger('contextmenu', e);\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tel = null;\n\t\t\t\t\t\t\ttm = null;\n\t\t\t\t\t\t});\n\t\t\t\t\t});\n\t\t\t}\n\t\t\t*/\n            $(document).on(\"context_hide.vakata.jstree\", function (e, data) {\n                this._data.contextmenu.visible = false;\n                $(data.reference).removeClass('jstree-context');\n            }.bind(this));\n        };\n        this.teardown = function () {\n            if(this._data.contextmenu.visible) {\n                $.vakata.context.hide();\n            }\n            $(document).off(\"context_hide.vakata.jstree\");\n            parent.teardown.call(this);\n        };\n\n        /**\n         * prepare and show the context menu for a node\n         * @name show_contextmenu(obj [, x, y])\n         * @param {mixed} obj the node\n         * @param {Number} x the x-coordinate relative to the document to show the menu at\n         * @param {Number} y the y-coordinate relative to the document to show the menu at\n         * @param {Object} e the event if available that triggered the contextmenu\n         * @plugin contextmenu\n         * @trigger show_contextmenu.jstree\n         */\n        this.show_contextmenu = function (obj, x, y, e) {\n            obj = this.get_node(obj);\n            if(!obj || obj.id === $.jstree.root) { return false; }\n            var s = this.settings.contextmenu,\n                d = this.get_node(obj, true),\n                a = d.children(\".jstree-anchor\"),\n                o = false,\n                i = false;\n            if(s.show_at_node || x === undefined || y === undefined) {\n                o = a.offset();\n                x = o.left;\n                y = o.top + this._data.core.li_height;\n            }\n            if(this.settings.contextmenu.select_node && !this.is_selected(obj)) {\n                this.activate_node(obj, e);\n            }\n\n            i = s.items;\n            if($.vakata.is_function(i)) {\n                i = i.call(this, obj, function (i) {\n                    this._show_contextmenu(obj, x, y, i);\n                }.bind(this));\n            }\n            if($.isPlainObject(i)) {\n                this._show_contextmenu(obj, x, y, i);\n            }\n        };\n        /**\n         * show the prepared context menu for a node\n         * @name _show_contextmenu(obj, x, y, i)\n         * @param {mixed} obj the node\n         * @param {Number} x the x-coordinate relative to the document to show the menu at\n         * @param {Number} y the y-coordinate relative to the document to show the menu at\n         * @param {Number} i the object of items to show\n         * @plugin contextmenu\n         * @trigger show_contextmenu.jstree\n         * @private\n         */\n        this._show_contextmenu = function (obj, x, y, i) {\n            var d = this.get_node(obj, true),\n                a = d.children(\".jstree-anchor\");\n            $(document).one(\"context_show.vakata.jstree\", function (e, data) {\n                var cls = 'jstree-contextmenu jstree-' + this.get_theme() + '-contextmenu';\n                $(data.element).addClass(cls);\n                a.addClass('jstree-context');\n            }.bind(this));\n            this._data.contextmenu.visible = true;\n            $.vakata.context.show(a, { 'x' : x, 'y' : y }, i);\n            /**\n             * triggered when the contextmenu is shown for a node\n             * @event\n             * @name show_contextmenu.jstree\n             * @param {Object} node the node\n             * @param {Number} x the x-coordinate of the menu relative to the document\n             * @param {Number} y the y-coordinate of the menu relative to the document\n             * @plugin contextmenu\n             */\n            this.trigger('show_contextmenu', { \"node\" : obj, \"x\" : x, \"y\" : y });\n        };\n    };\n\n    // contextmenu helper\n    (function ($) {\n        var right_to_left = false,\n            vakata_context = {\n                element\t\t: false,\n                reference\t: false,\n                position_x\t: 0,\n                position_y\t: 0,\n                items\t\t: [],\n                html\t\t: \"\",\n                is_visible\t: false\n            };\n\n        $.vakata.context = {\n            settings : {\n                hide_onmouseleave\t: 0,\n                icons\t\t\t\t: true\n            },\n            _trigger : function (event_name) {\n                $(document).triggerHandler(\"context_\" + event_name + \".vakata\", {\n                    \"reference\"\t: vakata_context.reference,\n                    \"element\"\t: vakata_context.element,\n                    \"position\"\t: {\n                        \"x\" : vakata_context.position_x,\n                        \"y\" : vakata_context.position_y\n                    }\n                });\n            },\n            _execute : function (i) {\n                i = vakata_context.items[i];\n                return i && (!i._disabled || ($.vakata.is_function(i._disabled) && !i._disabled({ \"item\" : i, \"reference\" : vakata_context.reference, \"element\" : vakata_context.element }))) && i.action ? i.action.call(null, {\n                    \"item\"\t\t: i,\n                    \"reference\"\t: vakata_context.reference,\n                    \"element\"\t: vakata_context.element,\n                    \"position\"\t: {\n                        \"x\" : vakata_context.position_x,\n                        \"y\" : vakata_context.position_y\n                    }\n                }) : false;\n            },\n            _parse : function (o, is_callback) {\n                if(!o) { return false; }\n                if(!is_callback) {\n                    vakata_context.html\t\t= \"\";\n                    vakata_context.items\t= [];\n                }\n                var str = \"\",\n                    sep = false,\n                    tmp;\n\n                if(is_callback) { str += \"<\"+\"ul>\"; }\n                $.each(o, function (i, val) {\n                    if(!val) { return true; }\n                    vakata_context.items.push(val);\n                    if(!sep && val.separator_before) {\n                        str += \"<\"+\"li class='vakata-context-separator'><\"+\"a href='#' \" + ($.vakata.context.settings.icons ? '' : 'class=\"vakata-context-no-icons\"') + \">&#160;<\"+\"/a><\"+\"/li>\";\n                    }\n                    sep = false;\n                    str += \"<\"+\"li class='\" + (val._class || \"\") + (val._disabled === true || ($.vakata.is_function(val._disabled) && val._disabled({ \"item\" : val, \"reference\" : vakata_context.reference, \"element\" : vakata_context.element })) ? \" vakata-contextmenu-disabled \" : \"\") + \"' \"+(val.shortcut?\" data-shortcut='\"+val.shortcut+\"' \":'')+\">\";\n                    str += \"<\"+\"a href='#' rel='\" + (vakata_context.items.length - 1) + \"' \" + (val.title ? \"title='\" + val.title + \"'\" : \"\") + \">\";\n                    if($.vakata.context.settings.icons) {\n                        str += \"<\"+\"i \";\n                        if(val.icon) {\n                            if(val.icon.indexOf(\"/\") !== -1 || val.icon.indexOf(\".\") !== -1) { str += \" style='background:url(\\\"\" + val.icon + \"\\\") center center no-repeat' \"; }\n                            else { str += \" class='\" + val.icon + \"' \"; }\n                        }\n                        str += \"><\"+\"/i><\"+\"span class='vakata-contextmenu-sep'>&#160;<\"+\"/span>\";\n                    }\n                    str += ($.vakata.is_function(val.label) ? val.label({ \"item\" : i, \"reference\" : vakata_context.reference, \"element\" : vakata_context.element }) : val.label) + (val.shortcut?' <span class=\"vakata-contextmenu-shortcut vakata-contextmenu-shortcut-'+val.shortcut+'\">'+ (val.shortcut_label || '') +'</span>':'') + \"<\"+\"/a>\";\n                    if(val.submenu) {\n                        tmp = $.vakata.context._parse(val.submenu, true);\n                        if(tmp) { str += tmp; }\n                    }\n                    str += \"<\"+\"/li>\";\n                    if(val.separator_after) {\n                        str += \"<\"+\"li class='vakata-context-separator'><\"+\"a href='#' \" + ($.vakata.context.settings.icons ? '' : 'class=\"vakata-context-no-icons\"') + \">&#160;<\"+\"/a><\"+\"/li>\";\n                        sep = true;\n                    }\n                });\n                str  = str.replace(/<li class\\='vakata-context-separator'\\><\\/li\\>$/,\"\");\n                if(is_callback) { str += \"</ul>\"; }\n                /**\n                 * triggered on the document when the contextmenu is parsed (HTML is built)\n                 * @event\n                 * @plugin contextmenu\n                 * @name context_parse.vakata\n                 * @param {jQuery} reference the element that was right clicked\n                 * @param {jQuery} element the DOM element of the menu itself\n                 * @param {Object} position the x & y coordinates of the menu\n                 */\n                if(!is_callback) { vakata_context.html = str; $.vakata.context._trigger(\"parse\"); }\n                return str.length > 10 ? str : false;\n            },\n            _show_submenu : function (o) {\n                o = $(o);\n                if(!o.length || !o.children(\"ul\").length) { return; }\n                var e = o.children(\"ul\"),\n                    xl = o.offset().left,\n                    x = xl + o.outerWidth(),\n                    y = o.offset().top,\n                    w = e.width(),\n                    h = e.height(),\n                    dw = $(window).width() + $(window).scrollLeft(),\n                    dh = $(window).height() + $(window).scrollTop();\n                // \u043c\u043e\u0436\u0435 \u0434\u0430 \u0441\u0435 \u0441\u043f\u0435\u0441\u0442\u0438 \u0435 \u0435\u0434\u043d\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 - \u0434\u0430\u043b\u0438 \u043d\u044f\u043c\u0430 \u043d\u044f\u043a\u043e\u0439 \u043e\u0442 \u043a\u043b\u0430\u0441\u043e\u0432\u0435\u0442\u0435 \u0432\u0435\u0447\u0435 \u043d\u0430\u0433\u043e\u0440\u0435\n                if(right_to_left) {\n                    o[x - (w + 10 + o.outerWidth()) < 0 ? \"addClass\" : \"removeClass\"](\"vakata-context-left\");\n                }\n                else {\n                    o[x + w > dw  && xl > dw - x ? \"addClass\" : \"removeClass\"](\"vakata-context-right\");\n                }\n                if(y + h + 10 > dh) {\n                    e.css(\"bottom\",\"-1px\");\n                }\n\n                //if does not fit - stick it to the side\n                if (o.hasClass('vakata-context-right')) {\n                    if (xl < w) {\n                        e.css(\"margin-right\", xl - w);\n                    }\n                } else {\n                    if (dw - x < w) {\n                        e.css(\"margin-left\", dw - x - w);\n                    }\n                }\n\n                e.show();\n            },\n            show : function (reference, position, data) {\n                var o, e, x, y, w, h, dw, dh, cond = true;\n                if(vakata_context.element && vakata_context.element.length) {\n                    vakata_context.element.width('');\n                }\n                switch(cond) {\n                    case (!position && !reference):\n                        return false;\n                    case (!!position && !!reference):\n                        vakata_context.reference\t= reference;\n                        vakata_context.position_x\t= position.x;\n                        vakata_context.position_y\t= position.y;\n                        break;\n                    case (!position && !!reference):\n                        vakata_context.reference\t= reference;\n                        o = reference.offset();\n                        vakata_context.position_x\t= o.left + reference.outerHeight();\n                        vakata_context.position_y\t= o.top;\n                        break;\n                    case (!!position && !reference):\n                        vakata_context.position_x\t= position.x;\n                        vakata_context.position_y\t= position.y;\n                        break;\n                }\n                if(!!reference && !data && $(reference).data('vakata_contextmenu')) {\n                    data = $(reference).data('vakata_contextmenu');\n                }\n                if($.vakata.context._parse(data)) {\n                    vakata_context.element.html(vakata_context.html);\n                }\n                if(vakata_context.items.length) {\n                    vakata_context.element.appendTo(document.body);\n                    e = vakata_context.element;\n                    x = vakata_context.position_x;\n                    y = vakata_context.position_y;\n                    w = e.width();\n                    h = e.height();\n                    dw = $(window).width() + $(window).scrollLeft();\n                    dh = $(window).height() + $(window).scrollTop();\n                    if(right_to_left) {\n                        x -= (e.outerWidth() - $(reference).outerWidth());\n                        if(x < $(window).scrollLeft() + 20) {\n                            x = $(window).scrollLeft() + 20;\n                        }\n                    }\n                    if(x + w + 20 > dw) {\n                        x = dw - (w + 20);\n                    }\n                    if(y + h + 20 > dh) {\n                        y = dh - (h + 20);\n                    }\n\n                    vakata_context.element\n                        .css({ \"left\" : x, \"top\" : y })\n                        .show()\n                        .find('a').first().trigger('focus').parent().addClass(\"vakata-context-hover\");\n                    vakata_context.is_visible = true;\n                    /**\n                     * triggered on the document when the contextmenu is shown\n                     * @event\n                     * @plugin contextmenu\n                     * @name context_show.vakata\n                     * @param {jQuery} reference the element that was right clicked\n                     * @param {jQuery} element the DOM element of the menu itself\n                     * @param {Object} position the x & y coordinates of the menu\n                     */\n                    $.vakata.context._trigger(\"show\");\n                }\n            },\n            hide : function () {\n                if(vakata_context.is_visible) {\n                    vakata_context.element.hide().find(\"ul\").hide().end().find(':focus').trigger('blur').end().detach();\n                    vakata_context.is_visible = false;\n                    /**\n                     * triggered on the document when the contextmenu is hidden\n                     * @event\n                     * @plugin contextmenu\n                     * @name context_hide.vakata\n                     * @param {jQuery} reference the element that was right clicked\n                     * @param {jQuery} element the DOM element of the menu itself\n                     * @param {Object} position the x & y coordinates of the menu\n                     */\n                    $.vakata.context._trigger(\"hide\");\n                }\n            }\n        };\n        $(function () {\n            right_to_left = $(document.body).css(\"direction\") === \"rtl\";\n            var to = false;\n\n            vakata_context.element = $(\"<ul class='vakata-context'></ul>\");\n            vakata_context.element\n                .on(\"mouseenter\", \"li\", function (e) {\n                    e.stopImmediatePropagation();\n\n                    if($.contains(this, e.relatedTarget)) {\n                        // \u043f\u0440\u0435\u043c\u0430\u0445\u043d\u0430\u0442\u043e \u0437\u0430\u0440\u0430\u0434\u0438 delegate mouseleave \u043f\u043e-\u0434\u043e\u043b\u0443\n                        // $(this).find(\".vakata-context-hover\").removeClass(\"vakata-context-hover\");\n                        return;\n                    }\n\n                    if(to) { clearTimeout(to); }\n                    vakata_context.element.find(\".vakata-context-hover\").removeClass(\"vakata-context-hover\").end();\n\n                    $(this)\n                        .siblings().find(\"ul\").hide().end().end()\n                        .parentsUntil(\".vakata-context\", \"li\").addBack().addClass(\"vakata-context-hover\");\n                    $.vakata.context._show_submenu(this);\n                })\n                // \u0442\u0435\u0441\u0442\u043e\u0432\u043e - \u0434\u0430\u043b\u0438 \u043d\u0435 \u043d\u0430\u0442\u043e\u0432\u0430\u0440\u0432\u0430?\n                .on(\"mouseleave\", \"li\", function (e) {\n                    if($.contains(this, e.relatedTarget)) { return; }\n                    $(this).find(\".vakata-context-hover\").addBack().removeClass(\"vakata-context-hover\");\n                })\n                .on(\"mouseleave\", function (e) {\n                    $(this).find(\".vakata-context-hover\").removeClass(\"vakata-context-hover\");\n                    if($.vakata.context.settings.hide_onmouseleave) {\n                        to = setTimeout(\n                            (function (t) {\n                                return function () { $.vakata.context.hide(); };\n                            }(this)), $.vakata.context.settings.hide_onmouseleave);\n                    }\n                })\n                .on(\"click\", \"a\", function (e) {\n                    e.preventDefault();\n                    //})\n                    //.on(\"mouseup\", \"a\", function (e) {\n                    if(!$(this).trigger('blur').parent().hasClass(\"vakata-context-disabled\") && $.vakata.context._execute($(this).attr(\"rel\")) !== false) {\n                        $.vakata.context.hide();\n                    }\n                })\n                .on('keydown', 'a', function (e) {\n                    var o = null;\n                    switch(e.which) {\n                        case 13:\n                        case 32:\n                            e.type = \"click\";\n                            e.preventDefault();\n                            $(e.currentTarget).trigger(e);\n                            break;\n                        case 37:\n                            if(vakata_context.is_visible) {\n                                vakata_context.element.find(\".vakata-context-hover\").last().closest(\"li\").first().find(\"ul\").hide().find(\".vakata-context-hover\").removeClass(\"vakata-context-hover\").end().end().children('a').trigger('focus');\n                                e.stopImmediatePropagation();\n                                e.preventDefault();\n                            }\n                            break;\n                        case 38:\n                            if(vakata_context.is_visible) {\n                                o = vakata_context.element.find(\"ul:visible\").addBack().last().children(\".vakata-context-hover\").removeClass(\"vakata-context-hover\").prevAll(\"li:not(.vakata-context-separator)\").first();\n                                if(!o.length) { o = vakata_context.element.find(\"ul:visible\").addBack().last().children(\"li:not(.vakata-context-separator)\").last(); }\n                                o.addClass(\"vakata-context-hover\").children('a').trigger('focus');\n                                e.stopImmediatePropagation();\n                                e.preventDefault();\n                            }\n                            break;\n                        case 39:\n                            if(vakata_context.is_visible) {\n                                vakata_context.element.find(\".vakata-context-hover\").last().children(\"ul\").show().children(\"li:not(.vakata-context-separator)\").removeClass(\"vakata-context-hover\").first().addClass(\"vakata-context-hover\").children('a').trigger('focus');\n                                e.stopImmediatePropagation();\n                                e.preventDefault();\n                            }\n                            break;\n                        case 40:\n                            if(vakata_context.is_visible) {\n                                o = vakata_context.element.find(\"ul:visible\").addBack().last().children(\".vakata-context-hover\").removeClass(\"vakata-context-hover\").nextAll(\"li:not(.vakata-context-separator)\").first();\n                                if(!o.length) { o = vakata_context.element.find(\"ul:visible\").addBack().last().children(\"li:not(.vakata-context-separator)\").first(); }\n                                o.addClass(\"vakata-context-hover\").children('a').trigger('focus');\n                                e.stopImmediatePropagation();\n                                e.preventDefault();\n                            }\n                            break;\n                        case 27:\n                            $.vakata.context.hide();\n                            e.preventDefault();\n                            break;\n                        default:\n                            //console.log(e.which);\n                            break;\n                    }\n                })\n                .on('keydown', function (e) {\n                    e.preventDefault();\n                    var a = vakata_context.element.find('.vakata-contextmenu-shortcut-' + e.which).parent();\n                    if(a.parent().not('.vakata-context-disabled')) {\n                        a.trigger('click');\n                    }\n                });\n\n            $(document)\n                .on(\"mousedown.vakata.jstree\", function (e) {\n                    if(vakata_context.is_visible && vakata_context.element[0] !== e.target  && !$.contains(vakata_context.element[0], e.target)) {\n                        $.vakata.context.hide();\n                    }\n                })\n                .on(\"context_show.vakata.jstree\", function (e, data) {\n                    vakata_context.element.find(\"li:has(ul)\").children(\"a\").addClass(\"vakata-context-parent\");\n                    if(right_to_left) {\n                        vakata_context.element.addClass(\"vakata-context-rtl\").css(\"direction\", \"rtl\");\n                    }\n                    // also apply a RTL class?\n                    vakata_context.element.find(\"ul\").hide().end();\n                });\n        });\n    }($));\n    // $.jstree.defaults.plugins.push(\"contextmenu\");\n\n\n    /**\n     * ### Drag'n'drop plugin\n     *\n     * Enables dragging and dropping of nodes in the tree, resulting in a move or copy operations.\n     */\n\n    /**\n     * stores all defaults for the drag'n'drop plugin\n     * @name $.jstree.defaults.dnd\n     * @plugin dnd\n     */\n    $.jstree.defaults.dnd = {\n        /**\n         * a boolean indicating if a copy should be possible while dragging (by pressint the meta key or Ctrl). Defaults to `true`.\n         * @name $.jstree.defaults.dnd.copy\n         * @plugin dnd\n         */\n        copy : true,\n        /**\n         * a number indicating how long a node should remain hovered while dragging to be opened. Defaults to `500`.\n         * @name $.jstree.defaults.dnd.open_timeout\n         * @plugin dnd\n         */\n        open_timeout : 500,\n        /**\n         * a function invoked each time a node is about to be dragged, invoked in the tree's scope and receives the nodes about to be dragged as an argument (array) and the event that started the drag - return `false` to prevent dragging\n         * @name $.jstree.defaults.dnd.is_draggable\n         * @plugin dnd\n         */\n        is_draggable : true,\n        /**\n         * a boolean indicating if checks should constantly be made while the user is dragging the node (as opposed to checking only on drop), default is `true`\n         * @name $.jstree.defaults.dnd.check_while_dragging\n         * @plugin dnd\n         */\n        check_while_dragging : true,\n        /**\n         * a boolean indicating if nodes from this tree should only be copied with dnd (as opposed to moved), default is `false`\n         * @name $.jstree.defaults.dnd.always_copy\n         * @plugin dnd\n         */\n        always_copy : false,\n        /**\n         * when dropping a node \"inside\", this setting indicates the position the node should go to - it can be an integer or a string: \"first\" (same as 0) or \"last\", default is `0`\n         * @name $.jstree.defaults.dnd.inside_pos\n         * @plugin dnd\n         */\n        inside_pos : 0,\n        /**\n         * when starting the drag on a node that is selected this setting controls if all selected nodes are dragged or only the single node, default is `true`, which means all selected nodes are dragged when the drag is started on a selected node\n         * @name $.jstree.defaults.dnd.drag_selection\n         * @plugin dnd\n         */\n        drag_selection : true,\n        /**\n         * controls whether dnd works on touch devices. If left as boolean true dnd will work the same as in desktop browsers, which in some cases may impair scrolling. If set to boolean false dnd will not work on touch devices. There is a special third option - string \"selected\" which means only selected nodes can be dragged on touch devices.\n         * @name $.jstree.defaults.dnd.touch\n         * @plugin dnd\n         */\n        touch : true,\n        /**\n         * controls whether items can be dropped anywhere on the node, not just on the anchor, by default only the node anchor is a valid drop target. Works best with the wholerow plugin. If enabled on mobile depending on the interface it might be hard for the user to cancel the drop, since the whole tree container will be a valid drop target.\n         * @name $.jstree.defaults.dnd.large_drop_target\n         * @plugin dnd\n         */\n        large_drop_target : false,\n        /**\n         * controls whether a drag can be initiated from any part of the node and not just the text/icon part, works best with the wholerow plugin. Keep in mind it can cause problems with tree scrolling on mobile depending on the interface - in that case set the touch option to \"selected\".\n         * @name $.jstree.defaults.dnd.large_drag_target\n         * @plugin dnd\n         */\n        large_drag_target : false,\n        /**\n         * controls whether use HTML5 dnd api instead of classical. That will allow better integration of dnd events with other HTML5 controls.\n         * @reference http://caniuse.com/#feat=dragndrop\n         * @name $.jstree.defaults.dnd.use_html5\n         * @plugin dnd\n         */\n        use_html5: false\n    };\n    var drg, elm;\n    // TODO: now check works by checking for each node individually, how about max_children, unique, etc?\n    $.jstree.plugins.dnd = function (options, parent) {\n        this.init = function (el, options) {\n            parent.init.call(this, el, options);\n            this.settings.dnd.use_html5 = this.settings.dnd.use_html5 && ('draggable' in document.createElement('span'));\n        };\n        this.bind = function () {\n            parent.bind.call(this);\n\n            this.element\n                .on(this.settings.dnd.use_html5 ? 'dragstart.jstree' : 'mousedown.jstree touchstart.jstree', this.settings.dnd.large_drag_target ? '.jstree-node' : '.jstree-anchor', function (e) {\n                    if(this.settings.dnd.large_drag_target && $(e.target).closest('.jstree-node')[0] !== e.currentTarget) {\n                        return true;\n                    }\n                    if(e.type === \"touchstart\" && (!this.settings.dnd.touch || (this.settings.dnd.touch === 'selected' && !$(e.currentTarget).closest('.jstree-node').children('.jstree-anchor').hasClass('jstree-clicked')))) {\n                        return true;\n                    }\n                    var obj = this.get_node(e.target),\n                        mlt = this.is_selected(obj) && this.settings.dnd.drag_selection ? this.get_top_selected().length : 1,\n                        txt = (mlt > 1 ? mlt + ' ' + this.get_string('nodes') : this.get_text(e.currentTarget));\n                    if(this.settings.core.force_text) {\n                        txt = $.vakata.html.escape(txt);\n                    }\n                    if(obj && obj.id && obj.id !== $.jstree.root && (e.which === 1 || e.type === \"touchstart\" || e.type === \"dragstart\") &&\n                        (this.settings.dnd.is_draggable === true || ($.vakata.is_function(this.settings.dnd.is_draggable) && this.settings.dnd.is_draggable.call(this, (mlt > 1 ? this.get_top_selected(true) : [obj]), e)))\n                    ) {\n                        drg = { 'jstree' : true, 'origin' : this, 'obj' : this.get_node(obj,true), 'nodes' : mlt > 1 ? this.get_top_selected() : [obj.id] };\n                        elm = e.currentTarget;\n                        if (this.settings.dnd.use_html5) {\n                            $.vakata.dnd._trigger('start', e, { 'helper': $(), 'element': elm, 'data': drg });\n                        } else {\n                            this.element.trigger('mousedown.jstree');\n                            return $.vakata.dnd.start(e, drg, '<div id=\"jstree-dnd\" class=\"jstree-' + this.get_theme() + ' jstree-' + this.get_theme() + '-' + this.get_theme_variant() + ' ' + ( this.settings.core.themes.responsive ? ' jstree-dnd-responsive' : '' ) + '\"><i class=\"jstree-icon jstree-er\"></i>' + txt + '<ins class=\"jstree-copy\">+</ins></div>');\n                        }\n                    }\n                }.bind(this));\n            if (this.settings.dnd.use_html5) {\n                this.element\n                    .on('dragover.jstree', function (e) {\n                        e.preventDefault();\n                        $.vakata.dnd._trigger('move', e, { 'helper': $(), 'element': elm, 'data': drg });\n                        return false;\n                    })\n                    //.on('dragenter.jstree', this.settings.dnd.large_drop_target ? '.jstree-node' : '.jstree-anchor', $.proxy(function (e) {\n                    //\t\te.preventDefault();\n                    //\t\t$.vakata.dnd._trigger('move', e, { 'helper': $(), 'element': elm, 'data': drg });\n                    //\t\treturn false;\n                    //\t}, this))\n                    .on('drop.jstree', function (e) {\n                        e.preventDefault();\n                        $.vakata.dnd._trigger('stop', e, { 'helper': $(), 'element': elm, 'data': drg });\n                        return false;\n                    }.bind(this));\n            }\n        };\n        this.redraw_node = function(obj, deep, callback, force_render) {\n            obj = parent.redraw_node.apply(this, arguments);\n            if (obj && this.settings.dnd.use_html5) {\n                if (this.settings.dnd.large_drag_target) {\n                    obj.setAttribute('draggable', true);\n                } else {\n                    var i, j, tmp = null;\n                    for(i = 0, j = obj.childNodes.length; i < j; i++) {\n                        if(obj.childNodes[i] && obj.childNodes[i].className && obj.childNodes[i].className.indexOf(\"jstree-anchor\") !== -1) {\n                            tmp = obj.childNodes[i];\n                            break;\n                        }\n                    }\n                    if(tmp) {\n                        tmp.setAttribute('draggable', true);\n                    }\n                }\n            }\n            return obj;\n        };\n    };\n\n    $(function() {\n        // bind only once for all instances\n        var lastmv = false,\n            laster = false,\n            lastev = false,\n            opento = false,\n            marker = $('<div id=\"jstree-marker\">&#160;</div>').hide(); //.appendTo('body');\n\n        $(document)\n            .on('dragover.vakata.jstree', function (e) {\n                if (elm) {\n                    $.vakata.dnd._trigger('move', e, { 'helper': $(), 'element': elm, 'data': drg });\n                }\n            })\n            .on('drop.vakata.jstree', function (e) {\n                if (elm) {\n                    $.vakata.dnd._trigger('stop', e, { 'helper': $(), 'element': elm, 'data': drg });\n                    elm = null;\n                    drg = null;\n                }\n            })\n            .on('dnd_start.vakata.jstree', function (e, data) {\n                lastmv = false;\n                lastev = false;\n                if(!data || !data.data || !data.data.jstree) { return; }\n                marker.appendTo(document.body); //.show();\n            })\n            .on('dnd_move.vakata.jstree', function (e, data) {\n                var isDifferentNode = data.event.target !== lastev.target;\n                if(opento) {\n                    if (!data.event || data.event.type !== 'dragover' || isDifferentNode) {\n                        clearTimeout(opento);\n                    }\n                }\n                if(!data || !data.data || !data.data.jstree) { return; }\n\n                // if we are hovering the marker image do nothing (can happen on \"inside\" drags)\n                if(data.event.target.id && data.event.target.id === 'jstree-marker') {\n                    return;\n                }\n                lastev = data.event;\n\n                var ins = $.jstree.reference(data.event.target),\n                    ref = false,\n                    off = false,\n                    rel = false,\n                    tmp, l, t, h, p, i, o, ok, t1, t2, op, ps, pr, ip, tm, is_copy, pn, c;\n                // if we are over an instance\n                if(ins && ins._data && ins._data.dnd) {\n                    marker.attr('class', 'jstree-' + ins.get_theme() + ( ins.settings.core.themes.responsive ? ' jstree-dnd-responsive' : '' ));\n                    is_copy = data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (data.event.metaKey || data.event.ctrlKey)));\n                    data.helper\n                        .children().attr('class', 'jstree-' + ins.get_theme() + ' jstree-' + ins.get_theme() + '-' + ins.get_theme_variant() + ' ' + ( ins.settings.core.themes.responsive ? ' jstree-dnd-responsive' : '' ))\n                        .find('.jstree-copy').first()[ is_copy ? 'show' : 'hide' ]();\n\n                    // if are hovering the container itself add a new root node\n                    //console.log(data.event);\n                    if( (data.event.target === ins.element[0] || data.event.target === ins.get_container_ul()[0]) && ins.get_container_ul().children().length === 0) {\n                        ok = true;\n                        for(t1 = 0, t2 = data.data.nodes.length; t1 < t2; t1++) {\n                            ok = ok && ins.check( (data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (data.event.metaKey || data.event.ctrlKey)) ) ? \"copy_node\" : \"move_node\"), (data.data.origin && data.data.origin !== ins ? data.data.origin.get_node(data.data.nodes[t1]) : data.data.nodes[t1]), $.jstree.root, 'last', { 'dnd' : true, 'ref' : ins.get_node($.jstree.root), 'pos' : 'i', 'origin' : data.data.origin, 'is_multi' : (data.data.origin && data.data.origin !== ins), 'is_foreign' : (!data.data.origin) });\n                            if(!ok) { break; }\n                        }\n                        if(ok) {\n                            lastmv = { 'ins' : ins, 'par' : $.jstree.root, 'pos' : 'last' };\n                            marker.hide();\n                            data.helper.find('.jstree-icon').first().removeClass('jstree-er').addClass('jstree-ok');\n                            if (data.event.originalEvent && data.event.originalEvent.dataTransfer) {\n                                data.event.originalEvent.dataTransfer.dropEffect = is_copy ? 'copy' : 'move';\n                            }\n                            return;\n                        }\n                    }\n                    else {\n                        // if we are hovering a tree node\n                        ref = ins.settings.dnd.large_drop_target ? $(data.event.target).closest('.jstree-node').children('.jstree-anchor') : $(data.event.target).closest('.jstree-anchor');\n                        if(ref && ref.length && ref.parent().is('.jstree-closed, .jstree-open, .jstree-leaf')) {\n                            off = ref.offset();\n                            rel = (data.event.pageY !== undefined ? data.event.pageY : data.event.originalEvent.pageY) - off.top;\n                            h = ref.outerHeight();\n                            if(rel < h / 3) {\n                                o = ['b', 'i', 'a'];\n                            }\n                            else if(rel > h - h / 3) {\n                                o = ['a', 'i', 'b'];\n                            }\n                            else {\n                                o = rel > h / 2 ? ['i', 'a', 'b'] : ['i', 'b', 'a'];\n                            }\n                            $.each(o, function (j, v) {\n                                switch(v) {\n                                    case 'b':\n                                        l = off.left - 6;\n                                        t = off.top;\n                                        p = ins.get_parent(ref);\n                                        i = ref.parent().index();\n                                        c = 'jstree-below';\n                                        break;\n                                    case 'i':\n                                        ip = ins.settings.dnd.inside_pos;\n                                        tm = ins.get_node(ref.parent());\n                                        l = off.left - 2;\n                                        t = off.top + h / 2 + 1;\n                                        p = tm.id;\n                                        i = ip === 'first' ? 0 : (ip === 'last' ? tm.children.length : Math.min(ip, tm.children.length));\n                                        c = 'jstree-inside';\n                                        break;\n                                    case 'a':\n                                        l = off.left - 6;\n                                        t = off.top + h;\n                                        p = ins.get_parent(ref);\n                                        i = ref.parent().index() + 1;\n                                        c = 'jstree-above';\n                                        break;\n                                }\n                                ok = true;\n                                for(t1 = 0, t2 = data.data.nodes.length; t1 < t2; t1++) {\n                                    op = data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (data.event.metaKey || data.event.ctrlKey))) ? \"copy_node\" : \"move_node\";\n                                    ps = i;\n                                    if(op === \"move_node\" && v === 'a' && (data.data.origin && data.data.origin === ins) && p === ins.get_parent(data.data.nodes[t1])) {\n                                        pr = ins.get_node(p);\n                                        if(ps > $.inArray(data.data.nodes[t1], pr.children)) {\n                                            ps -= 1;\n                                        }\n                                    }\n                                    ok = ok && ( (ins && ins.settings && ins.settings.dnd && ins.settings.dnd.check_while_dragging === false) || ins.check(op, (data.data.origin && data.data.origin !== ins ? data.data.origin.get_node(data.data.nodes[t1]) : data.data.nodes[t1]), p, ps, { 'dnd' : true, 'ref' : ins.get_node(ref.parent()), 'pos' : v, 'origin' : data.data.origin, 'is_multi' : (data.data.origin && data.data.origin !== ins), 'is_foreign' : (!data.data.origin) }) );\n                                    if(!ok) {\n                                        if(ins && ins.last_error) { laster = ins.last_error(); }\n                                        break;\n                                    }\n                                }\n                                if(v === 'i' && ref.parent().is('.jstree-closed') && ins.settings.dnd.open_timeout) {\n                                    if (!data.event || data.event.type !== 'dragover' || isDifferentNode) {\n                                        if (opento) { clearTimeout(opento); }\n                                        opento = setTimeout((function (x, z) { return function () { x.open_node(z); }; }(ins, ref)), ins.settings.dnd.open_timeout);\n                                    }\n                                }\n                                if(ok) {\n                                    pn = ins.get_node(p, true);\n                                    if (!pn.hasClass('.jstree-dnd-parent')) {\n                                        $('.jstree-dnd-parent').removeClass('jstree-dnd-parent');\n                                        pn.addClass('jstree-dnd-parent');\n                                    }\n                                    lastmv = { 'ins' : ins, 'par' : p, 'pos' : v === 'i' && ip === 'last' && i === 0 && !ins.is_loaded(tm) ? 'last' : i };\n                                    marker.css({ 'left' : l + 'px', 'top' : t + 'px' }).show();\n                                    marker.removeClass('jstree-above jstree-inside jstree-below').addClass(c);\n                                    data.helper.find('.jstree-icon').first().removeClass('jstree-er').addClass('jstree-ok');\n                                    if (data.event.originalEvent && data.event.originalEvent.dataTransfer) {\n                                        data.event.originalEvent.dataTransfer.dropEffect = is_copy ? 'copy' : 'move';\n                                    }\n                                    laster = {};\n                                    o = true;\n                                    return false;\n                                }\n                            });\n                            if(o === true) { return; }\n                        }\n                    }\n                }\n                $('.jstree-dnd-parent').removeClass('jstree-dnd-parent');\n                lastmv = false;\n                data.helper.find('.jstree-icon').removeClass('jstree-ok').addClass('jstree-er');\n                if (data.event.originalEvent && data.event.originalEvent.dataTransfer) {\n                    //data.event.originalEvent.dataTransfer.dropEffect = 'none';\n                }\n                marker.hide();\n            })\n            .on('dnd_scroll.vakata.jstree', function (e, data) {\n                if(!data || !data.data || !data.data.jstree) { return; }\n                marker.hide();\n                lastmv = false;\n                lastev = false;\n                data.helper.find('.jstree-icon').first().removeClass('jstree-ok').addClass('jstree-er');\n            })\n            .on('dnd_stop.vakata.jstree', function (e, data) {\n                $('.jstree-dnd-parent').removeClass('jstree-dnd-parent');\n                if(opento) { clearTimeout(opento); }\n                if(!data || !data.data || !data.data.jstree) { return; }\n                marker.hide().detach();\n                var i, j, nodes = [];\n                if(lastmv) {\n                    for(i = 0, j = data.data.nodes.length; i < j; i++) {\n                        nodes[i] = data.data.origin ? data.data.origin.get_node(data.data.nodes[i]) : data.data.nodes[i];\n                    }\n                    lastmv.ins[ data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (data.event.metaKey || data.event.ctrlKey))) ? 'copy_node' : 'move_node' ](nodes, lastmv.par, lastmv.pos, false, false, false, data.data.origin);\n                }\n                else {\n                    i = $(data.event.target).closest('.jstree');\n                    if(i.length && laster && laster.error && laster.error === 'check') {\n                        i = i.jstree(true);\n                        if(i) {\n                            i.settings.core.error.call(this, laster);\n                        }\n                    }\n                }\n                lastev = false;\n                lastmv = false;\n            })\n            .on('keyup.jstree keydown.jstree', function (e, data) {\n                data = $.vakata.dnd._get();\n                if(data && data.data && data.data.jstree) {\n                    if (e.type === \"keyup\" && e.which === 27) {\n                        if (opento) { clearTimeout(opento); }\n                        lastmv = false;\n                        laster = false;\n                        lastev = false;\n                        opento = false;\n                        marker.hide().detach();\n                        $.vakata.dnd._clean();\n                    } else {\n                        data.helper.find('.jstree-copy').first()[ data.data.origin && (data.data.origin.settings.dnd.always_copy || (data.data.origin.settings.dnd.copy && (e.metaKey || e.ctrlKey))) ? 'show' : 'hide' ]();\n                        if(lastev) {\n                            lastev.metaKey = e.metaKey;\n                            lastev.ctrlKey = e.ctrlKey;\n                            $.vakata.dnd._trigger('move', lastev);\n                        }\n                    }\n                }\n            });\n    });\n\n    // helpers\n    (function ($) {\n        $.vakata.html = {\n            div : $('<div></div>'),\n            escape : function (str) {\n                return $.vakata.html.div.text(str).html();\n            },\n            strip : function (str) {\n                return $.vakata.html.div.empty().append($.parseHTML(str)).text();\n            }\n        };\n        // private variable\n        var vakata_dnd = {\n            element\t: false,\n            target\t: false,\n            is_down\t: false,\n            is_drag\t: false,\n            helper\t: false,\n            helper_w: 0,\n            data\t: false,\n            init_x\t: 0,\n            init_y\t: 0,\n            scroll_l: 0,\n            scroll_t: 0,\n            scroll_e: false,\n            scroll_i: false,\n            is_touch: false\n        };\n        $.vakata.dnd = {\n            settings : {\n                scroll_speed\t\t: 10,\n                scroll_proximity\t: 20,\n                helper_left\t\t\t: 5,\n                helper_top\t\t\t: 10,\n                threshold\t\t\t: 5,\n                threshold_touch\t\t: 10\n            },\n            _trigger : function (event_name, e, data) {\n                if (data === undefined) {\n                    data = $.vakata.dnd._get();\n                }\n                data.event = e;\n                $(document).triggerHandler(\"dnd_\" + event_name + \".vakata\", data);\n            },\n            _get : function () {\n                return {\n                    \"data\"\t\t: vakata_dnd.data,\n                    \"element\"\t: vakata_dnd.element,\n                    \"helper\"\t: vakata_dnd.helper\n                };\n            },\n            _clean : function () {\n                if(vakata_dnd.helper) { vakata_dnd.helper.remove(); }\n                if(vakata_dnd.scroll_i) { clearInterval(vakata_dnd.scroll_i); vakata_dnd.scroll_i = false; }\n                vakata_dnd = {\n                    element\t: false,\n                    target\t: false,\n                    is_down\t: false,\n                    is_drag\t: false,\n                    helper\t: false,\n                    helper_w: 0,\n                    data\t: false,\n                    init_x\t: 0,\n                    init_y\t: 0,\n                    scroll_l: 0,\n                    scroll_t: 0,\n                    scroll_e: false,\n                    scroll_i: false,\n                    is_touch: false\n                };\n                elm = null;\n                $(document).off(\"mousemove.vakata.jstree touchmove.vakata.jstree\", $.vakata.dnd.drag);\n                $(document).off(\"mouseup.vakata.jstree touchend.vakata.jstree\", $.vakata.dnd.stop);\n            },\n            _scroll : function (init_only) {\n                if(!vakata_dnd.scroll_e || (!vakata_dnd.scroll_l && !vakata_dnd.scroll_t)) {\n                    if(vakata_dnd.scroll_i) { clearInterval(vakata_dnd.scroll_i); vakata_dnd.scroll_i = false; }\n                    return false;\n                }\n                if(!vakata_dnd.scroll_i) {\n                    vakata_dnd.scroll_i = setInterval($.vakata.dnd._scroll, 100);\n                    return false;\n                }\n                if(init_only === true) { return false; }\n\n                var i = vakata_dnd.scroll_e.scrollTop(),\n                    j = vakata_dnd.scroll_e.scrollLeft();\n                vakata_dnd.scroll_e.scrollTop(i + vakata_dnd.scroll_t * $.vakata.dnd.settings.scroll_speed);\n                vakata_dnd.scroll_e.scrollLeft(j + vakata_dnd.scroll_l * $.vakata.dnd.settings.scroll_speed);\n                if(i !== vakata_dnd.scroll_e.scrollTop() || j !== vakata_dnd.scroll_e.scrollLeft()) {\n                    /**\n                     * triggered on the document when a drag causes an element to scroll\n                     * @event\n                     * @plugin dnd\n                     * @name dnd_scroll.vakata\n                     * @param {Mixed} data any data supplied with the call to $.vakata.dnd.start\n                     * @param {DOM} element the DOM element being dragged\n                     * @param {jQuery} helper the helper shown next to the mouse\n                     * @param {jQuery} event the element that is scrolling\n                     */\n                    $.vakata.dnd._trigger(\"scroll\", vakata_dnd.scroll_e);\n                }\n            },\n            start : function (e, data, html) {\n                if(e.type === \"touchstart\" && e.originalEvent && e.originalEvent.changedTouches && e.originalEvent.changedTouches[0]) {\n                    e.pageX = e.originalEvent.changedTouches[0].pageX;\n                    e.pageY = e.originalEvent.changedTouches[0].pageY;\n                    e.target = document.elementFromPoint(e.originalEvent.changedTouches[0].pageX - window.pageXOffset, e.originalEvent.changedTouches[0].pageY - window.pageYOffset);\n                }\n                if(vakata_dnd.is_drag) { $.vakata.dnd.stop({}); }\n                try {\n                    e.currentTarget.unselectable = \"on\";\n                    e.currentTarget.onselectstart = function() { return false; };\n                    if(e.currentTarget.style) {\n                        e.currentTarget.style.touchAction = \"none\";\n                        e.currentTarget.style.msTouchAction = \"none\";\n                        e.currentTarget.style.MozUserSelect = \"none\";\n                    }\n                } catch(ignore) { }\n                vakata_dnd.init_x\t= e.pageX;\n                vakata_dnd.init_y\t= e.pageY;\n                vakata_dnd.data\t\t= data;\n                vakata_dnd.is_down\t= true;\n                vakata_dnd.element\t= e.currentTarget;\n                vakata_dnd.target\t= e.target;\n                vakata_dnd.is_touch\t= e.type === \"touchstart\";\n                if(html !== false) {\n                    vakata_dnd.helper = $(\"<div id='vakata-dnd'></div>\").html(html).css({\n                        \"display\"\t\t: \"block\",\n                        \"margin\"\t\t: \"0\",\n                        \"padding\"\t\t: \"0\",\n                        \"position\"\t\t: \"absolute\",\n                        \"top\"\t\t\t: \"-2000px\",\n                        \"lineHeight\"\t: \"16px\",\n                        \"zIndex\"\t\t: \"10000\"\n                    });\n                }\n                $(document).on(\"mousemove.vakata.jstree touchmove.vakata.jstree\", $.vakata.dnd.drag);\n                $(document).on(\"mouseup.vakata.jstree touchend.vakata.jstree\", $.vakata.dnd.stop);\n                return false;\n            },\n            drag : function (e) {\n                if(e.type === \"touchmove\" && e.originalEvent && e.originalEvent.changedTouches && e.originalEvent.changedTouches[0]) {\n                    e.pageX = e.originalEvent.changedTouches[0].pageX;\n                    e.pageY = e.originalEvent.changedTouches[0].pageY;\n                    e.target = document.elementFromPoint(e.originalEvent.changedTouches[0].pageX - window.pageXOffset, e.originalEvent.changedTouches[0].pageY - window.pageYOffset);\n                }\n                if(!vakata_dnd.is_down) { return; }\n                if(!vakata_dnd.is_drag) {\n                    if(\n                        Math.abs(e.pageX - vakata_dnd.init_x) > (vakata_dnd.is_touch ? $.vakata.dnd.settings.threshold_touch : $.vakata.dnd.settings.threshold) ||\n                        Math.abs(e.pageY - vakata_dnd.init_y) > (vakata_dnd.is_touch ? $.vakata.dnd.settings.threshold_touch : $.vakata.dnd.settings.threshold)\n                    ) {\n                        if(vakata_dnd.helper) {\n                            vakata_dnd.helper.appendTo(document.body);\n                            vakata_dnd.helper_w = vakata_dnd.helper.outerWidth();\n                        }\n                        vakata_dnd.is_drag = true;\n                        $(vakata_dnd.target).one('click.vakata', false);\n                        /**\n                         * triggered on the document when a drag starts\n                         * @event\n                         * @plugin dnd\n                         * @name dnd_start.vakata\n                         * @param {Mixed} data any data supplied with the call to $.vakata.dnd.start\n                         * @param {DOM} element the DOM element being dragged\n                         * @param {jQuery} helper the helper shown next to the mouse\n                         * @param {Object} event the event that caused the start (probably mousemove)\n                         */\n                        $.vakata.dnd._trigger(\"start\", e);\n                    }\n                    else { return; }\n                }\n\n                var d  = false, w  = false,\n                    dh = false, wh = false,\n                    dw = false, ww = false,\n                    dt = false, dl = false,\n                    ht = false, hl = false;\n\n                vakata_dnd.scroll_t = 0;\n                vakata_dnd.scroll_l = 0;\n                vakata_dnd.scroll_e = false;\n                $($(e.target).parentsUntil(\"body\").addBack().get().reverse())\n                    .filter(function () {\n                        return\t(/^auto|scroll$/).test($(this).css(\"overflow\")) &&\n                            (this.scrollHeight > this.offsetHeight || this.scrollWidth > this.offsetWidth);\n                    })\n                    .each(function () {\n                        var t = $(this), o = t.offset();\n                        if(this.scrollHeight > this.offsetHeight) {\n                            if(o.top + t.height() - e.pageY < $.vakata.dnd.settings.scroll_proximity)\t{ vakata_dnd.scroll_t = 1; }\n                            if(e.pageY - o.top < $.vakata.dnd.settings.scroll_proximity)\t\t\t\t{ vakata_dnd.scroll_t = -1; }\n                        }\n                        if(this.scrollWidth > this.offsetWidth) {\n                            if(o.left + t.width() - e.pageX < $.vakata.dnd.settings.scroll_proximity)\t{ vakata_dnd.scroll_l = 1; }\n                            if(e.pageX - o.left < $.vakata.dnd.settings.scroll_proximity)\t\t\t\t{ vakata_dnd.scroll_l = -1; }\n                        }\n                        if(vakata_dnd.scroll_t || vakata_dnd.scroll_l) {\n                            vakata_dnd.scroll_e = $(this);\n                            return false;\n                        }\n                    });\n\n                if(!vakata_dnd.scroll_e) {\n                    d  = $(document); w = $(window);\n                    dh = d.height(); wh = w.height();\n                    dw = d.width(); ww = w.width();\n                    dt = d.scrollTop(); dl = d.scrollLeft();\n                    if(dh > wh && e.pageY - dt < $.vakata.dnd.settings.scroll_proximity)\t\t{ vakata_dnd.scroll_t = -1;  }\n                    if(dh > wh && wh - (e.pageY - dt) < $.vakata.dnd.settings.scroll_proximity)\t{ vakata_dnd.scroll_t = 1; }\n                    if(dw > ww && e.pageX - dl < $.vakata.dnd.settings.scroll_proximity)\t\t{ vakata_dnd.scroll_l = -1; }\n                    if(dw > ww && ww - (e.pageX - dl) < $.vakata.dnd.settings.scroll_proximity)\t{ vakata_dnd.scroll_l = 1; }\n                    if(vakata_dnd.scroll_t || vakata_dnd.scroll_l) {\n                        vakata_dnd.scroll_e = d;\n                    }\n                }\n                if(vakata_dnd.scroll_e) { $.vakata.dnd._scroll(true); }\n\n                if(vakata_dnd.helper) {\n                    ht = parseInt(e.pageY + $.vakata.dnd.settings.helper_top, 10);\n                    hl = parseInt(e.pageX + $.vakata.dnd.settings.helper_left, 10);\n                    if(dh && ht + 25 > dh) { ht = dh - 50; }\n                    if(dw && hl + vakata_dnd.helper_w > dw) { hl = dw - (vakata_dnd.helper_w + 2); }\n                    vakata_dnd.helper.css({\n                        left\t: hl + \"px\",\n                        top\t\t: ht + \"px\"\n                    });\n                }\n                /**\n                 * triggered on the document when a drag is in progress\n                 * @event\n                 * @plugin dnd\n                 * @name dnd_move.vakata\n                 * @param {Mixed} data any data supplied with the call to $.vakata.dnd.start\n                 * @param {DOM} element the DOM element being dragged\n                 * @param {jQuery} helper the helper shown next to the mouse\n                 * @param {Object} event the event that caused this to trigger (most likely mousemove)\n                 */\n                $.vakata.dnd._trigger(\"move\", e);\n                return false;\n            },\n            stop : function (e) {\n                if(e.type === \"touchend\" && e.originalEvent && e.originalEvent.changedTouches && e.originalEvent.changedTouches[0]) {\n                    e.pageX = e.originalEvent.changedTouches[0].pageX;\n                    e.pageY = e.originalEvent.changedTouches[0].pageY;\n                    e.target = document.elementFromPoint(e.originalEvent.changedTouches[0].pageX - window.pageXOffset, e.originalEvent.changedTouches[0].pageY - window.pageYOffset);\n                }\n                if(vakata_dnd.is_drag) {\n                    /**\n                     * triggered on the document when a drag stops (the dragged element is dropped)\n                     * @event\n                     * @plugin dnd\n                     * @name dnd_stop.vakata\n                     * @param {Mixed} data any data supplied with the call to $.vakata.dnd.start\n                     * @param {DOM} element the DOM element being dragged\n                     * @param {jQuery} helper the helper shown next to the mouse\n                     * @param {Object} event the event that caused the stop\n                     */\n                    if (e.target !== vakata_dnd.target) {\n                        $(vakata_dnd.target).off('click.vakata');\n                    }\n                    $.vakata.dnd._trigger(\"stop\", e);\n                }\n                else {\n                    if(e.type === \"touchend\" && e.target === vakata_dnd.target) {\n                        var to = setTimeout(function () { $(e.target).trigger('click'); }, 100);\n                        $(e.target).one('click', function() { if(to) { clearTimeout(to); } });\n                    }\n                }\n                $.vakata.dnd._clean();\n                return false;\n            }\n        };\n    }($));\n\n    // include the dnd plugin by default\n    // $.jstree.defaults.plugins.push(\"dnd\");\n\n\n    /**\n     * ### Massload plugin\n     *\n     * Adds massload functionality to jsTree, so that multiple nodes can be loaded in a single request (only useful with lazy loading).\n     */\n\n    /**\n     * massload configuration\n     *\n     * It is possible to set this to a standard jQuery-like AJAX config.\n     * In addition to the standard jQuery ajax options here you can supply functions for `data` and `url`, the functions will be run in the current instance's scope and a param will be passed indicating which node IDs need to be loaded, the return value of those functions will be used.\n     *\n     * You can also set this to a function, that function will receive the node IDs being loaded as argument and a second param which is a function (callback) which should be called with the result.\n     *\n     * Both the AJAX and the function approach rely on the same return value - an object where the keys are the node IDs, and the value is the children of that node as an array.\n     *\n     *\t{\n     *\t\t\"id1\" : [{ \"text\" : \"Child of ID1\", \"id\" : \"c1\" }, { \"text\" : \"Another child of ID1\", \"id\" : \"c2\" }],\n     *\t\t\"id2\" : [{ \"text\" : \"Child of ID2\", \"id\" : \"c3\" }]\n     *\t}\n     *\n     * @name $.jstree.defaults.massload\n     * @plugin massload\n     */\n    $.jstree.defaults.massload = null;\n    $.jstree.plugins.massload = function (options, parent) {\n        this.init = function (el, options) {\n            this._data.massload = {};\n            parent.init.call(this, el, options);\n        };\n        this._load_nodes = function (nodes, callback, is_callback, force_reload) {\n            var s = this.settings.massload,\n                toLoad = [],\n                m = this._model.data,\n                i, j, dom;\n            if (!is_callback) {\n                for(i = 0, j = nodes.length; i < j; i++) {\n                    if(!m[nodes[i]] || ( (!m[nodes[i]].state.loaded && !m[nodes[i]].state.failed) || force_reload) ) {\n                        toLoad.push(nodes[i]);\n                        dom = this.get_node(nodes[i], true);\n                        if (dom && dom.length) {\n                            dom.addClass(\"jstree-loading\").attr('aria-busy',true);\n                        }\n                    }\n                }\n                this._data.massload = {};\n                if (toLoad.length) {\n                    if($.vakata.is_function(s)) {\n                        return s.call(this, toLoad, function (data) {\n                            var i, j;\n                            if(data) {\n                                for(i in data) {\n                                    if(data.hasOwnProperty(i)) {\n                                        this._data.massload[i] = data[i];\n                                    }\n                                }\n                            }\n                            for(i = 0, j = nodes.length; i < j; i++) {\n                                dom = this.get_node(nodes[i], true);\n                                if (dom && dom.length) {\n                                    dom.removeClass(\"jstree-loading\").attr('aria-busy',false);\n                                }\n                            }\n                            parent._load_nodes.call(this, nodes, callback, is_callback, force_reload);\n                        }.bind(this));\n                    }\n                    if(typeof s === 'object' && s && s.url) {\n                        s = $.extend(true, {}, s);\n                        if($.vakata.is_function(s.url)) {\n                            s.url = s.url.call(this, toLoad);\n                        }\n                        if($.vakata.is_function(s.data)) {\n                            s.data = s.data.call(this, toLoad);\n                        }\n                        return $.ajax(s)\n                            .done(function (data,t,x) {\n                                var i, j;\n                                if(data) {\n                                    for(i in data) {\n                                        if(data.hasOwnProperty(i)) {\n                                            this._data.massload[i] = data[i];\n                                        }\n                                    }\n                                }\n                                for(i = 0, j = nodes.length; i < j; i++) {\n                                    dom = this.get_node(nodes[i], true);\n                                    if (dom && dom.length) {\n                                        dom.removeClass(\"jstree-loading\").attr('aria-busy',false);\n                                    }\n                                }\n                                parent._load_nodes.call(this, nodes, callback, is_callback, force_reload);\n                            }.bind(this))\n                            .fail(function (f) {\n                                parent._load_nodes.call(this, nodes, callback, is_callback, force_reload);\n                            }.bind(this));\n                    }\n                }\n            }\n            return parent._load_nodes.call(this, nodes, callback, is_callback, force_reload);\n        };\n        this._load_node = function (obj, callback) {\n            var data = this._data.massload[obj.id],\n                rslt = null, dom;\n            if(data) {\n                rslt = this[typeof data === 'string' ? '_append_html_data' : '_append_json_data'](\n                    obj,\n                    typeof data === 'string' ? $($.parseHTML(data)).filter(function () { return this.nodeType !== 3; }) : data,\n                    function (status) { callback.call(this, status); }\n                );\n                dom = this.get_node(obj.id, true);\n                if (dom && dom.length) {\n                    dom.removeClass(\"jstree-loading\").attr('aria-busy',false);\n                }\n                delete this._data.massload[obj.id];\n                return rslt;\n            }\n            return parent._load_node.call(this, obj, callback);\n        };\n    };\n\n\n    /**\n     * ### Search plugin\n     *\n     * Adds search functionality to jsTree.\n     */\n\n    /**\n     * stores all defaults for the search plugin\n     * @name $.jstree.defaults.search\n     * @plugin search\n     */\n    $.jstree.defaults.search = {\n        /**\n         * a jQuery-like AJAX config, which jstree uses if a server should be queried for results.\n         *\n         * A `str` (which is the search string) parameter will be added with the request, an optional `inside` parameter will be added if the search is limited to a node id. The expected result is a JSON array with nodes that need to be opened so that matching nodes will be revealed.\n         * Leave this setting as `false` to not query the server. You can also set this to a function, which will be invoked in the instance's scope and receive 3 parameters - the search string, the callback to call with the array of nodes to load, and the optional node ID to limit the search to\n         * @name $.jstree.defaults.search.ajax\n         * @plugin search\n         */\n        ajax : false,\n        /**\n         * Indicates if the search should be fuzzy or not (should `chnd3` match `child node 3`). Default is `false`.\n         * @name $.jstree.defaults.search.fuzzy\n         * @plugin search\n         */\n        fuzzy : false,\n        /**\n         * Indicates if the search should be case sensitive. Default is `false`.\n         * @name $.jstree.defaults.search.case_sensitive\n         * @plugin search\n         */\n        case_sensitive : false,\n        /**\n         * Indicates if the tree should be filtered (by default) to show only matching nodes (keep in mind this can be a heavy on large trees in old browsers).\n         * This setting can be changed at runtime when calling the search method. Default is `false`.\n         * @name $.jstree.defaults.search.show_only_matches\n         * @plugin search\n         */\n        show_only_matches : false,\n        /**\n         * Indicates if the children of matched element are shown (when show_only_matches is true)\n         * This setting can be changed at runtime when calling the search method. Default is `false`.\n         * @name $.jstree.defaults.search.show_only_matches_children\n         * @plugin search\n         */\n        show_only_matches_children : false,\n        /**\n         * Indicates if all nodes opened to reveal the search result, should be closed when the search is cleared or a new search is performed. Default is `true`.\n         * @name $.jstree.defaults.search.close_opened_onclear\n         * @plugin search\n         */\n        close_opened_onclear : true,\n        /**\n         * Indicates if only leaf nodes should be included in search results. Default is `false`.\n         * @name $.jstree.defaults.search.search_leaves_only\n         * @plugin search\n         */\n        search_leaves_only : false,\n        /**\n         * If set to a function it wil be called in the instance's scope with two arguments - search string and node (where node will be every node in the structure, so use with caution).\n         * If the function returns a truthy value the node will be considered a match (it might not be displayed if search_only_leaves is set to true and the node is not a leaf). Default is `false`.\n         * @name $.jstree.defaults.search.search_callback\n         * @plugin search\n         */\n        search_callback : false\n    };\n\n    $.jstree.plugins.search = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n\n            this._data.search.str = \"\";\n            this._data.search.dom = $();\n            this._data.search.res = [];\n            this._data.search.opn = [];\n            this._data.search.som = false;\n            this._data.search.smc = false;\n            this._data.search.hdn = [];\n\n            this.element\n                .on(\"search.jstree\", function (e, data) {\n                    if(this._data.search.som && data.res.length) {\n                        var m = this._model.data, i, j, p = [], k, l;\n                        for(i = 0, j = data.res.length; i < j; i++) {\n                            if(m[data.res[i]] && !m[data.res[i]].state.hidden) {\n                                p.push(data.res[i]);\n                                p = p.concat(m[data.res[i]].parents);\n                                if(this._data.search.smc) {\n                                    for (k = 0, l = m[data.res[i]].children_d.length; k < l; k++) {\n                                        if (m[m[data.res[i]].children_d[k]] && !m[m[data.res[i]].children_d[k]].state.hidden) {\n                                            p.push(m[data.res[i]].children_d[k]);\n                                        }\n                                    }\n                                }\n                            }\n                        }\n                        p = $.vakata.array_remove_item($.vakata.array_unique(p), $.jstree.root);\n                        this._data.search.hdn = this.hide_all(true);\n                        this.show_node(p, true);\n                        this.redraw(true);\n                    }\n                }.bind(this))\n                .on(\"clear_search.jstree\", function (e, data) {\n                    if(this._data.search.som && data.res.length) {\n                        this.show_node(this._data.search.hdn, true);\n                        this.redraw(true);\n                    }\n                }.bind(this));\n        };\n        /**\n         * used to search the tree nodes for a given string\n         * @name search(str [, skip_async])\n         * @param {String} str the search string\n         * @param {Boolean} skip_async if set to true server will not be queried even if configured\n         * @param {Boolean} show_only_matches if set to true only matching nodes will be shown (keep in mind this can be very slow on large trees or old browsers)\n         * @param {mixed} inside an optional node to whose children to limit the search\n         * @param {Boolean} append if set to true the results of this search are appended to the previous search\n         * @plugin search\n         * @trigger search.jstree\n         */\n        this.search = function (str, skip_async, show_only_matches, inside, append, show_only_matches_children) {\n            if(str === false || $.vakata.trim(str.toString()) === \"\") {\n                return this.clear_search();\n            }\n            inside = this.get_node(inside);\n            inside = inside && inside.id ? inside.id : null;\n            str = str.toString();\n            var s = this.settings.search,\n                a = s.ajax ? s.ajax : false,\n                m = this._model.data,\n                f = null,\n                r = [],\n                p = [], i, j;\n            if(this._data.search.res.length && !append) {\n                this.clear_search();\n            }\n            if(show_only_matches === undefined) {\n                show_only_matches = s.show_only_matches;\n            }\n            if(show_only_matches_children === undefined) {\n                show_only_matches_children = s.show_only_matches_children;\n            }\n            if(!skip_async && a !== false) {\n                if($.vakata.is_function(a)) {\n                    return a.call(this, str, function (d) {\n                        if(d && d.d) { d = d.d; }\n                        this._load_nodes(!$.vakata.is_array(d) ? [] : $.vakata.array_unique(d), function () {\n                            this.search(str, true, show_only_matches, inside, append, show_only_matches_children);\n                        });\n                    }.bind(this), inside);\n                }\n                else {\n                    a = $.extend({}, a);\n                    if(!a.data) { a.data = {}; }\n                    a.data.str = str;\n                    if(inside) {\n                        a.data.inside = inside;\n                    }\n                    if (this._data.search.lastRequest) {\n                        this._data.search.lastRequest.abort();\n                    }\n                    this._data.search.lastRequest = $.ajax(a)\n                        .fail(function () {\n                            this._data.core.last_error = { 'error' : 'ajax', 'plugin' : 'search', 'id' : 'search_01', 'reason' : 'Could not load search parents', 'data' : JSON.stringify(a) };\n                            this.settings.core.error.call(this, this._data.core.last_error);\n                        }.bind(this))\n                        .done(function (d) {\n                            if(d && d.d) { d = d.d; }\n                            this._load_nodes(!$.vakata.is_array(d) ? [] : $.vakata.array_unique(d), function () {\n                                this.search(str, true, show_only_matches, inside, append, show_only_matches_children);\n                            });\n                        }.bind(this));\n                    return this._data.search.lastRequest;\n                }\n            }\n            if(!append) {\n                this._data.search.str = str;\n                this._data.search.dom = $();\n                this._data.search.res = [];\n                this._data.search.opn = [];\n                this._data.search.som = show_only_matches;\n                this._data.search.smc = show_only_matches_children;\n            }\n\n            f = new $.vakata.search(str, true, { caseSensitive : s.case_sensitive, fuzzy : s.fuzzy });\n            $.each(m[inside ? inside : $.jstree.root].children_d, function (ii, i) {\n                var v = m[i];\n                if(v.text && !v.state.hidden && (!s.search_leaves_only || (v.state.loaded && v.children.length === 0)) && ( (s.search_callback && s.search_callback.call(this, str, v)) || (!s.search_callback && f.search(v.text).isMatch) ) ) {\n                    r.push(i);\n                    p = p.concat(v.parents);\n                }\n            });\n            if(r.length) {\n                p = $.vakata.array_unique(p);\n                for(i = 0, j = p.length; i < j; i++) {\n                    if(p[i] !== $.jstree.root && m[p[i]] && this.open_node(p[i], null, 0) === true) {\n                        this._data.search.opn.push(p[i]);\n                    }\n                }\n                if(!append) {\n                    this._data.search.dom = $(this.element[0].querySelectorAll('#' + $.map(r, function (v) { return \"0123456789\".indexOf(v[0]) !== -1 ? '\\\\3' + v[0] + ' ' + v.substr(1).replace($.jstree.idregex,'\\\\$&') : v.replace($.jstree.idregex,'\\\\$&'); }).join(', #')));\n                    this._data.search.res = r;\n                }\n                else {\n                    this._data.search.dom = this._data.search.dom.add($(this.element[0].querySelectorAll('#' + $.map(r, function (v) { return \"0123456789\".indexOf(v[0]) !== -1 ? '\\\\3' + v[0] + ' ' + v.substr(1).replace($.jstree.idregex,'\\\\$&') : v.replace($.jstree.idregex,'\\\\$&'); }).join(', #'))));\n                    this._data.search.res = $.vakata.array_unique(this._data.search.res.concat(r));\n                }\n                this._data.search.dom.children(\".jstree-anchor\").addClass('jstree-search');\n            }\n            /**\n             * triggered after search is complete\n             * @event\n             * @name search.jstree\n             * @param {jQuery} nodes a jQuery collection of matching nodes\n             * @param {String} str the search string\n             * @param {Array} res a collection of objects represeing the matching nodes\n             * @plugin search\n             */\n            this.trigger('search', { nodes : this._data.search.dom, str : str, res : this._data.search.res, show_only_matches : show_only_matches });\n        };\n        /**\n         * used to clear the last search (removes classes and shows all nodes if filtering is on)\n         * @name clear_search()\n         * @plugin search\n         * @trigger clear_search.jstree\n         */\n        this.clear_search = function () {\n            if(this.settings.search.close_opened_onclear) {\n                this.close_node(this._data.search.opn, 0);\n            }\n            /**\n             * triggered after search is complete\n             * @event\n             * @name clear_search.jstree\n             * @param {jQuery} nodes a jQuery collection of matching nodes (the result from the last search)\n             * @param {String} str the search string (the last search string)\n             * @param {Array} res a collection of objects represeing the matching nodes (the result from the last search)\n             * @plugin search\n             */\n            this.trigger('clear_search', { 'nodes' : this._data.search.dom, str : this._data.search.str, res : this._data.search.res });\n            if(this._data.search.res.length) {\n                this._data.search.dom = $(this.element[0].querySelectorAll('#' + $.map(this._data.search.res, function (v) {\n                    return \"0123456789\".indexOf(v[0]) !== -1 ? '\\\\3' + v[0] + ' ' + v.substr(1).replace($.jstree.idregex,'\\\\$&') : v.replace($.jstree.idregex,'\\\\$&');\n                }).join(', #')));\n                this._data.search.dom.children(\".jstree-anchor\").removeClass(\"jstree-search\");\n            }\n            this._data.search.str = \"\";\n            this._data.search.res = [];\n            this._data.search.opn = [];\n            this._data.search.dom = $();\n        };\n\n        this.redraw_node = function(obj, deep, callback, force_render) {\n            obj = parent.redraw_node.apply(this, arguments);\n            if(obj) {\n                if($.inArray(obj.id, this._data.search.res) !== -1) {\n                    var i, j, tmp = null;\n                    for(i = 0, j = obj.childNodes.length; i < j; i++) {\n                        if(obj.childNodes[i] && obj.childNodes[i].className && obj.childNodes[i].className.indexOf(\"jstree-anchor\") !== -1) {\n                            tmp = obj.childNodes[i];\n                            break;\n                        }\n                    }\n                    if(tmp) {\n                        tmp.className += ' jstree-search';\n                    }\n                }\n            }\n            return obj;\n        };\n    };\n\n    // helpers\n    (function ($) {\n        // from http://kiro.me/projects/fuse.html\n        $.vakata.search = function(pattern, txt, options) {\n            options = options || {};\n            options = $.extend({}, $.vakata.search.defaults, options);\n            if(options.fuzzy !== false) {\n                options.fuzzy = true;\n            }\n            pattern = options.caseSensitive ? pattern : pattern.toLowerCase();\n            var MATCH_LOCATION\t= options.location,\n                MATCH_DISTANCE\t= options.distance,\n                MATCH_THRESHOLD\t= options.threshold,\n                patternLen = pattern.length,\n                matchmask, pattern_alphabet, match_bitapScore, search;\n            if(patternLen > 32) {\n                options.fuzzy = false;\n            }\n            if(options.fuzzy) {\n                matchmask = 1 << (patternLen - 1);\n                pattern_alphabet = (function () {\n                    var mask = {},\n                        i = 0;\n                    for (i = 0; i < patternLen; i++) {\n                        mask[pattern.charAt(i)] = 0;\n                    }\n                    for (i = 0; i < patternLen; i++) {\n                        mask[pattern.charAt(i)] |= 1 << (patternLen - i - 1);\n                    }\n                    return mask;\n                }());\n                match_bitapScore = function (e, x) {\n                    var accuracy = e / patternLen,\n                        proximity = Math.abs(MATCH_LOCATION - x);\n                    if(!MATCH_DISTANCE) {\n                        return proximity ? 1.0 : accuracy;\n                    }\n                    return accuracy + (proximity / MATCH_DISTANCE);\n                };\n            }\n            search = function (text) {\n                text = options.caseSensitive ? text : text.toLowerCase();\n                if(pattern === text || text.indexOf(pattern) !== -1) {\n                    return {\n                        isMatch: true,\n                        score: 0\n                    };\n                }\n                if(!options.fuzzy) {\n                    return {\n                        isMatch: false,\n                        score: 1\n                    };\n                }\n                var i, j,\n                    textLen = text.length,\n                    scoreThreshold = MATCH_THRESHOLD,\n                    bestLoc = text.indexOf(pattern, MATCH_LOCATION),\n                    binMin, binMid,\n                    binMax = patternLen + textLen,\n                    lastRd, start, finish, rd, charMatch,\n                    score = 1,\n                    locations = [];\n                if (bestLoc !== -1) {\n                    scoreThreshold = Math.min(match_bitapScore(0, bestLoc), scoreThreshold);\n                    bestLoc = text.lastIndexOf(pattern, MATCH_LOCATION + patternLen);\n                    if (bestLoc !== -1) {\n                        scoreThreshold = Math.min(match_bitapScore(0, bestLoc), scoreThreshold);\n                    }\n                }\n                bestLoc = -1;\n                for (i = 0; i < patternLen; i++) {\n                    binMin = 0;\n                    binMid = binMax;\n                    while (binMin < binMid) {\n                        if (match_bitapScore(i, MATCH_LOCATION + binMid) <= scoreThreshold) {\n                            binMin = binMid;\n                        } else {\n                            binMax = binMid;\n                        }\n                        binMid = Math.floor((binMax - binMin) / 2 + binMin);\n                    }\n                    binMax = binMid;\n                    start = Math.max(1, MATCH_LOCATION - binMid + 1);\n                    finish = Math.min(MATCH_LOCATION + binMid, textLen) + patternLen;\n                    rd = new Array(finish + 2);\n                    rd[finish + 1] = (1 << i) - 1;\n                    for (j = finish; j >= start; j--) {\n                        charMatch = pattern_alphabet[text.charAt(j - 1)];\n                        if (i === 0) {\n                            rd[j] = ((rd[j + 1] << 1) | 1) & charMatch;\n                        } else {\n                            rd[j] = ((rd[j + 1] << 1) | 1) & charMatch | (((lastRd[j + 1] | lastRd[j]) << 1) | 1) | lastRd[j + 1];\n                        }\n                        if (rd[j] & matchmask) {\n                            score = match_bitapScore(i, j - 1);\n                            if (score <= scoreThreshold) {\n                                scoreThreshold = score;\n                                bestLoc = j - 1;\n                                locations.push(bestLoc);\n                                if (bestLoc > MATCH_LOCATION) {\n                                    start = Math.max(1, 2 * MATCH_LOCATION - bestLoc);\n                                } else {\n                                    break;\n                                }\n                            }\n                        }\n                    }\n                    if (match_bitapScore(i + 1, MATCH_LOCATION) > scoreThreshold) {\n                        break;\n                    }\n                    lastRd = rd;\n                }\n                return {\n                    isMatch: bestLoc >= 0,\n                    score: score\n                };\n            };\n            return txt === true ? { 'search' : search } : search(txt);\n        };\n        $.vakata.search.defaults = {\n            location : 0,\n            distance : 100,\n            threshold : 0.6,\n            fuzzy : false,\n            caseSensitive : false\n        };\n    }($));\n\n    // include the search plugin by default\n    // $.jstree.defaults.plugins.push(\"search\");\n\n\n    /**\n     * ### Sort plugin\n     *\n     * Automatically sorts all siblings in the tree according to a sorting function.\n     */\n\n    /**\n     * the settings function used to sort the nodes.\n     * It is executed in the tree's context, accepts two nodes as arguments and should return `1` or `-1`.\n     * @name $.jstree.defaults.sort\n     * @plugin sort\n     */\n    $.jstree.defaults.sort = function (a, b) {\n        //return this.get_type(a) === this.get_type(b) ? (this.get_text(a) > this.get_text(b) ? 1 : -1) : this.get_type(a) >= this.get_type(b);\n        return this.get_text(a) > this.get_text(b) ? 1 : -1;\n    };\n    $.jstree.plugins.sort = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n            this.element\n                .on(\"model.jstree\", function (e, data) {\n                    this.sort(data.parent, true);\n                }.bind(this))\n                .on(\"rename_node.jstree create_node.jstree\", function (e, data) {\n                    this.sort(data.parent || data.node.parent, false);\n                    this.redraw_node(data.parent || data.node.parent, true);\n                }.bind(this))\n                .on(\"move_node.jstree copy_node.jstree\", function (e, data) {\n                    this.sort(data.parent, false);\n                    this.redraw_node(data.parent, true);\n                }.bind(this));\n        };\n        /**\n         * used to sort a node's children\n         * @private\n         * @name sort(obj [, deep])\n         * @param  {mixed} obj the node\n         * @param {Boolean} deep if set to `true` nodes are sorted recursively.\n         * @plugin sort\n         * @trigger search.jstree\n         */\n        this.sort = function (obj, deep) {\n            var i, j;\n            obj = this.get_node(obj);\n            if(obj && obj.children && obj.children.length) {\n                obj.children.sort(this.settings.sort.bind(this));\n                if(deep) {\n                    for(i = 0, j = obj.children_d.length; i < j; i++) {\n                        this.sort(obj.children_d[i], false);\n                    }\n                }\n            }\n        };\n    };\n\n    // include the sort plugin by default\n    // $.jstree.defaults.plugins.push(\"sort\");\n\n    /**\n     * ### State plugin\n     *\n     * Saves the state of the tree (selected nodes, opened nodes) on the user's computer using available options (localStorage, cookies, etc)\n     */\n\n    var to = false;\n    /**\n     * stores all defaults for the state plugin\n     * @name $.jstree.defaults.state\n     * @plugin state\n     */\n    $.jstree.defaults.state = {\n        /**\n         * A string for the key to use when saving the current tree (change if using multiple trees in your project). Defaults to `jstree`.\n         * @name $.jstree.defaults.state.key\n         * @plugin state\n         */\n        key\t\t: 'jstree',\n        /**\n         * A space separated list of events that trigger a state save. Defaults to `changed.jstree open_node.jstree close_node.jstree`.\n         * @name $.jstree.defaults.state.events\n         * @plugin state\n         */\n        events\t: 'changed.jstree open_node.jstree close_node.jstree check_node.jstree uncheck_node.jstree',\n        /**\n         * Time in milliseconds after which the state will expire. Defaults to 'false' meaning - no expire.\n         * @name $.jstree.defaults.state.ttl\n         * @plugin state\n         */\n        ttl\t\t: false,\n        /**\n         * A function that will be executed prior to restoring state with one argument - the state object. Can be used to clear unwanted parts of the state.\n         * @name $.jstree.defaults.state.filter\n         * @plugin state\n         */\n        filter\t: false,\n        /**\n         * Should loaded nodes be restored (setting this to true means that it is possible that the whole tree will be loaded for some users - use with caution). Defaults to `false`\n         * @name $.jstree.defaults.state.preserve_loaded\n         * @plugin state\n         */\n        preserve_loaded : false\n    };\n    $.jstree.plugins.state = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n            var bind = function () {\n                this.element.on(this.settings.state.events, function () {\n                    if(to) { clearTimeout(to); }\n                    to = setTimeout(function () { this.save_state(); }.bind(this), 100);\n                }.bind(this));\n                /**\n                 * triggered when the state plugin is finished restoring the state (and immediately after ready if there is no state to restore).\n                 * @event\n                 * @name state_ready.jstree\n                 * @plugin state\n                 */\n                this.trigger('state_ready');\n            }.bind(this);\n            this.element\n                .on(\"ready.jstree\", function (e, data) {\n                    this.element.one(\"restore_state.jstree\", bind);\n                    if(!this.restore_state()) { bind(); }\n                }.bind(this));\n        };\n        /**\n         * save the state\n         * @name save_state()\n         * @plugin state\n         */\n        this.save_state = function () {\n            var tm = this.get_state();\n            if (!this.settings.state.preserve_loaded) {\n                delete tm.core.loaded;\n            }\n            var st = { 'state' : tm, 'ttl' : this.settings.state.ttl, 'sec' : +(new Date()) };\n            $.vakata.storage.set(this.settings.state.key, JSON.stringify(st));\n        };\n        /**\n         * restore the state from the user's computer\n         * @name restore_state()\n         * @plugin state\n         */\n        this.restore_state = function () {\n            var k = $.vakata.storage.get(this.settings.state.key);\n            if(!!k) { try { k = JSON.parse(k); } catch(ex) { return false; } }\n            if(!!k && k.ttl && k.sec && +(new Date()) - k.sec > k.ttl) { return false; }\n            if(!!k && k.state) { k = k.state; }\n            if(!!k && $.vakata.is_function(this.settings.state.filter)) { k = this.settings.state.filter.call(this, k); }\n            if(!!k) {\n                if (!this.settings.state.preserve_loaded) {\n                    delete k.core.loaded;\n                }\n                this.element.one(\"set_state.jstree\", function (e, data) { data.instance.trigger('restore_state', { 'state' : $.extend(true, {}, k) }); });\n                this.set_state(k);\n                return true;\n            }\n            return false;\n        };\n        /**\n         * clear the state on the user's computer\n         * @name clear_state()\n         * @plugin state\n         */\n        this.clear_state = function () {\n            return $.vakata.storage.del(this.settings.state.key);\n        };\n    };\n\n    (function ($, undefined) {\n        $.vakata.storage = {\n            // simply specifying the functions in FF throws an error\n            set : function (key, val) { return window.localStorage.setItem(key, val); },\n            get : function (key) { return window.localStorage.getItem(key); },\n            del : function (key) { return window.localStorage.removeItem(key); }\n        };\n    }($));\n\n    // include the state plugin by default\n    // $.jstree.defaults.plugins.push(\"state\");\n\n    /**\n     * ### Types plugin\n     *\n     * Makes it possible to add predefined types for groups of nodes, which make it possible to easily control nesting rules and icon for each group.\n     */\n\n    /**\n     * An object storing all types as key value pairs, where the key is the type name and the value is an object that could contain following keys (all optional).\n     *\n     * * `max_children` the maximum number of immediate children this node type can have. Do not specify or set to `-1` for unlimited.\n     * * `max_depth` the maximum number of nesting this node type can have. A value of `1` would mean that the node can have children, but no grandchildren. Do not specify or set to `-1` for unlimited.\n     * * `valid_children` an array of node type strings, that nodes of this type can have as children. Do not specify or set to `-1` for no limits.\n     * * `icon` a string - can be a path to an icon or a className, if using an image that is in the current directory use a `./` prefix, otherwise it will be detected as a class. Omit to use the default icon from your theme.\n     * * `li_attr` an object of values which will be used to add HTML attributes on the resulting LI DOM node (merged with the node's own data)\n     * * `a_attr` an object of values which will be used to add HTML attributes on the resulting A DOM node (merged with the node's own data)\n     *\n     * There are two predefined types:\n     *\n     * * `#` represents the root of the tree, for example `max_children` would control the maximum number of root nodes.\n     * * `default` represents the default node - any settings here will be applied to all nodes that do not have a type specified.\n     *\n     * @name $.jstree.defaults.types\n     * @plugin types\n     */\n    $.jstree.defaults.types = {\n        'default' : {}\n    };\n    $.jstree.defaults.types[$.jstree.root] = {};\n\n    $.jstree.plugins.types = function (options, parent) {\n        this.init = function (el, options) {\n            var i, j;\n            if(options && options.types && options.types['default']) {\n                for(i in options.types) {\n                    if(i !== \"default\" && i !== $.jstree.root && options.types.hasOwnProperty(i)) {\n                        for(j in options.types['default']) {\n                            if(options.types['default'].hasOwnProperty(j) && options.types[i][j] === undefined) {\n                                options.types[i][j] = options.types['default'][j];\n                            }\n                        }\n                    }\n                }\n            }\n            parent.init.call(this, el, options);\n            this._model.data[$.jstree.root].type = $.jstree.root;\n        };\n        this.refresh = function (skip_loading, forget_state) {\n            parent.refresh.call(this, skip_loading, forget_state);\n            this._model.data[$.jstree.root].type = $.jstree.root;\n        };\n        this.bind = function () {\n            this.element\n                .on('model.jstree', function (e, data) {\n                    var m = this._model.data,\n                        dpc = data.nodes,\n                        t = this.settings.types,\n                        i, j, c = 'default', k;\n                    for(i = 0, j = dpc.length; i < j; i++) {\n                        c = 'default';\n                        if(m[dpc[i]].original && m[dpc[i]].original.type && t[m[dpc[i]].original.type]) {\n                            c = m[dpc[i]].original.type;\n                        }\n                        if(m[dpc[i]].data && m[dpc[i]].data.jstree && m[dpc[i]].data.jstree.type && t[m[dpc[i]].data.jstree.type]) {\n                            c = m[dpc[i]].data.jstree.type;\n                        }\n                        m[dpc[i]].type = c;\n                        if(m[dpc[i]].icon === true && t[c].icon !== undefined) {\n                            m[dpc[i]].icon = t[c].icon;\n                        }\n                        if(t[c].li_attr !== undefined && typeof t[c].li_attr === 'object') {\n                            for (k in t[c].li_attr) {\n                                if (t[c].li_attr.hasOwnProperty(k)) {\n                                    if (k === 'id') {\n                                        continue;\n                                    }\n                                    else if (m[dpc[i]].li_attr[k] === undefined) {\n                                        m[dpc[i]].li_attr[k] = t[c].li_attr[k];\n                                    }\n                                    else if (k === 'class') {\n                                        m[dpc[i]].li_attr['class'] = t[c].li_attr['class'] + ' ' + m[dpc[i]].li_attr['class'];\n                                    }\n                                }\n                            }\n                        }\n                        if(t[c].a_attr !== undefined && typeof t[c].a_attr === 'object') {\n                            for (k in t[c].a_attr) {\n                                if (t[c].a_attr.hasOwnProperty(k)) {\n                                    if (k === 'id') {\n                                        continue;\n                                    }\n                                    else if (m[dpc[i]].a_attr[k] === undefined) {\n                                        m[dpc[i]].a_attr[k] = t[c].a_attr[k];\n                                    }\n                                    else if (k === 'href' && m[dpc[i]].a_attr[k] === '#') {\n                                        m[dpc[i]].a_attr['href'] = t[c].a_attr['href'];\n                                    }\n                                    else if (k === 'class') {\n                                        m[dpc[i]].a_attr['class'] = t[c].a_attr['class'] + ' ' + m[dpc[i]].a_attr['class'];\n                                    }\n                                }\n                            }\n                        }\n                    }\n                    m[$.jstree.root].type = $.jstree.root;\n                }.bind(this));\n            parent.bind.call(this);\n        };\n        this.get_json = function (obj, options, flat) {\n            var i, j,\n                m = this._model.data,\n                opt = options ? $.extend(true, {}, options, {no_id:false}) : {},\n                tmp = parent.get_json.call(this, obj, opt, flat);\n            if(tmp === false) { return false; }\n            if($.vakata.is_array(tmp)) {\n                for(i = 0, j = tmp.length; i < j; i++) {\n                    tmp[i].type = tmp[i].id && m[tmp[i].id] && m[tmp[i].id].type ? m[tmp[i].id].type : \"default\";\n                    if(options && options.no_id) {\n                        delete tmp[i].id;\n                        if(tmp[i].li_attr && tmp[i].li_attr.id) {\n                            delete tmp[i].li_attr.id;\n                        }\n                        if(tmp[i].a_attr && tmp[i].a_attr.id) {\n                            delete tmp[i].a_attr.id;\n                        }\n                    }\n                }\n            }\n            else {\n                tmp.type = tmp.id && m[tmp.id] && m[tmp.id].type ? m[tmp.id].type : \"default\";\n                if(options && options.no_id) {\n                    tmp = this._delete_ids(tmp);\n                }\n            }\n            return tmp;\n        };\n        this._delete_ids = function (tmp) {\n            if($.vakata.is_array(tmp)) {\n                for(var i = 0, j = tmp.length; i < j; i++) {\n                    tmp[i] = this._delete_ids(tmp[i]);\n                }\n                return tmp;\n            }\n            delete tmp.id;\n            if(tmp.li_attr && tmp.li_attr.id) {\n                delete tmp.li_attr.id;\n            }\n            if(tmp.a_attr && tmp.a_attr.id) {\n                delete tmp.a_attr.id;\n            }\n            if(tmp.children && $.vakata.is_array(tmp.children)) {\n                tmp.children = this._delete_ids(tmp.children);\n            }\n            return tmp;\n        };\n        this.check = function (chk, obj, par, pos, more) {\n            if(parent.check.call(this, chk, obj, par, pos, more) === false) { return false; }\n            obj = obj && obj.id ? obj : this.get_node(obj);\n            par = par && par.id ? par : this.get_node(par);\n            var m = obj && obj.id ? (more && more.origin ? more.origin : $.jstree.reference(obj.id)) : null, tmp, d, i, j;\n            m = m && m._model && m._model.data ? m._model.data : null;\n            switch(chk) {\n                case \"create_node\":\n                case \"move_node\":\n                case \"copy_node\":\n                    if(chk !== 'move_node' || $.inArray(obj.id, par.children) === -1) {\n                        tmp = this.get_rules(par);\n                        if(tmp.max_children !== undefined && tmp.max_children !== -1 && tmp.max_children === par.children.length) {\n                            this._data.core.last_error = { 'error' : 'check', 'plugin' : 'types', 'id' : 'types_01', 'reason' : 'max_children prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                            return false;\n                        }\n                        if(tmp.valid_children !== undefined && tmp.valid_children !== -1 && $.inArray((obj.type || 'default'), tmp.valid_children) === -1) {\n                            this._data.core.last_error = { 'error' : 'check', 'plugin' : 'types', 'id' : 'types_02', 'reason' : 'valid_children prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                            return false;\n                        }\n                        if(m && obj.children_d && obj.parents) {\n                            d = 0;\n                            for(i = 0, j = obj.children_d.length; i < j; i++) {\n                                d = Math.max(d, m[obj.children_d[i]].parents.length);\n                            }\n                            d = d - obj.parents.length + 1;\n                        }\n                        if(d <= 0 || d === undefined) { d = 1; }\n                        do {\n                            if(tmp.max_depth !== undefined && tmp.max_depth !== -1 && tmp.max_depth < d) {\n                                this._data.core.last_error = { 'error' : 'check', 'plugin' : 'types', 'id' : 'types_03', 'reason' : 'max_depth prevents function: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                                return false;\n                            }\n                            par = this.get_node(par.parent);\n                            tmp = this.get_rules(par);\n                            d++;\n                        } while(par);\n                    }\n                    break;\n            }\n            return true;\n        };\n        /**\n         * used to retrieve the type settings object for a node\n         * @name get_rules(obj)\n         * @param {mixed} obj the node to find the rules for\n         * @return {Object}\n         * @plugin types\n         */\n        this.get_rules = function (obj) {\n            obj = this.get_node(obj);\n            if(!obj) { return false; }\n            var tmp = this.get_type(obj, true);\n            if(tmp.max_depth === undefined) { tmp.max_depth = -1; }\n            if(tmp.max_children === undefined) { tmp.max_children = -1; }\n            if(tmp.valid_children === undefined) { tmp.valid_children = -1; }\n            return tmp;\n        };\n        /**\n         * used to retrieve the type string or settings object for a node\n         * @name get_type(obj [, rules])\n         * @param {mixed} obj the node to find the rules for\n         * @param {Boolean} rules if set to `true` instead of a string the settings object will be returned\n         * @return {String|Object}\n         * @plugin types\n         */\n        this.get_type = function (obj, rules) {\n            obj = this.get_node(obj);\n            return (!obj) ? false : ( rules ? $.extend({ 'type' : obj.type }, this.settings.types[obj.type]) : obj.type);\n        };\n        /**\n         * used to change a node's type\n         * @name set_type(obj, type)\n         * @param {mixed} obj the node to change\n         * @param {String} type the new type\n         * @plugin types\n         */\n        this.set_type = function (obj, type) {\n            var m = this._model.data, t, t1, t2, old_type, old_icon, k, d, a;\n            if($.vakata.is_array(obj)) {\n                obj = obj.slice();\n                for(t1 = 0, t2 = obj.length; t1 < t2; t1++) {\n                    this.set_type(obj[t1], type);\n                }\n                return true;\n            }\n            t = this.settings.types;\n            obj = this.get_node(obj);\n            if(!t[type] || !obj) { return false; }\n            d = this.get_node(obj, true);\n            if (d && d.length) {\n                a = d.children('.jstree-anchor');\n            }\n            old_type = obj.type;\n            old_icon = this.get_icon(obj);\n            obj.type = type;\n            if(old_icon === true || !t[old_type] || (t[old_type].icon !== undefined && old_icon === t[old_type].icon)) {\n                this.set_icon(obj, t[type].icon !== undefined ? t[type].icon : true);\n            }\n\n            // remove old type props\n            if(t[old_type] && t[old_type].li_attr !== undefined && typeof t[old_type].li_attr === 'object') {\n                for (k in t[old_type].li_attr) {\n                    if (t[old_type].li_attr.hasOwnProperty(k)) {\n                        if (k === 'id') {\n                            continue;\n                        }\n                        else if (k === 'class') {\n                            m[obj.id].li_attr['class'] = (m[obj.id].li_attr['class'] || '').replace(t[old_type].li_attr[k], '');\n                            if (d) { d.removeClass(t[old_type].li_attr[k]); }\n                        }\n                        else if (m[obj.id].li_attr[k] === t[old_type].li_attr[k]) {\n                            m[obj.id].li_attr[k] = null;\n                            if (d) { d.removeAttr(k); }\n                        }\n                    }\n                }\n            }\n            if(t[old_type] && t[old_type].a_attr !== undefined && typeof t[old_type].a_attr === 'object') {\n                for (k in t[old_type].a_attr) {\n                    if (t[old_type].a_attr.hasOwnProperty(k)) {\n                        if (k === 'id') {\n                            continue;\n                        }\n                        else if (k === 'class') {\n                            m[obj.id].a_attr['class'] = (m[obj.id].a_attr['class'] || '').replace(t[old_type].a_attr[k], '');\n                            if (a) { a.removeClass(t[old_type].a_attr[k]); }\n                        }\n                        else if (m[obj.id].a_attr[k] === t[old_type].a_attr[k]) {\n                            if (k === 'href') {\n                                m[obj.id].a_attr[k] = '#';\n                                if (a) { a.attr('href', '#'); }\n                            }\n                            else {\n                                delete m[obj.id].a_attr[k];\n                                if (a) { a.removeAttr(k); }\n                            }\n                        }\n                    }\n                }\n            }\n\n            // add new props\n            if(t[type].li_attr !== undefined && typeof t[type].li_attr === 'object') {\n                for (k in t[type].li_attr) {\n                    if (t[type].li_attr.hasOwnProperty(k)) {\n                        if (k === 'id') {\n                            continue;\n                        }\n                        else if (m[obj.id].li_attr[k] === undefined) {\n                            m[obj.id].li_attr[k] = t[type].li_attr[k];\n                            if (d) {\n                                if (k === 'class') {\n                                    d.addClass(t[type].li_attr[k]);\n                                }\n                                else {\n                                    d.attr(k, t[type].li_attr[k]);\n                                }\n                            }\n                        }\n                        else if (k === 'class') {\n                            m[obj.id].li_attr['class'] = t[type].li_attr[k] + ' ' + m[obj.id].li_attr['class'];\n                            if (d) { d.addClass(t[type].li_attr[k]); }\n                        }\n                    }\n                }\n            }\n            if(t[type].a_attr !== undefined && typeof t[type].a_attr === 'object') {\n                for (k in t[type].a_attr) {\n                    if (t[type].a_attr.hasOwnProperty(k)) {\n                        if (k === 'id') {\n                            continue;\n                        }\n                        else if (m[obj.id].a_attr[k] === undefined) {\n                            m[obj.id].a_attr[k] = t[type].a_attr[k];\n                            if (a) {\n                                if (k === 'class') {\n                                    a.addClass(t[type].a_attr[k]);\n                                }\n                                else {\n                                    a.attr(k, t[type].a_attr[k]);\n                                }\n                            }\n                        }\n                        else if (k === 'href' && m[obj.id].a_attr[k] === '#') {\n                            m[obj.id].a_attr['href'] = t[type].a_attr['href'];\n                            if (a) { a.attr('href', t[type].a_attr['href']); }\n                        }\n                        else if (k === 'class') {\n                            m[obj.id].a_attr['class'] = t[type].a_attr['class'] + ' ' + m[obj.id].a_attr['class'];\n                            if (a) { a.addClass(t[type].a_attr[k]); }\n                        }\n                    }\n                }\n            }\n\n            return true;\n        };\n    };\n    // include the types plugin by default\n    // $.jstree.defaults.plugins.push(\"types\");\n\n\n    /**\n     * ### Unique plugin\n     *\n     * Enforces that no nodes with the same name can coexist as siblings.\n     */\n\n    /**\n     * stores all defaults for the unique plugin\n     * @name $.jstree.defaults.unique\n     * @plugin unique\n     */\n    $.jstree.defaults.unique = {\n        /**\n         * Indicates if the comparison should be case sensitive. Default is `false`.\n         * @name $.jstree.defaults.unique.case_sensitive\n         * @plugin unique\n         */\n        case_sensitive : false,\n        /**\n         * Indicates if white space should be trimmed before the comparison. Default is `false`.\n         * @name $.jstree.defaults.unique.trim_whitespace\n         * @plugin unique\n         */\n        trim_whitespace : false,\n        /**\n         * A callback executed in the instance's scope when a new node is created and the name is already taken, the two arguments are the conflicting name and the counter. The default will produce results like `New node (2)`.\n         * @name $.jstree.defaults.unique.duplicate\n         * @plugin unique\n         */\n        duplicate : function (name, counter) {\n            return name + ' (' + counter + ')';\n        }\n    };\n\n    $.jstree.plugins.unique = function (options, parent) {\n        this.check = function (chk, obj, par, pos, more) {\n            if(parent.check.call(this, chk, obj, par, pos, more) === false) { return false; }\n            obj = obj && obj.id ? obj : this.get_node(obj);\n            par = par && par.id ? par : this.get_node(par);\n            if(!par || !par.children) { return true; }\n            var n = chk === \"rename_node\" ? pos : obj.text,\n                c = [],\n                s = this.settings.unique.case_sensitive,\n                w = this.settings.unique.trim_whitespace,\n                m = this._model.data, i, j, t;\n            for(i = 0, j = par.children.length; i < j; i++) {\n                t = m[par.children[i]].text;\n                if (!s) {\n                    t = t.toLowerCase();\n                }\n                if (w) {\n                    t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                }\n                c.push(t);\n            }\n            if(!s) { n = n.toLowerCase(); }\n            if (w) { n = n.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, ''); }\n            switch(chk) {\n                case \"delete_node\":\n                    return true;\n                case \"rename_node\":\n                    t = obj.text || '';\n                    if (!s) {\n                        t = t.toLowerCase();\n                    }\n                    if (w) {\n                        t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                    }\n                    i = ($.inArray(n, c) === -1 || (obj.text && t === n));\n                    if(!i) {\n                        this._data.core.last_error = { 'error' : 'check', 'plugin' : 'unique', 'id' : 'unique_01', 'reason' : 'Child with name ' + n + ' already exists. Preventing: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    }\n                    return i;\n                case \"create_node\":\n                    i = ($.inArray(n, c) === -1);\n                    if(!i) {\n                        this._data.core.last_error = { 'error' : 'check', 'plugin' : 'unique', 'id' : 'unique_04', 'reason' : 'Child with name ' + n + ' already exists. Preventing: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    }\n                    return i;\n                case \"copy_node\":\n                    i = ($.inArray(n, c) === -1);\n                    if(!i) {\n                        this._data.core.last_error = { 'error' : 'check', 'plugin' : 'unique', 'id' : 'unique_02', 'reason' : 'Child with name ' + n + ' already exists. Preventing: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    }\n                    return i;\n                case \"move_node\":\n                    i = ( (obj.parent === par.id && (!more || !more.is_multi)) || $.inArray(n, c) === -1);\n                    if(!i) {\n                        this._data.core.last_error = { 'error' : 'check', 'plugin' : 'unique', 'id' : 'unique_03', 'reason' : 'Child with name ' + n + ' already exists. Preventing: ' + chk, 'data' : JSON.stringify({ 'chk' : chk, 'pos' : pos, 'obj' : obj && obj.id ? obj.id : false, 'par' : par && par.id ? par.id : false }) };\n                    }\n                    return i;\n            }\n            return true;\n        };\n        this.create_node = function (par, node, pos, callback, is_loaded) {\n            if(!node || node.text === undefined) {\n                if(par === null) {\n                    par = $.jstree.root;\n                }\n                par = this.get_node(par);\n                if(!par) {\n                    return parent.create_node.call(this, par, node, pos, callback, is_loaded);\n                }\n                pos = pos === undefined ? \"last\" : pos;\n                if(!pos.toString().match(/^(before|after)$/) && !is_loaded && !this.is_loaded(par)) {\n                    return parent.create_node.call(this, par, node, pos, callback, is_loaded);\n                }\n                if(!node) { node = {}; }\n                var tmp, n, dpc, i, j, m = this._model.data, s = this.settings.unique.case_sensitive, w = this.settings.unique.trim_whitespace, cb = this.settings.unique.duplicate, t;\n                n = tmp = this.get_string('New node');\n                dpc = [];\n                for(i = 0, j = par.children.length; i < j; i++) {\n                    t = m[par.children[i]].text;\n                    if (!s) {\n                        t = t.toLowerCase();\n                    }\n                    if (w) {\n                        t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                    }\n                    dpc.push(t);\n                }\n                i = 1;\n                t = n;\n                if (!s) {\n                    t = t.toLowerCase();\n                }\n                if (w) {\n                    t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                }\n                while($.inArray(t, dpc) !== -1) {\n                    n = cb.call(this, tmp, (++i)).toString();\n                    t = n;\n                    if (!s) {\n                        t = t.toLowerCase();\n                    }\n                    if (w) {\n                        t = t.replace(/^[\\s\\uFEFF\\xA0]+|[\\s\\uFEFF\\xA0]+$/g, '');\n                    }\n                }\n                node.text = n;\n            }\n            return parent.create_node.call(this, par, node, pos, callback, is_loaded);\n        };\n    };\n\n    // include the unique plugin by default\n    // $.jstree.defaults.plugins.push(\"unique\");\n\n\n    /**\n     * ### Wholerow plugin\n     *\n     * Makes each node appear block level. Making selection easier. May cause slow down for large trees in old browsers.\n     */\n\n    var div = document.createElement('DIV');\n    div.setAttribute('unselectable','on');\n    div.setAttribute('role','presentation');\n    div.className = 'jstree-wholerow';\n    div.innerHTML = '&#160;';\n    $.jstree.plugins.wholerow = function (options, parent) {\n        this.bind = function () {\n            parent.bind.call(this);\n\n            this.element\n                .on('ready.jstree set_state.jstree', function () {\n                    this.hide_dots();\n                }.bind(this))\n                .on(\"init.jstree loading.jstree ready.jstree\", function () {\n                    //div.style.height = this._data.core.li_height + 'px';\n                    this.get_container_ul().addClass('jstree-wholerow-ul');\n                }.bind(this))\n                .on(\"deselect_all.jstree\", function (e, data) {\n                    this.element.find('.jstree-wholerow-clicked').removeClass('jstree-wholerow-clicked');\n                }.bind(this))\n                .on(\"changed.jstree\", function (e, data) {\n                    this.element.find('.jstree-wholerow-clicked').removeClass('jstree-wholerow-clicked');\n                    var tmp = false, i, j;\n                    for(i = 0, j = data.selected.length; i < j; i++) {\n                        tmp = this.get_node(data.selected[i], true);\n                        if(tmp && tmp.length) {\n                            tmp.children('.jstree-wholerow').addClass('jstree-wholerow-clicked');\n                        }\n                    }\n                }.bind(this))\n                .on(\"open_node.jstree\", function (e, data) {\n                    this.get_node(data.node, true).find('.jstree-clicked').parent().children('.jstree-wholerow').addClass('jstree-wholerow-clicked');\n                }.bind(this))\n                .on(\"hover_node.jstree dehover_node.jstree\", function (e, data) {\n                    if(e.type === \"hover_node\" && this.is_disabled(data.node)) { return; }\n                    this.get_node(data.node, true).children('.jstree-wholerow')[e.type === \"hover_node\"?\"addClass\":\"removeClass\"]('jstree-wholerow-hovered');\n                }.bind(this))\n                .on(\"contextmenu.jstree\", \".jstree-wholerow\", function (e) {\n                    if (this._data.contextmenu) {\n                        e.preventDefault();\n                        var tmp = $.Event('contextmenu', { metaKey : e.metaKey, ctrlKey : e.ctrlKey, altKey : e.altKey, shiftKey : e.shiftKey, pageX : e.pageX, pageY : e.pageY });\n                        $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\").first().trigger(tmp);\n                    }\n                }.bind(this))\n                /*!\n\t\t\t\t.on(\"mousedown.jstree touchstart.jstree\", \".jstree-wholerow\", function (e) {\n\t\t\t\t\t\tif(e.target === e.currentTarget) {\n\t\t\t\t\t\t\tvar a = $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\");\n\t\t\t\t\t\t\te.target = a[0];\n\t\t\t\t\t\t\ta.trigger(e);\n\t\t\t\t\t\t}\n\t\t\t\t\t})\n\t\t\t\t*/\n                .on(\"click.jstree\", \".jstree-wholerow\", function (e) {\n                    e.stopImmediatePropagation();\n                    var tmp = $.Event('click', { metaKey : e.metaKey, ctrlKey : e.ctrlKey, altKey : e.altKey, shiftKey : e.shiftKey });\n                    $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\").first().trigger(tmp).trigger('focus');\n                })\n                .on(\"dblclick.jstree\", \".jstree-wholerow\", function (e) {\n                    e.stopImmediatePropagation();\n                    var tmp = $.Event('dblclick', { metaKey : e.metaKey, ctrlKey : e.ctrlKey, altKey : e.altKey, shiftKey : e.shiftKey });\n                    $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\").first().trigger(tmp).trigger('focus');\n                })\n                .on(\"click.jstree\", \".jstree-leaf > .jstree-ocl\", function (e) {\n                    e.stopImmediatePropagation();\n                    var tmp = $.Event('click', { metaKey : e.metaKey, ctrlKey : e.ctrlKey, altKey : e.altKey, shiftKey : e.shiftKey });\n                    $(e.currentTarget).closest(\".jstree-node\").children(\".jstree-anchor\").first().trigger(tmp).trigger('focus');\n                }.bind(this))\n                .on(\"mouseover.jstree\", \".jstree-wholerow, .jstree-icon\", function (e) {\n                    e.stopImmediatePropagation();\n                    if(!this.is_disabled(e.currentTarget)) {\n                        this.hover_node(e.currentTarget);\n                    }\n                    return false;\n                }.bind(this))\n                .on(\"mouseleave.jstree\", \".jstree-node\", function (e) {\n                    this.dehover_node(e.currentTarget);\n                }.bind(this));\n        };\n        this.teardown = function () {\n            if(this.settings.wholerow) {\n                this.element.find(\".jstree-wholerow\").remove();\n            }\n            parent.teardown.call(this);\n        };\n        this.redraw_node = function(obj, deep, callback, force_render) {\n            obj = parent.redraw_node.apply(this, arguments);\n            if(obj) {\n                var tmp = div.cloneNode(true);\n                //tmp.style.height = this._data.core.li_height + 'px';\n                if($.inArray(obj.id, this._data.core.selected) !== -1) { tmp.className += ' jstree-wholerow-clicked'; }\n                if(this._data.core.focused && this._data.core.focused === obj.id) { tmp.className += ' jstree-wholerow-hovered'; }\n                obj.insertBefore(tmp, obj.childNodes[0]);\n            }\n            return obj;\n        };\n    };\n    // include the wholerow plugin by default\n    // $.jstree.defaults.plugins.push(\"wholerow\");\n    if(window.customElements && Object && Object.create) {\n        var proto = Object.create(HTMLElement.prototype);\n        proto.createdCallback = function () {\n            var c = { core : {}, plugins : [] }, i;\n            for(i in $.jstree.plugins) {\n                if($.jstree.plugins.hasOwnProperty(i) && this.attributes[i]) {\n                    c.plugins.push(i);\n                    if(this.getAttribute(i) && JSON.parse(this.getAttribute(i))) {\n                        c[i] = JSON.parse(this.getAttribute(i));\n                    }\n                }\n            }\n            for(i in $.jstree.defaults.core) {\n                if($.jstree.defaults.core.hasOwnProperty(i) && this.attributes[i]) {\n                    c.core[i] = JSON.parse(this.getAttribute(i)) || this.getAttribute(i);\n                }\n            }\n            $(this).jstree(c);\n        };\n        // proto.attributeChangedCallback = function (name, previous, value) { };\n        try {\n            window.customElements.define(\"vakata-jstree\", function() {}, { prototype: proto });\n        } catch (ignore) { }\n    }\n\n}));\n","jquery/spectrum/spectrum.js":"// Spectrum Colorpicker v1.8.1\n// https://github.com/bgrins/spectrum\n// Author: Brian Grinstead\n// License: MIT\n\n(function (factory) {\n    \"use strict\";\n\n    if (typeof define === 'function' && define.amd) { // AMD\n        define(['jquery'], factory);\n    }\n    else if (typeof exports == \"object\" && typeof module == \"object\") { // CommonJS\n        module.exports = factory(require('jquery'));\n    }\n    else { // Browser\n        factory(jQuery);\n    }\n})(function($, undefined) {\n    \"use strict\";\n\n    var defaultOpts = {\n\n            // Callbacks\n            beforeShow: noop,\n            move: noop,\n            change: noop,\n            show: noop,\n            hide: noop,\n\n            // Options\n            color: false,\n            flat: false,\n            showInput: false,\n            allowEmpty: false,\n            showButtons: true,\n            clickoutFiresChange: true,\n            showInitial: false,\n            showPalette: false,\n            showPaletteOnly: false,\n            hideAfterPaletteSelect: false,\n            togglePaletteOnly: false,\n            showSelectionPalette: true,\n            localStorageKey: false,\n            appendTo: \"body\",\n            maxSelectionSize: 7,\n            cancelText: \"cancel\",\n            chooseText: \"choose\",\n            togglePaletteMoreText: \"more\",\n            togglePaletteLessText: \"less\",\n            clearText: \"Clear Color Selection\",\n            noColorSelectedText: \"No Color Selected\",\n            preferredFormat: false,\n            className: \"\", // Deprecated - use containerClassName and replacerClassName instead.\n            containerClassName: \"\",\n            replacerClassName: \"\",\n            showAlpha: false,\n            theme: \"sp-light\",\n            palette: [[\"#ffffff\", \"#000000\", \"#ff0000\", \"#ff8000\", \"#ffff00\", \"#008000\", \"#0000ff\", \"#4b0082\", \"#9400d3\"]],\n            selectionPalette: [],\n            disabled: false,\n            offset: null\n        },\n        spectrums = [],\n        IE = !!/msie/i.exec( window.navigator.userAgent ),\n        rgbaSupport = (function() {\n            function contains( str, substr ) {\n                return !!~('' + str).indexOf(substr);\n            }\n\n            var elem = document.createElement('div');\n            var style = elem.style;\n            style.cssText = 'background-color:rgba(0,0,0,.5)';\n            return contains(style.backgroundColor, 'rgba') || contains(style.backgroundColor, 'hsla');\n        })(),\n        replaceInput = [\n            \"<div class='sp-replacer'>\",\n            \"<div class='sp-preview'><div class='sp-preview-inner'></div></div>\",\n            \"<div class='sp-dd'>&#9660;</div>\",\n            \"</div>\"\n        ].join(''),\n        markup = (function () {\n\n            // IE does not support gradients with multiple stops, so we need to simulate\n            //  that for the rainbow slider with 8 divs that each have a single gradient\n            var gradientFix = \"\";\n            if (IE) {\n                for (var i = 1; i <= 6; i++) {\n                    gradientFix += \"<div class='sp-\" + i + \"'></div>\";\n                }\n            }\n\n            return [\n                \"<div class='sp-container sp-hidden'>\",\n                \"<div class='sp-palette-container'>\",\n                \"<div class='sp-palette sp-thumb sp-cf'></div>\",\n                \"<div class='sp-palette-button-container sp-cf'>\",\n                \"<button type='button' class='sp-palette-toggle'></button>\",\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-picker-container'>\",\n                \"<div class='sp-top sp-cf'>\",\n                \"<div class='sp-fill'></div>\",\n                \"<div class='sp-top-inner'>\",\n                \"<div class='sp-color'>\",\n                \"<div class='sp-sat'>\",\n                \"<div class='sp-val'>\",\n                \"<div class='sp-dragger'></div>\",\n                \"</div>\",\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-clear sp-clear-display'>\",\n                \"</div>\",\n                \"<div class='sp-hue'>\",\n                \"<div class='sp-slider'></div>\",\n                gradientFix,\n                \"</div>\",\n                \"</div>\",\n                \"<div class='sp-alpha'><div class='sp-alpha-inner'><div class='sp-alpha-handle'></div></div></div>\",\n                \"</div>\",\n                \"<div class='sp-input-container sp-cf'>\",\n                \"<input class='sp-input' type='text' spellcheck='false'  />\",\n                \"</div>\",\n                \"<div class='sp-initial sp-thumb sp-cf'></div>\",\n                \"<div class='sp-button-container sp-cf'>\",\n                \"<a class='sp-cancel' href='#'></a>\",\n                \"<button type='button' class='sp-choose'></button>\",\n                \"</div>\",\n                \"</div>\",\n                \"</div>\"\n            ].join(\"\");\n        })();\n\n    function paletteTemplate (p, color, className, opts) {\n        var html = [];\n        for (var i = 0; i < p.length; i++) {\n            var current = p[i];\n            if(current) {\n                var tiny = tinycolor(current);\n                var c = tiny.toHsl().l < 0.5 ? \"sp-thumb-el sp-thumb-dark\" : \"sp-thumb-el sp-thumb-light\";\n                c += (tinycolor.equals(color, current)) ? \" sp-thumb-active\" : \"\";\n                var formattedString = tiny.toString(opts.preferredFormat || \"rgb\");\n                var swatchStyle = rgbaSupport ? (\"background-color:\" + tiny.toRgbString()) : \"filter:\" + tiny.toFilter();\n                html.push('<span title=\"' + formattedString + '\" data-color=\"' + tiny.toRgbString() + '\" class=\"' + c + '\"><span class=\"sp-thumb-inner\" style=\"' + swatchStyle + ';\"></span></span>');\n            } else {\n                var cls = 'sp-clear-display';\n                html.push($('<div />')\n                    .append($('<span data-color=\"\" style=\"background-color:transparent;\" class=\"' + cls + '\"></span>')\n                        .attr('title', opts.noColorSelectedText)\n                    )\n                    .html()\n                );\n            }\n        }\n        return \"<div class='sp-cf \" + className + \"'>\" + html.join('') + \"</div>\";\n    }\n\n    function hideAll() {\n        for (var i = 0; i < spectrums.length; i++) {\n            if (spectrums[i]) {\n                spectrums[i].hide();\n            }\n        }\n    }\n\n    function instanceOptions(o, callbackContext) {\n        var opts = $.extend({}, defaultOpts, o);\n        opts.callbacks = {\n            'move': bind(opts.move, callbackContext),\n            'change': bind(opts.change, callbackContext),\n            'show': bind(opts.show, callbackContext),\n            'hide': bind(opts.hide, callbackContext),\n            'beforeShow': bind(opts.beforeShow, callbackContext)\n        };\n\n        return opts;\n    }\n\n    function spectrum(element, o) {\n\n        var opts = instanceOptions(o, element),\n            flat = opts.flat,\n            showSelectionPalette = opts.showSelectionPalette,\n            localStorageKey = opts.localStorageKey,\n            theme = opts.theme,\n            callbacks = opts.callbacks,\n            resize = throttle(reflow, 10),\n            visible = false,\n            isDragging = false,\n            dragWidth = 0,\n            dragHeight = 0,\n            dragHelperHeight = 0,\n            slideHeight = 0,\n            slideWidth = 0,\n            alphaWidth = 0,\n            alphaSlideHelperWidth = 0,\n            slideHelperHeight = 0,\n            currentHue = 0,\n            currentSaturation = 0,\n            currentValue = 0,\n            currentAlpha = 1,\n            palette = [],\n            paletteArray = [],\n            paletteLookup = {},\n            selectionPalette = opts.selectionPalette.slice(0),\n            maxSelectionSize = opts.maxSelectionSize,\n            draggingClass = \"sp-dragging\",\n            shiftMovementDirection = null;\n\n        var doc = element.ownerDocument,\n            body = doc.body,\n            boundElement = $(element),\n            disabled = false,\n            container = $(markup, doc).addClass(theme),\n            pickerContainer = container.find(\".sp-picker-container\"),\n            dragger = container.find(\".sp-color\"),\n            dragHelper = container.find(\".sp-dragger\"),\n            slider = container.find(\".sp-hue\"),\n            slideHelper = container.find(\".sp-slider\"),\n            alphaSliderInner = container.find(\".sp-alpha-inner\"),\n            alphaSlider = container.find(\".sp-alpha\"),\n            alphaSlideHelper = container.find(\".sp-alpha-handle\"),\n            textInput = container.find(\".sp-input\"),\n            paletteContainer = container.find(\".sp-palette\"),\n            initialColorContainer = container.find(\".sp-initial\"),\n            cancelButton = container.find(\".sp-cancel\"),\n            clearButton = container.find(\".sp-clear\"),\n            chooseButton = container.find(\".sp-choose\"),\n            toggleButton = container.find(\".sp-palette-toggle\"),\n            isInput = boundElement.is(\"input\"),\n            isInputTypeColor = isInput && boundElement.attr(\"type\") === \"color\" && inputTypeColorSupport(),\n            shouldReplace = isInput && !flat,\n            replacer = (shouldReplace) ? $(replaceInput).addClass(theme).addClass(opts.className).addClass(opts.replacerClassName) : $([]),\n            offsetElement = (shouldReplace) ? replacer : boundElement,\n            previewElement = replacer.find(\".sp-preview-inner\"),\n            initialColor = opts.color || (isInput && boundElement.val()),\n            colorOnShow = false,\n            currentPreferredFormat = opts.preferredFormat,\n            clickoutFiresChange = !opts.showButtons || opts.clickoutFiresChange,\n            isEmpty = !initialColor,\n            allowEmpty = opts.allowEmpty && !isInputTypeColor;\n\n        function applyOptions() {\n\n            if (opts.showPaletteOnly) {\n                opts.showPalette = true;\n            }\n\n            toggleButton.text(opts.showPaletteOnly ? opts.togglePaletteMoreText : opts.togglePaletteLessText);\n\n            if (opts.palette) {\n                palette = opts.palette.slice(0);\n                paletteArray = $.isArray(palette[0]) ? palette : [palette];\n                paletteLookup = {};\n                for (var i = 0; i < paletteArray.length; i++) {\n                    for (var j = 0; j < paletteArray[i].length; j++) {\n                        var rgb = tinycolor(paletteArray[i][j]).toRgbString();\n                        paletteLookup[rgb] = true;\n                    }\n                }\n            }\n\n            container.toggleClass(\"sp-flat\", flat);\n            container.toggleClass(\"sp-input-disabled\", !opts.showInput);\n            container.toggleClass(\"sp-alpha-enabled\", opts.showAlpha);\n            container.toggleClass(\"sp-clear-enabled\", allowEmpty);\n            container.toggleClass(\"sp-buttons-disabled\", !opts.showButtons);\n            container.toggleClass(\"sp-palette-buttons-disabled\", !opts.togglePaletteOnly);\n            container.toggleClass(\"sp-palette-disabled\", !opts.showPalette);\n            container.toggleClass(\"sp-palette-only\", opts.showPaletteOnly);\n            container.toggleClass(\"sp-initial-disabled\", !opts.showInitial);\n            container.addClass(opts.className).addClass(opts.containerClassName);\n\n            reflow();\n        }\n\n        function initialize() {\n\n            if (IE) {\n                container.find(\"*:not(input)\").attr(\"unselectable\", \"on\");\n            }\n\n            applyOptions();\n\n            if (shouldReplace) {\n                boundElement.after(replacer).hide();\n            }\n\n            if (!allowEmpty) {\n                clearButton.hide();\n            }\n\n            if (flat) {\n                boundElement.after(container).hide();\n            }\n            else {\n\n                var appendTo = opts.appendTo === \"parent\" ? boundElement.parent() : $(opts.appendTo);\n                if (appendTo.length !== 1) {\n                    appendTo = $(\"body\");\n                }\n\n                appendTo.append(container);\n            }\n\n            updateSelectionPaletteFromStorage();\n\n            offsetElement.on(\"click.spectrum touchstart.spectrum\", function (e) {\n                if (!disabled) {\n                    toggle();\n                }\n\n                e.stopPropagation();\n\n                if (!$(e.target).is(\"input\")) {\n                    e.preventDefault();\n                }\n            });\n\n            if(boundElement.is(\":disabled\") || (opts.disabled === true)) {\n                disable();\n            }\n\n            // Prevent clicks from bubbling up to document.  This would cause it to be hidden.\n            container.click(stopPropagation);\n\n            // Handle user typed input\n            textInput.change(setFromTextInput);\n            textInput.on(\"paste\", function () {\n                setTimeout(setFromTextInput, 1);\n            });\n            textInput.keydown(function (e) { if (e.keyCode == 13) { setFromTextInput(); } });\n\n            cancelButton.text(opts.cancelText);\n            cancelButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n                revert();\n                hide();\n            });\n\n            clearButton.attr(\"title\", opts.clearText);\n            clearButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n                isEmpty = true;\n                move();\n\n                if(flat) {\n                    //for the flat style, this is a change event\n                    updateOriginalInput(true);\n                }\n            });\n\n            chooseButton.text(opts.chooseText);\n            chooseButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n\n                if (IE && textInput.is(\":focus\")) {\n                    textInput.trigger('change');\n                }\n\n                if (isValid()) {\n                    updateOriginalInput(true);\n                    hide();\n                }\n            });\n\n            toggleButton.text(opts.showPaletteOnly ? opts.togglePaletteMoreText : opts.togglePaletteLessText);\n            toggleButton.on(\"click.spectrum\", function (e) {\n                e.stopPropagation();\n                e.preventDefault();\n\n                opts.showPaletteOnly = !opts.showPaletteOnly;\n\n                // To make sure the Picker area is drawn on the right, next to the\n                // Palette area (and not below the palette), first move the Palette\n                // to the left to make space for the picker, plus 5px extra.\n                // The 'applyOptions' function puts the whole container back into place\n                // and takes care of the button-text and the sp-palette-only CSS class.\n                if (!opts.showPaletteOnly && !flat) {\n                    container.css('left', '-=' + (pickerContainer.outerWidth(true) + 5));\n                }\n                applyOptions();\n            });\n\n            draggable(alphaSlider, function (dragX, dragY, e) {\n                currentAlpha = (dragX / alphaWidth);\n                isEmpty = false;\n                if (e.shiftKey) {\n                    currentAlpha = Math.round(currentAlpha * 10) / 10;\n                }\n\n                move();\n            }, dragStart, dragStop);\n\n            draggable(slider, function (dragX, dragY) {\n                currentHue = parseFloat(dragY / slideHeight);\n                isEmpty = false;\n                if (!opts.showAlpha) {\n                    currentAlpha = 1;\n                }\n                move();\n            }, dragStart, dragStop);\n\n            draggable(dragger, function (dragX, dragY, e) {\n\n                // shift+drag should snap the movement to either the x or y axis.\n                if (!e.shiftKey) {\n                    shiftMovementDirection = null;\n                }\n                else if (!shiftMovementDirection) {\n                    var oldDragX = currentSaturation * dragWidth;\n                    var oldDragY = dragHeight - (currentValue * dragHeight);\n                    var furtherFromX = Math.abs(dragX - oldDragX) > Math.abs(dragY - oldDragY);\n\n                    shiftMovementDirection = furtherFromX ? \"x\" : \"y\";\n                }\n\n                var setSaturation = !shiftMovementDirection || shiftMovementDirection === \"x\";\n                var setValue = !shiftMovementDirection || shiftMovementDirection === \"y\";\n\n                if (setSaturation) {\n                    currentSaturation = parseFloat(dragX / dragWidth);\n                }\n                if (setValue) {\n                    currentValue = parseFloat((dragHeight - dragY) / dragHeight);\n                }\n\n                isEmpty = false;\n                if (!opts.showAlpha) {\n                    currentAlpha = 1;\n                }\n\n                move();\n\n            }, dragStart, dragStop);\n\n            if (!!initialColor) {\n                set(initialColor);\n\n                // In case color was black - update the preview UI and set the format\n                // since the set function will not run (default color is black).\n                updateUI();\n                currentPreferredFormat = opts.preferredFormat || tinycolor(initialColor).format;\n\n                addColorToSelectionPalette(initialColor);\n            }\n            else {\n                updateUI();\n            }\n\n            if (flat) {\n                show();\n            }\n\n            function paletteElementClick(e) {\n                if (e.data && e.data.ignore) {\n                    set($(e.target).closest(\".sp-thumb-el\").data(\"color\"));\n                    move();\n                }\n                else {\n                    set($(e.target).closest(\".sp-thumb-el\").data(\"color\"));\n                    move();\n\n                    updateOriginalInput(true);\n                    if (opts.hideAfterPaletteSelect) {\n                        hide();\n                    }\n                }\n\n                return false;\n            }\n\n            var paletteEvent = IE ? \"mousedown.spectrum\" : \"click.spectrum touchstart.spectrum\";\n            paletteContainer.on(paletteEvent, \".sp-thumb-el\", paletteElementClick);\n            initialColorContainer.on(paletteEvent, \".sp-thumb-el:nth-child(1)\", { ignore: true }, paletteElementClick);\n        }\n\n        function updateSelectionPaletteFromStorage() {\n\n            if (localStorageKey && window.localStorage) {\n\n                // Migrate old palettes over to new format.  May want to remove this eventually.\n                try {\n                    var oldPalette = window.localStorage[localStorageKey].split(\",#\");\n                    if (oldPalette.length > 1) {\n                        delete window.localStorage[localStorageKey];\n                        $.each(oldPalette, function(i, c) {\n                            addColorToSelectionPalette(c);\n                        });\n                    }\n                }\n                catch(e) { }\n\n                try {\n                    selectionPalette = window.localStorage[localStorageKey].split(\";\");\n                }\n                catch (e) { }\n            }\n        }\n\n        function addColorToSelectionPalette(color) {\n            if (showSelectionPalette) {\n                var rgb = tinycolor(color).toRgbString();\n                if (!paletteLookup[rgb] && $.inArray(rgb, selectionPalette) === -1) {\n                    selectionPalette.push(rgb);\n                    while(selectionPalette.length > maxSelectionSize) {\n                        selectionPalette.shift();\n                    }\n                }\n\n                if (localStorageKey && window.localStorage) {\n                    try {\n                        window.localStorage[localStorageKey] = selectionPalette.join(\";\");\n                    }\n                    catch(e) { }\n                }\n            }\n        }\n\n        function getUniqueSelectionPalette() {\n            var unique = [];\n            if (opts.showPalette) {\n                for (var i = 0; i < selectionPalette.length; i++) {\n                    var rgb = tinycolor(selectionPalette[i]).toRgbString();\n\n                    if (!paletteLookup[rgb]) {\n                        unique.push(selectionPalette[i]);\n                    }\n                }\n            }\n\n            return unique.reverse().slice(0, opts.maxSelectionSize);\n        }\n\n        function drawPalette() {\n\n            var currentColor = get();\n\n            var html = $.map(paletteArray, function (palette, i) {\n                return paletteTemplate(palette, currentColor, \"sp-palette-row sp-palette-row-\" + i, opts);\n            });\n\n            updateSelectionPaletteFromStorage();\n\n            if (selectionPalette) {\n                html.push(paletteTemplate(getUniqueSelectionPalette(), currentColor, \"sp-palette-row sp-palette-row-selection\", opts));\n            }\n\n            paletteContainer.html(html.join(\"\"));\n        }\n\n        function drawInitial() {\n            if (opts.showInitial) {\n                var initial = colorOnShow;\n                var current = get();\n                initialColorContainer.html(paletteTemplate([initial, current], current, \"sp-palette-row-initial\", opts));\n            }\n        }\n\n        function dragStart() {\n            if (dragHeight <= 0 || dragWidth <= 0 || slideHeight <= 0) {\n                reflow();\n            }\n            isDragging = true;\n            container.addClass(draggingClass);\n            shiftMovementDirection = null;\n            boundElement.trigger('dragstart.spectrum', [ get() ]);\n        }\n\n        function dragStop() {\n            isDragging = false;\n            container.removeClass(draggingClass);\n            boundElement.trigger('dragstop.spectrum', [ get() ]);\n        }\n\n        function setFromTextInput() {\n\n            var value = textInput.val();\n\n            if ((value === null || value === \"\") && allowEmpty) {\n                set(null);\n                move();\n                updateOriginalInput();\n            }\n            else {\n                var tiny = tinycolor(value);\n                if (tiny.isValid()) {\n                    set(tiny);\n                    move();\n                    updateOriginalInput(true);\n                }\n                else {\n                    textInput.addClass(\"sp-validation-error\");\n                }\n            }\n        }\n\n        function toggle() {\n            if (visible) {\n                hide();\n            }\n            else {\n                show();\n            }\n        }\n\n        function show() {\n            var event = $.Event('beforeShow.spectrum');\n\n            if (visible) {\n                reflow();\n                return;\n            }\n\n            boundElement.trigger(event, [ get() ]);\n\n            if (callbacks.beforeShow(get()) === false || event.isDefaultPrevented()) {\n                return;\n            }\n\n            hideAll();\n            visible = true;\n\n            $(doc).on(\"keydown.spectrum\", onkeydown);\n            $(doc).on(\"click.spectrum\", clickout);\n            $(window).on(\"resize.spectrum\", resize);\n            replacer.addClass(\"sp-active\");\n            container.removeClass(\"sp-hidden\");\n\n            reflow();\n            updateUI();\n\n            colorOnShow = get();\n\n            drawInitial();\n            callbacks.show(colorOnShow);\n            boundElement.trigger('show.spectrum', [ colorOnShow ]);\n        }\n\n        function onkeydown(e) {\n            // Close on ESC\n            if (e.keyCode === 27) {\n                hide();\n            }\n        }\n\n        function clickout(e) {\n            // Return on right click.\n            if (e.button == 2) { return; }\n\n            // If a drag event was happening during the mouseup, don't hide\n            // on click.\n            if (isDragging) { return; }\n\n            if (clickoutFiresChange) {\n                updateOriginalInput(true);\n            }\n            else {\n                revert();\n            }\n            hide();\n        }\n\n        function hide() {\n            // Return if hiding is unnecessary\n            if (!visible || flat) { return; }\n            visible = false;\n\n            $(doc).off(\"keydown.spectrum\", onkeydown);\n            $(doc).off(\"click.spectrum\", clickout);\n            $(window).off(\"resize.spectrum\", resize);\n\n            replacer.removeClass(\"sp-active\");\n            container.addClass(\"sp-hidden\");\n\n            callbacks.hide(get());\n            boundElement.trigger('hide.spectrum', [ get() ]);\n        }\n\n        function revert() {\n            set(colorOnShow, true);\n            updateOriginalInput(true);\n        }\n\n        function set(color, ignoreFormatChange) {\n            if (tinycolor.equals(color, get())) {\n                // Update UI just in case a validation error needs\n                // to be cleared.\n                updateUI();\n                return;\n            }\n\n            var newColor, newHsv;\n            if (!color && allowEmpty) {\n                isEmpty = true;\n            } else {\n                isEmpty = false;\n                newColor = tinycolor(color);\n                newHsv = newColor.toHsv();\n\n                currentHue = (newHsv.h % 360) / 360;\n                currentSaturation = newHsv.s;\n                currentValue = newHsv.v;\n                currentAlpha = newHsv.a;\n            }\n            updateUI();\n\n            if (newColor && newColor.isValid() && !ignoreFormatChange) {\n                currentPreferredFormat = opts.preferredFormat || newColor.getFormat();\n            }\n        }\n\n        function get(opts) {\n            opts = opts || { };\n\n            if (allowEmpty && isEmpty) {\n                return null;\n            }\n\n            return tinycolor.fromRatio({\n                h: currentHue,\n                s: currentSaturation,\n                v: currentValue,\n                a: Math.round(currentAlpha * 1000) / 1000\n            }, { format: opts.format || currentPreferredFormat });\n        }\n\n        function isValid() {\n            return !textInput.hasClass(\"sp-validation-error\");\n        }\n\n        function move() {\n            updateUI();\n\n            callbacks.move(get());\n            boundElement.trigger('move.spectrum', [ get() ]);\n        }\n\n        function updateUI() {\n\n            textInput.removeClass(\"sp-validation-error\");\n\n            updateHelperLocations();\n\n            // Update dragger background color (gradients take care of saturation and value).\n            var flatColor = tinycolor.fromRatio({ h: currentHue, s: 1, v: 1 });\n            dragger.css(\"background-color\", flatColor.toHexString());\n\n            // Get a format that alpha will be included in (hex and names ignore alpha)\n            var format = currentPreferredFormat;\n            if (currentAlpha < 1 && !(currentAlpha === 0 && format === \"name\")) {\n                if (format === \"hex\" || format === \"hex3\" || format === \"hex6\" || format === \"name\") {\n                    format = \"rgb\";\n                }\n            }\n\n            var realColor = get({ format: format }),\n                displayColor = '';\n\n            //reset background info for preview element\n            previewElement.removeClass(\"sp-clear-display\");\n            previewElement.css('background-color', 'transparent');\n\n            if (!realColor && allowEmpty) {\n                // Update the replaced elements background with icon indicating no color selection\n                previewElement.addClass(\"sp-clear-display\");\n            }\n            else {\n                var realHex = realColor.toHexString(),\n                    realRgb = realColor.toRgbString();\n\n                // Update the replaced elements background color (with actual selected color)\n                if (rgbaSupport || realColor.alpha === 1) {\n                    previewElement.css(\"background-color\", realRgb);\n                }\n                else {\n                    previewElement.css(\"background-color\", \"transparent\");\n                    previewElement.css(\"filter\", realColor.toFilter());\n                }\n\n                if (opts.showAlpha) {\n                    var rgb = realColor.toRgb();\n                    rgb.a = 0;\n                    var realAlpha = tinycolor(rgb).toRgbString();\n                    var gradient = \"linear-gradient(left, \" + realAlpha + \", \" + realHex + \")\";\n\n                    if (IE) {\n                        alphaSliderInner.css(\"filter\", tinycolor(realAlpha).toFilter({ gradientType: 1 }, realHex));\n                    }\n                    else {\n                        alphaSliderInner.css(\"background\", \"-webkit-\" + gradient);\n                        alphaSliderInner.css(\"background\", \"-moz-\" + gradient);\n                        alphaSliderInner.css(\"background\", \"-ms-\" + gradient);\n                        // Use current syntax gradient on unprefixed property.\n                        alphaSliderInner.css(\"background\",\n                            \"linear-gradient(to right, \" + realAlpha + \", \" + realHex + \")\");\n                    }\n                }\n\n                displayColor = realColor.toString(format);\n            }\n\n            // Update the text entry input as it changes happen\n            if (opts.showInput) {\n                textInput.val(displayColor);\n            }\n\n            if (opts.showPalette) {\n                drawPalette();\n            }\n\n            drawInitial();\n        }\n\n        function updateHelperLocations() {\n            var s = currentSaturation;\n            var v = currentValue;\n\n            if(allowEmpty && isEmpty) {\n                //if selected color is empty, hide the helpers\n                alphaSlideHelper.hide();\n                slideHelper.hide();\n                dragHelper.hide();\n            }\n            else {\n                //make sure helpers are visible\n                alphaSlideHelper.show();\n                slideHelper.show();\n                dragHelper.show();\n\n                // Where to show the little circle in that displays your current selected color\n                var dragX = s * dragWidth;\n                var dragY = dragHeight - (v * dragHeight);\n                dragX = Math.max(\n                    -dragHelperHeight,\n                    Math.min(dragWidth - dragHelperHeight, dragX - dragHelperHeight)\n                );\n                dragY = Math.max(\n                    -dragHelperHeight,\n                    Math.min(dragHeight - dragHelperHeight, dragY - dragHelperHeight)\n                );\n                dragHelper.css({\n                    \"top\": dragY + \"px\",\n                    \"left\": dragX + \"px\"\n                });\n\n                var alphaX = currentAlpha * alphaWidth;\n                alphaSlideHelper.css({\n                    \"left\": (alphaX - (alphaSlideHelperWidth / 2)) + \"px\"\n                });\n\n                // Where to show the bar that displays your current selected hue\n                var slideY = (currentHue) * slideHeight;\n                slideHelper.css({\n                    \"top\": (slideY - slideHelperHeight) + \"px\"\n                });\n            }\n        }\n\n        function updateOriginalInput(fireCallback) {\n            var color = get(),\n                displayColor = '',\n                hasChanged = !tinycolor.equals(color, colorOnShow);\n\n            if (color) {\n                displayColor = color.toString(currentPreferredFormat);\n                // Update the selection palette with the current color\n                addColorToSelectionPalette(color);\n            }\n\n            if (isInput) {\n                boundElement.val(displayColor);\n            }\n\n            if (fireCallback && hasChanged) {\n                callbacks.change(color);\n                boundElement.trigger('change', [ color ]);\n            }\n        }\n\n        function reflow() {\n            if (!visible) {\n                return; // Calculations would be useless and wouldn't be reliable anyways\n            }\n            dragWidth = dragger.width();\n            dragHeight = dragger.height();\n            dragHelperHeight = dragHelper.height();\n            slideWidth = slider.width();\n            slideHeight = slider.height();\n            slideHelperHeight = slideHelper.height();\n            alphaWidth = alphaSlider.width();\n            alphaSlideHelperWidth = alphaSlideHelper.width();\n\n            if (!flat) {\n                container.css(\"position\", \"absolute\");\n                if (opts.offset) {\n                    container.offset(opts.offset);\n                } else {\n                    container.offset(getOffset(container, offsetElement));\n                }\n            }\n\n            updateHelperLocations();\n\n            if (opts.showPalette) {\n                drawPalette();\n            }\n\n            boundElement.trigger('reflow.spectrum');\n        }\n\n        function destroy() {\n            boundElement.show();\n            offsetElement.off(\"click.spectrum touchstart.spectrum\");\n            container.remove();\n            replacer.remove();\n            spectrums[spect.id] = null;\n        }\n\n        function option(optionName, optionValue) {\n            if (optionName === undefined) {\n                return $.extend({}, opts);\n            }\n            if (optionValue === undefined) {\n                return opts[optionName];\n            }\n\n            opts[optionName] = optionValue;\n\n            if (optionName === \"preferredFormat\") {\n                currentPreferredFormat = opts.preferredFormat;\n            }\n            applyOptions();\n        }\n\n        function enable() {\n            disabled = false;\n            boundElement.attr(\"disabled\", false);\n            offsetElement.removeClass(\"sp-disabled\");\n        }\n\n        function disable() {\n            hide();\n            disabled = true;\n            boundElement.attr(\"disabled\", true);\n            offsetElement.addClass(\"sp-disabled\");\n        }\n\n        function setOffset(coord) {\n            opts.offset = coord;\n            reflow();\n        }\n\n        initialize();\n\n        var spect = {\n            show: show,\n            hide: hide,\n            toggle: toggle,\n            reflow: reflow,\n            option: option,\n            enable: enable,\n            disable: disable,\n            offset: setOffset,\n            set: function (c) {\n                set(c);\n                updateOriginalInput();\n            },\n            get: get,\n            destroy: destroy,\n            container: container\n        };\n\n        spect.id = spectrums.push(spect) - 1;\n\n        return spect;\n    }\n\n    /**\n     * checkOffset - get the offset below/above and left/right element depending on screen position\n     * Thanks https://github.com/jquery/jquery-ui/blob/master/ui/jquery.ui.datepicker.js\n     */\n    function getOffset(picker, input) {\n        var extraY = 0;\n        var dpWidth = picker.outerWidth();\n        var dpHeight = picker.outerHeight();\n        var inputHeight = input.outerHeight();\n        var doc = picker[0].ownerDocument;\n        var docElem = doc.documentElement;\n        var viewWidth = docElem.clientWidth + $(doc).scrollLeft();\n        var viewHeight = docElem.clientHeight + $(doc).scrollTop();\n        var offset = input.offset();\n        var offsetLeft = offset.left;\n        var offsetTop = offset.top;\n\n        offsetTop += inputHeight;\n\n        offsetLeft -=\n            Math.min(offsetLeft, (offsetLeft + dpWidth > viewWidth && viewWidth > dpWidth) ?\n                Math.abs(offsetLeft + dpWidth - viewWidth) : 0);\n\n        offsetTop -=\n            Math.min(offsetTop, ((offsetTop + dpHeight > viewHeight && viewHeight > dpHeight) ?\n                Math.abs(dpHeight + inputHeight - extraY) : extraY));\n\n        return {\n            top: offsetTop,\n            bottom: offset.bottom,\n            left: offsetLeft,\n            right: offset.right,\n            width: offset.width,\n            height: offset.height\n        };\n    }\n\n    /**\n     * noop - do nothing\n     */\n    function noop() {\n\n    }\n\n    /**\n     * stopPropagation - makes the code only doing this a little easier to read in line\n     */\n    function stopPropagation(e) {\n        e.stopPropagation();\n    }\n\n    /**\n     * Create a function bound to a given object\n     * Thanks to underscore.js\n     */\n    function bind(func, obj) {\n        var slice = Array.prototype.slice;\n        var args = slice.call(arguments, 2);\n        return function () {\n            return func.apply(obj, args.concat(slice.call(arguments)));\n        };\n    }\n\n    /**\n     * Lightweight drag helper.  Handles containment within the element, so that\n     * when dragging, the x is within [0,element.width] and y is within [0,element.height]\n     */\n    function draggable(element, onmove, onstart, onstop) {\n        onmove = onmove || function () { };\n        onstart = onstart || function () { };\n        onstop = onstop || function () { };\n        var doc = document;\n        var dragging = false;\n        var offset = {};\n        var maxHeight = 0;\n        var maxWidth = 0;\n        var hasTouch = ('ontouchstart' in window);\n\n        var duringDragEvents = {};\n        duringDragEvents[\"selectstart\"] = prevent;\n        duringDragEvents[\"dragstart\"] = prevent;\n        duringDragEvents[\"touchmove mousemove\"] = move;\n        duringDragEvents[\"touchend mouseup\"] = stop;\n\n        function prevent(e) {\n            if (e.stopPropagation) {\n                e.stopPropagation();\n            }\n            if (e.preventDefault) {\n                e.preventDefault();\n            }\n            e.returnValue = false;\n        }\n\n        function move(e) {\n            if (dragging) {\n                // Mouseup happened outside of window\n                if (IE && doc.documentMode < 9 && !e.button) {\n                    return stop();\n                }\n\n                var t0 = e.originalEvent && e.originalEvent.touches && e.originalEvent.touches[0];\n                var pageX = t0 && t0.pageX || e.pageX;\n                var pageY = t0 && t0.pageY || e.pageY;\n\n                var dragX = Math.max(0, Math.min(pageX - offset.left, maxWidth));\n                var dragY = Math.max(0, Math.min(pageY - offset.top, maxHeight));\n\n                if (hasTouch) {\n                    // Stop scrolling in iOS\n                    prevent(e);\n                }\n\n                onmove.apply(element, [dragX, dragY, e]);\n            }\n        }\n\n        function start(e) {\n            var rightclick = (e.which) ? (e.which == 3) : (e.button == 2);\n\n            if (!rightclick && !dragging) {\n                if (onstart.apply(element, arguments) !== false) {\n                    dragging = true;\n                    maxHeight = $(element).height();\n                    maxWidth = $(element).width();\n                    offset = $(element).offset();\n\n                    $(doc).on(duringDragEvents);\n                    $(doc.body).addClass(\"sp-dragging\");\n\n                    move(e);\n\n                    prevent(e);\n                }\n            }\n        }\n\n        function stop() {\n            if (dragging) {\n                $(doc).off(duringDragEvents);\n                $(doc.body).removeClass(\"sp-dragging\");\n\n                // Wait a tick before notifying observers to allow the click event\n                // to fire in Chrome.\n                setTimeout(function() {\n                    onstop.apply(element, arguments);\n                }, 0);\n            }\n            dragging = false;\n        }\n\n        $(element).on(\"touchstart mousedown\", start);\n    }\n\n    function throttle(func, wait, debounce) {\n        var timeout;\n        return function () {\n            var context = this, args = arguments;\n            var throttler = function () {\n                timeout = null;\n                func.apply(context, args);\n            };\n            if (debounce) clearTimeout(timeout);\n            if (debounce || !timeout) timeout = setTimeout(throttler, wait);\n        };\n    }\n\n    function inputTypeColorSupport() {\n        return $.fn.spectrum.inputTypeColorSupport();\n    }\n\n    /**\n     * Define a jQuery plugin\n     */\n    var dataID = \"spectrum.id\";\n    $.fn.spectrum = function (opts, extra) {\n\n        if (typeof opts == \"string\") {\n\n            var returnValue = this;\n            var args = Array.prototype.slice.call( arguments, 1 );\n\n            this.each(function () {\n                var spect = spectrums[$(this).data(dataID)];\n                if (spect) {\n                    var method = spect[opts];\n                    if (!method) {\n                        throw new Error( \"Spectrum: no such method: '\" + opts + \"'\" );\n                    }\n\n                    if (opts == \"get\") {\n                        returnValue = spect.get();\n                    }\n                    else if (opts == \"container\") {\n                        returnValue = spect.container;\n                    }\n                    else if (opts == \"option\") {\n                        returnValue = spect.option.apply(spect, args);\n                    }\n                    else if (opts == \"destroy\") {\n                        spect.destroy();\n                        $(this).removeData(dataID);\n                    }\n                    else {\n                        method.apply(spect, args);\n                    }\n                }\n            });\n\n            return returnValue;\n        }\n\n        // Initializing a new instance of spectrum\n        return this.spectrum(\"destroy\").each(function () {\n            var options = $.extend({}, $(this).data(), opts);\n            var spect = spectrum(this, options);\n            $(this).data(dataID, spect.id);\n        });\n    };\n\n    $.fn.spectrum.load = true;\n    $.fn.spectrum.loadOpts = {};\n    $.fn.spectrum.draggable = draggable;\n    $.fn.spectrum.defaults = defaultOpts;\n    $.fn.spectrum.inputTypeColorSupport = function inputTypeColorSupport() {\n        if (typeof inputTypeColorSupport._cachedResult === \"undefined\") {\n            var colorInput = $(\"<input type='color'/>\")[0]; // if color element is supported, value will default to not null\n            inputTypeColorSupport._cachedResult = colorInput.type === \"color\" && colorInput.value !== \"\";\n        }\n        return inputTypeColorSupport._cachedResult;\n    };\n\n    $.spectrum = { };\n    $.spectrum.localization = { };\n    $.spectrum.palettes = { };\n\n    $.fn.spectrum.processNativeColorInputs = function () {\n        var colorInputs = $(\"input[type=color]\");\n        if (colorInputs.length && !inputTypeColorSupport()) {\n            colorInputs.spectrum({\n                preferredFormat: \"hex6\"\n            });\n        }\n    };\n\n    // TinyColor v1.1.2\n    // https://github.com/bgrins/TinyColor\n    // Brian Grinstead, MIT License\n\n    (function() {\n\n        var trimLeft = /^[\\s,#]+/,\n            trimRight = /\\s+$/,\n            tinyCounter = 0,\n            math = Math,\n            mathRound = math.round,\n            mathMin = math.min,\n            mathMax = math.max,\n            mathRandom = math.random;\n\n        var tinycolor = function(color, opts) {\n\n            color = (color) ? color : '';\n            opts = opts || { };\n\n            // If input is already a tinycolor, return itself\n            if (color instanceof tinycolor) {\n                return color;\n            }\n            // If we are called as a function, call using new instead\n            if (!(this instanceof tinycolor)) {\n                return new tinycolor(color, opts);\n            }\n\n            var rgb = inputToRGB(color);\n            this._originalInput = color;\n            this._r = rgb.r;\n            this._g = rgb.g;\n            this._b = rgb.b;\n            this._a = rgb.a;\n            this._roundA = mathRound(1000 * this._a) / 1000;\n            this._format = opts.format || rgb.format;\n            this._gradientType = opts.gradientType;\n\n            // Don't let the range of [0,255] come back in [0,1].\n            // Potentially lose a little bit of precision here, but will fix issues where\n            // .5 gets interpreted as half of the total, instead of half of 1\n            // If it was supposed to be 128, this was already taken care of by `inputToRgb`\n            if (this._r < 1) { this._r = mathRound(this._r); }\n            if (this._g < 1) { this._g = mathRound(this._g); }\n            if (this._b < 1) { this._b = mathRound(this._b); }\n\n            this._ok = rgb.ok;\n            this._tc_id = tinyCounter++;\n        };\n\n        tinycolor.prototype = {\n            isDark: function() {\n                return this.getBrightness() < 128;\n            },\n            isLight: function() {\n                return !this.isDark();\n            },\n            isValid: function() {\n                return this._ok;\n            },\n            getOriginalInput: function() {\n                return this._originalInput;\n            },\n            getFormat: function() {\n                return this._format;\n            },\n            getAlpha: function() {\n                return this._a;\n            },\n            getBrightness: function() {\n                var rgb = this.toRgb();\n                return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1000;\n            },\n            setAlpha: function(value) {\n                this._a = boundAlpha(value);\n                this._roundA = mathRound(1000 * this._a) / 1000;\n                return this;\n            },\n            toHsv: function() {\n                var hsv = rgbToHsv(this._r, this._g, this._b);\n                return { h: hsv.h * 360, s: hsv.s, v: hsv.v, a: this._a };\n            },\n            toHsvString: function() {\n                var hsv = rgbToHsv(this._r, this._g, this._b);\n                var h = mathRound(hsv.h * 360), s = mathRound(hsv.s * 100), v = mathRound(hsv.v * 100);\n                return (this._a == 1) ?\n                    \"hsv(\"  + h + \", \" + s + \"%, \" + v + \"%)\" :\n                    \"hsva(\" + h + \", \" + s + \"%, \" + v + \"%, \"+ this._roundA + \")\";\n            },\n            toHsl: function() {\n                var hsl = rgbToHsl(this._r, this._g, this._b);\n                return { h: hsl.h * 360, s: hsl.s, l: hsl.l, a: this._a };\n            },\n            toHslString: function() {\n                var hsl = rgbToHsl(this._r, this._g, this._b);\n                var h = mathRound(hsl.h * 360), s = mathRound(hsl.s * 100), l = mathRound(hsl.l * 100);\n                return (this._a == 1) ?\n                    \"hsl(\"  + h + \", \" + s + \"%, \" + l + \"%)\" :\n                    \"hsla(\" + h + \", \" + s + \"%, \" + l + \"%, \"+ this._roundA + \")\";\n            },\n            toHex: function(allow3Char) {\n                return rgbToHex(this._r, this._g, this._b, allow3Char);\n            },\n            toHexString: function(allow3Char) {\n                return '#' + this.toHex(allow3Char);\n            },\n            toHex8: function() {\n                return rgbaToHex(this._r, this._g, this._b, this._a);\n            },\n            toHex8String: function() {\n                return '#' + this.toHex8();\n            },\n            toRgb: function() {\n                return { r: mathRound(this._r), g: mathRound(this._g), b: mathRound(this._b), a: this._a };\n            },\n            toRgbString: function() {\n                return (this._a == 1) ?\n                    \"rgb(\"  + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \")\" :\n                    \"rgba(\" + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \", \" + this._roundA + \")\";\n            },\n            toPercentageRgb: function() {\n                return { r: mathRound(bound01(this._r, 255) * 100) + \"%\", g: mathRound(bound01(this._g, 255) * 100) + \"%\", b: mathRound(bound01(this._b, 255) * 100) + \"%\", a: this._a };\n            },\n            toPercentageRgbString: function() {\n                return (this._a == 1) ?\n                    \"rgb(\"  + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%)\" :\n                    \"rgba(\" + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%, \" + this._roundA + \")\";\n            },\n            toName: function() {\n                if (this._a === 0) {\n                    return \"transparent\";\n                }\n\n                if (this._a < 1) {\n                    return false;\n                }\n\n                return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;\n            },\n            toFilter: function(secondColor) {\n                var hex8String = '#' + rgbaToHex(this._r, this._g, this._b, this._a);\n                var secondHex8String = hex8String;\n                var gradientType = this._gradientType ? \"GradientType = 1, \" : \"\";\n\n                if (secondColor) {\n                    var s = tinycolor(secondColor);\n                    secondHex8String = s.toHex8String();\n                }\n\n                return \"progid:DXImageTransform.Microsoft.gradient(\"+gradientType+\"startColorstr=\"+hex8String+\",endColorstr=\"+secondHex8String+\")\";\n            },\n            toString: function(format) {\n                var formatSet = !!format;\n                format = format || this._format;\n\n                var formattedString = false;\n                var hasAlpha = this._a < 1 && this._a >= 0;\n                var needsAlphaFormat = !formatSet && hasAlpha && (format === \"hex\" || format === \"hex6\" || format === \"hex3\" || format === \"name\");\n\n                if (needsAlphaFormat) {\n                    // Special case for \"transparent\", all other non-alpha formats\n                    // will return rgba when there is transparency.\n                    if (format === \"name\" && this._a === 0) {\n                        return this.toName();\n                    }\n                    return this.toRgbString();\n                }\n                if (format === \"rgb\") {\n                    formattedString = this.toRgbString();\n                }\n                if (format === \"prgb\") {\n                    formattedString = this.toPercentageRgbString();\n                }\n                if (format === \"hex\" || format === \"hex6\") {\n                    formattedString = this.toHexString();\n                }\n                if (format === \"hex3\") {\n                    formattedString = this.toHexString(true);\n                }\n                if (format === \"hex8\") {\n                    formattedString = this.toHex8String();\n                }\n                if (format === \"name\") {\n                    formattedString = this.toName();\n                }\n                if (format === \"hsl\") {\n                    formattedString = this.toHslString();\n                }\n                if (format === \"hsv\") {\n                    formattedString = this.toHsvString();\n                }\n\n                return formattedString || this.toHexString();\n            },\n\n            _applyModification: function(fn, args) {\n                var color = fn.apply(null, [this].concat([].slice.call(args)));\n                this._r = color._r;\n                this._g = color._g;\n                this._b = color._b;\n                this.setAlpha(color._a);\n                return this;\n            },\n            lighten: function() {\n                return this._applyModification(lighten, arguments);\n            },\n            brighten: function() {\n                return this._applyModification(brighten, arguments);\n            },\n            darken: function() {\n                return this._applyModification(darken, arguments);\n            },\n            desaturate: function() {\n                return this._applyModification(desaturate, arguments);\n            },\n            saturate: function() {\n                return this._applyModification(saturate, arguments);\n            },\n            greyscale: function() {\n                return this._applyModification(greyscale, arguments);\n            },\n            spin: function() {\n                return this._applyModification(spin, arguments);\n            },\n\n            _applyCombination: function(fn, args) {\n                return fn.apply(null, [this].concat([].slice.call(args)));\n            },\n            analogous: function() {\n                return this._applyCombination(analogous, arguments);\n            },\n            complement: function() {\n                return this._applyCombination(complement, arguments);\n            },\n            monochromatic: function() {\n                return this._applyCombination(monochromatic, arguments);\n            },\n            splitcomplement: function() {\n                return this._applyCombination(splitcomplement, arguments);\n            },\n            triad: function() {\n                return this._applyCombination(triad, arguments);\n            },\n            tetrad: function() {\n                return this._applyCombination(tetrad, arguments);\n            }\n        };\n\n        // If input is an object, force 1 into \"1.0\" to handle ratios properly\n        // String input requires \"1.0\" as input, so 1 will be treated as 1\n        tinycolor.fromRatio = function(color, opts) {\n            if (typeof color == \"object\") {\n                var newColor = {};\n                for (var i in color) {\n                    if (color.hasOwnProperty(i)) {\n                        if (i === \"a\") {\n                            newColor[i] = color[i];\n                        }\n                        else {\n                            newColor[i] = convertToPercentage(color[i]);\n                        }\n                    }\n                }\n                color = newColor;\n            }\n\n            return tinycolor(color, opts);\n        };\n\n        // Given a string or object, convert that input to RGB\n        // Possible string inputs:\n        //\n        //     \"red\"\n        //     \"#f00\" or \"f00\"\n        //     \"#ff0000\" or \"ff0000\"\n        //     \"#ff000000\" or \"ff000000\"\n        //     \"rgb 255 0 0\" or \"rgb (255, 0, 0)\"\n        //     \"rgb 1.0 0 0\" or \"rgb (1, 0, 0)\"\n        //     \"rgba (255, 0, 0, 1)\" or \"rgba 255, 0, 0, 1\"\n        //     \"rgba (1.0, 0, 0, 1)\" or \"rgba 1.0, 0, 0, 1\"\n        //     \"hsl(0, 100%, 50%)\" or \"hsl 0 100% 50%\"\n        //     \"hsla(0, 100%, 50%, 1)\" or \"hsla 0 100% 50%, 1\"\n        //     \"hsv(0, 100%, 100%)\" or \"hsv 0 100% 100%\"\n        //\n        function inputToRGB(color) {\n\n            var rgb = { r: 0, g: 0, b: 0 };\n            var a = 1;\n            var ok = false;\n            var format = false;\n\n            if (typeof color == \"string\") {\n                color = stringInputToObject(color);\n            }\n\n            if (typeof color == \"object\") {\n                if (color.hasOwnProperty(\"r\") && color.hasOwnProperty(\"g\") && color.hasOwnProperty(\"b\")) {\n                    rgb = rgbToRgb(color.r, color.g, color.b);\n                    ok = true;\n                    format = String(color.r).substr(-1) === \"%\" ? \"prgb\" : \"rgb\";\n                }\n                else if (color.hasOwnProperty(\"h\") && color.hasOwnProperty(\"s\") && color.hasOwnProperty(\"v\")) {\n                    color.s = convertToPercentage(color.s);\n                    color.v = convertToPercentage(color.v);\n                    rgb = hsvToRgb(color.h, color.s, color.v);\n                    ok = true;\n                    format = \"hsv\";\n                }\n                else if (color.hasOwnProperty(\"h\") && color.hasOwnProperty(\"s\") && color.hasOwnProperty(\"l\")) {\n                    color.s = convertToPercentage(color.s);\n                    color.l = convertToPercentage(color.l);\n                    rgb = hslToRgb(color.h, color.s, color.l);\n                    ok = true;\n                    format = \"hsl\";\n                }\n\n                if (color.hasOwnProperty(\"a\")) {\n                    a = color.a;\n                }\n            }\n\n            a = boundAlpha(a);\n\n            return {\n                ok: ok,\n                format: color.format || format,\n                r: mathMin(255, mathMax(rgb.r, 0)),\n                g: mathMin(255, mathMax(rgb.g, 0)),\n                b: mathMin(255, mathMax(rgb.b, 0)),\n                a: a\n            };\n        }\n\n\n        // Conversion Functions\n        // --------------------\n\n        // `rgbToHsl`, `rgbToHsv`, `hslToRgb`, `hsvToRgb` modified from:\n        // <http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript>\n\n        // `rgbToRgb`\n        // Handle bounds / percentage checking to conform to CSS color spec\n        // <http://www.w3.org/TR/css3-color/>\n        // *Assumes:* r, g, b in [0, 255] or [0, 1]\n        // *Returns:* { r, g, b } in [0, 255]\n        function rgbToRgb(r, g, b){\n            return {\n                r: bound01(r, 255) * 255,\n                g: bound01(g, 255) * 255,\n                b: bound01(b, 255) * 255\n            };\n        }\n\n        // `rgbToHsl`\n        // Converts an RGB color value to HSL.\n        // *Assumes:* r, g, and b are contained in [0, 255] or [0, 1]\n        // *Returns:* { h, s, l } in [0,1]\n        function rgbToHsl(r, g, b) {\n\n            r = bound01(r, 255);\n            g = bound01(g, 255);\n            b = bound01(b, 255);\n\n            var max = mathMax(r, g, b), min = mathMin(r, g, b);\n            var h, s, l = (max + min) / 2;\n\n            if(max == min) {\n                h = s = 0; // achromatic\n            }\n            else {\n                var d = max - min;\n                s = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n                switch(max) {\n                    case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                    case g: h = (b - r) / d + 2; break;\n                    case b: h = (r - g) / d + 4; break;\n                }\n\n                h /= 6;\n            }\n\n            return { h: h, s: s, l: l };\n        }\n\n        // `hslToRgb`\n        // Converts an HSL color value to RGB.\n        // *Assumes:* h is contained in [0, 1] or [0, 360] and s and l are contained [0, 1] or [0, 100]\n        // *Returns:* { r, g, b } in the set [0, 255]\n        function hslToRgb(h, s, l) {\n            var r, g, b;\n\n            h = bound01(h, 360);\n            s = bound01(s, 100);\n            l = bound01(l, 100);\n\n            function hue2rgb(p, q, t) {\n                if(t < 0) t += 1;\n                if(t > 1) t -= 1;\n                if(t < 1/6) return p + (q - p) * 6 * t;\n                if(t < 1/2) return q;\n                if(t < 2/3) return p + (q - p) * (2/3 - t) * 6;\n                return p;\n            }\n\n            if(s === 0) {\n                r = g = b = l; // achromatic\n            }\n            else {\n                var q = l < 0.5 ? l * (1 + s) : l + s - l * s;\n                var p = 2 * l - q;\n                r = hue2rgb(p, q, h + 1/3);\n                g = hue2rgb(p, q, h);\n                b = hue2rgb(p, q, h - 1/3);\n            }\n\n            return { r: r * 255, g: g * 255, b: b * 255 };\n        }\n\n        // `rgbToHsv`\n        // Converts an RGB color value to HSV\n        // *Assumes:* r, g, and b are contained in the set [0, 255] or [0, 1]\n        // *Returns:* { h, s, v } in [0,1]\n        function rgbToHsv(r, g, b) {\n\n            r = bound01(r, 255);\n            g = bound01(g, 255);\n            b = bound01(b, 255);\n\n            var max = mathMax(r, g, b), min = mathMin(r, g, b);\n            var h, s, v = max;\n\n            var d = max - min;\n            s = max === 0 ? 0 : d / max;\n\n            if(max == min) {\n                h = 0; // achromatic\n            }\n            else {\n                switch(max) {\n                    case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                    case g: h = (b - r) / d + 2; break;\n                    case b: h = (r - g) / d + 4; break;\n                }\n                h /= 6;\n            }\n            return { h: h, s: s, v: v };\n        }\n\n        // `hsvToRgb`\n        // Converts an HSV color value to RGB.\n        // *Assumes:* h is contained in [0, 1] or [0, 360] and s and v are contained in [0, 1] or [0, 100]\n        // *Returns:* { r, g, b } in the set [0, 255]\n        function hsvToRgb(h, s, v) {\n\n            h = bound01(h, 360) * 6;\n            s = bound01(s, 100);\n            v = bound01(v, 100);\n\n            var i = math.floor(h),\n                f = h - i,\n                p = v * (1 - s),\n                q = v * (1 - f * s),\n                t = v * (1 - (1 - f) * s),\n                mod = i % 6,\n                r = [v, q, p, p, t, v][mod],\n                g = [t, v, v, q, p, p][mod],\n                b = [p, p, t, v, v, q][mod];\n\n            return { r: r * 255, g: g * 255, b: b * 255 };\n        }\n\n        // `rgbToHex`\n        // Converts an RGB color to hex\n        // Assumes r, g, and b are contained in the set [0, 255]\n        // Returns a 3 or 6 character hex\n        function rgbToHex(r, g, b, allow3Char) {\n\n            var hex = [\n                pad2(mathRound(r).toString(16)),\n                pad2(mathRound(g).toString(16)),\n                pad2(mathRound(b).toString(16))\n            ];\n\n            // Return a 3 character hex if possible\n            if (allow3Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1)) {\n                return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);\n            }\n\n            return hex.join(\"\");\n        }\n        // `rgbaToHex`\n        // Converts an RGBA color plus alpha transparency to hex\n        // Assumes r, g, b and a are contained in the set [0, 255]\n        // Returns an 8 character hex\n        function rgbaToHex(r, g, b, a) {\n\n            var hex = [\n                pad2(convertDecimalToHex(a)),\n                pad2(mathRound(r).toString(16)),\n                pad2(mathRound(g).toString(16)),\n                pad2(mathRound(b).toString(16))\n            ];\n\n            return hex.join(\"\");\n        }\n\n        // `equals`\n        // Can be called with any tinycolor input\n        tinycolor.equals = function (color1, color2) {\n            if (!color1 || !color2) { return false; }\n            return tinycolor(color1).toRgbString() == tinycolor(color2).toRgbString();\n        };\n        tinycolor.random = function() {\n            return tinycolor.fromRatio({\n                r: mathRandom(),\n                g: mathRandom(),\n                b: mathRandom()\n            });\n        };\n\n\n        // Modification Functions\n        // ----------------------\n        // Thanks to less.js for some of the basics here\n        // <https://github.com/cloudhead/less.js/blob/master/lib/less/functions.js>\n\n        function desaturate(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.s -= amount / 100;\n            hsl.s = clamp01(hsl.s);\n            return tinycolor(hsl);\n        }\n\n        function saturate(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.s += amount / 100;\n            hsl.s = clamp01(hsl.s);\n            return tinycolor(hsl);\n        }\n\n        function greyscale(color) {\n            return tinycolor(color).desaturate(100);\n        }\n\n        function lighten (color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.l += amount / 100;\n            hsl.l = clamp01(hsl.l);\n            return tinycolor(hsl);\n        }\n\n        function brighten(color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var rgb = tinycolor(color).toRgb();\n            rgb.r = mathMax(0, mathMin(255, rgb.r - mathRound(255 * - (amount / 100))));\n            rgb.g = mathMax(0, mathMin(255, rgb.g - mathRound(255 * - (amount / 100))));\n            rgb.b = mathMax(0, mathMin(255, rgb.b - mathRound(255 * - (amount / 100))));\n            return tinycolor(rgb);\n        }\n\n        function darken (color, amount) {\n            amount = (amount === 0) ? 0 : (amount || 10);\n            var hsl = tinycolor(color).toHsl();\n            hsl.l -= amount / 100;\n            hsl.l = clamp01(hsl.l);\n            return tinycolor(hsl);\n        }\n\n        // Spin takes a positive or negative amount within [-360, 360] indicating the change of hue.\n        // Values outside of this range will be wrapped into this range.\n        function spin(color, amount) {\n            var hsl = tinycolor(color).toHsl();\n            var hue = (mathRound(hsl.h) + amount) % 360;\n            hsl.h = hue < 0 ? 360 + hue : hue;\n            return tinycolor(hsl);\n        }\n\n        // Combination Functions\n        // ---------------------\n        // Thanks to jQuery xColor for some of the ideas behind these\n        // <https://github.com/infusion/jQuery-xcolor/blob/master/jquery.xcolor.js>\n\n        function complement(color) {\n            var hsl = tinycolor(color).toHsl();\n            hsl.h = (hsl.h + 180) % 360;\n            return tinycolor(hsl);\n        }\n\n        function triad(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 120) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 240) % 360, s: hsl.s, l: hsl.l })\n            ];\n        }\n\n        function tetrad(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 90) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 180) % 360, s: hsl.s, l: hsl.l }),\n                tinycolor({ h: (h + 270) % 360, s: hsl.s, l: hsl.l })\n            ];\n        }\n\n        function splitcomplement(color) {\n            var hsl = tinycolor(color).toHsl();\n            var h = hsl.h;\n            return [\n                tinycolor(color),\n                tinycolor({ h: (h + 72) % 360, s: hsl.s, l: hsl.l}),\n                tinycolor({ h: (h + 216) % 360, s: hsl.s, l: hsl.l})\n            ];\n        }\n\n        function analogous(color, results, slices) {\n            results = results || 6;\n            slices = slices || 30;\n\n            var hsl = tinycolor(color).toHsl();\n            var part = 360 / slices;\n            var ret = [tinycolor(color)];\n\n            for (hsl.h = ((hsl.h - (part * results >> 1)) + 720) % 360; --results; ) {\n                hsl.h = (hsl.h + part) % 360;\n                ret.push(tinycolor(hsl));\n            }\n            return ret;\n        }\n\n        function monochromatic(color, results) {\n            results = results || 6;\n            var hsv = tinycolor(color).toHsv();\n            var h = hsv.h, s = hsv.s, v = hsv.v;\n            var ret = [];\n            var modification = 1 / results;\n\n            while (results--) {\n                ret.push(tinycolor({ h: h, s: s, v: v}));\n                v = (v + modification) % 1;\n            }\n\n            return ret;\n        }\n\n        // Utility Functions\n        // ---------------------\n\n        tinycolor.mix = function(color1, color2, amount) {\n            amount = (amount === 0) ? 0 : (amount || 50);\n\n            var rgb1 = tinycolor(color1).toRgb();\n            var rgb2 = tinycolor(color2).toRgb();\n\n            var p = amount / 100;\n            var w = p * 2 - 1;\n            var a = rgb2.a - rgb1.a;\n\n            var w1;\n\n            if (w * a == -1) {\n                w1 = w;\n            } else {\n                w1 = (w + a) / (1 + w * a);\n            }\n\n            w1 = (w1 + 1) / 2;\n\n            var w2 = 1 - w1;\n\n            var rgba = {\n                r: rgb2.r * w1 + rgb1.r * w2,\n                g: rgb2.g * w1 + rgb1.g * w2,\n                b: rgb2.b * w1 + rgb1.b * w2,\n                a: rgb2.a * p  + rgb1.a * (1 - p)\n            };\n\n            return tinycolor(rgba);\n        };\n\n\n        // Readability Functions\n        // ---------------------\n        // <http://www.w3.org/TR/AERT#color-contrast>\n\n        // `readability`\n        // Analyze the 2 colors and returns an object with the following properties:\n        //    `brightness`: difference in brightness between the two colors\n        //    `color`: difference in color/hue between the two colors\n        tinycolor.readability = function(color1, color2) {\n            var c1 = tinycolor(color1);\n            var c2 = tinycolor(color2);\n            var rgb1 = c1.toRgb();\n            var rgb2 = c2.toRgb();\n            var brightnessA = c1.getBrightness();\n            var brightnessB = c2.getBrightness();\n            var colorDiff = (\n                Math.max(rgb1.r, rgb2.r) - Math.min(rgb1.r, rgb2.r) +\n                Math.max(rgb1.g, rgb2.g) - Math.min(rgb1.g, rgb2.g) +\n                Math.max(rgb1.b, rgb2.b) - Math.min(rgb1.b, rgb2.b)\n            );\n\n            return {\n                brightness: Math.abs(brightnessA - brightnessB),\n                color: colorDiff\n            };\n        };\n\n        // `readable`\n        // http://www.w3.org/TR/AERT#color-contrast\n        // Ensure that foreground and background color combinations provide sufficient contrast.\n        // *Example*\n        //    tinycolor.isReadable(\"#000\", \"#111\") => false\n        tinycolor.isReadable = function(color1, color2) {\n            var readability = tinycolor.readability(color1, color2);\n            return readability.brightness > 125 && readability.color > 500;\n        };\n\n        // `mostReadable`\n        // Given a base color and a list of possible foreground or background\n        // colors for that base, returns the most readable color.\n        // *Example*\n        //    tinycolor.mostReadable(\"#123\", [\"#fff\", \"#000\"]) => \"#000\"\n        tinycolor.mostReadable = function(baseColor, colorList) {\n            var bestColor = null;\n            var bestScore = 0;\n            var bestIsReadable = false;\n            for (var i=0; i < colorList.length; i++) {\n\n                // We normalize both around the \"acceptable\" breaking point,\n                // but rank brightness constrast higher than hue.\n\n                var readability = tinycolor.readability(baseColor, colorList[i]);\n                var readable = readability.brightness > 125 && readability.color > 500;\n                var score = 3 * (readability.brightness / 125) + (readability.color / 500);\n\n                if ((readable && ! bestIsReadable) ||\n                    (readable && bestIsReadable && score > bestScore) ||\n                    ((! readable) && (! bestIsReadable) && score > bestScore)) {\n                    bestIsReadable = readable;\n                    bestScore = score;\n                    bestColor = tinycolor(colorList[i]);\n                }\n            }\n            return bestColor;\n        };\n\n\n        // Big List of Colors\n        // ------------------\n        // <http://www.w3.org/TR/css3-color/#svg-color>\n        var names = tinycolor.names = {\n            aliceblue: \"f0f8ff\",\n            antiquewhite: \"faebd7\",\n            aqua: \"0ff\",\n            aquamarine: \"7fffd4\",\n            azure: \"f0ffff\",\n            beige: \"f5f5dc\",\n            bisque: \"ffe4c4\",\n            black: \"000\",\n            blanchedalmond: \"ffebcd\",\n            blue: \"00f\",\n            blueviolet: \"8a2be2\",\n            brown: \"a52a2a\",\n            burlywood: \"deb887\",\n            burntsienna: \"ea7e5d\",\n            cadetblue: \"5f9ea0\",\n            chartreuse: \"7fff00\",\n            chocolate: \"d2691e\",\n            coral: \"ff7f50\",\n            cornflowerblue: \"6495ed\",\n            cornsilk: \"fff8dc\",\n            crimson: \"dc143c\",\n            cyan: \"0ff\",\n            darkblue: \"00008b\",\n            darkcyan: \"008b8b\",\n            darkgoldenrod: \"b8860b\",\n            darkgray: \"a9a9a9\",\n            darkgreen: \"006400\",\n            darkgrey: \"a9a9a9\",\n            darkkhaki: \"bdb76b\",\n            darkmagenta: \"8b008b\",\n            darkolivegreen: \"556b2f\",\n            darkorange: \"ff8c00\",\n            darkorchid: \"9932cc\",\n            darkred: \"8b0000\",\n            darksalmon: \"e9967a\",\n            darkseagreen: \"8fbc8f\",\n            darkslateblue: \"483d8b\",\n            darkslategray: \"2f4f4f\",\n            darkslategrey: \"2f4f4f\",\n            darkturquoise: \"00ced1\",\n            darkviolet: \"9400d3\",\n            deeppink: \"ff1493\",\n            deepskyblue: \"00bfff\",\n            dimgray: \"696969\",\n            dimgrey: \"696969\",\n            dodgerblue: \"1e90ff\",\n            firebrick: \"b22222\",\n            floralwhite: \"fffaf0\",\n            forestgreen: \"228b22\",\n            fuchsia: \"f0f\",\n            gainsboro: \"dcdcdc\",\n            ghostwhite: \"f8f8ff\",\n            gold: \"ffd700\",\n            goldenrod: \"daa520\",\n            gray: \"808080\",\n            green: \"008000\",\n            greenyellow: \"adff2f\",\n            grey: \"808080\",\n            honeydew: \"f0fff0\",\n            hotpink: \"ff69b4\",\n            indianred: \"cd5c5c\",\n            indigo: \"4b0082\",\n            ivory: \"fffff0\",\n            khaki: \"f0e68c\",\n            lavender: \"e6e6fa\",\n            lavenderblush: \"fff0f5\",\n            lawngreen: \"7cfc00\",\n            lemonchiffon: \"fffacd\",\n            lightblue: \"add8e6\",\n            lightcoral: \"f08080\",\n            lightcyan: \"e0ffff\",\n            lightgoldenrodyellow: \"fafad2\",\n            lightgray: \"d3d3d3\",\n            lightgreen: \"90ee90\",\n            lightgrey: \"d3d3d3\",\n            lightpink: \"ffb6c1\",\n            lightsalmon: \"ffa07a\",\n            lightseagreen: \"20b2aa\",\n            lightskyblue: \"87cefa\",\n            lightslategray: \"789\",\n            lightslategrey: \"789\",\n            lightsteelblue: \"b0c4de\",\n            lightyellow: \"ffffe0\",\n            lime: \"0f0\",\n            limegreen: \"32cd32\",\n            linen: \"faf0e6\",\n            magenta: \"f0f\",\n            maroon: \"800000\",\n            mediumaquamarine: \"66cdaa\",\n            mediumblue: \"0000cd\",\n            mediumorchid: \"ba55d3\",\n            mediumpurple: \"9370db\",\n            mediumseagreen: \"3cb371\",\n            mediumslateblue: \"7b68ee\",\n            mediumspringgreen: \"00fa9a\",\n            mediumturquoise: \"48d1cc\",\n            mediumvioletred: \"c71585\",\n            midnightblue: \"191970\",\n            mintcream: \"f5fffa\",\n            mistyrose: \"ffe4e1\",\n            moccasin: \"ffe4b5\",\n            navajowhite: \"ffdead\",\n            navy: \"000080\",\n            oldlace: \"fdf5e6\",\n            olive: \"808000\",\n            olivedrab: \"6b8e23\",\n            orange: \"ffa500\",\n            orangered: \"ff4500\",\n            orchid: \"da70d6\",\n            palegoldenrod: \"eee8aa\",\n            palegreen: \"98fb98\",\n            paleturquoise: \"afeeee\",\n            palevioletred: \"db7093\",\n            papayawhip: \"ffefd5\",\n            peachpuff: \"ffdab9\",\n            peru: \"cd853f\",\n            pink: \"ffc0cb\",\n            plum: \"dda0dd\",\n            powderblue: \"b0e0e6\",\n            purple: \"800080\",\n            rebeccapurple: \"663399\",\n            red: \"f00\",\n            rosybrown: \"bc8f8f\",\n            royalblue: \"4169e1\",\n            saddlebrown: \"8b4513\",\n            salmon: \"fa8072\",\n            sandybrown: \"f4a460\",\n            seagreen: \"2e8b57\",\n            seashell: \"fff5ee\",\n            sienna: \"a0522d\",\n            silver: \"c0c0c0\",\n            skyblue: \"87ceeb\",\n            slateblue: \"6a5acd\",\n            slategray: \"708090\",\n            slategrey: \"708090\",\n            snow: \"fffafa\",\n            springgreen: \"00ff7f\",\n            steelblue: \"4682b4\",\n            tan: \"d2b48c\",\n            teal: \"008080\",\n            thistle: \"d8bfd8\",\n            tomato: \"ff6347\",\n            turquoise: \"40e0d0\",\n            violet: \"ee82ee\",\n            wheat: \"f5deb3\",\n            white: \"fff\",\n            whitesmoke: \"f5f5f5\",\n            yellow: \"ff0\",\n            yellowgreen: \"9acd32\"\n        };\n\n        // Make it easy to access colors via `hexNames[hex]`\n        var hexNames = tinycolor.hexNames = flip(names);\n\n\n        // Utilities\n        // ---------\n\n        // `{ 'name1': 'val1' }` becomes `{ 'val1': 'name1' }`\n        function flip(o) {\n            var flipped = { };\n            for (var i in o) {\n                if (o.hasOwnProperty(i)) {\n                    flipped[o[i]] = i;\n                }\n            }\n            return flipped;\n        }\n\n        // Return a valid alpha value [0,1] with all invalid values being set to 1\n        function boundAlpha(a) {\n            a = parseFloat(a);\n\n            if (isNaN(a) || a < 0 || a > 1) {\n                a = 1;\n            }\n\n            return a;\n        }\n\n        // Take input from [0, n] and return it as [0, 1]\n        function bound01(n, max) {\n            if (isOnePointZero(n)) { n = \"100%\"; }\n\n            var processPercent = isPercentage(n);\n            n = mathMin(max, mathMax(0, parseFloat(n)));\n\n            // Automatically convert percentage into number\n            if (processPercent) {\n                n = parseInt(n * max, 10) / 100;\n            }\n\n            // Handle floating point rounding errors\n            if ((math.abs(n - max) < 0.000001)) {\n                return 1;\n            }\n\n            // Convert into [0, 1] range if it isn't already\n            return (n % max) / parseFloat(max);\n        }\n\n        // Force a number between 0 and 1\n        function clamp01(val) {\n            return mathMin(1, mathMax(0, val));\n        }\n\n        // Parse a base-16 hex value into a base-10 integer\n        function parseIntFromHex(val) {\n            return parseInt(val, 16);\n        }\n\n        // Need to handle 1.0 as 100%, since once it is a number, there is no difference between it and 1\n        // <http://stackoverflow.com/questions/7422072/javascript-how-to-detect-number-as-a-decimal-including-1-0>\n        function isOnePointZero(n) {\n            return typeof n == \"string\" && n.indexOf('.') != -1 && parseFloat(n) === 1;\n        }\n\n        // Check to see if string passed in is a percentage\n        function isPercentage(n) {\n            return typeof n === \"string\" && n.indexOf('%') != -1;\n        }\n\n        // Force a hex value to have 2 characters\n        function pad2(c) {\n            return c.length == 1 ? '0' + c : '' + c;\n        }\n\n        // Replace a decimal with it's percentage value\n        function convertToPercentage(n) {\n            if (n <= 1) {\n                n = (n * 100) + \"%\";\n            }\n\n            return n;\n        }\n\n        // Converts a decimal to a hex value\n        function convertDecimalToHex(d) {\n            return Math.round(parseFloat(d) * 255).toString(16);\n        }\n        // Converts a hex value to a decimal\n        function convertHexToDecimal(h) {\n            return (parseIntFromHex(h) / 255);\n        }\n\n        var matchers = (function() {\n\n            // <http://www.w3.org/TR/css3-values/#integers>\n            var CSS_INTEGER = \"[-\\\\+]?\\\\d+%?\";\n\n            // <http://www.w3.org/TR/css3-values/#number-value>\n            var CSS_NUMBER = \"[-\\\\+]?\\\\d*\\\\.\\\\d+%?\";\n\n            // Allow positive/negative integer/number.  Don't capture the either/or, just the entire outcome.\n            var CSS_UNIT = \"(?:\" + CSS_NUMBER + \")|(?:\" + CSS_INTEGER + \")\";\n\n            // Actual matching.\n            // Parentheses and commas are optional, but not required.\n            // Whitespace can take the place of commas or opening paren\n            var PERMISSIVE_MATCH3 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n            var PERMISSIVE_MATCH4 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n\n            return {\n                rgb: new RegExp(\"rgb\" + PERMISSIVE_MATCH3),\n                rgba: new RegExp(\"rgba\" + PERMISSIVE_MATCH4),\n                hsl: new RegExp(\"hsl\" + PERMISSIVE_MATCH3),\n                hsla: new RegExp(\"hsla\" + PERMISSIVE_MATCH4),\n                hsv: new RegExp(\"hsv\" + PERMISSIVE_MATCH3),\n                hsva: new RegExp(\"hsva\" + PERMISSIVE_MATCH4),\n                hex3: /^([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n                hex6: /^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,\n                hex8: /^([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/\n            };\n        })();\n\n        // `stringInputToObject`\n        // Permissive string parsing.  Take in a number of formats, and output an object\n        // based on detected format.  Returns `{ r, g, b }` or `{ h, s, l }` or `{ h, s, v}`\n        function stringInputToObject(color) {\n\n            color = color.replace(trimLeft,'').replace(trimRight, '').toLowerCase();\n            var named = false;\n            if (names[color]) {\n                color = names[color];\n                named = true;\n            }\n            else if (color == 'transparent') {\n                return { r: 0, g: 0, b: 0, a: 0, format: \"name\" };\n            }\n\n            // Try to match string input using regular expressions.\n            // Keep most of the number bounding out of this function - don't worry about [0,1] or [0,100] or [0,360]\n            // Just return an object and let the conversion functions handle that.\n            // This way the result will be the same whether the tinycolor is initialized with string or object.\n            var match;\n            if ((match = matchers.rgb.exec(color))) {\n                return { r: match[1], g: match[2], b: match[3] };\n            }\n            if ((match = matchers.rgba.exec(color))) {\n                return { r: match[1], g: match[2], b: match[3], a: match[4] };\n            }\n            if ((match = matchers.hsl.exec(color))) {\n                return { h: match[1], s: match[2], l: match[3] };\n            }\n            if ((match = matchers.hsla.exec(color))) {\n                return { h: match[1], s: match[2], l: match[3], a: match[4] };\n            }\n            if ((match = matchers.hsv.exec(color))) {\n                return { h: match[1], s: match[2], v: match[3] };\n            }\n            if ((match = matchers.hsva.exec(color))) {\n                return { h: match[1], s: match[2], v: match[3], a: match[4] };\n            }\n            if ((match = matchers.hex8.exec(color))) {\n                return {\n                    a: convertHexToDecimal(match[1]),\n                    r: parseIntFromHex(match[2]),\n                    g: parseIntFromHex(match[3]),\n                    b: parseIntFromHex(match[4]),\n                    format: named ? \"name\" : \"hex8\"\n                };\n            }\n            if ((match = matchers.hex6.exec(color))) {\n                return {\n                    r: parseIntFromHex(match[1]),\n                    g: parseIntFromHex(match[2]),\n                    b: parseIntFromHex(match[3]),\n                    format: named ? \"name\" : \"hex\"\n                };\n            }\n            if ((match = matchers.hex3.exec(color))) {\n                return {\n                    r: parseIntFromHex(match[1] + '' + match[1]),\n                    g: parseIntFromHex(match[2] + '' + match[2]),\n                    b: parseIntFromHex(match[3] + '' + match[3]),\n                    format: named ? \"name\" : \"hex\"\n                };\n            }\n\n            return false;\n        }\n\n        window.tinycolor = tinycolor;\n    })();\n\n    $(function () {\n        if ($.fn.spectrum.load) {\n            $.fn.spectrum.processNativeColorInputs();\n        }\n    });\n\n});\n","jquery/spectrum/tinycolor.js":"// TinyColor v1.4.2\n// https://github.com/bgrins/TinyColor\n// Brian Grinstead, MIT License\n\n(function(Math) {\n\n    var trimLeft = /^\\s+/,\n        trimRight = /\\s+$/,\n        tinyCounter = 0,\n        mathRound = Math.round,\n        mathMin = Math.min,\n        mathMax = Math.max,\n        mathRandom = Math.random;\n\n    function tinycolor (color, opts) {\n\n        color = (color) ? color : '';\n        opts = opts || { };\n\n        // If input is already a tinycolor, return itself\n        if (color instanceof tinycolor) {\n            return color;\n        }\n        // If we are called as a function, call using new instead\n        if (!(this instanceof tinycolor)) {\n            return new tinycolor(color, opts);\n        }\n\n        var rgb = inputToRGB(color);\n        this._originalInput = color,\n            this._r = rgb.r,\n            this._g = rgb.g,\n            this._b = rgb.b,\n            this._a = rgb.a,\n            this._roundA = mathRound(100*this._a) / 100,\n            this._format = opts.format || rgb.format;\n        this._gradientType = opts.gradientType;\n\n        // Don't let the range of [0,255] come back in [0,1].\n        // Potentially lose a little bit of precision here, but will fix issues where\n        // .5 gets interpreted as half of the total, instead of half of 1\n        // If it was supposed to be 128, this was already taken care of by `inputToRgb`\n        if (this._r < 1) { this._r = mathRound(this._r); }\n        if (this._g < 1) { this._g = mathRound(this._g); }\n        if (this._b < 1) { this._b = mathRound(this._b); }\n\n        this._ok = rgb.ok;\n        this._tc_id = tinyCounter++;\n    }\n\n    tinycolor.prototype = {\n        isDark: function() {\n            return this.getBrightness() < 128;\n        },\n        isLight: function() {\n            return !this.isDark();\n        },\n        isValid: function() {\n            return this._ok;\n        },\n        getOriginalInput: function() {\n            return this._originalInput;\n        },\n        getFormat: function() {\n            return this._format;\n        },\n        getAlpha: function() {\n            return this._a;\n        },\n        getBrightness: function() {\n            //http://www.w3.org/TR/AERT#color-contrast\n            var rgb = this.toRgb();\n            return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1000;\n        },\n        getLuminance: function() {\n            //http://www.w3.org/TR/2008/REC-WCAG20-20081211/#relativeluminancedef\n            var rgb = this.toRgb();\n            var RsRGB, GsRGB, BsRGB, R, G, B;\n            RsRGB = rgb.r/255;\n            GsRGB = rgb.g/255;\n            BsRGB = rgb.b/255;\n\n            if (RsRGB <= 0.03928) {R = RsRGB / 12.92;} else {R = Math.pow(((RsRGB + 0.055) / 1.055), 2.4);}\n            if (GsRGB <= 0.03928) {G = GsRGB / 12.92;} else {G = Math.pow(((GsRGB + 0.055) / 1.055), 2.4);}\n            if (BsRGB <= 0.03928) {B = BsRGB / 12.92;} else {B = Math.pow(((BsRGB + 0.055) / 1.055), 2.4);}\n            return (0.2126 * R) + (0.7152 * G) + (0.0722 * B);\n        },\n        setAlpha: function(value) {\n            this._a = boundAlpha(value);\n            this._roundA = mathRound(100*this._a) / 100;\n            return this;\n        },\n        toHsv: function() {\n            var hsv = rgbToHsv(this._r, this._g, this._b);\n            return { h: hsv.h * 360, s: hsv.s, v: hsv.v, a: this._a };\n        },\n        toHsvString: function() {\n            var hsv = rgbToHsv(this._r, this._g, this._b);\n            var h = mathRound(hsv.h * 360), s = mathRound(hsv.s * 100), v = mathRound(hsv.v * 100);\n            return (this._a == 1) ?\n                \"hsv(\"  + h + \", \" + s + \"%, \" + v + \"%)\" :\n                \"hsva(\" + h + \", \" + s + \"%, \" + v + \"%, \"+ this._roundA + \")\";\n        },\n        toHsl: function() {\n            var hsl = rgbToHsl(this._r, this._g, this._b);\n            return { h: hsl.h * 360, s: hsl.s, l: hsl.l, a: this._a };\n        },\n        toHslString: function() {\n            var hsl = rgbToHsl(this._r, this._g, this._b);\n            var h = mathRound(hsl.h * 360), s = mathRound(hsl.s * 100), l = mathRound(hsl.l * 100);\n            return (this._a == 1) ?\n                \"hsl(\"  + h + \", \" + s + \"%, \" + l + \"%)\" :\n                \"hsla(\" + h + \", \" + s + \"%, \" + l + \"%, \"+ this._roundA + \")\";\n        },\n        toHex: function(allow3Char) {\n            return rgbToHex(this._r, this._g, this._b, allow3Char);\n        },\n        toHexString: function(allow3Char) {\n            return '#' + this.toHex(allow3Char);\n        },\n        toHex8: function(allow4Char) {\n            return rgbaToHex(this._r, this._g, this._b, this._a, allow4Char);\n        },\n        toHex8String: function(allow4Char) {\n            return '#' + this.toHex8(allow4Char);\n        },\n        toRgb: function() {\n            return { r: mathRound(this._r), g: mathRound(this._g), b: mathRound(this._b), a: this._a };\n        },\n        toRgbString: function() {\n            return (this._a == 1) ?\n                \"rgb(\"  + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \")\" :\n                \"rgba(\" + mathRound(this._r) + \", \" + mathRound(this._g) + \", \" + mathRound(this._b) + \", \" + this._roundA + \")\";\n        },\n        toPercentageRgb: function() {\n            return { r: mathRound(bound01(this._r, 255) * 100) + \"%\", g: mathRound(bound01(this._g, 255) * 100) + \"%\", b: mathRound(bound01(this._b, 255) * 100) + \"%\", a: this._a };\n        },\n        toPercentageRgbString: function() {\n            return (this._a == 1) ?\n                \"rgb(\"  + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%)\" :\n                \"rgba(\" + mathRound(bound01(this._r, 255) * 100) + \"%, \" + mathRound(bound01(this._g, 255) * 100) + \"%, \" + mathRound(bound01(this._b, 255) * 100) + \"%, \" + this._roundA + \")\";\n        },\n        toName: function() {\n            if (this._a === 0) {\n                return \"transparent\";\n            }\n\n            if (this._a < 1) {\n                return false;\n            }\n\n            return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;\n        },\n        toFilter: function(secondColor) {\n            var hex8String = '#' + rgbaToArgbHex(this._r, this._g, this._b, this._a);\n            var secondHex8String = hex8String;\n            var gradientType = this._gradientType ? \"GradientType = 1, \" : \"\";\n\n            if (secondColor) {\n                var s = tinycolor(secondColor);\n                secondHex8String = '#' + rgbaToArgbHex(s._r, s._g, s._b, s._a);\n            }\n\n            return \"progid:DXImageTransform.Microsoft.gradient(\"+gradientType+\"startColorstr=\"+hex8String+\",endColorstr=\"+secondHex8String+\")\";\n        },\n        toString: function(format) {\n            var formatSet = !!format;\n            format = format || this._format;\n\n            var formattedString = false;\n            var hasAlpha = this._a < 1 && this._a >= 0;\n            var needsAlphaFormat = !formatSet && hasAlpha && (format === \"hex\" || format === \"hex6\" || format === \"hex3\" || format === \"hex4\" || format === \"hex8\" || format === \"name\");\n\n            if (needsAlphaFormat) {\n                // Special case for \"transparent\", all other non-alpha formats\n                // will return rgba when there is transparency.\n                if (format === \"name\" && this._a === 0) {\n                    return this.toName();\n                }\n                return this.toRgbString();\n            }\n            if (format === \"rgb\") {\n                formattedString = this.toRgbString();\n            }\n            if (format === \"prgb\") {\n                formattedString = this.toPercentageRgbString();\n            }\n            if (format === \"hex\" || format === \"hex6\") {\n                formattedString = this.toHexString();\n            }\n            if (format === \"hex3\") {\n                formattedString = this.toHexString(true);\n            }\n            if (format === \"hex4\") {\n                formattedString = this.toHex8String(true);\n            }\n            if (format === \"hex8\") {\n                formattedString = this.toHex8String();\n            }\n            if (format === \"name\") {\n                formattedString = this.toName();\n            }\n            if (format === \"hsl\") {\n                formattedString = this.toHslString();\n            }\n            if (format === \"hsv\") {\n                formattedString = this.toHsvString();\n            }\n\n            return formattedString || this.toHexString();\n        },\n        clone: function() {\n            return tinycolor(this.toString());\n        },\n\n        _applyModification: function(fn, args) {\n            var color = fn.apply(null, [this].concat([].slice.call(args)));\n            this._r = color._r;\n            this._g = color._g;\n            this._b = color._b;\n            this.setAlpha(color._a);\n            return this;\n        },\n        lighten: function() {\n            return this._applyModification(lighten, arguments);\n        },\n        brighten: function() {\n            return this._applyModification(brighten, arguments);\n        },\n        darken: function() {\n            return this._applyModification(darken, arguments);\n        },\n        desaturate: function() {\n            return this._applyModification(desaturate, arguments);\n        },\n        saturate: function() {\n            return this._applyModification(saturate, arguments);\n        },\n        greyscale: function() {\n            return this._applyModification(greyscale, arguments);\n        },\n        spin: function() {\n            return this._applyModification(spin, arguments);\n        },\n\n        _applyCombination: function(fn, args) {\n            return fn.apply(null, [this].concat([].slice.call(args)));\n        },\n        analogous: function() {\n            return this._applyCombination(analogous, arguments);\n        },\n        complement: function() {\n            return this._applyCombination(complement, arguments);\n        },\n        monochromatic: function() {\n            return this._applyCombination(monochromatic, arguments);\n        },\n        splitcomplement: function() {\n            return this._applyCombination(splitcomplement, arguments);\n        },\n        triad: function() {\n            return this._applyCombination(triad, arguments);\n        },\n        tetrad: function() {\n            return this._applyCombination(tetrad, arguments);\n        }\n    };\n\n// If input is an object, force 1 into \"1.0\" to handle ratios properly\n// String input requires \"1.0\" as input, so 1 will be treated as 1\n    tinycolor.fromRatio = function(color, opts) {\n        if (typeof color == \"object\") {\n            var newColor = {};\n            for (var i in color) {\n                if (color.hasOwnProperty(i)) {\n                    if (i === \"a\") {\n                        newColor[i] = color[i];\n                    }\n                    else {\n                        newColor[i] = convertToPercentage(color[i]);\n                    }\n                }\n            }\n            color = newColor;\n        }\n\n        return tinycolor(color, opts);\n    };\n\n// Given a string or object, convert that input to RGB\n// Possible string inputs:\n//\n//     \"red\"\n//     \"#f00\" or \"f00\"\n//     \"#ff0000\" or \"ff0000\"\n//     \"#ff000000\" or \"ff000000\"\n//     \"rgb 255 0 0\" or \"rgb (255, 0, 0)\"\n//     \"rgb 1.0 0 0\" or \"rgb (1, 0, 0)\"\n//     \"rgba (255, 0, 0, 1)\" or \"rgba 255, 0, 0, 1\"\n//     \"rgba (1.0, 0, 0, 1)\" or \"rgba 1.0, 0, 0, 1\"\n//     \"hsl(0, 100%, 50%)\" or \"hsl 0 100% 50%\"\n//     \"hsla(0, 100%, 50%, 1)\" or \"hsla 0 100% 50%, 1\"\n//     \"hsv(0, 100%, 100%)\" or \"hsv 0 100% 100%\"\n//\n    function inputToRGB(color) {\n\n        var rgb = { r: 0, g: 0, b: 0 };\n        var a = 1;\n        var s = null;\n        var v = null;\n        var l = null;\n        var ok = false;\n        var format = false;\n\n        if (typeof color == \"string\") {\n            color = stringInputToObject(color);\n        }\n\n        if (typeof color == \"object\") {\n            if (isValidCSSUnit(color.r) && isValidCSSUnit(color.g) && isValidCSSUnit(color.b)) {\n                rgb = rgbToRgb(color.r, color.g, color.b);\n                ok = true;\n                format = String(color.r).substr(-1) === \"%\" ? \"prgb\" : \"rgb\";\n            }\n            else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.v)) {\n                s = convertToPercentage(color.s);\n                v = convertToPercentage(color.v);\n                rgb = hsvToRgb(color.h, s, v);\n                ok = true;\n                format = \"hsv\";\n            }\n            else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.l)) {\n                s = convertToPercentage(color.s);\n                l = convertToPercentage(color.l);\n                rgb = hslToRgb(color.h, s, l);\n                ok = true;\n                format = \"hsl\";\n            }\n\n            if (color.hasOwnProperty(\"a\")) {\n                a = color.a;\n            }\n        }\n\n        a = boundAlpha(a);\n\n        return {\n            ok: ok,\n            format: color.format || format,\n            r: mathMin(255, mathMax(rgb.r, 0)),\n            g: mathMin(255, mathMax(rgb.g, 0)),\n            b: mathMin(255, mathMax(rgb.b, 0)),\n            a: a\n        };\n    }\n\n\n// Conversion Functions\n// --------------------\n\n// `rgbToHsl`, `rgbToHsv`, `hslToRgb`, `hsvToRgb` modified from:\n// <http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript>\n\n// `rgbToRgb`\n// Handle bounds / percentage checking to conform to CSS color spec\n// <http://www.w3.org/TR/css3-color/>\n// *Assumes:* r, g, b in [0, 255] or [0, 1]\n// *Returns:* { r, g, b } in [0, 255]\n    function rgbToRgb(r, g, b){\n        return {\n            r: bound01(r, 255) * 255,\n            g: bound01(g, 255) * 255,\n            b: bound01(b, 255) * 255\n        };\n    }\n\n// `rgbToHsl`\n// Converts an RGB color value to HSL.\n// *Assumes:* r, g, and b are contained in [0, 255] or [0, 1]\n// *Returns:* { h, s, l } in [0,1]\n    function rgbToHsl(r, g, b) {\n\n        r = bound01(r, 255);\n        g = bound01(g, 255);\n        b = bound01(b, 255);\n\n        var max = mathMax(r, g, b), min = mathMin(r, g, b);\n        var h, s, l = (max + min) / 2;\n\n        if(max == min) {\n            h = s = 0; // achromatic\n        }\n        else {\n            var d = max - min;\n            s = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n            switch(max) {\n                case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                case g: h = (b - r) / d + 2; break;\n                case b: h = (r - g) / d + 4; break;\n            }\n\n            h /= 6;\n        }\n\n        return { h: h, s: s, l: l };\n    }\n\n// `hslToRgb`\n// Converts an HSL color value to RGB.\n// *Assumes:* h is contained in [0, 1] or [0, 360] and s and l are contained [0, 1] or [0, 100]\n// *Returns:* { r, g, b } in the set [0, 255]\n    function hslToRgb(h, s, l) {\n        var r, g, b;\n\n        h = bound01(h, 360);\n        s = bound01(s, 100);\n        l = bound01(l, 100);\n\n        function hue2rgb(p, q, t) {\n            if(t < 0) t += 1;\n            if(t > 1) t -= 1;\n            if(t < 1/6) return p + (q - p) * 6 * t;\n            if(t < 1/2) return q;\n            if(t < 2/3) return p + (q - p) * (2/3 - t) * 6;\n            return p;\n        }\n\n        if(s === 0) {\n            r = g = b = l; // achromatic\n        }\n        else {\n            var q = l < 0.5 ? l * (1 + s) : l + s - l * s;\n            var p = 2 * l - q;\n            r = hue2rgb(p, q, h + 1/3);\n            g = hue2rgb(p, q, h);\n            b = hue2rgb(p, q, h - 1/3);\n        }\n\n        return { r: r * 255, g: g * 255, b: b * 255 };\n    }\n\n// `rgbToHsv`\n// Converts an RGB color value to HSV\n// *Assumes:* r, g, and b are contained in the set [0, 255] or [0, 1]\n// *Returns:* { h, s, v } in [0,1]\n    function rgbToHsv(r, g, b) {\n\n        r = bound01(r, 255);\n        g = bound01(g, 255);\n        b = bound01(b, 255);\n\n        var max = mathMax(r, g, b), min = mathMin(r, g, b);\n        var h, s, v = max;\n\n        var d = max - min;\n        s = max === 0 ? 0 : d / max;\n\n        if(max == min) {\n            h = 0; // achromatic\n        }\n        else {\n            switch(max) {\n                case r: h = (g - b) / d + (g < b ? 6 : 0); break;\n                case g: h = (b - r) / d + 2; break;\n                case b: h = (r - g) / d + 4; break;\n            }\n            h /= 6;\n        }\n        return { h: h, s: s, v: v };\n    }\n\n// `hsvToRgb`\n// Converts an HSV color value to RGB.\n// *Assumes:* h is contained in [0, 1] or [0, 360] and s and v are contained in [0, 1] or [0, 100]\n// *Returns:* { r, g, b } in the set [0, 255]\n    function hsvToRgb(h, s, v) {\n\n        h = bound01(h, 360) * 6;\n        s = bound01(s, 100);\n        v = bound01(v, 100);\n\n        var i = Math.floor(h),\n            f = h - i,\n            p = v * (1 - s),\n            q = v * (1 - f * s),\n            t = v * (1 - (1 - f) * s),\n            mod = i % 6,\n            r = [v, q, p, p, t, v][mod],\n            g = [t, v, v, q, p, p][mod],\n            b = [p, p, t, v, v, q][mod];\n\n        return { r: r * 255, g: g * 255, b: b * 255 };\n    }\n\n// `rgbToHex`\n// Converts an RGB color to hex\n// Assumes r, g, and b are contained in the set [0, 255]\n// Returns a 3 or 6 character hex\n    function rgbToHex(r, g, b, allow3Char) {\n\n        var hex = [\n            pad2(mathRound(r).toString(16)),\n            pad2(mathRound(g).toString(16)),\n            pad2(mathRound(b).toString(16))\n        ];\n\n        // Return a 3 character hex if possible\n        if (allow3Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1)) {\n            return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);\n        }\n\n        return hex.join(\"\");\n    }\n\n// `rgbaToHex`\n// Converts an RGBA color plus alpha transparency to hex\n// Assumes r, g, b are contained in the set [0, 255] and\n// a in [0, 1]. Returns a 4 or 8 character rgba hex\n    function rgbaToHex(r, g, b, a, allow4Char) {\n\n        var hex = [\n            pad2(mathRound(r).toString(16)),\n            pad2(mathRound(g).toString(16)),\n            pad2(mathRound(b).toString(16)),\n            pad2(convertDecimalToHex(a))\n        ];\n\n        // Return a 4 character hex if possible\n        if (allow4Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1) && hex[3].charAt(0) == hex[3].charAt(1)) {\n            return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0) + hex[3].charAt(0);\n        }\n\n        return hex.join(\"\");\n    }\n\n// `rgbaToArgbHex`\n// Converts an RGBA color to an ARGB Hex8 string\n// Rarely used, but required for \"toFilter()\"\n    function rgbaToArgbHex(r, g, b, a) {\n\n        var hex = [\n            pad2(convertDecimalToHex(a)),\n            pad2(mathRound(r).toString(16)),\n            pad2(mathRound(g).toString(16)),\n            pad2(mathRound(b).toString(16))\n        ];\n\n        return hex.join(\"\");\n    }\n\n// `equals`\n// Can be called with any tinycolor input\n    tinycolor.equals = function (color1, color2) {\n        if (!color1 || !color2) { return false; }\n        return tinycolor(color1).toRgbString() == tinycolor(color2).toRgbString();\n    };\n\n    tinycolor.random = function() {\n        return tinycolor.fromRatio({\n            r: mathRandom(),\n            g: mathRandom(),\n            b: mathRandom()\n        });\n    };\n\n\n// Modification Functions\n// ----------------------\n// Thanks to less.js for some of the basics here\n// <https://github.com/cloudhead/less.js/blob/master/lib/less/functions.js>\n\n    function desaturate(color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var hsl = tinycolor(color).toHsl();\n        hsl.s -= amount / 100;\n        hsl.s = clamp01(hsl.s);\n        return tinycolor(hsl);\n    }\n\n    function saturate(color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var hsl = tinycolor(color).toHsl();\n        hsl.s += amount / 100;\n        hsl.s = clamp01(hsl.s);\n        return tinycolor(hsl);\n    }\n\n    function greyscale(color) {\n        return tinycolor(color).desaturate(100);\n    }\n\n    function lighten (color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var hsl = tinycolor(color).toHsl();\n        hsl.l += amount / 100;\n        hsl.l = clamp01(hsl.l);\n        return tinycolor(hsl);\n    }\n\n    function brighten(color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var rgb = tinycolor(color).toRgb();\n        rgb.r = mathMax(0, mathMin(255, rgb.r - mathRound(255 * - (amount / 100))));\n        rgb.g = mathMax(0, mathMin(255, rgb.g - mathRound(255 * - (amount / 100))));\n        rgb.b = mathMax(0, mathMin(255, rgb.b - mathRound(255 * - (amount / 100))));\n        return tinycolor(rgb);\n    }\n\n    function darken (color, amount) {\n        amount = (amount === 0) ? 0 : (amount || 10);\n        var hsl = tinycolor(color).toHsl();\n        hsl.l -= amount / 100;\n        hsl.l = clamp01(hsl.l);\n        return tinycolor(hsl);\n    }\n\n// Spin takes a positive or negative amount within [-360, 360] indicating the change of hue.\n// Values outside of this range will be wrapped into this range.\n    function spin(color, amount) {\n        var hsl = tinycolor(color).toHsl();\n        var hue = (hsl.h + amount) % 360;\n        hsl.h = hue < 0 ? 360 + hue : hue;\n        return tinycolor(hsl);\n    }\n\n// Combination Functions\n// ---------------------\n// Thanks to jQuery xColor for some of the ideas behind these\n// <https://github.com/infusion/jQuery-xcolor/blob/master/jquery.xcolor.js>\n\n    function complement(color) {\n        var hsl = tinycolor(color).toHsl();\n        hsl.h = (hsl.h + 180) % 360;\n        return tinycolor(hsl);\n    }\n\n    function triad(color) {\n        var hsl = tinycolor(color).toHsl();\n        var h = hsl.h;\n        return [\n            tinycolor(color),\n            tinycolor({ h: (h + 120) % 360, s: hsl.s, l: hsl.l }),\n            tinycolor({ h: (h + 240) % 360, s: hsl.s, l: hsl.l })\n        ];\n    }\n\n    function tetrad(color) {\n        var hsl = tinycolor(color).toHsl();\n        var h = hsl.h;\n        return [\n            tinycolor(color),\n            tinycolor({ h: (h + 90) % 360, s: hsl.s, l: hsl.l }),\n            tinycolor({ h: (h + 180) % 360, s: hsl.s, l: hsl.l }),\n            tinycolor({ h: (h + 270) % 360, s: hsl.s, l: hsl.l })\n        ];\n    }\n\n    function splitcomplement(color) {\n        var hsl = tinycolor(color).toHsl();\n        var h = hsl.h;\n        return [\n            tinycolor(color),\n            tinycolor({ h: (h + 72) % 360, s: hsl.s, l: hsl.l}),\n            tinycolor({ h: (h + 216) % 360, s: hsl.s, l: hsl.l})\n        ];\n    }\n\n    function analogous(color, results, slices) {\n        results = results || 6;\n        slices = slices || 30;\n\n        var hsl = tinycolor(color).toHsl();\n        var part = 360 / slices;\n        var ret = [tinycolor(color)];\n\n        for (hsl.h = ((hsl.h - (part * results >> 1)) + 720) % 360; --results; ) {\n            hsl.h = (hsl.h + part) % 360;\n            ret.push(tinycolor(hsl));\n        }\n        return ret;\n    }\n\n    function monochromatic(color, results) {\n        results = results || 6;\n        var hsv = tinycolor(color).toHsv();\n        var h = hsv.h, s = hsv.s, v = hsv.v;\n        var ret = [];\n        var modification = 1 / results;\n\n        while (results--) {\n            ret.push(tinycolor({ h: h, s: s, v: v}));\n            v = (v + modification) % 1;\n        }\n\n        return ret;\n    }\n\n// Utility Functions\n// ---------------------\n\n    tinycolor.mix = function(color1, color2, amount) {\n        amount = (amount === 0) ? 0 : (amount || 50);\n\n        var rgb1 = tinycolor(color1).toRgb();\n        var rgb2 = tinycolor(color2).toRgb();\n\n        var p = amount / 100;\n\n        var rgba = {\n            r: ((rgb2.r - rgb1.r) * p) + rgb1.r,\n            g: ((rgb2.g - rgb1.g) * p) + rgb1.g,\n            b: ((rgb2.b - rgb1.b) * p) + rgb1.b,\n            a: ((rgb2.a - rgb1.a) * p) + rgb1.a\n        };\n\n        return tinycolor(rgba);\n    };\n\n\n// Readability Functions\n// ---------------------\n// <http://www.w3.org/TR/2008/REC-WCAG20-20081211/#contrast-ratiodef (WCAG Version 2)\n\n// `contrast`\n// Analyze the 2 colors and returns the color contrast defined by (WCAG Version 2)\n    tinycolor.readability = function(color1, color2) {\n        var c1 = tinycolor(color1);\n        var c2 = tinycolor(color2);\n        return (Math.max(c1.getLuminance(),c2.getLuminance())+0.05) / (Math.min(c1.getLuminance(),c2.getLuminance())+0.05);\n    };\n\n// `isReadable`\n// Ensure that foreground and background color combinations meet WCAG2 guidelines.\n// The third argument is an optional Object.\n//      the 'level' property states 'AA' or 'AAA' - if missing or invalid, it defaults to 'AA';\n//      the 'size' property states 'large' or 'small' - if missing or invalid, it defaults to 'small'.\n// If the entire object is absent, isReadable defaults to {level:\"AA\",size:\"small\"}.\n\n// *Example*\n//    tinycolor.isReadable(\"#000\", \"#111\") => false\n//    tinycolor.isReadable(\"#000\", \"#111\",{level:\"AA\",size:\"large\"}) => false\n    tinycolor.isReadable = function(color1, color2, wcag2) {\n        var readability = tinycolor.readability(color1, color2);\n        var wcag2Parms, out;\n\n        out = false;\n\n        wcag2Parms = validateWCAG2Parms(wcag2);\n        switch (wcag2Parms.level + wcag2Parms.size) {\n            case \"AAsmall\":\n            case \"AAAlarge\":\n                out = readability >= 4.5;\n                break;\n            case \"AAlarge\":\n                out = readability >= 3;\n                break;\n            case \"AAAsmall\":\n                out = readability >= 7;\n                break;\n        }\n        return out;\n\n    };\n\n// `mostReadable`\n// Given a base color and a list of possible foreground or background\n// colors for that base, returns the most readable color.\n// Optionally returns Black or White if the most readable color is unreadable.\n// *Example*\n//    tinycolor.mostReadable(tinycolor.mostReadable(\"#123\", [\"#124\", \"#125\"],{includeFallbackColors:false}).toHexString(); // \"#112255\"\n//    tinycolor.mostReadable(tinycolor.mostReadable(\"#123\", [\"#124\", \"#125\"],{includeFallbackColors:true}).toHexString();  // \"#ffffff\"\n//    tinycolor.mostReadable(\"#a8015a\", [\"#faf3f3\"],{includeFallbackColors:true,level:\"AAA\",size:\"large\"}).toHexString(); // \"#faf3f3\"\n//    tinycolor.mostReadable(\"#a8015a\", [\"#faf3f3\"],{includeFallbackColors:true,level:\"AAA\",size:\"small\"}).toHexString(); // \"#ffffff\"\n    tinycolor.mostReadable = function(baseColor, colorList, args) {\n        var bestColor = null;\n        var bestScore = 0;\n        var readability;\n        var includeFallbackColors, level, size ;\n        args = args || {};\n        includeFallbackColors = args.includeFallbackColors ;\n        level = args.level;\n        size = args.size;\n\n        for (var i= 0; i < colorList.length ; i++) {\n            readability = tinycolor.readability(baseColor, colorList[i]);\n            if (readability > bestScore) {\n                bestScore = readability;\n                bestColor = tinycolor(colorList[i]);\n            }\n        }\n\n        if (tinycolor.isReadable(baseColor, bestColor, {\"level\":level,\"size\":size}) || !includeFallbackColors) {\n            return bestColor;\n        }\n        else {\n            args.includeFallbackColors=false;\n            return tinycolor.mostReadable(baseColor,[\"#fff\", \"#000\"],args);\n        }\n    };\n\n\n// Big List of Colors\n// ------------------\n// <http://www.w3.org/TR/css3-color/#svg-color>\n    var names = tinycolor.names = {\n        aliceblue: \"f0f8ff\",\n        antiquewhite: \"faebd7\",\n        aqua: \"0ff\",\n        aquamarine: \"7fffd4\",\n        azure: \"f0ffff\",\n        beige: \"f5f5dc\",\n        bisque: \"ffe4c4\",\n        black: \"000\",\n        blanchedalmond: \"ffebcd\",\n        blue: \"00f\",\n        blueviolet: \"8a2be2\",\n        brown: \"a52a2a\",\n        burlywood: \"deb887\",\n        burntsienna: \"ea7e5d\",\n        cadetblue: \"5f9ea0\",\n        chartreuse: \"7fff00\",\n        chocolate: \"d2691e\",\n        coral: \"ff7f50\",\n        cornflowerblue: \"6495ed\",\n        cornsilk: \"fff8dc\",\n        crimson: \"dc143c\",\n        cyan: \"0ff\",\n        darkblue: \"00008b\",\n        darkcyan: \"008b8b\",\n        darkgoldenrod: \"b8860b\",\n        darkgray: \"a9a9a9\",\n        darkgreen: \"006400\",\n        darkgrey: \"a9a9a9\",\n        darkkhaki: \"bdb76b\",\n        darkmagenta: \"8b008b\",\n        darkolivegreen: \"556b2f\",\n        darkorange: \"ff8c00\",\n        darkorchid: \"9932cc\",\n        darkred: \"8b0000\",\n        darksalmon: \"e9967a\",\n        darkseagreen: \"8fbc8f\",\n        darkslateblue: \"483d8b\",\n        darkslategray: \"2f4f4f\",\n        darkslategrey: \"2f4f4f\",\n        darkturquoise: \"00ced1\",\n        darkviolet: \"9400d3\",\n        deeppink: \"ff1493\",\n        deepskyblue: \"00bfff\",\n        dimgray: \"696969\",\n        dimgrey: \"696969\",\n        dodgerblue: \"1e90ff\",\n        firebrick: \"b22222\",\n        floralwhite: \"fffaf0\",\n        forestgreen: \"228b22\",\n        fuchsia: \"f0f\",\n        gainsboro: \"dcdcdc\",\n        ghostwhite: \"f8f8ff\",\n        gold: \"ffd700\",\n        goldenrod: \"daa520\",\n        gray: \"808080\",\n        green: \"008000\",\n        greenyellow: \"adff2f\",\n        grey: \"808080\",\n        honeydew: \"f0fff0\",\n        hotpink: \"ff69b4\",\n        indianred: \"cd5c5c\",\n        indigo: \"4b0082\",\n        ivory: \"fffff0\",\n        khaki: \"f0e68c\",\n        lavender: \"e6e6fa\",\n        lavenderblush: \"fff0f5\",\n        lawngreen: \"7cfc00\",\n        lemonchiffon: \"fffacd\",\n        lightblue: \"add8e6\",\n        lightcoral: \"f08080\",\n        lightcyan: \"e0ffff\",\n        lightgoldenrodyellow: \"fafad2\",\n        lightgray: \"d3d3d3\",\n        lightgreen: \"90ee90\",\n        lightgrey: \"d3d3d3\",\n        lightpink: \"ffb6c1\",\n        lightsalmon: \"ffa07a\",\n        lightseagreen: \"20b2aa\",\n        lightskyblue: \"87cefa\",\n        lightslategray: \"789\",\n        lightslategrey: \"789\",\n        lightsteelblue: \"b0c4de\",\n        lightyellow: \"ffffe0\",\n        lime: \"0f0\",\n        limegreen: \"32cd32\",\n        linen: \"faf0e6\",\n        magenta: \"f0f\",\n        maroon: \"800000\",\n        mediumaquamarine: \"66cdaa\",\n        mediumblue: \"0000cd\",\n        mediumorchid: \"ba55d3\",\n        mediumpurple: \"9370db\",\n        mediumseagreen: \"3cb371\",\n        mediumslateblue: \"7b68ee\",\n        mediumspringgreen: \"00fa9a\",\n        mediumturquoise: \"48d1cc\",\n        mediumvioletred: \"c71585\",\n        midnightblue: \"191970\",\n        mintcream: \"f5fffa\",\n        mistyrose: \"ffe4e1\",\n        moccasin: \"ffe4b5\",\n        navajowhite: \"ffdead\",\n        navy: \"000080\",\n        oldlace: \"fdf5e6\",\n        olive: \"808000\",\n        olivedrab: \"6b8e23\",\n        orange: \"ffa500\",\n        orangered: \"ff4500\",\n        orchid: \"da70d6\",\n        palegoldenrod: \"eee8aa\",\n        palegreen: \"98fb98\",\n        paleturquoise: \"afeeee\",\n        palevioletred: \"db7093\",\n        papayawhip: \"ffefd5\",\n        peachpuff: \"ffdab9\",\n        peru: \"cd853f\",\n        pink: \"ffc0cb\",\n        plum: \"dda0dd\",\n        powderblue: \"b0e0e6\",\n        purple: \"800080\",\n        rebeccapurple: \"663399\",\n        red: \"f00\",\n        rosybrown: \"bc8f8f\",\n        royalblue: \"4169e1\",\n        saddlebrown: \"8b4513\",\n        salmon: \"fa8072\",\n        sandybrown: \"f4a460\",\n        seagreen: \"2e8b57\",\n        seashell: \"fff5ee\",\n        sienna: \"a0522d\",\n        silver: \"c0c0c0\",\n        skyblue: \"87ceeb\",\n        slateblue: \"6a5acd\",\n        slategray: \"708090\",\n        slategrey: \"708090\",\n        snow: \"fffafa\",\n        springgreen: \"00ff7f\",\n        steelblue: \"4682b4\",\n        tan: \"d2b48c\",\n        teal: \"008080\",\n        thistle: \"d8bfd8\",\n        tomato: \"ff6347\",\n        turquoise: \"40e0d0\",\n        violet: \"ee82ee\",\n        wheat: \"f5deb3\",\n        white: \"fff\",\n        whitesmoke: \"f5f5f5\",\n        yellow: \"ff0\",\n        yellowgreen: \"9acd32\"\n    };\n\n// Make it easy to access colors via `hexNames[hex]`\n    var hexNames = tinycolor.hexNames = flip(names);\n\n\n// Utilities\n// ---------\n\n// `{ 'name1': 'val1' }` becomes `{ 'val1': 'name1' }`\n    function flip(o) {\n        var flipped = { };\n        for (var i in o) {\n            if (o.hasOwnProperty(i)) {\n                flipped[o[i]] = i;\n            }\n        }\n        return flipped;\n    }\n\n// Return a valid alpha value [0,1] with all invalid values being set to 1\n    function boundAlpha(a) {\n        a = parseFloat(a);\n\n        if (isNaN(a) || a < 0 || a > 1) {\n            a = 1;\n        }\n\n        return a;\n    }\n\n// Take input from [0, n] and return it as [0, 1]\n    function bound01(n, max) {\n        if (isOnePointZero(n)) { n = \"100%\"; }\n\n        var processPercent = isPercentage(n);\n        n = mathMin(max, mathMax(0, parseFloat(n)));\n\n        // Automatically convert percentage into number\n        if (processPercent) {\n            n = parseInt(n * max, 10) / 100;\n        }\n\n        // Handle floating point rounding errors\n        if ((Math.abs(n - max) < 0.000001)) {\n            return 1;\n        }\n\n        // Convert into [0, 1] range if it isn't already\n        return (n % max) / parseFloat(max);\n    }\n\n// Force a number between 0 and 1\n    function clamp01(val) {\n        return mathMin(1, mathMax(0, val));\n    }\n\n// Parse a base-16 hex value into a base-10 integer\n    function parseIntFromHex(val) {\n        return parseInt(val, 16);\n    }\n\n// Need to handle 1.0 as 100%, since once it is a number, there is no difference between it and 1\n// <http://stackoverflow.com/questions/7422072/javascript-how-to-detect-number-as-a-decimal-including-1-0>\n    function isOnePointZero(n) {\n        return typeof n == \"string\" && n.indexOf('.') != -1 && parseFloat(n) === 1;\n    }\n\n// Check to see if string passed in is a percentage\n    function isPercentage(n) {\n        return typeof n === \"string\" && n.indexOf('%') != -1;\n    }\n\n// Force a hex value to have 2 characters\n    function pad2(c) {\n        return c.length == 1 ? '0' + c : '' + c;\n    }\n\n// Replace a decimal with it's percentage value\n    function convertToPercentage(n) {\n        if (n <= 1) {\n            n = (n * 100) + \"%\";\n        }\n\n        return n;\n    }\n\n// Converts a decimal to a hex value\n    function convertDecimalToHex(d) {\n        return Math.round(parseFloat(d) * 255).toString(16);\n    }\n// Converts a hex value to a decimal\n    function convertHexToDecimal(h) {\n        return (parseIntFromHex(h) / 255);\n    }\n\n    var matchers = (function() {\n\n        // <http://www.w3.org/TR/css3-values/#integers>\n        var CSS_INTEGER = \"[-\\\\+]?\\\\d+%?\";\n\n        // <http://www.w3.org/TR/css3-values/#number-value>\n        var CSS_NUMBER = \"[-\\\\+]?\\\\d*\\\\.\\\\d+%?\";\n\n        // Allow positive/negative integer/number.  Don't capture the either/or, just the entire outcome.\n        var CSS_UNIT = \"(?:\" + CSS_NUMBER + \")|(?:\" + CSS_INTEGER + \")\";\n\n        // Actual matching.\n        // Parentheses and commas are optional, but not required.\n        // Whitespace can take the place of commas or opening paren\n        var PERMISSIVE_MATCH3 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n        var PERMISSIVE_MATCH4 = \"[\\\\s|\\\\(]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")[,|\\\\s]+(\" + CSS_UNIT + \")\\\\s*\\\\)?\";\n\n        return {\n            CSS_UNIT: new RegExp(CSS_UNIT),\n            rgb: new RegExp(\"rgb\" + PERMISSIVE_MATCH3),\n            rgba: new RegExp(\"rgba\" + PERMISSIVE_MATCH4),\n            hsl: new RegExp(\"hsl\" + PERMISSIVE_MATCH3),\n            hsla: new RegExp(\"hsla\" + PERMISSIVE_MATCH4),\n            hsv: new RegExp(\"hsv\" + PERMISSIVE_MATCH3),\n            hsva: new RegExp(\"hsva\" + PERMISSIVE_MATCH4),\n            hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n            hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,\n            hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,\n            hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/\n        };\n    })();\n\n// `isValidCSSUnit`\n// Take in a single string / number and check to see if it looks like a CSS unit\n// (see `matchers` above for definition).\n    function isValidCSSUnit(color) {\n        return !!matchers.CSS_UNIT.exec(color);\n    }\n\n// `stringInputToObject`\n// Permissive string parsing.  Take in a number of formats, and output an object\n// based on detected format.  Returns `{ r, g, b }` or `{ h, s, l }` or `{ h, s, v}`\n    function stringInputToObject(color) {\n\n        color = color.replace(trimLeft,'').replace(trimRight, '').toLowerCase();\n        var named = false;\n        if (names[color]) {\n            color = names[color];\n            named = true;\n        }\n        else if (color == 'transparent') {\n            return { r: 0, g: 0, b: 0, a: 0, format: \"name\" };\n        }\n\n        // Try to match string input using regular expressions.\n        // Keep most of the number bounding out of this function - don't worry about [0,1] or [0,100] or [0,360]\n        // Just return an object and let the conversion functions handle that.\n        // This way the result will be the same whether the tinycolor is initialized with string or object.\n        var match;\n        if ((match = matchers.rgb.exec(color))) {\n            return { r: match[1], g: match[2], b: match[3] };\n        }\n        if ((match = matchers.rgba.exec(color))) {\n            return { r: match[1], g: match[2], b: match[3], a: match[4] };\n        }\n        if ((match = matchers.hsl.exec(color))) {\n            return { h: match[1], s: match[2], l: match[3] };\n        }\n        if ((match = matchers.hsla.exec(color))) {\n            return { h: match[1], s: match[2], l: match[3], a: match[4] };\n        }\n        if ((match = matchers.hsv.exec(color))) {\n            return { h: match[1], s: match[2], v: match[3] };\n        }\n        if ((match = matchers.hsva.exec(color))) {\n            return { h: match[1], s: match[2], v: match[3], a: match[4] };\n        }\n        if ((match = matchers.hex8.exec(color))) {\n            return {\n                r: parseIntFromHex(match[1]),\n                g: parseIntFromHex(match[2]),\n                b: parseIntFromHex(match[3]),\n                a: convertHexToDecimal(match[4]),\n                format: named ? \"name\" : \"hex8\"\n            };\n        }\n        if ((match = matchers.hex6.exec(color))) {\n            return {\n                r: parseIntFromHex(match[1]),\n                g: parseIntFromHex(match[2]),\n                b: parseIntFromHex(match[3]),\n                format: named ? \"name\" : \"hex\"\n            };\n        }\n        if ((match = matchers.hex4.exec(color))) {\n            return {\n                r: parseIntFromHex(match[1] + '' + match[1]),\n                g: parseIntFromHex(match[2] + '' + match[2]),\n                b: parseIntFromHex(match[3] + '' + match[3]),\n                a: convertHexToDecimal(match[4] + '' + match[4]),\n                format: named ? \"name\" : \"hex8\"\n            };\n        }\n        if ((match = matchers.hex3.exec(color))) {\n            return {\n                r: parseIntFromHex(match[1] + '' + match[1]),\n                g: parseIntFromHex(match[2] + '' + match[2]),\n                b: parseIntFromHex(match[3] + '' + match[3]),\n                format: named ? \"name\" : \"hex\"\n            };\n        }\n\n        return false;\n    }\n\n    function validateWCAG2Parms(parms) {\n        // return valid WCAG2 parms for isReadable.\n        // If input parms are invalid, return {\"level\":\"AA\", \"size\":\"small\"}\n        var level, size;\n        parms = parms || {\"level\":\"AA\", \"size\":\"small\"};\n        level = (parms.level || \"AA\").toUpperCase();\n        size = (parms.size || \"small\").toLowerCase();\n        if (level !== \"AA\" && level !== \"AAA\") {\n            level = \"AA\";\n        }\n        if (size !== \"small\" && size !== \"large\") {\n            size = \"small\";\n        }\n        return {\"level\":level, \"size\":size};\n    }\n\n// Node: Export function\n    if (typeof module !== \"undefined\" && module.exports) {\n        module.exports = tinycolor;\n    }\n// AMD/requirejs: Define the module\n    else if (typeof define === 'function' && define.amd) {\n        define(function () {return tinycolor;});\n    }\n// Browser: Expose to window\n    else {\n        window.tinycolor = tinycolor;\n    }\n\n})(Math);\n","jquery/ui-modules/core.js":"// This file is deprecated in 1.12.0 to be removed in 1.14\n( function() {\n\"use strict\";\n\ndefine( [\n\t\"jquery\",\n\t\"./data\",\n\t\"./disable-selection\",\n\t\"./focusable\",\n\t\"./form\",\n\t\"./ie\",\n\t\"./keycode\",\n\t\"./labels\",\n\t\"./jquery-patch\",\n\t\"./plugin\",\n\t\"./safe-active-element\",\n\t\"./safe-blur\",\n\t\"./scroll-parent\",\n\t\"./tabbable\",\n\t\"./unique-id\",\n\t\"./version\"\n] );\n} )();\n","jquery/ui-modules/data.js":"/*!\n * jQuery UI :data 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: :data Selector\n//>>group: Core\n//>>description: Selects elements which have data stored under the specified key.\n//>>docs: http://api.jqueryui.com/data-selector/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.extend( $.expr.pseudos, {\n\tdata: $.expr.createPseudo ?\n\t\t$.expr.createPseudo( function( dataName ) {\n\t\t\treturn function( elem ) {\n\t\t\t\treturn !!$.data( elem, dataName );\n\t\t\t};\n\t\t} ) :\n\n\t\t// Support: jQuery <1.8\n\t\tfunction( elem, i, match ) {\n\t\t\treturn !!$.data( elem, match[ 3 ] );\n\t\t}\n} );\n} );\n","jquery/ui-modules/disable-selection.js":"/*!\n * jQuery UI Disable Selection 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: disableSelection\n//>>group: Core\n//>>description: Disable selection of text content within the set of matched elements.\n//>>docs: http://api.jqueryui.com/disableSelection/\n\n// This file is deprecated\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.fn.extend( {\n\tdisableSelection: ( function() {\n\t\tvar eventType = \"onselectstart\" in document.createElement( \"div\" ) ?\n\t\t\t\"selectstart\" :\n\t\t\t\"mousedown\";\n\n\t\treturn function() {\n\t\t\treturn this.on( eventType + \".ui-disableSelection\", function( event ) {\n\t\t\t\tevent.preventDefault();\n\t\t\t} );\n\t\t};\n\t} )(),\n\n\tenableSelection: function() {\n\t\treturn this.off( \".ui-disableSelection\" );\n\t}\n} );\n\n} );\n","jquery/ui-modules/effect.js":"/*!\n * jQuery UI Effects 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Effects Core\n//>>group: Effects\n/* eslint-disable max-len */\n//>>description: Extends the internal jQuery effects. Includes morphing and easing. Required by all other effects.\n/* eslint-enable max-len */\n//>>docs: http://api.jqueryui.com/category/effects-core/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"./jquery-var-for-color\",\n\t\t\t\"./vendor/jquery-color/jquery.color\",\n\t\t\t\"./version\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nvar dataSpace = \"ui-effects-\",\n\tdataSpaceStyle = \"ui-effects-style\",\n\tdataSpaceAnimated = \"ui-effects-animated\";\n\n$.effects = {\n\teffect: {}\n};\n\n/******************************************************************************/\n/****************************** CLASS ANIMATIONS ******************************/\n/******************************************************************************/\n( function() {\n\nvar classAnimationActions = [ \"add\", \"remove\", \"toggle\" ],\n\tshorthandStyles = {\n\t\tborder: 1,\n\t\tborderBottom: 1,\n\t\tborderColor: 1,\n\t\tborderLeft: 1,\n\t\tborderRight: 1,\n\t\tborderTop: 1,\n\t\tborderWidth: 1,\n\t\tmargin: 1,\n\t\tpadding: 1\n\t};\n\n$.each(\n\t[ \"borderLeftStyle\", \"borderRightStyle\", \"borderBottomStyle\", \"borderTopStyle\" ],\n\tfunction( _, prop ) {\n\t\t$.fx.step[ prop ] = function( fx ) {\n\t\t\tif ( fx.end !== \"none\" && !fx.setAttr || fx.pos === 1 && !fx.setAttr ) {\n\t\t\t\tjQuery.style( fx.elem, prop, fx.end );\n\t\t\t\tfx.setAttr = true;\n\t\t\t}\n\t\t};\n\t}\n);\n\nfunction camelCase( string ) {\n\treturn string.replace( /-([\\da-z])/gi, function( all, letter ) {\n\t\treturn letter.toUpperCase();\n\t} );\n}\n\nfunction getElementStyles( elem ) {\n\tvar key, len,\n\t\tstyle = elem.ownerDocument.defaultView ?\n\t\t\telem.ownerDocument.defaultView.getComputedStyle( elem, null ) :\n\t\t\telem.currentStyle,\n\t\tstyles = {};\n\n\tif ( style && style.length && style[ 0 ] && style[ style[ 0 ] ] ) {\n\t\tlen = style.length;\n\t\twhile ( len-- ) {\n\t\t\tkey = style[ len ];\n\t\t\tif ( typeof style[ key ] === \"string\" ) {\n\t\t\t\tstyles[ camelCase( key ) ] = style[ key ];\n\t\t\t}\n\t\t}\n\n\t// Support: Opera, IE <9\n\t} else {\n\t\tfor ( key in style ) {\n\t\t\tif ( typeof style[ key ] === \"string\" ) {\n\t\t\t\tstyles[ key ] = style[ key ];\n\t\t\t}\n\t\t}\n\t}\n\n\treturn styles;\n}\n\nfunction styleDifference( oldStyle, newStyle ) {\n\tvar diff = {},\n\t\tname, value;\n\n\tfor ( name in newStyle ) {\n\t\tvalue = newStyle[ name ];\n\t\tif ( oldStyle[ name ] !== value ) {\n\t\t\tif ( !shorthandStyles[ name ] ) {\n\t\t\t\tif ( $.fx.step[ name ] || !isNaN( parseFloat( value ) ) ) {\n\t\t\t\t\tdiff[ name ] = value;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n\treturn diff;\n}\n\n// Support: jQuery <1.8\nif ( !$.fn.addBack ) {\n\t$.fn.addBack = function( selector ) {\n\t\treturn this.add( selector == null ?\n\t\t\tthis.prevObject : this.prevObject.filter( selector )\n\t\t);\n\t};\n}\n\n$.effects.animateClass = function( value, duration, easing, callback ) {\n\tvar o = $.speed( duration, easing, callback );\n\n\treturn this.queue( function() {\n\t\tvar animated = $( this ),\n\t\t\tbaseClass = animated.attr( \"class\" ) || \"\",\n\t\t\tapplyClassChange,\n\t\t\tallAnimations = o.children ? animated.find( \"*\" ).addBack() : animated;\n\n\t\t// Map the animated objects to store the original styles.\n\t\tallAnimations = allAnimations.map( function() {\n\t\t\tvar el = $( this );\n\t\t\treturn {\n\t\t\t\tel: el,\n\t\t\t\tstart: getElementStyles( this )\n\t\t\t};\n\t\t} );\n\n\t\t// Apply class change\n\t\tapplyClassChange = function() {\n\t\t\t$.each( classAnimationActions, function( i, action ) {\n\t\t\t\tif ( value[ action ] ) {\n\t\t\t\t\tanimated[ action + \"Class\" ]( value[ action ] );\n\t\t\t\t}\n\t\t\t} );\n\t\t};\n\t\tapplyClassChange();\n\n\t\t// Map all animated objects again - calculate new styles and diff\n\t\tallAnimations = allAnimations.map( function() {\n\t\t\tthis.end = getElementStyles( this.el[ 0 ] );\n\t\t\tthis.diff = styleDifference( this.start, this.end );\n\t\t\treturn this;\n\t\t} );\n\n\t\t// Apply original class\n\t\tanimated.attr( \"class\", baseClass );\n\n\t\t// Map all animated objects again - this time collecting a promise\n\t\tallAnimations = allAnimations.map( function() {\n\t\t\tvar styleInfo = this,\n\t\t\t\tdfd = $.Deferred(),\n\t\t\t\topts = $.extend( {}, o, {\n\t\t\t\t\tqueue: false,\n\t\t\t\t\tcomplete: function() {\n\t\t\t\t\t\tdfd.resolve( styleInfo );\n\t\t\t\t\t}\n\t\t\t\t} );\n\n\t\t\tthis.el.animate( this.diff, opts );\n\t\t\treturn dfd.promise();\n\t\t} );\n\n\t\t// Once all animations have completed:\n\t\t$.when.apply( $, allAnimations.get() ).done( function() {\n\n\t\t\t// Set the final class\n\t\t\tapplyClassChange();\n\n\t\t\t// For each animated element,\n\t\t\t// clear all css properties that were animated\n\t\t\t$.each( arguments, function() {\n\t\t\t\tvar el = this.el;\n\t\t\t\t$.each( this.diff, function( key ) {\n\t\t\t\t\tel.css( key, \"\" );\n\t\t\t\t} );\n\t\t\t} );\n\n\t\t\t// This is guarnteed to be there if you use jQuery.speed()\n\t\t\t// it also handles dequeuing the next anim...\n\t\t\to.complete.call( animated[ 0 ] );\n\t\t} );\n\t} );\n};\n\n$.fn.extend( {\n\taddClass: ( function( orig ) {\n\t\treturn function( classNames, speed, easing, callback ) {\n\t\t\treturn speed ?\n\t\t\t\t$.effects.animateClass.call( this,\n\t\t\t\t\t{ add: classNames }, speed, easing, callback ) :\n\t\t\t\torig.apply( this, arguments );\n\t\t};\n\t} )( $.fn.addClass ),\n\n\tremoveClass: ( function( orig ) {\n\t\treturn function( classNames, speed, easing, callback ) {\n\t\t\treturn arguments.length > 1 ?\n\t\t\t\t$.effects.animateClass.call( this,\n\t\t\t\t\t{ remove: classNames }, speed, easing, callback ) :\n\t\t\t\torig.apply( this, arguments );\n\t\t};\n\t} )( $.fn.removeClass ),\n\n\ttoggleClass: ( function( orig ) {\n\t\treturn function( classNames, force, speed, easing, callback ) {\n\t\t\tif ( typeof force === \"boolean\" || force === undefined ) {\n\t\t\t\tif ( !speed ) {\n\n\t\t\t\t\t// Without speed parameter\n\t\t\t\t\treturn orig.apply( this, arguments );\n\t\t\t\t} else {\n\t\t\t\t\treturn $.effects.animateClass.call( this,\n\t\t\t\t\t\t( force ? { add: classNames } : { remove: classNames } ),\n\t\t\t\t\t\tspeed, easing, callback );\n\t\t\t\t}\n\t\t\t} else {\n\n\t\t\t\t// Without force parameter\n\t\t\t\treturn $.effects.animateClass.call( this,\n\t\t\t\t\t{ toggle: classNames }, force, speed, easing );\n\t\t\t}\n\t\t};\n\t} )( $.fn.toggleClass ),\n\n\tswitchClass: function( remove, add, speed, easing, callback ) {\n\t\treturn $.effects.animateClass.call( this, {\n\t\t\tadd: add,\n\t\t\tremove: remove\n\t\t}, speed, easing, callback );\n\t}\n} );\n\n} )();\n\n/******************************************************************************/\n/*********************************** EFFECTS **********************************/\n/******************************************************************************/\n\n( function() {\n\nif ( $.expr && $.expr.pseudos && $.expr.pseudos.animated ) {\n\t$.expr.pseudos.animated = ( function( orig ) {\n\t\treturn function( elem ) {\n\t\t\treturn !!$( elem ).data( dataSpaceAnimated ) || orig( elem );\n\t\t};\n\t} )( $.expr.pseudos.animated );\n}\n\nif ( $.uiBackCompat !== false ) {\n\t$.extend( $.effects, {\n\n\t\t// Saves a set of properties in a data storage\n\t\tsave: function( element, set ) {\n\t\t\tvar i = 0, length = set.length;\n\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\tif ( set[ i ] !== null ) {\n\t\t\t\t\telement.data( dataSpace + set[ i ], element[ 0 ].style[ set[ i ] ] );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t// Restores a set of previously saved properties from a data storage\n\t\trestore: function( element, set ) {\n\t\t\tvar val, i = 0, length = set.length;\n\t\t\tfor ( ; i < length; i++ ) {\n\t\t\t\tif ( set[ i ] !== null ) {\n\t\t\t\t\tval = element.data( dataSpace + set[ i ] );\n\t\t\t\t\telement.css( set[ i ], val );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tsetMode: function( el, mode ) {\n\t\t\tif ( mode === \"toggle\" ) {\n\t\t\t\tmode = el.is( \":hidden\" ) ? \"show\" : \"hide\";\n\t\t\t}\n\t\t\treturn mode;\n\t\t},\n\n\t\t// Wraps the element around a wrapper that copies position properties\n\t\tcreateWrapper: function( element ) {\n\n\t\t\t// If the element is already wrapped, return it\n\t\t\tif ( element.parent().is( \".ui-effects-wrapper\" ) ) {\n\t\t\t\treturn element.parent();\n\t\t\t}\n\n\t\t\t// Wrap the element\n\t\t\tvar props = {\n\t\t\t\t\twidth: element.outerWidth( true ),\n\t\t\t\t\theight: element.outerHeight( true ),\n\t\t\t\t\t\"float\": element.css( \"float\" )\n\t\t\t\t},\n\t\t\t\twrapper = $( \"<div></div>\" )\n\t\t\t\t\t.addClass( \"ui-effects-wrapper\" )\n\t\t\t\t\t.css( {\n\t\t\t\t\t\tfontSize: \"100%\",\n\t\t\t\t\t\tbackground: \"transparent\",\n\t\t\t\t\t\tborder: \"none\",\n\t\t\t\t\t\tmargin: 0,\n\t\t\t\t\t\tpadding: 0\n\t\t\t\t\t} ),\n\n\t\t\t\t// Store the size in case width/height are defined in % - Fixes #5245\n\t\t\t\tsize = {\n\t\t\t\t\twidth: element.width(),\n\t\t\t\t\theight: element.height()\n\t\t\t\t},\n\t\t\t\tactive = document.activeElement;\n\n\t\t\t// Support: Firefox\n\t\t\t// Firefox incorrectly exposes anonymous content\n\t\t\t// https://bugzilla.mozilla.org/show_bug.cgi?id=561664\n\t\t\ttry {\n\t\t\t\t// eslint-disable-next-line no-unused-expressions\n\t\t\t\tactive.id;\n\t\t\t} catch ( e ) {\n\t\t\t\tactive = document.body;\n\t\t\t}\n\n\t\t\telement.wrap( wrapper );\n\n\t\t\t// Fixes #7595 - Elements lose focus when wrapped.\n\t\t\tif ( element[ 0 ] === active || $.contains( element[ 0 ], active ) ) {\n\t\t\t\t$( active ).trigger( \"focus\" );\n\t\t\t}\n\n\t\t\t// Hotfix for jQuery 1.4 since some change in wrap() seems to actually\n\t\t\t// lose the reference to the wrapped element\n\t\t\twrapper = element.parent();\n\n\t\t\t// Transfer positioning properties to the wrapper\n\t\t\tif ( element.css( \"position\" ) === \"static\" ) {\n\t\t\t\twrapper.css( { position: \"relative\" } );\n\t\t\t\telement.css( { position: \"relative\" } );\n\t\t\t} else {\n\t\t\t\t$.extend( props, {\n\t\t\t\t\tposition: element.css( \"position\" ),\n\t\t\t\t\tzIndex: element.css( \"z-index\" )\n\t\t\t\t} );\n\t\t\t\t$.each( [ \"top\", \"left\", \"bottom\", \"right\" ], function( i, pos ) {\n\t\t\t\t\tprops[ pos ] = element.css( pos );\n\t\t\t\t\tif ( isNaN( parseInt( props[ pos ], 10 ) ) ) {\n\t\t\t\t\t\tprops[ pos ] = \"auto\";\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t\telement.css( {\n\t\t\t\t\tposition: \"relative\",\n\t\t\t\t\ttop: 0,\n\t\t\t\t\tleft: 0,\n\t\t\t\t\tright: \"auto\",\n\t\t\t\t\tbottom: \"auto\"\n\t\t\t\t} );\n\t\t\t}\n\t\t\telement.css( size );\n\n\t\t\treturn wrapper.css( props ).show();\n\t\t},\n\n\t\tremoveWrapper: function( element ) {\n\t\t\tvar active = document.activeElement;\n\n\t\t\tif ( element.parent().is( \".ui-effects-wrapper\" ) ) {\n\t\t\t\telement.parent().replaceWith( element );\n\n\t\t\t\t// Fixes #7595 - Elements lose focus when wrapped.\n\t\t\t\tif ( element[ 0 ] === active || $.contains( element[ 0 ], active ) ) {\n\t\t\t\t\t$( active ).trigger( \"focus\" );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\treturn element;\n\t\t}\n\t} );\n}\n\n$.extend( $.effects, {\n\tversion: \"1.13.1\",\n\n\tdefine: function( name, mode, effect ) {\n\t\tif ( !effect ) {\n\t\t\teffect = mode;\n\t\t\tmode = \"effect\";\n\t\t}\n\n\t\t$.effects.effect[ name ] = effect;\n\t\t$.effects.effect[ name ].mode = mode;\n\n\t\treturn effect;\n\t},\n\n\tscaledDimensions: function( element, percent, direction ) {\n\t\tif ( percent === 0 ) {\n\t\t\treturn {\n\t\t\t\theight: 0,\n\t\t\t\twidth: 0,\n\t\t\t\touterHeight: 0,\n\t\t\t\touterWidth: 0\n\t\t\t};\n\t\t}\n\n\t\tvar x = direction !== \"horizontal\" ? ( ( percent || 100 ) / 100 ) : 1,\n\t\t\ty = direction !== \"vertical\" ? ( ( percent || 100 ) / 100 ) : 1;\n\n\t\treturn {\n\t\t\theight: element.height() * y,\n\t\t\twidth: element.width() * x,\n\t\t\touterHeight: element.outerHeight() * y,\n\t\t\touterWidth: element.outerWidth() * x\n\t\t};\n\n\t},\n\n\tclipToBox: function( animation ) {\n\t\treturn {\n\t\t\twidth: animation.clip.right - animation.clip.left,\n\t\t\theight: animation.clip.bottom - animation.clip.top,\n\t\t\tleft: animation.clip.left,\n\t\t\ttop: animation.clip.top\n\t\t};\n\t},\n\n\t// Injects recently queued functions to be first in line (after \"inprogress\")\n\tunshift: function( element, queueLength, count ) {\n\t\tvar queue = element.queue();\n\n\t\tif ( queueLength > 1 ) {\n\t\t\tqueue.splice.apply( queue,\n\t\t\t\t[ 1, 0 ].concat( queue.splice( queueLength, count ) ) );\n\t\t}\n\t\telement.dequeue();\n\t},\n\n\tsaveStyle: function( element ) {\n\t\telement.data( dataSpaceStyle, element[ 0 ].style.cssText );\n\t},\n\n\trestoreStyle: function( element ) {\n\t\telement[ 0 ].style.cssText = element.data( dataSpaceStyle ) || \"\";\n\t\telement.removeData( dataSpaceStyle );\n\t},\n\n\tmode: function( element, mode ) {\n\t\tvar hidden = element.is( \":hidden\" );\n\n\t\tif ( mode === \"toggle\" ) {\n\t\t\tmode = hidden ? \"show\" : \"hide\";\n\t\t}\n\t\tif ( hidden ? mode === \"hide\" : mode === \"show\" ) {\n\t\t\tmode = \"none\";\n\t\t}\n\t\treturn mode;\n\t},\n\n\t// Translates a [top,left] array into a baseline value\n\tgetBaseline: function( origin, original ) {\n\t\tvar y, x;\n\n\t\tswitch ( origin[ 0 ] ) {\n\t\tcase \"top\":\n\t\t\ty = 0;\n\t\t\tbreak;\n\t\tcase \"middle\":\n\t\t\ty = 0.5;\n\t\t\tbreak;\n\t\tcase \"bottom\":\n\t\t\ty = 1;\n\t\t\tbreak;\n\t\tdefault:\n\t\t\ty = origin[ 0 ] / original.height;\n\t\t}\n\n\t\tswitch ( origin[ 1 ] ) {\n\t\tcase \"left\":\n\t\t\tx = 0;\n\t\t\tbreak;\n\t\tcase \"center\":\n\t\t\tx = 0.5;\n\t\t\tbreak;\n\t\tcase \"right\":\n\t\t\tx = 1;\n\t\t\tbreak;\n\t\tdefault:\n\t\t\tx = origin[ 1 ] / original.width;\n\t\t}\n\n\t\treturn {\n\t\t\tx: x,\n\t\t\ty: y\n\t\t};\n\t},\n\n\t// Creates a placeholder element so that the original element can be made absolute\n\tcreatePlaceholder: function( element ) {\n\t\tvar placeholder,\n\t\t\tcssPosition = element.css( \"position\" ),\n\t\t\tposition = element.position();\n\n\t\t// Lock in margins first to account for form elements, which\n\t\t// will change margin if you explicitly set height\n\t\t// see: http://jsfiddle.net/JZSMt/3/ https://bugs.webkit.org/show_bug.cgi?id=107380\n\t\t// Support: Safari\n\t\telement.css( {\n\t\t\tmarginTop: element.css( \"marginTop\" ),\n\t\t\tmarginBottom: element.css( \"marginBottom\" ),\n\t\t\tmarginLeft: element.css( \"marginLeft\" ),\n\t\t\tmarginRight: element.css( \"marginRight\" )\n\t\t} )\n\t\t.outerWidth( element.outerWidth() )\n\t\t.outerHeight( element.outerHeight() );\n\n\t\tif ( /^(static|relative)/.test( cssPosition ) ) {\n\t\t\tcssPosition = \"absolute\";\n\n\t\t\tplaceholder = $( \"<\" + element[ 0 ].nodeName + \">\" ).insertAfter( element ).css( {\n\n\t\t\t\t// Convert inline to inline block to account for inline elements\n\t\t\t\t// that turn to inline block based on content (like img)\n\t\t\t\tdisplay: /^(inline|ruby)/.test( element.css( \"display\" ) ) ?\n\t\t\t\t\t\"inline-block\" :\n\t\t\t\t\t\"block\",\n\t\t\t\tvisibility: \"hidden\",\n\n\t\t\t\t// Margins need to be set to account for margin collapse\n\t\t\t\tmarginTop: element.css( \"marginTop\" ),\n\t\t\t\tmarginBottom: element.css( \"marginBottom\" ),\n\t\t\t\tmarginLeft: element.css( \"marginLeft\" ),\n\t\t\t\tmarginRight: element.css( \"marginRight\" ),\n\t\t\t\t\"float\": element.css( \"float\" )\n\t\t\t} )\n\t\t\t.outerWidth( element.outerWidth() )\n\t\t\t.outerHeight( element.outerHeight() )\n\t\t\t.addClass( \"ui-effects-placeholder\" );\n\n\t\t\telement.data( dataSpace + \"placeholder\", placeholder );\n\t\t}\n\n\t\telement.css( {\n\t\t\tposition: cssPosition,\n\t\t\tleft: position.left,\n\t\t\ttop: position.top\n\t\t} );\n\n\t\treturn placeholder;\n\t},\n\n\tremovePlaceholder: function( element ) {\n\t\tvar dataKey = dataSpace + \"placeholder\",\n\t\t\t\tplaceholder = element.data( dataKey );\n\n\t\tif ( placeholder ) {\n\t\t\tplaceholder.remove();\n\t\t\telement.removeData( dataKey );\n\t\t}\n\t},\n\n\t// Removes a placeholder if it exists and restores\n\t// properties that were modified during placeholder creation\n\tcleanUp: function( element ) {\n\t\t$.effects.restoreStyle( element );\n\t\t$.effects.removePlaceholder( element );\n\t},\n\n\tsetTransition: function( element, list, factor, value ) {\n\t\tvalue = value || {};\n\t\t$.each( list, function( i, x ) {\n\t\t\tvar unit = element.cssUnit( x );\n\t\t\tif ( unit[ 0 ] > 0 ) {\n\t\t\t\tvalue[ x ] = unit[ 0 ] * factor + unit[ 1 ];\n\t\t\t}\n\t\t} );\n\t\treturn value;\n\t}\n} );\n\n// Return an effect options object for the given parameters:\nfunction _normalizeArguments( effect, options, speed, callback ) {\n\n\t// Allow passing all options as the first parameter\n\tif ( $.isPlainObject( effect ) ) {\n\t\toptions = effect;\n\t\teffect = effect.effect;\n\t}\n\n\t// Convert to an object\n\teffect = { effect: effect };\n\n\t// Catch (effect, null, ...)\n\tif ( options == null ) {\n\t\toptions = {};\n\t}\n\n\t// Catch (effect, callback)\n\tif ( typeof options === \"function\" ) {\n\t\tcallback = options;\n\t\tspeed = null;\n\t\toptions = {};\n\t}\n\n\t// Catch (effect, speed, ?)\n\tif ( typeof options === \"number\" || $.fx.speeds[ options ] ) {\n\t\tcallback = speed;\n\t\tspeed = options;\n\t\toptions = {};\n\t}\n\n\t// Catch (effect, options, callback)\n\tif ( typeof speed === \"function\" ) {\n\t\tcallback = speed;\n\t\tspeed = null;\n\t}\n\n\t// Add options to effect\n\tif ( options ) {\n\t\t$.extend( effect, options );\n\t}\n\n\tspeed = speed || options.duration;\n\teffect.duration = $.fx.off ? 0 :\n\t\ttypeof speed === \"number\" ? speed :\n\t\tspeed in $.fx.speeds ? $.fx.speeds[ speed ] :\n\t\t$.fx.speeds._default;\n\n\teffect.complete = callback || options.complete;\n\n\treturn effect;\n}\n\nfunction standardAnimationOption( option ) {\n\n\t// Valid standard speeds (nothing, number, named speed)\n\tif ( !option || typeof option === \"number\" || $.fx.speeds[ option ] ) {\n\t\treturn true;\n\t}\n\n\t// Invalid strings - treat as \"normal\" speed\n\tif ( typeof option === \"string\" && !$.effects.effect[ option ] ) {\n\t\treturn true;\n\t}\n\n\t// Complete callback\n\tif ( typeof option === \"function\" ) {\n\t\treturn true;\n\t}\n\n\t// Options hash (but not naming an effect)\n\tif ( typeof option === \"object\" && !option.effect ) {\n\t\treturn true;\n\t}\n\n\t// Didn't match any standard API\n\treturn false;\n}\n\n$.fn.extend( {\n\teffect: function( /* effect, options, speed, callback */ ) {\n\t\tvar args = _normalizeArguments.apply( this, arguments ),\n\t\t\teffectMethod = $.effects.effect[ args.effect ],\n\t\t\tdefaultMode = effectMethod.mode,\n\t\t\tqueue = args.queue,\n\t\t\tqueueName = queue || \"fx\",\n\t\t\tcomplete = args.complete,\n\t\t\tmode = args.mode,\n\t\t\tmodes = [],\n\t\t\tprefilter = function( next ) {\n\t\t\t\tvar el = $( this ),\n\t\t\t\t\tnormalizedMode = $.effects.mode( el, mode ) || defaultMode;\n\n\t\t\t\t// Sentinel for duck-punching the :animated pseudo-selector\n\t\t\t\tel.data( dataSpaceAnimated, true );\n\n\t\t\t\t// Save effect mode for later use,\n\t\t\t\t// we can't just call $.effects.mode again later,\n\t\t\t\t// as the .show() below destroys the initial state\n\t\t\t\tmodes.push( normalizedMode );\n\n\t\t\t\t// See $.uiBackCompat inside of run() for removal of defaultMode in 1.14\n\t\t\t\tif ( defaultMode && ( normalizedMode === \"show\" ||\n\t\t\t\t\t\t( normalizedMode === defaultMode && normalizedMode === \"hide\" ) ) ) {\n\t\t\t\t\tel.show();\n\t\t\t\t}\n\n\t\t\t\tif ( !defaultMode || normalizedMode !== \"none\" ) {\n\t\t\t\t\t$.effects.saveStyle( el );\n\t\t\t\t}\n\n\t\t\t\tif ( typeof next === \"function\" ) {\n\t\t\t\t\tnext();\n\t\t\t\t}\n\t\t\t};\n\n\t\tif ( $.fx.off || !effectMethod ) {\n\n\t\t\t// Delegate to the original method (e.g., .show()) if possible\n\t\t\tif ( mode ) {\n\t\t\t\treturn this[ mode ]( args.duration, complete );\n\t\t\t} else {\n\t\t\t\treturn this.each( function() {\n\t\t\t\t\tif ( complete ) {\n\t\t\t\t\t\tcomplete.call( this );\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t}\n\t\t}\n\n\t\tfunction run( next ) {\n\t\t\tvar elem = $( this );\n\n\t\t\tfunction cleanup() {\n\t\t\t\telem.removeData( dataSpaceAnimated );\n\n\t\t\t\t$.effects.cleanUp( elem );\n\n\t\t\t\tif ( args.mode === \"hide\" ) {\n\t\t\t\t\telem.hide();\n\t\t\t\t}\n\n\t\t\t\tdone();\n\t\t\t}\n\n\t\t\tfunction done() {\n\t\t\t\tif ( typeof complete === \"function\" ) {\n\t\t\t\t\tcomplete.call( elem[ 0 ] );\n\t\t\t\t}\n\n\t\t\t\tif ( typeof next === \"function\" ) {\n\t\t\t\t\tnext();\n\t\t\t\t}\n\t\t\t}\n\n\t\t\t// Override mode option on a per element basis,\n\t\t\t// as toggle can be either show or hide depending on element state\n\t\t\targs.mode = modes.shift();\n\n\t\t\tif ( $.uiBackCompat !== false && !defaultMode ) {\n\t\t\t\tif ( elem.is( \":hidden\" ) ? mode === \"hide\" : mode === \"show\" ) {\n\n\t\t\t\t\t// Call the core method to track \"olddisplay\" properly\n\t\t\t\t\telem[ mode ]();\n\t\t\t\t\tdone();\n\t\t\t\t} else {\n\t\t\t\t\teffectMethod.call( elem[ 0 ], args, done );\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tif ( args.mode === \"none\" ) {\n\n\t\t\t\t\t// Call the core method to track \"olddisplay\" properly\n\t\t\t\t\telem[ mode ]();\n\t\t\t\t\tdone();\n\t\t\t\t} else {\n\t\t\t\t\teffectMethod.call( elem[ 0 ], args, cleanup );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\t// Run prefilter on all elements first to ensure that\n\t\t// any showing or hiding happens before placeholder creation,\n\t\t// which ensures that any layout changes are correctly captured.\n\t\treturn queue === false ?\n\t\t\tthis.each( prefilter ).each( run ) :\n\t\t\tthis.queue( queueName, prefilter ).queue( queueName, run );\n\t},\n\n\tshow: ( function( orig ) {\n\t\treturn function( option ) {\n\t\t\tif ( standardAnimationOption( option ) ) {\n\t\t\t\treturn orig.apply( this, arguments );\n\t\t\t} else {\n\t\t\t\tvar args = _normalizeArguments.apply( this, arguments );\n\t\t\t\targs.mode = \"show\";\n\t\t\t\treturn this.effect.call( this, args );\n\t\t\t}\n\t\t};\n\t} )( $.fn.show ),\n\n\thide: ( function( orig ) {\n\t\treturn function( option ) {\n\t\t\tif ( standardAnimationOption( option ) ) {\n\t\t\t\treturn orig.apply( this, arguments );\n\t\t\t} else {\n\t\t\t\tvar args = _normalizeArguments.apply( this, arguments );\n\t\t\t\targs.mode = \"hide\";\n\t\t\t\treturn this.effect.call( this, args );\n\t\t\t}\n\t\t};\n\t} )( $.fn.hide ),\n\n\ttoggle: ( function( orig ) {\n\t\treturn function( option ) {\n\t\t\tif ( standardAnimationOption( option ) || typeof option === \"boolean\" ) {\n\t\t\t\treturn orig.apply( this, arguments );\n\t\t\t} else {\n\t\t\t\tvar args = _normalizeArguments.apply( this, arguments );\n\t\t\t\targs.mode = \"toggle\";\n\t\t\t\treturn this.effect.call( this, args );\n\t\t\t}\n\t\t};\n\t} )( $.fn.toggle ),\n\n\tcssUnit: function( key ) {\n\t\tvar style = this.css( key ),\n\t\t\tval = [];\n\n\t\t$.each( [ \"em\", \"px\", \"%\", \"pt\" ], function( i, unit ) {\n\t\t\tif ( style.indexOf( unit ) > 0 ) {\n\t\t\t\tval = [ parseFloat( style ), unit ];\n\t\t\t}\n\t\t} );\n\t\treturn val;\n\t},\n\n\tcssClip: function( clipObj ) {\n\t\tif ( clipObj ) {\n\t\t\treturn this.css( \"clip\", \"rect(\" + clipObj.top + \"px \" + clipObj.right + \"px \" +\n\t\t\t\tclipObj.bottom + \"px \" + clipObj.left + \"px)\" );\n\t\t}\n\t\treturn parseClip( this.css( \"clip\" ), this );\n\t},\n\n\ttransfer: function( options, done ) {\n\t\tvar element = $( this ),\n\t\t\ttarget = $( options.to ),\n\t\t\ttargetFixed = target.css( \"position\" ) === \"fixed\",\n\t\t\tbody = $( \"body\" ),\n\t\t\tfixTop = targetFixed ? body.scrollTop() : 0,\n\t\t\tfixLeft = targetFixed ? body.scrollLeft() : 0,\n\t\t\tendPosition = target.offset(),\n\t\t\tanimation = {\n\t\t\t\ttop: endPosition.top - fixTop,\n\t\t\t\tleft: endPosition.left - fixLeft,\n\t\t\t\theight: target.innerHeight(),\n\t\t\t\twidth: target.innerWidth()\n\t\t\t},\n\t\t\tstartPosition = element.offset(),\n\t\t\ttransfer = $( \"<div class='ui-effects-transfer'></div>\" );\n\n\t\ttransfer\n\t\t\t.appendTo( \"body\" )\n\t\t\t.addClass( options.className )\n\t\t\t.css( {\n\t\t\t\ttop: startPosition.top - fixTop,\n\t\t\t\tleft: startPosition.left - fixLeft,\n\t\t\t\theight: element.innerHeight(),\n\t\t\t\twidth: element.innerWidth(),\n\t\t\t\tposition: targetFixed ? \"fixed\" : \"absolute\"\n\t\t\t} )\n\t\t\t.animate( animation, options.duration, options.easing, function() {\n\t\t\t\ttransfer.remove();\n\t\t\t\tif ( typeof done === \"function\" ) {\n\t\t\t\t\tdone();\n\t\t\t\t}\n\t\t\t} );\n\t}\n} );\n\nfunction parseClip( str, element ) {\n\t\tvar outerWidth = element.outerWidth(),\n\t\t\touterHeight = element.outerHeight(),\n\t\t\tclipRegex = /^rect\\((-?\\d*\\.?\\d*px|-?\\d+%|auto),?\\s*(-?\\d*\\.?\\d*px|-?\\d+%|auto),?\\s*(-?\\d*\\.?\\d*px|-?\\d+%|auto),?\\s*(-?\\d*\\.?\\d*px|-?\\d+%|auto)\\)$/,\n\t\t\tvalues = clipRegex.exec( str ) || [ \"\", 0, outerWidth, outerHeight, 0 ];\n\n\t\treturn {\n\t\t\ttop: parseFloat( values[ 1 ] ) || 0,\n\t\t\tright: values[ 2 ] === \"auto\" ? outerWidth : parseFloat( values[ 2 ] ),\n\t\t\tbottom: values[ 3 ] === \"auto\" ? outerHeight : parseFloat( values[ 3 ] ),\n\t\t\tleft: parseFloat( values[ 4 ] ) || 0\n\t\t};\n}\n\n$.fx.step.clip = function( fx ) {\n\tif ( !fx.clipInit ) {\n\t\tfx.start = $( fx.elem ).cssClip();\n\t\tif ( typeof fx.end === \"string\" ) {\n\t\t\tfx.end = parseClip( fx.end, fx.elem );\n\t\t}\n\t\tfx.clipInit = true;\n\t}\n\n\t$( fx.elem ).cssClip( {\n\t\ttop: fx.pos * ( fx.end.top - fx.start.top ) + fx.start.top,\n\t\tright: fx.pos * ( fx.end.right - fx.start.right ) + fx.start.right,\n\t\tbottom: fx.pos * ( fx.end.bottom - fx.start.bottom ) + fx.start.bottom,\n\t\tleft: fx.pos * ( fx.end.left - fx.start.left ) + fx.start.left\n\t} );\n};\n\n} )();\n\n/******************************************************************************/\n/*********************************** EASING ***********************************/\n/******************************************************************************/\n\n( function() {\n\n// Based on easing equations from Robert Penner (http://www.robertpenner.com/easing)\n\nvar baseEasings = {};\n\n$.each( [ \"Quad\", \"Cubic\", \"Quart\", \"Quint\", \"Expo\" ], function( i, name ) {\n\tbaseEasings[ name ] = function( p ) {\n\t\treturn Math.pow( p, i + 2 );\n\t};\n} );\n\n$.extend( baseEasings, {\n\tSine: function( p ) {\n\t\treturn 1 - Math.cos( p * Math.PI / 2 );\n\t},\n\tCirc: function( p ) {\n\t\treturn 1 - Math.sqrt( 1 - p * p );\n\t},\n\tElastic: function( p ) {\n\t\treturn p === 0 || p === 1 ? p :\n\t\t\t-Math.pow( 2, 8 * ( p - 1 ) ) * Math.sin( ( ( p - 1 ) * 80 - 7.5 ) * Math.PI / 15 );\n\t},\n\tBack: function( p ) {\n\t\treturn p * p * ( 3 * p - 2 );\n\t},\n\tBounce: function( p ) {\n\t\tvar pow2,\n\t\t\tbounce = 4;\n\n\t\twhile ( p < ( ( pow2 = Math.pow( 2, --bounce ) ) - 1 ) / 11 ) {}\n\t\treturn 1 / Math.pow( 4, 3 - bounce ) - 7.5625 * Math.pow( ( pow2 * 3 - 2 ) / 22 - p, 2 );\n\t}\n} );\n\n$.each( baseEasings, function( name, easeIn ) {\n\t$.easing[ \"easeIn\" + name ] = easeIn;\n\t$.easing[ \"easeOut\" + name ] = function( p ) {\n\t\treturn 1 - easeIn( 1 - p );\n\t};\n\t$.easing[ \"easeInOut\" + name ] = function( p ) {\n\t\treturn p < 0.5 ?\n\t\t\teaseIn( p * 2 ) / 2 :\n\t\t\t1 - easeIn( p * -2 + 2 ) / 2;\n\t};\n} );\n\n} )();\n\nreturn $.effects;\n\n} );\n","jquery/ui-modules/focusable.js":"/*!\n * jQuery UI Focusable 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: :focusable Selector\n//>>group: Core\n//>>description: Selects elements which can be focused.\n//>>docs: http://api.jqueryui.com/focusable-selector/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n// Selectors\n$.ui.focusable = function( element, hasTabindex ) {\n\tvar map, mapName, img, focusableIfVisible, fieldset,\n\t\tnodeName = element.nodeName.toLowerCase();\n\n\tif ( \"area\" === nodeName ) {\n\t\tmap = element.parentNode;\n\t\tmapName = map.name;\n\t\tif ( !element.href || !mapName || map.nodeName.toLowerCase() !== \"map\" ) {\n\t\t\treturn false;\n\t\t}\n\t\timg = $( \"img[usemap='#\" + mapName + \"']\" );\n\t\treturn img.length > 0 && img.is( \":visible\" );\n\t}\n\n\tif ( /^(input|select|textarea|button|object)$/.test( nodeName ) ) {\n\t\tfocusableIfVisible = !element.disabled;\n\n\t\tif ( focusableIfVisible ) {\n\n\t\t\t// Form controls within a disabled fieldset are disabled.\n\t\t\t// However, controls within the fieldset's legend do not get disabled.\n\t\t\t// Since controls generally aren't placed inside legends, we skip\n\t\t\t// this portion of the check.\n\t\t\tfieldset = $( element ).closest( \"fieldset\" )[ 0 ];\n\t\t\tif ( fieldset ) {\n\t\t\t\tfocusableIfVisible = !fieldset.disabled;\n\t\t\t}\n\t\t}\n\t} else if ( \"a\" === nodeName ) {\n\t\tfocusableIfVisible = element.href || hasTabindex;\n\t} else {\n\t\tfocusableIfVisible = hasTabindex;\n\t}\n\n\treturn focusableIfVisible && $( element ).is( \":visible\" ) && visible( $( element ) );\n};\n\n// Support: IE 8 only\n// IE 8 doesn't resolve inherit to visible/hidden for computed values\nfunction visible( element ) {\n\tvar visibility = element.css( \"visibility\" );\n\twhile ( visibility === \"inherit\" ) {\n\t\telement = element.parent();\n\t\tvisibility = element.css( \"visibility\" );\n\t}\n\treturn visibility === \"visible\";\n}\n\n$.extend( $.expr.pseudos, {\n\tfocusable: function( element ) {\n\t\treturn $.ui.focusable( element, $.attr( element, \"tabindex\" ) != null );\n\t}\n} );\n\nreturn $.ui.focusable;\n\n} );\n","jquery/ui-modules/form-reset-mixin.js":"/*!\n * jQuery UI Form Reset Mixin 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Form Reset Mixin\n//>>group: Core\n//>>description: Refresh input widgets when their form is reset\n//>>docs: http://api.jqueryui.com/form-reset-mixin/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"./form\",\n\t\t\t\"./version\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.ui.formResetMixin = {\n\t_formResetHandler: function() {\n\t\tvar form = $( this );\n\n\t\t// Wait for the form reset to actually happen before refreshing\n\t\tsetTimeout( function() {\n\t\t\tvar instances = form.data( \"ui-form-reset-instances\" );\n\t\t\t$.each( instances, function() {\n\t\t\t\tthis.refresh();\n\t\t\t} );\n\t\t} );\n\t},\n\n\t_bindFormResetHandler: function() {\n\t\tthis.form = this.element._form();\n\t\tif ( !this.form.length ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar instances = this.form.data( \"ui-form-reset-instances\" ) || [];\n\t\tif ( !instances.length ) {\n\n\t\t\t// We don't use _on() here because we use a single event handler per form\n\t\t\tthis.form.on( \"reset.ui-form-reset\", this._formResetHandler );\n\t\t}\n\t\tinstances.push( this );\n\t\tthis.form.data( \"ui-form-reset-instances\", instances );\n\t},\n\n\t_unbindFormResetHandler: function() {\n\t\tif ( !this.form.length ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar instances = this.form.data( \"ui-form-reset-instances\" );\n\t\tinstances.splice( $.inArray( this, instances ), 1 );\n\t\tif ( instances.length ) {\n\t\t\tthis.form.data( \"ui-form-reset-instances\", instances );\n\t\t} else {\n\t\t\tthis.form\n\t\t\t\t.removeData( \"ui-form-reset-instances\" )\n\t\t\t\t.off( \"reset.ui-form-reset\" );\n\t\t}\n\t}\n};\n\n} );\n","jquery/ui-modules/form.js":"( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n// Support: IE8 Only\n// IE8 does not support the form attribute and when it is supplied. It overwrites the form prop\n// with a string, so we need to find the proper form.\nreturn $.fn._form = function() {\n\treturn typeof this[ 0 ].form === \"string\" ? this.closest( \"form\" ) : $( this[ 0 ].form );\n};\n\n} );\n","jquery/ui-modules/ie.js":"( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n// This file is deprecated\nreturn $.ui.ie = !!/msie [\\w.]+/.exec( navigator.userAgent.toLowerCase() );\n} );\n","jquery/ui-modules/jquery-patch.js":"/*!\n * jQuery UI Support for jQuery core 1.8.x and newer 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n */\n\n//>>label: jQuery 1.8+ Support\n//>>group: Core\n//>>description: Support version 1.8.x and newer of jQuery core\n\n( function( factory ) {\n\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n// Support: jQuery 1.9.x or older\n// $.expr[ \":\" ] is deprecated.\nif ( !$.expr.pseudos ) {\n\t$.expr.pseudos = $.expr[ \":\" ];\n}\n\n// Support: jQuery 1.11.x or older\n// $.unique has been renamed to $.uniqueSort\nif ( !$.uniqueSort ) {\n\t$.uniqueSort = $.unique;\n}\n\n// Support: jQuery 2.2.x or older.\n// This method has been defined in jQuery 3.0.0.\n// Code from https://github.com/jquery/jquery/blob/e539bac79e666bba95bba86d690b4e609dca2286/src/selector/escapeSelector.js\nif ( !$.escapeSelector ) {\n\n\t// CSS string/identifier serialization\n\t// https://drafts.csswg.org/cssom/#common-serializing-idioms\n\tvar rcssescape = /([\\0-\\x1f\\x7f]|^-?\\d)|^-$|[^\\x80-\\uFFFF\\w-]/g;\n\n\tvar fcssescape = function( ch, asCodePoint ) {\n\t\tif ( asCodePoint ) {\n\n\t\t\t// U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER\n\t\t\tif ( ch === \"\\0\" ) {\n\t\t\t\treturn \"\\uFFFD\";\n\t\t\t}\n\n\t\t\t// Control characters and (dependent upon position) numbers get escaped as code points\n\t\t\treturn ch.slice( 0, -1 ) + \"\\\\\" + ch.charCodeAt( ch.length - 1 ).toString( 16 ) + \" \";\n\t\t}\n\n\t\t// Other potentially-special ASCII characters get backslash-escaped\n\t\treturn \"\\\\\" + ch;\n\t};\n\n\t$.escapeSelector = function( sel ) {\n\t\treturn ( sel + \"\" ).replace( rcssescape, fcssescape );\n\t};\n}\n\n// Support: jQuery 3.4.x or older\n// These methods have been defined in jQuery 3.5.0.\nif ( !$.fn.even || !$.fn.odd ) {\n\t$.fn.extend( {\n\t\teven: function() {\n\t\t\treturn this.filter( function( i ) {\n\t\t\t\treturn i % 2 === 0;\n\t\t\t} );\n\t\t},\n\t\todd: function() {\n\t\t\treturn this.filter( function( i ) {\n\t\t\t\treturn i % 2 === 1;\n\t\t\t} );\n\t\t}\n\t} );\n}\n\n} );\n","jquery/ui-modules/jquery-var-for-color.js":"( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\t\"use strict\";\n\n// Create a local jQuery because jQuery Color relies on it and the\n// global may not exist with AMD and a custom build (#10199).\n// This module is a noop if used as a regular AMD module.\n// eslint-disable-next-line no-unused-vars\nvar jQuery = $;\n\n} );\n","jquery/ui-modules/keycode.js":"/*!\n * jQuery UI Keycode 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Keycode\n//>>group: Core\n//>>description: Provide keycodes as keynames\n//>>docs: http://api.jqueryui.com/jQuery.ui.keyCode/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.ui.keyCode = {\n\tBACKSPACE: 8,\n\tCOMMA: 188,\n\tDELETE: 46,\n\tDOWN: 40,\n\tEND: 35,\n\tENTER: 13,\n\tESCAPE: 27,\n\tHOME: 36,\n\tLEFT: 37,\n\tPAGE_DOWN: 34,\n\tPAGE_UP: 33,\n\tPERIOD: 190,\n\tRIGHT: 39,\n\tSPACE: 32,\n\tTAB: 9,\n\tUP: 38\n};\n\n} );\n","jquery/ui-modules/labels.js":"/*!\n * jQuery UI Labels 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: labels\n//>>group: Core\n//>>description: Find all the labels associated with a given input\n//>>docs: http://api.jqueryui.com/labels/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.fn.labels = function() {\n\tvar ancestor, selector, id, labels, ancestors;\n\n\tif ( !this.length ) {\n\t\treturn this.pushStack( [] );\n\t}\n\n\t// Check control.labels first\n\tif ( this[ 0 ].labels && this[ 0 ].labels.length ) {\n\t\treturn this.pushStack( this[ 0 ].labels );\n\t}\n\n\t// Support: IE <= 11, FF <= 37, Android <= 2.3 only\n\t// Above browsers do not support control.labels. Everything below is to support them\n\t// as well as document fragments. control.labels does not work on document fragments\n\tlabels = this.eq( 0 ).parents( \"label\" );\n\n\t// Look for the label based on the id\n\tid = this.attr( \"id\" );\n\tif ( id ) {\n\n\t\t// We don't search against the document in case the element\n\t\t// is disconnected from the DOM\n\t\tancestor = this.eq( 0 ).parents().last();\n\n\t\t// Get a full set of top level ancestors\n\t\tancestors = ancestor.add( ancestor.length ? ancestor.siblings() : this.siblings() );\n\n\t\t// Create a selector for the label based on the id\n\t\tselector = \"label[for='\" + $.escapeSelector( id ) + \"']\";\n\n\t\tlabels = labels.add( ancestors.find( selector ).addBack( selector ) );\n\n\t}\n\n\t// Return whatever we have found for labels\n\treturn this.pushStack( labels );\n};\n\n} );\n","jquery/ui-modules/plugin.js":"( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n// $.ui.plugin is deprecated. Use $.widget() extensions instead.\nreturn $.ui.plugin = {\n\tadd: function( module, option, set ) {\n\t\tvar i,\n\t\t\tproto = $.ui[ module ].prototype;\n\t\tfor ( i in set ) {\n\t\t\tproto.plugins[ i ] = proto.plugins[ i ] || [];\n\t\t\tproto.plugins[ i ].push( [ option, set[ i ] ] );\n\t\t}\n\t},\n\tcall: function( instance, name, args, allowDisconnected ) {\n\t\tvar i,\n\t\t\tset = instance.plugins[ name ];\n\n\t\tif ( !set ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( !allowDisconnected && ( !instance.element[ 0 ].parentNode ||\n\t\t\t\tinstance.element[ 0 ].parentNode.nodeType === 11 ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tfor ( i = 0; i < set.length; i++ ) {\n\t\t\tif ( instance.options[ set[ i ][ 0 ] ] ) {\n\t\t\t\tset[ i ][ 1 ].apply( instance.element, args );\n\t\t\t}\n\t\t}\n\t}\n};\n\n} );\n","jquery/ui-modules/position.js":"/*!\n * jQuery UI Position 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * http://api.jqueryui.com/position/\n */\n\n//>>label: Position\n//>>group: Core\n//>>description: Positions elements relative to other elements.\n//>>docs: http://api.jqueryui.com/position/\n//>>demos: http://jqueryui.com/position/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n( function() {\nvar cachedScrollbarWidth,\n\tmax = Math.max,\n\tabs = Math.abs,\n\trhorizontal = /left|center|right/,\n\trvertical = /top|center|bottom/,\n\troffset = /[\\+\\-]\\d+(\\.[\\d]+)?%?/,\n\trposition = /^\\w+/,\n\trpercent = /%$/,\n\t_position = $.fn.position;\n\nfunction getOffsets( offsets, width, height ) {\n\treturn [\n\t\tparseFloat( offsets[ 0 ] ) * ( rpercent.test( offsets[ 0 ] ) ? width / 100 : 1 ),\n\t\tparseFloat( offsets[ 1 ] ) * ( rpercent.test( offsets[ 1 ] ) ? height / 100 : 1 )\n\t];\n}\n\nfunction parseCss( element, property ) {\n\treturn parseInt( $.css( element, property ), 10 ) || 0;\n}\n\nfunction isWindow( obj ) {\n\treturn obj != null && obj === obj.window;\n}\n\nfunction getDimensions( elem ) {\n\tvar raw = elem[ 0 ];\n\tif ( raw.nodeType === 9 ) {\n\t\treturn {\n\t\t\twidth: elem.width(),\n\t\t\theight: elem.height(),\n\t\t\toffset: { top: 0, left: 0 }\n\t\t};\n\t}\n\tif ( isWindow( raw ) ) {\n\t\treturn {\n\t\t\twidth: elem.width(),\n\t\t\theight: elem.height(),\n\t\t\toffset: { top: elem.scrollTop(), left: elem.scrollLeft() }\n\t\t};\n\t}\n\tif ( raw.preventDefault ) {\n\t\treturn {\n\t\t\twidth: 0,\n\t\t\theight: 0,\n\t\t\toffset: { top: raw.pageY, left: raw.pageX }\n\t\t};\n\t}\n\treturn {\n\t\twidth: elem.outerWidth(),\n\t\theight: elem.outerHeight(),\n\t\toffset: elem.offset()\n\t};\n}\n\n$.position = {\n\tscrollbarWidth: function() {\n\t\tif ( cachedScrollbarWidth !== undefined ) {\n\t\t\treturn cachedScrollbarWidth;\n\t\t}\n\t\tvar w1, w2,\n\t\t\tdiv = $( \"<div style=\" +\n\t\t\t\t\"'display:block;position:absolute;width:200px;height:200px;overflow:hidden;'>\" +\n\t\t\t\t\"<div style='height:300px;width:auto;'></div></div>\" ),\n\t\t\tinnerDiv = div.children()[ 0 ];\n\n\t\t$( \"body\" ).append( div );\n\t\tw1 = innerDiv.offsetWidth;\n\t\tdiv.css( \"overflow\", \"scroll\" );\n\n\t\tw2 = innerDiv.offsetWidth;\n\n\t\tif ( w1 === w2 ) {\n\t\t\tw2 = div[ 0 ].clientWidth;\n\t\t}\n\n\t\tdiv.remove();\n\n\t\treturn ( cachedScrollbarWidth = w1 - w2 );\n\t},\n\tgetScrollInfo: function( within ) {\n\t\tvar overflowX = within.isWindow || within.isDocument ? \"\" :\n\t\t\t\twithin.element.css( \"overflow-x\" ),\n\t\t\toverflowY = within.isWindow || within.isDocument ? \"\" :\n\t\t\t\twithin.element.css( \"overflow-y\" ),\n\t\t\thasOverflowX = overflowX === \"scroll\" ||\n\t\t\t\t( overflowX === \"auto\" && within.width < within.element[ 0 ].scrollWidth ),\n\t\t\thasOverflowY = overflowY === \"scroll\" ||\n\t\t\t\t( overflowY === \"auto\" && within.height < within.element[ 0 ].scrollHeight );\n\t\treturn {\n\t\t\twidth: hasOverflowY ? $.position.scrollbarWidth() : 0,\n\t\t\theight: hasOverflowX ? $.position.scrollbarWidth() : 0\n\t\t};\n\t},\n\tgetWithinInfo: function( element ) {\n\t\tvar withinElement = $( element || window ),\n\t\t\tisElemWindow = isWindow( withinElement[ 0 ] ),\n\t\t\tisDocument = !!withinElement[ 0 ] && withinElement[ 0 ].nodeType === 9,\n\t\t\thasOffset = !isElemWindow && !isDocument;\n\t\treturn {\n\t\t\telement: withinElement,\n\t\t\tisWindow: isElemWindow,\n\t\t\tisDocument: isDocument,\n\t\t\toffset: hasOffset ? $( element ).offset() : { left: 0, top: 0 },\n\t\t\tscrollLeft: withinElement.scrollLeft(),\n\t\t\tscrollTop: withinElement.scrollTop(),\n\t\t\twidth: withinElement.outerWidth(),\n\t\t\theight: withinElement.outerHeight()\n\t\t};\n\t}\n};\n\n$.fn.position = function( options ) {\n\tif ( !options || !options.of ) {\n\t\treturn _position.apply( this, arguments );\n\t}\n\n\t// Make a copy, we don't want to modify arguments\n\toptions = $.extend( {}, options );\n\n\tvar atOffset, targetWidth, targetHeight, targetOffset, basePosition, dimensions,\n\n\t\t// Make sure string options are treated as CSS selectors\n\t\ttarget = typeof options.of === \"string\" ?\n\t\t\t$( document ).find( options.of ) :\n\t\t\t$( options.of ),\n\n\t\twithin = $.position.getWithinInfo( options.within ),\n\t\tscrollInfo = $.position.getScrollInfo( within ),\n\t\tcollision = ( options.collision || \"flip\" ).split( \" \" ),\n\t\toffsets = {};\n\n\tdimensions = getDimensions( target );\n\tif ( target[ 0 ].preventDefault ) {\n\n\t\t// Force left top to allow flipping\n\t\toptions.at = \"left top\";\n\t}\n\ttargetWidth = dimensions.width;\n\ttargetHeight = dimensions.height;\n\ttargetOffset = dimensions.offset;\n\n\t// Clone to reuse original targetOffset later\n\tbasePosition = $.extend( {}, targetOffset );\n\n\t// Force my and at to have valid horizontal and vertical positions\n\t// if a value is missing or invalid, it will be converted to center\n\t$.each( [ \"my\", \"at\" ], function() {\n\t\tvar pos = ( options[ this ] || \"\" ).split( \" \" ),\n\t\t\thorizontalOffset,\n\t\t\tverticalOffset;\n\n\t\tif ( pos.length === 1 ) {\n\t\t\tpos = rhorizontal.test( pos[ 0 ] ) ?\n\t\t\t\tpos.concat( [ \"center\" ] ) :\n\t\t\t\trvertical.test( pos[ 0 ] ) ?\n\t\t\t\t\t[ \"center\" ].concat( pos ) :\n\t\t\t\t\t[ \"center\", \"center\" ];\n\t\t}\n\t\tpos[ 0 ] = rhorizontal.test( pos[ 0 ] ) ? pos[ 0 ] : \"center\";\n\t\tpos[ 1 ] = rvertical.test( pos[ 1 ] ) ? pos[ 1 ] : \"center\";\n\n\t\t// Calculate offsets\n\t\thorizontalOffset = roffset.exec( pos[ 0 ] );\n\t\tverticalOffset = roffset.exec( pos[ 1 ] );\n\t\toffsets[ this ] = [\n\t\t\thorizontalOffset ? horizontalOffset[ 0 ] : 0,\n\t\t\tverticalOffset ? verticalOffset[ 0 ] : 0\n\t\t];\n\n\t\t// Reduce to just the positions without the offsets\n\t\toptions[ this ] = [\n\t\t\trposition.exec( pos[ 0 ] )[ 0 ],\n\t\t\trposition.exec( pos[ 1 ] )[ 0 ]\n\t\t];\n\t} );\n\n\t// Normalize collision option\n\tif ( collision.length === 1 ) {\n\t\tcollision[ 1 ] = collision[ 0 ];\n\t}\n\n\tif ( options.at[ 0 ] === \"right\" ) {\n\t\tbasePosition.left += targetWidth;\n\t} else if ( options.at[ 0 ] === \"center\" ) {\n\t\tbasePosition.left += targetWidth / 2;\n\t}\n\n\tif ( options.at[ 1 ] === \"bottom\" ) {\n\t\tbasePosition.top += targetHeight;\n\t} else if ( options.at[ 1 ] === \"center\" ) {\n\t\tbasePosition.top += targetHeight / 2;\n\t}\n\n\tatOffset = getOffsets( offsets.at, targetWidth, targetHeight );\n\tbasePosition.left += atOffset[ 0 ];\n\tbasePosition.top += atOffset[ 1 ];\n\n\treturn this.each( function() {\n\t\tvar collisionPosition, using,\n\t\t\telem = $( this ),\n\t\t\telemWidth = elem.outerWidth(),\n\t\t\telemHeight = elem.outerHeight(),\n\t\t\tmarginLeft = parseCss( this, \"marginLeft\" ),\n\t\t\tmarginTop = parseCss( this, \"marginTop\" ),\n\t\t\tcollisionWidth = elemWidth + marginLeft + parseCss( this, \"marginRight\" ) +\n\t\t\t\tscrollInfo.width,\n\t\t\tcollisionHeight = elemHeight + marginTop + parseCss( this, \"marginBottom\" ) +\n\t\t\t\tscrollInfo.height,\n\t\t\tposition = $.extend( {}, basePosition ),\n\t\t\tmyOffset = getOffsets( offsets.my, elem.outerWidth(), elem.outerHeight() );\n\n\t\tif ( options.my[ 0 ] === \"right\" ) {\n\t\t\tposition.left -= elemWidth;\n\t\t} else if ( options.my[ 0 ] === \"center\" ) {\n\t\t\tposition.left -= elemWidth / 2;\n\t\t}\n\n\t\tif ( options.my[ 1 ] === \"bottom\" ) {\n\t\t\tposition.top -= elemHeight;\n\t\t} else if ( options.my[ 1 ] === \"center\" ) {\n\t\t\tposition.top -= elemHeight / 2;\n\t\t}\n\n\t\tposition.left += myOffset[ 0 ];\n\t\tposition.top += myOffset[ 1 ];\n\n\t\tcollisionPosition = {\n\t\t\tmarginLeft: marginLeft,\n\t\t\tmarginTop: marginTop\n\t\t};\n\n\t\t$.each( [ \"left\", \"top\" ], function( i, dir ) {\n\t\t\tif ( $.ui.position[ collision[ i ] ] ) {\n\t\t\t\t$.ui.position[ collision[ i ] ][ dir ]( position, {\n\t\t\t\t\ttargetWidth: targetWidth,\n\t\t\t\t\ttargetHeight: targetHeight,\n\t\t\t\t\telemWidth: elemWidth,\n\t\t\t\t\telemHeight: elemHeight,\n\t\t\t\t\tcollisionPosition: collisionPosition,\n\t\t\t\t\tcollisionWidth: collisionWidth,\n\t\t\t\t\tcollisionHeight: collisionHeight,\n\t\t\t\t\toffset: [ atOffset[ 0 ] + myOffset[ 0 ], atOffset [ 1 ] + myOffset[ 1 ] ],\n\t\t\t\t\tmy: options.my,\n\t\t\t\t\tat: options.at,\n\t\t\t\t\twithin: within,\n\t\t\t\t\telem: elem\n\t\t\t\t} );\n\t\t\t}\n\t\t} );\n\n\t\tif ( options.using ) {\n\n\t\t\t// Adds feedback as second argument to using callback, if present\n\t\t\tusing = function( props ) {\n\t\t\t\tvar left = targetOffset.left - position.left,\n\t\t\t\t\tright = left + targetWidth - elemWidth,\n\t\t\t\t\ttop = targetOffset.top - position.top,\n\t\t\t\t\tbottom = top + targetHeight - elemHeight,\n\t\t\t\t\tfeedback = {\n\t\t\t\t\t\ttarget: {\n\t\t\t\t\t\t\telement: target,\n\t\t\t\t\t\t\tleft: targetOffset.left,\n\t\t\t\t\t\t\ttop: targetOffset.top,\n\t\t\t\t\t\t\twidth: targetWidth,\n\t\t\t\t\t\t\theight: targetHeight\n\t\t\t\t\t\t},\n\t\t\t\t\t\telement: {\n\t\t\t\t\t\t\telement: elem,\n\t\t\t\t\t\t\tleft: position.left,\n\t\t\t\t\t\t\ttop: position.top,\n\t\t\t\t\t\t\twidth: elemWidth,\n\t\t\t\t\t\t\theight: elemHeight\n\t\t\t\t\t\t},\n\t\t\t\t\t\thorizontal: right < 0 ? \"left\" : left > 0 ? \"right\" : \"center\",\n\t\t\t\t\t\tvertical: bottom < 0 ? \"top\" : top > 0 ? \"bottom\" : \"middle\"\n\t\t\t\t\t};\n\t\t\t\tif ( targetWidth < elemWidth && abs( left + right ) < targetWidth ) {\n\t\t\t\t\tfeedback.horizontal = \"center\";\n\t\t\t\t}\n\t\t\t\tif ( targetHeight < elemHeight && abs( top + bottom ) < targetHeight ) {\n\t\t\t\t\tfeedback.vertical = \"middle\";\n\t\t\t\t}\n\t\t\t\tif ( max( abs( left ), abs( right ) ) > max( abs( top ), abs( bottom ) ) ) {\n\t\t\t\t\tfeedback.important = \"horizontal\";\n\t\t\t\t} else {\n\t\t\t\t\tfeedback.important = \"vertical\";\n\t\t\t\t}\n\t\t\t\toptions.using.call( this, props, feedback );\n\t\t\t};\n\t\t}\n\n\t\telem.offset( $.extend( position, { using: using } ) );\n\t} );\n};\n\n$.ui.position = {\n\tfit: {\n\t\tleft: function( position, data ) {\n\t\t\tvar within = data.within,\n\t\t\t\twithinOffset = within.isWindow ? within.scrollLeft : within.offset.left,\n\t\t\t\touterWidth = within.width,\n\t\t\t\tcollisionPosLeft = position.left - data.collisionPosition.marginLeft,\n\t\t\t\toverLeft = withinOffset - collisionPosLeft,\n\t\t\t\toverRight = collisionPosLeft + data.collisionWidth - outerWidth - withinOffset,\n\t\t\t\tnewOverRight;\n\n\t\t\t// Element is wider than within\n\t\t\tif ( data.collisionWidth > outerWidth ) {\n\n\t\t\t\t// Element is initially over the left side of within\n\t\t\t\tif ( overLeft > 0 && overRight <= 0 ) {\n\t\t\t\t\tnewOverRight = position.left + overLeft + data.collisionWidth - outerWidth -\n\t\t\t\t\t\twithinOffset;\n\t\t\t\t\tposition.left += overLeft - newOverRight;\n\n\t\t\t\t// Element is initially over right side of within\n\t\t\t\t} else if ( overRight > 0 && overLeft <= 0 ) {\n\t\t\t\t\tposition.left = withinOffset;\n\n\t\t\t\t// Element is initially over both left and right sides of within\n\t\t\t\t} else {\n\t\t\t\t\tif ( overLeft > overRight ) {\n\t\t\t\t\t\tposition.left = withinOffset + outerWidth - data.collisionWidth;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tposition.left = withinOffset;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t// Too far left -> align with left edge\n\t\t\t} else if ( overLeft > 0 ) {\n\t\t\t\tposition.left += overLeft;\n\n\t\t\t// Too far right -> align with right edge\n\t\t\t} else if ( overRight > 0 ) {\n\t\t\t\tposition.left -= overRight;\n\n\t\t\t// Adjust based on position and margin\n\t\t\t} else {\n\t\t\t\tposition.left = max( position.left - collisionPosLeft, position.left );\n\t\t\t}\n\t\t},\n\t\ttop: function( position, data ) {\n\t\t\tvar within = data.within,\n\t\t\t\twithinOffset = within.isWindow ? within.scrollTop : within.offset.top,\n\t\t\t\touterHeight = data.within.height,\n\t\t\t\tcollisionPosTop = position.top - data.collisionPosition.marginTop,\n\t\t\t\toverTop = withinOffset - collisionPosTop,\n\t\t\t\toverBottom = collisionPosTop + data.collisionHeight - outerHeight - withinOffset,\n\t\t\t\tnewOverBottom;\n\n\t\t\t// Element is taller than within\n\t\t\tif ( data.collisionHeight > outerHeight ) {\n\n\t\t\t\t// Element is initially over the top of within\n\t\t\t\tif ( overTop > 0 && overBottom <= 0 ) {\n\t\t\t\t\tnewOverBottom = position.top + overTop + data.collisionHeight - outerHeight -\n\t\t\t\t\t\twithinOffset;\n\t\t\t\t\tposition.top += overTop - newOverBottom;\n\n\t\t\t\t// Element is initially over bottom of within\n\t\t\t\t} else if ( overBottom > 0 && overTop <= 0 ) {\n\t\t\t\t\tposition.top = withinOffset;\n\n\t\t\t\t// Element is initially over both top and bottom of within\n\t\t\t\t} else {\n\t\t\t\t\tif ( overTop > overBottom ) {\n\t\t\t\t\t\tposition.top = withinOffset + outerHeight - data.collisionHeight;\n\t\t\t\t\t} else {\n\t\t\t\t\t\tposition.top = withinOffset;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t// Too far up -> align with top\n\t\t\t} else if ( overTop > 0 ) {\n\t\t\t\tposition.top += overTop;\n\n\t\t\t// Too far down -> align with bottom edge\n\t\t\t} else if ( overBottom > 0 ) {\n\t\t\t\tposition.top -= overBottom;\n\n\t\t\t// Adjust based on position and margin\n\t\t\t} else {\n\t\t\t\tposition.top = max( position.top - collisionPosTop, position.top );\n\t\t\t}\n\t\t}\n\t},\n\tflip: {\n\t\tleft: function( position, data ) {\n\t\t\tvar within = data.within,\n\t\t\t\twithinOffset = within.offset.left + within.scrollLeft,\n\t\t\t\touterWidth = within.width,\n\t\t\t\toffsetLeft = within.isWindow ? within.scrollLeft : within.offset.left,\n\t\t\t\tcollisionPosLeft = position.left - data.collisionPosition.marginLeft,\n\t\t\t\toverLeft = collisionPosLeft - offsetLeft,\n\t\t\t\toverRight = collisionPosLeft + data.collisionWidth - outerWidth - offsetLeft,\n\t\t\t\tmyOffset = data.my[ 0 ] === \"left\" ?\n\t\t\t\t\t-data.elemWidth :\n\t\t\t\t\tdata.my[ 0 ] === \"right\" ?\n\t\t\t\t\t\tdata.elemWidth :\n\t\t\t\t\t\t0,\n\t\t\t\tatOffset = data.at[ 0 ] === \"left\" ?\n\t\t\t\t\tdata.targetWidth :\n\t\t\t\t\tdata.at[ 0 ] === \"right\" ?\n\t\t\t\t\t\t-data.targetWidth :\n\t\t\t\t\t\t0,\n\t\t\t\toffset = -2 * data.offset[ 0 ],\n\t\t\t\tnewOverRight,\n\t\t\t\tnewOverLeft;\n\n\t\t\tif ( overLeft < 0 ) {\n\t\t\t\tnewOverRight = position.left + myOffset + atOffset + offset + data.collisionWidth -\n\t\t\t\t\touterWidth - withinOffset;\n\t\t\t\tif ( newOverRight < 0 || newOverRight < abs( overLeft ) ) {\n\t\t\t\t\tposition.left += myOffset + atOffset + offset;\n\t\t\t\t}\n\t\t\t} else if ( overRight > 0 ) {\n\t\t\t\tnewOverLeft = position.left - data.collisionPosition.marginLeft + myOffset +\n\t\t\t\t\tatOffset + offset - offsetLeft;\n\t\t\t\tif ( newOverLeft > 0 || abs( newOverLeft ) < overRight ) {\n\t\t\t\t\tposition.left += myOffset + atOffset + offset;\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\ttop: function( position, data ) {\n\t\t\tvar within = data.within,\n\t\t\t\twithinOffset = within.offset.top + within.scrollTop,\n\t\t\t\touterHeight = within.height,\n\t\t\t\toffsetTop = within.isWindow ? within.scrollTop : within.offset.top,\n\t\t\t\tcollisionPosTop = position.top - data.collisionPosition.marginTop,\n\t\t\t\toverTop = collisionPosTop - offsetTop,\n\t\t\t\toverBottom = collisionPosTop + data.collisionHeight - outerHeight - offsetTop,\n\t\t\t\ttop = data.my[ 1 ] === \"top\",\n\t\t\t\tmyOffset = top ?\n\t\t\t\t\t-data.elemHeight :\n\t\t\t\t\tdata.my[ 1 ] === \"bottom\" ?\n\t\t\t\t\t\tdata.elemHeight :\n\t\t\t\t\t\t0,\n\t\t\t\tatOffset = data.at[ 1 ] === \"top\" ?\n\t\t\t\t\tdata.targetHeight :\n\t\t\t\t\tdata.at[ 1 ] === \"bottom\" ?\n\t\t\t\t\t\t-data.targetHeight :\n\t\t\t\t\t\t0,\n\t\t\t\toffset = -2 * data.offset[ 1 ],\n\t\t\t\tnewOverTop,\n\t\t\t\tnewOverBottom;\n\t\t\tif ( overTop < 0 ) {\n\t\t\t\tnewOverBottom = position.top + myOffset + atOffset + offset + data.collisionHeight -\n\t\t\t\t\touterHeight - withinOffset;\n\t\t\t\tif ( newOverBottom < 0 || newOverBottom < abs( overTop ) ) {\n\t\t\t\t\tposition.top += myOffset + atOffset + offset;\n\t\t\t\t}\n\t\t\t} else if ( overBottom > 0 ) {\n\t\t\t\tnewOverTop = position.top - data.collisionPosition.marginTop + myOffset + atOffset +\n\t\t\t\t\toffset - offsetTop;\n\t\t\t\tif ( newOverTop > 0 || abs( newOverTop ) < overBottom ) {\n\t\t\t\t\tposition.top += myOffset + atOffset + offset;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t},\n\tflipfit: {\n\t\tleft: function() {\n\t\t\t$.ui.position.flip.left.apply( this, arguments );\n\t\t\t$.ui.position.fit.left.apply( this, arguments );\n\t\t},\n\t\ttop: function() {\n\t\t\t$.ui.position.flip.top.apply( this, arguments );\n\t\t\t$.ui.position.fit.top.apply( this, arguments );\n\t\t}\n\t}\n};\n\n} )();\n\nreturn $.ui.position;\n\n} );\n","jquery/ui-modules/safe-active-element.js":"( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.ui.safeActiveElement = function( document ) {\n\tvar activeElement;\n\n\t// Support: IE 9 only\n\t// IE9 throws an \"Unspecified error\" accessing document.activeElement from an <iframe>\n\ttry {\n\t\tactiveElement = document.activeElement;\n\t} catch ( error ) {\n\t\tactiveElement = document.body;\n\t}\n\n\t// Support: IE 9 - 11 only\n\t// IE may return null instead of an element\n\t// Interestingly, this only seems to occur when NOT in an iframe\n\tif ( !activeElement ) {\n\t\tactiveElement = document.body;\n\t}\n\n\t// Support: IE 11 only\n\t// IE11 returns a seemingly empty object in some cases when accessing\n\t// document.activeElement from an <iframe>\n\tif ( !activeElement.nodeName ) {\n\t\tactiveElement = document.body;\n\t}\n\n\treturn activeElement;\n};\n\n} );\n","jquery/ui-modules/safe-blur.js":"( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.ui.safeBlur = function( element ) {\n\n\t// Support: IE9 - 10 only\n\t// If the <body> is blurred, IE will switch windows, see #9420\n\tif ( element && element.nodeName.toLowerCase() !== \"body\" ) {\n\t\t$( element ).trigger( \"blur\" );\n\t}\n};\n\n} );\n","jquery/ui-modules/scroll-parent.js":"/*!\n * jQuery UI Scroll Parent 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: scrollParent\n//>>group: Core\n//>>description: Get the closest ancestor element that is scrollable.\n//>>docs: http://api.jqueryui.com/scrollParent/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.fn.scrollParent = function( includeHidden ) {\n\tvar position = this.css( \"position\" ),\n\t\texcludeStaticParent = position === \"absolute\",\n\t\toverflowRegex = includeHidden ? /(auto|scroll|hidden)/ : /(auto|scroll)/,\n\t\tscrollParent = this.parents().filter( function() {\n\t\t\tvar parent = $( this );\n\t\t\tif ( excludeStaticParent && parent.css( \"position\" ) === \"static\" ) {\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\treturn overflowRegex.test( parent.css( \"overflow\" ) + parent.css( \"overflow-y\" ) +\n\t\t\t\tparent.css( \"overflow-x\" ) );\n\t\t} ).eq( 0 );\n\n\treturn position === \"fixed\" || !scrollParent.length ?\n\t\t$( this[ 0 ].ownerDocument || document ) :\n\t\tscrollParent;\n};\n\n} );\n","jquery/ui-modules/tabbable.js":"/*!\n * jQuery UI Tabbable 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: :tabbable Selector\n//>>group: Core\n//>>description: Selects elements which can be tabbed to.\n//>>docs: http://api.jqueryui.com/tabbable-selector/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\", \"./focusable\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.extend( $.expr.pseudos, {\n\ttabbable: function( element ) {\n\t\tvar tabIndex = $.attr( element, \"tabindex\" ),\n\t\t\thasTabindex = tabIndex != null;\n\t\treturn ( !hasTabindex || tabIndex >= 0 ) && $.ui.focusable( element, hasTabindex );\n\t}\n} );\n\n} );\n","jquery/ui-modules/unique-id.js":"/*!\n * jQuery UI Unique ID 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: uniqueId\n//>>group: Core\n//>>description: Functions to generate and remove uniqueId's\n//>>docs: http://api.jqueryui.com/uniqueId/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.fn.extend( {\n\tuniqueId: ( function() {\n\t\tvar uuid = 0;\n\n\t\treturn function() {\n\t\t\treturn this.each( function() {\n\t\t\t\tif ( !this.id ) {\n\t\t\t\t\tthis.id = \"ui-id-\" + ( ++uuid );\n\t\t\t\t}\n\t\t\t} );\n\t\t};\n\t} )(),\n\n\tremoveUniqueId: function() {\n\t\treturn this.each( function() {\n\t\t\tif ( /^ui-id-\\d+$/.test( this.id ) ) {\n\t\t\t\t$( this ).removeAttr( \"id\" );\n\t\t\t}\n\t\t} );\n\t}\n} );\n\n} );\n","jquery/ui-modules/version.js":"( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n$.ui = $.ui || {};\n\nreturn $.ui.version = \"1.13.1\";\n\n} );\n","jquery/ui-modules/widget.js":"/*!\n * jQuery UI Widget 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Widget\n//>>group: Core\n//>>description: Provides a factory for creating stateful widgets with a common API.\n//>>docs: http://api.jqueryui.com/jQuery.widget/\n//>>demos: http://jqueryui.com/widget/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\", \"./version\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nvar widgetUuid = 0;\nvar widgetHasOwnProperty = Array.prototype.hasOwnProperty;\nvar widgetSlice = Array.prototype.slice;\n\n$.cleanData = ( function( orig ) {\n\treturn function( elems ) {\n\t\tvar events, elem, i;\n\t\tfor ( i = 0; ( elem = elems[ i ] ) != null; i++ ) {\n\n\t\t\t// Only trigger remove when necessary to save time\n\t\t\tevents = $._data( elem, \"events\" );\n\t\t\tif ( events && events.remove ) {\n\t\t\t\t$( elem ).triggerHandler( \"remove\" );\n\t\t\t}\n\t\t}\n\t\torig( elems );\n\t};\n} )( $.cleanData );\n\n$.widget = function( name, base, prototype ) {\n\tvar existingConstructor, constructor, basePrototype;\n\n\t// ProxiedPrototype allows the provided prototype to remain unmodified\n\t// so that it can be used as a mixin for multiple widgets (#8876)\n\tvar proxiedPrototype = {};\n\n\tvar namespace = name.split( \".\" )[ 0 ];\n\tname = name.split( \".\" )[ 1 ];\n\tvar fullName = namespace + \"-\" + name;\n\n\tif ( !prototype ) {\n\t\tprototype = base;\n\t\tbase = $.Widget;\n\t}\n\n\tif ( Array.isArray( prototype ) ) {\n\t\tprototype = $.extend.apply( null, [ {} ].concat( prototype ) );\n\t}\n\n\t// Create selector for plugin\n\t$.expr.pseudos[ fullName.toLowerCase() ] = function( elem ) {\n\t\treturn !!$.data( elem, fullName );\n\t};\n\n\t$[ namespace ] = $[ namespace ] || {};\n\texistingConstructor = $[ namespace ][ name ];\n\tconstructor = $[ namespace ][ name ] = function( options, element ) {\n\n\t\t// Allow instantiation without \"new\" keyword\n\t\tif ( !this || !this._createWidget ) {\n\t\t\treturn new constructor( options, element );\n\t\t}\n\n\t\t// Allow instantiation without initializing for simple inheritance\n\t\t// must use \"new\" keyword (the code above always passes args)\n\t\tif ( arguments.length ) {\n\t\t\tthis._createWidget( options, element );\n\t\t}\n\t};\n\n\t// Extend with the existing constructor to carry over any static properties\n\t$.extend( constructor, existingConstructor, {\n\t\tversion: prototype.version,\n\n\t\t// Copy the object used to create the prototype in case we need to\n\t\t// redefine the widget later\n\t\t_proto: $.extend( {}, prototype ),\n\n\t\t// Track widgets that inherit from this widget in case this widget is\n\t\t// redefined after a widget inherits from it\n\t\t_childConstructors: []\n\t} );\n\n\tbasePrototype = new base();\n\n\t// We need to make the options hash a property directly on the new instance\n\t// otherwise we'll modify the options hash on the prototype that we're\n\t// inheriting from\n\tbasePrototype.options = $.widget.extend( {}, basePrototype.options );\n\t$.each( prototype, function( prop, value ) {\n\t\tif ( typeof value !== \"function\" ) {\n\t\t\tproxiedPrototype[ prop ] = value;\n\t\t\treturn;\n\t\t}\n\t\tproxiedPrototype[ prop ] = ( function() {\n\t\t\tfunction _super() {\n\t\t\t\treturn base.prototype[ prop ].apply( this, arguments );\n\t\t\t}\n\n\t\t\tfunction _superApply( args ) {\n\t\t\t\treturn base.prototype[ prop ].apply( this, args );\n\t\t\t}\n\n\t\t\treturn function() {\n\t\t\t\tvar __super = this._super;\n\t\t\t\tvar __superApply = this._superApply;\n\t\t\t\tvar returnValue;\n\n\t\t\t\tthis._super = _super;\n\t\t\t\tthis._superApply = _superApply;\n\n\t\t\t\treturnValue = value.apply( this, arguments );\n\n\t\t\t\tthis._super = __super;\n\t\t\t\tthis._superApply = __superApply;\n\n\t\t\t\treturn returnValue;\n\t\t\t};\n\t\t} )();\n\t} );\n\tconstructor.prototype = $.widget.extend( basePrototype, {\n\n\t\t// TODO: remove support for widgetEventPrefix\n\t\t// always use the name + a colon as the prefix, e.g., draggable:start\n\t\t// don't prefix for widgets that aren't DOM-based\n\t\twidgetEventPrefix: existingConstructor ? ( basePrototype.widgetEventPrefix || name ) : name\n\t}, proxiedPrototype, {\n\t\tconstructor: constructor,\n\t\tnamespace: namespace,\n\t\twidgetName: name,\n\t\twidgetFullName: fullName\n\t} );\n\n\t// If this widget is being redefined then we need to find all widgets that\n\t// are inheriting from it and redefine all of them so that they inherit from\n\t// the new version of this widget. We're essentially trying to replace one\n\t// level in the prototype chain.\n\tif ( existingConstructor ) {\n\t\t$.each( existingConstructor._childConstructors, function( i, child ) {\n\t\t\tvar childPrototype = child.prototype;\n\n\t\t\t// Redefine the child widget using the same prototype that was\n\t\t\t// originally used, but inherit from the new version of the base\n\t\t\t$.widget( childPrototype.namespace + \".\" + childPrototype.widgetName, constructor,\n\t\t\t\tchild._proto );\n\t\t} );\n\n\t\t// Remove the list of existing child constructors from the old constructor\n\t\t// so the old child constructors can be garbage collected\n\t\tdelete existingConstructor._childConstructors;\n\t} else {\n\t\tbase._childConstructors.push( constructor );\n\t}\n\n\t$.widget.bridge( name, constructor );\n\n\treturn constructor;\n};\n\n$.widget.extend = function( target ) {\n\tvar input = widgetSlice.call( arguments, 1 );\n\tvar inputIndex = 0;\n\tvar inputLength = input.length;\n\tvar key;\n\tvar value;\n\n\tfor ( ; inputIndex < inputLength; inputIndex++ ) {\n\t\tfor ( key in input[ inputIndex ] ) {\n\t\t\tvalue = input[ inputIndex ][ key ];\n\t\t\tif ( widgetHasOwnProperty.call( input[ inputIndex ], key ) && value !== undefined ) {\n\n\t\t\t\t// Clone objects\n\t\t\t\tif ( $.isPlainObject( value ) ) {\n\t\t\t\t\ttarget[ key ] = $.isPlainObject( target[ key ] ) ?\n\t\t\t\t\t\t$.widget.extend( {}, target[ key ], value ) :\n\n\t\t\t\t\t\t// Don't extend strings, arrays, etc. with objects\n\t\t\t\t\t\t$.widget.extend( {}, value );\n\n\t\t\t\t// Copy everything else by reference\n\t\t\t\t} else {\n\t\t\t\t\ttarget[ key ] = value;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\treturn target;\n};\n\n$.widget.bridge = function( name, object ) {\n\tvar fullName = object.prototype.widgetFullName || name;\n\t$.fn[ name ] = function( options ) {\n\t\tvar isMethodCall = typeof options === \"string\";\n\t\tvar args = widgetSlice.call( arguments, 1 );\n\t\tvar returnValue = this;\n\n\t\tif ( isMethodCall ) {\n\n\t\t\t// If this is an empty collection, we need to have the instance method\n\t\t\t// return undefined instead of the jQuery instance\n\t\t\tif ( !this.length && options === \"instance\" ) {\n\t\t\t\treturnValue = undefined;\n\t\t\t} else {\n\t\t\t\tthis.each( function() {\n\t\t\t\t\tvar methodValue;\n\t\t\t\t\tvar instance = $.data( this, fullName );\n\n\t\t\t\t\tif ( options === \"instance\" ) {\n\t\t\t\t\t\treturnValue = instance;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\n\t\t\t\t\tif ( !instance ) {\n\t\t\t\t\t\treturn $.error( \"cannot call methods on \" + name +\n\t\t\t\t\t\t\t\" prior to initialization; \" +\n\t\t\t\t\t\t\t\"attempted to call method '\" + options + \"'\" );\n\t\t\t\t\t}\n\n\t\t\t\t\tif ( typeof instance[ options ] !== \"function\" ||\n\t\t\t\t\t\toptions.charAt( 0 ) === \"_\" ) {\n\t\t\t\t\t\treturn $.error( \"no such method '\" + options + \"' for \" + name +\n\t\t\t\t\t\t\t\" widget instance\" );\n\t\t\t\t\t}\n\n\t\t\t\t\tmethodValue = instance[ options ].apply( instance, args );\n\n\t\t\t\t\tif ( methodValue !== instance && methodValue !== undefined ) {\n\t\t\t\t\t\treturnValue = methodValue && methodValue.jquery ?\n\t\t\t\t\t\t\treturnValue.pushStack( methodValue.get() ) :\n\t\t\t\t\t\t\tmethodValue;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t}\n\t\t} else {\n\n\t\t\t// Allow multiple hashes to be passed on init\n\t\t\tif ( args.length ) {\n\t\t\t\toptions = $.widget.extend.apply( null, [ options ].concat( args ) );\n\t\t\t}\n\n\t\t\tthis.each( function() {\n\t\t\t\tvar instance = $.data( this, fullName );\n\t\t\t\tif ( instance ) {\n\t\t\t\t\tinstance.option( options || {} );\n\t\t\t\t\tif ( instance._init ) {\n\t\t\t\t\t\tinstance._init();\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\t$.data( this, fullName, new object( options, this ) );\n\t\t\t\t}\n\t\t\t} );\n\t\t}\n\n\t\treturn returnValue;\n\t};\n};\n\n$.Widget = function( /* options, element */ ) {};\n$.Widget._childConstructors = [];\n\n$.Widget.prototype = {\n\twidgetName: \"widget\",\n\twidgetEventPrefix: \"\",\n\tdefaultElement: \"<div>\",\n\n\toptions: {\n\t\tclasses: {},\n\t\tdisabled: false,\n\n\t\t// Callbacks\n\t\tcreate: null\n\t},\n\n\t_createWidget: function( options, element ) {\n\t\telement = $( element || this.defaultElement || this )[ 0 ];\n\t\tthis.element = $( element );\n\t\tthis.uuid = widgetUuid++;\n\t\tthis.eventNamespace = \".\" + this.widgetName + this.uuid;\n\n\t\tthis.bindings = $();\n\t\tthis.hoverable = $();\n\t\tthis.focusable = $();\n\t\tthis.classesElementLookup = {};\n\n\t\tif ( element !== this ) {\n\t\t\t$.data( element, this.widgetFullName, this );\n\t\t\tthis._on( true, this.element, {\n\t\t\t\tremove: function( event ) {\n\t\t\t\t\tif ( event.target === element ) {\n\t\t\t\t\t\tthis.destroy();\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} );\n\t\t\tthis.document = $( element.style ?\n\n\t\t\t\t// Element within the document\n\t\t\t\telement.ownerDocument :\n\n\t\t\t\t// Element is window or document\n\t\t\t\telement.document || element );\n\t\t\tthis.window = $( this.document[ 0 ].defaultView || this.document[ 0 ].parentWindow );\n\t\t}\n\n\t\tthis.options = $.widget.extend( {},\n\t\t\tthis.options,\n\t\t\tthis._getCreateOptions(),\n\t\t\toptions );\n\n\t\tthis._create();\n\n\t\tif ( this.options.disabled ) {\n\t\t\tthis._setOptionDisabled( this.options.disabled );\n\t\t}\n\n\t\tthis._trigger( \"create\", null, this._getCreateEventData() );\n\t\tthis._init();\n\t},\n\n\t_getCreateOptions: function() {\n\t\treturn {};\n\t},\n\n\t_getCreateEventData: $.noop,\n\n\t_create: $.noop,\n\n\t_init: $.noop,\n\n\tdestroy: function() {\n\t\tvar that = this;\n\n\t\tthis._destroy();\n\t\t$.each( this.classesElementLookup, function( key, value ) {\n\t\t\tthat._removeClass( value, key );\n\t\t} );\n\n\t\t// We can probably remove the unbind calls in 2.0\n\t\t// all event bindings should go through this._on()\n\t\tthis.element\n\t\t\t.off( this.eventNamespace )\n\t\t\t.removeData( this.widgetFullName );\n\t\tthis.widget()\n\t\t\t.off( this.eventNamespace )\n\t\t\t.removeAttr( \"aria-disabled\" );\n\n\t\t// Clean up events and states\n\t\tthis.bindings.off( this.eventNamespace );\n\t},\n\n\t_destroy: $.noop,\n\n\twidget: function() {\n\t\treturn this.element;\n\t},\n\n\toption: function( key, value ) {\n\t\tvar options = key;\n\t\tvar parts;\n\t\tvar curOption;\n\t\tvar i;\n\n\t\tif ( arguments.length === 0 ) {\n\n\t\t\t// Don't return a reference to the internal hash\n\t\t\treturn $.widget.extend( {}, this.options );\n\t\t}\n\n\t\tif ( typeof key === \"string\" ) {\n\n\t\t\t// Handle nested keys, e.g., \"foo.bar\" => { foo: { bar: ___ } }\n\t\t\toptions = {};\n\t\t\tparts = key.split( \".\" );\n\t\t\tkey = parts.shift();\n\t\t\tif ( parts.length ) {\n\t\t\t\tcurOption = options[ key ] = $.widget.extend( {}, this.options[ key ] );\n\t\t\t\tfor ( i = 0; i < parts.length - 1; i++ ) {\n\t\t\t\t\tcurOption[ parts[ i ] ] = curOption[ parts[ i ] ] || {};\n\t\t\t\t\tcurOption = curOption[ parts[ i ] ];\n\t\t\t\t}\n\t\t\t\tkey = parts.pop();\n\t\t\t\tif ( arguments.length === 1 ) {\n\t\t\t\t\treturn curOption[ key ] === undefined ? null : curOption[ key ];\n\t\t\t\t}\n\t\t\t\tcurOption[ key ] = value;\n\t\t\t} else {\n\t\t\t\tif ( arguments.length === 1 ) {\n\t\t\t\t\treturn this.options[ key ] === undefined ? null : this.options[ key ];\n\t\t\t\t}\n\t\t\t\toptions[ key ] = value;\n\t\t\t}\n\t\t}\n\n\t\tthis._setOptions( options );\n\n\t\treturn this;\n\t},\n\n\t_setOptions: function( options ) {\n\t\tvar key;\n\n\t\tfor ( key in options ) {\n\t\t\tthis._setOption( key, options[ key ] );\n\t\t}\n\n\t\treturn this;\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tif ( key === \"classes\" ) {\n\t\t\tthis._setOptionClasses( value );\n\t\t}\n\n\t\tthis.options[ key ] = value;\n\n\t\tif ( key === \"disabled\" ) {\n\t\t\tthis._setOptionDisabled( value );\n\t\t}\n\n\t\treturn this;\n\t},\n\n\t_setOptionClasses: function( value ) {\n\t\tvar classKey, elements, currentElements;\n\n\t\tfor ( classKey in value ) {\n\t\t\tcurrentElements = this.classesElementLookup[ classKey ];\n\t\t\tif ( value[ classKey ] === this.options.classes[ classKey ] ||\n\t\t\t\t\t!currentElements ||\n\t\t\t\t\t!currentElements.length ) {\n\t\t\t\tcontinue;\n\t\t\t}\n\n\t\t\t// We are doing this to create a new jQuery object because the _removeClass() call\n\t\t\t// on the next line is going to destroy the reference to the current elements being\n\t\t\t// tracked. We need to save a copy of this collection so that we can add the new classes\n\t\t\t// below.\n\t\t\telements = $( currentElements.get() );\n\t\t\tthis._removeClass( currentElements, classKey );\n\n\t\t\t// We don't use _addClass() here, because that uses this.options.classes\n\t\t\t// for generating the string of classes. We want to use the value passed in from\n\t\t\t// _setOption(), this is the new value of the classes option which was passed to\n\t\t\t// _setOption(). We pass this value directly to _classes().\n\t\t\telements.addClass( this._classes( {\n\t\t\t\telement: elements,\n\t\t\t\tkeys: classKey,\n\t\t\t\tclasses: value,\n\t\t\t\tadd: true\n\t\t\t} ) );\n\t\t}\n\t},\n\n\t_setOptionDisabled: function( value ) {\n\t\tthis._toggleClass( this.widget(), this.widgetFullName + \"-disabled\", null, !!value );\n\n\t\t// If the widget is becoming disabled, then nothing is interactive\n\t\tif ( value ) {\n\t\t\tthis._removeClass( this.hoverable, null, \"ui-state-hover\" );\n\t\t\tthis._removeClass( this.focusable, null, \"ui-state-focus\" );\n\t\t}\n\t},\n\n\tenable: function() {\n\t\treturn this._setOptions( { disabled: false } );\n\t},\n\n\tdisable: function() {\n\t\treturn this._setOptions( { disabled: true } );\n\t},\n\n\t_classes: function( options ) {\n\t\tvar full = [];\n\t\tvar that = this;\n\n\t\toptions = $.extend( {\n\t\t\telement: this.element,\n\t\t\tclasses: this.options.classes || {}\n\t\t}, options );\n\n\t\tfunction bindRemoveEvent() {\n\t\t\tvar nodesToBind = [];\n\n\t\t\toptions.element.each( function( _, element ) {\n\t\t\t\tvar isTracked = $.map( that.classesElementLookup, function( elements ) {\n\t\t\t\t\treturn elements;\n\t\t\t\t} )\n\t\t\t\t\t.some( function( elements ) {\n\t\t\t\t\t\treturn elements.is( element );\n\t\t\t\t\t} );\n\n\t\t\t\tif ( !isTracked ) {\n\t\t\t\t\tnodesToBind.push( element );\n\t\t\t\t}\n\t\t\t} );\n\n\t\t\tthat._on( $( nodesToBind ), {\n\t\t\t\tremove: \"_untrackClassesElement\"\n\t\t\t} );\n\t\t}\n\n\t\tfunction processClassString( classes, checkOption ) {\n\t\t\tvar current, i;\n\t\t\tfor ( i = 0; i < classes.length; i++ ) {\n\t\t\t\tcurrent = that.classesElementLookup[ classes[ i ] ] || $();\n\t\t\t\tif ( options.add ) {\n\t\t\t\t\tbindRemoveEvent();\n\t\t\t\t\tcurrent = $( $.uniqueSort( current.get().concat( options.element.get() ) ) );\n\t\t\t\t} else {\n\t\t\t\t\tcurrent = $( current.not( options.element ).get() );\n\t\t\t\t}\n\t\t\t\tthat.classesElementLookup[ classes[ i ] ] = current;\n\t\t\t\tfull.push( classes[ i ] );\n\t\t\t\tif ( checkOption && options.classes[ classes[ i ] ] ) {\n\t\t\t\t\tfull.push( options.classes[ classes[ i ] ] );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tif ( options.keys ) {\n\t\t\tprocessClassString( options.keys.match( /\\S+/g ) || [], true );\n\t\t}\n\t\tif ( options.extra ) {\n\t\t\tprocessClassString( options.extra.match( /\\S+/g ) || [] );\n\t\t}\n\n\t\treturn full.join( \" \" );\n\t},\n\n\t_untrackClassesElement: function( event ) {\n\t\tvar that = this;\n\t\t$.each( that.classesElementLookup, function( key, value ) {\n\t\t\tif ( $.inArray( event.target, value ) !== -1 ) {\n\t\t\t\tthat.classesElementLookup[ key ] = $( value.not( event.target ).get() );\n\t\t\t}\n\t\t} );\n\n\t\tthis._off( $( event.target ) );\n\t},\n\n\t_removeClass: function( element, keys, extra ) {\n\t\treturn this._toggleClass( element, keys, extra, false );\n\t},\n\n\t_addClass: function( element, keys, extra ) {\n\t\treturn this._toggleClass( element, keys, extra, true );\n\t},\n\n\t_toggleClass: function( element, keys, extra, add ) {\n\t\tadd = ( typeof add === \"boolean\" ) ? add : extra;\n\t\tvar shift = ( typeof element === \"string\" || element === null ),\n\t\t\toptions = {\n\t\t\t\textra: shift ? keys : extra,\n\t\t\t\tkeys: shift ? element : keys,\n\t\t\t\telement: shift ? this.element : element,\n\t\t\t\tadd: add\n\t\t\t};\n\t\toptions.element.toggleClass( this._classes( options ), add );\n\t\treturn this;\n\t},\n\n\t_on: function( suppressDisabledCheck, element, handlers ) {\n\t\tvar delegateElement;\n\t\tvar instance = this;\n\n\t\t// No suppressDisabledCheck flag, shuffle arguments\n\t\tif ( typeof suppressDisabledCheck !== \"boolean\" ) {\n\t\t\thandlers = element;\n\t\t\telement = suppressDisabledCheck;\n\t\t\tsuppressDisabledCheck = false;\n\t\t}\n\n\t\t// No element argument, shuffle and use this.element\n\t\tif ( !handlers ) {\n\t\t\thandlers = element;\n\t\t\telement = this.element;\n\t\t\tdelegateElement = this.widget();\n\t\t} else {\n\t\t\telement = delegateElement = $( element );\n\t\t\tthis.bindings = this.bindings.add( element );\n\t\t}\n\n\t\t$.each( handlers, function( event, handler ) {\n\t\t\tfunction handlerProxy() {\n\n\t\t\t\t// Allow widgets to customize the disabled handling\n\t\t\t\t// - disabled as an array instead of boolean\n\t\t\t\t// - disabled class as method for disabling individual parts\n\t\t\t\tif ( !suppressDisabledCheck &&\n\t\t\t\t\t\t( instance.options.disabled === true ||\n\t\t\t\t\t\t$( this ).hasClass( \"ui-state-disabled\" ) ) ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\treturn ( typeof handler === \"string\" ? instance[ handler ] : handler )\n\t\t\t\t\t.apply( instance, arguments );\n\t\t\t}\n\n\t\t\t// Copy the guid so direct unbinding works\n\t\t\tif ( typeof handler !== \"string\" ) {\n\t\t\t\thandlerProxy.guid = handler.guid =\n\t\t\t\t\thandler.guid || handlerProxy.guid || $.guid++;\n\t\t\t}\n\n\t\t\tvar match = event.match( /^([\\w:-]*)\\s*(.*)$/ );\n\t\t\tvar eventName = match[ 1 ] + instance.eventNamespace;\n\t\t\tvar selector = match[ 2 ];\n\n\t\t\tif ( selector ) {\n\t\t\t\tdelegateElement.on( eventName, selector, handlerProxy );\n\t\t\t} else {\n\t\t\t\telement.on( eventName, handlerProxy );\n\t\t\t}\n\t\t} );\n\t},\n\n\t_off: function( element, eventName ) {\n\t\teventName = ( eventName || \"\" ).split( \" \" ).join( this.eventNamespace + \" \" ) +\n\t\t\tthis.eventNamespace;\n\t\telement.off( eventName );\n\n\t\t// Clear the stack to avoid memory leaks (#10056)\n\t\tthis.bindings = $( this.bindings.not( element ).get() );\n\t\tthis.focusable = $( this.focusable.not( element ).get() );\n\t\tthis.hoverable = $( this.hoverable.not( element ).get() );\n\t},\n\n\t_delay: function( handler, delay ) {\n\t\tfunction handlerProxy() {\n\t\t\treturn ( typeof handler === \"string\" ? instance[ handler ] : handler )\n\t\t\t\t.apply( instance, arguments );\n\t\t}\n\t\tvar instance = this;\n\t\treturn setTimeout( handlerProxy, delay || 0 );\n\t},\n\n\t_hoverable: function( element ) {\n\t\tthis.hoverable = this.hoverable.add( element );\n\t\tthis._on( element, {\n\t\t\tmouseenter: function( event ) {\n\t\t\t\tthis._addClass( $( event.currentTarget ), null, \"ui-state-hover\" );\n\t\t\t},\n\t\t\tmouseleave: function( event ) {\n\t\t\t\tthis._removeClass( $( event.currentTarget ), null, \"ui-state-hover\" );\n\t\t\t}\n\t\t} );\n\t},\n\n\t_focusable: function( element ) {\n\t\tthis.focusable = this.focusable.add( element );\n\t\tthis._on( element, {\n\t\t\tfocusin: function( event ) {\n\t\t\t\tthis._addClass( $( event.currentTarget ), null, \"ui-state-focus\" );\n\t\t\t},\n\t\t\tfocusout: function( event ) {\n\t\t\t\tthis._removeClass( $( event.currentTarget ), null, \"ui-state-focus\" );\n\t\t\t}\n\t\t} );\n\t},\n\n\t_trigger: function( type, event, data ) {\n\t\tvar prop, orig;\n\t\tvar callback = this.options[ type ];\n\n\t\tdata = data || {};\n\t\tevent = $.Event( event );\n\t\tevent.type = ( type === this.widgetEventPrefix ?\n\t\t\ttype :\n\t\t\tthis.widgetEventPrefix + type ).toLowerCase();\n\n\t\t// The original event may come from any element\n\t\t// so we need to reset the target on the new event\n\t\tevent.target = this.element[ 0 ];\n\n\t\t// Copy original event properties over to the new event\n\t\torig = event.originalEvent;\n\t\tif ( orig ) {\n\t\t\tfor ( prop in orig ) {\n\t\t\t\tif ( !( prop in event ) ) {\n\t\t\t\t\tevent[ prop ] = orig[ prop ];\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tthis.element.trigger( event, data );\n\t\treturn !( typeof callback === \"function\" &&\n\t\t\tcallback.apply( this.element[ 0 ], [ event ].concat( data ) ) === false ||\n\t\t\tevent.isDefaultPrevented() );\n\t}\n};\n\n$.each( { show: \"fadeIn\", hide: \"fadeOut\" }, function( method, defaultEffect ) {\n\t$.Widget.prototype[ \"_\" + method ] = function( element, options, callback ) {\n\t\tif ( typeof options === \"string\" ) {\n\t\t\toptions = { effect: options };\n\t\t}\n\n\t\tvar hasOptions;\n\t\tvar effectName = !options ?\n\t\t\tmethod :\n\t\t\toptions === true || typeof options === \"number\" ?\n\t\t\t\tdefaultEffect :\n\t\t\t\toptions.effect || defaultEffect;\n\n\t\toptions = options || {};\n\t\tif ( typeof options === \"number\" ) {\n\t\t\toptions = { duration: options };\n\t\t} else if ( options === true ) {\n\t\t\toptions = {};\n\t\t}\n\n\t\thasOptions = !$.isEmptyObject( options );\n\t\toptions.complete = callback;\n\n\t\tif ( options.delay ) {\n\t\t\telement.delay( options.delay );\n\t\t}\n\n\t\tif ( hasOptions && $.effects && $.effects.effect[ effectName ] ) {\n\t\t\telement[ method ]( options );\n\t\t} else if ( effectName !== method && element[ effectName ] ) {\n\t\t\telement[ effectName ]( options.duration, options.easing, callback );\n\t\t} else {\n\t\t\telement.queue( function( next ) {\n\t\t\t\t$( this )[ method ]();\n\t\t\t\tif ( callback ) {\n\t\t\t\t\tcallback.call( element[ 0 ] );\n\t\t\t\t}\n\t\t\t\tnext();\n\t\t\t} );\n\t\t}\n\t};\n} );\n\nreturn $.widget;\n\n} );\n","jquery/ui-modules/effects/effect-blind.js":"/*!\n * jQuery UI Effects Blind 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Blind Effect\n//>>group: Effects\n//>>description: Blinds the element.\n//>>docs: http://api.jqueryui.com/blind-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"blind\", \"hide\", function( options, done ) {\n\tvar map = {\n\t\t\tup: [ \"bottom\", \"top\" ],\n\t\t\tvertical: [ \"bottom\", \"top\" ],\n\t\t\tdown: [ \"top\", \"bottom\" ],\n\t\t\tleft: [ \"right\", \"left\" ],\n\t\t\thorizontal: [ \"right\", \"left\" ],\n\t\t\tright: [ \"left\", \"right\" ]\n\t\t},\n\t\telement = $( this ),\n\t\tdirection = options.direction || \"up\",\n\t\tstart = element.cssClip(),\n\t\tanimate = { clip: $.extend( {}, start ) },\n\t\tplaceholder = $.effects.createPlaceholder( element );\n\n\tanimate.clip[ map[ direction ][ 0 ] ] = animate.clip[ map[ direction ][ 1 ] ];\n\n\tif ( options.mode === \"show\" ) {\n\t\telement.cssClip( animate.clip );\n\t\tif ( placeholder ) {\n\t\t\tplaceholder.css( $.effects.clipToBox( animate ) );\n\t\t}\n\n\t\tanimate.clip = start;\n\t}\n\n\tif ( placeholder ) {\n\t\tplaceholder.animate( $.effects.clipToBox( animate ), options.duration, options.easing );\n\t}\n\n\telement.animate( animate, {\n\t\tqueue: false,\n\t\tduration: options.duration,\n\t\teasing: options.easing,\n\t\tcomplete: done\n\t} );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-bounce.js":"/*!\n * jQuery UI Effects Bounce 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Bounce Effect\n//>>group: Effects\n//>>description: Bounces an element horizontally or vertically n times.\n//>>docs: http://api.jqueryui.com/bounce-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"bounce\", function( options, done ) {\n\tvar upAnim, downAnim, refValue,\n\t\telement = $( this ),\n\n\t\t// Defaults:\n\t\tmode = options.mode,\n\t\thide = mode === \"hide\",\n\t\tshow = mode === \"show\",\n\t\tdirection = options.direction || \"up\",\n\t\tdistance = options.distance,\n\t\ttimes = options.times || 5,\n\n\t\t// Number of internal animations\n\t\tanims = times * 2 + ( show || hide ? 1 : 0 ),\n\t\tspeed = options.duration / anims,\n\t\teasing = options.easing,\n\n\t\t// Utility:\n\t\tref = ( direction === \"up\" || direction === \"down\" ) ? \"top\" : \"left\",\n\t\tmotion = ( direction === \"up\" || direction === \"left\" ),\n\t\ti = 0,\n\n\t\tqueuelen = element.queue().length;\n\n\t$.effects.createPlaceholder( element );\n\n\trefValue = element.css( ref );\n\n\t// Default distance for the BIGGEST bounce is the outer Distance / 3\n\tif ( !distance ) {\n\t\tdistance = element[ ref === \"top\" ? \"outerHeight\" : \"outerWidth\" ]() / 3;\n\t}\n\n\tif ( show ) {\n\t\tdownAnim = { opacity: 1 };\n\t\tdownAnim[ ref ] = refValue;\n\n\t\t// If we are showing, force opacity 0 and set the initial position\n\t\t// then do the \"first\" animation\n\t\telement\n\t\t\t.css( \"opacity\", 0 )\n\t\t\t.css( ref, motion ? -distance * 2 : distance * 2 )\n\t\t\t.animate( downAnim, speed, easing );\n\t}\n\n\t// Start at the smallest distance if we are hiding\n\tif ( hide ) {\n\t\tdistance = distance / Math.pow( 2, times - 1 );\n\t}\n\n\tdownAnim = {};\n\tdownAnim[ ref ] = refValue;\n\n\t// Bounces up/down/left/right then back to 0 -- times * 2 animations happen here\n\tfor ( ; i < times; i++ ) {\n\t\tupAnim = {};\n\t\tupAnim[ ref ] = ( motion ? \"-=\" : \"+=\" ) + distance;\n\n\t\telement\n\t\t\t.animate( upAnim, speed, easing )\n\t\t\t.animate( downAnim, speed, easing );\n\n\t\tdistance = hide ? distance * 2 : distance / 2;\n\t}\n\n\t// Last Bounce when Hiding\n\tif ( hide ) {\n\t\tupAnim = { opacity: 0 };\n\t\tupAnim[ ref ] = ( motion ? \"-=\" : \"+=\" ) + distance;\n\n\t\telement.animate( upAnim, speed, easing );\n\t}\n\n\telement.queue( done );\n\n\t$.effects.unshift( element, queuelen, anims + 1 );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-clip.js":"/*!\n * jQuery UI Effects Clip 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Clip Effect\n//>>group: Effects\n//>>description: Clips the element on and off like an old TV.\n//>>docs: http://api.jqueryui.com/clip-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"clip\", \"hide\", function( options, done ) {\n\tvar start,\n\t\tanimate = {},\n\t\telement = $( this ),\n\t\tdirection = options.direction || \"vertical\",\n\t\tboth = direction === \"both\",\n\t\thorizontal = both || direction === \"horizontal\",\n\t\tvertical = both || direction === \"vertical\";\n\n\tstart = element.cssClip();\n\tanimate.clip = {\n\t\ttop: vertical ? ( start.bottom - start.top ) / 2 : start.top,\n\t\tright: horizontal ? ( start.right - start.left ) / 2 : start.right,\n\t\tbottom: vertical ? ( start.bottom - start.top ) / 2 : start.bottom,\n\t\tleft: horizontal ? ( start.right - start.left ) / 2 : start.left\n\t};\n\n\t$.effects.createPlaceholder( element );\n\n\tif ( options.mode === \"show\" ) {\n\t\telement.cssClip( animate.clip );\n\t\tanimate.clip = start;\n\t}\n\n\telement.animate( animate, {\n\t\tqueue: false,\n\t\tduration: options.duration,\n\t\teasing: options.easing,\n\t\tcomplete: done\n\t} );\n\n} );\n\n} );\n","jquery/ui-modules/effects/effect-drop.js":"/*!\n * jQuery UI Effects Drop 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Drop Effect\n//>>group: Effects\n//>>description: Moves an element in one direction and hides it at the same time.\n//>>docs: http://api.jqueryui.com/drop-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"drop\", \"hide\", function( options, done ) {\n\n\tvar distance,\n\t\telement = $( this ),\n\t\tmode = options.mode,\n\t\tshow = mode === \"show\",\n\t\tdirection = options.direction || \"left\",\n\t\tref = ( direction === \"up\" || direction === \"down\" ) ? \"top\" : \"left\",\n\t\tmotion = ( direction === \"up\" || direction === \"left\" ) ? \"-=\" : \"+=\",\n\t\toppositeMotion = ( motion === \"+=\" ) ? \"-=\" : \"+=\",\n\t\tanimation = {\n\t\t\topacity: 0\n\t\t};\n\n\t$.effects.createPlaceholder( element );\n\n\tdistance = options.distance ||\n\t\telement[ ref === \"top\" ? \"outerHeight\" : \"outerWidth\" ]( true ) / 2;\n\n\tanimation[ ref ] = motion + distance;\n\n\tif ( show ) {\n\t\telement.css( animation );\n\n\t\tanimation[ ref ] = oppositeMotion + distance;\n\t\tanimation.opacity = 1;\n\t}\n\n\t// Animate\n\telement.animate( animation, {\n\t\tqueue: false,\n\t\tduration: options.duration,\n\t\teasing: options.easing,\n\t\tcomplete: done\n\t} );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-explode.js":"/*!\n * jQuery UI Effects Explode 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Explode Effect\n//>>group: Effects\n/* eslint-disable max-len */\n//>>description: Explodes an element in all directions into n pieces. Implodes an element to its original wholeness.\n/* eslint-enable max-len */\n//>>docs: http://api.jqueryui.com/explode-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"explode\", \"hide\", function( options, done ) {\n\n\tvar i, j, left, top, mx, my,\n\t\trows = options.pieces ? Math.round( Math.sqrt( options.pieces ) ) : 3,\n\t\tcells = rows,\n\t\telement = $( this ),\n\t\tmode = options.mode,\n\t\tshow = mode === \"show\",\n\n\t\t// Show and then visibility:hidden the element before calculating offset\n\t\toffset = element.show().css( \"visibility\", \"hidden\" ).offset(),\n\n\t\t// Width and height of a piece\n\t\twidth = Math.ceil( element.outerWidth() / cells ),\n\t\theight = Math.ceil( element.outerHeight() / rows ),\n\t\tpieces = [];\n\n\t// Children animate complete:\n\tfunction childComplete() {\n\t\tpieces.push( this );\n\t\tif ( pieces.length === rows * cells ) {\n\t\t\tanimComplete();\n\t\t}\n\t}\n\n\t// Clone the element for each row and cell.\n\tfor ( i = 0; i < rows; i++ ) { // ===>\n\t\ttop = offset.top + i * height;\n\t\tmy = i - ( rows - 1 ) / 2;\n\n\t\tfor ( j = 0; j < cells; j++ ) { // |||\n\t\t\tleft = offset.left + j * width;\n\t\t\tmx = j - ( cells - 1 ) / 2;\n\n\t\t\t// Create a clone of the now hidden main element that will be absolute positioned\n\t\t\t// within a wrapper div off the -left and -top equal to size of our pieces\n\t\t\telement\n\t\t\t\t.clone()\n\t\t\t\t.appendTo( \"body\" )\n\t\t\t\t.wrap( \"<div></div>\" )\n\t\t\t\t.css( {\n\t\t\t\t\tposition: \"absolute\",\n\t\t\t\t\tvisibility: \"visible\",\n\t\t\t\t\tleft: -j * width,\n\t\t\t\t\ttop: -i * height\n\t\t\t\t} )\n\n\t\t\t\t// Select the wrapper - make it overflow: hidden and absolute positioned based on\n\t\t\t\t// where the original was located +left and +top equal to the size of pieces\n\t\t\t\t.parent()\n\t\t\t\t\t.addClass( \"ui-effects-explode\" )\n\t\t\t\t\t.css( {\n\t\t\t\t\t\tposition: \"absolute\",\n\t\t\t\t\t\toverflow: \"hidden\",\n\t\t\t\t\t\twidth: width,\n\t\t\t\t\t\theight: height,\n\t\t\t\t\t\tleft: left + ( show ? mx * width : 0 ),\n\t\t\t\t\t\ttop: top + ( show ? my * height : 0 ),\n\t\t\t\t\t\topacity: show ? 0 : 1\n\t\t\t\t\t} )\n\t\t\t\t\t.animate( {\n\t\t\t\t\t\tleft: left + ( show ? 0 : mx * width ),\n\t\t\t\t\t\ttop: top + ( show ? 0 : my * height ),\n\t\t\t\t\t\topacity: show ? 1 : 0\n\t\t\t\t\t}, options.duration || 500, options.easing, childComplete );\n\t\t}\n\t}\n\n\tfunction animComplete() {\n\t\telement.css( {\n\t\t\tvisibility: \"visible\"\n\t\t} );\n\t\t$( pieces ).remove();\n\t\tdone();\n\t}\n} );\n\n} );\n","jquery/ui-modules/effects/effect-fade.js":"/*!\n * jQuery UI Effects Fade 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Fade Effect\n//>>group: Effects\n//>>description: Fades the element.\n//>>docs: http://api.jqueryui.com/fade-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"fade\", \"toggle\", function( options, done ) {\n\tvar show = options.mode === \"show\";\n\n\t$( this )\n\t\t.css( \"opacity\", show ? 0 : 1 )\n\t\t.animate( {\n\t\t\topacity: show ? 1 : 0\n\t\t}, {\n\t\t\tqueue: false,\n\t\t\tduration: options.duration,\n\t\t\teasing: options.easing,\n\t\t\tcomplete: done\n\t\t} );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-fold.js":"/*!\n * jQuery UI Effects Fold 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Fold Effect\n//>>group: Effects\n//>>description: Folds an element first horizontally and then vertically.\n//>>docs: http://api.jqueryui.com/fold-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"fold\", \"hide\", function( options, done ) {\n\n\t// Create element\n\tvar element = $( this ),\n\t\tmode = options.mode,\n\t\tshow = mode === \"show\",\n\t\thide = mode === \"hide\",\n\t\tsize = options.size || 15,\n\t\tpercent = /([0-9]+)%/.exec( size ),\n\t\thorizFirst = !!options.horizFirst,\n\t\tref = horizFirst ? [ \"right\", \"bottom\" ] : [ \"bottom\", \"right\" ],\n\t\tduration = options.duration / 2,\n\n\t\tplaceholder = $.effects.createPlaceholder( element ),\n\n\t\tstart = element.cssClip(),\n\t\tanimation1 = { clip: $.extend( {}, start ) },\n\t\tanimation2 = { clip: $.extend( {}, start ) },\n\n\t\tdistance = [ start[ ref[ 0 ] ], start[ ref[ 1 ] ] ],\n\n\t\tqueuelen = element.queue().length;\n\n\tif ( percent ) {\n\t\tsize = parseInt( percent[ 1 ], 10 ) / 100 * distance[ hide ? 0 : 1 ];\n\t}\n\tanimation1.clip[ ref[ 0 ] ] = size;\n\tanimation2.clip[ ref[ 0 ] ] = size;\n\tanimation2.clip[ ref[ 1 ] ] = 0;\n\n\tif ( show ) {\n\t\telement.cssClip( animation2.clip );\n\t\tif ( placeholder ) {\n\t\t\tplaceholder.css( $.effects.clipToBox( animation2 ) );\n\t\t}\n\n\t\tanimation2.clip = start;\n\t}\n\n\t// Animate\n\telement\n\t\t.queue( function( next ) {\n\t\t\tif ( placeholder ) {\n\t\t\t\tplaceholder\n\t\t\t\t\t.animate( $.effects.clipToBox( animation1 ), duration, options.easing )\n\t\t\t\t\t.animate( $.effects.clipToBox( animation2 ), duration, options.easing );\n\t\t\t}\n\n\t\t\tnext();\n\t\t} )\n\t\t.animate( animation1, duration, options.easing )\n\t\t.animate( animation2, duration, options.easing )\n\t\t.queue( done );\n\n\t$.effects.unshift( element, queuelen, 4 );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-highlight.js":"/*!\n * jQuery UI Effects Highlight 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Highlight Effect\n//>>group: Effects\n//>>description: Highlights the background of an element in a defined color for a custom duration.\n//>>docs: http://api.jqueryui.com/highlight-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"highlight\", \"show\", function( options, done ) {\n\tvar element = $( this ),\n\t\tanimation = {\n\t\t\tbackgroundColor: element.css( \"backgroundColor\" )\n\t\t};\n\n\tif ( options.mode === \"hide\" ) {\n\t\tanimation.opacity = 0;\n\t}\n\n\t$.effects.saveStyle( element );\n\n\telement\n\t\t.css( {\n\t\t\tbackgroundImage: \"none\",\n\t\t\tbackgroundColor: options.color || \"#ffff99\"\n\t\t} )\n\t\t.animate( animation, {\n\t\t\tqueue: false,\n\t\t\tduration: options.duration,\n\t\t\teasing: options.easing,\n\t\t\tcomplete: done\n\t\t} );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-puff.js":"/*!\n * jQuery UI Effects Puff 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Puff Effect\n//>>group: Effects\n//>>description: Creates a puff effect by scaling the element up and hiding it at the same time.\n//>>docs: http://api.jqueryui.com/puff-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\",\n\t\t\t\"./effect-scale\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"puff\", \"hide\", function( options, done ) {\n\tvar newOptions = $.extend( true, {}, options, {\n\t\tfade: true,\n\t\tpercent: parseInt( options.percent, 10 ) || 150\n\t} );\n\n\t$.effects.effect.scale.call( this, newOptions, done );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-pulsate.js":"/*!\n * jQuery UI Effects Pulsate 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Pulsate Effect\n//>>group: Effects\n//>>description: Pulsates an element n times by changing the opacity to zero and back.\n//>>docs: http://api.jqueryui.com/pulsate-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"pulsate\", \"show\", function( options, done ) {\n\tvar element = $( this ),\n\t\tmode = options.mode,\n\t\tshow = mode === \"show\",\n\t\thide = mode === \"hide\",\n\t\tshowhide = show || hide,\n\n\t\t// Showing or hiding leaves off the \"last\" animation\n\t\tanims = ( ( options.times || 5 ) * 2 ) + ( showhide ? 1 : 0 ),\n\t\tduration = options.duration / anims,\n\t\tanimateTo = 0,\n\t\ti = 1,\n\t\tqueuelen = element.queue().length;\n\n\tif ( show || !element.is( \":visible\" ) ) {\n\t\telement.css( \"opacity\", 0 ).show();\n\t\tanimateTo = 1;\n\t}\n\n\t// Anims - 1 opacity \"toggles\"\n\tfor ( ; i < anims; i++ ) {\n\t\telement.animate( { opacity: animateTo }, duration, options.easing );\n\t\tanimateTo = 1 - animateTo;\n\t}\n\n\telement.animate( { opacity: animateTo }, duration, options.easing );\n\n\telement.queue( done );\n\n\t$.effects.unshift( element, queuelen, anims + 1 );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-scale.js":"/*!\n * jQuery UI Effects Scale 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Scale Effect\n//>>group: Effects\n//>>description: Grows or shrinks an element and its content.\n//>>docs: http://api.jqueryui.com/scale-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\",\n\t\t\t\"./effect-size\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"scale\", function( options, done ) {\n\n\t// Create element\n\tvar el = $( this ),\n\t\tmode = options.mode,\n\t\tpercent = parseInt( options.percent, 10 ) ||\n\t\t\t( parseInt( options.percent, 10 ) === 0 ? 0 : ( mode !== \"effect\" ? 0 : 100 ) ),\n\n\t\tnewOptions = $.extend( true, {\n\t\t\tfrom: $.effects.scaledDimensions( el ),\n\t\t\tto: $.effects.scaledDimensions( el, percent, options.direction || \"both\" ),\n\t\t\torigin: options.origin || [ \"middle\", \"center\" ]\n\t\t}, options );\n\n\t// Fade option to support puff\n\tif ( options.fade ) {\n\t\tnewOptions.from.opacity = 1;\n\t\tnewOptions.to.opacity = 0;\n\t}\n\n\t$.effects.effect.size.call( this, newOptions, done );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-shake.js":"/*!\n * jQuery UI Effects Shake 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Shake Effect\n//>>group: Effects\n//>>description: Shakes an element horizontally or vertically n times.\n//>>docs: http://api.jqueryui.com/shake-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"shake\", function( options, done ) {\n\n\tvar i = 1,\n\t\telement = $( this ),\n\t\tdirection = options.direction || \"left\",\n\t\tdistance = options.distance || 20,\n\t\ttimes = options.times || 3,\n\t\tanims = times * 2 + 1,\n\t\tspeed = Math.round( options.duration / anims ),\n\t\tref = ( direction === \"up\" || direction === \"down\" ) ? \"top\" : \"left\",\n\t\tpositiveMotion = ( direction === \"up\" || direction === \"left\" ),\n\t\tanimation = {},\n\t\tanimation1 = {},\n\t\tanimation2 = {},\n\n\t\tqueuelen = element.queue().length;\n\n\t$.effects.createPlaceholder( element );\n\n\t// Animation\n\tanimation[ ref ] = ( positiveMotion ? \"-=\" : \"+=\" ) + distance;\n\tanimation1[ ref ] = ( positiveMotion ? \"+=\" : \"-=\" ) + distance * 2;\n\tanimation2[ ref ] = ( positiveMotion ? \"-=\" : \"+=\" ) + distance * 2;\n\n\t// Animate\n\telement.animate( animation, speed, options.easing );\n\n\t// Shakes\n\tfor ( ; i < times; i++ ) {\n\t\telement\n\t\t\t.animate( animation1, speed, options.easing )\n\t\t\t.animate( animation2, speed, options.easing );\n\t}\n\n\telement\n\t\t.animate( animation1, speed, options.easing )\n\t\t.animate( animation, speed / 2, options.easing )\n\t\t.queue( done );\n\n\t$.effects.unshift( element, queuelen, anims + 1 );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-size.js":"/*!\n * jQuery UI Effects Size 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Size Effect\n//>>group: Effects\n//>>description: Resize an element to a specified width and height.\n//>>docs: http://api.jqueryui.com/size-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"size\", function( options, done ) {\n\n\t// Create element\n\tvar baseline, factor, temp,\n\t\telement = $( this ),\n\n\t\t// Copy for children\n\t\tcProps = [ \"fontSize\" ],\n\t\tvProps = [ \"borderTopWidth\", \"borderBottomWidth\", \"paddingTop\", \"paddingBottom\" ],\n\t\thProps = [ \"borderLeftWidth\", \"borderRightWidth\", \"paddingLeft\", \"paddingRight\" ],\n\n\t\t// Set options\n\t\tmode = options.mode,\n\t\trestore = mode !== \"effect\",\n\t\tscale = options.scale || \"both\",\n\t\torigin = options.origin || [ \"middle\", \"center\" ],\n\t\tposition = element.css( \"position\" ),\n\t\tpos = element.position(),\n\t\toriginal = $.effects.scaledDimensions( element ),\n\t\tfrom = options.from || original,\n\t\tto = options.to || $.effects.scaledDimensions( element, 0 );\n\n\t$.effects.createPlaceholder( element );\n\n\tif ( mode === \"show\" ) {\n\t\ttemp = from;\n\t\tfrom = to;\n\t\tto = temp;\n\t}\n\n\t// Set scaling factor\n\tfactor = {\n\t\tfrom: {\n\t\t\ty: from.height / original.height,\n\t\t\tx: from.width / original.width\n\t\t},\n\t\tto: {\n\t\t\ty: to.height / original.height,\n\t\t\tx: to.width / original.width\n\t\t}\n\t};\n\n\t// Scale the css box\n\tif ( scale === \"box\" || scale === \"both\" ) {\n\n\t\t// Vertical props scaling\n\t\tif ( factor.from.y !== factor.to.y ) {\n\t\t\tfrom = $.effects.setTransition( element, vProps, factor.from.y, from );\n\t\t\tto = $.effects.setTransition( element, vProps, factor.to.y, to );\n\t\t}\n\n\t\t// Horizontal props scaling\n\t\tif ( factor.from.x !== factor.to.x ) {\n\t\t\tfrom = $.effects.setTransition( element, hProps, factor.from.x, from );\n\t\t\tto = $.effects.setTransition( element, hProps, factor.to.x, to );\n\t\t}\n\t}\n\n\t// Scale the content\n\tif ( scale === \"content\" || scale === \"both\" ) {\n\n\t\t// Vertical props scaling\n\t\tif ( factor.from.y !== factor.to.y ) {\n\t\t\tfrom = $.effects.setTransition( element, cProps, factor.from.y, from );\n\t\t\tto = $.effects.setTransition( element, cProps, factor.to.y, to );\n\t\t}\n\t}\n\n\t// Adjust the position properties based on the provided origin points\n\tif ( origin ) {\n\t\tbaseline = $.effects.getBaseline( origin, original );\n\t\tfrom.top = ( original.outerHeight - from.outerHeight ) * baseline.y + pos.top;\n\t\tfrom.left = ( original.outerWidth - from.outerWidth ) * baseline.x + pos.left;\n\t\tto.top = ( original.outerHeight - to.outerHeight ) * baseline.y + pos.top;\n\t\tto.left = ( original.outerWidth - to.outerWidth ) * baseline.x + pos.left;\n\t}\n\tdelete from.outerHeight;\n\tdelete from.outerWidth;\n\telement.css( from );\n\n\t// Animate the children if desired\n\tif ( scale === \"content\" || scale === \"both\" ) {\n\n\t\tvProps = vProps.concat( [ \"marginTop\", \"marginBottom\" ] ).concat( cProps );\n\t\thProps = hProps.concat( [ \"marginLeft\", \"marginRight\" ] );\n\n\t\t// Only animate children with width attributes specified\n\t\t// TODO: is this right? should we include anything with css width specified as well\n\t\telement.find( \"*[width]\" ).each( function() {\n\t\t\tvar child = $( this ),\n\t\t\t\tchildOriginal = $.effects.scaledDimensions( child ),\n\t\t\t\tchildFrom = {\n\t\t\t\t\theight: childOriginal.height * factor.from.y,\n\t\t\t\t\twidth: childOriginal.width * factor.from.x,\n\t\t\t\t\touterHeight: childOriginal.outerHeight * factor.from.y,\n\t\t\t\t\touterWidth: childOriginal.outerWidth * factor.from.x\n\t\t\t\t},\n\t\t\t\tchildTo = {\n\t\t\t\t\theight: childOriginal.height * factor.to.y,\n\t\t\t\t\twidth: childOriginal.width * factor.to.x,\n\t\t\t\t\touterHeight: childOriginal.height * factor.to.y,\n\t\t\t\t\touterWidth: childOriginal.width * factor.to.x\n\t\t\t\t};\n\n\t\t\t// Vertical props scaling\n\t\t\tif ( factor.from.y !== factor.to.y ) {\n\t\t\t\tchildFrom = $.effects.setTransition( child, vProps, factor.from.y, childFrom );\n\t\t\t\tchildTo = $.effects.setTransition( child, vProps, factor.to.y, childTo );\n\t\t\t}\n\n\t\t\t// Horizontal props scaling\n\t\t\tif ( factor.from.x !== factor.to.x ) {\n\t\t\t\tchildFrom = $.effects.setTransition( child, hProps, factor.from.x, childFrom );\n\t\t\t\tchildTo = $.effects.setTransition( child, hProps, factor.to.x, childTo );\n\t\t\t}\n\n\t\t\tif ( restore ) {\n\t\t\t\t$.effects.saveStyle( child );\n\t\t\t}\n\n\t\t\t// Animate children\n\t\t\tchild.css( childFrom );\n\t\t\tchild.animate( childTo, options.duration, options.easing, function() {\n\n\t\t\t\t// Restore children\n\t\t\t\tif ( restore ) {\n\t\t\t\t\t$.effects.restoreStyle( child );\n\t\t\t\t}\n\t\t\t} );\n\t\t} );\n\t}\n\n\t// Animate\n\telement.animate( to, {\n\t\tqueue: false,\n\t\tduration: options.duration,\n\t\teasing: options.easing,\n\t\tcomplete: function() {\n\n\t\t\tvar offset = element.offset();\n\n\t\t\tif ( to.opacity === 0 ) {\n\t\t\t\telement.css( \"opacity\", from.opacity );\n\t\t\t}\n\n\t\t\tif ( !restore ) {\n\t\t\t\telement\n\t\t\t\t\t.css( \"position\", position === \"static\" ? \"relative\" : position )\n\t\t\t\t\t.offset( offset );\n\n\t\t\t\t// Need to save style here so that automatic style restoration\n\t\t\t\t// doesn't restore to the original styles from before the animation.\n\t\t\t\t$.effects.saveStyle( element );\n\t\t\t}\n\n\t\t\tdone();\n\t\t}\n\t} );\n\n} );\n\n} );\n","jquery/ui-modules/effects/effect-slide.js":"/*!\n * jQuery UI Effects Slide 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Slide Effect\n//>>group: Effects\n//>>description: Slides an element in and out of the viewport.\n//>>docs: http://api.jqueryui.com/slide-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.effects.define( \"slide\", \"show\", function( options, done ) {\n\tvar startClip, startRef,\n\t\telement = $( this ),\n\t\tmap = {\n\t\t\tup: [ \"bottom\", \"top\" ],\n\t\t\tdown: [ \"top\", \"bottom\" ],\n\t\t\tleft: [ \"right\", \"left\" ],\n\t\t\tright: [ \"left\", \"right\" ]\n\t\t},\n\t\tmode = options.mode,\n\t\tdirection = options.direction || \"left\",\n\t\tref = ( direction === \"up\" || direction === \"down\" ) ? \"top\" : \"left\",\n\t\tpositiveMotion = ( direction === \"up\" || direction === \"left\" ),\n\t\tdistance = options.distance ||\n\t\t\telement[ ref === \"top\" ? \"outerHeight\" : \"outerWidth\" ]( true ),\n\t\tanimation = {};\n\n\t$.effects.createPlaceholder( element );\n\n\tstartClip = element.cssClip();\n\tstartRef = element.position()[ ref ];\n\n\t// Define hide animation\n\tanimation[ ref ] = ( positiveMotion ? -1 : 1 ) * distance + startRef;\n\tanimation.clip = element.cssClip();\n\tanimation.clip[ map[ direction ][ 1 ] ] = animation.clip[ map[ direction ][ 0 ] ];\n\n\t// Reverse the animation if we're showing\n\tif ( mode === \"show\" ) {\n\t\telement.cssClip( animation.clip );\n\t\telement.css( ref, animation[ ref ] );\n\t\tanimation.clip = startClip;\n\t\tanimation[ ref ] = startRef;\n\t}\n\n\t// Actually animate\n\telement.animate( animation, {\n\t\tqueue: false,\n\t\tduration: options.duration,\n\t\teasing: options.easing,\n\t\tcomplete: done\n\t} );\n} );\n\n} );\n","jquery/ui-modules/effects/effect-transfer.js":"/*!\n * jQuery UI Effects Transfer 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Transfer Effect\n//>>group: Effects\n//>>description: Displays a transfer effect from one element to another.\n//>>docs: http://api.jqueryui.com/transfer-effect/\n//>>demos: http://jqueryui.com/effect/\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../effect\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nvar effect;\nif ( $.uiBackCompat !== false ) {\n\teffect = $.effects.define( \"transfer\", function( options, done ) {\n\t\t$( this ).transfer( options, done );\n\t} );\n}\nreturn effect;\n\n} );\n","jquery/ui-modules/i18n/datepicker-af.js":"/* Afrikaans initialisation for the jQuery UI date picker plugin. */\n/* Written by Renier Pretorius. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.af = {\n\tcloseText: \"Selekteer\",\n\tprevText: \"Vorige\",\n\tnextText: \"Volgende\",\n\tcurrentText: \"Vandag\",\n\tmonthNames: [ \"Januarie\", \"Februarie\", \"Maart\", \"April\", \"Mei\", \"Junie\",\n\t\"Julie\", \"Augustus\", \"September\", \"Oktober\", \"November\", \"Desember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mrt\", \"Apr\", \"Mei\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Des\" ],\n\tdayNames: [ \"Sondag\", \"Maandag\", \"Dinsdag\", \"Woensdag\", \"Donderdag\", \"Vrydag\", \"Saterdag\" ],\n\tdayNamesShort: [ \"Son\", \"Maa\", \"Din\", \"Woe\", \"Don\", \"Vry\", \"Sat\" ],\n\tdayNamesMin: [ \"So\", \"Ma\", \"Di\", \"Wo\", \"Do\", \"Vr\", \"Sa\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.af );\n\nreturn datepicker.regional.af;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ar-DZ.js":"/* Algerian Arabic Translation for jQuery UI date picker plugin.\n/* Used in most of Maghreb countries, primarily in Algeria, Tunisia, Morocco.\n/* Mohamed Cherif BOUCHELAGHEM -- cherifbouchelaghem@yahoo.fr */\n/* Mohamed Amine HADDAD -- zatamine@gmail.com */\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"ar-DZ\" ] = {\n\tcloseText: \"\u0625\u063a\u0644\u0627\u0642\",\n\tprevText: \"&#x3C;\u0627\u0644\u0633\u0627\u0628\u0642\",\n\tnextText: \"\u0627\u0644\u062a\u0627\u0644\u064a&#x3E;\",\n\tcurrentText: \"\u0627\u0644\u064a\u0648\u0645\",\n\tmonthNames: [ \"\u062c\u0627\u0646\u0641\u064a\", \"\u0641\u064a\u0641\u0631\u064a\", \"\u0645\u0627\u0631\u0633\", \"\u0623\u0641\u0631\u064a\u0644\", \"\u0645\u0627\u064a\", \"\u062c\u0648\u0627\u0646\",\n\t\"\u062c\u0648\u064a\u0644\u064a\u0629\", \"\u0623\u0648\u062a\", \"\u0633\u0628\u062a\u0645\u0628\u0631\", \"\u0623\u0643\u062a\u0648\u0628\u0631\", \"\u0646\u0648\u0641\u0645\u0628\u0631\", \"\u062f\u064a\u0633\u0645\u0628\u0631\" ],\n\tmonthNamesShort: [ \"1\", \"2\", \"3\", \"4\", \"5\", \"6\", \"7\", \"8\", \"9\", \"10\", \"11\", \"12\" ],\n\tdayNames: [ \"\u0627\u0644\u0623\u062d\u062f\", \"\u0627\u0644\u0627\u062b\u0646\u064a\u0646\", \"\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621\", \"\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621\", \"\u0627\u0644\u062e\u0645\u064a\u0633\", \"\u0627\u0644\u062c\u0645\u0639\u0629\", \"\u0627\u0644\u0633\u0628\u062a\" ],\n\tdayNamesShort: [ \"\u0627\u0644\u0623\u062d\u062f\", \"\u0627\u0644\u0627\u062b\u0646\u064a\u0646\", \"\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621\", \"\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621\", \"\u0627\u0644\u062e\u0645\u064a\u0633\", \"\u0627\u0644\u062c\u0645\u0639\u0629\", \"\u0627\u0644\u0633\u0628\u062a\" ],\n\tdayNamesMin: [ \"\u062d\", \"\u0646\", \"\u062b\", \"\u0631\", \"\u062e\", \"\u062c\", \"\u0633\" ],\n\tweekHeader: \"\u0623\u0633\u0628\u0648\u0639\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 6,\n\t\tisRTL: true,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"ar-DZ\" ] );\n\nreturn datepicker.regional[ \"ar-DZ\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-ar.js":"/* Arabic Translation for jQuery UI date picker plugin. */\n/* Used in most of Arab countries, primarily in Bahrain, */\n/* Kuwait, Oman, Qatar, Saudi Arabia and the United Arab Emirates, Egypt, Sudan and Yemen. */\n/* Written by Mohammed Alshehri -- m@dralshehri.com */\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ar = {\n\tcloseText: \"\u0625\u063a\u0644\u0627\u0642\",\n\tprevText: \"&#x3C;\u0627\u0644\u0633\u0627\u0628\u0642\",\n\tnextText: \"\u0627\u0644\u062a\u0627\u0644\u064a&#x3E;\",\n\tcurrentText: \"\u0627\u0644\u064a\u0648\u0645\",\n\tmonthNames: [ \"\u064a\u0646\u0627\u064a\u0631\", \"\u0641\u0628\u0631\u0627\u064a\u0631\", \"\u0645\u0627\u0631\u0633\", \"\u0623\u0628\u0631\u064a\u0644\", \"\u0645\u0627\u064a\u0648\", \"\u064a\u0648\u0646\u064a\u0648\",\n\t\"\u064a\u0648\u0644\u064a\u0648\", \"\u0623\u063a\u0633\u0637\u0633\", \"\u0633\u0628\u062a\u0645\u0628\u0631\", \"\u0623\u0643\u062a\u0648\u0628\u0631\", \"\u0646\u0648\u0641\u0645\u0628\u0631\", \"\u062f\u064a\u0633\u0645\u0628\u0631\" ],\n\tmonthNamesShort: [ \"1\", \"2\", \"3\", \"4\", \"5\", \"6\", \"7\", \"8\", \"9\", \"10\", \"11\", \"12\" ],\n\tdayNames: [ \"\u0627\u0644\u0623\u062d\u062f\", \"\u0627\u0644\u0627\u062b\u0646\u064a\u0646\", \"\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621\", \"\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621\", \"\u0627\u0644\u062e\u0645\u064a\u0633\", \"\u0627\u0644\u062c\u0645\u0639\u0629\", \"\u0627\u0644\u0633\u0628\u062a\" ],\n\tdayNamesShort: [ \"\u0623\u062d\u062f\", \"\u0627\u062b\u0646\u064a\u0646\", \"\u062b\u0644\u0627\u062b\u0627\u0621\", \"\u0623\u0631\u0628\u0639\u0627\u0621\", \"\u062e\u0645\u064a\u0633\", \"\u062c\u0645\u0639\u0629\", \"\u0633\u0628\u062a\" ],\n\tdayNamesMin: [ \"\u062d\", \"\u0646\", \"\u062b\", \"\u0631\", \"\u062e\", \"\u062c\", \"\u0633\" ],\n\tweekHeader: \"\u0623\u0633\u0628\u0648\u0639\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\t\tisRTL: true,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ar );\n\nreturn datepicker.regional.ar;\n\n} );\n","jquery/ui-modules/i18n/datepicker-az.js":"/* Azerbaijani (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Jamil Najafov (necefov33@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.az = {\n\tcloseText: \"Ba\u011fla\",\n\tprevText: \"&#x3C;Geri\",\n\tnextText: \"\u0130r\u0259li&#x3E;\",\n\tcurrentText: \"Bug\u00fcn\",\n\tmonthNames: [ \"Yanvar\", \"Fevral\", \"Mart\", \"Aprel\", \"May\", \"\u0130yun\",\n\t\"\u0130yul\", \"Avqust\", \"Sentyabr\", \"Oktyabr\", \"Noyabr\", \"Dekabr\" ],\n\tmonthNamesShort: [ \"Yan\", \"Fev\", \"Mar\", \"Apr\", \"May\", \"\u0130yun\",\n\t\"\u0130yul\", \"Avq\", \"Sen\", \"Okt\", \"Noy\", \"Dek\" ],\n\tdayNames: [ \"Bazar\", \"Bazar ert\u0259si\", \"\u00c7\u0259r\u015f\u0259nb\u0259 ax\u015fam\u0131\", \"\u00c7\u0259r\u015f\u0259nb\u0259\", \"C\u00fcm\u0259 ax\u015fam\u0131\", \"C\u00fcm\u0259\", \"\u015e\u0259nb\u0259\" ],\n\tdayNamesShort: [ \"B\", \"Be\", \"\u00c7a\", \"\u00c7\", \"Ca\", \"C\", \"\u015e\" ],\n\tdayNamesMin: [ \"B\", \"B\", \"\u00c7\", \"\u0421\", \"\u00c7\", \"C\", \"\u015e\" ],\n\tweekHeader: \"Hf\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.az );\n\nreturn datepicker.regional.az;\n\n} );\n","jquery/ui-modules/i18n/datepicker-be.js":"/* Belarusian initialisation for the jQuery UI date picker plugin. */\n/* Written by Pavel Selitskas <p.selitskas@gmail.com> */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.be = {\n\tcloseText: \"\u0417\u0430\u0447\u044b\u043d\u0456\u0446\u044c\",\n\tprevText: \"&larr;\u041f\u0430\u043f\u044f\u0440.\",\n\tnextText: \"\u041d\u0430\u0441\u0442.&rarr;\",\n\tcurrentText: \"\u0421\u0451\u043d\u044c\u043d\u044f\",\n\tmonthNames: [ \"\u0421\u0442\u0443\u0434\u0437\u0435\u043d\u044c\", \"\u041b\u044e\u0442\u044b\", \"\u0421\u0430\u043a\u0430\u0432\u0456\u043a\", \"\u041a\u0440\u0430\u0441\u0430\u0432\u0456\u043a\", \"\u0422\u0440\u0430\u0432\u0435\u043d\u044c\", \"\u0427\u044d\u0440\u0432\u0435\u043d\u044c\",\n\t\"\u041b\u0456\u043f\u0435\u043d\u044c\", \"\u0416\u043d\u0456\u0432\u0435\u043d\u044c\", \"\u0412\u0435\u0440\u0430\u0441\u0435\u043d\u044c\", \"\u041a\u0430\u0441\u0442\u0440\u044b\u0447\u043d\u0456\u043a\", \"\u041b\u0456\u0441\u0442\u0430\u043f\u0430\u0434\", \"\u0421\u044c\u043d\u0435\u0436\u0430\u043d\u044c\" ],\n\tmonthNamesShort: [ \"\u0421\u0442\u0443\", \"\u041b\u044e\u0442\", \"\u0421\u0430\u043a\", \"\u041a\u0440\u0430\", \"\u0422\u0440\u0430\", \"\u0427\u044d\u0440\",\n\t\"\u041b\u0456\u043f\", \"\u0416\u043d\u0456\", \"\u0412\u0435\u0440\", \"\u041a\u0430\u0441\", \"\u041b\u0456\u0441\", \"\u0421\u044c\u043d\" ],\n\tdayNames: [ \"\u043d\u044f\u0434\u0437\u0435\u043b\u044f\", \"\u043f\u0430\u043d\u044f\u0434\u0437\u0435\u043b\u0430\u043a\", \"\u0430\u045e\u0442\u043e\u0440\u0430\u043a\", \"\u0441\u0435\u0440\u0430\u0434\u0430\", \"\u0447\u0430\u0446\u044c\u0432\u0435\u0440\", \"\u043f\u044f\u0442\u043d\u0456\u0446\u0430\", \"\u0441\u0443\u0431\u043e\u0442\u0430\" ],\n\tdayNamesShort: [ \"\u043d\u0434\u0437\", \"\u043f\u043d\u0434\", \"\u0430\u045e\u0442\", \"\u0441\u0440\u0434\", \"\u0447\u0446\u0432\", \"\u043f\u0442\u043d\", \"\u0441\u0431\u0442\" ],\n\tdayNamesMin: [ \"\u041d\u0434\", \"\u041f\u043d\", \"\u0410\u045e\", \"\u0421\u0440\", \"\u0427\u0446\", \"\u041f\u0442\", \"\u0421\u0431\" ],\n\tweekHeader: \"\u0422\u0434\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.be );\n\nreturn datepicker.regional.be;\n\n} );\n","jquery/ui-modules/i18n/datepicker-bg.js":"/* Bulgarian initialisation for the jQuery UI date picker plugin. */\n/* Written by Stoyan Kyosev (http://svest.org). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.bg = {\n\tcloseText: \"\u0437\u0430\u0442\u0432\u043e\u0440\u0438\",\n\tprevText: \"&#x3C;\u043d\u0430\u0437\u0430\u0434\",\n\tnextText: \"\u043d\u0430\u043f\u0440\u0435\u0434&#x3E;\",\n\tnextBigText: \"&#x3E;&#x3E;\",\n\tcurrentText: \"\u0434\u043d\u0435\u0441\",\n\tmonthNames: [ \"\u042f\u043d\u0443\u0430\u0440\u0438\", \"\u0424\u0435\u0432\u0440\u0443\u0430\u0440\u0438\", \"\u041c\u0430\u0440\u0442\", \"\u0410\u043f\u0440\u0438\u043b\", \"\u041c\u0430\u0439\", \"\u042e\u043d\u0438\",\n\t\"\u042e\u043b\u0438\", \"\u0410\u0432\u0433\u0443\u0441\u0442\", \"\u0421\u0435\u043f\u0442\u0435\u043c\u0432\u0440\u0438\", \"\u041e\u043a\u0442\u043e\u043c\u0432\u0440\u0438\", \"\u041d\u043e\u0435\u043c\u0432\u0440\u0438\", \"\u0414\u0435\u043a\u0435\u043c\u0432\u0440\u0438\" ],\n\tmonthNamesShort: [ \"\u042f\u043d\u0443\", \"\u0424\u0435\u0432\", \"\u041c\u0430\u0440\", \"\u0410\u043f\u0440\", \"\u041c\u0430\u0439\", \"\u042e\u043d\u0438\",\n\t\"\u042e\u043b\u0438\", \"\u0410\u0432\u0433\", \"\u0421\u0435\u043f\", \"\u041e\u043a\u0442\", \"\u041d\u043e\u0432\", \"\u0414\u0435\u043a\" ],\n\tdayNames: [ \"\u041d\u0435\u0434\u0435\u043b\u044f\", \"\u041f\u043e\u043d\u0435\u0434\u0435\u043b\u043d\u0438\u043a\", \"\u0412\u0442\u043e\u0440\u043d\u0438\u043a\", \"\u0421\u0440\u044f\u0434\u0430\", \"\u0427\u0435\u0442\u0432\u044a\u0440\u0442\u044a\u043a\", \"\u041f\u0435\u0442\u044a\u043a\", \"\u0421\u044a\u0431\u043e\u0442\u0430\" ],\n\tdayNamesShort: [ \"\u041d\u0435\u0434\", \"\u041f\u043e\u043d\", \"\u0412\u0442\u043e\", \"\u0421\u0440\u044f\", \"\u0427\u0435\u0442\", \"\u041f\u0435\u0442\", \"\u0421\u044a\u0431\" ],\n\tdayNamesMin: [ \"\u041d\u0435\", \"\u041f\u043e\", \"\u0412\u0442\", \"\u0421\u0440\", \"\u0427\u0435\", \"\u041f\u0435\", \"\u0421\u044a\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.bg );\n\nreturn datepicker.regional.bg;\n\n} );\n","jquery/ui-modules/i18n/datepicker-bs.js":"/* Bosnian i18n for the jQuery UI date picker plugin. */\n/* Written by Kenan Konjo. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.bs = {\n\tcloseText: \"Zatvori\",\n\tprevText: \"&#x3C;\",\n\tnextText: \"&#x3E;\",\n\tcurrentText: \"Danas\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"Mart\", \"April\", \"Maj\", \"Juni\",\n\t\"Juli\", \"August\", \"Septembar\", \"Oktobar\", \"Novembar\", \"Decembar\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Maj\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Nedelja\", \"Ponedeljak\", \"Utorak\", \"Srijeda\", \"\u010cetvrtak\", \"Petak\", \"Subota\" ],\n\tdayNamesShort: [ \"Ned\", \"Pon\", \"Uto\", \"Sri\", \"\u010cet\", \"Pet\", \"Sub\" ],\n\tdayNamesMin: [ \"Ne\", \"Po\", \"Ut\", \"Sr\", \"\u010ce\", \"Pe\", \"Su\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.bs );\n\nreturn datepicker.regional.bs;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ca.js":"/* Inicialitzaci\u00f3 en catal\u00e0 per a l'extensi\u00f3 'UI date picker' per jQuery. */\n/* Writers: (joan.leon@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ca = {\n\tcloseText: \"Tanca\",\n\tprevText: \"Anterior\",\n\tnextText: \"Seg\u00fcent\",\n\tcurrentText: \"Avui\",\n\tmonthNames: [ \"gener\", \"febrer\", \"mar\u00e7\", \"abril\", \"maig\", \"juny\",\n\t\"juliol\", \"agost\", \"setembre\", \"octubre\", \"novembre\", \"desembre\" ],\n\tmonthNamesShort: [ \"gen\", \"feb\", \"mar\u00e7\", \"abr\", \"maig\", \"juny\",\n\t\"jul\", \"ag\", \"set\", \"oct\", \"nov\", \"des\" ],\n\tdayNames: [ \"diumenge\", \"dilluns\", \"dimarts\", \"dimecres\", \"dijous\", \"divendres\", \"dissabte\" ],\n\tdayNamesShort: [ \"dg\", \"dl\", \"dt\", \"dc\", \"dj\", \"dv\", \"ds\" ],\n\tdayNamesMin: [ \"dg\", \"dl\", \"dt\", \"dc\", \"dj\", \"dv\", \"ds\" ],\n\tweekHeader: \"Set\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ca );\n\nreturn datepicker.regional.ca;\n\n} );\n","jquery/ui-modules/i18n/datepicker-cs.js":"/* Czech initialisation for the jQuery UI date picker plugin. */\n/* Written by Tomas Muller (tomas@tomas-muller.net). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.cs = {\n\tcloseText: \"Zav\u0159\u00edt\",\n\tprevText: \"&#x3C;D\u0159\u00edve\",\n\tnextText: \"Pozd\u011bji&#x3E;\",\n\tcurrentText: \"Nyn\u00ed\",\n\tmonthNames: [ \"leden\", \"\u00fanor\", \"b\u0159ezen\", \"duben\", \"kv\u011bten\", \"\u010derven\",\n\t\"\u010dervenec\", \"srpen\", \"z\u00e1\u0159\u00ed\", \"\u0159\u00edjen\", \"listopad\", \"prosinec\" ],\n\tmonthNamesShort: [ \"led\", \"\u00fano\", \"b\u0159e\", \"dub\", \"kv\u011b\", \"\u010der\",\n\t\"\u010dvc\", \"srp\", \"z\u00e1\u0159\", \"\u0159\u00edj\", \"lis\", \"pro\" ],\n\tdayNames: [ \"ned\u011ble\", \"pond\u011bl\u00ed\", \"\u00fater\u00fd\", \"st\u0159eda\", \"\u010dtvrtek\", \"p\u00e1tek\", \"sobota\" ],\n\tdayNamesShort: [ \"ne\", \"po\", \"\u00fat\", \"st\", \"\u010dt\", \"p\u00e1\", \"so\" ],\n\tdayNamesMin: [ \"ne\", \"po\", \"\u00fat\", \"st\", \"\u010dt\", \"p\u00e1\", \"so\" ],\n\tweekHeader: \"T\u00fdd\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.cs );\n\nreturn datepicker.regional.cs;\n\n} );\n","jquery/ui-modules/i18n/datepicker-cy-GB.js":"/* Welsh/UK initialisation for the jQuery UI date picker plugin. */\n/* Written by William Griffiths. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"cy-GB\" ] = {\n\tcloseText: \"Done\",\n\tprevText: \"Prev\",\n\tnextText: \"Next\",\n\tcurrentText: \"Today\",\n\tmonthNames: [ \"Ionawr\", \"Chwefror\", \"Mawrth\", \"Ebrill\", \"Mai\", \"Mehefin\",\n\t\"Gorffennaf\", \"Awst\", \"Medi\", \"Hydref\", \"Tachwedd\", \"Rhagfyr\" ],\n\tmonthNamesShort: [ \"Ion\", \"Chw\", \"Maw\", \"Ebr\", \"Mai\", \"Meh\",\n\t\"Gor\", \"Aws\", \"Med\", \"Hyd\", \"Tac\", \"Rha\" ],\n\tdayNames: [\n\t\t\"Dydd Sul\",\n\t\t\"Dydd Llun\",\n\t\t\"Dydd Mawrth\",\n\t\t\"Dydd Mercher\",\n\t\t\"Dydd Iau\",\n\t\t\"Dydd Gwener\",\n\t\t\"Dydd Sadwrn\"\n\t],\n\tdayNamesShort: [ \"Sul\", \"Llu\", \"Maw\", \"Mer\", \"Iau\", \"Gwe\", \"Sad\" ],\n\tdayNamesMin: [ \"Su\", \"Ll\", \"Ma\", \"Me\", \"Ia\", \"Gw\", \"Sa\" ],\n\tweekHeader: \"Wy\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"cy-GB\" ] );\n\nreturn datepicker.regional[ \"cy-GB\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-da.js":"/* Danish initialisation for the jQuery UI date picker plugin. */\n/* Written by Jan Christensen ( deletestuff@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.da = {\n\tcloseText: \"Luk\",\n\tprevText: \"&#x3C;Forrige\",\n\tnextText: \"N\u00e6ste&#x3E;\",\n\tcurrentText: \"I dag\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"Marts\", \"April\", \"Maj\", \"Juni\",\n\t\"Juli\", \"August\", \"September\", \"Oktober\", \"November\", \"December\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Maj\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"S\u00f8ndag\", \"Mandag\", \"Tirsdag\", \"Onsdag\", \"Torsdag\", \"Fredag\", \"L\u00f8rdag\" ],\n\tdayNamesShort: [ \"S\u00f8n\", \"Man\", \"Tir\", \"Ons\", \"Tor\", \"Fre\", \"L\u00f8r\" ],\n\tdayNamesMin: [ \"S\u00f8\", \"Ma\", \"Ti\", \"On\", \"To\", \"Fr\", \"L\u00f8\" ],\n\tweekHeader: \"Uge\",\n\tdateFormat: \"dd-mm-yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.da );\n\nreturn datepicker.regional.da;\n\n} );\n","jquery/ui-modules/i18n/datepicker-de-AT.js":"/* German/Austrian initialisation for the jQuery UI date picker plugin. */\n/* Based on the de initialisation. */\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"de-AT\" ] = {\n\tcloseText: \"Schlie\u00dfen\",\n\tprevText: \"&#x3C;Zur\u00fcck\",\n\tnextText: \"Vor&#x3E;\",\n\tcurrentText: \"Heute\",\n\tmonthNames: [ \"J\u00e4nner\", \"Februar\", \"M\u00e4rz\", \"April\", \"Mai\", \"Juni\",\n\t\"Juli\", \"August\", \"September\", \"Oktober\", \"November\", \"Dezember\" ],\n\tmonthNamesShort: [ \"J\u00e4n\", \"Feb\", \"M\u00e4r\", \"Apr\", \"Mai\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dez\" ],\n\tdayNames: [ \"Sonntag\", \"Montag\", \"Dienstag\", \"Mittwoch\", \"Donnerstag\", \"Freitag\", \"Samstag\" ],\n\tdayNamesShort: [ \"So\", \"Mo\", \"Di\", \"Mi\", \"Do\", \"Fr\", \"Sa\" ],\n\tdayNamesMin: [ \"So\", \"Mo\", \"Di\", \"Mi\", \"Do\", \"Fr\", \"Sa\" ],\n\tweekHeader: \"KW\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"de-AT\" ] );\n\nreturn datepicker.regional[ \"de-AT\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-de.js":"/* German initialisation for the jQuery UI date picker plugin. */\n/* Written by Milian Wolff (mail@milianw.de). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.de = {\n\tcloseText: \"Schlie\u00dfen\",\n\tprevText: \"&#x3C;Zur\u00fcck\",\n\tnextText: \"Vor&#x3E;\",\n\tcurrentText: \"Heute\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"M\u00e4rz\", \"April\", \"Mai\", \"Juni\",\n\t\"Juli\", \"August\", \"September\", \"Oktober\", \"November\", \"Dezember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"M\u00e4r\", \"Apr\", \"Mai\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dez\" ],\n\tdayNames: [ \"Sonntag\", \"Montag\", \"Dienstag\", \"Mittwoch\", \"Donnerstag\", \"Freitag\", \"Samstag\" ],\n\tdayNamesShort: [ \"So\", \"Mo\", \"Di\", \"Mi\", \"Do\", \"Fr\", \"Sa\" ],\n\tdayNamesMin: [ \"So\", \"Mo\", \"Di\", \"Mi\", \"Do\", \"Fr\", \"Sa\" ],\n\tweekHeader: \"KW\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.de );\n\nreturn datepicker.regional.de;\n\n} );\n","jquery/ui-modules/i18n/datepicker-el.js":"/* Greek (el) initialisation for the jQuery UI date picker plugin. */\n/* Written by Alex Cicovic (http://www.alexcicovic.com) */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.el = {\n\tcloseText: \"\u039a\u03bb\u03b5\u03af\u03c3\u03b9\u03bc\u03bf\",\n\tprevText: \"\u03a0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03bf\u03c2\",\n\tnextText: \"\u0395\u03c0\u03cc\u03bc\u03b5\u03bd\u03bf\u03c2\",\n\tcurrentText: \"\u03a3\u03ae\u03bc\u03b5\u03c1\u03b1\",\n\tmonthNames: [ \"\u0399\u03b1\u03bd\u03bf\u03c5\u03ac\u03c1\u03b9\u03bf\u03c2\", \"\u03a6\u03b5\u03b2\u03c1\u03bf\u03c5\u03ac\u03c1\u03b9\u03bf\u03c2\", \"\u039c\u03ac\u03c1\u03c4\u03b9\u03bf\u03c2\", \"\u0391\u03c0\u03c1\u03af\u03bb\u03b9\u03bf\u03c2\", \"\u039c\u03ac\u03b9\u03bf\u03c2\", \"\u0399\u03bf\u03cd\u03bd\u03b9\u03bf\u03c2\",\n\t\"\u0399\u03bf\u03cd\u03bb\u03b9\u03bf\u03c2\", \"\u0391\u03cd\u03b3\u03bf\u03c5\u03c3\u03c4\u03bf\u03c2\", \"\u03a3\u03b5\u03c0\u03c4\u03ad\u03bc\u03b2\u03c1\u03b9\u03bf\u03c2\", \"\u039f\u03ba\u03c4\u03ce\u03b2\u03c1\u03b9\u03bf\u03c2\", \"\u039d\u03bf\u03ad\u03bc\u03b2\u03c1\u03b9\u03bf\u03c2\", \"\u0394\u03b5\u03ba\u03ad\u03bc\u03b2\u03c1\u03b9\u03bf\u03c2\" ],\n\tmonthNamesShort: [ \"\u0399\u03b1\u03bd\", \"\u03a6\u03b5\u03b2\", \"\u039c\u03b1\u03c1\", \"\u0391\u03c0\u03c1\", \"\u039c\u03b1\u03b9\", \"\u0399\u03bf\u03c5\u03bd\",\n\t\"\u0399\u03bf\u03c5\u03bb\", \"\u0391\u03c5\u03b3\", \"\u03a3\u03b5\u03c0\", \"\u039f\u03ba\u03c4\", \"\u039d\u03bf\u03b5\", \"\u0394\u03b5\u03ba\" ],\n\tdayNames: [ \"\u039a\u03c5\u03c1\u03b9\u03b1\u03ba\u03ae\", \"\u0394\u03b5\u03c5\u03c4\u03ad\u03c1\u03b1\", \"\u03a4\u03c1\u03af\u03c4\u03b7\", \"\u03a4\u03b5\u03c4\u03ac\u03c1\u03c4\u03b7\", \"\u03a0\u03ad\u03bc\u03c0\u03c4\u03b7\", \"\u03a0\u03b1\u03c1\u03b1\u03c3\u03ba\u03b5\u03c5\u03ae\", \"\u03a3\u03ac\u03b2\u03b2\u03b1\u03c4\u03bf\" ],\n\tdayNamesShort: [ \"\u039a\u03c5\u03c1\", \"\u0394\u03b5\u03c5\", \"\u03a4\u03c1\u03b9\", \"\u03a4\u03b5\u03c4\", \"\u03a0\u03b5\u03bc\", \"\u03a0\u03b1\u03c1\", \"\u03a3\u03b1\u03b2\" ],\n\tdayNamesMin: [ \"\u039a\u03c5\", \"\u0394\u03b5\", \"\u03a4\u03c1\", \"\u03a4\u03b5\", \"\u03a0\u03b5\", \"\u03a0\u03b1\", \"\u03a3\u03b1\" ],\n\tweekHeader: \"\u0395\u03b2\u03b4\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.el );\n\nreturn datepicker.regional.el;\n\n} );\n","jquery/ui-modules/i18n/datepicker-en-AU.js":"/* English/Australia initialisation for the jQuery UI date picker plugin. */\n/* Based on the en-GB initialisation. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"en-AU\" ] = {\n\tcloseText: \"Done\",\n\tprevText: \"Prev\",\n\tnextText: \"Next\",\n\tcurrentText: \"Today\",\n\tmonthNames: [ \"January\", \"February\", \"March\", \"April\", \"May\", \"June\",\n\t\"July\", \"August\", \"September\", \"October\", \"November\", \"December\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"May\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Oct\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\" ],\n\tdayNamesShort: [ \"Sun\", \"Mon\", \"Tue\", \"Wed\", \"Thu\", \"Fri\", \"Sat\" ],\n\tdayNamesMin: [ \"Su\", \"Mo\", \"Tu\", \"We\", \"Th\", \"Fr\", \"Sa\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"en-AU\" ] );\n\nreturn datepicker.regional[ \"en-AU\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-en-GB.js":"/* English/UK initialisation for the jQuery UI date picker plugin. */\n/* Written by Stuart. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"en-GB\" ] = {\n\tcloseText: \"Done\",\n\tprevText: \"Prev\",\n\tnextText: \"Next\",\n\tcurrentText: \"Today\",\n\tmonthNames: [ \"January\", \"February\", \"March\", \"April\", \"May\", \"June\",\n\t\"July\", \"August\", \"September\", \"October\", \"November\", \"December\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"May\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Oct\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\" ],\n\tdayNamesShort: [ \"Sun\", \"Mon\", \"Tue\", \"Wed\", \"Thu\", \"Fri\", \"Sat\" ],\n\tdayNamesMin: [ \"Su\", \"Mo\", \"Tu\", \"We\", \"Th\", \"Fr\", \"Sa\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"en-GB\" ] );\n\nreturn datepicker.regional[ \"en-GB\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-en-NZ.js":"/* English/New Zealand initialisation for the jQuery UI date picker plugin. */\n/* Based on the en-GB initialisation. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"en-NZ\" ] = {\n\tcloseText: \"Done\",\n\tprevText: \"Prev\",\n\tnextText: \"Next\",\n\tcurrentText: \"Today\",\n\tmonthNames: [ \"January\", \"February\", \"March\", \"April\", \"May\", \"June\",\n\t\"July\", \"August\", \"September\", \"October\", \"November\", \"December\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"May\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Oct\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\" ],\n\tdayNamesShort: [ \"Sun\", \"Mon\", \"Tue\", \"Wed\", \"Thu\", \"Fri\", \"Sat\" ],\n\tdayNamesMin: [ \"Su\", \"Mo\", \"Tu\", \"We\", \"Th\", \"Fr\", \"Sa\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"en-NZ\" ] );\n\nreturn datepicker.regional[ \"en-NZ\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-eo.js":"/* Esperanto initialisation for the jQuery UI date picker plugin. */\n/* Written by Olivier M. (olivierweb@ifrance.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.eo = {\n\tcloseText: \"Fermi\",\n\tprevText: \"&#x3C;Anta\",\n\tnextText: \"Sekv&#x3E;\",\n\tcurrentText: \"Nuna\",\n\tmonthNames: [ \"Januaro\", \"Februaro\", \"Marto\", \"Aprilo\", \"Majo\", \"Junio\",\n\t\"Julio\", \"A\u016dgusto\", \"Septembro\", \"Oktobro\", \"Novembro\", \"Decembro\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Maj\", \"Jun\",\n\t\"Jul\", \"A\u016dg\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Diman\u0109o\", \"Lundo\", \"Mardo\", \"Merkredo\", \"\u0134a\u016ddo\", \"Vendredo\", \"Sabato\" ],\n\tdayNamesShort: [ \"Dim\", \"Lun\", \"Mar\", \"Mer\", \"\u0134a\u016d\", \"Ven\", \"Sab\" ],\n\tdayNamesMin: [ \"Di\", \"Lu\", \"Ma\", \"Me\", \"\u0134a\", \"Ve\", \"Sa\" ],\n\tweekHeader: \"Sb\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.eo );\n\nreturn datepicker.regional.eo;\n\n} );\n","jquery/ui-modules/i18n/datepicker-es.js":"/* Inicializaci\u00f3n en espa\u00f1ol para la extensi\u00f3n 'UI date picker' para jQuery. */\n/* Traducido por Vester (xvester@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.es = {\n\tcloseText: \"Cerrar\",\n\tprevText: \"&#x3C;Ant\",\n\tnextText: \"Sig&#x3E;\",\n\tcurrentText: \"Hoy\",\n\tmonthNames: [ \"enero\", \"febrero\", \"marzo\", \"abril\", \"mayo\", \"junio\",\n\t\"julio\", \"agosto\", \"septiembre\", \"octubre\", \"noviembre\", \"diciembre\" ],\n\tmonthNamesShort: [ \"ene\", \"feb\", \"mar\", \"abr\", \"may\", \"jun\",\n\t\"jul\", \"ago\", \"sep\", \"oct\", \"nov\", \"dic\" ],\n\tdayNames: [ \"domingo\", \"lunes\", \"martes\", \"mi\u00e9rcoles\", \"jueves\", \"viernes\", \"s\u00e1bado\" ],\n\tdayNamesShort: [ \"dom\", \"lun\", \"mar\", \"mi\u00e9\", \"jue\", \"vie\", \"s\u00e1b\" ],\n\tdayNamesMin: [ \"D\", \"L\", \"M\", \"X\", \"J\", \"V\", \"S\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.es );\n\nreturn datepicker.regional.es;\n\n} );\n","jquery/ui-modules/i18n/datepicker-et.js":"/* Estonian initialisation for the jQuery UI date picker plugin. */\n/* Written by Mart S\u00f5mermaa (mrts.pydev at gmail com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.et = {\n\tcloseText: \"Sulge\",\n\tprevText: \"Eelnev\",\n\tnextText: \"J\u00e4rgnev\",\n\tcurrentText: \"T\u00e4na\",\n\tmonthNames: [ \"Jaanuar\", \"Veebruar\", \"M\u00e4rts\", \"Aprill\", \"Mai\", \"Juuni\",\n\t\"Juuli\", \"August\", \"September\", \"Oktoober\", \"November\", \"Detsember\" ],\n\tmonthNamesShort: [ \"Jaan\", \"Veebr\", \"M\u00e4rts\", \"Apr\", \"Mai\", \"Juuni\",\n\t\"Juuli\", \"Aug\", \"Sept\", \"Okt\", \"Nov\", \"Dets\" ],\n\tdayNames: [\n\t\t\"P\u00fchap\u00e4ev\",\n\t\t\"Esmasp\u00e4ev\",\n\t\t\"Teisip\u00e4ev\",\n\t\t\"Kolmap\u00e4ev\",\n\t\t\"Neljap\u00e4ev\",\n\t\t\"Reede\",\n\t\t\"Laup\u00e4ev\"\n\t],\n\tdayNamesShort: [ \"P\u00fchap\", \"Esmasp\", \"Teisip\", \"Kolmap\", \"Neljap\", \"Reede\", \"Laup\" ],\n\tdayNamesMin: [ \"P\", \"E\", \"T\", \"K\", \"N\", \"R\", \"L\" ],\n\tweekHeader: \"n\u00e4d\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.et );\n\nreturn datepicker.regional.et;\n\n} );\n","jquery/ui-modules/i18n/datepicker-eu.js":"/* Karrikas-ek itzulia (karrikas@karrikas.com) */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.eu = {\n\tcloseText: \"Egina\",\n\tprevText: \"&#x3C;Aur\",\n\tnextText: \"Hur&#x3E;\",\n\tcurrentText: \"Gaur\",\n\tmonthNames: [ \"urtarrila\", \"otsaila\", \"martxoa\", \"apirila\", \"maiatza\", \"ekaina\",\n\t\t\"uztaila\", \"abuztua\", \"iraila\", \"urria\", \"azaroa\", \"abendua\" ],\n\tmonthNamesShort: [ \"urt.\", \"ots.\", \"mar.\", \"api.\", \"mai.\", \"eka.\",\n\t\t\"uzt.\", \"abu.\", \"ira.\", \"urr.\", \"aza.\", \"abe.\" ],\n\tdayNames: [ \"igandea\", \"astelehena\", \"asteartea\", \"asteazkena\", \"osteguna\", \"ostirala\", \"larunbata\" ],\n\tdayNamesShort: [ \"ig.\", \"al.\", \"ar.\", \"az.\", \"og.\", \"ol.\", \"lr.\" ],\n\tdayNamesMin: [ \"ig\", \"al\", \"ar\", \"az\", \"og\", \"ol\", \"lr\" ],\n\tweekHeader: \"As\",\n\tdateFormat: \"yy-mm-dd\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.eu );\n\nreturn datepicker.regional.eu;\n\n} );\n","jquery/ui-modules/i18n/datepicker-fa.js":"/* Persian (Farsi) Translation for the jQuery UI date picker plugin. */\n/* Javad Mowlanezhad -- jmowla@gmail.com */\n/* Jalali calendar should supported soon! (Its implemented but I have to test it) */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.fa = {\n\tcloseText: \"\u0628\u0633\u062a\u0646\",\n\tprevText: \"&#x3C;\u0642\u0628\u0644\u06cc\",\n\tnextText: \"\u0628\u0639\u062f\u06cc&#x3E;\",\n\tcurrentText: \"\u0627\u0645\u0631\u0648\u0632\",\n\tmonthNames: [\n\t\t\"\u0698\u0627\u0646\u0648\u06cc\u0647\",\n\t\t\"\u0641\u0648\u0631\u06cc\u0647\",\n\t\t\"\u0645\u0627\u0631\u0633\",\n\t\t\"\u0622\u0648\u0631\u06cc\u0644\",\n\t\t\"\u0645\u0647\",\n\t\t\"\u0698\u0648\u0626\u0646\",\n\t\t\"\u0698\u0648\u0626\u06cc\u0647\",\n\t\t\"\u0627\u0648\u062a\",\n\t\t\"\u0633\u067e\u062a\u0627\u0645\u0628\u0631\",\n\t\t\"\u0627\u06a9\u062a\u0628\u0631\",\n\t\t\"\u0646\u0648\u0627\u0645\u0628\u0631\",\n\t\t\"\u062f\u0633\u0627\u0645\u0628\u0631\"\n\t],\n\tmonthNamesShort: [ \"1\", \"2\", \"3\", \"4\", \"5\", \"6\", \"7\", \"8\", \"9\", \"10\", \"11\", \"12\" ],\n\tdayNames: [\n\t\t\"\u064a\u06a9\u0634\u0646\u0628\u0647\",\n\t\t\"\u062f\u0648\u0634\u0646\u0628\u0647\",\n\t\t\"\u0633\u0647\u200c\u0634\u0646\u0628\u0647\",\n\t\t\"\u0686\u0647\u0627\u0631\u0634\u0646\u0628\u0647\",\n\t\t\"\u067e\u0646\u062c\u0634\u0646\u0628\u0647\",\n\t\t\"\u062c\u0645\u0639\u0647\",\n\t\t\"\u0634\u0646\u0628\u0647\"\n\t],\n\tdayNamesShort: [\n\t\t\"\u06cc\",\n\t\t\"\u062f\",\n\t\t\"\u0633\",\n\t\t\"\u0686\",\n\t\t\"\u067e\",\n\t\t\"\u062c\",\n\t\t\"\u0634\"\n\t],\n\tdayNamesMin: [\n\t\t\"\u06cc\",\n\t\t\"\u062f\",\n\t\t\"\u0633\",\n\t\t\"\u0686\",\n\t\t\"\u067e\",\n\t\t\"\u062c\",\n\t\t\"\u0634\"\n\t],\n\tweekHeader: \"\u0647\u0641\",\n\tdateFormat: \"yy/mm/dd\",\n\tfirstDay: 6,\n\tisRTL: true,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.fa );\n\nreturn datepicker.regional.fa;\n\n} );\n","jquery/ui-modules/i18n/datepicker-fi.js":"/* Finnish initialisation for the jQuery UI date picker plugin. */\n/* Written by Harri Kilpi\u00f6 (harrikilpio@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.fi = {\n\tcloseText: \"Sulje\",\n\tprevText: \"&#xAB;Edellinen\",\n\tnextText: \"Seuraava&#xBB;\",\n\tcurrentText: \"T\u00e4n\u00e4\u00e4n\",\n\tmonthNames: [ \"Tammikuu\", \"Helmikuu\", \"Maaliskuu\", \"Huhtikuu\", \"Toukokuu\", \"Kes\u00e4kuu\",\n\t\"Hein\u00e4kuu\", \"Elokuu\", \"Syyskuu\", \"Lokakuu\", \"Marraskuu\", \"Joulukuu\" ],\n\tmonthNamesShort: [ \"Tammi\", \"Helmi\", \"Maalis\", \"Huhti\", \"Touko\", \"Kes\u00e4\",\n\t\"Hein\u00e4\", \"Elo\", \"Syys\", \"Loka\", \"Marras\", \"Joulu\" ],\n\tdayNamesShort: [ \"Su\", \"Ma\", \"Ti\", \"Ke\", \"To\", \"Pe\", \"La\" ],\n\tdayNames: [ \"Sunnuntai\", \"Maanantai\", \"Tiistai\", \"Keskiviikko\", \"Torstai\", \"Perjantai\", \"Lauantai\" ],\n\tdayNamesMin: [ \"Su\", \"Ma\", \"Ti\", \"Ke\", \"To\", \"Pe\", \"La\" ],\n\tweekHeader: \"Vk\",\n\tdateFormat: \"d.m.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.fi );\n\nreturn datepicker.regional.fi;\n\n} );\n","jquery/ui-modules/i18n/datepicker-fo.js":"/* Faroese initialisation for the jQuery UI date picker plugin */\n/* Written by Sverri Mohr Olsen, sverrimo@gmail.com */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.fo = {\n\tcloseText: \"Lat aftur\",\n\tprevText: \"&#x3C;Fyrra\",\n\tnextText: \"N\u00e6sta&#x3E;\",\n\tcurrentText: \"\u00cd dag\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"Mars\", \"Apr\u00edl\", \"Mei\", \"Juni\",\n\t\"Juli\", \"August\", \"September\", \"Oktober\", \"November\", \"Desember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Mei\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Des\" ],\n\tdayNames: [\n\t\t\"Sunnudagur\",\n\t\t\"M\u00e1nadagur\",\n\t\t\"T\u00fdsdagur\",\n\t\t\"Mikudagur\",\n\t\t\"H\u00f3sdagur\",\n\t\t\"Fr\u00edggjadagur\",\n\t\t\"Leyardagur\"\n\t],\n\tdayNamesShort: [ \"Sun\", \"M\u00e1n\", \"T\u00fds\", \"Mik\", \"H\u00f3s\", \"Fr\u00ed\", \"Ley\" ],\n\tdayNamesMin: [ \"Su\", \"M\u00e1\", \"T\u00fd\", \"Mi\", \"H\u00f3\", \"Fr\", \"Le\" ],\n\tweekHeader: \"Vk\",\n\tdateFormat: \"dd-mm-yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.fo );\n\nreturn datepicker.regional.fo;\n\n} );\n","jquery/ui-modules/i18n/datepicker-fr-CA.js":"/* Canadian-French initialisation for the jQuery UI date picker plugin. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"fr-CA\" ] = {\n\tcloseText: \"Fermer\",\n\tprevText: \"Pr\u00e9c\u00e9dent\",\n\tnextText: \"Suivant\",\n\tcurrentText: \"Aujourd'hui\",\n\tmonthNames: [ \"janvier\", \"f\u00e9vrier\", \"mars\", \"avril\", \"mai\", \"juin\",\n\t\t\"juillet\", \"ao\u00fbt\", \"septembre\", \"octobre\", \"novembre\", \"d\u00e9cembre\" ],\n\tmonthNamesShort: [ \"janv.\", \"f\u00e9vr.\", \"mars\", \"avril\", \"mai\", \"juin\",\n\t\t\"juil.\", \"ao\u00fbt\", \"sept.\", \"oct.\", \"nov.\", \"d\u00e9c.\" ],\n\tdayNames: [ \"dimanche\", \"lundi\", \"mardi\", \"mercredi\", \"jeudi\", \"vendredi\", \"samedi\" ],\n\tdayNamesShort: [ \"dim.\", \"lun.\", \"mar.\", \"mer.\", \"jeu.\", \"ven.\", \"sam.\" ],\n\tdayNamesMin: [ \"D\", \"L\", \"M\", \"M\", \"J\", \"V\", \"S\" ],\n\tweekHeader: \"Sem.\",\n\tdateFormat: \"yy-mm-dd\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\"\n};\ndatepicker.setDefaults( datepicker.regional[ \"fr-CA\" ] );\n\nreturn datepicker.regional[ \"fr-CA\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-fr-CH.js":"/* Swiss-French initialisation for the jQuery UI date picker plugin. */\n/* Written Martin Voelkle (martin.voelkle@e-tc.ch). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"fr-CH\" ] = {\n\tcloseText: \"Fermer\",\n\tprevText: \"&#x3C;Pr\u00e9c\",\n\tnextText: \"Suiv&#x3E;\",\n\tcurrentText: \"Courant\",\n\tmonthNames: [ \"janvier\", \"f\u00e9vrier\", \"mars\", \"avril\", \"mai\", \"juin\",\n\t\t\"juillet\", \"ao\u00fbt\", \"septembre\", \"octobre\", \"novembre\", \"d\u00e9cembre\" ],\n\tmonthNamesShort: [ \"janv.\", \"f\u00e9vr.\", \"mars\", \"avril\", \"mai\", \"juin\",\n\t\t\"juil.\", \"ao\u00fbt\", \"sept.\", \"oct.\", \"nov.\", \"d\u00e9c.\" ],\n\tdayNames: [ \"dimanche\", \"lundi\", \"mardi\", \"mercredi\", \"jeudi\", \"vendredi\", \"samedi\" ],\n\tdayNamesShort: [ \"dim.\", \"lun.\", \"mar.\", \"mer.\", \"jeu.\", \"ven.\", \"sam.\" ],\n\tdayNamesMin: [ \"D\", \"L\", \"M\", \"M\", \"J\", \"V\", \"S\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"fr-CH\" ] );\n\nreturn datepicker.regional[ \"fr-CH\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-fr.js":"/* French initialisation for the jQuery UI date picker plugin. */\n/* Written by Keith Wood (kbwood{at}iinet.com.au),\n\t\t\t  St\u00e9phane Nahmani (sholby@sholby.net),\n\t\t\t  St\u00e9phane Raimbault <stephane.raimbault@gmail.com> */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.fr = {\n\tcloseText: \"Fermer\",\n\tprevText: \"Pr\u00e9c\u00e9dent\",\n\tnextText: \"Suivant\",\n\tcurrentText: \"Aujourd'hui\",\n\tmonthNames: [ \"janvier\", \"f\u00e9vrier\", \"mars\", \"avril\", \"mai\", \"juin\",\n\t\t\"juillet\", \"ao\u00fbt\", \"septembre\", \"octobre\", \"novembre\", \"d\u00e9cembre\" ],\n\tmonthNamesShort: [ \"janv.\", \"f\u00e9vr.\", \"mars\", \"avr.\", \"mai\", \"juin\",\n\t\t\"juil.\", \"ao\u00fbt\", \"sept.\", \"oct.\", \"nov.\", \"d\u00e9c.\" ],\n\tdayNames: [ \"dimanche\", \"lundi\", \"mardi\", \"mercredi\", \"jeudi\", \"vendredi\", \"samedi\" ],\n\tdayNamesShort: [ \"dim.\", \"lun.\", \"mar.\", \"mer.\", \"jeu.\", \"ven.\", \"sam.\" ],\n\tdayNamesMin: [ \"D\", \"L\", \"M\", \"M\", \"J\", \"V\", \"S\" ],\n\tweekHeader: \"Sem.\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.fr );\n\nreturn datepicker.regional.fr;\n\n} );\n","jquery/ui-modules/i18n/datepicker-gl.js":"/* Galician localization for 'UI date picker' jQuery extension. */\n/* Translated by Jorge Barreiro <yortx.barry@gmail.com>. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.gl = {\n\tcloseText: \"Pechar\",\n\tprevText: \"&#x3C;Ant\",\n\tnextText: \"Seg&#x3E;\",\n\tcurrentText: \"Hoxe\",\n\tmonthNames: [ \"Xaneiro\", \"Febreiro\", \"Marzo\", \"Abril\", \"Maio\", \"Xu\u00f1o\",\n\t\"Xullo\", \"Agosto\", \"Setembro\", \"Outubro\", \"Novembro\", \"Decembro\" ],\n\tmonthNamesShort: [ \"Xan\", \"Feb\", \"Mar\", \"Abr\", \"Mai\", \"Xu\u00f1\",\n\t\"Xul\", \"Ago\", \"Set\", \"Out\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Domingo\", \"Luns\", \"Martes\", \"M\u00e9rcores\", \"Xoves\", \"Venres\", \"S\u00e1bado\" ],\n\tdayNamesShort: [ \"Dom\", \"Lun\", \"Mar\", \"M\u00e9r\", \"Xov\", \"Ven\", \"S\u00e1b\" ],\n\tdayNamesMin: [ \"Do\", \"Lu\", \"Ma\", \"M\u00e9\", \"Xo\", \"Ve\", \"S\u00e1\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.gl );\n\nreturn datepicker.regional.gl;\n\n} );\n","jquery/ui-modules/i18n/datepicker-he.js":"/* Hebrew initialisation for the UI Datepicker extension. */\n/* Written by Amir Hardon (ahardon at gmail dot com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.he = {\n\tcloseText: \"\u05e1\u05d2\u05d5\u05e8\",\n\tprevText: \"&#x3C;\u05d4\u05e7\u05d5\u05d3\u05dd\",\n\tnextText: \"\u05d4\u05d1\u05d0&#x3E;\",\n\tcurrentText: \"\u05d4\u05d9\u05d5\u05dd\",\n\tmonthNames: [ \"\u05d9\u05e0\u05d5\u05d0\u05e8\", \"\u05e4\u05d1\u05e8\u05d5\u05d0\u05e8\", \"\u05de\u05e8\u05e5\", \"\u05d0\u05e4\u05e8\u05d9\u05dc\", \"\u05de\u05d0\u05d9\", \"\u05d9\u05d5\u05e0\u05d9\",\n\t\"\u05d9\u05d5\u05dc\u05d9\", \"\u05d0\u05d5\u05d2\u05d5\u05e1\u05d8\", \"\u05e1\u05e4\u05d8\u05de\u05d1\u05e8\", \"\u05d0\u05d5\u05e7\u05d8\u05d5\u05d1\u05e8\", \"\u05e0\u05d5\u05d1\u05de\u05d1\u05e8\", \"\u05d3\u05e6\u05de\u05d1\u05e8\" ],\n\tmonthNamesShort: [ \"\u05d9\u05e0\u05d5\", \"\u05e4\u05d1\u05e8\", \"\u05de\u05e8\u05e5\", \"\u05d0\u05e4\u05e8\", \"\u05de\u05d0\u05d9\", \"\u05d9\u05d5\u05e0\u05d9\",\n\t\"\u05d9\u05d5\u05dc\u05d9\", \"\u05d0\u05d5\u05d2\", \"\u05e1\u05e4\u05d8\", \"\u05d0\u05d5\u05e7\", \"\u05e0\u05d5\u05d1\", \"\u05d3\u05e6\u05de\" ],\n\tdayNames: [ \"\u05e8\u05d0\u05e9\u05d5\u05df\", \"\u05e9\u05e0\u05d9\", \"\u05e9\u05dc\u05d9\u05e9\u05d9\", \"\u05e8\u05d1\u05d9\u05e2\u05d9\", \"\u05d7\u05de\u05d9\u05e9\u05d9\", \"\u05e9\u05d9\u05e9\u05d9\", \"\u05e9\u05d1\u05ea\" ],\n\tdayNamesShort: [ \"\u05d0'\", \"\u05d1'\", \"\u05d2'\", \"\u05d3'\", \"\u05d4'\", \"\u05d5'\", \"\u05e9\u05d1\u05ea\" ],\n\tdayNamesMin: [ \"\u05d0'\", \"\u05d1'\", \"\u05d2'\", \"\u05d3'\", \"\u05d4'\", \"\u05d5'\", \"\u05e9\u05d1\u05ea\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: true,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.he );\n\nreturn datepicker.regional.he;\n\n} );\n","jquery/ui-modules/i18n/datepicker-hi.js":"/* Hindi initialisation for the jQuery UI date picker plugin. */\n/* Written by Michael Dawart. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.hi = {\n\tcloseText: \"\u092c\u0902\u0926\",\n\tprevText: \"\u092a\u093f\u091b\u0932\u093e\",\n\tnextText: \"\u0905\u0917\u0932\u093e\",\n\tcurrentText: \"\u0906\u091c\",\n\tmonthNames: [ \"\u091c\u0928\u0935\u0930\u0940 \", \"\u092b\u0930\u0935\u0930\u0940\", \"\u092e\u093e\u0930\u094d\u091a\", \"\u0905\u092a\u094d\u0930\u0947\u0932\", \"\u092e\u0908\", \"\u091c\u0942\u0928\",\n\t\"\u091c\u0942\u0932\u093e\u0908\", \"\u0905\u0917\u0938\u094d\u0924 \", \"\u0938\u093f\u0924\u092e\u094d\u092c\u0930\", \"\u0905\u0915\u094d\u091f\u0942\u092c\u0930\", \"\u0928\u0935\u092e\u094d\u092c\u0930\", \"\u0926\u093f\u0938\u092e\u094d\u092c\u0930\" ],\n\tmonthNamesShort: [ \"\u091c\u0928\", \"\u092b\u0930\", \"\u092e\u093e\u0930\u094d\u091a\", \"\u0905\u092a\u094d\u0930\u0947\u0932\", \"\u092e\u0908\", \"\u091c\u0942\u0928\",\n\t\"\u091c\u0942\u0932\u093e\u0908\", \"\u0905\u0917\", \"\u0938\u093f\u0924\", \"\u0905\u0915\u094d\u091f\", \"\u0928\u0935\", \"\u0926\u093f\" ],\n\tdayNames: [ \"\u0930\u0935\u093f\u0935\u093e\u0930\", \"\u0938\u094b\u092e\u0935\u093e\u0930\", \"\u092e\u0902\u0917\u0932\u0935\u093e\u0930\", \"\u092c\u0941\u0927\u0935\u093e\u0930\", \"\u0917\u0941\u0930\u0941\u0935\u093e\u0930\", \"\u0936\u0941\u0915\u094d\u0930\u0935\u093e\u0930\", \"\u0936\u0928\u093f\u0935\u093e\u0930\" ],\n\tdayNamesShort: [ \"\u0930\u0935\u093f\", \"\u0938\u094b\u092e\", \"\u092e\u0902\u0917\u0932\", \"\u092c\u0941\u0927\", \"\u0917\u0941\u0930\u0941\", \"\u0936\u0941\u0915\u094d\u0930\", \"\u0936\u0928\u093f\" ],\n\tdayNamesMin: [ \"\u0930\u0935\u093f\", \"\u0938\u094b\u092e\", \"\u092e\u0902\u0917\u0932\", \"\u092c\u0941\u0927\", \"\u0917\u0941\u0930\u0941\", \"\u0936\u0941\u0915\u094d\u0930\", \"\u0936\u0928\u093f\" ],\n\tweekHeader: \"\u0939\u092b\u094d\u0924\u093e\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.hi );\n\nreturn datepicker.regional.hi;\n\n} );\n","jquery/ui-modules/i18n/datepicker-hr.js":"/* Croatian i18n for the jQuery UI date picker plugin. */\n/* Written by Vjekoslav Nesek. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.hr = {\n\tcloseText: \"Zatvori\",\n\tprevText: \"&#x3C;\",\n\tnextText: \"&#x3E;\",\n\tcurrentText: \"Danas\",\n\tmonthNames: [ \"Sije\u010danj\", \"Velja\u010da\", \"O\u017eujak\", \"Travanj\", \"Svibanj\", \"Lipanj\",\n\t\"Srpanj\", \"Kolovoz\", \"Rujan\", \"Listopad\", \"Studeni\", \"Prosinac\" ],\n\tmonthNamesShort: [ \"Sij\", \"Velj\", \"O\u017eu\", \"Tra\", \"Svi\", \"Lip\",\n\t\"Srp\", \"Kol\", \"Ruj\", \"Lis\", \"Stu\", \"Pro\" ],\n\tdayNames: [ \"Nedjelja\", \"Ponedjeljak\", \"Utorak\", \"Srijeda\", \"\u010cetvrtak\", \"Petak\", \"Subota\" ],\n\tdayNamesShort: [ \"Ned\", \"Pon\", \"Uto\", \"Sri\", \"\u010cet\", \"Pet\", \"Sub\" ],\n\tdayNamesMin: [ \"Ne\", \"Po\", \"Ut\", \"Sr\", \"\u010ce\", \"Pe\", \"Su\" ],\n\tweekHeader: \"Tje\",\n\tdateFormat: \"dd.mm.yy.\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.hr );\n\nreturn datepicker.regional.hr;\n\n} );\n","jquery/ui-modules/i18n/datepicker-hu.js":"/* Hungarian initialisation for the jQuery UI date picker plugin. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.hu = {\n\tcloseText: \"Bez\u00e1r\",\n\tprevText: \"Vissza\",\n\tnextText: \"El\u0151re\",\n\tcurrentText: \"Ma\",\n\tmonthNames: [ \"Janu\u00e1r\", \"Febru\u00e1r\", \"M\u00e1rcius\", \"\u00c1prilis\", \"M\u00e1jus\", \"J\u00fanius\",\n\t\"J\u00falius\", \"Augusztus\", \"Szeptember\", \"Okt\u00f3ber\", \"November\", \"December\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"M\u00e1r\", \"\u00c1pr\", \"M\u00e1j\", \"J\u00fan\",\n\t\"J\u00fal\", \"Aug\", \"Szep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Vas\u00e1rnap\", \"H\u00e9tf\u0151\", \"Kedd\", \"Szerda\", \"Cs\u00fct\u00f6rt\u00f6k\", \"P\u00e9ntek\", \"Szombat\" ],\n\tdayNamesShort: [ \"Vas\", \"H\u00e9t\", \"Ked\", \"Sze\", \"Cs\u00fc\", \"P\u00e9n\", \"Szo\" ],\n\tdayNamesMin: [ \"V\", \"H\", \"K\", \"Sze\", \"Cs\", \"P\", \"Szo\" ],\n\tweekHeader: \"H\u00e9t\",\n\tdateFormat: \"yy.mm.dd.\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.hu );\n\nreturn datepicker.regional.hu;\n\n} );\n","jquery/ui-modules/i18n/datepicker-hy.js":"/* Armenian(UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Levon Zakaryan (levon.zakaryan@gmail.com)*/\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.hy = {\n\tcloseText: \"\u0553\u0561\u056f\u0565\u056c\",\n\tprevText: \"&#x3C;\u0546\u0561\u056d.\",\n\tnextText: \"\u0540\u0561\u057b.&#x3E;\",\n\tcurrentText: \"\u0531\u0575\u057d\u0585\u0580\",\n\tmonthNames: [ \"\u0540\u0578\u0582\u0576\u057e\u0561\u0580\", \"\u0553\u0565\u057f\u0580\u057e\u0561\u0580\", \"\u0544\u0561\u0580\u057f\", \"\u0531\u057a\u0580\u056b\u056c\", \"\u0544\u0561\u0575\u056b\u057d\", \"\u0540\u0578\u0582\u0576\u056b\u057d\",\n\t\"\u0540\u0578\u0582\u056c\u056b\u057d\", \"\u0555\u0563\u0578\u057d\u057f\u0578\u057d\", \"\u054d\u0565\u057a\u057f\u0565\u0574\u0562\u0565\u0580\", \"\u0540\u0578\u056f\u057f\u0565\u0574\u0562\u0565\u0580\", \"\u0546\u0578\u0575\u0565\u0574\u0562\u0565\u0580\", \"\u0534\u0565\u056f\u057f\u0565\u0574\u0562\u0565\u0580\" ],\n\tmonthNamesShort: [ \"\u0540\u0578\u0582\u0576\u057e\", \"\u0553\u0565\u057f\u0580\", \"\u0544\u0561\u0580\u057f\", \"\u0531\u057a\u0580\", \"\u0544\u0561\u0575\u056b\u057d\", \"\u0540\u0578\u0582\u0576\u056b\u057d\",\n\t\"\u0540\u0578\u0582\u056c\", \"\u0555\u0563\u057d\", \"\u054d\u0565\u057a\", \"\u0540\u0578\u056f\", \"\u0546\u0578\u0575\", \"\u0534\u0565\u056f\" ],\n\tdayNames: [ \"\u056f\u056b\u0580\u0561\u056f\u056b\", \"\u0565\u056f\u0578\u0582\u0577\u0561\u0562\u0569\u056b\", \"\u0565\u0580\u0565\u0584\u0577\u0561\u0562\u0569\u056b\", \"\u0579\u0578\u0580\u0565\u0584\u0577\u0561\u0562\u0569\u056b\", \"\u0570\u056b\u0576\u0563\u0577\u0561\u0562\u0569\u056b\", \"\u0578\u0582\u0580\u0562\u0561\u0569\", \"\u0577\u0561\u0562\u0561\u0569\" ],\n\tdayNamesShort: [ \"\u056f\u056b\u0580\", \"\u0565\u0580\u056f\", \"\u0565\u0580\u0584\", \"\u0579\u0580\u0584\", \"\u0570\u0576\u0563\", \"\u0578\u0582\u0580\u0562\", \"\u0577\u0562\u0569\" ],\n\tdayNamesMin: [ \"\u056f\u056b\u0580\", \"\u0565\u0580\u056f\", \"\u0565\u0580\u0584\", \"\u0579\u0580\u0584\", \"\u0570\u0576\u0563\", \"\u0578\u0582\u0580\u0562\", \"\u0577\u0562\u0569\" ],\n\tweekHeader: \"\u0547\u0532\u054f\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.hy );\n\nreturn datepicker.regional.hy;\n\n} );\n","jquery/ui-modules/i18n/datepicker-id.js":"/* Indonesian initialisation for the jQuery UI date picker plugin. */\n/* Written by Deden Fathurahman (dedenf@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.id = {\n\tcloseText: \"Tutup\",\n\tprevText: \"&#x3C;mundur\",\n\tnextText: \"maju&#x3E;\",\n\tcurrentText: \"hari ini\",\n\tmonthNames: [ \"Januari\", \"Februari\", \"Maret\", \"April\", \"Mei\", \"Juni\",\n\t\"Juli\", \"Agustus\", \"September\", \"Oktober\", \"Nopember\", \"Desember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Mei\", \"Jun\",\n\t\"Jul\", \"Agus\", \"Sep\", \"Okt\", \"Nop\", \"Des\" ],\n\tdayNames: [ \"Minggu\", \"Senin\", \"Selasa\", \"Rabu\", \"Kamis\", \"Jumat\", \"Sabtu\" ],\n\tdayNamesShort: [ \"Min\", \"Sen\", \"Sel\", \"Rab\", \"kam\", \"Jum\", \"Sab\" ],\n\tdayNamesMin: [ \"Mg\", \"Sn\", \"Sl\", \"Rb\", \"Km\", \"jm\", \"Sb\" ],\n\tweekHeader: \"Mg\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.id );\n\nreturn datepicker.regional.id;\n\n} );\n","jquery/ui-modules/i18n/datepicker-is.js":"/* Icelandic initialisation for the jQuery UI date picker plugin. */\n/* Written by Haukur H. Thorsson (haukur@eskill.is). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.is = {\n\tcloseText: \"Loka\",\n\tprevText: \"&#x3C; Fyrri\",\n\tnextText: \"N\u00e6sti &#x3E;\",\n\tcurrentText: \"\u00cd dag\",\n\tmonthNames: [ \"Jan\u00faar\", \"Febr\u00faar\", \"Mars\", \"Apr\u00edl\", \"Ma\u00ed\", \"J\u00fan\u00ed\",\n\t\"J\u00fal\u00ed\", \"\u00c1g\u00fast\", \"September\", \"Okt\u00f3ber\", \"N\u00f3vember\", \"Desember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Ma\u00ed\", \"J\u00fan\",\n\t\"J\u00fal\", \"\u00c1g\u00fa\", \"Sep\", \"Okt\", \"N\u00f3v\", \"Des\" ],\n\tdayNames: [\n\t\t\"Sunnudagur\",\n\t\t\"M\u00e1nudagur\",\n\t\t\"\u00deri\u00f0judagur\",\n\t\t\"Mi\u00f0vikudagur\",\n\t\t\"Fimmtudagur\",\n\t\t\"F\u00f6studagur\",\n\t\t\"Laugardagur\"\n\t],\n\tdayNamesShort: [ \"Sun\", \"M\u00e1n\", \"\u00deri\", \"Mi\u00f0\", \"Fim\", \"F\u00f6s\", \"Lau\" ],\n\tdayNamesMin: [ \"Su\", \"M\u00e1\", \"\u00der\", \"Mi\", \"Fi\", \"F\u00f6\", \"La\" ],\n\tweekHeader: \"Vika\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.is );\n\nreturn datepicker.regional.is;\n\n} );\n","jquery/ui-modules/i18n/datepicker-it-CH.js":"/* Italian initialisation for the jQuery UI date picker plugin. */\n/* Written by Antonello Pasella (antonello.pasella@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"it-CH\" ] = {\n\tcloseText: \"Chiudi\",\n\tprevText: \"&#x3C;Prec\",\n\tnextText: \"Succ&#x3E;\",\n\tcurrentText: \"Oggi\",\n\tmonthNames: [ \"Gennaio\", \"Febbraio\", \"Marzo\", \"Aprile\", \"Maggio\", \"Giugno\",\n\t\t\"Luglio\", \"Agosto\", \"Settembre\", \"Ottobre\", \"Novembre\", \"Dicembre\" ],\n\tmonthNamesShort: [ \"Gen\", \"Feb\", \"Mar\", \"Apr\", \"Mag\", \"Giu\",\n\t\t\"Lug\", \"Ago\", \"Set\", \"Ott\", \"Nov\", \"Dic\" ],\n\tdayNames: [ \"Domenica\", \"Luned\u00ec\", \"Marted\u00ec\", \"Mercoled\u00ec\", \"Gioved\u00ec\", \"Venerd\u00ec\", \"Sabato\" ],\n\tdayNamesShort: [ \"Dom\", \"Lun\", \"Mar\", \"Mer\", \"Gio\", \"Ven\", \"Sab\" ],\n\tdayNamesMin: [ \"Do\", \"Lu\", \"Ma\", \"Me\", \"Gi\", \"Ve\", \"Sa\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"it-CH\" ] );\n\nreturn datepicker.regional[ \"it-CH\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-it.js":"/* Italian initialisation for the jQuery UI date picker plugin. */\n/* Written by Antonello Pasella (antonello.pasella@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.it = {\n\tcloseText: \"Chiudi\",\n\tprevText: \"&#x3C;Prec\",\n\tnextText: \"Succ&#x3E;\",\n\tcurrentText: \"Oggi\",\n\tmonthNames: [ \"Gennaio\", \"Febbraio\", \"Marzo\", \"Aprile\", \"Maggio\", \"Giugno\",\n\t\t\"Luglio\", \"Agosto\", \"Settembre\", \"Ottobre\", \"Novembre\", \"Dicembre\" ],\n\tmonthNamesShort: [ \"Gen\", \"Feb\", \"Mar\", \"Apr\", \"Mag\", \"Giu\",\n\t\t\"Lug\", \"Ago\", \"Set\", \"Ott\", \"Nov\", \"Dic\" ],\n\tdayNames: [ \"Domenica\", \"Luned\u00ec\", \"Marted\u00ec\", \"Mercoled\u00ec\", \"Gioved\u00ec\", \"Venerd\u00ec\", \"Sabato\" ],\n\tdayNamesShort: [ \"Dom\", \"Lun\", \"Mar\", \"Mer\", \"Gio\", \"Ven\", \"Sab\" ],\n\tdayNamesMin: [ \"Do\", \"Lu\", \"Ma\", \"Me\", \"Gi\", \"Ve\", \"Sa\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.it );\n\nreturn datepicker.regional.it;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ja.js":"/* Japanese initialisation for the jQuery UI date picker plugin. */\n/* Written by Kentaro SATO (kentaro@ranvis.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ja = {\n\tcloseText: \"\u9589\u3058\u308b\",\n\tprevText: \"&#x3C;\u524d\",\n\tnextText: \"\u6b21&#x3E;\",\n\tcurrentText: \"\u4eca\u65e5\",\n\tmonthNames: [ \"1\u6708\", \"2\u6708\", \"3\u6708\", \"4\u6708\", \"5\u6708\", \"6\u6708\",\n\t\"7\u6708\", \"8\u6708\", \"9\u6708\", \"10\u6708\", \"11\u6708\", \"12\u6708\" ],\n\tmonthNamesShort: [ \"1\u6708\", \"2\u6708\", \"3\u6708\", \"4\u6708\", \"5\u6708\", \"6\u6708\",\n\t\"7\u6708\", \"8\u6708\", \"9\u6708\", \"10\u6708\", \"11\u6708\", \"12\u6708\" ],\n\tdayNames: [ \"\u65e5\u66dc\u65e5\", \"\u6708\u66dc\u65e5\", \"\u706b\u66dc\u65e5\", \"\u6c34\u66dc\u65e5\", \"\u6728\u66dc\u65e5\", \"\u91d1\u66dc\u65e5\", \"\u571f\u66dc\u65e5\" ],\n\tdayNamesShort: [ \"\u65e5\", \"\u6708\", \"\u706b\", \"\u6c34\", \"\u6728\", \"\u91d1\", \"\u571f\" ],\n\tdayNamesMin: [ \"\u65e5\", \"\u6708\", \"\u706b\", \"\u6c34\", \"\u6728\", \"\u91d1\", \"\u571f\" ],\n\tweekHeader: \"\u9031\",\n\tdateFormat: \"yy/mm/dd\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\u5e74\" };\ndatepicker.setDefaults( datepicker.regional.ja );\n\nreturn datepicker.regional.ja;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ka.js":"/* Georgian (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Lado Lomidze (lado.lomidze@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ka = {\n\tcloseText: \"\u10d3\u10d0\u10ee\u10e3\u10e0\u10d5\u10d0\",\n\tprevText: \"&#x3c; \u10ec\u10d8\u10dc\u10d0\",\n\tnextText: \"\u10e8\u10d4\u10db\u10d3\u10d4\u10d2\u10d8 &#x3e;\",\n\tcurrentText: \"\u10d3\u10e6\u10d4\u10e1\",\n\tmonthNames: [\n\t\t\"\u10d8\u10d0\u10dc\u10d5\u10d0\u10e0\u10d8\",\n\t\t\"\u10d7\u10d4\u10d1\u10d4\u10e0\u10d5\u10d0\u10da\u10d8\",\n\t\t\"\u10db\u10d0\u10e0\u10e2\u10d8\",\n\t\t\"\u10d0\u10de\u10e0\u10d8\u10da\u10d8\",\n\t\t\"\u10db\u10d0\u10d8\u10e1\u10d8\",\n\t\t\"\u10d8\u10d5\u10dc\u10d8\u10e1\u10d8\",\n\t\t\"\u10d8\u10d5\u10da\u10d8\u10e1\u10d8\",\n\t\t\"\u10d0\u10d2\u10d5\u10d8\u10e1\u10e2\u10dd\",\n\t\t\"\u10e1\u10d4\u10e5\u10e2\u10d4\u10db\u10d1\u10d4\u10e0\u10d8\",\n\t\t\"\u10dd\u10e5\u10e2\u10dd\u10db\u10d1\u10d4\u10e0\u10d8\",\n\t\t\"\u10dc\u10dd\u10d4\u10db\u10d1\u10d4\u10e0\u10d8\",\n\t\t\"\u10d3\u10d4\u10d9\u10d4\u10db\u10d1\u10d4\u10e0\u10d8\"\n\t],\n\tmonthNamesShort: [ \"\u10d8\u10d0\u10dc\", \"\u10d7\u10d4\u10d1\", \"\u10db\u10d0\u10e0\", \"\u10d0\u10de\u10e0\", \"\u10db\u10d0\u10d8\", \"\u10d8\u10d5\u10dc\", \"\u10d8\u10d5\u10da\", \"\u10d0\u10d2\u10d5\", \"\u10e1\u10d4\u10e5\", \"\u10dd\u10e5\u10e2\", \"\u10dc\u10dd\u10d4\", \"\u10d3\u10d4\u10d9\" ],\n\tdayNames: [ \"\u10d9\u10d5\u10d8\u10e0\u10d0\", \"\u10dd\u10e0\u10e8\u10d0\u10d1\u10d0\u10d7\u10d8\", \"\u10e1\u10d0\u10db\u10e8\u10d0\u10d1\u10d0\u10d7\u10d8\", \"\u10dd\u10d7\u10ee\u10e8\u10d0\u10d1\u10d0\u10d7\u10d8\", \"\u10ee\u10e3\u10d7\u10e8\u10d0\u10d1\u10d0\u10d7\u10d8\", \"\u10de\u10d0\u10e0\u10d0\u10e1\u10d9\u10d4\u10d5\u10d8\", \"\u10e8\u10d0\u10d1\u10d0\u10d7\u10d8\" ],\n\tdayNamesShort: [ \"\u10d9\u10d5\", \"\u10dd\u10e0\u10e8\", \"\u10e1\u10d0\u10db\", \"\u10dd\u10d7\u10ee\", \"\u10ee\u10e3\u10d7\", \"\u10de\u10d0\u10e0\", \"\u10e8\u10d0\u10d1\" ],\n\tdayNamesMin: [ \"\u10d9\u10d5\", \"\u10dd\u10e0\u10e8\", \"\u10e1\u10d0\u10db\", \"\u10dd\u10d7\u10ee\", \"\u10ee\u10e3\u10d7\", \"\u10de\u10d0\u10e0\", \"\u10e8\u10d0\u10d1\" ],\n\tweekHeader: \"\u10d9\u10d5\u10d8\u10e0\u10d0\",\n\tdateFormat: \"dd-mm-yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ka );\n\nreturn datepicker.regional.ka;\n\n} );\n","jquery/ui-modules/i18n/datepicker-kk.js":"/* Kazakh (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Dmitriy Karasyov (dmitriy.karasyov@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.kk = {\n\tcloseText: \"\u0416\u0430\u0431\u0443\",\n\tprevText: \"&#x3C;\u0410\u043b\u0434\u044b\u04a3\u0493\u044b\",\n\tnextText: \"\u041a\u0435\u043b\u0435\u0441\u0456&#x3E;\",\n\tcurrentText: \"\u0411\u04af\u0433\u0456\u043d\",\n\tmonthNames: [ \"\u049a\u0430\u04a3\u0442\u0430\u0440\", \"\u0410\u049b\u043f\u0430\u043d\", \"\u041d\u0430\u0443\u0440\u044b\u0437\", \"\u0421\u04d9\u0443\u0456\u0440\", \"\u041c\u0430\u043c\u044b\u0440\", \"\u041c\u0430\u0443\u0441\u044b\u043c\",\n\t\"\u0428\u0456\u043b\u0434\u0435\", \"\u0422\u0430\u043c\u044b\u0437\", \"\u049a\u044b\u0440\u043a\u04af\u0439\u0435\u043a\", \"\u049a\u0430\u0437\u0430\u043d\", \"\u049a\u0430\u0440\u0430\u0448\u0430\", \"\u0416\u0435\u043b\u0442\u043e\u049b\u0441\u0430\u043d\" ],\n\tmonthNamesShort: [ \"\u049a\u0430\u04a3\", \"\u0410\u049b\u043f\", \"\u041d\u0430\u0443\", \"\u0421\u04d9\u0443\", \"\u041c\u0430\u043c\", \"\u041c\u0430\u0443\",\n\t\"\u0428\u0456\u043b\", \"\u0422\u0430\u043c\", \"\u049a\u044b\u0440\", \"\u049a\u0430\u0437\", \"\u049a\u0430\u0440\", \"\u0416\u0435\u043b\" ],\n\tdayNames: [ \"\u0416\u0435\u043a\u0441\u0435\u043d\u0431\u0456\", \"\u0414\u04af\u0439\u0441\u0435\u043d\u0431\u0456\", \"\u0421\u0435\u0439\u0441\u0435\u043d\u0431\u0456\", \"\u0421\u04d9\u0440\u0441\u0435\u043d\u0431\u0456\", \"\u0411\u0435\u0439\u0441\u0435\u043d\u0431\u0456\", \"\u0416\u04b1\u043c\u0430\", \"\u0421\u0435\u043d\u0431\u0456\" ],\n\tdayNamesShort: [ \"\u0436\u043a\u0441\", \"\u0434\u0441\u043d\", \"\u0441\u0441\u043d\", \"\u0441\u0440\u0441\", \"\u0431\u0441\u043d\", \"\u0436\u043c\u0430\", \"\u0441\u043d\u0431\" ],\n\tdayNamesMin: [ \"\u0416\u043a\", \"\u0414\u0441\", \"\u0421\u0441\", \"\u0421\u0440\", \"\u0411\u0441\", \"\u0416\u043c\", \"\u0421\u043d\" ],\n\tweekHeader: \"\u041d\u0435\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.kk );\n\nreturn datepicker.regional.kk;\n\n} );\n","jquery/ui-modules/i18n/datepicker-km.js":"/* Khmer initialisation for the jQuery calendar extension. */\n/* Written by Chandara Om (chandara.teacher@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.km = {\n\tcloseText: \"\u1792\u17d2\u179c\u17be\u200b\u179a\u17bd\u1785\",\n\tprevText: \"\u1798\u17bb\u1793\",\n\tnextText: \"\u1794\u1793\u17d2\u1791\u17b6\u1794\u17cb\",\n\tcurrentText: \"\u1790\u17d2\u1784\u17c3\u200b\u1793\u17c1\u17c7\",\n\tmonthNames: [ \"\u1798\u1780\u179a\u17b6\", \"\u1780\u17bb\u1798\u17d2\u1797\u17c8\", \"\u1798\u17b8\u1793\u17b6\", \"\u1798\u17c1\u179f\u17b6\", \"\u17a7\u179f\u1797\u17b6\", \"\u1798\u17b7\u1790\u17bb\u1793\u17b6\",\n\t\"\u1780\u1780\u17d2\u1780\u178a\u17b6\", \"\u179f\u17b8\u17a0\u17b6\", \"\u1780\u1789\u17d2\u1789\u17b6\", \"\u178f\u17bb\u179b\u17b6\", \"\u179c\u17b7\u1785\u17d2\u1786\u17b7\u1780\u17b6\", \"\u1792\u17d2\u1793\u17bc\" ],\n\tmonthNamesShort: [ \"\u1798\u1780\u179a\u17b6\", \"\u1780\u17bb\u1798\u17d2\u1797\u17c8\", \"\u1798\u17b8\u1793\u17b6\", \"\u1798\u17c1\u179f\u17b6\", \"\u17a7\u179f\u1797\u17b6\", \"\u1798\u17b7\u1790\u17bb\u1793\u17b6\",\n\t\"\u1780\u1780\u17d2\u1780\u178a\u17b6\", \"\u179f\u17b8\u17a0\u17b6\", \"\u1780\u1789\u17d2\u1789\u17b6\", \"\u178f\u17bb\u179b\u17b6\", \"\u179c\u17b7\u1785\u17d2\u1786\u17b7\u1780\u17b6\", \"\u1792\u17d2\u1793\u17bc\" ],\n\tdayNames: [ \"\u17a2\u17b6\u1791\u17b7\u178f\u17d2\u1799\", \"\u1785\u1793\u17d2\u1791\", \"\u17a2\u1784\u17d2\u1782\u17b6\u179a\", \"\u1796\u17bb\u1792\", \"\u1796\u17d2\u179a\u17a0\u179f\u17d2\u1794\u178f\u17b7\u17cd\", \"\u179f\u17bb\u1780\u17d2\u179a\", \"\u179f\u17c5\u179a\u17cd\" ],\n\tdayNamesShort: [ \"\u17a2\u17b6\", \"\u1785\", \"\u17a2\", \"\u1796\u17bb\", \"\u1796\u17d2\u179a\u17a0\", \"\u179f\u17bb\", \"\u179f\u17c5\" ],\n\tdayNamesMin: [ \"\u17a2\u17b6\", \"\u1785\", \"\u17a2\", \"\u1796\u17bb\", \"\u1796\u17d2\u179a\u17a0\", \"\u179f\u17bb\", \"\u179f\u17c5\" ],\n\tweekHeader: \"\u179f\u1794\u17d2\u178a\u17b6\u17a0\u17cd\",\n\tdateFormat: \"dd-mm-yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.km );\n\nreturn datepicker.regional.km;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ko.js":"/* Korean initialisation for the jQuery calendar extension. */\n/* Written by DaeKwon Kang (ncrash.dk@gmail.com), Edited by Genie and Myeongjin Lee. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ko = {\n\tcloseText: \"\ub2eb\uae30\",\n\tprevText: \"\uc774\uc804\ub2ec\",\n\tnextText: \"\ub2e4\uc74c\ub2ec\",\n\tcurrentText: \"\uc624\ub298\",\n\tmonthNames: [ \"1\uc6d4\", \"2\uc6d4\", \"3\uc6d4\", \"4\uc6d4\", \"5\uc6d4\", \"6\uc6d4\",\n\t\"7\uc6d4\", \"8\uc6d4\", \"9\uc6d4\", \"10\uc6d4\", \"11\uc6d4\", \"12\uc6d4\" ],\n\tmonthNamesShort: [ \"1\uc6d4\", \"2\uc6d4\", \"3\uc6d4\", \"4\uc6d4\", \"5\uc6d4\", \"6\uc6d4\",\n\t\"7\uc6d4\", \"8\uc6d4\", \"9\uc6d4\", \"10\uc6d4\", \"11\uc6d4\", \"12\uc6d4\" ],\n\tdayNames: [ \"\uc77c\uc694\uc77c\", \"\uc6d4\uc694\uc77c\", \"\ud654\uc694\uc77c\", \"\uc218\uc694\uc77c\", \"\ubaa9\uc694\uc77c\", \"\uae08\uc694\uc77c\", \"\ud1a0\uc694\uc77c\" ],\n\tdayNamesShort: [ \"\uc77c\", \"\uc6d4\", \"\ud654\", \"\uc218\", \"\ubaa9\", \"\uae08\", \"\ud1a0\" ],\n\tdayNamesMin: [ \"\uc77c\", \"\uc6d4\", \"\ud654\", \"\uc218\", \"\ubaa9\", \"\uae08\", \"\ud1a0\" ],\n\tweekHeader: \"\uc8fc\",\n\tdateFormat: \"yy. m. d.\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\ub144\" };\ndatepicker.setDefaults( datepicker.regional.ko );\n\nreturn datepicker.regional.ko;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ky.js":"/* Kyrgyz (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Sergey Kartashov (ebishkek@yandex.ru). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ky = {\n\tcloseText: \"\u0416\u0430\u0431\u0443\u0443\",\n\tprevText: \"&#x3c;\u041c\u0443\u0440\",\n\tnextText: \"\u041a\u0438\u0439&#x3e;\",\n\tcurrentText: \"\u0411\u04af\u0433\u04af\u043d\",\n\tmonthNames: [ \"\u042f\u043d\u0432\u0430\u0440\u044c\", \"\u0424\u0435\u0432\u0440\u0430\u043b\u044c\", \"\u041c\u0430\u0440\u0442\", \"\u0410\u043f\u0440\u0435\u043b\u044c\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\u044c\",\n\t\"\u0418\u044e\u043b\u044c\", \"\u0410\u0432\u0433\u0443\u0441\u0442\", \"\u0421\u0435\u043d\u0442\u044f\u0431\u0440\u044c\", \"\u041e\u043a\u0442\u044f\u0431\u0440\u044c\", \"\u041d\u043e\u044f\u0431\u0440\u044c\", \"\u0414\u0435\u043a\u0430\u0431\u0440\u044c\" ],\n\tmonthNamesShort: [ \"\u042f\u043d\u0432\", \"\u0424\u0435\u0432\", \"\u041c\u0430\u0440\", \"\u0410\u043f\u0440\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\",\n\t\"\u0418\u044e\u043b\", \"\u0410\u0432\u0433\", \"\u0421\u0435\u043d\", \"\u041e\u043a\u0442\", \"\u041d\u043e\u044f\", \"\u0414\u0435\u043a\" ],\n\tdayNames: [ \"\u0436\u0435\u043a\u0448\u0435\u043c\u0431\u0438\", \"\u0434\u04af\u0439\u0448\u04e9\u043c\u0431\u04af\", \"\u0448\u0435\u0439\u0448\u0435\u043c\u0431\u0438\", \"\u0448\u0430\u0440\u0448\u0435\u043c\u0431\u0438\", \"\u0431\u0435\u0439\u0448\u0435\u043c\u0431\u0438\", \"\u0436\u0443\u043c\u0430\", \"\u0438\u0448\u0435\u043c\u0431\u0438\" ],\n\tdayNamesShort: [ \"\u0436\u0435\u043a\", \"\u0434\u04af\u0439\", \"\u0448\u0435\u0439\", \"\u0448\u0430\u0440\", \"\u0431\u0435\u0439\", \"\u0436\u0443\u043c\", \"\u0438\u0448\u0435\" ],\n\tdayNamesMin: [ \"\u0416\u043a\", \"\u0414\u0448\", \"\u0428\u0448\", \"\u0428\u0440\", \"\u0411\u0448\", \"\u0416\u043c\", \"\u0418\u0448\" ],\n\tweekHeader: \"\u0416\u0443\u043c\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\"\n};\ndatepicker.setDefaults( datepicker.regional.ky );\n\nreturn datepicker.regional.ky;\n\n} );\n","jquery/ui-modules/i18n/datepicker-lb.js":"/* Luxembourgish initialisation for the jQuery UI date picker plugin. */\n/* Written by Michel Weimerskirch <michel@weimerskirch.net> */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.lb = {\n\tcloseText: \"F\u00e4erdeg\",\n\tprevText: \"Zr\u00e9ck\",\n\tnextText: \"Weider\",\n\tcurrentText: \"Haut\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"M\u00e4erz\", \"Abr\u00ebll\", \"Mee\", \"Juni\",\n\t\"Juli\", \"August\", \"September\", \"Oktober\", \"November\", \"Dezember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"M\u00e4e\", \"Abr\", \"Mee\", \"Jun\",\n\t\"Jul\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dez\" ],\n\tdayNames: [\n\t\t\"Sonndeg\",\n\t\t\"M\u00e9indeg\",\n\t\t\"D\u00ebnschdeg\",\n\t\t\"M\u00ebttwoch\",\n\t\t\"Donneschdeg\",\n\t\t\"Freideg\",\n\t\t\"Samschdeg\"\n\t],\n\tdayNamesShort: [ \"Son\", \"M\u00e9i\", \"D\u00ebn\", \"M\u00ebt\", \"Don\", \"Fre\", \"Sam\" ],\n\tdayNamesMin: [ \"So\", \"M\u00e9\", \"D\u00eb\", \"M\u00eb\", \"Do\", \"Fr\", \"Sa\" ],\n\tweekHeader: \"W\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.lb );\n\nreturn datepicker.regional.lb;\n\n} );\n","jquery/ui-modules/i18n/datepicker-lt.js":"/* Lithuanian (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* @author Arturas Paleicikas <arturas@avalon.lt> */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.lt = {\n\tcloseText: \"U\u017edaryti\",\n\tprevText: \"&#x3C;Atgal\",\n\tnextText: \"Pirmyn&#x3E;\",\n\tcurrentText: \"\u0160iandien\",\n\tmonthNames: [ \"Sausis\", \"Vasaris\", \"Kovas\", \"Balandis\", \"Gegu\u017e\u0117\", \"Bir\u017eelis\",\n\t\"Liepa\", \"Rugpj\u016btis\", \"Rugs\u0117jis\", \"Spalis\", \"Lapkritis\", \"Gruodis\" ],\n\tmonthNamesShort: [ \"Sau\", \"Vas\", \"Kov\", \"Bal\", \"Geg\", \"Bir\",\n\t\"Lie\", \"Rugp\", \"Rugs\", \"Spa\", \"Lap\", \"Gru\" ],\n\tdayNames: [\n\t\t\"sekmadienis\",\n\t\t\"pirmadienis\",\n\t\t\"antradienis\",\n\t\t\"tre\u010diadienis\",\n\t\t\"ketvirtadienis\",\n\t\t\"penktadienis\",\n\t\t\"\u0161e\u0161tadienis\"\n\t],\n\tdayNamesShort: [ \"sek\", \"pir\", \"ant\", \"tre\", \"ket\", \"pen\", \"\u0161e\u0161\" ],\n\tdayNamesMin: [ \"Se\", \"Pr\", \"An\", \"Tr\", \"Ke\", \"Pe\", \"\u0160e\" ],\n\tweekHeader: \"SAV\",\n\tdateFormat: \"yy-mm-dd\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.lt );\n\nreturn datepicker.regional.lt;\n\n} );\n","jquery/ui-modules/i18n/datepicker-lv.js":"/* Latvian (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* @author Arturas Paleicikas <arturas.paleicikas@metasite.net> */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.lv = {\n\tcloseText: \"Aizv\u0113rt\",\n\tprevText: \"Iepr.\",\n\tnextText: \"N\u0101k.\",\n\tcurrentText: \"\u0160odien\",\n\tmonthNames: [ \"Janv\u0101ris\", \"Febru\u0101ris\", \"Marts\", \"Apr\u012blis\", \"Maijs\", \"J\u016bnijs\",\n\t\"J\u016blijs\", \"Augusts\", \"Septembris\", \"Oktobris\", \"Novembris\", \"Decembris\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Mai\", \"J\u016bn\",\n\t\"J\u016bl\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [\n\t\t\"sv\u0113tdiena\",\n\t\t\"pirmdiena\",\n\t\t\"otrdiena\",\n\t\t\"tre\u0161diena\",\n\t\t\"ceturtdiena\",\n\t\t\"piektdiena\",\n\t\t\"sestdiena\"\n\t],\n\tdayNamesShort: [ \"svt\", \"prm\", \"otr\", \"tre\", \"ctr\", \"pkt\", \"sst\" ],\n\tdayNamesMin: [ \"Sv\", \"Pr\", \"Ot\", \"Tr\", \"Ct\", \"Pk\", \"Ss\" ],\n\tweekHeader: \"Ned.\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.lv );\n\nreturn datepicker.regional.lv;\n\n} );\n","jquery/ui-modules/i18n/datepicker-mk.js":"/* Macedonian i18n for the jQuery UI date picker plugin. */\n/* Written by Stojce Slavkovski. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.mk = {\n\tcloseText: \"\u0417\u0430\u0442\u0432\u043e\u0440\u0438\",\n\tprevText: \"&#x3C;\",\n\tnextText: \"&#x3E;\",\n\tcurrentText: \"\u0414\u0435\u043d\u0435\u0441\",\n\tmonthNames: [ \"\u0408\u0430\u043d\u0443\u0430\u0440\u0438\", \"\u0424\u0435\u0432\u0440\u0443\u0430\u0440\u0438\", \"\u041c\u0430\u0440\u0442\", \"\u0410\u043f\u0440\u0438\u043b\", \"\u041c\u0430\u0458\", \"\u0408\u0443\u043d\u0438\",\n\t\"\u0408\u0443\u043b\u0438\", \"\u0410\u0432\u0433\u0443\u0441\u0442\", \"\u0421\u0435\u043f\u0442\u0435\u043c\u0432\u0440\u0438\", \"\u041e\u043a\u0442\u043e\u043c\u0432\u0440\u0438\", \"\u041d\u043e\u0435\u043c\u0432\u0440\u0438\", \"\u0414\u0435\u043a\u0435\u043c\u0432\u0440\u0438\" ],\n\tmonthNamesShort: [ \"\u0408\u0430\u043d\", \"\u0424\u0435\u0432\", \"\u041c\u0430\u0440\", \"\u0410\u043f\u0440\", \"\u041c\u0430\u0458\", \"\u0408\u0443\u043d\",\n\t\"\u0408\u0443\u043b\", \"\u0410\u0432\u0433\", \"\u0421\u0435\u043f\", \"\u041e\u043a\u0442\", \"\u041d\u043e\u0435\", \"\u0414\u0435\u043a\" ],\n\tdayNames: [ \"\u041d\u0435\u0434\u0435\u043b\u0430\", \"\u041f\u043e\u043d\u0435\u0434\u0435\u043b\u043d\u0438\u043a\", \"\u0412\u0442\u043e\u0440\u043d\u0438\u043a\", \"\u0421\u0440\u0435\u0434\u0430\", \"\u0427\u0435\u0442\u0432\u0440\u0442\u043e\u043a\", \"\u041f\u0435\u0442\u043e\u043a\", \"\u0421\u0430\u0431\u043e\u0442\u0430\" ],\n\tdayNamesShort: [ \"\u041d\u0435\u0434\", \"\u041f\u043e\u043d\", \"\u0412\u0442\u043e\", \"\u0421\u0440\u0435\", \"\u0427\u0435\u0442\", \"\u041f\u0435\u0442\", \"\u0421\u0430\u0431\" ],\n\tdayNamesMin: [ \"\u041d\u0435\", \"\u041f\u043e\", \"\u0412\u0442\", \"\u0421\u0440\", \"\u0427\u0435\", \"\u041f\u0435\", \"\u0421\u0430\" ],\n\tweekHeader: \"\u0421\u0435\u0434\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.mk );\n\nreturn datepicker.regional.mk;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ml.js":"/* Malayalam (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Saji Nediyanchath (saji89@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ml = {\n\tcloseText: \"\u0d36\u0d30\u0d3f\",\n\tprevText: \"\u0d2e\u0d41\u0d28\u0d4d\u0d28\u0d24\u0d4d\u0d24\u0d46\",\n\tnextText: \"\u0d05\u0d1f\u0d41\u0d24\u0d4d\u0d24\u0d24\u0d4d \",\n\tcurrentText: \"\u0d07\u0d28\u0d4d\u0d28\u0d4d\",\n\tmonthNames: [ \"\u0d1c\u0d28\u0d41\u0d35\u0d30\u0d3f\", \"\u0d2b\u0d46\u0d2c\u0d4d\u0d30\u0d41\u0d35\u0d30\u0d3f\", \"\u0d2e\u0d3e\u0d30\u0d4d\u200d\u0d1a\u0d4d\u0d1a\u0d4d\", \"\u0d0f\u0d2a\u0d4d\u0d30\u0d3f\u0d32\u0d4d\u200d\", \"\u0d2e\u0d47\u0d2f\u0d4d\", \"\u0d1c\u0d42\u0d23\u0d4d\u200d\",\n\t\"\u0d1c\u0d42\u0d32\u0d48\", \"\u0d06\u0d17\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d4d\", \"\u0d38\u0d46\u0d2a\u0d4d\u0d31\u0d4d\u0d31\u0d02\u0d2c\u0d30\u0d4d\u200d\", \"\u0d12\u0d15\u0d4d\u0d1f\u0d4b\u0d2c\u0d30\u0d4d\u200d\", \"\u0d28\u0d35\u0d02\u0d2c\u0d30\u0d4d\u200d\", \"\u0d21\u0d3f\u0d38\u0d02\u0d2c\u0d30\u0d4d\u200d\" ],\n\tmonthNamesShort: [ \"\u0d1c\u0d28\u0d41\", \"\u0d2b\u0d46\u0d2c\u0d4d\", \"\u0d2e\u0d3e\u0d30\u0d4d\u200d\", \"\u0d0f\u0d2a\u0d4d\u0d30\u0d3f\", \"\u0d2e\u0d47\u0d2f\u0d4d\", \"\u0d1c\u0d42\u0d23\u0d4d\u200d\",\n\t\"\u0d1c\u0d42\u0d32\u0d3e\", \"\u0d06\u0d17\", \"\u0d38\u0d46\u0d2a\u0d4d\", \"\u0d12\u0d15\u0d4d\u0d1f\u0d4b\", \"\u0d28\u0d35\u0d02\", \"\u0d21\u0d3f\u0d38\" ],\n\tdayNames: [ \"\u0d1e\u0d3e\u0d2f\u0d30\u0d4d\u200d\", \"\u0d24\u0d3f\u0d19\u0d4d\u0d15\u0d33\u0d4d\u200d\", \"\u0d1a\u0d4a\u0d35\u0d4d\u0d35\", \"\u0d2c\u0d41\u0d27\u0d28\u0d4d\u200d\", \"\u0d35\u0d4d\u0d2f\u0d3e\u0d34\u0d02\", \"\u0d35\u0d46\u0d33\u0d4d\u0d33\u0d3f\", \"\u0d36\u0d28\u0d3f\" ],\n\tdayNamesShort: [ \"\u0d1e\u0d3e\u0d2f\", \"\u0d24\u0d3f\u0d19\u0d4d\u0d15\", \"\u0d1a\u0d4a\u0d35\u0d4d\u0d35\", \"\u0d2c\u0d41\u0d27\", \"\u0d35\u0d4d\u0d2f\u0d3e\u0d34\u0d02\", \"\u0d35\u0d46\u0d33\u0d4d\u0d33\u0d3f\", \"\u0d36\u0d28\u0d3f\" ],\n\tdayNamesMin: [ \"\u0d1e\u0d3e\", \"\u0d24\u0d3f\", \"\u0d1a\u0d4a\", \"\u0d2c\u0d41\", \"\u0d35\u0d4d\u0d2f\u0d3e\", \"\u0d35\u0d46\", \"\u0d36\" ],\n\tweekHeader: \"\u0d06\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ml );\n\nreturn datepicker.regional.ml;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ms.js":"/* Malaysian initialisation for the jQuery UI date picker plugin. */\n/* Written by Mohd Nawawi Mohamad Jamili (nawawi@ronggeng.net). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ms = {\n\tcloseText: \"Tutup\",\n\tprevText: \"&#x3C;Sebelum\",\n\tnextText: \"Selepas&#x3E;\",\n\tcurrentText: \"hari ini\",\n\tmonthNames: [ \"Januari\", \"Februari\", \"Mac\", \"April\", \"Mei\", \"Jun\",\n\t\"Julai\", \"Ogos\", \"September\", \"Oktober\", \"November\", \"Disember\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mac\", \"Apr\", \"Mei\", \"Jun\",\n\t\"Jul\", \"Ogo\", \"Sep\", \"Okt\", \"Nov\", \"Dis\" ],\n\tdayNames: [ \"Ahad\", \"Isnin\", \"Selasa\", \"Rabu\", \"Khamis\", \"Jumaat\", \"Sabtu\" ],\n\tdayNamesShort: [ \"Aha\", \"Isn\", \"Sel\", \"Rab\", \"kha\", \"Jum\", \"Sab\" ],\n\tdayNamesMin: [ \"Ah\", \"Is\", \"Se\", \"Ra\", \"Kh\", \"Ju\", \"Sa\" ],\n\tweekHeader: \"Mg\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ms );\n\nreturn datepicker.regional.ms;\n\n} );\n","jquery/ui-modules/i18n/datepicker-nb.js":"/* Norwegian Bokm\u00e5l initialisation for the jQuery UI date picker plugin. */\n/* Written by Bj\u00f8rn Johansen (post@bjornjohansen.no). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.nb = {\n\tcloseText: \"Lukk\",\n\tprevText: \"&#xAB;Forrige\",\n\tnextText: \"Neste&#xBB;\",\n\tcurrentText: \"I dag\",\n\tmonthNames: [\n\t\t\"januar\",\n\t\t\"februar\",\n\t\t\"mars\",\n\t\t\"april\",\n\t\t\"mai\",\n\t\t\"juni\",\n\t\t\"juli\",\n\t\t\"august\",\n\t\t\"september\",\n\t\t\"oktober\",\n\t\t\"november\",\n\t\t\"desember\"\n\t],\n\tmonthNamesShort: [ \"jan\", \"feb\", \"mar\", \"apr\", \"mai\", \"jun\", \"jul\", \"aug\", \"sep\", \"okt\", \"nov\", \"des\" ],\n\tdayNamesShort: [ \"s\u00f8n\", \"man\", \"tir\", \"ons\", \"tor\", \"fre\", \"l\u00f8r\" ],\n\tdayNames: [ \"s\u00f8ndag\", \"mandag\", \"tirsdag\", \"onsdag\", \"torsdag\", \"fredag\", \"l\u00f8rdag\" ],\n\tdayNamesMin: [ \"s\u00f8\", \"ma\", \"ti\", \"on\", \"to\", \"fr\", \"l\u00f8\" ],\n\tweekHeader: \"Uke\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\"\n};\ndatepicker.setDefaults( datepicker.regional.nb );\n\nreturn datepicker.regional.nb;\n\n} );\n","jquery/ui-modules/i18n/datepicker-nl-BE.js":"/* Dutch (Belgium) initialisation for the jQuery UI date picker plugin. */\n/* David De Sloovere @DavidDeSloovere */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"nl-BE\" ] = {\n\tcloseText: \"Sluiten\",\n\tprevText: \"\u2190\",\n\tnextText: \"\u2192\",\n\tcurrentText: \"Vandaag\",\n\tmonthNames: [ \"januari\", \"februari\", \"maart\", \"april\", \"mei\", \"juni\",\n\t\"juli\", \"augustus\", \"september\", \"oktober\", \"november\", \"december\" ],\n\tmonthNamesShort: [ \"jan\", \"feb\", \"mrt\", \"apr\", \"mei\", \"jun\",\n\t\"jul\", \"aug\", \"sep\", \"okt\", \"nov\", \"dec\" ],\n\tdayNames: [ \"zondag\", \"maandag\", \"dinsdag\", \"woensdag\", \"donderdag\", \"vrijdag\", \"zaterdag\" ],\n\tdayNamesShort: [ \"zon\", \"maa\", \"din\", \"woe\", \"don\", \"vri\", \"zat\" ],\n\tdayNamesMin: [ \"zo\", \"ma\", \"di\", \"wo\", \"do\", \"vr\", \"za\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"nl-BE\" ] );\n\nreturn datepicker.regional[ \"nl-BE\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-nl.js":"/* Dutch (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Mathias Bynens <http://mathiasbynens.be/> */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.nl = {\n\tcloseText: \"Sluiten\",\n\tprevText: \"\u2190\",\n\tnextText: \"\u2192\",\n\tcurrentText: \"Vandaag\",\n\tmonthNames: [ \"januari\", \"februari\", \"maart\", \"april\", \"mei\", \"juni\",\n\t\"juli\", \"augustus\", \"september\", \"oktober\", \"november\", \"december\" ],\n\tmonthNamesShort: [ \"jan\", \"feb\", \"mrt\", \"apr\", \"mei\", \"jun\",\n\t\"jul\", \"aug\", \"sep\", \"okt\", \"nov\", \"dec\" ],\n\tdayNames: [ \"zondag\", \"maandag\", \"dinsdag\", \"woensdag\", \"donderdag\", \"vrijdag\", \"zaterdag\" ],\n\tdayNamesShort: [ \"zon\", \"maa\", \"din\", \"woe\", \"don\", \"vri\", \"zat\" ],\n\tdayNamesMin: [ \"zo\", \"ma\", \"di\", \"wo\", \"do\", \"vr\", \"za\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd-mm-yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.nl );\n\nreturn datepicker.regional.nl;\n\n} );\n","jquery/ui-modules/i18n/datepicker-nn.js":"/* Norwegian Nynorsk initialisation for the jQuery UI date picker plugin. */\n/* Written by Bj\u00f8rn Johansen (post@bjornjohansen.no). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.nn = {\n\tcloseText: \"Lukk\",\n\tprevText: \"&#xAB;F\u00f8rre\",\n\tnextText: \"Neste&#xBB;\",\n\tcurrentText: \"I dag\",\n\tmonthNames: [\n\t\t\"januar\",\n\t\t\"februar\",\n\t\t\"mars\",\n\t\t\"april\",\n\t\t\"mai\",\n\t\t\"juni\",\n\t\t\"juli\",\n\t\t\"august\",\n\t\t\"september\",\n\t\t\"oktober\",\n\t\t\"november\",\n\t\t\"desember\"\n\t],\n\tmonthNamesShort: [ \"jan\", \"feb\", \"mar\", \"apr\", \"mai\", \"jun\", \"jul\", \"aug\", \"sep\", \"okt\", \"nov\", \"des\" ],\n\tdayNamesShort: [ \"sun\", \"m\u00e5n\", \"tys\", \"ons\", \"tor\", \"fre\", \"lau\" ],\n\tdayNames: [ \"sundag\", \"m\u00e5ndag\", \"tysdag\", \"onsdag\", \"torsdag\", \"fredag\", \"laurdag\" ],\n\tdayNamesMin: [ \"su\", \"m\u00e5\", \"ty\", \"on\", \"to\", \"fr\", \"la\" ],\n\tweekHeader: \"Veke\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\"\n};\ndatepicker.setDefaults( datepicker.regional.nn );\n\nreturn datepicker.regional.nn;\n\n} );\n","jquery/ui-modules/i18n/datepicker-no.js":"/* Norwegian initialisation for the jQuery UI date picker plugin. */\n/* Written by Naimdjon Takhirov (naimdjon@gmail.com). */\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.no = {\n\tcloseText: \"Lukk\",\n\tprevText: \"&#xAB;Forrige\",\n\tnextText: \"Neste&#xBB;\",\n\tcurrentText: \"I dag\",\n\tmonthNames: [\n\t\t\"januar\",\n\t\t\"februar\",\n\t\t\"mars\",\n\t\t\"april\",\n\t\t\"mai\",\n\t\t\"juni\",\n\t\t\"juli\",\n\t\t\"august\",\n\t\t\"september\",\n\t\t\"oktober\",\n\t\t\"november\",\n\t\t\"desember\"\n\t],\n\tmonthNamesShort: [ \"jan\", \"feb\", \"mar\", \"apr\", \"mai\", \"jun\", \"jul\", \"aug\", \"sep\", \"okt\", \"nov\", \"des\" ],\n\tdayNamesShort: [ \"s\u00f8n\", \"man\", \"tir\", \"ons\", \"tor\", \"fre\", \"l\u00f8r\" ],\n\tdayNames: [ \"s\u00f8ndag\", \"mandag\", \"tirsdag\", \"onsdag\", \"torsdag\", \"fredag\", \"l\u00f8rdag\" ],\n\tdayNamesMin: [ \"s\u00f8\", \"ma\", \"ti\", \"on\", \"to\", \"fr\", \"l\u00f8\" ],\n\tweekHeader: \"Uke\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\"\n};\ndatepicker.setDefaults( datepicker.regional.no );\n\nreturn datepicker.regional.no;\n\n} );\n","jquery/ui-modules/i18n/datepicker-pl.js":"/* Polish initialisation for the jQuery UI date picker plugin. */\n/* Written by Jacek Wysocki (jacek.wysocki@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.pl = {\n\tcloseText: \"Zamknij\",\n\tprevText: \"&#x3C;Poprzedni\",\n\tnextText: \"Nast\u0119pny&#x3E;\",\n\tcurrentText: \"Dzi\u015b\",\n\tmonthNames: [ \"Stycze\u0144\", \"Luty\", \"Marzec\", \"Kwiecie\u0144\", \"Maj\", \"Czerwiec\",\n\t\"Lipiec\", \"Sierpie\u0144\", \"Wrzesie\u0144\", \"Pa\u017adziernik\", \"Listopad\", \"Grudzie\u0144\" ],\n\tmonthNamesShort: [ \"Sty\", \"Lu\", \"Mar\", \"Kw\", \"Maj\", \"Cze\",\n\t\"Lip\", \"Sie\", \"Wrz\", \"Pa\", \"Lis\", \"Gru\" ],\n\tdayNames: [ \"Niedziela\", \"Poniedzia\u0142ek\", \"Wtorek\", \"\u015aroda\", \"Czwartek\", \"Pi\u0105tek\", \"Sobota\" ],\n\tdayNamesShort: [ \"Nie\", \"Pn\", \"Wt\", \"\u015ar\", \"Czw\", \"Pt\", \"So\" ],\n\tdayNamesMin: [ \"N\", \"Pn\", \"Wt\", \"\u015ar\", \"Cz\", \"Pt\", \"So\" ],\n\tweekHeader: \"Tydz\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.pl );\n\nreturn datepicker.regional.pl;\n\n} );\n","jquery/ui-modules/i18n/datepicker-pt-BR.js":"/* Brazilian initialisation for the jQuery UI date picker plugin. */\n/* Written by Leonildo Costa Silva (leocsilva@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"pt-BR\" ] = {\n\tcloseText: \"Fechar\",\n\tprevText: \"&#x3C;Anterior\",\n\tnextText: \"Pr\u00f3ximo&#x3E;\",\n\tcurrentText: \"Hoje\",\n\tmonthNames: [ \"Janeiro\", \"Fevereiro\", \"Mar\u00e7o\", \"Abril\", \"Maio\", \"Junho\",\n\t\"Julho\", \"Agosto\", \"Setembro\", \"Outubro\", \"Novembro\", \"Dezembro\" ],\n\tmonthNamesShort: [ \"Jan\", \"Fev\", \"Mar\", \"Abr\", \"Mai\", \"Jun\",\n\t\"Jul\", \"Ago\", \"Set\", \"Out\", \"Nov\", \"Dez\" ],\n\tdayNames: [\n\t\t\"Domingo\",\n\t\t\"Segunda-feira\",\n\t\t\"Ter\u00e7a-feira\",\n\t\t\"Quarta-feira\",\n\t\t\"Quinta-feira\",\n\t\t\"Sexta-feira\",\n\t\t\"S\u00e1bado\"\n\t],\n\tdayNamesShort: [ \"Dom\", \"Seg\", \"Ter\", \"Qua\", \"Qui\", \"Sex\", \"S\u00e1b\" ],\n\tdayNamesMin: [ \"Dom\", \"Seg\", \"Ter\", \"Qua\", \"Qui\", \"Sex\", \"S\u00e1b\" ],\n\tweekHeader: \"Sm\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"pt-BR\" ] );\n\nreturn datepicker.regional[ \"pt-BR\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-pt.js":"/* Portuguese initialisation for the jQuery UI date picker plugin. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.pt = {\n\tcloseText: \"Fechar\",\n\tprevText: \"Anterior\",\n\tnextText: \"Seguinte\",\n\tcurrentText: \"Hoje\",\n\tmonthNames: [ \"Janeiro\", \"Fevereiro\", \"Mar\u00e7o\", \"Abril\", \"Maio\", \"Junho\",\n\t\"Julho\", \"Agosto\", \"Setembro\", \"Outubro\", \"Novembro\", \"Dezembro\" ],\n\tmonthNamesShort: [ \"Jan\", \"Fev\", \"Mar\", \"Abr\", \"Mai\", \"Jun\",\n\t\"Jul\", \"Ago\", \"Set\", \"Out\", \"Nov\", \"Dez\" ],\n\tdayNames: [\n\t\t\"Domingo\",\n\t\t\"Segunda-feira\",\n\t\t\"Ter\u00e7a-feira\",\n\t\t\"Quarta-feira\",\n\t\t\"Quinta-feira\",\n\t\t\"Sexta-feira\",\n\t\t\"S\u00e1bado\"\n\t],\n\tdayNamesShort: [ \"Dom\", \"Seg\", \"Ter\", \"Qua\", \"Qui\", \"Sex\", \"S\u00e1b\" ],\n\tdayNamesMin: [ \"Dom\", \"Seg\", \"Ter\", \"Qua\", \"Qui\", \"Sex\", \"S\u00e1b\" ],\n\tweekHeader: \"Sem\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.pt );\n\nreturn datepicker.regional.pt;\n\n} );\n","jquery/ui-modules/i18n/datepicker-rm.js":"/* Romansh initialisation for the jQuery UI date picker plugin. */\n/* Written by Yvonne Gienal (yvonne.gienal@educa.ch). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.rm = {\n\tcloseText: \"Serrar\",\n\tprevText: \"&#x3C;Suandant\",\n\tnextText: \"Precedent&#x3E;\",\n\tcurrentText: \"Actual\",\n\tmonthNames: [\n\t\t\"Schaner\",\n\t\t\"Favrer\",\n\t\t\"Mars\",\n\t\t\"Avrigl\",\n\t\t\"Matg\",\n\t\t\"Zercladur\",\n\t\t\"Fanadur\",\n\t\t\"Avust\",\n\t\t\"Settember\",\n\t\t\"October\",\n\t\t\"November\",\n\t\t\"December\"\n\t],\n\tmonthNamesShort: [\n\t\t\"Scha\",\n\t\t\"Fev\",\n\t\t\"Mar\",\n\t\t\"Avr\",\n\t\t\"Matg\",\n\t\t\"Zer\",\n\t\t\"Fan\",\n\t\t\"Avu\",\n\t\t\"Sett\",\n\t\t\"Oct\",\n\t\t\"Nov\",\n\t\t\"Dec\"\n\t],\n\tdayNames: [ \"Dumengia\", \"Glindesdi\", \"Mardi\", \"Mesemna\", \"Gievgia\", \"Venderdi\", \"Sonda\" ],\n\tdayNamesShort: [ \"Dum\", \"Gli\", \"Mar\", \"Mes\", \"Gie\", \"Ven\", \"Som\" ],\n\tdayNamesMin: [ \"Du\", \"Gl\", \"Ma\", \"Me\", \"Gi\", \"Ve\", \"So\" ],\n\tweekHeader: \"emna\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.rm );\n\nreturn datepicker.regional.rm;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ro.js":"/* Romanian initialisation for the jQuery UI date picker plugin.\n *\n * Written by Edmond L. (ll_edmond@walla.com)\n * and Ionut G. Stan (ionut.g.stan@gmail.com)\n */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ro = {\n\tcloseText: \"\u00cenchide\",\n\tprevText: \"&#xAB; Luna precedent\u0103\",\n\tnextText: \"Luna urm\u0103toare &#xBB;\",\n\tcurrentText: \"Azi\",\n\tmonthNames: [ \"Ianuarie\", \"Februarie\", \"Martie\", \"Aprilie\", \"Mai\", \"Iunie\",\n\t\"Iulie\", \"August\", \"Septembrie\", \"Octombrie\", \"Noiembrie\", \"Decembrie\" ],\n\tmonthNamesShort: [ \"Ian\", \"Feb\", \"Mar\", \"Apr\", \"Mai\", \"Iun\",\n\t\"Iul\", \"Aug\", \"Sep\", \"Oct\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Duminic\u0103\", \"Luni\", \"Mar\u0163i\", \"Miercuri\", \"Joi\", \"Vineri\", \"S\u00e2mb\u0103t\u0103\" ],\n\tdayNamesShort: [ \"Dum\", \"Lun\", \"Mar\", \"Mie\", \"Joi\", \"Vin\", \"S\u00e2m\" ],\n\tdayNamesMin: [ \"Du\", \"Lu\", \"Ma\", \"Mi\", \"Jo\", \"Vi\", \"S\u00e2\" ],\n\tweekHeader: \"S\u0103pt\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ro );\n\nreturn datepicker.regional.ro;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ru.js":"/* Russian (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Andrew Stromnov (stromnov@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ru = {\n\tcloseText: \"\u0417\u0430\u043a\u0440\u044b\u0442\u044c\",\n\tprevText: \"&#x3C;\u041f\u0440\u0435\u0434\",\n\tnextText: \"\u0421\u043b\u0435\u0434&#x3E;\",\n\tcurrentText: \"\u0421\u0435\u0433\u043e\u0434\u043d\u044f\",\n\tmonthNames: [ \"\u042f\u043d\u0432\u0430\u0440\u044c\", \"\u0424\u0435\u0432\u0440\u0430\u043b\u044c\", \"\u041c\u0430\u0440\u0442\", \"\u0410\u043f\u0440\u0435\u043b\u044c\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\u044c\",\n\t\"\u0418\u044e\u043b\u044c\", \"\u0410\u0432\u0433\u0443\u0441\u0442\", \"\u0421\u0435\u043d\u0442\u044f\u0431\u0440\u044c\", \"\u041e\u043a\u0442\u044f\u0431\u0440\u044c\", \"\u041d\u043e\u044f\u0431\u0440\u044c\", \"\u0414\u0435\u043a\u0430\u0431\u0440\u044c\" ],\n\tmonthNamesShort: [ \"\u042f\u043d\u0432\", \"\u0424\u0435\u0432\", \"\u041c\u0430\u0440\", \"\u0410\u043f\u0440\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\",\n\t\"\u0418\u044e\u043b\", \"\u0410\u0432\u0433\", \"\u0421\u0435\u043d\", \"\u041e\u043a\u0442\", \"\u041d\u043e\u044f\", \"\u0414\u0435\u043a\" ],\n\tdayNames: [ \"\u0432\u043e\u0441\u043a\u0440\u0435\u0441\u0435\u043d\u044c\u0435\", \"\u043f\u043e\u043d\u0435\u0434\u0435\u043b\u044c\u043d\u0438\u043a\", \"\u0432\u0442\u043e\u0440\u043d\u0438\u043a\", \"\u0441\u0440\u0435\u0434\u0430\", \"\u0447\u0435\u0442\u0432\u0435\u0440\u0433\", \"\u043f\u044f\u0442\u043d\u0438\u0446\u0430\", \"\u0441\u0443\u0431\u0431\u043e\u0442\u0430\" ],\n\tdayNamesShort: [ \"\u0432\u0441\u043a\", \"\u043f\u043d\u0434\", \"\u0432\u0442\u0440\", \"\u0441\u0440\u0434\", \"\u0447\u0442\u0432\", \"\u043f\u0442\u043d\", \"\u0441\u0431\u0442\" ],\n\tdayNamesMin: [ \"\u0412\u0441\", \"\u041f\u043d\", \"\u0412\u0442\", \"\u0421\u0440\", \"\u0427\u0442\", \"\u041f\u0442\", \"\u0421\u0431\" ],\n\tweekHeader: \"\u041d\u0435\u0434\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ru );\n\nreturn datepicker.regional.ru;\n\n} );\n","jquery/ui-modules/i18n/datepicker-sk.js":"/* Slovak initialisation for the jQuery UI date picker plugin. */\n/* Written by Vojtech Rinik (vojto@hmm.sk). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.sk = {\n\tcloseText: \"Zavrie\u0165\",\n\tprevText: \"&#x3C;Predch\u00e1dzaj\u00faci\",\n\tnextText: \"Nasleduj\u00faci&#x3E;\",\n\tcurrentText: \"Dnes\",\n\tmonthNames: [ \"janu\u00e1r\", \"febru\u00e1r\", \"marec\", \"apr\u00edl\", \"m\u00e1j\", \"j\u00fan\",\n\t\"j\u00fal\", \"august\", \"september\", \"okt\u00f3ber\", \"november\", \"december\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"M\u00e1j\", \"J\u00fan\",\n\t\"J\u00fal\", \"Aug\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"nede\u013ea\", \"pondelok\", \"utorok\", \"streda\", \"\u0161tvrtok\", \"piatok\", \"sobota\" ],\n\tdayNamesShort: [ \"Ned\", \"Pon\", \"Uto\", \"Str\", \"\u0160tv\", \"Pia\", \"Sob\" ],\n\tdayNamesMin: [ \"Ne\", \"Po\", \"Ut\", \"St\", \"\u0160t\", \"Pia\", \"So\" ],\n\tweekHeader: \"Ty\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.sk );\n\nreturn datepicker.regional.sk;\n\n} );\n","jquery/ui-modules/i18n/datepicker-sl.js":"/* Slovenian initialisation for the jQuery UI date picker plugin. */\n/* Written by Jaka Jancar (jaka@kubje.org). */\n/* c = \u010d, s = \u0161 z = \u017e C = \u010c S = \u0160 Z = \u017d */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.sl = {\n\tcloseText: \"Zapri\",\n\tprevText: \"&#x3C;Prej\u0161nji\",\n\tnextText: \"Naslednji&#x3E;\",\n\tcurrentText: \"Trenutni\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"Marec\", \"April\", \"Maj\", \"Junij\",\n\t\"Julij\", \"Avgust\", \"September\", \"Oktober\", \"November\", \"December\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Maj\", \"Jun\",\n\t\"Jul\", \"Avg\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Nedelja\", \"Ponedeljek\", \"Torek\", \"Sreda\", \"\u010cetrtek\", \"Petek\", \"Sobota\" ],\n\tdayNamesShort: [ \"Ned\", \"Pon\", \"Tor\", \"Sre\", \"\u010cet\", \"Pet\", \"Sob\" ],\n\tdayNamesMin: [ \"Ne\", \"Po\", \"To\", \"Sr\", \"\u010ce\", \"Pe\", \"So\" ],\n\tweekHeader: \"Teden\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.sl );\n\nreturn datepicker.regional.sl;\n\n} );\n","jquery/ui-modules/i18n/datepicker-sq.js":"/* Albanian initialisation for the jQuery UI date picker plugin. */\n/* Written by Flakron Bytyqi (flakron@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.sq = {\n\tcloseText: \"mbylle\",\n\tprevText: \"&#x3C;mbrapa\",\n\tnextText: \"P\u00ebrpara&#x3E;\",\n\tcurrentText: \"sot\",\n\tmonthNames: [ \"Janar\", \"Shkurt\", \"Mars\", \"Prill\", \"Maj\", \"Qershor\",\n\t\"Korrik\", \"Gusht\", \"Shtator\", \"Tetor\", \"N\u00ebntor\", \"Dhjetor\" ],\n\tmonthNamesShort: [ \"Jan\", \"Shk\", \"Mar\", \"Pri\", \"Maj\", \"Qer\",\n\t\"Kor\", \"Gus\", \"Sht\", \"Tet\", \"N\u00ebn\", \"Dhj\" ],\n\tdayNames: [ \"E Diel\", \"E H\u00ebn\u00eb\", \"E Mart\u00eb\", \"E M\u00ebrkur\u00eb\", \"E Enjte\", \"E Premte\", \"E Shtune\" ],\n\tdayNamesShort: [ \"Di\", \"H\u00eb\", \"Ma\", \"M\u00eb\", \"En\", \"Pr\", \"Sh\" ],\n\tdayNamesMin: [ \"Di\", \"H\u00eb\", \"Ma\", \"M\u00eb\", \"En\", \"Pr\", \"Sh\" ],\n\tweekHeader: \"Ja\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.sq );\n\nreturn datepicker.regional.sq;\n\n} );\n","jquery/ui-modules/i18n/datepicker-sr-SR.js":"/* Serbian i18n for the jQuery UI date picker plugin. */\n/* Written by Dejan Dimi\u0107. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"sr-SR\" ] = {\n\tcloseText: \"Zatvori\",\n\tprevText: \"&#x3C;\",\n\tnextText: \"&#x3E;\",\n\tcurrentText: \"Danas\",\n\tmonthNames: [ \"Januar\", \"Februar\", \"Mart\", \"April\", \"Maj\", \"Jun\",\n\t\"Jul\", \"Avgust\", \"Septembar\", \"Oktobar\", \"Novembar\", \"Decembar\" ],\n\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"Maj\", \"Jun\",\n\t\"Jul\", \"Avg\", \"Sep\", \"Okt\", \"Nov\", \"Dec\" ],\n\tdayNames: [ \"Nedelja\", \"Ponedeljak\", \"Utorak\", \"Sreda\", \"\u010cetvrtak\", \"Petak\", \"Subota\" ],\n\tdayNamesShort: [ \"Ned\", \"Pon\", \"Uto\", \"Sre\", \"\u010cet\", \"Pet\", \"Sub\" ],\n\tdayNamesMin: [ \"Ne\", \"Po\", \"Ut\", \"Sr\", \"\u010ce\", \"Pe\", \"Su\" ],\n\tweekHeader: \"Sed\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional[ \"sr-SR\" ] );\n\nreturn datepicker.regional[ \"sr-SR\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-sr.js":"/* Serbian i18n for the jQuery UI date picker plugin. */\n/* Written by Dejan Dimi\u0107. */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.sr = {\n\tcloseText: \"\u0417\u0430\u0442\u0432\u043e\u0440\u0438\",\n\tprevText: \"&#x3C;\",\n\tnextText: \"&#x3E;\",\n\tcurrentText: \"\u0414\u0430\u043d\u0430\u0441\",\n\tmonthNames: [ \"\u0408\u0430\u043d\u0443\u0430\u0440\", \"\u0424\u0435\u0431\u0440\u0443\u0430\u0440\", \"\u041c\u0430\u0440\u0442\", \"\u0410\u043f\u0440\u0438\u043b\", \"\u041c\u0430\u0458\", \"\u0408\u0443\u043d\",\n\t\"\u0408\u0443\u043b\", \"\u0410\u0432\u0433\u0443\u0441\u0442\", \"\u0421\u0435\u043f\u0442\u0435\u043c\u0431\u0430\u0440\", \"\u041e\u043a\u0442\u043e\u0431\u0430\u0440\", \"\u041d\u043e\u0432\u0435\u043c\u0431\u0430\u0440\", \"\u0414\u0435\u0446\u0435\u043c\u0431\u0430\u0440\" ],\n\tmonthNamesShort: [ \"\u0408\u0430\u043d\", \"\u0424\u0435\u0431\", \"\u041c\u0430\u0440\", \"\u0410\u043f\u0440\", \"\u041c\u0430\u0458\", \"\u0408\u0443\u043d\",\n\t\"\u0408\u0443\u043b\", \"\u0410\u0432\u0433\", \"\u0421\u0435\u043f\", \"\u041e\u043a\u0442\", \"\u041d\u043e\u0432\", \"\u0414\u0435\u0446\" ],\n\tdayNames: [ \"\u041d\u0435\u0434\u0435\u0459\u0430\", \"\u041f\u043e\u043d\u0435\u0434\u0435\u0459\u0430\u043a\", \"\u0423\u0442\u043e\u0440\u0430\u043a\", \"\u0421\u0440\u0435\u0434\u0430\", \"\u0427\u0435\u0442\u0432\u0440\u0442\u0430\u043a\", \"\u041f\u0435\u0442\u0430\u043a\", \"\u0421\u0443\u0431\u043e\u0442\u0430\" ],\n\tdayNamesShort: [ \"\u041d\u0435\u0434\", \"\u041f\u043e\u043d\", \"\u0423\u0442\u043e\", \"\u0421\u0440\u0435\", \"\u0427\u0435\u0442\", \"\u041f\u0435\u0442\", \"\u0421\u0443\u0431\" ],\n\tdayNamesMin: [ \"\u041d\u0435\", \"\u041f\u043e\", \"\u0423\u0442\", \"\u0421\u0440\", \"\u0427\u0435\", \"\u041f\u0435\", \"\u0421\u0443\" ],\n\tweekHeader: \"\u0421\u0435\u0434\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.sr );\n\nreturn datepicker.regional.sr;\n\n} );\n","jquery/ui-modules/i18n/datepicker-sv.js":"/* Swedish initialisation for the jQuery UI date picker plugin. */\n/* Written by Anders Ekdahl ( anders@nomadiz.se). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.sv = {\n\tcloseText: \"St\u00e4ng\",\n\tprevText: \"&#xAB;F\u00f6rra\",\n\tnextText: \"N\u00e4sta&#xBB;\",\n\tcurrentText: \"Idag\",\n\tmonthNames: [ \"januari\", \"februari\", \"mars\", \"april\", \"maj\", \"juni\",\n\t\"juli\", \"augusti\", \"september\", \"oktober\", \"november\", \"december\" ],\n\tmonthNamesShort: [ \"jan.\", \"feb.\", \"mars\", \"apr.\", \"maj\", \"juni\",\n\t\"juli\", \"aug.\", \"sep.\", \"okt.\", \"nov.\", \"dec.\" ],\n\tdayNamesShort: [ \"s\u00f6n\", \"m\u00e5n\", \"tis\", \"ons\", \"tor\", \"fre\", \"l\u00f6r\" ],\n\tdayNames: [ \"s\u00f6ndag\", \"m\u00e5ndag\", \"tisdag\", \"onsdag\", \"torsdag\", \"fredag\", \"l\u00f6rdag\" ],\n\tdayNamesMin: [ \"s\u00f6\", \"m\u00e5\", \"ti\", \"on\", \"to\", \"fr\", \"l\u00f6\" ],\n\tweekHeader: \"Ve\",\n\tdateFormat: \"yy-mm-dd\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.sv );\n\nreturn datepicker.regional.sv;\n\n} );\n","jquery/ui-modules/i18n/datepicker-ta.js":"/* Tamil (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by S A Sureshkumar (saskumar@live.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.ta = {\n\tcloseText: \"\u0bae\u0bc2\u0b9f\u0bc1\",\n\tprevText: \"\u0bae\u0bc1\u0ba9\u0bcd\u0ba9\u0bc8\u0baf\u0ba4\u0bc1\",\n\tnextText: \"\u0b85\u0b9f\u0bc1\u0ba4\u0bcd\u0ba4\u0ba4\u0bc1\",\n\tcurrentText: \"\u0b87\u0ba9\u0bcd\u0bb1\u0bc1\",\n\tmonthNames: [ \"\u0ba4\u0bc8\", \"\u0bae\u0bbe\u0b9a\u0bbf\", \"\u0baa\u0b99\u0bcd\u0b95\u0bc1\u0ba9\u0bbf\", \"\u0b9a\u0bbf\u0ba4\u0bcd\u0ba4\u0bbf\u0bb0\u0bc8\", \"\u0bb5\u0bc8\u0b95\u0bbe\u0b9a\u0bbf\", \"\u0b86\u0ba9\u0bbf\",\n\t\"\u0b86\u0b9f\u0bbf\", \"\u0b86\u0bb5\u0ba3\u0bbf\", \"\u0baa\u0bc1\u0bb0\u0b9f\u0bcd\u0b9f\u0bbe\u0b9a\u0bbf\", \"\u0b90\u0baa\u0bcd\u0baa\u0b9a\u0bbf\", \"\u0b95\u0bbe\u0bb0\u0bcd\u0ba4\u0bcd\u0ba4\u0bbf\u0b95\u0bc8\", \"\u0bae\u0bbe\u0bb0\u0bcd\u0b95\u0bb4\u0bbf\" ],\n\tmonthNamesShort: [ \"\u0ba4\u0bc8\", \"\u0bae\u0bbe\u0b9a\u0bbf\", \"\u0baa\u0b99\u0bcd\", \"\u0b9a\u0bbf\u0ba4\u0bcd\", \"\u0bb5\u0bc8\u0b95\u0bbe\", \"\u0b86\u0ba9\u0bbf\",\n\t\"\u0b86\u0b9f\u0bbf\", \"\u0b86\u0bb5\", \"\u0baa\u0bc1\u0bb0\", \"\u0b90\u0baa\u0bcd\", \"\u0b95\u0bbe\u0bb0\u0bcd\", \"\u0bae\u0bbe\u0bb0\u0bcd\" ],\n\tdayNames: [\n\t\t\"\u0b9e\u0bbe\u0baf\u0bbf\u0bb1\u0bcd\u0bb1\u0bc1\u0b95\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\",\n\t\t\"\u0ba4\u0bbf\u0b99\u0bcd\u0b95\u0b9f\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\",\n\t\t\"\u0b9a\u0bc6\u0bb5\u0bcd\u0bb5\u0bbe\u0baf\u0bcd\u0b95\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\",\n\t\t\"\u0baa\u0bc1\u0ba4\u0ba9\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\",\n\t\t\"\u0bb5\u0bbf\u0baf\u0bbe\u0bb4\u0b95\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\",\n\t\t\"\u0bb5\u0bc6\u0bb3\u0bcd\u0bb3\u0bbf\u0b95\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\",\n\t\t\"\u0b9a\u0ba9\u0bbf\u0b95\u0bcd\u0b95\u0bbf\u0bb4\u0bae\u0bc8\"\n\t],\n\tdayNamesShort: [\n\t\t\"\u0b9e\u0bbe\u0baf\u0bbf\u0bb1\u0bc1\",\n\t\t\"\u0ba4\u0bbf\u0b99\u0bcd\u0b95\u0bb3\u0bcd\",\n\t\t\"\u0b9a\u0bc6\u0bb5\u0bcd\u0bb5\u0bbe\u0baf\u0bcd\",\n\t\t\"\u0baa\u0bc1\u0ba4\u0ba9\u0bcd\",\n\t\t\"\u0bb5\u0bbf\u0baf\u0bbe\u0bb4\u0ba9\u0bcd\",\n\t\t\"\u0bb5\u0bc6\u0bb3\u0bcd\u0bb3\u0bbf\",\n\t\t\"\u0b9a\u0ba9\u0bbf\"\n\t],\n\tdayNamesMin: [ \"\u0b9e\u0bbe\", \"\u0ba4\u0bbf\", \"\u0b9a\u0bc6\", \"\u0baa\u0bc1\", \"\u0bb5\u0bbf\", \"\u0bb5\u0bc6\", \"\u0b9a\" ],\n\tweekHeader: \"\u041d\u0435\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.ta );\n\nreturn datepicker.regional.ta;\n\n} );\n","jquery/ui-modules/i18n/datepicker-th.js":"/* Thai initialisation for the jQuery UI date picker plugin. */\n/* Written by pipo (pipo@sixhead.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.th = {\n\tcloseText: \"\u0e1b\u0e34\u0e14\",\n\tprevText: \"&#xAB;&#xA0;\u0e22\u0e49\u0e2d\u0e19\",\n\tnextText: \"\u0e16\u0e31\u0e14\u0e44\u0e1b&#xA0;&#xBB;\",\n\tcurrentText: \"\u0e27\u0e31\u0e19\u0e19\u0e35\u0e49\",\n\tmonthNames: [ \"\u0e21\u0e01\u0e23\u0e32\u0e04\u0e21\", \"\u0e01\u0e38\u0e21\u0e20\u0e32\u0e1e\u0e31\u0e19\u0e18\u0e4c\", \"\u0e21\u0e35\u0e19\u0e32\u0e04\u0e21\", \"\u0e40\u0e21\u0e29\u0e32\u0e22\u0e19\", \"\u0e1e\u0e24\u0e29\u0e20\u0e32\u0e04\u0e21\", \"\u0e21\u0e34\u0e16\u0e38\u0e19\u0e32\u0e22\u0e19\",\n\t\"\u0e01\u0e23\u0e01\u0e0e\u0e32\u0e04\u0e21\", \"\u0e2a\u0e34\u0e07\u0e2b\u0e32\u0e04\u0e21\", \"\u0e01\u0e31\u0e19\u0e22\u0e32\u0e22\u0e19\", \"\u0e15\u0e38\u0e25\u0e32\u0e04\u0e21\", \"\u0e1e\u0e24\u0e28\u0e08\u0e34\u0e01\u0e32\u0e22\u0e19\", \"\u0e18\u0e31\u0e19\u0e27\u0e32\u0e04\u0e21\" ],\n\tmonthNamesShort: [ \"\u0e21.\u0e04.\", \"\u0e01.\u0e1e.\", \"\u0e21\u0e35.\u0e04.\", \"\u0e40\u0e21.\u0e22.\", \"\u0e1e.\u0e04.\", \"\u0e21\u0e34.\u0e22.\",\n\t\"\u0e01.\u0e04.\", \"\u0e2a.\u0e04.\", \"\u0e01.\u0e22.\", \"\u0e15.\u0e04.\", \"\u0e1e.\u0e22.\", \"\u0e18.\u0e04.\" ],\n\tdayNames: [ \"\u0e2d\u0e32\u0e17\u0e34\u0e15\u0e22\u0e4c\", \"\u0e08\u0e31\u0e19\u0e17\u0e23\u0e4c\", \"\u0e2d\u0e31\u0e07\u0e04\u0e32\u0e23\", \"\u0e1e\u0e38\u0e18\", \"\u0e1e\u0e24\u0e2b\u0e31\u0e2a\u0e1a\u0e14\u0e35\", \"\u0e28\u0e38\u0e01\u0e23\u0e4c\", \"\u0e40\u0e2a\u0e32\u0e23\u0e4c\" ],\n\tdayNamesShort: [ \"\u0e2d\u0e32.\", \"\u0e08.\", \"\u0e2d.\", \"\u0e1e.\", \"\u0e1e\u0e24.\", \"\u0e28.\", \"\u0e2a.\" ],\n\tdayNamesMin: [ \"\u0e2d\u0e32.\", \"\u0e08.\", \"\u0e2d.\", \"\u0e1e.\", \"\u0e1e\u0e24.\", \"\u0e28.\", \"\u0e2a.\" ],\n\tweekHeader: \"Wk\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.th );\n\nreturn datepicker.regional.th;\n\n} );\n","jquery/ui-modules/i18n/datepicker-tj.js":"/* Tajiki (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Abdurahmon Saidov (saidovab@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.tj = {\n\tcloseText: \"\u0418\u0434\u043e\u043c\u0430\",\n\tprevText: \"&#x3c;\u049a\u0430\u0444\u043e\",\n\tnextText: \"\u041f\u0435\u0448&#x3e;\",\n\tcurrentText: \"\u0418\u043c\u0440\u04ef\u0437\",\n\tmonthNames: [ \"\u042f\u043d\u0432\u0430\u0440\", \"\u0424\u0435\u0432\u0440\u0430\u043b\", \"\u041c\u0430\u0440\u0442\", \"\u0410\u043f\u0440\u0435\u043b\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\",\n\t\"\u0418\u044e\u043b\", \"\u0410\u0432\u0433\u0443\u0441\u0442\", \"\u0421\u0435\u043d\u0442\u044f\u0431\u0440\", \"\u041e\u043a\u0442\u044f\u0431\u0440\", \"\u041d\u043e\u044f\u0431\u0440\", \"\u0414\u0435\u043a\u0430\u0431\u0440\" ],\n\tmonthNamesShort: [ \"\u042f\u043d\u0432\", \"\u0424\u0435\u0432\", \"\u041c\u0430\u0440\", \"\u0410\u043f\u0440\", \"\u041c\u0430\u0439\", \"\u0418\u044e\u043d\",\n\t\"\u0418\u044e\u043b\", \"\u0410\u0432\u0433\", \"\u0421\u0435\u043d\", \"\u041e\u043a\u0442\", \"\u041d\u043e\u044f\", \"\u0414\u0435\u043a\" ],\n\tdayNames: [ \"\u044f\u043a\u0448\u0430\u043d\u0431\u0435\", \"\u0434\u0443\u0448\u0430\u043d\u0431\u0435\", \"\u0441\u0435\u0448\u0430\u043d\u0431\u0435\", \"\u0447\u043e\u0440\u0448\u0430\u043d\u0431\u0435\", \"\u043f\u0430\u043d\u04b7\u0448\u0430\u043d\u0431\u0435\", \"\u04b7\u0443\u043c\u044a\u0430\", \"\u0448\u0430\u043d\u0431\u0435\" ],\n\tdayNamesShort: [ \"\u044f\u043a\u0448\", \"\u0434\u0443\u0448\", \"\u0441\u0435\u0448\", \"\u0447\u043e\u0440\", \"\u043f\u0430\u043d\", \"\u04b7\u0443\u043c\", \"\u0448\u0430\u043d\" ],\n\tdayNamesMin: [ \"\u042f\u043a\", \"\u0414\u0448\", \"\u0421\u0448\", \"\u0427\u0448\", \"\u041f\u0448\", \"\u04b6\u043c\", \"\u0428\u043d\" ],\n\tweekHeader: \"\u0425\u0444\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.tj );\n\nreturn datepicker.regional.tj;\n\n} );\n","jquery/ui-modules/i18n/datepicker-tr.js":"/* Turkish initialisation for the jQuery UI date picker plugin. */\n/* Written by Izzet Emre Erkan (kara@karalamalar.net). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.tr = {\n\tcloseText: \"kapat\",\n\tprevText: \"&#x3C;geri\",\n\tnextText: \"ileri&#x3e\",\n\tcurrentText: \"bug\u00fcn\",\n\tmonthNames: [ \"Ocak\", \"\u015eubat\", \"Mart\", \"Nisan\", \"May\u0131s\", \"Haziran\",\n\t\"Temmuz\", \"A\u011fustos\", \"Eyl\u00fcl\", \"Ekim\", \"Kas\u0131m\", \"Aral\u0131k\" ],\n\tmonthNamesShort: [ \"Oca\", \"\u015eub\", \"Mar\", \"Nis\", \"May\", \"Haz\",\n\t\"Tem\", \"A\u011fu\", \"Eyl\", \"Eki\", \"Kas\", \"Ara\" ],\n\tdayNames: [ \"Pazar\", \"Pazartesi\", \"Sal\u0131\", \"\u00c7ar\u015famba\", \"Per\u015fembe\", \"Cuma\", \"Cumartesi\" ],\n\tdayNamesShort: [ \"Pz\", \"Pt\", \"Sa\", \"\u00c7a\", \"Pe\", \"Cu\", \"Ct\" ],\n\tdayNamesMin: [ \"Pz\", \"Pt\", \"Sa\", \"\u00c7a\", \"Pe\", \"Cu\", \"Ct\" ],\n\tweekHeader: \"Hf\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.tr );\n\nreturn datepicker.regional.tr;\n\n} );\n","jquery/ui-modules/i18n/datepicker-uk.js":"/* Ukrainian (UTF-8) initialisation for the jQuery UI date picker plugin. */\n/* Written by Maxim Drogobitskiy (maxdao@gmail.com). */\n/* Corrected by Igor Milla (igor.fsp.milla@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.uk = {\n\tcloseText: \"\u0417\u0430\u043a\u0440\u0438\u0442\u0438\",\n\tprevText: \"&#x3C;\",\n\tnextText: \"&#x3E;\",\n\tcurrentText: \"\u0421\u044c\u043e\u0433\u043e\u0434\u043d\u0456\",\n\tmonthNames: [ \"\u0421\u0456\u0447\u0435\u043d\u044c\", \"\u041b\u044e\u0442\u0438\u0439\", \"\u0411\u0435\u0440\u0435\u0437\u0435\u043d\u044c\", \"\u041a\u0432\u0456\u0442\u0435\u043d\u044c\", \"\u0422\u0440\u0430\u0432\u0435\u043d\u044c\", \"\u0427\u0435\u0440\u0432\u0435\u043d\u044c\",\n\t\"\u041b\u0438\u043f\u0435\u043d\u044c\", \"\u0421\u0435\u0440\u043f\u0435\u043d\u044c\", \"\u0412\u0435\u0440\u0435\u0441\u0435\u043d\u044c\", \"\u0416\u043e\u0432\u0442\u0435\u043d\u044c\", \"\u041b\u0438\u0441\u0442\u043e\u043f\u0430\u0434\", \"\u0413\u0440\u0443\u0434\u0435\u043d\u044c\" ],\n\tmonthNamesShort: [ \"\u0421\u0456\u0447\", \"\u041b\u044e\u0442\", \"\u0411\u0435\u0440\", \"\u041a\u0432\u0456\", \"\u0422\u0440\u0430\", \"\u0427\u0435\u0440\",\n\t\"\u041b\u0438\u043f\", \"\u0421\u0435\u0440\", \"\u0412\u0435\u0440\", \"\u0416\u043e\u0432\", \"\u041b\u0438\u0441\", \"\u0413\u0440\u0443\" ],\n\tdayNames: [ \"\u043d\u0435\u0434\u0456\u043b\u044f\", \"\u043f\u043e\u043d\u0435\u0434\u0456\u043b\u043e\u043a\", \"\u0432\u0456\u0432\u0442\u043e\u0440\u043e\u043a\", \"\u0441\u0435\u0440\u0435\u0434\u0430\", \"\u0447\u0435\u0442\u0432\u0435\u0440\", \"\u043f\u2019\u044f\u0442\u043d\u0438\u0446\u044f\", \"\u0441\u0443\u0431\u043e\u0442\u0430\" ],\n\tdayNamesShort: [ \"\u043d\u0435\u0434\", \"\u043f\u043d\u0434\", \"\u0432\u0456\u0432\", \"\u0441\u0440\u0434\", \"\u0447\u0442\u0432\", \"\u043f\u0442\u043d\", \"\u0441\u0431\u0442\" ],\n\tdayNamesMin: [ \"\u041d\u0434\", \"\u041f\u043d\", \"\u0412\u0442\", \"\u0421\u0440\", \"\u0427\u0442\", \"\u041f\u0442\", \"\u0421\u0431\" ],\n\tweekHeader: \"\u0422\u0438\u0436\",\n\tdateFormat: \"dd.mm.yy\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.uk );\n\nreturn datepicker.regional.uk;\n\n} );\n","jquery/ui-modules/i18n/datepicker-vi.js":"/* Vietnamese initialisation for the jQuery UI date picker plugin. */\n/* Translated by Le Thanh Huy (lthanhhuy@cit.ctu.edu.vn). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional.vi = {\n\tcloseText: \"\u0110\u00f3ng\",\n\tprevText: \"&#x3C;Tr\u01b0\u1edbc\",\n\tnextText: \"Ti\u1ebfp&#x3E;\",\n\tcurrentText: \"H\u00f4m nay\",\n\tmonthNames: [ \"Th\u00e1ng M\u1ed9t\", \"Th\u00e1ng Hai\", \"Th\u00e1ng Ba\", \"Th\u00e1ng T\u01b0\", \"Th\u00e1ng N\u0103m\", \"Th\u00e1ng S\u00e1u\",\n\t\"Th\u00e1ng B\u1ea3y\", \"Th\u00e1ng T\u00e1m\", \"Th\u00e1ng Ch\u00edn\", \"Th\u00e1ng M\u01b0\u1eddi\", \"Th\u00e1ng M\u01b0\u1eddi M\u1ed9t\", \"Th\u00e1ng M\u01b0\u1eddi Hai\" ],\n\tmonthNamesShort: [ \"Th\u00e1ng 1\", \"Th\u00e1ng 2\", \"Th\u00e1ng 3\", \"Th\u00e1ng 4\", \"Th\u00e1ng 5\", \"Th\u00e1ng 6\",\n\t\"Th\u00e1ng 7\", \"Th\u00e1ng 8\", \"Th\u00e1ng 9\", \"Th\u00e1ng 10\", \"Th\u00e1ng 11\", \"Th\u00e1ng 12\" ],\n\tdayNames: [ \"Ch\u1ee7 Nh\u1eadt\", \"Th\u1ee9 Hai\", \"Th\u1ee9 Ba\", \"Th\u1ee9 T\u01b0\", \"Th\u1ee9 N\u0103m\", \"Th\u1ee9 S\u00e1u\", \"Th\u1ee9 B\u1ea3y\" ],\n\tdayNamesShort: [ \"CN\", \"T2\", \"T3\", \"T4\", \"T5\", \"T6\", \"T7\" ],\n\tdayNamesMin: [ \"CN\", \"T2\", \"T3\", \"T4\", \"T5\", \"T6\", \"T7\" ],\n\tweekHeader: \"Tu\",\n\tdateFormat: \"dd/mm/yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: false,\n\tyearSuffix: \"\" };\ndatepicker.setDefaults( datepicker.regional.vi );\n\nreturn datepicker.regional.vi;\n\n} );\n","jquery/ui-modules/i18n/datepicker-zh-CN.js":"/* Chinese initialisation for the jQuery UI date picker plugin. */\n/* Written by Cloudream (cloudream@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"zh-CN\" ] = {\n\tcloseText: \"\u5173\u95ed\",\n\tprevText: \"&#x3C;\u4e0a\u6708\",\n\tnextText: \"\u4e0b\u6708&#x3E;\",\n\tcurrentText: \"\u4eca\u5929\",\n\tmonthNames: [ \"\u4e00\u6708\", \"\u4e8c\u6708\", \"\u4e09\u6708\", \"\u56db\u6708\", \"\u4e94\u6708\", \"\u516d\u6708\",\n\t\"\u4e03\u6708\", \"\u516b\u6708\", \"\u4e5d\u6708\", \"\u5341\u6708\", \"\u5341\u4e00\u6708\", \"\u5341\u4e8c\u6708\" ],\n\tmonthNamesShort: [ \"\u4e00\u6708\", \"\u4e8c\u6708\", \"\u4e09\u6708\", \"\u56db\u6708\", \"\u4e94\u6708\", \"\u516d\u6708\",\n\t\"\u4e03\u6708\", \"\u516b\u6708\", \"\u4e5d\u6708\", \"\u5341\u6708\", \"\u5341\u4e00\u6708\", \"\u5341\u4e8c\u6708\" ],\n\tdayNames: [ \"\u661f\u671f\u65e5\", \"\u661f\u671f\u4e00\", \"\u661f\u671f\u4e8c\", \"\u661f\u671f\u4e09\", \"\u661f\u671f\u56db\", \"\u661f\u671f\u4e94\", \"\u661f\u671f\u516d\" ],\n\tdayNamesShort: [ \"\u5468\u65e5\", \"\u5468\u4e00\", \"\u5468\u4e8c\", \"\u5468\u4e09\", \"\u5468\u56db\", \"\u5468\u4e94\", \"\u5468\u516d\" ],\n\tdayNamesMin: [ \"\u65e5\", \"\u4e00\", \"\u4e8c\", \"\u4e09\", \"\u56db\", \"\u4e94\", \"\u516d\" ],\n\tweekHeader: \"\u5468\",\n\tdateFormat: \"yy-mm-dd\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\u5e74\" };\ndatepicker.setDefaults( datepicker.regional[ \"zh-CN\" ] );\n\nreturn datepicker.regional[ \"zh-CN\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-zh-HK.js":"/* Chinese initialisation for the jQuery UI date picker plugin. */\n/* Written by SCCY (samuelcychan@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"zh-HK\" ] = {\n\tcloseText: \"\u95dc\u9589\",\n\tprevText: \"&#x3C;\u4e0a\u6708\",\n\tnextText: \"\u4e0b\u6708&#x3E;\",\n\tcurrentText: \"\u4eca\u5929\",\n\tmonthNames: [ \"\u4e00\u6708\", \"\u4e8c\u6708\", \"\u4e09\u6708\", \"\u56db\u6708\", \"\u4e94\u6708\", \"\u516d\u6708\",\n\t\"\u4e03\u6708\", \"\u516b\u6708\", \"\u4e5d\u6708\", \"\u5341\u6708\", \"\u5341\u4e00\u6708\", \"\u5341\u4e8c\u6708\" ],\n\tmonthNamesShort: [ \"\u4e00\u6708\", \"\u4e8c\u6708\", \"\u4e09\u6708\", \"\u56db\u6708\", \"\u4e94\u6708\", \"\u516d\u6708\",\n\t\"\u4e03\u6708\", \"\u516b\u6708\", \"\u4e5d\u6708\", \"\u5341\u6708\", \"\u5341\u4e00\u6708\", \"\u5341\u4e8c\u6708\" ],\n\tdayNames: [ \"\u661f\u671f\u65e5\", \"\u661f\u671f\u4e00\", \"\u661f\u671f\u4e8c\", \"\u661f\u671f\u4e09\", \"\u661f\u671f\u56db\", \"\u661f\u671f\u4e94\", \"\u661f\u671f\u516d\" ],\n\tdayNamesShort: [ \"\u5468\u65e5\", \"\u5468\u4e00\", \"\u5468\u4e8c\", \"\u5468\u4e09\", \"\u5468\u56db\", \"\u5468\u4e94\", \"\u5468\u516d\" ],\n\tdayNamesMin: [ \"\u65e5\", \"\u4e00\", \"\u4e8c\", \"\u4e09\", \"\u56db\", \"\u4e94\", \"\u516d\" ],\n\tweekHeader: \"\u5468\",\n\tdateFormat: \"dd-mm-yy\",\n\tfirstDay: 0,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\u5e74\" };\ndatepicker.setDefaults( datepicker.regional[ \"zh-HK\" ] );\n\nreturn datepicker.regional[ \"zh-HK\" ];\n\n} );\n","jquery/ui-modules/i18n/datepicker-zh-TW.js":"/* Chinese initialisation for the jQuery UI date picker plugin. */\n/* Written by Ressol (ressol@gmail.com). */\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"../widgets/datepicker\" ], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery.datepicker );\n\t}\n} )( function( datepicker ) {\n\"use strict\";\n\ndatepicker.regional[ \"zh-TW\" ] = {\n\tcloseText: \"\u95dc\u9589\",\n\tprevText: \"&#x3C;\u4e0a\u500b\u6708\",\n\tnextText: \"\u4e0b\u500b\u6708&#x3E;\",\n\tcurrentText: \"\u4eca\u5929\",\n\tmonthNames: [ \"\u4e00\u6708\", \"\u4e8c\u6708\", \"\u4e09\u6708\", \"\u56db\u6708\", \"\u4e94\u6708\", \"\u516d\u6708\",\n\t\"\u4e03\u6708\", \"\u516b\u6708\", \"\u4e5d\u6708\", \"\u5341\u6708\", \"\u5341\u4e00\u6708\", \"\u5341\u4e8c\u6708\" ],\n\tmonthNamesShort: [ \"\u4e00\u6708\", \"\u4e8c\u6708\", \"\u4e09\u6708\", \"\u56db\u6708\", \"\u4e94\u6708\", \"\u516d\u6708\",\n\t\"\u4e03\u6708\", \"\u516b\u6708\", \"\u4e5d\u6708\", \"\u5341\u6708\", \"\u5341\u4e00\u6708\", \"\u5341\u4e8c\u6708\" ],\n\tdayNames: [ \"\u661f\u671f\u65e5\", \"\u661f\u671f\u4e00\", \"\u661f\u671f\u4e8c\", \"\u661f\u671f\u4e09\", \"\u661f\u671f\u56db\", \"\u661f\u671f\u4e94\", \"\u661f\u671f\u516d\" ],\n\tdayNamesShort: [ \"\u9031\u65e5\", \"\u9031\u4e00\", \"\u9031\u4e8c\", \"\u9031\u4e09\", \"\u9031\u56db\", \"\u9031\u4e94\", \"\u9031\u516d\" ],\n\tdayNamesMin: [ \"\u65e5\", \"\u4e00\", \"\u4e8c\", \"\u4e09\", \"\u56db\", \"\u4e94\", \"\u516d\" ],\n\tweekHeader: \"\u9031\",\n\tdateFormat: \"yy/mm/dd\",\n\tfirstDay: 1,\n\tisRTL: false,\n\tshowMonthAfterYear: true,\n\tyearSuffix: \"\u5e74\" };\ndatepicker.setDefaults( datepicker.regional[ \"zh-TW\" ] );\n\nreturn datepicker.regional[ \"zh-TW\" ];\n\n} );\n","jquery/ui-modules/vendor/jquery-color/jquery.color.js":"/*!\n * jQuery Color Animations v2.2.0\n * https://github.com/jquery/jquery-color\n *\n * Copyright OpenJS Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n *\n * Date: Sun May 10 09:02:36 2020 +0200\n */\n\n( function( root, factory ) {\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [ \"jquery\" ], factory );\n\t} else if ( typeof exports === \"object\" ) {\n\t\tmodule.exports = factory( require( \"jquery\" ) );\n\t} else {\n\t\tfactory( root.jQuery );\n\t}\n} )( this, function( jQuery, undefined ) {\n\n\tvar stepHooks = \"backgroundColor borderBottomColor borderLeftColor borderRightColor \" +\n\t\t\"borderTopColor color columnRuleColor outlineColor textDecorationColor textEmphasisColor\",\n\n\tclass2type = {},\n\ttoString = class2type.toString,\n\n\t// plusequals test for += 100 -= 100\n\trplusequals = /^([\\-+])=\\s*(\\d+\\.?\\d*)/,\n\n\t// a set of RE's that can match strings and generate color tuples.\n\tstringParsers = [ {\n\t\t\tre: /rgba?\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*(?:,\\s*(\\d?(?:\\.\\d+)?)\\s*)?\\)/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\texecResult[ 1 ],\n\t\t\t\t\texecResult[ 2 ],\n\t\t\t\t\texecResult[ 3 ],\n\t\t\t\t\texecResult[ 4 ]\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\t\t\tre: /rgba?\\(\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*(?:,\\s*(\\d?(?:\\.\\d+)?)\\s*)?\\)/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\texecResult[ 1 ] * 2.55,\n\t\t\t\t\texecResult[ 2 ] * 2.55,\n\t\t\t\t\texecResult[ 3 ] * 2.55,\n\t\t\t\t\texecResult[ 4 ]\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\n\t\t\t// this regex ignores A-F because it's compared against an already lowercased string\n\t\t\tre: /#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})?/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\tparseInt( execResult[ 1 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 2 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 3 ], 16 ),\n\t\t\t\t\texecResult[ 4 ] ?\n\t\t\t\t\t\t( parseInt( execResult[ 4 ], 16 ) / 255 ).toFixed( 2 ) :\n\t\t\t\t\t\t1\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\n\t\t\t// this regex ignores A-F because it's compared against an already lowercased string\n\t\t\tre: /#([a-f0-9])([a-f0-9])([a-f0-9])([a-f0-9])?/,\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\tparseInt( execResult[ 1 ] + execResult[ 1 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 2 ] + execResult[ 2 ], 16 ),\n\t\t\t\t\tparseInt( execResult[ 3 ] + execResult[ 3 ], 16 ),\n\t\t\t\t\texecResult[ 4 ] ?\n\t\t\t\t\t\t( parseInt( execResult[ 4 ] + execResult[ 4 ], 16 ) / 255 )\n\t\t\t\t\t\t\t.toFixed( 2 ) :\n\t\t\t\t\t\t1\n\t\t\t\t];\n\t\t\t}\n\t\t}, {\n\t\t\tre: /hsla?\\(\\s*(\\d+(?:\\.\\d+)?)\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*,\\s*(\\d+(?:\\.\\d+)?)\\%\\s*(?:,\\s*(\\d?(?:\\.\\d+)?)\\s*)?\\)/,\n\t\t\tspace: \"hsla\",\n\t\t\tparse: function( execResult ) {\n\t\t\t\treturn [\n\t\t\t\t\texecResult[ 1 ],\n\t\t\t\t\texecResult[ 2 ] / 100,\n\t\t\t\t\texecResult[ 3 ] / 100,\n\t\t\t\t\texecResult[ 4 ]\n\t\t\t\t];\n\t\t\t}\n\t\t} ],\n\n\t// jQuery.Color( )\n\tcolor = jQuery.Color = function( color, green, blue, alpha ) {\n\t\treturn new jQuery.Color.fn.parse( color, green, blue, alpha );\n\t},\n\tspaces = {\n\t\trgba: {\n\t\t\tprops: {\n\t\t\t\tred: {\n\t\t\t\t\tidx: 0,\n\t\t\t\t\ttype: \"byte\"\n\t\t\t\t},\n\t\t\t\tgreen: {\n\t\t\t\t\tidx: 1,\n\t\t\t\t\ttype: \"byte\"\n\t\t\t\t},\n\t\t\t\tblue: {\n\t\t\t\t\tidx: 2,\n\t\t\t\t\ttype: \"byte\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\thsla: {\n\t\t\tprops: {\n\t\t\t\thue: {\n\t\t\t\t\tidx: 0,\n\t\t\t\t\ttype: \"degrees\"\n\t\t\t\t},\n\t\t\t\tsaturation: {\n\t\t\t\t\tidx: 1,\n\t\t\t\t\ttype: \"percent\"\n\t\t\t\t},\n\t\t\t\tlightness: {\n\t\t\t\t\tidx: 2,\n\t\t\t\t\ttype: \"percent\"\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t},\n\tpropTypes = {\n\t\t\"byte\": {\n\t\t\tfloor: true,\n\t\t\tmax: 255\n\t\t},\n\t\t\"percent\": {\n\t\t\tmax: 1\n\t\t},\n\t\t\"degrees\": {\n\t\t\tmod: 360,\n\t\t\tfloor: true\n\t\t}\n\t},\n\tsupport = color.support = {},\n\n\t// element for support tests\n\tsupportElem = jQuery( \"<p>\" )[ 0 ],\n\n\t// colors = jQuery.Color.names\n\tcolors,\n\n\t// local aliases of functions called often\n\teach = jQuery.each;\n\n// determine rgba support immediately\nsupportElem.style.cssText = \"background-color:rgba(1,1,1,.5)\";\nsupport.rgba = supportElem.style.backgroundColor.indexOf( \"rgba\" ) > -1;\n\n// define cache name and alpha properties\n// for rgba and hsla spaces\neach( spaces, function( spaceName, space ) {\n\tspace.cache = \"_\" + spaceName;\n\tspace.props.alpha = {\n\t\tidx: 3,\n\t\ttype: \"percent\",\n\t\tdef: 1\n\t};\n} );\n\n// Populate the class2type map\njQuery.each( \"Boolean Number String Function Array Date RegExp Object Error Symbol\".split( \" \" ),\n\tfunction( _i, name ) {\n\t\tclass2type[ \"[object \" + name + \"]\" ] = name.toLowerCase();\n\t} );\n\nfunction getType( obj ) {\n\tif ( obj == null ) {\n\t\treturn obj + \"\";\n\t}\n\n\treturn typeof obj === \"object\" ?\n\t\tclass2type[ toString.call( obj ) ] || \"object\" :\n\t\ttypeof obj;\n}\n\nfunction clamp( value, prop, allowEmpty ) {\n\tvar type = propTypes[ prop.type ] || {};\n\n\tif ( value == null ) {\n\t\treturn ( allowEmpty || !prop.def ) ? null : prop.def;\n\t}\n\n\t// ~~ is an short way of doing floor for positive numbers\n\tvalue = type.floor ? ~~value : parseFloat( value );\n\n\t// IE will pass in empty strings as value for alpha,\n\t// which will hit this case\n\tif ( isNaN( value ) ) {\n\t\treturn prop.def;\n\t}\n\n\tif ( type.mod ) {\n\n\t\t// we add mod before modding to make sure that negatives values\n\t\t// get converted properly: -10 -> 350\n\t\treturn ( value + type.mod ) % type.mod;\n\t}\n\n\t// for now all property types without mod have min and max\n\treturn Math.min( type.max, Math.max( 0, value ) );\n}\n\nfunction stringParse( string ) {\n\tvar inst = color(),\n\t\trgba = inst._rgba = [];\n\n\tstring = string.toLowerCase();\n\n\teach( stringParsers, function( _i, parser ) {\n\t\tvar parsed,\n\t\t\tmatch = parser.re.exec( string ),\n\t\t\tvalues = match && parser.parse( match ),\n\t\t\tspaceName = parser.space || \"rgba\";\n\n\t\tif ( values ) {\n\t\t\tparsed = inst[ spaceName ]( values );\n\n\t\t\t// if this was an rgba parse the assignment might happen twice\n\t\t\t// oh well....\n\t\t\tinst[ spaces[ spaceName ].cache ] = parsed[ spaces[ spaceName ].cache ];\n\t\t\trgba = inst._rgba = parsed._rgba;\n\n\t\t\t// exit each( stringParsers ) here because we matched\n\t\t\treturn false;\n\t\t}\n\t} );\n\n\t// Found a stringParser that handled it\n\tif ( rgba.length ) {\n\n\t\t// if this came from a parsed string, force \"transparent\" when alpha is 0\n\t\t// chrome, (and maybe others) return \"transparent\" as rgba(0,0,0,0)\n\t\tif ( rgba.join() === \"0,0,0,0\" ) {\n\t\t\tjQuery.extend( rgba, colors.transparent );\n\t\t}\n\t\treturn inst;\n\t}\n\n\t// named colors\n\treturn colors[ string ];\n}\n\ncolor.fn = jQuery.extend( color.prototype, {\n\tparse: function( red, green, blue, alpha ) {\n\t\tif ( red === undefined ) {\n\t\t\tthis._rgba = [ null, null, null, null ];\n\t\t\treturn this;\n\t\t}\n\t\tif ( red.jquery || red.nodeType ) {\n\t\t\tred = jQuery( red ).css( green );\n\t\t\tgreen = undefined;\n\t\t}\n\n\t\tvar inst = this,\n\t\t\ttype = getType( red ),\n\t\t\trgba = this._rgba = [];\n\n\t\t// more than 1 argument specified - assume ( red, green, blue, alpha )\n\t\tif ( green !== undefined ) {\n\t\t\tred = [ red, green, blue, alpha ];\n\t\t\ttype = \"array\";\n\t\t}\n\n\t\tif ( type === \"string\" ) {\n\t\t\treturn this.parse( stringParse( red ) || colors._default );\n\t\t}\n\n\t\tif ( type === \"array\" ) {\n\t\t\teach( spaces.rgba.props, function( _key, prop ) {\n\t\t\t\trgba[ prop.idx ] = clamp( red[ prop.idx ], prop );\n\t\t\t} );\n\t\t\treturn this;\n\t\t}\n\n\t\tif ( type === \"object\" ) {\n\t\t\tif ( red instanceof color ) {\n\t\t\t\teach( spaces, function( _spaceName, space ) {\n\t\t\t\t\tif ( red[ space.cache ] ) {\n\t\t\t\t\t\tinst[ space.cache ] = red[ space.cache ].slice();\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t} else {\n\t\t\t\teach( spaces, function( _spaceName, space ) {\n\t\t\t\t\tvar cache = space.cache;\n\t\t\t\t\teach( space.props, function( key, prop ) {\n\n\t\t\t\t\t\t// if the cache doesn't exist, and we know how to convert\n\t\t\t\t\t\tif ( !inst[ cache ] && space.to ) {\n\n\t\t\t\t\t\t\t// if the value was null, we don't need to copy it\n\t\t\t\t\t\t\t// if the key was alpha, we don't need to copy it either\n\t\t\t\t\t\t\tif ( key === \"alpha\" || red[ key ] == null ) {\n\t\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tinst[ cache ] = space.to( inst._rgba );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// this is the only case where we allow nulls for ALL properties.\n\t\t\t\t\t\t// call clamp with alwaysAllowEmpty\n\t\t\t\t\t\tinst[ cache ][ prop.idx ] = clamp( red[ key ], prop, true );\n\t\t\t\t\t} );\n\n\t\t\t\t\t// everything defined but alpha?\n\t\t\t\t\tif ( inst[ cache ] && jQuery.inArray( null, inst[ cache ].slice( 0, 3 ) ) < 0 ) {\n\n\t\t\t\t\t\t// use the default of 1\n\t\t\t\t\t\tif ( inst[ cache ][ 3 ] == null ) {\n\t\t\t\t\t\t\tinst[ cache ][ 3 ] = 1;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif ( space.from ) {\n\t\t\t\t\t\t\tinst._rgba = space.from( inst[ cache ] );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t}\n\t\t\treturn this;\n\t\t}\n\t},\n\tis: function( compare ) {\n\t\tvar is = color( compare ),\n\t\t\tsame = true,\n\t\t\tinst = this;\n\n\t\teach( spaces, function( _, space ) {\n\t\t\tvar localCache,\n\t\t\t\tisCache = is[ space.cache ];\n\t\t\tif ( isCache ) {\n\t\t\t\tlocalCache = inst[ space.cache ] || space.to && space.to( inst._rgba ) || [];\n\t\t\t\teach( space.props, function( _, prop ) {\n\t\t\t\t\tif ( isCache[ prop.idx ] != null ) {\n\t\t\t\t\t\tsame = ( isCache[ prop.idx ] === localCache[ prop.idx ] );\n\t\t\t\t\t\treturn same;\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t}\n\t\t\treturn same;\n\t\t} );\n\t\treturn same;\n\t},\n\t_space: function() {\n\t\tvar used = [],\n\t\t\tinst = this;\n\t\teach( spaces, function( spaceName, space ) {\n\t\t\tif ( inst[ space.cache ] ) {\n\t\t\t\tused.push( spaceName );\n\t\t\t}\n\t\t} );\n\t\treturn used.pop();\n\t},\n\ttransition: function( other, distance ) {\n\t\tvar end = color( other ),\n\t\t\tspaceName = end._space(),\n\t\t\tspace = spaces[ spaceName ],\n\t\t\tstartColor = this.alpha() === 0 ? color( \"transparent\" ) : this,\n\t\t\tstart = startColor[ space.cache ] || space.to( startColor._rgba ),\n\t\t\tresult = start.slice();\n\n\t\tend = end[ space.cache ];\n\t\teach( space.props, function( _key, prop ) {\n\t\t\tvar index = prop.idx,\n\t\t\t\tstartValue = start[ index ],\n\t\t\t\tendValue = end[ index ],\n\t\t\t\ttype = propTypes[ prop.type ] || {};\n\n\t\t\t// if null, don't override start value\n\t\t\tif ( endValue === null ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// if null - use end\n\t\t\tif ( startValue === null ) {\n\t\t\t\tresult[ index ] = endValue;\n\t\t\t} else {\n\t\t\t\tif ( type.mod ) {\n\t\t\t\t\tif ( endValue - startValue > type.mod / 2 ) {\n\t\t\t\t\t\tstartValue += type.mod;\n\t\t\t\t\t} else if ( startValue - endValue > type.mod / 2 ) {\n\t\t\t\t\t\tstartValue -= type.mod;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\tresult[ index ] = clamp( ( endValue - startValue ) * distance + startValue, prop );\n\t\t\t}\n\t\t} );\n\t\treturn this[ spaceName ]( result );\n\t},\n\tblend: function( opaque ) {\n\n\t\t// if we are already opaque - return ourself\n\t\tif ( this._rgba[ 3 ] === 1 ) {\n\t\t\treturn this;\n\t\t}\n\n\t\tvar rgb = this._rgba.slice(),\n\t\t\ta = rgb.pop(),\n\t\t\tblend = color( opaque )._rgba;\n\n\t\treturn color( jQuery.map( rgb, function( v, i ) {\n\t\t\treturn ( 1 - a ) * blend[ i ] + a * v;\n\t\t} ) );\n\t},\n\ttoRgbaString: function() {\n\t\tvar prefix = \"rgba(\",\n\t\t\trgba = jQuery.map( this._rgba, function( v, i ) {\n\t\t\t\tif ( v != null ) {\n\t\t\t\t\treturn v;\n\t\t\t\t}\n\t\t\t\treturn i > 2 ? 1 : 0;\n\t\t\t} );\n\n\t\tif ( rgba[ 3 ] === 1 ) {\n\t\t\trgba.pop();\n\t\t\tprefix = \"rgb(\";\n\t\t}\n\n\t\treturn prefix + rgba.join() + \")\";\n\t},\n\ttoHslaString: function() {\n\t\tvar prefix = \"hsla(\",\n\t\t\thsla = jQuery.map( this.hsla(), function( v, i ) {\n\t\t\t\tif ( v == null ) {\n\t\t\t\t\tv = i > 2 ? 1 : 0;\n\t\t\t\t}\n\n\t\t\t\t// catch 1 and 2\n\t\t\t\tif ( i && i < 3 ) {\n\t\t\t\t\tv = Math.round( v * 100 ) + \"%\";\n\t\t\t\t}\n\t\t\t\treturn v;\n\t\t\t} );\n\n\t\tif ( hsla[ 3 ] === 1 ) {\n\t\t\thsla.pop();\n\t\t\tprefix = \"hsl(\";\n\t\t}\n\t\treturn prefix + hsla.join() + \")\";\n\t},\n\ttoHexString: function( includeAlpha ) {\n\t\tvar rgba = this._rgba.slice(),\n\t\t\talpha = rgba.pop();\n\n\t\tif ( includeAlpha ) {\n\t\t\trgba.push( ~~( alpha * 255 ) );\n\t\t}\n\n\t\treturn \"#\" + jQuery.map( rgba, function( v ) {\n\n\t\t\t// default to 0 when nulls exist\n\t\t\tv = ( v || 0 ).toString( 16 );\n\t\t\treturn v.length === 1 ? \"0\" + v : v;\n\t\t} ).join( \"\" );\n\t},\n\ttoString: function() {\n\t\treturn this._rgba[ 3 ] === 0 ? \"transparent\" : this.toRgbaString();\n\t}\n} );\ncolor.fn.parse.prototype = color.fn;\n\n// hsla conversions adapted from:\n// https://code.google.com/p/maashaack/source/browse/packages/graphics/trunk/src/graphics/colors/HUE2RGB.as?r=5021\n\nfunction hue2rgb( p, q, h ) {\n\th = ( h + 1 ) % 1;\n\tif ( h * 6 < 1 ) {\n\t\treturn p + ( q - p ) * h * 6;\n\t}\n\tif ( h * 2 < 1 ) {\n\t\treturn q;\n\t}\n\tif ( h * 3 < 2 ) {\n\t\treturn p + ( q - p ) * ( ( 2 / 3 ) - h ) * 6;\n\t}\n\treturn p;\n}\n\nspaces.hsla.to = function( rgba ) {\n\tif ( rgba[ 0 ] == null || rgba[ 1 ] == null || rgba[ 2 ] == null ) {\n\t\treturn [ null, null, null, rgba[ 3 ] ];\n\t}\n\tvar r = rgba[ 0 ] / 255,\n\t\tg = rgba[ 1 ] / 255,\n\t\tb = rgba[ 2 ] / 255,\n\t\ta = rgba[ 3 ],\n\t\tmax = Math.max( r, g, b ),\n\t\tmin = Math.min( r, g, b ),\n\t\tdiff = max - min,\n\t\tadd = max + min,\n\t\tl = add * 0.5,\n\t\th, s;\n\n\tif ( min === max ) {\n\t\th = 0;\n\t} else if ( r === max ) {\n\t\th = ( 60 * ( g - b ) / diff ) + 360;\n\t} else if ( g === max ) {\n\t\th = ( 60 * ( b - r ) / diff ) + 120;\n\t} else {\n\t\th = ( 60 * ( r - g ) / diff ) + 240;\n\t}\n\n\t// chroma (diff) == 0 means greyscale which, by definition, saturation = 0%\n\t// otherwise, saturation is based on the ratio of chroma (diff) to lightness (add)\n\tif ( diff === 0 ) {\n\t\ts = 0;\n\t} else if ( l <= 0.5 ) {\n\t\ts = diff / add;\n\t} else {\n\t\ts = diff / ( 2 - add );\n\t}\n\treturn [ Math.round( h ) % 360, s, l, a == null ? 1 : a ];\n};\n\nspaces.hsla.from = function( hsla ) {\n\tif ( hsla[ 0 ] == null || hsla[ 1 ] == null || hsla[ 2 ] == null ) {\n\t\treturn [ null, null, null, hsla[ 3 ] ];\n\t}\n\tvar h = hsla[ 0 ] / 360,\n\t\ts = hsla[ 1 ],\n\t\tl = hsla[ 2 ],\n\t\ta = hsla[ 3 ],\n\t\tq = l <= 0.5 ? l * ( 1 + s ) : l + s - l * s,\n\t\tp = 2 * l - q;\n\n\treturn [\n\t\tMath.round( hue2rgb( p, q, h + ( 1 / 3 ) ) * 255 ),\n\t\tMath.round( hue2rgb( p, q, h ) * 255 ),\n\t\tMath.round( hue2rgb( p, q, h - ( 1 / 3 ) ) * 255 ),\n\t\ta\n\t];\n};\n\n\neach( spaces, function( spaceName, space ) {\n\tvar props = space.props,\n\t\tcache = space.cache,\n\t\tto = space.to,\n\t\tfrom = space.from;\n\n\t// makes rgba() and hsla()\n\tcolor.fn[ spaceName ] = function( value ) {\n\n\t\t// generate a cache for this space if it doesn't exist\n\t\tif ( to && !this[ cache ] ) {\n\t\t\tthis[ cache ] = to( this._rgba );\n\t\t}\n\t\tif ( value === undefined ) {\n\t\t\treturn this[ cache ].slice();\n\t\t}\n\n\t\tvar ret,\n\t\t\ttype = getType( value ),\n\t\t\tarr = ( type === \"array\" || type === \"object\" ) ? value : arguments,\n\t\t\tlocal = this[ cache ].slice();\n\n\t\teach( props, function( key, prop ) {\n\t\t\tvar val = arr[ type === \"object\" ? key : prop.idx ];\n\t\t\tif ( val == null ) {\n\t\t\t\tval = local[ prop.idx ];\n\t\t\t}\n\t\t\tlocal[ prop.idx ] = clamp( val, prop );\n\t\t} );\n\n\t\tif ( from ) {\n\t\t\tret = color( from( local ) );\n\t\t\tret[ cache ] = local;\n\t\t\treturn ret;\n\t\t} else {\n\t\t\treturn color( local );\n\t\t}\n\t};\n\n\t// makes red() green() blue() alpha() hue() saturation() lightness()\n\teach( props, function( key, prop ) {\n\n\t\t// alpha is included in more than one space\n\t\tif ( color.fn[ key ] ) {\n\t\t\treturn;\n\t\t}\n\t\tcolor.fn[ key ] = function( value ) {\n\t\t\tvar local, cur, match, fn,\n\t\t\t\tvtype = getType( value );\n\n\t\t\tif ( key === \"alpha\" ) {\n\t\t\t\tfn = this._hsla ? \"hsla\" : \"rgba\";\n\t\t\t} else {\n\t\t\t\tfn = spaceName;\n\t\t\t}\n\t\t\tlocal = this[ fn ]();\n\t\t\tcur = local[ prop.idx ];\n\n\t\t\tif ( vtype === \"undefined\" ) {\n\t\t\t\treturn cur;\n\t\t\t}\n\n\t\t\tif ( vtype === \"function\" ) {\n\t\t\t\tvalue = value.call( this, cur );\n\t\t\t\tvtype = getType( value );\n\t\t\t}\n\t\t\tif ( value == null && prop.empty ) {\n\t\t\t\treturn this;\n\t\t\t}\n\t\t\tif ( vtype === \"string\" ) {\n\t\t\t\tmatch = rplusequals.exec( value );\n\t\t\t\tif ( match ) {\n\t\t\t\t\tvalue = cur + parseFloat( match[ 2 ] ) * ( match[ 1 ] === \"+\" ? 1 : -1 );\n\t\t\t\t}\n\t\t\t}\n\t\t\tlocal[ prop.idx ] = value;\n\t\t\treturn this[ fn ]( local );\n\t\t};\n\t} );\n} );\n\n// add cssHook and .fx.step function for each named hook.\n// accept a space separated string of properties\ncolor.hook = function( hook ) {\n\tvar hooks = hook.split( \" \" );\n\teach( hooks, function( _i, hook ) {\n\t\tjQuery.cssHooks[ hook ] = {\n\t\t\tset: function( elem, value ) {\n\t\t\t\tvar parsed, curElem,\n\t\t\t\t\tbackgroundColor = \"\";\n\n\t\t\t\tif ( value !== \"transparent\" && ( getType( value ) !== \"string\" || ( parsed = stringParse( value ) ) ) ) {\n\t\t\t\t\tvalue = color( parsed || value );\n\t\t\t\t\tif ( !support.rgba && value._rgba[ 3 ] !== 1 ) {\n\t\t\t\t\t\tcurElem = hook === \"backgroundColor\" ? elem.parentNode : elem;\n\t\t\t\t\t\twhile (\n\t\t\t\t\t\t\t( backgroundColor === \"\" || backgroundColor === \"transparent\" ) &&\n\t\t\t\t\t\t\tcurElem && curElem.style\n\t\t\t\t\t\t) {\n\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\tbackgroundColor = jQuery.css( curElem, \"backgroundColor\" );\n\t\t\t\t\t\t\t\tcurElem = curElem.parentNode;\n\t\t\t\t\t\t\t} catch ( e ) {\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tvalue = value.blend( backgroundColor && backgroundColor !== \"transparent\" ?\n\t\t\t\t\t\t\tbackgroundColor :\n\t\t\t\t\t\t\t\"_default\" );\n\t\t\t\t\t}\n\n\t\t\t\t\tvalue = value.toRgbaString();\n\t\t\t\t}\n\t\t\t\ttry {\n\t\t\t\t\telem.style[ hook ] = value;\n\t\t\t\t} catch ( e ) {\n\n\t\t\t\t\t// wrapped to prevent IE from throwing errors on \"invalid\" values like 'auto' or 'inherit'\n\t\t\t\t}\n\t\t\t}\n\t\t};\n\t\tjQuery.fx.step[ hook ] = function( fx ) {\n\t\t\tif ( !fx.colorInit ) {\n\t\t\t\tfx.start = color( fx.elem, hook );\n\t\t\t\tfx.end = color( fx.end );\n\t\t\t\tfx.colorInit = true;\n\t\t\t}\n\t\t\tjQuery.cssHooks[ hook ].set( fx.elem, fx.start.transition( fx.end, fx.pos ) );\n\t\t};\n\t} );\n\n};\n\ncolor.hook( stepHooks );\n\njQuery.cssHooks.borderColor = {\n\texpand: function( value ) {\n\t\tvar expanded = {};\n\n\t\teach( [ \"Top\", \"Right\", \"Bottom\", \"Left\" ], function( _i, part ) {\n\t\t\texpanded[ \"border\" + part + \"Color\" ] = value;\n\t\t} );\n\t\treturn expanded;\n\t}\n};\n\n// Basic color names only.\n// Usage of any of the other color names requires adding yourself or including\n// jquery.color.svg-names.js.\ncolors = jQuery.Color.names = {\n\n\t// 4.1. Basic color keywords\n\taqua: \"#00ffff\",\n\tblack: \"#000000\",\n\tblue: \"#0000ff\",\n\tfuchsia: \"#ff00ff\",\n\tgray: \"#808080\",\n\tgreen: \"#008000\",\n\tlime: \"#00ff00\",\n\tmaroon: \"#800000\",\n\tnavy: \"#000080\",\n\tolive: \"#808000\",\n\tpurple: \"#800080\",\n\tred: \"#ff0000\",\n\tsilver: \"#c0c0c0\",\n\tteal: \"#008080\",\n\twhite: \"#ffffff\",\n\tyellow: \"#ffff00\",\n\n\t// 4.2.3. \"transparent\" color keyword\n\ttransparent: [ null, null, null, 0 ],\n\n\t_default: \"#ffffff\"\n};\n\n} );\n","jquery/ui-modules/widgets/accordion.js":"/*!\n * jQuery UI Accordion 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Accordion\n//>>group: Widgets\n/* eslint-disable max-len */\n//>>description: Displays collapsible content panels for presenting information in a limited amount of space.\n/* eslint-enable max-len */\n//>>docs: http://api.jqueryui.com/accordion/\n//>>demos: http://jqueryui.com/accordion/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/accordion.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../keycode\",\n\t\t\t\"../unique-id\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nreturn $.widget( \"ui.accordion\", {\n\tversion: \"1.13.1\",\n\toptions: {\n\t\tactive: 0,\n\t\tanimate: {},\n\t\tclasses: {\n\t\t\t\"ui-accordion-header\": \"ui-corner-top\",\n\t\t\t\"ui-accordion-header-collapsed\": \"ui-corner-all\",\n\t\t\t\"ui-accordion-content\": \"ui-corner-bottom\"\n\t\t},\n\t\tcollapsible: false,\n\t\tevent: \"click\",\n\t\theader: function( elem ) {\n\t\t\treturn elem.find( \"> li > :first-child\" ).add( elem.find( \"> :not(li)\" ).even() );\n\t\t},\n\t\theightStyle: \"auto\",\n\t\ticons: {\n\t\t\tactiveHeader: \"ui-icon-triangle-1-s\",\n\t\t\theader: \"ui-icon-triangle-1-e\"\n\t\t},\n\n\t\t// Callbacks\n\t\tactivate: null,\n\t\tbeforeActivate: null\n\t},\n\n\thideProps: {\n\t\tborderTopWidth: \"hide\",\n\t\tborderBottomWidth: \"hide\",\n\t\tpaddingTop: \"hide\",\n\t\tpaddingBottom: \"hide\",\n\t\theight: \"hide\"\n\t},\n\n\tshowProps: {\n\t\tborderTopWidth: \"show\",\n\t\tborderBottomWidth: \"show\",\n\t\tpaddingTop: \"show\",\n\t\tpaddingBottom: \"show\",\n\t\theight: \"show\"\n\t},\n\n\t_create: function() {\n\t\tvar options = this.options;\n\n\t\tthis.prevShow = this.prevHide = $();\n\t\tthis._addClass( \"ui-accordion\", \"ui-widget ui-helper-reset\" );\n\t\tthis.element.attr( \"role\", \"tablist\" );\n\n\t\t// Don't allow collapsible: false and active: false / null\n\t\tif ( !options.collapsible && ( options.active === false || options.active == null ) ) {\n\t\t\toptions.active = 0;\n\t\t}\n\n\t\tthis._processPanels();\n\n\t\t// handle negative values\n\t\tif ( options.active < 0 ) {\n\t\t\toptions.active += this.headers.length;\n\t\t}\n\t\tthis._refresh();\n\t},\n\n\t_getCreateEventData: function() {\n\t\treturn {\n\t\t\theader: this.active,\n\t\t\tpanel: !this.active.length ? $() : this.active.next()\n\t\t};\n\t},\n\n\t_createIcons: function() {\n\t\tvar icon, children,\n\t\t\ticons = this.options.icons;\n\n\t\tif ( icons ) {\n\t\t\ticon = $( \"<span>\" );\n\t\t\tthis._addClass( icon, \"ui-accordion-header-icon\", \"ui-icon \" + icons.header );\n\t\t\ticon.prependTo( this.headers );\n\t\t\tchildren = this.active.children( \".ui-accordion-header-icon\" );\n\t\t\tthis._removeClass( children, icons.header )\n\t\t\t\t._addClass( children, null, icons.activeHeader )\n\t\t\t\t._addClass( this.headers, \"ui-accordion-icons\" );\n\t\t}\n\t},\n\n\t_destroyIcons: function() {\n\t\tthis._removeClass( this.headers, \"ui-accordion-icons\" );\n\t\tthis.headers.children( \".ui-accordion-header-icon\" ).remove();\n\t},\n\n\t_destroy: function() {\n\t\tvar contents;\n\n\t\t// Clean up main element\n\t\tthis.element.removeAttr( \"role\" );\n\n\t\t// Clean up headers\n\t\tthis.headers\n\t\t\t.removeAttr( \"role aria-expanded aria-selected aria-controls tabIndex\" )\n\t\t\t.removeUniqueId();\n\n\t\tthis._destroyIcons();\n\n\t\t// Clean up content panels\n\t\tcontents = this.headers.next()\n\t\t\t.css( \"display\", \"\" )\n\t\t\t.removeAttr( \"role aria-hidden aria-labelledby\" )\n\t\t\t.removeUniqueId();\n\n\t\tif ( this.options.heightStyle !== \"content\" ) {\n\t\t\tcontents.css( \"height\", \"\" );\n\t\t}\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tif ( key === \"active\" ) {\n\n\t\t\t// _activate() will handle invalid values and update this.options\n\t\t\tthis._activate( value );\n\t\t\treturn;\n\t\t}\n\n\t\tif ( key === \"event\" ) {\n\t\t\tif ( this.options.event ) {\n\t\t\t\tthis._off( this.headers, this.options.event );\n\t\t\t}\n\t\t\tthis._setupEvents( value );\n\t\t}\n\n\t\tthis._super( key, value );\n\n\t\t// Setting collapsible: false while collapsed; open first panel\n\t\tif ( key === \"collapsible\" && !value && this.options.active === false ) {\n\t\t\tthis._activate( 0 );\n\t\t}\n\n\t\tif ( key === \"icons\" ) {\n\t\t\tthis._destroyIcons();\n\t\t\tif ( value ) {\n\t\t\t\tthis._createIcons();\n\t\t\t}\n\t\t}\n\t},\n\n\t_setOptionDisabled: function( value ) {\n\t\tthis._super( value );\n\n\t\tthis.element.attr( \"aria-disabled\", value );\n\n\t\t// Support: IE8 Only\n\t\t// #5332 / #6059 - opacity doesn't cascade to positioned elements in IE\n\t\t// so we need to add the disabled class to the headers and panels\n\t\tthis._toggleClass( null, \"ui-state-disabled\", !!value );\n\t\tthis._toggleClass( this.headers.add( this.headers.next() ), null, \"ui-state-disabled\",\n\t\t\t!!value );\n\t},\n\n\t_keydown: function( event ) {\n\t\tif ( event.altKey || event.ctrlKey ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar keyCode = $.ui.keyCode,\n\t\t\tlength = this.headers.length,\n\t\t\tcurrentIndex = this.headers.index( event.target ),\n\t\t\ttoFocus = false;\n\n\t\tswitch ( event.keyCode ) {\n\t\tcase keyCode.RIGHT:\n\t\tcase keyCode.DOWN:\n\t\t\ttoFocus = this.headers[ ( currentIndex + 1 ) % length ];\n\t\t\tbreak;\n\t\tcase keyCode.LEFT:\n\t\tcase keyCode.UP:\n\t\t\ttoFocus = this.headers[ ( currentIndex - 1 + length ) % length ];\n\t\t\tbreak;\n\t\tcase keyCode.SPACE:\n\t\tcase keyCode.ENTER:\n\t\t\tthis._eventHandler( event );\n\t\t\tbreak;\n\t\tcase keyCode.HOME:\n\t\t\ttoFocus = this.headers[ 0 ];\n\t\t\tbreak;\n\t\tcase keyCode.END:\n\t\t\ttoFocus = this.headers[ length - 1 ];\n\t\t\tbreak;\n\t\t}\n\n\t\tif ( toFocus ) {\n\t\t\t$( event.target ).attr( \"tabIndex\", -1 );\n\t\t\t$( toFocus ).attr( \"tabIndex\", 0 );\n\t\t\t$( toFocus ).trigger( \"focus\" );\n\t\t\tevent.preventDefault();\n\t\t}\n\t},\n\n\t_panelKeyDown: function( event ) {\n\t\tif ( event.keyCode === $.ui.keyCode.UP && event.ctrlKey ) {\n\t\t\t$( event.currentTarget ).prev().trigger( \"focus\" );\n\t\t}\n\t},\n\n\trefresh: function() {\n\t\tvar options = this.options;\n\t\tthis._processPanels();\n\n\t\t// Was collapsed or no panel\n\t\tif ( ( options.active === false && options.collapsible === true ) ||\n\t\t\t\t!this.headers.length ) {\n\t\t\toptions.active = false;\n\t\t\tthis.active = $();\n\n\t\t// active false only when collapsible is true\n\t\t} else if ( options.active === false ) {\n\t\t\tthis._activate( 0 );\n\n\t\t// was active, but active panel is gone\n\t\t} else if ( this.active.length && !$.contains( this.element[ 0 ], this.active[ 0 ] ) ) {\n\n\t\t\t// all remaining panel are disabled\n\t\t\tif ( this.headers.length === this.headers.find( \".ui-state-disabled\" ).length ) {\n\t\t\t\toptions.active = false;\n\t\t\t\tthis.active = $();\n\n\t\t\t// activate previous panel\n\t\t\t} else {\n\t\t\t\tthis._activate( Math.max( 0, options.active - 1 ) );\n\t\t\t}\n\n\t\t// was active, active panel still exists\n\t\t} else {\n\n\t\t\t// make sure active index is correct\n\t\t\toptions.active = this.headers.index( this.active );\n\t\t}\n\n\t\tthis._destroyIcons();\n\n\t\tthis._refresh();\n\t},\n\n\t_processPanels: function() {\n\t\tvar prevHeaders = this.headers,\n\t\t\tprevPanels = this.panels;\n\n\t\tif ( typeof this.options.header === \"function\" ) {\n\t\t\tthis.headers = this.options.header( this.element );\n\t\t} else {\n\t\t\tthis.headers = this.element.find( this.options.header );\n\t\t}\n\t\tthis._addClass( this.headers, \"ui-accordion-header ui-accordion-header-collapsed\",\n\t\t\t\"ui-state-default\" );\n\n\t\tthis.panels = this.headers.next().filter( \":not(.ui-accordion-content-active)\" ).hide();\n\t\tthis._addClass( this.panels, \"ui-accordion-content\", \"ui-helper-reset ui-widget-content\" );\n\n\t\t// Avoid memory leaks (#10056)\n\t\tif ( prevPanels ) {\n\t\t\tthis._off( prevHeaders.not( this.headers ) );\n\t\t\tthis._off( prevPanels.not( this.panels ) );\n\t\t}\n\t},\n\n\t_refresh: function() {\n\t\tvar maxHeight,\n\t\t\toptions = this.options,\n\t\t\theightStyle = options.heightStyle,\n\t\t\tparent = this.element.parent();\n\n\t\tthis.active = this._findActive( options.active );\n\t\tthis._addClass( this.active, \"ui-accordion-header-active\", \"ui-state-active\" )\n\t\t\t._removeClass( this.active, \"ui-accordion-header-collapsed\" );\n\t\tthis._addClass( this.active.next(), \"ui-accordion-content-active\" );\n\t\tthis.active.next().show();\n\n\t\tthis.headers\n\t\t\t.attr( \"role\", \"tab\" )\n\t\t\t.each( function() {\n\t\t\t\tvar header = $( this ),\n\t\t\t\t\theaderId = header.uniqueId().attr( \"id\" ),\n\t\t\t\t\tpanel = header.next(),\n\t\t\t\t\tpanelId = panel.uniqueId().attr( \"id\" );\n\t\t\t\theader.attr( \"aria-controls\", panelId );\n\t\t\t\tpanel.attr( \"aria-labelledby\", headerId );\n\t\t\t} )\n\t\t\t.next()\n\t\t\t\t.attr( \"role\", \"tabpanel\" );\n\n\t\tthis.headers\n\t\t\t.not( this.active )\n\t\t\t\t.attr( {\n\t\t\t\t\t\"aria-selected\": \"false\",\n\t\t\t\t\t\"aria-expanded\": \"false\",\n\t\t\t\t\ttabIndex: -1\n\t\t\t\t} )\n\t\t\t\t.next()\n\t\t\t\t\t.attr( {\n\t\t\t\t\t\t\"aria-hidden\": \"true\"\n\t\t\t\t\t} )\n\t\t\t\t\t.hide();\n\n\t\t// Make sure at least one header is in the tab order\n\t\tif ( !this.active.length ) {\n\t\t\tthis.headers.eq( 0 ).attr( \"tabIndex\", 0 );\n\t\t} else {\n\t\t\tthis.active.attr( {\n\t\t\t\t\"aria-selected\": \"true\",\n\t\t\t\t\"aria-expanded\": \"true\",\n\t\t\t\ttabIndex: 0\n\t\t\t} )\n\t\t\t\t.next()\n\t\t\t\t\t.attr( {\n\t\t\t\t\t\t\"aria-hidden\": \"false\"\n\t\t\t\t\t} );\n\t\t}\n\n\t\tthis._createIcons();\n\n\t\tthis._setupEvents( options.event );\n\n\t\tif ( heightStyle === \"fill\" ) {\n\t\t\tmaxHeight = parent.height();\n\t\t\tthis.element.siblings( \":visible\" ).each( function() {\n\t\t\t\tvar elem = $( this ),\n\t\t\t\t\tposition = elem.css( \"position\" );\n\n\t\t\t\tif ( position === \"absolute\" || position === \"fixed\" ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tmaxHeight -= elem.outerHeight( true );\n\t\t\t} );\n\n\t\t\tthis.headers.each( function() {\n\t\t\t\tmaxHeight -= $( this ).outerHeight( true );\n\t\t\t} );\n\n\t\t\tthis.headers.next()\n\t\t\t\t.each( function() {\n\t\t\t\t\t$( this ).height( Math.max( 0, maxHeight -\n\t\t\t\t\t\t$( this ).innerHeight() + $( this ).height() ) );\n\t\t\t\t} )\n\t\t\t\t.css( \"overflow\", \"auto\" );\n\t\t} else if ( heightStyle === \"auto\" ) {\n\t\t\tmaxHeight = 0;\n\t\t\tthis.headers.next()\n\t\t\t\t.each( function() {\n\t\t\t\t\tvar isVisible = $( this ).is( \":visible\" );\n\t\t\t\t\tif ( !isVisible ) {\n\t\t\t\t\t\t$( this ).show();\n\t\t\t\t\t}\n\t\t\t\t\tmaxHeight = Math.max( maxHeight, $( this ).css( \"height\", \"\" ).height() );\n\t\t\t\t\tif ( !isVisible ) {\n\t\t\t\t\t\t$( this ).hide();\n\t\t\t\t\t}\n\t\t\t\t} )\n\t\t\t\t.height( maxHeight );\n\t\t}\n\t},\n\n\t_activate: function( index ) {\n\t\tvar active = this._findActive( index )[ 0 ];\n\n\t\t// Trying to activate the already active panel\n\t\tif ( active === this.active[ 0 ] ) {\n\t\t\treturn;\n\t\t}\n\n\t\t// Trying to collapse, simulate a click on the currently active header\n\t\tactive = active || this.active[ 0 ];\n\n\t\tthis._eventHandler( {\n\t\t\ttarget: active,\n\t\t\tcurrentTarget: active,\n\t\t\tpreventDefault: $.noop\n\t\t} );\n\t},\n\n\t_findActive: function( selector ) {\n\t\treturn typeof selector === \"number\" ? this.headers.eq( selector ) : $();\n\t},\n\n\t_setupEvents: function( event ) {\n\t\tvar events = {\n\t\t\tkeydown: \"_keydown\"\n\t\t};\n\t\tif ( event ) {\n\t\t\t$.each( event.split( \" \" ), function( index, eventName ) {\n\t\t\t\tevents[ eventName ] = \"_eventHandler\";\n\t\t\t} );\n\t\t}\n\n\t\tthis._off( this.headers.add( this.headers.next() ) );\n\t\tthis._on( this.headers, events );\n\t\tthis._on( this.headers.next(), { keydown: \"_panelKeyDown\" } );\n\t\tthis._hoverable( this.headers );\n\t\tthis._focusable( this.headers );\n\t},\n\n\t_eventHandler: function( event ) {\n\t\tvar activeChildren, clickedChildren,\n\t\t\toptions = this.options,\n\t\t\tactive = this.active,\n\t\t\tclicked = $( event.currentTarget ),\n\t\t\tclickedIsActive = clicked[ 0 ] === active[ 0 ],\n\t\t\tcollapsing = clickedIsActive && options.collapsible,\n\t\t\ttoShow = collapsing ? $() : clicked.next(),\n\t\t\ttoHide = active.next(),\n\t\t\teventData = {\n\t\t\t\toldHeader: active,\n\t\t\t\toldPanel: toHide,\n\t\t\t\tnewHeader: collapsing ? $() : clicked,\n\t\t\t\tnewPanel: toShow\n\t\t\t};\n\n\t\tevent.preventDefault();\n\n\t\tif (\n\n\t\t\t\t// click on active header, but not collapsible\n\t\t\t\t( clickedIsActive && !options.collapsible ) ||\n\n\t\t\t\t// allow canceling activation\n\t\t\t\t( this._trigger( \"beforeActivate\", event, eventData ) === false ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\toptions.active = collapsing ? false : this.headers.index( clicked );\n\n\t\t// When the call to ._toggle() comes after the class changes\n\t\t// it causes a very odd bug in IE 8 (see #6720)\n\t\tthis.active = clickedIsActive ? $() : clicked;\n\t\tthis._toggle( eventData );\n\n\t\t// Switch classes\n\t\t// corner classes on the previously active header stay after the animation\n\t\tthis._removeClass( active, \"ui-accordion-header-active\", \"ui-state-active\" );\n\t\tif ( options.icons ) {\n\t\t\tactiveChildren = active.children( \".ui-accordion-header-icon\" );\n\t\t\tthis._removeClass( activeChildren, null, options.icons.activeHeader )\n\t\t\t\t._addClass( activeChildren, null, options.icons.header );\n\t\t}\n\n\t\tif ( !clickedIsActive ) {\n\t\t\tthis._removeClass( clicked, \"ui-accordion-header-collapsed\" )\n\t\t\t\t._addClass( clicked, \"ui-accordion-header-active\", \"ui-state-active\" );\n\t\t\tif ( options.icons ) {\n\t\t\t\tclickedChildren = clicked.children( \".ui-accordion-header-icon\" );\n\t\t\t\tthis._removeClass( clickedChildren, null, options.icons.header )\n\t\t\t\t\t._addClass( clickedChildren, null, options.icons.activeHeader );\n\t\t\t}\n\n\t\t\tthis._addClass( clicked.next(), \"ui-accordion-content-active\" );\n\t\t}\n\t},\n\n\t_toggle: function( data ) {\n\t\tvar toShow = data.newPanel,\n\t\t\ttoHide = this.prevShow.length ? this.prevShow : data.oldPanel;\n\n\t\t// Handle activating a panel during the animation for another activation\n\t\tthis.prevShow.add( this.prevHide ).stop( true, true );\n\t\tthis.prevShow = toShow;\n\t\tthis.prevHide = toHide;\n\n\t\tif ( this.options.animate ) {\n\t\t\tthis._animate( toShow, toHide, data );\n\t\t} else {\n\t\t\ttoHide.hide();\n\t\t\ttoShow.show();\n\t\t\tthis._toggleComplete( data );\n\t\t}\n\n\t\ttoHide.attr( {\n\t\t\t\"aria-hidden\": \"true\"\n\t\t} );\n\t\ttoHide.prev().attr( {\n\t\t\t\"aria-selected\": \"false\",\n\t\t\t\"aria-expanded\": \"false\"\n\t\t} );\n\n\t\t// if we're switching panels, remove the old header from the tab order\n\t\t// if we're opening from collapsed state, remove the previous header from the tab order\n\t\t// if we're collapsing, then keep the collapsing header in the tab order\n\t\tif ( toShow.length && toHide.length ) {\n\t\t\ttoHide.prev().attr( {\n\t\t\t\t\"tabIndex\": -1,\n\t\t\t\t\"aria-expanded\": \"false\"\n\t\t\t} );\n\t\t} else if ( toShow.length ) {\n\t\t\tthis.headers.filter( function() {\n\t\t\t\treturn parseInt( $( this ).attr( \"tabIndex\" ), 10 ) === 0;\n\t\t\t} )\n\t\t\t\t.attr( \"tabIndex\", -1 );\n\t\t}\n\n\t\ttoShow\n\t\t\t.attr( \"aria-hidden\", \"false\" )\n\t\t\t.prev()\n\t\t\t\t.attr( {\n\t\t\t\t\t\"aria-selected\": \"true\",\n\t\t\t\t\t\"aria-expanded\": \"true\",\n\t\t\t\t\ttabIndex: 0\n\t\t\t\t} );\n\t},\n\n\t_animate: function( toShow, toHide, data ) {\n\t\tvar total, easing, duration,\n\t\t\tthat = this,\n\t\t\tadjust = 0,\n\t\t\tboxSizing = toShow.css( \"box-sizing\" ),\n\t\t\tdown = toShow.length &&\n\t\t\t\t( !toHide.length || ( toShow.index() < toHide.index() ) ),\n\t\t\tanimate = this.options.animate || {},\n\t\t\toptions = down && animate.down || animate,\n\t\t\tcomplete = function() {\n\t\t\t\tthat._toggleComplete( data );\n\t\t\t};\n\n\t\tif ( typeof options === \"number\" ) {\n\t\t\tduration = options;\n\t\t}\n\t\tif ( typeof options === \"string\" ) {\n\t\t\teasing = options;\n\t\t}\n\n\t\t// fall back from options to animation in case of partial down settings\n\t\teasing = easing || options.easing || animate.easing;\n\t\tduration = duration || options.duration || animate.duration;\n\n\t\tif ( !toHide.length ) {\n\t\t\treturn toShow.animate( this.showProps, duration, easing, complete );\n\t\t}\n\t\tif ( !toShow.length ) {\n\t\t\treturn toHide.animate( this.hideProps, duration, easing, complete );\n\t\t}\n\n\t\ttotal = toShow.show().outerHeight();\n\t\ttoHide.animate( this.hideProps, {\n\t\t\tduration: duration,\n\t\t\teasing: easing,\n\t\t\tstep: function( now, fx ) {\n\t\t\t\tfx.now = Math.round( now );\n\t\t\t}\n\t\t} );\n\t\ttoShow\n\t\t\t.hide()\n\t\t\t.animate( this.showProps, {\n\t\t\t\tduration: duration,\n\t\t\t\teasing: easing,\n\t\t\t\tcomplete: complete,\n\t\t\t\tstep: function( now, fx ) {\n\t\t\t\t\tfx.now = Math.round( now );\n\t\t\t\t\tif ( fx.prop !== \"height\" ) {\n\t\t\t\t\t\tif ( boxSizing === \"content-box\" ) {\n\t\t\t\t\t\t\tadjust += fx.now;\n\t\t\t\t\t\t}\n\t\t\t\t\t} else if ( that.options.heightStyle !== \"content\" ) {\n\t\t\t\t\t\tfx.now = Math.round( total - toHide.outerHeight() - adjust );\n\t\t\t\t\t\tadjust = 0;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} );\n\t},\n\n\t_toggleComplete: function( data ) {\n\t\tvar toHide = data.oldPanel,\n\t\t\tprev = toHide.prev();\n\n\t\tthis._removeClass( toHide, \"ui-accordion-content-active\" );\n\t\tthis._removeClass( prev, \"ui-accordion-header-active\" )\n\t\t\t._addClass( prev, \"ui-accordion-header-collapsed\" );\n\n\t\t// Work around for rendering bug in IE (#5421)\n\t\tif ( toHide.length ) {\n\t\t\ttoHide.parent()[ 0 ].className = toHide.parent()[ 0 ].className;\n\t\t}\n\t\tthis._trigger( \"activate\", null, data );\n\t}\n} );\n\n} );\n","jquery/ui-modules/widgets/autocomplete.js":"/*!\n * jQuery UI Autocomplete 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Autocomplete\n//>>group: Widgets\n//>>description: Lists suggested words as the user is typing.\n//>>docs: http://api.jqueryui.com/autocomplete/\n//>>demos: http://jqueryui.com/autocomplete/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/autocomplete.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"./menu\",\n\t\t\t\"../keycode\",\n\t\t\t\"../position\",\n\t\t\t\"../safe-active-element\",\n\t\t\t\"../version\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n$.widget( \"ui.autocomplete\", {\n\tversion: \"1.13.1\",\n\tdefaultElement: \"<input>\",\n\toptions: {\n\t\tappendTo: null,\n\t\tautoFocus: false,\n\t\tdelay: 300,\n\t\tminLength: 1,\n\t\tposition: {\n\t\t\tmy: \"left top\",\n\t\t\tat: \"left bottom\",\n\t\t\tcollision: \"none\"\n\t\t},\n\t\tsource: null,\n\n\t\t// Callbacks\n\t\tchange: null,\n\t\tclose: null,\n\t\tfocus: null,\n\t\topen: null,\n\t\tresponse: null,\n\t\tsearch: null,\n\t\tselect: null\n\t},\n\n\trequestIndex: 0,\n\tpending: 0,\n\tliveRegionTimer: null,\n\n\t_create: function() {\n\n\t\t// Some browsers only repeat keydown events, not keypress events,\n\t\t// so we use the suppressKeyPress flag to determine if we've already\n\t\t// handled the keydown event. #7269\n\t\t// Unfortunately the code for & in keypress is the same as the up arrow,\n\t\t// so we use the suppressKeyPressRepeat flag to avoid handling keypress\n\t\t// events when we know the keydown event was used to modify the\n\t\t// search term. #7799\n\t\tvar suppressKeyPress, suppressKeyPressRepeat, suppressInput,\n\t\t\tnodeName = this.element[ 0 ].nodeName.toLowerCase(),\n\t\t\tisTextarea = nodeName === \"textarea\",\n\t\t\tisInput = nodeName === \"input\";\n\n\t\t// Textareas are always multi-line\n\t\t// Inputs are always single-line, even if inside a contentEditable element\n\t\t// IE also treats inputs as contentEditable\n\t\t// All other element types are determined by whether or not they're contentEditable\n\t\tthis.isMultiLine = isTextarea || !isInput && this._isContentEditable( this.element );\n\n\t\tthis.valueMethod = this.element[ isTextarea || isInput ? \"val\" : \"text\" ];\n\t\tthis.isNewMenu = true;\n\n\t\tthis._addClass( \"ui-autocomplete-input\" );\n\t\tthis.element.attr( \"autocomplete\", \"off\" );\n\n\t\tthis._on( this.element, {\n\t\t\tkeydown: function( event ) {\n\t\t\t\tif ( this.element.prop( \"readOnly\" ) ) {\n\t\t\t\t\tsuppressKeyPress = true;\n\t\t\t\t\tsuppressInput = true;\n\t\t\t\t\tsuppressKeyPressRepeat = true;\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tsuppressKeyPress = false;\n\t\t\t\tsuppressInput = false;\n\t\t\t\tsuppressKeyPressRepeat = false;\n\t\t\t\tvar keyCode = $.ui.keyCode;\n\t\t\t\tswitch ( event.keyCode ) {\n\t\t\t\tcase keyCode.PAGE_UP:\n\t\t\t\t\tsuppressKeyPress = true;\n\t\t\t\t\tthis._move( \"previousPage\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.PAGE_DOWN:\n\t\t\t\t\tsuppressKeyPress = true;\n\t\t\t\t\tthis._move( \"nextPage\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.UP:\n\t\t\t\t\tsuppressKeyPress = true;\n\t\t\t\t\tthis._keyEvent( \"previous\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.DOWN:\n\t\t\t\t\tsuppressKeyPress = true;\n\t\t\t\t\tthis._keyEvent( \"next\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.ENTER:\n\n\t\t\t\t\t// when menu is open and has focus\n\t\t\t\t\tif ( this.menu.active ) {\n\n\t\t\t\t\t\t// #6055 - Opera still allows the keypress to occur\n\t\t\t\t\t\t// which causes forms to submit\n\t\t\t\t\t\tsuppressKeyPress = true;\n\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t\tthis.menu.select( event );\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.TAB:\n\t\t\t\t\tif ( this.menu.active ) {\n\t\t\t\t\t\tthis.menu.select( event );\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.ESCAPE:\n\t\t\t\t\tif ( this.menu.element.is( \":visible\" ) ) {\n\t\t\t\t\t\tif ( !this.isMultiLine ) {\n\t\t\t\t\t\t\tthis._value( this.term );\n\t\t\t\t\t\t}\n\t\t\t\t\t\tthis.close( event );\n\n\t\t\t\t\t\t// Different browsers have different default behavior for escape\n\t\t\t\t\t\t// Single press can mean undo or clear\n\t\t\t\t\t\t// Double press in IE means clear the whole form\n\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t\tbreak;\n\t\t\t\tdefault:\n\t\t\t\t\tsuppressKeyPressRepeat = true;\n\n\t\t\t\t\t// search timeout should be triggered before the input value is changed\n\t\t\t\t\tthis._searchTimeout( event );\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t},\n\t\t\tkeypress: function( event ) {\n\t\t\t\tif ( suppressKeyPress ) {\n\t\t\t\t\tsuppressKeyPress = false;\n\t\t\t\t\tif ( !this.isMultiLine || this.menu.element.is( \":visible\" ) ) {\n\t\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\t}\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tif ( suppressKeyPressRepeat ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// Replicate some key handlers to allow them to repeat in Firefox and Opera\n\t\t\t\tvar keyCode = $.ui.keyCode;\n\t\t\t\tswitch ( event.keyCode ) {\n\t\t\t\tcase keyCode.PAGE_UP:\n\t\t\t\t\tthis._move( \"previousPage\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.PAGE_DOWN:\n\t\t\t\t\tthis._move( \"nextPage\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.UP:\n\t\t\t\t\tthis._keyEvent( \"previous\", event );\n\t\t\t\t\tbreak;\n\t\t\t\tcase keyCode.DOWN:\n\t\t\t\t\tthis._keyEvent( \"next\", event );\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t},\n\t\t\tinput: function( event ) {\n\t\t\t\tif ( suppressInput ) {\n\t\t\t\t\tsuppressInput = false;\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tthis._searchTimeout( event );\n\t\t\t},\n\t\t\tfocus: function() {\n\t\t\t\tthis.selectedItem = null;\n\t\t\t\tthis.previous = this._value();\n\t\t\t},\n\t\t\tblur: function( event ) {\n\t\t\t\tclearTimeout( this.searching );\n\t\t\t\tthis.close( event );\n\t\t\t\tthis._change( event );\n\t\t\t}\n\t\t} );\n\n\t\tthis._initSource();\n\t\tthis.menu = $( \"<ul>\" )\n\t\t\t.appendTo( this._appendTo() )\n\t\t\t.menu( {\n\n\t\t\t\t// disable ARIA support, the live region takes care of that\n\t\t\t\trole: null\n\t\t\t} )\n\t\t\t.hide()\n\n\t\t\t// Support: IE 11 only, Edge <= 14\n\t\t\t// For other browsers, we preventDefault() on the mousedown event\n\t\t\t// to keep the dropdown from taking focus from the input. This doesn't\n\t\t\t// work for IE/Edge, causing problems with selection and scrolling (#9638)\n\t\t\t// Happily, IE and Edge support an \"unselectable\" attribute that\n\t\t\t// prevents an element from receiving focus, exactly what we want here.\n\t\t\t.attr( {\n\t\t\t\t\"unselectable\": \"on\"\n\t\t\t} )\n\t\t\t.menu( \"instance\" );\n\n\t\tthis._addClass( this.menu.element, \"ui-autocomplete\", \"ui-front\" );\n\t\tthis._on( this.menu.element, {\n\t\t\tmousedown: function( event ) {\n\n\t\t\t\t// Prevent moving focus out of the text field\n\t\t\t\tevent.preventDefault();\n\t\t\t},\n\t\t\tmenufocus: function( event, ui ) {\n\t\t\t\tvar label, item;\n\n\t\t\t\t// support: Firefox\n\t\t\t\t// Prevent accidental activation of menu items in Firefox (#7024 #9118)\n\t\t\t\tif ( this.isNewMenu ) {\n\t\t\t\t\tthis.isNewMenu = false;\n\t\t\t\t\tif ( event.originalEvent && /^mouse/.test( event.originalEvent.type ) ) {\n\t\t\t\t\t\tthis.menu.blur();\n\n\t\t\t\t\t\tthis.document.one( \"mousemove\", function() {\n\t\t\t\t\t\t\t$( event.target ).trigger( event.originalEvent );\n\t\t\t\t\t\t} );\n\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\titem = ui.item.data( \"ui-autocomplete-item\" );\n\t\t\t\tif ( false !== this._trigger( \"focus\", event, { item: item } ) ) {\n\n\t\t\t\t\t// use value to match what will end up in the input, if it was a key event\n\t\t\t\t\tif ( event.originalEvent && /^key/.test( event.originalEvent.type ) ) {\n\t\t\t\t\t\tthis._value( item.value );\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\t// Announce the value in the liveRegion\n\t\t\t\tlabel = ui.item.attr( \"aria-label\" ) || item.value;\n\t\t\t\tif ( label && String.prototype.trim.call( label ).length ) {\n\t\t\t\t\tclearTimeout( this.liveRegionTimer );\n\t\t\t\t\tthis.liveRegionTimer = this._delay( function() {\n\t\t\t\t\t\tthis.liveRegion.html( $( \"<div>\" ).text( label ) );\n\t\t\t\t\t}, 100 );\n\t\t\t\t}\n\t\t\t},\n\t\t\tmenuselect: function( event, ui ) {\n\t\t\t\tvar item = ui.item.data( \"ui-autocomplete-item\" ),\n\t\t\t\t\tprevious = this.previous;\n\n\t\t\t\t// Only trigger when focus was lost (click on menu)\n\t\t\t\tif ( this.element[ 0 ] !== $.ui.safeActiveElement( this.document[ 0 ] ) ) {\n\t\t\t\t\tthis.element.trigger( \"focus\" );\n\t\t\t\t\tthis.previous = previous;\n\n\t\t\t\t\t// #6109 - IE triggers two focus events and the second\n\t\t\t\t\t// is asynchronous, so we need to reset the previous\n\t\t\t\t\t// term synchronously and asynchronously :-(\n\t\t\t\t\tthis._delay( function() {\n\t\t\t\t\t\tthis.previous = previous;\n\t\t\t\t\t\tthis.selectedItem = item;\n\t\t\t\t\t} );\n\t\t\t\t}\n\n\t\t\t\tif ( false !== this._trigger( \"select\", event, { item: item } ) ) {\n\t\t\t\t\tthis._value( item.value );\n\t\t\t\t}\n\n\t\t\t\t// reset the term after the select event\n\t\t\t\t// this allows custom select handling to work properly\n\t\t\t\tthis.term = this._value();\n\n\t\t\t\tthis.close( event );\n\t\t\t\tthis.selectedItem = item;\n\t\t\t}\n\t\t} );\n\n\t\tthis.liveRegion = $( \"<div>\", {\n\t\t\trole: \"status\",\n\t\t\t\"aria-live\": \"assertive\",\n\t\t\t\"aria-relevant\": \"additions\"\n\t\t} )\n\t\t\t.appendTo( this.document[ 0 ].body );\n\n\t\tthis._addClass( this.liveRegion, null, \"ui-helper-hidden-accessible\" );\n\n\t\t// Turning off autocomplete prevents the browser from remembering the\n\t\t// value when navigating through history, so we re-enable autocomplete\n\t\t// if the page is unloaded before the widget is destroyed. #7790\n\t\tthis._on( this.window, {\n\t\t\tbeforeunload: function() {\n\t\t\t\tthis.element.removeAttr( \"autocomplete\" );\n\t\t\t}\n\t\t} );\n\t},\n\n\t_destroy: function() {\n\t\tclearTimeout( this.searching );\n\t\tthis.element.removeAttr( \"autocomplete\" );\n\t\tthis.menu.element.remove();\n\t\tthis.liveRegion.remove();\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tthis._super( key, value );\n\t\tif ( key === \"source\" ) {\n\t\t\tthis._initSource();\n\t\t}\n\t\tif ( key === \"appendTo\" ) {\n\t\t\tthis.menu.element.appendTo( this._appendTo() );\n\t\t}\n\t\tif ( key === \"disabled\" && value && this.xhr ) {\n\t\t\tthis.xhr.abort();\n\t\t}\n\t},\n\n\t_isEventTargetInWidget: function( event ) {\n\t\tvar menuElement = this.menu.element[ 0 ];\n\n\t\treturn event.target === this.element[ 0 ] ||\n\t\t\tevent.target === menuElement ||\n\t\t\t$.contains( menuElement, event.target );\n\t},\n\n\t_closeOnClickOutside: function( event ) {\n\t\tif ( !this._isEventTargetInWidget( event ) ) {\n\t\t\tthis.close();\n\t\t}\n\t},\n\n\t_appendTo: function() {\n\t\tvar element = this.options.appendTo;\n\n\t\tif ( element ) {\n\t\t\telement = element.jquery || element.nodeType ?\n\t\t\t\t$( element ) :\n\t\t\t\tthis.document.find( element ).eq( 0 );\n\t\t}\n\n\t\tif ( !element || !element[ 0 ] ) {\n\t\t\telement = this.element.closest( \".ui-front, dialog\" );\n\t\t}\n\n\t\tif ( !element.length ) {\n\t\t\telement = this.document[ 0 ].body;\n\t\t}\n\n\t\treturn element;\n\t},\n\n\t_initSource: function() {\n\t\tvar array, url,\n\t\t\tthat = this;\n\t\tif ( Array.isArray( this.options.source ) ) {\n\t\t\tarray = this.options.source;\n\t\t\tthis.source = function( request, response ) {\n\t\t\t\tresponse( $.ui.autocomplete.filter( array, request.term ) );\n\t\t\t};\n\t\t} else if ( typeof this.options.source === \"string\" ) {\n\t\t\turl = this.options.source;\n\t\t\tthis.source = function( request, response ) {\n\t\t\t\tif ( that.xhr ) {\n\t\t\t\t\tthat.xhr.abort();\n\t\t\t\t}\n\t\t\t\tthat.xhr = $.ajax( {\n\t\t\t\t\turl: url,\n\t\t\t\t\tdata: request,\n\t\t\t\t\tdataType: \"json\",\n\t\t\t\t\tsuccess: function( data ) {\n\t\t\t\t\t\tresponse( data );\n\t\t\t\t\t},\n\t\t\t\t\terror: function() {\n\t\t\t\t\t\tresponse( [] );\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t};\n\t\t} else {\n\t\t\tthis.source = this.options.source;\n\t\t}\n\t},\n\n\t_searchTimeout: function( event ) {\n\t\tclearTimeout( this.searching );\n\t\tthis.searching = this._delay( function() {\n\n\t\t\t// Search if the value has changed, or if the user retypes the same value (see #7434)\n\t\t\tvar equalValues = this.term === this._value(),\n\t\t\t\tmenuVisible = this.menu.element.is( \":visible\" ),\n\t\t\t\tmodifierKey = event.altKey || event.ctrlKey || event.metaKey || event.shiftKey;\n\n\t\t\tif ( !equalValues || ( equalValues && !menuVisible && !modifierKey ) ) {\n\t\t\t\tthis.selectedItem = null;\n\t\t\t\tthis.search( null, event );\n\t\t\t}\n\t\t}, this.options.delay );\n\t},\n\n\tsearch: function( value, event ) {\n\t\tvalue = value != null ? value : this._value();\n\n\t\t// Always save the actual value, not the one passed as an argument\n\t\tthis.term = this._value();\n\n\t\tif ( value.length < this.options.minLength ) {\n\t\t\treturn this.close( event );\n\t\t}\n\n\t\tif ( this._trigger( \"search\", event ) === false ) {\n\t\t\treturn;\n\t\t}\n\n\t\treturn this._search( value );\n\t},\n\n\t_search: function( value ) {\n\t\tthis.pending++;\n\t\tthis._addClass( \"ui-autocomplete-loading\" );\n\t\tthis.cancelSearch = false;\n\n\t\tthis.source( { term: value }, this._response() );\n\t},\n\n\t_response: function() {\n\t\tvar index = ++this.requestIndex;\n\n\t\treturn function( content ) {\n\t\t\tif ( index === this.requestIndex ) {\n\t\t\t\tthis.__response( content );\n\t\t\t}\n\n\t\t\tthis.pending--;\n\t\t\tif ( !this.pending ) {\n\t\t\t\tthis._removeClass( \"ui-autocomplete-loading\" );\n\t\t\t}\n\t\t}.bind( this );\n\t},\n\n\t__response: function( content ) {\n\t\tif ( content ) {\n\t\t\tcontent = this._normalize( content );\n\t\t}\n\t\tthis._trigger( \"response\", null, { content: content } );\n\t\tif ( !this.options.disabled && content && content.length && !this.cancelSearch ) {\n\t\t\tthis._suggest( content );\n\t\t\tthis._trigger( \"open\" );\n\t\t} else {\n\n\t\t\t// use ._close() instead of .close() so we don't cancel future searches\n\t\t\tthis._close();\n\t\t}\n\t},\n\n\tclose: function( event ) {\n\t\tthis.cancelSearch = true;\n\t\tthis._close( event );\n\t},\n\n\t_close: function( event ) {\n\n\t\t// Remove the handler that closes the menu on outside clicks\n\t\tthis._off( this.document, \"mousedown\" );\n\n\t\tif ( this.menu.element.is( \":visible\" ) ) {\n\t\t\tthis.menu.element.hide();\n\t\t\tthis.menu.blur();\n\t\t\tthis.isNewMenu = true;\n\t\t\tthis._trigger( \"close\", event );\n\t\t}\n\t},\n\n\t_change: function( event ) {\n\t\tif ( this.previous !== this._value() ) {\n\t\t\tthis._trigger( \"change\", event, { item: this.selectedItem } );\n\t\t}\n\t},\n\n\t_normalize: function( items ) {\n\n\t\t// assume all items have the right format when the first item is complete\n\t\tif ( items.length && items[ 0 ].label && items[ 0 ].value ) {\n\t\t\treturn items;\n\t\t}\n\t\treturn $.map( items, function( item ) {\n\t\t\tif ( typeof item === \"string\" ) {\n\t\t\t\treturn {\n\t\t\t\t\tlabel: item,\n\t\t\t\t\tvalue: item\n\t\t\t\t};\n\t\t\t}\n\t\t\treturn $.extend( {}, item, {\n\t\t\t\tlabel: item.label || item.value,\n\t\t\t\tvalue: item.value || item.label\n\t\t\t} );\n\t\t} );\n\t},\n\n\t_suggest: function( items ) {\n\t\tvar ul = this.menu.element.empty();\n\t\tthis._renderMenu( ul, items );\n\t\tthis.isNewMenu = true;\n\t\tthis.menu.refresh();\n\n\t\t// Size and position menu\n\t\tul.show();\n\t\tthis._resizeMenu();\n\t\tul.position( $.extend( {\n\t\t\tof: this.element\n\t\t}, this.options.position ) );\n\n\t\tif ( this.options.autoFocus ) {\n\t\t\tthis.menu.next();\n\t\t}\n\n\t\t// Listen for interactions outside of the widget (#6642)\n\t\tthis._on( this.document, {\n\t\t\tmousedown: \"_closeOnClickOutside\"\n\t\t} );\n\t},\n\n\t_resizeMenu: function() {\n\t\tvar ul = this.menu.element;\n\t\tul.outerWidth( Math.max(\n\n\t\t\t// Firefox wraps long text (possibly a rounding bug)\n\t\t\t// so we add 1px to avoid the wrapping (#7513)\n\t\t\tul.width( \"\" ).outerWidth() + 1,\n\t\t\tthis.element.outerWidth()\n\t\t) );\n\t},\n\n\t_renderMenu: function( ul, items ) {\n\t\tvar that = this;\n\t\t$.each( items, function( index, item ) {\n\t\t\tthat._renderItemData( ul, item );\n\t\t} );\n\t},\n\n\t_renderItemData: function( ul, item ) {\n\t\treturn this._renderItem( ul, item ).data( \"ui-autocomplete-item\", item );\n\t},\n\n\t_renderItem: function( ul, item ) {\n\t\treturn $( \"<li>\" )\n\t\t\t.append( $( \"<div>\" ).text( item.label ) )\n\t\t\t.appendTo( ul );\n\t},\n\n\t_move: function( direction, event ) {\n\t\tif ( !this.menu.element.is( \":visible\" ) ) {\n\t\t\tthis.search( null, event );\n\t\t\treturn;\n\t\t}\n\t\tif ( this.menu.isFirstItem() && /^previous/.test( direction ) ||\n\t\t\t\tthis.menu.isLastItem() && /^next/.test( direction ) ) {\n\n\t\t\tif ( !this.isMultiLine ) {\n\t\t\t\tthis._value( this.term );\n\t\t\t}\n\n\t\t\tthis.menu.blur();\n\t\t\treturn;\n\t\t}\n\t\tthis.menu[ direction ]( event );\n\t},\n\n\twidget: function() {\n\t\treturn this.menu.element;\n\t},\n\n\t_value: function() {\n\t\treturn this.valueMethod.apply( this.element, arguments );\n\t},\n\n\t_keyEvent: function( keyEvent, event ) {\n\t\tif ( !this.isMultiLine || this.menu.element.is( \":visible\" ) ) {\n\t\t\tthis._move( keyEvent, event );\n\n\t\t\t// Prevents moving cursor to beginning/end of the text field in some browsers\n\t\t\tevent.preventDefault();\n\t\t}\n\t},\n\n\t// Support: Chrome <=50\n\t// We should be able to just use this.element.prop( \"isContentEditable\" )\n\t// but hidden elements always report false in Chrome.\n\t// https://code.google.com/p/chromium/issues/detail?id=313082\n\t_isContentEditable: function( element ) {\n\t\tif ( !element.length ) {\n\t\t\treturn false;\n\t\t}\n\n\t\tvar editable = element.prop( \"contentEditable\" );\n\n\t\tif ( editable === \"inherit\" ) {\n\t\t\treturn this._isContentEditable( element.parent() );\n\t\t}\n\n\t\treturn editable === \"true\";\n\t}\n} );\n\n$.extend( $.ui.autocomplete, {\n\tescapeRegex: function( value ) {\n\t\treturn value.replace( /[\\-\\[\\]{}()*+?.,\\\\\\^$|#\\s]/g, \"\\\\$&\" );\n\t},\n\tfilter: function( array, term ) {\n\t\tvar matcher = new RegExp( $.ui.autocomplete.escapeRegex( term ), \"i\" );\n\t\treturn $.grep( array, function( value ) {\n\t\t\treturn matcher.test( value.label || value.value || value );\n\t\t} );\n\t}\n} );\n\n// Live region extension, adding a `messages` option\n// NOTE: This is an experimental API. We are still investigating\n// a full solution for string manipulation and internationalization.\n$.widget( \"ui.autocomplete\", $.ui.autocomplete, {\n\toptions: {\n\t\tmessages: {\n\t\t\tnoResults: \"No search results.\",\n\t\t\tresults: function( amount ) {\n\t\t\t\treturn amount + ( amount > 1 ? \" results are\" : \" result is\" ) +\n\t\t\t\t\t\" available, use up and down arrow keys to navigate.\";\n\t\t\t}\n\t\t}\n\t},\n\n\t__response: function( content ) {\n\t\tvar message;\n\t\tthis._superApply( arguments );\n\t\tif ( this.options.disabled || this.cancelSearch ) {\n\t\t\treturn;\n\t\t}\n\t\tif ( content && content.length ) {\n\t\t\tmessage = this.options.messages.results( content.length );\n\t\t} else {\n\t\t\tmessage = this.options.messages.noResults;\n\t\t}\n\t\tclearTimeout( this.liveRegionTimer );\n\t\tthis.liveRegionTimer = this._delay( function() {\n\t\t\tthis.liveRegion.html( $( \"<div>\" ).text( message ) );\n\t\t}, 100 );\n\t}\n} );\n\nreturn $.ui.autocomplete;\n\n} );\n","jquery/ui-modules/widgets/button.js":"/*!\n * jQuery UI Button 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Button\n//>>group: Widgets\n//>>description: Enhances a form with themeable buttons.\n//>>docs: http://api.jqueryui.com/button/\n//>>demos: http://jqueryui.com/button/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/button.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\n\t\t\t// These are only for backcompat\n\t\t\t// TODO: Remove after 1.12\n\t\t\t\"./controlgroup\",\n\t\t\t\"./checkboxradio\",\n\n\t\t\t\"../keycode\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n$.widget( \"ui.button\", {\n\tversion: \"1.13.1\",\n\tdefaultElement: \"<button>\",\n\toptions: {\n\t\tclasses: {\n\t\t\t\"ui-button\": \"ui-corner-all\"\n\t\t},\n\t\tdisabled: null,\n\t\ticon: null,\n\t\ticonPosition: \"beginning\",\n\t\tlabel: null,\n\t\tshowLabel: true\n\t},\n\n\t_getCreateOptions: function() {\n\t\tvar disabled,\n\n\t\t\t// This is to support cases like in jQuery Mobile where the base widget does have\n\t\t\t// an implementation of _getCreateOptions\n\t\t\toptions = this._super() || {};\n\n\t\tthis.isInput = this.element.is( \"input\" );\n\n\t\tdisabled = this.element[ 0 ].disabled;\n\t\tif ( disabled != null ) {\n\t\t\toptions.disabled = disabled;\n\t\t}\n\n\t\tthis.originalLabel = this.isInput ? this.element.val() : this.element.html();\n\t\tif ( this.originalLabel ) {\n\t\t\toptions.label = this.originalLabel;\n\t\t}\n\n\t\treturn options;\n\t},\n\n\t_create: function() {\n\t\tif ( !this.option.showLabel & !this.options.icon ) {\n\t\t\tthis.options.showLabel = true;\n\t\t}\n\n\t\t// We have to check the option again here even though we did in _getCreateOptions,\n\t\t// because null may have been passed on init which would override what was set in\n\t\t// _getCreateOptions\n\t\tif ( this.options.disabled == null ) {\n\t\t\tthis.options.disabled = this.element[ 0 ].disabled || false;\n\t\t}\n\n\t\tthis.hasTitle = !!this.element.attr( \"title\" );\n\n\t\t// Check to see if the label needs to be set or if its already correct\n\t\tif ( this.options.label && this.options.label !== this.originalLabel ) {\n\t\t\tif ( this.isInput ) {\n\t\t\t\tthis.element.val( this.options.label );\n\t\t\t} else {\n\t\t\t\tthis.element.html( this.options.label );\n\t\t\t}\n\t\t}\n\t\tthis._addClass( \"ui-button\", \"ui-widget\" );\n\t\tthis._setOption( \"disabled\", this.options.disabled );\n\t\tthis._enhance();\n\n\t\tif ( this.element.is( \"a\" ) ) {\n\t\t\tthis._on( {\n\t\t\t\t\"keyup\": function( event ) {\n\t\t\t\t\tif ( event.keyCode === $.ui.keyCode.SPACE ) {\n\t\t\t\t\t\tevent.preventDefault();\n\n\t\t\t\t\t\t// Support: PhantomJS <= 1.9, IE 8 Only\n\t\t\t\t\t\t// If a native click is available use it so we actually cause navigation\n\t\t\t\t\t\t// otherwise just trigger a click event\n\t\t\t\t\t\tif ( this.element[ 0 ].click ) {\n\t\t\t\t\t\t\tthis.element[ 0 ].click();\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tthis.element.trigger( \"click\" );\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t} );\n\t\t}\n\t},\n\n\t_enhance: function() {\n\t\tif ( !this.element.is( \"button\" ) ) {\n\t\t\tthis.element.attr( \"role\", \"button\" );\n\t\t}\n\n\t\tif ( this.options.icon ) {\n\t\t\tthis._updateIcon( \"icon\", this.options.icon );\n\t\t\tthis._updateTooltip();\n\t\t}\n\t},\n\n\t_updateTooltip: function() {\n\t\tthis.title = this.element.attr( \"title\" );\n\n\t\tif ( !this.options.showLabel && !this.title ) {\n\t\t\tthis.element.attr( \"title\", this.options.label );\n\t\t}\n\t},\n\n\t_updateIcon: function( option, value ) {\n\t\tvar icon = option !== \"iconPosition\",\n\t\t\tposition = icon ? this.options.iconPosition : value,\n\t\t\tdisplayBlock = position === \"top\" || position === \"bottom\";\n\n\t\t// Create icon\n\t\tif ( !this.icon ) {\n\t\t\tthis.icon = $( \"<span>\" );\n\n\t\t\tthis._addClass( this.icon, \"ui-button-icon\", \"ui-icon\" );\n\n\t\t\tif ( !this.options.showLabel ) {\n\t\t\t\tthis._addClass( \"ui-button-icon-only\" );\n\t\t\t}\n\t\t} else if ( icon ) {\n\n\t\t\t// If we are updating the icon remove the old icon class\n\t\t\tthis._removeClass( this.icon, null, this.options.icon );\n\t\t}\n\n\t\t// If we are updating the icon add the new icon class\n\t\tif ( icon ) {\n\t\t\tthis._addClass( this.icon, null, value );\n\t\t}\n\n\t\tthis._attachIcon( position );\n\n\t\t// If the icon is on top or bottom we need to add the ui-widget-icon-block class and remove\n\t\t// the iconSpace if there is one.\n\t\tif ( displayBlock ) {\n\t\t\tthis._addClass( this.icon, null, \"ui-widget-icon-block\" );\n\t\t\tif ( this.iconSpace ) {\n\t\t\t\tthis.iconSpace.remove();\n\t\t\t}\n\t\t} else {\n\n\t\t\t// Position is beginning or end so remove the ui-widget-icon-block class and add the\n\t\t\t// space if it does not exist\n\t\t\tif ( !this.iconSpace ) {\n\t\t\t\tthis.iconSpace = $( \"<span> </span>\" );\n\t\t\t\tthis._addClass( this.iconSpace, \"ui-button-icon-space\" );\n\t\t\t}\n\t\t\tthis._removeClass( this.icon, null, \"ui-wiget-icon-block\" );\n\t\t\tthis._attachIconSpace( position );\n\t\t}\n\t},\n\n\t_destroy: function() {\n\t\tthis.element.removeAttr( \"role\" );\n\n\t\tif ( this.icon ) {\n\t\t\tthis.icon.remove();\n\t\t}\n\t\tif ( this.iconSpace ) {\n\t\t\tthis.iconSpace.remove();\n\t\t}\n\t\tif ( !this.hasTitle ) {\n\t\t\tthis.element.removeAttr( \"title\" );\n\t\t}\n\t},\n\n\t_attachIconSpace: function( iconPosition ) {\n\t\tthis.icon[ /^(?:end|bottom)/.test( iconPosition ) ? \"before\" : \"after\" ]( this.iconSpace );\n\t},\n\n\t_attachIcon: function( iconPosition ) {\n\t\tthis.element[ /^(?:end|bottom)/.test( iconPosition ) ? \"append\" : \"prepend\" ]( this.icon );\n\t},\n\n\t_setOptions: function( options ) {\n\t\tvar newShowLabel = options.showLabel === undefined ?\n\t\t\t\tthis.options.showLabel :\n\t\t\t\toptions.showLabel,\n\t\t\tnewIcon = options.icon === undefined ? this.options.icon : options.icon;\n\n\t\tif ( !newShowLabel && !newIcon ) {\n\t\t\toptions.showLabel = true;\n\t\t}\n\t\tthis._super( options );\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tif ( key === \"icon\" ) {\n\t\t\tif ( value ) {\n\t\t\t\tthis._updateIcon( key, value );\n\t\t\t} else if ( this.icon ) {\n\t\t\t\tthis.icon.remove();\n\t\t\t\tif ( this.iconSpace ) {\n\t\t\t\t\tthis.iconSpace.remove();\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tif ( key === \"iconPosition\" ) {\n\t\t\tthis._updateIcon( key, value );\n\t\t}\n\n\t\t// Make sure we can't end up with a button that has neither text nor icon\n\t\tif ( key === \"showLabel\" ) {\n\t\t\t\tthis._toggleClass( \"ui-button-icon-only\", null, !value );\n\t\t\t\tthis._updateTooltip();\n\t\t}\n\n\t\tif ( key === \"label\" ) {\n\t\t\tif ( this.isInput ) {\n\t\t\t\tthis.element.val( value );\n\t\t\t} else {\n\n\t\t\t\t// If there is an icon, append it, else nothing then append the value\n\t\t\t\t// this avoids removal of the icon when setting label text\n\t\t\t\tthis.element.html( value );\n\t\t\t\tif ( this.icon ) {\n\t\t\t\t\tthis._attachIcon( this.options.iconPosition );\n\t\t\t\t\tthis._attachIconSpace( this.options.iconPosition );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tthis._super( key, value );\n\n\t\tif ( key === \"disabled\" ) {\n\t\t\tthis._toggleClass( null, \"ui-state-disabled\", value );\n\t\t\tthis.element[ 0 ].disabled = value;\n\t\t\tif ( value ) {\n\t\t\t\tthis.element.trigger( \"blur\" );\n\t\t\t}\n\t\t}\n\t},\n\n\trefresh: function() {\n\n\t\t// Make sure to only check disabled if its an element that supports this otherwise\n\t\t// check for the disabled class to determine state\n\t\tvar isDisabled = this.element.is( \"input, button\" ) ?\n\t\t\tthis.element[ 0 ].disabled : this.element.hasClass( \"ui-button-disabled\" );\n\n\t\tif ( isDisabled !== this.options.disabled ) {\n\t\t\tthis._setOptions( { disabled: isDisabled } );\n\t\t}\n\n\t\tthis._updateTooltip();\n\t}\n} );\n\n// DEPRECATED\nif ( $.uiBackCompat !== false ) {\n\n\t// Text and Icons options\n\t$.widget( \"ui.button\", $.ui.button, {\n\t\toptions: {\n\t\t\ttext: true,\n\t\t\ticons: {\n\t\t\t\tprimary: null,\n\t\t\t\tsecondary: null\n\t\t\t}\n\t\t},\n\n\t\t_create: function() {\n\t\t\tif ( this.options.showLabel && !this.options.text ) {\n\t\t\t\tthis.options.showLabel = this.options.text;\n\t\t\t}\n\t\t\tif ( !this.options.showLabel && this.options.text ) {\n\t\t\t\tthis.options.text = this.options.showLabel;\n\t\t\t}\n\t\t\tif ( !this.options.icon && ( this.options.icons.primary ||\n\t\t\t\t\tthis.options.icons.secondary ) ) {\n\t\t\t\tif ( this.options.icons.primary ) {\n\t\t\t\t\tthis.options.icon = this.options.icons.primary;\n\t\t\t\t} else {\n\t\t\t\t\tthis.options.icon = this.options.icons.secondary;\n\t\t\t\t\tthis.options.iconPosition = \"end\";\n\t\t\t\t}\n\t\t\t} else if ( this.options.icon ) {\n\t\t\t\tthis.options.icons.primary = this.options.icon;\n\t\t\t}\n\t\t\tthis._super();\n\t\t},\n\n\t\t_setOption: function( key, value ) {\n\t\t\tif ( key === \"text\" ) {\n\t\t\t\tthis._super( \"showLabel\", value );\n\t\t\t\treturn;\n\t\t\t}\n\t\t\tif ( key === \"showLabel\" ) {\n\t\t\t\tthis.options.text = value;\n\t\t\t}\n\t\t\tif ( key === \"icon\" ) {\n\t\t\t\tthis.options.icons.primary = value;\n\t\t\t}\n\t\t\tif ( key === \"icons\" ) {\n\t\t\t\tif ( value.primary ) {\n\t\t\t\t\tthis._super( \"icon\", value.primary );\n\t\t\t\t\tthis._super( \"iconPosition\", \"beginning\" );\n\t\t\t\t} else if ( value.secondary ) {\n\t\t\t\t\tthis._super( \"icon\", value.secondary );\n\t\t\t\t\tthis._super( \"iconPosition\", \"end\" );\n\t\t\t\t}\n\t\t\t}\n\t\t\tthis._superApply( arguments );\n\t\t}\n\t} );\n\n\t$.fn.button = ( function( orig ) {\n\t\treturn function( options ) {\n\t\t\tvar isMethodCall = typeof options === \"string\";\n\t\t\tvar args = Array.prototype.slice.call( arguments, 1 );\n\t\t\tvar returnValue = this;\n\n\t\t\tif ( isMethodCall ) {\n\n\t\t\t\t// If this is an empty collection, we need to have the instance method\n\t\t\t\t// return undefined instead of the jQuery instance\n\t\t\t\tif ( !this.length && options === \"instance\" ) {\n\t\t\t\t\treturnValue = undefined;\n\t\t\t\t} else {\n\t\t\t\t\tthis.each( function() {\n\t\t\t\t\t\tvar methodValue;\n\t\t\t\t\t\tvar type = $( this ).attr( \"type\" );\n\t\t\t\t\t\tvar name = type !== \"checkbox\" && type !== \"radio\" ?\n\t\t\t\t\t\t\t\"button\" :\n\t\t\t\t\t\t\t\"checkboxradio\";\n\t\t\t\t\t\tvar instance = $.data( this, \"ui-\" + name );\n\n\t\t\t\t\t\tif ( options === \"instance\" ) {\n\t\t\t\t\t\t\treturnValue = instance;\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif ( !instance ) {\n\t\t\t\t\t\t\treturn $.error( \"cannot call methods on button\" +\n\t\t\t\t\t\t\t\t\" prior to initialization; \" +\n\t\t\t\t\t\t\t\t\"attempted to call method '\" + options + \"'\" );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif ( typeof instance[ options ] !== \"function\" ||\n\t\t\t\t\t\t\toptions.charAt( 0 ) === \"_\" ) {\n\t\t\t\t\t\t\treturn $.error( \"no such method '\" + options + \"' for button\" +\n\t\t\t\t\t\t\t\t\" widget instance\" );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tmethodValue = instance[ options ].apply( instance, args );\n\n\t\t\t\t\t\tif ( methodValue !== instance && methodValue !== undefined ) {\n\t\t\t\t\t\t\treturnValue = methodValue && methodValue.jquery ?\n\t\t\t\t\t\t\t\treturnValue.pushStack( methodValue.get() ) :\n\t\t\t\t\t\t\t\tmethodValue;\n\t\t\t\t\t\t\treturn false;\n\t\t\t\t\t\t}\n\t\t\t\t\t} );\n\t\t\t\t}\n\t\t\t} else {\n\n\t\t\t\t// Allow multiple hashes to be passed on init\n\t\t\t\tif ( args.length ) {\n\t\t\t\t\toptions = $.widget.extend.apply( null, [ options ].concat( args ) );\n\t\t\t\t}\n\n\t\t\t\tthis.each( function() {\n\t\t\t\t\tvar type = $( this ).attr( \"type\" );\n\t\t\t\t\tvar name = type !== \"checkbox\" && type !== \"radio\" ? \"button\" : \"checkboxradio\";\n\t\t\t\t\tvar instance = $.data( this, \"ui-\" + name );\n\n\t\t\t\t\tif ( instance ) {\n\t\t\t\t\t\tinstance.option( options || {} );\n\t\t\t\t\t\tif ( instance._init ) {\n\t\t\t\t\t\t\tinstance._init();\n\t\t\t\t\t\t}\n\t\t\t\t\t} else {\n\t\t\t\t\t\tif ( name === \"button\" ) {\n\t\t\t\t\t\t\torig.call( $( this ), options );\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t$( this ).checkboxradio( $.extend( { icon: false }, options ) );\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\treturn returnValue;\n\t\t};\n\t} )( $.fn.button );\n\n\t$.fn.buttonset = function() {\n\t\tif ( !$.ui.controlgroup ) {\n\t\t\t$.error( \"Controlgroup widget missing\" );\n\t\t}\n\t\tif ( arguments[ 0 ] === \"option\" && arguments[ 1 ] === \"items\" && arguments[ 2 ] ) {\n\t\t\treturn this.controlgroup.apply( this,\n\t\t\t\t[ arguments[ 0 ], \"items.button\", arguments[ 2 ] ] );\n\t\t}\n\t\tif ( arguments[ 0 ] === \"option\" && arguments[ 1 ] === \"items\" ) {\n\t\t\treturn this.controlgroup.apply( this, [ arguments[ 0 ], \"items.button\" ] );\n\t\t}\n\t\tif ( typeof arguments[ 0 ] === \"object\" && arguments[ 0 ].items ) {\n\t\t\targuments[ 0 ].items = {\n\t\t\t\tbutton: arguments[ 0 ].items\n\t\t\t};\n\t\t}\n\t\treturn this.controlgroup.apply( this, arguments );\n\t};\n}\n\nreturn $.ui.button;\n\n} );\n","jquery/ui-modules/widgets/checkboxradio.js":"/*!\n * jQuery UI Checkboxradio 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Checkboxradio\n//>>group: Widgets\n//>>description: Enhances a form with multiple themeable checkboxes or radio buttons.\n//>>docs: http://api.jqueryui.com/checkboxradio/\n//>>demos: http://jqueryui.com/checkboxradio/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/button.css\n//>>css.structure: ../../themes/base/checkboxradio.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../form-reset-mixin\",\n\t\t\t\"../labels\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n$.widget( \"ui.checkboxradio\", [ $.ui.formResetMixin, {\n\tversion: \"1.13.1\",\n\toptions: {\n\t\tdisabled: null,\n\t\tlabel: null,\n\t\ticon: true,\n\t\tclasses: {\n\t\t\t\"ui-checkboxradio-label\": \"ui-corner-all\",\n\t\t\t\"ui-checkboxradio-icon\": \"ui-corner-all\"\n\t\t}\n\t},\n\n\t_getCreateOptions: function() {\n\t\tvar disabled, labels;\n\t\tvar that = this;\n\t\tvar options = this._super() || {};\n\n\t\t// We read the type here, because it makes more sense to throw a element type error first,\n\t\t// rather then the error for lack of a label. Often if its the wrong type, it\n\t\t// won't have a label (e.g. calling on a div, btn, etc)\n\t\tthis._readType();\n\n\t\tlabels = this.element.labels();\n\n\t\t// If there are multiple labels, use the last one\n\t\tthis.label = $( labels[ labels.length - 1 ] );\n\t\tif ( !this.label.length ) {\n\t\t\t$.error( \"No label found for checkboxradio widget\" );\n\t\t}\n\n\t\tthis.originalLabel = \"\";\n\n\t\t// We need to get the label text but this may also need to make sure it does not contain the\n\t\t// input itself.\n\t\tthis.label.contents().not( this.element[ 0 ] ).each( function() {\n\n\t\t\t// The label contents could be text, html, or a mix. We concat each element to get a\n\t\t\t// string representation of the label, without the input as part of it.\n\t\t\tthat.originalLabel += this.nodeType === 3 ? $( this ).text() : this.outerHTML;\n\t\t} );\n\n\t\t// Set the label option if we found label text\n\t\tif ( this.originalLabel ) {\n\t\t\toptions.label = this.originalLabel;\n\t\t}\n\n\t\tdisabled = this.element[ 0 ].disabled;\n\t\tif ( disabled != null ) {\n\t\t\toptions.disabled = disabled;\n\t\t}\n\t\treturn options;\n\t},\n\n\t_create: function() {\n\t\tvar checked = this.element[ 0 ].checked;\n\n\t\tthis._bindFormResetHandler();\n\n\t\tif ( this.options.disabled == null ) {\n\t\t\tthis.options.disabled = this.element[ 0 ].disabled;\n\t\t}\n\n\t\tthis._setOption( \"disabled\", this.options.disabled );\n\t\tthis._addClass( \"ui-checkboxradio\", \"ui-helper-hidden-accessible\" );\n\t\tthis._addClass( this.label, \"ui-checkboxradio-label\", \"ui-button ui-widget\" );\n\n\t\tif ( this.type === \"radio\" ) {\n\t\t\tthis._addClass( this.label, \"ui-checkboxradio-radio-label\" );\n\t\t}\n\n\t\tif ( this.options.label && this.options.label !== this.originalLabel ) {\n\t\t\tthis._updateLabel();\n\t\t} else if ( this.originalLabel ) {\n\t\t\tthis.options.label = this.originalLabel;\n\t\t}\n\n\t\tthis._enhance();\n\n\t\tif ( checked ) {\n\t\t\tthis._addClass( this.label, \"ui-checkboxradio-checked\", \"ui-state-active\" );\n\t\t}\n\n\t\tthis._on( {\n\t\t\tchange: \"_toggleClasses\",\n\t\t\tfocus: function() {\n\t\t\t\tthis._addClass( this.label, null, \"ui-state-focus ui-visual-focus\" );\n\t\t\t},\n\t\t\tblur: function() {\n\t\t\t\tthis._removeClass( this.label, null, \"ui-state-focus ui-visual-focus\" );\n\t\t\t}\n\t\t} );\n\t},\n\n\t_readType: function() {\n\t\tvar nodeName = this.element[ 0 ].nodeName.toLowerCase();\n\t\tthis.type = this.element[ 0 ].type;\n\t\tif ( nodeName !== \"input\" || !/radio|checkbox/.test( this.type ) ) {\n\t\t\t$.error( \"Can't create checkboxradio on element.nodeName=\" + nodeName +\n\t\t\t\t\" and element.type=\" + this.type );\n\t\t}\n\t},\n\n\t// Support jQuery Mobile enhanced option\n\t_enhance: function() {\n\t\tthis._updateIcon( this.element[ 0 ].checked );\n\t},\n\n\twidget: function() {\n\t\treturn this.label;\n\t},\n\n\t_getRadioGroup: function() {\n\t\tvar group;\n\t\tvar name = this.element[ 0 ].name;\n\t\tvar nameSelector = \"input[name='\" + $.escapeSelector( name ) + \"']\";\n\n\t\tif ( !name ) {\n\t\t\treturn $( [] );\n\t\t}\n\n\t\tif ( this.form.length ) {\n\t\t\tgroup = $( this.form[ 0 ].elements ).filter( nameSelector );\n\t\t} else {\n\n\t\t\t// Not inside a form, check all inputs that also are not inside a form\n\t\t\tgroup = $( nameSelector ).filter( function() {\n\t\t\t\treturn $( this )._form().length === 0;\n\t\t\t} );\n\t\t}\n\n\t\treturn group.not( this.element );\n\t},\n\n\t_toggleClasses: function() {\n\t\tvar checked = this.element[ 0 ].checked;\n\t\tthis._toggleClass( this.label, \"ui-checkboxradio-checked\", \"ui-state-active\", checked );\n\n\t\tif ( this.options.icon && this.type === \"checkbox\" ) {\n\t\t\tthis._toggleClass( this.icon, null, \"ui-icon-check ui-state-checked\", checked )\n\t\t\t\t._toggleClass( this.icon, null, \"ui-icon-blank\", !checked );\n\t\t}\n\n\t\tif ( this.type === \"radio\" ) {\n\t\t\tthis._getRadioGroup()\n\t\t\t\t.each( function() {\n\t\t\t\t\tvar instance = $( this ).checkboxradio( \"instance\" );\n\n\t\t\t\t\tif ( instance ) {\n\t\t\t\t\t\tinstance._removeClass( instance.label,\n\t\t\t\t\t\t\t\"ui-checkboxradio-checked\", \"ui-state-active\" );\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t}\n\t},\n\n\t_destroy: function() {\n\t\tthis._unbindFormResetHandler();\n\n\t\tif ( this.icon ) {\n\t\t\tthis.icon.remove();\n\t\t\tthis.iconSpace.remove();\n\t\t}\n\t},\n\n\t_setOption: function( key, value ) {\n\n\t\t// We don't allow the value to be set to nothing\n\t\tif ( key === \"label\" && !value ) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis._super( key, value );\n\n\t\tif ( key === \"disabled\" ) {\n\t\t\tthis._toggleClass( this.label, null, \"ui-state-disabled\", value );\n\t\t\tthis.element[ 0 ].disabled = value;\n\n\t\t\t// Don't refresh when setting disabled\n\t\t\treturn;\n\t\t}\n\t\tthis.refresh();\n\t},\n\n\t_updateIcon: function( checked ) {\n\t\tvar toAdd = \"ui-icon ui-icon-background \";\n\n\t\tif ( this.options.icon ) {\n\t\t\tif ( !this.icon ) {\n\t\t\t\tthis.icon = $( \"<span>\" );\n\t\t\t\tthis.iconSpace = $( \"<span> </span>\" );\n\t\t\t\tthis._addClass( this.iconSpace, \"ui-checkboxradio-icon-space\" );\n\t\t\t}\n\n\t\t\tif ( this.type === \"checkbox\" ) {\n\t\t\t\ttoAdd += checked ? \"ui-icon-check ui-state-checked\" : \"ui-icon-blank\";\n\t\t\t\tthis._removeClass( this.icon, null, checked ? \"ui-icon-blank\" : \"ui-icon-check\" );\n\t\t\t} else {\n\t\t\t\ttoAdd += \"ui-icon-blank\";\n\t\t\t}\n\t\t\tthis._addClass( this.icon, \"ui-checkboxradio-icon\", toAdd );\n\t\t\tif ( !checked ) {\n\t\t\t\tthis._removeClass( this.icon, null, \"ui-icon-check ui-state-checked\" );\n\t\t\t}\n\t\t\tthis.icon.prependTo( this.label ).after( this.iconSpace );\n\t\t} else if ( this.icon !== undefined ) {\n\t\t\tthis.icon.remove();\n\t\t\tthis.iconSpace.remove();\n\t\t\tdelete this.icon;\n\t\t}\n\t},\n\n\t_updateLabel: function() {\n\n\t\t// Remove the contents of the label ( minus the icon, icon space, and input )\n\t\tvar contents = this.label.contents().not( this.element[ 0 ] );\n\t\tif ( this.icon ) {\n\t\t\tcontents = contents.not( this.icon[ 0 ] );\n\t\t}\n\t\tif ( this.iconSpace ) {\n\t\t\tcontents = contents.not( this.iconSpace[ 0 ] );\n\t\t}\n\t\tcontents.remove();\n\n\t\tthis.label.append( this.options.label );\n\t},\n\n\trefresh: function() {\n\t\tvar checked = this.element[ 0 ].checked,\n\t\t\tisDisabled = this.element[ 0 ].disabled;\n\n\t\tthis._updateIcon( checked );\n\t\tthis._toggleClass( this.label, \"ui-checkboxradio-checked\", \"ui-state-active\", checked );\n\t\tif ( this.options.label !== null ) {\n\t\t\tthis._updateLabel();\n\t\t}\n\n\t\tif ( isDisabled !== this.options.disabled ) {\n\t\t\tthis._setOptions( { \"disabled\": isDisabled } );\n\t\t}\n\t}\n\n} ] );\n\nreturn $.ui.checkboxradio;\n\n} );\n","jquery/ui-modules/widgets/controlgroup.js":"/*!\n * jQuery UI Controlgroup 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Controlgroup\n//>>group: Widgets\n//>>description: Visually groups form control widgets\n//>>docs: http://api.jqueryui.com/controlgroup/\n//>>demos: http://jqueryui.com/controlgroup/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/controlgroup.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\nvar controlgroupCornerRegex = /ui-corner-([a-z]){2,6}/g;\n\nreturn $.widget( \"ui.controlgroup\", {\n\tversion: \"1.13.1\",\n\tdefaultElement: \"<div>\",\n\toptions: {\n\t\tdirection: \"horizontal\",\n\t\tdisabled: null,\n\t\tonlyVisible: true,\n\t\titems: {\n\t\t\t\"button\": \"input[type=button], input[type=submit], input[type=reset], button, a\",\n\t\t\t\"controlgroupLabel\": \".ui-controlgroup-label\",\n\t\t\t\"checkboxradio\": \"input[type='checkbox'], input[type='radio']\",\n\t\t\t\"selectmenu\": \"select\",\n\t\t\t\"spinner\": \".ui-spinner-input\"\n\t\t}\n\t},\n\n\t_create: function() {\n\t\tthis._enhance();\n\t},\n\n\t// To support the enhanced option in jQuery Mobile, we isolate DOM manipulation\n\t_enhance: function() {\n\t\tthis.element.attr( \"role\", \"toolbar\" );\n\t\tthis.refresh();\n\t},\n\n\t_destroy: function() {\n\t\tthis._callChildMethod( \"destroy\" );\n\t\tthis.childWidgets.removeData( \"ui-controlgroup-data\" );\n\t\tthis.element.removeAttr( \"role\" );\n\t\tif ( this.options.items.controlgroupLabel ) {\n\t\t\tthis.element\n\t\t\t\t.find( this.options.items.controlgroupLabel )\n\t\t\t\t.find( \".ui-controlgroup-label-contents\" )\n\t\t\t\t.contents().unwrap();\n\t\t}\n\t},\n\n\t_initWidgets: function() {\n\t\tvar that = this,\n\t\t\tchildWidgets = [];\n\n\t\t// First we iterate over each of the items options\n\t\t$.each( this.options.items, function( widget, selector ) {\n\t\t\tvar labels;\n\t\t\tvar options = {};\n\n\t\t\t// Make sure the widget has a selector set\n\t\t\tif ( !selector ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif ( widget === \"controlgroupLabel\" ) {\n\t\t\t\tlabels = that.element.find( selector );\n\t\t\t\tlabels.each( function() {\n\t\t\t\t\tvar element = $( this );\n\n\t\t\t\t\tif ( element.children( \".ui-controlgroup-label-contents\" ).length ) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\t\t\t\t\telement.contents()\n\t\t\t\t\t\t.wrapAll( \"<span class='ui-controlgroup-label-contents'></span>\" );\n\t\t\t\t} );\n\t\t\t\tthat._addClass( labels, null, \"ui-widget ui-widget-content ui-state-default\" );\n\t\t\t\tchildWidgets = childWidgets.concat( labels.get() );\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// Make sure the widget actually exists\n\t\t\tif ( !$.fn[ widget ] ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t// We assume everything is in the middle to start because we can't determine\n\t\t\t// first / last elements until all enhancments are done.\n\t\t\tif ( that[ \"_\" + widget + \"Options\" ] ) {\n\t\t\t\toptions = that[ \"_\" + widget + \"Options\" ]( \"middle\" );\n\t\t\t} else {\n\t\t\t\toptions = { classes: {} };\n\t\t\t}\n\n\t\t\t// Find instances of this widget inside controlgroup and init them\n\t\t\tthat.element\n\t\t\t\t.find( selector )\n\t\t\t\t.each( function() {\n\t\t\t\t\tvar element = $( this );\n\t\t\t\t\tvar instance = element[ widget ]( \"instance\" );\n\n\t\t\t\t\t// We need to clone the default options for this type of widget to avoid\n\t\t\t\t\t// polluting the variable options which has a wider scope than a single widget.\n\t\t\t\t\tvar instanceOptions = $.widget.extend( {}, options );\n\n\t\t\t\t\t// If the button is the child of a spinner ignore it\n\t\t\t\t\t// TODO: Find a more generic solution\n\t\t\t\t\tif ( widget === \"button\" && element.parent( \".ui-spinner\" ).length ) {\n\t\t\t\t\t\treturn;\n\t\t\t\t\t}\n\n\t\t\t\t\t// Create the widget if it doesn't exist\n\t\t\t\t\tif ( !instance ) {\n\t\t\t\t\t\tinstance = element[ widget ]()[ widget ]( \"instance\" );\n\t\t\t\t\t}\n\t\t\t\t\tif ( instance ) {\n\t\t\t\t\t\tinstanceOptions.classes =\n\t\t\t\t\t\t\tthat._resolveClassesValues( instanceOptions.classes, instance );\n\t\t\t\t\t}\n\t\t\t\t\telement[ widget ]( instanceOptions );\n\n\t\t\t\t\t// Store an instance of the controlgroup to be able to reference\n\t\t\t\t\t// from the outermost element for changing options and refresh\n\t\t\t\t\tvar widgetElement = element[ widget ]( \"widget\" );\n\t\t\t\t\t$.data( widgetElement[ 0 ], \"ui-controlgroup-data\",\n\t\t\t\t\t\tinstance ? instance : element[ widget ]( \"instance\" ) );\n\n\t\t\t\t\tchildWidgets.push( widgetElement[ 0 ] );\n\t\t\t\t} );\n\t\t} );\n\n\t\tthis.childWidgets = $( $.uniqueSort( childWidgets ) );\n\t\tthis._addClass( this.childWidgets, \"ui-controlgroup-item\" );\n\t},\n\n\t_callChildMethod: function( method ) {\n\t\tthis.childWidgets.each( function() {\n\t\t\tvar element = $( this ),\n\t\t\t\tdata = element.data( \"ui-controlgroup-data\" );\n\t\t\tif ( data && data[ method ] ) {\n\t\t\t\tdata[ method ]();\n\t\t\t}\n\t\t} );\n\t},\n\n\t_updateCornerClass: function( element, position ) {\n\t\tvar remove = \"ui-corner-top ui-corner-bottom ui-corner-left ui-corner-right ui-corner-all\";\n\t\tvar add = this._buildSimpleOptions( position, \"label\" ).classes.label;\n\n\t\tthis._removeClass( element, null, remove );\n\t\tthis._addClass( element, null, add );\n\t},\n\n\t_buildSimpleOptions: function( position, key ) {\n\t\tvar direction = this.options.direction === \"vertical\";\n\t\tvar result = {\n\t\t\tclasses: {}\n\t\t};\n\t\tresult.classes[ key ] = {\n\t\t\t\"middle\": \"\",\n\t\t\t\"first\": \"ui-corner-\" + ( direction ? \"top\" : \"left\" ),\n\t\t\t\"last\": \"ui-corner-\" + ( direction ? \"bottom\" : \"right\" ),\n\t\t\t\"only\": \"ui-corner-all\"\n\t\t}[ position ];\n\n\t\treturn result;\n\t},\n\n\t_spinnerOptions: function( position ) {\n\t\tvar options = this._buildSimpleOptions( position, \"ui-spinner\" );\n\n\t\toptions.classes[ \"ui-spinner-up\" ] = \"\";\n\t\toptions.classes[ \"ui-spinner-down\" ] = \"\";\n\n\t\treturn options;\n\t},\n\n\t_buttonOptions: function( position ) {\n\t\treturn this._buildSimpleOptions( position, \"ui-button\" );\n\t},\n\n\t_checkboxradioOptions: function( position ) {\n\t\treturn this._buildSimpleOptions( position, \"ui-checkboxradio-label\" );\n\t},\n\n\t_selectmenuOptions: function( position ) {\n\t\tvar direction = this.options.direction === \"vertical\";\n\t\treturn {\n\t\t\twidth: direction ? \"auto\" : false,\n\t\t\tclasses: {\n\t\t\t\tmiddle: {\n\t\t\t\t\t\"ui-selectmenu-button-open\": \"\",\n\t\t\t\t\t\"ui-selectmenu-button-closed\": \"\"\n\t\t\t\t},\n\t\t\t\tfirst: {\n\t\t\t\t\t\"ui-selectmenu-button-open\": \"ui-corner-\" + ( direction ? \"top\" : \"tl\" ),\n\t\t\t\t\t\"ui-selectmenu-button-closed\": \"ui-corner-\" + ( direction ? \"top\" : \"left\" )\n\t\t\t\t},\n\t\t\t\tlast: {\n\t\t\t\t\t\"ui-selectmenu-button-open\": direction ? \"\" : \"ui-corner-tr\",\n\t\t\t\t\t\"ui-selectmenu-button-closed\": \"ui-corner-\" + ( direction ? \"bottom\" : \"right\" )\n\t\t\t\t},\n\t\t\t\tonly: {\n\t\t\t\t\t\"ui-selectmenu-button-open\": \"ui-corner-top\",\n\t\t\t\t\t\"ui-selectmenu-button-closed\": \"ui-corner-all\"\n\t\t\t\t}\n\n\t\t\t}[ position ]\n\t\t};\n\t},\n\n\t_resolveClassesValues: function( classes, instance ) {\n\t\tvar result = {};\n\t\t$.each( classes, function( key ) {\n\t\t\tvar current = instance.options.classes[ key ] || \"\";\n\t\t\tcurrent = String.prototype.trim.call( current.replace( controlgroupCornerRegex, \"\" ) );\n\t\t\tresult[ key ] = ( current + \" \" + classes[ key ] ).replace( /\\s+/g, \" \" );\n\t\t} );\n\t\treturn result;\n\t},\n\n\t_setOption: function( key, value ) {\n\t\tif ( key === \"direction\" ) {\n\t\t\tthis._removeClass( \"ui-controlgroup-\" + this.options.direction );\n\t\t}\n\n\t\tthis._super( key, value );\n\t\tif ( key === \"disabled\" ) {\n\t\t\tthis._callChildMethod( value ? \"disable\" : \"enable\" );\n\t\t\treturn;\n\t\t}\n\n\t\tthis.refresh();\n\t},\n\n\trefresh: function() {\n\t\tvar children,\n\t\t\tthat = this;\n\n\t\tthis._addClass( \"ui-controlgroup ui-controlgroup-\" + this.options.direction );\n\n\t\tif ( this.options.direction === \"horizontal\" ) {\n\t\t\tthis._addClass( null, \"ui-helper-clearfix\" );\n\t\t}\n\t\tthis._initWidgets();\n\n\t\tchildren = this.childWidgets;\n\n\t\t// We filter here because we need to track all childWidgets not just the visible ones\n\t\tif ( this.options.onlyVisible ) {\n\t\t\tchildren = children.filter( \":visible\" );\n\t\t}\n\n\t\tif ( children.length ) {\n\n\t\t\t// We do this last because we need to make sure all enhancment is done\n\t\t\t// before determining first and last\n\t\t\t$.each( [ \"first\", \"last\" ], function( index, value ) {\n\t\t\t\tvar instance = children[ value ]().data( \"ui-controlgroup-data\" );\n\n\t\t\t\tif ( instance && that[ \"_\" + instance.widgetName + \"Options\" ] ) {\n\t\t\t\t\tvar options = that[ \"_\" + instance.widgetName + \"Options\" ](\n\t\t\t\t\t\tchildren.length === 1 ? \"only\" : value\n\t\t\t\t\t);\n\t\t\t\t\toptions.classes = that._resolveClassesValues( options.classes, instance );\n\t\t\t\t\tinstance.element[ instance.widgetName ]( options );\n\t\t\t\t} else {\n\t\t\t\t\tthat._updateCornerClass( children[ value ](), value );\n\t\t\t\t}\n\t\t\t} );\n\n\t\t\t// Finally call the refresh method on each of the child widgets.\n\t\t\tthis._callChildMethod( \"refresh\" );\n\t\t}\n\t}\n} );\n} );\n","jquery/ui-modules/widgets/datepicker.js":"/* eslint-disable max-len, camelcase */\n/*!\n * jQuery UI Datepicker 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Datepicker\n//>>group: Widgets\n//>>description: Displays a calendar from an input or inline for selecting dates.\n//>>docs: http://api.jqueryui.com/datepicker/\n//>>demos: http://jqueryui.com/datepicker/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/datepicker.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"../version\",\n\t\t\t\"../keycode\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n$.extend( $.ui, { datepicker: { version: \"1.13.1\" } } );\n\nvar datepicker_instActive;\n\nfunction datepicker_getZindex( elem ) {\n\tvar position, value;\n\twhile ( elem.length && elem[ 0 ] !== document ) {\n\n\t\t// Ignore z-index if position is set to a value where z-index is ignored by the browser\n\t\t// This makes behavior of this function consistent across browsers\n\t\t// WebKit always returns auto if the element is positioned\n\t\tposition = elem.css( \"position\" );\n\t\tif ( position === \"absolute\" || position === \"relative\" || position === \"fixed\" ) {\n\n\t\t\t// IE returns 0 when zIndex is not specified\n\t\t\t// other browsers return a string\n\t\t\t// we ignore the case of nested elements with an explicit value of 0\n\t\t\t// <div style=\"z-index: -10;\"><div style=\"z-index: 0;\"></div></div>\n\t\t\tvalue = parseInt( elem.css( \"zIndex\" ), 10 );\n\t\t\tif ( !isNaN( value ) && value !== 0 ) {\n\t\t\t\treturn value;\n\t\t\t}\n\t\t}\n\t\telem = elem.parent();\n\t}\n\n\treturn 0;\n}\n\n/* Date picker manager.\n   Use the singleton instance of this class, $.datepicker, to interact with the date picker.\n   Settings for (groups of) date pickers are maintained in an instance object,\n   allowing multiple different settings on the same page. */\n\nfunction Datepicker() {\n\tthis._curInst = null; // The current instance in use\n\tthis._keyEvent = false; // If the last event was a key event\n\tthis._disabledInputs = []; // List of date picker inputs that have been disabled\n\tthis._datepickerShowing = false; // True if the popup picker is showing , false if not\n\tthis._inDialog = false; // True if showing within a \"dialog\", false if not\n\tthis._mainDivId = \"ui-datepicker-div\"; // The ID of the main datepicker division\n\tthis._inlineClass = \"ui-datepicker-inline\"; // The name of the inline marker class\n\tthis._appendClass = \"ui-datepicker-append\"; // The name of the append marker class\n\tthis._triggerClass = \"ui-datepicker-trigger\"; // The name of the trigger marker class\n\tthis._dialogClass = \"ui-datepicker-dialog\"; // The name of the dialog marker class\n\tthis._disableClass = \"ui-datepicker-disabled\"; // The name of the disabled covering marker class\n\tthis._unselectableClass = \"ui-datepicker-unselectable\"; // The name of the unselectable cell marker class\n\tthis._currentClass = \"ui-datepicker-current-day\"; // The name of the current day marker class\n\tthis._dayOverClass = \"ui-datepicker-days-cell-over\"; // The name of the day hover marker class\n\tthis.regional = []; // Available regional settings, indexed by language code\n\tthis.regional[ \"\" ] = { // Default regional settings\n\t\tcloseText: \"Done\", // Display text for close link\n\t\tprevText: \"Prev\", // Display text for previous month link\n\t\tnextText: \"Next\", // Display text for next month link\n\t\tcurrentText: \"Today\", // Display text for current month link\n\t\tmonthNames: [ \"January\", \"February\", \"March\", \"April\", \"May\", \"June\",\n\t\t\t\"July\", \"August\", \"September\", \"October\", \"November\", \"December\" ], // Names of months for drop-down and formatting\n\t\tmonthNamesShort: [ \"Jan\", \"Feb\", \"Mar\", \"Apr\", \"May\", \"Jun\", \"Jul\", \"Aug\", \"Sep\", \"Oct\", \"Nov\", \"Dec\" ], // For formatting\n\t\tdayNames: [ \"Sunday\", \"Monday\", \"Tuesday\", \"Wednesday\", \"Thursday\", \"Friday\", \"Saturday\" ], // For formatting\n\t\tdayNamesShort: [ \"Sun\", \"Mon\", \"Tue\", \"Wed\", \"Thu\", \"Fri\", \"Sat\" ], // For formatting\n\t\tdayNamesMin: [ \"Su\", \"Mo\", \"Tu\", \"We\", \"Th\", \"Fr\", \"Sa\" ], // Column headings for days starting at Sunday\n\t\tweekHeader: \"Wk\", // Column header for week of the year\n\t\tdateFormat: \"mm/dd/yy\", // See format options on parseDate\n\t\tfirstDay: 0, // The first day of the week, Sun = 0, Mon = 1, ...\n\t\tisRTL: false, // True if right-to-left language, false if left-to-right\n\t\tshowMonthAfterYear: false, // True if the year select precedes month, false for month then year\n\t\tyearSuffix: \"\", // Additional text to append to the year in the month headers,\n\t\tselectMonthLabel: \"Select month\", // Invisible label for month selector\n\t\tselectYearLabel: \"Select year\" // Invisible label for year selector\n\t};\n\tthis._defaults = { // Global defaults for all the date picker instances\n\t\tshowOn: \"focus\", // \"focus\" for popup on focus,\n\t\t\t// \"button\" for trigger button, or \"both\" for either\n\t\tshowAnim: \"fadeIn\", // Name of jQuery animation for popup\n\t\tshowOptions: {}, // Options for enhanced animations\n\t\tdefaultDate: null, // Used when field is blank: actual date,\n\t\t\t// +/-number for offset from today, null for today\n\t\tappendText: \"\", // Display text following the input box, e.g. showing the format\n\t\tbuttonText: \"...\", // Text for trigger button\n\t\tbuttonImage: \"\", // URL for trigger button image\n\t\tbuttonImageOnly: false, // True if the image appears alone, false if it appears on a button\n\t\thideIfNoPrevNext: false, // True to hide next/previous month links\n\t\t\t// if not applicable, false to just disable them\n\t\tnavigationAsDateFormat: false, // True if date formatting applied to prev/today/next links\n\t\tgotoCurrent: false, // True if today link goes back to current selection instead\n\t\tchangeMonth: false, // True if month can be selected directly, false if only prev/next\n\t\tchangeYear: false, // True if year can be selected directly, false if only prev/next\n\t\tyearRange: \"c-10:c+10\", // Range of years to display in drop-down,\n\t\t\t// either relative to today's year (-nn:+nn), relative to currently displayed year\n\t\t\t// (c-nn:c+nn), absolute (nnnn:nnnn), or a combination of the above (nnnn:-n)\n\t\tshowOtherMonths: false, // True to show dates in other months, false to leave blank\n\t\tselectOtherMonths: false, // True to allow selection of dates in other months, false for unselectable\n\t\tshowWeek: false, // True to show week of the year, false to not show it\n\t\tcalculateWeek: this.iso8601Week, // How to calculate the week of the year,\n\t\t\t// takes a Date and returns the number of the week for it\n\t\tshortYearCutoff: \"+10\", // Short year values < this are in the current century,\n\t\t\t// > this are in the previous century,\n\t\t\t// string value starting with \"+\" for current year + value\n\t\tminDate: null, // The earliest selectable date, or null for no limit\n\t\tmaxDate: null, // The latest selectable date, or null for no limit\n\t\tduration: \"fast\", // Duration of display/closure\n\t\tbeforeShowDay: null, // Function that takes a date and returns an array with\n\t\t\t// [0] = true if selectable, false if not, [1] = custom CSS class name(s) or \"\",\n\t\t\t// [2] = cell title (optional), e.g. $.datepicker.noWeekends\n\t\tbeforeShow: null, // Function that takes an input field and\n\t\t\t// returns a set of custom settings for the date picker\n\t\tonSelect: null, // Define a callback function when a date is selected\n\t\tonChangeMonthYear: null, // Define a callback function when the month or year is changed\n\t\tonClose: null, // Define a callback function when the datepicker is closed\n\t\tonUpdateDatepicker: null, // Define a callback function when the datepicker is updated\n\t\tnumberOfMonths: 1, // Number of months to show at a time\n\t\tshowCurrentAtPos: 0, // The position in multipe months at which to show the current month (starting at 0)\n\t\tstepMonths: 1, // Number of months to step back/forward\n\t\tstepBigMonths: 12, // Number of months to step back/forward for the big links\n\t\taltField: \"\", // Selector for an alternate field to store selected dates into\n\t\taltFormat: \"\", // The date format to use for the alternate field\n\t\tconstrainInput: true, // The input is constrained by the current date format\n\t\tshowButtonPanel: false, // True to show button panel, false to not show it\n\t\tautoSize: false, // True to size the input for the date format, false to leave as is\n\t\tdisabled: false // The initial disabled state\n\t};\n\t$.extend( this._defaults, this.regional[ \"\" ] );\n\tthis.regional.en = $.extend( true, {}, this.regional[ \"\" ] );\n\tthis.regional[ \"en-US\" ] = $.extend( true, {}, this.regional.en );\n\tthis.dpDiv = datepicker_bindHover( $( \"<div id='\" + this._mainDivId + \"' class='ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>\" ) );\n}\n\n$.extend( Datepicker.prototype, {\n\n\t/* Class name added to elements to indicate already configured with a date picker. */\n\tmarkerClassName: \"hasDatepicker\",\n\n\t//Keep track of the maximum number of rows displayed (see #7043)\n\tmaxRows: 4,\n\n\t// TODO rename to \"widget\" when switching to widget factory\n\t_widgetDatepicker: function() {\n\t\treturn this.dpDiv;\n\t},\n\n\t/* Override the default settings for all instances of the date picker.\n\t * @param  settings  object - the new settings to use as defaults (anonymous object)\n\t * @return the manager object\n\t */\n\tsetDefaults: function( settings ) {\n\t\tdatepicker_extendRemove( this._defaults, settings || {} );\n\t\treturn this;\n\t},\n\n\t/* Attach the date picker to a jQuery selection.\n\t * @param  target\telement - the target input field or division or span\n\t * @param  settings  object - the new settings to use for this date picker instance (anonymous)\n\t */\n\t_attachDatepicker: function( target, settings ) {\n\t\tvar nodeName, inline, inst;\n\t\tnodeName = target.nodeName.toLowerCase();\n\t\tinline = ( nodeName === \"div\" || nodeName === \"span\" );\n\t\tif ( !target.id ) {\n\t\t\tthis.uuid += 1;\n\t\t\ttarget.id = \"dp\" + this.uuid;\n\t\t}\n\t\tinst = this._newInst( $( target ), inline );\n\t\tinst.settings = $.extend( {}, settings || {} );\n\t\tif ( nodeName === \"input\" ) {\n\t\t\tthis._connectDatepicker( target, inst );\n\t\t} else if ( inline ) {\n\t\t\tthis._inlineDatepicker( target, inst );\n\t\t}\n\t},\n\n\t/* Create a new instance object. */\n\t_newInst: function( target, inline ) {\n\t\tvar id = target[ 0 ].id.replace( /([^A-Za-z0-9_\\-])/g, \"\\\\\\\\$1\" ); // escape jQuery meta chars\n\t\treturn { id: id, input: target, // associated target\n\t\t\tselectedDay: 0, selectedMonth: 0, selectedYear: 0, // current selection\n\t\t\tdrawMonth: 0, drawYear: 0, // month being drawn\n\t\t\tinline: inline, // is datepicker inline or not\n\t\t\tdpDiv: ( !inline ? this.dpDiv : // presentation div\n\t\t\tdatepicker_bindHover( $( \"<div class='\" + this._inlineClass + \" ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all'></div>\" ) ) ) };\n\t},\n\n\t/* Attach the date picker to an input field. */\n\t_connectDatepicker: function( target, inst ) {\n\t\tvar input = $( target );\n\t\tinst.append = $( [] );\n\t\tinst.trigger = $( [] );\n\t\tif ( input.hasClass( this.markerClassName ) ) {\n\t\t\treturn;\n\t\t}\n\t\tthis._attachments( input, inst );\n\t\tinput.addClass( this.markerClassName ).on( \"keydown\", this._doKeyDown ).\n\t\t\ton( \"keypress\", this._doKeyPress ).on( \"keyup\", this._doKeyUp );\n\t\tthis._autoSize( inst );\n\t\t$.data( target, \"datepicker\", inst );\n\n\t\t//If disabled option is true, disable the datepicker once it has been attached to the input (see ticket #5665)\n\t\tif ( inst.settings.disabled ) {\n\t\t\tthis._disableDatepicker( target );\n\t\t}\n\t},\n\n\t/* Make attachments based on settings. */\n\t_attachments: function( input, inst ) {\n\t\tvar showOn, buttonText, buttonImage,\n\t\t\tappendText = this._get( inst, \"appendText\" ),\n\t\t\tisRTL = this._get( inst, \"isRTL\" );\n\n\t\tif ( inst.append ) {\n\t\t\tinst.append.remove();\n\t\t}\n\t\tif ( appendText ) {\n\t\t\tinst.append = $( \"<span>\" )\n\t\t\t\t.addClass( this._appendClass )\n\t\t\t\t.text( appendText );\n\t\t\tinput[ isRTL ? \"before\" : \"after\" ]( inst.append );\n\t\t}\n\n\t\tinput.off( \"focus\", this._showDatepicker );\n\n\t\tif ( inst.trigger ) {\n\t\t\tinst.trigger.remove();\n\t\t}\n\n\t\tshowOn = this._get( inst, \"showOn\" );\n\t\tif ( showOn === \"focus\" || showOn === \"both\" ) { // pop-up date picker when in the marked field\n\t\t\tinput.on( \"focus\", this._showDatepicker );\n\t\t}\n\t\tif ( showOn === \"button\" || showOn === \"both\" ) { // pop-up date picker when button clicked\n\t\t\tbuttonText = this._get( inst, \"buttonText\" );\n\t\t\tbuttonImage = this._get( inst, \"buttonImage\" );\n\n\t\t\tif ( this._get( inst, \"buttonImageOnly\" ) ) {\n\t\t\t\tinst.trigger = $( \"<img>\" )\n\t\t\t\t\t.addClass( this._triggerClass )\n\t\t\t\t\t.attr( {\n\t\t\t\t\t\tsrc: buttonImage,\n\t\t\t\t\t\talt: buttonText,\n\t\t\t\t\t\ttitle: buttonText\n\t\t\t\t\t} );\n\t\t\t} else {\n\t\t\t\tinst.trigger = $( \"<button type='button'>\" )\n\t\t\t\t\t.addClass( this._triggerClass );\n\t\t\t\tif ( buttonImage ) {\n\t\t\t\t\tinst.trigger.html(\n\t\t\t\t\t\t$( \"<img>\" )\n\t\t\t\t\t\t\t.attr( {\n\t\t\t\t\t\t\t\tsrc: buttonImage,\n\t\t\t\t\t\t\t\talt: buttonText,\n\t\t\t\t\t\t\t\ttitle: buttonText\n\t\t\t\t\t\t\t} )\n\t\t\t\t\t);\n\t\t\t\t} else {\n\t\t\t\t\tinst.trigger.text( buttonText );\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tinput[ isRTL ? \"before\" : \"after\" ]( inst.trigger );\n\t\t\tinst.trigger.on( \"click\", function() {\n\t\t\t\tif ( $.datepicker._datepickerShowing && $.datepicker._lastInput === input[ 0 ] ) {\n\t\t\t\t\t$.datepicker._hideDatepicker();\n\t\t\t\t} else if ( $.datepicker._datepickerShowing && $.datepicker._lastInput !== input[ 0 ] ) {\n\t\t\t\t\t$.datepicker._hideDatepicker();\n\t\t\t\t\t$.datepicker._showDatepicker( input[ 0 ] );\n\t\t\t\t} else {\n\t\t\t\t\t$.datepicker._showDatepicker( input[ 0 ] );\n\t\t\t\t}\n\t\t\t\treturn false;\n\t\t\t} );\n\t\t}\n\t},\n\n\t/* Apply the maximum length for the date format. */\n\t_autoSize: function( inst ) {\n\t\tif ( this._get( inst, \"autoSize\" ) && !inst.inline ) {\n\t\t\tvar findMax, max, maxI, i,\n\t\t\t\tdate = new Date( 2009, 12 - 1, 20 ), // Ensure double digits\n\t\t\t\tdateFormat = this._get( inst, \"dateFormat\" );\n\n\t\t\tif ( dateFormat.match( /[DM]/ ) ) {\n\t\t\t\tfindMax = function( names ) {\n\t\t\t\t\tmax = 0;\n\t\t\t\t\tmaxI = 0;\n\t\t\t\t\tfor ( i = 0; i < names.length; i++ ) {\n\t\t\t\t\t\tif ( names[ i ].length > max ) {\n\t\t\t\t\t\t\tmax = names[ i ].length;\n\t\t\t\t\t\t\tmaxI = i;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\treturn maxI;\n\t\t\t\t};\n\t\t\t\tdate.setMonth( findMax( this._get( inst, ( dateFormat.match( /MM/ ) ?\n\t\t\t\t\t\"monthNames\" : \"monthNamesShort\" ) ) ) );\n\t\t\t\tdate.setDate( findMax( this._get( inst, ( dateFormat.match( /DD/ ) ?\n\t\t\t\t\t\"dayNames\" : \"dayNamesShort\" ) ) ) + 20 - date.getDay() );\n\t\t\t}\n\t\t\tinst.input.attr( \"size\", this._formatDate( inst, date ).length );\n\t\t}\n\t},\n\n\t/* Attach an inline date picker to a div. */\n\t_inlineDatepicker: function( target, inst ) {\n\t\tvar divSpan = $( target );\n\t\tif ( divSpan.hasClass( this.markerClassName ) ) {\n\t\t\treturn;\n\t\t}\n\t\tdivSpan.addClass( this.markerClassName ).append( inst.dpDiv );\n\t\t$.data( target, \"datepicker\", inst );\n\t\tthis._setDate( inst, this._getDefaultDate( inst ), true );\n\t\tthis._updateDatepicker( inst );\n\t\tthis._updateAlternate( inst );\n\n\t\t//If disabled option is true, disable the datepicker before showing it (see ticket #5665)\n\t\tif ( inst.settings.disabled ) {\n\t\t\tthis._disableDatepicker( target );\n\t\t}\n\n\t\t// Set display:block in place of inst.dpDiv.show() which won't work on disconnected elements\n\t\t// http://bugs.jqueryui.com/ticket/7552 - A Datepicker created on a detached div has zero height\n\t\tinst.dpDiv.css( \"display\", \"block\" );\n\t},\n\n\t/* Pop-up the date picker in a \"dialog\" box.\n\t * @param  input element - ignored\n\t * @param  date\tstring or Date - the initial date to display\n\t * @param  onSelect  function - the function to call when a date is selected\n\t * @param  settings  object - update the dialog date picker instance's settings (anonymous object)\n\t * @param  pos int[2] - coordinates for the dialog's position within the screen or\n\t *\t\t\t\t\tevent - with x/y coordinates or\n\t *\t\t\t\t\tleave empty for default (screen centre)\n\t * @return the manager object\n\t */\n\t_dialogDatepicker: function( input, date, onSelect, settings, pos ) {\n\t\tvar id, browserWidth, browserHeight, scrollX, scrollY,\n\t\t\tinst = this._dialogInst; // internal instance\n\n\t\tif ( !inst ) {\n\t\t\tthis.uuid += 1;\n\t\t\tid = \"dp\" + this.uuid;\n\t\t\tthis._dialogInput = $( \"<input type='text' id='\" + id +\n\t\t\t\t\"' style='position: absolute; top: -100px; width: 0px;'/>\" );\n\t\t\tthis._dialogInput.on( \"keydown\", this._doKeyDown );\n\t\t\t$( \"body\" ).append( this._dialogInput );\n\t\t\tinst = this._dialogInst = this._newInst( this._dialogInput, false );\n\t\t\tinst.settings = {};\n\t\t\t$.data( this._dialogInput[ 0 ], \"datepicker\", inst );\n\t\t}\n\t\tdatepicker_extendRemove( inst.settings, settings || {} );\n\t\tdate = ( date && date.constructor === Date ? this._formatDate( inst, date ) : date );\n\t\tthis._dialogInput.val( date );\n\n\t\tthis._pos = ( pos ? ( pos.length ? pos : [ pos.pageX, pos.pageY ] ) : null );\n\t\tif ( !this._pos ) {\n\t\t\tbrowserWidth = document.documentElement.clientWidth;\n\t\t\tbrowserHeight = document.documentElement.clientHeight;\n\t\t\tscrollX = document.documentElement.scrollLeft || document.body.scrollLeft;\n\t\t\tscrollY = document.documentElement.scrollTop || document.body.scrollTop;\n\t\t\tthis._pos = // should use actual width/height below\n\t\t\t\t[ ( browserWidth / 2 ) - 100 + scrollX, ( browserHeight / 2 ) - 150 + scrollY ];\n\t\t}\n\n\t\t// Move input on screen for focus, but hidden behind dialog\n\t\tthis._dialogInput.css( \"left\", ( this._pos[ 0 ] + 20 ) + \"px\" ).css( \"top\", this._pos[ 1 ] + \"px\" );\n\t\tinst.settings.onSelect = onSelect;\n\t\tthis._inDialog = true;\n\t\tthis.dpDiv.addClass( this._dialogClass );\n\t\tthis._showDatepicker( this._dialogInput[ 0 ] );\n\t\tif ( $.blockUI ) {\n\t\t\t$.blockUI( this.dpDiv );\n\t\t}\n\t\t$.data( this._dialogInput[ 0 ], \"datepicker\", inst );\n\t\treturn this;\n\t},\n\n\t/* Detach a datepicker from its control.\n\t * @param  target\telement - the target input field or division or span\n\t */\n\t_destroyDatepicker: function( target ) {\n\t\tvar nodeName,\n\t\t\t$target = $( target ),\n\t\t\tinst = $.data( target, \"datepicker\" );\n\n\t\tif ( !$target.hasClass( this.markerClassName ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tnodeName = target.nodeName.toLowerCase();\n\t\t$.removeData( target, \"datepicker\" );\n\t\tif ( nodeName === \"input\" ) {\n\t\t\tinst.append.remove();\n\t\t\tinst.trigger.remove();\n\t\t\t$target.removeClass( this.markerClassName ).\n\t\t\t\toff( \"focus\", this._showDatepicker ).\n\t\t\t\toff( \"keydown\", this._doKeyDown ).\n\t\t\t\toff( \"keypress\", this._doKeyPress ).\n\t\t\t\toff( \"keyup\", this._doKeyUp );\n\t\t} else if ( nodeName === \"div\" || nodeName === \"span\" ) {\n\t\t\t$target.removeClass( this.markerClassName ).empty();\n\t\t}\n\n\t\tif ( datepicker_instActive === inst ) {\n\t\t\tdatepicker_instActive = null;\n\t\t\tthis._curInst = null;\n\t\t}\n\t},\n\n\t/* Enable the date picker to a jQuery selection.\n\t * @param  target\telement - the target input field or division or span\n\t */\n\t_enableDatepicker: function( target ) {\n\t\tvar nodeName, inline,\n\t\t\t$target = $( target ),\n\t\t\tinst = $.data( target, \"datepicker\" );\n\n\t\tif ( !$target.hasClass( this.markerClassName ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tnodeName = target.nodeName.toLowerCase();\n\t\tif ( nodeName === \"input\" ) {\n\t\t\ttarget.disabled = false;\n\t\t\tinst.trigger.filter( \"button\" ).\n\t\t\t\teach( function() {\n\t\t\t\t\tthis.disabled = false;\n\t\t\t\t} ).end().\n\t\t\t\tfilter( \"img\" ).css( { opacity: \"1.0\", cursor: \"\" } );\n\t\t} else if ( nodeName === \"div\" || nodeName === \"span\" ) {\n\t\t\tinline = $target.children( \".\" + this._inlineClass );\n\t\t\tinline.children().removeClass( \"ui-state-disabled\" );\n\t\t\tinline.find( \"select.ui-datepicker-month, select.ui-datepicker-year\" ).\n\t\t\t\tprop( \"disabled\", false );\n\t\t}\n\t\tthis._disabledInputs = $.map( this._disabledInputs,\n\n\t\t\t// Delete entry\n\t\t\tfunction( value ) {\n\t\t\t\treturn ( value === target ? null : value );\n\t\t\t} );\n\t},\n\n\t/* Disable the date picker to a jQuery selection.\n\t * @param  target\telement - the target input field or division or span\n\t */\n\t_disableDatepicker: function( target ) {\n\t\tvar nodeName, inline,\n\t\t\t$target = $( target ),\n\t\t\tinst = $.data( target, \"datepicker\" );\n\n\t\tif ( !$target.hasClass( this.markerClassName ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tnodeName = target.nodeName.toLowerCase();\n\t\tif ( nodeName === \"input\" ) {\n\t\t\ttarget.disabled = true;\n\t\t\tinst.trigger.filter( \"button\" ).\n\t\t\t\teach( function() {\n\t\t\t\t\tthis.disabled = true;\n\t\t\t\t} ).end().\n\t\t\t\tfilter( \"img\" ).css( { opacity: \"0.5\", cursor: \"default\" } );\n\t\t} else if ( nodeName === \"div\" || nodeName === \"span\" ) {\n\t\t\tinline = $target.children( \".\" + this._inlineClass );\n\t\t\tinline.children().addClass( \"ui-state-disabled\" );\n\t\t\tinline.find( \"select.ui-datepicker-month, select.ui-datepicker-year\" ).\n\t\t\t\tprop( \"disabled\", true );\n\t\t}\n\t\tthis._disabledInputs = $.map( this._disabledInputs,\n\n\t\t\t// Delete entry\n\t\t\tfunction( value ) {\n\t\t\t\treturn ( value === target ? null : value );\n\t\t\t} );\n\t\tthis._disabledInputs[ this._disabledInputs.length ] = target;\n\t},\n\n\t/* Is the first field in a jQuery collection disabled as a datepicker?\n\t * @param  target\telement - the target input field or division or span\n\t * @return boolean - true if disabled, false if enabled\n\t */\n\t_isDisabledDatepicker: function( target ) {\n\t\tif ( !target ) {\n\t\t\treturn false;\n\t\t}\n\t\tfor ( var i = 0; i < this._disabledInputs.length; i++ ) {\n\t\t\tif ( this._disabledInputs[ i ] === target ) {\n\t\t\t\treturn true;\n\t\t\t}\n\t\t}\n\t\treturn false;\n\t},\n\n\t/* Retrieve the instance data for the target control.\n\t * @param  target  element - the target input field or division or span\n\t * @return  object - the associated instance data\n\t * @throws  error if a jQuery problem getting data\n\t */\n\t_getInst: function( target ) {\n\t\ttry {\n\t\t\treturn $.data( target, \"datepicker\" );\n\t\t} catch ( err ) {\n\t\t\tthrow \"Missing instance data for this datepicker\";\n\t\t}\n\t},\n\n\t/* Update or retrieve the settings for a date picker attached to an input field or division.\n\t * @param  target  element - the target input field or division or span\n\t * @param  name\tobject - the new settings to update or\n\t *\t\t\t\tstring - the name of the setting to change or retrieve,\n\t *\t\t\t\twhen retrieving also \"all\" for all instance settings or\n\t *\t\t\t\t\"defaults\" for all global defaults\n\t * @param  value   any - the new value for the setting\n\t *\t\t\t\t(omit if above is an object or to retrieve a value)\n\t */\n\t_optionDatepicker: function( target, name, value ) {\n\t\tvar settings, date, minDate, maxDate,\n\t\t\tinst = this._getInst( target );\n\n\t\tif ( arguments.length === 2 && typeof name === \"string\" ) {\n\t\t\treturn ( name === \"defaults\" ? $.extend( {}, $.datepicker._defaults ) :\n\t\t\t\t( inst ? ( name === \"all\" ? $.extend( {}, inst.settings ) :\n\t\t\t\tthis._get( inst, name ) ) : null ) );\n\t\t}\n\n\t\tsettings = name || {};\n\t\tif ( typeof name === \"string\" ) {\n\t\t\tsettings = {};\n\t\t\tsettings[ name ] = value;\n\t\t}\n\n\t\tif ( inst ) {\n\t\t\tif ( this._curInst === inst ) {\n\t\t\t\tthis._hideDatepicker();\n\t\t\t}\n\n\t\t\tdate = this._getDateDatepicker( target, true );\n\t\t\tminDate = this._getMinMaxDate( inst, \"min\" );\n\t\t\tmaxDate = this._getMinMaxDate( inst, \"max\" );\n\t\t\tdatepicker_extendRemove( inst.settings, settings );\n\n\t\t\t// reformat the old minDate/maxDate values if dateFormat changes and a new minDate/maxDate isn't provided\n\t\t\tif ( minDate !== null && settings.dateFormat !== undefined && settings.minDate === undefined ) {\n\t\t\t\tinst.settings.minDate = this._formatDate( inst, minDate );\n\t\t\t}\n\t\t\tif ( maxDate !== null && settings.dateFormat !== undefined && settings.maxDate === undefined ) {\n\t\t\t\tinst.settings.maxDate = this._formatDate( inst, maxDate );\n\t\t\t}\n\t\t\tif ( \"disabled\" in settings ) {\n\t\t\t\tif ( settings.disabled ) {\n\t\t\t\t\tthis._disableDatepicker( target );\n\t\t\t\t} else {\n\t\t\t\t\tthis._enableDatepicker( target );\n\t\t\t\t}\n\t\t\t}\n\t\t\tthis._attachments( $( target ), inst );\n\t\t\tthis._autoSize( inst );\n\t\t\tthis._setDate( inst, date );\n\t\t\tthis._updateAlternate( inst );\n\t\t\tthis._updateDatepicker( inst );\n\t\t}\n\t},\n\n\t// Change method deprecated\n\t_changeDatepicker: function( target, name, value ) {\n\t\tthis._optionDatepicker( target, name, value );\n\t},\n\n\t/* Redraw the date picker attached to an input field or division.\n\t * @param  target  element - the target input field or division or span\n\t */\n\t_refreshDatepicker: function( target ) {\n\t\tvar inst = this._getInst( target );\n\t\tif ( inst ) {\n\t\t\tthis._updateDatepicker( inst );\n\t\t}\n\t},\n\n\t/* Set the dates for a jQuery selection.\n\t * @param  target element - the target input field or division or span\n\t * @param  date\tDate - the new date\n\t */\n\t_setDateDatepicker: function( target, date ) {\n\t\tvar inst = this._getInst( target );\n\t\tif ( inst ) {\n\t\t\tthis._setDate( inst, date );\n\t\t\tthis._updateDatepicker( inst );\n\t\t\tthis._updateAlternate( inst );\n\t\t}\n\t},\n\n\t/* Get the date(s) for the first entry in a jQuery selection.\n\t * @param  target element - the target input field or division or span\n\t * @param  noDefault boolean - true if no default date is to be used\n\t * @return Date - the current date\n\t */\n\t_getDateDatepicker: function( target, noDefault ) {\n\t\tvar inst = this._getInst( target );\n\t\tif ( inst && !inst.inline ) {\n\t\t\tthis._setDateFromField( inst, noDefault );\n\t\t}\n\t\treturn ( inst ? this._getDate( inst ) : null );\n\t},\n\n\t/* Handle keystrokes. */\n\t_doKeyDown: function( event ) {\n\t\tvar onSelect, dateStr, sel,\n\t\t\tinst = $.datepicker._getInst( event.target ),\n\t\t\thandled = true,\n\t\t\tisRTL = inst.dpDiv.is( \".ui-datepicker-rtl\" );\n\n\t\tinst._keyEvent = true;\n\t\tif ( $.datepicker._datepickerShowing ) {\n\t\t\tswitch ( event.keyCode ) {\n\t\t\t\tcase 9: $.datepicker._hideDatepicker();\n\t\t\t\t\t\thandled = false;\n\t\t\t\t\t\tbreak; // hide on tab out\n\t\t\t\tcase 13: sel = $( \"td.\" + $.datepicker._dayOverClass + \":not(.\" +\n\t\t\t\t\t\t\t\t\t$.datepicker._currentClass + \")\", inst.dpDiv );\n\t\t\t\t\t\tif ( sel[ 0 ] ) {\n\t\t\t\t\t\t\t$.datepicker._selectDay( event.target, inst.selectedMonth, inst.selectedYear, sel[ 0 ] );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tonSelect = $.datepicker._get( inst, \"onSelect\" );\n\t\t\t\t\t\tif ( onSelect ) {\n\t\t\t\t\t\t\tdateStr = $.datepicker._formatDate( inst );\n\n\t\t\t\t\t\t\t// Trigger custom callback\n\t\t\t\t\t\t\tonSelect.apply( ( inst.input ? inst.input[ 0 ] : null ), [ dateStr, inst ] );\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t$.datepicker._hideDatepicker();\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\treturn false; // don't submit the form\n\t\t\t\tcase 27: $.datepicker._hideDatepicker();\n\t\t\t\t\t\tbreak; // hide on escape\n\t\t\t\tcase 33: $.datepicker._adjustDate( event.target, ( event.ctrlKey ?\n\t\t\t\t\t\t\t-$.datepicker._get( inst, \"stepBigMonths\" ) :\n\t\t\t\t\t\t\t-$.datepicker._get( inst, \"stepMonths\" ) ), \"M\" );\n\t\t\t\t\t\tbreak; // previous month/year on page up/+ ctrl\n\t\t\t\tcase 34: $.datepicker._adjustDate( event.target, ( event.ctrlKey ?\n\t\t\t\t\t\t\t+$.datepicker._get( inst, \"stepBigMonths\" ) :\n\t\t\t\t\t\t\t+$.datepicker._get( inst, \"stepMonths\" ) ), \"M\" );\n\t\t\t\t\t\tbreak; // next month/year on page down/+ ctrl\n\t\t\t\tcase 35: if ( event.ctrlKey || event.metaKey ) {\n\t\t\t\t\t\t\t$.datepicker._clearDate( event.target );\n\t\t\t\t\t\t}\n\t\t\t\t\t\thandled = event.ctrlKey || event.metaKey;\n\t\t\t\t\t\tbreak; // clear on ctrl or command +end\n\t\t\t\tcase 36: if ( event.ctrlKey || event.metaKey ) {\n\t\t\t\t\t\t\t$.datepicker._gotoToday( event.target );\n\t\t\t\t\t\t}\n\t\t\t\t\t\thandled = event.ctrlKey || event.metaKey;\n\t\t\t\t\t\tbreak; // current on ctrl or command +home\n\t\t\t\tcase 37: if ( event.ctrlKey || event.metaKey ) {\n\t\t\t\t\t\t\t$.datepicker._adjustDate( event.target, ( isRTL ? +1 : -1 ), \"D\" );\n\t\t\t\t\t\t}\n\t\t\t\t\t\thandled = event.ctrlKey || event.metaKey;\n\n\t\t\t\t\t\t// -1 day on ctrl or command +left\n\t\t\t\t\t\tif ( event.originalEvent.altKey ) {\n\t\t\t\t\t\t\t$.datepicker._adjustDate( event.target, ( event.ctrlKey ?\n\t\t\t\t\t\t\t\t-$.datepicker._get( inst, \"stepBigMonths\" ) :\n\t\t\t\t\t\t\t\t-$.datepicker._get( inst, \"stepMonths\" ) ), \"M\" );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// next month/year on alt +left on Mac\n\t\t\t\t\t\tbreak;\n\t\t\t\tcase 38: if ( event.ctrlKey || event.metaKey ) {\n\t\t\t\t\t\t\t$.datepicker._adjustDate( event.target, -7, \"D\" );\n\t\t\t\t\t\t}\n\t\t\t\t\t\thandled = event.ctrlKey || event.metaKey;\n\t\t\t\t\t\tbreak; // -1 week on ctrl or command +up\n\t\t\t\tcase 39: if ( event.ctrlKey || event.metaKey ) {\n\t\t\t\t\t\t\t$.datepicker._adjustDate( event.target, ( isRTL ? -1 : +1 ), \"D\" );\n\t\t\t\t\t\t}\n\t\t\t\t\t\thandled = event.ctrlKey || event.metaKey;\n\n\t\t\t\t\t\t// +1 day on ctrl or command +right\n\t\t\t\t\t\tif ( event.originalEvent.altKey ) {\n\t\t\t\t\t\t\t$.datepicker._adjustDate( event.target, ( event.ctrlKey ?\n\t\t\t\t\t\t\t\t+$.datepicker._get( inst, \"stepBigMonths\" ) :\n\t\t\t\t\t\t\t\t+$.datepicker._get( inst, \"stepMonths\" ) ), \"M\" );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\t// next month/year on alt +right\n\t\t\t\t\t\tbreak;\n\t\t\t\tcase 40: if ( event.ctrlKey || event.metaKey ) {\n\t\t\t\t\t\t\t$.datepicker._adjustDate( event.target, +7, \"D\" );\n\t\t\t\t\t\t}\n\t\t\t\t\t\thandled = event.ctrlKey || event.metaKey;\n\t\t\t\t\t\tbreak; // +1 week on ctrl or command +down\n\t\t\t\tdefault: handled = false;\n\t\t\t}\n\t\t} else if ( event.keyCode === 36 && event.ctrlKey ) { // display the date picker on ctrl+home\n\t\t\t$.datepicker._showDatepicker( this );\n\t\t} else {\n\t\t\thandled = false;\n\t\t}\n\n\t\tif ( handled ) {\n\t\t\tevent.preventDefault();\n\t\t\tevent.stopPropagation();\n\t\t}\n\t},\n\n\t/* Filter entered characters - based on date format. */\n\t_doKeyPress: function( event ) {\n\t\tvar chars, chr,\n\t\t\tinst = $.datepicker._getInst( event.target );\n\n\t\tif ( $.datepicker._get( inst, \"constrainInput\" ) ) {\n\t\t\tchars = $.datepicker._possibleChars( $.datepicker._get( inst, \"dateFormat\" ) );\n\t\t\tchr = String.fromCharCode( event.charCode == null ? event.keyCode : event.charCode );\n\t\t\treturn event.ctrlKey || event.metaKey || ( chr < \" \" || !chars || chars.indexOf( chr ) > -1 );\n\t\t}\n\t},\n\n\t/* Synchronise manual entry and field/alternate field. */\n\t_doKeyUp: function( event ) {\n\t\tvar date,\n\t\t\tinst = $.datepicker._getInst( event.target );\n\n\t\tif ( inst.input.val() !== inst.lastVal ) {\n\t\t\ttry {\n\t\t\t\tdate = $.datepicker.parseDate( $.datepicker._get( inst, \"dateFormat\" ),\n\t\t\t\t\t( inst.input ? inst.input.val() : null ),\n\t\t\t\t\t$.datepicker._getFormatConfig( inst ) );\n\n\t\t\t\tif ( date ) { // only if valid\n\t\t\t\t\t$.datepicker._setDateFromField( inst );\n\t\t\t\t\t$.datepicker._updateAlternate( inst );\n\t\t\t\t\t$.datepicker._updateDatepicker( inst );\n\t\t\t\t}\n\t\t\t} catch ( err ) {\n\t\t\t}\n\t\t}\n\t\treturn true;\n\t},\n\n\t/* Pop-up the date picker for a given input field.\n\t * If false returned from beforeShow event handler do not show.\n\t * @param  input  element - the input field attached to the date picker or\n\t *\t\t\t\t\tevent - if triggered by focus\n\t */\n\t_showDatepicker: function( input ) {\n\t\tinput = input.target || input;\n\t\tif ( input.nodeName.toLowerCase() !== \"input\" ) { // find from button/image trigger\n\t\t\tinput = $( \"input\", input.parentNode )[ 0 ];\n\t\t}\n\n\t\tif ( $.datepicker._isDisabledDatepicker( input ) || $.datepicker._lastInput === input ) { // already here\n\t\t\treturn;\n\t\t}\n\n\t\tvar inst, beforeShow, beforeShowSettings, isFixed,\n\t\t\toffset, showAnim, duration;\n\n\t\tinst = $.datepicker._getInst( input );\n\t\tif ( $.datepicker._curInst && $.datepicker._curInst !== inst ) {\n\t\t\t$.datepicker._curInst.dpDiv.stop( true, true );\n\t\t\tif ( inst && $.datepicker._datepickerShowing ) {\n\t\t\t\t$.datepicker._hideDatepicker( $.datepicker._curInst.input[ 0 ] );\n\t\t\t}\n\t\t}\n\n\t\tbeforeShow = $.datepicker._get( inst, \"beforeShow\" );\n\t\tbeforeShowSettings = beforeShow ? beforeShow.apply( input, [ input, inst ] ) : {};\n\t\tif ( beforeShowSettings === false ) {\n\t\t\treturn;\n\t\t}\n\t\tdatepicker_extendRemove( inst.settings, beforeShowSettings );\n\n\t\tinst.lastVal = null;\n\t\t$.datepicker._lastInput = input;\n\t\t$.datepicker._setDateFromField( inst );\n\n\t\tif ( $.datepicker._inDialog ) { // hide cursor\n\t\t\tinput.value = \"\";\n\t\t}\n\t\tif ( !$.datepicker._pos ) { // position below input\n\t\t\t$.datepicker._pos = $.datepicker._findPos( input );\n\t\t\t$.datepicker._pos[ 1 ] += input.offsetHeight; // add the height\n\t\t}\n\n\t\tisFixed = false;\n\t\t$( input ).parents().each( function() {\n\t\t\tisFixed |= $( this ).css( \"position\" ) === \"fixed\";\n\t\t\treturn !isFixed;\n\t\t} );\n\n\t\toffset = { left: $.datepicker._pos[ 0 ], top: $.datepicker._pos[ 1 ] };\n\t\t$.datepicker._pos = null;\n\n\t\t//to avoid flashes on Firefox\n\t\tinst.dpDiv.empty();\n\n\t\t// determine sizing offscreen\n\t\tinst.dpDiv.css( { position: \"absolute\", display: \"block\", top: \"-1000px\" } );\n\t\t$.datepicker._updateDatepicker( inst );\n\n\t\t// fix width for dynamic number of date pickers\n\t\t// and adjust position before showing\n\t\toffset = $.datepicker._checkOffset( inst, offset, isFixed );\n\t\tinst.dpDiv.css( { position: ( $.datepicker._inDialog && $.blockUI ?\n\t\t\t\"static\" : ( isFixed ? \"fixed\" : \"absolute\" ) ), display: \"none\",\n\t\t\tleft: offset.left + \"px\", top: offset.top + \"px\" } );\n\n\t\tif ( !inst.inline ) {\n\t\t\tshowAnim = $.datepicker._get( inst, \"showAnim\" );\n\t\t\tduration = $.datepicker._get( inst, \"duration\" );\n\t\t\tinst.dpDiv.css( \"z-index\", datepicker_getZindex( $( input ) ) + 1 );\n\t\t\t$.datepicker._datepickerShowing = true;\n\n\t\t\tif ( $.effects && $.effects.effect[ showAnim ] ) {\n\t\t\t\tinst.dpDiv.show( showAnim, $.datepicker._get( inst, \"showOptions\" ), duration );\n\t\t\t} else {\n\t\t\t\tinst.dpDiv[ showAnim || \"show\" ]( showAnim ? duration : null );\n\t\t\t}\n\n\t\t\tif ( $.datepicker._shouldFocusInput( inst ) ) {\n\t\t\t\tinst.input.trigger( \"focus\" );\n\t\t\t}\n\n\t\t\t$.datepicker._curInst = inst;\n\t\t}\n\t},\n\n\t/* Generate the date picker content. */\n\t_updateDatepicker: function( inst ) {\n\t\tthis.maxRows = 4; //Reset the max number of rows being displayed (see #7043)\n\t\tdatepicker_instActive = inst; // for delegate hover events\n\t\tinst.dpDiv.empty().append( this._generateHTML( inst ) );\n\t\tthis._attachHandlers( inst );\n\n\t\tvar origyearshtml,\n\t\t\tnumMonths = this._getNumberOfMonths( inst ),\n\t\t\tcols = numMonths[ 1 ],\n\t\t\twidth = 17,\n\t\t\tactiveCell = inst.dpDiv.find( \".\" + this._dayOverClass + \" a\" ),\n\t\t\tonUpdateDatepicker = $.datepicker._get( inst, \"onUpdateDatepicker\" );\n\n\t\tif ( activeCell.length > 0 ) {\n\t\t\tdatepicker_handleMouseover.apply( activeCell.get( 0 ) );\n\t\t}\n\n\t\tinst.dpDiv.removeClass( \"ui-datepicker-multi-2 ui-datepicker-multi-3 ui-datepicker-multi-4\" ).width( \"\" );\n\t\tif ( cols > 1 ) {\n\t\t\tinst.dpDiv.addClass( \"ui-datepicker-multi-\" + cols ).css( \"width\", ( width * cols ) + \"em\" );\n\t\t}\n\t\tinst.dpDiv[ ( numMonths[ 0 ] !== 1 || numMonths[ 1 ] !== 1 ? \"add\" : \"remove\" ) +\n\t\t\t\"Class\" ]( \"ui-datepicker-multi\" );\n\t\tinst.dpDiv[ ( this._get( inst, \"isRTL\" ) ? \"add\" : \"remove\" ) +\n\t\t\t\"Class\" ]( \"ui-datepicker-rtl\" );\n\n\t\tif ( inst === $.datepicker._curInst && $.datepicker._datepickerShowing && $.datepicker._shouldFocusInput( inst ) ) {\n\t\t\tinst.input.trigger( \"focus\" );\n\t\t}\n\n\t\t// Deffered render of the years select (to avoid flashes on Firefox)\n\t\tif ( inst.yearshtml ) {\n\t\t\torigyearshtml = inst.yearshtml;\n\t\t\tsetTimeout( function() {\n\n\t\t\t\t//assure that inst.yearshtml didn't change.\n\t\t\t\tif ( origyearshtml === inst.yearshtml && inst.yearshtml ) {\n\t\t\t\t\tinst.dpDiv.find( \"select.ui-datepicker-year\" ).first().replaceWith( inst.yearshtml );\n\t\t\t\t}\n\t\t\t\torigyearshtml = inst.yearshtml = null;\n\t\t\t}, 0 );\n\t\t}\n\n\t\tif ( onUpdateDatepicker ) {\n\t\t\tonUpdateDatepicker.apply( ( inst.input ? inst.input[ 0 ] : null ), [ inst ] );\n\t\t}\n\t},\n\n\t// #6694 - don't focus the input if it's already focused\n\t// this breaks the change event in IE\n\t// Support: IE and jQuery <1.9\n\t_shouldFocusInput: function( inst ) {\n\t\treturn inst.input && inst.input.is( \":visible\" ) && !inst.input.is( \":disabled\" ) && !inst.input.is( \":focus\" );\n\t},\n\n\t/* Check positioning to remain on screen. */\n\t_checkOffset: function( inst, offset, isFixed ) {\n\t\tvar dpWidth = inst.dpDiv.outerWidth(),\n\t\t\tdpHeight = inst.dpDiv.outerHeight(),\n\t\t\tinputWidth = inst.input ? inst.input.outerWidth() : 0,\n\t\t\tinputHeight = inst.input ? inst.input.outerHeight() : 0,\n\t\t\tviewWidth = document.documentElement.clientWidth + ( isFixed ? 0 : $( document ).scrollLeft() ),\n\t\t\tviewHeight = document.documentElement.clientHeight + ( isFixed ? 0 : $( document ).scrollTop() );\n\n\t\toffset.left -= ( this._get( inst, \"isRTL\" ) ? ( dpWidth - inputWidth ) : 0 );\n\t\toffset.left -= ( isFixed && offset.left === inst.input.offset().left ) ? $( document ).scrollLeft() : 0;\n\t\toffset.top -= ( isFixed && offset.top === ( inst.input.offset().top + inputHeight ) ) ? $( document ).scrollTop() : 0;\n\n\t\t// Now check if datepicker is showing outside window viewport - move to a better place if so.\n\t\toffset.left -= Math.min( offset.left, ( offset.left + dpWidth > viewWidth && viewWidth > dpWidth ) ?\n\t\t\tMath.abs( offset.left + dpWidth - viewWidth ) : 0 );\n\t\toffset.top -= Math.min( offset.top, ( offset.top + dpHeight > viewHeight && viewHeight > dpHeight ) ?\n\t\t\tMath.abs( dpHeight + inputHeight ) : 0 );\n\n\t\treturn offset;\n\t},\n\n\t/* Find an object's position on the screen. */\n\t_findPos: function( obj ) {\n\t\tvar position,\n\t\t\tinst = this._getInst( obj ),\n\t\t\tisRTL = this._get( inst, \"isRTL\" );\n\n\t\twhile ( obj && ( obj.type === \"hidden\" || obj.nodeType !== 1 || $.expr.pseudos.hidden( obj ) ) ) {\n\t\t\tobj = obj[ isRTL ? \"previousSibling\" : \"nextSibling\" ];\n\t\t}\n\n\t\tposition = $( obj ).offset();\n\t\treturn [ position.left, position.top ];\n\t},\n\n\t/* Hide the date picker from view.\n\t * @param  input  element - the input field attached to the date picker\n\t */\n\t_hideDatepicker: function( input ) {\n\t\tvar showAnim, duration, postProcess, onClose,\n\t\t\tinst = this._curInst;\n\n\t\tif ( !inst || ( input && inst !== $.data( input, \"datepicker\" ) ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tif ( this._datepickerShowing ) {\n\t\t\tshowAnim = this._get( inst, \"showAnim\" );\n\t\t\tduration = this._get( inst, \"duration\" );\n\t\t\tpostProcess = function() {\n\t\t\t\t$.datepicker._tidyDialog( inst );\n\t\t\t};\n\n\t\t\t// DEPRECATED: after BC for 1.8.x $.effects[ showAnim ] is not needed\n\t\t\tif ( $.effects && ( $.effects.effect[ showAnim ] || $.effects[ showAnim ] ) ) {\n\t\t\t\tinst.dpDiv.hide( showAnim, $.datepicker._get( inst, \"showOptions\" ), duration, postProcess );\n\t\t\t} else {\n\t\t\t\tinst.dpDiv[ ( showAnim === \"slideDown\" ? \"slideUp\" :\n\t\t\t\t\t( showAnim === \"fadeIn\" ? \"fadeOut\" : \"hide\" ) ) ]( ( showAnim ? duration : null ), postProcess );\n\t\t\t}\n\n\t\t\tif ( !showAnim ) {\n\t\t\t\tpostProcess();\n\t\t\t}\n\t\t\tthis._datepickerShowing = false;\n\n\t\t\tonClose = this._get( inst, \"onClose\" );\n\t\t\tif ( onClose ) {\n\t\t\t\tonClose.apply( ( inst.input ? inst.input[ 0 ] : null ), [ ( inst.input ? inst.input.val() : \"\" ), inst ] );\n\t\t\t}\n\n\t\t\tthis._lastInput = null;\n\t\t\tif ( this._inDialog ) {\n\t\t\t\tthis._dialogInput.css( { position: \"absolute\", left: \"0\", top: \"-100px\" } );\n\t\t\t\tif ( $.blockUI ) {\n\t\t\t\t\t$.unblockUI();\n\t\t\t\t\t$( \"body\" ).append( this.dpDiv );\n\t\t\t\t}\n\t\t\t}\n\t\t\tthis._inDialog = false;\n\t\t}\n\t},\n\n\t/* Tidy up after a dialog display. */\n\t_tidyDialog: function( inst ) {\n\t\tinst.dpDiv.removeClass( this._dialogClass ).off( \".ui-datepicker-calendar\" );\n\t},\n\n\t/* Close date picker if clicked elsewhere. */\n\t_checkExternalClick: function( event ) {\n\t\tif ( !$.datepicker._curInst ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar $target = $( event.target ),\n\t\t\tinst = $.datepicker._getInst( $target[ 0 ] );\n\n\t\tif ( ( ( $target[ 0 ].id !== $.datepicker._mainDivId &&\n\t\t\t\t$target.parents( \"#\" + $.datepicker._mainDivId ).length === 0 &&\n\t\t\t\t!$target.hasClass( $.datepicker.markerClassName ) &&\n\t\t\t\t!$target.closest( \".\" + $.datepicker._triggerClass ).length &&\n\t\t\t\t$.datepicker._datepickerShowing && !( $.datepicker._inDialog && $.blockUI ) ) ) ||\n\t\t\t( $target.hasClass( $.datepicker.markerClassName ) && $.datepicker._curInst !== inst ) ) {\n\t\t\t\t$.datepicker._hideDatepicker();\n\t\t}\n\t},\n\n\t/* Adjust one of the date sub-fields. */\n\t_adjustDate: function( id, offset, period ) {\n\t\tvar target = $( id ),\n\t\t\tinst = this._getInst( target[ 0 ] );\n\n\t\tif ( this._isDisabledDatepicker( target[ 0 ] ) ) {\n\t\t\treturn;\n\t\t}\n\t\tthis._adjustInstDate( inst, offset, period );\n\t\tthis._updateDatepicker( inst );\n\t},\n\n\t/* Action for current link. */\n\t_gotoToday: function( id ) {\n\t\tvar date,\n\t\t\ttarget = $( id ),\n\t\t\tinst = this._getInst( target[ 0 ] );\n\n\t\tif ( this._get( inst, \"gotoCurrent\" ) && inst.currentDay ) {\n\t\t\tinst.selectedDay = inst.currentDay;\n\t\t\tinst.drawMonth = inst.selectedMonth = inst.currentMonth;\n\t\t\tinst.drawYear = inst.selectedYear = inst.currentYear;\n\t\t} else {\n\t\t\tdate = new Date();\n\t\t\tinst.selectedDay = date.getDate();\n\t\t\tinst.drawMonth = inst.selectedMonth = date.getMonth();\n\t\t\tinst.drawYear = inst.selectedYear = date.getFullYear();\n\t\t}\n\t\tthis._notifyChange( inst );\n\t\tthis._adjustDate( target );\n\t},\n\n\t/* Action for selecting a new month/year. */\n\t_selectMonthYear: function( id, select, period ) {\n\t\tvar target = $( id ),\n\t\t\tinst = this._getInst( target[ 0 ] );\n\n\t\tinst[ \"selected\" + ( period === \"M\" ? \"Month\" : \"Year\" ) ] =\n\t\tinst[ \"draw\" + ( period === \"M\" ? \"Month\" : \"Year\" ) ] =\n\t\t\tparseInt( select.options[ select.selectedIndex ].value, 10 );\n\n\t\tthis._notifyChange( inst );\n\t\tthis._adjustDate( target );\n\t},\n\n\t/* Action for selecting a day. */\n\t_selectDay: function( id, month, year, td ) {\n\t\tvar inst,\n\t\t\ttarget = $( id );\n\n\t\tif ( $( td ).hasClass( this._unselectableClass ) || this._isDisabledDatepicker( target[ 0 ] ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tinst = this._getInst( target[ 0 ] );\n\t\tinst.selectedDay = inst.currentDay = parseInt( $( \"a\", td ).attr( \"data-date\" ) );\n\t\tinst.selectedMonth = inst.currentMonth = month;\n\t\tinst.selectedYear = inst.currentYear = year;\n\t\tthis._selectDate( id, this._formatDate( inst,\n\t\t\tinst.currentDay, inst.currentMonth, inst.currentYear ) );\n\t},\n\n\t/* Erase the input field and hide the date picker. */\n\t_clearDate: function( id ) {\n\t\tvar target = $( id );\n\t\tthis._selectDate( target, \"\" );\n\t},\n\n\t/* Update the input field with the selected date. */\n\t_selectDate: function( id, dateStr ) {\n\t\tvar onSelect,\n\t\t\ttarget = $( id ),\n\t\t\tinst = this._getInst( target[ 0 ] );\n\n\t\tdateStr = ( dateStr != null ? dateStr : this._formatDate( inst ) );\n\t\tif ( inst.input ) {\n\t\t\tinst.input.val( dateStr );\n\t\t}\n\t\tthis._updateAlternate( inst );\n\n\t\tonSelect = this._get( inst, \"onSelect\" );\n\t\tif ( onSelect ) {\n\t\t\tonSelect.apply( ( inst.input ? inst.input[ 0 ] : null ), [ dateStr, inst ] );  // trigger custom callback\n\t\t} else if ( inst.input ) {\n\t\t\tinst.input.trigger( \"change\" ); // fire the change event\n\t\t}\n\n\t\tif ( inst.inline ) {\n\t\t\tthis._updateDatepicker( inst );\n\t\t} else {\n\t\t\tthis._hideDatepicker();\n\t\t\tthis._lastInput = inst.input[ 0 ];\n\t\t\tif ( typeof( inst.input[ 0 ] ) !== \"object\" ) {\n\t\t\t\tinst.input.trigger( \"focus\" ); // restore focus\n\t\t\t}\n\t\t\tthis._lastInput = null;\n\t\t}\n\t},\n\n\t/* Update any alternate field to synchronise with the main field. */\n\t_updateAlternate: function( inst ) {\n\t\tvar altFormat, date, dateStr,\n\t\t\taltField = this._get( inst, \"altField\" );\n\n\t\tif ( altField ) { // update alternate field too\n\t\t\taltFormat = this._get( inst, \"altFormat\" ) || this._get( inst, \"dateFormat\" );\n\t\t\tdate = this._getDate( inst );\n\t\t\tdateStr = this.formatDate( altFormat, date, this._getFormatConfig( inst ) );\n\t\t\t$( document ).find( altField ).val( dateStr );\n\t\t}\n\t},\n\n\t/* Set as beforeShowDay function to prevent selection of weekends.\n\t * @param  date  Date - the date to customise\n\t * @return [boolean, string] - is this date selectable?, what is its CSS class?\n\t */\n\tnoWeekends: function( date ) {\n\t\tvar day = date.getDay();\n\t\treturn [ ( day > 0 && day < 6 ), \"\" ];\n\t},\n\n\t/* Set as calculateWeek to determine the week of the year based on the ISO 8601 definition.\n\t * @param  date  Date - the date to get the week for\n\t * @return  number - the number of the week within the year that contains this date\n\t */\n\tiso8601Week: function( date ) {\n\t\tvar time,\n\t\t\tcheckDate = new Date( date.getTime() );\n\n\t\t// Find Thursday of this week starting on Monday\n\t\tcheckDate.setDate( checkDate.getDate() + 4 - ( checkDate.getDay() || 7 ) );\n\n\t\ttime = checkDate.getTime();\n\t\tcheckDate.setMonth( 0 ); // Compare with Jan 1\n\t\tcheckDate.setDate( 1 );\n\t\treturn Math.floor( Math.round( ( time - checkDate ) / 86400000 ) / 7 ) + 1;\n\t},\n\n\t/* Parse a string value into a date object.\n\t * See formatDate below for the possible formats.\n\t *\n\t * @param  format string - the expected format of the date\n\t * @param  value string - the date in the above format\n\t * @param  settings Object - attributes include:\n\t *\t\t\t\t\tshortYearCutoff  number - the cutoff year for determining the century (optional)\n\t *\t\t\t\t\tdayNamesShort\tstring[7] - abbreviated names of the days from Sunday (optional)\n\t *\t\t\t\t\tdayNames\t\tstring[7] - names of the days from Sunday (optional)\n\t *\t\t\t\t\tmonthNamesShort string[12] - abbreviated names of the months (optional)\n\t *\t\t\t\t\tmonthNames\t\tstring[12] - names of the months (optional)\n\t * @return  Date - the extracted date value or null if value is blank\n\t */\n\tparseDate: function( format, value, settings ) {\n\t\tif ( format == null || value == null ) {\n\t\t\tthrow \"Invalid arguments\";\n\t\t}\n\n\t\tvalue = ( typeof value === \"object\" ? value.toString() : value + \"\" );\n\t\tif ( value === \"\" ) {\n\t\t\treturn null;\n\t\t}\n\n\t\tvar iFormat, dim, extra,\n\t\t\tiValue = 0,\n\t\t\tshortYearCutoffTemp = ( settings ? settings.shortYearCutoff : null ) || this._defaults.shortYearCutoff,\n\t\t\tshortYearCutoff = ( typeof shortYearCutoffTemp !== \"string\" ? shortYearCutoffTemp :\n\t\t\t\tnew Date().getFullYear() % 100 + parseInt( shortYearCutoffTemp, 10 ) ),\n\t\t\tdayNamesShort = ( settings ? settings.dayNamesShort : null ) || this._defaults.dayNamesShort,\n\t\t\tdayNames = ( settings ? settings.dayNames : null ) || this._defaults.dayNames,\n\t\t\tmonthNamesShort = ( settings ? settings.monthNamesShort : null ) || this._defaults.monthNamesShort,\n\t\t\tmonthNames = ( settings ? settings.monthNames : null ) || this._defaults.monthNames,\n\t\t\tyear = -1,\n\t\t\tmonth = -1,\n\t\t\tday = -1,\n\t\t\tdoy = -1,\n\t\t\tliteral = false,\n\t\t\tdate,\n\n\t\t\t// Check whether a format character is doubled\n\t\t\tlookAhead = function( match ) {\n\t\t\t\tvar matches = ( iFormat + 1 < format.length && format.charAt( iFormat + 1 ) === match );\n\t\t\t\tif ( matches ) {\n\t\t\t\t\tiFormat++;\n\t\t\t\t}\n\t\t\t\treturn matches;\n\t\t\t},\n\n\t\t\t// Extract a number from the string value\n\t\t\tgetNumber = function( match ) {\n\t\t\t\tvar isDoubled = lookAhead( match ),\n\t\t\t\t\tsize = ( match === \"@\" ? 14 : ( match === \"!\" ? 20 :\n\t\t\t\t\t( match === \"y\" && isDoubled ? 4 : ( match === \"o\" ? 3 : 2 ) ) ) ),\n\t\t\t\t\tminSize = ( match === \"y\" ? size : 1 ),\n\t\t\t\t\tdigits = new RegExp( \"^\\\\d{\" + minSize + \",\" + size + \"}\" ),\n\t\t\t\t\tnum = value.substring( iValue ).match( digits );\n\t\t\t\tif ( !num ) {\n\t\t\t\t\tthrow \"Missing number at position \" + iValue;\n\t\t\t\t}\n\t\t\t\tiValue += num[ 0 ].length;\n\t\t\t\treturn parseInt( num[ 0 ], 10 );\n\t\t\t},\n\n\t\t\t// Extract a name from the string value and convert to an index\n\t\t\tgetName = function( match, shortNames, longNames ) {\n\t\t\t\tvar index = -1,\n\t\t\t\t\tnames = $.map( lookAhead( match ) ? longNames : shortNames, function( v, k ) {\n\t\t\t\t\t\treturn [ [ k, v ] ];\n\t\t\t\t\t} ).sort( function( a, b ) {\n\t\t\t\t\t\treturn -( a[ 1 ].length - b[ 1 ].length );\n\t\t\t\t\t} );\n\n\t\t\t\t$.each( names, function( i, pair ) {\n\t\t\t\t\tvar name = pair[ 1 ];\n\t\t\t\t\tif ( value.substr( iValue, name.length ).toLowerCase() === name.toLowerCase() ) {\n\t\t\t\t\t\tindex = pair[ 0 ];\n\t\t\t\t\t\tiValue += name.length;\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t}\n\t\t\t\t} );\n\t\t\t\tif ( index !== -1 ) {\n\t\t\t\t\treturn index + 1;\n\t\t\t\t} else {\n\t\t\t\t\tthrow \"Unknown name at position \" + iValue;\n\t\t\t\t}\n\t\t\t},\n\n\t\t\t// Confirm that a literal character matches the string value\n\t\t\tcheckLiteral = function() {\n\t\t\t\tif ( value.charAt( iValue ) !== format.charAt( iFormat ) ) {\n\t\t\t\t\tthrow \"Unexpected literal at position \" + iValue;\n\t\t\t\t}\n\t\t\t\tiValue++;\n\t\t\t};\n\n\t\tfor ( iFormat = 0; iFormat < format.length; iFormat++ ) {\n\t\t\tif ( literal ) {\n\t\t\t\tif ( format.charAt( iFormat ) === \"'\" && !lookAhead( \"'\" ) ) {\n\t\t\t\t\tliteral = false;\n\t\t\t\t} else {\n\t\t\t\t\tcheckLiteral();\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tswitch ( format.charAt( iFormat ) ) {\n\t\t\t\t\tcase \"d\":\n\t\t\t\t\t\tday = getNumber( \"d\" );\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"D\":\n\t\t\t\t\t\tgetName( \"D\", dayNamesShort, dayNames );\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"o\":\n\t\t\t\t\t\tdoy = getNumber( \"o\" );\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"m\":\n\t\t\t\t\t\tmonth = getNumber( \"m\" );\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"M\":\n\t\t\t\t\t\tmonth = getName( \"M\", monthNamesShort, monthNames );\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"y\":\n\t\t\t\t\t\tyear = getNumber( \"y\" );\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"@\":\n\t\t\t\t\t\tdate = new Date( getNumber( \"@\" ) );\n\t\t\t\t\t\tyear = date.getFullYear();\n\t\t\t\t\t\tmonth = date.getMonth() + 1;\n\t\t\t\t\t\tday = date.getDate();\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"!\":\n\t\t\t\t\t\tdate = new Date( ( getNumber( \"!\" ) - this._ticksTo1970 ) / 10000 );\n\t\t\t\t\t\tyear = date.getFullYear();\n\t\t\t\t\t\tmonth = date.getMonth() + 1;\n\t\t\t\t\t\tday = date.getDate();\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"'\":\n\t\t\t\t\t\tif ( lookAhead( \"'\" ) ) {\n\t\t\t\t\t\t\tcheckLiteral();\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tliteral = true;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tdefault:\n\t\t\t\t\t\tcheckLiteral();\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\n\t\tif ( iValue < value.length ) {\n\t\t\textra = value.substr( iValue );\n\t\t\tif ( !/^\\s+/.test( extra ) ) {\n\t\t\t\tthrow \"Extra/unparsed characters found in date: \" + extra;\n\t\t\t}\n\t\t}\n\n\t\tif ( year === -1 ) {\n\t\t\tyear = new Date().getFullYear();\n\t\t} else if ( year < 100 ) {\n\t\t\tyear += new Date().getFullYear() - new Date().getFullYear() % 100 +\n\t\t\t\t( year <= shortYearCutoff ? 0 : -100 );\n\t\t}\n\n\t\tif ( doy > -1 ) {\n\t\t\tmonth = 1;\n\t\t\tday = doy;\n\t\t\tdo {\n\t\t\t\tdim = this._getDaysInMonth( year, month - 1 );\n\t\t\t\tif ( day <= dim ) {\n\t\t\t\t\tbreak;\n\t\t\t\t}\n\t\t\t\tmonth++;\n\t\t\t\tday -= dim;\n\t\t\t} while ( true );\n\t\t}\n\n\t\tdate = this._daylightSavingAdjust( new Date( year, month - 1, day ) );\n\t\tif ( date.getFullYear() !== year || date.getMonth() + 1 !== month || date.getDate() !== day ) {\n\t\t\tthrow \"Invalid date\"; // E.g. 31/02/00\n\t\t}\n\t\treturn date;\n\t},\n\n\t/* Standard date formats. */\n\tATOM: \"yy-mm-dd\", // RFC 3339 (ISO 8601)\n\tCOOKIE: \"D, dd M yy\",\n\tISO_8601: \"yy-mm-dd\",\n\tRFC_822: \"D, d M y\",\n\tRFC_850: \"DD, dd-M-y\",\n\tRFC_1036: \"D, d M y\",\n\tRFC_1123: \"D, d M yy\",\n\tRFC_2822: \"D, d M yy\",\n\tRSS: \"D, d M y\", // RFC 822\n\tTICKS: \"!\",\n\tTIMESTAMP: \"@\",\n\tW3C: \"yy-mm-dd\", // ISO 8601\n\n\t_ticksTo1970: ( ( ( 1970 - 1 ) * 365 + Math.floor( 1970 / 4 ) - Math.floor( 1970 / 100 ) +\n\t\tMath.floor( 1970 / 400 ) ) * 24 * 60 * 60 * 10000000 ),\n\n\t/* Format a date object into a string value.\n\t * The format can be combinations of the following:\n\t * d  - day of month (no leading zero)\n\t * dd - day of month (two digit)\n\t * o  - day of year (no leading zeros)\n\t * oo - day of year (three digit)\n\t * D  - day name short\n\t * DD - day name long\n\t * m  - month of year (no leading zero)\n\t * mm - month of year (two digit)\n\t * M  - month name short\n\t * MM - month name long\n\t * y  - year (two digit)\n\t * yy - year (four digit)\n\t * @ - Unix timestamp (ms since 01/01/1970)\n\t * ! - Windows ticks (100ns since 01/01/0001)\n\t * \"...\" - literal text\n\t * '' - single quote\n\t *\n\t * @param  format string - the desired format of the date\n\t * @param  date Date - the date value to format\n\t * @param  settings Object - attributes include:\n\t *\t\t\t\t\tdayNamesShort\tstring[7] - abbreviated names of the days from Sunday (optional)\n\t *\t\t\t\t\tdayNames\t\tstring[7] - names of the days from Sunday (optional)\n\t *\t\t\t\t\tmonthNamesShort string[12] - abbreviated names of the months (optional)\n\t *\t\t\t\t\tmonthNames\t\tstring[12] - names of the months (optional)\n\t * @return  string - the date in the above format\n\t */\n\tformatDate: function( format, date, settings ) {\n\t\tif ( !date ) {\n\t\t\treturn \"\";\n\t\t}\n\n\t\tvar iFormat,\n\t\t\tdayNamesShort = ( settings ? settings.dayNamesShort : null ) || this._defaults.dayNamesShort,\n\t\t\tdayNames = ( settings ? settings.dayNames : null ) || this._defaults.dayNames,\n\t\t\tmonthNamesShort = ( settings ? settings.monthNamesShort : null ) || this._defaults.monthNamesShort,\n\t\t\tmonthNames = ( settings ? settings.monthNames : null ) || this._defaults.monthNames,\n\n\t\t\t// Check whether a format character is doubled\n\t\t\tlookAhead = function( match ) {\n\t\t\t\tvar matches = ( iFormat + 1 < format.length && format.charAt( iFormat + 1 ) === match );\n\t\t\t\tif ( matches ) {\n\t\t\t\t\tiFormat++;\n\t\t\t\t}\n\t\t\t\treturn matches;\n\t\t\t},\n\n\t\t\t// Format a number, with leading zero if necessary\n\t\t\tformatNumber = function( match, value, len ) {\n\t\t\t\tvar num = \"\" + value;\n\t\t\t\tif ( lookAhead( match ) ) {\n\t\t\t\t\twhile ( num.length < len ) {\n\t\t\t\t\t\tnum = \"0\" + num;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t\treturn num;\n\t\t\t},\n\n\t\t\t// Format a name, short or long as requested\n\t\t\tformatName = function( match, value, shortNames, longNames ) {\n\t\t\t\treturn ( lookAhead( match ) ? longNames[ value ] : shortNames[ value ] );\n\t\t\t},\n\t\t\toutput = \"\",\n\t\t\tliteral = false;\n\n\t\tif ( date ) {\n\t\t\tfor ( iFormat = 0; iFormat < format.length; iFormat++ ) {\n\t\t\t\tif ( literal ) {\n\t\t\t\t\tif ( format.charAt( iFormat ) === \"'\" && !lookAhead( \"'\" ) ) {\n\t\t\t\t\t\tliteral = false;\n\t\t\t\t\t} else {\n\t\t\t\t\t\toutput += format.charAt( iFormat );\n\t\t\t\t\t}\n\t\t\t\t} else {\n\t\t\t\t\tswitch ( format.charAt( iFormat ) ) {\n\t\t\t\t\t\tcase \"d\":\n\t\t\t\t\t\t\toutput += formatNumber( \"d\", date.getDate(), 2 );\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"D\":\n\t\t\t\t\t\t\toutput += formatName( \"D\", date.getDay(), dayNamesShort, dayNames );\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"o\":\n\t\t\t\t\t\t\toutput += formatNumber( \"o\",\n\t\t\t\t\t\t\t\tMath.round( ( new Date( date.getFullYear(), date.getMonth(), date.getDate() ).getTime() - new Date( date.getFullYear(), 0, 0 ).getTime() ) / 86400000 ), 3 );\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"m\":\n\t\t\t\t\t\t\toutput += formatNumber( \"m\", date.getMonth() + 1, 2 );\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"M\":\n\t\t\t\t\t\t\toutput += formatName( \"M\", date.getMonth(), monthNamesShort, monthNames );\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"y\":\n\t\t\t\t\t\t\toutput += ( lookAhead( \"y\" ) ? date.getFullYear() :\n\t\t\t\t\t\t\t\t( date.getFullYear() % 100 < 10 ? \"0\" : \"\" ) + date.getFullYear() % 100 );\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"@\":\n\t\t\t\t\t\t\toutput += date.getTime();\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"!\":\n\t\t\t\t\t\t\toutput += date.getTime() * 10000 + this._ticksTo1970;\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"'\":\n\t\t\t\t\t\t\tif ( lookAhead( \"'\" ) ) {\n\t\t\t\t\t\t\t\toutput += \"'\";\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\tliteral = true;\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tdefault:\n\t\t\t\t\t\t\toutput += format.charAt( iFormat );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\treturn output;\n\t},\n\n\t/* Extract all possible characters from the date format. */\n\t_possibleChars: function( format ) {\n\t\tvar iFormat,\n\t\t\tchars = \"\",\n\t\t\tliteral = false,\n\n\t\t\t// Check whether a format character is doubled\n\t\t\tlookAhead = function( match ) {\n\t\t\t\tvar matches = ( iFormat + 1 < format.length && format.charAt( iFormat + 1 ) === match );\n\t\t\t\tif ( matches ) {\n\t\t\t\t\tiFormat++;\n\t\t\t\t}\n\t\t\t\treturn matches;\n\t\t\t};\n\n\t\tfor ( iFormat = 0; iFormat < format.length; iFormat++ ) {\n\t\t\tif ( literal ) {\n\t\t\t\tif ( format.charAt( iFormat ) === \"'\" && !lookAhead( \"'\" ) ) {\n\t\t\t\t\tliteral = false;\n\t\t\t\t} else {\n\t\t\t\t\tchars += format.charAt( iFormat );\n\t\t\t\t}\n\t\t\t} else {\n\t\t\t\tswitch ( format.charAt( iFormat ) ) {\n\t\t\t\t\tcase \"d\": case \"m\": case \"y\": case \"@\":\n\t\t\t\t\t\tchars += \"0123456789\";\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tcase \"D\": case \"M\":\n\t\t\t\t\t\treturn null; // Accept anything\n\t\t\t\t\tcase \"'\":\n\t\t\t\t\t\tif ( lookAhead( \"'\" ) ) {\n\t\t\t\t\t\t\tchars += \"'\";\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\tliteral = true;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tbreak;\n\t\t\t\t\tdefault:\n\t\t\t\t\t\tchars += format.charAt( iFormat );\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\treturn chars;\n\t},\n\n\t/* Get a setting value, defaulting if necessary. */\n\t_get: function( inst, name ) {\n\t\treturn inst.settings[ name ] !== undefined ?\n\t\t\tinst.settings[ name ] : this._defaults[ name ];\n\t},\n\n\t/* Parse existing date and initialise date picker. */\n\t_setDateFromField: function( inst, noDefault ) {\n\t\tif ( inst.input.val() === inst.lastVal ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar dateFormat = this._get( inst, \"dateFormat\" ),\n\t\t\tdates = inst.lastVal = inst.input ? inst.input.val() : null,\n\t\t\tdefaultDate = this._getDefaultDate( inst ),\n\t\t\tdate = defaultDate,\n\t\t\tsettings = this._getFormatConfig( inst );\n\n\t\ttry {\n\t\t\tdate = this.parseDate( dateFormat, dates, settings ) || defaultDate;\n\t\t} catch ( event ) {\n\t\t\tdates = ( noDefault ? \"\" : dates );\n\t\t}\n\t\tinst.selectedDay = date.getDate();\n\t\tinst.drawMonth = inst.selectedMonth = date.getMonth();\n\t\tinst.drawYear = inst.selectedYear = date.getFullYear();\n\t\tinst.currentDay = ( dates ? date.getDate() : 0 );\n\t\tinst.currentMonth = ( dates ? date.getMonth() : 0 );\n\t\tinst.currentYear = ( dates ? date.getFullYear() : 0 );\n\t\tthis._adjustInstDate( inst );\n\t},\n\n\t/* Retrieve the default date shown on opening. */\n\t_getDefaultDate: function( inst ) {\n\t\treturn this._restrictMinMax( inst,\n\t\t\tthis._determineDate( inst, this._get( inst, \"defaultDate\" ), new Date() ) );\n\t},\n\n\t/* A date may be specified as an exact value or a relative one. */\n\t_determineDate: function( inst, date, defaultDate ) {\n\t\tvar offsetNumeric = function( offset ) {\n\t\t\t\tvar date = new Date();\n\t\t\t\tdate.setDate( date.getDate() + offset );\n\t\t\t\treturn date;\n\t\t\t},\n\t\t\toffsetString = function( offset ) {\n\t\t\t\ttry {\n\t\t\t\t\treturn $.datepicker.parseDate( $.datepicker._get( inst, \"dateFormat\" ),\n\t\t\t\t\t\toffset, $.datepicker._getFormatConfig( inst ) );\n\t\t\t\t} catch ( e ) {\n\n\t\t\t\t\t// Ignore\n\t\t\t\t}\n\n\t\t\t\tvar date = ( offset.toLowerCase().match( /^c/ ) ?\n\t\t\t\t\t$.datepicker._getDate( inst ) : null ) || new Date(),\n\t\t\t\t\tyear = date.getFullYear(),\n\t\t\t\t\tmonth = date.getMonth(),\n\t\t\t\t\tday = date.getDate(),\n\t\t\t\t\tpattern = /([+\\-]?[0-9]+)\\s*(d|D|w|W|m|M|y|Y)?/g,\n\t\t\t\t\tmatches = pattern.exec( offset );\n\n\t\t\t\twhile ( matches ) {\n\t\t\t\t\tswitch ( matches[ 2 ] || \"d\" ) {\n\t\t\t\t\t\tcase \"d\" : case \"D\" :\n\t\t\t\t\t\t\tday += parseInt( matches[ 1 ], 10 ); break;\n\t\t\t\t\t\tcase \"w\" : case \"W\" :\n\t\t\t\t\t\t\tday += parseInt( matches[ 1 ], 10 ) * 7; break;\n\t\t\t\t\t\tcase \"m\" : case \"M\" :\n\t\t\t\t\t\t\tmonth += parseInt( matches[ 1 ], 10 );\n\t\t\t\t\t\t\tday = Math.min( day, $.datepicker._getDaysInMonth( year, month ) );\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t\tcase \"y\": case \"Y\" :\n\t\t\t\t\t\t\tyear += parseInt( matches[ 1 ], 10 );\n\t\t\t\t\t\t\tday = Math.min( day, $.datepicker._getDaysInMonth( year, month ) );\n\t\t\t\t\t\t\tbreak;\n\t\t\t\t\t}\n\t\t\t\t\tmatches = pattern.exec( offset );\n\t\t\t\t}\n\t\t\t\treturn new Date( year, month, day );\n\t\t\t},\n\t\t\tnewDate = ( date == null || date === \"\" ? defaultDate : ( typeof date === \"string\" ? offsetString( date ) :\n\t\t\t\t( typeof date === \"number\" ? ( isNaN( date ) ? defaultDate : offsetNumeric( date ) ) : new Date( date.getTime() ) ) ) );\n\n\t\tnewDate = ( newDate && newDate.toString() === \"Invalid Date\" ? defaultDate : newDate );\n\t\tif ( newDate ) {\n\t\t\tnewDate.setHours( 0 );\n\t\t\tnewDate.setMinutes( 0 );\n\t\t\tnewDate.setSeconds( 0 );\n\t\t\tnewDate.setMilliseconds( 0 );\n\t\t}\n\t\treturn this._daylightSavingAdjust( newDate );\n\t},\n\n\t/* Handle switch to/from daylight saving.\n\t * Hours may be non-zero on daylight saving cut-over:\n\t * > 12 when midnight changeover, but then cannot generate\n\t * midnight datetime, so jump to 1AM, otherwise reset.\n\t * @param  date  (Date) the date to check\n\t * @return  (Date) the corrected date\n\t */\n\t_daylightSavingAdjust: function( date ) {\n\t\tif ( !date ) {\n\t\t\treturn null;\n\t\t}\n\t\tdate.setHours( date.getHours() > 12 ? date.getHours() + 2 : 0 );\n\t\treturn date;\n\t},\n\n\t/* Set the date(s) directly. */\n\t_setDate: function( inst, date, noChange ) {\n\t\tvar clear = !date,\n\t\t\torigMonth = inst.selectedMonth,\n\t\t\torigYear = inst.selectedYear,\n\t\t\tnewDate = this._restrictMinMax( inst, this._determineDate( inst, date, new Date() ) );\n\n\t\tinst.selectedDay = inst.currentDay = newDate.getDate();\n\t\tinst.drawMonth = inst.selectedMonth = inst.currentMonth = newDate.getMonth();\n\t\tinst.drawYear = inst.selectedYear = inst.currentYear = newDate.getFullYear();\n\t\tif ( ( origMonth !== inst.selectedMonth || origYear !== inst.selectedYear ) && !noChange ) {\n\t\t\tthis._notifyChange( inst );\n\t\t}\n\t\tthis._adjustInstDate( inst );\n\t\tif ( inst.input ) {\n\t\t\tinst.input.val( clear ? \"\" : this._formatDate( inst ) );\n\t\t}\n\t},\n\n\t/* Retrieve the date(s) directly. */\n\t_getDate: function( inst ) {\n\t\tvar startDate = ( !inst.currentYear || ( inst.input && inst.input.val() === \"\" ) ? null :\n\t\t\tthis._daylightSavingAdjust( new Date(\n\t\t\tinst.currentYear, inst.currentMonth, inst.currentDay ) ) );\n\t\t\treturn startDate;\n\t},\n\n\t/* Attach the onxxx handlers.  These are declared statically so\n\t * they work with static code transformers like Caja.\n\t */\n\t_attachHandlers: function( inst ) {\n\t\tvar stepMonths = this._get( inst, \"stepMonths\" ),\n\t\t\tid = \"#\" + inst.id.replace( /\\\\\\\\/g, \"\\\\\" );\n\t\tinst.dpDiv.find( \"[data-handler]\" ).map( function() {\n\t\t\tvar handler = {\n\t\t\t\tprev: function() {\n\t\t\t\t\t$.datepicker._adjustDate( id, -stepMonths, \"M\" );\n\t\t\t\t},\n\t\t\t\tnext: function() {\n\t\t\t\t\t$.datepicker._adjustDate( id, +stepMonths, \"M\" );\n\t\t\t\t},\n\t\t\t\thide: function() {\n\t\t\t\t\t$.datepicker._hideDatepicker();\n\t\t\t\t},\n\t\t\t\ttoday: function() {\n\t\t\t\t\t$.datepicker._gotoToday( id );\n\t\t\t\t},\n\t\t\t\tselectDay: function() {\n\t\t\t\t\t$.datepicker._selectDay( id, +this.getAttribute( \"data-month\" ), +this.getAttribute( \"data-year\" ), this );\n\t\t\t\t\treturn false;\n\t\t\t\t},\n\t\t\t\tselectMonth: function() {\n\t\t\t\t\t$.datepicker._selectMonthYear( id, this, \"M\" );\n\t\t\t\t\treturn false;\n\t\t\t\t},\n\t\t\t\tselectYear: function() {\n\t\t\t\t\t$.datepicker._selectMonthYear( id, this, \"Y\" );\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\t\t\t};\n\t\t\t$( this ).on( this.getAttribute( \"data-event\" ), handler[ this.getAttribute( \"data-handler\" ) ] );\n\t\t} );\n\t},\n\n\t/* Generate the HTML for the current state of the date picker. */\n\t_generateHTML: function( inst ) {\n\t\tvar maxDraw, prevText, prev, nextText, next, currentText, gotoDate,\n\t\t\tcontrols, buttonPanel, firstDay, showWeek, dayNames, dayNamesMin,\n\t\t\tmonthNames, monthNamesShort, beforeShowDay, showOtherMonths,\n\t\t\tselectOtherMonths, defaultDate, html, dow, row, group, col, selectedDate,\n\t\t\tcornerClass, calender, thead, day, daysInMonth, leadDays, curRows, numRows,\n\t\t\tprintDate, dRow, tbody, daySettings, otherMonth, unselectable,\n\t\t\ttempDate = new Date(),\n\t\t\ttoday = this._daylightSavingAdjust(\n\t\t\t\tnew Date( tempDate.getFullYear(), tempDate.getMonth(), tempDate.getDate() ) ), // clear time\n\t\t\tisRTL = this._get( inst, \"isRTL\" ),\n\t\t\tshowButtonPanel = this._get( inst, \"showButtonPanel\" ),\n\t\t\thideIfNoPrevNext = this._get( inst, \"hideIfNoPrevNext\" ),\n\t\t\tnavigationAsDateFormat = this._get( inst, \"navigationAsDateFormat\" ),\n\t\t\tnumMonths = this._getNumberOfMonths( inst ),\n\t\t\tshowCurrentAtPos = this._get( inst, \"showCurrentAtPos\" ),\n\t\t\tstepMonths = this._get( inst, \"stepMonths\" ),\n\t\t\tisMultiMonth = ( numMonths[ 0 ] !== 1 || numMonths[ 1 ] !== 1 ),\n\t\t\tcurrentDate = this._daylightSavingAdjust( ( !inst.currentDay ? new Date( 9999, 9, 9 ) :\n\t\t\t\tnew Date( inst.currentYear, inst.currentMonth, inst.currentDay ) ) ),\n\t\t\tminDate = this._getMinMaxDate( inst, \"min\" ),\n\t\t\tmaxDate = this._getMinMaxDate( inst, \"max\" ),\n\t\t\tdrawMonth = inst.drawMonth - showCurrentAtPos,\n\t\t\tdrawYear = inst.drawYear;\n\n\t\tif ( drawMonth < 0 ) {\n\t\t\tdrawMonth += 12;\n\t\t\tdrawYear--;\n\t\t}\n\t\tif ( maxDate ) {\n\t\t\tmaxDraw = this._daylightSavingAdjust( new Date( maxDate.getFullYear(),\n\t\t\t\tmaxDate.getMonth() - ( numMonths[ 0 ] * numMonths[ 1 ] ) + 1, maxDate.getDate() ) );\n\t\t\tmaxDraw = ( minDate && maxDraw < minDate ? minDate : maxDraw );\n\t\t\twhile ( this._daylightSavingAdjust( new Date( drawYear, drawMonth, 1 ) ) > maxDraw ) {\n\t\t\t\tdrawMonth--;\n\t\t\t\tif ( drawMonth < 0 ) {\n\t\t\t\t\tdrawMonth = 11;\n\t\t\t\t\tdrawYear--;\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\tinst.drawMonth = drawMonth;\n\t\tinst.drawYear = drawYear;\n\n\t\tprevText = this._get( inst, \"prevText\" );\n\t\tprevText = ( !navigationAsDateFormat ? prevText : this.formatDate( prevText,\n\t\t\tthis._daylightSavingAdjust( new Date( drawYear, drawMonth - stepMonths, 1 ) ),\n\t\t\tthis._getFormatConfig( inst ) ) );\n\n\t\tif ( this._canAdjustMonth( inst, -1, drawYear, drawMonth ) ) {\n\t\t\tprev = $( \"<a>\" )\n\t\t\t\t.attr( {\n\t\t\t\t\t\"class\": \"ui-datepicker-prev ui-corner-all\",\n\t\t\t\t\t\"data-handler\": \"prev\",\n\t\t\t\t\t\"data-event\": \"click\",\n\t\t\t\t\ttitle: prevText\n\t\t\t\t} )\n\t\t\t\t.append(\n\t\t\t\t\t$( \"<span>\" )\n\t\t\t\t\t\t.addClass( \"ui-icon ui-icon-circle-triangle-\" +\n\t\t\t\t\t\t\t( isRTL ? \"e\" : \"w\" ) )\n\t\t\t\t\t\t.text( prevText )\n\t\t\t\t)[ 0 ].outerHTML;\n\t\t} else if ( hideIfNoPrevNext ) {\n\t\t\tprev = \"\";\n\t\t} else {\n\t\t\tprev = $( \"<a>\" )\n\t\t\t\t.attr( {\n\t\t\t\t\t\"class\": \"ui-datepicker-prev ui-corner-all ui-state-disabled\",\n\t\t\t\t\ttitle: prevText\n\t\t\t\t} )\n\t\t\t\t.append(\n\t\t\t\t\t$( \"<span>\" )\n\t\t\t\t\t\t.addClass( \"ui-icon ui-icon-circle-triangle-\" +\n\t\t\t\t\t\t\t( isRTL ? \"e\" : \"w\" ) )\n\t\t\t\t\t\t.text( prevText )\n\t\t\t\t)[ 0 ].outerHTML;\n\t\t}\n\n\t\tnextText = this._get( inst, \"nextText\" );\n\t\tnextText = ( !navigationAsDateFormat ? nextText : this.formatDate( nextText,\n\t\t\tthis._daylightSavingAdjust( new Date( drawYear, drawMonth + stepMonths, 1 ) ),\n\t\t\tthis._getFormatConfig( inst ) ) );\n\n\t\tif ( this._canAdjustMonth( inst, +1, drawYear, drawMonth ) ) {\n\t\t\tnext = $( \"<a>\" )\n\t\t\t\t.attr( {\n\t\t\t\t\t\"class\": \"ui-datepicker-next ui-corner-all\",\n\t\t\t\t\t\"data-handler\": \"next\",\n\t\t\t\t\t\"data-event\": \"click\",\n\t\t\t\t\ttitle: nextText\n\t\t\t\t} )\n\t\t\t\t.append(\n\t\t\t\t\t$( \"<span>\" )\n\t\t\t\t\t\t.addClass( \"ui-icon ui-icon-circle-triangle-\" +\n\t\t\t\t\t\t\t( isRTL ? \"w\" : \"e\" ) )\n\t\t\t\t\t\t.text( nextText )\n\t\t\t\t)[ 0 ].outerHTML;\n\t\t} else if ( hideIfNoPrevNext ) {\n\t\t\tnext = \"\";\n\t\t} else {\n\t\t\tnext = $( \"<a>\" )\n\t\t\t\t.attr( {\n\t\t\t\t\t\"class\": \"ui-datepicker-next ui-corner-all ui-state-disabled\",\n\t\t\t\t\ttitle: nextText\n\t\t\t\t} )\n\t\t\t\t.append(\n\t\t\t\t\t$( \"<span>\" )\n\t\t\t\t\t\t.attr( \"class\", \"ui-icon ui-icon-circle-triangle-\" +\n\t\t\t\t\t\t\t( isRTL ? \"w\" : \"e\" ) )\n\t\t\t\t\t\t.text( nextText )\n\t\t\t\t)[ 0 ].outerHTML;\n\t\t}\n\n\t\tcurrentText = this._get( inst, \"currentText\" );\n\t\tgotoDate = ( this._get( inst, \"gotoCurrent\" ) && inst.currentDay ? currentDate : today );\n\t\tcurrentText = ( !navigationAsDateFormat ? currentText :\n\t\t\tthis.formatDate( currentText, gotoDate, this._getFormatConfig( inst ) ) );\n\n\t\tcontrols = \"\";\n\t\tif ( !inst.inline ) {\n\t\t\tcontrols = $( \"<button>\" )\n\t\t\t\t.attr( {\n\t\t\t\t\ttype: \"button\",\n\t\t\t\t\t\"class\": \"ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all\",\n\t\t\t\t\t\"data-handler\": \"hide\",\n\t\t\t\t\t\"data-event\": \"click\"\n\t\t\t\t} )\n\t\t\t\t.text( this._get( inst, \"closeText\" ) )[ 0 ].outerHTML;\n\t\t}\n\n\t\tbuttonPanel = \"\";\n\t\tif ( showButtonPanel ) {\n\t\t\tbuttonPanel = $( \"<div class='ui-datepicker-buttonpane ui-widget-content'>\" )\n\t\t\t\t.append( isRTL ? controls : \"\" )\n\t\t\t\t.append( this._isInRange( inst, gotoDate ) ?\n\t\t\t\t\t$( \"<button>\" )\n\t\t\t\t\t\t.attr( {\n\t\t\t\t\t\t\ttype: \"button\",\n\t\t\t\t\t\t\t\"class\": \"ui-datepicker-current ui-state-default ui-priority-secondary ui-corner-all\",\n\t\t\t\t\t\t\t\"data-handler\": \"today\",\n\t\t\t\t\t\t\t\"data-event\": \"click\"\n\t\t\t\t\t\t} )\n\t\t\t\t\t\t.text( currentText ) :\n\t\t\t\t\t\"\" )\n\t\t\t\t.append( isRTL ? \"\" : controls )[ 0 ].outerHTML;\n\t\t}\n\n\t\tfirstDay = parseInt( this._get( inst, \"firstDay\" ), 10 );\n\t\tfirstDay = ( isNaN( firstDay ) ? 0 : firstDay );\n\n\t\tshowWeek = this._get( inst, \"showWeek\" );\n\t\tdayNames = this._get( inst, \"dayNames\" );\n\t\tdayNamesMin = this._get( inst, \"dayNamesMin\" );\n\t\tmonthNames = this._get( inst, \"monthNames\" );\n\t\tmonthNamesShort = this._get( inst, \"monthNamesShort\" );\n\t\tbeforeShowDay = this._get( inst, \"beforeShowDay\" );\n\t\tshowOtherMonths = this._get( inst, \"showOtherMonths\" );\n\t\tselectOtherMonths = this._get( inst, \"selectOtherMonths\" );\n\t\tdefaultDate = this._getDefaultDate( inst );\n\t\thtml = \"\";\n\n\t\tfor ( row = 0; row < numMonths[ 0 ]; row++ ) {\n\t\t\tgroup = \"\";\n\t\t\tthis.maxRows = 4;\n\t\t\tfor ( col = 0; col < numMonths[ 1 ]; col++ ) {\n\t\t\t\tselectedDate = this._daylightSavingAdjust( new Date( drawYear, drawMonth, inst.selectedDay ) );\n\t\t\t\tcornerClass = \" ui-corner-all\";\n\t\t\t\tcalender = \"\";\n\t\t\t\tif ( isMultiMonth ) {\n\t\t\t\t\tcalender += \"<div class='ui-datepicker-group\";\n\t\t\t\t\tif ( numMonths[ 1 ] > 1 ) {\n\t\t\t\t\t\tswitch ( col ) {\n\t\t\t\t\t\t\tcase 0: calender += \" ui-datepicker-group-first\";\n\t\t\t\t\t\t\t\tcornerClass = \" ui-corner-\" + ( isRTL ? \"right\" : \"left\" ); break;\n\t\t\t\t\t\t\tcase numMonths[ 1 ] - 1: calender += \" ui-datepicker-group-last\";\n\t\t\t\t\t\t\t\tcornerClass = \" ui-corner-\" + ( isRTL ? \"left\" : \"right\" ); break;\n\t\t\t\t\t\t\tdefault: calender += \" ui-datepicker-group-middle\"; cornerClass = \"\"; break;\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\tcalender += \"'>\";\n\t\t\t\t}\n\t\t\t\tcalender += \"<div class='ui-datepicker-header ui-widget-header ui-helper-clearfix\" + cornerClass + \"'>\" +\n\t\t\t\t\t( /all|left/.test( cornerClass ) && row === 0 ? ( isRTL ? next : prev ) : \"\" ) +\n\t\t\t\t\t( /all|right/.test( cornerClass ) && row === 0 ? ( isRTL ? prev : next ) : \"\" ) +\n\t\t\t\t\tthis._generateMonthYearHeader( inst, drawMonth, drawYear, minDate, maxDate,\n\t\t\t\t\trow > 0 || col > 0, monthNames, monthNamesShort ) + // draw month headers\n\t\t\t\t\t\"</div><table class='ui-datepicker-calendar'><thead>\" +\n\t\t\t\t\t\"<tr>\";\n\t\t\t\tthead = ( showWeek ? \"<th class='ui-datepicker-week-col'>\" + this._get( inst, \"weekHeader\" ) + \"</th>\" : \"\" );\n\t\t\t\tfor ( dow = 0; dow < 7; dow++ ) { // days of the week\n\t\t\t\t\tday = ( dow + firstDay ) % 7;\n\t\t\t\t\tthead += \"<th scope='col'\" + ( ( dow + firstDay + 6 ) % 7 >= 5 ? \" class='ui-datepicker-week-end'\" : \"\" ) + \">\" +\n\t\t\t\t\t\t\"<span title='\" + dayNames[ day ] + \"'>\" + dayNamesMin[ day ] + \"</span></th>\";\n\t\t\t\t}\n\t\t\t\tcalender += thead + \"</tr></thead><tbody>\";\n\t\t\t\tdaysInMonth = this._getDaysInMonth( drawYear, drawMonth );\n\t\t\t\tif ( drawYear === inst.selectedYear && drawMonth === inst.selectedMonth ) {\n\t\t\t\t\tinst.selectedDay = Math.min( inst.selectedDay, daysInMonth );\n\t\t\t\t}\n\t\t\t\tleadDays = ( this._getFirstDayOfMonth( drawYear, drawMonth ) - firstDay + 7 ) % 7;\n\t\t\t\tcurRows = Math.ceil( ( leadDays + daysInMonth ) / 7 ); // calculate the number of rows to generate\n\t\t\t\tnumRows = ( isMultiMonth ? this.maxRows > curRows ? this.maxRows : curRows : curRows ); //If multiple months, use the higher number of rows (see #7043)\n\t\t\t\tthis.maxRows = numRows;\n\t\t\t\tprintDate = this._daylightSavingAdjust( new Date( drawYear, drawMonth, 1 - leadDays ) );\n\t\t\t\tfor ( dRow = 0; dRow < numRows; dRow++ ) { // create date picker rows\n\t\t\t\t\tcalender += \"<tr>\";\n\t\t\t\t\ttbody = ( !showWeek ? \"\" : \"<td class='ui-datepicker-week-col'>\" +\n\t\t\t\t\t\tthis._get( inst, \"calculateWeek\" )( printDate ) + \"</td>\" );\n\t\t\t\t\tfor ( dow = 0; dow < 7; dow++ ) { // create date picker days\n\t\t\t\t\t\tdaySettings = ( beforeShowDay ?\n\t\t\t\t\t\t\tbeforeShowDay.apply( ( inst.input ? inst.input[ 0 ] : null ), [ printDate ] ) : [ true, \"\" ] );\n\t\t\t\t\t\totherMonth = ( printDate.getMonth() !== drawMonth );\n\t\t\t\t\t\tunselectable = ( otherMonth && !selectOtherMonths ) || !daySettings[ 0 ] ||\n\t\t\t\t\t\t\t( minDate && printDate < minDate ) || ( maxDate && printDate > maxDate );\n\t\t\t\t\t\ttbody += \"<td class='\" +\n\t\t\t\t\t\t\t( ( dow + firstDay + 6 ) % 7 >= 5 ? \" ui-datepicker-week-end\" : \"\" ) + // highlight weekends\n\t\t\t\t\t\t\t( otherMonth ? \" ui-datepicker-other-month\" : \"\" ) + // highlight days from other months\n\t\t\t\t\t\t\t( ( printDate.getTime() === selectedDate.getTime() && drawMonth === inst.selectedMonth && inst._keyEvent ) || // user pressed key\n\t\t\t\t\t\t\t( defaultDate.getTime() === printDate.getTime() && defaultDate.getTime() === selectedDate.getTime() ) ?\n\n\t\t\t\t\t\t\t// or defaultDate is current printedDate and defaultDate is selectedDate\n\t\t\t\t\t\t\t\" \" + this._dayOverClass : \"\" ) + // highlight selected day\n\t\t\t\t\t\t\t( unselectable ? \" \" + this._unselectableClass + \" ui-state-disabled\" : \"\" ) +  // highlight unselectable days\n\t\t\t\t\t\t\t( otherMonth && !showOtherMonths ? \"\" : \" \" + daySettings[ 1 ] + // highlight custom dates\n\t\t\t\t\t\t\t( printDate.getTime() === currentDate.getTime() ? \" \" + this._currentClass : \"\" ) + // highlight selected day\n\t\t\t\t\t\t\t( printDate.getTime() === today.getTime() ? \" ui-datepicker-today\" : \"\" ) ) + \"'\" + // highlight today (if different)\n\t\t\t\t\t\t\t( ( !otherMonth || showOtherMonths ) && daySettings[ 2 ] ? \" title='\" + daySettings[ 2 ].replace( /'/g, \"&#39;\" ) + \"'\" : \"\" ) + // cell title\n\t\t\t\t\t\t\t( unselectable ? \"\" : \" data-handler='selectDay' data-event='click' data-month='\" + printDate.getMonth() + \"' data-year='\" + printDate.getFullYear() + \"'\" ) + \">\" + // actions\n\t\t\t\t\t\t\t( otherMonth && !showOtherMonths ? \"&#xa0;\" : // display for other months\n\t\t\t\t\t\t\t( unselectable ? \"<span class='ui-state-default'>\" + printDate.getDate() + \"</span>\" : \"<a class='ui-state-default\" +\n\t\t\t\t\t\t\t( printDate.getTime() === today.getTime() ? \" ui-state-highlight\" : \"\" ) +\n\t\t\t\t\t\t\t( printDate.getTime() === currentDate.getTime() ? \" ui-state-active\" : \"\" ) + // highlight selected day\n\t\t\t\t\t\t\t( otherMonth ? \" ui-priority-secondary\" : \"\" ) + // distinguish dates from other months\n\t\t\t\t\t\t\t\"' href='#' aria-current='\" + ( printDate.getTime() === currentDate.getTime() ? \"true\" : \"false\" ) + // mark date as selected for screen reader\n\t\t\t\t\t\t\t\"' data-date='\" + printDate.getDate() + // store date as data\n\t\t\t\t\t\t\t\"'>\" + printDate.getDate() + \"</a>\" ) ) + \"</td>\"; // display selectable date\n\t\t\t\t\t\tprintDate.setDate( printDate.getDate() + 1 );\n\t\t\t\t\t\tprintDate = this._daylightSavingAdjust( printDate );\n\t\t\t\t\t}\n\t\t\t\t\tcalender += tbody + \"</tr>\";\n\t\t\t\t}\n\t\t\t\tdrawMonth++;\n\t\t\t\tif ( drawMonth > 11 ) {\n\t\t\t\t\tdrawMonth = 0;\n\t\t\t\t\tdrawYear++;\n\t\t\t\t}\n\t\t\t\tcalender += \"</tbody></table>\" + ( isMultiMonth ? \"</div>\" +\n\t\t\t\t\t\t\t( ( numMonths[ 0 ] > 0 && col === numMonths[ 1 ] - 1 ) ? \"<div class='ui-datepicker-row-break'></div>\" : \"\" ) : \"\" );\n\t\t\t\tgroup += calender;\n\t\t\t}\n\t\t\thtml += group;\n\t\t}\n\t\thtml += buttonPanel;\n\t\tinst._keyEvent = false;\n\t\treturn html;\n\t},\n\n\t/* Generate the month and year header. */\n\t_generateMonthYearHeader: function( inst, drawMonth, drawYear, minDate, maxDate,\n\t\t\tsecondary, monthNames, monthNamesShort ) {\n\n\t\tvar inMinYear, inMaxYear, month, years, thisYear, determineYear, year, endYear,\n\t\t\tchangeMonth = this._get( inst, \"changeMonth\" ),\n\t\t\tchangeYear = this._get( inst, \"changeYear\" ),\n\t\t\tshowMonthAfterYear = this._get( inst, \"showMonthAfterYear\" ),\n\t\t\tselectMonthLabel = this._get( inst, \"selectMonthLabel\" ),\n\t\t\tselectYearLabel = this._get( inst, \"selectYearLabel\" ),\n\t\t\thtml = \"<div class='ui-datepicker-title'>\",\n\t\t\tmonthHtml = \"\";\n\n\t\t// Month selection\n\t\tif ( secondary || !changeMonth ) {\n\t\t\tmonthHtml += \"<span class='ui-datepicker-month'>\" + monthNames[ drawMonth ] + \"</span>\";\n\t\t} else {\n\t\t\tinMinYear = ( minDate && minDate.getFullYear() === drawYear );\n\t\t\tinMaxYear = ( maxDate && maxDate.getFullYear() === drawYear );\n\t\t\tmonthHtml += \"<select class='ui-datepicker-month' aria-label='\" + selectMonthLabel + \"' data-handler='selectMonth' data-event='change'>\";\n\t\t\tfor ( month = 0; month < 12; month++ ) {\n\t\t\t\tif ( ( !inMinYear || month >= minDate.getMonth() ) && ( !inMaxYear || month <= maxDate.getMonth() ) ) {\n\t\t\t\t\tmonthHtml += \"<option value='\" + month + \"'\" +\n\t\t\t\t\t\t( month === drawMonth ? \" selected='selected'\" : \"\" ) +\n\t\t\t\t\t\t\">\" + monthNamesShort[ month ] + \"</option>\";\n\t\t\t\t}\n\t\t\t}\n\t\t\tmonthHtml += \"</select>\";\n\t\t}\n\n\t\tif ( !showMonthAfterYear ) {\n\t\t\thtml += monthHtml + ( secondary || !( changeMonth && changeYear ) ? \"&#xa0;\" : \"\" );\n\t\t}\n\n\t\t// Year selection\n\t\tif ( !inst.yearshtml ) {\n\t\t\tinst.yearshtml = \"\";\n\t\t\tif ( secondary || !changeYear ) {\n\t\t\t\thtml += \"<span class='ui-datepicker-year'>\" + drawYear + \"</span>\";\n\t\t\t} else {\n\n\t\t\t\t// determine range of years to display\n\t\t\t\tyears = this._get( inst, \"yearRange\" ).split( \":\" );\n\t\t\t\tthisYear = new Date().getFullYear();\n\t\t\t\tdetermineYear = function( value ) {\n\t\t\t\t\tvar year = ( value.match( /c[+\\-].*/ ) ? drawYear + parseInt( value.substring( 1 ), 10 ) :\n\t\t\t\t\t\t( value.match( /[+\\-].*/ ) ? thisYear + parseInt( value, 10 ) :\n\t\t\t\t\t\tparseInt( value, 10 ) ) );\n\t\t\t\t\treturn ( isNaN( year ) ? thisYear : year );\n\t\t\t\t};\n\t\t\t\tyear = determineYear( years[ 0 ] );\n\t\t\t\tendYear = Math.max( year, determineYear( years[ 1 ] || \"\" ) );\n\t\t\t\tyear = ( minDate ? Math.max( year, minDate.getFullYear() ) : year );\n\t\t\t\tendYear = ( maxDate ? Math.min( endYear, maxDate.getFullYear() ) : endYear );\n\t\t\t\tinst.yearshtml += \"<select class='ui-datepicker-year' aria-label='\" + selectYearLabel + \"' data-handler='selectYear' data-event='change'>\";\n\t\t\t\tfor ( ; year <= endYear; year++ ) {\n\t\t\t\t\tinst.yearshtml += \"<option value='\" + year + \"'\" +\n\t\t\t\t\t\t( year === drawYear ? \" selected='selected'\" : \"\" ) +\n\t\t\t\t\t\t\">\" + year + \"</option>\";\n\t\t\t\t}\n\t\t\t\tinst.yearshtml += \"</select>\";\n\n\t\t\t\thtml += inst.yearshtml;\n\t\t\t\tinst.yearshtml = null;\n\t\t\t}\n\t\t}\n\n\t\thtml += this._get( inst, \"yearSuffix\" );\n\t\tif ( showMonthAfterYear ) {\n\t\t\thtml += ( secondary || !( changeMonth && changeYear ) ? \"&#xa0;\" : \"\" ) + monthHtml;\n\t\t}\n\t\thtml += \"</div>\"; // Close datepicker_header\n\t\treturn html;\n\t},\n\n\t/* Adjust one of the date sub-fields. */\n\t_adjustInstDate: function( inst, offset, period ) {\n\t\tvar year = inst.selectedYear + ( period === \"Y\" ? offset : 0 ),\n\t\t\tmonth = inst.selectedMonth + ( period === \"M\" ? offset : 0 ),\n\t\t\tday = Math.min( inst.selectedDay, this._getDaysInMonth( year, month ) ) + ( period === \"D\" ? offset : 0 ),\n\t\t\tdate = this._restrictMinMax( inst, this._daylightSavingAdjust( new Date( year, month, day ) ) );\n\n\t\tinst.selectedDay = date.getDate();\n\t\tinst.drawMonth = inst.selectedMonth = date.getMonth();\n\t\tinst.drawYear = inst.selectedYear = date.getFullYear();\n\t\tif ( period === \"M\" || period === \"Y\" ) {\n\t\t\tthis._notifyChange( inst );\n\t\t}\n\t},\n\n\t/* Ensure a date is within any min/max bounds. */\n\t_restrictMinMax: function( inst, date ) {\n\t\tvar minDate = this._getMinMaxDate( inst, \"min\" ),\n\t\t\tmaxDate = this._getMinMaxDate( inst, \"max\" ),\n\t\t\tnewDate = ( minDate && date < minDate ? minDate : date );\n\t\treturn ( maxDate && newDate > maxDate ? maxDate : newDate );\n\t},\n\n\t/* Notify change of month/year. */\n\t_notifyChange: function( inst ) {\n\t\tvar onChange = this._get( inst, \"onChangeMonthYear\" );\n\t\tif ( onChange ) {\n\t\t\tonChange.apply( ( inst.input ? inst.input[ 0 ] : null ),\n\t\t\t\t[ inst.selectedYear, inst.selectedMonth + 1, inst ] );\n\t\t}\n\t},\n\n\t/* Determine the number of months to show. */\n\t_getNumberOfMonths: function( inst ) {\n\t\tvar numMonths = this._get( inst, \"numberOfMonths\" );\n\t\treturn ( numMonths == null ? [ 1, 1 ] : ( typeof numMonths === \"number\" ? [ 1, numMonths ] : numMonths ) );\n\t},\n\n\t/* Determine the current maximum date - ensure no time components are set. */\n\t_getMinMaxDate: function( inst, minMax ) {\n\t\treturn this._determineDate( inst, this._get( inst, minMax + \"Date\" ), null );\n\t},\n\n\t/* Find the number of days in a given month. */\n\t_getDaysInMonth: function( year, month ) {\n\t\treturn 32 - this._daylightSavingAdjust( new Date( year, month, 32 ) ).getDate();\n\t},\n\n\t/* Find the day of the week of the first of a month. */\n\t_getFirstDayOfMonth: function( year, month ) {\n\t\treturn new Date( year, month, 1 ).getDay();\n\t},\n\n\t/* Determines if we should allow a \"next/prev\" month display change. */\n\t_canAdjustMonth: function( inst, offset, curYear, curMonth ) {\n\t\tvar numMonths = this._getNumberOfMonths( inst ),\n\t\t\tdate = this._daylightSavingAdjust( new Date( curYear,\n\t\t\tcurMonth + ( offset < 0 ? offset : numMonths[ 0 ] * numMonths[ 1 ] ), 1 ) );\n\n\t\tif ( offset < 0 ) {\n\t\t\tdate.setDate( this._getDaysInMonth( date.getFullYear(), date.getMonth() ) );\n\t\t}\n\t\treturn this._isInRange( inst, date );\n\t},\n\n\t/* Is the given date in the accepted range? */\n\t_isInRange: function( inst, date ) {\n\t\tvar yearSplit, currentYear,\n\t\t\tminDate = this._getMinMaxDate( inst, \"min\" ),\n\t\t\tmaxDate = this._getMinMaxDate( inst, \"max\" ),\n\t\t\tminYear = null,\n\t\t\tmaxYear = null,\n\t\t\tyears = this._get( inst, \"yearRange\" );\n\t\t\tif ( years ) {\n\t\t\t\tyearSplit = years.split( \":\" );\n\t\t\t\tcurrentYear = new Date().getFullYear();\n\t\t\t\tminYear = parseInt( yearSplit[ 0 ], 10 );\n\t\t\t\tmaxYear = parseInt( yearSplit[ 1 ], 10 );\n\t\t\t\tif ( yearSplit[ 0 ].match( /[+\\-].*/ ) ) {\n\t\t\t\t\tminYear += currentYear;\n\t\t\t\t}\n\t\t\t\tif ( yearSplit[ 1 ].match( /[+\\-].*/ ) ) {\n\t\t\t\t\tmaxYear += currentYear;\n\t\t\t\t}\n\t\t\t}\n\n\t\treturn ( ( !minDate || date.getTime() >= minDate.getTime() ) &&\n\t\t\t( !maxDate || date.getTime() <= maxDate.getTime() ) &&\n\t\t\t( !minYear || date.getFullYear() >= minYear ) &&\n\t\t\t( !maxYear || date.getFullYear() <= maxYear ) );\n\t},\n\n\t/* Provide the configuration settings for formatting/parsing. */\n\t_getFormatConfig: function( inst ) {\n\t\tvar shortYearCutoff = this._get( inst, \"shortYearCutoff\" );\n\t\tshortYearCutoff = ( typeof shortYearCutoff !== \"string\" ? shortYearCutoff :\n\t\t\tnew Date().getFullYear() % 100 + parseInt( shortYearCutoff, 10 ) );\n\t\treturn { shortYearCutoff: shortYearCutoff,\n\t\t\tdayNamesShort: this._get( inst, \"dayNamesShort\" ), dayNames: this._get( inst, \"dayNames\" ),\n\t\t\tmonthNamesShort: this._get( inst, \"monthNamesShort\" ), monthNames: this._get( inst, \"monthNames\" ) };\n\t},\n\n\t/* Format the given date for display. */\n\t_formatDate: function( inst, day, month, year ) {\n\t\tif ( !day ) {\n\t\t\tinst.currentDay = inst.selectedDay;\n\t\t\tinst.currentMonth = inst.selectedMonth;\n\t\t\tinst.currentYear = inst.selectedYear;\n\t\t}\n\t\tvar date = ( day ? ( typeof day === \"object\" ? day :\n\t\t\tthis._daylightSavingAdjust( new Date( year, month, day ) ) ) :\n\t\t\tthis._daylightSavingAdjust( new Date( inst.currentYear, inst.currentMonth, inst.currentDay ) ) );\n\t\treturn this.formatDate( this._get( inst, \"dateFormat\" ), date, this._getFormatConfig( inst ) );\n\t}\n} );\n\n/*\n * Bind hover events for datepicker elements.\n * Done via delegate so the binding only occurs once in the lifetime of the parent div.\n * Global datepicker_instActive, set by _updateDatepicker allows the handlers to find their way back to the active picker.\n */\nfunction datepicker_bindHover( dpDiv ) {\n\tvar selector = \"button, .ui-datepicker-prev, .ui-datepicker-next, .ui-datepicker-calendar td a\";\n\treturn dpDiv.on( \"mouseout\", selector, function() {\n\t\t\t$( this ).removeClass( \"ui-state-hover\" );\n\t\t\tif ( this.className.indexOf( \"ui-datepicker-prev\" ) !== -1 ) {\n\t\t\t\t$( this ).removeClass( \"ui-datepicker-prev-hover\" );\n\t\t\t}\n\t\t\tif ( this.className.indexOf( \"ui-datepicker-next\" ) !== -1 ) {\n\t\t\t\t$( this ).removeClass( \"ui-datepicker-next-hover\" );\n\t\t\t}\n\t\t} )\n\t\t.on( \"mouseover\", selector, datepicker_handleMouseover );\n}\n\nfunction datepicker_handleMouseover() {\n\tif ( !$.datepicker._isDisabledDatepicker( datepicker_instActive.inline ? datepicker_instActive.dpDiv.parent()[ 0 ] : datepicker_instActive.input[ 0 ] ) ) {\n\t\t$( this ).parents( \".ui-datepicker-calendar\" ).find( \"a\" ).removeClass( \"ui-state-hover\" );\n\t\t$( this ).addClass( \"ui-state-hover\" );\n\t\tif ( this.className.indexOf( \"ui-datepicker-prev\" ) !== -1 ) {\n\t\t\t$( this ).addClass( \"ui-datepicker-prev-hover\" );\n\t\t}\n\t\tif ( this.className.indexOf( \"ui-datepicker-next\" ) !== -1 ) {\n\t\t\t$( this ).addClass( \"ui-datepicker-next-hover\" );\n\t\t}\n\t}\n}\n\n/* jQuery extend now ignores nulls! */\nfunction datepicker_extendRemove( target, props ) {\n\t$.extend( target, props );\n\tfor ( var name in props ) {\n\t\tif ( props[ name ] == null ) {\n\t\t\ttarget[ name ] = props[ name ];\n\t\t}\n\t}\n\treturn target;\n}\n\n/* Invoke the datepicker functionality.\n   @param  options  string - a command, optionally followed by additional parameters or\n\t\t\t\t\tObject - settings for attaching new datepicker functionality\n   @return  jQuery object */\n$.fn.datepicker = function( options ) {\n\n\t/* Verify an empty collection wasn't passed - Fixes #6976 */\n\tif ( !this.length ) {\n\t\treturn this;\n\t}\n\n\t/* Initialise the date picker. */\n\tif ( !$.datepicker.initialized ) {\n\t\t$( document ).on( \"mousedown\", $.datepicker._checkExternalClick );\n\t\t$.datepicker.initialized = true;\n\t}\n\n\t/* Append datepicker main container to body if not exist. */\n\tif ( $( \"#\" + $.datepicker._mainDivId ).length === 0 ) {\n\t\t$( \"body\" ).append( $.datepicker.dpDiv );\n\t}\n\n\tvar otherArgs = Array.prototype.slice.call( arguments, 1 );\n\tif ( typeof options === \"string\" && ( options === \"isDisabled\" || options === \"getDate\" || options === \"widget\" ) ) {\n\t\treturn $.datepicker[ \"_\" + options + \"Datepicker\" ].\n\t\t\tapply( $.datepicker, [ this[ 0 ] ].concat( otherArgs ) );\n\t}\n\tif ( options === \"option\" && arguments.length === 2 && typeof arguments[ 1 ] === \"string\" ) {\n\t\treturn $.datepicker[ \"_\" + options + \"Datepicker\" ].\n\t\t\tapply( $.datepicker, [ this[ 0 ] ].concat( otherArgs ) );\n\t}\n\treturn this.each( function() {\n\t\tif ( typeof options === \"string\" ) {\n\t\t\t$.datepicker[ \"_\" + options + \"Datepicker\" ]\n\t\t\t\t.apply( $.datepicker, [ this ].concat( otherArgs ) );\n\t\t} else {\n\t\t\t$.datepicker._attachDatepicker( this, options );\n\t\t}\n\t} );\n};\n\n$.datepicker = new Datepicker(); // singleton instance\n$.datepicker.initialized = false;\n$.datepicker.uuid = new Date().getTime();\n$.datepicker.version = \"1.13.1\";\n\nreturn $.datepicker;\n\n} );\n","jquery/ui-modules/widgets/dialog.js":"/*!\n * jQuery UI Dialog 1.13.1\n * http://jqueryui.com\n *\n * Copyright jQuery Foundation and other contributors\n * Released under the MIT license.\n * http://jquery.org/license\n */\n\n//>>label: Dialog\n//>>group: Widgets\n//>>description: Displays customizable dialog windows.\n//>>docs: http://api.jqueryui.com/dialog/\n//>>demos: http://jqueryui.com/dialog/\n//>>css.structure: ../../themes/base/core.css\n//>>css.structure: ../../themes/base/dialog.css\n//>>css.theme: ../../themes/base/theme.css\n\n( function( factory ) {\n\t\"use strict\";\n\n\tif ( typeof define === \"function\" && define.amd ) {\n\n\t\t// AMD. Register as an anonymous module.\n\t\tdefine( [\n\t\t\t\"jquery\",\n\t\t\t\"./button\",\n\t\t\t\"./draggable\",\n\t\t\t\"./mouse\",\n\t\t\t\"./resizable\",\n\t\t\t\"../focusable\",\n\t\t\t\"../keycode\",\n\t\t\t\"../position\",\n\t\t\t\"../safe-active-element\",\n\t\t\t\"../safe-blur\",\n\t\t\t\"../tabbable\",\n\t\t\t\"../unique-id\",\n\t\t\t\"../version\",\n\t\t\t\"../widget\"\n\t\t], factory );\n\t} else {\n\n\t\t// Browser globals\n\t\tfactory( jQuery );\n\t}\n} )( function( $ ) {\n\"use strict\";\n\n$.widget( \"ui.dialog\", {\n\tversion: \"1.13.1\",\n\toptions: {\n\t\tappendTo: \"body\",\n\t\tautoOpen: true,\n\t\tbuttons: [],\n\t\tclasses: {\n\t\t\t\"ui-dialog\": \"ui-corner-all\",\n\t\t\t\"ui-dialog-titlebar\": \"ui-corner-all\"\n\t\t},\n\t\tcloseOnEscape: true,\n\t\tcloseText: \"Close\",\n\t\tdraggable: true,\n\t\thide: null,\n\t\theight: \"auto\",\n\t\tmaxHeight: null,\n\t\tmaxWidth: null,\n\t\tminHeight: 150,\n\t\tminWidth: 150,\n\t\tmodal: false,\n\t\tposition: {\n\t\t\tmy: \"center\",\n\t\t\tat: \"center\",\n\t\t\tof: window,\n\t\t\tcollision: \"fit\",\n\n\t\t\t// Ensure the titlebar is always visible\n\t\t\tusing: function( pos ) {\n\t\t\t\tvar topOffset = $( this ).css( pos ).offset().top;\n\t\t\t\tif ( topOffset < 0 ) {\n\t\t\t\t\t$( this ).css( \"top\", pos.top - topOffset );\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\tresizable: true,\n\t\tshow: null,\n\t\ttitle: null,\n\t\twidth: 300,\n\n\t\t// Callbacks\n\t\tbeforeClose: null,\n\t\tclose: null,\n\t\tdrag: null,\n\t\tdragStart: null,\n\t\tdragStop: null,\n\t\tfocus: null,\n\t\topen: null,\n\t\tresize: null,\n\t\tresizeStart: null,\n\t\tresizeStop: null\n\t},\n\n\tsizeRelatedOptions: {\n\t\tbuttons: true,\n\t\theight: true,\n\t\tmaxHeight: true,\n\t\tmaxWidth: true,\n\t\tminHeight: true,\n\t\tminWidth: true,\n\t\twidth: true\n\t},\n\n\tresizableRelatedOptions: {\n\t\tmaxHeight: true,\n\t\tmaxWidth: true,\n\t\tminHeight: true,\n\t\tminWidth: true\n\t},\n\n\t_create: function() {\n\t\tthis.originalCss = {\n\t\t\tdisplay: this.element[ 0 ].style.display,\n\t\t\twidth: this.element[ 0 ].style.width,\n\t\t\tminHeight: this.element[ 0 ].style.minHeight,\n\t\t\tmaxHeight: this.element[ 0 ].style.maxHeight,\n\t\t\theight: this.element[ 0 ].style.height\n\t\t};\n\t\tthis.originalPosition = {\n\t\t\tparent: this.element.parent(),\n\t\t\tindex: this.element.parent().children().index( this.element )\n\t\t};\n\t\tthis.originalTitle = this.element.attr( \"title\" );\n\t\tif ( this.options.title == null && this.originalTitle != null ) {\n\t\t\tthis.options.title = this.originalTitle;\n\t\t}\n\n\t\t// Dialogs can't be disabled\n\t\tif ( this.options.disabled ) {\n\t\t\tthis.options.disabled = false;\n\t\t}\n\n\t\tthis._createWrapper();\n\n\t\tthis.element\n\t\t\t.show()\n\t\t\t.removeAttr( \"title\" )\n\t\t\t.appendTo( this.uiDialog );\n\n\t\tthis._addClass( \"ui-dialog-content\", \"ui-widget-content\" );\n\n\t\tthis._createTitlebar();\n\t\tthis._createButtonPane();\n\n\t\tif ( this.options.draggable && $.fn.draggable ) {\n\t\t\tthis._makeDraggable();\n\t\t}\n\t\tif ( this.options.resizable && $.fn.resizable ) {\n\t\t\tthis._makeResizable();\n\t\t}\n\n\t\tthis._isOpen = false;\n\n\t\tthis._trackFocus();\n\t},\n\n\t_init: function() {\n\t\tif ( this.options.autoOpen ) {\n\t\t\tthis.open();\n\t\t}\n\t},\n\n\t_appendTo: function() {\n\t\tvar element = this.options.appendTo;\n\t\tif ( element && ( element.jquery || element.nodeType ) ) {\n\t\t\treturn $( element );\n\t\t}\n\t\treturn this.document.find( element || \"body\" ).eq( 0 );\n\t},\n\n\t_destroy: function() {\n\t\tvar next,\n\t\t\toriginalPosition = this.originalPosition;\n\n\t\tthis._untrackInstance();\n\t\tthis._destroyOverlay();\n\n\t\tthis.element\n\t\t\t.removeUniqueId()\n\t\t\t.css( this.originalCss )\n\n\t\t\t// Without detaching first, the following becomes really slow\n\t\t\t.detach();\n\n\t\tthis.uiDialog.remove();\n\n\t\tif ( this.originalTitle ) {\n\t\t\tthis.element.attr( \"title\", this.originalTitle );\n\t\t}\n\n\t\tnext = originalPosition.parent.children().eq( originalPosition.index );\n\n\t\t// Don't try to place the dialog next to itself (#8613)\n\t\tif ( next.length && next[ 0 ] !== this.element[ 0 ] ) {\n\t\t\tnext.before( this.element );\n\t\t} else {\n\t\t\toriginalPosition.parent.append( this.element );\n\t\t}\n\t},\n\n\twidget: function() {\n\t\treturn this.uiDialog;\n\t},\n\n\tdisable: $.noop,\n\tenable: $.noop,\n\n\tclose: function( event ) {\n\t\tvar that = this;\n\n\t\tif ( !this._isOpen || this._trigger( \"beforeClose\", event ) === false ) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis._isOpen = false;\n\t\tthis._focusedElement = null;\n\t\tthis._destroyOverlay();\n\t\tthis._untrackInstance();\n\n\t\tif ( !this.opener.filter( \":focusable\" ).trigger( \"focus\" ).length ) {\n\n\t\t\t// Hiding a focused element doesn't trigger blur in WebKit\n\t\t\t// so in case we have nothing to focus on, explicitly blur the active element\n\t\t\t// https://bugs.webkit.org/show_bug.cgi?id=47182\n\t\t\t$.ui.safeBlur( $.ui.safeActiveElement( this.document[ 0 ] ) );\n\t\t}\n\n\t\tthis._hide( this.uiDialog, this.options.hide, function() {\n\t\t\tthat._trigger( \"close\", event );\n\t\t} );\n\t},\n\n\tisOpen: function() {\n\t\treturn this._isOpen;\n\t},\n\n\tmoveToTop: function() {\n\t\tthis._moveToTop();\n\t},\n\n\t_moveToTop: function( event, silent ) {\n\t\tvar moved = false,\n\t\t\tzIndices = this.uiDialog.siblings( \".ui-front:visible\" ).map( function() {\n\t\t\t\treturn +$( this ).css( \"z-index\" );\n\t\t\t} ).get(),\n\t\t\tzIndexMax = Math.max.apply( null, zIndices );\n\n\t\tif ( zIndexMax >= +this.uiDialog.css( \"z-index\" ) ) {\n\t\t\tthis.uiDialog.css( \"z-index\", zIndexMax + 1 );\n\t\t\tmoved = true;\n\t\t}\n\n\t\tif ( moved && !silent ) {\n\t\t\tthis._trigger( \"focus\", event );\n\t\t}\n\t\treturn moved;\n\t},\n\n\topen: function() {\n\t\tvar that = this;\n\t\tif ( this._isOpen ) {\n\t\t\tif ( this._moveToTop() ) {\n\t\t\t\tthis._focusTabbable();\n\t\t\t}\n\t\t\treturn;\n\t\t}\n\n\t\tthis._isOpen = true;\n\t\tthis.opener = $( $.ui.safeActiveElement( this.document[ 0 ] ) );\n\n\t\tthis._size();\n\t\tthis._position();\n\t\tthis._createOverlay();\n\t\tthis._moveToTop( null, true );\n\n\t\t// Ensure the overlay is moved to the top with the dialog, but only when\n\t\t// opening. The overlay shouldn't move after the dialog is open so that\n\t\t// modeless dialogs opened after the modal dialog stack properly.\n\t\tif ( this.overlay ) {\n\t\t\tthis.overlay.css( \"z-index\", this.uiDialog.css( \"z-index\" ) - 1 );\n\t\t}\n\n\t\tthis._show( this.uiDialog, this.options.show, function() {\n\t\t\tthat._focusTabbable();\n\t\t\tthat._trigger( \"focus\" );\n\t\t} );\n\n\t\t// Track the dialog immediately upon opening in case a focus event\n\t\t// somehow occurs outside of the dialog before an element inside the\n\t\t// dialog is focused (#10152)\n\t\tthis._makeFocusTarget();\n\n\t\tthis._trigger( \"open\" );\n\t},\n\n\t_focusTabbable: function() {\n\n\t\t// Set focus to the first match:\n\t\t// 1. An element that was focused previously\n\t\t// 2. First element inside the dialog matching [autofocus]\n\t\t// 3. Tabbable element inside the content element\n\t\t// 4. Tabbable element inside the buttonpane\n\t\t// 5. The close button\n\t\t// 6. The dialog itself\n\t\tvar hasFocus = this._focusedElement;\n\t\tif ( !hasFocus ) {\n\t\t\thasFocus = this.element.find( \"[autofocus]\" );\n\t\t}\n\t\tif ( !hasFocus.length ) {\n\t\t\thasFocus = this.element.find( \":tabbable\" );\n\t\t}\n\t\tif ( !hasFocus.length ) {\n\t\t\thasFocus = this.uiDialogButtonPane.find( \":tabbable\" );\n\t\t}\n\t\tif ( !hasFocus.length ) {\n\t\t\thasFocus = this.uiDialogTitlebarClose.filter( \":tabbable\" );\n\t\t}\n\t\tif ( !hasFocus.length ) {\n\t\t\thasFocus = this.uiDialog;\n\t\t}\n\t\thasFocus.eq( 0 ).trigger( \"focus\" );\n\t},\n\n\t_restoreTabbableFocus: function() {\n\t\tvar activeElement = $.ui.safeActiveElement( this.document[ 0 ] ),\n\t\t\tisActive = this.uiDialog[ 0 ] === activeElement ||\n\t\t\t\t$.contains( this.uiDialog[ 0 ], activeElement );\n\t\tif ( !isActive ) {\n\t\t\tthis._focusTabbable();\n\t\t}\n\t},\n\n\t_keepFocus: function( event ) {\n\t\tevent.preventDefault();\n\t\tthis._restoreTabbableFocus();\n\n\t\t// support: IE\n\t\t// IE <= 8 doesn't prevent moving focus even with event.preventDefault()\n\t\t// so we check again later\n\t\tthis._delay( this._restoreTabbableFocus );\n\t},\n\n\t_createWrapper: function() {\n\t\tthis.uiDialog = $( \"<div>\" )\n\t\t\t.hide()\n\t\t\t.attr( {\n\n\t\t\t\t// Setting tabIndex makes the div focusable\n\t\t\t\ttabIndex: -1,\n\t\t\t\trole: \"dialog\"\n\t\t\t} )\n\t\t\t.appendTo( this._appendTo() );\n\n\t\tthis._addClass( this.uiDialog, \"ui-dialog\", \"ui-widget ui-widget-content ui-front\" );\n\t\tthis._on( this.uiDialog, {\n\t\t\tkeydown: function( event ) {\n\t\t\t\tif ( this.options.closeOnEscape && !event.isDefaultPrevented() && event.keyCode &&\n\t\t\t\t\t\tevent.keyCode === $.ui.keyCode.ESCAPE ) {\n\t\t\t\t\tevent.preventDefault();\n\t\t\t\t\tthis.close( event );\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\t// Prevent tabbing out of dialogs\n\t\t\t\tif ( event.keyCode !== $.ui.keyCode.TAB || event.isDefaultPrevented() ) {\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\tvar tabbables = this.uiDialog.find( \":tabbable\" ),\n\t\t\t\t\tfirst = tabbables.first(),\n\t\t\t\t\tlast = tabbables.last();\n\n\t\t\t\tif ( ( event.target === last[ 0 ] || event.target === this.uiDialog[ 0 ] ) &&\n\t\t\t\t\t\t!event.shiftKey ) {\n\t\t\t\t\tthis._delay( fu