<?php
/**
 * @author Suraj Wasnik (smwasnik0126@gmail.com)
 * @copyright Copyright (c) 2023
 * @package Fudugo_GraphQL
 */

namespace Fudugo\GraphQL\Model\Resolver;

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Exception\GraphQlNoSuchEntityException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

/**
 * Web Settings resolver
 */
class WebSettingsResolver implements ResolverInterface
{

    protected $_appEmulation;
    protected $_storeManager;
    protected $_assetRepo;
    protected $_logo;
    protected $_scopeConfigInterface;

    public function __construct(
        \Magento\Catalog\Model\Product $productRepository,
        \Magento\Framework\Api\SearchCriteriaBuilder $searchCriteriaBuilder,
        \Magento\Store\Model\App\Emulation $appEmulation,
        \Magento\Store\Model\StoreManagerInterface $storemanager,
        \Magento\Framework\View\Asset\Repository $assetRepo,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfigInterface,
        \Magento\Theme\Block\Html\Header\Logo $logo
    ) {
        $this->productRepository = $productRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->_appEmulation = $appEmulation;
        $this->_storeManager = $storemanager;
        $this->_assetRepo = $assetRepo;
        $this->_logo = $logo;
        $this->_scopeConfigInterface = $scopeConfigInterface;
    }

    /**
     * @inheritdoc
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ) {
        $webSettings = $this->getWebSettings();
        return $webSettings;
    }

    /**
     * @return array
     * @throws GraphQlNoSuchEntityException
     */
    private function getWebSettings(): array
    {
        try {
            $webSettings = [];
            $store = $this->_storeManager->getStore();
            $this->_appEmulation->startEnvironmentEmulation($this->_storeManager->getStore()->getId(), \Magento\Framework\App\Area::AREA_FRONTEND, true);

                        
            if($this->_scopeConfigInterface->getValue('design/header/logo_src', \Magento\Store\Model\ScopeInterface::SCOPE_STORE)){
                $base_path = $this ->_storeManager-> getStore()->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA );
                $webSettings['logo'] = $base_path.'logo/'.$this->_scopeConfigInterface->getValue('design/header/logo_src', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
                $webSettings['phone'] = $this->_scopeConfigInterface->getValue('general/store_information/phone', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);
                $webSettings['email'] = $this->_scopeConfigInterface->getValue('trans_email/ident_sales/email', \Magento\Store\Model\ScopeInterface::SCOPE_STORE);

            } else {
                $webSettings['logo'] = $this->_logo->getLogoSrc();
            }
            $this->_appEmulation->stopEnvironmentEmulation();

        } catch (NoSuchEntityException $e) {
            throw new GraphQlNoSuchEntityException(__($e->getMessage()), $e);
        }
        return $webSettings;
    }
}