<?php
/**
 * @author Suraj Wasnik (smwasnik0126@gmail.com)
 * @copyright Copyright (c) 2023
 * @package Fudugo_GraphQL
 */

namespace Fudugo\GraphQL\Model\Resolver;

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Exception\GraphQlNoSuchEntityException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

/**
 * Product collection resolver
 */
class ProductsByRatingResolver implements ResolverInterface
{

    protected $_storeManager;
    protected $_assetRepo;
    protected $_bestSellersCollectionFactory;
    protected $_productCollectionFactory;
    protected $objectmanager;
    protected $_productRepositoryFactory;

    public function __construct(
        \Magento\Catalog\Model\Product $productRepository,
        \Magento\Framework\Api\SearchCriteriaBuilder $searchCriteriaBuilder,
        \Magento\Store\Model\StoreManagerInterface $storemanager,
        \Magento\Framework\View\Asset\Repository $assetRepo,
        \Magento\Sales\Model\ResourceModel\Report\Bestsellers\CollectionFactory $bestSellersCollectionFactory,
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory,
        \Magento\Framework\ObjectManagerInterface $objectmanager,
        \Magento\Catalog\Api\ProductRepositoryInterfaceFactory $productRepositoryFactory
    ) {
        $this->productRepository = $productRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->_storeManager = $storemanager;
        $this->_assetRepo = $assetRepo;
        $this->_bestSellersCollectionFactory = $bestSellersCollectionFactory;
        $this->_productCollectionFactory = $productCollectionFactory;
        $this->objectManager = $objectmanager;
        $this->_productRepositoryFactory = $productRepositoryFactory;
    }

    /**
     * @inheritdoc
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ) {
        $productsData = $this->getProductsData();
        return $productsData;
    }

    /**
     * @return array
     * @throws GraphQlNoSuchEntityException
     */
    private function getProductsData(): array
    {
        $productRecord['items'] = [];
        try {

            $store = $this->_storeManager->getStore();
            
            $productIds = [];
            
            $collection = $this->objectManager->create('Magento\Catalog\Model\ResourceModel\Product\Collection');

            $collection->addAttributeToSelect('*');

            $collection->getSelect()->joinLeft(array('rova'=> 'rating_option_vote_aggregated'),'e.entity_id =rova.entity_pk_value', array("percent" => 'percent'))->group('e.entity_id');
 
            $collection->getSelect()->where('rova.percent=60')->orWhere('rova.percent=80')->orWhere('rova.percent=100');


            foreach ($collection as $product) {
                $productIds[] = $product->getEntityId();
            }

            $products = $this->_productCollectionFactory->create()->addIdFilter($productIds);
            $products->addMinimalPrice()
                ->addFinalPrice()
                ->addTaxPercents()
                ->addAttributeToSelect('*')->setPageSize(12); 


            foreach($products as $product) {

                if($product->getImage()=='no_selection'){
                    $pImage=null;
                }else{
                    $pImage=$product->getImage();
                }
                $productId = $product->getId();
                $productRecord['items'][$productId]['id']    = $product['entity_id'];
                $productRecord['items'][$productId]['sku']    = $product->getSku();
                $productRecord['items'][$productId]['name']   = $product->getName();
                $productRecord['items'][$productId]['price']  = $product->getPrice();
                $productRecord['items'][$productId]['image']  = $product->getImage() ? $store->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA) . 'catalog/product' .$product->getImage() : '';
                //$productRecord['items'][$productId]['image']  = $pImage;
            }

             
        } catch (NoSuchEntityException $e) {
            throw new GraphQlNoSuchEntityException(__($e->getMessage()), $e);
        }
        return $productRecord;
    }
}