<?php
/**
 * @author Suraj Wasnik (smwasnik0126@gmail.com)
 * @copyright Copyright (c) 2023
 * @package Fudugo_GraphQL
 */

namespace Fudugo\GraphQL\Model\Resolver;

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Exception\GraphQlNoSuchEntityException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

/**
 * Product collection resolver
 */
class ProductsAttributesResolver implements ResolverInterface
{

    protected $_storeManager;
    protected $_assetRepo;
    protected $_bestSellersCollectionFactory;
    protected $_productCollectionFactory;
    protected $_productRepository;
    protected $productAttributeCollectionFactory;
    protected $eavConfig;


    public function __construct(
        \Magento\Catalog\Model\ResourceModel\Product\Attribute\CollectionFactory $productAttributeCollectionFactory,
        \Magento\Eav\Model\Config $eavConfig
         
    ) {
        $this->productAttributeCollectionFactory = $productAttributeCollectionFactory;
        $this->eavConfig = $eavConfig;
    }

    /**
     * @inheritdoc
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ) {
        $productsData = $this->getProductsData();
        return $productsData;
    }

    /**
     * @return array
     * @throws GraphQlNoSuchEntityException
     */
    private function getProductsData(): array
    {
        $attributesData['items'] = [];
        try {

            /** @var \Magento\Catalog\Model\ResourceModel\Product\Attribute\Collection $productAttributes */

            $productAttributes = $this->productAttributeCollectionFactory->create();
            $productAttributes->addFieldToFilter(
                ['is_filterable', 'is_filterable_in_search'],
                [[1, 2], 1]
            );

            //print_r($productAttributes->getData()); die();

            foreach ($productAttributes->getData() as $key => $value) {
                $attribute = $this->eavConfig->getAttribute('catalog_product', $value['attribute_code']);
                $options = $attribute->getSource()->getAllOptions();

                $attributeItems = $this->processArray($options);
                if(!empty($attributeItems)){

                    $attributesData['items'][$key]['entity_type_id'] = $value['entity_type_id'];
                    $attributesData['items'][$key]['attribute_code'] = $value['attribute_code'];
                    $attributesData['items'][$key]['frontend_label'] = $value['frontend_label'];
                    $attributesData['items'][$key]['frontend_input'] = $value['frontend_input'];

                    foreach ($attributeItems as $aKey => $value) {
                         
                        $attributesData['items'][$key]['attribute_items'][$aKey]['value'] = $value['value'];
                        $attributesData['items'][$key]['attribute_items'][$aKey]['label'] = $value['label'];
                    }
                }

            }

            //print_r($attributesData); die();

        } catch (NoSuchEntityException $e) {
            throw new GraphQlNoSuchEntityException(__($e->getMessage()), $e);
        }
        return $attributesData;
    }

    private function processArray($data): array
    {
        $attr = array();
        if($data){
            foreach ($data as $key => $value) {
                if($value['label']!='' && $value['value']!='') {
                    $attr[] = array('label' => $value['label'], 'value' => $value['value']);
                }
            }
        }
        return $attr;
    }
}