<?php
/**
 * @author Suraj Wasnik (smwasnik0126@gmail.com)
 * @copyright Copyright (c) 2023
 * @package Fudugo_GraphQL
 */

namespace Fudugo\GraphQL\Model\Resolver;

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Exception\GraphQlNoSuchEntityException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

/**
 * Product collection resolver
 */
class ProductPricerangeResolver implements ResolverInterface
{

    protected $_productCollectionFactory;

    public function __construct( 
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productFactory
    ) {
        $this->_productCollectionFactory = $productFactory;
    }

    /**
     * @inheritdoc
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ) {
        $priceRangeData = $this->getPriceRangeData();
        return $priceRangeData;
    }

    /**
     * @return array
     * @throws GraphQlNoSuchEntityException
     */
    private function getPriceRangeData(): array
    {
        $data=[];
        try {

            $productCollection = $this->_productCollectionFactory->create();
            $productCollection->addFinalPrice();

            //print_r($productCollection->getData());
            
            $maxPrice = $productCollection->getMaxPrice();
            $minPrice = $productCollection->getMinPrice();
            $data['min_price'] = $minPrice;
            $data['max_price'] = $maxPrice;
             
        } catch (NoSuchEntityException $e) {
            throw new GraphQlNoSuchEntityException(__($e->getMessage()), $e);
        }
        return $data;
    }
}