<?php
/**
 * @author Suraj Wasnik (smwasnik0126@gmail.com)
 * @copyright Copyright (c) 2023
 * @package Fudugo_GraphQL
 */

namespace Fudugo\GraphQL\Model\Resolver;


use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Exception\GraphQlNoSuchEntityException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

/**
 * Banner resolver
 */
class HomePageContentsResolver implements ResolverInterface
{

    protected $_appEmulation;
    protected $_storeManager;
    protected $_assetRepo;
    protected $_logo;
    protected $_scopeConfigInterface;
    public $blogContents;
    //public $configImage;

    public function __construct(
        \Magento\Framework\Api\SearchCriteriaBuilder $searchCriteriaBuilder,
        \Magento\Store\Model\App\Emulation $appEmulation,
        \Magento\Store\Model\StoreManagerInterface $storemanager,
        \Magento\Framework\View\Asset\Repository $assetRepo,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfigInterface,
        \Mageplaza\Blog\Helper\Data $blogContents
    ) { 
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->_appEmulation = $appEmulation;
        $this->_storeManager = $storemanager;
        $this->_assetRepo = $assetRepo; 
        $this->_scopeConfigInterface = $scopeConfigInterface;
        $this->blogContents = $blogContents; 

    }

    /**
     * @inheritdoc
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ) {
        $homeData = $this->getHomePageContents();
        return $homeData;
    }

    /**
     * @return array
     * @throws GraphQlNoSuchEntityException
     */
    private function getHomePageContents(): array
    {
        try {  
            $homeData = []; 

            $blogData = $this->blogContents->getPostCollection();

            //print_r($blogData->getData()); die();
            $newsletter_txt=''; 
            $shipping_content=''; 
            $trade_txt=''; 
            $downgradeTxt='';
            $paymentBadges = '';
            $footerLogo='';
            $need_to_talk='';

            foreach ($blogData->getData() as $key => $blog):

                if($blog['post_id']==1){ 
                    $trade_txt= $blog['short_description'];
                }
                if($blog['post_id']==2){ 
                    $shipping_content= $blog['post_content'];
                }
                if($blog['post_id']==3){ 
                    $newsletter_txt= $blog['short_description'];
                }
                if($blog['post_id']==4){ 
                    $downgradeTxt= $blog['short_description'];
                }
                if($blog['post_id']==5){ 
                    $paymentBadges= $blog['post_content'];
                }
                if($blog['post_id']==6){ 
                    $footerLogo= $blog['post_content'];
                }
                if($blog['post_id']==7){ 
                    $need_to_talk= $blog['post_content'];
                }
                
                 
            endforeach;
            $homeData['blog_id'] = 22;
            $homeData['trade_txt'] = $trade_txt;
            $homeData['shipping_content']= $shipping_content;
            $homeData['newsletter_txt'] = $newsletter_txt;
            $homeData['downgrade_offer'] = $downgradeTxt;
            $homeData['payment_badges'] = $paymentBadges;
            $homeData['footer_logo'] = $footerLogo;
            $homeData['need_to_talk'] = $need_to_talk;

             
            // print_r($homeData); die();

        } catch (NoSuchEntityException $e) {
            throw new GraphQlNoSuchEntityException(__($e->getMessage()), $e);
        }
        return $homeData;
    }
}