<?php
/**
 * @author Suraj Wasnik (smwasnik0126@gmail.com)
 * @copyright Copyright (c) 2023
 * @package Fudugo_GraphQL
 */

namespace Fudugo\GraphQL\Model\Resolver;

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Exception\GraphQlNoSuchEntityException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

/**
 * Product collection resolver
 */
class BestsellerResolver implements ResolverInterface
{

    protected $_storeManager;
    protected $_assetRepo;
    protected $_bestSellersCollectionFactory;
    protected $_productCollectionFactory;

    public function __construct(
        \Magento\Catalog\Model\Product $productRepository,
        \Magento\Framework\Api\SearchCriteriaBuilder $searchCriteriaBuilder,
        \Magento\Store\Model\StoreManagerInterface $storemanager,
        \Magento\Framework\View\Asset\Repository $assetRepo,
        \Magento\Sales\Model\ResourceModel\Report\Bestsellers\CollectionFactory $bestSellersCollectionFactory,
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory
    ) {
        $this->productRepository = $productRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->_storeManager = $storemanager;
        $this->_assetRepo = $assetRepo;
        $this->_bestSellersCollectionFactory = $bestSellersCollectionFactory;
        $this->_productCollectionFactory = $productCollectionFactory;
    }

    /**
     * @inheritdoc
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ) {
        $productsData = $this->getProductsData();
        return $productsData;
    }

    /**
     * @return array
     * @throws GraphQlNoSuchEntityException
     */
    private function getProductsData(): array
    {
        try {

            $store = $this->_storeManager->getStore();
            $productIds = [];
            $bestSellers = $this->_bestSellersCollectionFactory->create()
                ->setPeriod('month');

            foreach ($bestSellers as $product) {
                $productIds[] = $product->getProductId();
            }
            $products = $this->_productCollectionFactory->create()->addIdFilter($productIds);
            $products->addMinimalPrice()
                ->addFinalPrice()
                ->addTaxPercents()
                ->addAttributeToSelect('*')->setPageSize(12);

            $productRecord['allProducts'] = [];            
            foreach($products as $product) {
                $productId = $product->getId();
                $productRecord['allProducts'][$productId]['sku']    = $product->getSku();
                $productRecord['allProducts'][$productId]['name']   = $product->getName();
                $productRecord['allProducts'][$productId]['price']  = $product->getPrice();
                $productRecord['allProducts'][$productId]['image']  = $product->getImage() ? $store->getBaseUrl(\Magento\Framework\UrlInterface::URL_TYPE_MEDIA) . 'catalog/product' .$product->getImage() : '';
            }
        } catch (NoSuchEntityException $e) {
            throw new GraphQlNoSuchEntityException(__($e->getMessage()), $e);
        }
        return $productRecord;
    }
}