<?php
/**
 * @author Suraj Wasnik (smwasnik0126@gmail.com)
 * @copyright Copyright (c) 2023
 * @package Fudugo_GraphQL
 */

namespace Fudugo\GraphQL\Model\Resolver;


use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Exception\GraphQlNoSuchEntityException;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

/**
 * Banner resolver
 */
class BannersResolver implements ResolverInterface
{

    protected $_appEmulation;
    protected $_storeManager;
    protected $_assetRepo;
    protected $_logo;
    protected $_scopeConfigInterface;
    public $bannerSlider;
    public $configImage;

    public function __construct(
        \Magento\Framework\Api\SearchCriteriaBuilder $searchCriteriaBuilder,
        \Magento\Store\Model\App\Emulation $appEmulation,
        \Magento\Store\Model\StoreManagerInterface $storemanager,
        \Magento\Framework\View\Asset\Repository $assetRepo,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfigInterface,
        \Mageplaza\BannerSlider\Helper\Data $bannerSlider,
        \Mageplaza\BannerSlider\Model\Config\Source\Image $configImage
    ) { 
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->_appEmulation = $appEmulation;
        $this->_storeManager = $storemanager;
        $this->_assetRepo = $assetRepo; 
        $this->_scopeConfigInterface = $scopeConfigInterface;
        $this->bannerSlider = $bannerSlider;
        $this->configImage = $configImage;

    }

    /**
     * @inheritdoc
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ) {
        $homeBanner = $this->getBennerData();
        return $homeBanner;
    }

    /**
     * @return array
     * @throws GraphQlNoSuchEntityException
     */
    private function getBennerData(): array
    {
        try { 
            $sliderId = 1;
            $bannerData =  $this->bannerSlider->getBannerCollection($sliderId); 
            $homeBanner['homebanner'] = []; 

            //print_r($bannerData->getData()); die();
             
            foreach ($bannerData->getData() as $key => $banner):
                
                $homeBanner['homebanner'][$key]['banner_id'] = $banner['banner_id'];
                $homeBanner['homebanner'][$key]['imageurl'] = $this->configImage->getBaseUrl().$banner['image'];
                $homeBanner['homebanner'][$key]['title'] = $banner['title'];
                $homeBanner['homebanner'][$key]['subtitle'] = $banner['subtitle'];
            endforeach;
             

        } catch (NoSuchEntityException $e) {
            throw new GraphQlNoSuchEntityException(__($e->getMessage()), $e);
        }
        return $homeBanner;
    }
}